SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_2025_07_a_open_data_dep01;
COMMENT ON schema bdnb_2025_07_a_open_data_dep01 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."adresse"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "adresse_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" IS 'Table de description des adresses. Les adresses dans la BDNB sont le sous-ensemble des adresses BAN de type `housenumber` (adressage au numéro) et uniquement localisé en France hexagonale et Corse. Des adresses ARCEP viennent compléter les adresses BAN quand ces adresses n''existent pas dans la BAN. Les géolocalisants ponctuels sont au format Lambert-93 (ESPG:2154).';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','adresse','geom_adresse',2154,'POINT',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "numero" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."numero" IS 'Numéro de l''adresse';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "rep" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."rep" IS 'Indice de répétition du numéro de l''adresse';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "type_voie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."type_voie" IS 'Type de voie';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "nom_voie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."nom_voie" IS 'Nom de la voie';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "libelle_adresse" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."libelle_adresse" IS 'Libellé complet de l''adresse';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "code_postal" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."code_postal" IS 'Code postal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "libelle_commune" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."libelle_commune" IS 'Libellé de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse" ADD COLUMN "source" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse"."source" IS 'source de l''adresse BAN ou ARCEP';
COPY "bdnb_2025_07_a_open_data_dep01"."adresse" ("geom_adresse", "cle_interop_adr", "code_departement_insee", "numero", "rep", "type_voie", "nom_voie", "libelle_adresse", "code_postal", "code_commune_insee", "libelle_commune", "source") FROM STDIN;
01010000206A080000F6285C0FECE22941B81E85DB75095941	01001_0400_00130	01	130	\N	Rue	Des Viards	130.0 RUE DES VIARDS 01400 L'Abergement-Clémenciat	01400	01001	L'Abergement-Clémenciat	BAN
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "adresse_metrique_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" IS 'Métriques des adresses. Cette table permet d’identifier le nombre de bâtiments desservis par une même adresse. Elle facilite ainsi la distinction entre :
- les adresses mono-bâtiment,
- les adresses desservant plusieurs bâtiments sur une même unité foncière,
- et les adresses plus problématiques desservant plusieurs unités foncières distinctes.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse_metrique"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse_metrique"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ADD COLUMN "nb_bat_grp" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse_metrique"."nb_bat_grp" IS 'Nombre de bâtiments desservis par l''adresse';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ADD COLUMN "nb_bat_grp_hors_dep" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."adresse_metrique"."nb_bat_grp_hors_dep" IS 'Nombre de bâtiments (hors dépendances) desservis par l''adresse';
COPY "bdnb_2025_07_a_open_data_dep01"."adresse_metrique" ("cle_interop_adr", "code_departement_insee", "nb_bat_grp", "nb_bat_grp_hors_dep") FROM STDIN;
01001_0400_00130	01	1	1
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_construction_adresse_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" IS 'Table de relation entre les adresses postales BAN/Arcep et les entrées de la table [batiment_construction]. 
Cette table détaillée permet de descendre en précision sur les associations entre batiments et adresses, la proximité entre le batiment_construction de la BDNB et les identifiants RNB permet notamment grâce à cette table et rel_batiment_construction_rnb d''associer des adresses au référentiel national des bâtiments.

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `adresse`';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','rel_batiment_construction_adresse','geom_batiment_construction_adresse',2154,'MULTILINESTRING',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "distance_batiment_construction_adresse" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."distance_batiment_construction_adresse" IS 'Distance entre le géolocalisant adresse et la géométrie de bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "fiabilite" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."fiabilite" IS 'Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :

Critères et pondérations :

- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2
- cond_2 : l''adresse est une adresse BAN → +1
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1

Échelle du score :
- Minimum : 0 (aucune condition vérifiée)
- Maximum : 20 (toutes les conditions vérifiées)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ADD COLUMN "adresse_principale" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse"."adresse_principale" IS 'Booléen précisant si l''adresse courante est l''une des adresses principales de la construction ou non. Une relation est taguée comme `principale` si l''adresse qui la compose obtient le score de fiabilité le plus important parmi toutes les adresses desservant une même construction. Il se peut, par conséquent, qu''une construction ait plusieurs adresses principales : toutes celles ayant le score de fiabilité le plus haut pour cette construction.';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" ("geom_batiment_construction_adresse", "batiment_construction_id", "cle_interop_adr", "code_departement_insee", "distance_batiment_construction_adresse", "fiabilite", "adresse_principale") FROM STDIN;
01050000206A08000001000000010200000002000000F6285C0FECE22941B81E85DB75095941F44595DBE4E229410000006074095941	bdnb-bc-MB4V-Z5M4-49KH	01001_0400_00130	01	7	20	1
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_adresse_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" IS 'Table de relation entre les adresses et les groupes de bâtiments. Les relations entre adresses et groupes de bâtiments sont de type n-m complexes :
- une adresse peut desservir plusieurs groupes de bâtiments,
- un groupe de bâtiment peut être desservi par plusieurs adresses (par exemple, plusieurs cages d’escalier).

Cette table constitue un pivot important de la BDNB. Elle permet notamment d’associer des données indexées à l’adresse aux groupes de bâtiments correspondants.

Les associations entre adresses et groupes de bâtiments sont établies à partir :
- d’intersections géométriques,
- de rapprochements entre les adresses de la Base Adresse Nationale (BAN) et les adresses fiscales des bâtiments issus des Fichiers Fonciers

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `adresse`';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','rel_batiment_groupe_adresse','geom_bat_adresse',2154,'MULTILINESTRING',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "origine" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"."origine" IS 'Origine de l''entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d''un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ADD COLUMN "fiabilite" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse"."fiabilite" IS 'Le score de fiabilité d''une relation batiment_groupe avec une adresse est le maximum de la fiabilité des associations adresses batiment construction correspondantes.

Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :

Critères et pondérations :

- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2
- cond_2 : l''adresse est une adresse BAN → +1
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1

Échelle du score :
- Minimum : 0 (aucune condition vérifiée)
- Maximum : 20 (toutes les conditions vérifiées)';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" ("geom_bat_adresse", "batiment_groupe_id", "cle_interop_adr", "code_departement_insee", "origine", "fiabilite") FROM STDIN;
01050000206A08000001000000010200000002000000F6285C0FECE22941B81E85DB75095941F44595DBE4E229410000006074095941	bdnb-bg-111J-YU68-VJ8Z	01001_0400_00130	01	Association Geometrique + Fichiers Fonciers	20
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_construction_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" IS 'Enceinte physique des différentes géométries qui composent le groupe de bâtiments. Ces enceintes sont des géométries 2D extrudées en hauteur.

Les bâtiments constructions proviennent de la BD TOPO de l’IGN et sont retraités par le CSTB, principalement pour les mettre en cohérence avec le découpage parcellaire du cadastre.';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','batiment_construction','geom_cstr',2154,'MULTIPOLYGON',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "batiment_construction_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."code_iris" IS 'Code iris INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "s_geom_cstr" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."s_geom_cstr" IS '(ign) Surface au sol de la géométrie de la construction [m²]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "hauteur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."hauteur" IS '(ign) Hauteur du bâtiment physique [m]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "altitude_sol" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."altitude_sol" IS '(ign) Altitude moynne au pied du bâtiment physique [m]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "fictive_hauteur_cstr" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."fictive_hauteur_cstr" IS '(ign) Variable renvoyant : "vrai" si la hauteur est fictive, "faux" elle correspond à une hauteur réelle';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ADD COLUMN "fictive_geom_cstr" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_construction"."fictive_geom_cstr" IS '(ign) Variable renvoyant : "vrai" si la géométrie est fictive (et la surface au sol n''est pas réelle), "faux" elle correspond à une emprise au sol réelle';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_construction" ("geom_cstr", "batiment_construction_id", "batiment_groupe_id", "code_departement_insee", "code_iris", "code_commune_insee", "s_geom_cstr", "hauteur", "altitude_sol", "fictive_hauteur_cstr", "fictive_geom_cstr") FROM STDIN;
01060000206A080000010000000103000000010000000500000000000000DAE22941000000E07509594133333333D5E229419A9999997509594166666666DAE229410000004074095941CDCCCCCCDEE22941000000807409594100000000DAE22941000000E075095941	bdnb-bc-8JTW-FW8N-QX52	bdnb-bg-111J-YU68-VJ8Z	01	010010000	01001	15	1.9	257.1	0	0
01060000206A080000010000000103000000010000000700000066666666DAE229410000004074095941CDCCCCCCE2E22941666666067209594166666666F2E229419A9999F97209594100000000E5E22941666666867609594100000000DAE22941000000E075095941CDCCCCCCDEE22941000000807409594166666666DAE229410000004074095941	bdnb-bc-MB4V-Z5M4-49KH	bdnb-bg-111J-YU68-VJ8Z	01	010010000	01001	122	1.9	257.1	0	0
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" IS 'Groupes de bâtiments au sens de la BDNB.

Un groupe de bâtiments est composé de 1 à *n* bâtiments fonciers et de 1 à *m* bâtiments constructions.  
Ces entités sont créées pour minimiser *n* et *m*, afin de produire des groupes aussi précis que possible, tout en garantissant une adéquation entre :
- le contenant : enceintes physiques des bâtiments (`batiment_construction`),
- et le contenu : bâtiments fonciers qui documentent usages, surfaces et nombre de locaux.

Un groupe de bâtiments est toujours situé sur une même unité foncière (ensemble de parcelles adjacentes appartenant à un même propriétaire).

Cette entité, qui assure la cohérence entre contenant et contenu, constitue le socle de la BDNB.  
La majorité des informations présentes dans la base sont définies à cette échelle : `batiment_groupe`.';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','batiment_groupe','geom_groupe',2154,'MULTIPOLYGON',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "s_geom_groupe" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."s_geom_groupe" IS 'Surface au sol de la géométrie du bâtiment groupe (geom_groupe)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."code_iris" IS 'Code iris INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "libelle_commune_insee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."libelle_commune_insee" IS '(insee) Libellé de la commune accueillant le groupe de bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "code_epci_insee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."code_epci_insee" IS 'Code de l''EPCI';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ADD COLUMN "contient_fictive_geom_groupe" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe"."contient_fictive_geom_groupe" IS 'Vaut "vrai", si la géométrie du groupe de bâtiment est générée automatiquement et ne représente pas la géométrie du groupe de bâtiment.';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" ("geom_groupe", "batiment_groupe_id", "code_departement_insee", "s_geom_groupe", "code_iris", "code_commune_insee", "libelle_commune_insee", "code_epci_insee", "contient_fictive_geom_groupe") FROM STDIN;
01060000206A080000010000000103000000010000000700000033333333D5E229419A9999997509594100000000DAE22941000000E07509594100000000E5E22941666666867609594166666666F2E229419A9999F972095941CDCCCCCCE2E22941666666067209594166666666DAE22941000000407409594133333333D5E229419A99999975095941	bdnb-bg-111J-YU68-VJ8Z	01	137	010010000	01001	L'Abergement-Clémenciat	200069193	0
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_adresse_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" IS 'Cette table fournit des informations résumées sur le groupe de bâtiments par rapport aux adresses qui y sont rattachées.

On y retrouve le nombre d’adresses associées au groupe de bâtiments, ainsi que l’adresse principale, définie comme celle associée au plus grand nombre de locaux pour ce groupe.

Si vous souhaitez associer des données référencées à l’adresse aux groupes de bâtiments de la BDNB, nous recommandons d’utiliser `rel_batiment_groupe_adresse` afin de prendre en compte l’ensemble des adresses associées au groupe de bâtiments.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "cle_interop_adr_principale_ban" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."cle_interop_adr_principale_ban" IS 'Clé d''interopérabilité de l''adresse principale (issue de la BAN)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "libelle_adr_principale_ban" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."libelle_adr_principale_ban" IS 'Libellé complet de l''adresse principale (issue de la BAN)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "nb_adresse_valid_ban" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."nb_adresse_valid_ban" IS 'Nombre d''adresses valides différentes provenant de la BAN qui desservent le groupe de bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "fiabilite_cr_adr_niv_1" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."fiabilite_cr_adr_niv_1" IS 'Fiabilité des données croisées à l''adresse (''données croisées à l''adresse fiables'', ''données croisées à l''adresse fiables à l''echelle de la parcelle unifiee'', ''données croisées à l''adresse moyennement fiables'', ''problème de géocodage'')';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ADD COLUMN "fiabilite_cr_adr_niv_2" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse"."fiabilite_cr_adr_niv_2" IS 'Fiabilité détaillée des données croisées à l''adresse';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_adresse" ("batiment_groupe_id", "code_departement_insee", "cle_interop_adr_principale_ban", "libelle_adr_principale_ban", "nb_adresse_valid_ban", "fiabilite_cr_adr_niv_1", "fiabilite_cr_adr_niv_2") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	01001_0400_00130	130.0 RUE DES VIARDS 01400 L'Abergement-Clémenciat	1	données croisées à l'adresse fiables	batiment sans voisin à l'adresse
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_argiles_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" IS '[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l''aléa lié au retrait gonflement des argiles (RGA) agrégées à l''échelle du bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" ADD COLUMN "alea" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles"."alea" IS '(argiles) Aléa du risque argiles';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_argiles" ("batiment_groupe_id", "code_departement_insee", "alea") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	Faible
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_bdtopo_bat_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" IS 'Cette table contient les informations attributaires disponibles dans la BD TOPO de l''IGN, couche bâti. Les données sont regroupées au niveau du groupe de bâtiments : altitude, hauteur et liste d''usages.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "l_nature" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."l_nature" IS '(ign) Catégorie de nature du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "l_usage_1" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."l_usage_1" IS '(ign) Usage principal du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "l_usage_2" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."l_usage_2" IS '(ign) Usage secondaire du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "l_etat" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."l_etat" IS '(ign) Etat des bâtiments';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "hauteur_mean" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."hauteur_mean" IS '(ign) Hauteur moyenne des bâtiments [m]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "max_hauteur" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."max_hauteur" IS '(ign) Hauteur maximale des bâtiments [m]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ADD COLUMN "altitude_sol_mean" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat"."altitude_sol_mean" IS '(ign) Altitude au sol moyenne [m]';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_bat" ("batiment_groupe_id", "code_departement_insee", "l_nature", "l_usage_1", "l_usage_2", "l_etat", "hauteur_mean", "max_hauteur", "altitude_sol_mean") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	{"Indifférenciée"}	{"Indifférencié","Résidentiel"}	\N	{"En service"}	2	2	257
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_bdtopo_equ_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" IS 'Agrégation des informations suivantes issues des équipements de la BD TOPO de l''IGN (couche équipement) qui intersectent les groupes de bâtiments :
- la nature de l''équipement,
- le toponyme associé.

Les données sont fournies sous forme de listes agrégées.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "l_nature" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"."l_nature" IS '(ign) Catégorie de nature du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "l_nature_detaillee" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"."l_nature_detaillee" IS '(ign) Catégorie détaillée de nature de l''équipement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ" ADD COLUMN "l_toponyme" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_equ"."l_toponyme" IS '(ign) Toponymie de l''équipement';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_bdtopo_zoac_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" IS 'Agrégation des informations suivantes issues des zones d''activités de la BD TOPO de l''IGN (couche ZOA) qui intersectent les groupes de bâtiments :
- la nature de la zone d''activité,
- le toponyme associé.

Les données sont fournies sous forme de listes agrégées.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "l_nature" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"."l_nature" IS '(ign) Catégorie de nature du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "l_nature_detaillee" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"."l_nature_detaillee" IS '(ign) Catégorie détaillée de nature de l''équipement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac" ADD COLUMN "l_toponyme" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bdtopo_zoac"."l_toponyme" IS '(ign) Toponymie de l''équipement';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_bpe_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe" IS 'Agrégation des informations suivantes issues de la Base Permanente des Équipements (BPE) de l''INSEE, à l’échelle du groupe de bâtiments :
- le type d’équipement.

Les données sont fournies sous forme de listes agrégées.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe" ADD COLUMN "l_type_equipement" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_bpe"."l_type_equipement" IS '(bpe) Liste des équipements recensés par la base BPE';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dle_elec_multimillesime_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" IS 'Données de consommations des données locales de l''énergie du SDES pour le vecteur éléctrique agrégées à l''échelle du bâtiment (2018-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "millesime" VARCHAR(4);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."millesime" IS 'Millésime des données';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "nb_pdl_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."nb_pdl_res" IS 'Nombre de points de livraisons résidentiel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "nb_pdl_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."nb_pdl_pro" IS 'Nombre de points de livraisons professionel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "nb_pdl_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."nb_pdl_tot" IS 'Nombre total de points de livraisons';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_res" IS 'Consommation résidentielle [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_pro" IS 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_tot" IS 'Consommation totale [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_res_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_res_par_pdl" IS 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_pro_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_pro_par_pdl" IS 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime" ADD COLUMN "conso_tot_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_elec_multimillesime"."conso_tot_par_pdl" IS 'Consommation totale par point de livraison  [kWh/pdl.an]';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dle_gaz_multimillesime_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" IS 'Données de consommations des données locales de l''énergie du SDES pour le vecteur gaz agrégées à l''échelle du bâtiment (2018-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation depuis 2018)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "millesime" VARCHAR(4);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."millesime" IS 'Millésime des données';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "nb_pdl_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."nb_pdl_res" IS 'Nombre de points de livraisons résidentiel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "nb_pdl_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."nb_pdl_pro" IS 'Nombre de points de livraisons professionel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "nb_pdl_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."nb_pdl_tot" IS 'Nombre total de points de livraisons';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_res" IS 'Consommation résidentielle [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_pro" IS 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_tot" IS 'Consommation totale [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_res_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_res_par_pdl" IS 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_pro_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_pro_par_pdl" IS 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime" ADD COLUMN "conso_tot_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_gaz_multimillesime"."conso_tot_par_pdl" IS 'Consommation totale par point de livraison  [kWh/pdl.an]';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dle_reseaux_multimillesime_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" IS 'Données de consommations des données locales de l''énergie du SDES pour le vecteur réseau de chaleur agrégées à l''échelle du bâtiment. (2020-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "millesime" VARCHAR(4);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."millesime" IS 'Millésime des données';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "nb_pdl_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."nb_pdl_res" IS 'Nombre de points de livraisons résidentiel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "nb_pdl_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."nb_pdl_pro" IS 'Nombre de points de livraisons professionel';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "nb_pdl_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."nb_pdl_tot" IS 'Nombre total de points de livraisons';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_res" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_res" IS 'Consommation résidentielle [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_pro" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_pro" IS 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_tot" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_tot" IS 'Consommation totale [kWh/an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_res_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_res_par_pdl" IS 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_pro_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_pro_par_pdl" IS 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "conso_tot_par_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."conso_tot_par_pdl" IS 'Consommation totale par point de livraison  [kWh/pdl.an]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "identifiant_reseau" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."identifiant_reseau" IS 'Identifiant du reseau de chaleur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime" ADD COLUMN "type_reseau" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dle_reseaux_multimillesime"."type_reseau" IS 'type du réseau de chaleur';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dpe_representatif_logement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" IS 'Table qui contient les DPE représentatifs de chaque bâtiment de logement. Le DPE représentatif est soit un DPE issu de l''ancien arrêté qui n''est plus en vigueur (arrêté 2012) ou d''un nouveau DPE (arrêté 2021). Pour filtrer ancien et nouveau DPE utiliser le booléen `arrete_2021`

⚠️ Cette table fournit une synthèse du DPE représentatif du bâtiment.  
Pour plus d’informations sur la méthode de détermination du DPE représentatif :  
[https://bdnb.io/documentation/methode_traitement_dpe/](https://bdnb.io/documentation/methode_traitement_dpe/)

Pour consulter l''ensemble des DPE de logements rattachés à un bâtiment,il faut utiliser les tables : 

- `dpe_logement`
- `rel_batiment_groupe_dpe_logement`';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "arrete_2021" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."arrete_2021" IS 'précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s''il s''agit d''un DPE issu de la modification antérieure de 2012.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_dpe" IS 'type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_batiment_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_batiment_dpe" IS 'défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d''information est un DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "periode_construction_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."periode_construction_dpe" IS 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "annee_construction_dpe" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."annee_construction_dpe" IS 'année de construction du logement évaluée par le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "version" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."version" IS 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "date_etablissement_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."date_etablissement_dpe" IS 'date de l''établissement du dpe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "date_reception_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."date_reception_dpe" IS 'date de réception du DPE dans la base de données de l''ADEME';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nombre_niveau_logement" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nombre_niveau_logement" IS 'nombre de niveaux du logement (maison ou appartement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nombre_niveau_immeuble" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nombre_niveau_immeuble" IS 'nombre de niveaux total de l''immeuble';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_habitable_immeuble" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_habitable_immeuble" IS 'surface habitable totale de l''immeuble dans le cas d''un DPE appartement avec usage collectif ou d''un DPE immeuble.(surface habitable au sens du DPE)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_habitable_logement" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_habitable_logement" IS 'surface habitable du logement renseignée sauf dans le cas du dpe à l''immeuble. (surface habitable au sens du DPE)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "conso_5_usages_ep_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."conso_5_usages_ep_m2" IS 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "conso_5_usages_ef_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."conso_5_usages_ef_m2" IS 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "emission_ges_5_usages_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."emission_ges_5_usages_m2" IS 'emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "classe_bilan_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."classe_bilan_dpe" IS 'Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "classe_emission_ges" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."classe_emission_ges" IS 'classe d''émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "classe_conso_energie_arrete_2012" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."classe_conso_energie_arrete_2012" IS 'classe d''émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "classe_emission_ges_arrete_2012" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."classe_emission_ges_arrete_2012" IS 'classe d''emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "conso_3_usages_ep_m2_arrete_2012" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."conso_3_usages_ep_m2_arrete_2012" IS 'consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "emission_ges_3_usages_ep_m2_arrete_2012" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."emission_ges_3_usages_ep_m2_arrete_2012" IS 'emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012 (kgCO2/m2/an).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_installation_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_installation_chauffage" IS 'type d''installation de chauffage (collectif ou individuel)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_energie_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_energie_chauffage" IS 'type d''énergie pour le générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_chauffage" IS 'type de générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_chauffage_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_chauffage_anciennete" IS 'ancienneté du générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_energie_chauffage_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_energie_chauffage_appoint" IS 'type d''énergie pour le générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_chauffage_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_chauffage_appoint" IS 'type de générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_chauffage_anciennete_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_chauffage_anciennete_appoint" IS 'ancienneté du générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "chauffage_solaire" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."chauffage_solaire" IS 'présence de chauffage solaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nb_generateur_chauffage" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nb_generateur_chauffage" IS 'nombre de générateurs de chauffage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nb_installation_chauffage" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nb_installation_chauffage" IS 'nombre d''installation de chauffage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_energie_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_energie_climatisation" IS 'type d''énergie pour le générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_climatisation" IS 'type de générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_climatisation_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_climatisation_anciennete" IS 'ancienneté du générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_installation_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_installation_ecs" IS 'type d''installation d''eau chaude sanitaire (ECS) (collectif ou individuel)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_energie_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_energie_ecs" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_ecs" IS 'type de générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_ecs_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_ecs_anciennete" IS 'ancienneté du générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_energie_ecs_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_energie_ecs_appoint" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_ecs_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_ecs_appoint" IS 'type de générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_generateur_ecs_anciennete_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_generateur_ecs_anciennete_appoint" IS 'ancienneté du générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "ecs_solaire" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."ecs_solaire" IS 'présence d''ecs solaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nb_generateur_ecs" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nb_generateur_ecs" IS 'nombre de générateurs d''ecs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "nb_installation_ecs" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."nb_installation_ecs" IS 'nombre d''installation d''ecs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "plusieurs_facade_exposee" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."plusieurs_facade_exposee" IS 'il est considéré dans le DPE qu''il y a plusieurs facades exposées au vent.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_ventilation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_ventilation" IS 'type de système de ventilation du logement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_production_energie_renouvelable" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_production_energie_renouvelable" IS 'type de production ENR pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_vitrage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_vitrage" IS 'type de vitrage principal des baies vitrées du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_materiaux_menuiserie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_materiaux_menuiserie" IS 'type de matériaux principal des menuiseries des baies vitrées du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_gaz_lame" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_gaz_lame" IS 'type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_fermeture" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_fermeture" IS 'type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "epaisseur_lame" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."epaisseur_lame" IS 'epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "vitrage_vir" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."vitrage_vir" IS 'le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d''un point de vue thermique.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_vitree_nord" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_vitree_nord" IS 'somme de la surface de baies vitrées orientées nord du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_vitree_sud" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_vitree_sud" IS 'somme de la surface de baies vitrées orientées sud du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_vitree_ouest" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_vitree_ouest" IS 'somme de la surface de baies vitrées orientées ouest du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_vitree_est" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_vitree_est" IS 'somme de la surface de baies vitrées orientées est du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_vitree_horizontal" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_vitree_horizontal" IS 'somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "traversant" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."traversant" IS 'indicateur du côté traversant du logement.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_baie_vitree" IS 'Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "uw" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."uw" IS 'Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "facteur_solaire_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."facteur_solaire_baie_vitree" IS 'facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "presence_balcon" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."presence_balcon" IS 'présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "l_orientation_baie_vitree" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."l_orientation_baie_vitree" IS 'liste des orientations des baies vitrées (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "pourcentage_surface_baie_vitree_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."pourcentage_surface_baie_vitree_exterieur" IS 'pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_isolation_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_isolation_mur_exterieur" IS 'type d''isolation principal des murs donnant sur l''extérieur pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "epaisseur_isolation_mur_exterieur_estim" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."epaisseur_isolation_mur_exterieur_estim" IS 'epaisseur d''isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d''une épaisseur déclarée c''est directement l''épaisseur déclarée qui est considérée, dans le cas contraire l''épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "materiaux_structure_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."materiaux_structure_mur_exterieur" IS 'matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "epaisseur_structure_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."epaisseur_structure_mur_exterieur" IS 'epaisseur moyenne de la partie structure du mur (sans l''isolation rapportée ni les doublages)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_mur_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_mur_totale" IS 'somme de la surface de murs totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_mur_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_mur_exterieur" IS 'somme de la surface  surface de murs donnant sur l''extérieur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_mur_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_mur_deperditif" IS 'somme de la surface de murs donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_mur_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_mur_exterieur" IS 'Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "l_local_non_chauffe_mur" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."l_local_non_chauffe_mur" IS 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "local_non_chauffe_principal_mur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."local_non_chauffe_principal_mur" IS 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "l_orientation_mur_exterieur" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."l_orientation_mur_exterieur" IS 'liste des orientations des murs donnant sur l''extérieur (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_isolation_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_isolation_plancher_bas" IS 'type d''isolation principal des planchers bas déperditifs pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_plancher_bas_deperditif" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_plancher_bas_deperditif" IS 'materiaux ou principe constructif principal des planchers bas';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_plancher_bas_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_plancher_bas_totale" IS 'somme de la surface de plancher bas totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_plancher_bas_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_plancher_bas_deperditif" IS 'somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_plancher_bas_final_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_plancher_bas_final_deperditif" IS 'Coefficient de transmission thermique moyen des planchers bas en prenant en compte l''atténuation forfaitaire du U lorsqu''en contact avec le sol de la méthode 3CL(W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_plancher_bas_brut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_plancher_bas_brut_deperditif" IS 'Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "l_local_non_chauffe_plancher_bas" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."l_local_non_chauffe_plancher_bas" IS 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "local_non_chauffe_principal_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."local_non_chauffe_principal_plancher_bas" IS 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_adjacence_principal_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_adjacence_principal_plancher_bas" IS 'type d''adjacence principale des planchers bas (sont ils en contact avec l''extérieur ou un local non chauffé)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_isolation_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_isolation_plancher_haut" IS 'type d''isolation principal des planchers hauts déperditifs pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_plancher_haut_deperditif" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_plancher_haut_deperditif" IS 'materiaux ou principe constructif principal des planchers hauts';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_plancher_haut_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_plancher_haut_totale" IS 'somme de la surface de plancher haut totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_plancher_haut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_plancher_haut_deperditif" IS 'somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_plancher_haut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_plancher_haut_deperditif" IS 'Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "l_local_non_chauffe_plancher_haut" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."l_local_non_chauffe_plancher_haut" IS 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "local_non_chauffe_principal_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."local_non_chauffe_principal_plancher_haut" IS 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_adjacence_principal_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_adjacence_principal_plancher_haut" IS 'type d''adjacence principale des planchers haut (sont ils en contact avec l''extérieur ou un local non chauffé)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "type_porte" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."type_porte" IS 'type de porte du DPE (enum version DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "surface_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."surface_porte" IS 'somme de la surface de portes du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "u_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."u_porte" IS 'Coefficient de transmission thermique moyen des portes (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "classe_inertie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."classe_inertie" IS 'classe d''inertie pour le DPE (de légère à très lourde)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_mur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_mur" IS 'somme des déperditions par les murs du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_baie_vitree" IS 'somme des déperditions par les baies vitrées du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_plancher_bas" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_plancher_bas" IS 'somme des deperditions par les planchers bas du logement (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_plancher_haut" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_plancher_haut" IS 'somme des deperditions par les planchers hauts du logement (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_pont_thermique" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_pont_thermique" IS 'somme des deperditions par les portes du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement" ADD COLUMN "deperdition_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_representatif_logement"."deperdition_porte" IS 'somme des deperditions par les portes du DPE (W/K)';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dpe_statistique_logement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" IS 'Données statistiques du nombre de DPE par étiquette sur un bâtiment de logement. Pour les étiquettes DPE de l''ancien arrêté qui ne sont plus en vigueur les colonnes sont suffixées par "arrete_2012"';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_a" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_a" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe A';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_b" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_b" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe B';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_c" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_c" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe C';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_d" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_d" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe D';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_e" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_e" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe E';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_f" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_f" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe F';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_bilan_dpe_g" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_bilan_dpe_g" IS '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe G';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_a" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_a" IS '(dpe) Nombre de DPE de la classe énergétique A. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_b" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_b" IS '(dpe) Nombre de DPE de la classe énergétique B. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_c" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_c" IS '(dpe) Nombre de DPE de la classe énergétique C. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_d" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_d" IS '(dpe) Nombre de DPE de la classe énergétique D. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_e" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_e" IS '(dpe) Nombre de DPE de la classe énergétique E. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_f" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_f" IS '(dpe) Nombre de DPE de la classe énergétique F. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_g" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_g" IS '(dpe) Nombre de DPE de la classe énergétique G. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement" ADD COLUMN "nb_classe_conso_energie_arrete_2012_nc" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_statistique_logement"."nb_classe_conso_energie_arrete_2012_nc" IS '(dpe) Nombre de DPE n''ayant pas fait l''objet d''un calcul d''étiquette énergie (DPE dits vierges). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dpe_tertiaire_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" IS 'Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l''ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l''ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d''une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d''information disponible est fortement réduit par rapport aux DPE logements.
La table batiment_groupe_dpe_tertiaire ne conserve que le DPE tertiaire non vierge le plus récent associé à un groupe de bâtiments ou le dernier DPE vierge si le groupe de bâtiments n''est associé à aucun DPE non vierge';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "type_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."type_dpe_tertiaire" IS 'le DPE tertiaire applique l''arrêté de 2006 sur le DPE et n''a pas été revu depuis. Pour le moment cette colonne vaut toujours : ''dpe 2006 tertiaire et erp''';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "source_nouvelle_base_ademe" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."source_nouvelle_base_ademe" IS 'le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l''ancienne base de données (2012-2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "version" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."version" IS 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "date_etablissement_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."date_etablissement_dpe" IS 'date de l''établissement du dpe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "date_reception_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."date_reception_dpe" IS 'date de réception du DPE dans la base de données de l''ADEME';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "annee_construction_dpe" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."annee_construction_dpe" IS 'année de construction du logement évaluée par le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "shon" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."shon" IS 'surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "surface_utile" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."surface_utile" IS 'surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "classe_conso_energie_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."classe_conso_energie_dpe_tertiaire" IS 'classe de consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "classe_emission_ges_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."classe_emission_ges_dpe_tertiaire" IS 'classe d''emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_dpe_tertiaire_ep_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_dpe_tertiaire_ep_m2" IS 'consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "emission_ges_dpe_tertiaire_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."emission_ges_dpe_tertiaire_m2" IS 'emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "categorie_erp_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."categorie_erp_dpe_tertiaire" IS 'categorie d''ERP du DPE tertiaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "periode_construction_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."periode_construction_dpe" IS 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "type_erp_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."type_erp_dpe_tertiaire" IS 'type d''ERP pour le DPE tertiaire, si l''usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n''est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "methode_application_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."methode_application_dpe_tertiaire" IS 'methode d''application du DPE tertiaire (facture, vierge ou neuf)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "sous_modele_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."sous_modele_dpe_tertiaire" IS 'sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "type_energie_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."type_energie_chauffage" IS 'type d''énergie pour le générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "type_energie_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."type_energie_ecs" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "type_energie_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."type_energie_climatisation" IS 'type d''énergie pour le générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "derniere_annee_consommation" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."derniere_annee_consommation" IS 'dernière année de consommation utilisée pour le calcul du DPE tertiaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_autre_fossile" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_autre_fossile" IS 'consommation d''autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_bois" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_bois" IS 'consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_electricite" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_electricite" IS 'consommation d''électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_fioul" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_fioul" IS 'consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_gaz" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_gaz" IS 'consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_gpl_butane_propane" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_gpl_butane_propane" IS 'consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_reseau_chaleur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_reseau_chaleur" IS 'consommation d''énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire" ADD COLUMN "conso_reseau_froid" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dpe_tertiaire"."conso_reseau_froid" IS 'consommation d''énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dvf_open_representatif_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" IS 'Données des mutations issues des valeurs foncières agrégées à l''échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.

Les données correspondent à la transaction représentative des transactions de locaux ayant eu lieu sur ce bâtiment. 
Le local représentatif est un logement (en cas de bâtiment mixte) choisi pour représenter le type de logement le plus fréquent (basé sur le nombre de pièces).
La transaction la plus récente correspondant à ce logement est remontée dans cette table.

Cette table correspond à la version « open_data » de la table `batiment_groupe_dvf_logtype`.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "id_opendata" VARCHAR(60);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."id_opendata" IS 'Identifiant open data de la mutation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "valeur_fonciere" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."valeur_fonciere" IS 'Valeur foncière en euros de la mutation représentative. [€]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "date_mutation" date;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."date_mutation" IS 'date de la mutation pour la transaction immobilière';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_locaux_mutee_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_locaux_mutee_mutation" IS 'Nombre de locaux ayant mutés lors de la mutation représentative.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_maison_mutee_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_maison_mutee_mutation" IS 'Nombre de maisons ayant mutées lors de la mutation représentative.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_appartement_mutee_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_appartement_mutee_mutation" IS 'Nombre d''appartements ayant mutés lors de la mutation représentative.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_dependance_mutee_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_dependance_mutee_mutation" IS 'Nombre de dépendances ayant mutées lors de la mutation représentative.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_locaux_tertiaire_mutee_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_locaux_tertiaire_mutee_mutation" IS 'Nombre de locaux tertiaires ayant mutés lors de la mutation représentative.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "surface_bati_mutee_residencielle_individuelle" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."surface_bati_mutee_residencielle_individuelle" IS 'Surface de bâti associée à des résidences individuelles ayant mutées lors de la mutation représentative [m²].';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "surface_bati_mutee_residencielle_collective" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."surface_bati_mutee_residencielle_collective" IS 'Surface de bâti associée à des résidences collectives ayant mutées lors de la mutation représentative [m²].';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "surface_bati_mutee_dependance" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."surface_bati_mutee_dependance" IS 'Surface de bâti associée à des dépendances ayant mutées lors de la mutation représentative [m²].';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "surface_bati_mutee_tertiaire" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."surface_bati_mutee_tertiaire" IS 'Surface de bâti associée à du tertiaire ayant mutées lors de la mutation représentative [m²].';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "surface_terrain_mutee" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."surface_terrain_mutee" IS 'Surface de terrain ayant muté lors de la mutation représentative [m²].';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "nb_piece_principale" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."nb_piece_principale" IS 'Nombre de pièces principales de la résidence individuelle ou collective ayant muté. Cet indicateur est disponible lorsqu''une unique résidence individuelle ou collective a mutée.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "prix_m2_local" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."prix_m2_local" IS 'Prix au m² de bâti en euros lors de la mutation. Cet indicateur n''est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif" ADD COLUMN "prix_m2_terrain" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_representatif"."prix_m2_terrain" IS 'Prix au m² du terrain en euros lors de la mutation. Cet indicateur n''est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_dvf_open_statistique_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" IS 'Données des mutations issues des valeurs foncières agrégées à l''échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.
les données sont des statistiques sur les transactions immobilières ayant eu lieue sur le bâtiment
Cette table correspond à la version  « open_data » de la table `batiment_groupe_dvf`.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_mutation" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_mutation" IS 'Nombre de mutations qui ont eu lieu sur le batiment_groupe (sur la période de référence des DVF).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "valeur_fonciere_median" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."valeur_fonciere_median" IS 'Valeur foncière médiane en euros calculée sur l''ensemble des mutations qui ont eu lieu sur le batiment_groupe.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "valeur_fonciere_moyenne" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."valeur_fonciere_moyenne" IS 'Valeur foncière moyenne en euros calculée sur l''ensemble des mutations qui ont eu lieu sur le batiment_groupe.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "valeur_fonciere_max" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."valeur_fonciere_max" IS '(dv3f) valeur foncière maximale parmi les locaux du bâtiment rapporté au m² habitable (SHAB)[€/m²]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "valeur_fonciere_min" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."valeur_fonciere_min" IS '(dv3f) valeur foncière minimale parmi les locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_local_median" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_local_median" IS 'Prix médian au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_local_moyen" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_local_moyen" IS 'Prix moyen au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_local_max" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_local_max" IS 'Prix maximale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_local_min" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_local_min" IS 'Prix minimale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_terrain_median" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_terrain_median" IS 'Prix médian au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_terrain_moyen" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_terrain_moyen" IS 'Prix moyen au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_terrain_max" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_terrain_max" IS 'Prix maximale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "prix_m2_terrain_min" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."prix_m2_terrain_min" IS 'Prix minimale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_locaux_mutee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_locaux_mutee" IS 'Nombre de locaux qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_maisons_mutee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_maisons_mutee" IS 'Nombre de maisons qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_appartement_mutee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_appartement_mutee" IS 'Nombre d''appartements qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_dependance_mutee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_dependance_mutee" IS 'Nombre de dépendances qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique" ADD COLUMN "nb_locaux_tertiaire_mutee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_dvf_open_statistique"."nb_locaux_tertiaire_mutee" IS 'Nombre de locaux tertiaires qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_ffo_bat_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" IS 'Données issues du traitement des fichiers fonciers pour ce bâtiment.

Caractéristiques :
- Les quantitatifs (nombre de locaux, surfaces) sont calculés comme la somme des locaux et de leurs surfaces sur l’ensemble des bâtiments fonciers idbat constitutifs du groupe de bâtiments de la BDNB.
- Les données d’usages sont une synthèse des différents usages identifiés dans les fichiers fonciers.

⚠️ Recommandation :
Pour l’usage des bâtiments, il est désormais conseillé d’utiliser la table `batiment_groupe_synthese_propriete_usage`, qui corrige les usages en intégrant des données complémentaires, notamment pour les bâtiments publics.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "nb_niveau" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."nb_niveau" IS '(ffo) Nombre de niveau du bâtiment (ex: RDC = 1, R+1 = 2, etc..)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "annee_construction" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."annee_construction" IS 'Année de construction du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "usage_niveau_1_txt" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."usage_niveau_1_txt" IS 'indicateurs d''usage simplifié du bâtiment (verbose)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "mat_mur_txt" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."mat_mur_txt" IS '(ffo) Matériaux principal des murs extérieurs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "mat_toit_txt" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."mat_toit_txt" IS '(ffo) Matériau principal des toitures';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ADD COLUMN "nb_log" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat"."nb_log" IS 'Nombre de logements dans le groupe de bâtiments';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_ffo_bat" ("batiment_groupe_id", "code_departement_insee", "nb_niveau", "annee_construction", "usage_niveau_1_txt", "mat_mur_txt", "mat_toit_txt", "nb_log") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	1	1995	Résidentiel individuel	MEULIERE	TUILES	1
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_geospx_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" IS 'Cette table contient des indications de fiabilité concernant l''association entre les bâtiments des Fichiers Fonciers et les bâtiments constructions, utilisée pour constituer les groupes de bâtiments de la BDNB.

[TABLE DÉPRÉCIÉE] : cette table est dépréciée. Les indicateurs correspondants seront intégrés dans une nouvelle version des métriques de qualité d''appariement entre les emprises BD TOPO et les bâtiments fonciers.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "fiabilite_emprise_sol" VARCHAR(7);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."fiabilite_emprise_sol" IS 'Fiabilité de l''emprise au sol du bâtiment : "vrai" si les données des Fichiers Fonciers (surfaces fiscales retravaillée par niveau) et BDTOpo (emprise au sol) sont cohérentes ; "faux" sinon ; "NULL" si l''un des deux informations à comparer n''est pas disponible';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "fiabilite_hauteur" VARCHAR(7);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."fiabilite_hauteur" IS 'Fiabilité de la hauteur du bâtiment : "vrai" si les données des Fichiers Fonciers (nombre de niveaux) et BDTOpo (hauteur) sont cohérentes ; "faux" sinon ; "NULL" si l''un des deux informations à comparer n''est pas disponible';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "fiabilite_adresse" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."fiabilite_adresse" IS 'Fiabilité des adresses du bâtiment : "vrai" si les Fichiers Fonciers et BDTOpo partagent au moins une même adresse BAN';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ADD COLUMN "croisement_geospx_reussi" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx"."croisement_geospx_reussi" IS 'Fiabilité sur le croisement de données bâtimentaires : "vrai" si l''association Fichiers Fonciers et BDTopo est considérée comme réussi ; "faux" sinon ; "NULL" si l''une des composantes n''existe pas sur l''unité foncière (i.e. parcelle unifiée) associée.';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_geospx" ("batiment_groupe_id", "code_departement_insee", "fiabilite_emprise_sol", "fiabilite_hauteur", "fiabilite_adresse", "croisement_geospx_reussi") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	MOYENNE	BONNE	1	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_hthd_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" IS 'Données issues de la base des immeubles localisés de l''Arcep agrégées à l''échelle du groupe de bâtiment.
Cette table permet d''identifier les bâtiments raccordés à la fibre.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "nb_pdl" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"."nb_pdl" IS '(hthd) Nombre total de PDL Arcep';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "l_type_pdl" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"."l_type_pdl" IS '(hthd) Liste de type de bâtiment desservis par les PDL';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ADD COLUMN "l_nom_pdl" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd"."l_nom_pdl" IS '(hthd) Liste des noms des points de livraisons centraux';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_hthd" ("batiment_groupe_id", "code_departement_insee", "nb_pdl", "l_type_pdl", "l_nom_pdl") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	1.000	{"PA"}	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_indicateur_reseau_chaud_froid_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" IS 'Indicateur de raccordement et de potentiel de raccordement aux réseaux de chaleur et de froid urbains construit à l''aide des données de "France Chaleur Urbaine" et les "Données Locales de l''Energie".
Cette table permet d''identifier les bâtiments raccordés aux réseaux de chaleurs ainsi que les bâtiments à proximité de réseaux chaleurs. 
Pour les bâtiments à proximité de réseaux de chaleur, un indicateur est calculé de potentiel de raccordement de ce bâtiment au réseau de chaleur en fonction de données techniques sur le bâtiment
pour plus d''informations voir la documentation (https://bdnb.io/documentation/indicateur_potentiel_raccordement_reseau_chaleur/)

Dans cette table 3 notions de proximité aux réseaux de chaleurs sont distinguées :

- la proximité aux réseaux de chaleur existants
- la proximité à des réseaux en cours de construction
- la présence dans un périmètre de développement de réseaux de chaleur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "id_reseau" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."id_reseau" IS '(France chaleur urbaine) Identifiant national du réseau.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "id_reseau_bdnb" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."id_reseau_bdnb" IS 'Identifiant BDNB, lié au réseau de chaleur, car des données sources ne disposent pas d''identifiant unique pour chacune des entrées (traces et points).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "reseau_en_construction" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."reseau_en_construction" IS 'Est vrai lorsque le réseau à proximité du bâtiment est en cours de construction ou en projet. Le réseau en construction peut avoir un tracé précis ou être délimité par une zone de construction du réseau. S''il n''y a pas de tracé disponible la distance au réseau considérée est la plus courte distance à la zone. 
Un réseau en construction ne possède pas d''identfiant réseau.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "perimetre_developpement_prioritaire" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."perimetre_developpement_prioritaire" IS 'Est vrai lorsque le bâtiment se situe dans une zone de développement prioritaire. Dans ce cas, le raccordement au réseau peut être obligatoire si il n''y a pas de contraintes techniques, ni un coût de raccordement disproportionné.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid" ADD COLUMN "indicateur_distance_au_reseau" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_indicateur_reseau_chaud_froid"."indicateur_distance_au_reseau" IS 'Indication sur la distance entre le bâtiment et le point au réseau
          de chaleur le plus proche en vue d''un potentiel raccordement au réseau.';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_merimee_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" IS '[TABLE DEPRECIEE] : Informations Mérimée (bâtiments classés aux Monuments Historiques) agrégées à l''échelle du bâtiment. Cette table est dépréciée au profit de `batiment_groupe_urbanisme`.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" ADD COLUMN "distance_batiment_historique_plus_proche" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee"."distance_batiment_historique_plus_proche" IS '(mer) Distance au bâtiment historique le plus proche (si moins de 500m) [m]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee" ADD COLUMN "nom_batiment_historique_plus_proche" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_merimee"."nom_batiment_historique_plus_proche" IS '(mer:tico) nom du bâtiment historique le plus proche';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_qpv_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv" IS 'Informations sur les Quartiers Prioritaires de la Ville agrégées à l''échelle du bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv" ADD COLUMN "nom_quartier" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_qpv"."nom_quartier" IS 'Nom du quartier prioritaire dans lequel se trouve le bâtiment';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_radon_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" IS '[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l''aléa radon projeté sur chaque bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" ADD COLUMN "alea" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon"."alea" IS '(radon) alea du risque radon';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_radon" ("batiment_groupe_id", "code_departement_insee", "alea") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	Faible
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_risques_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" IS 'Table regroupant différents indicateurs de risques (sismique, incendie, radon et argile) associés aux batiment_groupe de la BDNB. Les aléas sismiques, radon et argiles proviennent des zonages issus du site georisques. Les catégories de familles incendies proviennent d''une prédiction simplifiée de la réglementation risque incendie (sur le résidentiel uniquement). Enfin, les catégories de bâtiments associées au risque sismique correspondent à des travaux similaires au risque incendie (sur le résidentiel uniquement).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "alea_radon" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"."alea_radon" IS '(georisque) Indicateur d''aléa au radon. Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "alea_argile" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"."alea_argile" IS '(georisque) Indicateur d''aléa retrait-gonflement des argiles. Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ADD COLUMN "alea_sismique" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques"."alea_sismique" IS '(georisque) Indicateur d''aléa sismique.  Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_risques" ("batiment_groupe_id", "code_departement_insee", "alea_radon", "alea_argile", "alea_sismique") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	Faible	Faible	Faible
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_rnc_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" IS 'Informations issues de la base du registre national des copropriétés agrégées à l''échelle du groupe de bâtiment';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "numero_immat_principal" VARCHAR(30);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."numero_immat_principal" IS 'numéro d''immatriculation principal associé au bâtiment groupe. (numéro d''immatriculation copropriété qui comporte le plus de lots)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "periode_construction_max" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."periode_construction_max" IS '(rnc) Période de construction du local le plus récent';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "l_annee_construction" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."l_annee_construction" IS 'Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "nb_lot_garpark" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."nb_lot_garpark" IS 'Nombre de lots de stationnement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "nb_lot_tot" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."nb_lot_tot" IS 'Nombre total de lots';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "nb_log" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."nb_log" IS 'Nombre de logements déclaré dans le registre national des copropriétés pour le groupe de bâtiments';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "nb_lot_tertiaire" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."nb_lot_tertiaire" IS 'Nombre de lots de type bureau et commerce';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "l_nom_copro" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."l_nom_copro" IS '(rnc) liste des noms des copropriétés';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "l_siret" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."l_siret" IS 'liste de siret';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc" ADD COLUMN "copro_dans_pvd" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rnc"."copro_dans_pvd" IS '(rnc) au moins une des coproprietés est dans le programme petites villes de demain';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_rpls_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" IS 'Informations issues du répertoire des logements sociaux agrégées au niveau du groupe de bâtiment BDNB.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "rpls_open" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."rpls_open" IS 'True si tous les logements integrés sont en open';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_a" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_a" IS 'Nombre de logements avec un DPE énergie de classe A';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_b" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_b" IS 'Nombre de logements avec un DPE énergie de classe B';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_c" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_c" IS 'Nombre de logements ayant la classe DPE énergie C';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_d" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_d" IS 'Nombre de logements ayant la classe DPE énergie D';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_e" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_e" IS 'Nombre de logements ayant la classe DPE énergie E';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_f" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_f" IS 'Nombre de logements ayant la classe DPE énergie F';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_g" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_g" IS 'Nombre de logements ayant la classe DPE énergie G';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ener_nc" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ener_nc" IS 'Nombre de logements ayant la classe DPE énergie NC';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "classe_ener_principale" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."classe_ener_principale" IS '(rpls) classe DPE énergie principale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_a" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_a" IS '(rpls) Nombre de logements ayant la classe DPE climat A';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_b" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_b" IS '(rpls) Nombre de logements ayant la classe DPE climat B';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_c" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_c" IS '(rpls) Nombre de logements ayant la classe DPE climat C';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_d" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_d" IS '(rpls) Nombre de logements ayant la classe DPE climat D';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_e" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_e" IS '(rpls) Nombre de logements ayant la classe DPE climat E';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_f" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_f" IS '(rpls) Nombre de logements ayant la classe DPE climat F';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_g" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_g" IS '(rpls) Nombre de logements ayant la classe DPE climat G';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_classe_ges_nc" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_classe_ges_nc" IS '(rpls) Nombre de logements ayant la classe DPE climat NC';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "classe_ges_principale" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."classe_ges_principale" IS '(rpls) classe DPE climat principale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "accessible_pmr" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."accessible_pmr" IS '(rpls) Présence d''au moins un logement PMR';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "dans_qpv" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."dans_qpv" IS '(rpls) Immeuble dans un QPV';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "l_annee_construction" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."l_annee_construction" IS 'Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "nb_log" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."nb_log" IS 'Nombre de logements sociaux déclaré dans le RPLS pour le groupe de bâtiments';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "s_log_hab" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."s_log_hab" IS '(rpls) Surface de logements d''habitation [m²]';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls" ADD COLUMN "type_construction" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_rpls"."type_construction" IS '(rpls) Type de construction';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_synthese_propriete_usage_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" IS 'Table de synthèse des informations de propriété et d’usage des bâtiments.

Sources :
Cette table consolide les données issues de multiples sources :
- RPLS
- Fichiers fonciers
- Registre des copropriétés
- ESPACE (projet de géolocalisation des établissements publics en partenariat avec le CEREMA)
- Fichier locaux des personnes morales de la DGFiP
- SIRENE

Objectif :
Fournir les informations principales sur la propriété et l’usage des groupes de bâtiments.

NB : Cette table introduit le nouvel indicateur `usage_principal_bdnb_open`, qui remplace l’ancienne variable `usage_niveau_1_txt` issue des seuls fichiers fonciers.  
Il est recommandé d’utiliser `usage_principal_bdnb_open` à la place de la donnée foncière brute.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" ADD COLUMN "usage_principal_bdnb_open" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage"."usage_principal_bdnb_open" IS 'Indicateur d''usage principal du bâtiment. Cet indicateur est une évolution de la variable d''usage usage_niveau_1_txt (Fichiers Fonciers) qui est corrigée notamment sur les bâtiments publics qui sont affectés en usage tertiaire. 
Valeurs possibles :
- Résidentiel individuel
- Résidentiel collectif
- Tertiaire
- Secondaire
- Dépendance
- Indifférencié';
COPY "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_synthese_propriete_usage" ("batiment_groupe_id", "code_departement_insee", "usage_principal_bdnb_open") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01	Résidentiel individuel
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "batiment_groupe_urbanisme_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" IS 'Table qui regroupe les contraintes et réglementations d''urbanismes qui s''appliquent au bâtiment. Dans cette version, les contraintes d''urbanismes intégrées sont celles liées aux sites patrimoniaux et monuments historiques.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "batiment_groupe_id" VARCHAR(30);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "contrainte_urbanisme_ac1" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."contrainte_urbanisme_ac1" IS 'Indicateur booléen de la présence du bâtiment dans une zone AC1 (périmètre de 500m autour d''un monument historique ou dans un périmètre aux abords des monuments historiques)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "zone_plu_bati_patrimonial" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."zone_plu_bati_patrimonial" IS 'Indicateur booléen de la présence du bâtiment dans un périmètre classé patrimonial dans un PLU. Cela peut potentiellement recouvrir des classifications nationales comme les SPR mais peut aussi correspondre à des protections locales documentées uniquement dans le PLU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "monument_historique" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."monument_historique" IS 'Indicateur booléen signalant si le bâtiment est classé comme monument historique. Le bâtiment est déterminé comme monument historique lorsque le géolocalisant du monument est sur le bâtiment en question.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "source_monument_historique" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."source_monument_historique" IS 'Source utilisée pour identifier le bâtiment comme monument historique. (mérimée ou géoportail de l''urbanisme ou les deux)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "denomination_monument_historique" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."denomination_monument_historique" IS 'Dénomination du monument historique le plus proche si le bâtiment se trouve dans un périmètre AC1 ou s''il est lui-même bâtiment historique';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme" ADD COLUMN "distance_monument_historique" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."batiment_groupe_urbanisme"."distance_monument_historique" IS 'Distance entre le bâtiment et le monument historique en [m]. La distance est égale à 0m lorsque le bâtiment est un monument historique.';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "parcelle_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" IS 'Table contenant les informations sur les parcelles cadastrales.

Un groupe de bâtiments peut être situé sur une ou plusieurs parcelles cadastrales.
Cependant, un groupe de bâtiments ne peut pas appartenir à plusieurs unités foncières différentes (une unité foncière regroupe des parcelles appartenant au même propriétaire).

Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','parcelle','geom_parcelle',2154,'MULTIPOLYGON',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" ADD COLUMN "parcelle_id" VARCHAR(14);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle"."parcelle_id" IS '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle" ADD COLUMN "s_geom_parcelle" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle"."s_geom_parcelle" IS '(ffo) Surface au sol de la géométrie de parcelle';
COPY "bdnb_2025_07_a_open_data_dep01"."parcelle" ("geom_parcelle", "parcelle_id", "code_departement_insee", "code_commune_insee", "s_geom_parcelle") FROM STDIN;
01060000206A080000010000000103000000010000001E000000188ABA427DE029413992B970B90C59414FF79B7479E029416599F39BAE0C594198F5555D61E0294196165D10AE0C59416845C44155E0294178983BCBAD0C594166F460D73DE02941BD0E7044AD0C594147235D62FDDF2941F675A5C0AB0C594154074EC106E02941348741E3A60C5941DFE4FD7A5FDF294177372071A30C59417D76463245DF2941E9681EA9A90C59416E4A222F2DDF2941BEA7E862AF0C5941E069BA811FDF29414CB05F97B20C594177FD82921BDF2941E8916576B30C5941DFDE971B17DF29410B163648B40C594143B4480512DF2941F0D8BE0CB50C5941D7C397760DDF29412DEE94CAB50C59418DC4796008DF2941FCDEC979B60C594193F2DCD202DF2941580BB419B70C5941EE66F9BBECDE29417870EF70B90C594160FBDB0BD5DE29419573F5FCBB0C5941F665816C33DF29414C60C144BD0C5941536CB58949DF2941D6FA3395BD0C594109E0279494DF294117A469FEBD0C59415CEB0246ADDF2941EBF2B6F8BD0C5941A98039BABADF2941F2D970E7BD0C5941B4320BB3C8DF294156E6F5A1BD0C5941F020AF1DDEDF29416AF36D3FBD0C594130EF64D307E02941547D8F8ABC0C5941DE2F730D37E02941B6EF017ABB0C5941BE440A8A5AE029412B7ED58DBA0C5941188ABA427DE029413992B970B90C5941	010010000A0001	01	01001	14394
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "parcelle_sitadel_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" IS 'Informations consolidées et simplifiées à l''échelle de la parcelle des données SITADEL. Cette table fournit des données numériques et 
catégorielles synthétiques sur les demandes d''autorisation d''urbanisme (DAU) déclarées pour chaque parcelle. Une 
analyse complémentaire vérifie l''actualisation de certaines données de la BDNB, telles que la surface, le nombre de 
locaux, l''année de construction. Si ces éléments ne correspondent pas aux dernières autorisations d''urbanisme 
disponibles, cela indique que la BDNB n''est pas à jour pour cette parcelle.
**ATENTION** Ne pas faire des statistiques agregées sur cette table, les valeurs numériques sont données à titre 
indicatif. Pour des statistiques utiliser la table `sitadel`. En effet, une demande d''autorisation d''urbanisme peut concerner plusieurs parcelles et peut donc être répétée dans cette table.

NB : les données sitadel ne sont pas fournies au niveau des groupes de bâtiments comme les autres informations métiers de la BDNB car elles concernent des opérations ayant pour objet la démolition ou la construction de bâtiments et concernent majoritairement des bâtiments qui n''existent pas encore ou n''existent plus.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "parcelle_id" VARCHAR(14);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."parcelle_id" IS '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "code_departement_insee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nombre_dau" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nombre_dau" IS '(Sitadel) Nombre de demandes d''autorisation d''urbanisme (DAU).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "annee_premiere_dau_identifiee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."annee_premiere_dau_identifiee" IS '(Sitadel) Année de la première DAU identifiée dans le millésime de Sitadel utilisé.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "annee_derniere_dau_identifiee" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."annee_derniere_dau_identifiee" IS '(Sitadel) Année de la dernière DAU identifiée dans le millésime de Sitadel utilisé.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nouvelle_construction" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nouvelle_construction" IS 'Nouveau bâtiment sur parcelle. 
Peut prendre les valuers : ''nouveau bâtiment exclusif'' ou ''nouveau bâtiment ajouté''
- nouveau bâtiment exclusif : soit une construction entièrement neuve sur une parcelle vierge, soit un bâtiment qui remplace entièrement une structure préexistante.
- nouveau bâtiment ajouté : nouveau bâtiment sur parcelle sur laquelle existe déjà un ou plusieurs bâtiments.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "travaux_sur_construction_existante" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."travaux_sur_construction_existante" IS '(Sitadel) Vrai si les permis déclarent des travaux sur construction existante.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "demolition" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."demolition" IS '(Sitadel) Démolition déclarée par DAU égale à permis de démolir ou surface démolie déclarée dans les permis de 
création de surfaces.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "amenagement" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."amenagement" IS 'Demande d''autorisation d''urbanisme spécifique pour réaliser un aménagement.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "bdnb_obsolete" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."bdnb_obsolete" IS '(Sitadel) Les informations contenues dans la BDNB pour ce groupe de bâtiments sont considérées comme potentiellement obsolètes (année de construction, surfaces, emprise au sol, etc.), car elles se réfèrent à une période antérieure à celle des autorisations de création de surfaces.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "annee_construction_obsolete" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."annee_construction_obsolete" IS '(Sitadel) Année de construction enregistrée antérieure à celle déclarée dans la dernière DAU connue dans Sitadel pour cette parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "service_public_identifie" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."service_public_identifie" IS '(Sitadel) Travaux déclarés par les autorisations avec un ou l''un des usages de type service public.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "indicateur_extension" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."indicateur_extension" IS 'Indicateur pour la présence d''une extension.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "indicateur_surelevation_ou_nivsupp" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."indicateur_surelevation_ou_nivsupp" IS 'Indicateur pour la présence d''une surélévation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "indicateur_piscine" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."indicateur_piscine" IS 'Indicateur pour la présence d''une piscine.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "indicateur_garage" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."indicateur_garage" IS 'Indicateur pour la présence d''un garage.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nombre_logemens_totaux_crees" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nombre_logemens_totaux_crees" IS 'Nombre total de logements créés sur la parcelle. Cela inclus les logements à usage individuel, collectif et les logements en résidences.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nombre_logement_demolis" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nombre_logement_demolis" IS 'Nombre de logements démolis sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_cree" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_cree" IS 'Surface habitable créée sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_issue_transformation" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_issue_transformation" IS 'Surface habitable issue d''une transformation sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_transformee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_transformee" IS 'Surface habitable transformée sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_demolie" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_demolie" IS 'Surface habitable démolie sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_cree" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_cree" IS 'Surface des locaux créés sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_issue_transformee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_issue_transformee" IS 'Surface des locaux issus d''une transformation sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_transformee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_transformee" IS 'Surface des locaux transformée sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_demolie" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_demolie" IS 'Surface des locaux démolie sur la parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nature_derniere_dau" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nature_derniere_dau" IS '(Sitadel) Nature du dernier permis autorisé.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nombre_logements_creees_derniere_dau" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nombre_logements_creees_derniere_dau" IS '(Sitadel) Nombre de logements créés (individuels, collectifs et des résidences) - déclaré dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "nombre_logements_demolis_derniere_dau" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."nombre_logements_demolis_derniere_dau" IS '(Sitadel) Nombre de logements démolis - déclaré dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_creee_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_creee_derniere_dau" IS '(Sitadel) Surface habitable créée - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_creee_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_creee_derniere_dau" IS '(Sitadel) Surface créée pour les planchers de locaux non résidentiels - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_issue_transfo_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_issue_transfo_derniere_dau" IS '(Sitadel) Surface de plancher de la destination '' Habitation '' issue d''une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_issue_transfo_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_issue_transfo_derniere_dau" IS '(Sitadel) Surface de plancher des locaux non-résidentiels issue d''une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_transformee_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_transformee_derniere_dau" IS '(Sitadel) Surface de plancher de la destination '' Habitation '' transformée (changement de destination, réhabilitation, scission, regroupement ...) - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_transformee_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_transformee_derniere_dau" IS '(Sitadel) Surface de plancher - de locaux non résidentiels - transformée (changement de destination, réhabilitation, 
scission, regroupement ...) - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_habitable_demolie_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_habitable_demolie_derniere_dau" IS '(Sitadel) Surface de plancher de la destination '' Habitation '' supprimée (démolie) - déclarée dans la dernière DAU.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ADD COLUMN "surface_locaux_demolie_derniere_dau" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel"."surface_locaux_demolie_derniere_dau" IS '(Sitadel) Surface de plancher de locaux non résidentiels démolie - déclarée dans la dernière DAU.';
COPY "bdnb_2025_07_a_open_data_dep01"."parcelle_sitadel" ("parcelle_id", "code_departement_insee", "nombre_dau", "annee_premiere_dau_identifiee", "annee_derniere_dau_identifiee", "nouvelle_construction", "travaux_sur_construction_existante", "demolition", "amenagement", "bdnb_obsolete", "annee_construction_obsolete", "service_public_identifie", "indicateur_extension", "indicateur_surelevation_ou_nivsupp", "indicateur_piscine", "indicateur_garage", "nombre_logemens_totaux_crees", "nombre_logement_demolis", "surface_habitable_cree", "surface_habitable_issue_transformation", "surface_habitable_transformee", "surface_habitable_demolie", "surface_locaux_cree", "surface_locaux_issue_transformee", "surface_locaux_transformee", "surface_locaux_demolie", "nature_derniere_dau", "nombre_logements_creees_derniere_dau", "nombre_logements_demolis_derniere_dau", "surface_habitable_creee_derniere_dau", "surface_locaux_creee_derniere_dau", "surface_habitable_issue_transfo_derniere_dau", "surface_locaux_issue_transfo_derniere_dau", "surface_habitable_transformee_derniere_dau", "surface_locaux_transformee_derniere_dau", "surface_habitable_demolie_derniere_dau", "surface_locaux_demolie_derniere_dau") FROM STDIN;
010010000A1045	01	1	2015	2015	nouveau bâtiment exclusif	0	0	0	0	0	0	0	0	0	1	1	0	108.000	0.000	0.000	0.000	0.000	0.000	0.000	0.000	nouvelle construction	1	\N	108.000	\N	\N	\N	\N	\N	\N	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_parcelle_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" IS 'Table de relation entre les groupes de bâtiments et les parcelles (relation n-m) :
- Une parcelle peut contenir plusieurs groupes de bâtiments.
- Un groupe de bâtiments peut être situé sur plusieurs parcelles.

Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ADD COLUMN "parcelle_id" VARCHAR(14);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle"."parcelle_id" IS '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ADD COLUMN "parcelle_principale" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle"."parcelle_principale" IS 'Booléen renvoyant ''vrai'' si la parcelle cadastrale est la plus grande intersectant le groupe de bâtiment';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_parcelle" ("batiment_groupe_id", "parcelle_id", "code_departement_insee", "parcelle_principale") FROM STDIN;
bdnb-bg-111J-YU68-VJ8Z	01001000ZH0126	01	1
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "proprietaire_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" IS 'Données sur les propriétaires de bâtiment (issues des Fichiers Fonciers)
Cette table est disponible en open data uniquement sur certaines colonnes pour les propriétaires fonciers diffusés dans le fichier des locaux sur les personnes morales de la DGFiP (la version open filtre sur la colonne `dans_majic_pm`)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "personne_id" VARCHAR(8);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."personne_id" IS 'Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "siren" VARCHAR(9);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."siren" IS 'Numéro de SIREN d''une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "forme_juridique" VARCHAR(4);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."forme_juridique" IS 'Forme juridique du propriétaire (FF)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "denomination" VARCHAR(60);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."denomination" IS 'Dénomination du propriétaire (FF)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "code_postal" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."code_postal" IS 'Code postal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "libelle_commune" VARCHAR(32);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."libelle_commune" IS 'Libellé de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "dans_majic_pm" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."dans_majic_pm" IS '(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."proprietaire" ADD COLUMN "nb_locaux_open" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."proprietaire"."nb_locaux_open" IS 'nombre de locaux possédé par le propriétaire diffusé dans majic personne morale';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_proprietaire_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" IS 'Table de relation entre les propriétaires fonciers et les groupes de bâtiments.

Les données foncières sur les propriétaires sont disponibles en open data uniquement pour les personnes morales.
Seuls les propriétaires présents dans le fichier MAJIC personnes morales sont inclus dans la version open data (filtrage via la colonne `dans_majic_pm`).

Cette table établit le lien entre :
- la table `batiment_groupe` ,
- et la table `proprietaire`';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "personne_id" VARCHAR(8);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"."personne_id" IS 'Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "dans_majic_pm" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"."dans_majic_pm" IS '(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire" ADD COLUMN "nb_locaux_open" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_proprietaire"."nb_locaux_open" IS 'nombre de locaux possédé par le propriétaire dans ce groupe de bâtiment diffusé dans majic personne morale';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "dpe_logement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" IS 'Table de compilation des DPE logements regroupant les DPE logements de l''arrêté du 8 février 2012 (DPE "arrete 2012" Base ADEME 2012-2021) et les DPE logements de l''arrêté du 31 mars 2021 (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE "arrete 2012"  et les DPE "arrete 2021". Les DPE de l''arrêté du 31 mars sont opposables et donc réputés bien plus fiables et issus d''une base de donnée beaucoup plus propre et complète que la précédente.  Les types de DPE peuvent être filtrés avec la propriété type_dpe entre les DPE "arrete 2012" et "arrete 2021".';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "arrete_2021" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."arrete_2021" IS 'précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s''il s''agit d''un DPE issu de la modification antérieure de 2012.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_dpe" IS 'type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_batiment_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_batiment_dpe" IS 'défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d''information est un DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "periode_construction_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."periode_construction_dpe" IS 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "annee_construction_dpe" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."annee_construction_dpe" IS 'année de construction du logement évaluée par le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "version" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."version" IS 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "date_etablissement_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."date_etablissement_dpe" IS 'date de l''établissement du dpe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "date_reception_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."date_reception_dpe" IS 'date de réception du DPE dans la base de données de l''ADEME';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nombre_niveau_logement" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nombre_niveau_logement" IS 'nombre de niveaux du logement (maison ou appartement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nombre_niveau_immeuble" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nombre_niveau_immeuble" IS 'nombre de niveaux total de l''immeuble';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_habitable_immeuble" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_habitable_immeuble" IS 'surface habitable totale de l''immeuble dans le cas d''un DPE appartement avec usage collectif ou d''un DPE immeuble.(surface habitable au sens du DPE)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_habitable_logement" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_habitable_logement" IS 'surface habitable du logement renseignée sauf dans le cas du dpe à l''immeuble. (surface habitable au sens du DPE)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "conso_5_usages_ep_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."conso_5_usages_ep_m2" IS 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "conso_5_usages_ef_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."conso_5_usages_ef_m2" IS 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "emission_ges_5_usages_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."emission_ges_5_usages_m2" IS 'emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "classe_bilan_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."classe_bilan_dpe" IS 'Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "classe_emission_ges" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."classe_emission_ges" IS 'classe d''émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "classe_conso_energie_arrete_2012" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."classe_conso_energie_arrete_2012" IS 'classe d''émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "classe_emission_ges_arrete_2012" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."classe_emission_ges_arrete_2012" IS 'classe d''emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "conso_3_usages_ep_m2_arrete_2012" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."conso_3_usages_ep_m2_arrete_2012" IS 'consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "emission_ges_3_usages_ep_m2_arrete_2012" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."emission_ges_3_usages_ep_m2_arrete_2012" IS 'emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012 (kgCO2/m2/an).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_installation_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_installation_chauffage" IS 'type d''installation de chauffage (collectif ou individuel)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_energie_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_energie_chauffage" IS 'type d''énergie pour le générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_chauffage" IS 'type de générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_chauffage_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_chauffage_anciennete" IS 'ancienneté du générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_energie_chauffage_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_energie_chauffage_appoint" IS 'type d''énergie pour le générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_chauffage_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_chauffage_appoint" IS 'type de générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_chauffage_anciennete_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_chauffage_anciennete_appoint" IS 'ancienneté du générateur de chauffage d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "chauffage_solaire" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."chauffage_solaire" IS 'présence de chauffage solaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nb_generateur_chauffage" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nb_generateur_chauffage" IS 'nombre de générateurs de chauffage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nb_installation_chauffage" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nb_installation_chauffage" IS 'nombre d''installation de chauffage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_energie_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_energie_climatisation" IS 'type d''énergie pour le générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_climatisation" IS 'type de générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_climatisation_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_climatisation_anciennete" IS 'ancienneté du générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_installation_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_installation_ecs" IS 'type d''installation d''eau chaude sanitaire (ECS) (collectif ou individuel)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_energie_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_energie_ecs" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_ecs" IS 'type de générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_ecs_anciennete" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_ecs_anciennete" IS 'ancienneté du générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_energie_ecs_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_energie_ecs_appoint" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_ecs_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_ecs_appoint" IS 'type de générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_generateur_ecs_anciennete_appoint" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_generateur_ecs_anciennete_appoint" IS 'ancienneté du générateur d''eau chaude sanitaire (ECS) d''appoint';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "ecs_solaire" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."ecs_solaire" IS 'présence d''ecs solaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nb_generateur_ecs" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nb_generateur_ecs" IS 'nombre de générateurs d''ecs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "nb_installation_ecs" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."nb_installation_ecs" IS 'nombre d''installation d''ecs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "plusieurs_facade_exposee" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."plusieurs_facade_exposee" IS 'il est considéré dans le DPE qu''il y a plusieurs facades exposées au vent.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_ventilation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_ventilation" IS 'type de système de ventilation du logement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_production_energie_renouvelable" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_production_energie_renouvelable" IS 'type de production ENR pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_vitrage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_vitrage" IS 'type de vitrage principal des baies vitrées du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_materiaux_menuiserie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_materiaux_menuiserie" IS 'type de matériaux principal des menuiseries des baies vitrées du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_gaz_lame" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_gaz_lame" IS 'type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_fermeture" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_fermeture" IS 'type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "epaisseur_lame" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."epaisseur_lame" IS 'epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "vitrage_vir" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."vitrage_vir" IS 'le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d''un point de vue thermique.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_vitree_nord" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_vitree_nord" IS 'somme de la surface de baies vitrées orientées nord du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_vitree_sud" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_vitree_sud" IS 'somme de la surface de baies vitrées orientées sud du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_vitree_ouest" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_vitree_ouest" IS 'somme de la surface de baies vitrées orientées ouest du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_vitree_est" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_vitree_est" IS 'somme de la surface de baies vitrées orientées est du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_vitree_horizontal" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_vitree_horizontal" IS 'somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "traversant" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."traversant" IS 'indicateur du côté traversant du logement.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_baie_vitree" IS 'Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "uw" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."uw" IS 'Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "facteur_solaire_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."facteur_solaire_baie_vitree" IS 'facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "presence_balcon" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."presence_balcon" IS 'présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "l_orientation_baie_vitree" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."l_orientation_baie_vitree" IS 'liste des orientations des baies vitrées (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "pourcentage_surface_baie_vitree_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."pourcentage_surface_baie_vitree_exterieur" IS 'pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_isolation_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_isolation_mur_exterieur" IS 'type d''isolation principal des murs donnant sur l''extérieur pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "epaisseur_isolation_mur_exterieur_estim" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."epaisseur_isolation_mur_exterieur_estim" IS 'epaisseur d''isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d''une épaisseur déclarée c''est directement l''épaisseur déclarée qui est considérée, dans le cas contraire l''épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "materiaux_structure_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."materiaux_structure_mur_exterieur" IS 'matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "epaisseur_structure_mur_exterieur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."epaisseur_structure_mur_exterieur" IS 'epaisseur moyenne de la partie structure du mur (sans l''isolation rapportée ni les doublages)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_mur_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_mur_totale" IS 'somme de la surface de murs totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_mur_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_mur_exterieur" IS 'somme de la surface  surface de murs donnant sur l''extérieur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_mur_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_mur_deperditif" IS 'somme de la surface de murs donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_mur_exterieur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_mur_exterieur" IS 'Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "l_local_non_chauffe_mur" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."l_local_non_chauffe_mur" IS 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "local_non_chauffe_principal_mur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."local_non_chauffe_principal_mur" IS 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "l_orientation_mur_exterieur" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."l_orientation_mur_exterieur" IS 'liste des orientations des murs donnant sur l''extérieur (enum version BDNB)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_isolation_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_isolation_plancher_bas" IS 'type d''isolation principal des planchers bas déperditifs pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_plancher_bas_deperditif" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_plancher_bas_deperditif" IS 'materiaux ou principe constructif principal des planchers bas';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_plancher_bas_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_plancher_bas_totale" IS 'somme de la surface de plancher bas totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_plancher_bas_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_plancher_bas_deperditif" IS 'somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_plancher_bas_final_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_plancher_bas_final_deperditif" IS 'Coefficient de transmission thermique moyen des planchers bas en prenant en compte l''atténuation forfaitaire du U lorsqu''en contact avec le sol de la méthode 3CL(W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_plancher_bas_brut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_plancher_bas_brut_deperditif" IS 'Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "l_local_non_chauffe_plancher_bas" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."l_local_non_chauffe_plancher_bas" IS 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "local_non_chauffe_principal_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."local_non_chauffe_principal_plancher_bas" IS 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_adjacence_principal_plancher_bas" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_adjacence_principal_plancher_bas" IS 'type d''adjacence principale des planchers bas (sont ils en contact avec l''extérieur ou un local non chauffé)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_isolation_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_isolation_plancher_haut" IS 'type d''isolation principal des planchers hauts déperditifs pour le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_plancher_haut_deperditif" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_plancher_haut_deperditif" IS 'materiaux ou principe constructif principal des planchers hauts';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_plancher_haut_totale" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_plancher_haut_totale" IS 'somme de la surface de plancher haut totale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_plancher_haut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_plancher_haut_deperditif" IS 'somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_plancher_haut_deperditif" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_plancher_haut_deperditif" IS 'Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "l_local_non_chauffe_plancher_haut" varchar[];
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."l_local_non_chauffe_plancher_haut" IS 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "local_non_chauffe_principal_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."local_non_chauffe_principal_plancher_haut" IS 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_adjacence_principal_plancher_haut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_adjacence_principal_plancher_haut" IS 'type d''adjacence principale des planchers haut (sont ils en contact avec l''extérieur ou un local non chauffé)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "type_porte" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."type_porte" IS 'type de porte du DPE (enum version DPE 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "surface_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."surface_porte" IS 'somme de la surface de portes du DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "u_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."u_porte" IS 'Coefficient de transmission thermique moyen des portes (W/m²/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "classe_inertie" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."classe_inertie" IS 'classe d''inertie pour le DPE (de légère à très lourde)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_mur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_mur" IS 'somme des déperditions par les murs du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_baie_vitree" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_baie_vitree" IS 'somme des déperditions par les baies vitrées du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_plancher_bas" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_plancher_bas" IS 'somme des deperditions par les planchers bas du logement (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_plancher_haut" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_plancher_haut" IS 'somme des deperditions par les planchers hauts du logement (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_pont_thermique" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_pont_thermique" IS 'somme des deperditions par les portes du DPE (W/K)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_logement" ADD COLUMN "deperdition_porte" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_logement"."deperdition_porte" IS 'somme des deperditions par les portes du DPE (W/K)';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "dpe_tertiaire_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" IS 'Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l''ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l''ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d''une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d''information disponible est fortement réduit par rapport aux DPE logements.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "type_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."type_dpe_tertiaire" IS 'le DPE tertiaire applique l''arrêté de 2006 sur le DPE et n''a pas été revu depuis. Pour le moment cette colonne vaut toujours : ''dpe 2006 tertiaire et erp''';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "source_nouvelle_base_ademe" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."source_nouvelle_base_ademe" IS 'le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l''ancienne base de données (2012-2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "version" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."version" IS 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "date_etablissement_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."date_etablissement_dpe" IS 'date de l''établissement du dpe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "date_reception_dpe" timestamp with time zone;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."date_reception_dpe" IS 'date de réception du DPE dans la base de données de l''ADEME';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "annee_construction_dpe" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."annee_construction_dpe" IS 'année de construction du logement évaluée par le DPE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "shon" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."shon" IS 'surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "surface_utile" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."surface_utile" IS 'surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "classe_conso_energie_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."classe_conso_energie_dpe_tertiaire" IS 'classe de consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "classe_emission_ges_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."classe_emission_ges_dpe_tertiaire" IS 'classe d''emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_dpe_tertiaire_ep_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_dpe_tertiaire_ep_m2" IS 'consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "emission_ges_dpe_tertiaire_m2" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."emission_ges_dpe_tertiaire_m2" IS 'emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "categorie_erp_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."categorie_erp_dpe_tertiaire" IS 'categorie d''ERP du DPE tertiaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "periode_construction_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."periode_construction_dpe" IS 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "type_erp_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."type_erp_dpe_tertiaire" IS 'type d''ERP pour le DPE tertiaire, si l''usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n''est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "methode_application_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."methode_application_dpe_tertiaire" IS 'methode d''application du DPE tertiaire (facture, vierge ou neuf)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "sous_modele_dpe_tertiaire" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."sous_modele_dpe_tertiaire" IS 'sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "type_energie_chauffage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."type_energie_chauffage" IS 'type d''énergie pour le générateur de chauffage principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "type_energie_ecs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."type_energie_ecs" IS 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "type_energie_climatisation" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."type_energie_climatisation" IS 'type d''énergie pour le générateur de climatisation principal';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "derniere_annee_consommation" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."derniere_annee_consommation" IS 'dernière année de consommation utilisée pour le calcul du DPE tertiaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_autre_fossile" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_autre_fossile" IS 'consommation d''autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_bois" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_bois" IS 'consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_electricite" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_electricite" IS 'consommation d''électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_fioul" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_fioul" IS 'consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_gaz" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_gaz" IS 'consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_gpl_butane_propane" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_gpl_butane_propane" IS 'consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_reseau_chaleur" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_reseau_chaleur" IS 'consommation d''énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire" ADD COLUMN "conso_reseau_froid" FLOAT8;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."dpe_tertiaire"."conso_reseau_froid" IS 'consommation d''énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_construction_rnb_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" IS 'Table de relation entre les bâtiments construction de la BDNB et les entités du RNB (Référentiel National des Bâtiments), limitée à l’hexagone.

Dans la grande majorité des cas, un identifiant RNB correspond à un bâtiment construction de la BDNB, en raison de l’initialisation partielle du RNB à partir des données BDNB (relation 1 pour 1).

EXPERIMENTAL : Cette table est expérimentale. Une intégration plus poussée du RNB dans la BDNB est en cours, et la structure de cette relation est susceptible d’évoluer.';
SELECT AddGeometryColumn('bdnb_2025_07_a_open_data_dep01','rel_batiment_construction_rnb','geom_rnb_pos',2154,'POINT',2);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "rnb_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"."rnb_id" IS 'Identifiant unique de l''entrée RNB.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "type_appariement" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"."type_appariement" IS 'Type d''appariement entre les entrées `batiment_groupe_id` (BC) de la BDNB et `rnb_id` du RNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ADD COLUMN "detail" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb"."detail" IS 'Détail sur le type d''appariement';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" ("geom_rnb_pos", "rnb_id", "batiment_construction_id", "code_departement_insee", "type_appariement", "detail") FROM STDIN;
01010000206A080000A6E17366E6E2294127CBCC9C73095941	AZTJ3GFM1MAS	bdnb-bc-MB4V-Z5M4-49KH	01	Alignement 1 BC = 1 RNB, recouvrement géométrique ≥ 95%	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_bdtopo_bat_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" IS 'Table de relation entre les bâtiments de la BDNB et les éléments de la table bâti de la BDTOPO';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ADD COLUMN "bdtopo_bat_cleabs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat"."bdtopo_bat_cleabs" IS 'identifiant de la table bâtiment de la BDTOPO';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat"."code_departement_insee" IS 'Code département INSEE';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_bat" ("batiment_construction_id", "bdtopo_bat_cleabs", "batiment_groupe_id", "code_departement_insee") FROM STDIN;
bdnb-bc-8JTW-FW8N-QX52	BATIMENT0000000258495668	bdnb-bg-111J-YU68-VJ8Z	01
bdnb-bc-MB4V-Z5M4-49KH	BATIMENT0000000258495669	bdnb-bg-111J-YU68-VJ8Z	01
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_bdtopo_equ_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" IS 'Table de relation entre les bâtiments de la BDNB et les éléments de la table equipement de la BDTOPO';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" ADD COLUMN "bdtopo_equ_cleabs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ"."bdtopo_equ_cleabs" IS 'identifiant de la table equipement de la BDTOPO';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_equ"."code_departement_insee" IS 'Code département INSEE';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_bdtopo_zoa_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" IS 'Table de relation entre les bâtiments de la BDNB et les éléments de la table des zones d''activité de la BDTOPO';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" ADD COLUMN "bdtopo_zoa_cleabs" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa"."bdtopo_zoa_cleabs" IS 'identifiant de la table argiles';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bdtopo_zoa"."code_departement_insee" IS 'Code département INSEE';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_bpe_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" IS 'Table de relation entre les bâtiments de la BDNB et les éléments de la table bpe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe" ADD COLUMN "bpe_non_officiel_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_bpe"."bpe_non_officiel_id" IS 'identifiant de la table bpe';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_dpe_logement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" IS 'Table de relation entre les groupes de bâtiments de la BDNB et les éléments des deux bases de données DPE (arrêté 2012 et arrêté 2021).  
Les deux bases sont compilées dans cette table. Il est possible de filtrer avec la colonne `arrete_2021` (table `dpe_logement`) pour ne conserver que les nouveaux DPE.

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `dpe_logement` (qui contient l’intégralité des DPE).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "adresse_brut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."adresse_brut" IS 'adresse brute envoyée au géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "adresse_geocodee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."adresse_geocodee" IS 'libelle de l''adresse retournée par le géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "fiabilite_geocodage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."fiabilite_geocodage" IS 'fiabilité du géocodage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement" ADD COLUMN "type_appariement" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_logement"."type_appariement" IS 'méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l''identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l''ensemble des méthodes utilisées pour l''appariement';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_dpe_tertiaire_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" IS 'Table de relation entre les bâtiments de la BDNB et les éléments des deux bases de données DPE tertiaire de l’ADEME (avant 2021 et après 2021).  

Contrairement aux DPE logement, les deux bases sont ici compilées car aucune évolution réglementaire majeure n’a concerné les DPE tertiaires.  
Il n’est donc pas nécessaire de filtrer entre ancien ou nouveau DPE tertiaire

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `dpe_tertiaire` (qui contient l’intégralité des DPE).
-';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "identifiant_dpe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."identifiant_dpe" IS 'identifiant unique des DPE de l''ADEME.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "adresse_brut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."adresse_brut" IS 'adresse brute envoyée au géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "adresse_geocodee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."adresse_geocodee" IS 'libelle de l''adresse retournée par le géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "fiabilite_geocodage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."fiabilite_geocodage" IS 'fiabilité du géocodage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire" ADD COLUMN "type_appariement" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dpe_tertiaire"."type_appariement" IS 'méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l''identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l''ensemble des méthodes utilisées pour l''appariement';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_dvf_open_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" IS 'Table de relation entre les batiment_groupe de la BDNB et l''ensemble des mutations ayant eu lieu sur ce bâtiment groupe
Les mutations foncières sont identifiées par leur identifiant open_data diffusé dans le jeu de données du CEREMA DVF+ open data(https://datafoncier.cerema.fr/donnees/autres-donnees-foncieres/dvfplus-open-data)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "id_opendata" VARCHAR(60);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."id_opendata" IS 'Identifiant open data de la mutation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "fiabilite_croisement" VARCHAR(10);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."fiabilite_croisement" IS 'Fiabilité de l''appariement entre les bâtiments groupes et les mutations. La fiabilité est forte si l''ensemble des locaux de la mutation se situent sur un unique bâtiment groupe. La fiabilité est faible si les locaux de la mutation ne peuvent être associés à un unique bâtiment groupe.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "join_id_opendata" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."join_id_opendata" IS 'L''appariement a été réalisé à partir de l''id_opendata en le croisant avec les dv3f.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open" ADD COLUMN "join_geom_local" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_dvf_open"."join_geom_local" IS 'L''appariement a été réalisé à partir de la présence du localisant ponctuel du local ayant muté au sein de la géométrie de la parcelle unifiée.';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_merimee_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" IS '[TABLE DEPRECIEE] : Table de relation entre les bâtiments de la BDNB et les éléments de la table merimee';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "merimee_ref" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"."merimee_ref" IS 'identifiant de la table merimee';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee" ADD COLUMN "distance_batiment_historique" SMALLINT;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_merimee"."distance_batiment_historique" IS '(mer) Distance entre le batiment_historique et le batiment_construction (si moins de 500m) [m]';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_qpv_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" IS 'DEPRECIEE  -> utiliser uniquement la table batiment_groupe_qpv .Table de relation entre les bâtiments de la BDNB et les éléments de la table QPV';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" ADD COLUMN "batiment_construction_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv"."batiment_construction_id" IS 'Identifiant unique de l''entrée batiment_construction.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" ADD COLUMN "qpv_code_qp" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv"."qpv_code_qp" IS 'identifiant de la table qpv';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_qpv"."code_departement_insee" IS 'Code département INSEE';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_batiment_groupe_rnc_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" IS 'Table de relation entre les bâtiments de la BDNB et les éléments de la table RNC';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "batiment_groupe_id" VARCHAR(22);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."batiment_groupe_id" IS 'Identifiant du groupe de bâtiment au sens de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "numero_immat" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."numero_immat" IS 'identifiant de la table rnc';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "cle_interop_adr" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."cle_interop_adr" IS 'Clé d''interopérabilité de l''adresse postale';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "adresse_brut" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."adresse_brut" IS 'adresse brute envoyée au géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "adresse_geocodee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."adresse_geocodee" IS 'libelle de l''adresse retournée par le géocodeur';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "fiabilite_geocodage" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."fiabilite_geocodage" IS 'fiabilité du géocodage';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "fiabilite_globale" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."fiabilite_globale" IS 'fiabilité du global du croisement';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc" ADD COLUMN "parcelle_id" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_rnc"."parcelle_id" IS '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "rel_parcelle_sitadel_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" IS 'Table de relation entre les identifiants des parcelles et les identifiants de demande d''autorisation d''urbanisme (DAU)
de la base de données Sitadel.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "type_numero_dau" VARCHAR(15);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."type_numero_dau" IS 'Concatenation du type de demande d''autorisation d''urbanisme (DAU) et le numéro de DAU.
Combinaisons possibles : 
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro 
  DAU` ou `DP + numéro DAU`
- permis de démolir (PD) > `PD + numéro DAU`
- permis d''aménager (PA) > `PA + numéro DAU`';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "parcelle_id" VARCHAR(14);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."parcelle_id" IS '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "dau_monoparcelle" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."dau_monoparcelle" IS 'Indique si la demande d''autorisation d''urbanisme (DAU) ne concerne qu''une unique parcelle.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "type_appariement" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."type_appariement" IS 'Type de croisement final. Prend les valeurs ''parcelle'', ''adresse'', ''parcelle + adresse'' ou ''non apparie''.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ADD COLUMN "fiabilite_appariement" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel"."fiabilite_appariement" IS 'Fiabilité du croisement des données d''autorisation d''urbanisme SITADEL avec la BDNB, prend les valeurs - ''très 
fiable'' ou ''fiable''.';
COPY "bdnb_2025_07_a_open_data_dep01"."rel_parcelle_sitadel" ("type_numero_dau", "parcelle_id", "code_departement_insee", "dau_monoparcelle", "type_appariement", "fiabilite_appariement") FROM STDIN;
DP00100120V0011	01001000ZM0028	01	1	parcelle	très fiable
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "sitadel_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" IS 'Table de compilation des données Sitadel, cela inclut l''ensemble des demandes d''autorisation d''urbanisme (DAU) :
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux, 
- permis de démolir (PD)
- permis d''aménager (PA).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_numero_dau" VARCHAR(15);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_numero_dau" IS 'Concatenation du type de demande d''autorisation d''urbanisme (DAU) et le numéro de DAU.
Combinaisons possibles : 
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro 
  DAU` ou `DP + numéro DAU`
- permis de démolir (PD) > `PD + numéro DAU`
- permis d''aménager (PA) > `PA + numéro DAU`';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "code_departement_insee" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "creation_local" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."creation_local" IS 'Demande d''autorisation d''urbanisme spécifique pour la création de locaux.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "creation_logement" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."creation_logement" IS 'Demande d''autorisation d''urbanisme spécifique pour la création de logements.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "permis_demolir" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."permis_demolir" IS 'Demande d''autorisation d''urbanisme spécifique pour réaliser une démolition.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "permis_amenager" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."permis_amenager" IS 'Demande d''autorisation d''urbanisme spécifique pour réaliser un aménagement.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "etat_avancement_projet" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."etat_avancement_projet" IS 'Etat d''avancement du projet (Autorisé, Commencé, Terminé). Les projets annulés ne sont pas contenus dans cette 
compilation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "date_reelle_autorisation" date;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."date_reelle_autorisation" IS 'Date réelle d''autorisation (Permis de Construire) ou de non-opposition (Déclaration Préalable) initiale. Date de décision relative à la demande initiale, sans prise en compte d''éventuels modificatifs.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "date_reelle_ouverture_chantier" date;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."date_reelle_ouverture_chantier" IS 'Date réelle d''ouverture de chantier.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "date_reelle_achevement_travaux" date;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."date_reelle_achevement_travaux" IS 'Date réelle d''achèvement des travaux.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "annee_depot_dau" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."annee_depot_dau" IS 'Année de dépôt de la demande d''autorisation d''urbanisme.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "dpc_derniere_maj" date;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."dpc_derniere_maj" IS 'Date (mois) de prise en compte (DPC) de dernière mise à jour des données.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "code_activite_principale_demandeur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."code_activite_principale_demandeur" IS 'Code d''activité principale de l''établissement d''un demandeur (maître d''ouvrage) avéré en tant que personne morale - Nomenclature Naf Rév2';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "categorie_juridique_demandeur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."categorie_juridique_demandeur" IS 'Catégorie juridique d''un demandeur (maître d''ouvrage) avéré en tant que personne morale - Nomenclature Sirène.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "denomination_demandeur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."denomination_demandeur" IS 'Dénomination d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "siren_demandeur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."siren_demandeur" IS 'Numéro SIREN d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "siret_demandeur" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."siret_demandeur" IS 'Numéro SIRET d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "superficie_terrain" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."superficie_terrain" IS 'Superficie du terrain.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "nature_projet" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."nature_projet" IS 'Nature de projet détaillée : 
- nouvelle construction, 
- travaux sur construction existante
    * transformation sans extension ni diminution de surface (inclut les changements de destination, réhabilitations, scissions/regroupements de logements ...), 
    * transformation avec extension de surface, 
    * transformation avec diminution de surface, 
    * extension de surface sans transformation, 
    * diminution de surface sans transformation
N.B. Il s''agit du projet complété ou par défaut du projet déclaré';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "destination_principale" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."destination_principale" IS 'Destination principale des surfaces créées : 
- résidentiel, 
- non résidentiel
  * hébergement hôtelier, 
  * bureaux, 
  * commerce,
  * artisanat, 
  * industrie, 
  * agriculture, 
  * entrepôt, 
  * service public ou d''intérêt collectif
N.B. Quand le détail du non résidentiel n''est pas donnée, seulement est indiqué ''non résidentiel'', sinon, les 
    catégories sont détaillées.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_princip_logts_crees" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_princip_logts_crees" IS 'Type principal des logements créés :
- un logement individuel,
- plusieurs logements individuels,
- collectif hors résidence,
- résidence
N.B. Type principal selon le nombre de logements créés : il peut donc y avoir des logements individuels dans un permis de type "collectif hors résidences"';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_transfo_principal" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_transfo_principal" IS 'Type principal de transformation :
- transformation de locaux en logements (changement de destination), 
- transformation de logements (réhabilitation, scission, regroupement ...), 
- transformation de logements en locaux non résidentiels (changement de destination), 
- transformation de locaux non résidentiels (changement de destination, réhabilitation, scission, regroupement ...)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_princip_locaux_transformes" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_princip_locaux_transformes" IS 'Type principal des locaux d''origine transformés :
- résidentiel, 
- non résidentiel, 
  * hébergement hôtelier, 
  * bureaux, 
  * commerce, 
  * artisanat, 
  * industrie, 
  * agriculture, 
  * entrepôt, 
  * service public ou d''intérêt collectif
N.B. Quand le détail du non résidentiel n''est pas donnée, seulement est indiqué ''non résidentiel'', sinon, les catégories sont détaillées.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "indicateur_extension" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."indicateur_extension" IS 'Indicateur pour la présence d''une extension.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "indicateur_surelevation_ou_nivsupp" BOOLEAN;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."indicateur_surelevation_ou_nivsupp" IS 'Indicateur pour la présence d''une surélévation ou d''un niveau supérieur.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "residence_princip_ou_second" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."residence_princip_ou_second" IS 'Type d''habitation principale ou secondaire. Valable que si occupation personnelle :
- résidence principale
- résidence secondaire';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_annexe" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_annexe" IS 'Type d''annexe
- Piscine, 
- Garage, 
- Véranda, 
- Abri de Jardin, 
- Autre annexe, 
- plusieurs annexes,
- pas d’annexe';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "residence" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."residence" IS 'Type de résidence 
- res pour personnes âgées, 
- res étudiantes, 
- res de tourisme,
- res hôtelière à vocation sociale,
- res sociale, 
- res pour handicapés, 
- autre res, 
- projet mixte, 
N.B.: Pour les projets mixtes (logements ordinaires / résidence), traitement interne Sitadel pour ce que cette 
catégorie ne soit définie que si la résidence représente la majorité des logements du projet.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "nb_log_tot_crees" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."nb_log_tot_crees" IS 'Nombre total de logements créés.
N.B.: Une transformation d''un 3 pièces en 2 studios est généralement considérée comme créant 2 logements.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "nb_log_individuels_crees" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."nb_log_individuels_crees" IS 'Nombre de logements individuels créés.
N.B.: Une maison individuelle peut comporter 2 logements individuels (au maximum).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "nb_log_collectifs_crees" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."nb_log_collectifs_crees" IS 'Nombre de logements collectifs créés.
N.B.: Les logements collectifs font partie d’un bâtiment dans lequel sont superposés plus de deux logements distincts 
dont l''accès nécessite d''emprunter des parties communes.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "nb_log_demolis" INTEGER;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."nb_log_demolis" IS 'Nombre de logements démolis.
N.B. Insuffisamment renseigné.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_hab_avant" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_hab_avant" IS 'Surface de plancher de la destination '' Habitation '' existante avant travaux';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_hab_creee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_hab_creee" IS 'Surface de plancher de la destination '' Habitation '' nouvelle construite.
N.B.: Lorsque le projet crée des chambres (sans coin cuisine indépendant) et non des logements, on utilise plutôt la 
destination "Hébergement hôtelier" ou "Service Public" dans Sitadel plutôt que la destination "Habitation".';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_hab_issue_transfo" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_hab_issue_transfo" IS 'Surface de plancher de la destination '' Habitation '' issue d''une transformation (changement de destination, 
réhabilitation, scission, regroupement …).
N.B.: Surface issue d''un changement de destination ou d''un mouvement interne (cas où les surfaces supprimée et créée 
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_hab_demolie" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_hab_demolie" IS 'Surface de plancher de la destination '' Habitation '' supprimée (démolie)';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_hab_transformee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_hab_transformee" IS 'Surface de plancher de la destination '' Habitation '' transformée (changement de destination, réhabilitation, 
scission, regroupement ...).
N.B.: Surface issue d''un changement de destination ou d''un mouvement interne (cas où les surfaces supprimée et créée 
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_loc_avant" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_loc_avant" IS 'Surface de plancher de locaux non résidentiels existante avant travaux.
Total des surfaces des destinations autres que d''habitation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_loc_creee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_loc_creee" IS 'Surface de plancher de locaux non résidentiels nouvelle construite.
Total des surfaces des destinations autres que d''habitation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_loc_issue_transfo" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_loc_issue_transfo" IS 'Surface de plancher de locaux non résidentiels issue d''une transformation (changement 
de destination, réhabilitation, scission, regroupement …).
Total des surfaces des destinations autres que d''habitation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_loc_demolie" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_loc_demolie" IS 'Surface de plancher de locaux non résidentiels démolie.
Total des surfaces des destinations autres que d''habitation';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "s_loc_transformee" NUMERIC(17,3);
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."s_loc_transformee" IS 'Surface de plancher de locaux non résidentiels transformée (changement de destination,
réhabilitation, scission, regroupement ...).
Total des surfaces des destinations autres que d''habitation.';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."sitadel" ADD COLUMN "type_service_public" VARCHAR;
COMMENT ON COLUMN "bdnb_2025_07_a_open_data_dep01"."sitadel"."type_service_public" IS 'Type de service public ou d''intérêt collectif : 
- Transport, 
- Enseignement et recherche, 
- Santé, 
- Action sociale, 
- Ouvrage spécial, 
- Culture et loisir, 
- Plusieurs types renseignés';
COPY "bdnb_2025_07_a_open_data_dep01"."sitadel" ("type_numero_dau", "code_departement_insee", "code_commune_insee", "creation_local", "creation_logement", "permis_demolir", "permis_amenager", "etat_avancement_projet", "date_reelle_autorisation", "date_reelle_ouverture_chantier", "date_reelle_achevement_travaux", "annee_depot_dau", "dpc_derniere_maj", "code_activite_principale_demandeur", "categorie_juridique_demandeur", "denomination_demandeur", "siren_demandeur", "siret_demandeur", "superficie_terrain", "nature_projet", "destination_principale", "type_princip_logts_crees", "type_transfo_principal", "type_princip_locaux_transformes", "indicateur_extension", "indicateur_surelevation_ou_nivsupp", "residence_princip_ou_second", "type_annexe", "residence", "nb_log_tot_crees", "nb_log_individuels_crees", "nb_log_collectifs_crees", "nb_log_demolis", "s_hab_avant", "s_hab_creee", "s_hab_issue_transfo", "s_hab_demolie", "s_hab_transformee", "s_loc_avant", "s_loc_creee", "s_loc_issue_transfo", "s_loc_demolie", "s_loc_transformee", "type_service_public") FROM STDIN;
PC00100113V0003	01	01001	0	1	0	0	Commencé	2013/09/20	2013/11/26	\N	2013	2013/12/01	\N	\N	\N	\N	\N	644.000	nouvelle construction	résidentiel	un logement individuel	\N	\N	0	0	résidence principale	Garage	\N	1	1	0	0	0.000	105.000	0.000	0.000	0.000	0.000	0.000	0.000	0.000	0.000	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "metadonnees_bdnb_version_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" IS 'Descriptions des tables de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "millesime" VARCHAR(9);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "version" VARCHAR(7);
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "date_publication" date;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "changelog_rapide" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ADD COLUMN "changelog_detaille" VARCHAR;
COPY "bdnb_2025_07_a_open_data_dep01"."metadonnees_bdnb_version" ("millesime", "version", "date_publication", "changelog_rapide", "changelog_detaille") FROM STDIN;
2025-07.a	v0.7.10	2025/11/20	usages détaillés des bâtiments + mise à jour fichiers fonciers 2024 / maj ban/ maj BDTOPO	# CHANGELOG 2025-07.a\\n\\n## Nouveautés générales\\n\\n⚠️ : des changements ont eu lieu dans deux versions mineures 2024.10.b et 2024.10.c non publiées en open data en plus des changements décrits ici, n\\'oubliez pas de les consulter à la suite de cette section. \\n\\n## Mise à jour des données sources\\n\\n\\n| Fournisseur de données | Jeu de données | Millésime |\\n| :--------: | -------- | :--------: |\\n| ADEME      | [Diagnostic de Performance Energétique (DPE)](https://data.ademe.fr/datasets/dpe03existant)    | 2025-09  |\\n| ANAH     | [Registre National des Copropriétés (RNC)](https://www.data.gouv.fr/fr/datasets/registre-national-dimmatriculation-des-coproprietes/)     | 2025-T3     |\\n| ARCEP     | [Base immeuble](https://data.arcep.fr/fixe/maconnexioninternet/base_imb/index.html)     | 2025-09     |\\n| CEREMA     | [Fichiers Fonciers](https://datafoncier.cerema.fr/fichiers-fonciers)  | 2024     |\\n| CEREMA     | [Données Valeurs Foncières (DVF)](https://datafoncier.cerema.fr/donnees/autres-donnees-foncieres/dvfplus-open-data)     | 2025-04     |\\n| DGFIP     | [MAJIC Personne Morale](https://www.data.gouv.fr/datasets/fichiers-des-locaux-et-des-parcelles-des-personnes-morales/)   | 2024     |\\n| MTE | [Répertoire des logements locatifs des bailleurs sociaux (RPLS)](https://www.data.gouv.fr/fr/datasets/repertoire-des-logements-locatifs-des-bailleurs-sociaux/) | 2024     |\\n| IGN | [Base d\\'Adresse Nationale (BAN)](https://adresse.data.gouv.fr/data/ban/adresses/latest/addok) | 2025-07 |\\n| France Chaleur Urbaine | [Réseau de Chaleur Urbain (RCU)](https://www.data.gouv.fr/fr/datasets/traces-des-reseaux-de-chaleur-et-de-froid/)  | 2025-07 |\\n| MCT/IGN | [Géoportail de l\\'Urbanisme](https://data.geopf.fr/telechargement/resource/pack_psmv)  | 2025-07  |\\n| Georisques | [Retrait-Gonflement des Argiles (RGA)](https://www.georisques.gouv.fr/donnees/bases-de-donnees/retrait-gonflement-des-argiles)  | 2025-09     |\\n| IGN | [BDTOPO](https://geoservices.ign.fr/bdtopo#telechargementsqlfra)  | 2025-06-15     |\\n| INSEE | [Code Officiel Géographique (COG)](https://www.insee.fr/fr/information/8377162)  | 2025 |\\n| INSEE | [Base permanente des équipements (BPE)](https://www.insee.fr/fr/statistiques/8217525?sommaire=8217537)  | 2024     |\\n| INSEE | [Base SIRENE](https://www.data.gouv.fr/datasets/base-sirene-des-entreprises-et-de-leurs-etablissements-siren-siret/)  | 2025-07     |\\n| MCU | [Immeubles protégés au titre des Monuments Historiques (MERIMEE)](https://data.culture.gouv.fr/api/explore/v2.1/catalog/datasets/liste-des-immeubles-proteges-au-titre-des-monuments-historiques/)  | 2025-09     |\\n| MTE | [SITADEL](https://www.statistiques.developpement-durable.gouv.fr/catalogue?page=dataset&datasetId=6513f0189d7d312c80ec5b5b)  | 2025-06     |\\n| MTE | [Données Locales de l\\'Energie (DLE)](https://www.statistiques.developpement-durable.gouv.fr/donnees-locales-de-consommation-denergie)  | 2024     |\\n| SPM | [Annuaire de l\\'Administration](https://www.data.gouv.fr/fr/datasets/service-public-fr-annuaire-de-l-administration-base-de-donnees-locales)  | 2025-03     |\\n| RNB | [Référentiel National des Bâtiments (RNB)](https://www.data.gouv.fr/fr/datasets/referentiel-national-des-batiments/)  | 2025-07     |\\n\\n\\n## Tables expérimentales\\n\\nAjout et documentation d\\'un nouveau type de tables dans la BDNB : les tables expérimentales sont des tables contenant des produits de R&D bénéficiant d\\'évolutions importantes. Pour ces tables il n\\'est pas garanti un contrat d\\'API stable à ce stade.\\n\\nLes tables concernées sont les suivantes : \\n\\n* (bdnb expert) batiment_groupe_simulations_isb\\n* (bdnb expert) batiment_groupe_imputation_enveloppe_et_systemes_proba\\n\\n## ⚠️ BREAKING CHANGES ⚠️\\n\\n(bdnb expert) batiment_groupe_simulations_isb : \\n\\n* la table batiment_groupe_simulations_isb qui avait précédemment une double clef primaire (batiment_groupe_id-type_niveau) change pour n\\'avoir une clef primaire uniquement \\n\\n* les colonnes ont été toutes modifiées pour préciser la météo utilisée pour réaliser le calcul de degré heure en prévision de l\\'arrivée de nouveaux indicateurs pour d\\'autres météos prospectives dans un futur millésime à paraitre \\n\\n* (bdnb open) : suppression des colonnes lien_valide et classe dans rel_batiment_groupe_adresse (colonne dépréciée depuis 2 millésimes)\\n\\n* batiment_groupe_rnc (partie convention ANAH)\\n  * suppression des colonnes ayant_droit_rnic\\n\\n## Nouveautés\\n\\n\\n* **(bdnb ayant droit) rel_batiment_groupe_usage :**  (nouvelle table)\\n\\nTable contenant l’ensemble des usages détaillés de chaque bâtiment avec leurs surfaces et nombre de locaux associés (si disponibles).\\n\\nSources :\\nCette table compile des informations issues :\\n- des fichiers fonciers\\n- de la BDTOPO (zones d’activité)\\n- de la base SIRENE (entreprises)\\n- et de nombreuses bases recensant des usages publics des bâtiments harmonisées dans le cadre du projet collaboratif ESPACE avec le CEREMA :\\n  - annuaire de l’administration\\n  - base des équipements sportifs\\n  - annuaire de l’éducation,\\n  - base FINESS (ministère de la santé),\\n  - patrimoine immobilier de l’enseignement supérieur,\\n  - base BASILIC (lieux et équipements culturels),\\n  - crèches,\\n  - gares ferroviaires.\\n\\npour plus d\\'informations sur cette table, vous pouvez consulter l\\'article dédié sur notre site (https://bdnb.io/documentation/usage_detaille_bdnb/)\\n\\n* **(bdnb ayant droit) batiment_groupe_synthese_propriete_usage :** \\n  * ajout des colonnes usage_niveau_2_bdnb et usage_niveau_3_bdnb qui fournissent l\\'usage principal détaillé du bâtiment, cette donnée est pour l\\'instant exposée uniquement aux ayants droit fichiers fonciers. \\n\\n\\n* **(bdnb expert) batiment_groupe_urbanisme :** ajout des contraintes patrimoniales d\\'urbanismes locales établies dans les PLU\\n\\n* ⚠️ **(bdnb expert) batiment_groupe_simulations_dpe/local_simulations_dpe :** ⚠️ : les simulations DPE intègrent dès à présent le calcul du DPE avec le coefficient d\\'énergie primaire pour le vecteur *électricité* à 1.9. Ce changement majeur qui rentrera en vigueur officiellement au 1er janvier 2026 réduit de manière importante le nombre de passoires énergétiques évalué par le dispositif DPE. (source : https://rt-re-batiment.developpement-durable.gouv.fr/faq-dpe-modification-du-facteur-de-conversion-en-a1021.html?lang=fr)\\n\\n## Améliorations diverses\\n\\n* **(bdnb open) tous bâtiments :** certains locaux fichiers fonciers n\\'étaient pas proprement intégrés dans des bâtiments de la BDNB ceci est désormais résolu. Des tests d\\'intégration ont été mis en place pour palier ces anciens écueils.\\n* **(bdnb open) tous bâtiments :** traitement pour rendre valides certaines géométries non valides du cadastre pour ne pas les perdre dans la BDNB.\\n* **(bdnb open) tous bâtiments :** amélioration de la prise en compte de la position de l\\'adresse associée à un bâtiment foncier pour son attribution à un groupe de bâtiment. En conséquence, un nombre de *bâtiment groupe* plus important est constitué d\\'un seul *bâtiment construction*, améliorant la précision de définition des bâtiments dans la BDNB \\n* **(bdnb open) tous bâtiments :** amélioration des méthodes d\\'association des adresses aux batiment_construction et batiment_groupe en combinant des approches géométriques et de rapprochement d\\'adresses fiscales avec des adresses BAN et corrections de bugs mineurs. En conséquence, les tables BDNB de relations bâtiment-adresse" sont plus fiables qu\\'avant. \\n* **(bdnb open) tous bâtiments :** reclassification de bâtiments à usage indéterminé en dépendance lorsque l\\'information fiscale est disponible pour une majorité de parcelles cadastrales accueillant un bâtiment résidentiel et d\\'autres constructions physiques.\\n* **(bdnb open) tous bâtiments :** Améliorations diverses sur la qualification des usages de bâtiments. Notamment entre maisons individuelles et bâtiments d\\'habitation collective.\\n* **(bdnb open) tous bâtiments :** requalification des bâtiments BDTOPO qualifiés comme *léger* par l\\'IGN lorsqu\\'ils correspondent à des usages de bâtiments "lourds" (logement bureau etc.) dans les données foncières.\\n* **(bdnb ayant droit) parcelle_unifiee** : les unités foncières (TUP) non bâties n\\'étaient pas proprement intégrées dans la BDNB. Cela est désormais corrigé.\\n* **(bdnb ayant droit) parcelle_unifiee_metrique** : corrections de multiples bugs sur les métriques des parcelles unifiées. L\\'ensemble des quantitatifs affichés sont à présent corrects.\\n* **(bdnb open) tables DPE :** les DPE sont géolocalisés à l\\'aide de leur position RNB et parcelle en complément des adresses. Pour les géolocalisations RNB cela ne concerne que les géolocalisations renseignées par les diagnostiqueurs.\\n* **(bdnb expert) batiment_groupe_simulations_isb** : correction d\\'un bug qui empéchait le calcul de l\\'indicateur de surchauffe bâtiment pour certains IRIS sans logements collectifs.\\n* **(bdnb expert) batiment_groupe_simulations_isb** : ajout des apports solaires pour le calcul de l\\'indicateur de surchauffe bâtiment.\\n* **(bdnb open) contexte administratif :** Ajout de la couche d\\'information géographique sur les *cantons* selon les définitions du COG de l\\'année courante.\\n"
2024-10.c	v0.7.9	2025/06/30	DPE tertiaire + sytème de chauffage tertiaire + données d'imputations des systèmes logement	\\n# CHANGELOG 2024-10c\\n\\n## Nouveautés Générales\\n\\n* ajout des données issues des DPE tertiaires  (BDNB open)\\n* ajout d'une table d'imputation des performances de l'enveloppe et des systèmes pour les logements (utilisateurs avancés)  (BDNB expert)\\n\\n## tables ajoutées\\n\\n* **batiment_groupe_dpe_tertiaire :** (bdnb open) données sur le DPE tertiaire le plus récent du groupe de bâtiment\\n* **dpe_tertiaire :** tous les DPE tertiaires (bdnb open)(de 2014 à aujourd'hui)\\n\\n* **batiment_groupe_synthese_systeme_energetique_tertiaire :** (bdnb expert) données sur les systèmes énergétiques dans le tertiaire, initialisée avec les DPE tertiaires, les données locales de l'énergie et les tracés de réseau de chaleur pour cette première version.\\n\\n* **batiment_groupe_imputation_enveloppe_et_systemes_proba :** (bdnb expert) données de prédiction probabiliste des systèmes énergétique et de la performance d'isolation pour les bâtiments de logements. Ce sont les données probabilistes en entrée de nos simulations DPE.  (https://bdnb.io/documentation/predictions_dpe/)\\n\\n\\n## améliorations\\n\\n* **fix :** type_energie_ecs était null sur toutes les lignes pour les DPE logements -> corrigé\\n* **fix :** les DPE désactivés sont désormais correctement supprimés des tables DPE\\n* **fix :** les installations photovoltaiques déclarées sans production positives ne sont plus considérées commes des installations photovoltaique pour les DPE logement\\n
2024-10.b	v0.7.8	2025/03/17	mise à jour RPLS 2024 + table risques, urbanisme, contrainte opportunité rénovation	\\n# CHANGELOG 2024-10b\\n\\n## Nouveautés Générales\\n\\n* données de contraintes d'urbanismes : sites patrimoniaux et périmètres monuments historiques (BDNB open/expert)\\n* données de contraintes/opportunité à la rénovation : pompes à chaleur dans le résidentiel collectif (BDNB expert)\\n* aléa sismique (BDNB open)\\n* classe famille incendie, classe hauteur risques sismiques (BDNB expert)\\n* mise à jour RPLS 2024 \\n\\n## tables ajoutées\\n\\n* batiment_groupe_urbanisme (bdnb open/expert) : première version d'une table qui fourni des contraintes et réglementations d'urbanismes sur les bâtiments. Cette table intègre dans cette première version des informations sur les zonages patrimoniaux. Cette table remplace la table batiment_groupe_merimee sur les bâtiments historiques qui est dépréciée. \\n\\n\\t* bâtiments dans un périmètre AC2, AC4 : sites patrimoniaux remarquables et sites méritant d'être protégés (expert)\\n\\t* bâtiments dans un périmètre AC1 : périmètre autour des monuments historiques (open)\\n\\t* bâtiments qui sont eux mêmes des bâtiments classés au titre des monuments historiques. (open)\\n\\n* batiment_groupe_contrainte_opportunite_renovation : première version d'une table qui fourni des éléments d'opportunités, de contraintes et de faisabilité sur des gestes de rénovation. Dans cette première version les données disponibles concernent les pompes à chaleur dans le résidentiel collectif\\n\\n\\t* indicateur de faisabilité de mise en place d'une solution de pompe à chaleur sur chaque bâtiment résidentiel collectif\\n\\t* sous indicateurs qui détaillent les principaux critères qui sont pris en compte pour définir cette faisabilité de mise en place d'une pompe à chaleur. \\n\\n* batiment_groupe_risques : table qui regroupe toutes les données d'aléa et de vulnérabilité au risque des bâtiments. Dans cette première version cette table centralise les aléa argiles, radon, sismique ainsi que les classe de réglementation incendie et sismiques. \\n\\n## tables dépréciées\\n\\n* les table batiment_groupe_argiles et batiment_groupe_radon sont dépréciées au profit de la table batiment_groupe_risques\\n* la table batiment_groupe_merimee est dépréciée au profit de la table batiment_groupe_urbanisme. \\n
2024-10.a	v0.7.7	2025/02/12	indicateur surchauffe des bâtiments + intégration des données sitadel +fichiers fonciers 2023 / maj ban/ maj BDTOPO	\\n# Changelog BDNB 2024-10a\\n\\n## Nouveautés générales:\\n\\n* Ajout de nouveaux indicateurs d\\'usages des bâtiments plus complet dans batiment_groupe_synthese_propriete_usage\\n* Indicateur de surchauffe estivale évalué sur tous les bâtiments résidentiels (BDNB expert)\\n* Mise à disposition des données SITADEL (permis de construire) dans deux nouvelles tables\\n* Mise à jour des données socles :  fichiers fonciers (2023) + BDTOPO (2024-08) + BAN (2024-10)\\n* Mise à jour de la plupart des sources de données (consulter le fichier de documentation onglet source)\\n\\n\\n## Ajouts de tables\\n\\n* **batiment_groupe_synthese_propriete_usage :** nouvelle table qui contient des indicateurs d\\'usages consolidées en utilisant de multiples sources en plus des fichiers fonciers.\\n    *  usage_principal_bdnb_open : nouvelle variable d\\'usage principal du bâtiment à utiliser au lieu de usage_niveau_1_txt :\\n        * Résidentiel individuel\\n        * Résidentiel collectif\\n        * Tertiaire\\n        * Secondaire\\n        * Dépendance\\n        * Indifférencié\\n    *  categorie_usage_propriete : classification du bâtiment utilisant des informations d\\'usage et de propriété : \\n        *  Résidentiel individuel social\\n        *  Résidentiel individuel privé\\n        *  Résidentiel collectif social\\n        *  Résidentiel collectif copropriété\\n        *  Tertiaire public\\n        *  Tertiaire privé\\n        *  Secondaire\\n        *  Dépendance\\n* **sitadel et parcelle_sitadel :** nouvelles tables disponibles pour traiter des données sur les constructions nouvelles, extensions et démolitions. \\n* **batiment_groupe_simulations_isb :** indicateur de surchauffe des bâtiments.\\n\\n## Tables modifiées:\\n\\n* **batiment_groupe_indicateur_reseau_chaud_froid :**  ajout des réseaux de chaleurs en cours de construction.\\n* **batiment_groupe_dle_elec/gaz/reseau_multimillesime :** \\n    * ajout des données locales de l\\'énergie 2023 (sauf pour le gaz ⚠️ problème de mise à disposition par le producteur)\\n    * résolution d\\'un problème sur les clefs de répartition des consommations au batiment_groupe lorsque l\\'adresse de la DLE est associé à plusieurs bâtiments, la répartition se fait bien en proportion du nombre de logements de chaque bâtiment. \\n    * correction des données locales de l\\'énergie qui sont affectées pro" par les distributeurs d\\'énergies lorsque ces données sont celles concernant des chaudières collectives de bâtiments résidentiels -> elles sont requalifiées en résidentiel. \\n\\n* **parcelle:** ajout du code_commune_insee dans la table \\n\\n* **batiment_groupe_adresse :** amélioration de la logique de détermination de l\\'adresse principale d\\'un bâtiment basée sur le nombre de locaux du bâtiment associés à cette adresse. \\n\\n* **dpe_logement/batiment_groupe_dpe_representatif_logement :**\\n    * fix les bâtiments sans logements ne peuvent plus être associés à des DPE logements\\n    * fix le type d\\'énergie des générateurs d\\'ECS et de chauffage est toujours cohérent avec le générateur quand les données brutes du DPE sont incorrectes\\n\\n* **batiment_groupe_rnc :** correction du nombre de lots tertiaires (qui était précédemment mal affecté comme la somme de logements et tertiaire)\\n\\n* **batiment_groupe_synthese_systeme_energetique_logement (BDNB expert) :** intégration des données de raccordement de réseau de chaleur pour corriger/ajouter les bâtiments effectivement raccordés aux réseaux. \\n\\n\\n* **batiment_groupe_simulations_dpe/local_simulations_dpe (BDNB expert) :**\\n\\n    * mise à jour de la méthode de calcul avec l\\'arrêté dit "petites surfaces" du 1er juillet 2024\\n    * mise à jour de la méthode d\\'imputation des données d\\'entrées du calcul DPE.\\n    * amélioration de la modélisation des ponts thermiques et de l\\'estimation des surfaces déperditives.\\n\\n## ⚠️ Tables supprimées\\n\\n* **batiment_groupe_osm_building : dépréciée depuis plusieurs millésimes cette table est supprimée définitivement**\\n\\n## ⚠️ problèmes connus \\n\\n* **batiment_groupe_simulations_dpe/local_simulations_dpe (BDNB expert) :** un problème non résolu dans les simulations dpe entraine une  perte de 4% des bâtiments de logements non simulés. Nos équipes travaillent à identifier la source du problème et à apporter une correction rapidement\\n\\n## formats d\\'exports\\n\\n* projet QGIS géopackage -> passage à une présentation avec une couche multi style pour la couche batiment_groupe (la couche était précédemment dupliquée en plusieurs couches pour chaque représentation d\\'indicateur)\\n\\n"
2023-11.a	v0.7.6	2024/05/21	réseaux de chaleur/froid + intégration des données SIRENE + RNB + fichiers fonciers 2022 / maj ban/ maj BDTOPO	{"tables_ajoutees": {"rel_batiment_construction_rnb": "lien entre les identifiant du référentiel national des bâtiments et les objets de la BDNB", "batiment_groupe_reseau_chaud_froid": "nouvelle table qui identifie les bâtiments raccordés aux réseaux de chaleurs ainsi qu'un indicateur de potentiel de raccordement aux réseaux de chaleur existants.", "batiment_groupe_simulations_valeur_verte": "nouvelle table qui estime les gains en revalorisation foncière attendus après une rénovation qui fait évoluer l'étiquette DPE du bâtiment", "siren": "table des siren (pour pouvoir récupérer des informations sur les entreprises liées à des bâtiments)", "siret": "table des siret (pour pouvoir récupérer des informations sur les entreprises liées à des bâtiments)", "rel_batiment_groupe_siret": "table de relation entre les bâtiments groupes et les siret (base sirene)", "rel_batiment_groupe_siren": "table de relation entre les siren et les groupes de bâtiment (propriété et établissement)", "iris_contexte_geographique": "table de synthèse au niveau Iris des différents contextes géographiques utiles pour contextualiser les bâtiments.", "iris_simulations_valeur_verte": "nouvelle table qui estime les gains en revalorisation foncière attendus après une rénovation qui fait évoluer l'étiquette DPE du bâtiment (aggrégé iris)"}, "tables_modifiees": {"batiment_groupe_argiles": "Table dépréciée qui sera remplacée par une table plus complète à venir sur les risques sur les bâtiments", "batiment_groupe_radon": "Table dépréciée qui sera remplacée par une table plus complète à venir sur les risques sur les bâtiments", "rel_batiment_groupe_qpv": "Table dépréciée et entièrement remplacée par batiment_groupe_qpv", "rel_batiment_groupe_adresse": "amélioration de la méthode de rattachement des adresses à des bâtiments, limitation de faux positifs d'adresses qui étaient raccordés à plusieurs bâtiments par erreur", "rel_batiment_groupe_parcelle": "amélioration de la méthode de rattachement des parcelles à des bâtiments, limitation de faux positifs de parcelles qui étaient raccordés à des bâtiments à cause de problèmes d'alignement cadastre BDTOPO (https://gitlab.com/BDNB/base_nationale_batiment/-/issues/823)", "batiment_groupe_rnc": "fix d'un bug toutes les copropriétés identifiées par la parcelle sont bien de nouveau remontées dans cette table", "batiment_groupe_adresse": "amélioration de la logique de détermination de l'adresse principale."}, "tables_supprimees": {"batiment_groupe_dpe": "suppression de cette table dépréciée -> utiliser batiment_groupe_dpe_statistique_logement", "batiment_groupe_dpe_logtype": "suppression de cette table dépréciée -> utiliser batiment_groupe_dpe_representatif_logement"}, "vues_modifiees": {"batiment_groupe_compile": "vue dépréciée qui sera remplacée par une vue synthétique de la base de données à venir", "batiment_groupe_compile_compat_v06": "vue dépréciée qui sera remplacée par une vue synthétique de la base de données à venir"}}
2023-01.a	v0.7.5	2023/12/18	Nouveau croisement géospatial + MAJ DPE/RPLS/RNC	{"tables_ajoutees": {"passage_millesime_batiment_groupe_id": "Nouvelle table", "rel_batiment_construction_rnb": "Nouvelle table expérimentale stockant les identifiants du Référentiel National des Bâtiments (RNB). Dans les prochaines versions, cet identifiant sera intégré dans la table batiment_constuction directement."}, "tables_modifiees": {"adresse": ["ajout d'un champ libelle_adresse qui concatène l'ensemble des informations", "suppression de la 'source' \\"fichiers fonciers\\" dans les sources d'adresse (non pertinente méthodologiquement)"], "batiment": "changement de la modalité 'origine' **Cadastre** pour **Autre**", "batiment_construction": "'batiment_groupe_id' et 'batiment_construction_id' au format nano-id", "batiment_groupe": ["fiabilisation du croisement et intégration de nouvelles entrées \\"bâtiment-construction\\", réduisant considérablement le différentiel avec le jeux de données BDTopo de l'IGN", "batiment_groupe_id -> changement de tous les identifiants pour utiliser un nano-id"], "batiment_groupe_bdtopo_bat": "ajout de la colonne 'max_hauteur'", "batiment_groupe_exposition_bruit_logement_social": "MAJ des données + nouvelles colonnes : 'exposition_bruit_routier_et_ou_ferroviaire', 'nb_logement_social_expose_bruit_rte_et_ou_fer', 'type_exposition_bruit_routier_et_ou_ferroviaire'", "batiment_groupe_ffo_bat": ["Calcul de nb_log_hlm modifié car auparavant correspondait à hlm + sem", "modification des descriptions de nb_log_hlm, nb_log_sem, nb_log_soc pour refléter ce qui est réellement réalisé"], "batiment_groupe_rnc": ["Ajout des données open", "nouvelles colonnes -> 'l_siret', 'copro_dans_pvd'"], "batiment_groupe_rpls": ["Ajout des données open,", "MAJ 2022,", "Nouvelles colonnes -> 'rpls_open', 'classe_ener_principale', 'classe_ges_principale', 'raison_sociale_principal', 'siret_principal'"], "parcelle": "report du non-id de la parcelle unifiee", "rel_batiment_groupe_adresse": ["classe -> dépréciation de la classe d'association 1.1 -> 9.X", "lien_valide -> Déprécié", "Ajout d'une colonne 'origine' -> [Fichiers Fonciers, Association Géométrique, Fichiers Fonciers + Association Géométrique]"], "rel_batiment_construction_adresse": ["Ajout d'une table de relation entre les bâtiments construction et des adresses", "Nouvelle méthodologie d'association des bâtiments construction aux adresses.", "Cette nouvelle méthode permet de récupérer des adresses non documentées dans les fichiers fonciers et de les lier à des bâtiments construction et des bâtiments groupes.", "Cette table permet également d'attribuer des adresses postales aux entrées \\"bâtiment-construction\\" non référencées dans les données foncières"], "rel_batiment_groupe_parcelle": "ajout d'une propriété 'parcelle_principale' pour documenter s'il s'agit de la parcelle principale du bâtiment groupe.", "rel_batiment_groupe_argile": "renommage de la colonne 'argile_niveau' par 'argile_non_officiel_id'", "rel_batiment_groupe_merimee": ["relation entre les batiments_groupe et les references merimées dans un périmère de 500m", "Ajout des relations entre les batiments_constructions proches (moins de 500m) et les références mérimées"], "rel_batiment_groupe_pees": "Nouvelle table", "rel_batiment_groupe_pies": "Nouvelle table", "rel_batiment_groupe_rnc": ["MAJ 2022", "renommage de l'index 'rnc_numero_immat' en 'numero_immat'", "ajout colonnes 'fiabilite_globale', 'parcelle_id', 'parcelle_unifiee_id'"], "rel_batiment_groupe_rpls": ["MAJ 2022", "renommage de l'index 'rpls_non_officiel_id' 'ident_rpls'", "ajout colonnes 'fiabilite_globale', 'batiment_id', 'local_id', 'rpls_open'"]}, "tables_supprimees": null, "vues_modifiees": null}
2022-10.d	v0.7.4	2023/06/21	intégration des dle multi-millésime, des dvf_open, des données bruits pour les bailleurs sociaux, maj des dpe	{"tables_ajoutees": {"rel_batiment_groupe_bruit": "nouvelle table", "rel_batiment_groupe_dvf_open": "table relationnelle entre les mutations dvf open et les batiment_groupe", "batiment_groupe_dvf_open_representatif": "table des mutations représentatives des batiment_groupe associés aux mutations", "batiment_groupe_dvf_open_statistique": "table de statistique des mutations à l'échelle du batiment_groupe", "rel_batiment_groupe_dle_elec_2018": "nouvelle_table", "rel_batiment_groupe_dle_elec_2019": "nouvelle_table", "rel_batiment_groupe_dle_elec_2020": "nouvelle_table", "rel_batiment_groupe_dle_elec_2021": "nouvelle_table", "rel_batiment_groupe_dle_gaz_2018": "nouvelle_table", "rel_batiment_groupe_dle_gaz_2019": "nouvelle_table", "rel_batiment_groupe_dle_gaz_2020": "nouvelle_table", "rel_batiment_groupe_dle_gaz_2021": "nouvelle_table", "rel_batiment_groupe_dle_reseaux_2020": "nouvelle_table", "rel_batiment_groupe_dle_reseaux_2021": "nouvelle_table", "batiment_groupe_bdtopo_bat": "fix inversion de colonne dans la doc", "batiment_groupe_pie": "ajout d'une nouvelle table", "batiment_groupe_rpls": "mise à jour de la table batiment_groupe_rpls millésime 2019 par la table batiment_groupe_rpls millésime 2022", "rel_batiment_groupe_rpls": "mise à jour de la table rel_baitment_groupe_rpls millésime 2019 par la table rel_baitment_groupe_rpls millésime 2022", "rel_batiment_groupe_dle_elec_multimillesime": "nouvelle_table", "rel_batiment_groupe_dle_gaz_multimillesime": "nouvelle_table", "rel_batiment_groupe_dle_reseaux_multimillesime": "nouvelle_table", "batiment_groupe_dle_elec_multimillesime": "nouvelle_table", "batiment_groupe_dle_gaz_multimillesime": "nouvelle_table", "batiment_groupe_dle_reseaux_multimillesime": "nouvelle_table", "batiment_groupe_exposition_bruit_logement_social": "ajout d'une nouvelle table", "rel_batiment_groupe_pie": "ajout d'une nouvelle table", "batiment_groupe_synthese_periode_construction": "ajout d'une nouvelle table"}, "tables_modifiees": {"batiment_groupe_ffo_bat": "ajout des nombres de residences principales et secondaires", "batiment_groupe_bdtopo_bat": "fix inversion de colonne dans la doc", "batiment_groupe_synthese_enveloppe": "mise à jour des DPE", "batiment_groupe_synthese_systeme_energetique_logement": "mise à jour des DPE", "rel_batiment_groupe_dpe_logement": "mise à jour des DPE", "dpe_logement": "mise à jour des DPE", "batiment_groupe_dpe_representatif_logement": "mise à jour des DPE", "batiment_groupe_dpe_statistique_logement": "mise à jour des DPE"}, "tables_supprimees": {"batiment_groupe_dle_elec_2020": "DEPRECATED au profit des tables multi-millesime", "batiment_groupe_dle_gaz_2020": "DEPRECATED au profit des tables multi-millesime", "batiment_groupe_dle_reseaux_2020": "DEPRECATED au profit des tables multi-millesime"}, "vues_modifiees": {"batiment_groupe_compile": "ajout des nouvelles variables"}}
2022-10.c	v0.7.3	2023/03/23	nouveaux dpe + divers fix	{"tables_ajoutees": null, "tables_modifiees": {"filiation_siren (du schéma filiation_siren)": "maj de la table avec dernières données dont les fusions/absorptions de bailleurs ALS et complété à partir des info de la table propriétaire", "batiment_groupe_simulations_dvf": "nouvelles simulations avec un algorithme plus performant", "batiment_groupe_simulations_valeur_verte": "nouvelles simulations avec un algorithme plus performant", "batiment_groupe_simulations_dpe": "nouvelles simulations en prenant en compte les nouveaux dpe (suppression des colonnes de type conso_tot car non pertinentes)", "batiment_groupe_synthese_enveloppe": "nouvelle table", "batiment_groupe_synthese_systeme_energetique_logement": "nouvelle table", "dpe_logement": "nouvelle table", "local_simulations_dpe": "nouvelle table", "batiment_groupe_dpe_representatif_logement": "nouvelle table", "batiment_groupe_dpe_statistique_logement": "nouvelle table", "batiment_groupe_ffo_bat": "fix problème lié aux usages qui étaient parfois incohérents", "rel_batiment_groupe_dpe_logement": "nouvelle table", "batiment_groupe_proprietaire": "correction de la colonne propriétaire principal, l\\'algorithme sort désormais le propriétaire avec la plus grande surface de locaux", "iris_simulations_valeur_verte": "nouvelle table"}, "tables_supprimees": {"batiment_groupe_dpe": "DEPRECATED (uniquement anciens DPE arrêté 2012) -> est remplacé par batiment_groupe_dpe_statistique_logement (inclus ancien et nouveau DPE)", "batiment_groupe_dpe_logtype": "DEPRECATED (uniquement anciens DPE arrêté 2012) -> est remplacé par batiment_groupe_dpe_representatif_logement (inclus ancien et nouveau DPE)", "rel_batiment_groupe_dpe": "DEPRECATED (uniquement anciens DPE arrêté 2012)"}, "vues_modifiees": {"batiment_groupe_compile": "regénérée pour ajouter de nouvelles colonnes"}}
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "metadonnees_colonne_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" IS 'Descriptions des tables de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "nom_colonne" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "nom_table" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "type_sql" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "nullable" BOOLEAN;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "description" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "statut" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "unite" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "contrainte_acces" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "index" BOOLEAN;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "cle_primaire" BOOLEAN;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ADD COLUMN "modalite_enum" varchar[];
COPY "bdnb_2025_07_a_open_data_dep01"."metadonnees_colonne" ("nom_colonne", "nom_table", "type_sql", "nullable", "description", "statut", "unite", "contrainte_acces", "index", "cle_primaire", "modalite_enum") FROM STDIN;
identifiant_dpe	dpe_logement	text	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	dpe_logement	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
arrete_2021	dpe_logement	bool	0	précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s'il s'agit d'un DPE issu de la modification antérieure de 2012.	maintenu	\N	open_data_lo	0	0	\N
type_dpe	dpe_logement	text	0	type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)	maintenu	\N	open_data_lo	1	0	{"dpe arrêté 2012 3cl immeuble","dpe arrêté 2012 facture logement","dpe arrêté 2021 re2020 logement","dpe arrêté 2012 3cl logement","dpe arrêté 2021 rt2012 logement","dpe arrêté 2012 facture immeuble","dpe arrêté 2021 rt2012 immeuble","dpe arrêté 2021 3cl logement","dpe arrêté 2021 3cl immeuble","dpe arrêté 2021 re2020 immeuble"}
type_batiment_dpe	dpe_logement	text	1	défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d'information est un DPE.	maintenu	\N	open_data_lo	0	0	{"appartement","maison","immeuble"}
periode_construction_dpe	dpe_logement	text	1	période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.	maintenu	\N	open_data_lo	0	0	{"1983-1988","2013-2021","1989-2000","1978-1982","2006-2012","après 2021","avant 1948","1948-1974","1975-1977","2001-2005"}
annee_construction_dpe	dpe_logement	int2	1	année de construction du logement évaluée par le DPE	maintenu	\N	open_data_lo	0	0	\N
version	dpe_logement	text	1	version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu'à partir d'une certaine version	maintenu	\N	open_data_lo	1	0	\N
date_etablissement_dpe	dpe_logement	timestamp	1	date de l'établissement du dpe	maintenu	\N	open_data_lo	0	0	\N
date_reception_dpe	dpe_logement	timestamp	1	date de réception du DPE dans la base de données de l'ADEME	maintenu	\N	open_data_lo	0	0	\N
nombre_niveau_logement	dpe_logement	int2	1	nombre de niveaux du logement (maison ou appartement)	maintenu	\N	open_data_lo	0	0	\N
nombre_niveau_immeuble	dpe_logement	int2	1	nombre de niveaux total de l'immeuble	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_immeuble	dpe_logement	numeric	1	surface habitable totale de l'immeuble dans le cas d'un DPE appartement avec usage collectif ou d'un DPE immeuble.(surface habitable au sens du DPE)	maintenu	m2	open_data_lo	0	0	\N
surface_habitable_logement	dpe_logement	numeric	1	surface habitable du logement renseignée sauf dans le cas du dpe à l'immeuble. (surface habitable au sens du DPE)	maintenu	m2	open_data_lo	0	0	\N
type_energie_chauffage	dpe_logement	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
conso_5_usages_ep_m2	dpe_logement	numeric	1	consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
conso_5_usages_ef_m2	dpe_logement	numeric	1	consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
emission_ges_5_usages_m2	dpe_logement	numeric	1	emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
classe_bilan_dpe	dpe_logement	text	1	Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G"}
classe_emission_ges	dpe_logement	text	1	classe d'émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G"}
classe_conso_energie_arrete_2012	dpe_logement	text	1	classe d'émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","N"}
classe_emission_ges_arrete_2012	dpe_logement	text	1	classe d'emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","N"}
conso_3_usages_ep_m2_arrete_2012	dpe_logement	numeric	1	consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
pourcentage_surface_baie_vitree_exterieur	dpe_logement	numeric	1	pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs	maintenu	\N	open_data_lo	0	0	\N
emission_ges_3_usages_ep_m2_arrete_2012	dpe_logement	numeric	1	emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012 (kgCO2/m2/an).	maintenu	\N	open_data_lo	0	0	\N
type_installation_chauffage	dpe_logement	text	1	type d'installation de chauffage (collectif ou individuel)	maintenu	\N	open_data_lo	0	0	{"individuel","collectif"}
u_porte	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des portes (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
type_generateur_chauffage	dpe_logement	text	1	type de générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
type_generateur_chauffage_anciennete	dpe_logement	text	1	ancienneté du générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_chauffage_appoint	dpe_logement	text	1	type d'énergie pour le générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_chauffage_appoint	dpe_logement	text	1	type de générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
type_generateur_chauffage_anciennete_appoint	dpe_logement	text	1	ancienneté du générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
chauffage_solaire	dpe_logement	bool	1	présence de chauffage solaire	maintenu	\N	open_data_lo	0	0	\N
nb_generateur_chauffage	dpe_logement	int2	1	nombre de générateurs de chauffage	maintenu	\N	open_data_lo	0	0	\N
nb_installation_chauffage	dpe_logement	int2	1	nombre d'installation de chauffage	maintenu	\N	open_data_lo	0	0	\N
type_energie_climatisation	dpe_logement	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_climatisation	dpe_logement	text	1	type de générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"pac air/eau","pac geothermique","pac air/air","pac gaz","pac eau/eau","reseau de froid"}
type_generateur_climatisation_anciennete	dpe_logement	text	1	ancienneté du générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_installation_ecs	dpe_logement	text	1	type d'installation d'eau chaude sanitaire (ECS) (collectif ou individuel)	maintenu	\N	open_data_lo	0	0	{"individuel","collectif"}
type_energie_ecs	dpe_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_ecs	dpe_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
type_generateur_ecs_anciennete	dpe_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_ecs_appoint	dpe_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
nb_loc_hab	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux d'habitation	maintenu	\N	ayant_droit_ffo	0	0	\N
type_generateur_ecs_appoint	dpe_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
type_generateur_ecs_anciennete_appoint	dpe_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
ecs_solaire	dpe_logement	bool	1	présence d'ecs solaire	maintenu	\N	open_data_lo	0	0	\N
nb_generateur_ecs	dpe_logement	int2	1	nombre de générateurs d'ecs	maintenu	\N	open_data_lo	0	0	\N
nb_installation_ecs	dpe_logement	int2	1	nombre d'installation d'ecs	maintenu	\N	open_data_lo	0	0	\N
plusieurs_facade_exposee	dpe_logement	bool	1	il est considéré dans le DPE qu'il y a plusieurs facades exposées au vent.	maintenu	\N	open_data_lo	0	0	\N
type_ventilation	dpe_logement	text	1	type de système de ventilation du logement	maintenu	\N	open_data_lo	0	0	{"Système de ventilation par entrées d’air hautes et basses","Ventilation mécanique auto réglable « après 1982 »","Ventilation mécanique double flux avec échangeur","Ventilation mécanique auto réglable « avant 1982 »","Ventilation naturelle par conduit","Puits canadien","Ventilation mécanique double flux sans échangeur","Ventilation mécanique auto réglable","Extracteur mécanique sur conduit non modifié de ventilation naturelle existante","Ventilation mécanique à extraction hygroréglable","Ventilation mécanique à extraction et entrées d’air hygroréglables","Ventilation hybride","Ventilation mécanique gaz hygroréglable","Ventilation hybride avec entrées d’air hygroréglables","Ventilation naturelle par conduit avec entrées d’air hygroréglables","Ventilation par ouverture des fenêtres"}
type_production_energie_renouvelable	dpe_logement	text	1	type de production ENR pour le DPE	maintenu	\N	open_data_lo	0	0	{"cogénération","eolien","eolien + cogénération","solaire photovoltaïque","solaire photovoltaïque + cogénération","solaire photovoltaïque + eolien","solaire photovoltaïque + eolien + cogénération"}
type_vitrage	dpe_logement	text	1	type de vitrage principal des baies vitrées du DPE	maintenu	\N	open_data_lo	0	0	{"triple vitrage","brique de verre ou polycarbonate","double vitrage","survitrage","simple vitrage"}
type_materiaux_menuiserie	dpe_logement	text	1	type de matériaux principal des menuiseries des baies vitrées du DPE	maintenu	\N	open_data_lo	0	0	{"brique de verre","polycarbonate","pvc","bois","métal","métal avec rupture de pont thermique","métal sans rupture de pont thermique","bois/métal","autres","bois ou pvc"}
type_gaz_lame	dpe_logement	text	1	type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)	maintenu	\N	open_data_lo	0	0	{"air sec","argon ou krypton","inconnu"}
type_fermeture	dpe_logement	text	1	type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)	maintenu	\N	open_data_lo	0	0	{"Volet roulant PVC ( e > 12 mm)","abscence de fermeture pour la baie vitrée","Persienne coulissante ou volet battant PVC, volet battant bois (e > 22 mm)","Fermeture sans ajours en position déployée, volets roulants alu","Persienne coulissante ou volet battant PVC, volet battant bois (e ≤ 22 mm)","Fermeture isolée sans ajours en position déployée","Jalousie accordéon, fermeture à lames orientables y compris les vénitiens extérieurs tout métal, volets battants ou persiennes avec ajours fixes","Volet roulant PVC ( e ≤ 12 mm)"}
epaisseur_lame	dpe_logement	int2	1	epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.	maintenu	\N	open_data_lo	0	0	\N
vitrage_vir	dpe_logement	bool	1	le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d'un point de vue thermique.	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_nord	dpe_logement	numeric	1	somme de la surface de baies vitrées orientées nord du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_sud	dpe_logement	numeric	1	somme de la surface de baies vitrées orientées sud du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_ouest	dpe_logement	numeric	1	somme de la surface de baies vitrées orientées ouest du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_est	dpe_logement	numeric	1	somme de la surface de baies vitrées orientées est du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_horizontal	dpe_logement	numeric	1	somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)	maintenu	\N	open_data_lo	0	0	\N
traversant	dpe_logement	text	1	indicateur du côté traversant du logement.	maintenu	\N	open_data_lo	0	0	{"90°","90° (faible)","est ouest","est ouest (faible)","non traversant","nord sud","nord sud (faible)","tout azimut","tout venant","tout venant (faible)"}
u_baie_vitree	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
uw	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
facteur_solaire_baie_vitree	dpe_logement	numeric	1	facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1	maintenu	\N	open_data_lo	0	0	\N
presence_balcon	dpe_logement	bool	1	présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.	maintenu	\N	open_data_lo	0	0	\N
l_orientation_baie_vitree	dpe_logement	text[]	1	liste des orientations des baies vitrées (enum version BDNB)	maintenu	\N	open_data_lo	0	0	\N
nb_log_loue	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de logements loués avec un bail classique	maintenu	\N	ayant_droit_ffo	0	0	\N
type_isolation_mur_exterieur	dpe_logement	text	1	type d'isolation principal des murs donnant sur l'extérieur pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
epaisseur_isolation_mur_exterieur_estim	dpe_logement	int4	1	epaisseur d'isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d'une épaisseur déclarée c'est directement l'épaisseur déclarée qui est considérée, dans le cas contraire l'épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.	maintenu	\N	open_data_lo	0	0	\N
materiaux_structure_mur_exterieur	dpe_logement	text	1	matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)	maintenu	\N	open_data_lo	0	0	{"autre matériau innovant récent","autre matériau non répertorié","autre matériau traditionel ancien","brique terre cuite alvéolaire","béton cellulaire","cloison de plâtre","inconnu","monomur terre cuite","murs bois (rondin)","murs en blocs de béton creux","murs en blocs de béton pleins","murs en briques","murs en briques creuses","murs en briques pleines doubles avec lame d'air","murs en briques pleines simples","murs en béton","murs en béton banché","murs en béton de mâchefer","murs en ossature bois avec isolant en remplissage 2001-2005","murs en ossature bois avec isolant en remplissage <2001","murs en ossature bois avec isolant en remplissage ≥ 2006","murs en ossature bois avec remplissage tout venant","murs en ossature bois sans remplissage","murs en pan de bois avec remplissage tout venant","murs en pan de bois sans remplissage tout venant","murs en pierre","murs en pierre de taille et moellons avec remplissage tout venant","murs en pierre de taille et moellons constitué d'un seul matériaux","murs en pisé ou béton de terre stabilisé (à partir d'argile crue)","murs sandwich béton/isolant/béton (sans isolation rapportée)"}
epaisseur_structure_mur_exterieur	dpe_logement	text	1	epaisseur moyenne de la partie structure du mur (sans l'isolation rapportée ni les doublages)	maintenu	\N	open_data_lo	0	0	\N
surface_mur_totale	dpe_logement	numeric	1	somme de la surface de murs totale	maintenu	\N	open_data_lo	0	0	\N
surface_mur_exterieur	dpe_logement	numeric	1	somme de la surface  surface de murs donnant sur l'extérieur	maintenu	\N	open_data_lo	0	0	\N
surface_mur_deperditif	dpe_logement	numeric	1	somme de la surface de murs donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_mur_exterieur	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_mur	dpe_logement	text[]	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
local_non_chauffe_principal_mur	dpe_logement	text	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
l_orientation_mur_exterieur	dpe_logement	text[]	1	liste des orientations des murs donnant sur l'extérieur (enum version BDNB)	maintenu	\N	open_data_lo	0	0	\N
type_isolation_plancher_bas	dpe_logement	text	1	type d'isolation principal des planchers bas déperditifs pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_bas_deperditif	dpe_logement	text	1	materiaux ou principe constructif principal des planchers bas	maintenu	\N	open_data_lo	0	0	{"plancher lourd type entrevous terre-cuite, poutrelles béton","plancher avec ou sans remplissage","plancher bois sur solives bois","plancher à entrevous isolant","voutains en briques ou moellons","plancher entre solives bois avec ou sans remplissage","bardeaux et remplissage","plancher mitoyen non deperditif","inconnu","plancher bois sur solives métalliques","plancher entre solives métalliques avec ou sans remplissage","dalle béton","autre type de plancher non répertorié","voutains sur solives métalliques"}
surface_plancher_bas_totale	dpe_logement	numeric	1	somme de la surface de plancher bas totale	maintenu	\N	open_data_lo	0	0	\N
surface_plancher_bas_deperditif	dpe_logement	numeric	1	somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_bas_final_deperditif	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des planchers bas en prenant en compte l'atténuation forfaitaire du U lorsqu'en contact avec le sol de la méthode 3CL(W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_bas_brut_deperditif	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_plancher_bas	dpe_logement	text[]	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
local_non_chauffe_principal_plancher_bas	dpe_logement	text	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
emission_ges_3_usages_ep_m2_arrete_2012	batiment_groupe_dpe_representatif_logement	numeric	1	emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012 (kgCO2/m2/an).	maintenu	\N	open_data_lo	0	0	\N
type_installation_chauffage	batiment_groupe_dpe_representatif_logement	text	1	type d'installation de chauffage (collectif ou individuel)	maintenu	\N	open_data_lo	0	0	{"individuel","collectif"}
nb_log_loue_meuble	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de logements loués meublés	maintenu	\N	ayant_droit_ffo	0	0	\N
type_adjacence_principal_plancher_bas	dpe_logement	text	1	type d'adjacence principale des planchers bas (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	open_data_lo	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
type_isolation_plancher_haut	dpe_logement	text	1	type d'isolation principal des planchers hauts déperditifs pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_haut_deperditif	dpe_logement	text	1	materiaux ou principe constructif principal des planchers hauts	maintenu	\N	open_data_lo	0	0	{"plafond mitoyen non deperditif","plafond bois sous solives métalliques","bardeaux et remplissage","autre type de plafond non répertorié","toiture en chaume","plafond bois sur solives métalliques","plafond entre solives métalliques avec ou sans remplissage","toitures en Bac acier","plafond lourd type entrevous terre-cuite, poutrelles béton","plafond avec ou sans remplissage","inconnu","plafond en plaque de plâtre","dalle béton","plafond entre solives bois avec ou sans remplissage","plafond avec ou sans remplissage sous combles","plafond bois sur solives bois","combles aménagés sous rampant","plafond bois sous solives bois"}
surface_plancher_haut_totale	dpe_logement	numeric	1	somme de la surface de plancher haut totale	maintenu	\N	open_data_lo	0	0	\N
surface_plancher_haut_deperditif	dpe_logement	numeric	1	somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_haut_deperditif	dpe_logement	numeric	1	Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_plancher_haut	dpe_logement	text[]	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
local_non_chauffe_principal_plancher_haut	dpe_logement	text	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
type_adjacence_principal_plancher_haut	dpe_logement	text	1	type d'adjacence principale des planchers haut (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	open_data_lo	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
type_porte	dpe_logement	text	1	type de porte du DPE (enum version DPE 2021)	maintenu	\N	open_data_lo	0	0	{"porte simple en pvc porte opaque pleine","porte simple en métal porte avec moins de 30% de double vitrage","porte simple en métal porte avec 30-60% de double vitrage","toute menuiserie porte précédée d’un sas","porte simple en bois porte opaque pleine","porte simple en métal porte opaque pleine","toute menuiserie porte opaque pleine isolée","porte simple en bois porte avec double vitrage","toute menuiserie porte isolée avec double vitrage","porte simple en métal porte avec vitrage simple","porte simple en bois porte avec 30-60% de vitrage simple","porte simple en pvc porte avec moins de 30% de vitrage simple","porte simple en pvc porte avec 30-60% de vitrage simple","porte simple en bois porte avec moins de 30% de vitrage simple","autre type de porte","porte simple en pvc porte avec double vitrage"}
surface_porte	dpe_logement	numeric	1	somme de la surface de portes du DPE	maintenu	\N	open_data_lo	0	0	\N
l_bat_nom	batiment_groupe_rpls	text[]	1	(rpls) Nom du bâtiment	maintenu		ayant_droit_rpls	0	0	\N
classe_inertie	dpe_logement	text	1	classe d'inertie pour le DPE (de légère à très lourde)	maintenu	\N	open_data_lo	0	0	{"Légère","Lourde","Très Lourde","Moyenne"}
deperdition_mur	dpe_logement	numeric	1	somme des déperditions par les murs du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_baie_vitree	dpe_logement	numeric	1	somme des déperditions par les baies vitrées du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_plancher_bas	dpe_logement	numeric	1	somme des deperditions par les planchers bas du logement (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_plancher_haut	dpe_logement	numeric	1	somme des deperditions par les planchers hauts du logement (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_pont_thermique	dpe_logement	numeric	1	somme des deperditions par les portes du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_porte	dpe_logement	numeric	1	somme des deperditions par les portes du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dpe_representatif_logement	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
identifiant_dpe	batiment_groupe_dpe_representatif_logement	text	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	0	0	\N
unite_urbaine_catg	iris_contexte_geographique	text	1	Catégorie des unités urbaines	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
code_departement_insee	batiment_groupe_dpe_representatif_logement	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
arrete_2021	batiment_groupe_dpe_representatif_logement	bool	0	précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s'il s'agit d'un DPE issu de la modification antérieure de 2012.	maintenu	\N	open_data_lo	0	0	\N
type_dpe	batiment_groupe_dpe_representatif_logement	text	0	type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)	maintenu	\N	open_data_lo	0	0	{"dpe arrêté 2012 3cl immeuble","dpe arrêté 2012 facture logement","dpe arrêté 2021 re2020 logement","dpe arrêté 2012 3cl logement","dpe arrêté 2021 rt2012 logement","dpe arrêté 2012 facture immeuble","dpe arrêté 2021 rt2012 immeuble","dpe arrêté 2021 3cl logement","dpe arrêté 2021 3cl immeuble","dpe arrêté 2021 re2020 immeuble"}
type_batiment_dpe	batiment_groupe_dpe_representatif_logement	text	1	défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d'information est un DPE.	maintenu	\N	open_data_lo	0	0	{"appartement","maison","immeuble"}
periode_construction_dpe	batiment_groupe_dpe_representatif_logement	text	1	période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.	maintenu	\N	open_data_lo	0	0	\N
annee_construction_dpe	batiment_groupe_dpe_representatif_logement	int2	1	année de construction du logement évaluée par le DPE	maintenu	\N	open_data_lo	0	0	\N
version	batiment_groupe_dpe_representatif_logement	text	1	version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu'à partir d'une certaine version	maintenu	\N	open_data_lo	0	0	\N
date_etablissement_dpe	batiment_groupe_dpe_representatif_logement	timestamp	1	date de l'établissement du dpe	maintenu	\N	open_data_lo	0	0	\N
date_reception_dpe	batiment_groupe_dpe_representatif_logement	timestamp	1	date de réception du DPE dans la base de données de l'ADEME	maintenu	\N	open_data_lo	0	0	\N
nombre_niveau_logement	batiment_groupe_dpe_representatif_logement	int2	1	nombre de niveaux du logement (maison ou appartement)	maintenu	\N	open_data_lo	0	0	\N
nombre_niveau_immeuble	batiment_groupe_dpe_representatif_logement	int2	1	nombre de niveaux total de l'immeuble	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_immeuble	batiment_groupe_dpe_representatif_logement	numeric	1	surface habitable totale de l'immeuble dans le cas d'un DPE appartement avec usage collectif ou d'un DPE immeuble.(surface habitable au sens du DPE)	maintenu	m2	open_data_lo	0	0	\N
surface_habitable_logement	batiment_groupe_dpe_representatif_logement	numeric	1	surface habitable du logement renseignée sauf dans le cas du dpe à l'immeuble. (surface habitable au sens du DPE)	maintenu	m2	open_data_lo	0	0	\N
conso_5_usages_ep_m2	batiment_groupe_dpe_representatif_logement	numeric	1	consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
conso_5_usages_ef_m2	batiment_groupe_dpe_representatif_logement	numeric	1	consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
emission_ges_5_usages_m2	batiment_groupe_dpe_representatif_logement	numeric	1	emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	\N
classe_bilan_dpe	batiment_groupe_dpe_representatif_logement	text	1	Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G"}
classe_emission_ges	batiment_groupe_dpe_representatif_logement	text	1	classe d'émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 31 mars 2021 (en vigueur actuellement)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G"}
classe_conso_energie_arrete_2012	batiment_groupe_dpe_representatif_logement	text	1	classe d'émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
facteur_solaire_baie_vitree	batiment_groupe_dpe_representatif_logement	numeric	1	facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1	maintenu	\N	open_data_lo	0	0	\N
classe_emission_ges_arrete_2012	batiment_groupe_dpe_representatif_logement	text	1	classe d'emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","N"}
conso_3_usages_ep_m2_arrete_2012	batiment_groupe_dpe_representatif_logement	numeric	1	consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
usage_niveau_3	batiment_groupe_ffo_bat	int4	1	indicateur d'usage précis du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
type_energie_chauffage	batiment_groupe_dpe_representatif_logement	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_chauffage	batiment_groupe_dpe_representatif_logement	text	1	type de générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
type_generateur_chauffage_anciennete	batiment_groupe_dpe_representatif_logement	text	1	ancienneté du générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_chauffage_appoint	batiment_groupe_dpe_representatif_logement	text	1	type d'énergie pour le générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_chauffage_appoint	batiment_groupe_dpe_representatif_logement	text	1	type de générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
type_generateur_chauffage_anciennete_appoint	batiment_groupe_dpe_representatif_logement	text	1	ancienneté du générateur de chauffage d'appoint	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
chauffage_solaire	batiment_groupe_dpe_representatif_logement	bool	1	présence de chauffage solaire	maintenu	\N	open_data_lo	0	0	\N
nb_generateur_chauffage	batiment_groupe_dpe_representatif_logement	int2	1	nombre de générateurs de chauffage	maintenu	\N	open_data_lo	0	0	\N
nb_installation_chauffage	batiment_groupe_dpe_representatif_logement	int2	1	nombre d'installation de chauffage	maintenu	\N	open_data_lo	0	0	\N
type_energie_climatisation	batiment_groupe_dpe_representatif_logement	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_climatisation	batiment_groupe_dpe_representatif_logement	text	1	type de générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"pac air/eau","pac geothermique","pac air/air","pac gaz","pac eau/eau","reseau de froid"}
type_generateur_climatisation_anciennete	batiment_groupe_dpe_representatif_logement	text	1	ancienneté du générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_installation_ecs	batiment_groupe_dpe_representatif_logement	text	1	type d'installation d'eau chaude sanitaire (ECS) (collectif ou individuel)	maintenu	\N	open_data_lo	0	0	{"individuel","collectif"}
type_energie_ecs	batiment_groupe_dpe_representatif_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_ecs	batiment_groupe_dpe_representatif_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
type_generateur_ecs_anciennete	batiment_groupe_dpe_representatif_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_ecs_appoint	batiment_groupe_dpe_representatif_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_ecs_appoint	batiment_groupe_dpe_representatif_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
type_generateur_ecs_anciennete_appoint	batiment_groupe_dpe_representatif_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	open_data_lo	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
ecs_solaire	batiment_groupe_dpe_representatif_logement	bool	1	présence d'ecs solaire	maintenu	\N	open_data_lo	0	0	\N
nb_generateur_ecs	batiment_groupe_dpe_representatif_logement	int2	1	nombre de générateurs d'ecs	maintenu	\N	open_data_lo	0	0	\N
nb_installation_ecs	batiment_groupe_dpe_representatif_logement	int2	1	nombre d'installation d'ecs	maintenu	\N	open_data_lo	0	0	\N
plusieurs_facade_exposee	batiment_groupe_dpe_representatif_logement	bool	1	il est considéré dans le DPE qu'il y a plusieurs facades exposées au vent.	maintenu	\N	open_data_lo	0	0	\N
uw	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
type_ventilation	batiment_groupe_dpe_representatif_logement	text	1	type de système de ventilation du logement	maintenu	\N	open_data_lo	0	0	{"Système de ventilation par entrées d’air hautes et basses","Ventilation mécanique auto réglable « après 1982 »","Ventilation mécanique double flux avec échangeur","Ventilation mécanique auto réglable « avant 1982 »","Ventilation naturelle par conduit","Puits canadien","Ventilation mécanique double flux sans échangeur","Ventilation mécanique auto réglable","Extracteur mécanique sur conduit non modifié de ventilation naturelle existante","Ventilation mécanique à extraction hygroréglable","Ventilation mécanique à extraction et entrées d’air hygroréglables","Ventilation hybride","Ventilation mécanique gaz hygroréglable","Ventilation hybride avec entrées d’air hygroréglables","Ventilation naturelle par conduit avec entrées d’air hygroréglables","Ventilation par ouverture des fenêtres"}
type_production_energie_renouvelable	batiment_groupe_dpe_representatif_logement	text	1	type de production ENR pour le DPE	maintenu	\N	open_data_lo	0	0	{"cogénération","eolien","eolien + cogénération","solaire photovoltaïque","solaire photovoltaïque + cogénération","solaire photovoltaïque + eolien","solaire photovoltaïque + eolien + cogénération"}
type_vitrage	batiment_groupe_dpe_representatif_logement	text	1	type de vitrage principal des baies vitrées du DPE	maintenu	\N	open_data_lo	0	0	{"triple vitrage","brique de verre ou polycarbonate","double vitrage","survitrage","simple vitrage"}
type_materiaux_menuiserie	batiment_groupe_dpe_representatif_logement	text	1	type de matériaux principal des menuiseries des baies vitrées du DPE	maintenu	\N	open_data_lo	0	0	{"brique de verre","polycarbonate","pvc","bois","métal","métal avec rupture de pont thermique","métal sans rupture de pont thermique","bois/métal","autres","bois ou pvc"}
type_gaz_lame	batiment_groupe_dpe_representatif_logement	text	1	type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)	maintenu	\N	open_data_lo	0	0	{"air sec","argon ou krypton","inconnu"}
type_fermeture	batiment_groupe_dpe_representatif_logement	text	1	type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)	maintenu	\N	open_data_lo	0	0	{"Volet roulant PVC ( e > 12 mm)","abscence de fermeture pour la baie vitrée","Persienne coulissante ou volet battant PVC, volet battant bois (e > 22 mm)","Fermeture sans ajours en position déployée, volets roulants alu","Persienne coulissante ou volet battant PVC, volet battant bois (e ≤ 22 mm)","Fermeture isolée sans ajours en position déployée","Jalousie accordéon, fermeture à lames orientables y compris les vénitiens extérieurs tout métal, volets battants ou persiennes avec ajours fixes","Volet roulant PVC ( e ≤ 12 mm)"}
epaisseur_lame	batiment_groupe_dpe_representatif_logement	int2	1	epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.	maintenu	\N	open_data_lo	0	0	\N
vitrage_vir	batiment_groupe_dpe_representatif_logement	bool	1	le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d'un point de vue thermique.	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_nord	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de baies vitrées orientées nord du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_sud	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de baies vitrées orientées sud du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_ouest	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de baies vitrées orientées ouest du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_est	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de baies vitrées orientées est du DPE	maintenu	\N	open_data_lo	0	0	\N
surface_vitree_horizontal	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)	maintenu	\N	open_data_lo	0	0	\N
traversant	batiment_groupe_dpe_representatif_logement	text	1	indicateur du côté traversant du logement.	maintenu	\N	open_data_lo	0	0	{"90°","90° (faible)","est ouest","est ouest (faible)","non traversant","nord sud","nord sud (faible)","tout azimut","tout venant","tout venant (faible)"}
u_baie_vitree	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
presence_balcon	batiment_groupe_dpe_representatif_logement	bool	1	présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.	maintenu	\N	open_data_lo	0	0	\N
l_orientation_baie_vitree	batiment_groupe_dpe_representatif_logement	text[]	1	liste des orientations des baies vitrées (enum version BDNB)	maintenu	\N	open_data_lo	0	0	\N
pourcentage_surface_baie_vitree_exterieur	batiment_groupe_dpe_representatif_logement	numeric	1	pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs	maintenu	\N	open_data_lo	0	0	\N
type_isolation_mur_exterieur	batiment_groupe_dpe_representatif_logement	text	1	type d'isolation principal des murs donnant sur l'extérieur pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
epaisseur_isolation_mur_exterieur_estim	batiment_groupe_dpe_representatif_logement	int4	1	epaisseur d'isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d'une épaisseur déclarée c'est directement l'épaisseur déclarée qui est considérée, dans le cas contraire l'épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.	maintenu	\N	open_data_lo	0	0	\N
materiaux_structure_mur_exterieur	batiment_groupe_dpe_representatif_logement	text	1	matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)	maintenu	\N	open_data_lo	0	0	{"autre matériau innovant récent","autre matériau non répertorié","autre matériau traditionel ancien","brique terre cuite alvéolaire","béton cellulaire","cloison de plâtre","inconnu","monomur terre cuite","murs bois (rondin)","murs en blocs de béton creux","murs en blocs de béton pleins","murs en briques","murs en briques creuses","murs en briques pleines doubles avec lame d'air","murs en briques pleines simples","murs en béton","murs en béton banché","murs en béton de mâchefer","murs en ossature bois avec isolant en remplissage 2001-2005","murs en ossature bois avec isolant en remplissage <2001","murs en ossature bois avec isolant en remplissage ≥ 2006","murs en ossature bois avec remplissage tout venant","murs en ossature bois sans remplissage","murs en pan de bois avec remplissage tout venant","murs en pan de bois sans remplissage tout venant","murs en pierre","murs en pierre de taille et moellons avec remplissage tout venant","murs en pierre de taille et moellons constitué d'un seul matériaux","murs en pisé ou béton de terre stabilisé (à partir d'argile crue)","murs sandwich béton/isolant/béton (sans isolation rapportée)"}
epaisseur_structure_mur_exterieur	batiment_groupe_dpe_representatif_logement	text	1	epaisseur moyenne de la partie structure du mur (sans l'isolation rapportée ni les doublages)	maintenu	\N	open_data_lo	0	0	\N
surface_mur_totale	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de murs totale	maintenu	\N	open_data_lo	0	0	\N
surface_mur_exterieur	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface  surface de murs donnant sur l'extérieur	maintenu	\N	open_data_lo	0	0	\N
surface_mur_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de murs donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_mur_exterieur	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_mur	batiment_groupe_dpe_representatif_logement	text[]	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
local_non_chauffe_principal_mur	batiment_groupe_dpe_representatif_logement	text	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
l_orientation_mur_exterieur	batiment_groupe_dpe_representatif_logement	text[]	1	liste des orientations des murs donnant sur l'extérieur (enum version BDNB)	maintenu	\N	open_data_lo	0	0	\N
type_isolation_plancher_bas	batiment_groupe_dpe_representatif_logement	text	1	type d'isolation principal des planchers bas déperditifs pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_bas_deperditif	batiment_groupe_dpe_representatif_logement	text	1	materiaux ou principe constructif principal des planchers bas	maintenu	\N	open_data_lo	0	0	{"plancher lourd type entrevous terre-cuite, poutrelles béton","plancher avec ou sans remplissage","plancher bois sur solives bois","plancher à entrevous isolant","voutains en briques ou moellons","plancher entre solives bois avec ou sans remplissage","bardeaux et remplissage","plancher mitoyen non deperditif","inconnu","plancher bois sur solives métalliques","plancher entre solives métalliques avec ou sans remplissage","dalle béton","autre type de plancher non répertorié","voutains sur solives métalliques"}
surface_plancher_bas_totale	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de plancher bas totale	maintenu	\N	open_data_lo	0	0	\N
surface_plancher_bas_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_bas_final_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des planchers bas en prenant en compte l'atténuation forfaitaire du U lorsqu'en contact avec le sol de la méthode 3CL(W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_bas_brut_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_plancher_bas	batiment_groupe_dpe_representatif_logement	text[]	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
deperdition_baie_vitree	batiment_groupe_dpe_representatif_logement	numeric	1	somme des déperditions par les baies vitrées du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
nb_loc	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux `nlocal`	maintenu	\N	ayant_droit_ffo	0	0	\N
local_non_chauffe_principal_plancher_bas	batiment_groupe_dpe_representatif_logement	text	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
type_adjacence_principal_plancher_bas	batiment_groupe_dpe_representatif_logement	text	1	type d'adjacence principale des planchers bas (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	open_data_lo	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
type_isolation_plancher_haut	batiment_groupe_dpe_representatif_logement	text	1	type d'isolation principal des planchers hauts déperditifs pour le DPE	maintenu	\N	open_data_lo	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_haut_deperditif	batiment_groupe_dpe_representatif_logement	text	1	materiaux ou principe constructif principal des planchers hauts	maintenu	\N	open_data_lo	0	0	{"plafond mitoyen non deperditif","plafond bois sous solives métalliques","bardeaux et remplissage","autre type de plafond non répertorié","toiture en chaume","plafond bois sur solives métalliques","plafond entre solives métalliques avec ou sans remplissage","toitures en Bac acier","plafond lourd type entrevous terre-cuite, poutrelles béton","plafond avec ou sans remplissage","inconnu","plafond en plaque de plâtre","dalle béton","plafond entre solives bois avec ou sans remplissage","plafond avec ou sans remplissage sous combles","plafond bois sur solives bois","combles aménagés sous rampant","plafond bois sous solives bois"}
surface_plancher_haut_totale	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de plancher haut totale	maintenu	\N	open_data_lo	0	0	\N
surface_plancher_haut_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l'extérieur (surfaces déperditives)	maintenu	\N	open_data_lo	0	0	\N
u_plancher_haut_deperditif	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
l_local_non_chauffe_plancher_haut	batiment_groupe_dpe_representatif_logement	text[]	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	\N
local_non_chauffe_principal_plancher_haut	batiment_groupe_dpe_representatif_logement	text	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	open_data_lo	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
type_adjacence_principal_plancher_haut	batiment_groupe_dpe_representatif_logement	text	1	type d'adjacence principale des planchers haut (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	open_data_lo	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
type_porte	batiment_groupe_dpe_representatif_logement	text	1	type de porte du DPE (enum version DPE 2021)	maintenu	\N	open_data_lo	0	0	{"porte simple en pvc porte opaque pleine","porte simple en métal porte avec moins de 30% de double vitrage","porte simple en métal porte avec 30-60% de double vitrage","toute menuiserie porte précédée d’un sas","porte simple en bois porte opaque pleine","porte simple en métal porte opaque pleine","toute menuiserie porte opaque pleine isolée","porte simple en bois porte avec double vitrage","toute menuiserie porte isolée avec double vitrage","porte simple en métal porte avec vitrage simple","porte simple en bois porte avec 30-60% de vitrage simple","porte simple en pvc porte avec moins de 30% de vitrage simple","porte simple en pvc porte avec 30-60% de vitrage simple","porte simple en bois porte avec moins de 30% de vitrage simple","autre type de porte","porte simple en pvc porte avec double vitrage"}
surface_porte	batiment_groupe_dpe_representatif_logement	numeric	1	somme de la surface de portes du DPE	maintenu	\N	open_data_lo	0	0	\N
u_porte	batiment_groupe_dpe_representatif_logement	numeric	1	Coefficient de transmission thermique moyen des portes (W/m²/K)	maintenu	\N	open_data_lo	0	0	\N
classe_inertie	batiment_groupe_dpe_representatif_logement	text	1	classe d'inertie pour le DPE (de légère à très lourde)	maintenu	\N	open_data_lo	0	0	{"Légère","Lourde","Très Lourde","Moyenne"}
deperdition_mur	batiment_groupe_dpe_representatif_logement	numeric	1	somme des déperditions par les murs du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_plancher_bas	batiment_groupe_dpe_representatif_logement	numeric	1	somme des deperditions par les planchers bas du logement (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_plancher_haut	batiment_groupe_dpe_representatif_logement	numeric	1	somme des deperditions par les planchers hauts du logement (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_pont_thermique	batiment_groupe_dpe_representatif_logement	numeric	1	somme des deperditions par les portes du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
deperdition_porte	batiment_groupe_dpe_representatif_logement	numeric	1	somme des deperditions par les portes du DPE (W/K)	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dpe_statistique_logement	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
nb_loc_com_sec	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux d'activité secondaire	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_dpe_statistique_logement	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	0	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_classe_bilan_dpe_a	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe A	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_b	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe B	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_c	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe C	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_d	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe D	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_e	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe E	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_f	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe F	maintenu	\N	open_data_lo	0	0	\N
nb_classe_bilan_dpe_g	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe G	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_a	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique A. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_b	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique B. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_c	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique C. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_d	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique D. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_e	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique E. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_f	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique F. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
nb_classe_conso_energie_arrete_2012_g	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE de la classe énergétique G. valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
l_cat_org	batiment_groupe_rpls	text[]	1	(rpls) Catégories des organismes bailleurs	maintenu		ayant_droit_rpls	0	0	\N
nb_classe_conso_energie_arrete_2012_nc	batiment_groupe_dpe_statistique_logement	int4	1	(dpe) Nombre de DPE n'ayant pas fait l'objet d'un calcul d'étiquette énergie (DPE dits vierges). valable uniquement pour les DPE appliquant la méthode de l'arrêté du 8 février 2012	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_synthese_systeme_energetique_logement	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	batiment_groupe_synthese_systeme_energetique_logement	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
source_information_principale	batiment_groupe_synthese_systeme_energetique_logement	text	0	base de données source principale d'où est tirée directement les informations sur les systèmes énergétiques du bâtiment. (pour l'instant pas de combinaisons de sources voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"fcu","dle gaz","dle reseaux","dpe arrêté 2012 3cl immeuble","dpe arrêté 2012 3cl logement","dpe arrêté 2012 facture immeuble","dpe arrêté 2012 facture logement","dpe arrêté 2021 3cl immeuble","dpe arrêté 2021 3cl logement","dpe arrêté 2021 re2020 immeuble","dpe arrêté 2021 re2020 logement","dpe arrêté 2021 rt2012 immeuble","dpe arrêté 2021 rt2012 logement","rnc"}
score_fiabilite	batiment_groupe_synthese_systeme_energetique_logement	int4	0	score de fiabilité attribué aux informations affichées. En fonction de la source principale et du recoupement des informations de plusieurs sources le score peut être plus ou moins élevé. Le score maximal de confiance est de 10, le score minimal de 1. des informations recoupées par plusieurs sources ont un score de confiance plus élevé que des informations fournies par une unique source (voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_batiment_dpe	batiment_groupe_synthese_systeme_energetique_logement	text	1	défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d'information est un DPE.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"appartement","maison","immeuble"}
type_installation_chauffage	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'installation de chauffage (collectif ou individuel)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"individuel","collectif"}
type_energie_chauffage	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_chauffage	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de générateur de chauffage principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
annee_constr	batiment_groupe_dvf_logtype	text	1	année de construction du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
type_generateur_chauffage_anciennete	batiment_groupe_synthese_systeme_energetique_logement	text	1	ancienneté du générateur de chauffage principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_chauffage_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'énergie pour le générateur de chauffage d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_chauffage_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de générateur de chauffage d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"chaudiere bois","chaudiere charbon basse temperature","chaudiere charbon condensation","chaudiere charbon standard","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffage autre indetermine","chauffage bois indetermine","chauffage solaire","generateur air chaud combustion","generateurs a effet joule","pac air/air","pac air/eau","pac eau/eau","pac gaz","pac geothermique","pac indetermine","poele ou insert bois","poele ou insert charbon","poele ou insert fioul","poele ou insert gpl/butane/propane","poele ou insert indetermine","radiateurs gaz","reseau de chaleur","chaudiere gaz indetermine"}
type_generateur_chauffage_anciennete_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	ancienneté du générateur de chauffage d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
chauffage_solaire	batiment_groupe_synthese_systeme_energetique_logement	bool	1	présence de chauffage solaire	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
nb_generateur_chauffage	batiment_groupe_synthese_systeme_energetique_logement	int2	1	nombre de générateurs de chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
nb_installation_chauffage	batiment_groupe_synthese_systeme_energetique_logement	int2	1	nombre d'installation de chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_type_generateur_chauffage	batiment_groupe_synthese_systeme_energetique_logement	text[]	1	type de générateur de chauffage principal (enum version simplifiée BDNB) concaténé en liste pour tous les DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_energie_climatisation	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_climatisation	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de générateur de climatisation principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"pac air/eau","pac geothermique","pac air/air","pac gaz","pac eau/eau","reseau de froid"}
type_generateur_climatisation_anciennete	batiment_groupe_synthese_systeme_energetique_logement	text	1	ancienneté du générateur de climatisation principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_installation_ecs	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'installation d'eau chaude sanitaire (ECS) (collectif ou individuel)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"individuel","collectif"}
type_energie_ecs	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_ecs	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
l_siret	batiment_groupe_rpls	text[]	1	liste de siret	maintenu		ayant_droit_rpls	0	0	\N
type_generateur_ecs_anciennete	batiment_groupe_synthese_systeme_energetique_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
type_energie_ecs_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid"}
type_generateur_ecs_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ballon accumulation electrique","chaudiere bois","chaudiere charbon condensation","chaudiere charbon standard","chaudiere charbon basse temperature","chaudiere electrique","chaudiere energie indetermine basse temperature","chaudiere energie indetermine condensation","chaudiere energie indetermine indetermine","chaudiere energie indetermine standard","chaudiere fioul basse temperature","chaudiere fioul condensation","chaudiere fioul standard","chaudiere gaz basse temperature","chaudiere gaz condensation","chaudiere gaz standard","chaudiere gpl/butane/propane basse temperature","chaudiere gpl/butane/propane condensation","chaudiere gpl/butane/propane standard","chauffe eau electrique instantane","chauffe-eau fioul independant","chauffe-eau gaz independant","chauffe-eau gpl/butane/propane independant","chauffe-eau independant indetermine","ecs autre indetermine","ecs bois indetermine","ecs solaire","ecs thermodynamique electrique(pac ou ballon)","poele bouilleur bois","production mixte indetermine","reseau de chaleur"}
type_generateur_ecs_anciennete_appoint	batiment_groupe_synthese_systeme_energetique_logement	text	1	ancienneté du générateur d'eau chaude sanitaire (ECS) d'appoint	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"très ancien","ancien","neuf","récent(<15ans)"}
ecs_solaire	batiment_groupe_synthese_systeme_energetique_logement	bool	1	présence d'ecs solaire	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
nb_generateur_ecs	batiment_groupe_synthese_systeme_energetique_logement	int2	1	nombre de générateurs d'ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
nb_installation_ecs	batiment_groupe_synthese_systeme_energetique_logement	int2	1	nombre d'installation d'ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_type_generateur_ecs	batiment_groupe_synthese_systeme_energetique_logement	text[]	1	type de générateur d'ECS principal (enum version simplifiée BDNB) concaténé en liste pour tous les DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de système de ventilation du logement	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"Système de ventilation par entrées d’air hautes et basses","Ventilation mécanique auto réglable « après 1982 »","Ventilation mécanique double flux avec échangeur","Ventilation mécanique auto réglable « avant 1982 »","Ventilation naturelle par conduit","Puits canadien","Ventilation mécanique double flux sans échangeur","Ventilation mécanique auto réglable","Extracteur mécanique sur conduit non modifié de ventilation naturelle existante","Ventilation mécanique à extraction hygroréglable","Ventilation mécanique à extraction et entrées d’air hygroréglables","Ventilation hybride","Ventilation mécanique gaz hygroréglable","Ventilation hybride avec entrées d’air hygroréglables","Ventilation naturelle par conduit avec entrées d’air hygroréglables","Ventilation par ouverture des fenêtres"}
type_production_energie_renouvelable	batiment_groupe_synthese_systeme_energetique_logement	text	1	type de production ENR pour le DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"cogénération","eolien","eolien + cogénération","solaire photovoltaïque","solaire photovoltaïque + cogénération","solaire photovoltaïque + eolien","solaire photovoltaïque + eolien + cogénération"}
batiment_groupe_id	batiment_groupe_synthese_enveloppe	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	batiment_groupe_synthese_enveloppe	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
uw	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
facteur_solaire_baie_vitree	batiment_groupe_synthese_enveloppe	numeric	1	facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
siret_principal	batiment_groupe_rpls	text	1	(rpls) SIRET	maintenu		ayant_droit_rpls	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
source_information_principale	batiment_groupe_synthese_enveloppe	text	0	base de données source principale d'où est tirée directement les informations sur les systèmes énergétiques du bâtiment. (pour l'instant pas de combinaisons de sources voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"fichiers fonciers","dpe arrêté 2012 3cl immeuble","dpe arrêté 2012 3cl logement","dpe arrêté 2012 facture immeuble","dpe arrêté 2012 facture logement","dpe arrêté 2021 3cl immeuble","dpe arrêté 2021 3cl logement","dpe arrêté 2021 re2020 immeuble","dpe arrêté 2021 re2020 logement","dpe arrêté 2021 rt2012 immeuble","dpe arrêté 2021 rt2012 logement"}
score_fiabilite	batiment_groupe_synthese_enveloppe	int4	0	score de fiabilité attribué aux informations affichées. En fonction de la source principale et du recoupement des informations de plusieurs sources le score peut être plus ou moins élevé. Le score maximal de confiance est de 10, le score minimal de 1. des informations recoupées par plusieurs sources ont un score de confiance plus élevé que des informations fournies par une unique source (voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_batiment_dpe	batiment_groupe_synthese_enveloppe	text	1	défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d'information est un DPE.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_vitrage	batiment_groupe_synthese_enveloppe	text	1	type de vitrage principal des baies vitrées du DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"triple vitrage","brique de verre ou polycarbonate","double vitrage","survitrage","simple vitrage"}
type_materiaux_menuiserie	batiment_groupe_synthese_enveloppe	text	1	type de matériaux principal des menuiseries des baies vitrées du DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"brique de verre","polycarbonate","pvc","bois","métal","métal avec rupture de pont thermique","métal sans rupture de pont thermique","bois/métal","autres","bois ou pvc"}
type_gaz_lame	batiment_groupe_synthese_enveloppe	text	1	type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"air sec","argon ou krypton","inconnu"}
type_fermeture	batiment_groupe_synthese_enveloppe	text	1	type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"Volet roulant PVC ( e > 12 mm)","abscence de fermeture pour la baie vitrée","Persienne coulissante ou volet battant PVC, volet battant bois (e > 22 mm)","Fermeture sans ajours en position déployée, volets roulants alu","Persienne coulissante ou volet battant PVC, volet battant bois (e ≤ 22 mm)","Fermeture isolée sans ajours en position déployée","Jalousie accordéon, fermeture à lames orientables y compris les vénitiens extérieurs tout métal, volets battants ou persiennes avec ajours fixes","Volet roulant PVC ( e ≤ 12 mm)"}
epaisseur_lame	batiment_groupe_synthese_enveloppe	int2	1	epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
vitrage_vir	batiment_groupe_synthese_enveloppe	bool	1	le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d'un point de vue thermique.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant	batiment_groupe_synthese_enveloppe	text	1	indicateur du côté traversant du logement.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"90°","90° (faible)","est ouest","est ouest (faible)","non traversant","nord sud","nord sud (faible)","tout azimut","tout venant","tout venant (faible)"}
u_baie_vitree	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etage	batiment_groupe_dvf_logtype	text	1	étage (R+1 = 1) du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
presence_balcon	batiment_groupe_synthese_enveloppe	bool	1	présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_orientation_baie_vitree	batiment_groupe_synthese_enveloppe	text[]	1	liste des orientations des baies vitrées (enum version BDNB)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
pourcentage_surface_baie_vitree_exterieur	batiment_groupe_synthese_enveloppe	numeric	1	pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur	batiment_groupe_synthese_enveloppe	text	1	type d'isolation principal des murs donnant sur l'extérieur pour le DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
epaisseur_isolation_mur_exterieur_estim	batiment_groupe_synthese_enveloppe	int4	1	epaisseur d'isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d'une épaisseur déclarée c'est directement l'épaisseur déclarée qui est considérée, dans le cas contraire l'épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
materiaux_structure_mur_exterieur	batiment_groupe_synthese_enveloppe	text	1	matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"autre matériau innovant récent","autre matériau non répertorié","autre matériau traditionel ancien","brique terre cuite alvéolaire","béton cellulaire","cloison de plâtre","inconnu","monomur terre cuite","murs bois (rondin)","murs en blocs de béton creux","murs en blocs de béton pleins","murs en briques","murs en briques creuses","murs en briques pleines doubles avec lame d'air","murs en briques pleines simples","murs en béton","murs en béton banché","murs en béton de mâchefer","murs en ossature bois avec isolant en remplissage 2001-2005","murs en ossature bois avec isolant en remplissage <2001","murs en ossature bois avec isolant en remplissage ≥ 2006","murs en ossature bois avec remplissage tout venant","murs en ossature bois sans remplissage","murs en pan de bois avec remplissage tout venant","murs en pan de bois sans remplissage tout venant","murs en pierre","murs en pierre de taille et moellons avec remplissage tout venant","murs en pierre de taille et moellons constitué d'un seul matériaux","murs en pisé ou béton de terre stabilisé (à partir d'argile crue)","murs sandwich béton/isolant/béton (sans isolation rapportée)"}
classe_inertie_legere	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable classe_inertie soit legere	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
materiaux_structure_mur_exterieur_simplifie	batiment_groupe_synthese_enveloppe	text	1	materiaux principal utilié pour les murs extérieur simplifié. Cette information peut être récupérée de différentes sources (Fichiers Fonciers ou DPE pour le moment)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"autre","beton","bois","brique","pierre"}
epaisseur_structure_mur_exterieur	batiment_groupe_synthese_enveloppe	text	1	epaisseur moyenne de la partie structure du mur (sans l'isolation rapportée ni les doublages)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_mur_exterieur	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_local_non_chauffe_mur	batiment_groupe_synthese_enveloppe	text[]	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
local_non_chauffe_principal_mur	batiment_groupe_synthese_enveloppe	text	1	liste des locaux non chauffés en contact avec les murs (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
l_orientation_mur_exterieur	batiment_groupe_synthese_enveloppe	text[]	1	liste des orientations des murs donnant sur l'extérieur (enum version BDNB)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_generateur_ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas	batiment_groupe_synthese_enveloppe	text	1	type d'isolation principal des planchers bas déperditifs pour le DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_bas_deperditif	batiment_groupe_synthese_enveloppe	text	1	materiaux ou principe constructif principal des planchers bas	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"plancher lourd type entrevous terre-cuite, poutrelles béton","plancher avec ou sans remplissage","plancher bois sur solives bois","plancher à entrevous isolant","voutains en briques ou moellons","plancher entre solives bois avec ou sans remplissage","bardeaux et remplissage","plancher mitoyen non deperditif","inconnu","plancher bois sur solives métalliques","plancher entre solives métalliques avec ou sans remplissage","dalle béton","autre type de plancher non répertorié","voutains sur solives métalliques"}
u_plancher_bas_final_deperditif	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des planchers bas en prenant en compte l'atténuation forfaitaire du U lorsqu'en contact avec le sol de la méthode 3CL(W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_plancher_bas_brut_deperditif	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_local_non_chauffe_plancher_bas	batiment_groupe_synthese_enveloppe	text[]	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
local_non_chauffe_principal_plancher_bas	batiment_groupe_synthese_enveloppe	text	1	liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
type_adjacence_principal_plancher_bas	batiment_groupe_synthese_enveloppe	text	1	type d'adjacence principale des planchers bas (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
type_isolation_plancher_haut	batiment_groupe_synthese_enveloppe	text	1	type d'isolation principal des planchers hauts déperditifs pour le DPE	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ITR","inconnu","ITE","ITI","ITI+ITR","ITI+ITE","isole","non isole","ITE+ITR"}
type_plancher_haut_deperditif	batiment_groupe_synthese_enveloppe	text	1	materiaux ou principe constructif principal des planchers hauts	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"plafond mitoyen non deperditif","plafond bois sous solives métalliques","bardeaux et remplissage","autre type de plafond non répertorié","toiture en chaume","plafond bois sur solives métalliques","plafond entre solives métalliques avec ou sans remplissage","toitures en Bac acier","plafond lourd type entrevous terre-cuite, poutrelles béton","plafond avec ou sans remplissage","inconnu","plafond en plaque de plâtre","dalle béton","plafond entre solives bois avec ou sans remplissage","plafond avec ou sans remplissage sous combles","plafond bois sur solives bois","combles aménagés sous rampant","plafond bois sous solives bois"}
u_plancher_haut_deperditif	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
l_local_non_chauffe_plancher_haut	batiment_groupe_synthese_enveloppe	text[]	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
local_non_chauffe_principal_plancher_haut	batiment_groupe_synthese_enveloppe	text	1	liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","autres dépendances"}
type_adjacence_principal_plancher_haut	batiment_groupe_synthese_enveloppe	text	1	type d'adjacence principale des planchers haut (sont ils en contact avec l'extérieur ou un local non chauffé)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"extérieur","paroi enterrée","vide sanitaire","bâtiment ou local à usage autre que d'habitation","terre-plein","sous-sol non chauffé","locaux non chauffés non accessible","garage","cellier","espace tampon solarisé (véranda,loggia fermée)","comble fortement ventilé","comble faiblement ventilé","comble très faiblement ventilé","circulation sans ouverture directe sur l'extérieur","circulation avec ouverture directe sur l'extérieur","circulation avec bouche ou gaine de désenfumage ouverte en permanence","hall d'entrée avec dispositif de fermeture automatique","hall d'entrée sans dispositif de fermeture automatique","garage privé collectif","local tertiaire à l'intérieur de l'immeuble en contact avec l'appartement","autres dépendances","local non déperditif ( local à usage d'habitation chauffé)"}
materiaux_toiture_simplifie	batiment_groupe_synthese_enveloppe	text	1	materiaux principal utilié pour la toiture simplifié. Cette information peut être récupérée de différentes sources (Fichiers Fonciers ou DPE pour le moment)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"ardoise","autre","beton","tuile","zinc-aluminium"}
type_porte	batiment_groupe_synthese_enveloppe	text	1	type de porte du DPE (enum version DPE 2021)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"porte simple en pvc porte opaque pleine","porte simple en métal porte avec moins de 30% de double vitrage","porte simple en métal porte avec 30-60% de double vitrage","toute menuiserie porte précédée d’un sas","porte simple en bois porte opaque pleine","porte simple en métal porte opaque pleine","toute menuiserie porte opaque pleine isolée","porte simple en bois porte avec double vitrage","toute menuiserie porte isolée avec double vitrage","porte simple en métal porte avec vitrage simple","porte simple en bois porte avec 30-60% de vitrage simple","porte simple en pvc porte avec moins de 30% de vitrage simple","porte simple en pvc porte avec 30-60% de vitrage simple","porte simple en bois porte avec moins de 30% de vitrage simple","autre type de porte","porte simple en pvc porte avec double vitrage"}
u_porte	batiment_groupe_synthese_enveloppe	numeric	1	Coefficient de transmission thermique moyen des portes (W/m²/K)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie	batiment_groupe_synthese_enveloppe	text	1	classe d'inertie pour le DPE (de légère à très lourde)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"Légère","Lourde","Très Lourde","Moyenne"}
batiment_groupe_id	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
u_mur_exterieur_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de u_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_mur_exterieur_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour u_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_mur_exterieur_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for u_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_mur_exterieur_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de u_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_baie_vitree_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de u_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_baie_vitree_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour u_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_baie_vitree_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for u_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_baie_vitree_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de u_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
uw_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de uw	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
uw_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour uw	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
uw_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for uw	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
uw_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de uw	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_plancher_haut_deperditif_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de u_plancher_haut_deperditif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_plancher_haut_deperditif_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour u_plancher_haut_deperditif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_plancher_haut_deperditif_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for u_plancher_haut_deperditif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
u_plancher_haut_deperditif_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de u_plancher_haut_deperditif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable classe_inertie	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie_moyenne	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable classe_inertie soit moyenne	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie_lourde	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable classe_inertie soit lourde	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie_tres_lourde	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable classe_inertie soit tres_lourde	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
facteur_solaire_baie_vitree_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de facteur_solaire_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
facteur_solaire_baie_vitree_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour facteur_solaire_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
facteur_solaire_baie_vitree_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for facteur_solaire_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
facteur_solaire_baie_vitree_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de facteur_solaire_baie_vitree	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
pourcentage_surface_baie_vitree_exterieur_lower	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne inférieure de l'intervalle à 95% pour les valeurs de pourcentage_surface_baie_vitree_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
pourcentage_surface_baie_vitree_exterieur_mean	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Valeur moyenne pour pourcentage_surface_baie_vitree_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
pourcentage_surface_baie_vitree_exterieur_upper	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	Borne supérieure de l'intervalle à 95% pour les valeurs de for pourcentage_surface_baie_vitree_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
pourcentage_surface_baie_vitree_exterieur_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	double	1	valeur aléatoire tirée dans la distribution probabiliste de pourcentage_surface_baie_vitree_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable traversant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_90	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable traversant soit 90	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_est_ouest	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable traversant soit est_ouest	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_non_traversant	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable traversant soit non_traversant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_nord_sud	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable traversant soit nord_sud	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_tout_azimut	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable traversant soit tout_azimut	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_fermeture	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_abscence_fermeture	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit abscence de fermeture pour la baie vitrée	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_fermeture_isolee_sans_ajours	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Fermeture isolée sans ajours en position déployée	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_lame_orientable_ou_battant_ajour_fixe	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Jalousie accordéon, fermeture à lames orientables y compris les vénitiens extérieurs tout métal, volets battants ou persiennes avec ajours fixes	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_persienne_volet_battant_inf_22_mm	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Persienne coulissante ou volet battant PVC, volet battant bois (e ≤ 22 mm)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_persienne_volet_battant_sup_22_mm	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Persienne coulissante ou volet battant PVC, volet battant bois (e > 22 mm)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_sans_ajour_ou_volet_alu	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Fermeture sans ajours en position déployée, volets roulants alu	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_volet_roulant_pvc_inf_12_mm	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Volet roulant PVC ( e ≤ 12 mm)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_volet_roulant_pvc_sup_12_mm	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_fermeture soit Volet roulant PVC ( e > 12 mm)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_generateur_chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_bois	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere bois	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_isolation_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_charbon_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere charbon basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_charbon_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere charbon condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_ecs_solaire	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit ecs solaire	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_charbon_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere charbon standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_electrique	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere electrique	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_energie_indet_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere energie indetermine basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_energie_indet_cond	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere energie indetermine condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_energie_indet_indet	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere energie indetermine indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_energie_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere energie indetermine standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_fioul_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere fioul basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_fioul_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere fioul condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_fioul_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere fioul standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gaz_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gaz basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gaz_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gaz condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gaz_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gaz indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gaz_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gaz standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gpl_but_prop_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gpl/butane/propane basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gpl_but_prop_cond	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gpl/butane/propane condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chaudiere_gpl_but_prop_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chaudiere gpl/butane/propane standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chauffage_autre_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chauffage autre indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chauffage_bois_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chauffage bois indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_chauffage_solaire	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit chauffage solaire	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_generateur_air_chaud_comb	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit generateur air chaud combustion	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_generateurs_a_effet_joule	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit generateurs a effet joule	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_air_air	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac air/air	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_air_eau	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac air/eau	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_eau_eau	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac eau/eau	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_gaz	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac gaz	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_geothermique	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac geothermique	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_pac_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit pac indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_poele_ou_insert_bois	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit poele ou insert bois	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_poele_ou_insert_charbon	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit poele ou insert charbon	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_poele_ou_insert_fioul	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit poele ou insert fioul	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_poele_ou_insert_gpl_but_prop	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit poele ou insert gpl/butane/propane	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_poele_ou_insert_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit poele ou insert indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_radiateurs_gaz	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit radiateurs gaz	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_reseau_de_chaleur	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_chauffage soit reseau de chaleur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_ballon_accumulation_electrique	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit ballon accumulation electrique	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_bois	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere bois	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_charbon_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere charbon basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_charbon_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere charbon condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_charbon_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere charbon standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_ecs_energie_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere energie indetermine basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_electrique	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere electrique	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_energie_indet_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere energie indetermine condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_energie_indet_indet	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere energie indetermine indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_energie_indet_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere energie indetermine standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_fioul_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere fioul basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_fioul_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere fioul condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_fioul_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere fioul standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gaz_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gaz basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gaz_condensation	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gaz condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gaz_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gaz standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gpl_but_prop_basse_temp	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gpl/butane/propane basse temperature	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gpl_but_prop_standard	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gpl/butane/propane standard	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chaudiere_gpl_butane_propane_cond	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chaudiere gpl/butane/propane condensation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chauffe_eau_electrique_instantane	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chauffe eau electrique instantane	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chauffe_eau_fioul_independant	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chauffe-eau fioul independant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chauffe_eau_gaz_independant	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chauffe-eau gaz independant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chauffe_eau_gpl_but_prop_independent	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chauffe-eau gpl/butane/propane independant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_chauffe_eau_independant	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit chauffe-eau independant indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_ecs_autre_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit ecs autre indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_ecs_bois_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit ecs bois indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_ecs_thermodynamique_elec	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit ecs thermodynamique electrique(pac ou ballon)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_poele_bouilleur_bois	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit poele bouilleur bois	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_production_mixte_indetermine	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit production mixte indetermine	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_reseau_de_chaleur	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_generateur_ecs soit reseau de chaleur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_chauffage_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_installation_chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_chauffage_collectif	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_installation_chauffage soit collectif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_chauffage_individuel	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_installation_chauffage soit individuel	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_ecs_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_installation_ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_ecs_collectif	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_installation_ecs soit collectif	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_ecs_individuel	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_installation_ecs soit individuel	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
valeur_loc	batiment_groupe_dvf_logtype	int8	1	(dv3f) valeur locative estimée du local [€]	maintenu		ayant_droit_dv3f	0	0	\N
type_isolation_mur_exterieur_inconnu	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit inconnu	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_ite_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITE+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_iti	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITI	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_iti_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITI+ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_iti_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITI+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_non_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_mur_exterieur soit non isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_isolation_plancher_bas	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_inconnu	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit inconnu	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_ite_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITE+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_iti	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITI	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_iti_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITI+ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_iti_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITI+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_non_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_bas soit non isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_isolation_plancher_haut	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_inconnu	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit inconnu	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_ite_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITE+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_iti	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITI	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_iti_ite	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITI+ITE	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_iti_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITI+ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_itr	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit ITR	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_non_isole	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_isolation_plancher_haut soit non isole	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_top	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Modalité la plus probable de la variable type_ventilation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_entree_air_haut_bas	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Système de ventilation par entrées d’air hautes et basses	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_extracteur_meca_sur_conduit	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Extracteur mécanique sur conduit non modifié de ventilation naturelle existante	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_hybride	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation hybride	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_hybride_entree_hygro	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation hybride avec entrées d’air hygroréglables	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_autoreglable	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique auto réglable	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_autoreglable_apres_82	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique auto réglable « après 1982 »	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_autoreglable_avant_82	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique auto réglable « avant 1982 »	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_double_flux_avec_echangeur	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique double flux avec échangeur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_double_flux_sans_echangeur	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique double flux sans échangeur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
batiment_groupe_id	batiment_groupe_synthese_systeme_energetique_tertiaire	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
type_ventilation_meca_extraction_entree_hygro	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique à extraction et entrées d’air hygroréglables	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_extraction_hygro	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique à extraction hygroréglable	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_meca_gaz_hygro	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation mécanique gaz hygroréglable	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_naturelle_conduit_hygro	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation naturelle par conduit avec entrées d’air hygroréglables	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_naturelle_par_conduit	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation naturelle par conduit	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_par_ouverture_des_fenetres	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Ventilation par ouverture des fenêtres	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_puits_canadien	batiment_groupe_imputation_enveloppe_et_systemes_proba	long	1	Probabilité que la variable type_ventilation soit Puits canadien	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
classe_inertie_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable classe_inertie	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
traversant_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable traversant	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_fermeture_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_fermeture	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_chauffage_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_generateur_chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_generateur_ecs_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_generateur_ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_chauffage_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_installation_chauffage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_installation_ecs_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_installation_ecs	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_mur_exterieur_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_isolation_mur_exterieur	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_bas_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_isolation_plancher_bas	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_isolation_plancher_haut_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_isolation_plancher_haut	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_ventilation_random	batiment_groupe_imputation_enveloppe_et_systemes_proba	string	1	Valeur aléatoire tirée dans l'échantillon Monte Carlo la variable type_ventilation	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
code_departement_insee	batiment_groupe_synthese_systeme_energetique_tertiaire	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
source_information_principale	batiment_groupe_synthese_systeme_energetique_tertiaire	text	0	base de données source principale d'où est tirée directement les informations sur les systèmes énergétiques du bâtiment. (pour l'instant pas de combinaisons de sources voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"fcu","dle gaz","dle reseaux","dpe 2006 tertiaire et erp"}
score_fiabilite	batiment_groupe_synthese_systeme_energetique_tertiaire	int4	0	score de fiabilité attribué aux informations affichées. En fonction de la source principale et du recoupement des informations de plusieurs sources le score peut être plus ou moins élevé. Le score maximal de confiance est de 10, le score minimal de 1. des informations recoupées par plusieurs sources ont un score de confiance plus élevé que des informations fournies par une unique source (voir méthodo)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_energie_chauffage	batiment_groupe_synthese_systeme_energetique_tertiaire	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_ecs	batiment_groupe_synthese_systeme_energetique_tertiaire	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_climatisation	batiment_groupe_synthese_systeme_energetique_tertiaire	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
identifiant_dpe	dpe_tertiaire	text	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	dpe_tertiaire	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
type_dpe_tertiaire	dpe_tertiaire	text	0	le DPE tertiaire applique l'arrêté de 2006 sur le DPE et n'a pas été revu depuis. Pour le moment cette colonne vaut toujours : 'dpe 2006 tertiaire et erp'	maintenu	\N	open_data_lo	0	0	{"dpe 2006 tertiaire et erp"}
source_nouvelle_base_ademe	dpe_tertiaire	bool	1	le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l'ancienne base de données (2012-2021)	maintenu	\N	open_data_lo	0	0	\N
methode_application_dpe_tertiaire	dpe_tertiaire	text	1	methode d'application du DPE tertiaire (facture, vierge ou neuf)	maintenu	\N	open_data_lo	0	0	{"dpe tertiaire facture","dpe tertiaire bâtiment neuf","dpe tertiaire vierge","dpe tertiaire vierge neuf","dpe tertiaire facture dans un bâtiment de logement","dpe tertiaire bâtiment neuf dans un bâtiment de logement","dpe tertiaire vierge dans un bâtiment de logement","dpe tertiaire vierge neuf dans un bâtiment de logement"}
version	dpe_tertiaire	text	1	version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu'à partir d'une certaine version	maintenu	\N	open_data_lo	0	0	\N
date_etablissement_dpe	dpe_tertiaire	timestamp	1	date de l'établissement du dpe	maintenu	\N	open_data_lo	0	0	\N
date_reception_dpe	dpe_tertiaire	timestamp	1	date de réception du DPE dans la base de données de l'ADEME	maintenu	\N	open_data_lo	0	0	\N
annee_construction_dpe	dpe_tertiaire	smallint	1	année de construction du logement évaluée par le DPE	maintenu	\N	open_data_lo	0	0	\N
shon	dpe_tertiaire	numeric	1	surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution	maintenu	m2	open_data_lo	0	0	\N
surface_utile	dpe_tertiaire	numeric	1	surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires	maintenu	m2	open_data_lo	0	0	\N
code_iris	parcelle_unifiee	varchar(9)	1	Code iris INSEE	maintenu	\N	ayant_droit_ffo	0	0	\N
classe_conso_energie_dpe_tertiaire	dpe_tertiaire	text	1	classe de consommation d'energie primaire du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","H","I"}
classe_emission_ges_dpe_tertiaire	dpe_tertiaire	text	1	classe d'emission GES du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","H","I"}
conso_dpe_tertiaire_ep_m2	dpe_tertiaire	numeric	1	consommation d'energie primaire du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	kwhep/m²/an	open_data_lo	0	0	\N
emission_ges_dpe_tertiaire_m2	dpe_tertiaire	numeric	1	emission GES du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	kgCO2/m²/an	open_data_lo	0	0	\N
categorie_erp_dpe_tertiaire	dpe_tertiaire	text	1	categorie d'ERP du DPE tertiaire	maintenu	\N	open_data_lo	0	0	{"1ère catégorie","2ème catégorie","3ème catégorie","4ème catégorie","5ème catégorie"}
periode_construction_dpe	dpe_tertiaire	text	1	période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.	maintenu	\N	open_data_lo	0	0	{"1983-1988","2013-2021","1989-2000","1978-1982","2006-2012","après 2021","avant 1948","1948-1974","1975-1977","2001-2005"}
type_erp_dpe_tertiaire	dpe_tertiaire	text	1	type d'ERP pour le DPE tertiaire, si l'usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n'est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"	maintenu	\N	open_data_lo	0	0	{"j : structures d’accueil pour personnes âgées ou personnes handicapées","l : salles d'auditions, de conférences, de réunions, de spectacles ou à usage multiple","m : magasins de vente, centres commerciaux","n : restaurants et débits de boisson","o : hôtels et pensions de famille","p : salles de danse et salles de jeux","r : établissements d’éveil, d’enseignement, de formation, centres de vacances, centres de loisirs sans hébergement","s : bibliothèques, centres de documentation","t : salles d'exposition à vocation commerciale","u : établissements de soins","v : établissements de divers cultes","w : administrations, banques, bureaux","x : établissements sportifs couverts","y : musées","pa : établissements de plein air","cts : chapiteaux, tentes et structures toile","sg : structures gonflables","ps : parcs de stationnement couverts","oa : hôtels-restaurants d'altitude","ga : gares accessibles au public (chemins de fer, téléphériques, remonte-pentes...)","ef : établissements flottants (eaux intérieures)","ref : refuges de montagne","gha : habitation","gho : hôtel","ghr : enseignement","ghs : dépôt d'archives","ghtc : tour de contrôle","ghu : usage sanitaire","ghw : bureaux","ghz : usage mixte","locaux d'entreprise (bureaux)","autres tertiaires non erp"}
sous_modele_dpe_tertiaire	dpe_tertiaire	text	1	sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)	maintenu	\N	open_data_lo	0	0	{"bureaux, services administratifs, enseignement","bâtiments à occupation continue","autres","centre commercial"}
type_energie_chauffage	dpe_tertiaire	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_ecs	dpe_tertiaire	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_climatisation	dpe_tertiaire	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
derniere_annee_consommation	dpe_tertiaire	smallint	1	dernière année de consommation utilisée pour le calcul du DPE tertiaire	maintenu	\N	open_data_lo	0	0	\N
conso_autre_fossile	dpe_tertiaire	numeric	1	consommation d'autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_bois	dpe_tertiaire	numeric	1	consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_electricite	dpe_tertiaire	numeric	1	consommation d'électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_fioul	dpe_tertiaire	numeric	1	consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_gaz	dpe_tertiaire	numeric	1	consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_gpl_butane_propane	dpe_tertiaire	numeric	1	consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_reseau_chaleur	dpe_tertiaire	numeric	1	consommation d'énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
libelle_adr_principale	parcelle_unifiee_metrique	text	1	libellé complet de l'adresse principale	maintenu	\N	ayant_droit_ffo	0	0	\N
conso_reseau_froid	dpe_tertiaire	numeric	1	consommation d'énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
cle_interop_adr	adresse	TEXT	0	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	1	\N
cle_interop_adr	adresse_metrique	text	0	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	adresse	VARCHAR(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
numero	adresse	INT4	1	Numéro de l'adresse	maintenu	\N	open_data_lo	0	0	\N
rep	adresse	TEXT	1	Indice de répétition du numéro de l'adresse	maintenu	\N	open_data_lo	0	0	\N
type_voie	adresse	TEXT	1	Type de voie	maintenu	\N	open_data_lo	0	0	\N
nom_voie	adresse	TEXT	0	Nom de la voie	maintenu	\N	open_data_lo	0	0	\N
libelle_adresse	adresse	TEXT	0	Libellé complet de l'adresse	maintenu	\N	open_data_lo	0	0	\N
code_postal	adresse	VARCHAR(5)	1	Code postal	maintenu	\N	open_data_lo	0	0	\N
code_commune_insee	adresse	VARCHAR(5)	0	Code INSEE de la commune	maintenu	\N	open_data_lo	0	0	\N
libelle_commune	adresse	TEXT	0	Libellé de la commune	maintenu	\N	open_data_lo	0	0	\N
source	adresse	TEXT	0	source de l'adresse BAN ou ARCEP	maintenu	\N	open_data_lo	0	0	{"Arcep","BAN"}
geom_adresse	adresse	GEOMETRY(Point, 2154)	0	Géométrie de l'adresse (Lambert-93)	maintenu	\N	open_data_lo	1	0	\N
batiment_id	batiment	varchar(24)	0	Identifiant du bâtiment fiscal au sens des fichiers fonciers	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	batiment	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_groupe_id	batiment	varchar(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_ffo	1	0	\N
code_iris	batiment	varchar(9)	0	Code iris INSEE	maintenu	\N	ayant_droit_ffo	1	0	\N
code_commune_insee	batiment	varchar(5)	0	Code INSEE de la commune	maintenu	\N	ayant_droit_ffo	1	0	\N
parcelle_unifiee_id	batiment	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	0	\N
origine	batiment	TEXT	0	Origine de l'entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d'un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)	maintenu	\N	ayant_droit_ffo	0	0	{"Association géométrique","Fichiers Fonciers"}
batiment_construction_id	batiment_construction	varchar(22)	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	batiment_construction	varchar(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	batiment_construction	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
parcelle_unifiee_id	batiment_construction	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	0	\N
code_iris	batiment_construction	varchar(9)	0	Code iris INSEE	maintenu	\N	open_data_lo	1	0	\N
code_commune_insee	batiment_construction	varchar(5)	0	Code INSEE de la commune	maintenu	\N	open_data_lo	1	0	\N
s_geom_cstr	batiment_construction	int4	1	(ign) Surface au sol de la géométrie de la construction [m²]	maintenu	\N	open_data_lo	0	0	\N
hauteur	batiment_construction	numeric	1	(ign) Hauteur du bâtiment physique [m]	maintenu	\N	open_data_lo	0	0	\N
altitude_sol	batiment_construction	numeric	1	(ign) Altitude moynne au pied du bâtiment physique [m]	maintenu	\N	open_data_lo	0	0	\N
fictive_hauteur_cstr	batiment_construction	bool	1	(ign) Variable renvoyant : "vrai" si la hauteur est fictive, "faux" elle correspond à une hauteur réelle	maintenu	\N	open_data_lo	0	0	\N
fictive_geom_cstr	batiment_construction	bool	1	(ign) Variable renvoyant : "vrai" si la géométrie est fictive (et la surface au sol n'est pas réelle), "faux" elle correspond à une emprise au sol réelle	maintenu	\N	open_data_lo	0	0	\N
geom_cstr	batiment_construction	geometry(MultiPolygon, 2154)	1	(ign) Géométrie multipolygonale de l'enceinte du bâtiment (Lambert-93)	maintenu	\N	open_data_lo	1	0	\N
batiment_groupe_id	batiment_groupe	varchar(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
parcelle_unifiee_id	batiment_groupe	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	0	\N
code_departement_insee	batiment_groupe	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
s_geom_groupe	batiment_groupe	int4	1	Surface au sol de la géométrie du bâtiment groupe (geom_groupe)	maintenu	\N	open_data_lo	0	0	\N
code_iris	batiment_groupe	varchar(9)	0	Code iris INSEE	maintenu	\N	open_data_lo	1	0	\N
code_commune_insee	batiment_groupe	varchar(5)	0	Code INSEE de la commune	maintenu	\N	open_data_lo	1	0	\N
libelle_commune_insee	batiment_groupe	text	1	(insee) Libellé de la commune accueillant le groupe de bâtiment	maintenu	\N	open_data_lo	0	0	\N
code_epci_insee	batiment_groupe	TEXT	1	Code de l'EPCI	maintenu	\N	open_data_lo	1	0	\N
contient_fictive_geom_groupe	batiment_groupe	bool	1	Vaut "vrai", si la géométrie du groupe de bâtiment est générée automatiquement et ne représente pas la géométrie du groupe de bâtiment.	maintenu	\N	open_data_lo	0	0	\N
geom_groupe	batiment_groupe	GEOMETRY(MultiPolygon, 2154)	0	Géométrie multipolygonale du groupe de bâtiment (Lambert-93)	maintenu	\N	open_data_lo	1	0	\N
local_id	local	varchar(12)	0	identifiant du local dans les Fichiers Fonciers (Concaténation de ccodep, invar)	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	local	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_id	local	varchar(16)	0	Identifiant du bâtiment fiscal au sens des fichiers fonciers	maintenu	\N	ayant_droit_ffo	1	0	\N
parcelle_id	local	varchar(14)	0	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	ayant_droit_ffo	1	0	\N
parcelle_unifiee_id	local	varchar(14)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	0	0	\N
code_commune_insee	local	varchar(5)	1	Code INSEE de la commune	maintenu	\N	ayant_droit_ffo	1	0	\N
libelle_commune	local	varchar(45)	1	Libellé de la commune	maintenu	\N	ayant_droit_ffo	0	0	\N
invariant	local	varchar(10)	0	(ffo:invar) Numéro invariant	maintenu	\N	ayant_droit_ffo	0	0	\N
parcelle_id	parcelle	varchar(14)	0	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	parcelle	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
code_commune_insee	parcelle	varchar(5)	0	Code INSEE de la commune	maintenu	\N	open_data_lo	1	0	\N
parcelle_unifiee_id	parcelle	varchar(22)	1	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	0	\N
s_geom_parcelle	parcelle	NUMERIC	1	(ffo) Surface au sol de la géométrie de parcelle	maintenu	\N	open_data_lo	0	0	\N
geom_parcelle	parcelle	geometry(MultiPolygon, 2154)	1	(ffo:geompar) Géometrie de la parcelle cadastrale (Lambert-93)	maintenu	\N	open_data_lo	1	0	\N
personne_id	proprietaire	varchar(8)	0	Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)	maintenu	\N	open_data_lo	1	1	\N
parcelle_unifiee_id	parcelle_unifiee	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	parcelle_unifiee	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
code_commune_insee	parcelle_unifiee	varchar(5)	1	Code INSEE de la commune	maintenu	\N	ayant_droit_ffo	0	0	\N
origine	parcelle_unifiee	TEXT	0	Origine de l'entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d'un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)	maintenu	\N	ayant_droit_ffo	0	0	\N
categorie	parcelle_unifiee	TEXT	0	type de parcelle unifiée (n-> nb de bat issus des fichiers fonciers, m-> nb de geom issus de la bdtopo)	maintenu	\N	ayant_droit_ffo	0	0	\N
fictive_geom_parcelle_unifiee	parcelle_unifiee	bool	1	(ffo:contour) pour les parcelles unifiées issues des TUPs, certaines TUPs sont supposées fictives par le cerema	maintenu	\N	ayant_droit_ffo	0	0	\N
s_geom_parcelle_unifiee	parcelle_unifiee	int4	1	surface du regroupement de parcelle [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
geom_parcelle_unifiee	parcelle_unifiee	geometry(multipolygon, 2154)	1	géométrie polygonale du regroupement de parcelle (Lambert-93)	maintenu	\N	ayant_droit_ffo	1	0	\N
transformation_id	passage_millesime_batiment_groupe_id	varchar(15)	0	identifiant unique de la transformation	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	passage_millesime_batiment_groupe_id	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
ancien_millesime	passage_millesime_batiment_groupe_id	varchar(10)	0	Ancien millésime	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
ancien_id	passage_millesime_batiment_groupe_id	varchar(30)	1	identifiant du batiment_groupe_id dans l'ancien millésime	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
nouveau_millesime	passage_millesime_batiment_groupe_id	varchar(10)	0	Nouveau millésime	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
nouvel_id	passage_millesime_batiment_groupe_id	varchar(22)	1	identifiant du batiment_groupe_id dans le nouveau millésime	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
type_modification	passage_millesime_batiment_groupe_id	varchar(38)	0	Type de modification effectué entre l'ancien et le nouveau millésime (creation, renommage, suppression, fusion, division, transformation complexe)	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"creation","renommage","renommage sans modification de données","suppression","fusion","division","transformation complexe"}
batiment_groupe_id	batiment_groupe_bdtopo_zoac	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
valeur_fonciere_par_m2_hab	batiment_groupe_dvf_logtype	int8	1	(dv3f) valeur foncière du local par m² habitable [€/m²]	maintenu	€/m²	ayant_droit_dv3f	0	0	\N
siren	proprietaire	varchar(9)	1	Numéro de SIREN d'une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	proprietaire	varchar(2)	1	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_locaux	proprietaire	int8	1	nombre de locaux possédé par le propriétaire	maintenu	\N	ayant_droit_ffo	0	0	\N
s_locaux	proprietaire	int8	1	(ffo:slocal) surface totale de local détenue par le propriétaire [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log	proprietaire	int8	1	nombre de logements possédé par le propriétaire	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log	proprietaire	int8	1	(ffo) Surface totale des pièces d'habitation des locaux possédés par le proprietaire (en m²) (Utilisation de l'attribut dsupdc, nul si npevph nul) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
forme_juridique	proprietaire	varchar(4)	1	Forme juridique du propriétaire (FF)	maintenu	\N	open_data_lo	0	0	\N
denomination	proprietaire	varchar(60)	1	Dénomination du propriétaire (FF)	maintenu	\N	open_data_lo	0	0	\N
adr_lign3	proprietaire	varchar(30)	1	3e ligne d'adresse postale du propriétaire (FF)	maintenu	\N	ayant_droit_ffo	0	0	\N
adr_lign4	proprietaire	varchar(36)	1	(ffo:dlign4) 4e ligne d'adresse postale du propriétaire	maintenu	\N	ayant_droit_ffo	0	0	\N
code_postal	proprietaire	varchar(5)	1	Code postal	maintenu	\N	open_data_lo	0	0	\N
libelle_commune	proprietaire	varchar(32)	1	Libellé de la commune	maintenu	\N	open_data_lo	0	0	\N
personne_type	proprietaire	varchar(17)	1	(ffo:gtoper) Personne physique ou Personne morale (FF)	maintenu	\N	ayant_droit_ffo	0	0	\N
cat_personne_groupe	proprietaire	TEXT	1	(ffo:ccogrmtxt) Code du groupe du propriétaire	maintenu	\N	ayant_droit_ffo	0	0	\N
cat_personne_nature	proprietaire	varchar(3)	1	(ffo:dnatpr) Code sur la nature du propriétaire (FF)	maintenu	\N	ayant_droit_ffo	0	0	\N
cat_personne_classe2	proprietaire	TEXT	1	(ffo:catpro2txt) Classification de propriétaire niveau 2	maintenu	\N	ayant_droit_ffo	0	0	\N
cat_personne_classe3	proprietaire	varchar(105)	1	(ffo:catpro3txt) Classification de propriétaire niveau 3	maintenu	\N	ayant_droit_ffo	0	0	\N
proprietaire_ou_gestionnaire	proprietaire	varchar(12)	1	(ffo:typedroit) proprietaire ou gestionnaire	maintenu	\N	ayant_droit_ffo	0	0	\N
bailleur	proprietaire	bool	1	(ffo:catpro2) True si le propriétaire est un bailleur social (ORGANISME DE LOGEMENT SOCIAL)	maintenu	\N	ayant_droit_ffo	0	0	\N
dans_majic_pm	proprietaire	bool	1	(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_open	proprietaire	int4	1	nombre de locaux possédé par le propriétaire diffusé dans majic personne morale	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dle_gaz_multimillesime	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		open_data_lo	1	1	\N
nb_pdl_res	batiment_groupe_enepdl	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	déprécié		ayant_droit_enedis	0	0	\N
code_departement_insee	adresse_metrique	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_batiment	adresse_metrique	int4	0	Nombre de bâtiments	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_batiment_hors_dep	adresse_metrique	int4	0	Nombre de bâtiments (au sens des fichiers fonciers) hors dépendances desservies par l'adresse	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_bat_grp	adresse_metrique	int4	0	Nombre de bâtiments desservis par l'adresse	maintenu	\N	open_data_lo	0	0	\N
nb_bat_grp_hors_dep	adresse_metrique	int4	0	Nombre de bâtiments (hors dépendances) desservis par l'adresse	maintenu	\N	open_data_lo	0	0	\N
nb_parcelle_unifiee	adresse_metrique	int4	0	Nombre de parcelles unifiées desservies par l'adresse	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_parcelle_unifiee_hors_dep	adresse_metrique	int4	0	Nombre de parcelles unifiées desservies par l'adresse (hors couple parcelle_unifiee/adresse pointant sur une dépendance)	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	batiment_groupe_adresse	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_adresse	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
cle_interop_adr_principale_ban	batiment_groupe_adresse	text	1	Clé d'interopérabilité de l'adresse principale (issue de la BAN)	maintenu	\N	open_data_lo	0	0	\N
libelle_adr_principale_ban	batiment_groupe_adresse	text	1	Libellé complet de l'adresse principale (issue de la BAN)	maintenu	\N	open_data_lo	0	0	\N
nb_adresse	batiment_groupe_adresse	int4	1	Nombre d'adresses	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valid	batiment_groupe_adresse	int4	1	[DEPRECIEE] Nombre d'adresses valides différentes qui desservent le groupe de bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valid_ban	batiment_groupe_adresse	int4	1	Nombre d'adresses valides différentes provenant de la BAN qui desservent le groupe de bâtiment	maintenu	\N	open_data_lo	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
identifiant_reseau	batiment_groupe_dle_reseaux_2020	TEXT	1	Identifiant du reseau de chaleur	déprécié	\N	open_data_lo	0	0	\N
type_reseau	batiment_groupe_dle_reseaux_2020	TEXT	1	type du réseau de chaleur	déprécié	\N	open_data_lo	0	0	\N
fiabilite_cr_adr_niv_1	batiment_groupe_adresse	text	1	Fiabilité des données croisées à l'adresse ('données croisées à l'adresse fiables', 'données croisées à l'adresse fiables à l'echelle de la parcelle unifiee', 'données croisées à l'adresse moyennement fiables', 'problème de géocodage')	maintenu	\N	open_data_lo	0	0	{"données croisées à l'adresse fiables","données croisées à l'adresse fiables à l'echelle de la parcelle unifiee","données croisées à l'adresse moyennement fiables","problème de géocodage"}
fiabilite_cr_adr_niv_2	batiment_groupe_adresse	text	1	Fiabilité détaillée des données croisées à l'adresse	maintenu	\N	open_data_lo	0	0	{"batiment mal géocodé","batiment sur parcelle unifiee avec adresses non-exclusives","batiment sur parcelle unifiée dont les seuls voisins sont des dépendances","batiment sans voisin à l'adresse","batiment sur parcelle unifiee sans voisin à l'adresse","batiment dont les seuls voisins sont des dépendances"}
batiment_groupe_id	batiment_groupe_argiles	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_argiles	varchar(2)	0	Code département INSEE	déprécié	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
alea	batiment_groupe_argiles	TEXT	1	(argiles) Aléa du risque argiles	déprécié	\N	open_data_lo	0	0	{"Fort","Faible","Moyen"}
batiment_groupe_id	batiment_groupe_bdtopo_bat	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
conso_pro	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	déprécié	kWh	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation totale [kWh/an]	déprécié	kWh/an	open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
code_departement_insee	batiment_groupe_bdtopo_bat	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_nature	batiment_groupe_bdtopo_bat	text[]	1	(ign) Catégorie de nature du bâtiment	maintenu	\N	open_data_lo	0	0	\N
l_usage_1	batiment_groupe_bdtopo_bat	text[]	1	(ign) Usage principal du bâtiment	maintenu	\N	open_data_lo	0	0	\N
l_usage_2	batiment_groupe_bdtopo_bat	text[]	1	(ign) Usage secondaire du bâtiment	maintenu	\N	open_data_lo	0	0	\N
l_etat	batiment_groupe_bdtopo_bat	text[]	1	(ign) Etat des bâtiments	maintenu	\N	open_data_lo	0	0	\N
hauteur_mean	batiment_groupe_bdtopo_bat	int4	1	(ign) Hauteur moyenne des bâtiments [m]	maintenu	\N	open_data_lo	0	0	\N
max_hauteur	batiment_groupe_bdtopo_bat	int4	1	(ign) Hauteur maximale des bâtiments [m]	maintenu	\N	open_data_lo	0	0	\N
altitude_sol_mean	batiment_groupe_bdtopo_bat	int4	1	(ign) Altitude au sol moyenne [m]	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_bdtopo_equ	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_bdtopo_equ	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_nature	batiment_groupe_bdtopo_equ	text[]	1	(ign) Catégorie de nature du bâtiment	maintenu	\N	open_data_lo	0	0	\N
l_nature_detaillee	batiment_groupe_bdtopo_equ	text[]	1	(ign) Catégorie détaillée de nature de l'équipement	maintenu	\N	open_data_lo	0	0	\N
l_toponyme	batiment_groupe_bdtopo_equ	text[]	1	(ign) Toponymie de l'équipement	maintenu	\N	open_data_lo	0	0	\N
code_departement_insee	batiment_groupe_bdtopo_zoac	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_nature	batiment_groupe_bdtopo_zoac	text[]	1	(ign) Catégorie de nature du bâtiment	maintenu	\N	open_data_lo	0	0	\N
l_nature_detaillee	batiment_groupe_bdtopo_zoac	text[]	1	(ign) Catégorie détaillée de nature de l'équipement	maintenu	\N	open_data_lo	0	0	\N
l_toponyme	batiment_groupe_bdtopo_zoac	text[]	1	(ign) Toponymie de l'équipement	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_bpe	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_bpe	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_type_equipement	batiment_groupe_bpe	TEXT[]	1	(bpe) Liste des équipements recensés par la base BPE	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dle_elec_2020	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié		open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_dle_elec_2020	varchar(2)	0	Code département INSEE	déprécié		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl_res	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	déprécié		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Nombre de points de livraisons professionel	déprécié		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Nombre total de points de livraisons	déprécié		open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	déprécié	kWh	open_data_lo	0	0	\N
nb_loc_appt	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type appartement (`nlocappt`)	maintenu	\N	ayant_droit_ffo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_elec_2020	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dle_elec_multimillesime	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	batiment_groupe_dle_reseaux_multimillesime	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_dle_elec_multimillesime	varchar(2)	0	Code département INSEE	maintenu		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
millesime	batiment_groupe_dle_elec_multimillesime	varchar(4)	0	Millésime des données	maintenu	\N	open_data_lo	1	1	\N
nb_pdl_res	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	maintenu		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons professionel	maintenu		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Nombre total de points de livraisons	maintenu		open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	maintenu	kWh	open_data_lo	0	0	\N
conso_pro	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	maintenu	kWh	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation totale [kWh/an]	maintenu	kWh/an	open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_elec_multimillesime	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dle_gaz_2020	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié		open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_dle_gaz_2020	varchar(2)	0	Code département INSEE	déprécié		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl_res	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	déprécié		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Nombre de points de livraisons professionel	déprécié		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Nombre total de points de livraisons	déprécié		open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	déprécié	kWh	open_data_lo	0	0	\N
conso_pro	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	déprécié	kWh	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation totale [kWh/an]	déprécié		open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_gaz_2020	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
code_departement_insee	batiment_groupe_dle_gaz_multimillesime	varchar(2)	0	Code département INSEE	maintenu		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
millesime	batiment_groupe_dle_gaz_multimillesime	varchar(4)	0	Millésime des données	maintenu	\N	open_data_lo	1	1	\N
nb_pdl_res	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	maintenu		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons professionel	maintenu		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Nombre total de points de livraisons	maintenu		open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	maintenu	kWh	open_data_lo	0	0	\N
conso_pro	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	maintenu	kWh	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation totale [kWh/an]	maintenu		open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_gaz_multimillesime	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dle_reseaux_2020	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié		open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_dle_reseaux_2020	varchar(2)	0	Code département INSEE	déprécié		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl_res	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	déprécié		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Nombre de points de livraisons professionel	déprécié		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Nombre total de points de livraisons	déprécié		open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	déprécié	kWh	open_data_lo	0	0	\N
conso_pro	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	déprécié	kWh	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation totale [kWh/an]	déprécié		open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_reseaux_2020	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	déprécié	\N	open_data_lo	0	0	\N
code_departement_insee	batiment_groupe_dle_reseaux_multimillesime	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
millesime	batiment_groupe_dle_reseaux_multimillesime	varchar(4)	0	Millésime des données	maintenu	\N	open_data_lo	1	1	\N
nb_pdl_res	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	maintenu		open_data_lo	0	0	\N
nb_pdl_pro	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Nombre de points de livraisons professionel	maintenu		open_data_lo	0	0	\N
nb_pdl_tot	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Nombre total de points de livraisons	maintenu	\N	open_data_lo	0	0	\N
conso_res	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation résidentielle [kWh/an]	maintenu	\N	open_data_lo	0	0	\N
conso_pro	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation professionnelle [kWh/an]. En cas d'adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.	maintenu	\N	open_data_lo	0	0	\N
conso_tot	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation totale [kWh/an]	maintenu	\N	open_data_lo	0	0	\N
conso_res_par_pdl	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation résidentielle par point de livraison [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_pro_par_pdl	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation professionnelle par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
conso_tot_par_pdl	batiment_groupe_dle_reseaux_multimillesime	numeric(17, 3)	1	Consommation totale par point de livraison  [kWh/pdl.an]	maintenu	\N	open_data_lo	0	0	\N
identifiant_reseau	batiment_groupe_dle_reseaux_multimillesime	TEXT[]	1	Identifiant du reseau de chaleur	maintenu	\N	open_data_lo	0	0	\N
type_reseau	batiment_groupe_dle_reseaux_multimillesime	TEXT[]	1	type du réseau de chaleur	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dvf	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		ayant_droit_dv3f	1	1	\N
code_departement_insee	batiment_groupe_dvf	varchar(2)	0	Code département INSEE	maintenu		ayant_droit_dv3f	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
valeur_fonciere_min	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière minimale parmi les locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_max	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière maximale parmi les locaux du bâtiment rapporté au m² habitable (SHAB)[€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_med	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) médiane des valeurs foncières  rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_mean	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière moyenne des locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_mean_t1	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière moyenne des locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_mean_t2	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière moyenne des locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_mean_t3	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière moyenne des locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_mean_t4sup	batiment_groupe_dvf	numeric(10, 2)	1	(dv3f) valeur foncière moyenne des locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
nb_mutation_annee	batiment_groupe_dvf	int4	1	nombre moyen de mutations par an dans le bâtiment	maintenu		ayant_droit_dv3f	0	0	\N
nb_loc	batiment_groupe_dvf	int4	1	(ffo) Nombre de locaux `nlocal`	maintenu		ayant_droit_dv3f	0	0	\N
nb_log	batiment_groupe_dvf	int4	1	nombre de logements du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_log_soc	batiment_groupe_dvf	int4	1	(ffo) Nombre de locaux de type logement sociaux, (utilisation des attributs loc.logh = 't' AND loc.hlmsem = ('5','6')). Attention, cette colonne n'intègre pas les logements sociaux de type ESH, OPH, et autres societés avec des bailleurs sociaux	maintenu		ayant_droit_dv3f	0	0	\N
batiment_groupe_id	batiment_groupe_dvf_logtype	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		ayant_droit_dv3f	1	1	\N
code_departement_insee	batiment_groupe_dvf_logtype	varchar(2)	0	Code département INSEE	maintenu		ayant_droit_dv3f	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
id_locmut	batiment_groupe_dvf_logtype	text	1	identifiant du couple (local, mutation) pour la transaction immobilière	maintenu		ayant_droit_dv3f	1	0	\N
local_id	batiment_groupe_dvf_logtype	text	1	identifiant du local dans les Fichiers Fonciers (Concaténation de ccodep, invar)	maintenu		ayant_droit_dv3f	1	0	\N
id_mutation	batiment_groupe_dvf_logtype	text	1	identifiant de la mutation dans les Fichiers Fonciers	maintenu		ayant_droit_dv3f	0	0	\N
usage_simple	batiment_groupe_dvf_logtype	TEXT	1	(dv3f:dteloc) usage du local (1:résidentiel individuel, 2:résidentiel collectif, 3:dependance, 4:commercial)	maintenu		ayant_droit_dv3f	0	0	\N
usage_simple_txt	batiment_groupe_dvf_logtype	text	1	(dv3f) usage du local explicite	maintenu		ayant_droit_dv3f	0	0	{"APPARTEMENT","DEPENDANCES","LOCAL COMMERCIAL OU INDUSTRIEL","MAISON"}
usage_detail	batiment_groupe_dvf_logtype	text	1	(dv3f:cconlc) type de local	maintenu	\N	ayant_droit_dv3f	0	0	{"AP","AT","AU","CA","CB","CD","CH","CM","DA","DC","DE","DM","LC","MA","ME","MP","PP","SM","U","UE","UG","UN","US"}
usage_detail_txt	batiment_groupe_dvf_logtype	text	1	(dv3f) type de local explicite	maintenu		ayant_droit_dv3f	0	0	{"DEPENDANCE BATIE ISOLEE (EX GARAGE)","DEPENDANCE DE MAISON","LOCAL PROFESSIONNEL","DEPENDANCE D APPARTEMENT","MAISON EXCEPTIONNELLE","LOCAL DIVERS","COMMERCE AVEC BOUTIQUE","ETABLISSEMENT INDUSTRIEL","TRANSFORMATEUR ELECTRIQUE HBTA","PORT DE PLAISANCE","SOL DE MAISON (CONSTRUCTION SUR SOL D’AUTRU","DEPENDANCE COMMERCIALE","TRANSFORMATEUR ELECTRIQUE","MAISON PARTAGEE PAR UNE LIMITE TERRITORIALE","LOCAL COMMUN","AUTOROUTE","APPARTEMENT","DEPENDANCE BATIE ISOLEE","ETABLISSEMENT INDUSTRIEL (EVALUE PAR METHOD","CHANTIER","MAISON","SHELTERS DES ANTENNES TELEPHONES","APPAREIL A GAZ","SOL DE MAISON","VOIES ET ELEMENTS CONSTRUITS SUR UNE AUTORO","COMMERCE SANS BOUTIQUE","DEPENDANCE LIEUX COMMUNS","ANTENNE TELEPHONE","LOCAL COMMUN (EX LOCAL A VELOS)","USINE NUCLEAIRE"}
code_naf	batiment_groupe_dvf_logtype	varchar(5)	1	code de l'activité principale selon la nomenclature NAF du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_pdl_pro	batiment_groupe_enepdl	numeric(17, 3)	1	Nombre de points de livraisons professionel	déprécié		ayant_droit_enedis	0	0	\N
code_naf_txt	batiment_groupe_dvf_logtype	text	1	activité principale selon la nomenclature NAF du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
bureau	batiment_groupe_dvf_logtype	bool	1	vaut True si le local du local concerné par la transaction immobilière est un bureau	maintenu		ayant_droit_dv3f	0	0	\N
habitation	batiment_groupe_dvf_logtype	bool	1	vaut True si du local concerné par la transaction immobilière est une habitation pour la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
logsoc	batiment_groupe_dvf_logtype	bool	1	vaut True si le local concerné par la transaction immobilière est un logement social pour la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
vacant	batiment_groupe_dvf_logtype	bool	1	(dv3f) vaut True si le local est vacant	maintenu		ayant_droit_dv3f	0	0	\N
s_bati	batiment_groupe_dvf_logtype	int4	1	(dv3f) surface du bati [m²]	maintenu		ayant_droit_dv3f	0	0	\N
s_hab	batiment_groupe_dvf_logtype	int4	1	surface habitable du local concerné par la transaction immobilière [m²]	maintenu		ayant_droit_dv3f	0	0	\N
s_dep	batiment_groupe_dvf_logtype	int4	1	(dv3f) surface occupée par les dépendances [m²]	maintenu		ayant_droit_dv3f	0	0	\N
s_pro	batiment_groupe_dvf_logtype	int4	1	(dv3f) surface d'usage professionel [m²]	maintenu		ayant_droit_dv3f	0	0	\N
nb_salle_a_mange	batiment_groupe_dvf_logtype	int4	1	nombre de salle à manger du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_chambre	batiment_groupe_dvf_logtype	int4	1	nombre de chambre du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_kitchenette	batiment_groupe_dvf_logtype	int4	1	nombre de cuisines dont la surface est inférieure ou égale à 8m² du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_cuisine	batiment_groupe_dvf_logtype	int4	1	nombre de cuisine dont la surface est supérieure ou égale à 9m² du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_salle_d_eau	batiment_groupe_dvf_logtype	int4	1	nombre de salle d'eau du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_annexe	batiment_groupe_dvf_logtype	int4	1	nombre de pièces annexes du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_piece_principale	batiment_groupe_dvf_logtype	int4	1	Nombre de pièces principales de la résidence individuelle ou collective ayant muté. Cet indicateur est disponible lorsqu'une unique résidence individuelle ou collective a mutée.	maintenu		ayant_droit_dv3f	0	0	\N
nb_dep	batiment_groupe_dvf_logtype	int4	1	nombre de dépendances du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_garage	batiment_groupe_dvf_logtype	int4	1	nombre de garage du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_agrement	batiment_groupe_dvf_logtype	int4	1	nombre de partie d'agréement du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_terrasse	batiment_groupe_dvf_logtype	int4	1	(ffo) Nombre de terrasses (incorporées + annexes non incorporées)	maintenu		ayant_droit_dv3f	0	0	\N
nb_piscine	batiment_groupe_dvf_logtype	int4	1	nombre de piscine du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
nb_cave_cellier_remise	batiment_groupe_dvf_logtype	int4	1	nombre de pièce de type cave, grenier, cellier, remise du local concerné par la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_par_m2_bati	batiment_groupe_dvf_logtype	int8	1	(dv3f) valeur foncière du local par m² de bati [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_par_m2_terrain	batiment_groupe_dvf_logtype	int8	1	(dv3f) valeur foncière du local par m² de terrain [€/m²]	maintenu		ayant_droit_dv3f	0	0	\N
valeur_fonciere_brute	batiment_groupe_dvf_logtype	int8	1	(dv3f) valeur foncière totale de la mutation [€]	maintenu		ayant_droit_dv3f	0	0	\N
s_hab_mutation	batiment_groupe_dvf_logtype	int8	1	(dv3f) surface habitable totale comprise dans la mutation [m²]	maintenu		ayant_droit_dv3f	0	0	\N
s_bati_mutation	batiment_groupe_dvf_logtype	int8	1	(dv3f) surface de bati totale comprise dans la mutation [m²]	maintenu		ayant_droit_dv3f	0	0	\N
s_terrain_mutation	batiment_groupe_dvf_logtype	int8	1	(dv3f) surface de terrain totale comprise dans la mutation [m²]	maintenu		ayant_droit_dv3f	0	0	\N
date_mutation	batiment_groupe_dvf_logtype	date	1	date de la mutation pour la transaction immobilière	maintenu		ayant_droit_dv3f	0	0	\N
batiment_groupe_id	batiment_groupe_dvf_open_representatif	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
id_opendata	batiment_groupe_dvf_open_representatif	varchar(60)	0	Identifiant open data de la mutation.	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	batiment_groupe_dvf_open_representatif	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
valeur_fonciere	batiment_groupe_dvf_open_representatif	numeric	1	Valeur foncière en euros de la mutation représentative. [€]	maintenu	€	open_data_lo	0	0	\N
date_mutation	batiment_groupe_dvf_open_representatif	date	1	date de la mutation pour la transaction immobilière	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_mutee_mutation	batiment_groupe_dvf_open_representatif	int4	1	Nombre de locaux ayant mutés lors de la mutation représentative.	maintenu	\N	open_data_lo	0	0	\N
nb_maison_mutee_mutation	batiment_groupe_dvf_open_representatif	int4	1	Nombre de maisons ayant mutées lors de la mutation représentative.	maintenu	\N	open_data_lo	0	0	\N
nb_appartement_mutee_mutation	batiment_groupe_dvf_open_representatif	int4	1	Nombre d'appartements ayant mutés lors de la mutation représentative.	maintenu	\N	open_data_lo	0	0	\N
nb_dependance_mutee_mutation	batiment_groupe_dvf_open_representatif	int4	1	Nombre de dépendances ayant mutées lors de la mutation représentative.	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_tertiaire_mutee_mutation	batiment_groupe_dvf_open_representatif	int4	1	Nombre de locaux tertiaires ayant mutés lors de la mutation représentative.	maintenu	\N	open_data_lo	0	0	\N
surface_bati_mutee_residencielle_individuelle	batiment_groupe_dvf_open_representatif	numeric	1	Surface de bâti associée à des résidences individuelles ayant mutées lors de la mutation représentative [m²].	maintenu	\N	open_data_lo	0	0	\N
surface_bati_mutee_residencielle_collective	batiment_groupe_dvf_open_representatif	numeric	1	Surface de bâti associée à des résidences collectives ayant mutées lors de la mutation représentative [m²].	maintenu	\N	open_data_lo	0	0	\N
surface_bati_mutee_dependance	batiment_groupe_dvf_open_representatif	numeric	1	Surface de bâti associée à des dépendances ayant mutées lors de la mutation représentative [m²].	maintenu	\N	open_data_lo	0	0	\N
surface_bati_mutee_tertiaire	batiment_groupe_dvf_open_representatif	numeric	1	Surface de bâti associée à du tertiaire ayant mutées lors de la mutation représentative [m²].	maintenu	\N	open_data_lo	0	0	\N
surface_terrain_mutee	batiment_groupe_dvf_open_representatif	numeric	1	Surface de terrain ayant muté lors de la mutation représentative [m²].	maintenu	m²	open_data_lo	0	0	\N
nb_niveau	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de niveau du bâtiment (ex: RDC = 1, R+1 = 2, etc..)	maintenu	\N	open_data_lo	0	0	\N
nb_piece_principale	batiment_groupe_dvf_open_representatif	int4	1	Nombre de pièces principales de la résidence individuelle ou collective ayant muté. Cet indicateur est disponible lorsqu'une unique résidence individuelle ou collective a mutée.	maintenu	\N	open_data_lo	0	0	\N
prix_m2_local	batiment_groupe_dvf_open_representatif	numeric	1	Prix au m² de bâti en euros lors de la mutation. Cet indicateur n'est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]	maintenu	€	open_data_lo	0	0	\N
prix_m2_terrain	batiment_groupe_dvf_open_representatif	numeric	1	Prix au m² du terrain en euros lors de la mutation. Cet indicateur n'est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]	maintenu	€	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dvf_open_statistique	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_dvf_open_statistique	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_mutation	batiment_groupe_dvf_open_statistique	int4	1	Nombre de mutations qui ont eu lieu sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
valeur_fonciere_median	batiment_groupe_dvf_open_statistique	numeric	1	Valeur foncière médiane en euros calculée sur l'ensemble des mutations qui ont eu lieu sur le batiment_groupe.	maintenu	\N	open_data_lo	0	0	\N
valeur_fonciere_moyenne	batiment_groupe_dvf_open_statistique	numeric	1	Valeur foncière moyenne en euros calculée sur l'ensemble des mutations qui ont eu lieu sur le batiment_groupe.	maintenu	\N	open_data_lo	0	0	\N
valeur_fonciere_max	batiment_groupe_dvf_open_statistique	numeric	1	(dv3f) valeur foncière maximale parmi les locaux du bâtiment rapporté au m² habitable (SHAB)[€/m²]	maintenu	\N	open_data_lo	0	0	\N
valeur_fonciere_min	batiment_groupe_dvf_open_statistique	numeric	1	(dv3f) valeur foncière minimale parmi les locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]	maintenu	\N	open_data_lo	0	0	\N
prix_m2_local_median	batiment_groupe_dvf_open_statistique	numeric	1	Prix médian au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_local_moyen	batiment_groupe_dvf_open_statistique	numeric	1	Prix moyen au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_energie	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	ayant_droit_ffo	1	1	\N
prix_m2_local_max	batiment_groupe_dvf_open_statistique	numeric	1	Prix maximale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_local_min	batiment_groupe_dvf_open_statistique	numeric	1	Prix minimale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_terrain_median	batiment_groupe_dvf_open_statistique	numeric	1	Prix médian au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_terrain_moyen	batiment_groupe_dvf_open_statistique	numeric	1	Prix moyen au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_terrain_max	batiment_groupe_dvf_open_statistique	numeric	1	Prix maximale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
prix_m2_terrain_min	batiment_groupe_dvf_open_statistique	numeric	1	Prix minimale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_mutee	batiment_groupe_dvf_open_statistique	int4	1	Nombre de locaux qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
nb_maisons_mutee	batiment_groupe_dvf_open_statistique	int4	1	Nombre de maisons qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
nb_appartement_mutee	batiment_groupe_dvf_open_statistique	int4	1	Nombre d'appartements qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
nb_dependance_mutee	batiment_groupe_dvf_open_statistique	int4	1	Nombre de dépendances qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_tertiaire_mutee	batiment_groupe_dvf_open_statistique	int4	1	Nombre de locaux tertiaires qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_enepdl	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	ayant_droit_enedis	1	1	\N
exposition_bruit	batiment_groupe_exposition_bruit_logement_social	bool	1	Si le bâtiment est considéré comme sensible et exposé au moins à une source d’origine routière ou ferroviaire ou aéroportuaire (SRC_Rte, SRC_Fer, SRC_Aero ) alors ce champ prend la valeur True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_loc_com_ter	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux d'activité tertiaire (commercial, bureau, etc.)	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_enepdl	varchar(2)	0	Code département INSEE	déprécié		ayant_droit_enedis	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl_tot	batiment_groupe_enepdl	numeric(17, 3)	1	Nombre total de points de livraisons	déprécié		ayant_droit_enedis	0	0	\N
code_departement_insee	batiment_groupe_energie	varchar(2)	0	Code département INSEE	déprécié	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
dle_elec_conso_res_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation electrique résidentielle ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_elec_conso_pro_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation electrique professionnelle ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_elec_conso_tot_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation electrique totale ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_gaz_conso_res_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation gaz résidentielle ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_gaz_conso_pro_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation gaz professionnelle ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_gaz_conso_tot_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation gaz totale ramené au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_reseau_conso_res_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation RC résidentielle ramenée au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_reseau_conso_pro_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation RC professionnelle ramenée au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
dle_reseau_conso_tot_par_m2	batiment_groupe_energie	numeric(17, 3)	1	consommation RC totale ramenée au m² (en surface résidentielle) [kWh/m².an]	déprécié	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	batiment_groupe_enethermo	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	ayant_droit_enedis	1	1	\N
code_departement_insee	batiment_groupe_enethermo	varchar(2)	0	Code département INSEE	déprécié		ayant_droit_enedis	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl_res	batiment_groupe_enethermo	numeric(17, 3)	1	Nombre de points de livraisons résidentiel	déprécié		ayant_droit_enedis	0	0	\N
conso_ener_res	batiment_groupe_enethermo	numeric(17, 3)	1	(enedis_thermo) Consommation électrique résidentielle [kWh/an]	déprécié		ayant_droit_enedis	0	0	\N
conso_thermo_res	batiment_groupe_enethermo	numeric(17, 3)	1	(enedis_thermo) Consommation électrique moyenne, part thermosensibilité [kWh/an]	déprécié		ayant_droit_enedis	0	0	\N
gradient_mean_res	batiment_groupe_enethermo	numeric(17, 3)	1	(enedis_thermo) Gradient moyen résidentiel	déprécié		ayant_droit_enedis	0	0	\N
conso_ener_res_par_pdl	batiment_groupe_enethermo	numeric(17, 3)	1	(enedis_thermo) Consommation électrique moyenne par PDL résidentiel. [kWh/pdl.an]	déprécié		ayant_droit_enedis	0	0	\N
conso_thermo_res_par_pdl	batiment_groupe_enethermo	numeric(17, 3)	1	(enedis_thermo) Consommation électrique moyenne, part thermosensibilité, par PDL résidentiel [kWh/pdl.an]	déprécié		ayant_droit_enedis	0	0	\N
nb_lavabo	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de lavabo	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	batiment_groupe_exposition_bruit_logement_social	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bruit_logement_social	1	1	\N
code_departement_insee	batiment_groupe_exposition_bruit_logement_social	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bruit_logement_social	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_denomination_bailleur_social	batiment_groupe_exposition_bruit_logement_social	text[]	1	Cette information est renseignée pour les bailleurs sociaux en partie à partir des Fichiers fonciers (2019)	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
exposition_bruit_routier_et_ou_ferroviaire	batiment_groupe_exposition_bruit_logement_social	bool	1	Si le bâtiment est considéré comme sensible et exposé au moins à une source d’origine routière ou ferroviaire (SRC_Rte, SRC_Fer) alors ce champ prend la valeur True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
zone_prioritaire_bruit	batiment_groupe_exposition_bruit_logement_social	bool	1	Ce champ prend la valeur « vrai », si au moins un bâtiment du bâtiment groupe est sensible de se trouver dans au moins une des situations suivantes (1) situe dans une carte C de la directive européenne Bruit (2) le bâtiment se situe dans un Plan de Gêne Sonore des aéroports (PGS)	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
exposition_bruit_routier	batiment_groupe_exposition_bruit_logement_social	bool	1	Origine routière de la source de bruit	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
exposition_bruit_ferroviaire	batiment_groupe_exposition_bruit_logement_social	bool	1	Origine ferroviaire de la source de bruit	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
exposition_bruit_aeroport	batiment_groupe_exposition_bruit_logement_social	bool	1	Origine aéroportuaire de la source de bruit	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social	batiment_groupe_exposition_bruit_logement_social	float8	1	Nombre de logements sociaux retenu pour le calcul de l’exposition (il correspond à la répartition homogène des logements sociaux associés à la parcelle sur l’ensemble des bâtiments contenus, en fonction de leur volumétrie)	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social_expose_bruit	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand exposition_bruit = True et pour l'exposition au bruit routière et/ou ferroviaire et/ou aéroport	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social_expose_bruit_rte_et_ou_fer	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand exposition_bruit = True et pour l'exposition au bruit routière et/ou ferroviaire	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social_zone_prioritaire_bruit	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand priorité = True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_loc_burx	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux présentant au moins un bureau déclaré	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_logement_social_expose_routier	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand src_rte = True and exbruit = True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social_expose_ferroviaire	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand src_fer = True and exbruit = True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
nb_logement_social_expose_aeroport	batiment_groupe_exposition_bruit_logement_social	float8	1	somme du nombre de logements sociaux retenues quand src_aero = True and exbruit = True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	\N
type_exposition_bruit	batiment_groupe_exposition_bruit_logement_social	text	1	type d'exposition au bruit - src_x = True and exbruit = True	maintenu	\N	ayant_droit_bruit_logement_social	0	0	{"ferroviaire & aeroport","routier & ferroviaire","routier & ferroviaire & aeroport","routier","ferroviaire","routier & aeroport","aeroport","non-defini"}
type_exposition_bruit_routier_et_ou_ferroviaire	batiment_groupe_exposition_bruit_logement_social	text	1	type d'exposition au bruit - simplification pour montrer en préférence exposition routière et ferroviaire	maintenu	\N	ayant_droit_bruit_logement_social	0	0	{"routier","ferroviaire","routier & ferroviaire","aeroport","non-defini"}
type_exposition_bruit_simplifie	batiment_groupe_exposition_bruit_logement_social	text	1	type d'exposition au bruit - src_x = True and exbruit = True (priorité (1)route, (2)ferroviaire, (3)aeroport)	maintenu	\N	ayant_droit_bruit_logement_social	0	0	{"routier","ferroviaire","aeroport","non-defini"}
batiment_groupe_id	batiment_groupe_ffo_bat	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_ffo_bat	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
emprise_sol_deduite_sans_park_incorp	batiment_groupe_ffo_bat	int4	1	Emprise au sol déduite du bâtiment (les dépendances incorporées et non incorporées sont excluses de cette grandeur), utilisée dans la méthodologie d'appariement des entrées `bâtiments` FF-BDTopo [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_ch_central	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'une installation centralisée de chauffage	maintenu	\N	ayant_droit_ffo	0	0	\N
raccord_eau	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un raccordement à l'eau	maintenu	\N	ayant_droit_ffo	0	0	\N
raccord_egout	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un raccordement à un tout-à-l'égout	maintenu	\N	ayant_droit_ffo	0	0	\N
raccord_elec	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un raccordement à l'électricité	maintenu	\N	ayant_droit_ffo	0	0	\N
l_loc_sec_txt	batiment_groupe_ffo_bat	text[]	1	liste des usages des locaux secondaires (traitement CSTB de la variable cconlc)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_pev_etat_entretien	batiment_groupe_ffo_bat	text[]	1	(ffo) Etat d'entretien des parties d'évaluation	maintenu	\N	ayant_droit_ffo	0	0	\N
mat_mur	batiment_groupe_ffo_bat	TEXT	1	(ffo) indicateur Matériau principal des murs extérieurs	maintenu	\N	ayant_droit_ffo	0	0	\N
mat_toit	batiment_groupe_ffo_bat	TEXT	1	(ffo) indicateur Matériau principal des toitures	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse	batiment_groupe_ffo_bat	int4	1	Nombre d'adresses	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_baignoire	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de baignoire	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_douche	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de douche	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_loue_autre	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de logements loués à titre gratuit ou en bail rural	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_occ_prop	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de logements d'habitation occupés par le propriétaire	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_pevph	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de parties principales d'habitation dans les PEV	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_pev_pro	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de parties d'évaluation de type `professionnel`	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_piece_annexe	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de pièces annexes	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_piece_tx	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de pièces principales	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_piscine	batiment_groupe_ffo_bat	int4	1	nombre de piscine du local concerné par la transaction immobilière	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_sdb	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de salles d’eau	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_wc	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de WC	maintenu	\N	ayant_droit_ffo	0	0	\N
s_dep_non_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface totale des dépendances (non intégrées au local) sur la parcelle (Utilisation de l'attribut dsudep, nul si npevd nul) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_appt	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type "appartement" [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_com	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type `commercial ou industriel` [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type `dépendance` incorporés à des locaux [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_dep_non_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type `dépendance` incorporés à la pev [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_hors_sol_avec_dep	batiment_groupe_ffo_bat	int4	1	Somme des surfaces de locaux, dépendances non inporporées incluses, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_hors_sol_non_dep_inc	batiment_groupe_ffo_bat	int4	1	Somme des surfaces de locaux, dépendances inporporées et non incorporées non incluses, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_hors_sol_non_dep	batiment_groupe_ffo_bat	int4	1	Somme des surfaces de locaux, dépendances non inporporées, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_mi	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type "maison" [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_pro_princetdepcouv	batiment_groupe_ffo_bat	int4	1	(ffo) Surface des parties principales et secondaires couvertes du local professionnel [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log_hlm	batiment_groupe_ffo_bat	int4	1	(ffo) Surface de locaux de type social [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log_sem	batiment_groupe_ffo_bat	int4	1	(ffo) Surface de locaux de type logement SEM [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_grenier_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de greniers, comptées comme dépendances incorporées	maintenu	\N	ayant_droit_ffo	0	0	\N
s_max_hors_sol_avec_dep	batiment_groupe_ffo_bat	int4	1	Maximum des surfaces de locaux, dépendances non incorporées incluses, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_max_hors_sol_non_dep_inc	batiment_groupe_ffo_bat	int4	1	Maximum des surfaces de locaux, dépendances non incorporées non incluses, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_max_hors_sol_non_dep	batiment_groupe_ffo_bat	int4	1	Maximum des surfaces de locaux, dépendances incorporées et non incorporées non incluses, par niveau en surface [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_pev_dep	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de dépendance du bâtiment, calculé à partir des surfaces `dsudep` définies à l'échelle de la table `pb60_pevdependance` [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_pev_pro	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de parties principales des PEV professionnelles du bâtiment, calculé à partir des surfaces `dsup1` définies à l'échelle de la table `pb50_pevprofessionnelle` [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
annee_construction	batiment_groupe_ffo_bat	int4	1	Année de construction du bâtiment	maintenu	\N	open_data_lo	0	0	\N
emprise_sol_deduite	batiment_groupe_ffo_bat	int4	1	Emprise au sol déduite (brute), utilisée dans la méthodologie d'appariement des entrées `bâtiments` FF-BDTopo [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_ascenseur	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'ascenseur	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_bureau	batiment_groupe_ffo_bat	bool	1	(ffo) Présence de bureau	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_escalier	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un escalier	maintenu	\N	ayant_droit_ffo	0	0	\N
raccord_gaz	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un raccordement au gaz	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_sous_sol	batiment_groupe_ffo_bat	bool	1	(ffo) Tous les locaux sont localisés en sous-sol	maintenu	\N	ayant_droit_ffo	0	0	\N
presence_videordure	batiment_groupe_ffo_bat	bool	1	(ffo) Présence d'un système de vide-ordure	maintenu	\N	ayant_droit_ffo	0	0	\N
usage_principal	batiment_groupe_ffo_bat	text	1	Usage principal du bâtiment déterminé à partir des nombres de locaux par catégorie (DEPRECATED)	maintenu	\N	ayant_droit_ffo	0	0	{"batiment collectif d'habitation","dependance","maison individuelle","secondaire","tertiaire"}
usage_niveau_1	batiment_groupe_ffo_bat	int4	1	indicateur d'usage simplifié du batiment	maintenu	\N	ayant_droit_ffo	0	0	\N
usage_niveau_1_txt	batiment_groupe_ffo_bat	text	1	indicateurs d'usage simplifié du bâtiment (verbose)	maintenu	\N	open_data_lo	0	0	{"Résidentiel collectif","Résidentiel individuel","Dépendance","Tertiaire & Autres","Secondaire"}
usage_niveau_2	batiment_groupe_ffo_bat	int4	1	indicateur d'usage un peu plus précis du batiment	maintenu	\N	ayant_droit_ffo	0	0	\N
usage_niveau_2_txt	batiment_groupe_ffo_bat	text	1	indicateur d'usage un peu plus précis du bâtiment (verbose)	maintenu	\N	ayant_droit_ffo	0	0	{"Résidentiel collectif autre","Immeuble collectif","Centre de santé","Cave / Grenier / Remise","Hôtel","Bureau","Loisirs détente","Enseignement","Loisirs & Sport","Maison individuelle","Tertiaire autre & Divers","Industrie","Energie","Garage / Parking / Box","Dépendance diverse","Maisons groupées","Commerce","Résidentiel collectif"}
nb_loc_com	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux d'activité commerciale ou industrielle (`nloccom`)	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	batiment_groupe_qpv	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
usage_niveau_3_txt	batiment_groupe_ffo_bat	text	1	indicateur d'usage précis du bâtiment (verbose)	maintenu	\N	ayant_droit_ffo	0	0	{"Station service","Centre de loisir","Hôtel club","Artisant","Hôtel équivalent 2-3 étoiles","Bureau avec aménagement spécifique","Marché","Chambre de domestique","Magasin de centre commercial avec surface < 400m²","Pièce indépendante","Etablissement hospitalier","Chenil ou vivier","Centre de soins, crèche, garderie","Espace culturel (musée, théatre)","Espace bien être","Résidentiel collectif autre","Garage/parking","Transformateur","Garage","Local de manutention","Bureau d’agencement ancien","Elément de pur agrément","Remise","Magasin sur rue avec surface < 400m²","Maison exceptionnelle","Dépendance de local commun","Local divers","Dépendance diverse","Antenne téléphone","Cave","Grenier","Stationnement couvert","Carrière","Maison de retraite","Magasin sans accès à la rue avec surface < 400m²","Foyer d’hébergement","Immeuble collectif","Piscine","Dépot à ciel ouvert","Tertiaire autre & Divers","Espace loisir","Installation de stockage","Espace sportif","Maisons groupées","Magasin très grande surface (> 2500m²)","Box","Etablissement d’enseignement à but non lucratif","Cellier","Appareil à gaz","Autoroute","Etablissement industriel","Maison individuelle","Dépot couvert","Centre de rééducation","Stationnement ciel ouvert","Bureau d’agencement récent","Parking","Hôtel équivalent 1 étoile","Magasin grande surface (entre 400m² et 2499m²)","Etablissement d’enseignement à but lucratif","Hôtel équivalent 4 étoiles ou plus","Etablissement industriel autre que carrière","Bûcher","Jardin d’hiver","Sol de maison","Usine nucléaire","Bureau d'agencement ancien","Camping équivalent 3 étoiles ou plus","Camping équivalent 1 ou 2 étoiles","Serre","Bureau d'agencement récent","Buanderie","Toiture-terrasse","Grenier/cave","Résidentiel collectif","Terrasse"}
l_usage_niveau_1	batiment_groupe_ffo_bat	int4[]	1	indicateur d'usage simplifié du batiment	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_niveau_1_txt	batiment_groupe_ffo_bat	text	1	indicateurs d'usage simplifié du bâtiment (verbose)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_niveau_2	batiment_groupe_ffo_bat	int4[]	1	indicateur d'usage un peu plus précis du batiment	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_niveau_2_txt	batiment_groupe_ffo_bat	text	1	indicateur d'usage un peu plus précis du bâtiment (verbose)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_niveau_3	batiment_groupe_ffo_bat	int4[]	1	indicateur d'usage précis du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_niveau_3_txt	batiment_groupe_ffo_bat	text	1	indicateur d'usage précis du bâtiment (verbose)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_usage_mixite	batiment_groupe_ffo_bat	text[]	1	mixité des usages du batiment	maintenu	\N	ayant_droit_ffo	0	0	\N
usage_mixite_global	batiment_groupe_ffo_bat	text	1	mixité des usages du bâtiment simplifiée	maintenu	\N	ayant_droit_ffo	0	0	{"RESIDENTIEL","NON_RESIDENTIEL","MIXTE","DEPENDANCE"}
l_loc_dep_incorp	batiment_groupe_ffo_bat	text[]	1	liste des dépendances intégrées au bâtiment (traitement cstb des variables cconad : 1,2,3,4)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_loc_dep_non_incorp	batiment_groupe_ffo_bat	text[]	1	liste des dépendances non intégrées au bâtiment (traitement cstb de la variable cconad)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_loc_sec	batiment_groupe_ffo_bat	text[]	1	liste des usages des locaux secondaires (traitement cstb de la variable cconlc)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_loc_ter	batiment_groupe_ffo_bat	text[]	1	liste des usages des locaux tertiaire (traitement cstb des variables cconlc et typeact)	maintenu	\N	ayant_droit_ffo	0	0	\N
l_code_naf	batiment_groupe_ffo_bat	text[]	1	(ffo) Liste des codes NAF	maintenu	\N	ayant_droit_ffo	0	0	\N
l_code_naf_txt	batiment_groupe_ffo_bat	text[]	1	(ffo) Liste des libellés des codes NAF	maintenu	\N	ayant_droit_ffo	0	0	\N
mat_mur_txt	batiment_groupe_ffo_bat	text	1	(ffo) Matériaux principal des murs extérieurs	maintenu	\N	open_data_lo	0	0	{"AGGLOMERE - AUTRES","MEULIERE - PIERRE","BETON - AUTRES","AUTRES","AGGLOMERE - BRIQUES","BRIQUES","BETON - BRIQUES","AGGLOMERE - PIERRE","BETON - MEULIERE","AGGLOMERE - BETON","BETON - PIERRE","INDETERMINE","BRIQUES - MEULIERE","BOIS - BRIQUES","BETON - BOIS","BOIS - PIERRE","BOIS","MEULIERE - AUTRES","AGGLOMERE","PIERRE","BRIQUES - PIERRE","AGGLOMERE - MEULIERE","AGGLOMERE - BOIS","BRIQUES - AUTRES","MEULIERE","PIERRE - AUTRES","BETON","BOIS - MEULIERE","BOIS - AUTRES"}
mat_toit_txt	batiment_groupe_ffo_bat	text	1	(ffo) Matériau principal des toitures	maintenu	\N	open_data_lo	0	0	{"ZINC ALUMINIUM","TUILES - AUTRES","BETON - AUTRES","TUILES","AUTRES","ARDOISES","TUILES - ZINC ALUMINIUM","ARDOISES - AUTRES","BETON - TUILES","BETON - ZINC ALUMINIUM","ARDOISES - BETON","INDETERMINE","ARDOISES - TUILES","ARDOISES - ZINC ALUMINIUM","BETON","ZINC ALUMINIUM - AUTRES"}
nb_cave_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de cave, comptées comme dépendances incorporées	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_garage_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de garage, comptées comme dépendances incorporées	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_garpark	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de pièces annexes de type garages / parking	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc_com_rdc	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux d'activité secondaire ou tertiaire situés au rez de chaussée (Utilisation de `nloccomrdc`, l'attribut dteloc=4 et dniv=00)	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc_dep	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type dépendances	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de dépendances incorporées dans un local de type autre (`nlocdep`)	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc_dep_non_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de dépendances (non intégrées au local) sur la parcelle (Source article 60 (pb60))	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc_maison	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type maison (`nlocmaison`)	maintenu	maisons	ayant_droit_ffo	0	0	\N
nb_log	batiment_groupe_ffo_bat	int4	1	Nombre de logements dans le groupe de bâtiments	maintenu	\N	open_data_lo	0	0	\N
nb_log_residence_principale	batiment_groupe_ffo_bat	int4	1	(ffo:logh/rppo_rs) Nombre de logements d’habitation (Utilisation du champ logh) estimés être de la résidence principale	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_residence_secondaire	batiment_groupe_ffo_bat	int4	1	(ffo:logh/rppo_rs) Nombre de logements d’habitation (Utilisation du champ logh) estimés être de la résidence secondaire	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_hlm	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type logement HLM (utilisation des attributs loc.logh = 't' AND loc.hlmsem = '5')	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_sem	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type logement SEM (utilisation des attributs loc.logh = 't' AND loc.hlmsem = '6')	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_soc	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de locaux de type logement sociaux, (utilisation des attributs loc.logh = 't' AND loc.hlmsem = ('5','6')). Attention, cette colonne n'intègre pas les logements sociaux de type ESH, OPH, et autres societés avec des bailleurs sociaux	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log_vac	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de logements d'habitation vacants (Somme du champ nloghvac)	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_piece_principale	batiment_groupe_ffo_bat	int4	1	Nombre de pièces principales de la résidence individuelle ou collective ayant muté. Cet indicateur est disponible lorsqu'une unique résidence individuelle ou collective a mutée.	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_terrasse	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de terrasses (incorporées + annexes non incorporées)	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_terrasse_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Nombre de dépendance incorporée de type "terrasse"	maintenu	\N	ayant_droit_ffo	0	0	\N
s_cave_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface réelle de l'élément incorporé (caves) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface totale des éléments incorporés en m² (dsueic1+dsueic2+dsueic3+dsueic4) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_garage_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface réelle de l'élément incorporé (garages) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_grenier_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface réelle de l'élément incorporé (greniers) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_com_rdc	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type `commercial ou industriel` au rdc [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_com_sec	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type "industriel" [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_com_ter	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type "commercial" [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_dep	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces de locaux de type `dépendance` [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_loc_pro_tot	batiment_groupe_ffo_bat	int4	1	(ffo) Somme des surfaces des parties principales, secondaires couvertes ou non, stationnements couverts ou non (`sprobati`) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_loc_tot	batiment_groupe_ffo_bat	int4	1	(ffo) Somme de stoth, stotdsueic, stotd, sprincp, ssecp, sparkp, sparkncp (`slocal`) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_log	batiment_groupe_ffo_bat	int4	1	(ffo) Surface totale des pièces d'habitation (en m²) (Utilisation de l'attribut dsupdc, nul si npevph nul) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_log_residence_principale	batiment_groupe_ffo_bat	int4	1	(ffo) Surface totale des pièces d'habitation (Utilisation de l'attribut dsupdc, nul si npevph nul) des logements considérées comme des résidences principales [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_log_residence_secondaire	batiment_groupe_ffo_bat	int4	1	(ffo) Surface totale des pièces d'habitation (Utilisation de l'attribut dsupdc, nul si npevph nul) des logements considérées comme des résidences secondaires [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_log_soc	batiment_groupe_ffo_bat	int4	1	(ffo) Surface de locaux de type logement sociaux, version étendue (loc.logh = `t` AND loc.catpro2 = `F1`) [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
s_terrasse_dep_incorp	batiment_groupe_ffo_bat	int4	1	(ffo) Surface réelle de l'élément incorporé (terrasses) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	batiment_groupe_geospx	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_geospx	varchar(2)	0	Code département INSEE	déprécié	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
fiabilite_emprise_sol	batiment_groupe_geospx	varchar(7)	1	Fiabilité de l'emprise au sol du bâtiment : "vrai" si les données des Fichiers Fonciers (surfaces fiscales retravaillée par niveau) et BDTOpo (emprise au sol) sont cohérentes ; "faux" sinon ; "NULL" si l'un des deux informations à comparer n'est pas disponible	déprécié	\N	open_data_lo	0	0	\N
fiabilite_hauteur	batiment_groupe_geospx	varchar(7)	1	Fiabilité de la hauteur du bâtiment : "vrai" si les données des Fichiers Fonciers (nombre de niveaux) et BDTOpo (hauteur) sont cohérentes ; "faux" sinon ; "NULL" si l'un des deux informations à comparer n'est pas disponible	déprécié	\N	open_data_lo	0	0	\N
fiabilite_adresse	batiment_groupe_geospx	BOOL	1	Fiabilité des adresses du bâtiment : "vrai" si les Fichiers Fonciers et BDTOpo partagent au moins une même adresse BAN	déprécié	\N	open_data_lo	0	0	\N
croisement_geospx_reussi	batiment_groupe_geospx	bool	1	Fiabilité sur le croisement de données bâtimentaires : "vrai" si l'association Fichiers Fonciers et BDTopo est considérée comme réussi ; "faux" sinon ; "NULL" si l'une des composantes n'existe pas sur l'unité foncière (i.e. parcelle unifiée) associée.	déprécié	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_hthd	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_hthd	varchar(2)	0	Code département INSEE	maintenu		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_pdl	batiment_groupe_hthd	numeric(17, 3)	1	(hthd) Nombre total de PDL Arcep	maintenu	\N	open_data_lo	0	0	\N
l_type_pdl	batiment_groupe_hthd	text[]	1	(hthd) Liste de type de bâtiment desservis par les PDL	maintenu	\N	open_data_lo	0	0	\N
l_nom_pdl	batiment_groupe_hthd	text[]	1	(hthd) Liste des noms des points de livraisons centraux	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_merimee	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_merimee	varchar(2)	0	Code département INSEE	déprécié	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
distance_batiment_historique_plus_proche	batiment_groupe_merimee	int2	1	(mer) Distance au bâtiment historique le plus proche (si moins de 500m) [m]	déprécié	\N	open_data_lo	0	0	\N
nom_batiment_historique_plus_proche	batiment_groupe_merimee	text	1	(mer:tico) nom du bâtiment historique le plus proche	déprécié	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_pie	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_pie	1	1	\N
nb_gestionaire_bailleur	batiment_groupe_proprietaire	int4	1	(ffo) nombre de gestionnaires de types bailleur sociaux dans le bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_gestionnaire_pm	batiment_groupe_proprietaire	int4	1	(ffo) nombre de gestionnaires de types personne morale dans le bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_pie	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_pie	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
l_usage_principal	batiment_groupe_pie	TEXT[]	1	Liste des usages principaux définis dans la base du PIE	maintenu	\N	ayant_droit_pie	0	0	\N
l_usage_principal_detaille	batiment_groupe_pie	TEXT[]	1	Liste des usages principaux détaillés définis dans la base du PIE	maintenu	\N	ayant_droit_pie	0	0	\N
erp	batiment_groupe_pie	bool	1	Le bâtiment est-il considéré comme pouvant recevoir du public ?	maintenu	\N	ayant_droit_pie	0	0	\N
l_designation_site	batiment_groupe_pie	TEXT[]	1	Liste des désignation du site	maintenu	\N	ayant_droit_pie	0	0	\N
l_designation_batiment_terrain	batiment_groupe_pie	TEXT[]	1	Liste des désignation des bâtiments	maintenu	\N	ayant_droit_pie	0	0	\N
l_occupant	batiment_groupe_pie	TEXT[]	1	Liste des occupants	maintenu	\N	ayant_droit_pie	0	0	\N
l_ministere	batiment_groupe_pie	TEXT[]	1	Listes des ministères affiliés	maintenu	\N	ayant_droit_pie	0	0	\N
l_libelle_occupant	batiment_groupe_pie	TEXT[]	1	Liste des libéllés des occupants	maintenu	\N	ayant_droit_pie	0	0	\N
l_proprietaire	batiment_groupe_pie	TEXT[]	1	Liste des propriétaires (abbrégés)	maintenu	\N	ayant_droit_pie	0	0	\N
l_libelle_proprietaire	batiment_groupe_pie	TEXT[]	1	Liste des propriétaires (explicite)	maintenu	\N	ayant_droit_pie	0	0	\N
surface	batiment_groupe_pie	NUMERIC	1	Estimation de la surface du bâtiment [m²]	maintenu	\N	ayant_droit_pie	0	0	\N
annee_construction	batiment_groupe_pie	int4	1	Année de construction du bâtiment	maintenu	\N	ayant_droit_pie	0	0	\N
etat_de_sante_minimal	batiment_groupe_pie	VARCHAR(17)	1	Etat de santé du bâtiment	maintenu	\N	ayant_droit_pie	0	0	\N
tri_dechets	batiment_groupe_pie	bool	1	Le bâtiment fait-il le tri des déchets	maintenu	\N	ayant_droit_pie	0	0	\N
batiment_groupe_id	batiment_groupe_proprietaire	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	batiment_groupe_proprietaire	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
personne_id_proprietaire_principal	batiment_groupe_proprietaire	text	1	(ffo:idpersonne) identifiant du proprietaire possédant la plus grande surface du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
denomination_proprietaire_principal	batiment_groupe_proprietaire	text	1	(ffo:ddenom) identifiant du proprietaire possédant la plus grande surface du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
groupe_proprietaire_principal	batiment_groupe_proprietaire	text	1	(ffo:ccogrmtxt) typologie du proprietaire principal (ETAT, DEPARTEMENT, OFFICE HLM ...)	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_proprietaire	batiment_groupe_proprietaire	int4	1	(ffo) Nombre de proprietaires differents qui possèdent des locaux dans le bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_proprietaire_bailleur	batiment_groupe_proprietaire	int4	1	(ffo) Nombre de proprietaires bailleurs sociaux differents qui possèdent des locaux dans le bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_proprietaire_pm	batiment_groupe_proprietaire	int4	1	(ffo) Nombre de propriétaires	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_classe_ener_g	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie G	maintenu		open_data_lo	0	0	\N
nb_gestionnaire	batiment_groupe_proprietaire	int4	1	(ffo) nombre de gestionnaires différents dans le bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_qpv	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nom_quartier	batiment_groupe_qpv	text	1	Nom du quartier prioritaire dans lequel se trouve le bâtiment	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_radon	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_radon	varchar(2)	0	Code département INSEE	déprécié	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
alea	batiment_groupe_radon	TEXT	1	(radon) alea du risque radon	déprécié	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_rnc	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_rnc	varchar(2)	0	Code département INSEE	maintenu		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
numero_immat_principal	batiment_groupe_rnc	varchar(30)	1	numéro d'immatriculation principal associé au bâtiment groupe. (numéro d'immatriculation copropriété qui comporte le plus de lots)	maintenu		open_data_lo	0	0	\N
periode_construction_max	batiment_groupe_rnc	text	1	(rnc) Période de construction du local le plus récent	maintenu		open_data_lo	0	0	\N
l_annee_construction	batiment_groupe_rnc	text[]	1	Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)	maintenu		open_data_lo	0	0	\N
nb_lot_garpark	batiment_groupe_rnc	numeric	1	Nombre de lots de stationnement	maintenu		open_data_lo	0	0	\N
nb_lot_tot	batiment_groupe_rnc	numeric	1	Nombre total de lots	maintenu		open_data_lo	0	0	\N
nb_log	batiment_groupe_rnc	numeric	1	Nombre de logements déclaré dans le registre national des copropriétés pour le groupe de bâtiments	maintenu		open_data_lo	0	0	\N
nb_lot_tertiaire	batiment_groupe_rnc	numeric	1	Nombre de lots de type bureau et commerce	maintenu		open_data_lo	0	0	\N
l_nom_copro	batiment_groupe_rnc	text[]	1	(rnc) liste des noms des copropriétés	maintenu		open_data_lo	0	0	\N
l_siret	batiment_groupe_rnc	text[]	1	liste de siret	maintenu		open_data_lo	0	0	\N
copro_dans_pvd	batiment_groupe_rnc	bool	1	(rnc) au moins une des coproprietés est dans le programme petites villes de demain	maintenu		open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_rpls	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu		open_data_lo	1	1	\N
nb_loc_assoc	batiment_groupe_rpls	numeric	1	(rpls) Nombre de locaux associatifs	maintenu		ayant_droit_rpls	0	0	\N
nb_log_loue	batiment_groupe_rpls	numeric	1	(ffo) Nombre de logements loués avec un bail classique	maintenu		ayant_droit_rpls	0	0	\N
nb_log_vac	batiment_groupe_rpls	numeric	1	(ffo) Nombre de logements d'habitation vacants (Somme du champ nloghvac)	maintenu		ayant_droit_rpls	0	0	\N
code_departement_insee	batiment_groupe_rpls	varchar(2)	0	Code département INSEE	maintenu		open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
rpls_open	batiment_groupe_rpls	bool	1	True si tous les logements integrés sont en open	maintenu		open_data_lo	0	0	\N
nb_classe_ener_a	batiment_groupe_rpls	numeric	1	Nombre de logements avec un DPE énergie de classe A	maintenu		open_data_lo	0	0	\N
nb_classe_ener_b	batiment_groupe_rpls	numeric	1	Nombre de logements avec un DPE énergie de classe B	maintenu		open_data_lo	0	0	\N
nb_classe_ener_c	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie C	maintenu		open_data_lo	0	0	\N
nb_classe_ener_d	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie D	maintenu		open_data_lo	0	0	\N
nb_classe_ener_e	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie E	maintenu		open_data_lo	0	0	\N
nb_classe_ener_f	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie F	maintenu		open_data_lo	0	0	\N
nb_classe_ener_nc	batiment_groupe_rpls	numeric	1	Nombre de logements ayant la classe DPE énergie NC	maintenu		open_data_lo	0	0	\N
classe_ener_principale	batiment_groupe_rpls	text	1	(rpls) classe DPE énergie principale	maintenu		open_data_lo	0	0	\N
nb_classe_ges_a	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat A	maintenu		open_data_lo	0	0	\N
nb_classe_ges_b	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat B	maintenu		open_data_lo	0	0	\N
nb_classe_ges_c	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat C	maintenu		open_data_lo	0	0	\N
nb_classe_ges_d	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat D	maintenu		open_data_lo	0	0	\N
nb_classe_ges_e	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat E	maintenu		open_data_lo	0	0	\N
nb_classe_ges_f	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat F	maintenu		open_data_lo	0	0	\N
nb_classe_ges_g	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat G	maintenu		open_data_lo	0	0	\N
nb_classe_ges_nc	batiment_groupe_rpls	numeric	1	(rpls) Nombre de logements ayant la classe DPE climat NC	maintenu		open_data_lo	0	0	\N
classe_ges_principale	batiment_groupe_rpls	text	1	(rpls) classe DPE climat principale	maintenu		open_data_lo	0	0	\N
accessible_pmr	batiment_groupe_rpls	bool	1	(rpls) Présence d'au moins un logement PMR	maintenu		open_data_lo	0	0	\N
dans_qpv	batiment_groupe_rpls	bool	1	(rpls) Immeuble dans un QPV	maintenu		open_data_lo	0	0	\N
l_annee_construction	batiment_groupe_rpls	text[]	1	Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)	maintenu		open_data_lo	0	0	\N
l_ident_org	batiment_groupe_rpls	text[]	1	(rpls) Identifiant de l'organisme bailleur	maintenu		ayant_droit_rpls	0	0	\N
l_raison_sociale	batiment_groupe_rpls	text[]	1	(rpls) Raisons sociales des Bailleurs	maintenu		ayant_droit_rpls	0	0	\N
raison_sociale_principal	batiment_groupe_rpls	text	1	(rpls) Raison sociale principal au niveau batiment_groupe	maintenu		ayant_droit_rpls	0	0	\N
loyer_moyen	batiment_groupe_rpls	numeric	1	(rpls) Loyer moyen, tous usages confondus	maintenu		ayant_droit_rpls	0	0	\N
loyer_moyen_m2	batiment_groupe_rpls	numeric(10, 1)	1	(rpls) Loyer moyen au m² [€/m²]	maintenu		ayant_droit_rpls	0	0	\N
nb_log	batiment_groupe_rpls	numeric	1	Nombre de logements sociaux déclaré dans le RPLS pour le groupe de bâtiments	maintenu		open_data_lo	0	0	\N
s_log_hab	batiment_groupe_rpls	numeric	1	(rpls) Surface de logements d'habitation [m²]	maintenu	m²	open_data_lo	0	0	\N
type_construction	batiment_groupe_rpls	text[]	1	(rpls) Type de construction	maintenu		open_data_lo	0	0	\N
parcelle_unifiee_id	parcelle_unifiee_metrique	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	parcelle_unifiee_metrique	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nb_parcelle	parcelle_unifiee_metrique	int4	1	nombre de parcelle (au sens des fichiers fonciers) présentes dans la parcelle unifiee	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_batiment_groupe	parcelle_unifiee_metrique	int4	1	nombre de groupe de bâtiment présents dans la parcelle unifiee	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_batiment	parcelle_unifiee_metrique	int4	1	Nombre de bâtiments	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_batiment_construction	parcelle_unifiee_metrique	int4	1	nombre d'enceinte de bâtiment présentes dans la parcelle unifiee	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse	parcelle_unifiee_metrique	int4	1	Nombre d'adresses	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valide	parcelle_unifiee_metrique	int4	1	nombre d'adresses valides qui pointent vers la parcelle unifiée	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valide_ban	parcelle_unifiee_metrique	int4	1	nombre d'adresses valides issues de la BAN qui pointent vers la parcelle unifiée	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valide_arcep	parcelle_unifiee_metrique	int4	1	nombre d'adresses valides issues de l'ARCEP qui pointent vers la parcelle unifiée	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_adresse_valide_ffo	parcelle_unifiee_metrique	int4	1	nombre d'adresses valides issues des Fichiers Fonciers qui pointent vers la parcelle unifiée	maintenu	\N	ayant_droit_ffo	0	0	\N
cle_interop_adr_principale	parcelle_unifiee_metrique	text	1	clé d'interopérabilité de l'adresse principale	maintenu	\N	ayant_droit_ffo	1	0	\N
fiabilite_cr_adr_niv_1	parcelle_unifiee_metrique	text	0	Fiabilité des données croisées à l'adresse ('données croisées à l'adresse fiables', 'données croisées à l'adresse fiables à l'echelle de la parcelle unifiee', 'données croisées à l'adresse moyennement fiables', 'problème de géocodage')	maintenu	\N	ayant_droit_ffo	0	0	\N
fiabilite_cr_adr_niv_2	parcelle_unifiee_metrique	text	0	Fiabilité détaillée des données croisées à l'adresse	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_id	rel_batiment_adresse	VARCHAR(16)	0	Identifiant du bâtiment fiscal au sens des fichiers fonciers	maintenu	\N	ayant_droit_ffo	1	1	\N
cle_interop_adr	rel_batiment_adresse	TEXT	0	Clé d'interopérabilité de l'adresse postale	maintenu	\N	ayant_droit_ffo	1	1	\N
poids_nb_loc_pro	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(nombre de locaux professionnels desservis par l'adresse sur le bâtiment / nombre de locaux professionnels totaux desservis par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	rel_batiment_groupe_pie	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_pie	1	1	\N
code_departement_insee	rel_batiment_adresse	VARCHAR(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
origine	rel_batiment_adresse	TEXT	0	Origine de l'entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d'un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)	maintenu	\N	ayant_droit_ffo	0	0	{"Geocodage + Reconstruction Fantoir","Reconstruction Fantoir","Geocodage"}
batiment_construction_id	rel_batiment_construction_adresse	TEXT	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
cle_interop_adr	rel_batiment_construction_adresse	TEXT	0	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_construction_adresse	VARCHAR(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
distance_batiment_construction_adresse	rel_batiment_construction_adresse	INT4	0	Distance entre le géolocalisant adresse et la géométrie de bâtiment	maintenu	\N	open_data_lo	0	0	\N
fiabilite	rel_batiment_construction_adresse	INT4	1	Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :\
\
Critères et pondérations :\
\
- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5\
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5\
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3\
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3\
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2\
- cond_2 : l'adresse est une adresse BAN → +1\
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1\
\
Échelle du score :\
- Minimum : 0 (aucune condition vérifiée)\
- Maximum : 20 (toutes les conditions vérifiées)	maintenu	\N	open_data_lo	0	0	\N
adresse_principale	rel_batiment_construction_adresse	BOOL	0	Booléen précisant si l'adresse courante est l'une des adresses principales de la construction ou non. Une relation est taguée comme `principale` si l'adresse qui la compose obtient le score de fiabilité le plus important parmi toutes les adresses desservant une même construction. Il se peut, par conséquent, qu'une construction ait plusieurs adresses principales : toutes celles ayant le score de fiabilité le plus haut pour cette construction.	maintenu	\N	open_data_lo	0	0	\N
geom_batiment_construction_adresse	rel_batiment_construction_adresse	GEOMETRY(MultiLineString, 2154)	1	Géolocalisant du trait reliant le point adresse à la géométrie de la construction (Lambert-93, SRID=2154)	maintenu	\N	open_data_lo	1	0	\N
rnb_id	rel_batiment_construction_rnb	TEXT	1	Identifiant unique de l'entrée RNB.	expérimental	\N	open_data_lo	1	1	\N
batiment_construction_id	rel_batiment_construction_rnb	TEXT	0	Identifiant unique de l'entrée batiment_construction.	expérimental	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_construction_rnb	VARCHAR(2)	0	Code département INSEE	expérimental	\N	open_data_lo	1	0	\N
type_appariement	rel_batiment_construction_rnb	TEXT	0	Type d'appariement entre les entrées `batiment_groupe_id` (BC) de la BDNB et `rnb_id` du RNB	expérimental	\N	open_data_lo	0	0	\N
detail	rel_batiment_construction_rnb	TEXT	1	Détail sur le type d'appariement	expérimental	\N	open_data_lo	0	0	\N
geom_rnb_pos	rel_batiment_construction_rnb	GEOMETRY(Point, 2154)	1	Géométrie ponctuelle de l'objet RNB (Lambert-93, SRID=2154).	expérimental	\N	open_data_lo	1	0	\N
batiment_groupe_id	rel_batiment_groupe_adresse	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
cle_interop_adr	rel_batiment_groupe_adresse	TEXT	0	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_adresse	VARCHAR(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
poids_s_tot	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(surface desservie par l'adresse sur le bâtiment / surface totale desservie par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
poids_s_res	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(surface résidentielle desservie par l'adresse sur le bâtiment / surface résidentielle totale desservie par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
poids_s_pro	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(surface professionnelle desservie par l'adresse sur le bâtiment / surface professionnelle totale desservie par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
poids_nb_loc_tot	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(nombre de locaux desservis par l'adresse sur le bâtiment / nombre de locaux totaux desservis par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
poids_nb_loc_res	rel_batiment_groupe_adresse	NUMERIC(7,3)	1	(nombre de locaux résidentiels desservis par l'adresse sur le bâtiment / nombre de locaux résidentiels totaux desservis par l'adresse)	maintenu	\N	ayant_droit_ffo	0	0	\N
identifiant_dpe	rel_batiment_groupe_dpe_logement	TEXT	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	1	1	\N
origine	rel_batiment_groupe_adresse	TEXT	0	Origine de l'entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d'un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)	maintenu	\N	open_data_lo	0	0	{"Fichiers Fonciers","Association Geometrique","Association Geometrique + Fichiers Fonciers"}
fiabilite	rel_batiment_groupe_adresse	INT4	1	Le score de fiabilité d'une relation batiment_groupe avec une adresse est le maximum de la fiabilité des associations adresses batiment construction correspondantes.\
\
Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :\
\
Critères et pondérations :\
\
- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5\
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5\
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3\
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3\
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2\
- cond_2 : l'adresse est une adresse BAN → +1\
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1\
\
Échelle du score :\
- Minimum : 0 (aucune condition vérifiée)\
- Maximum : 20 (toutes les conditions vérifiées)	maintenu	\N	open_data_lo	0	0	\N
geom_bat_adresse	rel_batiment_groupe_adresse	GEOMETRY(MultiLineString, 2154)	0	Géolocalisant du trait reliant le point adresse à la géométrie du bâtiment groupe (Lambert-93, SRID=2154)	maintenu	\N	open_data_lo	1	0	\N
batiment_construction_id	rel_batiment_groupe_bdtopo_bat	text	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
bdtopo_bat_cleabs	rel_batiment_groupe_bdtopo_bat	TEXT	0	identifiant de la table bâtiment de la BDTOPO	maintenu	\N	open_data_lo	1	0	\N
batiment_groupe_id	rel_batiment_groupe_bdtopo_bat	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	rel_batiment_groupe_bdtopo_bat	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_construction_id	rel_batiment_groupe_bdtopo_equ	text	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
bdtopo_equ_cleabs	rel_batiment_groupe_bdtopo_equ	TEXT	0	identifiant de la table equipement de la BDTOPO	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	rel_batiment_groupe_bdtopo_equ	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	rel_batiment_groupe_bdtopo_equ	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_construction_id	rel_batiment_groupe_bdtopo_zoa	text	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
bdtopo_zoa_cleabs	rel_batiment_groupe_bdtopo_zoa	TEXT	0	identifiant de la table argiles	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	rel_batiment_groupe_bdtopo_zoa	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	rel_batiment_groupe_bdtopo_zoa	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_construction_id	rel_batiment_groupe_bpe	text	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_bpe	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_groupe_id	rel_batiment_groupe_bpe	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
bpe_non_officiel_id	rel_batiment_groupe_bpe	TEXT	0	identifiant de la table bpe	maintenu	\N	open_data_lo	1	1	\N
bassin_vie_code_insee	iris_contexte_geographique	text	1	Code insee des bassins de vie 2022 (BV2022)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
adresse_geocodee	rel_batiment_groupe_rnc	text	1	libelle de l'adresse retournée par le géocodeur	maintenu	\N	open_data_lo	0	0	\N
fiabilite_geocodage	rel_batiment_groupe_rnc	text	1	fiabilité du géocodage	maintenu	\N	open_data_lo	0	0	\N
fiabilite_globale	rel_batiment_groupe_rnc	text	1	fiabilité du global du croisement	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	rel_batiment_groupe_dpe_logement	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_dpe_logement	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
cle_interop_adr	rel_batiment_groupe_dpe_logement	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	0	\N
adresse_brut	rel_batiment_groupe_dpe_logement	text	1	adresse brute envoyée au géocodeur	maintenu	\N	open_data_lo	0	0	\N
adresse_geocodee	rel_batiment_groupe_dpe_logement	text	1	libelle de l'adresse retournée par le géocodeur	maintenu	\N	open_data_lo	0	0	\N
fiabilite_geocodage	rel_batiment_groupe_dpe_logement	text	1	fiabilité du géocodage	maintenu	\N	open_data_lo	0	0	\N
type_appariement	rel_batiment_groupe_dpe_logement	text	1	méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l'identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l'ensemble des méthodes utilisées pour l'appariement	maintenu	\N	open_data_lo	0	0	{"parcelle","adresse","parcelle + adresse","rnb + parcelle","rnb","rnb + parcelle + adresse","rnb + adresse"}
id_opendata	rel_batiment_groupe_dvf_open	varchar(60)	0	Identifiant open data de la mutation.	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	rel_batiment_groupe_dvf_open	varchar(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
parcelle_unifiee_id	rel_batiment_groupe_dvf_open	varchar(22)	0	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	1	0	\N
code_departement_insee	rel_batiment_groupe_dvf_open	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
fiabilite_croisement	rel_batiment_groupe_dvf_open	varchar(10)	1	Fiabilité de l'appariement entre les bâtiments groupes et les mutations. La fiabilité est forte si l'ensemble des locaux de la mutation se situent sur un unique bâtiment groupe. La fiabilité est faible si les locaux de la mutation ne peuvent être associés à un unique bâtiment groupe.	maintenu	\N	open_data_lo	0	0	\N
join_id_opendata	rel_batiment_groupe_dvf_open	bool	1	L'appariement a été réalisé à partir de l'id_opendata en le croisant avec les dv3f.	maintenu	\N	open_data_lo	0	0	\N
join_geom_local	rel_batiment_groupe_dvf_open	bool	1	L'appariement a été réalisé à partir de la présence du localisant ponctuel du local ayant muté au sein de la géométrie de la parcelle unifiée.	maintenu	\N	open_data_lo	0	0	\N
batiment_construction_id	rel_batiment_groupe_merimee	text	0	Identifiant unique de l'entrée batiment_construction.	maintenu	\N	open_data_lo	1	1	\N
merimee_ref	rel_batiment_groupe_merimee	TEXT	0	identifiant de la table merimee	maintenu	\N	open_data_lo	1	1	\N
batiment_groupe_id	rel_batiment_groupe_merimee	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	rel_batiment_groupe_merimee	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
distance_batiment_historique	rel_batiment_groupe_merimee	int2	1	(mer) Distance entre le batiment_historique et le batiment_construction (si moins de 500m) [m]	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	rel_batiment_groupe_parcelle	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
parcelle_id	rel_batiment_groupe_parcelle	varchar(14)	0	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_parcelle	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
parcelle_principale	rel_batiment_groupe_parcelle	BOOL	1	Booléen renvoyant 'vrai' si la parcelle cadastrale est la plus grande intersectant le groupe de bâtiment	maintenu	\N	open_data_lo	0	0	\N
id_pie	rel_batiment_groupe_pie	TEXT	0	identifiant de la table pie	maintenu	\N	ayant_droit_pie	1	1	\N
code_departement_insee	rel_batiment_groupe_pie	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_pie	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
cle_interop_adr	rel_batiment_groupe_pie	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	ayant_droit_pie	1	0	\N
adresse_brut	rel_batiment_groupe_pie	text	1	adresse brute envoyée au géocodeur	maintenu	\N	ayant_droit_pie	0	0	\N
adresse_geocodee	rel_batiment_groupe_pie	text	1	libelle de l'adresse retournée par le géocodeur	maintenu	\N	ayant_droit_pie	0	0	\N
fiabilite_geocodage	rel_batiment_groupe_pie	text	1	fiabilité du géocodage	maintenu	\N	ayant_droit_pie	0	0	\N
batiment_groupe_id	rel_batiment_groupe_proprietaire	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
personne_id	rel_batiment_groupe_proprietaire	varchar(8)	0	Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_proprietaire	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
s_locaux	rel_batiment_groupe_proprietaire	int4	1	(ffo:slocal) surface totale de local détenue par le propriétaire dans le batiment groupe [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log	rel_batiment_groupe_proprietaire	int4	1	(ffo) Surface totale des pièces d'habitation des locaux possédés par le proprietaire dans le batiment groupe (en m²) (Utilisation de l'attribut dsupdc, nul si npevph nul) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_locaux	rel_batiment_groupe_proprietaire	int4	1	nombre de logements possédé par le propriétaire dans ce groupe de bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log	rel_batiment_groupe_proprietaire	int4	1	nombre de logements possédé par le propriétaire dans ce groupe de bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
dans_majic_pm	rel_batiment_groupe_proprietaire	bool	1	(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm	maintenu	\N	open_data_lo	0	0	\N
nb_locaux_open	rel_batiment_groupe_proprietaire	int4	1	nombre de locaux possédé par le propriétaire dans ce groupe de bâtiment diffusé dans majic personne morale	maintenu	\N	open_data_lo	0	0	\N
batiment_construction_id	rel_batiment_groupe_qpv	text	0	Identifiant unique de l'entrée batiment_construction.	déprécié	\N	open_data_lo	1	1	\N
qpv_code_qp	rel_batiment_groupe_qpv	TEXT	0	identifiant de la table qpv	déprécié	\N	open_data_lo	1	0	\N
batiment_groupe_id	rel_batiment_groupe_qpv	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	déprécié	\N	open_data_lo	1	0	\N
code_departement_insee	rel_batiment_groupe_qpv	varchar(2)	0	Code département INSEE	déprécié	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
batiment_groupe_id	rel_batiment_groupe_rnc	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
numero_immat	rel_batiment_groupe_rnc	TEXT	0	identifiant de la table rnc	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_rnc	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
cle_interop_adr	rel_batiment_groupe_rnc	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	0	\N
adresse_brut	rel_batiment_groupe_rnc	text	1	adresse brute envoyée au géocodeur	maintenu	\N	open_data_lo	0	0	\N
parcelle_id	rel_batiment_groupe_rnc	text	1	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	open_data_lo	0	0	\N
parcelle_unifiee_id	rel_batiment_groupe_rnc	text	1	Identifiant de la parcelle unifiée dans la BDNB. Dans la très grande majorité des cas, il s'agit des identifiants idtup des fichiers fonciers (CEREMA). Une partie marginale de ces identifiants sont des identifiants de parcelles non documentées dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	0	0	\N
batiment_groupe_id	rel_batiment_groupe_rpls	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_rpls	1	1	\N
ident_rpls	rel_batiment_groupe_rpls	TEXT	0	identifiant rpls de la source	maintenu	\N	ayant_droit_rpls	1	1	\N
code_departement_insee	rel_batiment_groupe_rpls	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_rpls	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
cle_interop_adr	rel_batiment_groupe_rpls	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	ayant_droit_rpls	1	0	\N
adresse_brut	rel_batiment_groupe_rpls	text	1	adresse brute envoyée au géocodeur	maintenu	\N	ayant_droit_rpls	0	0	\N
adresse_geocodee	rel_batiment_groupe_rpls	text	1	libelle de l'adresse retournée par le géocodeur	maintenu	\N	ayant_droit_rpls	0	0	\N
fiabilite_geocodage	rel_batiment_groupe_rpls	text	1	fiabilité du géocodage	maintenu	\N	ayant_droit_rpls	0	0	\N
fiabilite_globale	rel_batiment_groupe_rpls	text	1	fiabilité du global du croisement	maintenu	\N	ayant_droit_rpls	0	0	\N
batiment_id	rel_batiment_groupe_rpls	text	1	Identifiant du bâtiment fiscal au sens des fichiers fonciers	maintenu	\N	ayant_droit_rpls	0	0	\N
local_id	rel_batiment_groupe_rpls	text	1	identifiant du local dans les Fichiers Fonciers (Concaténation de ccodep, invar)	maintenu	\N	ayant_droit_rpls	0	0	\N
rpls_open	rel_batiment_groupe_rpls	bool	1	True si tous les logements integrés sont en open	maintenu	\N	ayant_droit_rpls	0	0	\N
batiment_groupe_id	batiment_groupe_simulations_dpe	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_simulation_dpe	1	1	\N
code_departement_insee	batiment_groupe_simulations_dpe	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_simulation_dpe	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
indecence_energetique_initial	batiment_groupe_simulations_dpe	float4	1	probabilité du bâtiment d'être en indécence énergétique dans son état initial	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
indecence_energetique_renove	batiment_groupe_simulations_dpe	float4	1	probabilité du bâtiment d'être en indécence énergétique dans son état rénové (rénovation globale)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
volume_habitable	batiment_groupe_simulations_dpe	int4	1	volume habitable du bâtiment [m3]	maintenu	m3	ayant_droit_ffo	0	0	\N
volume_brut	batiment_groupe_simulations_dpe	int4	1	Volume brut du bâtiment [m3]	maintenu	m3	ayant_droit_simulation_dpe	0	0	\N
surface_facade_vitree	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface de façade vitrée [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_facade_totale	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface totale de façade (murs + baies) [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_facade_mitoyenne	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface de façade donnant sur un autre bâtiment [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_facade_ext	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface de façade donnant sur l'exterieur [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_enveloppe	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface de l'enveloppe [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_verticale	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface verticale du bâtiment [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_deperditive	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface déperditive du bâtiment [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_deperditive_verticale	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface déperditive verticale du bâtiment [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
surface_toiture	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface de toiture du bâtiment [m²]	maintenu	m²	ayant_droit_simulation_dpe	0	0	\N
sh	batiment_groupe_simulations_dpe	int4	1	Estimation de la surface habitable du bâtiment [m²]	maintenu	m²	ayant_droit_ffo	0	0	\N
etat_initial_consommation_energie_primaire_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute de la consommation énergétique primaire avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
gisement_gain_conso_finale_total	batiment_groupe_simulations_dpe	int4	1	Estimation du gisement de gain de consommation finale total	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
gisement_gain_ges_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne du gisement de gain sur les émissions de gaz à effets de serre	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
gisement_gain_energetique_mean	batiment_groupe_simulations_dpe	int4	1	Estimation du gain énergétique moyen	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_inc	batiment_groupe_simulations_dpe	int4	1	Fiabilité des estimations de consommation énergétique finale avant rénovation [1-5].\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse de la consommation énergétique finale avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique finale avant rénovation [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute de la consommation énergétique finale avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_primaire_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse de la consommation énergétique primaire avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_primaire_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique primaire avant rénovation [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_ges_estim_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude sur l'estimation de consommation de GES avant rénovation \
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse de la consommation de GES avant rénovation [kgeqC02/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne de la consommation de GES avant rénovation [kgeqC02/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute de la consommation de GES avant rénovation [kgeqC02/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_risque_canicule	batiment_groupe_simulations_dpe	int4	1	Estimation du risque canicule avant rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_risque_canicule_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude de l'estimation du risque canicule avant rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude sur les estimations des consommations énergétiques finales après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_ges_estim_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude sur l'estimation de consommation de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kgeqC02/m2/an]\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_ges_estim_lower	batiment_groupe_simulations_dpe	int4	1	Estimation basse des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_ges_estim_mean	batiment_groupe_simulations_dpe	int4	1	Estimation moyenne des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_ges_estim_upper	batiment_groupe_simulations_dpe	int4	1	Estimation haute des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_risque_canicule	batiment_groupe_simulations_dpe	int4	1	Estimation du risque canicule après rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_risque_canicule_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude de l'estimation du risque canicule après rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_a	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette A dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_b	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette B dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_c	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette C dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
bassin_vie_libelle	iris_contexte_geographique	text	1	Libellé des bassins de vie 2022 (BV2022)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etiquette_dpe_initial_d	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette D dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_e	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette E dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_f	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette F dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_g	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette G dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_error	batiment_groupe_simulations_dpe	float4	1	Erreur sur la simulation de DPE pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map	batiment_groupe_simulations_dpe	varchar(1)	1	Etiquette ayant la plus grande probabilité pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_2nd	batiment_groupe_simulations_dpe	varchar(3)	1	2 étiquettes ayant la plus grande probabilité pour l'état actuel du bâtiment. Si le champs vaut F-G alors F la première étiquette est l'étiquette la plus probable , G la seconde étiquette la plus probable.	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_prob	batiment_groupe_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE égale à l'étiquette ayant la plus grande probabilité pour l'état actuel du bâtiment. C'est la probabilité d'avoir pour ce bâtiment l'étiquette etiquette_dpe_initial_map. Si etiquette_dpe_initial_map = F et que etiquette_dpe_initial_map_prob = 0.64 alors il y a 64% de chance que l'étiquette DPE de ce bâtiment soit classé F	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_2nd_prob	batiment_groupe_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE parmi les 2 étiquettes ayant la plus grande probabilité pour l'état actuel du bâtiment. Si etiquette_dpe_initial_map_2nd = F-G et que etiquette_dpe_initial_map_2nd_prob = 0.95 alors il y a 95% de chance que l'étiquette DPE de ce bâtiment soit classé F ou G.	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_inc	batiment_groupe_simulations_dpe	int4	1	Classe d'incertitude sur la prédiction de l'étiquette dpe avec la plus grande probabilité avant rénovation [1 à 5].\
Cet indicateur se lit de 1 = peu fiable à 5 = fiable.\
La fiabilité est basé sur la densité de probabilité intégrée sur les 2 étiquettes prédites les plus probables.\
Par exemple, si les 2 étiquettes les plus probables sont C ou D, et que la somme des probabilités d'avoir C ou D est > à 90%, \
alors la fiabilité est considéré être à 5.\
  - 5 : de 100% à 90% de probabilité dans les 2 étiquettes les plus probables\
  - 4: de 80% à 90%\
  - 3: de 70% à 80%\
  - 2: de 60% à 70%\
  - 1: de 0% à 60%	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_a	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette A dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_b	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette B dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_c	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette C dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_d	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette D dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_e	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette E dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_f	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette F dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_g	batiment_groupe_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette G dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_error	batiment_groupe_simulations_dpe	float4	1	Erreur sur la simulation de DPE avant rénovation	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map	batiment_groupe_simulations_dpe	varchar(1)	1	Etiquette ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map_2nd	batiment_groupe_simulations_dpe	varchar(3)	1	2 étiquettes ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map_prob	batiment_groupe_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE égale à l'étiquette ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
nb_locaux	rel_batiment_groupe_siren	integer	1	nombre de logements possédé par le propriétaire dans ce groupe de bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
etiquette_dpe_renove_map_2nd_prob	batiment_groupe_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE parmi les 2 étiquettes ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_inc	batiment_groupe_simulations_dpe	int4	1	Incertitude de classe sur l'étiquette dpe avec la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [1-5]\
Cet indicateur se lit de 1 = peu fiable à 5 = fiable.\
La fiabilité est basé sur la densité de probabilité intégrée sur les 2 étiquettes prédites les plus probables.\
Par exemple, si les 2 étiquettes les plus probables sont C ou D, et que la somme des probabilités d'avoir C ou D est > à 90%, \
alors la fiabilité est considéré être à 5.\
  - 5 : de 100% à 90% de probabilité dans les 2 étiquettes les plus probables\
  - 4: de 80% à 90%\
  - 3: de 70% à 80%\
  - 2: de 60% à 70%\
  - 1: de 0% à 60%	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_lower	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_lower")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_mean	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_upper	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_upper")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_ecs_estim_mean	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_ecs_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_lower	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_lower")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_mean	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_upper	batiment_groupe_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_upper")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
batiment_groupe_id	batiment_groupe_simulations_dvf	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_simulation_dvf	1	1	\N
code_departement_insee	batiment_groupe_simulations_dvf	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_simulation_dvf	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
usage_niveau_1_txt	batiment_groupe_simulations_dvf	text	1	indicateurs d'usage simplifié du bâtiment (verbose). Cette donnée est dépréciée au niveau de cette table car redondante avec les informations présentes dans batiment_groupe_ffo_bat	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_initial_estim_lower	batiment_groupe_simulations_dvf	float8	1	Estimation basse de la valeur fonciere avant renovation [€/m²] (intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_initial_estim_mean	batiment_groupe_simulations_dvf	float8	1	Estimation moyenne de la valeur fonciere avant renovation [€/m²]	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_initial_estim_upper	batiment_groupe_simulations_dvf	float8	1	Estimation haute de la valeur fonciere avant renovation [€/m²] (intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_initial_incertitude	batiment_groupe_simulations_dvf	text	1	incertitude de l'estimation de la valeur fonciere avant renovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_renove_estim_lower	batiment_groupe_simulations_dvf	float8	1	Estimation basse de la valeur fonciere apres renovation [€/m²] (intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_renove_estim_mean	batiment_groupe_simulations_dvf	float8	1	Estimation moyenne de la valeur fonciere apres renovation [€/m²]	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_renove_estim_upper	batiment_groupe_simulations_dvf	float8	1	Estimation haute de la valeur fonciere apres renovation [€/m²] (intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
valeur_fonciere_etat_renove_incertitude	batiment_groupe_simulations_dvf	text	1	incertitude de l'estimation de la valeur fonciere apres renovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
classe_dpe_conso_initial	batiment_groupe_simulations_dvf	text	1	classe dpe a l'echelle bâtiment predit dans son etat initial	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
classe_dpe_conso_renove	batiment_groupe_simulations_dvf	text	1	classe dpe a l'echelle bâtiment predit dans son etat renove	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
r2	batiment_groupe_simulations_dvf	float8	1	r2 du modele de simulation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
difference_abs_valeur_fonciere_etat_initial_renove	batiment_groupe_simulations_dvf	float8	1	difference absolue entre la valeur foncière avant et apres renovation [€/m²]	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
difference_rel_valeur_fonciere_etat_initial_renove	batiment_groupe_simulations_dvf	float8	1	difference relative de valeur fonciere avant et apres renovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
difference_rel_valeur_fonciere_etat_initial_renove_categorie	batiment_groupe_simulations_dvf	text	1	categorie de la difference relative de valeur fonciere avant et apres renovation (verbose)	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
difference_rel_valeur_fonciere_initial_mean_iris	batiment_groupe_simulations_dvf	float8	1	difference relative de la valeur fonciere avant renovation par rapport à la moyenne à l'iris predite sans renovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
difference_rel_valeur_fonciere_renove_mean_iris	batiment_groupe_simulations_dvf	float8	1	difference relative de la valeur fonciere apres renovation par rapport à la moyenne à l'iris predite sans renovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
batiment_groupe_id	batiment_groupe_simulations_valeur_verte	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_simulation_dvf	1	1	\N
code_departement_insee	batiment_groupe_simulations_valeur_verte	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_simulation_dvf	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
renovation	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule une rénovation	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_b_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE B vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_c_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE C vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_c_vers_b	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE C vers B	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_d_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_d_vers_b	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers B	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_d_vers_c	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers C	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_e_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_e_vers_b	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers B	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_e_vers_c	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers C	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_e_vers_d	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers D	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_f_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_f_vers_b	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers B	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_f_vers_c	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers C	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_f_vers_d	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers D	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_f_vers_e	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers E	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_g_vers_a	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers A	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_g_vers_b	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers B	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_g_vers_c	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers C	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
bassin_vie_catg	iris_contexte_geographique	text	1	Catégorie des bassins de vie 2022 (BV2022)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
gain_classe_g_vers_d	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers D	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_g_vers_e	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers E	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
gain_classe_g_vers_f	batiment_groupe_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers F	maintenu	\N	ayant_droit_simulation_dvf	0	0	\N
code_departement_insee	iris_simulations_valeur_verte	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_valeur_verte	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
code_iris	iris_simulations_valeur_verte	varchar(30)	0	Code iris INSEE	maintenu	\N	ayant_droit_valeur_verte	1	1	\N
renovation	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule une rénovation	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_b_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE B vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_c_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE C vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_c_vers_b	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE C vers B	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_d_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_d_vers_b	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers B	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_d_vers_c	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE D vers C	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_e_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_e_vers_b	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers B	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_e_vers_c	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers C	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_e_vers_d	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE E vers D	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_f_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_f_vers_b	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers B	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_f_vers_c	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers C	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_f_vers_d	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers D	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_f_vers_e	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE F vers E	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_a	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers A	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_b	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers B	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_c	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers C	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_d	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers D	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_e	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers E	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
gain_classe_g_vers_f	iris_simulations_valeur_verte	numeric	1	(simulations) gain en % de la valeur immobilière lorsqu'on simule le changement de DPE G vers F	maintenu	\N	ayant_droit_valeur_verte	0	0	\N
cstb_local_oid	local_simulations_dpe	int4	0	identifiant local généré par auto incrément (anonyme), non persistant non signifiant , ceci est purement un identifiant technique	maintenu	\N	ayant_droit_simulation_dpe	1	1	\N
local_id	local_simulations_dpe	varchar(12)	0	identifiant du local dans les Fichiers Fonciers (Concaténation de ccodep, invar)	maintenu	\N	ayant_droit_ffo	1	0	\N
batiment_groupe_id	local_simulations_dpe	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_simulation_dpe	1	0	\N
code_departement_insee	local_simulations_dpe	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_simulation_dpe	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
position_logement	local_simulations_dpe	text	1	Position du logement au sens de la simulation, est ce que le plancher haut et/ou bas du logement sont déperditifs (all_deper= plancher haut et bas déperditif, pb_deper = plancher bas déperditif, ph_deper = plancher haut déperditif, intermediaire = plancher bas et haut non déperditif)	maintenu	\N	ayant_droit_ffo	0	0	\N
stoth	local_simulations_dpe	int4	0	Surface habitable totale du local (m²)	maintenu	\N	ayant_droit_ffo	0	0	\N
indecence_energetique_initial	local_simulations_dpe	float4	1	probabilité du bâtiment d'être en indécence énergétique dans son état initial	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
gisement_gain_ges_mean	local_simulations_dpe	int4	1	Estimation moyenne du gisement de gain sur les émissions de gaz à effets de serre	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
gisement_gain_energetique_mean	local_simulations_dpe	int4	1	Estimation du gain énergétique moyen	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_inc	local_simulations_dpe	int4	1	Fiabilité des estimations de consommation énergétique finale avant rénovation [1-5].\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
nb_log	rel_batiment_groupe_siren	integer	1	nombre de logements possédé par le propriétaire dans ce groupe de bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
etat_initial_consommation_energie_estim_lower	local_simulations_dpe	int4	1	Estimation basse de la consommation énergétique finale avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique finale avant rénovation [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_estim_upper	local_simulations_dpe	int4	1	Estimation haute de la consommation énergétique finale avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_primaire_estim_lower	local_simulations_dpe	int4	1	Estimation basse de la consommation énergétique primaire avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_primaire_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique primaire avant rénovation [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_energie_primaire_estim_upper	local_simulations_dpe	int4	1	Estimation haute de la consommation énergétique primaire avant rénovation [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_consommation_ges_estim_inc	local_simulations_dpe	int4	1	Incertitude sur l'estimation de consommation de GES avant rénovation \
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_lower	local_simulations_dpe	int4	1	Estimation basse de la consommation de GES avant rénovation [kgeqC02/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne de la consommation de GES avant rénovation [kgeqC02/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_ges_estim_upper	local_simulations_dpe	int4	1	Estimation haute de la consommation de GES avant rénovation [kgeqC02/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_risque_canicule	local_simulations_dpe	int4	1	Estimation du risque canicule avant rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_risque_canicule_inc	local_simulations_dpe	int4	1	Incertitude de l'estimation du risque canicule avant rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_error	local_simulations_dpe	float4	1	Erreur sur la simulation de DPE pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map	local_simulations_dpe	varchar(1)	1	Etiquette ayant la plus grande probabilité pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_inc	local_simulations_dpe	int4	1	Incertitude sur les estimations des consommations énergétiques finales après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_lower	local_simulations_dpe	int4	1	Estimation basse de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_estim_upper	local_simulations_dpe	int4	1	Estimation haute de la consommation énergétique finale après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_lower	local_simulations_dpe	int4	1	Estimation basse de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_consommation_energie_primaire_estim_upper	local_simulations_dpe	int4	1	Estimation haute de la consommation d'énergie primaire après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_2nd	local_simulations_dpe	varchar(3)	1	2 étiquettes ayant la plus grande probabilité pour l'état actuel du bâtiment. Si le champs vaut F-G alors F la première étiquette est l'étiquette la plus probable , G la seconde étiquette la plus probable.	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
bassin_vie_catg_libelle	iris_contexte_geographique	text	1	Libellé de la catégorie des bassins de vie 2022 (BV2022)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etat_renove_consommation_ges_estim_inc	local_simulations_dpe	int4	1	Incertitude sur l'estimation de consommation de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kgeqC02/m2/an]\
La fiabilité est basée sur le ratio entre la largeur de l'intervalle de confiance à 95% et la valeur moyenne.\
- 5 : de 0% à 20% \
- 4 : de 20% à 100%\
- 3 : de 100% à 150%\
- 2 : de 150% à 200%\
- 1 : 200% et +	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_ges_estim_lower	local_simulations_dpe	int4	1	Estimation basse des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
denomination_personne_morale	siren	text	1	Dénomination de l'entité identifiée par un SIREN	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etat_renove_ges_estim_mean	local_simulations_dpe	int4	1	Estimation moyenne des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_ges_estim_upper	local_simulations_dpe	int4	1	Estimation haute des émissions de GES après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [kWh/m2/an]\
(Intervalle à 95%)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_risque_canicule	local_simulations_dpe	int4	1	Estimation du risque canicule après rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_risque_canicule_inc	local_simulations_dpe	int4	1	Incertitude de l'estimation du risque canicule après rénovation [1-5]	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_a	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette A dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_b	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette B dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_c	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette C dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_d	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette D dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_e	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette E dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_f	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette F dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_g	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette G dans le bâtiment pour l'état actuel du bâtiment	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_prob	local_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE égale à l'étiquette ayant la plus grande probabilité pour l'état actuel du bâtiment. C'est la probabilité d'avoir pour ce bâtiment l'étiquette etiquette_dpe_initial_map. Si etiquette_dpe_initial_map = F et que etiquette_dpe_initial_map_prob = 0.64 alors il y a 64% de chance que l'étiquette DPE de ce bâtiment soit classé F	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_map_2nd_prob	local_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE parmi les 2 étiquettes ayant la plus grande probabilité pour l'état actuel du bâtiment. Si etiquette_dpe_initial_map_2nd = F-G et que etiquette_dpe_initial_map_2nd_prob = 0.95 alors il y a 95% de chance que l'étiquette DPE de ce bâtiment soit classé F ou G.	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_initial_inc	local_simulations_dpe	int4	1	Classe d'incertitude sur la prédiction de l'étiquette dpe avec la plus grande probabilité avant rénovation [1 à 5].\
Cet indicateur se lit de 1 = peu fiable à 5 = fiable.\
La fiabilité est basé sur la densité de probabilité intégrée sur les 2 étiquettes prédites les plus probables.\
Par exemple, si les 2 étiquettes les plus probables sont C ou D, et que la somme des probabilités d'avoir C ou D est > à 90%, \
alors la fiabilité est considéré être à 5.\
  - 5 : de 100% à 90% de probabilité dans les 2 étiquettes les plus probables\
  - 4: de 80% à 90%\
  - 3: de 70% à 80%\
  - 2: de 60% à 70%\
  - 1: de 0% à 60%	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_a	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette A dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_b	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette B dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_c	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette C dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_d	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette D dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
grille_communale_densite_catg	iris_contexte_geographique	text	1	Catégorie de la Grille communale de densité	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etiquette_dpe_renove_e	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette E dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_f	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette F dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_g	local_simulations_dpe	float4	1	Estimation de la probabilité d'avoir des logements d'étiquette G dans le bâtiment après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_error	local_simulations_dpe	float4	1	Erreur sur la simulation de DPE avant rénovation	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map	local_simulations_dpe	varchar(1)	1	Etiquette ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
dans_majic_pm	rel_batiment_groupe_siren	bool	1	(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etiquette_dpe_renove_map_2nd	local_simulations_dpe	varchar(3)	1	2 étiquettes ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map_prob	local_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE égale à l'étiquette ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etiquette_dpe_renove_map_2nd_prob	local_simulations_dpe	float4	1	Probabilité que le bâtiment ait une étiquette DPE parmi les 2 étiquettes ayant la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
perimetre_developpement_prioritaire	batiment_groupe_indicateur_reseau_chaud_froid	bool	0	Est vrai lorsque le bâtiment se situe dans une zone de développement prioritaire. Dans ce cas, le raccordement au réseau peut être obligatoire si il n'y a pas de contraintes techniques, ni un coût de raccordement disproportionné.	maintenu	\N	open_data_lo	0	0	\N
grille_communale_densite_catg_libelle	iris_contexte_geographique	text	1	Libellé de la catégorie de la Grille communale de densité	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
unite_urbaine_code_insee	iris_contexte_geographique	text	1	Code INSEE des unités urbaines	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
unite_urbaine_libelle	iris_contexte_geographique	text	1	Libellé des unités urbaines	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etiquette_dpe_renove_inc	local_simulations_dpe	int4	1	Incertitude de classe sur l'étiquette dpe avec la plus grande probabilité après un scénario de rénovation globale "standard" (isolation des principaux composants d'enveloppe et changement de système énergétique de chauffage)  [1-5]\
Cet indicateur se lit de 1 = peu fiable à 5 = fiable.\
La fiabilité est basé sur la densité de probabilité intégrée sur les 2 étiquettes prédites les plus probables.\
Par exemple, si les 2 étiquettes les plus probables sont C ou D, et que la somme des probabilités d'avoir C ou D est > à 90%, \
alors la fiabilité est considéré être à 5.\
  - 5 : de 100% à 90% de probabilité dans les 2 étiquettes les plus probables\
  - 4: de 80% à 90%\
  - 3: de 70% à 80%\
  - 2: de 60% à 70%\
  - 1: de 0% à 60%	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_lower	local_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_lower")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_mean	local_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_chauffage_estim_upper	local_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_chauffage_estim_upper")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_initial_besoin_ecs_estim_mean	local_simulations_dpe	int4	1	{ doc("col_etat_initial_besoin_ecs_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_lower	local_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_lower")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_mean	local_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_mean")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
etat_renove_besoin_chauffage_estim_upper	local_simulations_dpe	int4	1	{ doc("col_etat_renove_besoin_chauffage_estim_upper")}	maintenu	\N	ayant_droit_simulation_dpe	0	0	\N
batiment_groupe_id	batiment_groupe_indicateur_reseau_chaud_froid	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
id_reseau	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	1	(France chaleur urbaine) Identifiant national du réseau.	maintenu	\N	open_data_lo	1	0	\N
id_reseau_bdnb	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	0	Identifiant BDNB, lié au réseau de chaleur, car des données sources ne disposent pas d'identifiant unique pour chacune des entrées (traces et points).	maintenu	\N	open_data_lo	1	0	\N
code_departement_insee	batiment_groupe_indicateur_reseau_chaud_froid	VARCHAR(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
reseau_en_construction	batiment_groupe_indicateur_reseau_chaud_froid	bool	0	Est vrai lorsque le réseau à proximité du bâtiment est en cours de construction ou en projet. Le réseau en construction peut avoir un tracé précis ou être délimité par une zone de construction du réseau. S'il n'y a pas de tracé disponible la distance au réseau considérée est la plus courte distance à la zone. \
Un réseau en construction ne possède pas d'identfiant réseau.	maintenu	\N	open_data_lo	0	0	\N
aire_attraction_ville_catg_libelle	iris_contexte_geographique	text	1	Libellé de l'Aire d'Attraction urbaine des Villes (AAV2020) - recensement 2020	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
potentiel_raccordement_reseau_chaleur	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	0	Indicateur de potentiel de raccordement au réseau de chaleur. L'indicateur dépend de la distance entre le bâtiment et le réseau et du type de circuit de chauffage existant du bâtiment. Enfin, si le bâtiment est déjà raccordé alors il est indiqué comme tel.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"assez fort","faible","fort","inconnu","raccordé"}
potentiel_obligation_raccordement	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	1	Indique si le bâtiment est éventuellement dans l'obligation de se\
          raccorder lors de certains travaux de rénovation. Pour que potentiel_obligation_raccordement\
          soit possible, le bâtiment doit être situé à moins de 100m d'un réseau classé\
          et son système de chauffage indiqué comme collectif. Attention, cet indicateur\
          n'est qu'à titre d'information.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"possible"}
indicateur_systeme_chauffage	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	1	Indication sur le système de chauffage en vue d'un potentiel raccordement\
          au réseau de chaleur	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"adapte","inadapté","inconnu","raccordé au reseau de chaleur"}
indicateur_distance_au_reseau	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	1	Indication sur la distance entre le bâtiment et le point au réseau\
          de chaleur le plus proche en vue d'un potentiel raccordement au réseau.	maintenu	\N	open_data_lo	0	0	{"supérieur à 400m","entre 100 et 200m","entre 200 et 400m","inferieure à 100m","raccordé au reseau de chaleur"}
consommation_chaleur_par_rapport_distance_au_reseau	batiment_groupe_indicateur_reseau_chaud_froid	TEXT	1	Indication sur la consommation de chaleur du bâtiment et sa distance\
          au réseau. Plus un bâtiment consomme plus celui-ci peut être éloigné du réseau\
          et malgré tout être raccordé. Ici, si la distance entre le bâtiment et le réseau\
          est suffisamment proche par rapport à sa consommation, la consommation est noté\
          'suffisante', sinon elle est notée 'trop faible'.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"suffisante","trop faible","raccordé au reseau de chaleur"}
code_departement_insee	iris_contexte_geographique	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
code_iris	iris_contexte_geographique	varchar(30)	0	Code iris INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
en_montagne	iris_contexte_geographique	boolean	1	iris situé en montagne	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
en_littoral	iris_contexte_geographique	boolean	1	Iris situé en littoral	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
aire_attraction_ville_code_insee	iris_contexte_geographique	text	1	Code insee des Aires d'Attractions urbaines des Villes (AAV2020) - recensement 2020	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
aire_attraction_ville_libelle	iris_contexte_geographique	text	1	Libellé des Aires d'Attractions urbaines des Villes (AAV2020) - recensement 2020	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
aire_attraction_ville_catg	iris_contexte_geographique	text	1	Catégorie de l'Aire d'Attraction urbaine des Villes (AAV2020) - recensement 2020	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
unite_urbaine_catg_libelle	iris_contexte_geographique	text	1	Libellé de la catégorie des unités urbaines	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
aire_urbaine_fonctionnelle_eurostat	iris_contexte_geographique	text	1	Code des cities et des aires urbaines fonctionnelles (FUA) - eurostat	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
aire_urbaine_fonctionnelle_libelle	iris_contexte_geographique	text	1	Libellé des cities et des aires urbaines fonctionnelles (FUA) - eurostat	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
zone_emploi_code_insee	iris_contexte_geographique	text	1	Code insee des zones d'emploi	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
zone_emploi_libelle	iris_contexte_geographique	text	1	Libellé des zones d'emploi	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
action_coeur_ville_code_anct	iris_contexte_geographique	text	1	Code anct des communes sélectionnées pour le programme Action cœur de ville	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
action_coeur_ville_libelle	iris_contexte_geographique	text	1	Libellé des communes sélectionnées pour le programme Action cœur de ville	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
zone_aide_finalite_reg_code_anct	iris_contexte_geographique	boolean	1	Code anct des zones d’aides à finalité régionale (AFR) pour la période 2022-2027	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
zone_aide_finalite_reg_catg	iris_contexte_geographique	text	1	Catégorie des zones d’aides à finalité régionale (AFR) pour la période 2022-2027	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
contrat_relance_trans_eco_code_anct	iris_contexte_geographique	text[]	1	Code anct des iris dans le Contrat de relance et de transition écologique (CRTE)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
contrat_relance_trans_eco_libelle	iris_contexte_geographique	text[]	1	Libellés des communes/iris dans le Contrat de relance et de transition écologique (CRTE)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
petites_villes_demain_code_anct	iris_contexte_geographique	text	1	Code anct des iris/comunes dans le programme petites villes de demain (PVD)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
territoires_industrie_code_anct	iris_contexte_geographique	text	1	Code anct - programme territoires d'industrie	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
territoires_industrie_libelle	iris_contexte_geographique	text	1	Libellé - programme territoires d'industrie	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
geom_iris	iris_contexte_geographique	GEOMETRY(MultiPolygon, 2154)	0	Géométrie de l'IRIS	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
batiment_groupe_id	rel_batiment_groupe_siren	VARCHAR(22)	1	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
siren	rel_batiment_groupe_siren	varchar(9)	1	Numéro de SIREN d'une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	rel_batiment_groupe_siren	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
s_locaux	rel_batiment_groupe_siren	integer	1	(ffo:slocal) surface totale de local détenue par le propriétaire dans le batiment groupe [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log	rel_batiment_groupe_siren	integer	1	(ffo) Surface totale des pièces d'habitation des locaux possédés par le proprietaire dans le batiment groupe (en m²) (Utilisation de l'attribut dsupdc, nul si npevph nul) [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_locaux_open	rel_batiment_groupe_siren	integer	1	nombre de locaux possédé par le propriétaire dans ce groupe de bâtiment diffusé dans majic personne morale	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
nb_siret_actifs	rel_batiment_groupe_siren	integer	1	Nombre de siret actifs.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
proprietaire	rel_batiment_groupe_siren	bool	1	La personne morale est identifiée comme étant propriétaire d'au moins un local dans le bâtiment. \
(locaux/logements).	maintenu	\N	ayant_droit_ffo	0	0	\N
etablissement	rel_batiment_groupe_siren	bool	1	le bâtiment est identifié comme un des établissement du SIREN	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
dans_majic_pm_ou_etablissement	rel_batiment_groupe_siren	bool	1	identifié comme établissement ou dans majic_pm - permet de filtrer les éléments en open data	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
proprietaire_open	rel_batiment_groupe_siren	bool	1	la personne morale est identifiée comme propriétaire uniquement lorsque l'information de propriété est disponible dans majic personne morale (majic_pm)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
batiment_groupe_id	rel_batiment_groupe_siret	VARCHAR(22)	1	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
siret	rel_batiment_groupe_siret	varchar(14)	1	Siret de l'établissement.	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
siren	rel_batiment_groupe_siret	varchar(9)	1	Numéro de SIREN d'une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
code_departement_insee	rel_batiment_groupe_siret	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
fiabilite_geocodage	rel_batiment_groupe_siret	text	1	fiabilité du géocodage	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
cle_interop_adr	rel_batiment_groupe_siret	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
etat_administratif_actif	rel_batiment_groupe_siret	bool	0	Etat administratif de l'établissement. Si l'établissement\
        est signalé comme actif alors la variable est indiquée comme 'Vrai'.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
siret	siret	TEXT	0	Siret de l'établissement.	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
siren	siret	TEXT	0	Numéro de SIREN d'une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France	maintenu	\N	ayant_droit_bdnb_expert	1	0	\N
nic	siret	TEXT	1	Numéro interne de classement (Nic) de l'établissement siège\
        de l'etablissement.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
code_departement_insee	siret	TEXT	1	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
code_activite_principale	siret	TEXT	1	Code de l'activité principale de l'établissement, lors de\
        son inscription au répertoire APET. Il permet l'identification de la branche\
        d'activité principale pour chaque établissement.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
libelle_activite_principale	siret	TEXT	1	Libellé de l'activité principale de l'établissement, lors\
        de son inscription au répertoire APET.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
activite_registre_metier	siret	TEXT	1	Activité principale de l'établissement au Registre des Métiers.\
        Cette variable, complémentaire à l'activité principale de l'établissement,\
        ne concerne que les établissements relevant de l'artisanat (artisans, artisans-commerçants\
        et sociétés artisanales). Elle caractérise l'activité selon la Nomenclature\
        d'Activités Française de l'Artisanat (NAFA). La variable n'est pas disponible\
        au niveau unité légale.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
denomination_etablissement	siret	TEXT	1	Cette variable désigne le nom sous lequel l'établissement\
        est connu du grand public (nom commercial de l'établissement).	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
date_creation	siret	date	1	La date de création de l'établissement - correspond à la\
        date qui figure dans la déclaration déposée au Centres de Formalités des Entreprises\
        (CFE) compétent.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
date_dernier_traitement	siret	date	1	Date du dernier traitement de l'établissement dans le répertoire Sirene.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etat_administratif_actif	siret	bool	0	Etat administratif de l'établissement. Si l'établissement\
        est signalé comme actif alors la variable est indiquée comme 'Vrai'.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
siege_social	siret	bool	0	Indique si l'etablissement est le siège social	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
siren	siren	text	0	Numéro de SIREN d'une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
siren_dans_sirene	siren	BOOLEAN	1	Le Siren est présent dans la base sirene.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
siren_dans_fichiers_fonciers	siren	BOOLEAN	1	Le siren est présent dans les fichiers fonciers.	maintenu	\N	ayant_droit_ffo	0	0	\N
siren_dans_rpls	siren	BOOLEAN	1	Le siren est présent dans la base du RPLS.	maintenu	\N	ayant_droit_rpls	0	0	\N
cat_org	siren	text	1	Catégorie de l'organisation selon la base RPLS.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
cat_org_simplifie	siren	text	1	catégorie de l'organisation - simplifiée	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
personne_type	siren	text	1	Permet de différencier les personnes physiques des personnes morales.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
date_creation	siren	date	1	La date de création de l'unité légale - correspond à la\
          date qui figure dans la déclaration déposée au Centres de Formalités des Entreprises\
          (CFE) compétent.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
date_dernier_traitement	siren	date	1	Date du dernier traitement de l'unité légale dans le répertoire\
          Sirene.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
etat_administratif_actif	siren	BOOLEAN	0	Etat administratif de l'unité légale (siren). Si l'unité\
          légale est signalé comme active alors la variable est indiquée comme 'Vrai'.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
bailleur_social	siren	BOOLEAN	0	La sirène a été reconnue comme étant celui d'un organisme de logement social.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
type_numero_dau	sitadel	varchar(15)	0	Concatenation du type de demande d'autorisation d'urbanisme (DAU) et le numéro de DAU.\
Combinaisons possibles : \
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro \
  DAU` ou `DP + numéro DAU`\
- permis de démolir (PD) > `PD + numéro DAU`\
- permis d'aménager (PA) > `PA + numéro DAU`	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	sitadel	TEXT	1	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95","971","972","973","974","976"}
code_commune_insee	sitadel	varchar(5)	0	Code INSEE de la commune	maintenu	\N	open_data_lo	1	0	\N
creation_local	sitadel	BOOLEAN	1	Demande d'autorisation d'urbanisme spécifique pour la création de locaux.	maintenu	\N	open_data_lo	0	0	\N
creation_logement	sitadel	BOOLEAN	1	Demande d'autorisation d'urbanisme spécifique pour la création de logements.	maintenu	\N	open_data_lo	0	0	\N
permis_demolir	sitadel	BOOLEAN	1	Demande d'autorisation d'urbanisme spécifique pour réaliser une démolition.	maintenu	\N	open_data_lo	0	0	\N
permis_amenager	sitadel	BOOLEAN	1	Demande d'autorisation d'urbanisme spécifique pour réaliser un aménagement.	maintenu	\N	open_data_lo	0	0	\N
etat_avancement_projet	sitadel	text	1	Etat d'avancement du projet (Autorisé, Commencé, Terminé). Les projets annulés ne sont pas contenus dans cette \
compilation.	maintenu	\N	open_data_lo	0	0	{"Terminé","Autorisé","Commencé"}
date_reelle_autorisation	sitadel	date	1	Date réelle d'autorisation (Permis de Construire) ou de non-opposition (Déclaration Préalable) initiale. Date de décision relative à la demande initiale, sans prise en compte d'éventuels modificatifs.	maintenu	\N	open_data_lo	0	0	\N
date_reelle_ouverture_chantier	sitadel	date	1	Date réelle d'ouverture de chantier.	maintenu	\N	open_data_lo	0	0	\N
date_reelle_achevement_travaux	sitadel	date	1	Date réelle d'achèvement des travaux.	maintenu	\N	open_data_lo	0	0	\N
annee_depot_dau	sitadel	INT	1	Année de dépôt de la demande d'autorisation d'urbanisme.	maintenu	\N	open_data_lo	0	0	\N
dpc_derniere_maj	sitadel	date	1	Date (mois) de prise en compte (DPC) de dernière mise à jour des données.	maintenu	\N	open_data_lo	0	0	\N
code_activite_principale_demandeur	sitadel	text	1	Code d'activité principale de l'établissement d'un demandeur (maître d'ouvrage) avéré en tant que personne morale - Nomenclature Naf Rév2	maintenu	\N	open_data_lo	0	0	\N
categorie_juridique_demandeur	sitadel	text	1	Catégorie juridique d'un demandeur (maître d'ouvrage) avéré en tant que personne morale - Nomenclature Sirène.	maintenu	\N	open_data_lo	0	0	\N
denomination_demandeur	sitadel	text	1	Dénomination d'un demandeur (maître d'ouvrage) avéré en tant que personne morale.	maintenu	\N	open_data_lo	0	0	\N
siren_demandeur	sitadel	text	1	Numéro SIREN d'un demandeur (maître d'ouvrage) avéré en tant que personne morale.	maintenu	\N	open_data_lo	0	0	\N
siret_demandeur	sitadel	text	1	Numéro SIRET d'un demandeur (maître d'ouvrage) avéré en tant que personne morale.	maintenu	\N	open_data_lo	0	0	\N
superficie_terrain	sitadel	numeric(17,3)	1	Superficie du terrain.	maintenu	\N	open_data_lo	0	0	\N
nature_projet	sitadel	text	1	Nature de projet détaillée : \
- nouvelle construction, \
- travaux sur construction existante\
    * transformation sans extension ni diminution de surface (inclut les changements de destination, réhabilitations, scissions/regroupements de logements ...), \
    * transformation avec extension de surface, \
    * transformation avec diminution de surface, \
    * extension de surface sans transformation, \
    * diminution de surface sans transformation\
N.B. Il s'agit du projet complété ou par défaut du projet déclaré	maintenu	\N	open_data_lo	0	0	{"transformation sans extension ni diminution de surface (inclut les changements de destination, réhabilitations, scissions/regroupements de logements ...)","transformation avec diminution de surface","nouvelle construction","travaux sur construction existante","transformation avec extension de surface","diminution de surface sans transformation","extension de surface sans transformation"}
destination_principale	sitadel	text	1	Destination principale des surfaces créées : \
- résidentiel, \
- non résidentiel\
  * hébergement hôtelier, \
  * bureaux, \
  * commerce,\
  * artisanat, \
  * industrie, \
  * agriculture, \
  * entrepôt, \
  * service public ou d'intérêt collectif\
N.B. Quand le détail du non résidentiel n'est pas donnée, seulement est indiqué 'non résidentiel', sinon, les \
    catégories sont détaillées.	maintenu	\N	open_data_lo	0	0	\N
type_princip_logts_crees	sitadel	text	1	Type principal des logements créés :\
- un logement individuel,\
- plusieurs logements individuels,\
- collectif hors résidence,\
- résidence\
N.B. Type principal selon le nombre de logements créés : il peut donc y avoir des logements individuels dans un permis de type "collectif hors résidences"	maintenu	\N	open_data_lo	0	0	{"plusieurs logements individuels","un logement individuel","résidence","collectif hors résidence"}
nb_log_demolis	sitadel	INT	1	Nombre de logements démolis.\
N.B. Insuffisamment renseigné.	maintenu	\N	open_data_lo	0	0	\N
s_hab_avant	sitadel	numeric(17,3)	1	Surface de plancher de la destination ' Habitation ' existante avant travaux	maintenu	\N	open_data_lo	0	0	\N
parcelle_id	parcelle_sitadel	varchar(14)	0	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	open_data_lo	1	1	\N
type_transfo_principal	sitadel	text	1	Type principal de transformation :\
- transformation de locaux en logements (changement de destination), \
- transformation de logements (réhabilitation, scission, regroupement ...), \
- transformation de logements en locaux non résidentiels (changement de destination), \
- transformation de locaux non résidentiels (changement de destination, réhabilitation, scission, regroupement ...)	maintenu	\N	open_data_lo	0	0	{"transformation de locaux non résidentiels (changement de destination, réhabilitation, scission, regroupement ...)","transformation de logements (réhabilitation, scission, regroupement ...)","transformation de locaux en logements (changement de destination)","transformation de logements en locaux non résidentiels (changement de destination)"}
type_princip_locaux_transformes	sitadel	text	1	Type principal des locaux d'origine transformés :\
- résidentiel, \
- non résidentiel, \
  * hébergement hôtelier, \
  * bureaux, \
  * commerce, \
  * artisanat, \
  * industrie, \
  * agriculture, \
  * entrepôt, \
  * service public ou d'intérêt collectif\
N.B. Quand le détail du non résidentiel n'est pas donnée, seulement est indiqué 'non résidentiel', sinon, les catégories sont détaillées.	maintenu	\N	open_data_lo	0	0	\N
indicateur_extension	sitadel	BOOLEAN	1	Indicateur pour la présence d'une extension.	maintenu	\N	open_data_lo	0	0	\N
indicateur_surelevation_ou_nivsupp	sitadel	BOOLEAN	1	Indicateur pour la présence d'une surélévation ou d'un niveau supérieur.	maintenu	\N	open_data_lo	0	0	\N
residence_princip_ou_second	sitadel	TEXT	1	Type d'habitation principale ou secondaire. Valable que si occupation personnelle :\
- résidence principale\
- résidence secondaire	maintenu	\N	open_data_lo	0	0	{"résidence secondaire","résidence principale"}
type_annexe	sitadel	text	1	Type d'annexe\
- Piscine, \
- Garage, \
- Véranda, \
- Abri de Jardin, \
- Autre annexe, \
- plusieurs annexes,\
- pas d’annexe	maintenu	\N	open_data_lo	0	0	{"Autre annexe","Garage","Véranda","pas d’annexe","Piscine","plusieurs annexes","Abri de Jardin"}
residence	sitadel	text	1	Type de résidence \
- res pour personnes âgées, \
- res étudiantes, \
- res de tourisme,\
- res hôtelière à vocation sociale,\
- res sociale, \
- res pour handicapés, \
- autre res, \
- projet mixte, \
N.B.: Pour les projets mixtes (logements ordinaires / résidence), traitement interne Sitadel pour ce que cette \
catégorie ne soit définie que si la résidence représente la majorité des logements du projet.	maintenu	\N	open_data_lo	0	0	{"res pour personnes âgées","res étudiantes","res de tourisme","res hôtelière à vocation sociale","res sociale","res pour handicapés","autre résidence","projet mixte"}
nb_log_tot_crees	sitadel	INT	1	Nombre total de logements créés.\
N.B.: Une transformation d'un 3 pièces en 2 studios est généralement considérée comme créant 2 logements.	maintenu	\N	open_data_lo	0	0	\N
nb_log_individuels_crees	sitadel	INT	1	Nombre de logements individuels créés.\
N.B.: Une maison individuelle peut comporter 2 logements individuels (au maximum).	maintenu	\N	open_data_lo	0	0	\N
nb_log_collectifs_crees	sitadel	INT	1	Nombre de logements collectifs créés.\
N.B.: Les logements collectifs font partie d’un bâtiment dans lequel sont superposés plus de deux logements distincts \
dont l'accès nécessite d'emprunter des parties communes.	maintenu	\N	open_data_lo	0	0	\N
s_hab_creee	sitadel	numeric(17,3)	1	Surface de plancher de la destination ' Habitation ' nouvelle construite.\
N.B.: Lorsque le projet crée des chambres (sans coin cuisine indépendant) et non des logements, on utilise plutôt la \
destination "Hébergement hôtelier" ou "Service Public" dans Sitadel plutôt que la destination "Habitation".	maintenu	\N	open_data_lo	0	0	\N
s_hab_issue_transfo	sitadel	numeric(17,3)	1	Surface de plancher de la destination ' Habitation ' issue d'une transformation (changement de destination, \
réhabilitation, scission, regroupement …).\
N.B.: Surface issue d'un changement de destination ou d'un mouvement interne (cas où les surfaces supprimée et créée \
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).	maintenu	\N	open_data_lo	0	0	\N
s_hab_demolie	sitadel	numeric(17,3)	1	Surface de plancher de la destination ' Habitation ' supprimée (démolie)	maintenu	\N	open_data_lo	0	0	\N
s_hab_transformee	sitadel	numeric(17,3)	1	Surface de plancher de la destination ' Habitation ' transformée (changement de destination, réhabilitation, \
scission, regroupement ...).\
N.B.: Surface issue d'un changement de destination ou d'un mouvement interne (cas où les surfaces supprimée et créée \
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).	maintenu	\N	open_data_lo	0	0	\N
s_loc_avant	sitadel	numeric(17,3)	1	Surface de plancher de locaux non résidentiels existante avant travaux.\
Total des surfaces des destinations autres que d'habitation.	maintenu	\N	open_data_lo	0	0	\N
s_loc_creee	sitadel	numeric(17,3)	1	Surface de plancher de locaux non résidentiels nouvelle construite.\
Total des surfaces des destinations autres que d'habitation.	maintenu	\N	open_data_lo	0	0	\N
s_loc_issue_transfo	sitadel	numeric(17,3)	1	Surface de plancher de locaux non résidentiels issue d'une transformation (changement \
de destination, réhabilitation, scission, regroupement …).\
Total des surfaces des destinations autres que d'habitation.	maintenu	\N	open_data_lo	0	0	\N
s_loc_demolie	sitadel	numeric(17,3)	1	Surface de plancher de locaux non résidentiels démolie.\
Total des surfaces des destinations autres que d'habitation	maintenu	\N	open_data_lo	0	0	\N
s_loc_transformee	sitadel	numeric(17,3)	1	Surface de plancher de locaux non résidentiels transformée (changement de destination,\
réhabilitation, scission, regroupement ...).\
Total des surfaces des destinations autres que d'habitation.	maintenu	\N	open_data_lo	0	0	\N
type_service_public	sitadel	text	1	Type de service public ou d'intérêt collectif : \
- Transport, \
- Enseignement et recherche, \
- Santé, \
- Action sociale, \
- Ouvrage spécial, \
- Culture et loisir, \
- Plusieurs types renseignés	maintenu	\N	open_data_lo	0	0	{"Transport","Enseignement et recherche","Santé","Action sociale","Ouvrage spécial","Culture et loisir","Plusieurs types renseignés"}
surface_locaux_transformee_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher - de locaux non résidentiels - transformée (changement de destination, réhabilitation, \
scission, regroupement ...) - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
code_departement_insee	parcelle_sitadel	TEXT	1	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
nombre_dau	parcelle_sitadel	integer	1	(Sitadel) Nombre de demandes d'autorisation d'urbanisme (DAU).	maintenu	\N	open_data_lo	0	0	\N
annee_premiere_dau_identifiee	parcelle_sitadel	INT	1	(Sitadel) Année de la première DAU identifiée dans le millésime de Sitadel utilisé.	maintenu	\N	open_data_lo	0	0	\N
annee_derniere_dau_identifiee	parcelle_sitadel	INT	1	(Sitadel) Année de la dernière DAU identifiée dans le millésime de Sitadel utilisé.	maintenu	\N	open_data_lo	0	0	\N
nouvelle_construction	parcelle_sitadel	text	1	Nouveau bâtiment sur parcelle. \
Peut prendre les valuers : 'nouveau bâtiment exclusif' ou 'nouveau bâtiment ajouté'\
- nouveau bâtiment exclusif : soit une construction entièrement neuve sur une parcelle vierge, soit un bâtiment qui remplace entièrement une structure préexistante.\
- nouveau bâtiment ajouté : nouveau bâtiment sur parcelle sur laquelle existe déjà un ou plusieurs bâtiments.	maintenu	\N	open_data_lo	0	0	{"nouveau bâtiment exclusif","nouveau bâtiment additionnel"}
travaux_sur_construction_existante	parcelle_sitadel	BOOLEAN	1	(Sitadel) Vrai si les permis déclarent des travaux sur construction existante.	maintenu	\N	open_data_lo	0	0	\N
demolition	parcelle_sitadel	BOOLEAN	1	(Sitadel) Démolition déclarée par DAU égale à permis de démolir ou surface démolie déclarée dans les permis de \
création de surfaces.	maintenu	\N	open_data_lo	0	0	\N
amenagement	parcelle_sitadel	BOOLEAN	1	Demande d'autorisation d'urbanisme spécifique pour réaliser un aménagement.	maintenu	\N	open_data_lo	0	0	\N
bdnb_obsolete	parcelle_sitadel	BOOLEAN	1	(Sitadel) Les informations contenues dans la BDNB pour ce groupe de bâtiments sont considérées comme potentiellement obsolètes (année de construction, surfaces, emprise au sol, etc.), car elles se réfèrent à une période antérieure à celle des autorisations de création de surfaces.	maintenu	\N	open_data_lo	0	0	\N
annee_construction_obsolete	parcelle_sitadel	BOOLEAN	1	(Sitadel) Année de construction enregistrée antérieure à celle déclarée dans la dernière DAU connue dans Sitadel pour cette parcelle.	maintenu	\N	open_data_lo	0	0	\N
service_public_identifie	parcelle_sitadel	BOOLEAN	1	(Sitadel) Travaux déclarés par les autorisations avec un ou l'un des usages de type service public.	maintenu	\N	open_data_lo	0	0	\N
indicateur_extension	parcelle_sitadel	BOOLEAN	1	Indicateur pour la présence d'une extension.	maintenu	\N	open_data_lo	0	0	\N
indicateur_surelevation_ou_nivsupp	parcelle_sitadel	BOOLEAN	1	Indicateur pour la présence d'une surélévation.	maintenu	\N	open_data_lo	0	0	\N
indicateur_piscine	parcelle_sitadel	BOOLEAN	1	Indicateur pour la présence d'une piscine.	maintenu	\N	open_data_lo	0	0	\N
indicateur_garage	parcelle_sitadel	BOOLEAN	1	Indicateur pour la présence d'un garage.	maintenu	\N	open_data_lo	0	0	\N
nombre_logemens_totaux_crees	parcelle_sitadel	INT	1	Nombre total de logements créés sur la parcelle. Cela inclus les logements à usage individuel, collectif et les logements en résidences.	maintenu	\N	open_data_lo	0	0	\N
nombre_logement_demolis	parcelle_sitadel	INT	1	Nombre de logements démolis sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_cree	parcelle_sitadel	NUMERIC(17,3)	1	Surface habitable créée sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_issue_transformation	parcelle_sitadel	NUMERIC(17,3)	1	Surface habitable issue d'une transformation sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_transformee	parcelle_sitadel	NUMERIC(17,3)	1	Surface habitable transformée sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_demolie	parcelle_sitadel	NUMERIC(17,3)	1	Surface habitable démolie sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_cree	parcelle_sitadel	NUMERIC(17,3)	1	Surface des locaux créés sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_issue_transformee	parcelle_sitadel	NUMERIC(17,3)	1	Surface des locaux issus d'une transformation sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_transformee	parcelle_sitadel	NUMERIC(17,3)	1	Surface des locaux transformée sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_demolie	parcelle_sitadel	NUMERIC(17,3)	1	Surface des locaux démolie sur la parcelle.	maintenu	\N	open_data_lo	0	0	\N
nature_derniere_dau	parcelle_sitadel	TEXT	1	(Sitadel) Nature du dernier permis autorisé.	maintenu	\N	open_data_lo	0	0	\N
nombre_logements_creees_derniere_dau	parcelle_sitadel	INT	1	(Sitadel) Nombre de logements créés (individuels, collectifs et des résidences) - déclaré dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
nombre_logements_demolis_derniere_dau	parcelle_sitadel	INT	1	(Sitadel) Nombre de logements démolis - déclaré dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_creee_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface habitable créée - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_creee_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface créée pour les planchers de locaux non résidentiels - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_issue_transfo_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher de la destination ' Habitation ' issue d'une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_issue_transfo_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher des locaux non-résidentiels issue d'une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_transformee_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher de la destination ' Habitation ' transformée (changement de destination, réhabilitation, scission, regroupement ...) - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_habitable_demolie_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher de la destination ' Habitation ' supprimée (démolie) - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
surface_locaux_demolie_derniere_dau	parcelle_sitadel	NUMERIC(17,3)	1	(Sitadel) Surface de plancher de locaux non résidentiels démolie - déclarée dans la dernière DAU.	maintenu	\N	open_data_lo	0	0	\N
type_numero_dau	rel_parcelle_sitadel	varchar(15)	0	Concatenation du type de demande d'autorisation d'urbanisme (DAU) et le numéro de DAU.\
Combinaisons possibles : \
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro \
  DAU` ou `DP + numéro DAU`\
- permis de démolir (PD) > `PD + numéro DAU`\
- permis d'aménager (PA) > `PA + numéro DAU`	maintenu	\N	open_data_lo	1	1	\N
parcelle_id	rel_parcelle_sitadel	varchar(14)	0	(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_parcelle_sitadel	varchar(2)	1	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
dau_monoparcelle	rel_parcelle_sitadel	BOOLEAN	1	Indique si la demande d'autorisation d'urbanisme (DAU) ne concerne qu'une unique parcelle.	maintenu	\N	open_data_lo	0	0	\N
type_appariement	rel_parcelle_sitadel	text	1	Type de croisement final. Prend les valeurs 'parcelle', 'adresse', 'parcelle + adresse' ou 'non apparie'.	maintenu	\N	open_data_lo	0	0	{"parcelle","adresse","parcelle + adresse"}
fiabilite_appariement	rel_parcelle_sitadel	text	1	Fiabilité du croisement des données d'autorisation d'urbanisme SITADEL avec la BDNB, prend les valeurs - 'très \
fiable' ou 'fiable'.	maintenu	\N	open_data_lo	0	0	{"très fiable","fiable"}
batiment_groupe_id	batiment_groupe_simulations_isb	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	expérimental	\N	ayant_droit_bdnb_expert	1	1	\N
code_departement_insee	batiment_groupe_simulations_isb	VARCHAR(2)	0	Code département INSEE	expérimental	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
mixite_usage_residentiel_tertiaire	batiment_groupe_synthese_propriete_usage	BOOLEAN	1	Indicateur binaire de la présence d'une mixité d'usage dans le bâtiment, spécifiquement entre les usages résidentiel et tertiaire.	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_contrainte_opportunite_renovation	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_bdnb_expert	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
dh_moyen_2003_maison_ou_collectif_dernier_etage	batiment_groupe_simulations_isb	INT	1	Valeur moyenne du DH pour ce logement, calculé à partir du climat réglementaire actuel, RE2020 (qui prend en compte la canicule de 2003). Le logement correspond soit à une maison individuelle, soit, dans le cas d'un bâtiment résdientiel collectif, d'un logement représentatif du bâtiment au dernier étage (c-a-d, avec l'influence de la toiture). La valeur moyenne est obtenue à partir d'un grand nombre de simulations de ce logement. Plus le DH est élevé, plus le risque d'inconfort en été est fort. Plus le DH est faible, plus le risque d'inconfort en été est faible.	expérimental	\N	ayant_droit_bdnb_expert	0	0	\N
classe_plus_probable_dh_2003_maison_ou_collectif_dernier_etage	batiment_groupe_simulations_isb	TEXT	1	La classe de DH la plus probable pour ce logement. Les classes de surchauffe ont été créées afin de faciliter la comparaison au sein du parc de bâtiments. Le logement correspond soit à une maison individuelle, soit, dans le cas d'un bâtiment résdientiel collectif, d'un logement représentatif du bâtiment au dernier étage (c-a-d, avec l'influence de la toiture). La classe la plus probable est obtenue à partir d'un grand nombre de simulations de ce logement. Plus la classe de DH est élevé, plus le risque d'inconfort en été est fort. Plus la classe de DH est faible, plus le risque d'inconfort en été est faible.	expérimental	\N	ayant_droit_bdnb_expert	0	0	{"classe_1","classe_2","classe_3","classe_4","classe_5","classe_6","classe_7","classe_8","classe_9","classe_10"}
fiabilite_dh_2003_maison_ou_collectif_dernier_etage	batiment_groupe_simulations_isb	TEXT	1	Fiabilité des résultats pour ce logement. Les résultats étant issues de simulations, un degré de fiabilité peut être estimé. Un degré de fiabilité élevé ne présume pas d'un résultat sans erreur. Le logement correspond soit à une maison individuelle, soit, dans le cas d'un bâtiment résdientiel collectif, d'un logement représentatif du bâtiment au dernier étage (c-a-d, avec l'influence de la toiture).	expérimental	\N	ayant_droit_bdnb_expert	0	0	{"pas fiable","peu fiable","moyennement fiable","fiable","très fiable","inconnue"}
emission_ges_dpe_tertiaire_m2	batiment_groupe_dpe_tertiaire	numeric	1	emission GES du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	kgCO2/m²/an	open_data_lo	0	0	\N
fiabilite_geocodage	rel_batiment_groupe_dpe_tertiaire	text	1	fiabilité du géocodage	maintenu	\N	open_data_lo	0	0	\N
dh_moyen_2003_collectif_etage_courant	batiment_groupe_simulations_isb	INT	1	Valeur moyenne du DH pour ce logement, calculé à partir du climat réglementaire actuel, RE2020 (qui prend en compte la canicule de 2003). Cette donnée n'est disponible que pour les bâtiments correspondant à du résidentiel collectif et où des logements sont présents sur plusieurs étages. Le logement correspond à un logement représentatif du bâtiment en étage courant (c-a-d, sans l'influence de la toiture). La valeur moyenne est obtenue à partir d'un grand nombre de simulations de ce logement. Plus le DH est élevé, plus le risque d'inconfort en été est fort. Plus le DH est faible, plus le risque d'inconfort en été est faible.	expérimental	\N	ayant_droit_bdnb_expert	0	0	\N
classe_famille_incendie_residentiel	batiment_groupe_risques	TEXT	1	(bdnb) Famille de risque incendie. Les bâtiments à usage résidentiel sont classés en différentes catégories, selon la réglementation en vigueur au 01/01/2024.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"values"}
classe_plus_probable_dh_2003_collectif_etage_courant	batiment_groupe_simulations_isb	TEXT	1	La classe de DH la plus probable pour ce logement. Les classes de surchauffe ont été créées afin de faciliter la comparaison au sein du parc de bâtiments. Cette donnée n'est disponible que pour les bâtiments correspondant à du résidentiel collectif et où des logements sont présents sur plusieurs étages. Le logement correspond à un logement représentatif du bâtiment en étage courant (c-a-d, sans l'influence de la toiture). La classe la plus probable est obtenue à partir d'un grand nombre de simulations de ce logement. Plus la classe de DH est élevé, plus le risque d'inconfort en été est fort. Plus la classe de DH est faible, plus le risque d'inconfort en été est faible.	expérimental	\N	ayant_droit_bdnb_expert	0	0	{"classe_1","classe_2","classe_3","classe_4","classe_5","classe_6","classe_7","classe_8","classe_9","classe_10"}
fiabilite_dh_2003_collectif_etage_courant	batiment_groupe_simulations_isb	TEXT	1	Fiabilité des résultats pour ce logement. Les résultats étant issues de simulations, un degré de fiabilité peut être estimé. Un degré de fiabilité élevé ne présume pas d'un résultat sans erreur. Cette donnée n'est disponible que pour les bâtiments correspondant à du résidentiel collectif et où des logements sont présents sur plusieurs étages. Le logement correspond à un logement représentatif du bâtiment en étage courant (c-a-d, sans l'influence de la toiture).	expérimental	\N	ayant_droit_bdnb_expert	0	0	{"pas fiable","peu fiable","moyennement fiable","fiable","très fiable","inconnue"}
batiment_groupe_id	batiment_groupe_synthese_propriete_usage	varchar(22)	1	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	batiment_groupe_synthese_propriete_usage	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
usage_principal_bdnb_open	batiment_groupe_synthese_propriete_usage	text	0	Indicateur d'usage principal du bâtiment. Cet indicateur est une évolution de la variable d'usage usage_niveau_1_txt (Fichiers Fonciers) qui est corrigée notamment sur les bâtiments publics qui sont affectés en usage tertiaire. \
Valeurs possibles :\
- Résidentiel individuel\
- Résidentiel collectif\
- Tertiaire\
- Secondaire\
- Dépendance\
- Indifférencié	maintenu	\N	open_data_lo	0	0	{"Résidentiel individuel","Résidentiel collectif","Tertiaire","Secondaire","Primaire","Dépendance","Indifférencié"}
usage_niveau_2_bdnb	batiment_groupe_synthese_propriete_usage	varchar	0	Usage de deuxième niveau\
Valeurs possibles :\
- 'administration',\
- 'agriculture, sylviculture et pêche',\
- 'armée',\
- 'bureau',\
- 'cave / grenier / remise',\
- 'commerce',\
- 'culte',\
- 'culture',\
- 'dépendance diverse',\
- 'énergie',\
- 'enseignement indifférencié',\
- 'enseignement primaire et secondaire',\
- 'entrepôt et logistique',\
- 'forces de l''ordre et sécurité civile',\
- 'garage / parking / box',\
- 'hébergement et restauration',\
- 'indifférencié',\
- 'industrie',\
- 'information et communication',\
- 'justice',\
- 'loisirs',\
- 'loisirs détente',\
- 'monument',\
- 'primaire indifférencié',\
- 'recherche et enseignement supérieur',\
- 'résidentiel collectif',\
- 'résidentiel indifférencié',\
- 'résidentiel individuel',\
- 'santé et social',\
- 'secondaire indifférencié',\
- 'service pour l''emploi et la formation',\
- 'service urbain',\
- 'services',\
- 'sport',\
- 'tertiaire indifférencié',\
- 'transport'	maintenu	\N	ayant_droit_ffo	0	0	{"administration","agriculture, sylviculture et pêche","armée","bureau","cave / grenier / remise","commerce","culte","culture","dépendance diverse","énergie","enseignement indifférencié","enseignement petite enfance","enseignement primaire et secondaire","entrepôt et logistique","forces de l'ordre et sécurité civile","garage / parking / box","hébergement et restauration","industrie","information et communication","justice","loisirs","loisirs détente","monument","recherche et enseignement supérieur","résidentiel collectif","résidentiel individuel","santé et social","service pour l'emploi et la formation","service urbain","sport","tertiaire indifférencié","transport","parking"}
usage_niveau_3_bdnb	batiment_groupe_synthese_propriete_usage	varchar	0	Usage de troisième niveau\
Valeurs possibles :\
- 'abbaye',\
- 'administration indifférenciée',\
- 'agriculture, sylviculture et pêche indifférenciée',\
- 'aire de repos, service ou triage', \
- 'artisanat',\
- 'autre service de l''enseignement supérieur et de la recherche',\
- 'autre service de l''éducation',\
- 'autre service des forces de l''ordre',\
- 'autre service judiciaire',\
- 'autre service médico-social',\
- 'autre établissement et service à caractère sanitaire',\
- 'basilique', \
- 'bibliothèque et médiathèque',\
- 'box',\
- 'buanderie',\
- 'bureau indifférencié',\
- 'bûcher',\
- 'cathédrale',\
- 'cave',\
- 'cellier',\
- 'centre de formation',\
- 'chapelle',\
- 'commerce indifférencié',\
- 'couvent',\
- 'culte indifférencié',\
- 'culture indifférenciée',\
- 'dépendance de local commun',\
- 'dépôt d''archives',\
- 'elément de pur agrément',\
- 'énergie indifférenciée',\
- 'enseignement du premier degré',\
- 'enseignement du second degré - premier cycle',\
- 'enseignement du second degré - second cycle',\
- 'enseignement indifférencié',\
- 'enseignement primaire et secondaire indifférencié',\
- 'enseignement primaire indifférencié',\
- 'enseignement secondaire indifférencié',\
- 'entreposage et services auxiliaires des transports',\
- 'entrepôsage et logistique indifférencié',\
- 'espace loisirs indifférencié',\
- 'espace sportif indifférencié',\
- 'espaces naturels et animaliers',\
- 'forces armées',\
- 'garage',\
- 'gendarmerie',\
- 'gestion de l''eau',\
- 'gestion des déchets',\
- 'gestion espaces naturels et animaliers',\
- 'gestion patrimoine historique',\
- 'grenier',\
- 'hébergement',\
- 'hébergement avec restauration',\
- 'hébergement et restauration indifférenciés',\
- 'hébergement sans restauration',\
- 'indifférencié',\
- 'industrie extractive',\
- 'industrie indifférenciée',\
- 'industrie manufacturière',\
- 'information et communication indifférenciée',\
- 'jardin d’hiver',\
- 'jeux d''hasard et argent',\
- 'justice indifférenciée',\
- 'logistique',\
- 'magasin de centre commercial',\
- 'magasin grande surface',\
- 'magasin très grande surface',\
- 'mairie',\
- 'maison individuelle',\
- 'maisons groupées',\
- 'marché',\
- 'monastère',\
- 'monument indifférencié',\
- 'mosquée',\
- 'musée et centre culturel',\
- 'parc d''attractions',\
- 'parking',\
- 'piscine',\
- 'pièce indépendante',\
- 'police',\
- 'presbytère',\
- 'production et stockage d''énergie',\
- 'recherche et enseignement supérieur indifférencié',\
- 'remise',\
- 'restauration',\
- 'résidentiel collectif',\
- 'résidentiel indifférencié',\
- 'salle de spectacles',\
- 'santé et social indifférencié',\
- 'sapeurs-pompiers',\
- 'secondaire indifférencié',\
- 'serre',\
- 'service administratif',\
- 'service administratif des forces armées',\
- 'service administratif du domaine de l''emploi et de la formation',\
- 'service administratif du domaine de l''éducation et de la recherche',\
- 'service administratif du domaine des forces de l''ordre et de la sécurité civile',\
- 'service administratif du domaine fiscal',\
- 'service administratif du domaine judiciaire',\
- 'service administratif du domaine médico-social',\
- 'service administratif du domaine économique',\
- 'service d''accueil des usagers',\
- 'service d''administration local',\
- 'service d''aide pour l''emploi',\
- 'service hospitalier',\
- 'service judiciaire et d''accueil du public',\
- 'services indifférencié',\
- 'station service',\
- 'synagogue',\
- 'temple',\
- 'terrasse',\
- 'tertiaire indifférencié',\
- 'théâtre',\
- 'transformateur',\
- 'transport aérien',\
- 'transport férroviaire',\
- 'transport indifférencié',\
- 'transport par conduites',\
- 'transport par eau',\
- 'transport terrestre',\
- 'tribunal',\
- 'télécommunication',\
- 'usine de génération d''énergie',\
- 'éducation et formation à usage culturel',\
- 'église',\
- 'énergie indifférenciée',\
- 'établissement et service de santé',\
- 'établissement industriel',\
- 'établissement médico-social pour personnes agées',\
- 'établissement médico-social pour personnes handicapées',\
- 'établissement pénitentiaire',\
- 'établissements pour la construction et le génie civil'	maintenu	\N	ayant_droit_ffo	0	0	{"usine de génération d'énergie","énergie indifférenciée","transformateur","industrie extractive","industrie manufacturière","industrie indifférenciée","secondaire indifférencié","service hospitalier","établissement pénitentiaire","enseignement du second degré - second cycle","recherche et enseignement supérieur","cathédrale","parc d'attractions","tribunal","enseignement du second degré - premier cycle","basilique","abbaye","bassin de natation","sport de glace","monastère","couvent","presbytère","enseignement du premier degré","enseignement pré-primaire","enseignement primaire indifférencié","enseignement secondaire indifférencié","enseignement primaire et secondaire indifférencié","mairie","établissement et service de santé","recherche et enseignement supérieur indifférencié","mosquée","église","temple","synagogue","transport aérien","établissement médico-social pour personnes agées","établissement médico-social pour personnes handicapées","gendarmerie","forces armées","police","sapeurs-pompiers","théâtre","musée et centre culturel","salle de spectacles","bibliothèque et médiathèque","salle multisports","autre service des forces de l'ordre","espace sportif indifférencié","salle ou terrain non spécialisée","transport férroviaire","transport par conduites","gestion de l'eau","gestion des déchets","production et stockage d'énergie","transport par eau","autre établissement et service à caractère sanitaire","hébergement médico-social","service administratif du domaine de l'éducation et de la recherche","service administratif du domaine judiciaire","service administratif du domaine médico-social","service administratif du domaine des forces de l'ordre et de la sécurité civile","service administratif du domaine fiscal","service administratif du domaine économique","service administratif du domaine des sports","service administratif du domaine des transports","service administratif du domaine de l'emploi et de la formation","administration indifférenciée","bureau indifférencié","magasin très grande surface","hébergement avec restauration","magasin grande surface","hébergement","crèche","service administratif des forces armées","service administratif","jeux d'hasard et argent","service judiciaire et d'accueil du public","service d'administration local","autre service de l'enseignement supérieur et de la recherche","magasin de centre commercial","salle ou terrain spécialisé","hébergement et restauration indifférenciés","restauration","artisanat","hébergement sans restauration","station service","commerce indifférencié","espace loisirs indifférencié","justice indifférenciée","autre service judiciaire","santé et social indifférencié","enseignement indifférencié","centre de formation","information et communication indifférenciée","établissements pour la construction et le génie civil","entrepôsage et logistique indifférencié","monument indifférencié","logistique","service d'aide pour l'emploi","services indifférencié","entreposage et services auxiliaires des transports","service d'accueil des usagers","marché","télécommunication","éducation et formation à usage culturel","culture indifférenciée","culte indifférencié","autre service de l'éducation","transport indifférencié","gestion patrimoine historique","gestion espaces naturels et animaliers","chapelle","dépôt d'archives","transport terrestre","aire de repos, service ou triage","espaces naturels et animaliers","tertiaire indifférencié","agriculture, sylviculture et pêche indifférenciée","résidentiel collectif","maison individuelle","maisons groupées","parking","garage","box","piscine","pièce indépendante","elément de pur agrément","terrasse","serre","jardin d’hiver","buanderie","cellier","dépendance de local commun","remise","cave","grenier","bûcher","indifférencié","antenne téléphone","voies et éléments construits sur autoroute","appareil à gaz","usine","hôtel","parking à ciel ouvert","parking couvert","centre de rééducation,thalassothérapie,thermaux"}
categorie_usage_propriete	batiment_groupe_synthese_propriete_usage	text	0	Catégorie d'usage et de propriété du bâtiment. Cet indicateur couple les catégories d'usages à la typologie de propriétaire du bâtiment pour produire une segmentation du parc utilisé dans de nombreux cas d'usages. \
Valeurs possibles :\
- Résidentiel individuel social\
- Résidentiel individuel indifférencié\
- Résidentiel collectif social\
- Résidentiel collectif copropriété\
- Résidentiel collectif indifférencié\
- Tertiaire public indifférencié\
- Tertiaire indifférencié\
- Secondaire indifférencié\
- Dépendance indifférenciée\
- Indifférencié	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"Dépendance indifférenciée","Secondaire indifférencié","Primaire indifférencié","Indifférencié","Résidentiel collectif social","Résidentiel collectif copropriété","Résidentiel collectif indifférencié","Résidentiel individuel indifférencié","Résidentiel individuel privé","Résidentiel individuel social","Tertiaire indifférencié","Tertiaire privé","Tertiaire public"}
presence_logement_social	batiment_groupe_synthese_propriete_usage	boolean	1	Présence de logements sociaux dans le bâtiment.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
batiment_groupe_id	batiment_groupe_risques	VARCHAR(22)	1	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	à_completer	open_data_lo	1	1	\N
periode_construction_dpe	batiment_groupe_dpe_tertiaire	text	1	période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.	maintenu	\N	open_data_lo	0	0	{"1983-1988","2013-2021","1989-2000","1978-1982","2006-2012","après 2021","avant 1948","1948-1974","1975-1977","2001-2005"}
s_loc_dep	rel_batiment_groupe_usage	int	1	Somme des surfaces de locaux de type `dépendance` liées à l'usage bâtiment [m²]	maintenu	\N	ayant_droit_ffo	0	0	\N
s_log	rel_batiment_groupe_usage	int	1	Surface totale des pièces d'habitation (en m²) - de cet usage du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_risques	VARCHAR(2)	0	Code département INSEE	maintenu	à_completer	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
alea_argile	batiment_groupe_risques	TEXT	1	(georisque) Indicateur d'aléa retrait-gonflement des argiles. Cet indicateur est déterminé à partir de sa localisation sur les cartes d'aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.	maintenu	\N	open_data_lo	0	0	{"values"}
alea_sismique	batiment_groupe_risques	TEXT	1	(georisque) Indicateur d'aléa sismique.  Cet indicateur est déterminé à partir de sa localisation sur les cartes d'aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.	maintenu	\N	open_data_lo	0	0	{"values"}
categorie_hauteur_residentiel_risque_sismique	batiment_groupe_risques	TEXT	1	(bdnb) Catégorie de hauteur liée au risque sismique. Les bâtiments à usage résidentiel sont classés en différentes catégories. \
La catégorie 1 correspond aux habitations individuelles, la catégorie 2 aux habitations collectives dont la hauteur est inférieur ou égale à 12.5m, \
la catégorie 3 aux habitations collectives dont la hauteur est inférieur ou égale à 28m, \
la catégorie 4 aux habitations collectives dont la hauteur est inférieur ou égale à 50m, au-delà, il s'agit de la catégorie 5.	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"values"}
batiment_groupe_id	batiment_groupe_contrainte_opportunite_renovation	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_bdnb_expert	1	1	\N
pac_faisabilite_ayant_droit	batiment_groupe_contrainte_opportunite_renovation	text	1	Indicateur sur le niveau de faisabilité technico-économique des solutions PAC calculé à partir des données ayant droits fichiers fonciers.\
Valeurs possibles :\
- forte\
- forte-moyenne\
- moyenne\
- moyenne-faible\
- faible	maintenu	\N	ayant_droit_ffo	0	0	{"forte","forte-moyenne","moyenne","moyenne-faible","faible"}
type_pac_ayant_droit	batiment_groupe_contrainte_opportunite_renovation	text	1	Type de PAC correspondant à la faisabilité fournie, la faisabilité est évaluée pour une liste de solutions techniques de pompes à chaleur, on indique ici quelle grande famille de pompe à chaleur correspond à la faisabilité maximale. Cet indicateur utilise en partie des données ayant droits fichiers fonciers.\
Valeurs possibles :\
- pac_idv : Solution PAC individuelle\
- pac_col : Solution PAC collective et individuelle\
- pac_tout_type : Solution PAC collective ou individuelle	maintenu	\N	ayant_droit_ffo	0	0	{"pac_idv","pac_col","pac_tout_type"}
pac_faisabilite	batiment_groupe_contrainte_opportunite_renovation	text	1	Indicateur sur le niveau de faisabilité technico-économique des solutions PAC calculé à partir de données non ayant droit fichiers fonciers.\
Valeurs possibles :\
- forte\
- forte-moyenne\
- moyenne\
- moyenne-faible\
- faible	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"forte","forte-moyenne","moyenne","moyenne-faible","faible"}
type_pac	batiment_groupe_contrainte_opportunite_renovation	text	1	Type de PAC correspondant à la faisabilité fournie, la faisabilité est évaluée pour une liste de solutions techniques de pompes à chaleur, on indique ici quelle grande famille de pompe à chaleur correspond à la faisabilité maximale. Cet indicateur n'utilise pas de données ayant droits fichiers fonciers.\
Valeurs possibles :\
- pac_idv : Solution PAC individuelle\
- pac_col : Solution PAC collective et individuelle\
- pac_tout_type : Solution PAC collective ou individuelle	maintenu	\N	ayant_droit_bdnb_expert	0	0	{"pac_idv","pac_col","pac_tout_type"}
critere_surface_non_bati	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si plus de 50 % de la surface totale de la parcelle est une surface non bâtie. on considère qu'au delà de 50% il est possible d'aménager un local pour une pompe à chaleur collective.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
critere_toiture_terrasse	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si le bâtiment possède une toiture terrasse. On considère que si le bâtiment dispose d'une toiture terrasse alors il est possible d'aménager une pompe à chaleur collective sur le toit.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
categorie_erp_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	categorie d'ERP du DPE tertiaire	maintenu	\N	open_data_lo	0	0	{"1ère catégorie","2ème catégorie","3ème catégorie","4ème catégorie","5ème catégorie"}
critere_presence_balcon_ayant_droit	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si le bâtiment dispose d’un balcon ou d’une terrasse. Les balcons ou terrasses sont des espaces propices à l'installation de pompes à chaleur individuelles. Cet indicateur utilise des données ayant droits fichiers fonciers.	maintenu	\N	ayant_droit_ffo	0	0	\N
critere_presence_balcon	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si le bâtiment dispose d’un balcon ou d’une terrasse. Les balcons ou terrasses sont des espaces propices à l'installation de pompes à chaleur individuelles. Cet indicateur n'utilise pas de données ayant droits fichiers fonciers.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
critere_typologie_moyenne_ayant_droit	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si la typologie moyenne des appartements est adapté l’installation d’une PAC individuelle. Cet indicateur utilise des données ayant droits fichiers fonciers.	maintenu	\N	ayant_droit_ffo	0	0	\N
critere_typologie_moyenne	batiment_groupe_contrainte_opportunite_renovation	boolean	1	Indique si la typologie moyenne des appartements permet l’installation d’une PAC individuelle. Cet indicateur n'utilise pas de données ayant droits fichiers fonciers.	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
batiment_groupe_id	batiment_groupe_urbanisme	varchar(30)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
cle_interop_adr	rel_batiment_groupe_dpe_tertiaire	text	1	Clé d'interopérabilité de l'adresse postale	maintenu	\N	open_data_lo	1	0	\N
adresse_brut	rel_batiment_groupe_dpe_tertiaire	text	1	adresse brute envoyée au géocodeur	maintenu	\N	open_data_lo	0	0	\N
adresse_geocodee	rel_batiment_groupe_dpe_tertiaire	text	1	libelle de l'adresse retournée par le géocodeur	maintenu	\N	open_data_lo	0	0	\N
code_departement_insee	batiment_groupe_urbanisme	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
contrainte_urbanisme_ac4	batiment_groupe_urbanisme	boolean	1	Indicateur booléen de la présence du bâtiment dans une zone AC4 (sites patrimoniaux remarquables)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
contrainte_urbanisme_ac2	batiment_groupe_urbanisme	boolean	1	Indicateur booléen de la présence du bâtiment dans une zone AC2 (les sites méritant d'être protégés mais ne présentant pas d'intérêt remarquables suffisants pour justifier leur classement)	maintenu	\N	ayant_droit_bdnb_expert	0	0	\N
contrainte_urbanisme_ac1	batiment_groupe_urbanisme	boolean	1	Indicateur booléen de la présence du bâtiment dans une zone AC1 (périmètre de 500m autour d'un monument historique ou dans un périmètre aux abords des monuments historiques)	maintenu	\N	open_data_lo	0	0	\N
zone_plu_bati_patrimonial	batiment_groupe_urbanisme	boolean	1	Indicateur booléen de la présence du bâtiment dans un périmètre classé patrimonial dans un PLU. Cela peut potentiellement recouvrir des classifications nationales comme les SPR mais peut aussi correspondre à des protections locales documentées uniquement dans le PLU.	maintenu	\N	open_data_lo	0	0	\N
monument_historique	batiment_groupe_urbanisme	boolean	1	Indicateur booléen signalant si le bâtiment est classé comme monument historique. Le bâtiment est déterminé comme monument historique lorsque le géolocalisant du monument est sur le bâtiment en question.	maintenu	\N	open_data_lo	0	0	\N
source_monument_historique	batiment_groupe_urbanisme	text	1	Source utilisée pour identifier le bâtiment comme monument historique. (mérimée ou géoportail de l'urbanisme ou les deux)	maintenu	\N	open_data_lo	0	0	\N
denomination_monument_historique	batiment_groupe_urbanisme	text	1	Dénomination du monument historique le plus proche si le bâtiment se trouve dans un périmètre AC1 ou s'il est lui-même bâtiment historique	maintenu	\N	open_data_lo	0	0	\N
distance_monument_historique	batiment_groupe_urbanisme	INTEGER	1	Distance entre le bâtiment et le monument historique en [m]. La distance est égale à 0m lorsque le bâtiment est un monument historique.	maintenu	\N	open_data_lo	0	0	\N
batiment_groupe_id	batiment_groupe_dpe_tertiaire	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
service_public	rel_batiment_groupe_usage	boolean	1	Si service public identifié alors Vrai. Si non connu, null.	maintenu	\N	ayant_droit_ffo	0	0	\N
l_sources	rel_batiment_groupe_usage	text[]	1	Liste de sources ayant servi à construire l'usage.	maintenu	\N	ayant_droit_ffo	0	0	\N
code_departement_insee	batiment_groupe_dpe_tertiaire	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
identifiant_dpe	batiment_groupe_dpe_tertiaire	text	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	0	0	\N
type_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	0	le DPE tertiaire applique l'arrêté de 2006 sur le DPE et n'a pas été revu depuis. Pour le moment cette colonne vaut toujours : 'dpe 2006 tertiaire et erp'	maintenu	\N	open_data_lo	0	0	{"dpe 2006 tertiaire et erp"}
source_nouvelle_base_ademe	batiment_groupe_dpe_tertiaire	bool	1	le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l'ancienne base de données (2012-2021)	maintenu	\N	open_data_lo	0	0	\N
version	batiment_groupe_dpe_tertiaire	text	1	version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu'à partir d'une certaine version	maintenu	\N	open_data_lo	0	0	\N
date_etablissement_dpe	batiment_groupe_dpe_tertiaire	timestamp	1	date de l'établissement du dpe	maintenu	\N	open_data_lo	0	0	\N
date_reception_dpe	batiment_groupe_dpe_tertiaire	timestamp	1	date de réception du DPE dans la base de données de l'ADEME	maintenu	\N	open_data_lo	0	0	\N
annee_construction_dpe	batiment_groupe_dpe_tertiaire	smallint	1	année de construction du logement évaluée par le DPE	maintenu	\N	open_data_lo	0	0	\N
shon	batiment_groupe_dpe_tertiaire	numeric	1	surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution	maintenu	m2	open_data_lo	0	0	\N
surface_utile	batiment_groupe_dpe_tertiaire	numeric	1	surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires	maintenu	m2	open_data_lo	0	0	\N
classe_conso_energie_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	classe de consommation d'energie primaire du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","H","I"}
classe_emission_ges_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	classe d'emission GES du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	\N	open_data_lo	0	0	{"A","B","C","D","E","F","G","H","I"}
conso_dpe_tertiaire_ep_m2	batiment_groupe_dpe_tertiaire	numeric	1	consommation d'energie primaire du DPE tertiaire suivant l'arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)	maintenu	kwhep/m²/an	open_data_lo	0	0	\N
type_erp_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	type d'ERP pour le DPE tertiaire, si l'usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n'est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"	maintenu	\N	open_data_lo	0	0	{"j : structures d’accueil pour personnes âgées ou personnes handicapées","l : salles d'auditions, de conférences, de réunions, de spectacles ou à usage multiple","m : magasins de vente, centres commerciaux","n : restaurants et débits de boisson","o : hôtels et pensions de famille","p : salles de danse et salles de jeux","r : établissements d’éveil, d’enseignement, de formation, centres de vacances, centres de loisirs sans hébergement","s : bibliothèques, centres de documentation","t : salles d'exposition à vocation commerciale","u : établissements de soins","v : établissements de divers cultes","w : administrations, banques, bureaux","x : établissements sportifs couverts","y : musées","pa : établissements de plein air","cts : chapiteaux, tentes et structures toile","sg : structures gonflables","ps : parcs de stationnement couverts","oa : hôtels-restaurants d'altitude","ga : gares accessibles au public (chemins de fer, téléphériques, remonte-pentes...)","ef : établissements flottants (eaux intérieures)","ref : refuges de montagne","gha : habitation","gho : hôtel","ghr : enseignement","ghs : dépôt d'archives","ghtc : tour de contrôle","ghu : usage sanitaire","ghw : bureaux","ghz : usage mixte","locaux d'entreprise (bureaux)","autres tertiaires non erp"}
methode_application_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	methode d'application du DPE tertiaire (facture, vierge ou neuf)	maintenu	\N	open_data_lo	0	0	{"dpe tertiaire facture","dpe tertiaire bâtiment neuf","dpe tertiaire vierge","dpe tertiaire vierge neuf","dpe tertiaire facture dans un bâtiment de logement","dpe tertiaire bâtiment neuf dans un bâtiment de logement","dpe tertiaire vierge dans un bâtiment de logement","dpe tertiaire vierge neuf dans un bâtiment de logement"}
sous_modele_dpe_tertiaire	batiment_groupe_dpe_tertiaire	text	1	sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)	maintenu	\N	open_data_lo	0	0	{"bureaux, services administratifs, enseignement","bâtiments à occupation continue","autres","centre commercial"}
type_energie_chauffage	batiment_groupe_dpe_tertiaire	text	1	type d'énergie pour le générateur de chauffage principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_ecs	batiment_groupe_dpe_tertiaire	text	1	type d'énergie pour le générateur d'eau chaude sanitaire (ECS) principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
type_energie_climatisation	batiment_groupe_dpe_tertiaire	text	1	type d'énergie pour le générateur de climatisation principal	maintenu	\N	open_data_lo	0	0	{"gpl/butane/propane","fioul","gaz","reseau de chaleur","bois","electricite","charbon","solaire","reseau de froid","autre combustible fossile"}
derniere_annee_consommation	batiment_groupe_dpe_tertiaire	smallint	1	dernière année de consommation utilisée pour le calcul du DPE tertiaire	maintenu	kwhef	open_data_lo	0	0	\N
conso_autre_fossile	batiment_groupe_dpe_tertiaire	numeric	1	consommation d'autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_bois	batiment_groupe_dpe_tertiaire	numeric	1	consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
niveau_fiabilite	rel_batiment_groupe_usage	varchar	1	Valeurs possibles :\
- très fiable\
- fiable\
- moyennement fiable\
- ou null	maintenu	\N	ayant_droit_ffo	0	0	{"fiable","assez fiable","très fiable"}
conso_electricite	batiment_groupe_dpe_tertiaire	numeric	1	consommation d'électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_fioul	batiment_groupe_dpe_tertiaire	numeric	1	consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_gaz	batiment_groupe_dpe_tertiaire	numeric	1	consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_gpl_butane_propane	batiment_groupe_dpe_tertiaire	numeric	1	consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_reseau_chaleur	batiment_groupe_dpe_tertiaire	numeric	1	consommation d'énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
conso_reseau_froid	batiment_groupe_dpe_tertiaire	numeric	1	consommation d'énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l'étiquette énergie primaire et GES du DPE tertiaire (kWhef)	maintenu	kwhef	open_data_lo	0	0	\N
batiment_groupe_id	rel_batiment_groupe_dpe_tertiaire	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	open_data_lo	1	1	\N
identifiant_dpe	rel_batiment_groupe_dpe_tertiaire	TEXT	0	identifiant unique des DPE de l'ADEME.	maintenu	\N	open_data_lo	1	1	\N
code_departement_insee	rel_batiment_groupe_dpe_tertiaire	varchar(2)	0	Code département INSEE	maintenu	\N	open_data_lo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
type_appariement	rel_batiment_groupe_dpe_tertiaire	text	1	méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l'identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l'ensemble des méthodes utilisées pour l'appariement	maintenu	\N	open_data_lo	0	0	{"parcelle","adresse","parcelle + adresse","rnb + parcelle","rnb","rnb + parcelle + adresse","rnb + adresse"}
batiment_groupe_id	rel_batiment_groupe_usage	VARCHAR(22)	0	Identifiant du groupe de bâtiment au sens de la BDNB	maintenu	\N	ayant_droit_ffo	1	1	\N
code_departement_insee	rel_batiment_groupe_usage	varchar(2)	0	Code département INSEE	maintenu	\N	ayant_droit_ffo	1	0	{"01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","21","22","23","24","25","26","27","28","29","2A","2B","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95"}
usage_niveau_1_bdnb	rel_batiment_groupe_usage	varchar	0	Usage de premier niveau\
Valeurs possibles :\
- 'Résidentiel individuel',\
- 'Résidentiel collectif',\
- 'Résidentiel indifférencié',\
- 'Tertiaire',\
- 'Primaire',\
- 'Secondaire',\
- 'Indifférencié',\
- 'Dépendance'	maintenu	\N	ayant_droit_ffo	1	0	{"Résidentiel individuel","Résidentiel collectif","Résidentiel indifférencié","Tertiaire","Primaire","Secondaire","Indifférencié","Dépendance"}
usage_niveau_2_bdnb	rel_batiment_groupe_usage	varchar	0	Usage de deuxième niveau\
Valeurs possibles :\
- 'administration',\
- 'agriculture, sylviculture et pêche',\
- 'armée',\
- 'bureau',\
- 'cave / grenier / remise',\
- 'commerce',\
- 'culte',\
- 'culture',\
- 'dépendance diverse',\
- 'énergie',\
- 'enseignement indifférencié',\
- 'enseignement primaire et secondaire',\
- 'entrepôt et logistique',\
- 'forces de l''ordre et sécurité civile',\
- 'garage / parking / box',\
- 'hébergement et restauration',\
- 'indifférencié',\
- 'industrie',\
- 'information et communication',\
- 'justice',\
- 'loisirs',\
- 'loisirs détente',\
- 'monument',\
- 'primaire indifférencié',\
- 'recherche et enseignement supérieur',\
- 'résidentiel collectif',\
- 'résidentiel indifférencié',\
- 'résidentiel individuel',\
- 'santé et social',\
- 'secondaire indifférencié',\
- 'service pour l''emploi et la formation',\
- 'service urbain',\
- 'services',\
- 'sport',\
- 'tertiaire indifférencié',\
- 'transport'	maintenu	\N	ayant_droit_ffo	1	0	{"administration","agriculture, sylviculture et pêche","armée","bureau","cave / grenier / remise","commerce","culte","culture","dépendance diverse","énergie","enseignement indifférencié","enseignement petite enfance","enseignement primaire et secondaire","entrepôt et logistique","forces de l'ordre et sécurité civile","garage / parking / box","hébergement et restauration","industrie","information et communication","justice","loisirs","loisirs détente","monument","recherche et enseignement supérieur","résidentiel collectif","résidentiel individuel","santé et social","service pour l'emploi et la formation","service urbain","sport","tertiaire indifférencié","transport","parking"}
usage_niveau_3_bdnb	rel_batiment_groupe_usage	varchar	0	Usage de troisième niveau\
Valeurs possibles :\
- 'abbaye',\
- 'administration indifférenciée',\
- 'agriculture, sylviculture et pêche indifférenciée',\
- 'aire de repos, service ou triage', \
- 'artisanat',\
- 'autre service de l''enseignement supérieur et de la recherche',\
- 'autre service de l''éducation',\
- 'autre service des forces de l''ordre',\
- 'autre service judiciaire',\
- 'autre service médico-social',\
- 'autre établissement et service à caractère sanitaire',\
- 'basilique', \
- 'bibliothèque et médiathèque',\
- 'box',\
- 'buanderie',\
- 'bureau indifférencié',\
- 'bûcher',\
- 'cathédrale',\
- 'cave',\
- 'cellier',\
- 'centre de formation',\
- 'chapelle',\
- 'commerce indifférencié',\
- 'couvent',\
- 'culte indifférencié',\
- 'culture indifférenciée',\
- 'dépendance de local commun',\
- 'dépôt d''archives',\
- 'elément de pur agrément',\
- 'énergie indifférenciée',\
- 'enseignement du premier degré',\
- 'enseignement du second degré - premier cycle',\
- 'enseignement du second degré - second cycle',\
- 'enseignement indifférencié',\
- 'enseignement primaire et secondaire indifférencié',\
- 'enseignement primaire indifférencié',\
- 'enseignement secondaire indifférencié',\
- 'entreposage et services auxiliaires des transports',\
- 'entrepôsage et logistique indifférencié',\
- 'espace loisirs indifférencié',\
- 'espace sportif indifférencié',\
- 'espaces naturels et animaliers',\
- 'forces armées',\
- 'garage',\
- 'gendarmerie',\
- 'gestion de l''eau',\
- 'gestion des déchets',\
- 'gestion espaces naturels et animaliers',\
- 'gestion patrimoine historique',\
- 'grenier',\
- 'hébergement',\
- 'hébergement avec restauration',\
- 'hébergement et restauration indifférenciés',\
- 'hébergement sans restauration',\
- 'indifférencié',\
- 'industrie extractive',\
- 'industrie indifférenciée',\
- 'industrie manufacturière',\
- 'information et communication indifférenciée',\
- 'jardin d’hiver',\
- 'jeux d''hasard et argent',\
- 'justice indifférenciée',\
- 'logistique',\
- 'magasin de centre commercial',\
- 'magasin grande surface',\
- 'magasin très grande surface',\
- 'mairie',\
- 'maison individuelle',\
- 'maisons groupées',\
- 'marché',\
- 'monastère',\
- 'monument indifférencié',\
- 'mosquée',\
- 'musée et centre culturel',\
- 'parc d''attractions',\
- 'parking',\
- 'piscine',\
- 'pièce indépendante',\
- 'police',\
- 'presbytère',\
- 'production et stockage d''énergie',\
- 'recherche et enseignement supérieur indifférencié',\
- 'remise',\
- 'restauration',\
- 'résidentiel collectif',\
- 'résidentiel indifférencié',\
- 'salle de spectacles',\
- 'santé et social indifférencié',\
- 'sapeurs-pompiers',\
- 'secondaire indifférencié',\
- 'serre',\
- 'service administratif',\
- 'service administratif des forces armées',\
- 'service administratif du domaine de l''emploi et de la formation',\
- 'service administratif du domaine de l''éducation et de la recherche',\
- 'service administratif du domaine des forces de l''ordre et de la sécurité civile',\
- 'service administratif du domaine fiscal',\
- 'service administratif du domaine judiciaire',\
- 'service administratif du domaine médico-social',\
- 'service administratif du domaine économique',\
- 'service d''accueil des usagers',\
- 'service d''administration local',\
- 'service d''aide pour l''emploi',\
- 'service hospitalier',\
- 'service judiciaire et d''accueil du public',\
- 'services indifférencié',\
- 'station service',\
- 'synagogue',\
- 'temple',\
- 'terrasse',\
- 'tertiaire indifférencié',\
- 'théâtre',\
- 'transformateur',\
- 'transport aérien',\
- 'transport férroviaire',\
- 'transport indifférencié',\
- 'transport par conduites',\
- 'transport par eau',\
- 'transport terrestre',\
- 'tribunal',\
- 'télécommunication',\
- 'usine de génération d''énergie',\
- 'éducation et formation à usage culturel',\
- 'église',\
- 'énergie indifférenciée',\
- 'établissement et service de santé',\
- 'établissement industriel',\
- 'établissement médico-social pour personnes agées',\
- 'établissement médico-social pour personnes handicapées',\
- 'établissement pénitentiaire',\
- 'établissements pour la construction et le génie civil'	maintenu	\N	ayant_droit_ffo	1	1	{"usine de génération d'énergie","énergie indifférenciée","transformateur","industrie extractive","industrie manufacturière","industrie indifférenciée","secondaire indifférencié","service hospitalier","établissement pénitentiaire","enseignement du second degré - second cycle","recherche et enseignement supérieur","cathédrale","parc d'attractions","tribunal","enseignement du second degré - premier cycle","basilique","abbaye","bassin de natation","sport de glace","monastère","couvent","presbytère","enseignement du premier degré","enseignement pré-primaire","enseignement primaire indifférencié","enseignement secondaire indifférencié","enseignement primaire et secondaire indifférencié","mairie","établissement et service de santé","recherche et enseignement supérieur indifférencié","mosquée","église","temple","synagogue","transport aérien","établissement médico-social pour personnes agées","établissement médico-social pour personnes handicapées","gendarmerie","forces armées","police","sapeurs-pompiers","théâtre","musée et centre culturel","salle de spectacles","bibliothèque et médiathèque","salle multisports","autre service des forces de l'ordre","espace sportif indifférencié","salle ou terrain non spécialisée","transport férroviaire","transport par conduites","gestion de l'eau","gestion des déchets","production et stockage d'énergie","transport par eau","autre établissement et service à caractère sanitaire","hébergement médico-social","service administratif du domaine de l'éducation et de la recherche","service administratif du domaine judiciaire","service administratif du domaine médico-social","service administratif du domaine des forces de l'ordre et de la sécurité civile","service administratif du domaine fiscal","service administratif du domaine économique","service administratif du domaine des sports","service administratif du domaine des transports","service administratif du domaine de l'emploi et de la formation","administration indifférenciée","bureau indifférencié","magasin très grande surface","hébergement avec restauration","magasin grande surface","hébergement","crèche","service administratif des forces armées","service administratif","jeux d'hasard et argent","service judiciaire et d'accueil du public","service d'administration local","autre service de l'enseignement supérieur et de la recherche","magasin de centre commercial","salle ou terrain spécialisé","hébergement et restauration indifférenciés","restauration","artisanat","hébergement sans restauration","station service","commerce indifférencié","espace loisirs indifférencié","justice indifférenciée","autre service judiciaire","santé et social indifférencié","enseignement indifférencié","centre de formation","information et communication indifférenciée","établissements pour la construction et le génie civil","entrepôsage et logistique indifférencié","monument indifférencié","logistique","service d'aide pour l'emploi","services indifférencié","entreposage et services auxiliaires des transports","service d'accueil des usagers","marché","télécommunication","éducation et formation à usage culturel","culture indifférenciée","culte indifférencié","autre service de l'éducation","transport indifférencié","gestion patrimoine historique","gestion espaces naturels et animaliers","chapelle","dépôt d'archives","transport terrestre","aire de repos, service ou triage","espaces naturels et animaliers","tertiaire indifférencié","agriculture, sylviculture et pêche indifférenciée","résidentiel collectif","maison individuelle","maisons groupées","parking","garage","box","piscine","pièce indépendante","elément de pur agrément","terrasse","serre","jardin d’hiver","buanderie","cellier","dépendance de local commun","remise","cave","grenier","bûcher","indifférencié","résidentiel indifférencié","antenne téléphone","voies et éléments construits sur autoroute","appareil à gaz","usine","hôtel","parking à ciel ouvert","parking couvert","centre de rééducation,thalassothérapie,thermaux"}
categorie_usage_propriete	rel_batiment_groupe_usage	varchar	0	Catégorie d'usage et de propriété du bâtiment. Cet indicateur couple les catégories d'usages à la typologie de propriétaire du bâtiment pour produire une segmentation du parc utilisé dans de nombreux cas d'usages. \
Valeurs possibles :\
- Résidentiel individuel social\
- Résidentiel individuel indifférencié\
- Résidentiel collectif social\
- Résidentiel collectif copropriété\
- Résidentiel collectif indifférencié\
- Tertiaire public indifférencié\
- Tertiaire indifférencié\
- Secondaire indifférencié\
- Dépendance indifférenciée\
- Indifférencié	maintenu	\N	ayant_droit_ffo	0	0	{"Dépendance indifférenciée","Tertiaire privé","Résidentiel collectif social","Résidentiel collectif indifférencié","Résidentiel indifférencié","Tertiaire public","Résidentiel collectif copropriété","Résidentiel individuel indifférencié","Tertiaire indifférencié","Indifférencié","Secondaire indifférencié","Résidentiel individuel social","Primaire indifférencié"}
l_denomination	rel_batiment_groupe_usage	text[]	1	Liste de dénominations des établissements - sous le même usage	maintenu	\N	ayant_droit_ffo	0	0	\N
priorite	rel_batiment_groupe_usage	INT	1	Niveaux de priorité sur l'usage basé sur les surfaces et/ou nombre de sources que renseignent sur l'usage. 1 correspond au usage prioritaire.	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_pro_tot	rel_batiment_groupe_usage	int	1	Somme des surfaces des parties principales, secondaires couvertes ou non, stationnements couverts ou non (`sprobati`) [m²] - hors parkings pour cet usage dans ce bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
s_loc_tot	rel_batiment_groupe_usage	int	1	Somme de stoth, stotdsueic, stotd, sprincp, ssecp, sparkp, sparkncp (`slocal`) [m²] - pour cet usage dans ce bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
pourcentage_s_loc_tot	rel_batiment_groupe_usage	int	1	Pourcentage de la surface des locaux pour cet usage par rapport au total des surfaces de locaux du bâtiment	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_log	rel_batiment_groupe_usage	int	1	Nombre de logements associés au couple batiment groupe usage	maintenu	\N	ayant_droit_ffo	0	0	\N
nb_loc	rel_batiment_groupe_usage	int	1	Nombre de locaux associés au couple batiment groupe usage	maintenu	\N	ayant_droit_ffo	0	0	\N
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "metadonnees_jeu_de_donnee_source_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" IS 'Descriptions des tables de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "denomination_serie" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "millesime_jeu_de_donnees" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "description" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "url_data" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "url_doc" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "date_publication" date;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "couverture_temporelle" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "couverture_spatiale" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ADD COLUMN "denomination_fournisseur" VARCHAR;
COPY "bdnb_2025_07_a_open_data_dep01"."metadonnees_jeu_de_donnee_source" ("denomination_serie", "millesime_jeu_de_donnees", "description", "url_data", "url_doc", "date_publication", "couverture_temporelle", "couverture_spatiale", "denomination_fournisseur") FROM STDIN;
ban	2025T3	Base d'Adresse Nationale (BAN)	https://adresse.data.gouv.fr/data/ban/adresses/latest/addok	https://adresse.data.gouv.fr/donnees-nationales	2025/07/23	non pertinent	France Métropolitaine (Hexagone + Corse)	etalab
cadastre	20250401	Cadastre Etalab : Données consolidées pour la France entière, produites par Etalab à partir des données de référence ci-dessus.	https://cadastre.data.gouv.fr/data/etalab-cadastre/2025-04-01/shp/departements/	https://cadastre.data.gouv.fr/datasets/cadastre-etalab	2025/04/01	non pertinent	France Métropolitaine (Hexagone + Corse)	etalab
gupsmv	2024-10-22	Archives des plans de sauvegarde et de mise en valeur (PSMV)	https://data.geopf.fr/telechargement/resource/pack_psmv	https://data.geopf.fr/telechargement/resource/pack_psmv	2024/10/22	non pertinent	Hexagone + Corse	geoportail_urbanisme
gusup	2025-07-28	Données des servitudes d'utilité publique (SUP)	https://www.geoportail-urbanisme.gouv.fr/services/	https://www.geoportail-urbanisme.gouv.fr/services/	2025/07/28	non pertinent	Hexagone + Corse	geoportail_urbanisme
guplu	2025-07-25	Données des Plans Locaux d'Urbanism (PLU)	https://www.geoportail-urbanisme.gouv.fr/services/	https://www.geoportail-urbanisme.gouv.fr/services/	2025/07/25	non pertinent	Hexagone + Corse	geoportail_urbanisme
fichiers_fonciers	2024-31-12	Base de données des Fichiers Fonciers (FF), produite par la DGFip et gérée/rediffusée par le CEREMA HdF	https://datafoncier.cerema.fr/ressources/fichiers-fonciers	https://datafoncier.cerema.fr/ressources/fichiers-fonciers	2024/03/15	non pertinent	Hexagone + Corse	cerema
coproff	2023-01-01	Base des copropriétés (CoproFF), produite par le CEREMA, d'après RNIC, FF et DV3F	https://datafoncier.cerema.fr/coproff	https://datafoncier.cerema.fr/coproff	2024/09/26	non pertinent	Hexagone + Corse	cerema
dvf_open	2025-04-14	Base des données des valeurs foncières open data (DVF Open)	https://cerema.app.box.com/v/dvfplus-opendata/folder/77228357248	https://www.data.gouv.fr/fr/datasets/r/d573456c-76eb-4276-b91c-e6b9c89d6656	2025/04/14	non pertinent	Hexagone + Corse	cerema
dv3f	2025-01	Base de Données des Valeurs Foncières (DV3F)	https://datafoncier.cerema.fr/donnees/donnee-dv3f	https://datafoncier.cerema.fr/donnees/donnee-dv3f	2025/07/06	(2010-01,2024-01)	Hexagone + Corse	cerema
bruit_ls	2022	Base de Données d'Exposition au bruit du parc locatif social	\N	\N	2022/01/01	non pertinent	Hexagone + Corse	cerema
majic_pm	2024-01-01	Fichier MAJIC - Personnes Morales (MAJIC-PM) propriétés non bâties et non bâties	https://www.data.gouv.fr/datasets/fichiers-des-locaux-et-des-parcelles-des-personnes-morales/	https://www.data.gouv.fr/fr/datasets/fichiers-des-locaux-et-des-parcelles-des-personnes-morales/	2025/02/26	non pertinent	Hexagone + Corse	dgfip
enepdl	2022-01-01	Nombre de Points de Livraison (PDL) d'électricité par adresse couvert par le réseau ENEDIS			2022/01/01	{01/01/2022,31/12/2022}	Hexagone + Corse	enedis
sitadel	2025	Base des permis de construire et autres autorisations d'urbanisme (Sitadel)	https://www.statistiques.developpement-durable.gouv.fr/catalogue?page=dataset&datasetId=6513f0189d7d312c80ec5b5b	https://www.statistiques.developpement-durable.gouv.fr/catalogue?page=dataset&datasetId=6513f0189d7d312c80ec5b5b	2025/06/26	(20130101-20250531)	France Métropolitaine (Hexagone + Corse)	mte
dle	2024	Données Locales de l'Energie (DLE)	https://www.statistiques.developpement-durable.gouv.fr/donnees-locales-de-consommation-denergie	https://www.statistiques.developpement-durable.gouv.fr/donnees-locales-de-consommation-denergie	2025/10/01	(2018,2023)	France Hexagonale	mte
rpls	2024	Répertoire des logements locatifs des bailleurs sociaux (RPLS)	https://www.data.gouv.fr/fr/datasets/repertoire-des-logements-locatifs-des-bailleurs-sociaux/	https://www.statistiques.developpement-durable.gouv.fr/repertoire-des-logements-locatifs-des-bailleurs-sociaux-rpls	2024/01/01	non pertinent	France	dhup
dpe_arrete_2021	2025-09	Observatoire des Diagnostics de Performance Energétique (DPE post réforme du 1er juillet 2021)	https://opendata.ademe.fr/dump_dpev2_prod_fdld.sql.gz	https://data.ademe.fr/datasets/dpe-v2-logements-existants	2025/09/23	(2021-07,2025-05)	France Métropolitaine (Hexagone + Corse)	ademe
dpe_arrete_2012	2020-06-01	Base de données des Diagnostics de Performance Energétique (DPE arrêté 2012). Ancienne version archivée au 1er octobre 2021	https://www.data.gouv.fr/fr/datasets/dpe-logements-avant-juillet-2021/	https://www.data.gouv.fr/fr/datasets/dpe-logements-avant-juillet-2021/	2020/06/01	(2014-01,2020-06)	France Métropolitaine (Hexagone + Corse)	ademe
pies	2023	Patrimoine Immobilier des opérateurs de l'Enseignement Supérieur (PIES)	https://data.enseignementsup-recherche.gouv.fr/api/explore/v2.1/catalog/datasets/fr-esr-patrimoine-immobilier-des-operateurs-de-l-enseignement-superieur/exports/csv?lang=fr&timezone=Europe%2FBerlin&use_labels=true&delimiter=%3B	https://data.enseignementsup-recherche.gouv.fr/explore/dataset/fr-esr-patrimoine-immobilier-des-operateurs-de-l-enseignement-superieur/table	2023/07/01	non pertinent	France	ministere_enseignement_superieur
rnb	2025-07	Stock d'identifiants du Référentiel National des Bâtiments (RNB)	https://www.data.gouv.fr/api/1/datasets/r/93b1b952-6ea2-4df1-b6cb-ad403807db38	https://www.data.gouv.fr/fr/datasets/referentiel-national-des-batiments/	2025/07/26	non pertinent	France Métropolitaine (Hexagone + Corse) & DROM	rnb
aen	2023	Annuaire de l'éducation (AE)	https://www.data.gouv.fr/fr/datasets/r/b22f04bf-64a8-495d-b8bb-d84dbc4c7983	https://www.data.gouv.fr/fr/datasets/annuaire-de-leducation/	2023/06/10	non pertinent	France	ministere_education_nationale
arcep_imb	2025	Liste des immeubles contenant les informations relatives au déploiement FTTH.	https://static.data.gouv.fr/resources/le-marche-du-haut-et-tres-haut-debit-fixe-deploiements/20250911-155524/2025t2-immeuble.zip	https://www.data.gouv.fr/fr/datasets/le-marche-du-haut-et-tres-haut-debit-fixe-deploiements/	2025/09/11	non pertinent	France	arcep
finess	2024	Fichier national des établissements sanitaires et sociaux (FINESS)	https://www.data.gouv.fr/fr/datasets/r/98f3161f-79ff-4f16-8f6a-6d571a80fea2	https://finess.esante.gouv.fr/fininter/jsp/index.jsp	2024/02/01	non pertinent	France	ministere_solidarite_sante
rnc	2025T3	Registre National des Copropriétés (RNC)	https://www.data.gouv.fr/fr/datasets/registre-national-dimmatriculation-des-coproprietes/	https://www.registre-coproprietes.gouv.fr/	2025/10/01	non pertinent	France Métropolitaine (Hexagone + Corse)	anah
rcf	202507	Tracés des réseaux récoltés par France Chaleur Urbaine auprès des collectivités et exploitants	https://www.data.gouv.fr/fr/datasets/traces-des-reseaux-de-chaleur-et-de-froid/	https://www.data.gouv.fr/fr/datasets/traces-des-reseaux-de-chaleur-et-de-froid/	2025/07/24	non pertinent	France Métropolitaine (Hexagone + Corse)	fcu
bdnb	2024-10	Base de Données Nationale des Bâtiments	https://bdnb.io/download/	https://bdnb.io/	2025/02/01	non pertinent	France Métropolitaine (Hexagone + Corse)	cstb
pie	2024	Parc de l'Immobilier de l'Etat (PIE)		https://www.data.gouv.fr/fr/datasets/parc-de-limmobilier-de-letat-au-31-12-2021/	2024/05/01	non pertinent	France	ministere_economie_finances
bdtopo	2025-06-15	Base BDTopo v3.5	https://geoservices.ign.fr/bdtopo#telechargementsqlfra	https://geoservices.ign.fr/documentation/donnees/vecteur/bdtopo	2025/06/15	non pertinent	Hexagone + Corse	ign
iris	2025	Contours des IRIS Grande Echelle (IRIS-GE), co-construit par l'IGN Et l'INSEE	https://geoservices.ign.fr/irisge	https://geoservices.ign.fr/irisge	2025/01/01	non pertinent	France Métropolitaine (Hexagone + Corse)	ign
adm	2025	Annuaire de l'administration	https://www.data.gouv.fr/fr/datasets/service-public-fr-annuaire-de-l-administration-base-de-donnees-locales/	https://www.data.gouv.fr/fr/datasets/service-public-fr-annuaire-de-l-administration-base-de-donnees-locales/	2025/03/07	non pertinent	France	service_premier_ministre
merimee	2025	Base Mérimée : Immeubles protégés au titre des Monuments Historiques	https://data.culture.gouv.fr/api/explore/v2.1/catalog/datasets/liste-des-immeubles-proteges-au-titre-des-monuments-historiques/exports/csv?lang=fr&timezone=Europe%2FBerlin&use_labels=true&delimiter=%3B	https://data.culture.gouv.fr/explore/dataset/liste-des-immeubles-proteges-au-titre-des-monuments-historiques/information/	2025/09/11	non pertinent	France	mcu
qpv	2024	Quartiers Prioritaires de la Ville (QPV)	https://www.data.gouv.fr/fr/datasets/r/24c8e27e-b508-40ea-b218-8d894a3c4065	https://www.data.gouv.fr/fr/datasets/quartiers-prioritaires-de-la-politique-de-la-ville-qpv/	2024/09/17	non pertinent	France	anct
insee_cog	2025	Code Officiel Géographique (COG)	https://www.insee.fr/fr/statistiques/fichier/8377162/cog_ensemble_2025_csv.zip	https://www.insee.fr/fr/information/8377252	2025/03/04	non pertinent	France	insee
intercommunalites	2025	Intercommunalités (EPCI & EPT)	https://www.insee.fr/fr/information/2510634	https://www.insee.fr/fr/information/2510634	2025/01/01	non pertinent	France	insee
bpe	2024	Base permanente des équipements (BPE)	https://www.insee.fr/fr/statistiques/fichier/8217525/BPE24.zip	https://www.insee.fr/fr/statistiques/8217525?sommaire=8217537	2025/07/22	non pertinent	France	insee
sirene	2025	Base SIRENE -  codes SIREN et SIRET des entreprises	https://www.data.gouv.fr/datasets/base-sirene-des-entreprises-et-de-leurs-etablissements-siren-siret/	https://sirene.fr/sirene/public/static/documentation	2025/07/01	non pertinent	France	insee
es	202502	Recensement national des équipements sportifs et lieux de pratiques	https://equipements.sports.gouv.fr/explore/dataset/data-es/table/	https://equipements.sports.gouv.fr/pages/methodologie/	2025/02/25	non pertinent	France (outre-mer inclus)	msj
argiles	2025	Retrait-gonflement des argiles (RGA)	https://files.georisques.fr/argiles/AleaRG_Fxx_L93.zip	https://www.georisques.gouv.fr/donnees/bases-de-donnees/retrait-gonflement-des-argiles	2025/09/16	non pertinent	France Métropolitaine (Hexagone + Corse)	georisques
radon	2020	Base Géorisques - Carte des aléas liés aux gaz radon	https://www.georisques.gouv.fr/doc-api#!/Radon/rechercheRadonUsingGET	https://www.georisques.gouv.fr/doc-api#!/Radon/rechercheRadonUsingGET	2020/01/01	non pertinent	France Métropolitaine (Hexagone + Corse)	georisques
\.
BEGIN;
CREATE TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table"();
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "metadonnees_table_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" IS 'Descriptions des tables de la BDNB';
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "nom_table" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "statut" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "description" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "onglet_documentation" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "prefix_vue_compile" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "dans_vue_compile" BOOLEAN;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "type_table" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "contrainte_acces" VARCHAR;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "experimental" BOOLEAN;
ALTER TABLE "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ADD COLUMN "jeu_de_donnees_source" varchar[];
COPY "bdnb_2025_07_a_open_data_dep01"."metadonnees_table" ("nom_table", "statut", "description", "onglet_documentation", "prefix_vue_compile", "dans_vue_compile", "type_table", "contrainte_acces", "experimental", "jeu_de_donnees_source") FROM STDIN;
batiment_groupe_dle_elec_multimillesime	maintenu	Données de consommations des données locales de l'énergie du SDES pour le vecteur éléctrique agrégées à l'échelle du bâtiment (2018-2024)\
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)	batiment_groupe	\N	0	table	open_data_lo	0	{"dle"}
batiment_groupe_dle_reseaux_multimillesime	maintenu	Données de consommations des données locales de l'énergie du SDES pour le vecteur réseau de chaleur agrégées à l'échelle du bâtiment. (2020-2024)\
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)	batiment_groupe	\N	0	table	open_data_lo	0	{"dle"}
rel_batiment_groupe_dpe_logement	maintenu	Table de relation entre les groupes de bâtiments de la BDNB et les éléments des deux bases de données DPE (arrêté 2012 et arrêté 2021).  \
Les deux bases sont compilées dans cette table. Il est possible de filtrer avec la colonne `arrete_2021` (table `dpe_logement`) pour ne conserver que les nouveaux DPE.\
\
Cette table permet de faire le lien entre :\
- la table `batiment_groupe`,\
- et la table `dpe_logement` (qui contient l’intégralité des DPE).	tables_sources	\N	0	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
batiment_groupe_exposition_bruit_logement_social	maintenu	Informations d'exposition au bruit (restreint au parc locatif social) agrégées à l'échelle du bâtiment	\N	\N	1	table	ayant_droit_bruit_logement_social	0	{"bruit_ls"}
batiment_groupe_energie	déprécié	Dans cette table réservée aux ayants droits fichiers fonciers, il est calculé une consommation rapportée à la surface à partir des données locales de l'énergie et des fichiers fonciers sur la dernière année des données locales de l'énergie\
[TABLE DÉPRÉCIÉE] : les résultats de cette table seront intégrés directement dans les tables `batiment_groupe_dle_elec`, `batiment_groupe_dle_gaz` et `batiment_groupe_dle_reseau_multimillesime` dans une future version de la BDNB.	batiment_groupe	\N	1	table	ayant_droit_ffo	0	{"dle","fichiers_fonciers"}
passage_millesime_batiment_groupe_id	maintenu	Cette table permet d’identifier si un identifiant `batiment_groupe_id` a été modifié entre deux millésimes de la BDNB.  \
\
Elle contient uniquement les identifiants qui ont évolué depuis le millésime `2023-01a` (les identifiants inchangés sont absents) :\
- le type de transformation subie par le groupe de bâtiments : suppression, scission, regroupement,\
- le ou les nouveaux identifiants correspondants,\
- ainsi que leur millésime d’apparition.\
\
Si un identifiant est présent dans la colonne `ancien_id`, la table précise la nature de la transformation et les nouveaux identifiants associés.	batiment_groupe	\N	0	table	ayant_droit_bdnb_expert	0	{"bdnb"}
local	maintenu	Locaux au sens des fichiers fonciers (équivalent à [pb0010_local](https://doc-datafoncier.cerema.fr :\
Un logement est un local utilisé pour l’habitation, séparé, sans communication avec un autre local sauf avec les parties communes de l’immeuble (couloir, escalier, etc.), indépendant, c’est-à-dire ayant une entrée avec accès direct sur l’extérieur ou sur les parties communes.	batiment	\N	0	table	ayant_droit_ffo	0	{"fichiers_fonciers"}
batiment_groupe_pie	maintenu	Informations du parc immobilier de l'Etat agrégées à l'échelle du bâtiment	batiment_groupe	pie	1	table	ayant_droit_pie	0	{"pie"}
batiment_groupe_bdtopo_equ	maintenu	Agrégation des informations suivantes issues des équipements de la BD TOPO de l'IGN (couche équipement) qui intersectent les groupes de bâtiments :\
- la nature de l'équipement,\
- le toponyme associé.\
\
Les données sont fournies sous forme de listes agrégées.	batiment_groupe	bdtopo_equ	1	table	open_data_lo	0	{"bdtopo"}
batiment_groupe_proprietaire	maintenu	Informations issues des fichiers fonciers concernant la propriété du bâtiment.\
\
Contenu :\
- Identification du propriétaire principal via `personne_id`, correspondant à la variable [idpersonnedes fichiers fonciers.\
- Données statistiques sur le nombre et le statut des différents propriétaires associés au bâtiment.	batiment_groupe	ffo_prop	1	table	ayant_droit_ffo	0	{"fichiers_fonciers","majic_pm"}
batiment_groupe_simulations_valeur_verte	maintenu	Simulation des gains en valeur foncière liés à un potentiel changement de classe DPE pour un logement du bâtiment (en valeur relative).  \
Cette estimation repose sur :\
- un modèle utilisant les valeurs foncières réelles des logements vendus dans le même IRIS,\
- les prédictions DPE issues de la table `batiment_groupe_simulations_dpe`.	batiment_groupe	simu_valeur_verte	1	table	ayant_droit_simulation_dvf	0	{"bdnb"}
batiment_groupe_radon	déprécié	[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l'aléa radon projeté sur chaque bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.	batiment_groupe	radon	0	table	open_data_lo	0	{"radon"}
batiment_groupe_synthese_systeme_energetique_logement	maintenu	Table de synthèse des informations sur les systèmes énergétiques présents dans le bâtiment (chauffage, eau chaude sanitaire, climatisation, production d’électricité par énergie renouvelable).  \
Elle compile :\
- les données des DPE de l’ADEME,\
- les données locales de l’énergie,\
- les informations de raccordement à un réseau de chaleur (france chaleur urbaine)\
- les données du registre national des copropriétés de l’ANAH.\
\
Attention, ces informations concernent uniquement les bâtiments ayant un usage de logement et uniquement les informations concernant la partie logement des bâtiments à usage mixte	batiment_groupe	systeme_energetique	1	table	ayant_droit_bdnb_expert	0	{"dpe_arrete_2012","dpe_arrete_2021","rnc","dle","rcf"}
dpe_logement	maintenu	Table de compilation des DPE logements regroupant les DPE logements de l'arrêté du 8 février 2012 (DPE "arrete 2012" Base ADEME 2012-2021) et les DPE logements de l'arrêté du 31 mars 2021 (juillet 2021 - aujourd'hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE "arrete 2012"  et les DPE "arrete 2021". Les DPE de l'arrêté du 31 mars sont opposables et donc réputés bien plus fiables et issus d'une base de donnée beaucoup plus propre et complète que la précédente.  Les types de DPE peuvent être filtrés avec la propriété type_dpe entre les DPE "arrete 2012" et "arrete 2021".	tables_sources	\N	0	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
batiment_groupe_hthd	maintenu	Données issues de la base des immeubles localisés de l'Arcep agrégées à l'échelle du groupe de bâtiment.\
Cette table permet d'identifier les bâtiments raccordés à la fibre.	batiment_groupe	hthd	1	table	open_data_lo	0	{"arcep_imb"}
adresse_metrique	maintenu	Métriques des adresses. Cette table permet d’identifier le nombre de bâtiments desservis par une même adresse. Elle facilite ainsi la distinction entre :\
- les adresses mono-bâtiment,\
- les adresses desservant plusieurs bâtiments sur une même unité foncière,\
- et les adresses plus problématiques desservant plusieurs unités foncières distinctes.	adresse	\N	0	table	open_data_lo	0	{"ban","arcep_imb"}
rel_batiment_groupe_siret	maintenu	Table de relation entre les bâtiments de la BDNB et les établissements SIRET de la base SIREN.	tables_sources	\N	0	table	ayant_droit_bdnb_expert	0	{"sirene","bdnb"}
batiment_groupe_qpv	maintenu	Informations sur les Quartiers Prioritaires de la Ville agrégées à l'échelle du bâtiment	batiment_groupe	qpv	1	table	open_data_lo	0	{"qpv"}
batiment_groupe_synthese_enveloppe	maintenu	Table de synthèse des informations sur l’enveloppe du bâtiment (murs, toiture, vitrages, planchers).  \
Elle contient :\
- des informations sur les performances énergétiques des parois,\
- leurs caractéristiques techniques,\
- les types de matériaux utilisés.\
\
Cette table compile des données issues des DPE et des Fichiers Fonciers.	batiment_groupe	enveloppe	1	table	ayant_droit_bdnb_expert	0	{"dpe_arrete_2012","dpe_arrete_2021","fichiers_fonciers"}
batiment_groupe_argiles	déprécié	[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l'aléa lié au retrait gonflement des argiles (RGA) agrégées à l'échelle du bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.	batiment_groupe	argiles	0	table	open_data_lo	0	{"argiles"}
siret	maintenu	Table des établissements SIRET issus de la base SIRENE.	tables_sources	\N	0	table	ayant_droit_bdnb_expert	0	{"sirene"}
rel_batiment_groupe_bdtopo_zoa	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table des zones d'activité de la BDTOPO	tables_sources	\N	0	table	open_data_lo	0	{"bdtopo"}
batiment_groupe_urbanisme	maintenu	Table qui regroupe les contraintes et réglementations d'urbanismes qui s'appliquent au bâtiment. Dans cette version, les contraintes d'urbanismes intégrées sont celles liées aux sites patrimoniaux et monuments historiques.	batiment_groupe	\N	1	table	open_data_lo	0	{"bdnb","merimee","gusup","gupsmv"}
adresse	maintenu	Table de description des adresses. Les adresses dans la BDNB sont le sous-ensemble des adresses BAN de type `housenumber` (adressage au numéro) et uniquement localisé en France hexagonale et Corse. Des adresses ARCEP viennent compléter les adresses BAN quand ces adresses n'existent pas dans la BAN. Les géolocalisants ponctuels sont au format Lambert-93 (ESPG:2154).	adresse	\N	0	table	open_data_lo	0	{"arcep_imb","ban"}
rel_batiment_groupe_qpv	déprécié	DEPRECIEE  -> utiliser uniquement la table batiment_groupe_qpv .Table de relation entre les bâtiments de la BDNB et les éléments de la table QPV	tables_sources	\N	0	table	open_data_lo	0	{"qpv"}
batiment_groupe_geospx	déprécié	Cette table contient des indications de fiabilité concernant l'association entre les bâtiments des Fichiers Fonciers et les bâtiments constructions, utilisée pour constituer les groupes de bâtiments de la BDNB.\
\
[TABLE DÉPRÉCIÉE] : cette table est dépréciée. Les indicateurs correspondants seront intégrés dans une nouvelle version des métriques de qualité d'appariement entre les emprises BD TOPO et les bâtiments fonciers.	batiment_groupe	\N	1	table	open_data_lo	0	{"bdnb"}
batiment_groupe_simulations_dvf	maintenu	Estimation des valeurs foncières rapportées au m² pour les logements situés à l’intérieur du bâtiment.  \
Cette estimation repose sur un modèle utilisant les valeurs foncières réelles des logements vendus dans le même IRIS.	batiment_groupe	simu_dvf	1	table	ayant_droit_simulation_dvf	0	{"bdnb"}
batiment_groupe	maintenu	Groupes de bâtiments au sens de la BDNB.\
\
Un groupe de bâtiments est composé de 1 à *n* bâtiments fonciers et de 1 à *m* bâtiments constructions.  \
Ces entités sont créées pour minimiser *n* et *m*, afin de produire des groupes aussi précis que possible, tout en garantissant une adéquation entre :\
- le contenant : enceintes physiques des bâtiments (`batiment_construction`),\
- et le contenu : bâtiments fonciers qui documentent usages, surfaces et nombre de locaux.\
\
Un groupe de bâtiments est toujours situé sur une même unité foncière (ensemble de parcelles adjacentes appartenant à un même propriétaire).\
\
Cette entité, qui assure la cohérence entre contenant et contenu, constitue le socle de la BDNB.  \
La majorité des informations présentes dans la base sont définies à cette échelle : `batiment_groupe`.	batiment_groupe	\N	1	table	open_data_lo	0	{"bdnb"}
rel_batiment_groupe_bdtopo_equ	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table equipement de la BDTOPO	tables_sources	\N	0	table	open_data_lo	0	{"bdtopo"}
rel_batiment_groupe_rnc	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table RNC	tables_sources	\N	0	table	open_data_lo	0	{"rnc"}
batiment_groupe_bdtopo_bat	maintenu	Cette table contient les informations attributaires disponibles dans la BD TOPO de l'IGN, couche bâti. Les données sont regroupées au niveau du groupe de bâtiments : altitude, hauteur et liste d'usages.	batiment_groupe	bdtopo_bat	1	table	open_data_lo	0	{"bdtopo"}
iris_contexte_geographique	maintenu	Contexte géographique des Iris	iris	\N	0	table	ayant_droit_bdnb_expert	0	{"bdnb"}
batiment_groupe_dpe_statistique_logement	maintenu	Données statistiques du nombre de DPE par étiquette sur un bâtiment de logement. Pour les étiquettes DPE de l'ancien arrêté qui ne sont plus en vigueur les colonnes sont suffixées par "arrete_2012"	batiment_groupe	dpe_mix_arrete	1	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
rel_batiment_groupe_dpe_tertiaire	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments des deux bases de données DPE tertiaire de l’ADEME (avant 2021 et après 2021).  \
\
Contrairement aux DPE logement, les deux bases sont ici compilées car aucune évolution réglementaire majeure n’a concerné les DPE tertiaires.  \
Il n’est donc pas nécessaire de filtrer entre ancien ou nouveau DPE tertiaire\
\
Cette table permet de faire le lien entre :\
- la table `batiment_groupe`,\
- et la table `dpe_tertiaire` (qui contient l’intégralité des DPE).\
-	tables_sources	\N	0	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
batiment_groupe_simulations_isb	expérimental	Table regroupant les indicateurs de surchauffe des bâtiments (ISB).\
\
Objectif :\
Cette table synthétise les indicateurs relatifs au risque de surchauffe des bâtiments. Elle est issue d’un produit de recherche et son contenu (colonnes, noms, données) peut évoluer. La méthodologie est disponible sur : [bdnb.io/documentation/predictions_isb_dh](https://bdnb.io/documentation/predictions_isb_dh) \
L'indicateur de surchauffe est calculé sur des logements représentatifs du bâtiment et est décliné pour trois typologies particulières de logements :\
\
- **Maison individuelle** : résultats dans les colonnes `maison_ou_collectif_dernier_etage`.\
- **Collectif résidentiel** :\
  - Dernier étage (influence toiture) → colonnes `maison_ou_collectif_dernier_etage`.\
  - Étage courant (sans influence toiture) → colonnes `collectif_etage_courant`.\
\
Un logement au dernier étage est généralement plus exposé à la surchauffe estivale qu’un logement en étage courant.\
\
Indicateur :\
Basé sur le **degré-heure (DH)** : temps passé au-dessus d’un seuil de température sur une année type.\
Pour chaque typologie, trois informations sont fournies :\
- `dh_moyen` : moyenne des DH issus des simulations.\
- `classe_plus_probable_dh` : classe de DH la plus probable (facilite la comparaison entre bâtiments).\
- `fiabilite_dh` : fiabilité des résultats.\
\
Interprétation :\
- DH élevé → risque d’inconfort estival important.\
- DH faible → faible risque d'inconfort.\
\
Méthodologie :\
- Basée sur la météo réglementaire RE2020 (référence canicule 2003).\
- Prédiction statistique issue de simulations thermiques dynamiques.\
- Prend en compte : performance thermique (isolation, inertie, protections solaires), configuration (orientation, traversant), îlots de chaleur urbains.\
- Hypothèse : gestion thermique optimale par les occupants (volets fermés le jour, ventilation nocturne).\
- N’inclut pas la climatisation.\
\
⚠️ **EXPERIMENTAL** : Table expérimentale, structure et champs susceptibles d’évoluer.	batiment_groupe	\N	1	table	ayant_droit_bdnb_expert	1	{"bdnb"}
sitadel	maintenu	Table de compilation des données Sitadel, cela inclut l'ensemble des demandes d'autorisation d'urbanisme (DAU) :\
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux, \
- permis de démolir (PD)\
- permis d'aménager (PA).	tables_sources	\N	0	table	open_data_lo	0	{"sitadel"}
batiment_groupe_indicateur_reseau_chaud_froid	maintenu	Indicateur de raccordement et de potentiel de raccordement aux réseaux de chaleur et de froid urbains construit à l'aide des données de "France Chaleur Urbaine" et les "Données Locales de l'Energie".\
Cette table permet d'identifier les bâtiments raccordés aux réseaux de chaleurs ainsi que les bâtiments à proximité de réseaux chaleurs. \
Pour les bâtiments à proximité de réseaux de chaleur, un indicateur est calculé de potentiel de raccordement de ce bâtiment au réseau de chaleur en fonction de données techniques sur le bâtiment\
pour plus d'informations voir la documentation (https://bdnb.io/documentation/indicateur_potentiel_raccordement_reseau_chaleur/)\
\
Dans cette table 3 notions de proximité aux réseaux de chaleurs sont distinguées :\
\
- la proximité aux réseaux de chaleur existants\
- la proximité à des réseaux en cours de construction\
- la présence dans un périmètre de développement de réseaux de chaleur	batiment_groupe	\N	1	table	open_data_lo	0	{"rcf","bdnb"}
rel_batiment_groupe_merimee	maintenu	[TABLE DEPRECIEE] : Table de relation entre les bâtiments de la BDNB et les éléments de la table merimee	tables_sources	\N	0	table	open_data_lo	0	{"merimee"}
batiment_groupe_rnc	maintenu	Informations issues de la base du registre national des copropriétés agrégées à l'échelle du groupe de bâtiment	batiment_groupe	rnc	1	table	open_data_lo	0	{"rnc"}
batiment_groupe_contrainte_opportunite_renovation	maintenu	Table de contraintes et d'opportunités à la rénovation. Cette table fournit des indicateurs pour évaluer le niveau de contraintes, d'opportunités et de faisabilité de certains gestes de rénovation en fonction de critères techniques et administratifs sur les bâtiments concernés. \
La table contient les indicateurs de faisabilité, contrainte ou opportunité ainsi que les critères qui ont permis d'évaluer ces indicateurs. \
Les indicateurs nommés "ayant_droit" dans cette table sont réputés plus fiables, car ils mobilisent des données foncières en complément des autres données.	batiment_groupe	\N	1	table	ayant_droit_bdnb_expert	0	{"bdnb","dpe_arrete_2012","dpe_arrete_2021","bdtopo","fichiers_fonciers"}
rel_batiment_groupe_adresse	maintenu	Table de relation entre les adresses et les groupes de bâtiments. Les relations entre adresses et groupes de bâtiments sont de type n-m complexes :\
- une adresse peut desservir plusieurs groupes de bâtiments,\
- un groupe de bâtiment peut être desservi par plusieurs adresses (par exemple, plusieurs cages d’escalier).\
\
Cette table constitue un pivot important de la BDNB. Elle permet notamment d’associer des données indexées à l’adresse aux groupes de bâtiments correspondants.\
\
Les associations entre adresses et groupes de bâtiments sont établies à partir :\
- d’intersections géométriques,\
- de rapprochements entre les adresses de la Base Adresse Nationale (BAN) et les adresses fiscales des bâtiments issus des Fichiers Fonciers\
\
Cette table permet de faire le lien entre :\
- la table `batiment_groupe`,\
- et la table `adresse`	adresse	\N	0	table	open_data_lo	0	{"bdnb","ban","arcep_imb"}
batiment_groupe_dvf	maintenu	Données des mutations issues des valeurs foncières agrégées à l'échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.\
les données sont des statistiques sur les transactions immobilières ayant eu lieue sur le bâtiment\
Cette table correspond à la version « ayants droit fichiers fonciers » de la table `batiment_groupe_dvf_open_statistique`.	batiment_groupe	dv3f	1	table	ayant_droit_dv3f	0	{"dv3f"}
proprietaire	maintenu	Données sur les propriétaires de bâtiment (issues des Fichiers Fonciers)\
Cette table est disponible en open data uniquement sur certaines colonnes pour les propriétaires fonciers diffusés dans le fichier des locaux sur les personnes morales de la DGFiP (la version open filtre sur la colonne `dans_majic_pm`)	proprietaire	\N	0	table	open_data_lo	0	{"fichiers_fonciers","majic_pm"}
batiment_groupe_dle_gaz_2020	déprécié	[TABLE DEPRECIEE] Données de consommations des DLE agrégées à l'échelle du bâtiment	batiment_groupe	dle_gaz_2020	1	table	open_data_lo	0	{"dle"}
rel_batiment_groupe_siren	maintenu	Table de relation entre les bâtiments de la BDNB et les siren des entreprises rattachées\
Cette table permet de distinguer deux relations entre une entreprise et un bâtiment \
\
- l'entreprise est propriétaire de locaux dans le bâtiment\
- l'entreprise dispose d'un établissement qu'elle exploite dans le bâtiment\
\
Cette table permet donc d'identifier rapidement l'ensemble des bâtiments possédé ou exploité par une personne morale précise pour réaliser des analyses de parc immobilier.	tables_sources	\N	0	table	ayant_droit_bdnb_expert	0	{"sirene","fichiers_fonciers","majic_pm","bdnb"}
local_simulations_dpe	maintenu	Cette table contient les étiquettes DPE estimées pour chaque appartement situé dans un immeuble de logements collectifs.  \
Elle reprend les mêmes indicateurs que la table `batiment_groupe_simulations_dpe`, mais calculés à l’échelle du logement.  \
\
Un indicateur supplémentaire, `position_logement`, estime la position du logement dans le bâtiment :\
- étage intermédiaire,\
- sous un plancher haut déperditif (sous toiture),\
- sur un plancher bas déperditif (rez-de-chaussée).\
\
Cette table permet d’apprécier la variabilité des étiquettes DPE au sein d’un même immeuble et de modéliser notamment les logements sous toiture, généralement moins performants.\
\
⚠️ Cette table contient deux types de données :\
- les données de maximum a posteriori (ex. `etiquette_dpe_initial_map`), qui fournissent l’étiquette la plus probable pour chaque logement. Ces données sont adaptées à une lecture individuelle mais **ne doivent pas être utilisées pour des analyses statistiques** ;\
- les colonnes de probabilité détaillées (`etiquette_dpe_initial_a`, `..._b`, `..._c`, etc.), qui permettent une **représentation statistique fiable** de la distribution des étiquettes sur un parc ou à l’échelle territoriale.\
\
Plus d’informations sur nos prédictions DPE : https://bdnb.io/documentation/predictions_dpe/\
\
Cette table ne contient des informations que pour les bâtiments résidentiels collectifs.  \
Pour les maisons individuelles, l’estimation à l’échelle logement est identique à celle à l’échelle bâtiment. Il est donc recommandé d’utiliser directement les données de `batiment_groupe_simulations_dpe` pour ces cas.	batiment	\N	0	table	ayant_droit_simulation_dpe	0	{"bdnb"}
batiment_groupe_simulations_dpe	maintenu	Simulations réalisées par le CSTB des étiquettes DPE estimées pour les bâtiments de logement en France. Les résultats sont accompagnés d’indicateurs, principalement sous forme de probabilités.\
\
Les étiquettes DPE estimées dans cette table sont calculées à l’échelle du bâtiment :\
- pour les maisons individuelles, il s’agit d’une estimation de l’étiquette DPE propre à la maison,\
- pour les logements collectifs, l’estimation concerne l’immeuble dans son ensemble.\
\
⚠️ Cette table contient deux types de données :\
- les données de maximum a posteriori (ex. `etiquette_dpe_initial_map`), qui fournissent l’étiquette la plus probable pour chaque bâtiment. Ces données sont adaptées à une lecture individuelle mais **ne doivent pas être utilisées pour des analyses statistiques** ;\
- les colonnes de probabilité détaillées (`etiquette_dpe_initial_a`, `..._b`, `..._c`, etc.), qui permettent une **représentation statistique fiable** de la distribution des étiquettes sur un parc de bâtiments ou sur une échelle territoriale donnée.\
\
Plus d'informations sur nos predictions DPE ici : https://bdnb.io/documentation/predictions_dpe/\
\
⚠️ depuis la 2025-07a : les prédictions DPE sont calculées avec la nouvelle règle de coefficient d'énergie primaire de 1.9 pour l'électricité ce qui entraine une baisse notoire du nombre de passoires thermique et une amélioration globale des performances des bâtiments selon l'indicateur DPE.	batiment_groupe	simu_dpe	1	table	ayant_droit_simulation_dpe	0	{"bdnb"}
batiment_construction	maintenu	Enceinte physique des différentes géométries qui composent le groupe de bâtiments. Ces enceintes sont des géométries 2D extrudées en hauteur.\
\
Les bâtiments constructions proviennent de la BD TOPO de l’IGN et sont retraités par le CSTB, principalement pour les mettre en cohérence avec le découpage parcellaire du cadastre.	batiment_construction	\N	0	table	open_data_lo	0	{"bdnb","bdtopo"}
rel_batiment_construction_rnb	expérimental	Table de relation entre les bâtiments construction de la BDNB et les entités du RNB (Référentiel National des Bâtiments), limitée à l’hexagone.\
\
Dans la grande majorité des cas, un identifiant RNB correspond à un bâtiment construction de la BDNB, en raison de l’initialisation partielle du RNB à partir des données BDNB (relation 1 pour 1).\
\
EXPERIMENTAL : Cette table est expérimentale. Une intégration plus poussée du RNB dans la BDNB est en cours, et la structure de cette relation est susceptible d’évoluer.	tables_sources	\N	0	table	open_data_lo	1	{"rnb","bdtopo","bdnb"}
rel_batiment_groupe_rpls	maintenu	Table de relation entre les bâtiments de la BDNB et les identifiants du RPLS \
Cette table est à destination d'acteurs publique qui veulent localiser les logements RPLS sur leur territoire.	tables_sources	\N	0	table	ayant_droit_rpls	0	{"rpls"}
batiment_groupe_dvf_open_statistique	maintenu	Données des mutations issues des valeurs foncières agrégées à l'échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.\
les données sont des statistiques sur les transactions immobilières ayant eu lieue sur le bâtiment\
Cette table correspond à la version  « open_data » de la table `batiment_groupe_dvf`.	batiment_groupe	dvf_open	1	table	open_data_lo	0	{"dvf_open"}
batiment_groupe_dpe_tertiaire	maintenu	Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l'ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd'hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l'ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d'une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d'information disponible est fortement réduit par rapport aux DPE logements.\
La table batiment_groupe_dpe_tertiaire ne conserve que le DPE tertiaire non vierge le plus récent associé à un groupe de bâtiments ou le dernier DPE vierge si le groupe de bâtiments n'est associé à aucun DPE non vierge	batiment_groupe	dpe_ter	1	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
batiment_groupe_imputation_enveloppe_et_systemes_proba	expérimental	Cette table fournit un bilan statistique agrégé des données imputées de manière probabiliste sur l’enveloppe et les systèmes énergétiques des bâtiments, lorsqu’une information est manquante dans les données d’entrée utilisées pour la prédiction du DPE.\
L’agrégation s’effectue au niveau du groupe de bâtiments. Pour chaque groupe, la table restitue les probabilités estimées associées aux différentes modalités de certains paramètres clés, comme le type de système de chauffage ou le niveau d’isolation.\
Elle permet notamment de retrouver les probabilités associées à chaque modalité prédite pour un paramètre (ex. : la probabilité que le générateur de chauffage principal soit électrique au gaz, au fioul, etc.).\
Pour les grandeurs numériques comme la performance du niveau d'isolation du mur (u_mur_exterieur), il est fourni la moyenne, et les bornes à 95% de la distribution statistique, ainsi qu'une valeur aléatoire issue du tirage de la distribution.\
Important : toutes les valeurs présentes dans cette table sont issues de modèles d’imputation probabiliste. Elles représentent des estimations, et doivent être interprétées avec précaution, en gardant à l’esprit leur nature incertaine.\
Comment utiliser cette table :  \
\
colonnes de type "_top" : ces données permettent d'imputer des données d'enveloppe et systèmes les plus probables sur un bâtiment précis. Le cas d'usage de ces variables est de pouvoir initier des approches d'audit du bâtiment en l'absence d'information. elles ne doivent jamais être utilisée à des fins de statistiques\
colonnes de type "_random" : elle correspondent à un tirage aléatoire parmi les 100 tirages réalisé par méthode de monte carlo sur le bâtiment. L'ensemble des colonnes "_random" sont cohérentes entre elles et correspondent au même tirage. Le cas d'usage est de pouvoir faire des statistiques à grande échelle de problème complexe. Elles ne sont pas à utiliser pour analyser chaque bâtiment individuellement.\
colonnes probabilistes détaillées : ces colonnes sont des statistiques des 100 tirages réalisés. elles peuvent être utilisées pour faire des statistiques ou traiter des données à la maille de chaque bâtiment pour des problèmes comme "identifier les bâtiments avec la probabilite de chauffage au fioul les plus importants"\
\
NB : Lorsque l'information est connue via un DPE existant ou d'autres sources de données, l'ensemble des informations sera déterministe dans cette table (ex. si le DPE renseigne chaudière fioul standard,  type_generateur_chauffage_top = chaudiere fioul standard, type_generateur_chauffage_random = 'chaudiere fioul standard' et la probabilité type_generateur_chauffage_chaudiere_fioul_standard=1 )\
NB : les colonnes de type top, mean , upper, lower ne sont pas à utiliser pour faire des statistiques sur plusieurs bâtiments.\
\
EXPERIMENTAL : cette table est expérimentale, à ce titre, nous ne garantissons pas de stabilité sur la définition des champs produits par cette table qui pourront être amenés à évoluer.	batiment_groupe	\N	0	table	ayant_droit_bdnb_expert	1	{"bdnb"}
batiment_groupe_synthese_systeme_energetique_tertiaire	maintenu	Table de synthèse des informations sur les systèmes énergétiques présents dans le bâtiment (chauffage, eau chaude sanitaire, climatisation).  \
Elle compile :\
- les données des DPE de l’ADEME,\
- les données locales de l’énergie\
- les informations de raccordement à un réseau de chaleur (france chaleur urbaine)\
\
Attention, Ces informations concernent uniquement les bâtiments à usage tertiaire.	batiment_groupe	systeme_energetique_ter	1	table	ayant_droit_bdnb_expert	0	{"dpe_arrete_2012","dpe_arrete_2021","dle","rcf"}
batiment_groupe_merimee	déprécié	[TABLE DEPRECIEE] : Informations Mérimée (bâtiments classés aux Monuments Historiques) agrégées à l'échelle du bâtiment. Cette table est dépréciée au profit de `batiment_groupe_urbanisme`.	batiment_groupe	merimee	1	table	open_data_lo	0	{"merimee"}
rel_batiment_groupe_usage	maintenu	Table contenant l’ensemble des usages détaillés de chaque bâtiment, avec leurs surfaces et nombre de locaux associés (si disponibles).\
\
Sources :\
Cette table compile des informations issues :\
- des fichiers fonciers,\
- de la BDTOPO (zones d’activité),\
- de la base SIRENE (entreprises),\
- du RPLS\
- et de nombreuses bases recensant des usages publics des bâtiments, harmonisées dans le cadre du projet collaboratif ESPACE avec le CEREMA :\
  - annuaire de l’administration,\
  - base des équipements sportifs,\
  - annuaire de l’éducation,\
  - base FINESS (ministère de la santé),\
  - patrimoine immobilier de l’enseignement supérieur,\
  - base BASILIC (lieux et équipements culturels),\
  - crèches,\
  - gares ferroviaires.\
\
Logique :\
- Les usages sont ordonnés par priorité pour déterminer l’usage dominant des bâtiments multi-usages.\
- Priorité basée sur :\
  - la surface occupée (bâti privé),\
  - une liste ordonnée d’usages prioritaires pour le bâti public (souvent mal documenté en termes d'usage et de surfaces dans les fichiers fonciers)\
\
Utilisation :\
Cette table permet :\
- d’identifier tous les bâtiments pour un usage donné,\
- de réaliser des analyses par usage détaillé (ex. identifier les bâtiments d’écoles élémentaires publiques).\
\
- pour plus d'informations sur cette table, vous pouvez consulter l'article dédié sur notre site (https://bdnb.io/documentation/usage_detaille_bdnb/)	batiment_groupe	\N	0	table	ayant_droit_bdnb_expert	0	{"fichiers_fonciers","rnc","rpls","bdtopo","sirene","merimee","aen","pies","finess","es","adm"}
rel_batiment_groupe_bdtopo_bat	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table bâti de la BDTOPO	tables_sources	\N	0	table	open_data_lo	0	{"bdtopo"}
parcelle_unifiee_metrique	maintenu	Table de statistique sur le nombre d'entités rattachées à la parcelle unifiée ou TUP on retrouve notamment le nombre de :\
- batiments fonciers\
- batiments construction\
- adresses\
- batiment groupe \
- parcelles\
\
Cette table permet d'apprécier la complexité de correspondances qu'il peut y avoir entre plusieurs référentiels de données au sein de chaque unité foncière.	parcelle	\N	0	table	ayant_droit_ffo	0	{"fichiers_fonciers"}
batiment_groupe_dvf_open_representatif	maintenu	Données des mutations issues des valeurs foncières agrégées à l'échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.\
\
Les données correspondent à la transaction représentative des transactions de locaux ayant eu lieu sur ce bâtiment. \
Le local représentatif est un logement (en cas de bâtiment mixte) choisi pour représenter le type de logement le plus fréquent (basé sur le nombre de pièces).\
La transaction la plus récente correspondant à ce logement est remontée dans cette table.\
\
Cette table correspond à la version « open_data » de la table `batiment_groupe_dvf_logtype`.	batiment_groupe	dvf_open	1	table	open_data_lo	0	{"dvf_open"}
parcelle_unifiee	maintenu	Table d'information sur les parcelle unifiées ou TUP. une TUP est un ensemble de parcelles adjacentes appartenant à un même groupe de propriétaires. Pour plus d'informations se référer à la documentation des fichiers fonciers (https://doc-datafoncier.cerema.fr/doc/guide/ff/le-foncier-non-bati-parcelle-suf-unite-fonciere-tup)\
la TUP ou parcelle unifiée est l’entité englobante des groupes de bâtiments.\
\
Dans des cas très marginaux, nous avons dû compléter cette table des TUP avec des parcelles issues du PCI vecteur (https://cadastre.data.gouv.fr/datasets) afin d'assurer que tout groupe de bâtiments dans la BDNB disposait d'une assise parcellaire.\
Ces parcelles sont identifiées avec origine = 'Cadastre' dans la table	parcelle	\N	0	table	ayant_droit_ffo	0	{"fichiers_fonciers"}
batiment_groupe_ffo_bat	maintenu	Données issues du traitement des fichiers fonciers pour ce bâtiment.\
\
Caractéristiques :\
- Les quantitatifs (nombre de locaux, surfaces) sont calculés comme la somme des locaux et de leurs surfaces sur l’ensemble des bâtiments fonciers idbat constitutifs du groupe de bâtiments de la BDNB.\
- Les données d’usages sont une synthèse des différents usages identifiés dans les fichiers fonciers.\
\
⚠️ Recommandation :\
Pour l’usage des bâtiments, il est désormais conseillé d’utiliser la table `batiment_groupe_synthese_propriete_usage`, qui corrige les usages en intégrant des données complémentaires, notamment pour les bâtiments publics.	batiment_groupe	ffo_bat	1	table	open_data_lo	0	{"fichiers_fonciers"}
batiment_groupe_synthese_propriete_usage	maintenu	Table de synthèse des informations de propriété et d’usage des bâtiments.\
\
Sources :\
Cette table consolide les données issues de multiples sources :\
- RPLS\
- Fichiers fonciers\
- Registre des copropriétés\
- ESPACE (projet de géolocalisation des établissements publics en partenariat avec le CEREMA)\
- Fichier locaux des personnes morales de la DGFiP\
- SIRENE\
\
Objectif :\
Fournir les informations principales sur la propriété et l’usage des groupes de bâtiments.\
\
NB : Cette table introduit le nouvel indicateur `usage_principal_bdnb_open`, qui remplace l’ancienne variable `usage_niveau_1_txt` issue des seuls fichiers fonciers.  \
Il est recommandé d’utiliser `usage_principal_bdnb_open` à la place de la donnée foncière brute.	batiment_groupe	\N	1	table	open_data_lo	0	{"fichiers_fonciers","rnc","rpls","bdtopo","sirene","merimee","aen","pies","finess","es","adm"}
batiment_groupe_adresse	maintenu	Cette table fournit des informations résumées sur le groupe de bâtiments par rapport aux adresses qui y sont rattachées.\
\
On y retrouve le nombre d’adresses associées au groupe de bâtiments, ainsi que l’adresse principale, définie comme celle associée au plus grand nombre de locaux pour ce groupe.\
\
Si vous souhaitez associer des données référencées à l’adresse aux groupes de bâtiments de la BDNB, nous recommandons d’utiliser `rel_batiment_groupe_adresse` afin de prendre en compte l’ensemble des adresses associées au groupe de bâtiments.	batiment_groupe	\N	1	table	open_data_lo	0	{"ban","arcep_imb"}
siren	maintenu	Cette table est un croisement de plusieurs bases documentant des entreprises enregistrées dans SIREN. Il s'agit donc d'une base SIREN "enrichie"\
Dans cette table, il est documenté les éléments suivants \
\
- l'entreprise est un bailleur social identifié dans le RPLS\
- l'entreprise est une personne morale propriétaire de bâtiments dans les fichiers fonciers	tables_sources	\N	0	table	ayant_droit_bdnb_expert	0	{"sirene"}
rel_batiment_groupe_proprietaire	maintenu	Table de relation entre les propriétaires fonciers et les groupes de bâtiments.\
\
Les données foncières sur les propriétaires sont disponibles en open data uniquement pour les personnes morales.\
Seuls les propriétaires présents dans le fichier MAJIC personnes morales sont inclus dans la version open data (filtrage via la colonne `dans_majic_pm`).\
\
Cette table établit le lien entre :\
- la table `batiment_groupe` ,\
- et la table `proprietaire`	proprietaire	\N	0	table	open_data_lo	0	{"fichiers_fonciers","majic_pm"}
rel_batiment_adresse	maintenu	Table de relation entre les adresses et les bâtiments issus des fichiers fonciers.\
\
Cette table est construite en associant les adresses foncières aux adresses BAN/ARCEP.\
Elle correspond au sous-ensemble d’adresses liées à un groupe de bâtiments, déterminé par la localisation du bâtiment foncier au sein d’une même unité foncière.\
\
Cette table détaillée est à destination d'utilisateurs avancés des fichiers fonciers et nous recommandons d'utiliser rel_batiment_groupe_adresse pour un usage classique de relations entre adresses et bâtiments.	adresse	\N	0	table	ayant_droit_ffo	0	{"fichiers_fonciers","ban"}
batiment_groupe_dle_reseaux_2020	déprécié	[TABLE DEPRECIEE] Données de consommations des DLE agrégées à l'échelle du bâtiment	batiment_groupe	dle_reseaux_2020	1	table	open_data_lo	0	{"dle"}
batiment_groupe_dpe_representatif_logement	maintenu	Table qui contient les DPE représentatifs de chaque bâtiment de logement. Le DPE représentatif est soit un DPE issu de l'ancien arrêté qui n'est plus en vigueur (arrêté 2012) ou d'un nouveau DPE (arrêté 2021). Pour filtrer ancien et nouveau DPE utiliser le booléen `arrete_2021`\
\
⚠️ Cette table fournit une synthèse du DPE représentatif du bâtiment.  \
Pour plus d’informations sur la méthode de détermination du DPE représentatif :  \
[https://bdnb.io/documentation/methode_traitement_dpe/](https://bdnb.io/documentation/methode_traitement_dpe/)\
\
Pour consulter l'ensemble des DPE de logements rattachés à un bâtiment,il faut utiliser les tables : \
\
- `dpe_logement`\
- `rel_batiment_groupe_dpe_logement`	batiment_groupe	dpe_mix_arrete	1	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
batiment_groupe_rpls	maintenu	Informations issues du répertoire des logements sociaux agrégées au niveau du groupe de bâtiment BDNB.	batiment_groupe	rpls	1	table	open_data_lo	0	{"rpls"}
parcelle_sitadel	maintenu	Informations consolidées et simplifiées à l'échelle de la parcelle des données SITADEL. Cette table fournit des données numériques et \
catégorielles synthétiques sur les demandes d'autorisation d'urbanisme (DAU) déclarées pour chaque parcelle. Une \
analyse complémentaire vérifie l'actualisation de certaines données de la BDNB, telles que la surface, le nombre de \
locaux, l'année de construction. Si ces éléments ne correspondent pas aux dernières autorisations d'urbanisme \
disponibles, cela indique que la BDNB n'est pas à jour pour cette parcelle.\
**ATENTION** Ne pas faire des statistiques agregées sur cette table, les valeurs numériques sont données à titre \
indicatif. Pour des statistiques utiliser la table `sitadel`. En effet, une demande d'autorisation d'urbanisme peut concerner plusieurs parcelles et peut donc être répétée dans cette table.\
\
NB : les données sitadel ne sont pas fournies au niveau des groupes de bâtiments comme les autres informations métiers de la BDNB car elles concernent des opérations ayant pour objet la démolition ou la construction de bâtiments et concernent majoritairement des bâtiments qui n'existent pas encore ou n'existent plus.	parcelle	\N	0	table	open_data_lo	0	{"sitadel"}
batiment_groupe_bpe	maintenu	Agrégation des informations suivantes issues de la Base Permanente des Équipements (BPE) de l'INSEE, à l’échelle du groupe de bâtiments :\
- le type d’équipement.\
\
Les données sont fournies sous forme de listes agrégées.	batiment_groupe	bpe	1	table	open_data_lo	0	{"bpe"}
rel_batiment_groupe_dvf_open	maintenu	Table de relation entre les batiment_groupe de la BDNB et l'ensemble des mutations ayant eu lieu sur ce bâtiment groupe\
Les mutations foncières sont identifiées par leur identifiant open_data diffusé dans le jeu de données du CEREMA DVF+ open data(https://datafoncier.cerema.fr/donnees/autres-donnees-foncieres/dvfplus-open-data)	tables_sources	\N	0	table	open_data_lo	0	{"dvf_open"}
rel_batiment_groupe_bpe	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table bpe	tables_sources	\N	0	table	open_data_lo	0	{"bpe"}
batiment_groupe_dvf_logtype	maintenu	Données des mutations issues des valeurs foncières agrégées à l'échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.\
\
Les données correspondent à la transaction représentative des transactions de locaux ayant eu lieu sur ce bâtiment. \
Le local représentatif est un logement (en cas de bâtiment mixte) choisi pour représenter le type de logement le plus fréquent (basé sur le nombre de pièces).\
La transaction la plus récente correspondant à ce logement est remontée dans cette table.\
\
Cette table correspond à la version « ayants droit fichiers fonciers » de la table `batiment_groupe_dvf_open_representatif`.	batiment_groupe	dv3f	1	table	ayant_droit_dv3f	0	{"dv3f"}
iris_simulations_valeur_verte	maintenu	Simulation des gains en valeur foncière liés à un potentiel changement de classe DPE estimée sur une IRIS (en valeur relative).  \
Cette estimation repose sur :\
- un modèle utilisant les valeurs foncières réelles des logements vendus dans le même IRIS,\
- les prédictions DPE issues de la table `batiment_groupe_simulations_dpe`.	iris	\N	0	table	ayant_droit_valeur_verte	0	{"bdnb"}
batiment_groupe_dle_gaz_multimillesime	maintenu	Données de consommations des données locales de l'énergie du SDES pour le vecteur gaz agrégées à l'échelle du bâtiment (2018-2024)\
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation depuis 2018)	batiment_groupe	\N	0	table	open_data_lo	0	{"dle"}
dpe_tertiaire	maintenu	Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l'ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd'hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l'ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d'une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d'information disponible est fortement réduit par rapport aux DPE logements.	tables_sources	\N	0	table	open_data_lo	0	{"dpe_arrete_2012","dpe_arrete_2021"}
rel_parcelle_sitadel	maintenu	Table de relation entre les identifiants des parcelles et les identifiants de demande d'autorisation d'urbanisme (DAU)\
de la base de données Sitadel.	tables_sources	\N	0	table	open_data_lo	0	{"sitadel","cadastre"}
parcelle	maintenu	Table contenant les informations sur les parcelles cadastrales.\
\
Un groupe de bâtiments peut être situé sur une ou plusieurs parcelles cadastrales.\
Cependant, un groupe de bâtiments ne peut pas appartenir à plusieurs unités foncières différentes (une unité foncière regroupe des parcelles appartenant au même propriétaire).\
\
Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.	parcelle	\N	0	table	open_data_lo	0	{"cadastre"}
rel_batiment_construction_adresse	maintenu	Table de relation entre les adresses postales BAN/Arcep et les entrées de la table [batiment_construction]. \
Cette table détaillée permet de descendre en précision sur les associations entre batiments et adresses, la proximité entre le batiment_construction de la BDNB et les identifiants RNB permet notamment grâce à cette table et rel_batiment_construction_rnb d'associer des adresses au référentiel national des bâtiments.\
\
Cette table permet de faire le lien entre :\
- la table `batiment_groupe`,\
- et la table `adresse`	adresse	\N	0	table	open_data_lo	0	{"bdtopo","bdnb","ban"}
batiment_groupe_dle_elec_2020	déprécié	[TABLE DEPRECIEE] Données de consommations des DLE agrégées à l'échelle du bâtiment	batiment_groupe	dle_elec_2020	1	table	open_data_lo	0	{"dle"}
batiment_groupe_risques	maintenu	Table regroupant différents indicateurs de risques (sismique, incendie, radon et argile) associés aux batiment_groupe de la BDNB. Les aléas sismiques, radon et argiles proviennent des zonages issus du site georisques. Les catégories de familles incendies proviennent d'une prédiction simplifiée de la réglementation risque incendie (sur le résidentiel uniquement). Enfin, les catégories de bâtiments associées au risque sismique correspondent à des travaux similaires au risque incendie (sur le résidentiel uniquement).	batiment_groupe	\N	1	table	open_data_lo	0	{"radon","argiles"}
batiment_groupe_enepdl	déprécié	Données de consommations des PDL Enedis agrégées à l'échelle du bâtiment	batiment_groupe	\N	0	table	ayant_droit_enedis	0	{"enepdl"}
batiment_groupe_enethermo	déprécié	Données de consommation Enedis agrégées à l'échelle du bâtiment	batiment_groupe	\N	0	table	ayant_droit_enedis	0	{"thermosensibilite"}
batiment_groupe_bdtopo_zoac	maintenu	Agrégation des informations suivantes issues des zones d'activités de la BD TOPO de l'IGN (couche ZOA) qui intersectent les groupes de bâtiments :\
- la nature de la zone d'activité,\
- le toponyme associé.\
\
Les données sont fournies sous forme de listes agrégées.	batiment_groupe	bdtopo_zoa	1	table	open_data_lo	0	{"bdtopo"}
batiment	maintenu	Bâtiments au sens des Fichiers Fonciers, correspondant aux [idbat](https://doc-datafoncier.cerema.fr/doc/ff/batiment/idbat) présents dans la base de données du CEREMA lorsque `origine = 'Fichiers Fonciers'`.\
\
Des entrées supplémentaires issues de la table [batiment_groupe] sont ajoutées pour représenter des bâtiments non référencés dans les Fichiers Fonciers (`origine = 'Association géométrique'`). Cela correspond à des bâtiments localisés sur des parcelles absentes des Fichiers Fonciers.	batiment	\N	0	table	ayant_droit_ffo	0	{"fichiers_fonciers"}
rel_batiment_groupe_parcelle	maintenu	Table de relation entre les groupes de bâtiments et les parcelles (relation n-m) :\
- Une parcelle peut contenir plusieurs groupes de bâtiments.\
- Un groupe de bâtiments peut être situé sur plusieurs parcelles.\
\
Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.	parcelle	\N	0	table	open_data_lo	0	{"cadastre"}
rel_batiment_groupe_pie	maintenu	Table de relation entre les bâtiments de la BDNB et les éléments de la table PIE	tables_sources	\N	0	table	ayant_droit_pie	0	{"pie"}
\.
CREATE INDEX "adresse_geom_adresse_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."adresse" USING GIST ("geom_adresse");
CREATE INDEX "rel_batiment_constr_geom_batiment_construction_adresse_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_adresse" USING GIST ("geom_batiment_construction_adresse");
CREATE INDEX "rel_batiment_groupe_adresse_geom_bat_adresse_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."rel_batiment_groupe_adresse" USING GIST ("geom_bat_adresse");
CREATE INDEX "batiment_construction_geom_cstr_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."batiment_construction" USING GIST ("geom_cstr");
CREATE INDEX "batiment_groupe_geom_groupe_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."batiment_groupe" USING GIST ("geom_groupe");
CREATE INDEX "parcelle_geom_parcelle_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."parcelle" USING GIST ("geom_parcelle");
CREATE INDEX "rel_batiment_construction_rnb_geom_rnb_pos_geom_idx" ON "bdnb_2025_07_a_open_data_dep01"."rel_batiment_construction_rnb" USING GIST ("geom_rnb_pos");
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.adresse is 'Table de description des adresses. Les adresses dans la BDNB sont le sous-ensemble des adresses BAN de type `housenumber` (adressage au numéro) et uniquement localisé en France hexagonale et Corse. Des adresses ARCEP viennent compléter les adresses BAN quand ces adresses n''existent pas dans la BAN. Les géolocalisants ponctuels sont au format Lambert-93 (ESPG:2154).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.numero is 'Numéro de l''adresse';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.rep is 'Indice de répétition du numéro de l''adresse';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.type_voie is 'Type de voie';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.nom_voie is 'Nom de la voie';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.libelle_adresse is 'Libellé complet de l''adresse';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.code_postal is 'Code postal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.libelle_commune is 'Libellé de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.source is 'source de l''adresse BAN ou ARCEP';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse.geom_adresse is 'Géométrie de l''adresse (Lambert-93)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.adresse_metrique is 'Métriques des adresses. Cette table permet d’identifier le nombre de bâtiments desservis par une même adresse. Elle facilite ainsi la distinction entre :
- les adresses mono-bâtiment,
- les adresses desservant plusieurs bâtiments sur une même unité foncière,
- et les adresses plus problématiques desservant plusieurs unités foncières distinctes.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse_metrique.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse_metrique.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse_metrique.nb_bat_grp is 'Nombre de bâtiments desservis par l''adresse';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.adresse_metrique.nb_bat_grp_hors_dep is 'Nombre de bâtiments (hors dépendances) desservis par l''adresse';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse is 'Table de relation entre les adresses postales BAN/Arcep et les entrées de la table [batiment_construction]. 
Cette table détaillée permet de descendre en précision sur les associations entre batiments et adresses, la proximité entre le batiment_construction de la BDNB et les identifiants RNB permet notamment grâce à cette table et rel_batiment_construction_rnb d''associer des adresses au référentiel national des bâtiments.

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `adresse`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.distance_batiment_construction_adresse is 'Distance entre le géolocalisant adresse et la géométrie de bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.fiabilite is 'Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :

Critères et pondérations :

- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2
- cond_2 : l''adresse est une adresse BAN → +1
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1

Échelle du score :
- Minimum : 0 (aucune condition vérifiée)
- Maximum : 20 (toutes les conditions vérifiées)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.adresse_principale is 'Booléen précisant si l''adresse courante est l''une des adresses principales de la construction ou non. Une relation est taguée comme `principale` si l''adresse qui la compose obtient le score de fiabilité le plus important parmi toutes les adresses desservant une même construction. Il se peut, par conséquent, qu''une construction ait plusieurs adresses principales : toutes celles ayant le score de fiabilité le plus haut pour cette construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse.geom_batiment_construction_adresse is 'Géolocalisant du trait reliant le point adresse à la géométrie de la construction (Lambert-93, SRID=2154)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse is 'Table de relation entre les adresses et les groupes de bâtiments. Les relations entre adresses et groupes de bâtiments sont de type n-m complexes :
- une adresse peut desservir plusieurs groupes de bâtiments,
- un groupe de bâtiment peut être desservi par plusieurs adresses (par exemple, plusieurs cages d’escalier).

Cette table constitue un pivot important de la BDNB. Elle permet notamment d’associer des données indexées à l’adresse aux groupes de bâtiments correspondants.

Les associations entre adresses et groupes de bâtiments sont établies à partir :
- d’intersections géométriques,
- de rapprochements entre les adresses de la Base Adresse Nationale (BAN) et les adresses fiscales des bâtiments issus des Fichiers Fonciers

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `adresse`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.origine is 'Origine de l''entrée bâtiment. Elle provient soit des données foncières (Fichiers Fonciers), soit d''un croisement géospatial entre le Cadastre, la BDTopo et des bases de données métiers (ex: BPE ou Mérimée)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.fiabilite is 'Le score de fiabilité d''une relation batiment_groupe avec une adresse est le maximum de la fiabilité des associations adresses batiment construction correspondantes.

Le score de fiabilité d’une relation Adresse ↔ Bâtiment Construction (BC) est calculé comme la somme pondérée des conditions suivantes (valeurs booléennes : 0 ou 1) :

Critères et pondérations :

- cond_4 : L’adresse intersecte l’unité foncière du bâtiment → +5
- cond_3 : L’adresse est une adresse foncière d’un bâtiment situé sur l’unité foncière → +5
- cond_5 : Les clés d’interopérabilité BAN et FF correspondent → +3
- cond_1 : La position de l’adresse intersecte directement le bâtiment construction → +3
- cond_7 : L’adresse ne dessert qu’un seul bâtiment construction → +2
- cond_2 : l''adresse est une adresse BAN → +1
- cond_6 : L’adresse ne dessert qu’une seule unité foncière → +1

Échelle du score :
- Minimum : 0 (aucune condition vérifiée)
- Maximum : 20 (toutes les conditions vérifiées)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse.geom_bat_adresse is 'Géolocalisant du trait reliant le point adresse à la géométrie du bâtiment groupe (Lambert-93, SRID=2154)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_construction is 'Enceinte physique des différentes géométries qui composent le groupe de bâtiments. Ces enceintes sont des géométries 2D extrudées en hauteur.

Les bâtiments constructions proviennent de la BD TOPO de l’IGN et sont retraités par le CSTB, principalement pour les mettre en cohérence avec le découpage parcellaire du cadastre.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.code_iris is 'Code iris INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.s_geom_cstr is '(ign) Surface au sol de la géométrie de la construction [m²]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.hauteur is '(ign) Hauteur du bâtiment physique [m]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.altitude_sol is '(ign) Altitude moynne au pied du bâtiment physique [m]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.fictive_hauteur_cstr is '(ign) Variable renvoyant : "vrai" si la hauteur est fictive, "faux" elle correspond à une hauteur réelle';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.fictive_geom_cstr is '(ign) Variable renvoyant : "vrai" si la géométrie est fictive (et la surface au sol n''est pas réelle), "faux" elle correspond à une emprise au sol réelle';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_construction.geom_cstr is '(ign) Géométrie multipolygonale de l''enceinte du bâtiment (Lambert-93)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe is 'Groupes de bâtiments au sens de la BDNB.

Un groupe de bâtiments est composé de 1 à *n* bâtiments fonciers et de 1 à *m* bâtiments constructions.  
Ces entités sont créées pour minimiser *n* et *m*, afin de produire des groupes aussi précis que possible, tout en garantissant une adéquation entre :
- le contenant : enceintes physiques des bâtiments (`batiment_construction`),
- et le contenu : bâtiments fonciers qui documentent usages, surfaces et nombre de locaux.

Un groupe de bâtiments est toujours situé sur une même unité foncière (ensemble de parcelles adjacentes appartenant à un même propriétaire).

Cette entité, qui assure la cohérence entre contenant et contenu, constitue le socle de la BDNB.  
La majorité des informations présentes dans la base sont définies à cette échelle : `batiment_groupe`.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.s_geom_groupe is 'Surface au sol de la géométrie du bâtiment groupe (geom_groupe)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.code_iris is 'Code iris INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.libelle_commune_insee is '(insee) Libellé de la commune accueillant le groupe de bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.code_epci_insee is 'Code de l''EPCI';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.contient_fictive_geom_groupe is 'Vaut "vrai", si la géométrie du groupe de bâtiment est générée automatiquement et ne représente pas la géométrie du groupe de bâtiment.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe.geom_groupe is 'Géométrie multipolygonale du groupe de bâtiment (Lambert-93)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse is 'Cette table fournit des informations résumées sur le groupe de bâtiments par rapport aux adresses qui y sont rattachées.

On y retrouve le nombre d’adresses associées au groupe de bâtiments, ainsi que l’adresse principale, définie comme celle associée au plus grand nombre de locaux pour ce groupe.

Si vous souhaitez associer des données référencées à l’adresse aux groupes de bâtiments de la BDNB, nous recommandons d’utiliser `rel_batiment_groupe_adresse` afin de prendre en compte l’ensemble des adresses associées au groupe de bâtiments.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.cle_interop_adr_principale_ban is 'Clé d''interopérabilité de l''adresse principale (issue de la BAN)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.libelle_adr_principale_ban is 'Libellé complet de l''adresse principale (issue de la BAN)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.nb_adresse_valid_ban is 'Nombre d''adresses valides différentes provenant de la BAN qui desservent le groupe de bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.fiabilite_cr_adr_niv_1 is 'Fiabilité des données croisées à l''adresse (''données croisées à l''adresse fiables'', ''données croisées à l''adresse fiables à l''echelle de la parcelle unifiee'', ''données croisées à l''adresse moyennement fiables'', ''problème de géocodage'')';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse.fiabilite_cr_adr_niv_2 is 'Fiabilité détaillée des données croisées à l''adresse';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles is '[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l''aléa lié au retrait gonflement des argiles (RGA) agrégées à l''échelle du bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles.alea is '(argiles) Aléa du risque argiles';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat is 'Cette table contient les informations attributaires disponibles dans la BD TOPO de l''IGN, couche bâti. Les données sont regroupées au niveau du groupe de bâtiments : altitude, hauteur et liste d''usages.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.l_nature is '(ign) Catégorie de nature du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.l_usage_1 is '(ign) Usage principal du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.l_usage_2 is '(ign) Usage secondaire du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.l_etat is '(ign) Etat des bâtiments';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.hauteur_mean is '(ign) Hauteur moyenne des bâtiments [m]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.max_hauteur is '(ign) Hauteur maximale des bâtiments [m]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat.altitude_sol_mean is '(ign) Altitude au sol moyenne [m]';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ is 'Agrégation des informations suivantes issues des équipements de la BD TOPO de l''IGN (couche équipement) qui intersectent les groupes de bâtiments :
- la nature de l''équipement,
- le toponyme associé.

Les données sont fournies sous forme de listes agrégées.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ.l_nature is '(ign) Catégorie de nature du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ.l_nature_detaillee is '(ign) Catégorie détaillée de nature de l''équipement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ.l_toponyme is '(ign) Toponymie de l''équipement';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac is 'Agrégation des informations suivantes issues des zones d''activités de la BD TOPO de l''IGN (couche ZOA) qui intersectent les groupes de bâtiments :
- la nature de la zone d''activité,
- le toponyme associé.

Les données sont fournies sous forme de listes agrégées.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac.l_nature is '(ign) Catégorie de nature du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac.l_nature_detaillee is '(ign) Catégorie détaillée de nature de l''équipement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac.l_toponyme is '(ign) Toponymie de l''équipement';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe is 'Agrégation des informations suivantes issues de la Base Permanente des Équipements (BPE) de l''INSEE, à l’échelle du groupe de bâtiments :
- le type d’équipement.

Les données sont fournies sous forme de listes agrégées.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe.l_type_equipement is '(bpe) Liste des équipements recensés par la base BPE';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime is 'Données de consommations des données locales de l''énergie du SDES pour le vecteur éléctrique agrégées à l''échelle du bâtiment (2018-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.millesime is 'Millésime des données';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.nb_pdl_res is 'Nombre de points de livraisons résidentiel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.nb_pdl_pro is 'Nombre de points de livraisons professionel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.nb_pdl_tot is 'Nombre total de points de livraisons';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_res is 'Consommation résidentielle [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_pro is 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_tot is 'Consommation totale [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_res_par_pdl is 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_pro_par_pdl is 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime.conso_tot_par_pdl is 'Consommation totale par point de livraison  [kWh/pdl.an]';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime is 'Données de consommations des données locales de l''énergie du SDES pour le vecteur gaz agrégées à l''échelle du bâtiment (2018-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation depuis 2018)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.millesime is 'Millésime des données';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.nb_pdl_res is 'Nombre de points de livraisons résidentiel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.nb_pdl_pro is 'Nombre de points de livraisons professionel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.nb_pdl_tot is 'Nombre total de points de livraisons';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_res is 'Consommation résidentielle [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_pro is 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_tot is 'Consommation totale [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_res_par_pdl is 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_pro_par_pdl is 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime.conso_tot_par_pdl is 'Consommation totale par point de livraison  [kWh/pdl.an]';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime is 'Données de consommations des données locales de l''énergie du SDES pour le vecteur réseau de chaleur agrégées à l''échelle du bâtiment. (2020-2024)
ATTENTION : Cette table utilise une double clef primaire (batiment_groupe,millesime) et contient donc plusieurs lignes par batiment groupe (une par année de consommation)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.millesime is 'Millésime des données';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.nb_pdl_res is 'Nombre de points de livraisons résidentiel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.nb_pdl_pro is 'Nombre de points de livraisons professionel';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.nb_pdl_tot is 'Nombre total de points de livraisons';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_res is 'Consommation résidentielle [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_pro is 'Consommation professionnelle [kWh/an]. En cas d''adresse qui desservent plusieurs bâtiments la consommation est répartie sur chaque bâtiment en proportion de la surface de locaux professionnels.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_tot is 'Consommation totale [kWh/an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_res_par_pdl is 'Consommation résidentielle par point de livraison [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_pro_par_pdl is 'Consommation professionnelle par point de livraison  [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.conso_tot_par_pdl is 'Consommation totale par point de livraison  [kWh/pdl.an]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.identifiant_reseau is 'Identifiant du reseau de chaleur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime.type_reseau is 'type du réseau de chaleur';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement is 'Table qui contient les DPE représentatifs de chaque bâtiment de logement. Le DPE représentatif est soit un DPE issu de l''ancien arrêté qui n''est plus en vigueur (arrêté 2012) ou d''un nouveau DPE (arrêté 2021). Pour filtrer ancien et nouveau DPE utiliser le booléen `arrete_2021`

⚠️ Cette table fournit une synthèse du DPE représentatif du bâtiment.  
Pour plus d’informations sur la méthode de détermination du DPE représentatif :  
[https://bdnb.io/documentation/methode_traitement_dpe/](https://bdnb.io/documentation/methode_traitement_dpe/)

Pour consulter l''ensemble des DPE de logements rattachés à un bâtiment,il faut utiliser les tables : 

- `dpe_logement`
- `rel_batiment_groupe_dpe_logement`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.arrete_2021 is 'précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s''il s''agit d''un DPE issu de la modification antérieure de 2012.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_dpe is 'type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_batiment_dpe is 'défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d''information est un DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.periode_construction_dpe is 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.annee_construction_dpe is 'année de construction du logement évaluée par le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.version is 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.date_etablissement_dpe is 'date de l''établissement du dpe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.date_reception_dpe is 'date de réception du DPE dans la base de données de l''ADEME';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nombre_niveau_logement is 'nombre de niveaux du logement (maison ou appartement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nombre_niveau_immeuble is 'nombre de niveaux total de l''immeuble';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_habitable_immeuble is 'surface habitable totale de l''immeuble dans le cas d''un DPE appartement avec usage collectif ou d''un DPE immeuble.(surface habitable au sens du DPE)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_habitable_logement is 'surface habitable du logement renseignée sauf dans le cas du dpe à l''immeuble. (surface habitable au sens du DPE)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.conso_5_usages_ep_m2 is 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.conso_5_usages_ef_m2 is 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.emission_ges_5_usages_m2 is 'emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.classe_bilan_dpe is 'Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.classe_emission_ges is 'classe d''émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.classe_conso_energie_arrete_2012 is 'classe d''émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.classe_emission_ges_arrete_2012 is 'classe d''emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.conso_3_usages_ep_m2_arrete_2012 is 'consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.emission_ges_3_usages_ep_m2_arrete_2012 is 'emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012 (kgCO2/m2/an).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_installation_chauffage is 'type d''installation de chauffage (collectif ou individuel)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_energie_chauffage is 'type d''énergie pour le générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_chauffage is 'type de générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_chauffage_anciennete is 'ancienneté du générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_energie_chauffage_appoint is 'type d''énergie pour le générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_chauffage_appoint is 'type de générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_chauffage_anciennete_appoint is 'ancienneté du générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.chauffage_solaire is 'présence de chauffage solaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nb_generateur_chauffage is 'nombre de générateurs de chauffage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nb_installation_chauffage is 'nombre d''installation de chauffage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_energie_climatisation is 'type d''énergie pour le générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_climatisation is 'type de générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_climatisation_anciennete is 'ancienneté du générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_installation_ecs is 'type d''installation d''eau chaude sanitaire (ECS) (collectif ou individuel)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_energie_ecs is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_ecs is 'type de générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_ecs_anciennete is 'ancienneté du générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_energie_ecs_appoint is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_ecs_appoint is 'type de générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_generateur_ecs_anciennete_appoint is 'ancienneté du générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.ecs_solaire is 'présence d''ecs solaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nb_generateur_ecs is 'nombre de générateurs d''ecs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.nb_installation_ecs is 'nombre d''installation d''ecs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.plusieurs_facade_exposee is 'il est considéré dans le DPE qu''il y a plusieurs facades exposées au vent.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_ventilation is 'type de système de ventilation du logement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_production_energie_renouvelable is 'type de production ENR pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_vitrage is 'type de vitrage principal des baies vitrées du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_materiaux_menuiserie is 'type de matériaux principal des menuiseries des baies vitrées du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_gaz_lame is 'type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_fermeture is 'type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.epaisseur_lame is 'epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.vitrage_vir is 'le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d''un point de vue thermique.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_vitree_nord is 'somme de la surface de baies vitrées orientées nord du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_vitree_sud is 'somme de la surface de baies vitrées orientées sud du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_vitree_ouest is 'somme de la surface de baies vitrées orientées ouest du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_vitree_est is 'somme de la surface de baies vitrées orientées est du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_vitree_horizontal is 'somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.traversant is 'indicateur du côté traversant du logement.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_baie_vitree is 'Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.uw is 'Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.facteur_solaire_baie_vitree is 'facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.presence_balcon is 'présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.l_orientation_baie_vitree is 'liste des orientations des baies vitrées (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.pourcentage_surface_baie_vitree_exterieur is 'pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_isolation_mur_exterieur is 'type d''isolation principal des murs donnant sur l''extérieur pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.epaisseur_isolation_mur_exterieur_estim is 'epaisseur d''isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d''une épaisseur déclarée c''est directement l''épaisseur déclarée qui est considérée, dans le cas contraire l''épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.materiaux_structure_mur_exterieur is 'matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.epaisseur_structure_mur_exterieur is 'epaisseur moyenne de la partie structure du mur (sans l''isolation rapportée ni les doublages)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_mur_totale is 'somme de la surface de murs totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_mur_exterieur is 'somme de la surface  surface de murs donnant sur l''extérieur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_mur_deperditif is 'somme de la surface de murs donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_mur_exterieur is 'Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.l_local_non_chauffe_mur is 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.local_non_chauffe_principal_mur is 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.l_orientation_mur_exterieur is 'liste des orientations des murs donnant sur l''extérieur (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_isolation_plancher_bas is 'type d''isolation principal des planchers bas déperditifs pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_plancher_bas_deperditif is 'materiaux ou principe constructif principal des planchers bas';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_plancher_bas_totale is 'somme de la surface de plancher bas totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_plancher_bas_deperditif is 'somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_plancher_bas_final_deperditif is 'Coefficient de transmission thermique moyen des planchers bas en prenant en compte l''atténuation forfaitaire du U lorsqu''en contact avec le sol de la méthode 3CL(W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_plancher_bas_brut_deperditif is 'Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.l_local_non_chauffe_plancher_bas is 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.local_non_chauffe_principal_plancher_bas is 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_adjacence_principal_plancher_bas is 'type d''adjacence principale des planchers bas (sont ils en contact avec l''extérieur ou un local non chauffé)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_isolation_plancher_haut is 'type d''isolation principal des planchers hauts déperditifs pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_plancher_haut_deperditif is 'materiaux ou principe constructif principal des planchers hauts';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_plancher_haut_totale is 'somme de la surface de plancher haut totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_plancher_haut_deperditif is 'somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_plancher_haut_deperditif is 'Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.l_local_non_chauffe_plancher_haut is 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.local_non_chauffe_principal_plancher_haut is 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_adjacence_principal_plancher_haut is 'type d''adjacence principale des planchers haut (sont ils en contact avec l''extérieur ou un local non chauffé)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.type_porte is 'type de porte du DPE (enum version DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.surface_porte is 'somme de la surface de portes du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.u_porte is 'Coefficient de transmission thermique moyen des portes (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.classe_inertie is 'classe d''inertie pour le DPE (de légère à très lourde)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_mur is 'somme des déperditions par les murs du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_baie_vitree is 'somme des déperditions par les baies vitrées du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_plancher_bas is 'somme des deperditions par les planchers bas du logement (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_plancher_haut is 'somme des deperditions par les planchers hauts du logement (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_pont_thermique is 'somme des deperditions par les portes du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement.deperdition_porte is 'somme des deperditions par les portes du DPE (W/K)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement is 'Données statistiques du nombre de DPE par étiquette sur un bâtiment de logement. Pour les étiquettes DPE de l''ancien arrêté qui ne sont plus en vigueur les colonnes sont suffixées par "arrete_2012"';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_a is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe A';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_b is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe B';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_c is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe C';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_d is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe D';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_e is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe E';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_f is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe F';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_bilan_dpe_g is '(dpe) Nombre de DPE avec une étiquette bilan DPE (double seuil énergie/ges) de classe G';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_a is '(dpe) Nombre de DPE de la classe énergétique A. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_b is '(dpe) Nombre de DPE de la classe énergétique B. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_c is '(dpe) Nombre de DPE de la classe énergétique C. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_d is '(dpe) Nombre de DPE de la classe énergétique D. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_e is '(dpe) Nombre de DPE de la classe énergétique E. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_f is '(dpe) Nombre de DPE de la classe énergétique F. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_g is '(dpe) Nombre de DPE de la classe énergétique G. valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement.nb_classe_conso_energie_arrete_2012_nc is '(dpe) Nombre de DPE n''ayant pas fait l''objet d''un calcul d''étiquette énergie (DPE dits vierges). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire is 'Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l''ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l''ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d''une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d''information disponible est fortement réduit par rapport aux DPE logements.
La table batiment_groupe_dpe_tertiaire ne conserve que le DPE tertiaire non vierge le plus récent associé à un groupe de bâtiments ou le dernier DPE vierge si le groupe de bâtiments n''est associé à aucun DPE non vierge';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.type_dpe_tertiaire is 'le DPE tertiaire applique l''arrêté de 2006 sur le DPE et n''a pas été revu depuis. Pour le moment cette colonne vaut toujours : ''dpe 2006 tertiaire et erp''';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.source_nouvelle_base_ademe is 'le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l''ancienne base de données (2012-2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.version is 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.date_etablissement_dpe is 'date de l''établissement du dpe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.date_reception_dpe is 'date de réception du DPE dans la base de données de l''ADEME';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.annee_construction_dpe is 'année de construction du logement évaluée par le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.shon is 'surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.surface_utile is 'surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.classe_conso_energie_dpe_tertiaire is 'classe de consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.classe_emission_ges_dpe_tertiaire is 'classe d''emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_dpe_tertiaire_ep_m2 is 'consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.emission_ges_dpe_tertiaire_m2 is 'emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.categorie_erp_dpe_tertiaire is 'categorie d''ERP du DPE tertiaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.periode_construction_dpe is 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.type_erp_dpe_tertiaire is 'type d''ERP pour le DPE tertiaire, si l''usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n''est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.methode_application_dpe_tertiaire is 'methode d''application du DPE tertiaire (facture, vierge ou neuf)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.sous_modele_dpe_tertiaire is 'sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.type_energie_chauffage is 'type d''énergie pour le générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.type_energie_ecs is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.type_energie_climatisation is 'type d''énergie pour le générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.derniere_annee_consommation is 'dernière année de consommation utilisée pour le calcul du DPE tertiaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_autre_fossile is 'consommation d''autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_bois is 'consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_electricite is 'consommation d''électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_fioul is 'consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_gaz is 'consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_gpl_butane_propane is 'consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_reseau_chaleur is 'consommation d''énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire.conso_reseau_froid is 'consommation d''énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif is 'Données des mutations issues des valeurs foncières agrégées à l''échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.

Les données correspondent à la transaction représentative des transactions de locaux ayant eu lieu sur ce bâtiment. 
Le local représentatif est un logement (en cas de bâtiment mixte) choisi pour représenter le type de logement le plus fréquent (basé sur le nombre de pièces).
La transaction la plus récente correspondant à ce logement est remontée dans cette table.

Cette table correspond à la version « open_data » de la table `batiment_groupe_dvf_logtype`.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.id_opendata is 'Identifiant open data de la mutation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.valeur_fonciere is 'Valeur foncière en euros de la mutation représentative. [€]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.date_mutation is 'date de la mutation pour la transaction immobilière';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_locaux_mutee_mutation is 'Nombre de locaux ayant mutés lors de la mutation représentative.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_maison_mutee_mutation is 'Nombre de maisons ayant mutées lors de la mutation représentative.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_appartement_mutee_mutation is 'Nombre d''appartements ayant mutés lors de la mutation représentative.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_dependance_mutee_mutation is 'Nombre de dépendances ayant mutées lors de la mutation représentative.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_locaux_tertiaire_mutee_mutation is 'Nombre de locaux tertiaires ayant mutés lors de la mutation représentative.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.surface_bati_mutee_residencielle_individuelle is 'Surface de bâti associée à des résidences individuelles ayant mutées lors de la mutation représentative [m²].';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.surface_bati_mutee_residencielle_collective is 'Surface de bâti associée à des résidences collectives ayant mutées lors de la mutation représentative [m²].';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.surface_bati_mutee_dependance is 'Surface de bâti associée à des dépendances ayant mutées lors de la mutation représentative [m²].';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.surface_bati_mutee_tertiaire is 'Surface de bâti associée à du tertiaire ayant mutées lors de la mutation représentative [m²].';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.surface_terrain_mutee is 'Surface de terrain ayant muté lors de la mutation représentative [m²].';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.nb_piece_principale is 'Nombre de pièces principales de la résidence individuelle ou collective ayant muté. Cet indicateur est disponible lorsqu''une unique résidence individuelle ou collective a mutée.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.prix_m2_local is 'Prix au m² de bâti en euros lors de la mutation. Cet indicateur n''est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif.prix_m2_terrain is 'Prix au m² du terrain en euros lors de la mutation. Cet indicateur n''est disponible que pour des transactions dont uniquement les locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées [€]';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique is 'Données des mutations issues des valeurs foncières agrégées à l''échelle du bâtiment. Les départements 57, 67 et 68 sont absents de jeu de données.
les données sont des statistiques sur les transactions immobilières ayant eu lieue sur le bâtiment
Cette table correspond à la version  « open_data » de la table `batiment_groupe_dvf`.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_mutation is 'Nombre de mutations qui ont eu lieu sur le batiment_groupe (sur la période de référence des DVF).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.valeur_fonciere_median is 'Valeur foncière médiane en euros calculée sur l''ensemble des mutations qui ont eu lieu sur le batiment_groupe.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.valeur_fonciere_moyenne is 'Valeur foncière moyenne en euros calculée sur l''ensemble des mutations qui ont eu lieu sur le batiment_groupe.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.valeur_fonciere_max is '(dv3f) valeur foncière maximale parmi les locaux du bâtiment rapporté au m² habitable (SHAB)[€/m²]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.valeur_fonciere_min is '(dv3f) valeur foncière minimale parmi les locaux du bâtiment rapporté au m² habitable (SHAB) [€/m²]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_local_median is 'Prix médian au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_local_moyen is 'Prix moyen au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_local_max is 'Prix maximale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_local_min is 'Prix minimale au m2 de bâti en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_terrain_median is 'Prix médian au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_terrain_moyen is 'Prix moyen au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_terrain_max is 'Prix maximale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.prix_m2_terrain_min is 'Prix minimale au m2 de terrain en euros calculé à partir des transactions dont uniquement des locaux (résidences individuelles + dépendances) ou (résidences collectives + dépendances) ont mutées';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_locaux_mutee is 'Nombre de locaux qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_maisons_mutee is 'Nombre de maisons qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_appartement_mutee is 'Nombre d''appartements qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_dependance_mutee is 'Nombre de dépendances qui ont mutées sur le batiment_groupe (sur la période de référence des DVF).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique.nb_locaux_tertiaire_mutee is 'Nombre de locaux tertiaires qui ont mutés sur le batiment_groupe (sur la période de référence des DVF).';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat is 'Données issues du traitement des fichiers fonciers pour ce bâtiment.

Caractéristiques :
- Les quantitatifs (nombre de locaux, surfaces) sont calculés comme la somme des locaux et de leurs surfaces sur l’ensemble des bâtiments fonciers idbat constitutifs du groupe de bâtiments de la BDNB.
- Les données d’usages sont une synthèse des différents usages identifiés dans les fichiers fonciers.

⚠️ Recommandation :
Pour l’usage des bâtiments, il est désormais conseillé d’utiliser la table `batiment_groupe_synthese_propriete_usage`, qui corrige les usages en intégrant des données complémentaires, notamment pour les bâtiments publics.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.nb_niveau is '(ffo) Nombre de niveau du bâtiment (ex: RDC = 1, R+1 = 2, etc..)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.annee_construction is 'Année de construction du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.usage_niveau_1_txt is 'indicateurs d''usage simplifié du bâtiment (verbose)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.mat_mur_txt is '(ffo) Matériaux principal des murs extérieurs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.mat_toit_txt is '(ffo) Matériau principal des toitures';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat.nb_log is 'Nombre de logements dans le groupe de bâtiments';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx is 'Cette table contient des indications de fiabilité concernant l''association entre les bâtiments des Fichiers Fonciers et les bâtiments constructions, utilisée pour constituer les groupes de bâtiments de la BDNB.

[TABLE DÉPRÉCIÉE] : cette table est dépréciée. Les indicateurs correspondants seront intégrés dans une nouvelle version des métriques de qualité d''appariement entre les emprises BD TOPO et les bâtiments fonciers.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.fiabilite_emprise_sol is 'Fiabilité de l''emprise au sol du bâtiment : "vrai" si les données des Fichiers Fonciers (surfaces fiscales retravaillée par niveau) et BDTOpo (emprise au sol) sont cohérentes ; "faux" sinon ; "NULL" si l''un des deux informations à comparer n''est pas disponible';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.fiabilite_hauteur is 'Fiabilité de la hauteur du bâtiment : "vrai" si les données des Fichiers Fonciers (nombre de niveaux) et BDTOpo (hauteur) sont cohérentes ; "faux" sinon ; "NULL" si l''un des deux informations à comparer n''est pas disponible';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.fiabilite_adresse is 'Fiabilité des adresses du bâtiment : "vrai" si les Fichiers Fonciers et BDTOpo partagent au moins une même adresse BAN';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx.croisement_geospx_reussi is 'Fiabilité sur le croisement de données bâtimentaires : "vrai" si l''association Fichiers Fonciers et BDTopo est considérée comme réussi ; "faux" sinon ; "NULL" si l''une des composantes n''existe pas sur l''unité foncière (i.e. parcelle unifiée) associée.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd is 'Données issues de la base des immeubles localisés de l''Arcep agrégées à l''échelle du groupe de bâtiment.
Cette table permet d''identifier les bâtiments raccordés à la fibre.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd.nb_pdl is '(hthd) Nombre total de PDL Arcep';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd.l_type_pdl is '(hthd) Liste de type de bâtiment desservis par les PDL';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd.l_nom_pdl is '(hthd) Liste des noms des points de livraisons centraux';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid is 'Indicateur de raccordement et de potentiel de raccordement aux réseaux de chaleur et de froid urbains construit à l''aide des données de "France Chaleur Urbaine" et les "Données Locales de l''Energie".
Cette table permet d''identifier les bâtiments raccordés aux réseaux de chaleurs ainsi que les bâtiments à proximité de réseaux chaleurs. 
Pour les bâtiments à proximité de réseaux de chaleur, un indicateur est calculé de potentiel de raccordement de ce bâtiment au réseau de chaleur en fonction de données techniques sur le bâtiment
pour plus d''informations voir la documentation (https://bdnb.io/documentation/indicateur_potentiel_raccordement_reseau_chaleur/)

Dans cette table 3 notions de proximité aux réseaux de chaleurs sont distinguées :

- la proximité aux réseaux de chaleur existants
- la proximité à des réseaux en cours de construction
- la présence dans un périmètre de développement de réseaux de chaleur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.id_reseau is '(France chaleur urbaine) Identifiant national du réseau.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.id_reseau_bdnb is 'Identifiant BDNB, lié au réseau de chaleur, car des données sources ne disposent pas d''identifiant unique pour chacune des entrées (traces et points).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.reseau_en_construction is 'Est vrai lorsque le réseau à proximité du bâtiment est en cours de construction ou en projet. Le réseau en construction peut avoir un tracé précis ou être délimité par une zone de construction du réseau. S''il n''y a pas de tracé disponible la distance au réseau considérée est la plus courte distance à la zone. 
Un réseau en construction ne possède pas d''identfiant réseau.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.perimetre_developpement_prioritaire is 'Est vrai lorsque le bâtiment se situe dans une zone de développement prioritaire. Dans ce cas, le raccordement au réseau peut être obligatoire si il n''y a pas de contraintes techniques, ni un coût de raccordement disproportionné.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid.indicateur_distance_au_reseau is 'Indication sur la distance entre le bâtiment et le point au réseau
          de chaleur le plus proche en vue d''un potentiel raccordement au réseau.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee is '[TABLE DEPRECIEE] : Informations Mérimée (bâtiments classés aux Monuments Historiques) agrégées à l''échelle du bâtiment. Cette table est dépréciée au profit de `batiment_groupe_urbanisme`.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee.distance_batiment_historique_plus_proche is '(mer) Distance au bâtiment historique le plus proche (si moins de 500m) [m]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee.nom_batiment_historique_plus_proche is '(mer:tico) nom du bâtiment historique le plus proche';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv is 'Informations sur les Quartiers Prioritaires de la Ville agrégées à l''échelle du bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv.nom_quartier is 'Nom du quartier prioritaire dans lequel se trouve le bâtiment';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_radon is '[TABLE DÉPRÉCIÉE] : cette table contenait des informations sur l''aléa radon projeté sur chaque bâtiment. Ces données sont désormais intégrées dans la table `batiment_groupe_risques`, compilées avec les autres risques liés aux bâtiments.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_radon.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_radon.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_radon.alea is '(radon) alea du risque radon';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques is 'Table regroupant différents indicateurs de risques (sismique, incendie, radon et argile) associés aux batiment_groupe de la BDNB. Les aléas sismiques, radon et argiles proviennent des zonages issus du site georisques. Les catégories de familles incendies proviennent d''une prédiction simplifiée de la réglementation risque incendie (sur le résidentiel uniquement). Enfin, les catégories de bâtiments associées au risque sismique correspondent à des travaux similaires au risque incendie (sur le résidentiel uniquement).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques.alea_radon is '(georisque) Indicateur d''aléa au radon. Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques.alea_argile is '(georisque) Indicateur d''aléa retrait-gonflement des argiles. Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_risques.alea_sismique is '(georisque) Indicateur d''aléa sismique.  Cet indicateur est déterminé à partir de sa localisation sur les cartes d''aléa défini par le Ministère de la Transition écologique et de la Cohésion des territoires et le BRGM.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc is 'Informations issues de la base du registre national des copropriétés agrégées à l''échelle du groupe de bâtiment';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.numero_immat_principal is 'numéro d''immatriculation principal associé au bâtiment groupe. (numéro d''immatriculation copropriété qui comporte le plus de lots)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.periode_construction_max is '(rnc) Période de construction du local le plus récent';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.l_annee_construction is 'Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.nb_lot_garpark is 'Nombre de lots de stationnement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.nb_lot_tot is 'Nombre total de lots';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.nb_log is 'Nombre de logements déclaré dans le registre national des copropriétés pour le groupe de bâtiments';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.nb_lot_tertiaire is 'Nombre de lots de type bureau et commerce';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.l_nom_copro is '(rnc) liste des noms des copropriétés';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.l_siret is 'liste de siret';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rnc.copro_dans_pvd is '(rnc) au moins une des coproprietés est dans le programme petites villes de demain';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls is 'Informations issues du répertoire des logements sociaux agrégées au niveau du groupe de bâtiment BDNB.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.rpls_open is 'True si tous les logements integrés sont en open';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_a is 'Nombre de logements avec un DPE énergie de classe A';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_b is 'Nombre de logements avec un DPE énergie de classe B';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_c is 'Nombre de logements ayant la classe DPE énergie C';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_d is 'Nombre de logements ayant la classe DPE énergie D';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_e is 'Nombre de logements ayant la classe DPE énergie E';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_f is 'Nombre de logements ayant la classe DPE énergie F';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_g is 'Nombre de logements ayant la classe DPE énergie G';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ener_nc is 'Nombre de logements ayant la classe DPE énergie NC';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.classe_ener_principale is '(rpls) classe DPE énergie principale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_a is '(rpls) Nombre de logements ayant la classe DPE climat A';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_b is '(rpls) Nombre de logements ayant la classe DPE climat B';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_c is '(rpls) Nombre de logements ayant la classe DPE climat C';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_d is '(rpls) Nombre de logements ayant la classe DPE climat D';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_e is '(rpls) Nombre de logements ayant la classe DPE climat E';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_f is '(rpls) Nombre de logements ayant la classe DPE climat F';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_g is '(rpls) Nombre de logements ayant la classe DPE climat G';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_classe_ges_nc is '(rpls) Nombre de logements ayant la classe DPE climat NC';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.classe_ges_principale is '(rpls) classe DPE climat principale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.accessible_pmr is '(rpls) Présence d''au moins un logement PMR';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.dans_qpv is '(rpls) Immeuble dans un QPV';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.l_annee_construction is 'Liste des années de construction issue des données foncières (colonne dépréciée à ne plus utiliser)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.nb_log is 'Nombre de logements sociaux déclaré dans le RPLS pour le groupe de bâtiments';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.s_log_hab is '(rpls) Surface de logements d''habitation [m²]';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_rpls.type_construction is '(rpls) Type de construction';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_synthese_propriete_usage is 'Table de synthèse des informations de propriété et d’usage des bâtiments.

Sources :
Cette table consolide les données issues de multiples sources :
- RPLS
- Fichiers fonciers
- Registre des copropriétés
- ESPACE (projet de géolocalisation des établissements publics en partenariat avec le CEREMA)
- Fichier locaux des personnes morales de la DGFiP
- SIRENE

Objectif :
Fournir les informations principales sur la propriété et l’usage des groupes de bâtiments.

NB : Cette table introduit le nouvel indicateur `usage_principal_bdnb_open`, qui remplace l’ancienne variable `usage_niveau_1_txt` issue des seuls fichiers fonciers.  
Il est recommandé d’utiliser `usage_principal_bdnb_open` à la place de la donnée foncière brute.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_synthese_propriete_usage.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_synthese_propriete_usage.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_synthese_propriete_usage.usage_principal_bdnb_open is 'Indicateur d''usage principal du bâtiment. Cet indicateur est une évolution de la variable d''usage usage_niveau_1_txt (Fichiers Fonciers) qui est corrigée notamment sur les bâtiments publics qui sont affectés en usage tertiaire. 
Valeurs possibles :
- Résidentiel individuel
- Résidentiel collectif
- Tertiaire
- Secondaire
- Dépendance
- Indifférencié';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme is 'Table qui regroupe les contraintes et réglementations d''urbanismes qui s''appliquent au bâtiment. Dans cette version, les contraintes d''urbanismes intégrées sont celles liées aux sites patrimoniaux et monuments historiques.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.contrainte_urbanisme_ac1 is 'Indicateur booléen de la présence du bâtiment dans une zone AC1 (périmètre de 500m autour d''un monument historique ou dans un périmètre aux abords des monuments historiques)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.zone_plu_bati_patrimonial is 'Indicateur booléen de la présence du bâtiment dans un périmètre classé patrimonial dans un PLU. Cela peut potentiellement recouvrir des classifications nationales comme les SPR mais peut aussi correspondre à des protections locales documentées uniquement dans le PLU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.monument_historique is 'Indicateur booléen signalant si le bâtiment est classé comme monument historique. Le bâtiment est déterminé comme monument historique lorsque le géolocalisant du monument est sur le bâtiment en question.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.source_monument_historique is 'Source utilisée pour identifier le bâtiment comme monument historique. (mérimée ou géoportail de l''urbanisme ou les deux)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.denomination_monument_historique is 'Dénomination du monument historique le plus proche si le bâtiment se trouve dans un périmètre AC1 ou s''il est lui-même bâtiment historique';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.batiment_groupe_urbanisme.distance_monument_historique is 'Distance entre le bâtiment et le monument historique en [m]. La distance est égale à 0m lorsque le bâtiment est un monument historique.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.parcelle is 'Table contenant les informations sur les parcelles cadastrales.

Un groupe de bâtiments peut être situé sur une ou plusieurs parcelles cadastrales.
Cependant, un groupe de bâtiments ne peut pas appartenir à plusieurs unités foncières différentes (une unité foncière regroupe des parcelles appartenant au même propriétaire).

Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle.parcelle_id is '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle.s_geom_parcelle is '(ffo) Surface au sol de la géométrie de parcelle';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle.geom_parcelle is '(ffo:geompar) Géometrie de la parcelle cadastrale (Lambert-93)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.parcelle_sitadel is 'Informations consolidées et simplifiées à l''échelle de la parcelle des données SITADEL. Cette table fournit des données numériques et 
catégorielles synthétiques sur les demandes d''autorisation d''urbanisme (DAU) déclarées pour chaque parcelle. Une 
analyse complémentaire vérifie l''actualisation de certaines données de la BDNB, telles que la surface, le nombre de 
locaux, l''année de construction. Si ces éléments ne correspondent pas aux dernières autorisations d''urbanisme 
disponibles, cela indique que la BDNB n''est pas à jour pour cette parcelle.
**ATENTION** Ne pas faire des statistiques agregées sur cette table, les valeurs numériques sont données à titre 
indicatif. Pour des statistiques utiliser la table `sitadel`. En effet, une demande d''autorisation d''urbanisme peut concerner plusieurs parcelles et peut donc être répétée dans cette table.

NB : les données sitadel ne sont pas fournies au niveau des groupes de bâtiments comme les autres informations métiers de la BDNB car elles concernent des opérations ayant pour objet la démolition ou la construction de bâtiments et concernent majoritairement des bâtiments qui n''existent pas encore ou n''existent plus.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.parcelle_id is '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nombre_dau is '(Sitadel) Nombre de demandes d''autorisation d''urbanisme (DAU).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.annee_premiere_dau_identifiee is '(Sitadel) Année de la première DAU identifiée dans le millésime de Sitadel utilisé.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.annee_derniere_dau_identifiee is '(Sitadel) Année de la dernière DAU identifiée dans le millésime de Sitadel utilisé.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nouvelle_construction is 'Nouveau bâtiment sur parcelle. 
Peut prendre les valuers : ''nouveau bâtiment exclusif'' ou ''nouveau bâtiment ajouté''
- nouveau bâtiment exclusif : soit une construction entièrement neuve sur une parcelle vierge, soit un bâtiment qui remplace entièrement une structure préexistante.
- nouveau bâtiment ajouté : nouveau bâtiment sur parcelle sur laquelle existe déjà un ou plusieurs bâtiments.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.travaux_sur_construction_existante is '(Sitadel) Vrai si les permis déclarent des travaux sur construction existante.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.demolition is '(Sitadel) Démolition déclarée par DAU égale à permis de démolir ou surface démolie déclarée dans les permis de 
création de surfaces.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.amenagement is 'Demande d''autorisation d''urbanisme spécifique pour réaliser un aménagement.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.bdnb_obsolete is '(Sitadel) Les informations contenues dans la BDNB pour ce groupe de bâtiments sont considérées comme potentiellement obsolètes (année de construction, surfaces, emprise au sol, etc.), car elles se réfèrent à une période antérieure à celle des autorisations de création de surfaces.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.annee_construction_obsolete is '(Sitadel) Année de construction enregistrée antérieure à celle déclarée dans la dernière DAU connue dans Sitadel pour cette parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.service_public_identifie is '(Sitadel) Travaux déclarés par les autorisations avec un ou l''un des usages de type service public.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.indicateur_extension is 'Indicateur pour la présence d''une extension.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.indicateur_surelevation_ou_nivsupp is 'Indicateur pour la présence d''une surélévation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.indicateur_piscine is 'Indicateur pour la présence d''une piscine.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.indicateur_garage is 'Indicateur pour la présence d''un garage.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nombre_logemens_totaux_crees is 'Nombre total de logements créés sur la parcelle. Cela inclus les logements à usage individuel, collectif et les logements en résidences.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nombre_logement_demolis is 'Nombre de logements démolis sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_cree is 'Surface habitable créée sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_issue_transformation is 'Surface habitable issue d''une transformation sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_transformee is 'Surface habitable transformée sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_demolie is 'Surface habitable démolie sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_cree is 'Surface des locaux créés sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_issue_transformee is 'Surface des locaux issus d''une transformation sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_transformee is 'Surface des locaux transformée sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_demolie is 'Surface des locaux démolie sur la parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nature_derniere_dau is '(Sitadel) Nature du dernier permis autorisé.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nombre_logements_creees_derniere_dau is '(Sitadel) Nombre de logements créés (individuels, collectifs et des résidences) - déclaré dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.nombre_logements_demolis_derniere_dau is '(Sitadel) Nombre de logements démolis - déclaré dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_creee_derniere_dau is '(Sitadel) Surface habitable créée - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_creee_derniere_dau is '(Sitadel) Surface créée pour les planchers de locaux non résidentiels - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_issue_transfo_derniere_dau is '(Sitadel) Surface de plancher de la destination '' Habitation '' issue d''une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_issue_transfo_derniere_dau is '(Sitadel) Surface de plancher des locaux non-résidentiels issue d''une transformation (changement de destination, réhabilitation, scission, regroupement …) - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_transformee_derniere_dau is '(Sitadel) Surface de plancher de la destination '' Habitation '' transformée (changement de destination, réhabilitation, scission, regroupement ...) - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_transformee_derniere_dau is '(Sitadel) Surface de plancher - de locaux non résidentiels - transformée (changement de destination, réhabilitation, 
scission, regroupement ...) - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_habitable_demolie_derniere_dau is '(Sitadel) Surface de plancher de la destination '' Habitation '' supprimée (démolie) - déclarée dans la dernière DAU.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.parcelle_sitadel.surface_locaux_demolie_derniere_dau is '(Sitadel) Surface de plancher de locaux non résidentiels démolie - déclarée dans la dernière DAU.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_parcelle is 'Table de relation entre les groupes de bâtiments et les parcelles (relation n-m) :
- Une parcelle peut contenir plusieurs groupes de bâtiments.
- Un groupe de bâtiments peut être situé sur plusieurs parcelles.

Pour les ayants droit des fichiers fonciers, il est recommandé d’utiliser la table [parcelle_unifiee] plutôt que les tables parcelles.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_parcelle.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_parcelle.parcelle_id is '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_parcelle.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_parcelle.parcelle_principale is 'Booléen renvoyant ''vrai'' si la parcelle cadastrale est la plus grande intersectant le groupe de bâtiment';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.proprietaire is 'Données sur les propriétaires de bâtiment (issues des Fichiers Fonciers)
Cette table est disponible en open data uniquement sur certaines colonnes pour les propriétaires fonciers diffusés dans le fichier des locaux sur les personnes morales de la DGFiP (la version open filtre sur la colonne `dans_majic_pm`)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.personne_id is 'Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.siren is 'Numéro de SIREN d''une entreprise, un organisme public ou privé, une personne physique ayant une activité économique indépendante non salariée ou une association ayant des activités en France';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.forme_juridique is 'Forme juridique du propriétaire (FF)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.denomination is 'Dénomination du propriétaire (FF)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.code_postal is 'Code postal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.libelle_commune is 'Libellé de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.dans_majic_pm is '(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.proprietaire.nb_locaux_open is 'nombre de locaux possédé par le propriétaire diffusé dans majic personne morale';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire is 'Table de relation entre les propriétaires fonciers et les groupes de bâtiments.

Les données foncières sur les propriétaires sont disponibles en open data uniquement pour les personnes morales.
Seuls les propriétaires présents dans le fichier MAJIC personnes morales sont inclus dans la version open data (filtrage via la colonne `dans_majic_pm`).

Cette table établit le lien entre :
- la table `batiment_groupe` ,
- et la table `proprietaire`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire.personne_id is 'Concaténation de code département et du numéro de personne Majic3 (FF) (appelé aussi NUMÉRO PERSONNE PRESENT DANS L’APPLICATION MAJIC dans les fichiers des locaux des personnes morales)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire.dans_majic_pm is '(majic_pm) Ce propriétaire possède des bâtiments déclarés dans majic_pm';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_proprietaire.nb_locaux_open is 'nombre de locaux possédé par le propriétaire dans ce groupe de bâtiment diffusé dans majic personne morale';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.dpe_logement is 'Table de compilation des DPE logements regroupant les DPE logements de l''arrêté du 8 février 2012 (DPE "arrete 2012" Base ADEME 2012-2021) et les DPE logements de l''arrêté du 31 mars 2021 (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE "arrete 2012"  et les DPE "arrete 2021". Les DPE de l''arrêté du 31 mars sont opposables et donc réputés bien plus fiables et issus d''une base de donnée beaucoup plus propre et complète que la précédente.  Les types de DPE peuvent être filtrés avec la propriété type_dpe entre les DPE "arrete 2012" et "arrete 2021".';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.arrete_2021 is 'précise si le DPE est un DPE qui est issu de la nouvelle réforme du DPE (arrêté du 31 mars 2021) ou s''il s''agit d''un DPE issu de la modification antérieure de 2012.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_dpe is 'type de DPE. Permet de préciser le type de DPE (arrêté 2012/arrêté 2021), son objet (logement, immeuble de logement, tertiaire) et la méthode de calcul utilisé (3CL conventionel,facture ou RT2012/RE2020)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_batiment_dpe is 'défini si le DPE a été établi pour une maison, un appartement ou un immeuble entier. Cette colonne est renseignée uniquement si la source d''information est un DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.periode_construction_dpe is 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.annee_construction_dpe is 'année de construction du logement évaluée par le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.version is 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.date_etablissement_dpe is 'date de l''établissement du dpe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.date_reception_dpe is 'date de réception du DPE dans la base de données de l''ADEME';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nombre_niveau_logement is 'nombre de niveaux du logement (maison ou appartement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nombre_niveau_immeuble is 'nombre de niveaux total de l''immeuble';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_habitable_immeuble is 'surface habitable totale de l''immeuble dans le cas d''un DPE appartement avec usage collectif ou d''un DPE immeuble.(surface habitable au sens du DPE)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_habitable_logement is 'surface habitable du logement renseignée sauf dans le cas du dpe à l''immeuble. (surface habitable au sens du DPE)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.conso_5_usages_ep_m2 is 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires) en énergie primaire (déduit de la production pv autoconsommée) (kWhep/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.conso_5_usages_ef_m2 is 'consommation annuelle 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires)en énergie finale (déduit de la production pv autoconsommée) (kWhef/m²/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.emission_ges_5_usages_m2 is 'emission GES totale 5 usages rapportée au m² (déduit de la production pv autoconsommée) (ecs/chauffage/climatisation/eclairage/auxiliaires)(kgCO2/m2/an). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.classe_bilan_dpe is 'Classe du DPE issu de la synthèse du double seuil sur les consommations énergie primaire et les émissions de CO2 sur les 5 usages (ecs/chauffage/climatisation/eclairage/auxiliaires).  valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.classe_emission_ges is 'classe d''émission GES du DPE 5 usages (chauffage, ECS, climatisation, éclairage et auxiliaires). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 31 mars 2021 (en vigueur actuellement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.classe_conso_energie_arrete_2012 is 'classe d''émission GES du DPE 3 usages (Chauffage, ECS, Climatisation). Valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.classe_emission_ges_arrete_2012 is 'classe d''emission GES du DPE 3 usages (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.conso_3_usages_ep_m2_arrete_2012 is 'consommation annuelle 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.emission_ges_3_usages_ep_m2_arrete_2012 is 'emission GES totale 3 usages énergie primaire rapportée au m2 (Chauffage, ECS , Climatisation). valable uniquement pour les DPE appliquant la méthode de l''arrêté du 8 février 2012 (kgCO2/m2/an).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_installation_chauffage is 'type d''installation de chauffage (collectif ou individuel)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_energie_chauffage is 'type d''énergie pour le générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_chauffage is 'type de générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_chauffage_anciennete is 'ancienneté du générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_energie_chauffage_appoint is 'type d''énergie pour le générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_chauffage_appoint is 'type de générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_chauffage_anciennete_appoint is 'ancienneté du générateur de chauffage d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.chauffage_solaire is 'présence de chauffage solaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nb_generateur_chauffage is 'nombre de générateurs de chauffage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nb_installation_chauffage is 'nombre d''installation de chauffage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_energie_climatisation is 'type d''énergie pour le générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_climatisation is 'type de générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_climatisation_anciennete is 'ancienneté du générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_installation_ecs is 'type d''installation d''eau chaude sanitaire (ECS) (collectif ou individuel)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_energie_ecs is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_ecs is 'type de générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_ecs_anciennete is 'ancienneté du générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_energie_ecs_appoint is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_ecs_appoint is 'type de générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_generateur_ecs_anciennete_appoint is 'ancienneté du générateur d''eau chaude sanitaire (ECS) d''appoint';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.ecs_solaire is 'présence d''ecs solaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nb_generateur_ecs is 'nombre de générateurs d''ecs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.nb_installation_ecs is 'nombre d''installation d''ecs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.plusieurs_facade_exposee is 'il est considéré dans le DPE qu''il y a plusieurs facades exposées au vent.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_ventilation is 'type de système de ventilation du logement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_production_energie_renouvelable is 'type de production ENR pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_vitrage is 'type de vitrage principal des baies vitrées du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_materiaux_menuiserie is 'type de matériaux principal des menuiseries des baies vitrées du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_gaz_lame is 'type de gaz injecté principalement dans la lame entre les vitrages des baies vitrées du DPE (double vitrage ou triple vitrage uniquement)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_fermeture is 'type de fermeture principale installée sur les baies vitrées du DPE (volet,persienne etc..)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.epaisseur_lame is 'epaisseur principale de la lame de gaz entre vitrages pour les baies vitrées du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.vitrage_vir is 'le vitrage a été traité avec un traitement à isolation renforcé ce qui le rend plus performant d''un point de vue thermique.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_vitree_nord is 'somme de la surface de baies vitrées orientées nord du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_vitree_sud is 'somme de la surface de baies vitrées orientées sud du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_vitree_ouest is 'somme de la surface de baies vitrées orientées ouest du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_vitree_est is 'somme de la surface de baies vitrées orientées est du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_vitree_horizontal is 'somme de la surface de baies vitrées horizontales du DPE (velux la plupart du temps)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.traversant is 'indicateur du côté traversant du logement.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_baie_vitree is 'Coefficient de transmission thermique moyen des baies vitrées en incluant le calcul de la résistance additionelle des fermetures (calcul Ujn) (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.uw is 'Coefficient de transmission thermique moyen des baies vitrées sans prise en compte des fermeture (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.facteur_solaire_baie_vitree is 'facteur de transmission du flux solaire par la baie vitrée. coefficient entre 0 et 1';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.presence_balcon is 'présence de balcons identifiés par analyse des coefficients de masques solaires du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.l_orientation_baie_vitree is 'liste des orientations des baies vitrées (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.pourcentage_surface_baie_vitree_exterieur is 'pourcentage de surface de baies vitrées rapportée à la surface totale des murs extérieurs';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_isolation_mur_exterieur is 'type d''isolation principal des murs donnant sur l''extérieur pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.epaisseur_isolation_mur_exterieur_estim is 'epaisseur d''isolation moyenne des murs extérieurs estimée à partir de la différence entre le U de mur et le U de mur nu. Dans le cas d''une épaisseur déclarée c''est directement l''épaisseur déclarée qui est considérée, dans le cas contraire l''épaisseur est estimée aussi pour les U conventionels de la méthode 3CL DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.materiaux_structure_mur_exterieur is 'matériaux ou principe constructif principal utilisé pour les murs extérieurs (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.epaisseur_structure_mur_exterieur is 'epaisseur moyenne de la partie structure du mur (sans l''isolation rapportée ni les doublages)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_mur_totale is 'somme de la surface de murs totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_mur_exterieur is 'somme de la surface  surface de murs donnant sur l''extérieur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_mur_deperditif is 'somme de la surface de murs donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_mur_exterieur is 'Coefficient de transmission thermique moyen des murs extérieurs (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.l_local_non_chauffe_mur is 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.local_non_chauffe_principal_mur is 'liste des locaux non chauffés en contact avec les murs (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.l_orientation_mur_exterieur is 'liste des orientations des murs donnant sur l''extérieur (enum version BDNB)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_isolation_plancher_bas is 'type d''isolation principal des planchers bas déperditifs pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_plancher_bas_deperditif is 'materiaux ou principe constructif principal des planchers bas';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_plancher_bas_totale is 'somme de la surface de plancher bas totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_plancher_bas_deperditif is 'somme de la surface de plancher bas donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_plancher_bas_final_deperditif is 'Coefficient de transmission thermique moyen des planchers bas en prenant en compte l''atténuation forfaitaire du U lorsqu''en contact avec le sol de la méthode 3CL(W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_plancher_bas_brut_deperditif is 'Coefficient de transmission thermique moyen des planchers bas brut (W/m²/K) (sans application de la réduction de déperdition liée à la modélisation du contact avec le sol dans la méthode 3CL).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.l_local_non_chauffe_plancher_bas is 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.local_non_chauffe_principal_plancher_bas is 'liste des locaux non chauffés en contact avec les planchers bas (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_adjacence_principal_plancher_bas is 'type d''adjacence principale des planchers bas (sont ils en contact avec l''extérieur ou un local non chauffé)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_isolation_plancher_haut is 'type d''isolation principal des planchers hauts déperditifs pour le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_plancher_haut_deperditif is 'materiaux ou principe constructif principal des planchers hauts';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_plancher_haut_totale is 'somme de la surface de plancher haut totale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_plancher_haut_deperditif is 'somme de la surface de plancher haut donnant sur des locaux non chauffés et sur l''extérieur (surfaces déperditives)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_plancher_haut_deperditif is 'Coefficient de transmission thermique moyen des planchers hauts (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.l_local_non_chauffe_plancher_haut is 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.local_non_chauffe_principal_plancher_haut is 'liste des locaux non chauffés en contact avec les planchers hauts (enum DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_adjacence_principal_plancher_haut is 'type d''adjacence principale des planchers haut (sont ils en contact avec l''extérieur ou un local non chauffé)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.type_porte is 'type de porte du DPE (enum version DPE 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.surface_porte is 'somme de la surface de portes du DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.u_porte is 'Coefficient de transmission thermique moyen des portes (W/m²/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.classe_inertie is 'classe d''inertie pour le DPE (de légère à très lourde)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_mur is 'somme des déperditions par les murs du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_baie_vitree is 'somme des déperditions par les baies vitrées du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_plancher_bas is 'somme des deperditions par les planchers bas du logement (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_plancher_haut is 'somme des deperditions par les planchers hauts du logement (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_pont_thermique is 'somme des deperditions par les portes du DPE (W/K)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_logement.deperdition_porte is 'somme des deperditions par les portes du DPE (W/K)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.dpe_tertiaire is 'Table de compilation des DPE tertiaire regroupant les DPE tertiaires de l''ancienne base ADEME (Base ADEME 2012-2021) et les DPE tertiaire de la nouvelle base ADEME des DPE (juillet 2021 - aujourd''hui). Attention la qualité de données et le taux de remplissage des informations change drastiquement entre les DPE de la nouvelle et de l''ancienne base peuvent sensiblement différerée. Les DPE tertiaires sont des DPE de type "facture" ou issu d''une étude thermique (RT2012/RE2020) pour un bâtiment neuf. Les informations techniques relatives au bâtiment sont moins bien décrites que pour les DPE logements. Le nombre d''information disponible est fortement réduit par rapport aux DPE logements.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.type_dpe_tertiaire is 'le DPE tertiaire applique l''arrêté de 2006 sur le DPE et n''a pas été revu depuis. Pour le moment cette colonne vaut toujours : ''dpe 2006 tertiaire et erp''';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.source_nouvelle_base_ademe is 'le DPE tertiaire provient-il de la nouvelle base de DPE ADEME opérationelle depuis juillet 2021 ou est-il issu de l''ancienne base de données (2012-2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.version is 'version du DPE (arrêté 2021). Cenuméro de version permet de tracer les évolutions de modèle de données, decontexte réglementaire et de contrôle mis en place sur les DPE. Chaque nouvelle version induit un certain nombre de changements substantiels. Certaines données ne sont disponible ou obligatoires qu''à partir d''une certaine version';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.date_etablissement_dpe is 'date de l''établissement du dpe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.date_reception_dpe is 'date de réception du DPE dans la base de données de l''ADEME';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.annee_construction_dpe is 'année de construction du logement évaluée par le DPE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.shon is 'surface hors œuvre nette du bâtiment. Attention : cette notion est parfois confondue avec la surface chauffée et saisie égale à la surface chauffée = surface utile *1.1. Cette donnée est donc à utiliser avec beaucoup de précaution';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.surface_utile is 'surface utile du bâtiment. Donnée peu fiable dans les DPE tertiaires';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.classe_conso_energie_dpe_tertiaire is 'classe de consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.classe_emission_ges_dpe_tertiaire is 'classe d''emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_dpe_tertiaire_ep_m2 is 'consommation d''energie primaire du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.emission_ges_dpe_tertiaire_m2 is 'emission GES du DPE tertiaire suivant l''arrêté de 2006 concernant les DPE tertiaires (non révisé en 2021)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.categorie_erp_dpe_tertiaire is 'categorie d''ERP du DPE tertiaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.periode_construction_dpe is 'période de construction selon la segmentation par grandes périodes "énergétiques" du DPE.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.type_erp_dpe_tertiaire is 'type d''ERP pour le DPE tertiaire, si l''usage du bâtiment est un bureau non ERP cela est précisé. Si le bâtiment n''est ni un ERP, ni une partie de bâtiment à usage de bureau alors il est identifié comme "autres tertiaires non erp"';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.methode_application_dpe_tertiaire is 'methode d''application du DPE tertiaire (facture, vierge ou neuf)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.sous_modele_dpe_tertiaire is 'sous modèle de DPE tertiaire correspondant aux catégories en vigueur (https://rt-re-batiment.developpement-durable.gouv.fr/dpe-tertiaire-r378.html)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.type_energie_chauffage is 'type d''énergie pour le générateur de chauffage principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.type_energie_ecs is 'type d''énergie pour le générateur d''eau chaude sanitaire (ECS) principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.type_energie_climatisation is 'type d''énergie pour le générateur de climatisation principal';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.derniere_annee_consommation is 'dernière année de consommation utilisée pour le calcul du DPE tertiaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_autre_fossile is 'consommation d''autres combustibles fossiles (hors fioul , gaz, butane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_bois is 'consommation de bois pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_electricite is 'consommation d''électricité pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_fioul is 'consommation de fioul pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_gaz is 'consommation de gaz de ville pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_gpl_butane_propane is 'consommation de gaz citerne (gpl,butane ou propane) pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_reseau_chaleur is 'consommation d''énergie calorifique fournie par un réseau de chaleur pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.dpe_tertiaire.conso_reseau_froid is 'consommation d''énergie calorifique fournie par un réseau de froid pour la dernière année de consommation en énergie finale. Cette consommation est utilisée pour calculer l''étiquette énergie primaire et GES du DPE tertiaire (kWhef)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb is 'Table de relation entre les bâtiments construction de la BDNB et les entités du RNB (Référentiel National des Bâtiments), limitée à l’hexagone.

Dans la grande majorité des cas, un identifiant RNB correspond à un bâtiment construction de la BDNB, en raison de l’initialisation partielle du RNB à partir des données BDNB (relation 1 pour 1).

EXPERIMENTAL : Cette table est expérimentale. Une intégration plus poussée du RNB dans la BDNB est en cours, et la structure de cette relation est susceptible d’évoluer.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.rnb_id is 'Identifiant unique de l''entrée RNB.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.type_appariement is 'Type d''appariement entre les entrées `batiment_groupe_id` (BC) de la BDNB et `rnb_id` du RNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.detail is 'Détail sur le type d''appariement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_rnb.geom_rnb_pos is 'Géométrie ponctuelle de l''objet RNB (Lambert-93, SRID=2154).';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_bat is 'Table de relation entre les bâtiments de la BDNB et les éléments de la table bâti de la BDTOPO';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_bat.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_bat.bdtopo_bat_cleabs is 'identifiant de la table bâtiment de la BDTOPO';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_bat.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_bat.code_departement_insee is 'Code département INSEE';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_equ is 'Table de relation entre les bâtiments de la BDNB et les éléments de la table equipement de la BDTOPO';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_equ.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_equ.bdtopo_equ_cleabs is 'identifiant de la table equipement de la BDTOPO';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_equ.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_equ.code_departement_insee is 'Code département INSEE';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_zoa is 'Table de relation entre les bâtiments de la BDNB et les éléments de la table des zones d''activité de la BDTOPO';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_zoa.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_zoa.bdtopo_zoa_cleabs is 'identifiant de la table argiles';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_zoa.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bdtopo_zoa.code_departement_insee is 'Code département INSEE';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bpe is 'Table de relation entre les bâtiments de la BDNB et les éléments de la table bpe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bpe.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bpe.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bpe.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_bpe.bpe_non_officiel_id is 'identifiant de la table bpe';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement is 'Table de relation entre les groupes de bâtiments de la BDNB et les éléments des deux bases de données DPE (arrêté 2012 et arrêté 2021).  
Les deux bases sont compilées dans cette table. Il est possible de filtrer avec la colonne `arrete_2021` (table `dpe_logement`) pour ne conserver que les nouveaux DPE.

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `dpe_logement` (qui contient l’intégralité des DPE).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.adresse_brut is 'adresse brute envoyée au géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.adresse_geocodee is 'libelle de l''adresse retournée par le géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.fiabilite_geocodage is 'fiabilité du géocodage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_logement.type_appariement is 'méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l''identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l''ensemble des méthodes utilisées pour l''appariement';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire is 'Table de relation entre les bâtiments de la BDNB et les éléments des deux bases de données DPE tertiaire de l’ADEME (avant 2021 et après 2021).  

Contrairement aux DPE logement, les deux bases sont ici compilées car aucune évolution réglementaire majeure n’a concerné les DPE tertiaires.  
Il n’est donc pas nécessaire de filtrer entre ancien ou nouveau DPE tertiaire

Cette table permet de faire le lien entre :
- la table `batiment_groupe`,
- et la table `dpe_tertiaire` (qui contient l’intégralité des DPE).
-';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.identifiant_dpe is 'identifiant unique des DPE de l''ADEME.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.adresse_brut is 'adresse brute envoyée au géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.adresse_geocodee is 'libelle de l''adresse retournée par le géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.fiabilite_geocodage is 'fiabilité du géocodage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dpe_tertiaire.type_appariement is 'méthode qui a été utilisée pour associer le groupe de bâtiment à un DPE. Un DPE peut être associé par son adresse, sa parcelle, l''identifiant rnb lorsque celui-ci est renseigné par le diagnostiqueur ou via le RPLS. Si plusieurs méthodes coincident type_appariement décrit l''ensemble des méthodes utilisées pour l''appariement';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open is 'Table de relation entre les batiment_groupe de la BDNB et l''ensemble des mutations ayant eu lieu sur ce bâtiment groupe
Les mutations foncières sont identifiées par leur identifiant open_data diffusé dans le jeu de données du CEREMA DVF+ open data(https://datafoncier.cerema.fr/donnees/autres-donnees-foncieres/dvfplus-open-data)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.id_opendata is 'Identifiant open data de la mutation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.fiabilite_croisement is 'Fiabilité de l''appariement entre les bâtiments groupes et les mutations. La fiabilité est forte si l''ensemble des locaux de la mutation se situent sur un unique bâtiment groupe. La fiabilité est faible si les locaux de la mutation ne peuvent être associés à un unique bâtiment groupe.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.join_id_opendata is 'L''appariement a été réalisé à partir de l''id_opendata en le croisant avec les dv3f.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_dvf_open.join_geom_local is 'L''appariement a été réalisé à partir de la présence du localisant ponctuel du local ayant muté au sein de la géométrie de la parcelle unifiée.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee is '[TABLE DEPRECIEE] : Table de relation entre les bâtiments de la BDNB et les éléments de la table merimee';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee.merimee_ref is 'identifiant de la table merimee';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_merimee.distance_batiment_historique is '(mer) Distance entre le batiment_historique et le batiment_construction (si moins de 500m) [m]';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_qpv is 'DEPRECIEE  -> utiliser uniquement la table batiment_groupe_qpv .Table de relation entre les bâtiments de la BDNB et les éléments de la table QPV';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_qpv.batiment_construction_id is 'Identifiant unique de l''entrée batiment_construction.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_qpv.qpv_code_qp is 'identifiant de la table qpv';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_qpv.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_qpv.code_departement_insee is 'Code département INSEE';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc is 'Table de relation entre les bâtiments de la BDNB et les éléments de la table RNC';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.batiment_groupe_id is 'Identifiant du groupe de bâtiment au sens de la BDNB';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.numero_immat is 'identifiant de la table rnc';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.cle_interop_adr is 'Clé d''interopérabilité de l''adresse postale';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.adresse_brut is 'adresse brute envoyée au géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.adresse_geocodee is 'libelle de l''adresse retournée par le géocodeur';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.fiabilite_geocodage is 'fiabilité du géocodage';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.fiabilite_globale is 'fiabilité du global du croisement';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_rnc.parcelle_id is '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel is 'Table de relation entre les identifiants des parcelles et les identifiants de demande d''autorisation d''urbanisme (DAU)
de la base de données Sitadel.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.type_numero_dau is 'Concatenation du type de demande d''autorisation d''urbanisme (DAU) et le numéro de DAU.
Combinaisons possibles : 
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro 
  DAU` ou `DP + numéro DAU`
- permis de démolir (PD) > `PD + numéro DAU`
- permis d''aménager (PA) > `PA + numéro DAU`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.parcelle_id is '(ffo:idpar) Identifiant de parcelle (Concaténation de ccodep, ccocom, ccopre, ccosec, dnupla)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.dau_monoparcelle is 'Indique si la demande d''autorisation d''urbanisme (DAU) ne concerne qu''une unique parcelle.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.type_appariement is 'Type de croisement final. Prend les valeurs ''parcelle'', ''adresse'', ''parcelle + adresse'' ou ''non apparie''.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.rel_parcelle_sitadel.fiabilite_appariement is 'Fiabilité du croisement des données d''autorisation d''urbanisme SITADEL avec la BDNB, prend les valeurs - ''très 
fiable'' ou ''fiable''.';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.sitadel is 'Table de compilation des données Sitadel, cela inclut l''ensemble des demandes d''autorisation d''urbanisme (DAU) :
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux, 
- permis de démolir (PD)
- permis d''aménager (PA).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_numero_dau is 'Concatenation du type de demande d''autorisation d''urbanisme (DAU) et le numéro de DAU.
Combinaisons possibles : 
- permis de construire (PC) et déclarations préalables (DP) de création de logements et/ou locaux > `PC + numéro 
  DAU` ou `DP + numéro DAU`
- permis de démolir (PD) > `PD + numéro DAU`
- permis d''aménager (PA) > `PA + numéro DAU`';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.creation_local is 'Demande d''autorisation d''urbanisme spécifique pour la création de locaux.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.creation_logement is 'Demande d''autorisation d''urbanisme spécifique pour la création de logements.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.permis_demolir is 'Demande d''autorisation d''urbanisme spécifique pour réaliser une démolition.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.permis_amenager is 'Demande d''autorisation d''urbanisme spécifique pour réaliser un aménagement.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.etat_avancement_projet is 'Etat d''avancement du projet (Autorisé, Commencé, Terminé). Les projets annulés ne sont pas contenus dans cette 
compilation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.date_reelle_autorisation is 'Date réelle d''autorisation (Permis de Construire) ou de non-opposition (Déclaration Préalable) initiale. Date de décision relative à la demande initiale, sans prise en compte d''éventuels modificatifs.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.date_reelle_ouverture_chantier is 'Date réelle d''ouverture de chantier.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.date_reelle_achevement_travaux is 'Date réelle d''achèvement des travaux.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.annee_depot_dau is 'Année de dépôt de la demande d''autorisation d''urbanisme.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.dpc_derniere_maj is 'Date (mois) de prise en compte (DPC) de dernière mise à jour des données.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.code_activite_principale_demandeur is 'Code d''activité principale de l''établissement d''un demandeur (maître d''ouvrage) avéré en tant que personne morale - Nomenclature Naf Rév2';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.categorie_juridique_demandeur is 'Catégorie juridique d''un demandeur (maître d''ouvrage) avéré en tant que personne morale - Nomenclature Sirène.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.denomination_demandeur is 'Dénomination d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.siren_demandeur is 'Numéro SIREN d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.siret_demandeur is 'Numéro SIRET d''un demandeur (maître d''ouvrage) avéré en tant que personne morale.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.superficie_terrain is 'Superficie du terrain.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.nature_projet is 'Nature de projet détaillée : 
- nouvelle construction, 
- travaux sur construction existante
    * transformation sans extension ni diminution de surface (inclut les changements de destination, réhabilitations, scissions/regroupements de logements ...), 
    * transformation avec extension de surface, 
    * transformation avec diminution de surface, 
    * extension de surface sans transformation, 
    * diminution de surface sans transformation
N.B. Il s''agit du projet complété ou par défaut du projet déclaré';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.destination_principale is 'Destination principale des surfaces créées : 
- résidentiel, 
- non résidentiel
  * hébergement hôtelier, 
  * bureaux, 
  * commerce,
  * artisanat, 
  * industrie, 
  * agriculture, 
  * entrepôt, 
  * service public ou d''intérêt collectif
N.B. Quand le détail du non résidentiel n''est pas donnée, seulement est indiqué ''non résidentiel'', sinon, les 
    catégories sont détaillées.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_princip_logts_crees is 'Type principal des logements créés :
- un logement individuel,
- plusieurs logements individuels,
- collectif hors résidence,
- résidence
N.B. Type principal selon le nombre de logements créés : il peut donc y avoir des logements individuels dans un permis de type "collectif hors résidences"';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_transfo_principal is 'Type principal de transformation :
- transformation de locaux en logements (changement de destination), 
- transformation de logements (réhabilitation, scission, regroupement ...), 
- transformation de logements en locaux non résidentiels (changement de destination), 
- transformation de locaux non résidentiels (changement de destination, réhabilitation, scission, regroupement ...)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_princip_locaux_transformes is 'Type principal des locaux d''origine transformés :
- résidentiel, 
- non résidentiel, 
  * hébergement hôtelier, 
  * bureaux, 
  * commerce, 
  * artisanat, 
  * industrie, 
  * agriculture, 
  * entrepôt, 
  * service public ou d''intérêt collectif
N.B. Quand le détail du non résidentiel n''est pas donnée, seulement est indiqué ''non résidentiel'', sinon, les catégories sont détaillées.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.indicateur_extension is 'Indicateur pour la présence d''une extension.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.indicateur_surelevation_ou_nivsupp is 'Indicateur pour la présence d''une surélévation ou d''un niveau supérieur.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.residence_princip_ou_second is 'Type d''habitation principale ou secondaire. Valable que si occupation personnelle :
- résidence principale
- résidence secondaire';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_annexe is 'Type d''annexe
- Piscine, 
- Garage, 
- Véranda, 
- Abri de Jardin, 
- Autre annexe, 
- plusieurs annexes,
- pas d’annexe';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.residence is 'Type de résidence 
- res pour personnes âgées, 
- res étudiantes, 
- res de tourisme,
- res hôtelière à vocation sociale,
- res sociale, 
- res pour handicapés, 
- autre res, 
- projet mixte, 
N.B.: Pour les projets mixtes (logements ordinaires / résidence), traitement interne Sitadel pour ce que cette 
catégorie ne soit définie que si la résidence représente la majorité des logements du projet.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.nb_log_tot_crees is 'Nombre total de logements créés.
N.B.: Une transformation d''un 3 pièces en 2 studios est généralement considérée comme créant 2 logements.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.nb_log_individuels_crees is 'Nombre de logements individuels créés.
N.B.: Une maison individuelle peut comporter 2 logements individuels (au maximum).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.nb_log_collectifs_crees is 'Nombre de logements collectifs créés.
N.B.: Les logements collectifs font partie d’un bâtiment dans lequel sont superposés plus de deux logements distincts 
dont l''accès nécessite d''emprunter des parties communes.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.nb_log_demolis is 'Nombre de logements démolis.
N.B. Insuffisamment renseigné.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_hab_avant is 'Surface de plancher de la destination '' Habitation '' existante avant travaux';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_hab_creee is 'Surface de plancher de la destination '' Habitation '' nouvelle construite.
N.B.: Lorsque le projet crée des chambres (sans coin cuisine indépendant) et non des logements, on utilise plutôt la 
destination "Hébergement hôtelier" ou "Service Public" dans Sitadel plutôt que la destination "Habitation".';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_hab_issue_transfo is 'Surface de plancher de la destination '' Habitation '' issue d''une transformation (changement de destination, 
réhabilitation, scission, regroupement …).
N.B.: Surface issue d''un changement de destination ou d''un mouvement interne (cas où les surfaces supprimée et créée 
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_hab_demolie is 'Surface de plancher de la destination '' Habitation '' supprimée (démolie)';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_hab_transformee is 'Surface de plancher de la destination '' Habitation '' transformée (changement de destination, réhabilitation, 
scission, regroupement ...).
N.B.: Surface issue d''un changement de destination ou d''un mouvement interne (cas où les surfaces supprimée et créée 
sont identiques sur une même ligne, qui correspondent le plus souvent à des réhabilitations, scissions, regroupements …).';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_loc_avant is 'Surface de plancher de locaux non résidentiels existante avant travaux.
Total des surfaces des destinations autres que d''habitation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_loc_creee is 'Surface de plancher de locaux non résidentiels nouvelle construite.
Total des surfaces des destinations autres que d''habitation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_loc_issue_transfo is 'Surface de plancher de locaux non résidentiels issue d''une transformation (changement 
de destination, réhabilitation, scission, regroupement …).
Total des surfaces des destinations autres que d''habitation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_loc_demolie is 'Surface de plancher de locaux non résidentiels démolie.
Total des surfaces des destinations autres que d''habitation';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.s_loc_transformee is 'Surface de plancher de locaux non résidentiels transformée (changement de destination,
réhabilitation, scission, regroupement ...).
Total des surfaces des destinations autres que d''habitation.';
    COMMENT ON COLUMN bdnb_2025_07_a_open_data_dep01.sitadel.type_service_public is 'Type de service public ou d''intérêt collectif : 
- Transport, 
- Enseignement et recherche, 
- Santé, 
- Action sociale, 
- Ouvrage spécial, 
- Culture et loisir, 
- Plusieurs types renseignés';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.metadonnees_bdnb_version is 'Descriptions des tables de la BDNB';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.metadonnees_colonne is 'Descriptions des tables de la BDNB';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.metadonnees_jeu_de_donnee_source is 'Descriptions des tables de la BDNB';
COMMIT;
COMMENT ON TABLE bdnb_2025_07_a_open_data_dep01.metadonnees_table is 'Descriptions des tables de la BDNB';
COMMIT;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse
DROP CONSTRAINT IF EXISTS adresse_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse
ADD PRIMARY KEY (cle_interop_adr);

CREATE INDEX IF NOT EXISTS adresse_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.adresse
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse_metrique
DROP CONSTRAINT IF EXISTS adresse_metrique_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse_metrique
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.adresse_metrique
ADD PRIMARY KEY (cle_interop_adr);

CREATE INDEX IF NOT EXISTS adresse_metrique_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.adresse_metrique
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse
DROP CONSTRAINT IF EXISTS rel_batiment_construction_adresse_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse
ADD PRIMARY KEY (batiment_construction_id, cle_interop_adr);

CREATE INDEX IF NOT EXISTS rel_batiment_construction_adresse_cle_interop_adr_idx
ON bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse
USING BTREE(cle_interop_adr);
CREATE INDEX IF NOT EXISTS rel_batiment_construction_adresse_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.rel_batiment_construction_adresse
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse
DROP CONSTRAINT IF EXISTS rel_batiment_groupe_adresse_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse
ADD PRIMARY KEY (batiment_groupe_id, cle_interop_adr);

CREATE INDEX IF NOT EXISTS rel_batiment_groupe_adresse_cle_interop_adr_idx
ON bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse
USING BTREE(cle_interop_adr);
CREATE INDEX IF NOT EXISTS rel_batiment_groupe_adresse_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.rel_batiment_groupe_adresse
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_construction
DROP CONSTRAINT IF EXISTS batiment_construction_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_construction
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_construction
ADD PRIMARY KEY (batiment_construction_id);

CREATE INDEX IF NOT EXISTS batiment_construction_batiment_groupe_id_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_construction
USING BTREE(batiment_groupe_id);
CREATE INDEX IF NOT EXISTS batiment_construction_code_commune_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_construction
USING BTREE(code_commune_insee);
CREATE INDEX IF NOT EXISTS batiment_construction_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_construction
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_construction_code_iris_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_construction
USING BTREE(code_iris);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe
DROP CONSTRAINT IF EXISTS batiment_groupe_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_code_commune_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe
USING BTREE(code_commune_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_code_epci_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe
USING BTREE(code_epci_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_code_iris_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe
USING BTREE(code_iris);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse
DROP CONSTRAINT IF EXISTS batiment_groupe_adresse_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_adresse_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_adresse
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles
DROP CONSTRAINT IF EXISTS batiment_groupe_argiles_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_argiles_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_argiles
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat
DROP CONSTRAINT IF EXISTS batiment_groupe_bdtopo_bat_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_bdtopo_bat_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_bat
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ
DROP CONSTRAINT IF EXISTS batiment_groupe_bdtopo_equ_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_bdtopo_equ_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_equ
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac
DROP CONSTRAINT IF EXISTS batiment_groupe_bdtopo_zoac_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_bdtopo_zoac_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_bdtopo_zoac
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe
DROP CONSTRAINT IF EXISTS batiment_groupe_bpe_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_bpe_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_bpe
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime
DROP CONSTRAINT IF EXISTS batiment_groupe_dle_elec_multimillesime_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime
ADD PRIMARY KEY (batiment_groupe_id, millesime);

CREATE INDEX IF NOT EXISTS batiment_groupe_dle_elec_multimillesime_code_departement_insee_
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_dle_elec_multimillesime_millesime_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_elec_multimillesime
USING BTREE(millesime);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime
DROP CONSTRAINT IF EXISTS batiment_groupe_dle_gaz_multimillesime_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime
ADD PRIMARY KEY (batiment_groupe_id, millesime);

CREATE INDEX IF NOT EXISTS batiment_groupe_dle_gaz_multimillesime_code_departement_insee_i
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_dle_gaz_multimillesime_millesime_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_gaz_multimillesime
USING BTREE(millesime);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime
DROP CONSTRAINT IF EXISTS batiment_groupe_dle_reseaux_multimillesime_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime
ADD PRIMARY KEY (batiment_groupe_id, millesime);

CREATE INDEX IF NOT EXISTS batiment_groupe_dle_reseaux_multimillesime_code_departement_ins
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_dle_reseaux_multimillesime_millesime_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dle_reseaux_multimillesime
USING BTREE(millesime);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement
DROP CONSTRAINT IF EXISTS batiment_groupe_dpe_representatif_logement_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_dpe_representatif_logement_code_departement_ins
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_representatif_logement
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement
DROP CONSTRAINT IF EXISTS batiment_groupe_dpe_statistique_logement_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_statistique_logement
ADD PRIMARY KEY (batiment_groupe_id);



ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire
DROP CONSTRAINT IF EXISTS batiment_groupe_dpe_tertiaire_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_dpe_tertiaire_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dpe_tertiaire
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif
DROP CONSTRAINT IF EXISTS batiment_groupe_dvf_open_representatif_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_dvf_open_representatif_code_departement_insee_i
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif
USING BTREE(code_departement_insee);
CREATE INDEX IF NOT EXISTS batiment_groupe_dvf_open_representatif_id_opendata_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_representatif
USING BTREE(id_opendata);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique
DROP CONSTRAINT IF EXISTS batiment_groupe_dvf_open_statistique_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_dvf_open_statistique_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_dvf_open_statistique
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat
DROP CONSTRAINT IF EXISTS batiment_groupe_ffo_bat_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_ffo_bat_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_ffo_bat
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx
DROP CONSTRAINT IF EXISTS batiment_groupe_geospx_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_geospx_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_geospx
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd
DROP CONSTRAINT IF EXISTS batiment_groupe_hthd_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_hthd_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_hthd
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
DROP CONSTRAINT IF EXISTS batiment_groupe_indicateur_reseau_chaud_froid_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_indicateur_reseau_chaud_froid_id_reseau_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
USING BTREE(id_reseau);
CREATE INDEX IF NOT EXISTS batiment_groupe_indicateur_reseau_chaud_froid_id_reseau_bdnb_id
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
USING BTREE(id_reseau_bdnb);
CREATE INDEX IF NOT EXISTS batiment_groupe_indicateur_reseau_chaud_froid_code_departement_
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_indicateur_reseau_chaud_froid
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee
DROP CONSTRAINT IF EXISTS batiment_groupe_merimee_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_groupe_merimee_code_departement_insee_idx
ON bdnb_2025_07_a_open_data_dep01.batiment_groupe_merimee
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv
DROP CONSTRAINT IF EXISTS batiment_groupe_qpv_pk;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_2025_07_a_open_data_dep01.batiment_groupe_qpv
ADD PRIMARY KEY (batiment_groupe_id);

CREATE INDEX IF NOT EXISTS batiment_gr