SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep01;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep01 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000D6F6E4ADA8EA2941666666D650095941	010010000	Z	L'Abergement-Clémenciat	0100100	01001	01	84	16
\.
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "commune_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" IS 'Données sur contours des communes, issues de l''agrégation des IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE (Intégration des arrondissements)';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','commune','geom_commune',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','commune','geom_commune_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','commune','geom_commune_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."code_commune_insee" IS 'Code commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "type_commune" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."type_commune" IS 'Type de commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "commune_parente" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."commune_parente" IS 'commune associée dans les cas complexes des arrondissements';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "code_arrondissement" VARCHAR(3);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."code_arrondissement" IS 'Code arrondissement';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "code_canton" VARCHAR(4);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."code_canton" IS 'Code canton';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "libelle_commune" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."libelle_commune" IS 'Nom de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "nb_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."nb_iris" IS 'Nombre d''IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ADD COLUMN "s_geom_commune" INT8;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune"."s_geom_commune" IS 'Superficie de la commune [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" ("geom_commune", "geom_commune_simplifiee_10m", "geom_commune_pos", "code_commune_insee", "type_commune", "commune_parente", "code_arrondissement", "code_canton", "libelle_commune", "code_departement_insee", "nb_iris", "s_geom_commune") FROM STDIN;
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	01010000206A080000D6F6E4ADA8EA2941666666D650095941	01001	commune	\N	012	0108	L'Abergement-Clémenciat	01	1	16
\.
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "departement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" IS 'Données INSEE/IGN sur les départements (Hexagone + Corse)';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','departement','geom_departement',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','departement','geom_departement_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep01','departement','geom_departement_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "libelle_departement" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."libelle_departement" IS 'Nom du département';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "chef_lieu" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."chef_lieu" IS 'Nom du chef-lieu';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."code_region_insee" IS 'Nom de la région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "type_departement" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."type_departement" IS 'Catégorie de département ou territoire (DEPH : departement de l''hexagone, DROM : département et région d''outre mer, COM : Collectivité d''Outre-mer, TOM : Territoire d''outre-mer';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "nb_commune" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."nb_commune" IS 'Nombre de commune associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ADD COLUMN "s_geom_departement" INT8;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement"."s_geom_departement" IS 'Superficie du département [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" ("geom_departement", "geom_departement_simplifiee_10m", "geom_departement_pos", "code_departement_insee", "libelle_departement", "chef_lieu", "code_region_insee", "type_departement", "nb_commune", "s_geom_departement") FROM STDIN;
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	01010000206A0800001110F1723EC12A41666666E6EA005941	01	Ain	01053	84	DEPH	391	5774
\.
CREATE INDEX "iris_geom_iris_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" USING GIST ("geom_iris");
CREATE INDEX "iris_geom_iris_simplifiee_10m_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" USING GIST ("geom_iris_simplifiee_10m");
CREATE INDEX "iris_geom_iris_pos_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."iris" USING GIST ("geom_iris_pos");
CREATE INDEX "commune_geom_commune_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" USING GIST ("geom_commune");
CREATE INDEX "commune_geom_commune_simplifiee_10m_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" USING GIST ("geom_commune_simplifiee_10m");
CREATE INDEX "commune_geom_commune_pos_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."commune" USING GIST ("geom_commune_pos");
CREATE INDEX "departement_geom_departement_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" USING GIST ("geom_departement");
CREATE INDEX "departement_geom_departement_simplifiee_10m_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" USING GIST ("geom_departement_simplifiee_10m");
CREATE INDEX "departement_geom_departement_pos_geom_idx" ON "bdnb_ref_admin_2025_07_a_open_data_dep01"."departement" USING GIST ("geom_departement_pos");
COMMENT ON TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.iris is 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.code_iris is 'Code IRIS';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.type_iris is 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.libelle_iris is 'Nom de l''IRIS';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.code_grand_iris is 'code du grand IRIS associé';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.code_commune_insee is 'Code INSEE de la commune';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.code_region_insee is 'Identifiant de la Région associée';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.s_geom_iris is 'Superficie de l''iris [km²]';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.geom_iris is 'Contours géographiques détaillés des IRIS (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.geom_iris_simplifiee_10m is 'Contours géographiques simplifiés à 10m des IRIS (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.iris.geom_iris_pos is 'Point sur la surface des IRIS (Lambert-93, SRID=2154)';
COMMIT;
COMMENT ON TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.commune is 'Données sur contours des communes, issues de l''agrégation des IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE (Intégration des arrondissements)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.code_commune_insee is 'Code commune';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.type_commune is 'Type de commune';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.commune_parente is 'commune associée dans les cas complexes des arrondissements';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.code_arrondissement is 'Code arrondissement';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.code_canton is 'Code canton';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.libelle_commune is 'Nom de la commune';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.nb_iris is 'Nombre d''IRIS associé';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.s_geom_commune is 'Superficie de la commune [km²]';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.geom_commune is 'Contours géographiques détaillés de la commune (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.geom_commune_simplifiee_10m is 'Contours géographiques simplifiés à 10m de la commune (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.commune.geom_commune_pos is 'Point sur la surface de la commune (Lambert-93, SRID=2154)';
COMMIT;
COMMENT ON TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.departement is 'Données INSEE/IGN sur les départements (Hexagone + Corse)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.code_departement_insee is 'Code département INSEE';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.libelle_departement is 'Nom du département';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.chef_lieu is 'Nom du chef-lieu';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.code_region_insee is 'Nom de la région associée';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.type_departement is 'Catégorie de département ou territoire (DEPH : departement de l''hexagone, DROM : département et région d''outre mer, COM : Collectivité d''Outre-mer, TOM : Territoire d''outre-mer';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.nb_commune is 'Nombre de commune associée';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.s_geom_departement is 'Superficie du département [km²]';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.geom_departement is 'Contours géographiques détaillés du département (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.geom_departement_simplifiee_10m is 'Contours géographiques simplifiés à 10m du département (Lambert-93, SRID=2154)';
    COMMENT ON COLUMN bdnb_ref_admin_2025_07_a_open_data_dep01.departement.geom_departement_pos is 'Point sur la surface du département (Lambert-93, SRID=2154)';
COMMIT;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.iris
DROP CONSTRAINT IF EXISTS iris_pk;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.iris
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.iris
ADD PRIMARY KEY (code_iris);

CREATE INDEX IF NOT EXISTS iris_code_commune_insee_idx
ON bdnb_ref_admin_2025_07_a_open_data_dep01.iris
USING BTREE(code_commune_insee);
CREATE INDEX IF NOT EXISTS iris_code_departement_insee_idx
ON bdnb_ref_admin_2025_07_a_open_data_dep01.iris
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.commune
DROP CONSTRAINT IF EXISTS commune_pk;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.commune
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.commune
ADD PRIMARY KEY (code_commune_insee);

CREATE INDEX IF NOT EXISTS commune_code_departement_insee_idx
ON bdnb_ref_admin_2025_07_a_open_data_dep01.commune
USING BTREE(code_departement_insee);


ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.departement
DROP CONSTRAINT IF EXISTS departement_pk;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.departement
DROP COLUMN ogc_fid;
ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.departement
ADD PRIMARY KEY (code_departement_insee);



ALTER TABLE bdnb_ref_admin_2025_07_a_open_data_dep01.iris
ADD CONSTRAINT iris_code_commune_insee_fkey
FOREIGN KEY (code_commune_insee)
REFERENCES bdnb_ref_admin_2025_07_a_open_data_dep01.commune (code_commune_insee);

