SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep02;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep02 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep02"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A080000010000000103000000010000007F0100000000000068B525419A999999C77E5A41CDCCCCCC6DB52541CDCCCCECDC7E5A4133333333D2B52541000000A0EB7E5A4166666666D6B52541666666C6F07E5A416666666603B62541333333F3F47E5A419A9999994AB62541333333D3277F5A419A99999954B62541000000C02B7F5A41666666665BB62541000000402F7F5A410000000060B62541CDCCCC2C327F5A416666666666B6254166666686367F5A41CDCCCCCC6BB62541CDCCCCCC397F5A41000000006DB62541333333B33A7F5A413333333383B62541333333B3397F5A4100000000A3B625419A9999F9387F5A4133333333C0B62541CDCCCCCC387F5A4166666666E3B6254166666626397F5A413333333316B72541666666463A7F5A41CDCCCCCC53B72541666666A63B7F5A419A9999998BB72541333333533D7F5A4166666666ADB72541333333333E7F5A4100000000D5B72541333333F33E7F5A413333333304B82541333333B33F7F5A41CDCCCCCC37B8254133333353407F5A419A99999971B82541CDCCCCCC407F5A4133333333A6B8254100000060417F5A41CDCCCCCCB7B82541666666A6417F5A41CDCCCCCCD1B8254133333313427F5A419A99999913B92541333333F3427F5A41CDCCCCCC39B92541666666A6437F5A41CDCCCCCCA2B9254100000060457F5A41CDCCCCCCE2B92541CDCCCC4C467F5A41CDCCCCCC1ABA25419A999959477F5A416666666652BA254100000040487F5A41000000007ABA254166666606497F5A419A9999998FBA2541CDCCCCAC497F5A4166666666B2BA2541333333F34A7F5A4166666666E3BA25419A9999394D7F5A413333333316BB2541000000804F7F5A419A9999994BBB2541CDCCCC0C527F5A41CDCCCCCC75BB2541666666C6537F5A419A9999999FBB25419A999979557F5A410000000010BC2541000000A05B7F5A416666666676BC2541333333F3607F5A4100000000A3BC254166666666637F5A4133333333DFBC254166666666667F5A416666666634BD2541000000206B7F5A413333333388BD2541666666A66F7F5A4166666666C5BD2541666666A6727F5A41CDCCCCCC0FBE25419A999959767F5A4133333333AABE254100000000807F5A413333333342BF2541CDCCCC0C887F5A4100000000B6BF2541333333138E7F5A4133333333EEBF2541CDCCCC2C907F5A413333333330C0254100000040927F5A41CDCCCCCC94C0254133333313907F5A410000000091C02541CDCCCC8C8B7F5A41CDCCCCCC84C02541333333938A7F5A41CDCCCCCC7FC0254166666646897F5A410000000075C025419A999999867F5A416666666674C02541333333F3837F5A410000000075C02541CDCCCC6C827F5A416666666677C025419A999959817F5A41666666667AC02541666666067F7F5A410000000083C02541CDCCCC0C7C7F5A41CDCCCCCC94C025419A999959737F5A41000000009EC0254133333353707F5A419A999999DBC0254133333393607F5A4133333333ECC02541000000C05B7F5A4100000000FEC0254100000000557F5A416666666616C12541333333534E7F5A413333333336C12541000000A0457F5A413333333347C12541333333D3407F5A41CDCCCCCC59C125419A9999F9367F5A419A99999965C12541CDCCCC8C337F5A419A9999997FC12541666666E62A7F5A4100000000ADC12541000000802E7F5A41CDCCCCCCC1C12541333333932F7F5A4133333333CDC1254133333313307F5A41CDCCCCCCDDC12541000000C0297F5A41CDCCCCCCE9C1254100000020287F5A4100000000F7C12541666666C6237F5A413333333303C225419A9999791F7F5A41000000000BC22541666666461D7F5A419A9999990DC225419A9999991B7F5A41CDCCCCCC16C225419A999999197F5A419A9999991BC2254133333333177F5A419A99999924C225419A9999B9157F5A410000000037C2254100000060127F5A416666666644C22541CDCCCCEC0E7F5A419A99999936C22541000000A00B7F5A41CDCCCCCC6BC22541333333B3047F5A419A999999A9C2254133333313FF7E5A4166666666E0C22541CDCCCC4CF97E5A419A999999F8C2254100000000F77E5A41CDCCCCCC0AC3254166666666F47E5A410000000055C32541CDCCCC0CEA7E5A416666666666C325419A9999D9E87E5A41CDCCCCCCC4C325419A999919E37E5A4166666666D8C3254100000060E17E5A413333333300C425419A9999F9D57E5A41CDCCCCCC2DC42541000000A0CF7E5A41CDCCCCCC3DC4254133333393CC7E5A419A9999994EC4254166666646C47E5A410000000055C4254133333373BE7E5A413333333365C42541CDCCCC4CB17E5A41CDCCCCCC69C425419A999979AC7E5A416666666678C42541CDCCCCECA67E5A41CDCCCCCC81C425419A999959A37E5A419A99999974C42541000000E0947E5A41CDCCCCCC71C4254100000060937E5A410000000078C42541333333738B7E5A41333333337BC42541666666E67D7E5A419A99999985C42541CDCCCC4C797E5A4100000000A1C42541333333936D7E5A4166666666A2C42541666666E66B7E5A41666666669EC4254100000060677E5A413333333399C425419A999999607E5A41CDCCCCCC95C42541000000605E7E5A4100000000B2C42541CDCCCCEC477E5A41CDCCCCCCC1C42541CDCCCC0C3E7E5A4133333333C5C4254166666686377E5A41CDCCCCCCC0C425419A999979277E5A419A999999BDC4254100000020237E5A41CDCCCCCCBBC425419A9999391F7E5A4166666666A2C42541CDCCCC0C1F7E5A41666666666EC42541000000A01E7E5A4100000000D5C32541333333731D7E5A41666666667EC32541666666C61C7E5A419A9999991BC325419A9999591B7E5A41CDCCCCCC3EC325419A999919147E5A419A9999994BC32541CDCCCCCC0F7E5A416666666650C3254166666666FE7D5A41CDCCCCCC56C325419A9999D9F77D5A41CDCCCCCC5CC3254166666666EC7D5A41CDCCCCCC4FC32541CDCCCCACE87D5A419A9999997BC32541CDCCCC2CE77D5A41CDCCCCCCEAC32541CDCCCC0CE17D5A410000000014C4254166666666DF7D5A416666666625C425419A999939DF7D5A413333333325C42541333333F3E07D5A41000000001FC425419A999999E37D5A4100000000ABC42541CDCCCCACE07D5A410000000063C52541333333F3D57D5A41CDCCCCCC7AC5254166666666D47D5A419A99999981C62541666666E6D57D5A4100000000EAC625419A999939B97D5A41333333335DC7254100000000BA7D5A41333333339BC7254100000080BC7D5A419A9999998CC7254100000080AF7D5A419A9999997AC725419A9999D9A57D5A419A9999996DC72541000000609F7D5A419A99999978C7254166666606987D5A41CDCCCCCCB8C725419A999979877D5A4166666666ECC72541333333D3817D5A41CDCCCCCC5BC825419A999979817D5A41CDCCCCCC9EC825419A999939827D5A419A999999BCC825419A9999797F7D5A41CDCCCCCCE7C82541CDCCCCCC827D5A41000000003AC92541000000E0847D5A419A99999995CA25419A9999794C7D5A4133333333F2CA2541CDCCCC6C3D7D5A41CDCCCCCCFCCB254133333393537D5A41CDCCCCCC21CD2541333333336C7D5A4133333333ACCF254166666666A27D5A4100000000A0CF25419A9999399E7D5A41CDCCCCCC3BD22541CDCCCCAC207D5A419A9999991DD22541CDCCCC2C207D5A4166666666FDD12541666666261E7D5A4133333333EFD1254133333333197D5A4133333333E8D1254133333393117D5A4100000000E6D125419A9999190B7D5A4100000000E1D12541CDCCCC6C067D5A4133333333C3D12541CDCCCC4C017D5A4166666666A5D12541CDCCCC8C007D5A413333333375D12541CDCCCC4C017D5A41333333332DD12541666666E6047D5A419A99999909D12541CDCCCCCC067D5A419A999999E0D025419A999939077D5A4166666666B6D02541CDCCCC8C067D5A413333333390D02541666666E6047D5A410000000057D0254100000060067D5A416666666624D0254166666686087D5A419A99999908D0254133333353087D5A4100000000EDCF254100000060077D5A4100000000B8CF2541000000E0077D5A416666666677CF2541CDCCCC0C097D5A413333333340CF2541666666460A7D5A41CDCCCCCC1DCF2541CDCCCC6C097D5A4133333333F5CE2541333333D3077D5A41CDCCCCCCC0CE2541000000C0047D5A419A999999A4CE2541CDCCCCCC017D5A41333333339ECE25419A9999B9FC7C5A410000000098CE254166666646F37C5A41CDCCCCCC92CE25419A9999F9EE7C5A416666666688CE25419A9999D9EB7C5A41333333338FCE254166666646E77C5A4133333333A7CE2541CDCCCCCCE07C5A4166666666D2CE2541333333F3DB7C5A4100000000F9CE254133333353D77C5A419A999999FACE2541333333F3D27C5A41CDCCCCCCF1CE254100000080CC7C5A4100000000C3CE254166666646C47C5A413333333386CE2541000000A0BD7C5A410000000043CE2541000000A0BA7C5A41CDCCCCCC04CE25419A9999F9B97C5A4133333333D9CD254133333373BB7C5A41CDCCCCCCA5CD2541000000E0BF7C5A410000000081CD2541CDCCCCCCC57C5A419A99999966CD2541CDCCCCACCC7C5A41666666664DCD2541CDCCCC4CD47C5A413333333349CD25419A999939D57C5A41000000002DCD254166666646DB7C5A419A99999925CD25419A999919DE7C5A4166666666F6CC25419A999939E37C5A4166666666C4CC254166666626E97C5A41CDCCCCCCA1CC254133333353EE7C5A419A99999986CC254166666666EF7C5A419A99999955CC25419A999939F07C5A410000000007CC254166666666EE7C5A4133333333B9CB25419A999999EC7C5A419A9999997CCB254166666606EB7C5A413333333356CB254100000000EB7C5A41000000000CCB254166666646E77C5A419A999999D5CA254166666606E47C5A4100000000ACCA254166666686DD7C5A41333333338ACA25419A999979D47C5A419A99999958CA25419A999959CB7C5A4100000000FCC92541000000E0C27C5A41333333339FC925419A9999F9BC7C5A41CDCCCCCC77C92541CDCCCC6CBA7C5A41CDCCCCCC71C92541CDCCCC0CBA7C5A419A9999996CC92541333333B3B97C5A419A99999928C9254166666646B57C5A41333333330FC92541000000A0B37C5A41666666668DC8254133333313AB7C5A419A9999993BC82541333333F3A67C5A4133333333CFC72541666666A6A47C5A419A9999990BC7254166666646A27C5A4166666666B9C62541666666A6A07C5A413333333381C62541000000E09C7C5A41333333332CC62541333333139B7C5A4133333333BDC52541000000009D7C5A419A99999977C52541333333B39E7C5A416666666631C525419A9999D99E7C5A419A999999F8C42541333333339C7C5A4133333333D2C42541333333F3987C5A419A999999B4C42541CDCCCC0C957C5A419A999999AAC42541666666068F7C5A41CDCCCCCCB8C4254133333393877C5A41CDCCCCCCE0C4254166666606767C5A41333333332BC52541000000805D7C5A41CDCCCCCC3AC52541CDCCCC2C557C5A41666666663AC52541000000804E7C5A416666666622C52541000000004B7C5A419A99999905C52541000000004A7C5A419A999999C9C4254166666626497C5A41333333338FC4254133333313457C5A410000000072C425419A9999B9437C5A419A99999915C4254133333333427C5A41666666667DC32541CDCCCC8C407C5A413333333307C32541CDCCCC8C377C5A4100000000F1C2254100000020327C5A419A999999D2C22541333333B3307C5A41CDCCCCCC8DC225419A999939307C5A41CDCCCCCC57C22541000000E0327C5A413333333322C225419A9999F9357C5A419A999999F1C125419A999959387C5A419A999999C8C125419A999959387C5A41CDCCCCCCA9C125419A999919357C5A419A99999998C12541CDCCCCAC2E7C5A41CDCCCCCC9AC12541CDCCCCEC277C5A4133333333B5C12541333333B31F7C5A41CDCCCCCCDAC1254166666626157C5A4133333333F8C12541666666660E7C5A41CDCCCCCC05C22541CDCCCCEC087C5A413333333317C2254100000060FD7B5A41666666660AC22541CDCCCC6CF67B5A4100000000FCC1254100000060F17B5A4133333333CBC1254133333313F07B5A41000000007FC1254166666626F57B5A419A99999940C12541666666A6FB7B5A4100000000F7C02541666666C6047C5A419A999999B1C02541000000A00E7C5A419A99999992C02541CDCCCC8C147C5A416666666676C025419A999939177C5A413333333357C0254100000020187C5A416666666640C0254133333393177C5A419A9999999FBF254166666606347C5A4166666666B3BF2541CDCCCC2C3B7C5A4100000000B6BF25419A9999993D7C5A419A9999998FBF254166666646457C5A41666666667DBF2541000000C0437C5A41CDCCCCCC16BF2541333333333B7C5A4100000000D8BE2541666666C6357C5A413333333386BE2541CDCCCC0C2F7C5A41CDCCCCCC82BE2541000000E02F7C5A41666666667ABE254100000000327C5A419A99999970BE2541000000A0347C5A410000000057BE2541333333533B7C5A419A9999993EBE254100000060457C5A413333333337BE2541666666C64E7C5A419A99999942BE2541CDCCCC0C567C5A41000000002CBE2541CDCCCC6C5E7C5A419A999999ECBC2541CDCCCC8C4A7C5A41CDCCCCCCDEBC2541333333134E7C5A410000000006BC2541333333536D7C5A41CDCCCCCCB1BB2541333333B3877C5A41CDCCCCCC39BB254100000040AC7C5A413333333300BB25419A9999F9B47C5A413333333306BB254166666626B97C5A419A99999911BB2541CDCCCCACBE7C5A416666666609BB2541000000E0C27C5A419A999999FCB9254100000020EC7C5A4166666666F7B9254133333313F37C5A4166666666EFB92541000000A0F87C5A419A999999EFB92541333333B3FA7C5A41333333332ABA2541666666C6FD7C5A4166666666C6B92541333333F3297D5A4166666666C9B92541333333132D7D5A413333333341BA2541666666E6337D5A419A999999C0B925419A999979507D5A419A9999996ABA25419A9999F9587D5A419A99999956BA2541CDCCCC0C7C7D5A416666666643BA254133333393847D5A4100000000C9B9254133333333A27D5A4166666666A3B9254100000080AC7D5A41CDCCCCCC9CB925419A999959AE7D5A41CDCCCCCC91B9254133333313B27D5A416666666687B9254166666686B57D5A416666666678B92541000000E0B77D5A419A9999996EB92541CDCCCCACB97D5A41CDCCCCCC69B92541000000E0BB7D5A41CDCCCCCC69B925419A999979BE7D5A41333333336AB9254133333333C07D5A41CDCCCCCC66B925419A999959C47D5A410000000062B92541000000C0C57D5A41666666665AB925419A9999F9C77D5A41333333334CB92541CDCCCCCCCA7D5A413333333318B92541CDCCCC4CD57D5A4100000000F3B82541333333F3DC7D5A4100000000DEB82541CDCCCC8CE17D5A4133333333D4B825419A9999D9E27D5A419A999999C5B8254133333333E47D5A4166666666A5B8254166666626E77D5A419A99999976B8254133333333EC7D5A41000000003FB8254166666646F17D5A41333333330AB82541000000A0F57D5A4100000000F1B72541333333D3F77D5A4133333333E3B7254100000040F97D5A41CDCCCCCCDBB725419A999959F97D5A41CDCCCCCCCDB7254166666666F97D5A4166666666B4B72541333333F3F87D5A419A999999A1B725419A999979F87D5A416666666694B72541CDCCCC6CF97D5A41CDCCCCCC81B7254100000040FC7D5A41CDCCCCCC6CB72541CDCCCCECFF7D5A41000000004EB725419A9999B9047E5A41CDCCCCCC39B7254100000060087E5A41CDCCCCCC30B72541CDCCCC4C087E5A419A99999927B72541CDCCCC6C077E5A419A9999991CB72541CDCCCC2C077E5A41CDCCCCCC07B72541333333D3097E5A4100000000F3B62541000000C00C7E5A4100000000E6B6254133333333107E5A4166666666D2B62541CDCCCCAC147E5A4100000000B8B62541CDCCCC4C1B7E5A410000000091B62541CDCCCC8C277E5A419A9999998AB6254133333313377E5A410000000089B625419A9999D93A7E5A416666666683B6254133333313457E5A419A99999981B62541CDCCCC2C597E5A413333333380B62541CDCCCCAC647E5A419A99999981B625419A9999196B7E5A41666666667CB62541CDCCCC8C6C7E5A41000000006CB62541000000E0707E5A416666666655B625419A9999B9787E5A413333333341B6254100000020827E5A410000000020B62541666666A6907E5A41CDCCCCCC0EB6254166666606977E5A4166666666D3B52541666666C6A87E5A41CDCCCCCCA4B52541666666A6B57E5A413333333385B525419A999939C07E5A410000000068B525419A999999C77E5A41	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	01010000206A080000E6AE7EC618C0254166666646C27D5A41	020010000	Z	Abbécourt	0200100	02001	02	32	6
\.
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "commune_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" IS 'Données sur contours des communes, issues de l''agrégation des IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE (Intégration des arrondissements)';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','commune','geom_commune',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','commune','geom_commune_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','commune','geom_commune_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."code_commune_insee" IS 'Code commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "type_commune" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."type_commune" IS 'Type de commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "commune_parente" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."commune_parente" IS 'commune associée dans les cas complexes des arrondissements';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "code_arrondissement" VARCHAR(3);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."code_arrondissement" IS 'Code arrondissement';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "code_canton" VARCHAR(4);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."code_canton" IS 'Code canton';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "libelle_commune" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."libelle_commune" IS 'Nom de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "nb_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."nb_iris" IS 'Nombre d''IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ADD COLUMN "s_geom_commune" INT8;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune"."s_geom_commune" IS 'Superficie de la commune [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep02"."commune" ("geom_commune", "geom_commune_simplifiee_10m", "geom_commune_pos", "code_commune_insee", "type_commune", "commune_parente", "code_arrondissement", "code_canton", "libelle_commune", "code_departement_insee", "nb_iris", "s_geom_commune") FROM STDIN;
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	01010000206A08000060FBF2223769264133333323C37D5A41	02122	commune	\N	022	0218	Brie	02	1	3
\.
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "departement_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" IS 'Données INSEE/IGN sur les départements (Hexagone + Corse)';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','departement','geom_departement',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','departement','geom_departement_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep02','departement','geom_departement_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "libelle_departement" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."libelle_departement" IS 'Nom du département';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "chef_lieu" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."chef_lieu" IS 'Nom du chef-lieu';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."code_region_insee" IS 'Nom de la région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "type_departement" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."type_departement" IS 'Catégorie de département ou territoire (DEPH : departement de l''hexagone, DROM : département et région d''outre mer, COM : Collectivité d''Outre-mer, TOM : Territoire d''outre-mer';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "nb_commune" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."nb_commune" IS 'Nombre de commune associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ADD COLUMN "s_geom_departement" INT8;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement"."s_geom_departement" IS 'Superficie du département [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep02"."departement" ("geom_departement", "geom_departement_simplifiee_10m", "geom_departement_pos", "code_departement_insee", "libelle_departement", "chef_lieu", "code_region_insee", "type_departement", "nb_commune", "s_geom_departement") FROM STDIN;
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