SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep04;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep04 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep04','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep04','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep04','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep04"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000D2A1D9A0BE082D41343333B3E4295841	040010000	Z	Aiglun	0400100	04001	04	93	15
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	01010000206A080000E9E9578426D02C419A9999992E0C5841	040040000	Z	Allemagne-en-Provence	0400400	04004	04	93	33
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	01010000206A080000A5A52532E1262E419A9999C906225841	040050000	Z	Allons	0400500	04005	04	93	42
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	01060000206A08000001000000010300000001000000EE020000000000005DF62D41666666C6904358413333333367F62D4100000080944358419A999999ADF62D41CDCCCCAC9A4358413333333331F72D4100000080B24358410000000079F72D41666666A6CC435841666666668DF72D419A9999D9F043584166666666E8F72D419A9999F90044584133333333FDF72D41333333730D44584100000000F4F72D413333337317445841CDCCCCCCCCF72D419A9999B92244584166666666BAF72D419A99993939445841666666669EF72D41333333F373445841CDCCCCCC9FF72D41CDCCCCEC87445841CDCCCCCC2CF82D419A999939B64458410000000024F82D419A999939C5445841CDCCCCCC37F72D41CDCCCC2CFB4458416666666619F72D41333333330F455841000000001BF72D416666662628455841CDCCCCCCE9F62D4133333333324558419A999999FEF62D41CDCCCC6C3D4558416666666659F72D41CDCCCC4C4C455841666666660EF82D419A9999995D455841CDCCCCCC5EF82D41000000C063455841CDCCCCCCF5F82D413333335375455841333333335AF92D41333333B37C4558416666666697F92D41000000208E45584133333333CAF92D4166666646B74558413333333311FA2D41CDCCCC6CC745584133333333FEF92D41333333F3D345584166666666CDF92D419A999979E545584100000000CDF92D41333333F3FB455841000000000BFA2D419A9999591B4658410000000003FA2D41333333133846584100000000BFF92D41000000605246584100000000C8F92D419A99995961465841CDCCCCCC2DFA2D419A9999797B465841666666667EFA2D41000000E0874658416666666615FB2D41333333B3964658410000000085FB2D41CDCCCCCCAF4658413333333369FB2D41CDCCCC4CD0465841666666666AFB2D4100000080FE465841CDCCCCCC88FB2D41333333B304475841CDCCCCCC89FB2D413333333311475841CDCCCCCC31FB2D41666666C62C4758410000000046FB2D4100000080304758416666666668FC2D410000006058475841CDCCCCCCEBFC2D419A9999796D4758419A99999907FD2D41000000E06D4758416666666653FD2D41000000006B4758419A999999A4FD2D419A9999796547584100000000F5FD2D41CDCCCC2C634758416666666669FE2D41CDCCCCEC5D4758413333333326FF2D416666664652475841CDCCCCCC8FFF2D416666668647475841CDCCCCCCB7FF2D416666662645475841CDCCCCCCDEFF2D419A9999B93E475841666666661B002E41333333B3384758419A99999982002E41000000E02B47584133333333E9002E41CDCCCCEC244758419A99999903012E4166666666204758419A99999989012E41666666A611475841666666662D022E41000000E008475841CDCCCCCC0D032E41666666E6004758413333333365032E4133333333FF46584133333333C2032E41CDCCCC6CFB4658413333333330042E4100000040FB4658419A999999B3042E4166666666FD465841000000005F052E41000000000A475841666666664E062E41333333B3D74658419A999999D0062E41CDCCCCCCCB4658419A9999992C072E41CDCCCCCCC146584166666666C2072E4100000060B046584166666666FF072E41CDCCCC8CA3465841000000001E082E4133333313A04658419A9999997C082E41666666A69E465841CDCCCCCCA0082E41000000809F4658419A999999F0082E41666666269E4658419A99999973092E41000000809D46584133333333420A2E41CDCCCC2C94465841CDCCCCCC700A2E41000000408F46584166666666DC0A2E41000000C08C465841333333331A0B2E419A9999598A465841666666666F0B2E41000000E088465841333333331B0C2E419A9999D98B465841CDCCCCCCC40C2E41666666069146584100000000040D2E41333333B385465841333333339B0D2E419A9999D96F46584133333333E70D2E419A9999D9654658419A999999690E2E41666666C65146584100000000F20E2E41000000A05546584100000000700F2E4133333333544658419A999999D90F2E419A999919584658419A9999991F102E41666666465C46584133333333D2102E4100000060654658419A99999989112E419A999939654658416666666619122E41CDCCCCCC60465841666666664C122E419A9999B95C46584100000000A7122E41000000004E465841666666660E132E416666662643465841666666662E132E416666666642465841000000007E132E41000000E03C465841CDCCCCCCAC132E4166666646384658419A999999E9132E41333333D32E4658419A9999996F142E41666666262246584100000000AA142E419A9999D9174658410000000030152E410000000002465841000000007D152E41666666C6FA45584133333333F1152E419A999919F7455841000000002D162E4133333373EF455841333333334D162E419A999959E7455841CDCCCCCC70162E419A999939E4455841CDCCCCCCDA162E4100000000DE4558410000000067172E41CDCCCC0CD34558410000000031182E41CDCCCCECC74558419A99999957182E41CDCCCC0CC4455841CDCCCCCC6D182E419A999939BF45584133333333EC182E419A999979AA4558413333333315192E41666666A6A4455841CDCCCCCC2A192E41333333139E4558419A99999966192E4133333353864558410000000097192E4100000000694558419A999999C0192E41666666C65745584100000000EC192E41CDCCCC2C4C45584166666666251A2E4166666606424558419A999999981A2E416666668633455841CDCCCCCCD31A2E41CDCCCC6C29455841000000003A1B2E41CDCCCCCC1B45584166666666531B2E41666666061745584166666666981B2E4166666646014558419A999999B31B2E4166666666FC44584166666666EC1B2E4133333393EB44584133333333051C2E41CDCCCC4CE2445841666666660A1C2E4100000040D6445841CDCCCCCC1F1C2E4166666666C844584133333333611C2E41333333D3C7445841333333333B1C2E41333333B3B8445841CDCCCCCC1B1C2E419A9999F9AE44584100000000061C2E41000000A0A444584100000000FE1B2E419A999919974458419A999999D31B2E41666666068F445841000000002E1B2E41000000607B445841CDCCCCCCEA1A2E416666666671445841CDCCCCCCCA1A2E41000000006744584133333333D31A2E41CDCCCC8C59445841CDCCCCCCD21A2E41000000804944584166666666F71A2E41666666063D44584100000000431B2E41666666E63444584133333333811B2E41666666C6324458419A999999231C2E41000000E031445841666666667F1C2E41CDCCCCAC2C4458419A999999381D2E41000000A020445841CDCCCCCC4A1D2E419A9999591E44584100000000A51D2E41000000601B44584133333333101E2E41666666C619445841333333333D1E2E41333333331B445841CDCCCCCCA81E2E41000000C00544584100000000FB1E2E41000000C0F94358419A9999997C1F2E41CDCCCC2CEF43584166666666881F2E419A9999B9EB435841CDCCCCCCE71F2E419A9999F9E6435841333333333D202E41666666E6E7435841000000008F202E41000000C0E44358410000000026212E419A999979D24358410000000087212E41000000C0CA43584100000000D3212E41CDCCCC4CC7435841000000003D222E419A999979C7435841666666665E232E41333333F3C3435841000000009C232E4100000020C84358413333333308242E419A9999D9D24358419A999999F9242E41CDCCCC6CE543584166666666CB252E4100000000F14358413333333327262E4100000080F24358416666666695262E41CDCCCC0CF9435841CDCCCCCC18272E41CDCCCC0CFF435841666666665D272E41666666E6004458419A99999996272E41CDCCCCAC0444584133333333C1272E419A9999190E4458416666666643282E41000000801A445841333333334D282E41666666C61F445841000000003E282E41333333B328445841CDCCCCCC80282E419A999999314458413333333331292E41CDCCCC4C424458410000000062292E41CDCCCC8C484458416666666691292E41000000C05044584133333333E9292E41CDCCCCEC6244584100000000702A2E41CDCCCC2C7444584100000000A92A2E41666666667F445841CDCCCCCC462B2E41000000E0884458419A999999A42B2E41CDCCCCCC8944584166666666D42B2E41000000608B44584133333333392C2E41000000209844584100000000122D2E4133333353BE4458419A999999562D2E4100000080C844584133333333A82D2E4100000020D3445841666666664D2E2E41CDCCCC8CEC445841333333339E2E2E41000000E0F7445841666666661E2F2E41000000C0F14458419A999999DD2F2E4133333313E54458413333333309302E4133333373E4445841666666664B302E419A9999F9E54458416666666678302E419A999979E4445841CDCCCCCCED302E4166666686D3445841CDCCCCCC60312E41CDCCCCECC5445841CDCCCCCCF2312E4133333393AF4458419A9999997C322E4166666646A2445841CDCCCCCC12332E4166666666964458419A999999D0332E41333333D38044584133333333E1342E41000000C0664458413333333321352E41333333B35C44584100000000CC352E41CDCCCC2C584458419A9999992A362E4166666686534458419A999999A5362E41666666064A4458410000000060372E41CDCCCC8C3E445841CDCCCCCCA0372E41333333733C445841CDCCCCCCF3372E413333331342445841333333331D382E4166666626474458416666666613392E41000000E05944584100000000BD392E419A9999B95A445841666666667C3A2E41000000E063445841CDCCCCCC083B2E41CDCCCC4C6E44584133333333503B2E41333333738344584166666666A33B2E41666666A68A4458419A999999473C2E41CDCCCC4C95445841000000009E3C2E419A9999199644584166666666A73D2E4166666686A244584133333333993E2E419A9999D9D14458419A999999983F2E41333333B3CB44584133333333BD402E419A999919BF445841CDCCCCCC92412E41CDCCCC6CB2445841333333339B422E41CDCCCC4C9B4458410000000060432E410000008082445841CDCCCCCCE9432E41000000A0764458419A99999964442E41000000405A445841CDCCCCCC8E442E4133333373584458413333333306452E41666666A6604458419A999999A9452E4133333353724458419A999999B8462E41666666C6844458413333333324472E419A9999F9854458413333333378472E41333333538C44584133333333B8472E41CDCCCC8C93445841CDCCCCCC49482E41000000809D4458419A999999B1482E4100000080A1445841333333338B492E4133333333B644584166666666D1492E4100000040BC445841CDCCCCCC274A2E41333333D3C0445841000000009B4A2E419A999939C4445841333333334C4B2E4133333333C444584133333333C44B2E41666666A6C5445841CDCCCCCC774C2E4166666626BD44584166666666064D2E41CDCCCCCCB54458419A999999354E2E41CDCCCC6CB3445841CDCCCCCCE44E2E419A9999B9B74458419A999999724F2E419A999959D6445841CDCCCCCCB34F2E419A9999D9DC44584133333333FB4F2E419A9999F9DE4458416666666660502E419A9999F9DD4458419A99999915512E419A999919CA44584133333333BF512E419A999939BB445841333333335B522E41CDCCCC0CBB4458419A999999AC532E41333333F3BF44584100000000AF542E419A999939BF445841000000000F552E41000000A0BB4458413333333341552E419A999979B644584133333333DD552E41666666A69C4458416666666651562E419A9999999F445841CDCCCCCC99562E41666666A69E445841000000007A572E41666666A6904458419A9999995A582E4166666666964458410000000013592E41333333F38944584166666666E95A2E4166666626694458419A999999D35B2E413333337360445841000000000D5D2E410000000062445841666666662E5E2E41CDCCCCAC6244584133333333755E2E419A9999D96C445841666666669E5E2E419A9999D96E44584133333333625F2E419A999939694458419A99999929602E419A9999B969445841CDCCCCCCDC602E41CDCCCC6C704458416666666636612E4133333313704458419A9999997B612E41CDCCCC0C68445841333333339D612E4166666626624458419A999999CA612E41666666865D4458413333333317622E41CDCCCC0C48445841000000007B622E419A9999D93644584100000000AC622E41333333D32B44584133333333AB622E4100000060294458419A999999FE622E41CDCCCC2C13445841666666661A632E41666666C6094458419A9999991E632E413333335304445841000000003D632E419A999939F7435841CDCCCCCC46632E4100000020EF435841CDCCCCCC42632E4100000040E5435841000000006D632E41333333F3CE435841666666669F632E4133333353BD4358419A99999952642E4133333353A943584166666666C6642E419A9999999843584133333333FC642E41000000E08743584166666666E4642E419A9999B9744358419A999999F6642E419A9999D95C4358419A99999952652E41000000E0324358410000000050652E41CDCCCCAC2E4358410000000021652E41666666462843584100000000FF642E4166666606214358419A999999D7642E41666666C60A43584100000000B3642E4133333313044358413333333399642E4100000080D84258410000000045642E4166666646D14258416666666638642E4100000020BF42584133333333F6632E4166666666B94258419A999999AF632E41000000C0B04258413333333391632E4166666646A9425841666666662C632E41666666269E425841CDCCCCCCD2622E4166666646854258416666666696622E419A9999D97E4258413333333318622E416666668677425841333333333B622E419A9999F96A4258410000000061622E41333333F34C425841333333335F622E419A999979314258416666666622622E419A9999990942584166666666E5612E41CDCCCCACFA415841CDCCCCCCEE612E41CDCCCCACF0415841CDCCCCCC0B622E4166666626E4415841333333331F622E41CDCCCCACBE41584166666666C8622E41000000C0B5415841000000008B632E4100000040A241584133333333E0632E419A9999B9A24158416666666637652E41000000A096415841CDCCCCCCDB652E41CDCCCCEC9A415841CDCCCCCCB8662E41333333338E4158413333333389672E419A9999F979415841CDCCCCCCB0672E413333337377415841CDCCCCCCDC682E41000000E0794158419A99999918692E41CDCCCC4C774158419A999999A4692E41666666A67941584133333333316A2E410000000086415841000000003F6B2E41333333F386415841000000009F6B2E41000000C08A415841333333337F6C2E419A9999198D415841000000008E6D2E41666666469E4158419A999999E86D2E41CDCCCC2CA841584133333333426E2E41333333D3A1415841CDCCCCCCE26E2E41CDCCCCAC91415841CDCCCCCC136F2E41666666A682415841CDCCCCCC086F2E41CDCCCCEC7441584100000000A36E2E41CDCCCC4C59415841333333333E6E2E41CDCCCCEC4C4158419A999999156E2E419A9999B94141584133333333ED6D2E41666666863B41584166666666C46D2E41333333132F41584133333333616D2E41333333731C41584166666666606D2E419A9999391141584100000000AF6D2E41666666A6FF405841CDCCCCCC356E2E41CDCCCC2CDF40584133333333646E2E4133333313CC40584100000000B16E2E41CDCCCCACC940584133333333266F2E4133333333C240584100000000876F2E419A999919BB4058416666666648702E4166666606AA4058419A999999FA702E419A999919924058419A9999997C712E410000004075405841CDCCCCCCB7712E41CDCCCC6C6C4058419A99999999712E419A9999F969405841CDCCCCCC0C712E41666666E65940584166666666276F2E41000000E01D4058419A999999786F2E41CDCCCC6CFC3F5841CDCCCCCC946F2E41CDCCCC6CE33F58419A9999997F6F2E4133333373CF3F58410000000018702E41000000A0AB3F5841333333332D702E41333333739F3F5841CDCCCCCC16702E4133333313903F5841333333332A702E41666666C67A3F5841CDCCCCCC41702E41333333F36C3F5841CDCCCCCC6A702E4133333313623F5841CDCCCCCC8A702E41CDCCCCEC533F58416666666660702E4166666606463F5841CDCCCCCC04702E41CDCCCC0C353F58419A999999EB6F2E41333333D32D3F584100000000CA6F2E41666666462E3F584100000000B06F2E41333333532B3F58419A9999999E6F2E419A999919243F58419A999999786F2E41CDCCCCAC1B3F5841666666666F6F2E41000000E0153F5841CDCCCCCC746F2E41CDCCCCCC0A3F584100000000616F2E4100000060F23E584100000000756F2E41333333B3E03E5841CDCCCCCC5E6F2E4166666646C03E5841CDCCCCCC216F2E419A999919B03E584133333333F96E2E41666666A6A83E584100000000DA6E2E41333333F3953E584133333333896E2E41CDCCCC4C883E58419A999999576E2E4100000060703E58419A999999606E2E41000000A0623E5841CDCCCCCC9A6E2E419A9999D94A3E58419A999999E06E2E4166666606473E584133333333C66F2E4166666606473E5841CDCCCCCC15702E41333333F3413E58413333333384702E419A9999592B3E5841333333330D712E4100000000023E584133333333F8702E4166666606F33D584133333333B1702E4100000020E43D58410000000092702E41CDCCCC2CD13D584133333333B0702E41CDCCCC2CB83D584133333333C1702E41CDCCCCEC8E3D58419A999999D0702E419A9999D9833D58419A99999996702E41666666E67C3D5841CDCCCCCCF76F2E41CDCCCC2C763D5841666666667F6F2E4133333313703D584166666666106F2E41333333B35E3D584166666666C16E2E41CDCCCCCC503D5841CDCCCCCC166E2E4100000040433D5841CDCCCCCCB16D2E41000000A0353D58419A9999997E6D2E41333333F3223D5841333333331A6D2E41333333531A3D584100000000E86C2E41000000E0173D58419A999999BF6C2E41CDCCCC6C113D584166666666B46C2E41333333F3FF3C584166666666C66C2E41333333F3E13C5841000000009E6C2E41000000C0DB3C584100000000EB6B2E419A9999B9CB3C58419A999999A46B2E41CDCCCC4CC43C5841333333330E6B2E419A9999F9BC3C5841CDCCCCCC586A2E4133333373A63C584100000000316A2E419A9999F9A83C58419A99999968692E41CDCCCC2CBD3C5841CDCCCCCC18692E4166666686BE3C58416666666688672E4133333333B23C58419A999999AC662E4133333333B13C58413333333329662E41CDCCCCACAE3C5841CDCCCCCCF9652E419A999979B03C584133333333BE652E41CDCCCCECB43C58413333333345652E4133333353B53C58416666666660642E4100000020B43C584133333333F5632E419A9999D9B43C5841CDCCCCCC50632E41000000C0BB3C58419A999999F5622E4166666686BD3C5841000000005A622E41CDCCCC6CBC3C58413333333342612E41666666E6BD3C584133333333A5602E41666666A6C33C58413333333358602E4166666646C93C584166666666E25F2E41CDCCCC8CD03C584166666666015F2E4100000000E43C584133333333B85E2E419A999919E63C584133333333F05D2E4133333353E23C584133333333CD5C2E4166666626D13C5841000000006A5C2E41CDCCCC2CCE3C58419A999999F95B2E4100000000CE3C584133333333A25B2E419A9999F9CE3C584133333333555B2E4166666626D33C58419A999999E25A2E41CDCCCCECDD3C5841333333336A5A2E41CDCCCC4CD53C58416666666666592E4133333393D53C584100000000FD572E4100000040BA3C58416666666648572E4133333373B03C584166666666D0562E419A999919AE3C584133333333F5552E4133333313B73C5841CDCCCCCCFB542E41333333D3BA3C584133333333A5532E4166666686C83C5841333333332F532E4133333353CA3C58413333333311532E419A999919C93C58413333333387522E4100000000C83C58419A99999917522E41000000A0CA3C5841000000001E512E4166666626CD3C58410000000011502E41CDCCCCACD83C584133333333FD4F2E41CDCCCC2CDB3C584133333333404F2E4100000060E53C584133333333EF4E2E4100000060EA3C58419A999999B34E2E4166666646F03C5841333333338D4E2E41333333D3F03C5841CDCCCCCC604E2E419A999919EB3C584166666666824C2E41CDCCCCECC23C5841CDCCCCCCD74B2E4100000060B63C5841333333337D4B2E419A999979AC3C584133333333C44A2E41666666069B3C58419A999999A34A2E41333333D39C3C5841666666661B4A2E41000000E0AB3C58416666666668492E4133333313B83C58416666666639492E419A999979BA3C584100000000D5482E4133333373BD3C5841333333335E482E41333333D3D03C584100000000E1472E419A9999D9CB3C58413333333390472E41666666C6D13C58416666666627472E4100000040D43C58413333333366462E419A999959D63C58419A99999934462E41CDCCCC2CDF3C584100000000BB452E41333333F3DC3C5841CDCCCCCCE5442E4133333313E03C5841333333337F442E419A9999F9DD3C58419A99999932442E41666666A6D93C584100000000C4432E4166666626D13C5841000000004D432E4100000040D13C58410000000037432E4133333373CF3C584166666666BC422E41666666A6CD3C5841666666667A422E419A9999B9D03C58410000000031422E419A999979CA3C5841CDCCCCCCEF412E4166666606CA3C5841CDCCCCCCB8412E4100000080BC3C58413333333379412E41CDCCCCCCB63C5841000000006E412E4100000000B43C5841CDCCCCCC1D412E419A999979AB3C584100000000EE402E4100000080A03C5841CDCCCCCCD5402E41333333B39D3C5841CDCCCCCC78402E419A999939973C5841000000004E402E4133333353913C5841CDCCCCCC1F402E419A9999F9863C584133333333F63F2E41CDCCCCAC823C5841000000009E3F2E41000000607E3C5841CDCCCCCC803F2E419A9999197B3C58419A999999623F2E419A999959703C584133333333093F2E419A9999B95E3C584100000000C03E2E4166666606583C58419A9999998B3E2E4133333333513C58419A999999BF3D2E4100000080483C58419A999999163D2E419A9999193A3C5841CDCCCCCCF13C2E4100000080383C5841CDCCCCCC773C2E41000000E03B3C584100000000503C2E41CDCCCC4C3B3C58419A999999103C2E4133333393363C5841CDCCCCCCD63B2E41666666C6343C5841CDCCCCCC8E3B2E41666666462F3C5841CDCCCCCC6B3B2E419A999959313C584100000000583B2E41666666E62D3C5841333333334A3B2E41000000A0233C584133333333173B2E41333333131A3C584166666666623A2E4133333373163C584133333333D2392E4133333373113C58416666666685392E419A9999B90B3C58419A9999997D392E41CDCCCC4CFE3B58419A99999987392E419A9999F9F93B584100000000DB382E41CDCCCC0C0B3C584100000000A2382E41333333D3113C58410000000045382E41666666461A3C5841CDCCCCCCE4372E41CDCCCC8C243C58416666666650372E41000000002D3C58419A9999997D362E41666666E6483C58419A999999DE352E41CDCCCC8C553C584100000000B3352E41666666865F3C5841CDCCCCCC63352E4133333393693C58419A999999E4342E41333333B3693C58419A999999B4342E419A9999596C3C58416666666629342E4133333333933C584100000000A9332E4133333353A73C58413333333364332E4100000020BA3C58416666666615332E41333333F3C73C5841000000008B322E4100000020D63C5841CDCCCCCC11322E4100000040E93C584166666666FE312E419A9999F9EF3C58419A999999D6312E4100000080F23C584166666666B9312E41000000C0F93C58413333333380312E4100000060FF3C58419A99999951312E419A999959FF3C58413333333344312E4100000020FD3C5841CDCCCCCCBE302E4166666686F13C5841CDCCCCCC58302E4166666646EC3C58419A9999991C302E419A9999D9F03C5841333333338C2F2E4166666606F83C5841000000002B2F2E419A999959FB3C58419A999999C42E2E41000000A0FC3C584133333333452E2E419A9999B9FA3C584100000000D22D2E4166666626F63C58419A9999993D2D2E419A999919E73C584133333333EB2C2E4133333333E03C5841CDCCCCCC1F2C2E41666666E6D03C58419A999999CA2B2E41666666E6CC3C5841CDCCCCCC702B2E4133333373CE3C5841CDCCCCCCF82A2E41333333B3CD3C58419A999999A82A2E41CDCCCCACC93C584166666666582A2E419A999939C43C5841666666660A2A2E4166666666BC3C584133333333C1292E4166666686B23C58410000000087292E41333333D3A43C58419A9999994C292E41000000E0983C5841CDCCCCCC03292E41666666A6913C58419A999999DD282E41CDCCCC0C883C58419A9999998A282E419A9999797E3C5841CDCCCCCC55282E419A9999797C3C5841CDCCCCCCBC272E41CDCCCCEC783C58410000000008272E41000000606C3C584133333333A9262E4100000000603C58410000000049262E419A999999583C58419A999999DD252E41666666A64E3C58419A99999949252E41CDCCCC0C463C58410000000006252E41666666C6433C5841333333338F242E41000000E0393C5841CDCCCCCC0B242E4166666686243C584100000000E3232E419A999919183C58419A9999991E232E419A999979FF3B5841CDCCCCCC91222E41666666C6F53B58419A99999952222E4133333353EF3B58416666666625222E41CDCCCC0C013C5841CDCCCCCC09222E41333333F3013C584100000000BA212E41666666A6133C5841000000008F212E4133333393193C58410000000036212E41CDCCCCEC2E3C58416666666608212E41CDCCCC2C363C584133333333EE202E41000000203D3C58419A999999BF202E41CDCCCC8C423C584100000000B8202E41333333F3463C584133333333BD202E41333333D3513C5841CDCCCCCCCC202E41333333935D3C58419A999999E5202E419A9999D9683C58416666666601212E4100000080703C5841000000000D212E41333333337E3C58410000000038212E41CDCCCC4C943C58410000000031212E41333333739D3C58413333333303212E41666666E6A73C584166666666D1202E419A999939B63C584166666666A9202E41CDCCCC2CBD3C5841CDCCCCCC86202E419A999999CB3C5841000000005C202E4100000000D93C58413333333301202E41CDCCCC2CE73C5841CDCCCCCCE81F2E41333333D3ED3C5841CDCCCCCCD01F2E4100000020033D584166666666AE1F2E419A9999390F3D584100000000B21F2E41CDCCCCCC163D584133333333A31F2E41000000A0263D58419A9999997C1F2E41CDCCCCEC2D3D584166666666691F2E419A999959363D58419A9999996D1F2E41000000C03D3D584166666666551F2E4100000040463D58419A9999998A1F2E41666666E6623D584133333333821F2E41CDCCCC6C693D58419A9999995C1F2E4166666626703D584166666666EB1E2E41CDCCCCCC763D584166666666D01D2E41000000E0853D5841CDCCCCCC2F1D2E4100000020903D584133333333C41C2E4133333333953D584133333333381C2E41666666E6A03D5841CDCCCCCCE41B2E419A9999B9A53D58419A999999A31B2E41CDCCCCECAC3D584133333333331B2E41666666C6B43D58419A999999C41A2E4133333353B83D584133333333421A2E41333333D3BA3D584133333333DE192E4166666626C03D58419A9999991C192E4100000020D33D584133333333FE182E41666666A6D93D58419A999999AE182E41000000E0DF3D58410000000046182E419A999919E43D584100000000A1162E4166666606F23D5841CDCCCCCC10162E41666666C6F93D5841CDCCCCCCC5152E419A999999F93D584166666666C2142E4133333333DF3D58413333333343142E4100000080E03D584166666666D5132E41000000C0DF3D58419A99999949132E41666666C6E03D5841666666665F122E419A9999F9EA3D5841CDCCCCCC62112E41666666A6EF3D58419A999999DB102E4100000020EB3D5841CDCCCCCC85102E4100000040E43D5841CDCCCCCCF50F2E41666666E6E43D58419A999999C60F2E4100000020E63D584133333333650F2E4166666686E63D5841CDCCCCCC270E2E419A999939E43D5841CDCCCCCCBC0D2E419A9999B9E63D58419A999999D50C2E41000000E0F33D5841000000004F0C2E4166666626FA3D584166666666E60B2E4100000080FD3D584100000000850B2E41666666A6FF3D584133333333F60A2E4166666606003E584133333333360A2E41CDCCCCAC013E5841000000008A092E41666666E6043E58410000000044092E419A9999F9043E58419A999999D5082E419A999959FC3D58416666666658082E4133333353FC3D58419A99999921082E4100000000FF3D584100000000E5072E4100000060F23D5841000000009E072E41333333F3E03D5841666666660C072E419A999979BF3D5841666666668D062E41CDCCCCCCC73D5841CDCCCCCCAB052E41666666E6D23D584100000000D8042E419A999979D73D58410000000058042E4166666626DB3D58419A999999BF032E419A999979DC3D58410000000043032E4100000040DF3D58419A99999980022E419A999939E13D584133333333ED012E4133333313E13D58413333333346012E419A999979E43D58413333333389002E4166666666F03D5841CDCCCCCC39002E419A999919F83D584133333333EAFF2D4166666646FC3D5841CDCCCCCC72FF2D41CDCCCC4C043E5841333333333CFF2D4166666606073E584100000000A5FE2D4166666626083E58419A9999995FFE2D419A9999B90F3E584100000000FDFD2D41CDCCCC8C223E584133333333FBFD2D41CDCCCC8C273E58416666666660FE2D41CDCCCC6C3A3E584166666666EEFE2D4100000080593E58410000000075FF2D4133333333803E584100000000B5FF2D4133333353943E584166666666CFFF2D41CDCCCCECA23E584100000000EBFF2D4100000040AC3E584166666666C4FF2D41CDCCCCACB03E58416666666683FF2D419A9999F9BF3E5841666666664CFF2D4100000020E13E58419A99999932FF2D41000000C0093F58419A9999990AFF2D41CDCCCCEC1C3F5841000000008FFE2D41666666462C3F58413333333358FE2D419A9999192E3F58419A999999F9FD2D4133333353343F58419A9999992BFD2D41000000E0473F5841CDCCCCCCC0FC2D41333333135A3F584100000000A4FC2D419A9999996B3F584166666666C3FC2D41CDCCCC8C7F3F58416666666648FD2D419A999999AC3F58419A999999DEFD2D4166666626CE3F58410000000094FD2D4166666686D43F58419A9999993DFD2D41666666E6E53F5841333333332DFD2D4133333353F13F5841000000001BFD2D41CDCCCC8C0B40584100000000F4FC2D419A9999591940584166666666CBFC2D419A9999992E405841666666661DFD2D41000000804C405841CDCCCCCC1FFD2D41333333336E4058413333333384FD2D419A99999975405841333333331BFE2D41666666A684405841333333331AFE2D41666666E6944058419A9999992FFE2D419A9999D9A84058419A9999994FFE2D41CDCCCC2CBF4058416666666684FE2D4100000000CF40584133333333B9FE2D41CDCCCC8CDB405841CDCCCCCC4BFF2D419A999979E94058419A999999C4FF2D419A999919F64058419A9999990B002E4100000080074158419A99999928002E4133333333154158419A99999916002E41333333F33141584100000000A2FF2D4166666686614158419A99999951FF2D41333333137841584133333333A9FE2D41000000808D415841CDCCCCCC32FE2D419A999999A14158419A999999F8FD2D41666666A6BA4158413333333327FD2D4133333393DC4158416666666660FC2D4166666686EB415841333333335EFB2D416666668603425841333333337FFB2D41CDCCCCEC4A425841CDCCCCCC58FB2D4133333373614258410000000008FB2D416666660673425841333333339BFA2D41000000A080425841333333336AFA2D41666666668E42584133333333C0F92D4166666686B542584133333333B4F92D419A9999B9B6425841CDCCCCCC36F92D41CDCCCCECCB4258419A99999916F92D419A999919D742584133333333F0F82D41CDCCCC2CED4258419A999999E6F82D41CDCCCCECFD42584133333333EAF82D41000000201D435841CDCCCCCCADF82D41000000A0284358413333333327F82D41000000A0394358416666666686F72D416666660652435841000000005DF62D41666666C690435841000000005DF62D41666666C690435841	01010000206A080000E2B583A9A4302E41666666C6AB415841	040060000	Z	Allos	0400600	04006	04	93	117
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	01010000206A08000058E19821BC102E41000000B0501E5841	040070000	Z	Angles	0400700	04007	04	93	10
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	01010000206A080000AD48BC4A55552E4166666686D6205841	040080000	Z	Annot	0400800	04008	04	93	30
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	01010000206A08000056E7B0F064812D410000003011305841	040090000	Z	Archail	0400900	04009	04	93	13
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	01010000206A08000029091F3035EB2B4166666686C41A5841	040120000	Z	Aubenas-les-Alpes	0401200	04012	04	93	8
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	01010000206A080000C741869613982C4166666616A82F5841	040130000	Z	Aubignosc	0401300	04013	04	93	15
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	01010000206A0800004635CB29BE072D4100000060C63D5841	040160000	Z	Authon	0401600	04016	04	93	40
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	01010000206A080000F21823E1D86E2D41666666A683445841	040170000	Z	Auzet	0401700	04017	04	93	35
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	01010000206A0800007C50FEE5E7DA2B41666666F641245841	040180000	Z	Banon	0401800	04018	04	93	40
01060000206A08000001000000010300000001000000E9020000333333334C282E41333333B3644E5841333333336B282E4100000020694E5841CDCCCCCCA0282E419A9999596E4E58419A999999ED282E4133333393714E5841CDCCCCCC1D292E41666666E6724E58410000000027292E4166666626734E5841CDCCCCCC69292E41333333B3744E584166666666BD292E419A9999D9764E584166666666FF292E41CDCCCCAC764E5841666666662C2A2E41CDCCCC2C754E58419A999999312A2E419A9999B9744E58419A999999552A2E41000000E0714E5841CDCCCCCC662A2E41CDCCCC0C734E584133333333922A2E41CDCCCCAC764E584133333333F02A2E419A9999597D4E584100000000172B2E41CDCCCC2C7E4E584133333333642B2E4166666606804E5841CDCCCCCCA72B2E41CDCCCC8C824E58419A999999EA2B2E41666666A6824E5841666666660D2C2E41CDCCCC8C824E584100000000342C2E4166666666804E584100000000AE2C2E419A9999D9824E5841CDCCCCCC112D2E4166666686844E5841333333333A2D2E41CDCCCCEC844E5841CDCCCCCCD82D2E4166666686864E5841000000009F2E2E41CDCCCCAC884E584166666666572F2E41333333538A4E5841CDCCCCCC2E302E41CDCCCCAC8B4E58413333333310312E41000000E08C4E5841CDCCCCCC1E312E419A9999F98C4E58410000000020312E41333333D3914E58410000000021312E41000000C0954E58410000000029312E419A9999F9A14E5841CDCCCCCC30312E4100000080AB4E58416666666631312E4166666606AF4E58410000000032312E41000000E0B24E5841000000003A312E41CDCCCCECBD4E5841666666663F312E41333333F3C54E58419A99999943312E419A9999F9CE4E58410000000046312E419A999979D14E58419A99999946312E419A999999D34E58416666666646312E41666666A6D54E5841CDCCCCCC45312E419A9999B9D74E58413333333341312E41000000E0DA4E58419A9999993E312E41CDCCCC0CDD4E5841333333333D312E41CDCCCC2CDE4E5841000000003A312E4166666686E14E58419A99999933312E41CDCCCC6CE84E58416666666632312E41CDCCCCECEA4E58419A99999931312E419A999959ED4E5841666666662E312E4133333313F14E5841CDCCCCCC2D312E419A999959F34E58419A9999992E312E41000000A0F54E5841333333332E312E4133333333F84E58419A9999992E312E41666666E6FA4E58419A99999930312E41333333B3FD4E58413333333331312E4100000020014F5841333333332C312E41CDCCCCAC094F58413333333327312E41000000E00F4F58413333333324312E41CDCCCC0C124F58413333333321312E4100000020154F58419A9999991E312E41000000E0174F58419A9999991C312E419A9999791A4F58416666666619312E41666666661E4F58416666666617312E41CDCCCCCC214F58413333333315312E41CDCCCCAC244F58416666666613312E41000000A0284F58416666666614312E41333333932B4F58419A9999990E312E41000000E02F4F5841000000000A312E41CDCCCCEC324F58410000000004312E41000000E0344F584100000000FE302E41CDCCCC2C374F58419A999999F9302E41CDCCCCCC394F584133333333F4302E41666666063D4F58419A999999F1302E41666666E63F4F584166666666EF302E419A9999D9434F58419A999999EA302E41CDCCCC0C474F584100000000E6302E41CDCCCC6C4A4F58419A999999E2302E419A9999994D4F5841CDCCCCCCE0302E419A999939514F5841CDCCCCCCDF302E419A999979544F584133333333DF302E419A999959584F58419A999999E4302E41000000405C4F584166666666EC302E419A999999604F584166666666FE302E419A999979674F584133333333FF302E4133333313684F5841CDCCCCCC04312E41000000E06B4F58413333333308312E41333333136E4F58419A9999990E312E4133333313724F5841CDCCCCCC1D312E419A9999D97A4F5841333333331E312E41333333137B4F58413333333320312E41CDCCCC2C7C4F58413333333321312E41000000007D4F5841666666661E312E4166666686814F58419A9999991B312E4133333393834F58419A99999917312E419A9999D9844F5841CDCCCCCC10312E4133333353864F5841000000000D312E4133333393874F5841CDCCCCCC0B312E41CDCCCCCC884F58419A9999990B312E419A9999B98A4F5841333333330D312E41000000A08C4F5841CDCCCCCC0E312E41666666268E4F5841CDCCCCCC11312E4133333373904F5841CDCCCCCC14312E41CDCCCC8C924F58410000000018312E41333333B3944F5841CDCCCCCC19312E4133333393974F5841333333331B312E41333333739A4F58419A9999991C312E41CDCCCC6C9D4F58413333333320312E419A999919A04F58416666666626312E41CDCCCCCCA24F5841000000002D312E4133333353A54F58413333333334312E419A999999A84F5841CDCCCCCC3B312E419A9999F9AA4F58410000000042312E4133333333AD4F58419A99999945312E41CDCCCC6CAF4F58416666666644312E419A999919B14F58413333333344312E4166666626B34F5841CDCCCCCC4A312E41CDCCCCACB44F5841333333334B312E41666666C6B44F58416666666665312E41000000E0B94F58413333333379312E419A999979C14F584166666666B2312E4100000000D94F58419A999999CB312E419A999939DF4F584100000000CD312E4133333393DF4F58419A999999CF312E41000000C0E04F584166666666D0312E419A999999E14F584133333333D3312E419A9999D9E24F584166666666D6312E4133333313E44F584166666666DA312E4133333333E54F584100000000E1312E41666666C6E64F5841CDCCCCCCE5312E41CDCCCC0CE84F584133333333EA312E41CDCCCC2CE94F58419A999999EF312E4166666646EA4F584166666666F4312E41CDCCCCACEB4F584166666666FA312E41CDCCCC4CEE4F584100000000FB312E4166666606F04F584166666666FB312E419A999999F14F58419A999999FC312E41CDCCCC0CF34F5841CDCCCCCCFD312E419A999959F44F58413333333301322E41CDCCCCECF54F58416666666601322E41000000C0F64F58416666666602322E41333333D3F84F5841CDCCCCCC00322E41333333D3FB4F5841CDCCCCCC00322E41000000E0FF4F58413333333300322E41000000C00150584166666666FD312E41000000000450584100000000FC312E41000000A00550584166666666FB312E41666666660650584133333333F7312E41CDCCCC6C085058419A999999F3312E41000000400A50584166666666F0312E41666666660C50584133333333ED312E41333333D30E505841CDCCCCCCEC312E41CDCCCCEC1150584166666666ED312E41000000001550584133333333EE312E419A9999B91850584133333333ED312E41CDCCCC6C1C50584133333333EB312E419A999919205058419A999999EA312E41666666E62250584166666666EC312E419A99991926505841CDCCCCCCEB312E419A9999D92750584166666666FB312E41666666862A50584166666666FD312E41000000602B505841000000000B322E419A9999B92E505841CDCCCCCC12322E41000000802F505841666666661A322E4133333373305058419A99999920322E41000000C0315058419A99999925322E4100000020335058413333333328322E413333337334505841666666662C322E41666666E635505841CDCCCCCC31322E41CDCCCCAC375058410000000039322E4133333313395058413333333341322E419A9999793A5058416666666645322E41333333133C5058413333333347322E41CDCCCCEC3D5058419A99999949322E41333333533F505841CDCCCCCC4F322E410000002041505841333333335A322E4100000080435058410000000065322E41000000C045505841CDCCCCCC6E322E4133333353485058419A99999974322E41333333D34A5058419A99999974322E41CDCCCC4C4C5058416666666673322E41CDCCCC8C4D505841CDCCCCCC74322E41666666C64E5058419A99999976322E419A999919505058419A9999997B322E41000000C0515058413333333384322E4166666686525058410000000089322E41CDCCCC8C53505841666666668C322E41333333B3545058416666666692322E4100000080565058413333333398322E41333333335850584166666666A0322E41000000A0595058419A999999AC322E419A9999395B50584133333333B6322E41CDCCCCAC5C50584100000000C1322E41666666065E505841CDCCCCCCC6322E419A9999196050584166666666CC322E4166666606625058419A999999D3322E41000000606350584166666666DF322E419A9999D964505841CDCCCCCCEA322E4133333333665058419A999999F4322E410000000068505841CDCCCCCCFF322E41666666E669505841666666660A332E41333333936B5058419A99999916332E41666666866D5058413333333324332E41333333536F505841666666662F332E41CDCCCC2C71505841000000003D332E413333335373505841333333334A332E419A99997974505841CDCCCCCC53332E41666666A675505841000000005A332E419A999979775058410000000018342E419A999959855058419A99999922342E4100000040875058419A9999992C342E41333333F3885058416666666635342E41000000008B5058419A9999993F342E41000000608D5058410000000044342E419A9999598E5058413333333348342E41CDCCCC6C8F505841666666664E342E41CDCCCC8C90505841CDCCCCCC56342E41333333B3915058413333333360342E4166666626A150584166666666D2342E4133333353B150584166666666E2342E41333333B3B250584133333333EF342E4166666626B450584100000000FD342E41000000C0B5505841666666660C352E4133333313B7505841333333331D352E4166666666B8505841333333332E352E4166666686BA505841CDCCCCCC30352E41333333D3BA505841666666664C352E4133333313BE505841000000004E352E4166666646BE505841666666665B352E419A999979BF505841CDCCCCCC6C352E41CDCCCCCCC05058410000000081352E4166666666C25058419A99999995352E4133333353C45058416666666696352E41CDCCCC6CC450584166666666AA352E41CDCCCC4CC6505841CDCCCCCCBC352E41333333D3C750584100000000C4352E41666666C6C850584100000000D7352E41CDCCCCECCA50584100000000E7352E41333333B3CC505841CDCCCCCCF5352E4133333333CE5058419A99999903362E4166666686D05058413333333314362E4166666626D3505841CDCCCCCC18362E41333333F3D35058416666666627362E4100000060D6505841666666663F362E419A9999D9D95058416666666651362E41000000C0DC505841666666666E362E4166666686E15058413333333378362E4166666646E35058413333333379362E419A999979E35058416666666684362E4133333313E55058419A99999990362E4133333353E75058419A999999A0362E41CDCCCCECE9505841CDCCCCCCB4362E4100000020ED50584133333333BD362E4133333333EE50584166666666BF362E41666666E6EE50584100000000CB362E4166666686F050584133333333D8362E419A999959F250584133333333E6362E41666666C6F45058419A999999F6362E419A9999F9F65058410000000005372E4166666686F85058419A99999916372E419A999939FA505841CDCCCCCC26372E41000000E0FA505841333333333A372E41333333D3F9505841666666664E372E4133333393F9505841333333335F372E41666666E6FA5058416666666673372E41000000E0FB5058419A99999983372E419A9999B9FC5058419A99999993372E41CDCCCCACFD505841CDCCCCCCA7372E41CDCCCC6CFE505841CDCCCCCCB7372E419A999939FF50584166666666CA372E41CDCCCC6C0051584133333333DC372E41000000C0015158419A999999ED372E41333333D302515841CDCCCCCC00382E41CDCCCC4C03515841333333330D382E41000000C004515841000000001D382E4166666666065158419A9999993C382E41333333F309515841000000007A382E41333333F310515841CDCCCCCCCC382E410000002016515841CDCCCCCC43392E41CDCCCCEC1E5158410000000088392E413333333331515841CDCCCCCCF6392E41CDCCCC2C3D515841CDCCCCCC513A2E41333333335A51584166666666863A2E419A9999397151584166666666783A2E41000000208051584133333333153B2E41333333D3825158419A999999223B2E4166666626825158419A999999323B2E419A9999D98051584133333333453B2E41333333937F515841CDCCCCCC563B2E419A9999597E51584100000000663B2E41CDCCCC6C7D51584166666666933B2E41666666067D51584133333333C93B2E41CDCCCCAC7E515841CDCCCCCCDC3B2E419A9999797F5158419A999999033C2E41000000808051584100000000623C2E419A9999198151584166666666883C2E419A9999B97E51584100000000A53C2E419A9999B97A51584133333333BB3C2E4166666686745158419A999999FE3C2E41666666666051584166666666253D2E41CDCCCCAC4F5158419A9999995B3D2E41000000C042515841000000002A3D2E41333333D33851584133333333153D2E41666666262C5158419A9999991C3D2E4166666666F550584133333333113D2E4133333313E25058419A999999D13C2E4166666626CE50584166666666DB3C2E4166666666CA5058419A999999703D2E41000000C0C250584166666666983D2E4133333333C050584166666666243E2E4100000060BB50584100000000913E2E419A9999D9BB50584100000000B23F2E4133333393C250584133333333A53F2E4133333373A3505841CDCCCCCCA23F2E41CDCCCCCCA1505841666666669A3F2E41CDCCCC6CA0505841CDCCCCCC903F2E41333333539F5058419A999999833F2E41000000209E505841333333337D3F2E41CDCCCCCC9C50584133333333823F2E41000000C09B5058419A9999999B3F2E419A9999999A5058419A999999B33F2E419A999939985058419A999999C03F2E41666666469750584166666666CF3F2E41666666069750584166666666F13F2E419A99991997505841CDCCCCCCFF3F2E41000000C097505841333333330B402E419A999959985058419A9999992A402E4133333333985058413333333339402E419A9999D997505841000000005A402E410000004097505841CDCCCCCC8E402E41666666669650584100000000B8402E41000000809550584166666666D2402E41333333F39450584100000000F8402E41CDCCCCAC94505841333333333D412E419A9999D9935058410000000050412E4133333353935058419A99999970412E413333331392505841CDCCCCCC80412E41666666E691505841CDCCCCCCA0412E41666666C6925058419A999999C0412E41666666669250584100000000DE412E41CDCCCCEC925058410000000014422E419A9999399B505841CDCCCCCC67422E41333333338B505841333333335D422E419A999979845058419A99999995422E41CDCCCCEC755058419A999999C6422E419A9999595A5058419A99999948432E41000000602650584166666666FA432E41666666E6FA4F58419A9999993B442E41CDCCCC4CEC4F5841CDCCCCCC11452E419A999959D34F58413333333347452E41000000C0C74F5841000000004B452E4100000080C44F58419A9999994B452E419A999999C24F58413333333349452E41333333B3C04F58410000000047452E41333333D3BE4F5841CDCCCCCC46452E41CDCCCC4CBD4F5841CDCCCCCC44452E41CDCCCC2CBC4F58416666666643452E41CDCCCC2CBB4F58410000000043452E4133333393B94F5841CDCCCCCC38452E419A9999B9AD4F58416666666630452E4166666606A24F58410000000044452E419A9999D99B4F58416666666681452E41666666A6894F584133333333AA452E41666666667F4F584100000000B3452E41CDCCCC4C7D4F584100000000D2452E419A9999F9754F584166666666EC452E419A9999B9704F5841333333330B462E41333333B36B4F5841CDCCCCCC62462E41000000405C4F5841CDCCCCCC64462E41000000E05B4F5841CDCCCCCC82462E41000000C0564F5841000000009E462E4166666646524F584166666666B9462E41000000804D4F58419A999999D0462E419A9999B9494F584133333333F6462E4100000080434F58419A99999916472E41333333733E4F5841CDCCCCCC35472E4166666626394F5841333333335A472E41CDCCCC2C324F5841CDCCCCCC7A472E41000000402C4F58416666666696472E4166666646274F5841CDCCCCCCAE472E4166666686234F584133333333C7472E41333333531F4F584100000000D2472E41CDCCCC6C1D4F584166666666E4472E41CDCCCC4C174F5841000000004E472E41CDCCCC8C0E4F58419A99999937472E41000000800C4F58419A999999E1462E4100000020044F5841CDCCCCCCFC462E4100000060004F58410000000003472E419A9999B9FA4E58419A99999913472E4100000020F94E58413333333328472E41CDCCCC8CF74E58416666666649472E419A9999F9F34E58416666666666472E41CDCCCC8CF04E584166666666AB472E41CDCCCC4CE54E584166666666C5472E4100000020E14E58419A999999F0472E4133333333DA4E5841CDCCCCCC4C482E4100000080CB4E58419A9999995F482E4166666686C84E584166666666BF482E4166666686B94E58413333333328492E419A999959A94E58419A99999990492E41CDCCCC8C984E58419A999999F8492E419A999979884E584133333333244A2E4166666686814E5841333333336B4A2E419A999959764E5841000000005F4A2E41333333B3754E584133333333534A2E419A9999F9704E5841000000003A4A2E41000000006B4E5841CDCCCCCC1A4A2E41000000E0644E584166666666FF492E41666666465D4E58419A999999CF492E41000000004D4E584133333333BC492E4166666666474E584100000000BC492E41000000C0464E58419A999999BC492E419A999959464E5841CDCCCCCC32482E419A9999F9FB4D58419A9999993A472E41333333D3CB4D58416666666627472E4166666666C44D5841666666660B472E41666666C6A94D58410000000034472E4166666646A24D58410000000079472E419A999999954D584100000000AE472E419A9999B98A4D584100000000E8472E41666666A6724D58413333333349482E41CDCCCCEC5E4D5841CDCCCCCC3F482E41CDCCCC8C484D5841CDCCCCCC30482E419A9999F9414D58419A99999918482E41000000C02B4D58413333333324482E41000000C01C4D5841000000002E482E41CDCCCCCC154D5841000000003C482E419A9999990E4D58413333333344482E41CDCCCC2C0B4D58413333333351482E419A999999074D5841000000006C482E4100000060024D58416666666691482E419A999959FB4C58419A999999A6482E4133333353F84C58419A999999B0482E4166666626F74C584133333333BE482E41CDCCCCCCF44C584133333333C5482E4100000000F34C584100000000D2482E41000000C0EE4C58419A999999DC482E41000000C0E94C58419A999999E5482E419A999999E34C58419A999999E1482E419A999979E24C58419A999999E0482E4133333333E14C58419A999999EA482E41666666C6DB4C5841CDCCCCCCEB482E41666666C6D74C584100000000EA482E419A999939D54C584133333333E4482E41333333B3D04C584166666666DF482E41000000A0CC4C5841CDCCCCCCD6482E41666666A6C74C58419A999999D1482E41333333B3C34C584166666666D0482E4166666666C14C584133333333D2482E419A999919BF4C584133333333E7482E419A9999F9B44C584100000000F0482E4166666646AF4C584166666666EF482E4166666606AE4C58419A999999EC482E4166666646AD4C584100000000E1482E4166666686AB4C584133333333DE482E41666666A6AA4C58419A999999DE482E41666666C6A94C584133333333E3482E4100000060A84C584100000000E6482E41333333D3A64C584133333333E5482E4133333333A54C584133333333E2482E41CDCCCCECA34C58419A999999E7482E41000000808F4C584166666666C1482E4133333393854C58419A99999987482E4133333373854C5841CDCCCCCC83482E41000000C0844C5841CDCCCCCC7E482E419A999959844C5841333333337A482E4166666626844C58416666666674482E4166666626844C58419A9999994B482E4133333393854C58413333333344482E419A999999854C5841000000003B482E41CDCCCC6C854C58419A9999992F482E419A9999B9844C58413333333329482E4100000000844C5841666666661A482E41CDCCCCAC824C5841666666660F482E419A999959814C5841CDCCCCCC05482E41333333D37F4C584166666666FF472E41000000807E4C584133333333FA472E41000000207D4C584133333333F2472E419A999919794C584166666666EE472E419A999959754C5841CDCCCCCCE6472E41000000A0714C584100000000D8472E41000000006C4C584100000000D6472E41666666066B4C584100000000D4472E41CDCCCC8C694C584133333333D3472E41CDCCCC8C674C584100000000D4472E41CDCCCC0C664C584166666666D5472E4133333373644C584166666666D5472E4100000060634C584133333333D2472E4100000000614C584100000000CF472E41000000C05F4C58419A999999BB472E419A9999195C4C584100000000B7472E419A9999195B4C58419A999999AE472E419A9999D9574C584166666666A3472E419A9999B9544C58419A9999999A472E41333333B3524C5841CDCCCCCC81472E41666666E64D4C5841666666667A472E41666666264C4C58419A99999974472E41000000604A4C58413333333370472E4133333393484C5841333333336D472E41CDCCCCAC464C58419A9999996A472E41666666E6404C58416666666669472E41666666E63A4C58410000000062472E41CDCCCC8C344C5841666666665C472E41666666262F4C58419A9999994F472E4133333393294C5841CDCCCCCC4D472E419A9999B9274C5841333333334F472E4166666666254C5841333333335C472E41666666061F4C58410000000063472E419A9999B91B4C58419A99999966472E4166666626194C58416666666668472E41CDCCCC0C174C5841CDCCCCCC68472E419A999959134C5841CDCCCCCC64472E41666666260F4C5841CDCCCCCC5F472E41333333F3024C58413333333362472E419A9999D9004C58416666666669472E4100000080FE4B58419A99999972472E41333333B3FC4B5841CDCCCCCC82472E41CDCCCC4CFA4B5841666666668A472E4166666666F84B5841CDCCCCCC8C472E4100000060F74B5841333333338E472E419A9999F9F54B58419A9999998C472E4133333313F34B5841000000008D472E41666666E6F14B5841666666668E472E41333333B3F04B58416666666691472E41CDCCCC8CEF4B58419A99999995472E4133333373EE4B5841CDCCCCCC9A472E41CDCCCC6CED4B584100000000A1472E41CDCCCC8CEC4B5841CDCCCCCCA7472E41CDCCCCCCEB4B584166666666B2472E41CDCCCCECE94B58419A999999B8472E419A999939E84B584166666666BD472E41CDCCCC2CE64B584133333333C0472E41CDCCCC6CE54B5841CDCCCCCCCB472E41CDCCCC4CE24B584100000000DE472E4100000080DD4B584133333333EC472E41CDCCCC6CDA4B584133333333FE472E41666666E6D64B5841CDCCCCCC03482E419A9999D9D44B58416666666607482E41333333B3D14B5841CDCCCCCC0C482E4100000000D04B58419A99999916482E4166666646CE4B58419A99999920482E419A999939CD4B58410000000027482E4133333373CC4B5841CDCCCCCC2B482E4166666686CB4B5841333333332F482E4166666646CA4B5841CDCCCCCC30482E41000000C0C64B58419A9999992E482E41333333D3C34B58413333333327482E4133333353C04B58416666666623482E41CDCCCC2CBD4B58410000000022482E41CDCCCC6CBA4B5841CDCCCCCC1B482E4100000000B24B5841000000001D482E41333333B3B04B58419A99999912482E419A999939AB4B5841CDCCCCCC0F482E4100000040AA4B5841666666660F482E4133333353A94B584166666666F3472E41CDCCCCCC974B58419A999999F2472E41000000208D4B5841CDCCCCCCE0472E41333333F37F4B584100000000A4472E41666666C6744B584133333333A0472E41CDCCCC0C684B5841000000005E472E41000000A0554B58413333333370472E41000000A03C4B5841666666663C472E419A999979224B58416666666602482E41CDCCCC0CEA4A58416666666650482E4100000080CE4A58413333333346482E41666666C6CA4A58413333333373472E419A999999924A584166666666EE462E419A999939724A584133333333E6462E41000000A0DE49584133333333D7462E41000000C07A4958419A999999D8462E41333333536A49584166666666B9462E41CDCCCC8C6049584100000000DC452E410000002075495841CDCCCCCCFE442E41000000408849584100000000C5432E419A999919A5495841CDCCCCCC84422E419A999939BF495841CDCCCCCCB1412E4100000060D44958410000000074412E4100000080DC4958410000000040412E4166666646E3495841000000001B412E4100000080EA495841000000001D412E4100000000F5495841CDCCCCCC1C412E4166666646004A5841666666660F412E4100000000054A584100000000DA402E41CDCCCC2C0A4A5841666666668B402E419A9999390E4A5841666666663E402E41333333D3114A584166666666F63F2E41CDCCCCAC1A4A584133333333BB3F2E4100000060234A584100000000633F2E41666666E62A4A5841333333337C3F2E41CDCCCC0C2C4A584133333333943F2E41CDCCCCEC2D4A584166666666A63F2E4166666606394A584100000000C13F2E419A9999F93E4A584166666666DD3F2E419A9999F95C4A58419A999999FE3F2E41000000E0654A58419A9999991A402E41333333936C4A58413333333326402E41CDCCCC4C734A58413333333325402E419A9999B9744A58413333333315402E41000000E09D4A58419A99999905402E41CDCCCC0CA84A58419A999999E83F2E419A999939B44A584133333333CC3F2E4133333373BB4A584133333333BA3F2E41666666E6C14A5841CDCCCCCCBF3F2E41333333B3CB4A58419A999999B33F2E4100000000D24A5841CDCCCCCC7B3F2E419A999999D64A58419A9999991E3F2E4166666666DC4A584100000000013F2E41CDCCCC8CE14A5841CDCCCCCCDB3E2E419A9999D9E54A584133333333443E2E4133333373EF4A58419A9999993F3E2E419A999979F24A5841CDCCCCCC343E2E419A999959F54A58419A999999213E2E41333333D3F94A584166666666023E2E419A9999D9034B58419A999999E93D2E419A9999F9074B584166666666ED3D2E41000000C0144B584166666666F03D2E419A999919164B584133333333FB3D2E419A9999B91A4B5841CDCCCCCCFD3D2E41666666661D4B584100000000F63D2E41000000A01E4B584166666666DE3D2E4100000020244B5841CDCCCCCCCA3D2E4133333373274B584166666666BC3D2E41000000602A4B584166666666AB3D2E419A9999B92B4B584100000000983D2E419A999979324B584166666666823D2E419A999979344B5841666666666D3D2E419A9999D9374B5841000000006B3D2E41000000E03B4B58419A9999996B3D2E41666666A63F4B5841CDCCCCCC623D2E4100000080414B5841CDCCCCCC3C3D2E41CDCCCCEC444B584100000000383D2E4166666686454B584166666666273D2E41000000A0474B5841333333331B3D2E41333333934A4B58419A9999991D3D2E41666666864C4B584100000000083D2E41333333D3504B58419A999999F93C2E41CDCCCC4C584B584166666666E43C2E41CDCCCCEC5A4B584133333333DB3C2E419A9999795D4B58419A999999C23C2E41CDCCCCCC664B584133333333AC3C2E419A9999596B4B584100000000A13C2E41333333336C4B584100000000883C2E41333333736D4B584133333333663C2E41000000606F4B5841333333333A3C2E41333333937C4B5841666666663D3C2E419A9999D9874B584100000000043C2E4166666606984B584133333333EF3B2E419A9999399F4B5841CDCCCCCCD63B2E419A999999A84B58419A999999E43B2E4100000000BA4B584133333333CA3B2E4166666606CB4B584100000000CB3B2E41000000C0D14B584100000000B63B2E41CDCCCC2CD64B5841CDCCCCCC803B2E41333333B3DD4B584100000000003B2E419A999959ED4B584166666666D43A2E419A9999B9EF4B5841CDCCCCCCCA3A2E419A999999F54B584166666666C53A2E4100000020FF4B58419A999999A43A2E41CDCCCCEC0D4C5841CDCCCCCC843A2E4166666626154C584100000000673A2E4166666666184C5841000000001E3A2E4166666666214C584100000000B4392E41CDCCCCAC2C4C58419A9999996C392E41666666A62E4C58413333333367392E41000000202F4C5841CDCCCCCC63392E41000000E02F4C58419A99999963392E41333333B3304C58419A99999965392E4100000080314C58419A99999948392E4166666686354C5841CDCCCCCCEF382E4166666646454C5841CDCCCCCCB0382E41000000E04E4C58419A9999999F382E419A999939514C5841333333339D382E4166666666524C5841000000008F382E419A9999F95C4C5841CDCCCCCC86382E4133333353654C5841333333337E382E419A9999F9684C5841CDCCCCCC57382E41000000006E4C58413333333311382E4100000020764C58419A999999B1372E41666666667D4C58419A9999990F372E4100000060814C58416666666699362E419A999999854C5841000000005A362E4133333353894C58416666666614362E41666666C68C4C584166666666B5352E41666666069F4C5841000000007F352E419A999919A64C5841666666665D352E41CDCCCCECA84C5841CDCCCCCC17352E4100000040AD4C584166666666A7342E4100000080BF4C58410000000048342E4133333373CA4C5841CDCCCCCC3F342E4166666606D04C58419A99999946342E4166666686D94C5841CDCCCCCC40342E419A999959DE4C5841CDCCCCCC26342E41000000A0E24C58410000000011342E4166666626EB4C584100000000FA332E4133333393F64C584133333333D0332E41333333D3FE4C58419A9999993F332E419A999939154D584133333333FA322E41333333531C4D58419A999999A5322E4166666686204D5841333333336B322E419A999919244D58416666666670312E4133333353414D5841666666666D312E41333333F3464D5841CDCCCCCC40312E419A999959514D5841CDCCCCCCFE302E41CDCCCC0C554D5841CDCCCCCCDD302E41000000605F4D584100000000D8302E4100000040684D5841CDCCCCCC56302E41000000006E4D58413333333339302E4100000000754D5841CDCCCCCC04302E41666666A6794D584100000000B82F2E41CDCCCC0C774D584133333333502F2E4100000000774D584166666666302F2E41333333D3794D58419A9999999D2E2E41000000A07D4D5841CDCCCCCC742E2E41CDCCCC6C804D584133333333482E2E41333333537F4D5841CDCCCCCC282D2E41333333D36A4D584133333333E12C2E41333333337C4D5841CDCCCCCCD32B2E41333333B3A84D584133333333A12B2E4133333333B14D584100000000462B2E419A9999B9C34D58419A9999997E2A2E419A999979EF4D5841000000007E2A2E4166666686EF4D5841666666666D2A2E419A9999F9F04D5841CDCCCCCC412A2E419A999999F34D5841CDCCCCCC312A2E41CDCCCC8CF64D5841666666662A2A2E41CDCCCC0CF94D584100000000232A2E4100000080FB4D584166666666132A2E4100000040014E5841CDCCCCCC042A2E4100000020054E584100000000EB292E4100000040094E5841CDCCCCCCD7292E41000000800C4E5841CDCCCCCCCB292E41CDCCCCEC0E4E58419A999999BA292E419A999959104E5841CDCCCCCCB1292E41CDCCCCCC114E584166666666AB292E419A9999D9124E5841333333339F292E4100000020174E5841000000008E292E41333333F31A4E58410000000083292E419A9999991D4E58419A99999968292E41666666A6214E5841CDCCCCCC55292E41000000A0234E5841000000004B292E419A999939244E5841333333331F292E41333333F32C4E584166666666AB282E41666666E6434E5841333333337F282E419A9999594E4E5841333333334C282E41333333B3644E5841	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	01010000206A080000F43E7A36203C2E4133333353704D5841	040190000	Z	Barcelonnette	0401900	04019	04	93	17
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	01010000206A080000C8FF89C19F492D419A9999E9F7415841	040200000	Z	Barles	0402000	04020	04	93	60
01060000206A0800000100000001030000000100000072030000333333333AD92C41666666067E2D58410000000060D92C41CDCCCC2C8A2D58410000000061D92C419A9999798A2D5841333333336DD92C41CDCCCC6CA82D5841333333336FD92C4166666626AB2D58410000000071D92C419A999939AD2D5841CDCCCCCC72D92C4100000080AF2D58419A99999974D92C4100000060B12D5841CDCCCCCC79D92C4133333393B72D5841000000007FD92C41CDCCCCCCBD2D5841CDCCCCCC8FD92C4166666626D22D58413333333392D92C419A9999F9D42D58419A99999998D92C41333333D3DC2D58413333333399D92C4133333313E32D58413333333399D92C41CDCCCC2CE42D58419A99999999D92C4133333353E92D584166666666A3D92C4166666626EB2D5841CDCCCCCCADD92C41CDCCCC0CED2D584133333333B3D92C4100000040F12D584133333333BBD92C41CDCCCC6CF72D584133333333C3D92C4133333393FD2D584166666666CBD92C41000000C0032E584133333333D8D92C4166666666062E58419A99999926DA2C4100000060162E58413333333345DA2C4133333353202E584166666666AADA2C41333333F3322E584166666666ACDA2C4100000080332E584133333333A2DA2C419A999939362E5841CDCCCCCC95DA2C41333333733B2E58413333333392DA2C41333333933D2E584133333333A4DA2C419A999919472E5841CDCCCCCCA8DA2C41333333B34C2E58419A999999A8DA2C41666666A64F2E58419A9999999FDA2C4166666646552E58419A9999999DDA2C4133333373592E58419A9999999DDA2C41CDCCCC8C5F2E584166666666B3DA2C41CDCCCC6C6C2E584133333333B9DA2C41CDCCCCEC762E584100000000C0DA2C4166666646872E5841CDCCCCCCC5DA2C41000000E0902E58419A999999C6DA2C4166666626A22E5841000000001DDB2C419A999999B42E5841333333336ADB2C41000000A0B52E5841CDCCCCCCAADB2C41CDCCCC6CB92E58419A9999991DDC2C41CDCCCCACC02E58410000000061DC2C4100000040CA2E58410000000088DC2C419A999939D32E5841CDCCCCCCB5DC2C4166666626DD2E584100000000EBDC2C41000000E0E62E58419A99999978DD2C41CDCCCC0CEB2E584133333333D1DD2C41CDCCCCECEB2E58419A9999995EDE2C4100000060ED2E584133333333DFDE2C41000000E0ED2E5841CDCCCCCC3BDF2C419A9999F9F02E584166666666A4DF2C4100000020F72E584133333333FCDF2C4133333393FE2E5841CDCCCCCC97E02C41CDCCCC6C022F58419A99999905E12C4100000020072F58410000000072E12C419A9999D90F2F5841CDCCCCCCC5E12C41CDCCCC4C172F5841CDCCCCCC67E22C419A999939192F584133333333D5E22C41CDCCCC4C1C2F5841CDCCCCCC10E32C41666666C6232F5841CDCCCCCC0EE32C41666666C6242F5841CDCCCCCC10E32C41333333D3252F58416666666612E32C41000000C0262F58416666666621E32C41333333B3292F5841000000003CE32C4133333353352F58410000000019E32C4133333353472F58410000000019E32C4166666646482F5841CDCCCCCC16E32C41333333B34A2F58416666666616E32C419A9999F94D2F58410000000015E32C419A9999B9502F58416666666612E32C4166666626522F58419A9999990BE32C41CDCCCC4C532F58413333333309E32C419A9999B9542F5841000000000AE32C419A999939562F58419A99999913E32C419A9999B9592F58419A99999914E32C41333333935B2F58413333333313E32C41666666665E2F5841333333330AE32C4100000060622F58419A99999901E32C41CDCCCCEC662F584166666666F3E22C41000000606D2F5841CDCCCCCCE7E22C41CDCCCC4C722F584100000000E6E22C41333333B3732F584133333333ECE22C4100000020762F58419A999999EEE22C41CDCCCC6C772F584100000000ECE22C41CDCCCC4C792F584100000000E1E22C41CDCCCC6C7E2F5841CDCCCCCCD7E22C4166666606842F584100000000D1E22C41CDCCCC0C8A2F58419A999999CFE22C41666666268E2F58419A999999CDE22C41333333D3912F584133333333C7E22C4133333333952F5841CDCCCCCCC0E22C419A9999D9972F584100000000B2E22C419A9999D99D2F584133333333A7E22C4100000060A12F58419A9999999EE22C4166666606A32F58410000000093E22C4100000040A52F5841333333338BE22C419A999939A72F5841000000007FE22C41CDCCCC0CAB2F5841CDCCCCCC7BE22C41CDCCCC2CAD2F5841333333337EE22C41666666E6AF2F5841666666667DE22C4166666686B12F5841CDCCCCCC76E22C4100000040B32F58413333333366E22C419A999979B52F5841CDCCCCCC4DE22C419A9999F9B72F5841666666663FE22C41CDCCCCECB92F58413333333334E22C419A9999B9BB2F5841000000002FE22C41666666E6BD2F58416666666627E22C4100000040C02F58419A9999991AE22C419A999939C22F58419A999999E5E12C419A999979DF2F584100000000FDE12C4133333333F32F58416666666613E22C4100000000FC2F58410000000034E22C41000000A005305841333333339FE22C419A9999B91A30584166666666D0E22C4133333393203058413333333308E32C41CDCCCC4C24305841000000004AE32C4133333353263058416666666684E32C41000000402530584133333333F5E32C419A9999F9243058416666666603E42C41000000A025305841000000002AE42C416666660628305841000000003BE42C41000000A028305841333333335EE42C41000000A02B3058413333333380E42C41000000602E30584100000000AEE42C419A9999393230584100000000BFE42C419A9999793230584166666666D4E42C41CDCCCCAC323058419A999999E5E42C4166666626333058419A999999FAE42C41000000C0333058410000000015E52C416666664635305841333333332DE52C41CDCCCC6C37305841000000004EE52C419A9999393A305841CDCCCCCC76E52C41CDCCCC6C3D305841CDCCCCCC92E52C41666666A63F30584166666666B0E52C41CDCCCCAC4130584133333333CFE52C413333331343305841666666660BE62C41CDCCCC8C44305841CDCCCCCC10E62C41333333B344305841CDCCCCCC27E62C41333333B346305841CDCCCCCC60E62C41000000A0463058419A99999994E62C41CDCCCC0C4A30584133333333CEE62C41CDCCCC8C4C3058419A99999900E72C410000008051305841CDCCCCCC46E72C41CDCCCC2C553058413333333378E72C41666666265630584166666666FBE72C4166666606573058419A99999908E82C41666666265A3058419A99999968E82C41666666E65C305841CDCCCCCCA7E82C41CDCCCC4C613058419A999999D4E82C4133333353663058419A999999F2E82C419A9999596A3058419A99999918E92C419A9999D96D3058419A99999935E92C413333331370305841333333334EE92C4100000080733058416666666652E92C41666666E6773058413333333363E92C41CDCCCC4C7C3058410000000086E92C419A9999B98030584133333333B6E92C4100000040843058419A999999D5E92C41666666468830584166666666D8E92C41333333338B30584100000000F9E92C41666666868E3058416666666627EA2C410000000092305841CDCCCCCC66EA2C416666664695305841CDCCCCCC98EA2C4100000020963058419A999999CEEA2C419A9999D9973058419A99999903EB2C4166666666993058419A99999941EB2C41000000C09A3058416666666649EB2C41CDCCCCEC9A305841CDCCCCCC6AEB2C41666666669B30584100000000BEEB2C4133333313A23058410000000001EC2C4166666606A73058413333333356EC2C41666666A6AB305841CDCCCCCC88EC2C41CDCCCC0CAE30584133333333B9EC2C4100000060AE30584133333333E1EC2C4166666626B2305841CDCCCCCCFFEC2C4166666626B73058410000000028ED2C41666666C6BB3058416666666646ED2C4133333353C13058416666666654ED2C41333333B3C7305841CDCCCCCC70ED2C4133333313CC305841666666669BED2C41333333B3CF305841CDCCCCCCC0ED2C4133333333D430584166666666E3ED2C419A999959D53058413333333308EE2C41666666C6D6305841666666661FEE2C4133333393D83058419A99999937EE2C419A999939DF305841333333334CEE2C41333333B3E4305841333333335FEE2C419A9999B9E7305841000000008BEE2C41333333B3EA30584133333333B6EE2C41666666A6EE30584100000000EFEE2C4166666626F2305841333333332EEF2C4133333333F43058416666666670EF2C4100000060F530584100000000B4EF2C41333333B3F53058419A999999E5EF2C4166666666F53058419A999999FBEF2C4100000040F5305841CDCCCCCC3CF02C4166666686F6305841CDCCCCCC77F02C41000000E0F730584100000000FCF02C4100000080FA3058413333333349F12C419A999959FD305841CDCCCCCC8DF12C41000000C0FE3058419A999999D4F12C4133333373FF3058416666666610F22C4166666666F9305841CDCCCCCC56F22C41CDCCCC8CF530584100000000AEF22C41666666A6F53058410000000011F32C41CDCCCC2CF53058416666666660F32C41CDCCCCECF2305841CDCCCCCCB5F32C4100000020EE3058410000000007F42C41CDCCCCACED3058419A9999993EF42C419A999979EF3058413333333376F42C41CDCCCC6CEF30584166666666A3F42C41CDCCCC0CF130584133333333D6F42C4100000040F0305841CDCCCCCCFBF42C4133333313EF3058419A9999990FF52C4133333373EE3058413333333348F52C41CDCCCCACEA3058416666666696F52C4133333353E830584100000000C3F52C41CDCCCC8CE830584100000000E9F52C41CDCCCCCCE9305841CDCCCCCC01F62C4100000080ED305841CDCCCCCC25F62C4100000060F0305841CDCCCCCC50F62C4100000060F13058416666666685F62C41CDCCCCECF230584166666666AEF62C41333333F3F23058419A999999ECF62C41CDCCCC0CF43058419A9999992FF72C419A9999F9F3305841CDCCCCCC62F72C4133333393EF30584133333333BBF72C41000000E0EE305841CDCCCCCC00F82C41CDCCCC8CEF305841000000002EF82C41CDCCCCCCEC305841666666666EF82C4166666626E93058419A999999B3F82C41666666E6E430584100000000CFF82C4166666686DE305841CDCCCCCCD4F82C4100000040D630584166666666EAF82C419A999999CF305841CDCCCCCCFFF82C419A999999CC305841333333331EF92C4133333393C93058413333333341F92C419A999939C73058419A99999970F92C4166666626C4305841CDCCCCCC95F92C419A999999C230584100000000ADF92C41CDCCCC8CBF3058419A999999C2F92C419A999959BC3058419A999999E2F92C41CDCCCC0CB73058416666666613FA2C4166666646AF3058416666666637FA2C4100000080A93058410000000067FA2C419A999999A1305841333333338CFA2C41000000A09B30584166666666ABFA2C41666666C6923058419A999999B0FA2C41666666069030584166666666D0FA2C41000000608C3058410000000012FB2C4100000080823058416666666678FB2C41CDCCCCCC72305841CDCCCCCCF2FB2C41CDCCCCCC643058419A99999976FC2C41CDCCCC0C58305841CDCCCCCC0DFD2C41333333D347305841CDCCCCCC96FD2C41CDCCCC0C3D3058419A9999991DFE2C41333333F333305841CDCCCCCC5BFE2C41CDCCCC8C31305841CDCCCCCCA0FE2C41666666062F30584100000000ACFE2C41CDCCCC0C283058419A999999CBFE2C41666666A629305841CDCCCCCCDAFE2C41666666E629305841CDCCCCCCF4FE2C416666660628305841333333330EFF2C413333337326305841CDCCCCCC20FF2C41000000A026305841666666662DFF2C4166666686273058419A99999936FF2C41CDCCCC6C2A3058410000000058FF2C41333333F32A3058416666666675FF2C41000000402B305841666666669EFF2C41666666062D30584133333333D3FF2C4133333313303058419A99999909002D4100000080323058410000000033002D4166666646333058410000000064002D416666662635305841CDCCCCCC8C002D41666666663630584133333333B5002D41666666263730584133333333E8002D41CDCCCCEC36305841CDCCCCCC2B012D41CDCCCC8C363058416666666642012D4166666606373058419A99999965012D41CDCCCC2C38305841CDCCCCCC7B012D416666662638305841CDCCCCCC8F012D41333333B33630584133333333A0012D41333333F33430584166666666B2012D4100000020343058419A999999F4012D41666666A6313058410000000010022D41333333932F305841000000002A022D413333335329305841666666664D022D41CDCCCC4C23305841000000008F022D41333333531B30584133333333B0022D41666666C616305841CDCCCCCCDC022D419A9999790C305841CDCCCCCC04032D419A999979093058419A99999912032D419A999999F12F58413333333346032D419A9999D9E82F58410000000041032D419A9999B9DA2F58416666666625032D419A999979CE2F58419A999999E1022D419A999919BE2F58419A999999C4022D41333333D3AA2F58419A99999991022D41CDCCCCCC9B2F58413333333361022D41666666868A2F58416666666643022D419A9999D97F2F58419A9999991D022D41CDCCCCAC742F584166666666F5012D41CDCCCCCC6E2F584166666666E7012D41CDCCCC8C6B2F584133333333C6012D4166666686652F5841CDCCCCCCB0012D41CDCCCC0C632F58419A999999AD012D4133333393622F58419A9999999D012D4166666646602F5841CDCCCCCC8F012D4100000000602F5841CDCCCCCC8A012D41CDCCCC6C5E2F58419A99999987012D41CDCCCCCC5C2F58419A9999998E012D41333333D35A2F58410000000094012D4100000060592F5841CDCCCCCC8F012D41CDCCCC8C552F58413333333386012D4100000060522F58413333333368012D41CDCCCC0C4F2F58419A99999956012D41000000004C2F5841CDCCCCCC40012D41000000204A2F58410000000014012D41CDCCCC6C482F5841CDCCCCCC07012D4133333373482F584100000000ED002D41CDCCCC2C4A2F584133333333D1002D41333333D34C2F584100000000B1002D41666666064D2F58419A9999998E002D41666666664D2F58416666666663002D41333333534D2F5841CDCCCCCC30002D41000000004C2F5841333333330D002D41666666864A2F58419A999999E7FF2C41CDCCCC6C482F5841CDCCCCCCD6FF2C41666666A6452F584166666666CBFF2C41CDCCCC6C442F584133333333A7FF2C41333333F3422F5841333333337BFF2C4100000020422F5841CDCCCCCC59FF2C4166666606402F58419A9999993FFF2C41666666263F2F5841CDCCCCCC27FF2C41000000403F2F58416666666607FF2C4100000040402F5841CDCCCCCCF0FE2C41333333F3402F584133333333C3FE2C41CDCCCC8C422F584133333333B4FE2C41333333F3412F584166666666A3FE2C4166666666402F5841CDCCCCCC6FFE2C41666666263E2F58410000000046FE2C41000000803C2F58413333333334FE2C41000000E0392F58419A99999933FE2C41CDCCCCAC392F5841000000002BFE2C41CDCCCC6C372F58410000000027FE2C41666666A6342F58413333333327FE2C419A9999D9302F5841CDCCCCCC22FE2C41CDCCCC8C2C2F58413333333320FE2C4133333333282F58413333333315FE2C41333333D3252F58416666666604FE2C4133333393222F584133333333FCFD2C41CDCCCCCC212F5841CDCCCCCCEFFD2C4100000000222F58419A999999D6FD2C4133333373222F584133333333C0FD2C4133333333212F58419A99999988FD2C41CDCCCC4C1D2F5841333333336AFD2C41000000001D2F58413333333348FD2C41CDCCCC8C1C2F5841000000003BFD2C41666666461B2F58410000000030FD2C4100000020192F5841CDCCCCCC1CFD2C4166666686172F5841CDCCCCCC06FD2C41000000A0162F58419A999999E1FC2C419A9999B9172F584166666666C5FC2C4166666626192F584166666666B3FC2C419A9999F9192F584100000000A6FC2C419A999959192F5841000000009AFC2C4100000000182F58416666666695FC2C41666666C6162F5841CDCCCCCC8CFC2C41CDCCCCAC112F5841CDCCCCCC7FFC2C41CDCCCC4C102F58410000000076FC2C41000000E00D2F58419A9999995BFC2C41CDCCCCAC0A2F5841333333334BFC2C41CDCCCC8C092F58419A99999931FC2C419A9999190A2F58419A99999908FC2C41666666460A2F584133333333CEFB2C41CDCCCC2C0B2F5841CDCCCCCCC0FB2C41000000000B2F584166666666BAFB2C41CDCCCCAC0A2F58419A9999999BFB2C41CDCCCC4C082F5841000000008AFB2C4133333373062F58419A99999961FB2C4100000000032F58419A99999941FB2C41CDCCCC2CFF2E58416666666631FB2C419A999939FD2E5841CDCCCCCC1AFB2C41CDCCCCACFC2E5841CDCCCCCCEFFA2C41333333B3FB2E584166666666D0FA2C4100000060F92E58419A9999999DFA2C41CDCCCC0CF62E58413333333356FA2C41CDCCCC8CF22E5841CDCCCCCC16FA2C419A9999F9EF2E584166666666FDF92C41CDCCCC6CED2E5841CDCCCCCCF0F92C41CDCCCCACEC2E584133333333BBF92C41000000E0EB2E5841CDCCCCCCADF92C41000000A0EA2E5841CDCCCCCC8CF92C41CDCCCC0CE02E58416666666630F92C4166666666D12E584133333333EAF82C4133333313C72E584100000000E1F82C419A9999B9B92E584133333333C9F82C4100000020B62E58419A999999BAF82C4133333313B12E5841CDCCCCCCBBF82C41666666C6AF2E5841CDCCCCCCC7F82C41333333B3AC2E584166666666DAF82C41CDCCCCECAA2E584133333333FBF82C4100000020A92E5841CDCCCCCC18F92C419A999959A42E58419A99999935F92C41000000009F2E5841CDCCCCCC4BF92C41666666269A2E5841333333334AF92C419A999919972E58413333333347F92C41CDCCCCCC942E58419A9999993FF92C4100000000932E5841CDCCCCCC33F92C41CDCCCC2C902E58410000000029F92C41666666268C2E5841CDCCCCCC29F92C4166666646882E5841666666662DF92C419A999959842E5841000000003CF92C41333333737F2E5841333333334FF92C41666666667C2E5841CDCCCCCC52F92C419A9999197B2E5841333333335EF92C41000000C0762E58419A99999963F92C41CDCCCC2C742E58419A9999995EF92C419A9999996E2E58419A99999964F92C4133333313692E5841CDCCCCCC5EF92C41CDCCCC0C4D2E5841333333334BF92C41000000C0352E584133333333CFF82C41CDCCCC6CE92D584166666666A5F82C41CDCCCC0CCE2D58416666666688F82C4166666686BE2D5841666666668DF82C4100000060B72D5841CDCCCCCC88F82C4100000060B52D5841CDCCCCCC7DF82C41CDCCCCECAF2D5841000000007BF82C4100000020AE2D58413333333374F82C419A9999D9A92D58419A9999996DF82C41333333F3A62D5841CDCCCCCC58F82C41000000A0A42D58416666666654F82C41CDCCCC8CA02D5841CDCCCCCC4BF82C41666666469C2D58419A99999939F82C4133333373982D5841CDCCCCCC20F82C41CDCCCCEC942D5841333333331AF82C41CDCCCC2C912D5841666666661AF82C41CDCCCC8C8D2D5841CDCCCCCC1FF82C41CDCCCCCC872D5841333333331AF82C419A999979862D5841333333331CF82C4133333353842D5841CDCCCCCC01F82C419A9999D97E2D584133333333F8F72C41CDCCCC6C7B2D584133333333F2F72C4166666646792D5841CDCCCCCCEFF72C41CDCCCC6C752D584166666666F2F72C419A9999D9712D5841CDCCCCCC02F82C41CDCCCCCC6C2D58410000000014F82C419A999959682D58419A9999991BF82C4166666666662D5841CDCCCCCC3DF82C4133333313662D5841CDCCCCCC50F82C41000000C0642D5841333333335AF82C4166666606632D5841666666665BF82C419A9999995F2D5841666666665FF82C41666666265D2D58419A99999970F82C41666666065B2D58419A9999997FF82C41000000E0572D5841CDCCCCCC92F82C419A999999532D58419A999999A4F82C419A9999994D2D584166666666B6F82C4133333313482D584100000000CAF82C4100000020432D584133333333D3F82C41CDCCCC8C3E2D58419A999999D2F82C41333333133C2D584100000000D2F82C41666666A6392D584133333333CEF82C419A999959362D5841CDCCCCCCCEF82C4166666606342D5841CDCCCCCCCEF82C419A999919332D58419A999999D6F82C419A9999792E2D584133333333ECF82C41CDCCCCEC282D584100000000F2F82C4100000040282D58410000000007F92C41000000C0252D58413333333323F92C41CDCCCCAC202D58419A99999944F92C41333333131B2D58416666666650F92C4100000000172D58419A99999961F92C4166666666132D5841666666667EF92C41CDCCCC6C112D584166666666A2F92C41333333730F2D584133333333AAF92C41333333330D2D584133333333A8F92C41666666660B2D58419A999999A6F92C419A999999092D584166666666B4F92C4100000040032D58419A999999BFF92C41CDCCCC4C022D58419A999999C1F92C4166666626022D58419A999999D0F92C419A999939FD2C58419A999999D8F92C41CDCCCCECF82C584100000000D8F92C41666666E6F52C5841CDCCCCCCCDF92C4133333373F32C584133333333B6F92C419A9999F9ED2C5841CDCCCCCCA7F92C4100000060EA2C58416666666684F92C41CDCCCC4CE62C58419A9999997EF92C4133333393E22C5841CDCCCCCC85F92C4100000060DF2C5841333333337AF92C4133333313DA2C5841333333338AF92C4133333333D42C58410000000088F92C4133333353CF2C58410000000084F92C419A999939CD2C5841CDCCCCCC58F92C4100000040CB2C5841CDCCCCCC2EF92C4166666646C92C58413333333321F92C419A999959C72C5841CDCCCCCC20F92C41CDCCCC2CC72C58410000000015F92C4166666606C22C5841CDCCCCCC17F92C419A999959BE2C58419A99999918F92C4133333313BE2C58410000000027F92C41CDCCCC8CB82C5841000000002AF92C41333333D3B62C58419A99999931F92C41CDCCCC8CB22C58416666666648F92C4100000020AC2C5841CDCCCCCC52F92C41000000A0A62C5841CDCCCCCC59F92C4100000040A22C5841666666666CF92C4100000080972C58413333333379F92C419A999999932C5841666666667DF92C419A999959922C58416666666680F92C41000000008F2C58413333333383F92C41000000E08B2C5841000000008AF92C41000000208A2C5841666666669EF92C41CDCCCCEC852C584166666666B0F92C4166666666822C584100000000B7F92C4100000020812C584100000000BBF92C41666666867F2C584100000000BAF92C419A9999197F2C58419A999999AEF92C41333333537A2C584166666666ACF92C4166666646772C58419A999999B1F92C41333333F3752C5841CDCCCCCCBCF92C4100000060742C584133333333C1F92C4133333353732C58419A999999BFF92C41333333B36D2C584166666666C0F92C41000000606A2C58419A999999C0F92C419A9999F9682C584166666666BCF92C419A9999B9632C5841CDCCCCCCBAF92C4100000000622C584100000000C0F92C41CDCCCCCC5F2C584100000000CBF92C41666666A65E2C584133333333EFF92C41333333135B2C584166666666FEF92C41CDCCCC6C592C58416666666603FA2C4100000040582C5841333333330AFA2C4133333353542C58419A9999990DFA2C4133333333522C5841333333332BFA2C419A9999F94E2C58413333333348FA2C41666666064B2C5841CDCCCCCC71FA2C41CDCCCC0C452C5841000000007DFA2C419A9999D9422C5841333333337FFA2C4100000020422C58419A9999998CFA2C41666666863D2C5841666666669CFA2C4133333393392C584133333333AAFA2C4166666686332C584166666666DBFA2C4166666686222C584166666666C6FA2C4133333333202C584133333333BFFA2C4166666666172C584133333333B1FA2C41666666460C2C5841CDCCCCCCD6FA2C4133333333FE2B58419A999999B3FA2C41CDCCCC8CF42B58419A999999BAFA2C4133333353EC2B584133333333B1FA2C4133333373DF2B584133333333B8FA2C4100000060D12B584166666666D4FA2C4166666646CD2B5841000000000FFB2C4100000040C62B58410000000016FB2C41CDCCCCECBE2B58419A999999C8FA2C41666666C6A72B5841CDCCCCCCA7FA2C4166666606A12B58419A99999976FA2C41333333B3992B5841666666663EFA2C4133333353902B584166666666C4F92C419A9999B9722B5841000000008FF82C41333333D32D2B5841CDCCCCCC4CF82C41666666261F2B58410000000012F82C41333333D3112B584133333333DDF72C419A999999082B5841000000008BF72C41666666E6FF2A584166666666FDF62C4133333353F82A58419A9999999AF62C4100000020F32A5841000000000DF62C4100000000EB2A5841333333335FF52C419A999979E22A5841CDCCCCCCE3F42C4100000080D92A5841666666668FF42C41CDCCCC6CCE2A58419A99999959F42C4133333313C52A58410000000015F42C41CDCCCCCCAD2A584166666666D2F32C41000000008D2A584100000000DCF32C41000000E0722A584166666666EDF32C41666666C6532A58410000000005F42C41333333B33C2A58410000000035F42C41333333931D2A58419A9999999CF42C41CDCCCC0CF62958410000000007F52C419A999959D32958413333333335F52C4100000060BE295841000000004DF52C4100000080AB2958416666666677F52C41000000608C2958416666666698F52C41333333D37C2958419A999999A0F52C41333333337729584133333333DEF42C41000000E08F29584133333333AEF42C419A999959912958416666666676F42C416666662692295841666666662FF42C4166666606932958419A999999F6F32C41CDCCCCAC932958416666666697F32C4133333313952958410000000054F32C4100000000962958416666666630F32C4133333333952958419A9999990CF32C410000004093295841CDCCCCCC71F22C41666666A69B295841CDCCCCCC48F22C419A9999799C2958416666666628F22C419A9999F99C2958419A9999990EF22C41333333739D29584100000000E1F12C41000000C09E295841CDCCCCCCABF12C41000000C0A0295841000000008EF12C41666666A6A4295841CDCCCCCC6CF12C4100000060A7295841CDCCCCCC40F12C4100000080A82958416666666604F12C4133333393AA295841CDCCCCCCD2F02C4100000040AC29584133333333B7F02C4100000000AB295841000000008FF02C419A9999B9A92958413333333362F02C41CDCCCC2CAB2958419A99999937F02C4166666606AE295841333333330AF02C4133333313B129584100000000E4EF2C4133333333B229584133333333CBEF2C419A999959B129584133333333A5EF2C4100000000AE295841CDCCCCCC8AEF2C4100000000AD2958419A99999960EF2C41CDCCCCACAD2958410000000028EF2C419A9999D9AF295841CDCCCCCCDAEE2C4166666666B0295841CDCCCCCC9EEE2C4133333313B0295841CDCCCCCC75EE2C419A999919B22958419A9999995EEE2C41CDCCCCECB42958419A99999950EE2C41CDCCCC8CB7295841CDCCCCCC0AEE2C41666666A6BE29584133333333D9ED2C4133333393C329584133333333B1ED2C41CDCCCC8CC6295841CDCCCCCC7AED2C4166666686CD2958413333333352ED2C4133333313D2295841000000002FED2C419A9999B9D52958413333333317ED2C41666666A6D72958419A999999ECEC2C4100000020DA29584166666666D2EC2C41CDCCCC4CDC29584100000000B4EC2C419A999959DE2958419A999999A4EC2C4100000060DF2958419A99999967EC2C41CDCCCCECE12958419A99999927EC2C41CDCCCCECE32958419A999999F8EB2C4133333313E529584100000000CDEB2C41CDCCCCACE629584166666666A0EB2C4133333373E82958419A99999979EB2C41000000A0EA2958416666666673EB2C4100000080EB2958419A99999962EB2C41666666E6ED2958419A99999940EB2C41666666A6F1295841666666662AEB2C4100000020F4295841000000000BEB2C4166666646F72958419A999999F7EA2C41CDCCCC4CF9295841CDCCCCCCCFEA2C41666666E6FA29584166666666AEEA2C41CDCCCCACFB29584133333333A9EA2C4166666646FC295841333333330FEA2C4100000080FC29584166666666D3E92C41333333330A2A5841000000009BE92C41333333D31B2A58410000000081E92C41CDCCCC4C2E2A584133333333BAE92C41666666C63E2A58419A999999B9E92C4100000040472A58410000000028EA2C4166666606602A58410000000097EA2C419A9999D9702A584166666666E2EA2C41000000E0792A584100000000F7EA2C41666666667A2A58416666666613EB2C41CDCCCC2C7C2A58410000000020EB2C41666666667D2A58413333333329EB2C41000000A07E2A5841CDCCCCCC2FEB2C41666666C67F2A5841CDCCCCCC4CEB2C4166666666852A58416666666661EB2C41666666C6892A58419A99999965EB2C41000000C08A2A58416666666672EB2C41666666068E2A5841CDCCCCCC73EB2C419A9999798E2A58419A99999975EB2C419A9999598F2A58413333333377EB2C41000000A0932A5841CDCCCCCC78EB2C419A999919962A5841000000007BEB2C419A9999D9972A5841CDCCCCCC7EEB2C41666666E6992A5841CDCCCCCC83EB2C41CDCCCCCC9B2A58416666666693EB2C419A9999B99F2A58419A99999995EB2C419A9999F99F2A58419A9999996DEB2C4100000080BE2A58413333333360EB2C41CDCCCCCCD62A5841666666669CEB2C4100000060F12A5841666666668EEB2C419A9999F9FD2A58410000000047EB2C41666666E60F2B58413333333330EB2C41CDCCCC0C1B2B5841CDCCCCCC2FEB2C419A9999F9292B58419A9999994BEB2C41333333D33C2B5841000000004EEB2C41333333134E2B58419A99999946EB2C41666666464E2B5841CDCCCCCC3CEB2C41666666864F2B5841CDCCCCCC37EB2C41000000C0502B5841CDCCCCCC2AEB2C41CDCCCC6C512B58416666666621EB2C4100000000522B58419A99999916EB2C419A999939542B5841CDCCCCCCFBEA2C41666666A6582B584133333333F0EA2C419A9999795B2B5841CDCCCCCCE5EA2C41333333335E2B584133333333D8EA2C419A999979612B58419A999999CBEA2C41000000E0642B58419A999999B6EA2C41333333F36A2B58419A999999ABEA2C41333333B36C2B5841CDCCCCCC9EEA2C41000000406E2B5841333333338AEA2C41333333336F2B5841CDCCCCCC74EA2C4133333393702B58410000000068EA2C41CDCCCCEC702B58419A99999956EA2C419A999959722B5841CDCCCCCC42EA2C41CDCCCCEC742B58416666666630EA2C41666666A6762B58410000000017EA2C4166666646782B584166666666FEE92C41CDCCCC4C7A2B5841CDCCCCCCF4E92C41666666C67A2B584133333333CEE92C41000000807C2B58419A999999B6E92C419A9999397D2B5841CDCCCCCC29E92C4100000040952B5841666666660FE92C419A999979982B58419A999999FFE82C41CDCCCC8C9A2B58419A999999F2E82C41666666E69C2B58419A999999E4E82C41333333F39E2B584100000000DCE82C4166666606A22B58419A999999D5E82C41333333B3A32B584166666666CEE82C41CDCCCC0CA52B58419A999999C5E82C4133333353A62B584133333333B2E82C4100000080A82B5841CDCCCCCCA9E82C4166666606AA2B58410000000098E82C4100000020AC2B58410000000076E82C41CDCCCCECAD2B58413333333359E82C41CDCCCC0CAF2B5841666666663FE82C419A999939B02B58413333333337E82C41CDCCCCCCB02B5841000000002EE82C4133333393B12B58413333333323E82C419A999919B32B5841666666661AE82C419A999999B42B58413333333319E82C4133333313B62B58419A99999918E82C4100000060B72B5841333333331AE82C419A999919BA2B5841666666661CE82C4133333353BB2B58419A99999925E82C41000000C0BE2B58413333333329E82C419A9999D9C02B58410000000029E82C41000000E0C12B58410000000026E82C41666666E6C22B58419A99999922E82C41333333B3C32B58419A9999991DE82C4166666686C42B5841CDCCCCCC1BE82C41666666A6C42B58410000000016E82C4166666666C52B58416666666613E82C41CDCCCC4CC62B58410000000014E82C41CDCCCC2CC72B58416666666604E82C419A999939CC2B584133333333FEE72C41CDCCCCACCD2B58419A999999F8E72C419A999979CE2B58419A999999EFE72C4100000060D02B584166666666EDE72C4166666606D12B584100000000E8E72C4133333313D22B584100000000E7E72C4133333333D22B5841CDCCCCCCE4E72C419A999959D22B58419A999999E2E72C41333333B3D22B58419A999999E1E72C419A999939D32B58419A999999E3E72C41333333F3D32B584133333333E6E72C41000000A0D42B584100000000E7E72C41CDCCCC0CD52B584166666666E6E72C4133333393D52B58419A999999E3E72C4133333313D62B584100000000DFE72C4166666646D72B5841CDCCCCCCDCE72C4133333393D82B584166666666DCE72C4100000000DA2B58419A999999D9E72C4100000060DB2B5841CDCCCCCCD6E72C41CDCCCC8CDB2B5841CDCCCCCCD0E72C4166666626DC2B5841CDCCCCCCCCE72C419A9999F9DC2B584133333333C9E72C419A999919DF2B584166666666C9E72C419A999959E12B58419A999999CCE72C419A999939E22B58419A99999971E72C41000000C0F82B5841000000004BE72C41666666460A2C58419A99999924E72C41CDCCCCEC102C584166666666E4E62C4166666626172C58419A999999A0E62C41333333B31F2C58410000000002E62C419A999999322C584100000000B5E52C41CDCCCCCC3D2C5841666666667BE52C41000000E04D2C58416666666650E52C4166666686562C5841CDCCCCCC0AE52C41333333D3612C584166666666E6E42C4166666606682C5841CDCCCCCCA4E42C419A9999F96E2C58419A99999952E42C41000000C07C2C58413333333346E42C41666666A6832C58416666666645E42C41333333B38C2C5841CDCCCCCC4EE42C419A999939962C58419A9999995AE42C419A999939A42C58416666666651E42C419A999939AB2C5841CDCCCCCC42E42C41333333F3AF2C5841CDCCCCCC2EE42C41666666E6B82C5841CDCCCCCC1DE42C41666666C6C42C58419A999999FDE32C4133333313CA2C5841CDCCCCCCC7E32C419A999999D32C5841CDCCCCCC8FE32C4133333393DB2C58419A99999977E32C41666666E6E12C5841666666664FE32C41CDCCCC4CEF2C5841333333333EE32C4166666646F52C58413333333337E32C41CDCCCC6CFA2C58416666666600E32C41CDCCCC6C012D584166666666F9E22C41CDCCCC0C032D58419A999999F6E22C41000000E0042D5841CDCCCCCCF6E22C41333333F3092D58419A999999F7E22C41CDCCCC6C0D2D58419A999999F6E22C419A9999D90E2D58419A999999F1E22C41CDCCCC4C102D584166666666E6E22C419A999919132D584133333333D9E22C4166666646172D584100000000D0E22C41CDCCCC8C1A2D58419A999999C6E22C41CDCCCC6C1E2D58416666666698E22C41000000801F2D58413333333369E22C41333333731E2D58416666666633E22C41CDCCCCCC1C2D584166666666ECE12C41333333B3192D584133333333B7E12C419A9999B9162D58419A9999996DE12C41000000C0112D58410000000022E12C419A9999F9062D58419A999999CAE02C41333333D3F92C5841CDCCCCCC75E02C4133333333E52C58419A9999993CE02C4166666626DA2C58413333333331E02C4100000020D52C58410000000028E02C4133333333CF2C5841CDCCCCCC32E02C419A9999D9C32C58413333333342E02C4100000000BC2C5841666666664EE02C419A999979B02C58419A99999947E02C4100000080A82C5841000000002FE02C41333333B39C2C58416666666624E02C41666666E6992C58419A999999CDDF2C41333333F3A12C5841333333337FDF2C4100000040AD2C58410000000051DF2C41CDCCCC8CB82C58413333333347DF2C4166666606BD2C5841CDCCCCCC24DF2C4166666626C22C58419A999999D8DE2C41333333D3C82C58410000000091DE2C4100000080CC2C58419A99999961DE2C41CDCCCC2CCF2C58410000000051DE2C419A9999F9D12C58410000000040DE2C419A999919D52C58410000000031DE2C41000000A0D62C58419A9999991CDE2C41CDCCCCACD62C58410000000015DE2C4133333313D72C58413333333309DE2C4166666606D92C58419A999999F5DD2C41CDCCCC4CDC2C584166666666EADD2C4166666646DF2C58419A999999D9DD2C4100000080E22C5841CDCCCCCCCADD2C41000000E0E42C584133333333C2DD2C41CDCCCC8CE82C584166666666BDDD2C41CDCCCC6CEB2C584166666666ADDD2C4166666606EF2C5841CDCCCCCC98DD2C41666666A6F22C5841000000007FDD2C41CDCCCC0CF52C58410000000074DD2C41CDCCCC0CF72C5841000000006DDD2C4166666646FA2C5841333333336ADD2C419A999959FD2C5841CDCCCCCC65DD2C41CDCCCC0C002D58416666666662DD2C41CDCCCC0C022D5841CDCCCCCC63DD2C41CDCCCC4C022D58416666666607DD2C419A9999990C2D58419A999999F9DC2C41CDCCCC6C0D2D584166666666CCDC2C4100000020102D5841666666669FDC2C41CDCCCCCC122D58413333333372DC2C4100000080152D5841333333334BDC2C419A9999F9172D5841CDCCCCCC1EDC2C41CDCCCCCC1A2D584133333333F2DB2C41000000A01D2D5841CDCCCCCCC5DB2C419A999979202D58413333333399DB2C41CDCCCC4C232D58419A9999996CDB2C4100000020262D58410000000040DB2C41333333F3282D58419A99999913DB2C41666666C62B2D584133333333E7DA2C41000000A02E2D58419A999999BADA2C4133333373312D584166666666AFDA2C4166666686322D58413333333388DA2C419A999959362D5841CDCCCCCC11DA2C419A9999D9412D584100000000C9D92C41000000204C2D5841CDCCCCCCB8D92C41333333734E2D5841666666667DD92C41CDCCCC8C5A2D5841CDCCCCCC60D92C4100000060602D58416666666656D92C4166666686622D58416666666643D92C4166666686712D58410000000042D92C41CDCCCC0C732D5841333333333AD92C41666666067E2D5841	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	01010000206A080000CA363B0596E92C41CCCCCCDC3A2D5841	040210000	Z	Barras	0402100	04021	04	93	21
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	01010000206A080000DE022CC743AB2D4134333353FC1D5841	040220000	Z	Barrême	0402200	04022	04	93	37
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	01010000206A0800003803995436192D419A9999A94F465841	040230000	Z	Bayons	0402300	04023	04	93	126
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	01010000206A080000B3750D817F922D41CDCCCC3C183B5841	040240000	Z	Beaujeu	0402400	04024	04	93	46
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	01060000206A08000001000000010300000001000000B9010000CDCCCCCC35032E419A999919A63658416666666674032E419A9999D9AC36584100000000B3032E4166666626B1365841CDCCCCCC41042E419A999939B43658419A999999DD042E4166666646B53658416666666650052E4166666686B236584100000000C3052E41000000E0AE3658413333333365062E419A999939AD365841333333333E072E41000000A0A83658416666666615082E41333333F3A136584133333333B9082E419A9999B99F3658410000000027092E41CDCCCCECA13658410000000089092E41666666C6AB36584100000000090A2E4100000020B4365841666666666A0A2E419A999999B436584133333333260B2E419A9999F9B93658419A9999997D0B2E4166666606BB36584133333333FD0B2E41333333B3BE365841666666663E0C2E419A9999D9C136584100000000A80C2E419A999979CF36584100000000EC0C2E419A9999D9D536584166666666800D2E4100000080E5365841CDCCCCCCE90D2E41CDCCCC2CEE36584133333333CE0E2E41CDCCCCACFB36584133333333680F2E41333333D30037584133333333CC0F2E413333333303375841000000006C102E41CDCCCCCC013758413333333301112E41000000E0F83658419A999999DA112E41000000C0EA3658416666666625122E41000000E0E83658419A999999AD122E4133333333E83658416666666633132E41000000E0ED3658419A99999915142E41CDCCCCCCEB365841CDCCCCCCB6142E4100000020E43658410000000075152E41666666A6D436584100000000C2152E41CDCCCCACCC3658419A9999994C162E4100000020BC3658419A9999999E162E419A999979B636584166666666F6162E41CDCCCC0CAE36584133333333F0172E413333331391365841CDCCCCCC3F182E41000000008C365841CDCCCCCC99182E41666666268D3658410000000003192E41000000C09B3658419A9999994B192E41000000C09F365841CDCCCCCC5F1A2E41666666C68E36584133333333C91A2E41666666C68C365841000000005F1B2E41000000608B365841000000002B1C2E41666666E68B365841CDCCCCCC841C2E41000000A08A36584133333333E61C2E41CDCCCCCC8A36584100000000E91D2E41666666269636584133333333861E2E419A9999399C365841CDCCCCCCF81E2E413333333399365841CDCCCCCC601F2E41CDCCCCAC8D365841CDCCCCCCBE1F2E41000000A07E36584100000000DC1F2E41CDCCCCAC763658410000000034202E419A999919573658419A99999970202E41CDCCCC0C4336584133333333F8202E41666666A621365841666666660A212E410000002018365841CDCCCCCC2A212E4100000040133658416666666626212E41000000800E3658413333333350212E41000000600A365841333333332D212E41CDCCCC0C003658410000000037212E41CDCCCC0CF83558416666666693212E41333333F3ED35584100000000BE212E41CDCCCC8CE335584133333333EB212E419A9999F9DC355841CDCCCCCC7D222E4133333313CC35584100000000C6222E41CDCCCCECC6355841CDCCCCCC10232E4166666646BF3558410000000031232E419A9999F9B735584100000000B6232E419A9999D9AB355841333333330C242E4133333353AB3558419A99999948262E41333333B3373558419A999999C7262E41666666C621355841CDCCCCCCB6262E41333333B3353558419A999999CF262E41666666A63C355841666666661C272E419A9999594B3558419A99999997272E41000000A05A35584100000000F0272E410000004071355841CDCCCCCCE7272E41000000A0743558419A999999F4272E41666666A68C3558419A99999907282E41CDCCCC2C9F3558419A99999944282E41666666A6B035584133333333C1282E419A9999D9C135584100000000EA282E4133333373C1355841CDCCCCCC39292E41CDCCCC2CBE35584100000000352A2E41CDCCCC4CAC3558419A9999996E2A2E419A999999A635584166666666BB2A2E41666666069C3558419A999999102B2E419A9999F99435584166666666722B2E41000000A089355841CDCCCCCCB92B2E41333333737C35584133333333D62B2E41666666067935584100000000632C2E419A9999597035584133333333252D2E413333337365355841CDCCCCCC6E2D2E41000000C05F3558419A999999AC2D2E41CDCCCCAC583558419A999999CB2D2E419A9999B9503558419A999999D32D2E419A9999194835584100000000FB2D2E41CDCCCCCC3F35584133333333332E2E4166666686383558419A999999832E2E419A999999323558419A999999B62E2E41333333332A35584133333333802F2E41666666E635355841CDCCCCCCD92F2E41CDCCCC4C33355841000000000E312E419A999979223558419A99999965322E419A999919163558416666666670332E41CDCCCC0C0D355841CDCCCCCCC5342E41333333730235584133333333FE362E41CDCCCCECF2345841333333337F372E419A9999D9EA345841333333336B382E41333333D3D53458410000000053392E41CDCCCC8CBA3458419A9999990F3A2E4100000020A93458419A999999ED3B2E4166666666753458419A999999E63B2E41CDCCCCCC6D34584133333333273C2E419A99995969345841CDCCCCCC6E3C2E41666666466B34584166666666283D2E41CDCCCC4C673458419A999999353D2E41333333535D345841CDCCCCCC813D2E41666666265E34584166666666EA3D2E41000000805A345841CDCCCCCC243E2E41333333D356345841000000008A3E2E41333333B357345841CDCCCCCCCF3E2E41333333D353345841000000002A3F2E41CDCCCCCC4C34584100000000653F2E41000000E04A345841000000003F412E419A99993944345841CDCCCCCCF7412E41CDCCCC8C39345841CDCCCCCC14432E4133333353273458419A9999996F432E419A9999D91134584100000000CF432E419A9999B9F9335841CDCCCCCC04442E419A9999D9E9335841000000007E442E4133333373D2335841CDCCCCCCB8442E41666666A6BF3358416666666610452E4133333353A03358419A999999B9452E4133333373793358413333333370462E41333333335B3358419A999999CB462E41000000604D3358419A9999993B472E413333339344335841CDCCCCCCCB472E419A9999B93E335841CDCCCCCCC4482E41CDCCCCEC33335841333333337F492E419A99999928335841CDCCCCCCC4492E41333333D32333584166666666054A2E41000000A01D33584100000000E34A2E416666662613335841CDCCCCCCA94B2E41CDCCCC2C05335841CDCCCCCCF44B2E4100000020073358419A9999990A4D2E41CDCCCC0CF6325841666666669E4E2E41CDCCCC0CE032584166666666024F2E41333333538432584166666666DA4E2E419A999959843258419A9999992C4E2E41CDCCCC8C8C325841CDCCCCCCE44D2E41333333538C325841CDCCCCCC804D2E4100000000883258419A9999995D4D2E41333333D38432584100000000EA4C2E41000000A0833258419A999999534C2E419A9999797C3258419A999999E64B2E41000000207B32584166666666704B2E41333333337D32584133333333F74A2E41000000E07D32584166666666BF4A2E419A9999F97C325841CDCCCCCC7A4A2E419A99991979325841333333330B4A2E41000000A07432584100000000C2492E41000000A0703258419A9999998B492E4133333393703258416666666608492E419A9999797432584100000000DB482E410000000074325841CDCCCCCCBD482E419A99995970325841000000007E482E41CDCCCC4C71325841333333331D482E41000000406F32584166666666AF472E4166666606693258413333333347472E419A9999B961325841CDCCCCCCFC462E41666666C659325841000000009F462E419A99999954325841CDCCCCCC65462E4100000080563258419A99999944462E416666666655325841CDCCCCCC0F462E41CDCCCC4C5032584100000000B8452E4166666626513258416666666661452E419A9999F94D325841333333332C452E419A9999594932584100000000DA442E41CDCCCCAC443258413333333395442E41000000C04332584133333333CF432E4133333373443258419A9999997F432E41666666864332584133333333DB422E4133333373433258413333333343422E41CDCCCC8C3C3258410000000016422E419A9999393832584100000000EF412E41333333D3303258416666666686412E41666666262B325841CDCCCCCC7E412E410000002028325841CDCCCCCC41412E41333333532332584100000000B5402E41333333F31A3258419A9999998D402E41CDCCCC2C1A325841CDCCCCCC41402E41CDCCCCEC2132584100000000F93F2E41666666C62332584100000000B13F2E41CDCCCCAC23325841000000007B3F2E41CDCCCC0C20325841333333333E3F2E41000000E01F32584133333333EF3E2E419A9999992832584166666666C23E2E413333337329325841666666663E3E2E41CDCCCCEC283258419A999999F33D2E41666666C62E325841CDCCCCCCC13D2E41000000202E325841000000009A3D2E410000008026325841CDCCCCCC9E3D2E419A9999991E325841CDCCCCCCD73D2E419A9999191632584166666666E43D2E410000002012325841000000002A3E2E41000000400B325841CDCCCCCC303E2E41CDCCCC6C073258419A999999F53D2E41CDCCCC0CFF315841666666668D3D2E419A999919ED31584100000000633D2E419A9999F9DC315841CDCCCCCCE43C2E41333333F3D431584133333333013D2E4100000000CC3158419A999999F03C2E4166666606C3315841CDCCCCCCF23C2E4100000040B93158419A999999DB3C2E419A9999D9B53158419A999999473C2E4166666686B2315841CDCCCCCC1F3C2E41CDCCCC4CAE3158419A999999013C2E4133333333AE3158419A999999DD3B2E41666666E6B331584100000000B43B2E41333333D3B3315841000000004C3B2E4100000060AC315841CDCCCCCC203B2E41CDCCCCACAE31584100000000DE3A2E41CDCCCC2CAE3158419A999999713A2E419A999959B331584133333333393A2E4133333373B231584133333333FB392E4166666626BB31584100000000AD392E41CDCCCC8CBC315841CDCCCCCC36392E419A999959BD315841666666660D392E4133333353C3315841CDCCCCCCE0382E419A999979C43158419A99999997382E4166666646CE315841CDCCCCCC4D382E4100000060CE31584133333333ED372E4166666606CD31584133333333C7372E4100000080CE3158419A99999981372E41000000A0DD3158419A9999995B372E41CDCCCC2CDE315841CDCCCCCCD1362E41CDCCCCECDA3158410000000088362E4166666646DB315841666666665F362E41333333B3DD3158416666666626362E4100000020DE31584100000000DF352E41CDCCCCCCE831584166666666D9352E41CDCCCC4CEC315841CDCCCCCCA5352E41666666A6ED3158416666666678352E41333333B3EC315841CDCCCCCC12352E4133333313F031584166666666E4342E41333333F3EB315841666666662E342E41CDCCCC8CEE31584133333333D5332E4100000080EC315841CDCCCCCC82332E41CDCCCCCCEF3158416666666663332E41CDCCCC8CF43158419A9999990A332E41333333D3FC3158419A999999DE322E41CDCCCCACFF315841CDCCCCCC99322E41CDCCCC6C003258419A99999966322E41CDCCCC0C0B3258416666666637322E41CDCCCCCC093258419A99999909322E41CDCCCC0C0B3258413333333389312E419A9999D9073258419A99999959312E413333337307325841CDCCCCCC40312E41CDCCCCEC0B325841CDCCCCCC34312E41000000C014325841CDCCCCCC21312E41333333331632584133333333F0302E419A9999F91332584100000000BD302E41CDCCCCEC16325841CDCCCCCCA8302E41CDCCCC2C1B325841CDCCCCCC6F302E419A9999191E32584166666666E32F2E41333333F31A325841CDCCCCCCCE2F2E419A99993918325841CDCCCCCC9E2F2E419A99997917325841CDCCCCCC5B2F2E41666666062132584166666666032F2E41666666E629325841000000009D2E2E41CDCCCCEC2F3258419A999999452E2E41CDCCCC8C303258419A9999990F2E2E413333339333325841CDCCCCCCDD2D2E41333333533432584133333333AB2D2E419A9999D930325841CDCCCCCC7A2D2E419A999959343258419A999999452D2E41CDCCCCCC3A3258419A999999CC2C2E41000000403A32584100000000782C2E41666666C633325841CDCCCCCC252C2E419A9999F93332584133333333CD2B2E41000000E02F325841CDCCCCCCA12B2E41CDCCCCEC2F32584166666666772B2E41CDCCCCCC34325841CDCCCCCCD82A2E41CDCCCC6C37325841333333337D2A2E41000000403C325841CDCCCCCC602A2E41333333333B32584100000000392A2E41333333F33D325841CDCCCCCCDE292E410000000041325841CDCCCCCC9C292E4166666666403258416666666683292E41333333733E325841333333333D292E419A9999F9413258413333333308292E41333333D3403258419A999999DA282E410000002046325841333333336D282E4166666626483258419A99999954282E419A99999943325841000000000B282E41000000003E3258419A999999DC272E41333333533C3258416666666687272E41CDCCCC8C35325841CDCCCCCC65272E419A99991935325841CDCCCCCC21272E41CDCCCC8C3A32584133333333EA262E41666666063B3258419A99999977262E419A9999F93D3258416666666632262E419A9999194232584166666666FC252E419A9999994232584166666666AB252E416666660648325841CDCCCCCC61252E41000000C044325841CDCCCCCC43252E419A999999403258419A999999E1242E4100000040473258419A999999B4242E41333333B34B325841CDCCCCCCA1242E410000006055325841CDCCCCCC65242E41666666665C3258419A999999D4232E41CDCCCC6C54325841000000008D232E4133333353553258419A9999996E232E41333333D3573258416666666606232E41333333D36B325841000000009A222E419A9999397C3258410000000051222E41CDCCCCAC8032584133333333BF212E419A9999797F3258419A999999A5212E419A9999F98A325841333333338E212E41000000808D3258419A99999900212E41000000208E3258419A999999AB202E41000000E098325841333333332D202E4166666606A0325841CDCCCCCCEE1F2E4100000080A13258419A999999A21F2E4133333333B33258419A999999801F2E4166666626B73258419A999999631F2E4133333313BF3258419A9999993E1F2E41CDCCCC8CC232584166666666FE1E2E41CDCCCCCCBE3258419A9999998F1E2E4100000080C83258419A999999701E2E419A9999F9D0325841333333336C1E2E41CDCCCC0CD9325841333333334F1E2E41CDCCCC8CE632584166666666161E2E419A9999F9EF325841CDCCCCCCCD1D2E4100000060EF32584100000000EF1C2E41CDCCCC2CE732584100000000591C2E41000000C0D6325841CDCCCCCC041C2E41666666C6C532584166666666021C2E41CDCCCC4CB832584133333333E61B2E419A999979A832584100000000A01B2E41666666469B32584166666666731B2E41333333B38932584166666666081B2E41333333739132584133333333FC1A2E41333333539732584166666666DA1A2E41333333F39932584100000000991A2E41CDCCCCEC9B32584166666666101A2E4133333333AA3258419A999999CD192E419A9999D9B23258413333333395192E419A999999BE325841CDCCCCCC17192E419A999979DB3258419A999999D4182E41666666E6E43258410000000091182E419A999979E63258413333333352182E4166666666E43258419A9999999C172E41CDCCCC8CE0325841000000004E172E41CDCCCC4CE03258413333333320172E419A9999D9E132584100000000D8162E41333333B3E632584166666666F4152E41CDCCCC4CF13258410000000075152E41666666C6FB325841CDCCCCCC66152E413333333301335841CDCCCCCC2C152E41666666A60F3358419A9999990B152E419A9999F91333584133333333A3142E4100000060193358410000000009142E41000000E02533584166666666CF132E41666666A6293358419A99999968132E41666666C62D3358410000000097122E419A99995937335841333333333E122E41333333333933584100000000BA112E41666666463E3358416666666692112E419A999939413358419A9999995C112E416666660648335841CDCCCCCC2D112E41CDCCCC4C4B33584166666666D2102E41000000C0553358413333333385102E4133333393593358416666666610102E41CDCCCC6C5D33584133333333F10F2E4166666646603358419A999999C10F2E41CDCCCCEC6F33584166666666760F2E41333333F37333584133333333B20E2E419A9999197933584133333333680E2E41000000007633584166666666280E2E419A9999B97633584100000000920D2E419A9999B97633584166666666590D2E419A99999974335841CDCCCCCC7C0C2E41CDCCCC4C7A33584166666666E60B2E419A9999997D335841000000002F0B2E41666666467C3358419A999999BC0A2E41000000E07C335841CDCCCCCC5B0A2E41666666A6803358419A9999991D0A2E41000000C08533584100000000F0092E41000000C0873358419A999999B6092E41666666E687335841666666665B092E41CDCCCCAC8D335841CDCCCCCCF6082E41CDCCCC2C9033584166666666A5082E41000000E0943358419A9999996C082E41CDCCCC8C99335841CDCCCCCC2B082E419A9999D9A03358419A99999903082E4133333393A733584133333333FA072E4166666686B13358419A999999DC072E419A9999B9DF335841CDCCCCCC05082E4166666626F13358419A9999991B082E416666668607345841CDCCCCCC3B072E419A9999F91F3458416666666607072E4133333313223458419A999999C9062E41333333332234584133333333A2062E419A9999F92A3458410000000066062E416666664645345841CDCCCCCC79062E41666666C6723458419A9999992D062E410000004095345841CDCCCCCC38062E419A999939A43458410000000094062E419A999959B934584133333333D8062E4166666646C0345841CDCCCCCC36072E419A999979CB3458419A999999D2072E4133333333DB3458413333333305082E4133333313E5345841666666660A082E41CDCCCC0CEA34584166666666E3072E41CDCCCCACF63458419A9999993D072E419A9999D90E35584133333333E5062E41666666062435584100000000A6062E41333333F3473558416666666695062E41CDCCCC0C543558416666666600062E419A9999D9813558416666666631062E4100000040943558410000000065062E41666666E6AB355841666666666F062E41000000E0B73558416666666652062E4166666626C13558419A99999937062E4133333393D23558419A9999993B062E419A999939E8355841666666662B062E4100000080F93558419A9999990F062E41666666260B365841CDCCCCCCBD052E41666666C623365841CDCCCCCC7D052E4133333393313658416666666660052E419A9999193A3658419A9999999A042E4133333353593658410000000031042E416666662671365841CDCCCCCC35032E419A999919A6365841CDCCCCCC35032E419A999919A6365841	01010000206A080000E6652BA337222E419A99991959345841	040250000	Z	Beauvezer	0402500	04025	04	93	27
01060000206A0800000100000001030000000100000032030000CDCCCCCCE0342D419A999979B34C58419A999999E0342D4166666646B14C584133333333C3342D4133333393AD4C5841CDCCCCCCBE342D419A9999B9AC4C584133333333BC342D419A9999B9AB4C584166666666A3342D419A999979AA4C5841000000009D342D4166666646AA4C5841000000005F332D4100000060A24C584133333333BF322D41CDCCCC8CA24C58416666666683322D419A9999D9A34C584166666666E3312D4166666606A44C5841000000001B312D41000000409B4C58413333333367302D41333333F3984C5841CDCCCCCC0C302D41CDCCCC0C944C584133333333A82F2D41CDCCCCAC874C584133333333742F2D41CDCCCC8C7B4C584166666666382F2D41333333936D4C584133333333062F2D41000000E0694C584100000000492E2D41CDCCCC4C6F4C5841666666662F2E2D41000000806C4C584166666666162E2D41333333936A4C584166666666092E2D41000000E0694C584166666666D72D2D4100000040694C584166666666CA2D2D41333333D3684C5841000000009B2D2D41666666A6644C5841CDCCCCCC5D2D2D41CDCCCC8C604C58419A999999392D2D41000000805D4C584100000000E82C2D419A9999F9544C584166666666B82C2D4166666626504C584100000000772C2D419A999959484C58419A999999382C2D41CDCCCCAC404C5841333333330E2C2D41CDCCCC4C3C4C584166666666E02B2D41CDCCCCAC364C584100000000A52B2D419A9999D9304C58419A999999662B2D419A9999192C4C584166666666502B2D41666666E6294C584133333333252B2D4133333393244C584100000000E12A2D41000000C01C4C58419A999999CF2A2D41666666461B4C58419A999999CE2A2D419A9999991A4C584100000000CB2A2D41CDCCCC2C1A4C584133333333A12A2D41333333B3174C5841CDCCCCCC6C2A2D41000000E0144C5841CDCCCCCC5B2A2D41CDCCCC8C134C584166666666532A2D4166666606124C58419A9999993E2A2D41CDCCCC6C0C4C58410000000026292D4100000020F94B58419A9999998A282D4133333333ED4B58416666666673282D419A999959EC4B58410000000048282D4166666686EA4B58413333333328282D41CDCCCC0CEA4B58410000000008282D41CDCCCCECE94B584133333333E1272D4133333393E94B58419A999999BA272D41CDCCCC6CE94B58419A99999993272D41CDCCCCACE94B58410000000078272D4133333353EA4B5841666666665C272D4100000060EB4B58419A99999902272D4166666666ED4B584133333333C0262D4133333333EF4B58410000000099262D41666666E6EF4B58416666666671262D41CDCCCC6CF04B58416666666630262D41666666E6F04B584133333333FB252D41CDCCCCACF04B584166666666D4252D41CDCCCC6CF04B584100000000AF252D41666666A6EF4B5841000000008D252D4100000040EE4B5841CDCCCCCCD9232D41666666063A4C5841000000009C222D419A9999196E4C5841CDCCCCCCA2212D4166666606974C584166666666DD202D4133333373BB4C5841CDCCCCCC66202D4133333313CD4C58419A999999FC1E2D41CDCCCCCC744D5841CDCCCCCCB71E2D419A999919854D5841CDCCCCCC4C1E2D41000000C08D4D5841000000004C1E2D419A9999F98F4D584100000000F51D2D41333333D3A34D584166666666E81D2D419A999939B04D5841CDCCCCCCDF1D2D41CDCCCC2CD14D5841CDCCCCCCE11D2D419A9999D9D84D58419A999999E61D2D41CDCCCC6CDF4D584133333333011E2D419A9999B9E64D584166666666C91D2D41333333D3EE4D584133333333A91D2D4166666686F54D584100000000A11D2D41333333F3FA4D5841333333339A1D2D41CDCCCC6CFF4D5841CDCCCCCC8D1D2D41666666C60A4E5841000000007E1D2D41CDCCCC2C134E584100000000561D2D41666666C61B4E5841333333331E1D2D4100000080224E58419A999999EF1C2D41333333B3284E58419A999999D81C2D41CDCCCC6C304E5841000000009E1C2D41333333B3394E5841333333338C1C2D419A999939404E584100000000871C2D41CDCCCC0C424E584133333333731C2D41333333D3424E58419A9999995A1C2D41666666C6434E5841CDCCCCCC261C2D41CDCCCCEC464E58419A999999001C2D419A9999194D4E584133333333C51B2D419A999939544E584166666666921B2D419A9999595D4E5841CDCCCCCC741B2D4133333353644E584166666666421B2D41333333D36B4E5841333333330A1B2D41000000A06A4E584166666666EF1A2D41CDCCCC8C6C4E584133333333D61A2D41333333336E4E584166666666AD1A2D41333333B36F4E5841CDCCCCCC741A2D419A999919744E58419A9999994C1A2D41CDCCCCCC764E58419A999999081A2D41333333937C4E584166666666DC192D4133333353804E584133333333CF192D41666666A6844E584100000000A8192D419A999979844E5841333333337F192D41000000C0844E58419A9999995C192D41CDCCCCAC884E58410000000025192D41CDCCCC2C8C4E584133333333F9182D41CDCCCCAC8D4E58419A999999DB182D41000000808D4E5841CDCCCCCCC4182D41CDCCCCEC8A4E5841666666669E182D41CDCCCC0C894E5841CDCCCCCC78182D419A9999798A4E58419A9999995E182D41666666468C4E58413333333354182D41CDCCCC6C8F4E5841666666663B182D4100000000914E5841000000002A182D4133333333924E58416666666610182D41000000E0954E584100000000FF172D4133333373974E5841CDCCCCCCF2172D4166666606974E584133333333E4172D419A999959994E5841CDCCCCCCEF172D41000000C09B4E58419A999999EE172D41666666269E4E58419A999999D3172D419A999919A04E5841CDCCCCCCB3172D41000000A0A24E584133333333A7172D4133333353A44E5841666666669D172D4133333353A64E5841000000008C172D41CDCCCCCCA74E58413333333374172D41666666C6A94E58416666666657172D4133333393AE4E58410000000042172D41333333F3B24E5841000000002E172D41CDCCCCECB54E58419A9999990B172D4166666686B74E584166666666EC162D41CDCCCCECB74E584166666666CF162D4100000020B94E584100000000B9162D419A999919BB4E5841CDCCCCCCAD162D419A9999D9BC4E5841CDCCCCCC95162D4133333313C14E58416666666687162D41CDCCCC0CC34E58413333333371162D419A999979C24E5841666666665A162D4133333353C14E58413333333336162D4166666626C14E5841CDCCCCCC16162D41666666C6C24E5841666666669F152D4166666626C94E58419A9999997F152D41666666A6CC4E58419A99999970152D41000000E0D14E58413333333375152D419A999999D74E58419A9999998E152D41333333D3DD4E5841CDCCCCCCBC152D41666666A6E34E5841CDCCCCCCC6152D41666666A6E74E584133333333BF152D419A999939F24E58419A999999B1152D41CDCCCC0CF64E5841333333338B152D4100000060FD4E5841CDCCCCCC88152D419A9999F9FF4E5841CDCCCCCC93152D4166666686014F584166666666AB152D41CDCCCC6C024F5841CDCCCCCCBB152D41333333F3024F584133333333C7152D41666666E6034F584133333333C8152D4100000060064F584100000000C0152D41CDCCCC2C0B4F584133333333BC152D4166666666104F5841CDCCCCCCB0152D4166666646144F5841CDCCCCCC9D152D419A999999184F5841CDCCCCCCA0152D41333333931B4F584166666666A7152D41333333B3224F58419A999999A0152D41CDCCCC4C294F5841CDCCCCCCA1152D4166666686334F5841666666669D152D41CDCCCC6C354F58413333333393152D419A9999B9364F5841CDCCCCCC70152D4100000040374F5841333333335D152D41333333F3374F5841CDCCCCCC50152D41CDCCCC6C394F5841CDCCCCCC4F152D41666666063B4F5841CDCCCCCC53152D41000000603D4F58419A99999960152D419A9999F93E4F58416666666681152D41CDCCCC6C424F58413333333396152D4133333393454F58419A99999997152D4166666626474F5841CDCCCCCC93152D41333333B3484F58410000000084152D41000000404A4F58419A99999961152D41000000204D4F58413333333355152D41CDCCCC2C504F58419A99999947152D419A999959564F58413333333350152D41333333F3584F5841CDCCCCCC66152D41000000805B4F5841CDCCCCCC6C152D41666666065E4F5841CDCCCCCC6B152D41CDCCCC2C5F4F5841333333336A152D4100000080634F58416666666654152D4100000060684F5841CDCCCCCC42152D41000000606C4F5841CDCCCCCC3A152D41CDCCCCEC714F5841CDCCCCCC2B152D419A9999B9744F5841333333331B152D4166666606784F5841666666661B152D41666666267B4F5841CDCCCCCC2D152D41333333937D4F58413333333365152D4100000020804F5841CDCCCCCC7F152D419A999939834F5841CDCCCCCC93152D4166666646894F58416666666698152D419A999939914F58419A999999C5152D419A9999D9964F584100000000D3152D419A9999B9984F584100000000E5152D41666666869C4F584100000000E5152D419A9999F99E4F58419A999999E4152D419A9999F9A34F584100000000EC152D419A999999A74F58419A999999FF152D4100000060AB4F5841CDCCCCCCFF152D41333333F3AD4F584100000000FA152D41CDCCCCCCB04F5841CDCCCCCCE5152D41000000E0B34F584133333333C4152D4133333333B74F58419A999999C3152D4166666626BA4F58413333333348132D41CDCCCC4CDA4F58419A9999994E122D41333333D3DC4F584133333333DB112D41333333D3DF4F58419A999999FE102D41666666E6DF4F584100000000820D2D41333333330C50584133333333610D2D4100000040125058419A9999997D0D2D41CDCCCC2C1250584100000000860D2D41666666661250584100000000930D2D41666666661350584133333333A10D2D419A99997918505841CDCCCCCC9F0D2D41000000E01B505841CDCCCCCCA40D2D41666666662050584166666666A50D2D419A99997924505841CDCCCCCC9E0D2D41666666A628505841666666669A0D2D41000000802F5058419A999999A40D2D41666666663550584133333333CB0D2D419A9999793A50584166666666E60D2D419A9999193E505841CDCCCCCC050E2D41666666A64050584100000000360E2D41000000804050584133333333670E2D41000000603D50584166666666790E2D41000000003D50584100000000950E2D41666666C63F50584100000000DA0E2D41CDCCCC0C4750584166666666000F2D41666666E64A50584166666666160F2D41000000404E50584166666666240F2D4100000000545058419A9999992A0F2D419A9999B95650584133333333420F2D419A9999D95F505841666666666D0F2D41333333936A50584133333333940F2D419A99995972505841CDCCCCCCAD0F2D41666666E677505841CDCCCCCCB80F2D41666666067850584133333333F20F2D41666666C67A5058410000000044102D41CDCCCC6C7D5058419A99999983102D41333333F37F5058413333333394102D4133333333815058419A999999A2102D4166666646835058419A999999A8102D41666666C6865058419A999999B1102D41000000E08C50584166666666AC102D4133333393925058419A999999B2102D419A99997997505841CDCCCCCCD5102D41CDCCCC6C9C5058419A999999EF102D419A9999799E505841CDCCCCCC06112D41333333739F5058410000000018112D41666666A6A25058419A9999991E112D41000000E0A35058416666666633112D4100000040A7505841CDCCCCCC4B112D4166666666A8505841333333335F112D419A999959A7505841666666666E112D41CDCCCC8CA4505841CDCCCCCC6C112D4100000000A1505841000000006F112D41000000009D505841CDCCCCCC7E112D41CDCCCCAC9B5058410000000098112D41333333739C50584166666666AA112D41666666669E505841CDCCCCCCAE112D41CDCCCC4C9F50584166666666B9112D419A9999B9A3505841CDCCCCCCCC112D419A999959A650584133333333E4112D419A9999F9A850584133333333F4112D419A999919AB5058419A99999900122D41333333D3AE50584133333333FA112D4166666626B3505841CDCCCCCCF1112D4133333373B650584100000000F0112D41CDCCCC4CBA5058416666666604122D41CDCCCCCCBD5058416666666611122D41CDCCCC6CBD505841CDCCCCCC57122D419A999999BD505841CDCCCCCC89122D41000000C0BD50584100000000B2122D419A999939BE505841CDCCCCCCA1122D419A999999C45058416666666685122D41CDCCCC0CCA5058416666666670122D419A9999B9CE5058419A9999995D122D4133333393D25058419A99999937122D419A999919D85058419A99999911122D4133333373DD5058419A999999F8112D41CDCCCC2CE150584166666666DF112D41CDCCCCACE25058419A999999C9112D419A9999D9E350584133333333AD112D41CDCCCCCCE6505841666666668F112D4100000080EA5058410000000070112D4133333353EE5058413333333352112D4133333313F1505841CDCCCCCC24112D4166666686F4505841CDCCCCCC14112D41CDCCCCECF650584133333333D8102D4100000000FD5058419A99999984102D41333333F30A5158419A99999923102D41333333F31551584166666666FD0F2D41666666A61E515841333333339E0F2D419A9999F9395158419A999999C50F2D419A9999F94251584133333333D50F2D419A99997948515841CDCCCCCCBF0F2D4133333333565158419A999999C10F2D41333333F3715158419A999999550F2D419A9999F9795158419A9999996B0E2D41CDCCCC4C955158419A9999999F0D2D419A9999D99C51584133333333D90C2D41333333B3C65158419A999999E40A2D41000000202A525841CDCCCCCC8F0A2D41333333B33252584100000000AF0A2D4166666686345258419A999999D20A2D419A999919355258419A999999070B2D41666666A63852584133333333340B2D41000000203B52584166666666860B2D41CDCCCC2C3E52584133333333BE0B2D41000000A042525841CDCCCCCC050C2D41CDCCCC0C48525841CDCCCCCC3C0C2D41CDCCCC8C47525841000000006F0C2D41333333F346525841333333339C0C2D41333333F34652584133333333D50C2D41000000A048525841CDCCCCCC140D2D41333333134B525841CDCCCCCC3B0D2D41666666864B52584166666666720D2D41666666464B525841CDCCCCCC9C0D2D41333333B34C5258419A999999BE0D2D41000000404F5258419A999999D10D2D419A9999995252584133333333E70D2D410000008057525841CDCCCCCCFB0D2D41333333935D52584100000000120E2D41CDCCCC2C605258419A999999390E2D41CDCCCC4C625258419A9999995F0E2D41333333736652584133333333780E2D4100000080695258419A999999930E2D419A9999D96A52584100000000AF0E2D419A9999F96952584100000000D10E2D41333333B36A5258419A999999DA0E2D419A9999796B52584133333333F50E2D41333333337552584166666666140F2D41666666268852584133333333510F2D41333333539352584166666666DD0F2D41CDCCCCAC9A525841333333331A102D419A999919A75258419A99999974102D4100000000AC52584100000000A7102D41CDCCCCACB452584133333333C5102D41666666E6B55258410000000009112D41CDCCCC8CB9525841666666662E112D4133333333BA5258413333333346112D419A999979BD5258413333333366112D4133333373C8525841666666667A112D41CDCCCC2CCC52584133333333B2112D419A9999D9CE5258419A999999E5112D41333333F3CD52584100000000E3112D4100000060CB52584133333333E4112D41666666C6C852584100000000F2112D419A999979C6525841CDCCCCCC0F122D4100000040C45258419A99999933122D4166666606C15258419A9999995A122D4166666606BE5258419A99999986122D41CDCCCCCCBA52584133333333AF122D4100000020B5525841CDCCCCCCD0122D4166666626B052584166666666D8122D4133333373A7525841CDCCCCCCD8122D419A999999A5525841CDCCCCCCC9122D41000000C09D525841CDCCCCCCA7122D419A99999994525841000000007F122D41CDCCCC2C8D5258410000000079122D41333333F3865258413333333389122D41000000A084525841CDCCCCCCA4122D41666666A68352584100000000D4122D4166666686835258419A999999F9122D4100000040825258410000000002132D41333333937F52584166666666FF122D41CDCCCC0C7C525841333333330C132D41CDCCCCCC765258416666666625132D419A999959735258419A9999995A132D41CDCCCC2C6D5258419A99999977132D4166666606675258419A99999988132D41666666C663525841CDCCCCCC97132D419A9999D95E525841666666669B132D41CDCCCC2C5A5258416666666694132D419A99995956525841666666665C132D41666666A64F5258419A99999956132D41666666664D525841CDCCCCCC5E132D41666666464A525841CDCCCCCC74132D4133333353485258413333333388132D41666666A64852584166666666A8132D41000000604A52584133333333BD132D41CDCCCC0C4B52584166666666DA132D41666666064B52584166666666F8132D41333333934A5258413333333313142D41333333534A525841333333332D142D41666666264A525841666666664C142D419A9999794B5258419A99999991142D419A9999794F525841CDCCCCCCA2142D413333331350525841CDCCCCCCB8142D413333335350525841CDCCCCCCC7142D41CDCCCC6C4F52584166666666D8142D41333333D34C5258419A999999D9142D41000000E049525841CDCCCCCCCC142D41CDCCCC4C4752584133333333C0142D419A9999994252584166666666BE142D41CDCCCC4C3E52584100000000C5142D4133333333385258419A999999DA142D41666666063052584166666666F7142D419A9999592C5258413333333313152D419A9999F92B525841CDCCCCCC2A152D41666666062E5258410000000044152D410000000032525841000000004A152D4166666646355258413333333346152D419A9999393C525841CDCCCCCC4E152D41000000A03E525841000000005E152D416666660640525841CDCCCCCC79152D41666666E64052584100000000AA152D419A9999D9415258419A999999E0152D41000000003F5258416666666615162D41000000803A5258413333333331162D419A99993936525841CDCCCCCC46162D4166666606305258410000000050162D419A9999D928525841CDCCCCCC5E162D41CDCCCCEC20525841CDCCCCCC55162D41666666461B525841666666663D162D419A99995916525841CDCCCCCC20162D41CDCCCC0C155258419A999999FC152D41000000001552584100000000D1152D41333333531652584100000000AA152D41CDCCCCCC15525841333333338F152D41CDCCCCCC135258413333333389152D419A999959135258416666666684152D41CDCCCC2C0F5258410000000095152D41333333130A52584100000000B1152D41000000200552584133333333CC152D4133333313015258419A999999F4152D4166666666FD515841CDCCCCCC19162D4100000000FD5158416666666633162D4166666646FF515841333333333C162D4100000080035258419A9999994D162D41CDCCCCCC075258410000000080162D41CDCCCC4C0A52584133333333AF162D41333333130C52584100000000F7162D41000000A00C525841CDCCCCCC41172D41CDCCCC4C0C5258410000000079172D41000000600A525841CDCCCCCCAF172D4166666606055258419A999999DB172D4100000060FC51584100000000D8172D41000000A0F551584133333333BE172D419A9999F9F0515841CDCCCCCCA0172D41666666A6EE5158413333333383172D4133333313EE515841CDCCCCCC69172D41333333B3EE5158413333333359172D41CDCCCC4CEE515841CDCCCCCC54172D4100000080EC515841666666666B172D41666666A6E75158419A9999998B172D41CDCCCCCCE35158419A99999998172D41666666A6DE515841CDCCCCCC87172D4100000080D7515841333333337A172D4100000060D05158419A99999981172D4133333333CC515841000000009F172D419A999939C75158419A999999CE172D41666666A6C05158419A999999EF172D41666666C6B951584100000000FF172D41666666C6B25158419A999999F8172D419A999959AE515841CDCCCCCCFF172D41CDCCCC0CAC5158416666666600182D419A9999D9AB5158410000000024182D4100000060A45158416666666639182D41666666669F5158419A9999993F182D41CDCCCC8C9A515841000000002A182D41CDCCCC8C94515841666666661E182D41CDCCCC4C8F515841CDCCCCCC24182D41000000608A5158416666666633182D41333333D3855158410000000047182D419A99991981515841333333334A182D4100000000805158416666666661182D419A999979785158413333333367182D41CDCCCC8C76515841333333336E182D4133333393715158410000000067182D4100000000675158413333333367182D41666666E65E515841CDCCCCCC63182D41666666E6565158413333333360182D41CDCCCC4C505158419A9999996C182D41CDCCCCCC4C5158419A9999996D182D41666666864C515841000000007E182D41666666E64A515841333333338B182D41666666064A5158419A99999997182D419A999939485158419A9999999A182D41CDCCCC4C45515841000000009A182D41333333F342515841CDCCCCCC92182D41666666863F5158416666666681182D41666666C63B5158416666666678182D41333333133B5158419A99999942182D4133333393385158419A99999938182D419A999979355158419A99999947182D416666660633515841CDCCCCCC7A182D419A99993931515841CDCCCCCC9E182D41000000C02E51584166666666C9182D41CDCCCC0C2A51584133333333FF182D41CDCCCC4C25515841666666660B192D41000000A021515841CDCCCCCC0A192D4133333373185158413333333312192D419A99999912515841CDCCCCCC14192D41CDCCCC2C10515841000000002F192D41CDCCCC4C0E515841666666663E192D41666666A60D5158413333333358192D41CDCCCCEC0C515841CDCCCCCC7E192D41000000400A515841CDCCCCCC8F192D41666666C60851584166666666B4192D41000000E00751584100000000D8192D4166666626085158419A999999DE192D419A9999590851584133333333FB192D41CDCCCC4C0951584166666666181A2D41000000200A51584100000000331A2D41333333730A515841CDCCCCCC491A2D41333333D3085158419A9999994F1A2D41666666A606515841333333334C1A2D41CDCCCC8CFF50584133333333581A2D419A9999B9FC50584100000000731A2D4133333393FB50584166666666A01A2D4166666666FA50584133333333BE1A2D4133333353F950584166666666E41A2D4166666686F850584133333333041B2D41000000A0F95058419A9999991E1B2D419A999979FA5058419A999999301B2D41000000C0FA5058419A9999994B1B2D41CDCCCCACFA50584133333333721B2D41CDCCCC4CF85058419A999999891B2D4133333353F650584166666666A81B2D41000000A0F55058419A999999C41B2D41CDCCCC2CF7505841CDCCCCCCD41B2D41666666E6F850584100000000E91B2D419A999959FB5058419A999999051C2D41666666A6FB505841000000000F1C2D41CDCCCCECFA50584100000000281C2D4133333373F850584166666666421C2D4166666646F65058419A999999511C2D4133333373F4505841000000005C1C2D41CDCCCC2CF350584133333333731C2D4133333333F050584166666666921C2D4166666686EC50584133333333AB1C2D419A999979E9505841CDCCCCCCC21C2D419A9999D9E750584133333333D51C2D419A999939E750584133333333E81C2D41000000E0E450584133333333E61C2D41CDCCCC8CE05058419A999999E21C2D419A9999D9D75058419A999999DF1C2D41CDCCCC6CD150584100000000E01C2D41CDCCCCACD0505841CDCCCCCCDF1C2D41333333D3CF5058419A999999E01C2D4133333393CF50584133333333F11C2D419A9999B9CA505841CDCCCCCC151D2D41CDCCCC0CC750584133333333701D2D41CDCCCC6CC35058419A999999DC1D2D4133333353C250584166666666071E2D4100000000C2505841000000002D1E2D41666666C6BF505841333333333A1E2D4166666666BB50584166666666451E2D41000000C0B5505841000000006C1E2D4100000000B1505841CDCCCCCCA11E2D419A999999AA50584166666666E61E2D419A9999B9A250584166666666071F2D41666666469F505841CDCCCCCC301F2D41333333739C5058419A999999571F2D41CDCCCC4C9C50584166666666771F2D419A9999599E505841000000009F1F2D4100000080A25058419A999999B71F2D4133333353A5505841CDCCCCCCDA1F2D41CDCCCC2CA65058419A99999902202D4166666606A55058410000000033202D41CDCCCCACA0505841CDCCCCCC65202D41000000009A5058419A999999A3202D41666666869450584166666666B1202D41000000608C50584100000000BC202D41666666668650584166666666DE202D41333333F3805058416666666601212D419A999959805058413333333328212D41000000607F505841CDCCCCCC4A212D41CDCCCC8C79505841333333336C212D419A9999D9715058410000000083212D41000000406C50584133333333A5212D410000008067505841CDCCCCCCB8212D413333339361505841666666669E212D41666666E6605058410000000094212D419A9999D95D50584166666666A1212D4133333353595058419A999999BE212D41000000E057505841CDCCCCCCED212D410000008056505841CDCCCCCC24222D419A9999F94E505841333333334F222D41333333F349505841CDCCCCCC72222D419A999979485058419A9999998F222D419A9999393F50584166666666C0222D419A9999D93150584166666666E9222D41666666062D5058416666666612232D419A9999F929505841CDCCCCCC2F232D41666666C627505841666666668A232D41333333532850584166666666EC232D41CDCCCCEC29505841333333331F242D419A9999F929505841666666664C242D41000000E0205058413333333344242D4133333373165058416666666649242D41000000A014505841333333335A242D419A9999790E5058419A999999A3242D41CDCCCCAC05505841CDCCCCCCE0242D41333333B301505841666666661E252D4166666646FD4F58416666666641252D41000000A0FA4F5841000000001F252D41333333F3E94F5841CDCCCCCC15252D41333333B3DE4F58419A99999912252D41CDCCCC0CD74F58419A9999992A252D41000000C0CC4F58413333333369252D4166666666BD4F58413333333370252D41333333B3BB4F5841333333339E252D4166666646A94F58419A999999C6252D4100000040A24F58419A999999F1252D41000000609E4F58413333333333262D41000000A0994F58413333333377262D41CDCCCC2C934F58416666666688262D41CDCCCC6C8A4F5841000000009A262D41CDCCCCEC804F5841CDCCCCCCC6262D41666666667A4F584133333333D9262D41CDCCCC0C704F5841CDCCCCCC06272D41CDCCCCAC6A4F58410000000044272D41CDCCCC2C654F58419A99999980272D419A9999D95B4F584100000000B5272D419A999959584F58419A9999990A282D41666666C6514F5841000000002D282D41333333B34D4F5841CDCCCCCC4E282D41CDCCCCAC494F5841666666669B282D419A9999F9434F584133333333B8282D41666666063E4F5841333333339C282D41CDCCCC0C374F58419A999999A2282D4100000000314F5841CDCCCCCCCC282D419A9999D92C4F58419A999999FC282D41000000C0294F58416666666623292D4133333373244F5841333333333E292D41333333D31C4F58413333333342292D419A999919184F5841333333335C292D41000000800F4F58416666666689292D419A999979064F584100000000B8292D419A999999004F58419A999999EC292D419A999979FF4E5841666666663A2A2D41000000E0FD4E58419A999999652A2D41CDCCCC6CFA4E58419A999999982A2D419A999919F44E584100000000E52A2D41000000E0E84E584133333333032B2D41CDCCCC2CE24E584166666666022B2D419A999939D94E58419A999999082B2D41000000E0CA4E5841CDCCCCCCEF2A2D41666666A6C44E5841CDCCCCCCE42A2D4166666666BB4E58419A999999F12A2D4166666666B54E584133333333F62A2D419A999939B24E5841CDCCCCCC0B2B2D41CDCCCC2CB04E584100000000592B2D41333333D3AF4E5841333333337C2B2D4166666606AE4E5841000000007D2B2D4166666626A84E5841333333337C2B2D4133333313A04E584100000000962B2D41666666C69A4E58419A999999A42B2D4166666686A74E5841CDCCCCCCD82B2D4100000060B24E5841CDCCCCCC172C2D419A9999F9A44E584133333333212C2D41333333F3A24E5841666666662C2C2D41CDCCCC2CA14E5841000000003B2C2D41000000A09F4E584133333333462C2D41CDCCCCAC9D4E584166666666512C2D419A9999599B4E58419A9999995A2C2D41000000E0984E5841666666665F2C2D4166666626974E58419A999999622C2D419A999919954E584166666666632C2D41666666C6924E5841666666666A2C2D4100000000904E584133333333722C2D419A9999998D4E584133333333792C2D41333333F38B4E5841CDCCCCCC882C2D41CDCCCCAC884E58419A999999962C2D4166666646864E584166666666A52C2D41333333F3834E584133333333AA2C2D4100000000834E58419A999999B62C2D4100000040804E58419A999999BF2C2D41CDCCCCEC7D4E584133333333C52C2D41333333337A4E584166666666C82C2D4133333373764E584133333333CC2C2D419A9999D9704E58419A999999D42C2D41666666E6694E584133333333D92C2D41000000C0674E58419A999999DF2C2D41333333F3654E584166666666E42C2D4100000000654E584166666666F32C2D419A999999634E584166666666042D2D41CDCCCC8C624E584166666666132D2D41CDCCCC0C624E584133333333362D2D41666666A6614E5841CDCCCCCC4C2D2D41333333B3614E58419A9999995C2D2D41000000E0614E58419A999999692D2D419A9999B9614E58419A999999762D2D41333333F3614E58419A999999822D2D419A999999624E58419A999999862D2D419A9999B9624E584133333333912D2D41CDCCCCCC624E5841CDCCCCCC992D2D41666666A6624E584100000000A22D2D41CDCCCC4C624E58419A999999A92D2D41000000C0614E584100000000C42D2D419A9999F95E4E584100000000F42D2D41CDCCCC8C5A4E584133333333062E2D41666666C6574E58419A999999272E2D41000000C0504E584133333333442E2D41000000C0464E58419A999999632E2D41000000E03E4E58419A999999742E2D4133333333354E584166666666782E2D41000000E0294E584133333333702E2D4133333313214E58419A9999996C2E2D41000000A01B4E58419A999999802E2D41333333F3184E584166666666882E2D41333333B3184E5841CDCCCCCCA12E2D419A9999F9174E584100000000BE2E2D4166666686164E5841CDCCCCCCCF2E2D4133333373144E58419A999999D82E2D4166666666134E5841CDCCCCCCD92E2D41666666C6114E584100000000DB2E2D41333333F30F4E58419A999999DC2E2D41000000200D4E5841CDCCCCCCEE2E2D4133333393064E584133333333052F2D41CDCCCC2C014E58419A9999990C2F2D41000000A0FE4D5841333333330A2F2D4100000080FC4D584133333333082F2D41CDCCCC0CF74D584166666666152F2D4166666646F44D584133333333462F2D41CDCCCC8CEF4D5841333333336A2F2D419A9999F9EB4D58419A9999997B2F2D419A9999B9EB4D584100000000BE2F2D41333333F3EC4D584133333333C92F2D41666666C6EC4D58419A999999D92F2D4133333353EB4D584100000000F42F2D41CDCCCCCCE74D58416666666608302D419A999999E34D5841CDCCCCCC0A302D4133333313E14D5841666666660B302D4133333313DB4D58419A9999990F302D4133333393D54D5841666666661B302D419A999999D24D58410000000025302D419A999939D04D58413333333320302D41000000E0CD4D58419A99999925302D4133333373CA4D58410000000030302D41666666E6C84D5841333333334C302D4100000020C74D58416666666657302D419A999939C54D5841CDCCCCCC63302D4166666666BF4D58419A9999996C302D41CDCCCC2CBB4D5841666666667D302D41000000E0B54D5841CDCCCCCC96302D41666666C6B04D584100000000AF302D41CDCCCC6CAE4D584100000000C3302D419A999979AC4D5841CDCCCCCCC9302D4100000080A64D584133333333CF302D41CDCCCC0C9F4D584100000000DB302D4100000080994D584100000000EA302D41000000A0914D584133333333F9302D41000000808D4D58413333333318312D4100000040894D58419A99999938312D4100000020834D58419A9999995C312D41666666867D4D5841666666667C312D41333333337A4D58419A9999997B312D41CDCCCCAC774D58419A99999979312D419A999979714D5841666666667A312D41333333336F4D58419A99999948312D41CDCCCCCC5F4D58419A99999939312D41CDCCCCEC5A4D5841CDCCCCCC35312D41000000C0574D58419A99999936312D4100000020534D58419A9999993E312D41CDCCCCCC4D4D584166666666B6312D41CDCCCC4C454D58410000000032322D41CDCCCC8C3D4D58419A99999931322D41CDCCCC4C374D58419A99999945322D4166666646374D5841333333334F322D4166666686334D58416666666604332D41CDCCCC6C294D5841CDCCCCCC29332D4166666686254D5841000000003A332D41000000601F4D5841CDCCCCCC43332D419A9999F9054D58419A99999978332D41CDCCCC6CF64C58419A9999999A332D41CDCCCCECF24C5841CDCCCCCC9D332D41CDCCCC0CF24C58419A9999999F332D4133333333F14C5841CDCCCCCCA4332D4166666626EC4C584166666666A9332D419A9999F9E94C58419A999999B3332D4166666686E74C584133333333CE332D41CDCCCC4CE24C584166666666EA332D41CDCCCC0CDC4C584133333333FB332D419A9999B9D74C5841CDCCCCCCFD332D41666666C6D64C58419A99999901342D419A999919D54C58416666666603342D4100000060D34C5841CDCCCCCC03342D4166666606CD4C58416666666603342D419A999979CC4C58416666666604342D41666666E6CB4C58410000000007342D4100000060CB4C5841000000000C342D41CDCCCCECCA4C58419A99999911342D41CDCCCCCCCA4C5841CDCCCCCC38342D41000000A0CB4C5841CDCCCCCC3D342D41666666A6CB4C58410000000049342D419A999959CB4C58416666666653342D41000000A0CA4C5841CDCCCCCC59342D41666666C6C94C5841333333335F342D4100000060C84C5841CDCCCCCC60342D41CDCCCC4CC74C58419A9999995F342D41333333F3C54C58416666666660342D4166666646C34C58419A99999963342D41CDCCCCECC14C58419A99999968342D41CDCCCCACC04C58419A9999996E342D41000000C0BF4C58410000000077342D419A9999D9BE4C58419A9999999A342D419A999919BC4C5841CDCCCCCC9F342D41666666C6BB4C584166666666A8342D41CDCCCCACBB4C584133333333C2342D4100000000B74C5841CDCCCCCCE0342D419A999979B34C5841	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	01010000206A0800002677D0DF711E2D41000000F05C4F5841	040260000	Z	Bellaffaire	0402600	04026	04	93	13
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	01010000206A080000DCEE316647622C413333339344355841	040270000	Z	Bevons	0402700	04027	04	93	11
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	01010000206A080000D1A7E07C314D2D41343333333E215841	040280000	Z	Beynes	0402800	04028	04	93	41
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	01010000206A080000B44B382C969E2D419A9999A96F165841	040300000	Z	Blieux	0403000	04030	04	93	58
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	01010000206A0800008BE79A55E8072D41CDCCCC1C2E1B5841	040310000	Z	Bras-d'Asse	0403100	04031	04	93	26
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