SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep05;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep05 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep05','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep05','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep05','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep05"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000E6DAC23AAEEE2E41666666E6B1795841	050010000	Z	Abriès-Ristolas	0500100	05001	05	93	161
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	01010000206A08000030C74DA3D0B52E41CDCCCCBC827A5841	050030000	Z	Aiguilles	0500300	05003	05	93	41
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	01010000206A080000B03B6132442C2D41333333E383665841	050040000	Z	Ancelle	0500400	05004	05	93	51
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	01010000206A08000047D741DAB4C22D41CDCCCC5C1A795841	050060000	Z	L'Argentière-la-Bessée	0500600	05006	05	93	65
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	01010000206A0800001E7D601EE85D2E4100000000A4775841	050070000	Z	Arvieux	0500700	05007	05	93	73
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	01010000206A08000038F94D606CF32B41666666A65B575841	050080000	Z	Aspremont	0500800	05008	05	93	19
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	01010000206A08000056227DCFCD962C419A999999ED7A5841	050090000	Z	Aspres-lès-Corps	0500900	05009	05	93	17
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	01010000206A08000008081EE91A1D2C419A9999C9C45E5841	050100000	Z	Aspres-sur-Buëch	0501000	05010	05	93	43
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	01010000206A080000AB263C60D2182D41CDCCCCDC435D5841	050110000	Z	Avançon	0501100	05011	05	93	22
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	01010000206A0800007BA2C57E0DDC2D4166666616FB5A5841	050120000	Z	Baratier	0501200	05012	05	93	16
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	01010000206A0800001899E249516B2C41CDCCCCFC5D515841	050130000	Z	Barcillonnette	0501300	05013	05	93	20
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	01010000206A080000EEF82D1506FD2B41000000E0013E5841	050140000	Z	Barret-sur-Méouge	0501400	05014	05	93	26
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	01010000206A08000030CEF2FAC40B2C41CDCCCC0C6D535841	050160000	Z	La Bâtie-Montsaléon	0501600	05016	05	93	15
01060000206A08000001000000010300000001000000BC0500000000000053032D416666660629635841000000005C032D41666666E62A635841CDCCCCCC5F032D41333333B32C6358419A9999995C032D41333333132E635841666666665E032D419A9999F92E635841CDCCCCCC6B032D419A9999B9306358419A99999976032D419A999939336358413333333381032D41000000C0346358416666666692032D419A9999F93463584100000000AE032D416666660635635841CDCCCCCCB9032D41000000003563584100000000C4032D419A9999793563584100000000CE032D419A9999B93763584100000000E0032D41CDCCCCCC3763584100000000F4032D41333333933863584166666666FE032D41000000A0396358419A99999902042D419A9999793A635841CDCCCCCC08042D41666666463F6358410000000008042D41666666A6406358410000000005042D41000000004263584100000000DE032D41CDCCCCCC446358419A999999D7032D410000004045635841CDCCCCCCCD032D41666666E6456358419A999999BE032D41CDCCCC6C4863584133333333B6032D41CDCCCC0C4A635841CDCCCCCCB0032D41CDCCCC2C4B63584100000000AC032D41666666464E635841CDCCCCCCA7032D41000000404F63584100000000A5032D41333333B34F63584100000000A7032D41CDCCCCAC50635841CDCCCCCCAB032D41333333735263584133333333AF032D41000000205463584133333333AF032D41666666E655635841CDCCCCCCAD032D419A9999195863584166666666B1032D419A9999F95963584133333333B8032D41000000805C635841CDCCCCCCB5032D41666666E65F63584166666666B4032D41CDCCCC0C616358419A999999B4032D41CDCCCCCC62635841CDCCCCCCB8032D41CDCCCCAC6463584133333333B8032D419A9999B9686358419A999999B6032D41333333136A63584100000000B5032D41666666866B63584166666666B6032D41000000806D63584100000000B9032D41CDCCCCEC6F635841CDCCCCCCB8032D419A9999797163584166666666BB032D41333333737263584166666666C8032D4133333333746358419A999999DC032D41000000807663584166666666E4032D41000000A0776358419A999999EB032D410000008079635841CDCCCCCCF1032D41000000C07C6358419A999999F7032D41CDCCCCEC7D635841CDCCCCCC04042D41333333D37E635841000000001A042D41333333D37F635841333333332B042D41000000A0816358413333333334042D419A999919836358410000000042042D419A999979846358419A9999994F042D4133333353876358413333333358042D419A99993989635841CDCCCCCC60042D41000000808B635841CDCCCCCC6B042D419A9999B98D6358410000000080042D410000002090635841666666668F042D41000000C09163584166666666B8042D419A9999599263584133333333C6042D41CDCCCC6C926358419A999999CB042D419A99991993635841CDCCCCCCD1042D41000000809463584100000000D7042D41CDCCCC8C9663584133333333D4042D41666666A69763584166666666D3042D419A9999399863584100000000D5042D41000000009963584133333333D8042D41000000009A63584100000000DB042D41333333539B6358419A999999DF042D41666666269C63584166666666E5042D41CDCCCC0C9D635841CDCCCCCCED042D41333333139F63584133333333F0042D41000000A0A063584133333333F4042D4100000040A163584100000000FA042D41CDCCCC6CA26358410000000010052D419A9999D9A56358416666666613052D4166666686A66358410000000016052D419A999999A7635841CDCCCCCC13052D419A999959A86358419A99999908052D4166666646AB6358413333333308052D4133333353AC635841CDCCCCCC15052D419A999919B06358413333333328052D41CDCCCCECB1635841CDCCCCCC58052D419A999939B4635841CDCCCCCC67052D4166666686B5635841CDCCCCCC6F052D4133333373B6635841CDCCCCCC7D052D4166666666B7635841666666668B052D41000000C0B76358419A999999A3052D41666666A6BA635841CDCCCCCCBB052D419A999919BF635841CDCCCCCC47062D41CDCCCC4CCF6358419A99999979062D419A999939CF635841000000004A072D4166666686B8635841CDCCCCCC71072D4100000080B8635841000000005E092D41CDCCCCACDD635841000000007C092D41666666A6DD6358410000000087092D41000000E0D763584133333333A2092D4100000060D26358419A999999C3092D4166666686CD63584133333333E2092D41666666A6CB635841CDCCCCCCF4092D41000000A0CA6358419A999999F9092D41000000A0C9635841333333330B0A2D41CDCCCC6CC663584166666666140A2D41CDCCCCCCC5635841000000002B0A2D419A999959C563584100000000380A2D419A999979C4635841CDCCCCCC530A2D41CDCCCC0CC263584133333333620A2D41CDCCCC4CC16358419A9999997A0A2D41666666E6BF635841666666668C0A2D4166666606BF63584100000000A80A2D4166666686BC63584133333333B40A2D419A9999B9BB6358419A999999CF0A2D4100000000BA635841CDCCCCCCDD0A2D41000000A0BA635841CDCCCCCCE40A2D4133333313BA635841000000000D0B2D41CDCCCC2CB76358419A999999170B2D41CDCCCC4CB7635841CDCCCCCC220B2D41333333B3B763584166666666360B2D41666666C6B6635841CDCCCCCC430B2D41CDCCCC4CB763584166666666510B2D4166666666B76358419A9999995E0B2D4166666626B6635841CDCCCCCC640B2D4166666626B5635841666666666C0B2D4166666646B4635841666666666F0B2D419A999959B363584133333333780B2D41000000C0AF635841333333337A0B2D41CDCCCC6CAE6358419A999999210C2D419A999979A763584100000000970C2D41666666A6A2635841666666669B0C2D4166666626A1635841CDCCCCCCB40C2D41CDCCCC0C9F63584100000000BF0C2D41666666C69D635841CDCCCCCCCB0C2D419A9999199A63584100000000D00C2D41000000209763584133333333D30C2D419A9999399463584166666666D60C2D419A99999990635841CDCCCCCCDB0C2D41333333B38D635841CDCCCCCCDF0C2D41CDCCCC6C8C63584133333333E30C2D41000000808B635841CDCCCCCCEB0C2D41CDCCCCAC8A6358419A999999010D2D41333333738863584166666666180D2D419A9999F97D6358419A999999520F2D41666666E66B6358413333333324102D41CDCCCCCC6A6358410000000032102D4100000040686358419A9999993B102D41000000A0666358413333333345102D41CDCCCC4C66635841CDCCCCCC4F102D410000006066635841333333335E102D413333335366635841000000006A102D41CDCCCC8C65635841333333337E102D41CDCCCC0C656358419A999999B1102D41333333B36263584100000000CC102D41000000E06263584166666666D8102D419A99999963635841000000001D112D41666666265A63584133333333E2112D4100000000556358413333333316122D41666666A6536358416666666655122D41CDCCCC2C516358413333333349152D41CDCCCCCC33635841666666669C162D41333333B32A6358413333333396172D41CDCCCC2C2D63584100000000431B2D41000000A04663584133333333B51C2D419A9999794C63584100000000881D2D41333333D35363584166666666971E2D41333333F35A6358419A999999231F2D419A9999395D635841CDCCCCCC3F1F2D41000000C05E635841CDCCCCCC26212D41333333336B635841000000009C212D41000000006D6358410000000083222D4133333313726358419A999999BB222D419A999959746358416666666664232D41333333D376635841CDCCCCCC8F242D41000000407F63584166666666A5242D419A9999D97F6358419A999999EC242D41666666A680635841666666661F252D419A99993981635841CDCCCCCC86262D419A9999B98F6358413333333352282D41CDCCCCECA26358419A9999991A292D4133333373AB6358419A999999792A2D41000000A0B9635841CDCCCCCCE32A2D41333333F3BD635841CDCCCCCCEC2A2D41CDCCCC4CBE635841CDCCCCCCEC2A2D4100000000BF63584100000000EF2A2D41CDCCCCCCBF635841CDCCCCCCF12A2D419A999919C063584166666666F82A2D4166666686C06358419A999999142B2D41666666C6C063584100000000322B2D4133333333C163584133333333472B2D4100000000C263584100000000652B2D4100000080C463584133333333942B2D4166666646C963584133333333AA2B2D41666666A6CA63584166666666E82B2D419A9999B9CD635841333333331A2C2D4133333353D0635841666666662D2C2D41CDCCCCCCD063584100000000512C2D4100000020D16358419A9999997E2C2D41666666C6D16358419A9999998F2C2D41CDCCCCACD163584100000000A42C2D41CDCCCC0CD16358419A9999998C2D2D41666666C6DB63584100000000792E2D41CDCCCCACE663584166666666AE2E2D41CDCCCCECEA6358419A999999B32E2D419A999959EB6358419A999999CA2E2D4166666686EF63584100000000EF2E2D4166666606F363584100000000192F2D419A999979F7635841CDCCCCCC502F2D4166666666FB63584166666666782F2D4166666646FE63584133333333B22F2D41000000E003645841CDCCCCCCEA2F2D413333331308645841CDCCCCCC09302D41CDCCCC6C096458410000000034302D41333333730A645841CDCCCCCC50302D41666666C60B645841333333336E302D41000000E00E645841000000008D302D410000006012645841000000009A302D41CDCCCC8C13645841CDCCCCCC9F302D41CDCCCCCC1364584133333333A3302D41000000001464584100000000D4302D41333333131364584133333333F2302D4133333373136458416666666625312D413333335316645841333333334E312D41666666C6186458416666666683312D41333333531B6458419A999999C4312D419A9999791D6458419A999999F4312D41666666061E6458419A99999927322D41CDCCCC8C1E645841CDCCCCCC47322D419A9999791D645841000000005D322D41333333B31C645841CDCCCCCC65322D41000000A01C6458416666666667322D41000000A01C6458419A99999974322D41000000A01C645841CDCCCCCC7C322D419A9999591C645841CDCCCCCC97322D41CDCCCCCC1D6458419A9999999F322D41000000A01D645841CDCCCCCCA7322D419A9999991D64584166666666B0322D419A9999791D64584133333333B9322D41CDCCCC8C1D6458419A999999C1322D41666666861D64584166666666CA322D41000000801D64584166666666D2322D41333333531D645841CDCCCCCCDC322D41000000401D6458419A999999E6322D41CDCCCCEC1C64584166666666EF322D41000000E01C64584133333333F9322D41333333D31C6458413333333302332D41000000201D645841333333330B332D41666666861D6458410000000016332D41CDCCCCAC1D6458419A9999991F332D41666666C61D6458419A99999927332D419A9999D91D6458410000000030332D41000000E01D645841666666663B332D41000000C01D6458410000000044332D41CDCCCC6C1D645841CDCCCCCC4B332D41333333131D6458419A99999952332D419A9999791C6458419A9999995C332D41CDCCCCEC1B6458419A99999964332D419A9999B91B645841CDCCCCCC6C332D419A9999791B645841CDCCCCCC72332D41666666A61A6458419A99999975332D413333339319645841333333337B332D41CDCCCCCC18645841CDCCCCCC80332D41CDCCCC0C186458413333333388332D41666666A617645841CDCCCCCC90332D41000000C0166458416666666699332D419A9999591664584133333333A4332D419A9999791664584133333333AD332D4133333393166458419A999999B6332D41000000001764584166666666BE332D4166666666176458419A999999C7332D41000000C01764584166666666D1332D41CDCCCCEC17645841CDCCCCCCDA332D41666666061864584166666666E3332D419A9999D91764584133333333EC332D41333333D31764584166666666F5332D41333333B3176458416666666603342D4166666626176458416666666616342D41000000A016645841333333332A342D41000000E0166458410000000039342D419A9999B9176458410000000056342D419A9999F917645841666666665C342D416666668617645841CDCCCCCC64342D4133333393166458413333333372342D419A99991916645841333333337B342D419A9999D915645841CDCCCCCC90342D41CDCCCC8C156458419A999999A1342D419A9999191564584133333333B4342D41666666E614645841CDCCCCCCC5342D41000000C0156458419A999999DD342D41333333B3166458419A999999F1342D41CDCCCC8C1664584133333333FC342D419A9999D9156458416666666608352D4133333393146458413333333314352D419A999919146458416666666628352D41CDCCCCEC13645841CDCCCCCC39352D419A9999B9126458413333333346352D41000000C0116458413333333351352D413333333312645841CDCCCCCC5A352D413333337313645841333333336D352D41333333B314645841CDCCCCCC7E352D413333337315645841CDCCCCCC87352D4166666686156458419A99999992352D419A99993915645841000000009B352D41666666661464584100000000A8352D41000000001464584166666666B8352D416666668614645841CDCCCCCCC5352D41000000C015645841CDCCCCCCCA352D41CDCCCCEC1664584133333333CF352D41666666A61764584133333333E1352D41CDCCCC4C176458419A999999F5352D41000000E0156458419A99999907362D41CDCCCCCC166458413333333314362D41333333B3156458419A99999921362D4133333353166458413333333331362D4166666606186458416666666640362D41000000001A645841666666663F362D419A9999391C6458419A9999994D362D419A9999F91E6458413333333355362D4133333393216458419A9999995C362D419A999979236458416666666666362D4133333393246458413333333376362D416666666625645841CDCCCCCC82362D4100000080256458410000000093362D41000000802464584133333333AE362D419A9999B92464584100000000C3362D41000000C02464584133333333DA362D41333333D32564584133333333F3362D413333335327645841333333330D372D41CDCCCCAC29645841000000001E372D41CDCCCCAC2A645841333333332E372D419A9999192A645841000000003D372D416666664629645841CDCCCCCC4D372D419A9999B9286458413333333365372D41CDCCCC8C286458413333333377372D4100000040296458410000000088372D41CDCCCC2C2A6458410000000099372D41CDCCCC2C2C645841CDCCCCCC9F372D419A9999792D64584166666666A6372D419A9999792E64584100000000AD372D413333337330645841CDCCCCCCB7372D419A9999793164584133333333CC372D41333333333264584100000000E4372D419A9999F932645841CDCCCCCCED372D41000000403564584133333333F1372D4100000020376458419A999999F2372D41CDCCCCCC396458419A999999F9372D41000000803B645841CDCCCCCC05382D41000000A03D645841CDCCCCCC13382D41CDCCCC0C3F6458416666666629382D41333333B340645841333333333B382D41666666C641645841CDCCCCCC4E382D419A9999B9436458410000000069382D41666666C643645841CDCCCCCC73382D4100000080436458419A99999987382D41666666664364584100000000A5382D419A9999194264584100000000C1382D41CDCCCC6C41645841CDCCCCCCD4382D41333333D34064584133333333DD382D419A9999393F645841CDCCCCCCE6382D41CDCCCCAC3C645841CDCCCCCCF0382D41333333533A64584133333333F0382D41CDCCCCAC376458419A999999F3382D410000000034645841CDCCCCCCF5382D41000000E03164584133333333F6382D41CDCCCC6C3064584100000000F7382D41333333132F645841CDCCCCCC04392D41CDCCCC6C2C645841CDCCCCCC16392D419A9999D92A6458413333333326392D41666666062A645841000000003E392D419A999959296458413333333357392D41666666862A645841CDCCCCCC5E392D41333333F32A645841666666666E392D41000000E02B645841333333337B392D41333333132D6458419A99999987392D41333333332F6458419A99999990392D413333331331645841666666669E392D41333333133264584100000000BE392D41666666663364584166666666ED392D41000000C033645841CDCCCCCC043A2D41333333933464584133333333183A2D41000000E0346458419A9999992C3A2D419A999979346458419A999999303A2D4133333353346458419A999999493A2D41CDCCCC4C33645841000000005C3A2D419A999919336458419A999999653A2D41666666A6336458419A9999996F3A2D41CDCCCCAC34645841000000007F3A2D419A9999D9346458419A999999913A2D419A9999F93464584100000000A13A2D41000000803564584133333333AD3A2D41333333733664584133333333B93A2D41666666A636645841CDCCCCCCCA3A2D416666662635645841CDCCCCCCD53A2D41333333B3346458419A999999003B2D41333333D334645841000000003C3B2D419A9999F9346458419A9999994C3B2D41333333B334645841666666666E3B2D419A9999393364584100000000863B2D41333333F3316458419A9999999E3B2D41666666E631645841CDCCCCCCAD3B2D41333333133264584166666666B73B2D41000000403364584166666666C43B2D41CDCCCC0C3464584133333333D63B2D41CDCCCC4C3364584133333333EC3B2D41000000403364584133333333FA3B2D41000000E033645841CDCCCCCCFE3B2D41666666263564584100000000FD3B2D41000000C03664584100000000033C2D413333337338645841666666660D3C2D41000000E03A6458419A9999991C3C2D41000000003D645841CDCCCCCC273C2D41666666663E6458419A9999993C3C2D4133333333406458419A999999583C2D410000008040645841000000006E3C2D41333333F3406458419A9999998D3C2D419A9999B94164584133333333993C2D41CDCCCCEC4164584100000000B03C2D4133333313426458419A999999C23C2D41333333334264584133333333DA3C2D41CDCCCC6C41645841CDCCCCCCEA3C2D41000000C04064584133333333FF3C2D41000000E03F645841000000000C3D2D419A9999F93E645841333333331A3D2D41CDCCCC0C3F64584133333333323D2D41000000603F64584100000000423D2D41CDCCCC2C406458419A999999533D2D41000000803F6458419A999999703D2D419A9999793E645841666666668B3D2D419A9999793E6458419A999999A53D2D41666666263F645841CDCCCCCCB83D2D419A9999F93F64584166666666C23D2D41333333534164584133333333CA3D2D41CDCCCCCC42645841CDCCCCCCD13D2D41666666264464584166666666DA3D2D419A9999D945645841CDCCCCCCEB3D2D41666666E64764584100000000FC3D2D419A9999B949645841CDCCCCCC103E2D41666666E64B645841CDCCCCCC1E3E2D41666666464D645841000000002E3E2D419A9999394F64584133333333463E2D41CDCCCC2C516458419A9999994E3E2D41333333535264584166666666613E2D41CDCCCC4C5364584166666666683E2D41333333335464584100000000743E2D41333333F355645841000000007A3E2D419A999939576458419A9999998B3E2D41CDCCCC4C5864584166666666933E2D413333331359645841CDCCCCCC993E2D419A9999195A645841666666669E3E2D41000000A05A645841CDCCCCCCA53E2D41CDCCCCAC5B64584166666666AE3E2D41000000405D64584133333333B93E2D41333333335E64584166666666C43E2D419A999979606458419A999999D23E2D41666666E66164584133333333DC3E2D41CDCCCC6C6264584100000000E83E2D419A9999596264584100000000F63E2D41CDCCCC4C62645841666666660C3F2D41666666466264584166666666233F2D41CDCCCC8C62645841CDCCCCCC3A3F2D41666666066264584100000000413F2D41666666A66164584166666666453F2D41333333F360645841CDCCCCCC503F2D41CDCCCC6C60645841CDCCCCCC613F2D416666668660645841000000006D3F2D41CDCCCC8C6064584100000000773F2D419A99995960645841CDCCCCCC7E3F2D41666666A66064584166666666863F2D41666666066164584133333333933F2D41666666A6606458419A9999999C3F2D4100000020616458419A999999A13F2D41000000406264584100000000A63F2D419A9999F96264584166666666B43F2D41333333D36364584166666666B73F2D4166666626656458419A999999BF3F2D41000000206664584100000000C43F2D41333333B36764584166666666C63F2D4166666606696458419A999999CA3F2D41666666066A6458419A999999D03F2D41666666266B645841CDCCCCCCD83F2D41000000606C645841CDCCCCCCDE3F2D41CDCCCCCC6C64584166666666E73F2D41CDCCCC0C6D6458419A999999EF3F2D41666666866D64584100000000F73F2D419A999959716458410000000005402D41333333F3716458416666666609402D419A9999F9716458410000000013402D41CDCCCC0C726458413333333325402D419A999999716458410000000037402D419A99999971645841CDCCCCCC3F402D41CDCCCCCC716458419A9999994A402D419A9999B972645841000000005A402D41CDCCCC4C736458419A9999996B402D419A9999F9736458416666666678402D419A999999746458419A99999989402D41CDCCCC8C7464584166666666A5402D41000000207464584166666666AC402D41CDCCCCAC7364584166666666B4402D419A999959736458419A999999BE402D41333333F37364584100000000CA402D419A99993974645841CDCCCCCCDA402D41666666467564584100000000E3402D41CDCCCCCC756458419A999999E6402D41CDCCCCEC7564584100000000F1402D4166666646776458419A999999FE402D41000000A078645841CDCCCCCC09412D4166666606796458413333333312412D4166666626796458413333333321412D41000000E079645841CDCCCCCC2F412D41666666467B6458413333333338412D419A9999997B6458416666666644412D41CDCCCC2C7C6458410000000048412D41CDCCCC8C7C645841333333334E412D41333333137D6458413333333360412D41333333B37D6458410000000079412D419A9999D97E645841CDCCCCCC86412D4100000000806458419A9999998B412D419A999979806458416666666693412D41333333D380645841CDCCCCCCA3412D41CDCCCC8C81645841CDCCCCCCAE412D41666666868164584166666666BC412D41666666E68164584166666666C3412D41666666A68264584133333333D7412D41666666068464584133333333F3412D41CDCCCC8C8564584133333333FA412D416666662686645841CDCCCCCCFE412D41CDCCCC8C86645841CDCCCCCC07422D416666660687645841666666661E422D4166666686876458410000000034422D41333333D387645841666666663B422D419A9999B9886458416666666644422D419A9999598A6458419A9999994F422D41333333138C6458416666666655422D41000000008D645841000000005A422D41333333938D6458419A99999963422D41333333F38D6458413333333372422D41CDCCCCEC8E645841CDCCCCCC7C422D41000000A08F6458413333333389422D416666668690645841333333338E422D419A999959916458410000000092422D419A9999B991645841666666669B422D41333333539264584133333333B6422D41666666069364584133333333D4422D419A9999799364584133333333D8422D4100000080936458419A999999E0422D419A9999F99364584100000000EC422D419A99991995645841CDCCCCCCF9422D4166666626966458413333333302432D4166666626976458419A99999905432D41666666E6976458410000000009432D419A9999B998645841CDCCCCCC10432D4133333373996458419A9999991F432D41000000209B645841CDCCCCCC2B432D41000000E09C6458410000000035432D41CDCCCCCC9D645841666666663D432D41000000009F6458416666666641432D419A999999A06458410000000048432D419A999979A26458419A9999994B432D4133333313A36458410000000054432D4166666666A36458419A9999995C432D419A9999B9A46458416666666666432D41666666A6A56458413333333374432D4133333353A6645841CDCCCCCC83432D419A9999F9A66458413333333391432D419A999959A86458419A9999999A432D41666666A6A8645841CDCCCCCCA8432D419A999939A96458419A999999B5432D4166666626AA64584166666666C0432D41CDCCCC6CAB645841CDCCCCCCC7432D419A9999B9AC645841CDCCCCCCCD432D4133333393AD64584100000000D9432D41000000A0AD64584133333333EC432D41CDCCCCCCAE6458410000000064452D41CDCCCC0CCC64584100000000CA452D419A9999F9D364584166666666A6472D41333333B3AA6458410000000041482D41000000A090645841CDCCCCCC01482D41CDCCCC6C7C6458419A999999E5472D413333331369645841666666669F472D4133333353566458416666666633472D41333333933A645841CDCCCCCC3B472D41000000A0396458410000000044472D419A99993938645841CDCCCCCC4F472D419A999959376458416666666653472D41666666C6356458410000000052472D41333333F3336458413333333348472D4133333373316458413333333341472D41CDCCCC6C2F645841000000003B472D419A9999992B6458410000000031472D41000000002A6458413333333319472D41CDCCCCAC25645841333333330D472D41666666662464584100000000FC462D41000000602364584100000000E2462D41CDCCCCAC226458419A999999D2462D41000000C0216458419A999999C8462D416666666620645841CDCCCCCCC5462D41666666A61E645841CDCCCCCCC4462D41CDCCCC2C1D6458419A999999C3462D41666666A61B6458419A999999C3462D41CDCCCCCC1A6458419A999999CA462D410000002019645841CDCCCCCCDD462D4166666666166458419A999999E4462D41000000C014645841CDCCCCCCE6462D416666666612645841CDCCCCCCE2462D41333333531064584166666666D3462D419A9999990D64584100000000BC462D41CDCCCCAC0B64584133333333AF462D41666666A60964584166666666A9462D419A99995908645841000000009E462D41CDCCCC6C06645841333333338C462D419A99997904645841333333337A462D41CDCCCCEC02645841333333336F462D41CDCCCC6C016458416666666665462D4133333313006458410000000047462D4100000080FB635841333333331D462D4133333353F563584133333333FF452D4133333313F263584133333333D2452D41CDCCCCACEE6358416666666668452D419A9999F9E9635841666666662B452D4100000040E3635841000000001B452D41000000A0DB635841CDCCCCCCDB442D41333333F3D163584100000000B4442D41666666C6C46358419A99999966442D41CDCCCCECBE6358416666666643442D4133333313A8635841000000000F442D419A9999999D6358419A99999902442D41CDCCCC8C9C6358419A999999F9432D41666666069B6358419A999999F2432D41CDCCCC4C99635841CDCCCCCCEA432D41CDCCCC2C976358419A999999DD432D4100000040956358419A999999D2432D419A9999B99363584133333333D3432D4166666626926358419A999999C7432D419A99997990635841CDCCCCCCC8432D419A9999998E63584133333333CE432D41CDCCCCCC8C63584100000000CC432D41666666068A6358419A999999C8432D41000000A08763584133333333C6432D41000000C0846358419A999999C9432D41333333538263584100000000C6432D41333333937E63584100000000C0432D41000000C07963584166666666BF432D41333333137663584166666666C4432D419A9999597463584133333333D6432D419A9999B970635841CDCCCCCCE9432D41000000E06C63584100000000F6432D419A9999F96A63584133333333FC432D41333333F3696358410000000004442D41CDCCCC8C696358413333333307442D4100000020686358416666666611442D41CDCCCC8C676358419A9999991A442D41666666A6646358410000000020442D41CDCCCC0C63635841000000002C442D4133333393626358416666666637442D419A999919616358413333333346442D419A9999195F6358419A9999994C442D41CDCCCCAC5C6358416666666651442D41666666A65A6358419A9999995A442D41000000A059635841666666665B442D416666664658635841333333335A442D41CDCCCC4C57635841000000005A442D416666664656635841666666665D442D41CDCCCCAC54635841CDCCCCCC5A442D41333333B353635841CDCCCCCC55442D419A999919526358419A99999949442D4166666686506358416666666639442D41CDCCCCAC4D6358410000000031442D41333333D34B6358416666666621442D41666666E648635841333333331B442D41666666A6466358419A9999991B442D413333337344635841CDCCCCCC20442D419A999939406358419A9999991E442D41333333D33C6358413333333318442D4166666606396358410000000017442D41666666E6356358410000000014442D41333333D333635841CDCCCCCC15442D419A999999326358413333333315442D41000000C02E6358419A99999913442D419A9999B92C6358416666666613442D41CDCCCC6C2A6358410000000012442D41000000A0296358419A9999990C442D41000000E0286358419A99999906442D41333333B327635841CDCCCCCC02442D41CDCCCC6C256358419A99999900442D4166666646246358413333333302442D41333333D3226358419A99999904442D41333333D3216358416666666606442D419A9999F91E635841333333330C442D419A9999F91C6358413333333311442D41CDCCCCAC1A6358419A99999915442D41CDCCCC2C186358419A99999915442D4100000020166358416666666617442D41CDCCCC8C13635841CDCCCCCC22442D41666666860F635841000000002D442D41666666C60D635841CDCCCCCC2F442D41000000A00C6358416666666634442D41CDCCCC4C096358416666666636442D41000000E0066358410000000037442D41CDCCCC4C036358419A99999939442D419A999959016358419A9999993E442D41CDCCCC8CFE625841CDCCCCCC3F442D4133333353FD625841CDCCCCCC39442D4100000040FB625841CDCCCCCC37442D41333333D3F96258419A99999939442D41CDCCCC6CF86258419A99999937442D41000000A0F6625841CDCCCCCC2E442D419A999979F2625841666666662A442D419A9999B9F06258419A99999923442D419A999939F06258413333333313442D4166666666EF625841CDCCCCCC0B442D4166666606EE6258419A99999906442D41CDCCCC6CED62584100000000F4432D4166666666EC62584166666666E3432D4166666686EA62584100000000E0432D41666666C6E96258419A999999DF432D41CDCCCCACE762584100000000D4432D419A9999F9E46258419A999999D0432D41CDCCCC6CE36258419A999999C7432D419A999999E062584133333333C8432D41333333D3DE62584166666666C9432D41000000A0DC62584100000000C9432D41333333D3DA62584133333333CC432D41CDCCCCACD6625841CDCCCCCCD7432D4100000080D3625841CDCCCCCCDF432D41CDCCCCECD1625841CDCCCCCCEE432D419A999979D1625841CDCCCCCCEE432D4133333313D0625841CDCCCCCCF0432D41666666A6CE6258419A999999F7432D4166666606CD625841CDCCCCCCF5432D4100000000CA62584166666666F3432D4166666686C7625841CDCCCCCCEE432D41666666C6C562584133333333E6432D419A999979C36258419A999999E1432D4100000020C2625841CDCCCCCCDE432D419A999999C062584166666666CE432D4100000040BD62584166666666CE432D4133333353BB62584100000000CA432D4166666606BA62584133333333BE432D4133333373B962584133333333B7432D419A9999D9B862584100000000B4432D41666666E6B662584100000000AD432D419A999959B362584133333333AC432D4166666666B062584100000000AB432D4133333373AE625841CDCCCCCCA6432D41CDCCCCCCAC62584100000000A8432D419A999979AB62584166666666A9432D419A999979A76258419A999999AE432D4133333393A562584166666666AE432D41000000C0A36258419A999999B0432D41CDCCCCECA162584100000000B1432D41666666469F62584100000000B6432D41CDCCCCCC9C625841CDCCCCCCB5432D41333333739A6258419A999999B6432D41666666E69762584100000000B8432D41CDCCCC4C9662584166666666B4432D4133333333956258419A999999AB432D41CDCCCCCC9462584133333333A3432D413333339394625841000000009A432D41666666C6936258419A99999999432D41333333B3916258416666666697432D419A999959906258419A99999985432D41CDCCCC0C8F6258419A9999997B432D41333333338D6258410000000060432D41666666868A6258410000000053432D41333333F387625841CDCCCCCC40432D419A999979866258416666666621432D4166666646856258416666666614432D41CDCCCC6C846258413333333308432D4100000040836258413333333303432D419A999999816258419A999999FA422D41666666067E62584133333333EF422D419A9999197B62584100000000E2422D419A9999797962584166666666DF422D41CDCCCCAC7662584166666666D4422D41333333D3736258419A999999D0422D41000000E07062584133333333C7422D41CDCCCCEC6D62584100000000C2422D41666666866B6258419A999999B8422D41000000E06862584166666666B5422D419A9999D966625841CDCCCCCCBC422D41333333136562584100000000BE422D419A99995962625841CDCCCCCCB8422D419A9999596062584100000000B8422D41CDCCCC8C5E625841CDCCCCCCB0422D41CDCCCC4C5C62584166666666AC422D41000000C05962584133333333A2422D4166666666586258413333333391422D41333333D357625841CDCCCCCC81422D416666660656625841000000007C422D4166666606556258419A9999997B422D41333333F3526258410000000073422D41666666C651625841333333336A422D4133333313506258419A99999962422D41CDCCCCEC4C625841CDCCCCCC62422D41666666864A625841CDCCCCCC69422D419A999919486258419A99999971422D419A9999B9446258419A99999971422D419A9999B9416258410000000077422D41333333B33E6258416666666682422D419A9999393A6258416666666690422D419A99999935625841CDCCCCCC9B422D410000006032625841CDCCCCCC9C422D41CDCCCCCC306258410000000093422D41333333332F625841000000008F422D419A9999592D625841CDCCCCCC84422D41CDCCCC0C2A625841000000007A422D4166666646266258419A9999997B422D410000002023625841333333337B422D41333333D3206258419A99999973422D41333333131E625841333333336D422D41000000E01A6258410000000069422D41333333B319625841000000005E422D41CDCCCC0C19625841CDCCCCCC51422D41CDCCCC0C18625841CDCCCCCC4B422D41CDCCCCCC156258410000000044422D41000000C014625841000000002D422D41666666C6116258416666666624422D419A9999B910625841CDCCCCCC24422D41CDCCCC4C0D6258416666666628422D410000008008625841000000002F422D41666666E602625841666666662E422D41CDCCCCAC006258413333333325422D41000000A0FD6158416666666615422D41CDCCCC0CFB61584166666666FF412D41CDCCCC6CF961584133333333EC412D41333333D3F861584166666666DB412D41333333B3F761584100000000CA412D4100000000F6615841CDCCCCCCBE412D4166666666F3615841CDCCCCCCB6412D4100000060F061584166666666B3412D4100000000ED61584133333333A8412D41000000E0EA6158413333333391412D419A9999B9E86158419A99999976412D4166666666E76158410000000065412D41CDCCCCACE76158419A99999946412D41CDCCCC2CE86158413333333336412D4100000040E96158416666666622412D41CDCCCC6CEA615841CDCCCCCC0D412D41000000A0EA6158416666666600412D419A999939EA61584166666666F3402D41CDCCCC4CE961584166666666EB402D41CDCCCC8CE76158419A999999E7402D419A999999E561584166666666CF402D41666666A6E26158419A999999A9402D4166666646DF6158416666666694402D4133333373DD6158410000000087402D4166666606DB6158413333333372402D41333333D3D76158413333333362402D419A999979D36158413333333355402D4166666606D0615841666666664B402D4133333373CD6158419A99999941402D419A9999F9C8615841333333333F402D419A999959C7615841333333332D402D41000000E0C36158416666666622402D4133333393C06158410000000016402D419A9999B9BC615841333333330C402D41333333F3B66158416666666604402D41CDCCCC0CB561584133333333FD3F2D4100000080B361584166666666F63F2D41CDCCCCACB0615841CDCCCCCCE73F2D419A999939AE6158419A999999D93F2D41CDCCCC8CAC6158419A999999D23F2D4100000000AA6158419A999999D03F2D4133333393A9615841CDCCCCCCC83F2D41000000E0A761584133333333BA3F2D41CDCCCC4CA561584100000000A23F2D419A999959A36158419A999999913F2D41666666A6A261584100000000883F2D4100000040A2615841CDCCCCCC783F2D41666666A6A161584166666666633F2D41CDCCCCCCA0615841666666664E3F2D4133333373A1615841CDCCCCCC3B3F2D419A999939A361584166666666283F2D4100000000A66158419A999999113F2D41000000E0A861584100000000F73E2D41000000A0A961584133333333E23E2D41CDCCCCCCA86158419A999999CC3E2D419A999919A761584133333333BB3E2D4166666606A561584133333333AD3E2D41CDCCCCCCA26158419A9999999A3E2D4100000020A0615841666666668E3E2D41333333D39E61584133333333883E2D41000000A09C615841000000008B3E2D4166666646986158419A9999998D3E2D41CDCCCC6C95615841CDCCCCCC973E2D416666660693615841666666669A3E2D41666666E690615841CDCCCCCC9A3E2D41666666E68F615841CDCCCCCCA13E2D41666666A68D6158419A999999A03E2D41666666068C61584100000000A23E2D41666666668B61584133333333A63E2D41CDCCCCAC8A61584100000000A63E2D41000000E08961584166666666A43E2D41CDCCCC4C89615841CDCCCCCCA63E2D41333333F38761584133333333A63E2D419A999939876158419A999999A03E2D41000000A08661584133333333953E2D410000000085615841CDCCCCCC8E3E2D419A999999836158419A9999998C3E2D41000000C082615841666666668E3E2D416666662682615841CDCCCCCC913E2D41CDCCCC8C8161584133333333913E2D41CDCCCC0C80615841333333338F3E2D41333333F37D615841333333338D3E2D41666666C67B615841333333338C3E2D41333333D37A615841000000008F3E2D419A99997979615841CDCCCCCC943E2D419A9999797861584166666666973E2D41666666E6776158419A9999999F3E2D4166666626766158419A999999A33E2D419A999999746158419A999999A73E2D419A999919736158419A999999AF3E2D41000000207161584166666666BA3E2D41666666C66F61584166666666BE3E2D419A9999596F61584133333333C13E2D41000000C06D6158419A999999C53E2D419A9999B96C6158419A999999CD3E2D41CDCCCCAC6B615841CDCCCCCCD63E2D41333333736A6158419A999999D83E2D41000000806961584133333333D83E2D419A9999D96761584100000000DE3E2D419A9999B96561584133333333E03E2D41CDCCCCCC6361584100000000E23E2D4100000080626158419A999999DE3E2D4166666646616158419A999999C83E2D41000000005E6158419A999999A63E2D41666666065B61584166666666783E2D41666666C656615841000000005A3E2D413333339353615841CDCCCCCC473E2D416666662651615841000000003E3E2D419A9999794F615841CDCCCCCC3A3E2D41CDCCCC8C4D61584166666666343E2D41666666E64A61584100000000363E2D4100000080496158419A999999333E2D416666660648615841333333332A3E2D410000002045615841000000002B3E2D41000000804361584100000000293E2D41CDCCCC6C41615841CDCCCCCC1A3E2D41CDCCCC6C3F6158419A999999183E2D419A9999593E61584100000000153E2D41666666263A61584166666666083E2D41000000A0366158419A999999053E2D419A99993934615841CDCCCCCC013E2D419A9999F9306158419A999999F63D2D41666666862E6158419A999999E63D2D41333333F3296158419A999999D43D2D419A999959256158419A999999C13D2D41CDCCCC2C2361584166666666B93D2D4100000020226158419A999999B73D2D41333333532061584166666666B13D2D41333333B31E6158419A999999A33D2D41666666061D615841000000008E3D2D41666666061A61584100000000893D2D41000000601761584166666666863D2D41CDCCCCCC1461584166666666913D2D419A9999390E61584166666666983D2D41666666660A61584133333333963D2D41CDCCCC2C096158419A999999913D2D41CDCCCC6C07615841CDCCCCCC903D2D419A99995903615841666666669A3D2D41666666660161584100000000A73D2D419A999979FF60584166666666B23D2D41666666C6FB60584133333333C33D2D419A9999F9F560584133333333CF3D2D4100000080F1605841CDCCCCCCD73D2D41333333D3EF6058419A999999E03D2D41666666C6EC60584133333333E43D2D41CDCCCCCCE960584166666666EA3D2D41000000E0E660584166666666EB3D2D4100000080E660584100000000EC3D2D41CDCCCCACE3605841CDCCCCCCF53D2D41333333F3E1605841CDCCCCCCFA3D2D419A9999B9E06058419A999999FF3D2D41CDCCCC8CDF60584133333333033E2D4100000020DB60584100000000FF3D2D41CDCCCCCCD860584133333333FD3D2D41333333F3D560584100000000013E2D4166666686D460584166666666013E2D4100000080D360584133333333FD3D2D4133333373D2605841CDCCCCCCFD3D2D4100000060D060584166666666043E2D41333333B3CE605841333333330F3E2D4133333313CB605841666666660D3E2D4166666606C960584133333333073E2D4133333373C6605841000000000A3E2D4166666626C2605841CDCCCCCC0C3E2D41CDCCCC4CC060584166666666123E2D4100000080BF6058419A999999123E2D41000000E0BD605841000000000E3E2D4166666686BC6058419A999999133E2D41CDCCCCACBB60584133333333173E2D4166666686BA6058419A999999183E2D41CDCCCCECB8605841CDCCCCCC153E2D419A999979B860584100000000143E2D41CDCCCCACB660584166666666173E2D4166666646B5605841CDCCCCCC123E2D41CDCCCCECB360584133333333113E2D41CDCCCC6CB2605841666666660C3E2D4166666686B0605841666666660E3E2D4100000080AF60584133333333113E2D4166666646AD605841CDCCCCCC093E2D41CDCCCCACAB60584100000000063E2D41CDCCCCECA760584100000000103E2D4133333313A6605841333333330E3E2D4133333393A460584100000000103E2D41333333F3A2605841666666661F3E2D4133333373A0605841666666662B3E2D41000000609F60584166666666353E2D41000000609C605841666666664F3E2D410000006097605841CDCCCCCC5E3E2D416666660694605841CDCCCCCC6B3E2D41CDCCCCEC8E60584100000000733E2D41666666A6896058419A999999743E2D41333333538460584100000000723E2D41000000C07D6058419A9999996A3E2D41333333D3786058419A999999593E2D413333331373605841000000004A3E2D41666666066E6058419A999999463E2D41000000E06A60584100000000493E2D41333333B36560584166666666523E2D41CDCCCC0C62605841333333332F3E2D41333333735F60584133333333BF3D2D419A99999941605841CDCCCCCC963D2D41000000603C60584100000000E63C2D41000000604060584133333333DA3C2D41666666864360584133333333CB3C2D419A9999B9456058419A999999C03C2D410000004047605841CDCCCCCCA23C2D41333333334A605841CDCCCCCC7B3C2D419A9999D94D60584100000000603C2D410000006050605841CDCCCCCC473C2D419A999979526058419A999999253C2D41333333F35360584166666666F93B2D41CDCCCC6C5560584166666666E03B2D419A999979566058419A999999C83B2D41CDCCCC0C5860584133333333B23B2D41CDCCCCAC59605841CDCCCCCC9A3B2D419A9999995A605841000000007F3B2D41CDCCCC2C5B60584133333333693B2D41000000005C605841CDCCCCCC5B3B2D41666666465D605841CDCCCCCC4D3B2D419A9999395F60584166666666423B2D419A999939616058419A9999993D3B2D41CDCCCC2C62605841CDCCCCCC2D3B2D41CDCCCC8C616058419A999999193B2D41CDCCCC8C6160584100000000E53A2D4133333313626058419A9999998F3A2D41CDCCCC0C63605841333333335D3A2D419A9999D96360584166666666323A2D416666668664605841CDCCCCCC193A2D41666666C66460584100000000053A2D4100000080656058419A999999EE392D419A9999996660584133333333DE392D41000000A067605841CDCCCCCCCD392D416666666668605841CDCCCCCCB5392D4166666646696058419A9999998C392D419A9999F96A605841CDCCCCCC56392D41666666C66D6058413333333330392D41333333B36F6058419A99999912392D416666660671605841CDCCCCCCFC382D41000000E07160584100000000E8382D41CDCCCC6C726058419A999999D3382D41CDCCCC8C7260584166666666B3382D419A9999B972605841CDCCCCCC96382D41CDCCCC6C73605841CDCCCCCC7B382D4133333373746058416666666656382D41666666E675605841000000003E382D41CDCCCC6C76605841CDCCCCCC26382D4166666666766058416666666603382D419A999959766058419A999999E2372D419A9999797660584166666666BE372D41666666E6776058419A999999A4372D4100000040796058410000000091372D41666666067B6058419A99999981372D41CDCCCC6C7D6058419A99999975372D41333333D37E6058419A9999995F372D4166666606806058410000000032372D416666662682605841CDCCCCCC08372D419A9999D9836058419A999999EA362D41333333538460584100000000D2362D41333333538460584133333333AF362D41666666A683605841333333339D362D41CDCCCC0C83605841666666667D362D41CDCCCCAC816058416666666657362D410000002080605841CDCCCCCC38362D419A9999397F605841333333332C362D419A9999D97E6058419A999999E6352D41333333537D6058419A999999AC352D41CDCCCC6C7C605841CDCCCCCC90352D419A9999F97B6058419A99999980352D419A9999B97B6058410000000064352D41000000C07B6058410000000038352D41666666E67B605841000000001E352D419A9999397C605841CDCCCCCCF6342D41CDCCCC6C7D605841CDCCCCCCDA342D41666666067E6058419A999999B1342D419A9999597F6058413333333388342D41CDCCCCAC806058419A99999967342D41333333F3816058413333333349342D41CDCCCC8C836058413333333336342D410000008084605841333333331D342D41333333138560584133333333E0332D41333333538660584100000000BA332D419A99997987605841CDCCCCCC9B332D4133333353886058419A9999997E332D419A999979886058419A99999966332D4100000020886058416666666657332D41000000C087605841CDCCCCCC38332D419A999959866058419A9999991F332D419A9999F98460584166666666F1322D419A99993981605841CDCCCCCCBA322D419A9999597D6058413333333390322D41333333737A6058416666666679322D413333337379605841CDCCCCCC56322D41333333B378605841333333333E322D41CDCCCC6C786058419A99999912322D41666666867860584133333333EC312D41000000E078605841CDCCCCCCBB312D41333333337A605841333333339B312D41666666E67A6058419A99999980312D419A9999397B6058410000000023312D41666666867B60584133333333CD302D41666666A67B6058419A9999997D302D41666666A67B6058413333333324302D41666666E67B605841CDCCCCCC06302D41333333B37B60584133333333C22F2D41CDCCCC0C7B60584166666666862F2D41333333B37A605841000000004E2F2D41000000007B605841CDCCCCCC062F2D41333333337B60584100000000C62E2D419A9999797B6058419A999999752E2D419A9999F97B60584100000000532E2D41333333737C60584100000000162E2D41000000607D60584100000000F62D2D41000000A07D6058419A999999E12D2D41000000407D6058419A999999BC2D2D41666666E67B60584100000000952D2D41CDCCCC6C7960584166666666762D2D41333333D37660584166666666532D2D41000000207360584133333333342D2D41666666E66F605841666666661E2D2D419A9999196E60584166666666072D2D41000000206D60584133333333DA2C2D419A9999996B60584133333333B92C2D41000000006B605841333333339F2C2D41000000006B60584166666666892C2D41333333736B60584100000000622C2D41333333336D605841000000004A2C2D41333333136E605841000000002F2C2D41333333336E605841CDCCCCCC2A2C2D41333333336E60584133333333142C2D41000000406E6058419A999999B22B2D41000000206E605841CDCCCCCC782B2D41333333F36D60584100000000592B2D419A9999996D6058419A999999332B2D41333333D36C605841CDCCCCCC072B2D41333333F36B60584100000000F52A2D41333333D36B605841CDCCCCCCE02A2D41CDCCCC4C6C60584100000000B72A2D419A9999796D60584100000000AE2A2D41666666C66D60584166666666992A2D41CDCCCCEC6B605841000000008B2A2D41333333D36A6058419A9999996F2A2D413333331369605841000000005E2A2D419A99999968605841333333333E2A2D41666666466860584133333333EA292D41000000606660584133333333CA292D419A999999656058413333333397292D41CDCCCC6C63605841000000008D292D41666666C6616058419A99999984292D4100000020606058410000000078292D41333333B35D605841333333336B292D419A9999595C605841CDCCCCCC5E292D41333333335B6058419A99999945292D41000000805A605841333333332A292D419A9999995960584166666666C6282D4166666686556058419A99999969282D4100000060536058419A9999991E282D419A9999395260584100000000E1272D41666666A65160584100000000CB272D41333333B3516058419A999999B3272D419A999939516058419A9999999D272D4100000020506058416666666688272D41333333D34F605841666666667A272D41000000E04E605841333333336E272D41CDCCCCCC4D6058419A9999995C272D41666666664C605841333333333D272D41CDCCCCAC496058413333333326272D410000008047605841CDCCCCCC16272D41CDCCCCAC446058416666666609272D419A99993942605841CDCCCCCCFE262D41000000E040605841CDCCCCCCEB262D413333331340605841CDCCCCCCAA262D419A9999993C6058419A99999983262D41666666C63A6058413333333371262D4100000060396058419A9999995E262D410000006037605841CDCCCCCC43262D4133333313336058413333333330262D4166666626306058416666666620262D41000000802E6058413333333315262D41CDCCCCCC2C605841666666660D262D41666666662B60584100000000BF252D413333331339605841CDCCCCCCB0252D41666666063860584100000000A2252D4166666626376058410000000090252D4166666646366058419A99999980252D41000000E035605841CDCCCCCC6C252D410000002034605841CDCCCCCC5A252D416666662633605841666666664A252D41000000E031605841CDCCCCCC39252D41CDCCCCAC306058410000000029252D41000000E02F6058419A99999921252D41CDCCCC4C2E605841666666661F252D41000000C02D6058419A9999991C252D41333333732C605841333333331A252D41CDCCCC2C2B6058419A99999919252D41333333F32A6058410000000012252D41CDCCCC2C286058413333333306252D41000000602660584100000000FD242D413333333325605841CDCCCCCCF5242D41333333B32360584133333333EB242D41666666C62160584100000000E4242D41CDCCCC8C206058419A999999D3242D41666666261E60584100000000CF242D41CDCCCC6C1D60584166666666C3242D41000000801B60584100000000C0242D41000000001B60584166666666BB242D41CDCCCC4C1A6058419A999999AB242D41666666461860584133333333A7242D41666666A61760584100000000A5242D410000006016605841CDCCCCCCA4242D41000000A01560584100000000A2242D41CDCCCC0C14605841666666669D242D413333333311605841333333339F242D419A9999D90F605841CDCCCCCC9D242D41333333D30B6058416666666682242D419A999979086058410000000078242D419A99993907605841CDCCCCCC3F242D4133333393056058416666666614242D416666662604605841CDCCCCCCE6232D4166666666036058410000000086232D410000004003605841CDCCCCCC73232D41333333D3026058410000000071232D41000000C002605841CDCCCCCC63232D41CDCCCC2C026058419A99999954232D4133333333016058416666666647232D41666666C6006058410000000046232D41333333B300605841000000003C232D41CDCCCC8C006058413333333330232D41666666A6FF5F58416666666623232D4100000020FD5F584133333333D3222D419A999999FE5F5841666666663D222D4100000080FE5F584100000000C91F2D41CDCCCCEC0C60584100000000761F2D41000000401A605841CDCCCCCC6E1F2D41666666661B60584100000000671F2D419A9999391B60584100000000581F2D41666666A61B605841CDCCCCCC261F2D41CDCCCCEC1C605841CDCCCCCC0B1F2D41000000401E60584166666666B91E2D41666666262260584100000000921E2D410000006024605841666666665B1E2D419A99997927605841CDCCCCCC351E2D41CDCCCC2C2960584133333333FC1D2D41000000802A6058419A999999B21D2D41666666862B6058419A999999371D2D41000000E02E60584100000000D01C2D419A9999B93160584166666666961C2D41000000003260584100000000501C2D419A9999193360584100000000571B2D419A99991937605841333333330E1A2D41CDCCCC0C3C6058419A999999F4192D41000000A03B60584100000000D1192D419A9999393B6058419A9999999C192D419A9999793B6058413333333350192D419A9999593C6058410000000011192D41333333133E605841CDCCCCCC03192D41333333733E60584100000000CB182D419A9999D93560584100000000B9182D41000000C034605841CDCCCCCC69182D419A99993931605841000000004F182D4133333393306058413333333338182D413333337330605841CDCCCCCCDC172D41666666C632605841CDCCCCCCC1172D41CDCCCC2C336058410000000076172D419A9999D932605841CDCCCCCC48172D419A999919326058419A999999F6162D419A999939356058419A999999DB162D41000000403660584166666666C8162D41666666C636605841CDCCCCCCA1162D410000002037605841CDCCCCCC5B162D41000000E0376058419A99999913162D41666666C639605841CDCCCCCCA8152D419A9999B93D6058419A9999996B152D41CDCCCC4C3F6058410000000036152D41CDCCCC8C406058416666666623152D419A9999B940605841CDCCCCCC18152D4100000080416058416666666610152D41333333D341605841666666663C142D41CDCCCCCC4D60584133333333E9122D416666666655605841CDCCCCCCB9102D4100000040576058416666666654102D419A9999795E6058419A9999992C102D419A9999595B605841CDCCCCCC02102D41333333B3586058419A999999D00F2D4100000060566058419A9999998B0F2D41CDCCCCEC53605841333333334B0F2D41CDCCCC2C5260584166666666150F2D419A9999D95060584100000000E50E2D41000000204F60584133333333B10E2D41000000804D605841CDCCCCCC770E2D41333333534C605841CDCCCCCC350E2D41CDCCCCEC4A605841CDCCCCCC020E2D41000000204A60584166666666EF0D2D41333333D34960584133333333C10D2D419A9999B9486058419A9999999C0D2D4133333353476058419A999999700D2D4133333353456058419A9999994B0D2D4133333333436058419A9999990A0D2D41666666663C60584166666666EE0C2D41000000203860584166666666CB0C2D419A999979336058419A999999A90C2D41CDCCCCCC30605841CDCCCCCC680C2D419A9999792C6058419A999999400C2D413333337329605841000000001E0C2D41666666C6286058419A999999EE0B2D41CDCCCC6C296058419A999999BE0B2D41000000C02A6058419A999999820B2D41000000202E60584100000000470B2D4100000060326058419A999999250B2D41666666463460584133333333050B2D413333333335605841CDCCCCCCDB0A2D4100000000366058419A999999B20A2D41333333B336605841CDCCCCCC820A2D419A99993937605841CDCCCCCC5C0A2D41CDCCCCAC3660584133333333310A2D41000000C03560584100000000090A2D41CDCCCCEC3460584133333333020A2D41CDCCCCCC34605841CDCCCCCCE3092D41000000803560584166666666AB092D41CDCCCC0C376058419A99999991092D4100000000386058410000000085092D4133333373386058419A9999995D092D41333333933A6058416666666639092D419A9999593B6058419A999999FB082D41000000403C60584166666666C3082D419A9999793D6058410000000083082D41000000803F6058416666666647082D41CDCCCC8C416058419A99999907082D419A9999F94260584133333333D6072D419A9999194360584133333333AD072D4133333353426058410000000088072D41CDCCCC6C406058419A9999996C072D419A9999D93E605841000000005D072D41666666663E6058413333333351072D41CDCCCC6C3E6058416666666631072D41000000A03F60584133333333F3062D41333333F343605841CDCCCCCCAF062D4133333353496058416666666663062D41666666E64E605841666666662D062D41666666A65360584166666666F7052D410000006059605841CDCCCCCCC8052D419A9999595F605841333333339A052D41CDCCCC4C65605841CDCCCCCC8E052D4100000020676058413333333386052D41CDCCCC6C68605841666666667C052D419A9999F96A6058410000000077052D41CDCCCC8C6B6058416666666680052D419A9999596F6058413333333380052D4100000020736058413333333377052D41666666C67B605841CDCCCCCC65052D419A9999D9876058419A9999994D052D41666666C694605841CDCCCCCC33052D41CDCCCC0CA0605841333333332B052D4166666686A66058419A99999929052D4166666626AC6058416666666641052D419A999999BC6058419A9999994C052D4166666666C3605841333333335F052D4166666646C9605841000000007D052D41CDCCCCCCCF6058419A999999A1052D4166666646D660584100000000CC052D41666666A6D9605841666666660B062D41333333B3DC6058416666666678062D41333333F3DF60584100000000BF062D41CDCCCC0CE2605841000000000C072D41CDCCCC4CE56058416666666645072D4166666626E8605841666666667A072D41666666C6EA6058419A999999AD072D41CDCCCC2CED6058419A999999F8072D419A999979EF6058419A9999992E082D41000000C0F16058419A9999994E082D41333333F3F3605841666666669A082D419A999999FB60584166666666A1082D4133333393FC60584133333333BF082D41000000C009615841CDCCCCCCD1082D41333333F31261584133333333D7082D41000000E01661584133333333D6082D41000000001A61584100000000C3082D419A9999D92461584133333333B1082D41000000202D61584133333333AD082D419A999999326158419A999999AE082D419A9999F93761584133333333B6082D41CDCCCCCC3761584166666666C3082D4100000080386158419A999999D0082D41666666C63961584133333333E9082D41666666263C615841000000000A092D419A9999B93F61584166666666F7082D419A9999394261584133333333D8082D41333333F3456158419A999999CB082D41666666A646615841CDCCCCCCAD082D410000006046615841333333339A082D410000006046615841000000008F082D416666660647615841000000006E082D41333333D349615841666666661E082D41CDCCCC8C4F61584166666666EF072D419A9999995261584166666666E4072D41000000C05261584133333333A1072D4133333333516158419A9999998D072D4133333333516158413333333384072D41CDCCCC8C516158419A99999971072D4166666686536158416666666650072D4100000000586158416666666620072D41666666A65D61584133333333F8062D419A9999F961615841CDCCCCCCD7062D41333333D36461584133333333AC062D41666666A6666158413333333380062D413333333367615841CDCCCCCC51062D410000006067615841CDCCCCCC3C062D41666666E6676158416666666619062D41CDCCCC2C6A6158419A999999EC052D41333333D36B61584166666666CB052D419A9999796B6158419A9999999C052D41666666466A615841CDCCCCCC40052D41333333D36861584133333333D8042D41666666466761584166666666AC042D41CDCCCC6C666158419A999999DA042D41CDCCCCEC72615841CDCCCCCCF6042D419A9999F97B615841333333330E052D419A9999D9846158410000000017052D419A9999198B615841CDCCCCCC1A052D419A9999B98D6158410000000022052D419A9999B9966158416666666623052D41333333539F6158419A9999991E052D41666666C6A76158419A9999991B052D41000000E0A96158413333333315052D419A999979AE6158413333333319052D4100000080B66158419A99999925052D4133333393C76158419A9999992A052D4100000020CE615841666666662A052D41333333D3D2615841000000001D052D4166666626D7615841CDCCCCCC0A042D419A999979686258416666666689042D410000000078625841CDCCCCCC92042D410000008080625841666666667B042D41000000409362584100000000E5042D41000000E0B7625841333333332B052D4133333373C96258416666666647052D41666666A6E2625841CDCCCCCC6C052D4166666626F762584166666666B8042D41CDCCCC2CFE6258413333333351042D419A99991906635841CDCCCCCC24042D41CDCCCCAC0663584133333333EA032D4100000060066358419A99999992032D41666666E6126358410000000053032D416666660629635841	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	01010000206A0800008CCF805B62232D41CDCCCCAC68625841	050170000	Z	La Bâtie-Neuve	0501700	05017	05	93	27
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	01010000206A080000F281BD8EFF042D419A9999B9E75E5841	050180000	Z	La Bâtie-Vieille	0501800	05018	05	93	9
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	01010000206A0800006466665EE4C92B419A9999690C5D5841	050190000	Z	La Beaume	0501900	05019	05	93	30
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	01010000206A0800004C0DECDD3C0D2C41CDCCCC5C234E5841	050210000	Z	Le Bersac	0502100	05021	05	93	8
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