SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep08;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep08 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep08','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep08','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep08','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep08"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800004A3F0D559A4C2841CCCCCCFCC0725A41	080010000	Z	Acy-Romance	0800100	08001	08	44	11
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	01010000206A080000C50D7A85F6422941000000C0E3935A41	080030000	Z	Aiglemont	0800300	08003	08	44	9
01060000206A080000010000000103000000010000003D0100000000000062E227416666664620715A4133333333DBE22741CDCCCC8C1F715A4133333333EFE22741333333B33C715A4133333333F2E227413333335340715A41CDCCCCCCE4E227419A99997955715A4100000000E3E227410000000058715A41CDCCCCCCE1E227419A9999395A715A4133333333E0E22741333333135D715A41CDCCCCCC52E327419A99995963715A410000000077E32741000000E06A715A4133333333BAE32741CDCCCCEC73715A413333333351E32741CDCCCC2C8A715A41000000000CE32741000000C096715A4100000000E7E22741333333339F715A419A999999E7E227419A999959A7715A416666666613E3274166666626AC715A413333333366E32741333333D3B3715A416666666611E32741333333B3C8715A419A99999920E327419A9999D9CD715A416666666650E327419A999939CB715A41CDCCCCCC8AE32741CDCCCCCCC8715A4166666666B6E3274133333313C7715A4166666666E4E327419A999919C5715A41CDCCCCCCFEE3274100000060C3715A419A99999919E4274133333373C1715A413333333336E4274133333373BF715A410000000052E42741000000C0BD715A41CDCCCCCC68E42741000000C0BC715A419A99999982E4274100000040BC715A4100000000A5E4274100000020BC715A4133333333C6E42741333333B3BC715A4100000000E8E4274133333313BE715A41666666661EE527419A9999B9C0715A41CDCCCCCC44E5274166666666C2715A410000000062E52741000000C0C4715A41CDCCCCCC6FE527419A999979C6715A419A9999997EE5274133333333CA715A419A99999986E527419A999939CF715A41000000008BE5274100000040D8715A416666666686E5274100000040DE715A41CDCCCCCC7AE5274166666646E2715A410000000068E52741000000A0E5715A41666666664DE52741CDCCCC0CE9715A41333333330CE52741CDCCCCECED715A4100000000E1E4274100000000F1715A4133333333CEE42741666666A6F3715A4133333333BFE4274133333313F7715A4100000000B7E42741666666C6FA715A4166666666B2E42741333333F3FF715A4166666666B9E427410000006004725A41CDCCCCCCCDE427410000004009725A419A999999F7E427419A9999590F725A41CDCCCCCC35E527413333335316725A41CDCCCCCC73E52741666666A61A725A4133333333C6E527419A99991920725A410000000020E627413333333326725A41000000007EE62741CDCCCCAC2C725A41CDCCCCCCC4E62741CDCCCC2C28725A41000000008DE72741333333B322725A41CDCCCCCC0DE82741333333D31E725A41333333332BE827419A9999D91C725A41000000005BE827410000004012725A41666666669BE82741333333D300725A413333333352E8274100000040FA715A41000000003CE8274100000040D9715A413333333371E827419A999939D8715A41666666669CE8274166666686D1715A41CDCCCCCC1AE9274133333393B9715A419A999999AFE927419A999959C2715A416666666628EA274100000040B8715A410000000081EA2741000000E0B2715A4166666666ADEA274133333393BD715A419A999999DBEA274166666666CA715A4166666666DCEA2741000000C0D3715A4100000000B9EA2741CDCCCCCCDC715A419A999999BFEA2741333333D3E2715A419A999999E2EA274166666626EC715A419A99999940EB27419A9999B9F0715A416666666669EB274166666626F7715A419A999999A2EB2741333333B306725A41CDCCCCCCB8EB2741333333130C725A4100000000D8EB2741000000200A725A41333333332AEC2741333333B3FF715A41666666664CEC2741CDCCCC4CFE715A410000000076EC2741000000E001725A41CDCCCCCCE1EC2741333333731A725A4100000000E9EC2741333333131C725A4133333333FFEC2741333333531B725A41333333330FED2741000000A01B725A419A9999991EED2741CDCCCCEC1B725A41CDCCCCCC2EED2741333333B31C725A419A9999993AED2741CDCCCC8C1D725A410000000050ED27419A9999D91F725A41CDCCCCCC86ED27419A99997927725A41CDCCCCCCDEED2741CDCCCC2C36725A410000000058EE27419A9999D94A725A410000000071EE2741000000C04E725A416666666695EE2741CDCCCC8C4F725A4133333333AEEE2741666666C64C725A410000000098EE27413333335348725A41CDCCCCCCD7EE2741333333F343725A416666666643EF27410000000043725A41666666664CEF2741333333333D725A416666666665EF27419A9999F93C725A41000000006BEF27419A99993933725A416666666672EF27416666660631725A419A9999990CF027416666662628725A419A99999959F02741CDCCCC2C0E725A416666666613F1274166666626E2715A419A99999961F12741CDCCCC8CE8715A4133333333C2F22741000000E088715A413333333308F327419A9999B98D715A416666666608F42741CDCCCC2C32715A4166666666B6F4274100000060F9705A419A999999EDF427413333331300715A419A999999F9F427419A99995905715A419A999999FCF427419A99997902715A4133333333EEF4274133333313F1705A419A999999E1F4274133333353F0705A4133333333DBF42741000000C0EE705A419A999999EBF4274100000000EC705A4133333333F4F42741333333D3E9705A4166666666F8F42741666666C6E6705A4100000000F9F4274133333313E0705A41CDCCCCCCF9F427419A999919D5705A41CDCCCCCCF8F42741CDCCCCCCCB705A41CDCCCCCCF6F427419A999999C5705A4166666666F0F42741CDCCCCECBB705A4133333333E8F42741000000A0B3705A419A999999DFF4274100000000AB705A4166666666D8F42741333333D3A2705A419A999999CBF42741333333F396705A4100000000C0F42741CDCCCCCC8A705A4166666666B0F42741333333B37B705A419A999999A1F42741666666666D705A41CDCCCCCC86F427413333337354705A419A9999998BF827410000000082705A41CDCCCCCCCAF82741666666C669705A41CDCCCCCCE5F82741CDCCCCCC5F705A41333333330FF92741666666864F705A41CDCCCCCC38F92741000000A03F705A41CDCCCCCC5DF92741000000E031705A41CDCCCCCC6BF92741CDCCCC2C2C705A413333333388F92741CDCCCCEC20705A4166666666A3F92741CDCCCC2C16705A4133333333BEF92741666666A60C705A4133333333DAF927419A99993902705A4100000000F9F92741CDCCCC0CF66F5A410000000011FA274133333373EC6F5A410000000039FA27419A999939DD6F5A413333333359FA2741000000E0D06F5A41666666666CFA2741CDCCCC4CC96F5A413333333389FA274166666666BE6F5A4166666666A5FA274133333333B46F5A419A999999BFFA274166666686AA6F5A4166666666E1FA27419A9999999D6F5A41CDCCCCCCFAFA2741333333F3936F5A41CDCCCCCC18FB2741CDCCCC6C886F5A413333333337FB2741000000A07B6F5A413333333350FB27419A9999B9716F5A410000000065FB27419A999999696F5A410000000079FB2741333333F3616F5A41CDCCCCCC92FB27419A999939586F5A41CDCCCCCC11FC2741333333532F6F5A419A9999996DF92741666666A6106F5A41CDCCCCCC82F9274166666666E36E5A4133333333A0F9274133333393DC6E5A4166666666C1F9274133333333D46E5A41CDCCCCCCEBF92741333333D3C96E5A410000000012FA274100000080C06E5A41000000003CFA27419A9999B9B66E5A419A9999997BFA274133333353A76E5A4133333333E6FA2741666666A6956E5A419A99999903FB2741000000E08C6E5A41333333332BFB27419A999999866E5A4133333333F1FB274133333333526E5A413333333380FA2741333333B35B6E5A419A99999941FA27419A9999995A6E5A416666666603F92741666666C6496E5A4133333333DCF72741CDCCCC4C366E5A41CDCCCCCCFEF6274166666646216E5A416666666686F62741CDCCCCEC196E5A419A999999A8F52741666666E66F6E5A416666666616F5274133333353696E5A4166666666B3F42741333333D3646E5A416666666657F4274133333393606E5A41CDCCCCCCF9F32741333333535C6E5A410000000096F32741000000C0576E5A419A99999938F3274133333373536E5A41CDCCCCCCF5F22741333333B3506E5A419A999999D5F227419A9999794F6E5A4133333333BDF22741666666664E6E5A41CDCCCCCCB0F2274166666666566E5A419A999999A0F22741666666A6606E5A419A99999991F22741666666C6696E5A41CDCCCCCC8DF227419A9999996E6E5A41CDCCCCCC8DF2274100000040726E5A41CDCCCCCC92F22741333333F3756E5A41000000009BF22741666666A6796E5A4100000000AAF22741CDCCCC4C7F6E5A4166666666C2F22741CDCCCC0C886E5A4166666666DDF227419A9999D9916E5A4166666666F6F22741CDCCCCEC9A6E5A410000000010F327419A999919A46E5A41CDCCCCCC00F32741666666A6A46E5A4166666666EFF22741000000A0A46E5A4166666666C2F2274133333313A36E5A416666666676F22741CDCCCC8CA06E5A41333333331EF22741CDCCCC8C9D6E5A4166666666BBF12741666666269A6E5A413333333370F12741CDCCCCAC976E5A416666666637F12741000000A0956E5A419A9999992DF12741666666E6956E5A410000000029F12741CDCCCC8C966E5A41333333332AF12741333333B3976E5A419A99999948F12741333333F3A26E5A416666666666F1274166666686AE6E5A419A99999994F12741CDCCCC2CBF6E5A4166666666B9F1274133333333CC6E5A4100000000DEF12741666666E6D86E5A4100000000DEF12741666666E6D96E5A41CDCCCCCCD9F12741333333D3DA6E5A4166666666D3F127419A999979DB6E5A4100000000A1F1274100000040DC6E5A416666666656F12741CDCCCC2CDD6E5A41000000001EF1274133333313DE6E5A410000000016F12741CDCCCC4CDE6E5A419A99999912F1274133333393DE6E5A410000000013F12741333333D3DF6E5A413333333314F1274166666626E96E5A419A99999913F12741CDCCCCCCF56E5A41CDCCCCCC14F12741666666C6026F5A419A99999914F1274133333373066F5A410000000016F12741CDCCCCCC106F5A416666666616F12741666666C61A6F5A416666666616F12741CDCCCC6C1E6F5A419A99999915F1274166666606206F5A410000000011F12741CDCCCCEC206F5A41666666660AF127419A999939216F5A41CDCCCCCCF8F0274166666606216F5A4100000000E2F0274133333373206F5A4100000000D7F02741666666A61F6F5A41666666669AF02741CDCCCC4C1D6F5A416666666656F027419A9999591A6F5A416666666613F02741CDCCCC8C176F5A4133333333D2EF2741000000E0146F5A419A9999997EEF2741CDCCCC4C116F5A41333333332BEF2741000000E00D6F5A4100000000DFEE2741666666860A6F5A41CDCCCCCCCBEE2741CDCCCC0C0A6F5A4133333333C1EE2741CDCCCC4C0A6F5A41CDCCCCCCB7EE2741CDCCCCAC0B6F5A419A99999985EE2741CDCCCC2C186F5A413333333358EE274100000020246F5A41CDCCCCCC35EE2741CDCCCC6C2C6F5A410000000013EE274166666666356F5A4166666666E9ED2741333333933F6F5A4100000000BCED27419A9999394B6F5A416666666690ED2741333333B3566F5A41CDCCCCCC5BED2741CDCCCC2C646F5A413333333334ED2741000000C0706F5A416666666614ED2741333333337C6F5A419A999999F5EC2741CDCCCCCC866F5A41CDCCCCCC5FEC27419A999959BB6F5A413333333337EC27419A999979C86F5A413333333323EC274166666666D06F5A4166666666E9EB274100000080CD6F5A41000000009DEB2741000000E0C96F5A41CDCCCCCC4FEB2741CDCCCC2CC66F5A4100000000FCEA274166666606C26F5A41CDCCCCCCBBEA2741333333D3BE6F5A41CDCCCCCC77EA274133333373BB6F5A41CDCCCCCC69EA2741666666C6BA6F5A41CDCCCCCC70EA274166666686BD6F5A41000000004FEA274133333373C76F5A41CDCCCCCC27EA274100000020D36F5A413333333304EA274133333333DE6F5A4100000000E8E92741CDCCCC2CE66F5A4166666666C1E927419A9999D9EF6F5A41CDCCCCCC8BE92741CDCCCCACFD6F5A41000000004DE92741000000400E705A419A99999922E92741CDCCCC0C19705A419A999999F6E82741CDCCCCEC23705A41CDCCCCCCCEE82741333333732E705A413333333399E827419A9999793D705A410000000074E82741CDCCCC0C47705A410000000055E82741000000A04E705A419A99999938E82741666666C656705A41CDCCCCCC1AE82741CDCCCCAC60705A419A99999905E827419A99999969705A4166666666E2E72741CDCCCC6C77705A4133333333C0E72741CDCCCC2C85705A4133333333A5E72741333333738F705A410000000096E72741000000E094705A41CDCCCCCC8FE72741CDCCCC4C95705A413333333387E727410000006095705A41CDCCCCCC78E727419A99991995705A41333333334FE72741333333D392705A419A99999924E72741000000C090705A41000000001EE72741CDCCCCCC90705A4100000000ECE62741CDCCCCCC8D705A41CDCCCCCC3DE62741CDCCCC4C85705A41CDCCCCCC47E52741333333D37C705A419A99999943E4274133333373E8705A4100000000FAE42741CDCCCC8CEC705A41CDCCCCCCDBE42741CDCCCC0CF7705A4133333333BCE42741666666A605715A419A999999B4E427419A99995909715A4166666666B3E427413333335310715A413333333372E427419A9999990F715A419A999999E8E32741333333130E715A41CDCCCCCC9AE327419A99995913715A41CDCCCCCC51E327416666660613715A419A9999998EE22741CDCCCC8C15715A416666666693E227419A9999391A715A410000000068E22741333333D31A715A410000000062E227416666664620715A41	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	01010000206A0800001D9DB20AFEF02741CDCCCCAC37705A41	080040000	Z	Aire	0800400	08004	08	44	7
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	01010000206A0800008CF8243FD0572841CDCCCC2CEF685A41	080050000	Z	Alincourt	0800500	08005	08	44	9
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	01010000206A0800005AAE9216F2C72841333333A343755A41	080060000	Z	Alland'Huy-et-Sausseuil	0800600	08006	08	44	9
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	01010000206A080000F2020A68F7AD28419A9999295C755A41	080080000	Z	Amagne	0800800	08008	08	44	9
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	01010000206A080000D0637FA686A9284100000070BF725A41	080100000	Z	Ambly-Fleury	0801000	08010	08	44	6
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	01010000206A080000465CF4A235042941343333535FA25A41	080110000	Z	Anchamps	0801100	08011	08	44	2
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	01010000206A0800006C666697A6B929419A9999991F835A41	080130000	Z	Angecourt	0801300	08013	08	44	4
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	01010000206A080000E2B2551D5D7B284134333363A76C5A41	080140000	Z	Annelles	0801400	08014	08	44	13
01060000206A08000001000000010300000001000000F600000066666666EE292841333333F31C995A419A9999999C2A28410000004043995A4100000000C82A28419A9999D951995A4100000000F32A2841333333D358995A41666666663F2B28416666662665995A4166666666D62B2841000000A07E995A4100000000342C2841CDCCCC0C8E995A4100000000B32C2841CDCCCC2CA5995A41CDCCCCCCE22C2841333333D3AD995A4133333333222D28419A9999F9BC995A419A9999997D2D284133333333CC995A419A999999F12D284133333353DD995A4133333333562E284133333373E5995A4100000000FC2E28419A9999D9F1995A41666666663F2F2841333333F3F4995A4166666666332F284100000080FA995A41666666669A2F284166666666069A5A41000000001B3028419A999939159A5A41333333337F302841000000001E9A5A4133333333D9302841666666A61F9A5A410000000040312841333333F3239A5A41CDCCCCCC9631284133333373289A5A4100000000DE3128419A9999D92C9A5A4133333333363228419A999999379A5A41666666667F3228419A999939439A5A419A999999B4322841000000604B9A5A41000000001F332841333333F33E9A5A4100000000E333284133333333289A5A41CDCCCCCC093728419A999959939A5A410000000067372841666666669E9A5A4100000000733828419A999919AA9A5A41CDCCCCCCDE382841CDCCCC0CAC9A5A41CDCCCCCCC0392841000000609B9A5A4100000000163A284133333313A49A5A419A999999D43A284100000020BD9A5A4133333333323B2841000000E0C99A5A41666666663B3B284166666666C89A5A41666666666B3B2841CDCCCCECBC9A5A41CDCCCCCC7C3B28419A999939B79A5A4133333333AA3B2841CDCCCCCCA69A5A4166666666B43C284166666686BF9A5A41666666663F3E284100000020949A5A4133333333393F28419A999959769A5A41CDCCCCCCE03F2841CDCCCCCC649A5A419A9999997B4028419A9999595F9A5A4133333333ED402841CDCCCCAC5C9A5A419A999999A5442841CDCCCCEC4E9A5A4100000000C2452841666666C64C9A5A41CDCCCCCC2346284166666646529A5A4166666666A6462841000000605D9A5A4100000000E3462841CDCCCC0C669A5A416666666601472841666666466C9A5A419A99999901472841666666C66E9A5A413333333336472841666666C6759A5A41333333336F472841CDCCCC0C779A5A41666666668047284133333333799A5A419A999999AA472841CDCCCCEC7D9A5A41CDCCCCCCC44728419A9999B9809A5A4166666666E447284133333373839A5A413333333309482841000000C0859A5A41CDCCCCCC194828419A999939869A5A41333333332C48284100000080869A5A41333333334A482841000000C0879A5A41666666666948284166666666899A5A4100000000864828419A9999F98A9A5A41CDCCCCCC93482841333333338C9A5A416666666699482841333333B38D9A5A41CDCCCCCC98482841000000808F9A5A41333333339A482841666666E6909A5A419A999999A9482841000000C0919A5A4100000000B448284100000020929A5A419A999999B7482841000000E0939A5A4100000000BA48284133333333959A5A4133333333CA482841666666A6959A5A41CDCCCCCCD048284100000060969A5A4133333333D648284166666626979A5A4100000000EC482841666666A6989A5A4100000000FD482841666666C6999A5A419A99999916492841CDCCCCCC9A9A5A4166666666314928419A9999199C9A5A4166666666634928419A9999D99E9A5A41666666667049284100000000A09A5A419A999999B2492841CDCCCC0CA69A5A4100000000F1492841CDCCCC4CAA9A5A41000000001E4A284166666606AD9A5A41CDCCCCCC4A4A2841666666C6AF9A5A41CDCCCCCC774A284166666686B29A5A41CDCCCCCC8B4A284166666686B29A5A419A999999BD4A284133333373B29A5A419A999999EF4A284166666666B29A5A41CDCCCCCC084B284133333353B19A5A4133333333674B284166666646AD9A5A41000000008F4B284100000080A99A5A4100000000664B2841CDCCCCCC9B9A5A41CDCCCCCC6F4B2841666666C6969A5A4100000000A14B28419A9999798C9A5A419A9999992A4C28419A999959699A5A41666666662A4C28419A999919689A5A41CDCCCCCCDA4B2841000000A0669A5A41CDCCCCCCF44B2841666666864E9A5A41666666665F4C284133333373FB995A4166666666A14C284166666646FC995A419A999999094D284100000080FE995A41CDCCCCCC1C4D2841666666E6FA995A4133333333284E2841CDCCCCCCFA995A41333333332E4E28419A999979F6995A4100000000F54E2841666666E6E9995A4166666666EF4E2841666666A6E8995A4100000000D54E28419A999919E3995A4100000000C94E2841333333B3E0995A4133333333B74E284133333313DD995A419A999999A54E28419A999939D9995A4133333333944E284100000060D5995A419A999999864E284133333353D2995A419A999999784E284100000060CF995A41CDCCCCCC694E28419A999939CC995A41000000005A4E2841000000E0C8995A41333333334D4E2841CDCCCC0CC6995A4166666666424E2841666666C6C3995A41CDCCCCCC354E284100000020C1995A419A999999284E2841CDCCCC0CBE995A41CDCCCCCC1B4E284133333373BB995A41333333330F4E28419A999999B8995A4166666666FC4D2841666666A6B4995A41CDCCCCCCE94D2841CDCCCCCCB0995A4133333333D94D284166666626AD995A4100000000C94D2841666666E6A9995A4133333333BB4D2841333333D3A6995A4100000000AD4D2841666666E6A3995A419A999999A04D284133333333A1995A41CDCCCCCC944D2841CDCCCC8C9E995A41000000008A4D2841CDCCCCCC9B995A419A9999997F4D2841CDCCCCEC98995A4166666666784D28419A99999996995A4100000000714D2841333333B393995A41CDCCCCCC6E4D28410000002092995A4133333333684D2841333333538E995A419A999999624D2841333333738A995A41CDCCCCCC5C4D28419A9999F983995A419A999999504D2841000000C077995A4100000000444D2841333333736B995A4133333333334D28416666668663995A41666666661E4D2841CDCCCC8C5D995A419A999999FC4C28419A9999F956995A4166666666D84C28419A99995951995A419A999999B24C2841666666E64C995A4133333333294C2841333333734F995A419A999999B74B2841CDCCCC0C51995A4166666666084B28419A99999951995A41666666660E4A28410000000052995A4100000000664928410000004052995A4100000000214928419A99995952995A41666666669F482841000000A052995A416666666638452841000000C084985A41666666666744284133333373B0985A4100000000674028413333335384985A41333333337F4028419A999959F7975A4100000000CC3B2841333333F382975A41CDCCCCCCF93A2841CDCCCCEC7F975A41000000008A3A2841CDCCCC0C80975A41CDCCCCCC10392841333333D395975A413333333306392841CDCCCCEC90975A419A999999F2382841000000C08B975A4133333333DC382841666666A688975A41CDCCCCCC82382841CDCCCC0C80975A41CDCCCCCCDA372841CDCCCC2C6D975A419A999999C13728416666660669975A41CDCCCCCC58372841333333534C975A4166666666073728419A9999193C975A419A999999D7362841CDCCCC4C37975A41666666667E362841CDCCCCCC30975A410000000065362841666666462B975A4133333333443628419A9999F909975A41666666663236284100000000F9965A41666666662236284133333373EB965A419A999999F8352841CDCCCC0CF0965A4100000000DE352841666666C6F2965A41CDCCCCCCC8352841000000A0F4965A41CDCCCCCCB235284166666666F6965A4133333333A0352841666666C6F7965A41333333338C35284166666606F9965A419A9999997235284133333353FA965A4133333333443528419A999979FC965A41CDCCCCCCF03428419A99995900975A4166666666D4342841333333B301975A4133333333BA342841CDCCCC2C03975A41000000009E342841CDCCCC0C05975A41666666667A3428410000004007975A419A99999953342841000000000A975A41CDCCCCCC14342841000000A00E975A41333333338E3328416666662618975A419A99999961332841000000801B975A41CDCCCCCC433328419A9999191E975A41333333332E3328416666666620975A41CDCCCCCC1B332841CDCCCC6C23975A419A99999905332841333333D326975A4166666666E6322841666666A62B975A4133333333C43228413333331331975A413333333395322841666666E637975A419A999999823228419A9999B93A975A419A99999956322841CDCCCC6C41975A419A99999925322841666666A648975A4100000000F33128419A9999D94F975A4133333333C03128410000000057975A41CDCCCCCC8A312841000000A05E975A4133333333563128416666666666975A413333333325312841000000A06D975A4133333333FF3028410000004073975A41CDCCCCCCE83028416666666676975A4100000000D93028413333339378975A41CDCCCCCCC1302841CDCCCC6C7B975A419A999999853028413333335382975A4133333333443028413333339389975A41CDCCCCCC103028419A9999598F975A4133333333F72F28419A99991992975A4133333333DE2F28413333339394975A4100000000962F2841CDCCCCAC8D975A4133333333292F2841666666A68C975A4166666666812E28419A9999F98A975A4133333333C22D2841666666C687975A4100000000AE2D2841CDCCCC8C86975A4133333333492D28419A99993986975A4133333333182D28419A9999B986975A4166666666C52C28410000006086975A4166666666F32C28416666664695975A419A9999995B2C2841666666E69A975A4133333333C22B2841000000009E975A41CDCCCCCCF62B2841000000C0B9975A419A999999162C2841000000E0B7975A41666666666C2C2841CDCCCC0CB2975A419A999999B32C284100000080CB975A4166666666E12C284100000060D5975A41CDCCCCCCEE2C284133333393E2975A4100000000422D2841000000E033985A419A9999997D2D2841000000C077985A4133333333922D28419A9999D982985A4133333333B82D2841666666E68B985A41CDCCCCCC842D2841333333B399985A4166666666022D2841CDCCCC2CB0985A4133333333AC2C284100000080BF985A41CDCCCCCC752C284100000080C9985A4133333333862B284133333353F3985A41000000003A2B28419A99991904995A4133333333C52A2841666666C60E995A419A999999702A28419A9999F912995A4166666666EE292841333333F31C995A41	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	01010000206A08000070355BDE583928419A999969DE985A41	080150000	Z	Antheny	0801500	08015	08	44	10
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	01060000206A0800000100000001030000000100000018010000666666662E2D28416666668610925A4100000000662E2841CDCCCC0C26925A41CDCCCCCCB92F28413333337332925A410000000029322841333333B347925A416666666642332841333333B351925A419A999999F83328416666668656925A41CDCCCCCC2B3528419A9999F956925A4100000000B1352841CDCCCCCC5E925A410000000036362841000000406D925A419A99999968362841CDCCCCEC73925A416666666696362841000000C080925A419A999999D53628413333337386925A410000000040362841000000E08C925A41666666666E352841333333D390925A41000000006F3428419A99991991925A41CDCCCCCC42332841666666068D925A419A99999993322841CDCCCCAC87925A4166666666203228413333339382925A416666666667312841CDCCCC6C98925A41CDCCCCCCE130284133333373A5925A419A999999E4302841CDCCCC6CAD925A4100000000BF302841CDCCCC4CB4925A4166666666DC30284166666666B6925A41CDCCCCCCA931284133333313D8925A4166666666FA31284100000000E2925A4100000000F331284133333353EE925A41000000009B32284133333373F5925A4166666666903228419A99995913935A4133333333823228419A9999791E935A4166666666CD322841000000A021935A4133333333DB322841333333332A935A41CDCCCCCCF9322841CDCCCCAC31935A41000000009D332841000000C046935A419A999999103428419A9999595C935A41CDCCCCCC593428410000000068935A41CDCCCCCC66352841CDCCCC8C7E935A41CDCCCCCCFA352841000000A088935A4166666666463628419A99997990935A419A999999963628419A9999D9DE935A419A999999DF3628410000000004945A4133333333033728410000006012945A419A999999E13628419A9999B920945A419A999999CD3628410000004023945A4133333333CE362841000000002C945A416666666600372841333333332D945A419A99999990362841000000803B945A41CDCCCCCC2F3628410000002046945A419A999999CB352841666666A64F945A419A99999944342841333333B363945A413333333335342841CDCCCC6C70945A4100000000D33328416666668689945A4100000000B6332841CDCCCC0C96945A41CDCCCCCCCA33284166666686A2945A41CDCCCCCCCB33284100000080B1945A4100000000F633284166666606C0945A416666666623342841CDCCCC2CC8945A4100000000B633284100000020F6945A410000000037332841CDCCCC4C21955A41CDCCCCCC71332841CDCCCC4C27955A4100000000073428416666664634955A419A999999C23428413333335342955A410000000032352841666666064A955A413333333395352841666666C64F955A419A9999995F362841000000005A955A4166666666AB362841666666465F955A419A999999BA372841666666E676955A41CDCCCCCCEA362841666666E692955A4133333333C3362841000000409A955A4166666666B236284133333373A0955A4100000000CA362841666666E6B4955A419A999999B4362841666666A6C0955A419A99999911382841CDCCCC2CDB955A4166666666A3382841333333D3E8955A4100000000AA3928416666666612965A41CDCCCCCC0A3A28419A99991927965A419A999999C93A2841666666A61C965A4133333333E13B2841666666460F965A4166666666003C2841333333532B965A419A9999990A3C2841CDCCCCAC4A965A4133333333713C2841CDCCCC6C4B965A4100000000873C28419A99997941965A4133333333ED3C2841666666A63C965A41000000000F3D2841666666C633965A419A999999863D2841333333F325965A4166666666D13D28416666666624965A4100000000173E28419A99993920965A4166666666893E2841333333531B965A41333333335F3E2841CDCCCC6CED955A419A9999991E3E284133333353D2955A4166666666FB3D2841666666A6C6955A4100000000673E284166666686C0955A4166666666633E28419A9999F9AA955A4133333333533F284166666646AF955A4166666666643F284166666646AA955A419A9999998B402841666666A6B0955A41CDCCCCCC0D41284100000080B5955A41CDCCCCCC4941284133333373B5955A41333333336E412841666666E6A7955A4133333333C542284166666606B0955A4100000000F14228419A999979B3955A419A9999991143284133333373B3955A41000000004043284166666606A4955A41666666665F432841000000C093955A41000000009F4228419A9999D994955A4166666666184228410000006099955A419A99999985412841000000E08F955A419A999999F14028413333331384955A41CDCCCCCCC7402841000000607F955A41CDCCCCCCCF4028416666668674955A4166666666F34028413333339374955A41CDCCCCCC57412841333333F37B955A4100000000B54128419A9999598D955A4100000000DD412841CDCCCC8C8E955A419A999999044228410000004088955A41333333335E422841CDCCCCEC82955A4133333333014328419A9999D983955A4133333333374328419A99995986955A419A99999968432841333333738B955A419A999999E9432841000000A094955A4133333333234428416666662696955A413333333376442841000000009B955A4100000000DE442841CDCCCC2CA5955A41000000003045284133333353B5955A41666666665945284133333313B9955A4166666666C64528419A9999F9B8955A41CDCCCCCCE04528419A999939B1955A416666666632462841000000208D955A4133333333A6462841666666A693955A41333333336D47284133333313A1955A419A999999B547284166666686A6955A4100000000DA4828419A9999398E955A41CDCCCCCCF0482841CDCCCC2C93955A41000000000C492841000000A08F955A41CDCCCCCC3B492841333333F393955A410000000054492841000000C08E955A419A999999A4492841CDCCCC6C97955A4100000000F04928419A99995999955A4100000000314A2841666666C69E955A419A9999994A4A28419A999999A2955A41CDCCCCCC804A2841CDCCCC2C9D955A41CDCCCCCC3B4B2841CDCCCCCCB4955A4100000000B04B2841CDCCCC6CA5955A419A9999997A4B2841CDCCCCAC9B955A4166666666524B28419A9999B996955A4166666666CC4B2841000000808A955A41000000001B4D284100000020AE955A4166666666FE4D28419A999979BB955A4166666666124E284133333333BA955A4100000000044F2841CDCCCC0C7F955A4100000000D44E2841000000A079955A419A999999BF4E2841CDCCCC0C57955A41666666668D4E2841000000A054955A41666666666A4E2841CDCCCCEC28955A4166666666674E284133333333FD945A41666666667B4E2841CDCCCCECFB945A4100000000434F28419A999939F9945A41666666663F4F2841000000C0C4945A41333333330F4F28419A99995983945A41CDCCCCCC0B4E2841666666C689945A4133333333064E2841666666467F945A41666666663A4E2841000000007C945A4100000000A14D28419A99997925945A4100000000084E2841333333531A945A41CDCCCCCCE64C28413333339307945A4133333333104C2841000000C0FB935A4133333333D74B2841000000A0F9935A41000000004A4C2841CDCCCCACDB935A41666666669F4C2841666666A6D0935A41000000001C4D284166666666CC935A419A999999F74C2841666666C6B6935A4166666666A44C28419A99999988935A41CDCCCCCCEB4B28419A9999798D935A41333333337A4B2841333333B386935A4166666666074B2841000000E082935A41CDCCCCCC494B2841333333736F935A419A999999C94B28416666664650935A41666666669C4C2841333333933B935A41000000001F4C284100000000C8925A419A999999D04B2841CDCCCC0CC6925A4133333333D74B2841CDCCCC2CBB925A4100000000C34B28419A9999F9A7925A4166666666734B2841CDCCCC8C97925A4100000000464B28413333339390925A4133333333FE4A2841333333F39C925A4100000000D14A2841666666E698925A419A999999DC4A2841666666868A925A419A999999934A2841666666A685925A41000000000F4A28413333333380925A41333333337E4A28419A9999196F925A4166666666824A28419A9999D964925A41333333335F4A2841000000E055925A419A999999154A2841333333D345925A4166666666E14928410000004037925A41CDCCCCCCA4492841CDCCCC8C2E925A41CDCCCCCC564928419A99997928925A413333333391492841666666E613925A4166666666C04928410000000010925A4100000000D64928416666660606925A4166666666C949284133333333E2915A41000000006F4928419A999939D2915A41000000001949284100000020CC915A41CDCCCCCCD7482841666666A6C2915A4100000000914828419A999939B6915A41333333334E482841666666A6AE915A4100000000B7472841CDCCCCCCB7915A41CDCCCCCC4B47284166666606BC915A4100000000E3462841CDCCCC0CBF915A410000000098462841CDCCCC6CBF915A413333333323462841CDCCCC2CC7915A419A999999B245284100000020C6915A419A9999994445284100000040C6915A419A999999A844284166666646C5915A41666666669B44284100000080CF915A413333333371442841000000E0D1915A41CDCCCCCC14442841CDCCCC4CD4915A419A999999B243284133333313EF915A419A9999990F43284100000020E4915A419A999999B442284133333393D5915A41CDCCCCCC8D4228419A9999D9D4915A41333333337A422841000000A0D8915A41CDCCCCCCA242284133333393E2915A416666666698422841CDCCCC4CEB915A41666666666B4228419A999939EC915A4166666666D241284166666606F8915A4100000000CF412841CDCCCC2CFC915A419A999999054128410000002008925A410000000076402841666666E60D925A410000000043402841CDCCCC0C0F925A4100000000213F2841CDCCCCCC09925A41000000000F3F28410000004004925A41CDCCCCCCA53E2841CDCCCC0C02925A41000000005C3D284100000080EA915A4166666666343D2841CDCCCCCCF0915A4100000000293C2841CDCCCC4C15925A4133333333D03B28416666666623925A4100000000A53B28416666666624925A41333333333D3B28419A9999591E925A41333333330E3B28419A99993918925A41CDCCCCCCEB3A2841666666C610925A4133333333AF3A2841333333F3FF915A41666666666C3A2841CDCCCC4CEB915A419A999999463A2841666666C6E1915A4100000000263A284100000060D6915A41CDCCCCCCDC392841CDCCCCCCC5915A4166666666CB392841000000E0BF915A419A999999793928419A999999BE915A4133333333023928419A999979C7915A4100000000A9382841CDCCCC0CD3915A41666666664438284100000040EF915A4133333333123828419A999979FA915A416666666670372841666666C60C925A41333333334D3728416666668626925A419A999999B0362841CDCCCCCC1F925A410000000038362841CDCCCC6C18925A4100000000DE3528416666660616925A419A999999AB3528413333331311925A4100000000833528410000006008925A41CDCCCCCC50352841333333B304925A41000000001C35284100000040F8915A41666666660735284166666686EF915A41666666665134284100000080D0915A416666666642342841CDCCCCCCC4915A41333333335A342841666666A6B0915A41CDCCCCCC223428419A9999799D915A41CDCCCCCC98332841CDCCCC4C89915A41CDCCCCCC2C332841333333537E915A419A999999013328416666662678915A419A999999643228419A9999596C915A419A99999903322841CDCCCC0C7E915A416666666636312841000000209E915A4100000000B530284100000000A7915A4133333333312F284166666666C4915A41333333334C2E2841CDCCCCECD1915A419A999999CA2D284166666606D5915A4133333333412D28419A9999F9D9915A4166666666442D284133333393E5915A41000000003C2D284133333333F9915A4133333333302D2841666666E600925A41666666662E2D28416666668610925A41666666662E2D28416666668610925A41	01010000206A08000022D9FD716C41284134333343DD935A41	080160000	Z	Aouste	0801600	08016	08	44	13
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	01010000206A080000827892BA8BBA2941CCCCCC6C765A5A41	080170000	Z	Apremont	0801700	08017	08	44	13
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	01010000206A080000B63AA629312929419A999939E65A5A41	080180000	Z	Ardeuil-et-Montfauxelles	0801800	08018	08	44	4
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	01060000206A080000010000000103000000010000007600000066666666F98429419A9999B9C5775A413333333314872941000000A0EF775A41CDCCCCCC8C87294133333333F8775A419A999999FA8729410000002008785A416666666693882941666666E617785A4133333333898929416666664634785A419A999999758B2941666666E66D785A41CDCCCCCC218C2941CDCCCC4C80785A41CDCCCCCCBC8C2941333333B38B785A419A999999078D29419A99991992785A4100000000638D29419A9999B9A4785A4100000000D78D2941000000C0B2785A4100000000478E29419A9999D9BA785A4133333333318E29419A999979BE785A419A999999278E29419A9999F9C5785A419A9999997B8E29419A999959FF785A4100000000298F2941666666A615795A419A9999995B8F29419A9999D920795A41666666667A8F2941CDCCCC0C2C795A4100000000908F2941666666C643795A41CDCCCCCCE18F2941CDCCCCEC5C795A419A999999F68F29416666666669795A419A999999299029413333335378795A41CDCCCCCC06912941333333138C795A4100000000639129419A9999B98F795A410000000035922941000000C091795A41333333338D922941CDCCCC6C77795A419A999999F69229419A99995974795A41000000003D9329419A9999595D795A4133333333D89329419A9999D941795A419A9999994D942941CDCCCC8C32795A4100000000759529419A99991913795A4100000000F8942941CDCCCC4C09795A419A9999990E96294100000060E6785A41CDCCCCCCAD962941000000A0D8785A4133333333B5972941666666E6C3785A41000000001D9729413333331398785A41CDCCCCCC829629419A9999796A785A4166666666719629413333335366785A4166666666A8952941000000402E785A419A9999996B952941666666E61D785A4133333333D9942941333333F3F9775A4166666666AF942941CDCCCC6CF0775A41666666668A94294100000000E0775A41CDCCCCCC5A942941CDCCCCACD4775A419A99999909942941CDCCCC8CC7775A4100000000E593294100000000BE775A419A999999AA93294166666626AA775A419A99999997932941CDCCCC2CA0775A419A999999989329419A9999998E775A4100000000AA932941666666467C775A41CDCCCCCCB0932941000000E063775A419A999999C3932941666666264E775A4100000000D79329413333335329775A419A99999912942941CDCCCC6C17775A419A999999279429419A9999590F775A41CDCCCCCC1D9429416666666604775A419A999999EC93294100000000F7765A4133333333F59329419A9999F9EA765A4166666666DD93294100000080D3765A419A999999E3932941CDCCCCECC9765A41CDCCCCCC1C9429419A999939B5765A41000000005194294166666686A7765A410000000075942941000000A099765A419A9999997C942941333333B393765A4166666666759429419A99997980765A4166666666869429413333339373765A41CDCCCCCCCD9429413333333363765A410000000003952941CDCCCC4C52765A413333333313952941CDCCCC8C43765A41666666660C9529419A99991939765A419A999999F2942941000000A02D765A4166666666C49429410000002021765A413333333367942941666666A60F765A419A999999549429410000004003765A41000000005A94294133333333FB755A41666666667594294100000020F1755A419A999999D8932941CDCCCC0CE8755A410000000027932941333333F3DB755A419A999999EB92294133333393D8755A419A999999BF91294166666666D6755A41CDCCCCCCAB912941CDCCCC2CDA755A419A999999D7912941CDCCCC0CE7755A419A999999E7912941CDCCCCECEF755A4100000000F09129419A99995910765A4100000000059129413333331306765A41CDCCCCCCC19029410000006043765A4166666666349029413333339340765A416666666610902941CDCCCC6C5C765A4166666666A38F2941000000805B765A4166666666888F29419A9999D963765A419A999999E78E29410000004069765A41CDCCCCCC918E29419A9999796D765A4100000000C58D2941666666A674765A419A999999AF8D29419A99997980765A41CDCCCCCC7B8C2941CDCCCCEC94765A41CDCCCCCC398C2941CDCCCCCC98765A41CDCCCCCC678C294100000000A7765A419A999999A08B2941000000E0AF765A4100000000E78A2941CDCCCC8CB2765A4133333333DA8A29419A999939C7765A41CDCCCCCC488A2941CDCCCCCCC5765A41666666663D8A294100000040CF765A419A99999994882941333333F3D4765A419A999999BC8729419A999959E0765A41333333334F87294166666666DD765A4133333333378629419A9999B9D9765A41333333330B86294100000060F4765A419A999999D7852941CDCCCC8C0E775A4133333333D48529413333331322775A413333333306862941666666A635775A4133333333108629419A99995944775A41CDCCCCCC1F8629410000004070775A4166666666F0852941333333138A775A4166666666D78529419A9999799A775A416666666660852941666666A6B2775A4166666666F98429419A9999B9C5775A4166666666F98429419A9999B9C5775A41	01010000206A080000E6CAB6078B8C294133333353B8775A41	080190000	Z	Les Grandes-Armoises	0801900	08019	08	44	5
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	01010000206A080000FE9866F71E6729413333337374745A41	080200000	Z	Les Petites-Armoises	0802000	08020	08	44	4
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	01010000206A080000C469153ECA552841CCCCCC6C9D795A41	080210000	Z	Arnicourt	0802100	08021	08	44	8
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	01010000206A080000421FAE6EC7042941666666369D975A41	080220000	Z	Arreux	0802200	08022	08	44	4
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	01010000206A0800002085C5936B8C29419A9999193B7C5A41	080230000	Z	Artaise-le-Vivier	0802300	08023	08	44	8
01060000206A08000001000000010300000001000000FF02000000000000F3BB27413333335386715A41000000001ABD274100000000B9715A41CDCCCCCCF4BD2741CDCCCC0CDF715A413333333309BE2741CDCCCC6CDE715A41CDCCCCCC24BE2741CDCCCCACDC715A419A99999947BE27419A999919DA715A413333333374BE2741CDCCCCACD6715A4100000000A2BE27419A9999F9D3715A4166666666C8BE2741666666E6D1715A4166666666F2BE274166666686CF715A419A99999922BF2741CDCCCCECCC715A41CDCCCCCC4ABF274166666686CA715A419A9999996ABF2741666666C6C8715A410000000093BF2741CDCCCC8CC6715A41CDCCCCCCABBF274133333313C5715A41CDCCCCCCD9BF2741000000A0C2715A419A999999FDBF274166666686C0715A419A9999992BC02741333333D3BD715A410000000051C02741666666A6BB715A416666666675C02741000000A0B9715A419A9999998CC0274100000060B8715A41CDCCCCCC6AC22741CDCCCC4C2B725A41CDCCCCCC7BC227413333337330725A41CDCCCCCCEAC227413333337313725A413333333393C327416666660626725A410000000008C42741CDCCCCAC33725A419A999999A6C427419A99999949725A419A9999997CC52741333333F368725A419A999999CBC527419A99997972725A41666666668BC527410000006085725A419A99999981C527419A99995989725A4133333333C5C527419A9999D990725A41CDCCCCCC03C7274166666666A4725A419A9999994AC72741CDCCCC4CAB725A416666666694C727419A9999B9B0725A4133333333EEC7274100000060B7725A419A99999954C8274133333313BF725A41000000008BC8274100000020C3725A4133333333E2C827419A999999C9725A41CDCCCCCC40C92741000000A0D0725A419A999999A2C9274100000040D8725A419A9999991BCA2741CDCCCC8CE1725A41000000006BCA274133333393E7725A4133333333B2CA2741666666C6EC725A4133333333F7CA2741000000E0F1725A419A999999C4CA274133333313F4725A41000000008BCA27419A999959F6725A41000000005CCA2741CDCCCCCCF7725A413333333311CA2741666666E6F9725A4133333333F8C92741000000C0FA725A419A999999E8C927419A9999B9FB725A4166666666DAC927419A999979FD725A419A999999DFC92741000000A000735A41CDCCCCCC1ACA27413333333309735A41CDCCCCCC45CA2741333333530E735A41CDCCCCCC8CCA2741333333D319735A419A99999901CB2741666666E62B735A413333333390CB27413333337341735A4100000000CECB27419A99995949735A4166666666E6CB2741CDCCCC4C51735A419A99999910CC2741333333D353735A41333333339DCC27419A99999956735A416666666604CD2741CDCCCC0C59735A419A9999996ECD2741333333135A735A419A9999996CCD2741333333936B735A413333333387CD2741666666C66B735A4100000000B9CD2741666666466C735A419A9999991CCE2741333333336D735A41CDCCCCCC63CE2741333333F36D735A410000000096CE2741333333F36D735A4133333333CECE2741000000206E735A4166666666F7CE27419A9999596F735A416666666625CF27410000004071735A410000000038CF2741666666E671735A41666666664DCF2741666666E672735A41333333336CCF27419A99997974735A419A9999998ECF27419A99991976735A419A999999AFCF2741000000C077735A41CDCCCCCCCBCF2741CDCCCCEC78735A4100000000F4CF27419A9999B97A735A416666666627D02741333333137D735A416666666655D02741000000207F735A410000000078D02741000000E080735A413333333397D027416666664682735A4166666666B9D02741333333D383735A4100000000DBD02741CDCCCC6C85735A419A999999FAD027416666666687735A419A99999905D12741CDCCCCAC88735A4133333333F9D02741333333B38A735A4166666666E9D02741333333B38C735A4166666666C5D027419A99993991735A4100000000AED027416666666694735A413333333399D027419A9999F996735A413333333387D027419A99995999735A41666666666DD02741CDCCCC8C9C735A410000000059D02741000000809F735A410000000048D027419A9999F9A1735A41333333333BD0274166666646A4735A41666666662DD02741000000C0A6735A419A99999921D02741333333B3A8735A416666666618D027419A9999F9AA735A41666666660CD0274166666666AD735A419A99999902D02741000000A0AF735A4100000000F9CF27419A9999F9B1735A4133333333EFCF274133333393B4735A41CDCCCCCCE4CF27419A999979B7735A4100000000DACF27419A999919BA735A4133333333D0CF2741CDCCCCECBC735A4166666666C5CF27419A9999B9BF735A41CDCCCCCCB9CF274133333353C2735A4133333333AECF2741666666E6C4735A4100000000A2CF2741CDCCCC4CC7735A41CDCCCCCC95CF274166666646C9735A416666666657D1274133333373E5735A41CDCCCCCC18D32741000000A001745A4100000000B1D427416666668638745A413333333349D62741666666666F745A4100000000C7D62741000000805F745A419A9999992CD727419A99991955745A41CDCCCCCC13D72741CDCCCCAC50745A419A99999957D827419A99995924745A4100000000E4D82741CDCCCCEC04745A4100000000E6D827413333337304745A419A999999E8D82741000000A004745A4133333333FAD82741CDCCCCEC05745A419A999999FED82741CDCCCCAC04745A41CDCCCCCC5CD9274133333393EA735A419A99999979D927419A999939EB735A416666666689D92741CDCCCCCCE6735A410000000094D9274100000060E3735A41CDCCCCCC9ED9274166666606E1735A4100000000A9D92741666666E6DE735A4133333333B9D92741000000A0DB735A4133333333C9D927419A999959D8735A4100000000DCD927419A9999F9D4735A4133333333F1D92741CDCCCCECD0735A416666666600DA27419A9999D9CD735A41000000000FDA2741CDCCCCACCB735A410000000023DA274166666606C9735A410000000036DA2741333333B3C5735A410000000042DA274100000060C3735A410000000057DA2741CDCCCCACC0735A41666666666ADA27419A999979BE735A41CDCCCCCC82DA274166666686BB735A41000000009FDA2741666666A6B8735A41CDCCCCCCBADA27419A999999B6735A4166666666CCDA2741CDCCCCACB4735A41CDCCCCCC09DB2741000000E0B1735A419A9999990BDB274133333313B0735A410000000014DB274100000080AC735A41CDCCCCCC1BDB2741333333D3A8735A410000000067DB2741000000809E735A41CDCCCCCC98DB2741CDCCCCEC92735A41000000009CDB2741333333938F735A41333333339DDB2741000000808C735A419A9999999EDB27410000000088735A41CDCCCCCC9EDB27419A99995984735A41CDCCCCCC9CDB27419A9999B980735A416666666698DB2741666666E67C735A419A99999994DB27410000008079735A416666666691DB2741CDCCCC6C77735A419A99999989DB2741CDCCCC8C73735A413333333377DB27419A9999796C735A41000000007CDB27419A99997967735A4166666666A2DB27413333331364735A41CDCCCCCCC4DB27416666662650735A4133333333DEDB2741333333534B735A4133333333E6DB2741333333134A735A4166666666F1DB27410000004046735A4100000000FBDB27419A9999993F735A41CDCCCCCC03DC27419A99997939735A419A9999991ADC2741333333532F735A419A99999924DC27419A9999192D735A41666666663DDC27410000008029735A41CDCCCCCC5DDC2741000000E026735A413333333385DC27416666666626735A41CDCCCCCCA0DC27419A99991927735A41CDCCCCCCB5DC27416666666627735A4100000000C9DC2741CDCCCC0C27735A419A999999D0DC27419A99993926735A4166666666D1DC2741CDCCCC2C25735A4166666666CFDC27410000002024735A4133333333B1DC27413333333320735A419A99999992DC2741666666261A735A41CDCCCCCC7BDC2741666666A617735A41CDCCCCCC6FDC27419A99997915735A41666666666DDC2741CDCCCC6C14735A41333333336EDC2741000000C012735A413333333372DC27410000008011735A41CDCCCCCC78DC27419A99993910735A41000000008FDC2741666666660E735A419A999999C3DC2741333333330D735A419A999999EDDC2741CDCCCCAC0B735A416666666602DD2741333333F308735A41666666660EDD2741CDCCCC6C04735A41CDCCCCCC15DD2741666666C600735A416666666611DD27419A9999B9FD725A41CDCCCCCC08DD27419A999999FA725A41CDCCCCCCFDDC2741CDCCCC4CF8725A41CDCCCCCCF3DC274100000080F7725A4133333333E6DC2741CDCCCC2CF7725A4166666666D6DC274166666686F7725A4133333333CDDC274133333393F8725A4166666666C8DC27419A9999B9F9725A4166666666C2DC274133333353FB725A41CDCCCCCCBCDC2741000000E0FC725A4100000000B7DC274100000040FE725A419A999999AFDC274133333313FF725A41CDCCCCCCA3DC2741CDCCCC6CFF725A41333333339DDC27419A999939FF725A413333333397DC27419A9999D9FD725A413333333395DC27419A9999D9FA725A416666666699DC2741CDCCCCECF8725A4166666666B7DC274166666686EE725A4133333333BADC274133333313E7725A4166666666B0DC274133333393DD725A410000000090DC274133333333D4725A41000000007DDC2741CDCCCCACCC725A41CDCCCCCC5CDC2741CDCCCC6CC6725A410000000029DC274133333353BE725A419A99999919DC2741CDCCCC4CB7725A416666666604DC2741CDCCCCCCAD725A41CDCCCCCCC7DB27419A9999F9A4725A41CDCCCCCC6FDB27419A9999B998725A410000000042DB27413333337392725A419A9999990DDB2741333333D38B725A4166666666EFDA27416666664684725A4166666666D2DA27419A99993981725A419A999999CADA27419A9999F97F725A41CDCCCCCCC4DA27419A9999D97E725A4100000000C4DA2741CDCCCC2C7D725A4133333333C5DA2741CDCCCCAC7B725A4166666666CADA27416666662678725A419A999999E3DA27410000006070725A419A999999FFDA2741666666A669725A41CDCCCCCC0FDB2741CDCCCCAC65725A41666666661ADB27419A99991962725A419A99999935DB2741CDCCCC4C5F725A416666666647DB27419A99991957725A41333333334FDB27419A9999394C725A41333333335BDB27410000000045725A419A9999995CDB2741000000C042725A410000000051DB2741CDCCCC2C41725A41CDCCCCCC36DB2741000000E03F725A41CDCCCCCC22DB2741666666463E725A41333333331ADB2741333333B33D725A419A9999990DDB27419A9999393C725A410000000006DB2741CDCCCCAC3A725A416666666602DB2741333333F337725A41666666660BDB27416666666636725A416666666620DB27419A99997934725A41333333332FDB27419A99995932725A410000000030DB2741CDCCCCCC30725A41666666662DDB2741333333532F725A413333333323DB2741000000E02D725A41CDCCCCCC14DB2741666666862C725A416666666607DB27419A9999992B725A41CDCCCCCCFADA2741CDCCCC0C2A725A41CDCCCCCCF5DA27416666664628725A41CDCCCCCCF8DA27413333331326725A410000000001DB27410000002023725A410000000000DB27419A99995921725A4133333333FDDA2741CDCCCC6C1E725A4166666666F1DA2741666666461D725A4100000000E0DA2741CDCCCC4C1D725A4133333333CADA2741666666A61D725A4133333333BFDA2741666666461E725A4100000000B2DA2741333333D31E725A41CDCCCCCCA8DA2741CDCCCC8C1F725A41000000009DDA2741333333931F725A416666666696DA2741666666861E725A416666666695DA2741CDCCCC2C1C725A416666666699DA2741333333B319725A4166666666A7DA2741666666C616725A4100000000B8DA2741000000E012725A4166666666BDDA2741333333F30D725A4166666666C6DA2741666666E60A725A4100000000D1DA27413333339308725A4166666666E7DA27410000008005725A419A999999F9DA27416666666603725A41CDCCCCCC08DB2741000000C002725A410000000017DB27419A9999D902725A41666666661ADB2741000000A004725A41333333331CDB27419A99991906725A41CDCCCCCC22DB27416666660607725A41CDCCCCCC2DDB27419A99991907725A41666666663ADB2741333333B306725A410000000051DB274133333333FC715A410000000051DB2741CDCCCCACF9715A419A9999994CDB274133333353F8715A41666666663DDB274133333373F6715A413333333333DB274100000060F4715A41000000002EDB27419A9999B9F2715A41333333332DDB274133333373F1715A41CDCCCCCC22DB274100000000DE715A410000000087DB2741CDCCCCECDD715A41CDCCCCCCD1DB2741CDCCCCCCDD715A41CDCCCCCC01DC2741000000C0DD715A419A9999991FDC274133333313DD715A41CDCCCCCC3EDC274100000080DB715A410000000053DC274100000040DA715A41666666666ADC2741CDCCCCECD7715A41000000007FDC27419A9999D9D4715A41666666668BDC2741666666C6D0715A416666666694DC274166666666CA715A419A9999999ADC2741CDCCCC8CC4715A4100000000A1DC2741CDCCCC2CC1715A41CDCCCCCCAADC274133333393BE715A41CDCCCCCCBADC27419A9999D9BC715A4133333333D0DC274166666626BB715A419A999999E7DC274133333333BA715A413333333301DD274166666666B9715A410000000021DD274166666626B9715A41000000003DDD2741CDCCCC6CB9715A410000000064DD2741333333D3BA715A41CDCCCCCC98DD2741666666A6BC715A419A999999B0DD274166666646BD715A419A999999EFDD2741666666C6BD715A41333333330ADE2741CDCCCC6CBD715A410000000023DE274133333353BC715A41000000003DDE2741666666A6BA715A413333333354DE274100000060B8715A41CDCCCCCC67DE27419A9999D9B4715A410000000070DE274166666606B2715A419A99999970DE2741666666C6AE715A41666666666CDE274133333393AB715A41CDCCCCCC62DE274166666606A8715A410000000052DE2741CDCCCCACA3715A413333333337DE2741333333939D715A410000000022DE27419A99999998715A410000000014DE2741333333B393715A41333333330FDE2741333333538D715A410000000010DE27416666660689715A41CDCCCCCC14DE27419A99995986715A419A9999991EDE2741CDCCCCEC83715A41000000002ADE27410000002082715A413333333334DE27410000000081715A410000000051DE27419A9999B97F715A419A9999996ADE27419A9999597F715A410000000085DE2741CDCCCC6C7F715A419A99999997DE2741666666C67F715A4133333333B7DE2741CDCCCCCC81715A4100000000D6DE2741666666A684715A419A999999FCDE2741CDCCCC2C89715A41CDCCCCCC1DDF2741333333D38C715A410000000034DF2741666666268E715A419A99999946DF2741666666C68E715A41CDCCCCCC63DF2741CDCCCCCC8E715A41000000007ADF2741000000408E715A413333333395DF27419A9999998C715A4166666666BEDF2741CDCCCC8C89715A4100000000DADF27410000002086715A419A999999F5DF2741CDCCCC2C81715A413333333312E02741000000807A715A413333333327E027419A99993975715A41666666663BE02741666666A671715A41CDCCCCCC53E02741333333F36E715A416666666678E02741333333D36C715A41CDCCCCCC93E02741CDCCCCAC6B715A4100000000C3E02741000000A06B715A41CDCCCCCCE3E02741CDCCCC6C6C715A41666666660DE12741666666466F715A41666666662EE127416666666672715A41CDCCCCCC3CE12741000000C074715A416666666640E127419A9999D977715A41CDCCCCCC40E12741666666867A715A41000000003DE127419A9999597D715A413333333332E12741000000A07F715A410000000021E127410000008081715A419A999999FCE027410000006083715A4100000000DEE027419A9999B984715A4100000000BAE027410000008086715A419A99999994E027416666660689715A41CDCCCCCC68E02741333333338D715A413333333346E027419A9999B990715A41333333331BE027416666664696715A410000000001E02741666666869A715A419A999999E6DF274100000040A0715A41CDCCCCCCDCDF2741000000A0A3715A4133333333DBDF2741666666C6A6715A41CDCCCCCCDEDF274166666606AA715A4133333333E6DF2741CDCCCC8CAD715A4133333333FCDF274133333373B6715A41666666660BE0274166666666BB715A413333333317E02741666666A6C1715A41000000001DE027419A9999D9C5715A419A99999919E02741000000E0D1715A419A99999917E02741CDCCCC0CDA715A416666666618E02741000000C0DC715A41333333332BE02741000000E0E1715A419A99999953E02741CDCCCCCCEA715A41CDCCCCCC80E02741CDCCCC0CF3715A41CDCCCCCCA7E027419A999999F8715A41CDCCCCCCD1E02741CDCCCC4CFD715A419A999999F6E027410000006000725A410000000018E127410000006002725A410000000045E127416666662604725A410000000087E127416666666605725A41CDCCCCCCB7E127419A99995906725A4100000000E0E127416666668606725A41CDCCCCCCF9E127410000006006725A410000000014E22741CDCCCCEC05725A41CDCCCCCC38E227416666664604725A410000000069E227419A99993901725A41666666667CE2274133333333FF715A41666666668CE2274166666686FD715A41CDCCCCCC9EE2274166666686FA715A41CDCCCCCCAAE22741000000E0F7715A4133333333B2E2274100000040F5715A4166666666B4E2274100000060F1715A4166666666B6E22741000000E0EC715A4166666666B8E22741666666C6E8715A4166666666B9E22741000000A0E6715A4166666666BDE2274100000020E1715A4100000000C2E227419A999939DB715A4166666666CDE227419A999939D7715A41CDCCCCCCDEE22741CDCCCCECD3715A419A999999F5E227419A999959D1715A419A99999920E327419A9999D9CD715A416666666611E32741333333B3C8715A413333333366E32741333333D3B3715A416666666613E3274166666626AC715A419A999999E7E227419A999959A7715A4100000000E7E22741333333339F715A41000000000CE32741000000C096715A413333333351E32741CDCCCC2C8A715A4133333333BAE32741CDCCCCEC73715A410000000077E32741000000E06A715A41CDCCCCCC52E327419A99995963715A4133333333E0E22741333333135D715A41CDCCCCCCE1E227419A9999395A715A4100000000E3E227410000000058715A41CDCCCCCCE4E227419A99997955715A4133333333F2E227413333335340715A4133333333EFE22741333333B33C715A4133333333DBE22741CDCCCC8C1F715A410000000062E227416666664620715A410000000068E22741333333D31A715A416666666693E227419A9999391A715A419A9999998EE22741CDCCCC8C15715A41CDCCCCCC51E327416666660613715A41CDCCCCCC9AE327419A99995913715A419A999999E8E32741333333130E715A413333333372E427419A9999990F715A4166666666B3E427413333335310715A419A999999B4E427419A99995909715A4133333333BCE42741666666A605715A41CDCCCCCCDBE42741CDCCCC0CF7705A4100000000FAE42741CDCCCC8CEC705A419A99999943E4274133333373E8705A41CDCCCCCC47E52741333333D37C705A41CDCCCCCC3DE62741CDCCCC4C85705A4100000000ECE62741CDCCCCCC8D705A41000000001EE72741CDCCCCCC90705A419A99999924E72741000000C090705A41333333334FE72741333333D392705A41CDCCCCCC78E727419A99991995705A413333333387E727410000006095705A41CDCCCCCC8FE72741CDCCCC4C95705A410000000096E72741000000E094705A4133333333A5E72741333333738F705A4133333333C0E72741CDCCCC2C85705A4166666666E2E72741CDCCCC6C77705A419A99999905E827419A99999969705A41CDCCCCCC1AE82741CDCCCCAC60705A419A99999938E82741666666C656705A410000000055E82741000000A04E705A410000000074E82741CDCCCC0C47705A413333333399E827419A9999793D705A41CDCCCCCCCEE82741333333732E705A419A999999F6E82741CDCCCCEC23705A419A99999922E92741CDCCCC0C19705A41000000004DE92741000000400E705A41CDCCCCCC8BE92741CDCCCCACFD6F5A4166666666C1E927419A9999D9EF6F5A4100000000E8E92741CDCCCC2CE66F5A413333333304EA274133333333DE6F5A41CDCCCCCC27EA274100000020D36F5A41000000004FEA274133333373C76F5A41CDCCCCCC70EA274166666686BD6F5A41CDCCCCCC69EA2741666666C6BA6F5A41CDCCCCCC77EA274133333373BB6F5A41CDCCCCCCBBEA2741333333D3BE6F5A4100000000FCEA274166666606C26F5A41CDCCCCCC4FEB2741CDCCCC2CC66F5A41000000009DEB2741000000E0C96F5A4166666666E9EB274100000080CD6F5A413333333323EC274166666666D06F5A413333333337EC27419A999979C86F5A41CDCCCCCC5FEC27419A999959BB6F5A419A999999F5EC2741CDCCCCCC866F5A416666666614ED2741333333337C6F5A413333333334ED2741000000C0706F5A41CDCCCCCC5BED2741CDCCCC2C646F5A416666666690ED2741333333B3566F5A4100000000BCED27419A9999394B6F5A4166666666E9ED2741333333933F6F5A410000000013EE274166666666356F5A41CDCCCCCC35EE2741CDCCCC6C2C6F5A413333333358EE274100000020246F5A419A99999985EE2741CDCCCC2C186F5A41CDCCCCCCB7EE2741CDCCCCAC0B6F5A4133333333C1EE2741CDCCCC4C0A6F5A41CDCCCCCCCBEE2741CDCCCC0C0A6F5A4100000000DFEE2741666666860A6F5A41333333332BEF2741000000E00D6F5A419A9999997EEF2741CDCCCC4C116F5A4133333333D2EF2741000000E0146F5A416666666613F02741CDCCCC8C176F5A416666666656F027419A9999591A6F5A41666666669AF02741CDCCCC4C1D6F5A4100000000D7F02741666666A61F6F5A4100000000E2F0274133333373206F5A41CDCCCCCCF8F0274166666606216F5A41666666660AF127419A999939216F5A410000000011F12741CDCCCCEC206F5A419A99999915F1274166666606206F5A416666666616F12741CDCCCC6C1E6F5A416666666616F12741666666C61A6F5A410000000016F12741CDCCCCCC106F5A419A99999914F1274133333373066F5A41CDCCCCCC14F12741666666C6026F5A419A99999913F12741CDCCCCCCF56E5A413333333314F1274166666626E96E5A410000000013F12741333333D3DF6E5A419A99999912F1274133333393DE6E5A410000000016F12741CDCCCC4CDE6E5A41000000001EF1274133333313DE6E5A416666666656F12741CDCCCC2CDD6E5A4100000000A1F1274100000040DC6E5A4166666666D3F127419A999979DB6E5A41CDCCCCCCD9F12741333333D3DA6E5A4100000000DEF12741666666E6D96E5A4100000000DEF12741666666E6D86E5A4166666666B9F1274133333333CC6E5A419A99999994F12741CDCCCC2CBF6E5A416666666666F1274166666686AE6E5A419A99999948F12741333333F3A26E5A41333333332AF12741333333B3976E5A410000000029F12741CDCCCC8C966E5A419A9999992DF12741666666E6956E5A416666666637F12741000000A0956E5A413333333370F12741CDCCCCAC976E5A4166666666BBF12741666666269A6E5A41333333331EF22741CDCCCC8C9D6E5A416666666676F22741CDCCCC8CA06E5A4166666666C2F2274133333313A36E5A4166666666EFF22741000000A0A46E5A41CDCCCCCC00F32741666666A6A46E5A410000000010F327419A999919A46E5A4166666666F6F22741CDCCCCEC9A6E5A4166666666DDF227419A9999D9916E5A4166666666C2F22741CDCCCC0C886E5A4100000000AAF22741CDCCCC4C7F6E5A41000000009BF22741666666A6796E5A41CDCCCCCC92F22741333333F3756E5A41CDCCCCCC8DF2274100000040726E5A41CDCCCCCC8DF227419A9999996E6E5A419A99999991F22741666666C6696E5A419A999999A0F22741666666A6606E5A41CDCCCCCCB0F2274166666666566E5A4133333333BDF22741666666664E6E5A419A999999D5F227419A9999794F6E5A41CDCCCCCCF5F22741333333B3506E5A419A99999938F3274133333373536E5A410000000096F32741000000C0576E5A41CDCCCCCCF9F32741333333535C6E5A416666666657F4274133333393606E5A4166666666B3F42741333333D3646E5A416666666616F5274133333353696E5A419A999999A8F52741666666E66F6E5A416666666686F62741CDCCCCEC196E5A41333333337FF52741333333F3046E5A419A999999BFF42741333333B3F36D5A41CDCCCCCCBCF4274133333393EB6D5A4100000000C7F42741CDCCCCECDF6D5A4133333333DDF4274166666606CF6D5A41CDCCCCCCA6F42741CDCCCC0CC86D5A41CDCCCCCCACF32741000000E0B46D5A4133333333A8F3274133333353B36D5A4133333333A4F32741CDCCCCECB16D5A410000000094F3274100000080AE6D5A410000000079F32741CDCCCC6CA96D5A419A9999993EF3274100000060A86D5A419A999999F3F227419A999939A66D5A41CDCCCCCC9CF227419A9999F9A36D5A410000000032F2274100000060A16D5A4133333333ACF12741000000209E6D5A413333333348F12741000000C09B6D5A419A999999E8F0274133333353996D5A41CDCCCCCC87F027419A9999F9966D5A41CDCCCCCC26F027419A999999946D5A419A999999B5EF2741000000C0916D5A413333333325EF2741000000408E6D5A419A999999D0EE2741666666268C6D5A416666666679EE2741CDCCCCEC896D5A419A99999913EE274133333373876D5A41CDCCCCCCBBED274133333393856D5A41666666667FED27419A999939846D5A41CDCCCCCC68ED274100000060836D5A413333333351ED27419A9999F9816D5A41333333331AED274100000080816D5A419A999999C4EC2741000000C0806D5A41CDCCCCCC6AEC274133333313806D5A41CDCCCCCC0BEC27419A9999397F6D5A4166666666B5EB2741666666867E6D5A416666666653EB27419A9999997D6D5A4133333333F2EA27419A9999D97C6D5A419A99999988EA2741666666E67B6D5A419A9999991AEA2741333333137B6D5A41666666669FE92741000000007A6D5A413333333319E92741333333D3786D5A4100000000A4E82741000000E0776D5A41333333334BE827419A999939776D5A41333333331FE82741000000E0766D5A413333333314E8274100000060766D5A41000000000EE82741CDCCCC8C756D5A410000000009E8274133333333746D5A413333333305E82741CDCCCCAC7A6D5A4100000000F6E7274133333393956D5A41666666668DE327419A9999B9846D5A410000000076E02741666666E6786D5A410000000070E0274166666606846D5A41666666666AE0274133333313906D5A41CDCCCCCC67E02741666666A6916D5A413333333362E02741333333F3926D5A41CDCCCCCC3BE02741333333F3956D5A4133333333FFDF27419A9999399A6D5A4100000000C0DF27419A9999B99E6D5A416666666689DF274133333393A26D5A410000000041DF2741CDCCCC6CA76D5A419A999999F9DE274166666646AC6D5A419A999999ACDE27419A9999D9B16D5A41000000006EDE274100000020B66D5A413333333313DE274166666666BC6D5A419A999999B2DD274100000000C36D5A416666666685DD2741333333F3C56D5A419A99999956DD274100000000C96D5A41CDCCCCCC26DD2741CDCCCC6CCC6D5A4166666666E0DC27419A999919D16D5A41333333339DDC2741000000A0D56D5A41666666665CDC274166666606DA6D5A410000000022DC2741000000C0DD6D5A419A999999FBDB274166666646E06D5A4133333333F1DB2741CDCCCCECE06D5A41666666660DDC27419A999999E36D5A41333333332CDC274166666626E66D5A41CDCCCCCC50DC274166666646E96D5A419A9999997DDC27419A999919ED6D5A4100000000B3DC27419A9999B9F16D5A419A999999E3DC2741333333F3F56D5A413333333329DD2741333333B3FB6D5A419A99999963DD27419A9999B9006E5A419A99999998DD274133333313056E5A41CDCCCCCCD0DD2741CDCCCC0C0A6E5A41666666660CDE27419A9999190F6E5A41CDCCCCCC55DE274133333353156E5A4100000000B3DE2741000000801D6E5A4166666666F1DD27419A999959306E5A4166666666BDDC2741CDCCCCEC496E5A41CDCCCCCCBADB2741CDCCCC2C5E6E5A41CDCCCCCCEED72741333333D3AF6E5A4100000000A0D72741CDCCCC2CB66E5A41CDCCCCCC38D72741000000A0AA6E5A41CDCCCCCC25D72741666666A6AA6E5A419A999999F9D627419A999999AB6E5A4100000000DFD62741000000A0B06E5A413333333375D5274100000060ED6E5A41CDCCCCCCA5D427419A9999B9106F5A41666666668BD42741CDCCCC4C176F5A41000000000CD42741000000A0016F5A419A999999E2D3274166666686056F5A4100000000E9D02741666666A6606F5A4133333333D5D0274100000060626F5A4100000000D1CF2741CDCCCC6C826F5A4100000000C6CF274133333333806F5A4166666666BACF274100000000806F5A41CDCCCCCCB0CF2741CDCCCC2C806F5A41666666669CCF2741CDCCCC8C826F5A41CDCCCCCC52CF27419A9999798B6F5A41333333331ECF274166666606926F5A4100000000CACE2741333333339C6F5A416666666669CE274166666626A86F5A410000000013CE2741333333B3B26F5A4100000000EDCD2741000000A0B76F5A4133333333C4CD2741CDCCCCECB76F5A4166666666A3CD27419A9999D9B86F5A419A99999974CD2741000000A0B16F5A4133333333FBCC2741CDCCCC2CBC6F5A410000000013CD27419A9999F9C16F5A41333333330FCD27419A999939C66F5A41CDCCCCCCE2CC27419A999959CB6F5A4133333333C7CC27419A999939CD6F5A41000000008CCC27419A9999F9CF6F5A41333333336CCC2741CDCCCC2CD36F5A41CDCCCCCC5FCC274100000040D86F5A416666666662CC27419A999939DC6F5A410000000061CC2741CDCCCCACDD6F5A41666666665DCB2741CDCCCC2CFC6F5A41666666665CCB2741CDCCCCAC00705A41666666666ECB2741000000C003705A410000000072CB27410000006004705A416666666690CB27419A99997909705A419A9999999ACB2741000000400B705A419A999999F9CA27419A99999919705A4133333333E9C92741CDCCCC2C33705A41CDCCCCCC1EC927416666662640705A4100000000DFC82741000000804E705A41CDCCCCCCD6C827413333331350705A4100000000B8C827410000002052705A41000000007FC827419A9999B955705A416666666657C827419A9999F957705A4166666666FCC72741666666065E705A4100000000E6C727413333331360705A4100000000B2C727416666662663705A41000000007AC727413333335366705A41333333332BC72741333333936A705A419A99999910C72741000000E06B705A4133333333E2C627419A9999396E705A41CDCCCCCCB2C627416666660671705A41CDCCCCCC7DC62741CDCCCC4C74705A41000000004BC627413333335377705A410000000016C62741CDCCCC8C7A705A4166666666E8C52741666666467D705A4133333333B7C527419A99995980705A413333333385C527416666668683705A419A99999932C52741666666A688705A416666666616C52741CDCCCC4C8A705A4133333333EAC427419A9999198D705A419A999999C1C427419A9999398F705A4133333333A1C427419A9999F990705A41333333337DC427410000008092705A419A99999950C42741CDCCCC0C94705A41CDCCCCCC24C42741CDCCCC6C95705A4166666666FFC32741333333B396705A41CDCCCCCCCDC327419A99995998705A41CDCCCCCC96C32741666666869A705A419A99999965C32741CDCCCC6C9C705A416666666633C32741666666269E705A416666666608C327419A9999999F705A41CDCCCCCCD6C2274100000060A1705A41333333338EC22741666666E6A3705A416666666654C2274100000020A6705A41CDCCCCCC21C22741CDCCCCECA7705A4166666666EAC12741000000E0A9705A419A999999BEC1274166666666AB705A41333333338EC1274133333353AD705A41666666667EC12741333333F3AD705A41CDCCCCCC8DC127419A9999B9B1705A419A9999999EC1274133333353B6705A4100000000B3C1274166666686BB705A419A999999CBC127419A999919C2705A4100000000E3C12741CDCCCC8CC8705A41666666660BC22741CDCCCC2CD3705A416666666626C22741000000C0DA705A419A9999993FC2274100000020E1705A41CDCCCCCC62C22741CDCCCC8CEA705A4166666666A3C22741666666E6FB705A41666666664AC227410000008000715A41333333334ABC27416666662630715A41CDCCCCCC44BC27413333337336715A413333333337BC27416666660646715A419A9999992DBC2741000000C050715A410000000027BC2741000000A058715A41CDCCCCCC22BC27419A9999795D715A41CDCCCCCC23BC27410000006060715A4100000000F3BB27413333335386715A41	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	01010000206A08000046BCDC58B4D32741CDCCCCCCF1705A41	080240000	Z	Asfeld	0802400	08024	08	44	22
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	01010000206A0800003383CBE2FFE22841343333C35E715A41	080250000	Z	Attigny	0802500	08025	08	44	12
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	01010000206A080000D2CBD8C773802841666666D690905A41	080260000	Z	Aubigny-les-Pothées	0802600	08026	08	44	15
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	01010000206A08000082A43E4AE4A22841CCCCCCCC1D7A5A41	080270000	Z	Auboncourt-Vauzelles	0802700	08027	08	44	5
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	01060000206A080000010000000103000000010000001301000066666666252B2941CDCCCCECB5B45A419A9999998A2B294100000020BCB45A4166666666202C29419A9999B9BBB45A4166666666192D294133333353B8B45A419A999999DE2D29419A999999BBB45A4133333333F72E294133333373BFB45A419A9999993F30294133333393CBB45A413333333359312941CDCCCC4CDCB45A41CDCCCCCC1C32294166666686F2B45A41000000004E3229419A9999D9F8B45A41CDCCCCCCA6322941666666A604B55A410000000054332941333333931AB55A41333333339F332941CDCCCC8C27B55A4133333333A63329416666664633B55A41CDCCCCCC8E332941000000E041B55A413333333353332941CDCCCC2C48B55A4166666666CA3229413333339356B55A4133333333B8312941CDCCCCCC62B55A41CDCCCCCCC73029410000006073B55A41CDCCCCCC363029410000008077B55A41CDCCCCCCB52F2941000000C07DB55A41000000002B2F29410000006081B55A419A999999922E2941CDCCCC4C84B55A419A999999742E29419A9999398AB55A41000000008B2E29413333337393B55A419A9999996D2E29419A9999B99DB55A4166666666122E29419A999919A6B55A41CDCCCCCCCF2D2941000000A0BAB55A41CDCCCCCC002E29419A999939C2B55A419A9999991E2E294100000000DFB55A41666666664B2E294100000040E6B55A41CDCCCCCC7F2E2941CDCCCC2CE7B55A419A999999AC2E29419A999999EAB55A4133333333992E29419A9999B9ECB55A419A999999672E294166666646F1B55A4100000000252E29419A999979F2B55A4166666666152E2941000000C0F2B55A41CDCCCCCC052E29419A9999B9F2B55A4100000000FC2D2941CDCCCCCCF2B55A419A999999CF2D2941CDCCCC8CFCB55A41CDCCCCCC0D2E2941666666A609B65A419A999999532E2941333333D30FB65A41666666668E2E2941000000E01AB65A4133333333AC2E29419A99999937B65A4133333333F22E29413333337370B65A41CDCCCCCC322F2941666666667DB65A41000000001D30294166666646AFB65A41CDCCCCCC4D302941000000C0BBB65A41CDCCCCCC4F302941CDCCCC2CBCB65A413333333393302941CDCCCC6CC6B65A41333333339B302941333333B3C6B65A4133333333E4302941CDCCCC6CF3B65A416666666626312941CDCCCC0C1CB75A416666666667312941333333F346B75A41000000005E2E294100000060E6B75A419A999999592E294133333353E7B75A4100000000E5322941CDCCCCECD6B75A419A9999990033294133333353CDB75A410000000063332941CDCCCC4CA8B75A4100000000703329419A999919A3B75A41000000008E3329416666668699B75A41CDCCCCCCBD332941CDCCCCAC8DB75A41CDCCCCCC27342941666666E67EB75A416666666609352941000000E05DB75A413333333352352941CDCCCCEC54B75A41CDCCCCCC38362941000000C053B75A41CDCCCCCC7E362941333333F35AB75A4100000000ED362941333333F361B75A413333333372372941666666066BB75A4100000000A03729419A99997973B75A4100000000E13729416666666677B75A41666666666A3829416666668682B75A41CDCCCCCCCA382941666666A687B75A419A999999383929419A9999D98BB75A4166666666113A2941333333B391B75A419A999999743B29419A9999999EB75A4100000000BD3B2941333333F3A0B75A41666666663E3C294166666666A6B75A4133333333D23C29419A9999D9ADB75A4166666666483D2941CDCCCC8CB1B75A4166666666973D29419A999939AFB75A4133333333CD3D29419A999939ADB75A4166666666923D2941333333739DB75A41666666666D3D2941CDCCCC6C89B75A4100000000573D2941333333937EB75A41CDCCCCCC523D2941000000607DB75A4133333333303D2941CDCCCCCC78B75A4133333333DB3C2941666666C66FB75A4133333333A63C2941333333F36DB75A4133333333643C2941333333D367B75A41333333333B3C2941000000E062B75A4166666666253C2941333333935AB75A4100000000263C2941000000A055B75A4100000000333C2941333333334BB75A419A9999993D3C2941000000A046B75A4133333333FE3C29419A9999D950B75A4100000000713D2941666666E656B75A41CDCCCCCCD03D2941666666265AB75A4166666666FE3D2941333333135AB75A4133333333003E2941333333535CB75A41666666664A3E2941000000605EB75A41000000009C3E2941CDCCCC6C5FB75A4133333333C53E2941666666A64FB75A4100000000E63E29419A9999D945B75A419A999999393F2941CDCCCCEC2BB75A419A999999E53F29419A9999D931B75A413333333356402941000000002BB75A41000000000E402941333333D323B75A41CDCCCCCC9E3F29413333335316B75A41666666666B3F29416666660610B75A419A999999033F2941CDCCCCCC04B75A419A999999603E2941CDCCCCECF3B65A419A999999EB3D294166666626EBB65A41666666668E3D2941000000E0DDB65A4133333333433D2941000000A0D3B65A419A999999F63C2941CDCCCC0CCEB65A419A9999999C3C29419A9999B9CAB65A41000000006A3C2941CDCCCCACBFB65A4166666666073C294166666626B8B65A419A9999997D3B29419A999919B1B65A41333333335D3B2941666666E6AFB65A4166666666223B2941000000E0ADB65A41666666667E3A29419A9999D9AEB65A419A999999203A2941CDCCCC6CA4B65A41CDCCCCCCBB392941CDCCCC2C96B65A413333333368392941000000407EB65A41666666661F3929419A9999B95EB65A4100000000F8382941CDCCCCEC44B65A4133333333EC3829419A9999F92BB65A419A999999E83829419A9999D905B65A419A999999D638294166666666F4B55A41CDCCCCCC49392941CDCCCCCCF2B55A4166666666BF392941CDCCCC6CF5B55A419A999999C9392941000000A0FAB55A4100000000D4392941333333D3FFB55A4100000000DC3929419A9999F904B65A419A999999F7392941666666C60DB65A41CDCCCCCC4C3A29419A9999391FB65A4166666666903A2941000000202DB65A419A999999BE3A29416666668634B65A419A999999F53A2941CDCCCC2C3DB65A4100000000313B2941CDCCCC4C45B65A419A9999994F3B2941666666E649B65A4133333333843B2941CDCCCC6C53B65A419A999999A33B2941666666A656B65A41CDCCCCCCC43B2941666666065AB65A4133333333F23B2941CDCCCCAC60B65A41CDCCCCCC123C2941000000A065B65A41CDCCCCCC3C3C29419A99997969B65A41CDCCCCCC833C2941CDCCCC6C67B65A419A999999253C2941333333D355B65A4100000000DF3B29419A99999945B65A41333333338F3B29419A9999193BB65A41666666666A3B29416666664639B65A41CDCCCCCC5B3B2941666666C635B65A4133333333263B2941CDCCCCCC28B65A419A999999E63A29413333335319B65A4100000000C23B2941666666C612B65A41CDCCCCCCDD3B294166666606CCB55A41CDCCCCCCF93B2941666666E6A7B55A4166666666FF3B2941000000E0A1B55A4166666666FC3B29416666660673B55A4100000000193C2941666666A62EB55A4100000000393C294166666606FEB45A41CDCCCCCCDD3B2941000000A0ECB45A41CDCCCCCCF03A294100000060CEB45A4100000000FE3A2941000000A0C3B45A419A999999163B2941CDCCCC8CBEB45A41333333335A3B294133333353B6B45A41000000007E3B294100000000B3B45A41CDCCCCCCC33B29419A999919ABB45A419A999999FC3B294100000040A4B45A4166666666303C2941000000009FB45A41CDCCCCCC553C2941666666269BB45A4166666666833C2941000000A097B45A41CDCCCCCCC23C29413333337390B45A41CDCCCCCC043D29419A99991989B45A41CDCCCCCC303D29416666664682B45A41666666664D3D2941333333737AB45A4100000000663D29410000000074B45A41CDCCCCCC703D2941333333F36EB45A419A9999997D3D29413333331366B45A4100000000803D29416666668660B45A419A999999703D29419A9999D95BB45A4100000000653D29419A99995957B45A41CDCCCCCC563D2941CDCCCC4C51B45A4100000000573D2941CDCCCC0C4BB45A419A999999563D2941CDCCCCCC4AB45A4100000000563D29419A9999F941B45A4100000000683D2941CDCCCC8C26B45A4133333333063E294133333333F1B35A4100000000163E294166666666E6B35A41CDCCCCCCC63E294133333333AEB35A4133333333F13F29416666662647B35A419A999999A241294133333313BAB25A41CDCCCCCCBF412941CDCCCC8CADB25A41000000000E4229419A99997994B25A41CDCCCCCCB744294100000060ADB15A4100000000CA452941CDCCCCCC4EB15A41CDCCCCCC21462941000000C036B15A41CDCCCCCC46462941CDCCCC4C24B15A4133333333984629419A9999390BB15A41666666663C47294166666686D1B05A41CDCCCCCC76482941CDCCCC2C6BB05A4133333333FB4729410000006068B05A419A9999996E472941666666865EB05A41CDCCCCCCE74529413333333351B05A4133333333454529416666666647B05A4133333333F6442941333333B33AB05A41CDCCCCCC83442941CDCCCCCC31B05A4166666666464429419A9999B92DB05A41CDCCCCCCE44329419A9999D928B05A413333333376432941333333B329B05A41CDCCCCCCAB412941666666E62CB05A4166666666EE4029413333333350B05A410000000076402941666666066AB05A4133333333DE3F2941333333B3A1B05A4133333333553F2941333333F3CDB05A419A999999FD3E2941666666C6EFB05A4166666666CF3E2941CDCCCC2C03B15A41CDCCCCCC823E29419A99993913B15A41CDCCCCCC243E29419A9999391EB15A41CDCCCCCC7A3D29419A9999F938B15A4166666666383D29419A9999F951B15A4166666666F43C2941666666866DB15A41CDCCCCCC923C29419A9999598FB15A41CDCCCCCCAF3B294133333353BAB15A4166666666A43A29419A999999DDB15A4166666666B73929413333335307B25A4133333333AD3829419A9999193CB25A4133333333123829410000008069B25A419A999999663829416666662672B25A410000000019382941000000E07DB25A419A999999DD3729416666668695B25A41CDCCCCCC6A372941CDCCCC4CB2B25A41CDCCCCCCC0362941CDCCCC4CBDB25A41333333336636294133333393C2B25A4133333333AD3529419A999999CAB25A419A999999BB3429419A999999CEB25A41CDCCCCCC6B34294133333333D1B25A4100000000F233294166666626CFB25A419A999999C233294100000020DAB25A41333333337333294133333333E4B25A4166666666573329413333333302B35A410000000070332941CDCCCCEC27B35A416666666686332941000000604DB35A41CDCCCCCCE2332941000000006FB35A4133333333F1332941333333F3AFB35A416666666615332941333333F3B8B35A41CDCCCCCC74322941333333F3BDB35A416666666613322941333333D3C4B35A419A999999CB31294133333373CAB35A41CDCCCCCC8331294133333313D0B35A41CDCCCCCCDD3029419A9999F9D9B35A41000000008B302941CDCCCCECDEB35A41CDCCCCCC4830294133333353E7B35A41CDCCCCCCC12F29419A999939F9B35A4133333333B62F29419A99997912B45A41CDCCCCCCE12F2941CDCCCCAC29B45A410000000033302941333333933EB45A419A99999907312941CDCCCCEC5EB45A41666666664E3129419A9999596BB45A4166666666AF312941333333D3A6B45A419A9999995A312941CDCCCCECA3B45A41CDCCCCCCE230294166666606A1B45A4100000000FD2F2941000000209CB45A41333333335C2F2941CDCCCC0C9AB45A41CDCCCCCCE62E29419A9999D998B45A419A999999872E29416666668698B45A419A999999202E29416666662699B45A4166666666B42D2941666666869BB45A41CDCCCCCCD72C29419A999939A3B45A4133333333252C2941CDCCCCCCA9B45A4133333333872B29419A999979B1B45A4166666666252B2941CDCCCCECB5B45A41	01010000206A0800008D48A87BC23629419A9999D905B45A41	080280000	Z	Aubrives	0802800	08028	08	44	11
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	01010000206A0800005CF870A3826B2A41CDCCCC8CCA815A41	080290000	Z	Auflance	0802900	08029	08	44	6
01060000206A080000010000000103000000010000007800000000000000CE1A2841000000A05E9A5A419A999999DF1A284100000040939A5A4100000000E61A284100000080A89A5A4100000000F81A2841666666C6C09A5A41CDCCCCCC2C1B284166666646FC9A5A419A999999561B2841CDCCCC0C0F9B5A4166666666C31B284133333353199B5A41CDCCCCCCDF1B28419A9999D91D9B5A4133333333FD1B2841000000A0229B5A4100000000151C28419A9999B9269B5A4100000000301C2841000000202B9B5A4166666666481C2841333333132F9B5A41333333335F1C284100000000339B5A41CDCCCCCC791C284133333353379B5A4166666666901C2841000000003B9B5A419A999999AD1C28419A9999793F9B5A419A999999281E2841666666462C9B5A41CDCCCCCC801F284100000080589B5A4166666666F120284100000000A29B5A41333333331A26284166666686689B5A41CDCCCCCC1F2628419A9999F96D9B5A419A9999991F26284100000040729B5A419A9999991D262841333333F3769B5A41000000001C2628419A9999997B9B5A41000000001C262841CDCCCC8C7F9B5A41000000001B26284166666646839B5A41333333331B2628419A9999D9879B5A41CDCCCCCC192628419A9999398C9B5A4100000000192628419A999999989B5A41CDCCCCCCD9262841333333F3929B5A41000000001C2C2841666666A6469B5A4166666666632C2841CDCCCCAC519B5A4100000000F52C2841CDCCCC4C029B5A419A999999862D284133333313C19A5A41CDCCCCCCD22D28419A999979A49A5A41CDCCCCCCD32D2841333333F3A49A5A4133333333212F2841CDCCCC4C979A5A41CDCCCCCC5A2F2841CDCCCCCC969A5A41CDCCCCCCB22F2841000000C0909A5A419A999999E42F2841CDCCCC6C8B9A5A419A999999EB2F2841CDCCCC4C879A5A4166666666D12F2841666666C6759A5A4100000000C62F284166666646619A5A4100000000CC2F28419A9999D9499A5A419A999999E12F2841666666863D9A5A41CDCCCCCCF92F2841666666A6329A5A41333333337F302841000000001E9A5A41000000001B3028419A999939159A5A41666666669A2F284166666666069A5A4166666666332F284100000080FA995A41666666663F2F2841333333F3F4995A4100000000FC2E28419A9999D9F1995A4133333333562E284133333373E5995A419A999999F12D284133333353DD995A419A9999997D2D284133333333CC995A4133333333222D28419A9999F9BC995A41CDCCCCCCE22C2841333333D3AD995A4100000000B32C2841CDCCCC2CA5995A4100000000342C2841CDCCCC0C8E995A4166666666D62B2841000000A07E995A41666666663F2B28416666662665995A4100000000F32A2841333333D358995A4100000000C82A28419A9999D951995A419A9999999C2A28410000004043995A4166666666EE292841333333F31C995A4100000000522928416666668628995A41000000009F282841666666C636995A41CDCCCCCC8A272841666666664A995A419A9999996E2728413333331363995A4166666666B2262841333333F36C995A4133333333BF2528419A99995985995A4166666666382528413333335391995A41333333334F242841CDCCCC0C82995A41CDCCCCCC39242841333333B395995A419A99999910242841CDCCCC6CA6995A41333333335F23284100000060A8995A416666666659232841333333139C995A4100000000562228419A9999B99E995A419A999999A421284133333313A3995A41CDCCCCCC1121284166666626A8995A41CDCCCCCCBF202841CDCCCC8CAF995A41CDCCCCCC8D2028419A9999D9B4995A419A999999331F2841000000C099995A4166666666071F28419A999999A4995A419A999999C91E28419A999919B0995A41CDCCCCCC2C1E28419A999919B3995A419A9999992B1E28419A9999B9B3995A4166666666251E2841666666E6B5995A41333333331D1E284166666686B8995A419A999999141E2841CDCCCC4CBB995A41000000000B1E2841CDCCCCACBD995A4100000000FE1D284100000040C0995A41CDCCCCCCF01D2841000000C0C2995A419A999999EF1D284133333313C8995A4133333333B51D284166666606E1995A41CDCCCCCC8B1D2841333333B3EF995A4100000000421D284133333333009A5A41CDCCCCCCD41C2841000000200B9A5A419A999999771C284100000040239A5A4133333333BB1B2841666666C6199A5A4100000000AE1B2841CDCCCC4C1C9A5A41CDCCCCCC9D1B2841CDCCCC8C1F9A5A4133333333851B284100000000259A5A4133333333721B284133333313299A5A41CDCCCCCC601B2841333333F32C9A5A41CDCCCCCC501B2841CDCCCC4C309A5A419A9999993F1B28419A999919349A5A419A999999301B284166666686379A5A41CDCCCCCC221B2841333333533B9A5A419A999999171B2841000000C03E9A5A4100000000111B28419A999999419A5A419A999999071B28419A999939459A5A41CDCCCCCC001B2841333333D3489A5A419A999999FA1A28419A9999194C9A5A4133333333F51A2841666666864F9A5A4133333333EE1A2841666666C6529A5A4100000000E91A28419A999979549A5A4166666666DF1A28419A9999B9579A5A4100000000D71A2841333333735A9A5A4100000000CE1A2841000000A05E9A5A41	01060000206A080000010000000103000000010000007800000000000000CE1A2841000000A05E9A5A419A999999DF1A284100000040939A5A4100000000E61A284100000080A89A5A4100000000F81A2841666666C6C09A5A41CDCCCCCC2C1B284166666646FC9A5A419A999999561B2841CDCCCC0C0F9B5A4166666666C31B284133333353199B5A41CDCCCCCCDF1B28419A9999D91D9B5A4133333333FD1B2841000000A0229B5A4100000000151C28419A9999B9269B5A4100000000301C2841000000202B9B5A4166666666481C2841333333132F9B5A41333333335F1C284100000000339B5A41CDCCCCCC791C284133333353379B5A4166666666901C2841000000003B9B5A419A999999AD1C28419A9999793F9B5A419A999999281E2841666666462C9B5A41CDCCCCCC801F284100000080589B5A4166666666F120284100000000A29B5A41333333331A26284166666686689B5A41CDCCCCCC1F2628419A9999F96D9B5A419A9999991F26284100000040729B5A419A9999991D262841333333F3769B5A41000000001C2628419A9999997B9B5A41000000001C262841CDCCCC8C7F9B5A41000000001B26284166666646839B5A41333333331B2628419A9999D9879B5A41CDCCCCCC192628419A9999398C9B5A4100000000192628419A999999989B5A41CDCCCCCCD9262841333333F3929B5A41000000001C2C2841666666A6469B5A4166666666632C2841CDCCCCAC519B5A4100000000F52C2841CDCCCC4C029B5A419A999999862D284133333313C19A5A41CDCCCCCCD22D28419A999979A49A5A41CDCCCCCCD32D2841333333F3A49A5A4133333333212F2841CDCCCC4C979A5A41CDCCCCCC5A2F2841CDCCCCCC969A5A41CDCCCCCCB22F2841000000C0909A5A419A999999E42F2841CDCCCC6C8B9A5A419A999999EB2F2841CDCCCC4C879A5A4166666666D12F2841666666C6759A5A4100000000C62F284166666646619A5A4100000000CC2F28419A9999D9499A5A419A999999E12F2841666666863D9A5A41CDCCCCCCF92F2841666666A6329A5A41333333337F302841000000001E9A5A41000000001B3028419A999939159A5A41666666669A2F284166666666069A5A4166666666332F284100000080FA995A41666666663F2F2841333333F3F4995A4100000000FC2E28419A9999D9F1995A4133333333562E284133333373E5995A419A999999F12D284133333353DD995A419A9999997D2D284133333333CC995A4133333333222D28419A9999F9BC995A41CDCCCCCCE22C2841333333D3AD995A4100000000B32C2841CDCCCC2CA5995A4100000000342C2841CDCCCC0C8E995A4166666666D62B2841000000A07E995A41666666663F2B28416666662665995A4100000000F32A2841333333D358995A4100000000C82A28419A9999D951995A419A9999999C2A28410000004043995A4166666666EE292841333333F31C995A4100000000522928416666668628995A41000000009F282841666666C636995A41CDCCCCCC8A272841666666664A995A419A9999996E2728413333331363995A4166666666B2262841333333F36C995A4133333333BF2528419A99995985995A4166666666382528413333335391995A41333333334F242841CDCCCC0C82995A41CDCCCCCC39242841333333B395995A419A99999910242841CDCCCC6CA6995A41333333335F23284100000060A8995A416666666659232841333333139C995A4100000000562228419A9999B99E995A419A999999A421284133333313A3995A41CDCCCCCC1121284166666626A8995A41CDCCCCCCBF202841CDCCCC8CAF995A41CDCCCCCC8D2028419A9999D9B4995A419A999999331F2841000000C099995A4166666666071F28419A999999A4995A419A999999C91E28419A999919B0995A41CDCCCCCC2C1E28419A999919B3995A419A9999992B1E28419A9999B9B3995A4166666666251E2841666666E6B5995A41333333331D1E284166666686B8995A419A999999141E2841CDCCCC4CBB995A41000000000B1E2841CDCCCCACBD995A4100000000FE1D284100000040C0995A41CDCCCCCCF01D2841000000C0C2995A419A999999EF1D284133333313C8995A4133333333B51D284166666606E1995A41CDCCCCCC8B1D2841333333B3EF995A4100000000421D284133333333009A5A41CDCCCCCCD41C2841000000200B9A5A419A999999771C284100000040239A5A4133333333BB1B2841666666C6199A5A4100000000AE1B2841CDCCCC4C1C9A5A41CDCCCCCC9D1B2841CDCCCC8C1F9A5A4133333333851B284100000000259A5A4133333333721B284133333313299A5A41CDCCCCCC601B2841333333F32C9A5A41CDCCCCCC501B2841CDCCCC4C309A5A419A9999993F1B28419A999919349A5A419A999999301B284166666686379A5A41CDCCCCCC221B2841333333533B9A5A419A999999171B2841000000C03E9A5A4100000000111B28419A999999419A5A419A999999071B28419A999939459A5A41CDCCCCCC001B2841333333D3489A5A419A999999FA1A28419A9999194C9A5A4133333333F51A2841666666864F9A5A4133333333EE1A2841666666C6529A5A4100000000E91A28419A999979549A5A4166666666DF1A28419A9999B9579A5A4100000000D71A2841333333735A9A5A4100000000CE1A2841000000A05E9A5A41	01010000206A0800004B7F29644A252841333333F35F9A5A41	080300000	Z	Auge	0803000	08030	08	44	5
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	01010000206A080000664FAEE5CFF628419A9999C9C45B5A41	080310000	Z	Aure	0803100	08031	08	44	13
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	01010000206A0800001C6BFC7FA74C2841000000F0AE625A41	080320000	Z	Aussonce	0803200	08032	08	44	19
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	01010000206A0800000062B0629E842941000000A04F705A41	080330000	Z	Authe	0803300	08033	08	44	10
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	01010000206A080000F037CD839AD02941333333D323805A41	080340000	Z	Autrecourt-et-Pourron	0803400	08034	08	44	12
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	01010000206A08000050D96625C7932941666666E6536F5A41	080350000	Z	Autruche	0803500	08035	08	44	8
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	01010000206A0800009036EF9BEE6F2941666666D6D65A5A41	080360000	Z	Autry	0803600	08036	08	44	16
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	01010000206A080000CAF6416E415B2841CDCCCCBC9B9B5A41	080370000	Z	Auvillers-les-Forges	0803700	08037	08	44	8
01060000206A08000001000000010300000001000000CB0100009A99999931092841666666C64A715A419A9999995F0928419A9999995E715A41CDCCCCCC81092841CDCCCC6C7F715A41CDCCCCCC99092841666666A697715A4133333333D90928419A9999F994715A4100000000E70A2841333333D387715A4100000000260C2841000000007D715A41CDCCCCCCC50C28419A9999B974715A4166666666DF0C2841CDCCCC4C7B715A4100000000F30C28416666666680715A4166666666080D28419A99999986715A41CDCCCCCCEF0C2841333333D38C715A4166666666F50C2841333333B39B715A4100000000220D284166666626C2715A419A999999330D28419A9999B9CA715A419A999999A50D28419A9999F938725A4133333333D10C28413333337337725A4100000000E10B2841CDCCCCCC9D725A4133333333160C2841CDCCCCAC9E725A41333333334A0C284133333393A0725A4100000000E30B2841333333F3BA725A419A999999A90B284100000000C9725A419A999999770B284100000020DB725A41CDCCCCCC490B284166666606E8725A4166666666E00A2841333333B304735A41000000001E0B2841CDCCCCCC05735A41666666663A0B28413333335306735A4166666666810B28413333337307735A4166666666E70B28410000006009735A419A999999290C2841CDCCCCCC0A735A41000000004F0C2841333333930B735A4100000000350C2841333333131E735A41333333332E0B28416666660685735A4166666666650B2841000000C086735A41000000007F0C2841000000008C735A419A999999B00C2841333333738D735A419A999999F00C2841CDCCCCEC8E735A419A999999FE0C28419A9999598F735A419A9999993E0D2841CDCCCC2C91735A419A999999860D28410000006093735A419A999999DB0D2841333333F395735A41666666663C0E28416666660699735A4166666666130F2841666666A69B735A41333333330B0F2841666666669F735A4133333333F70E2841000000A0A8735A419A999999440F2841CDCCCC2CAB735A4166666666BB0F284166666626B0735A4133333333AD0F284166666666B9735A4166666666D30F2841CDCCCC2CBB735A416666666617102841CDCCCCECBC735A419A99999951102841CDCCCC2CBE735A419A999999A510284133333333C0735A419A999999E510284133333333C1735A419A99999913112841333333B3C1735A41CDCCCCCC3D112841CDCCCC2CC1735A41CDCCCCCC69112841CDCCCC2CC0735A41CDCCCCCC69112841CDCCCCECAF735A413333333325132841333333B3AE735A41CDCCCCCCE014284133333373AD735A41CDCCCCCCDE14284133333373B3735A4133333333321628419A999999BB735A419A9999996E17284133333333C3735A419A9999996C172841000000C0CB735A416666666677192841000000C0D3735A41000000007819284100000040D1735A41666666667819284100000080CD735A41000000007919284133333373C8735A41000000007919284133333333C7735A41333333337A1928419A999999BF735A41666666667A192841000000C0B9735A41666666667A19284166666646B8735A41333333337B1928419A999979B2735A419A9999997B19284166666606B1735A41333333337C19284133333333AB735A419A9999997C19284100000020A9735A419A9999997D19284166666606A6735A419A9999997E192841000000A0A2735A41CDCCCCCC7E192841666666C6A1735A41CDCCCCCC80192841CDCCCCEC9D735A419A999999811928419A9999F99C735A4100000000EF1A28419A9999599C735A4166666666461B2841CDCCCC6C9C735A4166666666541B28416666660696735A4100000000561B2841000000C093735A41CDCCCCCC6E1B28413333335386735A41CDCCCCCC571C28419A9999D98A735A4133333333451D28416666666696735A4166666666681D28419A9999B951735A4133333333401F2841CDCCCCAC5E735A4100000000292028413333333381735A416666666641212841000000407B735A419A999999D7212841CDCCCC0C79735A410000000025222841333333D377735A41666666664E2228419A9999F976735A410000000058222841CDCCCCEC76735A41CDCCCCCC5E2228416666664677735A4133333333432328419A9999F93B735A41666666669C232841CDCCCCAC3F735A41000000005F2428419A99997943735A41666666664F252841666666C642735A4100000000422628419A9999D947735A419A999999B9262841666666864D735A41666666660A272841CDCCCCCC52735A4166666666582928419A99993974735A413333333375292841666666666C735A41CDCCCCCCA7292841000000606F735A41CDCCCCCC012A28416666662675735A41CDCCCCCC7E2A28419A9999397D735A419A999999C12A28413333337381735A4133333333522B28419A9999D98A735A41000000009E2B2841333333B38F735A41CDCCCCCCAF2B28419A99999990735A419A999999BE2B2841000000E08F735A41CDCCCCCCDF2B2841333333B38C735A419A999999482C28416666664681735A4133333333B72C2841CDCCCC0C75735A419A999999122D2841CDCCCC4C6B735A41CDCCCCCC3B2D2841CDCCCCCC66735A4133333333662D28413333335362735A419A9999998B2D28419A9999595E735A419A9999997F2E2841666666A64E735A4100000000AE2E28413333331347735A41CDCCCCCC062F2841333333F33D735A4166666666422F28413333337337735A41CDCCCCCC7A2F28419A99991931735A41000000009C2F2841333333132D735A419A999999A72F2841CDCCCC4C2B735A4133333333B52F28413333333327735A41CDCCCCCCBE2F28410000002024735A41CDCCCCCCE72F2841CDCCCCAC18735A410000000001302841333333B311735A419A9999992E3028416666662605735A41000000004E3028419A999919FC725A41666666668830284133333373EB725A4133333333B230284133333313E0725A4166666666C7302841CDCCCCECD9725A4100000000D9302841CDCCCCCCD4725A4166666666E9302841333333D3CF725A419A999999F23028419A9999D9CD725A4100000000FE30284133333313CD725A41000000000B312841CDCCCC4CCD725A41333333333731284133333353CF725A419A9999995831284100000000D1725A410000000092312841333333B3D3725A4166666666033228419A9999F9D8725A41CDCCCCCC1132284133333313D9725A419A9999991832284100000060D9725A419A999999363228419A9999B9D5725A416666666679322841000000A0CD725A4166666666A13228419A9999F9C8725A4166666666D032284166666626C3725A4166666666F832284166666626BE725A41333333333C332841CDCCCCACB5725A41333333337033284100000060AF725A4100000000A5332841666666A6A8725A419A999999E6332841000000A0A0725A41333333331C342841666666469A725A41000000003C3428419A99997996725A41CDCCCCCC503428419A9999F993725A4133333333643428419A99999991725A419A99999997342841000000008D725A419A999999E13428410000002091725A4100000000253528410000004095725A41000000005E3528413333339399725A4100000000AA3528419A9999B99F725A41CDCCCCCCF835284166666606A6725A41666666666436284133333393AD725A41333333337D36284166666626AF725A4133333333763628419A999999AA725A419A9999998536284166666626A8725A41666666669836284133333373A5725A41CDCCCCCCB0362841CDCCCCCCA1725A419A999999D1362841CDCCCCAC9C725A41CDCCCCCCE1362841666666069A725A4100000000F7362841333333D396725A419A999999073728416666666694725A41CDCCCCCC28372841CDCCCC4C8F725A41CDCCCCCC41372841CDCCCC4C8B725A41666666667F372841000000E081725A41666666669B372841333333737D725A41CDCCCCCCC6372841666666A676725A4166666666EE3728413333337370725A41CDCCCCCC23382841CDCCCC0C68725A413333333346382841666666E662725A419A99999976382841333333535B725A41CDCCCCCCA93828419A9999B953725A4100000000D4382841000000404D725A4100000000ED3828413333339349725A4133333333F23828416666662648725A4166666666F63828410000000046725A419A999999F7382841CDCCCCCC44725A41CDCCCCCCFA382841666666C640725A410000000008392841CDCCCCEC32725A413333333321392841CDCCCCAC1A725A41666666662E392841000000000E725A41000000003C3928413333333303725A41CDCCCCCC483928419A999919F6715A41CDCCCCCC273B284166666686EC715A41CDCCCCCCC63C28419A999939E4715A419A999999753C2841333333D3D2715A419A999999023C2841CDCCCCECC2715A419A9999995E3C28419A999999C1715A419A9999998B3B2841666666869F715A4133333333873B28419A9999B99C715A4133333333813B2841666666069A715A4133333333793B28419A99995997715A419A999999703B28419A9999B994715A4133333333633B28419A9999B991715A4100000000503B2841CDCCCCCC8D715A41666666663A3B28419A9999F988715A4133333333293B28413333331385715A4133333333183B2841000000C080715A41666666660A3B2841CDCCCC0C7D715A4166666666FD3A2841CDCCCC6C78715A4100000000F33A2841CDCCCC0C74715A4133333333EC3A28416666660671715A4133333333E63A28419A9999396C715A4166666666E03A28413333331367715A4133333333DB3A2841333333F361715A419A999999D53A2841000000605D715A41CDCCCCCCCE3A28419A99997958715A4100000000C73A28419A9999D953715A4166666666BD3A2841CDCCCC2C4F715A4100000000BC3A28419A9999794E715A4166666666B43A2841333333F34A715A41CDCCCCCCA73A28419A9999D946715A41CDCCCCCC9C3A28410000008043715A4133333333903A2841CDCCCC6C3F715A4133333333893A28419A9999593C715A419A999999803A28413333337337715A4133333333793A28419A99993932715A41CDCCCCCC713A28419A9999192E715A41000000006A3A2841333333132B715A419A9999995D3A2841000000E027715A41CDCCCCCC4C3A2841333333D324715A41666666663D3A28419A9999D922715A41CDCCCCCC243A2841CDCCCC8C20715A41666666660A3A2841000000801E715A4100000000BC392841666666E618715A4133333333AF392841CDCCCCEC17715A416666666693392841666666C615715A419A99999980392841CDCCCCEC13715A413333333373392841CDCCCCCC11715A41000000006A392841333333D30F715A416666666664392841000000A00D715A41CDCCCCCC5A392841333333F309715A419A999999493928410000000003715A41333333333239284100000020FB705A419A99999920392841CDCCCC6CF5705A41666666660C392841CDCCCC8CEF705A41CDCCCCCCF9382841666666C6EB705A4133333333E8382841666666C6E8705A4100000000D63828419A999939E6705A4166666666BF382841000000E0E3705A4166666666A6382841333333B3E1705A41000000004B382841333333F3D9705A4166666666FF37284166666606D3705A41CDCCCCCCE837284100000080D0705A4100000000D4372841CDCCCC0CCE705A419A999999C13728419A999939CB705A4166666666AF372841333333F3C7705A4133333333A437284133333333C5705A419A999999563728419A999919CC705A41333333330D37284100000000C1705A4133333333D0362841333333B3B7705A413333333341362841333333337F705A413333333311362841333333136F705A410000000080362841CDCCCCEC68705A413333333371362841CDCCCC2C61705A419A9999995F362841333333F35B705A4133333333F3352841CDCCCC4C60705A4133333333F6342841000000E06D705A419A999999C7342841CDCCCC6C62705A41666666664C3428419A99991967705A41CDCCCCCCF63328410000006056705A41CDCCCCCC953328419A99995958705A419A999999723328419A99991959705A41CDCCCCCC14332841333333935B705A4133333333FA322841666666465C705A41CDCCCCCC243228410000006061705A419A9999993B312841000000C04F705A413333333386312841666666264B705A4133333333823128416666664647705A41CDCCCCCC30312841000000A034705A410000000091302841CDCCCC0C36705A41CDCCCCCCAD2F2841000000C03A705A4166666666C42F2841666666E648705A41CDCCCCCCF32F28419A9999995B705A41333333330C2F2841666666E662705A4133333333FF2E2841CDCCCC6C5C705A4133333333F02E2841666666E64E705A4166666666E42E2841000000C046705A4100000000632E28419A9999B941705A419A999999DF2D28416666660638705A41CDCCCCCCC62C28419A99995929705A419A999999BD2B28419A9999D91A705A4133333333A92B2841CDCCCC0C09705A41000000009F2B2841333333D301705A419A9999996D2A284133333373F56F5A41CDCCCCCC6C2A284133333393EA6F5A41CDCCCCCCE729284100000080E96F5A419A999999F2292841CDCCCC2CD96F5A419A9999998A29284100000060D86F5A41CDCCCCCC8C292841333333F3D26F5A419A999999D7292841CDCCCC8CD26F5A4100000000D529284133333353CE6F5A41000000004929284100000000D06F5A41CDCCCCCC3829284100000060AD6F5A41CDCCCCCCB72B2841CDCCCC6CA56F5A4166666666B62B2841CDCCCCCCA46F5A41CDCCCCCCB52B28419A9999F9A36F5A4100000000AE2B2841333333B3976F5A41CDCCCCCCAA2B2841CDCCCCEC926F5A4100000000A82B28419A9999598E6F5A41CDCCCCCCA52B2841CDCCCCEC8B6F5A41CDCCCCCCA22B284166666646896F5A4100000000A12B284133333353876F5A41CDCCCCCC9F2B284133333353856F5A41CDCCCCCCA12B2841333333D3836F5A419A999999A62B284100000060826F5A41CDCCCCCCAC2B2841333333D3806F5A41CDCCCCCCFB2B2841CDCCCCAC6B6F5A4133333333392C2841000000605C6F5A4133333333912C28419A9999F9446F5A41CDCCCCCC922C2841CDCCCC6C436F5A41666666668B2C284133333333436F5A4100000000812C28419A999919436F5A41CDCCCCCC312B28419A999919456F5A41CDCCCCCCB02928419A999939476F5A41333333339529284100000060476F5A41CDCCCCCC0A2928419A9999B9476F5A4100000000BC2828419A999939486F5A41CDCCCCCC08282841CDCCCC0C496F5A4133333333BA2728419A999979496F5A419A999999A0272841CDCCCC4C486F5A41666666667A272841333333B3516F5A41333333335C272841CDCCCC4C576F5A419A9999991E27284133333353606F5A4100000000B8262841333333D36D6F5A4100000000A02628419A999919716F5A419A9999994A262841CDCCCCCC7C6F5A4100000000042628419A999979876F5A4133333333F7252841CDCCCC6C8B6F5A410000000058252841666666467B6F5A4166666666B2242841CDCCCC8C6A6F5A41CDCCCCCC8C242841CDCCCC2C6A6F5A41666666661B232841000000C0806F5A4166666666F42128419A9999995E6F5A4166666666BE202841000000803F6F5A4133333333002128419A999979386F5A4166666666D5222841CDCCCCAC2D6F5A416666666611232841000000A02A6F5A41666666664423284100000020286F5A4133333333AA2328419A999979246F5A416666666618242841CDCCCC4C216F5A41666666662B242841000000E0206F5A41666666663324284100000000206F5A41CDCCCCCC38242841666666A61E6F5A41CDCCCCCC3C242841000000201D6F5A41000000003F242841333333B31C6F5A41CDCCCCCC6C24284100000020156F5A4100000000D0242841CDCCCC2C056F5A4166666666412528419A999919F36E5A4100000000B1252841000000E0E06E5A41CDCCCCCC352628419A999919CB6E5A4133333333B72628419A9999B9B66E5A41333333333727284100000060A26E5A41000000000021284166666666AB6E5A419A999999E2202841333333D3B56E5A4133333333C220284166666686BE6E5A419A999999682028419A999959D36E5A416666666636202841CDCCCCECDE6E5A4100000000FF1F284100000040EB6E5A419A999999CC1F284100000040F76E5A419A999999BE1F2841666666E6FB6E5A419A999999B11F2841CDCCCCCC016F5A41CDCCCCCC9E1F284133333333106F5A419A999999911F2841000000401C6F5A41CDCCCCCC871F284100000000226F5A419A9999996A1F2841333333D32C6F5A4133333333F71E284166666626296F5A41CDCCCCCC611E28419A999979246F5A4166666666E61D2841000000C0206F5A419A999999B91D2841CDCCCC8C1F6F5A419A999999801D2841000000601F6F5A419A999999191D2841CDCCCCCC1F6F5A4166666666D41C2841CDCCCC2C206F5A41CDCCCCCC881C284100000000206F5A41CDCCCCCC411C2841333333B31F6F5A41CDCCCCCC0A1C2841666666061F6F5A419A999999C91B2841333333731D6F5A419A999999461B2841666666E6196F5A4133333333D31A28419A9999F9176F5A4133333333921A284133333353186F5A41CDCCCCCC591A2841000000E0186F5A41CDCCCCCC1D1A28419A9999191A6F5A41CDCCCCCCDE192841666666E61C6F5A4100000000A0192841CDCCCC0C216F5A4166666666621928419A999999256F5A413333333324192841CDCCCC6C2A6F5A4100000000F11828419A999959316F5A4166666666B81828419A999939396F5A4133333333931828419A999959406F5A4133333333731828419A9999F9476F5A41000000004918284166666666526F5A41CDCCCCCC18182841CDCCCCAC5D6F5A419A99999901182841CDCCCC4C626F5A419A999999D7172841CDCCCCEC676F5A419A9999998917284166666626736F5A419A999999401728419A9999D97D6F5A4133333333EB162841666666E68A6F5A419A999999B8162841666666A6926F5A41CDCCCCCC78162841333333738A6F5A41CDCCCCCC27162841000000807D6F5A419A9999990F16284100000060776F5A410000000002162841333333D3706F5A4166666666F4152841000000C0656F5A4100000000EE152841333333F3636F5A41CDCCCCCCD9152841000000C05F6F5A41CDCCCCCCC11528419A9999395C6F5A41CDCCCCCC9F14284100000080956F5A419A9999996A132841CDCCCC4CDC6F5A4166666666631228410000002017705A41CDCCCCCC081128419A99999962705A41CDCCCCCC94112841666666866F705A419A999999491128419A9999997B705A4133333333F9102841666666E687705A41CDCCCCCCB81028413333339391705A41000000003410284166666666A5705A419A9999992C1028419A999979A6705A413333333329102841CDCCCCCCA4705A416666666624102841CDCCCC0CA4705A41CDCCCCCC111028419A999979A2705A4166666666AE0F2841000000209A705A419A999999410F2841666666C690705A419A999999940E28419A9999F981705A4166666666EE0C2841666666E6CC705A41CDCCCCCCD10C28419A999939CB705A41666666665D0C284166666646C4705A4100000000F40B2841CDCCCCECBD705A41CDCCCCCCD60B2841CDCCCC8CBC705A4133333333C20B284133333353BF705A419A999999A50B284166666686C1705A4166666666770B28419A9999D9C4705A419A9999994F0B28419A9999F9C7705A41000000002B0B28419A9999F9CA705A4100000000030B284133333373D1705A41666666662B0B2841666666A6D7705A41CDCCCCCC1E0C284166666686F4705A4166666666590C284133333313FC705A4100000000F10B28419A9999B90A715A4133333333DC0B2841CDCCCCAC0D715A41666666669C0B28413333331316715A419A999999820B28419A9999F919715A419A9999997C0B2841CDCCCC4C1B715A41CDCCCCCC7C0B2841333333131D715A41666666668C0B28413333335321715A41CDCCCCCCBB0B2841333333132E715A419A99999931092841666666C64A715A41	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	01010000206A0800004CB3E9669A222841666666E639715A41	080380000	Z	Avançon	0803800	08038	08	44	21
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	01010000206A080000A9B2999292BB27419A999909A96F5A41	080390000	Z	Avaux	0803900	08039	08	44	13
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	01010000206A0800003C92D9D054392941000000A05B8C5A41	080400000	Z	Les Ayvelles	0804000	08040	08	44	5
01060000206A08000001000000010300000001000000AC010000CDCCCCCC8DF128419A9999595C7E5A410000000098F128419A9999995D7E5A4100000000CAF12841666666865D7E5A41CDCCCCCCD4F12841666666466B7E5A4100000000C1F12841666666C66D7E5A416666666699F1284133333393717E5A41CDCCCCCC99F1284133333313787E5A4133333333B8F12841666666867F7E5A419A999999B9F12841666666C6947E5A419A999999E2F128419A999979A27E5A416666666633F22841000000A0AD7E5A419A99999983F22841CDCCCC4CB17E5A4100000000C0F228419A999979B77E5A4166666666D4F22841333333F3BE7E5A41CDCCCCCCE3F2284100000040C27E5A4133333333F9F228419A999999C57E5A41CDCCCCCC2CF3284166666686CC7E5A413333333356F3284133333313D27E5A419A9999996BF32841CDCCCCECD27E5A4100000000C7F32841CDCCCCCCD77E5A413333333309F42841CDCCCCECDF7E5A4100000000D2F4284100000060ED7E5A41CDCCCCCC84F5284100000020F87E5A4133333333E9F52841666666C6FB7E5A410000000009F628419A999939FA7E5A41CDCCCCCC46F62841000000A0F27E5A419A9999996AF6284166666646EE7E5A41333333338EF62841666666E6E97E5A4133333333B2F62841CDCCCC8CE57E5A41CDCCCCCCD5F6284166666626E17E5A4166666666F9F62841CDCCCCCCDC7E5A419A9999990FF7284100000040DB7E5A41666666663BF728419A999939D87E5A410000000067F72841CDCCCC2CD57E5A410000000069F728419A999939D57E5A41000000009AF7284166666666D67E5A4100000000CBF7284133333393D77E5A41000000001FF8284133333333D47E5A41CDCCCCCC1FF82841CDCCCC2CD47E5A410000000031F8284133333333D37E5A419A999999B6F82841CDCCCCECC37E5A4133333333C0F82841CDCCCC2CC27E5A416666666630F928419A9999F9B27E5A41333333335CF9284133333333B37E5A410000000073F9284166666686B27E5A419A99999904FA2841CDCCCC6CAE7E5A41CDCCCCCC0CFA28419A999959AE7E5A41CDCCCCCCC9FA284166666646AD7E5A4100000000C0FA2841CDCCCC4CB27E5A419A999999C1FA2841333333D3B47E5A419A999999C5FA2841CDCCCC0CBB7E5A4166666666C9FA2841CDCCCC4CC17E5A4166666666CDFA284100000080C77E5A4133333333D7FA2841666666E6CC7E5A4133333333E2FA28419A9999F9D27E5A4100000000F0FA2841000000E0D47E5A416666666611FB284100000080D97E5A410000000033FB284166666626DE7E5A419A99999937FB28419A9999F9DE7E5A419A99999953FB284166666626E47E5A41CDCCCCCC6FFB284133333353E97E5A41666666667AFB2841CDCCCC4CEC7E5A41666666668EFB284166666606F27E5A41666666668EFB28419A999919F27E5A41CDCCCCCC89FB2841CDCCCC4CF87E5A413333333385FB284166666686FE7E5A419A99999967FB284133333393037F5A41CDCCCCCC49FB28419A999999087F5A419A99999936FB2841666666260E7F5A419A99999922FB2841000000E0137F5A413333333323FB2841000000201A7F5A419A99999923FB284100000060207F5A410000000024FB2841666666A6207F5A41CDCCCCCC2BFB2841CDCCCCCC267F5A419A99999933FB2841000000002D7F5A41666666663BFB284166666626337F5A413333333343FB284133333353397F5A419A99999943FB2841333333533E7F5A410000000044FB284133333393447F5A416666666644FB2841333333D34A7F5A419A99999944FB2841333333F34A7F5A41CDCCCCCC4EFB2841CDCCCC0C517F5A416666666681FB2841000000005B7F5A419A999999DFFB2841000000207A7F5A419A999999EAFB28419A9999D9877F5A4100000000D7FB2841000000208E7F5A419A999999D3FB2841CDCCCCEC957F5A4133333333D1FB2841CDCCCCCC9B7F5A4133333333D1FB2841000000409C7F5A4133333333D0FB2841666666469E7F5A4100000000D9FB28419A999959AD7F5A410000000016FC284166666606BB7F5A419A9999992AFC284100000000C57F5A410000000053FC284133333333CB7F5A4100000000D6FC2841CDCCCC4CDB7F5A419A999999E0FC2841CDCCCCCCE17F5A419A999999F4FC2841666666C6E17F5A419A999999F3FC284100000000E67F5A4166666666D3FC2841666666C627805A413333333306FD28413333333334805A41CDCCCCCC1BFD2841CDCCCC2C38805A41CDCCCCCC37FD28419A9999593D805A41CDCCCCCC53FD28416666668642805A4100000000A8FD28416666660652805A4100000000D1FD28419A9999F960805A41CDCCCCCCD7FD28419A99995966805A41CDCCCCCCDBFD2841000000C06F805A4166666666DFFD28419A9999B970805A4133333333DDFD2841000000E072805A4100000000D5FD2841000000A077805A4133333333D3FD28416666660679805A4166666666D2FD28419A9999397C805A41CDCCCCCCD6FD2841CDCCCCAC7D805A419A999999DCFD2841666666667E805A41CDCCCCCCD9FD2841666666667F805A4100000000D8FD28419A99999980805A41CDCCCCCCD7FD2841333333D382805A41CDCCCCCCDFFD2841666666A686805A4166666666ECFD28416666668689805A4100000000FFFD2841333333738D805A416666666613FE2841CDCCCCAC8F805A41000000001AFE28410000002092805A419A99999925FE28419A99997995805A410000000027FE2841CDCCCC8C98805A410000000027FE28419A9999799A805A41666666662FFE2841000000E09E805A41333333333DFE284166666666A2805A413333333341FE2841CDCCCC2CA6805A419A99999944FE2841CDCCCC2CAB805A41CDCCCCCC88FE284100000040C9805A41CDCCCCCC3BFF2841CDCCCC6CDB805A419A9999999FFE28419A9999B905815A413333333383FF28419A9999B920815A419A999999EC002941CDCCCC8C1C815A41CDCCCCCC72012941000000C01E815A4133333333ED012941333333D326815A413333333324032941CDCCCC4C3E815A4100000000F2042941CDCCCCEC0D815A41000000009B0529410000004001815A4100000000400629413333333300815A41666666667709294100000000FB805A419A9999999C09294100000020FB805A419A999999C3092941000000A0FA805A4100000000E90929419A999999F9805A41333333330F0A29419A999919F8805A41CDCCCCCC350A29419A999999F5805A4133333333750A294133333313F1805A4133333333860A2941000000C0EF805A41CDCCCCCCEA0A294133333313E7805A41CDCCCCCC230B2941CDCCCCACE2805A41000000006C0B294100000060DD805A419A999999BE0B2941333333B3D7805A4133333333F60B2941333333F3D2805A4166666666400C29419A999939CC805A41333333333F0D294133333373BC805A41CDCCCCCC980D29419A999919B6805A4133333333760E2941666666C6B5805A419A999999310F294166666626B7805A41CDCCCCCCC40F294133333393B2805A410000000001102941CDCCCC0CAE805A41000000005C1029419A9999B9AD805A4100000000DB102941CDCCCCCCAB805A4166666666E1102941000000E0AB805A41666666660D112941CDCCCC6CAA805A4166666666941129419A999919A7805A4166666666E611294133333393A5805A419A9999992E12294133333373A3805A41CDCCCCCC641229419A9999B9A4805A41000000008412294100000080A6805A41CDCCCCCCB312294166666666A7805A4133333333E21229419A999959A7805A41333333334F1329419A999919A9805A419A999999AA132941CDCCCC6CA8805A41CDCCCCCC0D14294100000080AC805A419A999999D61429419A999979A7805A4100000000A1152941CDCCCC6CA2805A419A9999996B162941CDCCCC8CA1805A41333333331417294100000000A1805A41666666664D17294166666646A2805A41CDCCCCCC96172941333333D3A0805A41000000001D1829410000008097805A419A9999994818294166666686A1805A419A9999996D18294133333353A8805A419A999999DB182941333333B39D805A41333333335E19294166666686A0805A4100000000E119294100000080A3805A4133333333751A2941333333F3AB805A41000000006E1B294133333353AA805A4133333333221C294133333353AB805A4133333333981C2941CDCCCC4CAD805A4100000000F81C294166666606A9805A41CDCCCCCC4A1D294166666646A7805A4133333333431D2941333333D3A0805A41666666664A1D2941000000009D805A4166666666561D2941CDCCCCCC96805A41333333335F1D2941CDCCCC8C86805A41CDCCCCCC721D2941CDCCCC0C7F805A41CDCCCCCCE91D2941CDCCCC2C71805A4133333333611E2941CDCCCC8C69805A4100000000921E29410000000058805A4166666666AB1E2941000000A052805A419A999999C41E29419A9999394D805A4100000000CD1E2941333333734B805A4166666666D91E29416666666645805A419A999999E51E29419A9999593F805A4100000000F21E2941CDCCCC4C39805A41CDCCCCCCF31E2941CDCCCC6C38805A41666666660B1F2941CDCCCCEC32805A41CDCCCCCC221F2941666666662D805A41CDCCCCCC2E1F29419A9999992A805A41000000004B1F29413333337325805A4166666666691F2941CDCCCCEC1F805A41CDCCCCCC731F2941CDCCCC0C1E805A41CDCCCCCC821F2941666666261C805A4100000000971F29413333339319805A4100000000BA1F29416666662615805A4133333333C31F29419A9999F913805A4133333333C71F2941000000C00D805A4133333333CB1F29416666668607805A4133333333CC1F29419A99993906805A419A999999B81F29413333337300805A4100000000A51F29419A9999B9FA7F5A4133333333991F294166666646F77F5A41000000009B1F294166666646F37F5A41CDCCCCCCAA1F294166666646D47F5A419A999999951F2941CDCCCC0CC47F5A41CDCCCCCC741F29419A999999B77F5A4100000000231F2941333333339C7F5A4133333333A01E29419A9999998E7F5A419A999999771E2941666666E6857F5A41333333334F1E2941333333F3807F5A4133333333271E29419A9999797E7F5A419A999999441E294133333333787F5A41CDCCCCCC751E2941666666666B7F5A41CDCCCCCC6A1E2941CDCCCCAC5D7F5A4166666666BA1E29419A999999587F5A4133333333C41E29419A9999D9547F5A4166666666A51E2941000000A0497F5A419A999999CC1E29419A9999193D7F5A4166666666611F2941333333F32D7F5A4133333333611F2941333333332A7F5A41CDCCCCCC231F294166666646167F5A4100000000411F2941000000C0097F5A4133333333651F29419A999979EF7E5A419A9999996D1F29419A999939DA7E5A4166666666811F294133333373D67E5A4100000000811F294133333373D17E5A41333333333A1F2941CDCCCCCCC37E5A419A9999999D1F2941333333F3BB7E5A4100000000931F294133333333B37E5A4100000000561F294166666686A57E5A419A999999871F29419A9999399F7E5A4133333333911F29419A9999399A7E5A419A9999995E1F2941666666068F7E5A41333333335E1F2941666666068A7E5A41000000007C1F294100000080877E5A41CDCCCCCCAD1F2941333333F3847E5A4166666666D81F2941CDCCCCAC817E5A419A999999DF1F294166666626817E5A41CDCCCCCCFB1F2941CDCCCC4C7E7E5A419A999999062029419A9999B9797E5A419A999999E21F2941CDCCCCCC777E5A4133333333CA1F294166666626797E5A4133333333A51F2941CDCCCC2C797E5A4133333333901F2941CDCCCC6C787E5A4133333333751F2941CDCCCC6C777E5A4100000000711F294166666646777E5A41CDCCCCCC701F29419A999999767E5A41333333332B1F294133333333767E5A41CDCCCCCC251E2941666666A6697E5A4166666666DB1C2941000000A0547E5A41000000007F1B2941000000003A7E5A4133333333591B29419A999919377E5A41CDCCCCCC851A2941666666C6227E5A419A9999993B1A2941CDCCCC2C1A7E5A4133333333EE1929419A999999097E5A4166666666B91929419A9999B9FE7D5A41000000008419294133333393F17D5A4100000000E1182941CDCCCC2CDA7D5A41666666668618294133333333C67D5A41CDCCCCCC33182941333333D3AF7D5A4133333333DF172941333333F3BC7D5A41CDCCCCCC66172941CDCCCC8CD37D5A419A9999991B172941000000A0DE7D5A41000000009A162941666666C6E17D5A41666666663B162941666666C6E07D5A4100000000FD15294100000060E37D5A4133333333DF1529419A9999F9E37D5A419A999999C6152941CDCCCCCCE47D5A410000000096152941000000A0E77D5A41CDCCCCCC6515294133333373EB7D5A419A9999992B152941CDCCCC8CEF7D5A419A999999F6142941CDCCCC2CF37D5A4133333333C41429419A999979F57D5A4133333333801429419A999959F77D5A41CDCCCCCC40142941CDCCCCCCF87D5A4133333333C1132941666666A6F67D5A4166666666651329419A999919F77D5A4133333333D512294100000040F77D5A41333333333F122941CDCCCC0CF77D5A419A99999912122941CDCCCCACF47D5A4100000000BC11294166666686EE7D5A419A99999970112941CDCCCC4CE77D5A416666666610112941CDCCCC0CDF7D5A41CDCCCCCCD31029419A999999DB7D5A4100000000BF10294166666646DA7D5A41CDCCCCCC9D10294166666686D87D5A419A9999997210294133333313D77D5A41333333334E10294166666646D67D5A41666666664110294166666626D67D5A419A99999916102941CDCCCCACD57D5A41CDCCCCCCE40F2941666666C6D57D5A41CDCCCCCCC10F294166666606D67D5A4100000000A50F2941333333D3D67D5A4133333333730F294100000060D87D5A4166666666420F2941CDCCCC2CDA7D5A4166666666EF0E29419A9999D9DC7D5A4133333333D10E2941CDCCCC2CDD7D5A41CDCCCCCCB80E2941333333F3DC7D5A41CDCCCCCC9D0E2941CDCCCC0CDC7D5A419A9999996D0E294166666686D97D5A41000000004C0E29419A999959D77D5A4100000000A70D29419A999999FE7D5A4100000000110D29419A9999390B7E5A419A999999EE0C294100000060067E5A4166666666420C29419A999939167E5A41CDCCCCCC0C0C2941CDCCCCAC097E5A419A999999E80B2941666666860A7E5A419A999999D50B2941333333330B7E5A41CDCCCCCCC90B2941666666A60B7E5A41666666661C0B2941000000A0127E5A41333333333B0B2941666666C61A7E5A4133333333220B294133333333307E5A4166666666660A294133333333377E5A4100000000690A2941000000003A7E5A4133333333700A2941CDCCCC4C417E5A419A9999996E0A2941CDCCCC8C427E5A41CDCCCCCC300A29419A999939407E5A41CDCCCCCCCD092941CDCCCCAC3C7E5A4100000000BA092941666666063C7E5A4133333333870929419A9999F93A7E5A4166666666490929419A9999393A7E5A41CDCCCCCC0D092941333333933A7E5A4166666666D1082941000000C03B7E5A41CDCCCCCC9B0829419A9999593D7E5A419A9999994308294133333313417E5A419A999999ED072941CDCCCCEC447E5A419A999999BA072941CDCCCC4C477E5A41666666668B07294166666646497E5A41666666665F072941666666464A7E5A410000000034072941333333734A7E5A41000000000E072941CDCCCC4C4A7E5A4133333333E9062941CDCCCCEC497E5A41000000004006294166666626417E5A419A999999260629419A9999D93F7E5A41000000008405294133333333397E5A413333333304052941666666A63C7E5A4133333333EC042941666666A63B7E5A419A999999BF042941000000003B7E5A419A9999998E042941333333933A7E5A41CDCCCCCC6A042941CDCCCC2C3A7E5A41CDCCCCCC4404294166666666397E5A41333333330804294166666646387E5A4133333333DE03294100000040377E5A41CDCCCCCCC103294133333313377E5A4133333333A703294166666646377E5A41CDCCCCCC7F0329419A999919387E5A41CDCCCCCC61032941CDCCCCAC387E5A41000000004D032941000000A0387E5A419A9999993D03294166666606387E5A4133333333280329419A999999367E5A41CDCCCCCC0B032941666666C6337E5A4166666666F7022941666666A6317E5A41CDCCCCCCE1022941CDCCCC2C2F7E5A41CDCCCCCCA302294100000000287E5A41000000002302294166666626AC7D5A416666666618022941333333D3A77D5A416666666628022941333333D3917D5A413333333347022941CDCCCC6C7B7D5A419A999999610229419A9999996A7D5A410000000060022941000000C05F7D5A41CDCCCCCC5302294166666666547D5A413333333339022941CDCCCCCC4A7D5A41CDCCCCCC01022941000000C0427D5A419A999999C0012941666666E63B7D5A413333333362012941333333F3357D5A4133333333DC002941666666C6317D5A41CDCCCCCC03002941000000E0287D5A419A999999B6FF284166666666297D5A413333333377FF284166666646267D5A41666666660FFF2841666666061D7D5A413333333378FE2841000000A00B7D5A419A999999FBFD2841000000E0FC7C5A41CDCCCCCC66FD284166666606FD7C5A4133333333C5FC2841000000E0FD7C5A41000000000DFC284166666646FC7C5A41CDCCCCCCD7FA284100000040F47C5A41CDCCCCCCECFA28419A9999590F7D5A41CDCCCCCCEEFA2841666666662D7D5A41333333335AFA2841000000802D7D5A419A999999CDF92841000000402D7D5A419A9999993EF928419A999959387D5A4133333333D6F82841333333F3377D5A413333333391F8284133333313427D5A416666666683F82841CDCCCCAC467D5A410000000072F82841666666864C7D5A416666666660F8284100000060527D5A41CDCCCCCC60F82841666666A6537D5A419A99999963F82841666666E6597D5A41000000006CF828419A9999996C7D5A413333333385F82841666666E67A7D5A41CDCCCCCC98F82841666666A6847D5A419A999999A7F82841CDCCCCEC8B7D5A4166666666B9F828419A9999D9907D5A41CDCCCCCCE0F8284166666686977D5A4133333333F7F82841000000209E7D5A416666666606F92841666666E6A07D5A416666666622F928419A9999B9A47D5A410000000060F92841CDCCCC0CAF7D5A416666666691F928419A999959BA7D5A4166666666F7F8284166666606CE7D5A419A99999993F62841333333F3F07D5A419A99999939F4284166666666287E5A41333333332BF228419A9999194B7E5A41CDCCCCCC0EF22841666666A6457E5A419A999999D2F12841666666C64A7E5A419A99999997F128419A999959577E5A41CDCCCCCC8DF128419A9999595C7E5A41	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	01010000206A080000CC15A45F260D294133333333187F5A41	080410000	Z	Baâlons	0804100	08041	08	44	15
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	01010000206A080000FAF7A854ADB029410000004024895A41	080430000	Z	Balan	0804300	08043	08	44	5
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	01010000206A080000FFC00F3496EA27419A9999F98F725A41	080440000	Z	Balham	0804400	08044	08	44	2
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	01010000206A08000056CC8CB2B439294100000060FA6B5A41	080450000	Z	Ballay	0804500	08045	08	44	10
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	01010000206A0800004E151F5370D72741000000003C7B5A41	080460000	Z	Banogne-Recouvrance	0804600	08046	08	44	19
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	01010000206A0800005ABF2CBF5DD82841CDCCCCEC50875A41	080470000	Z	Barbaise	0804700	08047	08	44	7
01060000206A08000001000000010300000001000000460200009A999999B9312841000000007D765A4133333333BF312841000000207E765A41CDCCCCCCDB312841CDCCCC8C87765A4100000000FC3128419A99995992765A416666666618322841333333739B765A416666666623322841CDCCCC6C9F765A41000000002A322841333333D3A1765A410000000039322841CDCCCCCCA6765A41666666664A32284100000000AC765A4133333333153228419A9999D9AD765A41333333335B3228419A9999B9C6765A41000000009D3228419A999939C3765A4100000000AF322841666666C6C8765A4133333333C1322841666666E6CD765A4100000000CF322841666666E6D1765A419A999999E23228419A999999D7765A419A999999FA322841CDCCCCCCDD765A413333333314332841CDCCCC4CE4765A41333333332C3328419A999979EA765A41666666663D33284133333333EF765A41CDCCCCCC33332841000000E0EF765A41CDCCCCCC6E33284133333393FD765A4133333333CB3328419A99997914775A41666666660C342841000000C025775A41CDCCCCCC383428416666664628775A4100000000C6342841333333D326775A419A999999D7342841CDCCCC4C27775A419A999999E13428419A9999592C775A419A999999E3342841333333332F775A4100000000E23428419A99993931775A41CDCCCCCCDB3428419A99991933775A41CDCCCCCCCE342841CDCCCC4C34775A41CDCCCCCCB9342841666666C636775A419A999999A13428419A9999D938775A41333333338B342841000000203C775A41CDCCCCCC7C342841CDCCCC2C3F775A4133333333733428413333337342775A419A9999996E342841333333B344775A41CDCCCCCC6E3428413333335346775A419A99999973342841CDCCCC8C47775A4100000000843428419A9999B948775A419A9999999A3428410000008048775A4166666666BE342841000000A047775A4100000000D2342841333333D346775A4100000000E73428410000006045775A419A999999F03428413333335344775A4166666666023528410000008042775A41333333330A352841CDCCCC6C40775A413333333317352841CDCCCC6C3F775A4133333333243528419A9999993F775A4166666666313528410000000040775A41CDCCCCCC373528419A9999F940775A41000000003D3528416666660644775A419A9999993B352841CDCCCC4C47775A4166666666383528413333335349775A41666666662D3528419A9999994C775A4166666666253528419A9999D94E775A4133333333273528416666664650775A41333333332C352841666666E651775A419A99999932352841CDCCCCAC52775A416666666641352841000000E052775A41CDCCCCCC6D352841333333D352775A41CDCCCCCC6E352841333333D352775A4100000000A33528416666662653775A4166666666D53528419A99991954775A4100000000FB352841666666E655775A41333333330B362841333333B357775A41CDCCCCCC16362841CDCCCCEC59775A41333333331F362841333333F35B775A413333333329362841666666C65E775A41CDCCCCCC3C362841CDCCCCCC60775A419A99999950362841CDCCCCCC61775A419A9999996F3628410000006064775A4133333333903628413333333367775A41000000009F362841000000A069775A419A999999AA362841666666266C775A419A999999A7362841000000006F775A419A99999992362841CDCCCC4C73775A419A9999997A362841CDCCCC2C78775A41CDCCCCCC72362841000000407B775A41333333336E362841333333B37D775A410000000063362841333333537F775A419A999999573628419A9999F980775A41CDCCCCCC4D3628410000006081775A41CDCCCCCC38362841000000A081775A41000000002F362841CDCCCC6C81775A41333333331D3628419A9999D981775A4166666666183628413333337382775A419A999999133628419A99991984775A419A99999910362841333333F386775A41CDCCCCCC1D362841666666668A775A41333333332E362841CDCCCCCC8C775A416666666648362841CDCCCC6C8F775A410000000054362841CDCCCC0C91775A41CDCCCCCC5A3628410000004093775A41CDCCCCCC5A362841CDCCCC4C95775A41333333335E362841CDCCCCEC96775A41666666666B362841666666269A775A419A99999978362841666666C69B775A410000000089362841CDCCCC2C9E775A41000000009336284100000000A0775A41666666669E36284166666606A2775A419A999999AB36284166666606A4775A4133333333B736284133333373A5775A41CDCCCCCCBD3628419A999979A7775A4100000000BE362841333333B3A8775A4166666666C4362841333333B3AA775A419A999999B736284133333393AD775A4100000000A3362841CDCCCC0CB2775A419A9999998236284133333393B5775A41666666666A36284100000040B9775A419A9999995D362841333333B3BB775A41000000005936284100000020BE775A4133333333593628419A9999F9C0775A410000000060362841333333D3C3775A419A9999996B36284100000040C6775A41000000007C362841CDCCCCACC8775A41333333339136284133333313CA775A41CDCCCCCCAC3628419A9999D9CA775A419A999999CD362841CDCCCC0CCD775A41CDCCCCCCE7362841CDCCCC0CCF775A4166666666FB362841000000A0CF775A41CDCCCCCC063728419A999939CF775A41000000001237284100000060CD775A41CDCCCCCC1937284166666626CC775A41CDCCCCCC1E372841666666E6C9775A413333333320372841666666A6C6775A41CDCCCCCC2437284166666606C5775A41000000002B37284100000060C3775A41CDCCCCCC39372841CDCCCCECC0775A41CDCCCCCC51372841CDCCCCACBF775A41000000008937284133333393BD775A4133333333C5372841333333B3BC775A41CDCCCCCC02382841CDCCCC8CBC775A41CDCCCCCC21382841000000A0BF775A419A9999995C382841000000E0C5775A41CDCCCCCC713828419A999979C7775A41666666667E3828419A9999D9C7775A419A9999998A3828419A9999B9C7775A41333333339E3828419A9999D9C6775A4133333333BC382841333333D3C4775A419A999999E238284166666666C2775A4133333333FB38284166666626C1775A410000000013392841CDCCCC4CC1775A416666666621392841333333F3C1775A413333333330392841CDCCCCACC2775A419A9999993A392841666666C6C3775A410000000041392841CDCCCC4CC5775A41333333334C392841CDCCCC0CC8775A41CDCCCCCC58392841666666C6CA775A4100000000683928419A999979CE775A41CDCCCCCC703928419A999939D2775A41666666667639284100000060D4775A41666666667B39284100000020D6775A413333333394392841CDCCCC4CDD775A41CDCCCCCCAB3928419A999979E5775A41CDCCCCCCBB392841CDCCCC2CEC775A4166666666CB3928419A9999B9F1775A4133333333DB39284100000040F7775A4133333333E5392841333333D3FA775A4133333333EB392841333333F3FD775A41CDCCCCCCE7392841CDCCCCCC01785A41CDCCCCCCD83928410000006007785A41CDCCCCCCC9392841CDCCCCAC0C785A4133333333C6392841CDCCCCCC0F785A4100000000CA3928419A9999F911785A4100000000D23928410000006014785A419A999999E3392841CDCCCCCC15785A4166666666023A28419A9999F916785A41666666661D3A2841666666E617785A4100000000423A28419A9999D917785A419A9999997F3A28416666668617785A419A9999999C3A28410000008017785A4166666666BD3A2841CDCCCCAC18785A4133333333DC3A28419A99995919785A4166666666F13A28413333335319785A41666666660A3B2841CDCCCCCC18785A41000000002D3B2841CDCCCC4C18785A4100000000483B28416666664618785A4100000000613B28419A99997918785A4166666666743B2841666666A619785A4166666666B03B2841333333B31C785A41CDCCCCCCDE3B2841CDCCCC8C1F785A419A999999013C28419A99993920785A41CDCCCCCC143C28413333337320785A4133333333243C2841CDCCCC2C20785A419A9999992D3C2841333333B31F785A41CDCCCCCC403C28419A9999791E785A41CDCCCCCC553C2841000000001D785A4166666666633C2841000000C01B785A41000000006D3C2841000000C01B785A4133333333823C28419A9999F91B785A41000000009F3C2841666666E61C785A41CDCCCCCCAA3C2841333333931E785A4166666666A53C28410000000021785A419A999999A53C28419A99999924785A41CDCCCCCC9C3C2841333333B32C785A4166666666983C28416666662631785A41333333339A3C28410000004034785A4133333333973C2841CDCCCC2C36785A419A9999998C3C28416666664639785A419A999999893C2841000000A03A785A419A999999863C2841CDCCCC2C3C785A4100000000873C2841CDCCCC4C3E785A4166666666853C2841CDCCCCCC40785A41666666667F3C28416666668643785A4166666666793C28410000004046785A4133333333783C28413333339348785A41000000007A3C2841000000E04A785A41CDCCCCCC813C2841333333934D785A41CDCCCCCC8C3C2841000000804F785A4100000000A13C2841000000A050785A4100000000AF3C2841CDCCCCCC50785A4166666666BB3C28419A99999950785A4166666666C43C28410000000050785A4133333333CB3C2841666666664F785A4166666666D83C28419A9999394E785A41CDCCCCCCEA3C2841CDCCCC4C4C785A419A999999F53C2841000000E04B785A419A999999033D2841000000E04B785A41CDCCCCCC0C3D2841000000004D785A4133333333133D2841000000C04E785A4166666666103D28413333337351785A419A9999990D3D28413333335355785A419A9999990A3D28419A99993958785A41666666660C3D2841CDCCCC8C5A785A41CDCCCCCC153D2841000000405C785A4166666666253D2841CDCCCC6C5D785A419A9999993F3D2841000000C05E785A4166666666583D2841666666E65E785A4166666666663D2841CDCCCCAC5E785A41000000007C3D2841333333B35D785A41666666668E3D28419A9999B95B785A419A9999999D3D28419A99999959785A4166666666B13D2841000000E056785A4166666666BF3D28410000008055785A4133333333D03D28419A9999B954785A4133333333E43D28410000008054785A41CDCCCCCC073E2841000000A054785A4166666666113E2841CDCCCCCC55785A41CDCCCCCC203E28419A99997958785A41CDCCCCCC2B3E2841000000605B785A4166666666323E2841CDCCCC0C5E785A4100000000343E2841000000C060785A4133333333363E28410000006068785A4166666666363E2841000000E06B785A419A999999443E2841666666C66D785A41666666664F3E2841000000806F785A4133333333703E2841CDCCCCCC70785A4133333333923E28419A9999B972785A4166666666A33E28419A99993974785A4133333333AB3E28416666666675785A4133333333A83E28410000002077785A4133333333A23E28413333331379785A41CDCCCCCCA33E28419A9999997A785A4100000000AA3E28419A9999597C785A419A999999B33E2841000000E07D785A4100000000C33E2841CDCCCCCC7E785A4166666666D23E28419A9999597F785A41CDCCCCCCD83E2841CDCCCC8C7F785A4133333333EB3E28413333335380785A4100000000FB3E28413333337381785A4100000000063F2841CDCCCC8C83785A419A9999991C3F2841CDCCCCCC80785A4100000000273F2841000000E07E785A41CDCCCCCC0F3F2841000000C07C785A419A999999033F2841666666867A785A4133333333F93E28413333331377785A4133333333013F28419A9999B973785A4166666666233F28416666668668785A419A999999503F2841666666665B785A4166666666673F2841666666A654785A4100000000943F2841333333B345785A419A999999BE3F2841CDCCCC4C3C785A419A999999C53F28419A99991939785A41CDCCCCCCF73F28419A9999192D785A416666666642402841000000001B785A416666666685402841333333130A785A4133333333D240284100000080F6775A41CDCCCCCC2D412841000000A0F9775A41CDCCCCCC9541284133333373FC775A41000000000E422841CDCCCCCCFE775A41333333338E4228419A999939FF775A4100000000E242284100000040FE775A41666666661E432841CDCCCCCCFC775A41666666665C43284166666626FA775A41000000009C432841CDCCCC8CF6775A4100000000DD43284100000080F1775A410000000042442841CDCCCC6CE8775A416666666696442841CDCCCC8CE0775A4100000000C0442841CDCCCCACDC775A4166666666E4442841CDCCCC4CD9775A41333333331145284100000020D5775A419A9999997B452841CDCCCC4CCB775A41CDCCCCCC9045284166666626C9775A419A9999999145284133333313C9775A4166666666D545284100000000C3775A419A9999993B46284133333373B9775A41000000009B462841CDCCCC8CB0775A4133333333F446284100000040A8775A4100000000544728419A9999599F775A419A999999B1472841333333D396775A4100000000BF472841CDCCCC8C95775A4100000000D44728410000000098775A4166666666E0472841CDCCCCCC98775A4133333333F94728416666664699775A413333333323482841333333D399775A413333333356482841333333739A775A41CDCCCCCC8D482841CDCCCC2C9B775A4100000000C04828419A9999D99B775A41CDCCCCCCED4828419A9999799C775A41CDCCCCCC14492841CDCCCC0C9D775A41666666663A492841333333939D775A4166666666644928419A9999399E775A41000000008A492841333333B39E775A4133333333B0492841333333339F775A41CDCCCCCCD4492841000000C09F775A4166666666FA49284133333353A0775A419A9999990E4A2841000000A0A0775A4166666666444A28419A999979A1775A41000000008A4A284166666646A2775A4133333333BE4A28419A9999D9A2775A41CDCCCCCCD84A284166666666A3775A4100000000E74A284166666646A4775A4100000000F44A284166666686A5775A4100000000064B284100000020A8775A4133333333204B284100000060AC775A4100000000324B284133333353AF775A41CDCCCCCC544B2841666666C6B4775A419A999999774B2841000000E0B9775A4166666666914B2841CDCCCCECBC775A419A9999999A4B2841000000C0BD775A4166666666A44B284133333393BC775A4166666666BF4B2841CDCCCC4CB9775A4166666666EF4B284100000000B4775A41333333331B4C28419A999959AF775A419A999999714C28419A999939A6775A4133333333B24C28419A9999D99F775A4133333333DD4C2841CDCCCC2C9B775A4166666666324D28419A99991992775A4166666666624D2841CDCCCCEC8C775A4166666666A24D28416666668686775A41CDCCCCCCFB4D2841000000C07D775A4166666666304E28410000002078775A4166666666724E28413333335371775A4166666666B94E2841000000006A775A419A9999991E4F2841CDCCCCAC5F775A41333333335C4F2841CDCCCC4C59775A4133333333964F2841CDCCCC4C53775A4133333333AC4F28410000008051775A4133333333175728416666662699765A4166666666EC562841666666A68B765A4100000000AA562841CDCCCCAC73765A410000000092562841666666C66A765A419A999999F6562841000000C05D765A419A9999990E5728416666668658765A41000000003B5728416666662654765A416666666647572841000000E04D765A41666666661A572841CDCCCC8C46765A419A999999BD5628410000000039765A41CDCCCCCC5A562841666666C628765A419A999999C9552841CDCCCCEC11765A41000000001D552841666666C6F9755A4100000000F05428419A999919F1755A41CDCCCCCCD454284133333353E5755A419A999999A0542841CDCCCC6CD8755A41CDCCCCCC3F542841CDCCCC4CCD755A419A9999992154284133333393C9755A4133333333DB53284166666666C3755A4100000000305328419A9999D9B0755A419A999999E9522841CDCCCCACAA755A41CDCCCCCC9F52284133333313A5755A41CDCCCCCCC2522841333333339E755A413333333304522841000000C094755A4133333333295228416666662685755A41CDCCCCCC6C5228419A9999F952755A4133333333C1532841666666E642755A4166666666405428419A9999193D755A41333333335A542841000000203A755A413333333356542841333333F336755A4133333333545428410000008034755A413333333353542841CDCCCC6C31755A416666666653542841666666C62D755A4166666666FB532841000000202D755A410000000015542841333333F30E755A41000000007C5428416666666610755A419A999999C754284100000020E3745A419A9999999C54284133333333E0745A41333333338B542841CDCCCC0CDF745A41666666667454284100000080DD745A4133333333FE532841000000A0D4745A41666666669F532841333333F3CE745A41333333334B53284133333393CB745A41CDCCCCCCC052284166666686C8745A41666666666F522841CDCCCCECC5745A410000000024522841CDCCCC8CC1745A41CDCCCCCCC3512841CDCCCCECB9745A413333333367512841666666E6B1745A4166666666295128419A999979AD745A4133333333FE502841333333D3AA745A419A999999D850284100000000AA745A4166666666A85028419A9999B9A8745A41666666666C502841CDCCCC8CA3745A41CDCCCCCC425028419A999919A5745A4166666666894F284100000080A3745A41CDCCCCCC584F284133333393A8745A41000000003C4F284100000080A4745A419A999999FF4E28419A999919A3745A4133333333654E2841333333D39A745A41CDCCCCCC7D4E28419A9999198A745A41666666667C4D28416666660698745A4100000000624D2841CDCCCC4C92745A4133333333394D28410000002088745A4166666666EA4C2841CDCCCC4C78745A419A999999C64B2841666666C689745A41333333330E4B2841CDCCCC4C95745A41CDCCCCCCE84A28416666666696745A41CDCCCCCCCD4A2841333333F398745A4100000000964A2841333333939E745A41333333338D4A2841CDCCCCEC9A745A419A9999990D4A28416666660687745A41CDCCCCCC564A2841CDCCCC4C71745A4133333333134B2841CDCCCC2C61745A4133333333AC4A2841CDCCCCCC50745A4133333333904A28416666664653745A41CDCCCCCC674A2841CDCCCC0C57745A41CDCCCCCC564A2841666666A658745A4133333333014A28410000006061745A4100000000C24928419A9999B967745A416666666698492841666666466C745A413333333325492841000000C078745A4100000000E8482841000000A07F745A41CDCCCCCC2D482841333333B393745A41CDCCCCCCF7472841666666669A745A419A999999AD47284133333313A6745A419A999999614728419A999939B0745A41CDCCCCCC38472841CDCCCC4CB5745A416666666685472841333333B3E6745A41CDCCCCCC444728419A999959EB745A41666666662947284133333353ED745A41333333330647284100000080EF745A41CDCCCCCCEC4628419A9999D9F1745A4100000000CC46284133333393F4745A419A999999B146284166666686F7745A419A9999997946284100000040FD745A416666666655462841333333B301755A4100000000364628416666668606755A413333333311462841000000000D755A4100000000FC4528419A99997912755A41CDCCCCCCEC4528419A9999F916755A4133333333B84528419A99999922755A419A999999684528419A9999392A755A41CDCCCCCC4A452841000000802D755A410000000027452841CDCCCCCC2F755A4100000000074528413333335331755A4100000000D94428410000006032755A4100000000A9442841CDCCCCAC33755A41CDCCCCCC8D442841333333933B755A41CDCCCCCCCE442841CDCCCC0C4F755A4166666666E3442841666666865C755A4133333333DF4428413333335367755A4133333333AB442841333333936D755A41CDCCCCCC31442841000000606C755A41000000000E4428410000004066755A419A999999E0432841666666C65E755A41CDCCCCCCA24328413333337359755A419A99999970432841CDCCCC8C54755A419A999999544328413333331352755A4133333333284328419A9999D94F755A4100000000EE422841666666264D755A41CDCCCCCCD1422841333333B34A755A41CDCCCCCCC1422841CDCCCC2C48755A4166666666B5422841333333B344755A4133333333AB4228419A9999B93F755A4166666666A0422841333333F335755A41666666667D422841333333933F755A416666666673422841000000C041755A4166666666674228419A99993944755A4166666666584228413333331347755A410000000044422841666666864A755A410000000031422841CDCCCCEC4D755A410000000019422841000000A052755A419A999999064228419A9999B956755A4166666666EE4128419A9999195B755A4100000000E14128419A9999395E755A4100000000EA412841CDCCCC0C60755A419A999999F0412841666666C660755A4166666666F84128413333333362755A413333333309422841CDCCCC0C64755A41333333331D4228413333335367755A419A9999992F422841CDCCCC6C6A755A41333333333E422841666666666D755A41CDCCCCCC434228413333335370755A410000000040422841CDCCCCEC73755A4133333333374228416666662677755A410000000032422841333333B37A755A419A999999B84128419A9999197A755A41CDCCCCCC09412841CDCCCCAC70755A4100000000B54028410000000067755A41CDCCCCCC82402841CDCCCC4C66755A4166666666CD3F2841666666C673755A419A9999999B3F28413333335376755A4166666666553F2841333333D357755A4166666666B63D2841CDCCCC4C6F755A4166666666ED3D2841000000407C755A419A9999990F3D28413333337388755A419A999999B73C2841333333338D755A41CDCCCCCCA13C2841000000008B755A41333333338B3C28416666664688755A41333333337D3C28413333333386755A4100000000763C2841666666E684755A41000000006E3C28416666668682755A4100000000493C2841000000807C755A41333333332D3C28419A9999F977755A41666666661D3C28416666666675755A4133333333C53B28416666660667755A4166666666493B2841666666A66A755A4100000000AB3A28413333339368755A4166666666523A28416666666661755A4100000000B9392841666666A66E755A41333333338B392841000000A072755A4133333333753928410000006070755A41CDCCCCCC51382841000000C08F755A4166666666D3372841000000609D755A4166666666CD372841000000209D755A41CDCCCCCC9E36284133333333B9755A41CDCCCCCC6336284100000020B6755A416666666640362841CDCCCC4CB4755A41666666668D35284100000080C6755A41000000001635284166666626D3755A4133333333CA3428419A999979DA755A41CDCCCCCCB93428419A999979E4755A4100000000B2342841CDCCCC2CE9755A41000000009B34284100000020F7755A41666666669034284133333393FD755A41333333337F3428419A99991908765A416666666695342841666666A60C765A4100000000AF3428410000002012765A4100000000C03428419A99997915765A419A999999D63428419A9999191A765A419A999999EE3428419A9999191F765A410000000004352841CDCCCC8C23765A4133333333023528419A9999B925765A4100000000FD342841CDCCCCEC28765A4133333333F3342841333333F32B765A41CDCCCCCCE3342841000000202E765A4100000000CB342841666666C630765A419A999999AD342841CDCCCC0C32765A41333333338E3428416666664633765A419A99999966342841CDCCCCAC34765A41000000004B342841333333F334765A41333333332A3428419A9999D933765A41CDCCCCCC123428410000002033765A4100000000F23328416666664631765A41CDCCCCCCD03328419A9999D92D765A4166666666B53328419A99997929765A41333333339D332841333333932A765A419A99999986332841333333D32B765A410000000077332841666666A62C765A413333333381332841CDCCCCEC2E765A416666666685332841CDCCCC2C31765A41666666667D332841CDCCCCEC32765A419A99999973332841CDCCCCAC34765A41CDCCCCCC533328419A9999F937765A41CDCCCCCC31332841000000403B765A413333333310332841CDCCCCCC40765A419A999999EE3228419A99991949765A4100000000E53228419A9999D94D765A4133333333E33228410000002052765A4166666666EB3228410000002055765A419A999999F53228419A99999957765A41CDCCCCCCFF3228419A99991959765A416666666610332841CDCCCC2C5A765A4133333333373328419A9999995A765A413333333328332841333333135D765A4133333333143328413333335360765A4166666666EE322841CDCCCC8C64765A4166666666C73228413333331369765A419A999999E0322841000000806C765A4166666666EB322841000000006E765A4166666666913228410000008078765A419A999999B9312841000000007D765A41	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	01010000206A08000025DF0A1CB3442841CCCCCCEC69765A41	080480000	Z	Barby	0804800	08048	08	44	11
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	01010000206A0800009ED8895594AF2941CDCCCCDC706E5A41	080490000	Z	Bar-lès-Buzancy	0804900	08049	08	44	9
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	01010000206A080000C15D000D63CF29410000007062695A41	080520000	Z	Bayonville	0805200	08052	08	44	16
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	01010000206A080000808A52FDD2D429419A9999F9028C5A41	080530000	Z	Bazeilles	0805300	08053	08	44	37
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	01010000206A080000DC7F679526D82941CDCCCC7C1B785A41	080550000	Z	Beaumont-en-Argonne	0805500	08055	08	44	31
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	01010000206A080000301D6767008E2941000000D0B8665A41	080560000	Z	Beffu-et-le-Morthomme	0805600	08056	08	44	6
01060000206A08000001000000010300000001000000F60300009A999999134A2941333333B37D715A4133333333504A2941CDCCCC4C87715A4100000000304B2941000000A093715A4133333333F44B294100000020AE715A41CDCCCCCC934C29419A9999B9C1715A4166666666E44C2941666666A6C9715A4100000000FB4C2941000000E0CB715A4100000000134D294100000060CF715A4166666666264D294100000060D2715A41CDCCCCCC334D294133333353D4715A41666666663A4D294166666666D6715A4133333333414D2941666666A6D9715A419A999999474D2941CDCCCC4CDD715A41CDCCCCCC514D2941333333F3E0715A41CDCCCCCC5B4D294100000020E4715A4133333333614D29419A9999B9E6715A419A9999996A4D294133333333EB715A419A999999724D2941CDCCCC8CEE715A419A9999997C4D294133333393F2715A4100000000864D2941666666E6F6715A4100000000904D2941333333B3FB715A41000000009A4D2941333333B300725A419A9999999E4D2941000000E00E725A41333333339B4D2941000000001B725A41CDCCCCCC494D2941CDCCCC6C1B725A4166666666BE4C2941CDCCCCCC21725A41000000004D4C2941666666662A725A4166666666014C2941CDCCCCAC32725A4100000000DC4B2941CDCCCCCC3C725A4133333333AE4B29410000004049725A41CDCCCCCC974B29419A9999B955725A41CDCCCCCC2F4B2941666666E671725A41666666662F4B2941CDCCCCEC78725A41CDCCCCCC304B2941000000407B725A41000000002D4B2941CDCCCCCC7C725A41CDCCCCCC2D4B2941CDCCCCAC7E725A419A9999992D4B29419A99997980725A41CDCCCCCC304B2941CDCCCC8C83725A4133333333344B2941000000C084725A419A9999993D4B29413333331386725A4100000000524B29419A99997987725A4166666666594B2941666666A688725A419A9999996A4B29419A9999998A725A419A9999997E4B2941000000808B725A4166666666AF4B2941333333938E725A419A999999C54B29419A9999D990725A4133333333C94B2941CDCCCC4C92725A419A999999C04B29419A99993995725A4166666666A74B2941CDCCCCEC99725A41CDCCCCCC8E4B2941333333139E725A41666666666D4B2941CDCCCC4CA3725A4166666666794B294100000080A4725A41000000009E4B294133333313A8725A419A999999BD4B29419A9999D9A9725A41CDCCCCCC0B4C2941CDCCCC2CAA725A41CDCCCCCCC04C2941CDCCCCCCB4725A4100000000EE4C294133333373B7725A419A999999064D2941666666E6B8725A4133333333394D29419A999959C0725A41CDCCCCCCA74D29419A999979CB725A419A999999E44D294166666666D5725A41CDCCCCCCF14D2941CDCCCC6CDB725A4133333333FF4D294133333373E1725A41CDCCCCCC0D4E29419A999919E8725A41CDCCCCCC024E2941CDCCCC6CEE725A4100000000224E2941CDCCCC0CF4725A419A9999994F4E294133333393F6725A4100000000714E294100000040F8725A4133333333804E294100000060F9725A4133333333A54E2941CDCCCC4CFB725A4166666666DE4E2941CDCCCCCCFE725A4100000000F44E2941CDCCCC2C00735A419A999999314F2941CDCCCC4C03735A419A9999994B4F2941333333F304735A4100000000594F29419A99991907735A41CDCCCCCC714F2941CDCCCC6C0B735A41000000008D4F29419A9999F90F735A41333333337B502941CDCCCC2C27735A4166666666B9502941666666662C735A419A999999E6502941666666462F735A4100000000045129416666664630735A41CDCCCCCC265129410000008032735A419A99999937512941333333B333735A419A99999972512941000000403C735A4133333333DF512941666666E64B735A41CDCCCCCC1A522941666666A654735A416666666645522941333333735A735A4166666666715229413333337360735A41666666667F522941CDCCCC0C65735A41000000008C5229419A99993966735A41000000009A5229419A9999B967735A4100000000A2522941666666E668735A4100000000A5522941333333B36A735A41CDCCCCCCB7522941000000A06B735A4166666666C4522941333333D36C735A4166666666C7522941666666E66E735A419A999999C95229413333337371735A4166666666B85229413333335374735A419A999999AA5229416666660678735A4100000000A8522941666666A67A735A41CDCCCCCCA8522941CDCCCCEC7C735A419A999999BF5229413333339382735A419A999999D8522941CDCCCCCC86735A41CDCCCCCCEB5229413333335389735A413333333300532941666666468B735A419A9999992A532941CDCCCC6C90735A4133333333685329416666666696735A41CDCCCCCC86532941000000E099735A413333333398532941000000E09A735A419A999999B1532941CDCCCC0C9B735A4100000000ED532941666666A69B735A413333333307542941CDCCCC8C9C735A419A99999925542941000000C09D735A410000000050542941000000C0A1735A419A9999996B542941CDCCCCCCA3735A41000000009554294133333373A5735A4100000000BA542941000000E0A7735A419A999999D954294100000060A7735A4100000000E454294100000060A7735A419A999999EC542941666666C6A6735A419A999999F55429419A999939A6735A4166666666FB542941CDCCCCECA6735A419A999999FE54294100000020A8735A41666666661F552941CDCCCC6CAC735A419A9999995C55294133333373AF735A41333333339555294100000000B3735A4100000000E455294133333333B6735A41CDCCCCCCF055294100000020B8735A41CDCCCCCCEF55294133333353BB735A4166666666EA55294166666666BF735A41CDCCCCCC035629419A999919C2735A41666666661656294166666686C6735A41CDCCCCCC2356294166666606C9735A41CDCCCCCC3956294100000000CB735A41CDCCCCCC5656294166666606CF735A41333333336C56294100000000D1735A4133333333885629419A999919D2735A4100000000D2562941000000A0D3735A41333333331057294133333353D4735A41CDCCCCCC4657294133333373D5735A419A9999997457294100000080DA735A41333333338857294133333313E1735A419A9999998857294166666646E6735A419A9999999757294100000060E9735A4133333333A3572941CDCCCCECEE735A41000000009D5729419A999979FB735A4133333333A457294133333313FF735A4100000000AC5729416666660603745A4133333333C2572941CDCCCC8C08745A41CDCCCCCCD9572941000000800E745A4166666666E95729410000000012745A419A999999F45729410000000015745A419A99999905582941CDCCCC4C18745A41333333332D5829419A99995922745A4166666666725829419A9999D933745A4133333333775829419A99993937745A41666666667E5829419A9999F939745A419A99999988582941666666863B745A41666666668D582941666666C63E745A416666666691582941333333D341745A4133333333945829419A99991943745A4166666666A0582941333333D343745A419A9999996D5829416666662649745A4133333333445829416666668654745A41000000002B5829410000002060745A41333333331F5829410000004069745A416666666674582941333333F35C745A4100000000A1582941666666C656745A41CDCCCCCC14592941666666E649745A4166666666E65929419A99995957745A4133333333215A2941000000005C745A4133333333705A29410000004058745A41CDCCCCCC8F5A2941333333D355745A4133333333E25A29419A9999794F745A419A999999085B2941000000804B745A41333333332F5B29410000008047745A419A999999555B29416666668643745A419A999999635B2941333333F341745A41CDCCCCCC885B2941333333D33D745A4133333333AE5B2941666666A639745A4166666666D35B29410000008035745A41CDCCCCCCF85B29413333335331745A41000000001E5C2941CDCCCC2C2D745A4166666666435C29410000000029745A419A999999685C2941000000E024745A41000000008E5C2941333333B320745A419A999999D85C29410000006018745A4166666666B25D294166666626FA735A41666666660B5E294133333353EC735A41CDCCCCCC505E2941000000C0E4735A4100000000195F2941CDCCCC8CE5735A41333333334E5F29419A999919E7735A41CDCCCCCC4A602941333333D3E6735A4100000000536029419A9999B9E7735A41CDCCCCCC8F60294100000040F1735A41CDCCCCCC9C60294166666666F3735A41CDCCCCCCBB602941000000E0EF735A4166666666DE6029419A9999F9E9735A4133333333E5602941CDCCCCECE6735A41CDCCCCCCE96029419A9999D9E4735A4100000000EA60294166666626E3735A419A999999E2602941CDCCCCCCE0735A41CDCCCCCCCD6029419A9999F9DC735A4100000000B660294100000000D9735A4100000000AA602941CDCCCC8CD6735A419A999999A660294166666606D5735A41CDCCCCCCA7602941666666A6D3735A4100000000B160294100000040D2735A4166666666C4602941CDCCCC8CD0735A41CDCCCCCCD7602941CDCCCC6CCF735A4100000000F060294166666626CE735A416666666627612941CDCCCCCCC7735A419A9999993B61294133333333C5735A413333333346612941CDCCCC4CC3735A4133333333636129419A999939BF735A41CDCCCCCC6D612941666666E6BD735A419A9999997C61294100000000BD735A41CDCCCCCCB4612941666666E6BB735A4166666666CE61294166666666BB735A4100000000E461294100000000BA735A4133333333E76129419A999939B9735A419A999999E96129419A999919B8735A419A999999E9612941666666A6B6735A41CDCCCCCCE761294166666626B5735A419A999999DC6129419A9999B9B1735A4133333333DA61294100000060B0735A41CDCCCCCCD761294133333393AD735A419A999999D96129419A9999F9A6735A4133333333D96129419A999959A2735A419A999999D2612941CDCCCC6C9F735A419A999999CA6129419A9999F99C735A4166666666AB6129410000004094735A4100000000A5612941CDCCCCEC92735A4133333333A5612941333333F391735A41CDCCCCCCAA612941000000C090735A419A999999B26129416666664690735A4166666666D3612941666666468F735A4166666666E3612941000000E08E735A4100000000F3612941000000A08E735A4166666666FF6129419A9999F98E735A41666666660D6229413333331390735A410000000033622941000000E093735A416666666667622941000000A09A735A41333333336F622941333333339B735A410000000079622941CDCCCC2C9B735A41CDCCCCCC87622941000000609A735A416666666693622941CDCCCC4C99735A41666666669E622941CDCCCC4C97735A4166666666A16229413333333395735A41CDCCCCCCA16229413333337393735A41666666669D6229419A99997990735A410000000099622941333333138F735A41CDCCCCCC96622941000000208D735A419A9999999B622941333333D38A735A41CDCCCCCCA66229416666666688735A4166666666B16229419A9999F986735A4100000000C26229410000000086735A413333333301632941000000C085735A419A999999236329419A99997984735A419A9999993F6329419A9999B982735A419A99999943632941CDCCCCCC80735A4166666666456329419A9999597E735A41000000004B6329419A9999197D735A413333333365632941CDCCCC6C79735A416666666688632941CDCCCCEC71735A419A999999A3632941333333536A735A4100000000A3632941CDCCCC6C68735A419A999999A66329419A9999F966735A41CDCCCCCCB36329410000000066735A4133333333CC632941CDCCCC6C65735A4166666666E1632941333333F365735A419A999999006429419A99999966735A41CDCCCCCC16642941000000A065735A41CDCCCCCC216429419A9999B961735A4100000000246429419A99997958735A4133333333356429419A99997953735A41000000008A642941333333D347735A41333333339E6429419A99995945735A4166666666B6642941333333F340735A419A999999C0642941666666A63F735A41CDCCCCCCC86429419A9999393F735A4133333333DD6429419A9999B93E735A4166666666F6642941000000003E735A41CDCCCCCC166529419A9999993D735A419A99999930652941000000003D735A4133333333396529419A9999593C735A419A999999426529419A9999193A735A416666666669652941333333932E735A4100000000776529419A9999F92B735A41666666667D6529419A9999592A735A419A9999998B6529419A9999B926735A416666666696652941333333D322735A4166666666CB6529413333331314735A4133333333FD6529416666664611735A419A99999915662941333333730D735A41000000002A662941666666C609735A41CDCCCCCC426629419A99991906735A419A9999995B662941333333B304735A4100000000886629410000002002735A419A9999999C662941333333D3FD725A4133333333A7662941000000C0FB725A419A999999C56629419A999959F6725A4166666666E966294133333353F2725A413333333302672941333333D3EE725A41333333332E672941CDCCCC2CEB725A41CDCCCCCC5067294166666646EA725A416666666685672941000000E0E6725A410000000098672941000000A0E5725A419A999999D46729419A999979E1725A416666666601682941000000C0DE725A41666666662C682941666666A6DD725A41333333334568294166666666DC725A41CDCCCCCC84682941CDCCCC6CDA725A41CDCCCCCCB668294133333333D8725A4100000000DB68294100000080D4725A419A999999F6682941CDCCCCECD0725A413333333319692941CDCCCC2CCC725A41000000003469294133333353C8725A41333333335F6929419A9999F9C3725A419A9999997B692941000000E0C1725A41CDCCCCCC916929419A9999F9BC725A4133333333AD69294100000080B7725A4133333333C46929419A999939B3725A4166666666D0692941000000A0B1725A4166666666FA692941CDCCCC0CAF725A41CDCCCCCC066A2941CDCCCCCCAC725A419A9999990D6A2941CDCCCCACA6725A419A999999166A294100000040A4725A4166666666346A29419A9999B99E725A41CDCCCCCC3D6A2941CDCCCC6C9C725A419A9999993C6A2941000000C09A725A41666666662E6A2941CDCCCC2C98725A41CDCCCCCC0E6A2941000000A093725A4166666666036A29416666660691725A4166666666FE692941000000008F725A4100000000006A29419A9999798C725A419A999999026A29419A9999598B725A4100000000086A2941CDCCCC8C89725A41000000000E6A2941333333F387725A41CDCCCCCC156A29413333339386725A41666666661C6A29410000006085725A4100000000266A29410000004084725A41333333332F6A2941000000A083725A41CDCCCCCC3B6A2941333333B382725A41CDCCCCCC456A29410000002082725A4133333333536A29413333339381725A4133333333646A29419A99991981725A4133333333736A2941CDCCCCCC80725A41000000007D6A2941666666C680725A41666666668D6A29419A99991981725A4100000000966A29410000008081725A41CDCCCCCCA06A29416666660682725A419A999999AD6A2941CDCCCCAC82725A419A999999B96A2941CDCCCC6C83725A4166666666C26A2941000000E083725A419A999999CD6A29413333331384725A41CDCCCCCCDA6A2941000000E083725A41CDCCCCCCE66A29416666664683725A41CDCCCCCCF06A29410000004082725A4133333333FA6A29419A99991981725A4166666666046B2941333333937F725A41000000000F6B2941666666267E725A4166666666216B2941666666267C725A41333333332D6B29419A9999F97A725A419A999999376B2941CDCCCCAC79725A4100000000406B2941CDCCCC6C78725A41CDCCCCCC496B29419A99999976725A4100000000506B29419A99995975725A41CDCCCCCC626B29410000004072725A419A999999986B29413333331367725A41CDCCCCCC9E6B29413333333365725A41CDCCCCCCA56B2941CDCCCC0C64725A419A999999AF6B29416666662663725A4133333333C86B29413333331361725A4166666666F06B2941666666E65E725A4166666666166C2941666666865E725A4100000000206C2941666666E65E725A41333333332C6C29419A9999B95F725A4166666666336C29410000004060725A419A9999993E6C2941CDCCCCEC61725A41333333334C6C29413333337363725A4100000000586C2941CDCCCC2C64725A4100000000616C29419A99993964725A419A9999996B6C29410000004064725A41000000007B6C2941CDCCCC4C64725A41CDCCCCCC8A6C29419A99995964725A4100000000A46C2941666666E663725A4100000000B46C2941666666E663725A41CDCCCCCCC16C2941333333B363725A4166666666CE6C2941CDCCCC2C63725A4166666666DA6C29419A99991962725A41CDCCCCCCF26C2941333333B35F725A41CDCCCCCC016D2941CDCCCCCC5E725A41000000001C6D2941333333935E725A4166666666296D29419A9999B95E725A4100000000316D29419A9999D95E725A41CDCCCCCC3A6D2941666666065F725A4133333333466D2941CDCCCC4C5F725A41CDCCCCCC536D2941333333935F725A4100000000646D2941CDCCCCCC5F725A4166666666706D2941666666A65F725A41CDCCCCCC776D2941000000405F725A41666666667E6D2941333333735E725A4133333333836D29419A9999D95D725A4133333333896D2941333333D35C725A41333333338F6D29419A9999795B725A4133333333966D2941000000205A725A41CDCCCCCC9C6D2941CDCCCC6C58725A4133333333A46D2941666666E656725A41CDCCCCCCAD6D2941333333D354725A4166666666B26D2941000000A053725A4166666666B96D2941CDCCCCEC51725A4133333333BD6D29416666662651725A4133333333C56D2941CDCCCCCC4F725A4100000000CD6D2941CDCCCC6C4E725A419A999999D46D29419A9999394D725A4166666666DF6D2941CDCCCC8C4B725A4133333333EB6D29416666666649725A4100000000F16D29419A99995948725A41CDCCCCCCF76D29413333331347725A419A999999006E29410000006045725A4133333333056E29410000006044725A4133333333096E29410000002043725A41666666660D6E2941666666A641725A4133333333126E2941CDCCCC2C40725A4133333333166E29419A9999993E725A4166666666196E2941CDCCCC2C3D725A419A9999991D6E29419A9999993B725A4133333333256E29419A99997939725A4100000000296E29410000000038725A41666666662C6E2941000000C036725A4100000000326E29416666662635725A419A9999995B6E2941333333732C725A4133333333726E2941CDCCCC4C26725A419A999999756E29416666660620725A4166666666776E2941000000201F725A41000000007A6E29419A9999F91D725A419A9999997E6E2941666666261C725A41CDCCCCCC836E2941CDCCCC8C1A725A419A999999886E29416666664619725A41000000008E6E2941000000E017725A419A999999926E2941333333D316725A41CDCCCCCC986E2941000000A015725A41666666669F6E29410000006014725A4166666666A56E29416666662613725A41CDCCCCCCA96E29419A99995912725A41CDCCCCCCAE6E2941CDCCCC0C11725A4166666666B36E29416666660610725A4100000000C66E29419A9999F90C725A41CDCCCCCCD06E2941000000000B725A4133333333D56E29413333335309725A419A999999D86E2941CDCCCCEC07725A4100000000D96E2941000000C006725A4133333333D46E29416666668605725A4166666666CF6E29416666660604725A4133333333C96E29413333339302725A419A999999C36E29419A99995901725A419A999999B76E2941666666E6FF715A4133333333B06E2941CDCCCC6CFE715A4166666666AA6E2941666666E6FC715A4133333333A76E294166666606FB715A4133333333A86E29419A999959F9715A419A999999A86E2941CDCCCC4CF7715A4133333333AA6E294166666606F6715A41CDCCCCCCAF6E2941CDCCCCECF3715A4166666666B56E294166666686F1715A4133333333BA6E2941CDCCCC0CF0715A419A999999BF6E29419A999999EE715A419A999999C66E294166666606ED715A4100000000CF6E294133333353EB715A4166666666D56E294100000000EA715A4166666666DD6E2941CDCCCC6CE8715A4166666666E76E2941CDCCCCCCE6715A419A999999F16E29419A999919E5715A41CDCCCCCCF86E294100000020E4715A419A999999006F294133333333E3715A4166666666096F29419A999979E2715A41CDCCCCCC126F29419A999919E2715A419A9999991D6F2941333333F3E1715A4166666666296F2941CDCCCCECE1715A4100000000336F2941333333B3E1715A41CDCCCCCC3D6F29419A999999E1715A419A999999496F2941CDCCCC2CE1715A419A9999994C6F294100000080DF715A41CDCCCCCC4D6F294100000060DE715A4133333333506F29419A9999D9DC715A41333333334E6F2941666666A6DA715A419A9999994C6F2941000000E0D8715A41666666664C6F294133333373D7715A41000000004B6F29419A999919D5715A41CDCCCCCC496F29419A999939D3715A419A999999476F294100000040D1715A4100000000446F2941CDCCCCCCCF715A41CDCCCCCC3E6F2941666666C6CD715A41CDCCCCCC3B6F294166666666CC715A4100000000366F294133333393CA715A4100000000306F294100000080C9715A4133333333286F2941CDCCCC0CC8715A41666666661E6F29419A9999D9C6715A4100000000156F294166666666C5715A41333333330B6F2941CDCCCC0CC4715A4166666666006F2941CDCCCC8CC2715A4100000000EE6E2941CDCCCC6CC0715A419A999999E06E294100000080BE715A4100000000D66E29419A999919BD715A4166666666CD6E2941000000A0BB715A4100000000BF6E29419A9999F9B8715A4166666666B66E294166666626B7715A4133333333AA6E2941000000C0B5715A41333333339D6E294133333353B4715A419A999999956E2941333333B3B2715A41000000008E6E2941000000E0B0715A419A999999856E2941CDCCCCACAE715A41333333337E6E29419A9999D9AC715A419A999999746E2941666666E6AB715A419A999999686E294133333313AB715A41666666665D6E2941CDCCCCACAA715A4133333333466E29419A999939AA715A4133333333376E2941CDCCCC6CA9715A4100000000306E294166666626A9715A41CDCCCCCC2E6E294100000020A7715A41666666662E6E294100000040A5715A41666666662D6E294166666606A3715A4166666666476E2941000000A090715A4166666666506E2941333333138C715A4166666666556E2941333333D389715A41333333335E6E29413333339387715A4166666666A66E29419A9999997F715A41666666660B6F2941000000C071715A4133333333156F2941000000C06C715A419A999999FB6E29419A99999964715A41CDCCCCCCFA6E2941000000A062715A41CDCCCCCCFA6E2941000000E060715A4133333333FA6E29419A9999995E715A419A999999F96E2941000000C05C715A4133333333F86E29419A9999D95A715A41CDCCCCCCF56E29419A99991959715A4100000000F36E29413333339357715A419A999999F06E29416666666656715A4100000000ED6E29419A9999D954715A4100000000E96E29413333339353715A4166666666E46E29416666664652715A4133333333DF6E2941CDCCCC0C51715A41CDCCCCCCD96E2941CDCCCCCC4F715A41CDCCCCCCCF6E2941000000604D715A4166666666CE6E29419A9999194D715A4133333333CB6E2941000000604C715A419A999999C56E2941CDCCCCAC4A715A4133333333C56E29419A9999F948715A4166666666CC6E2941CDCCCCEC44715A4166666666D26E2941000000A041715A4133333333D76E29419A9999B93F715A41CDCCCCCCDF6E29419A9999393D715A4100000000E76E2941000000203B715A4166666666EC6E2941666666E636715A4133333333F26E2941CDCCCCAC32715A419A999999E76E2941666666662C715A41CDCCCCCCE36E2941333333B32B715A4133333333E06E2941CDCCCC0C2B715A4166666666DC6E29419A9999592A715A419A999999DA6E2941CDCCCC8C29715A41CDCCCCCCD96E2941CDCCCCAC28715A4166666666D86E29410000008027715A4133333333D86E29413333337326715A41CDCCCCCCD96E29416666660625715A4100000000DC6E2941333333F323715A4166666666DD6E2941CDCCCC0C23715A419A999999DF6E29419A9999D921715A419A999999E06E29410000004021715A4100000000E46E29410000004020715A4166666666E56E2941333333931F715A41CDCCCCCCE76E2941CDCCCCAC1E715A4100000000EA6E29419A9999991D715A41CDCCCCCCEB6E2941000000E01C715A419A999999EF6E2941666666A61B715A4133333333F46E29419A9999391A715A41CDCCCCCCF56E29413333337319715A41CDCCCCCCF76E2941CDCCCCAC18715A41CDCCCCCCFA6E29419A9999D917715A4133333333FE6E29413333331317715A4133333333026F29413333331316715A419A999999066F2941333333F314715A41333333330D6F29413333331313715A4166666666106F29416666664612715A41CDCCCCCC126F2941000000C011715A41CDCCCCCC156F2941CDCCCC2C11715A4166666666186F2941CDCCCC8C10715A41333333331B6F2941CDCCCC8C0F715A41333333331D6F2941666666660E715A41333333331E6F2941CDCCCC6C0D715A4100000000206F29419A9999590C715A4166666666216F2941333333330B715A4133333333236F29419A9999F909715A4133333333266F29413333339308715A4166666666296F29416666662607715A41666666662B6F2941CDCCCC4C06715A41333333332D6F29410000006005715A41000000002F6F29419A99999904715A4133333333336F29419A9999B902715A4100000000366F2941CDCCCCEC01715A4133333333386F29419A9999F900715A4133333333396F29410000002000715A41CDCCCCCC396F29419A999979FF705A41666666663C6F294166666686FE705A41333333333E6F2941000000E0FD705A4166666666426F29419A9999F9FA705A4166666666446F294133333333F9705A4166666666466F2941000000A0F7705A419A999999486F294100000040F6705A41333333334B6F29419A999939F4705A419A9999994E6F2941000000A0F1705A41CDCCCCCC4F6F294166666646F0705A4133333333516F29419A999979EF705A4133333333546F2941CDCCCC6CEE705A4133333333586F294100000040ED705A41333333335F6F294166666626E9705A41000000008C6F29419A999919CF705A41CDCCCCCC9B6F2941CDCCCC6CC7705A4133333333CF6F2941CDCCCCCCAF705A4133333333EB6F2941000000A0A1705A41CDCCCCCCEE6F2941666666A6A0705A4100000000F26F2941333333F39F705A41CDCCCCCCF76F2941666666069F705A413333333306702941000000A09B705A419A999999257029413333335394705A413333333336702941333333D390705A419A9999993A702941CDCCCCCC8F705A41333333333F702941666666C68E705A416666666644702941000000C08D705A41CDCCCCCC4C702941000000408C705A410000000050702941666666A68B705A4166666666547029419A9999D98A705A41333333335C702941666666C689705A41CDCCCCCC607029413333333389705A413333333367702941000000C087705A410000000098702941333333B37E705A4100000000B57029410000000077705A41CDCCCCCCD2702941333333B367705A41CDCCCCCCDA702941000000A064705A4166666666FB702941333333F359705A4133333333057129413333339356705A41666666667C7129419A9999792D705A41CDCCCCCCB3712941333333131E705A4133333333BD712941000000201A705A410000000030722941333333B3F56F5A41666666665D7229419A9999F9EB6F5A41CDCCCCCC6B7229419A9999F9E56F5A4133333333BA7229419A9999D9C76F5A41CDCCCCCCBF72294133333333C66F5A4133333333C6722941666666E6C36F5A4100000000C972294133333333C26F5A4166666666CE7229419A999979BF6F5A4133333333D2722941333333B3BD6F5A4100000000D372294133333393BC6F5A4100000000D472294133333393BB6F5A4166666666D67229419A999979B96F5A4166666666D8722941CDCCCCECB76F5A41CDCCCCCCD972294100000040B76F5A4166666666DD7229419A999919B66F5A4100000000DF722941CDCCCC0CB56F5A419A999999E072294100000000B46F5A41CDCCCCCCE572294166666626B26F5A419A999999F9722941000000E0AD6F5A419A999999FB7229419A999979AD6F5A4133333333077329419A999919AB6F5A410000000022732941000000E0A56F5A416666666626732941CDCCCC0CA56F5A41CDCCCCCC28732941CDCCCC4CA46F5A41000000002C73294166666626A36F5A419A99999935732941000000609E6F5A41CDCCCCCC41732941CDCCCC4C986F5A41666666664673294100000060966F5A41000000004773294100000040956F5A41000000004673294166666626946F5A41666666664473294166666626936F5A41666666664273294100000080916F5A41333333333D732941333333938C6F5A410000000054732941000000A0866F5A416666666691732941666666E6826F5A4133333333A57329419A999999816F5A4166666666B97329419A999959806F5A419A999999CC7329419A9999997F6F5A41CDCCCCCCE0732941666666E67E6F5A4166666666FD732941CDCCCCAC7D6F5A41333333330D742941666666467C6F5A419A99999917742941666666E67A6F5A41666666661E74294133333333796F5A419A99999924742941CDCCCCCC776F5A41666666662F74294100000060766F5A419A99999941742941CDCCCC4C746F5A41000000004C7429419A999939716F5A41666666665E7429419A9999996C6F5A419A9999997474294133333353686F5A41333333337B742941CDCCCC0C676F5A41CDCCCCCCC5742941CDCCCC4C596F5A4100000000CE74294166666666576F5A4133333333D1742941CDCCCCAC566F5A41CDCCCCCCDE742941000000A0536F5A4100000000F1742941CDCCCC8C506F5A413333333312752941CDCCCCEC4A6F5A41000000002C7529419A9999B9456F5A419A99999944752941333333D3406F5A413333333355752941333333533D6F5A41CDCCCCCC70752941000000C0376F5A41CDCCCCCC87752941333333B3326F5A419A999999997529419A9999792E6F5A4166666666AF752941333333132A6F5A4166666666BD7529419A999919286F5A4100000000D4752941666666A6236F5A4166666666E7752941CDCCCC4C206F5A41CDCCCCCCFD752941000000A01B6F5A413333333309762941666666A6186F5A419A99999913762941CDCCCC0C156F5A41000000001D76294133333373116F5A419A99999926762941333333930E6F5A419A9999992F762941000000800D6F5A410000000041762941333333730C6F5A419A9999995E7629419A999959076F5A41666666666676294133333373056F5A41666666667376294100000020036F5A419A99999983762941333333B3016F5A41000000009E7629419A999919006F5A4133333333A576294166666646FF6E5A4166666666AA762941CDCCCCACFD6E5A4100000000B4762941CDCCCC2CF86E5A4100000000BD762941CDCCCC4CF16E5A41CDCCCCCCC4762941CDCCCC0CEC6E5A4100000000BD76294133333353E96E5A4133333333C876294133333353E86E5A419A999999D27629419A999919E66E5A41CDCCCCCCE176294100000020E26E5A4133333333F276294100000040DE6E5A4133333333FC76294133333353DB6E5A419A999999127729419A9999B9D46E5A41CDCCCCCC1F77294166666666D16E5A413333333335772941CDCCCC2CCC6E5A41333333335A772941666666A6C46E5A419A9999996977294166666666C06E5A419A99999977772941000000E0BC6E5A410000000086772941666666E6B96E5A4133333333B3772941000000A0B06E5A4166666666D4772941CDCCCCECA96E5A4100000000FA77294133333393A16E5A41666666661E78294133333353996E5A4133333333347829419A999939956E5A41666666663F78294100000020936E5A419A999999B3782941CDCCCC8C7D6E5A41CDCCCCCCC6782941000000E0796E5A41CDCCCCCCD7782941000000C0766E5A41CDCCCCCCF878294166666626716E5A41CDCCCCCC12792941CDCCCC0C6D6E5A416666666620792941000000E0696E5A410000000053792941333333D3606E5A4166666666977929419A999999546E5A41CDCCCCCCE47929419A9999B94C6E5A41666666662F7A2941CDCCCC0C3A6E5A41000000004C7A29419A999919376E5A41666666665A7A29419A9999F9356E5A419A999999B17A29419A9999592E6E5A4166666666407B2941CDCCCC2C296E5A4100000000627A2941000000E01C6E5A41CDCCCCCCAA792941CDCCCC8C136E5A41CDCCCCCC3F792941333333B3016E5A41CDCCCCCC17792941000000C0016E5A41CDCCCCCC29792941666666E6106E5A4100000000BB78294100000020286E5A41CDCCCCCCAA782941000000802B6E5A41CDCCCCCC8A782941666666C6316E5A41CDCCCCCC6278294133333393396E5A4133333333517829419A9999F93C6E5A41CDCCCCCC22782941000000C0456E5A4166666666F4772941000000C04E6E5A419A9999996B772941CDCCCC2C696E5A4100000000587729419A9999F96C6E5A410000000038772941333333B3736E5A413333333307772941CDCCCCAC7C6E5A4166666666CF76294166666686876E5A4133333333B6762941CDCCCC2C8D6E5A419A999999B2762941CDCCCCEC8A6E5A41CDCCCCCCAF762941CDCCCC2C896E5A41666666668C76294166666686826E5A416666666662762941000000007B6E5A419A9999994676294133333373766E5A41333333332D762941333333F3716E5A4166666666077629419A9999F96A6E5A4133333333D07529419A999939606E5A41CDCCCCCCB7752941000000A05B6E5A41333333339F752941333333F3566E5A4133333333897529419A999979526E5A413333333372752941000000E04D6E5A4133333333647529419A9999D9496E5A41666666664375294166666686426E5A41333333333A7529419A9999F93F6E5A410000000037752941666666263E6E5A419A999999107529419A999979356E5A41CDCCCCCCD67429419A9999F9236E5A4166666666C8742941666666E61E6E5A4166666666A37429419A999939136E5A41000000008A7429419A9999F90D6E5A41666666668974294100000000046E5A41666666666874294166666606FD6D5A419A99999944742941000000C0EE6D5A4100000000357429419A9999D9E66D5A41CDCCCCCC1D74294100000000DA6D5A4100000000FF73294133333353CE6D5A4133333333E473294100000080CB6D5A4166666666A8732941CDCCCCACCF6D5A419A9999996773294100000080D36D5A41000000001E73294133333373D86D5A41666666660D7329419A999919D96D5A4133333333A2722941333333D3DB6D5A416666666613722941000000E0DE6D5A41000000008C71294100000040E26D5A41333333331C712941333333D3E46D5A4100000000CD702941000000A0E66D5A4100000000B5702941666666E6E66D5A41CDCCCCCC787029419A999939E76D5A41CDCCCCCC1A702941333333D3E66D5A4166666666DF6F2941666666E6E66D5A41000000009A6F29419A999999EC6D5A419A999999736F2941CDCCCCCCE76D5A419A999999106F2941333333F3E16D5A4133333333836E294133333373D46D5A41CDCCCCCCF26D2941CDCCCC8CC56D5A41CDCCCCCCB46D294166666626C26D5A41333333336D6D29419A999999BF6D5A419A9999999D6C294166666646B86D5A4166666666496C29419A999979B36D5A4133333333DA6B2941CDCCCC6CAD6D5A41CDCCCCCCB56B2941000000C0AA6D5A41CDCCCCCC2F6B294166666606A46D5A419A9999998D6A2941000000A0986D5A41CDCCCCCC516A2941CDCCCC4C976D5A4100000000B4692941CDCCCCCC9E6D5A41CDCCCCCC4B69294133333333A46D5A4100000000196929419A999999A46D5A419A99999977682941000000809F6D5A419A9999991C672941333333D3926D5A41CDCCCCCC24672941CDCCCC8C866D5A41CDCCCCCC0C66294100000080736D5A4166666666B2652941000000206E6D5A41CDCCCCCCBA642941CDCCCC6C726D5A419A999999B8642941666666A66E6D5A4100000000C1642941666666665F6D5A4166666666B7642941CDCCCC6C4F6D5A41333333337A6429419A9999394A6D5A4133333333CE632941CDCCCCAC2D6D5A4133333333F9622941CDCCCC6C1C6D5A41CDCCCCCC2661294133333353E76C5A419A9999991561294166666626E56C5A4100000000C5602941333333D3DA6C5A41666666669260294100000020D26C5A41CDCCCCCC4D5F294100000040A96C5A41CDCCCCCC975E2941333333338A6C5A4166666666CD5D294133333333666C5A41666666665C5D294133333313566C5A4166666666695C29419A999959296C5A4166666666515C294100000020276C5A4133333333415C2941666666A6256C5A4133333333D45B294100000040326C5A41CDCCCCCC805B294100000000406C5A419A9999995D5B2941000000A0466C5A41333333334D5B294133333333556C5A41CDCCCCCC195B2941CDCCCCEC656C5A419A999999CB5A2941000000C07D6C5A4133333333AF5B294133333373D26C5A4100000000E45B29419A999919F36C5A4133333333195C294133333353026D5A419A9999995D5C2941000000A00C6D5A4166666666AC5C2941000000E0136D5A419A999999F55C2941CDCCCC4C196D5A4133333333305D2941CDCCCC8C2B6D5A41CDCCCCCC845D2941CDCCCC2C3D6D5A4133333333EE5D294100000000506D5A4166666666325E2941CDCCCC6C7A6D5A4166666666475E2941666666E68A6D5A4166666666675E2941CDCCCC8C986D5A41CDCCCCCC3F5E2941666666A6AC6D5A41CDCCCCCC455E29419A999999E86D5A4133333333165E2941000000600A6E5A4166666666BD5D29419A9999B91A6E5A41CDCCCCCC325D29419A9999992D6E5A41000000009A5C2941666666A6466E5A419A999999245C2941666666C6456E5A4133333333CC5C2941333333335C6E5A4100000000325D294166666646516E5A4133333333D65D294166666626626E5A419A9999991C5E294133333353686E5A4166666666DB5E294100000000826E5A419A9999990F5F2941CDCCCCAC7C6E5A4100000000505F2941333333F38F6E5A4100000000355F29419A999939956E5A419A9999992F5F294100000040966E5A4100000000275F2941666666669C6E5A419A9999991E5F294133333393A26E5A419A9999991C5F294166666606A46E5A4133333333E15E294166666606B06E5A419A999999F85E29419A999919B46E5A41CDCCCCCCFA5E2941CDCCCC6CB56E5A4100000000FC5E294166666666B76E5A4166666666FC5E2941333333D3B86E5A41CDCCCCCCFF5E2941000000A0BA6E5A4100000000035F29419A999999BC6E5A41CDCCCCCC095F294133333393BF6E5A4133333333105F29419A9999D9C16E5A4100000000195F29419A999919C56E5A41CDCCCCCC1C5F2941333333B3C66E5A4133333333215F2941CDCCCC4CC86E5A4166666666335F29419A999979CE6E5A4133333333115F2941000000C0D66E5A4100000000FB5E294100000080D96E5A41000000000E5F2941CDCCCC4CE66E5A41666666663F5F2941333333F3E96E5A41000000004A5F2941CDCCCCECF36E5A41CDCCCCCC725F294100000060006F5A4133333333765F29419A999959146F5A41CDCCCCCC8A5F2941333333D31B6F5A41666666668C5F2941333333D3346F5A4133333333B05F294133333333396F5A41CDCCCCCCB45F2941666666C6396F5A4166666666D05F29419A9999F93E6F5A4100000000EC5F2941CDCCCC2C446F5A41CDCCCCCC0760294100000060496F5A4166666666236029419A9999994E6F5A41000000003F602941666666C6536F5A419A9999994C6029419A999959566F5A41CDCCCCCC74602941CDCCCCCC586F5A41666666669360294166666686616F5A419A9999999360294100000080666F5A41666666664E60294133333393706F5A419A9999994E60294133333353746F5A41000000006D602941CDCCCC0C786F5A410000000063602941CDCCCC8C7A6F5A419A99999963602941CDCCCC4C836F5A41CDCCCCCC95602941000000C0856F5A4100000000AA6029419A999939886F5A4133333333AA6029419A9999F98B6F5A419A9999998C602941000000C08F6F5A41000000008360294100000000966F5A419A99999951602941CDCCCC4CA06F5A4133333333206029419A9999D9A76F5A419A999999206029419A999919AE6F5A41000000003760294133333353B46F5A41CDCCCCCC196029419A999959BE6F5A4166666666106029419A999919C76F5A4166666666066029419A999959C86F5A41CDCCCCCC066029419A999959CD6F5A41666666665760294166666646D76F5A41CDCCCCCC6160294100000040DC6F5A41333333335860294100000080E26F5A41CDCCCCCCF45F29419A999919EA6F5A4166666666E25F294133333393F16F5A4133333333875F29419A999939EF6F5A419A999999045F294100000020E46F5A4166666666D25E2941CDCCCCECE26F5A4133333333795E294100000000ED6F5A4166666666795E294100000080EF6F5A4133333333F25E2941000000E0FB6F5A4166666666DE5E2941666666A6FF6F5A41CDCCCCCC0D5E29419A99999912705A4166666666DC5D2941666666A61B705A419A999999775C29416666664645705A4133333333465C2941CDCCCC0C4E705A419A999999A75B29419A99993962705A4166666666D75A2941CDCCCC2C7A705A4100000000F3592941CDCCCCAC8E705A41CDCCCCCC115A2941000000209B705A4100000000F4592941666666A69D705A419A99999966582941CDCCCCCCB3705A4100000000B65729419A999939B9705A413333333375572941000000E0B4705A41000000008E5629419A9999F9E9705A41000000001D56294133333333EF705A4133333333B25529419A999939F5705A41CDCCCCCC6E552941CDCCCC4CF5705A419A9999990055294133333333F2705A419A999999B554294166666646F2705A41666666664A542941CDCCCC2CF6705A413333333309542941000000A0F3705A4133333333CD532941333333B3F3705A41666666668753294166666686F5705A41CDCCCCCC6E5329419A999959F9705A410000000038532941CDCCCCCCFD705A4133333333CF5229410000004000715A4100000000465229419A99991900715A4100000000F15129413333333300715A41CDCCCCCCCD51294100000020FC705A41CDCCCCCC96512941666666E6FB705A41CDCCCCCC37512941333333B3FB705A41CDCCCCCCE750294133333333FB705A4166666666B850294100000000FD705A419A9999997A5029416666666604715A4100000000235029419A99995905715A419A999999DF4F2941CDCCCCAC03715A41CDCCCCCCC34E2941666666C6FC705A4100000000424E294100000040FF705A419A999999844D2941CDCCCC6C04715A41CDCCCCCCB74D2941333333B315715A41CDCCCCCCA44D2941666666A626715A4166666666B44C29419A9999391B715A41333333335F4B2941CDCCCCCC09715A419A999999C74A2941CDCCCCEC0E715A41CDCCCCCC954A2941CDCCCC8C0F715A4133333333B54A2941CDCCCCAC14715A41CDCCCCCCD84A29419A9999D91C715A419A999999E04A29413333333321715A4166666666D24A2941000000802B715A4133333333BF4A29413333335336715A41CDCCCCCCBC4A2941CDCCCC6C3A715A419A999999644A29413333331357715A41666666664D4A2941333333535F715A4133333333304A29419A9999D96B715A419A9999991C4A29416666666674715A419A999999134A2941333333B37D715A41	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