SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep10;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep10 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep10','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep10','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep10','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep10"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000D4A29E8D6D332941666666862BED5941	100020000	Z	Ailleville	1000200	10002	10	44	5
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	01010000206A0800001306BAD7B10D27419A999959DCE85941	100030000	Z	Aix-Villemaur-Pâlis	1000300	10003	10	44	75
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	01010000206A080000502BA918B6E327413433335311105A41	100040000	Z	Allibaudières	1000400	10004	10	44	24
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	01060000206A080000010000000103000000010000008A0100003333333325902841000000E0E9F05941333333333C902841666666A6F6F05941CDCCCCCC77902841CDCCCCAC09F15941CDCCCCCCD1902841666666E619F15941CDCCCCCCF9902841CDCCCC4C2DF15941CDCCCCCC0B912841666666463EF15941000000005E9128410000002056F1594166666666C89128413333335366F15941CDCCCCCC24922841CDCCCC2C73F15941000000007B9228419A9999197AF159419A999999A3922841CDCCCC0C83F1594166666666C9922841CDCCCC6C86F15941CDCCCCCCE7922841666666E695F15941666666663A932841CDCCCCACA4F1594166666666E293284100000020B9F15941000000002D942841000000E0C2F15941666666665E942841CDCCCC2CCCF159419A999999709428419A999959D5F159416666666673942841CDCCCC8CE0F159419A9999998A9428419A999939ECF1594166666666BD942841000000C0F5F15941000000002B952841000000C0FFF159419A999999A1952841CDCCCC6C07F259419A9999993C9628419A99999910F2594133333333CD9628410000004017F259416666666651972841666666461BF25941666666660E982841333333132DF259419A999999399928419A9999593CF2594100000000BC992841CDCCCC8C47F2594133333333569A2841333333534BF25941CDCCCCCCB09A28419A9999F953F25941CDCCCCCC219B28419A99995965F25941CDCCCCCC3F9B2841CDCCCC4C65F2594166666666539B2841CDCCCC4C60F2594133333333A39B2841333333B35DF25941CDCCCCCCAC9B28413333337357F2594166666666969B28419A99993951F2594100000000B49B2841333333F34AF2594133333333DC9B2841666666A64EF2594100000000FA9B2841000000604DF2594100000000BD9B2841333333733EF259419A999999ED9B2841CDCCCCEC27F259419A999999F69B2841CDCCCC2C1AF25941CDCCCCCC279C2841000000E00EF25941000000009F9C28410000000006F25941333333339E9C284100000080F9F15941CDCCCCCC019D284166666626F3F159419A999999979D284100000000F3F15941CDCCCCCCF09D284166666666E6F15941000000000E9E284100000020DBF15941000000000B9E2841CDCCCC6CAFF15941666666661E9E284166666626A9F15941CDCCCCCC099E2841CDCCCCEC9DF159419A9999991B9E2841CDCCCCAC7EF1594133333333399E28416666666678F159413333333313A02841CDCCCCEC7EF159419A9999994EA32841000000C099F15941CDCCCCCC47A62841CDCCCCECB1F15941CDCCCCCC5FA728419A999959B6F1594166666666DBA8284133333373B3F15941CDCCCCCC64AB2841666666A6B4F1594166666666B7AC284133333333BBF159410000000010AD2841CDCCCCACBBF1594133333333FFAC284133333313CEF15941000000005FAD2841000000E0CFF159419A999999CBAD2841666666A6D4F15941000000001AAE28419A999939DDF15941666666666DAE2841333333D3DDF15941CDCCCCCCBBAE2841000000A0E0F159410000000038AF2841000000C0E0F15941666666665CAF2841CDCCCC6CE2F159419A999999D3AF284100000000E3F15941333333330BB0284100000040E2F15941333333332CB028419A999959DDF159413333333390B0284166666646DEF1594100000000BAB028419A999959E1F1594100000000D9B02841000000A0E8F1594133333333DBB1284166666666E9F159413333333363B2284133333333E8F1594166666666B6B2284133333353E5F15941CDCCCCCC27B32841CDCCCCACDFF1594100000000A2B32841333333F3E1F15941CDCCCCCCBCB328419A999979E4F1594133333333E6B32841CDCCCC4CD7F159419A99999905B42841CDCCCC0CD2F1594100000000F6B32841CDCCCCCCCBF159416666666634B428419A9999F9C8F15941333333331BB428419A9999B9C1F15941000000000BB428419A9999B9B8F15941333333331BB4284100000040B1F15941CDCCCCCC56B4284166666626B0F159410000000078B4284100000000ADF159416666666690B42841CDCCCC2CA5F1594100000000E2B42841666666E6A0F159410000000021B52841CDCCCC2C94F15941CDCCCCCC5CB52841666666C693F159416666666674B52841CDCCCC0C8AF15941CDCCCCCC95B528413333339383F159419A999999D9B52841CDCCCC4C82F159413333333303B62841666666A67DF159416666666627B628419A9999197CF15941CDCCCCCC8AB628410000004073F15941CDCCCCCCFBB72841000000E068F15941CDCCCCCC82B82841666666A667F15941CDCCCCCCE6B828416666664669F1594133333333C2B928419A9999196AF159416666666652BA2841000000E068F159419A9999998FBA28416666668669F1594133333333EDBA2841000000005FF159410000000062BB2841666666A661F159410000000000BC2841CDCCCC8C58F1594100000000D1BC2841333333934AF15941666666664ABE2841333333B329F15941666666669ABE28419A99999929F15941CDCCCCCC6CBF28410000002032F1594133333333D6C028419A9999794AF1594133333333DEC22841CDCCCCEC4EF15941000000001AC328419A9999994DF159416666666639C32841CDCCCCCC62F159416666666633C32841666666069BF159416666666648C3284100000040ABF159419A99999991C32841666666A6BCF159419A9999998DC32841333333D3D0F1594133333333EDC32841CDCCCC4CD4F15941333333331AC52841333333F3E7F15941CDCCCCCC1AC52841333333B3F0F159419A999999D9C5284100000040FEF15941000000003FC728419A9999991AF259413333333324C728416666664624F259413333333340C728419A99991932F259419A9999993BC72841333333F339F259410000000017C72841333333933FF259416666666609C72841333333B344F259410000000018C728419A99991952F25941333333330AC728413333339354F259416666666630C728419A9999995DF259413333333344C728419A9999F965F25941CDCCCCCC58C728416666666667F25941333333334DC72841666666E66CF25941000000006FC72841000000C073F259416666666674C728419A9999597DF25941000000004CC72841666666067EF25941CDCCCCCC3FC728419A9999D980F259419A99999963C728416666660686F259410000000090C72841CDCCCC6C88F2594133333333A0C72841333333B38EF259413333333385C728410000004090F2594133333333A6C728416666668696F25941333333339DC72841666666469FF2594166666666A2C72841666666C6A7F2594166666666C9C728419A999959A9F25941CDCCCCCCEEC72841CDCCCC6CB3F2594100000000CBC72841666666A6B5F2594100000000D6C72841CDCCCC4CBAF259410000000000C82841CDCCCCCCC0F25941333333331FC82841CDCCCCECC1F259419A99999945C8284100000040C8F25941CDCCCCCC45C82841CDCCCC2CCCF259419A99999978C82841333333D3D0F259416666666683C82841CDCCCC2CD8F259410000000098C8284166666666DBF25941CDCCCCCC81C8284166666666E1F25941CDCCCCCCA1C8284166666606E5F25941000000009EC8284133333353EFF2594166666666C2C828419A9999F9F0F2594100000000ECC828419A999919F8F2594166666666EDC8284100000080FEF2594166666666D8C828410000004000F35941CDCCCCCCDEC82841666666C606F35941CDCCCCCCFFC82841000000A00CF359413333333301C928416666662611F35941333333331EC928410000002017F359419A9999991BC928419A9999591DF359413333333335C928419A99993921F359410000000055C928419A9999F929F359410000000062C92841333333B330F35941CDCCCCCC62C92841666666C63FF35941CDCCCCCC9AC92841333333D33EF3594166666666BBC928419A99991946F359413333333396CA28410000004036F359419A999999FCCB28410000002023F3594133333333CECC28419A9999191AF359416666666619CD2841666666661BF359416666666639CE28416666666611F3594133333333BFCE2841CDCCCC2C0CF359416666666680CE28419A999939EBF25941000000006BCE28419A999959DEF259416666666696CE28419A999979D2F25941333333339ECE284133333333CCF259419A9999990BCF28419A999999C4F25941333333331FCF284133333313BEF25941CDCCCCCC45CF2841CDCCCC0CAAF259419A9999995CCF2841000000E095F25941666666668FCF2841333333B379F25941666666666DCF2841333333536FF259419A9999999ACF2841000000C05DF2594166666666C9CF28419A9999B94EF259419A9999992CD028410000006043F25941000000001FD228419A9999D92EF2594166666666BED22841CDCCCCAC29F2594133333333FAD22841000000E025F25941000000002BD328413333335314F259419A9999998DD328410000008001F25941CDCCCCCC67D4284166666646E8F159419A999999D8D6284100000060B6F1594133333333FFD6284133333353B6F159419A9999995DD828410000000097F159413333333306D928413333339386F1594100000000CDD92841000000E074F1594166666666E0DA2841666666265EF159419A999999BCDB28410000006060F15941666666664DDC28413333339362F1594166666666B1DC28416666668665F159416666666634DD2841CDCCCC8C6CF1594166666666B8DD28413333337376F15941000000000ADE2841666666467AF15941333333337BDE2841CDCCCC0C79F15941CDCCCCCC83DE2841666666E672F15941CDCCCCCCBCDE28419A99995961F1594100000000D6DE2841333333D34DF1594133333333FEDD2841666666C638F159416666666643DE2841333333F32FF15941CDCCCCCC38DE28419A9999B924F15941CDCCCCCC04DE2841CDCCCC0C08F159419A99999910DE284166666666CBF059419A999999EBDD28419A999919C5F059419A999999BBDD2841CDCCCCECB6F059410000000082DD284100000040A0F05941000000002CDD2841CDCCCCAC6FF05941CDCCCCCCF7DC28410000004055F0594133333333E0DC28413333337346F0594133333333C9DC2841666666C62EF05941CDCCCCCC92DC28413333331326F059419A999999BBDC28410000008010F05941CDCCCCCC24DC2841CDCCCCEC16F05941CDCCCCCC8DDB28419A99995902F059416666666681DB28419A9999F9FEEF594133333333B2DA2841666666A6EEEF59413333333327DA284166666686FCEF594133333333FFD92841333333D3FDEF5941333333330ED928419A999959EAEF594100000000DCD82841666666E6E7EF594133333333B4D82841CDCCCCACEBEF5941CDCCCCCC6DD8284166666686E5EF59413333333350D82841CDCCCC4CE9EF5941CDCCCCCCFFD7284100000060E4EF5941CDCCCCCCD9D628419A9999B9C1EF59410000000059D628419A999919D2EF59410000000027D6284166666666D3EF59416666666608D62841333333B3CAEF59419A999999C5D52841000000C0D9EF59416666666689D5284133333353D7EF5941CDCCCCCC6BD528419A999959DCEF59419A9999991BD52841CDCCCCECD9EF594133333333C9D4284166666646D1EF59410000000031D42841333333B3AFEF59410000000009D42841000000C0AFEF59419A99999969D32841CDCCCCACB8EF59419A99999937D32841CDCCCC8CBDEF594166666666FAD22841CDCCCC0CA6EF59419A9999998AD22841CDCCCCAC89EF5941666666665ED22841CDCCCCEC85EF5941000000003BD228416666660690EF59413333333313D22841CDCCCC0C90EF5941333333337FD12841CDCCCCEC77EF5941CDCCCCCC0ED128419A9999D988EF594100000000FBD028419A9999198AEF59419A999999A4D028413333339382EF59413333333389D028419A99991987EF59419A999999FDCF2841000000C079EF5941666666663BCF28413333339368EF59410000000026CF28410000004070EF594166666666C2CE2841666666E663EF5941666666661ECE2841CDCCCC2C5FEF59419A99999927CE2841CDCCCCEC53EF594100000000B5CC28413333335345EF59419A999999D1CC2841CDCCCC8C32EF59416666666654CC28413333339331EF594166666666E4CA28419A9999D91CEF594133333333E4CA28419A99991919EF5941CDCCCCCC1ECB2841CDCCCC4C06EF594133333333B0CA2841CDCCCCECF9EE5941CDCCCCCC9BCA2841333333F3F4EE594100000000D7CA2841666666A6E9EE5941CDCCCCCCCCCA2841666666E6E5EE59410000000004CA284100000060D8EE5941CDCCCCCC52C92841CDCCCCECD0EE59419A99999923C92841000000A0D0EE59419A99999960C828419A999919C6EE5941CDCCCCCC4AC828419A999959CCEE5941CDCCCCCC07C82841333333F3C8EE594166666666B5C7284166666606CAEE59413333333379C728419A999959C6EE59410000000092C728419A999959B6EE59413333333322C72841333333B3ABEE59419A99999908C6284166666646B9EE594166666666A0C428419A999999D2EE5941CDCCCCCC64C42841CDCCCCACD7EE5941333333338EC428419A9999D9ECEE594100000000D1C32841CDCCCC0CF7EE5941333333336DC3284166666626F7EE594100000000E1C2284133333393F3EE59413333333325C228410000000013EF5941666666669FC12841333333D330EF594100000000B5C028419A99995935EF5941CDCCCCCCACC028410000000036EF59410000000090BF28413333339338EF5941CDCCCCCCE9BE2841CDCCCC2C3BEF59419A9999993DBE2841666666A63AEF5941CDCCCCCC39BC2841666666E639EF594100000000C1BB2841666666C64CEF5941CDCCCCCC84BB28413333335359EF59419A99999996BB28419A9999F969EF5941CDCCCCCC86BB28419A99997976EF59419A99999982BB28419A9999F9AAEF594133333333ECBA2841666666C6A3EF594166666666EEB92841CDCCCC6C94EF5941CDCCCCCC1AB92841CDCCCCEC8AEF59419A999999E8B82841000000E087EF594100000000A6B82841666666E686EF5941333333338DB62841666666468CEF594100000000DFB42841000000408FEF594100000000B1B428413333333390EF594166666666D0B42841333333138CEF59413333333334B52841333333935EEF5941CDCCCCCC5AB528413333333345EF594133333333EFB52841CDCCCCCC2FEF59416666666648B62841333333B324EF59419A99999987B42841333333B332EF59413333333384B328419A9999B936EF59410000000052B328416666664634EF5941CDCCCCCCC5B02841000000400DEF59419A999999CBAF28416666664607EF59419A999999EFAE28410000004006EF5941333333331EAE28419A9999B90CEF59410000000098AD284166666666CEEE5941333333335BAD28419A999939C3EE59410000000029AD284166666686BFEE5941CDCCCCCC28AD284166666606BDEE59410000000058AD284100000040AFEE5941CDCCCCCC21A92841000000A0BFEE59410000000010A9284166666626C2EE5941333333332EA9284100000020C7EE594166666666CCA828419A99995913EF594133333333C5A828416666664623EF594133333333AEA828413333333344EF594133333333AEA82841CDCCCC2C57EF5941CDCCCCCC98A82841CDCCCCEC60EF5941666666663BA828410000002034F059419A999999F9A72841000000C073F059419A99999908A828419A9999997AF05941CDCCCCCCECA72841CDCCCC2C86F0594133333333DAA72841000000A0D1F0594133333333DEA628419A999919F4F059419A99999961A528419A999999CDF059416666666624A42841CDCCCC8CACF0594100000000E5A22841CDCCCC0C8AF0594133333333CCA12841000000C069F059419A999999B0A128413333331368F0594166666666B4A12841333333D362F05941CDCCCCCCCAA028413333339349F05941CDCCCCCC75A028410000002044F059419A999999C09F28419A99991932F05941CDCCCCCCDD9F2841CDCCCC8C2EF059419A99999965A028419A99995915F0594100000000E3A02841000000C0F5EF594133333333F6A02841333333D3EFEF5941CDCCCCCC2AA1284100000000E8EF59410000000049A128419A9999B9E0EF5941CDCCCCCC809E2841666666E69FEF594100000000EB9B2841000000E07DEF594100000000A59B2841333333B37CEF5941CDCCCCCCBC992841CDCCCC2CBDEF5941CDCCCCCC8898284100000000ADEF59419A9999994C98284133333393AAEF59419A9999999A97284100000080C7EF59419A999999AF9628419A9999F9EFEF5941CDCCCCCC389628413333339301F059419A999999069528410000006036F05941CDCCCCCCF19328416666666662F05941666666662C9328413333335384F059419A99999904932841000000E086F0594133333333BE922841333333B380F059419A9999998C922841000000C085F059413333333346922841333333937FF05941333333330A922841666666A67FF05941CDCCCCCCE8912841CDCCCC2C8AF05941666666666D912841666666C6ACF05941666666660A91284100000060B9F0594133333333D790284166666606C3F059416666666693902841000000C0C8F05941333333334590284166666686D9F059413333333325902841000000E0E9F059413333333325902841000000E0E9F05941	01010000206A080000030942F92EB728419A999959FFF05941	100050000	Z	Amance	1000500	10005	10	44	23
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	01010000206A08000084361EE11CF027419A999909E7095A41	100060000	Z	Arcis-sur-Aube	1000600	10006	10	44	9
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	01010000206A0800002106D11D454A29419A99991973E25941	100070000	Z	Arconville	1000700	10007	10	44	15
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	01010000206A080000A7AB9F489CFD2841666666465FEC5941	100080000	Z	Argançon	1000800	10008	10	44	8
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	01010000206A0800002B5A5F41754028419A999909BCD55941	100090000	Z	Arrelles	1000900	10009	10	44	14
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	01010000206A0800008C3760203BF82841333333E3F20B5A41	100100000	Z	Arrembécourt	1001000	10010	10	44	7
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	01010000206A080000DAFB5BE3C5492941CCCCCCEC8FEE5941	100110000	Z	Arrentières	1001100	10011	10	44	14
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	01010000206A08000047278D34FB1729416666660664EF5941	100120000	Z	Arsonval	1001200	10012	10	44	8
01060000206A08000001000000010300000001000000BD0000003333333379BC274166666646B5E4594100000000D7BC274166666686BFE45941666666661DBD2741CDCCCCCCC6E459419A9999994ABD2741CDCCCC8CCBE459410000000072BD27419A999919D0E45941333333339BBD2741666666E6D4E4594166666666ADBD274100000020D7E45941CDCCCCCCB2BD2741666666E6D7E4594100000000B7BD2741666666C6DDE4594166666666BDBD2741000000C0E1E459419A999999DDBD274100000040E9E459419A99999964BE274133333333F6E45941333333336FBE2741666666C6F7E459419A99999980BE27419A9999F9F9E459413333333389BE27419A9999F9FAE459416666666693BE27419A999919FCE45941CDCCCCCC9BBE2741CDCCCCECFCE459419A999999A8BE274166666646FEE4594100000000B8BE2741333333D3FFE4594133333333CDBE27419A9999D901E5594166666666E6BE27419A99995904E559416666666600BF2741666666C606E559416666666619BF2741666666E608E559410000000034BF2741000000600BE559413333333361BF2741333333130FE559419A99999991BF27413333339313E55941CDCCCCCCB2BF2741CDCCCC8C16E559419A999999CABF27416666666618E5594100000000E4BF2741666666461AE5594100000000F9BF2741CDCCCCCC1BE55941333333330CC027419A9999391DE559419A99999926C02741333333F31EE55941000000003CC027416666664620E559419A99999954C02741333333F321E559416666666664C02741CDCCCC0C23E55941CDCCCCCC75C02741CDCCCC2C24E559419A9999998DC02741666666A625E559419A999999A4C027416666662627E5594100000000BDC02741333333B328E5594100000000D9C02741000000602AE5594100000000F5C02741333333132CE559410000000031C127416666662630E559416666666657C127419A9999B932E559419A9999997EC127413333335335E55941666666668DC127410000008036E559419A99999992C127416666662637E559413333333396C127419A9999D937E55941333333339CC127413333331339E559419A9999999EC12741333333D339E5594100000000A2C12741333333533BE559419A999999A3C12741333333333CE55941CDCCCCCCA4C12741000000003DE5594100000000A7C12741333333F33DE5594166666666A8C127419A9999D93EE55941CDCCCCCCA9C12741CDCCCCAC3FE5594166666666ABC127410000008040E5594166666666C2C12741333333D340E5594166666666D1C12741CDCCCCAC40E5594133333333E7C12741CDCCCCAC40E55941CDCCCCCC02C22741333333B340E55941666666660CC227410000002041E559410000000014C227413333333342E559419A99999925C22741333333B345E55941CDCCCCCC3BC22741333333D349E55941333333331FC227419A9999D963E559419A999999F6C527410000000028E5594133333333AAC527419A9999D91EE559419A999999C5C52741000000001BE55941CDCCCCCCD5C527416666664619E559416666666610C62741666666C611E559419A99999991C62741000000A001E5594100000000E3C6274133333313F8E459410000000030C72741CDCCCCACEDE45941000000006CC727419A999919E6E4594166666666A8C727419A999979DDE4594100000000CBC72741CDCCCC6CD9E459419A9999997CC92741666666C6AFE459413333333320CA27413333333395E459419A9999994BCA2741333333338EE4594100000000D6CA27419A9999197CE45941000000000ECB2741CDCCCCCC74E4594166666666E7CC2741000000603CE459419A99999901CD27413333335339E45941666666660ACD2741CDCCCC6C38E459419A99999988CD2741333333F326E45941666666668DCD27419A99997926E45941CDCCCCCC2ECE27416666666613E4594166666666A8CE274133333353FBE35941CDCCCCCCD1CE274100000000F2E35941CDCCCCCCE2CE274133333353EFE359416666666611CF27419A9999B9E6E359410000000077CF2741666666E6CFE35941CDCCCCCC80CF27419A9999B9CDE359416666666696CF2741333333D3C9E359419A999999BACF27419A9999B9C1E35941CDCCCCCCCCCF27419A999979BEE359419A9999993ED02741CDCCCCCCACE35941CDCCCCCC5CD027419A999939A9E3594133333333ADCF27413333339399E35941000000003BD12741CDCCCCAC97E359416666666640D127419A99997997E35941CDCCCCCC47D127410000008097E35941666666669FD12741000000A030E359419A99999994D127419A9999792BE35941CDCCCCCC8FD127419A99993929E3594133333333F3D02741333333B311E35941666666669FD02741333333330FE359419A99999959D027419A9999190DE3594100000000DACF27416666668605E359419A999999A5CF2741CDCCCC8C01E35941333333337ECF274166666626FDE25941666666662ECF274133333353F6E2594100000000EFCE274133333333EFE25941000000007ECB2741000000E073E25941000000004BCA27419A9999997EE25941000000000FCB2741000000809BE25941666666665FC8274100000040F3E25941000000002DC82741000000C0F9E259410000000037C8274166666666FBE25941000000002EC8274100000060FCE25941666666663EC8274133333313FFE259419A9999997FC82741CDCCCCEC08E35941666666668AC827419A9999D90AE35941000000002CC827410000008015E359419A999999E6C727419A9999591DE3594100000000A8C727413333333318E35941CDCCCCCC8AC727419A9999F91DE359413333333361C727416666668623E359419A9999997DC727419A9999F926E359410000000052C72741666666C62CE359410000000021C727419A9999D932E35941000000002BC72741CDCCCCEC34E359410000000031C727413333339336E35941333333334DC62741666666264EE359419A99999961C627419A99999950E359419A99999941C62741666666A655E359419A9999995AC627419A99999958E359416666666638C62741000000605BE359410000000025C62741666666E661E3594133333333E7C52741333333336EE35941CDCCCCCCBEC527416666664676E359419A999999D3C52741000000C077E3594100000000A9C527419A9999B97FE359419A99999966C52741666666C68CE3594133333333A6C4274133333373B1E359419A999999A3C4274166666606B2E3594133333333A8C427419A999959B2E3594166666666BCC427419A999999B3E35941333333337DC4274133333333BBE359419A99999959C4274133333373BFE35941CDCCCCCC08C42741CDCCCCCCCBE3594166666666EEC3274133333313C9E3594166666666BFC327419A999919CFE359416666666695C327419A999979D4E359419A99999923C327419A999919E4E359419A99999900C3274133333373E0E3594133333333A0C2274166666646F5E3594166666666B2C2274100000040F7E359419A99999981C22741CDCCCC0C06E45941CDCCCCCC85C227413333337306E45941666666669FC22741333333F308E459419A9999999CC227413333333309E45941CDCCCCCC76C22741CDCCCCAC0DE459416666666637C22741CDCCCC2C15E459410000000022C227419A9999B917E459413333333316C22741666666461AE459413333333300C227419A9999D917E45941CDCCCCCCF4C127419A9999D919E459419A999999FAC127419A9999991AE459416666666601C227419A9999591BE4594166666666F5C12741000000801CE4594100000000E2C12741333333F31EE4594133333333D6C12741000000A020E4594100000000CDC127413333339321E459419A999999BFC12741CDCCCC0C20E459419A99999992C12741CDCCCCCC27E45941CDCCCCCCA6C12741CDCCCCCC29E459413333333359C12741333333D331E459410000000018C12741000000A03FE459410000000099C02741CDCCCC2C4EE459416666666606C02741666666C65CE4594133333333DBBF27410000002057E4594133333333CEBF2741CDCCCC4C55E4594166666666DCBE2741000000E06FE4594166666666CDBC274100000000AAE459416666666605BD2741CDCCCCACB1E45941CDCCCCCCD3BC27419A9999F9B7E459419A99999995BC2741666666C6B1E459413333333379BC274166666646B5E45941	01060000206A080000010000000103000000010000005B0000003333333379BC274166666646B5E459419A9999994ABD2741CDCCCC8CCBE45941CDCCCCCCB2BD2741666666E6D7E4594166666666BDBD2741000000C0E1E459419A999999DDBD274100000040E9E459419A99999964BE274133333333F6E459419A99999980BE27419A9999F9F9E459416666666600BF2741666666C606E55941CDCCCCCCB2BF2741CDCCCC8C16E55941333333330CC027419A9999391DE5594100000000F5C02741333333132CE559419A9999997EC127413333335335E55941333333339CC127413333331339E5594166666666ABC127410000008040E55941CDCCCCCC02C22741333333B340E55941CDCCCCCC3BC22741333333D349E55941333333331FC227419A9999D963E559419A999999F6C527410000000028E5594133333333AAC527419A9999D91EE559419A99999991C62741000000A001E5594100000000E3C6274133333313F8E4594100000000CBC72741CDCCCC6CD9E459419A9999997CC92741666666C6AFE459419A9999994BCA2741333333338EE45941000000000ECB2741CDCCCCCC74E4594166666666E7CC2741000000603CE45941666666660ACD2741CDCCCC6C38E459419A99999988CD2741333333F326E45941CDCCCCCC2ECE27416666666613E4594166666666A8CE274133333353FBE35941CDCCCCCCD1CE274100000000F2E359416666666611CF27419A9999B9E6E35941CDCCCCCC80CF27419A9999B9CDE35941CDCCCCCCCCCF27419A999979BEE359419A9999993ED02741CDCCCCCCACE35941CDCCCCCC5CD027419A999939A9E3594133333333ADCF27413333339399E35941CDCCCCCC47D127410000008097E35941666666669FD12741000000A030E35941CDCCCCCC8FD127419A99993929E3594133333333F3D02741333333B311E359419A99999959D027419A9999190DE3594100000000DACF27416666668605E35941666666662ECF274133333353F6E2594100000000EFCE274133333333EFE25941000000007ECB2741000000E073E25941000000004BCA27419A9999997EE25941000000000FCB2741000000809BE25941000000002DC82741000000C0F9E25941000000002EC8274100000060FCE25941666666668AC827419A9999D90AE359419A999999E6C727419A9999591DE3594100000000A8C727413333333318E359413333333361C727416666668623E359419A9999997DC727419A9999F926E359410000000021C727419A9999D932E359410000000031C727413333339336E35941333333334DC62741666666264EE359419A99999961C627419A99999950E359419A99999941C62741666666A655E359419A9999995AC627419A99999958E359416666666638C62741000000605BE359410000000025C62741666666E661E35941CDCCCCCCBEC527416666664676E359419A999999D3C52741000000C077E359419A999999A3C4274166666606B2E3594166666666BCC427419A999999B3E359419A99999959C4274133333373BFE35941CDCCCCCC08C42741CDCCCCCCCBE3594166666666EEC3274133333313C9E359419A99999923C327419A999919E4E359419A99999900C3274133333373E0E3594133333333A0C2274166666646F5E3594166666666B2C2274100000040F7E359419A99999981C22741CDCCCC0C06E45941666666669FC22741333333F308E4594100000000CDC127413333339321E459419A999999BFC12741CDCCCC0C20E459419A99999992C12741CDCCCCCC27E45941CDCCCCCCA6C12741CDCCCCCC29E459413333333359C12741333333D331E459410000000018C12741000000A03FE459410000000099C02741CDCCCC2C4EE459416666666606C02741666666C65CE4594133333333CEBF2741CDCCCC4C55E4594166666666CDBC274100000000AAE459416666666605BD2741CDCCCCACB1E45941CDCCCCCCD3BC27419A9999F9B7E459419A99999995BC2741666666C6B1E459413333333379BC274166666646B5E459413333333379BC274166666646B5E45941	01010000206A080000D839B7DFE4C8274166666606EBE35941	100130000	Z	Assenay	1001300	10013	10	44	3
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	01010000206A0800001CC0D1951B142841CDCCCCDC66F75941	100140000	Z	Assencières	1001400	10014	10	44	7
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	01010000206A08000031584C61B9DA27413433335358FE5941	100150000	Z	Aubeterre	1001500	10015	10	44	12
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	01010000206A0800000393E5AFC18A284134333383A9045A41	100170000	Z	Aulnay	1001700	10017	10	44	10
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	01010000206A080000D0D5BF333A722741000000409DDB5941	100180000	Z	Auxon	1001800	10018	10	44	26
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	01010000206A0800004CA00799966728413433338302FC5941	100190000	Z	Val-d'Auzon	1001900	10019	10	44	28
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	01010000206A0800005EF5EE11859F26419A9999E9DCFE5941	100200000	Z	Avant-lès-Marcilly	1002000	10020	10	44	28
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	01060000206A08000001000000010300000001000000400100009A99999969132841CDCCCC2C86015A419A99999975132841333333F389015A41CDCCCCCCB213284166666606B5015A41CDCCCCCCEC1328419A999999D0015A41666666660E142841333333D3DB015A41000000005D14284166666626ED015A41CDCCCCCC8C142841CDCCCCACFA015A419A999999A6142841CDCCCC8C09025A4100000000DA1428413333339334025A410000000001152841CDCCCCEC47025A41CDCCCCCC17152841CDCCCC0C4C025A4166666666491628413333333371025A41666666662E1728419A9999198A025A41CDCCCCCCA7172841666666C697025A41CDCCCCCCE4172841000000208E025A41666666663F182841333333137B025A41CDCCCCCC75182841000000E072025A41CDCCCCCCDC182841000000A07C025A41CDCCCCCC60192841CDCCCC6C8B025A4100000000CC192841CDCCCC0C99025A4166666666801A284100000040AD025A4166666666371B2841CDCCCC4CBC025A4133333333AB1B2841666666E6C4025A4100000000341C2841000000A0CD025A419A999999D71D284133333333E5025A4133333333BC1E28419A999979F3025A41CDCCCCCC541F284100000060FE025A41000000001F202841666666C612035A413333333344212841333333B32D035A41CDCCCCCCDE212841CDCCCC8C3E035A41333333338F2228419A99991955035A41CDCCCCCCC7222841000000205F035A41CDCCCCCCE8222841666666E661035A4133333333262328419A9999995D035A4133333333672328410000004057035A419A999999EB232841CDCCCCCC71035A410000000085242841666666A68C035A41CDCCCCCCC12428410000002095035A4100000000AA2528419A999979AB035A419A99999951272841CDCCCC0CD5035A41666666667D28284166666666F1035A416666666645292841000000C003045A419A999999BE292841CDCCCC2C11045A4166666666312A2841333333531F045A41000000009C2A2841000000402E045A4166666666122B2841CDCCCC0C40045A41CDCCCCCCB52B2841CDCCCC4C5A045A41CDCCCCCCBE2C2841CDCCCC8C81045A4100000000D72C2841CDCCCC6C7C045A4133333333742D28419A99999966045A41CDCCCCCCBD2D2841333333135D045A41CDCCCCCC602E28419A9999B941045A4166666666A12E2841CDCCCC4C30045A4133333333E12E2841666666A623045A419A999999CE2E28413333337316045A4166666666C72E28419A9999B907045A4166666666D42E2841CDCCCCECF7035A4166666666E82E284166666686F1035A419A999999582F28419A9999F9DE035A4133333333CD2F284166666606D0035A41CDCCCCCC8830284100000020BB035A4133333333DA302841CDCCCCCCB0035A4133333333CC3128419A99999993035A4166666666D0312841CDCCCC2C8F035A41CDCCCCCCC63028413333337369035A41CDCCCCCC2E3028419A99995955035A41CDCCCCCC232F2841333333D32F035A41666666660B2E28410000000009035A4100000000112D284100000000E7025A41CDCCCCCC8B2B2841CDCCCC2CB1025A41CDCCCCCC222B2841333333F3A4025A419A9999997B2A2841000000608E025A41000000000C2A2841666666867E025A4100000000DB2928410000006075025A4100000000D1272841000000E05A025A4100000000D7272841000000204F025A413333333326272841666666A63F025A41CDCCCCCC14262841333333332D025A410000000013242841333333730B025A419A99999949232841CDCCCC2CF5015A4133333333FE212841CDCCCC8CDC015A4133333333E5202841000000A0CB015A419A999999BF1F284133333373B0015A4100000000791F2841666666C6A7015A41CDCCCCCC821F284166666646A5015A41000000006C222841666666C665015A4100000000DA222841333333335A015A410000000045232841666666A646015A41CDCCCCCCA72328413333339336015A419A99999933242841333333731D015A419A999999832428419A99995914015A41CDCCCCCCF12428419A9999D90A015A4100000000132528410000002009015A41333333334E2528419A99999901015A4100000000C3252841CDCCCC6CF5005A4100000000982628419A999939DB005A41000000002C2728419A999959CB005A41CDCCCCCCE4272841CDCCCC8CB8005A41000000000E2828419A999959BC005A419A999999422A2841666666A6E4005A4166666666262B2841000000A0F5005A41CDCCCCCCB32C2841CDCCCCAC11015A419A999999EB2D28419A9999192A015A419A9999994A2E2841000000E030015A41666666661F2F28419A9999F93B015A4166666666533028419A9999394D015A4133333333CE302841666666C654015A41333333338C3128419A9999795F015A4133333333A8322841666666666D015A4133333333B13328419A9999797F015A4166666666D83428410000000094015A41666666664C352841333333539D015A419A9999994536284100000060B0015A41333333335D37284133333333C7015A410000000028382841CDCCCCECD5015A41CDCCCCCCF838284100000000E3015A41CDCCCCCC213A2841CDCCCC8CF9015A4100000000113B2841CDCCCC4C15025A4133333333503C2841666666E62E025A4133333333F03D2841000000C051025A41333333332C3E28410000002057025A41CDCCCCCC863F28410000000074025A4166666666F24028419A9999B992025A41000000005D412841000000209C025A41CDCCCCCC0D4328419A999979C0025A4100000000D2432841666666A6D0025A41333333331E4428419A999979D7025A41333333334045284166666666EF025A4133333333A34728410000004024035A41CDCCCCCC94482841333333333A035A4100000000434928419A99993949035A41000000008D492841666666A64E035A4133333333454A28416666666659035A419A999999C94A2841CDCCCCAC5F035A41CDCCCCCCB44B2841CDCCCC0C6E035A41000000003A4C2841666666C676035A41CDCCCCCC784C28410000002067035A4166666666BA4C28416666668659035A4100000000204D2841CDCCCC0C48035A41CDCCCCCC3B4D2841CDCCCC6C49035A4166666666294E28419A9999B95F035A419A999999574E28419A9999D95E035A4166666666904E28410000008057035A41000000006C4F28416666664639035A4100000000A94F2841666666A62F035A419A99999953502841000000E016035A41CDCCCCCCEE50284100000040FE025A419A9999993351284100000080F5025A41333333339A51284100000080E6025A41666666668452284100000040C0025A41000000005651284166666606A5025A41CDCCCCCC2D512841CDCCCC8CA2025A419A9999997D50284100000000BE025A41333333331A4F2841333333B393025A4133333333794E28413333335375025A4100000000374F28419A9999F952025A419A999999E84F2841000000A037025A419A9999993E5028419A99991928025A419A999999F65028413333335304025A41666666667651284166666666F4015A419A9999994E52284133333313D6015A419A9999997F522841CDCCCC6CCD015A413333333351532841333333D3A2015A41000000009B5328419A9999D992015A413333333332542841CDCCCCEC73015A410000000069542841CDCCCC6C67015A419A999999E75428413333331348015A419A999999B9552841333333F314015A4100000000BF552841666666E612015A4100000000E4542841CDCCCCCC0A015A419A999999A15428410000008007015A41000000002B5428419A9999D9FF005A419A999999F852284166666686E8005A41CDCCCCCCB1522841000000C0E5005A4100000000F1532841666666C6D4005A41CDCCCCCC6754284133333333D3005A41666666667954284100000080D1005A41000000009954284133333333C6005A4133333333F654284133333333B6005A41000000001455284166666686AD005A41666666662A552841CDCCCC8CA3005A41CDCCCCCC29552841CDCCCCCC9A005A4100000000065528410000004094005A4133333333985428416666660694005A41CDCCCCCC43542841CDCCCC0C97005A41CDCCCCCCFE532841666666C69A005A4133333333E15328410000004095005A4100000000B35328416666664690005A4133333333695328419A9999198E005A419A999999FB522841666666868D005A41CDCCCCCCD05228413333331397005A419A9999991D5228419A9999F993005A419A999999AF512841666666C690005A41CDCCCCCC7C512841000000C096005A419A999999CA502841333333138E005A416666666650502841CDCCCCCC8B005A41CDCCCCCC11502841333333938D005A4133333333B14F28416666666693005A4100000000944F28413333331391005A419A999999134F28419A9999598F005A4100000000C04E2841000000C08C005A41CDCCCCCCA04E2841333333D37F005A4166666666B64E28419A99993976005A41CDCCCCCC8C4E28413333337370005A4166666666374E2841000000206A005A419A999999AE4D28419A99997969005A4166666666714D28419A99997967005A41333333334A4D28416666664661005A41666666664C4D28416666664659005A41CDCCCCCC384D28419A99993957005A41CDCCCCCCC34C2841CDCCCCCC51005A419A9999999C4C28413333335356005A41CDCCCCCC2A4C28416666662650005A4100000000924B2841666666E64A005A41000000002E4B28416666664649005A4100000000014B2841CDCCCCEC45005A4166666666F34A2841CDCCCC6C41005A4100000000F64A28410000008038005A41333333331F4B2841666666662B005A419A999999FD492841000000A01F005A41CDCCCCCCB7492841333333131C005A419A9999993B4928410000006011005A41CDCCCCCC0B492841CDCCCCCC12005A419A999999AF4828419A9999B91A005A41CDCCCCCC514828419A9999592A005A416666666618482841333333132E005A41CDCCCCCCD5472841666666A624005A41CDCCCCCC7C4728416666666610005A4100000000FF46284100000000F9FF59413333333392462841CDCCCCCCDEFF5941333333337246284133333313D9FF5941CDCCCCCC36462841333333F3D2FF5941CDCCCCCC274528419A999939F9FF594100000000904428419A9999590B005A419A9999995B442841CDCCCC4C0E005A419A99999963432841CDCCCC8C27005A41CDCCCCCC36432841666666062E005A4166666666474128419A9999D95E005A41CDCCCCCC813F2841333333F38F005A41CDCCCCCC923A284133333373DBFF5941CDCCCCCC543A2841666666A6D0FF59419A999999F83928419A999999B5FF5941CDCCCCCCE83828410000008062FF5941CDCCCCCCD63828413333337363FF59419A99999979382841666666465FFF59419A9999990A382841000000C05FFF5941666666664B372841CDCCCCCC64FF594166666666B83628419A99995966FF5941666666664C362841333333F369FF5941CDCCCCCCFE352841CDCCCC2C6EFF59410000000046352841CDCCCCAC7DFF594133333333043528410000002088FF594100000000B1342841000000409EFF59410000000058332841CDCCCC4C74FF594166666666483328419A99991972FF5941333333336F3228416666664683FF5941CDCCCCCCAA312841000000C08FFF5941000000004B3128416666660697FF5941333333334C302841CDCCCCACABFF59419A999999852F284100000060BCFF5941CDCCCCCC262F2841CDCCCC8CC3FF59419A999999992E284166666666B9FF5941666666664C2E284166666646B2FF5941000000007B2D2841666666C6A5FF59419A999999292D28419A999939A0FF5941666666662D2C2841333333938BFF594100000000D62B28419A9999D983FF594133333333FE2A2841666666266FFF594166666666632A28419A9999195FFF594100000000D42928419A9999594CFF5941000000001E292841CDCCCCEC36FF594133333333CC282841666666062AFF594133333333732828416666668616FF5941000000004C282841CDCCCC4C0CFF594100000000C827284133333333EDFE59410000000082272841CDCCCCCCEAFE59419A9999999B2628419A999919E7FE59413333333392262841CDCCCC4C19FF59410000000081262841666666261CFF594100000000FA2428419A99993914FF594166666666D22428413333333316FF594133333333C2242841CDCCCCCC26FF5941CDCCCCCC8D2428419A9999194AFF59419A999999662428419A99991959FF594100000000C72328416666662689FF59410000000083232841000000009CFF594100000000362328419A999979AFFF5941CDCCCCCCEB2228419A999979C5FF59419A999999CA1F284100000000ADFF59419A999999BA1F2841000000A0BBFF59419A9999999F1F2841CDCCCCECC6FF594100000000481F28419A999959DEFF59419A999999FD1E28419A9999D9EAFF5941CDCCCCCCA91E284100000080FBFF594166666666571E2841333333330F005A4133333333D41D2841333333732C005A4166666666AA1D28416666668633005A419A9999996F1D2841000000603A005A41CDCCCCCC131C2841333333735A005A41CDCCCCCCE11B2841000000C05F005A41CDCCCCCCBD1B2841CDCCCC0C66005A419A999999921B28410000002074005A4166666666E01A2841000000809C005A41333333339B1A284166666626AB005A419A9999997B1928419A9999D9DC005A41000000004B192841333333D3DE005A419A9999991718284166666606C3005A4100000000EA172841CDCCCC2CC2005A41CDCCCCCC0C17284166666606E5005A419A999999D616284133333393EB005A41333333337E16284133333333F8005A41CDCCCCCC25162841333333F300015A416666666693152841CDCCCCEC15015A41000000007B152841666666261E015A41CDCCCCCCA9152841000000C024015A4166666666A2152841333333D32A015A419A99999943152841333333F338015A4133333333D51328413333339373015A419A99999969132841CDCCCC2C86015A419A99999969132841CDCCCC2C86015A41	01010000206A08000088805FFBB1442841CCCCCCBCB2015A41	100210000	Z	Avant-lès-Ramerupt	1002100	10021	10	44	21
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	01010000206A0800007C41AF9BB95428410000002082D45941	100220000	Z	Avirey-Lingey	1002200	10022	10	44	18
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	01010000206A0800003B87429984D12641000000F0F8F95941	100230000	Z	Avon-la-Pèze	1002300	10023	10	44	13
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	01010000206A0800002AE084AA5FA02741333333535AD65941	100240000	Z	Avreuil	1002400	10024	10	44	10
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	01010000206A08000073764C85254B284166666646A3D05941	100250000	Z	Bagneux-la-Fosse	1002500	10025	10	44	23
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	01010000206A0800009A37B06DD61A29419A999959EF095A41	100260000	Z	Bailly-le-Franc	1002600	10026	10	44	6
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	01010000206A08000059F6A32D38A4284166666616640A5A41	100270000	Z	Balignicourt	1002700	10027	10	44	13
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	01010000206A0800000EE781C6D5182841666666A65FCF5941	100280000	Z	Balnot-la-Grange	1002800	10028	10	44	20
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	01010000206A080000343333C3F5702841666666F6D9D45941	100290000	Z	Balnot-sur-Laignes	1002900	10029	10	44	10
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	01010000206A0800001CA49870E4A927419A99997908F45941	100300000	Z	Barberey-Saint-Sulpice	1003000	10030	10	44	10
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	01010000206A080000EA41429E87A02641333333A30A0C5A41	100310000	Z	Barbuise	1003100	10031	10	44	19
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	01010000206A080000CC84A157CB4829410000008031E55941	100320000	Z	Baroville	1003200	10032	10	44	17
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	01010000206A080000484457AEA6332941CCCCCC5C55E95941	100330101	H	Centre-Ouest	1003301	10033	10	44	3
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	01010000206A080000E0E75387123429419A99995942EB5941	100330102	H	Nord-Ouest	1003301	10033	10	44	1
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	01010000206A080000B2D5D742354529419A9999195DEB5941	100330103	H	Est	1003301	10033	10	44	11
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	01010000206A080000316061D2D2812841666666E65ADD5941	100340000	Z	Bar-sur-Seine	1003400	10034	10	44	28
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	01010000206A080000DC3AC338C56A2941000000B0A1E65941	100350000	Z	Bayel	1003500	10035	10	44	23
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	01060000206A08000001000000010300000001000000F2000000666666663B54274133333333D5E45941333333338D5427419A999999F0E4594133333333E8542741000000C000E559419A9999999D5527416666660617E559419A999999C55527410000008019E5594166666666CF5527419A9999B915E559419A999999FB562741666666661AE5594100000000425727413333331323E5594166666666895727410000004038E55941CDCCCCCC20582741333333534DE55941CDCCCCCC8E582741333333B34FE55941CDCCCCCC8A592741000000804DE559419A999999CB5927413333339369E55941CDCCCCCCE5592741CDCCCC0C89E5594100000000DB592741CDCCCC8C94E559419A999999B85927419A9999D9A1E55941333333333D5927419A99997990E5594133333333D95827413333339390E559419A9999999D5827410000006094E55941333333332758274100000000A5E559419A9999992358274133333333B9E559416666666635582741CDCCCCACC4E559419A9999994E58274166666626CCE559413333333381582741333333B3D2E5594100000000A758274166666686D5E559419A999999855827419A999919EDE559419A999999E4572741000000A0EBE559419A999999C95727419A999959F7E5594100000000B7572741000000E004E65941333333330B5727410000008001E659419A999999F85627410000004014E6594100000000035727419A9999B91BE65941CDCCCCCC8F572741333333D321E65941CDCCCCCC90572741666666A624E659416666666613582741CDCCCC6C56E659419A99999917582741CDCCCC8C5BE6594166666666C15827413333337395E659419A999999D2582741CDCCCC4C97E6594100000000845927419A999959D4E65941CDCCCCCC8359274100000080D9E65941666666665C5927413333331301E75941666666664B5B2741000000E00DE759419A9999991B5B27413333337318E7594166666666FF5A2741CDCCCCAC22E75941CDCCCCCCED5A27410000004035E7594166666666DA5A27419A9999393CE75941000000007C5A2741CDCCCCEC54E75941CDCCCCCC495A2741666666C660E759419A999999ED5927413333333373E7594100000000A65927416666666683E759419A99999963592741333333538AE7594166666666FB582741666666268FE759419A99999962582741666666269AE7594100000000C258274100000040ACE759416666666659592741CDCCCC8CCDE75941CDCCCCCC635A27410000000007E8594133333333E25927419A9999D928E85941CDCCCCCCBB592741000000A040E859419A9999999E5927416666666649E8594100000000A95927416666662652E85941666666662D5A27419A99993976E8594133333333C0592741333333137FE8594166666666CA5927413333331384E8594166666666A95A2741CDCCCCCCB0E85941000000000D5B274133333313CDE85941CDCCCCCCCC5B2741000000E00FE9594166666666FC5B2741333333130EE95941666666662F5D2741CDCCCC0C0FE95941000000007E5F2741CDCCCC6C1DE9594100000000C86027413333331322E95941000000004A612741CDCCCCEC21E9594100000000116227419A99993915E959410000000014632741333333F30AE9594100000000E26327419A999939F2E8594166666666AD642741333333B3D2E859419A999999556527419A9999B9B1E8594166666666C765274100000060A0E85941CDCCCCCCFC6527419A9999598FE8594133333333846627419A99991966E8594166666666A96627419A9999D95CE85941CDCCCCCCCF662741CDCCCC0C3EE8594133333333E9662741CDCCCC8C35E8594166666666DE662741CDCCCC2C2FE8594133333333D1662741000000C01DE859419A999999B26627419A99991914E859413333333375662741CDCCCCEC08E859410000000018662741666666E6FCE75941333333330B6627419A999999DFE75941000000000066274100000020CEE759419A9999991C6627419A999919BAE75941333333337F662741000000C0A4E7594166666666276727419A9999198EE7594133333333806827416666660644E7594133333333C56827419A99993936E7594100000000EC682741CDCCCCAC24E7594100000000EB682741333333F316E75941333333338468274133333393ECE65941CDCCCCCC6D68274100000060C8E65941CDCCCCCC76682741000000A0BAE65941000000009E6827419A999959AFE65941CDCCCCCC28692741333333F39EE65941CDCCCCCC8C6927419A999919A0E6594133333333E66927416666660696E6594100000000406A2741CDCCCCEC95E65941CDCCCCCC716A27410000006093E65941CDCCCCCC236B27413333337376E6594133333333EA6B27410000000061E65941000000009D6C27413333339350E6594133333333E26C27410000004045E659419A9999997E6D27410000002013E6594100000000BA6D2741333333930BE65941000000003C6E2741CDCCCC6C0BE6594166666666C77027419A99993926E65941CDCCCCCC6A742741333333B345E6594100000000697427419A9999392AE659413333333314742741000000A014E6594133333333137427419A99995907E65941333333332B742741333333B3F7E55941666666667574274133333373E6E559419A99999903752741000000A0DCE55941333333333C75274166666666D7E559419A9999998B752741CDCCCCCCBCE5594100000000A375274100000020A6E5594133333333A77527419A99993989E5594133333333D7752741333333136DE5594166666666F4752741333333B356E5594133333333067627416666668640E5594133333333807627413333337315E5594166666666A4762741CDCCCC8CFFE459416666666644772741333333D3DDE4594133333333A77727419A999919CEE459410000000078782741333333D3AFE45941333333333D782741666666E6A8E459413333333313782741000000609FE4594100000000CE772741000000808AE4594133333333B5772741CDCCCCEC85E459416666666657772741666666467CE45941000000001B772741CDCCCCCC71E4594133333333A5762741666666E658E459419A9999991A762741CDCCCC2C33E4594133333333C4752741333333531FE4594100000000677527416666666608E459416666666629752741CDCCCC8CFAE3594166666666C0742741CDCCCC0CE9E359416666666619742741CDCCCCCCD2E3594133333333EE732741000000A0CEE359419A999999737327419A999939B4E359419A9999993C7327419A9999F9A3E359419A999999177327419A9999D99BE35941CDCCCCCCC8722741CDCCCC0C90E359419A999999C07227419A9999198CE3594166666666C8722741CDCCCCEC7EE359419A999999E6722741CDCCCC2C71E35941666666664C7327419A9999995BE359413333333385732741666666664DE35941CDCCCCCC9F732741000000C03FE3594166666666907327416666666634E3594100000000FA722741333333131AE35941CDCCCCCCE2722741CDCCCC0C14E3594100000000C9722741CDCCCCEC07E3594100000000CC722741666666A601E35941CDCCCCCCAF72274133333393F8E2594166666666777227419A999999E2E25941666666664272274166666626D8E259419A99999937722741CDCCCCCCD2E2594166666666FE71274166666666C4E2594166666666CE71274100000080B2E2594100000000077227419A999979B1E259419A9999996A7227419A999999ADE25941333333338F742741CDCCCC4C9FE25941CDCCCCCC10752741666666269AE25941CDCCCCCCB07527419A9999399BE25941333333331F7627419A999999A2E25941333333333D76274133333353A1E2594100000000D2762741666666C67EE25941CDCCCCCC187727410000002067E2594166666666E07627410000000066E2594133333333A47627416666668662E25941CDCCCCCC17762741333333D357E2594100000000BF7527416666666652E259413333333318752741333333334BE25941CDCCCCCCC3742741000000A049E259416666666670742741CDCCCC8C49E2594166666666F3732741666666064CE2594133333333AF732741CDCCCCCC4EE25941CDCCCCCC077327419A9999195AE2594133333333B67227419A9999795DE259413333333376722741666666C65EE2594166666666FD712741000000A05DE25941CDCCCCCC247127419A99991957E259416666666676702741CDCCCCAC55E259419A99999940702741CDCCCCCC53E2594133333333D26F2741333333D34CE2594100000000956F2741CDCCCC6C47E2594100000000CB6E2741666666A631E2594133333333686E27416666668644E25941333333332C6E27413333339344E2594166666666D16C2741CDCCCCAC70E2594133333333596C2741CDCCCCCC7DE25941CDCCCCCC056C27413333333388E25941CDCCCCCC8A6B2741CDCCCC8C93E25941666666663E6B2741CDCCCC6C9EE25941666666667C6A2741CDCCCC0CB5E25941666666660C6A274166666646BFE259419A999999D1692741333333D3C7E25941CDCCCCCCAB69274100000000D0E259419A99999972692741CDCCCCCCE2E2594166666666156927419A9999F9F6E2594100000000776827419A9999D911E3594100000000636827416666660613E359419A999999B3672741333333F32AE35941333333336C672741333333B339E359410000000069672741CDCCCCEC45E35941333333335C672741CDCCCC0C50E3594100000000A5662741333333534CE35941CDCCCCCC7C662741CDCCCCCC58E359419A999999556627419A9999395FE3594133333333DB652741CDCCCC2C6EE3594133333333B9652741333333B374E3594100000000F7642741000000E093E3594100000000346327413333333380E35941CDCCCCCC586327410000002065E3594166666666376327419A99991964E3594100000000556327410000002054E35941000000005A632741CDCCCC8C45E3594100000000F3622741000000E042E3594133333333FA612741CDCCCCAC3EE35941CDCCCCCC53612741666666E63AE359413333333389602741CDCCCCEC2FE3594133333333A45E2741CDCCCCEC23E3594166666666D55D27416666666618E359419A999999715D27419A99995919E359419A999999F55C2741CDCCCC4C28E35941CDCCCCCC545C27413333337341E3594166666666A85B2741CDCCCCEC65E3594166666666F25A2741000000C085E3594133333333D15A27416666666683E3594166666666F65827419A9999D9C9E359416666666609582741333333D3F5E359410000000076572741333333331AE45941666666663B54274133333333D5E45941666666663B54274133333333D5E45941	01010000206A0800001AF04A80E16627419A9999B9ABE55941	100370000	Z	Bercenay-en-Othe	1003700	10037	10	44	18
01060000206A080000010000000103000000010000007901000066666666BD97264166666686DFF2594166666666A898264100000040F2F259419A999999D99826419A999939F5F25941000000002F99264100000060FAF259419A999999CE9A2641666666E617F3594133333333C39A2641000000C022F3594166666666C99A2641CDCCCC0C23F35941CDCCCCCC039B2641000000C025F3594166666666469B2641333333B329F35941CDCCCCCCA49B2641666666862FF359419A999999C79B26419A99999931F35941CDCCCCCC269C26416666664637F3594133333333519C2641333333F339F35941CDCCCCCC929C2641333333D33EF3594166666666D09C26419A99993943F3594100000000AA9C2641000000A04CF3594166666666859D26410000002063F35941CDCCCCCC739D2641000000E06AF35941000000009F9E2641000000009BF35941000000000E9F2641666666E6ACF3594100000000759F264166666646BAF35941CDCCCCCC84A026419A999939DAF359410000000087A026419A999979DAF359419A9999996FA0264100000000E3F359419A99999906A12641333333D3F5F3594100000000F8A126416666660629F459416666666617A12641000000C03CF4594100000000B8A12641666666A655F45941CDCCCCCC49A12641666666C666F4594100000000DA9F2641CDCCCCCC7AF4594166666666469F2641333333D397F4594100000000FE9E26419A999979A8F45941333333338F9E26419A999939C0F4594133333333F39D264100000040E1F459419A999999C49D2641CDCCCC8CEFF4594166666666E99D26419A999979F6F4594166666666EB9D264133333313F7F4594100000000F39D26419A999939F8F45941000000000E9E264166666646FAF4594133333333829E2641666666A601F5594166666666B79E26416666662605F5594166666666E19E2641CDCCCCEC07F55941CDCCCCCC2F9F2641333333F30CF5594100000000839F2641333333F311F55941CDCCCCCCD49F2641000000C016F55941666666660DA02641CDCCCC8C1AF559419A9999994CA02641333333131FF55941CDCCCCCC8FA026410000008024F5594166666666D4A02641333333132AF559410000000014A126419A9999792FF559419A99999960A12641000000E035F5594100000000B8A126419A9999593DF5594133333333F2A126419A99995942F55941333333330FA22641CDCCCCAC44F559419A9999992FA22641333333B347F559416666666654A22641CDCCCC2C4BF559410000000090A226410000002051F5594133333333C8A22641CDCCCC4C56F559419A999999DDA226413333333358F5594133333333F9A22641CDCCCCCC5AF559413333333315A32641666666C65DF559413333333347A326419A99995962F559413333333383A32641CDCCCC8C67F559419A999999A6A32641000000A06AF55941CDCCCCCCB2A32641333333D36BF559419A999999C7A326419A9999996DF559413333333317A426413333337374F559410000000078A42641666666667DF5594100000000C9A426413333331385F55941666666660BA52641CDCCCCCC8BF55941CDCCCCCC2AA52641333333D38EF55941CDCCCCCC35A526413333331390F55941000000006FA52641666666E695F5594133333333B0A526419A9999D99CF5594100000000E9A52641CDCCCCECA2F5594133333333F7A5264166666606A4F559419A9999990AA62641CDCCCC4CA6F559413333333341A626419A999999ABF55941666666667FA6264166666666B1F55941CDCCCCCCC8A6264100000080B8F559419A999999FFA62641333333F3BDF55941000000003FA72641CDCCCC2CC4F559416666666656A726419A999999C6F55941CDCCCCCCC1A72641333333B3D1F559413333333300A8264166666606D8F55941CDCCCCCC47A8264133333373DFF559410000000093A82641CDCCCC0CE6F559419A999999DDA8264133333373ECF559410000000014A92641CDCCCCCCF0F55941666666664FA92641333333F3F4F5594133333333A1A9264166666666FAF559419A999999F5A926419A999999FFF55941CDCCCCCC51AA26410000004005F6594133333333A5AA2641333333930AF659419A999999FBAA26419A99993910F65941666666662FAB2641CDCCCC2C13F65941CDCCCCCC6DAB26413333339316F659419A999999AAAB2641666666A619F65941CDCCCCCCDCAB2641666666861CF65941333333330AAC2641666666E61FF659416666666639AC2641CDCCCCCC23F65941666666665BAC26410000004027F65941000000007FAC2641666666A62BF659419A999999BBAC2641CDCCCC4C33F6594133333333FCAC2641333333933BF65941333333333DAD26413333339344F659416666666681AD2641333333934DF659419A999999CBAD26410000002057F6594166666666F3AD2641333333935BF65941666666660FAE2641333333D35EF65941666666662DAE26419A99995963F659410000000046AE2641CDCCCCEC68F659410000000060AE2641000000C06FF659410000000064AE26413333333371F659419A9999996EAE26416666668671F65941000000007DAE2641000000A071F659413333333381AE2641333333F36CF659419A99999985AE26413333339366F65941CDCCCCCC8EAE2641CDCCCCCC60F65941CDCCCCCC99AE2641666666265AF65941CDCCCCCCA8AE2641CDCCCCCC52F659419A999999BAAE2641000000404AF65941CDCCCCCCEFAF26419A9999F951F6594100000000F0AF2641666666A651F6594100000000F4AF2641666666464DF65941CDCCCCCCF9AF26419A9999F948F659419A99999904B026419A9999D944F659416666666617B02641000000803FF65941CDCCCCCC2CB02641CDCCCCCC37F659419A99999942B026410000008030F65941000000005AB026419A99993928F659413333333365B026419A99993924F6594100000000BEB12641333333732FF659410000000006B22641333333F32FF659419A999999A3B22641000000A02DF65941000000002EB32641666666C62AF65941CDCCCCCC56B32641CDCCCCAC2BF6594100000000C0B326419A99993932F65941CDCCCCCC48B42641CDCCCC2C32F65941333333334EB426419A9999F92FF65941333333335BB42641CDCCCC8C2CF65941CDCCCCCC18B52641000000C02DF65941CDCCCCCCC5B52641333333532DF6594100000000EAB526416666664630F65941000000001DB626419A99997941F6594100000000BFB726416666660644F65941CDCCCCCCECB72641000000406EF6594133333333EDB72641666666066FF659419A999999F5B726419A99993971F659419A999999FBB726413333335371F659416666666604B826413333335371F659413333333312B826416666664671F65941CDCCCCCC1FB826410000004071F65941CDCCCCCC56B826413333339371F65941CDCCCCCC71B82641CDCCCCEC71F659413333333386B826419A99995972F65941CDCCCCCC9BB826410000002073F65941CDCCCCCCBAB82641666666C674F659419A99999905B92641CDCCCC8C78F659419A9999997FB926419A9999397FF6594100000000FBB92641CDCCCC4C86F659419A99999946BA2641333333938AF65941CDCCCCCC50BA2641000000608BF65941000000005ABA2641666666468CF659416666666662BA2641000000808DF65941CDCCCCCC76BA2641000000C082F659413333333392BA2641000000005CF6594166666666D7BA2641CDCCCCAC50F659416666666610BB26416666666627F659410000000068BB26413333331303F659419A9999997ABB2641333333D3EEF559413333333365BC264100000020A1F559416666666681BC26419A99991988F559419A999999EFBC26419A9999798AF55941CDCCCCCC17BD2641333333338EF559419A99999935BD2641666666E68CF5594133333333A8BD2641CDCCCC6C60F5594166666666ABBD26419A9999195FF5594133333333C7BD2641CDCCCC0C58F559416666666610BE26416666668644F559413333333349BE26413333335335F559419A99999957BE26416666666631F55941333333335DBE2641000000E02EF559410000000031C026419A9999F9BDF459410000000093C0264166666626A1F459419A999999B0C02641000000E09AF45941CDCCCCCCFEC02641CDCCCC4C7FF45941CDCCCCCC55C126410000000056F45941CDCCCCCC5EC12641000000C045F4594166666666ECC02641666666A636F45941CDCCCCCCEEC026416666660636F459410000000000C126410000006031F45941666666660EC12641666666462DF45941000000001EC12641CDCCCC2C29F459413333333323C126419A99991928F459410000000027C126419A99999926F459416666666626C126413333337323F459419A99999924C12641000000A022F45941CDCCCCCC1AC126416666660620F459416666666612C126419A9999991EF459419A999999F4C026410000008019F4594166666666CEC02641000000E011F459419A999999C9C02641CDCCCCCC10F4594100000000C6C02641333333330FF45941CDCCCCCCC5C02641333333330EF459419A999999C8C02641666666C60CF4594166666666D3C026419A9999990AF45941CDCCCCCCDBC026419A99993909F4594166666666F3C02641666666A604F459419A999999FAC026410000004003F459410000000005C126419A99993901F45941CDCCCCCC6BC1264100000000ECF3594100000000A4C1264133333393DCF3594166666666CAC12641666666E6D1F359419A999999BBC126419A999919C8F3594133333333B3C12641CDCCCCECC3F35941CDCCCCCCAFC1264133333313C1F3594166666666ACC126419A999999BEF359419A999999A9C12641333333F3BBF35941CDCCCCCCA8C12641CDCCCC2CB9F3594100000000A8C1264100000060B5F3594133333333A5C126419A999919B0F3594133333333A3C1264166666646ACF3594133333333A2C1264100000000A9F359419A9999999EC12641666666E6A2F359419A99999999C12641CDCCCC4C9DF359419A99999984C12641CDCCCCAC8DF359413333333331C12641CDCCCC2C7FF359413333333331C12641CDCCCCAC7CF35941CDCCCCCC54C22641000000207CF3594133333333ACC226416666664673F3594133333333F2C226413333333373F359413333333358C326419A99999975F359410000000010C426413333337339F359419A99999936C426416666662624F35941CDCCCCCC34C42641CDCCCC2C0BF35941333333332AC42641333333F3FFF25941333333333DC42641CDCCCC6CF3F25941CDCCCCCC78C4264100000020EDF25941CDCCCCCCD2C4264166666606EDF259410000000041C5264166666626F3F25941CDCCCCCCD2C52641CDCCCCCCB5F259419A99999947C626413333333386F25941CDCCCCCC8BC62641666666266DF25941333333336BC726419A9999390FF25941333333339CC72641CDCCCC2C00F259410000000032C826416666660600F2594166666666B3C8264166666626F7F1594133333333DBC826419A999959F3F15941000000002BC9264166666646F3F1594100000000F4C92641CDCCCC0C02F25941000000003ACA26419A99997904F259410000000062CA2641CDCCCC2C03F259410000000060CA2641CDCCCC4CDCF15941CDCCCCCC66CA2641CDCCCCCCD5F159419A9999996FCA2641000000C0CAF159413333333372CA264133333373C7F15941CDCCCCCC20C826419A999959B1F159419A999999AEC6264100000040AAF15941CDCCCCCCAAC52641666666C6ABF15941333333330BC52641CDCCCCACAFF15941CDCCCCCC9DC42641CDCCCC8CB8F15941666666663CC42641333333F3BBF15941CDCCCCCC3EC42641333333D3C1F15941CDCCCCCC22C42641333333F3C1F15941CDCCCCCCFDC3264166666606C2F1594133333333D7C3264133333333C2F1594100000000ADC326419A9999B9C2F159413333333376C32641000000C0C3F15941000000003CC326419A999939C5F15941CDCCCCCC10C32641CDCCCC6CC6F159419A999999EDC22641666666C6C7F1594100000000D0C226419A999959C9F1594133333333ADC2264166666686CBF159419A9999997BC2264166666686CFF159410000000037C2264133333373D5F159419A999999EAC1264100000020DCF1594166666666A4C1264133333313E3F15941666666665FC12641333333B3EAF159413333333332C1264133333313F0F159416666666614C12641666666E6F3F1594133333333FAC0264166666686F7F15941CDCCCCCCD9C0264133333373FCF1594133333333B9C026413333333301F259419A9999999AC026413333335305F25941CDCCCCCC85C02641000000C007F259419A9999996CC02641000000200AF25941CDCCCCCC59C02641333333930BF259419A9999994CC02641CDCCCC4C0CF25941CDCCCCCC3BC02641CDCCCCCC0CF25941000000002DC026419A9999F90CF25941CDCCCCCC1BC02641000000E00CF259419A999999FCBF2641CDCCCC2C0CF2594166666666A1BF26416666666609F25941CDCCCCCC49BF2641666666E606F2594166666666FABE26419A9999B904F2594100000000C4BE26410000008003F259419A9999998FBE2641666666A602F25941CDCCCCCC62BE26413333333302F259416666666606BE26410000008001F2594166666666A9BD2641000000C000F259419A99999981BD26410000002000F259419A99999975BD2641CDCCCC6C18F259419A9999996DBD26416666666623F25941CDCCCCCC0FBC26416666668635F2594100000000D8B82641000000606DF259419A999999B7B826413333331374F259419A99999993B826410000004078F259419A99999967B82641CDCCCC2C7DF259413333333317B82641333333537FF25941CDCCCCCCD4B72641CDCCCCCC80F259419A99999976B726419A99993985F259419A99999945B72641333333938BF259413333333310B726410000004092F2594133333333E1B626410000002097F2594100000000C3B62641333333339AF25941CDCCCCCC92B62641CDCCCC4C9FF259410000000057B62641666666C6A5F25941000000001BB62641333333F3ABF2594100000000B9B52641333333F3B6F2594100000000AAB52641CDCCCCACB8F25941000000007DB5264166666606BEF259419A9999996DB52641666666E6BFF259419A99999949B5264100000060C4F25941CDCCCCCC1BB5264100000080CAF259419A9999990FB52641CDCCCC4CCBF25941CDCCCCCCF2B42641666666C6CEF2594166666666BCB426419A9999D9D5F259413333333395B42641CDCCCC0CDBF25941333333336AB4264100000080E0F259413333333341B42641333333F3E4F259419A99999915B4264166666686E9F259419A9999996BB32641000000E0FBF259419A99999941B326416666666600F3594100000000D4B22641CDCCCC2C0CF359416666666669B22641CDCCCC8C17F359419A99999906B226410000002022F359419A999999BAB12641CDCCCC0C2AF359410000000072B12641000000E031F359419A99999919B12641000000C03BF3594166666666E3B026410000002042F35941CDCCCCCCDCB02641666666A642F3594133333333D0B026413333335343F35941333333334DB02641000000204DF35941CDCCCCCCC1AF2641333333735EF359410000000072AF2641CDCCCC8C57F3594133333333DEAE2641333333D34AF35941000000007DAE26416666664644F359410000000035AE2641666666A641F359419A99999996AD2641666666A637F35941CDCCCCCCEBAC2641000000402FF35941000000005CAC2641333333732CF3594133333333E8AB2641000000E028F3594166666666E9AA2641CDCCCC0C25F35941CDCCCCCCCEAA26419A9999B922F35941CDCCCCCCEAA92641000000201FF3594100000000CAA82641CDCCCC6C1FF359413333333334A826419A9999991FF35941CDCCCCCCD9A726419A99995920F3594133333333BAA526419A99991920F359416666666603A52641333333531FF35941CDCCCCCC8FA42641CDCCCCEC1BF359419A99999931A426416666662617F359410000000048A326416666662609F35941CDCCCCCC06A32641CDCCCCEC0FF3594133333333D8A226416666668613F3594133333333CEA226416666660613F35941CDCCCCCCCCA226419A9999F912F3594133333333929E2641CDCCCCACDEF25941CDCCCCCCA79D26419A999959D3F25941666666662D9D26419A999999CDF25941CDCCCCCC979C264166666686D0F25941CDCCCCCCD19B2641CDCCCCACD3F259419A999999749A2641CDCCCC4CDAF259419A99999995992641CDCCCCECDAF2594133333333D797264100000040DCF2594166666666BD97264166666686DFF25941	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	01010000206A080000686696295FB12641CDCCCC0C1CF45941	100380000	Z	Bercenay-le-Hayer	1003800	10038	10	44	15
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	01010000206A080000C232AA3AFF242941000000B062E55941	100390000	Z	Bergères	1003900	10039	10	44	6
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	01010000206A080000ED31E15413A22741CDCCCCBCFDCE5941	100400000	Z	Bernon	1004000	10040	10	44	18
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