SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep12;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep12 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep12','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep12','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep12','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep12"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A08000084BDC6F2289D24419A99997945445841	120010000	Z	Agen-d'Aveyron	1200100	12001	12	76	22
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	01060000206A08000001000000010300000001000000750100009A999999396E254133333333E231584133333333EC6E25419A9999D9ED315841333333333E6F2541CDCCCCACF6315841000000004D6F2541666666E600325841CDCCCCCCCE6F254133333313133258410000000076702541000000802932584100000000B5702541CDCCCC0C34325841CDCCCCCCF2702541000000803B3258419A99999984732541333333330B325841333333336C7525419A9999B9EC31584133333333FA75254133333313EF315841000000005E7625419A9999B9ED315841CDCCCCCCD57625419A999999ED315841666666662677254100000080F7315841333333338477254100000080FA3158419A9999992D78254166666666EB31584133333333B3782541666666A6E9315841666666661779254100000040E93158419A9999998D792541CDCCCCACE531584100000000177A25419A9999B9DD315841CDCCCCCC4F7A2541666666A6DB3158419A999999AC7A2541CDCCCC0CDB31584100000000EA7A2541333333B3DC315841666666668B7B25419A999999E331584133333333F87B2541CDCCCC2CE331584166666666C97C25419A999999D4315841CDCCCCCCE97C2541666666E6D331584100000000527D25419A999919D7315841CDCCCCCC8E7D2541000000C0D731584100000000447E254133333313DF3158419A999999747E2541CDCCCC4CE0315841666666667A7F2541CDCCCC6CE33158419A999999BC7F2541666666A6E6315841333333331A802541666666E6E7315841333333336A8025419A9999F9E4315841CDCCCCCCBC802541CDCCCCECE43158416666666602812541CDCCCC6CE1315841333333337A8125419A9999B9D9315841CDCCCCCCD7812541CDCCCCACD23158419A999999BF8225419A9999B9C73158410000000013832541666666A6C7315841333333334F83254166666686CB31584133333333E083254100000040D93158419A9999994984254100000040DE31584100000000D8842541000000E0E231584133333333A18525419A9999B9E6315841CDCCCCCCF58525419A9999D9EC315841333333335E86254166666666EC31584166666666BE86254133333373E831584133333333F38625419A9999F9E43158419A999999658725419A999919E331584166666666DF87254166666606DD3158419A9999996888254166666686D131584100000000E788254166666626CA315841666666663D892541000000E0C7315841CDCCCCCCBC89254133333333C831584166666666118A2541333333B3C931584133333333C38A2541333333B3CA31584133333333348B2541CDCCCCECCD3158419A999999EC8B254100000060D63158419A999999698C254133333373DA31584166666666058D2541CDCCCC2CDD3158419A999999338D254133333353E431584166666666468D25419A999959EB315841CDCCCCCC478D254166666606F531584166666666988D254166666666F531584133333333178E254133333393F131584100000000578E2541CDCCCCCCEB315841333333335C8E254100000020E9315841CDCCCCCC3A8E2541333333D3E231584100000000358E2541CDCCCC0CD93158419A999999458E254100000080D0315841CDCCCCCC4E8E254166666626C23158419A9999995E8E2541666666A6BB315841CDCCCCCC5D8E2541CDCCCCACB43158419A999999348E254166666606B031584166666666698E2541CDCCCC6C9C315841666666666C8E2541000000C093315841666666665C8E254133333353843158419A9999995E8E2541CDCCCCCC7B31584133333333798E2541CDCCCCEC6F3158419A999999BE8E2541000000E05F31584133333333E68E25419A99993955315841CDCCCCCC238F25419A9999794C31584166666666468F2541000000C043315841CDCCCCCC658F2541333333D338315841000000008A8F2541CDCCCCCC26315841CDCCCCCCF28F25419A9999D9013158410000000007902541666666C6F03058419A999999189025419A9999D9E930584166666666139025419A9999F9E3305841000000002190254166666646DB3058416666666643902541333333D3D23058419A99999945902541CDCCCCCCC8305841666666665790254166666686C4305841CDCCCCCC6B90254166666666B7305841CDCCCCCC81902541CDCCCC6CAE305841CDCCCCCCB4902541CDCCCC6CA53058419A999999089125416666662694305841000000006A9125419A9999B985305841CDCCCCCCE691254133333393793058410000000011922541CDCCCCAC713058416666666690922541333333736830584133333333A9922541CDCCCC4C653058419A999999C6922541CDCCCC0C5C3058419A999999D09225419A9999F9533058410000000095922541333333B350305841666666666D922541CDCCCC8C4A305841CDCCCCCC689225419A9999F94030584133333333A6922541000000002C30584100000000A1922541666666261C3058419A999999B79225413333331319305841CDCCCCCC0A9325416666664618305841CDCCCCCC28932541CDCCCCAC133058410000000036932541333333B302305841CDCCCCCC4B93254133333353FC2F584100000000B3932541333333D3E52F584100000000F0932541666666E6C92F5841CDCCCCCC0194254166666626C62F58413333333357942541CDCCCC8CBC2F58419A999999C0942541CDCCCCCCB72F584166666666EB94254166666606B42F5841CDCCCCCC2B952541CDCCCCACB22F58416666666657952541666666A6AF2F5841666666665096254166666626AD2F5841333333336F96254166666606A82F5841CDCCCCCCE896254133333353A72F58419A999999F9962541CDCCCC6CA32F5841CDCCCCCC0B9725419A999919992F584166666666269725419A999919932F5841CDCCCCCC47972541CDCCCC0C902F58419A999999AA972541666666668A2F58419A999999C89725419A999919872F5841CDCCCCCC72982541CDCCCCCC7B2F584133333333A6982541CDCCCC6C772F58413333333302992541CDCCCC0C732F5841CDCCCCCC5399254100000060732F58419A999999A099254133333373692F58419A999999299A2541CDCCCCAC5D2F58419A999999AC9A2541CDCCCC4C4C2F58419A999999CF9A254133333353452F58419A999999029B254166666606412F58419A9999994A9B254100000080462F584133333333899B254166666686482F584166666666989D254133333393552F584100000000DD9D254133333373582F58419A999999539E25419A9999995F2F58419A999999B49E254133333353642F584100000000D39E254133333333592F58419A9999998C9E254166666646542F58419A999999849E25419A9999F9452F584166666666C49D2541CDCCCCCC482F5841000000004A9D25419A999979492F58419A999999E69C2541000000A0472F584133333333599C25419A9999F93E2F584166666666E19B25419A9999F9342F58419A999999869B25419A999999282F584100000000579B25419A9999391F2F58419A999999339B254133333333152F5841666666661D9B25419A9999990B2F5841CDCCCCCC169B2541333333F3032F5841000000001E9B2541CDCCCC4CF42E584133333333489B2541CDCCCCCCDD2E5841000000008F9B2541CDCCCCECC72E5841CDCCCCCCE39B254166666606B32E584100000000139C25419A999979A02E5841CDCCCCCC219C2541333333F3872E5841333333331A9C2541000000C0792E58419A999999F09B2541CDCCCC4C602E584166666666EA9B254166666686572E5841CDCCCCCCEC9B2541333333B3282E5841CDCCCCCCDF9B254166666666002E584133333333E09B2541CDCCCC0CED2D58419A999999A19B254100000000E92D584166666666699B2541000000C0E02D58419A999999609B25419A999939D92D584100000000659B2541CDCCCC0CBC2D5841CDCCCCCC769B2541000000A0B42D584166666666AA9B2541333333B3AA2D584133333333D99B2541CDCCCC2CA62D58419A9999990D9C2541333333139B2D5841CDCCCCCC2E9C2541666666468D2D584166666666519C2541CDCCCC2C652D584100000000789C25419A999959562D584166666666789C254100000000492D5841666666665D9C2541CDCCCC0C412D5841CDCCCCCCF09B2541000000C02A2D58419A999999CB9B2541666666461C2D584100000000C39B2541000000A0112D5841CDCCCCCCCF9B2541CDCCCCEC062D5841CDCCCCCCC79B2541333333D3F32C584100000000AC9B2541666666C6E22C5841CDCCCCCCB09B2541CDCCCC2CD32C584100000000AC9B25419A9999D9BF2C5841CDCCCCCC8A9B25419A9999D9AE2C584100000000409B2541666666A6942C584100000000089B2541CDCCCC6C762C584133333333D09A254166666686772C5841000000006B97254166666666962C5841333333332C962541000000C0A02C5841CDCCCCCC3894254166666686A22C58419A999999B58E2541000000409B2C58419A9999998E8E254166666606A92C5841CDCCCCCC908E254100000040C82C5841333333337D8E2541666666C6CF2C584166666666398E2541CDCCCC0CEF2C5841000000001D8E2541333333D3062D58419A999999148E2541CDCCCC4C1D2D5841333333331F8E254166666606262D58419A999999208E2541000000403B2D5841CDCCCCCC0C8E2541666666063F2D58419A999999328E2541000000C05E2D584166666666598E254133333373642D58419A999999598E254166666626692D58419A999999878E2541666666266E2D584133333333908E25419A999959762D5841333333337B8E254166666606812D5841666666664E8E2541CDCCCC4C7E2D584133333333CA8D254100000080722D58419A999999908D2541CDCCCCEC702D58419A9999991C8D2541333333F36A2D584166666666EE8C25419A9999D96A2D58419A999999A58C254133333353662D584100000000808C2541000000E0662D5841CDCCCCCC0E8C254133333353622D584133333333C58B2541666666E6582D5841666666669F8B2541CDCCCC4C4D2D584166666666478B2541CDCCCCAC412D58419A999999308B25419A9999D93C2D5841000000006A8A2541333333933C2D584100000000ED892541CDCCCC2C3B2D584133333333C8892541CDCCCC0C392D5841666666668D89254166666666382D58413333333352892541666666C6422D5841666666662A892541CDCCCC4C602D58419A99999922892541666666466C2D5841000000001089254133333393782D584166666666F4882541CDCCCC4C9A2D584133333333F58825419A999999B92D5841CDCCCCCCC488254100000040BD2D584166666666A8882541CDCCCCECC22D5841333333339388254100000020CD2D58419A9999994088254100000080D32D58413333333332882541CDCCCC0CD92D584100000000428825419A9999F9E12D5841333333337F88254100000000F12D584100000000968825419A9999F9F82D58416666666699882541CDCCCC8C012E584100000000718825419A999959152E58413333333397882541333333F3312E584100000000968825419A9999793C2E5841CDCCCCCC9F882541333333B3432E5841666666669C88254133333313582E5841333333337D8825419A9999D9682E5841666666663E88254133333353772E58419A999999AC872541000000E08E2E58419A999999A387254133333333942E584133333333C9872541333333B3A92E5841CDCCCCCCF787254133333393B42E584133333333E387254133333393C62E5841666666661188254166666666CE2E5841666666661B8825419A999979D92E5841666666662C88254133333373DD2E5841333333332888254133333373E22E584133333333DD872541CDCCCCECF52E5841CDCCCCCC9F87254166666626FE2E584100000000398725419A9999B9F42E58416666666615872541CDCCCC4CF32E5841333333339986254166666646F32E5841CDCCCCCCE2852541333333B3F62E58419A99999982852541CDCCCC6CF62E5841CDCCCCCC4885254133333353F72E58410000000010852541000000A0FA2E5841CDCCCCCCB884254166666606FD2E5841CDCCCCCC5B842541333333F3FA2E5841666666661F84254133333313EF2E5841000000001084254100000000E72E584166666666FC83254166666686E52E584133333333A883254133333313E52E5841CDCCCCCC678225419A9999B9EC2E58410000000028822541CDCCCC6CED2E584100000000D9812541CDCCCC6CF32E5841CDCCCCCC928125419A999979F52E584166666666588125419A999939EE2E584133333333238125419A999999E92E5841CDCCCCCCE4802541333333F3E72E58419A999999998025419A999979EB2E58419A99999976802541666666A6F02E58419A9999992780254133333313F62E5841CDCCCCCCED7F254100000040F42E584133333333AF7F254133333373002F584100000000637F254166666606072F58419A999999067F25419A9999B9112F584166666666AF7E25419A9999D9172F5841CDCCCCCCFC7D2541000000C0282F584166666666987D254100000020342F58419A9999994D7D2541666666063F2F58419A999999C97C2541CDCCCC4C562F584166666666877C254100000040642F584133333333357C2541333333B3702F5841CDCCCCCC0B7C2541CDCCCC6C7D2F5841333333337F7A254100000080672F584100000000FD792541666666A6622F58413333333332792541000000C0622F584166666666FF7825419A999959612F584166666666E1782541CDCCCC4C4F2F584166666666B57825419A9999793C2F58419A9999998B78254166666686302F5841666666667778254133333393252F5841333333337D782541000000401D2F5841333333339378254133333313112F5841CDCCCCCCE677254100000040172F584133333333827725419A9999991E2F58419A99999936772541CDCCCC2C292F5841333333331E772541CDCCCCAC2F2F584133333333F6762541333333F3402F584100000000F4762541CDCCCC6C492F5841CDCCCCCCFE762541CDCCCCCC4D2F5841CDCCCCCCFF762541333333D3592F584133333333EC762541000000E0682F5841CDCCCCCC72762541CDCCCC0C8E2F58416666666619762541666666A6952F5841000000008A74254166666646B52F5841000000005874254133333353B52F58419A999999F3732541333333F3AD2F5841CDCCCCCC2A732541CDCCCCAC9C2F58419A9999994972254133333393842F58413333333320722541333333738D2F584100000000BC712541CDCCCCEC992F5841CDCCCCCC13712541666666A6B92F584100000000F1702541CDCCCC6CC92F5841000000001B712541333333F3D42F58419A9999998271254133333333EB2F584133333333F37125419A9999D90C3058419A999999477225419A99999920305841000000008E722541333333F32D30584100000000BA722541000000603F30584166666666AA722541666666264C305841666666666D7225419A9999195E30584166666666387225419A99999972305841666666662D722541000000607B3058419A9999992F72254166666626833058419A9999995E722541CDCCCC0C99305841CDCCCCCC57722541000000C0A7305841CDCCCCCC4A72254133333393AD3058413333333311722541CDCCCCACB6305841CDCCCCCCD371254166666626BD305841CDCCCCCCAD71254133333333C3305841666666669A712541CDCCCC8CCC3058419A99999976712541CDCCCC0CD8305841666666664F71254133333373E7305841666666661F712541000000C0F730584100000000257125410000006003315841CDCCCCCCA870254166666606083158419A999999E4702541333333531F315841CDCCCCCCD870254166666666223158416666666603712541666666462F31584100000000C2702541000000603431584133333333E97025419A9999195031584133333333B27025419A9999395F3158410000000079702541000000A06831584133333333487025419A999999783158419A999999FD6F25410000000085315841CDCCCCCCCC6F25419A99999995315841666666668A6F25419A999999A2315841CDCCCCCC336F2541333333D3AD3158419A999999046F25419A999999B531584100000000EC6E25419A9999F9BD31584166666666CB6E2541666666E6C33158419A999999866E25419A999939C931584166666666576E25419A9999F9D43158419A999999396E254133333333E23158419A999999396E254133333333E2315841	01010000206A080000AAEF306F868B2541333333F3582F5841	120020000	Z	Aguessac	1200200	12002	12	76	18
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	01010000206A080000D2277D923F5E2341CDCCCC4C14595841	120030000	Z	Les Albres	1200300	12003	12	76	15
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	01010000206A0800004A3755A80FB4234100000090905F5841	120040000	Z	Almont-les-Junies	1200400	12004	12	76	24
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	01010000206A0800006A38945669942441CDCCCC5C5D2D5841	120060000	Z	Alrance	1200600	12006	12	76	36
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	01010000206A080000733B5778DBC52241CDCCCC9C14545841	120070000	Z	Ambeyrac	1200700	12007	12	76	11
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	01060000206A080000010000000103000000010000007C01000033333333236A234133333313564D584100000000286A2341666666065F4D584100000000386A234100000020674D584166666666376A2341CDCCCC8C6F4D5841000000005D6A2341000000E06E4D58419A999999056D2341333333935E4D584166666666F96D2341333333F3584D5841000000007A6E23419A999959544D584100000000966E23419A9999D9594D5841666666664A6E2341666666266A4D584133333333996D2341333333B38B4D5841CDCCCCCC756D23419A999919954D58419A999999DC6D234166666626964D5841000000004F6E2341CDCCCCEC9A4D5841666666669E6E2341CDCCCC4CA54D584166666666FC6E2341CDCCCCECAC4D58419A999999086F2341000000E0B34D58419A999999016F23419A999959BB4D584100000000D36E2341666666E6CD4D584100000000AE6E2341CDCCCCACD74D58419A999999926E2341333333F3E64D584133333333946E234166666666ED4D58416666666622702341000000A0F44D584100000000AF7023419A9999B9FF4D584100000000CD70234133333373FE4D584166666666E0702341CDCCCCACF54D58419A999999E970234133333333E94D58410000000007712341CDCCCCACE14D58419A999999427123419A999959DB4D584166666666AB73234100000000B54D584133333333F97423419A9999D9A74D5841000000007A742341000000608B4D5841666666665D7423419A999959834D58419A99999934742341CDCCCC8C724D58413333333391752341CDCCCC4C624D5841333333337F752341666666A65D4D584166666666E1762341000000004A4D58413333333326772341CDCCCCEC3A4D58413333333358772341000000E03A4D584166666666BC772341666666C63F4D5841333333338C78234133333353454D58419A999999CF78234166666686554D584133333333F4782341666666C66B4D5841CDCCCCCC2979234166666626814D584133333333D77A2341666666E6754D58419A999999377D234166666606654D58419A999999B97D234100000060674D5841CDCCCCCC277E2341000000806D4D5841CDCCCCCC777E2341CDCCCCAC6E4D58419A999999D17E2341333333136C4D58419A9999993F7F23419A9999F96B4D5841CDCCCCCCCB7F2341CDCCCC0C724D584166666666088023419A9999397D4D5841CDCCCCCC31802341CDCCCC6C924D5841000000005A802341000000A0934D5841CDCCCCCCA9802341CDCCCC4C924D5841000000004B8123419A999999A84D58413333333387812341CDCCCC0CAB4D58419A9999991282234166666666A34D58419A9999999E82234166666626A04D58419A9999999B822341333333D3A34D5841333333337882234100000080AC4D58419A9999994B82234100000020B44D58419A9999996F8123419A999919D44D5841CDCCCCCC1A812341CDCCCCCCDF4D58419A999999F280234166666606E74D584166666666A0812341333333B3F84D584166666666FA8123419A9999D9F94D584133333333618223419A999979074E5841CDCCCCCCFC822341333333931A4E58419A999999C68223419A9999991C4E5841666666661382234166666606284E584100000000D6812341333333532E4E5841CDCCCCCCD6812341333333D33A4E584166666666E1812341CDCCCC8C434E5841CDCCCCCC01822341000000404C4E58419A999999CA82234166666686584E5841333333330084234133333333584E5841666666667884234133333333574E5841000000000685234133333313614E5841CDCCCCCC8F852341CDCCCCCC574E58419A999999C2862341000000402E4E58419A9999993987234166666666204E5841CDCCCCCCCE87234100000000154E58413333333346882341000000E00F4E5841CDCCCCCC17892341CDCCCCAC0A4E58416666666685892341CDCCCCCC064E584166666666B789234100000000084E584100000000628A2341CDCCCC4C144E584133333333B28A23419A9999F9174E584133333333F88A234166666626194E5841000000003E8B234133333393164E58419A999999D58B2341CDCCCCAC124E5841666666664D8C2341CDCCCC8C124E5841666666661F8D2341333333D3144E58419A9999990F8E2341333333D31A4E58419A999999508F2341333333732E4E5841CDCCCCCC828F234166666666334E584166666666DF8F2341CDCCCC8C334E58413333333322902341CDCCCCEC1A4E58419A999999E5902341CDCCCCACCF4D58419A999999C590234100000020CC4D5841CDCCCCCCA7902341333333F39F4D58413333333389902341666666C6804D5841CDCCCCCC82902341000000406F4D58416666666661902341000000A03F4D5841666666665890234100000080284D58419A9999995D902341CDCCCC4C144D58413333333366902341CDCCCC4C074D584100000000019123419A999979024D5841000000005F932341CDCCCC2CFB4C58416666666608942341000000C0F44C58419A999999BB942341333333D3EB4C5841CDCCCCCC9096234100000060C94C58413333333361972341CDCCCCECB34C584166666666E197234166666606A94C584133333333C997234166666666A24C584100000000B8972341CDCCCCCC924C584166666666BE972341CDCCCC6C894C5841CDCCCCCCB6972341333333F3774C5841CDCCCCCC71972341000000206F4C5841333333336A97234166666686674C58419A99999983972341666666265C4C5841CDCCCCCC80972341666666A6544C58419A99999960972341CDCCCC2C4E4C58416666666651972341333333F3414C58419A999999259723419A9999B93C4C584133333333B6962341000000C0354C5841CDCCCCCC8A962341666666E62E4C58416666666661962341CDCCCCCC2B4C58413333333305962341333333B32C4C584133333333CA952341000000002A4C58419A99999960952341CDCCCC4C204C58416666666639952341CDCCCC4C1F4C5841666666665E95234100000000134C584133333333A0952341666666E6044C5841000000001698234133333313C24B5841CDCCCCCC1397234100000040B04B5841CDCCCCCC9A96234166666666A14B584100000000FC952341CDCCCCCC964B5841CDCCCCCC3E962341CDCCCC4C844B5841000000004C962341000000E07D4B58413333333361962341000000E0624B58413333333391962341000000A0524B584133333333BC9623419A9999393A4B584133333333E5962341CDCCCC0C2F4B5841CDCCCCCC17972341000000E0254B5841333333336797234133333333154B58416666666698972341333333D3084B5841000000004C9723419A999919074B5841CDCCCCCCCF962341666666E6094B5841000000003F962341000000800B4B584100000000C7952341CDCCCC4C084B5841CDCCCCCCA295234100000000054B5841333333330C952341333333D3014B5841CDCCCCCCE994234166666626FF4A584100000000AF9423419A9999B9F64A5841CDCCCCCC7A94234133333373F44A5841000000004994234133333333EC4A5841CDCCCCCC29942341000000C0E04A5841000000003D942341333333B3D14A58419A9999995C942341CDCCCCACCA4A5841666666667294234100000080B94A5841000000006B942341CDCCCC0CB54A5841333333333D9423419A999999AC4A58419A999999309423419A999919A74A58416666666631942341333333939C4A58419A99999922942341666666C6964A584100000000D59323419A9999B98C4A584133333333C49323419A9999D9854A584100000000CC932341666666467B4A5841CDCCCCCCA393234100000040744A5841333333338C932341000000E06A4A58419A999999759323419A9999F9544A58410000000063932341666666A6474A58416666666662932341CDCCCCAC354A58413333333353932341000000E0314A58410000000008932341CDCCCC0C284A584100000000D6922341000000C01E4A5841CDCCCCCCB0922341CDCCCC4C124A5841000000007E922341000000E0064A5841666666666C922341666666E6FA4958416666666659922341CDCCCC0CF7495841CDCCCCCC5C92234166666686F14958419A99999947922341CDCCCCCCE7495841000000004F922341666666A6DB495841CDCCCCCC2492234133333353D349584133333333749223419A9999F9C949584166666666C2922341CDCCCC6CAE49584100000000FD922341000000E09C495841333333330B9523413333339371495841CDCCCCCC95942341000000404E4958419A999999749423419A9999D94649584133333333529323410000004018495841CDCCCCCCDF922341666666660B495841CDCCCCCCB29223419A9999D90749584166666666C0912341333333B3FB485841CDCCCCCC8091234166666626F94858419A9999998F902341CDCCCCCCF4485841000000004290234133333333F248584133333333498F2341000000A0E4485841000000000C8F2341333333B3E148584166666666628E2341CDCCCC0CDC48584100000000288D23419A9999D90C49584133333333D58C2341666666E616495841CDCCCCCC9A8C23419A9999792549584166666666778C2341666666C62949584166666666FF8B2341666666E633495841CDCCCCCCD88B2341333333D33D495841000000005D8A2341333333D32A495841CDCCCCCC7888234100000020014958413333333365882341333333D3EE485841CDCCCCCC9288234100000000DA4858419A999999F2882341666666E6B9485841CDCCCCCC1989234166666646AA4858416666666635892341CDCCCC2C97485841CDCCCCCC88882341666666E68548584133333333648823410000004083485841666666661F872341666666E672485841CDCCCCCC968623419A9999996D48584133333333C2852341666666266848584133333333C3842341CDCCCC6C634858416666666671842341333333D36348584100000000AE8323413333333367485841666666661C832341333333D36A485841CDCCCCCCC6812341000000C0784858419A999999158123419A9999B9804858416666666690802341CDCCCC0CA84858416666666626802341000000C0C5485841666666662680234100000080CF4858419A9999991980234100000060D9485841666666660F80234133333373EA4858419A999999C17F234100000000F6485841CDCCCCCC707F23419A99993904495841000000001F7F2341666666060D4958419A9999994F7E2341000000202549584166666666297E23410000004027495841CDCCCCCC0F7E2341666666062C49584166666666C57D23419A999959354958419A9999998D7D2341000000203A495841CDCCCCCC5C7D23413333339341495841CDCCCCCC097D2341CDCCCC8C4B495841000000007B7C23419A99997962495841000000005A7C2341CDCCCC6C69495841CDCCCCCC547C2341333333F37B4958419A9999992D7C2341000000E087495841CDCCCCCC267C23416666662691495841CDCCCCCC197C2341CDCCCC4C93495841000000001A7C2341CDCCCC4C9D4958419A999999FF7B234100000020AB495841CDCCCCCCFD7B23419A999939B44958419A999999077C2341000000A0BF4958419A999999147C23419A999999C149584133333333147C2341CDCCCC0CD149584166666666FA7B2341CDCCCC4CD94958419A999999BF7B2341CDCCCC8CE04958419A9999998B7B234100000080E9495841CDCCCCCC4F7B234166666606ED4958419A999999F07A23419A9999F9EE4958419A9999993B7A234100000040EF4958419A9999999A792341000000A0EC495841000000003E79234133333393F149584100000000DE782341000000E0014A584166666666AB7823419A9999790C4A584100000000A078234166666626154A58419A9999997E7823419A9999391C4A5841000000004A782341CDCCCCEC2D4A5841CDCCCCCC1878234100000000324A584133333333A6772341000000A03E4A58419A9999997C7723419A9999F9484A58419A999999597723419A9999D9544A58410000000033772341CDCCCC8C564A584166666666067723419A9999195E4A584133333333F0762341000000805F4A5841CDCCCCCCEF762341CDCCCC0C664A584133333333D2762341000000A0674A584166666666F97623419A999999724A58419A999999EC762341CDCCCC6C764A584100000000AF762341333333B37B4A584100000000A676234133333353844A58419A999999B4762341333333339A4A5841333333338A76234166666666A14A58413333333381762341666666E6A54A5841333333335876234100000060AD4A5841666666662A7623419A999919B94A58416666666623762341CDCCCC4CBF4A58419A99999900762341000000C0CA4A584133333333E67523419A9999F9CD4A584100000000D1752341000000C0DD4A5841000000006D752341000000A0EF4A584166666666E27423419A999999F24A584100000000B3742341CDCCCCCCF44A5841666666666574234166666646F34A584100000000217423419A999979F64A584100000000F273234100000000F04A5841CDCCCCCCC5732341666666C6F14A58419A999999A973234100000080EB4A58416666666694732341333333B3EA4A5841333333333A732341333333D3ED4A5841CDCCCCCCA2722341666666E6EB4A58419A9999995C72234166666686E44A5841666666662E7223419A9999B9E94A58419A999999FC712341333333B3E84A58413333333309722341CDCCCCCCDE4A5841CDCCCCCCDC7123419A9999D9DB4A58419A9999999D71234100000080E14A5841000000007371234166666646DB4A5841000000007E712341CDCCCC8CD34A584166666666F3702341666666C6E14A584166666666D0702341000000A0E94A584133333333C370234166666606F24A5841CDCCCCCCE7702341CDCCCCCCFA4A5841CDCCCCCCF470234166666646114B5841CDCCCCCCE2702341333333B3234B58419A99999980702341666666C6334B5841000000001A702341000000E0494B5841CDCCCCCC08702341666666A6494B58419A999999E56F234100000040374B5841666666669D6F234100000020164B5841CDCCCCCC5F6F2341000000A0134B58419A999999516F234166666686084B58419A9999994B6F234133333313FA4A584133333333616F2341CDCCCC0CDF4A5841333333330D6F234100000000DC4A5841000000009E6E234100000080D64A5841CDCCCCCC596E23419A9999F9D14A5841CDCCCCCCB96D23419A999919E84A5841CDCCCCCC866D23419A9999F9EF4A584133333333166E234133333333FC4A5841CDCCCCCCFA6D2341CDCCCC6C064B584133333333466E2341CDCCCC8C0A4B58419A999999056F2341CDCCCC0C1D4B584166666666856E23419A9999F9374B584133333333686E234133333393434B5841333333331E6F23419A999919474B584166666666036F23419A999939514B58419A9999999C6E2341666666E6714B584100000000926E2341CDCCCC6C724B584100000000696E234166666626824B5841666666665D6E2341666666068A4B584133333333746E234133333333984B58419A999999B76E2341CDCCCCEC984B5841000000009E6E234133333313B04B5841CDCCCCCC296E2341666666E6A74B5841CDCCCCCC456D234166666646A24B584133333333B16C2341000000C09C4B5841CDCCCCCC556C2341000000609F4B5841000000002F6C234100000040AB4B58419A999999926B2341CDCCCC4CBE4B5841CDCCCCCC816B23419A999919C14B5841333333339B6B2341CDCCCC4CF04B5841000000001C6C23419A9999591B4C5841666666664B6C234100000020254C584133333333596C2341CDCCCC0C314C5841CDCCCCCC536C2341666666C6394C58419A999999646C2341666666464A4C584166666666C16C234133333373524C58419A999999CE6C234166666646634C5841CDCCCCCCC16C23419A999919694C58419A999999B86C234133333393764C584100000000A46C23419A9999B97E4C584100000000786C234100000040834C5841666666662C6C2341000000A0874C584100000000FD6B2341333333B3864C584133333333C96B23419A9999D98C4C58419A999999C16B234133333313914C584133333333926B2341333333F39D4C5841CDCCCCCC7E6B23419A9999D9AB4C5841000000007D6B234166666606B54C5841CDCCCCCC3E6B234100000060C24C584100000000346B2341666666C6CC4C584100000000396B23419A9999D9D14C5841666666662C6B234100000000DB4C5841CDCCCCCC386B234166666626F74C58419A999999216B234100000060024D584166666666CB6A2341000000401B4D5841CDCCCCCCCB6A234100000040204D5841CDCCCCCC8B6A2341CDCCCC6C444D584133333333236A234133333313564D584133333333236A234133333313564D5841	01010000206A0800001B5E60D69782234133333373624B5841	120080000	Z	Anglars-Saint-Félix	1200800	12008	12	76	22
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	01010000206A080000CCCCCC8C863C25419A999919A6FF5741	120090000	Z	Arnac-sur-Dourdou	1200900	12009	12	76	17
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	01010000206A0800002681EA9627DC2441333333330F415841	120100000	Z	Arques	1201000	12010	12	76	11
01060000206A08000001000000010300000001000000BB0B00009A9999990360244133333353273258416666666605602441CDCCCC0C29325841333333330C602441666666462B325841CDCCCCCC0F602441666666E62C3258410000000015602441CDCCCC4C2C3258413333333320602441CDCCCC6C2C325841CDCCCCCC256024419A9999792C32584166666666316024419A9999D92C325841000000003D602441CDCCCC4C2D3258410000000045602441666666062E325841000000004A602441666666262F325841333333335260244166666626303258419A999999686024419A999999323258410000000070602441CDCCCCAC3432584100000000706024419A99995936325841666666666A60244166666626373258410000000062602441CDCCCCAC383258419A99999964602441000000803A3258410000000064602441000000403C32584133333333646024419A9999D93D3258410000000069602441000000A040325841666666666F602441000000004332584133333333796024419A9999B9473258419A99999980602441CDCCCCCC4A325841666666668F602441666666664C325841333333339E602441333333734D32584133333333A3602441333333D34D32584133333333A96024419A9999794E3258419A999999AE6024416666660650325841CDCCCCCCAA6024419A9999395232584133333333A9602441CDCCCC6C5332584133333333A8602441CDCCCC6C5432584133333333AA602441666666065632584133333333AF602441333333F35632584166666666D76024419A999959593258419A999999EE6024419A9999195A3258419A999999FF602441CDCCCC8C5A325841666666661B6124419A9999795B325841CDCCCCCC326124419A9999995C3258413333333334612441000000A05C325841CDCCCCCC4C612441CDCCCC6C5C325841000000005B612441666666265C325841CDCCCCCC6B6124419A9999D95B3258419A99999983612441CDCCCC8C5B325841CDCCCCCCA9612441CDCCCC0C5A32584166666666BF612441666666065932584100000000CE6124419A99993957325841CDCCCCCCD7612441333333535532584133333333E6612441CDCCCCAC523258419A999999F7612441000000404F3258419A99999902622441000000A04C32584133333333166224419A9999F9483258413333333326622441000000A0473258419A9999993B6224410000004047325841CDCCCCCC5C622441CDCCCCEC44325841CDCCCCCC6A622441CDCCCCEC433258410000000072622441000000C0433258410000000081622441CDCCCCEC433258419A999999976224419A9999194432584133333333A36224419A9999594432584100000000B0622441CDCCCC8C443258419A999999BF622441666666064532584166666666D5622441666666E6463258419A999999DE6224419A9999994732584100000000EF622441CDCCCC0C483258416666666610632441CDCCCCEC4832584133333333236324419A99997949325841666666662B632441666666264A32584166666666386324419A9999B94B325841666666663D632441333333134D3258419A99999941632441666666A64E3258419A99999945632441000000A051325841CDCCCCCC4D6324413333333354325841666666665563244166666606573258413333333354632441000000C059325841CDCCCCCC4F632441CDCCCC0C5B325841CDCCCCCC4A632441000000E05B3258419A99999949632441333333135D3258419A99999946632441333333F36532584100000000446324419A9999B96D3258419A99999947632441333333736F3258416666666657632441666666C6703258419A99999964632441333333F371325841333333336F632441CDCCCC4C7332584100000000756324419A99995974325841000000007A632441000000C075325841000000007E63244166666606783258413333333395632441CDCCCC4C7C325841CDCCCCCCA0632441666666A67D32584100000000B2632441333333F37E32584133333333C5632441000000208132584166666666DE6324419A9999398432584133333333ED63244133333393843258413333333301642441333333D3843258419A9999991B642441333333D3843258419A9999992D642441333333F38432584133333333546424410000008086325841000000007464244133333393873258419A99999998642441666666268832584100000000B1642441666666A6873258419A999999C8642441CDCCCC0C8632584100000000F2642441CDCCCC2C853258419A9999992C6524410000002084325841CDCCCCCC46652441CDCCCC2C843258419A999999546524419A99997985325841CDCCCCCC726524419A9999D9863258410000000097652441000000C08832584166666666A0652441CDCCCC4C893258419A999999A6652441333333D38932584166666666AE652441000000A08B32584166666666B5652441666666468D32584133333333B96524419A9999F98E3258419A999999B4652441666666669032584100000000AB652441333333739132584100000000A1652441CDCCCC2C923258419A99999998652441CDCCCC6C923258419A999999716524416666662694325841333333335F6524419A9999D9943258419A9999995A652441666666E69532584133333333546524419A99993997325841333333334D6524419A99993999325841000000004C652441666666C6993258419A999999176524419A999959A2325841000000000E652441000000C0A4325841000000000465244166666626A7325841CDCCCCCC0165244133333333A8325841000000000065244133333313AB32584166666666FC6424419A9999F9AD32584100000000FB64244166666686B0325841CDCCCCCCFD642441000000C0B33258419A99999901652441CDCCCCCCB8325841333333330A65244100000060BC325841CDCCCCCC15652441CDCCCC6CBF3258413333333321652441333333F3C1325841333333332B652441CDCCCC0CC33258416666666641652441666666A6C43258413333333363652441CDCCCCACC63258410000000085652441CDCCCCACC832584166666666B16524419A999999CA32584133333333D56524419A999999CC325841CDCCCCCCF9652441CDCCCC0CCF325841CDCCCCCC0D662441CDCCCCCCD03258419A9999991B662441CDCCCC2CD2325841CDCCCCCC22662441666666C6D33258419A999999236624419A9999B9D43258419A99999922662441333333F3D5325841333333331666244166666606D7325841666666660F6624419A9999D9D732584133333333086624419A999979D832584133333333E3652441CDCCCC6CDC32584166666666D465244166666606DE325841CDCCCCCCC365244100000000E032584133333333B3652441CDCCCC8CE03258419A999999A965244133333353E1325841CDCCCCCC9965244133333353E4325841CDCCCCCC8B65244133333393E6325841000000007765244100000000E9325841666666664B652441CDCCCC4CED3258419A99999920652441CDCCCC6CF232584166666666116524419A9999F9F332584166666666046524419A9999D9F43258419A999999F864244100000000F632584100000000ED642441CDCCCC4CF832584133333333E9642441CDCCCC0CFA3258419A999999E6642441666666C6FB32584166666666E76424419A999939FD3258419A999999E8642441666666C6FF3258419A999999EA6424419A9999D90133584100000000ED642441666666860333584100000000EF642441666666060433584100000000F96424419A99997904335841CDCCCCCC036524419A9999B904335841CDCCCCCC09652441333333D3043358410000000025652441CDCCCC4C04335841CDCCCCCC4A6524419A99991903335841CDCCCCCC5D65244100000000023358413333333369652441000000E001335841333333338F652441000000600133584166666666A16524413333335301335841CDCCCCCCAF65244100000040013358419A999999D86524419A999979003358419A99999902662441000000C0FF3258419A999999176624419A9999F9FF3258419A9999991F662441333333730033584133333333266624419A9999990133584166666666276624416666666603335841CDCCCCCC2766244166666686043358416666666628662441CDCCCCEC0533584133333333296624413333335308335841000000002A662441666666860A3358419A9999992D662441333333F30C335841CDCCCCCC2D662441000000A00E335841000000002C662441666666061033584133333333256624419A999959123358410000000022662441333333B313335841CDCCCCCC21662441666666061633584166666666206624410000002018335841666666661D662441333333F3193358410000000018662441CDCCCC2C1B335841666666660E662441CDCCCC0C1D335841CDCCCCCC03662441000000001E33584166666666EE652441CDCCCC4C2233584133333333CD6524416666660629335841CDCCCCCCC46524419A9999792A33584166666666C0652441CDCCCC0C2F3358419A999999BF652441000000C03433584100000000C06524419A9999393833584166666666C8652441666666263933584133333333CD652441666666863933584133333333E5652441CDCCCC4C3B3358416666666603662441666666463E33584133333333246624419A99995940335841CDCCCCCC33662441CDCCCCAC40335841666666663C66244100000000403358413333333348662441CDCCCC6C40335841666666665466244133333393413358419A9999995B66244166666606433358419A9999995E662441CDCCCC4C443358413333333357662441CDCCCC4C45335841CDCCCCCC4D662441000000E044335841666666663F6624419A9999994433584100000000356624413333339344335841CDCCCCCC256624419A99995945335841666666661A662441333333F34533584133333333186624419A9999994633584166666666186624410000002048335841000000001D662441333333F3483358419A99999925662441000000804A3358419A9999992B6624419A9999594B335841000000003A662441333333F34C3358413333333346662441CDCCCC4C4F33584100000000486624419A999939503358419A99999945662441666666E6503358410000000043662441CDCCCC6C513358413333333341662441CDCCCC8C5233584133333333446624416666666653335841CDCCCCCC496624419A9999F9543358410000000053662441CDCCCCCC553358419A999999616624419A999939563358410000000071662441000000C056335841000000009B662441333333F35733584166666666B9662441CDCCCCEC583358419A999999D7662441333333535A335841CDCCCCCCE6662441000000205B33584133333333FA6624419A9999F95C3358419A9999990E672441666666E65F3358419A9999993467244166666666623358410000000050672441333333336433584166666666656724410000000065335841CDCCCCCC816724419A99993968335841CDCCCCCC92672441000000806A33584166666666A36724410000008070335841CDCCCCCCB3672441000000607933584100000000B5672441666666467B33584100000000B26724419A9999D97B33584166666666AC672441333333737C3358419A999999B3672441333333537E33584100000000AC672441333333D3813358419A999999A8672441666666A682335841CDCCCCCCA9672441CDCCCC4C833358419A999999AB6724410000008083335841CDCCCCCCD1672441333333738533584100000000E8672441CDCCCC4C863358419A999999F26724413333335386335841000000000068244100000000863358419A9999991A6824419A999999833358419A99999930682441000000E081335841000000003E682441CDCCCCEC803358419A999999506824416666668680335841CDCCCCCC61682441666666E67E335841666666666E682441CDCCCCCC7D335841CDCCCCCC78682441CDCCCCCC7D335841000000008C6824419A9999F97C3358413333333394682441000000807C335841333333339E682441000000807E3358419A999999AB682441000000008133584133333333BF682441000000208433584166666666D0682441333333D3863358419A999999DF682441000000C0883358419A999999F1682441CDCCCC6C8A3358416666666607692441666666C68B335841000000002E6924419A9999D98D335841666666664F6924419A9999598F3358416666666676692441666666E690335841CDCCCCCC9D69244166666626923358419A999999B36924410000002093335841CDCCCCCCBA692441333333939333584133333333BF692441666666C69333584133333333C0692441CDCCCC2C94335841CDCCCCCCC16924419A9999799533584166666666C8692441CDCCCCCC973358419A999999D86924419A9999199B3358419A999999E3692441666666869D3358419A999999F169244166666646A0335841CDCCCCCC706B244100000000B33358419A9999996B6C24419A9999B9C133584100000000A96C24419A9999D9C933584100000000B96C2441333333F3CA33584100000000CC6C24419A9999F9CB33584133333333E66C244166666606CD335841CDCCCCCC076D2441CDCCCCECCD33584166666666206D244166666626CE33584166666666346D24419A999979CE335841CDCCCCCC3D6D2441CDCCCCECCE33584100000000516D244100000040D0335841CDCCCCCC616D244133333373D13358419A999999786D2441CDCCCCACD2335841000000009C6D24419A999919D433584133333333C56D2441000000E0D5335841CDCCCCCCCF6D244166666626D633584166666666C36D244133333313E333584133333333146E24419A999939EE3358419A9999991E6E2441333333B3F5335841333333330B6E24419A999939FD33584100000000E46D2441000000800834584166666666E46D2441000000800D34584166666666706E24419A9999D90F345841CDCCCCCC0F6F2441CDCCCCAC0A345841CDCCCCCC416F2441000000A00A345841333333337E6F2441333333D3103458419A999999A66F2441000000801934584133333333B16F24410000004022345841CDCCCCCC7F6F2441666666062B34584166666666806F2441666666C633345841CDCCCCCCE56F2441666666A6443458419A999999EB6F2441000000004434584100000000F96F24413333333343345841666666660A7024410000000042345841000000001270244133333353413458419A99999927702441CDCCCCCC3F34584100000000427024419A9999393D345841333333334E702441CDCCCCEC3B345841CDCCCCCC627024419A9999593A345841666666667E7024416666664638345841000000009E702441000000C03634584166666666C1702441000000403534584133333333D9702441CDCCCC8C3434584133333333F7702441333333B33334584166666666227124419A999999323458416666666635712441333333D33134584166666666487124419A99997930345841000000005E712441CDCCCCAC2E345841CDCCCCCC6F7124419A9999792D345841000000007C712441333333932C345841CDCCCCCC89712441333333D32B345841CDCCCCCC9A7124419A9999792B34584166666666B07124419A9999592B34584100000000C5712441333333532B34584100000000D2712441333333732B34584166666666E27124419A9999B92B3458410000000002722441000000202D3458410000000010722441000000C02D345841333333331D722441000000402E34584166666666267224419A9999592E345841333333332F722441333333332E3458419A99999932722441000000202E345841CDCCCCCC49722441000000202C345841CDCCCCCC537224419A9999D92A345841CDCCCCCC5B722441000000E0293458416666666665722441666666E62834584166666666797224410000008027345841CDCCCCCC897224419A999979263458416666666695722441666666462534584166666666A27224416666660624345841CDCCCCCCB0722441333333D322345841CDCCCCCCC07224419A9999592234584100000000CD72244166666646223458419A999999DA722441333333932234584133333333EA722441CDCCCC2C2334584133333333FF7224410000002024345841333333330C732441333333B324345841333333332873244133333333263458413333333334732441CDCCCC8C27345841333333333A73244100000080283458410000000043732441000000602A345841000000004A732441000000002D3458410000000050732441CDCCCC4C2E3458410000000056732441CDCCCCEC2E345841666666665E732441666666462F345841CDCCCCCC667324419A9999992F3458419A9999996D732441666666263034584133333333797324419A999939313458416666666680732441333333333234584100000000867324416666660634345841000000008B732441666666663534584166666666987324419A9999B93A3458419A999999AB732441333333933F3458419A999999BB732441666666664234584133333333C57324419A9999594334584166666666D87324419A9999B94434584166666666DC732441CDCCCCCC44345841CDCCCCCCEB7324419A9999794534584133333333F87324419A9999B9463458410000000000742441CDCCCC8C473458419A9999990C742441000000A0483458413333333315742441333333D3493458413333333319742441CDCCCC4C4B3458410000000019742441CDCCCCCC4D3458413333333316742441666666464F3458416666666611742441CDCCCCCC513458416666666612742441CDCCCC0C543458416666666626742441CDCCCCEC5634584166666666367424419A9999F95834584166666666487424419A9999195B345841666666665A742441333333535D3458413333333370742441666666E65F3458419A9999998C742441666666466334584133333333A0742441CDCCCC0C663458419A999999B5742441000000606834584166666666CE742441CDCCCC0C6B345841CDCCCCCCDC7424419A9999596C34584100000000E7742441000000606D34584133333333F6742441333333F36F34584100000000FF7424419A99991972345841000000000C752441666666C6753458419A9999991C7524410000002079345841333333332F752441CDCCCCEC7C34584166666666337524419A9999797D345841000000003E752441000000C07E3458416666666645752441000000207F345841666666664E752441333333737F34584166666666577524410000000080345841000000006F75244133333373813458413333333372752441666666A681345841CDCCCCCC7E752441CDCCCCEC823458419A999999907524413333335385345841666666669675244166666626863458419A9999999C7524413333331388345841CDCCCCCCA37524419A9999B98A34584166666666AC752441666666869034584100000000B7752441333333F395345841CDCCCCCCC4752441000000C09B34584100000000CF752441333333139F34584166666666D57524419A999999A134584100000000D8752441CDCCCCCCA334584166666666DE752441333333B3A5345841CDCCCCCCE47524419A9999F9A634584133333333F175244166666626A934584100000000FE752441666666E6AB345841CDCCCCCC05762441666666C6AD345841333333330F76244166666606AF34584133333333167624419A999999AF345841666666661B76244166666606B03458410000000024762441CDCCCC4CB034584100000000297624419A999959B03458419A9999992E76244133333353B0345841000000003376244100000000B0345841000000003876244133333373AF3458419A999999427624419A9999F9AD3458410000000047762441CDCCCC6CAD345841CDCCCCCC4E76244133333393AC345841CDCCCCCC5A7624419A9999B9AB34584166666666657624419A999939AB3458413333333377762441CDCCCCCCAA3458413333333384762441666666C6AA345841333333338F762441000000C0AA34584133333333A0762441333333D3AA3458419A999999AC762441333333F3AA34584166666666C07624419A9999F9AA345841CDCCCCCCCF76244133333333AB345841CDCCCCCCE47624419A9999B9AB34584100000000EF76244133333333AC34584166666666FF762441CDCCCC0CAD345841666666661377244133333353AE3458413333333319772441000000A0AE3458410000000027772441666666E6AF345841CDCCCCCC48772441333333F3B13458413333333358772441666666E6B23458410000000074772441CDCCCCACB4345841666666667F772441666666E6B53458419A9999998E7724419A999979B7345841CDCCCCCC9B772441CDCCCC2CB934584166666666A977244133333333BB3458419A999999BB7724419A999999BD34584100000000C8772441000000E0BF3458419A999999D577244100000080C23458419A999999D9772441CDCCCCECC33458419A999999DB7724419A9999F9C43458419A999999DA772441000000E0C734584166666666D777244100000000C934584100000000D477244100000020CA34584166666666D177244133333313CC34584166666666D17724419A999999CC34584166666666D4772441666666E6CD3458419A999999D9772441000000E0CE34584133333333DF77244133333373CF34584133333333F277244133333313D0345841000000000378244100000020D0345841CDCCCCCC2378244100000000D0345841CDCCCCCC32782441000000E0CF345841666666663D782441000000C0CF345841333333334978244166666666CF345841666666665E78244133333393CE3458419A99999964782441CDCCCC4CCE345841666666667F78244133333333CC345841333333338B78244100000040CB34584166666666947824419A9999F9C9345841666666669D782441CDCCCCCCC834584100000000A678244100000000C834584166666666AD78244100000040C734584100000000B6782441666666A6C63458419A999999C1782441666666E6C534584166666666CA7824419A9999B9C434584133333333CF782441333333D3C334584100000000D878244100000040C23458419A999999DF782441CDCCCC2CC034584133333333E5782441666666C6BE34584100000000EC78244166666686BD34584166666666F478244100000000BC345841CDCCCCCC0079244133333353BB345841CDCCCCCC0D792441CDCCCCECBA345841666666661B792441333333B3BA3458416666666627792441666666C6BA345841CDCCCCCC39792441666666C6BA345841333333335279244133333353BB345841333333335679244100000060BB345841333333336B7924419A999939BC3458419A99999976792441666666C6BC345841333333338379244133333373BD3458419A9999999B792441000000C0BF345841CDCCCCCCA179244133333333C134584166666666A97924419A999959C3345841CDCCCCCCAB79244100000060C43458419A999999AC792441CDCCCC0CC634584133333333B1792441000000C0C9345841CDCCCCCCB179244133333393CB34584166666666B2792441666666C6CC34584133333333B07924419A999979CD3458419A999999A67924419A999919CF34584100000000A27924419A9999F9D0345841CDCCCCCCA37924419A999979D234584133333333A77924419A9999F9D334584166666666A8792441333333F3D43458419A999999A77924419A9999F9D5345841CDCCCCCCA37924419A999939D73458419A9999999E79244133333393D83458419A9999999D792441333333D3D93458419A9999999D7924419A999979DA34584166666666A1792441CDCCCCACDB345841CDCCCCCCAA792441CDCCCCECDC34584166666666B27924419A999959DD34584133333333BA79244133333373DD34584100000000C979244133333353DD34584100000000D4792441666666E6DC345841CDCCCCCCDB792441CDCCCCACDC34584166666666F579244166666646DC3458419A999999087A2441666666E6DB34584166666666157A24419A999959DB345841333333332C7A2441000000A0DA345841CDCCCCCC3B7A2441CDCCCC4CDA345841CDCCCCCC3F7A2441CDCCCC4CDA345841CDCCCCCC4B7A2441666666E6D934584100000000527A24419A999939D934584133333333547A2441666666E6D834584100000000577A244166666686D83458419A9999995A7A24419A999979D83458419A999999607A2441CDCCCC8CD834584166666666687A2441666666E6D8345841666666666D7A244100000040D9345841CDCCCCCC717A2441333333D3D934584166666666727A244166666666DA34584100000000737A244166666646DB345841CDCCCCCC737A24419A9999B9DC345841CDCCCCCC737A24419A999939DE34584166666666747A244133333353E034584166666666767A2441666666C6E134584166666666777A2441CDCCCCCCE23458419A9999997B7A244133333353E4345841CDCCCCCC857A24419A999939E5345841CDCCCCCC8F7A244166666646E6345841CDCCCCCC917A2441CDCCCC6CE734584133333333937A24419A9999B9E934584133333333947A244166666666EA34584133333333987A24419A999959EC3458419A999999A67A2441CDCCCC0CEF34584166666666AB7A244166666666F034584133333333B27A24419A999939F134584100000000BB7A2441666666E6F13458419A999999D67A2441333333B3F234584166666666DD7A2441CDCCCCCCF234584166666666E97A24419A9999B9F234584100000000F57A2441CDCCCCACF23458419A999999FF7A2441CDCCCCACF23458419A999999187B24419A999979F33458419A999999227B2441CDCCCC0CF434584133333333327B244100000060F534584133333333387B24419A999999F6345841CDCCCCCC3E7B244100000060F834584100000000427B244166666666F934584100000000477B2441000000A0FA3458419A9999994B7B2441CDCCCC0CFC34584100000000577B244166666606FE345841666666665D7B244100000080FF34584133333333617B2441333333730135584100000000647B2441000000600435584133333333607B2441333333D3063558419A9999995C7B2441CDCCCCEC07355841CDCCCCCC577B24419A9999590B35584133333333587B2441000000A00E3558419A9999995A7B24416666666610355841CDCCCCCC5F7B2441666666061135584100000000687B24419A9999391135584133333333787B24419A9999F910355841CDCCCCCC807B2441666666E610355841000000008D7B2441666666E6103558419A999999A27B2441333333331135584133333333B07B24410000008011355841CDCCCCCCC17B24419A9999B9113558419A999999D67B24419A9999B91135584133333333F27B2441333333931135584166666666167C24410000006011355841333333332F7C24413333331311355841333333333D7C24419A9999191135584166666666417C24416666662611355841666666664C7C24410000008011355841CDCCCCCC537C2441CDCCCC2C1235584133333333577C2441333333B31335584133333333567C24419A9999591435584166666666547C2441333333F31535584166666666527C2441666666C6163558419A9999994B7C2441666666A61835584166666666427C24419A9999B91A355841CDCCCCCC3C7C2441CDCCCC4C1C355841666666662F7C2441333333531E35584100000000287C2441333333131F355841333333331B7C2441333333B31F355841666666660B7C2441333333D31F35584166666666037C2441333333F31F3558419A999999FC7B24413333337320355841CDCCCCCCF67B2441000000A02135584100000000F67B2441CDCCCCEC223558419A999999F57B2441666666862435584133333333F77B2441666666C62535584100000000FE7B24413333333327355841CDCCCCCC027C2441CDCCCC0C2835584100000000067C2441333333F3283558419A999999037C2441666666A62935584100000000027C2441666666262A35584133333333037C24419A9999B92A35584166666666087C2441CDCCCC2C2B35584166666666127C2441000000E02B355841000000001B7C24419A9999F92B35584133333333267C24419A9999F92B355841CDCCCCCC377C2441000000C02B355841CDCCCCCC407C24419A9999792B35584133333333497C2441CDCCCC0C2B355841000000005F7C2441CDCCCC4C293558419A9999996A7C2441666666A628355841000000007F7C2441CDCCCCAC2735584166666666897C24416666666627355841CDCCCCCC957C2441000000802735584133333333A37C24419A9999792735584133333333AF7C2441CDCCCC2C273558419A999999C07C2441333333D3263558419A999999C87C244133333353273558419A999999CE7C24419A9999B92735584166666666D47C2441CDCCCC4C2835584133333333DB7C2441333333532835584133333333E17C2441CDCCCC2C2835584166666666E77C2441CDCCCC0C283558419A999999EC7C24419A9999F927355841CDCCCCCCFA7C2441CDCCCC8C2835584166666666FE7C2441000000E02835584100000000047D24419A99999929355841333333330B7D24419A9999192A35584166666666177D2441000000A02A3558419A999999227D2441666666662B355841CDCCCCCC267D2441CDCCCC0C2C355841000000002A7D2441333333D32C355841666666662E7D24419A9999792F3558419A999999317D2441CDCCCC2C30355841CDCCCCCC367D24419A9999993035584100000000487D244133333333323558419A999999527D2441CDCCCC0C333558419A999999637D2441CDCCCCAC34355841666666666A7D2441000000803535584133333333717D2441333333133635584133333333847D2441CDCCCC8C3635584166666666AC7D2441CDCCCCCC3635584133333333BF7D2441CDCCCCCC3635584133333333CB7D24419A99999936355841CDCCCCCCD77D244133333313363558419A999999DF7D24419A9999993535584166666666E77D2441666666E63435584100000000EE7D2441666666663435584133333333F77D2441333333933335584133333333FD7D2441666666863335584133333333027E2441333333733335584100000000077E24416666664633355841333333330A7E2441CDCCCC2C32355841000000000C7E244166666686313558419A9999990D7E2441333333D3303558419A999999107E2441CDCCCC2C30355841CDCCCCCC167E24419A9999792F355841CDCCCCCC1D7E2441CDCCCC0C2F355841CDCCCCCC237E2441333333D32E355841000000002B7E2441CDCCCCCC2E35584166666666367E2441333333332F35584133333333427E24413333331330355841CDCCCCCC467E24419A999979303558419A999999507E2441CDCCCC0C3235584166666666527E244133333373323558419A999999557E24410000002033355841666666665F7E244133333333353558419A999999667E2441333333B336355841666666666D7E2441000000603835584166666666757E2441000000A03A355841000000007F7E2441000000803E3558419A999999837E2441CDCCCC6C41355841CDCCCCCC847E2441CDCCCC4C4535584133333333857E2441CDCCCCAC4835584133333333857E2441000000A04B355841CDCCCCCC837E2441CDCCCC6C4E355841CDCCCCCC807E244166666626503558419A9999997D7E24413333335351355841333333337D7E24419A999959553558419A999999817E2441000000405935584100000000877E24419A9999995B355841000000008C7E2441000000805C35584100000000937E2441CDCCCCAC5D355841666666669C7E2441333333D35E35584100000000A97E24419A9999795F355841CDCCCCCCB57E244100000060603558419A999999C17E2441666666266135584100000000D47E244166666626623558419A999999D77E2441CDCCCC6C6235584133333333F57E2441CDCCCC4C633558419A999999087F244100000080633558419A9999991B7F244133333373633558419A999999357F2441333333136435584100000000487F24416666666664355841CDCCCCCC5D7F2441CDCCCC0C653558419A999999687F2441CDCCCCAC6535584133333333727F24419A99999966355841333333337B7F2441000000A067355841333333337F7F24419A9999596835584100000000807F2441000000406935584133333333807F2441333333336A355841666666667A7F2441000000A06C35584166666666767F24419A9999F96D355841CDCCCCCC737F2441666666E66E3558419A999999727F2441000000C06F355841666666667B7F244100000040723558419A9999997F7F2441666666E67235584133333333837F2441666666A673355841CDCCCCCC867F2441333333F374355841333333338A7F2441000000E076355841666666668F7F24419A9999D979355841CDCCCCCC947F24419A9999397B355841CDCCCCCC9F7F2441333333337D355841CDCCCCCCA77F2441666666267E3558419A999999AD7F2441666666067F35584100000000B47F2441CDCCCCEC7F35584133333333C67F2441333333538235584166666666C47F24419A9999398335584133333333C07F2441CDCCCC2C8435584166666666B57F2441333333B385355841CDCCCCCCAB7F24416666662687355841CDCCCCCCA27F24419A9999B988355841CDCCCCCC9C7F2441666666868A35584166666666997F2441333333D38C355841CDCCCCCC997F2441000000E08E355841CDCCCCCC957F24419A9999599135584166666666957F2441333333739335584133333333927F244133333373953558419A9999998C7F2441666666E69735584133333333887F2441666666069935584166666666847F2441333333739A35584100000000847F2441000000A09B3558419A999999867F24419A9999399E3558419A999999887F2441666666A69F3558419A999999897F244100000000A135584100000000847F244100000080A2355841CDCCCCCC7E7F2441CDCCCC2CA33558419A999999747F244166666666A43558419A9999996A7F2441CDCCCC6CA535584133333333607F244133333353A63558419A9999994C7F2441000000A0A735584133333333447F244100000060A8355841CDCCCCCC3C7F244100000040A93558419A999999327F2441CDCCCCECAA355841666666662A7F244100000060AC355841000000001F7F24419A999939AE35584133333333187F2441000000E0AE3558419A999999107F2441CDCCCC6CAF3558419A999999FF7E24419A9999F9B03558419A999999F97E2441666666E6B135584166666666F27E244133333313B335584133333333EA7E244100000000B6355841CDCCCCCCE67E2441000000E0B7355841CDCCCCCCE57E244133333393BA35584166666666E87E24419A9999F9BC3558419A999999E97E244166666626BE35584100000000EA7E2441333333B3BF3558419A999999E67E244133333393C035584133333333E27E244133333353C13558419A999999D97E244133333333C235584166666666CC7E2441333333F3C235584133333333C57E244166666606C33558419A999999BC7E244166666626C335584133333333B27E24419A9999B9C3355841CDCCCCCCAE7E244166666646C4355841CDCCCCCCAD7E2441000000E0C4355841CDCCCCCCAC7E244100000060C535584166666666A97E2441333333B3C5355841CDCCCCCCA27E244100000000C63558419A9999999E7E244100000040C6355841CDCCCCCC987E2441333333F3C635584100000000927E2441CDCCCC8CC8355841000000008F7E244100000040C93558419A999999897E2441CDCCCC6CCA3558419A999999847E24419A999959CB3558419A9999997F7E244166666606CC3558419A999999707E24419A9999F9CC355841666666666A7E244166666686CD3558419A999999627E244100000080CE355841CDCCCCCC5A7E24419A999979CF3558419A9999994C7E2441000000E0D1355841CDCCCCCC447E244100000060D33558419A999999437E244100000000D43558419A999999467E24419A999999D4355841000000004D7E24419A999939D53558419A9999995B7E2441CDCCCC0CD735584100000000657E2441CDCCCCACD8355841666666666C7E2441CDCCCC6CDA355841CDCCCCCC6D7E2441666666A6DB355841000000006B7E24419A9999D9DC35584133333333657E244166666606DE355841666666665C7E244166666606DF35584133333333547E2441CDCCCCECDF355841CDCCCCCC537E2441000000A0E135584133333333527E2441000000A0E3355841CDCCCCCC4E7E2441000000E0E5355841333333334D7E244133333333E8355841000000004D7E2441333333F3EA355841CDCCCCCC4D7E244133333373EE3558419A9999994A7E244133333373F235584100000000487E2441CDCCCCCCF435584166666666457E24419A999999F7355841000000003F7E2441CDCCCCECFA3558419A9999993D7E2441666666C6FD355841CDCCCCCC3E7E2441CDCCCCCC0036584100000000427E2441CDCCCC2C033658419A999999477E2441CDCCCC4C05365841000000004F7E244100000060073658419A999999587E2441333333330A365841333333335E7E24419A9999990B3658419A999999617E2441666666E60C36584133333333657E2441CDCCCC0C0F365841CDCCCCCC6A7E2441CDCCCCAC1136584166666666717E24410000004014365841CDCCCCCC797E2441333333331636584166666666857E2441333333D31736584100000000927E2441333333F3183658419A9999999A7E24416666668619365841CDCCCCCCA47E2441CDCCCC0C1A365841CDCCCCCCB57E2441CDCCCC0C1B36584166666666BE7E2441CDCCCCEC1B36584133333333C77E2441666666261D36584133333333877F24419A9999F91A365841333333334F802441666666461D3658419A999999D78224419A9999D90E365841666666663B832441000000C00E36584133333333A18324419A9999F90C365841CDCCCCCCAD832441333333730B36584166666666B6832441666666660A36584166666666BB832441CDCCCC8C093658419A999999C1832441CDCCCC0C083658419A999999C98324419A9999F90536584166666666D48324410000006002365841CDCCCCCC9D832441CDCCCC2CF83558416666666675832441333333F3F1355841CDCCCCCC7E83244133333333E9355841CDCCCCCCB9832441CDCCCC2CDA35584166666666BC832441000000E0D1355841CDCCCCCCC48324419A9999D9D135584100000000D783244166666626D2355841CDCCCCCCE6832441CDCCCC2CD2355841CDCCCCCCF28324419A9999F9D1355841CDCCCCCC02842441CDCCCC2CD13558413333333313842441333333D3CF355841CDCCCCCC238424419A999959CE3558413333333336842441000000C0CC35584133333333458424419A9999F9CB355841000000004E842441CDCCCCCCCB355841666666666884244133333333CC355841CDCCCCCC738424419A999939CC355841000000007D84244100000040CC3558419A9999998884244166666626CC355841333333339F84244166666606CB35584133333333B284244133333353CA35584100000000CC84244133333373C9355841CDCCCCCCDC8424419A9999D9C835584166666666F284244166666626C8355841333333330385244133333353C7355841333333331785244166666666C6355841666666662A85244166666666C5355841666666663A852441333333B3C4355841333333334B852441333333F3C33558419A9999995D8524419A999939C33558413333333372852441CDCCCC0CC2355841CDCCCCCC80852441CDCCCC6CC1355841CDCCCCCC9E8524419A999999C035584166666666B5852441000000E0BF35584133333333C48524419A999999BF35584166666666D985244100000000BF35584133333333F0852441CDCCCC2CBE355841333333330F8624419A999979BD3558419A999999388624419A9999B9BC355841CDCCCCCC5986244100000060BC355841666666667C86244100000000BC3558419A99999990862441666666C6BB35584100000000B986244133333373BB35584100000000D586244166666646BB3558419A999999EA86244166666626BB35584166666666FF8624419A999919BB355841CDCCCCCC078724419A9999F9BA355841666666661B87244133333373BA3558419A999999318724419A999999B9355841CDCCCCCC3F872441666666C6B8355841CDCCCCCC538724419A999939B7355841666666667B872441000000C0B335584133333333B0872441666666A6AF35584100000000C687244100000000AE35584133333333DB8724419A999999AC355841CDCCCCCCEC872441000000A0AB355841CDCCCCCCFE87244166666626AB355841CDCCCCCC0A8824419A9999D9AA355841666666661288244100000000AB3558413333333317882441CDCCCC4CAB355841333333331D88244166666606AC3558419A99999922882441333333B3AC355841666666662B88244133333333AD355841CDCCCCCC328824419A9999D9AD355841000000003A8824419A999999AE355841CDCCCCCC3D882441666666E6AE355841000000004188244100000020AF3558416666666659882441CDCCCC8CB0355841666666666A88244166666606B1355841CDCCCCCC828824419A9999F9B1355841CDCCCCCC9088244133333393B2355841333333339D88244133333393B335584133333333B0882441000000C0B535584166666666BC882441000000C0B735584166666666C4882441000000E0B83558419A999999CF882441000000A0B935584133333333DF88244166666666BA35584100000000EF882441CDCCCC8CBB3558419A999999F788244133333353BC355841666666660A8924419A999999BD3558419A9999991E892441CDCCCC8CBE355841333333332D8924419A9999F9BE355841CDCCCCCC3C89244133333353BF355841666666664C892441CDCCCC6CBF355841666666665D892441666666A6BF355841666666666E89244166666646C0355841CDCCCCCC7C8924419A999939C1355841000000008D892441666666C6C235584133333333A189244100000020C5355841CDCCCCCCB389244133333393C735584166666666C589244100000020CA35584166666666D989244166666606CD35584100000000E5892441CDCCCCECCE355841CDCCCCCCEF892441666666E6D035584100000000F989244166666606D33558419A999999008A24419A999959D535584166666666048A24419A999939D73558419A999999078A244100000000D8355841000000000B8A244166666686D835584100000000118A244133333313D93558419A9999992D8A24419A999979DB35584100000000488A24419A999979DD35584133333333598A24419A9999B9DE355841CDCCCCCCAB8A24419A999999E33558419A999999D08A244166666686E5355841CDCCCCCCF08A244133333393E7355841666666660F8B2441666666A6E935584166666666198B24419A999979EA35584133333333218B244100000060EB35584133333333498B244166666606F23558419A999999538B24419A999999F33558419A9999995A8B244166666646F4355841333333335F8B2441000000A0F4355841CDCCCCCC648B24419A9999D9F4355841666666667A8B2441CDCCCC4CF5355841000000008E8B2441000000E0F5355841333333339C8B24419A999999F63558419A999999AB8B2441CDCCCCCCF7355841CDCCCCCCB28B2441CDCCCC8CF83558419A999999BB8B24419A9999D9F835584100000000C48B2441000000E0F83558419A999999EE8B24419A9999D9F835584100000000018C24419A9999D9F835584100000000098C244166666606F9355841000000003F8C24419A999979FA355841CDCCCCCC468C2441333333B3FA355841000000004C8C24419A9999B9FA35584133333333518C24419A999999FA35584133333333738C244100000040F8355841CDCCCCCC2D8D24419A999959E03558419A999999738D2441CDCCCC4CE0355841CDCCCCCCA58D24419A9999F9E3355841CDCCCCCCEC8D244166666626F43558419A999999158E244133333353FF3558419A999999A28E2441CDCCCCAC10365841CDCCCCCCFC8E2441333333931536584100000000499024419A9999F91D36584133333333499024413333337320365841000000002C902441CDCCCCAC24365841333333331D902441CDCCCC0C253658416666666601902441000000A02536584166666666E68F24419A9999192636584133333333CD8F24419A9999992636584166666666B58F2441CDCCCCEC263658419A999999A08F244100000040273658419A999999938F24419A999959273658419A9999998E8F2441CDCCCC2C2736584166666666868F2441CDCCCCAC26365841000000007C8F2441000000E02536584100000000738F24419A9999192536584166666666688F24410000006024365841CDCCCCCC618F2441666666262436584166666666558F244166666606243658419A9999993B8F2441000000402436584166666666168F24410000008024365841CDCCCCCCEF8E2441CDCCCCCC24365841CDCCCCCCCC8E24419A9999392536584133333333E38E244166666686273658419A999999ED8E24419A9999992836584100000000FA8E2441CDCCCCCC2936584133333333038F2441666666062B36584100000000108F2441333333B32C365841666666661D8F2441000000E02E3658419A9999992A8F24419A99999930365841CDCCCCCC3B8F24416666668632365841CDCCCCCC4C8F24410000006034365841333333335B8F24416666664636365841CDCCCCCC6C8F2441666666E638365841000000007D8F2441000000803B36584100000000878F2441333333F33C365841CDCCCCCC918F2441666666E63D36584100000000A18F2441CDCCCC0C3F3658419A999999B18F2441CDCCCC0C4036584166666666C08F24413333335341365841CDCCCCCCCC8F2441333333134336584166666666D58F2441CDCCCCCC44365841CDCCCCCCDE8F24419A9999D9463658419A999999E68F2441333333F348365841CDCCCCCCEE8F2441CDCCCC4C4B36584166666666F48F2441CDCCCCAC4C3658410000000074902441000000A049365841CDCCCCCCCD902441666666864936584166666666649124410000006053365841CDCCCCCCBE9124410000008059365841CDCCCCCC04922441CDCCCC2C5D365841CDCCCCCC37922441000000206C365841666666667E92244166666606753658419A999999EC922441666666267B365841CDCCCCCC32932441333333D37E3658419A999999AB932441333333338B36584133333333609424410000008097365841333333337E942441333333739736584100000000889424419A99993996365841333333338E942441CDCCCC4C923658416666666693942441666666868E365841CDCCCCCC96942441666666868A365841CDCCCCCC999424419A99995986365841666666669B9424419A999979823658419A9999999B942441CDCCCC2C7F365841CDCCCCCC99942441666666A67C3658413333333396942441333333F379365841CDCCCCCC8E942441000000007636584166666666C1942441CDCCCCAC7036584133333333119524419A9999196E365841000000007F9524419A9999796B365841333333331E9624413333335361365841666666668B9624419A9999B95936584166666666EE962441000000A04B36584100000000169724419A99999946365841CDCCCCCC8E9724419A99993936365841CDCCCCCCAC9724413333337337365841666666661B98244133333353413658419A9999995F982441333333D33F365841000000006B982441666666863E365841666666666E982441CDCCCCEC3D3658413333333376982441CDCCCC4C3C3658410000000084982441CDCCCC4C39365841333333338E98244100000060363658413333333399982441333333733336584133333333A2982441333333F33036584166666666AC9824419A9999792D36584166666666B7982441333333332936584100000000C29824419A99997925365841CDCCCCCCC8982441666666C62236584133333333CA9824416666662621365841CDCCCCCCC6982441000000C01E365841CDCCCCCCC3982441333333131D3658419A999999BF982441333333131B36584100000000BE982441333333B31936584100000000BE982441666666E61836584100000000BE982441CDCCCC2C1836584100000000C198244166666606173658419A999999D1982441666666A618365841CDCCCCCCDA982441CDCCCCAC193658419A999999E29824419A9999B91836584166666666ED98244166666646173658419A999999F49824419A9999F9153658419A999999F8982441000000001536584166666666FB982441333333F31336584133333333FE9824419A9999991136584100000000FF9824410000000010365841CDCCCCCC00992441CDCCCC8C0C365841CDCCCCCC0199244133333353093658413333333301992441333333130736584100000000FF982441CDCCCC8C0436584133333333FE982441666666460336584100000000FF9824419A9999390236584133333333029924413333333301365841CDCCCCCC0699244133333393003658419A9999990C99244133333313003658416666666616992441666666A6FF355841CDCCCCCC2899244100000020FF355841CDCCCCCC4E99244100000060FE35584166666666689924419A9999B9FD355841333333336C9924419A999999FD355841000000006E99244100000020FE3558419A999999729924419A9999B9FE355841CDCCCCCC7899244133333313FF3558419A999999CF992441CDCCCCEC0E36584166666666029A24419A9999991C36584100000000219A2441CDCCCC4C253658419A999999679A24419A9999F92D3658419A999999859A2441333333F32D36584166666666FC9A2441333333D31E3658419A999999AF9B2441666666261736584100000000EB9B24419A9999590E36584133333333E09B2441000000A0003658419A999999D59B2441666666E6F7355841666666662F9C2441CDCCCCCCF7355841000000003E9D2441000000C00236584100000000CA9D24419A9999190536584100000000C99D2441000000A0F8355841CDCCCCCCAA9D244166666666F235584166666666969D2441CDCCCCACEE3558419A9999996E9D24419A9999B9EE355841CDCCCCCCD89C244100000060F1355841CDCCCCCC749C24419A9999F9EE355841333333332E9C244133333353E635584166666666109C24419A999999E73558419A999999DE9B244166666626EA3558419A999999A29B2441333333F3E8355841CDCCCCCC529B2441CDCCCC4CEA355841CDCCCCCC0C9B244100000060EA355841CDCCCCCCF89A2441CDCCCC8CE4355841000000000E9B2441333333B3E1355841000000007C9B244166666606D535584133333333D89B244100000020C735584100000000DF9B244166666686C535584100000000E19B244166666666C435584100000000E19B2441CDCCCC8CC03558419A999999E29B24419A999919BE35584100000000D19B24419A999979B435584133333333759B24419A9999D99735584100000000569B24416666666686355841CDCCCCCCA79C2441CDCCCC4C693558419A999999019D24419A99993969355841CDCCCCCC479D2441666666E66C35584100000000489D2441000000606F355841666666668B9C24413333335382355841000000008C9C2441CDCCCC0C8B35584133333333E79C2441333333B39D35584133333333F19C2441CDCCCCEC9E35584133333333059D2441666666E69E35584166666666689D2441333333D39435584133333333639E2441333333938535584100000000139F2441333333738035584133333333089F24419A9999597B35584133333333F59E2441CDCCCC2C763558419A999999EE9E2441333333D36F3558419A999999F59E2441CDCCCCCC6A35584166666666099F244100000000663558419A9999992E9F2441666666665F3558419A999999509F2441333333535835584100000000629F2441333333B35535584100000000779F2441000000805235584100000000909F2441333333B34E3558419A999999A49F2441CDCCCC6C4B35584100000000A79F2441CDCCCC0C4B355841CDCCCCCCA89F2441CDCCCCAC4A35584100000000AA9F2441666666C64635584166666666C59F244166666606343558419A999999E29F2441000000002A35584100000000E19F24416666660612355841CDCCCCCCF49F2441666666460E355841666666661CA024419A9999790A355841333333338AA024419A99991909355841CDCCCCCCD6A024419A9999590735584133333333E9A02441CDCCCC8C0B3558410000000003A1244166666646103558419A9999991AA1244166666666143558419A99999917A12441333333731E355841CDCCCCCCF9A024419A9999F9203558416666666678A024419A9999D9293558416666666651A024410000006036355841CDCCCCCC3EA02441000000604A3558413333333349A024419A99999950355841333333337BA02441CDCCCC0C5335584133333333F3A02441CDCCCCEC52355841666666661BA12441000000A0563558419A99999980A12441000000C06B35584133333333B3A12441333333337335584100000000BFA124419A9999D974355841CDCCCCCCCFA124419A9999F972355841333333330EA22441CDCCCC4C6B355841CDCCCCCC2AA224419A99991968355841CDCCCCCC3DA22441CDCCCCCC663558410000000043A224419A99999966355841666666664EA224419A999999663558410000000060A224419A9999B9663558416666666670A224419A9999F966355841666666667DA224419A999979673558419A9999999AA22441CDCCCC2C6835584100000000BAA22441666666A66935584133333333CFA22441000000E06A35584133333333E1A22441333333736C35584166666666EFA22441333333936E3558419A999999FCA22441333333D370355841CDCCCCCC04A324410000000075355841000000000FA3244166666646773558416666666621A32441666666E678355841333333333AA32441666666467A3558416666666668A324419A9999797B3558410000000081A32441CDCCCCCC7B3558416666666694A32441666666A67B35584166666666B1A324419A9999D97A35584100000000D2A32441333333337935584166666666EDA324410000008077355841000000000EA42441CDCCCCAC753558413333333333A42441333333D372355841CDCCCCCC55A42441000000806F355841CDCCCCCC70A42441CDCCCC2C6C355841333333338AA42441333333B36835584100000000A5A424419A99999965355841CDCCCCCCD0A42441000000C06135584166666666F3A42441CDCCCCEC5E355841CDCCCCCC13A524419A9999395C3558419A9999992EA52441CDCCCCCC593558416666666644A524419A999999583558416666666671A52441CDCCCC4C56355841000000008CA52441666666E65335584133333333C5A52441333333134E3558419A999999DEA52441CDCCCC0C4A35584100000000F9A5244166666606463558410000000013A62441333333F3413558419A99999928A6244166666606403558416666666634A624419A9999B93F355841333333334DA624419A9999593F3558410000000070A62441000000C03E355841000000008AA62441666666863E3558419A999999B0A62441666666863E35584133333333D1A624419A9999993E35584166666666FBA62441666666C63E3558410000000022A72441CDCCCCAC403558419A9999992DA72441CDCCCC8C41355841666666663AA72441000000C041355841666666664BA72441666666A6413558410000000061A724419A99995940355841CDCCCCCC7AA724419A9999B93E3558413333333396A724419A9999593D35584166666666A6A72441000000A03C3558419A999999B0A72441333333933B35584133333333C6A724419A9999593935584166666666DBA72441CDCCCC0C3835584166666666ECA72441666666263735584166666666F4A724419A9999F9363558413333333305A8244100000080343558416666666624A82441333333532F355841CDCCCCCC3FA8244166666666283558416666666641A824419A999939283558416666666675A82441333333D3213558419A9999998AAA244166666646EB345841333333339BAA2441333333D3E93458419A999999E0AA244100000060DD345841CDCCCCCC07AB24419A999919D23458419A9999992EAB244133333313BF345841CDCCCCCC79AC24419A9999B9B93458419A999999DDAC244100000060B8345841CDCCCCCC23AD2441CDCCCC0CBC3458413333333360AD24419A999979C23458419A99999988AD2441CDCCCCECC934584166666666CFAD244133333313D53458419A9999990BAE2441666666C6D83458419A99999951AE2441333333F3D9345841666666666FAE2441CDCCCCACD8345841CDCCCCCCFAAE2441666666C6CF345841CDCCCCCC7BAF244166666626C33458419A99999973B02441CDCCCC2CA63458419A999999EAB02441CDCCCC4C993458419A99999939B12441000000808B3458419A999999B0B12441000000E07E34584166666666F6B12441CDCCCC8C7D3458419A99999964B22441CDCCCC6C823458410000000083B22441666666E689345841CDCCCCCC8DB22441000000E0933458419A99999998B224419A9999D9A1345841CDCCCCCCACB2244133333353A4345841CDCCCCCC24B3244133333373A534584133333333BAB32441CDCCCC4CA0345841666666665BB42441000000209634584133333333F0B4244100000000873458419A99999967B52441000000E07D34584133333333CBB52441666666067A345841333333331BB62441333333337A3458413333333393B62441333333937C3458419A9999998FB62441000000E0473458410000000099B62441000000E03D345841CDCCCCCC84B62441666666663B3458413333333309B52441CDCCCCCC3B3458410000000091B42441CDCCCC2C38345841CDCCCCCC5EB424419A999979343458419A9999992DB4244100000020303458416666666680B3244100000060FE33584166666666ABB32441333333F3EF335841CDCCCCCCB6B42441CDCCCC6CE533584133333333F4B5244100000000E333584133333333E5B62441333333D3E33358419A99999964B72441000000C0E333584166666666B4B7244166666666E2335841CDCCCCCC35B8244166666686D9335841CDCCCCCCACB82441CDCCCCACCB3358419A9999990FB92441333333D3BD33584133333333C2B92441333333338E33584166666666E9B92441CDCCCC6C80335841CDCCCCCC05BA2441666666266B3358419A999999FAB92441CDCCCC2C58335841CDCCCCCC80B924419A9999993B335841666666666CB92441000000A036335841333333336BB92441666666E6233358419A9999997EB92441000000201B3358419A999999CDB92441CDCCCC8C0E3358416666666644BA2441333333F3FC32584166666666E2BA2441CDCCCC8CE2325841666666661DBB2441000000C0D43258410000000031BB244100000080CE325841000000003ABB2441000000C0C0325841000000001EBC2441CDCCCC0CA53258419A999999E3BC24419A999999853258419A999999FCBC2441333333937C32584166666666F6BC24419A9999197432584100000000AFBC2441333333735C325841333333339ABC2441000000405232584166666666A3BC2441000000C0453258419A999999F1BC2441CDCCCC6C2B325841666666663FBD2441000000200C32584166666666B5BD2441CDCCCC8CF031584100000000BFBD244166666606E93158419A999999B2BD244133333353C7315841CDCCCCCC9DBD2441000000E0BA315841333333336BBD2441CDCCCC2CB2315841CDCCCCCCA1BC2441CDCCCC2C98315841CDCCCCCC83BC2441333333739931584133333333E5BB24419A999919AB31584166666666B3BB2441666666A6AD3158416666666613BB244133333353AB315841333333332DBA244133333313A4315841CDCCCCCCD2B92441CDCCCCAC9C315841CDCCCCCC59B92441333333938C315841000000001DB924416666662680315841666666660BB92441CDCCCC4C723158419A99999902B9244100000080713158419A999999D3B824419A9999F96E31584100000000CAB82441666666466E31584166666666C2B824419A9999796D315841CDCCCCCCB8B82441CDCCCC6C6C315841CDCCCCCCABB82441333333736B315841666666669FB82441CDCCCCAC6A3158419A9999998EB82441666666066A315841000000007FB82441CDCCCCCC693158419A9999996FB82441CDCCCCCC693158413333333361B824419A9999F9693158419A99999951B824419A9999F969315841CDCCCCCC45B824419A9999D969315841CDCCCCCC3AB8244166666686693158413333333331B82441CDCCCC0C693158413333333326B82441CDCCCC6C68315841CDCCCCCC1DB82441333333B3673158416666666614B824419A9999D966315841666666660CB8244166666686653158416666666605B82441666666A66331584133333333FCB724419A9999396031584133333333ECB72441000000605831584166666666D7B72441666666065231584100000000BEB72441000000604931584166666666B7B72441CDCCCC6C4431584133333333ABB72441CDCCCCAC42315841333333339CB724413333337340315841CDCCCCCC45B7244133333353363158419A99999917B72441CDCCCCEC3231584100000000C1B62441CDCCCCAC2F31584100000000BDB62441666666862F315841333333339BB62441CDCCCCAC2E315841666666667CB62441333333932E315841CDCCCCCC6AB624419A9999F92E315841333333334AB624416666662630315841000000002BB624419A9999F930315841CDCCCCCC17B6244100000020313158419A999999F2B52441666666C63031584100000000BBB52441333333932F315841333333339CB524419A9999F92E315841666666668DB52441000000C02E3158413333333387B524419A9999992E315841CDCCCCCC83B524419A9999592E3158410000000082B52441333333132E3158416666666680B52441666666462D3158419A9999997AB52441666666662C3158419A9999996EB524419A9999B92B3158419A99999959B524419A9999F92A3158419A99999918B52441666666062931584166666666D5B42441333333532631584133333333AAB424410000000024315841333333337EB424410000004021315841333333335BB42441333333531E315841CDCCCCCC24B424416666664619315841CDCCCCCC00B424419A9999791531584133333333F7B32441000000A0143158419A9999991EB42441000000604D3158416666666617B42441000000A0533158416666666614B42441333333735F3158419A99999913B42441CDCCCC8C613158416666666636B42441000000A0663158413333333343B42441333333B36B315841CDCCCCCC55B42441666666866C31584166666666B2B42441000000A07431584166666666D4B42441333333D3773158419A999999F2B42441333333937B315841CDCCCCCC39B5244166666606833158410000000059B52441CDCCCC8C85315841666666668FB52441666666468831584166666666C5B52441333333F3893158419A99999907B62441CDCCCC8C8D3158419A99999944B624419A999919923158416666666677B624419A9999D996315841CDCCCCCC9CB624419A9999D99B3158419A999999ABB62441000000409E315841CDCCCCCCAEB62441000000809F31584166666666AEB6244166666666A131584133333333D2B624419A9999B9AC31584133333333D7B62441333333F3B0315841666666660BB72441333333F3B231584100000000A6B724419A9999F9C3315841333333339CB724419A9999B9C73158419A9999991BB724419A999959D93158416666666605B62441333333130E325841CDCCCCCC5DB524419A9999B92E32584133333333FBB42441CDCCCC8C413258419A999999B5B424410000002049325841000000007AB42441CDCCCCAC4B325841CDCCCCCCF4B224419A99999953325841666666660FB22441333333935732584166666666EDB02441000000605532584100000000B7B02441CDCCCC8C543258419A999999B2B024419A9999B9533258419A999999AFB02441000000605232584133333333B0B024419A9999994F32584133333333BCB02441CDCCCCAC4332584100000000C2B02441CDCCCC0C403258419A999999D5B024416666666637325841CDCCCCCCE5B02441CDCCCCCC2F325841CDCCCCCCF3B02441666666C62A325841CDCCCCCC07B124419A999919263258419A99999931B12441333333F31D325841CDCCCCCCB3B12441666666060632584100000000C8B124419A9999B901325841CDCCCCCCD6B12441666666A6FE3158419A999999F2B12441CDCCCC4CF83158419A99999908B22441CDCCCC6CF2315841CDCCCCCC0BB2244100000040F13158410000000020B22441333333F3EA315841000000002FB22441666666A6E43158413333333339B2244100000080DF3158416666666643B2244133333333D9315841666666664CB2244166666666D4315841000000006CB2244133333353C23158419A99999979B2244166666626BC315841CDCCCCCC8DB224419A999959B531584166666666B8B22441CDCCCC6CA831584133333333CDB224419A999999A331584133333333E1B22441333333D39F3158413333333309B32441666666069A3158419A9999996EB32441000000608C31584166666666C3B32441333333B38231584100000000E2B32441333333B37E3158419A999999F0B32441CDCCCC6C7C315841CDCCCCCCF9B32441333333737A3158419A999999FCB32441000000E0793158419A99999902B42441CDCCCCCC77315841CDCCCCCC03B42441CDCCCC2C773158419A999999DFB32441CDCCCC0C763158419A99999935B324410000008072315841CDCCCCCCE1B124419A9999196F3158419A9999997EB12441333333737A315841CDCCCCCC25B12441666666C68A31584100000000A5B02441666666269B3158419A99999955B024419A999979A1315841000000001AB0244166666606A931584100000000E0AF244133333353C3315841CDCCCCCCB8AF24419A999919D0315841CDCCCCCC38AF2441333333F3EC3158416666666699AE2441333333D30E3258410000000072AE2441000000E018325841CDCCCCCC5EAE244100000020243258413333333341AE2441666666662A3258419A99999923AE2441CDCCCC2C2E3258419A99999904AE2441666666062B325841CDCCCCCC0DAE2441666666062A3258413333333317AE2441CDCCCC2C29325841000000001FAE24419A9999D927325841666666661EAE2441666666E6253258419A99999918AE2441666666A6243258419A99999916AE24419A9999F9223258419A9999991AAE2441666666E621325841000000001EAE24419A99995921325841333333331DAE2441000000C01F3258413333333312AE2441333333931E325841CDCCCCCCFAAD24419A9999F91D325841CDCCCCCCEDAD2441666666061D3258419A999999E1AD2441333333B31B3258419A999999C4AD24413333335317325841CDCCCCCCB9AD2441000000801432584133333333B0AD2441666666E61132584100000000ADAD244133333313103258419A999999A7AD24419A9999790C3258419A999999A7AD2441000000800932584166666666A8AD2441333333330832584100000000A7AD244166666606073258419A999999A4AD244100000000053258419A999999A2AD24419A9999B90132584166666666A2AD2441333333F3FF315841666666669DAD2441CDCCCCECFE3158416666666687AD244166666686FB3158419A99999978AD2441CDCCCC6CF93158416666666652AD244166666606F33158413333333346AD2441666666C6F0315841CDCCCCCC42AD2441CDCCCCECEF3158410000000041AD24419A9999B9EE315841333333333CAD2441CDCCCCACED315841CDCCCCCC3BAD244166666646ED315841333333333CAD244133333393EB315841666666662AAD244166666666E43158416666666618AD2441CDCCCC0CE1315841000000000FAD244133333313DD315841CDCCCCCC0FAD2441CDCCCCECD7315841CDCCCCCC10AD2441000000E0D33158419A9999990DAD244100000020D13158419A999999FBAC2441CDCCCCECCC31584133333333DEAC244100000060C931584133333333C6AC244166666606C831584100000000B0AC24419A999919C73158419A99999995AC2441333333F3C63158410000000072AC2441666666C6C7315841CDCCCCCC5DAC244166666606C93158419A99999958AC244133333373C9315841CDCCCCCC55AC2441CDCCCC2CCA3158416666666655AC2441666666A6CC3158419A99999952AC24419A999939CE315841000000004FAC244133333333CF315841333333333DAC244166666686D03158413333333337AC2441CDCCCCCCD03158413333333316AC24419A999979D03158419A999999FBAB24419A999999D03158419A999999BBAB244166666646D131584133333333A7AB244100000020D13158416666666692AB244166666686D0315841CDCCCCCC8CAB24419A999919D0315841CDCCCCCC84AB24419A9999D9CE315841333333336DAB2441666666C6CC3158416666666650AB2441000000E0C93158419A99999945AB2441CDCCCC2CC8315841000000003FAB2441666666A6C63158419A9999993AAB244100000020C5315841CDCCCCCC37AB24419A999979C23158413333333337AB244166666606BA3158413333333337AB244100000000B3315841CDCCCCCC3EAB2441333333B3A33158419A99999941AB24419A9999999B3158416666666649AB244166666666933158419A9999994DAB24419A9999F98A3158410000000052AB24419A99999972315841CDCCCCCC45AB2441333333F370315841000000000DAB2441333333F36C315841CDCCCCCCF3AA2441333333736B315841CDCCCCCCC4AA244166666686693158413333333393AA24419A999959683158419A99999971AA244133333333683158419A99999967AA24413333335368315841CDCCCCCC49AA244166666666693158413333333311AA2441CDCCCC2C6931584100000000FBA924419A9999B96831584133333333E4A92441CDCCCCAC6631584166666666D7A92441CDCCCCCC653158419A999999C9A92441666666066531584166666666A8A924419A9999F963315841333333334FA9244166666606623158419A99999940A924419A9999F961315841000000003AA924419A999959623158413333333337A924419A9999B9623158410000000022A9244100000040653158419A999999FEA8244133333353663158419A999999EFA82441CDCCCC2C663158419A999999E8A8244133333313663158419A999999D5A82441CDCCCC0C6431584133333333C9A82441666666A66231584166666666C2A82441CDCCCC2C6131584100000000BCA82441CDCCCCAC6031584166666666B6A82441CDCCCCAC6031584166666666B3A82441CDCCCC0C6131584133333333A8A82441666666A6613158419A9999999CA82441CDCCCCEC613158413333333398A82441666666E6613158416666666685A8244133333313623158416666666682A824416666664662315841666666667AA82441CDCCCC8C5F315841CDCCCCCC74A82441000000E05D315841000000006EA82441666666C65B315841000000006BA82441CDCCCC0C5A315841CDCCCCCC68A82441000000E0553158416666666663A824419A9999D9523158410000000065A8244166666606513158416666666666A82441000000A04E3158413333333364A82441333333934D315841CDCCCCCC5BA82441666666064C315841CDCCCCCC5CA82441000000204A3158416666666666A82441CDCCCC4C49315841CDCCCCCC6EA8244166666606483158413333333370A8244133333393453158419A9999996AA824419A999959443158410000000065A824419A9999D9433158413333333361A8244133333313433158416666666658A8244133333373413158410000000054A824416666666640315841666666664AA82441333333B33E3158413333333346A82441333333D33C3158416666666641A824419A9999F93B315841333333333BA82441CDCCCC4C3B315841CDCCCCCC30A82441333333933A315841666666662AA82441000000603A315841CDCCCCCC23A8244100000080383158410000000020A824416666668636315841333333331AA82441000000C0323158410000000017A82441CDCCCC8C2F3158413333333313A82441000000E02C3158410000000011A82441000000A02A3158419A99999910A82441666666062A315841CDCCCCCC0DA8244133333353283158419A9999990BA8244133333333253158416666666607A82441333333F3213158413333333300A82441666666261F31584133333333FAA72441000000A01C3158419A999999F8A72441000000401B31584100000000F1A72441666666261931584133333333EDA72441CDCCCC6C173158410000000040A724419A9999391E3158410000000021A72441333333931E3158416666666609A724419A9999391E3158410000000002A72441666666C61D3158419A999999EEA62441333333F31B31584100000000D6A62441666666E619315841CDCCCCCCC5A624419A9999191931584133333333ADA62441CDCCCC0C19315841666666668BA624419A9999B9183158419A9999997CA6244166666626183158419A9999995FA6244166666666163158413333333344A6244100000080143158419A99999929A624419A9999D911315841CDCCCCCCF3A524419A9999B90C3158419A999999B1A5244133333333073158419A99999968A524419A99997900315841666666663AA5244166666626FD305841CDCCCCCC02A5244100000080F83058419A999999D1A42441000000A0F230584100000000C6A42441666666A6F130584100000000BFA4244166666626F1305841CDCCCCCCBAA4244133333333F130584166666666B7A4244100000040F1305841333333330DA424419A9999F9D8305841333333338AA32441000000A0C7305841CDCCCCCC2FA3244100000080C1305841CDCCCCCC8FA22441666666E6BD3058419A999999D1A1244100000020B9305841333333336DA124419A9999B9B1305841CDCCCCCCB7A02441333333339A305841000000001BA02441000000808330584100000000F29F24413333335388305841CDCCCCCCC69F24419A9999F98C3058419A999999A19F2441CDCCCC2C91305841333333337B9F24419A9999B995305841666666665B9F2441CDCCCCEC9930584166666666409F2441333333339D305841CDCCCCCC319F24419A9999B99E305841666666661B9F2441CDCCCC0CA030584166666666049F24419A999959A130584100000000E49E2441666666C6A330584133333333B89E24419A999919A730584133333333939E244100000000AA305841CDCCCCCC7F9E2441666666C6AB30584100000000729E244100000040AD305841CDCCCCCC6B9E24419A9999F9AE30584100000000639E24419A999959B1305841CDCCCCCC549E244166666686B430584166666666479E2441333333B3B630584133333333319E24419A999939B9305841CDCCCCCC1C9E244166666646BB305841333333330B9E244133333393BC30584166666666F59D244166666686BD305841CDCCCCCCE49D2441000000A0BF30584100000000D99D2441CDCCCCECC030584133333333D39D244166666626C23058419A999999CA9D24419A999959C430584100000000C49D2441666666A6C53058419A999999BF9D24419A999999C630584133333333BD9D2441333333D3C63058419A999999B99D2441CDCCCCECC630584133333333B69D2441333333F3C63058419A999999B49D2441000000C0C6305841CDCCCCCCB09D244133333373C6305841CDCCCCCCAD9D24419A999959C6305841CDCCCCCCAA9D244100000040C630584100000000A79D244166666646C630584133333333A49D24419A999979C630584166666666A29D2441333333B3C6305841333333339F9D244166666666C8305841333333339F9D244100000060C9305841CDCCCCCC999D2441666666E6C93058419A999999969D244166666626CA305841CDCCCCCC819D244100000080CB305841333333337C9D2441CDCCCC6CCB3058419A999999779D244133333333CB305841CDCCCCCC749D2441000000E0CA305841333333336D9D244133333373CA305841333333336A9D244166666646CA305841666666665F9D2441CDCCCC4CCA30584100000000569D2441CDCCCCACCA3058419A999999539D244133333333CB30584133333333529D2441666666C6CB30584133333333529D244133333393CD30584166666666529D244166666666CF30584166666666519D24419A9999B9D030584133333333539D244166666666D13058419A999999569D244100000020D230584133333333579D24419A9999D9D23058419A999999539D24419A999999D3305841CDCCCCCC489D244166666626D4305841CDCCCCCC3B9D244100000060D4305841666666662D9D244100000060D4305841CDCCCCCC1D9D24419A999919D430584133333333189D2441333333B3D330584166666666149D2441CDCCCCACD3305841666666660E9D24419A9999B9D3305841CDCCCCCC089D24419A999919D4305841CDCCCCCC059D244100000060D43058419A999999F49C2441333333D3D530584100000000EB9C2441CDCCCC8CD630584100000000CD9C2441CDCCCCECD730584166666666BD9C2441666666C6D8305841CDCCCCCCB79C244166666686D930584166666666B39C244166666686DA305841CDCCCCCCAF9C244133333373DB30584166666666A99C244166666606DC3058419A999999A19C244133333373DC305841CDCCCCCC909C2441CDCCCC0CDD305841666666668B9C244100000000DD3058419A999999869C24419A9999F9DC3058419A9999997F9C244166666606DD30584133333333789C244100000020DD3058419A999999739C244100000040DD3058419A9999996B9C2441666666A6DD30584100000000689C24419A9999F9DD30584166666666629C24419A999979DE305841666666665C9C2441000000E0DE30584166666666499C244133333333E03058419A999999309C24419A9999F9E03058419A9999991A9C2441CDCCCCCCE13058419A9999990B9C2441CDCCCCACE23058419A999999079C24419A9999D9E230584166666666FE9B24419A9999F9E23058419A999999F39B2441000000E0E230584133333333EC9B24419A9999D9E230584100000000E79B24419A9999F9E23058419A999999E39B2441CDCCCC2CE3305841CDCCCCCCDC9B2441000000C0E33058419A999999D69B244133333313E4305841CDCCCCCCD09B24419A999939E430584100000000B89B2441333333F3E43058419A999999A49B244100000060E53058419A999999999B2441000000C0E530584100000000909B2441CDCCCC8CE6305841CDCCCCCC869B244133333353E7305841333333336F9B2441333333B3E830584133333333539B2441000000A0E9305841333333333E9B24419A9999D9E830584166666666309B24419A999979E83058419A999999169B2441666666C6E930584100000000019B244166666626EA305841CDCCCCCCED9A244133333313EA30584100000000E49A244100000020EA3058419A999999DB9A244100000060EA30584100000000D79A2441333333F3EA305841CDCCCCCC5B9A244166666626E630584166666666509A244100000040E130584100000000489A244133333373DE30584166666666429A244133333313DC3058419A9999993D9A244166666686D9305841333333333A9A2441333333B3D73058419A999999339A244100000080D630584133333333299A244133333333D5305841CDCCCCCC239A244100000020D430584166666666229A244133333333D330584166666666229A244166666606D2305841000000001D9A244133333393D030584100000000189A2441CDCCCC0CCF30584100000000169A244100000000CE305841CDCCCCCC139A24419A999999CD305841666666660C9A2441333333D3CC30584166666666079A2441CDCCCC6CCB30584133333333069A2441000000E0CA3058419A999999049A244166666626CA305841CDCCCCCCFC99244100000020C830584100000000009A2441666666A6C630584100000000FF99244100000020C630584166666666F99924419A999919C530584166666666EF992441CDCCCC2CC330584100000000E89924419A999999C13058419A999999DC99244133333393BF30584166666666D1992441333333B3BC305841CDCCCCCCCE992441333333F3BB305841CDCCCCCCCE992441CDCCCC2CBB305841CDCCCCCCCE9924419A9999B9B8305841CDCCCCCCCA99244166666626B6305841CDCCCCCCBA992441666666C6B230584166666666B49924419A999919B130584100000000B299244166666686B030584133333333B199244133333353AF305841CDCCCCCCB099244100000080AD30584100000000AB99244166666646AB30584133333333A299244133333313A9305841CDCCCCCC95992441333333B3A53058410000000086992441CDCCCC0C9F3058419A999999749924419A9999799C305841000000005E992441333333D39A30584100000000439924413333331397305841CDCCCCCC2B9924416666666695305841CDCCCCCC2599244100000040943058419A9999991399244166666606913058416666666605992441666666268E3058419A999999EF9824419A9999598A30584166666666DA9824419A9999F9863058419A999999CA982441000000808330584100000000BA982441333333F37F3058419A999999B2982441333333B37C30584133333333AB982441CDCCCC2C7A3058419A999999A19824410000000077305841CDCCCCCC98982441000000A074305841333333338E982441333333F3723058410000000083982441CDCCCC8C713058416666666670982441CDCCCC4C6F3058416666666660982441CDCCCC2C6D305841CDCCCCCC519824419A9999196B3058419A999999469824419A9999D968305841CDCCCCCC3A982441666666E666305841666666662C982441666666A6653058419A9999991F982441000000C0643058413333333307982441666666A663305841CDCCCCCCE8972441333333F36230584133333333DC962441666666E65C3058416666666664962441666666065D3058419A99999900962441000000E0603058419A99999975952441666666066B30584166666666A39424419A9999F982305841CDCCCCCC2B9424419A999959893058410000000078932441CDCCCC2C8E3058419A9999995F932441CDCCCC2C8E305841000000004C932441333333F38D3058416666666639932441333333938D3058419A999999209324419A9999798D3058419A9999990B932441000000C08D305841CDCCCCCCEA922441666666668E30584166666666D7922441666666268F305841CDCCCCCCC59224410000002090305841CDCCCCCCB59224413333335391305841CDCCCCCCA19224410000004092305841CDCCCCCC8D922441333333B392305841333333337E922441333333B392305841CDCCCCCC769224419A9999D992305841CDCCCCCC7192244166666626933058416666666662922441000000E09330584166666666549224410000008094305841333333334D922441333333B394305841666666663D9224419A9999D99530584166666666339224410000008096305841CDCCCCCC2692244166666646983058413333333311922441666666C69A305841CDCCCCCCF0912441333333539E3058419A999999DE91244166666626A130584133333333CE91244133333373A3305841CDCCCCCCB7912441666666A6A53058413333333390912441CDCCCCECA730584100000000799124419A999959A9305841000000006691244166666626AA305841666666665291244166666666AA3058419A9999992C91244100000060AA3058419A9999990E91244100000020AA3058416666666601912441CDCCCC4CAA305841CDCCCCCCF5902441CDCCCC0CAA30584166666666EE9024419A999939AA30584166666666E590244166666666AA30584100000000DA90244166666606AB30584166666666CB9024419A9999D9AB3058419A999999AF90244100000000AC3058413333333392902441CDCCCCECAB305841333333337D90244166666626AB305841CDCCCCCC729024419A999919AB3058419A9999996C90244133333333AB305841CDCCCCCC6690244100000040AB3058419A9999995E90244133333393AB305841CDCCCCCC3B90244100000000AE30584166666666209024419A999939B1305841CDCCCCCC0A902441CDCCCC8CB3305841CDCCCCCCE78F24419A999919B6305841CDCCCCCCCB8F244166666686B830584166666666AD8F244133333353BA305841000000009A8F24419A9999D9BA3058419A999999838F2441CDCCCCCCBA30584100000000728F24419A999939BA30584100000000638F24419A9999F9B9305841333333334F8F24419A9999B9B93058419A999999398F2441333333F3B9305841CDCCCCCC228F244133333313BA3058419A999999108F2441CDCCCCCCB9305841CDCCCCCC048F2441666666E6B83058419A999999F48E2441CDCCCC6CB730584100000000E38E2441333333D3B530584100000000DA8E2441666666E6B430584100000000D78E244166666686B43058419A999999E68E24419A9999F9B230584133333333EB8E24419A9999D9B1305841CDCCCCCCED8E2441000000E0B030584133333333F08E2441CDCCCC0CB030584166666666F28E2441000000C0AE3058419A999999F68E24419A999999AD3058419A999999F98E2441CDCCCCCCAC30584166666666F98E2441CDCCCC2CAC30584100000000F88E2441CDCCCC4CAA305841CDCCCCCCF88E2441000000C0A73058419A999999F98E2441CDCCCCCCA630584133333333FA8E24419A999939A630584133333333FA8E24419A999959A53058419A999999F98E244166666626A330584133333333FB8E24419A999999A13058419A999999FF8E2441666666E69F3058419A999999018F2441000000009E305841CDCCCCCC028F2441CDCCCC4C9B30584133333333068F2441CDCCCC8C9A30584133333333098F2441CDCCCC0C9A3058419A9999990D8F2441CDCCCCAC99305841666666661D8F24419A9999B998305841333333332B8F24419A999999973058419A999999348F2441666666E695305841000000003D8F24416666664693305841CDCCCCCC418F2441CDCCCC0C9030584133333333448F2441000000E08D30584100000000458F2441000000208D305841333333334B8F2441000000008C305841333333334F8F2441333333538B305841CDCCCCCC558F2441333333138A305841333333335A8F2441000000C088305841CDCCCCCC5C8F2441666666A687305841000000005F8F24413333333386305841000000005F8F2441000000E083305841CDCCCCCC618F24416666666682305841CDCCCCCC678F244100000000813058419A9999996D8F2441CDCCCCEC7F30584166666666718F24419A9999997E305841CDCCCCCC728F2441000000407D30584166666666718F2441000000C07B3058419A999999718F2441666666667A3058419A999999768F24419A99999978305841CDCCCCCC798F24419A9999F976305841CDCCCCCC5C8F2441CDCCCCAC67305841CDCCCCCC298F24419A9999795730584133333333AE8E2441000000E04130584133333333978E2441000000E04230584166666666798E2441CDCCCCAC44305841000000005D8E2441CDCCCCEC463058419A9999993D8E2441666666C649305841666666662C8E24419A9999B94B305841333333331C8E2441666666C64D30584133333333FF8D2441666666265130584100000000EA8D2441333333935330584100000000D28D2441333333F35530584100000000C18D2441666666A6573058419A999999B38D2441CDCCCCCC5830584100000000A68D2441CDCCCC8C59305841000000008E8D2441666666C65A305841CDCCCCCC728D2441333333535C3058419A999999508D2441333333335E3058419A9999992F8D2441333333D35F305841000000001D8D24419A9999F960305841CDCCCCCC148D2441666666A661305841CDCCCCCC0C8D2441666666C66230584166666666078D24416666668663305841CDCCCCCC108D2441CDCCCC0C663058419A999999178D24416666660668305841333333331E8D2441666666666A30584133333333228D2441666666066D3058419A999999238D2441666666266F305841CDCCCCCC228D24419A9999B97130584133333333218D24419A9999D9733058419A9999991E8D24419A999959763058419A9999991A8D2441666666867830584133333333178D2441000000007A30584133333333148D2441000000207B30584166666666128D2441000000A07C30584133333333128D24419A9999D97D30584166666666128D2441000000E07E30584133333333138D2441CDCCCCEC80305841CDCCCCCC148D2441000000A08230584100000000168D2441333333B38430584166666666168D2441CDCCCC2C873058419A999999148D2441666666A68830584100000000128D2441333333738A305841CDCCCCCC0D8D2441333333938C305841CDCCCCCC058D2441CDCCCC4C8F30584133333333FD8C2441000000609230584166666666F38C2441666666C69530584166666666E98C2441000000409930584133333333E18C2441333333539C30584133333333D88C2441CDCCCC4CA030584133333333D08C24419A999959A330584100000000C98C24419A999919A6305841CDCCCCCCBF8C244133333313A930584133333333AA8C244166666666AE30584166666666978C24419A9999B9B2305841CDCCCCCC8E8C2441000000E0B430584166666666808C244133333393B83058419A999999728C244100000020BC305841666666665E8C2441333333D3C03058419A9999994F8C24419A9999F9C430584100000000458C244100000080C83058419A999999448C2441CDCCCCACC8305841CDCCCCCC8D8B24419A999959C130584100000000EE8A244166666686C13058419A999999448A2441333333B3C630584166666666CD892441CDCCCCCCD0305841000000000789244100000080E63058419A999999A38824419A999919EE305841000000007C88244100000060F4305841666666666888244166666666F930584133333333878824419A99999904315841CDCCCCCC878824419A9999990E3158416666666639882441666666262531584166666666FF872441CDCCCCEC413158419A99999900882441CDCCCC2C5231584133333333298824419A9999195C3158419A999999DE882441666666A67331584100000000FD8824419A9999197B3158419A999999088924413333339391315841CDCCCCCC3B89244100000040A4315841000000006C892441CDCCCCCCBE3158416666666667892441000000A0C1315841666666666289244100000080C431584166666666608924419A999919C73158419A9999996089244133333313C931584133333333618924419A999919CB31584133333333638924419A9999F9CB315841000000006489244100000060CC3158419A99999965892441CDCCCCACCC3158419A9999996789244100000020CD31584166666666698924419A999999CD315841666666666889244166666606CE3158419A9999996789244100000040CE315841000000006089244100000080CF315841666666665D89244166666606D0315841333333335C89244133333353D0315841CDCCCCCC5B89244100000000D1315841000000005C89244100000080D1315841333333335F89244133333393D23158419A99999967892441CDCCCC8CD33158413333333377892441000000E0D43158419A9999997F892441666666A6D5315841333333338489244133333353D631584133333333888924419A999939D7315841000000008B89244100000020D8315841000000008E892441CDCCCCECD9315841000000008F89244133333333DB315841666666669089244166666606DC3158419A999999948924419A999939DD315841666666669789244100000080DE315841666666669A89244166666666E0315841000000009B892441CDCCCC4CE13158419A9999999A8924419A999939E23158413333333399892441000000C0E2315841333333339589244133333373E3315841000000009189244100000020E4315841000000008E892441333333B3E4315841333333338A8924419A999999E53158416666666686892441CDCCCC0CE7315841CDCCCCCC8089244133333333E9315841333333337F892441CDCCCCECEA315841666666667F8924419A999959ED315841000000007F892441666666A6EF315841666666667D892441333333D3F0315841CDCCCCCC788924419A999919F23158419A9999997089244166666626F3315841333333336A89244166666646F4315841666666666889244166666606F53158419A99999968892441CDCCCC2CF6315841666666666989244133333393F63158410000000069892441333333F3F6315841333333336789244166666626F73158413333333365892441CDCCCC2CF7315841CDCCCCCC6189244166666686F73158419A9999995A89244133333333F8315841333333335689244100000020F9315841000000005289244133333353FA31584100000000508924419A9999B9FB315841333333334F892441333333F3FD315841CDCCCCCC508924419A999939003258419A9999995389244166666686013258419A99999953892441666666E60132584133333333528924419A999999023258410000000051892441333333D302325841666666664B892441CDCCCC8C04325841333333334189244133333333063258419A9999993C892441CDCCCC0C07325841CDCCCCCC388924419A99999907325841CDCCCCCC378924419A9999D90732584100000000378924419A999939083258413333333337892441333333B3083258416666666639892441CDCCCC2C093258419A9999993F892441CDCCCC8C0A32584166666666478924419A9999790B3258419A9999994A892441000000E00B325841000000004C892441CDCCCC2C0C325841333333334C8924419A9999590C325841333333334B892441CDCCCCAC0C325841000000004A892441333333D30C3258419A99999947892441333333F30C325841CDCCCCCC3A892441000000200E325841CDCCCCCC35892441666666C60E325841000000002F892441CDCCCCCC0F325841CDCCCCCC28892441CDCCCC4C10325841CDCCCCCC248924413333339310325841333333330789244133333333113258419A9999996E882441000000A0083258419A999999CD872441CDCCCCCCF4315841333333337D872441666666E6EF315841CDCCCCCCDC86244133333353E73158410000000037862441CDCCCC4CD9315841CDCCCCCC68852441CDCCCCCCAE315841CDCCCCCC68852441000000609D3158413333333366842441000000407B3158413333333329842441666666A65F31584166666666FC832441CDCCCCCC53315841CDCCCCCCF48324419A9999795231584166666666EF832441000000E05031584133333333EE8324419A9999D94F3158419A999999EB8324419A9999D94D315841CDCCCCCCEA832441666666464931584133333333E9832441000000C04331584100000000E78324419A9999B93E315841CDCCCCCCE4832441000000E03831584166666666E3832441666666063431584166666666E3832441666666C62F31584166666666E2832441666666862A31584166666666E08324413333333324315841CDCCCCCCDD8324419A9999191D31584166666666DC832441000000601731584133333333DA832441333333131131584166666666D6832441CDCCCC6C0B315841CDCCCCCCD4832441333333F305315841CDCCCCCCD2832441CDCCCCCC0031584133333333D28324419A999939FC30584100000000D2832441CDCCCC8CF93058419A999999D1832441CDCCCC2CF630584133333333D1832441CDCCCC6CF4305841CDCCCCCCCF83244133333353F330584166666666F28324419A999999E730584133333333E783244166666626D63058419A999999C783244133333333BD3058419A999999B28324419A999979AF3058419A9999997E83244133333353903058419A99999988832441666666A67F305841333333336D8324413333339382305841666666665B832441000000A0843058419A9999994D832441333333B386305841666666663C832441CDCCCC6C88305841CDCCCCCC2D832441333333938930584166666666208324419A9999F98A305841000000001B8324419A9999798C3058410000000017832441333333B38E3058419A99999910832441666666A6903058419A99999907832441666666869230584100000000F782244100000020943058419A999999EA822441000000C09430584166666666DC822441333333939430584133333333C6822441CDCCCCAC933058419A999999A98224419A999919933058419A999999A1822441333333539330584100000000988224419A99995994305841CDCCCCCC838224419A99997996305841666666666982244133333353993058413333333354822441CDCCCCCC9B305841CDCCCCCC4E822441333333B39C305841666666664C822441CDCCCC0C9D3058410000000049822441333333F39D3058416666666646822441000000409E30584100000000438224419A9999799E305841666666663D822441666666A69E3058416666666637822441333333B39E305841333333332B8224419A9999399F3058413333333322822441CDCCCCAC9F3058419A9999991D82244133333313A03058419A99999919822441000000C0A030584166666666198224419A999939A1305841333333331982244133333313A2305841333333331D82244100000000A3305841000000002F822441CDCCCC2CA53058410000000039822441CDCCCCCCA63058419A9999993C82244166666646A73058419A9999993D822441CDCCCCCCA7305841000000003E82244100000080A8305841333333332C822441CDCCCCACAA3058419A9999992082244100000020AC30584166666666158224419A999959AD305841000000000E822441666666C6AD305841CDCCCCCC0182244100000000AE3058419A999999FA8124419A9999F9AD30584166666666F181244133333313AE30584166666666E7812441666666C6AE305841CDCCCCCCE0812441666666E6AF30584166666666CE812441333333B3B230584166666666BE81244100000060B4305841CDCCCCCCB0812441000000C0B530584166666666A681244100000040B63058419A9999999D812441CDCCCC6CB63058419A999999918124419A999939B63058419A99999988812441CDCCCC6CB53058410000000082812441333333F3B4305841000000007A812441CDCCCC8CB43058413333333372812441CDCCCC0CB43058419A9999996C812441CDCCCC0CB43058413333333369812441CDCCCC2CB43058410000000067812441CDCCCC6CB43058413333333365812441000000C0B43058419A9999995E812441CDCCCC0CB6305841000000005081244100000000B83058413333333341812441CDCCCC0CBA305841000000003481244100000040BB305841333333332681244100000080BC305841000000001F81244133333373BD305841333333331C81244166666626BE305841CDCCCCCC1981244100000020BF305841CDCCCCCC178124419A999959C03058413333333314812441666666A6C1305841000000000F81244100000080C23058410000000009812441CDCCCC6CC3305841CDCCCCCC0281244166666606C430584166666666FA8024419A999999C430584100000000F48024419A9999F9C430584100000000E68024419A999999C5305841CDCCCCCCDF80244166666606C630584166666666D8802441CDCCCCACC630584166666666D38024419A999979C73058419A999999CC80244166666626C830584166666666C3802441CDCCCCACC830584166666666B98024419A9999D9C8305841000000009C802441333333D3C93058419A9999999280244133333313CA3058419A9999998780244133333313CA305841333333337F802441000000C0C93058410000000079802441CDCCCC2CC930584100000000738024419A999979C83058419A9999996C8024419A9999F9C73058419A99999966802441666666E6C7305841000000005F8024419A9999D9C73058419A9999995B80244166666686C73058419A999999588024419A999959C630584100000000568024419A999999C430584133333333518024419A9999D9C23058419A9999994D80244166666646C23058416666666646802441333333B3C1305841CDCCCCCC3A80244133333313C13058419A99999931802441CDCCCC8CC0305841000000002E802441CDCCCCECBF305841000000002C8024419A999999BE305841000000002D80244100000080BB305841666666662B80244100000020B9305841666666662780244133333333B7305841CDCCCCCC2080244166666646B5305841333333331D802441CDCCCC6CB43058413333333319802441000000E0B33058419A999999148024419A999979B33058419A9999990E8024419A999919B3305841000000000380244133333313B330584100000000F87F244100000020B330584133333333E87F244100000060B33058419A999999D97F2441333333F3B330584133333333CB7F24419A9999B9B43058419A999999C07F24419A999959B530584133333333BC7F2441333333F3B530584133333333B77F24419A999999B630584166666666B27F244133333333B7305841CDCCCCCCAC7F24419A999939B8305841CDCCCCCCA67F244100000060B930584100000000A37F24419A999939BA305841000000009C7F244133333333BB30584100000000937F2441CDCCCC0CBC30584133333333897F2441333333B3BC305841000000007B7F244133333313BD3058419A999999607F2441CDCCCCCCBD30584100000000497F2441CDCCCC8CBE305841333333333B7F24419A999939BF30584166666666317F24419A999959C030584133333333277F2441666666C6C130584133333333227F2441CDCCCCCCC2305841CDCCCCCC147F2441333333F3C1305841666666660D7F24419A999919C130584100000000047F2441000000C0BF30584133333333FC7E2441CDCCCC4CBE305841CDCCCCCCF47E244100000020BD30584100000000EF7E2441CDCCCC2CBC305841CDCCCCCCE97E2441666666E6BA30584166666666E47E244133333373B930584100000000DF7E244166666606B830584100000000DD7E24419A999919B73058419A999999D07E2441333333F3B330584100000000C57E244100000060B130584100000000BC7E2441CDCCCC6CAF30584133333333AD7E244133333333AD3058419A999999A27E24419A999939AB305841000000009A7E244133333373A930584133333333937E244166666646A8305841CDCCCCCC8E7E2441666666C6A6305841666666668C7E2441CDCCCCACA5305841000000008C7E2441CDCCCCCCA4305841CDCCCCCC897E244133333393A330584166666666867E2441CDCCCCACA230584100000000837E244133333393A1305841CDCCCCCC817E24419A9999D99F305841CDCCCCCC807E24419A9999199E305841333333337F7E2441000000209D3058419A9999997B7E2441CDCCCCEC9B30584100000000767E2441CDCCCCEC9A305841000000006F7E2441CDCCCC0C9A30584100000000677E24413333333399305841CDCCCCCC5A7E244133333353983058419A9999994E7E2441CDCCCC6C9730584133333333427E24419A99999996305841CDCCCCCC327E2441666666A695305841333333332C7E24413333331395305841CDCCCCCC277E2441CDCCCC4C9430584133333333247E24419A999939933058419A999999217E24419A9999F99130584100000000207E24416666664690305841666666661E7E2441000000A08D305841000000001E7E24419A99993989305841666666661E7E244100000080843058419A9999997A7E24419A9999B95F30584133333333837E24419A9999B94B3058419A9999996E7E2441000000C041305841666666663B7E2441333333132F30584100000000F47D2441CDCCCCAC193058419A999999B77D2441000000001130584100000000357D244166666626073058419A999999EE7C24419A9999B9FF2F584133333333C47C2441000000A0F52F584166666666B57C2441CDCCCC4CF22F584133333333A37C244100000080F02F58419A999999917C244166666626F02F58419A999999787C24419A999959F42F5841666666665F7C2441666666C6F62F5841CDCCCCCC3D7C244166666626F82F58419A9999990D7C2441CDCCCCCCF82F584100000000F37B24419A9999B9F72F584100000000D97B2441CDCCCC8CF52F5841CDCCCCCCC77B244166666646F52F58419A999999AE7B244133333373F52F58419A999999A07B2441CDCCCC0CF62F584166666666897B24419A9999D9F82F584133333333707B24419A9999D9FB2F584100000000457B244100000080FD2F5841000000001E7B24419A9999F9FD2F584166666666F67A244166666606FE2F584100000000AE7A2441CDCCCC2CFE2F58419A999999757A244166666666FE2F584166666666557A2441CDCCCC2CFF2F584100000000307A2441333333B3003058419A999999037A24410000008001305841CDCCCCCCC97924413333331300305841CDCCCCCCAC79244133333353FD2F5841666666668C792441333333B3FB2F5841666666664879244133333393FB2F58419A9999990679244166666666FD2F58419A999999E178244100000080FF2F58419A999999A978244166666606023058419A9999997C7824419A99999902305841CDCCCCCC65782441666666860230584100000000317824416666660600305841000000000678244133333313FC2F58419A999999D4772441CDCCCCCCF92F5841CDCCCCCCA677244166666606FA2F5841CDCCCCCC7C7724419A9999D9FA2F5841000000005C772441666666C6FA2F5841CDCCCCCC3077244133333373FA2F5841666666660B772441666666E6F82F584133333333E87624419A999979F52F584100000000AF762441CDCCCC4CF02F5841666666668C76244166666626EB2F5841000000005976244166666646E62F5841333333332676244100000040E42F584133333333D575244133333393E32F5841333333339D752441666666C6E32F5841000000005C752441CDCCCCECE32F58419A99999924752441333333D3E32F584166666666FB74244166666666E32F584166666666C77424419A999939E22F584100000000BF74244133333313E22F584133333333B5742441000000E0E12F5841CDCCCCCCA27424419A999979E22F5841CDCCCCCC90742441666666C6E22F58419A99999975742441000000C0E42F5841CDCCCCCC58742441CDCCCCECE62F5841CDCCCCCC447424419A999919E72F5841333333333074244166666686E42F584166666666267424419A999919E12F5841CDCCCCCC107424419A9999B9D92F5841CDCCCCCCDD7324419A9999F9CF2F58419A9999999773244133333333C42F5841000000008173244100000060C02F5841CDCCCCCC69732441333333D3BF2F5841CDCCCCCC5273244100000020C02F5841333333330C73244100000060C12F584100000000CD72244166666686C12F5841333333339A722441333333D3B32F5841000000002B7224419A999939A12F584166666666F871244166666686982F58419A999999D9712441333333138C2F5841CDCCCCCCC371244100000060702F5841CDCCCCCCAE712441CDCCCC6C612F58410000000090712441333333F3542F58410000000049712441CDCCCC0C462F58419A9999991E712441000000003D2F5841CDCCCCCCFB702441666666263E2F584166666666EB702441000000A03E2F584166666666DD702441CDCCCCEC3E2F584100000000D0702441666666463E2F584100000000BE702441CDCCCC6C3D2F584133333333A4702441333333133E2F58410000000097702441CDCCCCAC3E2F584133333333847024419A9999F93E2F58416666666677702441666666E63E2F58419A999999687024419A9999F93F2F5841CDCCCCCC5D7024419A9999B9412F58419A9999994E702441CDCCCCCC432F58413333333344702441666666A6452F5841000000004370244133333373462F5841666666664470244100000040472F58419A9999994270244166666606482F5841666666663D702441333333D3482F5841333333332D702441CDCCCCCC492F58413333333321702441000000004B2F58410000000019702441000000A04B2F5841CDCCCCCC11702441CDCCCC6C4B2F58413333333301702441666666864A2F584133333333F96F24419A9999F9492F58419A999999F26F24419A9999D9492F58419A999999E76F24419A9999394A2F5841CDCCCCCCDF6F2441666666A64A2F5841CDCCCCCCD26F2441666666C64A2F5841CDCCCCCCCC6F2441CDCCCCAC4A2F5841CDCCCCCCC56F2441666666264A2F58419A999999C06F24419A9999F9492F584166666666BA6F2441000000204A2F58419A999999B06F2441333333734A2F584166666666A76F2441CDCCCCCC4B2F5841CDCCCCCCA56F2441000000604E2F584133333333A66F244166666646522F5841000000009D6F244100000020572F5841CDCCCCCC916F2441333333735B2F58419A999999826F2441CDCCCC6C5D2F584133333333726F2441CDCCCCCC5E2F5841CDCCCCCC646F24419A9999F95E2F58419A999999546F2441CDCCCC4C5F2F5841CDCCCCCC386F2441333333B3612F584166666666286F24419A9999D9622F584133333333156F2441CDCCCC2C632F58419A9999990D6F24419A999939632F584166666666EB6E24419A9999B9652F584166666666CD6E2441CDCCCC8C692F584166666666B96E2441333333536C2F58419A999999566E244100000060792F5841CDCCCCCC2E6E24419A9999D97D2F584166666666146E2441000000C0802F584166666666FB6D2441000000E0822F5841CDCCCCCCE06D244100000020852F5841CDCCCCCCCC6D24419A999979872F584133333333BF6D2441666666E6892F58419A999999B96D2441666666A68C2F584166666666B26D244166666606902F584100000000B66D24419A999919972F584133333333D56D2441666666269D2F5841CDCCCCCCEC6D244133333333A12F5841CDCCCCCCF26D244100000060A42F584133333333F66D24419A9999B9A72F584133333333F16D24419A999999A92F58419A999999E66D2441000000A0AB2F584100000000D86D244166666686AC2F584100000000CD6D244100000000AD2F584100000000C56D2441CDCCCC2CAE2F584100000000B26D24419A9999B9B12F584166666666A46D244166666646B22F58419A9999999B6D244133333373B22F58419A999999986D2441666666C6B22F5841333333338F6D244100000060B52F58419A9999997E6D2441CDCCCC2CB82F584133333333696D2441666666A6B92F584166666666586D2441000000C0B92F5841CDCCCCCC4C6D24419A9999F9B92F5841666666662A6D24419A999939BB2F584166666666206D244166666686BB2F584100000000146D24419A999939BA2F584166666666086D244133333313B82F584100000000FF6C2441333333D3B52F5841CDCCCCCCF46C2441333333D3B42F58419A999999E56C2441CDCCCCACB42F58419A999999CB6C244100000080B52F58419A999999B56C24419A9999F9B52F58419A999999AF6C244166666606B62F58419A9999999B6C244166666606B52F5841666666668D6C24419A999939B32F58419A999999866C2441CDCCCC4CB22F5841666666666E6C2441666666E6B02F584133333333616C244166666666B12F584100000000526C244166666606B32F584166666666456C2441333333B3B72F584166666666366C244133333333BE2F584166666666366C2441666666C6C02F58419A9999993B6C2441000000A0C32F5841000000003C6C244100000080C42F584166666666326C24419A999979C72F5841CDCCCCCC176C244166666666CA2F584133333333FA6B2441CDCCCCCCCB2F584133333333CE6B244166666606CD2F584100000000C16B24419A9999D9CC2F5841CDCCCCCC906B2441CDCCCCCCCD2F584100000000436B24419A9999D9CF2F584166666666036B244100000040D22F584100000000E36A244133333353D42F5841CDCCCCCCD16A24419A999979D52F584133333333C56A2441000000A0D52F584166666666AF6A2441CDCCCC4CD52F584100000000A06A2441666666E6D42F5841CDCCCCCC8C6A2441CDCCCC2CD42F5841CDCCCCCC656A2441CDCCCC6CD22F58419A999999506A2441000000A0D02F584100000000416A2441000000C0CC2F58419A999999336A244133333313CA2F5841CDCCCCCC256A244166666646C82F58419A999999116A24419A999919C82F58419A999999FC69244166666666C82F584133333333E4692441333333D3C92F584100000000C469244166666666CD2F58419A999999A569244166666646D12F5841CDCCCCCC8A69244133333333D52F5841000000007E69244100000040D82F5841CDCCCCCC70692441CDCCCCECDB2F5841CDCCCCCC6769244166666606E02F5841333333335F69244166666666E32F58413333333354692441666666C6E52F5841666666664C692441333333D3E72F58419A99999948692441666666C6E92F5841333333334669244166666646EC2F584166666666466924419A999999EF2F58419A9999994C6924419A9999D9F32F5841666666664E6924419A9999F9F62F58419A9999994E69244100000060FA2F58416666666647692441CDCCCC6CFE2F5841CDCCCCCC35692441CDCCCC0C04305841000000002E6924419A99991907305841666666662B692441333333530D3058419A999999276924419A9999790E3058413333333323692441CDCCCC4C0F305841666666661C692441666666E60F3058410000000011692441000000001030584133333333F8682441CDCCCCCC0F305841CDCCCCCCEC682441333333930F30584166666666D8682441000000A00F30584166666666D3682441333333730F3058419A999999C46824419A9999590E30584133333333B3682441666666A60D3058413333333393682441000000200D3058410000000078682441666666E60D3058410000000069682441666666060E305841666666665E682441000000200E3058413333333352682441000000000E3058416666666649682441000000E00D305841CDCCCCCC3D682441000000000E305841666666662B682441333333B30E3058413333333320682441CDCCCC0C10305841333333330D6824419A9999F913305841CDCCCCCCFC672441CDCCCC6C1630584100000000ED672441333333B318305841CDCCCCCCE2672441000000E01930584133333333D6672441666666A61B30584133333333C5672441000000C01E3058419A999999BE672441CDCCCCAC2030584133333333B56724419A9999192330584166666666AB6724419A9999992430584133333333A0672441666666A62530584100000000896724410000006027305841333333338067244133333353283058413333333376672441CDCCCCAC283058419A9999996B672441333333B327305841CDCCCCCC5D672441CDCCCC0C273058410000000050672441000000E025305841CDCCCCCC4B672441CDCCCC6C253058410000000048672441666666E62430584133333333436724413333333324305841666666663F6724419A9999F923305841666666663567244166666666233058410000000028672441000000A023305841666666660E6724413333333323305841CDCCCCCCFE662441000000C02230584100000000FC662441333333D322305841CDCCCCCCF66624419A99999922305841CDCCCCCCE9662441333333D3223058419A999999E5662441CDCCCC6C2330584100000000DE6624419A9999F92430584166666666DA662441666666C62730584166666666DB6624419A9999B9283058419A999999E3662441666666062930584133333333E9662441333333F3283058419A999999EC66244133333313293058419A999999F96624419A9999392A3058419A99999900672441333333F32B3058410000000003672441CDCCCCCC2E305841CDCCCCCCFA662441333333133130584133333333ED662441666666A63330584100000000D9662441000000003730584100000000BD662441666666A63B305841CDCCCCCCAA662441666666863F305841333333339E66244100000080423058419A99999999662441CDCCCC8C453058419A9999999B662441666666C647305841333333339D662441333333D34A3058419A9999999D662441CDCCCC2C4E305841333333339E662441000000C051305841CDCCCCCC9C6624413333333354305841333333339466244100000080593058419A9999998E662441CDCCCC2C5F305841333333338B6624419A99999961305841CDCCCCCC87662441666666E6633058419A9999998266244166666626653058410000000081662441666666C6653058419A99999979662441000000C06630584100000000726624416666662667305841000000006A662441000000006730584100000000636624419A99999966305841CDCCCCCC5466244166666666663058413333333345662441CDCCCCAC663058419A999999306624413333331368305841CDCCCCCC20662441000000606A30584100000000046624419A9999D96F30584166666666FE652441CDCCCCEC703058419A999999F46524419A9999397230584100000000E7652441000000007330584133333333D36524419A9999D97330584133333333CF652441666666467430584166666666C5652441333333D37530584166666666BF6524419A9999D977305841CDCCCCCCBB652441000000E07A30584166666666BC6524419A9999797C30584166666666BA652441CDCCCCCC7D30584133333333B5652441000000C07F30584100000000AE6524419A9999D980305841CDCCCCCC9D65244166666666823058416666666696652441CDCCCCCC84305841CDCCCCCC9065244100000080863058410000000085652441333333B387305841333333337865244100000040883058416666666663652441666666C689305841CDCCCCCC55652441CDCCCCEC8A3058419A99999944652441666666868D305841000000003C652441333333F38F305841CDCCCCCC3665244100000080913058419A9999992D652441CDCCCCCC93305841CDCCCCCC296524419A9999D995305841CDCCCCCC216524419A999979993058410000000018652441CDCCCCECA0305841000000000965244133333313A93058413333333304652441333333F3AC305841CDCCCCCC04652441333333B3AF3058410000000008652441333333D3B3305841333333330865244133333373B53058419A9999990765244133333313B7305841000000000865244166666686B73058413333333304652441333333F3B8305841666666660665244166666666BB3058419A999999076524419A9999D9BB305841000000000D6524419A999939BD305841666666660F65244166666646BE3058410000000011652441CDCCCCECBF3058419A999999116524419A999979C1305841333333330E65244100000040C23058419A9999990C652441333333B3C2305841000000000765244133333373C33058413333333303652441CDCCCC0CC43058419A999999FF642441CDCCCC2CC530584166666666FF642441666666A6C630584100000000FC6424419A9999B9C630584133333333F7642441CDCCCC8CC630584100000000ED6424419A9999F9C530584100000000E764244133333313C630584133333333E2642441000000E0C6305841CDCCCCCCDE6424419A999999C9305841CDCCCCCCDC642441666666C6CA3058419A999999D5642441CDCCCCACCB30584100000000CF6424419A9999D9CC3058419A999999C764244133333393CE305841CDCCCCCCC8642441666666C6CF30584100000000CB6424419A999979D130584100000000C864244100000000D230584133333333C46424419A999919D230584133333333BD642441CDCCCC2CD23058419A999999B8642441333333D3D130584166666666B1642441CDCCCCACD130584133333333AE642441CDCCCC4CD230584133333333AC642441333333F3D230584100000000AA64244100000020D4305841000000009E642441666666C6D5305841666666669864244133333393D63058410000000090642441CDCCCC6CD73058413333333386642441666666A6D8305841666666667E6424419A999919DC3058419A99999977642441CDCCCC8CE1305841333333337664244133333313E43058419A9999997664244166666606E5305841CDCCCCCC736424419A9999F9E5305841CDCCCCCC6D64244100000020E6305841666666665B6424419A999939E63058416666666653642441666666A6E63058410000000052642441CDCCCCACE73058413333333353642441CDCCCC8CE93058413333333354642441CDCCCCECEA305841666666665864244100000040EB305841333333335C64244133333393EC305841333333335A64244166666646ED305841000000005664244133333393ED3058413333333348642441000000C0F030584166666666496424419A999979F2305841000000004B64244100000020F5305841CDCCCCCC4D642441000000C0F6305841666666664D642441CDCCCC6CF9305841333333334664244133333373FB305841CDCCCCCC3A64244133333373FD305841CDCCCCCC3264244133333393FF3058410000000027642441333333B3003158410000000022642441CDCCCC2C01315841000000001B642441CDCCCCAC01315841CDCCCCCC166424419A9999B9013158419A9999990E642441000000A001315841000000000A642441CDCCCC6C013158419A99999901642441CDCCCC4C0131584133333333F66324419A99997901315841CDCCCCCCEC6324419A9999F90131584100000000E6632441000000400231584133333333DD632441CDCCCC2C02315841CDCCCCCCD56324416666660602315841CDCCCCCCD06324419A9999B90131584133333333C063244100000060013158419A999999AD632441333333B30131584166666666A9632441000000200231584133333333A363244100000060033158419A999999A06324419A9999D904315841CDCCCCCC9F6324419A9999590631584166666666A0632441000000E007315841CDCCCCCC9F63244133333393093158410000000091632441666666460C3158419A9999997B632441333333730E315841000000006B6324419A999979103158419A999999556324419A999919133158416666666644632441666666C6143158419A999999386324419A99999916315841000000002E632441CDCCCCAC18315841CDCCCCCC1F6324419A9999F91A315841CDCCCCCC18632441666666C61B3158413333333303632441CDCCCCEC1C31584133333333F9622441666666061D31584133333333E56224419A9999591D31584166666666C5622441000000201E3158419A999999B8622441CDCCCCCC1E3158419A999999AE6224410000004020315841CDCCCCCCA96224410000004021315841000000009D622441666666C62131584133333333966224419A99997922315841000000009162244100000060233158416666666684622441CDCCCC4C24315841CDCCCCCC816224416666668624315841000000007A6224413333335325315841CDCCCCCC766224419A999939263158419A9999996E6224419A9999192731584133333333626224413333335328315841666666666062244133333353293158410000000063622441000000202A315841CDCCCCCC64622441000000A02B3158410000000061622441333333F32B3158413333333359622441333333332D3158419A999999536224419A9999792E315841CDCCCCCC50622441CDCCCC2C303158413333333354622441000000C03131584100000000556224419A9999D9323158410000000047622441666666263431584100000000416224416666668634315841666666663F622441333333B334315841333333333E622441666666A635315841666666663D622441666666A636315841CDCCCCCC3E62244100000000383158419A99999942622441666666A639315841666666663F622441CDCCCCCC3A3158419A9999993E622441666666C63D315841CDCCCCCC3E622441000000203F315841CDCCCCCC41622441CDCCCC4C41315841CDCCCCCC47622441CDCCCC4C433158413333333350622441666666E644315841000000005B62244166666626463158416666666662622441000000E0463158419A9999996362244100000080473158416666666665622441666666264831584133333333646224413333333349315841666666665A622441333333534B315841CDCCCCCC456224419A9999994F3158413333333334622441333333F351315841CDCCCCCC2D622441666666E652315841CDCCCCCC2A622441000000405431584133333333296224419A999959553158413333333333622441333333335831584166666666206224419A9999995A315841000000000A622441000000805E315841666666660362244100000040603158410000000003622441CDCCCC2C6131584133333333016224410000000063315841CDCCCCCCFF612441666666E6633158419A999999FB61244100000020653158419A999999F4612441000000606631584133333333F0612441666666E66631584133333333E6612441666666266731584100000000DC612441666666E6663158419A999999D1612441CDCCCC2C663158419A999999C46124419A9999596531584133333333B8612441333333D364315841CDCCCCCCB6612441000000C06431584133333333AF612441000000E064315841CDCCCCCCA76124413333333366315841CDCCCCCCA3612441CDCCCC2C68315841000000009F61244100000080693158413333333394612441CDCCCCCC693158419A99999986612441666666466A315841000000007E6124419A9999F96A3158419A99999971612441000000206C3158419A9999996A612441000000206E315841666666665A6124416666664671315841CDCCCCCC3C612441CDCCCC8C753158413333333315612441666666E679315841CDCCCCCC06612441333333137B3158419A999999EF602441666666467D31584100000000E7602441000000007F31584166666666DC602441666666868231584166666666CD602441000000E088315841CDCCCCCCC9602441666666468A3158419A999999C1602441333333D38B315841CDCCCCCCB6602441CDCCCC4C8D31584133333333AC602441000000E08E31584166666666A6602441333333F39031584100000000A5602441CDCCCC6C9231584100000000A7602441000000C09331584100000000B06024410000008094315841CDCCCCCCB9602441333333F39431584133333333C86024419A9999F99431584100000000D3602441000000A095315841CDCCCCCCD96024419A99999996315841CDCCCCCCD1602441CDCCCC0C9931584133333333C56024419A9999999C31584166666666BD602441666666A69E31584166666666BC602441000000A0A0315841CDCCCCCCBB602441CDCCCC2CA2315841CDCCCCCCBF6024419A9999D9A331584133333333D2602441000000E0A431584166666666E3602441333333D3A53158419A999999EE602441CDCCCCECA631584133333333EE60244166666606A831584166666666E76024419A9999D9AB31584133333333E660244166666686AC31584100000000E5602441000000A0AD31584133333333E6602441CDCCCC4CAE31584133333333E860244166666606AF31584133333333EF602441CDCCCC4CAF31584133333333F760244133333313AF31584166666666FC602441000000C0AE315841CDCCCCCC0461244166666646AE315841333333330E612441CDCCCCECAD3158419A999999156124419A9999F9AD315841333333332061244166666686AE31584166666666266124419A9999F9AF315841333333332F612441000000A0B13158419A99999936612441CDCCCC4CB23158419A9999993F61244100000020B3315841000000004D61244166666626B53158410000000065612441CDCCCCECB8315841333333337C612441666666E6BB3158416666666681612441000000A0BC315841666666668561244133333313BD315841000000008F612441000000C0BD315841CDCCCCCC9F6124419A999979BE31584100000000AB61244166666606BF3158419A999999BB61244100000040C13158419A999999C061244100000020C2315841CDCCCCCCC1612441000000E0C3315841CDCCCCCCBD612441333333D3C431584100000000B66124419A999959C631584166666666A361244166666686C83158419A9999997E61244166666686CC3158419A9999997461244166666666CD3158413333333366612441CDCCCC6CCE315841CDCCCCCC5861244133333393CF315841CDCCCCCC4D6124419A999939D0315841CDCCCCCC1D61244133333393D2315841333333330361244100000020D531584166666666EE602441CDCCCC4CD8315841CDCCCCCCE060244133333333DA31584100000000D3602441CDCCCCECDB31584100000000BF6024419A999919DE31584100000000B460244133333393E031584100000000B26024419A999959E231584166666666B2602441666666A6E3315841CDCCCCCCB5602441333333B3E531584133333333B16024419A9999D9E631584166666666A160244100000000E7315841000000009560244133333353E73158410000000091602441CDCCCC4CE83158419A999999916024419A9999B9EA315841000000008C602441CDCCCC8CEC315841000000008260244133333353ED315841CDCCCCCC7760244133333313EE315841CDCCCCCC6F602441333333F3EF31584133333333736024419A999959F1315841000000007B6024419A9999B9F23158419A9999997F602441CDCCCC6CF3315841CDCCCCCC836024419A999919F43158416666666687602441666666E6F43158419A9999998A6024419A999939F63158419A99999989602441CDCCCC2CF7315841CDCCCCCC86602441CDCCCC2CF83158419A9999997F60244133333313FA315841CDCCCCCC7C60244166666626FC315841CDCCCCCC7C602441333333D3FC3158410000000083602441000000A0FD315841333333338B60244100000040FE315841666666668E602441333333F3FE315841333333338E6024419A9999D9FF31584166666666816024410000006001325841666666667B6024410000002002325841CDCCCCCC796024419A9999B902325841000000007A602441000000C004325841666666667D602441000000A006325841CDCCCCCC7F6024413333339308325841000000007B60244100000060093258419A99999979602441000000A00A325841666666667A6024419A9999190B325841666666667A602441CDCCCC2C0C325841CDCCCCCC75602441333333530C325841CDCCCCCC716024419A9999790C325841CDCCCCCC6E6024419A9999F90C3258419A999999706024419A9999390E325841CDCCCCCC75602441000000600F325841000000007E602441666666A6103258413333333380602441CDCCCC2C11325841CDCCCCCC7D6024419A99993912325841333333337B6024419A99991913325841CDCCCCCC71602441000000A013325841666666666C60244100000040133258419A999999666024419A9999B913325841CDCCCCCC656024410000002015325841CDCCCCCC65602441CDCCCC0C163258416666666665602441000000C0163258419A9999996160244133333313183258419A99999958602441000000A0193258410000000046602441333333931B3258416666666637602441666666661D3258416666666630602441666666661F32584133333333236024419A999919213258419A9999990E602441CDCCCC8C2432584133333333066024419A999919263258419A999999036024413333335327325841	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	01010000206A0800000EC5AD100890244166666626EB325841	120110000	Z	Arvieu	1201100	12011	12	76	50
01060000206A08000001000000010300000001000000B403000000000000854D23419A999959BB5758419A999999794D2341CDCCCC6CBB57584100000000694D2341666666E6BA575841CDCCCCCC584D2341666666A6BA57584100000000454D234133333393BA57584166666666364D2341000000A0BA57584100000000244D2341333333B3BA5758419A9999991B4D2341333333B3BA5758419A9999990F4D2341CDCCCC6CBA57584166666666FA4C23419A9999D9B857584166666666E74C2341CDCCCCECB657584100000000D44C2341CDCCCCECB457584166666666CB4C2341CDCCCC0CB35758419A999999C44C234100000080B157584100000000C14C2341333333D3B0575841CDCCCCCCBE4C234100000060AF57584100000000AD4C2341000000A0AD57584166666666A04C234133333353AB57584133333333994C2341CDCCCCACA957584100000000954C234166666666A8575841666666668E4C23419A9999F9A557584133333333844C234133333313A3575841000000007E4C2341CDCCCC8CA0575841000000007B4C2341333333739E5758419A999999754C2341666666269C57584100000000724C23419A9999799A575841666666666D4C2341CDCCCC4C985758419A999999664C23410000000097575841CDCCCCCC584C23419A9999D99557584133333333494C2341CDCCCC6C95575841333333333D4C2341000000409557584133333333374C23413333333395575841CDCCCCCC2D4C2341CDCCCC2C95575841000000001E4C2341000000409557584100000000104C2341CDCCCC6C9557584133333333014C2341000000809557584166666666F14B2341CDCCCC8C9557584166666666E14B2341000000A0955758419A999999D14B2341666666669557584166666666C24B234133333333955758419A999999B34B23416666664695575841CDCCCCCCA44B23419A9999599557584166666666984B234166666666955758419A9999998C4B234133333373955758419A999999824B2341CDCCCC6C9557584166666666724B23419A9999599557584133333333604B23419A99993995575841CDCCCCCC464B2341333333539557584133333333374B234100000060955758419A999999244B2341666666A69557584166666666164B23419A9999B9955758419A999999084B2341CDCCCCAC9557584166666666F64A2341000000609557584133333333E84A2341333333D394575841CDCCCCCCD94A2341333333939357584133333333D04A23416666662692575841CDCCCCCCC94A23413333333391575841CDCCCCCCC14A23419A9999D98F57584100000000BE4A2341CDCCCC8C8E575841CDCCCCCCB84A23419A9999198C57584133333333B54A2341333333138A575841CDCCCCCCB44A2341333333138857584133333333B44A2341333333F3855758419A999999B34A2341000000608357584100000000B34A2341333333138157584133333333B24A2341666666C67E57584166666666AD4A2341000000A07B5758419A999999A84A2341333333537A575841666666669F4A2341333333137857584133333333934A2341CDCCCC8C7657584166666666834A2341000000607557584133333333714A23416666666674575841CDCCCCCC5B4A23413333331374575841666666663F4A23419A9999B973575841333333332F4A2341CDCCCC8C7357584166666666174A23419A9999197357584133333333004A2341CDCCCC0C725758419A999999F1492341CDCCCC0C7157584100000000DB492341CDCCCCAC6F575841CDCCCCCCD0492341CDCCCCEC6E575841CDCCCCCCC4492341666666866D57584100000000B84923419A9999596C57584166666666A8492341666666866A575841CDCCCCCC9A4923419A99999967575841CDCCCCCC924923419A9999D9655758416666666687492341000000C0635758410000000083492341666666A661575841000000007E4923419A999979605758419A99999971492341666666C65F575841000000006B492341000000A05F5758416666666657492341666666E65E575841666666664A492341000000E05E57584133333333344923419A9999F95E575841CDCCCCCC25492341666666265F5758419A999999194923419A9999B977575841666666661A4923419A9999B981575841CDCCCCCC104923419A9999F9875758419A999999FD4823419A9999B99557584133333333ED48234133333333B857584133333333A3482341333333D3B257584100000000144823419A9999D9CA575841000000008847234100000060BF5758419A9999993147234133333373CD5758416666666652472341000000E0D5575841000000005E4723419A9999F9D6575841CDCCCCCCA9462341666666C6E857584100000000ED452341333333F3F75758419A9999990D442341CDCCCCCC1658584100000000D643234166666666115858410000000068432341666666261858584133333333E54223410000004029585841000000008E42234133333373335858410000000045422341333333534658584100000000B441234100000020625858419A99999929412341000000C063585841000000008E402341CDCCCCEC5F5858416666666660402341CDCCCC6C8B585841CDCCCCCC893F2341CDCCCC6C8B5858419A9999998F3F2341CDCCCC4C98585841CDCCCCCC533F23419A999959A2585841000000003E3F2341666666A6A2585841CDCCCCCC243F2341333333F3A2585841666666660F3F234133333353A35858419A999999FC3E23419A999919A458584100000000E63E2341666666A6A558584100000000D73E23419A9999F9A558584133333333C73E234100000000A858584100000000C23E2341333333F3A858584100000000AC3E234133333313AA5858419A999999903E234133333373AB585841333333337D3E2341666666C6AD585841000000006C3E23419A9999F9AF58584133333333503E2341333333B3B358584100000000373E2341333333B3B758584133333333303E23419A9999F9B958584166666666303E2341CDCCCCACBB5858419A999999233E234100000000BC5858419A9999991B3E2341666666C6BC58584133333333093E234133333333BF58584100000000E23D234166666686C358584133333333D53D2341333333B3C458584100000000CB3D234133333353C558584133333333B93D2341CDCCCC6CC658584166666666933D234166666686C8585841333333337D3D234166666626CA58584133333333723D234133333333CB58584100000000743C2341CDCCCC4CD0585841666666665F3C234133333393C758584166666666783B2341CDCCCC2CCA58584166666666893B2341000000C0CF58584166666666843B2341333333B3D558584100000000983B2341333333D3D9585841333333335D3B234166666686E7585841666666663D3B234133333353EF58584100000000343B234133333393F5585841000000004D3B234100000040F958584166666666633B2341333333B3FB585841CDCCCCCC7C3B23419A999959005958419A9999997F3B23419A9999D9065958419A999999783B2341333333B30D595841333333336F3B2341666666261559584133333333863B2341CDCCCCCC1D59584166666666903B234133333313235958419A999999893B2341666666062D595841333333338E3B234133333353315958419A9999993C3B23413333335338595841CDCCCCCC5E3B2341000000A05F595841666666668E3A2341CDCCCCAC7E59584133333333C93A2341333333D3845958419A9999990C3B2341000000808C595841CDCCCCCC403B2341CDCCCC0C925958419A999999563B234166666646945958419A9999997A3B23413333331397595841CDCCCCCCC63B2341CDCCCC0C9C59584166666666FB3B2341CDCCCC8C9F59584133333333183C23419A999999A1595841666666662C3C234100000040A3595841CDCCCCCC5C3C234100000020A85958419A999999953C234100000060AE59584100000000DF3C234133333313B659584100000000273D234100000080BE595841CDCCCCCC3F3D23419A9999F9C159584166666666533D234166666626C559584166666666703D234100000040CA595841CDCCCCCC963D234133333373D1595841CDCCCCCCBF3D23419A999979D959584100000000F13D23419A999939E25958419A999999073E2341000000C0E65958419A999999213E2341333333F3EA59584166666666483E23419A999959F059584133333333773E234100000040F759584100000000B23E234133333353005A58419A999999DA3E2341CDCCCCCC075A5841CDCCCCCCFC3E2341000000400D5A584166666666283F23419A999999125A584133333333463F23419A999999155A584100000000523F234166666626165A58419A999999583F23419A999979165A58419A999999633F2341CDCCCC6C165A584133333333873F234166666666155A5841CDCCCCCC8E3F23419A999959325A5841000000005E3F234166666666415A58419A999999543F2341666666264A5A5841000000007B3F234100000040625A58419A999999B23F234133333333625A584166666666294023419A999959735A5841666666661B402341CDCCCCAC825A58416666666644402341CDCCCCEC865A5841CDCCCCCC834023419A9999D9985A584133333333E9402341666666A6945A5841333333336A412341666666C6815A584166666666C5412341333333738C5A58410000000094412341333333B3A45A5841000000000A4223419A999979A95A58419A999999FC4023419A999999C75A584166666666C5402341666666E6D35A5841CDCCCCCCB740234133333373D85A584100000000C640234166666606DD5A584133333333D7402341666666E6E15A584100000000CF4023419A999919E65A584166666666B040234166666646E95A58410000000057402341666666C6EA5A584166666666943E2341333333F3EB5A584100000000493E2341666666C6ED5A5841666666667D3D2341333333D3F85A5841CDCCCCCC5B3D23419A999999FA5A5841666666661E3D2341CDCCCCACFA5A584166666666BC3C234166666646FE5A5841333333337F3C2341CDCCCC8C025B58419A999999553C23419A9999D9075B584100000000373C234166666646095B584133333333B03B2341CDCCCC2C045B58419A999999FF3A234100000060FE5A58419A9999992B3B2341CDCCCC2CF45A58419A999999463B2341CDCCCC6CE85A5841000000007C3B23419A999999C95A58419A999999613B23419A999919C35A584133333333F23A2341000000E0AA5A584133333333BF3A2341CDCCCC6C955A584100000000683A2341CDCCCC2C805A5841CDCCCCCC273A234133333373795A5841CDCCCCCCF4392341CDCCCC0C825A5841333333338F39234133333313935A58419A9999995D392341000000A0885A58419A999999F3382341666666A6915A5841666666669B37234133333333AC5A58419A9999993F372341666666E6BF5A58419A9999993D372341CDCCCCACC25A58419A999999273723419A999939C65A5841CDCCCCCC5D3623419A999939DD5A584133333333793623419A999959045B5841CDCCCCCC0037234166666626175B58419A999999F236234133333393225B5841CDCCCCCCCE36234100000060265B58419A99999973362341CDCCCCCC275B5841666666665A3623419A9999992D5B58416666666691342341333333931C5B58416666666655342341666666661B5B5841666666664B342341666666A61C5B584166666666C0332341CDCCCC0C285B58416666666670332341000000E0265B58416666666602332341000000C0255B58419A999999D0322341CDCCCC4C285B5841CDCCCCCC9B3123419A999919355B58416666666638312341333333B33C5B584166666666903023419A999979505B58419A9999999830234100000080575B5841666666669F3023419A9999F95C5B584133333333A030234166666686605B5841CDCCCCCC9C3023419A9999B9635B58416666666694302341333333F3675B58413333333369302341CDCCCC2C795B5841CDCCCCCC4D30234166666626845B584100000000DE2F2341333333D3805B584166666666BC2F234133333313AC5B5841666666662C2F2341333333F3AB5B5841CDCCCCCC242F2341333333B3BA5B5841666666663D2F23419A999939C65B58419A999999AE2F234133333353E35B584166666666B92F234100000060ED5B5841CDCCCCCCAF2F234133333353F05B58419A999999A62F23419A999999F25B5841CDCCCCCC9B2F2341666666A6F45B5841CDCCCCCC932F2341CDCCCC2CF65B58419A999999E72D234133333333D75B584100000000952D2341666666C6CF5B5841CDCCCCCC452D23419A999999D85B584100000000462D23419A999999DC5B5841666666668C2D2341666666C6E25B58419A9999998C2D234166666646E55B58419A999999822D234166666646E55B5841000000001F2D234100000060EA5B584133333333F72C2341CDCCCCECEC5B584166666666F72C2341CDCCCCACF05B584133333333202D23419A9999D9FB5B584166666666C42D234133333373F95B5841CDCCCCCC2C2E2341333333B3FB5B58419A999999332E234133333353FF5B5841333333333C2E2341CDCCCCEC035C5841CDCCCCCC4B2E23419A9999B90C5C584133333333552E2341CDCCCCAC125C5841000000005A2E234166666646175C5841666666665B2E2341CDCCCC8C1B5C58419A999999582E2341666666861F5C584166666666542E234133333353235C584133333333502E2341000000C0265C584166666666492E2341000000A0295C5841CDCCCCCC3F2E2341000000A02B5C584166666666272E2341666666662D5C584166666666022E23419A9999392F5C584133333333E62D23419A9999392F5C5841CDCCCCCCD82D2341666666A62E5C5841000000008B2D2341CDCCCC6C455C58419A999999C82D23419A9999595E5C584166666666832D2341666666A6695C58419A999999B02C2341CDCCCC8C925C584100000000B92B2341000000C0A85C584100000000772B2341333333D3B25C584133333333622B23419A9999F9B15C58419A999999532B234166666606B25C5841CDCCCCCC442B2341CDCCCCACB25C584100000000392B234166666626B45C584100000000332B234133333393B65C5841CDCCCCCC322B2341CDCCCC0CB95C5841CDCCCCCC352B23419A9999D9BC5C584166666666382B2341666666E6C15C5841CDCCCCCC362B234166666686C65C58419A9999992F2B234100000020CB5C584166666666232B234166666646CE5C584133333333102B234133333373D15C584100000000F92A234100000060D35C584166666666DF2A2341CDCCCC0CD45C58419A999999C02A234133333393D35C5841666666669B2A2341CDCCCC4CD25C58419A999999812A23419A999919D25C584166666666832A2341CDCCCC2CD35C584166666666852A234100000040D45C58419A9999999C2A2341CDCCCC6CE65C584100000000562A234133333333E85C58419A999999712A2341000000C0F55C5841CDCCCCCC892A2341333333330A5D584100000000962A23419A9999D9155D584100000000B52A2341000000201E5D584100000000D02A23419A999919235D584166666666002B2341666666862D5D5841CDCCCCCC5C2B2341CDCCCC4C3C5D584133333333B22B2341CDCCCCAC445D5841CDCCCCCCBF2B23419A999939425D584133333333D92B2341666666A63D5D584133333333FC2B2341666666E6375D584166666666852C234133333333255D5841000000009F2C2341333333B3215D58419A999999B62C23419A9999D91D5D5841CDCCCCCCBA2C2341CDCCCC2C1D5D5841CDCCCCCCDB2C2341CDCCCC0C185D5841666666661D2D234133333313105D584100000000692D2341666666C6085D584133333333AF2D2341CDCCCC0CFE5C58419A999999EF2D23419A999919F05C584100000000412E2341333333F3DC5C58419A999999712E234166666646CE5C5841000000009D2E2341CDCCCCCCC35C58419A999999D32E234100000080B85C5841CDCCCCCCEA2E2341CDCCCC8CB45C584133333333F82E2341666666C6B25C584166666666002F2341666666A6B15C5841333333331A2F234100000080AE5C584166666666312F23419A9999B9AB5C5841000000004D2F234133333393A85C584100000000872F2341CDCCCCECA35C584100000000B82F2341666666469F5C584133333333E62F2341333333F39B5C5841CDCCCCCC3F302341CDCCCC8C955C5841CDCCCCCCD03023419A9999B98C5C5841666666664E312341000000A0895C584166666666D6312341000000E0875C5841000000005E322341CDCCCC8C855C5841CDCCCCCCC432234100000000855C58419A9999993F33234133333333855C584166666666CE332341333333B3855C58419A999999E2332341666666C6855C5841666666665C34234166666666865C58419A999999D9342341CDCCCCCC875C58410000000072352341333333B3895C5841CDCCCCCCED3523419A9999D98C5C58419A9999995C362341000000C08F5C58419A999999C5362341CDCCCC0C965C5841333333338F372341CDCCCC8CA15C5841666666666D3823419A9999B9B25C5841CDCCCCCC95382341CDCCCC4CB55C58419A9999999A382341CDCCCCACB55C5841CDCCCCCCED382341000000A0BB5C5841CDCCCCCCF6382341CDCCCCACBC5C584100000000C339234133333353D65C58419A999999FE392341000000C0DF5C5841000000005C3A2341666666E6F05C584133333333C03A23419A9999F9045D584133333333083B2341CDCCCC6C125D584100000000733B234100000040245D584133333333B33B2341666666E6305D584100000000EF3B2341666666C63B5D5841666666661D3C2341CDCCCCEC435D584166666666553C23419A9999794C5D5841CDCCCCCC693C23419A9999B94E5D58419A999999A23C234133333373545D584166666666E23C2341CDCCCC6C595D5841000000001D3D23419A9999F95C5D5841CDCCCCCC4C3D2341CDCCCCCC5F5D5841666666667F3D234100000000625D584133333333B43D234133333313635D584133333333E63D2341333333D3635D584133333333233E2341CDCCCCCC635D5841000000005F3E234100000020635D58419A999999933E23419A9999D9615D584100000000C73E2341000000A05F5D5841CDCCCCCCFC3E2341000000405B5D5841333333331A3F234100000080585D5841000000003E3F23419A999959535D584133333333583F23419A9999F94F5D584133333333773F23419A9999F94A5D58419A999999903F234133333313465D584133333333AD3F2341333333533F5D584100000000C43F2341000000A0385D584166666666E03F234166666686305D584166666666FE3F2341000000A0265D584133333333184023419A9999F91D5D58410000000035402341333333B3115D58419A99999957402341333333D3035D58419A99999976402341000000E0F85C584133333333964023419A999919EC5C584100000000A4402341CDCCCC8CDE5C5841CDCCCCCCB840234100000060D35C58419A999999BC40234100000000D15C5841333333330741234133333373A45C58419A99999934412341000000C0935C5841CDCCCCCC52412341CDCCCC6C835C58413333333389412341CDCCCC8C715C5841CDCCCCCCAB41234166666606695C584166666666D1412341CDCCCC4C615C584100000000FA412341333333F35A5C5841000000002942234133333333565C58419A9999995642234166666646535C5841CDCCCCCC9142234166666686505C584166666666BC422341000000804F5C584133333333F54223419A9999394F5C58419A9999992C43234100000040505C5841333333336F432341333333B3515C584166666666C34323419A9999D9555C584133333333144423419A9999B95B5C58410000000061442341CDCCCC2C625C58419A999999AE44234100000020695C584166666666F3442341CDCCCCAC6E5C58410000000090452341CDCCCCCC795C5841333333331846234166666606825C58410000000045462341CDCCCC4C845C5841CDCCCCCC794623419A999959865C584100000000B246234166666626885C5841CDCCCCCCF04623419A9999B9895C58419A9999992D472341CDCCCC8C8A5C5841333333337F4723419A9999598A5C58419A999999C247234166666686895C58419A999999D547234166666606895C5841CDCCCCCC1948234100000040875C5841CDCCCCCC85482341333333F3835C5841CDCCCCCC004923419A9999B97F5C5841000000003B492341000000607D5C58413333333387492341CDCCCC4C7A5C58419A999999064A2341CDCCCCEC755C584166666666664A234166666606725C584133333333B94A2341CDCCCC4C6D5C584166666666144B234166666646695C584133333333564B234133333373675C584133333333A54B23419A999959665C584100000000BC4B234166666666665C584100000000EE4B234100000080665C58419A999999F84B2341000000A0665C5841CDCCCCCC394C234133333353675C58419A9999995C4C234100000000685C584166666666834C23419A9999B9685C5841CDCCCCCCD34C2341000000606C5C584166666666AB4D2341666666C6745C5841CDCCCCCCB54E234133333393805C58419A999999124F2341000000E0835C584166666666404F2341333333736B5C584100000000334F2341000000C0605C584133333333364F23419A9999F95E5C58419A999999354F23419A9999395D5C5841CDCCCCCC2E4F2341CDCCCC8C5A5C5841000000002A4F234166666646585C5841000000002A4F23419A999919555C5841666666662F4F2341333333D3525C5841CDCCCCCC354F2341CDCCCC6C515C5841CDCCCCCC394F2341333333F34F5C58419A999999404F23419A9999794A5C5841000000003F4F23419A999939475C5841333333333E4F234100000060455C58419A999999404F234133333373425C5841333333334C4F2341000000C03A5C584166666666504F2341333333B3375C584100000000584F2341000000E0335C58419A999999594F234100000020315C584166666666AA4F2341333333D3315C58419A999999AD4F2341333333D32B5C584166666666CE4F2341333333732A5C58410000000007502341000000E0285C5841CDCCCCCC1550234133333393235C58413333333321502341CDCCCCAC205C58416666666627502341000000C01D5C58419A9999992B502341000000C0185C58419A9999992C502341333333F3155C5841CDCCCCCC29502341000000000D5C58413333333329502341666666C60C5C58410000000028502341666666A6025C58419A9999992850234100000000FB5B5841CDCCCCCC2A50234166666626F85B5841CDCCCCCC31502341000000E0F35B58419A999999405023419A9999B9EE5B584100000000525023419A9999F9E85B5841000000005D50234100000040E55B5841000000005F50234133333333E45B58419A9999995E5023419A999939E25B58419A9999995A502341333333B3DC5B5841333333338150234166666666DA5B58419A9999990C51234100000000D45B5841666666667551234166666626C35B5841000000007B512341CDCCCCACC25B5841333333338D51234166666626C15B58419A9999992152234100000080AA5B584166666666515223419A9999798C5B58419A999999C352234133333333375B5841333333339A522341666666C6205B58419A99999985522341CDCCCC0C185B584100000000AD522341000000400F5B584100000000B7522341000000400F5B5841CDCCCCCCB6522341000000C00C5B5841666666662D532341666666A6F85A58413333333390532341CDCCCC8CE95A584100000000CC53234100000040E85A5841CDCCCCCC3355234100000060EA5A5841CDCCCCCC0456234166666666DC5A584166666666F3562341CDCCCCACCA5A5841CDCCCCCCEC572341CDCCCCACC65A58419A9999994F58234133333353B65A5841666666667A58234133333393AB5A58410000000081582341CDCCCC0CAC5A584133333333A05823419A9999B9AD5A584100000000B9582341333333D3AE5A584100000000C7582341CDCCCC6CAF5A5841CDCCCCCCE65823419A999939B15A5841CDCCCCCCFB5823419A9999D9B25A5841000000001B5923419A9999B9B55A58419A9999992F592341666666C6B75A5841CDCCCCCC3F5923419A999999B95A58419A999999555923419A999979BC5A584133333333665923419A999959BE5A58413333333377592341666666C6BF5A5841666666668559234133333373C05A58413333333390592341000000C0C05A584100000000A459234100000020C15A584133333333D05923419A9999B9C15A5841666666660E5A234166666626C25A5841CDCCCCCC515A23419A999919C25A5841CDCCCCCC835A23419A999939C25A584166666666975A2341CDCCCC0CC25A584166666666A65A2341000000C0C15A584100000000CB5A2341CDCCCC0CC15A5841CDCCCCCCE05A23419A9999D9C05A584166666666F05A23419A9999D9C05A5841333333333B5B234166666626C15A58419A999999635B2341CDCCCC8CC15A5841CDCCCCCC955B23419A999919C25A584133333333BC5B23419A9999B9C25A58419A999999D95B234100000060C35A58419A999999EA5B23419A9999D9C35A58419A999999F85B234133333373C45A58419A9999990E5C23419A999999C55A584166666666385C23419A9999B9C75A5841666666666A5C234133333393C95A5841666666666A5C23419A9999B9D35A584133333333E25B2341000000E0DB5A584133333333795B23419A999939E25A584166666666235B2341CDCCCC2CE75A5841CDCCCCCCDD5A234133333313EB5A584166666666CB5A234133333393EB5A58419A999999BB5A23419A9999F9EB5A584133333333AF5A234133333333EC5A5841CDCCCCCCA35A234166666626FE5A584100000000745A2341666666661D5B584133333333105A2341000000002D5B584166666666005A23419A999999335B584166666666F4592341333333F33B5B584133333333F6592341666666C6465B5841CDCCCCCCFC592341CDCCCC8C525B5841CDCCCCCC0B5A23419A9999B95F5B584166666666325A2341CDCCCC2C735B58419A9999995C5A234166666666815B58419A9999998E5A2341000000A08B5B584166666666B65A2341333333D3915B584100000000D25A23419A999999965B584133333333F15A23419A9999B9A05B584166666666F55A234133333373A35B58419A999999025B2341666666E6AB5B5841666666661B5B23419A9999D9B25B58419A999999305B2341333333F3B85B584133333333405B234166666666BB5B58419A9999996F5B234100000040C15B5841CDCCCCCC865B23419A9999F9C55B58419A9999999C5B2341CDCCCC0CCE5B584166666666C05B2341000000E0DC5B584100000000D25B2341666666C6E85B5841CDCCCCCCCE5B23419A999959F15B5841CDCCCCCCCC5B234100000040F85B5841CDCCCCCCDB5B2341333333F3005C584166666666DF5B2341333333D3025C584100000000F95B23419A9999790F5C584166666666115C23419A9999191A5C584166666666165C2341333333531C5C584133333333155C2341CDCCCCCC1F5C584166666666165C2341CDCCCCCC225C58419A9999991D5C23419A9999F9255C58419A999999315C23419A9999392B5C58419A999999335C2341666666E62C5C584166666666765C2341666666A6285C584133333333845C2341CDCCCC8C275C584100000000BF5C234133333353245C5841CDCCCCCCE65C234133333333235C584133333333FA5C234166666666225C58419A999999135D2341CDCCCC4C205C58419A999999235D2341666666C61E5C584100000000455D2341666666461D5C5841CDCCCCCC665D23419A9999591B5C58419A999999715D2341000000201B5C5841CDCCCCCC895D23419A9999B91A5C58419A999999AA5D2341666666E6195C5841CDCCCCCCDD5D23419A999919165C5841CDCCCCCC125E23419A999939125C584133333333555E2341666666A60D5C5841333333336C5E2341000000C00C5C5841000000009C5E234133333373085C584166666666DA5E2341000000C0035C584100000000185F23419A9999B9FE5B584133333333615F2341CDCCCC6CF85B584166666666965F2341333333F3F15B584166666666C55F2341CDCCCCACEA5B584166666666C85F234133333353EA5B5841CDCCCCCCFC5F2341000000E0E35B5841CDCCCCCC35602341000000E0DF5B5841666666667160234133333333DC5B584100000000C2602341000000E0D75B58419A999999D0602341333333B3D75B5841CDCCCCCCF2602341666666C6D45B5841000000002A61234166666686D05B5841000000003961234133333313CF5B58419A9999993C612341CDCCCCACCD5B5841000000004561234100000020CC5B58419A9999995F612341CDCCCC8CCB5B58419A999999906123419A999939C85B5841CDCCCCCC9D612341CDCCCCECC55B5841CDCCCCCCA8612341CDCCCC4CC45B58419A999999E16123419A9999B9BF5B5841CDCCCCCC1062234100000040BD5B5841000000002A62234166666606BD5B5841CDCCCCCC44622341CDCCCC6CBE5B5841000000006262234133333313BF5B5841000000007C62234100000040BF5B584133333333906223419A999959BF5B58419A999999AC6223419A999979C15B58419A999999C362234100000020C35B584133333333DD622341CDCCCC0CC35B5841000000000A63234133333333C25B584100000000336323419A9999F9BF5B5841CDCCCCCC59632341CDCCCC8CBC5B5841000000007F632341333333F3B65B584100000000966323419A999999B05B584166666666A763234100000040AA5B584100000000B363234166666626A45B584166666666B6632341CDCCCC2C9E5B584133333333BD6323419A9999D9955B58419A999999BD632341000000C0955B584133333333C863234166666606905B5841CDCCCCCCD1632341000000008B5B584166666666D8632341CDCCCC4C855B584100000000DD632341333333137E5B584133333333E2632341000000A0775B584166666666E7632341666666A6745B584133333333E6632341CDCCCC2C715B584166666666DA632341666666A66B5B584166666666D463234166666626655B58419A999999D66323419A9999795C5B58410000000057642341333333B3515B5841333333339D6523419A9999B9405B5841000000008E652341CDCCCCAC3E5B58413333333375652341000000E03B5B5841CDCCCCCC5B6523419A9999F9385B5841000000004B65234133333313375B5841000000002B6523419A9999B9335B584100000000EE6423419A9999F92D5B584133333333D0642341CDCCCC4C2B5B5841CDCCCCCCB664234100000020295B5841000000009B64234100000060275B58419A99999978642341666666C6255B5841000000005264234100000060245B58416666666622642341666666C6225B584166666666EF6323419A999939205B584133333333ED63234100000020205B58419A999999C6632341CDCCCC0C1E5B58419A99999998632341CDCCCCEC1B5B58416666666676632341666666061A5B584100000000586323419A999919185B58413333333337632341CDCCCCEC155B5841CDCCCCCC17632341333333D3135B584100000000FB622341333333B3115B58419A999999DF622341000000400F5B5841CDCCCCCCBE6223419A9999790C5B584166666666A66223419A9999F90A5B5841000000008F622341000000C0095B58416666666675622341666666E6085B58413333333360622341CDCCCCAC085B5841333333335662234133333393085B5841CDCCCCCC1D6223419A999979085B584166666666EA61234133333313085B5841CDCCCCCCCA61234100000020075B584133333333B46123419A9999F9055B58419A9999999561234133333373045B5841000000006661234166666606015B5841000000003E612341000000E0FD5A584166666666FD602341CDCCCCCCF75A5841CDCCCCCCD7602341CDCCCC2CF45A584100000000B260234166666666F05A584133333333A86023419A999959EF5A5841CDCCCCCC826023419A999979EB5A5841333333335F6023419A9999B9E85A58419A9999994160234100000000E75A58419A9999993A6023419A999999E65A5841CDCCCCCC1C602341CDCCCCECE45A5841CDCCCCCCE15F234133333353E25A584133333333A35F234133333373DF5A58419A9999998B5F234133333333DE5A5841CDCCCCCC7A5F234133333353DC5A5841CDCCCCCC695F2341333333B3D95A5841000000005E5F2341333333B3D75A58419A999999525F2341CDCCCCACD45A5841000000004A5F2341000000C0D15A584166666666405F2341CDCCCC4CCD5A584133333333385F23419A9999F9C85A5841666666662A5F23419A999979C15A584133333333205F2341CDCCCC0CBC5A584166666666155F2341CDCCCCACB75A5841666666660F5F2341CDCCCC2CB55A584133333333075F2341333333D3B25A584166666666FA5E2341CDCCCCACAF5A584133333333EA5E2341000000C0AB5A5841CDCCCCCCDC5E2341666666E6A85A584133333333045E2341CDCCCC4CB75A584166666666DE5D234166666646B85A584166666666D25D23419A999999B85A584100000000BC5D234166666666B65A584133333333A85D234133333373B45A584133333333A05D2341666666A6B35A584166666666095D234133333353A75A584100000000E15C2341666666E6A45A5841CDCCCCCC825C2341666666469F5A58419A9999994E5C2341000000009B5A584133333333205C23419A999959955A584133333333075C234133333353925A58419A999999F55B2341CDCCCCEC905A5841CDCCCCCCE35B234133333373905A584133333333D15B2341666666668F5A5841CDCCCCCCBA5B2341000000808E5A584100000000A25B2341333333938C5A58419A999999895B23419A9999798B5A58419A999999785B2341666666068B5A5841666666665A5B2341000000A08A5A584100000000415B2341CDCCCC8C8A5A58419A999999365B2341333333D38A5A584100000000535A2341000000E08C5A584133333333315A2341000000208D5A584100000000F8592341666666068E5A58419A999999E3592341CDCCCC4C8E5A5841CDCCCCCCCE592341333333D38E5A584100000000A9592341CDCCCC0C905A5841000000008C59234133333353905A584133333333765923419A9999F98F5A5841333333334C5923419A9999198F5A5841333333333B5923419A9999398F5A58419A99999902592341333333F38F5A5841CDCCCCCCD5582341CDCCCC6C905A5841CDCCCCCCBF582341666666C6905A584133333333AF582341000000E0905A584133333333A0582341CDCCCC8C905A58410000000092582341333333D38F5A58419A99999976582341666666E68D5A5841666666666D5823419A9999D98C5A58416666666662582341333333738B5A5841CDCCCCCC55582341000000408A5A58413333333346582341CDCCCC4C885A58419A9999993858234133333393875A58419A999999245823419A999979845A5841666666660C582341666666067F5A5841CDCCCCCCF1572341000000A0785A58419A999999DB572341666666C6715A584100000000DA57234100000060715A5841CDCCCCCCD557234133333313705A584166666666CD572341CDCCCC8C6D5A5841CDCCCCCCB7572341CDCCCC6C685A584100000000A5572341333333B3635A584100000000945723419A9999195F5A58416666666691572341333333735E5A58410000000091572341CDCCCC4C5E5A5841CDCCCCCC85572341333333335B5A5841000000007C57234166666606595A5841666666666A572341CDCCCC2C575A5841666666662F572341CDCCCC4C505A5841333333330857234100000020475A5841CDCCCCCCD7562341CDCCCC4C3C5A584133333333AB56234100000020325A5841CDCCCCCC89562341CDCCCC4C2C5A5841333333333956234100000000235A58419A99999917562341000000401F5A58419A999999FD5523419A9999B91D5A584133333333D655234166666686175A584133333333BB55234100000040135A584133333333BA552341666666260E5A5841CDCCCCCCAE552341333333D3095A58419A999999A15523419A999939055A58413333333383552341333333F3FD5958419A999999565523419A999999F5595841333333335A55234100000040EF595841666666665D552341333333D3E9595841666666664D552341666666C6E2595841CDCCCCCC33552341333333B3DF59584166666666E3542341CDCCCC4CD9595841CDCCCCCCC654234133333373D459584133333333BE5423419A999979CF5958419A999999A654234100000080C8595841666666668C542341333333F3C2595841333333337F54234133333353C15958419A99999963542341000000C0BE595841333333331354234133333333BB59584166666666B2532341CDCCCCACB9595841CDCCCCCC405323419A9999B9B7595841666666660553234166666626B559584100000000CB52234166666686B1595841CDCCCCCCBC522341000000A0B0595841333333339B522341666666C6AD5958419A99999985522341333333B3AC5958413333333360522341333333F3AA59584166666666385223419A9999D9A95958419A9999992852234166666626A9595841CDCCCCCC15522341333333D3A65958419A999999105223419A9999D9A55958419A9999990352234100000060A359584100000000F351234166666666A059584100000000E1512341000000409C595841CDCCCCCCD6512341666666A69A5958419A99999940512341000000608A595841333333333551234100000000895958419A99999924512341000000C0835958419A999999F6502341333333B379595841CDCCCCCCBB5023416666660672595841333333339E5023419A9999396D595841333333338A5023416666668665595841CDCCCCCC89502341000000E06159584100000000AA502341666666C65B59584166666666B3502341333333535759584166666666A9502341333333D3505958413333333392502341666666664C5958413333333378502341666666664A5958419A99999947502341666666A64959584100000000345023413333337348595841000000002A50234100000000445958419A999999295023419A9999593E595841CDCCCCCC3C502341CDCCCCAC3A595841666666664950234133333333365958416666666635502341333333B32D59584133333333FE4F2341666666862A59584100000000A64F2341000000802259584166666666854F2341000000801E595841000000006B4F23419A9999D91859584133333333264F2341CDCCCC2C0F59584100000000E54E2341CDCCCC8C07595841CDCCCCCCBD4E2341CDCCCC8C0359584100000000B74E23419A999919FF58584100000000BA4E234100000040FA58584100000000BE4E234100000000F8585841CDCCCCCCBD4E23419A9999F9F458584133333333A94E23419A999979ED585841CDCCCCCC964E23419A9999F9E6585841333333338C4E2341333333B3DE585841CDCCCCCC8B4E2341CDCCCCECD758584100000000794E2341CDCCCC6CD05858419A999999684E2341CDCCCC2CC9585841CDCCCCCC634E234166666666BE58584166666666774E23419A999919B858584100000000834E2341CDCCCC4CAE58584133333333774E234133333353A8585841CDCCCCCC6E4E2341666666E6A5585841333333336C4E2341000000E0A4585841333333336C4E2341333333B3A1585841CDCCCCCC694E2341666666669F5858419A999999604E2341333333539B585841CDCCCCCC534E23416666664698585841333333334C4E23419A9999199758584133333333454E234166666686945858419A999999184E23419A9999999158584100000000084E2341333333538D585841CDCCCCCC034E2341333333D3895858419A9999990F4E2341CDCCCC0C88585841666666660D4E2341CDCCCCCC84585841000000000B4E2341CDCCCC0C7F585841CDCCCCCC0E4E2341666666867A5858419A999999244E23419A9999397558584166666666364E2341CDCCCCEC71585841CDCCCCCC494E2341666666666758584166666666554E2341000000A06158584133333333774E2341333333935B58584100000000A54E23410000000057585841CDCCCCCCA84E23419A99997953585841CDCCCCCCCD4E2341666666664458584166666666DD4E23419A9999993C58584100000000DF4E2341333333D33558584166666666C64E23419A99995931585841000000009E4E2341000000202B5858419A999999854E23410000002025585841CDCCCCCC684E2341000000601B58584100000000504E2341000000A014585841666666662D4E2341CDCCCCCC0F585841000000001D4E2341000000000A58584166666666154E234166666626085858419A999999FD4D2341333333F30258584166666666ED4D234166666646FD57584133333333E44D2341CDCCCC6CF95758419A999999E04D234100000000F75758419A999999E24D2341333333F3F3575841CDCCCCCCF24D23419A9999F9EE57584133333333044E2341CDCCCCECEC575841CDCCCCCC094E2341666666C6EA575841CDCCCCCC0D4E2341000000E0E557584133333333084E2341333333F3E35758419A999999F54D2341666666C6DD57584166666666ED4D234166666606D457584100000000EA4D2341333333D3CE57584100000000EE4D2341333333B3CC57584166666666F14D234100000040CA57584100000000EF4D2341CDCCCCACC8575841CDCCCCCCD34D23419A999959C557584166666666AC4D2341CDCCCC4CC157584100000000854D23419A999959BB575841	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	01010000206A080000AEA5E516894B2341666666A6605A5841	120120000	Z	Asprières	1201200	12012	12	76	17
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	01010000206A08000023E98CD58B872341CCCCCC2C03585841	120130000	Z	Aubin	1201300	12013	12	76	27
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	01010000206A080000CA409148D95E24419A999949A42D5841	120150000	Z	Auriac-Lagast	1201500	12015	12	76	31
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	01010000206A08000038C954B1E7AE2341CCCCCC0C1F545841	120160000	Z	Auzits	1201600	12016	12	76	24
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	01010000206A0800009A4B58625EC324419A9999C91D285841	120170000	Z	Ayssènes	1201700	12017	12	76	23
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	01010000206A080000B410AE60DCDF224100000040F5565841	120180000	Z	Balaguier-d'Olt	1201800	12018	12	76	11
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	01010000206A08000084E450D6605024419A999929CC125841	120190000	Z	Balaguier-sur-Rance	1201900	12019	12	76	10
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