SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep15;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep15 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep15','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep15','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep15','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep15"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800000857B0A1173B2541000000706AA35841	150010000	Z	Allanche	1500100	15001	15	84	51
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	01010000206A0800006BB9CE008094254100000030BE855841	150020000	Z	Alleuze	1500200	15002	15	84	26
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	01060000206A0800000100000001030000000100000024030000CDCCCCCC83A8234133333353A79C58413333333388A8234133333313AE9C5841CDCCCCCCB4A8234100000080B89C58419A9999990EA92341666666C6B39C58416666666657A92341000000E0C59C58419A999999C2A9234133333353C59C584166666666A1AA23419A999959F09C58416666666617AC2341333333D3059D58416666666621AC23419A999979EE9C5841CDCCCCCC74AC234133333333F29C5841333333339EAC234133333313C89C5841CDCCCCCCFCAC23419A999999CC9C584100000000C6AC234100000000E99C584133333333ADAD23419A999999E19C58419A99999973AD234133333353089D584166666666CDAC234166666646059D5841CDCCCCCCD6AC23419A9999D9239D58410000000033AE234133333373349D5841CDCCCCCC02AE23419A9999394F9D584100000000DFAD2341000000C0659D5841CDCCCCCCCFAD234166666626779D58410000000038AE234133333393719D58419A999999FCAE2341333333536D9D58413333333310AF23419A999939769D58419A9999996EAE234166666686809D5841CDCCCCCC85AE23419A9999F9899D5841CDCCCCCCEEAE234133333333829D5841CDCCCCCCAAAF23419A9999B9939D5841333333331EB0234100000060A69D58419A99999926B0234100000060C79D5841CDCCCCCC38B023419A999979D19D5841666666665AB02341333333D3DC9D58413333333388B02341CDCCCC0CE99D5841CDCCCCCC91B02341CDCCCCCCEE9D58410000000074B0234100000040FD9D58419A9999992BB1234100000000FE9D58413333333382B1234100000000F99D584166666666D1B123419A999999059E58413333333382B023419A999959179E58413333333328B12341666666A61C9E58410000000061B12341CDCCCC8C2B9E58416666666611B1234166666666359E58419A999999B8B02341CDCCCC2C3E9E5841666666664FB02341000000A0469E5841666666662BB0234100000020489E58419A999999A8B02341333333B35F9E58410000000051B12341666666C6519E58419A999999BBB1234166666686519E584100000000EDB12341CDCCCCEC579E58416666666646B2234133333393559E5841CDCCCCCC8AB22341666666C6609E584133333333DEB22341333333D35D9E584100000000FDB22341CDCCCC8C629E58419A99999944B22341333333B36C9E5841666666661DB2234133333373659E584166666666B0B1234166666606659E5841CDCCCCCC8DB123419A9999F96F9E5841CDCCCCCCFDB0234166666666719E584100000000D7B023419A9999B97F9E58413333333301B123419A999979909E58419A999999CBB023419A999999939E58419A99999959B023419A999919939E5841666666669CAF2341000000A0829E58419A99999963AF23419A9999597E9E584133333333ECAE234133333333879E584100000000C5AE234100000000909E584133333333D0AE2341333333B3A29E58419A999999E4AE2341CDCCCC2CAA9E5841333333335CAF2341CDCCCC0CA59E58413333333398AF234100000040A69E5841CDCCCCCCE8AF2341666666E6AE9E58410000000007B02341000000E0B39E58416666666685AF234100000000B99E58410000000068AF234166666646BF9E5841CDCCCCCC87AF23419A9999F9DB9E58419A99999988AF234133333373E89E58416666666662AF23419A999939009F58419A9999999BAF2341666666E60B9F58419A999999F4AF2341666666262F9F58419A99999948B0234133333333389F584100000000AAB02341000000E03B9F584100000000CBAF2341CDCCCC8C489F584133333333C1AF2341CDCCCC0C4B9F584133333333FDB0234100000000479F5841000000001FB1234100000040599F58419A9999991EB1234133333353629F5841CDCCCCCCC1AF2341CDCCCC8C529F5841CDCCCCCC8FAF23419A999999529F5841000000005FAF2341000000E0629F58410000000069AF234100000060659F5841333333332CB12341000000A07C9F58413333333311B1234100000040849F58419A999999DFB0234166666666969F584133333333A1B0234166666646B39F5841CDCCCCCC99B0234133333313C09F584100000000B8B02341666666C6CE9F584100000000A7B0234100000020D69F58419A9999997DB02341CDCCCCACDD9F5841CDCCCCCC80B02341000000E0E39F58419A9999999BB0234133333353E99F584166666666C0B02341CDCCCCECF89F58419A999999F5B02341CDCCCCCC05A0584133333333F9B02341CDCCCCCC0AA0584100000000D8B02341000000401CA0584133333333A6B023416666664625A058413333333372B023416666666627A05841000000003EB023419A99999926A058410000000011B023419A9999792DA058419A9999990AB023413333339338A0584133333333EAAF2341000000C040A0584133333333CDAF23416666660643A058419A999999F1AF2341CDCCCCCC45A05841333333333CB02341000000E04EA058419A9999996DB02341000000205CA05841CDCCCCCCD9B02341CDCCCC0C5CA058419A9999996BB12341CDCCCC0C52A0584166666666F5B12341333333D34AA058419A9999994FB22341CDCCCC4C4AA05841333333330AB32341333333B33EA05841333333339CB323416666664640A0584166666666D5B32341CDCCCCAC38A058419A999999ECB32341666666C62FA0584133333333E9B32341333333D322A05841CDCCCCCCD9B32341333333131EA05841CDCCCCCCB6B32341000000001BA058419A999999B1B323410000000016A0584133333333C9B32341000000E00AA05841CDCCCCCC07B42341CDCCCC8C02A058419A99999926B42341000000C001A058413333333373B423419A99993906A058419A9999999EB42341CDCCCC2C13A058419A9999999FB42341333333D321A058419A999999B1B42341CDCCCC8C25A058413333333306B52341CDCCCCCC24A058419A999999D0B52341000000A018A058410000000039B623416666660611A058419A999999BDB62341000000E003A05841CDCCCCCCDFB62341CDCCCC0CFC9F584100000000FEB623419A9999D9F99F5841666666662DB723419A999959FB9F58419A99999950B7234166666626FF9F5841CDCCCCCC8FB72341666666E609A058413333333314B823416666664619A058416666666624B82341CDCCCC6C21A058416666666620B82341666666C627A05841CDCCCCCC2AB823413333333337A05841333333335BB82341CDCCCCEC42A058419A999999A7B823413333337345A05841CDCCCCCC51B92341CDCCCC2C49A058419A999999A4B92341666666064CA0584166666666D1B923410000006048A05841CDCCCCCC1BBA23413333339321A05841CDCCCCCC59BA23419A99995913A058413333333368BA2341000000600CA0584133333333C6BA23419A999939F39F58419A999999DDBA234100000020EA9F58413333333303BB234133333373E09F58413333333330BB234166666626D89F58416666666691BB2341333333D3D39F5841CDCCCCCCB1BB2341333333F3D39F584133333333E0BB23419A999999DB9F5841CDCCCCCCE9BB234100000040F29F5841666666662BBC2341666666A603A0584166666666D0BC2341000000C017A058413333333308BD23419A9999191AA058410000000081BD2341333333D317A05841CDCCCCCCD0BD2341333333F313A05841CDCCCCCC0BBE2341333333D30FA0584166666666B5BE2341666666A601A05841CDCCCCCC13BF2341CDCCCC6CF89F5841333333336EBF2341CDCCCC2CF59F584166666666C0BF2341000000A0F79F5841CDCCCCCC38C023413333337310A05841000000005CC02341333333B311A05841666666668EC02341CDCCCC2C0FA0584133333333CDC023419A99999907A0584133333333F3C023419A99991901A058413333333342C123419A999939ED9F58419A99999978C12341333333D3E59F5841CDCCCCCCECC12341333333B3E29F58419A99999919C22341000000C0DD9F58410000000036C22341333333B3D29F58416666666638C22341CDCCCC0CC19F58410000000054C2234166666686B99F5841000000004AC22341000000A0B19F58419A99999951C22341000000209E9F58410000000073C2234166666606929F5841CDCCCCCCA0C2234100000060899F5841CDCCCCCCC5C22341CDCCCC8C859F5841000000000AC32341333333B3829F5841333333334AC32341666666067E9F5841CDCCCCCC59C32341CDCCCC2C7B9F5841666666663BC32341CDCCCCAC6D9F58410000000054C32341CDCCCC8C649F58419A99999972C3234100000080619F58419A9999999BC32341CDCCCCEC609F584133333333DDC32341CDCCCCAC639F5841333333334CC423419A999999629F5841CDCCCCCC90C42341666666465F9F584166666666FEC4234166666666519F58410000000027C523419A9999794D9F58416666666694C52341CDCCCC6C499F584100000000B9C523419A999999429F58419A999999F4C52341333333B33C9F58413333333388C6234100000060319F58419A9999999CC62341666666A62A9F5841CDCCCCCC84C6234166666646249F58413333333361C623419A9999191F9F5841666666661DC62341333333B31A9F5841CDCCCCCCE0C523419A999999189F584100000000B5C523419A9999190F9F58419A999999D1C523419A9999B9069F584100000000F5C52341CDCCCCCC019F5841CDCCCCCCA6C623419A999939F09E5841CDCCCCCCEBC62341CDCCCC6CE79E5841CDCCCCCC1DC72341CDCCCCACE39E58413333333389C72341333333B3E49E584100000000CBC7234166666626DE9E584100000000F1C72341CDCCCC2CD29E58419A999999EEC723419A9999B9C49E584166666666BDC72341666666E6B99E58419A99999980C72341666666E6B59E5841000000000FC7234166666666B19E584133333333DBC6234133333313AD9E584100000000A7C6234100000020A39E584133333333A0C62341000000C09D9E584100000000A3C62341666666C68E9E584100000000B3C623419A9999997F9E58419A999999ECC62341CDCCCC0C7C9E58410000000002C723419A9999D9709E5841CDCCCCCC36C723419A9999D9659E5841333333335FC7234133333313659E58413333333389C72341000000805E9E584166666666A2C72341666666C6569E58413333333399C72341666666464D9E5841666666665AC7234166666666399E5841333333335BC7234166666626339E58419A99999970C7234100000060299E58419A9999996BC72341666666A6229E58410000000083C72341CDCCCCCC0F9E5841CDCCCCCCF8C6234100000060FB9D584166666666E5C6234133333393F49D584133333333C0C623419A999939F09D584166666666F3C52341666666E6E49D58413333333393C523419A999959E29D58413333333368C5234133333333DC9D584166666666F5C423419A999999D39D584133333333C0C42341333333B3D19D5841CDCCCCCC36C423419A9999B9C59D584133333333E4C3234166666626C29D5841CDCCCCCCC2C3234133333313C29D5841666666669CC323419A999999CB9D5841666666665EC3234133333313CD9D584133333333EAC2234166666666CD9D584133333333E8C1234100000000CF9D5841666666663CC123419A9999F9D99D58419A999999F3C0234100000060DC9D58419A99999979C02341333333D3D99D584133333333E3BF234133333373D39D584133333333A6BF234100000000DC9D58413333333300BF234133333333ED9D5841CDCCCCCCD3BE23419A999959F09D58419A9999998BBE2341CDCCCCECEB9D58416666666663BE2341666666E6ED9D58419A9999992BBE2341333333B3ED9D58410000000064BD234166666626EB9D58410000000052BD234100000080DE9D5841000000002BBD23419A999939CB9D5841333333330DBD23419A999919C09D584100000000FDBC2341333333B3AA9D584133333333E5BC234166666646969D584166666666B8BC23419A9999F9899D58413333333355BC2341666666A6769D584166666666ECBB23419A9999D96B9D5841000000008ABB2341666666A65F9D5841CDCCCCCC4FBB2341333333F3569D58419A99999934BB234166666646469D584133333333F3BA2341CDCCCCAC2C9D584166666666B4BA2341333333931E9D584166666666BCBA2341000000200F9D58416666666699BA234166666606109D58419A999999D1B92341666666861F9D5841000000005BB823419A999939CE9C58419A9999995FB9234100000040C29C5841333333330CBA2341333333F3E29C5841CDCCCCCCECBA2341CDCCCC8CD59C5841CDCCCCCCD7BA23419A9999F9CB9C5841CDCCCCCCA3BB23419A9999B9BC9C5841CDCCCCCCE1BB234166666646C69C58419A99999998BB23419A999959D79C58410000000040BC234100000020E19C58413333333366BC2341CDCCCCECDA9C5841666666665FBC2341333333F3D29C5841000000009EBC2341333333D3C19C5841000000004DBC2341CDCCCC0CBE9C58419A999999D2BB234100000060AD9C58410000000072BB2341333333F3B09C58410000000050BB23419A999999A59C5841666666666EBB234166666606A59C5841000000008BBB234133333353A09C58410000000070BB234133333373899C58413333333386BB23419A9999F9849C58413333333336BC2341000000808E9C5841000000008BBC234133333333879C584133333333FCBC23419A9999198F9C584166666666F8BC234166666666969C5841CDCCCCCC2DBD2341333333539E9C58413333333372BD23419A9999D9909C58416666666699BD234166666646859C58416666666617BE2341666666865A9C5841000000007DBE2341333333D33E9C584166666666F6BD2341CDCCCC4C359C5841CDCCCCCC71BE23419A999999249C584100000000A8BE2341666666862A9C584100000000D5BE2341333333F33E9C584166666666E7BE2341CDCCCCEC449C58419A9999990EBF2341CDCCCC0C4B9C58419A99999929BF23419A9999D9519C5841CDCCCCCCAEBF2341CDCCCC8C479C58416666666666BF2341333333D3329C58410000000074C02341CDCCCC8C329C584100000000CAC0234100000000319C5841CDCCCCCCC8C02341000000E0379C584100000000F6C02341333333333B9C58416666666632C22341000000603B9C5841CDCCCCCC35C2234133333393349C58410000000099C223419A9999B9399C58413333333391C22341333333B3499C584166666666F0C223419A9999F94A9C58416666666651C323419A9999994D9C584100000000DCC32341CDCCCCCC5A9C58416666666604C42341CDCCCC4C629C58416666666634C4234166666646449C58419A9999997EC4234100000080369C58410000000086C4234133333313249C58419A999999BDC42341CDCCCC6C1D9C58413333333332C52341CDCCCC8C279C58410000000065C4234100000000509C5841CDCCCCCCD9C423419A999979599C584133333333B0C5234133333313439C584166666666DBC52341CDCCCC2C499C5841666666667EC6234133333333489C58419A9999998CC6234100000020509C5841000000000BC6234166666606549C5841333333330BC62341000000C0579C58413333333352C62341CDCCCCEC679C5841CDCCCCCC8EC623419A9999596F9C5841CDCCCCCCACC6234133333393709C584133333333D4C6234166666606699C5841CDCCCCCCA2C72341CDCCCC0C719C58419A99999964C823419A9999D9739C58413333333379C82341333333D37D9C58419A999999A1C8234166666606849C5841333333331AC92341666666268F9C58410000000020CA234166666626AB9C5841CDCCCCCCCAC92341666666C6B69C58419A999999DBC82341CDCCCC0CB09C5841CDCCCCCC36C823419A999959B29C5841CDCCCCCCF6C72341000000E0A99C5841CDCCCCCC29C72341000000A0BF9C584166666666E8C7234100000080E19C58419A99999939C72341CDCCCC0CF29C58419A999999F1C7234133333333029D58419A99999961C723419A9999190E9D58416666666663C7234133333333169D58419A999999F7C72341000000E0149D58410000000027C823419A9999F9169D58413333333367C823419A9999991E9D5841000000007AC823419A999919239D58419A999999A8C72341333333D3299D58413333333307C8234100000040469D5841333333330BC72341CDCCCC0C4A9D58416666666614C7234133333373549D584133333333A8C7234133333393549D584133333333FDC7234100000060529D584133333333ECC8234166666606609D584133333333ECC823419A9999D96D9D5841333333335FC82341000000E0749D5841CDCCCCCC59C823419A9999D9919D5841666666668DC823419A999999909D584133333333A1C82341CDCCCCAC969D584166666666F7C82341CDCCCC8CA39D5841333333338CC823419A999999B69D58419A9999991DC92341666666E6C59D58419A999999B1C8234100000020C49D58413333333334C8234133333333C69D5841666666661DC923419A999959D09D5841CDCCCCCC25C9234133333373D59D5841333333338DC92341000000E0DF9D58416666666636CA234166666686F39D5841CDCCCCCC81CA234166666606EE9D584166666666C7CA2341333333D3EA9D5841CDCCCCCCA0CB23419A999939EB9D5841CDCCCCCC10CC234133333393EE9D58419A99999983CC2341000000A0F09D584166666666ADCC234133333353F39D584133333333E1CC23419A9999F9FA9D58416666666619CD2341000000C0FD9D5841666666665ECD23419A999959FD9D5841CDCCCCCCA8CD23419A9999B9F99D584100000000F0CD234166666686F89D58410000000055CE234166666646049E58416666666683CE234100000020049E584166666666AECE2341CDCCCCACFF9D584100000000E7CE2341666666C6FE9D5841CDCCCCCC64CF234133333313039E58419A99999996CF2341CDCCCC4C089E58419A999999C3CF234100000000089E5841CDCCCCCC0BD023419A999959029E58413333333360D023419A999999FD9D5841CDCCCCCCA3D02341000000A0F79D58419A999999E6D0234166666686EF9D5841333333330ED12341000000C0E89D58416666666667D12341000000C0D49D58416666666668D12341CDCCCCECCA9D5841CDCCCCCC50D1234166666666C49D58419A9999991AD12341333333F3BA9D58410000000011D12341666666A6B39D5841000000003AD1234100000080AD9D584133333333E0D1234100000060A49D58413333333327D22341000000209E9D5841CDCCCCCC4CD223419A999919969D58419A99999989D223419A9999B9919D58410000000007D32341666666468D9D58419A99999932D32341666666268A9D5841666666666DD32341333333B3819D584166666666ECD3234166666686729D5841666666666AD423419A9999D96A9D584166666666A7D4234133333393639D58419A999999E1D42341000000E0539D5841000000007AD5234100000080529D58419A999999C3D52341333333534E9D58416666666605D6234100000020539D58416666666625D623419A999979519D5841666666669ED62341CDCCCC6C3F9D584100000000A8D62341CDCCCCEC379D5841333333338ED623419A999919339D584166666666E7D62341CDCCCC4C2A9D58416666666695D72341666666861D9D58416666666635D8234166666686169D58419A99999918D92341333333D30A9D584166666666A4D92341000000E0049D584100000000F4D9234166666626FD9C58419A99999964DA23419A999979F59C584100000000D4DA234133333393E59C58419A99999977DA234100000000DE9C5841CDCCCCCC1CDA2341CDCCCC4CC99C5841666666668ED92341CDCCCCACCB9C5841333333333AD92341CDCCCC0CCA9C5841333333332DD92341000000A0BC9C5841CDCCCCCC9CD82341CDCCCCACCB9C58410000000090D82341CDCCCC0CA09C584133333333E1D823419A9999199D9C5841000000001CD923419A9999B9929C584133333333F8D823419A999959909C584133333333F4D82341000000207D9C58410000000052D92341333333D3749C58416666666652D9234100000080709C584166666666D9D82341000000A0749C584133333333C7D8234133333393629C5841CDCCCCCCE5D82341CDCCCC8C509C5841CDCCCCCCEBD82341666666262F9C5841CDCCCCCC6FD82341333333932A9C5841000000006BD82341000000201D9C5841000000005DD823419A9999B90D9C58416666666668D82341CDCCCC2CF59B5841CDCCCCCC5AD82341666666A6EA9B58419A99999924D8234133333313DA9B58410000000015D8234100000000CE9B584133333333C3D72341CDCCCCACA79B584166666666A5D7234133333333AA9B5841CDCCCCCC0BD72341333333D3BB9B5841CDCCCCCCDAD62341333333B3BB9B584133333333A6D62341CDCCCCCC989B5841CDCCCCCC7AD6234100000000919B5841CDCCCCCC8AD623419A999979899B58410000000003D7234166666666829B58413333333348D723419A999959789B5841CDCCCCCC51D7234133333353739B5841CDCCCCCC67D62341333333B34E9B584100000000C0D62341666666E6429B58419A99999940D72341333333932E9B58410000000092D72341333333131D9B584166666666AAD72341333333B3119B58419A999999B2D7234166666646FF9A58419A999999D8D72341000000A0DF9A58419A99999969D82341CDCCCCACDF9A58419A99999923D92341666666C6A49A5841CDCCCCCC50D9234166666686989A584100000000F2D72341333333D3829A58413333333397D723419A999999929A58410000000093D62341666666C6D19A58410000000070D5234100000000BB9A58419A99999963D5234166666646B79A5841CDCCCCCC96D523419A9999F9AB9A584166666666A0D523419A9999B9A59A584100000000E9D42341333333738F9A58416666666603D423419A999979779A584100000000C9D32341000000A0769A5841CDCCCCCCEAD223419A999979839A584100000000DCD1234133333353679A58419A999999BAD12341666666266D9A58419A99999987D12341666666E66D9A58419A99999928D123419A9999397B9A5841CDCCCCCC88D02341000000607B9A58413333333388D0234166666666719A584133333333C3D023419A9999D9649A5841CDCCCCCCEDCF2341000000A0309A58419A999999C4CF2341333333132A9A58410000000095CF234166666686319A58413333333368CF2341CDCCCCCC359A58410000000033CF234100000080379A58410000000008CF2341CDCCCC8C349A584166666666F2CE234100000040389A5841CDCCCCCCCDCE234133333333399A584133333333AFCE2341333333F33E9A5841666666666DCE23419A999919469A58410000000037CE2341333333F3499A58410000000008CE2341333333334A9A58419A999999CACD23419A9999594F9A58413333333388CD234166666606579A58419A99999970CD23419A9999995D9A58419A9999995ACD2341333333B36B9A58413333333359CD23419A9999D9729A5841CDCCCCCC84CC2341000000E06D9A58413333333378CC2341000000E0809A584100000000FACB2341333333D39F9A584166666666C1CB234166666606AF9A5841666666665ECC2341333333F3B59A5841CDCCCCCC3ACC234133333393C49A58419A999999FDCB234133333353D09A584133333333D5CB23419A999919DB9A58419A9999995DCB2341CDCCCCACEC9A584133333333C8CA2341CDCCCC2CFA9A584100000000DFCA234100000020069B5841666666669DCA2341333333D30A9B5841666666663CCA2341CDCCCCEC0C9B58410000000001CA23419A999919099B5841CDCCCCCC78C923419A9999B9F69A58410000000052C923419A9999D9F39A58413333333304C92341CDCCCC8CF29A584166666666CBC82341CDCCCCCCEE9A584166666666A5C82341CDCCCCCCE59A58416666666637C823419A9999D9D99A5841CDCCCCCC23C82341000000E0D19A5841CDCCCCCCF8C7234100000060CD9A584133333333ACC72341CDCCCCACCB9A5841CDCCCCCC1BC72341CDCCCC4CB89A5841CDCCCCCCDDC62341CDCCCCCCB49A58413333333361C6234133333313B49A58416666666610C6234166666646AF9A5841CDCCCCCC8BC5234133333353A09A5841CDCCCCCC48C52341000000E09F9A58419A99999910C52341CDCCCC4CA89A584133333333BFC4234166666646A99A5841333333338AC42341CDCCCCECA19A5841000000002CC42341666666469C9A584133333333F2C32341CDCCCCEC9E9A584100000000DBC323419A999979A69A58419A99999981C32341CDCCCC2CA89A5841CDCCCCCC32C32341CDCCCC6CA59A584100000000D3C22341CDCCCCACA39A5841CDCCCCCCA8C22341CDCCCC0C9E9A58419A99999996C22341333333F3909A58419A99999996C22341666666A6889A58419A9999996BC2234166666646889A58413333333369C22341000000C0839A58416666666633C223419A999999809A5841666666660FC22341CDCCCC4C819A58419A999999F4C12341333333D3879A584100000000D4C1234166666606899A584100000000A4C1234100000080839A58416666666668C123419A999919809A58416666666661C123419A9999997A9A5841CDCCCCCC25C1234133333393729A58419A99999925C12341666666A66D9A58413333333345C1234133333313699A58410000000012C12341666666265E9A584166666666EDC02341333333D35A9A58419A999999CEC023419A999979549A58416666666686C023419A9999D9569A58413333333362C02341333333F3539A5841CDCCCCCC15C02341CDCCCCEC569A584166666666C8BF2341333333B3549A58410000000092BF2341666666A6559A5841333333335EBF2341333333935B9A58416666666636BF2341CDCCCCAC559A5841333333331ABF2341CDCCCC2C569A58419A999999EBBE2341CDCCCC4C5B9A584100000000BFBE2341333333135C9A58416666666697BE2341666666665F9A5841000000007BBE2341000000E0559A58419A9999995DBE2341666666E6529A58416666666632BE234133333393599A58416666666606BE2341333333D3599A5841000000000EBE2341666666C6619A584166666666D0BD2341333333136A9A58410000000074BD23419A9999596B9A58410000000046BD234166666666719A58419A99999930BD23419A9999B96D9A58419A9999992ABD2341000000E0679A58419A999999DFBC2341000000C0689A58419A99999978BC234166666686619A58413333333335BC2341333333B35E9A58419A99999986BB2341333333D35E9A5841CDCCCCCC43BB234133333313599A584100000000C5BA2341666666E6589A584133333333B1BA2341666666664D9A58419A9999996FBA2341CDCCCCCC469A58416666666623BA2341CDCCCC0C469A584100000000FBB923419A9999F94D9A58419A999999DAB92341CDCCCCCC509A5841CDCCCCCCA9B92341CDCCCC0C4D9A58413333333363B92341666666263F9A58413333333342B92341666666E6359A5841333333331FB92341CDCCCCAC339A584100000000D4B82341666666E6329A5841333333338BB823419A999939309A58416666666644B82341333333D32A9A5841333333331DB823419A9999792A9A58416666666600B8234100000020309A584166666666F5B723419A9999393A9A58419A999999DAB72341CDCCCCCC459A58419A999999A8B72341333333734A9A58419A99999976B72341333333B3489A5841CDCCCCCC5DB723419A999979419A58419A9999990CB7234166666686349A5841CDCCCCCCE7B62341333333F3319A5841CDCCCCCCDAB62341000000002B9A5841666666662DB7234166666686289A5841000000003BB7234166666646259A5841CDCCCCCC2BB72341CDCCCCAC1F9A5841CDCCCCCCE9B62341CDCCCCEC1C9A5841000000008CB62341000000E0149A5841666666664AB62341666666E6099A584133333333F8B523419A999979049A584133333333D0B523419A999919059A58419A99999982B5234133333313119A58419A99999956B5234100000080129A5841000000001FB5234166666606129A584100000000EEB42341000000C00F9A5841CDCCCCCCB5B4234166666686089A5841000000006DB4234166666646FC995841CDCCCCCC66B4234166666666F4995841666666663CB42341CDCCCC0CF09958416666666613B423419A999999F099584100000000E6B3234166666666F49958419A999999C1B3234100000020F5995841CDCCCCCC57B32341CDCCCC2CEB9958416666666611B32341000000A0EA99584100000000E0B22341CDCCCC2CEE995841CDCCCCCCB0B22341000000C0EC995841CDCCCCCC41B2234133333393ED995841CDCCCCCCFBB12341333333F3E899584166666666A2B12341000000A0EA995841333333334AB1234133333393E59958419A99999937B12341333333D3E29958413333333308B1234133333373D199584133333333CEB02341CDCCCCCCC4995841CDCCCCCC87B02341CDCCCCCCBE9958419A9999992FB0234133333333BE99584133333333AEAF2341666666E6B89958419A99999991AF2341666666C6B5995841000000003BAF2341CDCCCC4CA1995841CDCCCCCC0FAF2341CDCCCCAC9C995841CDCCCCCCD7AE2341333333539A995841333333336EAE2341333333539A995841666666661DAE2341666666469C995841CDCCCCCC21AE234133333393AF9958419A99999916AE23419A999999C399584133333333DDAD2341CDCCCC6CCE9958419A999999DCAD2341CDCCCCACD7995841666666660BAE234166666646D6995841000000008EAE23419A999999D59958419A999999DDAE234133333313E59958413333333318AF234100000080ED9958419A99999939AF2341000000E0FE995841CDCCCCCC1FAF2341CDCCCC6C109A584133333333F0AE234166666686199A58419A999999C4AE2341333333531C9A58416666666677AE23419A9999791A9A58416666666644AE2341000000400B9A584100000000F1AD23419A9999B90C9A5841CDCCCCCC0CAE234100000080179A5841CDCCCCCC08AE23419A9999191E9A584166666666ACAD23419A9999592D9A5841CDCCCCCCCFAD234133333353319A58413333333307AE2341000000A02E9A58413333333343AE2341CDCCCC4C329A5841000000000AAE23419A9999F9579A58419A9999994AAD23419A999939549A58419A999999DDAC2341000000A05D9A58419A999999E0AC2341000000A06E9A58416666666679AC2341000000E0729A5841666666668BAC234166666626799A584166666666C8AC2341CDCCCCCC859A584166666666DAAC2341CDCCCC6C909A584100000000C2AD2341333333338C9A584166666666BFAD23419A999959969A58416666666691AD234100000040A09A584100000000DEAD2341CDCCCCCCA89A58413333333319AE2341CDCCCC0CAA9A58419A9999990FAE23419A999999B19A584100000000F2AD23419A999979B89A58419A999999CBAD2341000000A0BD9A5841CDCCCCCCBBAD234133333393C99A5841000000009DAD234133333393D09A5841CDCCCCCC8CAD2341CDCCCC2CDF9A584166666666BDAD2341333333B3E29A58410000000015AE23419A999959DD9A5841666666662BAE23419A999979E59A58416666666666AE23419A999959F19A5841CDCCCCCC32AE23419A999919F99A584166666666FCAD2341333333B3F99A58413333333315AE2341CDCCCC2C029B5841CDCCCCCCCDAE2341666666E6FF9A58410000000002AF2341000000E0FD9A58413333333313AF234133333353F19A58416666666688AF234100000080F39A5841333333336CAF234100000020D99A58419A999999C1AF234100000060D49A584133333333E8AF2341CDCCCC2CDF9A58416666666626B0234166666686DF9A58413333333310B02341000000C0FC9A584166666666E4AF234100000060FB9A5841CDCCCCCCD6AF23419A999979089B584166666666BDAF2341666666060E9B58413333333327AF23419A9999D90F9B5841333333332BAF2341666666E6159B58413333333329AD2341666666461D9B58419A99999917AD234100000020119B584166666666F7AC2341666666E6009B584100000000EFAC2341000000E0F29A58419A999999A4AC23419A9999D9F29A5841333333337AAC23419A9999F9C99A58419A999999B3AB23419A9999D9C89A58419A999999F8AA2341333333F3C59A5841CDCCCCCCBBAA234100000000C99A584166666666C6AA2341CDCCCC0CD09A58416666666687AA2341000000E0D09A58419A99999915AA234166666646D99A5841CDCCCCCCE0A92341333333D3CE9A58419A9999995EA92341CDCCCCCCDB9A58416666666629A9234133333393DF9A58419A99999977A923419A9999F9E59A58419A9999999CA923419A999979FC9A58410000000005AA2341CDCCCCCC3F9B5841000000005FAA2341333333B33F9B5841CDCCCCCC7CAA2341CDCCCC6C3E9B58419A99999943AB23419A9999392F9B58419A99999980AB2341666666663F9B58416666666628AB23419A999979589B58419A9999997EAA2341666666E6599B58410000000043AA2341333333F35E9B5841CDCCCCCCF2A92341CDCCCC0C5A9B5841CDCCCCCCC0A923419A9999195A9B58419A999999B7A923419A999959659B58410000000076AA2341000000E06D9B5841000000008BAA23419A9999197E9B5841666666663BAA2341CDCCCCAC809B58419A99999931AA2341CDCCCC6C849B58413333333399AA234166666646BB9B5841CDCCCCCC71AA2341CDCCCCCCC29B58413333333368AA234133333313C99B5841CDCCCCCC90AA234166666606D39B584166666666C9AA2341666666E6DA9B58416666666609AB2341666666C6DF9B58416666666699AB234133333393E49B58419A999999B4AB234100000060D29B5841000000003BAC2341000000C0D49B58416666666622AC2341333333F3E79B584100000000A6AC2341CDCCCC6CED9B5841CDCCCCCC23AC2341CDCCCC0C069C58419A999999F2AB2341666666460D9C5841CDCCCCCC5BAC23419A999919169C58416666666613AC234133333333209C584166666666ECAB23419A999999319C584166666666BFAB234166666606319C5841CDCCCCCCA1AB2341333333133C9C58419A9999996AAB23419A999979409C58419A99999985AB2341CDCCCC2C449C58410000000030AB23419A999939499C58413333333390AA2341CDCCCC0C4A9C5841CDCCCCCC8FAA23419A999979509C58410000000066AA2341333333D3539C584166666666F1AA2341666666C66A9C58419A999999C7AA2341333333336D9C5841666666662EAA2341CDCCCC4C619C584100000000F4A923419A9999D9569C584133333333BEA923419A9999995B9C58419A99999965A92341333333736A9C58410000000076A923419A9999996E9C5841666666664DAA234133333393849C5841CDCCCCCC67AA234166666646979C5841CDCCCCCC58AB2341333333D3A49C5841CDCCCCCCEFAA2341333333F3BE9C5841666666666AAA23419A999939B99C5841CDCCCCCC48AA23419A9999199D9C5841CDCCCCCC33AA234166666666989C584166666666FDA92341666666E6999C58410000000055A92341000000C0A09C584166666666E9A8234133333313A69C5841CDCCCCCC83A8234133333353A79C5841CDCCCCCC83A8234133333353A79C5841	01010000206A080000BC93E4C2D7D0234100000050FC9C5841	150030000	Z	Ally	1500300	15003	15	84	23
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	01010000206A08000036EED97FD58325419A999959A6915841	150040000	Z	Andelat	1500400	15004	15	84	21
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	01010000206A080000517DBE9557BF25419A9999695A895841	150050000	Z	Anglards-de-Saint-Flour	1500500	15005	15	84	12
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	01010000206A08000074E2D7DB8E0E2441CCCCCC8C59A05841	150060000	Z	Anglards-de-Salers	1500600	15006	15	84	48
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	01010000206A080000FC85237CF27B254166666666DF775841	150070000	Z	Anterrieux	1500700	15007	15	84	16
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	01010000206A080000E6C4F4512E5324419A9999192CB15841	150080000	Z	Antignac	1500800	15008	15	84	16
01060000206A0800000100000001030000000100000043030000CDCCCCCC269024416666666630A358416666666630902441CDCCCCAC33A3584100000000359024410000006037A358419A9999993A902441666666C63AA35841CDCCCCCC3F902441333333F33CA35841333333334C902441000000C03FA358419A99999952902441333333F342A35841666666665B9024410000006046A3584133333333659024419A9999194BA35841333333336D902441000000804EA358419A99999976902441CDCCCC2C52A3584100000000859024410000000055A3584133333333989024419A99991958A3584133333333B0902441666666265CA35841CDCCCCCCC7902441666666A660A3584100000000E09024416666660664A358419A999999F49024416666664666A35841000000000B9124416666664668A358416666666625912441CDCCCCEC69A35841333333333B912441666666866AA358419A9999994A912441333333D36BA358419A9999994B912441666666466CA35841CDCCCCCC4E912441000000E06EA35841333333334D9124419A99999971A358413333333342912441CDCCCC4C73A35841333333333A912441333333D374A35841CDCCCCCC449124410000006087A35841CDCCCCCC8B912441CDCCCC4C96A35841333333338C912441CDCCCC4C9BA35841000000003391244100000060A5A35841CDCCCCCC0B912441666666A6B0A35841000000005C912441333333D3B6A3584100000000B69124419A9999F9B7A358419A999999239224419A9999D9B2A3584166666666E1922441666666A6B2A3584100000000A8922441CDCCCC6CD9A358419A999999B392244166666626F1A3584166666666C892244100000060FCA358419A999999E6922441333333D3FEA358416666666637932441666666C610A45841CDCCCCCC489324416666668610A458413333333367932441666666C611A4584166666666839324416666662614A45841666666669D932441666666A616A45841CDCCCCCCB59324419A9999791AA458419A999999CE932441CDCCCCAC1DA45841CDCCCCCCEC9324413333331322A45841CDCCCCCC0B942441CDCCCC8C27A458416666666627942441666666862BA45841CDCCCCCC3B9424419A9999B92DA458419A99999954942441666666E62EA458419A9999996D9424413333335330A458410000000080942441000000C031A458416666666685942441CDCCCCEC32A45841CDCCCCCC419524416666666636A45841CDCCCCCC4F9624419A9999593CA458419A999999509624419A99999947A4584133333333DF9824419A99999963A45841CDCCCCCCD39824410000000067A458419A999999C4982441333333136DA4584166666666AF982441CDCCCC6C72A45841333333338B982441CDCCCC2C7AA458413333333375982441333333337FA45841CDCCCCCC659824419A9999B983A458419A99999954982441CDCCCC8C88A458416666666638982441666666A68EA458419A999999139824419A99999996A4584100000000FB9724419A9999F99AA4584100000000E7972441000000A09FA45841CDCCCCCCD4972441CDCCCC2CA3A4584100000000BF972441333333D3A7A4584133333333B5972441000000C0ABA4584133333333A29724419A9999F9AEA45841000000008897244133333393B2A458419A99999973972441666666A6B5A458419A999999699724419A9999D9B7A45841CDCCCCCC58972441000000E0BAA458419A9999993C97244100000000C0A458419A9999992297244133333393C5A4584133333333FD9624419A999959CCA45841CDCCCCCCD096244133333393D3A4584166666666AF962441CDCCCC2CD9A45841CDCCCCCC9696244100000080DCA458419A9999997296244100000000E3A45841333333335B962441CDCCCC8CE7A458419A9999993D96244166666666EDA4584166666666229624419A9999F9F2A4584100000000FE952441CDCCCC8CF9A4584100000000DD9524419A999919FEA4584166666666C19524413333339301A5584133333333B79524416666666603A55841CDCCCCCCB29524419A99997906A558419A999999AF952441333333F30AA55841CDCCCCCCA59524416666660610A558419A999999A49524419A99995915A5584133333333A19524419A9999591BA55841333333339F9524410000004023A55841CDCCCCCC9B952441666666062AA5584100000000929524419A9999D930A558419A99999986952441666666C635A558419A9999997C952441333333333AA558419A99999977952441000000203EA55841CDCCCCCC7B9524416666662641A558416666666684952441CDCCCC0C44A55841333333338B9524419A9999D946A55841333333338C9524410000006049A558410000000088952441666666064DA55841CDCCCCCC7D9524410000008051A5584166666666739524419A9999D954A558413333333367952441CDCCCC4C56A5584166666666629524416666668657A558419A999999669524419A9999795AA558419A9999996A952441666666865FA55841666666666F9524410000004063A558419A9999996B9524413333333366A558410000000049952441CDCCCC2C70A558419A999999409524413333333374A558416666666639952441CDCCCC2C77A55841CDCCCCCC259524419A9999B97BA55841666666661B952441333333D37FA558410000000017952441CDCCCCAC82A5584166666666129524416666660686A55841333333330C952441333333338AA55841333333330C9524419A9999398CA558410000000014952441CDCCCC2C8FA558419A999999199524413333337390A558419A99999927952441CDCCCCEC91A55841000000003E952441000000E092A558413333333356952441333333F393A558419A9999997F952441000000409AA55841666666668A9524419A999979A5A55841666666665095244166666686C3A558419A9999995B952441000000C0D3A558419A9999996995244166666626D5A55841CDCCCCCC709524419A999919D6A5584166666666869524419A999939D7A558419A9999998C95244100000020D8A558419A9999998E9524419A999919DAA55841000000008E95244100000080DDA55841333333338B95244166666666E1A55841000000008795244133333333E5A558416666666684952441000000C0E7A558416666666688952441666666C6E9A558410000000092952441000000C0ECA55841CDCCCCCCA1952441CDCCCC8CEFA558419A999999B195244133333353F1A558419A999999C19524419A9999D9F2A55841333333331B96244100000040F0A55841666666668896244166666626E6A558419A999999EB96244133333393D9A558413333333316972441CDCCCC0CDAA55841CDCCCCCC1D97244100000040DDA5584133333333F5962441333333D3E6A5584133333333D99624419A999939EBA55841CDCCCCCC89962441666666E6F8A558419A99999962962441CDCCCCAC06A6584100000000A7962441CDCCCC8C05A6584133333333AA9624419A99991905A6584133333333C2962441CDCCCC0C03A65841CDCCCCCCD99624410000008001A65841CDCCCCCCEC9624419A999939FFA5584133333333FE96244100000080FDA5584166666666129724419A999999FBA55841666666662A97244100000020FAA55841000000004697244166666686F8A55841CDCCCCCC5797244166666626F7A55841333333336F97244166666646F5A55841333333337F972441CDCCCC6CF3A55841333333338B97244133333313F2A5584133333333C9972441CDCCCCCCF4A5584133333333FB972441000000C0F4A5584133333333E998244166666686DBA55841333333338699244133333333C8A55841333333338D99244133333333C9A5584166666666BE99244133333373CEA5584133333333D39924419A9999F9D0A5584133333333DB99244100000080D2A5584100000000DC99244166666686D3A55841CDCCCCCCD799244100000020D5A55841CDCCCCCCAE992441CDCCCC8CDEA558416666666697992441CDCCCCECE5A5584166666666939924419A9999B9E8A55841000000009599244166666666ECA5584166666666A2992441333333F3F6A5584100000000AB9924419A999959FDA5584166666666BD9924416666660604A658419A999999C69924416666668608A6584133333333D2992441CDCCCC0C0DA658419A999999DC9924419A99991910A658419A999999F39924410000000014A65841CDCCCCCC1E9A24410000004019A6584166666666229A24413333339319A6584133333333239A2441000000E01AA65841CDCCCCCC8E9924416666664630A65841CDCCCCCCFD992441666666A641A6584133333333EA992441666666E647A65841000000004C992441CDCCCCCC5FA658419A999999389924413333339368A65841333333333A992441CDCCCC0C7FA658419A9999994E9924416666664685A65841CDCCCCCC80992441333333338AA6584100000000BE992441000000E09CA6584133333333D29924419A999999A0A6584133333333689A2441333333B3A1A6584166666666629B2441CDCCCCECA8A658419A999999C69B24419A999999C6A658419A999999329C2441CDCCCC2CCCA65841CDCCCCCCFB9B2441333333F3DDA65841CDCCCCCC8C9C2441CDCCCC8CEDA658419A9999991E9D244166666626EEA65841000000007C9D2441CDCCCC8CE6A6584100000000649E24416666664605A758419A9999990C9F244100000060F4A65841CDCCCCCCFD9E24413333339323A758419A999999519F24410000008022A758419A9999993E9F2441000000002FA7584100000000219F24416666668636A7584133333333499F24419A9999393AA75841333333337B9F2441CDCCCC2C3AA75841CDCCCCCCA29F24416666662635A758419A9999994DA02441333333F343A758416666666694A02441000000204FA7584100000000BDA02441333333535AA758419A99999917A124413333333364A75841CDCCCCCC5DA12441000000E067A75841CDCCCCCCDFA12441000000C067A758413333333343A224416666662660A758416666666688A224413333335357A758419A999999CEA22441000000C059A758419A999999F6A224419A9999395CA75841CDCCCCCC6AA32441CDCCCCAC5EA758419A999999C0A32441000000E060A7584133333333E9A324419A9999F962A758413333333316A424410000008066A758413333333338A42441000000206BA75841CDCCCCCC4AA42441CDCCCC4C6FA758419A99999951A424419A9999F972A75841CDCCCCCC4DA424419A99997979A758410000000049A424419A9999197FA75841333333334CA424419A9999D982A758410000000060A424416666660687A758419A99999983A42441CDCCCCEC8BA75841333333339AA424413333337390A7584166666666ADA424416666662696A7584166666666B5A424419A9999399BA75841CDCCCCCCAEA4244133333313A0A758419A999999A6A424419A9999F9A4A758419A999999A3A424419A999919A8A7584133333333B0A4244100000040ACA758419A999999BBA424419A9999F9B1A75841CDCCCCCCC8A4244100000000B7A7584100000000DBA4244166666666BCA7584166666666F6A42441CDCCCC0CC2A758413333333318A5244100000000C5A758419A99999945A52441333333B3C6A758419A99999980A52441CDCCCC0CC8A758419A999999A7A524419A999919C9A7584166666666B4A52441666666C6C6A75841CDCCCCCCC1A5244133333353C1A7584100000000C4A5244166666646BEA7584166666666BFA52441333333D3B9A758419A999999A8A5244100000040B3A758413333333397A5244133333373AEA75841CDCCCCCC94A52441CDCCCCECAAA758419A99999997A5244166666666A8A7584133333333A2A52441666666C6A5A7584166666666C1A52441CDCCCCCCA2A75841CDCCCCCCE7A52441666666C69EA75841CDCCCCCC2FA624419A99995995A758419A99999948A62441CDCCCCCC92A758419A99999984A62441000000C08DA758419A999999C1A624419A9999D986A758413333333312A72441CDCCCC0C7DA75841666666664BA72441666666E675A75841333333336EA724416666664670A758419A9999997FA724419A9999F96BA758410000000088A72441333333F365A758416666666687A72441666666265EA75841000000008CA72441333333D356A75841CDCCCCCC99A72441CDCCCCAC4DA7584100000000ADA724416666660644A7584133333333B2A724413333333340A758419A999999AFA72441000000E037A75841CDCCCCCCABA72441000000A02FA7584166666666A1A72441333333B31CA75841666666669AA72441CDCCCC4C0EA75841666666669EA724416666660606A7584100000000B4A72441CDCCCC4CF8A6584133333333C1A7244166666686F4A65841CDCCCCCCCBA72441CDCCCC8CF2A658419A999999E2A72441CDCCCC4CF1A6584166666666FDA7244100000080F1A658410000000026A824419A999999F2A658419A99999950A8244133333333F3A6584100000000A6A82441CDCCCC6CF2A65841333333330AA9244166666666F0A65841000000004BA9244133333313EFA658413333333360A924419A9999F9EEA65841000000008AA92441666666C6EEA65841CDCCCCCCB6A92441CDCCCC6CEDA6584100000000E9A9244166666666E9A65841CDCCCCCC1EAA244133333353E3A658410000000042AA244166666686DDA658413333333375AA2441CDCCCCACD3A6584166666666A0AA2441CDCCCC0CC8A6584166666666B4AA244166666666C3A6584100000000DAAA2441CDCCCC6CBDA658413333333305AB2441CDCCCCACB6A65841333333334DAB244133333313ABA658419A9999999EAB2441CDCCCCAC9EA658419A999999B8AB2441CDCCCC2C9AA6584100000000D0AB24416666668694A6584166666666E7AB2441333333F390A658419A9999991AAC2441333333138CA658419A99999933AC2441666666C688A65841333333334FAC2441CDCCCC4C83A658419A99999960AC2441666666C67DA658416666666666AC2441000000A077A658419A99999962AC2441CDCCCCCC6DA65841CDCCCCCC62AC2441333333D364A65841CDCCCCCC68AC24416666662662A65841CDCCCCCC7DAC24416666662663A658419A999999A2AC24419A9999D964A6584166666666CBAC24410000000067A6584166666666F8AC24413333337368A658416666666613AD2441CDCCCC2C68A658419A99999954AD24410000006072A65841666666669AAD2441CDCCCC4C72A65841CDCCCCCC07AE24413333337369A65841666666669DAE2441CDCCCCCC66A6584100000000CEAE24416666668651A65841666666663BAF2441666666E649A658413333333363AF2441000000A048A658419A99999993AF24413333331332A6584133333333ECAF2441666666061EA65841666666663BB02441333333F313A65841CDCCCCCC63B02441666666E618A658413333333396B024413333339321A658416666666619B12441CDCCCCEC32A65841CDCCCCCC73B12441333333533AA65841000000007EB12441CDCCCCCC3CA65841CDCCCCCCA5B12441666666863BA6584133333333F4B12441333333F324A658413333333344B22441000000E024A65841666666664DB22441000000E01AA6584166666666E3B224419A9999391DA658419A99999900B32441333333B310A658419A9999991EB32441666666E611A65841666666665BB324419A9999191DA65841333333338EB32441666666062CA65841666666661BB424419A9999593DA65841666666662FB42441333333533DA658419A9999994AB424419A99999916A6584166666666C8B324419A99997910A6584100000000AAB32441666666860BA658419A99999921B424416666662605A658416666666653B424419A9999D903A658413333333351B4244100000020E2A55841666666668BB424419A9999D9C7A558419A999999BCB42441CDCCCCCCBDA558419A999999DFB42441CDCCCCCCB9A5584100000000F7B424419A999919B5A558419A9999990CB52441CDCCCC6CB1A558416666666641B5244133333393A9A55841333333337FB5244100000020A0A5584166666666CAB524419A9999D994A55841CDCCCCCCE3B524419A99999991A558419A999999F9B52441CDCCCC6C8FA55841CDCCCCCC3BB624410000002089A558413333333367B62441CDCCCCAC84A558419A99999976B62441000000E082A55841CDCCCCCC85B624413333337380A55841000000008EB62441000000A07EA558413333333392B62441666666A67DA55841CDCCCCCC22B724419A9999B96FA5584166666666BCB72441333333536DA5584166666666E2B724419A9999796CA558410000000003B82441CDCCCC4C6CA55841CDCCCCCC3BB824419A9999196EA558410000000056B824419A9999D971A55841333333338CB82441CDCCCCAC78A5584133333333A8B82441666666A675A5584100000000C9B82441000000E070A558419A999999F1B824413333339369A55841CDCCCCCC10B924419A9999B962A55841CDCCCCCC22B92441666666265FA558416666666633B924419A9999F95BA558410000000045B924410000008058A558413333333359B924419A9999B956A5584166666666D2B924416666664657A558419A99999936BA2441CDCCCCEC5AA558419A99999986BA2441333333D35AA558416666666625BB2441CDCCCCEC4CA558413333333325BB2441CDCCCC2C49A5584100000000D5BA24416666664644A5584100000000BDB92441333333933FA5584100000000A4B92441333333B327A558419A99999988B92441CDCCCCEC24A558419A99999976B924419A99997921A55841000000006AB92441666666C620A55841666666664EB92441CDCCCCAC21A558419A99999910B92441666666861BA5584100000000DFB824413333339320A558413333333390B82441666666E630A55841333333335EB82441333333F330A558410000000052B824410000008010A558419A999999D9B724410000002009A558413333333357B7244166666646FFA45841666666668EB62441CDCCCC2CE7A45841CDCCCCCC94B624419A9999D9E2A45841333333339AB624419A999979DCA4584100000000A1B6244133333353D6A45841CDCCCCCCA8B6244166666626D2A458413333333346B624419A999919D0A458410000000059B624419A999999BEA4584100000000D7B5244100000000BBA45841CDCCCCCCCEB524419A9999D99CA45841CDCCCCCCB9B524419A9999D99CA45841000000009FB524419A9999199DA45841666666667FB52441333333D39CA45841CDCCCCCC69B52441333333B39CA458410000000054B524419A9999D99DA458419A9999993EB524419A9999B99EA458413333333329B52441000000A09EA45841333333330DB52441CDCCCCAC9EA4584166666666FCB42441666666469FA45841CDCCCCCCD3B42441CDCCCC0CA1A458419A999999C3B42441333333D3A1A458419A999999B8B42441CDCCCC2CA3A458419A999999ABB4244166666666A5A45841CDCCCCCCA2B4244133333373A8A45841000000009FB4244100000040ABA45841000000008FB4244100000080ADA45841CDCCCCCC7BB4244100000040AFA458419A99999960B424419A9999B9B0A458419A99999942B424419A999999B1A45841333333332BB42441666666C6B2A458419A99999914B4244100000060B4A458416666666603B424419A999919B6A4584166666666FDB324419A999959B8A45841CDCCCCCCFCB3244100000020BBA458419A999999F9B3244133333333BDA4584133333333F2B324419A999939BEA45841CDCCCCCCDFB3244133333333BEA458419A999999CEB3244166666646BEA4584166666666C6B3244133333313BFA4584166666666BDB32441666666C6C1A45841CDCCCCCCAFB32441666666A6C1A45841CDCCCCCC96B3244100000040C2A458416666666673B3244133333393C3A45841CDCCCCCC5DB32441333333B3C4A458410000000043B32441666666E6C7A458413333333322B32441CDCCCC8CCCA45841CDCCCCCC0CB3244133333313CFA458419A999999FFB22441CDCCCCACCFA4584133333333EEB22441666666A6CFA4584166666666D1B224419A999999CEA4584166666666A1B22441CDCCCC8CCBA45841CDCCCCCC73B224419A9999F9C8A45841666666664BB224419A9999B9C6A458419A99999924B22441000000A0C4A458419A99999904B22441000000C0C2A4584133333333F5B124419A9999F9C1A45841CDCCCCCCE5B12441CDCCCC8CC1A45841CDCCCCCCBBB124419A9999F9C0A458413333333391B124419A9999D9C0A458413333333396B12441000000A0BEA458410000000096B1244166666626BCA4584133333333DBB1244133333313B2A45841CDCCCCCC16B22441666666C6ABA458410000000052B224419A9999B9A1A458413333333350B224410000004086A4584133333333F6B124413333331385A4584100000000E2B124419A99995981A458419A999999E1B12441000000207BA45841333333333AB22441CDCCCC4C68A458410000000043B22441CDCCCC8C55A45841CDCCCCCC10B224419A99995954A4584100000000D5B12441CDCCCC6C54A4584100000000A5B124413333337372A458413333333391B12441333333B373A45841000000000EB124410000006062A45841CDCCCCCCA9B024419A9999395CA458416666666644B024419A99991947A4584166666666A6B02441666666862BA4584133333333B5B02441CDCCCCEC23A45841CDCCCCCCB9B024410000008021A45841333333337DB024413333339317A45841333333335FB024410000006016A45841CDCCCCCC51B02441000000E017A45841CDCCCCCC05B024413333337320A45841CDCCCCCCE8AF24419A9999F92CA45841CDCCCCCCD6AF2441333333F34AA45841CDCCCCCC7CAF2441CDCCCC0C4BA458419A99999918AF2441CDCCCCEC44A458419A9999999FAE2441CDCCCC0C36A45841CDCCCCCC6CAE24410000006029A45841333333336CAE2441000000201EA458416666666689AE24410000002014A45841333333339CAE24419A9999D903A45841000000007EAE2441666666E6FEA358413333333355AE2441333333B3F3A358419A999999F1AD2441CDCCCC8CF7A358419A99999965AD244133333373F6A358413333333320AD244166666606FEA3584166666666DAAC244133333353FFA35841666666668AAC2441CDCCCCECFCA358419A99999976AC244133333373FFA358419A99999932AC24419A9999B91EA4584166666666D9AB24413333339327A4584100000000C6AB24413333335330A458419A999999D0AB24413333331339A45841000000000DAC24410000008040A458413333333317AC24419A99993944A45841666666660DAC24419A9999B946A458419A999999AAAB2441333333D355A45841CDCCCCCCDCAB2441666666065CA4584166666666E7AB2441000000C064A45841000000001AAC2441333333336CA458413333333307AC2441333333F37EA458410000000030AC2441666666668BA45841333333331CAC2441666666E68DA458413333333393AB244100000080B7A458413333333339AB24419A999959B7A4584166666666A2AA244166666606ABA45841CDCCCCCC65AA244100000000ABA458416666666660AA24419A999979AFA45841666666665DAA24419A9999B9B4A45841000000005EAA24419A999959B8A458416666666662AA24419A9999B9BDA458416666666661AA2441333333D3C2A45841CDCCCCCC5EAA24419A999979C7A45841666666665FAA2441666666A6C8A45841000000006EAA244133333373C6A458410000000077AA24419A9999B9C3A458416666666684AA2441333333B3C1A458416666666696AA244166666606BFA458419A999999B1AA2441000000E0BBA4584133333333C4AA2441CDCCCC0CBAA4584100000000D3AA24419A9999D9B9A458419A999999DBAA244166666646BAA458419A999999E6AA244166666606BCA4584166666666F3AA24419A999919BEA458419A99999919AB2441CDCCCC0CC3A458410000000035AB244166666666C6A45841000000004DAB244133333313C9A458410000000046AB2441000000C0C9A458419A99999937AB2441CDCCCCACCCA45841333333332EAB24419A999939D0A458413333333327AB2441CDCCCCCCD4A45841666666661EAB2441666666C6D9A458419A99999910AB244133333333DFA458419A999999FBAA244133333313E5A4584133333333EEAA244166666606E9A458419A999999E4AA24419A9999D9EAA4584133333333D9AA244133333393ECA458419A999999C9AA2441CDCCCCACEEA45841CDCCCCCCBAAA244133333373F1A4584133333333B7AA244166666686F4A4584166666666B1AA244166666666F9A4584133333333A8AA2441CDCCCC6CFDA45841666666669AAA24410000000004A55841666666668BAA2441CDCCCCEC09A55841CDCCCCCC7DAA2441CDCCCC0C10A55841333333336CAA24413333331318A55841333333335AAA2441333333131EA558410000000001AA2441333333D325A5584133333333A5A924410000008029A558410000000090A92441CDCCCC0C27A55841666666667BA92441000000E025A55841666666665AA92441CDCCCC0C25A558419A99999947A924410000006024A55841666666663CA924410000008023A558419A99999930A924413333335321A558413333333328A92441CDCCCCAC1EA558410000000025A924419A9999F91BA558416666666626A92441CDCCCC4C19A55841333333332BA92441000000C015A558413333333336A92441000000A012A558413333333349A92441333333730EA55841666666665BA92441333333930AA558410000000072A92441000000A004A55841CDCCCCCC79A92441000000E000A558416666666678A9244133333313FEA45841333333336FA924419A9999F9FAA45841000000005EA92441CDCCCC8CF8A458419A9999993FA92441000000A0F5A45841CDCCCCCCE5A82441CDCCCCECF3A458419A999999BDA824419A999939F0A4584100000000BDA824419A999979E7A458419A9999999EA8244166666606E0A458413333333362A824419A999919DBA45841666666664DA82441000000A0CEA458413333333357A8244100000020CCA458413333333325A9244133333373C9A458419A9999993AA92441CDCCCCECC3A458413333333352A92441CDCCCCECBCA45841000000005FA9244100000020B7A45841666666666CA9244133333313B0A45841CDCCCCCC7BA924419A999979A8A45841666666667FA9244133333333A7A45841CDCCCCCC7BA92441333333F3A6A45841CDCCCCCC5FA92441000000A0A4A458416666666636A9244133333373A1A458419A9999990CA92441666666E69EA4584166666666E7A82441666666269DA458419A999999BDA82441CDCCCCCC9BA458419A9999998CA82441666666869AA45841666666666AA82441666666A699A458410000000034A824419A99993999A45841CDCCCCCCFCA72441666666A699A4584133333333D0A72441666666A698A4584100000000A7A724410000006097A45841000000007CA724419A9999B996A458416666666661A72441333333B396A458410000000041A724410000004097A458419A9999991FA72441333333B396A458416666666606A724413333333395A4584166666666F7A62441CDCCCC8C93A4584166666666E6A62441666666E690A45841CDCCCCCCDBA62441666666868EA4584133333333C8A62441000000C08CA45841333333337CA62441333333337AA458416666666671A624419A9999B96DA4584133333333B6A62441666666A65EA45841CDCCCCCCB5A624416666666658A458419A99999997A624413333337353A4584100000000ABA62441CDCCCCAC4AA458419A99999903A724419A99991939A458416666666603A724419A99991934A45841CDCCCCCCB2A62441333333332AA458419A999999E3A62441CDCCCCAC18A45841333333334DA624413333335311A4584166666666C0A524413333333309A458419A999999CDA52441666666C603A4584166666666D8A52441666666E6FEA35841CDCCCCCCE3A52441CDCCCC0CF8A3584100000000F9A52441CDCCCC2CECA35841000000000DA6244166666646E0A358416666666615A6244133333313DBA358419A9999995DA62441000000E0DCA3584100000000CCA6244100000000E3A3584166666666C8A62441CDCCCC8CAEA358419A99999963A62441CDCCCC2CA2A358419A999999F5A52441666666C69FA3584100000000B0A524419A9999D9A4A358419A9999997EA5244166666666ACA3584100000000D6A42441CDCCCC4CBFA35841333333339AA42441000000E0C1A3584133333333B7A424419A9999D9B2A35841000000001AA5244100000080A2A35841CDCCCCCCADA524410000002083A358419A99999998A52441CDCCCCEC72A35841CDCCCCCC34A524419A9999F942A358410000000026A524419A9999F942A358416666666606A524416666666643A3584133333333EEA424413333339344A3584166666666BBA42441333333B347A35841CDCCCCCC92A42441000000E049A35841000000006EA42441CDCCCC6C4BA35841666666665DA42441000000A04CA358416666666653A42441333333D34EA358416666666649A424416666664651A358416666666639A424419A99995953A358419A99999928A424419A99999954A35841666666661CA424419A99991956A358416666666613A42441CDCCCC8C58A35841666666660FA42441CDCCCC4C5AA358413333333311A42441CDCCCC8C5DA358410000000013A42441000000C060A358419A9999990FA42441CDCCCC4C63A358413333333312A424419A9999D966A3584133333333EBA324410000006073A35841000000006AA32441000000C07EA35841333333337DA22441333333F3ABA358413333333355A2244100000000ACA358419A999999F0A12441000000A09FA3584166666666C8A12441666666E69BA35841CDCCCCCC81A124410000004093A35841CDCCCCCCEEA124416666662684A3584166666666F8A12441000000207FA358413333333389A12441666666466BA3584100000000D6A124419A9999393EA3584166666666E9A124419A9999B936A35841CDCCCCCC46A324419A99999932A358416666666650A324419A9999192BA35841666666664FA32441000000601DA358419A99999966A224413333331318A358410000000043A224413333335319A358413333333322A22441CDCCCC2C1AA3584166666666FEA124419A9999591AA3584100000000D2A12441333333331AA35841CDCCCCCCB0A12441000000601AA35841CDCCCCCC8BA12441333333F31AA358413333333356A124419A9999991CA358419A99999921A124419A9999391EA358413333333316A12441000000801EA3584133333333FCA02441333333131FA35841CDCCCCCCB3A02441CDCCCCCC35A35841CDCCCCCC77A024419A99991937A358419A999999D79F24416666664632A35841CDCCCCCC919F24419A99995932A35841666666666A9F2441000000603CA35841333333332F9F2441333333B347A35841CDCCCCCCE99E2441000000404FA3584100000000A49E24413333339350A35841CDCCCCCC359E2441333333F34CA35841CDCCCCCC179E24419A9999794AA35841333333335B9E24413333333326A358419A999999389D24410000008017A35841000000001D9D2441CDCCCC6C16A35841000000001D9D24413333333319A3584133333333199D2441000000801BA35841CDCCCCCC0A9D24419A99995921A3584166666666F29C2441666666062AA35841CDCCCCCCDA9C2441CDCCCC2C33A35841CDCCCCCCD29C2441CDCCCC4C36A3584133333333D19C2441CDCCCC0C37A3584133333333AE9C24410000002036A35841000000008D9C24419A99997936A3584100000000669C2441CDCCCC0C38A35841CDCCCCCC429C2441666666E639A35841CDCCCCCC1A9C2441000000803CA3584166666666F99B2441000000403FA35841CDCCCCCCE19B24419A9999B941A3584166666666C89B24413333337345A3584133333333A79B2441CDCCCC8C49A35841CDCCCCCC889B2441666666E64BA35841666666666B9B2441333333F34CA35841CDCCCCCC4A9B2441CDCCCCCC4EA3584166666666099B24416666664653A35841CDCCCCCC6C9A2441666666E65DA358419A999999499A24419A99995960A3584133333333079A24413333331364A3584133333333DB992441CDCCCC4C66A3584133333333C39924419A9999B967A35841CDCCCCCC979924410000008068A3584133333333649924413333337369A358419A9999994C9924410000008069A3584100000000369924419A99993968A35841CDCCCCCC299924410000004066A35841CDCCCCCC22992441000000C063A358410000000019992441666666A661A35841CDCCCCCC0C992441666666A65FA358419A99999903992441666666865DA358419A999999E8982441000000605FA3584166666666C99824416666660660A3584133333333AD9824416666668660A358419A9999998B982441CDCCCC0C61A35841CDCCCCCC6E9824419A9999F961A35841333333335C982441666666E662A358419A999999469824410000000064A35841CDCCCCCCFE9724419A99997968A35841CDCCCCCCB2972441CDCCCC6C61A35841CDCCCCCCE3972441666666A653A3584100000000E39724416666666648A35841333333335F9724413333335329A3584133333333419724419A99995929A35841CDCCCCCCE79624413333333332A358410000000098962441666666C634A3584133333333A19624416666664628A35841666666661F9624416666666628A358410000000094952441CDCCCC4C31A35841000000001E952441666666C631A358413333333319952441CDCCCCCC30A3584166666666029524419A9999192EA3584166666666ED942441666666262CA358419A999999E2942441CDCCCCEC29A358419A999999DF9424419A99999927A3584133333333DE942441333333B325A358419A999999C79424416666666621A3584133333333BF942441CDCCCC6C1FA358419A999999C0942441000000A01DA3584133333333CD942441000000001BA35841CDCCCCCCCF9424416666668619A3584133333333CB9424413333335318A3584166666666BF9424413333337317A358419A999999AC942441666666C615A3584133333333A29424410000004014A35841CDCCCCCC9F9424419A99997912A358419A999999A29424419A9999F910A3584166666666A7942441666666260FA3584166666666A7942441333333F30DA35841CDCCCCCC9E942441333333530CA358419A99999995942441CDCCCC2C0BA358413333333396942441333333B309A35841CDCCCCCC9D9424419A99993908A358419A999999A6942441666666A605A3584166666666AD942441333333F301A358419A999999B094244100000000FFA2584133333333B29424419A999919FCA2584100000000B0942441CDCCCC6CF9A258419A999999A994244133333393F6A2584166666666AA94244100000040F5A2584133333333B294244100000020F4A2584133333333BE94244166666666F3A258419A999999CA942441666666C6F1A25841CDCCCCCCD2942441000000C0EFA2584100000000D994244166666606EDA2584133333333DC942441666666A6EAA2584166666666D7942441CDCCCCECE7A2584133333333CB9424419A999979E5A25841333333339F942441000000A0E6A258419A9999994694244133333333F8A25841000000001F94244100000040FDA258413333333389932441666666A6FEA25841CDCCCCCC7E932441666666A6F9A258419A9999997393244133333333E8A258419A9999999A93244166666666DAA258419A999999F393244133333313CAA25841666666661B942441CDCCCCCCC8A25841666666664D9424419A999939CBA2584166666666B194244100000060CCA2584166666666BB94244100000020CBA2584100000000C1942441333333F3C4A258419A999999BD942441CDCCCC6CC2A2584166666666C094244166666686BFA258419A99999937942441666666C6AFA258419A999999F19324419A999959ADA258419A9999991F93244133333353ACA25841666666662F9224419A999999A3A25841CDCCCCCC1B9224419A999919ABA25841000000001C9224419A999999ADA25841333333337692244100000080B2A25841CDCCCCCC8A9224419A9999F9B9A2584100000000B3922441CDCCCCACBCA2584133333333BD922441CDCCCC6CC0A258419A99999932922441CDCCCC4CD3A25841CDCCCCCCD991244100000020E6A2584100000000EB9024419A9999D9F3A2584166666666D7902441000000E0F8A25841333333330A912441CDCCCCCC06A35841CDCCCCCC1E912441666666860FA358410000000063902441333333B32DA35841CDCCCCCC269024416666666630A35841	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	01010000206A080000A52ED6539BA72441CCCCCCFC37A55841	150090000	Z	Apchon	1500900	15009	15	84	13
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	01010000206A08000012FA7FA774BF23419A9999690FAB5841	150100000	Z	Arches	1501000	15010	15	84	18
01060000206A08000001000000010300000001000000BE0300009A99999934602341333333F3AB9358410000000041602341666666C6B1935841000000005F60234100000000BF935841333333336560234166666626C3935841CDCCCCCC6860234133333393C5935841CDCCCCCCBE60234133333313BF9358419A9999993C612341CDCCCC8CAD9358419A999999B2612341333333D3A6935841CDCCCCCC1A6223419A9999F9A69358419A999999636223419A9999F9AB9358419A9999995B63234166666646C5935841CDCCCCCC1F662341CDCCCCACE293584100000000C4672341000000C0E793584100000000546A2341CDCCCC4CF1935841CDCCCCCCD56A2341CDCCCC0CEC935841333333337C6B2341CDCCCC6CDA9358419A999999236C23419A9999F9D093584100000000F16C23419A9999D9CD93584133333333546D2341000000C0CB935841CDCCCCCC656D2341666666C6CA93584100000000A46D234100000060C793584166666666AD6D23419A999959C59358419A999999AC6E2341333333B39C935841CDCCCCCCF46E2341666666A685935841CDCCCCCCBF6F2341000000406A935841666666668B702341666666C6619358419A9999998B712341CDCCCC0C6393584133333333937223419A9999796C9358416666666694722341CDCCCCAC6C9358419A9999993F732341000000E07A935841CDCCCCCCD775234133333373D5935841CDCCCCCC1B772341000000E01E945841666666661A782341666666C6429458416666666613792341000000C04A945841CDCCCCCCBC79234133333373429458419A9999994B7A23419A9999592F945841CDCCCCCC9A7A23419A99999912945841333333335A7A2341000000C0FF935841CDCCCCCCF479234166666686EE93584100000000D478234100000000C0935841CDCCCCCC44782341000000E09C935841333333337A7823419A9999B979935841CDCCCCCC9E792341666666062E935841CDCCCCCC457A2341333333331B93584133333333597C2341666666E61C935841CDCCCCCCA38023419A9999192E93584133333333D9802341666666662E93584166666666A5812341666666862F93584100000000D2822341000000803093584166666666DA832341000000003093584133333333868423410000006030935841CDCCCCCC478523410000006034935841CDCCCCCCAE852341000000203893584166666666DD852341333333733A935841CDCCCCCC808623419A999959459358413333333351872341CDCCCC0C589358419A999999678823419A99993975935841666666660A892341666666E684935841CDCCCCCCA889234166666606929358419A999999578A2341666666C69D93584166666666F88A23419A999919A693584100000000868B234133333313AC93584133333333F58B2341000000E0B593584133333333068C234166666646B8935841333333333D8C234100000020C39358419A9999994D8C234100000040CB93584133333333538C2341CDCCCCECD6935841CDCCCCCC368C23419A999999E493584166666666F78B2341CDCCCCCCF6935841333333338B8B2341CDCCCCEC0F94584100000000268B23419A999959339458419A9999990C8B2341666666864A945841CDCCCCCC088B2341333333B3639458419A999999218B2341CDCCCC8C74945841CDCCCCCC448B23416666660682945841333333336E8B23419A9999198A94584166666666AB8B2341CDCCCC2C9294584166666666F78B2341CDCCCCCC96945841000000004A8C2341333333939994584100000000F28C2341333333539B94584166666666638D2341333333539B94584133333333D68D2341000000209A945841CDCCCCCC7C8E2341333333F395945841000000004D8F23419A9999599194584166666666CD8F2341000000C09194584133333333339023419A9999399294584133333333C2902341CDCCCCCC95945841333333333C9123419A9999599A945841CDCCCCCC5D912341666666069B94584100000000E9912341333333739D9458419A99999957922341000000A09E945841CDCCCCCCC3922341000000A09E9458419A999999EF922341000000A09E945841666666669D9323419A9999D99B9458419A999999149423410000006096945841666666665194234133333353919458419A999999A3942341000000E083945841CDCCCCCC09952341CDCCCC4C67945841CDCCCCCC289523419A99991958945841000000003395234100000040439458419A9999990D9523419A9999992C94584166666666ED942341CDCCCC2C25945841CDCCCCCCAE9423419A9999B9169458410000000033942341000000E006945841CDCCCCCC439323419A999979F39358419A999999C3922341666666A6EF9358416666666654922341666666A6EE93584166666666159223419A999959F0935841CDCCCCCCCC912341666666C6F6935841CDCCCCCC9C9123419A9999D9FF935841666666668C9123413333333309945841CDCCCCCC89912341000000C010945841CDCCCCCC859123413333333319945841CDCCCCCC64912341000000E01F9458419A99999938912341666666462194584166666666FC902341CDCCCCAC1E94584166666666AF902341CDCCCC0C1494584133333333629023413333335304945841CDCCCCCC0A90234166666686F0935841CDCCCCCCFF8F2341000000A0ED93584133333333728F2341CDCCCC6CC393584133333333578F2341000000E0B593584133333333498F2341CDCCCC8CA793584100000000538F234100000020A09358419A9999995F8F2341333333539793584166666666748F2341CDCCCC4C9293584166666666898F2341333333738F935841CDCCCCCCAD8F2341666666268C93584166666666DD8F2341CDCCCC6C889358410000000024902341CDCCCCCC859358419A9999997D902341000000C084935841CDCCCCCC7F902341666666C68493584133333333DA902341CDCCCC0C859358419A999999229123419A99991985935841CDCCCCCC71912341666666C683935841CDCCCCCCAA912341000000008093584100000000D5912341333333B37993584133333333E7912341000000A07093584100000000FF9123419A99993955935841CDCCCCCC24922341666666062F9358410000000028922341000000202B9358413333333330922341CDCCCCEC1D935841CDCCCCCC349223413333337310935841CDCCCCCC31922341000000E000935841CDCCCCCC389223419A9999F9F5925841CDCCCCCC4D922341333333B3ED925841CDCCCCCC6D92234166666606E692584166666666929223419A999959DF92584133333333CC92234166666626D892584100000000FD92234166666606D2925841333333332893234166666626CD9258419A9999994493234133333353CA925841333333336D9323419A999999C59258410000000091932341CDCCCC6CC0925841CDCCCCCCB3932341666666C6B992584133333333CF9323419A999939B492584166666666E093234100000060B09258419A999999EA932341666666A6AD92584166666666F19323419A999919A9925841CDCCCCCCEE93234166666666A292584166666666E5932341000000A09A92584166666666D2932341CDCCCC6C8D92584166666666BF932341CDCCCCCC789258419A999999BE93234133333333709258419A999999C2932341333333536C9258419A999999CC9323419A9999796892584100000000DD932341000000A065925841CDCCCCCCFB932341CDCCCC8C62925841CDCCCCCC2694234133333313609258419A99999954942341666666C65E925841CDCCCCCC70942341000000605E9258419A99999993942341333333535E92584100000000C4942341666666665F925841CDCCCCCCEE942341000000A061925841CDCCCCCC1E952341CDCCCCEC65925841CDCCCCCC42952341666666466B9258419A99999976952341CDCCCC4C749258419A999999D1952341666666268492584166666666FB9523419A9999F98A9258419A999999199623419A9999598F925841000000003C9623416666664692925841666666665D962341666666069392584100000000739623419A9999B992925841000000009E962341CDCCCCAC9092584100000000D0962341666666668C92584100000000FD9623419A9999B987925841000000001797234133333373839258410000000030972341CDCCCC8C7C92584166666666469723419A999999749258413333333363972341CDCCCC8C67925841CDCCCCCC699723419A9999F962925841333333336C9723419A9999795E925841666666666C972341666666A657925841333333336497234166666666459258416666666658972341000000802F925841666666663E972341333333F31C9258419A9999991797234100000060079258419A99999902972341CDCCCC6CFE91584133333333D49623419A999919F5915841CDCCCCCCA1962341CDCCCCCCEE915841000000005F9623419A999959E99158419A999999C9952341666666C6E19158419A9999994E95234133333333DC915841666666660E95234166666626D991584133333333CF94234133333313D49158419A999999B3942341333333F3D0915841000000009E94234100000060CD915841CDCCCCCC92942341333333F3C8915841333333339194234133333353C591584166666666939423419A999999BF915841CDCCCCCCB0942341666666A6B091584166666666F19423419A9999799C915841CDCCCCCC1E95234100000000939158413333333331952341CDCCCC6C909158410000000054952341000000008E915841333333336D952341000000E08C915841CDCCCCCC8E952341000000A08C91584166666666B1952341000000008D91584166666666D5952341CDCCCC2C8F915841000000000096234133333313949158416666666616962341666666C6989158416666666628962341CDCCCC4C9E915841333333333196234166666606A49158416666666634962341333333D3AD915841000000003A96234133333353B491584166666666459623419A999939B99158410000000056962341CDCCCCCCBD915841CDCCCCCC6F962341333333D3C2915841CDCCCCCCD196234100000020D2915841CDCCCCCC059723419A999919DA915841CDCCCCCC18972341000000E0DC9158416666666628972341000000E0DE9158419A9999993A97234133333333E0915841CDCCCCCC5097234100000080E09158419A9999997597234166666686E091584100000000DC97234100000080E0915841CDCCCCCC0F9823419A999939E0915841CDCCCCCC33982341333333F3DE915841666666669A9823419A999939D7915841CDCCCCCC00992341CDCCCCECCE915841000000001E99234133333333CC915841666666665199234133333313C6915841666666666399234100000040C3915841000000006F99234133333333C09158419A99999982992341333333F3B89158419A999999AC992341333333939F91584166666666C2992341CDCCCC8C939158419A999999CD992341000000408B915841CDCCCCCCD7992341333333B38391584133333333E19923419A9999597F91584100000000ED992341000000407B91584100000000FA9923413333335377915841000000001A9A23416666664671915841CDCCCCCC359A23419A9999796B915841000000003D9A2341CDCCCCAC699158419A999999439A2341666666C6669158419A9999994D9A2341000000006291584100000000649A234166666606559158419A999999859A23419A9999B94391584133333333929A23419A9999793D91584133333333979A2341CDCCCC0C3891584100000000999A2341CDCCCC4C30915841CDCCCCCC999A23419A9999B92B915841666666669B9A2341CDCCCCEC299158419A999999869A23410000006029915841333333337E9A23419A9999D92891584133333333709A234100000020279158419A9999995A9A23419A9999B92391584166666666429A23419A9999B9209158419A9999991B9A2341666666061E91584133333333E39923419A9999791A915841CDCCCCCCB69923413333335317915841666666669D9923410000000016915841666666668F992341CDCCCCEC15915841CDCCCCCC839923413333333316915841000000006E992341CDCCCC6C17915841CDCCCCCC4E9923410000006019915841000000003C992341666666261A9158419A99999929992341333333331A91584133333333179923419A99995919915841666666660B9923419A9999B9189158419A999999EF982341000000001791584166666666E098234133333393169158419A999999CC9823416666666616915841CDCCCCCCBD982341666666A61691584133333333AB9823410000006017915841CDCCCCCC96982341666666861891584166666666749823419A9999F91A9158419A9999994E9823419A9999391C9158419A99999905982341333333331D9158419A999999EC9723419A9999591D91584100000000DD972341CDCCCC2C1D91584166666666D1972341333333531C915841CDCCCCCCCF972341000000001B9158419A999999D19723419A9999991891584166666666D1972341CDCCCC6C1691584100000000CE972341666666E61391584133333333C997234166666686119158419A999999CA9723419A9999390E91584133333333D6972341666666460A915841CDCCCCCCE7972341333333D305915841000000000498234133333313FF9058413333333316982341333333F3FA9058419A9999991E982341CDCCCC4CF6905841CDCCCCCC1D98234133333393F29058416666666615982341CDCCCCACEF905841333333330A98234133333353ED905841CDCCCCCCF7972341CDCCCCACEA905841CDCCCCCCEB972341CDCCCCECE790584100000000E59723419A999919E5905841CDCCCCCCDD9723419A999979E390584166666666D19723419A9999B9E2905841CDCCCCCCC2972341666666A6E29058419A999999AB972341CDCCCC4CE3905841CDCCCCCC8D9723419A9999B9E3905841000000007997234166666686E3905841CDCCCCCC6597234166666666E390584133333333589723419A9999F9E3905841CDCCCCCC43972341CDCCCC0CE5905841666666661D972341CDCCCCACE6905841CDCCCCCCFC96234100000080E890584133333333D996234100000020EB90584100000000C09623419A999999EC9058419A999999A0962341CDCCCC6CED9058416666666688962341CDCCCCCCED905841CDCCCCCC709623419A9999D9ED905841CDCCCCCC5C96234133333373ED9058413333333340962341CDCCCCCCEC9058419A99999917962341CDCCCC6CEB90584100000000F995234133333373E9905841CDCCCCCCE0952341333333B3E790584133333333CE952341CDCCCC6CE590584166666666BC952341000000C0E19058419A999999B695234166666666DF90584133333333B495234166666666DB90584166666666B695234100000060D8905841CDCCCCCCBE952341666666C6D290584133333333BF952341CDCCCC2CCE905841CDCCCCCCBD95234100000020CA90584133333333B7952341CDCCCCACC490584100000000B495234100000000BF90584166666666B5952341000000A0BB90584100000000B795234166666666B890584133333333C195234166666686B39058419A999999E3952341CDCCCC2CA69058413333333310962341333333B395905841666666661C962341333333B38E9058410000000023962341CDCCCCCC8790584133333333219623419A9999D982905841CDCCCCCC179623419A9999D98090584166666666F39523419A9999B97E90584166666666CD952341333333D37C90584166666666A9952341CDCCCC6C7A9058410000000094952341333333D37A905841000000007E952341CDCCCCCC7B90584100000000699523419A9999197C9058413333333352952341333333537B9058419A99999938952341000000A0799058413333333312952341000000407690584100000000EF942341666666C672905841CDCCCCCCCE942341CDCCCC2C6F90584133333333AF942341333333B36A905841CDCCCCCC96942341000000C0659058413333333385942341CDCCCCEC609058413333333381942341000000605C9058419A9999998194234133333373599058419A99999988942341CDCCCCCC56905841CDCCCCCC959423419A9999995390584133333333B8942341333333734E90584166666666E1942341666666C6499058416666666614952341333333B34490584133333333319523419A9999F9409058416666666639952341CDCCCC0C3F9058419A9999993F952341CDCCCC0C3B9058419A9999993D952341000000C038905841333333333095234100000060359058413333333323952341666666C6339058419A999999B5942341333333D32990584100000000839423419A9999B922905841333333336F942341CDCCCCCC1D905841000000006494234166666646189058410000000060942341333333B312905841666666665E942341CDCCCC4C10905841CDCCCCCC4F942341666666060E9058410000000041942341CDCCCCEC0C9058410000000025942341666666E60A905841333333333C942341000000E00790584133333333599423419A99997902905841333333338C942341000000E0F78F58419A999999B4942341CDCCCC2CEF8F584100000000C59423419A9999D9EB8F5841CDCCCCCCC9942341CDCCCC8CE88F58419A999999C9942341CDCCCC2CE58F5841CDCCCCCCC3942341CDCCCCCCE28F584166666666B794234100000060E08F58419A999999A3942341666666A6DE8F5841333333338B9423419A9999B9DD8F5841666666666E942341CDCCCC6CDD8F5841666666665694234133333353DD8F5841666666663A94234133333373DD8F5841666666662994234133333353DD8F58419A9999991794234133333393DC8F58419A999999049423419A999919DB8F584133333333F293234133333333D88F584133333333E6932341CDCCCCACD68F584100000000D1932341000000E0D48F584100000000B49323419A999979D38F5841CDCCCCCC97932341000000A0D28F58419A9999997A93234100000060D28F58410000000051932341666666E6D18F5841666666662593234100000060D18F5841CDCCCCCC0F932341000000E0D08F584166666666EA922341CDCCCCECCE8F5841CDCCCCCCCA922341CDCCCCACCC8F584166666666A192234133333373C88F58419A9999998A9223419A999999C68F58413333333369922341CDCCCCECC48F58419A9999994B92234100000060C38F58413333333338922341333333D3C18F58419A9999992792234100000020BF8F58419A9999991B9223419A9999B9BB8F58419A99999913922341666666E6B88F58419A99999908922341000000A0B68F584166666666F391234133333313B58F584133333333DE9123419A999939B48F58419A999999BF912341CDCCCCECB28F5841CDCCCCCCA99123419A999959B18F58419A9999999A91234100000000AF8F5841333333338F9123419A999939AB8F5841CDCCCCCC8091234100000060A48F58413333333360912341CDCCCC6C8E8F5841CDCCCCCC4D912341000000A07D8F5841CDCCCCCC499123419A9999D97A8F5841000000004A912341333333B3768F5841CDCCCCCC5A912341CDCCCCEC718F58410000000068912341333333936E8F58410000000075912341000000A06A8F58416666666679912341000000A0688F58419A99999969912341CDCCCCAC678F584100000000599123419A9999B9668F5841666666661791234100000040628F5841CDCCCCCCFE902341CDCCCCAC608F58419A999999E79023419A9999795F8F584166666666CA902341CDCCCCEC5E8F584166666666AD9023419A9999395F8F5841333333337F902341CDCCCC4C618F5841000000005C90234133333313628F5841CDCCCCCC3D90234166666666618F5841CDCCCCCC1990234166666686608F584133333333009023419A999979608F584166666666D98F2341CDCCCCCC608F584100000000BB8F23419A999959618F584100000000A28F234166666666618F5841CDCCCCCC888F2341666666A6608F58419A999999448F2341000000C05D8F5841666666660E8F2341CDCCCC6C5C8F584133333333F58E2341000000C05C8F58419A999999D28E2341666666A65E8F584166666666BA8E234166666626608F584100000000A28E234100000080608F5841CDCCCCCC8B8E2341CDCCCC0C608F584166666666778E2341333333535F8F584100000000538E23419A9999995E8F5841000000002C8E2341CDCCCCAC5E8F5841CDCCCCCC118E2341666666A65F8F5841CDCCCCCCED8D23419A9999D9618F584100000000B88D23419A9999D9668F584100000000998D2341333333F3698F58419A9999998B8D2341333333336B8F584133333333608D23419A9999F96C8F584100000000318D2341000000006E8F5841CDCCCCCC0A8D2341CDCCCC8C6F8F584133333333E78C2341CDCCCCEC728F584166666666BB8C234100000080798F584133333333768C2341000000E0858F584133333333308C23419A9999D9918F584166666666F68B2341000000E09C8F5841CDCCCCCCBB8B234100000080A58F584100000000848B2341CDCCCC6CAC8F58419A999999648B2341CDCCCC6CAF8F5841666666663D8B2341333333D3B28F5841333333330A8B2341666666C6B78F584133333333D48A2341333333F3BB8F5841CDCCCCCC8D8A23419A9999F9C08F5841CDCCCCCC578A2341333333F3C38F58419A999999138A2341666666A6C88F5841000000000E8A2341666666E6C88F58419A999999FC892341666666A6C98F584100000000DD89234100000020CA8F5841666666668889234166666606CA8F584166666666558923419A999999C98F5841000000001C8923419A9999F9C68F58419A999999DD88234166666646C38F5841CDCCCCCC90882341CDCCCCCCBF8F58419A9999996188234100000060BE8F5841000000003A8823419A9999B9BD8F584133333333078823419A999939BD8F584100000000E787234133333333BC8F584100000000C4872341CDCCCC2CBA8F584166666666938723419A9999F9B78F5841333333337787234100000020B78F5841CDCCCCCC71872341CDCCCC6CBB8F5841000000006E87234133333393BD8F58419A9999996587234133333373BE8F5841333333335F87234133333393BE8F584133333333F68623419A999979D38F584100000000F98623419A999939D68F58410000000001872341CDCCCCACD88F58413333333317872341CDCCCCCCDC8F5841000000002B872341000000A0E08F5841CDCCCCCC3287234166666646E38F5841CDCCCCCC33872341000000A0E58F58416666666631872341CDCCCCECE88F5841CDCCCCCC25872341333333D3EE8F58416666666619872341000000C0F48F5841CDCCCCCC06872341000000A0FA8F5841CDCCCCCCEE862341CDCCCC4C0190584166666666D48623419A9999990A905841CDCCCCCCC7862341333333D31090584166666666C2862341CDCCCCAC129058419A999999BB862341CDCCCC0C1490584166666666B8862341000000E01490584166666666A6862341CDCCCC4C10905841666666668286234166666646079058419A9999995F862341CDCCCCCCFE8F584166666666398623419A999959F68F5841666666661E86234100000060F18F5841333333330686234100000020EE8F5841CDCCCCCCF0852341000000E0EB8F584133333333B185234166666666E18F5841333333338B84234166666686D48F5841000000003F842341333333D3DB8F58410000000016842341666666C6D98F58419A9999990884234166666606D98F5841CDCCCCCCE383234100000080D68F5841CDCCCCCCC1832341000000C0D38F5841333333335884234100000000BD8F58413333333330842341CDCCCCCCAE8F5841333333330284234166666626AE8F584100000000E58323419A999939AD8F584100000000B7832341CDCCCCCCAA8F5841666666669583234166666626A98F5841000000008483234166666666A78F5841333333336F832341666666C6A38F5841333333332D832341CDCCCCCC9B8F58419A9999991B832341333333B39E8F5841CDCCCCCC01832341333333D3A18F584166666666DC822341CDCCCC0CA48F584100000000B38223419A999979A58F5841CDCCCCCC92822341000000C0A58F58419A9999997682234133333333A68F58419A99999959822341333333F3A68F58419A9999994B8223419A999919A58F5841666666663E8223419A999919A38F58410000000025822341CDCCCC4C9F8F58413333333310822341666666469B8F584133333333FC8123419A9999B9968F584100000000E7812341000000E0908F584100000000D28123419A9999198A8F584133333333AD812341666666667E8F5841000000007D812341666666266F8F58419A99999954812341333333B3628F584166666666398023419A9999B9398F58419A9999991A802341666666263C8F584133333333ED7F2341000000E03D8F5841CDCCCCCCC47F234166666626408F584100000000AF7F234166666646418F5841000000009D7F2341CDCCCCAC418F584100000000917F234166666666418F584100000000867F2341CDCCCCAC408F584133333333747F234100000060408F5841CDCCCCCC407F2341333333D3408F584133333333D67E234133333313418F584166666666707E23419A999919418F5841333333333C7E2341666666C6418F584100000000177E2341000000A0428F584100000000F57D234133333313438F584166666666E47D234133333313438F584133333333DF7D234100000020438F584100000000D97D23419A999939438F584133333333D47D2341CDCCCCCC428F584166666666C97D234133333333428F584133333333A07D2341CDCCCC6C408F5841CDCCCCCC827D2341666666263F8F584166666666737D2341666666063F8F584100000000637D2341333333133F8F5841666666663C7D23419A9999B93F8F5841000000000C7D23419A999939418F58419A999999E77C23419A9999F9418F5841CDCCCCCCBB7C234133333393428F5841666666668C7C234133333333438F5841CDCCCCCC6A7C23419A999999438F584166666666597C2341CDCCCCEC438F584100000000487C234100000060448F584133333333397C234133333353458F5841000000001D7C2341333333D3478F5841CDCCCCCC057C2341CDCCCCAC498F5841CDCCCCCCE07B23419A9999D94B8F5841CDCCCCCCBE7B23419A9999D94D8F584166666666A87B2341666666C64F8F5841666666668B7B2341666666C6528F5841CDCCCCCC6A7B2341000000E0558F5841000000004D7B234100000060588F584166666666387B23419A9999B9598F5841CDCCCCCC1E7B23419A9999D95A8F584166666666097B2341666666E65B8F5841CDCCCCCCFB7A2341CDCCCC0C5D8F584133333333EB7A2341333333F35E8F584100000000DE7A234133333313618F5841CDCCCCCCA17A2341CDCCCC2C688F584100000000C6792341666666C6778F584166666666B279234100000040798F584166666666987923419A9999597A8F5841666666666A792341666666E67B8F5841CDCCCCCC387923419A9999797D8F5841666666660F792341CDCCCCEC7E8F58419A999999F278234100000000818F58419A999999EC7823419A9999D9808F5841000000001E7823419A9999997B8F5841333333330A7823419A9999797A8F584133333333E7772341CDCCCC0C798F58419A999999AA7723419A9999F9768F5841CDCCCCCC70772341CDCCCC6C748F58419A99999938772341666666E6718F58419A99999906772341CDCCCCAC6F8F58419A999999D0762341333333B36D8F5841CDCCCCCCAB762341000000A06C8F58410000000087762341CDCCCC8C6B8F58419A99999964762341CDCCCC0C6B8F58410000000042762341666666C66A8F58413333333318762341666666C66A8F58419A999999ED7523419A9999F96A8F584100000000C6752341666666C66B8F58419A9999998F752341333333136D8F5841666666665C752341666666A66E8F5841000000002D75234133333373708F584166666666F3742341333333136D8F58419A9999997C7423419A9999B96D8F5841CDCCCCCC3F742341CDCCCC8C718F58410000000037742341666666E6728F58419A999999257423419A9999B9758F58416666666612742341CDCCCC6C798F5841666666660A742341333333537E8F5841CDCCCCCC0C74234166666686838F5841000000001A74234166666686878F58419A99999930742341000000808C8F58410000000030742341CDCCCC8C908F5841333333332B7423419A999999968F584133333333167423419A9999B99B8F584166666666FE73234100000020A08F58419A999999DE732341000000A0A58F58419A999999CC732341CDCCCCCCA98F58419A999999B873234100000040AE8F5841CDCCCCCCB273234166666686B08F5841CDCCCCCCB3732341666666A6B38F584166666666BB73234166666666B68F58419A999999C5732341333333B3B88F584100000000C77323419A999939BB8F584100000000C8732341666666E6BC8F5841CDCCCCCCCA73234166666686C28F58419A999999C97323419A999919C78F58419A999999C4732341CDCCCCACC98F584166666666C073234133333393CB8F58419A999999B7732341666666E6CF8F5841CDCCCCCCA473234166666606D48F5841666666668773234166666606D78F5841666666666273234166666646DA8F58419A9999993573234100000060DF8F58410000000016732341000000E0E28F584166666666F5722341CDCCCC6CE68F58419A999999D2722341666666E6E98F584100000000C572234133333353EC8F584100000000B372234166666646F08F58419A999999AB72234100000080F38F5841666666669D7223419A999919F88F58419A9999999172234100000020FE8F584166666666867223413333331302905841000000007B722341333333D3049058413333333370722341CDCCCCEC099058419A99999962722341CDCCCCCC0E9058419A9999994E7223413333337312905841666666662F72234133333333189058416666666627722341CDCCCC0C1B9058413333333320722341666666E61E90584133333333217223413333331324905841000000001E722341000000C0299058419A9999991D722341333333532E90584166666666247223419A9999F9329058419A9999992B72234133333353369058413333333327722341333333B33B905841666666661E7223419A99999940905841333333330E7223419A9999194790584166666666007223419A9999594A905841CDCCCCCCF1712341333333B34E9058419A999999E3712341000000A052905841CDCCCCCCE17123419A9999D9549058419A999999E5712341CDCCCC8C5890584100000000F3712341000000A05D905841CDCCCCCCF971234166666686629058419A999999F4712341CDCCCCAC6790584133333333E67123419A9999196D9058419A999999DC712341CDCCCCAC7290584100000000DC7123410000006073905841CDCCCCCCD9712341000000E075905841CDCCCCCCD3712341CDCCCCEC7A90584133333333B8712341CDCCCC8C819058416666666692712341333333F387905841000000006E712341666666668D9058419A9999994971234133333373929058413333333337712341CDCCCC2C94905841000000000F7123419A9999B996905841CDCCCCCCF3702341000000009890584133333333D0702341333333539990584166666666B1702341333333539A9058416666666695702341000000A09E9058419A99999985702341666666E6A19058419A99999973702341333333F3A6905841666666666970234133333333AC905841CDCCCCCC6270234133333333B39058416666666657702341000000E0BA905841333333334970234100000020C1905841CDCCCCCC3870234166666666C7905841CDCCCCCC3370234100000000CC9058419A9999993370234133333373CC9058419A999999307023419A9999D9D39058410000000025702341CDCCCC8CD7905841333333330C70234133333313DC90584100000000FF6F2341000000C0DE90584133333333FC6F2341000000A0DF90584100000000F26F23419A999919E39058419A999999E96F23419A999959E99058419A999999DC6F2341CDCCCC8CEF90584100000000CB6F2341000000A0F590584133333333AB6F23419A9999D9FD905841000000008A6F23419A9999390591584100000000756F234166666606099158419A9999995E6F2341CDCCCCAC0B915841666666664B6F2341000000800E91584133333333456F23410000004011915841CDCCCCCC486F23419A9999D91391584166666666506F2341333333131691584166666666766F2341CDCCCCAC1A9158419A999999C86F2341000000002491584166666666F06F23419A9999F9289158413333333305702341333333932E915841333333330E7023419A99991935915841666666660C7023419A9999F93A915841CDCCCCCCFE6F23416666660642915841CDCCCCCCDB6F2341333333934D91584100000000BB6F2341666666865891584133333333A46F23419A99991962915841CDCCCCCC996F2341CDCCCC6C6B91584133333333996F2341CDCCCC0C759158419A999999966F2341666666067E915841333333338A6F2341CDCCCC8C88915841000000007C6F23419A999959909158419A999999616F2341000000209A915841666666664E6F23419A999979A4915841666666664A6F234166666686AA915841CDCCCCCC446F234133333393B1915841666666663F6F2341333333D3B79158419A999999316F23419A999939BD915841666666661C6F234100000040C1915841CDCCCCCCFC6E234133333353C59158419A999999D76E2341CDCCCC0CCB9158419A999999C36E234166666606D091584133333333B06E2341CDCCCCECD49158419A999999916E2341000000A0DB91584133333333766E2341333333B3DF91584166666666676E2341CDCCCC8CE2915841666666665C6E2341666666A6E69158419A999999576E2341333333B3EA915841666666664A6E234166666686F2915841000000003A6E2341CDCCCCECF591584133333333266E2341000000C0F7915841CDCCCCCC086E2341666666A6F8915841CDCCCCCCA76D23419A9999D9F891584166666666266D2341000000E0F69158419A999999096D234100000060F691584100000000EF6C2341666666E6F591584166666666C56C234100000060F591584166666666AD6C23419A9999D9F5915841000000009D6C2341333333D3F6915841CDCCCCCC816C23419A999999F991584100000000726C2341CDCCCCACFC91584166666666606C23413333331304925841666666665B6C2341333333330C92584166666666566C2341666666E61792584133333333526C2341666666862192584133333333466C23410000004029925841CDCCCCCC2B6C2341666666E63192584166666666FA6B23419A9999993B9258419A999999CD6B2341CDCCCC0C4292584100000000976B234100000040469258419A9999994A6B2341CDCCCC2C4D925841CDCCCCCC286B2341000000A05192584133333333F06A2341CDCCCC6C589258419A999999D16A23419A9999795E92584100000000B56A23419A999959659258419A999999A46A2341CDCCCCCC6892584166666666906A23419A9999796E9258419A999999836A2341CDCCCC6C709258419A999999736A2341000000C0719258419A999999606A234133333333729258419A9999993E6A23419A9999197292584100000000126A2341666666467292584100000000E8692341000000007392584100000000B5692341333333D3759258419A9999995E692341333333737C925841CDCCCCCC2D692341000000C08192584133333333FE682341666666868792584166666666E3682341666666C68A9258419A999999D5682341CDCCCCAC8B92584166666666C2682341000000E08B92584100000000A9682341666666868A925841CDCCCCCC9B682341666666E689925841CDCCCCCC84682341666666E6899258419A999999746823419A9999F98A9258419A9999996B682341333333538D9258419A9999996C6823419A99995992925841CDCCCCCC806823419A9999F996925841666666668F682341000000E09B9258419A99999999682341000000E09D9258419A999999A0682341333333B39F9258419A999999A568234100000080A292584100000000A1682341666666C6A5925841666666669468234100000060AA925841CDCCCCCC7B682341CDCCCC2CAF9258410000000064682341333333D3B2925841CDCCCCCC47682341CDCCCC2CB6925841333333333068234100000000B8925841CDCCCCCC1B682341333333F3B8925841666666660D6823419A999959BA9258419A99999900682341333333F3BC92584100000000FA672341333333B3BF92584166666666F667234166666666C39258419A999999F467234166666626C692584100000000F767234100000080C7925841CDCCCCCCFA67234166666666C992584100000000F567234133333313CC925841CDCCCCCCE7672341CDCCCCECCE92584166666666DC672341CDCCCCECD092584166666666C76723419A999959D592584166666666B867234133333333DA92584166666666AE67234100000060DE92584133333333AA672341000000E0E292584166666666AB67234166666606E89258419A999999B267234133333313EE92584133333333BE67234166666686F4925841CDCCCCCCC867234133333353F992584166666666D7672341CDCCCCCCFD92584166666666E86723419A9999F900935841CDCCCCCCFC672341CDCCCCAC039358419A9999991868234166666646069358419A999999356823410000006009935841666666664A6823419A9999B90C9358413333333359682341CDCCCCAC119358416666666661682341CDCCCC2C17935841000000005E682341000000001E935841333333334F68234100000020249358413333333331682341CDCCCC0C299358419A9999991A682341333333B32B93584100000000FC672341333333D32D93584100000000DA6723419A9999592F93584100000000A267234166666686319358416666666680672341CDCCCCAC33935841666666666A672341000000A0359358416666666661672341CDCCCC8C3793584133333333586723419A999979389358419A9999994C672341CDCCCCAC399358413333333346672341CDCCCCAC3A935841CDCCCCCC3D672341666666C63B9358413333333330672341333333133C935841CDCCCCCC1A672341666666063C9358419A9999990C672341000000C03B93584100000000FD662341CDCCCCAC3B93584100000000E7662341000000203C93584166666666DC662341CDCCCC4C3D935841CDCCCCCCD2662341666666663F93584133333333D3662341000000A0419358419A999999DB662341000000A04393584100000000E9662341CDCCCC4C45935841CDCCCCCC1D6723413333331349935841CDCCCCCC44672341CDCCCCCC4B9358416666666658672341666666664E935841CDCCCCCC66672341CDCCCC6C519358413333333369672341333333535693584133333333646723419A9999F95A9358410000000056672341CDCCCC6C5F9358419A999999416723410000008062935841333333332A672341CDCCCCEC649358413333333309672341333333936693584100000000ED662341000000006793584100000000BA662341333333F366935841666666668B662341CDCCCCCC659358419A999999446623416666668662935841333333330C662341CDCCCC8C5F935841CDCCCCCCD3652341333333F35C93584100000000A6652341333333335C9358419A99999976652341000000605C935841CDCCCCCC3D652341333333F35D935841000000000B652341333333936093584133333333EC6423413333331362935841CDCCCCCCD4642341CDCCCCCC6293584133333333BA642341000000C062935841666666669F6423410000000062935841000000006B6423410000000060935841666666661F6423419A9999595B935841CDCCCCCCD3632341000000C056935841000000009063234166666626529358410000000063632341000000804F9358419A99999956632341CDCCCC0C4F935841666666664E632341CDCCCCCC4E935841CDCCCCCC42632341333333734E935841CDCCCCCC30632341333333334E935841666666661E632341CDCCCC4C4E9358419A99999915632341333333B34E93584166666666036323410000002050935841CDCCCCCCF0622341666666065293584133333333DA622341CDCCCCCC53935841CDCCCCCCC8622341000000A05493584133333333B86223419A9999D95493584100000000A86223419A99999954935841CDCCCCCC92622341CDCCCCEC5393584133333333846223410000000053935841666666666A622341CDCCCC0C5293584133333333506223410000002052935841CDCCCCCC32622341CDCCCCAC529358419A999999196223413333333354935841CDCCCCCCF86123419A99991957935841CDCCCCCCD9612341CDCCCC8C5993584100000000BB612341333333535B935841CDCCCCCCA3612341000000205C935841CDCCCCCC7D612341333333735D935841CDCCCCCC5F612341333333135E9358410000000040612341000000405F935841333333332C6123419A99997960935841000000001861234133333333629358413333333304612341CDCCCCAC6493584100000000F0602341333333336893584100000000DC602341333333536C93584133333333CA6023419A9999D97093584133333333BE602341333333B3739358419A999999B0602341CDCCCC2C76935841666666669D6023413333333379935841000000008B602341666666C67B935841CDCCCCCC7F6023419A9999797D9358419A999999736023419A99991981935841333333336D602341333333F3839358419A9999996D602341333333D386935841000000006E602341CDCCCCEC8A935841000000006B602341666666E68E935841CDCCCCCC656023419A999959929358413333333358602341CDCCCCCC95935841333333334D6023419A9999D9989358410000000046602341000000209D9358413333333339602341000000E0A49358419A99999934602341333333F3AB935841	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	01010000206A080000F4075A686E822341000000C0EC915841	150110000	Z	Arnac	1501100	15011	15	84	22
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	01010000206A080000FA19ED7E250C2441666666A6B47F5841	150120101	H	Nord	1501201	15012	15	84	11
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	01060000206A08000001000000010300000001000000CD0200009A9999992DF32341666666C6117D58419A99999978F32341CDCCCC0C147D58419A999999C0F323419A999939187D58419A99999926F4234133333313277D58416666666668F4234100000040367D58410000000096F42341CDCCCCEC457D584166666666BEF4234166666666567D5841CDCCCCCCDEF42341CDCCCC0C5E7D5841CDCCCCCC5EF523419A9999B9757D5841CDCCCCCCC8F52341000000C0837D58410000000041F62341333333F38F7D58419A999999BAF62341000000809A7D5841CDCCCCCC30F723419A999939A37D584166666666B1F7234133333333A97D58419A99999967F8234133333353AE7D584166666666DCF82341CDCCCC2CAD7D5841CDCCCCCC17F92341333333D3AA7D58416666666663F92341CDCCCC4CA47D5841666666668DF92341CDCCCC6C9E7D584133333333B3F92341000000A0937D584133333333CCF9234133333313897D58419A9999990AFA2341CDCCCCAC7B7D5841000000003FFA2341333333B3757D58413333333377FA23419A9999596B7D584166666666FEFA2341CDCCCC0C5B7D58410000000050FB234133333333537D5841CDCCCCCCE1FB2341000000A04A7D5841333333333BFC2341666666E63D7D58419A99999955FC2341000000003C7D584166666666A2FC2341000000203C7D58416666666661FD2341333333534E7D5841333333339BFD234100000060527D5841CDCCCCCC5AFE2341CDCCCCEC5B7D58413333333306FF2341CDCCCC6C677D5841CDCCCCCCE0FF2341333333B3767D58419A99999946002441333333137F7D58419A999999D8002441000000808D7D5841CDCCCCCC410124419A9999799A7D58419A9999997B012441CDCCCC4CA87D58419A999999800124419A999999B17D5841000000004B0124419A9999D9CB7D5841666666661301244166666666DD7D5841CDCCCCCC1301244133333373E87D58419A99999940012441CDCCCC8CF27D58419A99999990012441CDCCCC4C0F7E584100000000AC01244133333393137E5841CDCCCCCC14022441000000201E7E5841CDCCCCCC60022441000000E0207E5841CDCCCCCC95022441333333F3257E5841333333339802244133333313287E5841333333337202244166666646367E584166666666520224419A999979467E5841000000004C022441333333735E7E5841000000005B0224419A9999D9677E5841CDCCCCCC87022441CDCCCCEC727E584100000000AD022441CDCCCCAC787E58419A999999F5022441CDCCCCEC807E5841333333338C032441CDCCCC4C8C7E5841CDCCCCCC3704244133333393967E584133333333C6042441000000A0A77E58419A9999991705244166666626AD7E58413333333380052441666666A6AD7E584166666666F605244166666646A87E5841666666661E06244100000060A57E5841000000004F0624419A999939977E5841CDCCCCCC69062441333333B3917E584133333333A20624419A9999B98F7E5841CDCCCCCC62072441000000E08E7E584166666666B207244100000040937E584100000000EC072441333333739D7E584133333333FB072441333333B3A47E584166666666F207244133333313AA7E584100000000C00724419A999959B27E5841CDCCCCCC5007244100000040BF7E584166666666D6062441CDCCCCACC87E58419A99999991062441333333D3CE7E5841000000003F062441666666C6D37E584133333333110624419A999939D87E584166666666DF0524419A999979E17E584100000000B6052441CDCCCC0C087F584133333333C7052441CDCCCC8C137F584100000000C3052441666666A6207F584133333333CD0524419A9999F9297F584100000000EA05244133333313307F5841000000003A0624419A9999B9377F5841CDCCCCCCD3062441CDCCCCEC3C7F5841666666661407244133333333357F58419A9999994C072441333333132B7F58413333333383072441666666C61B7F584166666666A90724419A999939187F584166666666CB072441666666061A7F58413333333374082441CDCCCC6C2A7F584100000000CA082441333333933B7F5841333333330B092441333333B3437F584166666666320924419A999939447F5841333333339D09244166666666487F58419A999999D5092441000000404C7F5841000000006E0A2441000000204F7F5841CDCCCCCC930A2441CDCCCCAC527F58419A999999D00A24419A9999D95E7F5841CDCCCCCC100B2441CDCCCCEC647F584133333333700B24419A999939717F58419A9999998F0B2441CDCCCC4C727F58419A999999EE0B2441333333D36F7F584100000000420C244166666606727F5841CDCCCCCCC50C24419A999939717F584166666666F40C244100000020707F5841CDCCCCCC1B0D2441CDCCCC2C727F584166666666520D2441333333137A7F5841CDCCCCCC710D24419A9999B9777F584133333333720D2441CDCCCC4C707F5841000000008C0D2441CDCCCC6C6E7F584133333333C30D244100000080757F58419A999999C70D2441000000207D7F584133333333D90D2441333333B3827F584166666666FC0D2441CDCCCC6C857F5841000000003F0E2441333333B3847F584133333333710E244100000020887F5841CDCCCCCC760E24419A9999D98B7F5841333333336A0E2441000000009B7F5841333333334E0E2441CDCCCC0C9D7F584133333333450E244133333373A27F584133333333550E2441333333B3AB7F5841CDCCCCCC660E24419A999959AD7F58419A999999C20E2441333333D3AF7F5841666666661F0F2441333333F3B07F584100000000750F244100000020B47F5841CDCCCCCC2D1024419A9999F9BE7F58410000000075102441666666A6C47F584100000000B5102441333333D3C37F584100000000D3102441666666A6C87F58419A999999D410244166666666D67F5841CDCCCCCCC8102441CDCCCC2CDD7F584100000000B61024419A999939DF7F58419A9999992110244166666646E77F584100000000191024419A9999B9EA7F58419A999999840F2441000000A0F37F58419A9999994E0F244100000040FB7F584166666666420F24419A99997905805841000000001E0F2441000000C0108058419A999999E70E2441CDCCCC4C1C8058419A999999150E24419A9999993680584166666666980E2441333333335180584133333333C10E2441666666A6668058419A999999120F2441CDCCCC2C83805841CDCCCCCC300F2441666666A69080584100000000500F2441CDCCCC6C8F80584166666666730F24419A9999397C80584100000000B40F244166666666688058410000000016102441333333D3548058416666666671102441000000404880584100000000EB102441666666463B805841CDCCCCCC84112441333333F32F80584100000000E2112441333333132B8058416666666661122441CDCCCC8C268058416666666619132441CDCCCCEC23805841333333338F132441000000802480584166666666091424416666666626805841333333336F142441333333932980584100000000DD1324419A9999994B8058419A9999996D132441000000A04880584166666666261324419A9999994A805841CDCCCCCC12132441000000204D805841CDCCCCCC36132441000000E051805841CDCCCCCCF612244133333373518058416666666601132441666666A65C8058410000000020132441000000A05A805841666666665B1324419A9999D9608058419A99999974132441000000A05E8058419A999999D41324419A99997966805841000000002C142441333333136B805841CDCCCCCC6814244133333373678058410000000060142441000000606A805841CDCCCCCCE41424419A99991973805841CDCCCCCC91152441CDCCCC8C8580584133333333DD152441333333B396805841666666662B162441333333138A80584133333333401624419A9999B989805841333333336616244133333373838058419A99999994162441333333337680584166666666E8162441000000C06C805841CDCCCCCCF7162441666666E667805841CDCCCCCCD5162441666666865F805841CDCCCCCCF0162441000000605880584100000000E7162441CDCCCCAC518058419A999999F71624419A999979488058410000000001172441666666E6398058419A9999998B172441666666C63B805841CDCCCCCCDA182441333333D342805841000000008019244133333353478058419A9999994E1A2441333333534E80584100000000AC1A2441333333535480584166666666991A2441000000605A80584100000000A21A2441333333136480584166666666B91A2441333333D36780584133333333F91A2441000000A069805841000000004E1B2441333333B36980584133333333F81C24419A99995965805841CDCCCCCC791D24419A9999F96680584100000000EE1D2441CDCCCC6C638058419A999999591E2441666666465E80584100000000901E2441333333535D805841000000003B1F24419A9999795E8058419A999999C01F2441333333D35D8058419A9999992A202441000000805B8058410000000060202441000000E0588058419A9999999B202441000000005380584166666666DC202441333333534A805841666666660C212441CDCCCC4C468058419A999999562124410000000045805841CDCCCCCCCF212441666666863F8058419A999999DF2124410000006042805841CDCCCCCC42222441000000E041805841000000007E2224419A9999F93F80584100000000BF2224419A9999393B805841CDCCCCCCED222441666666663380584100000000E3222441CDCCCC4C2A80584100000000AF222441666666261F80584133333333A7222441CDCCCC8C1680584166666666C12224419A99997912805841CDCCCCCC0D2324413333339311805841333333337A2324416666666619805841CDCCCCCCEB23244166666646288058419A99999932242441000000A034805841666666664A242441333333D33E805841CDCCCCCC792424419A9999794A80584166666666BA24244133333393548058413333333342252441666666067180584133333333942524419A9999197E80584133333333F62524419A99997984805841CDCCCCCC3026244100000080858058419A9999992C26244133333353818058410000000045262441666666E67D805841000000006E262441666666467C8058419A999999902624413333337375805841CDCCCCCC0F27244166666626628058410000000001272441333333B35D805841000000003727244100000060588058410000000099272441333333B34980584166666666352724419A9999394380584100000000CF262441666666863A8058410000000021262441000000A02A805841CDCCCCCCF2252441333333D3278058413333333355262441333333530E805841000000004A272441666666461680584166666666D0272441333333D314805841333333330E28244133333373FC7F584133333333162924419A9999D9038058419A9999994929244100000060E97F5841000000005C282441666666E6E17F58419A9999997428244100000040D27F5841333333338C28244166666686AD7F5841666666666E282441333333D39E7F5841CDCCCCCCCE282441CDCCCC0C987F58419A999999D8282441CDCCCC8C957F58419A999999AA28244133333393877F584133333333B728244100000000827F5841CDCCCCCC08292441666666467B7F5841CDCCCCCC08292441666666C6787F58419A999999AE28244100000020757F584166666666A0272441666666266F7F58419A9999999F272441CDCCCCAC627F58419A999999082724419A999999527F58413333333386262441000000004A7F58413333333349262441333333533C7F584166666666C62524419A9999392C7F58413333333380252441CDCCCCCC297F5841CDCCCCCC48242441666666E60F7F584166666666BC232441CDCCCC8C087F584166666666C4232441333333D3EB7E584133333333E2232441CDCCCCCCE67E5841CDCCCCCC292524419A999979C87E58419A999999DD252441CDCCCC0CC77E5841333333330E26244100000000B37E5841333333335D262441CDCCCCACA77E5841CDCCCCCCCA26244133333353A17E5841CDCCCCCCFA262441CDCCCCCC857E5841CDCCCCCCA026244166666666837E584100000000BD26244166666626697E5841CDCCCCCC3E27244100000000697E58419A9999996F2724419A999939567E584166666666BC272441333333F3277E584166666666C4272441333333730C7E58410000000035282441CDCCCC4CFA7D5841333333331D2824419A999999F57D58419A999999F327244133333313E97D5841CDCCCCCCAD2724419A999979E57D584166666666E327244133333373DD7D58416666666602282441333333B3CF7D58416666666652282441CDCCCCECC97D58419A999999DE282441666666C6BB7D5841666666669D292441666666A6B57D58419A9999993C2A244133333313A57D58419A999999612A2441666666E69B7D584133333333A12A244166666606977D58419A999999832B2441CDCCCCAC8E7D58419A999999E12B24419A9999D9897D584100000000472C244100000080867D58419A999999312D2441CDCCCC0C847D58419A999999012F244133333333657D584166666666362F244133333393627D584100000000812F2441000000605C7D584133333333DF2F2441000000004D7D58419A99999969302441666666A63D7D58419A999999AA302441333333D3397D584100000000F2302441666666A6327D5841333333331E3124419A9999B92C7D5841333333333F322441333333F3157D58419A99999972322441000000E00D7D5841333333339332244100000040047D5841333333337C332441333333D3E97C58419A999999CE332441000000E0DC7C584166666666C033244133333373CB7C58419A999999DA332441CDCCCC6CCA7C58419A999999E0332441000000A0B57C584166666666EB33244166666686B07C58410000000025342441000000A0AB7C58419A9999994C3424419A999959AA7C58413333333362342441CDCCCC8CA07C584100000000FC332441333333939A7C5841333333337D3324419A999939997C584166666666213324419A999979957C58419A999999FC322441333333538F7C584133333333193324419A9999D9877C58416666666676332441000000A08E7C5841000000008D332441000000A0917C5841333333339C332441000000C0647C58419A9999994034244166666626517C5841000000007234244100000000467C58419A999999333324419A9999393A7C584166666666E6322441000000402A7C584100000000C3322441000000001C7C58419A99999977322441333333F31A7C58410000000068322441CDCCCCAC167C58419A9999990E3224419A999919187C584166666666D33124419A9999B90A7C58419A999999C831244100000040FE7B58413333333317322441333333F3E87B5841CDCCCCCC5132244166666626D67B5841CDCCCCCC6F322441000000E0D47B58419A999999C03224419A999919B67B584166666666CE332441000000C0927B584166666666863324419A9999598E7B5841CDCCCCCC5C3324419A9999F9877B5841000000001833244166666686807B58410000000084322441CDCCCCEC777B5841000000004032244100000040737B58419A99999907322441000000E06D7B58416666666680312441333333B35D7B5841CDCCCCCC50312441000000E0587B584166666666EE302441CDCCCC2C557B584133333333B82F2441CDCCCCEC507B584133333333572F2441000000604C7B584166666666F32E2441CDCCCC0C467B58419A9999998F2E2441CDCCCC0C4F7B584100000000FB2D24419A999979247B584100000000482E2441CDCCCCCC187B584133333333612E24419A999919067B584100000000202E24419A9999F9F97A5841CDCCCCCCEC2D2441CDCCCC4CE77A58419A999999C22D2441000000E0C67A58419A999999592C2441333333F3027B58419A9999992B2C244100000080097B58419A999999A12B244100000020257B5841CDCCCCCCAB2A244133333313607B5841666666665F2A2441000000E0767B584166666666C02924419A999919767B5841000000001529244133333373737B584100000000D728244133333393757B5841CDCCCCCC8C282441666666C67B7B584133333333F5272441CDCCCC6C8E7B58410000000077272441000000009A7B58416666666643272441000000E0A27B5841333333331B272441666666C6A67B584166666666DB26244166666686A97B5841333333334026244100000040AA7B584100000000DE252441CDCCCC4CAF7B584133333333B8252441CDCCCC2CB37B5841CDCCCCCC8D252441000000A0BC7B584100000000662524419A999919C37B5841000000002925244133333393BF7B58419A999999EE242441666666E6B07B58419A999999A3242441000000C0B27B5841000000006424244166666606A57B5841333333332D2424419A9999F99A7B584166666666EF2324419A9999998C7B5841CDCCCCCCC5232441000000C0887B5841CDCCCCCC642324419A9999D97B7B584166666666DA222441000000A0657B5841CDCCCCCCE5222441000000A0587B5841CDCCCCCC0423244100000060547B5841CDCCCCCC9D222441CDCCCCAC4B7B5841CDCCCCCC5722244166666686427B5841000000001022244100000020377B584100000000C82124419A9999D9307B5841CDCCCCCCAA212441333333F32A7B5841CDCCCCCCA1212441666666A61D7B58419A999999D0212441666666660F7B58419A999999F021244133333373FF7A5841CDCCCCCC2D2224419A9999F9F27A5841000000006722244133333373EA7A5841CDCCCCCCE62224419A9999B9DA7A5841000000007723244133333373C57A5841CDCCCCCCB8232441666666A6B87A584166666666FE2324419A999939A07A58410000000012242441000000E0977A5841CDCCCCCC2C24244133333353867A5841CDCCCCCC3A242441333333B3787A584166666666092324419A9999D96F7A584133333333092324419A9999596D7A5841666666664D232441CDCCCCCC517A58419A9999992E2324419A9999D9477A58419A99999906232441666666A6467A584133333333B72224419A9999F94C7A5841333333337B222441666666464E7A5841CDCCCCCC66222441CDCCCC0C487A584133333333BA22244166666686417A5841CDCCCCCC68222441000000E0347A58419A9999992622244100000080337A5841CDCCCCCC002224419A9999192B7A58419A999999F0202441333333D3E979584166666666C9202441000000C0EC795841333333339420244166666626DE7958419A99999989202441CDCCCC2CD47958413333333365212441CDCCCCACD2795841666666668C21244166666666C7795841CDCCCCCCD12124419A999999BE7958419A99999939222441333333F3B87958419A99999916222441333333B3A4795841000000001E2224413333331399795841CDCCCCCC4D222441CDCCCC8C8F79584100000000A1222441666666268A7958416666666651222441333333738179584100000000202224419A99999977795841CDCCCCCC10222441666666466B795841CDCCCCCC37212441000000C05E7958419A999999AF2024413333331359795841000000006E1F2441CDCCCCCC4E79584166666666991E2441CDCCCC2C44795841CDCCCCCC361E244100000000437958419A999999C31D2441333333134879584166666666901D24416666662648795841000000005E1D2441333333F34279584100000000ED1C2441666666464E79584100000000791C2441CDCCCC4C5C795841000000004D1C2441666666666479584166666666231C2441333333536F795841CDCCCCCCDF1B2441CDCCCC6C8579584100000000AD1B24419A9999399279584133333333861B2441666666269879584100000000071B2441333333F3A47958419A99999920192441000000A06E7958416666666666182441666666A654795841CDCCCCCC37182441333333134F79584133333333CD172441333333B348795841666666666C1724419A9999F9457958419A999999FD1624419A9999D9467958410000000091162441333333934679584166666666491624419A9999392E79584166666666671624419A9999B923795841CDCCCCCC66162441333333931C7958419A99999957162441333333F31279584100000000CE152441333333530979584166666666A4152441CDCCCCCC0379584166666666761524413333335300795841666666662815244100000000F67858419A999999FC142441CDCCCC6CF27858410000000098142441CDCCCCACEF7858419A9999997414244100000000F0785841333333334A142441333333D3F47858419A9999991F142441CDCCCC4CF77858419A9999997413244133333353FA785841666666660B1324419A999959FF78584166666666B7122441CDCCCC8CFB7858419A999999761224419A9999D9FC7858416666666659122441000000200179584133333333ED1124419A9999390A7958419A999999611124413333333318795841666666662C1124416666662620795841CDCCCCCCF3102441666666262279584166666666C4102441CDCCCC2C2B795841CDCCCCCC6D1024419A9999D92E795841CDCCCCCC53102441000000A031795841666666665B102441333333133A795841000000004C102441CDCCCCEC3C795841CDCCCCCCF80F2441333333D34579584100000000C90F2441666666A64779584166666666820F2441CDCCCCCC51795841CDCCCCCC5F0F2441CDCCCC2C5079584133333333390F244100000020547958419A999999E60E24419A9999D959795841CDCCCCCCAE0E24419A9999F959795841CDCCCCCC500E2441333333F35F79584166666666EA0D2441000000E064795841CDCCCCCC910D2441666666066F7958419A999999BE0C24419A9999797979584166666666710C2441000000E07B79584133333333710C2441000000E079795841333333332B0C244100000000787958419A999999E30B2441CDCCCC6C7879584133333333B30B2441CDCCCCAC7379584133333333660B2441000000C06279584100000000350B2441333333B35B795841CDCCCCCCE60A24419A9999B95779584100000000660A24410000008054795841333333333A0A2441000000205579584133333333AD092441CDCCCCCC5C795841666666667E0924419A9999595D7958419A9999996B092441666666C65A795841000000005909244100000060477958413333333363092441000000C04079584100000000940924419A99997930795841CDCCCCCC700924419A9999F92179584100000000460924419A9999992079584100000000FA082441CDCCCCAC247958419A999999B3082441CDCCCCAC2B7958413333333399082441333333732C7958419A999999E40724419A99999928795841333333337A072441333333B3257958413333333323072441333333D31F79584133333333D90624419A9999191C795841CDCCCCCC38062441CDCCCCAC1D795841666666665D0524419A9999591A7958419A999999F5042441CDCCCCAC13795841CDCCCCCC32042441CDCCCCCC0E7958419A999999DB032441666666060B7958419A99999999032441666666A60B7958413333333325032441CDCCCC4C0F79584133333333DD022441666666A6147958413333333394022441666666461E7958413333333340022441666666262E79584166666666ED012441CDCCCCEC3179584100000000B40124419A9999592E7958419A9999996F01244133333373317958416666666611012441333333F33C7958416666666683002441CDCCCCAC3D795841333333333A002441000000E039795841CDCCCCCC1C002441666666463B7958419A999999DAFF2341000000E0367958419A999999B4FF23419A999999387958419A9999999FFF2341666666C63F795841333333337CFF2341666666C641795841333333335FFF23419A999979487958416666666616FF2341000000E04A79584133333333DCFE2341CDCCCCCC4A795841CDCCCCCC95FE2341000000804D7958416666666630FE234133333333547958413333333333FE234100000080597958416666666601FE234133333313617958419A999999E4FD2341000000406C79584133333333C9FD2341666666E66F795841666666665AFD2341CDCCCCEC74795841CDCCCCCC24FD2341666666867A7958419A99999906FD23419A9999797A795841CDCCCCCCD5FC2341CDCCCC8C7F79584166666666C0FC2341666666C68979584133333333A2FC234166666686927958419A9999997CFC2341000000E0997958419A99999952FC2341333333939A7958419A99999903FC23419A999959997958419A999999FBFB23413333335395795841CDCCCCCCD6FB2341333333D39379584166666666CFFB2341333333B3997958419A999999AAFB23419A9999799D795841666666665FFB2341000000E09E795841666666661DFB2341666666E6A1795841CDCCCCCCDEFA23419A999939A279584100000000B6FA234100000080A47958419A99999966FA2341333333F3AD795841CDCCCCCC4CFA23419A999979B47958419A999999F1F9234100000080B679584133333333E6F923419A999919BB795841000000009CF92341CDCCCC2CBB7958419A99999905F92341000000C0C37958419A999999DFF8234166666686C37958419A999999C4F82341000000C0C67958419A999999A4F82341666666C6C579584100000000A1F823419A999939CF79584100000000DBF8234100000060E0795841CDCCCCCC02F92341000000A0E67958413333333376F9234100000040ED79584100000000B4F923419A9999F9F179584166666666EFF923419A999959F9795841CDCCCCCC25FA234166666646FD79584166666666B6FA23419A9999F90B7A58410000000053FB234100000060177A5841333333339CFB2341000000E01D7A58419A9999991EFC234166666686247A58413333333399FC2341000000C01E7A584100000000FDFC2341666666261C7A584166666666B3FD2341CDCCCCAC427A5841000000006EFD23419A9999794B7A5841CDCCCCCCEEFC23419A9999B9687A58413333333311FD23419A9999396C7A58419A99999902FD2341CDCCCCAC6E7A5841000000000AFD23419A9999F9777A5841CDCCCCCCFDFC2341000000607C7A58419A999999CCFC23419A999959847A584100000000D7FC2341CDCCCC6C887A5841666666666BFC23419A9999F98C7A5841666666663CFC23419A999939917A58419A999999F1FB2341666666469D7A584133333333C5FB2341666666E6A87A5841CDCCCCCC8EFB2341000000E0AE7A5841000000006BFB2341CDCCCC8CB57A5841CDCCCCCC45FB234166666626C17A58416666666602FB23419A9999D9CD7A58419A999999D1FA2341CDCCCCECD27A584166666666EFFA234133333333D67A58419A9999990DFB23419A9999F9D47A58413333333334FB2341666666E6D87A58419A9999999AFB234133333393D67A584166666666C4FB2341666666A6CC7A5841666666661DFC234166666686C77A58416666666683FC2341000000A0C67A5841CDCCCCCC98FC234133333313BF7A584100000000CDFC2341CDCCCCCCBE7A5841666666664BFD23419A9999D9C47A58419A999999F7FD234100000000C77A58413333333319FE234133333373C87A58410000000030FE2341CDCCCC6CCC7A58410000000035FE2341666666E6D47A58419A99999971FE234166666686DB7A584100000000B0FE2341666666C6DA7A584100000000D1FE2341333333F3D77A584100000000F9FE2341CDCCCCACD77A5841000000000DFF23419A9999F9DB7A58419A9999992BFF234133333353DB7A5841CDCCCCCC47FF23419A999919D77A5841333333336DFF2341CDCCCC0CD67A58413333333375FF23419A999939D17A5841CDCCCCCCA5FF234100000000D27A58419A999999C4FF23419A9999B9CC7A58419A999999E5FF2341333333D3CD7A58410000000018002441CDCCCCACBB7A58419A999999B2002441666666A6B97A584100000000170124419A999959BA7A584133333333A601244133333373B77A5841CDCCCCCCF201244100000060B37A5841CDCCCCCC24022441333333F3AA7A5841666666663E0224419A999959A97A584100000000650224419A999999AC7A58419A999999550224419A999979B17A5841333333337202244100000020C47A584100000000B602244100000020DE7A5841CDCCCCCCF80224419A999959E17A584133333333B7032441CDCCCCACEE7A584166666666AA03244166666626F47A58419A99999967032441666666E6F17A5841666666663F032441CDCCCC0CF67A58410000000010032441333333B3157B5841333333334B032441CDCCCCEC227B5841000000002303244100000080257B5841333333332D032441333333B3357B584100000000490424419A9999796B7B5841CDCCCCCCB0042441000000007D7B584133333333C00524419A999999A77B584133333333C30524419A9999B9AE7B5841000000006A052441CDCCCCCCD17B5841000000000605244166666666EA7B584100000000FA042441666666A6F07B58410000000000052441CDCCCCACF97B5841CDCCCCCC3805244166666686057C58419A9999991505244166666626117C58419A999999E404244166666626167C58410000000092042441CDCCCC2C1B7C58419A9999996004244100000000217C5841000000003F042441CDCCCC6C2E7C584166666666460424419A9999195A7C5841333333331F042441333333D3637C584166666666FB032441CDCCCC2C687C5841333333337903244166666626727C584133333333B70224419A9999397C7C5841CDCCCCCC6E022441333333F3837C5841000000006302244100000040997C58416666666615022441666666C6AB7C58419A9999990E02244166666606B67C58419A99999932022441000000C0BE7C5841CDCCCCCC8B022441666666A6C37C58419A999999B602244166666686CA7C58419A999999BD02244166666686D77C5841CDCCCCCCD9012441333333F3C87C584100000000F4002441333333F3C77C58419A999999F9FF23419A999939BF7C58413333333325FF2341CDCCCCACB27C584166666666B6FE2341000000A0AD7C5841000000003FFE2341666666A6A47C58419A99999902FE2341333333D39D7C58419A999999D6FD2341666666E6937C5841CDCCCCCCB6FD23419A999959897C5841666666663BFD234133333313767C58419A999999F4FC234100000020667C5841000000001CFC2341666666664B7C58410000000038FB234100000020337C58416666666683FA234166666646507C5841CDCCCCCC03FA234100000020727C584133333333C9F92341CDCCCCEC847C584133333333A9F9234166666686937C58410000000014F923419A999979977C584166666666B8F82341333333339B7C58419A99999967F823419A9999B99F7C58419A99999912F8234100000040A67C584133333333ADF723419A999939AB7C58419A9999992DF7234166666606AB7C584133333333DCF62341333333B3AC7C58413333333372F6234166666666B67C5841CDCCCCCCEBF523419A999999BE7C5841CDCCCCCC92F5234166666646C57C58413333333363F52341CDCCCC6CCD7C58410000000018F5234133333313DD7C584133333333C4F42341CDCCCC2CE87C58416666666683F4234166666646ED7C584133333333D7F323419A999919F77C58416666666682F32341666666E6FE7C5841CDCCCCCC30F32341333333330F7D58419A9999992DF32341666666C6117D58419A9999992DF32341666666C6117D5841	01010000206A08000042562384311B24419A999919C37C5841	150120102	H	Sud	1501201	15012	15	84	37
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	01010000206A0800009ABDB595C7AE25419A99993987A75841	150130000	Z	Auriac-l'Église	1501300	15013	15	84	20
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	01010000206A0800007AD1D0B3180324419A999979D5825841	150140101	H	République	1501401	15014	15	84	1
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	01060000206A08000001000000010300000001000000200000009A999999F6042441333333734A8358416666666633052441333333B35183584133333333CE052441333333D35583584133333333240624419A9999595D8358416666666656072441666666C6818358419A99999982072441CDCCCC8C838358413333333327082441CDCCCC2C858358410000000086082441CDCCCC0C8C8358419A999999BB082441CDCCCC8C8583584166666666AC092441333333F36C83584100000000030A24416666668660835841CDCCCCCC190A2441CDCCCC8C5A83584166666666E70924419A999939578358416666666694092441666666864C8358410000000067092441CDCCCCCC44835841666666660C092441666666062F83584100000000FE082441000000202883584100000000CC0824410000000019835841CDCCCCCC11082441CDCCCC8CF4825841666666669A072441CDCCCC8CDC8258410000000073072441CDCCCC2CE28258419A9999993607244166666686E4825841CDCCCCCCEB062441000000A0EA825841CDCCCCCC7B06244166666666FC8258416666666650062441CDCCCC4C00835841CDCCCCCC91052441333333B31E8358419A9999993A0524419A9999192B835841000000001B0524416666664632835841333333330A052441CDCCCC2C3A835841CDCCCCCC0305244166666666458358419A999999F6042441333333734A8358419A999999F6042441333333734A835841	01010000206A0800001487E30D1F0724419A9999A934835841	150140102	H	Saint-Géraud	1501401	15014	15	84	0
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	01060000206A08000001000000010300000001000000200000006666666647FD2341333333D3A4815841CDCCCCCCAAFD234133333353B28158419A9999992CFE2341000000A0C18158419A999999CBFE23419A999979D78158416666666626002441CDCCCC2C0A8258419A9999994E0024416666662603825841CDCCCCCC710024410000004000825841333333337E002441333333F3F681584133333333E60024419A9999B9D4815841000000000C01244166666606CC815841000000005201244100000080C08158410000000078012441CDCCCC2CBC81584133333333D001244100000080B7815841CDCCCCCC2902244133333333AE81584133333333A402244133333393A3815841CDCCCCCC840324419A99997992815841CDCCCCCCD7032441CDCCCC8C8A8158419A9999990904244133333373788158416666666689042441CDCCCCAC54815841333333332C0424410000006051815841CDCCCCCCC60224410000004049815841333333335C0224416666664647815841CDCCCCCCF4012441000000C046815841333333334C0124419A999959488158419A999999AA002441CDCCCC0C4D8158419A999999380024410000006052815841CDCCCCCCD5FF2341000000C058815841CDCCCCCC7BFF2341CDCCCCAC5F8158419A999999B9FE23419A99997973815841CDCCCCCCE1FD234100000020928158416666666647FD2341333333D3A48158416666666647FD2341333333D3A4815841	01010000206A080000EDFC94D9E6FF23419A999949A9815841	150140105	H	Tivoli	1501401	15014	15	84	0
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	01010000206A08000007AFAFC973092441000000D088825841	150140103	H	Aristide Briand	1501401	15014	15	84	1
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	01060000206A08000001000000010300000001000000460000006666666626002441CDCCCC2C0A82584133333333940024419A9999D91B8258410000000025012441000000C02F825841CDCCCCCC5D012441CDCCCC0C3982584133333333AB012441CDCCCC8C4982584133333333D3012441333333335482584166666666FE012441CDCCCC8C5B825841666666665902244133333373658258413333333347022441666666C66B825841000000009F022441000000607282584166666666D70224419A99995975825841000000004F0324413333333379825841666666667503244100000080768258419A9999997B032441666666667282584133333333D20324410000004072825841CDCCCCCCD8032441000000C074825841CDCCCCCC48042441CDCCCCEC738258419A999999630424419A999979728258410000000068042441666666466E82584166666666E00424413333331367825841000000001B052441CDCCCCAC6182584133333333C1042441333333B35382584166666666CA042441CDCCCCEC4C82584133333333460524419A9999793F8258419A9999995B0524419A9999B93782584100000000400524419A9999F92D8258419A99999926052441666666062C8258410000000065052441000000801F8258419A999999760524419A9999391782584100000000780524419A9999D9108258419A999999580524419A999999088258416666666613052441CDCCCCCC068258419A999999D504244166666686088258413333333394042441000000A0058258419A99999923042441666666E6ED815841CDCCCCCCF90324419A999959E281584100000000D80324419A999919D48158419A999999DE032441333333D3CE8158410000000009042441CDCCCCECC88158419A999999F0032441666666E6C5815841CDCCCCCCF6032441666666A6C0815841333333334A04244166666666B8815841333333336F0424419A9999B9B9815841CDCCCCCCC70424419A9999B9B8815841CDCCCCCCC5042441CDCCCC0CBC81584133333333EE042441000000C0BE815841CDCCCCCC2D052441CDCCCC2CAB815841333333336B0524419A9999998B8158419A9999996A052441333333137E815841CDCCCCCC54052441000000C0778158410000000008052441000000E06E815841CDCCCCCCE0042441000000C0678158419A999999DF042441333333B3608158410000000004052441666666465A8158416666666689042441CDCCCCAC548158419A999999090424413333337378815841CDCCCCCCD7032441CDCCCC8C8A815841CDCCCCCC840324419A9999799281584133333333A402244133333393A3815841CDCCCCCC2902244133333333AE81584133333333D001244100000080B78158410000000078012441CDCCCC2CBC815841000000005201244100000080C0815841000000000C01244166666606CC81584133333333E60024419A9999B9D4815841333333337E002441333333F3F6815841CDCCCCCC7100244100000040008258419A9999994E00244166666626038258416666666626002441CDCCCC2C0A8258416666666626002441CDCCCC2C0A825841	01010000206A08000001E2FBC85C02244100000050E8815841	150140104	H	Saint-Eugène	1501401	15014	15	84	0
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	01010000206A080000F61BA10C97FC23416666668636825841	150140106	H	Vialenc	1501401	15014	15	84	1
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	01010000206A080000C2E6400A2F042441666666368B835841	150140107	H	Alouettes	1501401	15014	15	84	1
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	01010000206A080000CA114D239D0E24419A9999B934845841	150140108	H	Limagne	1501401	15014	15	84	1
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	01010000206A080000E4138872D8192441333333A311845841	150140109	D	Zone Verte	1501401	15014	15	84	16
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	01010000206A08000006F9FCCE55072441CCCCCC7C8E805841	150140110	A	Ponétie	1501401	15014	15	84	2
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	01060000206A080000010000000103000000010000001C00000000000000A7FF2341CDCCCCEC158158413333333357002441000000E050815841CDCCCCCCE3002441000000004B815841333333334C0124419A99995948815841CDCCCCCCF4012441000000C0468158419A99999947022441000000204781584133333333630224419A999979278158419A9999998D02244166666606EE8058419A999999A7022441666666E6DA8058419A999999EB02244100000020C4805841666666662C032441666666A6AC805841666666662003244133333333A68058419A999999F9022441CDCCCCACA68058410000000010022441666666C6A480584166666666BF012441333333339F805841CDCCCCCC670124419A9999999580584100000000D00024419A999999AC80584166666666C50024419A9999D9AF80584100000000B5002441CDCCCC6CC6805841CDCCCCCCA50024419A9999D9D28058419A9999996600244100000000D9805841333333335C002441666666C6DE805841CDCCCCCC2200244133333313F08058413333333306002441333333F3018158419A999999F3FF234133333313038158419A999999E9FF2341CDCCCC6C1081584100000000A7FF2341CDCCCCEC1581584100000000A7FF2341CDCCCCEC15815841	01010000206A08000044CB72395501244133333343F2805841	150140111	H	Marmiers	1501401	15014	15	84	0
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	01010000206A0800001C9A506931FF23413433334324805841	150140112	H	Tronquières	1501401	15014	15	84	2
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