SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep18;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep18 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep18','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep18','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep18','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep18"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000B865F294B21D2441000000505C825941	180010000	Z	Achères	1800100	18001	18	24	13
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	01010000206A0800003290DEBF0553244100000030773E5941	180020000	Z	Ainay-le-Vieil	1800200	18002	18	24	14
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	01010000206A08000008769357F9592441333333B386785941	180030000	Z	Les Aix-d'Angillon	1800300	18003	18	24	15
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	01010000206A080000E655424768C4234133333383907D5941	180040000	Z	Allogny	1800400	18004	18	24	51
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	01010000206A080000F7711A9D5F9A23416666668641775941	180050000	Z	Allouis	1800500	18005	18	24	36
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	01010000206A08000024167067394A2441000000A084605941	180060000	Z	Annoix	1800600	18006	18	24	12
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	01010000206A08000058BEE0437964254134333323B7595941	180070000	Z	Apremont-sur-Allier	1800700	18007	18	24	31
01060000206A08000001000000010300000001000000D40100000000000090C32341333333B3865D5941666666669FC323419A9999398A5D59419A999999D6C3234133333393955D594166666666FCC32341CDCCCC2C9E5D5941333333330FC423419A999999A35D5941000000001FC4234166666686A95D59419A9999992BC4234133333333AE5D59413333333337C42341CDCCCCCCB15D5941CDCCCCCC43C42341000000C0B45D59416666666668C4234133333313BC5D59419A9999998CC42341666666E6C25D5941CDCCCCCCB1C42341CDCCCC6CCA5D5941CDCCCCCCD1C42341666666E6D05D594100000000F1C423419A999979D75D59410000000012C523419A999939DF5D5941CDCCCCCC30C52341333333F3E55D59419A99999946C5234100000040EA5D5941333333335EC52341000000C0EE5D5941333333336DC52341CDCCCC8CF15D59419A99999981C5234100000060F65D59410000000092C52341CDCCCC8CFA5D59419A999999A5C5234100000020005E594166666666C0C523419A999939075E5941CDCCCCCCF3C5234100000040135E59413333333316C62341333333931B5E5941CDCCCCCC3BC6234133333373245E5941666666666AC623419A9999B92F5E59416666666698C623419A9999B93A5E5941CDCCCCCCBEC62341000000E0435E59419A999999E7C62341000000404D5E5941333333330BC723419A9999D9555E59416666666630C723419A9999795E5E59410000000061C7234133333333695E59416666666688C7234100000060725E5941CDCCCCCCADC72341666666C67B5E594100000000D1C72341CDCCCCCC835E594100000000FEC72341333333338E5E5941CDCCCCCC23C8234100000040975E5941CDCCCCCC48C823419A9999F99F5E59419A9999996AC823419A9999B9A75E5941CDCCCCCC8BC82341666666E6AF5E59419A999999ABC8234166666686B75E594133333333D0C8234100000020C05E59419A999999F7C8234166666646C95E5941CDCCCCCC08C92341666666E6CB5E5941666666662EC9234133333313D25E59413333333347C92341CDCCCC6CD65E5941CDCCCCCC74C9234166666626DE5E594100000000B0C9234133333313E85E594100000000EAC923419A9999F9F15E5941CDCCCCCC26CA2341CDCCCC0CFC5E59416666666642CA2341666666A6005F59416666666648CA2341000000A0015F59410000000067CA2341CDCCCC8C065F59419A9999999ECA2341000000E00F5F594166666666BACA234100000060145F59419A999999FCCA23419A9999991F5F59413333333325CB234133333393265F5941CDCCCCCC09CA23419A999919485F594166666666D8C92341666666E6505F594166666666B3C9234133333353575F594100000000FAC82341333333736B5F5941333333339AC823419A999979775F59410000000046C823419A999919845F5941333333332AC823419A9999198A5F59413333333314C8234100000040935F59419A99999905C823419A9999399B5F594133333333F1C72341666666A6A95F594133333333E3C723419A999959AE5F594100000000D0C723419A999959B25F594100000000ABC723419A999959BA5F5941333333339EC72341666666A6BD5F5941CDCCCCCC5AC7234166666626D35F59416666666636C72341333333D3DF5F59419A9999991FC7234166666646EA5F5941000000001BC72341CDCCCCACEB5F5941666666668AC62341666666E615605941CDCCCCCC3CC62341333333F33860594100000000E9C523413333337395605941000000004FCA2341666666C696605941000000004ACA2341CDCCCC0C996059419A99999940CA2341000000409D6059410000000033CA23419A9999F9A36059419A9999992ECA23419A9999B9A5605941333333333FCA2341666666C6A56059416666666661CC2341000000A0A76059416666666662CC23419A9999D9AC6059419A99999966CC2341666666C6AF6059410000000075CC234133333353B66059410000000092CC234100000000C36059410000000021CC234100000080C46059419A999999FBCB234166666606EA605941CDCCCCCC7DCB23419A9999791A615941CDCCCCCCDBCB2341666666A6176159419A9999998FCC234100000080126159416666666601CD2341CDCCCC4C0F6159419A9999993BCD2341000000800D6159419A99999952CD2341000000C0176159419A99999973CD2341333333D327615941CDCCCCCC90CD2341000000203661594100000000A9CD23416666660642615941CDCCCCCCBCCD23419A9999394B615941CDCCCCCCD5CD2341000000E05661594166666666EFCD23419A9999D963615941000000000ECE2341666666A6736159410000000037CE2341333333F387615941666666664FCE23419A9999F9936159416666666662CE2341000000809D615941000000007ACE2341CDCCCC4CA96159419A9999998ACE234166666666B16159410000000096CE234133333353B66159410000000092CE234100000060B76159410000000077CD2341000000A0036259413333333389CC2341000000C0436259419A9999991BCC23419A9999396162594166666666D5CB2341333333937362594133333333B6CB2341666666867C6259416666666652CB23419A999959976259413333333326CB23419A999919A46259419A99999944C923419A9999B9E2625941CDCCCCCC79C92341000000E0EC625941CDCCCCCC25CA2341CDCCCC0CFE6259419A999999A1CA2341CDCCCCEC0663594100000000D3CC2341CDCCCC4C2F635941333333331CCC234100000020566359419A9999991ECB2341333333D37763594133333333D3CA2341CDCCCC2C8B6359416666666635CA2341333333F39B6359419A999999BEC92341000000E0BE635941666666668DC923419A999959CD6359419A99999984C9234166666646DD635941CDCCCCCC70C9234133333373006459416666666661CA2341333333D300645941CDCCCCCC09CB2341CDCCCC2C01645941333333339CCB2341CDCCCC6C0164594100000000AACC234100000000066459410000000056CD2341000000E0086459419A9999995ACD2341333333F308645941CDCCCCCC5DCE2341000000800D6459413333333361CF2341CDCCCC0C126459416666666664D023419A99999916645941CDCCCCCCC7D023419A9999791764594100000000C9D023419A9999D9156459419A999999D8D02341666666060D6459419A999999E1D02341333333330664594166666666EFD02341666666E6FF6359416666666602D12341666666C6F8635941CDCCCCCC1DD12341666666A6F1635941CDCCCCCC4FD1234133333353E66359416666666655D123419A999919E56359410000000056D1234100000000E56359419A999999A8D123419A9999F9D663594100000000C7D12341000000E0D063594133333333D8D12341CDCCCC6CCB6359419A999999F9D12341666666E6BF635941CDCCCCCC0DD2234133333353B8635941000000002DD22341666666A6AC6359419A99999978D22341000000808F635941333333337FD22341000000608D6359410000000081D22341CDCCCCAC8A6359410000000081D22341CDCCCCAC88635941CDCCCCCC7ED22341666666A6866359419A9999997DD223419A999979846359413333333377D22341CDCCCC0C816359410000000060D223419A999939786359419A99999906D42341333333B37D6359419A99999920D62341CDCCCC4C836359419A9999991FD62341CDCCCCCC816359410000000019D623419A99995979635941666666660ED62341333333336A6359413333333303D62341000000C05B63594133333333ECD52341666666E63C63594100000000EAD52341666666A63963594133333333CED5234100000040146359410000000099D62341CDCCCCAC0E6359413333333380D7234100000020166359416666666619D82341333333F30E635941666666664CD82341CDCCCC8C0C635941CDCCCCCC52D8234133333353056359419A999999C0D82341CDCCCC6C046359410000000002DA2341CDCCCC6C056359410000000048DA2341000000C0056359413333333338DA23419A999939FE6259419A99999905DB234100000000FA6259419A9999994FDD234133333333E86259416666666629DD234166666646CD6259419A99999998DD234166666666C9625941000000007EDD2341000000A0B9625941CDCCCCCC5FDD2341CDCCCCACAC6259419A9999994BDD234133333333A36259416666666633DD23419A99995997625941CDCCCCCC16DD23410000008088625941333333330EDD2341000000A08462594133333333FEDC2341000000A07C6259419A999999EEDC23419A9999D9746259419A999999D7DC2341CDCCCCEC6862594166666666C2DC2341666666865E6259419A999999ABDC2341CDCCCCCC52625941CDCCCCCCA2DC2341000000004E625941333333338FDC234133333353446259410000000081DC2341000000603C6259410000000076DC2341666666C635625941000000006DDC2341666666E62F6259410000000066DC2341666666062A625941666666665FDC2341CDCCCCCC236259419A9999995DDC23416666662622625941666666665CDC234166666686206259416666666657DC2341000000E01A625941333333334FDC23419A9999B907625941333333334BDC2341666666E6FA615941666666664ADC234166666626F3615941000000004ADC2341000000E0F2615941000000004ADC234133333353F2615941CDCCCCCC41DC2341000000E0DD6159419A9999993ADC2341666666E6C96159410000000037DC234166666626BD6159419A99999934DC2341CDCCCC8CB66159416666666631DC2341CDCCCCECAC615941000000002FDC2341CDCCCCACA3615941000000002ADC234100000060966159413333333329DC2341CDCCCC6C916159419A99999928DC23416666664690615941CDCCCCCC25DC2341CDCCCC0C7E6159413333333324DC23413333337373615941CDCCCCCC22DC2341666666A668615941CDCCCCCC22DC2341CDCCCC8C566159416666666623DC2341CDCCCCAC466159413333333324DC2341333333D33A6159410000000024DC2341000000202F6159410000000023DC234133333393216159413333333323DC2341666666A6156159410000000023DC2341000000E0086159410000000024DC234133333373FB6059419A99999923DC234133333393F06059419A99999922DC234100000080E36059416666666622DC2341333333F3D66059410000000023DC2341666666E6C96059410000000023DC234133333333BE605941CDCCCCCC22DC23419A9999F9B36059413333333323DC23419A9999F9A66059413333333323DC234166666606956059410000000022DC2341CDCCCCAC866059419A99999921DC2341CDCCCC2C7E6059410000000022DC2341666666C6716059410000000023DC2341333333F3666059410000000022DC23419A9999F95C6059416666666621DC23419A99995955605941CDCCCCCC21DC2341666666E64B605941CDCCCCCC21DC234133333333416059413333333321DC23419A999959396059413333333321DC2341333333F3356059413333333320DC23419A9999F933605941666666661EDC2341000000E031605941CDCCCCCC18DC23419A9999192C605941000000000EDC234166666626216059410000000002DC23419A9999B91460594100000000F5DB2341666666E60760594133333333E7DB23419A999939FB5F594166666666D7DB2341000000A0E95F5941CDCCCCCCD4DB234166666606E75F59419A999999C3DB234100000000D75F5941CDCCCCCCBADB234166666646D15F59419A999999B0DB23419A999939C85F5941333333339BDB234133333353BA5F59419A9999997EDB2341CDCCCCACA95F5941CDCCCCCC62DB234100000040995F59410000000047DB234100000020895F59419A99999939DB2341CDCCCCEC815F5941666666664BDB234100000080825F59410000000057DB2341CDCCCCAC835F59413333333367DB23419A999999865F59419A999999B7DB234100000000955F59419A999999EADB2341333333D39C5F594166666666F7DB23419A9999199F5F59413333333305DC234133333353A05F5941CDCCCCCC17DC2341666666A6A15F5941CDCCCCCC5BDC234133333333A45F5941CDCCCCCC75DC2341CDCCCCACA55F594133333333FADC23419A999979AA5F59419A9999999BDD234100000040B05F594133333333D9DD2341666666C6B25F59419A99999903DE2341666666C6B35F59410000000024DE2341CDCCCCECB35F5941CDCCCCCC2EDE234100000080B35F59413333333334DE2341000000A0B25F59413333333338DE234100000040B15F59413333333340DE2341CDCCCC0CB05F59419A9999994DDE2341CDCCCCACAF5F5941CDCCCCCC5CDE234166666626B05F5941000000008ADE234100000000B15F59419A9999998EDE234100000000AE5F5941CDCCCCCCEEDE2341333333B3755F59419A99999948DF23419A999959745F59410000000098DF2341666666866B5F5941333333338DDF2341CDCCCC8C615F5941CDCCCCCC5ADF23419A9999595B5F594166666666B1DF2341CDCCCC0C285F594133333333F7DF23419A9999F9275F5941666666661FE02341333333732A5F59413333333365E0234100000020295F594166666666ECE02341666666C6E15E59410000000045E12341333333F3CE5E59410000000026E1234100000000C05E5941333333335EE1234100000080A15E59416666666637E12341CDCCCC4CA05E59413333333305E123419A9999B99E5E5941CDCCCCCCB5E02341000000009C5E59416666666659E0234166666606995E59410000000013E023419A999999965E59419A999999D8DF2341333333B3945E5941333333339CDF2341666666A6925E5941CDCCCCCC50DF2341CDCCCC2C905E5941CDCCCCCC0FDF2341000000008E5E594166666666CADE2341CDCCCC0C8C5E5941333333338DDE23419A9999598A5E5941333333334FDE2341000000A0885E594166666666F4DD234100000020865E594166666666A4DD2341000000E0835E5941CDCCCCCC17DD23419A9999F97F5E594100000000B7DC2341000000607D5E5941666666667ADC2341333333137C5E5941000000002DDC2341CDCCCC6C7A5E5941CDCCCCCCF2DB23419A999919795E5941CDCCCCCC88DB2341666666A6765E594133333333F8DA23419A999959735E5941CDCCCCCC8CDA2341000000E0705E59419A99999937DA2341000000406F5E5941CDCCCCCC38DA23419A9999B96B5E5941CDCCCCCC38DA2341000000E0675E59413333333335DA2341666666A6605E59419A9999992FDA2341333333F35A5E59416666666627DA234133333393555E59416666666621DA2341CDCCCC0C515E5941666666661CDA2341666666264D5E59416666666616DA234133333373495E59416666666611DA2341CDCCCC8C455E5941666666660EDA2341CDCCCCEC405E5941666666660DDA2341000000203D5E5941666666660DDA2341CDCCCCCC395E5941333333330FDA2341CDCCCCAC375E59413333333311DA2341666666A6355E59413333333317DA2341666666662D5E59419A99999919DA2341CDCCCC4C295E5941000000001CDA234133333313265E5941333333331EDA2341666666C6225E59419A9999991FDA2341333333131F5E59419A99999920DA2341000000A01B5E59413333333321DA2341000000E0175E59410000000022DA234166666606145E59413333333322DA2341000000A0105E59413333333322DA23419A9999990C5E5941CDCCCCCC20DA2341CDCCCC2C075E5941CDCCCCCC1FDA234166666666035E5941000000001EDA234166666606FF5D59419A99999919DA2341666666C6FA5D59419A99999914DA2341666666C6F75D59416666666608DA234166666646F35D59416666666605DA2341CDCCCCECEF5D59419A99999903DA234166666686EC5D5941CDCCCCCCFDD9234166666606E65D594100000000F2D923419A9999F9DB5D59419A999999ECD92341CDCCCC8CD75D594166666666E5D923419A999959D15D594100000000D6D923419A999979C55D594133333333D2D923419A999939C15D5941CDCCCCCCCAD9234166666646B95D59419A999999C0D92341CDCCCC8CAE5D594133333333ABD92341666666E6985D594166666666A0D9234100000040885D5941666666669CD9234166666606835D5941333333339BD9234133333393805D59410000000093D92341000000E06D5D59419A99999991D923419A9999B96A5D59413333333388D9234100000000545D5941666666667CD92341333333B3335D59413333333373D92341CDCCCC0C1A5D5941CDCCCCCC66D9234133333373F85C5941CDCCCCCC5ED92341333333B3E15C59416666666654D923419A9999B9CE5C594166666666AAD8234166666626D15C59419A99999962D8234100000080B45C5941CDCCCCCC1BD823419A999919A85C5941CDCCCCCC3ED72341333333D3965C594100000000DAD6234133333333895C5941CDCCCCCCA6D62341666666C6775C594166666666B0D6234166666686715C594166666666D8D623419A999939705C594100000000ECD62341333333336B5C594100000000AFD62341666666065B5C59410000000068D62341000000604D5C5941666666663FD62341CDCCCC2C425C5941CDCCCCCCE4D5234166666646385C594166666666A2D2234133333373EF5B59416666666615D2234100000020DE5B59419A9999996AD12341CDCCCC4CCF5B59419A9999996BD023419A9999F9C65B59410000000051D0234166666646C55B59419A99999905D023419A9999D9C05B594133333333C5CF234100000040BC5B59413333333372CF2341CDCCCCCCB85B5941CDCCCCCCF9CE23419A9999D9B35B59419A99999998CE2341666666A6B05B594100000000EBCD234166666626AC5B5941CDCCCCCC8BCD2341CDCCCC4CA95B5941333333330DCD234100000020A75B594100000000B7CC23419A999959A35B5941CDCCCCCC9FCC23419A999939A35B5941333333337FCC234133333393A25B59416666666666CC234100000040A25B5941CDCCCCCC55CC2341333333B3A15B59413333333336CC2341CDCCCC2CA05B5941CDCCCCCC22CC2341000000209F5B59410000000075CB234133333373925B59416666666668CB23419A999979955B5941333333334DCB2341CDCCCC6C9C5B59416666666643CB23419A9999D99E5B59410000000033CB234166666686A35B59410000000026CB234133333333A75B5941666666661ACB23419A999959AA5B59416666666602CB2341CDCCCCACAF5B5941CDCCCCCCEECA2341CDCCCCACB35B594100000000EBCA23419A9999D9B55B5941CDCCCCCCEDCA2341000000E0B75B59419A999999F2CA2341333333F3B95B59419A999999F5CA23419A9999D9BC5B594166666666F6CA2341CDCCCCECBE5B594166666666F8CA2341CDCCCCECC05B5941CDCCCCCCEECA234133333313C35B5941CDCCCCCCE3CA234133333373C55B5941CDCCCCCCC6CA2341CDCCCC6CCB5B594100000000BBCA2341CDCCCCECCD5B59413333333398CA234133333353D55B5941CDCCCCCC8ECA23419A999979D75B59416666666668CA234166666646E05B5941CDCCCCCC36CA23419A999999EA5B5941CDCCCCCC14CA23419A999979F15B59416666666600CA2341666666A6F55B594133333333EDC9234133333353FA5B594166666666D4C9234166666666FF5B594166666666B6C92341CDCCCC8C055C594100000000B1C9234166666626075C594100000000A5C92341333333F3095C594100000000DFC72341333333F3F45B59410000000019C723419A999939435C59419A99999913C72341666666A6455C59419A99999934C7234133333333475C59419A999999ABC72341666666264B5C5941666666660AC82341333333334D5C594133333333DCC8234133333313565C59419A999999D4C823419A9999595E5C5941333333335BC9234133333313655C594166666666FDC8234133333373765C594100000000EAC823419A9999B97C5C59416666666658C923419A999919845C59419A99999962C92341333333D3875C59416666666672C8234100000000B75C5941CDCCCCCC42C823419A9999D9CB5C594133333333FBC7234133333393205D5941CDCCCCCC90C62341000000A08D5D59413333333383C623419A999999905D5941CDCCCCCCEEC52341666666468E5D59419A9999990FC523419A9999598A5D5941CDCCCCCCF3C423419A9999D9895D59410000000046C423419A999919875D594100000000F7C3234100000000865D5941CDCCCCCCC3C323419A999959855D5941CDCCCCCC92C3234100000080845D59410000000090C32341333333B3865D5941	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	01010000206A0800004F09D8F48AD1234133333313D55F5941	180080000	Z	Arçay	1800800	18008	18	24	18
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	01010000206A0800002862E08440032441000000A05D405941	180090000	Z	Arcomps	1800900	18009	18	24	21
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	01010000206A0800001E0E78BCDCD923419A999939743D5941	180100000	Z	Ardenais	1801000	18010	18	24	18
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	01060000206A080000010000000103000000010000009B010000333333339FDF23410000002051A2594133333333B1DF2341333333335DA2594100000000D9DF23413333333364A259410000000016E02341000000006AA259410000000013E12341333333137DA2594100000000E2E12341333333538AA2594100000000DBE22341CDCCCCEC96A259419A99999952E323419A9999199EA2594166666666CBE323419A999979A9A259410000000025E42341666666A6AEA259410000000015E5234133333373BEA259413333333347E52341666666E6C0A25941CDCCCCCCFFE5234133333313C3A259419A999999A0E6234100000080C3A259416666666646E723419A9999D9C5A25941000000007FE72341000000A0CCA25941000000005AE823419A999939D3A259416666666699E82341000000C0D8A259410000000008E9234166666606DCA25941000000003FE923419A999919E5A259419A999999B1EA23413333339305A3594166666666D6EA2341666666660AA3594166666666D5EB23413333339328A35941CDCCCCCCD6EB2341000000402CA3594166666666A0EC23416666668646A359416666666676EF234100000040A7A359413333333354F0234100000040C6A359419A99999972F023419A999939CBA359419A9999995AF1234133333333EAA35941CDCCCCCC96F12341000000E0EDA359419A99999918F2234100000080ECA359419A9999995AF42341666666A6D6A359410000000040F523419A9999F9D1A3594100000000AEF52341CDCCCC4CD1A35941CDCCCCCCACF7234100000080E3A35941666666666BF82341CDCCCC0CECA35941000000001AFA2341333333D3FBA35941666666661AFA2341333333D300A45941CDCCCCCCC1F92341666666E614A459419A999999A5F92341CDCCCC2C2FA459419A999999C4F92341000000603FA45941666666660BFA2341CDCCCC4C49A459416666666610FB2341000000005DA45941666666669DFB23419A9999196DA459419A999999B0FB2341CDCCCC2C7EA4594133333333BEFB2341CDCCCCCC82A45941000000000BFC2341CDCCCCEC91A4594100000000A1FC234166666666B3A4594166666666DBFC234166666626BDA45941666666663BFD23419A9999F9BCA459419A9999999FFD234133333353B9A4594166666666EFFD234166666666BAA459413333333329FE2341CDCCCCACC2A4594133333333B4FE23419A999979C7A4594166666666D9FF234166666626D0A459419A9999993A0024419A9999B9D1A4594166666666A3002441CDCCCCACD4A45941666666669802244166666646FCA45941CDCCCCCC13032441CDCCCC0C04A5594100000000600324416666660607A55941CDCCCCCCCE032441666666C60CA5594100000000FD042441666666661FA5594100000000440524419A9999B924A5594166666666940524410000006028A5594133333333ED0624419A9999D935A55941666666660A0824410000008040A55941CDCCCCCC1D0924419A9999B949A5594133333333D40924410000002051A55941CDCCCCCCC60924419A99991955A559419A999999790A2441000000005DA5594133333333830B2441666666866AA55941333333334D0C24410000004073A5594133333333380D2441CDCCCC8C7BA55941CDCCCCCC900D24419A99993983A559419A999999F60D2441333333738EA559419A9999994E0E24419A99995994A5594100000000CC0F2441000000A0A6A55941666666668110244100000040B1A559419A9999992C112441CDCCCC0CC5A5594133333333C3112441000000E0CEA559419A99999981122441CDCCCC2CD6A5594166666666EF122441CDCCCC0CD6A55941CDCCCCCCB61324419A999959CEA55941666666669415244100000020B1A559419A9999998D162441000000E0A6A55941CDCCCCCC0E172441000000C09CA55941CDCCCCCC711724416666662690A559419A999999FF1824410000000073A55941CDCCCCCC031A2441000000A063A5594100000000F11924413333331341A5594166666666D31924416666662624A55941CDCCCCCCCA1924419A99991910A5594166666666A41A244166666666EFA45941666666668C1C2441666666A6B0A4594133333333251C2441000000A09DA4594133333333651B2441CDCCCCAC7BA459419A999999521B2441CDCCCC6C7AA4594166666666591B2441CDCCCCCC6AA4594133333333281D2441666666A62AA45941CDCCCCCC871D24419A9999F913A459419A9999995F1E24419A9999B9F4A35941666666664A1F2441666666E6D9A3594166666666761F2441333333D3D2A359416666666691202441CDCCCCACAEA35941000000008A222441CDCCCCCC62A35941333333333E252441CDCCCC0C04A359413333333387282441333333B38DA259410000000099282441333333738AA25941CDCCCCCCC12B2441666666064CA25941CDCCCCCC6A2C2441000000203EA259419A999999452D2441666666E62EA259419A999999892D24419A9999D910A2594100000000E12D24419A9999F90FA2594166666666DC2F244133333353F6A15941000000007E3124419A9999D9ABA1594133333333873124419A9999599FA159410000000098312441000000E06FA1594133333333D2312441333333D356A159419A999999F9312441CDCCCC4C4FA159419A999999583224410000004004A15941333333336032244100000040E1A05941333333334B322441CDCCCC0CD1A05941CDCCCCCCB23124419A999939AEA0594133333333573124419A99991994A059413333333323312441CDCCCCEC74A059410000000001312441CDCCCC2C59A0594166666666383324416666664649A059413333333312332441333333B32FA0594100000000C2322441666666862EA05941CDCCCCCC7B3224419A9999D92AA0594100000000D1312441CDCCCC4C1DA0594166666666803124416666662612A059419A9999997D312441CDCCCCECE89F594166666666543124419A999979D79F59413333333394302441333333B3B49F594166666666512F2441333333D3869F594166666666412F244100000060829F594100000000AB2F2441000000C07E9F59419A999999ED2F244133333373789F594166666666E62F2441666666A6709F59419A9999995F302441CDCCCC0C5B9F59419A9999998D302441000000A0589F594166666666C7302441333333334F9F594133333333CA302441CDCCCC8C469F594166666666F53024419A9999193E9F59419A999999EA302441CDCCCC8C3A9F594100000000A7302441333333D3349F59413333333349302441CDCCCCAC279F5941CDCCCCCC4A302441CDCCCC6C1F9F5941000000008C302441333333331C9F594100000000B3302441333333131E9F5941CDCCCCCCDD3024419A999959269F59413333333306312441CDCCCC8C239F59410000000018312441CDCCCCAC179F5941CDCCCCCC4731244133333393129F5941CDCCCCCCE831244166666626069F594133333333013224419A9999D9019F59416666666606322441000000E0FA9E594100000000DB3124419A999939F99E59419A999999C5312441CDCCCC4C009F5941CDCCCCCCAB312441666666A6009F5941666666665A31244166666666F79E594166666666083124419A999979F99E594166666666FB302441333333B3F79E594133333333FB302441CDCCCC0CE99E59419A9999995730244166666606E79E594100000000FC2F244133333393D99E594100000000A92F24419A999979CA9E594166666666512F244133333393BC9E594100000000232F2441000000C0B09E59419A999999BC2E244100000060A09E594100000000872E2441666666669B9E5941333333331F2E244166666646999E594133333333A42D2441CDCCCCAC9A9E594100000000762D2441000000009A9E594166666666452D2441666666C6959E5941000000000D2D24419A9999198E9E5941CDCCCCCC102D24419A999939859E594133333333F72C24419A9999197B9E594166666666572C24419A9999F9599E594166666666FD2B2441333333934A9E5941CDCCCCCC8E2B244100000020399E59419A9999990A2B24419A999919289E59419A999999D92A2441CDCCCCCC189E59419A999999692A244133333373F89D59416666666662292441000000C0C69D5941000000006D282441000000E0B19D5941333333338E28244166666686A59D59413333333379282441666666E6999D594166666666D3282441333333B3989D5941666666669A2924419A9999398D9D59419A999999582A2441333333B3849D594100000000AC2A24419A999979869D59419A999999DE2A2441000000807F9D5941000000008A2B2441CDCCCCEC749D5941CDCCCCCC372C2441000000406F9D5941CDCCCCCC6B2C24419A9999B96F9D594166666666862C2441000000A06C9D594100000000252D24419A9999D9669D59419A999999CA2D2441000000205A9D5941CDCCCCCC1E2E2441CDCCCCAC579D594100000000232F2441666666664A9D594133333333CC302441CDCCCCAC2C9D5941CDCCCCCC92302441CDCCCC2C249D594133333333FF2F244100000000179D59419A9999999A2F2441333333D3149D5941CDCCCCCC672F2441000000200D9D594133333333002F244100000080019D594100000000C22E244166666686FB9C594166666666592E244166666626EE9C59419A999999112E2441000000C0E69C59419A999999EF2C2441CDCCCC6CD09C5941CDCCCCCCBF2C244166666686CA9C59419A9999994F2D244166666646BF9C594166666666922D2441000000C0B89C5941333333330B2E2441CDCCCC6CAB9C594100000000FD2D24419A999939979C5941CDCCCCCC9D2D244166666666479C594133333333602D24419A9999792E9C594100000000232D2441CDCCCC4C1E9C594166666666842C24419A999939119C59419A999999D72B2441CDCCCCAC059C5941CDCCCCCC542B244133333313F89B59419A999999632A244133333353E49B594133333333132A2441CDCCCCACDB9B59410000000022292441333333B3C69B5941333333331C28244100000040AA9B5941CDCCCCCCAD2724419A9999D9A29B594166666666A723244133333373929B59419A99999994232441333333F3A39B59419A999999A9232441CDCCCC2CB49B594166666666AB23244166666666CE9B594133333333D423244166666686DE9B59419A99999917242441CDCCCC8C0D9C5941000000001C24244100000060149C5941666666660624244100000040179C594100000000EE23244166666646139C594166666666B1232441000000E0119C59419A99999937232441000000A0089C594166666666FB22244166666606099C594166666666C3222441CDCCCC8C0C9C59419A99999976222441666666860F9C5941CDCCCCCC4B222441333333F30E9C59419A99999910222441000000E0079C5941CDCCCCCCB72124419A9999F9019C59419A999999F120244133333333019C594133333333271F244166666646FE9B5941CDCCCCCC531E244133333353E19B5941CDCCCCCC221E244133333353D89B594166666666A31D24419A999959CF9B594166666666371D244166666646C99B5941CDCCCCCCAD1C24419A999919C49B594133333333231C2441333333D3BC9B59419A999999651B24419A9999D9B09B5941CDCCCCCC1B1B244133333353A59B594166666666CE1A2441CDCCCCCCAA9B5941CDCCCCCC0D1A24419A9999F9B09B594133333333771824419A999999B89B59416666666646182441000000C0B89B5941333333338E152441333333B3D69B59413333333335152441666666A6D99B59419A999999B8142441CDCCCC6CE29B5941666666664214244100000060E99B59419A9999999F132441000000C0ED9B5941666666666F1224419A9999F9F39B594133333333B911244166666646F89B5941666666668011244133333373FB9B5941333333334B112441666666A6039C5941CDCCCCCC1311244100000000109C59419A9999993C0F2441CDCCCC2C7D9C594100000000A40E24419A9999F99D9C59419A999999570E24419A999919A49C594100000000D10D244100000040AD9C59419A999999470D24419A999999B29C594166666666460C2441CDCCCC0CB89C5941666666660A0B244100000040B79C594133333333FA0924419A9999F9BB9C59410000000049092441CDCCCC8CC29C5941CDCCCCCC2809244166666626C29C594166666666BE08244133333333CD9C5941CDCCCCCCCC0724419A9999F9E99C594166666666F7062441000000C0F59C594166666666B50624419A9999B9009D59419A99999948062441333333D30F9D5941CDCCCCCC20062441000000A0139D594166666666D0042441333333B3449D59419A999999EC0324419A9999B9619D594133333333B6032441333333D36C9D594100000000760324419A999979869D5941666666665A0324419A999959969D5941CDCCCCCC4502244166666686C89D594100000000BB01244166666626DA9D5941333333332A012441CDCCCC2CE59D5941000000001201244133333393E59D59410000000097FF23419A999979F29D594100000000F8FE2341000000E0FD9D5941CDCCCCCCA8FE234133333333099E594166666666A9FE234133333333139E59419A99999978FE23419A9999B9249E5941666666663EFE2341666666C63D9E594100000000F9FD23419A9999D9479E5941666666663CFD234166666646589E5941666666669EFC2341CDCCCCEC739E5941333333336AFB23419A9999398D9E594166666666E9FA23419A9999999D9E59413333333387FA234133333373B59E5941000000006AFA23419A9999F9C19E59419A99999907FA2341CDCCCCCCD99E59419A999999AEF92341000000A0E79E5941333333337DF92341CDCCCC6CF09E5941CDCCCCCC4CF92341CDCCCC0CF59E59410000000043F9234166666646F99E59419A999999FBF8234133333393009F5941CDCCCCCCA7F8234133333313079F59410000000036F82341CDCCCC2C099F5941333333339DF72341333333930E9F5941333333334AF7234166666626189F59410000000008F72341CDCCCC6C1C9F594100000000DCF62341CDCCCC8C1D9F59419A99999966F6234133333393199F594133333333FDF52341666666E6129F594166666666D2F52341CDCCCC4C119F5941CDCCCCCC55F52341CDCCCC4C169F5941CDCCCCCC5FF42341000000C01E9F59419A99999919F423419A9999391F9F5941666666669CF3234133333313229F59416666666637F3234166666626239F594166666666BAF2234100000020229F5941333333338DF22341000000C0229F59419A99999923F22341000000E02A9F5941CDCCCCCCDEF12341CDCCCC0C2E9F5941CDCCCCCC9BF123419A9999192F9F5941000000001AF12341000000202C9F594100000000F3F023419A9999592C9F59419A999999AFF023419A999979299F594100000000F1EF234133333353289F594166666666D0EF23419A999959299F59419A99999958EF2341CDCCCC0C319F5941CDCCCCCC1BEF2341666666A6339F59419A99999984EE2341CDCCCCEC369F59419A9999999FED2341CDCCCCCC3E9F5941CDCCCCCC06ED2341000000A0449F594166666666DBEC234133333333479F59416666666648EC234166666626479F59419A99999902EC2341666666A64D9F594100000000E5EB2341CDCCCCAC4E9F59419A99999997EB2341000000C0569F59413333333361EB23419A9999F95F9F59416666666655EB23419A999999679F59413333333339EB2341666666C6699F5941333333332DEB2341666666466E9F594100000000F2EA234133333313719F59419A9999999CEA23419A9999F9779F59416666666674EA234133333333819F59416666666662EA2341000000608A9F59410000000004E92341333333F3B09F594166666666A0E82341333333F3B59F59410000000023E8234133333333C89F5941CDCCCCCC16E8234166666626CD9F59419A999999F6E72341CDCCCC2CE39F59413333333303E82341666666C6E79F5941CDCCCCCC43E8234166666626EB9F59416666666624E82341666666E6FD9F59419A99999913E82341333333D301A0594166666666F8E723410000004011A0594133333333B1E723419A9999D91BA05941CDCCCCCC4FE72341666666862DA059419A9999993DE723410000000033A059416666666604E72341333333D33BA059410000000091E62341CDCCCC0C45A05941CDCCCCCCDFE52341666666A654A05941000000009CE52341333333335CA05941333333338EE523419A9999F96FA05941CDCCCCCC5BE52341000000A098A059410000000049E5234166666606B2A059419A9999993BE52341666666A6B9A05941CDCCCCCC1CE5234100000080C0A0594166666666BBE42341CDCCCC6CCFA05941333333339DE4234100000040DFA05941CDCCCCCC7CE4234100000000E4A059410000000032E423419A9999D9EBA0594166666666AEE3234166666646F5A05941CDCCCCCC7AE3234133333373FBA05941000000003AE32341CDCCCC6C07A15941CDCCCCCC1BE323419A9999D917A15941666666660CE32341666666661AA15941666666668EE22341000000C021A159410000000018E223419A9999F929A15941CDCCCCCC31E22341333333132DA15941333333334DE223419A99999937A15941666666662FE22341666666E642A159410000000029E22341333333F349A15941666666665EE223419A9999995BA159419A99999975E22341CDCCCC0C67A159416666666628E22341000000006BA1594133333333E2E12341333333D369A15941CDCCCCCC87E12341CDCCCC2C61A159413333333370E12341CDCCCCCC60A15941CDCCCCCC1CE123419A99993995A15941CDCCCCCCFEE02341CDCCCC8CA3A1594133333333C4E023419A999959AEA15941000000007DE023419A999999B7A159413333333363E0234100000080C3A159419A99999956E02341CDCCCC0CD7A159416666666635E0234166666646FAA159419A9999992BE02341333333930EA259419A99999913E02341666666A62EA25941CDCCCCCCFCDF23413333333339A259419A999999B4DF2341333333734AA25941333333339FDF23410000002051A25941333333339FDF23410000002051A25941	01010000206A080000C287A43A8B0B2441666666D6B5A05941	180110000	Z	Argent-sur-Sauldre	1801100	18011	18	24	67
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	01010000206A0800006A1A7ED18758254100000030C9725941	180120000	Z	Argenvières	1801200	18012	18	24	15
01060000206A080000010000000103000000010000001503000066666666F63D244166666606964F5941CDCCCCCC003E2441000000809D4F594100000000473E2441CDCCCCEC9F4F594133333333A73E2441333333539F4F59419A999999413F2441000000E0B34F59419A999999643F24419A999959BE4F594166666666653F244133333313CA4F59419A9999994C3F2441CDCCCCCCCE4F59419A999999403F2441CDCCCC0CD54F5941666666664A3F244133333353D94F59419A999999893F2441666666A6E24F5941666666669E3F2441666666E6E54F59419A9999992D4024419A999939FC4F5941000000006040244133333333035059419A999999B34124413333337329505941666666662E42244133333353395059419A999999BF422441333333D34F5059410000000028432441CDCCCC2C655059419A99999990432441666666867A50594133333333C9432441CDCCCCAC8250594166666666E943244133333393895059419A999999F1432441333333938B505941000000006E442441333333B3AA5059419A999999C044244166666626BE505941000000004F4524419A999979DA505941CDCCCCCCF2452441666666C6EF505941666666667A46244133333353045159419A99999969472441666666E630515941666666666D472441666666E63251594133333333754724419A99991937515941666666667E472441666666863A5159413333333388472441666666263E5159419A999999AF4724419A9999794951594133333333B947244100000000485159419A999999C947244100000080445159416666666670492441666666E6EF505941CDCCCCCC74492441666666A6BA505941CDCCCCCCDC492441000000C099505941333333339F4A244100000040755059419A999999F74A2441CDCCCC2C6F50594133333333FE4A2441000000809650594133333333FA4A244166666606A15059419A9999992B4B244166666606DF505941CDCCCCCC964B24416666664684515941333333339A4B24419A9999598A51594166666666AC4B244133333313A95159419A999999B44B244133333313B3515941CDCCCCCCB54B2441CDCCCC8CB4515941CDCCCCCCC64B24419A999999B451594133333333E94B2441CDCCCCECB5515941CDCCCCCCFB4B244166666666B7515941CDCCCCCC0A4C244133333393B8515941333333333D4C244166666686BC5159419A999999444C2441333333D3BC5159419A9999994F4C244100000000BD515941000000005E4C24419A9999D9BC515941CDCCCCCC724C2441000000A0BB51594133333333914C244166666646B851594133333333964C2441666666A6B751594100000000A44C2441000000E0B55159419A999999204D244100000000A6515941000000002C4D2441000000A0A451594133333333354D24419A9999B9A451594133333333994D244133333313A6515941CDCCCCCC6A4E2441666666A6A8515941CDCCCCCCEA4E244166666666AA51594100000000CF4F244100000040AD5159416666666651502441CDCCCC0CAF5159419A999999DA502441666666C6B0515941CDCCCCCCDE502441CDCCCCCCB051594133333333EE50244166666606B1515941333333334251244133333333B2515941666666664651244133333353B251594100000000AF5124419A999979B351594100000000CA512441CDCCCCECB35159416666666619522441666666E6B451594100000000355224419A999959B5515941000000007F52244133333333B651594100000000A9522441666666C6B6515941CDCCCCCCF0522441CDCCCCACB7515941000000005253244166666606B95159419A99999966532441CDCCCC4CB951594133333333E953244100000020BB515941CDCCCCCC6B542441000000C0BC51594100000000E55424419A999939BE515941CDCCCCCC3E55244133333373BF5159413333333357552441CDCCCCCCBF515941666666666B55244133333313C051594166666666F355244100000000C251594166666666825624419A9999F9C3515941CDCCCCCC00572441000000A0C5515941CDCCCCCC6757244166666626C75159419A9999991158244100000080C95159419A9999995458244133333373CA51594100000000CD58244100000040CC5159416666666634592441666666A6CD5159410000000050592441CDCCCC0CCE5159419A999999435B2441CDCCCC0CD551594166666666475D244100000000DC51594133333333605D2441CDCCCC4CDC51594100000000535E244133333333DF515941CDCCCCCC885F2441CDCCCC8CE3515941CDCCCCCCF160244133333353E851594100000000D5612441666666A6E7515941666666668662244100000040C351594133333333CB622441CDCCCC6CB051594166666666F0622441CDCCCC6C88515941333333332A632441666666A666515941CDCCCCCC646324419A9999D9535159419A99999978632441333333935251594133333333646324419A9999594C51594166666666C3622441666666863D5159419A999999C8612441CDCCCC8C2D51594100000000B06024419A9999592151594100000000FC5F2441CDCCCC0C1F515941666666661C5E2441CDCCCC8C1F515941CDCCCCCCFD5D2441333333D3115159419A9999997C5D2441333333331151594100000000A55C2441000000600C515941CDCCCCCCD55B24419A9999190051594133333333845B244100000020F950594100000000485B2441CDCCCC8CEB50594100000000085B244133333333D450594133333333E25A244100000080CA5059419A9999996D5A2441CDCCCC0CB950594100000000BA5924419A9999F9A25059410000000015592441CDCCCCCC8750594100000000365924419A9999B98650594166666666765924419A999999845059419A999999AE592441666666668350594100000000F359244133333393805059419A999999505A2441666666E67750594133333333635A24419A9999397650594166666666F15A24416666664669505941333333331A5B2441CDCCCC0C6850594133333333465B2441333333336950594133333333BB5B24419A9999995350594133333333565C2441000000C03E505941333333337E5C2441666666E6365059419A999999055D2441000000401A505941CDCCCCCC0F5D2441CDCCCCAC18505941666666661D5D24413333339316505941000000009A5D2441000000A00350594133333333B85D2441666666E6F34F5941CDCCCCCC8B5E2441CDCCCC2CBB4F594100000000BE5E24419A9999B9BA4F594133333333445F244133333393BA4F594166666666BB5F2441000000E0C14F59419A9999995B6024419A9999F9CE4F594133333333B960244166666646CF4F59419A999999D5602441666666E6D34F5941666666661D61244133333373D34F5941666666666B61244133333393D24F594133333333B36124419A999959D14F5941CDCCCCCC13622441333333F3CC4F59419A9999999C622441000000C0C74F59419A999999ED622441CDCCCC4CC54F5941666666661C632441CDCCCC4CC34F5941CDCCCCCC4A632441CDCCCC2CBE4F59410000000086632441CDCCCC6CB94F594166666666AF632441CDCCCCECB74F594133333333B5632441333333F3B34F594100000000D46324419A9999199E4F5941CDCCCCCCD8632441333333139E4F59410000000084642441333333D39D4F5941CDCCCCCCC564244100000080A04F5941333333331765244100000080A54F5941333333338C652441000000008C4F594100000000A565244133333313884F5941CDCCCCCCD3652441666666E6844F59419A99999943662441CDCCCCEC7E4F5941666666667866244100000000794F594166666666F7662441333333336B4F594166666666696724419A999939554F594100000000BA6724419A9999394A4F5941CDCCCCCC2C682441CDCCCCCC3E4F594166666666BB68244133333393304F59419A99999902692441666666C6264F59413333333356692441CDCCCCAC1D4F594100000000A7692441CDCCCCEC184F59419A999999EB692441CDCCCC8C144F594166666666206A24419A9999B9134F5941CDCCCCCC586A2441CDCCCCAC134F59419A999999746A2441333333B3114F594133333333A36A2441000000000B4F594133333333E96A244133333313F54E594166666666396B2441CDCCCC8CE64E59419A9999997C6B244166666646CF4E59419A9999998B6B24419A9999B9CC4E5941CDCCCCCC106C2441CDCCCC4CB64E594133333333486C24419A999979AC4E594133333333546C24419A999939A64E594100000000766C2441CDCCCC0C9C4E594166666666946C2441CDCCCC4C904E594166666666BC6C2441333333B3854E594100000000136D2441000000E07B4E5941CDCCCCCCAE6D244166666606774E594100000000296E2441333333937B4E5941000000008A6E2441000000607F4E5941CDCCCCCC196F2441000000C0824E5941CDCCCCCCDB6F2441CDCCCC0C864E5941CDCCCCCCE4702441666666A6824E594133333333A3712441333333537F4E594100000000D47224419A999919724E5941666666664D732441000000C06B4E5941333333335973244166666626634E5941333333335C73244166666666604E5941CDCCCCCC07742441000000805D4E5941333333330E7424419A999939604E594133333333FE7424419A9999B9594E5941666666663975244166666646594E5941000000008B752441333333B35C4E59419A999999DF752441333333B35E4E59419A99999904762441333333935F4E5941000000002E772441CDCCCC6C664E594133333333F37724419A9999396D4E5941CDCCCCCC41782441000000C0754E59419A999999AC7824419A9999997E4E594100000000E8782441666666A6814E59410000000052792441666666A67D4E594166666666DE792441CDCCCC8C7B4E594166666666797A2441333333F3794E594166666666B27A24419A999959794E594100000000D17A244133333353784E594133333333CD7A2441666666A6774E594100000000E97A2441333333136E4E5941CDCCCCCCFA7A244100000000684E5941333333330A7B2441666666E6624E5941000000000D7B2441666666C65F4E594100000000107B2441666666E6594E5941CDCCCCCC187B24419A999939554E594133333333287B2441CDCCCCEC504E594166666666347B2441000000004D4E5941666666663D7B2441000000C0464E5941000000003D7B244166666646414E594100000000467B2441333333933C4E5941000000004C7B244133333373394E594166666666777B244166666626334E594100000000907B2441666666462D4E594133333333CD7B2441333333331D4E59419A999999EE7B2441000000200F4E594166666666F17B244100000020084E594166666666FA7B244166666666034E5941CDCCCCCC437C24419A999959EA4D59419A999999627C2441CDCCCC6CE64D5941333333335C7C24419A999959E14D5941333333336E7C2441333333B3DA4D59419A999999807C244100000040D34D5941CDCCCCCC8C7C2441CDCCCCCCCD4D59419A999999A57C2441CDCCCCCCCB4D5941CDCCCCCCB17C2441333333D3C94D594133333333B17C244166666646C14D594133333333C07C2441666666A6B84D594166666666B97C24419A999959AD4D59419A9999994B7C2441666666667F4D5941333333332C7C2441666666C6734D594166666666E77B2441666666265A4D594166666666DB7B2441000000C0554D594166666666B67B2441CDCCCCAC444D59419A999999867B24419A999979374D5941000000008C7B2441000000C02B4D5941CDCCCCCC787B244100000000224D5941000000005E7B2441000000000C4D594133333333517C244100000000024D594100000000047D244133333393F14C5941000000007B7D24419A9999F9D94C59419A999999977D24419A999959CA4C594133333333A67D2441CDCCCC0CB64C594133333333927D2441666666C6A14C594166666666A07D2441000000A08E4C5941CDCCCCCCDD7D2441000000007D4C5941CDCCCCCCEF7D2441CDCCCCCC744C594166666666EB7D2441333333535F4C594133333333FD7D2441CDCCCCCC524C594100000000357E244166666686354C594166666666367E2441333333B3344C594166666666457E2441CDCCCC4C2B4C594133333333417E2441CDCCCC6C174C594100000000337E2441CDCCCCECFC4B594166666666327E2441CDCCCCACF64B594166666666327E2441333333B3F44B5941666666661C7E2441666666C6F24B594133333333007E2441000000A0F14B5941333333335D7D2441CDCCCC0CE84B59419A999999517B244166666626CA4B594166666666FE792441CDCCCC2CB64B594133333333E179244133333373B44B59419A99999947772441333333338D4B59413333333356772441666666A67D4B59419A999999197724419A9999B9734B594133333333B9752441000000A04E4B5941333333330474244100000020024B5941333333330C74244100000000FF4A5941000000001F742441CDCCCC6CF64A59413333333333742441CDCCCCACED4A59413333333346742441333333D3E44A594166666666367424419A9999D9E44A5941CDCCCCCCB87024419A9999D9A44A59419A99999968702441CDCCCCEC9F4A5941000000004B702441333333F3A44A5941000000002370244100000040A64A594100000000F66E244133333393924A594100000000BA6E2441666666A6924A59419A9999995B6E244133333373A34A594133333333EF6D244166666606984A594166666666D56D2441CDCCCC4C954A5941CDCCCCCC4A6D24419A9999D9874A594133333333E76C2441000000A07D4A5941CDCCCCCC736C2441000000E0714A594166666666A56B24419A9999395D4A59419A999999416B24419A9999F9524A5941CDCCCCCC0A6B2441666666464D4A594100000000CE6A244100000020474A5941666666669B6A2441CDCCCCEC414A5941000000007F6A2441000000803E4A5941333333336A6A24419A9999D93B4A594100000000546A2441000000C0384A594133333333436A244133333313364A594166666666346A2441333333B3334A5941CDCCCCCC246A2441CDCCCCCC304A594166666666FE692441CDCCCC4C294A59419A999999AB692441CDCCCC0C194A59419A9999996C6924419A9999790C4A5941666666661D692441333333F3FC49594100000000F668244133333333F5495941CDCCCCCCDD68244100000060F049594100000000CB6824419A999939EC49594166666666BE68244100000080E949594133333333B3682441000000A0E649594133333333AB682441CDCCCC4CE449594133333333A2682441000000C0E1495941CDCCCCCC9968244100000000DF495941CDCCCCCC92682441CDCCCCECDC495941000000008968244100000060D949594166666666746824419A999999D1495941666666664B6824419A999939C1495941CDCCCCCC246824419A999919B249594166666666F66724419A999959A049594133333333F46724419A9999799F495941CDCCCCCC1E65244100000020484959413333333318652441333333F348495941CDCCCCCC0E6524416666668649495941CDCCCCCC066524419A9999B94949594100000000FD642441333333934949594133333333F3642441666666064949594133333333CC642441666666E6454959419A999999AA64244166666686434959410000000063642441333333933E495941333333333F642441CDCCCC0C3C495941000000002C642441333333133B4959419A99999923642441666666C63A4959416666666615642441CDCCCCCC3949594133333333F66324413333337337495941CDCCCCCC96632441000000C030495941000000002C632441CDCCCCAC294959416666666612632441CDCCCC8C28495941333333330A632441000000402849594133333333F362244100000020284959413333333377622441666666E62749594100000000DA612441666666A6274959419A9999994A612441333333332749594100000000B1602441CDCCCC2C274959419A999999596024419A9999F926495941CDCCCCCCE05F24419A9999B9264959419A999999AF5F2441333333932649594166666666985F2441CDCCCCAC264959419A9999998F5F24416666668626495941CDCCCCCC845F24410000002026495941CDCCCCCC795F24419A9999992549594166666666645F2441000000002449594100000000FC5E2441CDCCCC2C1C495941000000007F5E24419A9999391349594166666666225E2441000000A00C4959419A999999C65D2441666666860549594133333333835D2441666666A60049594100000000685D244166666606FF485941666666663F5D2441CDCCCCECFC485941CDCCCCCC055D244166666666FA485941CDCCCCCCDC5C24419A999999F84859419A999999A75C244100000020F548594100000000945C244166666646F348594100000000785C2441666666E6F048594166666666665C24419A999979EF48594166666666285C24419A999939EC48594133333333DD5B244133333353E848594166666666C05B244100000080E648594133333333AF5B2441CDCCCC0CE648594100000000915B2441CDCCCC6CE54859419A999999755B24419A9999F9E44859419A9999993F5B24419A999939E448594100000000F85A2441000000C0E24859419A999999CA5A24419A999979DF485941333333338C5A2441CDCCCC6CDA48594166666666395A2441CDCCCC0CD448594166666666FF5924419A9999D9CE48594100000000D8592441666666C6CB48594133333333AC5924419A999959C8485941666666664E592441000000A0C1485941333333331159244100000040BD485941CDCCCCCCCF58244100000040B84859419A999999865824419A9999F9B24859419A99999931582441000000A0AC485941CDCCCCCC0558244133333373A94859419A999999C057244133333353A4485941CDCCCCCC8C57244133333393A0485941666666665B5724419A9999D99C485941333333333E572441000000A09A485941666666662F572441CDCCCC8C99485941000000002B57244100000020994859419A99999922572441666666C6974859419A9999991A572441333333D395485941000000000B572441333333939248594100000000EE562441CDCCCCCC8C485941CDCCCCCCD95624419A9999B98848594166666666C35624419A9999398448594133333333AD5624419A9999597F4859416666666697562441666666A67A485941333333338656244166666606774859416666666676562441CDCCCCAC744859419A9999995E56244133333373714859419A99999946562441CDCCCCAC6E4859416666666629562441666666066B485941CDCCCCCC15562441CDCCCC0C68485941CDCCCCCC055624416666664665485941CDCCCCCCF05524419A9999596148594166666666CF552441CDCCCC2C5B4859419A999999B45524419A99993956485941CDCCCCCC975524410000000051485941000000007D552441000000204C485941000000006A552441000000004848594100000000565524416666666643485941CDCCCCCC40552441333333533E48594100000000325524419A9999D93A48594100000000255524410000008037485941666666660D552441CDCCCC4C33485941CDCCCCCC435424419A9999F9F84759410000000021542441666666A6F9475941000000000354244133333373F647594133333333E153244133333313F3475941CDCCCCCCB753244166666666EE4759410000000099532441333333F3EA475941CDCCCCCC6E5324419A999939E6475941666666663853244133333333E04759419A9999990553244166666686DA47594166666666DD522441000000C0D54759419A999999C4522441CDCCCC6CD2475941333333339D522441CDCCCCACCC4759419A9999996C5224419A999999C5475941666666664552244133333393BF4759413333333320522441000000E0B847594133333333F8512441CDCCCC2CB147594100000000E35124419A999919AD475941CDCCCCCCC351244166666666A74759419A999999985124419A9999F99E4759416666666687512441666666669B475941333333337E512441000000809947594166666666775124419A99991998475941CDCCCCCC535124413333337392475941CDCCCCCC19512441333333F3894759410000000004512441000000C08647594100000000E85024419A9999398847594133333333C75024419A9999998947594166666666A05024419A9999F98A475941CDCCCCCC8B502441333333938B4759413333333366502441000000808C47594166666666355024419A9999B98D47594100000000F54F2441333333338F475941CDCCCCCC694F24419A9999799247594133333333484F24419A99993993475941CDCCCCCC1C4F244133333353944759419A999999F54E24419A9999799547594100000000DE4E244166666646964759419A999999C14E24419A9999D99747594100000000A44E2441000000009A475941CDCCCCCC894E2441666666E69B475941CDCCCCCC624E2441333333D39E47594133333333414E2441666666A6A147594166666666224E2441333333F3A347594100000000FB4D2441666666C6A6475941CDCCCCCCDB4D2441666666E6A847594133333333B94D2441666666E6AA475941CDCCCCCCA04D244100000060AC475941666666668F4D2441CDCCCC2CAD475941000000007C4D244133333313AE47594100000000624D244133333373AE4759419A999999494D24419A9999B9AE47594166666666324D244166666606AF4759419A999999F24C2441000000C0AF4759419A999999B24C2441CDCCCCACB047594166666666664C2441666666A6B147594100000000164C2441000000C0B247594100000000C74B2441333333B3B347594166666666644B244100000000B547594100000000FA4A244100000060B647594166666666C04A244166666606B74759419A999999844A244100000080B7475941333333335A4A244133333393B7475941CDCCCCCC214A24419A999979B747594100000000FC49244166666646B747594133333333D14924419A9999D9B6475941CDCCCCCCB649244133333353B64759419A99999998492441CDCCCC6CB547594100000000984924419A9999D9B747594133333333944924419A999939BA475941333333338B492441666666C6BC475941666666667E49244166666626C0475941666666669349244100000040CB4759419A9999999C49244133333393CF47594166666666AE4924419A9999B9D94759419A999999C1492441666666C6E347594166666666D6492441000000E0EE47594166666666E349244133333373F6475941CDCCCCCCF449244100000080004859419A999999FE492441CDCCCC6C0548594133333333144A2441666666261048594100000000254A2441666666A616485941000000003C4A2441666666E61D48594133333333554A2441CDCCCC0C2448594133333333644A2441333333F32748594133333333774A2441333333932B48594166666666904A24413333337330485941CDCCCCCCB04A244166666606364859419A999999D14A2441000000A03C48594166666666F24A24419A9999B94348594100000000154B2441CDCCCC6C4B485941CDCCCCCC384B2441000000E05448594133333333584B2441666666E65D485941CDCCCCCC684B24410000004062485941CDCCCCCC7E4B24410000000067485941333333339A4B2441333333536C48594100000000B34B2441666666267048594133333333D94B24419A9999D97648594166666666FE4B2441666666267D48594133333333044C24419A9999197E48594166666666244C2441CDCCCC4C8348594133333333414C24410000000088485941666666665C4C2441CDCCCC4C8C485941333333336F4C24410000002090485941CDCCCCCC794C2441333333139248594100000000844C2441666666A69148594133333333A24C2441CDCCCC6C9648594133333333BF4C2441CDCCCC4C9B48594166666666E44C244100000040A148594166666666044D2441333333B3A74859419A999999204D244133333353AD4859419A999999334D244133333353B2485941CDCCCCCC4A4D244166666686B8485941666666665A4D244133333353BD485941666666665C4D2441333333F3BD485941666666666B4D244133333393C2485941666666667C4D2441666666A6C648594100000000934D244133333353CD485941CDCCCCCCA64D2441000000E0D348594133333333C04D244133333373DB48594133333333E14D244100000040E5485941CDCCCCCCF74D24419A999939EC485941CDCCCCCCFD4D244133333393EE48594133333333FE4D244100000080F04859419A999999FB4D244100000040F448594133333333F84D2441333333B3F648594166666666F64D2441CDCCCC8CF848594166666666F54D244133333313FB4859419A9999994D4C244166666606064A59419A9999993B4C2441666666C6224A594100000000D24B2441333333D3634A594100000000984B2441000000E0814A5941CDCCCCCC4B4B2441666666E6B84A594100000000094B2441CDCCCC4CD74A5941CDCCCCCC144B2441CDCCCC4CDE4A59419A999999224B24419A999959E74A59419A9999992C4B244133333393EE4A594166666666314B24419A9999B9F34A594133333333314B24419A9999B9F64A5941CDCCCCCC2C4B2441000000E0FA4A59419A999999214B2441000000C0024B594100000000104B2441000000600D4B594166666666F94A24419A9999F91B4B594100000000E54A244166666686284B59419A999999E44A24419A9999B9284B594166666666DC4A2441CDCCCCAC2D4B5941CDCCCCCCDD4A2441000000602F4B5941CDCCCCCCC54A2441CDCCCC6C324B5941CDCCCCCCAF4A2441CDCCCC6C354B5941CDCCCCCC8A4A2441CDCCCCCC3B4B5941666666665E4A2441333333D3434B594133333333354A24419A9999594B4B594100000000144A244166666686514B5941CDCCCCCCF44924419A9999D9564B5941CDCCCCCCD8492441666666E65B4B594133333333C249244100000020604B594100000000B949244100000060624B59419A999999AB49244100000040664B594133333333A549244166666666694B59419A9999999A492441CDCCCC2C714B59413333333392492441333333D3774B5941333333338B492441000000407C4B594133333333844924419A9999B97F4B59419A9999997C492441333333B3824B5941333333337449244133333373854B59419A999999684924419A999959884B59410000000059492441666666068C4B5941CDCCCCCC404924419A9999F9904B5941CDCCCCCC2F49244133333373944B59419A99999925492441CDCCCC8C964B5941333333331C49244100000000994B59413333333312492441333333539C4B59419A99999903492441666666A6A24B594100000000F8482441CDCCCC0CA84B594166666666F448244133333393AA4B5941CDCCCCCCF048244100000020AD4B5941CDCCCCCCE74824419A9999B9B04B5941CDCCCCCCD3482441CDCCCCACB54B594100000000C8482441CDCCCC0CB94B594133333333BD48244133333313BD4B59419A999999B8482441666666A6BF4B594100000000B848244133333313C04B59419A999999B448244100000080C24B594100000000B148244166666646C64B59419A999999AC48244100000040CC4B5941CDCCCCCCA848244100000080D04B594100000000A348244133333333D54B5941333333339F48244133333333DA4B5941CDCCCCCC9C48244100000020DE4B5941666666669B4824419A9999F9E34B5941CDCCCCCC9A48244100000000E84B5941CDCCCCCC9B4824419A9999B9EB4B5941333333339E48244166666686EF4B59419A9999999F482441666666C6F24B59419A9999999E48244133333333F84B5941000000009E482441333333F3FB4B59419A99999998482441CDCCCCACFF4B59416666666695482441CDCCCC2C014C59416666666683482441000000000B4C5941666666667A482441333333D30E4C5941333333336E4824419A999999134C5941333333336348244166666666174C59410000000059482441666666661A4C5941666666664C482441333333931D4C59419A9999993548244166666686224C59413333333322482441000000A0264C5941CDCCCCCC10482441000000002B4C59419A99999900482441000000A02F4C594133333333EC472441CDCCCCAC354C5941CDCCCCCCDC47244166666686394C594100000000D0472441CDCCCC8C3C4C59419A999999C1472441666666463F4C5941CDCCCCCCAB472441333333D3434C5941666666669C472441666666E6464C5941666666668C4724419A999959494C59419A9999995F47244133333373504C5941CDCCCCCC3747244133333353574C59410000000000472441333333D3604C594166666666EA4624419A9999F9644C594166666666D046244166666686694C594100000000AC462441000000206F4C5941CDCCCCCC7E46244100000040764C5941CDCCCCCC46462441000000E07E4C59410000000045462441666666267F4C5941000000003B462441333333B3804C59419A9999992B4624419A999959824C59419A9999991D46244133333353844C59419A9999991246244166666686864C5941666666660D46244166666666874C5941CDCCCCCC064624419A9999398A4C5941CDCCCCCCFE452441666666268D4C594133333333F24524419A9999F9904C59419A999999E545244133333393944C594133333333DA452441000000E0974C594100000000CF452441000000609B4C594100000000C6452441666666C69E4C59419A999999BD452441666666C6A14C594166666666B6452441CDCCCC8CA44C594100000000B045244166666686A64C594133333333A6452441333333F3A84C59419A999999A045244100000060AD4C5941CDCCCCCC95452441CDCCCCACB34C5941000000008C45244166666666B84C59410000000084452441333333B3BC4C5941666666667C45244133333333BE4C5941CDCCCCCC724524419A9999D9BF4C59419A9999996D4524419A999919C14C5941666666664C452441333333B3C24C5941333333331F45244166666606C64C59410000000001452441333333B3C84C5941CDCCCCCCE1442441666666A6CB4C594100000000D444244100000040CD4C594100000000B5442441CDCCCC2CD14C59413333333394442441333333D3D54C59419A9999997444244166666666DA4C59410000000057442441000000C0DE4C5941333333333E4424419A999959E24C5941CDCCCCCC2A44244166666626E54C59419A999999184424419A999999E74C59419A9999990444244100000080E94C594133333333EC4324419A999939EB4C59419A999999CF432441666666E6EC4C59419A999999A8432441000000C0EE4C59419A9999997B432441000000E0F04C5941CDCCCCCC524324419A9999B9F24C5941333333332D432441CDCCCC8CF44C5941666666661043244166666686F54C594133333333F642244100000000F64C594100000000EC422441CDCCCCACF64C5941CDCCCCCCDC422441000000A0F74C594100000000CE422441CDCCCCCCF84C59419A999999BE422441000000C0F94C594100000000A142244133333333FD4C594133333333834224419A999959014D5941000000006742244133333353054D59419A99999950422441000000C0084D5941CDCCCCCC3C422441CDCCCC8C0C4D5941CDCCCCCC2B42244166666606104D594166666666154224419A9999F9144D5941000000000342244166666646184D59419A999999F04124419A9999D91A4D5941CDCCCCCCD8412441000000C01D4D5941CDCCCCCCB44124419A999939214D59410000000098412441000000E0234D5941CDCCCCCC76412441000000A0264D5941CDCCCCCC514124419A9999392A4D59410000000038412441000000202D4D59410000000015412441CDCCCCCC314D594166666666E9402441333333D3374D59419A999999CB402441CDCCCC0C3C4D5941CDCCCCCCB8402441666666C63E4D59419A999999AC402441CDCCCC2C414D594166666666A340244166666686434D59419A9999999C402441666666C6454D5941333333339740244100000060484D5941666666668E4024419A9999B94D4D59416666666686402441CDCCCCCC524D5941666666667D402441666666E6574D5941000000006F40244133333393604D5941666666666240244133333373684D59419A99999956402441333333B36F4D59419A9999994A402441666666E6764D59413333333340402441000000407D4D5941333333333A402441333333F3804D5941333333333940244133333313814D59410000000034402441CDCCCC0C844D594133333333E83F244166666686B14D59419A999999DC3F2441CDCCCC2CB44D59419A999999D83F24419A999939B54D59419A999999B83F244133333373BC4D594133333333A33F24419A9999D9C04D594133333333A03F244100000080C14D5941000000008A3F2441CDCCCC4CC64D594100000000763F244100000080CA4D594100000000663F244133333333CE4D5941000000005F3F24419A999939D04D5941CDCCCCCC5A3F244100000020D34D5941000000005B3F24419A999959D64D5941000000005D3F2441CDCCCC6CDC4D594133333333613F2441333333F3DF4D59419A999999653F24419A999999E64D59419A999999693F244133333393EB4D5941666666666C3F244100000060F04D5941000000006D3F2441666666C6F44D594133333333673F2441333333D3F54D5941333333335C3F2441333333D3F64D594100000000433F2441666666C6F84D5941CDCCCCCC323F244100000020FA4D5941000000000C3F244133333333FD4D59419A999999F13E2441CDCCCC8CFF4D594133333333E43E244100000080014E594100000000DA3E2441CDCCCCEC034E5941CDCCCCCCD03E2441333333F3064E594166666666C73E2441333333130B4E59419A999999B03E2441CDCCCC2C114E594100000000953E2441333333F3164E5941666666667A3E24419A9999591C4E594133333333593E244100000080224E59419A999999413E2441000000C0264E5941CDCCCCCC353E24419A9999F9294E5941000000002A3E2441333333B32E4E594133333333CF3E2441CDCCCCCC404E5941000000005D3F2441666666A65E4E59419A9999998F3F244133333393684E59410000000027402441666666667C4E594166666666A940244100000040864E5941CDCCCCCCBD4024419A9999398B4E5941CDCCCCCC823F244100000080D14E5941CDCCCCCC713F2441000000C0FF4E5941333333334B3F2441666666C6134F59419A999999D53E2441000000A0354F594133333333733E2441333333F34A4F594133333333563E24419A9999F9594F5941666666664E3E2441333333737A4F594166666666F63D244166666606964F5941	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	01010000206A080000600C5FE5996124419A999939B74C5941	180130000	Z	Arpheuilles	1801300	18013	18	24	48
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	01010000206A080000DAE4F892F9C824413333336382925941	180140000	Z	Assigny	1801400	18014	18	24	17
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	01010000206A0800000EA7C55CEA0424419A9999995E985941	180150000	Z	Aubigny-sur-Nère	1801500	18015	18	24	62
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	01010000206A0800000C8BD873206A244166666626837B5941	180160000	Z	Aubinges	1801600	18016	18	24	11
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	01010000206A0800009050AE4730072541CCCCCC9C8D4B5941	180170000	Z	Augy-sur-Aubois	1801700	18017	18	24	31
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	01010000206A08000078C3482FC2922441000000101A675941	180180000	Z	Avord	1801800	18018	18	24	28
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	01010000206A0800002066B12022B12441666666E69A785941	180190000	Z	Azy	1801900	18019	18	24	28
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	01010000206A080000EA9E1B13EF0E2541CDCCCC1CF08C5941	180200000	Z	Bannay	1802000	18020	18	24	25
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	01010000206A080000050000C095B624419A999979884E5941	180210000	Z	Bannegon	1802100	18021	18	24	21
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	01010000206A0800001283C09A6B7E24410000002027995941	180220000	Z	Barlieu	1802200	18022	18	24	29
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	01010000206A080000F0285CCB0DB1244166666606DF695941	180230000	Z	Baugy	1802300	18023	18	24	48
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	01010000206A080000E25050856F8023419A9999894B395941	180240000	Z	Beddes	1802400	18024	18	24	13
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	01010000206A080000ECFD4078C75C2541666666569C6D5941	180250000	Z	Beffes	1802500	18025	18	24	12
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	01010000206A080000E80ABAE88803254100000040B3995941	180260000	Z	Belleville-sur-Loire	1802600	18026	18	24	11
01060000206A08000001000000010300000001000000A602000000000000109524419A9999D9C164594100000000E7992441CDCCCC8CC064594133333333D5992441CDCCCCCCDF6459419A9999999C992441333333D311655941CDCCCCCC9C992441333333531465594166666666BE9A2441000000001465594166666666F79C2441CDCCCC6C0965594100000000B59D24419A9999B906655941CDCCCCCCE89D2441666666262265594100000000E29E2441666666661A65594133333333A99F2441333333331065594133333333D19F24416666666611655941666666669CA02441666666E641655941000000006BA02441333333B34A6559413333333375A02441CDCCCC6C4E655941666666669DA02441000000205265594166666666C5A024419A9999D95065594133333333E5A12441CDCCCC0C35655941000000000DA2244166666606306559410000000021A2244100000040316559419A99999954A22441CDCCCC2C4A6559416666666612A324419A9999B948655941333333338AA324419A99991946655941CDCCCCCC95A324413333335360655941333333338DA32441CDCCCC0C73655941CDCCCCCC72A4244133333353706559419A999999EAA42441333333B36D6559413333333333A524419A9999D996655941000000008DA5244100000000936559419A999999F2A52441000000E0AB655941333333336BA6244166666606C1655941666666668DA62441000000C0C565594133333333D3A6244133333313F465594166666666DEA62441CDCCCCCC066659419A999999B0A72441333333930B665941CDCCCCCCCEA72441CDCCCC0C0E6659419A999999ECA72441666666C60C665941CDCCCCCC9FA824419A9999D9E86559419A999999ADA92441666666A6CD6559416666666616AB2441000000C0B9655941CDCCCCCC21AC2441CDCCCCACB86559413333333398AC2441CDCCCC4CD86559419A999999B0AC2441CDCCCCACE56559410000000052AD244100000040DF65594133333333F3AD24419A999999D86559413333333356AE2441CDCCCC2CD46559416666666682AE2441666666C6E165594166666666C0AE2441CDCCCC6CFE65594166666666A5AF244133333333F4655941CDCCCCCCF3B224419A999999C76559416666666675B3244133333373C2655941666666669CB32441CDCCCC6CB3655941CDCCCCCC23B424419A999919716559419A9999994BB42441CDCCCCCC6F655941CDCCCCCCC6B52441666666A6666559419A999999A5B72441666666E65A6559419A999999C3B72441000000205C6559410000000071B82441666666268F655941CDCCCCCC24B924419A9999F98E6559419A9999993DB9244100000020D66559416666666656BA244133333313E66559419A99999955BB2441000000803466594100000000ABBF24413333339339665941CDCCCCCC8EBF2441333333D3536659410000000038BF24416666666683665941CDCCCCCC50CA2441333333F3F26659419A9999994FCA2441CDCCCCCCE7665941000000004FCA24419A9999D9DE6659419A99999948CA2441CDCCCC6CD36659416666666642CA244100000080CA665941000000003ACA244166666666BE6659419A99999932CA2441CDCCCCACB5665941000000002BCA2441CDCCCC6CAA665941CDCCCCCC20CA2441000000009D6659413333333317CA2441000000808F665941333333330ECA244166666686846659410000000007CA2441CDCCCC0C78665941CDCCCCCC03CA24419A9999796F665941333333336CCA2441CDCCCC0C6E6659410000000005CB24419A9999996A665941CDCCCCCC8ECB2441CDCCCC4C686659410000000042CC2441666666866466594133333333FCCC2441666666066166594166666666A8CD24419A9999795D665941CDCCCCCC41CE24419A9999795A6659416666666665CE2441000000E0596659410000000077CE244166666626596659419A99999984CE2441CDCCCC8C58665941CDCCCCCC8FCE24419A9999395866594133333333CBCE244133333313576659410000000006CF244100000060566659419A99999930CF24413333339355665941CDCCCCCC81CF2441CDCCCCEC5366594100000000DACF2441CDCCCCAC52665941333333333CD02441333333135166594133333333A3D02441333333734F6659416666666601D124419A9999394E665941666666666FD12441333333934C6659413333333398D12441666666E64B6659419A9999999AD12441000000E04B665941CDCCCCCCB1D12441000000804B66594100000000C3D124419A9999194B665941333333330ED2244100000060486659413333333318D22441000000E047665941CDCCCCCC21D224413333337347665941CDCCCCCC2DD2244166666626476659419A99999937D22441666666E646665941333333333DD22441666666C6466659419A99999941D22441666666E646665941333333335DD22441000000604A6659410000000064D22441333333D34A665941000000006BD22441666666A64A665941333333337ED22441CDCCCCEC496659419A9999998ED224419A999979496659419A999999A6D22441000000004966594133333333CED22441CDCCCC8C4866594100000000BDD2244166666606426659419A999999A1D224419A9999793A665941CDCCCCCC6FD22441CDCCCC2C31665941666666664BD2244133333313296659413333333321D22441000000202066594133333333F7D124419A9999B91666594166666666B0D12441333333D3076659419A99999982D12441CDCCCCECFD6559413333333345D12441CDCCCCECF0655941CDCCCCCC10D1244166666626E665594133333333DDD0244100000080DA6559419A999999A3D0244166666646CE6559419A9999997AD0244133333393C5655941000000006ED0244100000000C3655941333333334BD0244166666686BB6559419A99999921D02441CDCCCC6CB26559419A999999EACF2441000000A0A665594133333333AFCF2441000000009A65594133333333A2CF24413333333397655941CDCCCCCC78CF2441333333B38E6559419A9999991DD02441CDCCCC4C81655941333333331CD124419A99997965655941666666667DD0244166666686426559410000000078D124410000004019655941666666660ED2244133333393206559413333333399D22441333333F30E6559419A99999902D42441CDCCCCCC286559416666666608D72441CDCCCCEC68655941666666661CD72441666666E6686559413333333318D92441CDCCCCEC5365594100000000FDD82441CDCCCC4C506559410000000055D82441000000003A6559410000000000D8244100000080316559419A999999B7D72441666666262A655941000000008ED72441000000C01B655941CDCCCCCC51D72441000000C00D6559416666666609D724419A9999F90765594133333333AED6244100000020FD6459419A99999940D6244166666686FA64594166666666F2D5244166666626F56459410000000089D5244166666626EA6459419A99999958D5244100000060E76459416666666623D52441CDCCCCCCE364594166666666E9D4244100000020DE64594100000000ADD4244100000000D6645941CDCCCCCC97D4244133333313D3645941CDCCCCCC79D42441CDCCCC4CD0645941000000005DD4244100000080CD6459416666666645D4244133333353CA6459413333333325D4244133333373C66459419A999999FFD32441CDCCCC6CC1645941CDCCCCCC72D4244166666686B46459419A99999986D4244100000000B264594166666666F3D42441666666E6A26459413333333375D5244100000080A16459410000000036D52441000000A06F6459419A99999935D52441000000E06B64594166666666D5D52441333333736A6459419A999999F0D52441333333F33F6459413333333304D62441333333B339645941000000007BD62441333333532964594166666666C9D62441000000001464594100000000D3D62441000000000F64594166666666DDD72441666666260C64594100000000E3D724419A9999590D64594100000000EBD72441000000400E645941CDCCCCCCF1D72441CDCCCC8C0F6459416666666603D82441CDCCCC4C11645941CDCCCCCC0DD8244100000040126459413333333315D824419A999999136459419A99999915D824419A99995914645941CDCCCCCC1BD8244133333393156459419A9999992CD8244100000000176459413333333337D82441000000E0176459410000000063D82441333333531264594133333333BCD82441000000000764594100000000BBD8244100000080F56359419A9999999CD82441CDCCCC4CEF6359416666666610D82441333333B3EB6359416666666698D7244133333353E96359410000000001D7244100000040D46359416666666688D6244100000020C9635941CDCCCCCCD3D5244133333313BE63594133333333A1D5244166666626B4635941CDCCCCCC56D5244100000020A36359416666666682D52441666666C69E6359419A9999998AD524419A9999D99D63594100000000AED52441666666E69963594133333333D3D52441000000209663594100000000F1D5244133333313946359419A999999FAD62441333333D372635941CDCCCCCC5DD724419A9999F9696359416666666693D82441666666E665635941CDCCCCCC9CD82441666666A65F635941CDCCCCCC55D82441000000404E6359410000000031D7244133333393216359410000000085D62441CDCCCC8C02635941333333337AD6244133333313F6625941CDCCCCCC8CD62441CDCCCCCCE06259419A9999996DD624419A999959CF625941CDCCCCCC93D6244133333353B66259410000000092D624419A9999999962594166666666AFD624413333335393625941CDCCCCCC1CD724419A9999798A6259419A9999996CD72441666666E6876259419A99999902D824419A9999F98862594133333333DFD8244100000000946259410000000043D92441666666A6926259419A99999992D92441CDCCCC8C8D625941CDCCCCCC41DA24419A9999F98F625941CDCCCCCC4FDA2441CDCCCCAC91625941000000005BDA244133333393926259419A99999969DA244100000000936259410000000097DA24419A999999936259419A99999906DB24419A999999946259419A99999943DB24416666668694625941CDCCCCCC73DB2441CDCCCC8C9362594166666666A9DB2441000000E09162594133333333E8DB2441666666C69062594133333333F0DB2441666666E69062594166666666FBDB244166666606916259413333333304DC24416666666691625941CDCCCCCC2BDC24419A99993995625941333333336FDC2441CDCCCCEC9A625941666666667FDC2441333333F39B6259413333333391DC2441333333B39C62594100000000A7DC2441333333539D62594133333333BADC2441CDCCCC4C9D62594133333333C4DC2441333333139D625941CDCCCCCCE9DC2441666666C69B625941666666663EDD2441333333939B6259416666666602DE2441000000A091625941CDCCCCCCBEDD2441333333F37F6259416666666659DD2441333333D36A625941CDCCCCCC4EDD244133333313626259419A9999993ADD24419A9999195D62594166666666F4DC2441CDCCCC6C5962594133333333D5DC24419A9999F947625941666666667ADC24419A9999593A6259419A9999994CDB2441CDCCCCAC1C6259416666666663DA24419A9999B9E9615941000000003ADA2441666666C6D561594100000000ACD9244133333373B561594166666666EBD82441CDCCCC6C8C6159410000000067D824419A999999696159419A99999956D82441CDCCCCCC63615941666666664ED82441000000E0606159410000000034D82441CDCCCC6C59615941CDCCCCCC41D7244133333373356159419A99999923D724419A9999B9316159419A999999C8D624419A999999216159419A999999C0D62441000000202061594133333333CCD62441000000001E61594100000000F8D62441CDCCCC8C196159416666666608D724419A99991918615941CDCCCCCC54D724413333331311615941CDCCCCCCA5D72441CDCCCCEC0861594133333333B0D724419A9999F90761594100000000B6D72441666666660761594133333333AFD724419A9999390661594100000000A9D724413333333305615941CDCCCCCC87D7244133333333006159413333333380D7244100000040FE605941CDCCCCCC6BD72441666666A6FA6059413333333361D72441CDCCCCCCF9605941333333334DD72441CDCCCC6CF86059410000000036D7244166666646F7605941000000002BD7244100000000F6605941CDCCCCCC24D7244133333373F46059416666666616D7244100000000F16059419A9999990BD7244100000040EF6059419A999999FAD62441000000C0ED60594166666666CBD624419A9999F9EA605941CDCCCCCCC4D62441333333D3E960594166666666BFD6244166666626E860594100000000B4D624419A9999D9E1605941CDCCCCCCAFD624419A999939DE60594166666666B3D62441666666C6DC60594166666666BAD62441000000C0D96059419A999999BDD6244133333313D760594166666666C2D62441333333F3D4605941CDCCCCCCCBD6244133333313D360594133333333E1D624419A999979D060594166666666F3D62441CDCCCCACCE60594100000000FDD6244133333373CD605941CDCCCCCC01D72441CDCCCC4CCC6059413333333309D72441000000E0C96059410000000012D72441CDCCCC2CC5605941CDCCCCCC14D72441CDCCCC4CC2605941CDCCCCCC12D7244100000000C0605941666666660ED724419A9999B9BD6059419A9999990CD72441333333B3BB6059416666666611D7244100000080B76059416666666618D72441CDCCCC2CB3605941CDCCCCCC20D7244133333373B1605941CDCCCCCC33D72441000000E0AD605941666666664DD7244166666606A96059416666666650D7244100000000A8605941CDCCCCCC56D7244100000040A3605941000000005DD72441000000E09D6059413333333362D72441333333739A605941666666666AD72441000000C0966059419A9999996DD72441000000A093605941000000006BD72441000000A08F605941666666666BD72441666666668C6059419A99999969D724419A9999F98A605941CDCCCCCC65D72441CDCCCCAC886059416666666666D72441333333B3866059416666666668D72441000000E083605941000000006BD724419A99991982605941CDCCCCCC69D72441CDCCCC2C806059410000000064D72441000000807E6059413333333356D72441000000807B6059410000000049D72441000000C0796059410000000030D7244100000040776059419A99999913D72441CDCCCC2C736059413333333305D72441666666867160594166666666F3D624419A9999F96F6059419A999999E4D624419A9999F96D60594133333333D0D624419A9999996B60594166666666C2D62441000000E06960594100000000B7D624419A9999D967605941CDCCCCCCACD62441CDCCCC6C6560594166666666A5D62441000000C0636059419A99999998D6244166666686616059410000000094D62441000000E0606059413333333393D624419A9999B9606059419A99999986D62441333333F35E6059416666666671D62441333333935B605941CDCCCCCC5CD624419A99993959605941666666664AD62441000000C0576059413333333339D62441CDCCCCAC566059419A9999990CD62441000000805460594133333333E1D52441333333335360594100000000C1D52441CDCCCCEC51605941CDCCCCCCA5D52441333333B350605941CDCCCCCC9AD52441CDCCCCEC4F6059410000000082D52441000000604D6059416666666670D52441CDCCCC6C4B605941CDCCCCCC50D5244133333373486059419A99999940D52441CDCCCC2C476059413333333312D52441333333D3426059410000000008D52441000000604160594133333333FED42441CDCCCC8C3F60594100000000F8D42441666666A63C60594100000000F7D42441CDCCCCCC3960594166666666F4D4244133333333376059419A999999F0D4244100000080346059419A999999E9D42441CDCCCC6C3160594133333333E5D424419A9999992F60594133333333E3D424419A9999992E60594100000000E3D424419A9999F92D6059419A999999E5D42441333333732D6059419A999999E4D42441CDCCCCCC2C60594100000000E3D42441CDCCCC0C2C6059419A999999DFD42441333333132B60594166666666D5D42441CDCCCCCC2960594100000000ACD424413333339325605941CDCCCCCC9AD4244100000060236059410000000089D42441000000E020605941000000005FD42441CDCCCC6C1B6059419A99999950D4244133333373196059413333333341D42441000000A0176059419A99999933D42441CDCCCCCC166059413333333329D42441CDCCCCCC156059416666666621D424410000008014605941CDCCCCCC1BD42441CDCCCC8C12605941666666661AD4244166666666116059416666666612D42441333333730D6059419A99999912D42441CDCCCCCC0B6059416666666612D42441000000600A60594166666666B0D3244166666666E85F594133333333A3D32441CDCCCC8CE95F5941CDCCCCCC7FD32441CDCCCCCCEB5F59410000000065D32441CDCCCCCCED5F5941000000004DD32441333333F3F05F5941CDCCCCCC3DD3244100000080F35F59416666666636D32441CDCCCC2CF55F59419A9999992ED32441000000E0F75F5941CDCCCCCC29D32441666666E6FE5F59416666666626D324413333339307605941CDCCCCCC25D32441CDCCCCAC0A6059419A99999920D32441000000800C605941CDCCCCCC0FD324419A9999590F60594133333333F9D224419A9999591260594100000000EAD22441666666E61460594166666666E3D224419A9999991560594133333333BBD22441333333331D605941000000009ED2244133333313226059416666666689D2244166666666266059413333333371D22441666666C62C6059416666666658D22441CDCCCC2C33605941666666663ED22441CDCCCC8C3A6059419A99999925D22441000000803F6059416666666619D22441333333B3416059416666666608D224419A9999B94360594100000000E8D12441CDCCCC0C4760594100000000D5D124419A999959496059419A999999C5D12441CDCCCC6C4B60594133333333A9D12441000000C04F605941333333338ED12441000000E0546059413333333363D12441000000605D605941333333334AD12441666666E6616059416666666637D1244166666646646059413333333325D12441333333736660594133333333F8D024413333339369605941CDCCCCCCCFD024419A9999F96C60594100000000B7D02441000000E06E6059410000000099D02441666666A6726059410000000056D024419A9999597C6059419A99999923D02441666666868360594166666666F8CF2441000000208960594166666666E9CF24419A9999F98A60594166666666E3CF24419A9999B98B60594100000000C0CF24419A9999598E6059419A99999999CF244100000020916059419A99999973CF2441CDCCCCCC936059413333333346CF24419A9999B9976059416666666606CF2441333333539D6059419A999999BFCE244166666686A46059419A9999998BCE244100000080A96059416666666668CE244100000020AD6059419A99999952CE24419A999939B06059416666666646CE244133333313B36059416666666637CE244100000080B5605941666666661ECE2441666666C6B860594100000000F5CD2441CDCCCC0CBD60594166666666D4CD24419A999979BF605941666666669DCD244100000040C36059419A99999953CD2441CDCCCC8CC86059410000000037CD2441666666A6CA6059413333333325CD2441333333B3CB605941CDCCCCCC0DCD2441666666E6CC60594133333333F9CC2441333333B3CD60594100000000DECC24419A999979CE60594100000000CBCC2441333333B3CE60594133333333B2CC244166666646CF6059416666666680CC244166666666CF6059419A99999938CC2441000000C0CF6059410000000015CC244133333313D060594133333333BDCB244100000080D16059419A99999959CB244100000000D3605941333333332BCB2441000000E0D3605941333333330BCB24419A999979D46059419A999999F8CA244133333313D460594100000000E6CA24419A999939D4605941CDCCCCCCCECA2441333333B3D460594133333333A0CA2441333333F3D56059419A9999996FCA2441CDCCCC8CD76059416666666664CA2441CDCCCC0CD8605941CDCCCCCC51CA24419A9999D9D86059419A99999930CA2441666666E6DA6059416666666610CA2441CDCCCCECDC60594133333333BEC9244166666646E2605941333333337BC9244133333353E66059419A99999934C924419A999959EB60594133333333E9C82441333333F3EF6059413333333395C8244166666646F5605941CDCCCCCC29C824419A9999F9FB60594166666666BDC7244166666606036159413333333373C724419A9999D9076159410000000034C72441666666A60B61594100000000F6C62441666666A60F61594166666666D8C62441CDCCCC0C116159419A99999994C62441666666E614615941CDCCCCCC54C62441CDCCCC4C1861594133333333DEC52441CDCCCC0C1E6159419A9999997DC52441CDCCCC2C236159419A99999965C524419A9999B924615941CDCCCCCC60C524419A9999D9246159413333333344C52441CDCCCCAC266159416666666628C52441333333D3286159413333333307C52441000000602B61594166666666E5C42441333333F32E615941CDCCCCCCCAC42441CDCCCCEC31615941CDCCCCCCACC42441CDCCCC2C36615941CDCCCCCC93C42441000000A039615941333333336CC424419A999919406159419A99999960C42441333333F3416159410000000056C42441CDCCCCEC43615941333333334BC4244166666606466159416666666631C42441CDCCCC0C4A6159410000000011C42441333333134D615941333333330AC42441CDCCCCAC4A61594133333333FFC32441333333B34661594166666666E1C324419A9999B93A61594133333333B5C32441666666A628615941CDCCCCCCA7C32441000000E023615941333333339AC32441666666861E6159413333333386C324419A999999176159419A9999997BC3244133333313156159413333333396BC2441CDCCCCAC0A6159410000000082BC24413333333308615941CDCCCCCC1ABC24419A9999D9D86059419A999999BEBB24419A9999B9B460594166666666E6BB2441CDCCCC2CB260594166666666D7BB2441666666469B605941CDCCCCCC94BB2441666666A69B605941666666665EBB2441666666669C605941CDCCCCCC53BB24419A9999399C605941CDCCCCCC4ABB24419A9999D99B60594166666666DEBA2441000000E098605941CDCCCCCC52BA24419A999939956059410000000022BA2441CDCCCC2C9460594100000000C9B92441000000A0936059416666666673B924419A9999F99260594166666666FAB824413333337392605941CDCCCCCC77B82441333333D391605941CDCCCCCC11B8244100000020916059416666666674B72441CDCCCCEC8F60594166666666EEB62441CDCCCCEC8E60594133333333C9B62441333333138F60594133333333C4B62441666666868B60594100000000BCB62441333333538860594100000000ABB6244133333353896059419A9999997BB62441000000208C605941666666665AB624419A9999998D605941CDCCCCCC43B62441333333538E605941CDCCCCCC28B624419A9999F98E60594133333333F3B52441666666A68F60594133333333ACB52441000000C0906059413333333353B52441666666269260594133333333B0B42441CDCCCC6C94605941CDCCCCCCC3B32441CDCCCC8C986059413333333349B32441000000609A6059413333333321B32441333333139B60594100000000BDB22441000000A09C605941333333333EB22441666666669E60594166666666EBB12441000000609F60594100000000AAB1244166666606A0605941CDCCCCCC67B1244133333373A0605941666666662DB12441CDCCCC6CA16059419A99999901B124419A999999A260594166666666C1B0244100000020A5605941000000007FB0244100000000A8605941CDCCCCCC39B0244166666606AB605941CDCCCCCC2EB02441666666A6AB6059413333333338B02441CDCCCCCCAC60594133333333ECB02441333333D3C36059419A9999997BB12441CDCCCCECD76059419A999999DDB12441CDCCCCACE560594100000000BFB224419A999959F96059419A99999992B324419A99999914615941CDCCCCCC56B32441CDCCCC2C17615941333333335FB124410000000021615941CDCCCCCC50B12441333333332E6159419A9999990EB124419A999939656159413333333309B12441666666E667615941CDCCCCCC04B124419A9999396A61594100000000D4B024416666664679615941CDCCCCCCB6B024416666660687615941CDCCCCCCC2B0244100000080A2615941666666661FB12441000000E0CC61594166666666A4B1244133333373F8615941CDCCCCCC18B124419A9999D9FE6159413333333383B024410000008001625941CDCCCCCC89AF24410000000008625941CDCCCCCCC6AE2441CDCCCCEC116259413333333394AE2441CDCCCC6C15625941000000006AAE2441333333D317625941000000004CAE2441666666A619625941333333330EAE2441CDCCCCEC1C6259419A999999CBAD24410000006020625941000000009DAD24419A99991922625941000000007AAD24413333333323625941000000001AAD2441CDCCCCAC2562594133333333E9AC244166666626276259419A999999A6AC244133333333296259419A99999967AC2441333333F32A625941000000003AAC2441666666062C62594100000000EBAB2441000000C02D62594133333333BCAB24419A9999592E6259416666666688AB2441000000402E625941CDCCCCCC5BAB2441CDCCCCAC2D625941CDCCCCCC3EAB2441333333532D625941000000002EAB2441333333D32C62594166666666FBAA2441333333F32F625941000000002AAA2441CDCCCC6C3662594133333333B8A82441CDCCCCCC366259410000000054A82441CDCCCCEC3162594100000000B3A724419A9999D9216259419A99999926A72441000000801A6259419A999999CCA624419A9999591962594166666666BFA6244133333333226259410000000017A72441000000C03862594133333333C5A62441333333933D625941CDCCCCCC75A6244166666666466259419A99999955A52441333333335D6259419A999999CAA42441333333536C62594100000000A3A424419A9999597162594133333333A3A424419A999919756259413333333319A424419A9999B99062594133333333ADA3244133333353AC625941CDCCCCCC40A32441CDCCCCACC16259419A9999992DA32441CDCCCC2CCE625941CDCCCCCC22A32441CDCCCC8C10635941333333330CA32441CDCCCC8C17635941CDCCCCCCC6A22441333333332063594100000000C1A224413333339320635941CDCCCCCCB5A22441CDCCCC8C2163594133333333A1A224419A99997923635941CDCCCCCC7DA22441666666C6266359416666666652A12441000000E0106359413333333378A024419A999999276359419A9999995AA02441000000A02C63594133333333A1A02441CDCCCCCC376359419A999999B5A02441666666C63C6359410000000045A02441CDCCCC6C496359416666666630A02441CDCCCC2C4A6359413333333319A024419A9999994B635941CDCCCCCCF99F2441666666464E63594100000000C89F24416666668653635941333333336E9F2441CDCCCC4C5D635941000000002C9F2441666666866463594166666666029F2441000000C06A63594166666666EE9E2441333333136D6359419A999999AD9E2441000000C0766359419A999999739E24419A9999197F63594133333333399E24419A999959876359419A999999ED9D244100000080916359419A999999AA9D2441CDCCCCEC9A63594100000000709D2441CDCCCCECA26359419A9999995B9D24419A9999D9A563594166666666369D2441CDCCCC2CAB63594166666666009D24419A999999B263594100000000E59C244133333353B663594166666666D29C24419A9999D9B8635941CDCCCCCC9F9C2441CDCCCCCCBF63594166666666679C24419A999979C7635941CDCCCCCC3E9C244133333333CD63594166666666209C2441333333F3D16359419A999999EC9B24419A9999B9DA6359419A999999BE9B2441CDCCCC0CE363594166666666B79B244100000060E4635941333333339C9B244100000060E9635941000000006E9B244166666626F263594100000000589B244133333393F5635941CDCCCCCC439B24419A9999B9F7635941333333332B9B244166666686F96359419A999999FB9A24419A999959FC63594166666666F59A24419A9999B9FC63594166666666D09A2441CDCCCCCCFE635941CDCCCCCC8B9A2441333333D302645941CDCCCCCC709A2441CDCCCC6C0464594100000000449A24419A9999190764594166666666CC992441CDCCCCEC0D645941000000005B9924419A99997914645941CDCCCCCC1F992441CDCCCC0C18645941000000009E9824419A9999791F645941666666666A9824416666666622645941000000004F9824419A9999F9236459419A999999F3972441CDCCCC4C2964594133333333BB972441333333732C64594166666666AB9724419A9999592D6459419A9999993397244133333373346459419A999999E8962441000000C038645941333333330D962441CDCCCC2C60645941CDCCCCCC04962441666666A67664594166666666DF952441CDCCCC2C9C64594133333333AE95244133333373A76459419A999999199524419A999999BB64594100000000109524419A9999D9C1645941	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	01010000206A080000A6AF2EFCFABA2441333333F36F635941	180270000	Z	Bengy-sur-Craon	1802700	18027	18	24	36
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	01010000206A0800000AD5DDC676BE2341343333B31F725941	180280000	Z	Berry-Bouy	1802800	18028	18	24	32
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	01010000206A0800004E09F26016D72441333333D38B485941	180290000	Z	Bessais-le-Fromental	1802900	18029	18	24	26
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	01010000206A080000843D2FB75A5224419A999909CA9D5941	180300000	Z	Blancafort	1803000	18030	18	24	65
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	01010000206A08000084C71B195FB92441343333A3FC565941	180310000	Z	Blet	1803100	18031	18	24	31
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	01010000206A080000249B2BF370192541000000E04C925941	180320000	Z	Boulleret	1803200	18032	18	24	33
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	01060000206A0800000100000001030000000100000025000000666666666DFA23419A9999F93A6F59419A999999BDFA2341000000A03F6F5941CDCCCCCC18FB2341000000204D6F5941CDCCCCCC5BFB234100000060516F59413333333398FB2341CDCCCCCC4E6F594133333333CCFB234166666646586F5941666666660BFC2341000000205D6F59419A999999A2FC234133333393726F59419A999999D1FC2341CDCCCCCC766F5941000000004AFD23419A9999197F6F59410000000086FD2341333333D3846F594100000000C1FD2341CDCCCC6C866F594166666666D0FD234133333373826F59419A999999E6FD2341CDCCCC2C866F594133333333C1FE2341666666069F6F594100000000DCFE2341CDCCCC4C9B6F5941CDCCCCCC34FF2341CDCCCC4CA16F59419A99999968FF2341CDCCCC8C976F59416666666634FE234133333333746F59416666666651FE2341CDCCCC6C6E6F5941666666661BFF2341CDCCCC4C4A6F59419A9999997BFF2341333333B3446F59413333333310002441CDCCCCCC3A6F59416666666611FF2341CDCCCCACF86E5941CDCCCCCC90FE234166666626006F59416666666630FE2341666666E6036F59416666666651FE2341CDCCCC8C136F59416666666645FE2341666666E6176F59419A999999D0FD23419A9999392D6F5941333333337DFD2341CDCCCC0C266F59416666666606FD2341666666463B6F5941333333336CFC2341000000802D6F5941CDCCCCCCFFFB234133333373416F59419A999999F3FA234100000000316F5941CDCCCCCCB8FA2341000000E0366F5941666666666DFA23419A9999F93A6F5941666666666DFA23419A9999F93A6F5941	01010000206A080000282EE46811FD2341666666B64B6F5941	180331002	H	Chancellerie 2	1803310	18033	18	24	0
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