
# CHANGELOG 2025-07.a

## Nouveautés générales

⚠️ : des changements ont eu lieu dans deux versions mineures 2024.10.b et 2024.10.c non publiées en open data en plus des changements décrits ici, n\'oubliez pas de les consulter à la suite de cette section. 

## Mise à jour des données sources


| Fournisseur de données | Jeu de données | Millésime |
| :--------: | -------- | :--------: |
| ADEME      | [Diagnostic de Performance Energétique (DPE)](https://data.ademe.fr/datasets/dpe03existant)    | 2025-09  |
| ANAH     | [Registre National des Copropriétés (RNC)](https://www.data.gouv.fr/fr/datasets/registre-national-dimmatriculation-des-coproprietes/)     | 2025-T3     |
| ARCEP     | [Base immeuble](https://data.arcep.fr/fixe/maconnexioninternet/base_imb/index.html)     | 2025-09     |
| CEREMA     | [Fichiers Fonciers](https://datafoncier.cerema.fr/fichiers-fonciers)  | 2024     |
| CEREMA     | [Données Valeurs Foncières (DVF)](https://datafoncier.cerema.fr/donnees/autres-donnees-foncieres/dvfplus-open-data)     | 2025-04     |
| DGFIP     | [MAJIC Personne Morale](https://www.data.gouv.fr/datasets/fichiers-des-locaux-et-des-parcelles-des-personnes-morales/)   | 2024     |
| MTE | [Répertoire des logements locatifs des bailleurs sociaux (RPLS)](https://www.data.gouv.fr/fr/datasets/repertoire-des-logements-locatifs-des-bailleurs-sociaux/) | 2024     |
| IGN | [Base d\'Adresse Nationale (BAN)](https://adresse.data.gouv.fr/data/ban/adresses/latest/addok) | 2025-07 |
| France Chaleur Urbaine | [Réseau de Chaleur Urbain (RCU)](https://www.data.gouv.fr/fr/datasets/traces-des-reseaux-de-chaleur-et-de-froid/)  | 2025-07 |
| MCT/IGN | [Géoportail de l'Urbanisme](https://data.geopf.fr/telechargement/resource/pack_psmv)  | 2025-07  |
| Georisques | [Retrait-Gonflement des Argiles (RGA)](https://www.georisques.gouv.fr/donnees/bases-de-donnees/retrait-gonflement-des-argiles)  | 2025-09     |
| IGN | [BDTOPO](https://geoservices.ign.fr/bdtopo#telechargementsqlfra)  | 2025-06-15     |
| INSEE | [Code Officiel Géographique (COG)](https://www.insee.fr/fr/information/8377162)  | 2025 |
| INSEE | [Base permanente des équipements (BPE)](https://www.insee.fr/fr/statistiques/8217525?sommaire=8217537)  | 2024     |
| INSEE | [Base SIRENE](https://www.data.gouv.fr/datasets/base-sirene-des-entreprises-et-de-leurs-etablissements-siren-siret/)  | 2025-07     |
| MCU | [Immeubles protégés au titre des Monuments Historiques (MERIMEE)](https://data.culture.gouv.fr/api/explore/v2.1/catalog/datasets/liste-des-immeubles-proteges-au-titre-des-monuments-historiques/)  | 2025-09     |
| MTE | [SITADEL](https://www.statistiques.developpement-durable.gouv.fr/catalogue?page=dataset&datasetId=6513f0189d7d312c80ec5b5b)  | 2025-06     |
| MTE | [Données Locales de l'Energie (DLE)](https://www.statistiques.developpement-durable.gouv.fr/donnees-locales-de-consommation-denergie)  | 2024     |
| SPM | [Annuaire de l'Administration](https://www.data.gouv.fr/fr/datasets/service-public-fr-annuaire-de-l-administration-base-de-donnees-locales)  | 2025-03     |
| RNB | [Référentiel National des Bâtiments (RNB)](https://www.data.gouv.fr/fr/datasets/referentiel-national-des-batiments/)  | 2025-07     |


## Tables expérimentales

Ajout et documentation d\'un nouveau type de tables dans la BDNB : les tables expérimentales sont des tables contenant des produits de R&D bénéficiant d\'évolutions importantes. Pour ces tables il n\'est pas garanti un contrat d\'API stable à ce stade.

Les tables concernées sont les suivantes : 

* (bdnb expert) batiment_groupe_simulations_isb
* (bdnb expert) batiment_groupe_imputation_enveloppe_et_systemes_proba

## ⚠️ BREAKING CHANGES ⚠️

(bdnb expert) batiment_groupe_simulations_isb : 

* la table batiment_groupe_simulations_isb qui avait précédemment une double clef primaire (batiment_groupe_id-type_niveau) change pour n\'avoir une clef primaire uniquement 

* les colonnes ont été toutes modifiées pour préciser la météo utilisée pour réaliser le calcul de degré heure en prévision de l'arrivée de nouveaux indicateurs pour d\'autres météos prospectives dans un futur millésime à paraitre 

* (bdnb open) : suppression des colonnes lien_valide et classe dans rel_batiment_groupe_adresse (colonne dépréciée depuis 2 millésimes)

* batiment_groupe_rnc (partie convention ANAH)
  * suppression des colonnes ayant_droit_rnic

## Nouveautés


* **(bdnb ayant droit) rel_batiment_groupe_usage :**  (nouvelle table)

Table contenant l’ensemble des usages détaillés de chaque bâtiment avec leurs surfaces et nombre de locaux associés (si disponibles).

Sources :
Cette table compile des informations issues :
- des fichiers fonciers
- de la BDTOPO (zones d’activité)
- de la base SIRENE (entreprises)
- et de nombreuses bases recensant des usages publics des bâtiments harmonisées dans le cadre du projet collaboratif ESPACE avec le CEREMA :
  - annuaire de l’administration
  - base des équipements sportifs
  - annuaire de l’éducation,
  - base FINESS (ministère de la santé),
  - patrimoine immobilier de l’enseignement supérieur,
  - base BASILIC (lieux et équipements culturels),
  - crèches,
  - gares ferroviaires.

pour plus d\'informations sur cette table, vous pouvez consulter l'article dédié sur notre site (https://bdnb.io/documentation/usage_detaille_bdnb/)

* **(bdnb ayant droit) batiment_groupe_synthese_propriete_usage :** 
  * ajout des colonnes usage_niveau_2_bdnb et usage_niveau_3_bdnb qui fournissent l'usage principal détaillé du bâtiment, cette donnée est pour l'instant exposée uniquement aux ayants droit fichiers fonciers. 


* **(bdnb expert) batiment_groupe_urbanisme :** ajout des contraintes patrimoniales d\'urbanismes locales établies dans les PLU

* ⚠️ **(bdnb expert) batiment_groupe_simulations_dpe/local_simulations_dpe :** ⚠️ : les simulations DPE intègrent dès à présent le calcul du DPE avec le coefficient d\'énergie primaire pour le vecteur *électricité* à 1.9. Ce changement majeur qui rentrera en vigueur officiellement au 1er janvier 2026 réduit de manière importante le nombre de passoires énergétiques évalué par le dispositif DPE. (source : https://rt-re-batiment.developpement-durable.gouv.fr/faq-dpe-modification-du-facteur-de-conversion-en-a1021.html?lang=fr)

## Améliorations diverses

* **(bdnb open) tous bâtiments :** certains locaux fichiers fonciers n\'étaient pas proprement intégrés dans des bâtiments de la BDNB ceci est désormais résolu. Des tests d\'intégration ont été mis en place pour palier ces anciens écueils.
* **(bdnb open) tous bâtiments :** traitement pour rendre valides certaines géométries non valides du cadastre pour ne pas les perdre dans la BDNB.
* **(bdnb open) tous bâtiments :** amélioration de la prise en compte de la position de l'adresse associée à un bâtiment foncier pour son attribution à un groupe de bâtiment. En conséquence, un nombre de *bâtiment groupe* plus important est constitué d\'un seul *bâtiment construction*, améliorant la précision de définition des bâtiments dans la BDNB 
* **(bdnb open) tous bâtiments :** amélioration des méthodes d\'association des adresses aux batiment_construction et batiment_groupe en combinant des approches géométriques et de rapprochement d\'adresses fiscales avec des adresses BAN et corrections de bugs mineurs. En conséquence, les tables BDNB de relations bâtiment-adresse" sont plus fiables qu\'avant. 
* **(bdnb open) tous bâtiments :** reclassification de bâtiments à usage indéterminé en dépendance lorsque l'information fiscale est disponible pour une majorité de parcelles cadastrales accueillant un bâtiment résidentiel et d\'autres constructions physiques.
* **(bdnb open) tous bâtiments :** Améliorations diverses sur la qualification des usages de bâtiments. Notamment entre maisons individuelles et bâtiments d\'habitation collective.
* **(bdnb open) tous bâtiments :** requalification des bâtiments BDTOPO qualifiés comme *léger* par l'IGN lorsqu\'ils correspondent à des usages de bâtiments "lourds" (logement bureau etc.) dans les données foncières.
* **(bdnb ayant droit) parcelle_unifiee** : les unités foncières (TUP) non bâties n\'étaient pas proprement intégrées dans la BDNB. Cela est désormais corrigé.
* **(bdnb ayant droit) parcelle_unifiee_metrique** : corrections de multiples bugs sur les métriques des parcelles unifiées. L\'ensemble des quantitatifs affichés sont à présent corrects.
* **(bdnb open) tables DPE :** les DPE sont géolocalisés à l'aide de leur position RNB et parcelle en complément des adresses. Pour les géolocalisations RNB cela ne concerne que les géolocalisations renseignées par les diagnostiqueurs.
* **(bdnb expert) batiment_groupe_simulations_isb** : correction d\'un bug qui empéchait le calcul de l'indicateur de surchauffe bâtiment pour certains IRIS sans logements collectifs.
* **(bdnb expert) batiment_groupe_simulations_isb** : ajout des apports solaires pour le calcul de l'indicateur de surchauffe bâtiment.
* **(bdnb open) contexte administratif :** Ajout de la couche d\'information géographique sur les *cantons* selon les définitions du COG de l'année courante.
"

# CHANGELOG 2024-10c

## Nouveautés Générales

* ajout des données issues des DPE tertiaires  (BDNB open)
* ajout d'une table d'imputation des performances de l'enveloppe et des systèmes pour les logements (utilisateurs avancés)  (BDNB expert)

## tables ajoutées

* **batiment_groupe_dpe_tertiaire :** (bdnb open) données sur le DPE tertiaire le plus récent du groupe de bâtiment
* **dpe_tertiaire :** tous les DPE tertiaires (bdnb open)(de 2014 à aujourd'hui)

* **batiment_groupe_synthese_systeme_energetique_tertiaire :** (bdnb expert) données sur les systèmes énergétiques dans le tertiaire, initialisée avec les DPE tertiaires, les données locales de l'énergie et les tracés de réseau de chaleur pour cette première version.

* **batiment_groupe_imputation_enveloppe_et_systemes_proba :** (bdnb expert) données de prédiction probabiliste des systèmes énergétique et de la performance d'isolation pour les bâtiments de logements. Ce sont les données probabilistes en entrée de nos simulations DPE.  (https://bdnb.io/documentation/predictions_dpe/)


## améliorations

* **fix :** type_energie_ecs était null sur toutes les lignes pour les DPE logements -> corrigé
* **fix :** les DPE désactivés sont désormais correctement supprimés des tables DPE
* **fix :** les installations photovoltaiques déclarées sans production positives ne sont plus considérées commes des installations photovoltaique pour les DPE logement


# CHANGELOG 2024-10b

## Nouveautés Générales

* données de contraintes d'urbanismes : sites patrimoniaux et périmètres monuments historiques (BDNB open/expert)
* données de contraintes/opportunité à la rénovation : pompes à chaleur dans le résidentiel collectif (BDNB expert)
* aléa sismique (BDNB open)
* classe famille incendie, classe hauteur risques sismiques (BDNB expert)
* mise à jour RPLS 2024 

## tables ajoutées

* batiment_groupe_urbanisme (bdnb open/expert) : première version d'une table qui fourni des contraintes et réglementations d'urbanismes sur les bâtiments. Cette table intègre dans cette première version des informations sur les zonages patrimoniaux. Cette table remplace la table batiment_groupe_merimee sur les bâtiments historiques qui est dépréciée. 

\t* bâtiments dans un périmètre AC2, AC4 : sites patrimoniaux remarquables et sites méritant d'être protégés (expert)
\t* bâtiments dans un périmètre AC1 : périmètre autour des monuments historiques (open)
\t* bâtiments qui sont eux mêmes des bâtiments classés au titre des monuments historiques. (open)

* batiment_groupe_contrainte_opportunite_renovation : première version d'une table qui fourni des éléments d'opportunités, de contraintes et de faisabilité sur des gestes de rénovation. Dans cette première version les données disponibles concernent les pompes à chaleur dans le résidentiel collectif

\t* indicateur de faisabilité de mise en place d'une solution de pompe à chaleur sur chaque bâtiment résidentiel collectif
\t* sous indicateurs qui détaillent les principaux critères qui sont pris en compte pour définir cette faisabilité de mise en place d'une pompe à chaleur. 

* batiment_groupe_risques : table qui regroupe toutes les données d'aléa et de vulnérabilité au risque des bâtiments. Dans cette première version cette table centralise les aléa argiles, radon, sismique ainsi que les classe de réglementation incendie et sismiques. 

## tables dépréciées

* les table batiment_groupe_argiles et batiment_groupe_radon sont dépréciées au profit de la table batiment_groupe_risques
* la table batiment_groupe_merimee est dépréciée au profit de la table batiment_groupe_urbanisme. 


# Changelog BDNB 2024-10a

## Nouveautés générales:

* Ajout de nouveaux indicateurs d\'usages des bâtiments plus complet dans batiment_groupe_synthese_propriete_usage
* Indicateur de surchauffe estivale évalué sur tous les bâtiments résidentiels (BDNB expert)
* Mise à disposition des données SITADEL (permis de construire) dans deux nouvelles tables
* Mise à jour des données socles :  fichiers fonciers (2023) + BDTOPO (2024-08) + BAN (2024-10)
* Mise à jour de la plupart des sources de données (consulter le fichier de documentation onglet source)


## Ajouts de tables

* **batiment_groupe_synthese_propriete_usage :** nouvelle table qui contient des indicateurs d\'usages consolidées en utilisant de multiples sources en plus des fichiers fonciers.
    *  usage_principal_bdnb_open : nouvelle variable d\'usage principal du bâtiment à utiliser au lieu de usage_niveau_1_txt :
        * Résidentiel individuel
        * Résidentiel collectif
        * Tertiaire
        * Secondaire
        * Dépendance
        * Indifférencié
    *  categorie_usage_propriete : classification du bâtiment utilisant des informations d\'usage et de propriété : 
        *  Résidentiel individuel social
        *  Résidentiel individuel privé
        *  Résidentiel collectif social
        *  Résidentiel collectif copropriété
        *  Tertiaire public
        *  Tertiaire privé
        *  Secondaire
        *  Dépendance
* **sitadel et parcelle_sitadel :** nouvelles tables disponibles pour traiter des données sur les constructions nouvelles, extensions et démolitions. 
* **batiment_groupe_simulations_isb :** indicateur de surchauffe des bâtiments.

## Tables modifiées:

* **batiment_groupe_indicateur_reseau_chaud_froid :**  ajout des réseaux de chaleurs en cours de construction.
* **batiment_groupe_dle_elec/gaz/reseau_multimillesime :** 
    * ajout des données locales de l'énergie 2023 (sauf pour le gaz ⚠️ problème de mise à disposition par le producteur)
    * résolution d\'un problème sur les clefs de répartition des consommations au batiment_groupe lorsque l'adresse de la DLE est associé à plusieurs bâtiments, la répartition se fait bien en proportion du nombre de logements de chaque bâtiment. 
    * correction des données locales de l'énergie qui sont affectées pro" par les distributeurs d\'énergies lorsque ces données sont celles concernant des chaudières collectives de bâtiments résidentiels -> elles sont requalifiées en résidentiel. 

* **parcelle:** ajout du code_commune_insee dans la table 

* **batiment_groupe_adresse :** amélioration de la logique de détermination de l'adresse principale d\'un bâtiment basée sur le nombre de locaux du bâtiment associés à cette adresse. 

* **dpe_logement/batiment_groupe_dpe_representatif_logement :**
    * fix les bâtiments sans logements ne peuvent plus être associés à des DPE logements
    * fix le type d\'énergie des générateurs d\'ECS et de chauffage est toujours cohérent avec le générateur quand les données brutes du DPE sont incorrectes

* **batiment_groupe_rnc :** correction du nombre de lots tertiaires (qui était précédemment mal affecté comme la somme de logements et tertiaire)

* **batiment_groupe_synthese_systeme_energetique_logement (BDNB expert) :** intégration des données de raccordement de réseau de chaleur pour corriger/ajouter les bâtiments effectivement raccordés aux réseaux. 


* **batiment_groupe_simulations_dpe/local_simulations_dpe (BDNB expert) :**

    * mise à jour de la méthode de calcul avec l'arrêté dit "petites surfaces" du 1er juillet 2024
    * mise à jour de la méthode d\'imputation des données d\'entrées du calcul DPE.
    * amélioration de la modélisation des ponts thermiques et de l'estimation des surfaces déperditives.

## ⚠️ Tables supprimées

* **batiment_groupe_osm_building : dépréciée depuis plusieurs millésimes cette table est supprimée définitivement**

## ⚠️ problèmes connus 

* **batiment_groupe_simulations_dpe/local_simulations_dpe (BDNB expert) :** un problème non résolu dans les simulations dpe entraine une  perte de 4% des bâtiments de logements non simulés. Nos équipes travaillent à identifier la source du problème et à apporter une correction rapidement

## formats d\'exports

* projet QGIS géopackage -> passage à une présentation avec une couche multi style pour la couche batiment_groupe (la couche était précédemment dupliquée en plusieurs couches pour chaque représentation d\'indicateur)

"
# Changelog BDNB 2023-11.a

## tables_ajoutees

- rel_batiment_construction_rnb : lien entre les identifiant du référentiel national des bâtiments et les objets de la BDNB
- batiment_groupe_reseau_chaud_froid : nouvelle table qui identifie les bâtiments raccordés aux réseaux de chaleurs ainsi qu'un indicateur de potentiel de raccordement aux réseaux de chaleur existants.
- batiment_groupe_simulations_valeur_verte : nouvelle table qui estime les gains en revalorisation foncière attendus après une rénovation qui fait évoluer l'étiquette DPE du bâtiment
- siren : table des siren (pour pouvoir récupérer des informations sur les entreprises liées à des bâtiments)
- siret : table des siret (pour pouvoir récupérer des informations sur les entreprises liées à des bâtiments)
- rel_batiment_groupe_siret : table de relation entre les bâtiments groupes et les siret (base sirene)
- rel_batiment_groupe_siren : table de relation entre les siren et les groupes de bâtiment (propriété et établissement)
- iris_contexte_geographique : table de synthèse au niveau Iris des différents contextes géographiques utiles pour contextualiser les bâtiments.
- iris_simulations_valeur_verte : nouvelle table qui estime les gains en revalorisation foncière attendus après une rénovation qui fait évoluer l'étiquette DPE du bâtiment (aggrégé iris)

## tables_modifiees

- batiment_groupe_argiles : Table dépréciée qui sera remplacée par une table plus complète à venir sur les risques sur les bâtiments
- batiment_groupe_radon : Table dépréciée qui sera remplacée par une table plus complète à venir sur les risques sur les bâtiments
- rel_batiment_groupe_qpv : Table dépréciée et entièrement remplacée par batiment_groupe_qpv
- rel_batiment_groupe_adresse : amélioration de la méthode de rattachement des adresses à des bâtiments, limitation de faux positifs d'adresses qui étaient raccordés à plusieurs bâtiments par erreur
- rel_batiment_groupe_parcelle : amélioration de la méthode de rattachement des parcelles à des bâtiments, limitation de faux positifs de parcelles qui étaient raccordés à des bâtiments à cause de problèmes d'alignement cadastre BDTOPO (https://gitlab.com/BDNB/base_nationale_batiment/-/issues/823)
- batiment_groupe_rnc : fix d'un bug toutes les copropriétés identifiées par la parcelle sont bien de nouveau remontées dans cette table
- batiment_groupe_adresse : amélioration de la logique de détermination de l'adresse principale.

## tables_supprimees

- batiment_groupe_dpe : suppression de cette table dépréciée -> utiliser batiment_groupe_dpe_statistique_logement
- batiment_groupe_dpe_logtype : suppression de cette table dépréciée -> utiliser batiment_groupe_dpe_representatif_logement

## vues_modifiees

- batiment_groupe_compile : vue dépréciée qui sera remplacée par une vue synthétique de la base de données à venir
- batiment_groupe_compile_compat_v06 : vue dépréciée qui sera remplacée par une vue synthétique de la base de données à venir

# Changelog BDNB 2023-01.a

## tables_ajoutees

- passage_millesime_batiment_groupe_id : Nouvelle table
- rel_batiment_construction_rnb : Nouvelle table expérimentale stockant les identifiants du Référentiel National des Bâtiments (RNB). Dans les prochaines versions, cet identifiant sera intégré dans la table batiment_constuction directement.

## tables_modifiees

- adresse : ["ajout d'un champ libelle_adresse qui concatène l'ensemble des informations", 'suppression de la \'source\' "fichiers fonciers" dans les sources d\'adresse (non pertinente méthodologiquement)']
- batiment : changement de la modalité 'origine' **Cadastre** pour **Autre**
- batiment_construction : 'batiment_groupe_id' et 'batiment_construction_id' au format nano-id
- batiment_groupe : ['fiabilisation du croisement et intégration de nouvelles entrées "bâtiment-construction", réduisant considérablement le différentiel avec le jeux de données BDTopo de l\'IGN', 'batiment_groupe_id -> changement de tous les identifiants pour utiliser un nano-id']
- batiment_groupe_bdtopo_bat : ajout de la colonne 'max_hauteur'
- batiment_groupe_exposition_bruit_logement_social : MAJ des données + nouvelles colonnes : 'exposition_bruit_routier_et_ou_ferroviaire', 'nb_logement_social_expose_bruit_rte_et_ou_fer', 'type_exposition_bruit_routier_et_ou_ferroviaire'
- batiment_groupe_ffo_bat : ['Calcul de nb_log_hlm modifié car auparavant correspondait à hlm + sem', 'modification des descriptions de nb_log_hlm, nb_log_sem, nb_log_soc pour refléter ce qui est réellement réalisé']
- batiment_groupe_rnc : ['Ajout des données open', "nouvelles colonnes -> 'l_siret', 'copro_dans_pvd'"]
- batiment_groupe_rpls : ['Ajout des données open,', 'MAJ 2022,', "Nouvelles colonnes -> 'rpls_open', 'classe_ener_principale', 'classe_ges_principale', 'raison_sociale_principal', 'siret_principal'"]
- parcelle : report du non-id de la parcelle unifiee
- rel_batiment_groupe_adresse : ["classe -> dépréciation de la classe d'association 1.1 -> 9.X", 'lien_valide -> Déprécié', "Ajout d'une colonne 'origine' -> [Fichiers Fonciers, Association Géométrique, Fichiers Fonciers + Association Géométrique]"]
- rel_batiment_construction_adresse : ["Ajout d'une table de relation entre les bâtiments construction et des adresses", "Nouvelle méthodologie d'association des bâtiments construction aux adresses.", 'Cette nouvelle méthode permet de récupérer des adresses non documentées dans les fichiers fonciers et de les lier à des bâtiments construction et des bâtiments groupes.', 'Cette table permet également d\'attribuer des adresses postales aux entrées "bâtiment-construction" non référencées dans les données foncières']
- rel_batiment_groupe_parcelle : ajout d'une propriété 'parcelle_principale' pour documenter s'il s'agit de la parcelle principale du bâtiment groupe.
- rel_batiment_groupe_argile : renommage de la colonne 'argile_niveau' par 'argile_non_officiel_id'
- rel_batiment_groupe_merimee : ['relation entre les batiments_groupe et les references merimées dans un périmère de 500m', 'Ajout des relations entre les batiments_constructions proches (moins de 500m) et les références mérimées']
- rel_batiment_groupe_pees : Nouvelle table
- rel_batiment_groupe_pies : Nouvelle table
- rel_batiment_groupe_rnc : ['MAJ 2022', "renommage de l'index 'rnc_numero_immat' en 'numero_immat'", "ajout colonnes 'fiabilite_globale', 'parcelle_id', 'parcelle_unifiee_id'"]
- rel_batiment_groupe_rpls : ['MAJ 2022', "renommage de l'index 'rpls_non_officiel_id' 'ident_rpls'", "ajout colonnes 'fiabilite_globale', 'batiment_id', 'local_id', 'rpls_open'"]

## tables_supprimees


## vues_modifiees


# Changelog BDNB 2022-10.d

## tables_ajoutees

- rel_batiment_groupe_bruit : nouvelle table
- rel_batiment_groupe_dvf_open : table relationnelle entre les mutations dvf open et les batiment_groupe
- batiment_groupe_dvf_open_representatif : table des mutations représentatives des batiment_groupe associés aux mutations
- batiment_groupe_dvf_open_statistique : table de statistique des mutations à l'échelle du batiment_groupe
- rel_batiment_groupe_dle_elec_2018 : nouvelle_table
- rel_batiment_groupe_dle_elec_2019 : nouvelle_table
- rel_batiment_groupe_dle_elec_2020 : nouvelle_table
- rel_batiment_groupe_dle_elec_2021 : nouvelle_table
- rel_batiment_groupe_dle_gaz_2018 : nouvelle_table
- rel_batiment_groupe_dle_gaz_2019 : nouvelle_table
- rel_batiment_groupe_dle_gaz_2020 : nouvelle_table
- rel_batiment_groupe_dle_gaz_2021 : nouvelle_table
- rel_batiment_groupe_dle_reseaux_2020 : nouvelle_table
- rel_batiment_groupe_dle_reseaux_2021 : nouvelle_table
- batiment_groupe_bdtopo_bat : fix inversion de colonne dans la doc
- batiment_groupe_pie : ajout d'une nouvelle table
- batiment_groupe_rpls : mise à jour de la table batiment_groupe_rpls millésime 2019 par la table batiment_groupe_rpls millésime 2022
- rel_batiment_groupe_rpls : mise à jour de la table rel_baitment_groupe_rpls millésime 2019 par la table rel_baitment_groupe_rpls millésime 2022
- rel_batiment_groupe_dle_elec_multimillesime : nouvelle_table
- rel_batiment_groupe_dle_gaz_multimillesime : nouvelle_table
- rel_batiment_groupe_dle_reseaux_multimillesime : nouvelle_table
- batiment_groupe_dle_elec_multimillesime : nouvelle_table
- batiment_groupe_dle_gaz_multimillesime : nouvelle_table
- batiment_groupe_dle_reseaux_multimillesime : nouvelle_table
- batiment_groupe_exposition_bruit_logement_social : ajout d'une nouvelle table
- rel_batiment_groupe_pie : ajout d'une nouvelle table
- batiment_groupe_synthese_periode_construction : ajout d'une nouvelle table

## tables_modifiees

- batiment_groupe_ffo_bat : ajout des nombres de residences principales et secondaires
- batiment_groupe_bdtopo_bat : fix inversion de colonne dans la doc
- batiment_groupe_synthese_enveloppe : mise à jour des DPE
- batiment_groupe_synthese_systeme_energetique_logement : mise à jour des DPE
- rel_batiment_groupe_dpe_logement : mise à jour des DPE
- dpe_logement : mise à jour des DPE
- batiment_groupe_dpe_representatif_logement : mise à jour des DPE
- batiment_groupe_dpe_statistique_logement : mise à jour des DPE

## tables_supprimees

- batiment_groupe_dle_elec_2020 : DEPRECATED au profit des tables multi-millesime
- batiment_groupe_dle_gaz_2020 : DEPRECATED au profit des tables multi-millesime
- batiment_groupe_dle_reseaux_2020 : DEPRECATED au profit des tables multi-millesime

## vues_modifiees

- batiment_groupe_compile : ajout des nouvelles variables

# Changelog BDNB 2022-10.c

## tables_ajoutees


## tables_modifiees

- filiation_siren (du schéma filiation_siren) : maj de la table avec dernières données dont les fusions/absorptions de bailleurs ALS et complété à partir des info de la table propriétaire
- batiment_groupe_simulations_dvf : nouvelles simulations avec un algorithme plus performant
- batiment_groupe_simulations_valeur_verte : nouvelles simulations avec un algorithme plus performant
- batiment_groupe_simulations_dpe : nouvelles simulations en prenant en compte les nouveaux dpe (suppression des colonnes de type conso_tot car non pertinentes)
- batiment_groupe_synthese_enveloppe : nouvelle table
- batiment_groupe_synthese_systeme_energetique_logement : nouvelle table
- dpe_logement : nouvelle table
- local_simulations_dpe : nouvelle table
- batiment_groupe_dpe_representatif_logement : nouvelle table
- batiment_groupe_dpe_statistique_logement : nouvelle table
- batiment_groupe_ffo_bat : fix problème lié aux usages qui étaient parfois incohérents
- rel_batiment_groupe_dpe_logement : nouvelle table
- batiment_groupe_proprietaire : correction de la colonne propriétaire principal, l'algorithme sort désormais le propriétaire avec la plus grande surface de locaux
- iris_simulations_valeur_verte : nouvelle table

## tables_supprimees

- batiment_groupe_dpe : DEPRECATED (uniquement anciens DPE arrêté 2012) -> est remplacé par batiment_groupe_dpe_statistique_logement (inclus ancien et nouveau DPE)
- batiment_groupe_dpe_logtype : DEPRECATED (uniquement anciens DPE arrêté 2012) -> est remplacé par batiment_groupe_dpe_representatif_logement (inclus ancien et nouveau DPE)
- rel_batiment_groupe_dpe : DEPRECATED (uniquement anciens DPE arrêté 2012)

## vues_modifiees

- batiment_groupe_compile : regénérée pour ajouter de nouvelles colonnes
