SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep19;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep19 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep19','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep19','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep19','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep19"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A080000010000000103000000010000004A060000333333334549224100000020B8C158419A9999994D492241000000E0B8C15841CDCCCCCC5149224133333373B9C158416666666654492241666666E6B9C15841CDCCCCCC5649224133333333BBC15841333333335749224100000080BCC15841666666665E4922419A999999BFC15841CDCCCCCC6B4922419A9999B9C4C1584133333333734922419A999959C7C158419A99999974492241CDCCCCECC7C15841333333338549224133333393D0C158419A99999986492241CDCCCCCCD3C158413333333387492241CDCCCCCCD5C15841CDCCCCCC8C49224166666686D8C15841666666668F492241000000A0DAC158410000000093492241333333D3DDC15841000000009749224166666686E0C158419A9999999649224166666626E2C15841CDCCCCCC96492241333333D3E4C1584166666666914922419A9999D9E7C158419A99999980492241333333B3EDC158416666666678492241CDCCCCECEFC158410000000074492241333333F3F1C158416666666670492241333333F3F3C15841666666666F492241333333B3F4C15841333333337049224166666606F7C158419A999999714922419A9999B9FAC15841CDCCCCCC7549224166666606FEC15841333333337A4922410000000001C258410000000084492241000000C003C25841666666668C492241666666E605C2584100000000B94922419A9999590EC25841CDCCCCCCF2492241000000A016C2584133333333174A2241000000401BC258419A999999434A22419A99991920C25841CDCCCCCC4D4A22413333333321C25841000000007D4A2241000000A025C2584100000000CB4A2241333333F32AC25841666666660E4B2241666666462EC2584100000000764B2241CDCCCC8C31C2584166666666014C22416666662637C2584133333333244C22416666662638C2584166666666474C2241666666A638C2584166666666654C22413333335338C258419A999999834C22416666660638C2584166666666AE4C22419A99991938C25841CDCCCCCCC84C22419A99993939C2584133333333FC4C2241CDCCCCAC3DC2584133333333284D22410000002042C258419A999999514D22419A9999F945C25841CDCCCCCC754D2241CDCCCC6C49C25841CDCCCCCC9B4D2241CDCCCC8C4DC258419A999999CA4D2241000000C052C2584133333333E24D22419A99993956C2584166666666E54D2241000000C056C2584133333333F54D22413333335359C25841CDCCCCCC504E22419A9999196AC258419A9999998B4E22410000004076C25841CDCCCCCCAE4E22419A9999197DC2584133333333BB4E2241666666267FC2584133333333C14E2241CDCCCC2C80C2584133333333DE4E2241CDCCCC0C85C258419A999999154F22419A9999798CC25841CDCCCCCC6A4F22416666662699C258419A999999A94F22419A999959A4C25841CDCCCCCCDA4F224100000040B1C25841CDCCCCCC1350224100000060C1C25841CDCCCCCC33502241CDCCCC2CC9C25841666666664650224166666646CDC258419A9999995F502241000000A0D2C2584100000000B05022419A999919DFC2584133333333F4502241666666A6E7C258410000000064512241666666A6F3C2584166666666AC51224166666626FBC2584166666666C5512241333333B3FDC25841333333335B522241666666860DC358419A999999B9522241CDCCCCAC19C35841CDCCCCCCF3522241666666461FC35841000000002D532241CDCCCC0C24C358410000000060532241000000A026C3584133333333A35322416666662629C35841000000001C542241CDCCCCCC2BC35841CDCCCCCC7B542241CDCCCCEC2CC358419A9999999D542241333333532DC358416666666602552241333333332EC358416666666618552241CDCCCC4C2FC35841CDCCCCCC35552241333333F332C35841CDCCCCCC3F552241000000C038C358410000000036552241000000803EC3584133333333295522416666664641C3584133333333EE5422410000004048C35841CDCCCCCCE35422413333333349C35841333333332D542241CDCCCC4C56C358419A999999A25322419A9999795EC358419A99999949532241CDCCCC8C63C3584133333333215322413333335367C35841000000000B532241333333F36AC3584133333333FB522241CDCCCC0C70C3584100000000E9522241000000A079C3584133333333D9522241666666A683C3584100000000CE522241666666868DC358419A999999CC5222416666666695C3584100000000D95222419A9999D99DC358419A999999F2522241666666C6A7C35841333333330F532241CDCCCCCCB0C358419A9999992453224100000040B5C35841CDCCCCCC4F532241666666E6BBC35841333333336F532241CDCCCC0CC0C35841666666669B532241666666C6C3C3584100000000CC532241000000C0C6C358419A9999990B542241CDCCCCECC8C358419A9999994F54224100000020CAC35841CDCCCCCCAD542241CDCCCC4CCAC35841CDCCCCCCC954224100000020CAC3584166666666D5542241CDCCCC0CCAC358419A9999993B5522419A999939C9C35841CDCCCCCC7455224166666646C8C3584133333333B45522419A999959C6C3584166666666DE552241CDCCCCACC4C35841000000001A56224166666666C1C35841666666665556224133333393BFC35841CDCCCCCC78562241CDCCCC6CBFC35841CDCCCCCCBF562241CDCCCC6CC1C3584133333333FA5622419A999959C4C358419A99999960572241CDCCCC4CC7C3584133333333F357224166666666CAC35841666666662758224133333333CCC35841666666663E58224100000060CDC358419A9999994F58224166666646CEC358419A9999996E5822419A999919D1C35841333333338C58224133333393D4C3584133333333A05822419A999999D6C3584100000000AB58224166666606D9C3584133333333C35822419A999959E4C358419A999999D25822419A9999B9ECC3584133333333FD58224133333313F1C35841CDCCCCCC08592241333333B3F3C35841CDCCCCCC095922419A9999D9F6C358419A9999991C592241333333D3FAC358419A9999992D592241CDCCCC8CFFC35841666666664F5922410000004003C4584133333333505922413333339304C45841333333336B592241CDCCCCAC10C45841CDCCCCCC9F592241CDCCCC8C20C4584100000000A7592241CDCCCC4C27C4584133333333A05922419A9999592CC45841666666668C5922410000004030C458416666666667592241CDCCCC8C33C458416666666640592241CDCCCCEC35C45841000000000D592241000000A038C45841CDCCCCCCD5582241666666A63AC458419A999999955822419A9999993CC45841CDCCCCCC6C582241333333B33EC4584166666666485822419A99995941C45841CDCCCCCC29582241000000C045C45841CDCCCCCC02582241666666464DC4584100000000F6572241000000804FC45841CDCCCCCC8E572241CDCCCC2C5FC4584166666666765722419A9999B962C4584133333333605722419A99991966C458413333333340572241666666866AC45841000000001B572241666666066EC458416666666605572241CDCCCC4C6FC4584100000000ED5622410000002070C45841CDCCCCCCB4562241333333D372C45841CDCCCCCC69562241CDCCCCAC75C45841333333333A562241333333B377C458410000000011562241333333337BC4584100000000E8552241CDCCCC6C80C45841CDCCCCCCC25522416666666687C4584100000000AE5522419A9999598DC4584166666666A3552241666666A693C4584133333333A15522410000006098C4584100000000A5552241000000E09DC4584133333333B1552241CDCCCC6CA2C45841CDCCCCCCC855224133333333A8C45841CDCCCCCCDF55224100000060ABC4584133333333F45522419A999979ADC45841000000000156224133333353AEC45841CDCCCCCC95562241CDCCCC0CB7C4584100000000C1562241000000E0B8C4584133333333D8562241CDCCCCACB8C45841CDCCCCCCFD56224133333333B7C4584133333333545722419A9999D9B3C45841666666669B5722419A9999D9B1C458416666666605582241CDCCCC2CAFC4584133333333665822419A999919ACC45841666666669F58224166666606A9C458419A999999CE582241CDCCCC2CA5C45841CDCCCCCCF0582241333333B3A1C458413333333318592241CDCCCC2C9BC45841333333335B592241666666268EC4584133333333815922419A9999D985C458419A99999998592241000000807FC4584100000000AA592241666666E67CC4584166666666D1592241CDCCCC0C78C45841CDCCCCCCFE5922419A99997973C45841CDCCCCCC345A22419A99999971C45841666666668A5A22419A99995970C458419A999999F15A2241000000E06EC4584133333333435B2241333333D36CC458419A9999997E5B2241333333D369C4584133333333A65B2241333333F365C4584133333333BD5B22416666660663C4584133333333C25B22419A99995962C45841CDCCCCCCF65B2241666666665AC45841CDCCCCCC0E5C2241CDCCCCAC58C45841666666663A5C2241CDCCCC2C57C45841CDCCCCCC695C22416666668656C45841CDCCCCCCA55C2241666666A656C4584133333333DB5C2241333333D358C45841000000002D5D2241CDCCCC2C60C458419A9999994B5D2241CDCCCC8C62C45841666666665F5D22413333331363C45841000000007F5D22410000008062C4584133333333C65D22419A9999795FC4584133333333E35D2241000000A05EC4584133333333AE5E22419A99999959C4584100000000005F2241333333B359C458419A999999645F2241000000405BC458419A999999B15F2241CDCCCC6C5EC45841CDCCCCCCE05F22419A99999961C4584166666666026022419A99993966C45841CDCCCCCC206022419A9999396DC4584100000000746022419A99997982C4584100000000856022419A99997986C4584166666666C16022410000006094C458416666666611612241CDCCCC6CA5C458419A9999993961224166666686AEC45841000000004F6122419A9999B9B5C45841333333335B61224133333353BBC458416666666667612241666666A6BEC4584100000000776122419A999999C1C458416666666688612241666666E6C3C45841666666669661224100000000C6C45841333333339F61224133333393C8C4584166666666CA61224100000060D4C4584100000000F661224133333333E0C458416666666611622241CDCCCCACE6C458416666666638622241CDCCCC4CEDC458410000000060622241666666E6F2C45841333333337C622241333333F3F5C4584133333333A1622241CDCCCC6CF8C4584166666666CD62224166666606FBC4584166666666066322419A9999B9FCC458410000000047632241CDCCCCECFDC4584100000000706322419A9999D9FDC45841CDCCCCCC8463224100000080FDC45841333333339B63224166666686FCC458419A999999C56322419A999979FAC4584100000000EB632241CDCCCCECF7C45841333333330C642241333333D3F5C458410000000026642241666666E6F4C45841333333333A6422419A9999B9F4C4584133333333546422419A999919F5C45841333333336F6422419A999979F6C45841333333338064224166666666F8C45841333333338B642241CDCCCCECFAC458413333333396642241CDCCCC8CFDC458419A9999999D6422413333339302C558419A999999A46422413333333306C558419A999999A96422413333337307C558419A999999B8642241000000200AC5584133333333EB6422419A9999B913C5584100000000076522419A9999B918C558419A9999991E652241CDCCCC0C23C55841333333332B652241000000802CC55841666666662C652241CDCCCCEC2DC5584166666666356522413333333337C5584100000000386522410000006040C55841CDCCCCCC326522410000002045C5584166666666326522410000002048C558410000000036652241333333F34AC55841333333333D652241333333F34EC558413333333360652241666666A658C5584100000000946522410000006064C558419A999999C8652241666666866FC5584133333333166622410000008080C55841CDCCCCCC26662241333333D382C558419A99999938662241666666A684C55841CDCCCCCC456622416666668685C55841666666665A6622419A99991986C55841CDCCCCCC786622416666662686C55841CDCCCCCC8C662241000000A085C5584133333333936622410000008085C5584133333333A16622416666662685C558419A999999B5662241CDCCCC8C83C55841CDCCCCCCBC6622413333339382C5584166666666C86622419A99991981C5584166666666D5662241333333537EC5584100000000DD662241666666A679C5584100000000E7662241CDCCCC0C73C55841CDCCCCCCF8662241333333336DC558416666666658672241000000405DC5584133333333B36722413333331350C5584166666666B7672241666666864FC5584166666666F2672241CDCCCC8C49C5584133333333286822410000000046C5584133333333646822413333339343C5584166666666736822413333335343C558419A9999999E682241000000A042C55841333333335A6922413333337340C55841666666661A6A2241333333733FC5584100000000936A2241333333F33EC5584133333333D16A22419A9999593FC55841000000001F6B2241CDCCCCAC41C5584133333333646B2241666666A643C55841666666667A6B2241666666A643C5584100000000906B2241CDCCCC6C43C55841CDCCCCCCAA6B22410000000043C5584166666666CE6B22416666664643C5584133333333E66B22419A9999D943C5584100000000F76B2241CDCCCC8C44C5584133333333246C22419A99991947C5584166666666596C2241333333334BC5584166666666636C22419A9999F94BC5584100000000C36C2241666666E654C558419A999999026D2241000000A05CC5584100000000476D22419A99999966C5584166666666926D22413333333374C5584100000000DC6D2241333333D380C5584166666666086E22419A9999998AC55841CDCCCCCC126E22419A9999B98DC55841000000002C6E22410000004095C5584100000000446E2241666666469EC5584166666666526E2241CDCCCC0CA5C558419A9999995E6E22419A9999B9A7C55841CDCCCCCC6B6E224166666686A9C55841333333337E6E2241CDCCCCCCAAC5584133333333926E22419A999939ABC5584166666666A96E224133333373ABC5584100000000C76E22419A9999D9ABC55841CDCCCCCCD56E224100000040ACC5584100000000EF6E224100000040ADC5584133333333FF6E22419A999919AEC5584166666666136F22419A999999AFC558419A999999236F22419A9999D9AFC55841333333333F6F22419A9999D9AFC5584100000000746F2241CDCCCCCCAEC55841000000009F6F22419A9999F9AEC5584166666666B16F2241CDCCCC6CAFC5584100000000BD6F2241CDCCCC4CB0C5584166666666D06F224100000020B2C558419A999999F56F2241CDCCCC2CB6C55841000000000070224166666606B8C55841333333330A7022419A9999D9B9C558410000000050702241CDCCCCCCC7C55841CDCCCCCC617022419A999919CBC55841666666669070224100000040CFC5584166666666DF70224166666606D3C55841CDCCCCCCF8702241CDCCCC6CD3C55841333333331F712241CDCCCCECD2C5584133333333E371224166666606CFC5584133333333007222419A999999CFC558419A99999911722241CDCCCCACD0C55841CDCCCCCC22722241CDCCCC4CD2C558419A99999926722241CDCCCCECD2C55841666666662F722241000000E0D5C558416666666632722241CDCCCC4CD9C55841000000002D72224100000080DDC558419A9999992272224100000020E2C558419A99999911722241666666C6E6C55841CDCCCCCC05722241000000C0E9C55841000000000172224133333313EDC55841333333330872224100000000F2C55841666666661C72224166666626F6C55841666666663272224100000080F8C558419A99999943722241CDCCCC8CF9C55841CDCCCCCC5B72224100000000FBC5584166666666C37222416666666600C6584133333333EE722241333333F302C6584166666666FA722241CDCCCCCC04C65841CDCCCCCCFC7222416666668606C65841CDCCCCCCFF722241333333730BC658410000000009732241333333730FC6584133333333227322416666666613C6584166666666397322419A9999D915C6584166666666527322413333335317C65841CDCCCCCC747322419A99993917C65841666666668E7322413333335315C658419A999999BD732241000000000FC65841CDCCCCCCEC732241000000C007C65841333333330C7422419A99999904C658419A9999992B742241333333D302C658419A99999972742241000000A0FFC558419A9999999274224133333353FDC5584100000000AC7422419A9999B9F8C558419A999999DE742241333333D3ECC55841666666660375224166666606E7C558416666666627752241CDCCCC8CE3C558410000000048752241666666A6E1C55841666666666E752241333333B3E1C55841333333338B752241666666E6E2C5584100000000BA752241333333D3E6C55841CDCCCCCCE07522419A999959EBC55841666666661076224166666606F3C55841666666662876224100000060F6C558416666666649762241CDCCCCCCF8C55841333333335F7622419A9999F9F9C55841333333337976224166666626FAC558410000000090762241666666C6F8C55841666666669E762241000000A0F6C5584133333333B87622419A9999D9EDC5584100000000DB76224166666646E3C558413333333309772241CDCCCCECD7C55841000000003377224166666626D1C55841333333335677224166666626CEC55841333333337B772241666666E6CCC558410000000097772241CDCCCCCCCCC5584133333333BD772241CDCCCC6CCEC5584166666666D7772241CDCCCC4CD1C55841CDCCCCCCF4772241000000A0D6C55841333333331178224166666626DAC5584100000000387822419A999939DCC55841000000007278224133333333DFC55841666666667C7822419A999959E0C55841000000007D782241CDCCCC6CE0C55841CDCCCCCC90782241CDCCCC8CE2C558419A999999B378224166666686E6C5584166666666DF782241CDCCCCECEAC55841CDCCCCCCEF782241CDCCCC8CEDC5584100000000FF78224133333353EFC55841666666660B7922419A9999D9EFC55841333333331D792241333333D3EFC55841666666662E7922419A9999F9EEC55841CDCCCCCC5279224133333333ECC55841666666667079224166666646E9C5584100000000817922419A9999F9E6C55841666666668B792241CDCCCC4CE4C5584133333333A57922419A9999B9DBC5584166666666B779224166666666D6C5584166666666D9792241666666A6CEC558419A999999ED792241CDCCCC0CC9C5584166666666F2792241CDCCCCCCC4C5584133333333F279224166666666C3C558419A999999EE792241CDCCCCCCBFC55841CDCCCCCCDF79224166666626BBC55841CDCCCCCCCC7922419A999919B7C55841CDCCCCCCBD79224133333333B4C5584166666666AF79224133333333B0C55841CDCCCCCCA8792241CDCCCC6CABC5584100000000A8792241CDCCCC8CA5C5584100000000AD792241CDCCCC8C95C558419A999999B57922419A9999798CC55841CDCCCCCCB97922416666660687C5584133333333C0792241333333B382C5584133333333C87922419A9999997FC55841CDCCCCCCDB792241333333D379C5584166666666F3792241CDCCCC0C75C558419A999999007A2241000000E072C55841CDCCCCCCF67922416666660671C5584166666666EE792241CDCCCC6C6FC5584100000000DA792241333333D36AC558419A999999C27922410000008065C5584166666666B27922419A99995962C5584166666666AC792241CDCCCCAC60C5584100000000A87922419A9999995FC55841CDCCCCCC9D792241000000405CC5584100000000987922413333337359C558416666666694792241666666E657C558419A9999998D792241CDCCCC6C55C558419A9999997F7922419A9999D951C5584133333333777922413333333350C558419A9999996A792241666666C64DC558416666666663792241333333F34BC55841CDCCCCCC5B792241333333F349C55841CDCCCCCC54792241CDCCCC0C48C55841CDCCCCCC497922410000008045C55841333333333F7922413333337343C55841CDCCCCCC367922419A9999D941C558419A9999992B792241666666E63FC558416666666620792241333333F33DC55841CDCCCCCC127922419A9999393BC5584133333333027922413333337338C5584133333333F87822413333339336C5584133333333E37822419A9999D933C5584166666666D77822416666662632C558419A999999C87822416666666630C5584100000000BB7822419A9999F92EC5584100000000AD782241CDCCCCCC2DC5584166666666A1782241CDCCCC8C2CC558410000000092782241333333D32AC558419A99999984782241CDCCCC6C28C558419A999999777822413333339326C558416666666626782241666666261BC5584166666666FC772241000000C013C55841CDCCCCCCBD772241CDCCCCEC06C558419A9999999A772241CDCCCCCC00C55841000000005F772241666666C6F8C458419A999999267722419A9999B9F1C45841000000001477224133333393EEC458419A9999990B77224133333313EDC458410000000001772241CDCCCC2CEBC45841CDCCCCCCE9762241666666C6E7C4584166666666CA7622419A999999DEC45841666666668C7622419A999959D0C45841CDCCCCCC5C762241666666C6C3C458419A99999939762241000000A0BBC458416666666622762241CDCCCC2CB5C45841666666661076224166666646AFC4584166666666817622419A9999D9ADC458419A9999996C762241000000009FC458419A999999E276224100000000A1C45841666666668C772241333333939FC458413333333395772241333333538FC4584133333333A2772241CDCCCC4C82C458419A9999991A7922410000004081C4584100000000967922416666666675C458413333333364792241CDCCCC6C61C4584100000000617922419A9999D94DC45841666666669F7922413333333345C4584100000000EE7922419A9999D939C45841666666665D7A2241000000C039C45841CDCCCCCC867A2241000000A039C458419A9999999B7A22419A9999D944C458419A999999D77A22416666660646C4584133333333427B22410000006038C4584100000000057C22419A99991920C45841666666662E7C22419A99997905C45841666666669B7C224133333393BEC3584100000000E27C2241666666A6B8C3584166666666A77D2241CDCCCCCC9EC3584100000000067E22410000000092C3584100000000A57E2241333333937EC358419A999999BD7E2241333333B37DC3584166666666107F2241333333B373C358419A9999996D7F2241CDCCCC4C68C35841CDCCCCCCD47F2241666666C65DC3584166666666548022419A9999B94DC3584100000000118122413333333335C35841CDCCCCCC688222413333339308C3584166666666EB822241CDCCCCCCF7C2584133333333208322419A999919F8C25841CDCCCCCC9E832241CDCCCCACF9C25841CDCCCCCC29842241666666E6FBC258419A9999998784224133333373FDC25841CDCCCCCCD484224133333353F7C25841666666666185224133333333F9C2584166666666E2852241CDCCCC2CFCC2584133333333728622419A99995900C3584133333333F3862241CDCCCC8C05C35841333333334487224133333333F7C258419A9999997C87224133333353ECC25841666666661487224133333353E7C258419A9999997B86224133333373E1C258419A999999F485224166666646DCC25841333333330786224166666666C0C258419A999999198622419A999939A2C258416666666628862241333333138EC258419A99999931862241333333B37EC2584133333333B4862241000000A06EC25841CDCCCCCC1C8722413333331362C258410000000088872241CDCCCC0C56C258416666666603882241333333D347C25841333333336C882241666666463BC2584166666666C4882241CDCCCC8C2CC2584133333333668822416666662625C25841CDCCCCCC36882241CDCCCC2C1FC258419A9999993D8822410000000014C258416666666630882241333333B3FFC15841CDCCCCCC17882241CDCCCC8CEEC15841CDCCCCCCFD872241CDCCCC8CE3C158419A999999DC87224166666646D1C1584166666666BE8722419A999999C3C1584166666666778722419A999999B9C15841CDCCCCCC0487224166666606B0C15841333333338C862241CDCCCC8CA5C15841666666662C862241000000209CC158419A999999ED8522419A9999B993C1584133333333BB852241CDCCCC2C89C15841CDCCCCCC588522419A99999983C158419A99999934852241CDCCCCCC72C15841000000001C852241CDCCCC8C62C158419A999999FA842241666666A650C158419A999999D4842241000000C03CC15841CDCCCCCCB7842241000000E02CC158419A999999908422419A9999B91EC15841000000007B842241000000600FC15841000000007C842241CDCCCC6C06C158419A9999998284224100000000FEC0584133333333B6842241CDCCCC4CEDC05841CDCCCCCC03852241666666E6D8C05841000000001C852241000000A0CEC05841CDCCCCCC2F85224166666686C8C05841666666665C85224100000080BDC05841CDCCCCCC7D8522419A9999F9B7C05841CDCCCCCCB9852241CDCCCC2CB2C05841CDCCCCCCCB852241CDCCCCAC91C058410000000006862241000000608BC0584166666666648622416666660681C05841333333339D862241CDCCCC6C7EC05841CDCCCCCCDE862241333333537AC058416666666604872241CDCCCC2C75C058413333333337872241000000C06DC05841333333332D872241333333B36BC0584166666666218722416666666669C05841CDCCCCCC16872241666666A667C05841333333330A872241666666E665C058419A999999FC862241666666C664C0584100000000F58622416666664664C05841CDCCCCCCEE8622413333335363C058419A999999ED862241CDCCCCCC61C058419A999999EB862241CDCCCC4C60C0584133333333E5862241CDCCCCEC5EC0584100000000E2862241CDCCCC6C5DC0584100000000E1862241666666865CC0584133333333E2862241333333535AC05841CDCCCCCCF4862241666666E652C05841CDCCCCCC0A872241333333F34EC0584100000000198722419A99999947C05841333333332D8722419A9999F93DC05841CDCCCCCC0C872241333333D32FC0584166666666EE8622419A9999191FC05841CDCCCCCCBD8622419A99997914C0584100000000F98622419A9999D910C05841666666665A872241000000600CC058419A999999D68722413333331305C0584100000000238822410000004000C05841CDCCCCCC7588224133333353FBBF58419A999999AD8822419A9999F9F5BF584166666666D88822419A9999D9EEBF58419A999999FC8822419A9999D9E6BF584100000000118922419A999979DFBF5841666666662F8922419A999959D7BF58416666666640892241666666A6CFBF58419A9999994B89224133333393CABF584100000000548922419A999999C5BF5841CDCCCCCC4F892241000000A0C2BF5841CDCCCCCC4B89224166666626C1BF5841000000004789224100000080C0BF58416666666641892241CDCCCC4CC0BF58419A9999993389224166666666C0BF58410000000026892241CDCCCC2CC1BF5841CDCCCCCC138922419A999979C2BF58413333333303892241000000A0C3BF58419A999999FA8822419A9999D9C3BF584166666666F3882241000000E0C3BF584100000000E788224166666666C3BF58419A999999DC882241CDCCCC8CC2BF584133333333D48822419A999999C1BF584100000000CE88224133333393C0BF5841CDCCCCCCC7882241CDCCCC2CBFBF58419A999999B9882241CDCCCC6CBABF5841333333339688224133333313B4BF5841333333337088224166666606ADBF5841CDCCCCCC38882241CDCCCC8C7FBF58419A9999990C882241666666667BBF58419A999999BF8722410000000078BF5841CDCCCCCC588722416666664674BF58419A9999991F872241333333B372BF584133333333F78622413333333373BF58416666666683872241CDCCCC8C7CBF5841CDCCCCCC44872241666666068BBF5841666666662F872241333333F39ABF5841CDCCCCCC1687224166666646A5BF58419A999999008722419A999939ADBF58419A999999E58622419A999959B4BF5841CDCCCCCC9E862241CDCCCCECB4BF5841000000005386224100000000B8BF5841CDCCCCCC2186224100000080B9BF584133333333FF85224100000020BEBF58419A999999C485224166666666C3BF584133333333B6852241666666E6C3BF5841000000007585224133333313C4BF5841666666665785224100000020C4BF5841666666662985224100000060C4BF58413333333315852241CDCCCCCCC4BF584100000000FD8422419A999979C6BF584100000000AF842241333333F3CFBF5841333333339084224100000040D5BF5841333333338C84224133333313D7BF5841CDCCCCCC8F84224166666646DBBF58419A9999998D842241CDCCCC4CE1BF58416666666681842241000000E0E4BF58416666666666842241000000A0E8BF5841666666664A84224100000060EABF58413333333332842241666666C6EBBF584133333333298422419A999919ECBF5841000000001D8422419A999919ECBF584100000000FE83224166666686EABF584166666666AB832241333333B3E6BF5841CDCCCCCC9583224166666686E6BF5841333333338983224166666606E7BF58410000000081832241CDCCCCCCE7BF58419A9999997D832241CDCCCC8CE8BF5841666666667A832241333333B3E9BF584133333333218322419A999959E4BF584100000000F782224133333353E7BF5841CDCCCCCCD2822241333333D3EABF584166666666B4822241CDCCCC2CF0BF58419A9999998E82224133333313F6BF58410000000070822241CDCCCC6CFDBF5841CDCCCCCC5F82224133333353FDBF58413333333354822241666666A6FCBF58419A999999438222419A999999FBBF5841000000002D82224166666686FABF58416666666622822241CDCCCCACF9BF58419A9999990082224100000080F8BF584100000000DB81224133333313F6BF584100000000CA8122419A9999B9F5BF584166666666A48122419A999979F4BF5841CDCCCCCC888122419A999979F4BF5841666666668081224100000040F4BF5841CDCCCCCC798122419A999979F3BF5841CDCCCCCC7281224166666686F2BF5841CDCCCCCC678122419A999939F1BF5841CDCCCCCC5C8122419A9999F9F0BF58416666666656812241CDCCCCCCF0BF5841666666665381224166666666F0BF5841CDCCCCCC4881224133333373EFBF5841666666664681224133333353EFBF584100000000408122419A999979EFBF5841CDCCCCCC3A81224133333313F0BF58416666666636812241CDCCCC2CF0BF58413333333332812241666666E6EFBF5841666666662D812241CDCCCC2CEFBF58410000000029812241000000E0EEBF584133333333258122419A9999D9EEBF5841000000001C812241333333F3EEBF58410000000006812241666666A6EFBF58419A999999E780224100000020F1BF5841CDCCCCCCD5802241666666C6F1BF584100000000C7802241CDCCCCCCF1BF584133333333BC80224133333353F1BF584133333333B5802241666666A6F0BF584166666666AD802241000000A0EFBF584100000000A680224133333313EFBF5841333333339E80224166666686EEBF58419A9999999680224100000060EEBF58416666666684802241000000A0EEBF5841CDCCCCCC67802241666666A6EFBF584133333333568022419A999939F0BF58419A9999994E80224166666666F0BF5841CDCCCCCC4480224166666686F0BF5841333333333D80224100000040F0BF58410000000039802241000000C0EFBF584133333333398022419A999919EFBF5841333333333C80224133333333EEBF5841333333333D80224133333353EDBF5841333333333C8022419A999999ECBF58410000000034802241CDCCCC8CEBBF5841000000002780224133333373EABF58419A99999920802241000000C0E9BF5841CDCCCCCC1B80224166666666E8BF58416666666618802241CDCCCCECE6BF5841666666661380224100000080E5BF58410000000010802241CDCCCC4CE4BF5841CDCCCCCC08802241666666C6E2BF5841CDCCCCCCFE7F2241333333F3E0BF584100000000F57F224133333333E0BF584100000000EB7F224166666606E0BF5841CDCCCCCCDD7F22419A999919E0BF584166666666D17F224100000080E0BF584100000000C97F2241666666E6E0BF584133333333BF7F2241666666E6E1BF58419A999999B87F22419A999939E3BF5841CDCCCCCCB17F2241333333D3E4BF584133333333AC7F22419A999999E5BF5841CDCCCCCCA77F224166666606E6BF5841000000009E7F224166666606E6BF584166666666927F224133333373E5BF5841333333338D7F224166666606E4BF5841666666668B7F22419A9999B9E2BF584100000000827F224166666646E1BF5841000000007A7F2241333333B3E0BF584166666666767F2241666666C6E0BF5841666666666F7F2241666666E6E0BF58419A9999996A7F224100000060E1BF584166666666667F224166666626E2BF584100000000607F224166666606E3BF5841000000005A7F2241CDCCCCECE2BF584100000000507F224133333353E2BF584166666666467F224166666626E2BF5841000000003A7F224100000020E2BF5841000000002E7F2241CDCCCC8CE2BF584166666666267F224100000060E3BF584100000000227F2241CDCCCC8CE4BF584100000000227F2241666666C6E7BF584100000000257F2241333333B3EABF5841CDCCCCCC227F224100000040EBBF5841000000001C7F224133333373EBBF584166666666127F22419A9999F9EABF584100000000067F224100000020EBBF584133333333027F2241666666C6EBBF584166666666017F224133333353ECBF584166666666027F224133333313EDBF58419A9999991A7F224100000060F0BF5841333333331F7F224133333353F2BF584166666666237F2241CDCCCCCCF6BF584100000000207F2241CDCCCCACF7BF58419A999999167F224100000000F8BF584166666666087F22419A9999D9F7BF58419A999999F87E224100000060F7BF584166666666F17E2241CDCCCC8CF7BF584100000000EF7E2241666666C6F7BF584166666666E17E2241CDCCCC6CF9BF584100000000D97E22419A999999FCBF584166666666D57E2241666666E6FEBF58419A999999D07E22413333331301C0584133333333CC7E22416666666601C058419A999999C47E22419A9999F900C05841CDCCCCCCBD7E224100000020FFBF58419A999999B67E2241666666C6FDBF5841CDCCCCCCAB7E2241333333B3FDBF584100000000647E224100000020FEBF584166666666507E22419A999979FEBF5841CDCCCCCC347E224166666606FFBF584100000000237E224133333393FFBF5841CDCCCCCC197E224166666666FFBF5841333333330F7E22419A9999F9FEBF584133333333007E22419A9999F9FEBF5841CDCCCCCCF67D224100000060FFBF584166666666F17D2241666666E6FFBF584100000000E67D22419A99995901C0584133333333D17D22419A9999F901C058419A999999C67D22413333333302C0584100000000C17D22419A9999B902C0584100000000C27D22413333339303C0584166666666C27D2241CDCCCC4C05C0584100000000BE7D22419A99991906C058419A999999B37D22413333333306C0584100000000A67D22419A9999D905C05841000000008F7D22416666668605C05841CDCCCCCC747D22413333339305C058419A999999677D22413333339305C058419A9999995F7D22419A9999B905C05841CDCCCCCC527D22410000002006C058419A999999517D2241CDCCCC8C06C0584166666666577D22410000008007C05841CDCCCCCC617D22419A9999F907C0584166666666677D22413333337308C058419A999999677D22416666664609C0584166666666637D2241000000C009C0584100000000597D22413333339309C05841666666664D7D2241CDCCCCAC08C058419A999999337D22419A9999F907C05841CDCCCCCC217D22410000000008C05841000000001A7D2241666666A607C0584133333333137D2241000000C006C0584166666666F27C22410000008000C058419A999999C27C2241CDCCCCACF7BF584166666666977C22419A9999B9EFBF584166666666587C22419A999919E6BF584166666666367C224166666646E1BF5841CDCCCCCC297C2241000000E0DEBF584133333333247C22419A999919DDBF584133333333257C224133333333DCBF584100000000227C2241666666E6D9BF5841666666661A7C2241666666E6D7BF584100000000147C2241333333D3D5BF5841CDCCCCCC137C224100000060D3BF5841CDCCCCCC177C2241000000C0D1BF584100000000187C22419A999999D0BF584166666666117C22419A999999CFBF5841666666660B7C2241CDCCCCCCCEBF584133333333057C2241333333D3CDBF584100000000077C224166666606CCBF5841CDCCCCCC0D7C2241CDCCCC4CCABF58419A999999127C224133333373C8BF58419A999999117C2241000000C0C7BF5841666666660D7C224133333353C7BF584100000000FB7B224166666646C6BF584166666666F27B22419A999959C5BF584100000000F17B22419A9999D9C3BF584133333333F27B2241CDCCCC0CC3BF5841CDCCCCCCF07B2241CDCCCCECC0BF584100000000EA7B22419A999979BFBF584100000000E27B2241CDCCCCCCBEBF58419A999999D77B224100000080BEBF5841CDCCCCCCCE7B2241CDCCCC6CBEBF584166666666BD7B22419A999939BEBF584100000000AB7B224133333313BDBF584100000000A67B224100000000BCBF584166666666A17B2241000000C0BABF5841666666669E7B22419A999939BABF58419A999999987B224133333333BABF5841CDCCCCCC927B2241CDCCCCECBABF5841333333338C7B2241333333D3BCBF584100000000857B224100000000BEBF58419A9999997B7B2241CDCCCC4CBEBF5841333333335E7B224100000000BEBF5841333333334D7B224133333333BDBF58419A999999467B224166666626BCBF5841000000003E7B224133333393B8BF5841333333333A7B2241333333D3B7BF584166666666307B224100000060B6BF584100000000217B2241CDCCCC6CB4BF58419A999999147B224100000080B1BF584133333333077B22419A999999AFBF5841CDCCCCCCEE7A22419A999939ADBF5841CDCCCCCCD87A224133333313ACBF584100000000CA7A224100000000ACBF584166666666A97A2241CDCCCC8CACBF58419A9999998E7A22419A999999ADBF58419A999999797A2241CDCCCCACADBF584133333333687A224166666646ADBF5841333333335C7A2241CDCCCC8CADBF5841333333333F7A2241000000C0AEBF5841CDCCCCCC217A224100000060AFBF58419A9999991C7A224166666646AFBF584166666666197A2241666666E6AEBF584133333333157A224100000000AEBF584133333333187A224166666646ACBF58419A999999157A2241666666A6AABF584166666666117A224166666686A9BF584166666666097A2241666666E6A8BF5841CDCCCCCCFF792241CDCCCC2CA9BF584166666666F879224100000040AABF58419A999999F279224166666666ABBF584100000000ED792241CDCCCCCCABBF584166666666E0792241000000C0ABBF58419A999999D2792241CDCCCC0CABBF58419A999999C379224166666686AABF584133333333B679224133333373AABF584133333333A6792241CDCCCCECAABF5841000000008C7922419A9999F9ABBF58419A9999997E79224133333333ACBF5841CDCCCCCC6C792241CDCCCC0CACBF5841CDCCCCCC637922419A9999B9AABF5841000000005E7922419A999959A9BF5841666666665F792241666666A6A7BF5841333333335379224166666686A6BF5841CDCCCCCC477922419A9999B9A6BF5841CDCCCCCC4079224166666646A6BF5841CDCCCCCC36792241CDCCCC4CA5BF5841000000002879224133333353A4BF58419A99999913792241CDCCCCACA3BF58419A999999F67822419A9999B9A3BF584166666666D978224133333353A4BF584100000000C5782241CDCCCC6CA5BF584166666666B7782241CDCCCC8CA7BF584166666666AD78224166666666ABBF5841333333339E78224166666606AFBF5841CDCCCCCC847822419A9999F9B0BF584133333333727822419A999979B1BF584133333333587822419A999999B1BF584133333333417822419A999979B2BF5841333333332978224133333333B4BF58413333333317782241CDCCCCACB6BF584133333333037822419A9999B9B9BF584166666666ED77224133333393BABF584166666666D6772241CDCCCCCCBABF584100000000C377224133333373BABF5841CDCCCCCCB877224100000020BABF584133333333A4772241666666A6B8BF5841000000008E7722419A999939B7BF5841666666666F772241333333B3B4BF5841CDCCCCCC5C772241333333D3B3BF584100000000417722419A999919B2BF5841666666662677224133333333B1BF58416666666603772241333333B3B0BF58419A999999C476224133333313B1BF5841CDCCCCCC9676224133333313B1BF5841CDCCCCCC7B762241000000E0B0BF58419A99999947762241CDCCCCACB0BF5841000000002B762241CDCCCCACB0BF58413333333312762241666666C6AFBF58419A99999900762241CDCCCC6CAEBF584100000000EA75224133333353ACBF584133333333CC752241000000A0A8BF584100000000AF7522419A9999F9A4BF5841666666669775224166666626A1BF58416666666684752241333333B39EBF5841333333336F7522419A9999D99CBF5841333333334C752241CDCCCC6C9ABF5841333333331B752241666666A698BF584100000000F27422419A99993998BF584100000000C5742241666666E698BF584133333333B5742241333333139ABF58419A999999AC742241333333139DBF584100000000AA742241333333F3A0BF584133333333A67422419A9999B9A6BF58419A99999998742241CDCCCCACAEBF58419A9999997D742241666666E6B4BF5841666666667374224100000040B7BF58419A9999996A7422419A9999F9B9BF5841333333335C7422419A999939BDBF5841CDCCCCCC5174224133333353BFBF584100000000437422419A999959C1BF58416666666631742241CDCCCC0CC3BF5841666666661574224133333353C4BF584100000000FC7322419A999979C5BF584133333333EE732241CDCCCCECC6BF584100000000E473224133333353C9BF5841CDCCCCCCDB732241CDCCCC2CCCBF58419A999999CE732241000000C0CDBF5841CDCCCCCCB473224133333393CEBF5841666666668E732241666666A6CEBF5841CDCCCCCC69732241CDCCCCCCCEBF58419A9999994E7322419A9999B9CEBF58419A9999994973224100000060CEBF58416666666642732241000000E0CDBF58419A9999993873224133333373CCBF584133333333357322419A999919CBBF584166666666317322419A999919C9BF58419A9999992873224166666646C6BF58413333333313732241CDCCCC0CC4BF584133333333FC72224166666626C2BF584100000000E372224100000080C0BF584166666666CD7222419A999999BFBF584133333333BD72224133333393BEBF584166666666AC7222419A999979BCBF5841CDCCCCCC9F722241CDCCCC0CBABF5841666666669872224133333353B8BF5841333333338F72224133333353B6BF5841333333338F722241CDCCCC2CB5BF5841333333339072224133333393B3BF5841333333339672224100000020B2BF584166666666A0722241CDCCCCECB0BF584133333333AA722241666666C6AFBF584100000000B272224133333313AEBF58419A999999B3722241CDCCCC0CACBF584100000000B1722241000000C0A9BF584100000000A5722241CDCCCC8CA7BF58419A99999998722241CDCCCC0CA6BF5841CDCCCCCC8A722241666666A6A4BF5841CDCCCCCC727222419A999959A3BF5841000000005A722241000000C0A3BF58413333333343722241CDCCCCECA4BF5841CDCCCCCC3372224100000080A5BF58419A999999217222419A999959A5BF58410000000008722241333333D3A4BF58419A999999E77122419A9999D9A3BF584100000000CF71224100000080A3BF584100000000BA7122419A999919A3BF584133333333A9712241666666E6A2BF5841333333339971224133333333A3BF5841CDCCCCCC8C71224133333333A4BF584100000000857122419A9999B9A4BF5841000000007D7122419A9999F9A4BF5841333333337871224133333393A4BF584166666666797122419A999999A3BF58419A999999747122419A9999F9A2BF5841333333335D712241666666A6A2BF584100000000487122419A9999D9A2BF5841CDCCCCCC3671224133333353A3BF5841000000002D712241000000A0A3BF5841000000002771224166666686A3BF5841CDCCCCCC207122419A9999D9A2BF5841666666661971224133333393A1BF58413333333310712241666666C6A0BF58419A99999908712241CDCCCC8CA0BF58419A9999990171224100000000A0BF584133333333F5702241666666269FBF5841CDCCCCCCE6702241000000009EBF5841CDCCCCCCDE702241CDCCCC8C9CBF584166666666D4702241333333539BBF584100000000CC702241666666469ABF5841CDCCCCCCC6702241CDCCCC2C99BF584166666666BB702241333333D397BF58419A999999AF7022410000002097BF5841CDCCCCCCA57022410000000097BF5841CDCCCCCCA2702241CDCCCC6C97BF58416666666696702241CDCCCC2C98BF58410000000089702241000000A097BF5841666666667C7022410000004097BF5841CDCCCCCC76702241666666A696BF584133333333727022416666662695BF58410000000069702241CDCCCC4C94BF584166666666587022410000008092BF5841666666664C7022419A9999B991BF584166666666477022419A9999F990BF5841CDCCCCCC49702241333333738FBF5841CDCCCCCC49702241000000C08DBF5841CDCCCCCC46702241CDCCCC8C8CBF5841333333333D702241CDCCCC8C8BBF5841CDCCCCCC2F7022419A9999998ABF58419A99999925702241CDCCCCEC88BF58419A99999919702241CDCCCCCC87BF5841CDCCCCCC097022419A9999B986BF58419A999999FD6F2241CDCCCCCC85BF584100000000F76F22416666668685BF584133333333ED6F22416666668686BF5841CDCCCCCCE66F2241666666E686BF584100000000DE6F22410000004086BF5841CDCCCCCCD06F2241666666E685BF58419A999999C86F22419A99997986BF584100000000C26F22413333339387BF58419A999999B66F22416666668687BF584100000000B36F2241666666E688BF584100000000A36F22419A9999398ABF584133333333926F22419A9999798BBF5841CDCCCCCC896F2241333333D38CBF58419A999999876F2241000000408EBF58419A999999866F2241CDCCCC2C90BF5841CDCCCCCC856F22419A9999B990BF584133333333816F22410000006091BF5841666666667C6F22413333335391BF584133333333766F22413333337390BF5841CDCCCCCC6E6F2241333333B390BF584166666666666F22410000000092BF58419A999999576F2241000000E092BF5841333333334B6F22413333339392BF5841CDCCCCCC3C6F22410000008092BF5841CDCCCCCC2E6F22410000006092BF58419A9999991D6F2241CDCCCC4C92BF584100000000116F22419A99995992BF584166666666036F2241CDCCCC8C92BF584166666666F66E2241666666C693BF584133333333EB6E2241CDCCCC6C95BF584100000000DD6E22410000000097BF58419A999999C76E2241CDCCCC4C97BF58419A999999B56E22416666662698BF584100000000AE6E22419A9999D998BF5841CDCCCCCCA46E22419A9999B999BF5841CDCCCCCC996E2241CDCCCC2C9CBF584133333333906E2241CDCCCC8C9EBF5841CDCCCCCC8A6E224100000000A1BF5841000000008B6E2241CDCCCCECA3BF584166666666926E224100000020A8BF58419A999999916E22419A9999F9A9BF5841000000008D6E22419A999979ACBF5841CDCCCCCC886E224100000020AEBF584166666666856E22419A999919B0BF5841000000007A6E224133333373B2BF5841CDCCCCCC6B6E2241333333B3B4BF58419A9999995B6E2241CDCCCCACB6BF5841CDCCCCCC3F6E22419A999959B9BF584100000000086E2241CDCCCCCCBBBF584133333333E46D224133333353BDBF584133333333C36D224133333373BFBF584100000000B36D224133333313C2BF584166666666AC6D224100000000C5BF584133333333A76D22419A9999D9C7BF5841CDCCCCCCA16D22419A999999CABF584100000000946D22419A999999CDBF58419A999999846D224100000060D0BF584133333333726D224166666686D3BF584133333333606D2241000000A0D6BF5841CDCCCCCC536D224133333353D8BF58419A9999994A6D22419A999939D9BF584166666666426D224166666686D9BF584100000000346D22419A999999D9BF5841000000001F6D224166666686D9BF5841000000000C6D2241CDCCCCCCD8BF584100000000F86C224133333353D8BF58419A999999E66C224133333313D8BF584166666666D66C224100000000D9BF584166666666CA6C22419A999999DABF584100000000B96C22419A999979DDBF5841CDCCCCCC9D6C22419A9999F9DFBF584133333333796C2241CDCCCC6CE1BF584100000000546C2241CDCCCC2CE2BF584166666666326C2241333333D3E1BF584166666666176C224100000080E0BF58419A999999F56B2241CDCCCC4CE0BF58419A999999CD6B2241CDCCCC0CE0BF584166666666A76B2241CDCCCC2CDFBF5841CDCCCCCC756B224133333313DEBF5841666666664E6B22419A9999D9DDBF584133333333256B224166666646DEBF584100000000036B2241000000C0DEBF584133333333D66A224133333393DFBF584100000000A66A2241CDCCCCACE0BF584166666666816A2241CDCCCCCCE1BF58419A999999676A224166666606E3BF58419A999999496A224100000040E5BF58419A999999216A224100000020E8BF584100000000056A224100000040EBBF58419A999999EF692241333333D3EEBF584166666666DE692241666666E6F2BF584100000000D669224166666646F8BF584133333333D7692241333333F3FBBF5841CDCCCCCCDB692241CDCCCC4CFEBF58419A999999DE692241333333F301C05841CDCCCCCCDD6922410000002004C0584100000000DA692241CDCCCC4C06C0584100000000D36922419A9999B907C058419A999999C66922419A99995908C0584166666666BC6922419A9999B908C05841CDCCCCCCB0692241333333330AC0584100000000AB692241000000A00BC0584133333333AB692241000000000EC0584166666666A9692241000000A010C05841CDCCCCCCA5692241333333B312C05841666666669F6922413333331316C0584133333333966922413333335319C05841000000008B692241000000401DC058413333333381692241CDCCCCAC20C058416666666671692241333333D324C05841CDCCCCCC676922410000008027C05841666666665C6922419A9999192AC058419A999999546922419A9999992BC058419A9999994B692241CDCCCC4C2CC05841000000003C692241CDCCCC4C2CC058413333333335692241333333D32BC05841CDCCCCCC29692241CDCCCC0C2BC058413333333317692241666666862AC058416666666605692241666666A62AC058419A999999ED682241333333532BC0584133333333D6682241CDCCCC4C2CC0584100000000C7682241CDCCCC8C2CC0584166666666B76822419A9999F92BC05841CDCCCCCCAA682241666666E62AC05841000000009E682241666666A629C05841CDCCCCCC896822413333331328C05841CDCCCCCC72682241CDCCCC6C27C05841666666665A6822410000006027C058419A9999993F682241666666C627C0584100000000256822419A9999B928C05841CDCCCCCC0B682241CDCCCC4C2AC0584166666666EA672241666666E62CC0584133333333C06722419A9999F92FC0584133333333A66722410000006031C058413333333397672241666666A632C058419A9999998F672241666666E633C058413333333386672241CDCCCCAC35C05841000000007C6722419A99997936C05841333333336F672241666666A636C05841CDCCCCCC59672241666666E636C0584133333333456722416666666637C0584100000000386722410000000038C0584133333333276722419A99991939C058413333333317672241333333D33AC05841CDCCCCCC0C6722419A9999993CC0584133333333066722419A9999593EC0584100000000026722419A9999993FC0584166666666FD6622416666660641C0584100000000FA6622419A99993942C058419A999999F56622410000006043C0584133333333F06622413333337344C05841CDCCCCCCE86622413333337345C058419A999999E3662241000000E045C0584166666666DE662241CDCCCCEC46C058419A999999D8662241000000C048C0584166666666D3662241333333534AC058419A999999D0662241000000C04BC05841CDCCCCCCCC6622419A9999F94CC0584100000000C8662241666666C64DC0584100000000C5662241CDCCCC6C4EC05841CDCCCCCCC1662241CDCCCC6C4FC05841CDCCCCCCBB662241CDCCCC6C50C0584100000000B6662241CDCCCC4C51C0584100000000B16622416666662652C05841CDCCCCCCAB6622413333333353C058419A999999A7662241CDCCCC6C54C05841CDCCCCCCA66622413333339355C05841CDCCCCCCA76622410000002057C05841CDCCCCCCA6662241CDCCCC4C59C0584100000000A3662241000000C05AC058419A9999999E6622419A9999195CC058419A999999916622419A9999795EC058419A99999981662241CDCCCCAC60C05841000000006F662241000000C062C0584100000000706622410000002066C058413333333358662241666666C669C05841000000003D662241CDCCCC8C6BC05841333333332C662241000000C06DC05841CDCCCCCC1D662241CDCCCC0C6DC058416666666610662241CDCCCC8C6AC058419A999999076622419A99995967C05841CDCCCCCCE1652241666666A666C05841CDCCCCCCD0652241CDCCCC2C67C0584133333333A86522410000000066C0584100000000966522413333337365C05841333333338B6522419A99991965C05841333333337E652241CDCCCCAC64C0584166666666756522413333335364C05841000000006D6522419A99993964C05841CDCCCCCC65652241CDCCCC4C64C058419A99999958652241000000C064C05841666666664B6522416666660665C05841333333333E6522416666660665C058416666666633652241666666C664C058416666666619652241666666E663C058416666666606652241CDCCCC6C63C0584100000000F06422419A99991963C0584166666666DA6422419A99991963C0584166666666C46422419A99991963C05841CDCCCCCCAA642241CDCCCC8C63C0584100000000926422419A9999B964C0584166666666806422419A99995966C05841CDCCCCCC626422419A99991969C058413333333348642241333333336BC05841000000002D642241000000006DC05841000000000D642241CDCCCCCC6EC0584100000000E46322410000004071C058419A999999C6632241CDCCCCAC72C0584133333333B16322410000000074C0584166666666A46322410000004075C05841CDCCCCCC97632241CDCCCCCC75C05841333333338A632241CDCCCC0C76C05841CDCCCCCC6E632241333333F375C05841333333334C632241000000C075C0584100000000256322413333335375C058419A99999904632241666666C674C0584166666666E46222419A9999B973C058419A999999BD6222410000008072C0584166666666A76222416666668671C058419A9999998B622241CDCCCCEC6FC05841666666667B622241333333136FC058410000000064622241CDCCCC4C6EC058419A99999944622241333333D36DC05841666666662A6222419A9999B96DC058416666666609622241333333B36DC05841CDCCCCCCF3612241666666A66DC05841CDCCCCCCE1612241333333736DC05841CDCCCCCCD3612241666666E66CC0584133333333CE612241333333336CC058416666666681612241333333B364C058416666666631612241CDCCCC4C5FC05841CDCCCCCC8A6022419A9999D95FC05841CDCCCCCCCA5F2241CDCCCC4C62C05841CDCCCCCCBD5F22419A99995962C058419A999999B05F2241CDCCCCAC62C0584133333333AC5F22419A99995963C0584100000000AC5F22413333335364C05841CDCCCCCCAE5F22416666668665C0584100000000B15F22419A9999F966C0584100000000B05F22419A9999D967C058419A999999AC5F22419A9999B968C0584166666666A55F2241333333D369C058419A9999999E5F2241000000206AC05841CDCCCCCC935F22419A9999396AC05841333333338B5F22419A9999796AC0584100000000855F2241000000606BC058419A999999855F2241CDCCCC6C6CC05841333333338B5F2241333333536DC0584166666666925F2241666666C66DC0584100000000975F2241CDCCCC6C6EC05841CDCCCCCC955F2241333333136FC05841CDCCCCCC8E5F2241333333336FC05841CDCCCCCC7D5F22419A9999F96EC0584100000000695F22419A9999B96EC05841CDCCCCCC5A5F2241000000C06EC0584100000000545F22419A9999396FC05841000000004E5F22419A99991970C05841CDCCCCCC4A5F22410000004071C058419A999999485F2241333333F372C0584133333333445F22419A9999D973C05841000000003C5F22413333339374C05841CDCCCCCC2F5F22416666660675C0584133333333225F22410000000075C0584133333333115F2241CDCCCC8C74C05841CDCCCCCC045F2241333333F373C0584133333333FB5E22416666666673C05841CDCCCCCCED5E2241333333F372C0584166666666E15E2241333333F372C0584133333333D65E22419A99993973C058419A999999D05E2241666666E673C0584100000000CE5E22419A9999B974C05841CDCCCCCCC85E2241333333D375C05841CDCCCCCCC05E2241CDCCCCAC76C05841CDCCCCCCB65E22413333335377C0584166666666A75E22413333339377C0584166666666905E2241CDCCCC6C77C0584133333333795E2241333333B376C05841CDCCCCCC685E22410000004076C05841CDCCCCCC585E22413333339375C05841CDCCCCCC475E22410000004075C05841CDCCCCCC3F5E22410000008075C05841000000003A5E22419A99995976C0584166666666355E2241CDCCCC6C77C05841666666662D5E22419A9999D978C0584133333333205E2241333333937AC058419A999999115E2241000000807BC05841CDCCCCCCFB5D2241333333537CC0584166666666EE5D2241000000C07CC058419A999999E35D2241000000607DC0584166666666DB5D2241666666467EC0584100000000D45D2241000000607FC05841CDCCCCCCCA5D2241000000E080C0584166666666C25D2241CDCCCC4C81C0584100000000BD5D2241000000E081C0584133333333975D22419A9999B985C05841666666668A5D2241CDCCCC0C86C058419A999999825D22416666660686C0584166666666795D2241CDCCCCEC85C0584100000000715D2241333333D385C0584133333333645D2241CDCCCCCC85C0584166666666585D2241333333F385C0584100000000535D22416666668686C058419A999999515D22416666662687C0584133333333515D22419A99991988C058419A9999994E5D2241666666C688C05841CDCCCCCC485D22419A9999198BC0584133333333395D2241333333B38DC05841333333332A5D2241666666468FC05841000000001A5D22419A9999B990C058419A999999005D22416666660692C0584166666666E85C22419A99995992C058419A999999CE5C2241666666C691C0584100000000BC5C22413333335391C0584100000000A55C2241CDCCCC6C91C05841CDCCCCCC915C2241CDCCCC0C92C05841CDCCCCCC845C2241333333D392C05841CDCCCCCC6F5C2241000000A093C0584100000000585C22419A9999F993C05841CDCCCCCC425C22410000008094C05841666666662D5C22419A99991995C058419A999999245C2241CDCCCCCC94C05841CDCCCCCC1F5C2241333333F393C058419A9999991A5C22410000002093C0584166666666135C2241CDCCCC4C92C0584166666666045C22413333339391C05841CDCCCCCCF95B2241000000C091C0584166666666F35B2241333333D392C05841CDCCCCCCEA5B22413333335394C058419A999999DE5B2241666666E694C05841CDCCCCCCCC5B2241CDCCCC8C94C0584166666666AF5B22416666660692C0584100000000935B2241333333338FC0584133333333805B2241666666668DC05841000000006E5B2241000000A08CC058419A999999595B2241333333538CC058419A9999993E5B2241666666C68CC05841333333331D5B2241CDCCCCCC8DC05841CDCCCCCCEF5A2241000000208FC0584100000000B75A2241CDCCCC6C91C05841333333338C5A22419A99997993C0584166666666725A2241666666E695C058419A999999635A2241666666E697C05841333333335D5A22419A9999199AC058419A999999585A2241CDCCCC6C9CC0584133333333505A2241CDCCCCAC9FC05841CDCCCCCC455A224133333313A2C05841333333333A5A224133333313A4C058419A999999265A224166666646A6C05841CDCCCCCC0A5A2241CDCCCC2CA8C0584166666666F059224166666666A9C058419A999999DF5922419A9999B9AAC05841CDCCCCCCD359224166666626ACC0584133333333C459224133333353AEC058419A999999B65922419A999939AFC0584166666666A9592241666666A6AFC05841000000009C5922419A9999D9B0C058419A9999999259224166666666B2C05841333333338B592241000000A0B4C0584133333333815922419A9999D9B7C05841CDCCCCCC73592241CDCCCCACBAC058419A9999996559224100000080BCC0584166666666515922419A999979BDC05841CDCCCCCC42592241000000E0BDC05841000000003A592241000000C0BEC0584166666666305922419A9999B9C0C058419A999999265922419A999959C3C0584166666666205922419A999919C5C05841333333331759224166666626C6C05841000000000D592241666666C6C6C058419A999999F558224166666626C7C0584100000000D4582241CDCCCC2CC7C0584133333333B75822419A999979C7C058419A999999A45822419A9999B9C8C05841CDCCCCCC9A58224166666666CAC05841666666669158224100000040CDC058410000000082582241CDCCCCACCFC058413333333371582241333333B3D1C05841000000005A58224100000080D3C058410000000032582241CDCCCC0CD6C058410000000016582241000000C0D7C058419A9999990258224100000080D9C0584166666666FC5722419A999939DAC0584100000000F4572241000000C0DAC0584100000000EF57224133333353DBC058419A999999E757224100000060DCC0584133333333DF5722419A9999D9DCC058419A999999D3572241CDCCCC4CDDC05841CDCCCCCCCB57224133333393DDC0584166666666C957224100000000DEC0584133333333C9572241333333D3DEC058419A999999C9572241CDCCCC8CE0C058419A999999C75722419A999999E1C0584166666666C357224166666626E2C0584100000000BC5722419A999939E2C0584166666666B157224166666686E2C0584133333333B057224100000020E3C0584133333333B3572241CDCCCC0CE4C0584166666666B557224166666646E5C0584133333333B557224166666606E7C05841CDCCCCCCB25722419A9999B9E7C0584166666666AC572241000000A0E8C0584166666666A5572241CDCCCCCCE8C05841CDCCCCCC9E5722419A999959E8C05841CDCCCCCC9557224100000040E7C05841333333338A57224166666666E6C05841000000007D572241333333F3E5C05841CDCCCCCC7357224166666626E6C05841666666666A57224166666666E6C0584133333333625722419A999959E6C05841666666665857224100000020E6C05841333333334C57224166666646E5C05841333333333B572241000000C0E3C05841666666663457224100000080E2C05841000000003257224166666686E1C05841333333332F572241CDCCCC4CE0C058416666666628572241CDCCCC4CDFC058419A999999215722419A999919DFC058419A99999916572241CDCCCC0CDFC058419A9999990957224133333373DEC05841333333330657224133333373DDC05841CDCCCCCC0357224166666666DCC05841CDCCCCCCFA56224100000040DBC0584166666666F0562241333333F3DAC0584100000000E25622419A9999D9DAC05841CDCCCCCCD45622419A999919DBC058419A999999CE56224100000080DAC0584133333333CC562241000000A0D8C0584100000000CB56224166666646D7C0584166666666C7562241CDCCCC0CD6C0584100000000C05622419A999999D5C0584166666666B5562241CDCCCC8CD5C05841333333339C5622419A9999F9D6C058419A9999998E56224133333373D6C058416666666686562241000000A0D5C05841CDCCCCCC7F562241CDCCCC8CD3C05841CDCCCCCC7C5622419A999939D2C058410000000076562241000000E0D0C058419A999999695622419A999999CFC05841333333335C562241666666A6CEC05841666666665156224133333313CEC058413333333342562241000000A0CDC0584100000000365622419A999919CDC058419A9999992C5622419A999919CCC058419A9999992356224133333353CAC05841CDCCCCCC1C56224133333333C9C05841000000001256224100000000C8C05841000000000656224100000000C7C058419A999999F75522419A999979C6C0584100000000BB552241000000C0D1C0584100000000BB55224100000000D3C05841666666667E552241333333D3D4C05841CDCCCCCC8C5522419A999959E7C05841CDCCCCCC22552241CDCCCC8CE3C0584166666666DC542241CDCCCCACEDC058416666666608552241333333B3F2C05841CDCCCCCC3A55224166666626F9C05841333333335655224133333313FCC058419A9999998A55224133333373FEC0584133333333D1552241000000A001C1584133333333345622419A99995905C158419A9999994D562241CDCCCCEC0FC15841666666666D562241CDCCCC6C14C1584133333333A8562241666666E61AC1584100000000E7562241333333F320C1584166666666F5562241666666E622C158413333333308572241CDCCCCAC26C15841CDCCCCCC18572241CDCCCC0C2BC15841CDCCCCCC265722419A9999792FC15841CDCCCCCC385722419A99993936C158419A99999945572241666666A63CC15841CDCCCCCC505722410000000043C158416666666657572241666666A647C158419A9999995E572241666666464CC15841000000006A572241CDCCCC6C54C1584166666666795722419A9999F95AC158419A9999998A572241CDCCCC8C60C158419A999999A2572241000000C065C1584166666666C2572241666666A66AC1584100000000E6572241000000C06FC15841CDCCCCCC0D5822413333331375C15841000000002F582241000000607AC15841666666664A5822410000004080C158413333333361582241000000A087C1584166666666795822413333339391C158419A9999998A5822413333333399C15841CDCCCCCC9D58224133333353A1C158419A999999AC58224133333353A7C1584100000000C2582241333333F3ACC15841CDCCCCCCD4582241000000A0B0C1584166666666EA582241CDCCCC4CB4C1584133333333FD5822419A9999F9B7C15841666666660459224166666686BAC15841000000005558224133333313CCC15841666666661758224133333333D5C15841CDCCCCCC74582241CDCCCC2CFFC1584166666666695822416666660600C2584100000000F0572241CDCCCCCC06C2584166666666C4572241CDCCCCAC02C25841333333339F572241CDCCCC6CFFC158419A9999997C57224133333353FCC15841CDCCCCCC5F57224100000080F9C15841000000006957224133333353F4C158419A9999995057224166666606E4C158410000000048572241333333D3DCC158419A99999912572241333333B3D6C158419A99999927562241CDCCCC8CC9C158419A999999AD552241000000E0C9C1584166666666AF5422419A9999F9CBC158419A999999665422419A999979D4C15841000000003554224166666666D4C1584133333333D153224166666646D4C1584100000000865322419A999939D4C158410000000059532241CDCCCCACD4C15841666666664153224166666686D5C158419A99999921532241000000E0D7C1584166666666875222419A999999D5C15841CDCCCCCC18522241CDCCCC2CD7C158410000000012522241333333B3D4C15841CDCCCCCC1451224133333373DEC158419A99999960502241333333B3E4C1584133333333F14F2241333333D3E7C15841000000009A4F2241000000A0F7C15841CDCCCCCC164F2241666666E6F7C158419A999999764E224166666626F4C158419A999999EB4D22419A9999D9ECC15841CDCCCCCC7D4D2241333333F3ECC158419A999999474D224100000080ECC158419A999999F04C22419A999939EDC1584133333333584C224133333353E3C15841000000000A4C2241333333D3DFC1584133333333F54B2241333333B3DFC1584166666666984B224133333313D5C158419A999999834B224133333373D4C1584133333333284B2241CDCCCC0CBCC1584133333333FD4A22419A999939B7C15841CDCCCCCCBB4A224133333353B0C1584166666666934A2241666666C6ADC1584166666666194A224133333353B0C15841000000009C4922419A999919B8C15841333333334549224100000020B8C15841	01060000206A080000010000000103000000010000004A020000333333334549224100000020B8C15841333333335749224100000080BCC15841333333338549224133333393D0C15841000000009749224166666686E0C1584166666666914922419A9999D9E7C15841666666666F492241333333B3F4C15841333333337A4922410000000001C2584100000000B94922419A9999590EC2584133333333174A2241000000401BC25841000000007D4A2241000000A025C25841666666660E4B2241666666462EC2584100000000764B2241CDCCCC8C31C2584166666666014C22416666662637C2584166666666474C2241666666A638C2584166666666AE4C22419A99991938C2584133333333FC4C2241CDCCCCAC3DC25841CDCCCCCC754D2241CDCCCC6C49C258419A999999CA4D2241000000C052C2584133333333F54D22413333335359C25841CDCCCCCC504E22419A9999196AC25841CDCCCCCCAE4E22419A9999197DC2584133333333DE4E2241CDCCCC0C85C25841CDCCCCCC6A4F22416666662699C258419A999999A94F22419A999959A4C25841CDCCCCCC1350224100000060C1C258419A9999995F502241000000A0D2C2584100000000B05022419A999919DFC2584133333333F4502241666666A6E7C25841333333335B522241666666860DC358419A999999B9522241CDCCCCAC19C35841000000002D532241CDCCCC0C24C3584133333333A35322416666662629C35841000000001C542241CDCCCCCC2BC358416666666602552241333333332EC35841CDCCCCCC35552241333333F332C35841CDCCCCCC3F552241000000C038C3584133333333295522416666664641C35841CDCCCCCCE35422413333333349C35841333333332D542241CDCCCC4C56C358419A99999949532241CDCCCC8C63C3584133333333215322413333335367C3584133333333FB522241CDCCCC0C70C3584133333333D9522241666666A683C358419A999999CC5222416666666695C3584100000000D95222419A9999D99DC35841333333330F532241CDCCCCCCB0C358419A9999992453224100000040B5C35841333333336F532241CDCCCC0CC0C3584100000000CC532241000000C0C6C358419A9999994F54224100000020CAC35841CDCCCCCCAD542241CDCCCC4CCAC35841CDCCCCCC7455224166666646C8C3584166666666DE552241CDCCCCACC4C35841000000001A56224166666666C1C35841CDCCCCCC78562241CDCCCC6CBFC3584133333333FA5622419A999959C4C358419A99999960572241CDCCCC4CC7C3584133333333F357224166666666CAC358419A9999994F58224166666646CEC3584133333333A05822419A999999D6C3584100000000AB58224166666606D9C358419A999999D25822419A9999B9ECC3584133333333FD58224133333313F1C358419A9999992D592241CDCCCC8CFFC35841666666664F5922410000004003C45841333333336B592241CDCCCCAC10C45841CDCCCCCC9F592241CDCCCC8C20C4584100000000A7592241CDCCCC4C27C45841666666668C5922410000004030C458416666666667592241CDCCCC8C33C45841000000000D592241000000A038C458419A999999955822419A9999993CC4584166666666485822419A99995941C4584100000000F6572241000000804FC458413333333340572241666666866AC45841000000001B572241666666066EC45841333333333A562241333333B377C4584100000000E8552241CDCCCC6C80C45841CDCCCCCCC25522416666666687C4584166666666A3552241666666A693C4584100000000A5552241000000E09DC45841CDCCCCCCC855224133333333A8C45841000000000156224133333353AEC45841CDCCCCCC95562241CDCCCC0CB7C4584133333333D8562241CDCCCCACB8C4584133333333545722419A9999D9B3C4584133333333665822419A999919ACC45841666666669F58224166666606A9C45841CDCCCCCCF0582241333333B3A1C45841333333335B592241666666268EC458419A99999998592241000000807FC45841CDCCCCCCFE5922419A99997973C45841CDCCCCCC345A22419A99999971C458419A999999F15A2241000000E06EC4584133333333435B2241333333D36CC458419A9999997E5B2241333333D369C4584133333333A65B2241333333F365C45841CDCCCCCCF65B2241666666665AC45841666666663A5C2241CDCCCC2C57C45841CDCCCCCCA55C2241666666A656C4584133333333DB5C2241333333D358C458419A9999994B5D2241CDCCCC8C62C45841000000007F5D22410000008062C4584133333333C65D22419A9999795FC4584133333333AE5E22419A99999959C4584100000000005F2241333333B359C458419A999999645F2241000000405BC45841CDCCCCCCE05F22419A99999961C4584166666666026022419A99993966C4584100000000746022419A99997982C4584166666666C16022410000006094C458419A9999993961224166666686AEC45841333333335B61224133333353BBC45841666666669661224100000000C6C4584100000000F661224133333333E0C458416666666638622241CDCCCC4CEDC45841333333337C622241333333F3F5C4584166666666CD62224166666606FBC458410000000047632241CDCCCCECFDC45841CDCCCCCC8463224100000080FDC45841333333330C642241333333D3F5C4584133333333546422419A999919F5C45841333333338064224166666666F8C458413333333396642241CDCCCC8CFDC458419A999999A46422413333333306C5584100000000076522419A9999B918C558419A9999991E652241CDCCCC0C23C5584166666666356522413333333337C5584166666666326522410000002048C55841333333333D652241333333F34EC558413333333360652241666666A658C5584133333333166622410000008080C55841CDCCCCCC456622416666668685C5584133333333A16622416666662685C5584166666666D5662241333333537EC55841CDCCCCCCF8662241333333336DC558416666666658672241000000405DC5584166666666B7672241666666864FC5584166666666F2672241CDCCCC8C49C5584133333333646822413333339343C55841333333335A6922413333337340C5584100000000936A2241333333F33EC5584133333333D16A22419A9999593FC5584133333333646B2241666666A643C55841CDCCCCCCAA6B22410000000043C5584100000000F76B2241CDCCCC8C44C5584166666666636C22419A9999F94BC5584100000000C36C2241666666E654C558419A999999026D2241000000A05CC5584100000000476D22419A99999966C5584100000000DC6D2241333333D380C5584166666666086E22419A9999998AC55841000000002C6E22410000004095C5584166666666526E2241CDCCCC0CA5C55841333333337E6E2241CDCCCCCCAAC5584100000000C76E22419A9999D9ABC5584166666666136F22419A999999AFC5584100000000746F2241CDCCCCCCAEC5584166666666B16F2241CDCCCC6CAFC558419A999999F56F2241CDCCCC2CB6C55841CDCCCCCC617022419A999919CBC55841666666669070224100000040CFC5584166666666DF70224166666606D3C55841333333331F712241CDCCCCECD2C5584133333333E371224166666606CFC558419A99999926722241CDCCCCECD2C558416666666632722241CDCCCC4CD9C558419A9999992272224100000020E2C55841CDCCCCCC05722241000000C0E9C55841333333330872224100000000F2C55841666666663272224100000080F8C5584133333333EE722241333333F302C6584166666666FA722241CDCCCCCC04C658410000000009732241333333730FC6584166666666527322413333335317C65841666666668E7322413333335315C65841CDCCCCCCEC732241000000C007C65841333333330C7422419A99999904C658419A9999999274224133333353FDC558419A999999DE742241333333D3ECC55841666666660375224166666606E7C558410000000048752241666666A6E1C55841333333338B752241666666E6E2C55841CDCCCCCCE07522419A999959EBC55841666666662876224100000060F6C55841333333337976224166666626FAC55841666666669E762241000000A0F6C5584100000000DB76224166666646E3C558413333333309772241CDCCCCECD7C55841000000003377224166666626D1C55841333333335677224166666626CEC558410000000097772241CDCCCCCCCCC5584133333333BD772241CDCCCC6CCEC55841333333331178224166666626DAC55841000000007278224133333333DFC5584166666666DF782241CDCCCCECEAC5584100000000FF78224133333353EFC55841333333331D792241333333D3EFC55841CDCCCCCC5279224133333333ECC5584100000000817922419A9999F9E6C5584166666666B779224166666666D6C558419A999999ED792241CDCCCC0CC9C558419A999999EE792241CDCCCCCCBFC5584166666666AF79224133333333B0C5584100000000A8792241CDCCCC8CA5C5584100000000AD792241CDCCCC8C95C5584133333333C0792241333333B382C55841CDCCCCCCDB792241333333D379C558419A999999007A2241000000E072C5584166666666B27922419A99995962C558419A9999998D792241CDCCCC6C55C55841CDCCCCCC497922410000008045C5584133333333F87822413333339336C558410000000092782241333333D32AC558416666666626782241666666261BC558419A9999999A772241CDCCCCCC00C558419A999999267722419A9999B9F1C45841CDCCCCCCE9762241666666C6E7C4584166666666CA7622419A999999DEC45841666666668C7622419A999959D0C458419A99999939762241000000A0BBC45841666666661076224166666646AFC4584166666666817622419A9999D9ADC458419A9999996C762241000000009FC458419A999999E276224100000000A1C45841666666668C772241333333939FC4584133333333A2772241CDCCCC4C82C458419A9999991A7922410000004081C4584100000000967922416666666675C458413333333364792241CDCCCC6C61C4584100000000617922419A9999D94DC4584100000000EE7922419A9999D939C45841CDCCCCCC867A2241000000A039C458419A9999999B7A22419A9999D944C458419A999999D77A22416666660646C4584100000000057C22419A99991920C45841666666669B7C224133333393BEC3584100000000E27C2241666666A6B8C3584100000000067E22410000000092C3584100000000A57E2241333333937EC358419A999999BD7E2241333333B37DC358419A9999996D7F2241CDCCCC4C68C35841CDCCCCCCD47F2241666666C65DC3584166666666548022419A9999B94DC3584166666666EB822241CDCCCCCCF7C25841CDCCCCCC9E832241CDCCCCACF9C258419A9999998784224133333373FDC25841CDCCCCCCD484224133333353F7C25841666666666185224133333333F9C2584166666666E2852241CDCCCC2CFCC2584133333333728622419A99995900C3584133333333F3862241CDCCCC8C05C358419A9999997C87224133333353ECC25841666666661487224133333353E7C258419A999999F485224166666646DCC258419A99999931862241333333B37EC25841CDCCCCCC1C8722413333331362C258416666666603882241333333D347C25841333333336C882241666666463BC2584166666666C4882241CDCCCC8C2CC2584133333333668822416666662625C25841CDCCCCCC36882241CDCCCC2C1FC258419A9999993D8822410000000014C258416666666630882241333333B3FFC15841CDCCCCCC17882241CDCCCC8CEEC15841CDCCCCCCFD872241CDCCCC8CE3C1584166666666BE8722419A999999C3C1584166666666778722419A999999B9C15841333333338C862241CDCCCC8CA5C15841666666662C862241000000209CC158419A999999ED8522419A9999B993C1584133333333BB852241CDCCCC2C89C15841CDCCCCCC588522419A99999983C158419A99999934852241CDCCCCCC72C15841000000001C852241CDCCCC8C62C15841CDCCCCCCB7842241000000E02CC158419A999999908422419A9999B91EC15841000000007B842241000000600FC158419A9999998284224100000000FEC0584133333333B6842241CDCCCC4CEDC05841CDCCCCCC03852241666666E6D8C05841000000001C852241000000A0CEC05841666666665C85224100000080BDC05841CDCCCCCC7D8522419A9999F9B7C05841CDCCCCCCB9852241CDCCCC2CB2C05841CDCCCCCCCB852241CDCCCCAC91C0584166666666648622416666660681C05841CDCCCCCCDE862241333333537AC058413333333337872241000000C06DC05841CDCCCCCCEE8622413333335363C0584100000000E1862241666666865CC05841CDCCCCCCF4862241666666E652C05841CDCCCCCC0A872241333333F34EC05841333333332D8722419A9999F93DC05841CDCCCCCC0C872241333333D32FC0584166666666EE8622419A9999191FC05841CDCCCCCCBD8622419A99997914C05841666666665A872241000000600CC05841CDCCCCCC7588224133333353FBBF58419A999999AD8822419A9999F9F5BF58419A999999FC8822419A9999D9E6BF5841666666662F8922419A999959D7BF584100000000548922419A999999C5BF5841CDCCCCCC4B89224166666626C1BF58419A9999993389224166666666C0BF58413333333303892241000000A0C3BF584100000000E788224166666666C3BF5841333333337088224166666606ADBF5841CDCCCCCC38882241CDCCCC8C7FBF58419A9999990C882241666666667BBF58419A999999BF8722410000000078BF58419A9999991F872241333333B372BF584133333333F78622413333333373BF58416666666683872241CDCCCC8C7CBF5841CDCCCCCC44872241666666068BBF5841666666662F872241333333F39ABF58419A999999008722419A999939ADBF58419A999999E58622419A999959B4BF5841CDCCCCCC9E862241CDCCCCECB4BF5841CDCCCCCC2186224100000080B9BF584133333333FF85224100000020BEBF584133333333B6852241666666E6C3BF5841666666662985224100000060C4BF584100000000FD8422419A999979C6BF584100000000AF842241333333F3CFBF5841333333339084224100000040D5BF58419A9999998D842241CDCCCC4CE1BF58416666666666842241000000A0E8BF5841000000001D8422419A999919ECBF584166666666AB832241333333B3E6BF5841666666667A832241333333B3E9BF584133333333218322419A999959E4BF5841CDCCCCCCD2822241333333D3EABF58419A9999998E82224133333313F6BF58410000000070822241CDCCCC6CFDBF5841CDCCCCCC5F82224133333353FDBF584100000000DB81224133333313F6BF5841666666668081224100000040F4BF5841CDCCCCCC678122419A999939F1BF58410000000029812241000000E0EEBF5841CDCCCCCCD5802241666666C6F1BF5841333333339E80224166666686EEBF5841CDCCCCCC4480224166666686F0BF5841CDCCCCCCFE7F2241333333F3E0BF5841CDCCCCCCDD7F22419A999919E0BF5841CDCCCCCCA77F224166666606E6BF5841000000007A7F2241333333B3E0BF584100000000607F224166666606E3BF5841000000002E7F2241CDCCCC8CE2BF584100000000257F2241333333B3EABF584166666666027F224133333313EDBF58419A9999991A7F224100000060F0BF584166666666237F2241CDCCCCCCF6BF584166666666E17E2241CDCCCC6CF9BF58419A999999D07E22413333331301C058419A999999B67E2241666666C6FDBF5841CDCCCCCCF67D224100000060FFBF584100000000C17D22419A9999B902C058419A999999B37D22413333333306C05841CDCCCCCC527D22410000002006C0584166666666637D2241000000C009C0584133333333137D2241000000C006C0584166666666977C22419A9999B9EFBF584166666666367C224166666646E1BF584100000000147C2241333333D3D5BF584100000000187C22419A999999D0BF584133333333057C2241333333D3CDBF58419A999999127C224133333373C8BF584166666666F27B22419A999959C5BF5841CDCCCCCCF07B2241CDCCCCECC0BF584100000000AB7B224133333313BDBF5841666666669E7B22419A999939BABF584100000000857B224100000000BEBF5841333333335E7B224100000000BEBF58419A999999147B224100000080B1BF5841CDCCCCCCD87A224133333313ACBF584133333333687A224166666646ADBF5841CDCCCCCC217A224100000060AFBF584166666666117A224166666686A9BF584166666666E0792241000000C0ABBF584133333333B679224133333373AABF5841CDCCCCCC6C792241CDCCCC0CACBF5841666666665F792241666666A6A7BF58419A99999913792241CDCCCCACA3BF584166666666D978224133333353A4BF584166666666B7782241CDCCCC8CA7BF5841333333339E78224166666606AFBF5841333333332978224133333333B4BF584133333333037822419A9999B9B9BF5841CDCCCCCCB877224100000020BABF584100000000417722419A999919B2BF58416666666603772241333333B3B0BF5841000000002B762241CDCCCCACB0BF584100000000EA75224133333353ACBF58416666666684752241333333B39EBF5841333333334C752241CDCCCC6C9ABF5841333333331B752241666666A698BF584100000000C5742241666666E698BF58419A999999AC742241333333139DBF58419A99999998742241CDCCCCACAEBF5841CDCCCCCC5174224133333353BFBF58416666666631742241CDCCCC0CC3BF584133333333EE732241CDCCCCECC6BF5841CDCCCCCCDB732241CDCCCC2CCCBF5841CDCCCCCCB473224133333393CEBF58419A9999994E7322419A9999B9CEBF58419A9999992873224166666646C6BF584133333333BD72224133333393BEBF5841333333338F72224133333353B6BF584100000000B272224133333313AEBF584100000000B1722241000000C0A9BF5841CDCCCCCC727222419A999959A3BF5841CDCCCCCC3372224100000080A5BF584133333333A9712241666666E6A2BF584100000000857122419A9999B9A4BF5841333333335D712241666666A6A2BF5841000000002771224166666686A3BF5841CDCCCCCCE6702241000000009EBF584166666666BB702241333333D397BF5841666666667C7022410000004097BF584166666666477022419A9999F990BF5841CDCCCCCC46702241CDCCCC8C8CBF584100000000F76F22416666668685BF5841CDCCCCCCD06F2241666666E685BF584133333333926F22419A9999798BBF5841CDCCCCCC856F22419A9999B990BF58419A999999576F2241000000E092BF584166666666036F2241CDCCCC8C92BF584100000000DD6E22410000000097BF5841CDCCCCCCA46E22419A9999B999BF584133333333906E2241CDCCCC8C9EBF58419A999999916E22419A9999F9A9BF584166666666856E22419A999919B0BF5841CDCCCCCC3F6E22419A999959B9BF584133333333E46D224133333353BDBF584100000000B36D224133333313C2BF5841CDCCCCCCA16D22419A999999CABF58419A9999994A6D22419A999939D9BF58419A999999E66C224133333313D8BF5841CDCCCCCC9D6C22419A9999F9DFBF584100000000546C2241CDCCCC2CE2BF5841CDCCCCCC756B224133333313DEBF584100000000036B2241000000C0DEBF58419A999999676A224166666606E3BF584100000000056A224100000040EBBF584166666666DE692241666666E6F2BF584100000000D669224166666646F8BF58419A999999DE692241333333F301C0584100000000D36922419A9999B907C0584100000000AB692241000000A00BC05841666666669F6922413333331316C058413333333381692241CDCCCCAC20C058419A999999546922419A9999992BC058416666666605692241666666A62AC0584166666666B76822419A9999F92BC05841CDCCCCCC896822413333331328C058419A9999993F682241666666C627C05841CDCCCCCC0B682241CDCCCC4C2AC058413333333397672241666666A632C05841000000007C6722419A99997936C0584133333333456722416666666637C05841CDCCCCCC0C6722419A9999993CC058419A999999A7662241CDCCCC6C54C05841CDCCCCCCA6662241CDCCCC4C59C05841000000006F662241000000C062C0584100000000706622410000002066C05841333333332C662241000000C06DC058419A999999076622419A99995967C05841CDCCCCCCD0652241CDCCCC2C67C0584166666666756522413333335364C05841333333333E6522416666660665C0584166666666C46422419A99991963C0584100000000926422419A9999B964C05841000000002D642241000000006DC05841333333338A632241CDCCCC0C76C058419A99999904632241666666C674C05841666666667B622241333333136FC058419A99999944622241333333D36DC05841CDCCCCCCE1612241333333736DC058416666666681612241333333B364C058416666666631612241CDCCCC4C5FC05841CDCCCCCC8A6022419A9999D95FC058419A999999B05F2241CDCCCCAC62C0584166666666A55F2241333333D369C05841333333338B5F22419A9999796AC05841CDCCCCCC8E5F2241333333336FC05841CDCCCCCC5A5F2241000000C06EC05841CDCCCCCC2F5F22416666660675C0584133333333D65E22419A99993973C05841CDCCCCCCB65E22413333335377C05841CDCCCCCC475E22410000004075C0584133333333205E2241333333937AC0584166666666EE5D2241000000C07CC0584133333333975D22419A9999B985C0584166666666585D2241333333F385C05841CDCCCCCC485D22419A9999198BC05841000000001A5D22419A9999B990C0584166666666E85C22419A99995992C0584100000000A55C2241CDCCCC6C91C05841666666662D5C22419A99991995C05841CDCCCCCCF95B2241000000C091C05841CDCCCCCCCC5B2241CDCCCC8C94C0584133333333805B2241666666668DC058419A999999595B2241333333538CC05841CDCCCCCCEF5A2241000000208FC05841333333338C5A22419A99997993C058419A999999635A2241666666E697C0584133333333505A2241CDCCCCAC9FC058419A999999265A224166666646A6C058419A999999DF5922419A9999B9AAC058419A9999999259224166666666B2C058419A9999996559224100000080BCC05841CDCCCCCC42592241000000E0BDC05841000000000D592241666666C6C6C0584133333333B75822419A999979C7C058413333333371582241333333B3D1C05841CDCCCCCCCB57224133333393DDC0584166666666B157224166666686E2C0584166666666A5572241CDCCCCCCE8C05841333333338A57224166666666E6C05841666666665857224100000020E6C058416666666628572241CDCCCC4CDFC05841CDCCCCCCFA56224100000040DBC058419A999999CE56224100000080DAC0584166666666C7562241CDCCCC0CD6C058416666666686562241000000A0D5C058419A999999695622419A999999CFC0584100000000365622419A999919CDC058419A999999F75522419A999979C6C0584100000000BB55224100000000D3C05841666666667E552241333333D3D4C05841CDCCCCCC8C5522419A999959E7C05841CDCCCCCC22552241CDCCCC8CE3C0584166666666DC542241CDCCCCACEDC05841333333335655224133333313FCC0584133333333345622419A99995905C158419A9999994D562241CDCCCCEC0FC15841666666666D562241CDCCCC6C14C1584100000000E7562241333333F320C158413333333308572241CDCCCCAC26C15841CDCCCCCC385722419A99993936C15841000000006A572241CDCCCC6C54C158419A9999998A572241CDCCCC8C60C158419A999999A2572241000000C065C15841000000002F582241000000607AC158413333333361582241000000A087C158419A999999AC58224133333353A7C15841666666660459224166666686BAC15841000000005558224133333313CCC15841666666661758224133333333D5C15841CDCCCCCC74582241CDCCCC2CFFC1584100000000F0572241CDCCCCCC06C25841CDCCCCCC5F57224100000080F9C15841000000006957224133333353F4C158410000000048572241333333D3DCC158419A99999912572241333333B3D6C158419A99999927562241CDCCCC8CC9C158419A999999AD552241000000E0C9C1584166666666AF5422419A9999F9CBC158419A999999665422419A999979D4C1584100000000865322419A999939D4C15841666666664153224166666686D5C158419A99999921532241000000E0D7C1584166666666875222419A999999D5C15841CDCCCCCC18522241CDCCCC2CD7C158410000000012522241333333B3D4C15841CDCCCCCC1451224133333373DEC158419A99999960502241333333B3E4C1584133333333F14F2241333333D3E7C15841000000009A4F2241000000A0F7C15841CDCCCCCC164F2241666666E6F7C158419A999999764E224166666626F4C158419A999999EB4D22419A9999D9ECC158419A999999474D224100000080ECC158419A999999F04C22419A999939EDC1584133333333584C224133333353E3C1584133333333F54B2241333333B3DFC1584166666666984B224133333313D5C158419A999999834B224133333373D4C1584133333333284B2241CDCCCC0CBCC15841CDCCCCCCBB4A224133333353B0C1584166666666934A2241666666C6ADC1584166666666194A224133333353B0C15841000000009C4922419A999919B8C15841333333334549224100000020B8C15841333333334549224100000020B8C15841	01010000206A080000E67CA0DF136B224166666646C5C25841	190010000	Z	Affieux	1900100	19001	19	75	31
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	01010000206A0800001A32F28C95F123419A999919A0CD5841	190020000	Z	Aix	1900200	19002	19	75	49
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	01010000206A080000DAE92E9932312241000000406E9B5841	190030000	Z	Albignac	1900300	19003	19	75	10
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	01010000206A080000B267120551872241CDCCCCFC619A5841	190040000	Z	Albussac	1900400	19004	19	75	36
01060000206A080000010000000103000000010000009E070000CDCCCCCCFF8921413333331328A458419A999999008A2141CDCCCC2C2BA4584133333333068A2141000000C02DA4584133333333158A21419A99995933A4584166666666268A21419A9999D938A45841000000002B8A2141333333133AA4584100000000418A21410000006045A458419A999999528A21419A9999F94AA4584100000000578A2141000000204DA45841CDCCCCCC618A2141333333B350A45841CDCCCCCC6E8A21416666660654A45841666666667B8A21413333331357A45841CDCCCCCC948A21413333333356A45841CDCCCCCC288B2141666666C648A458419A9999990E8C21419A9999F95EA458419A9999998A8C2141333333B372A4584133333333AE8D21419A99993992A4584100000000B98D21410000004090A4584133333333C68D2141CDCCCC0C8EA4584133333333CD8D2141666666668DA45841CDCCCCCCD88D21419A9999F98CA4584133333333F18D2141000000C08CA4584133333333258E2141000000808CA45841CDCCCCCC428E2141CDCCCC0C8CA45841333333336B8E2141666666C68AA458419A999999928E21419A99995989A45841CDCCCCCCB78E21410000000088A45841CDCCCCCCB48E2141666666C68AA4584100000000AD8E2141CDCCCCAC8CA45841CDCCCCCC9B8E21419A99991992A45841333333338A8E21419A99997998A4584166666666848E2141666666269BA4584166666666798E2141666666C6A0A4584166666666738E2141CDCCCC0CA5A4584166666666738E2141666666C6A5A45841CDCCCCCC588E2141000000A0ACA458419A9999995C8E2141000000A0B6A4584100000000628E214166666626BDA4584166666666DC8E214133333373BBA45841CDCCCCCC408F21419A999999C1A4584133333333938F2141000000E0B8A45841CDCCCCCC9D9021419A999939B8A45841666666669091214166666666BEA4584100000000A79121419A999939BFA458419A999999C3912141666666C6BFA4584100000000E091214100000000C0A45841CDCCCCCCFA91214100000060C0A45841666666661F92214100000020C2A45841CDCCCCCC3C92214166666606C4A45841666666666192214133333353C6A45841CDCCCCCC8592214133333313C8A4584100000000A792214166666626C9A4584166666666DD922141000000E0CAA45841000000001493214100000020CDA458419A9999992F932141CDCCCC8CCEA458419A99999947932141CDCCCC4CD0A45841666666665993214166666626D2A4584100000000649321419A9999F9D3A45841666666666B9321419A9999B9D5A45841CDCCCCCC73932141666666A6D6A458419A9999997F9321419A999979D7A45841CDCCCCCCA0932141CDCCCCCCD9A4584100000000EA93214133333313E3A458416666666664952141CDCCCCEC05A558419A999999E0952141666666C61CA5584166666666C39521419A9999991DA5584100000000A3952141666666A61BA5584133333333879521419A99997917A558419A999999799521416666666614A5584133333333649521410000000012A55841333333334F9521419A99997910A55841CDCCCCCCF1942141CDCCCC2C0BA5584133333333D1942141CDCCCC0C0AA558419A999999C49421419A99999909A558419A999999AC942141333333D308A558419A99999971942141CDCCCC4C0AA5584100000000519421419A9999790BA5584166666666259421419A9999190CA5584133333333F3932141666666860CA5584100000000E69321419A9999D90CA5584166666666DD932141CDCCCC8C0EA5584100000000DE932141CDCCCCEC10A5584100000000E5932141666666C613A558419A999999EB9321419A99997915A5584133333333FC9321410000002018A55841000000000B942141666666261BA558413333333310942141000000201EA5584166666666209421419A9999B922A558419A9999992B942141CDCCCCAC24A558410000000048942141CDCCCC6C27A5584166666666699421413333331329A558419A999999769421419A9999B929A5584166666666809421419A9999792CA55841CDCCCCCC7A942141666666262FA5584100000000709421419A99999930A5584100000000509421419A99995934A55841000000003F942141333333F336A5584166666666379421416666664639A55841CDCCCCCC369421419A9999B93BA55841333333333D942141CDCCCCEC3EA55841666666666B9421416666664648A558419A999999C3942141CDCCCC0C57A55841CDCCCCCCE5942141000000205CA5584133333333F2942141CDCCCCAC5FA5584166666666F39421416666668661A55841CDCCCCCCF39421416666666664A55841CDCCCCCCF19421419A9999F964A5584166666666E8942141666666E667A558419A999999DE9421416666668668A5584100000000D0942141CDCCCC4C69A55841CDCCCCCCB2942141333333D36AA55841333333339C942141000000A06BA55841333333337F942141333333536EA55841CDCCCCCC619421413333339372A55841CDCCCCCC549421410000004074A5584100000000429421410000008075A558416666666628942141CDCCCC0C75A5584166666666E79321419A99991973A558419A999999D3932141CDCCCC6C72A558419A999999BD9321410000008073A55841CDCCCCCCB19321419A9999B974A5584166666666AC932141000000E075A5584100000000A8932141CDCCCC6C78A55841CDCCCCCCA7932141000000E07AA5584166666666AB932141333333F37CA558419A999999AC932141CDCCCC0C7EA558419A999999AB9321413333331381A558419A999999A19321419A99997983A558410000000094932141666666C684A55841666666668D9321410000002086A55841333333337E932141CDCCCC0C89A55841000000007A932141000000808AA55841333333336C932141CDCCCCCC8EA55841CDCCCCCC58932141666666E694A558419A999999439321410000008097A558419A99999929932141CDCCCC0C97A558416666666609932141CDCCCC8C95A5584166666666E4922141CDCCCCCC94A55841CDCCCCCCC3922141CDCCCC4C95A5584166666666A7922141000000E096A558419A999999919221419A99999999A558419A9999997E922141000000C09EA55841666666667B922141CDCCCC4CA4A5584133333333849221419A9999F9ADA55841CDCCCCCC889221419A999979B1A5584133333333819221419A9999F9B5A55841666666666892214133333353BDA558419A999999509221419A9999B9BFA55841333333334792214100000040C0A55841000000003692214133333333C1A558413333333323922141666666E6C1A55841000000000B922141CDCCCC6CC1A5584133333333EB91214166666626C0A5584166666666C6912141333333F3BEA55841CDCCCCCCB0912141333333B3BFA55841CDCCCCCCA7912141CDCCCCECC0A5584133333333A3912141666666C6C2A55841666666669C91214166666606C5A5584133333333929121419A9999F9C5A5584166666666709121419A9999B9C6A5584100000000249121419A999959C6A558419A999999FC9021419A9999B9C6A558419A999999E5902141000000A0C7A5584166666666C790214133333313C9A558419A999999B4902141CDCCCCCCCAA558419A9999999B902141333333D3D0A55841CDCCCCCC9190214166666606D4A558419A9999998E902141333333B3D5A5584166666666939021419A999999D8A55841666666669990214100000020DBA558419A9999999E90214133333333DDA558419A999999A99021419A999919E0A5584133333333AE902141CDCCCC8CE1A5584100000000AF90214100000000E3A5584133333333A5902141CDCCCCECE6A55841333333335590214100000040F8A5584100000000289021413333335300A658419A9999990D9021419A9999D903A6584166666666EB8F2141000000A005A65841CDCCCCCCCF8F21419A99997908A658419A999999C68F2141666666A60AA658419A999999B88F2141CDCCCCAC0CA65841CDCCCCCC9B8F2141CDCCCC4C0EA65841CDCCCCCC848F21419A9999590FA6584133333333928F2141333333F312A6584166666666A28F21410000004017A658419A999999E48F21416666660621A6584133333333EC8F21416666662623A6584100000000ED8F21410000008024A65841666666665D9021419A9999B91FA6584133333333FF9021416666668619A6584133333333D5922141CDCCCCEC5BA6584133333333DD922141333333935CA65841CDCCCCCCE7922141CDCCCCCC5DA6584100000000F6922141000000A05FA658416666666606932141333333B361A6584133333333149321413333339363A658419A99999920932141CDCCCC0C65A65841CDCCCCCC2C9321416666664666A6584133333333399321410000008067A6584100000000439321413333337368A65841CDCCCCCC54932141333333136AA658419A99999968932141333333B36BA658413333333383932141000000E06DA6584100000000A99321419A99993971A6584133333333C7932141333333B373A65841CDCCCCCCDE932141666666E675A65841CDCCCCCC009421413333337379A65841333333331C942141333333537CA658416666666631942141333333337EA65841666666664F942141CDCCCCCC80A65841CDCCCCCC5B9421410000002082A65841000000006F9421410000002084A65841CDCCCCCC7A942141666666A685A6584100000000869421416666660687A6584133333333939421416666666688A65841333333339F942141666666C689A6584166666666A8942141CDCCCCAC8AA6584133333333B7942141333333138CA6584166666666C3942141666666468DA658419A999999D3942141CDCCCCAC8EA6584166666666E19421419A9999F98FA65841CDCCCCCCEF942141CDCCCC2C91A65841333333330C9521416666668693A658416666666629952141000000E095A65841CDCCCCCC41952141000000C097A65841333333335B9521413333339399A65841666666666E952141666666069BA6584166666666969521419A9999B99DA65841CDCCCCCCB995214100000040A0A6584100000000D6952141CDCCCC0CA2A6584100000000F695214133333313A4A65841CDCCCCCC13962141333333D3A5A658416666666631962141CDCCCC6CA7A65841333333335396214100000060A9A658410000000070962141CDCCCCCCAAA65841000000009E962141CDCCCCACADA6584100000000B896214133333373AFA658419A999999CF962141CDCCCC0CB1A6584100000000E096214100000040B2A6584166666666EF9621419A999959B3A6584133333333FA96214100000020B4A65841CDCCCCCC0997214166666666B5A65841CDCCCCCC2797214133333313B8A658416666666639972141666666C6B9A658419A9999994A97214100000040BBA65841CDCCCCCC5A9721419A9999B9BCA65841666666666A972141CDCCCC0CBEA658413333333376972141CDCCCC2CBFA65841CDCCCCCC8C9721419A999939C1A65841CDCCCCCC9A9721419A999979C2A65841CDCCCCCCA597214100000060C3A6584166666666B29721419A999959C4A6584100000000C3972141333333B3C5A6584133333333D1972141666666E6C6A6584100000000E097214166666646C8A6584100000000F497214166666626CAA6584166666666079821419A9999D9CBA65841CDCCCCCC16982141CDCCCC6CCDA65841666666662898214100000040CFA658419A9999993598214166666686D0A658419A9999993E98214100000040D1A658419A9999994D98214100000080D2A65841666666665C9821419A9999D9D3A65841666666666998214100000000D5A65841CDCCCCCC74982141333333F3D5A65841666666667C9821419A999979D6A658410000000084982141CDCCCCCCD6A658413333333389982141000000E0D6A65841333333338898214133333393D7A65841CDCCCCCC8798214133333373D8A65841666666668998214166666686D9A658419A9999998F982141CDCCCCCCDAA65841333333339A9821419A999979DCA6584100000000A698214133333333DEA6584100000000AF9821419A999979DFA6584100000000B69821419A999959E0A6584166666666BC98214100000060E1A6584133333333C398214166666646E2A6584100000000CD9821419A999979E3A6584100000000DA982141666666C6E4A65841CDCCCCCCE5982141CDCCCCCCE5A65841CDCCCCCCEE98214133333393E6A658419A999999F698214133333333E7A6584133333333FA98214100000060E7A6584166666666029921419A9999B9E7A65841333333331F992141CDCCCCACE8A65841666666664A9921419A999939EAA65841CDCCCCCC70992141CDCCCCACEBA6584166666666B19921419A999919EEA6584166666666E199214133333393F0A65841CDCCCCCCEF992141CDCCCC4CF1A65841CDCCCCCCFE99214166666666F2A65841666666660C9A21419A9999B9F3A6584100000000159A214166666686F4A65841666666661B9A214100000020F5A658419A999999299A214100000080F6A65841CDCCCCCC379A214100000000F8A6584100000000449A2141CDCCCC6CF9A65841333333334A9A214166666666FAA6584166666666549A214166666666FCA65841CDCCCCCC5C9A214166666626FEA658419A999999629A214166666666FFA65841000000006B9A21410000004001A75841666666666F9A21410000006002A7584133333333799A2141666666C604A7584133333333849A21413333331307A75841000000008E9A21413333331309A7584133333333959A2141000000800AA75841CDCCCCCC9D9A2141666666E60BA758419A999999AB9A2141000000A00DA7584100000000B69A2141333333D30EA758419A999999C39A2141CDCCCCEC0FA7584133333333D19A2141CDCCCC2C11A7584100000000E19A21413333335312A758419A999999EF9A21416666660613A7584100000000F99A21419A99997913A7584100000000099B21410000000014A75841CDCCCCCC119B2141CDCCCC4C14A758419A9999991B9B21413333339314A7584166666666279B2141CDCCCCEC14A7584166666666369B21413333333315A75841CDCCCCCC3F9B21419A99995915A758419A999999489B21419A99997915A75841CDCCCCCC599B2141CDCCCCAC15A75841333333336A9B21419A9999D915A7584100000000779B21413333331316A7584100000000849B21413333335316A75841CDCCCCCC8F9B214133333313FEA65841CDCCCCCC9C9C214133333333F9A6584133333333E29C2141666666E600A75841000000000C9D2141CDCCCCCC02A758419A999999EB9D21410000000004A758419A999999429E21419A99995900A75841000000007C9E214133333313FFA658419A9999999F9E2141333333B3FFA6584166666666989E2141000000A000A75841333333338C9E21419A9999F902A7584100000000859E21413333337304A7584100000000829E2141CDCCCC2C05A75841CDCCCCCC7B9E2141CDCCCC4C06A7584100000000749E21410000004007A758419A999999649E2141333333D307A7584133333333549E21413333331308A75841666666664D9E2141666666A608A7584100000000499E2141666666C609A7584100000000419E2141333333B30BA75841CDCCCCCC3C9E2141CDCCCCAC0CA758419A999999369E2141000000600DA7584133333333309E21419A9999790EA75841CDCCCCCC269E2141000000E00FA758419A9999991F9E21419A99991911A75841CDCCCCCC149E2141CDCCCCAC12A75841CDCCCCCC0C9E2141CDCCCC0C14A7584166666666089E2141CDCCCC0C15A7584166666666059E21416666668616A75841CDCCCCCC009E21413333339319A7584100000000009E2141666666261CA75841CDCCCCCCFE9D21419A9999B91EA758419A999999FF9D2141CDCCCC8C21A7584166666666FF9D21419A99993923A758419A999999019E21419A9999F924A7584100000000059E21416666666627A758419A999999089E2141CDCCCCCC29A75841333333330B9E2141333333F32BA758419A9999990B9E2141CDCCCC2C2FA75841333333330B9E2141666666A631A75841000000000B9E21410000002034A75841666666660B9E21416666666636A75841CDCCCCCC0A9E21413333337337A758419A999999329E21416666660639A75841CDCCCCCC339E21419A9999B939A7584166666666349E2141333333533AA7584100000000369E2141666666263CA75841CDCCCCCC3A9E2141666666C63FA75841333333333F9E21413333333344A75841CDCCCCCC439E2141666666E648A7584133333333499E21419A9999594DA75841000000004E9E21410000004051A75841CDCCCCCC529E21413333333355A7584133333333579E21410000004058A75841000000005A9E2141000000C05AA75841CDCCCCCC5B9E2141333333335DA75841333333335D9E2141CDCCCCAC5FA75841CDCCCCCC5D9E2141333333F361A75841000000005E9E2141CDCCCC0C64A758419A9999995C9E2141666666A665A75841333333335A9E21410000008069A7584133333333589E2141000000A06BA75841CDCCCCCC569E21419A9999196EA7584133333333559E2141666666E66FA75841CDCCCCCC549E2141333333D371A7584133333333549E21419A99993974A7584100000000549E21419A99995976A758419A999999549E21416666666677A7584100000000569E21419A99999978A7584166666666589E2141CDCCCC2C7AA75841666666665B9E2141333333737BA758419A9999995D9E21419A9999B97CA75841CDCCCCCC5D9E2141333333F37DA75841CDCCCCCC5B9E2141666666267FA758419A999999599E21413333331380A7584133333333549E21413333339381A75841CDCCCCCC4E9E2141666666C682A75841CDCCCCCC449E21410000006085A75841333333333B9E2141666666C688A7584133333333339E2141000000E08BA75841333333332D9E2141CDCCCC2C8FA75841000000002B9E21416666664691A7584133333333299E2141666666E693A758419A999999299E2141000000A096A75841CDCCCCCC2B9E2141CDCCCC2C9AA75841666666662D9E2141CDCCCC8C9BA75841CDCCCCCC319E2141666666669DA7584133333333379E2141000000409FA7584100000000429E21419A9999F9A1A75841333333334B9E2141000000A0A4A75841CDCCCCCC539E214100000000A7A75841333333335C9E21419A9999F9A9A758419A999999619E2141333333D3ABA75841CDCCCCCC669E214133333393ADA75841CDCCCCCC699E214166666686AFA7584100000000699E214100000000B1A7584133333333659E214133333333B2A75841CDCCCCCC5F9E214133333313B3A75841333333335A9E2141CDCCCC0CB4A7584166666666539E21419A9999D9B4A75841333333334C9E2141CDCCCCECB5A7584166666666429E214100000080B8A758419A999999359E2141CDCCCC0CBCA75841CDCCCCCC2D9E2141666666A6BEA7584133333333279E214100000080C1A75841CDCCCCCC249E21419A9999D9C2A7584166666666229E214100000080C4A7584166666666229E2141666666A6C5A7584100000000269E21419A999979C6A75841CDCCCCCC2A9E21419A9999F9C6A758419A9999990A9E2141CDCCCCACD3A7584133333333D29D21419A999919E5A7584100000000C79D2141666666A6E6A758419A999999BE9D2141333333F3E7A7584166666666B99D2141333333F3E8A75841CDCCCCCCB39D214166666626EAA758419A999999AF9D214100000060EBA7584133333333A39D2141333333F3ECA75841CDCCCCCC999D21419A999919EEA7584166666666899D214100000040F0A7584166666666759D21419A999959F2A7584100000000639D214100000040F4A758419A999999529D21419A999919F6A7584166666666479D21419A9999B9F7A75841CDCCCCCC3D9D214100000000F9A7584100000000339D214133333373FAA758419A9999992C9D214100000080FBA75841CDCCCCCC259D214100000000FCA75841333333331E9D214166666646FCA75841333333330D9D2141333333B3FCA758419A999999F89C2141CDCCCC0CFDA7584133333333DD9C2141000000E0FDA758419A999999C79C21419A999999FEA75841CDCCCCCCB59C214100000060FFA7584133333333A09C21419A99993900A85841CDCCCCCC8D9C2141CDCCCC0C01A8584133333333829C21419A9999D901A85841333333337B9C21410000008002A85841CDCCCCCC779C21413333337302A85841CDCCCCCC6F9C21413333333302A85841CDCCCCCC649C2141333333F301A858419A9999995A9C21413333331302A858419A9999994D9C21419A9999D902A8584133333333469C2141CDCCCC8C03A85841CDCCCCCC3D9C21413333339304A858419A999999349C21419A9999B905A85841333333331F9C21419A99995908A858419A999999109C2141333333330AA858419A999999029C21419A9999F90BA8584100000000F49B21419A9999D90DA8584166666666E99B2141333333330FA8584133333333D99B21416666666611A8584133333333CC9B21419A99997913A8584133333333C19B21413333337315A858419A999999B59B2141333333B317A85841CDCCCCCCA99B2141666666261AA858419A999999A19B2141666666061CA8584100000000989B2141000000401EA85841333333338E9B2141CDCCCC6C20A8584100000000899B21419A99999921A85841333333337F9B21416666664623A8584100000000769B2141333333D324A8584100000000659B21410000000028A8584100000000529B2141333333532BA8584166666666409B2141CDCCCCEC2EA858419A999999389B2141CDCCCCAC30A85841333333332E9B21413333339332A85841333333331E9B21419A99997936A858419A999999099B2141CDCCCC2C3BA8584166666666F89A2141CDCCCC4C3FA85841CDCCCCCCF69A2141666666A63FA8584166666666E39A21413333331344A85841CDCCCCCCD49A2141CDCCCC8C47A858419A999999CA9A21419A9999F949A858419A999999B79A2141333333934EA8584100000000AA9A2141CDCCCCEC51A858419A999999979A21419A99991956A8584133333333889A21419A99997959A8584133333333789A2141333333B35CA858419A9999996F9A21419A9999995EA8584166666666669A2141000000C060A858419A9999995C9A2141666666E662A85841000000004F9A21410000002066A858419A999999449A2141CDCCCC4C68A85841666666663E9A21413333337369A858419A999999359A2141000000A06AA85841CDCCCCCC2B9A21419A9999F96BA858419A9999991B9A2141666666C66DA858419A9999990F9A2141000000406FA85841CDCCCCCC089A21410000000070A8584166666666009A2141CDCCCCEC70A8584100000000F8992141666666A671A85841CDCCCCCCF0992141CDCCCC4C72A8584133333333E8992141000000A073A8584100000000DE992141CDCCCC4C75A85841CDCCCCCCD69921419A9999D976A8584166666666CF992141CDCCCC4C78A858419A999999C7992141333333337AA858419A999999C0992141666666267CA85841CDCCCCCCBA992141666666867EA8584133333333B59921410000006081A8584133333333B1992141333333D383A8584166666666AD9921419A9999F985A8584133333333AA9921410000002088A85841CDCCCCCCA8992141333333D389A8584100000000A7992141CDCCCCCC8BA8584133333333A5992141CDCCCC8C8EA858419A999999A29921419A9999D990A8584100000000A09921413333337393A85841333333339E992141666666C695A85841333333339A992141CDCCCCCC9BA858419A99999999992141333333539DA8584133333333999921419A9999999EA85841333333339A9921419A9999B99FA858419A9999999A992141CDCCCC6CA0A85841333333339B99214166666646A1A85841666666669D9921419A999979A2A8584166666666A0992141666666A6A3A858419A999999A299214133333313A5A8584100000000A4992141000000E0A5A85841CDCCCCCCA699214100000020A7A85841CDCCCCCCA999214100000060A8A8584100000000AC99214166666686A9A8584166666666AD99214133333333ABA8584133333333AF992141CDCCCCCCACA858419A999999B1992141666666A6AEA8584133333333B399214133333313B0A8584100000000B599214133333393B1A858419A999999B6992141CDCCCC0CB3A8584100000000BA992141CDCCCC6CB5A8584133333333BC992141CDCCCC4CB7A858419A999999BD992141333333B3B8A8584100000000BE9921419A999959BAA858419A999999BE992141000000E0BBA85841CDCCCCCCBE99214133333393BDA8584166666666BF992141CDCCCCACBFA858419A999999BF99214166666606C1A8584166666666C1992141CDCCCC4CC2A8584100000000C4992141000000A0C3A8584100000000C799214100000060C4A8584100000000CB992141CDCCCC8CC5A858419A999999D7992141CDCCCC6CC8A858419A999999E1992141000000E0CAA858419A999999E29921419A999919CBA858419A999999F59921419A999999CFA8584166666666059A214100000060D3A85841CDCCCCCC129A2141CDCCCCECD6A85841CDCCCCCC249A214166666686DDA858419A999999339A2141000000C0E2A85841333333333D9A21419A999979E5A85841666666667C9A21419A9999B9E4A85841CDCCCCCC8D9A214133333313E4A85841CDCCCCCC9A9A214133333333E4A8584100000000A89A2141000000E0E4A858419A999999B19A21419A999919E6A8584100000000B79A214100000020E7A858419A999999B99A2141666666C6E8A8584133333333199B21419A999939E9A8584133333333AA9B2141666666A6E9A8584166666666D99B2141CDCCCC8CE9A8584166666666139C2141666666A6E7A85841CDCCCCCC2F9C2141CDCCCCACE5A858419A9999994F9C2141000000C0E1A85841CDCCCCCC139C214133333373D9A85841CDCCCCCCDC9B214100000000D3A85841CDCCCCCC1A9C214133333333C9A85841666666664F9C214100000060C8A85841CDCCCCCC929C21419A999999C6A8584100000000D39C2141333333D3C3A8584166666666089D2141CDCCCCACBEA85841CDCCCCCC3E9D21419A9999F9B8A85841000000007B9D214133333353B2A858419A999999BF9D2141CDCCCCACA9A858419A999999EA9D214133333393A3A8584100000000139E2141CDCCCC4C9FA85841CDCCCCCC479E2141333333739BA858419A999999719E21416666662698A85841666666668A9E21410000008099A8584100000000A39E2141CDCCCCCC9AA858419A999999B99E2141333333D39AA8584166666666DD9E2141666666069CA85841CDCCCCCCFB9E2141333333B39DA85841CDCCCCCC099F2141000000409FA8584133333333199F2141666666869FA8584100000000329F214100000000A0A85841666666664B9F214133333333A0A8584100000000689F2141666666E6A0A8584166666666809F214166666666A2A8584133333333AE9F21419A9999B9A6A858419A999999BF9F2141333333B3A9A85841CDCCCCCCC49F21419A999999ABA85841CDCCCCCCDD9F21419A9999F9AEA858416666666604A0214166666626B2A85841666666662AA021419A999999B3A85841000000003CA0214166666646B4A85841000000005AA02141CDCCCCACB5A858413333333377A02141000000C0B7A858419A9999998FA02141CDCCCC4CB9A8584100000000A7A02141CDCCCC0CBAA8584133333333BDA0214100000020BBA858419A999999DBA02141333333B3BCA8584166666666FCA0214100000060BEA858410000000025A1214166666646C0A858416666666640A1214100000080C2A858410000000056A1214100000060C4A858413333333373A12141666666A6C6A858413333333373A12141000000E0C6A85841000000008EA12141666666E6C7A8584133333333A4A12141000000E0C8A8584100000000ABA1214166666666C9A858419A999999B3A1214166666666CAA8584133333333C5A121419A9999D9CCA8584166666666CEA121419A9999D9CDA85841CDCCCCCCE5A1214133333393CFA858419A999999F9A1214133333373D0A85841CDCCCCCC0DA221419A9999B9D0A858410000000029A22141CDCCCC6CD1A85841666666663CA221419A999939D2A858416666666650A221419A999979D3A85841666666665EA22141000000E0D4A858410000000071A22141000000A0D6A858419A9999997FA22141CDCCCC8CD7A858413333333396A2214100000060D7A8584166666666B4A221419A999939D7A858419A999999BDA221419A999939D3A8584166666666CBA22141CDCCCC8CCFA85841CDCCCCCCE1A2214166666666CBA8584133333333F8A22141CDCCCCACC8A858413333333307A32141CDCCCC4CC7A85841CDCCCCCC22A321419A999999C5A85841333333333AA3214166666646C4A858410000000049A32141333333F3C2A85841CDCCCCCC57A3214133333353C1A858413333333364A321419A999999BFA85841333333336DA3214100000040BEA858419A99999977A3214166666686BCA858410000000085A321419A9999F9B9A858410000000090A32141333333B3B7A858419A9999999BA32141333333F3B4A858419A999999A4A32141333333D3B2A8584166666666AEA3214133333393B0A85841CDCCCCCCB5A3214133333373AEA8584133333333BAA3214100000080ACA8584133333333BEA3214133333353AAA85841CDCCCCCCC1A3214100000040A8A858419A999999C4A3214133333333A6A8584100000000C8A321419A9999B9A3A8584100000000CBA3214166666606A1A858419A999999CFA321419A9999399CA8584166666666D2A321410000000099A8584133333333D5A321419A9999B996A8584166666666D7A32141666666C694A858419A999999D9A321410000006092A8584100000000DCA32141CDCCCC6C8FA858419A999999DEA32141CDCCCC0C8CA858419A999999E1A32141CDCCCCCC88A85841CDCCCCCCE3A32141CDCCCC8C85A85841CDCCCCCCE6A32141000000E082A858419A999999E9A32141333333D37FA85841CDCCCCCCEBA32141000000A07DA8584133333333EEA32141CDCCCC6C7CA858419A999999F1A32141CDCCCC8C7BA8584133333333F4A32141000000407AA85841CDCCCCCCF3A321419A99995979A85841CDCCCCCCF6A32141333333B377A858419A999999FBA32141CDCCCCAC75A858413333333304A421410000002073A85841000000000BA42141CDCCCC0C71A858419A99999914A42141666666466EA858416666666621A42141CDCCCCEC69A85841000000002AA42141666666C666A858413333333337A42141CDCCCC4C62A858416666666644A42141000000605DA85841000000004CA42141666666C65AA858410000000054A42141000000E057A85841CDCCCCCC5DA421419A9999D954A858413333333362A421410000004053A858419A99999968A421419A9999594FA858419A99999968A42141666666E64CA8584133333333BBA42141000000E049A85841333333337BA521410000004049A85841000000009FA52141CDCCCC8C41A8584133333333BBA52141CDCCCCEC36A8584166666666C3A52141000000A021A858410000000018A62141666666661CA858419A99999926A62141CDCCCCCC0BA858419A9999990CA72141CDCCCC4CFFA7584166666666EDA62141CDCCCCACF5A7584166666666FAA621419A999919F1A75841333333333AA721419A999979EDA758419A99999975A72141333333B3EDA7584166666666A7A7214166666666EFA758419A999999B0A72141333333B3F1A7584166666666BDA72141CDCCCCECF3A7584166666666CEA72141CDCCCCACF6A758413333333344A82141000000E0F8A758410000000077A82141666666E6F7A7584133333333A3A8214100000000F4A758419A999999B2A82141666666E6EEA7584166666666B1A82141CDCCCCECE9A7584166666666B9A8214133333333E7A758419A99999951A9214100000060DCA75841000000006DA92141CDCCCC2CE2A758410000000087A921419A9999F9E6A7584166666666E6A921419A999959F8A758413333333321AA21413333339302A85841000000002BAA21416666664605A85841CDCCCCCC3BAA2141666666E609A858410000000040AA21416666660613A858410000000037AA2141333333D31CA85841666666660DAA21413333337328A8584100000000D5A92141CDCCCC4C34A858419A999999CDA92141333333933CA8584166666666C8A92141000000604AA85841CDCCCCCCC0A92141333333F353A8584133333333BBA92141666666665BA8584166666666AAA921419A9999396EA858410000000086A92141000000E084A85841000000007CA92141CDCCCC8C92A858419A9999997DA921410000006094A858413333333385A92141333333739BA85841CDCCCCCCA1A9214133333393ABA8584166666666B6A92141CDCCCCACBEA8584100000000C5A9214100000020CCA8584133333333E7A92141CDCCCCECDAA8584166666666EFA9214100000040E2A8584133333333EDA9214100000060E9A8584166666666DFA92141000000E0F3A858419A999999D6A9214166666606FBA8584133333333D7A92141CDCCCC6C0DA95841CDCCCCCCD9A92141333333B313A9584166666666ECA92141000000001DA95841CDCCCCCCF1A92141000000C01FA958419A99999931AA21419A9999B92DA958416666666668AA2141333333D336A958419A99999987AA2141333333F33BA9584133333333C2AA21413333333349A958419A999999FCAA2141000000605AA958419A99999919AB2141666666666BA958419A99999931AB21410000002077A95841333333337FAB2141CDCCCC0C8DA9584133333333ACAB21419A9999999CA9584100000000CFAB2141CDCCCCACACA9584133333333DDAB21419A9999D9B1A9584133333333E5AB2141000000C0B4A9584100000000EDAB21419A999999B7A95841666666660DAC2141333333D3C1A958413333333348AC214100000020CDA958410000000059AC2141CDCCCCECCFA958410000000072AC2141666666C6D4A958419A9999997DAC2141000000C0D8A958413333333399AC214133333373DCA9584166666666B7AC2141CDCCCC6CE0A958419A999999D8AC2141000000C0E4A958419A999999FEAC2141CDCCCC2CEAA95841CDCCCCCC2EAD2141CDCCCC6CF3A95841CDCCCCCCA2AD21419A999999FEA958419A999999BBAD21410000006001AA584133333333D3AD2141333333F305AA584133333333E9AD2141333333D30DAA58416666666614AE21413333335319AA58416666666640AE2141CDCCCC8C24AA58419A99999980AE2141333333D334AA584133333333DAAE21419A99991949AA5841333333330FAF21419A99993954AA58416666666667AF21419A9999F95BAA58419A99999984AF2141666666665EAA584166666666BBAF21419A99995962AA5841CDCCCCCC06B021419A9999197CAA584133333333F6AF2141000000E08EAA584100000000D1AF2141333333F3A4AA58413333333306B0214166666626AFAA58413333333321B02141666666A6B5AA5841CDCCCCCC3DB02141333333B3B9AA58419A9999997AB02141CDCCCC0CBEAA5841CDCCCCCCACB02141CDCCCC8CBEAA58419A999999EAB02141000000A0BCAA58419A99999938B121419A999919BAAA5841CDCCCCCC4FB12141CDCCCC0CB9AA5841000000006FB1214133333393B6AA5841CDCCCCCCA0B12141666666E6B4AA584100000000D4B12141000000C0B5AA584100000000F6B1214133333313B8AA584133333333FDB121419A999999BCAA58416666666601B2214100000060BDAA5841333333330EB2214166666666BFAA58410000000030B22141000000E0C3AA58413333333357B2214133333373CAAA58419A9999995CB221419A999959CDAA5841333333335AB2214100000080CFAA5841CDCCCCCC3FB2214133333393D3AA58419A99999924B22141333333B3D6AA5841CDCCCCCC17B22141CDCCCCECDAAA5841CDCCCCCC15B221419A999939DCAA58419A9999990DB22141333333D3E1AA58419A9999990DB22141666666E6E8AA58413333333313B22141CDCCCC4CECAA58413333333326B2214100000060F3AA58410000000055B22141CDCCCCECF9AA5841CDCCCCCCB8B221410000004011AB584166666666CDB221413333331316AB58419A999999F0B22141CDCCCC4C1EAB584166666666F9B221419A99997922AB5841CDCCCCCCFEB221410000000035AB58416666666601B321419A99997955AB584166666666FEB221416666668671AB58410000000008B32141333333B396AB5841333333330BB32141CDCCCCEC9BAB58413333333339B3214100000020AEAB58416666666670B3214100000080C4AB58419A9999999CB3214166666646D2AB584100000000C2B321419A9999B9D9AB5841000000000CB421419A999999E2AB58419A9999991FB421419A9999D9E0AB58416666666632B42141000000E0DFAB5841333333334AB4214166666626DFAB58410000000052B42141CDCCCCCCDEAB5841666666665AB4214100000060DEAB5841666666666AB421419A999919DDAB58410000000083B4214166666606DAAB58410000000098B4214100000000D8AB584100000000A3B421419A999999D7AB58419A999999AEB4214166666606D7AB5841CDCCCCCCB7B42141CDCCCCACD6AB584133333333D9B421419A999919D7AB58419A99999906B52141000000C0D6AB58419A9999992DB521419A999959D6AB5841CDCCCCCC4FB521419A9999D9D5AB5841CDCCCCCC68B52141CDCCCCCCD4AB5841000000008EB52141CDCCCCCCD2AB58419A999999ABB52141000000A0D1AB5841CDCCCCCCC9B5214166666646D1AB584133333333E5B521419A999919D1AB584133333333FAB5214166666606D1AB58419A99999926B62141CDCCCC2CD1AB58416666666635B62141CDCCCC6CD1AB5841CDCCCCCC60B6214166666686DEAB5841CDCCCCCC19B6214133333393E3AB58419A9999994FB62141CDCCCC0CF1AB5841666666667FB7214133333373F9AB58410000000091B7214100000080EEAB58419A999999CAB721419A999999E5AB5841CDCCCCCC4DB8214133333393E3AB5841CDCCCCCCCBB82141333333D3D9AB5841CDCCCCCC08B92141333333F3D6AB58410000000092B921419A999919D6AB5841CDCCCCCC55BA2141CDCCCC2CC5AB58410000000096BA2141CDCCCC0CDAAB584133333333A0BA214133333373D9AB58419A999999BBBA2141000000A0D8AB5841CDCCCCCCD8BA2141CDCCCC6CD7AB5841000000000ABB21419A9999F9D5AB58419A9999991EBB2141CDCCCC4CD5AB5841CDCCCCCC2CBB214166666686D4AB58410000000037BB214133333393D3AB5841CDCCCCCC3DBB21419A999939D2AB58419A99999942BB214166666666D0AB5841CDCCCCCC45BB2141333333D3CDAB5841333333334ABB214133333393CBAB5841CDCCCCCC52BB2141CDCCCC6CC9AB58413333333360BB21419A999919C8AB58416666666671BB214133333313C7AB58413333333380BB2141CDCCCCECC5AB5841333333339ABB2141666666A6C7AB584133333333ADBB21419A9999B9C7AB584166666666D9BB2141CDCCCC4CC8AB58419A99999904BC214166666666C8AB58419A9999991ABC2141CDCCCC8CC7AB5841666666662DBC2141000000A0C5AB5841000000005EBC2141666666C6BEAB5841000000006CBC214100000020BDAB58413333333373BC21419A9999D9BCAB5841000000007CBC2141666666C6BCAB5841CDCCCCCC80BC2141000000A0BCAB5841333333338BBC214100000020BBAB58410000000096BC2141333333B3B9AB584133333333A9BC2141666666E6B6AB584133333333BBBC2141666666C6B3AB58419A999999C0BC214133333333B2AB584166666666C6BC21419A999979B1AB58419A999999CEBC21419A9999B9B0AB584100000000E0BC2141CDCCCC4CB0AB5841CDCCCCCCF4BC2141CDCCCC2CB0AB58419A999999FDBC2141666666E6AFAB58410000000017BD2141CDCCCC4CAFAB58419A99999942BD2141333333D3ADAB58416666666663BD214133333393ADAB58419A99999986BD21419A999959AEAB58419A9999999CBD21419A999959AFAB5841CDCCCCCCB5BD21419A999919B1AB584133333333CCBD21419A9999F9B2AB5841CDCCCCCCE1BD21419A999979B4AB584100000000F5BD2141CDCCCC4CB5AB58413333333328BE2141666666C6B6AB5841CDCCCCCC3CBE2141000000A0B7AB58419A99999947BE214166666606B9AB58410000000050BE2141CDCCCC8CBAAB58413333333351BE2141666666C6BAAB58410000000066BE2141666666A6BCAB5841666666668CBE2141CDCCCC0CC0AB584133333333A4BE214133333393C1AB58419A999999B7BE214133333333C2AB584166666666D3BE2141CDCCCCCCC2AB584100000000F2BE214166666626C3AB58416666666609BF214166666606C4AB5841666666661DBF214166666666C5AB58419A99999932BF21419A999959C7AB58419A99999945BF2141CDCCCC4CC9AB5841CDCCCCCC53BF214166666626CBAB5841CDCCCCCC9CBF21419A999919C5AB584166666666BEBF2141CDCCCC4CC2AB584100000000DFBF2141000000A0BEAB5841000000001FC02141CDCCCCECB5AB5841CDCCCCCC55C0214100000000AEAB5841666666669BC021419A9999F9A3AB584100000000A0C02141CDCCCC6CA3AB5841CDCCCCCCA1C021419A999939A3AB5841CDCCCCCCA8C021419A9999D9A1AB584166666666B5C02141000000009FAB5841CDCCCCCCCDC021413333331399AB58419A999999E7C02141CDCCCCCC93AB584166666666F2C02141000000E091AB58416666666601C12141333333F38EAB5841CDCCCCCC08C12141CDCCCCAC8DAB5841666666660EC121419A9999198DAB58416666666663C12141666666869AAB584100000000A3C12141333333B3A4AB58419A999999DBC12141000000C0ADAB584133333333DFC1214133333353AEAB58419A999999E6C1214133333393AFAB58413333333377C22141000000A0A3AB58413333333320C3214133333313A9AB5841CDCCCCCC1EC321419A9999999DAB58410000000034C321419A9999F99CAB58416666666654C32141333333139CAB58413333333368C32141666666869BAB58413333333382C321419A9999999DAB584133333333C7C3214166666626A3AB584133333333BFC321413333337399AB584166666666CCC321419A99995999AB5841CDCCCCCCD7C321419A99993999AB584100000000E9C321419A99991999AB5841CDCCCCCCDFC321410000000080AB58410000000067C421416666664679AB58410000000088C42141000000C05CAB5841000000009CC42141666666C65AAB584133333333BFC42141333333B356AB5841CDCCCCCC16C52141CDCCCCAC4FAB5841666666662EC52141CDCCCC8C4FAB58413333333364C52141000000404EAB584133333333A3C521419A9999194CAB584166666666BCC52141666666C64AAB584100000000C6C52141333333534AAB584100000000D7C521410000004049AB58419A999999ECC521416666664647AB5841CDCCCCCC01C62141CDCCCC0C44AB58413333333320C62141000000203EAB5841CDCCCCCC36C62141666666863BAB58410000000048C621419A9999793AAB5841333333337BC62141CDCCCCAC35AB58419A999999A7C62141333333B32FAB584100000000ECC62141333333D327AB58416666666610C72141666666A624AB5841666666661BC72141666666A624AB58416666666634C72141000000C016AB58419A99999907C82141333333B314AB58410000000053C821416666662606AB58416666666655C82141000000C005AB58419A999999D8C82141CDCCCCEC02AB5841CDCCCCCC86C821419A999999EEAA5841CDCCCCCC8CC8214100000060EDAA58416666666699C821419A999919ECAA5841CDCCCCCCA4C8214166666666EAAA5841CDCCCCCCB1C82141666666E6E7AA584133333333BFC821419A999959E6AA584166666666D2C8214100000040E4AA584100000000DFC82141CDCCCC8CE2AA584166666666EBC8214100000000E0AA58413333333397C821419A999959CCAA58410000000025C9214100000060B5AA58419A99999932C92141333333D3B1AA58413333333342C921419A999919AEAA5841CDCCCCCC4CC9214100000040ABAA58410000000059C92141333333D3A6AA58416666666662C92141333333B3A2AA584100000000BAC9214100000040A1AA584100000000C1C921419A99995998AA58410000000023CA2141666666C67CAA58419A9999994ACA21419A99993975AA5841CDCCCCCCCBCA21419A99995972AA584100000000B7CA2141CDCCCCEC66AA584100000000F8CA21419A9999D965AA584166666666FACA2141CDCCCC6C60AA5841CDCCCCCC66CB21419A99997960AA5841666666664FCB2141000000004CAA58419A9999998ECB2141333333F33DAA58410000000052CB21416666664635AA5841CDCCCCCC29CB21413333339331AA5841CDCCCCCC32CB21413333339322AA58419A9999993CCB2141CDCCCC4C21AA58416666666640CC21416666660622AA584133333333AECC2141CDCCCC6C1FAA58419A9999991ACD2141333333D308AA58413333333369CD2141666666C6F4A9584100000000DACF2141CDCCCC2CAEA95841666666663DD0214133333313A9A95841CDCCCCCCFDD02141CDCCCCACA9A9584166666666FCD021419A999919A8A95841CDCCCCCCFAD0214166666686A4A9584100000000FAD02141CDCCCCCCA1A9584100000000F6D021419A9999399FA958419A999999EED02141333333D39CA9584100000000E6D02141CDCCCC0C9BA95841CDCCCCCCD0D02141666666E697A9584133333333CCD021419A9999D995A958419A999999CED02141CDCCCC8C94A9584133333333D6D021416666666692A9584133333333DED02141000000A090A958419A999999EED02141666666668CA9584100000000F7D02141000000C089A958419A999999FBD02141CDCCCC2C87A95841CDCCCCCCFBD02141666666C684A9584133333333F8D02141666666A682A9584133333333F1D02141333333B381A9584100000000DFD021419A9999B980A95841CDCCCCCCD3D021416666662680A9584166666666CED021419A9999997FA9584100000000C7D02141333333D37DA9584133333333BDD02141CDCCCCAC7BA9584133333333BCD021419A9999397AA95841CDCCCCCCBFD02141666666A678A95841CDCCCCCCC6D02141CDCCCCCC77A9584133333333D2D021410000000077A9584133333333DFD021410000002076A9584166666666E8D02141000000A074A9584133333333E6D02141CDCCCC4C73A958419A999999E4D02141666666E671A958419A999999EAD02141666666666FA95841CDCCCCCCEFD021419A9999996CA9584100000000F3D021419A99999969A958419A999999F1D021416666666665A9584100000000E9D02141CDCCCCCC61A9584100000000D4D02141CDCCCC0C5DA9584133333333C5D02141333333B35AA9584133333333BBD02141000000C059A9584166666666B8D021413333339359A9584100000000A7D021419A9999B958A958410000000083D021410000000058A958419A99999959D021419A9999D956A958419A99999949D02141CDCCCCAC55A958410000000049D02141666666A655A958419A9999993DD021410000002054A95841000000002CD021416666664650A958416666666612D021413333333349A9584100000000FDCF21413333335343A958419A999999F0CF2141CDCCCCCC40A9584166666666CCCF2141CDCCCC0C3EA9584100000000CBCF2141666666C63DA958419A999999CACF21419A9999193CA9584133333333D5CF2141666666063AA958419A999999DFCF21419A9999B937A9584133333333F3CF21413333335331A958419A99999917D02141CDCCCC2C27A958410000000018D02141666666C626A958413333333319D02141333333B325A958410000000017D02141CDCCCCAC24A958413333333314D021419A99993924A9584100000000FACF21416666660622A95841CDCCCCCCC5CF21419A9999191DA95841000000008CCF21413333331319A95841333333335FCF2141CDCCCC4C15A95841333333334DCF21410000008013A958419A99999948CF2141000000E012A958413333333342CF2141000000E011A958419A9999993ECF21419A99991910A95841CDCCCCCC3ECF2141000000200EA958410000000045CF2141666666A60BA95841333333334ACF2141CDCCCCEC08A95841000000004ACF2141CDCCCC4C06A958419A99999941CF21413333335303A95841000000003ACF21419A99999901A958419A99999937CF2141CDCCCC0CFFA858413333333338CF2141CDCCCC6CFEA85841000000003BCF214133333353FDA858419A9999993ECF2141000000C0FAA85841333333333CCF214166666606F9A85841CDCCCCCC32CF214166666646F8A858419A99999929CF214100000040F8A858410000000014CF214166666686F8A85841CDCCCCCC0CCF214166666666F8A858419A99999904CF21419A9999B9F7A858416666666600CF2141CDCCCC6CF6A8584166666666F8CE2141CDCCCCACF2A8584166666666EFCE214133333353EFA8584100000000E6CE2141CDCCCCCCEDA858419A999999D1CE214166666626ECA8584133333333BECE214100000000EAA8584100000000B9CE21419A9999F9E8A8584100000000B6CE2141333333D3E6A858419A999999B2CE214133333333E5A8584166666666A7CE2141666666C6E3A85841666666667ECE214100000000E1A85841000000004ECE2141CDCCCC8CDEA858419A9999992ACE2141CDCCCC4CDCA85841CDCCCCCCFDCD214166666626DAA858419A999999D9CD21419A999939D8A858419A999999BDCD21419A9999B9D5A8584100000000AECD21419A999959D3A858419A999999A0CD2141333333D3D0A85841CDCCCCCC9CCD2141333333F3CEA85841333333339DCD2141333333D3CCA85841333333339FCD21419A999999CAA858413333333399CD214100000040C7A858419A99999982CD214100000060C2A858410000000057CD214100000040BDA858416666666622CD21419A9999F9B8A8584166666666FECC2141666666E6B5A8584133333333FBCC21419A9999F9B4A858419A999999FACC214166666626B3A858419A999999FECC214100000080B1A858416666666612CD214100000020B0A858410000000043CD2141666666C6AFA85841333333336CCD214100000060B0A858419A99999997CD214133333393B0A8584100000000AFCD214166666666B0A8584100000000C0CD214133333313B0A858419A999999CACD2141CDCCCC2CAFA8584100000000D1CD214100000020AEA8584166666666CFCD214166666666ABA8584133333333BACD21419A999959A6A85841CDCCCCCC84CD2141000000209EA85841CDCCCCCC5BCD21419A99999997A858416666666632CD21410000000091A858419A999999FECC2141333333D388A85841CDCCCCCCD3CC2141333333B383A8584100000000A6CC2141000000207FA85841CDCCCCCC8ACC2141CDCCCC2C7BA858416666666683CC21413333337378A85841000000007ECC21413333331375A85841000000007CCC2141CDCCCCAC71A85841CDCCCCCC7ACC2141333333736DA85841000000007DCC21413333333369A85841666666667FCC2141CDCCCCEC67A85841CDCCCCCC83CC2141666666C665A85841CDCCCCCC8BCC2141CDCCCCCC62A858410000000095CC2141666666A65FA858419A9999999ACC2141333333535CA858419A99999917CD21419A9999195CA858416666666673CE2141CDCCCC6C3EA858416666666662CE2141666666E63AA858413333333352CE2141666666A636A858419A99999944CE21413333333332A85841333333333CCE2141CDCCCCEC2EA85841333333333ACE2141CDCCCC8C2CA85841666666663CCE21416666662628A85841333333334CCE21413333333327A858413333333360CE2141000000C025A85841000000007FCE2141666666E623A858419A999999C6CF21419A9999F933A8584133333333B1CF2141CDCCCC6C30A858410000000098CF2141333333B32BA858416666666687CF21410000008028A858416666666671CF21410000002024A858410000000063CF21419A9999791FA85841000000005CCF2141666666261AA85841CDCCCCCC58CF21410000000016A85841CDCCCCCC52CF2141333333B312A85841666666664BCF21413333335310A85841CDCCCCCC42CF2141CDCCCC4C0DA858419A9999993DCF21410000002009A858416666666633CF21416666664603A858416666666622CF214100000060FEA75841333333330DCF21419A999979F8A7584133333333FDCE214100000080F3A7584100000000DDCE2141CDCCCC8CECA7584133333333C5CE2141000000A0E7A75841CDCCCCCC8BCE214100000060DBA75841333333337BCE214100000060D8A75841333333336ACE214166666646D5A758419A9999994FCE21419A999939D1A758410000000036CE214100000080CDA758416666666617CE2141CDCCCC6CC9A75841CDCCCCCCFACD214100000080C5A7584100000000DFCD214133333373C2A75841CDCCCCCCC4CD2141666666A6BFA75841CDCCCCCCA5CD214133333333BCA758413333333387CD2141CDCCCC0CB8A75841000000006BCD2141000000A0B4A758413333333355CD21419A999959B0A75841333333333ECD21419A999939ABA758410000000029CD21419A999959A6A75841CDCCCCCC14CD214100000040A2A7584133333333FECC21419A9999599FA7584100000000DBCC2141333333939CA7584166666666B5CC21419A9999599AA758416666666690CC2141CDCCCCAC98A75841000000006ECC21416666664696A758419A9999994ECC21419A9999D993A75841000000002ACC21419A9999F990A758419A99999903CC2141666666A68EA7584100000000E3CB2141666666668CA7584133333333BECB21419A9999398AA758419A99999998CB2141CDCCCC8C87A75841CDCCCCCC7CCB21413333331384A75841666666665DCB21413333331380A75841CDCCCCCC3FCB2141000000407DA758419A9999991BCB21419A99999979A75841CDCCCCCCFFCA21413333335376A75841CDCCCCCCE8CA21413333333373A7584133333333CACA2141CDCCCCCC6FA7584100000000B3CA2141666666266DA75841000000009BCA2141CDCCCCCC6AA758410000000079CA2141333333D366A758416666666669CA2141CDCCCC8C65A75841666666664FCA21419A9999F962A758413333333338CA21410000004060A758410000000015CA2141000000005DA75841CDCCCCCCEAC921419A99991959A7584166666666D3C921419A9999F956A7584100000000B7C921416666666654A758416666666695C921416666668650A758410000000081C92141666666A64DA75841666666666FC92141333333F34AA758413333333367C92141333333D349A758419A99999972C921410000008044A75841CDCCCCCC78C921419A99995940A758410000000078C921419A9999F93CA758413333333370C92141666666C638A758410000000057C921410000004034A75841666666663BC92141666666862FA758413333333319C92141666666862DA7584133333333F9C821419A9999792DA7584166666666D0C82141666666A62DA75841CDCCCCCCBBC82141333333732DA7584100000000ABC821419A9999992CA758419A99999992C82141000000C029A758419A9999998BC82141333333F325A758413333333389C82141CDCCCCEC20A758419A9999997EC82141000000001CA758419A99999973C821410000000015A75841333333336CC82141666666260FA758416666666661C821419A99995907A758419A9999994DC821416666660600A75841333333333DC8214100000040FCA65841666666662FC8214166666606F9A65841CDCCCCCC16C82141CDCCCCACF4A6584133333333F7C72141666666E6EEA6584166666666DDC72141666666A6E8A6584100000000CFC721419A9999D9E2A65841CDCCCCCCBFC72141CDCCCC8CDCA6584133333333B0C72141000000E0D7A65841000000009BC72141333333F3D1A658416666666685C721419A9999D9CCA65841666666666CC7214133333313C7A65841CDCCCCCC60C7214166666666C3A658416666666654C72141333333F3BFA658419A99999942C7214133333373BAA658413333333336C7214100000000B5A65841666666662EC72141CDCCCCACB0A658416666666625C72141333333F3ABA658410000000022C72141333333B3A6A65841CDCCCCCC1CC72141CDCCCCCCA0A65841333333331AC72141666666869BA65841333333331CC721419A99997996A65841CDCCCCCC1FC72141000000C091A65841CDCCCCCC2AC72141000000A08DA658410000000040C72141333333D389A65841CDCCCCCC52C721416666666686A65841CDCCCCCC6CC721410000006080A658410000000079C72141000000607BA658419A9999997FC721413333333376A658416666666687C72141CDCCCC4C6FA65841666666668AC721416666666669A658419A99999988C721416666666661A658410000000085C72141333333F35BA65841CDCCCCCC79C721410000004057A65841CDCCCCCC6BC72141666666E651A65841000000005DC72141666666064DA65841333333334AC721416666664647A658419A99999937C72141CDCCCCCC43A658419A99999908C721419A9999393DA6584166666666EBC62141333333333AA65841CDCCCCCCCAC621410000000037A6584166666666A2C62141CDCCCC8C33A658413333333377C62141CDCCCC6C31A658419A9999995AC62141333333532FA658413333333339C621419A9999192CA65841333333331DC621410000002029A658419A99999908C62141CDCCCC2C26A6584100000000F7C52141CDCCCC8C21A658419A999999F3C521419A9999791CA658416666666678C521419A9999D906A65841666666663FC52141333333530CA658410000000068C42141333333B3E5A558410000000033C42141666666C6DEA558419A99999937C42141CDCCCC8CDAA55841CDCCCCCC3FC42141CDCCCCCCD6A558410000000094C3214166666666CBA558410000000069C3214100000020D4A55841CDCCCCCCACC22141CDCCCC2CC0A558419A9999997AC221419A999979C6A55841CDCCCCCC46C221419A9999B9C1A55841CDCCCCCC9EC121419A999919C6A558419A99999991C1214166666686C4A558416666666685C12141CDCCCC0CC3A55841333333332BC02141000000A096A55841CDCCCCCC41C021419A9999B993A55841000000004FC02141CDCCCCCC91A55841000000005CC02141333333B38FA55841CDCCCCCC69C02141666666E68CA558419A9999997AC021419A9999798AA55841333333338BC02141666666A688A55841000000009EC021419A99993987A5584133333333AFC02141CDCCCC2C86A5584133333333C4C021419A99995985A5584166666666D7C02141CDCCCCAC84A5584100000000E9C02141000000E083A558419A999999FDC02141CDCCCC8C82A558413333333314C12141000000C080A55841CDCCCCCC2EC12141333333337EA558416666666646C12141000000807BA558419A9999995CC121416666664679A55841666666666BC121413333339377A55841666666667BC121416666664676A558413333333390C12141000000E074A558419A999999A3C121413333339373A55841CDCCCCCCB5C121416666666672A558419A999999C5C121419A99995971A558419A999999D4C121413333339370A5584166666666E1C12141CDCCCC2C70A558419A999999F6C12141666666E66FA55841000000001AC22141000000A06FA55841CDCCCCCC32C22141000000406FA55841CDCCCCCC4AC22141666666E66EA55841000000005CC22141CDCCCC6C6EA55841333333336FC22141CDCCCCAC6DA558419A9999997DC22141CDCCCCAC6CA55841CDCCCCCC89C22141000000606BA55841CDCCCCCC97C221410000006069A558419A999999A3C22141666666A666A5584166666666AAC22141000000C064A558419A999999B2C22141CDCCCC2C64A55841CDCCCCCC20C32141000000203CA558416666666669C32141000000C026A558413333333381C321419A99997921A558410000000081C321419A9999991EA558416666666686C321413333331318A55841333333339AC321419A9999B913A5584100000000B7C32141666666E611A55841CDCCCCCCF0C32141000000C010A558413333333327C421413333337310A55841333333331CC421419A99993902A5584166666666F2C321410000008001A558419A999999F8C32141000000A0F5A45841CDCCCCCC54C42141666666C6F3A45841CDCCCCCC28C42141CDCCCC4CD9A458413333333327C42141666666C6D6A458413333333322C4214133333313D4A458410000000020C421419A999939D0A45841666666661FC4214166666686CDA45841CDCCCCCC22C421419A999959CBA458413333333320C4214133333313C8A45841333333331FC42141CDCCCCACC5A458410000000022C4214166666666C4A458410000000022C42141333333F3C1A45841000000001EC421419A999979BBA45841CDCCCCCC1CC4214166666646B8A458419A9999991EC42141CDCCCCCCB5A45841CDCCCCCC1AC421419A9999B9B3A458419A99999912C421419A999999B1A45841666666660EC42141CDCCCC6CAEA458419A9999990CC42141333333D3AAA45841333333330CC42141666666C6A7A45841000000000BC4214100000020A5A458416666666607C42141666666E6A2A458419A99999907C421419A999939A1A45841333333330DC42141666666E69DA4584133333333FEC32141CDCCCC0C94A4584133333333CEC32141666666E68AA4584100000000B7C321410000006081A45841000000007DC321410000006074A458419A99999974C321410000000073A45841666666665EC32141CDCCCC4C70A458413333333356C32141666666666FA458419A9999994CC32141CDCCCC2C6EA45841CDCCCCCC38C32141333333736CA458419A99999926C32141666666266BA45841666666661CC32141CDCCCC6C6AA458413333333310C32141666666C669A45841CDCCCCCC00C32141333333B368A458419A999999F2C221419A9999D966A45841CDCCCCCCEDC221413333333366A45841CDCCCCCC23C32141333333135AA4584166666666A9C22141000000C034A45841333333336DC22141CDCCCC4C32A4584100000000F6C12141CDCCCC2C3BA458419A999999A1C12141000000002AA4584100000000AEC12141666666461DA4584166666666B5C12141666666261CA45841CDCCCCCCB6C12141333333B31AA4584166666666B6C121413333339319A4584133333333B7C121416666664616A4584100000000BDC121419A99995913A4584166666666CAC12141666666E60FA4584133333333D3C12141000000200DA458419A999999D8C12141000000E008A4584166666666DBC121410000000004A458419A999999DAC121410000006000A4584133333333DCC1214100000020FDA35841CDCCCCCCE0C12141CDCCCC2CFAA3584133333333ACC02141666666260BA45841CDCCCCCC8AC02141CDCCCCAC02A458419A99999954C021416666666604A458419A9999991DC021413333333311A458419A99999906BF21419A9999791BA458413333333388BE214166666686EBA3584166666666C7BD2141CDCCCCEC0BA45841333333331EBE21419A9999790BA45841333333334FBE21416666668616A4584166666666C7BD2141CDCCCC4C23A45841CDCCCCCC3CBD21419A99991924A45841666666663CBD21416666664622A458419A99999939BD2141CDCCCCEC20A45841666666662BBD2141CDCCCC6C1EA458416666666614BD2141666666661BA45841CDCCCCCCE9BC21419A9999B916A4584100000000D9BC21419A99997915A4584166666666BDBC2141333333B314A458413333333367BC2141666666A612A45841333333331ABC2141CDCCCCCC10A45841CDCCCCCCB7BB2141666666660EA458410000000094BB2141666666C60DA458413333333386BB2141000000400DA45841CDCCCCCC79BB2141CDCCCC2C0FA458419A99999963BB2141000000A011A458419A9999994CBB2141CDCCCCAC14A458416666666630BB21410000002018A45841000000001DBB2141CDCCCC4C1BA45841CDCCCCCCFFBA21419A99999920A458419A999999CCBA21419A9999592AA4584100000000A1BA2141CDCCCC0C32A458419A9999997FBA21419A99997938A458410000000080B92141666666665AA45841CDCCCCCC43B921419A9999B956A4584166666666B0B921410000006041A45841000000006AB92141333333733CA4584100000000CCB821419A99991958A45841333333338BB72141333333F346A458410000000061B72141666666E664A458419A9999994BB72141CDCCCCEC6CA45841333333332FB721419A99997976A458413333333323B72141CDCCCC4C7BA458413333333311B721419A9999F981A45841CDCCCCCCFEB621410000002088A4584133333333F2B62141666666068CA4584100000000E4B52141CDCCCC4CA6A45841666666664FB52141CDCCCC2CB9A4584100000000F7B4214100000040D2A4584166666666D0B4214166666646E6A45841666666669BB321419A9999D9DCA45841CDCCCCCC55B3214166666606DAA45841666666662DB3214133333373DAA458413333333302B3214133333393DBA45841CDCCCCCCDCB2214100000080DEA4584133333333B7B22141CDCCCC8CDEA458416666666680B221419A999939DEA45841CDCCCCCC2CB221419A999999DCA45841666666660CB22141666666C6DBA458419A999999AEB12141CDCCCC8CD6A458419A99999968B12141333333F3D1A458419A9999993BB121419A9999B9CEA458413333333318B12141333333F3CBA4584133333333F0B021419A999939C8A4584133333333B3B0214133333373C2A45841000000005CB0214166666646BAA458416666666626B0214133333393B4A4584100000000F2AF2141666666A6AEA4584166666666BEAF21419A9999F9A7A4584133333333A3AF2141333333B3A2A45841666666668EAF2141000000C09DA458419A99999975AF21410000004097A458419A99999966AF21416666668693A458413333333358AF21416666660691A458413333333343AF2141000000208FA458413333333327AF2141333333D38DA458413333333305AF21419A9999B98CA4584133333333E3AE2141CDCCCC2C8CA458419A999999BDAE2141666666C68BA4584133333333BBAE2141000000C08BA45841CDCCCCCCA9AE2141CDCCCC4C8BA45841000000009EAE2141666666E68AA458413333333399AE2141CDCCCCEC8BA458419A99999995AE21419A9999B98CA45841CDCCCCCC8BAE2141333333F38FA45841CDCCCCCC7DAE2141666666C694A458419A99999978AE21419A99995996A458413333333376AE2141CDCCCC0C97A458416666666660AE2141000000409BA45841333333333BAE214133333313A1A45841666666661CAE21419A999979A6A4584100000000E9AD2141000000C0B0A458419A999999E5AD214166666606B1A458419A999999D7AD214166666606B1A458416666666694AD214100000060B0A458419A99999966AD214100000040ECA45841666666661BA82141000000E0CFA45841000000001CA82141333333F3D0A45841CDCCCCCC16A82141CDCCCC2CD9A458410000000018A8214133333333E0A458416666666619A82141CDCCCCECEAA458419A9999991DA8214166666686F7A45841666666661CA821416666664601A558413333333315A821410000002009A55841CDCCCCCC0DA821419A9999B90CA558416666666608A82141666666060EA55841CDCCCCCC00A82141000000000FA5584166666666F6A72141000000C00FA5584133333333EAA72141CDCCCCCC0FA5584100000000D8A72141CDCCCC4C0FA55841CDCCCCCCC4A72141000000C00EA5584100000000BAA72141000000A00EA558419A999999B1A72141333333F30EA558419A999999A7A72141666666A60FA5584166666666A1A72141CDCCCCCC10A55841CDCCCCCC9AA721413333335313A55841666666668FA721419A9999F919A558416666666686A72141000000A01EA558413333333381A72141CDCCCC4C20A558419A9999997CA72141666666E620A558413333333378A721413333331321A558416666666672A721413333335321A558410000000063A721410000002021A55841CDCCCCCC24A72141000000001FA5584100000000C0A62141333333531BA558419A9999994EA621419A99993917A5584166666666F3A521413333339313A558419A999999C8A521419A99995936A55841CDCCCCCC8CA52141CDCCCC0C32A55841CDCCCCCC51A52141000000202FA5584166666666EFA42141CDCCCC2C2CA558419A999999AAA421410000004028A558416666666675A421413333333325A55841333333331BA421419A9999B91EA558419A999999E0A32141333333731AA5584100000000DBA32141666666061AA5584166666666B4A321410000002016A55841CDCCCCCC92A321416666668611A55841666666664DA32141CDCCCC4C0FA55841CDCCCCCCEBA22141333333130CA558413333333398A221419A9999190BA55841CDCCCCCC57A221416666666608A558419A99999930A22141CDCCCCCC04A558419A99999918A2214100000060FEA458419A999999FDA1214166666626F4A4584166666666E9A12141CDCCCC4CEBA4584166666666D5A1214100000080E7A4584166666666B0A12141666666A6E4A458410000000064A12141666666C6D8A458410000000053A1214133333313D4A458413333333323A12141CDCCCCECDBA458413333333378A02141CDCCCC4CD2A45841666666664BA02141000000A0CDA458410000000018A02141CDCCCCECC9A458419A999999D29F2141000000A0C5A4584166666666CA9F214166666606C5A4584166666666C49F214100000060C4A458419A999999BC9F2141CDCCCC0CC3A45841CDCCCCCCB49F2141333333D3BFA4584100000000A59F2141666666A6B2A45841CDCCCCCC9B9F21419A9999B9A7A4584166666666999F214100000000A6A458419A999999939F21419A9999F9A4A45841666666668F9F21419A999999A4A458419A999999D29E21419A9999F999A45841CDCCCCCC429E2141000000209BA458419A999999979C2141000000E0A0A4584100000000E79B2141CDCCCCEC9CA45841666666667D9B2141CDCCCC0C99A45841CDCCCCCC259B2141666666E690A45841CDCCCCCC3D9B2141666666C68DA45841666666664D9B2141000000A08BA4584100000000599B2141000000A086A458419A999999629B2141666666E681A458419A999999729B21419A9999397FA4584166666666979B2141000000607DA4584166666666C89B2141666666C67DA4584166666666DB9B2141CDCCCC0C7DA4584133333333EA9B2141333333B379A4584166666666F19B21416666664676A4584100000000EF9B2141000000E072A45841CDCCCCCCE59B2141CDCCCC8C6DA458419A999999DB9B21416666664668A458419A999999CD9B21410000002064A458419A999999B79B2141666666E660A4584166666666A29B2141CDCCCCCC5EA45841000000007E9B21419A9999795CA45841666666666C9B2141CDCCCC4C5AA4584100000000639B21413333331357A458419A999999629B2141CDCCCC4C54A45841000000006D9B2141000000C051A45841666666667F9B21416666660650A45841CDCCCCCCFA9B21419A9999994DA4584100000000259C21419A9999194CA45841CDCCCCCC3E9C21416666668649A4584166666666499C2141000000A045A4584166666666479C21419A9999D938A45841000000003C9C2141666666C632A4584166666666299C2141CDCCCCEC2CA4584100000000149C2141CDCCCC6C29A45841CDCCCCCCF29B21410000000026A458419A999999DF9B21419A99993923A45841CDCCCCCCD49B2141000000601FA4584166666666DA9B2141333333331CA4584133333333F39B2141CDCCCC8C18A458419A9999990B9C2141CDCCCC0C14A45841000000000A9C2141333333930EA458419A999999E79B2141666666C6FDA3584133333333E59B2141CDCCCCACF6A3584133333333F19B2141CDCCCC0CF1A3584100000000109C214100000040E9A3584100000000239C214133333353E4A3584133333333449C2141666666A6DDA35841CDCCCCCC4E9C2141000000C0D8A358419A999999599C214166666666CFA3584133333333559C21419A9999D9CAA358419A9999995B9C21419A999979C4A3584133333333719C2141CDCCCCACBFA3584166666666AC9C214133333313B7A358419A999999C89C2141CDCCCC8CB0A358419A999999D39C2141CDCCCCACACA3584100000000F89C214166666626A1A35841CDCCCCCC199D2141333333B39CA358419A999999109D2141CDCCCCCC9AA3584166666666E79C2141000000E09AA35841CDCCCCCC069D21419A9999198DA35841000000002B9D2141000000208CA35841333333334A9D21410000008084A3584166666666579D21419A99991979A358419A999999769D2141333333F36EA358419A999999629D2141666666E66BA3584133333333459D2141CDCCCC0C70A358419A999999389D2141666666C671A35841666666661F9D21410000008074A35841666666660D9D2141CDCCCC8C75A3584100000000FD9C21419A9999F975A3584100000000EC9C21419A99991976A3584133333333CD9C21416666662676A3584100000000C09C2141CDCCCC4C76A358419A999999AC9C2141666666E676A3584100000000939C2141CDCCCCAC78A3584100000000659C21419A9999B97CA358419A999999509C2141333333F37DA358419A999999419C2141CDCCCC8C7EA35841000000002A9C2141000000407FA35841333333331D9C21419A9999F97FA3584133333333129C21416666660681A35841CDCCCCCCFF9B21416666668682A35841CDCCCCCCF49B21416666662683A358419A999999E89B2141CDCCCC6C83A3584166666666D79B21416666660683A358419A999999C79B2141000000E081A35841CDCCCCCCB89B21410000008080A3584133333333AC9B21419A9999597FA35841666666669C9B2141333333737EA35841666666668E9B21419A9999F97DA358419A999999849B2141666666067EA3584166666666779B2141CDCCCCAC7EA3584133333333659B2141333333D380A358419A9999995A9B21419A99993983A35841CDCCCCCC539B21410000002086A3584100000000549B21419A9999D988A3584100000000559B2141CDCCCC0C8CA358419A999999539B2141CDCCCC8C8DA35841666666664F9B21419A9999798FA35841CDCCCCCC479B21419A9999D990A35841333333333F9B2141CDCCCCCC91A3584133333333399B2141CDCCCC4C92A35841CDCCCCCC259B2141333333F392A35841CDCCCCCC139B2141000000C093A35841333333330D9B2141CDCCCC6C94A35841333333330A9B21413333331395A3584166666666039B2141CDCCCC6C96A358419A999999F89A21416666668697A358419A999999E69A2141CDCCCC0C98A3584166666666DA9A2141000000E097A35841CDCCCCCCD29A2141CDCCCC4C97A35841CDCCCCCCCB9A21413333337395A3584100000000C79A21419A9999F993A3584166666666BF9A2141000000E092A35841CDCCCCCCAE9A21416666662692A35841333333339E9A21413333331392A358419A999999949A21419A99995992A358419A999999869A21419A99991994A35841333333337D9A21413333333395A35841CDCCCCCC709A2141CDCCCCEC95A35841000000005A9A21413333335396A35841CDCCCCCC499A2141333333F396A3584166666666429A2141CDCCCCEC97A358419A999999409A2141CDCCCCCC98A3584133333333409A2141333333739AA358419A9999993C9A2141666666E69BA3584133333333349A2141333333139DA35841333333332D9A2141000000809DA3584100000000249A21419A9999B99DA3584100000000189A2141000000C09DA3584133333333DA992141333333939BA3584133333333BC992141333333F399A35841CDCCCCCC969921413333339397A358419A9999997D9921419A9999B995A3584133333333679921416666666694A358419A9999994F992141000000A093A3584133333333EA9821416666668690A3584100000000BE982141000000808FA3584133333333A49821419A9999598FA358419A99999993982141333333538FA35841CDCCCCCC83982141333333938EA35841CDCCCCCC7B982141000000808DA358413333333378982141CDCCCCEC8BA35841CDCCCCCC77982141333333938AA358419A99999977982141666666E688A35841CDCCCCCC719821413333339386A358419A99999967982141333333F384A35841000000005C9821419A9999D983A358410000000045982141000000C082A358419A99999932982141CDCCCC8C82A358410000000021982141666666A682A358419A99999906982141333333B383A35841CDCCCCCCFA972141333333F383A358419A999999F2972141CDCCCCAC83A358419A999999EB9721413333331383A358419A999999DF9721413333333382A358419A999999D19721419A9999B981A358419A999999C09721419A9999B981A3584133333333AF972141CDCCCC8C82A3584166666666A5972141666666E683A35841CDCCCCCCA1972141CDCCCC6C85A3584100000000A09721419A99995987A35841CDCCCCCC9B9721413333337389A35841CDCCCCCC95972141000000008AA35841333333338A972141000000608AA35841CDCCCCCC64972141000000408AA358419A99999943972141000000E089A35841666666663A972141CDCCCCEC89A3584133333333319721419A9999B98AA35841CDCCCCCC239721419A9999F98BA358410000000013972141333333138DA3584166666666FC962141333333338EA35841CDCCCCCCAF962141CDCCCCEC90A35841000000007B962141CDCCCCCC92A35841000000002C9621416666662696A358419A999999129621419A99991998A3584133333333FF952141CDCCCC0C9AA3584133333333F1952141CDCCCC8C9CA358419A999999D9952141CDCCCC6CA3A3584100000000D29521419A999999A5A3584166666666C995214166666686A6A3584133333333BE952141CDCCCCECA6A35841CDCCCCCCAD95214100000040A6A35841CDCCCCCC9C95214166666666A5A35841CDCCCCCC9295214100000040A5A358419A99999989952141000000A0A5A35841000000008495214100000060A6A35841666666667F952141CDCCCC0CA8A358419A9999997A9521419A9999D9A9A35841CDCCCCCC71952141CDCCCC6CACA35841CDCCCCCC69952141CDCCCC6CAEA35841666666664395214166666646B6A358419A9999994095214166666626B7A35841333333334195214133333393B8A35841CDCCCCCC519521419A9999B9C3A35841333333335395214166666666C6A3584166666666509521419A9999F9C7A358419A9999994A95214100000000C9A35841CDCCCCCC3C95214166666686CAA358419A999999B994214100000000D4A358410000000076942141666666C6D7A35841000000006394214100000040D8A35841333333335094214100000060D8A35841000000003F94214100000040D8A35841CDCCCCCC2D94214100000000D8A35841CDCCCCCC1F94214100000000D8A35841000000001394214166666666D8A358419A9999990C9421419A999939D9A3584133333333099421419A999999DAA35841666666660894214100000080DDA35841CDCCCCCC0794214100000040DFA3584133333333029421419A9999B9E1A3584166666666FC93214133333353E3A3584100000000EF93214133333333E5A3584100000000DF9321419A999979E7A3584100000000D2932141CDCCCC4CE9A3584100000000C39321419A999999EBA3584100000000B4932141333333B3EDA358419A9999999A93214100000040F0A35841000000007B9321419A999919F3A358410000000054932141333333D3F5A35841CDCCCCCC399321419A999999F7A358419A99999926932141333333B3F8A3584133333333149321419A9999B9F9A35841666666660793214133333353FAA3584133333333FA922141CDCCCC2CFBA3584133333333F292214100000000FCA3584166666666EA922141CDCCCCECFDA3584166666666E79221419A9999F9FEA3584100000000E1922141CDCCCC2C00A4584166666666C29221419A99997904A45841CDCCCCCCB19221410000002006A4584166666666A3922141666666A606A458416666666698922141000000A006A458413333333388922141CDCCCC0C06A4584133333333799221419A99991905A458413333333367922141CDCCCCEC03A458419A999999549221419A9999D902A458410000000047922141000000A002A458419A9999993A922141333333D302A45841666666662E922141333333D303A4584133333333259221419A99991905A45841CDCCCCCC209221410000006006A458419A999999199221419A9999D909A45841333333330E9221419A9999D90EA458419A999999089221416666660610A4584100000000FE9121416666660611A4584133333333F1912141666666A611A4584166666666E19121413333331312A4584100000000D69121416666660612A4584100000000B79121416666668611A4584133333333A3912141666666A611A4584100000000909121413333337312A458410000000082912141CDCCCC4C13A45841333333337A9121416666666613A458410000000064912141CDCCCCEC12A458419A99999952912141CDCCCC4C12A45841CDCCCCCC3D912141666666E611A458416666666626912141666666E611A458413333333314912141CDCCCC0C12A458413333333301912141333333B312A4584166666666E69021419A99997914A45841CDCCCCCCCE902141000000C016A4584166666666C49021416666664618A4584100000000B89021419A9999191BA458419A999999B3902141666666261CA45841CDCCCCCCA9902141000000201DA45841333333339F9021419A9999391DA458416666666671902141000000A01BA45841000000005D902141000000001BA45841CDCCCCCC53902141333333331BA45841CDCCCCCC4A902141000000801CA4584166666666439021419A9999F91DA45841CDCCCCCC3A902141000000C01EA45841666666662C9021419A9999591FA458410000000019902141666666861FA458419A999999F58F21419A9999591EA4584166666666E48F2141666666661DA4584100000000D78F2141666666461CA4584100000000D38F2141CDCCCC4C1BA4584166666666CE8F21410000004019A4584133333333C88F21413333333317A4584100000000C48F21410000004016A4584166666666B98F21419A99999915A458419A999999888F21419A99995914A45841666666667C8F21413333337313A458419A9999996D8F21416666668611A458419A9999993C8F21419A9999D90AA45841CDCCCCCC258F2141666666A608A4584133333333108F21410000000007A4584100000000FD8E2141CDCCCC4C06A4584100000000E78E2141CDCCCCEC05A4584100000000AA8E2141333333B305A458419A9999997F8E2141666666A604A4584166666666658E2141000000E003A45841CDCCCCCC458E2141333333D301A45841CDCCCCCC378E2141333333F3FFA35841CDCCCCCC2D8E21419A9999B9FDA358419A999999208E2141CDCCCC8CFAA3584166666666158E21419A9999F9F8A3584133333333088E2141CDCCCC0CF8A3584133333333F88D214133333373F7A35841CDCCCCCCD58D2141000000E0F7A3584166666666AA8D2141333333B3F8A358419A999999558D214133333373FAA3584133333333338D214133333393FBA35841CDCCCCCC138D214100000040FDA3584166666666F08C21410000002000A4584100000000D78C2141000000A001A4584133333333C08C21413333335302A4584166666666998C21419A9999D902A45841CDCCCCCC7D8C21416666668603A458419A999999708C21416666666604A458419A999999668C2141666666E605A45841CDCCCCCC648C21410000000007A4584166666666678C2141CDCCCC4C08A458419A9999996D8C2141666666460AA4584133333333728C2141000000E00BA4584100000000728C2141000000800DA458419A9999996C8C2141333333930EA4584100000000658C2141000000400FA4584100000000108C2141000000C011A4584100000000A88B21413333333314A45841CDCCCCCC1C8B21419A99993917A4584100000000F78A21419A99999917A45841CDCCCCCCEC8A21416666662617A4584100000000E58A21416666664616A458419A999999E28A2141000000A015A458419A999999DE8A2141666666C613A4584166666666DA8A21416666666612A45841CDCCCCCCCF8A21419A99995911A4584100000000C78A2141333333F310A4584166666666B88A21413333333311A45841CDCCCCCCAA8A2141333333F311A45841CDCCCCCCA58A2141CDCCCC8C12A45841666666669F8A2141333333B313A4584166666666978A2141666666A615A45841CDCCCCCC908A2141666666C617A4584100000000898A2141000000A01AA4584100000000848A2141333333D31BA4584100000000758A2141CDCCCC4C1EA45841666666665F8A21416666662620A4584100000000498A21419A99991921A4584133333333308A21416666668621A45841CDCCCCCC1B8A21413333333321A45841333333330B8A21416666666620A4584133333333038A21419A9999F923A45841CDCCCCCCFF8921413333331328A45841	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	01010000206A0800001272B5AEE1B52141333333A3B2A75841	190050000	Z	Allassac	1900500	19005	19	75	39
01060000206A08000001000000010300000001000000E7010000CDCCCCCCA1722341CDCCCCAC19C9584166666666A7722341000000A01EC958419A999999A3722341CDCCCCEC22C9584166666666947323410000008026C95841000000009F7323419A99997930C9584166666666A17323413333337353C95841CDCCCCCC537323410000008076C95841CDCCCCCC3A732341333333F3BEC95841666666669373234133333353C3C9584100000000F973234100000040C6C95841CDCCCCCC4D7423419A9999B9C9C95841CDCCCCCC4C752341666666E6C5C9584133333333647623419A999999C0C95841000000009D76234100000020B8C958419A999999F2762341CDCCCC6CABC9584133333333C8772341666666C68BC9584166666666DC772341000000408EC95841CDCCCCCCAD7823419A999999BDC958416666666652792341666666C6E2C9584100000000A5792341CDCCCC6CF5C95841CDCCCCCCCD792341000000E001CA584166666666007A2341333333D30BCA5841CDCCCCCCD57A2341CDCCCC4C41CA5841333333338F7B23416666660696CA5841CDCCCCCCB281234133333393C2CA5841CDCCCCCC75822341333333F3CCCA584166666666F283234166666646FCCA58410000000043842341CDCCCCCCFBCA58419A999999FD84234166666626F6CA58419A9999990A862341000000A0EACA58419A999999F886234166666666D1CA5841666666661988234100000060C3CA584100000000948923419A9999F9B3CA584100000000658A234166666646A7CA584166666666358B2341333333D391CA58419A9999992C8C23419A9999D96ACA584166666666058D2341CDCCCCAC3DCA584100000000208D2341CDCCCCCC36CA584100000000048D23419A9999D934CA58419A999999C58C23416666666630CA584166666666AA8C2341333333532ECA58419A999999998C2341333333D32CCA58419A999999888C23419A9999F92ACA5841333333337A8C2341666666E628CA5841CDCCCCCC6D8C2341666666C626CA58419A999999638C23419A99997924CA5841CDCCCCCC5B8C23416666660622CA584133333333538C23419A9999591ECA584100000000508C2341666666261DCA5841333333334C8C2341000000C01CCA584166666666528C2341000000E01ACA584100000000558C2341333333B319CA584133333333558C23413333339318CA5841CDCCCCCC538C2341000000A017CA5841666666664F8C23419A99991915CA584100000000238D2341333333B307CA5841000000002A8D234100000060F5C9584166666666318D2341CDCCCC4CE4C95841CDCCCCCC078D2341CDCCCCACDBC95841CDCCCCCCDE8C2341CDCCCC2CDCC9584166666666C08C23419A999919DCC95841000000009D8C2341CDCCCC8CDBC95841000000006E8C2341666666C6D9C95841CDCCCCCC3D8C234100000040D7C9584166666666268C2341666666A6D6C95841CDCCCCCC198C234133333353D6C9584166666666F48B234100000020D6C9584100000000E88B2341CDCCCCACD5C9584100000000C48B2341CDCCCC0CD3C95841666666666D8B2341666666C6CCC95841000000002F8B2341000000A0C8C95841CDCCCCCCE08A234133333313C4C95841CDCCCCCCAC8A23419A999959C1C95841666666667D8A234166666626BFC958419A999999498A23419A9999D9BDC958419A999999038A234133333393BCC95841CDCCCCCCC98923419A9999D9BAC95841333333339F89234133333313B9C958410000000075892341666666A6B6C95841CDCCCCCC3E8923419A999959B2C958419A9999992289234166666626B0C958416666666611892341333333D3AEC9584100000000FA882341666666C6ADC9584100000000ED88234133333373ADC9584133333333A9882341666666A6A6C958410000000076882341666666E69AC958419A999999578823419A9999D988C9584133333333568823410000004076C9584100000000BF882341333333336BC9584100000000E68C23419A99995901C9584166666666FB8D234100000080FEC858419A999999938D234133333353EEC858419A999999648D234133333373EDC85841CDCCCCCC728D234166666626D6C858419A999999908D23419A999999D5C8584100000000DF8D23419A999939C2C85841CDCCCCCCB58E2341333333B3B9C858419A9999995D8E23419A999999ADC85841CDCCCCCC468E2341CDCCCCACA6C8584166666666968E2341CDCCCCCCA0C8584100000000A18E23419A99995997C8584133333333DC8E2341CDCCCCCCA0C8584100000000FD8E2341CDCCCC8C9FC85841CDCCCCCCE48E23419A9999B997C858419A999999B18E23416666660692C8584100000000988E2341000000A08BC8584100000000628E2341CDCCCCAC89C858419A9999991D8E2341333333738BC8584100000000FD8D2341000000608FC8584100000000D88D23419A99999995C8584100000000A98D23410000000097C8584100000000848D23416666664696C8584100000000698D2341CDCCCC6C98C858419A999999568D2341000000009CC85841CDCCCCCC1A8D2341000000C0AAC8584100000000158D234166666646B0C85841000000003D8D2341333333D3BBC8584133333333238D234100000060BFC8584133333333F78C234133333393C2C8584100000000158D234100000000CCC8584133333333F98C234100000040D2C85841CDCCCCCCBC8C234166666626D6C858419A9999999D8C2341CDCCCCACD6C85841666666668E8C2341CDCCCC6CD3C8584100000000848C2341666666C6CDC85841CDCCCCCC758C23419A9999B9C7C858419A999999828C23419A999979C3C85841000000009F8C2341CDCCCC6CBDC8584166666666B48C234100000080B9C858419A999999788C23419A9999F9B0C858419A9999993F8C234133333373B0C8584100000000E68B2341666666E6AFC858419A999999E18B23419A999979ABC8584133333333E38B23410000006077C858419A999999D78B2341666666A65FC85841CDCCCCCC078C23410000006045C8584166666666F28B2341CDCCCC2C30C85841CDCCCCCCDD8B23413333337327C858419A999999DA8B2341000000401EC858419A9999992F8C2341000000000FC8584133333333638C2341666666860CC85841666666663A8C23419A99997909C8584100000000758C23416666666609C85841333333338D8C23419A9999F908C8584100000000A38C2341666666C607C858419A999999EC8C23416666666601C8584133333333028D2341CDCCCCECFEC7584100000000108D23419A999959FDC7584100000000358D234166666626F4C75841CDCCCCCC528D23419A999959EAC7584166666666738D2341000000E0DEC7584100000000768D234100000000DEC75841CDCCCCCC8D8D2341CDCCCC4CD4C75841CDCCCCCCA28D2341CDCCCC2CCAC7584100000000BE8D2341666666E6BCC7584133333333DA8D2341333333B3AFC7584100000000E38D2341CDCCCC4CABC7584166666666E88D23419A999999A8C7584133333333F08D234100000060A5C7584100000000F48D2341333333B3A3C7584166666666FD8D2341666666E69FC7584166666666158E23419A99993996C75841333333332A8E2341666666668CC75841CDCCCCCC3E8E23410000000084C75841000000004B8E2341666666C67FC758419A999999498B23419A9999F969C75841CDCCCCCC2A8B23413333333366C75841CDCCCCCC138B23419A9999D963C7584100000000DE8A2341000000C05FC7584166666666B28A23419A9999D95BC75841666666669E8A2341666666265AC75841333333335E8A2341CDCCCC2C52C75841333333334A8A23410000004043C7584100000000568A23410000006036C7584133333333A98A2341CDCCCCEC35C7584166666666B58A23419A99999934C7584166666666B98A23416666660633C7584166666666BB8A2341333333D32EC7584166666666BC8A2341000000A02CC7584133333333BB8A2341333333D329C758419A999999B48A23413333337326C7584166666666B78A23410000004024C75841CDCCCCCCB78A2341000000A022C75841CDCCCCCCB18A23413333335321C75841CDCCCCCCAA8A2341000000E01FC7584100000000A08A2341CDCCCC8C1BC7584133333333A38A23413333339316C758419A999999B38A2341CDCCCC8C11C75841CDCCCCCCD98A23413333333309C7584133333333088B2341CDCCCC6C00C758419A9999991A8B2341CDCCCC8CFAC6584133333333BD8A23419A9999D9FBC65841CDCCCCCC118B234133333313E8C6584133333333638A2341333333D3DEC658419A999999058A234100000040EBC65841CDCCCCCCE589234166666666E8C6584166666666C1892341CDCCCC4CDAC65841CDCCCCCC7389234100000060DAC658410000000099892341CDCCCC6CD1C65841CDCCCCCC7989234100000080B7C65841CDCCCCCC168A2341666666E6B3C6584100000000548A2341000000A0B9C6584166666666118A234100000080C0C6584100000000838A234133333393C4C658419A999999E98A234100000000C5C6584100000000478B2341333333D3B2C6584166666666E58B23419A999959B6C6584133333333DA8B2341CDCCCC4CB3C6584100000000D78B234100000060B1C6584166666666C78B2341000000E0ADC6584133333333AC8B234100000020A8C658419A9999999B8B2341CDCCCC8CA4C6584133333333D28B23410000008096C6584166666666EA8B2341CDCCCC4C90C658419A999999F08B23416666660690C65841666666663C8C2341CDCCCC6C94C65841CDCCCCCC7F8C2341CDCCCC8C98C65841666666668A8C23410000006091C65841CDCCCCCCBB8C23419A99999988C65841000000003D8D23419A9999797EC65841000000008A8E2341CDCCCCCC72C6584133333333C08E2341333333336DC6584100000000058F2341CDCCCC4C6DC6584133333333168F2341CDCCCC4C6DC65841333333331E8F2341666666A66CC65841333333331F8F23419A9999F96BC658419A9999991D8F23419A9999396AC65841666666661E8F23419A9999F968C6584166666666278F23410000004068C65841CDCCCCCC528F2341000000E066C6584133333333938F23419A99995967C6584133333333D08F2341CDCCCCAC66C658419A999999818F2341000000003AC658419A9999994F8F23413333339333C65841CDCCCCCC258F23419A9999792FC658419A999999108F23419A9999592DC6584166666666F58E23419A9999D92BC65841CDCCCCCCB28E23419A99995929C6584100000000878E23419A9999D928C6584133333333808E2341333333F31DC65841CDCCCCCC258E23413333335315C6584133333333B78D2341CDCCCCAC0CC65841CDCCCCCC708D23416666664605C65841333333332F8D2341333333B306C6584100000000CD8C2341CDCCCC0C0CC6584166666666CC8C23416666662603C65841CDCCCCCCE98C23410000004001C65841333333332D8D2341000000A0F1C55841666666663D8D23419A999999EEC55841000000003D8D23419A9999D9E9C5584133333333008D2341CDCCCC2CDCC558419A999999C18C23419A999939DFC55841CDCCCCCCAC8C23419A999959E1C55841000000005A8C234100000060D5C5584100000000068C234133333373D7C558419A999999AE8B2341CDCCCC0CDBC5584166666666F08A2341000000C0E5C55841CDCCCCCCD08A234100000000DEC55841333333339E8A234133333353D5C5584166666666088A23419A999979D5C55841000000000C8A23419A999959C8C5584100000000BB88234166666606CFC55841CDCCCCCCCA8823419A999919D3C558419A999999D4882341000000C0D6C5584166666666E488234166666686DCC5584133333333FE88234133333333E5C55841CDCCCCCC06892341333333F3E9C55841333333330A89234100000020F0C5584166666666088923419A999999F6C558416666666669882341333333F3FBC558410000000056882341CDCCCC2CF8C55841CDCCCCCC5B88234166666666F5C558419A9999994B882341333333F3F2C558419A9999993988234100000000EEC558413333333330882341333333F3EBC55841000000002F88234166666606E9C558419A99999925882341CDCCCC0CE7C55841333333331E88234100000040E5C55841CDCCCCCC0C88234100000020E3C558410000000007882341CDCCCCECE0C558416666666604882341000000E0DEC5584133333333FE87234100000060DBC55841CDCCCCCCF2872341666666A6D6C558419A999999E6872341333333D3D4C558419A999999DC872341666666A6D3C558419A999999D78723419A999979D2C5584166666666C187234166666626CEC558419A999999AF872341333333D3C7C558419A999999A38723419A9999B9C5C55841CDCCCCCC91872341CDCCCC6CC5C558413333333384872341CDCCCC0CC3C55841333333336287234166666666BDC558410000000052872341CDCCCCACBCC55841333333334287234100000040BAC55841333333333587234100000000B8C558419A99999933872341CDCCCC6CB6C558419A9999991F872341CDCCCC2CB4C55841333333330F872341333333D3B0C558416666666678862341CDCCCCCCB7C55841CDCCCCCC3C862341333333B3A9C55841CDCCCCCCA5852341333333F3A0C55841000000001A8523419A9999D99FC55841666666662A8423419A999919A5C55841333333338183234166666606AEC558419A99999913832341000000A0B0C5584133333333C48023419A99991980C558419A999999968023419A9999597CC55841000000007C802341000000E072C55841333333332C8023413333333374C558419A999999E27F2341666666C67BC55841CDCCCCCC9E7F23416666666680C55841CDCCCCCC157F23419A9999B989C5584133333333037F23419A9999398AC5584100000000C57D23416666668695C55841CDCCCCCCE77C2341CDCCCC8C9FC5584133333333947C234100000060A6C5584133333333CF7B23419A9999198CC558419A999999617B23416666668681C5584100000000EE7A23419A9999197DC5584166666666477A2341CDCCCC8C74C558419A999999617923416666664672C55841333333333F7923419A99991978C5584100000000467923416666664679C55841CDCCCCCC7C792341CDCCCC0C82C5584166666666327A234133333393ADC5584100000000137A23419A9999F9AFC55841CDCCCCCCC77923419A999959B6C558419A999999A279234100000040BEC5584133333333907923419A999999C5C558419A999999D87823419A999919B4C5584166666666BD78234133333393B6C55841CDCCCCCCAE782341CDCCCCACB8C5584100000000A6782341CDCCCCACBAC5584100000000A278234166666686BEC55841CDCCCCCC9B7823419A9999B9C1C55841666666667B78234100000060C8C55841CDCCCCCC707823419A9999D9CAC55841666666665678234166666666CEC558419A99999949782341000000E0CFC558419A999999347823419A999999D0C55841000000002C78234166666666D1C55841666666662778234166666666D2C55841666666661D7823419A999979D2C5584133333333167823419A9999B9D1C5584166666666FF772341666666E6D1C5584100000000F377234100000000D2C55841CDCCCCCCE977234133333353D1C5584166666666E177234100000020D0C55841CDCCCCCCD6772341CDCCCC8CCFC558419A999999C177234100000080CFC5584166666666B57723419A999979CFC5584166666666A5772341CDCCCCCCCEC558419A999999887723419A999939CFC55841666666667A77234133333353CFC55841000000006B7723419A999939CFC55841CDCCCCCC57772341CDCCCC8CCFC55841CDCCCCCC36772341CDCCCCCCD1C55841333333331F772341000000E0D2C55841CDCCCCCCFA76234100000080D6C55841CDCCCCCCF0762341CDCCCC8CD7C5584166666666ED76234166666626D9C5584166666666E476234100000020DBC5584100000000E6762341333333D3DCC558419A999999EC762341CDCCCC0CDEC5584133333333F6762341666666E6DEC558419A999999FA76234100000020E0C5584166666666FB7623419A999959E1C5584166666666F776234100000040E2C5584100000000F876234100000000E4C5584100000000F2762341CDCCCCACE5C5584166666666DF762341CDCCCC2CE7C55841CDCCCCCCD476234133333333E8C5584133333333CD762341CDCCCC6CE9C5584100000000C776234133333333EAC5584133333333BB762341CDCCCCACEAC5584100000000A27623419A999979EBC558419A99999992762341CDCCCC4CECC55841CDCCCCCC8976234100000020EDC55841000000008A76234100000000EFC55841CDCCCCCC9576234166666626F0C5584133333333A47623419A999919F0C558419A999999B676234100000020F1C5584166666666C17623419A999999F2C558419A999999C97623419A9999B9F4C5584166666666CD762341000000E0F6C558419A999999B97623419A9999B9F8C5584100000000A076234133333353F9C55841666666667F762341333333D3F9C558419A99999976762341CDCCCCECFBC558416666666686762341CDCCCCECFBC55841333333339376234166666686FDC55841000000009C76234100000020FFC55841000000009D7623419A99991900C65841333333339B762341CDCCCCCC01C65841CDCCCCCC9B762341CDCCCCAC02C65841CDCCCCCC967623416666660604C658413333333390762341000000E007C658413333333391762341333333F30AC6584100000000A47623419A99991911C658419A999999BE762341666666A617C65841CDCCCCCCB27623416666666620C65841000000005B7623413333331324C658419A99999917762341CDCCCC2C23C6584166666666FC752341666666A627C6584100000000F7752341000000402CC6584100000000EC752341666666662EC658419A999999F17523419A9999D930C6584133333333267623416666666636C6584166666666277623413333337338C65841333333331D762341000000603AC658419A999999F9752341666666263EC65841CDCCCCCCEE7523419A9999B946C65841333333339F7523419A99995951C6584100000000877523410000000054C6584100000000247523419A9999F959C6584100000000E77423410000004064C6584100000000B3742341000000E06AC658416666666678742341333333937CC6584133333333707423419A9999997FC65841333333336B7423410000008081C6584100000000FE7323413333333391C6584166666666CE732341000000C091C6584133333333B4732341333333F394C658419A99999953732341333333D39AC65841000000003D732341CDCCCCAC9CC65841CDCCCCCC15742341CDCCCCAC1DC758413333333322742341666666862EC75841333333332F7423410000000046C758419A9999994B742341CDCCCC8C5AC7584166666666537423419A99997960C7584133333333527423416666660664C75841CDCCCCCC3E742341CDCCCCCC6FC75841000000002D7423410000006081C758413333333319742341333333138DC7584100000000F7732341333333D39BC7584133333333D8732341CDCCCCCCA8C758419A999999B173234133333353B5C7584166666666D575234133333333D7C758413333333348762341333333B3DEC75841CDCCCCCC4A7623419A999999E4C75841000000004876234133333333E6C758410000000039762341CDCCCC4CE7C7584100000000CB7523419A999999EAC7584133333333C3752341CDCCCC6CECC7584133333333C2752341000000E0F2C75841CDCCCCCC7E75234100000060F6C758410000000053752341333333F3F9C75841000000005175234166666626FCC75841000000005A7523416666666601C85841CDCCCCCCD4742341666666A612C858419A999999CD742341CDCCCC6C14C858419A999999CF7423419A99995916C85841CDCCCCCCDC742341666666061CC8584133333333DE742341666666061FC8584133333333D87423419A9999B922C8584166666666C8742341666666E628C8584166666666A17423413333339334C8584100000000707423413333331346C8584133333333697423410000004054C85841CDCCCCCC607423413333335367C85841CDCCCCCC50742341000000A06DC858419A999999237423410000008077C8584100000000157423419A9999797AC85841333333330D742341000000E07DC858419A9999990D7423416666668687C858419A9999990D742341333333139CC85841CDCCCCCC04742341333333D3A1C858419A999999F8732341333333F3A3C8584100000000E773234133333313A7C8584100000000D4732341000000E0AAC85841CDCCCCCCB2732341CDCCCC0CB1C8584133333333A473234166666666B4C85841CDCCCCCC9C7323419A999939B7C85841CDCCCCCC9F73234166666666BDC8584133333333A27323419A999939BFC85841CDCCCCCC96732341CDCCCCECC2C858410000000080732341000000A0C6C858416666666658732341CDCCCCCCCFC85841000000004973234133333333D5C85841333333334A73234133333353D9C85841CDCCCCCC5E7323419A999959E1C858413333333319732341CDCCCCACE7C85841CDCCCCCCFD72234166666666EAC85841CDCCCCCCDE722341333333F3F5C8584166666666CD7223413333339301C958419A999999A9722341CDCCCC4C0DC95841CDCCCCCCA1722341CDCCCCAC19C95841	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	01010000206A080000E3DF1E81448023419A9999F93CC85841	190060000	Z	Alleyrat	1900600	19006	19	75	15
01060000206A08000001000000010300000001000000EC0300009A999999B98B2241CDCCCC6CD689584166666666BB8B2241333333D3EA895841CDCCCCCCC18B22419A999959F689584166666666CF8B224133333393FE895841CDCCCCCCD58B224133333353008A584133333333FD8B2241000000200C8A58419A999999258C2241333333F31F8A58419A999999268C22419A999979208A5841333333332D8C22419A9999B9238A5841333333333A8C224166666686298A58419A999999438C2241000000203B8A5841CDCCCCCC478C2241CDCCCC2C5E8A5841CDCCCCCC4C8C224133333373788A5841333333335B8C2241666666468A8A5841CDCCCCCC6D8C2241333333D3918A584133333333728C22419A9999D9998A5841CDCCCCCC658C2241333333F3AC8A58419A999999698C22419A999919B78A5841000000006A8C224100000020B88A5841CDCCCCCC708C224133333373C68A584166666666828C2241666666E6C98A584166666666508D224133333313F48A5841000000005B8D2241666666C6F68A5841CDCCCCCC628D2241666666C6F88A584100000000A28D2241CDCCCC0C098B58419A999999E78D2241000000801C8B584100000000118E224133333353248B58419A999999168E22419A999919258B584166666666448E2241666666E62B8B5841CDCCCCCC808E224166666606318B584166666666E38E224100000040388B58419A9999994C8F2241CDCCCCEC3E8B58419A9999993B90224133333373498B5841333333334C9022419A9999394A8B5841333333335F9022419A9999194B8B5841666666663791224100000020558B58416666666657922241333333535E8B58416666666608932241333333D3638B58416666666622932241CDCCCCAC648B5841CDCCCCCC379322419A999959658B5841CDCCCCCCAC9322419A9999996A8B58410000000069942241CDCCCCAC6C8B58410000000029952241333333B36E8B58419A99999937952241000000206F8B58419A9999995D952241CDCCCC6C708B5841CDCCCCCC6C952241CDCCCCEC708B584133333333E69522419A9999F9748B584166666666A6962241666666067D8B5841666666662A9722419A999979848B58419A999999B7972241CDCCCC2C908B5841CDCCCCCCF4972241CDCCCCEC968B58419A9999997598224100000040A68B584166666666EE982241666666A6B48B5841CDCCCCCC6099224166666686C88B584100000000A69922419A999959D68B5841CDCCCCCCD69922419A999919E08B584133333333E499224133333393DF8B58419A999999299A22419A9999D9DC8B584100000000519A2241CDCCCC8CDB8B584100000000699A2241000000C0DA8B5841CDCCCCCCCA9A2241CDCCCCECD78B584133333333409B2241666666C6D48B58419A9999999E9B224133333373D28B584100000000D69B2241666666E6D18B58419A9999991B9C2241CDCCCC8CCF8B584100000000579C2241000000C0CB8B584166666666209D2241000000C0B58B58419A999999669D2241000000E0AD8B5841333333338E9D224166666686AB8B584166666666B49D2241CDCCCC0CAA8B584133333333E89D2241000000E0A98B58419A999999119E22419A999939A98B5841000000004A9E2241333333D3A78B5841CDCCCCCC8B9E224133333373A58B58419A999999EC9E224100000000A28B5841666666660C9F224166666666A18B584133333333229F224133333373A18B584166666666319F22419A9999D9A18B5841333333334B9F224100000040A38B5841CDCCCCCC5B9F2241CDCCCCECA48B5841CDCCCCCC7D9F22419A999919A98B5841333333339D9F2241333333B3AB8B584166666666C39F224133333353AE8B5841CDCCCCCCDC9F2241CDCCCC2CAF8B58419A999999FE9F224166666626B08B58416666666660A0224133333393B28B58419A99999983A02241666666C6B28B584166666666B4A0224166666686B58B5841CDCCCCCCEAA022419A999939B98B584166666666FEA02241666666A6BA8B5841CDCCCCCC0DA12241666666A6BB8B5841333333332CA1224166666646BC8B58419A99999973A12241000000E0BE8B584166666666A8A122419A999959C18B58419A999999B9A12241CDCCCC0CC28B584100000000C6A122419A999939C28B584133333333D6A12241333333F3C18B584133333333E0A12241333333D3C18B58419A999999E5A122419A9999F9C18B58419A999999F0A12241CDCCCC8CC28B58410000000015A22241666666C6C58B58410000000023A222419A999959C78B5841CDCCCCCC33A22241666666C6C88B58413333333348A2224133333353C98B58416666666662A222419A999919C98B5841CDCCCCCC7AA222419A999979C88B58419A9999999EA222419A999959C68B5841CDCCCCCCCAA2224133333333C38B58419A99999927A3224133333353BE8B5841CDCCCCCC78A322419A999959B98B584166666666B8A32241666666C6B68B5841CDCCCCCC01A4224100000020B68B58419A99999911A422419A999919B68B58419A99999922A4224100000000B78B58416666666628A4224133333373B78B58410000000035A42241CDCCCCECB88B58419A99999948A42241000000A0BB8B58416666666664A422419A9999F9BF8B58419A9999999CA42241666666E6C88B584133333333BDA4224166666606CC8B5841CDCCCCCCDEA42241CDCCCC8CCE8B5841CDCCCCCCFBA42241333333F3CF8B5841CDCCCCCC35A5224100000040D18B5841CDCCCCCC47A5224133333333D18B5841CDCCCCCC74A5224100000020D18B584166666666ACA52241000000C0CF8B584166666666F2A5224133333393CD8B5841666666662EA6224100000060CA8B5841CDCCCCCC4DA6224166666626C88B5841CDCCCCCC88A6224100000040BF8B5841CDCCCCCC96A622419A9999F9BB8B58419A99999999A622419A999959BA8B5841CDCCCCCC98A622419A999939B68B584133333333B3A62241333333D3B88B58419A999999BDA62241666666C6B98B58419A999999C6A6224100000020BA8B584100000000D3A62241333333B3B98B584166666666E1A62241CDCCCC6CB88B584166666666ECA62241CDCCCC0CB88B584166666666FBA6224133333353B88B5841666666660CA722419A999939B98B5841333333331FA7224166666646BA8B5841666666662EA7224166666646BB8B5841666666664AA72241000000A0BD8B58413333333376A72241CDCCCC2CC18B5841333333338AA7224100000080C28B5841CDCCCCCC97A72241CDCCCC2CC38B58419A999999A8A72241000000C0C48B584166666666B5A722419A999939C68B584100000000F1A722419A9999D9CE8B5841CDCCCCCC07A82241666666C6D18B5841000000001DA822419A9999F9D38B58419A99999934A82241333333B3D58B58413333333378A82241CDCCCC6CD88B58419A999999C6A82241333333D3DC8B584100000000DAA82241CDCCCC8CDE8B58419A999999ECA8224166666606E18B5841CDCCCCCCF2A822419A999979E38B584166666666F8A8224166666606E58B58410000000004A9224133333313E68B58410000000026A92241CDCCCC6CE88B58410000000045A9224100000020EA8B58419A99999953A9224100000020EC8B58416666666656A922419A9999B9ED8B5841000000004FA92241666666E6F58B58419A99999954A922419A999979FA8B58413333333382A9224133333373068C584100000000C9A9224166666626168C58410000000010AA2241000000C0238C58419A9999993EAA2241CDCCCC4C2C8C5841CDCCCCCC74AA2241666666E62F8C5841333333339DAA2241CDCCCCEC308C584166666666B8AA2241666666E6308C5841CDCCCCCCCAAA224100000040308C584166666666F2AA2241666666462C8C58419A9999991AAB22419A999939298C58419A99999930AB2241000000A0278C58413333333351AB22419A999939278C5841666666667FAB22419A9999D9278C584133333333BAAB22419A999959298C58419A99999902AC22419A9999592C8C5841CDCCCCCC31AC22419A9999792D8C58419A9999994DAC2241666666262E8C58419A99999973AC2241CDCCCC2C2F8C584100000000A1AC22419A9999D92F8C58419A999999C7AC2241CDCCCCEC2F8C58416666666632AD2241666666E6248C58410000000076AD22419A999999198C5841CDCCCCCC1FAE224166666646208C584166666666A8AE2241CDCCCCAC1F8C5841CDCCCCCCD7AE2241000000A01E8C58410000000003AF224133333333198C58419A999999BEAF2241CDCCCCACC28B584100000000A9AF224100000040BB8B5841666666669AAF224166666646B58B58416666666694AF2241CDCCCC2CB28B5841CDCCCCCC79AF2241666666C6A58B5841CDCCCCCC62AF2241666666C69B8B5841CDCCCCCC5DAF2241666666E6988B5841666666665AAF2241666666A6968B58413333333359AF2241CDCCCCAC948B5841CDCCCCCC5AAF22419A999939928B58413333333366AF2241666666C68C8B5841000000007EAF22419A999919848B58416666666694AF2241666666467B8B584166666666A4AF22419A999919758B584133333333B7AF2241666666066E8B58419A999999C0AF2241CDCCCCCC698B5841CDCCCCCCC4AF22419A9999F9668B58419A999999C5AF22419A999979648B584100000000C2AF2241CDCCCC8C5E8B5841CDCCCCCCBAAF224166666606558B584133333333B3AF22419A9999194A8B584100000000B0AF22419A999939468B584100000000ACAF224166666686438B584133333333A5AF2241000000E0408B5841333333338EAF2241CDCCCC2C398B5841CDCCCCCC6DAF2241000000602F8B58419A9999994FAF224100000040268B5841CDCCCCCC45AF224166666646238B5841333333333AAF2241666666C61F8B58419A99999921AF224166666606198B58419A99999900AF2241000000C00E8B584166666666E8AE22419A999979078B5841CDCCCCCCC2AE224100000060FC8A584133333333AAAE22419A9999D9F48A5841CDCCCCCC9BAE2241CDCCCC4CF08A58413333333393AE224100000040EC8A58419A9999998EAE22419A999919E88A5841000000008FAE224166666646E58A58419A99999992AE224166666626E28A58419A999999A3AE2241000000C0DA8A58419A999999D9AE22419A999959C58A58419A999999E6AE224133333333C08A5841CDCCCCCC5DAF2241CDCCCCECC48A58410000000009B12241CDCCCC8CDD8A58416666666639B1224100000060E28A58410000000060B1224166666646E58A58416666666674B1224100000000E78A5841CDCCCCCC8CB1224133333333E88A584100000000ADB12241666666C6E88A58419A999999CDB122419A9999B9E98A584100000000E0B12241CDCCCC8CE98A584166666666D1B12241333333D3E08A584166666666DFB122419A9999D9DD8A5841CDCCCCCC02B22241000000C0DA8A58416666666625B222419A999959D88A58413333333359B2224166666646D68A584133333333D3B222419A9999D9CF8A58413333333315B32241000000A0C78A58413333333334B32241CDCCCC8CC58A58419A99999965B322419A999919C48A58416666666696B32241666666C6C28A584133333333B4B322419A999939C18A5841CDCCCCCCFCB32241333333D3BC8A5841CDCCCCCC45B42241CDCCCC0CB88A5841666666668CB42241000000A0B38A584100000000B1B42241000000C0B18A584133333333D4B4224133333313B18A5841CDCCCCCCFDB4224100000080B08A58419A9999991CB52241CDCCCCACAF8A5841CDCCCCCC36B5224133333353AE8A58413333333353B52241000000A0AB8A58419A9999996DB5224100000020A98A5841CDCCCCCC75B5224100000080A88A58410000000084B522419A9999B9A78A5841666666669DB52241000000E0A68A5841CDCCCCCCB8B52241666666C6A68A584100000000DAB5224133333373A78A584166666666F3B5224133333393A78A58419A999999F6B62241666666C6A88A5841CDCCCCCC58B7224133333333AD8A5841CDCCCCCCA6B72241333333D3AD8A584166666666F4B7224100000060AC8A5841CDCCCCCC63B82241333333F3A98A584100000000BBB82241CDCCCC0CA78A584166666666EAB82241000000E0A58A584133333333EBB8224133333373A08A58413333333309B9224100000040998A58410000000035B9224133333393948A58410000000062B92241000000608F8A58416666666688B9224100000080898A58419A999999AEB922419A999939838A584166666666D9B92241333333337B8A584166666666F5B92241666666A6738A584100000000F8B92241000000A0718A584100000000F7B92241000000E06A8A58419A999999F7B922419A999939648A58416666666607BA2241000000E05E8A58419A9999992CBA2241666666865A8A5841666666663EBA224166666646588A5841CDCCCCCC54BA2241CDCCCCEC548A58416666666671BA2241333333B34F8A58416666666683BA22419A9999D94A8A5841CDCCCCCC85BA2241666666E6468A58413333333387BA224133333353448A5841666666667FBA2241CDCCCC8C408A58413333333378BA2241CDCCCC8C3D8A5841CDCCCCCC74BA224133333333388A5841666666667DBA224166666686338A58419A99999993BA2241666666E62F8A584100000000B4BA2241CDCCCC4C2D8A584133333333C9BA2241000000402B8A584100000000E7BA224133333313288A5841CDCCCCCCF1BA2241000000C0258A58419A9999990ABB2241333333F31D8A58410000000019BB22419A999919198A5841CDCCCCCC21BB2241666666A60E8A58416666666622BB2241333333330C8A5841CDCCCCCC22BB2241666666460A8A58413333333319BB2241000000C0028A58416666666605BB2241000000A0FC895841CDCCCCCCEFBA22419A999919F78958419A999999EDBA2241666666C6F289584100000000F6BA224166666686EE89584166666666FEBA22419A999959EC8958410000000006BB22419A999979EB895841CDCCCCCC17BB2241333333D3E88958416666666620BB2241CDCCCC6CE78958410000000030BB22419A9999F9E4895841CDCCCCCC3DBB22419A9999D9E1895841000000003DBB2241000000E0DB895841CDCCCCCC21BB22419A9999F9D68958410000000000BB224166666606D38958419A999999F1BA2241CDCCCC8CCE89584166666666EABA2241333333D3C68958419A999999E7BA2241333333D3BF895841CDCCCCCCE5BA2241333333B3B989584166666666E8BA2241CDCCCC6CAE89584100000000E7BA224133333393A8895841CDCCCCCCEDBA2241333333F3A28958419A99999902BB2241000000009B8958410000000014BB2241000000C08B8958419A99999914BB224166666666868958416666666620BB2241000000607C8958419A99999931BB2241CDCCCC0C748958419A9999993DBB2241000000006F8958419A99999947BB2241CDCCCC4C688958419A99999944BB2241666666065D895841666666663EBB22419A999939598958416666666630BB22419A999939528958413333333331BB2241000000404E895841666666663EBB2241333333D3488958410000000059BB22410000002043895841333333336FBB22419A9999393D895841000000007BBB2241CDCCCC4C39895841CDCCCCCC81BB2241CDCCCCEC33895841000000007DBB2241666666C62E895841CDCCCCCC61BB2241CDCCCC6C2B8958410000000049BB22410000006027895841CDCCCCCC38BB2241333333F324895841CDCCCCCC2ABB2241333333131F8958416666666629BB22419A9999B91A895841000000003CBB2241CDCCCCEC128958416666666654BB22419A9999790F8958413333333375BB22419A9999190D8958413333333391BB2241000000200B89584133333333A7BB224166666626098958419A999999B5BB22419A9999390789584166666666BEBB2241333333930489584166666666C1BB2241666666A60089584100000000ACBB2241CDCCCCCCFC885841CDCCCCCC91BB22419A999939FA885841CDCCCCCC76BB2241666666C6F78858413333333356BB2241666666E6F4885841CDCCCCCC49BB2241CDCCCC4CEF8858410000000055BB2241CDCCCC4CEC8858419A9999996CBB22419A9999B9E9885841CDCCCCCC9FBB2241CDCCCC0CE6885841CDCCCCCCADBB22419A999999E588584100000000D3BB22419A999979E3885841CDCCCCCCD8BB224100000020E3885841CDCCCCCCEABB224133333353E1885841CDCCCCCCFDBB224100000080DC88584166666666FEBB2241333333D3DA8858419A99999906BC224166666646D088584166666666D4BB224100000000CC8858419A999999C1BB22419A999919CA88584133333333AEBB22419A999959C8885841CDCCCCCC9ABB2241CDCCCC8CC6885841000000008EBB224100000040C58858413333333380BB22419A999919C4885841000000006CBB2241CDCCCC4CC28858419A9999995FBB224166666686C08858419A99999954BB2241666666A6BE8858410000000050BB22419A9999D9BC8858419A9999994BBB2241666666C6B98858416666666647BB2241666666C6B78858419A99999943BB224133333373B5885841CDCCCCCC41BB2241CDCCCCCCB28858410000000044BB224100000020B18858413333333347BB224166666646AF8858419A99999947BB22419A999919AF885841CDCCCCCC45BB224133333353AC885841CDCCCCCC21BB22419A999999A28858419A99999918BB22419A999939A08858419A99999910BB22419A9999F99D885841000000000EBB22419A9999B99B8858410000000004BB2241666666269888584166666666F8BA2241CDCCCC6C95885841CDCCCCCCF0BA224100000080938858419A999999EABA2241CDCCCCEC908858419A999999E3BA2241666666468E88584100000000DBBA2241333333138C885841CDCCCCCCD5BA22410000004089885841CDCCCCCCD0BA2241333333738688584166666666C8BA2241CDCCCC8C848858419A999999BFBA2241000000008388584133333333ACBA224166666606808858419A9999999EBA22419A9999B97E8858413333333391BA22419A9999597C8858410000000086BA2241000000E07A8858410000000074BA224100000080798858410000000064BA2241CDCCCCAC788858416666666650BA224100000020778858419A9999993DBA224166666606768858419A9999992CBA2241666666E675885841000000001CBA2241333333B3758858416666666608BA2241CDCCCC4C7588584133333333F0B92241000000C07488584133333333DDB92241333333937488584133333333CCB92241666666267588584166666666BBB92241CDCCCCAC75885841CDCCCCCCAAB9224100000040768858410000000096B92241333333D3768858416666666684B92241CDCCCC8C778858419A99999973B922410000008078885841666666665BB922419A99997979885841CDCCCCCC44B92241666666A67A8858410000000024B922419A9999B97B8858410000000005B92241333333537D88584133333333F8B82241CDCCCC4C7E88584133333333E9B82241666666067F8858419A999999DBB82241000000807F88584133333333CDB82241000000807F88584100000000C0B82241CDCCCCEC7E88584133333333B8B822419A9999197E88584100000000AFB82241000000607C885841CDCCCCCCA8B822419A9999F97A8858419A999999A1B82241CDCCCC6C798858419A9999999AB822416666664677885841CDCCCCCC94B82241CDCCCC2C758858419A9999998FB82241CDCCCC2C738858419A9999998CB822410000002071885841CDCCCCCC8DB82241CDCCCC2C6F8858416666666695B82241666666466D885841CDCCCCCC9CB822419A9999396B88584133333333A1B82241666666866888584166666666A2B82241CDCCCC4C668858419A999999A1B8224166666646618858419A999999A1B822419A9999D95E8858419A9999999CB82241CDCCCC2C5C8858410000000096B822413333339359885841CDCCCCCC91B822410000002057885841000000008AB822419A9999B954885841CDCCCCCC80B8224133333373528858413333333377B822419A99991950885841000000006CB822419A9999594D8858410000000059B82241666666064C8858419A99999949B822419A9999794B8858413333333334B82241CDCCCCCC4B8858419A9999991CB82241333333B34C885841CDCCCCCC0BB822419A9999394D88584133333333F6B72241CDCCCC8C4D885841CDCCCCCCE3B72241000000004E88584100000000D5B72241333333F34D885841CDCCCCCCCCB72241CDCCCC2C4D8858419A999999BFB72241CDCCCCCC4A885841CDCCCCCCB8B72241CDCCCC0C49885841CDCCCCCCAEB72241CDCCCCEC468858419A9999999BB722410000002046885841CDCCCCCC85B72241333333B3458858416666666675B722419A99991946885841CDCCCCCC5DB72241000000E046885841000000004AB722419A999959478858416666666634B722419A99999947885841CDCCCCCC14B72241CDCCCC0C488858413333333305B72241333333D3478858419A999999D4B62241333333F345885841CDCCCCCCC4B62241000000E04488584133333333B6B62241000000A0438858419A999999A6B62241CDCCCCCC418858410000000095B62241000000A03F8858410000000079B62241CDCCCCCC3B885841CDCCCCCC6DB62241000000A0398858410000000063B622413333337337885841666666665AB62241CDCCCC6C35885841CDCCCCCC51B622419A99995933885841CDCCCCCC4BB622419A99993931885841CDCCCCCC47B62241333333D32D885841000000004CB62241333333F3268858413333333348B6224133333353248858416666666644B62241333333D3218858419A99999943B62241333333931E8858416666666644B622419A9999D91B885841CDCCCCCC44B6224166666626198858410000000044B6224100000060168858413333333344B622419A999979138858413333333345B622419A9999790F8858410000000047B62241CDCCCC6C0D885841000000004AB62241666666860A885841CDCCCCCC4BB62241333333D307885841CDCCCCCC4AB6224133333373048858410000000044B622419A99991901885841CDCCCCCC38B6224166666606FD8758413333333330B622419A9999F9F98758419A99999927B62241333333D3F68758410000000021B62241CDCCCC8CF48758419A99999915B62241333333F3F1875841666666660EB622419A9999D9EF875841000000000EB62241666666C6EE8758419A9999990DB62241000000A0ED8758410000000011B6224100000080EB875841CDCCCCCC17B62241CDCCCCCCE8875841CDCCCCCC1EB62241CDCCCCCCE68758413333333323B62241CDCCCCCCE4875841CDCCCCCC27B62241666666A6E2875841CDCCCCCC30B62241000000A0E08758419A9999993EB62241333333B3DE875841000000004AB622419A999999DC8758413333333353B62241CDCCCC0CDA875841CDCCCCCC5CB62241CDCCCC6CD78758410000000070B62241CDCCCCECD2875841CDCCCCCC88B6224100000060CF8758416666666691B6224166666686CD8758419A9999999AB622419A9999F9CB87584133333333A5B62241CDCCCCCCC987584166666666A9B62241333333B3C78758419A999999AAB6224166666606C5875841CDCCCCCCA9B622419A9999F9C287584133333333A4B622419A999919C18758419A99999999B62241000000E0BE8758419A9999998FB62241CDCCCC0CBD8758410000000084B622419A999939BB8758410000000072B6224166666666B98758410000000062B62241000000E0B88758419A99999952B6224100000080B8875841333333330DB6224133333333B787584133333333FAB522419A999979B78758419A999999EAB52241000000C0B78758419A999999CFB52241CDCCCC8CB787584133333333BCB5224133333393B787584100000000A3B522419A9999B9B7875841000000008FB52241000000C0B7875841CDCCCCCC7BB522419A9999B9B7875841000000005BB522419A999959B7875841CDCCCCCC49B52241000000E0B68758410000000024B5224100000080B5875841CDCCCCCCFEB422419A9999D9B387584166666666D8B42241666666C6B0875841CDCCCCCCC6B42241CDCCCC8CAE8758419A999999B3B42241CDCCCC0CAC87584166666666A3B42241CDCCCC0CAA875841CDCCCCCC92B4224133333393A78758416666666686B42241000000C0A58758410000000073B42241CDCCCCCCA28758410000000064B422419A999939A08758413333333353B42241666666E69D875841CDCCCCCC48B42241CDCCCC6C9B8758419A99999942B42241666666E698875841333333333CB4224100000080968758413333333335B42241CDCCCCCC93875841CDCCCCCC2BB422410000004091875841CDCCCCCC23B42241333333D38E875841333333331EB42241CDCCCC6C8C875841CDCCCCCC19B42241000000208A8758413333333312B4224166666686888758416666666603B42241CDCCCC2C868758419A99999900B422419A9999B98587584166666666F1B322413333335383875841CDCCCCCCE3B322419A9999598187584133333333D1B322419A9999597F87584133333333BEB322419A9999D97D87584133333333AEB32241CDCCCC6C7C875841333333339CB32241000000607B8758419A99999949B32241CDCCCC8C768758419A9999992DB322416666666674875841CDCCCCCC18B32241CDCCCCCC72875841CDCCCCCC07B32241CDCCCCCC718758419A999999EDB22241666666067187584100000000DBB22241CDCCCCEC6F87584166666666CBB22241666666866E8758419A999999BAB22241666666066D87584100000000AAB22241000000A06B875841000000009BB22241333333136A875841CDCCCCCC88B2224100000060688758416666666675B2224133333313678758410000000068B222419A99993966875841CDCCCCCC35B222416666666664875841333333331DB22241CDCCCC4C63875841CDCCCCCC07B22241CDCCCC4C6287584100000000D3B122419A9999995F875841CDCCCCCCBCB122419A9999D95D8758419A999999A8B122419A9999395C8758416666666698B122419A9999395B8758410000000088B122419A9999F95A8758413333333372B12241666666A65A875841666666665AB12241333333535A8758416666666643B122416666668659875841CDCCCCCC31B122419A99999958875841000000001DB1224166666606588758410000000008B122419A9999995787584133333333F7B02241666666E65687584100000000E4B022419A9999B95687584133333333D4B022413333333357875841CDCCCCCCCCB02241CDCCCC4C58875841CDCCCCCCCBB022419A9999995A87584100000000CDB02241666666E65C8758419A999999C7B02241333333F35F87584166666666BEB02241000000C061875841CDCCCCCCAEB022410000006062875841CDCCCCCC9DB02241CDCCCC4C638758419A9999998CB0224133333313648758419A99999976B0224133333373648758410000000064B02241333333B364875841333333334CB02241666666E664875841CDCCCCCC39B022410000008064875841CDCCCCCC23B022413333335363875841CDCCCCCC15B022410000006061875841666666660BB02241000000805F8758416666666601B02241333333735C8758419A999999FDAF2241CDCCCC4C5A87584166666666FCAF2241CDCCCC0C5787584166666666FBAF224133333333548758419A999999FAAF2241666666665087584133333333F7AF2241333333334B87584166666666F2AF2241666666664687584133333333EFAF22416666660644875841CDCCCCCCE8AF2241CDCCCC0C418758419A999999E0AF2241333333D33E87584100000000DAAF2241666666263D8758419A999999C9AF2241000000603B87584166666666BBAF2241000000603A87584133333333AAAF2241333333D339875841666666669AAF2241CDCCCC6C398758410000000085AF2241CDCCCCEC38875841CDCCCCCC75AF22419A9999F937875841CDCCCCCC67AF22416666660637875841CDCCCCCC56AF22410000000036875841CDCCCCCC4EAF2241000000E034875841CDCCCCCC4CAF224100000040338758419A99999952AF2241CDCCCCAC308758419A9999995CAF2241666666262E8758413333333364AF2241CDCCCC8C2B875841CDCCCCCC69AF2241CDCCCC8C28875841666666666CAF22410000006025875841333333336DAF2241333333F321875841666666666EAF2241666666A61E875841333333336DAF22419A9999B91A875841CDCCCCCC6BAF224100000040188758419A99999964AF2241CDCCCCEC158758413333333353AF22416666666613875841CDCCCCCC49AF2241666666E6118758419A9999993AAF22419A9999790E8758419A9999992BAF2241000000000C875841000000001EAF2241666666060A8758416666666610AF224166666666078758410000000000AF2241000000600487584133333333F5AE2241666666860187584166666666F1AE22419A9999D9FE86584100000000F2AE224100000040FC86584133333333EEAE22419A999959F986584166666666DDAE2241666666A6F686584100000000CDAE22419A9999F9F38658419A999999BCAE224133333393F18658419A999999ADAE224166666606EF8658419A9999999BAE224166666686EB865841000000008BAE2241666666C6E8865841000000007EAE2241333333B3E58658413333333373AE2241CDCCCCCCE2865841000000006BAE2241CDCCCCACDF8658416666666661AE2241CDCCCC4CDC8658419A9999994AAE224133333353D68658419A9999993AAE2241CDCCCCACD2865841000000002EAE2241666666E6CF8658419A99999923AE2241CDCCCC8CCD8658416666666619AE2241666666E6CA8658410000000017AE22419A9999B9C8865841CDCCCCCC17AE224166666606C6865841666666661BAE2241333333B3C38658416666666626AE224133333393BB865841CDCCCCCC2BAE224133333353B8865841CDCCCCCC2FAE224133333333B58658413333333334AE224166666686B28658416666666637AE2241CDCCCC4CAF8658419A9999993DAE224133333393AD865841333333334AAE2241333333F3AA8658413333333353AE2241CDCCCCECA98658413333333367AE224133333353A8865841CDCCCCCC79AE224100000000A7865841333333338CAE2241000000A0A586584133333333A6AE22419A9999F9A38658419A999999B5AE2241000000C0A286584133333333C6AE2241CDCCCC8CA18658419A999999D5AE2241333333139F865841CDCCCCCCDDAE2241333333339D865841CDCCCCCCE6AE2241666666A69B8658419A999999EFAE22419A9999199A86584100000000F8AE22410000006098865841CDCCCCCCFDAE2241000000C0978658419A99999903AF22419A9999F996865841666666660FAF22416666664696865841CDCCCCCC19AF2241CDCCCCAC958658410000000025AF22419A9999B9948658410000000031AF2241CDCCCC2C94865841CDCCCCCC3DAF2241666666A6928658419A99999945AF224133333393908658413333333346AF2241666666668E8658419A99999941AF2241666666668C865841CDCCCCCC36AF22419A9999D9898658410000000028AF2241CDCCCC2C88865841666666661CAF22419A999939868658413333333317AF2241000000C0838658413333333313AF2241666666468186584100000000A6AE2241666666667A865841666666669AAE2241CDCCCCAC7986584166666666A0AD2241CDCCCCAC788658413333333314AD22413333339372865841CDCCCCCC54AC2241000000406D8658413333333325AC2241CDCCCC2C748658419A9999991BAC2241CDCCCC8C728658413333333314AC2241CDCCCCEC708658410000000010AC2241CDCCCC6C6F865841666666660FAC2241666666C66D8658419A99999911AC2241000000606B8658416666666614AC22419A999919688658419A99999920AC2241CDCCCC6C60865841000000002EAC2241000000E0588658419A99999910AC22419A9999F95886584133333333DCAB22419A9999F95C8658413333333377AB2241666666A6698658419A9999991DAB2241000000E06F865841000000007DAA2241CDCCCC8C74865841333333331DAA2241CDCCCC8C7A8658410000000016AA2241CDCCCCAC738658419A99999922AA2241333333736C865841CDCCCCCC46AA22419A99991965865841000000008AA92241000000006E8658419A99999954A922419A9999D96A86584133333333A0A82241CDCCCC0C618658419A99999935A72241CDCCCCAC538658410000000082A6224100000060568658419A99999977A6224100000020508658410000000059A62241CDCCCC6C4786584133333333F4A52241CDCCCC4C3C8658416666666635A522419A999959318658410000000027A522419A999939318658419A99999917A5224100000040318658416666666609A52241333333533186584100000000FAA4224133333373318658419A999999EBA42241666666C6318658419A999999DEA42241CDCCCC2C32865841CDCCCCCCCDA42241333333933286584100000000C0A42241666666E6328658419A999999B3A4224133333353338658419A999999A8A422419A9999F933865841000000009DA4224166666626358658410000000097A42241000000A036865841333333337AA42241666666863C865841CDCCCCCC69A42241666666A640865841CDCCCCCC62A42241000000E042865841CDCCCCCC54A42241000000C045865841000000004BA422419A999979478658416666666642A42241333333F3488658410000000032A422419A9999394A8658410000000020A42241333333D34A865841CDCCCCCC0FA42241333333B34A865841CDCCCCCCFBA32241666666864A86584133333333E9A32241333333F34986584133333333D6A32241666666264986584166666666BBA322419A9999D94786584133333333A9A32241000000E046865841CDCCCCCC91A322413333339345865841333333337FA32241CDCCCC4C448658410000000066A322419A999979428658416666666652A32241666666E6408658416666666642A32241000000603F865841CDCCCCCC30A322419A9999F93D8658410000000020A322419A9999993C865841CDCCCCCC13A32241CDCCCCCC3B8658419A999999FAA22241333333B3398658419A999999F0A2224166666646388658419A999999EBA222419A9999D936865841CDCCCCCCE9A2224166666606358658419A999999EDA222413333331333865841CDCCCCCCF2A22241000000203086584133333333F6A22241CDCCCCCC2D865841CDCCCCCCF5A22241CDCCCC4C2B8658419A999999F3A22241333333F32886584166666666EFA222419A9999992586584133333333E4A22241333333D32286584133333333D9A222419A99991921865841CDCCCCCCCAA22241666666062086584166666666BDA22241000000601F865841CDCCCCCCB4A22241CDCCCCCC1E8658419A9999999EA222419A9999591D865841CDCCCCCC89A22241000000201B865841CDCCCCCC7AA222419A99995919865841CDCCCCCC6FA22241CDCCCC8C178658413333333367A222413333331316865841333333335FA22241000000A0148658413333333354A222419A9999D9128658419A9999994BA22241CDCCCC8C118658410000000040A222419A99995910865841CDCCCCCC34A22241CDCCCC6C0F8658416666666628A22241CDCCCC0C0F8658410000000027A22241666666060F8658416666666654A122419A999959F185584100000000A0A02241CDCCCC8CE7855841666666664FA02241666666A6DD8558419A9999994DA02241CDCCCC6CC38558419A9999996AA02241666666A6B5855841CDCCCCCC69A0224166666626A9855841000000000FA02241000000A096855841CDCCCCCC0B9F2241CDCCCC2C9A85584133333333F69E22419A9999799C85584100000000E29E2241000000E09D85584166666666D29E2241CDCCCC8C9E8558419A999999C19E2241CDCCCCAC9E855841CDCCCCCCAE9E2241000000609E8558419A999999949E2241666666669D85584133333333769E2241000000C09B855841333333335F9E2241666666469A85584100000000469E22413333337398855841333333332E9E2241000000A09785584133333333119E2241000000009785584100000000EF9D2241CDCCCCCC9685584133333333C29D22419A99997997855841333333337B9D22419A99997998855841CDCCCCCC309D2241CDCCCCCC99855841CDCCCCCCEC9C22419A9999799A855841CDCCCCCCD79C2241000000809A85584100000000CB9C2241000000609A8558419A999999BE9C2241000000C099855841CDCCCCCCB89C2241666666269985584100000000B79C2241333333F39885584100000000B09C2241CDCCCCAC9785584166666666AD9C2241333333139685584100000000AE9C2241333333539385584133333333B19C2241666666A69085584133333333B09C2241CDCCCC4C8E8558419A999999AB9C2241333333338C8558419A999999A49C2241000000808A855841333333339C9C22419A99999989855841CDCCCCCC919C2241333333338985584166666666889C22419A999939898558419A9999997D9C22419A9999998985584100000000739C2241000000608A855841CDCCCCCC5F9C2241CDCCCCEC8B85584133333333519C2241000000008D85584133333333479C22419A9999798D855841000000003B9C2241333333938D855841CDCCCCCC2F9C2241666666668D85584166666666209C2241333333D38C8558419A999999099C2241333333538B85584166666666F99B22419A9999398A85584166666666CF9B2241CDCCCC4C8785584100000000979B22413333333384855841666666665D9B2241000000A07F85584133333333149B22413333339379855841CDCCCCCCC69A22419A9999B97385584100000000A09A22419A99997970855841000000007C9A2241CDCCCC2C70855841CDCCCCCC3B9A2241000000406E8558419A999999289A2241666666266E855841CDCCCCCCD0992241333333336F855841000000007D992241333333737085584100000000669922419A99999970855841333333335599224166666646708558410000000049992241666666466F855841CDCCCCCC37992241000000006D855841666666661E9922419A9999596E85584100000000D19822419A9999797285584100000000E29822413333337377855841000000001199224166666626868558419A99999941992241CDCCCCAC978558416666666671992241666666A6AC8558419A9999998A99224133333353B9855841CDCCCCCCA2992241CDCCCC0CCA85584100000000C299224166666606E385584133333333D199224100000060F585584133333333DD992241000000600386584133333333DB9922419A9999F90886584166666666D9992241666666060F86584133333333D89922416666664613865841CDCCCCCCCA9922419A9999591F86584100000000C29922419A9999992886584100000000BB992241333333932F86584100000000B099224133333353368658413333333397992241666666A6418658413333333376992241000000E04F8658419A999999539922419A9999D95B8658419A99999928992241CDCCCCAC6C865841333333330F992241000000607A8658419A999999EE982241333333938D86584100000000DD982241000000809C865841CDCCCCCCCB98224166666686AB86584133333333CC98224133333353B5865841CDCCCCCCCF98224166666606BE86584166666666DB98224100000020CA86584166666666EE982241666666C6D58658419A999999F298224100000020DC86584100000000ED98224166666626E88658419A999999DA9822419A999939F886584133333333CF982241000000001487584100000000D0982241333333F32287584133333333D0982241666666C62E87584100000000CD982241CDCCCC2C368758419A999999C5982241666666863E87584166666666B7982241333333D34887584166666666A298224133333333568758419A999999949822419A999959608758416666666691982241666666C662875841666666666F98224133333353798758410000000042982241000000008B875841CDCCCCCC19982241333333139B87584133333333F79722419A999919AB87584166666666D8972241666666C6B887584166666666CC97224166666606C187584166666666C897224100000080C487584166666666BD972241CDCCCCECCD87584133333333AB972241666666C6D7875841333333339697224133333393E08758419A99999986972241CDCCCC4CE5875841CDCCCCCC7697224100000060E8875841666666665B972241CDCCCCCCEB875841666666661097224133333353F587584166666666CB9622419A999939FD875841CDCCCCCCBB962241666666C6FE875841666666664F962241000000000A8858419A9999991F962241CDCCCCAC0E88584100000000D19522413333337314885841CDCCCCCCBF9522413333337317885841666666668695224100000020228858419A9999996C9522416666666627885841333333334A952241666666662E885841666666661695224100000080378858419A999999B09422419A9999B9488858416666666686942241CDCCCC2C53885841333333337994224133333373598858419A99999976942241000000605B8858419A9999997294224166666686608858419A99999971942241CDCCCC2C68885841CDCCCCCC729422419A999979728858419A99999973942241CDCCCC8C768858413333333375942241333333F37C8858416666666675942241000000207D8858419A99999984942241CDCCCC6C918858419A999999859422416666660698885841CDCCCCCC83942241CDCCCC0C9F885841666666667F94224133333353A5885841333333337494224133333353AD885841CDCCCCCC669422419A999979B38858419A9999995B942241CDCCCCACBC885841000000005D942241666666A6C1885841CDCCCCCC63942241333333B3CC885841000000006494224166666646CD885841CDCCCCCC65942241666666E6CF885841333333337494224133333313E1885841000000007A942241CDCCCCCCE78858410000000084942241000000E0F2885841000000008594224166666646F58858419A9999997D9422416666666608895841CDCCCCCC7C942241CDCCCCEC1389584166666666799422419A9999D91B895841CDCCCCCC729422416666666621895841333333336794224100000060278958410000000052942241666666062E89584100000000389422416666666634895841CDCCCCCC11942241666666263B895841CDCCCCCCE3932241CDCCCC8C41895841CDCCCCCCD4932241666666464389584100000000AD932241666666E6478958416666666672932241333333734C89584133333333F79222419A999919538958419A99999934922241000000405C89584166666666B691224166666686618958419A9999999C9122419A9999196289584100000000669122410000002063895841000000004591224100000000648958419A99999923912241000000E0648958419A9999990B912241CDCCCC8C6589584100000000F7902241000000206689584100000000719022416666666668895841CDCCCCCC19902241CDCCCC2C68895841333333339E8F22410000006067895841000000006E8F2241666666E66789584100000000308F2241333333B369895841CDCCCCCCD58E2241666666866D8958419A9999995B8E2241333333D373895841CDCCCCCC428E2241000000C07489584133333333CB8D2241CDCCCC6C78895841CDCCCCCC668D2241333333137B89584133333333B98C224100000060808958419A999999728C2241666666868489584133333333528C224100000040878958419A999999418C2241000000A089895841CDCCCCCC168C22413333333392895841CDCCCCCCF68B22419A9999199C89584100000000E58B224100000000A489584166666666C88B224133333333B5895841CDCCCCCCBC8B224133333353C889584133333333BC8B2241333333F3C98958419A999999B98B2241CDCCCC6CD6895841	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	01010000206A080000E43594D72BA8224166666696CE885841	190070000	Z	Altillac	1900700	19007	19	75	25
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	01010000206A08000036D1B06ED42C23419A9999B9E6C45841	190080000	Z	Ambrugeat	1900800	19008	19	75	30
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	01010000206A080000E33295FEED7E2241666666A6FAAC5841	190090000	Z	Les Angles-sur-Corrèze	1900900	19009	19	75	5
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	01010000206A080000256202D8E4D12241CCCCCC3CDA975841	190100000	Z	Argentat-sur-Dordogne	1901000	19010	19	75	29
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	01010000206A080000CEB1E60613712141666666F697B85841	190110000	Z	Arnac-Pompadour	1901100	19011	19	75	15
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	01010000206A08000020CE733DCC8D224100000080FC855841	190120000	Z	Astaillac	1901200	19012	19	75	7
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	01010000206A0800000098FABCA43722419A999919C99F5841	190130000	Z	Aubazines	1901300	19013	19	75	14
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	01010000206A08000032F06E4484502341CDCCCC3C7EA05841	190140000	Z	Auriac	1901400	19014	19	75	35
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	01010000206A080000761E3A06A05A2141666666468BA75841	190150000	Z	Ayen	1901500	19015	19	75	13
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	01010000206A080000C640D0C2ED852241333333333EB05841	190160000	Z	Bar	1901600	19016	19	75	21
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	01010000206A080000D439FE5793A4224133333323158E5841	190170000	Z	Bassignac-le-Bas	1901700	19017	19	75	12
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	01010000206A080000EB8164DFCB1D234100000080E5A05841	190180000	Z	Bassignac-le-Haut	1901800	19018	19	75	19
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	01010000206A0800008CDE85E8DF862241CDCCCC8C2F8B5841	190190000	Z	Beaulieu-sur-Dordogne	1901900	19019	19	75	17
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	01010000206A080000E8F7DC52B87B2241666666E62DB95841	190200000	Z	Beaumont	1902000	19020	19	75	11
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