SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep21;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep21 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep21','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep21','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep21','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep21"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000B010876003F72941666666D604735941	210010000	Z	Agencourt	2100100	21001	21	27	4
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	01010000206A08000026F95B154A6E2941343333F341845941	210020000	Z	Agey	2100200	21002	21	27	8
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	01010000206A080000CAB9181D8A032A41CCCCCCCC8D8D5941	210030000	Z	Ahuy	2100300	21003	21	27	6
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	01010000206A0800001C6E2E27C7622941000000E000AE5941	210040000	Z	Aignay-le-Duc	2100400	21004	21	27	25
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	01010000206A080000AB914DEB30612A41343333E35A785941	210050000	Z	Aiserey	2100500	21005	21	27	10
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	01010000206A08000048D30AE34D0829410000003047B55941	210060000	Z	Aisey-sur-Seine	2100600	21006	21	27	13
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	01010000206A0800006A92CCA65D4E28419A999919CF8E5941	210070000	Z	Aisy-sous-Thil	2100700	21007	21	27	8
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	01010000206A080000BE07F51DA1C92841000000A0CC9E5941	210080000	Z	Alise-Sainte-Reine	2100800	21008	21	27	4
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	01010000206A08000018EB823403AA2841343333F314795941	210090000	Z	Allerey	2100900	21009	21	27	19
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	01060000206A08000001000000010300000001000000680000006666666633A529419A999959086D59413333333357A5294133333353116D59413333333365A529419A9999B91A6D5941CDCCCCCC22A62941CDCCCC4C1F6D59419A9999994AA72941000000A0316D59419A9999996CA82941000000603E6D594166666666ADA8294133333373196D594100000000DAA8294133333393116D5941333333330BA92941333333F30C6D59419A99999968A92941000000A0096D59419A99999987A92941666666C60B6D59419A999999D3A92941666666E60A6D5941666666667CAA2941000000C0106D5941CDCCCCCC24AB2941666666861F6D5941000000009CAB2941CDCCCCAC2A6D5941CDCCCCCCEDAB294166666686356D5941666666665FAC294166666626496D59419A9999999DAC294100000080516D59419A99999975AD294100000060716D59410000000047AE2941CDCCCC6C8F6D594100000000ECAE2941CDCCCC4CA26D59419A99999942AF294133333373AE6D5941CDCCCCCC62AF2941000000C0B56D59410000000057AF2941666666E6BB6D59419A99999965AF294133333333C16D594100000000ACAF2941CDCCCCCCD26D5941CDCCCCCCC2AF2941CDCCCC2CDA6D5941333333336BB02941CDCCCCACD26D59419A99999996B0294133333353D46D5941CDCCCCCCC1B0294166666686CD6D594100000000E9B0294133333393BA6D59410000000005B1294166666686A96D59419A99999938B1294133333313966D5941333333336BB12941CDCCCC0C8B6D594100000000BDB129419A999979856D594133333333DDB1294133333393806D5941CDCCCCCCD9B12941CDCCCCCC7B6D5941666666669BB12941666666C66F6D5941CDCCCCCCA1B129419A9999F9676D5941CDCCCCCC0BB2294166666646596D5941CDCCCCCC6BB22941CDCCCCEC526D594100000000D5B22941CDCCCCAC486D59419A999999E2B2294133333393456D59413333333334B32941CDCCCC4C3D6D59419A99999962B32941333333133A6D594166666666BDB3294133333353366D594166666666FFB329419A999919366D594166666666BFB42941CDCCCCEC246D5941CDCCCCCCA5B42941666666A61B6D5941CDCCCCCC6BB4294166666686206D5941CDCCCCCC50B429419A9999B91B6D5941CDCCCCCC11B429419A9999191B6D594133333333D9B329419A999959206D59419A999999B2B32941666666C61B6D5941333333335DB32941333333330B6D59413333333337B329419A999959026D594133333333BAB2294100000060EC6C59413333333318B3294133333333ED6C59419A999999A8B32941333333D3EB6C594166666666C7B32941333333F3E86C5941CDCCCCCC39B22941000000E09A6C59416666666614B12941CDCCCC0C636C59419A9999995CB02941333333533E6C59419A999999F2AF2941333333532A6C59419A9999996DAF2941CDCCCC0C106C5941666666662AAE2941666666E6CE6B59419A9999996BAD29419A999959AA6B59416666666605AC2941CDCCCCCC6C6B594166666666DBAB2941CDCCCC0C646B59410000000089AB29419A999939506B5941CDCCCCCC3FAB2941333333133C6B59419A999999F4AA29419A999919436B5941333333339EA92941666666E6536B59419A999999EAA82941666666C6596B594166666666A8A82941000000C0596B594133333333E5A72941CDCCCC2C5E6B59413333333357A7294133333313636B59413333333361A72941CDCCCC8C676B59410000000062A629419A999919716B59410000000095A62941000000207F6B594100000000D6A62941000000207E6B59413333333307A72941333333538C6B59416666666665A72941333333D3AC6B594133333333C5A72941666666E6D26B594166666666B4A72941333333D3D86B594166666666B7A729419A999999E96B594166666666A5A729419A9999D9F36B59419A99999959A729419A999999066C5941333333333EA729419A999959116C59410000000033A72941CDCCCC8C2C6C59419A999999F6A62941333333F3536C594166666666F9A629419A9999995A6C59419A9999990FA729419A999919646C594166666666DAA6294166666626806C5941CDCCCCCCAAA6294100000080896C59413333333387A629419A9999B99B6C59419A99999950A6294100000060AC6C59416666666605A62941CDCCCC6CC56C594133333333E0A529419A999959CE6C5941333333336FA5294166666646E46C59419A99999942A5294133333393EF6C5941000000005CA5294133333373F86C59416666666633A529419A999959086D59416666666633A529419A999959086D5941	01010000206A08000023EC1A6649AC2941000000E08C6C5941	210100000	Z	Aloxe-Corton	2101000	21010	21	27	3
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	01010000206A080000DA61B332791529416666661640AA5941	210110000	Z	Ampilly-les-Bordes	2101100	21011	21	27	15
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	01010000206A0800006AFF1274C3CC28419A999909D9BC5941	210120000	Z	Ampilly-le-Sec	2101200	21012	21	27	24
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	01010000206A0800006CB0E7FD29902941343333A372895941	210130000	Z	Ancey	2101300	21013	21	27	8
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	01010000206A080000476BB466B86729410000007017785941	210140000	Z	Antheuil	2101400	21014	21	27	10
01060000206A080000010000000103000000010000002E0200009A9999995DEB2841000000A0C870594100000000C5EB2841CDCCCCECCF7059419A99999900EC284166666646D4705941333333333BEC2841CDCCCC8CD87059410000000072EC284100000040DC7059419A999999B2EC28419A999939E07059410000000017ED2841666666C6E67059419A9999996CED284100000020EC7059419A9999998BED284166666626EE7059419A999999A6ED2841333333F3EF70594100000000C3ED2841CDCCCC0CF1705941CDCCCCCCDFED28419A999979F2705941333333332BF02841666666860F7159413333333364F02841333333F30D715941CDCCCCCCB0F02841333333730F7159419A999999E9F028410000004011715941000000001CF128413333331312715941666666662BF22841CDCCCC0C267159419A99999919F22841CDCCCCAC28715941333333331EF2284166666686297159416666666623F228419A9999192D7159413333333345F22841333333732C715941000000004FF228419A9999792D7159416666666658F22841CDCCCC8C2E7159419A99999961F2284100000000307159410000000068F228419A99991931715941CDCCCCCC6DF228419A999959327159419A99999972F2284166666666337159419A99999978F22841666666A634715941333333337EF22841333333B335715941CDCCCCCC83F22841000000A0367159419A99999988F22841CDCCCC6C37715941CDCCCCCC8DF228416666662638715941CDCCCCCC92F22841000000A0387159416666666699F22841000000003971594100000000A1F22841666666263971594100000000AAF228410000004039715941CDCCCCCCB2F22841CDCCCC4C3971594100000000BCF228419A99995939715941CDCCCCCCC5F228419A9999993971594133333333CDF22841666666C6397159419A999999DDF228419A9999593A71594166666666E9F22841000000203B71594100000000F3F228416666662639715941CDCCCCCCF9F2284100000080387159410000000002F32841CDCCCCEC37715941000000000BF328419A999979377159413333333315F32841CDCCCC4C377159419A99999920F32841CDCCCC4C37715941333333332DF328419A99995937715941CDCCCCCC38F328419A999939377159413333333347F328419A9999F9367159419A99999952F32841666666C636715941000000005DF328419A999979367159410000000067F32841CDCCCC2C367159410000000070F328419A9999F9357159416666666680F328419A9999B935715941666666668FF32841666666C6357159419A9999999DF32841666666063671594166666666ABF32841CDCCCC6C3671594100000000B3F32841000000803671594100000000BBF32841666666663571594133333333F1F3284166666606387159413333333327F42841333333F33A7159413333333339F42841333333D33B715941CDCCCCCC04F42841666666C649715941CDCCCCCC81F428419A9999F95371594166666666CBF42841000000805971594133333333D6F42841000000E05A7159419A999999DEF42841333333D35A7159419A999999EDF42841333333D35B715941CDCCCCCCF6F42841000000E05B7159416666666602F52841666666665B7159410000000009F528419A9999395A715941CDCCCCCC0EF52841666666C6597159416666666628F528419A9999195B7159416666666633F52841CDCCCC8C5C7159419A9999993AF52841CDCCCCCC5C7159410000000071F5284100000040547159416666666681F52841333333D35571594100000000CAF528419A9999995B715941666666662AF628410000002063715941666666663CF62841CDCCCCCC637159419A99999951F628413333339361715941CDCCCCCCB5F62841333333D371715941CDCCCCCCE7F62841CDCCCC6C6D7159419A999999F4F62841CDCCCC4C6C7159416666666621F728419A9999F96F715941CDCCCCCC35F72841CDCCCCEC727159410000000050F7284166666666767159413333333368F7284133333353797159419A9999997EF72841666666467C71594100000000A1F72841000000007F71594166666666D0F72841000000E08471594100000000DCF72841CDCCCC6C86715941CDCCCCCC08F82841CDCCCCCC8A715941666666661CF82841000000808C715941333333332FF82841CDCCCC8C8E7159419A9999995FF82841000000C08B71594100000000A3F82841666666868771594133333333F6F82841666666E683715941CDCCCCCC73F928419A9999197E7159410000000008FA2841333333B3747159413333333332FA2841CDCCCC6C72715941CDCCCCCC49FA284166666666707159419A99999961FA28419A9999596E715941333333337DFA2841333333136B715941CDCCCCCCA0FA2841666666866771594133333333C8FA28413333333363715941CDCCCCCCEDFA2841CDCCCC6C5F715941666666660EFB2841333333135B71594100000000DFFB2841000000A04C7159419A99999984FC28419A9999D9437159416666666635FD2841CDCCCCAC38715941CDCCCCCCA7FD2841CDCCCC0C30715941000000009EFD2841333333F32A7159419A99999998FD284166666686267159410000000053FD28419A9999D9FA705941666666663CFD284100000080E87059419A99999931FD2841CDCCCCACDF705941666666661AFD2841000000E0CC70594133333333BDFD2841666666A6C6705941333333331DFE284100000000C3705941333333339BFE2841666666C6BE7059413333333306FF2841CDCCCC2CBB7059410000000097FF2841CDCCCC8CBA705941CDCCCCCCABFF2841000000C0BC705941CDCCCCCCC3FF2841000000E0BD70594166666666F6FF284166666686BC705941CDCCCCCC06002941000000A0BC7059416666666636002941CDCCCC6CBC705941666666664100294166666666CB7059419A9999993E0029419A999919CC7059410000000030002941000000E0CD705941666666661B00294133333313CF705941333333330B00294133333373CF70594166666666E8FF28419A999979CE70594133333333DCFF2841000000C0CE70594133333333B1FF2841666666A6DA7059419A999999A4FF284166666606E17059419A999999A7FF2841333333F3E47059419A999999BDFF2841CDCCCC2CE570594133333333E6FF2841000000E0E57059419A999999290029419A999979E4705941CDCCCCCC7A00294100000020E4705941CDCCCCCCBF002941CDCCCCECE370594133333333F600294100000060E2705941000000006E01294133333393DD70594100000000A40129419A999999DA7059419A999999DF012941666666C6D870594100000000E7012941CDCCCC2CD870594100000000F40129419A999999D77059419A99999909022941000000A0D6705941000000002D02294166666646D5705941333333335502294133333333D3705941333333335F02294100000000D27059419A9999997A02294166666686D27059419A9999998F022941CDCCCCECD17059419A999999AC0229419A9999F9D1705941CDCCCCCCDE02294166666606D270594166666666DD02294166666686D17059419A999999FC022941666666E6CF7059419A999999190329419A999999CE705941CDCCCCCC2803294133333353CD7059416666666631032941CDCCCCECCC705941333333333603294100000000CD7059413333333341032941000000E0CC7059416666666673032941333333B3CB7059410000000094032941CDCCCCCCC970594133333333D80329419A999939C87059419A9999990D0429419A9999D9C6705941000000004204294100000080C57059419A999999A5042941CDCCCC6CC370594166666666B40429419A999999C770594166666666B90429419A999939CB705941CDCCCCCCDF04294166666686CB705941CDCCCCCCF204294133333313CB70594166666666EE04294166666666C570594133333333E3042941000000C0BA705941CDCCCCCCD5042941CDCCCCACA9705941CDCCCCCCCC042941666666469F705941CDCCCCCCC2042941CDCCCCCC92705941CDCCCCCCB9042941000000C08970594100000000D8042941CDCCCCAC8870594166666666750529413333333382705941CDCCCCCC8505294100000060817059419A9999999F0529419A9999997F705941CDCCCCCCBF052941333333B37C705941000000001F062941CDCCCCEC74705941000000003B06294166666626737059410000000055062941000000C071705941333333334A0629419A9999196E7059419A999999380629410000002061705941000000002D0629416666666658705941CDCCCCCC230629410000000050705941666666661D0629419A9999D94A705941CDCCCCCCF9052941CDCCCCCC337059419A99999954052941CDCCCC2C457059419A999999A3042941CDCCCC0C597059419A9999996D042941000000405E705941CDCCCCCC700429419A99995959705941333333337104294100000000537059410000000078042941666666A64B7059419A999999840429419A9999B9457059419A99999990042941000000803D7059419A999999900429419A99997938705941CDCCCCCC82042941000000C0327059419A9999996B042941CDCCCC0C2D7059416666666659042941000000402E705941666666663B0429419A9999592F705941CDCCCCCC24042941CDCCCC2C3070594100000000FC032941CDCCCCAC30705941CDCCCCCCF6032941000000402670594100000000FB032941666666061C7059416666666611042941CDCCCC2C14705941CDCCCCCC34042941000000001570594166666666680429419A999939007059419A99999954042941666666E6FF6F5941666666665C042941CDCCCCECF26F5941CDCCCCCC56042941000000E0EB6F594166666666420429419A999959DC6F59413333333341042941666666E6DB6F5941CDCCCCCC3504294166666646D76F5941666666662204294166666666C66F5941CDCCCCCC1A0429419A999939B56F59419A99999911042941333333B3A46F5941000000001904294100000020976F5941333333332704294166666626826F5941CDCCCCCC320429419A9999B97E6F59419A9999993D042941CDCCCC0C7C6F594100000000460429419A9999D9796F5941CDCCCCCC520429419A999939776F5941333333335E042941CDCCCC0C756F5941000000004E042941CDCCCCCC716F59419A99999939042941333333536E6F59410000000015042941666666A6686F5941CDCCCCCC02042941CDCCCCEC646F59419A999999F20329419A999979616F594133333333E2032941000000805D6F594166666666D4032941666666C6596F5941CDCCCCCCD103294100000000596F59419A999999C80329419A999959566F594166666666BD032941666666A6526F5941CDCCCCCCB1032941000000C04D6F594166666666AA0329419A999999496F5941CDCCCCCCA10329419A999919446F5941333333339C032941000000A03F6F5941666666669B0329419A9999593C6F5941333333339E0329419A9999B9386F594166666666A2032941000000A0356F594166666666A70329419A999919336F594133333333A00329419A9999D9306F59413333333385032941333333D3276F5941CDCCCCCC5A032941333333331D6F59416666666628032941CDCCCC2C126F59419A99999918032941666666660B6F594166666666150329419A9999990A6F5941666666660D0329419A9999F9056F59419A999999FD022941CDCCCC8CFA6E594100000000FD022941CDCCCC2CFA6E594133333333EC022941333333B3ED6E59419A999999BA0229419A999959C86E5941000000009602294166666626AF6E5941CDCCCCCC8402294100000040A36E59416666666686022941000000E0A26E59419A9999997F022941000000E09F6E594133333333C2022941333333F3996E59419A999999A102294166666606846E59419A9999998102294166666686806E59410000000070022941666666C6816E5941666666664C02294133333393836E59416666666636022941000000A0846E59419A9999992202294100000060856E59419A99999906022941CDCCCCEC856E59419A999999DA0129419A9999F9856E59419A999999BE012941CDCCCC0C856E594166666666A6012941333333D3836E59416666666670012941666666E6806E59413333333362012941CDCCCC2C806E5941333333334E012941000000007F6E59419A999999330129419A9999D97C6E59413333333314012941CDCCCC0C7A6E594166666666ED0029419A999979766E5941CDCCCCCCB2002941CDCCCC2C716E59419A9999995F0029419A9999B96B6E59416666666639002941CDCCCC0C696E5941000000001800294133333353676E5941CDCCCCCCFCFF284133333393646E5941CDCCCCCCE5FF2841CDCCCCAC626E594166666666BAFF2841333333935F6E5941000000008AFF28419A9999195B6E59410000000072FF2841CDCCCC4C576E59410000000056FF2841CDCCCC0C536E5941CDCCCCCCACFF28419A999959496E5941000000002CFF284166666686326E5941CDCCCCCC9AFE2841CDCCCC2C166E5941CDCCCCCC7BFE2841000000E01B6E59410000000074FE28419A9999991C6E5941333333331AFE28419A999939166E594100000000F6FD2841666666A6136E5941666666666DFD2841000000A00C6E5941000000002DFD2841666666C6096E594100000000F3FC2841000000C0076E5941CDCCCCCCC8FC2841333333F3056E594133333333DAFC28419A999999FE6D59419A999999E6FC284100000040F96D59419A999999FBFC28419A9999B9F16D5941333333330FFD284166666686EA6D594100000000F7FC28419A999979EA6D594100000000D6FC2841333333F3E96D594166666666CEFC28419A9999D9E96D594100000000F1FC284133333353DD6D5941CDCCCCCCF8FC284100000080DA6D5941CDCCCCCC24FD284166666626CE6D5941000000002AFD284100000020CD6D59413333333343FD284133333353C86D59416666666665FD28419A9999B9C16D5941333333337CFD2841CDCCCC4CBD6D5941666666665CFD2841000000A0BD6D5941CDCCCCCC41FD284100000020BD6D5941CDCCCCCC2BFD2841666666A6BC6D5941CDCCCCCC15FD2841333333F3BB6D59416666666601FD284100000000BB6D59419A999999E4FC28419A999999B96D594133333333BDFC284100000020B76D594100000000A5FC2841CDCCCC6CB56D59419A9999998CFC284133333373B36D5941333333337BFC284166666686B16D594100000000CBFB284133333393C26D59413333333394FB2841CDCCCC6CBB6D5941CDCCCCCC01FC284100000080A96D594100000000C1FB284100000060A16D5941666666662FFB284100000020B36D59419A99999998FA284166666626C56D59416666666656FA2841000000A0CA6D59419A99999900FA284133333353D16D59419A999999F4F92841CDCCCC2CD06D59419A999999DFF928419A999919CD6D594133333333A6F9284166666646C76D59419A9999999AF92841CDCCCC6CC66D59416666666642F92841CDCCCCCCC16D5941333333332DF928419A999959C16D59419A99999903F928419A999939C26D594166666666F3F828419A999979C36D594166666666EAF82841666666E6C46D594100000000D8F828419A999959C66D594133333333BBF828419A999919CC6D59419A999999ABF82841CDCCCC6CCE6D59416666666697F82841000000C0D16D59416666666688F828419A999979D46D59419A99999974F828419A999939DB6D5941CDCCCCCC63F82841CDCCCCECDD6D59416666666644F828419A9999B9E26D59413333333317F82841CDCCCCCCE86D59419A999999FFF728419A9999D9EB6D594100000000E6F72841000000E0EE6D594133333333CEF72841CDCCCCACF16D59419A999999B6F728419A9999B9F36D5941CDCCCCCC9CF728419A9999B9F46D5941CDCCCCCC84F7284166666606F36D59416666666665F72841CDCCCCCCEF6D5941000000005AF72841666666C6EE6D59413333333335F728419A999999F26D594166666666C1F62841000000C0046E59416666666680F62841CDCCCC0C0B6E59419A9999996FF62841CDCCCC2C0D6E59419A99999965F62841000000E00D6E5941CDCCCCCC44F628419A9999F90E6E5941000000003AF628419A9999D90F6E5941CDCCCCCC1CF62841666666A6126E594133333333FDF52841CDCCCCCC166E594166666666B2F52841000000E01D6E59410000000099F5284133333313216E5941000000008BF5284133333353226E5941000000006FF52841666666E6236E59419A99999936F52841000000A0246E59413333333326F52841333333D3256E59419A9999991CF52841333333F3266E594133333333FCF4284133333353296E594133333333E2F428419A9999392C6E594166666666CDF42841666666662D6E594133333333BAF42841CDCCCCCC2D6E5941000000005BF42841333333932E6E594100000000C7F32841000000C02F6E59419A9999999EF3284133333353216E5941CDCCCCCC68F3284166666666146E5941000000003DF328419A999959206E59416666666606F3284133333373286E594166666666D6F228419A9999F9306E594133333333D0F22841000000E0326E59419A999999C6F22841CDCCCC2C356E594166666666BBF2284100000080376E594100000000B1F22841CDCCCC4C3A6E5941CDCCCCCCA9F22841666666C63D6E594133333333A7F228419A999999416E5941CDCCCCCCA7F22841333333B3446E594100000000AAF228419A999959476E59419A999999B0F22841666666C64A6E5941CDCCCCCCA4F22841CDCCCCEC4C6E59410000000097F22841666666864F6E59419A99999938F22841CDCCCCCC636E59416666666632F22841333333F3656E5941333333332AF228419A9999F9676E594166666666BDF12841666666467E6E594133333333BAF128419A999959806E5941CDCCCCCC74F12841666666867F6E5941CDCCCCCC71F1284133333373806E59410000000062F12841CDCCCC6C836E59419A9999994FF12841333333D3846E59410000000042F1284166666606866E59419A9999992EF12841CDCCCC2C886E59416666666615F12841000000008B6E594166666666F8F028419A9999B98D6E59419A999999DEF02841333333F38F6E594133333333C8F02841666666A6916E594166666666B9F0284100000060936E59419A999999A1F0284100000040966E59416666666692F028419A9999B9976E59416666666682F02841333333F3986E59416666666672F02841CDCCCC8C996E59410000000061F02841666666269A6E5941000000004DF02841CDCCCC0C9B6E59419A9999993AF02841333333739C6E5941666666662DF02841666666469D6E59416666666627F028419A9999B99D6E5941333333331BF02841CDCCCC2C9E6E59419A999999E1EF284100000020A16E59410000000080EF2841666666E6A76E5941666666662CEF284100000020AE6E594166666666E2EE2841CDCCCC8CB36E59419A999999BEEE284166666686B66E594166666666B2EE2841666666C6B86E594133333333ACEE284100000080BB6E594133333333ACEE2841CDCCCCCCBE6E5941CDCCCCCCB1EE28419A9999F9C16E5941CDCCCCCCBCEE2841CDCCCC0CC66E594166666666CAEE284100000060C96E59419A999999D9EE2841CDCCCC6CCC6E594100000000E2EE2841000000A0CE6E594166666666EAEE2841CDCCCC0CD26E59419A999999F5EE2841CDCCCCECD76E59419A99999906EF284100000020E26E59416666666610EF28419A999999E96E59413333333314EF2841CDCCCCECF06E59416666666611EF2841000000E0F46E5941333333330AEF284100000000F86E594100000000FDEE284100000080FB6E594133333333E0EE28419A999959016F594133333333B6EE284166666666096F59416666666688EE284166666606126F5941666666666EEE2841CDCCCCCC166F59413333333345EE2841666666661D6F59419A99999923EE28419A999939236F59419A99999906EE2841000000E0286F594166666666FFED2841666666462A6F594133333333D9ED284166666646326F594166666666B4ED2841666666063B6F59419A99999992ED284100000080416F5941CDCCCCCC76ED2841333333D3456F59419A99999948ED28419A9999B94B6F59416666666624ED284166666666506F5941333333331AED284133333313566F59419A9999990FED2841666666A65E6F59419A99999901ED2841CDCCCC2C686F594133333333F7EC2841333333B36E6F5941CDCCCCCCF4EC284100000020736F5941CDCCCCCCF5EC2841000000C0796F59419A999999F6EC2841CDCCCC8C806F594133333333F7EC2841CDCCCC4C856F5941CDCCCCCC0EED2841CDCCCC4C856F59419A99999955ED284166666666886F5941CDCCCCCC03EE2841333333D38E6F5941CDCCCCCC11EE2841CDCCCC4C916F59413333333319EE2841CDCCCCEC906F59410000000020EE2841CDCCCCEC946F5941000000004BEE28419A9999F99E6F59419A9999996CEE28419A999959A66F5941CDCCCCCC6BEE2841666666A6AA6F59419A99999966EE28419A9999D9AB6F59413333333368EE2841CDCCCCCCAC6F59419A9999997BEE284100000060B36F5941CDCCCCCC95EE284100000040BA6F594100000000A3EE284166666606C06F59419A999999C4EE284166666646C56F59410000000001EF284166666666D06F5941CDCCCCCC2DEF28419A999919DB6F5941CDCCCCCC59EF284100000020E36F59413333333396EF2841CDCCCCACEA6F594133333333C1EF284133333393E86F5941CDCCCCCCD7EF28419A999979E96F59419A999999F2EF2841333333F3EB6F5941CDCCCCCC13F02841333333B3EE6F5941000000002BF02841666666E6EF6F59416666666649F02841CDCCCCACF66F5941CDCCCCCC3BF028419A9999D9FB6F59416666666624F02841333333330070594100000000F3EF28419A9999D9077059410000000086EF28419A99991915705941CDCCCCCC7BEF284100000060177059410000000060EF28419A9999991D7059413333333339EF2841CDCCCCEC217059416666666610EF2841CDCCCC0C2570594133333333F0EE2841333333332970594133333333E0EE2841000000202D70594133333333BBEE2841CDCCCC8C34705941CDCCCCCCAEEE2841CDCCCCCC38705941666666669FEE2841000000E03A7059416666666693EE2841000000003E7059419A99999986EE284133333313407059419A99999980EE284166666606417059413333333364EE2841000000E045705941CDCCCCCC52EE2841CDCCCCCC49705941666666668AEE284133333353527059419A999999C8EE28419A9999B95A705941333333330EEF2841666666C663705941666666664AEF2841333333B36A7059410000000059EF28419A9999796C7059419A99999966EF2841333333D36D705941CDCCCCCC5EEF28419A99991970705941333333334FEF28419A9999B9727059410000000041EF2841666666E6757059416666666639EF2841333333F3767059413333333328EF2841000000C077705941666666661EEF2841000000C07970594166666666F7EE2841000000A07C705941CDCCCCCCEBEE28419A9999F97F7059419A999999D3EE28416666664683705941CDCCCCCCC6EE28419A9999B9857059419A999999A8EE28419A999939877059419A99999995EE2841CDCCCCCC897059416666666669EE2841333333F38C7059413333333342EE284133333373907059419A99999936EE28413333335392705941333333331EEE284166666686997059416666666612EE28419A9999D99B7059410000000004EE2841000000E09C705941CDCCCCCCF6ED2841666666C69E70594100000000CDED2841666666E6A070594133333333BBED28419A999979A1705941CDCCCCCCA9ED28419A999959A3705941333333338BED284166666626A1705941CDCCCCCC6EED2841000000409F705941CDCCCCCC55ED2841333333539F70594100000000CCEC284100000000A5705941CDCCCCCC8CEC28419A9999F9A6705941CDCCCCCC3CEC284166666686A97059416666666624EC284166666686A97059419A999999DAEB284133333393AE70594166666666CBEB28419A9999D9B070594133333333BEEB2841666666C6B070594100000000B0EB28419A9999F9B07059419A9999999FEB28419A9999B9B07059419A99999991EB284166666606B0705941CDCCCCCC8CEB2841333333B3B2705941CDCCCCCC91EB284100000040B57059416666666680EB2841666666A6BA705941000000007DEB28419A999939BD7059419A9999995DEB2841000000A0C8705941	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	01010000206A080000DC498F8828F92841CDCCCC0C9B6F5941	210150000	Z	Antigny-la-Ville	2101500	21015	21	27	8
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	01010000206A0800005A9B4FEFB1692A4134333343B68E5941	210160000	Z	Arceau	2101600	21016	21	27	22
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	01060000206A08000001000000010300000001000000EC0000009A999999B28829413333335344755941000000007889294133333333697559419A9999997089294133333393717559419A999999D08929416666668681755941CDCCCCCC4E8A2941333333D392755941000000009F8A29419A9999199B7559419A999999CE8A2941000000C0A1755941333333330F8B2941333333B3B4755941333333333F8B29419A999939CF755941CDCCCCCCC48B29419A999939F27559419A999999AD8C2941666666C62D765941CDCCCCCCCE8C29419A9999D9247659419A999999328D2941CDCCCC6C1876594166666666548D2941CDCCCC0C12765941CDCCCCCC1F8E2941000000A00B765941CDCCCCCC4E8E2941CDCCCC8C0476594133333333098F2941000000C0FD7559419A999999409029419A999979F075594100000000EB90294133333313F1755941CDCCCCCC45922941333333B3F3755941CDCCCCCC5492294100000060F575594133333333C2922941CDCCCCCCF4755941666666664E932941000000C0EC7559419A999999B493294100000060E3755941CDCCCCCC3094294133333333D6755941666666668794294133333333D175594133333333D29429419A999999C87559419A999999F0942941000000A0C0755941333333336A952941CDCCCCECB475594133333333A99529419A9999D9B2755941CDCCCCCC5196294133333393AA755941333333336696294100000040AA7559419A999999789629419A9999F9AE755941CDCCCCCC039729419A999919AD755941CDCCCCCCC4972941CDCCCCCCAD755941666666661F982941CDCCCC8CAC755941000000001B98294133333353A675594100000000B5982941CDCCCC2CA375594133333333B2982941333333F39F755941CDCCCCCCCD9B29416666662681755941CDCCCCCCAD9D2941CDCCCCEC7475594166666666419E29413333333373755941CDCCCCCCD89E2941CDCCCCAC72755941CDCCCCCC199F2941333333737075594100000000DF9F2941CDCCCC6C66755941CDCCCCCC36A02941333333935F7559419A9999994BA02941CDCCCC2C607559419A99999905A129413333337354755941CDCCCCCCA8A12941666666664975594100000000F4A12941333333B3427559410000000093A22941000000203B7559413333333314A42941000000A0217559416666666663A429419A9999D91C755941333333337BA429419A9999391D75594133333333D0A4294100000000187559419A99999955A529419A9999D91A755941CDCCCCCC53A52941000000A016755941CDCCCCCCBFA5294166666686197559413333333368A6294100000020057559410000000005A729419A999939F574594166666666EFA7294133333353D87459416666666623A8294166666666D5745941333333335DA82941000000E0CB745941CDCCCCCCC9A8294100000020C5745941CDCCCCCCFFA8294133333373BE7459410000000052A92941000000A0B17459410000000070A929419A999999AB7459416666666687A929419A9999B9A274594166666666AAA92941333333F39C74594100000000F2A929419A9999798774594100000000FFA92941333333F38174594100000000E2A929413333333377745941CDCCCCCCE7A92941CDCCCC2C737459413333333320A92941000000806F7459419A9999994BA92941666666A643745941CDCCCCCC96A92941000000A045745941CDCCCCCCD2A929419A9999591D7459419A999999E4A92941000000600F7459419A999999F6A92941CDCCCCCC087459416666666604AA2941CDCCCCCCFD7359419A99999910AA2941CDCCCC4CFD7359416666666621AA29419A999939F17359413333333380AA294133333313E07359413333333330AA29419A9999F9DB7359419A9999993DAA2941333333B3D7735941666666661FAA294166666606D5735941000000005FAA2941000000E0C573594133333333C4AA294166666626CB7359419A999999ABAB29419A999999D9735941CDCCCCCCFBAB2941333333F3DA7359419A99999918AD2941333333F3E17359413333333311AD2941333333B3E7735941000000009FAD2941000000C0E873594133333333B2AE2941000000C0EC735941CDCCCCCC9CAF2941CDCCCC8C09745941CDCCCCCCE2B02941000000C01374594100000000E2B12941CDCCCC8C13745941333333334EB3294100000020FB735941000000007EB32941000000A0F67359413333333388B32941333333D3E673594100000000BCB329419A999959D773594100000000A2B32941666666A6D473594133333333E3B3294100000080BD735941CDCCCCCC57B429413333337399735941CDCCCCCC64B42941333333D37C7359419A9999996AB429419A999939797359410000000065B42941000000C0687359419A99999937B429419A9999593E7359419A9999991EB429419A999919377359419A99999969B32941000000000F7359416666666644B32941333333D3107359413333333333B32941666666C60D735941CDCCCCCCC6B2294133333353EF72594166666666CFB2294133333353E37259419A999999C4B22941CDCCCC6CDF7259419A9999992FB2294166666626CA7259419A999999CAB12941666666E6D17259419A999999A3B12941333333D3D07259419A9999997FB1294166666686CA7259419A99999916B1294133333393BB725941CDCCCCCCD0B02941666666A6AF7259419A99999971B02941CDCCCCAC9B725941CDCCCCCCEFAF294133333373A47259413333333395AF29419A999919AD725941000000005BAF2941000000E0B3725941000000001DAF294166666606BD72594133333333F1AE2941CDCCCC8CC17259419A99999986AE2941CDCCCC0CBB7259419A9999990BAE294100000060B7725941333333330DAE29419A9999D9BE725941CDCCCCCCF4AD294133333393CD72594133333333C6AD2941CDCCCC6CCD7259416666666644AD2941000000E0CF7259413333333313AD294100000020D27259419A99999957AC29419A999959DD72594133333333FBAB294166666686DE7259416666666681AB294133333353E27259416666666612AB2941000000A0E77259419A999999C3AA294166666666EC7259419A99999983AA29419A9999B9F17259410000000051A92941000000A00673594133333333B5A829419A9999390E73594133333333C3A82941000000802673594100000000AEA72941666666462D735941CDCCCCCC69A729419A9999792F735941CDCCCCCC73A72941CDCCCCCC34735941CDCCCCCC34A62941CDCCCC0C3D7359413333333361A42941666666E64A73594133333333A3A329419A9999F951735941CDCCCCCC8FA32941333333B34B7359419A9999993BA32941666666464F73594166666666B2A22941000000402F735941666666663CA22941000000202D73594100000000A7A029410000008037735941000000008FA029419A9999B9267359419A9999995AA029419A9999D90E735941CDCCCCCC33A0294133333393FF7259419A99999901A029419A999959FF72594133333333AE9F29410000006001735941333333339C9F2941CDCCCC2CF2725941CDCCCCCC599F294133333393F37259419A999999249F294100000080F872594133333333119E2941333333D3F9725941CDCCCCCCD79D2941666666A6F9725941CDCCCCCCD29D294133333353FF72594166666666A59D2941333333D31573594166666666A19D2941666666E61F735941CDCCCCCC5A9D2941666666E62A73594166666666369D2941CDCCCC2C24735941CDCCCCCC2C9C2941666666A62A7359419A999999729B2941CDCCCCCC32735941666666660A9B2941000000E0347359419A999999ED9A29410000000034735941000000003B9A2941000000403E735941333333334D9A2941CDCCCC6C44735941333333332D9A2941000000A04673594100000000229829419A999939557359413333333324982941CDCCCC4C5E7359410000000063972941CDCCCC4C5E735941333333335F972941666666A66373594133333333F5962941666666A6627359419A999999DC9629413333337361735941CDCCCCCCEF9529419A9999D95F73594100000000829529419A9999B9647359419A999999FF942941CDCCCC2C8073594133333333C6942941000000808E73594100000000939429419A999939977359413333333362942941000000609C73594133333333F99329419A9999999E73594133333333A693294133333333A57359419A999999399329419A9999F9AB7359419A999999E592294133333333B57359419A99999997922941CDCCCC6CB9735941CDCCCCCC5192294100000080BF73594100000000D891294133333353C673594166666666A79129419A999939CA735941CDCCCCCC7D912941CDCCCC6CCA7359413333333307912941666666C6C47359413333333392902941333333D3C7735941000000007D902941CDCCCCACCA735941333333337390294133333393D3735941CDCCCCCC5F902941CDCCCC8CDA735941333333335C9029419A999979EA7359413333333310902941CDCCCCACF7735941CDCCCCCCF48F294166666686FA7359419A999999BF8F294100000080FB73594166666666818F29413333339303745941000000007B8F2941333333930874594166666666958E29419A9999D913745941CDCCCCCC318E2941333333331A74594100000000FE8C2941CDCCCC0C2A7459419A999999408C2941333333F33A74594166666666B78B29419A9999794D74594133333333958B2941666666064F74594100000000B38B29419A9999395F74594166666666E48B2941666666C6757459419A9999991A8C2941333333738B74594133333333B38B2941CDCCCC0C90745941CDCCCCCCD48A2941666666A698745941CDCCCCCCEB892941666666E6A5745941CDCCCCCCB9892941CDCCCC8CAA745941666666668A89294166666686AC74594133333333A589294100000040B6745941CDCCCCCC0B8A2941333333F3C274594100000000268A294133333393C774594166666666618A294133333393DC745941CDCCCCCC998A2941CDCCCCECF274594100000000C38A29413333337308755941CDCCCCCCB78A2941333333931575594133333333A08A29419A9999D919755941000000003F8A29419A9999D920755941CDCCCCCC008A29419A9999991E755941000000004189294100000020337559416666666639892941000000A0377559419A999999B288294133333353447559419A999999B28829413333335344755941	01010000206A08000054BA2A8D769A2941CDCCCC5C67745941	210170000	Z	Arcenant	2101700	21017	21	27	10
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	01010000206A0800008EC7224AA1912941CDCCCCBCC3825941	210180000	Z	Arcey	2101800	21018	21	27	3
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	01010000206A080000F22E5DF3C0BC284133333343257C5941	210200000	Z	Arconcey	2102000	21020	21	27	15
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	01010000206A080000DE8C651B7B6F2A41000000D0A68A5941	210210000	Z	Arc-sur-Tille	2102100	21021	21	27	23
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	01010000206A0800000CB660D7730C2A4166666626946C5941	210220000	Z	Argilly	2102200	21022	21	27	34
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	01010000206A08000088A6352F1FC628419A999979C2715941	210230000	Z	Arnay-le-Duc	2102300	21023	21	27	12
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	01010000206A080000CCEE93847FCF284100000090B2935941	210240000	Z	Arnay-sous-Vitteaux	2102400	21024	21	27	12
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	01010000206A080000349A00A732642841000000302FAF5941	210250000	Z	Arrans	2102500	21025	21	27	11
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	01010000206A080000602A6835635828419A9999C99AB15941	210260000	Z	Asnières-en-Montagne	2102600	21026	21	27	28
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	01010000206A080000129B8D68E1122A41CCCCCC7C718F5941	210270000	Z	Asnières-lès-Dijon	2102700	21027	21	27	5
01060000206A08000001000000010300000001000000DE0100000000000084BC2A41333333D3E97E5941333333338ABE2A41666666662B7F5941333333337FBE2A41333333B32F7F59416666666671BE2A419A999919357F5941CDCCCCCC5ABE2A41CDCCCCCC3D7F59410000000030BE2A41333333334E7F59419A99999929BE2A41CDCCCCAC507F5941CDCCCCCC15BE2A4100000060587F5941CDCCCCCC05BE2A41333333735E7F59416666666602BE2A419A9999D95F7F594100000000F0BD2A41333333D3667F594166666666D9BD2A41000000806F7F5941CDCCCCCCD3BD2A419A999999717F594100000000BABD2A41000000807A7F59419A999999A5BD2A41000000C0817F59416666666696BD2A4133333353887F5941666666668BBD2A41CDCCCCAC8C7F59416666666685BD2A41333333138F7F5941CDCCCCCC7ABD2A41CDCCCC4C937F59416666666677BD2A419A9999F9947F5941CDCCCCCC77BD2A419A999939967F5941666666667ABD2A41CDCCCC4C977F59413333333381BD2A41CDCCCC4C987F5941666666668CBD2A4166666606997F59419A999999E3BD2A41333333139D7F5941CDCCCCCCF5BD2A41CDCCCCEC9D7F59413333333318BE2A41CDCCCC8C9F7F5941333333335BBE2A419A9999B9A27F594133333333BBBE2A4100000040A77F594100000000CCBE2A41CDCCCC8CAA7F5941CDCCCCCC41BF2A41666666A6C17F5941CDCCCCCC4CBF2A41CDCCCCCCC37F59416666666668BF2A4100000040C97F5941CDCCCCCCDABF2A41666666C6CE7F59410000000082C02A41000000E0D67F5941CDCCCCCC90C02A4166666626D87F594166666666DDC02A419A999999DE7F59419A99999965C12A4100000020EA7F5941CDCCCCCCC9C12A419A999999F27F5941666666660BC22A4166666626F87F5941CDCCCCCC49C22A4166666666FD7F59419A9999998BC22A4100000000038059419A999999A0C22A41CDCCCC4C048059419A999999AFC32A416666666615805941CDCCCCCC1FC42A41333333731C8059416666666657C42A41333333F31F8059419A99999969C42A4100000020218059419A99999985C42A419A9999D9228059419A999999EEC42A410000008029805941CDCCCCCC02C62A41000000E03A8059419A99999923C62A41333333F33C805941CDCCCCCCDEC62A419A9999B94880594166666666EFC72A41666666E659805941CDCCCCCCF3C72A41CDCCCC6C598059419A999999F5C72A41CDCCCC2C59805941CDCCCCCC0BC82A4100000020568059413333333322C82A410000008052805941CDCCCCCC32C82A41666666664F8059413333333340C82A419A9999594C8059419A9999994AC82A419A9999D948805941CDCCCCCC55C82A41CDCCCC4C44805941CDCCCCCC60C82A419A9999F93E8059410000000062C82A41CDCCCC6C3E8059416666666668C82A41666666463B805941CDCCCCCC6AC82A419A9999193A805941000000007CC82A419A999919328059416666666682C82A41000000202F8059413333333387C82A41333333F32C8059419A999999A6C82A41666666461E8059419A999999B6C82A41CDCCCC6C2280594166666666CEC82A41333333732780594133333333EAC82A41666666A62D80594166666666EEC82A419A9999992E8059419A99999900C92A419A999939328059410000000009C92A413333337334805941666666660CC92A419A999959358059416666666614C92A413333337338805941CDCCCCCC1CC92A41000000603B8059419A9999991FC92A41666666A644805941CDCCCCCC2AC92A419A9999994C805941CDCCCCCC3BC92A41666666C650805941000000004FC92A41CDCCCC0C54805941CDCCCCCC65C92A41CDCCCC0C58805941CDCCCCCC7FC92A419A9999995C80594100000000CFC92A41333333B36A8059419A9999990ACA2A419A9999596F8059410000000030CA2A41CDCCCCEC6F8059413333333370CA2A41333333F371805941CDCCCCCC71CA2A41333333F3718059419A999999C1CA2A41666666066B8059419A99999902CB2A41CDCCCC8C6F8059419A999999E1CD2A41CDCCCC6C538059419A999999D5CE2A41CDCCCCCC4980594166666666B9CE2A41333333534F8059419A999999FECE2A410000006047805941CDCCCCCC14CF2A416666664644805941CDCCCCCCEECF2A4133333393228059416666666620D02A419A9999991F8059410000000078D02A419A9999D91C80594133333333ACD02A41666666E6128059419A99999920D12A41CDCCCCAC078059416666666670D12A419A9999F9FF7F594166666666A5D12A41000000E0FC7F5941333333333DD22A4166666606F77F5941333333333FD22A41333333F3F67F59413333333357D22A4166666606F67F5941CDCCCCCC6CD32A41666666E6EA7F5941666666668BD32A419A999999E97F59419A99999973D42A41666666E6DC7F59410000000090D52A419A999959CD7F59419A999999B7D52A4133333393CA7F59419A999999ABD52A4133333333C97F5941CDCCCCCC19D62A419A999919C07F59419A99999974D62A41666666A6B87F5941000000006BD72A4133333353A47F5941000000006CD72A41CDCCCCACA27F59419A9999996DD72A41333333539F7F5941CDCCCCCC70D72A41000000C09C7F59413333333371D72A41333333539C7F59416666666674D72A41333333B3997F59413333333374D72A4166666626987F5941333333336ED72A41000000E0957F59416666666664D72A4166666626947F59419A99999959D72A41000000A0927F59410000000048D72A4133333333907F59413333333343D72A41CDCCCCAC8F7F59410000000039D72A41CDCCCCEC8E7F5941333333334CD72A41000000608D7F594166666666A4D72A4100000000877F59419A999999C4D72A4100000020857F594166666666CBD72A41000000E0847F59419A999999D1D72A41666666A6847F5941CDCCCCCCDDD72A4166666646847F5941CDCCCCCCF2D72A4100000040837F5941000000000DD82A41666666A6807F5941000000001ED82A41000000607F7F5941CDCCCCCC3AD82A419A9999B97C7F59416666666645D82A419A9999797B7F59419A9999994BD82A41333333B37A7F5941666666665AD82A41CDCCCC0C7A7F59413333333367D82A41666666C6797F5941CDCCCCCC6ED82A41CDCCCC0C7A7F5941CDCCCCCC79D82A41666666467A7F5941CDCCCCCC87D82A41000000A0797F5941CDCCCCCCC9D82A419A999999747F5941666666661AD92A419A9999F96E7F5941000000001DD92A41666666C66E7F5941CDCCCCCC43D92A41666666666C7F5941333333334FD92A41333333336C7F5941666666665ED92A41000000806B7F59419A999999B3D92A4100000080687F594133333333AADA2A419A999939607F5941CDCCCCCC5ADB2A41000000405A7F59419A9999994ADB2A41000000A04C7F59419A99999966DB2A419A9999994B7F59419A99999972DB2A41666666264B7F5941666666667EDC2A4133333353417F59416666666663DC2A4133333333367F59416666666661DC2A4100000040347F59410000000074DC2A41666666662D7F5941CDCCCCCC88DC2A4100000080257F5941333333339DDC2A419A9999B91D7F594100000000A2DC2A41666666061C7F594166666666ABDC2A4100000020177F594100000000ADDC2A4133333393167F594100000000BADC2A4133333393127F594100000000C6DC2A41333333530F7F594133333333DADC2A419A9999790B7F594133333333EDDC2A4100000020087F5941CDCCCCCC01DD2A419A9999D9037F59410000000023DD2A41CDCCCC6CFD7E59410000000039DD2A4100000040FA7E59416666666655DD2A419A999959F67E59419A9999996FDD2A4100000060F37E59419A9999995CDD2A41CDCCCCCCED7E5941CDCCCCCC50DD2A4166666646EA7E59413333333338DD2A4100000000E37E59413333333332DD2A419A999939E17E59419A99999921DD2A419A999979DC7E59419A99999920DD2A419A9999F9DB7E5941CDCCCCCC1CDD2A41000000A0D97E5941333333331DDD2A41CDCCCC4CD77E5941000000001FDD2A41CDCCCC8CD47E5941666666661FDD2A419A999999D37E5941CDCCCCCC1BDD2A419A999939CE7E5941CDCCCCCC1ADD2A4133333333CD7E59419A99999919DD2A41CDCCCCECCB7E59416666666611DD2A4100000000C97E594133333333F6DC2A41666666A6C27E594100000000E2DC2A419A999979BD7E594100000000C9DC2A419A9999B9B67E594166666666BCDC2A4166666686B37E59413333333370DD2A419A9999B9A57E59413333333338DD2A419A9999999E7E59419A9999992BDD2A41000000A09C7E59419A999999E0DC2A419A999919917E594100000000D9DC2A41CDCCCC2C907E5941CDCCCCCCDCDD2A41333333B37B7E59410000000092DD2A41666666466F7E59419A999999D1DD2A419A9999396A7E5941CDCCCCCC28DF2A41333333F34E7E5941CDCCCCCC5DDF2A419A9999394F7E594166666666B0DF2A41666666064F7E59413333333309E02A419A9999994C7E5941333333332EE02A41000000C05B7E5941CDCCCCCC66E02A4166666646597E5941CDCCCCCC86E02A4133333353577E59413333333398E02A41CDCCCC4C547E594166666666A9E02A41000000E0507E59419A999999D3E02A4100000080497E594133333333ECE02A419A9999F9467E5941000000002CE12A4100000040407E5941CDCCCCCC47E12A41333333B33C7E59416666666650E12A41000000003B7E5941CDCCCCCC53E12A419A9999193A7E5941CDCCCCCC55E12A4100000020397E59413333333357E12A41000000E0357E59416666666660E12A419A9999992B7E5941CDCCCCCC5CE12A41333333D32A7E59419A9999995AE12A41000000602A7E594100000000D8E02A41333333D3217E59419A999999D1E02A4166666666217E59419A999999CBE02A419A9999D91F7E594100000000CBE02A419A9999791E7E59419A999999CFE02A41000000201D7E594133333333D5E02A41666666861B7E59419A999999D9E02A41CDCCCCEC197E594166666666D9E02A419A999999187E594133333333D6E02A4133333353177E594166666666CFE02A4100000080167E594133333333C4E02A41000000E0157E594100000000BFE02A41666666C6157E594100000000ABE02A419A999939157E59416666666697E02A41666666C6147E5941000000008AE02A4133333373147E59416666666685E02A4166666646147E59419A99999965E02A419A999959077E5941666666664BE02A4166666686087E59419A999999D6DF2A41666666E60C7E59419A9999993ADF2A41666666E60E7E5941666666666DDE2A41000000400A7E594133333333BDDD2A4166666686027E59410000000059DD2A41CDCCCC4CF87D59416666666611DD2A4166666606F17D594133333333AEDC2A4133333393DA7D59416666666685DC2A41333333D3C27D59416666666639DC2A4166666606977D5941666666663DDC2A419A9999F9887D59416666666659DC2A4133333313797D59413333333397DC2A419A9999D9617D5941CDCCCCCCF2DC2A41666666E6517D59410000000040DD2A4133333333437D5941000000005CDD2A419A999979317D5941CDCCCCCC6DDD2A41CDCCCC0C197D59419A99999971DD2A419A999999087D594133333333AFDD2A41CDCCCCECEE7C594133333333F2DD2A4100000040DC7C59416666666609DE2A41CDCCCC8CCA7C59413333333324DE2A4133333353A57C5941000000005CDE2A4133333313807C594133333333C0DE2A41CDCCCCCC5D7C59419A99999976DF2A41CDCCCCEC327C59416666666615E02A4133333373127C5941666666662CE02A4166666626007C59410000000021E02A419A9999F9E87B594100000000AFDF2A41CDCCCCACCD7B5941CDCCCCCC6DDF2A41CDCCCC6CB47B59410000000031DF2A41CDCCCC2C947B5941CDCCCCCCFBDE2A419A9999B9847B594166666666E1DE2A41333333137D7B59413333333392DE2A41000000E06A7B59419A9999991EDE2A41000000E05C7B5941333333339BDD2A4100000080637B59419A99999991DD2A419A9999F9637B5941000000008FDD2A4100000020647B59410000000078DD2A419A999959657B5941333333331EDD2A419A9999196A7B59410000000021DD2A41000000C06D7B5941CDCCCCCC1FDD2A419A999919707B5941000000001CDD2A41CDCCCC6C727B59419A99999916DD2A419A999999747B5941333333330DDD2A41666666E6787B59419A99999907DD2A41666666467C7B5941CDCCCCCC03DD2A419A9999F97E7B59416666666601DD2A41CDCCCC0C827B5941CDCCCCCC00DD2A419A999999857B59419A99999900DD2A4100000040897B59416666666601DD2A419A9999398B7B5941CDCCCCCC01DD2A41666666868C7B59416666666603DD2A41000000008F7B59416666666605DD2A4133333393917B5941CDCCCCCC06DD2A4100000020947B594166666666DCDC2A41000000C0997B59419A999999CCDC2A41000000009C7B59416666666678DC2A4100000000A87B59413333333398DB2A419A999959C87B59419A99999933DB2A41333333D3D67B5941CDCCCCCCB6DA2A41333333D3E87B5941CDCCCCCC69DA2A41CDCCCC0CF47B59419A99999959DA2A4166666626F67B5941333333334EDA2A41000000A0F77B59416666666649DA2A41CDCCCC2CF87B59413333333323DA2A4166666666007C59419A999999C6D92A41000000E00D7C59410000000088D92A419A999979177C5941CDCCCCCCB1D92A41333333B31D7C59413333333343DA2A41666666E62F7C59416666666656DA2A4166666666327C5941000000003FDA2A41000000C0357C59419A9999991FDA2A4166666646397C5941CDCCCCCCFBD92A41333333133D7C594100000000E0D92A419A9999D93F7C59419A999999C8D92A41000000E0437C5941CDCCCCCCBAD92A41000000A0467C594100000000A9D92A41666666A6497C5941666666669BD92A41000000204D7C59419A999999ABD92A41000000204F7C5941666666669FD92A41333333D3527C59416666666685D92A41333333F35A7C5941000000005FD92A41CDCCCCEC657C5941CDCCCCCC4AD92A41CDCCCCEC6A7C59413333333333D92A419A999959707C59410000000014D92A419A999919777C59419A999999A3D82A41333333D38C7C59410000000090D82A4133333333917C59419A99999985D82A4100000060937C5941333333337FD82A41CDCCCC6C957C59416666666679D82A419A999959977C59416666666659D82A419A9999B9A17C59419A99999942D82A419A999919A97C59419A999999BED72A41CDCCCC8CBB7C5941CDCCCCCCA8D72A4100000020B87C59419A99999970D72A4133333393BD7C59410000000026D72A41666666C6C47C59419A99999914D72A41333333B3C67C5941333333331DD72A41666666A6C77C59410000000055D72A419A999959CF7C59419A99999964D72A41666666E6D17C594166666666CED72A419A999919E57C59419A999999E0D72A41CDCCCC6CE77C59416666666607D82A41000000E0FA7C59416666666605D82A4166666606FD7C59419A999999FDD72A419A9999D9017D59419A999999F3D72A41CDCCCC4C077D594166666666F0D72A41CDCCCCAC087D594100000000E8D72A41333333D30B7D594166666666D5D72A419A999919177D59419A999999CAD72A41CDCCCC4C1C7D594100000000C9D72A41666666061E7D594166666666C2D72A419A9999791D7D594133333333ACD72A41333333B31A7D59419A9999998BD72A419A9999F91D7D59410000000066D72A419A9999B9217D59416666666631D72A4166666686257D5941CDCCCCCC18D72A419A999919287D59419A999999E9D62A41666666662D7D594100000000F6D62A419A9999992F7D59419A99999936D72A4100000080387D59416666666640D72A41333333B33A7D59410000000074D72A41333333F3437D594133333333DDD62A41333333134E7D59416666666606D72A41666666465F7D5941CDCCCCCCAAD62A419A9999D9627D594166666666B8D62A41666666A6667D59410000000010D72A41333333137C7D5941CDCCCCCC21D72A41666666E6807D59410000000031D72A4100000040817D5941666666660BD72A41000000C0847D594133333333F7D62A41666666A6867D59410000000078D62A419A9999B9907D59419A99999958D62A41CDCCCC2C937D5941CDCCCCCC4ED62A41000000C0937D59410000000048D62A41CDCCCC6C937D5941000000003FD62A4133333393937D59419A99999937D62A4133333333947D5941000000001CD62A41333333F3957D59416666666602D62A4133333353977D594166666666C3D52A419A9999599A7D59419A999999B2D52A41000000E09A7D594166666666ABD52A419A9999D99A7D5941CDCCCCCCA3D52A41CDCCCCAC9A7D5941000000009DD52A41666666C6997D5941CDCCCCCC86D52A4133333373957D5941333333337AD52A4100000020947D59410000000072D52A4133333313947D5941CDCCCCCC61D52A41CDCCCC2C947D5941CDCCCCCCF8D42A41666666269A7D594133333333F2D42A41000000409B7D594166666666F5D42A41CDCCCC8C9D7D59419A99999900D52A419A999979A27D594133333333B3D42A41CDCCCC0CA77D5941CDCCCCCC5BD42A419A999959AB7D5941CDCCCCCC20D42A41000000A0AC7D59413333333300D42A41333333F3AD7D594133333333EED32A41000000C0AE7D594100000000F7D22A4166666666BB7D5941CDCCCCCCD2D22A419A999959BD7D594166666666A8D22A419A9999F9BF7D59410000000079D22A419A999959C37D5941CDCCCCCCBFD12A4166666606D17D594133333333BAD12A41CDCCCC6CD17D59419A999999AAD12A41CDCCCC8CCF7D5941CDCCCCCC94D12A41CDCCCC4CD17D594133333333C7D02A419A9999B9E17D59419A999999BAD02A4100000000E37D5941CDCCCCCCA0D02A4166666646E17D5941CDCCCCCC8AD02A41666666C6DF7D59410000000077D02A41CDCCCC6CDE7D59416666666655D02A4100000080DB7D594166666666E7CF2A41CDCCCCACCE7D59419A999999D7CF2A419A999939CA7D59419A99999983CF2A41666666A6CF7D59416666666657CF2A419A999979D27D59416666666608CF2A4100000060D87D5941CDCCCCCCF9CE2A41666666C6D97D594100000000F5CE2A41CDCCCC2CD87D594133333333F1CE2A41CDCCCC0CD67D594133333333DBCE2A4100000040D87D5941CDCCCCCCE8CE2A419A999979DB7D59419A999999C3CE2A4100000040E57D59419A999999AFCE2A41000000C0E57D59419A99999986CE2A41000000C0E67D5941666666661ACE2A41CDCCCC6CE97D594100000000EFCD2A41CDCCCC0C097E594166666666CDCD2A419A9999F9087E594133333333C0CD2A41CDCCCC2C097E594100000000BACD2A41333333B30C7E59419A99999990CD2A41000000C00C7E5941CDCCCCCC68CD2A41CDCCCCCC0C7E59410000000067CD2A419A999939107E59419A999999F1CC2A41000000C0107E594166666666D6CC2A41666666C6107E59419A99999977CC2A419A999959127E5941CDCCCCCC58CC2A419A9999D9127E594100000000C4CB2A4133333333167E5941CDCCCCCC98CB2A41CDCCCCCC177E59416666666645CB2A419A9999F91A7E59416666666648CB2A41333333131C7E5941CDCCCCCC58CB2A41333333D3227E5941CDCCCCCC8ACB2A4133333333297E59419A9999995ACB2A41000000802A7E5941666666661ACB2A41CDCCCC2C2C7E5941666666667ECA2A41CDCCCC0C307E59413333333370CA2A41CDCCCCAC307E5941CDCCCCCC25CA2A419A9999D9327E594133333333CDC92A4100000060357E594166666666D6C92A41333333133B7E594166666666D7C92A41666666C63B7E5941CDCCCCCCA6C92A41666666C63D7E5941333333331DC82A41333333F3497E5941666666661CC82A419A9999D94B7E59419A9999999BC72A41666666664E7E5941CDCCCCCC00C72A41666666C6507E5941CDCCCCCC7DC62A4133333373527E594100000000EEC52A4100000020547E594133333333BAC52A41CDCCCC8C547E59410000000055C52A4100000000547E59419A999999B5C42A41333333D3527E5941CDCCCCCC56C42A41333333B3517E5941000000002CC42A41333333D3517E5941333333336FC32A41000000A0537E5941CDCCCCCCEEC22A41000000C0547E594100000000E7C02A41666666067B7E59419A999999A1C02A4166666626807E594100000000B5BF2A419A999999917E59413333333315BF2A41CDCCCC6C9D7E594100000000E1BE2A4166666646A07E59410000000052BE2A419A9999F9AB7E59410000000040BE2A4166666666AD7E59419A9999990BBE2A4166666606B27E59410000000056BD2A4166666606C27E59416666666600BD2A419A999979CC7E59419A999999DDBC2A41000000A0D37E594133333333C4BC2A419A9999F9D87E5941CDCCCCCCAEBC2A41CDCCCC6CDD7E59413333333391BC2A4166666626E47E5941CDCCCCCC87BC2A419A999999E77E59410000000084BC2A41333333D3E97E5941	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	01010000206A08000047A132349DD52A4166666616E87D5941	210280000	Z	Athée	2102800	21028	21	27	10
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	01010000206A08000054468D9C283B284100000040E5A05941	210290000	Z	Athie	2102900	21029	21	27	6
01060000206A080000010000000103000000010000004604000033333333D14A2941333333D3027759419A999999DB4A2941333333D30277594100000000DE4A2941333333D302775941CDCCCCCCF64A2941CDCCCC4C03775941333333330A4B2941000000A004775941000000001C4B2941666666E60677594166666666474B29419A9999390E775941666666664C4B2941000000201077594166666666534B294100000080127759419A999999654B2941CDCCCC4C16775941333333336B4B29416666660618775941666666667A4B2941CDCCCC2C1A775941CDCCCCCCBB4B2941CDCCCCEC1F77594166666666CA4B294100000040207759419A999999DA4B2941CDCCCC0C20775941CDCCCCCCFD4B2941666666861F775941333333333E4C2941666666A61D77594166666666644C2941333333B31B775941666666667B4C29419A9999791977594100000000824C29419A9999991877594133333333B24C29419A9999391277594166666666CA4C2941CDCCCCEC0F77594100000000E14C2941000000800E775941CDCCCCCCF84C2941000000E00D77594100000000054D2941666666060D775941666666662A4D2941CDCCCCAC0577594133333333464D2941333333F302775941CDCCCCCC5D4D2941666666A60277594133333333714D2941333333F3027759419A9999997C4D29413333335304775941666666668F4D2941CDCCCC4C0877594133333333974D29419A9999590977594166666666A84D2941333333B30A7759419A999999B64D2941000000E00A77594166666666CC4D2941333333530A775941CDCCCCCCE74D29419A9999D90877594166666666F54D2941CDCCCC6C07775941CDCCCCCC044E294100000060047759419A9999990F4E29419A9999390377594133333333364E2941666666C601775941333333334E4E294166666686017759419A999999554E29419A99999901775941CDCCCCCC634E2941CDCCCCCC01775941CDCCCCCC8A4E2941CDCCCCEC0677594100000000994E29410000004008775941CDCCCCCCA24E2941666666A60877594100000000BD4E29419A99995907775941CDCCCCCCC74E29419A9999790577594133333333D54E2941333333330477594166666666DB4E2941CDCCCC2C0377594166666666E54E2941CDCCCC8C027759419A999999FF4E2941CDCCCCEC01775941CDCCCCCC134F294133333313027759419A9999992A4F2941333333F30277594133333333414F2941333333F3027759419A999999604F294100000040047759419A999999854F29410000000005775941CDCCCCCC944F29419A99991905775941CDCCCCCCB54F2941CDCCCC6C047759419A999999E54F294133333353047759410000000018502941000000E004775941000000002750294166666646057759410000000030502941CDCCCC8C0577594133333333455029410000002007775941000000005E50294133333393057759419A99999966502941CDCCCC0C05775941CDCCCCCC8C502941CDCCCCAC0277594100000000A150294166666666017759419A999999C350294166666646FF76594100000000EE50294166666626FD76594166666666F250294166666606FC765941CDCCCCCCF950294100000000FA7659419A9999991C5129419A9999F9F4765941333333332C512941000000C0F07659419A9999993F512941333333F3EE765941CDCCCCCC5651294166666626E87659419A9999997D51294100000040E27659416666666687512941CDCCCC2CDE765941000000008F51294166666626D8765941000000007F51294100000020D57659419A9999997251294166666626CE7659416666666659512941CDCCCC8CC3765941CDCCCCCC5651294166666606C17659419A99999958512941000000C0BC7659419A9999996051294133333313B97659410000000077512941CDCCCCECB1765941CDCCCCCCA7512941666666E6B276594100000000C6512941666666E6B3765941CDCCCCCCEA512941666666E6B17659419A999999EB5129419A9999B9B076594166666666F2512941CDCCCCACAD765941000000000152294100000000AB7659419A9999990E52294100000060A7765941CDCCCCCC14522941CDCCCCCCA27659413333333317522941666666069A765941333333331C5229419A9999D996765941CDCCCCCC26522941CDCCCC8C947659416666666641522941000000A0917659410000000050522941000000A0907659419A99999969522941333333538E765941CDCCCCCC7C522941333333138D7659410000000077522941CDCCCC6C8B7659416666666649522941333333338D7659419A999999125229419A9999798E765941CDCCCCCC065229419A9999398F76594133333333005229419A9999199076594100000000EF512941666666468E765941CDCCCCCCF8512941000000E08C7659410000000035522941CDCCCC6C87765941000000004F5229413333331385765941CDCCCCCC92522941333333538276594166666666C35229419A9999F98076594133333333E55229416666660680765941CDCCCCCCE652294133333313807659413333333312532941000000A080765941CDCCCCCCB15329419A9999397D765941CDCCCCCC21542941666666A67B765941000000002A542941CDCCCCCC7B765941CDCCCCCC355429419A9999797C7659419A99999971542941333333F36D765941CDCCCCCC835429419A9999596B7659410000000098542941333333736576594133333333A8542941000000E06176594100000000B0542941000000805E76594166666666B7542941666666865C76594166666666CC5429419A9999F958765941CDCCCCCCDE5429419A9999D95676594166666666F75429413333337351765941CDCCCCCC0F552941000000E04A765941666666661E552941333333D3457659419A9999993F552941000000803276594100000000705529413333335323765941CDCCCCCC915529419A9999191C765941000000009F552941666666A616765941CDCCCCCCA8552941666666860F76594100000000AB5529419A99991902765941CDCCCCCC9F5529419A999999F675594100000000A6552941CDCCCC4CF0755941CDCCCCCCD7552941333333B3EF755941CDCCCCCCE1552941000000E0F2755941CDCCCCCC0356294133333313FC75594100000000135629419A999959027659419A99999917562941CDCCCC0C067659419A99999919562941CDCCCCAC097659413333333318562941666666E610765941CDCCCCCC0C5629419A9999791E765941666666660B56294133333393247659413333333315562941666666E62E7659419A99999926562941666666E63B76594100000000355629419A999999467659419A9999993E562941000000C04D765941000000004A5629419A9999B9567659413333333366562941333333935E765941CDCCCCCC7D562941CDCCCC8C667659416666666687562941CDCCCC2C697659410000000097562941333333136C765941333333339D562941000000E06E7659416666666688562941CDCCCCCC767659410000000086562941CDCCCCAC7A765941333333338C562941666666E67E765941CDCCCCCC96562941000000408276594166666666A5562941CDCCCC6C8676594166666666B4562941333333D38B7659419A999999B9562941000000808F76594133333333BD562941666666669176594100000000C5562941000000609576594133333333C9562941666666669776594100000000D2562941333333B39B7659413333333348582941000000008D7659410000000094582941CDCCCC0C8A7659410000000097592941000000E07F7659419A9999994C5B29419A9999B96E7659419A999999A45C2941000000406176594133333333145D2941333333F35D76594100000000505D2941333333735B765941333333337C5D29419A9999795A76594133333333D35D2941666666A6557659419A999999145E29419A9999B95276594166666666465E2941000000E0507659419A9999995D5E2941000000005076594100000000975E2941000000404F7659419A999999CA5E2941666666264E76594100000000245F29419A9999D94C76594133333333385F2941CDCCCC8C4C765941000000006C5F2941666666464B765941CDCCCCCCA05F29416666660649765941CDCCCCCCB65F2941000000004876594100000000E45F2941666666864576594166666666F75F29419A9999F943765941000000000D602941666666C6417659410000000035602941CDCCCC8C3C765941333333334C602941666666E63876594166666666596029419A9999D937765941CDCCCCCC696029419A99999936765941CDCCCCCC89602941CDCCCC6C3576594100000000B360294100000080337659419A999999DB602941CDCCCCEC317659419A999999EC6029419A99995931765941CDCCCCCC036129419A9999F9307659419A9999996D612941333333932E765941CDCCCCCC77612941333333532D7659410000000087612941666666262E765941CDCCCCCCAB612941000000602E76594100000000D96129419A9999992D76594133333333FE612941333333B32C7659419A999999336229419A9999F92B7659410000000064622941333333D32B7659413333333365622941333333D32B765941CDCCCCCC95622941000000202C76594166666666B6622941CDCCCCEC2B76594166666666EC6229419A9999992C765941000000002B6329419A9999392C765941666666667F632941CDCCCC0C2B76594166666666DC632941333333B32A765941CDCCCCCC14642941666666C629765941333333334F642941000000602876594100000000A7642941666666A62776594166666666EE64294100000080277659419A99999938652941CDCCCCCC2776594166666666756529410000000028765941333333339D652941333333D32776594166666666D1652941333333132876594100000000E7652941CDCCCC2C287659419A9999993A662941CDCCCC0C2976594133333333526629419A999939297659416666666682662941666666A629765941CDCCCCCCAC662941333333132A7659419A99999977662941666666C6217659410000000053662941000000E01B765941CDCCCCCC176629416666668613765941CDCCCCCCEE652941000000600D7659419A999999D6652941CDCCCC6C0B76594100000000BC6529416666666608765941CDCCCCCC9765294133333393057659419A999999756529416666666603765941333333335F6529413333337300765941CDCCCCCC506529419A999979FE7559413333333338652941CDCCCCCCF8755941333333331C652941CDCCCC8CF27559419A99999917652941666666A6EF755941CDCCCCCC096529419A999939EB755941000000000665294166666666E87559410000000003652941666666E6E4755941666666660365294166666686E37559419A99999901652941000000C0E0755941CDCCCCCC02652941CDCCCCCCDE755941CDCCCCCC0365294100000020DD755941CDCCCCCC0765294166666606DC755941666666660E652941CDCCCC8CDA7559413333333320652941CDCCCC8CD47559419A99999923652941666666E6D1755941666666662C6529419A9999F9CC7559410000000034652941000000C0CA755941333333333E65294166666686C775594166666666446529419A9999F9C5755941666666664D652941333333B3C27559419A9999995365294166666606C1755941666666665C652941000000A0BE755941000000006565294166666646BC75594166666666FB652941666666C69175594166666666E56529410000004090755941CDCCCCCCD6652941333333738E75594133333333C8652941333333938B7559419A999999B5652941666666A688755941CDCCCCCCA5652941333333F385755941000000005E6529419A9999D986755941666666665D6529419A99999983755941000000005C6529419A99999978755941CDCCCCCC5C6529416666662670755941000000005A652941666666A66A7559413333333364652941000000205F755941CDCCCCCC646529419A9999F94F755941CDCCCCCC6A652941333333B34E755941CDCCCCCC6E652941333333934D75594133333333726529419A9999194C7559419A99999972652941000000204B755941CDCCCCCC7365294100000020497559419A999999746529419A999999477559410000000075652941333333D345755941CDCCCCCC7565294166666666427559419A999999736529419A999919407559416666666672652941666666663E755941CDCCCCCC716529416666660638755941CDCCCCCC7165294133333333367559419A99999972652941CDCCCC2C327559413333333374652941CDCCCCAC2E7559419A999999746529419A9999592C7559410000000075652941666666C62A75594166666666766529413333337328755941CDCCCCCC796529413333337325755941000000007D652941666666A623755941666666667F652941333333D32175594100000000816529410000000020755941CDCCCCCC82652941000000A01D7559413333333383652941CDCCCCAC1B7559419A99999983652941666666261A755941CDCCCCCC84652941CDCCCC8C187559410000000084652941CDCCCC8C157559419A9999997F6529419A99993913755941333333337F652941666666A611755941CDCCCCCC7B6529416666660610755941CDCCCCCC76652941000000200E7559419A99999973652941666666860C7559416666666671652941666666E60A75594133333333706529419A9999F908755941000000006C652941000000200675594133333333696529419A999939037559419A999999676529419A999939027559410000000062652941666666A6FE745941CDCCCCCC6065294166666666FD745941000000005F652941CDCCCCCCFA745941CDCCCCCC6065294100000040F6745941CDCCCCCC606529419A9999F9F274594133333333616529419A999919EF74594166666666646529419A999939EC745941000000006765294133333373EA7459419A9999996A65294100000020E8745941CDCCCCCC6B65294166666626E7745941666666666E652941CDCCCC8CE47459419A9999996F65294100000020E1745941333333336D6529419A999919DF7459419A99999968652941CDCCCCECD8745941333333336465294133333373D6745941666666665E652941CDCCCC8CD4745941CDCCCCCC57652941CDCCCC2CD2745941000000004D652941333333F3CE7459419A999999446529419A999979C9745941CDCCCCCC3F6529419A999979C47459419A999999406529419A999999BE745941CDCCCCCC4165294133333313B97459419A999999416529419A999919B7745941333333334165294166666626B47459410000000048652941CDCCCCECAE7459419A999999526529419A999959A87459419A99999957652941000000A0A57459419A99999973652941333333D3A27459416666666684652941CDCCCC4CA1745941333333338D65294166666686A0745941CDCCCCCCA26529419A9999F99D7459419A999999B8652941CDCCCCEC9B74594133333333C6652941666666E69974594166666666D9652941000000A0947459410000000004662941CDCCCCCC847459413333333312662941000000807E7459419A99999917662941333333737A745941CDCCCCCC20662941000000C07374594100000000216629419A999999737459413333333333662941333333336A745941666666663C662941333333F363745941000000003F6629413333333359745941CDCCCCCC43662941333333F35074594100000000476629419A9999B94A745941CDCCCCCC416629419A9999F942745941666666663F6629419A9999F93F7459419A9999993A662941666666063A7459416666666633662941666666863274594133333333336629416666660630745941CDCCCCCC4E66294133333333287459419A999999556629419A99993926745941333333336B662941333333F3137459416666666677662941666666260C74594100000000816629416666662606745941666666668A66294166666626017459419A9999998E662941666666A6F57359419A99999987662941CDCCCC8CE9735941CDCCCCCCA566294166666686E6735941CDCCCCCCB566294100000000E573594133333333C2662941CDCCCC4CE373594133333333D6662941000000A0E17359419A999999E366294133333373DF735941CDCCCCCCF2662941666666A6DD73594133333333FD662941333333B3DB7359419A99999906672941000000A0D9735941666666661267294100000040D6735941666666661B6729419A9999B9D47359413333333321672941666666C6D27359413333333334672941CDCCCC6CCF735941666666663E67294100000020CE7359416666666646672941000000C0CC735941000000004F67294100000020CB7359419A9999995D672941333333B3C67359419A99999965672941CDCCCCCCC4735941000000007067294100000000C37359419A9999997B67294166666666C0735941000000008B6729419A9999B9BD735941666666669A672941666666C6BB73594100000000AB67294166666646BA73594100000000BA6729419A9999B9B873594100000000C667294166666626B773594100000000D6672941CDCCCCECB573594166666666E567294133333353B473594100000000F567294100000020B3735941CDCCCCCCFE672941CDCCCC4CB2735941CDCCCCCC0468294100000060B1735941666666660D68294133333333B0735941CDCCCCCC17682941CDCCCCECAE735941CDCCCCCC1F68294166666686AD7359419A9999992F682941CDCCCC4CAB7359410000000042682941666666C6A97359419A9999995268294133333373A87359410000000066682941333333B3A6735941CDCCCCCC7D682941000000E0A4735941CDCCCCCC8C682941333333D3A37359419A9999999C682941000000E0A273594166666666B26829419A999939A17359419A999999C8682941CDCCCC4C9F73594100000000D8682941333333D39D735941CDCCCCCCED682941333333939C7359410000000006692941333333339B735941CDCCCCCC16692941666666A69A7359416666666627692941CDCCCC2C9A735941666666663B692941333333D398735941000000004C692941CDCCCC4C97735941666666666569294100000060957359419A999999796929419A99997993735941000000008B692941666666869173594100000000A2692941000000808F735941CDCCCCCCB7692941CDCCCC0C8D7359419A999999C5692941000000608B73594166666666D66929419A999999887359419A999999E5692941666666C68573594166666666F1692941000000608373594133333333036A2941CDCCCC2C8073594133333333116A2941333333D37D73594100000000226A2941000000007B735941000000002C6A29413333333378735941CDCCCCCC386A2941000000A07473594100000000426A2941000000E07173594100000000516A2941000000E06E735941CDCCCCCC5C6A29419A9999796B735941CDCCCCCC666A2941CDCCCCCC68735941CDCCCCCC706A2941CDCCCC2C66735941666666667C6A29419A9999B96373594100000000896A2941666666266173594166666666996A2941CDCCCC6C5E735941CDCCCCCCA76A2941666666265C735941CDCCCCCCB06A29419A9999195A7359419A999999BF6A2941000000405773594133333333CA6A2941666666865573594133333333D76A2941000000605373594166666666E86A2941333333534E73594166666666466B29419A9999394E73594100000000EE6B2941000000004E735941CDCCCCCCCD6B2941000000E0317359419A999999716B29413333331321735941333333330F6B2941333333D3FD7259419A9999991C6B294133333353F7725941666666661B6B294166666686F67259419A9999991C6B2941CDCCCC8CF37259419A999999256B2941CDCCCC0CEF7259419A999999306B294100000020EB725941000000003E6B294166666606E6725941CDCCCCCC446B29419A999979E0725941CDCCCCCC4A6B294100000080DC72594100000000526B2941CDCCCC6CD8725941CDCCCCCC546B294133333373D1725941CDCCCCCC596B29419A999999C9725941CDCCCCCC586B294100000000C07259419A999999586B294166666606BE72594100000000526B2941CDCCCC6CB2725941666666664D6B2941666666A6A8725941666666664B6B294133333393A07259419A999999426B29419A9999D99A725941CDCCCCCC376B29416666664695725941666666661C6B29419A9999598A7259419A9999990C6B2941000000A0867259419A999999F86A2941333333738372594166666666E86A29419A9999198072594100000000DA6A2941333333337C7259419A999999D16A2941333333337872594166666666CD6A29416666662676725941CDCCCCCCCB6A29419A9999597572594100000000CB6A29410000006071725941CDCCCCCCCC6A2941666666666E7259419A999999D16A2941333333136C72594100000000DD6A29419A9999396A72594166666666F76A2941CDCCCC0C67725941CDCCCCCC0A6B2941CDCCCC0C64725941000000000D6B2941CDCCCCAC63725941CDCCCCCC276B2941CDCCCC4C60725941333333334D6B2941CDCCCC2C5C725941333333335E6B2941333333935A7259419A9999996B6B2941000000C0597259419A999999776B29410000006059725941000000007E6B2941CDCCCCCC5872594133333333826B2941666666E65572594100000000926B2941333333D35472594133333333996B2941666666465472594166666666A36B29419A99999953725941333333334C6B2941666666064272594166666666446B2941000000E03F72594166666666316B29419A9999593C7259419A999999206B2941CDCCCC2C39725941CDCCCCCC136B2941CDCCCC2C3672594100000000096B29419A9999B93372594100000000006B29419A9999B9317259419A999999F66A2941333333B32E725941CDCCCCCCF26A2941333333132B72594166666666F06A2941CDCCCCEC2772594133333333D36A2941666666860B72594100000000D06A2941CDCCCC4C0A72594133333333D06A29410000006008725941CDCCCCCCDA6A2941333333F304725941CDCCCCCCE36A29419A999979037259419A999999086B2941CDCCCCAC04725941333333330A6B29419A9999390272594133333333126B29413333337300725941CDCCCCCC236B2941CDCCCC6CFF7159419A999999336B2941666666A6FD715941666666663D6B294100000060FC71594166666666436B294100000060FB715941333333333F6B294100000060FA71594100000000376B2941666666A6F8715941333333333F6B294100000040F77159419A999999496B2941333333D3F571594166666666596B2941333333D3F4715941666666666C6B294166666626F471594166666666816B2941333333B3F371594133333333976B294166666686F371594100000000AE6B2941CDCCCC8CF3715941CDCCCCCCC56B294166666666F371594100000000E66B29419A999919F37159419A999999FF6B2941CDCCCCECF271594133333333146C294100000080F2715941CDCCCCCC216C2941000000E0F1715941000000002F6C2941CDCCCCCCF0715941CDCCCCCC2F6C2941000000C0F071594166666666236C2941333333F3ED71594133333333276C2941333333B3EA7159419A999999286C294133333333E6715941333333332E6C2941CDCCCCECE2715941CDCCCCCC2B6C294133333333E071594166666666356C2941CDCCCC6CDC71594100000000376C2941CDCCCCECD7715941666666663E6C2941CDCCCC6CD2715941000000003C6C2941CDCCCC6CCF71594166666666356C2941CDCCCCACCB7159419A999999316C294166666626CA715941000000002B6C2941333333B3C7715941CDCCCCCC266C29419A9999B9C371594100000000206C29419A999939BF7159419A9999990F6C2941000000C0BA71594166666666036C2941CDCCCCCCB871594133333333FB6B2941CDCCCC8CB6715941CDCCCCCCF46B294133333313B271594166666666F26B294100000020AE71594133333333126B2941666666069A715941000000009D6A2941000000808F71594100000000066A294133333353717159419A9999991D6A2941666666866F715941000000003B6A2941333333736B715941CDCCCCCC486A29419A999999677159419A999999AD6A294100000060727159419A999999F96A29419A9999997271594166666666FB6A29419A9999D971715941333333330B6B2941666666A65F715941000000002B6B2941000000A051715941CDCCCCCC696B294166666646447159419A9999996D6B2941666666E643715941CDCCCCCCC46B2941000000C0337159419A9999990A6C29419A9999D926715941CDCCCCCCBF6C2941666666C60F71594100000000536D2941000000400D71594133333333786D29419A9999990C7159419A999999046E2941333333330A71594133333333A36F29410000002003715941000000009870294166666626F5705941333333337D7029419A999959F27059416666666666702941CDCCCCCCF0705941666666664D70294166666626EF7059419A9999992C7029419A999959EC705941CDCCCCCC0C70294166666686E97059419A999999EC6F294166666666E67059419A999999CB6F29419A9999F9E1705941CDCCCCCCB76F294100000080E0705941CDCCCCCCA36F294100000020DF70594166666666816F294133333393DC705941333333335D6F29419A999939D9705941CDCCCCCC296F2941CDCCCC8CD47059419A999999226F2941666666E6D370594133333333026F2941000000E0D070594100000000EC6E2941CDCCCC2CCF70594166666666E36E294166666686CE70594166666666C86E294166666606CD705941CDCCCCCCAA6E294100000040CB70594133333333946E2941CDCCCC6CC9705941CDCCCCCC7D6E294166666606C770594133333333696E2941CDCCCC2CC470594166666666526E2941CDCCCCECC0705941000000003B6E2941CDCCCC0CBE705941333333332D6E294166666666BC70594166666666206E29419A9999D9BA70594133333333066E294166666686B77059419A999999F76D294166666606B5705941CDCCCCCCEE6D29419A999919B37059419A999999E66D29419A999979B07059419A999999DD6D2941333333B3AE70594100000000D26D294100000000AD70594100000000BD6D294133333313A87059419A999999AE6D294133333393A5705941CDCCCCCCA86D2941CDCCCC2CA370594166666666886D2941666666E69D705941CDCCCCCC806D2941666666869B70594133333333766D29413333331399705941CDCCCCCC536D29410000004094705941CDCCCCCC4F6D29416666668692705941000000003B6D2941333333B38F70594166666666256D2941666666268D7059419A999999186D2941000000608C705941CDCCCCCC0A6D2941000000E08C70594166666666F96C2941666666A68D7059419A999999E96C2941333333938E70594166666666D26C2941CDCCCC6C9070594100000000BE6C2941CDCCCC2C927059419A999999B06C2941333333F3937059419A9999998F6C29413333337399705941CDCCCCCC716C2941000000609C705941CDCCCCCC596C2941666666C69E70594100000000486C2941CDCCCC2CA0705941333333331D6C2941000000C0A470594133333333F26B2941CDCCCC8C9D70594100000000C46B29413333331396705941666666668D6B2941CDCCCC6C907059419A9999994A6B2941333333D388705941CDCCCCCCDF6A2941666666068170594100000000966A2941CDCCCC0C7B70594100000000736A2941000000407870594100000000026A29419A9999796F705941000000007169294100000000647059419A9999994469294133333313607059419A99999935692941666666465E705941CDCCCCCC03692941333333335870594133333333AE682941000000204A7059416666666687682941333333F342705941CDCCCCCC62682941CDCCCC0C3E705941666666661E682941CDCCCC6C38705941CDCCCCCCDD672941CDCCCC8C337059416666666669672941666666862E70594133333333036729419A9999F92B70594166666666886629419A9999992870594100000000736629410000000028705941CDCCCCCC2E662941666666E62470594166666666F865294100000040227059416666666662652941CDCCCC8C0F705941CDCCCCCC2965294133333333FE6F5941CDCCCCCCE764294100000020EA6F594133333333DE64294133333333E76F5941CDCCCCCCD56429419A999999E46F5941CDCCCCCCC96429419A999939E16F594133333333B864294166666646DC6F594133333333AD64294166666626D96F594100000000A76429419A999959D76F59419A9999998F642941000000C0D06F59419A99999988642941CDCCCCCCCE6F59419A999999FF632941CDCCCC0CA86F594133333333E66329419A9999D9A06F59416666666602642941CDCCCC2C966F59419A999999EB6329419A9999F97A6F5941CDCCCCCCBE6329419A9999596B6F59410000000089632941000000A0566F5941000000001F632941000000E0576F5941CDCCCCCCF9612941000000C05C6F594100000000A7612941666666665E6F59416666666661612941000000A05F6F594166666666CC602941000000C0606F5941CDCCCCCCBB602941CDCCCCCC4B6F5941CDCCCCCCB1602941666666263F6F594100000000A5602941666666662F6F59419A999999136029419A999919316F5941666666660460294166666646326F59419A999999265F2941000000803C6F59419A999999E25E29419A9999393F6F594133333333455E294100000000436F5941CDCCCCCCC75D29419A999939466F5941CDCCCCCC4C5D2941666666E6496F594166666666415D29419A9999394A6F594133333333D85C2941666666C64D6F5941333333335E5C294133333333526F5941000000003A5C294100000040546F59419A9999991B5C2941CDCCCC4C546F594100000000FA5B2941CDCCCC2C546F594100000000E65B294100000040556F59419A999999205B2941666666E6576F594133333333A05A29419A999939556F594100000000955A2941666666465B6F59419A9999996B5A29419A9999795C6F59419A999999695A29419A9999F95F6F5941CDCCCCCC5E5A2941333333D3626F5941000000005A5A2941333333D3666F594100000000545A2941666666A66C6F594133333333575A294133333373716F5941CDCCCCCC5C5A294166666666736F59419A999999615A294166666606A46F594100000000635A294166666686AF6F594166666666675A294100000080B36F594100000000765A294133333373B96F59419A999999825A2941333333B3BE6F5941666666668D5A2941CDCCCC2CC56F594100000000905A2941CDCCCC6CCA6F5941000000008C5A2941333333D3CE6F59419A9999997F5A2941333333D3D96F5941000000007C5A2941CDCCCC4CDD6F594133333333785A2941333333B3E06F594133333333765A294166666606E36F594133333333635A2941000000E0F96F5941000000005E5A2941000000C0FB6F594166666666585A2941666666A6FE6F5941000000005A5A2941000000200070594133333333645A2941CDCCCC6C03705941333333336F5A2941666666C609705941CDCCCCCC755A2941666666060F705941666666667F5A2941333333F3177059419A999999835A2941CDCCCCAC1B7059419A999999875A2941333333331F70594100000000915A29419A9999392670594100000000935A29419A9999193570594166666666985A2941666666C636705941CDCCCCCC925A29419A9999F93A70594166666666905A29419A9999F94270594133333333845A2941000000A0497059419A9999997D5A2941CDCCCCCC4E705941666666667D5A29416666662658705941000000008B5A29419A9999595A705941CDCCCCCC7A5A2941000000C069705941666666666E5A2941CDCCCC6C72705941666666666B5A2941CDCCCC0C7B70594133333333605A2941CDCCCC2C89705941666666665F5A29419A99991990705941666666665B5A2941333333B3A9705941333333334B5A294166666606B5705941000000004A5A2941333333F3B870594166666666485A2941CDCCCC0CBF7059419A9999994F5A29419A999999C170594133333333465A294166666646C8705941CDCCCCCC345A2941000000C0D470594166666666305A2941333333D3D7705941333333331D5A2941CDCCCC0CEF70594100000000175A29419A9999B9F7705941333333330E5A29410000002001715941CDCCCCCC0C5A2941000000C00B715941333333330C5A2941000000201171594100000000115A29419A9999591771594100000000215A2941666666E61B7159419A9999991F5A2941000000A02071594166666666235A29410000004024715941666666661D5A29419A999999297159419A9999991C5A2941666666262C7159419A999999225A2941CDCCCCEC3171594100000000215A29413333331338715941CDCCCCCC115A2941CDCCCCEC41715941CDCCCCCCF9592941333333F34F7159419A999999F0592941CDCCCC6C5D71594100000000E1592941000000406E715941CDCCCCCCDA592941666666267571594133333333D9592941CDCCCCCC7771594166666666D259294166666646827159419A999999C5592941CDCCCC4C88715941CDCCCCCCB5592941333333138D71594166666666B2592941333333138E71594100000000A55929419A99999991715941666666669959294100000060957159419A9999998B592941666666269771594166666666845929416666662698715941000000007A592941333333B399715941000000006A592941333333F39A7159416666666656592941000000C09C7159416666666642592941CDCCCC4C9D715941666666662A592941333333139E71594166666666175929419A9999D9A57159419A999999155929419A999959A8715941CDCCCCCC175929419A999999A9715941000000001E5929419A999919AB7159410000000028592941333333D3AB7159410000000034592941CDCCCCCCAB715941333333334A59294100000000AB715941333333335959294100000060AE7159419A9999995C5929419A999979B1715941000000005F5929419A9999F9B47159419A9999995B5929419A999939BA715941666666664F5929419A9999B9BD7159416666666648592941000000C0BF715941666666662759294133333353C8715941CDCCCCCCF658294166666666D5715941CDCCCCCCC95829419A9999F9DC715941CDCCCCCCA658294166666606E57159419A99999983582941000000A0EB715941CDCCCCCC7E58294100000060EE715941333333337A58294100000020F1715941CDCCCCCC78582941000000E0F471594133333333855829419A9999D9F7715941CDCCCCCC97582941CDCCCC4CFE71594133333333A0582941CDCCCCCC01725941CDCCCCCCCD582941000000E00372594166666666F4582941666666060572594133333333C0582941666666262972594133333333C0582941CDCCCC6C2C72594100000000C0582941CDCCCC8C2C7259419A999999BE582941333333732D72594166666666BE582941333333132E72594133333333BE582941666666462F72594166666666BF58294133333313317259419A999999C0582941CDCCCC6C3272594166666666CA582941000000803672594166666666CC5829410000004038725941CDCCCCCCCE582941000000C0397259419A999999D1582941666666463B725941CDCCCCCCD6582941CDCCCCCC3D72594133333333DD58294100000060427259419A999999DF58294133333353447259419A999999CE5829419A9999B94F7259419A999999B5582941666666A6607259419A999999B05829410000002064725941666666669B58294100000060727259419A9999999758294166666686747259416666666693582941CDCCCCCC767259413333333390582941CDCCCC4C7C72594133333333905829419A9999398172594133333333985829419A9999B989725941333333337B5829419A999979997259410000000073582941CDCCCCCC9A725941333333336E582941000000A09B725941000000006A582941333333739D7259419A9999996858294133333373A0725941000000006958294100000080A1725941CDCCCCCC695829419A999959A37259419A9999996958294133333333A5725941000000006B582941CDCCCC2CA7725941CDCCCCCC6A582941CDCCCC6CA87259419A9999996D5829419A999959AA725941666666666D58294133333393AB725941666666666E582941000000C0AE72594166666666725829419A999939B47259410000000077582941666666A6B8725941CDCCCCCC7F582941333333B3BC7259413333333384582941333333F3C07259419A9999998858294166666606C57259410000000091582941666666C6C7725941CDCCCCCC945829419A999999C972594133333333A5582941CDCCCCECCD7259419A999999A9582941666666E6D1725941CDCCCCCCD1582941CDCCCCECDE725941000000007F58294133333393F47259419A9999993D582941CDCCCCEC147359410000000027582941666666C6187359410000000015582941CDCCCC0C1873594133333333015829419A999939177359419A999999E757294100000060167359419A999999DB57294133333373157359419A999999D457294133333373147359413333333376572941666666C60E7359419A999999005729416666660611735941CDCCCCCCEC5629416666660611735941CDCCCCCCDC562941333333B31173594133333333DA5629419A9999D910735941CDCCCCCCD55629410000004010735941CDCCCCCCCB562941333333930F735941CDCCCCCCBF562941333333F30E73594166666666AF562941666666260E73594166666666975629419A9999F90C735941CDCCCCCC81562941000000000C735941666666666D562941333333D30A735941CDCCCCCC5F562941333333D309735941666666665356294166666646087359419A99999947562941CDCCCCAC06735941000000003E562941CDCCCCEC047359416666666635562941000000E0027359419A9999992D562941000000A000735941CDCCCCCC2456294133333313FE725941666666660B56294166666686F572594133333333B9552941CDCCCCECDC725941CDCCCCCC92552941333333F3D17259419A99999989552941000000C0CF7259419A9999997455294166666626CC7259413333333326552941CDCCCC0CBF7259419A999999105529419A999959BB72594133333333FD54294166666646BC7259419A999999EA54294133333333BD725941CDCCCCCCE15429419A999999BD725941CDCCCCCCE15429419A9999D9BE72594133333333E854294133333353C572594166666666E054294100000020C672594166666666D054294100000020C7725941CDCCCCCCB2542941CDCCCC2CC87259413333333379542941CDCCCC0CCB7259410000000082542941CDCCCC2CCD725941CDCCCCCC83542941666666C6CE72594166666666865429419A999979D0725941666666668B542941CDCCCCCCD172594133333333935429419A999959D3725941333333339D5429419A9999F9D472594166666666A754294166666646D672594133333333B354294100000060D772594166666666C2542941333333F3D872594100000000CA542941CDCCCCCCD972594133333333CE54294166666646DA725941CDCCCCCCD4542941CDCCCCCCDB725941CDCCCCCCDC5429419A999919DE725941CDCCCCCC2955294100000040ED7259419A999999495529419A9999F9F572594166666666685529416666666600735941666666666D5529413333335305735941000000006F5529419A9999190A735941CDCCCCCC6E552941333333D30D7359419A9999996E5529410000004010735941666666666D5529419A999959167359419A9999996B552941CDCCCC6C1B735941000000006C552941000000A01E7359419A99999970552941333333B3237359410000000076552941CDCCCC4C26735941CDCCCCCC7B55294133333373297359410000000081552941666666062C735941CDCCCCCC82552941666666862E7359419A999999815529410000004036735941666666667F552941000000203A7359419A99999979552941333333533E735941CDCCCCCC7155294166666666437359419A99999967552941666666A64773594166666666FC542941666666C6647359419A999999A7542941000000E06573594100000000A4542941000000E06A735941333333337E542941CDCCCC2C6C7359413333333354542941000000C06C7359419A9999992E5429416666664689735941000000001C542941CDCCCCCC9A7359416666666638542941000000009E7359410000000019542941666666C6A57359419A999999D4532941000000A0B7735941CDCCCCCCB7532941CDCCCC6CC4735941CDCCCCCCD753294100000060C573594100000000D4532941000000A0C873594100000000C853294166666666C973594166666666965329419A999979CC73594166666666915329419A9999B9D87359419A9999999B53294133333333DC73594133333333E15329419A9999F9DE7359410000000000542941000000E0E1735941333333331454294100000080E37359410000000025542941CDCCCCCCE4735941666666663354294166666646E573594133333333425429419A9999B9E5735941CDCCCCCC75542941000000C0EA735941CDCCCCCC86542941333333F3E97359410000000098542941CDCCCC8CE97359419A999999A954294166666626E97359419A999999B8542941CDCCCC4CE9735941CDCCCCCCC4542941000000C0E973594133333333CB542941CDCCCCECE973594100000000DF5429419A9999B9EA73594166666666D75429419A9999B9EC73594166666666CB54294133333353EF73594100000000B9542941CDCCCCCCF27359419A99999997542941000000A0F8735941666666668D54294166666666FA735941CDCCCCCC8554294166666686FC735941333333337D5429419A999999FF7359419A999999735429419A99995904745941000000006C54294166666666087459419A99999993542941333333930A7459413333333389542941333333730D74594133333333835429419A99991910745941CDCCCCCC7C5429410000002013745941CDCCCCCC7654294133333373167459416666666671542941666666261A7459419A9999996C5429419A9999191E745941CDCCCCCC68542941333333532174594166666666655429419A9999B926745941CDCCCCCC54542941666666664C74594133333333715429419A9999D95374594100000000C65429419A9999F95D74594133333333B2542941000000005F74594133333333B054294100000040607459419A999999D8542941333333F365745941CDCCCCCCD4542941333333336B745941666666661E55294100000060767459413333333348552941CDCCCC4C7C7459410000000037552941CDCCCC0C847459416666666641552941CDCCCCCC8B7459416666666682552941333333B395745941CDCCCCCCDC552941333333D3AC74594133333333E255294100000020B174594100000000F0552941000000C0B57459419A99999948562941000000A0C6745941333333334B57294100000020E6745941CDCCCCCC67572941CDCCCC4CE8745941000000009F5729419A999939EA7459419A999999A957294166666686EA745941CDCCCCCCC1572941333333B3EB745941CDCCCCCCEC572941CDCCCC4CEE74594100000000F6572941000000E0EE745941333333331958294133333333F174594100000000385829419A9999D9F67459419A99999940582941000000E0F8745941666666665D582941000000C0FF7459419A9999994258294133333373057559419A999999385829419A999999077559419A999999145829419A9999190975594166666666BA5729419A9999991275594133333333C4572941333333531775594100000000AD572941000000201975594166666666A7572941000000201B75594166666666C5572941333333D31B75594133333333CF5729419A9999D91C755941CDCCCCCCE3572941000000001F75594166666666DB5729419A9999D9227559419A999999A4562941666666E63175594133333333B1562941CDCCCC2C36755941CDCCCCCCB15629419A9999193875594166666666AF562941333333F339755941CDCCCCCCA55629419A9999193C7559413333333398562941000000A03D755941000000004D5629419A99995944755941CDCCCCCC3D5629419A9999B9457559419A999999F8552941666666E64775594100000000A4552941000000C04B7559419A99999981552941666666664E755941666666665F5529410000000052755941CDCCCCCC48552941CDCCCC2C56755941333333333C5529419A9999B9597559413333333334552941666666E65B755941CDCCCCCC2A5529413333335360755941CDCCCCCC2755294100000040647559419A99999929552941CDCCCCCC6A755941333333332A5529419A9999D96D7559410000000031552941CDCCCCAC737559416666666642552941CDCCCC4C7F7559410000000042552941CDCCCC8C807559419A99999998552941CDCCCCACAE7559416666666699552941CDCCCC8CB07559419A999999A75529419A9999F9C275594133333333AF552941CDCCCC8CCE75594133333333B3552941666666C6D6755941CDCCCCCCB2552941CDCCCCECD9755941CDCCCCCCB2552941CDCCCCECDA75594100000000AF552941666666E6DE755941666666669755294133333333E37559416666666654552941666666A6EA7559419A99999941552941333333F3ED755941333333331B552941666666A6F675594100000000E6542941666666C6FD755941CDCCCCCCC5542941CDCCCCECFF755941CDCCCCCCA55429413333335301765941CDCCCCCC87542941CDCCCCEC01765941CDCCCCCC4D542941333333330276594133333333385429419A9999F9027659419A999999FB5329419A9999990B765941CDCCCCCCB6532941333333730376594100000000755329416666668604765941333333335A53294133333393F7755941000000003A532941000000E0F4755941CDCCCCCC4B5329419A999999EF7559413333333348532941666666C6EE755941CDCCCCCC3D532941666666E6EC7559419A9999992C5329419A9999B9EE755941CDCCCCCCF752294166666686F5755941CDCCCCCCDD522941CDCCCC0CF97559419A999999CA52294133333393FB7559419A9999999F5229419A999959017659419A999999765229419A99991907765941666666664B522941CDCCCC0C0C765941CDCCCCCC21522941000000C010765941CDCCCCCC1D5229419A9999391176594100000000F851294166666626157659419A999999CB512941666666861A7659419A999999C4512941000000A01B7659416666666654512941666666062676594100000000AE502941CDCCCCAC2E7659419A99999988502941000000A03076594166666666DE4F29419A9999793976594166666666DC4F29419A99999939765941CDCCCCCCBA4F2941333333533B76594100000000F04E2941CDCCCC8C417659419A999999834D2941000000C06276594100000000604D29419A9999D967765941CDCCCCCC344D29410000008068765941CDCCCCCCF54C2941CDCCCC4C6E76594166666666F04C29419A9999B97376594133333333EA4C29419A9999B97E76594100000000CF4C2941333333538976594100000000CA4C2941666666668F765941000000000F4C29419A999979BA765941CDCCCCCC344C294166666686C8765941000000005E4C2941CDCCCC0CD276594166666666354D294100000020E3765941333333332C4D29419A9999B9E376594100000000084D2941CDCCCCECE47659419A999999D24C29419A999939E776594100000000D84B294133333313F276594100000000FF4B2941000000A0FE7659419A999999A64B2941666666A602775941CDCCCCCC1E4B2941CDCCCC8CF6765941666666660F4B2941CDCCCC2CF87659419A999999E84A294100000000FF7659419A999999D84A2941666666A60177594133333333D14A2941333333D302775941	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	01010000206A080000698DD6E887602941000000E027735941	210300000	Z	Aubaine	2103000	21030	21	27	16
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	01010000206A08000090BB7E36C75D2A4100000000D4735941	210310000	Z	Aubigny-en-Plaine	2103100	21031	21	27	6
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	01010000206A0800001A023B7C7E122941333333138D635941	210320000	Z	Aubigny-la-Ronce	2103200	21032	21	27	12
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	01060000206A08000001000000010300000001000000B10000006666666698182941666666A6818559413333333307192941666666869085594166666666EF182941CDCCCCECA48559419A9999993C192941666666C6AF855941CDCCCCCC8B1929419A999959B885594133333333B71929419A999939C985594133333333301A2941333333B3E8855941333333334F1A2941666666A6F9855941666666664F1A2941000000E0178659419A999999641A2941CDCCCC4C1D8659419A999999211A29413333331323865941666666661F1A2941333333733586594100000000111A294166666666438659419A999999FE1929419A9999B9608659419A999999F0192941000000606F865941CDCCCCCCEC192941666666A6898659419A999999C3192941666666669E865941666666669B192941CDCCCC0CAA86594133333333601A29419A9999B9BF86594133333333491C2941000000A0F8865941CDCCCCCCB71C294100000040018759419A999999191D294166666666E486594133333333721D294133333353D086594100000000C11D294100000000C0865941CDCCCCCC371E294166666666AE86594133333333911E2941CDCCCC0CA88659419A9999993A1F2941000000209F8659419A9999998D202941666666C6948659419A9999997F212941CDCCCC4C888659419A9999994D2229419A9999198186594100000000DA222941666666268586594133333333182329419A9999F97F865941CDCCCCCC6B232941CDCCCC4C7D865941CDCCCCCCD92329419A9999F97F8659419A99999965242941CDCCCC6C8586594100000000AA252941000000A08A86594166666666362629419A999939938659419A99999927272941333333F3A68659419A9999996D27294100000020A8865941CDCCCCCC95272941333333D3AB8659416666666627282941CDCCCCACB686594100000000F5282941333333B3C086594100000000B1292941333333B3C3865941000000004A2A2941CDCCCC2CCA865941CDCCCCCC9A2A2941CDCCCCECCE865941000000001C2B29419A999919D486594166666666222B294133333313D68659419A999999692B294166666606D8865941CDCCCCCC022D29419A9999D9EE86594133333333782D29419A9999D9F386594100000000202E294100000000FA86594100000000DE2E2941000000A00687594166666666662F29416666668602875941CDCCCCCCAB2F2941000000C0018759419A99999949302941CDCCCCAC03875941333333333A302941CDCCCCECE78659413333333357302941666666E6D8865941666666667E302941000000E0CE86594166666666923029419A999959CC865941CDCCCCCC9B3029419A999999C38659416666666673302941666666A6BE865941000000009A302941000000A0AA8659419A999999B5302941000000608686594100000000BF3029419A9999198086594100000000B43029410000002071865941666666668130294133333333678659419A99999980302941333333F35B865941000000009430294133333333538659419A99999992302941333333F33D865941CDCCCCCC68302941666666862286594100000000D430294133333373FA8559419A9999990E312941666666A6E7855941666666667A312941CDCCCC8CC985594133333333C93129419A9999F9B78559410000000017322941CDCCCCAC98855941CDCCCCCC96322941CDCCCC8C7A855941333333330D3329413333333365855941666666662A332941CDCCCCEC598559416666666629332941CDCCCC6C488559419A9999998A3329419A9999D922855941CDCCCCCCD8332941CDCCCC8C0885594100000000F633294166666646FD8459419A9999992534294100000080DB845941CDCCCCCC29342941CDCCCC8CD28459419A99999917342941666666C6C984594100000000E23329419A9999D9C58459419A999999B533294166666666AF8459410000000063332941CDCCCCCC9A845941666666662A3329419A9999598984594166666666973129419A9999798C8459413333333353312941000000808B8459419A99999900312941CDCCCCEC86845941666666667E302941333333737E845941CDCCCCCC19302941CDCCCCEC7984594100000000F82F2941000000C07984594100000000E72F2941000000806D84594133333333AC2F29419A9999395F8459419A9999995A2F294133333393588459419A999999062F2941000000405D84594100000000772E29419A9999795884594100000000DF2D2941000000E05684594166666666392D2941000000C057845941CDCCCCCC4F2C2941000000405684594166666666E82A29419A99991959845941CDCCCCCC902A294100000020518459419A999999FE2929416666666639845941666666667B292941CDCCCC0C288459410000000035292941000000A020845941CDCCCCCCC6282941000000C01B8459419A9999993A2829416666662618845941CDCCCCCCA027294133333333168459410000000019272941333333F31A845941CDCCCCCCBE262941CDCCCC0C168459419A999999FF25294166666686038459416666666680252941CDCCCC8CF8835941000000003E242941000000C002845941CDCCCCCCD6222941000000200D845941CDCCCCCC72222941000000C00A8459419A99999922222941333333130784594133333333DC212941666666A6FF835941CDCCCCCCD1212941CDCCCCACFA8359419A999999C6212941333333F3E7835941CDCCCCCCD9212941CDCCCCACDC835941CDCCCCCCF6212941000000A0C1835941000000003C2229419A999919B28359410000000044222941000000C0AB8359419A9999996A222941333333D3A083594133333333B7222941333333F383835941CDCCCCCC12232941CDCCCCAC79835941333333332623294166666626728359413333333341222941666666667C835941000000007720294100000020928359419A999999341E29419A9999F9A2835941666666664F1D294133333373AE835941666666669C1C2941CDCCCC4CB483594133333333A11B29419A999939C883594133333333C81B29419A999919DA83594166666666C31B29419A9999F9E7835941CDCCCCCCD41B29419A999999F483594166666666D81B29419A9999F9FE83594133333333E71B2941666666860A845941333333331B1C2941CDCCCCEC1E845941CDCCCCCC3E1C29416666664622845941666666669D1C29419A999959248459419A999999CA1C2941CDCCCC0C2484594100000000331D2941000000C026845941666666667B1D2941CDCCCCEC2A84594100000000DA1D2941333333132D84594133333333E61D29410000002031845941CDCCCCCCA31D2941333333933784594133333333771D2941666666C6428459419A999999531D2941666666664E84594100000000561D29410000002056845941CDCCCCCC3D1D29413333333364845941000000003F1D29413333331375845941CDCCCCCC311D2941000000A08684594100000000C11D29410000006084845941CDCCCCCC4C1E2941000000407784594166666666CB1E2941000000407A8459419A999999871F2941CDCCCC8C7684594100000000AB1F2941CDCCCCAC7A84594100000000B61F2941666666E68A84594133333333A31F2941666666269B845941000000002E1F294100000000C2845941CDCCCCCC991E294100000020DB84594166666666051E294166666686F08459419A999999DD1D294133333313F384594166666666971C2941CDCCCCAC00855941333333337E1B294133333333148559419A999999751A294133333373258559419A999999AA1929416666668643855941CDCCCCCC6A192941333333334F855941666666660D192941CDCCCC0C57855941CDCCCCCCDB1829419A9999595D855941CDCCCCCCAA182941666666266B8559416666666698182941666666A6818559416666666698182941666666A681855941	01010000206A080000D5B19489B6262941CCCCCC7C34855941	210330000	Z	Aubigny-lès-Sombernon	2103300	21033	21	27	8
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	01010000206A08000056555595D50B294166666666C3CF5941	210340000	Z	Autricourt	2103400	21034	21	27	27
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	01010000206A080000BC9120C855402A41CDCCCCAC316C5941	210350000	Z	Auvillars-sur-Saône	2103500	21035	21	27	7
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	01010000206A080000DB0BDE6E411F294133333363D0725941	210360000	Z	Auxant	2103600	21036	21	27	6
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	01010000206A080000FE30002A0867294166666616C6635941	210370000	Z	Auxey-Duresses	2103700	21037	21	27	11
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