SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep28;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep28 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep28','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep28','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep28','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep28"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000DE62744062CC214100000010D2275A41	280010000	Z	Abondant	2800100	28001	28	24	35
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	01060000206A08000001000000010300000001000000780000003333333387762141000000E09A1E5A41333333330377214166666606D51E5A419A9999997177214133333393FC1E5A41000000008F77214166666606051F5A41CDCCCCCCBD7721419A999959201F5A41CDCCCCCCC7772141333333F32D1F5A419A999999B7772141000000803B1F5A41666666668D7721419A9999D9511F5A4100000000E7782141CDCCCC4C611F5A41333333332F7B2141CDCCCC4C831F5A41CDCCCCCC237B2141CDCCCC4C8A1F5A4100000000BA7B2141000000208F1F5A419A999999507C2141666666A6951F5A4166666666847C21419A9999D9981F5A41000000009E7D2141333333F3AF1F5A4166666666B57D2141333333F3A61F5A41333333334380214133333353C21F5A41CDCCCCCCAC822141666666C6DC1F5A410000000097822141CDCCCCACE51F5A419A999999D882214100000060E71F5A41CDCCCCCC56832141CDCCCCCCEC1F5A41333333335D832141333333D3F01F5A41CDCCCCCC038421410000002007205A41CDCCCCCC76842141CDCCCC2C13205A4166666666E48421419A99997920205A419A99999950852141000000A02F205A41CDCCCCCCAC852141CDCCCC8C36205A41333333331B862141CDCCCC8C43205A4166666666BB8621419A99997959205A4133333333628721419A9999D96C205A4133333333AD872141666666C674205A41666666661C8821413333331382205A41666666662F8821413333335386205A4166666666888821416666664692205A4166666666AB8821419A9999B998205A419A999999D4882141CDCCCC2CA3205A4166666666DC88214100000000A9205A4133333333D0882141000000E0B6205A41666666660789214100000020BB205A4100000000698921419A999959C0205A419A999999D88921419A999959C2205A41CDCCCCCC468A2141000000C0C2205A419A999999908A214166666666C4205A41333333332B8B214133333333CE205A4133333333E38B2141CDCCCCCCD5205A41CDCCCCCC7C8C2141333333B3D9205A41CDCCCCCCCA8C2141666666A6DA205A41CDCCCCCCAB8D2141CDCCCC4CDB205A41CDCCCCCCEF8D21419A999959DA205A41CDCCCCCC568E214166666606D6205A4100000000848E21419A9999D9D2205A4133333333EB8E214100000060C7205A41CDCCCCCC378F214100000080C0205A419A9999995A8F21419A999919BF205A419A999999B68F214100000080BF205A4133333333E48F2141666666E6C2205A41CDCCCCCC9B9021419A999979D3205A410000000009912141CDCCCC6CDB205A4133333333B1912141CDCCCC4CE9205A41333333331B9221419A999939EB205A419A999999FE922141CDCCCCCCF1205A419A9999994C932141666666C6F4205A413333333396932141333333D3CE205A4133333333C693214166666626BE205A4166666666CF93214133333393B8205A410000000031942141CDCCCCAC8B205A41666666666A932141000000408D205A41000000005D942141333333734F205A4166666666F09321419A99993949205A41000000006C942141CDCCCC8C25205A4166666666CF942141333333930A205A419A999999E7942141CDCCCC0CFE1F5A419A9999992996214133333373B91F5A41000000000E96214133333353B91F5A419A999999EE952141000000C0A41F5A41CDCCCCCCE0952141666666E6911F5A4133333333CF952141000000E0901F5A419A999999B795214100000040891F5A41CDCCCCCCAB952141333333737B1F5A41000000007E9521419A9999797D1F5A41CDCCCCCCAB942141666666E6511F5A419A9999992F942141CDCCCC2C571F5A4133333333E593214100000060581F5A410000000063932141CDCCCC2C581F5A4133333333F59221419A999979541F5A419A999999539221419A999999511F5A41CDCCCCCCFF912141000000404F1F5A4133333333AE912141333333134F1F5A41CDCCCCCC15912141000000604A1F5A41CDCCCCCCD7902141CDCCCC4C4A1F5A419A999999619021419A9999794D1F5A41CDCCCCCC229021419A999959341F5A4100000000918F2141CDCCCC8C101F5A41CDCCCCCC478F2141000000E0041F5A4100000000648D2141000000C0CB1E5A4100000000B98C21419A999939B71E5A4100000000268B2141CDCCCCCC871E5A4166666666508A2141333333D36D1E5A41CDCCCCCCD9882141333333F3411E5A41CDCCCCCC2488214166666686751E5A41000000000087214166666646C81E5A4133333333798621419A9999B9BD1E5A41CDCCCCCCF0842141CDCCCC2CFD1E5A41CDCCCCCCF6832141666666C6241F5A419A999999228321419A9999F9081F5A419A999999C58221419A999939FE1E5A41666666663282214166666606F21E5A41666666660B81214133333353DF1E5A41000000002280214133333313D51E5A4133333333CD7F2141333333B3D21E5A4100000000067F2141666666E6D11E5A4100000000A47E2141666666C6D01E5A4166666666AF7D21419A999959CC1E5A4133333333467D2141CDCCCCACC91E5A419A999999517C2141000000A0BF1E5A419A999999517B214166666626B81E5A416666666699792141333333D3A71E5A419A99999949792141333333D3A51E5A413333333387762141000000E09A1E5A413333333387762141000000E09A1E5A41	01010000206A080000D4E6B3965B892141CDCCCCCC9E1F5A41	280030000	Z	Allainville	2800300	28003	28	24	5
01060000206A08000001000000010300000001000000A60000006666666631412241666666E618F45941000000004B4322419A9999B956F4594100000000DB422241333333B365F45941000000001A422241000000A07EF459416666666604422241666666C681F4594100000000B64122413333337393F45941000000006E42224166666606A7F45941666666666443224166666686C1F45941333333332244224100000020D6F45941000000004744224100000040DAF4594133333333EC432241CDCCCCCCE1F459416666666662432241000000C0EDF45941CDCCCCCC5A43224166666666EEF459419A99999914442241CDCCCC4C17F5594166666666AF4422416666660639F559416666666674442241CDCCCC2C3EF559419A9999995D4622419A9999F9ACF55941CDCCCCCC7646224100000040B2F559419A999999584622419A999939B6F5594133333333364622419A9999B9B2F55941000000002844224133333393FFF55941CDCCCCCCAE432241000000A011F65941000000000D4422419A99997924F65941333333336D4422419A99999936F659419A999999AF4422419A9999D941F659419A999999C8452241CDCCCCCC6DF659416666666686462241CDCCCC6C8BF65941CDCCCCCC98462241CDCCCC8C8DF659419A9999991246224100000040A0F659419A9999999A45224133333373B1F6594133333333E346224100000020DCF6594166666666FC46224133333313E1F6594100000000074822416666666609F759416666666656482241CDCCCC0C15F7594100000000764822413333337305F75941CDCCCCCCAD4822419A999979EFF6594100000000B6482241000000A0ECF6594100000000CD482241CDCCCCACE4F6594100000000F848224166666686D7F65941000000002749224166666666D8F65941666666665349224133333333DAF65941CDCCCCCC9A49224133333373DCF65941CDCCCCCCD349224166666606DFF65941CDCCCCCC064A22419A999979E1F6594100000000764A22419A999999E6F6594133333333DC4A2241666666E6EAF6594133333333D34A2241CDCCCCAC9BF6594166666666064C22419A9999D99BF65941000000006A4D22419A9999799DF659419A999999744F22419A9999399FF6594100000000DA4F2241000000409FF65941666666661D502241CDCCCCAC9EF659419A999999325022419A9999199EF6594100000000D2502241333333F397F659419A999999755122413333335392F6594166666666FE532241000000007BF659419A9999999F542241CDCCCCEC74F659419A999999705622413333331364F659410000000072572241CDCCCC0C5BF65941333333332D5822410000004054F65941CDCCCCCC6C582241666666E651F659419A9999999B5822413333333350F6594166666666C2582241000000E04EF659419A999999FA582241CDCCCC6C4DF659410000000058592241666666A64AF659419A999999105A22410000006042F65941000000005C5A2241000000A03DF6594166666666895A2241CDCCCCCC3AF659419A999999A45A22410000008039F6594100000000C25A22413333339337F6594133333333DA5A22419A9999B935F6594166666666F15A22416666664633F65941CDCCCCCCF75B2241333333D310F65941333333332A5D2241666666E6E7F5594133333333B85E224133333353B3F5594133333333B05E2241000000C0B1F55941333333339D5E224100000000AEF55941333333338C5E224100000040A9F5594100000000ED5D2241CDCCCC6C82F559419A999999505D2241333333535BF559419A999999225D2241CDCCCC0C50F559419A9999994C5C22419A9999991BF5594100000000335C22419A99993914F5594166666666025C22413333331309F55941000000007C5B224133333313E8F459419A9999995E5B2241CDCCCCCCE0F459419A999999F55A2241333333D3C6F45941CDCCCCCC5A5A2241000000A0A0F45941000000002E5A22416666668695F45941CDCCCCCC285A22419A9999D992F459419A999999C55A22419A9999F990F45941CDCCCCCCC95A2241666666E690F4594100000000905A22419A99999988F45941333333332E592241000000A055F4594100000000BD5722413333337320F45941CDCCCCCC92572241000000601AF45941000000001F5822419A99999905F459419A999999D0582241CDCCCC0CEBF3594133333333EF582241666666E6E6F359419A9999991059224100000060E3F35941CDCCCCCC1959224166666606E2F35941333333339A592241666666C6CDF359419A999999A859224166666606CCF35941CDCCCCCCC05922419A999919C9F3594166666666015A224100000040C1F3594100000000FA5B2241333333136EF35941000000001C5C22419A99995969F359419A999999605C22419A9999995FF35941333333338A5D22413333335335F3594166666666EA5D2241CDCCCCAC27F35941000000002A5E22419A9999B91EF3594166666666585F224166666686F4F25941666666667E5F2241CDCCCC8CEEF2594133333333375F2241333333F3E2F25941333333338B5E22419A999959C4F259419A9999994A5E2241CDCCCC2CB9F2594133333333545D2241333333F392F259419A9999991D5D2241CDCCCC0C8AF25941CDCCCCCC195D22419A99997989F259419A999999065D22413333339386F2594133333333815A22419A999939E1F25941CDCCCCCC6A5A2241CDCCCC8CE4F2594133333333555A22419A9999B9E7F2594100000000035A224166666666F2F25941333333338D592241CDCCCCCC02F359413333333388582241666666C626F35941000000001B582241000000A00BF359413333333358572241CDCCCC0C26F35941CDCCCCCCE15522419A999999C8F2594133333333C4552241000000E0CCF25941CDCCCCCCAC55224100000040D0F25941CDCCCCCC9655224133333373D3F25941000000002D5622419A999979F7F25941666666664D5622410000000001F35941CDCCCCCC3B5622416666662602F3594100000000C95422419A99997910F35941CDCCCCCCA45422416666662612F3594100000000365422419A99993916F3594133333333D6532241000000401AF3594166666666715322419A9999D91DF35941666666664F532241000000801FF3594166666666955222410000006026F3594100000000705222410000002028F3594100000000A9512241333333D32FF359419A9999998E512241CDCCCC2C31F35941CDCCCCCCFE5022419A99999936F359416666666696502241CDCCCCEC3AF359419A999999864F22413333333345F3594166666666614E2241333333F350F359419A999999294D2241CDCCCCEC5CF3594133333333954C2241666666C662F3594166666666274B22413333337370F3594133333333DD492241000000007EF359419A9999992D4922419A99993985F3594100000000FA4822413333335387F35941666666661B4622419A9999F9A3F359419A9999990B46224100000060A5F3594100000000084622419A999979A4F359419A999999E0452241333333B3A7F35941000000003745224166666646B8F35941CDCCCCCCDD44224166666686C0F3594133333333AF4322419A9999F9DDF35941CDCCCCCCA943224100000040DEF35941CDCCCCCC6442224166666666FDF3594100000000DB412241CDCCCC6C0AF459416666666631412241666666E618F45941	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	01010000206A0800002AD2B71E784F22419A999979CEF45941	280040000	Z	Allonnes	2800400	28004	28	24	10
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	01010000206A0800009856B5874AA1214166666606AEE95941	280050000	Z	Alluyes	2800500	28005	28	24	20
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	01010000206A080000B66BB0A153C421413333338332015A41	280060000	Z	Amilly	2800600	28006	28	24	20
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	01010000206A080000CEB9D25973DD2141666666167F2D5A41	280070000	Z	Anet	2800700	28007	28	24	8
01060000206A080000010000000103000000010000006E01000000000000C230214133333393F30D5A419A99999967332141CDCCCC0C250E5A41CDCCCCCC8433214133333333270E5A4133333333DE332141333333332E0E5A413333333361342141CDCCCCCC370E5A419A999999EA34214166666666420E5A410000000052352141000000004A0E5A4100000000AC3521419A9999D9500E5A419A999999F335214166666646560E5A419A9999990E36214133333373580E5A41CDCCCCCC3939214100000000210E5A4100000000513B2141333333D3450E5A4133333333D43E2141666666A6830E5A419A999999B63F21419A999939930E5A41000000007E402141000000805F0E5A41CDCCCCCCAE4021419A9999B9610E5A4133333333264121419A9999F96B0E5A41CDCCCCCC39412141CDCCCCCC6E0E5A41000000009841214100000000580E5A41CDCCCCCC0A4221419A999919420E5A419A9999998542214100000020290E5A419A999999CC422141CDCCCC0C1A0E5A4133333333EA422141666666C6130E5A4133333333FB42214166666626100E5A41000000001D43214166666666060E5A41CDCCCCCC61432141333333D30A0E5A419A9999998E432141333333730D0E5A41CDCCCCCC97432141000000600F0E5A419A9999999B43214133333333110E5A4133333333A143214100000000130E5A4166666666AA4321419A999939150E5A4133333333BA4321419A999999160E5A419A99999902442141666666061B0E5A41333333333E442141333333D31E0E5A419A9999994D442141333333D3200E5A4100000000B1442141CDCCCC2C2C0E5A41333333330145214166666606360E5A41CDCCCCCC29452141333333933B0E5A41666666664A452141000000E0400E5A419A9999995F4521419A9999B9450E5A416666666673452141CDCCCCEC4B0E5A41CDCCCCCC90452141666666E6570E5A41CDCCCCCC9B452141333333D3600E5A4166666666B8452141333333F3660E5A419A9999992B462141000000007C0E5A410000000070462141CDCCCCEC870E5A41666666667D46214100000040870E5A41000000009E4621419A999919740E5A4166666666944621419A9999596E0E5A416666666695462141CDCCCCCC670E5A4100000000A7462141CDCCCCEC600E5A4166666666BB462141CDCCCCCC590E5A41CDCCCCCCC6462141CDCCCCAC550E5A41CDCCCCCCCB462141333333F3500E5A4166666666D4462141000000A04B0E5A41CDCCCCCCE4462141666666A6470E5A41333333330147214100000020440E5A41333333334D472141666666663B0E5A419A9999996A4721419A999919370E5A41333333337B47214133333333330E5A419A9999998B47214166666606320E5A4133333333A047214166666626310E5A419A999999AF472141000000E0300E5A4133333333C04721419A9999D9300E5A4133333333EB47214100000040300E5A41000000000248214100000020300E5A41666666661B48214166666666300E5A41CDCCCCCC78482141CDCCCCCC330E5A4100000000CF482141666666E6360E5A4133333333EE482141666666C6370E5A41CDCCCCCC00492141CDCCCC0C390E5A41CDCCCCCC2C492141000000403C0E5A419A999999754921419A999979410E5A41CDCCCCCCD24921419A999939480E5A4133333333144A2141CDCCCCEC4C0E5A419A999999A84A2141000000E0570E5A4100000000D14A2141666666C65A0E5A4166666666E44A2141CDCCCC2C5C0E5A41CDCCCCCC074B214100000080570E5A41000000004B4B2141666666264E0E5A4100000000974B214100000060440E5A419A999999C34B2141333333733F0E5A41CDCCCCCCE24B2141000000403B0E5A41CDCCCCCC034C214166666646370E5A41333333333D4C2141333333732F0E5A419A999999644C21419A9999D9290E5A4166666666934C214133333393230E5A419A999999B84C2141666666A61E0E5A41CDCCCCCCCC4C2141666666061C0E5A4133333333E64C21419A999939190E5A41CDCCCCCC094D2141CDCCCCCC150E5A4166666666314D21419A9999D9110E5A419A9999994F4D2141000000C00E0E5A41000000006D4D2141666666C60B0E5A41000000008C4D214133333333080E5A4100000000B14D2141000000A0020E5A41CDCCCCCCD04D214166666626FD0D5A4133333333ED4D2141CDCCCC8CF80D5A4133333333024E214166666626F40D5A4100000000104E2141666666C6F00D5A41333333335F4E214100000080E20D5A419A999999AB4D2141CDCCCCCCB70D5A419A999999154E21419A9999799B0D5A41CDCCCCCCDF4E21419A9999B9670D5A419A999999F74E214166666646640D5A4133333333BE4E2141333333D35F0D5A4166666666874E2141333333335B0D5A4133333333634E2141CDCCCCAC570D5A419A999999254E2141333333B3500D5A419A999999534E214100000080470D5A41CDCCCCCCE94E214133333353340D5A4100000000044F21419A999959320D5A4166666666684F21419A9999392E0D5A4166666666C24F214133333353250D5A4133333333F04F21419A999959210D5A41666666669F4F2141CDCCCCCC160D5A4100000000914F214100000060150D5A41000000008E4F214133333373110D5A419A999999AE4F21419A9999190E0D5A41CDCCCCCC1550214166666646020D5A4133333333565021419A999979F80C5A41666666668D502141666666E6ED0C5A41333333337850214133333393EA0C5A41CDCCCCCC6750214133333373E80C5A41666666664B50214166666646E60C5A41666666662B50214100000080E30C5A41333333338E5021419A999939D80C5A41666666661B512141333333F3C50C5A4100000000EB50214133333313C00C5A41CDCCCCCCD550214166666646BC0C5A41666666662D51214133333393AE0C5A41666666667D51214166666666960C5A419A999999DB512141333333338D0C5A419A999999FF51214166666666870C5A41CDCCCCCC4252214133333333920C5A41000000007552214133333353930C5A41CDCCCCCC514F2141CDCCCCEC0D0C5A41CDCCCCCC5F4F21419A9999790C0C5A41333333336D4F2141333333930B0C5A4100000000BF4F2141666666E6050C5A41666666660A5021419A9999F9000C5A41333333334050214133333353FD0B5A41CDCCCCCCAD502141CDCCCCECF50B5A4133333333EA502141333333B3F10B5A410000000042512141CDCCCCCCEB0B5A41CDCCCCCCED512141CDCCCC6CE10B5A4100000000B34E214100000020520B5A41CDCCCCCCC14E21419A9999F94F0B5A419A999999D34E2141333333B34C0B5A41CDCCCCCCED4E21419A999979460B5A419A9999990C4F2141000000A03E0B5A419A999999244F214100000080390B5A4166666666374F2141333333F3350B5A4100000000554F214100000020310B5A4133333333774F2141666666862B0B5A4133333333934F2141333333F3260B5A41333333335E4D2141000000E0E00A5A41CDCCCCCC404D2141CDCCCCCCDD0A5A41000000005A4D2141CDCCCC2CD60A5A4133333333694D214166666626D20A5A4133333333EA4C2141000000E0C90A5A4100000000554C214100000000BF0A5A4100000000914B21419A999959B00A5A41CDCCCCCC594B214166666606B30A5A41333333330B4B2141333333D3B70A5A41CDCCCCCCB74A21419A999939BE0A5A41000000002C4A214166666606C80A5A41CDCCCCCC7D49214166666606D40A5A419A999999FA48214100000080DA0A5A419A9999999E482141CDCCCC8CDD0A5A410000000032482141CDCCCCCCDF0A5A4100000000BC472141333333B3E00A5A41CDCCCCCC7F4721419A9999F9DF0A5A41666666660C47214166666666DC0A5A41666666669746214166666626D80A5A419A9999997F46214166666686D80A5A4133333333464621419A999999DB0A5A419A99999903462141666666A6DF0A5A4166666666CB452141000000C0E20A5A41CDCCCCCC8945214133333373E60A5A41333333332C452141CDCCCC0CEC0A5A4133333333D944214133333313F10A5A4133333333B3442141CDCCCC4CF30A5A410000000064442141000000E0F70A5A413333333354442141CDCCCCCCF80A5A41333333336F442141CDCCCC6C070B5A41000000008E442141333333F31F0B5A4133333333B4442141666666A6450B5A41CDCCCCCCC5442141000000C0540B5A41333333335F44214133333353610B5A41CDCCCCCC314421419A999999660B5A4133333333E243214166666606700B5A4166666666B8432141333333B3740B5A419A9999999F432141CDCCCCAC770B5A419A99999969432141333333D37D0B5A416666666648432141666666C6810B5A41000000002343214133333353860B5A41CDCCCCCCF7422141666666A6880B5A4133333333BB4221419A9999998A0B5A419A99999982422141333333F38A0B5A416666666656422141333333D3890B5A41666666663B4221419A9999B9880B5A4100000000184221419A999919870B5A4100000000ED41214133333393840B5A4166666666BB412141666666E67F0B5A41CDCCCCCC964121419A9999997D0B5A41333333334B412141666666C6770B5A413333333315412141333333F3730B5A4100000000D34021419A9999196F0B5A410000000050402141000000C0690B5A41000000000B40214166666686680B5A4100000000CB3F214100000060680B5A4166666666843F2141333333936A0B5A4100000000403F2141666666E66B0B5A4133333333CF3E2141CDCCCC4C6C0B5A41CDCCCCCC313E21419A9999796C0B5A4133333333643D2141CDCCCCAC6C0B5A419A999999353D21419A9999396C0B5A4100000000073D2141000000406C0B5A419A999999E53C2141333333336C0B5A4100000000CD3C21419A9999196C0B5A41000000009D3C2141CDCCCCEC6B0B5A419A999999693C2141CDCCCC0C6B0B5A4133333333333C214166666686690B5A419A9999991D3C2141333333D3690B5A419A999999153C2141CDCCCCCC6A0B5A41CDCCCCCC0B3C2141000000206F0B5A41CDCCCCCC053C2141333333B3710B5A4166666666FC3B21419A999919750B5A41CDCCCCCCEC3B2141CDCCCCEC780B5A4100000000D73B2141CDCCCC4C7D0B5A419A999999C13B21419A999999810B5A419A999999B63B2141000000E0840B5A4100000000AA3B2141000000A0880B5A419A9999999B3B21419A9999998D0B5A41000000008E3B21419A999999960B5A4100000000873B2141333333B39A0B5A4166666666843B21419A9999F99E0B5A41CDCCCCCC803B214166666666A20B5A41333333337F3B2141333333B3A40B5A41666666667C3B21419A9999F9A70B5A4100000000793B214133333353AB0B5A41CDCCCCCC743B21419A9999B9AD0B5A41CDCCCCCC6C3B2141666666A6B20B5A4133333333663B214166666686B60B5A41666666665A3B214133333373BC0B5A4166666666523B21419A9999D9C00B5A4100000000483B214166666606C60B5A4133333333403B21419A999999C80B5A41CDCCCCCC313B21419A999979CB0B5A4100000000173B2141CDCCCC4CD10B5A419A999999063B2141CDCCCC6CD40B5A4133333333F03A21419A9999F9D80B5A41CDCCCCCCDD3A2141333333D3DC0B5A4166666666CD3A214100000040E00B5A4100000000BD3A2141CDCCCC2CE40B5A41CDCCCCCCAC3A21419A999979E70B5A419A999999A13A2141CDCCCCECE90B5A4166666666943A2141000000C0EC0B5A419A999999863A2141CDCCCCCCEF0B5A4166666666713A214166666626F20B5A41CDCCCCCC523A214133333393F50B5A41CDCCCCCC0C3A21419A9999B9FD0B5A4100000000FF39214100000060FF0B5A4133333333F539214133333393000C5A4100000000E739214133333313010C5A4133333333D1392141666666E6010C5A4133333333A2392141333333D3030C5A41CDCCCCCC71392141CDCCCC2C060C5A41CDCCCCCC2839214133333313090C5A410000000001392141333333930A0C5A419A999999D8382141666666260C0C5A419A999999AD382141666666E60D0C5A41CDCCCCCC903821419A9999590F0C5A416666666656382141000000E0110C5A41000000003D38214100000000130C5A41000000000D38214100000080150C5A419A999999ED372141CDCCCC6C160C5A4166666666CF372141333333131A0C5A4100000000B73721419A9999191E0C5A4100000000A937214133333333200C5A41CDCCCCCC9637214100000080220C5A41666666668D3721419A999999230C5A41CDCCCCCC8637214166666626230C5A416666666682372141CDCCCCCC210C5A41666666667837214100000000200C5A41CDCCCCCC2D372141000000A0210C5A4166666666E3362141666666C6220C5A419A999999B6362141333333B3240C5A413333333398362141666666A6250C5A419A9999994236214166666626300C5A410000000009362141CDCCCC8C390C5A41CDCCCCCC1F362141000000E03D0C5A419A999999FD35214100000080430C5A419A999999DF35214133333333480C5A4166666666CF352141CDCCCC0C4D0C5A4100000000D935214133333313500C5A4133333333DF35214100000080530C5A4133333333F5352141CDCCCC4C5C0C5A41CDCCCCCC0836214133333313640C5A41000000001636214133333373690C5A410000000022362141000000606E0C5A419A9999992A362141000000C0730C5A410000000037362141CDCCCC4C7A0C5A419A99999942362141CDCCCC6C800C5A41CDCCCCCC4A362141666666C6830C5A41CDCCCCCC5436214100000080880C5A419A9999996136214100000020900C5A410000000070362141000000C0970C5A410000000076362141333333F39B0C5A416666666676362141000000C09F0C5A41CDCCCCCC70362141333333B3A30C5A41666666665F362141CDCCCC0CA80C5A41333333334F362141333333F3AB0C5A41CDCCCCCC38362141CDCCCC6CB10C5A41CDCCCCCC2B362141333333D3B50C5A41666666661E3621419A9999F9BB0C5A41333333331436214133333373C20C5A41666666660E36214133333393C80C5A41000000000A3621419A999959D00C5A419A999999093621419A999939D60C5A4133333333053621419A999959DA0C5A419A999999FA35214133333333DF0C5A4100000000F4352141CDCCCCCCE10C5A4166666666E3352141CDCCCC4CE50C5A41CDCCCCCCB735214166666666EB0C5A41333333339135214166666686F10C5A4133333333763521419A9999F9F30C5A41333333335735214133333313F50C5A41000000002F352141000000E0F50C5A41CDCCCCCCFC34214133333373F70C5A4166666666CE34214133333313FA0C5A4100000000693421419A9999190B0D5A419A9999992D34214133333313180D5A410000000025342141666666061A0D5A4100000000003421419A9999591F0D5A4166666666D133214166666686260D5A41CDCCCCCC9B332141CDCCCC8C2D0D5A41CDCCCCCC7A332141666666E6310D5A419A99999951332141CDCCCC4C360D5A41333333333D332141CDCCCC0C3B0D5A41000000002E33214100000020410D5A419A9999992E33214100000020480D5A413333333338332141666666464F0D5A41000000004833214133333393530D5A419A9999994E332141CDCCCC4C550D5A41000000008C332141666666865E0D5A41CDCCCCCC1F3421419A999919720D5A41CDCCCCCC7D3421419A9999B97B0D5A419A9999999F342141CDCCCC8C7E0D5A4100000000A9342141666666A6820D5A419A999999AA34214166666686870D5A41000000009E342141333333B38C0D5A41666666667B342141CDCCCCCC920D5A419A9999994134214100000080980D5A4133333333B633214100000080A20D5A419A999999433321419A999999A90D5A4100000000193321419A999919AC0D5A4166666666BE322141CDCCCC0CAF0D5A41000000003D322141666666E6B30D5A4133333333F231214100000060B80D5A4100000000C931214100000060BC0D5A41000000006E312141333333B3C90D5A416666666606312141CDCCCC2CE10D5A41CDCCCCCCC2302141333333D3EF0D5A4100000000C230214133333393F30D5A41	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	01010000206A080000C670FAC2E54321419A9999B9A10C5A41	280080000	Z	Ardelles	2800800	28008	28	24	10
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	01010000206A080000902BC02BD0E72241333333130CF75941	280090000	Z	Ardelu	2800900	28009	28	24	4
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	01010000206A0800003C0871EA4DC62041333333B3CDEF5941	280100000	Z	Argenvilliers	2801000	28010	28	24	18
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	01010000206A08000047457C733B092141CDCCCC2C9FDB5941	280120000	Z	Vald'Yerre	2801200	28012	28	24	146
01060000206A080000010000000103000000010000009B010000333333338B982241666666E63A005A419A999999F2982241CDCCCC6C49005A4166666666F3982241333333934F005A41CDCCCCCCF39822419A99995956005A4100000000F4982241333333535B005A419A999999F4982241666666665F005A4133333333ED982241666666A660005A4133333333CA9822419A99999966005A4133333333B5982241666666266A005A4100000000A7982241CDCCCC8C6C005A41CDCCCCCCA0982241000000A06D005A4166666666B6982241000000A07D005A4100000000BA982241000000207F005A4100000000CA9822416666666684005A419A999999DA982241666666E688005A41CDCCCCCC09992241000000A092005A41CDCCCCCC279922416666662691005A41000000004C992241333333B396005A41000000005B9922416666660699005A419A99999999992241CDCCCCACA2005A4166666666969A2241666666C6C9005A419A9999992A9B2241CDCCCCACE0005A4133333333669B22419A9999F9E7005A4166666666B19B224133333333F1005A41CDCCCCCCD99B224166666626F6005A4166666666069C2241000000A0FB005A41CDCCCCCC249C224100000060FF005A41666666666D9C22416666664608015A4100000000749C22413333331309015A4100000000849C2241666666060B015A41333333339B9C2241666666E60D015A4100000000A69C22419A9999390F015A4166666666179D22419A99999921015A41666666661C9D22416666666622015A4133333333289D22419A99995924015A419A9999992A9D22419A9999B924015A41CDCCCCCC309D22419A9999B925015A4166666666589D2241CDCCCC2C2C015A4133333333AE9D2241CDCCCC4C42015A41CDCCCCCCFC9D2241CDCCCC8C56015A4133333333259E22413333333355015A4166666666329E2241000000C054015A419A999999869E22419A9999F951015A41CDCCCCCCA29E22416666660651015A419A999999BA9E22410000004050015A4133333333559F2241666666264B015A419A999999619F22419A9999B94A015A4166666666D99F22416666668662015A4133333333F89F2241CDCCCCAC68015A419A99999919A02241666666466F015A41CDCCCCCC43A022419A99999974015A41CDCCCCCC64A02241666666C678015A4133333333DFA02241CDCCCC2C88015A419A9999990FA12241000000408E015A4100000000D9A02241000000C091015A41333333336CA022413333339398015A413333333329A022419A9999599C015A4100000000E49F2241CDCCCC2C9F015A4133333333C79F224133333393A0015A4166666666B39F2241CDCCCCACA1015A4100000000BBA02241CDCCCC8CB1015A410000000033A22241CDCCCC4CC7015A419A9999994DA32241CDCCCC6CDB015A416666666672A42241CDCCCC4CF9015A41CDCCCCCC82A422419A9999F9FA015A416666666628A522419A99999916025A419A99999952A522419A9999591D025A410000000065A522410000008020025A410000000092A52241000000E026025A41CDCCCCCC15A722419A9999995D025A41CDCCCCCC52A722419A99999966025A419A999999A1A72241CDCCCC4C72025A419A999999AEA722413333333374025A41CDCCCCCCECA72241CDCCCC2C7D025A419A99999913A82241CDCCCCAC82025A41CDCCCCCC52A82241666666A68B025A410000000079A822413333331391025A4100000000DFA82241000000A09F025A419A999999E0A8224100000020A0025A4133333333DFA82241000000C0A0025A4100000000D4A82241CDCCCC0CA2025A4166666666D9A82241333333D3A2025A410000000001A92241CDCCCC6CA8025A410000000094A9224100000040BD025A419A9999996AAA224133333333DB025A410000000080AA2241CDCCCC2CDE025A41000000001EAB2241333333F3F3025A41CDCCCCCC6BAB22419A9999B9FE025A410000000095AB22416666666604035A419A99999904AC2241000000E013035A41CDCCCCCC68AC22413333331320035A41333333337BAC22413333331322035A4100000000D3AC2241666666862B035A41CDCCCCCCD6AC2241666666E62B035A41CDCCCCCCDBAC2241333333732C035A419A999999F9AC2241CDCCCCAC2F035A41CDCCCCCCC0AD2241333333F342035A4133333333D2AD22413333335344035A41CDCCCCCCE8AD2241CDCCCC2C46035A41333333336EAE2241CDCCCC0C49035A410000000074AE22416666664649035A416666666690AE22413333337349035A41CDCCCCCCF1AE22416666668647035A4166666666A8AF22416666660642035A4100000000BDAF22419A9999F940035A41CDCCCCCCCAAF2241333333D340035A4100000000D7AF22416666668641035A41666666665CB122410000008039035A413333333302B22241666666C636035A41CDCCCCCC5BB22241000000A035035A41CDCCCCCCB2B22241000000E034035A410000000000B322416666668633035A41CDCCCCCC37B32241666666C632035A410000000063B322419A9999B932035A41000000009EB322416666664634035A41CDCCCCCCB7B32241CDCCCCCC34035A416666666653B42241666666E639035A410000000021B522416666668641035A413333333342B52241CDCCCC8C43035A419A99999957B52241666666A645035A4133333333DAB522419A9999B948035A419A999999EEB62241333333334F035A410000000003B822419A9999B955035A419A99999917B922419A9999395C035A4166666666B3B92241000000E05F035A41333333337DBA2241000000A064035A419A99999995BB2241CDCCCCEC61035A413333333373BC2241666666665B035A41CDCCCCCC85BC2241666666A65A035A41CDCCCCCCBEBC22419A99995959035A4166666666E2BC22413333337358035A4166666666F7BC22413333333358035A4100000000BDBC2241333333B33A035A41CDCCCCCC82BC2241333333331D035A416666666648BC2241333333B3FF025A41333333333ABC2241CDCCCC8CF8025A41000000004CBC224166666606F8025A413333333379BC224133333373E3025A41CDCCCCCC93BC224166666646D9025A41CDCCCCCCADBC22419A9999B9CF025A4100000000D1BC22419A9999F9C5025A419A999999F7BC2241000000E0BD025A416666666627BD224133333393B4025A41CDCCCCCC87BD2241333333D39F025A41CDCCCCCCA2BD22416666664699025A4100000000FEBD22419A99991980025A416666666653BE22410000002064025A419A99999962BE2241333333135E025A41CDCCCCCC71BE2241000000C057025A41000000007FBE22413333335351025A413333333395BE22413333337342025A419A9999999ABE2241333333533D025A4133333333A1BE2241666666E639025A41CDCCCCCCBBBE22419A9999D92F025A419A999999C0BE2241CDCCCC4C2D025A410000000069BE2241666666A62B025A419A99999958BE22419A9999592B025A413333333367BE2241333333B306025A419A99999975BE224166666606E2015A413333333384BE22419A999959BD015A410000000068BF2241333333F3B9015A41000000004CC02241CDCCCC8CB6015A410000000030C1224100000020B3015A419A99999956C122410000002076015A41000000005CC12241333333936D015A41CDCCCCCCE5C12241CDCCCC8C6E015A41CDCCCCCCEBC122410000006068015A4166666666FAC122413333339359015A419A999999FCC12241000000C057015A41666666660AC22241CDCCCCCC4D015A41CDCCCCCC12C222410000008043015A410000000013C222419A99997936015A41CDCCCCCC10C222419A9999792E015A4166666666E9C122413333333324015A41CDCCCCCCD9C12241CDCCCCEC22015A419A999999C5C122419A9999D920015A4100000000ACC12241333333D31C015A413333333368C122419A99991913015A419A99999981C32241CDCCCCAC17015A413333333396C42241666666061A015A419A999999AAC52241000000601C015A4133333333BFC622419A9999B91E015A4100000000B2C822410000000020015A4100000000B6C82241000000E017015A4166666666C5C822419A9999D9FA005A419A99999990CA2241333333B3FD005A4100000000B9CA22419A9999B9D9005A4166666666BBCA2241CDCCCC8CD7005A4133333333C3CA2241000000C0C9005A4100000000C5CA2241CDCCCCCCC3005A4100000000C7CA2241CDCCCCECBC005A4133333333D5CA22419A9999F9AF005A4166666666E1CA2241CDCCCC2CA2005A4133333333EACA22419A99991994005A41CDCCCCCCECCA2241666666A683005A4166666666EDCA2241333333337F005A4133333333EECA2241666666067A005A41CDCCCCCCF0CA2241000000C073005A413333333301CB2241333333334D005A419A99999902CB2241000000204B005A416666666605CB22413333337347005A41333333330BCB2241333333933D005A41CDCCCCCCD1C92241CDCCCCEC47005A4166666666B9C922419A9999F93A005A419A9999998AC922410000002026005A410000000076C92241333333F31C005A41666666663EC92241CDCCCC8C08005A410000000028C92241CDCCCC6CFFFF5941000000000AC822419A9999B902005A4100000000DAC722416666664603005A4100000000B7C722416666662608005A41000000007FC722419A99991912005A416666666646C722419A9999991C005A410000000023C72241CDCCCC2C23005A410000000011C72241CDCCCC6C25005A4166666666E2C62241CDCCCCCC29005A41CDCCCCCCD1C622419A9999B92B005A4100000000B0C62241CDCCCC6C35005A419A9999996EC622410000004048005A419A9999995DC62241666666064F005A419A99999955C62241CDCCCCAC50005A41CDCCCCCC4FC62241333333D351005A419A99999949C62241666666A653005A413333333337C622413333331357005A416666666630C622419A9999F957005A410000000024C62241000000E058005A416666666616C622416666668659005A41CDCCCCCC05C622419A9999195A005A4133333333E4C52241000000E05A005A419A999999BBC52241333333935A005A419A99999992C52241CDCCCCCC59005A416666666678C522413333339359005A410000000064C52241000000A059005A413333333350C52241666666065A005A41CDCCCCCC3AC52241000000C05A005A41CDCCCCCC27C52241333333935B005A410000000013C52241000000C05C005A41CDCCCCCCEAC42241333333D35F005A4133333333C9C422416666662662005A41CDCCCCCC9AC42241CDCCCC0C66005A413333333379C42241000000A069005A416666666658C422419A9999D96C005A410000000032C42241333333536F005A4166666666EDC32241666666E671005A4166666666C1C322410000002074005A416666666697C32241000000E075005A419A99999984C322410000008076005A419A9999996DC32241333333D376005A41333333334AC32241333333D376005A41333333332EC32241CDCCCC0C77005A41CDCCCCCC19C32241CDCCCC6C77005A4100000000F3C222410000000079005A4133333333CBC22241333333137B005A41CDCCCCCC9FC222419A9999B97B005A419A99999975C22241666666A67C005A413333333353C22241333333B37C005A410000000038C22241666666867C005A419A99999916C22241CDCCCC6C7D005A41CDCCCCCCC7C12241CDCCCC6C80005A41333333334DC122410000002084005A419A99999928C12241CDCCCCEC84005A4100000000FBC022419A99991985005A419A999999DCC02241000000E078005A4100000000ADC02241000000A065005A41CDCCCCCCADC02241CDCCCCEC64005A41666666667DC02241000000A056005A419A9999995DC02241CDCCCC6C4A005A413333333328C02241333333734B005A419A99999940BF2241CDCCCCCC55005A4133333333F4BE2241CDCCCC4C38005A419A999999A7BE2241666666C61A005A41CDCCCCCC5ABE224100000040FDFF594133333333F6BD2241000000E0FEFF5941CDCCCCCCD5BD2241CDCCCC0CF4FF59413333333360BD224100000060CFFF5941CDCCCCCC38BD2241CDCCCC4CC4FF59416666666636BD2241333333F3C2FF5941CDCCCCCC33BD2241CDCCCCACC1FF59410000000034BD2241CDCCCC4CBFFF59419A99999937BD2241333333B3BDFF59410000000048BD22419A9999D9B6FF59419A99999968BD2241333333F3AAFF594133333333B0BD22419A9999198DFF594133333333C6BD22416666666685FF5941333333335ABC22419A9999F938FF59419A999999B3BD22419A99993912FF59419A99999905BD22419A9999B9F0FE5941CDCCCCCCE8BC224100000080EBFE59410000000051BC224166666666CEFE5941666666663DBC2241333333D3CAFE59410000000032BC224100000020C9FE5941000000002EBC22419A999939C8FE5941000000002EBC2241000000E0C6FE5941333333330DBC224133333393C5FE594166666666EABB2241000000A0C3FE59416666666671BB22419A9999F9BBFE5941CDCCCCCC42BA22419A999939A8FE59410000000009BA2241CDCCCC4CA5FE594100000000F9B92241666666A6A4FE5941000000002AB922419A9999B99CFE5941666666660FB92241CDCCCCEC9BFE594166666666F8B82241000000809BFE59419A999999DBB822419A9999799BFE594166666666BEB82241333333B39BFE59410000000040B82241CDCCCCEC9DFE5941666666661AB822419A9999599EFE594133333333FAB72241666666669EFE594100000000BEB72241666666A69DFE59416666666634B722419A9999F99AFE5941CDCCCCCC0AB72241333333D39AFE59419A999999A6B622419A9999199BFE59410000000091B62241CDCCCC2C9BFE5941333333330CB62241CDCCCC4CA3FE594166666666A2B52241CDCCCCACABFE59410000000064B5224133333313B1FE5941CDCCCCCC35B52241CDCCCCECB5FE59419A999999FCB4224133333393BDFE594100000000D8B4224100000080C3FE59419A9999999DB4224100000060CEFE59413333333390B42241333333F3D0FE5941CDCCCCCC53B42241333333B3DCFE5941CDCCCCCC41B422419A999959E0FE59416666666630B422419A9999F9E3FE59410000000008B4224166666646ECFE594166666666E3B32241666666C6F4FE594133333333C9B32241666666A6FBFE594133333333BEB322419A999939FFFE59419A999999B2B322419A9999F902FF594100000000A1B32241000000C00AFF59416666666688B32241666666261BFF5941333333337EB322419A9999F91FFF5941CDCCCCCC68B32241000000A026FF5941CDCCCCCC4CB32241666666262DFF594133333333F9B22241666666A63EFF594166666666D9B222419A9999F944FF59419A999999C5B222419A99995940FF5941CDCCCCCC73B22241000000E02FFF59419A99999972B222419A9999992FFF5941CDCCCCCCBEB12241666666A60BFF59410000000037B12241333333B3F1FE5941CDCCCCCC24B122419A999939EFFE59410000000093AF2241CDCCCC8CFCFE5941CDCCCCCC92AF22416666668606FF59419A9999999EAF2241CDCCCC8C0EFF59413333333373AA2241333333330FFF59419A99999967AA2241666666460CFF5941000000003EAA2241CDCCCC4C00FF59419A99999930AA2241000000E0FBFE5941CDCCCCCC27AA22419A9999B9F7FE5941CDCCCCCC1CAA224133333373EFFE5941000000001BAA2241CDCCCCACEBFE5941666666661DAA2241CDCCCCACE4FE59410000000024AA2241CDCCCCECDFFE5941000000003CAA224100000060D5FE59413333333359AA224133333333CCFE5941333333336BAA2241CDCCCC8CC6FE59410000000085AA22419A999919BDFE5941CDCCCCCC6AAA2241333333B3BCFE5941666666663CAA224100000080BCFE5941333333331BAA224166666686BCFE594166666666FEA92241333333B3BCFE59419A999999C9A9224166666686BDFE5941666666666FA92241CDCCCC6CBFFE594100000000CCA8224166666666C3FE59419A99999935A8224100000060C6FE59410000000018A822419A9999F9C6FE594133333333E2A722419A9999F9C8FE5941000000006BA7224100000020CDFE594166666666A2A62241CDCCCC0CD4FE5941CDCCCCCC37A62241CDCCCCCCD7FE5941CDCCCCCCD0A522419A9999B9DBFE59413333333388A52241000000E0DEFE5941666666665FA52241666666C6E0FE5941000000002DA52241000000A0CAFE5941CDCCCCCC4DA422410000004062FE59419A99999904A42241000000206FFE594100000000BDA32241333333737CFE5941000000003DA32241333333F391FE5941CDCCCCCC21A32241666666C68FFE5941666666666BA22241000000C084FE5941666666665AA222416666666683FE59416666666615A22241000000208EFE594133333333A6A12241666666C69EFE5941666666669DA122413333337396FE5941333333338AA122410000008088FE59416666666655A12241000000E067FE59419A999999A49C2241CDCCCCCC83FE59413333333376992241000000C098FE594100000000E2992241CDCCCC2CF4FE594166666666129A22413333339316FF5941CDCCCCCC179A2241666666461CFF5941CDCCCCCC189A2241333333D31FFF594100000000F39822410000002018FF594133333333CC9822416666668617FF594166666666A99822410000006017FF5941000000008D982241666666A617FF59413333333339992241CDCCCC8C3DFF594166666666989822413333331349FF594100000000F2982241333333535BFF59419A99999964992241666666C672FF5941CDCCCCCC0B9A2241CDCCCC6C94FF5941CDCCCCCCDF9A224166666626BFFF5941CDCCCCCC259B2241CDCCCCECCDFF59419A999999E39A2241666666A6DDFF59419A999999C19A2241000000A0E4FF59419A9999997B9A22419A999999F1FF594133333333059A22416666664604005A4133333333559922419A9999B91C005A4133333333049922416666666628005A4100000000CD9822410000000030005A41333333338B982241666666E63A005A41	01060000206A08000001000000010300000001000000B9000000333333338B982241666666E63A005A419A999999F2982241CDCCCC6C49005A419A999999F4982241666666665F005A41CDCCCCCCA0982241000000A06D005A4166666666B6982241000000A07D005A419A999999DA982241666666E688005A41CDCCCCCC09992241000000A092005A41CDCCCCCC279922416666662691005A419A9999992A9B2241CDCCCCACE0005A4100000000A69C22419A9999390F015A4166666666589D2241CDCCCC2C2C015A41CDCCCCCCFC9D2241CDCCCC8C56015A419A999999619F22419A9999B94A015A419A99999919A02241666666466F015A419A9999990FA12241000000408E015A413333333329A022419A9999599C015A4166666666B39F2241CDCCCCACA1015A4100000000BBA02241CDCCCC8CB1015A410000000033A22241CDCCCC4CC7015A419A9999994DA32241CDCCCC6CDB015A41CDCCCCCC82A422419A9999F9FA015A410000000065A522410000008020025A41CDCCCCCC15A722419A9999995D025A41CDCCCCCCECA72241CDCCCC2C7D025A4100000000DFA82241000000A09F025A4100000000D4A82241CDCCCC0CA2025A410000000080AA2241CDCCCC2CDE025A419A99999904AC2241000000E013035A41CDCCCCCC68AC22413333331320035A419A999999F9AC2241CDCCCCAC2F035A41CDCCCCCCC0AD2241333333F342035A41CDCCCCCCE8AD2241CDCCCC2C46035A416666666690AE22413333337349035A41CDCCCCCCF1AE22416666668647035A41CDCCCCCCCAAF2241333333D340035A4100000000D7AF22416666668641035A41666666665CB122410000008039035A413333333302B22241666666C636035A410000000063B322419A9999B932035A41CDCCCCCCB7B32241CDCCCCCC34035A416666666653B42241666666E639035A410000000021B522416666668641035A419A99999957B52241666666A645035A41333333337DBA2241000000A064035A419A99999995BB2241CDCCCCEC61035A413333333373BC2241666666665B035A4166666666F7BC22413333333358035A41333333333ABC2241CDCCCC8CF8025A41000000004CBC224166666606F8025A413333333379BC224133333373E3025A41CDCCCCCCADBC22419A9999B9CF025A4100000000D1BC22419A9999F9C5025A416666666627BD224133333393B4025A41CDCCCCCCA2BD22416666664699025A4100000000FEBD22419A99991980025A416666666653BE22410000002064025A41000000007FBE22413333335351025A4133333333A1BE2241666666E639025A419A999999C0BE2241CDCCCC4C2D025A419A99999958BE22419A9999592B025A413333333384BE22419A999959BD015A410000000030C1224100000020B3015A41000000005CC12241333333936D015A41CDCCCCCCE5C12241CDCCCC8C6E015A41CDCCCCCC12C222410000008043015A41CDCCCCCC10C222419A9999792E015A4166666666E9C122413333333324015A419A999999C5C122419A9999D920015A413333333368C122419A99991913015A4133333333BFC622419A9999B91E015A4100000000B2C822410000000020015A4166666666C5C822419A9999D9FA005A419A99999990CA2241333333B3FD005A4166666666BBCA2241CDCCCC8CD7005A4100000000C7CA2241CDCCCCECBC005A4166666666E1CA2241CDCCCC2CA2005A4133333333EACA22419A99991994005A4133333333EECA2241666666067A005A413333333301CB2241333333334D005A41333333330BCB2241333333933D005A41CDCCCCCCD1C92241CDCCCCEC47005A4166666666B9C922419A9999F93A005A410000000076C92241333333F31C005A410000000028C92241CDCCCC6CFFFF594100000000DAC722416666664603005A4100000000B7C722416666662608005A410000000023C72241CDCCCC2C23005A41CDCCCCCCD1C622419A9999B92B005A419A9999996EC622410000004048005A419A9999995DC62241666666064F005A413333333337C622413333331357005A4133333333E4C52241000000E05A005A410000000064C52241000000A059005A41CDCCCCCC27C52241333333935B005A4133333333C9C422416666662662005A416666666658C422419A9999D96C005A410000000032C42241333333536F005A419A99999984C322410000008076005A41CDCCCCCC19C32241CDCCCC6C77005A4133333333CBC22241333333137B005A419A99999975C22241666666A67C005A410000000038C22241666666867C005A41333333334DC122410000002084005A4100000000FBC022419A99991985005A4100000000ADC02241000000A065005A41666666667DC02241000000A056005A419A9999995DC02241CDCCCC6C4A005A413333333328C02241333333734B005A419A99999940BF2241CDCCCCCC55005A41CDCCCCCC5ABE224100000040FDFF594133333333F6BD2241000000E0FEFF59413333333360BD224100000060CFFF5941CDCCCCCC38BD2241CDCCCC4CC4FF59410000000034BD2241CDCCCC4CBFFF59419A99999968BD2241333333F3AAFF594133333333B0BD22419A9999198DFF594133333333C6BD22416666666685FF5941333333335ABC22419A9999F938FF59419A999999B3BD22419A99993912FF59410000000051BC224166666666CEFE5941000000002EBC2241000000E0C6FE594166666666EABB2241000000A0C3FE5941CDCCCCCC42BA22419A999939A8FE59410000000009BA2241CDCCCC4CA5FE5941000000002AB922419A9999B99CFE594166666666BEB82241333333B39BFE594133333333FAB72241666666669EFE59416666666634B722419A9999F99AFE59410000000091B62241CDCCCC2C9BFE5941333333330CB62241CDCCCC4CA3FE59410000000064B5224133333313B1FE5941CDCCCCCC35B52241CDCCCCECB5FE594100000000D8B4224100000080C3FE5941CDCCCCCC53B42241333333B3DCFE59410000000008B4224166666646ECFE594133333333C9B32241666666A6FBFE594100000000A1B32241000000C00AFF59416666666688B32241666666261BFF5941CDCCCCCC68B32241000000A026FF594166666666D9B222419A9999F944FF59419A999999C5B222419A99995940FF5941CDCCCCCCBEB12241666666A60BFF59410000000037B12241333333B3F1FE5941CDCCCCCC24B122419A999939EFFE59410000000093AF2241CDCCCC8CFCFE5941CDCCCCCC92AF22416666668606FF59419A9999999EAF2241CDCCCC8C0EFF59413333333373AA2241333333330FFF5941000000003EAA2241CDCCCC4C00FF5941CDCCCCCC1CAA224133333373EFFE5941666666661DAA2241CDCCCCACE4FE5941000000003CAA224100000060D5FE59410000000085AA22419A999919BDFE594166666666FEA92241333333B3BCFE5941666666666FA92241CDCCCC6CBFFE594100000000CCA8224166666666C3FE59410000000018A822419A9999F9C6FE5941CDCCCCCC37A62241CDCCCCCCD7FE5941666666665FA52241666666C6E0FE5941000000002DA52241000000A0CAFE5941CDCCCCCC4DA422410000004062FE594100000000BDA32241333333737CFE5941000000003DA32241333333F391FE5941666666665AA222416666666683FE594133333333A6A12241666666C69EFE5941333333338AA122410000008088FE59416666666655A12241000000E067FE59419A999999A49C2241CDCCCCCC83FE59413333333376992241000000C098FE594100000000E2992241CDCCCC2CF4FE594166666666129A22413333339316FF5941CDCCCCCC189A2241333333D31FFF594100000000F39822410000002018FF5941000000008D982241666666A617FF59413333333339992241CDCCCC8C3DFF594166666666989822413333331349FF59419A99999964992241666666C672FF5941CDCCCCCCDF9A224166666626BFFF5941CDCCCCCC259B2241CDCCCCECCDFF59419A999999E39A2241666666A6DDFF59419A9999997B9A22419A999999F1FF594133333333059A22416666664604005A4100000000CD9822410000000030005A41333333338B982241666666E63A005A41333333338B982241666666E63A005A41	01010000206A080000ECC182BFFAB2224134333353E4005A41	280130000	Z	Aunay-sous-Auneau	2801300	28013	28	24	20
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	01010000206A08000034CE6D144D8C214100000020B6185A41	280140000	Z	Aunay-sous-Crécy	2801400	28014	28	24	9
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	01010000206A080000DA3AEDBE3C992241000000E0F9065A41	280150000	Z	Auneau-Bleury-Saint-Symphorien	2801500	28015	28	24	34
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	01010000206A080000647DFA2861D42041333333331AE55941	280160000	Z	Les Autels-Villevillon	2801600	28016	28	24	10
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	01010000206A0800003B15B5C4F68D20416666669625E65941	280180000	Z	Authon-du-Perche	2801800	28018	28	24	35
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	01010000206A080000F1C3003430AE22419A9999C978DE5941	280190000	Z	Baigneaux	2801900	28019	28	24	12
01060000206A08000001000000010300000001000000B40200009A999999FB7D2141666666C629F85941000000003E7E2141666666E62DF85941CDCCCCCC7B7E2141CDCCCCAC31F8594100000000D27E21416666660637F85941333333331A7F2141000000403BF8594133333333767F2141CDCCCC2C41F8594166666666D17F21416666668646F859410000000001802141CDCCCC6C49F859419A9999992F802141666666264CF85941000000007C802141CDCCCC2C50F8594100000000C4802141666666A653F859413333333309812141000000E056F859419A9999990D8121419A99991957F8594100000000F27E2141000000C0E4F859419A999999207F214100000020E6F859419A9999998E7F2141CDCCCC2CE9F85941CDCCCCCCCD7F2141333333F3EAF859419A999999FF7F21419A999959ECF859410000000065802141CDCCCC8CEFF8594166666666C78021419A999939F2F859419A999999198121419A9999B9F4F85941333333334D8121419A999939F6F859413333333393812141CDCCCC4CF8F85941CDCCCCCCC2812141CDCCCCACF9F8594100000000F98121419A999939FBF859419A99999926822141000000A0FCF85941CDCCCCCC5F822141CDCCCC2CFEF85941000000008F8221419A999959FFF8594133333333D6822141000000A001F95941CDCCCCCC42832141333333B304F959419A999999758321419A99991906F95941CDCCCCCCB1832141CDCCCCEC07F9594100000000E5832141CDCCCC4C09F959410000000011842141666666A60AF959419A9999993A842141CDCCCCEC0BF959419A99999960842141000000200DF95941CDCCCCCC8D8421419A9999790EF9594133333333E28421419A99997911F95941000000000A852141333333F312F9594100000000158521413333337313F9594133333333178521413333333314F95941CDCCCCCC168521419A99993915F959419A99999911852141CDCCCC0C17F959419A999999FD842141333333931BF9594166666666DD8421419A99997923F959416666666668882141000000005DF95941CDCCCCCC5D8821413333339361F9594133333333538821410000008065F959419A99999947882141333333F369F959419A9999993B8821419A9999596EF95941666666662E882141333333B372F9594100000000238821416666668676F959410000000016882141333333337AF9594100000000058821419A9999F97EF9594166666666F58721410000002083F9594133333333E18721419A9999F988F95941CDCCCCCCF2872141666666068AF959419A99999913882141000000608CF959410000000033882141333333B38EF959419A999999588821419A9999F991F95941CDCCCCCC71882141333333F393F959410000000083882141000000A095F95941333333339C882141333333D397F95941CDCCCCCCAD882141CDCCCC6C99F9594133333333BD882141333333339AF9594100000000D2882141333333F39AF95941CDCCCCCCED882141CDCCCC0C9CF95941CDCCCCCC028921419A9999D99CF95941CDCCCCCC238921419A9999799EF95941666666664889214133333333A0F959419A9999996689214100000000A2F95941CDCCCCCC90892141CDCCCC6CA4F95941CDCCCCCCB3892141CDCCCC8CA6F9594166666666E089214166666626A9F95941000000000B8A214133333393ABF959419A9999993D8A214133333393AEF9594100000000628A21419A999999B0F959419A9999998E8A214166666626B3F959419A999999B98A2141000000A0B5F9594133333333E68A214100000020B8F95941CDCCCCCC0C8B21419A999959BAF959419A999999358B2141CDCCCCACBCF959419A999999498B2141000000E0BDF95941000000005B8B2141CDCCCC2CBFF9594166666666688B2141333333B3C0F9594100000000748B214133333373C2F9594133333333808B2141666666E6C4F95941333333338C8B2141000000E0C7F959419A999999998B21419A999939CBF9594133333333A48B21419A999919CEF95941CDCCCCCCB38B214133333333D2F959419A999999C38B2141CDCCCC4CD6F959419A999999CC8B214133333393D8F9594100000000D18B214100000020DAF95941CDCCCCCCDA8B214100000080DCF95941CDCCCCCCE18B214100000040DEF95941333333330E8C214133333353E6F9594166666666458C214166666646F0F959419A9999997F8C2141CDCCCCACFAF9594100000000AB8C2141CDCCCC6C02FA59419A999999F98C21410000008010FA594100000000168D2141000000E015FA59419A9999991E8D21419A99993917FA594133333333288D21416666660618FA5941666666664E8D2141000000E019FA594100000000828D2141666666261CFA594166666666B78D2141666666C61EFA594133333333008E21419A99999922FA5941000000004C8E21410000008026FA594166666666768E2141666666E628FA594133333333A48E2141666666862BFA5941CDCCCCCCBC8E2141333333F32CFA594100000000D08E2141333333132EFA59419A999999308F2141666666A633FA59419A9999996C8F2141333333D336FA59419A9999999B8F21416666666639FA594133333333C48F21419A9999B93BFA594166666666E38F2141000000C03DFA594166666666099021416666664640FA59416666666623902141666666A642FA5941CDCCCCCC45902141666666C645FA5941CDCCCCCC6E902141666666C649FA59419A9999998D9021419A9999394CFA5941CDCCCCCCC8902141CDCCCC6C50FA59419A999999FF9021410000006054FA59410000000040912141CDCCCC2C59FA59413333333391912141000000405FFA594133333333C79121419A9999F962FA5941CDCCCCCCE3912141000000C064FA5941CDCCCCCC01922141CDCCCC6C66FA59419A999999359221413333331369FA5941333333336D922141CDCCCCEC6BFA594133333333AE922141666666066FFA594133333333F2922141CDCCCC0C72FA594166666666509321413333333376FA594133333333909321416666660679FA594100000000E5932141333333D37CFA59410000000039942141CDCCCCAC80FA5941333333338C9421410000006084FA594100000000C79421410000006086FA59419A999999F29421416666666687FA59419A99999908952141333333F387FA5941666666660E952141CDCCCCAC88FA5941333333332C952141CDCCCCEC86FA59419A9999992F952141CDCCCCCC87FA5941CDCCCCCC33952141000000C08BFA59419A9999993D9521419A9999B992FA594133333333449521410000008092FA5941666666664F952141666666A692FA59419A999999729521416666664693FA59419A999999A89521419A99997994FA594166666666E49521413333339395FA5941CDCCCCCC2F962141CDCCCC0C97FA5941000000005A962141CDCCCCCC97FA59410000000076962141CDCCCC2C98FA594166666666B39621416666662698FA5941CDCCCCCCD99621410000000098FA59416666666606972141000000A097FA594100000000329721419A99997997FA5941666666664F9721416666660697FA594166666666679721413333335396FA594100000000809721410000004095FA594166666666959721419A99991994FA594133333333BB972141666666E691FA5941666666661C982141CDCCCCCC8BFA594133333333539821410000000088FA5941666666666A982141CDCCCC6C86FA594166666666E4982141333333F37DFA5941000000004F9921416666668676FA5941CDCCCCCC9D9921416666662671FA594100000000D4992141CDCCCC8C6DFA59419A999999369A21419A9999B974FA594100000000A29A2141000000E06CFA594133333333C49A2141333333536FFA59419A999999E99B2141000000205DFA5941CDCCCCCCF99B2141666666066CFA594133333333009C21410000000072FA594166666666089C2141666666C677FA59419A999999129C2141000000207DFA5941666666661E9C2141000000E082FA594100000000249C21410000000085FA594100000000879C21419A99999981FA5941666666663A9D2141CDCCCCEC79FA594166666666589D2141000000207BFA5941000000000C9E2141333333B3B6FA5941CDCCCCCC419E2141CDCCCC8CB4FA5941000000007D9E2141000000E0B1FA594133333333AE9E21419A9999D9AFFA59419A999999F99E2141CDCCCCCCACFA594100000000479F214133333373A9FA59419A999999949F21419A999979A6FA594133333333E39F214100000040A3FA59410000000032A02141000000C09FFA5941000000007CA02141CDCCCCAC9CFA59410000000097A02141000000809BFA594166666666A3A02141CDCCCCCC9BFA59419A999999AAA02141666666C69CFA594133333333C4A021419A999939A2FA59419A999999EDA02141000000E0AAFA5941000000001CA12141666666A6B4FA59419A99999949A121419A999959BEFA59413333333376A1214166666606C8FA59419A999999A7A1214133333393D2FA59419A999999C6A1214100000060D9FA594166666666F7A12141CDCCCC6CE3FA5941000000002EA22141CDCCCCECEEFA59416666666666A2214100000020FBFA5941333333336DA221419A999999FCFA5941CDCCCCCCD8A3214133333393E8FA5941CDCCCCCC04A5214166666646CFFA594166666666FAA6214133333353A8FA59410000000096A62141000000A0A1FA5941666666666FA621419A9999B99EFA5941CDCCCCCC75A621419A9999799DFA59413333333385A62141000000C099FA59416666666692A621419A99997998FA5941333333339CA62141000000A097FA59419A999999A7A621410000008096FA5941CDCCCCCCAFA621416666666695FA594166666666B8A621413333331394FA5941CDCCCCCCB1A621413333337391FA59419A99999982A62141CDCCCCCC84FA5941CDCCCCCC45A621419A99997974FA59413333333327A62141333333B36BFA59416666666610A621416666668663FA594100000000F2A521419A99991956FA594100000000DDA521410000000051FA594166666666C6A52141000000204DFA59419A99999994A521410000002045FA59419A99999975A52141000000803EFA5941666666667AA521410000006038FA5941CDCCCCCC81A52141333333132FFA59410000000083A521413333333328FA59410000000036A621419A9999791DFA5941CDCCCCCCCFA62141CDCCCCEC14FA594133333333C6A621419A99997912FA594100000000A9A62141000000A00AFA5941333333338DA621410000004002FA59410000000071A62141666666A6F9F959416666666666A62141666666E6F7F959419A9999995FA621419A999999F7F959419A99999958A6214100000040F8F959416666666635A6214133333313FDF959410000000010A621419A9999D901FA594100000000F3A521410000004006FA5941CDCCCCCCEBA521416666662607FA59419A999999E1A521410000004007FA5941CDCCCCCCD8A52141666666A606FA5941CDCCCCCCCEA52141CDCCCC6C04FA59419A999999B1A52141CDCCCC2CFCF95941000000008EA52141CDCCCC0CF2F959416666666688A521419A999919F0F959419A9999998AA52141CDCCCCCCEDF959413333333392A5214166666666E9F959419A99999998A52141CDCCCC6CE5F959419A999999A8A52141666666C6DBF95941CDCCCCCCA9A52141CDCCCC0CDBF95941666666661FA72141000000A0CEF9594100000000E6AA21419A999999A0F95941CDCCCCCCD2AA2141CDCCCC2C9EF9594133333333ADAA21416666666699F95941CDCCCCCC9FAA2141333333D397F959416666666695AA21419A99997996F95941CDCCCCCC83AA21410000002094F95941333333335BAA2141666666A68EF959419A9999993CAA2141333333738AF959419A99999925AA2141666666C686F959419A99999913AA2141CDCCCCAC83F95941666666660AAA2141666666C681F959416666666602AA2141CDCCCC4C80F95941CDCCCCCCF4A92141CDCCCC2C7DF959419A999999E5A921419A9999D979F959419A999999D4A92141333333D375F95941CDCCCCCCBEA92141666666E670F9594100000000ACA921419A9999796CF95941CDCCCCCC9AA921416666666668F959419A9999998CA921419A99991965F959419A99999976A92141000000205FF959419A99999964A921410000006059F95941333333335CA921413333337356F95941CDCCCCCC55A921416666664654F959419A99999947A921419A9999194FF95941333333333AA92141CDCCCCAC49F95941CDCCCCCC2AA92141000000E042F95941666666661CA92141666666863BF95941CDCCCCCC10A921410000006035F959413333333317A921416666666631F95941333333330AA92141CDCCCC4C2CF959419A99999903A921416666666626F959419A999999F6A821419A99999922F9594100000000E3A821419A9999791EF9594166666666D0A82141333333531AF9594133333333C3A821410000006017F9594166666666B1A82141CDCCCCEC13F959419A999999A0A821416666662610F959419A99999992A82141CDCCCC2C0DF959419A99999985A82141333333D30AF95941333333336EA821419A9999D905F959416666666650A82141000000C0FEF8594100000000C0A721416666666601F959413333333346A72141666666A602F95941666666663EA621413333339307F959419A99999903A62141666666C608F95941CDCCCCCCCAA521419A9999D909F959410000000090A521419A9999D90AF95941333333335BA52141333333930BF95941CDCCCCCC21A52141666666060CF95941CDCCCCCCF2A421419A9999190CF9594100000000AFA421419A9999F90BF95941CDCCCCCC7CA42141CDCCCCCC0BF95941CDCCCCCC39A421419A9999390BF959419A999999E8A32141000000000AF9594133333333BEA321413333335309F9594100000000BAA321416666660607F9594166666666A5A321410000004004F959413333333367A321419A999939FBF85941CDCCCCCC37A321419A999939F4F859419A999999F3A2214100000040EAF859419A999999CAA22141CDCCCC2CE4F859410000000076A2214133333353D7F859413333333350A22141000000A0D1F85941000000001EA221419A999919CAF859413333333302A221419A9999D9C5F8594133333333E2A121419A9999F9C0F85941CDCCCCCCBCA1214133333393BBF859416666666693A1214100000060B5F85941CDCCCCCC6DA12141000000E0AFF859419A99999933A1214100000000A7F85941CDCCCCCC0DA1214100000080A1F8594166666666D4A02141CDCCCC0C99F8594133333333B2A02141333333D393F859419A99999902A02141CDCCCCCC78F85941CDCCCCCC899F21413333333368F85941333333333D9F2141666666C65CF85941CDCCCCCCD99E2141666666464DF8594166666666A89E21419A9999B945F85941000000002E9E2141666666E631F8594133333333F99D21410000008029F8594100000000789D21419A99997918F8594166666666529D2141CDCCCC4C13F8594133333333219D21419A9999F90BF8594133333333549D21419A9999B908F8594100000000789D21416666664605F85941CDCCCCCC219C2141CDCCCC0CCCF7594166666666AE9B2141000000C0B5F75941CDCCCCCC009C2141CDCCCC0CADF75941333333335C9A2141CDCCCCCC82F75941CDCCCCCC079A2141000000407AF7594166666666FA992141333333F378F759419A999999F29921419A9999F977F7594133333333EB9921419A99991977F759419A999999CD9921416666662674F7594100000000A69921419A99991970F75941666666667A992141CDCCCCAC6BF759410000000055992141000000A067F759416666666634992141CDCCCC0C64F7594133333333F3982141CDCCCC4C5DF7594166666666CE982141000000A059F759419A9999999A982141CDCCCC2C54F75941666666666D982141000000604FF759410000000043982141CDCCCC0C4BF759413333333323982141333333D347F75941000000006B9721416666666655F75941000000003C9621410000008016F7594166666666D0952141CDCCCC4C00F75941CDCCCCCC9896214166666606EEF65941666666664F962141CDCCCCACE5F659419A9999990896214100000060DEF659419A999999C59521419A999919D8F659419A9999992B952141333333B3C9F6594166666666FF93214100000080AAF659419A99999927942141CDCCCC8CA4F6594100000000E69321416666660699F6594100000000BB9321419A9999198AF659410000000045942141333333F376F6594100000000D19421413333339361F6594100000000B69521410000000040F65941CDCCCCCC009621419A9999F934F659416666666670952141333333731FF659413333333305952141666666E612F6594133333333AA9421419A9999391FF6594100000000A49421419A9999B91EF65941333333335E9421419A99999915F65941CDCCCCCC17942141000000200CF6594166666666E29321410000000005F65941666666668993214166666666F8F55941333333334693214166666626EFF55941000000001D93214100000060E9F5594100000000F19221419A999939E3F5594166666666CC92214133333353DEF55941333333339A9221419A999979D7F559410000000080922141CDCCCCECD3F559419A9999996392214133333313D0F559419A999999439221419A9999F9CBF559416666666622922141CDCCCC8CC7F559419A999999FD91214133333393C2F55941CDCCCCCCDF91214166666666BEF55941CDCCCCCCC4912141CDCCCCCCBAF5594133333333A7912141333333D3B6F559410000000088912141333333B3B2F55941666666666D9121419A999919AFF55941666666664A9121419A999959AAF559419A9999992B91214133333313A6F55941333333331891214166666686A3F55941666666660991214166666666A1F559416666666604912141666666869FF559419A99999903912141333333139EF5594166666666109121419A99997999F559419A99999960912141333333F38EF55941CDCCCCCC76912141000000808CF55941333333338D912141CDCCCCCC8AF5594133333333E2912141CDCCCC2C85F55941CDCCCCCC189221419A99993981F559410000000062922141666666867CF559413333333375922141333333937BF5594100000000929221419A9999F97AF5594133333333E4922141333333937AF55941666666664A932141333333937AF559410000000085932141CDCCCC2C7AF55941666666669A9321416666664679F559419A999999A79321413333335378F5594133333333B2932141CDCCCC2C77F5594166666666C29321419A9999F973F5594166666666D1932141CDCCCC8C71F5594100000000DE9321413333331370F55941CDCCCCCCE7932141333333536FF5594133333333FF932141666666266EF559419A99999948942141000000C06BF5594133333333B29421413333337367F559419A99999911952141CDCCCC6C64F5594100000000339521416666660663F5594133333333389521410000004062F559419A9999993D952141CDCCCCEC60F559419A9999991F952141333333D35FF55941333333330B9521419A9999195FF5594100000000F9942141000000405EF5594166666666DE942141333333D35CF55941CDCCCCCCC09421419A9999F95AF559419A999999AD9421413333339359F55941000000009C9421410000002058F559419A999999859421413333333356F55941CDCCCCCC6B942141CDCCCCCC53F55941CDCCCCCC48942141333333B350F5594100000000249421419A9999594DF55941CDCCCCCC07942141000000C04AF5594100000000E69321413333337347F5594166666666C49321410000002044F55941666666669B932141000000E03FF55941CDCCCCCC7A9321419A9999193CF5594166666666609321419A9999D938F559410000000042932141000000E034F5594100000000289321413333331331F55941666666660D932141000000002DF559419A999999F09221419A99999928F5594100000000DB9221413333331325F5594166666666BA922141666666E61FF55941666666669A922141CDCCCC2C1BF55941666666667D9221413333333317F559416666666670922141333333B315F5594100000000619221416666662614F559413333333346922141333333D311F55941333333332E9221416666662610F559419A9999991B922141333333130FF55941333333330C922141CDCCCC4C0EF5594133333333EF912141CDCCCC0C0DF5594166666666D0912141000000C00BF5594100000000A79121419A9999190AF55941000000008A912141666666E608F559419A9999997E912141CDCCCC4C08F55941666666667B9121416666660609F5594133333333729121419A9999D909F559413333333365912141CDCCCCCC0AF55941CDCCCCCC35912141333333730EF5594100000000EE902141CDCCCC6C14F5594133333333B09021419A9999191AF559413333333397902141CDCCCC4C1CF559410000000073902141CDCCCCAC1FF5594133333333449021416666666624F55941CDCCCCCC0E9021413333339329F5594166666666EA8F2141333333532DF55941CDCCCCCCB18F21410000000033F5594166666666828F21413333339337F55941CDCCCCCC638F2141666666663AF559419A999999408F21419A9999993DF5594100000000178F21410000004041F55941CDCCCCCCF28E21416666664644F55941CDCCCCCCA38E2141CDCCCC8C4AF559419A999999878E2141CDCCCCAC4CF55941CDCCCCCC5D8E2141CDCCCCEC4FF5594166666666388E21419A9999B952F5594166666666148E21419A99997955F5594133333333F28D21419A9999F957F5594166666666CA8D2141000000205BF559419A999999A88D21419A9999395EF559419A9999998A8D2141CDCCCC0C61F5594166666666758D21416666664663F55941CDCCCCCC4E8D2141CDCCCC8C67F55941000000001B8D2141000000806DF5594133333333008D2141CDCCCC8C70F5594100000000DF8C2141666666A674F559419A999999BE8C21419A9999B978F559419A999999A18C2141000000807CF5594100000000838C2141333333D380F55941333333336E8C21419A99991984F559419A9999995C8C21410000006087F5594166666666428C2141333333B38CF5594166666666318C21419A9999F98FF5594166666666228C21419A99999992F55941CDCCCCCC148C21419A99997994F559419A9999990A8C2141666666A695F55941CDCCCCCC038C21419A99995996F559419A999999EA8B21419A9999B998F559419A999999BB8B2141333333339CF559419A999999888B214133333333A0F55941333333335B8B21419A9999D9A3F5594166666666298B21419A999999A7F5594100000000FA8A2141CDCCCC6CABF5594100000000CE8A214100000080AEF55941CDCCCCCCA48A214133333313B1F5594133333333748A2141666666A6B3F559419A999999478A214100000000B6F559419A9999991C8A2141333333D3B7F5594133333333D78921419A999999BAF559419A999999A2892141000000A0BCF55941CDCCCCCC7C8921419A9999D9BDF55941666666664B8921419A999939BFF5594133333333128921419A9999D9C0F5594166666666D688214100000080C2F55941CDCCCCCC79882141333333D3C4F559410000000057882141666666A6C5F55941000000002D88214166666646C6F55941666666660A882141CDCCCC2CC6F5594166666666FA872141CDCCCCECC5F559419A999999E1872141CDCCCC6CC5F559419A999999CE872141CDCCCC8CC4F559419A999999AF872141CDCCCC0CC3F559416666666696872141666666E6C1F5594133333333718721419A999919C0F55941333333335E872141CDCCCC2CBFF559413333333321872141666666C6BCF5594100000000FB862141CDCCCC4CBBF5594100000000E486214166666666BAF5594100000000D3862141CDCCCC0CBAF5594100000000C586214166666606BAF5594166666666C5862141333333F3B8F55941CDCCCCCCC28621419A9999D9B7F5594133333333A5862141666666E6B5F55941CDCCCCCC7A862141666666E6B2F55941666666663A862141000000A0AEF55941666666660C86214100000040ABF5594166666666F2852141CDCCCC2CA9F559419A999999D78521419A999959A7F5594100000000AA85214133333393A4F55941666666665C85214100000000A0F55941CDCCCCCCF2842141CDCCCCCC99F559419A999999DF8421410000006098F559419A999999DB8421419A99993997F5594100000000CB8421410000004098F5594166666666AB842141333333B39FF55941333333331A852141666666C6ADF55941CDCCCCCC5385214133333313B5F559419A9999997385214100000080B9F55941CDCCCCCC8F85214133333393BDF55941333333339E852141666666E6BFF5594100000000A3852141000000E0C0F55941666666666F85214133333393C3F559419A999999458521419A999939C6F55941333333335085214133333313CAF55941000000002E8621419A999979F4F559416666666664862141333333D3FEF559419A9999998D8621413333337306F659419A999999AD862141333333D30BF6594133333333AC862141000000E00DF6594166666666A4862141CDCCCC8C0FF659413333333381862141CDCCCC8C13F65941CDCCCCCC4A862141666666E617F659410000000006862141666666461CF6594133333333CA8521410000008020F65941CDCCCCCC83852141000000E025F659419A9999994B852141666666262AF65941CDCCCCCC09852141000000202FF659419A999999C48421419A99995934F659413333333353842141000000E03CF659416666666638842141333333D33EF65941000000002D842141CDCCCCCC3FF65941CDCCCCCC098421416666668642F659419A999999DF8321419A9999F945F6594133333333BD8321416666660649F659419A999999A4832141666666A64BF6594100000000818321419A9999F94FF65941333333335C832141CDCCCC2C55F659413333333320832141000000C05FF659419A99999916832141000000E061F65941000000000E8321416666668663F65941666666660B832141CDCCCC4C64F6594166666666FE8221419A99991968F6594133333333E8822141666666A66EF65941CDCCCCCCC88221416666660677F6594100000000B18221419A9999B97DF6594133333333948221413333339384F659419A9999998F8221419A99995986F6594166666666A4822141CDCCCCAC86F659419A999999B9822141333333D387F659419A999999F4822141333333338BF659419A99999926832141333333138EF659419A99999946832141000000A08FF659419A99999957832141CDCCCC8C90F659419A9999995D8321413333333391F659419A99999953832141CDCCCCCC92F65941333333333D8321419A99995997F659419A99999922832141000000C09CF65941000000000B8321419A999919A2F6594100000000FC822141333333D3A5F6594166666666F2822141CDCCCCCCA8F6594166666666E4822141333333B3AFF6594166666666DF822141666666C6B2F659419A999999D882214166666626B6F6594133333333D0822141333333B3B8F659419A999999C8822141CDCCCC8CB9F6594100000000048321419A9999F9C3F659419A99999940832141CDCCCCCCCDF659416666666679832141666666A6D6F65941CDCCCCCC9683214166666626DBF65941CDCCCCCCB0832141CDCCCCECDFF6594100000000C7832141CDCCCCECE3F6594100000000F4832141CDCCCC8CECF6594166666666168421419A999959F3F6594100000000388421419A9999F9F9F65941000000005084214133333353FEF6594100000000C582214133333353FAF65941CDCCCCCCE68121416666664611F75941CDCCCCCC558121416666662603F759416666666650812141333333B303F759416666666600812141333333330BF7594133333333AB802141CDCCCC4C13F75941666666666B8021413333337319F759416666666667802141666666061AF7594166666666858021419A9999591EF759419A999999A8802141333333D323F75941CDCCCCCCC68021410000008028F7594100000000E4802141000000C02CF759413333333302812141CDCCCC2C31F759419A999999218121419A9999F935F759419A999999488121419A9999B93BF7594100000000888121419A99991945F7594100000000C5812141CDCCCC0C4EF75941CDCCCCCC038221416666668657F7594133333333308221419A9999395EF75941CDCCCCCC608221413333339365F759419A99999983822141000000A06AF75941666666669C822141666666C66DF75941CDCCCCCCB98221419A9999D970F7594100000000E98221410000004075F759416666666623832141CDCCCC2C7AF75941666666664C832141666666667EF759419A99999973832141CDCCCC8C82F75941CDCCCCCC8A832141333333B384F7594100000000988321419A99999986F7594100000000988321416666666687F75941CDCCCCCC7E832141333333F386F75941CDCCCCCC67832141CDCCCCAC86F759416666666631832141666666C686F7594100000000EA8221410000006087F759419A9999999E822141CDCCCC0C88F75941CDCCCCCC3A822141666666468AF759419A999999D8812141CDCCCC8C8CF75941333333338E812141333333F38DF75941CDCCCCCC378121419A9999B98FF7594166666666EA8021416666660691F75941666666669A802141CDCCCCEC91F75941CDCCCCCC428021419A99999992F75941CDCCCCCC0B8021419A9999D992F759419A999999D97F2141CDCCCC6C92F75941CDCCCCCCAB7F21419A9999B991F759419A999999827F2141CDCCCC8C90F75941CDCCCCCC537F2141000000208FF759419A9999993D7F2141000000808EF75941333333333D7F2141CDCCCCAC8FF7594166666666467F2141CDCCCC4C90F75941333333335D7F2141CDCCCC0C97F759419A9999997C7F2141666666E6A0F75941CDCCCCCCAB7F214166666626AFF7594133333333C47F21419A999999B6F759419A9999999E7F2141CDCCCCECBBF759419A999999747F21419A999939C2F759419A999999497F2141333333B3C9F75941000000001B7F214166666626D3F7594166666666F07E214133333333DBF7594100000000A87E214166666646E8F759419A999999937E2141333333F3ECF7594100000000677E2141333333D3F8F759419A999999FB7D2141666666C629F85941	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	01010000206A0800009D20F90ED68D2141CCCCCC0CFFF75941	280210000	Z	Bailleau-le-Pin	2802100	28021	28	24	17
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	01010000206A080000731B217480C12141000000602F065A41	280220000	Z	Bailleau-l'Évêque	2802200	28022	28	24	20
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	01010000206A0800006DBED8AF63492241666666267D0A5A41	280230000	Z	Bailleau-Armenonville	2802300	28023	28	24	18
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	01010000206A08000042FC6FB72BE9214133333363FCFC5941	280240000	Z	Barjouville	2802400	28024	28	24	4
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	01010000206A08000096E789D0EED42241CCCCCC2CC5F35941	280260000	Z	Baudreville	2802600	28026	28	24	13
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	01010000206A080000E22773D98BC92041CCCCCCECACE05941	280270000	Z	La Bazoche-Gouet	2802700	28027	28	24	38
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	01010000206A0800000674A61D9E20224100000010DEDA5941	280280000	Z	Bazoches-en-Dunois	2802800	28028	28	24	19
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	01010000206A08000019DAADB915B12241CDCCCC6C4EE25941	280290000	Z	Bazoches-les-Hautes	2802900	28029	28	24	17
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	01010000206A0800009FFA740A4DD42041333333F38E1B5A41	280300000	Z	Beauche	2803000	28030	28	24	17
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	01010000206A080000E05E05F9C8B52041CDCCCC5C1FEC5941	280310000	Z	Beaumont-les-Autels	2803100	28031	28	24	21
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	01060000206A080000010000000103000000010000007F01000033333333D7322241666666E6BEF159410000000021332241666666A6D4F15941CDCCCCCC6533224166666606E9F1594100000000B8332241333333D300F25941CDCCCCCCBE3322413333331302F259410000000021342241333333131FF2594133333333933422416666662640F259419A999999FE3422419A9999F95FF259416666666602352241CDCCCCAC61F259419A999999353522413333333370F25941CDCCCCCCA5352241666666E68FF25941CDCCCCCCCD3522419A9999599CF2594133333333CE3522419A9999799FF259419A9999992B36224133333313A6F25941666666665236224166666666A8F259419A999999EC36224133333393B3F25941CDCCCCCC65372241333333D3BBF25941CDCCCCCC7E3722419A999939BDF2594100000000F3372241CDCCCCECC1F259413333333300382241CDCCCC6CC2F25941CDCCCCCC1238224100000020C3F25941CDCCCCCC62372241333333F3FCF259419A999999D3362241CDCCCC0C2CF35941333333336535224133333373A3F35941CDCCCCCCBF342241CDCCCC6CD9F3594133333333BF3422419A999959DAF3594166666666C534224166666626DBF3594133333333CA34224133333333DBF3594166666666D534224133333393DBF359419A999999DB342241CDCCCCACDBF35941CDCCCCCCEC34224100000000DCF35941333333331D352241CDCCCC2CDCF35941CDCCCCCC95352241666666C6DDF359419A999999B6352241000000A0DDF359419A999999BE35224133333353DDF3594133333333F835224133333373DBF359419A9999996136224133333373D7F35941333333338836224100000060D6F35941000000009C362241333333D3D5F35941CDCCCCCCFC36224100000020D4F35941666666663D372241000000C0D2F35941CDCCCCCC4C37224166666626D2F35941666666666E37224100000080D1F3594133333333CD372241CDCCCCECCFF359413333333330382241CDCCCCCCCDF359419A99999990382241CDCCCC8CCCF359419A999999023A22419A999979CAF35941CDCCCCCC2A3A224100000080CAF35941CDCCCCCC4D3A224133333373CAF35941CDCCCCCCAC3A2241CDCCCC2CCAF3594133333333D03A224166666666CAF359419A999999E33A2241666666E6CAF3594100000000023B2241CDCCCCECCBF35941333333335C3B2241333333F3CFF359419A999999F83B224166666666D6F359419A999999303E2241000000C0EDF35941333333336F3E2241333333B3EFF359419A999999903E224133333393F0F359419A999999973E2241333333D3EBF35941000000009A3E22419A999979EAF3594133333333B83E2241CDCCCC8CDEF35941CDCCCCCCE23E224166666646D1F35941CDCCCCCC543F22419A999979B5F359419A9999997F3F22419A999919ACF359419A999999B73F2241000000C09EF3594166666666EA3F2241666666E696F359419A9999996D402241CDCCCCCC85F35941000000009B402241666666E67FF3594166666666C6402241CDCCCC2C7AF359419A999999654122419A9999F964F35941CDCCCCCCC94122410000006058F359413333333320422241333333D34CF35941333333336C422241666666E643F3594133333333974222419A9999F93FF3594100000000CC422241333333933AF3594100000000F24222416666660636F35941CDCCCCCC2E432241666666A62FF359410000000049432241333333532CF359416666666661432241000000002AF35941CDCCCCCC7B4322419A9999D926F3594100000000994322413333335321F35941CDCCCCCCAA432241333333131AF35941CDCCCCCCB24322410000002018F35941CDCCCCCCC74322419A9999D917F3594100000000044422413333339315F3594133333333E6442241000000A009F3594166666666ED442241666666860CF359416666666608452241CDCCCC6C15F359416666666614452241CDCCCC6C1CF359413333333317452241333333F31FF35941CDCCCCCC17452241CDCCCCEC26F35941666666660F452241333333733DF359410000000011452241CDCCCCAC42F359419A9999990F4522413333335344F35941CDCCCCCC14452241333333934AF359419A99999944452241000000805FF35941666666667B4522419A99993974F3594133333333814522419A9999B976F3594133333333D8452241666666A697F3594100000000FF45224100000080A2F3594100000000084622419A999979A4F359419A9999990B46224100000060A5F35941666666661B4622419A9999F9A3F3594100000000FA4822413333335387F359419A9999992D4922419A99993985F3594133333333DD492241000000007EF3594166666666274B22413333337370F3594133333333954C2241666666C662F359419A999999294D2241CDCCCCEC5CF3594166666666614E2241333333F350F359419A999999864F22413333333345F359416666666696502241CDCCCCEC3AF35941CDCCCCCCFE5022419A99999936F359419A9999998E512241CDCCCC2C31F3594100000000A9512241333333D32FF3594100000000705222410000002028F3594166666666955222410000006026F35941666666664F532241000000801FF3594166666666715322419A9999D91DF3594133333333D6532241000000401AF3594100000000365422419A99993916F35941CDCCCCCCA45422416666662612F3594100000000C95422419A99997910F35941CDCCCCCC3B5622416666662602F35941666666664D5622410000000001F35941000000002D5622419A999979F7F25941CDCCCCCC9655224133333373D3F25941CDCCCCCCAC55224100000040D0F2594133333333C4552241000000E0CCF25941CDCCCCCCE15522419A999999C8F259413333333358572241CDCCCC0C26F35941000000001B582241000000A00BF359413333333388582241666666C626F35941333333338D592241CDCCCCCC02F3594100000000035A224166666666F2F2594133333333555A22419A9999B9E7F25941CDCCCCCC6A5A2241CDCCCC8CE4F2594133333333815A22419A999939E1F259419A999999065D22413333339386F25941CDCCCCCC195D22419A99997989F259419A9999991D5D2241CDCCCC0C8AF2594133333333545D2241333333F392F259419A9999994A5E2241CDCCCC2CB9F25941333333338B5E22419A999959C4F2594133333333375F2241333333F3E2F25941666666667E5F2241CDCCCC8CEEF2594166666666E35F22419A999939E0F25941CDCCCCCC97602241000000C0C6F2594166666666FA612241CDCCCC0C94F259416666666670622241CDCCCCCC83F25941CDCCCCCCCA622241CDCCCCAC76F259410000000027632241333333336AF25941CDCCCCCC3C632241000000E066F2594133333333846322419A9999595DF2594133333333EA6322419A9999B950F25941CDCCCCCCEA6322410000004050F25941CDCCCCCC5C642241000000C042F2594100000000BE6422419A9999D936F2594100000000A0652241666666261BF2594133333333A4652241CDCCCC2C1AF2594100000000A767224166666606DCF159419A999999456822419A999999C8F15941000000006A682241333333D3C3F159419A9999997B6822419A999999C6F15941000000007E682241333333F3C6F15941666666660069224100000080E2F1594166666666076A2241333333731BF25941333333332F6A22413333339323F2594100000000016B2241CDCCCCCC05F2594100000000EC6B2241666666E6E5F15941333333333D6C2241333333B3DBF15941CDCCCCCC246D224100000040BCF15941CDCCCCCCC56D2241CDCCCCECA5F15941333333330D6E2241333333939CF15941CDCCCCCC366E22410000002097F15941CDCCCCCC6C6E22419A99991990F1594133333333236E2241CDCCCC0C80F1594133333333C16D2241333333736BF1594133333333DE6D22410000002069F15941CDCCCCCCFC6E2241CDCCCC4C4FF15941CDCCCCCCCD6F2241666666C63BF1594133333333107022416666660636F15941333333338A702241666666862AF15941666666668E702241666666662AF159419A999999137122419A9999391EF159413333333361712241666666A615F1594100000000847122419A99999912F15941CDCCCCCC807122419A9999F908F15941000000008671224133333313FAF05941666666664971224133333333FDF05941333333332C712241666666C6FEF059413333333308712241CDCCCCAC00F1594166666666FF702241000000C0FEF05941CDCCCCCCE4702241000000A0F9F0594100000000CF70224133333393F5F05941CDCCCCCCBD702241CDCCCC0CF2F0594133333333B2702241CDCCCC4CEFF0594133333333A1702241000000A0EAF059419A9999998E702241CDCCCC2CE7F05941000000007670224133333393E2F05941CDCCCCCC4D702241333333F3DBF059419A9999993470224133333393D6F05941000000002670224133333353D5F05941CDCCCCCC0970224133333393D1F05941CDCCCCCCFC6F2241000000C0CEF059419A9999990C702241CDCCCCCCCCF05941CDCCCCCC0B71224133333333ADF05941666666662D71224133333333A9F059419A99999914712241333333B3A9F059419A9999990D71224166666686A9F059419A9999990471224166666666A8F0594166666666F6702241000000E0A4F0594166666666B57022410000006092F0594100000000AA702241CDCCCCEC8FF05941CDCCCCCC487022416666664675F0594133333333D96F2241CDCCCC0C55F0594133333333D06F2241CDCCCC6C53F059419A999999A06F2241666666064DF0594100000000686F22413333339346F05941CDCCCCCCE56E22419A99995939F05941000000005B6F22419A9999D930F0594100000000266F2241666666E61EF05941333333335F6E2241333333F32AF0594133333333C06D2241666666A61AF0594166666666CF6C2241CDCCCC6C01F0594166666666806C224166666626F9EF594133333333946B224100000060E0EF594100000000D96A224100000080CCEF594133333333556A22419A999939D6EF59419A999999346A2241CDCCCC2CD8EF594100000000C3692241CDCCCC8CDDEF5941CDCCCCCC3E692241000000C0E2EF5941333333332C69224100000060E4EF594100000000E268224133333353E8EF594166666666B4682241CDCCCC4CECEF5941CDCCCCCC9D682241333333F3EDEF594166666666FF672241000000A0FBEF594133333333B5672241000000A003F059410000000053672241000000600CF05941333333337D6622419A9999F91EF059419A999999F96522410000000029F059413333333316652241666666A6FDEF59419A999999D663224166666646BEEF5941CDCCCCCC93632241000000E0BFEF5941000000005E632241CDCCCCCCC1EF5941666666663F632241000000A0C2EF594166666666BC62224166666646C8EF59419A999999E46122413333339398EF59419A999999D1602241CDCCCC2C5CEF594133333333E45E22419A9999B997EF594166666666B65E2241000000208DEF5941000000008A5E22410000008081EF5941000000006C5E2241333333F378EF594133333333675E22410000000077EF59419A999999485E22413333331370EF5941CDCCCCCC1D5E22419A9999F968EF594100000000BA5D2241666666265AEF5941CDCCCCCCA15D22416666668656EF59419A999999925D22419A99993954EF5941CDCCCCCC3D5D2241666666E646EF594100000000B95C22419A9999F959EF5941CDCCCCCC615C22419A9999F966EF5941CDCCCCCC1E5C2241CDCCCC6C70EF5941000000001A5A2241CDCCCCAC33EF594133333333F55922419A9999592FEF594166666666805922419A99995920EF5941666666663E5822419A9999B9F9EE5941CDCCCCCCB3572241000000C0E8EE594166666666BD5622419A999939CBEE59419A999999AB562241CDCCCC8CCDEE594166666666215622419A9999D9D6EE59419A999999C1552241333333B3DCEE59416666666652552241CDCCCC4CE5EE59416666666631532241333333530AEF594166666666275322419A9999B90AEF59410000000006532241CDCCCCCC0DEF594100000000F1522241333333D30FEF5941CDCCCCCCAC522241CDCCCCEC18EF59410000000082522241000000001CEF59410000000070522241CDCCCCCC1DEF594166666666435222413333335324EF5941CDCCCCCC175222416666664629EF5941CDCCCCCCEF5122419A9999F92DEF594133333333BA512241666666A633EF5941666666665D512241000000003EEF59419A999999055122419A99993949EF594133333333BF502241333333D350EF594166666666BE5022416666664651EF5941CDCCCCCC6A502241CDCCCC0C5BEF594166666666285022416666668662EF594100000000AE4F2241CDCCCCAC71EF594100000000894F22410000002076EF594100000000434F2241CDCCCC4C7DEF594166666666E14E22416666666688EF594133333333DE4E22410000002089EF594166666666464E2241333333139BEF594133333333EA4D2241000000A0A5EF594166666666AA4D224166666666A9EF594100000000BB4C22419A999999B5EF5941333333333F4C2241CDCCCC8CBCEF594100000000C34B2241CDCCCC0CC3EF594100000000A94B2241CDCCCCECC3EF5941000000009E4B2241CDCCCC4CC4EF594166666666814B2241666666C6C4EF5941CDCCCCCCEE4A2241333333B3C5EF594100000000D74A2241CDCCCCECC5EF5941CDCCCCCCC04A224166666686C6EF594133333333A64A2241CDCCCC0CC8EF5941CDCCCCCC754A224100000080CBEF594133333333334A2241666666A6CFEF594166666666254A22419A999939D0EF594133333333C149224100000000D7EF59419A999999AB492241333333D3D7EF5941CDCCCCCC8C49224100000040DAEF5941333333338A4922419A999979DAEF5941000000007549224166666626DCEF5941CDCCCCCCCB492241CDCCCC6CECEF594100000000094A2241000000A0F9EF59419A999999124A2241000000C0FBEF594100000000534A22419A9999990AF05941CDCCCCCC7C4A2241333333F313F0594133333333984A2241000000A01AF0594100000000D34A22413333335328F0594133333333434B22416666660644F0594166666666764B2241666666C650F0594100000000704B2241666666E650F0594100000000F34A2241000000E053F059419A999999F1492241333333B35AF059410000000049492241333333F35FF0594133333333B64822413333333364F05941666666668E4822413333339364F0594166666666ED4722410000000069F059419A999999A0482241CDCCCCEC7CF059419A999999DF4822410000004084F05941000000004A4922416666668690F0594166666666564922419A9999F991F05941CDCCCCCCC8492241333333339FF059419A9999993E4A224166666606AEF0594133333333174A2241666666C6AFF0594100000000064A224100000000B0F059419A999999DB492241333333F3B0F0594166666666C649224133333393B1F059419A99999944492241CDCCCC4CB5F059419A999999924722419A9999B9C1F059416666666600462241CDCCCC6CCCF05941CDCCCCCCDE452241333333F3CBF05941CDCCCCCC6F45224100000000CAF05941CDCCCCCCD8432241CDCCCC2CC4F059419A999999794322419A999979C2F0594133333333DA42224100000060C0F0594100000000CE4122419A999919BCF0594166666666A041224100000060BBF05941000000005C4122419A999999BAF05941333333332341224166666686B9F05941000000000E41224133333353B9F05941CDCCCCCCCE40224100000060B8F059419A9999998C3E224133333333AFF05941CDCCCCCC7D3E224166666606AFF05941333333337B3E224100000000AFF05941CDCCCCCC6A3E22419A999999AEF0594166666666823E224166666686A6F0594166666666BD3E22410000000093F059419A999999D13E2241333333538CF0594166666666283F22419A9999996EF05941000000003F3F2241CDCCCCCC66F05941CDCCCCCC643F2241CDCCCCCC59F05941CDCCCCCC883B22419A99993941F05941000000005D3B22413333333350F0594166666666E83A22419A9999F976F05941CDCCCCCC933A22416666660692F0594166666666663A224100000040A1F05941666666661F3A2241CDCCCC4CB9F05941CDCCCCCCB63922419A999939DCF059419A9999992A3922419A9999F909F1594100000000E9382241666666E607F159416666666697382241333333F305F159419A9999993A382241CDCCCC8C04F1594166666666203722410000008001F1594133333333F7362241000000A000F159419A999999B136224133333373FEF059410000000086332241CDCCCC6CC7F1594166666666E1322241CDCCCC2CBFF1594133333333D7322241666666E6BEF15941	01010000206A0800005D7C943AD2512241666666365CF15941	280320000	Z	Beauvilliers	2803200	28032	28	24	23
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	01010000206A080000165D743135F720416666668622085A41	280330000	Z	Belhomert-Guéhouville	2803300	28033	28	24	11
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	01010000206A080000D642DB212AE82141000000704D0B5A41	280340000	Z	Berchères-Saint-Germain	2803400	28034	28	24	28
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	01060000206A08000001000000010300000001000000150100009A999999C60622416666668676FA59413333333346072241333333B37DFA5941CDCCCCCCE30822413333333396FA5941000000005F092241333333D39DFA59416666666693082241CDCCCC4CC3FA59413333333378082241CDCCCCACC8FA594133333333B408224133333393D2FA5941000000001309224133333373E2FA5941666666665F0922419A9999B9EFFA594166666666CB0922419A9999990FFB5941CDCCCCCC170A22413333331312FB5941CDCCCCCC120A2241666666E613FB59419A9999990E0A2241000000601BFB59419A9999990C0A2241000000E01EFB5941666666660D0A2241333333132BFB5941CDCCCCCC0E0A22419A9999393FFB5941666666660A0A2241666666E644FB594133333333100A22419A99995952FB59419A999999120A22419A99999957FB59419A999999180A2241CDCCCC8C5DFB5941CDCCCCCC850A2241333333F358FB59419A999999220B22413333335352FB5941666666668A0B2241333333F34DFB5941666666668C0B22419A9999F950FB5941CDCCCCCCD60B22419A99991975FB5941CDCCCCCCD70B22419A99997975FB594133333333760C2241000000A069FB5941CDCCCCCC990C2241333333D376FB59419A999999EB0C22419A9999B988FB594100000000340D2241000000A095FB59419A999999F40C2241000000409AFB594100000000DD0C22419A9999F99BFB594133333333E40C2241CDCCCC6C9DFB594133333333C90D2241CDCCCC2CCBFB594166666666B30D224133333373CEFB59419A999999BB0D2241CDCCCC6CD1FB594133333333610D2241CDCCCCCCDFFB5941CDCCCCCC740D224166666646E4FB5941CDCCCCCCEB0D2241CDCCCC8C00FC5941CDCCCCCC080E22413333337307FC5941666666661A0E2241333333730BFC5941000000009B0E2241CDCCCCAC28FC5941CDCCCCCC9C0E22419A9999392BFC594166666666D80E22419A9999992FFC594166666666420F22416666664638FC594100000000A90F2241000000E041FC5941CDCCCCCC091022410000006049FC59416666666653102241666666A64CFC5941CDCCCCCC60102241333333134DFC59413333333377102241000000C04DFC594133333333F51022419A99999951FC59419A999999751122419A9999D956FC594166666666C6112241333333335AFC594100000000F8112241333333335DFC59419A999999381222419A9999B95FFC59419A999999B81222410000004066FC59419A99999939132241000000806EFC59416666666608142241666666067AFC5941CDCCCCCC731422410000000080FC5941333333338B142241000000E082FC5941CDCCCCCC9F1422410000006086FC5941CDCCCCCCB2142241333333338CFC594166666666CE142241CDCCCCCC9CFC5941CDCCCCCCEB14224133333393B0FC594133333333FA142241000000A0C2FC5941333333330215224166666626C7FC5941666666661415224133333393D1FC594166666666161522419A999979D3FC59413333333325152241666666C6E1FC59419A9999992C152241CDCCCCCCE8FC5941000000003415224100000040ECFC5941333333333D15224100000020F0FC59419A999999481522419A9999F9F8FC5941CDCCCCCC8C1522419A999999EFFC594166666666A415224133333353ECFC594100000000F1152241666666C6E1FC59419A9999991B162241CDCCCCECDBFC594100000000931622419A999979CBFC5941000000009C1622419A9999B9C9FC59419A9999990217224133333373BBFC5941CDCCCCCC0C1722419A999919BAFC5941000000002417224166666606B7FC59416666666650182241666666268FFC5941000000004A1A2241CDCCCC0C4CFC594166666666F41A22410000002035FC594100000000341C2241666666660BFC594166666666591C22413333339306FC59419A999999DA1C22419A9999D9F5FB5941CDCCCCCCE71C224100000020F4FB594166666666981D2241CDCCCCCCDCFB594100000000D31D22419A999919D5FB59419A999999DB1D2241333333F3D3FB594133333333241E22419A999919CAFB5941000000004F1E2241CDCCCC4CC4FB59419A999999C81E22419A999979B4FB594100000000F41E2241CDCCCC8CAEFB5941CDCCCCCC3E1F2241CDCCCC4CA4FB594166666666701F2241666666869DFB59419A999999791F2241333333539CFB594133333333CF1F22416666662691FB5941CDCCCCCC272022413333339385FB5941CDCCCCCCA7202241333333B374FB5941CDCCCCCCBE202241CDCCCCAC71FB59419A999999C82022410000006070FB59413333333302212241CDCCCCCC68FB594166666666112122419A9999D966FB59419A999999272122419A9999F963FB5941333333333B2122419A99997961FB5941CDCCCCCC72212241333333535AFB59419A999999F3212241CDCCCC6C4AFB5941000000006E2222419A9999993BFB594166666666B42222410000002033FB59416666666608232241CDCCCCEC28FB5941CDCCCCCC62232241CDCCCCEC1DFB59413333333344242241CDCCCC8C02FB5941666666667A24224166666606FCFA594100000000A8242241CDCCCC8CF6FA5941CDCCCCCCD725224133333373D2FA5941CDCCCCCCFB252241CDCCCC2CCEFA5941000000005126224100000000C4FA594133333333BE26224100000000B7FA5941CDCCCCCC022722419A9999D9AEFA594100000000272722419A999959AAFA59419A9999995527224133333393A4FA594133333333AC272241333333D399FA594133333333EE272241000000A091FA5941CDCCCCCCBA2822413333339377FA594100000000F62822410000000070FA594166666666892922419A9999395DFA594100000000AF2922416666666658FA594100000000442A22416666666645FA594133333333332B2241000000E026FA594133333333472D224100000000E3F9594100000000932D22419A999959D9F9594166666666F52D22419A9999D9CCF95941666666666D2E224166666686BDF9594100000000722E2241CDCCCCECBCF9594133333333BA2F22413333339393F95941CDCCCCCC01302241333333938AF959413333333320302241CDCCCCCC86F9594100000000DA2F2241000000E07BF9594133333333C12F2241CDCCCC6C77F95941000000008F2F2241666666666EF95941000000006F2F2241CDCCCCEC66F9594133333333612F2241333333B363F9594133333333342F2241000000C056F95941CDCCCCCC132F2241666666E64BF9594100000000F42E22410000004041F9594133333333B32E2241000000E02FF95941666666666A2E22419A9999F91DF9594100000000672E2241000000201DF95941CDCCCCCC1A2E2241CDCCCC6C0FF9594133333333C82D22416666666602F9594133333333C12D2241000000E000F95941CDCCCCCC6E2D224100000000F5F85941000000000C2D224100000020E6F8594133333333DE2C22419A999939DFF859419A999999852C2241666666E6D1F85941CDCCCCCC602C224166666646CBF85941333333334D2C2241666666E6C5F8594133333333422C2241CDCCCC0CC1F8594100000000392C22419A999979BAF8594133333333372C22419A9999D9B7F8594100000000342C2241333333D3B2F859419A999999312C22419A9999B9A7F8594133333333352C22419A9999799EF85941CDCCCCCC362C22419A9999B99BF859419A999999632C2241333333334DF8594133333333732C22419A9999793BF85941000000007B2C2241666666C635F8594166666666842C2241666666E62EF859419A9999998D2C2241000000E02AF859419A999999A02B2241CDCCCC0CE5F759419A999999C62A224100000040F2F75941666666667F2A224133333353F6F7594100000000F02922419A9999B9FEF7594166666666E82A2241333333534CF8594166666666C72A22419A9999194EF8594166666666512A22416666662655F859419A999999DF292241333333335BF85941CDCCCCCCE92822416666668667F8594166666666762822419A9999F96CF85941CDCCCCCCB6272241CDCCCC4C2AF8594166666666A62722416666664626F8594100000000A0272241333333B324F859413333333382272241000000C01FF8594100000000F82622419A9999F902F85941333333333B262241CDCCCCECDAF75941333333331326224133333373D2F7594133333333A1252241666666A6BAF759419A999999CF242241666666A68DF759419A9999998E242241CDCCCCCC7FF759419A999999782422419A99993981F759419A999999E2232241CDCCCCEC8BF759419A999999DB232241CDCCCC0C89F7594133333333C72322410000000083F759413333333312232241CDCCCC2C45F7594100000000E1222241666666E633F759419A99999957222241CDCCCC6C38F75941CDCCCCCCD2212241CDCCCC2C3CF759419A9999992E212241666666C641F759419A9999990C212241333333D342F7594166666666C6202241333333532FF75941CDCCCCCCC0202241333333D32DF759419A9999996B202241CDCCCC4C17F759419A999999E71F2241CDCCCCEC17F7594100000000601F2241CDCCCC0C19F75941CDCCCCCCB11E2241000000A019F7594100000000621D2241CDCCCCAC1BF7594166666666421D2241333333731BF759419A9999992D1A22410000006021F7594133333333DD1922413333331321F759416666666642192241666666C621F7594100000000101722413333335324F75941333333336F1722413333339316F759413333333375182241CDCCCC6CF0F65941CDCCCCCC881822419A999999EDF659419A99999967172241000000E0EDF65941CDCCCCCC4816224133333333EEF65941CDCCCCCCD41522419A999919EEF6594166666666BF152241CDCCCC2CEEF65941CDCCCCCCF4152241CDCCCC8CE0F65941CDCCCCCC8D16224133333313B7F659419A9999999416224166666686B5F6594133333333591422419A999959ACF65941CDCCCCCCF9132241333333F3AAF65941333333339A1322419A999959FCF65941666666669F122241333333F3F3F65941666666668B12224166666606F3F659419A999999C91122419A999999E3F6594100000000AD102241CDCCCC6CCCF65941CDCCCCCC990F2241CDCCCCCCB6F6594133333333820F2241CDCCCC6CB3F6594100000000F60E2241666666E69CF659419A999999F70C2241000000A0DEF65941CDCCCCCCF10C2241333333D3DFF6594100000000F70B2241666666C602F7594133333333510C2241000000E011F7594133333333250D22410000006033F7594100000000830B2241666666E66BF759419A999999630B22419A9999D966F7594100000000C70A22419A99995979F759419A999999350A2241CDCCCCCC62F759413333333377092241000000C088F7594133333333AA092241333333B392F759419A999999730A2241CDCCCCECB9F7594166666666C60B224133333313FCF75941333333336A0C2241666666261BF8594100000000740C2241666666061DF85941CDCCCCCCA50C2241CDCCCCAC26F8594166666666A50C2241CDCCCC2C38F859419A999999A40C2241333333F3A0F8594100000000760C2241CDCCCC6CA1F859419A9999990A0C224166666686A2F859419A9999996A0B2241000000E0A3F8594133333333000B2241CDCCCCCCA4F85941CDCCCCCC360A2241CDCCCC8CA6F859419A9999992B0A22419A9999B9A6F8594133333333DB092241000000E0A7F85941CDCCCCCCE00922419A9999D9ADF859419A999999E5092241000000C0B4F85941CDCCCCCCE9092241666666A6BAF8594100000000020A2241CDCCCC0CCAF859419A999999050A224100000080CCF8594100000000370A224166666606F0F85941333333334A0A224100000000FBF8594133333333AC0A22419A99997929F9594133333333E00A22413333339340F9594133333333AF0A22419A99999942F95941CDCCCCCC910A2241666666A643F9594133333333850A2241333333F348F9594166666666C7092241CDCCCC4C84F959410000000089082241666666E6E7F959413333333347082241000000E0FCF959410000000059072241CDCCCC4C48FA59416666666608072241333333D361FA59419A999999C60622416666668676FA5941	01010000206A08000011272AAF941B224100000030C5F95941	280350000	Z	Berchères-les-Pierres	2803500	28035	28	24	20
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	01010000206A0800004CACBEDFCA1F2241CCCCCC6CA62C5A41	280360000	Z	Berchères-sur-Vesgre	2803600	28036	28	24	12
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	01010000206A0800003C41D74EE00921416666662641225A41	280370000	Z	Bérou-la-Mulotière	2803700	28037	28	24	13
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	01010000206A080000A21C2E03A69A2041343333D30DEB5941	280380000	Z	Béthonvilliers	2803800	28038	28	24	12
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	01010000206A08000046BFCA3A966D2241CCCCCCEC55005A41	280390000	Z	Béville-le-Comte	2803900	28039	28	24	20
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	01010000206A080000B2D0199179552141666666F62C075A41	280400000	Z	Billancelles	2804000	28040	28	24	12
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