SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep2a;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep2a is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep2a','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep2a','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep2a','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep2a"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800008EDD1197FA063241000000E026545741	2A0010000	Z	Afa	2A00100	2A001	2A	94	12
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	01060000206A08000001000000010300000001000000220000006666666636F23141333333D31E4E57413333333352F23141000000C0354E5741CDCCCCCC64F2314133333333364E5741333333B3BCF2314133333313424E574166666666C8F2314133333353484E57419A999999D7F23141000000A04A4E574100000080FEF2314166666666624E574133333333E9F2314166666666634E57419A99999917F33141CDCCCC0C764E5741666666E627F3314133333353744E5741666666E63CF33141666666E6804E5741666666E649F331419A9999F9804E57419A9999194BF33141CDCCCCEC934E57416666666681F33141666666A6964E5741CDCCCCCC8CF331419A999999944E5741333333B395F3314100000000864E574100000080AFF33141666666A67B4E5741CDCCCC4CFCF331419A999999684E57416666666630F43141666666E6614E5741CDCCCCCC40F43141666666665E4E5741666666664AF43141333333B3584E5741000000003CF4314166666686494E5741333333B325F43141CDCCCC8C2D4E57419A99991919F4314133333393154E5741CDCCCC4CE6F33141CDCCCCCC164E5741CDCCCCCCB7F33141CDCCCC2C194E5741CDCCCCCC72F33141000000401B4E5741333333333CF33141000000A0194E5741CDCCCC4CEDF2314100000020164E574100000000D2F231419A999999164E57419A999999B1F23141CDCCCCAC194E57413333333363F23141333333D31A4E57416666666636F23141333333D31E4E57416666666636F23141333333D31E4E5741	01010000206A0800003A9E879397F33141CCCCCCEC544E5741	2A0040102	H	Saint-Jean	2A00401	2A004	2A	94	0
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	01010000206A0800008A512E3A54F33141000000F0BD4D5741	2A0040103	H	Place Abbatucci	2A00401	2A004	2A	94	0
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	01060000206A080000010000000103000000010000003900000000000080F3F4314166666606834D57410000000004F53141CDCCCC2C804D5741666666E605F5314100000000774D5741666666E68AF53141666666C6784D57419A9999198CF5314100000080754D5741333333B36DF5314133333393744D57419A9999996EF53141CDCCCC0C714D57410000008017F53141666666C66F4D57413333333319F5314100000060684D574166666666F3F43141666666C6674D57419A999919F6F431419A9999F95B4D57419A99999902F53141CDCCCC4C5B4D5741CDCCCCCCFAF43141CDCCCCEC514D5741666666E6D1F53141000000A0464D574100000000CFF5314100000040424D5741333333B302F63141000000003C4D57419A999999E2F53141666666063D4D57419A999919CCF5314166666646424D5741333333B3DBF43141CDCCCCCC4E4D574166666666E8F4314166666626144D574100000080E2F43141000000A0154D5741CDCCCCCCB3F431419A9999B9154D5741333333339FF4314100000080294D5741CDCCCCCC60F431419A9999D9244D5741666666E631F431419A9999391B4D57416666666626F43141CDCCCC6C1F4D574166666666A1F3314166666686154D5741333333B39DF3314166666646184D5741CDCCCCCC76F3314166666606174D57416666666664F3314100000020194D5741CDCCCCCC3FF3314133333313304D57410000008013F33141000000A0304D5741666666661BF33141666666A6324D57410000008002F33141000000A03F4D574133333333EBF2314100000040454D574133333333F3F231419A999999494D5741333333B3F0F23141666666E6554D57419A9999991AF33141666666E6674D5741333333332CF33141CDCCCC4C744D5741CDCCCC4C20F3314133333333794D5741666666E62AF331419A9999F97C4D57410000008033F33141CDCCCCEC794D57419A99991988F3314100000060744D5741666666E6A1F3314100000080714D5741CDCCCCCCAAF33141333333137C4D5741CDCCCC4CC9F33141333333B3774D5741CDCCCCCCE0F3314133333393774D574166666666E1F331419A9999197C4D574100000080ECF331419A999939794D5741666666E61CF43141333333B3784D5741CDCCCC4C2EF43141666666E6754D5741CDCCCC4C30F43141CDCCCCAC7B4D57410000000048F43141666666267C4D57419A9999197BF43141333333F37A4D574100000000E8F4314166666606834D574100000080F3F4314166666606834D574100000080F3F4314166666606834D5741	01010000206A08000074301A68E7F33141666666464B4D5741	2A0040201	H	Centre Ville	2A00402	2A004	2A	94	0
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	01010000206A0800001210269B70D53141000000B0D94D5741	2A0040402	H	Résidence des Îles	2A00404	2A004	2A	94	35
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	01060000206A080000010000000103000000010000002900000033333333DCF13141000000004E4E574100000080E3F1314166666666524E5741CDCCCCCC21F23141CDCCCC4C5E4E5741666666E633F23141CDCCCCEC634E57410000008054F231419A9999F9744E57410000000071F231419A9999B9804E5741333333B379F23141333333B38A4E57419A9999996FF231419A9999F98E4E5741666666664CF2314133333353944E5741CDCCCC4C38F231419A999999924E5741333333331DF23141666666C69F4E57419A99991942F2314133333333A44E57413333333341F231419A999939B44E57419A99999951F23141666666A6BE4E57419A9999996FF231419A999999CA4E5741CDCCCC4CA4F23141CDCCCC2CC34E5741666666E6C4F2314100000080BD4E5741CDCCCC4CD9F2314166666606C64E5741666666E6FBF23141666666A6D04E5741000000001EF331419A999919D74E57419A99999944F3314100000020C14E57419A99999950F33141CDCCCCCCAF4E5741CDCCCCCC6FF3314133333393A44E5741333333B387F3314100000060984E57416666666681F33141666666A6964E57419A9999194BF33141CDCCCCEC934E5741666666E649F331419A9999F9804E5741666666E63CF33141666666E6804E5741666666E627F3314133333353744E57419A99999917F33141CDCCCC0C764E574133333333E9F2314166666666634E574100000080FEF2314166666666624E57419A999999D7F23141000000A04A4E574166666666C8F2314133333353484E5741333333B3BCF2314133333313424E5741CDCCCCCC64F2314133333333364E5741666666E64EF23141CDCCCCEC374E5741000000001CF231419A9999B9404E574133333333F4F13141CDCCCCCC494E574133333333DCF13141000000004E4E574133333333DCF13141000000004E4E5741	01010000206A080000727272F2E2F2314100000080874E5741	2A0040501	H	Les Palmiers	2A00405	2A004	2A	94	0
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	01060000206A0800000100000001030000000100000028000000CDCCCC4C68F8314133333333CE4E57419A999999A1F83141000000E0D84E57419A999919ADF83141666666E6DE4E5741CDCCCC4CB8F831419A999939EC4E5741CDCCCC4CB0F83141000000C0F04E5741666666E6A3F8314133333393094F574100000080A4F83141CDCCCC2C134F574100000080ABF83141000000001B4F574166666666D4F83141666666C63E4F5741666666E6E0F83141000000A0474F574100000080F8F83141666666A6524F57416666666615F93141000000005E4F57419A9999193FF931419A999919644F57416666666653F93141666666666C4F57419A9999996FF93141333333D3694F574166666666A4F93141000000C06C4F5741333333B33FFA314133333353824F5741333333B371FA314100000000834F57410000008078FA3141333333D37E4F57410000000090FA31419A9999D97E4F5741333333B39FFA3141000000806F4F57410000000052FA3141666666E6664F5741666666E641FA314166666646664F5741333333B33CFA314100000040604F57419A99991972FA31419A999999524F57413333333385FA31419A9999F94B4F57419A9999198BFA314100000020424F5741333333335FFA3141000000C03D4F5741CDCCCC4C32FA31419A9999B9334F5741CDCCCC4C01FA3141000000602A4F5741CDCCCCCC9DF9314100000080134F5741000000008BF93141333333930A4F57419A99991983F93141333333B3FA4E57419A9999197AF93141000000E0EF4E57416666666667F9314166666686E74E5741333333B340F9314166666666DD4E57419A99999911F931419A999999C04E5741666666E6A0F8314100000060CB4E5741CDCCCC4C68F8314133333333CE4E5741CDCCCC4C68F8314133333333CE4E5741	01010000206A08000038A60EFF4CF93141000000C0234F5741	2A0040802	H	Avenue Franchini	2A00408	2A004	2A	94	0
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	01010000206A0800005A14545B16073241666666F6B3505741	2A0040902	H	La Confina	2A00409	2A004	2A	94	5
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	01010000206A0800003615768012F53141666666F69E505741	2A0040903	H	Suartello	2A00409	2A004	2A	94	6
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	01060000206A08000001000000010300000001000000390000009A999999AAF431419A9999F9774E574100000080ABF4314100000040654E57419A99999997F431419A999919644E5741666666E69AF431419A9999593D4E57419A999919D1F43141CDCCCCAC3D4E574133333333D3F4314166666686374E574133333333D5F4314100000020174E574100000080F6F43141CDCCCCEC0E4E5741666666666DF53141CDCCCC6C184E5741666666E674F53141CDCCCC8C1A4E5741666666E671F53141333333533A4E5741666666666BF53141CDCCCC4C3A4E57419A99991970F53141000000A0424E574100000000B0F53141666666A6514E574100000000B7F53141333333534E4E5741333333337EF5314100000000424E5741333333337DF5314100000080344E57416666666680F53141000000C01A4E57419A9999199CF5314100000000164E57419A99991994F53141000000C0134E5741000000007CF5314100000020164E57410000000001F53141000000600C4E57419A999919EEF4314100000080074E5741666666E6C8F4314133333393E94D57419A999919BBF4314166666686E84D5741CDCCCCCC1EF4314166666686EB4D5741666666661CF431419A999979D94D57413333333307F43141000000C0D54D5741333333B30AF4314133333353E34D5741000000800BF3314166666606E84D574133333333DBF23141CDCCCC2CE94D5741666666E6C1F2314133333353F04D5741333333B35DF2314166666646024E57419A99999949F2314133333333034E5741CDCCCCCC21F23141CDCCCC0C004E574166666666E1F1314166666626F74D574100000080DAF13141666666E6FA4D57419A9999190BF23141333333B3044E5741666666E63FF23141333333D3074E5741000000803DF23141666666A60E4E5741000000005CF231419A9999391B4E57419A999999B1F23141CDCCCCAC194E574100000000D2F231419A999999164E5741CDCCCC4CEDF2314100000020164E5741333333333CF33141000000A0194E5741CDCCCCCC72F33141000000401B4E5741CDCCCCCCB7F33141CDCCCC2C194E5741CDCCCC4CE6F33141CDCCCCCC164E57419A99991919F4314133333393154E5741333333B325F43141CDCCCC8C2D4E5741000000003CF4314166666686494E5741666666664AF43141333333B3584E5741CDCCCCCC40F43141666666665E4E5741CDCCCC4C5EF4314100000060624E5741666666666DF4314166666666734E57419A999999AAF431419A9999F9774E57419A999999AAF431419A9999F9774E5741	01010000206A08000084DE12337BF4314100000020274E5741	2A0040101	H	La Gare	2A00401	2A004	2A	94	0
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	01060000206A080000010000000103000000010000003A00000066666666E8F4314166666626144D5741CDCCCCCC43F53141000000E0034D57419A99999945F53141CDCCCC4C024D5741666666E6E1F43141333333D3134D5741666666E6D4F431419A999999134D57419A999999E3F431419A999919084D5741CDCCCCCC1BF531419A999999F64C5741000000005AF5314166666626F34C5741000000007AF53141000000A0F84C57410000008056F531419A999999FF4C5741CDCCCCCC77F53141333333D3FA4C574100000000EFF53141000000C00F4D57410000008000F6314166666686294D57419A99999913F6314100000080284D57419A99991905F63141000000C0134D57419A99991910F63141000000C00B4D57410000000013F6314100000080044D5741666666E602F6314100000000FF4C574100000000E6F531419A9999F9FA4C574100000000C3F531419A9999F9F34C574100000000B4F5314133333373EF4C57410000000095F53141333333D3EA4C5741000000007BF531419A999939E94C57410000000067F531419A9999B9E44C5741000000804BF5314100000040E14C57410000000058F5314166666666D64C5741CDCCCCCC36F5314100000000D14C57419A9999992BF5314133333313D24C5741333333B31AF5314100000020CA4C5741666666662EF53141000000C0C34C5741000000002AF5314133333333C04C574100000000F5F431419A999939BE4C574100000000B3F4314100000000BE4C574100000000A7F4314100000020C04C57410000000009F4314133333373D14C574100000000AAF3314100000000D94C574166666666ADF3314166666606E04C574100000080A3F3314166666646E54C57410000000085F331419A9999F9E54C5741CDCCCC4C6DF3314166666606EA4C57410000008051F33141000000E0FF4C5741000000804DF3314133333393FF4C5741CDCCCC4C2EF33141666666661A4D5741CDCCCCCC12F331419A9999192F4D57410000008013F33141000000A0304D5741CDCCCCCC3FF3314133333313304D57416666666664F3314100000020194D5741CDCCCCCC76F3314166666606174D5741333333B39DF3314166666646184D574166666666A1F3314166666686154D57416666666626F43141CDCCCC6C1F4D5741666666E631F431419A9999391B4D5741CDCCCCCC60F431419A9999D9244D5741333333339FF4314100000080294D5741CDCCCCCCB3F431419A9999B9154D574100000080E2F43141000000A0154D574166666666E8F4314166666626144D574166666666E8F4314166666626144D5741	01010000206A080000280C229F3BF43141666666F6F64C5741	2A0040202	H	Place Foch	2A00402	2A004	2A	94	0
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	01010000206A080000C0156F8850F23141343333B3374D5741	2A0040203	H	Cours Grandval	2A00402	2A004	2A	94	0
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	01010000206A080000B7EF4AF2B3F0314166666686364D5741	2A0040301	H	Balestrino	2A00403	2A004	2A	94	1
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	01060000206A080000010000000103000000010000002D0000006666666660F23141CDCCCCCCCA4C57410000000046F2314100000000C74C57410000000039F23141CDCCCCECBF4C57410000000019F23141CDCCCC0CBA4C574100000000FCF1314166666606AF4C5741666666E603F23141000000C0AB4C5741666666E6FEF1314100000080A14C57410000000005F2314100000040974C57410000000003F23141666666E6824C574100000080F8F1314100000000784C574100000000E9F13141000000406E4C574100000000C0F13141333333535F4C5741333333338DF1314100000040544C57410000000050F13141CDCCCCEC4A4C57410000000005F13141333333F3464C574100000000E1F03141000000C04B4C574100000000B9F03141666666064E4C57410000000092F03141000000E04D4C5741000000005AF03141CDCCCC4C4C4C57413333333354F03141666666064F4C5741333333B351F031419A9999F9594C57419A9999195EF03141CDCCCC8C5A4C57419A99999941F03141CDCCCC4C694C5741CDCCCC4CF1EF31419A9999798E4C574100000080C9EF31419A999979894C574100000000AAEF3141666666C6864C57419A99999994EF314100000080874C5741333333B36BEF31419A9999198D4C5741333333B354EF314133333333994C5741333333332BEF3141CDCCCCACA84C5741CDCCCC4C1BEF3141CDCCCCCCB44C57410000008050EF314166666646BC4C5741CDCCCCCC5BEF314100000060C14C5741000000006CEF3141CDCCCC2CBA4C5741CDCCCC4C86EF314133333353BD4C5741333333B3A3EF314133333373C74C5741666666E614F0314133333373CF4C5741CDCCCC4C31F03141333333F3CE4C57410000008073F03141CDCCCC8CCA4C574100000080C4F03141000000E0CF4C5741CDCCCCCCF9F13141000000E0E64C5741000000001BF2314166666646CA4C5741666666E650F231419A999919CE4C57416666666660F23141CDCCCCCCCA4C57416666666660F23141CDCCCCCCCA4C5741	01010000206A080000E472349EAFF03141000000B0964C5741	2A0040302	H	Boulevard Fred Scamaroni	2A00403	2A004	2A	94	0
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	01010000206A0800006EA0D3E6D7EE3141CDCCCCEC394C5741	2A0040401	H	Parc Berthault	2A00404	2A004	2A	94	0
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	01010000206A080000F30EEECB3AF031419A999969DB4E5741	2A0040502	H	La Gravona	2A00405	2A004	2A	94	1
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