SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep31;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep31 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep31','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep31','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep31','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep31"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A08000001000000010300000001000000C902000066666666D30D204133333313EBDA574166666666D40D20419A999979EFDA574133333333D60D204100000080F3DA574166666666DE0D20419A999959FADA5741CDCCCCCCE50D2041CDCCCCECFEDA574100000000EB0D20413333337303DB574133333333F10D2041666666C606DB5741CDCCCCCCFC0D2041666666460ADB574100000000050E2041666666E60DDB5741333333330F0E20413333333311DB574166666666190E2041CDCCCC2C14DB5741CDCCCCCC1F0E2041CDCCCC0C16DB5741000000002B0E2041CDCCCC8C18DB574166666666320E2041333333331BDB5741CDCCCCCC350E2041333333131EDB5741333333333A0E20410000002021DB574100000000460E2041CDCCCC4C26DB574133333333510E20416666660629DB5741CDCCCCCC590E2041000000402BDB57419A999999650E2041333333B32EDB5741000000006E0E20410000008030DB5741000000007E0E2041CDCCCCCC32DB5741CDCCCCCC850E20410000002034DB574133333333910E20419A99999936DB5741666666669A0E20410000002039DB574166666666A90E20413333335342DB5741CDCCCCCCAA0E2041CDCCCCEC45DB574100000000AE0E2041666666864ADB574133333333C10E2041333333D354DB574100000000D00E2041333333335BDB57419A999999D90E20413333339364DB574166666666DA0E20410000008065DB574166666666DA0E20410000002067DB574166666666D50E2041000000A068DB57419A999999C60E20419A9999396ADB574166666666C00E2041666666E66ADB57419A999999B20E2041666666E66BDB57419A999999AD0E2041333333736CDB5741CDCCCCCCA60E2041CDCCCCAC6DDB574166666666A50E20416666666671DB574100000000A60E2041000000A073DB5741CDCCCCCCA40E2041333333F375DB5741333333339E0E2041CDCCCC0C7ADB57419A999999960E20419A9999197DDB57419A999999930E2041333333537EDB574166666666880E20416666662683DB574100000000860E20419A99995987DB5741CDCCCCCC810E2041CDCCCCEC8ADB5741000000007A0E2041333333D38DDB574166666666740E20413333337390DB5741CDCCCCCC6B0E20410000008097DB574166666666620E2041666666469DDB5741CDCCCCCC5E0E204166666606A1DB5741CDCCCCCC5B0E2041666666E6A6DB574100000000580E2041CDCCCCACABDB5741CDCCCCCC530E20419A9999D9ADDB5741CDCCCCCC4F0E2041666666C6B1DB57419A999999480E204100000020B6DB57419A999999440E204100000060B9DB574100000000420E2041CDCCCCACBCDB574100000000420E2041000000C0BFDB574100000000480E2041CDCCCCACC1DB5741000000004F0E2041CDCCCC0CC3DB5741CDCCCCCC570E204166666666C4DB574133333333720E2041CDCCCC8CC9DB5741333333337A0E2041CDCCCCCCCADB574100000000880E2041CDCCCCACCDDB57419A999999910E20419A999939CFDB574133333333A20E2041666666A6D2DB5741CDCCCCCCA40E204133333313D4DB574166666666A70E204133333353D6DB574100000000AA0E204166666626D8DB574100000000B10E204133333333DADB5741CDCCCCCCB80E2041CDCCCC2CDCDB574133333333C00E20419A999919DEDB574133333333C30E20419A9999D9DFDB5741CDCCCCCCBE0E204133333353E2DB5741CDCCCCCCB80E204133333353E4DB57419A999999990E20419A999939EBDB574100000000960E2041666666E6ECDB57419A999999960E2041333333D3EEDB5741CDCCCCCC980E204166666606F0DB574100000000A00E2041CDCCCC2CF1DB574166666666D00E20419A9999F9F5DB574166666666D80E204166666606F7DB574100000000DF0E2041CDCCCC4CF8DB574166666666EB0E2041000000E0F7DB5741CDCCCCCC5F0F204133333353F6DB5741333333337D0F204166666646F6DB574133333333990F2041CDCCCC2CF6DB57419A999999A80F2041CDCCCC2CF5DB57419A999999B00F2041CDCCCC2CF4DB574100000000D30F20419A9999F9EDDB574100000000DC0F204100000060ECDB5741CDCCCCCCE60F2041CDCCCCECEADB574166666666F20F204100000040EADB57410000000003102041000000C0E9DB5741333333332F1020419A999959E8DB57419A9999994310204100000000E8DB5741666666665B102041333333B3E7DB5741333333337710204166666626E7DB5741CDCCCCCC8A102041CDCCCC6CE6DB5741CDCCCCCC98102041666666A6E5DB5741CDCCCCCCB1102041000000C0E4DB574166666666CF102041333333D3E3DB57419A9999990611204133333333E2DB57419A9999991B112041CDCCCC8CE1DB5741000000005511204100000060DFDB57419A9999996B11204100000040DEDB574133333333B211204100000060DADB5741666666660D12204100000080D5DB574133333333451220419A999999E4DB57419A9999991012204100000060E6DB574166666666D911204133333393E8DB574166666666A01120419A9999D9EBDB5741CDCCCCCC6F112041333333B3EFDB57419A999999F71120413333337312DC5741333333332A112041CDCCCC4C28DC5741000000003C112041000000002CDC57416666666646112041000000802DDC57413333333354112041CDCCCCCC2EDC57410000000066112041666666A62FDC5741333333337A112041CDCCCCAC30DC5741000000008A1120413333335331DC57419A9999999C112041666666E631DC574100000000AF1120410000004032DC57419A999999BF1120413333339332DC5741CDCCCCCCDF1120413333339333DC574166666666EE112041CDCCCCAC34DC57416666666617122041333333B336DC5741333333332A1220419A99995937DC5741000000004E122041CDCCCC0C39DC57413333333383122041CDCCCC0C3CDC57419A99999998122041000000003DDC574100000000B3122041333333D33DDC57419A999999BB122041CDCCCC4C3EDC5741CDCCCCCCC4122041333333533FDC574133333333DE1220419A9999793DDC5741CDCCCCCC071320419A9999393ADC5741CDCCCCCC291320410000006037DC574166666666401320416666664635DC574166666666501320413333331333DC57419A99999957132041666666C630DC57413333333365132041CDCCCCAC2DDC57419A9999996A132041CDCCCC6C2CDC5741CDCCCCCC7D132041666666062ADC574100000000961320410000006028DC574100000000BD1320419A99997926DC5741CDCCCCCCC41320410000002026DC5741CDCCCCCC671420413333333339DC574100000000631420419A9999593CDC57419A9999995F1420416666662640DC5741CDCCCCCC621420410000004043DC5741CDCCCCCC67142041000000E045DC5741CDCCCCCC6E1420413333339348DC57419A99999975142041333333534ADC5741666666667D142041CDCCCC2C4CDC57419A99999983142041666666264EDC5741CDCCCCCC891420419A9999F94FDC574100000000911420419A99997951DC5741333333339C1420416666660653DC57419A999999BE142041000000A058DC574100000000D5142041333333D35CDC574166666666E31420413333331360DC574100000000F11420416666662663DC5741CDCCCCCCFC1420419A9999D965DC5741333333330C152041333333F36ADC57413333333315152041666666866DDC5741333333331C1520419A99993970DC57410000000023152041CDCCCCAC72DC5741CDCCCCCC291520410000002075DC5741CDCCCCCC2C1520419A99997977DC5741333333332D1520419A99999979DC57419A9999992A152041000000807CDC57416666666626152041CDCCCCAC7EDC574100000000211520410000004081DC5741CDCCCCCC1F1520419A9999D982DC57419A9999991C152041CDCCCC0C86DC5741333333331B1520410000008088DC5741CDCCCCCC1A1520419A9999398BDC5741333333331B152041333333B38DDC57419A9999991B152041666666468FDC57419A999999181520419A9999F992DC57419A99999919152041CDCCCCAC95DC5741000000001C1520419A99999998DC57419A999999211520419A9999399BDC57419A9999992B152041000000609EDC5741CDCCCCCC2F15204166666686A0DC57419A99999936152041000000C0A3DC5741333333333C152041CDCCCC6CA6DC5741CDCCCCCC40152041CDCCCC8CA9DC57410000000045152041CDCCCCECACDC57416666666648152041000000C0AFDC5741333333334C15204166666626B3DC5741000000004F152041333333D3B6DC57413333333350152041CDCCCC0CBADC574133333333511520419A999999BDDC5741000000005015204133333373C0DC5741CDCCCCCC4F152041CDCCCCACC3DC5741333333335215204166666606C6DC57419A9999995715204166666646C9DC5741333333335F1520419A999979CCDC5741333333336615204133333373CFDC57419A9999996B152041666666A6D2DC5741333333336E15204166666686D5DC5741000000006F1520419A9999D9D7DC57419A9999997015204100000020DBDC57419A99999975152041CDCCCCCCDDDC57419A9999997B1520419A9999B9E0DC57413333333381152041CDCCCCECE3DC5741CDCCCCCC88152041333333F3E6DC5741333333338E152041000000A0E9DC5741666666669315204166666626EDDC574100000000A515204100000020FCDC57419A999999A5152041CDCCCCACFDDC574133333333A3152041CDCCCC2CFFDC5741666666669A152041000000C002DD5741CDCCCCCC81152041000000C00CDD5741CDCCCCCC5B152041333333F31CDD57419A9999994C1520416666662624DD57410000000043152041000000802ADD5741333333333F152041333333F32DDD5741000000003C1520410000002030DD5741CDCCCCCC381520413333333331DD57419A9999992D1520419A99999935DD5741CDCCCCCC20152041333333B33CDD5741000000001E152041CDCCCC8C40DD5741666666661E1520413333339342DD57416666666621152041666666C646DD57419A99999920152041000000A048DD5741000000001F1520419A9999B949DD5741333333331C152041333333734ADD574100000000111520419A9999F94BDD5741CDCCCCCCF8142041000000E04DDD574100000000E1142041000000E04FDD574100000000C11420413333331353DD574133333333CF142041333333735CDD57419A999999FC1420410000008059DD57416666666627152041333333F356DD574100000000581520410000006055DD5741CDCCCCCC6A1520416666662655DD5741CDCCCCCCB2152041000000C054DD5741CDCCCCCC39162041CDCCCC8C54DD57419A999999AC162041333333B354DD57413333333300172041333333D354DD5741CDCCCCCC331720413333339354DD574133333333A8172041CDCCCC8C53DD574166666666041820413333335352DD5741666666663D182041000000A051DD57416666666664182041CDCCCCAC50DD5741CDCCCCCCAC182041CDCCCC8C4EDD574100000000F41820419A9999194CDD5741333333331B192041000000C04ADD57413333333344192041000000C049DD57419A999999691920413333335349DD574166666666821920413333337349DD57419A999999B6192041000000404ADD574133333333EE192041666666064BDD5741CDCCCCCC091A2041CDCCCC0C4BDD5741CDCCCCCC161A2041333333F34ADD57419A999999261A2041000000A04ADD5741666666663F1A2041000000E048DD5741CDCCCCCC5B1A2041666666A645DD574100000000EE1A2041CDCCCCAC42DD574166666666C81B2041CDCCCC0C40DD574100000000F01B2041CDCCCC8C47DD5741CDCCCCCC161C2041666666864EDD574166666666381C20416666668654DD5741333333334C1C20419A99997957DD5741333333335B1C2041000000A05BDD574133333333651C2041666666265EDD574133333333771C20413333339361DD574100000000811C20413333337363DD574166666666921C20413333337365DD574100000000AC1C2041333333D367DD57419A999999DA1C2041333333336CDD574133333333001D20419A9999F96FDD5741CDCCCCCC971D2041CDCCCC2C66DD574166666666BB1E2041000000E065DD574133333333BE1F2041000000A074DD5741CDCCCCCCDA1F20419A99997973DD574133333333EA1F20419A9999F972DD5741CDCCCCCC0A202041666666E671DD5741333333331A202041CDCCCC0C71DD574100000000372020419A99991970DD5741000000006B202041333333536DDD5741CDCCCCCC96202041666666266ADD574133333333C6202041000000E066DD574100000000EE202041000000C063DD574166666666092120419A9999B960DD574133333333222120419A9999D95DDD5741666666663C212041CDCCCC2C5ADD5741CDCCCCCC422120419A99997958DD57413333333349212041000000A056DD574100000000532120410000008055DD57419A999999822120410000008050DD574100000000D82120419A9999593EDD57410000000045222041000000C032DD57419A99999994222041CDCCCC6C2CDD5741666666663E2320419A9999392CDD5741CDCCCCCCD5232041333333D325DD57413333333313242041333333F322DD5741CDCCCCCC42242041666666A622DD57410000000007252041CDCCCCAC23DD57413333333323252041CDCCCC0C27DD57419A99999939252041CDCCCC0C29DD57416666666650252041333333D32ADD5741CDCCCCCC6C252041000000602CDD5741CDCCCCCC582520419A9999F93ADD57410000000057252041CDCCCC2C3EDD57419A999999572520419A9999B93FDD5741333333335A252041333333F340DD5741000000005E2520413333333342DD5741CDCCCCCC67252041666666C643DD5741000000006F252041CDCCCC6C44DD5741000000007A2520410000000045DD5741CDCCCCCC9A252041CDCCCCCC59DD5741CDCCCCCCC3252041000000006ADD5741CDCCCCCC27262041666666A66DDD574133333333462620419A99999972DD574133333333472620419A99991983DD57410000000003262041000000209CDD574133333333962520419A999939ABDD5741666666668E252041333333B3CBDD57410000000043252041000000C0F3DD5741666666668A252041666666660ADE57419A999999172620419A9999391EDE57419A99999929262041666666C62DDE57410000000036262041666666062EDE57419A99999995262041CDCCCC6C30DE5741CDCCCCCCCA2620419A99997931DE574166666666D72620416666668631DE574166666666E32620410000008031DE574166666666F82620410000008030DE57419A999999122720419A9999B92EDE5741666666664D2720419A9999D92ADE57416666666676272041000000A027DE57419A999999812720416666668626DE57419A99999989272041666666A625DE574133333333912720413333335323DE57413333333395272041CDCCCCAC21DE574133333333992720410000000020DE57419A999999A2272041000000001EDE574133333333B0272041666666461CDE574100000000D9272041000000A016DE57416666666609282041CDCCCC6C0FDE5741CDCCCCCC322820419A9999F909DE57410000000072282041CDCCCCAC01DE5741000000009928204166666666FCDD5741CDCCCCCCB4282041333333D3F7DD57419A999999B92820419A999919F7DD57419A999999C4282041000000A0F4DD574100000000CC28204133333333F3DD574100000000E728204100000080EEDD57410000000010292041666666E6E8DD57413333333325292041333333B3E5DD57413333333332292041CDCCCCECE2DD5741CDCCCCCC372920419A999939E1DD57419A9999993D2920419A999979DFDD5741666666664C2920419A999979DBDD57419A9999995F29204133333313D7DD5741CDCCCCCC7829204100000020D2DD5741333333339F29204100000000CCDD57419A999999BD29204166666626C7DD574166666666DA29204166666686C2DD574100000000E1292041CDCCCCCCC0DD574100000000E929204133333353C1DD5741CDCCCCCCF329204100000020C1DD5741CDCCCCCCFF292041CDCCCC4CC0DD574100000000102A204166666626BFDD5741CDCCCCCC442A2041CDCCCCACBADD574133333333852A204133333353B5DD57419A999999B62A204166666666B1DD5741CDCCCCCCDD2A2041666666C6AEDD574133333333002B20419A999959ADDD5741666666662E2B204133333373ABDD574166666666562B204100000080A9DD574166666666972B204133333373A6DD574133333333DE2B204166666606A3DD5741000000000A2C20419A9999F9A0DD5741CDCCCCCC292C2041CDCCCCAC9FDD5741CDCCCCCC542C2041666666869EDD574133333333892C2041000000609DDD5741CDCCCCCCAA2C2041333333F39BDD57419A999999DB2C2041000000009ADD5741CDCCCCCCEB2C2041666666C699DD574166666666F62C20419A9999B999DD574166666666132D20419A9999399ADD574166666666372D2041CDCCCCEC9ADD574166666666422D20419A9999D99ADD574166666666562D2041333333539ADD5741CDCCCCCC672D20416666668699DD574166666666992D20410000004097DD574133333333D42D2041CDCCCCCC93DD574166666666072E20416666664690DD574100000000352E2041CDCCCC6C8DDD57419A999999582E2041333333B38ADD574133333333792E2041333333F387DD5741666666669D2E20410000000085DD574100000000BC2E20419A9999D981DD57419A999999CD2E20410000000080DD574133333333DC2E2041000000C07DDD574166666666052F2041CDCCCC0C7FDD574100000000302F20410000000080DD5741000000004B2F20410000004080DD574133333333502F2041CDCCCC4C80DD574133333333632F2041CDCCCC2C80DD574133333333672F2041CDCCCC2C80DD574100000000822F20419A9999B97FDD57419A9999999F2F20419A9999B97EDD574100000000E02F2041666666A67BDD574133333333FD2F20419A9999B97ADD5741333333331A302041CDCCCC6C7ADD57410000000030302041333333B37ADD5741666666663D302041000000007BDD574133333333373020410000008078DD5741CDCCCCCC2A3020413333335375DD57410000000018302041CDCCCC2C71DD57410000000001302041333333136DDD574100000000D62F20419A9999F966DD57419A999999932F2041333333335DDD574166666666A32F2041333333735CDD57419A999999D82F2041000000A058DD5741CDCCCCCC30302041CDCCCC6C51DD57419A9999996B3020419A9999194CDD5741CDCCCCCC933020419A99997949DD574100000000A3302041333333F34ADD574100000000B43020419A9999994CDD574100000000C5302041666666464FDD574166666666D53020416666660652DD5741CDCCCCCCDF302041CDCCCC4C54DD5741CDCCCCCCE5302041000000A050DD574133333333F0302041666666E64CDD574100000000F6302041666666C64ADD5741CDCCCCCC053120416666662643DD57413333333322312041333333B33EDD5741CDCCCCCC42312041CDCCCC4C3ADD57419A9999996F3120410000004036DD574133333333A03120419A99993931DD574133333333D6312041333333D32CDD57410000000007322041CDCCCC8C28DD57410000000017322041CDCCCC4C27DD5741CDCCCCCC2B3220419A9999B927DD574100000000313220413333337327DD574166666666283220413333333325DD57413333333307322041CDCCCC2C1DDD574133333333D13120419A99993912DD574100000000B63120419A9999F90CDD57416666666695312041666666A606DD5741000000005A3120419A999979FADC5741CDCCCCCC3631204100000020F3DC57419A9999992D3120419A999999F0DC5741CDCCCCCC2D312041CDCCCCACEFDC57419A9999993031204166666606EFDC57410000000056312041CDCCCCECEBDC5741333333331032204133333353DDDC57419A999999A23220419A999999D2DC57419A999999193320419A999999CBDC57416666666670332041666666A6C6DC5741CDCCCCCCBE332041CDCCCC2CC3DC57419A9999992035204133333393D0DC574100000000863520419A999939CFDC574133333333B7352041666666C6CFDC5741000000001636204133333353C8DC574133333333F1352041333333B3C2DC5741666666668D352041CDCCCCECB3DC5741000000002235204100000060A4DC574133333333CC3420419A99995998DC57416666666684342041666666468EDC5741CDCCCCCC463420413333337386DC5741CDCCCCCC153420410000006080DC574100000000F8332041CDCCCC0C7BDC57419A999999E4332041666666A675DC574166666666D5332041CDCCCC6C6EDC5741CDCCCCCCD23320419A9999F96BDC5741CDCCCCCCD3332041CDCCCCAC66DC5741CDCCCCCCD9332041333333935EDC574166666666DF332041CDCCCCAC55DC5741CDCCCCCCDE3320410000002053DC57419A999999DC332041333333F34DDC5741CDCCCCCCD5332041333333B341DC574100000000CF332041666666E637DC57419A999999CC332041333333F332DC574100000000CC3320413333333328DC5741CDCCCCCCC8332041333333F31FDC574166666666C73320419A9999791CDC574133333333C23320416666666619DC574133333333B03320410000002015DC5741CDCCCCCC8C332041CDCCCCCC0EDC574166666666663320419A99995907DC574166666666453320413333331301DC57419A99999933332041666666A6FADB57419A9999992933204133333373F7DB5741CDCCCCCC1A332041CDCCCC6CF3DB5741333333330333204100000000EFDB57419A999999DB32204166666626E8DB57419A999999BF32204100000060E3DB574133333333983220419A999959DDDB5741CDCCCCCC7C3220419A9999F9D8DB5741CDCCCCCC5F3220419A999979D5DB5741CDCCCCCC353220419A999979D1DB574100000000F6312041CDCCCC0CCCDB574133333333C331204100000040C8DB5741CDCCCCCCA331204133333313C5DB5741000000009B3120419A999999C3DB5741333333337B31204100000080BFDB5741666666665E3120419A999979BBDB57416666666650312041CDCCCCACB7DB57410000000044312041CDCCCCCCB2DB5741666666663731204100000060AEDB57419A9999992631204166666666A9DB5741333333331C31204133333373A6DB57410000000005312041666666E6A1DB57419A999999D93020419A9999599ADB5741CDCCCCCCBB302041CDCCCCEC94DB57419A9999999C302041333333738FDB57419A99999991302041666666268DDB5741000000008B302041000000608ADB57413333333386302041CDCCCC4C83DB574100000000853020419A99995981DB5741333333337C3020410000002077DB5741CDCCCCCC74302041666666A66DDB5741666666666A302041666666C663DB57413333333364302041CDCCCC8C5CDB5741CDCCCCCC5F3020413333337358DB5741666666665D302041666666E650DB57416666666659302041666666A646DB57410000000058302041666666A644DB5741CDCCCCCC553020419A9999B941DB5741CDCCCCCC52302041CDCCCC2C3FDB5741333333334D3020419A9999793DDB574166666666FA2F20416666666644DB574166666666BD2F2041CDCCCC0C49DB57419A999999792F2041333333334EDB574100000000372F2041CDCCCC8C53DB5741CDCCCCCC062F20413333337357DB574166666666EC2E2041CDCCCCEC59DB5741CDCCCCCCD02E20419A9999B95CDB574133333333A82E20416666666660DB574166666666752E20410000002064DB5741000000003C2E20419A99991967DB5741CDCCCCCC272E2041000000C067DB5741CDCCCCCC1D2E20419A99997968DB57419A999999102E20410000008069DB574166666666002E2041333333536ADB574166666666F32D2041666666C66ADB574100000000BF2D2041CDCCCC8C6BDB57419A9999998F2D2041CDCCCCCC6BDB57419A999999522D2041000000606BDB57419A9999991F2D2041333333B36ADB5741CDCCCCCC0D2D20419A9999796ADB5741CDCCCCCCF62C2041CDCCCC4C6ADB5741CDCCCCCCE02C2041333333336ADB574133333333D02C2041666666C669DB574100000000AD2C20410000006068DB574133333333662C2041CDCCCCAC64DB57419A9999993F2C20410000000062DB574133333333322C20419A99991961DB57419A9999992A2C2041666666E660DB5741333333331E2C20419A99991961DB5741CDCCCCCC092C20419A99991963DB574166666666EF2B20416666662665DB57419A999999DF2B2041000000E065DB5741CDCCCCCCBF2B20419A9999D966DB5741CDCCCCCC752B2041000000C068DB574166666666D82A2041666666866CDB5741CDCCCCCC6D2A2041CDCCCCEC6EDB574100000000592A2041CDCCCC6C6FDB57419A9999994A2A20419A99991970DB5741CDCCCCCC362A20410000004071DB574100000000142A2041000000E073DB574133333333E5292041000000E077DB5741CDCCCCCCA0292041666666667FDB57413333333382292041000000A082DB574133333333442920410000002072DB5741333333331E2920410000008073DB574166666666EF2820419A9999B975DB574166666666BB2820419A99993979DB5741CDCCCCCC60282041666666467FDB57419A999999162820413333339385DB5741CDCCCCCCFB2720413333337386DB574100000000EE272041333333B386DB5741666666668E272041666666C688DB5741000000001F272041CDCCCCAC8BDB574166666666B5262041333333938EDB57416666666651262041666666A691DB574133333333E22520416666668695DB574133333333CF252041CDCCCC2C96DB5741000000008C2520419A9999D998DB57416666666658252041333333B39ADB5741CDCCCCCC20252041666666C69DDB574133333333F924204133333373A0DB57419A99999982242041666666E681DB574166666666462420419A99995979DB5741CDCCCCCC36242041CDCCCC4C7ADB574166666666132420419A9999197CDB57419A999999DE232041666666E67DDB5741CDCCCCCCB8232041333333737FDB574166666666AD232041333333F370DB5741CDCCCCCC58232041000000E04EDB5741CDCCCCCC26232041CDCCCC4C50DB574133333333CF222041000000A053DB57419A99999970222041333333F357DB57410000000006222041333333335CDB57419A999999A6212041666666A65FDB5741666666664E2120419A99993963DB57413333333326212041CDCCCC6C64DB5741666666660A212041666666A664DB57419A999999E9202041000000C064DB574100000000762020419A99991941DB574166666666B61F2041CDCCCC2C44DB5741666666661A1F2041CDCCCCCC45DB574166666666151F2041666666C640DB5741CDCCCCCC381F2041333333F337DB574166666666141F2041CDCCCC8C29DB57419A999999061F2041333333B329DB57419A999999C01E2041666666062ADB57419A9999997C1E2041666666462ADB5741CDCCCCCC621E20419A9999192ADB5741CDCCCCCC191E20413333333329DB574166666666BB1D20419A99997927DB5741666666668D1D20410000006026DB57419A999999711D20416666664625DB57419A999999291D2041000000A021DB574166666666EC1C2041CDCCCC2C1FDB574166666666C41C2041000000201EDB574100000000B61C2041333333F31DDB5741333333339D1C2041CDCCCC0C1EDB574166666666BE1C20416666662610DB57419A999999F71C204133333353EFDA574100000000E01C20419A9999D9EFDA574166666666C71C204100000020F0DA5741CDCCCCCCAE1C20419A999979F0DA57419A999999921C2041CDCCCCCCF0DA5741666666667A1C2041333333F3F0DA57419A999999641C204100000020F1DA5741333333334F1C204100000040F1DA5741CDCCCCCC381C204133333353F1DA5741CDCCCCCC211C204133333313F1DA5741666666660A1C2041333333B3F0DA574133333333F91B2041000000A0F0DA574166666666E51B204100000080F0DA5741CDCCCCCCD21B20419A999999F0DA574133333333BB1B20419A9999B9F0DA5741333333339C1B2041CDCCCCECF0DA57419A999999841B204133333313F1DA574100000000701B204100000060F1DA574133333333551B2041333333F3F1DA5741666666663E1B204133333313F2DA574133333333261B2041CDCCCC4CF2DA574166666666BE1A204100000020D7DA5741666666665F1A2041CDCCCC4CDBDA5741666666661C1A204100000020DEDA574166666666FF19204100000020DFDA574133333333EA192041CDCCCC8CDFDA574100000000C9192041CDCCCCECDFDA5741666666666D19204133333373DFDA5741CDCCCCCC59192041333333F3DEDA5741333333334F19204133333393DEDA5741333333334C19204133333353EDDA574100000000DA18204100000060F4DA574133333333E018204100000080F5DA57419A999999E51820419A9999F9F6DA57413333333361172041CDCCCCAC12DB5741000000005F1720419A9999D910DB5741333333335A172041333333B30EDB57416666666655172041666666660CDB5741333333334D1720413333335309DB57419A999999471720419A99991906DB57416666666644172041CDCCCCEC03DB574133333333411720413333337301DB57419A9999993D1720419A9999D9FEDA5741CDCCCCCC3817204166666666FCDA5741CDCCCCCC2B17204100000040F8DA5741333333332417204166666666F6DA57419A9999991E172041666666C6F4DA5741333333331B1720419A9999B9F2DA57419A9999991817204133333393F0DA5741CDCCCCCC15172041CDCCCCCCEEDA57419A9999990C1720419A9999F9ECDA57419A999999FB162041CDCCCC0CEBDA5741CDCCCCCCE316204166666666E8DA57419A999999BC162041CDCCCCCCE3DA5741CDCCCCCC6315204133333333C7DA57419A999999C2142041333333D3CEDA5741CDCCCCCCC5142041CDCCCCACCBDA574100000000D2142041333333B3C7DA57419A999999E1142041333333F3C3DA574100000000F81420419A9999F9BFDA5741CDCCCCCC10152041CDCCCCECBCDA5741333333331B152041333333D3BBDA574166666666EF142041333333D3BCDA574100000000D814204166666606BEDA574100000000BF14204166666646BFDA57419A999999B514204166666666BFDA57410000000091142041666666C6C1DA5741333333336D142041CDCCCCACC3DA5741CDCCCCCC3E14204166666626C6DA5741000000000B1420419A999939C9DA57419A999999EA132041000000A0CBDA574100000000C413204100000000CEDA57419A9999999A132041CDCCCC2CD0DA57419A99999974132041CDCCCC8CD1DA5741000000005413204166666606D2DA5741CDCCCCCC28132041CDCCCCACD1DA57410000000001132041CDCCCC6CD0DA574133333333E41220419A999919CFDA574133333333BD122041333333B3CCDA5741CDCCCCCCCA102041666666E6EBDA574100000000A71020419A9999F9ECDA5741333333338510204133333353EDDA5741666666666A0F204100000040ECDA574166666666D30D204133333313EBDA5741	01060000206A08000001000000010300000001000000FD00000066666666D30D204133333313EBDA574133333333D60D204100000080F3DA574100000000EB0D20413333337303DB574100000000050E2041666666E60DDB574166666666320E2041333333331BDB574100000000460E2041CDCCCC4C26DB5741000000006E0E20410000008030DB5741666666669A0E20410000002039DB574100000000AE0E2041666666864ADB574100000000D00E2041333333335BDB574166666666D50E2041000000A068DB5741CDCCCCCCA60E2041CDCCCCAC6DDB5741CDCCCCCCA40E2041333333F375DB574166666666880E20416666662683DB574166666666620E2041666666469DDB574100000000580E2041CDCCCCACABDB574100000000420E2041000000C0BFDB574133333333A20E2041666666A6D2DB574133333333C30E20419A9999D9DFDB57419A999999990E20419A999939EBDB5741CDCCCCCC980E204166666606F0DB574100000000DF0E2041CDCCCC4CF8DB574133333333990F2041CDCCCC2CF6DB57419A999999B00F2041CDCCCC2CF4DB574166666666F20F204100000040EADB5741333333337710204166666626E7DB5741000000005511204100000060DFDB5741666666660D12204100000080D5DB574133333333451220419A999999E4DB574166666666D911204133333393E8DB5741CDCCCCCC6F112041333333B3EFDB57419A999999F71120413333337312DC5741333333332A112041CDCCCC4C28DC57413333333354112041CDCCCCCC2EDC5741CDCCCCCCDF1120413333339333DC5741CDCCCCCCC4122041333333533FDC574166666666401320416666664635DC5741CDCCCCCC7D132041666666062ADC5741CDCCCCCCC41320410000002026DC5741CDCCCCCC671420413333333339DC57419A9999995F1420416666662640DC5741CDCCCCCC6E1420413333339348DC5741CDCCCCCC891420419A9999F94FDC574100000000D5142041333333D35CDC5741CDCCCCCCFC1420419A9999D965DC5741CDCCCCCC291520410000002075DC5741333333332D1520419A99999979DC57419A9999991C152041CDCCCC0C86DC5741000000001C1520419A99999998DC5741333333333C152041CDCCCC6CA6DC5741333333334C15204166666626B3DC5741CDCCCCCC4F152041CDCCCCACC3DC5741333333336615204133333373CFDC57419A9999997015204100000020DBDC5741333333338E152041000000A0E9DC574100000000A515204100000020FCDC574133333333A3152041CDCCCC2CFFDC57419A9999994C1520416666662624DD5741000000001E152041CDCCCC8C40DD57416666666621152041666666C646DD574100000000111520419A9999F94BDD574100000000C11420413333331353DD574133333333CF142041333333735CDD57416666666627152041333333F356DD574100000000581520410000006055DD5741CDCCCCCC39162041CDCCCC8C54DD57413333333300172041333333D354DD574133333333A8172041CDCCCC8C53DD5741666666663D182041000000A051DD57413333333344192041000000C049DD574166666666821920413333337349DD574133333333EE192041666666064BDD57419A999999261A2041000000A04ADD5741CDCCCCCC5B1A2041666666A645DD574100000000EE1A2041CDCCCCAC42DD574166666666C81B2041CDCCCC0C40DD5741333333334C1C20419A99997957DD574100000000811C20413333337363DD574133333333001D20419A9999F96FDD5741CDCCCCCC971D2041CDCCCC2C66DD574166666666BB1E2041000000E065DD574133333333BE1F2041000000A074DD5741000000006B202041333333536DDD574100000000EE202041000000C063DD5741666666663C212041CDCCCC2C5ADD57413333333349212041000000A056DD57419A999999822120410000008050DD574100000000D82120419A9999593EDD57410000000045222041000000C032DD57419A99999994222041CDCCCC6C2CDD5741666666663E2320419A9999392CDD57413333333313242041333333F322DD5741CDCCCCCC42242041666666A622DD57410000000007252041CDCCCCAC23DD5741CDCCCCCC6C252041000000602CDD57419A999999572520419A9999B93FDD5741000000007A2520410000000045DD5741CDCCCCCC9A252041CDCCCCCC59DD5741CDCCCCCCC3252041000000006ADD5741CDCCCCCC27262041666666A66DDD574133333333462620419A99999972DD574133333333472620419A99991983DD57410000000003262041000000209CDD574133333333962520419A999939ABDD5741666666668E252041333333B3CBDD57410000000043252041000000C0F3DD5741666666668A252041666666660ADE57419A999999172620419A9999391EDE57419A99999929262041666666C62DDE574166666666E32620410000008031DE5741666666664D2720419A9999D92ADE57419A99999989272041666666A625DE57419A999999A2272041000000001EDE57416666666609282041CDCCCC6C0FDE5741000000009928204166666666FCDD574100000000E728204100000080EEDD57413333333325292041333333B3E5DD5741CDCCCCCC7829204100000020D2DD574166666666DA29204166666686C2DD574100000000102A204166666626BFDD574133333333852A204133333353B5DD5741CDCCCCCCDD2A2041666666C6AEDD5741666666662E2B204133333373ABDD5741CDCCCCCC292C2041CDCCCCAC9FDD574133333333892C2041000000609DDD57419A999999DB2C2041000000009ADD574166666666372D2041CDCCCCEC9ADD574166666666992D20410000004097DD574100000000352E2041CDCCCC6C8DDD5741666666669D2E20410000000085DD574133333333DC2E2041000000C07DDD574100000000302F20410000000080DD574100000000822F20419A9999B97FDD574100000000E02F2041666666A67BDD5741666666663D302041000000007BDD57410000000001302041333333136DDD57419A999999932F2041333333335DDD57419A999999D82F2041000000A058DD57419A9999996B3020419A9999194CDD5741CDCCCCCC933020419A99997949DD574100000000B43020419A9999994CDD5741CDCCCCCCDF302041CDCCCC4C54DD5741CDCCCCCC053120416666662643DD5741CDCCCCCC42312041CDCCCC4C3ADD574133333333A03120419A99993931DD57410000000017322041CDCCCC4C27DD574100000000313220413333337327DD57413333333307322041CDCCCC2C1DDD5741CDCCCCCC3631204100000020F3DC57419A9999993031204166666606EFDC5741333333331032204133333353DDDC57419A999999A23220419A999999D2DC57416666666670332041666666A6C6DC5741CDCCCCCCBE332041CDCCCC2CC3DC57419A9999992035204133333393D0DC574100000000863520419A999939CFDC574133333333B7352041666666C6CFDC5741000000001636204133333353C8DC5741000000002235204100000060A4DC57416666666684342041666666468EDC5741CDCCCCCC153420410000006080DC57419A999999E4332041666666A675DC574166666666D5332041CDCCCC6C6EDC5741CDCCCCCCD3332041CDCCCCAC66DC574166666666DF332041CDCCCCAC55DC57419A999999CC332041333333F332DC574166666666C73320419A9999791CDC574133333333B03320410000002015DC574166666666453320413333331301DC5741CDCCCCCC1A332041CDCCCC6CF3DB57419A999999BF32204100000060E3DB5741CDCCCCCC5F3220419A999979D5DB5741CDCCCCCCA331204133333313C5DB5741666666665E3120419A999979BBDB5741333333331C31204133333373A6DB57419A9999999C302041333333738FDB5741000000008B302041000000608ADB5741CDCCCCCC74302041666666A66DDB5741CDCCCCCC5F3020413333337358DB57416666666659302041666666A646DB5741333333334D3020419A9999793DDB574166666666FA2F20416666666644DB5741CDCCCCCC062F20413333337357DB574133333333A82E20416666666660DB574166666666752E20410000002064DB574166666666F32D2041666666C66ADB57419A9999998F2D2041CDCCCCCC6BDB5741CDCCCCCCE02C2041333333336ADB574100000000AD2C20410000006068DB574133333333322C20419A99991961DB5741CDCCCCCCBF2B20419A9999D966DB574100000000592A2041CDCCCC6C6FDB574133333333E5292041000000E077DB57413333333382292041000000A082DB574133333333442920410000002072DB574166666666EF2820419A9999B975DB5741CDCCCCCC60282041666666467FDB57419A999999162820413333339385DB5741666666668E272041666666C688DB57416666666651262041666666A691DB57416666666658252041333333B39ADB574133333333F924204133333373A0DB57419A99999982242041666666E681DB574166666666462420419A99995979DB5741CDCCCCCCB8232041333333737FDB574166666666AD232041333333F370DB5741CDCCCCCC58232041000000E04EDB574133333333CF222041000000A053DB57419A99999970222041333333F357DB5741666666664E2120419A99993963DB57419A999999E9202041000000C064DB574100000000762020419A99991941DB574166666666B61F2041CDCCCC2C44DB5741666666661A1F2041CDCCCCCC45DB574166666666151F2041666666C640DB5741CDCCCCCC381F2041333333F337DB574166666666141F2041CDCCCC8C29DB57419A9999997C1E2041666666462ADB574166666666BB1D20419A99997927DB57419A999999711D20416666664625DB57419A999999291D2041000000A021DB574166666666C41C2041000000201EDB5741333333339D1C2041CDCCCC0C1EDB574166666666BE1C20416666662610DB57419A999999F71C204133333353EFDA5741CDCCCCCC381C204133333353F1DA574166666666E51B204100000080F0DA574133333333261B2041CDCCCC4CF2DA574166666666BE1A204100000020D7DA5741666666661C1A204100000020DEDA574100000000C9192041CDCCCCECDFDA5741333333334F19204133333393DEDA5741333333334C19204133333353EDDA574100000000DA18204100000060F4DA57419A999999E51820419A9999F9F6DA57413333333361172041CDCCCCAC12DB5741CDCCCCCC3817204166666666FCDA57419A9999990C1720419A9999F9ECDA57419A999999BC162041CDCCCCCCE3DA5741CDCCCCCC6315204133333333C7DA57419A999999C2142041333333D3CEDA57419A999999E1142041333333F3C3DA5741333333331B152041333333D3BBDA57419A999999B514204166666666BFDA57419A9999999A132041CDCCCC2CD0DA5741000000005413204166666606D2DA5741CDCCCCCC28132041CDCCCCACD1DA574133333333BD122041333333B3CCDA5741CDCCCCCCCA102041666666E6EBDA5741333333338510204133333353EDDA5741666666666A0F204100000040ECDA574166666666D30D204133333313EBDA574166666666D30D204133333313EBDA5741	01010000206A080000CA5BB5C1892420410000009076DC5741	310010000	Z	Agassac	3100100	31001	31	76	10
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	01010000206A0800009C68E54DCCDF2141000000D0CDD65741	310020000	Z	Aignes	3100200	31002	31	76	22
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	01010000206A080000CE267CC162DE2141666666B64EF05741	310030000	Z	Aigrefeuille	3100300	31003	31	76	5
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	01010000206A08000025C1AF3105DE2141CDCCCCBC98E05741	310040000	Z	Ayguesvives	3100400	31004	31	76	13
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	01010000206A080000595959D90C3520413333337363CB5741	310050000	Z	Alan	3100500	31005	31	76	11
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	01010000206A080000EED5A4DB765A22413333339394EE5741	310060000	Z	Albiac	3100600	31006	31	76	5
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	01010000206A080000D81D049014432041000000F0D5DB5741	310070000	Z	Ambax	3100700	31007	31	76	6
01060000206A0800000100000001030000000100000038030000CDCCCCCCB2B91F4133333333BAD957419A999999E9B91F41666666C6BBD957416666666626BA1F41333333D3BDD957416666666642BA1F419A9999F9BED95741CDCCCCCC78BA1F41CDCCCCECC1D957419A9999999DBA1F419A999939C4D9574100000000AEBA1F41CDCCCC8CC5D9574166666666F0BA1F4166666626CAD95741CDCCCCCC48BB1F41CDCCCC0CD1D957419A99999965BB1F419A999919D4D957419A99999977BB1F4100000020D6D9574100000000AEBB1F4133333393DDD95741CDCCCCCCB4BB1F419A999939DED95741CDCCCCCCBCBB1F41000000E0DED9574100000000D2BB1F41CDCCCC2CE0D9574133333333E5BB1F41CDCCCCECE0D95741CDCCCCCCFABB1F41000000E0E1D957419A99999909BC1F41000000E0E2D957416666666630BC1F41333333B3E5D957416666666638BC1F419A999979E6D957419A9999994FBC1F4133333333E9D957419A99999965BC1F41CDCCCC8CEBD957416666666694BC1F4100000040F1D95741CDCCCCCCBEBC1F419A999939F7D9574100000000CCBC1F419A9999B9F9D9574100000000E4BC1F41666666A6FED9574133333333F9BC1F410000006002DA574100000000FEBC1F419A9999B903DA5741CDCCCCCC00BD1F419A9999F904DA57416666666604BD1F41CDCCCC8C07DA5741CDCCCCCC06BD1F41CDCCCCAC0CDA57419A99999907BD1F410000006011DA57419A99999909BD1F41000000A012DA5741000000000EBD1F41333333D313DA57419A99999919BD1F419A9999F915DA5741CDCCCCCC2CBD1F416666662618DA5741CDCCCCCC3CBD1F41CDCCCC6C19DA57419A99999955BD1F41333333F31ADA5741CDCCCCCC68BD1F41CDCCCCEC1BDA574100000000A6BD1F419A9999D91EDA57419A999999EFBD1F41CDCCCCCC21DA57416666666612BE1F419A9999F922DA5741000000003ABE1F413333335324DA57413333333393BE1F416666662627DA574166666666C6BE1F41CDCCCC8C28DA57419A999999FBBE1F419A9999192ADA5741666666664CBF1F41666666262CDA5741000000007EBF1F419A9999192DDA57419A99999999BF1F419A9999F92DDA574133333333A9BF1F41000000A02EDA574133333333B9BF1F41CDCCCC6C2FDA574100000000C8BF1F41CDCCCC6C30DA57419A999999D5BF1F413333337331DA574166666666F0BF1F41CDCCCC0C34DA57410000000004C01F413333339336DA57416666666610C01F41333333B338DA57416666666616C01F41333333D339DA57419A9999991BC01F41666666063BDA5741CDCCCCCC2EC01F41CDCCCC8C3FDA57413333333333C01F41666666C640DA5741333333333BC01F413333335343DA57416666666644C01F413333337346DA57419A99999959C01F41333333734BDA57410000000064C01F41000000404DDA5741CDCCCCCC6AC01F419A9999594EDA57416666666678C01F41CDCCCC8C50DA5741666666667EC01F41CDCCCC6C51DA57419A99999989C01F416666668652DA5741CDCCCCCC90C01F410000000053DA57419A9999999DC01F41000000A053DA574166666666BCC01F416666664654DA574100000000CCC01F413333337354DA574166666666FCC01F41666666C654DA5741000000000EC11F419A9999F954DA57416666666620C11F419A99995955DA57419A9999993DC11F416666662656DA57419A99999947C11F41000000C056DA57416666666650C11F419A99999957DA5741CDCCCCCC6EC11F419A9999795BDA57419A9999998BC11F41CDCCCCCC5FDA57419A999999A1C11F41333333F361DA574100000000AAC11F410000008062DA574166666666BAC11F416666664663DA57419A999999CDC11F41000000E063DA5741CDCCCCCCFCC11F41666666A665DA5741CDCCCCCC16C21F41CDCCCCAC66DA5741000000002CC21F41000000C067DA5741CDCCCCCC5EC21F419A9999396BDA5741666666666AC21F41333333336CDA5741666666667EC21F41666666666EDA5741333333338FC21F419A99997970DA574133333333A7C21F41CDCCCCEC74DA57419A999999CBC21F419A9999397BDA574100000000D6C21F41000000607DDA574100000000DAC21F41000000407FDA57419A999999D7C21F419A9999B981DA574166666666D0C21F41CDCCCC4C83DA57419A999999C1C21F41666666A684DA57419A999999A7C21F410000000086DA5741000000008AC21F419A9999B986DA5741CDCCCCCC84C21F41CDCCCC0C87DA57413333333373C21F41000000C087DA57419A99999927C21F419A99997989DA57419A999999C7C11F41333333338CDA57410000000064C11F41333333338FDA5741666666663EC11F410000004090DA5741CDCCCCCC2AC11F41CDCCCCEC90DA57413333333319C11F41333333B391DA57419A999999FBC01F413333335393DA57419A999999EDC01F410000004094DA57419A999999E1C01F41CDCCCC2C95DA57419A999999D5C01F41333333D396DA574100000000CEC01F410000004098DA5741CDCCCCCCCAC01F410000006099DA574166666666CAC01F41666666869BDA574100000000CAC01F41666666A69CDA5741CDCCCCCCC2C01F4100000000A1DA574100000000B0C01F41000000E0A8DA5741CDCCCCCCACC01F41CDCCCC4CABDA5741CDCCCCCCAEC01F419A999939B0DA574133333333B3C01F41000000A0B2DA574166666666BAC01F41CDCCCC0CB5DA57419A999999BFC01F41CDCCCC2CB6DA574133333333D7C01F41333333B3BADA57410000000002C11F419A9999B9C1DA57419A9999990BC11F41666666A6C3DA57416666666612C11F419A999959C8DA57416666666614C11F4100000000CCDA57413333333311C11F4133333373CEDA5741000000000CC11F4166666666D1DA57419A99999901C11F41CDCCCCECD4DA574100000000F8C01F419A999919D8DA574166666666F4C01F4133333313D9DA574166666666E0C01F41CDCCCC2CDCDA5741CDCCCCCCD4C01F41666666A6DEDA574100000000C8C01F4133333333E1DA57419A999999C5C01F419A999939E3DA57419A999999C3C01F4166666646E6DA5741CDCCCCCCC4C01F419A9999D9E7DA574166666666C8C01F41CDCCCC0CEBDA574133333333CFC01F4133333333EDDA57419A999999D7C01F419A9999F9EEDA574166666666EEC01F41CDCCCCECF1DA574100000000FAC01F4100000020F3DA5741666666661AC11F4100000000F7DA57410000000026C11F4166666626F8DA5741000000004AC11F4133333333FBDA5741CDCCCCCC62C11F4166666666FDDA5741666666667CC11F410000002000DB57413333333393C11F41CDCCCC2C02DB574100000000B2C11F413333335305DB574166666666ECC11F41666666A60BDB5741CDCCCCCC0AC21F41CDCCCC2C0FDB57410000000026C21F41333333F312DB57410000000030C21F413333333314DB57419A9999993BC21F413333337315DB5741000000004EC21F41000000C017DB5741CDCCCCCC52C21F41666666A618DB5741000000005EC21F419A9999591BDB5741666666666CC21F419A9999D91DDB57416666666676C21F419A9999F91EDB574133333333A5C21F419A99997922DB57419A999999ABC21F413333331323DB574166666666C4C21F413333339326DB57416666666602C31F410000002030DB5741CDCCCCCC12C31F41CDCCCC2C31DB5741CDCCCCCC24C31F419A9999D934DB57413333333329C31F41666666A635DB5741666666663EC31F410000006039DB57413333333345C31F41333333D33ADB57413333333353C31F41333333533DDB57413333333363C31F410000008040DB57419A9999996DC31F41333333B342DB5741666666667AC31F41333333D345DB57419A9999997FC31F41CDCCCC2C48DB57410000000080C31F41CDCCCCAC48DB5741333333337FC31F41666666864BDB5741CDCCCCCC7AC31F41000000404EDB5741000000007AC31F41000000804FDB5741666666667AC31F413333333352DB57419A9999997DC31F41CDCCCCEC54DB57413333333391C31F41000000E058DB5741CDCCCCCC9CC31F41333333735ADB57419A999999A9C31F41333333F35BDB574133333333B3C31F41CDCCCC4C5DDB5741CDCCCCCCD4C31F419A9999D960DB57419A999999DDC31F41CDCCCCEC61DB574166666666E8C31F41000000A063DB57419A999999EDC31F41CDCCCCCC64DB574166666666F8C31F416666660668DB574166666666FAC31F41000000806BDB574133333333F9C31F419A9999996DDB57419A999999F9C31F41CDCCCC6C6EDB574100000000F4C31F41CDCCCC4C73DB5741CDCCCCCCF2C31F41333333B377DB57419A999999F9C31F41000000807BDB5741CDCCCCCC00C41F41000000E07EDB57419A99999905C41F416666668681DB5741666666660AC41F416666666683DB57419A99999919C41F419A9999B988DB57416666666628C41F419A9999998FDB57419A9999992BC41F41CDCCCC0C91DB57410000000032C41F41CDCCCCCC9BDB57419A99999935C41F41333333F39DDB5741000000003CC41F4100000020A1DB5741000000003EC41F419A999979A4DB5741333333333DC41F4133333393A5DB5741333333333BC41F41666666A6A6DB57416666666630C41F419A999939AADB5741CDCCCCCC22C41F4133333333ADDB5741333333330FC41F41333333D3B0DB57416666666606C41F419A9999D9B2DB574100000000FEC31F41333333D3B4DB574166666666FCC31F41000000C0B5DB57416666666600C41F41CDCCCCECB7DB57413333333305C41F419A999999B9DB5741333333330DC41F419A999979BBDB5741CDCCCCCC20C41F419A9999B9BEDB5741CDCCCCCC26C41F41CDCCCC4CC0DB5741CDCCCCCC2CC41F41CDCCCC0CC3DB57416666666630C41F419A999959C7DB5741CDCCCCCC3EC41F419A9999D9CDDB57410000000044C41F41666666C6D0DB5741CDCCCCCC48C41F419A999979D3DB5741000000004AC41F419A999919D6DB5741666666664CC41F41000000C0D7DB57419A99999953C41F41666666C6D9DB57416666666668C41F4166666686DDDB57413333333375C41F41333333B3E0DB5741CDCCCCCC78C41F41333333F3E2DB5741000000007EC41F41CDCCCC8CE7DB5741333333337FC41F41CDCCCC2CEFDB57413333333375C41F4166666626F3DB57416666666670C41F41CDCCCCACF4DB5741CDCCCCCC6EC41F4166666686F6DB57416666666672C41F4100000020F8DB57419A99999979C41F41CDCCCC8CFADB5741333333337FC41F41000000C0FBDB57419A9999998FC41F419A9999B9FEDB57416666666692C41F419A999979FFDB5741CDCCCCCC94C41F419A9999B900DC57416666666696C41F419A99993903DC57416666666696C41F416666666604DC5741CDCCCCCC88C41F416666662607DC57413333333379C41F410000008009DC5741CDCCCCCC6AC41F41666666C60BDC57419A99999967C41F419A9999B90CDC5741CDCCCCCC60C41F419A99995910DC57419A9999995DC41F416666662612DC57410000000068C41F41666666A61CDC5741CDCCCCCC6AC41F419A9999791DDC57410000000076C41F41000000401FDC57410000000080C41F410000000020DC5741CDCCCCCC98C41F419A99995921DC574166666666B0C41F410000006022DC5741CDCCCCCCF6C41F410000006025DC5741CDCCCCCC24C51F41333333B327DC57416666666648C51F416666660629DC5741CDCCCCCC7EC51F41666666662BDC57413333333389C51F41333333F32BDC57419A9999999BC51F41000000C02CDC574133333333BDC51F41666666262EDC574166666666DCC51F41CDCCCCAC2FDC574166666666EEC51F416666666630DC57416666666612C61F41CDCCCCCC31DC57413333333331C61F41CDCCCCEC32DC5741000000004EC61F41CDCCCC2C34DC57419A9999995BC61F41666666E634DC5741CDCCCCCC7CC61F416666660637DC574166666666A6C61F41CDCCCC8C39DC574133333333B3C61F41333333733ADC574166666666D8C61F41000000603DDC5741CDCCCCCC0EC71F41333333B342DC5741000000002CC71F416666666645DC57419A9999993BC71F419A99999946DC57413333333365C71F41000000A049DC5741CDCCCCCC9AC71F41CDCCCC0C4EDC574166666666A4C71F41000000204FDC574166666666C8C71F41666666C653DC574100000000E2C71F410000004057DC574100000000F4C71F413333337359DC57416666666608C81F41333333935BDC57419A99999929C81F41333333735EDC57413333333337C81F41666666865FDC5741CDCCCCCC52C81F413333337361DC57413333333371C81F419A99997963DC57419A999999B5C81F413333335368DC574166666666D2C81F41333333B36ADC57413333333303C91F41000000806EDC5741CDCCCCCC14C91F413333333370DC5741000000001EC91F410000002071DC5741000000002EC91F410000000073DC57419A99999935C91F410000000074DC5741666666663AC91F419A9999F974DC5741CDCCCCCC4AC91F419A99991979DC57419A9999995DC91F41CDCCCC0C80DC57419A99999975C91F419A99999986DC5741CDCCCCCC7AC91F41CDCCCC2C88DC5741666666668EC91F41CDCCCCEC8BDC57419A999999D9C91F41CDCCCCEC87DC5741CDCCCCCCDEC91F416666668687DC57416666666684CA1F41666666867EDC57410000000088CA1F419A9999F97DDC574100000000CECA1F41000000207BDC57416666666606CB1F410000004078DC5741666666664CCB1F41333333F373DC5741333333335FCB1F410000006072DC57413333333375CB1F410000000070DC57413333333395CB1F41666666266CDC574133333333BBCB1F413333337367DC5741CDCCCCCCD0CB1F41000000A064DC57419A999999DBCB1F419A99993963DC574166666666F4CB1F41666666A660DC5741CDCCCCCC16CC1F41666666465EDC57419A99999949CC1F41000000005BDC5741CDCCCCCC76CC1F416666666658DC5741CDCCCCCC8ECC1F41CDCCCC4C57DC57419A999999AFCC1F416666660656DC5741CDCCCCCCCCCC1F41666666C654DC574166666666F6CC1F413333333353DC57413333333323CD1F41CDCCCC0C52DC5741CDCCCCCC48CD1F41333333D350DC5741CDCCCCCC5ECD1F410000002050DC57413333333387CD1F41CDCCCCAC4EDC57419A9999999BCD1F41666666064EDC574100000000B4CD1F41666666664DDC57419A999999D1CD1F41666666664CDC57419A9999993FCE1F41333333734ADC574100000000A0CE1F41000000E045DC5741CDCCCCCC06CF1F41333333B341DC5741CDCCCCCC86CF1F41666666863CDC57416666666644D01F419A99991934DC574100000000E2D01F419A9999792CDC5741666666665ED11F41666666E625DC57419A99999995D11F41000000C023DC5741CDCCCCCC3CD21F41666666661DDC574166666666E4D21F413333339316DC574100000000A2D31F410000002010DC57419A999999D3D31F41CDCCCCCC0EDC5741CDCCCCCC48D41F41333333530CDC5741CDCCCCCCE0D41F419A9999B908DC57413333333313D51F410000006007DC574133333333ADD51F41CDCCCC6C02DC574133333333D9D61F41000000C0F7DB5741CDCCCCCC54D91F41CDCCCC2CE6DB5741CDCCCCCC9ED91F41666666E6DCDB574166666666CCD91F4133333313D8DB574166666666F0D91F4133333313D6DB5741CDCCCCCC2EDA1F4100000080D3DB57410000000090DA1F419A9999B9CFDB574133333333CBDA1F4100000040CDDB5741000000000ADB1F41CDCCCCECCBDB57410000000090DB1F41000000A0C9DB57419A9999991DDC1F419A999939C7DB57413333333343DC1F41CDCCCC6CC6DB57419A99999959DC1F419A9999D9C5DB5741CDCCCCCC62DC1F4166666606C5DB57413333333365DC1F41000000C0C3DB57419A99999963DC1F419A999979C2DB57410000000060DC1F419A999919C0DB57410000000044DC1F41000000A0B9DB57410000000030DC1F41CDCCCC0CB4DB57419A99999901DD1F4100000020B0DB574166666666F4DE1F41000000A0AADB574166666666D0E01F41333333F3A0DB57419A9999999DE11F41333333D397DB57419A999999EBE31F41666666E680DB5741000000008CE41F41333333537BDB57413333333321E51F419A99991974DB574166666666F4E51F419A9999996FDB57419A999999B5E61F41666666866BDB5741CDCCCCCC88E71F416666660663DB57410000000040E81F419A9999B959DB57419A999999E9E81F419A9999D94CDB57413333333333E91F419A99999944DB57416666666664E91F41CDCCCCCC41DB57419A9999999FE91F41666666C63FDB574133333333EFE91F41000000803DDB5741333333332FEA1F41000000A03CDB57413333333349EA1F41000000203CDB5741CDCCCCCC58EA1F41CDCCCC6C3BDB57413333333395EA1F413333339337DB5741CDCCCCCCB6EA1F416666668636DB57419A99999951EB1F410000008032DB5741333333330FEC1F419A9999B92DDB5741333333334DEC1F41CDCCCCEC2BDB5741CDCCCCCC80EC1F41000000C029DB5741CDCCCCCC92EC1F41CDCCCCEC28DB5741CDCCCCCC9EEC1F41CDCCCC0C2ADB5741CDCCCCCC00ED1F413333333334DB57413333333367ED1F41000000C03EDB5741CDCCCCCCD6ED1F41666666463BDB5741CDCCCCCC80EE1F41CDCCCC4C35DB57419A9999996BEF1F41333333B32DDB574133333333C3EF1F41000000602ADB57413333333347F01F41333333B325DB57410000000058F01F413333331325DB5741CDCCCCCCBAF01F41333333D32BDB57419A9999994BF11F41CDCCCC2C35DB57410000000084F11F410000002039DB5741CDCCCCCCACF11F41CDCCCC4C39DB5741CDCCCCCCEAF11F416666662636DB5741666666661CF21F41CDCCCC2C33DB57410000000042F21F416666668632DB57410000000090F21F41666666C634DB574133333333C5F21F419A9999F934DB574133333333F7F21F41CDCCCCAC33DB5741666666668CF31F41333333332FDB574133333333A1F41F41666666C628DB574100000000B8F51F41000000E01EDB57419A999999BFF51F41CDCCCC8C20DB574100000000CEF51F416666662623DB574133333333D9F51F413333333325DB574133333333E1F51F41666666E627DB5741CDCCCCCCE6F51F41CDCCCC6C2BDB574133333333E7F51F41333333332EDB5741CDCCCCCCE8F51F41CDCCCC0C33DB5741CDCCCCCCF2F51F41CDCCCC0C38DB57419A999999FBF51F41666666E63BDB57410000000008F61F41666666863FDB57419A99999919F61F41CDCCCC6C42DB57419A99999935F61F416666662645DB5741000000005CF61F41CDCCCC0C48DB5741CDCCCCCC9AF61F41333333534BDB574133333333C7F61F41CDCCCC4C4DDB574166666666EAF61F419A9999F94EDB574166666666F8F61F419A99991950DB57413333333303F71F419A99995951DB57416666666606F71F416666668652DB57419A999999FBF61F41CDCCCC6C57DB5741CDCCCCCCEEF61F41CDCCCC0C5ADB574133333333D9F61F41666666E65DDB5741CDCCCCCCCAF61F41333333B35FDB574133333333B9F61F41666666A663DB574100000000B6F61F41CDCCCC6C65DB574100000000B6F61F416666662667DB5741CDCCCCCCB8F61F41666666066ADB57419A999999C3F61F419A9999F96CDB57419A999999D7F61F41666666466FDB5741CDCCCCCCF4F61F410000006071DB57416666666626F71F416666660674DB574100000000D6F71F41333333D37CDB57416666666682F81F41666666E682DB5741333333334BF91F41666666C689DB574133333333DDF91F41333333138DDB5741666666666AFA1F413333337391DB5741000000008EFA1F41CDCCCC2C93DB5741CDCCCCCCA4FA1F416666660695DB574166666666E6FA1F41333333339CDB5741000000000EFB1F419A9999D9A0DB57419A99999959FB1F41666666A6A9DB574133333333A5FB1F419A9999B9B4DB574166666666BCFB1F419A999959B9DB574166666666D8FB1F4100000060B8DB5741666666664CFC1F41CDCCCC6CB4DB574100000000D6FC1F41CDCCCC4CAFDB5741CDCCCCCCD4FD1F41333333F3A5DB57410000000092FE1F41000000209FDB57419A999999CBFE1F41CDCCCC4C9DDB57413333333363FF1F419A9999F998DB5741666666660B0020410000006095DB57419A9999991E002041CDCCCCAC94DB5741333333334D0020419A99993992DB5741CDCCCCCCB3002041333333538CDB57413333333311012041333333B387DB57419A999999240120410000006086DB5741666666663D0120410000004084DB5741000000005F0120413333339380DB574133333333CE0120419A99995974DB57413333333322022041000000E06ADB5741333333337A022041CDCCCCCC61DB574166666666DB0220419A99993957DB5741333333331D032041CDCCCC8C50DB57410000000033032041666666264EDB57410000000064032041000000C047DB5741CDCCCCCCAD032041000000803EDB57419A999999F10320413333331336DB57416666666616042041CDCCCCAC31DB5741666666663A042041CDCCCC2C2EDB574166666666730420416666666629DB5741000000009E042041CDCCCCEC26DB574100000000B2042041666666E625DB5741CDCCCCCCE40420410000004021DB5741333333331D052041CDCCCCAC1CDB57413333333347052041666666A618DB574166666666550520416666664617DB5741000000007B0520413333339313DB5741CDCCCCCCA2052041000000200FDB574133333333BB0520419A9999990BDB5741CDCCCCCCD6052041CDCCCCAC07DB574166666666E8052041CDCCCCAC03DB574133333333FD0520416666662600DB5741CDCCCCCC0D06204166666666FDDA5741333333333306204166666666F8DA57419A9999994E062041000000E0F4DA5741000000006906204100000080F2DA57419A999999A3062041000000E0EDDA5741CDCCCCCCED062041CDCCCC6CE8DA5741000000004407204133333333E1DA57419A9999999B072041CDCCCCECDADA5741666666662C082041CDCCCC2CD1DA57413333333380082041000000C0C9DA5741000000000D0920419A9999D9B8DA57416666666661092041CDCCCC6CBADA5741CDCCCCCCF80920419A999999B8DA5741CDCCCCCCF0092041CDCCCC2CB3DA574100000000E70920419A999979AADA574166666666E30920419A999959A5DA57419A999999E209204100000060A1DA574100000000E5092041333333D39DDA574166666666EF0920416666668697DA574100000000000A2041666666468EDA574166666666130A2041666666E685DA574166666666F2092041CDCCCCCC85DA57419A999999DE0920416666662686DA574133333333B20920419A99993987DA57419A9999999F092041CDCCCCCC87DA5741333333337D0920410000006089DA5741000000004D0920419A9999B98BDA57410000000017092041333333B38EDA574133333333C3082041CDCCCC4C94DA57413333333394082041CDCCCC0C98DA57413333333371082041333333739ADA5741CDCCCCCC55082041CDCCCCEC9BDA57419A99999931082041333333939DDA5741666666660E082041000000E09EDA57419A999999F1072041000000809FDA574100000000DE072041000000A09FDA574166666666BF0720419A9999999FDA57416666666691072041333333139FDA5741666666665E072041CDCCCC6C9EDA57410000000041072041333333339EDA5741333333332F072041CDCCCC4C9EDA5741000000001C072041CDCCCCEC9EDA5741333333330A072041000000A09FDA574133333333F706204166666606A0DA5741CDCCCCCCE506204133333313A0DA574133333333CD062041000000608BDA5741CDCCCCCCAF062041CDCCCCCC79DA5741CDCCCCCC8C062041333333F36EDA57413333333383062041000000A06ADA5741CDCCCCCC80062041CDCCCC2C5EDA57419A999999D80520419A9999593DDA574166666666D7042041CDCCCCAC0ADA57416666666660022041CDCCCC8C8ED95741000000009C012041333333F373D95741000000009D0120416666660672D95741000000009D012041CDCCCC8C70D957419A9999999C0120419A9999F96ED95741333333339C012041333333336DD95741000000009C0120419A9999B96BD95741666666669B012041333333F368D95741CDCCCCCC9A012041CDCCCCCC66D9574166666666980120413333339364D9574100000000940120413333339362D9574133333333900120413333337360D95741CDCCCCCC8E012041000000405ED957419A9999998D012041666666E65BD95741333333338A012041CDCCCC2C59D957416666666685012041CDCCCCEC55D95741000000007F0120413333339353D95741000000007B0120419A9999B950D9574100000000780120419A9999994DD95741CDCCCCCC77012041333333734BD95741CDCCCCCCDC0020413333337309D9574100000000C2002041333333D30BD957419A999999810020416666668611D95741333333331A002041666666C61AD95741CDCCCCCCD0FF1F41000000201FD95741666666669EFF1F413333339321D957416666666686FF1F41CDCCCC6C23D95741333333336BFF1F413333337323D95741CDCCCCCC5AFF1F41CDCCCCAC23D95741333333333DFF1F41666666E624D957410000000018FF1F41333333B326D957419A999999BDFD1F419A999999F6D857413333333395FD1F4133333353F7D857410000000076FD1F41666666C6F7D857419A999999F1FC1F41666666E6F8D857419A9999999BFC1F41CDCCCCECF8D857419A9999994BFC1F41CDCCCCACF8D857419A99999919FC1F4100000080F8D8574133333333D9FB1F4133333393F8D8574166666666B0FB1F41000000A0F8D857419A9999996DFB1F41000000C0F8D857419A9999993DFB1F41CDCCCCCCF8D85741CDCCCCCC16FB1F41000000A0F8D8574100000000ECFA1F4100000040F8D8574133333333BDFA1F41CDCCCC2CF8D857413333333391FA1F41CDCCCC4CF8D857416666666668FA1F4166666666F8D857410000000032FA1F4100000060F8D857419A9999990BFA1F419A9999D9F7D8574166666666D8F91F41CDCCCC0CF7D85741CDCCCCCC9EF91F4100000020F6D85741666666666CF91F41333333B3F4D85741CDCCCCCC3CF91F419A999979F3D857413333333315F91F4133333353F2D8574100000000F0F81F41CDCCCC2CF1D8574100000000C4F81F41CDCCCC4CF0D857410000000094F81F419A999919EFD857419A99999951F81F4166666686EDD85741666666660EF81F41CDCCCCACEBD8574166666666E0F71F4166666626EBD85741CDCCCCCCE8F71F4133333353E6D857419A99999919F81F419A9999B9E2D857416666666658F81F4133333393DED85741CDCCCCCC74F81F4100000000DCD85741333333337DF81F4133333333DAD85741000000007EF81F4133333373D8D85741333333337BF81F419A9999F9D6D857410000000076F81F419A999959D5D85741CDCCCCCC70F81F41CDCCCCECD3D857413333333369F81F419A999959D2D857416666666664F81F4133333333D0D85741CDCCCCCC62F81F4166666626CED85741CDCCCCCC64F81F41CDCCCC4CCCD85741CDCCCCCC6EF81F4166666666CAD85741CDCCCCCC80F81F4166666686C8D857410000000092F81F41333333B3C6D8574100000000AAF81F419A999999C4D8574133333333BDF81F4133333353C3D85741CDCCCCCCD6F81F41000000C0C1D857419A999999E7F81F4133333333C0D8574100000000F4F81F41CDCCCCCCBED857416666666602F91F4100000020BDD85741CDCCCCCC0EF91F41CDCCCCCCBBD85741CDCCCCCC22F91F419A999939BAD857419A9999992BF91F41000000A0B3D857410000000014F91F41333333B3A7D857416666666612F91F41666666269CD8574133333333FBF81F41CDCCCC8C8ED857419A999999F1F81F41000000207ED857413333333359F81F41CDCCCCEC81D8574100000000E4F71F419A9999D983D85741666666664AF71F41333333D385D8574166666666DAF61F410000008087D857416666666660F61F41CDCCCCAC89D857413333333307F61F41000000008CD8574100000000B2F51F41CDCCCC8C8ED857416666666644F51F41CDCCCCEC91D857419A999999E3F41F419A9999B994D85741666666668EF41F41333333F396D85741CDCCCCCC2CF41F419A9999D998D85741CDCCCCCCB2F31F41000000209BD857410000000010F31F419A9999799DD857410000000050F21F419A9999F99FD85741CDCCCCCC16F21F419A9999F991D857419A99999907F11F41CDCCCC2C63D85741000000006EF01F416666660666D857419A999999C3EF1F41000000A068D85741000000004EEF1F41333333736AD857413333333305EF1F41000000E06AD857416666666690EE1F41666666866BD857419A99999929EE1F41333333B36BD8574133333333DDED1F41000000E06BD8574166666666B2ED1F41000000206CD857416666666668ED1F419A9999996CD857410000000024ED1F41CDCCCC2C6DD8574100000000E2EC1F41666666466DD85741CDCCCCCC82EC1F41666666666DD857410000000020EC1F41666666866DD85741CDCCCCCCD4EB1F41000000A06DD85741000000006AEB1F41666666C66DD8574166666666ECEA1F419A9999396ED8574100000000A4EA1F419A9999996ED85741000000004AEA1F419A9999796FD857410000000024EA1F419A9999D96FD85741CDCCCCCCEEE91F413333331370D8574166666666BAE91F413333331370D85741CDCCCCCC96E91F416666660670D8574100000000C0E81F419A9999996FD857413333333393E81F41CDCCCC4C6FD857419A9999994BE81F419A9999396ED857413333333323E81F41666666C66DD85741CDCCCCCCF8E71F41666666A66DD857419A999999BBE71F41333333F36DD857419A9999998DE71F41CDCCCCAC6ED85741CDCCCCCC5EE71F41333333536FD857410000000008E71F419A99997971D85741CDCCCCCCD2E61F410000008072D85741CDCCCCCCA0E61F416666662673D8574100000000E0E51F41CDCCCC2C75D85741333333333DE51F419A99993976D85741333333330DE51F416666664676D857419A999999E1E41F419A9999F975D857410000000092E41F410000002075D857416666666676E41F41CDCCCC0C75D857419A99999961E41F41CDCCCC6C75D857416666666636E41F41333333D376D8574166666666D0E31F41CDCCCCAC79D85741CDCCCCCC52E31F41000000E07CD8574100000000F2E21F41666666067FD8574166666666BCE21F41000000607FD857410000000090E21F419A9999B97FD85741333333333FE21F41000000A080D85741CDCCCCCC18E21F416666662681D85741CDCCCCCCB4E11F410000002083D85741CDCCCCCC72E11F410000002085D857413333333357E11F41CDCCCC2C86D857419A999999D7DF1F41CDCCCCACB5D8574133333333D1DB1F419A999999C4D85741CDCCCCCCA8DB1F41666666C6BCD857419A99999945DB1F41000000E0ACD85741CDCCCCCC38DB1F4133333373ABD85741CDCCCCCC26DB1F41333333B3AAD85741CDCCCCCCE6DA1F4100000020A9D8574100000000CADA1F419A9999D9A9D85741666666664EDA1F4100000060ADD8574100000000CAD91F4166666666B1D85741000000006CD91F4100000080B4D8574133333333FBD81F419A9999D9B8D85741333333337BD81F41333333F3BDD8574100000000E4D71F41CDCCCC0CC4D85741CDCCCCCCF6D61F4133333393CCD85741000000000ED61F4100000060D4D85741CDCCCCCC64D51F41CDCCCC6CDAD857410000000030D51F4133333353DCD857419A999999ABD41F4166666686E0D85741CDCCCCCC48D41F419A9999F9E2D8574133333333CBD31F419A999959E6D857419A9999993FD31F41333333F3EAD857419A999999C7D21F41666666C6EED857419A999999DDD11F41666666E6F7D857419A99999933D11F4100000020FDD85741CDCCCCCCD0D01F41CDCCCCECFFD857419A999999A9D01F410000004000D95741666666666AD01F419A99991901D957416666666634D01F41CDCCCC4C01D9574133333333C3CF1F416666666601D957416666666670CF1F416666662601D957419A999999FFCE1F419A99999900D957419A99999999CE1F4166666666FFD85741CDCCCCCC4CCE1F41CDCCCCCC00D957419A9999991BCE1F419A99993901D957419A999999E3CD1F41CDCCCC2C02D957419A999999CBCD1F410000008002D9574133333333ADCD1F41CDCCCC0C03D957419A99999987CD1F419A9999B903D95741333333335BCD1F410000008004D95741CDCCCCCC26CD1F416666666605D957410000000004CD1F410000000006D95741CDCCCCCCD6CC1F416666664607D9574166666666B4CC1F416666664608D95741333333338BCC1F41CDCCCCAC09D95741333333335FCC1F419A9999590BD957416666666638CC1F41000000000DD95741CDCCCCCCD2CB1F419A99997911D957410000000030CB1F419A9999591AD9574166666666F8CA1F41333333D318D95741CDCCCCCC44CA1F41666666C613D957419A99999909CA1F410000002012D957419A999999C1C91F413333337310D957416666666662C91F419A9999D90ED957419A999999B3C81F41CDCCCCCC0CD957413333333303C81F419A9999990AD957419A9999999DC71F413333335309D957419A9999994FC71F419A9999D908D957419A99999909C71F41333333D308D95741333333333DC61F413333339309D9574166666666C2C51F41CDCCCC4C0AD957416666666690C51F41333333930AD957419A9999998DC51F41666666860AD95741CDCCCCCC84C51F419A9999D90BD957416666666682C51F41000000C00DD95741000000007CC51F41333333F30ED957419A99999971C51F41CDCCCCAC10D957416666666662C51F413333333312D957416666666658C51F413333335314D95741CDCCCCCC4CC51F41333333D316D957410000000042C51F41CDCCCC0C19D957416666666630C51F41666666A61CD957416666666626C51F419A9999791ED957416666666612C51F413333331321D957410000000000C51F419A9999D924D957419A999999EDC41F41CDCCCCAC27D957419A999999D7C41F419A9999F92BD9574100000000CCC41F41CDCCCCEC2DD957419A999999B5C41F41666666A630D95741CDCCCCCC98C41F419A99993934D957413333333383C41F419A9999D936D957413333333365C41F41000000A039D95741333333333FC41F41666666863DD95741666666661CC41F41333333F33FD9574133333333EFC31F41CDCCCC2C43D957419A9999990FC31F419A9999F950D957419A999999B7C11F413333335366D957419A99999993C11F416666660669D9574133333333E9C01F419A9999595AD95741000000009EC01F41000000805FD9574133333333D7BF1F41666666A670D9574133333333A5BF1F413333339374D957416666666688BF1F41CDCCCC4C76D957416666666666BF1F413333337377D957419A99999911BF1F41CDCCCC4C78D95741CDCCCCCC82BE1F41000000207AD95741666666663EBE1F41000000807BD957419A99999911BE1F41666666267DD95741CDCCCCCCCEBD1F410000000080D957419A99999993BD1F419A99997983D957410000000064BD1F41CDCCCCAC87D95741666666662CBD1F41666666468CD95741CDCCCCCCFCBC1F419A99991991D95741CDCCCCCCECBC1F416666664693D9574133333333D1BC1F419A99991995D957419A99999999BC1F413333333399D957410000000058BC1F41666666C69DD957419A9999993BBC1F41CDCCCC6C9FD95741CDCCCCCC28BC1F4100000040A0D957410000000010BC1F41666666A6A0D9574100000000F8BB1F41CDCCCC8CA1D9574166666666B8BB1F41CDCCCCACA4D95741666666667EBB1F41CDCCCC6CA7D95741333333334DBB1F4100000080A9D957416666666600BB1F41CDCCCC8CACD9574133333333A9BA1F419A9999D9AFD95741CDCCCCCC58BA1F4166666606B4D957416666666634BA1F4133333393B5D957419A99999923BA1F41333333F3B5D957419A99999913BA1F41333333F3B5D9574133333333E3B91F41CDCCCCACB5D9574100000000DAB91F419A9999D9B6D9574166666666C4B91F41000000E0B8D95741CDCCCCCCB2B91F4133333333BAD95741	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	01010000206A08000043D7299402E81F41CDCCCC5C77DA5741	310080000	Z	Anan	3100800	31008	31	76	14
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	01010000206A0800009E268F1B75261F4134333323E3B05741	310090000	Z	Antichan-de-Frontignes	3100900	31009	31	76	4
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	01010000206A0800007ACE11536DAD1E41000000B01EA25741	310100000	Z	Antignac	3101000	31010	31	76	6
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	01060000206A08000001000000010300000001000000C900000033333333FE122041333333D37BB257419A9999993A1320416666660682B2574166666666DB132041333333D390B257419A999999351420419A9999F996B25741333333337C14204166666626A2B2574133333333B914204133333313B0B2574100000000EC14204100000080BCB257416666666628152041CDCCCCECC3B25741CDCCCCCC8E15204133333353CBB25741CDCCCCCC2416204166666626D0B257413333333389162041CDCCCC8CD7B25741666666662A1720419A999959EBB25741CDCCCCCC8417204100000000F4B2574100000000EA1720410000006005B3574133333333501820419A9999790CB357419A9999996F182041333333330DB35741666666669D182041333333330EB3574133333333DE182041CDCCCC8C10B357410000000026192041666666C612B357413333333368192041000000E015B357419A99999998192041CDCCCCEC19B357419A999999E8192041CDCCCCEC20B35741CDCCCCCC1E1A2041CDCCCC8C27B3574100000000361A2041666666462BB3574166666666381A2041CDCCCCCC2CB357419A9999993F1B2041333333732CB357419A999999991B20419A9999992DB357419A999999D71B20416666660630B35741CDCCCCCCE11B2041666666C633B3574166666666D81B2041666666863CB3574133333333BB1B2041666666C647B3574166666666451B2041000000A064B35741333333333C1B20410000002071B35741CDCCCCCC5A1B2041333333137BB3574133333333971B2041000000C083B3574133333333F11B2041CDCCCCAC83B35741CDCCCCCC2C1C20419A9999D97FB3574133333333681C2041CDCCCCCC75B35741CDCCCCCCC11C20419A9999F971B35741CDCCCCCCE91C2041CDCCCC2C73B3574100000000301D20419A9999D976B3574166666666801D2041000000007DB35741CDCCCCCCB21D2041333333B385B3574133333333FA1D20419A9999199CB35741CDCCCCCC2C1E2041666666C6A4B35741333333337F1E204133333373ACB3574133333333151F204166666686AEB35741CDCCCCCCB41F2041000000E0ABB3574166666666402020419A9999F9A7B357410000000091202041333333339DB3574100000000EA20204133333353A0B3574100000000482120419A9999B9A3B35741666666665E212041CDCCCCACA4B357419A9999996C2120419A9999B9A5B35741000000003B212041333333B3B6B357413333333346212041CDCCCC6CCEB357413333333398212041000000C0D3B3574166666666FD21204100000060DDB35741CDCCCCCC07222041333333B3E3B35741666666661C22204166666666ECB3574100000000322220419A99995905B457419A99999979222041000000401EB45741CDCCCCCCB6222041CDCCCC2C32B4574133333333E02220419A99991946B457419A999999EA2220419A9999594CB457416666666644232041CDCCCC2C54B4574166666666442320410000006055B45741666666664A232041CDCCCC8C57B457413333333357232041CDCCCC6C5BB45741666666666A232041666666C65EB457416666666683232041333333F361B45741CDCCCCCC95232041CDCCCC8C64B4574133333333AC232041CDCCCC8C67B4574166666666BB232041000000006AB457419A999999C2232041333333136CB457419A999999C4232041666666E66DB4574100000000C4232041000000E06FB45741CDCCCCCCE62320410000004072B4574100000000F4232041000000C072B457416666666612252041CDCCCCEC87B4574166666666172520410000004090B4574166666666132520419A99995992B45741CDCCCCCC11252041CDCCCC6C95B457416666666611252041333333B399B4574100000000132520419A9999799EB45741333333331A252041333333D3A1B457419A99999926252041000000A0A6B45741CDCCCCCC31252041CDCCCC0CABB4574100000000C9252041666666E6A8B45741000000004D262041CDCCCCACACB45741CDCCCCCC20272041000000E09DB457419A99999966272041CDCCCC4C9CB4574133333333C4282041333333B39AB4574100000000E2282041CDCCCC6C99B457419A999999802920416666664685B4574133333333AB292041CDCCCC8C7EB4574166666666FE292041CDCCCCAC7BB457419A999999A12A2041666666C674B4574166666666C62A20419A99997973B45741CDCCCCCCED2A2041333333F370B4574100000000082B2041666666066FB45741CDCCCCCC112B20419A9999D96CB4574133333333152B2041666666466AB4574133333333132B20419A9999B967B4574133333333152B20416666660665B4574166666666932B20413333337345B4574166666666EB2B20413333339340B4574100000000AE2C2041333333D329B457419A999999252D20413333331335B4574166666666992E2041666666C62EB4574133333333112F2041666666A62EB45741333333337F2F20416666660631B4574133333333E32F2041CDCCCCEC30B457419A9999995A302041CDCCCCCC2BB457410000000013312041CDCCCCEC28B45741333333336D3120416666668629B457419A9999999B312041000000E021B45741CDCCCCCC18322041000000E006B457410000000017322041CDCCCC4CEDB3574166666666373220419A9999D9E2B35741666666667733204166666606BDB3574133333333BB342041CDCCCCCC91B357416666666600352041000000C087B3574100000000143520419A99997981B357419A999999D7342041CDCCCC4C7BB35741CDCCCCCCF0332041CDCCCC0C6AB35741333333338B332041333333935DB35741666666663A3320419A9999394BB3574166666666F23220410000002041B35741CDCCCCCC8D3220419A99997938B35741333333333D322041333333132DB3574166666666E2312041333333731FB35741333333337E312041CDCCCC4C19B35741333333334C3120419A9999991AB35741CDCCCCCCCA3020419A9999F91FB35741CDCCCCCC7A302041CDCCCCCC1EB35741CDCCCCCC732F20419A9999D90AB3574100000000DD2E204166666646FDB25741CDCCCCCCDC2E204166666686F9B2574100000000182F20419A9999B9F0B25741CDCCCCCC172F20419A9999F9ECB2574133333333C52E20419A999979D2B2574166666666B12E2041000000A0C7B2574166666666AF2E2041CDCCCCACA9B2574133333333A52E2041666666C696B25741333333336E2E2041333333337FB257419A999999672E2041CDCCCCAC78B2574133333333692E2041CDCCCCEC75B25741666666665F2E2041CDCCCC2C6FB2574133333333562E2041CDCCCCCC6AB25741000000004F2E2041CDCCCC8C67B257419A999999432E20416666668663B2574133333333372E2041CDCCCC2C5FB257419A999999282E2041CDCCCCCC5AB2574100000000112E20419A99999955B2574133333333E92D20419A9999D949B2574166666666AD2D2041CDCCCCAC3CB2574166666666262D2041000000E026B257419A999999232D20419A99993926B25741CDCCCCCC192D20416666666623B257419A9999990C2D20413333337321B25741CDCCCCCCFE2C2041333333B31FB2574100000000F02C20419A9999F91DB25741CDCCCCCCE32C20419A9999D91BB2574166666666D72C2041CDCCCC2C1AB25741CDCCCCCCCB2C20419A99993918B2574133333333BF2C20410000000016B257419A999999B22C20416666662614B2574100000000A32C2041CDCCCC4C12B25741CDCCCCCC682C20413333339301B2574133333333FC2B2041CDCCCC2CF1B15741CDCCCCCCF72B2041000000E0EDB15741CDCCCCCCF22B2041333333F3E9B157419A999999EE2B2041CDCCCCECE5B15741CDCCCCCCE82B2041000000A0E1B15741CDCCCCCCE22B204100000000DEB157419A999999DD2B2041000000E0D9B1574133333333D72B204166666646D6B1574133333333D12B204133333373D3B157419A999999C92B2041666666C6D0B1574133333333C32B2041CDCCCCECCEB15741CDCCCCCC922B2041CDCCCCACCEB15741CDCCCCCC3B2B2041CDCCCC8CCEB15741333333335C2A2041CDCCCC8CCEB15741CDCCCCCC9E29204100000040D5B157419A9999994E2920419A999959D0B157413333333333282041666666A6B7B157413333333356272041666666A6A3B157419A999999EC2520413333339388B15741CDCCCCCCAE232041CDCCCC0C58B15741CDCCCCCC932120416666668684B157416666666684212041666666A685B15741666666667D2120410000006087B1574166666666361F2041CDCCCCCCC1B157419A9999992A1E2041666666C6DEB1574100000000CF1C20419A999959FEB1574100000000711B2041333333B316B25741666666661E1A20416666660626B25741CDCCCCCCF0172041333333933FB2574133333333011420413333335370B2574133333333FE122041333333D37BB25741	01010000206A0800001EA853336E2320413333335301B35741	310110000	Z	Arbas	3101100	31011	31	76	7
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	01010000206A080000A658B3911E6C1F41CDCCCCEC64B45741	310120000	Z	Arbon	3101200	31012	31	76	4
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	01010000206A0800004ABB2E5B41061F419A9999B973BB5741	310130000	Z	Ardiège	3101300	31013	31	76	4
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	01010000206A080000A84804B3DE5C1F41666666D6B9AF5741	310140000	Z	Arguenos	3101400	31014	31	76	11
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	01010000206A080000820F3EE83F511F41000000B090A85741	310150000	Z	Argut-Dessous	3101500	31015	31	76	3
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	01010000206A080000B5CCF3B65E3B1F41666666D60FA75741	310170000	Z	Arlos	3101700	31017	31	76	10
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	01010000206A08000099242FB92A26204100000050BEC35741	310180000	Z	Arnaud-Guilhem	3101800	31018	31	76	8
01060000206A0800000100000001030000000100000010030000000000005ACB1E41CDCCCC6CA1A25741000000000CCC1E4166666646ADA257419A99999985CC1E41333333B3B9A25741333333332DCE1E41333333B3D8A257416666666692CE1E41000000E0E2A25741000000000CD11E419A9999F91BA35741000000000ED11E41333333F31BA357416666666628D11E41333333931BA35741000000004ED11E419A9999B91AA35741666666665ED11E41000000601AA357419A99999983D11E41CDCCCC8C19A3574166666666B2D11E41666666A618A3574166666666FCD11E410000008017A35741CDCCCCCC20D21E413333331316A35741CDCCCCCC62D21E41333333D313A357413333333397D21E41000000C011A3574133333333D7D21E41333333D30EA35741CDCCCCCC0ED31E41000000000DA35741666666664AD31E41333333F30BA357419A9999995DD31E419A9999790CA35741000000007CD31E41CDCCCCCC0DA357410000000092D31E41CDCCCC4C0FA3574166666666BAD31E419A99999911A3574100000000CED31E41000000E012A35741CDCCCCCCF0D31E416666660614A35741000000000CD41E41CDCCCC8C14A35741CDCCCCCC32D41E41333333F314A35741CDCCCCCC76D41E419A99991915A357419A99999997D41E41666666A614A3574166666666DED41E416666664613A35741CDCCCCCCF8D41E416666666612A357419A9999991FD51E410000008011A35741000000004ED51E419A99993911A357419A99999993D51E41CDCCCCCC11A3574133333333B7D51E410000006012A357416666666602D61E41333333B313A357410000000056D61E41CDCCCC4C15A357410000000094D61E413333339315A35741CDCCCCCCC4D61E416666664615A357419A999999D7D61E41666666E613A35741CDCCCCCCE8D61E41333333D311A3574166666666EED61E41333333F310A3574100000000FCD61E416666664610A357416666666612D71E41666666C60FA357410000000052D71E41666666A60EA357410000000068D71E419A9999190EA3574166666666A8D71E41CDCCCCAC0DA357419A999999CFD71E41CDCCCCAC0DA3574133333333EFD71E41333333D30DA357413333333329D81E41333333D30EA35741CDCCCCCC2CD81E41CDCCCC0C0FA35741666666663CD81E41666666E60FA35741000000004CD81E419A9999D910A357413333333361D81E41666666E611A35741CDCCCCCC84D81E410000008013A357419A999999EDD81E410000002018A357416666666656D91E41666666461CA357410000000094D91E41333333531FA35741000000009ED91E419A99993920A35741CDCCCCCCAAD91E41CDCCCC0C21A357419A999999B3D91E41666666C621A3574166666666C2D91E410000002023A35741CDCCCCCCD4D91E419A9999D923A3574133333333EDD91E413333335324A357410000000002DA1E419A99997924A357419A99999911DA1E419A99999924A357410000000032DA1E41333333B324A35741333333335BDA1E41CDCCCC8C24A35741CDCCCCCC72DA1E41CDCCCC2C24A357413333333391DA1E41000000C023A3574100000000BEDA1E410000000023A35741CDCCCCCCFEDA1E410000002022A35741000000002CDB1E410000004021A357416666666652DB1E410000000020A35741666666661ADC1E416666666619A357419A99999931DC1E41666666A618A35741CDCCCCCC68DC1E419A99997916A3574133333333BFDC1E416666662613A357410000000058DD1E419A9999B90BA357419A9999995BDE1E4100000040FEA25741666666669EDE1E41666666C6FAA257419A999999E1DE1E4133333393F7A25741000000002ADF1E4100000060F4A257413333333379DF1E4166666666F2A2574133333333BFDF1E4100000060F2A25741000000000AE01E4166666606F2A25741CDCCCCCC3CE01E41666666A6F0A257410000000056E01E4100000000EEA257419A99999955E01E4166666646EBA25741666666665CE01E41666666A6E7A257413333333385E01E4133333373E5A2574100000000BAE01E419A999939E5A2574166666666ECE01E4166666626E4A25741CDCCCCCC1AE11E41666666E6E2A257413333333361E11E41CDCCCC6CE1A25741CDCCCCCCACE11E41333333B3DFA257419A999999EFE11E4100000060DDA25741CDCCCCCC16E21E4100000080DAA25741CDCCCCCC30E21E41CDCCCCECD7A25741000000005EE21E4100000020D5A25741CDCCCCCC9AE21E4166666666D3A2574100000000CAE21E41CDCCCC0CD4A257419A999999FFE21E4133333313D4A257410000000026E31E419A999999D2A25741CDCCCCCC44E31E419A999939D0A257419A9999997DE31E419A999919CFA2574133333333BFE31E4133333393CEA25741CDCCCCCC02E41E41CDCCCC0CCDA25741CDCCCCCC26E41E419A999919CBA25741CDCCCCCC52E41E41000000E0C8A25741666666667EE41E4166666606C9A2574100000000A8E41E4166666686CAA25741CDCCCCCCE6E41E41CDCCCC0CCBA257419A99999925E51E41666666E6C9A25741666666665EE51E41333333B3C7A257419A99999997E51E4133333333C5A25741CDCCCCCCC8E51E4100000020C2A2574166666666F8E51E41666666C6BEA257413333333327E61E41000000E0BBA257413333333363E61E41333333B3BAA2574166666666A4E61E419A999939BAA2574166666666E0E61E4100000000B9A257419A99999913E71E41333333D3B6A25741666666663CE71E419A999999B3A25741CDCCCCCC70E71E4100000080B0A25741000000009EE71E419A9999B9ADA257419A999999CDE71E41000000E0AAA257419A99999907E81E41CDCCCCCCA7A257410000000040E81E4133333313A6A25741CDCCCCCC8AE81E4133333313A5A257419A999999CBE81E41333333F3A4A257419A99999907E91E41000000E0A4A25741333333334FE91E419A999959A5A257419A99999997E91E41666666E6A4A2574133333333DBE91E41666666A6A4A257413333333323EA1E41666666E6A3A257416666666664EA1E41CDCCCC4CA2A25741CDCCCCCCA0EA1E4166666626A1A2574100000000D4EA1E41CDCCCC6C9FA257419A9999990DEB1E41333333F39EA257410000000040EB1E419A999919A0A25741CDCCCCCC7EEB1E41333333B3A0A2574100000000AEEB1E41000000A09FA2574100000000CCEB1E41CDCCCC0C9EA2574166666666E8EB1E41666666E69BA257413333333311EC1E41000000E099A25741CDCCCCCC44EC1E410000000099A25741CDCCCCCC7AEC1E41333333B398A2574166666666AEEC1E41CDCCCCAC98A25741CDCCCCCCF4EC1E419A99997998A257410000000042ED1E419A99995998A25741000000008AED1E41CDCCCC8C99A2574100000000BEED1E41000000C09AA2574166666666F0ED1E41333333139DA257419A99999923EE1E41000000E09EA25741CDCCCCCC60EE1E4133333393A1A257419A99999999EE1E4166666626A4A2574166666666CEEE1E4166666646A6A2574133333333EDEE1E4166666666A7A25741CDCCCCCC1EEF1E41CDCCCC0CA9A257419A99999953EF1E41CDCCCC6CAAA257419A99999983EF1E419A9999D9AAA25741CDCCCCCCB0EF1E4133333393ABA2574166666666F4EF1E41000000A0ABA25741666666661CF01E419A999919ABA257413333333345F01E4100000060AAA25741CDCCCCCC7AF01E41CDCCCCECA8A2574100000000AEF01E41666666A6A7A2574100000000ECF01E4100000020A7A257410000000030F11E41CDCCCC0CA7A257413333333365F11E4100000040A8A257419A9999999FF11E419A999959A9A25741CDCCCCCCDAF11E41666666A6A9A25741CDCCCCCC28F21E4100000080A9A257419A99999955F21E41CDCCCCACA8A25741CDCCCCCC7CF21E41CDCCCCECA7A25741CDCCCCCCACF21E41333333D3A6A2574100000000E2F21E4166666606A6A257416666666614F31E419A999999A5A25741CDCCCCCC5AF31E41CDCCCC8CA4A25741333333339DF31E419A9999F9A3A2574166666666DCF31E41666666A6A3A257419A99999939F41E419A999979A3A257410000000096F41E41000000E0A3A25741CDCCCCCCE6F41E4166666646A4A25741CDCCCCCC44F51E4133333353A4A25741000000007EF51E41000000E0A3A2574166666666AAF51E41000000C0A2A25741CDCCCCCCD0F51E41000000A0A1A25741CDCCCCCC02F61E41333333D39FA25741000000001EF61E419A9999199EA25741CDCCCCCC3EF61E41CDCCCCCC9CA257416666666666F61E41333333939BA25741000000009AF61E413333335399A2574166666666CCF61E416666668698A257419A99999905F71E41CDCCCC0C98A257413333333331F71E41666666A697A257410000000064F71E410000008097A257419A9999999FF71E419A9999F997A2574100000000D2F71E419A99993998A257419A99999903F81E419A99995998A25741CDCCCCCC28F81E410000008097A257416666666650F81E41333333F396A257419A9999997BF81E419A99991996A25741CDCCCCCCACF81E41CDCCCC8C95A25741CDCCCCCCD2F81E419A99999994A2574100000000FCF81E41CDCCCCEC93A257419A99999919F91E41000000C092A257419A9999993DF91E413333337391A25741000000006CF91E416666664690A25741000000008CF91E41666666668FA257419A999999B5F91E41CDCCCC6C8EA257419A999999E1F91E41666666868DA257410000000000FA1E419A9999998CA257410000000034FA1E419A9999198BA25741000000006CFA1E419A9999198AA25741666666669CFA1E41333333B389A2574166666666E0FA1E41CDCCCCCC88A257416666666620FB1E419A99991988A25741666666665AFB1E41000000E087A2574166666666A4FB1E41666666C687A25741CDCCCCCCE2FB1E419A99993988A257410000000032FC1E41CDCCCCAC88A25741CDCCCCCC66FC1E41666666A689A257419A999999A7FC1E41000000808AA2574133333333EBFC1E41000000008BA257413333333337FD1E41333333F38BA25741CDCCCCCC66FD1E41666666468CA25741CDCCCCCC98FD1E41000000408CA2574133333333C9FD1E41CDCCCC2C8CA257410000000000FE1E419A9999398CA25741CDCCCCCC44FE1E41666666C68CA25741CDCCCCCC7CFE1E41333333338DA25741CDCCCCCCA6FE1E419A9999F98CA257419A999999C9FE1E41333333D38BA2574100000000E6FE1E41000000C08AA257419A99999907FF1E41CDCCCCAC89A257416666666630FF1E419A99995988A257416666666658FF1E419A9999D987A257419A99999981FF1E41CDCCCC2C87A257419A999999ABFF1E416666660686A2574133333333CFFF1E419A9999F983A2574166666666F0FF1E413333333383A25741666666661E001F41CDCCCCEC81A257410000000040001F41666666A680A257413333333359001F41333333937FA25741CDCCCCCC80001F41333333537EA25741CDCCCCCCA2001F419A9999D97DA2574100000000D0001F41000000A07DA2574166666666F6001F41CDCCCCEC7CA257416666666624011F41333333D37CA25741CDCCCCCC42011F419A9999597CA257416666666662011F41666666267BA25741CDCCCCCC7E011F41666666867AA2574133333333AD011F41000000C079A2574100000000D0011F41CDCCCC6C79A257419A999999F7011F419A9999F978A257419A99999927021F419A99993979A257419A9999995B021F41CDCCCCAC78A25741CDCCCCCC9E021F419A99991978A25741CDCCCCCCEA021F41333333B377A25741CDCCCCCC2C031F413333337376A257410000000078031F41333333B375A2574166666666D2031F413333339375A25741000000003E041F410000002076A257413333333305051F416666664679A2574100000000A4051F41333333D37BA257419A999999AB061F41333333937CA257419A99999997071F41000000C07DA2574166666666B4071F419A9999F97DA257413333333365081F416666662680A25741666666666C081F41666666267FA257413333333373081F41666666E67DA25741CDCCCCCC7C081F41CDCCCC6C7CA25741000000009C081F413333337377A2574100000000B2081F419A99991975A2574133333333B9081F41666666E673A257419A999999BB081F413333333372A2574100000000BA081F41333333B36EA257419A999999B5081F419A9999996BA2574100000000B2081F419A99997968A2574166666666AC081F416666664665A257419A999999A3081F41666666C662A2574166666666A2081F41000000C061A257419A999999A3081F413333331361A2574100000000B2081F41333333B35CA257419A999999BF081F419A99997959A25741CDCCCCCCCE081F410000008056A2574133333333DB081F41333333B353A257419A999999E5081F41CDCCCC6C50A2574166666666EC081F41000000004EA257419A999999F3081F41000000804BA2574100000000F8081F41000000E048A2574133333333FB081F413333337346A257410000000000091F41333333B343A257413333333305091F413333337341A257413333333309091F41CDCCCCCC3EA25741CDCCCCCC0E091F41000000603CA257419A99999913091F419A9999D93AA257419A9999991D091F419A99995939A25741CDCCCCCC32091F416666668637A25741000000004E091F41666666A635A25741CDCCCCCC6C091F416666668634A25741000000009A091F410000008033A25741000000009E091F410000008030A257419A999999A1091F41333333732EA2574133333333AD091F41000000A02CA2574133333333C1091F41333333532AA2574166666666FE091F41666666A625A257419A999999410A1F41000000C021A257419A999999710A1F419A9999991FA25741666666669A0A1F41333333531EA2574133333333A30A1F41666666C61DA2574133333333A50A1F419A9999D91CA257419A9999999D0A1F41333333F31AA25741CDCCCCCC8A0A1F41000000C018A25741CDCCCCCC7C0A1F410000008017A2574133333333710A1F41666666C616A25741CDCCCCCC560A1F413333337315A25741CDCCCCCC520A1F413333339314A257419A999999530A1F419A99991913A2574133333333550A1F416666668611A257419A999999570A1F41CDCCCC0C10A25741666666665A0A1F41000000A00EA25741CDCCCCCC5E0A1F41666666260DA2574133333333630A1F41CDCCCCCC0BA25741CDCCCCCC620A1F41000000E00AA25741CDCCCCCC5E0A1F41000000A009A25741CDCCCCCC5E0A1F41333333D308A257419A999999650A1F41CDCCCCAC07A2574133333333730A1F41666666E605A25741CDCCCCCC800A1F419A9999B904A257419A999999930A1F41CDCCCCAC03A257419A999999AB0A1F419A99999902A2574100000000C20A1F419A99993902A2574166666666D40A1F419A9999F901A2574100000000F00A1F4133333393FFA15741CDCCCCCCF20A1F41CDCCCC8CFEA1574133333333F10A1F419A999939FDA1574100000000F20A1F4100000040FCA15741CDCCCCCCF20A1F41CDCCCC4CFBA15741CDCCCCCCEA0A1F4166666626FAA157419A999999EB0A1F419A999919F9A1574133333333F70A1F41CDCCCCECF5A157419A999999FF0A1F4100000040F4A1574100000000080B1F41CDCCCC4CF3A15741666666661E0B1F4133333353F1A15741666666662A0B1F41CDCCCC4CEFA15741333333332F0B1F419A999999EDA15741CDCCCCCC2C0B1F4166666686ECA157419A999999270B1F41000000A0EAA157419A999999210B1F419A999939E8A15741CDCCCCCC1E0B1F41666666A6E6A157419A9999991D0B1F41CDCCCC2CE5A15741000000001E0B1F419A999939E3A157419A9999991F0B1F4133333313E1A157419A999999210B1F4166666686DFA15741CDCCCCCC260B1F4133333393DDA15741000000002E0B1F4166666626DCA15741CDCCCCCC3C0B1F4100000040DAA15741CDCCCCCC4C0B1F41CDCCCC2CD8A15741CDCCCCCC600B1F4100000000D6A15741CDCCCCCC6C0B1F41CDCCCC4CD4A15741CDCCCCCC7A0B1F419A999959D2A1574133333333890B1F4100000040D0A157419A9999999D0B1F4100000000CEA157419A999999B70B1F4133333373CBA15741CDCCCCCCD60B1F41666666C6C8A15741CDCCCCCCE60B1F419A999959C7A1574133333333F70B1F41333333B3C5A15741CDCCCCCC080C1F4133333393C3A1574133333333230C1F4166666626C0A157419A9999992B0C1F4166666646BFA15741CDCCCCCC520C1F4133333313BDA15741CDCCCCCC6A0C1F419A999919BCA157419A999999910C1F4166666606BBA1574100000000AC0C1F4166666686BAA1574100000000D60C1F4166666686B9A1574166666666F20C1F41000000E0B8A157419A9999991B0D1F41333333F3B7A1574100000000300D1F4133333393B7A15741CDCCCCCC480D1F4100000000B7A1574100000000660D1F4100000060B6A15741CDCCCCCC780D1F41CDCCCC0CB6A15741333333338D0D1F4133333393B5A1574166666666C40D1F419A999919B4A1574166666666DE0D1F419A999939B3A1574133333333EB0D1F41000000A0B2A15741CDCCCCCCF80D1F41333333D3B1A15741CDCCCCCC0C0E1F41333333B3B0A157419A999999190E1F4100000020B0A1574100000000320E1F4166666626AFA1574166666666500E1F419A999919AEA157419A999999710E1F41CDCCCC2CADA15741666666669E0E1F4166666626ACA1574166666666C80E1F419A999999ABA15741CDCCCCCCF00E1F4166666646ABA15741CDCCCCCC040F1F41333333F3AAA1574133333333290F1F41333333D3A9A1574166666666340F1F4100000060A9A157419A999999490F1F4100000000A9A15741CDCCCCCC5E0F1F419A999959A8A15741666666667C0F1F4166666626A7A15741333333339B0F1F419A999999A5A1574133333333A50F1F419A999979A4A1574133333333A70F1F41333333F3A3A1574166666666AA0F1F4100000080A2A157419A999999A90F1F41333333B3A1A15741CDCCCCCCAC0F1F41000000C0A0A157419A999999B10F1F41333333F39FA157419A999999B10F1F41CDCCCCAC9EA1574166666666B20F1F41333333139EA1574166666666BA0F1F41CDCCCC6C9DA157419A999999CD0F1F41666666E69BA1574100000000E00F1F41333333139AA1574133333333F30F1F41CDCCCCEC97A157413333333309101F41666666E695A157416666666620101F41000000E093A15741CDCCCCCC3E101F416666666691A15741000000005C101F41333333F38EA157410000000090101F41CDCCCCAC8AA1574133333333A5101F41CDCCCC4C88A1574166666666AA101F41CDCCCCCC86A15741CDCCCCCCAE101F410000006086A157419A999999BF101F416666660686A157419A999999C7101F41CDCCCCCC85A1574133333333CD101F41CDCCCC2C85A15741CDCCCCCCCE101F413333331384A15741CDCCCCCCD8101F419A9999B983A1574100000000E2101F419A9999F982A157419A999999E7101F41000000C082A1574100000000FC101F41CDCCCCAC82A15741000000000A111F419A99997982A157416666666644111F413333337380A15741CDCCCCCC58111F41666666667FA157419A9999996D111F41666666467EA157419A99999989111F419A9999197DA15741000000009E111F41666666467CA1574133333333B3111F419A9999797BA1574100000000C4111F41000000E07AA157419A999999EB111F419A99999979A157413333333311121F416666666678A15741000000001E121F416666662678A157410000000052121F41666666E677A15741000000007A121F41CDCCCC8C77A15741CDCCCCCC84121F419A99999976A15741333333338F121F419A9999F974A15741CDCCCCCC9A121F41CDCCCC0C73A1574133333333A3121F410000002072A157419A999999AD121F419A99995971A15741CDCCCCCCC2121F41333333B36FA1574166666666D2121F41666666466EA157419A999999DD121F41333333B36DA1574166666666EC121F41333333336DA157410000000002131F419A9999B96CA15741CDCCCCCC0E131F41000000806CA15741666666661C131F41CDCCCC0C6BA157419A99999925131F41666666E669A15741666666663E131F41333333B367A157416666666658131F410000006065A157413333333373131F41CDCCCCEC62A15741CDCCCCCC80131F41CDCCCC8C61A157416666666686131F41CDCCCCCC60A157413333333393131F41000000C060A1574166666666A4131F410000004060A1574100000000C6131F41333333D35EA1574166666666D6131F419A9999595EA1574133333333E5131F41333333335EA157410000000010141F41333333135EA157419A9999992F141F41CDCCCC8C5DA157410000000044141F41000000C05CA157419A9999995D141F41666666465BA15741CDCCCCCC7A141F416666668659A157410000000088141F410000000059A1574100000000AC141F413333331358A157419A999999C1141F413333335357A1574166666666DE141F41CDCCCC0C56A1574166666666FA141F41000000A054A157416666666616151F41CDCCCCCC52A157413333333323151F41000000A051A15741CDCCCCCC32151F410000002050A15741CDCCCCCC44151F41000000404EA157419A9999995D151F41666666864BA15741000000006C151F419A9999394AA157413333333377151F410000006049A157410000000082151F419A99999948A15741CDCCCCCC90151F41CDCCCCCC47A15741333333339D151F419A99993947A1574100000000AE151F41CDCCCCCC46A1574133333333CF151F410000006046A1574166666666C6151F41333333B345A1574166666666B8151F419A9999B944A15741CDCCCCCCAA151F41666666E643A15741666666669C151F419A9999F942A157410000000094151F419A99993942A157413333333389151F41333333F340A15741CDCCCCCC7E151F419A9999593FA157419A99999975151F41CDCCCC2C3DA157419A99999973151F41333333533CA157416666666674151F41333333F33BA15741CDCCCCCC8C151F41CDCCCC6C3AA157413333333393151F41000000A039A157410000000098151F419A99997938A157419A99999997151F413333331338A157413333333395151F41CDCCCCEC36A157419A99999991151F410000006035A157410000000088151F41666666A632A157413333333383151F419A9999D930A157410000000082151F41333333932FA157419A99999983151F419A9999992EA157413333333389151F41333333B32DA157410000000092151F41CDCCCCEC2CA15741CDCCCCCC92151F41CDCCCC4C2CA15741CDCCCCCC8E151F41333333332BA15741666666668E151F410000004029A15741000000008E151F410000008027A157410000000090151F410000004026A157413333333397151F416666662624A1574166666666A4151F413333339321A157419A999999AD151F419A9999D91FA15741CDCCCCCCB2151F41333333731DA15741CDCCCCCCB8151F41CDCCCC4C1CA1574100000000CE151F41666666C618A1574166666666DA151F41CDCCCC4C17A15741CDCCCCCCE8151F41CDCCCC6C15A157419A999999ED151F419A99999913A1574133333333EF151F41000000C011A1574166666666EE151F41CDCCCCEC0FA157419A999999E9151F41666666860EA1574100000000E4151F41000000400CA1574166666666E0151F41000000C009A1574100000000E0151F41000000A007A157419A999999E3151F41CDCCCCEC05A1574100000000EC151F413333331304A1574166666666FA151F416666662601A157413333333301161F410000000000A157419A99999907161F4100000000FFA05741666666660E161F4166666686FDA05741CDCCCCCC0E161F4100000020FDA05741333333330F161F4133333373FCA05741CDCCCCCCF2151F41666666C6FBA0574166666666D8151F419A999919FBA05741CDCCCCCCC4151F4133333373FAA057419A999999AD151F4166666666F9A057416666666696151F41CDCCCC4CF8A05741CDCCCCCC8E151F41CDCCCCECF7A05741CDCCCCCC6C151F419A999919F6A05741666666664A151F41333333D3F3A057410000000034151F41CDCCCCCCF1A057416666666626151F419A999979F0A057416666666612151F41CDCCCC2CEFA0574133333333FB141F41666666A6EDA0574133333333E7141F4166666686ECA057419A999999BB141F4100000040EAA05741666666668A141F41000000E0E7A057419A99999965141F41333333F3E5A057419A99999949141F419A999959E4A05741CDCCCCCC2E141F41666666A6E2A05741CDCCCCCC16141F41000000A0E0A05741666666660A141F419A999979DFA057419A99999901141F4133333393DEA05741CDCCCCCCFC131F419A999919DEA0574100000000F4131F41000000A0DDA057419A999999E1131F419A999939DDA05741CDCCCCCCD4131F4100000040DCA0574100000000BA131F41CDCCCC2CDBA05741CDCCCCCCA8131F41CDCCCCCCDAA05741333333338F131F41CDCCCC0CDAA057413333333381131F4100000060D9A05741333333336D131F41CDCCCCACD8A057416666666660131F4166666666D7A057416666666658131F419A9999F9D5A05741CDCCCCCC4E131F41666666C6D4A057416666666644131F41CDCCCCCCD3A05741333333333B131F4166666626D3A05741666666662C131F4100000060D2A05741CDCCCCCC20131F41CDCCCCECD1A057419A99999925131F41000000C0CFA057410000000024131F41666666A6CEA05741333333331F131F419A9999B9CDA057413333333311131F4166666686CCA057410000000002131F41CDCCCCCCCAA0574133333333F7121F4100000040C9A05741CDCCCCCCEE121F41CDCCCC8CC7A0574133333333C9121F41CDCCCC8CC6A057419A999999B5121F41CDCCCCACC5A05741666666669A121F4166666666C4A057410000000064121F4133333373C1A057413333333335121F41666666E6BEA05741CDCCCCCC00121F4133333333BCA0574133333333DB111F4100000040BAA0574166666666B4111F41CDCCCCECB7A057419A99999997111F419A9999D9B5A057413333333371111F41CDCCCCCCB2A05741333333335F111F4100000000B1A057419A9999994D111F419A9999F9AEA05741000000002E111F4133333333ABA05741CDCCCCCC1A111F41333333B3A8A057419A99999909111F41000000E0A5A057416666666600111F4133333313A4A05741CDCCCCCCF0101F4166666606A1A057419A999999EB101F41666666269FA0574133333333EB101F41CDCCCC2C9EA0574166666666F0101F419A9999199DA057410000000000111F41666666C69BA05741CDCCCCCC06111F419A9999999AA05741CDCCCCCC06111F410000004099A057410000000000111F41CDCCCC2C97A05741CDCCCCCCF4101F419A99997995A0574166666666D8101F41CDCCCC6C92A05741CDCCCCCCB4101F41333333D38EA057413333333397101F419A9999F98BA057413333333383101F413333339389A05741666666667A101F419A99995988A057410000000070101F41333333B386A05741CDCCCCCC5E101F41CDCCCCCC83A05741666666664E101F41000000A081A05741666666663E101F41333333B37FA05741666666662E101F419A9999197EA057413333333321101F41000000607CA05741333333330D101F41000000A079A05741CDCCCCCCF60F1F41000000E076A0574166666666EA0F1F410000004075A0574133333333E50F1F41000000A074A0574166666666DC0F1F41333333B373A05741CDCCCCCCD80F1F41CDCCCC0C73A05741CDCCCCCCD20F1F419A99997970A05741CDCCCCCCCC0F1F41CDCCCC6C6EA0574166666666C40F1F41000000606CA0574166666666B60F1F41666666066AA0574100000000A60F1F41CDCCCC0C68A05741666666668E0F1F41000000E065A05741666666666E0F1F419A99993963A05741666666664C0F1F41333333B360A05741CDCCCCCC2A0F1F419A9999795EA0574166666666140F1F41000000C05CA05741CDCCCCCCFA0E1F41CDCCCC2C5AA0574166666666E20E1F413333339357A057419A999999CF0E1F419A99993955A0574166666666C20E1F410000000053A0574133333333BD0E1F419A99997951A05741CDCCCCCCBC0E1F41CDCCCCEC4FA0574100000000C80E1F41666666064EA0574133333333A90D1F416666660641A05741666666664A0D1F41CDCCCC0C3CA0574100000000040B1F41000000A024A0574100000000780A1F413333333322A057413333333361051F41000000E022A057419A99999981021F41000000401FA057416666666642011F413333339320A057419A9999990D001F413333333327A0574166666666BEFE1E41000000A025A057413333333307FC1E41666666C61DA057410000000004F91E41666666061CA057413333333389F71E419A99997922A057419A99999959F41E41000000203DA057419A9999993FF21E41000000A047A057410000000078F11E41000000C047A05741CDCCCCCC5AEF1E41000000C05AA057410000000084ED1E410000002075A057419A99999923EC1E419A99999988A05741666666663EEB1E41CDCCCCAC8DA0574166666666AAEA1E419A99997999A05741CDCCCCCC74EA1E41000000E0A2A0574133333333EFE91E41000000A0ABA0574100000000A0E91E41CDCCCCACB0A057419A99999995E81E41000000E0A4A057410000000074E71E410000000093A05741000000004AE71E41CDCCCCEC90A05741000000001CE71E419A9999F98DA0574133333333E7E61E41666666268BA05741CDCCCCCCBAE61E419A9999D987A0574166666666C0E51E41000000607BA05741333333333DE51E419A99991972A0574100000000E4E41E419A9999F967A057419A999999B1E41E419A9999B967A057413333333383E41E416666660668A057410000000050E41E413333335369A057419A99999919E41E419A9999196CA0574133333333AFE31E413333337372A05741CDCCCCCC50E31E416666662678A057419A9999990DE31E41CDCCCCAC7BA0574100000000D2E21E41000000C07EA05741000000009EE21E413333335381A057410000000088E21E41666666C683A05741333333336DE21E410000008085A05741CDCCCCCC52E21E416666662686A05741666666663AE21E416666666686A05741000000001CE21E419A99995985A05741CDCCCCCCFCE11E410000002083A0574100000000D2E11E419A9999D980A057419A9999998BE11E41666666C67DA05741666666663EE11E419A9999B97AA057419A999999E9E01E419A99999978A057416666666698E01E41CDCCCC0C77A05741CDCCCCCCFEDF1E41666666667AA057413333333305DF1E41666666867AA057413333333315DE1E41000000E078A057419A99999933DD1E416666666671A05741CDCCCCCC74DC1E419A9999796AA0574133333333C7DB1E416666664676A057419A999999C1DA1E41CDCCCC6C89A0574166666666E4D81E41666666E6ACA057410000000094D71E4166666606C6A0574100000000CED61E41000000E0D2A05741CDCCCCCC60D51E4100000020EAA057419A999999F3D41E4133333373EFA057419A99999963D41E41333333D3F6A057410000000000D41E4133333373FCA0574166666666DAD31E41333333730BA157419A999999CDD31E419A9999D918A157416666666688D31E41333333731EA15741CDCCCCCC46D41E41666666E623A15741000000001ED51E41CDCCCCEC29A1574166666666D2D61E41CDCCCC6C37A157410000000028D81E41000000C044A157416666666626D91E41666666464CA157419A99999985D91E41000000405EA157410000000048D81E410000004057A157416666666610D71E41333333335AA157419A999999DBD61E41000000205CA15741333333339BD61E41666666865EA15741666666667AD61E41333333F35FA15741CDCCCCCC52D61E410000006062A157416666666620D61E413333335364A1574166666666E8D51E41CDCCCCEC65A1574133333333B5D51E41CDCCCC4C67A157419A9999997BD51E419A9999F968A157419A99999947D51E41000000406BA157410000000014D51E41CDCCCCEC6CA15741CDCCCCCCE4D41E419A9999196EA1574133333333B1D41E41333333536FA157413333333383D41E410000006071A15741CDCCCCCC60D41E41000000A073A157419A9999993DD41E41CDCCCC0C76A15741CDCCCCCC1ED41E419A99993978A1574133333333EFD31E41CDCCCCCC79A15741CDCCCCCCB6D31E41CDCCCCCC7AA157410000000082D31E41CDCCCC0C7CA15741CDCCCCCC50D31E419A9999197DA157413333333321D31E41666666867EA1574133333333EBD21E413333331380A1574100000000AED21E41000000A080A157413333333375D21E41333333D381A15741CDCCCCCC32D21E41666666E683A157416666666602D21E413333337386A1574166666666DAD11E410000008088A157419A999999A7D11E41000000808AA15741333333337BD11E41333333B38BA15741333333334FD11E41000000208DA15741666666662ED11E41000000808EA15741CDCCCCCC0ED11E41666666E690A1574133333333D7D01E41000000C092A15741666666669CD01E419A9999B994A15741CDCCCCCC6AD01E410000002096A15741CDCCCCCC3AD01E41666666A696A157419A9999990BD01E416666668696A1574166666666E4CF1E41CDCCCC0C97A1574166666666C6CF1E419A9999D997A157413333333397CF1E41000000E098A157416666666660CF1E413333333399A157413333333321CF1E41CDCCCCCC99A1574100000000E8CE1E41CDCCCC6C9AA157419A999999A7CE1E41000000C09BA157410000000068CE1E41666666C69CA15741000000002CCE1E41333333F39CA1574166666666F4CD1E41000000C09CA157419A999999B3CD1E41000000C09BA15741CDCCCCCC78CD1E41CDCCCC6C9AA157419A9999993DCD1E410000008099A157410000000004CD1E416666666699A1574166666666CACC1E41666666269AA15741666666669ACC1E41000000E09AA157410000000068CC1E419A9999B99AA157410000000042CC1E41666666869AA15741666666661ECC1E41333333939AA1574166666666F6CB1E419A9999F999A1574133333333F7CB1E419A9999199AA15741CDCCCCCCFCCB1E41CDCCCC0CC2A1574166666666D8CB1E4166666646DCA15741CDCCCCCCB6CB1E41000000800EA2574100000000BECB1E41CDCCCC2C44A257416666666690CB1E41000000E091A25741000000005ACB1E41CDCCCC6CA1A25741	01060000206A08000001000000010300000001000000DE000000000000005ACB1E41CDCCCC6CA1A25741000000000CCC1E4166666646ADA257419A99999985CC1E41333333B3B9A25741333333332DCE1E41333333B3D8A257416666666692CE1E41000000E0E2A25741000000000CD11E419A9999F91BA3574166666666FCD11E410000008017A35741CDCCCCCC0ED31E41000000000DA35741666666664AD31E41333333F30BA3574100000000CED31E41000000E012A35741CDCCCCCC76D41E419A99991915A357419A9999991FD51E410000008011A357419A99999993D51E41CDCCCCCC11A357410000000056D61E41CDCCCC4C15A35741CDCCCCCCC4D61E416666664615A3574100000000FCD61E416666664610A357410000000068D71E419A9999190EA3574133333333EFD71E41333333D30DA357413333333361D81E41666666E611A357410000000094D91E41333333531FA3574133333333EDD91E413333335324A35741333333335BDA1E41CDCCCC8C24A35741000000002CDB1E410000004021A357419A99999931DC1E41666666A618A3574133333333BFDC1E416666662613A35741666666669EDE1E41666666C6FAA25741000000002ADF1E4100000060F4A257413333333379DF1E4166666666F2A25741000000000AE01E4166666606F2A257410000000056E01E4100000000EEA25741666666665CE01E41666666A6E7A25741CDCCCCCCACE11E41333333B3DFA257419A999999EFE11E4100000060DDA25741000000005EE21E4100000020D5A25741CDCCCCCC9AE21E4166666666D3A257419A999999FFE21E4133333313D4A25741CDCCCCCC44E31E419A999939D0A25741CDCCCCCC02E41E41CDCCCC0CCDA25741CDCCCCCC52E41E41000000E0C8A25741CDCCCCCCE6E41E41CDCCCC0CCBA257419A99999997E51E4133333333C5A257413333333327E61E41000000E0BBA2574166666666E0E61E4100000000B9A257419A99999907E81E41CDCCCCCCA7A25741CDCCCCCC8AE81E4133333313A5A25741333333334FE91E419A999959A5A257413333333323EA1E41666666E6A3A257419A9999990DEB1E41333333F39EA25741CDCCCCCC7EEB1E41333333B3A0A257413333333311EC1E41000000E099A257410000000042ED1E419A99995998A2574100000000BEED1E41000000C09AA25741CDCCCCCC1EEF1E41CDCCCC0CA9A25741CDCCCCCCB0EF1E4133333393ABA257413333333345F01E4100000060AAA2574100000000AEF01E41666666A6A7A257410000000030F11E41CDCCCC0CA7A257419A9999999FF11E419A999959A9A25741CDCCCCCC28F21E4100000080A9A25741CDCCCCCC5AF31E41CDCCCC8CA4A257419A99999939F41E419A999979A3A25741000000007EF51E41000000E0A3A25741CDCCCCCC02F61E41333333D39FA25741000000009AF61E413333335399A257410000000064F71E410000008097A257419A99999903F81E419A99995998A2574100000000FCF81E41CDCCCCEC93A257419A9999993DF91E413333337391A25741000000006CFA1E419A9999198AA257416666666620FB1E419A99991988A257410000000032FC1E41CDCCCCAC88A25741CDCCCCCC66FD1E41666666468CA25741CDCCCCCCA6FE1E419A9999F98CA257416666666630FF1E419A99995988A257419A999999ABFF1E416666660686A25741CDCCCCCC80001F41333333537EA25741CDCCCCCC42011F419A9999597CA2574133333333AD011F41000000C079A25741CDCCCCCCEA021F41333333B377A257410000000078031F41333333B375A25741000000003E041F410000002076A2574100000000A4051F41333333D37BA2574166666666B4071F419A9999F97DA257413333333365081F416666662680A2574100000000B2081F419A99991975A2574100000000BA081F41333333B36EA257419A999999A3081F413333331361A257419A999999F3081F41000000804BA257419A9999991D091F419A99995939A25741000000009A091F410000008033A2574133333333C1091F41333333532AA257419A999999410A1F41000000C021A25741666666669A0A1F41333333531EA257419A9999999D0A1F41333333F31AA25741CDCCCCCC520A1F413333339314A25741CDCCCCCC5E0A1F41333333D308A25741CDCCCCCC800A1F419A9999B904A2574100000000F00A1F4133333393FFA157419A999999EB0A1F419A999919F9A15741333333332F0B1F419A999999EDA157419A9999991D0B1F41CDCCCC2CE5A15741000000002E0B1F4166666626DCA1574133333333890B1F4100000040D0A157419A9999992B0C1F4166666646BFA15741CDCCCCCC6A0C1F419A999919BCA15741333333338D0D1F4133333393B5A1574100000000320E1F4166666626AFA15741CDCCCCCC5E0F1F419A999959A8A1574133333333A50F1F419A999979A4A1574166666666B20F1F41333333139EA157410000000090101F41CDCCCCAC8AA15741CDCCCCCCAE101F410000006086A1574100000000C4111F41000000E07AA15741000000007A121F41CDCCCC8C77A1574166666666D2121F41666666466EA15741CDCCCCCC0E131F41000000806CA157416666666686131F41CDCCCCCC60A157410000000044141F41000000C05CA157416666666616151F41CDCCCCCC52A15741333333339D151F419A99993947A1574133333333CF151F410000006046A157413333333389151F41333333F340A157416666666674151F41333333F33BA157410000000098151F419A99997938A157413333333383151F419A9999D930A15741000000008E151F410000008027A15741CDCCCCCCB2151F41333333731DA15741CDCCCCCCE8151F41CDCCCC6C15A157419A999999E3151F41CDCCCCEC05A15741333333330F161F4133333373FCA05741CDCCCCCC6C151F419A999919F6A0574133333333FB141F41666666A6EDA05741CDCCCCCC2E141F41666666A6E2A05741CDCCCCCCFC131F419A999919DEA05741333333336D131F41CDCCCCACD8A05741CDCCCCCC20131F41CDCCCCECD1A05741CDCCCCCCEE121F41CDCCCC8CC7A05741666666669A121F4166666666C4A0574133333333DB111F4100000040BAA057413333333371111F41CDCCCCCCB2A057419A99999909111F41000000E0A5A0574133333333EB101F41CDCCCC2C9EA057410000000000111F41CDCCCC2C97A057413333333397101F419A9999F98BA05741CDCCCCCCD80F1F41CDCCCC0C73A0574100000000A60F1F41CDCCCC0C68A0574166666666140F1F41000000C05CA0574166666666C20E1F410000000053A0574100000000C80E1F41666666064EA05741666666664A0D1F41CDCCCC0C3CA0574100000000040B1F41000000A024A0574100000000780A1F413333333322A057413333333361051F41000000E022A057419A99999981021F41000000401FA057416666666642011F413333339320A057419A9999990D001F413333333327A0574166666666BEFE1E41000000A025A057413333333307FC1E41666666C61DA057410000000004F91E41666666061CA057413333333389F71E419A99997922A057419A99999959F41E41000000203DA057419A9999993FF21E41000000A047A057410000000078F11E41000000C047A05741CDCCCCCC5AEF1E41000000C05AA057419A99999923EC1E419A99999988A05741666666663EEB1E41CDCCCCAC8DA0574166666666AAEA1E419A99997999A05741CDCCCCCC74EA1E41000000E0A2A0574100000000A0E91E41CDCCCCACB0A057419A99999995E81E41000000E0A4A05741CDCCCCCCBAE61E419A9999D987A0574166666666C0E51E41000000607BA05741333333333DE51E419A99991972A0574100000000E4E41E419A9999F967A057413333333383E41E416666660668A057419A99999919E41E419A9999196CA05741CDCCCCCC50E31E416666662678A05741666666663AE21E416666666686A05741666666663EE11E419A9999B97AA057416666666698E01E41CDCCCC0C77A05741CDCCCCCCFEDF1E41666666667AA057413333333305DF1E41666666867AA057413333333315DE1E41000000E078A05741CDCCCCCC74DC1E419A9999796AA0574133333333C7DB1E416666664676A057419A999999C1DA1E41CDCCCC6C89A057410000000094D71E4166666606C6A05741CDCCCCCC60D51E4100000020EAA057410000000000D41E4133333373FCA0574166666666DAD31E41333333730BA157419A999999CDD31E419A9999D918A157416666666688D31E41333333731EA15741000000001ED51E41CDCCCCEC29A1574166666666D2D61E41CDCCCC6C37A157410000000028D81E41000000C044A157416666666626D91E41666666464CA157419A99999985D91E41000000405EA157410000000048D81E410000004057A157416666666610D71E41333333335AA157416666666620D61E413333335364A157419A9999997BD51E419A9999F968A157413333333383D41E410000006071A15741CDCCCCCC1ED41E419A99993978A1574133333333EBD21E413333331380A15741CDCCCCCC32D21E41666666E683A1574166666666DAD11E410000008088A15741333333334FD11E41000000208DA15741CDCCCCCC0ED11E41666666E690A15741CDCCCCCC6AD01E410000002096A1574100000000E8CE1E41CDCCCC6C9AA157410000000068CE1E41666666C69CA1574166666666F4CD1E41000000C09CA157419A9999993DCD1E410000008099A15741666666669ACC1E41000000E09AA1574133333333F7CB1E419A9999199AA15741CDCCCCCCFCCB1E41CDCCCC0CC2A1574166666666D8CB1E4166666646DCA15741CDCCCCCCB6CB1E41000000800EA2574100000000BECB1E41CDCCCC2C44A257416666666690CB1E41000000E091A25741000000005ACB1E41CDCCCC6CA1A25741000000005ACB1E41CDCCCC6CA1A25741	01010000206A080000B81557A3D3ED1E419A999959A0A15741	310190000	Z	Artigue	3101900	31019	31	76	10
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	01010000206A080000ACF1D6646AD41F41343333935BB55741	310200000	Z	Aspet	3102000	31020	31	76	26
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	01010000206A080000D94781454D5F1F41CCCCCCDCC0BB5741	310210000	Z	Aspret-Sarrat	3102100	31021	31	76	4
01060000206A08000001000000010300000001000000D20000009A999999D77C214166666606F1FB57419A999999E37C21419A9999B9F1FB574166666666F67C2141000000C0F2FB5741CDCCCCCC807D21419A999919FBFB57419A9999998D7D2141CDCCCC4CFBFB57419A999999107E21413333333302FC574166666666AD7E2141000000600AFC5741CDCCCCCCAF7E2141CDCCCC8C09FC574133333333BB7E2141000000200AFC574166666666EB7E2141666666E60CFC574133333333E27E2141666666A60FFC5741000000004B7F21419A99999914FC57419A9999995A7F21416666666615FC5741000000007D7F21410000000016FC574133333333817F21410000006016FC5741666666669C7F2141000000A017FC5741CDCCCCCCBD802141CDCCCCCC26FC5741CDCCCCCCE78021419A9999D928FC574133333333E78021419A99999929FC57416666666643822141CDCCCCAC3FFC57413333333352822141CDCCCC0C3CFC5741000000007C8221419A9999793EFC57416666666691822141333333B33FFC57419A999999DB8221410000000044FC5741CDCCCCCC0C832141333333D346FC57416666666653832141666666E64AFC5741CDCCCCCC70832141333333934CFC5741333333338A832141CDCCCC0C4EFC57419A99999993832141333333934EFC57416666666693832141000000604DFC574166666666D08321419A99999950FC574166666666D1832141666666A650FC574133333333D4832141CDCCCCCC50FC57419A999999ED8321419A99991952FC574100000000C5832141CDCCCC0C5BFC574166666666C7832141CDCCCC8C5BFC5741CDCCCCCC89832141CDCCCC6C68FC57419A9999990E8321413333339380FC5741CDCCCCCC148321419A9999D980FC57419A99999922832141CDCCCC6C81FC57410000000045832141CDCCCCEC82FC5741CDCCCCCC5A832141666666E683FC57419A9999996C832141666666E684FC57419A9999999C8321410000000088FC574100000000A7832141CDCCCCAC88FC574100000000808421419A99997997FC57410000000049852141000000A0A5FC5741666666666A852141CDCCCCECA7FC574166666666758521419A9999F9A8FC5741000000007C85214133333313AAFC5741666666668A8521419A999999A8FC5741CDCCCCCCA8852141CDCCCCCCA4FC57419A999999BF852141666666C6A2FC574100000000D885214166666626A1FC5741CDCCCCCCF0852141CDCCCC0CA0FC5741CDCCCCCC1C862141333333F39CFC5741666666662D862141CDCCCC2C9BFC5741333333333D8621410000008098FC57419A99999951862141CDCCCCAC93FC57419A9999995A862141666666268FFC5741CDCCCCCC59862141000000E08CFC5741333333334A862141CDCCCC4C87FC57419A999999268621419A9999B97EFC5741CDCCCCCC22862141666666C67CFC574100000000238621419A9999997AFC57419A999999268621413333339378FC57416666666630862141333333D376FC57419A9999996C862141CDCCCC6C70FC57419A99999981862141333333536FFC5741CDCCCCCCAE862141CDCCCCEC6DFC5741CDCCCCCCC0862141666666A66DFC574100000000F78621419A9999D96DFC57410000000007872141333333136DFC57419A9999991E8721419A9999196AFC5741CDCCCCCC4B8721419A9999D965FC5741000000004E872141CDCCCCCC64FC5741666666664F8721419A99993964FC5741000000004E8721410000000063FC5741CDCCCCCC3F8721419A9999D960FC574166666666358721410000004060FC5741666666662A872141666666865FFC574166666666F48621419A99993961FC574100000000BB8621413333335361FC574100000000A5862141000000E060FC5741666666669B8621419A99991960FC57410000000097862141CDCCCC2C5FFC5741CDCCCCCC928621410000004054FC57410000000091862141000000C051FC57419A9999998C8621419A99993950FC57413333333375862141000000804BFC57419A9999996B862141000000404AFC5741CDCCCCCC598621419A99997949FC57419A99999945862141666666264AFC57416666666632862141333333134CFC5741CDCCCCCC2C862141000000204DFC5741CDCCCCCC20862141CDCCCCEC55FC5741CDCCCCCC158621416666662658FC574133333333068621416666668658FC574166666666FD8521410000002058FC5741CDCCCCCCEF8521410000000057FC574166666666D5852141666666A653FC57419A999999BF8521419A99993950FC57419A999999A08521413333339349FC5741CDCCCCCC90852141333333B344FC57419A99999986852141000000C03CFC574133333333698521410000000035FC5741666666662F852141000000602DFC5741CDCCCCCC18852141000000602CFC5741CDCCCCCC05852141000000802BFC574133333333F88421419A9999F92AFC5741CDCCCCCC08852141000000E024FC5741CDCCCCCC1A852141000000C01DFC5741CDCCCCCC1D852141666666C61BFC57419A999999208521413333337319FC5741CDCCCCCC21852141000000C016FC574133333333208521416666662613FC57419A99999919852141666666E60FFC5741CDCCCCCC17852141666666660CFC574100000000188521413333339305FC57416666666619852141CDCCCC8C00FC5741666666661A852141000000E0FAFB5741CDCCCCCC1A85214100000000F6FB5741333333331C852141000000A0F0FB5741333333331E85214133333313ECFB5741333333332085214133333353E7FB57416666666621852141CDCCCCCCE2FB5741333333332785214133333333DEFB57416666666630852141CDCCCC8CD8FB57419A99999937852141CDCCCC6CD5FB5741333333333D852141CDCCCCCCD2FB57416666666644852141CDCCCC6CCFFB5741333333334C8521419A999959CBFB57419A9999995085214133333373C8FB57416666666655852141CDCCCCECC3FB5741CDCCCCCC57852141000000C0BFFB57419A99999957852141333333B3BCFB574133333333578521419A999939B9FB5741333333335785214166666686B5FB5741666666665985214100000020B2FB5741333333335F852141CDCCCCCCAEFB5741666666666A85214100000080AAFB57416666666679852141CDCCCC2CA5FB57419A9999998385214100000020A1FB5741666666668B852141000000609DFB57419A999999958521410000004097FB5741333333339E852141333333B391FB574100000000A48521419A9999398DFB5741CDCCCCCCA8852141000000E089FB574133333333B18521410000002086FB57419A999999BC8521419A9999D982FB5741CDCCCCCCC8852141CDCCCCAC7FFB5741CDCCCCCCD6852141666666E67CFB574133333333E68521419A9999597AFB5741CDCCCCCCF8852141666666A677FB57419A999999028621413333339375FB57419A9999990B8621410000008073FB5741CDCCCCCC1A862141CDCCCC4C71FB5741CDCCCCCC2F862141666666C66EFB57410000000013862141666666866DFB57413333333393852141CDCCCCAC6AFB5741CDCCCCCC4B8521419A99995967FB574133333333068521413333331363FB5741CDCCCCCCEF8421419A9999195BFB5741333333332F842141CDCCCCCC4EFB5741333333332A842141333333F34EFB57419A99999924842141CDCCCC0C4FFB5741CDCCCCCC1D842141333333F34EFB57416666666616842141333333B34EFB574166666666D3832141000000C04BFB5741000000006A8321419A9999D946FB574133333333FE8221419A9999D941FB57419A999999C0822141333333333FFB5741CDCCCCCC93822141666666463DFB5741CDCCCCCC4D822141CDCCCC2C3AFB5741333333333F8221413333335339FB5741333333331D8221413333337337FB57419A999999D48121410000002034FB57410000000038812141333333132DFB574166666666CB8021410000008028FB574166666666A2802141CDCCCC4C41FB5741333333337F7F21419A9999B933FB57419A999999337F21413333337330FB574100000000267F2141CDCCCCEC2FFB57419A9999990B7F2141000000003CFB57419A999999CD7E21419A99993959FB5741CDCCCCCCCC7E2141CDCCCC8C59FB5741CDCCCCCCC67E21419A9999595CFB5741CDCCCCCCC37E2141333333B35DFB574133333333C07E2141000000605FFB57419A999999AE7E21419A99995965FB57419A9999998D7E2141000000C070FB5741CDCCCCCC7A7E21416666664677FB574100000000577E21413333335383FB5741000000004D7E21416666662686FB57419A999999427E21410000002089FB574166666666217E21419A9999B991FB5741CDCCCCCCFC7D2141000000809BFB574133333333F17D2141CDCCCC8C9EFB57419A999999EA7D214166666646A0FB574166666666D07D21419A999959A7FB57419A999999C47D2141CDCCCC8CAAFB574100000000BA7D2141333333B3ADFB5741333333339A7D21419A999919B7FB574133333333847D2141000000A0BDFB574133333333607D21419A999959C8FB5741000000005A7D214100000020CAFB5741000000004E7D21419A9999B9CDFB5741CDCCCCCC157D21419A999979DEFB57419A999999FA7C2141000000A0E6FB57419A999999D77C214166666606F1FB5741	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	01010000206A0800008EDCC8B907812141333333B3E9FB5741	310220101	H	L'Hers	3102201	31022	31	76	1
01060000206A08000001000000010300000001000000F0000000333333339E7021419A99991929FD574133333333B8702141666666062BFD574133333333A57121419A9999993CFD5741CDCCCCCC327221410000002047FD57419A99999939722141CDCCCC0C45FD57416666666654722141333333B33CFD57410000000064722141000000C038FD57413333333389722141666666E630FD5741CDCCCCCC90722141333333532FFD574100000000C37221410000006024FD574166666666F57221419A9999F919FD57413333333316732141CDCCCC4C13FD5741CDCCCCCC1F7321416666666611FD5741666666663A732141666666460BFD5741333333334F732141CDCCCCCC06FD574100000000647321419A9999B902FD5741666666668173214166666606FDFC57419A999999A3732141333333F3F6FC5741000000000474214133333373E6FC5741000000004474214100000080DBFC57419A999999717421419A9999B9D3FC574166666666DC74214166666606C2FC57413333333322752141000000A0B6FC5741000000005175214100000000BAFC57410000000082752141CDCCCC8CBDFC574166666666B0752141666666E6C0FC5741000000000B76214133333373C7FC57419A999999987621419A999959D2FC5741CDCCCCCC7C76214100000080DAFC57419A9999990C77214133333373E4FC5741333333338E77214166666666EDFC5741000000008F77214100000040EBFC574166666666937721419A999999E9FC5741666666669C77214133333333E7FC574133333333C7772141333333F3DEFC574133333333E7772141CDCCCCCCD8FC5741CDCCCCCC34782141CDCCCCACC9FC574100000000DB7821419A9999B9A3FC574166666666DD78214166666626A3FC5741333333330D7921413333333398FC57410000000034792141000000408FFC5741CDCCCCCC40792141666666E68CFC57419A9999996A792141CDCCCC2C85FC574100000000F0792141000000E08FFC574133333333B27A214100000000A0FC574133333333C67A2141333333D398FC574166666666D87A21410000006091FC574100000000F87A21419A9999D985FC574133333333097B2141666666C67FFC574100000000477B2141666666C66BFC5741333333337C7B21419A9999995AFC5741CDCCCCCCA07B2141333333F34EFC5741CDCCCCCC057C2141000000A02FFC574133333333327C21413333331322FC57419A9999994A7C21419A9999B91AFC57419A999999717C2141666666060FFC5741CDCCCCCC8B7C21413333335307FC574133333333A37C2141CDCCCC6C00FC574133333333BA7C2141333333B3F9FB57419A999999D77C214166666606F1FB57419A999999FA7C2141000000A0E6FB5741CDCCCCCC157D21419A999979DEFB5741000000004E7D21419A9999B9CDFB5741000000005A7D214100000020CAFB574133333333607D21419A999959C8FB574133333333847D2141000000A0BDFB5741333333339A7D21419A999919B7FB574100000000BA7D2141333333B3ADFB57419A999999C47D2141CDCCCC8CAAFB574166666666D07D21419A999959A7FB57419A999999EA7D214166666646A0FB574133333333F17D2141CDCCCC8C9EFB5741CDCCCCCCFC7D2141000000809BFB574166666666217E21419A9999B991FB57419A999999427E21410000002089FB5741000000004D7E21416666662686FB574100000000577E21413333335383FB5741CDCCCCCC7A7E21416666664677FB57419A9999998D7E2141000000C070FB57419A999999AE7E21419A99995965FB574133333333C07E2141000000605FFB5741CDCCCCCCC37E2141333333B35DFB5741CDCCCCCCC67E21419A9999595CFB5741CDCCCCCCCC7E2141CDCCCC8C59FB57419A999999CD7E21419A99993959FB57419A9999990B7F2141000000003CFB574100000000267F2141CDCCCCEC2FFB5741CDCCCCCC497F2141333333931DFB574133333333927F2141CDCCCC0CF4FA574100000000A67F21419A9999B9E8FA5741CDCCCCCCB27F2141666666A6E1FA574133333333F67F214166666626BBFA5741CDCCCCCC0180214133333333B4FA5741666666660880214133333333AFFA57419A9999991080214133333313ACFA57410000000015802141333333B3A8FA5741CDCCCCCC1980214100000020A6FA57410000000021802141CDCCCCACA0FA57413333333325802141000000609CFA5741666666662E802141666666868BFA57419A99999931802141CDCCCCEC84FA574166666666428021416666668663FA574166666666438021410000002061FA57413333333345802141CDCCCC2C5DFA57419A999999458021419A9999795CFA57419A9999994A8021416666664652FA57419A99999954802141666666663EFA5741CDCCCCCC598021419A99997933FA57419A9999995A802141CDCCCCEC31FA5741CDCCCCCC0F802141000000003EFA5741CDCCCCCC04802141666666A63EFA574166666666BA7F2141CDCCCC0C44FA5741666666669E7F2141CDCCCC4C46FA574166666666697F2141000000E048FA5741000000005B7F2141CDCCCCEC49FA57419A999999477F2141CDCCCCAC4CFA574133333333307F2141CDCCCCEC4EFA5741000000001C7F21416666666651FA5741333333330E7F2141666666E652FA5741333333330A7F21410000002053FA57419A999999007F21419A9999B953FA574166666666F27E21413333331354FA574133333333907E2141CDCCCC4C54FA574166666666EF7D2141CDCCCCEC55FA57419A999999EA7D2141333333B356FA574166666666E57D2141CDCCCC0C58FA574100000000CD7D2141CDCCCC8C5CFA5741666666665E7D21419A9999D972FA574133333333527D2141CDCCCCEC74FA57419A999999407D21413333333376FA5741CDCCCCCCA47C2141CDCCCCCC7EFA574166666666967C2141CDCCCCAC7FFA5741000000008E7C2141CDCCCC6C80FA5741333333336B7C21413333333382FA57419A999999317C21413333333385FA57419A999999D57B2141000000008AFA574133333333C77B2141000000C08AFA574133333333987B2141666666668DFA574166666666F67A2141CDCCCC4C85FA5741000000000D7A2141CDCCCC0C9CFA574133333333EE792141CDCCCC0C9FFA5741CDCCCCCCD57921419A9999D99FFA574133333333B679214133333393A0FA5741CDCCCCCC74792141000000E0A0FA574133333333E678214166666686A2FA5741CDCCCCCCBE782141333333D3A2FA574133333333AB782141333333B3A2FA5741000000006378214100000020A1FA5741CDCCCCCC2C782141000000A09FFA57416666666603782141666666669EFA574133333333B87721419A9999B99CFA5741000000007E772141666666E69AFA5741333333331C772141333333D398FA574100000000B4762141000000E0ADFA57419A999999B576214133333393B2FA574100000000BD762141333333F3C9FA574166666666C176214133333373D7FA574166666666C4762141333333B3E0FA574166666666B3762141333333B3F9FA574100000000AD7621416666660602FB574166666666AA7621410000000004FB57419A999999A57621416666662605FB5741000000009C7621416666668607FB574100000000917621419A9999390AFB5741CDCCCCCC597621413333339315FB574100000000517621410000000017FB574100000000127621413333331320FB574166666666E37521413333337325FB574133333333B47521413333337329FB57419A99999983752141666666E62DFB5741000000004A7521416666660632FB574100000000237521413333331334FB5741CDCCCCCCFD7421416666664635FB5741CDCCCCCCDC7421419A99999936FB574166666666B57421413333333338FB5741000000008B742141CDCCCCEC39FB5741000000006F742141CDCCCC0C3BFB5741CDCCCCCC5D7421419A9999793BFB57419A99999946742141666666063CFB574166666666437421419A9999193CFB57419A9999991F742141333333F33CFB574100000000197421419A9999193DFB5741666666660E742141000000603DFB574100000000E7732141666666463EFB57419A999999D77321410000000042FB5741CDCCCCCCC37321413333335347FB57419A999999B8732141333333334BFB5741CDCCCCCCAA7321416666666650FB574166666666A07321419A99997955FB574100000000997321416666660659FB5741CDCCCCCC88732141666666E662FB5741CDCCCCCC7B732141000000A06AFB57416666666664732141666666C678FB574100000000387321410000002094FB57419A99999914732141666666C6A9FB5741CDCCCCCCFD722141CDCCCC8CB7FB574100000000EF7221419A999959C0FB574100000000CD72214133333333D5FB574100000000B07221419A9999B9E6FB574100000000BF72214133333393E7FB574133333333D1722141CDCCCCAC03FC574133333333AE722141CDCCCCEC0FFC5741333333339F7221416666660615FC5741000000007B722141333333B321FC57410000000027722141000000E03EFC5741CDCCCCCC1B7221419A9999B940FC574166666666147221410000002045FC5741000000006B7221419A9999994CFC574166666666E0722141CDCCCC6C55FC5741CDCCCCCCF8722141666666C657FC574166666666F57221419A9999F95DFC574100000000EB722141333333936AFC574133333333EB722141CDCCCC4C70FC574100000000E97221419A9999F974FC574166666666E5722141666666E677FC5741CDCCCCCCDF722141000000807BFC574133333333D7722141666666A67FFC57419A999999AE722141CDCCCC4C96FC5741000000009872214100000080A3FC5741666666668C72214166666666ACFC57419A9999998A72214166666626AEFC5741666666668772214166666666B1FC5741CDCCCCCC807221419A9999B9BBFC5741CDCCCCCC7D722141CDCCCCECBDFC5741CDCCCCCC77722141CDCCCCACC0FC57413333333363722141CDCCCC4CC7FC57413333333358722141CDCCCCECC9FC57416666666617722141666666C6D5FC57419A999999FB712141666666C6DAFC574100000000C471214100000080E5FC5741000000008071214100000060F3FC57410000000050712141000000A0FDFC5741CDCCCCCC347121419A99997903FD574133333333F6702141CDCCCC0C10FD574133333333E17021416666660614FD574100000000D77021416666666615FD574100000000BB702141CDCCCCAC17FD5741CDCCCCCCB3702141666666261CFD574133333333A67021419A99995924FD5741333333339E7021419A99991929FD5741	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	01010000206A080000CE7101914378214166666696BAFB5741	310220102	H	Les Violettes	3102201	31022	31	76	3
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	01060000206A0800000100000001030000000100000076010000CDCCCCCC7CA91F410000004038CA57419A999999A5A91F41CDCCCC8C48CA5741CDCCCCCCCEA91F41CDCCCCAC4CCA574166666666F2AA1F416666664659CA5741666666665CAB1F41000000405FCA57413333333357AC1F413333333374CA574100000000DEAC1F41666666867BCA57419A9999993BAD1F419A9999B983CA574166666666EEAD1F41000000A090CA57410000000004AF1F41666666A6ACCA5741000000005CAF1F4100000060ADCA57419A999999C1AF1F41CDCCCCACA9CA57419A9999998BB01F4166666686A4CA5741333333335FB21F41CDCCCC6CA1CA57410000000092B21F419A9999D99FCA574100000000C0B21F410000004099CA574133333333BBB31F419A9999B98CCA5741CDCCCCCC9CB51F41CDCCCC4C80CA574166666666A6B61F413333337380CA57416666666622B71F419A9999B97ECA57416666666636B71F419A99993985CA5741000000002AB81F419A9999B985CA574166666666FAB71F41CDCCCC8C97CA5741CDCCCCCCF2B51F41CDCCCC6C05CB574133333333BDB51F416666662612CB57413333333349B91F413333333356CB5741333333331BBA1F419A9999395CCB57410000000070BA1F419A9999B94FCB5741CDCCCCCCB0BA1F41CDCCCC4C4CCB574100000000E4BA1F416666666643CB5741333333335DBB1F416666660634CB5741000000008EBB1F413333339331CB574166666666EEBB1F41666666C633CB5741333333334DBC1F419A9999D930CB57410000000082BC1F41666666E628CB5741000000004ABD1F41666666A616CB5741CDCCCCCC74BD1F419A9999D90FCB5741000000003CBD1F419A9999B912CB5741333333339BBD1F41000000A006CB5741CDCCCCCC10BE1F4166666626FFCA574166666666B0BE1F41CDCCCCCCF9CA57413333333335BF1F4166666646F3CA5741CDCCCCCC54BF1F41CDCCCC8CEBCA574166666666B4BF1F41000000C0E3CA574100000000A2C01F41000000E0DECA57410000000022C11F41CDCCCC6CD7CA574133333333C7C11F41CDCCCCACD3CA57416666666672C21F4166666626CDCA57410000000016C31F41666666C6C4CA57419A99999987C31F41CDCCCC8CBDCA57410000000042C41F41000000A0B5CA5741666666666CC51F4166666686AACA57413333333357C61F41CDCCCC0C9DCA574100000000FCC61F41CDCCCCEC94CA57419A9999998DC71F419A9999598FCA5741000000000EC81F41666666A68CCA5741CDCCCCCC1EC91F419A9999598ACA57419A9999995FC91F419A9999198BCA57416666666696CA1F41CDCCCCCC87CA5741CDCCCCCC00CB1F41000000607ECA57410000000044CB1F419A99997972CA57410000000038CC1F41666666466ACA574133333333F3CC1F413333335365CA57419A9999990BCD1F419A99997952CA5741CDCCCCCC62CD1F41000000E050CA57413333333391CD1F41000000004BCA574133333333DBCD1F419A9999B94ACA574133333333ABCE1F41666666264DCA5741666666661CCF1F41000000604ACA57413333333365CF1F419A99991945CA574133333333A3CF1F41333333F345CA57419A999999F5CF1F41000000204CCA57413333333349D01F41000000A056CA57410000000082D01F410000000059CA574100000000E0D11F41333333935DCA574166666666F4D21F41CDCCCC8C5DCA57413333333371D31F41666666465BCA57419A99999923D41F419A9999B95CCA57419A99999961D41F419A9999995FCA57413333333311D51F410000008063CA57419A99999953D51F41CDCCCC4C62CA574100000000CED51F41CDCCCC8C5ACA57413333333337D61F41CDCCCC0C59CA5741000000004CD71F41CDCCCC4C51CA57410000000064D71F416666662657CA5741666666660AD71F41333333135CCA57413333333327D71F41000000805FCA574133333333A3D71F41CDCCCC6C61CA5741CDCCCCCCE0D71F410000002064CA57419A9999991FD81F413333337362CA5741000000005ED81F41666666C65ACA5741CDCCCCCC64D91F41666666A658CA57410000000090D91F41666666A65BCA5741000000008AD91F41CDCCCC6C66CA574133333333DFD91F419A9999D967CA57413333333349DA1F410000008065CA5741CDCCCCCC32DB1F41333333F36CCA57413333333377DB1F41CDCCCCEC71CA57410000000094DB1F419A99993977CA57413333333373DC1F41000000407BCA5741CDCCCCCC9ADC1F41666666A680CA5741CDCCCCCC0ADD1F416666666680CA57416666666642DD1F419A99991979CA5741CDCCCCCC56DD1F41666666A671CA5741CDCCCCCCD2DD1F41666666066CCA5741CDCCCCCC5EDE1F41CDCCCCCC69CA57413333333321DF1F416666666661CA574133333333D9DF1F41333333D35BCA5741000000004CE01F419A9999795CCA57410000000088E01F419A9999D963CA574100000000E8E01F413333339365CA5741000000006EE11F416666664662CA5741CDCCCCCC00E21F41CDCCCCCC55CA5741333333333FE21F41CDCCCCAC53CA574166666666B4E21F41CDCCCC0C53CA57419A99999979E31F41000000A04BCA574166666666DEE31F41000000404CCA574100000000E0E31F419A99999955CA57410000000006E41F41000000605CCA574100000000EAE41F413333331361CA57419A99999905E61F416666666661CA57413333333345E61F419A9999394FCA5741CDCCCCCCF0E61F41333333D336CA57416666666646E91F4133333353C2C957416666666630E91F41333333D3BDC95741CDCCCCCC3AE91F4166666626ABC9574133333333F5E91F4166666626A3C95741666666660AEB1F416666664690C95741666666666CEB1F419A99993981C95741CDCCCCCC7EEB1F419A99993977C957419A999999A5EB1F419A9999396DC95741CDCCCCCCB6EB1F410000000058C9574166666666F2EB1F41333333B356C957413333333389EE1F41000000A052C95741666666662EF01F41666666864AC957416666666694F01F410000008038C957419A99999907F21F413333333330C9574133333333CDF21F41666666862FC95741CDCCCCCC62F31F41333333B307C95741CDCCCCCC64F61F41000000A025C957410000000056F71F419A9999392EC957410000000012F91F410000004034C9574166666666AAFA1F41666666C637C95741666666665CFB1F419A9999D936C9574100000000DAFC1F419A99997931C957419A99999939FD1F41000000A031C95741333333339DFD1F41666666E628C95741666666661CFE1F410000006025C957410000000088FF1F41666666C617C95741CDCCCCCC32002041CDCCCC4C0DC957416666666659002041333333730CC95741666666660F012041333333D30FC95741CDCCCCCCEA0120419A9999990AC95741CDCCCCCC48022041666666260AC957410000000069022041CDCCCC4C04C95741000000007302204166666606EAC85741333333339902204133333313E2C8574166666666C402204133333373DCC857419A99999903032041000000A0D9C8574100000000440320419A999959D2C857413333333381032041333333B3C9C857413333333382032041CDCCCC4CC5C85741666666665D032041CDCCCCECBBC857419A99999963022041333333B3B8C85741666666664B0220419A999999B7C85741333333331A022041000000A0AEC8574133333333F701204166666686A1C8574166666666A9012041CDCCCC2CA2C8574133333333910120419A9999F9A0C8574100000000530120416666666699C857419A999999FF0020419A9999799BC8574100000000BF0020419A9999B998C8574166666666B30020419A99999978C857419A999999BC0020419A9999196CC8574133333333F7002041CDCCCCCC56C8574166666666410120416666660638C85741CDCCCCCCC0002041CDCCCC6C14C8574133333333B6002041333333B30BC85741CDCCCCCC4001204133333393F7C75741333333337C01204166666646F1C75741CDCCCCCC4B022041CDCCCC8CF7C757419A999999F7022041000000A0EFC75741000000003D032041333333D3E6C757416666666654042041666666C6E2C757419A9999999304204166666646E9C7574166666666A2052041CDCCCC8CE2C757410000000099052041000000C0DFC7574100000000930520419A9999D9C8C75741666666667F05204133333333B0C75741333333336B052041333333B3A7C757419A999999660520419A99991994C7574100000000480520413333335375C757419A9999991F0520413333331360C75741000000001B0520419A9999F956C7574133333333CF0420416666664645C757419A999999350420413333337318C7574133333333C103204133333333FAC65741666666667A03204166666606EFC65741333333332A032041000000E0E8C65741000000006202204133333313E4C65741CDCCCCCCB7012041000000C0DCC657419A999999E80120419A999979CCC657419A99999941022041666666A6BEC6574133333333730220419A999999B9C6574100000000E102204100000000B7C65741CDCCCCCCD50320419A9999F9B7C65741CDCCCCCC7104204133333353B7C65741CDCCCCCCEC042041CDCCCC0CB4C65741CDCCCCCC26062041333333D3A7C65741000000007006204133333373A7C65741CDCCCCCC5806204133333313A3C65741000000004F062041666666469BC6574166666666300620419A99999993C6574100000000250620410000008089C6574100000000F0052041CDCCCCEC79C6574133333333F2052041666666C66DC6574133333333C0052041000000E05EC657419A9999999E052041666666465AC6574100000000710520419A99991946C65741000000004D0520419A9999993FC65741000000001D052041CDCCCC6C32C65741CDCCCCCC0E052041333333332AC65741333333330D0520419A99991917C657419A999999F0042041666666860EC6574100000000DF042041333333B304C657419A999999C4042041000000E0FBC55741CDCCCCCCCD04204100000060F5C557410000000012052041000000A0EBC557413333333310052041333333F3E5C5574100000000FA042041666666A6DFC5574133333333A804204100000080E0C5574100000000610420419A999999CCC5574100000000FC0320419A999979A6C55741666666663D0320419A9999F9B5C55741333333331F032041000000C0B6C5574133333333E6022041666666C6ADC5574166666666CB02204100000020B1C557419A9999999202204166666666B3C55741333333334F0220419A999979BAC55741CDCCCCCC0D02204166666666CEC55741CDCCCCCCC30120419A999939E0C55741CDCCCCCCF0002041333333B30DC65741CDCCCCCC96002041CDCCCCEC24C6574100000000D4FF1F41000000C046C657419A99999901FF1F410000006059C65741CDCCCCCC9AFD1F41666666E675C657419A9999991BFD1F41333333B37DC65741000000006AFC1F413333331386C65741CDCCCCCC62FC1F41CDCCCC8C94C65741333333333FFC1F419A9999B998C657419A99999997FA1F4166666686B2C657419A99999949F91F41666666A6C5C65741CDCCCCCCBEF71F4133333393DAC657410000000066F71F4133333393DCC657419A99999961F71F4133333333E5C65741CDCCCCCC2EF71F419A999919E6C65741333333339BF61F41666666C6EDC65741CDCCCCCC0AF61F41CDCCCC8CF2C65741CDCCCCCC32F51F4100000080F7C657413333333311F31F4133333393FEC6574133333333C5F21F4133333373FEC6574166666666BAF01F4100000000E6C6574133333333D7EF1F41000000E0DDC65741333333331FEF1F41CDCCCC8CD9C6574133333333FDED1F4166666606D0C6574133333333ABEC1F4133333393C9C6574166666666E2EB1F41CDCCCCACBFC657413333333351EA1F41666666A6B4C6574100000000F4E71F419A9999F9A5C65741666666668AE61F41CDCCCC6C98C6574166666666A4E31F419A99999983C657413333333341E21F419A9999F976C65741333333332DE21F41CDCCCCEC80C6574133333333C5E11F41000000A08FC657419A99999913E11F419A99999995C657419A999999E5E01F416666662699C65741CDCCCCCCA8E01F41666666C6A3C657416666666652E01F4133333313AEC657410000000008E01F4166666666B2C6574133333333D5DE1F4100000060C1C65741CDCCCCCC9ADE1F419A9999F9C6C65741333333334BDE1F41333333F3D2C65741CDCCCCCC1EDE1F4133333393D6C657419A999999B3DD1F41666666E6E4C657419A99999985DD1F419A9999D900C757419A9999994DDD1F419A99999910C7574166666666F2DC1F41000000801AC757419A999999C5DC1F410000006024C757419A99999975DC1F41000000402EC75741666666663ADC1F41666666463AC75741333333332DDC1F41CDCCCC4C45C75741CDCCCCCC2CDC1F410000006055C7574166666666A2DB1F41333333B365C75741CDCCCCCC70DB1F419A9999996FC757410000000014DB1F410000004077C757410000000052DA1F41CDCCCC8C8EC7574166666666C4D91F41CDCCCC2CA1C75741CDCCCCCC62D91F41666666C6AAC7574166666666E6D81F4166666626B0C75741CDCCCCCC8CD71F41000000E0B7C757410000000010D61F41CDCCCC0CCCC7574100000000E6D41F4133333373D7C7574133333333DDD11F4133333393E9C75741CDCCCCCC12D01F41CDCCCCCCF3C757416666666638CF1F4166666666FBC7574133333333E7CD1F41CDCCCC4C0EC857410000000054CD1F41CDCCCC8C24C8574100000000A8CC1F419A9999392CC85741333333331DCC1F41CDCCCC8C36C85741CDCCCCCC72CA1F41333333D34BC85741000000007AC91F413333335355C857410000000002C91F41CDCCCC0C53C857413333333357C51F410000002058C857419A999999F3C41F41CDCCCCAC5AC857419A9999996BC41F413333337377C85741CDCCCCCCE4C31F419A9999399DC8574100000000D2C31F41000000C0A4C85741CDCCCCCCD6C31F4133333333CAC8574166666666ECC31F41CDCCCCACD6C8574166666666ACC21F419A999919D3C85741000000002EBF1F4100000040D5C8574100000000A8BE1F41333333F3D6C857413333333307BE1F41000000E0D6C8574166666666B8BD1F41333333D3D8C85741CDCCCCCCF6BC1F4166666626D5C857410000000028BC1F41333333B3D2C85741000000000ABC1F4100000060D1C85741333333334FBB1F419A999999D1C857410000000058BA1F4100000080D4C85741CDCCCCCC86B91F41000000E0D3C85741666666662CB81F419A9999B9DDC857413333333341B71F41CDCCCC4CE3C8574100000000A0B61F41CDCCCC4CEAC85741666666660EB61F419A999959EFC857416666666692B41F413333339303C957416666666626B41F419A9999190EC9574166666666AEB31F41000000C015C957410000000066B31F410000006017C957419A999999CFB21F410000000017C95741CDCCCCCC02B21F41CDCCCCCC1AC9574166666666B4B11F41666666461BC957410000000044B11F419A9999D918C9574133333333C1B01F410000002019C95741666666669AAF1F416666660617C957416666666694AE1F41CDCCCC2C21C957419A999999A1AE1F41CDCCCC6C27C957410000000084AE1F416666660632C95741CDCCCCCC50AE1F41666666663BC9574100000000F8AD1F41CDCCCCCC41C9574133333333A5AD1F410000008045C957410000000096AD1F419A9999394DC957419A999999F1AD1F41000000A054C957416666666674AE1F41666666E655C957413333333385AE1F41CDCCCC8C61C9574133333333C9AE1F41CDCCCCEC6AC957416666666624AF1F413333331373C957419A99999943AF1F410000002079C9574100000000BCAF1F419A99991984C9574133333333D9AF1F419A9999398AC9574166666666BAB01F41333333F39FC9574100000000DAB01F41CDCCCC6CABC9574100000000A4B01F41333333D3B7C957419A9999999FAF1F41CDCCCC8CC2C957416666666682AE1F419A999919D0C957419A999999EFAD1F4133333313D6C95741000000005AAD1F4166666686E0C957410000000000AD1F4100000060FFC95741CDCCCCCC5EAC1F41CDCCCC2C0ACA574133333333FFAB1F41666666260ECA57419A9999990DAB1F41000000E011CA5741CDCCCCCC84AA1F416666664615CA574166666666B6A91F41333333332CCA5741CDCCCCCC7CA91F410000004038CA5741CDCCCCCC7CA91F410000004038CA5741	01010000206A08000090CAE249D0E21F419A9999A988C85741	310230000	Z	Aulon	3102300	31023	31	76	15
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	01010000206A0800004E97D788A5AE21419A9999E951DD5741	310240000	Z	Auragne	3102400	31024	31	76	14
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	01010000206A08000018BECF95608C214100000000D5E65741	310250000	Z	Aureville	3102500	31025	31	76	7
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	01010000206A080000A2B7D27B2B7622416666665676EA5741	310260000	Z	Auriac-sur-Vendinelle	3102600	31026	31	76	31
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	01010000206A080000C85EB922FF572141666666B6C7D85741	310270000	Z	Auribail	3102700	31027	31	76	9
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	01010000206A0800006CF6E0F4EB152041CDCCCC2C08CB5741	310280000	Z	Aurignac	3102800	31028	31	76	18
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	01010000206A0800004AD3FB92BF1C2241333333439DEC5741	310290000	Z	Aurin	3102900	31029	31	76	8
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	01010000206A0800006CA0D3F61D7920419A99996981C45741	310300000	Z	Ausseing	3103000	31030	31	76	6
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	01010000206A0800006216F7A9EDBB1E41000000007EBE5741	310310000	Z	Ausson	3103100	31031	31	76	4
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	01010000206A080000722CDFEF553D21419A9999B937FD5741	310320000	Z	Aussonne	3103200	31032	31	76	14
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	01010000206A0800008EC2F56DFF992141000000302ADB5741	310330101	H	Nord	3103301	31033	31	76	25
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	01010000206A080000346D86EFCAA421419A99997911D85741	310330102	H	Sud-Est	3103301	31033	31	76	5
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	01010000206A0800009D75E2777D902141333333739FD75741	310330103	H	Sud-Ouest	3103301	31033	31	76	8
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	01010000206A080000A01B9170892220419A999949B4C65741	310340000	Z	Auzas	3103400	31034	31	76	8
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	01010000206A080000F684CB98DEA22141343333B321EC5741	310350000	Z	Auzeville-Tolosane	3103500	31035	31	76	7
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	01010000206A080000B82609CB16D42141666666E65EED5741	310360000	Z	Auzielle	3103600	31036	31	76	5
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