SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep32;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep32 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep32','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep32','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep32','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep32"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A08000001000000010300000001000000A805000066666666BE251C419A9999D94E015841666666661C261C41CDCCCC2C530158410000000080261C41CDCCCCCC5701584133333333D7261C419A9999F95B015841666666662C271C4100000000600158410000000068271C41CDCCCCCC6201584166666666A2271C41000000A065015841CDCCCCCCDC271C413333337368015841CDCCCCCC44281C41333333336D01584133333333A3281C419A99999971015841666666660E291C41000000A0760158419A99999977291C41000000607B0158410000000092291C41666666A67C015841CDCCCCCCDE291C41333333538001584166666666382A1C410000008084015841333333338D2A1C41CDCCCC8C8801584166666666D02A1C41000000A08B015841666666662E2B1C419A9999199001584133333333772B1C419A999979930158419A9999995F2C1C41333333B3870158419A999999C92D1C41666666467A01584133333333772E1C419A9999D974015841CDCCCCCC902E1C41CDCCCC0C7401584100000000102F1C410000002070015841000000006E2F1C4100000040800158419A99999951301C4100000000770158419A999999AF301C41000000607301584133333333CF311C4133333393730158413333333369331C419A9999F977015841CDCCCCCC88331C419A9999596901584100000000CE321C4100000000470158419A9999990D331C41CDCCCC8C44015841333333336B331C41CDCCCC8C4101584133333333E5331C41000000603F0158413333333323341C41666666A63E015841CDCCCCCC36341C419A9999993E0158413333333345341C41333333733E0158410000000052341C41333333133E0158410000000070341C41333333933C01584100000000A8341C419A9999593A01584166666666E2341C4133333353380158410000000028351C4133333313360158413333333357351C41CDCCCCAC3401584133333333B1351C419A999999320158419A99999909361C410000008030015841CDCCCCCC66361C41333333332E0158419A999999A5361C419A9999D92C01584100000000FC361C41666666262B0158410000000052371C41666666C629015841CDCCCCCC90371C41CDCCCCCC280158413333333325381C410000002026015841CDCCCCCC60381C413333331325015841CDCCCCCC82381C410000004024015841CDCCCCCC8E381C419A9999F92301584133333333D1381C4100000020220158413333333325391C41CDCCCC2C200158416666666644391C41CDCCCCAC1F0158416666666680391C41000000001F0158419A99999993391C41666666C61E0158419A999999C3391C41CDCCCCCC2301584166666666F4391C41CDCCCCCC280158419A999999413A1C41333333B32E015841000000008C3A1C4100000040350158419A999999BF3A1C41000000E03A01584100000000EC3A1C41333333F3400158419A9999990D3B1C419A99997948015841CDCCCCCC103B1C419A9999B94C01584166666666423B1C419A9999194C015841333333338D3B1C41000000E0470158419A999999013C1C41666666A644015841333333336B3C1C413333333343015841CDCCCCCC903C1C419A99993943015841CDCCCCCCBE3C1C41000000004401584100000000063D1C41CDCCCC6C4501584133333333293D1C410000002047015841333333335D3D1C4166666606490158419A999999913D1C41666666A6490158419A999999FB3D1C41CDCCCCAC4A01584100000000643E1C41333333B34A015841CDCCCCCCB83E1C41666666264A015841CDCCCCCCDE3E1C41CDCCCC8C49015841CDCCCCCC023F1C41CDCCCC6C48015841000000002E3F1C41CDCCCCAC46015841CDCCCCCC5E3F1C41000000204501584133333333833F1C41CDCCCCEC4401584166666666983F1C4166666646450158419A999999A93F1C413333339345015841CDCCCCCCC03F1C41666666464601584100000000E43F1C41666666C6470158410000000008401C4166666606490158416666666650401C41000000A04A0158410000000062401C41000000A04A0158419A9999996D401C41666666464A0158419A99999979401C41CDCCCC8C490158413333333379401C4166666686470158413333333379401C413333331346015841CDCCCCCC72401C41CDCCCC0C42015841CDCCCCCC6C401C41666666C63A0158410000000074401C419A999939380158419A99999975401C41333333F3360158416666666688401C4133333393350158416666666698401C41CDCCCCAC3401584166666666A8401C413333335334015841CDCCCCCCC2401C41333333933401584166666666D8401C41333333F334015841CDCCCCCCEC401C41CDCCCCEC35015841CDCCCCCC0E411C41CDCCCC4C380158419A9999995D411C41333333F33D015841666666666C411C41333333F33E015841333333338F411C419A99993940015841CDCCCCCCB0411C419A9999994001584166666666C8411C41000000804001584166666666DE411C41333333F33F01584133333333FB411C41000000C03E015841CDCCCCCC0C421C41666666663D0158416666666612421C41CDCCCCAC3B0158419A99999913421C41000000C038015841CDCCCCCC0E421C41333333D3320158416666666610421C41333333132E0158419A9999991B421C41000000A02B0158413333333323421C41333333D32A0158419A99999935421C41666666E6290158419A99999945421C41CDCCCC2C29015841333333336D421C419A9999B928015841CDCCCCCCB2421C41333333132801584100000000F0421C41333333B3270158416666666622431C419A99995927015841333333332B431C41CDCCCC2C270158416666666678431C41666666C6250158413333333311441C41333333F322015841000000005A441C419A9999D921015841000000007A441C419A9999792101584166666666AA441C410000006021015841CDCCCCCCE4441C41666666A6210158419A99999943451C4100000060220158416666666656451C41CDCCCC4C220158413333333361451C4166666606220158416666666622471C41666666867101584100000000D2461C41000000A08F015841CDCCCCCC26461C41CDCCCC4C940158419A99999969471C4166666626AA0158410000000026481C419A999939BF0158410000000036481C41CDCCCCACCE015841CDCCCCCC34481C41CDCCCC8CE7015841000000004A4A1C41666666C6FE015841000000004C4B1C419A999939F601584100000000B84B1C41000000A00402584100000000064C1C41000000E01002584166666666584C1C419A9999D9130258419A999999EB4C1C419A9999792802584100000000B64D1C41666666664002584100000000424D1C41333333734302584133333333594D1C410000002046025841666666667A4D1C41CDCCCCEC49025841CDCCCCCC964D1C41333333F34C02584133333333AF4D1C416666662650025841CDCCCCCCC04D1C4100000000530258419A9999991D4E1C413333335356025841CDCCCCCC6C4E1C41666666A657025841CDCCCCCC344F1C41666666C660025841333333337F4F1C416666664665025841CDCCCCCC884E1C41666666868402584100000000104E1C41333333938202584166666666AE4D1C419A9999D98302584133333333AD4D1C419A9999999302584133333333BD4D1C41000000C0A6025841CDCCCCCCE44D1C4100000000B202584100000000E84C1C4166666606B5025841CDCCCCCC024D1C41666666E6B802584133333333554D1C41666666C6BC0258419A999999AF4D1C419A9999F9C0025841666666660E4E1C4166666666C902584166666666224E1C41333333F3D1025841666666661C4E1C419A9999D9D9025841CDCCCCCC1E4E1C419A999959E102584133333333554E1C41CDCCCC0CEB025841CDCCCCCC524E1C41CDCCCC2CF802584100000000664E1C41666666E6060358419A9999995F4E1C419A9999B923035841CDCCCCCC6E4E1C419A9999592C0358419A999999A94E1C41000000403B03584100000000E44E1C41CDCCCCEC40035841CDCCCCCC204F1C419A99997948035841000000006E4F1C41333333D34E03584100000000CE4F1C410000008055035841CDCCCCCCDE4F1C41CDCCCCAC6903584133333333D54F1C41333333F37703584133333333EB4F1C419A9999597F0358410000000020501C41000000208C03584100000000A0501C41333333D3A5035841CDCCCCCCB4501C4133333373B30358419A99999971501C4166666606B70358413333333323501C41CDCCCCCCBA0358410000000002501C419A999979BF03584133333333F34F1C41CDCCCC6CC6035841CDCCCCCCDE4F1C419A999919CC03584166666666A44F1C41333333D3CE03584166666666704F1C4133333313D2035841000000006C4F1C41000000A0D50358419A999999714F1C4133333353D903584100000000484F1C41000000C0DC03584100000000664F1C41333333D3E30358419A999999734F1C41CDCCCCACE8035841000000008C4F1C41666666C6EE035841666666669C4F1C419A999939F50358419A999999E14F1C419A999959FB03584133333333DD4F1C410000004002045841CDCCCCCCEA4F1C419A9999D90904584100000000F44F1C41CDCCCC4C1004584133333333E74F1C41666666261504584100000000E44F1C41000000601B0458413333333319501C4166666626220458416666666624501C413333335326045841CDCCCCCC2C501C419A9999592A0458410000000042501C41666666662D0458416666666664501C41000000602E045841000000008E501C41666666262F0458413333333399501C41666666663104584166666666A2501C419A9999D9350458419A99999953501C41000000E0380458419A999999814F1C419A9999B94004584133333333214E1C41333333934E04584133333333E54A1C41000000A06B0458410000000070491C419A9999197A045841CDCCCCCCB6461C41333333D3920458419A999999C3451C41666666C69D04584133333333DD441C4133333353A50458416666666634441C4100000080A90458419A9999993B441C4133333353AF0458413333333343431C4100000000B50458416666666658421C4166666626B60458419A999999BD411C4100000000B80458419A99999929411C4100000080B804584133333333CF401C419A999959B8045841666666668A401C41CDCCCC4CB80458416666666622401C4133333353BA045841CDCCCCCCC43F1C41666666C6BD0458419A9999996F3F1C419A9999F9C4045841CDCCCCCC0E3F1C4133333333CB045841CDCCCCCCE63E1C41000000C0CD04584133333333C93E1C4100000020CF04584166666666923E1C41CDCCCCCCCE04584100000000643E1C4100000040CF045841666666664C3E1C4166666606D00458419A999999133E1C41333333F3D204584133333333B93D1C41CDCCCC4CD50458419A9999994F3D1C4133333333D704584166666666363D1C4133333373D804584100000000203D1C4133333313DA0458419A9999991D3D1C4166666666DC04584133333333173D1C4100000020DE04584100000000063D1C41CDCCCC0CDF045841CDCCCCCCE43C1C4100000080DF04584133333333C13C1C4133333393DF0458419A999999853C1C4166666686E104584133333333413C1C419A9999D9E304584133333333EB3B1C41000000C0E5045841CDCCCCCC9E3B1C4166666606E9045841666666663E3B1C4100000060ED045841CDCCCCCCC43A1C41000000E0F1045841666666667E3A1C4100000040F5045841CDCCCCCC3E3A1C419A999999F8045841CDCCCCCC363A1C4133333333FD045841666666661C3A1C413333339304055841CDCCCCCC123A1C41CDCCCC6C0905584166666666183A1C41666666260D05584100000000A03A1C4133333393220558419A9999990D3C1C41000000804A055841CDCCCCCCA23C1C419A9999D95A0558419A999999513D1C41000000406F055841000000009E3D1C41666666267E05584166666666A23D1C41666666468105584100000000A43D1C410000004082055841CDCCCCCC963D1C410000000086055841333333337D3D1C41333333138905584166666666C63C1C419A9999799C055841CDCCCCCC803C1C41333333F3A505584166666666563C1C41CDCCCCCCAE05584133333333353C1C4166666606BC0558419A999999373C1C419A999999C2055841000000005C3C1C41000000E0D005584166666666EA3C1C41666666A6EF055841CDCCCCCC603D1C4133333313020658419A999999E93D1C41CDCCCC2C0E0658419A999999613E1C41000000A0180658419A9999998B3E1C41666666261C06584166666666963E1C419A9999B91E065841CDCCCCCC983E1C419A9999B92006584100000000983E1C41333333132306584133333333CD3E1C41CDCCCCCC20065841CDCCCCCCEA3E1C41CDCCCCCC1E06584100000000283F1C41CDCCCC6C1C065841CDCCCCCC46411C41333333D3090658419A999999DB411C41333333D30406584100000000C8421C41000000E0FB055841666666666E431C41666666C6F505584133333333F7431C41CDCCCCCCF0055841CDCCCCCC64441C41CDCCCC8CED05584133333333D1441C4133333393EA0558416666666608451C41666666C6E80558410000000098451C41CDCCCCECE5055841CDCCCCCC2C461C4166666606E2055841333333338F461C4100000020E005584166666666F6461C41333333B3DE055841CDCCCCCC48471C419A9999B9DD0558416666666678471C4166666666DD05584100000000AC471C41CDCCCCACDC05584100000000D0471C4166666626DC0558419A9999991B481C41666666A6DA055841CDCCCCCCAE481C41333333D3D605584100000000F2481C41CDCCCCECD40558419A99999937491C41333333D3D3055841666666668E491C41333333B3D205584166666666E6491C4100000020D1055841000000000C4A1C4166666646D005584133333333254A1C419A999999CF055841CDCCCCCC5E4A1C419A999979CE0558419A9999998D4A1C4100000080CD055841CDCCCCCCA64A1C419A9999D9CC05584133333333C54A1C41000000C0CB0558419A999999614E1C4100000000C8055841000000002A4F1C41CDCCCC2CC205584133333333854F1C4166666606BF05584100000000B04F1C4133333353BB05584100000000F84F1C4166666686B805584100000000EE501C4100000060B105584133333333F9511C419A9999B9A905584100000000A0521C4166666626A5055841333333331F531C41CDCCCCECA0055841CDCCCCCCDA531C41333333B39A055841000000005C541C419A999939960558410000000076541C419A999979960558419A9999999D541C41CDCCCCEC9605584133333333E5541C416666668696055841000000001C551C4100000020960558413333333391551C41CDCCCC2C9505584100000000EA551C410000004095055841CDCCCCCC14561C410000002095055841000000005E561C41CDCCCCCC94055841CDCCCCCC04571C41333333B3930558410000000058571C41666666069205584133333333A7571C419A9999B98F0558419A9999990D581C41666666E68B055841CDCCCCCC7E581C413333335386055841CDCCCCCCB6581C4166666606840558410000000000591C41CDCCCC8C810558413333333363591C41666666467D05584133333333055A1C41333333B375055841000000006E5A1C41000000807005584133333333E95A1C41333333F36905584133333333755B1C41000000A06405584166666666B45B1C41000000A061055841CDCCCCCCF05B1C41666666265E055841000000003E5C1C41000000405905584133333333CD5C1C41CDCCCC6C4E055841CDCCCCCC405D1C41CDCCCC2C44055841CDCCCCCC625D1C419A9999194005584100000000C25D1C41666666063705584166666666EC5D1C41000000C032055841000000000C5E1C41CDCCCC0C3005584133333333315E1C41666666662D05584133333333795E1C41666666662905584100000000AE5E1C41333333932605584133333333D95E1C41666666A62405584166666666E05F1C41666666261B055841000000001E601C41CDCCCC0C18055841000000009A601C4100000040100558410000000032611C419A9999390705584166666666B2611C41333333B3FE0458419A999999E5611C41333333B3FB045841000000004A621C41000000A0F60458416666666614631C419A999959ED04584133333333A1631C41666666C6E60458419A999999DD631C41CDCCCCACE20458416666666620641C41000000E0DC045841000000008E641C4133333333D2045841CDCCCCCC40651C41000000E0C10458410000000072651C41000000A0BD0458419A999999A5651C4166666626B90458419A99999927661C41CDCCCC4CAD045841CDCCCCCCA6661C41333333B3A10458416666666620671C41666666C69604584133333333A1671C41333333738A04584133333333F9671C41CDCCCCEC7D0458410000000012681C419A9999B9770458410000000028681C41CDCCCC2C71045841CDCCCCCC14681C41000000A05F045841666666660A681C41333333935504584166666666EC671C41333333335004584166666666E8671C41000000A04B0458419A999999D7671C41000000E0450458419A999999CD671C41CDCCCC4C4104584133333333B9671C419A9999593C04584166666666B8671C410000006036045841CDCCCCCCA6671C419A9999793104584100000000AA671C41000000402B0458419A999999E9671C41CDCCCC0C27045841CDCCCCCC2C681C410000004022045841333333337D681C41333333731D045841CDCCCCCCA2681C41CDCCCC0C1904584100000000D6681C419A9999391504584100000000EC681C4133333373110458419A99999901691C41CDCCCCAC0B045841666666660E691C41333333B306045841000000001E691C4133333393010458416666666632691C41CDCCCC6CFB0358416666666646691C4133333353F50358413333333363691C4133333373EF035841333333338B691C4133333333EA03584133333333BD691C419A9999D9DD0358419A999999BB691C41CDCCCCECD10358419A9999999F691C419A9999D9C00358410000000070691C4133333393AE0358419A9999991F691C419A9999F99703584100000000E4681C41000000408703584133333333CF681C419A9999798203584100000000146A1C4166666646700358419A999999836A1C41333333334B0358419A9999994F6A1C416666668647035841333333331B6A1C41666666A64303584133333333EF691C41CDCCCC0C3F03584100000000C2691C419A99993938035841CDCCCCCCA2691C41666666C633035841000000006A691C419A9999F92C0358410000000018691C41666666C6200358410000000008691C41000000801B0358413333333309691C4100000080180358416666666618691C416666662615035841CDCCCCCCA2691C419A9999990903584133333333016A1C4166666606030358419A999999456A1C41000000A0FD0258419A999999896A1C41CDCCCC0CFB02584166666666286B1C41333333B3F4025841CDCCCCCC706B1C4133333333F202584133333333796B1C41000000E0F102584133333333E16B1C4133333333EF025841333333335F6C1C4133333313ED02584133333333D36C1C4166666606EB02584166666666406D1C419A999979E8025841333333338B6D1C41CDCCCC8CE602584166666666D66D1C4100000020E40258419A999999096E1C41CDCCCC8CE1025841333333334F6E1C419A999999DD025841CDCCCCCCA86E1C41666666C6D7025841CDCCCCCC086F1C4166666666D10258419A999999616F1C41000000E0CB025841CDCCCCCCF66F1C4166666686C20258413333333339701C41333333D3BD0258410000000060701C41333333D3BA025841CDCCCCCC96701C41666666C6B502584166666666B0701C419A999979B202584133333333D5701C41666666E6AB0258419A999999F9701C419A9999D9A4025841CDCCCCCC20711C41000000609D0258419A99999939711C41000000E0980258410000000006721C419A9999999702584100000000FE731C41000000A0950258419A9999999D741C41333333F3910258419A99999915751C41333333938D025841000000003E751C41000000A094025841CDCCCCCC68751C419A9999F99802584166666666B8751C419A9999199B02584133333333FF751C41000000809D0258419A99999969761C419A999959A202584133333333E1761C41CDCCCC4CA7025841333333332F771C41000000C0AB025841666666663C771C4133333333AE0258410000000048771C419A999919B0025841666666667C771C4166666606AC0258419A999999A3771C4100000060A702584100000000EA771C41CDCCCCECA10258419A99999913781C41666666E69E0258419A99999939781C41000000E099025841CDCCCCCC36781C416666660699025841CDCCCCCC2C781C41CDCCCCEC970258416666666624781C419A9999F9960258419A99999919781C416666666695025841666666661C781C419A999999940258416666666626781C410000004093025841CDCCCCCC30781C41666666E692025841CDCCCCCC34781C41666666E6920258413333333339781C4133333313930258413333333361781C41666666069302584166666666D8781C41333333738F02584100000000F8781C41333333D38D0258419A99999911791C41000000408C0258416666666628791C41CDCCCC8C89025841000000002E791C416666666687025841CDCCCCCCC67A1C419A9999398102584133333333277D1C41CDCCCC4C7402584166666666DC7E1C41333333D3640258419A99999915801C41CDCCCCEC590258419A9999994D801C41666666C66102584166666666A0801C41000000E06C02584133333333C3801C41000000007202584100000000E8801C41CDCCCC0C770258416666666678811C41000000208A025841CDCCCCCCCA811C41CDCCCCCC9502584100000000F8811C419A9999799B0258413333333319821C419A9999399E0258419A99999939821C41666666E69F025841333333333D821C4133333313A0025841CDCCCCCC5E821C419A999999A10258419A999999B1821C4166666626A40258416666666604831C4133333393A6025841666666669E831C4166666606AB02584100000000D0831C41CDCCCC4CAC0258419A99999909841C41CDCCCC6CAB0258419A9999996B841C419A9999D9AA025841CDCCCCCCD8841C4100000020AA025841CDCCCCCCFA841C41CDCCCCCCA9025841666666666E851C4166666606A80258416666666694851C4166666626A70258419A999999B7851C41CDCCCC0CA6025841CDCCCCCCD4851C4133333313A50258413333333305861C4100000020A3025841CDCCCCCC2C861C419A9999D9A10258419A9999995F861C419A9999B9A002584166666666A2861C41CDCCCC8C9F02584133333333ED861C419A9999599E0258413333333337871C41CDCCCC4C9D025841CDCCCCCC72871C41666666869C025841CDCCCCCC8A871C419A9999599C02584166666666A4871C41333333739C0258419A999999BB871C41CDCCCCAC9C0258413333333323881C41333333B39E025841CDCCCCCC7E881C4133333373A002584133333333BB881C419A999979A102584100000000E8881C419A9999F9A10258416666666616891C41CDCCCC0CA2025841000000003A891C41000000E0A10258419A99999955891C4133333373A10258416666666682891C4133333373A0025841CDCCCCCCB4891C41000000E09E025841CDCCCCCCD0891C41CDCCCC2C9E02584100000000E4891C41000000009E02584133333333F5891C41000000009E025841333333330F8A1C41000000C09E02584133333333278A1C41CDCCCCEC9F025841CDCCCCCC6C8A1C41333333F3A20258419A9999997B8A1C41333333B3A30258419A999999898A1C419A999979A402584133333333938A1C41CDCCCCACA5025841666666669A8A1C41333333B3A7025841CDCCCCCC9A8A1C41CDCCCCCCA802584133333333958A1C4166666646AA025841000000005C8A1C419A999919B10258419A9999994B8A1C41CDCCCC4CB302584100000000448A1C41333333F3B402584166666666448A1C41CDCCCC6CB602584133333333458A1C4100000060B7025841000000004E8A1C4133333393B80258419A9999995F8A1C41666666C6B9025841666666667C8A1C419A999939BB02584166666666C28A1C419A999979BE02584100000000D48A1C41CDCCCC8CBF0258419A999999F98A1C41CDCCCCECC10258419A999999238B1C4166666666C4025841CDCCCCCC448B1C419A999919C6025841CDCCCCCC6E8B1C4133333353C802584133333333A18B1C41CDCCCC6CCA025841CDCCCCCCB68B1C41CDCCCCECCA02584166666666E48B1C4100000020CB025841CDCCCCCC268C1C41666666C6CA0258419A9999996F8C1C4100000000CA0258419A999999CB8C1C419A999959C802584133333333278D1C4166666606C602584100000000788D1C41CDCCCC8CC3025841000000009E8D1C419A999979C202584166666666A48D1C4166666646C2025841CDCCCCCCC88D1C41CDCCCC6CC102584133333333138E1C4133333313C0025841666666666E8E1C4133333393BE0258419A9999999B8E1C419A999919BE025841CDCCCCCCCA8E1C41000000A0BD02584133333333078F1C419A999919BD02584133333333438F1C41666666E6BC025841666666668C8F1C41CDCCCCACBC025841CDCCCCCCCA8F1C4166666666BC0258416666666614901C4133333393BC025841666666664E901C41000000A0BC0258419A99999977901C41333333F3BC025841CDCCCCCCA4901C4166666646BD0258419A999999C3901C41000000C0BD025841CDCCCCCCF0901C4100000080BE0258410000000018911C419A999959BF0258419A99999961911C4166666626C10258419A999999A5911C41666666C6C202584133333333D7911C41000000C0C30258416666666600921C4100000080C40258410000000064921C4133333393C502584100000000B6921C419A999939C60258410000000008931C41666666A6C6025841000000003A931C419A9999D9C6025841000000006E931C41666666E6C6025841333333339F931C41CDCCCC8CC60258419A999999C1931C419A999959C602584100000000E6931C41CDCCCC4CC60258419A99999917941C4133333353C6025841CDCCCCCC42941C4166666686C60258419A9999996D941C419A9999D9C602584100000000A8941C4166666666C70258419A999999D5941C41000000E0C7025841CDCCCCCC06951C4133333373C80258419A99999937951C4100000020C90258410000000054951C419A9999B9C90258416666666696951C41CDCCCC8CCB0258419A999999EB951C4133333333CE0258419A99999915961C4166666666CF025841CDCCCCCC52961C41CDCCCCACD00258413333333395961C419A9999F9D10258413333333325971C4133333353D402584166666666E4971C4166666666D70258419A99999929981C41CDCCCCACD80258410000000050981C419A9999B9D9025841666666666C981C41000000A0DA025841CDCCCCCC9A981C4133333393DC0258419A999999EB981C419A9999B9E0025841CDCCCCCC10991C41333333F3E20258416666666652991C4166666646E70258410000000082991C419A999919EA02584133333333A9991C419A9999F9EB0258419A999999C5991C4166666606ED0258419A999999DF991C41CDCCCCACED0258419A999999FF991C4133333353EE02584166666666389A1C41666666E6EE02584133333333799A1C419A999999EF025841CDCCCCCCD89A1C41CDCCCCACF0025841666666662C9B1C41CDCCCC8CF1025841333333333D9B1C41666666C6F10258419A9999998B9B1C419A999999F202584100000000B49B1C4166666646F302584100000000E09B1C4100000080F3025841CDCCCCCC049C1C419A9999F9F30258419A9999995B9C1C4166666626F402584166666666649C1C41333333D3F302584133333333659C1C41666666A6F302584133333333A39C1C4166666606F402584166666666CE9C1C41333333F3F30258419A999999E59C1C41CDCCCCECF3025841CDCCCCCCF89C1C4133333373F302584166666666129D1C419A999979F20258419A9999991F9D1C4133333333F202584133333333379D1C41000000E0F102584133333333599D1C4166666646F10258419A9999997B9D1C41CDCCCCACF00258419A999999BF9D1C4100000000EF0258419A999999379E1C41000000E0EC025841333333337D9E1C41CDCCCC8CEB025841CDCCCCCC149F1C41CDCCCC6CE802584100000000629F1C41000000E0E6025841CDCCCCCC42A01C4100000080E302584133333333B1A11C41000000A0E4025841CDCCCCCC08A21C419A999979E702584166666666D4A21C419A9999B9EB0258410000000064A31C4133333393EE0258419A999999EBA31C419A999979F1025841666666668CA41C4166666646F40258419A99999929A51C4166666666F7025841000000000CA61C419A999979FC0258413333333371A61C4100000000FF0258419A9999998DA61C4133333393FF0258413333333395A61C41333333B3FD02584166666666A8A61C4133333313F802584133333333E1A61C4100000080ED02584133333333EBA61C41CDCCCC4CEB02584166666666FEA61C41CDCCCC6CE5025841666666663CA71C4133333333D3025841000000008CA71C4133333313C102584100000000A6A71C419A9999B9BB02584133333333F5A71C419A999979A9025841333333332FA81C41333333F398025841333333333FA81C4133333353940258410000000082A81C41000000E0820258419A9999999BA81C419A9999797B02584166666666C4A81C4133333373700258419A999999D5A81C419A9999B96B0258419A999999EFA81C41000000A06402584133333333F9A81C41CDCCCC8C620258419A99999901A91C410000008060025841CDCCCCCC06A91C41000000A05D0258416666666608A91C41CDCCCCAC5C0258413333333307A91C41CDCCCCCC590258419A99999911A91C410000008053025841666666661EA91C41333333334D0258416666666624A91C41666666664B0258413333333329A91C410000002048025841CDCCCCCC2EA91C416666668645025841333333333DA91C4133333393430258413333333349A91C41666666E6410258410000000058A91C4100000060400258410000000084A91C419A9999793C02584100000000ACA91C41000000E03802584166666666BEA91C41000000603602584133333333CBA91C419A9999D9340258419A999999D5A91C41CDCCCC2C34025841CDCCCCCCE6A91C419A99999933025841CDCCCCCC58AA1C41333333732F02584166666666B4AA1C41000000A02B02584133333333E1AA1C41000000802902584133333333FBAA1C41666666A628025841CDCCCCCC16AB1C410000008027025841666666662CAB1C41333333D325025841CDCCCCCC3CAB1C4100000000240258419A9999997DAB1C41333333331D02584100000000B6AB1C410000006017025841CDCCCCCCD0AB1C41333333131402584133333333E5AB1C41CDCCCC2C110258410000000000AC1C41333333530C025841CDCCCCCC14AC1C41666666A607025841CDCCCCCC44AC1C4133333333FE01584100000000A4AC1C4100000040ED015841CDCCCCCCD6AC1C41000000E0E3015841CDCCCCCCE4AC1C419A999919E0015841CDCCCCCCEEAC1C4133333373DE015841CDCCCCCCFAAC1C4100000060DC0158416666666610AD1C4100000040D9015841CDCCCCCCFAAC1C41333333F3D601584166666666DAAC1C4133333373D301584166666666A6AC1C4100000000D00158410000000062AC1C419A9999F9CC015841CDCCCCCCE6AB1C419A9999D9C70158416666666696AB1C41CDCCCC8CC40158416666666610AB1C4100000020BF01584100000000ACAA1C4100000040BB0158413333333367AA1C4133333373B901584133333333F3A91C41CDCCCC6CB70158419A99999993A91C41CDCCCCECB5015841CDCCCCCC3AA91C41CDCCCC6CB50158413333333399A81C4166666686B30158419A999999F9A71C41666666C6B1015841666666665CA71C41CDCCCCECAF015841333333338DA61C41CDCCCCECAC0158419A99999931A61C419A999919AB01584100000000E6A51C41000000C0A9015841CDCCCCCCCCA51C41CDCCCC4CA90158419A9999998BA51C41666666C6A80158410000000076A51C41666666C6A80158413333333367A51C41CDCCCCACA8015841666666665CA51C4166666606A8015841666666664CA51C41666666E6A50158419A9999993DA51C419A999959A5015841333333332DA51C419A999979A5015841CDCCCCCC1EA51C41CDCCCCECA5015841CDCCCCCCFAA41C41CDCCCC2CA6015841CDCCCCCCA2A41C41CDCCCCECA5015841CDCCCCCC40A41C419A9999D9A301584133333333CDA31C41333333B39D015841333333336FA31C419A99999999015841CDCCCCCC22A31C419A9999999B0158419A999999B3A21C41CDCCCCCCAB01584133333333A3A11C41000000E09E0158419A999999A5A01C4100000000990158410000000048A01C41666666E69401584133333333D79F1C41333333738E015841CDCCCCCC249F1C419A99993986015841CDCCCCCC309E1C41000000C078015841666666667E9D1C419A9999596F01584166666666609C1C419A9999B96501584100000000049C1C41666666A6640158419A999999AF9B1C41CDCCCC0C6301584100000000509B1C41666666865F01584166666666F89A1C419A9999595B01584100000000B89A1C413333337357015841CDCCCCCC609A1C419A99999953015841CDCCCCCC189A1C41CDCCCCEC4E01584133333333EB991C419A99999948015841CDCCCCCCAA991C4166666646430158413333333363991C41000000603F0158419A9999992B991C41000000803C01584100000000F4981C419A999999390158419A999999B9981C419A9999D936015841000000005A981C41666666A632015841000000002A981C41666666C62F0158419A999999DF971C41666666E62A01584133333333A7971C41CDCCCC0C27015841666666665A971C419A9999B920015841CDCCCCCC0E971C410000006015015841CDCCCCCCEA961C419A999939080158419A999999DF961C410000008003015841CDCCCCCCEE961C41CDCCCCECFF005841CDCCCCCCC8961C4166666606FB00584100000000AE961C41CDCCCCACF50058419A99999985961C41CDCCCCCCF0005841CDCCCCCC62961C41333333F3EB005841666666663A961C4133333373E5005841CDCCCCCC06961C4100000080DD00584100000000D4951C41000000E0D600584100000000CE951C41333333F3D20058416666666696951C41CDCCCC8CCF005841000000004C951C41CDCCCCACCC00584166666666FC941C4166666626C800584100000000BA941C4100000020C40058419A99999979941C419A9999F9BD005841666666664C941C4133333313BA005841333333331F941C419A999959B700584133333333D7931C41CDCCCC6CB40058419A99999987931C4133333333B10058416666666640931C4100000020AF005841CDCCCCCCE0921C4133333393AC0058410000000094921C41CDCCCCACAA0058410000000042921C41000000C0A800584133333333E5911C4100000000A70058416666666688911C4133333373A40058413333333319911C41CDCCCCCC9F00584133333333E1901C41666666669C005841CDCCCCCCAE901C4133333353990058419A99999981901C41666666C6950058410000000054901C413333339391005841666666663E901C41000000008E005841333333332B901C41000000A089005841333333330B901C41333333138500584100000000E08F1C41CDCCCC6C7E00584133333333B58F1C41000000407800584133333333878F1C41000000C072005841CDCCCCCC648F1C41333333B36E005841000000002A8F1C41666666A66A00584166666666F48E1C41666666A66500584100000000C48E1C419A9999795F00584100000000AC8E1C41666666865B00584133333333938E1C41666666E65500584166666666888E1C41CDCCCCAC5100584133333333758E1C41333333D34B00584100000000668E1C41666666263E005841CDCCCCCC228E1C419A9999B93500584166666666F88D1C41000000402E005841CDCCCCCC868D1C419A9999592600584133333333158D1C419A999939210058419A9999997B8C1C41666666261C00584133333333FB8B1C41666666461800584100000000628B1C413333331314005841000000009C8A1C41666666261100584100000000128A1C419A9999190F005841CDCCCCCC4A881C41333333930D00584100000000E2871C4133333333150058410000000034871C41333333F30D00584100000000EE861C4133333393090058410000000074861C41333333B3FEFF5741CDCCCCCC22861C4166666626F8FF57419A99999991851C419A999959F6FF574100000000C6841C4166666626F8FF5741CDCCCCCCC0831C4133333353FAFF5741000000001E831C41CDCCCC0CFBFF57416666666658821C419A9999F9F9FF574166666666E0811C4100000080F8FF5741CDCCCCCC2E811C4133333373F9FF574166666666B0801C41000000A0F9FF57410000000022811C4133333373E6FF57410000000018811C4166666606DFFF574133333333A7801C41000000A0D7FF5741CDCCCCCC54801C4133333353C9FF57413333333313801C41CDCCCC6CBAFF57413333333309801C4100000000ABFF57419A9999998F801C419A9999D9A9FF57419A99999907811C4133333313A5FF5741000000007E811C41000000C09EFF57410000000070811C41CDCCCC2C9DFF5741CDCCCCCC1A811C419A9999F98FFF574166666666CA801C419A9999D983FF5741333333337F801C41CDCCCCCC7BFF5741CDCCCCCC56801C416666662678FF57413333333339801C41CDCCCC6C78FF574166666666C27F1C419A99997978FF574133333333637F1C413333337377FF574166666666E47E1C419A9999F975FF57419A999999A77E1C41666666C674FF5741CDCCCCCCF47D1C410000008071FF57419A999999C57D1C416666668670FF5741666666664C7D1C41CDCCCCCC6FFF574100000000E67C1C410000002070FF5741CDCCCCCC807C1C419A99999970FF5741000000004C7C1C41000000E070FF574100000000327C1C416666662671FF574166666666027C1C41333333B372FF57419A999999CF7B1C41CDCCCCCC74FF57419A999999917B1C41CDCCCC4C78FF574133333333B97A1C41000000806EFF5741CDCCCCCCC47A1C419A9999F96BFF574133333333ED7A1C41CDCCCC4C68FF574166666666267B1C41333333F363FF574133333333637B1C41333333535FFF574133333333A97B1C41000000A059FF574166666666BC7B1C413333339357FF574133333333D37B1C416666660655FF574133333333E77B1C410000008051FF57419A999999F57B1C41CDCCCC6C4EFF5741CDCCCCCC067C1C41666666464CFF5741666666665E7C1C41666666A643FF574166666666887C1C413333339340FF574166666666FC7C1C419A99993937FF57419A999999417D1C41333333D331FF57419A999999897D1C41333333B32CFF57419A999999F97D1C413333335326FF5741000000004E7E1C41CDCCCC2C21FF5741CDCCCCCC847E1C41666666C61FFF5741CDCCCCCCB67E1C419A9999391FFF574166666666D07E1C41666666C61EFF57419A999999057F1C419A9999791BFF57419A999999177F1C41CDCCCCAC19FF574133333333497F1C41333333B316FF5741CDCCCCCC607F1C413333333314FF57419A9999997D7F1C41333333B311FF5741CDCCCCCCA27F1C41CDCCCC6C10FF57419A999999DF7F1C419A9999190FFF57413333333315801C41000000E00DFF57419A9999992D801C419A9999790CFF57413333333349801C41000000A008FF5741CDCCCCCC5C801C41CDCCCC2C07FF5741CDCCCCCC74801C413333339305FF57419A99999983801C41CDCCCC4C03FF57413333333399801C419A999919FFFE574100000000B2801C419A999959FBFE574166666666CC801C4133333373F6FE574166666666EC801C419A9999F9EDFE5741CDCCCCCC38811C419A999959E8FE57410000000078811C419A9999F9E3FE57419A999999C9811C4100000040DBFE574166666666E4811C41333333D3D8FE5741CDCCCCCC08821C4166666686D4FE5741333333333F821C41666666A6CDFE57416666666690821C4100000080C5FE574100000000D6821C419A999979BFFE57419A9999997D821C4166666666B2FE57410000000018821C4133333333A7FE5741333333333F821C41333333B39FFE57419A99999941821C41666666E699FE5741CDCCCCCC00821C41333333738EFE574100000000BA811C419A99999990FE5741000000002E811C416666660696FE57410000000034801C410000004083FE5741CDCCCCCC1E801C41666666C67EFE57419A9999995B801C41333333937CFE5741CDCCCCCCB6801C41CDCCCC0C7AFE57419A999999DB801C410000004079FE57410000000006811C416666668678FE5741333333332D811C410000004078FE57410000000040811C410000004078FE5741CDCCCCCC40811C419A99991976FE57413333333331811C413333335372FE5741CDCCCCCC2A811C41CDCCCC8C6EFE5741666666662C811C41333333536BFE57410000000028811C413333333369FE57413333333311811C419A9999F966FE57419A999999F1801C41CDCCCCCC63FE574100000000DC801C419A99995961FE574166666666CE801C41000000405EFE57419A999999D7801C41666666665BFE574166666666EA801C413333333358FE574133333333F7801C41CDCCCCEC53FE5741CDCCCCCCF4801C41CDCCCC4C4FFE57419A999999ED801C419A9999F947FE574133333333E3801C41666666E63FFE574166666666D6801C41333333B337FE57419A99999903801C410000000038FE574100000000FE7F1C413333331325FE5741CDCCCCCC46801C419A9999B924FE5741CDCCCCCC38801C41CDCCCC4C1AFE57419A9999992D801C413333331310FE5741CDCCCCCC52801C413333339306FE5741CDCCCCCC6E801C413333331300FE5741000000008C801C41CDCCCC4CF0FD5741000000006E801C4166666646EEFD57410000000030801C41CDCCCCCCEAFD574100000000FC7F1C41CDCCCC4CE7FD5741CDCCCCCCE27F1C41333333D3E2FD57419A999999E17F1C41CDCCCCECDBFD574166666666E87F1C41333333B3D5FD5741CDCCCCCCEC7F1C41000000E0CAFD574100000000E87F1C4133333373C2FD574133333333E97F1C4166666626BDFD57419A999999F77F1C4166666646B7FD57413333333311801C419A9999F9B1FD5741000000001E801C419A9999F9ABFD5741666666662A801C419A9999D9A3FD5741CDCCCCCC32801C419A9999B99CFD57410000000038801C419A9999D998FD57416666666674801C416666668693FD57413333333367801C419A9999597AFD5741CDCCCCCC18811C41CDCCCC0C72FD574166666666BE811C41000000C069FD57419A9999995B821C41000000805EFD57419A999999A1821C419A99991954FD5741333333337F821C410000004054FD5741000000001E821C41666666A657FD57410000000072811C41333333935DFD5741000000005E811C41333333335EFD5741CDCCCCCC14811C41333333535FFD57410000000072801C41666666A660FD574133333333B97F1C41CDCCCC8C62FD574166666666E27E1C41666666C664FD574100000000BA7E1C416666662665FD574166666666747E1C413333333365FD574100000000727E1C413333337365FD574133333333677E1C413333333366FD574166666666367E1C410000004067FD574166666666107E1C41CDCCCC8C67FD574100000000D27D1C413333337367FD574166666666BA7D1C416666662667FD574133333333997D1C419A99993966FD574133333333757D1C41CDCCCCCC65FD5741666666665C7D1C413333331366FD5741666666663C7D1C410000002067FD5741333333331B7D1C41CDCCCC4C68FD5741CDCCCCCC067D1C416666660669FD5741CDCCCCCCF07C1C419A99999969FD5741CDCCCCCCD47C1C419A9999B969FD574166666666C27C1C410000006068FD574100000000B27C1C41666666E666FD5741000000009E7C1C413333337365FD57419A9999997F7C1C416666668664FD57419A999999557C1C410000004064FD5741CDCCCCCC107C1C41CDCCCC4C64FD5741CDCCCCCCD27B1C416666660664FD574133333333957B1C416666660663FD574133333333617B1C419A9999D961FD57419A999999437B1C410000000061FD574100000000347B1C419A9999D960FD574166666666207B1C41CDCCCCEC60FD574166666666147B1C413333335361FD574166666666EA7A1C419A99997963FD5741CDCCCCCCC47A1C41000000A064FD574166666666367A1C41CDCCCCCC66FD574100000000EE791C41333333D367FD5741CDCCCCCCD4791C416666664668FD574133333333A9791C413333339369FD5741CDCCCCCC88791C41666666466BFD5741CDCCCCCC70791C41CDCCCC2C6DFD5741666666665C791C41CDCCCC6C6EFD57419A99999941791C41000000406FFD57419A99999925791C41000000606FFD5741333333330D791C419A9999196FFD574166666666CC781C419A9999F96DFD5741CDCCCCCC9C781C419A9999796DFD5741CDCCCCCC84781C419A9999996DFD57419A99999971781C41000000006EFD57419A99999967781C41333333936EFD57410000000060781C41CDCCCC4C6FFD57419A9999992D781C41000000E072FD5741666666661A781C410000008073FD57410000000004781C41000000C073FD574133333333EB771C416666660674FD574133333333A7771C419A99993974FD57413333333379771C41333333F374FD57416666666642771C413333331376FD574133333333D5761C413333339377FD5741000000009E761C41CDCCCCCC78FD5741666666667A761C41CDCCCC4C79FD57410000000062761C416666666679FD5741666666662C761C419A9999B978FD57413333333311761C41666666C678FD57419A999999FF751C41CDCCCC4C79FD5741CDCCCCCCEA751C41333333737AFD574100000000D8751C41333333F37BFD574166666666CC751C41CDCCCC6C7DFD574166666666AA751C41666666A680FD5741CDCCCCCC96751C41333333F382FD5741000000008E751C41666666A683FD5741000000007C751C41CDCCCCCC84FD5741CDCCCCCC60751C416666662685FD5741333333334B751C419A9999D984FD57419A9999992D751C419A99997984FD57416666666612751C41CDCCCC6C84FD574166666666F4741C416666666684FD574100000000E2741C41CDCCCC6C84FD5741CDCCCCCCCE741C419A9999B984FD574166666666BA741C416666662685FD5741CDCCCCCC9E741C410000002086FD5741CDCCCCCC78741C41666666C687FD57410000000038741C41666666668AFD57416666666636741C41333333738AFD57413333333311741C419A9999798CFD5741333333330B741C419A9999998DFD57413333333309741C41CDCCCCAC8EFD57419A99999909741C41000000E090FD5741CDCCCCCC0C741C41CDCCCCEC93FD57410000000006741C419A99999995FD574133333333FF731C419A99999997FD574133333333E7731C41000000A099FD574133333333CB731C41000000209CFD574133333333AD731C41000000A09EFD57413333333391731C41CDCCCC4CA1FD5741666666667E731C4166666606A3FD57416666666658731C41CDCCCC0CA5FD57410000000028731C419A9999F9A6FD57413333333301731C4133333333A8FD574100000000EC721C41CDCCCCCCA8FD57419A999999DD721C419A9999B9A9FD574166666666D2721C4100000040ABFD57419A999999C9721C419A999999ACFD574100000000BC721C4166666666AEFD574133333333AF721C4133333313B0FD574100000000A6721C41666666E6B0FD5741666666669A721C4133333373B1FD57419A99999989721C41333333F3B1FD57419A9999997F721C4133333353B2FD5741666666666E721C41333333F3B2FD57416666666654721C419A999919B4FD57419A99999945721C41CDCCCC0CB5FD5741CDCCCCCC3A721C4166666646B6FD57419A99999937721C41333333D3B7FD57419A99999939721C41333333F3B9FD5741666666663C721C41CDCCCC4CBBFD5741666666663C721C4166666666BDFD57419A99999939721C41333333D3C1FD57410000000036721C419A999919C4FD57416666666630721C4166666666C6FD5741000000002E721C4100000000C9FD5741666666662C721C4100000020CCFD5741000000002E721C419A999939CFFD57413333333331721C4133333333D1FD57419A99999931721C4100000020D2FD5741666666662E721C41333333D3D4FD5741000000002C721C41333333D3D6FD5741333333331D721C4166666626D8FD57419A99999905721C41CDCCCCECD8FD574166666666F8711C4166666666D9FD574100000000DE711C419A9999D9DAFD57419A999999BF711C41CDCCCC8CDCFD57416666666694711C41000000A0DEFD57410000000088711C41666666C6DEFD5741CDCCCCCC6A711C41333333B3DFFD5741000000005A711C4133333353E0FD57419A99999949711C419A999959E1FD57419A9999993F711C4100000080E2FD5741000000003C711C41666666E6E3FD57410000000038711C4133333313E5FD5741CDCCCCCC28711C419A999939E6FD57419A99999917711C41CDCCCCECE6FD57410000000000711C41666666A6E7FD5741CDCCCCCCEC701C4133333313E8FD574100000000E2701C4100000080E8FD574100000000C2701C41CDCCCC8CEAFD57419A99999975701C41CDCCCC4CF0FD57410000000054701C4100000060F3FD5741666666664C701C41000000A0F7FD57410000000036701C419A9999B9FAFD57413333333329701C41000000E0FBFD57419A999999E36F1C41CDCCCC0C00FE574100000000A86F1C41333333F302FE57419A999999636F1C41CDCCCC2C06FE5741333333334B6F1C413333335307FE5741000000003E6F1C419A99995908FE574133333333356F1C41333333B309FE5741CDCCCCCC306F1C41000000C00BFE574100000000306F1C41333333B30FFE5741CDCCCCCC346F1C413333333312FE5741666666663C6F1C41CDCCCC6C14FE574133333333476F1C419A9999B916FE574100000000446F1C410000004018FE574133333333376F1C41000000E019FE574166666666226F1C41000000601BFE5741000000008C6E1C41666666C624FE574100000000686E1C419A99993927FE574166666666146E1C41666666C62CFE57419A999999F96D1C41333333532FFE57419A999999EB6D1C413333337331FE57419A999999DF6D1C416666668633FE5741CDCCCCCCD46D1C413333339334FE574100000000C26D1C413333337335FE5741CDCCCCCCAE6D1C413333333336FE57419A999999876D1C419A99999937FE574100000000386D1C410000000039FE574100000000126D1C419A9999F938FE5741CDCCCCCCF46C1C410000002038FE574133333333D76C1C41000000E036FE574100000000CA6C1C416666664636FE5741CDCCCCCCAE6C1C41CDCCCCEC35FE5741CDCCCCCC406C1C41CDCCCC4C36FE5741CDCCCCCCF26B1C41666666E636FE57419A9999999F6B1C416666662639FE574166666666606B1C419A9999B93BFE5741CDCCCCCC126B1C41666666663EFE57419A999999C36A1C41000000A042FE5741666666669A6A1C41666666E644FE5741CDCCCCCC6A6A1C413333339348FE574100000000486A1C41000000404CFE57419A999999F3691C41CDCCCC6C55FE574100000000AC691C41666666C65EFE5741CDCCCCCC98691C41000000A061FE5741333333338B691C410000004063FE57419A99999971691C410000004064FE57416666666650691C419A9999F964FE57419A99999945691C413333335365FE5741CDCCCCCC40691C413333331366FE5741000000003E691C419A99991967FE5741666666662C691C41666666C667FE5741CDCCCCCC0A691C41333333D368FE5741CDCCCCCCF0681C41000000A069FE574166666666E0681C41CDCCCC6C6AFE574133333333DB681C41CDCCCC8C6BFE5741CDCCCCCCDE681C41CDCCCCAC6CFE574133333333EF681C419A99995970FE57419A999999E9681C419A9999D971FE574133333333DF681C410000004073FE57419A999999D9681C41CDCCCC8C74FE57419A999999D9681C419A9999F974FE574166666666E0681C419A99999976FE574133333333E9681C41CDCCCC8C77FE574133333333F1681C419A99991979FE574100000000F2681C419A9999D979FE574100000000E4681C419A9999197BFE574166666666B4681C41000000E07EFE57416666666648681C41666666A689FE5741666666662E681C41CDCCCC8C8CFE57410000000020681C41CDCCCC0C8EFE57413333333387661C41CDCCCC8C6DFE574166666666F8651C41000000C072FE5741CDCCCCCCF4641C419A9999F96BFE5741333333333D641C416666668688FE57416666666634641C416666664687FE57413333333321641C419A99997986FE574133333333C7631C41333333F384FE57416666666634631C413333331383FE574100000000E6621C41CDCCCC4C82FE57410000000048621C41666666C680FE574133333333EF611C413333331380FE57419A9999996F611C41000000207FFE57419A99999939611C41000000E07EFE57419A999999DF601C419A9999597FFE5741CDCCCCCCB8601C419A99995980FE574100000000A0601C41CDCCCC6C81FE5741000000008A601C41666666A681FE57413333333343601C41CDCCCC4C81FE574100000000DC5F1C416666666681FE5741CDCCCCCCA05F1C41CDCCCC0C82FE574100000000785F1C419A99999982FE57419A999999335F1C419A9999B982FE574133333333FB5E1C416666664682FE5741CDCCCCCC865E1C413333333380FE5741CDCCCCCC085E1C41333333F37DFE574166666666BE5D1C41000000407BFE57419A999999895D1C41CDCCCCEC78FE574166666666725D1C416666664677FE574100000000525D1C41CDCCCC6C75FE574133333333155D1C41CDCCCCCC71FE5741CDCCCCCCC05C1C41333333936EFE5741333333331B5C1C41000000C06BFE574166666666585B1C419A99995968FE5741CDCCCCCCDE5A1C41000000E065FE5741000000001C5A1C41666666A660FE574100000000F2561C416666660641FE574100000000F0551C410000002031FE5741CDCCCCCCE4541C413333339325FE574166666666CC541C41333333F323FE5741CDCCCCCC3C541C416666668616FE57413333333337531C41CDCCCCCCFFFD574100000000EE521C419A9999D9FAFD574100000000BE521C41CDCCCC4CF8FD57410000000090521C4100000080F4FD57416666666670521C41000000C0F1FD5741CDCCCCCC24521C41CDCCCCACECFD574133333333FF511C4100000020EAFD5741CDCCCCCC78511C41666666E6E5FD5741CDCCCCCC16511C419A999999E6FD574100000000BA501C41CDCCCCCCE3FD57416666666676501C4100000000E0FD5741CDCCCCCC42501C41CDCCCC4CDBFD57419A9999992F501C41CDCCCC8CD7FD57419A99999901501C4100000000D2FD574133333333D34F1C419A999979CCFD57419A999999A54F1C41333333F3C6FD574133333333774F1C4166666666C1FD574100000000484F1C41666666A6BCFD574133333333154F1C419A9999D9B6FD57419A999999134F1C41666666A6B6FD57419A999999E94E1C4100000040B2FD574100000000C04E1C4100000020AEFD57419A9999999B4E1C41CDCCCCACAAFD5741000000003E4E1C41CDCCCCACA4FD5741CDCCCCCCEA4D1C41CDCCCC6C9DFD5741CDCCCCCCAC4D1C410000006098FD574100000000644D1C419A99995993FD5741CDCCCCCC104D1C41666666C68BFD5741CDCCCCCCC44C1C41333333738DFD5741000000006E4C1C41CDCCCC8C8FFD574133333333254C1C419A9999F990FD57419A999999EB4B1C419A99993992FD57419A999999AD4B1C41000000A093FD5741666666664E4B1C419A99999995FD574133333333B74A1C41333333D398FD574100000000044A1C419A9999999CFD5741333333337F491C419A9999999EFD5741333333339D481C41CDCCCCECA0FD57419A999999D9471C41CDCCCC4CA1FD57416666666618471C41CDCCCC2CA0FD57419A999999C9441C419A9999B994FD574100000000DC441C41CDCCCC0C89FD574100000000E6441C416666668684FD574133333333F3441C41000000C081FD57419A99999905451C41333333137FFD5741000000000C451C41CDCCCC8C7EFD5741CDCCCCCC02451C41CDCCCC2C7EFD574166666666F4441C41000000E07DFD574166666666E8441C41000000E07DFD574166666666D6441C41666666267EFD574133333333AB441C41666666467FFD57410000000018441C41CDCCCCEC83FD574166666666A8431C419A9999D986FD5741CDCCCCCC2A431C413333333389FD574166666666EC421C41CDCCCC2C8AFD57416666666698421C41333333F38BFD57413333333369421C419A9999198DFD5741333333333D421C41000000A08EFD57413333333317421C419A9999D98FFD5741CDCCCCCC86411C41CDCCCC6C95FD5741000000002A411C413333339398FD574166666666EE401C419A9999799AFD574133333333B5401C41000000809CFD57419A99999983401C41333333339EFD57413333333357401C41000000C09FFD57419A99999925401C41333333F3A1FD57416666666618401C41000000C0A2FD574133333333E33F1C4100000020A3FD574133333333C33F1C419A9999F9A3FD5741CDCCCCCC9A3F1C4100000000A5FD5741CDCCCCCC623F1C41666666E6A5FD57419A999999433F1C4166666666A6FD5741666666660E3F1C4166666666A6FD57419A999999CF3E1C41666666C6A6FD5741CDCCCCCC983E1C41666666E6A6FD57419A999999793E1C41333333D3A6FD574100000000643E1C41333333D3A6FD574133333333453E1C41333333D3A6FD5741CDCCCCCC263E1C419A999939A7FD574133333333193E1C41666666A6A7FD5741CDCCCCCC9A3D1C41CDCCCC0CAAFD574133333333373D1C41CDCCCCACACFD574133333333CB3C1C4133333313B0FD574166666666963C1C41CDCCCC0CB3FD5741CDCCCCCC763C1C41666666A6B4FD574166666666523C1C4133333373B6FD57419A999999FF3B1C419A999999BBFD574133333333DB3B1C4133333353BEFD574166666666C23B1C4133333333C0FD574166666666B03B1C4133333393C1FD574166666666923B1C4166666686C4FD574166666666F63B1C41000000A005FE57419A9999994D3C1C41666666E608FE574100000000A63E1C410000000025FE574133333333C53F1C41666666E62BFE574166666666863F1C41CDCCCCAC36FE57419A999999873F1C41333333D347FE57419A999999073F1C41000000A055FE57419A999999473F1C41333333B36EFE5741000000007C3F1C41000000207CFE57419A9999993B401C41CDCCCCAC82FE574133333333D33F1C41333333F385FE5741CDCCCCCC643F1C413333339385FE57419A999999073F1C41000000C087FE574166666666CA3E1C41666666268DFE574166666666BC3E1C419A9999D991FE57419A999999A33E1C41CDCCCCCC94FE574100000000883E1C416666660699FE5741CDCCCCCC6E3E1C41666666E69DFE574133333333593E1C4100000000A4FE574133333333433E1C41CDCCCCECA9FE574133333333393E1C419A999979B2FE5741CDCCCCCC343E1C41CDCCCC4CBAFE574100000000303E1C41000000C0C0FE5741333333331D3E1C41333333F3C8FE574166666666123E1C4100000000CEFE574133333333053E1C4166666666D3FE5741CDCCCCCCF43D1C41CDCCCCACD9FE574133333333ED3D1C419A999999DFFE57419A999999DD3D1C419A999919E7FE574133333333C93D1C41CDCCCC6CF0FE5741000000009A3D1C41333333D3F7FE57419A999999C53C1C41000000600BFF574166666666B03C1C41666666260DFF574133333333A13D1C416666666618FF574100000000CE3E1C41000000C020FF5741CDCCCCCC5A3F1C41666666E626FF574166666666AC3F1C419A9999D934FF57419A9999998B421C416666662632FF57413333333381421C413333337334FF5741333333337B421C410000004038FF57413333333377421C41333333F33DFF5741CDCCCCCC7A421C413333335345FF57413333333375421C41CDCCCC4C4CFF57413333333371421C419A9999594FFF5741000000006E421C419A9999595AFF57416666666666421C41CDCCCC4C63FF5741000000005E421C413333333369FF5741CDCCCCCC50421C41666666A66EFF57419A99999933421C410000006075FF57416666666622421C413333331378FF5741CDCCCCCC00421C419A9999597CFF57419A999999E5411C41CDCCCCCC7FFF5741CDCCCCCCBE411C41000000A084FF574100000000A8411C416666660688FF574166666666A4411C41666666468AFF574133333333AB411C41000000C08CFF5741CDCCCCCCAE401C419A99993993FF57419A999999C1401C4133333393A1FF574100000000D2401C41000000C0B6FF574100000000D03F1C41CDCCCC0CC1FF5741CDCCCCCCB43E1C41CDCCCC4CCBFF57419A999999113E1C419A9999B9CAFF574133333333533D1C41666666E6D1FF574166666666A03C1C419A9999D9DBFF574133333333AD3A1C419A999959F5FF5741666666666C391C4166666606020058413333333383381C419A9999990A0058419A999999FD371C41000000A00F0058416666666694371C4133333333130058410000000028371C41333333131600584166666666DE361C419A9999B918005841CDCCCCCCCA361C419A9999D91D005841CDCCCCCC9A361C419A999959200058416666666656361C419A9999F9210058413333333301361C41666666C62300584166666666B4351C41333333D3260058419A9999994D351C41CDCCCC0C2A00584133333333FB341C41666666862C00584166666666AE341C41666666862E0058419A99999961341C41666666462F0058419A99999911341C41333333D32F00584166666666CA331C41CDCCCC4C31005841000000008C331C4133333353340058413333333345331C41666666A6390058410000000004331C41000000004000584100000000B2321C419A9999D9450058410000000076321C410000004046005841666666662C321C41666666E64400584166666666E8311C41CDCCCCEC4A005841666666664A311C41333333D35600584133333333B9301C41333333F35D0058419A99999903301C41666666E66700584133333333B12F1C41333333136A005841333333337B2F1C41666666466D00584133333333512F1C41CDCCCC2C710058419A999999152F1C41333333F372005841CDCCCCCCC22E1C41333333B37300584166666666862E1C4133333373740058419A9999996F2E1C41666666667600584166666666FC2D1C41333333938200584166666666602D1C41333333939400584166666666002D1C41CDCCCC0C9C00584100000000682C1C4166666666B4005841CDCCCCCCA82A1C4166666666D90058413333333375291C41CDCCCC6CF3005841CDCCCCCCA8281C41333333330001584133333333B5271C4100000040160158416666666602271C41333333732A015841000000000E261C41000000C03D01584100000000DA251C41CDCCCC4C4401584100000000C6251C41333333134C01584166666666BE251C419A9999D94E015841	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	01010000206A080000348D2DFE78791C4100000030BD015841	320010000	Z	Aignan	3200100	32001	32	76	32
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	01010000206A0800005828148AC1D21F41CDCCCC9C86FE5741	320020000	Z	Ansan	3200200	32002	32	76	8
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	01010000206A080000B21E856B1C2B1E41000000002C045841	320030000	Z	Antras	3200300	32003	32	76	7
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	01010000206A080000111111115A161B410000008021035841	320040000	Z	Arblade-le-Bas	3200400	32004	32	76	8
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	01010000206A08000056341B127DB31B419A999939CA065841	320050000	Z	Arblade-le-Haut	3200500	32005	32	76	12
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	01060000206A08000001000000010300000001000000C500000000000000555F2041333333F31E035841000000000E6020419A9999D937035841CDCCCCCC56602041000000004303584100000000EE602041333333D35603584100000000636220419A9999398D035841333333336B622041CDCCCC2C96035841CDCCCCCC616220419A9999799E035841000000002262204133333313B703584100000000236320419A999919B20358416666666691632041666666A6B003584166666666A0632041333333B3C3035841000000005C642041000000A0B90358419A9999990465204166666626AF035841CDCCCCCC376520419A999979BF0358419A9999994E652041CDCCCC0CC90358413333333394652041000000E0EF0358419A999999D2652041666666E605045841CDCCCCCC496620419A9999592804584166666666736620416666664632045841CDCCCCCC9A6620419A999919390458416666666607672041000000A048045841CDCCCCCC5C6720413333333359045841CDCCCCCC8A672041CDCCCCCC6004584166666666E56720419A9999996B045841333333330D682041CDCCCC2C740458413333333307682041333333338004584133333333F3672041333333138A0458419A999999D36720419A999939910458419A99999971672041333333939B0458419A9999995E67204100000060A0045841666666665967204166666646AA04584166666666C8672041CDCCCCACAA0458413333333302682041CDCCCC2C9F045841CDCCCCCC0568204166666606930458419A9999990F682041666666E68F045841CDCCCCCC946820419A999939780458419A99999904692041333333D362045841333333333E69204100000040550458419A99999956692041CDCCCC6C5204584133333333EE692041CDCCCC2C3104584100000000056A2041666666A629045841CDCCCCCC776A2041CDCCCCEC1004584133333333566B2041666666A6E7035841CDCCCCCC426C2041333333B3D003584166666666C46C2041CDCCCC4CC50358419A999999F76C204100000080C203584166666666486D2041333333F3B8035841CDCCCCCCC46D2041666666E6A80358419A999999036E204133333373A2035841CDCCCCCC876E2041000000E090035841CDCCCCCC5A6F2041CDCCCCAC73035841666666669E6F2041CDCCCC2C6C03584100000000E46F20416666662668035841333333332B702041666666A666035841000000008A7020419A9999D9620358419A999999307120419A9999D960035841CDCCCCCCD1712041CDCCCCAC60035841CDCCCCCC62722041333333B35D035841CDCCCCCC0E7320419A9999F95703584166666666577320413333337353035841CDCCCCCC87732041333333D35103584133333333BA732041000000C048035841CDCCCCCCF7732041333333734403584133333333C674204100000040180358419A999999D67420419A9999D91103584133333333D37420419A99995908035841CDCCCCCCDD742041333333D3030358419A99999900752041000000A0FF025841333333333C752041CDCCCC2CF0025841666666663B75204100000000EC0258413333333311752041666666C6E40258410000000016752041333333B3DC0258416666666672752041333333F3CD025841000000007875204166666626CB0258419A999999DC752041333333D3BE0258419A9999990A76204133333373BC0258410000000094762041666666C6B802584133333333D4762041666666E6B4025841CDCCCCCCC27720419A9999D9AF025841333333330C782041333333B3AC025841333333337B782041CDCCCC8CA60258419A999999A678204133333333A20258416666666610792041000000409C0258413333333370792041CDCCCCEC8C025841333333339A79204133333313850258419A999999087A20416666664673025841CDCCCCCC517A2041000000E06D02584166666666157C204100000020580258419A999999D07C20419A9999194E025841333333333D7D2041CDCCCC4C4A0258419A9999999D7D2041333333B34502584166666666ED7D2041CDCCCC4C430258419A999999257E2041333333533F0258419A999999778020419A999919FD0158419A999999758020419A9999B9F7015841CDCCCCCC58802041CDCCCCCCE3015841666666663B80204100000020DF015841666666668B7F204133333353CD01584100000000217F204100000020C40158419A9999990F7F20419A999999C001584133333333AB7E204133333393B301584166666666A37E20419A999999AD0158419A9999996A7E2041CDCCCCCCA401584166666666767E2041666666269D01584133333333D87E2041333333738D01584100000000067F2041000000608301584166666666177F2041666666467A015841CDCCCCCC147F2041333333B365015841333333334E7F2041666666A65A01584100000000F27F2041000000003901584166666666288020416666662632015841333333336F802041000000A025015841333333339D802041CDCCCCEC1101584166666666B9802041666666260B01584100000000E280204100000020FA00584100000000E4802041333333D3F400584133333333C6802041333333F3F4005841000000006280204166666626F0005841666666666D7F2041666666C6CC00584100000000067F204100000040C1005841666666664A7E204100000040A000584166666666017E2041CDCCCCAC940058419A9999992D7D204100000020A700584166666666AE7C2041666666C6AE00584133333333807B2041333333D3BE0058419A999999C87A20419A9999D9C7005841CDCCCCCC937A20419A999939C90058419A999999D379204166666646C90058419A999999ED7820419A999979C800584133333333957820419A999999B2005841333333337578204166666686A9005841666666660F7820410000006090005841CDCCCCCCE2772041666666A681005841666666666D77204166666646630058419A999999517720419A9999395F00584166666666DE76204100000000600058416666666670762041CDCCCCAC3F005841CDCCCCCC62762041000000C0380058419A99999909762041666666463F0058413333333374752041CDCCCC6C4400584166666666497420419A999979510058419A999999BD73204100000020540058419A99999974722041333333735E005841666666666F7120419A9999B9630058419A9999990870204133333393700058419A9999997D6F2041333333B37F005841333333335D6E20419A9999F992005841CDCCCCCC916D2041666666C69900584100000000346D2041333333939E00584133333333FE6C204166666606A300584133333333636C2041333333B3B30058419A999999196C20419A999959BA0058419A9999996B6B204166666666C8005841CDCCCCCC0B6B204166666626D500584166666666296A2041000000600D015841CDCCCCCCC76920410000004028015841333333339C692041666666E6390158416666666699692041333333134301584166666666AD692041333333D34D01584100000000CE692041CDCCCCCC57015841CDCCCCCC116A2041CDCCCCEC6201584166666666526A2041000000607601584166666666C66A2041000000C09D01584100000000EA6A2041666666A6A401584133333333366B204133333353A7015841666666668E6B2041CDCCCC8CAC01584133333333AB6B204133333393B301584133333333766B2041333333B3BF0158419A999999796B204100000040C901584100000000436B2041000000E0E801584133333333256B204133333333FE015841000000000E6B20416666662615025841CDCCCCCC146B20416666668632025841333333330E6B2041333333D33B02584100000000E06A20419A9999995602584100000000CA6A20419A9999396A025841CDCCCCCCE3692041CDCCCC2C6902584133333333AF692041666666C671025841CDCCCCCC4B692041333333537102584133333333EE68204166666606730258416666666686682041CDCCCCCC77025841CDCCCCCC64662041333333B3920258413333333341662041333333F3930258413333333304662041333333F3900258419A999999DC652041CDCCCCCC8902584133333333AF652041666666867E0258419A999999D6642041666666C68B0258419A9999997963204166666646A30258419A99999970622041CDCCCCACB6025841333333337861204133333313C80258413333333313612041333333B3C402584166666666096120419A9999F9C80258419A9999992F60204166666626F702584100000000DD5F2041CDCCCCEC0A0358419A999999AB5F2041CDCCCC0C1303584100000000555F2041333333F31E03584100000000555F2041333333F31E035841	01010000206A08000042E28E90E4712041CCCCCCBC71025841	320070000	Z	Ardizas	3200700	32007	32	76	9
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	01010000206A080000909DD8098B641C419A9999D975EE5741	320080000	Z	Armentieux	3200800	32008	32	76	5
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	01010000206A08000026E402D432E01C41CCCCCCAC86F35741	320090000	Z	Armous-et-Cau	3200900	32009	32	76	9
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	01010000206A0800006E85E202ABC01E41000000109CDB5741	320100000	Z	Arrouède	3201000	32010	32	76	7
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	01010000206A080000C349DFFAF7D91F41CCCCCCBCCDFA5741	320120000	Z	Aubiet	3201200	32012	32	76	39
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	01060000206A08000001000000010300000001000000260000000000000038CE1E419A999939EEFA574100000000C4CE1E4166666666F9FA5741CDCCCCCC1CCF1E41666666C6F4FA574100000000BCCF1E413333333300FB574133333333F9D01E4100000040F3FA5741000000006CD11E419A999939F4FA57419A999999A1D21E419A9999F90EFB57419A9999991BD31E419A9999990AFB57416666666680D31E41CDCCCCEC09FB574100000000A6D51E419A99997910FB5741666666662AD71E416666666617FB5741000000001AD71E419A9999590DFB5741333333330DD81E41CDCCCCCC07FB57416666666614D81E410000006005FB574100000000D2D91E419A9999F9FAFA574166666666AEDA1E4166666626F5FA5741CDCCCCCC40DA1E419A9999F9F1FA5741CDCCCCCC96D91E4100000060D4FA57416666666656D91E419A999959C7FA57419A99999929D91E4100000080C1FA57419A99999923D81E416666660696FA5741333333339DD71E41333333F37CFA57419A9999990DD71E41CDCCCC2C64FA57416666666682D51E419A99997971FA57419A999999F5D41E410000006075FA574100000000DCD31E41666666C683FA57419A999999FBD21E41666666068AFA574133333333D3D21E41000000008FFA57416666666690D11E419A99999992FA5741CDCCCCCC32D11E41666666E68FFA57416666666642D11E419A99997996FA574100000000B2D01E41666666E699FA574133333333D5CF1E4100000020ADFA5741CDCCCCCC22CF1E4166666606B7FA574100000000A8CE1E41CDCCCC8CD6FA57410000000066CE1E4100000020EAFA57410000000038CE1E419A999939EEFA57410000000038CE1E419A999939EEFA5741	01010000206A080000F4F61B6B0ED41E4100000090BFFA5741	320130102	H	Centre Haute Ville	3201301	32013	32	76	0
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	01010000206A0800008EC7D50441DF1E4166666696F7F85741	320130401	A	Zone d'Activités Sud	3201304	32013	32	76	5
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	01060000206A080000010000000103000000010000001F000000CDCCCCCC8ED71E41CDCCCC8C61FA5741666666663CD81E410000000082FA57419A999999C3D71E41000000C084FA57419A99999923D81E416666660696FA57419A99999929D91E4100000080C1FA57416666666656D91E419A999959C7FA5741CDCCCCCC96D91E4100000060D4FA5741CDCCCCCC40DA1E419A9999F9F1FA574166666666AEDA1E4166666626F5FA5741000000004ADE1E419A999979DDFA574166666666B6DE1E41333333D3E0FA5741CDCCCCCCDADE1E4100000060DEFA57413333333311E01E419A999939E5FA57419A999999A1E21E4166666626F5FA574133333333F1E21E419A999999EBFA574166666666DAE21E4133333353DEFA5741CDCCCCCCCCE21E4166666666C0FA57410000000084E21E41CDCCCC6C87FA57410000000038E21E419A9999D93FFA57416666666620E21E419A9999D938FA57413333333393E11E41333333931EFA5741CDCCCCCC62E11E416666662617FA5741CDCCCCCCA0DD1E413333331338FA57419A99999957DD1E419A9999F938FA57419A9999990BDC1E41CDCCCC0C3AFA5741CDCCCCCC58DA1E41CDCCCCAC3DFA5741000000007ED91E41CDCCCCCC51FA57413333333353D91E419A9999B957FA57419A999999C9D81E419A9999995BFA5741CDCCCCCC8ED71E41CDCCCC8C61FA5741CDCCCCCC8ED71E41CDCCCC8C61FA5741	01010000206A08000024C844A726DD1E416666661686FA5741	320130101	H	Centre Basse Ville	3201301	32013	32	76	0
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	01010000206A0800005C47206A5DD21E41333333E31EFA5741	320130201	H	Faubourg Sud-Ouest	3201302	32013	32	76	2
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	01010000206A080000D8D5D5D5C0CD1E416666661618FC5741	320130202	H	Faubourg Nord-Ouest	3201302	32013	32	76	3
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	01010000206A080000762A9C47FFE11E419A9999D9C6FB5741	320130203	H	Faubourg Nord	3201302	32013	32	76	1
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	01010000206A080000A87D3F1DB6F11E41333333939FFA5741	320130204	H	Faubourg Ouest	3201302	32013	32	76	2
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	01060000206A080000010000000103000000010000002A0000003333333365DB1E41000000C091F957416666666610DC1E41CDCCCCACA3F957410000000034DD1E4166666686BEF957419A9999999DDE1E4133333333D8F9574166666666BCDE1E419A9999B9D6F957419A9999998FE01E419A999919F6F9574133333333FFE01E41333333D3FEF95741CDCCCCCCD0E11E41000000E00CFA574133333333B9E21E41000000800AFA57419A999999C9E31E419A9999D901FA574166666666D0E41E41CDCCCC2CF8F95741CDCCCCCC2EE51E419A999979F3F957413333333353E61E41CDCCCCCCDEF95741CDCCCCCCD8E61E4133333393D8F95741CDCCCCCC3CE81E41CDCCCCACCCF95741333333332DE71E416666662693F957416666666684E61E41333333D359F95741333333330FE61E41CDCCCC8C48F95741CDCCCCCCDAE51E41333333334DF9574166666666A6E51E413333339343F9574166666666CEE41E41333333732FF957410000000052E31E416666662637F95741666666666EE21E413333333341F9574166666666B6E11E41333333B346F9574133333333B7E11E41000000204BF957419A999999F5E11E416666664659F957419A999999B5E11E41CDCCCC4C5DF957416666666672E11E41666666A657F9574133333333A1E01E41333333F33FF9574100000000EADF1E41000000A043F95741CDCCCCCC4EE01E41000000405DF957419A99999967DF1E410000006061F957413333333361DF1E41333333736FF957419A999999F5DE1E41CDCCCC8C73F9574100000000DCDE1E419A99993977F957419A99999903DF1E41333333737BF9574166666666D2DE1E410000002083F9574133333333B7DE1E41000000C08CF95741666666668CDD1E413333333391F957416666666664DD1E41333333B388F957413333333365DB1E41000000C091F957413333333365DB1E41000000C091F95741	01010000206A080000B5090C139FE11E41CDCCCC3C9EF95741	320130301	H	La Hourre	3201303	32013	32	76	0
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	01060000206A08000001000000010300000001000000180000006666666642D91E413333339341F95741CDCCCCCC3EDA1E41CDCCCC4C68F957419A99999987DA1E419A99999971F957413333333365DB1E41000000C091F957416666666664DD1E41333333B388F95741666666668CDD1E413333333391F9574133333333B7DE1E41000000C08CF9574166666666D2DE1E410000002083F957419A99999903DF1E41333333737BF9574100000000DCDE1E419A99993977F957419A999999F5DE1E41CDCCCC8C73F957413333333361DF1E41333333736FF957419A99999967DF1E410000006061F95741CDCCCCCC4EE01E41000000405DF9574100000000EADF1E41000000A043F9574133333333A1E01E41333333F33FF957410000000030E01E41CDCCCC6C34F957419A99999991DF1E419A9999992BF95741CDCCCCCC46DE1E419A99995925F9574133333333D9DD1E41333333B324F957413333333343DD1E41000000C026F9574133333333E7D91E41CDCCCCAC3DF957416666666642D91E413333339341F957416666666642D91E413333339341F95741	01010000206A080000CBF8844E14DD1E419A9999C95AF95741	320130302	H	Garros	3201303	32013	32	76	0
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	01010000206A080000604835AF92F91E4100000070ECFB5741	320130501	A	Zone d'Activités Quartier Nord-Est	3201305	32013	32	76	6
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	01010000206A0800000825C190CB8B1E4166666676E2FA5741	320130601	H	Auch Rural	3201306	32013	32	76	52
01060000206A0800000100000001030000000100000033010000CDCCCCCC02AD1F4133333393AE025841CDCCCCCCCCAD1F4133333333CB0258419A9999993DAD1F419A9999F9CF02584133333333D7AD1F41666666A6F0025841666666669AAE1F41CDCCCC2C1D035841CDCCCCCCEEAE1F41333333D31B035841000000005AAF1F41000000201B0358419A999999C1AF1F41333333531A0358413333333359B01F41CDCCCC4C180358419A99999905B11F41333333B315035841CDCCCCCC9CB11F416666662614035841CDCCCCCC3AB21F41333333131303584100000000F4B21F419A9999791103584166666666D8B31F4100000020100358419A99999947B41F419A9999590F0358419A9999995BB41F41000000001E035841333333330FB51F41666666661B03584100000000EAB51F41CDCCCC4C1603584133333333A1B61F419A9999B94103584133333333E5B61F4166666666400358413333333383B71F41333333733D03584100000000B8B71F41000000E03C035841CDCCCCCCECB71F41666666E63C0358416666666624B81F41333333933D0358410000000046B81F41333333333D0358419A99999985B81F41333333333C03584133333333EBB81F41666666463A0358416666666646B91F41CDCCCC4C380358419A9999998FB91F419A9999D9350358419A999999D7B91F4133333313340358410000000038BA1F419A9999B9320358419A999999D7BA1F41333333F32D035841CDCCCCCC50BB1F41CDCCCCCC34035841333333332FBC1F41666666E6490358413333333367BC1F419A9999D94D0358419A999999BBBC1F419A9999595A035841333333339BBD1F41666666A67F0358419A999999E5BD1F41333333537B035841333333334DBE1F41666666067503584166666666A0BE1F41CDCCCC4C7003584166666666E4BE1F41333333336B035841333333331DBF1F41333333F366035841000000003EBF1F419A999939640358416666666684BF1F41000000E05E03584133333333E7BF1F4133333353560358413333333345C01F41CDCCCC4C4E035841000000008CC01F41666666264803584166666666C8C01F419A9999F94203584133333333E9C01F41666666863F035841CDCCCCCC04C11F41000000203C0358410000000020C11F41CDCCCC4C38035841CDCCCCCC32C11F41CDCCCCEC330358419A9999994FC11F41CDCCCCAC2D0358419A9999996BC11F419A999919260358419A9999997DC11F41666666861F035841CDCCCCCC86C11F419A9999591A035841CDCCCCCC92C11F41CDCCCC4C1103584100000000A6C11F41CDCCCCCC0503584133333333A9C11F41CDCCCC2C0403584166666666D4C11F419A999979050358416666666604C21F41333333B3070358416666666610C21F413333335309035841666666661AC21F41666666660B0358419A9999992FC21F41666666060C035841000000007AC21F41333333930C03584133333333C7C21F41CDCCCC2C0D0358413333333309C31F419A9999590D035841CDCCCCCC4EC31F419A9999390E0358419A9999999DC31F41000000201003584133333333DFC31F41CDCCCCCC10035841CDCCCCCC26C41F419A9999D910035841CDCCCCCCCCC41F41CDCCCCEC0D035841000000003EC51F41333333B30B0358419A99999993C51F419A9999B90A035841666666660EC61F41CDCCCC6C0A035841CDCCCCCC6EC61F41333333B30A0358419A999999C1C61F419A9999F90C0358413333333309C71F41333333730D0358419A99999973C71F41CDCCCCCC0E03584100000000A4C71F41CDCCCC4C1003584166666666F0C71F41CDCCCC8C140358419A99999925C81F41CDCCCCCC170358416666666644C81F41333333F31A035841CDCCCCCC56C81F419A9999391E0358419A9999995DC81F419A9999B9210358416666666662C81F41CDCCCCAC24035841000000006EC81F41000000E026035841666666667AC81F4133333333290358410000000082C81F41333333532B0358413333333397C81F41666666462E035841CDCCCCCCB4C81F41000000403103584166666666CEC81F4100000040330358419A999999EDC81F41000000C034035841CDCCCCCC3EC91F419A9999993503584100000000AAC91F41CDCCCC0C36035841CDCCCCCC1ECA1F41333333F336035841333333336DCA1F41CDCCCCEC360358419A999999F3CA1F416666666636035841000000003ACB1F416666662636035841CDCCCCCC8ECB1F419A9999D935035841CDCCCCCCC4CB1F41CDCCCC4C360358419A999999FBCB1F41CDCCCCAC370358413333333365CC1F41000000803B035841CDCCCCCCCACC1F419A9999393F0358419A9999990FCD1F410000008042035841333333333DCD1F41CDCCCC4C450358419A99999965CD1F41CDCCCC2C480358410000000098CD1F41333333134B03584133333333FDCD1F41000000004F0358419A99999949CE1F410000006052035841CDCCCCCC6CCE1F4166666646540358413333333387CE1F416666662655035841CDCCCCCCDACE1F41CDCCCCAC55035841CDCCCCCC4CCF1F41000000205603584166666666A2CF1F41333333135603584166666666C0CF1F41CDCCCC6C560358419A999999E1CF1F4133333393570358413333333311D01F41CDCCCCAC59035841000000002ED01F419A9999595B0358416666666662D01F41666666265F03584166666666ACD01F41000000C0640358419A999999E1D01F41000000C069035841CDCCCCCCF4D01F41CDCCCCAC6C035841CDCCCCCCF8D01F41000000206E03584133333333FDD01F41666666C66F0358413333333301D11F410000004073035841CDCCCCCC0AD11F41CDCCCCAC750358413333333325D11F419A9999F9790358416666666638D11F41000000C07B0358419A99999967D11F419A9999397F03584100000000C2D11F419A9999D9840358419A9999993FD21F41CDCCCC0C8C035841CDCCCCCC90D21F41333333B38F0358419A999999FBD21F41666666A693035841CDCCCCCC5ED31F41CDCCCCAC960358410000000000D41F419A9999B99B0358419A999999A7D41F4100000060A103584166666666D0D41F41000000E0A20358416666666618D51F41000000C0A4035841CDCCCCCC46D51F41CDCCCC2CA60358410000000062D51F4100000000A80358410000000082D51F4166666626AB0358416666666694D51F41CDCCCC8CAC03584166666666AAD51F4133333373AD03584133333333D3D51F41333333D3AD0358413333333343D61F4133333373AE03584100000000A8D61F4100000040AF03584100000000DAD61F41CDCCCCACAF035841CDCCCCCCF2D61F41333333F3AF0358419A999999F9D61F419A999979B0035841CDCCCCCC04D71F4100000000B1035841CDCCCCCC1CD71F419A999999B10358416666666650D71F4133333313B203584166666666AED71F4166666606B20358413333333301D81F4100000020B20358419A99999939D81F4166666666B20358413333333379D81F4166666646B3035841CDCCCCCCF6D81F41CDCCCC0CB50358416666666668D91F4166666666B60358419A999999B1D91F4166666686B60358416666666604DA1F41CDCCCC0CB60358419A99999931DA1F4166666626B6035841666666666CDA1F4133333313B7035841666666669CDA1F41666666E6B8035841CDCCCCCCE2DA1F419A999919BC0358419A99999915DB1F41666666E6BE0358413333333365DB1F419A9999F9C303584133333333C3DB1F4133333373C9035841000000000EDC1F4133333373CC035841CDCCCCCC84DC1F41000000C0CE0358410000000000DD1F41333333B3D00358419A99999989DD1F41CDCCCCCCD2035841CDCCCCCCF6DD1F4100000060D50358419A9999995FDE1F4133333333D603584166666666ACDE1F4166666626D60358413333333307DF1F4166666666D7035841000000008CDF1F4100000080D903584166666666F2DF1F41CDCCCC2CDA0358419A99999933E01F4166666606DA03584133333333C1E01F41CDCCCCECBE035841CDCCCCCC84E01F4133333373BC035841CDCCCCCC20E11F41666666A69F0358419A9999995BE11F4166666666940358419A99999991E11F410000004081035841CDCCCCCC4CE21F4133333313690358419A999999EFE11F419A9999B955035841CDCCCCCCD0E11F41666666665603584133333333B1E11F413333339356035841333333337FE11F419A999999560358416666666648E11F41000000005503584100000000AAE01F41666666A6500358419A9999995BE01F41666666664E0358416666666626E01F419A9999794C03584166666666FCDF1F41333333334A03584100000000C0DF1F41CDCCCCEC470358410000000096DF1F41333333D3450358410000000080DF1F41CDCCCC6C410358416666666672DF1F41000000003D0358413333333345DF1F41333333D33603584133333333B5DE1F416666660626035841333333337DDE1F4166666626210358419A99999945DE1F41666666661D035841000000002EDE1F41666666661D0358419A999999F9DD1F419A9999991D035841CDCCCCCCC2DD1F41CDCCCC4C1E0358413333333357DD1F41000000001F035841CDCCCCCCBCDC1F41666666E61F0358419A99999995DC1F41000000C01F0358419A99999951DC1F41CDCCCCCC1E035841CDCCCCCCB8DB1F41CDCCCC4C1B0358419A99999947DB1F419A9999B91703584133333333FBDA1F41CDCCCC2C140358413333333397DA1F41666666C6100358410000000038DA1F419A9999990A035841CDCCCCCC40D91F419A9999B9F8025841CDCCCCCCD6D81F41CDCCCCCCF0025841CDCCCCCC5CD81F4100000080E8025841CDCCCCCC44D81F4100000060E40258413333333341D81F4133333353E00258419A9999992BD81F41CDCCCC4CDE0258419A99999907D81F41CDCCCCECDA025841000000008AD71F419A999999D50258413333333317D71F41333333B3CD0258419A99999981D61F419A999919C3025841666666662AD61F41666666A6BC0258413333333303D61F41666666C6B9025841CDCCCCCCE0D51F419A999959B80258419A99999999D51F41666666E6B70258419A99999945D51F41CDCCCCCCB70258416666666610D51F41000000A0B702584133333333DDD41F41CDCCCC6CB6025841000000009AD41F419A999999B20258419A99999913D41F41666666C6A702584166666666CCD31F41000000A0A20258419A999999A3D31F41666666869F025841CDCCCCCC88D31F41333333739E0258416666666658D31F41000000409D0258419A99999903D31F41333333D39902584133333333CBD21F419A9999F99602584166666666A6D21F410000006093025841CDCCCCCC84D21F41CDCCCCCC8E0258413333333343D21F41CDCCCC8C8902584166666666F2D11F41666666E685025841CDCCCCCC92D11F410000008081025841333333334DD11F41666666267E02584166666666C0D01F41CDCCCCEC780258419A9999999BD01F41CDCCCC4C71025841333333337DD01F41666666A6690258410000000072D01F41CDCCCC8C620258419A99999983D01F419A9999595E025841CDCCCCCCCAD01F41CDCCCCAC570258413333333331D11F41CDCCCC2C4E02584100000000AED11F41CDCCCC2C420258419A99999913D21F4166666646390258419A99999985D21F419A9999B9330258419A999999BDD21F41CDCCCC6C2F025841CDCCCCCCE8D21F41CDCCCC6C290258416666666624D31F41000000E0200258419A9999995BD31F41CDCCCC0C190258419A99999989D31F41000000201402584133333333D9D31F41000000000E025841CDCCCCCC26D41F419A9999F909025841000000004CD41F4166666666080258416666666628D31F4133333353FD0158419A99999901D01F41CDCCCC8CE30158419A999999D5CE1F41666666E6DA015841CDCCCCCCA2CD1F419A999979D40158416666666672CC1F41333333B3CE0158416666666620CB1F4133333313C90158410000000040C91F4133333353C401584133333333FBC61F4100000060B90158419A99999947C31F41CDCCCC8CAA01584133333333EFBD1F41CDCCCC8C950158410000000094BC1F4166666686AA0158413333333351B91F41CDCCCC6CCA0158419A999999D9B81F4100000000CD015841CDCCCCCC2AB81F4133333393CD01584166666666FCB61F4133333393CC0158413333333393B51F41666666C6CA0158419A99999917B51F41000000C0D3015841CDCCCCCC66B41F41CDCCCC4CEA015841333333338BB21F4166666686080258419A9999993BB21F41CDCCCC4C0C0258410000000010B11F41333333131D0258419A9999992FB11F419A9999F923025841CDCCCCCC52B11F41666666462E0258413333333359B11F4100000000330258416666666644B11F41333333F3350258419A9999991DB11F419A9999B93C02584100000000FCB01F41333333B341025841CDCCCCCCD2B01F41000000E044025841333333337DB01F41666666E6480258413333333359B01F41CDCCCCCC4B025841000000002EB01F4166666686500258419A99999913B01F4133333333550258416666666610B01F419A999939590258416666666612B01F410000008063025841CDCCCCCC10B01F410000002065025841CDCCCCCC0EB01F419A99993969025841CDCCCCCCF4AF1F41000000006A0258413333333325AF1F41CDCCCC2C700258410000000096AE1F41CDCCCCAC740258416666666678AE1F41000000A075025841666666666EAE1F41666666A67C02584100000000F8AD1F419A9999B98E025841CDCCCCCC64AD1F41CDCCCC0CA2025841CDCCCCCC02AD1F4133333393AE025841	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	01010000206A080000A6E2FEEC59C11F419A9999D9B7025841	320140000	Z	Augnax	3201400	32014	32	76	4
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	01010000206A0800002B64218B07611E413433332367DD5741	320150000	Z	Aujan-Mournède	3201500	32015	32	76	9
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	01010000206A0800000C9ED6B3CC9D2041000000B07DF05741	320160000	Z	Auradé	3201600	32016	32	76	22
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	01010000206A080000B2320BCF91F31A413433338305FA5741	320170000	Z	Aurensan	3201700	32017	32	76	6
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	01010000206A080000B903945F20022041000000E074F15741	320180000	Z	Aurimont	3201800	32018	32	76	8
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	01010000206A080000968E458F1C111F41CDCCCC4C27F35741	320190000	Z	Auterive	3201900	32019	32	76	11
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	01010000206A08000056CA42A577301D413333335340E55741	320200000	Z	Aux-Aussat	3202000	32020	32	76	13
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	01010000206A0800005C56FA77C737204100000030E60D5841	320210000	Z	Avensac	3202100	32021	32	76	5
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	01010000206A080000181EDC69D54A1C41333333C334085841	320220000	Z	Avéron-Bergelle	3202200	32022	32	76	15
01060000206A0800000100000001030000000100000093020000666666661ED81F419A9999D9511458410000000020D81F41CDCCCCCC531458410000000042D81F419A999959571458410000000060D81F419A9999795D1458410000000078D81F41333333B3611458410000000084D81F41000000A062145841CDCCCCCC9AD81F4133333333641458419A999999B3D81F41666666866514584133333333D1D81F419A9999996614584100000000F4D81F419A999959671458419A9999990DD91F41666666E667145841CDCCCCCC1ED91F416666664668145841000000002ED91F41000000A0681458419A99999953D91F41333333136A145841CDCCCCCC66D91F41000000806B1458416666666674D91F419A9999196D145841333333337DD91F419A9999B96E1458416666666684D91F41CDCCCC8C711458419A9999997DD91F419A9999F974145841333333336FD91F41666666A6761458413333333349D91F419A9999F9781458413333333321D91F41CDCCCCCC7A14584133333333EBD81F41000000C07C1458410000000032D91F4133333333831458410000000016DB1F4133333353AA1458410000000012DB1F41000000E0AC1458419A99999915DB1F4166666666B11458416666666620DB1F4100000060B8145841CDCCCCCC26DB1F4166666646BE1458413333333329DB1F41333333B3C51458413333333335DB1F419A999959CD1458416666666642DB1F4133333353D21458410000000052DB1F41CDCCCCACD91458419A9999996DDB1F4133333313DF1458413333333393DB1F41666666A6E414584133333333A1DB1F4133333393E414584133333333D1DB1F41333333B3E414584100000000F6DB1F41000000E0E4145841CDCCCCCC60DC1F4100000080E61458410000000088DC1F419A999919E714584133333333BFDC1F419A9999B9E714584166666666ECDC1F41CDCCCCCCE7145841CDCCCCCC20DD1F419A9999D9E71458416666666660DD1F41666666C6E7145841CDCCCCCC72DD1F41333333B3E7145841333333339BDD1F4166666686E71458419A999999E7DD1F41CDCCCC0CE71458419A99999969DE1F41CDCCCC6CE61458419A999999D1DE1F41000000E0E51458410000000034DF1F419A999979E5145841666666668ADF1F41CDCCCC8CE414584133333333BBDF1F4100000080E31458413333333307E01F41333333D3E014584166666666A6E01F419A999979DC145841CDCCCCCCFEE01F4133333393D91458416666666622E11F41CDCCCCCCD61458410000000034E11F41666666E6D31458419A9999994DE11F4166666606D11458419A9999995DE11F419A9999B9CC1458419A99999971E11F4133333313CA145841CDCCCCCCA4E11F41333333B3C714584166666666F0E11F419A999959C7145841666666660EE21F41CDCCCC6CC81458410000000010E21F41333333B3C71458419A99999917E21F4100000020C71458410000000022E21F41333333B3C61458419A9999992DE21F4133333393C61458419A99999941E21F41CDCCCCACC61458416666666666E21F41000000E0C61458416666666692E21F4100000040C714584166666666DCE21F419A999999C7145841CDCCCCCC38E31F4133333393C71458419A9999999BE31F4100000040C7145841CDCCCCCC04E41F4166666646C71458413333333321E41F419A9999F9CE145841333333333DE41F4100000040E714584166666666CCE91F419A9999B9E51458410000000066EC1F4166666646F1145841CDCCCCCC1AEE1F41CDCCCC4CD8145841CDCCCCCCF8F21F41CDCCCCACBC1458410000000006F61F41000000E0A71458419A99999959F71F419A999939E91458410000000082F71F41CDCCCC2CF31458419A999999E9F71F41CDCCCC0CFD1458419A999999C3F71F4133333373091558419A999999D3F71F41CDCCCCAC0C1558419A999999AFF81F419A9999B93E1558419A999999CDF81F41666666463E155841CDCCCCCC8EFA1F416666664637155841666666664EFB1F4100000020361558416666666624FC1F41333333F33515584133333333F1FC1F41CDCCCC4C2E1558416666666664FD1F41000000E0281558413333333347FE1F41CDCCCC8C1F1558410000000070FF1F41CDCCCC0C1515584133333333E9FF1F419A9999B912155841000000002D0020419A9999F910155841CDCCCCCC5E0020419A9999190F15584100000000820020419A9999D90D15584100000000B80020419A9999590C15584166666666D20020416666668608155841333333330C0120419A9999F9F81458419A99999912012041666666A6F31458416666666611012041CDCCCC2CF31458419A999999F20020419A999939E9145841CDCCCCCCED002041333333B3E61458419A999999EF0020419A999939E01458419A999999010120419A999959CB145841666666661701204133333373BE1458419A9999991F0120419A9999D9BC1458419A9999994901204133333313B8145841CDCCCCCC8E01204166666666B21458419A999999A4012041CDCCCCCCB014584100000000C80120419A999979A8145841CDCCCCCCDD01204133333333A21458416666666610022041000000A08F145841CDCCCCCC2C02204166666606891458419A9999994E02204133333333811458410000000060022041333333137B14584100000000670220419A9999197A145841666666666802204133333333781458419A999999670220419A9999D9761458419A999999650220410000008075145841333333337E0220419A999979711458413333333387022041CDCCCC0C711458419A9999999A0220419A9999F97014584133333333AD0220419A9999597014584133333333B6022041333333F36E14584100000000C1022041CDCCCC0C6D14584166666666D0022041666666666A1458419A999999DE022041CDCCCC0C681458419A999999EB0220419A99991966145841CDCCCCCCFE022041000000C063145841CDCCCCCC120320419A9999F9611458416666666630032041333333735F145841000000004B032041CDCCCCEC5C1458413333333360032041666666065B1458419A9999999E032041CDCCCCEC561458419A999999E10320419A99999952145841333333330A042041000000C04F1458416666666631042041000000A04B145841CDCCCCCC50042041666666A647145841333333336E0420419A9999F943145841CDCCCCCC92042041CDCCCCCC3E145841333333338A042041CDCCCC8C3D1458416666666684042041000000203B145841CDCCCCCC7F0420419A999999371458416666666680042041000000203314584100000000840420419A9999B930145841CDCCCCCC87042041CDCCCC6C2D1458413333333388042041CDCCCC8C29145841666666668E0420419A999939261458419A999999930420410000008022145841CDCCCCCC9A042041333333931E14584166666666A3042041333333F31A14584133333333A90420419A9999F91614584133333333AF042041CDCCCC0C1414584133333333B6042041000000A01114584133333333BE042041CDCCCC0C0E14584166666666C6042041333333F30A14584133333333CD0420410000002008145841CDCCCCCCD2042041CDCCCC0C051458419A999999D8042041333333B302145841CDCCCCCCE104204133333373FF13584100000000F0042041333333F3FA13584133333333FF04204166666646F7135841CDCCCCCC06052041333333D3F5135841CDCCCCCC1905204100000040F41358419A9999991E052041000000A0F21358410000000027052041000000A0EC1358410000000032052041333333F3E2135841000000003705204133333313DF135841000000003305204133333313DA135841000000003005204133333353D313584100000000290520419A9999F9CB1358419A9999992505204166666646C8135841666666663005204133333393C4135841666666663B052041CDCCCC6CC113584166666666490520419A999919BE135841CDCCCCCC5D052041CDCCCCCCB9135841333333336F05204166666666B613584166666666820520419A999939B2135841CDCCCCCC92052041CDCCCCECAD135841333333339405204100000020AA135841666666665905204166666626A913584100000000E3042041CDCCCC0CA313584133333333A004204166666606A11358419A99999961042041CDCCCCECA213584166666666AB0320419A9999D99C1358419A999999E2022041333333938B13584166666666B0022041666666668A1358419A999999CA01204133333373A013584166666666B6012041CDCCCCAC9E135841CDCCCCCC91012041CDCCCC0C9C1358419A9999996C0120410000008099135841CDCCCCCC490120419A99993997135841CDCCCCCC2D0120419A99997995135841666666660A012041000000209313584166666666ED002041CDCCCC4C9113584166666666CD002041CDCCCC4C8F135841CDCCCCCCB8002041CDCCCCCC8D135841CDCCCCCCA3002041000000808C1358419A999999890020419A9999198A1358419A99999983002041000000C088135841000000007D002041000000C0881358419A99999976002041CDCCCC6C88135841666666666D002041000000A0871358410000000061002041CDCCCC4C86135841333333334E0020413333333384135841CDCCCCCC3B0020410000004082135841666666662C002041333333D380135841CDCCCCCC1F002041666666A67F1358419A99999912002041666666A67E1358419A99999902002041000000A07D135841CDCCCCCCF2FF1F41CDCCCC0C7D1358419A999999110020410000002072135841333333330800204100000060701358416666666608FF1F41000000C05A13584166666666DAFD1F4166666666381358413333333359FD1F4133333353211358419A99999915FD1F41000000401313584166666666FCFC1F41333333B30F13584133333333B9FC1F41000000600A1358410000000070FC1F41CDCCCC4C02135841CDCCCCCCE8FB1F4133333333F312584166666666A6FB1F41CDCCCC4CEB1258419A99999993FB1F41333333D3E61258419A99999961FB1F4133333373E1125841CDCCCCCC48FB1F4166666626DF12584133333333FBFA1F419A9999B9D91258419A9999999FFA1F419A9999B9D5125841333333335BFA1F41CDCCCCCCD71258410000000046FA1F419A999979D81258419A99999927FA1F41666666C6D8125841CDCCCCCC06FA1F41CDCCCC2CD91258419A999999D9F91F41000000E0D912584133333333CBF91F419A999959D912584166666666A0F91F4166666666D31258416666666694F91F4133333373D31258413333333351F91F41CDCCCC0CD3125841666666663CF91F419A999999D21258416666666604F91F419A9999B9D0125841CDCCCCCCEEF81F41CDCCCCECCF12584166666666D6F81F4100000080CF12584166666666B8F81F41CDCCCC6CCF125841666666669AF81F4133333373CF125841000000007CF81F419A999919CF1258410000000074F81F41000000E0CE1258410000000064F81F41000000E0CD1258410000000052F81F41CDCCCC0CCD125841666666663EF81F41666666A6CC12584133333333D3F71F4100000080CB12584133333333ADF71F419A9999B9CA125841CDCCCCCC90F71F4133333333CA125841333333337DF71F419A9999B9C91258419A99999965F71F41CDCCCCECC8125841333333333DF71F41CDCCCCACC71258410000000012F71F41666666A6C6125841CDCCCCCCFAF61F4133333353C612584166666666D6F61F4133333313C61258419A999999B3F61F419A9999B9C51258419A99999971F61F41CDCCCC0CC51258413333333337F61F4133333373C41258419A9999991BF61F41666666C6C412584100000000FEF51F41CDCCCC2CC512584133333333EFF51F41CDCCCC4CC51258419A999999B7F51F41CDCCCC6CC41258416666666696F51F4166666686C31258419A99999971F51F41CDCCCC6CC21258413333333341F51F4166666686C0125841CDCCCCCC1AF51F41CDCCCC6CBF12584100000000FAF41F41333333B3BE1258419A999999DDF41F4100000020BE125841CDCCCCCCCEF41F41666666A6BD12584100000000B8F41F4100000000BC1258419A9999999DF41F4166666626BA1258410000000078F41F41CDCCCC0CB7125841CDCCCCCC68F41F41CDCCCC6CB5125841CDCCCCCC14F41F41333333B3B01258419A999999FDF31F4166666646AD12584166666666EEF31F41666666A6AA12584133333333BFF31F41CDCCCC0CA81258419A9999996FF31F4100000080A4125841666666662CF31F4166666626A012584166666666E8F21F41CDCCCC6C9B1258419A999999C7F21F41CDCCCCEC9712584100000000A8F21F41CDCCCC6C95125841CDCCCCCC74F21F4133333393931258410000000002F21F4133333373901258416666666670F11F419A9999798D1258419A99999935F11F41CDCCCC4C8D1258419A9999991DF11F41CDCCCCAC9012584100000000B4F01F41CDCCCC2C90125841CDCCCCCC26F01F41666666669112584133333333DDED1F41666666269D1258419A9999996FED1F41666666869E1258419A9999992DED1F419A9999999E12584100000000D2EC1F419A9999799C1258413333333385EC1F4133333393981258413333333309EC1F41333333338F1258410000000078EA1F41CDCCCCAC6D12584133333333D5E91F41CDCCCC4C5E1258413333333371E91F41333333D358125841CDCCCCCC18E91F410000008059125841CDCCCCCC44E81F41000000C05B1258419A99999911E81F419A9999B95C125841CDCCCCCCE6E71F41CDCCCC8C5E12584133333333BBE71F4100000040611258419A999999A5E71F41CDCCCCEC63125841CDCCCCCCA6E71F41CDCCCCCC6612584166666666B4E71F419A999979691258419A999999D3E71F41333333536B125841CDCCCCCC08E81F41000000A06C1258410000000054E81F41333333536D125841000000006AE81F41CDCCCCCC6E1258410000000072E81F41CDCCCC0C71125841666666666AE81F419A9999B972125841CDCCCCCC4CE81F41000000607412584166666666E2E71F41CDCCCC2C751258419A9999999BE71F41CDCCCC0C75125841666666663CE71F41CDCCCC6C7412584133333333E5E61F4166666666731258419A99999999E61F41CDCCCC2C72125841CDCCCCCC76E61F4133333373711258419A9999993FE61F41CDCCCCEC701258416666666618E61F41333333137112584133333333F7E51F41CDCCCCAC711258419A999999D7E51F41000000A07212584133333333C5E51F4100000000741258419A999999B7E51F41666666E67512584100000000B8E51F41CDCCCC6C781258419A999999BBE51F41CDCCCCCC7912584100000000CCE51F41333333D37B125841CDCCCCCCDCE51F41CDCCCC8C7D12584133333333F3E51F41666666067F1258410000000000E61F4166666686801258416666666602E61F41666666A6811258419A999999FFE51F41000000A08312584166666666FEE51F41000000408512584100000000FEE51F41666666E6871258416666666606E61F41000000408A125841000000000CE61F41000000608B12584100000000A8E51F41333333B38A1258413333333381E51F419A9999798A125841CDCCCCCC38E51F41333333D389125841CDCCCCCC04E51F41666666668912584133333333E1E41F41333333D38812584166666666C2E41F41333333138812584133333333B3E41F419A99997987125841CDCCCCCC7CE41F4166666646871258419A9999994DE41F41333333B387125841CDCCCCCC2EE41F4100000000891258410000000016E41F41333333338B1258410000000004E41F41000000208D12584100000000FCE31F419A9999B98F12584166666666FEE31F41666666E691125841000000001AE41F410000002095125841333333333FE41F419A999959991258416666666656E41F419A9999F99B125841CDCCCCCC66E41F419A9999999E125841CDCCCCCC66E41F419A9999B9A01258419A99999957E41F419A999979A21258416666666630E41F41CDCCCCACA3125841CDCCCCCCFCE31F41333333D3A31258419A999999D7E31F419A9999D9A3125841666666666EE31F41000000E0A212584133333333C1E21F41000000E0A01258416666666670E21F41000000209F125841333333331DE21F419A9999599C12584133333333EFE11F41CDCCCCCC9C12584100000000DEE11F41666666269E125841CDCCCCCCDCE11F419A999999A012584100000000E4E11F41000000E0A31258419A999999F7E11F41333333F3A5125841CDCCCCCCFEE11F419A999999A71258410000000010E21F419A999999AA1258419A99999919E21F41CDCCCCCCAC1258416666666620E21F41000000C0AE1258419A99999929E21F419A9999F9B0125841333333333BE21F41000000A0B31258419A99999957E21F4133333373B51258413333333379E21F4100000020B71258419A9999998BE21F41CDCCCCACB712584100000000A6E21F419A9999B9B812584133333333BDE21F419A999979B91258419A999999E3E21F41000000A0BA125841CDCCCCCC02E31F4166666686BB1258416666666626E31F41CDCCCC0CBD125841CDCCCCCC44E31F41CDCCCC2CBF1258419A99999963E31F4166666626C2125841CDCCCCCC76E31F4166666666C41258416666666678E31F419A9999D9C4125841CDCCCCCC82E31F419A999999C71258416666666684E31F41333333F3C7125841333333338DE31F41CDCCCC8CCA125841333333338FE31F41CDCCCCACCD1258419A9999998FE31F41666666E6CE125841333333339BE31F419A9999F9D312584100000000A8E31F41CDCCCC4CD912584100000000B4E31F41666666E6DD12584133333333D7E31F419A999979E012584100000000FEE31F4133333393E3125841CDCCCCCC04E41F4133333373E5125841CDCCCCCC04E41F419A999919E712584133333333FBE31F41CDCCCCCCE912584133333333EDE31F419A9999B9EC1258419A999999C7E31F41333333F3EE12584166666666AAE31F41333333F3F01258419A9999998FE31F41666666C6F41258419A99999989E31F41333333D3F61258410000000088E31F41666666E6F81258419A99999987E31F419A9999D9FA1258419A99999981E31F419A9999B9FB1258416666666676E31F41000000C0FC1258413333333351E31F41CDCCCCCCFE125841000000002CE31F410000006000135841CDCCCCCC10E31F41333333730113584100000000FCE21F41666666A60213584100000000F0E21F41333333930313584100000000DCE21F41CDCCCCCC04135841CDCCCCCCC8E21F41CDCCCCAC051358419A999999B9E21F419A999939061358419A999999AFE21F4100000060061358419A99999959E21F4166666626071358419A99999919E21F41666666C6071358419A999999E9E11F41666666A6081358419A999999ADE11F41CDCCCCAC0A135841CDCCCCCC7EE11F41666666A60D135841666666666CE11F4100000040101358419A9999995FE11F41000000A011135841666666664CE11F41333333F3121358413333333337E11F419A999919141358416666666614E11F41666666C6151358419A99999903E11F41000000A0171358413333333301E11F4100000000191358413333333303E11F419A9999391A135841CDCCCCCC0AE11F41CDCCCC8C1B1358419A99999911E11F41000000E01B135841CDCCCCCC20E11F41CDCCCC4C1C135841CDCCCCCC30E11F41333333B31C1358413333333373E11F419A9999B91D135841CDCCCCCCBEE11F41000000801E13584133333333F7E11F419A9999B91E135841CDCCCCCC26E21F41666666461F1358413333333343E21F416666662620135841CDCCCCCC5EE21F4100000040221358416666666670E21F4166666646251358410000000068E21F41333333D326135841CDCCCCCC44E21F419A999999291358419A9999992BE21F41333333932A1358419A99999909E21F419A9999B92B1358419A999999DDE11F419A9999392C135841CDCCCCCC6CE11F41666666C62D135841CDCCCCCC26E11F41333333F32E1358416666666608E11F419A999979301358419A999999FDE01F41CDCCCCAC311358410000000000E11F41CDCCCC2C331358410000000010E11F4166666666351358419A99999939E11F41CDCCCC2C39135841CDCCCCCC5EE11F41000000203D135841CDCCCCCC98E11F419A9999B944135841000000009EE11F419A9999D9451358419A9999999BE11F4166666666471358410000000092E11F41333333D3481358413333333383E11F41CDCCCCCC491358410000000062E11F41666666264B135841CDCCCCCC18E11F419A9999394D13584133333333F9E01F41CDCCCC2C4E1358419A999999EDE01F41CDCCCC8C4E13584100000000D6E01F41CDCCCC8C4F13584166666666BCE01F413333333351135841CDCCCCCC92E01F4133333313541358419A9999997FE01F41333333D355135841333333336FE01F41000000C057135841CDCCCCCC62E01F4133333333591358410000000050E01F41000000C05A1358416666666640E01F419A9999D95B1358419A99999905E01F419A9999195F1358419A999999D9DF1F416666666661135841CDCCCCCCC8DF1F41333333136213584133333333BDDF1F419A99995962135841333333339FDF1F41CDCCCCEC621358413333333377DF1F41CDCCCCAC62135841CDCCCCCC56DF1F41CDCCCCCC61135841333333334FDF1F41CDCCCCEC5F135841CDCCCCCC40DF1F41666666065C1358410000000040DF1F4166666646571358416666666652DF1F41CDCCCC4C541358416666666662DF1F4166666646511358419A9999995BDF1F41333333134D1358419A9999994BDF1F41333333734A1358416666666634DF1F4166666666491358419A99999911DF1F419A9999194913584100000000ECDE1F41CDCCCC0C4A135841CDCCCCCCCCDE1F41666666264C13584100000000B4DE1F419A9999B94E135841000000008ADE1F419A99995953135841CDCCCCCC64DE1F419A999939561358416666666646DE1F410000008058135841333333331FDE1F41666666865A135841CDCCCCCCC2DD1F4166666626601358413333333399DD1F41666666C6611358413333333373DD1F41CDCCCC6C621358419A9999994FDD1F419A999919621358419A99999939DD1F41CDCCCCCC61135841CDCCCCCC1CDD1F41000000805E1358413333333315DD1F41000000C05B1358410000000008DD1F4100000060591358419A999999E5DC1F41CDCCCCEC571358419A999999B5DC1F419A999919561358419A99999987DC1F4133333393541358416666666662DC1F41666666A653135841CDCCCCCC40DC1F416666664653135841666666663CDC1F41333333D3571358413333333327DC1F41000000A05B1358410000000018DC1F41333333D35D135841666666660ADC1F4133333393601358413333333301DC1F41CDCCCCCC631358419A999999F9DB1F41333333136913584133333333F7DB1F41666666E66B1358419A999999F9DB1F419A9999D96D13584166666666FCDB1F41000000207013584166666666F6DB1F419A9999F97113584166666666EADB1F41666666867313584133333333E1DB1F419A9999397413584166666666CCDB1F41333333337513584133333333C5DB1F4166666686751358419A999999A3DB1F4166666666761358419A99999987DB1F41CDCCCC8C76135841666666665EDB1F41CDCCCC6C761358419A99999925DB1F4100000000761358413333333307DB1F41CDCCCC4C7613584100000000ECDA1F41000000E07613584133333333D9DA1F41666666C677135841CDCCCCCCCCDA1F41333333337913584133333333B9DA1F41666666A67B13584166666666AEDA1F419A9999797D13584166666666AADA1F41333333337E1358413333333399DA1F419A9999D9811358413333333397DA1F413333331385135841000000009ADA1F41666666268813584133333333A3DA1F41333333138B135841CDCCCCCCB0DA1F419A9999598D13584133333333C5DA1F41333333D38F13584133333333E1DA1F419A9999D99213584166666666F0DA1F41000000A094135841666666660ADB1F41CDCCCCAC971358410000000016DB1F41666666269A1358419A99999917DB1F41333333139D1358416666666610DB1F4166666626A01358410000000006DB1F4100000020A213584166666666F6DA1F419A999939A4135841CDCCCCCCE6DA1F4100000000A613584133333333D9DA1F4166666686A71358419A99999993DA1F419A999999AD1358419A9999997FDA1F41000000E0AF1358419A9999996DDA1F41CDCCCCACB21358410000000060DA1F41CDCCCCCCB51358413333333359DA1F41000000E0B8135841333333335FDA1F41CDCCCC4CBB1358419A99999965DA1F41000000C0BC1358413333333379DA1F4100000060BF1358416666666688DA1F41000000A0C01358419A9999999FDA1F419A9999D9C113584166666666BADA1F41333333B3C213584166666666D6DA1F41CDCCCC0CC31358419A9999990BDB1F41CDCCCC8CC31358419A99999933DB1F41CDCCCCCCC3135841CDCCCCCC4ADB1F41CDCCCC0CC41358413333333363DB1F4166666686C4135841333333337FDB1F41000000A0C513584100000000A6DB1F4166666666C7135841CDCCCCCCC4DB1F41CDCCCC2CC9135841CDCCCCCCDEDB1F4100000020CB135841000000002ADC1F41CDCCCC8CD1135841666666664ADC1F419A999979D41358413333333353DC1F4133333313D61358413333333355DC1F41000000E0D61358416666666654DC1F41000000A0D7135841000000004EDC1F419A999979D81358410000000046DC1F4166666606D9135841000000003ADC1F419A999979D91358413333333329DC1F41CDCCCCCCD91358410000000016DC1F419A999919DA13584133333333F7DB1F4133333333DA1358419A999999BFDB1F419A9999F9DB13584100000000A4DB1F41666666E6DD135841666666668CDB1F4166666666E0135841CDCCCCCC82DB1F41666666C6E2135841CDCCCCCC82DB1F41666666E6E41358413333333387DB1F4166666606E6135841CDCCCCCC88DB1F41CDCCCC4CE61358410000000090DB1F41000000E0E613584100000000BEDB1F41CDCCCC8CE91358416666666604DC1F4166666686ED1358413333333327DC1F4133333333F01358416666666656DC1F4166666666F31358419A9999996FDC1F41666666E6F4135841CDCCCCCC88DC1F41CDCCCC8CF61358413333333399DC1F41666666A6F713584166666666A6DC1F41000000E0F813584166666666AEDC1F4100000040FA13584133333333B5DC1F41000000E0FB13584133333333B5DC1F41666666C6FC1358419A999999B3DC1F4133333393FD13584100000000B2DC1F4166666686FE13584100000000ACDC1F41CDCCCC4C0014584166666666ACDC1F41000000400114584100000000B0DC1F41333333330214584100000000BADC1F41666666C6031458419A999999C7DC1F416666666605145841CDCCCCCCD6DC1F413333331307145841000000001CDD1F419A9999D90E145841CDCCCCCC3EDD1F41000000A0141458413333333355DD1F41CDCCCC8C18145841CDCCCCCC68DD1F41333333131D145841CDCCCCCC80DD1F4100000020211458410000000094DD1F41000000C0241458419A99999999DD1F419A99997927145841CDCCCCCC98DD1F419A999959291458419A99999991DD1F41CDCCCCAC2A145841CDCCCCCC82DD1F41CDCCCC6C2C1458410000000072DD1F41CDCCCC6C2E1458419A9999995BDD1F410000002030145841000000004CDD1F4100000040311458416666666632DD1F41333333B3321458413333333319DD1F41CDCCCC8C33145841CDCCCCCCFCDC1F419A9999393414584133333333BFDC1F410000006035145841666666669EDC1F410000000036145841CDCCCCCC80DC1F41333333F3361458416666666656DC1F41CDCCCC6C38145841CDCCCCCC34DC1F41666666A6391458419A999999DBDB1F41000000003D1458419A999999ADDB1F41666666C63E145841666666668EDB1F41666666A63F1458410000000066DB1F4100000060401458419A9999993FDB1F419A9999B9401458413333333317DB1F41333333B34014584133333333E9DA1F419A9999D940145841CDCCCCCC9ADA1F419A99995942145841666666664ADA1F4166666626451458413333333325DA1F419A9999794614584166666666FAD91F41333333D34814584100000000C4D91F41000000C04B145841333333337BD91F41333333F34E145841CDCCCCCC48D91F41333333F3501458419A9999992BD91F419A999959521458413333333329D91F41666666C6521458413333333307D91F41333333735314584100000000F0D81F41666666665314584133333333E3D81F41CDCCCC2C53145841CDCCCCCCC6D81F4100000060521458419A99999995D81F4133333313501458410000000066D81F41333333B34E1458413333333351D81F41000000804E1458419A99999937D81F41666666C64E1458410000000028D81F41666666E64F145841666666661ED81F419A9999D951145841	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	01010000206A0800001D6C227F1AF31F41CDCCCC8CCB135841	320230000	Z	Avezan	3202300	32023	32	76	6
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	01010000206A0800001823348CD10E1E4166666606210F5841	320240000	Z	Ayguetinte	3202400	32024	32	76	6
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	01060000206A08000001000000010300000001000000460100009A9999994FC21B419A9999D9FE135841333333335FC21B419A9999B90D1458419A999999CBC21B41333333332414584100000000E8C21B41666666262F14584133333333F1C21B41CDCCCC2C3C14584166666666DEC21B41CDCCCC2C46145841CDCCCCCC98C21B41666666264D1458413333333387C21B41333333B35D14584133333333ADC21B419A9999B96E1458419A99999917C31B416666666676145841666666666AC31B4133333313791458419A99999995C31B419A9999D99114584133333333A1C31B419A9999F99F14584133333333C9C31B4133333313AE145841CDCCCCCCD2C31B41000000A0C0145841CDCCCCCCC2C31B4100000060D01458410000000068C31B41666666A6E21458419A999999E1C31B4133333373E31458419A99999949C41B4166666646D0145841CDCCCCCC96C41B41666666E6CF14584100000000ECC51B41666666A6DD14584166666666D2C61B419A999999E5145841CDCCCCCCCCC71B41666666E6F3145841CDCCCCCC2CC81B41000000A0F71458410000000094C81B4133333373F91458419A9999996BC91B419A9999F9F91458419A99999993C91B419A9999B9F01458419A99999977CC1B419A9999D9E9145841CDCCCCCC0ED21B41666666A6E4145841CDCCCCCC5ED21B4166666666D414584133333333F7D31B4133333393F514584166666666CCD41B41333333D3FD1458419A999999F9D61B413333339318155841000000002CD91B41333333332F1558416666666616DA1B41000000803B155841CDCCCCCCC2DA1B41000000C04A155841CDCCCCCC2EDB1B4133333393551558416666666634DB1B419A9999D95A15584166666666B6DA1B41000000E067155841333333339BDA1B419A9999596C15584133333333AFDA1B4100000020771558410000000048DB1B41CDCCCC2C8315584166666666C6DB1B4100000080851558419A99999965DC1B41333333D38D1558416666666650DD1B41000000609B15584133333333C9DD1B41CDCCCC2CA115584100000000AADE1B41666666E6A915584100000000DEDE1B41000000A0B115584166666666FEDF1B41666666A6C915584100000000B8E01B41000000E0C91558419A999999E1E01B4166666626CE15584100000000E6E01B4133333373D91558416666666696E01B4166666666E115584166666666CAE01B41666666E6E81558413333333399E01B419A9999D9EC15584100000000CEE01B41666666C6F015584166666666A4E01B41000000A0021658416666666678E01B41666666A60C1658410000000036E11B41000000601B16584133333333A5E11B41000000A01E1658410000000030E21B41000000601E1658419A99999991E21B41CDCCCC8C24165841333333339DE21B419A9999B929165841CDCCCCCCF4E21B41000000A0231658416666666684E31B41CDCCCCCC20165841666666667EE41B41333333132416584166666666ACE41B4166666686151658419A999999CBE41B416666664610165841666666663AE51B41333333530A16584166666666C0E51B410000004000165841CDCCCCCC20E61B41666666E6EA1558416666666604E71B41CDCCCC8CED155841333333338BE71B419A999979EC15584100000000C0E71B419A999979E81558419A999999A3E71B419A999939D915584133333333D5E71B41CDCCCCCCD6155841666666668AE91B419A999919D41558413333333319EA1B4100000040D1155841666666667EEA1B419A9999D9CB15584133333333C9EA1B41CDCCCCACCA1558413333333397EB1B4166666646CA155841CDCCCCCCFEEB1B4100000000C31558419A99999925EC1B41666666E6B91558419A999999E1EC1B41000000C0BE155841CDCCCCCCE4EC1B4133333333C31558410000000094EC1B419A9999B9CD1558416666666650ED1B4100000040CF155841666666669CED1B4166666606CC1558419A999999E7ED1B41CDCCCC6CC51558413333333329EE1B4100000020C61558416666666630EE1B419A999999CB15584133333333FFED1B4100000060D01558410000000014EE1B419A9999D9D21558410000000088EE1B419A999939D41558419A9999999DEF1B4100000000CC15584100000000CCEF1B4133333333CC155841000000002EF01B419A9999F9D0155841CDCCCCCC9CF01B41CDCCCC4CD0155841666666662EF11B419A999979CD15584100000000A4F11B4133333313C4155841666666662AF21B41CDCCCC6CC1155841CDCCCCCCC2F21B419A9999D9B915584100000000E2F21B4166666646B0155841CDCCCCCCCCF21B41CDCCCC2CAA1558416666666664F21B41666666A69F155841000000006EF21B41666666269A15584100000000D8F21B4100000080961558416666666618F31B41333333D391155841000000002CF31B41000000008A15584133333333DFF21B41666666068215584100000000ECF21B41000000E0771558419A9999993FF31B416666664669155841666666667CF31B41666666A6611558416666666604F41B41000000005B155841000000003EF41B41333333B3551558419A9999995BF41B41666666864E1558413333333361F41B41CDCCCC6C45155841000000007CF41B41333333733E1558419A9999994DF41B41333333133315584100000000E0F31B419A9999393115584166666666FEF21B41666666C63115584100000000C0F21B4133333353301558419A99999999F21B419A999919281558419A999999BDF21B41000000C01D155841CDCCCCCC84F21B41333333330C1558416666666650F21B41CDCCCC8C0315584100000000BCF11B419A999999FB14584133333333E9F01B41333333D3EA145841CDCCCCCC5EF01B419A9999F9E01458419A99999953F01B41333333B3DB145841666666666AF01B4133333373D31458419A999999F1F01B41333333D3C4145841CDCCCCCC50F11B419A9999D9BE1458410000000036F21B4133333373B51458419A99999913F31B4133333373B31458416666666680F41B41CDCCCC4C99145841000000009AF41B419A999919921458416666666666F41B4166666606851458416666666668F41B41000000C080145841666666669CF41B416666664679145841000000008CF51B41CDCCCC0C67145841CDCCCCCCA0F51B41333333F35F1458416666666604F51B41000000605614584100000000CAF41B419A9999795114584166666666B4F41B419A999979481458413333333331F51B419A9999994214584133333333A1F61B41000000E03B14584100000000D8F61B419A9999393914584166666666F6F61B419A9999B930145841CDCCCCCCF0F61B41666666C628145841000000002CF71B41CDCCCC0C251458419A999999E3F71B413333335321145841333333332FF81B41000000401B14584100000000E4F81B419A99997917145841333333335BF91B41666666C612145841CDCCCCCC68F91B41CDCCCCAC051458416666666652F91B41CDCCCC6C02145841CDCCCCCCBCF81B41CDCCCC8CFB135841CDCCCCCCA2F81B41CDCCCCCCF41358419A999999C7F81B41666666E6F01358413333333353F91B41666666C6ED135841000000008CF91B419A999999E7135841666666669AF91B419A9999F9DB13584133333333F3F91B419A999959DC135841000000007EFA1B4133333373D413584166666666AEFA1B41CDCCCCACCD135841CDCCCCCC5AFB1B4100000040C61358416666666672FB1B41CDCCCC4CC31358416666666660FB1B41CDCCCC8CAE13584100000000D4FA1B41CDCCCC4C9E1358419A99999997FB1B41000000C0871358410000000052FC1B41666666E679135841000000004CFD1B41CDCCCC2C6A1358419A99999957FE1B41666666C6571358416666666640FF1B419A9999D94813584133333333BBFF1B41333333F33D135841CDCCCCCCEAFF1B419A9999B92D135841666666664A001C41CDCCCCEC1C135841CDCCCCCC8EFF1B4133333373EE1258410000000026FF1B419A999959D812584166666666FAFE1B419A999939CB1258416666666684FE1B41666666E6BD1258413333333347FE1B41666666C6AE125841CDCCCCCC12FE1B41333333D3A9125841000000003AFD1B41333333B3A71258419A999999FDFC1B419A999939A412584133333333EFFC1B41333333B39E1258410000000016FD1B4166666666941258410000000058FD1B41666666668F1258416666666640FD1B41333333F388125841CDCCCCCC7AFD1B419A9999B97E1258410000000082FD1B41000000407812584166666666D2FC1B419A9999596A12584100000000DAFC1B41333333535A1258419A999999EFFC1B41CDCCCCCC531258413333333321FD1B419A9999F94E12584166666666B0FD1B41000000A04E1258413333333309FE1B41333333B348125841CDCCCCCCFAFD1B416666668643125841000000009AFD1B41000000C0391258413333333395FD1B41333333B3341258416666666652FE1B41333333732E1258416666666670FE1B413333339329125841000000006AFE1B41CDCCCC4C231258410000000090FE1B41666666A613125841CDCCCCCCE0FE1B410000006006125841333333330FFF1B419A999979021258416666666684FE1B41CDCCCC8CFC11584133333333C7FD1B4133333393F7115841CDCCCCCC30FD1B41333333B3F41158410000000098FC1B4133333373E91158419A99999985FB1B41CDCCCC0CE7115841000000003CFA1B41CDCCCC2CC51158419A9999999FF91B4166666646B6115841CDCCCCCCFEF81B4166666626B71158416666666636F81B4166666666BC1158416666666664F71B41CDCCCCCCBE115841CDCCCCCCACF61B41000000C0B9115841CDCCCCCC3EF51B419A9999B9B311584100000000F0F41B4166666666A2115841CDCCCCCC92F41B41CDCCCCAC97115841CDCCCCCCA0F31B4133333353861158416666666616F31B419A999979771158413333333331F31B419A9999597211584100000000D8F21B4133333393661158419A9999997FF21B4166666606611158416666666686F11B41333333135C1158413333333325F11B4100000080521158416666666686F01B41CDCCCCCC331158419A999999E9EF1B41000000A027115841333333339DEF1B413333339325115841CDCCCCCC7AEE1B41333333732211584166666666A6EC1B4100000080181158419A99999961EC1B4133333373141158419A999999C9EB1B41333333730F11584100000000C6EA1B419A9999F90B115841CDCCCCCCE0E91B41333333F3131158419A99999935E91B41666666C615115841CDCCCCCC64E81B410000000016115841CDCCCCCCE2E61B41CDCCCCEC1B1158419A9999991FE51B41333333B31811584100000000ECE31B41CDCCCC2C1711584100000000B4E31B41000000C017115841CDCCCCCC16E21B4133333333221158416666666648E11B419A9999992211584166666666F8E01B4166666666211158413333333393E01B41333333F3191158419A9999997DE01B419A9999F90A115841CDCCCCCC68E01B4100000040071158416666666604E01B41CDCCCC0C0111584133333333ABDE1B419A9999F9F510584166666666CEDD1B419A9999D9EF105841CDCCCCCC2CDA1B419A999919DB1058419A9999991DDA1B41CDCCCC2CC81058419A999999D1D91B41CDCCCC2CBC105841000000005ED81B41CDCCCCCC95105841CDCCCCCC32D71B41CDCCCC4CA810584100000000E4D61B419A9999D9AF105841000000004CD61B41000000A0CC1058419A99999961D61B419A999959DA105841CDCCCCCC26D61B4100000020E31058419A99999989D51B41333333F3F41058419A999999D7D41B41666666C6021158419A99999911D41B419A99999910115841CDCCCCCCD6D31B41000000A01A115841333333339DD31B41666666662D1158419A999999B1D21B419A9999794B115841CDCCCCCC8AD21B4100000080551158419A99999915D21B41333333735F115841CDCCCCCC48D21B41000000C06711584100000000B6D11B41CDCCCC0C89115841000000007ED11B41CDCCCC0CA7115841CDCCCCCCE0D01B419A999959BC11584166666666BAD01B4100000060C61158419A999999D5D01B4133333353DF1158413333333323D11B41333333D3EA11584166666666A8D11B41333333F3F7115841CDCCCCCC5AD11B4166666646001258419A9999990DD11B41CDCCCCAC051258419A99999909D01B4100000060111258419A999999DDCE1B41666666C624125841CDCCCCCC68CE1B41666666E6291258410000000042CD1B41000000004512584166666666D6CC1B41CDCCCC8C47125841666666661CCC1B419A9999F951125841000000005CCB1B419A9999195812584166666666AECA1B41000000A05F1258413333333335CA1B41CDCCCCEC621258419A999999EDC91B419A999979681258416666666670C91B41000000606D125841CDCCCCCCB6C81B410000000072125841333333336BC81B419A9999197512584100000000B8C71B413333333378125841333333336FC71B41CDCCCC4C7F1258413333333305C81B41000000E0871258410000000034C81B419A9999998F1258413333333325C81B419A9999199A125841CDCCCCCC08C81B41000000209C125841666666663AC71B4166666666A3125841CDCCCCCC10C71B4166666626A712584133333333E3C61B4166666606B512584133333333EFC61B4133333353DB125841333333338FC71B419A999919E612584100000000A0C71B41333333D3E8125841666666668CC71B41CDCCCC4CF212584133333333F9C71B4166666666FB125841666666663CC81B41CDCCCC0C05135841CDCCCCCC52C81B41000000A010135841333333331DC81B41000000C015135841CDCCCCCC34C71B41CDCCCC2C23135841000000009CC61B41CDCCCCAC2F13584166666666E4C51B41666666064313584100000000F6C41B41333333334D13584100000000B8C41B41333333B35D13584166666666B6C41B419A999939691358419A999999E3C41B4100000020741358419A9999999FC41B413333331379135841666666662AC41B41CDCCCC4C96135841333333333DC41B4100000020B11358419A9999995FC41B4133333353C21358413333333317C41B419A999959CA1358419A999999CDC31B4100000080CC135841000000004CC31B4166666646CA1358413333333329C31B41CDCCCC4CCE1358419A9999994FC21B419A9999D9FE1358419A9999994FC21B419A9999D9FE135841	01010000206A0800006A1FF63248E11B416666669660135841	320250000	Z	Ayzieu	3202500	32025	32	76	14
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	01010000206A080000F7B71A371DC21F4166666666550C5841	320260000	Z	Bajonnette	3202600	32026	32	76	8
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	01010000206A0800002B0ECE0A0AF11A41000000C026025841	320270000	Z	Barcelonne-du-Gers	3202700	32027	32	76	21
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