SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep33;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep33 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep33','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep33','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep33','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep33"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000F8DC7C950CA01B41CDCCCC7CBF905841	330010000	Z	Abzac	3300100	33001	33	75	13
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	01010000206A0800001A48691E2CD01B41333333B35B575841	330020000	Z	Aillas	3300200	33002	33	75	35
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	01010000206A0800006591570EE4DE1941666666D62A8C5841	330030101	H	Chemin de la Vie	3300301	33003	33	75	14
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	01010000206A080000D74D79A24C021A419A9999790B895841	330030102	H	Lagrave-Le Bourg	3300301	33003	33	75	4
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	01010000206A080000A66DDBB691CC1941CCCCCC3CE1885841	330030103	H	Sabarèges	3300301	33003	33	75	4
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	01010000206A0800009ADAC42D48F21941000000608E895841	330030104	H	Parabelle	3300301	33003	33	75	2
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	01010000206A080000B98C2C4D24A71941CDCCCCFC39925841	330040000	Z	Ambès	3300400	33004	33	75	25
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	01060000206A080000010000000103000000010000005E000000CDCCCCCCD60D1741333333334B755841000000004C0D1741333333B341755841CDCCCCCCCA0B17419A9999D937755841CDCCCCCCAE0B1741000000403375584166666666200B1741000000802A75584166666666660A174133333313237558413333333365091741CDCCCCCC1E7558419A999999810817413333331315755841666666661E081741CDCCCC6C0D755841CDCCCCCC92071741000000C0FD7458419A9999997F071741CDCCCCCCF4745841000000004407174100000080E474584100000000E405174133333333CC74584133333333AB051741CDCCCCACC1745841000000006C05174100000040B1745841000000002C05174100000000B3745841000000007002174100000080E1745841000000006C02174100000080E27458410000000000011741000000C0F9745841000000000C00174100000080057558410000000024FF1641000000800C7558410000000058FC1641000000401975584100000000C0FB164100000000217558410000000028FA1641000000404C75584100000000F8F8164100000080707558410000000054F81641000000808675584100000000B0F71641000000009B755841000000007CF71641000000009D7558410000000030F7164100000040AB75584100000000D0F6164100000000B475584100000000F8F5164166666686D575584133333333BBF51641CDCCCC0CD9755841CDCCCCCC02F5164133333353F2755841000000007CF4164100000080FD7558410000000044F4164100000000007658410000000028F41641000000002376584100000000E0F41641000000C0317658410000000084F41641000000403676584100000000A8F31641000000402576584100000000C4F3164100000080FF7558410000000084F3164100000000FC75584133333333DDF21641000000C0107658419A9999991FF21641333333F32E765841000000008CF11641CDCCCCAC427658410000000094F11641000000004576584100000000F8F016410000008052765841000000009CF01641000000805876584100000000A4EF16410000008064765841000000005CEF1641000000406476584100000000F4EE164100000000677658410000000020ED1641000000407876584100000000E8EC1641000000007C7658410000000044EC1641000000408C76584100000000A4EB1641000000C0987658410000000080EB164100000040987658410000000008EB1641000000C09F765841000000008CE91641000000C06D7658410000000084E91641000000C06F765841CDCCCCCCD2EA16419A9999199C76584100000000F4EA164100000040A37658419A999999A1EA164100000040A9765841CDCCCCCC24EB1641CDCCCCECAE7658419A99999921EC16419A999999BF765841CDCCCCCCA8ED16419A999979D5765841CDCCCCCC08EF1641666666C6E97658416666666614F0164133333313F87658410000000038F016419A999979FB7658419A99999997F11641CDCCCC2C0F7758410000000056F21641333333731A77584166666666B2F31641CDCCCC6C2B7758413333333393F41641333333B33577584100000000AEF5164166666666417758419A99999947F616419A9999994877584166666666E6F61641000000004E775841CDCCCCCC9CF9164133333373617758419A99999949FA1641CDCCCC2C4F7758416666666684FB1641000000402F7758413333333307FD1641666666A60677584166666666DCFB164166666686F37658413333333347FF1641000000A0B6765841333333332100174133333313A7765841CDCCCCCC5802174166666626807658413333333375031741666666A666765841CDCCCCCCB4041741CDCCCC2C5376584100000000FE061741666666A63076584133333333D7081741CDCCCC8C1976584133333333FB081741333333F3157658419A999999230617419A999939DC75584133333333F904174133333373C77558413333333399041741CDCCCCECC17558419A99999945051741666666E6B875584166666666920917413333331382755841CDCCCCCCD60D1741333333334B755841CDCCCCCCD60D1741333333334B755841	01010000206A08000040E22BD14AFE16413433333309765841	330050101	H	Sud-Ouest	3300501	33005	33	75	3
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	01010000206A0800005C5BAD0A38E216419A9999B9ED775841	330050102	H	Nord-Ouest	3300501	33005	33	75	3
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	01010000206A0800008E9A7F35B6FF16416666667615795841	330050103	H	Nord-Est	3300501	33005	33	75	7
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	01010000206A0800004E7F373C34191741666666C62F785841	330050104	H	Sud-Est	3300501	33005	33	75	7
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	01060000206A08000001000000010300000001000000CE00000033333333331B1941CDCCCC6C5DAA5841333333332B1C1941CDCCCC0C58AA5841CDCCCCCC9C1D1941333333F352AA584133333333F11D19419A99999950AA584100000000641E1941CDCCCC0C48AA58419A999999D51E1941000000A038AA584133333333031F19410000004034AA58419A999999791F1941CDCCCC4C2FAA58410000000010201941CDCCCC0C2FAA584166666666C4211941000000A032AA584133333333A72219419A9999B930AA58419A99999909231941000000002DAA58419A9999994F231941333333D323AA5841333333337F231941CDCCCC2C16AA584100000000D6231941CDCCCCAC0DAA5841333333334D2419416666662608AA584133333333F92419410000008004AA584166666666342619419A999999FFA95841CDCCCCCCC4261941CDCCCCACFBA95841666666661827194166666606F5A95841CDCCCCCC6E271941CDCCCCCCE9A95841000000009E27194133333333E0A9584166666666162819419A9999D9D3A9584133333333AD281941333333B3CDA95841CDCCCCCCA029194133333373C7A9584100000000202C19419A9999B9B4A95841CDCCCCCCA82C194100000060AFA9584166666666282E19419A999919A3A9584166666666FE3319419A9999997AA95841CDCCCCCCA03719416666668661A95841CDCCCCCC76381941666666665BA9584166666666203A19413333337350A958419A999999C33A19419A9999394DA95841CDCCCCCC403B1941666666464DA95841333333339B3D19419A99997948A9584100000000BC411941CDCCCCAC40A95841CDCCCCCC724219419A9999B93EA9584100000000E24319419A99997937A958419A999999C9441941666666C636A95841CDCCCCCC90481941CDCCCCAC3AA9584166666666FC4A1941666666063CA9584133333333DF501941666666A63BA958413333333373571941666666063BA9584133333333995C1941666666263AA95841666666663A5F1941000000E039A95841000000009E5F19410000006039A95841666666668C651941666666A638A95841CDCCCCCCB46619416666660639A95841CDCCCCCCDA6A1941666666A617A95841CDCCCCCCEC71194133333313E0A85841CDCCCCCC6C701941CDCCCC2C89A8584166666666367119410000004081A858419A9999996D7019416666660654A858419A99999937701941666666264EA858410000000016701941000000C043A8584100000000886F1941333333D322A8584100000000327119410000008017A85841333333332D711941CDCCCCCCF0A75841333333331F7119419A999979D0A7584166666666EE6F19419A9999D991A7584133333333BB6F1941CDCCCC2C8CA75841CDCCCCCC78701941000000C07CA7584166666666387119410000008068A7584133333333C37119419A9999F95BA7584166666666C87119410000002057A7584166666666007219413333339355A7584100000000147319413333335352A758416666666680731941000000A04EA758419A9999994F741941000000604BA758416666666668741941CDCCCCEC49A75841CDCCCCCC8E741941333333F33EA75841CDCCCCCC907419419A9999B935A75841CDCCCCCC6A741941CDCCCC0C30A7584133333333B37419416666664628A7584166666666A67419419A99999920A75841CDCCCCCC0C751941CDCCCC0C16A758416666666674751941CDCCCCCC06A75841CDCCCCCCD8751941CDCCCC8CFAA65841CDCCCCCC0A76194100000060ECA65841333333335B761941666666E6E7A65841CDCCCCCC3276194166666686DEA65841CDCCCCCC70761941CDCCCC0CD3A65841CDCCCCCC547619419A9999F9CEA6584166666666E8751941CDCCCC2CCDA6584133333333D975194133333353C8A6584100000000EE7519419A9999D9B7A65841666666660A761941CDCCCC2CB5A6584100000000EA7519419A9999F9ACA658413333333333761941CDCCCC8CA9A65841333333335D761941666666E69CA6584133333333957619416666662698A658410000000088761941CDCCCCEC90A658416666666648761941CDCCCC2C8CA65841000000003C7619419A99995986A65841666666661A741941CDCCCC6C7DA658419A99999951731941CDCCCC6C77A65841CDCCCCCCD8721941333333336FA65841000000002E721941666666C66AA6584133333333617119416666660669A65841000000008C7019413333333366A65841CDCCCCCCFE6E1941CDCCCCAC5EA6584166666666546E1941000000405EA65841666666663C6D1941CDCCCC4C65A658419A999999E76C19419A9999796BA6584133333333816C1941666666A676A65841CDCCCCCC726B1941333333F37FA65841CDCCCCCCE86A19410000006082A6584100000000206A19416666662683A658413333333337691941666666E688A658410000000068681941666666A689A658419A999999AB6719416666668688A658419A999999256719416666662681A6584100000000166619419A9999D96EA658419A999999FF6219413333331388A658419A9999991F6219410000000089A6584166666666086219410000008083A6584100000000D86019419A9999D985A6584133333333B7601941000000407FA6584166666666E45F1941000000207FA6584100000000A45E19419A99997984A6584100000000165E1941000000E05DA65841CDCCCCCC0E5E1941CDCCCC4C49A658419A999999D35D1941CDCCCCEC49A6584100000000AA5D1941000000E036A6584100000000645D1941333333D337A658419A999999BF5C194166666606FDA5584133333333F55B1941000000C0F6A55841666666662A5B1941CDCCCC8CF2A5584166666666545A194133333333E9A558419A99999937591941666666C6F4A5584100000000F457194166666646FDA55841CDCCCCCCFE571941CDCCCCAC01A65841CDCCCCCC68561941333333F30AA6584100000000525619416666660607A65841CDCCCCCC80531941CDCCCCEC15A65841666666666C531941000000200FA6584166666666EC521941000000E00EA6584133333333C55119413333339313A65841666666666C5119416666660617A65841CDCCCCCC8A501941666666E61AA658419A9999993F501941333333F310A65841CDCCCCCCAE4F19419A9999190DA658419A999999534F1941666666E60CA6584166666666324E19410000006014A6584133333333B74D19410000000016A65841CDCCCCCCA44D1941333333330FA65841333333335F4D19419A9999F90FA6584133333333254D19416666666605A6584133333333C54C1941CDCCCC6C05A6584100000000924C194166666686FFA558419A9999998B4B1941CDCCCC2CFFA5584166666666E44A19419A999979FDA558419A9999990F4A194166666686FDA5584133333333834819419A9999D9FEA55841CDCCCCCCA6471941333333F3FCA5584133333333B14619419A9999B903A658419A999999E7451941666666C607A65841000000007E4519410000002008A6584100000000C44419413333337310A6584100000000604419416666662611A65841CDCCCCCC964319419A9999F917A6584133333333414319419A9999D91CA65841CDCCCCCC544219419A99997924A658419A99999931421941666666C623A65841CDCCCCCCCE401941CDCCCCCC2BA65841CDCCCCCC92401941333333732FA658410000000004401941333333D32FA65841000000004A3F1941666666C63DA6584133333333BF3D1941000000C045A6584166666666283D1941CDCCCC6C4AA6584100000000323D1941666666E64EA6584133333333853C19413333333360A6584166666666363C1941000000E069A6584166666666383C19419A99997972A6584166666666663C1941666666A67EA6584100000000423C19416666668680A6584100000000403B19419A99999981A65841000000009E3A19416666664684A658419A999999CF3A1941CDCCCC4C88A65841CDCCCCCC123C1941666666669AA6584133333333A53C1941000000A0A5A65841CDCCCCCCF83D1941CDCCCCACD6A65841666666664C3E1941CDCCCC6CE4A65841333333333D3E1941666666E6F1A6584133333333793D19410000006043A758419A999999BB3C1941CDCCCCCC94A7584133333333293B1941CDCCCCEC8DA7584166666666AA3819419A9999B981A758419A999999ED3219419A9999D966A75841CDCCCCCCF02E1941000000C053A75841333333335B2E1941666666668EA7584133333333252E194133333333B7A75841666666669E2D1941666666862EA8584133333333AF2A1941CDCCCC4C1FA858416666666620251941000000C002A8584133333333EF2419413333339318A8584166666666342319419A9999F9C7A8584166666666C6221941000000E0F5A858419A999999A92219419A9999B9FDA8584166666666801E194100000020C6A95841CDCCCCCC8E1C1941CDCCCCAC24AA58419A999999411C19419A99991934AA5841CDCCCCCCD01B1941333333D344AA584133333333731B1941333333734DAA584133333333331B1941CDCCCC6C5DAA584133333333331B1941CDCCCC6C5DAA5841	01010000206A0800007E7E7E7E9A4E1941333333D323A85841	330060000	Z	Anglade	3300600	33006	33	75	14
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	01010000206A0800007A927793993F1A41CDCCCC3C4D6C5841	330070000	Z	Arbanats	3300700	33007	33	75	8
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	01060000206A08000001000000010300000001000000D80100009A99999971071B41CDCCCCCC386A58419A999999A7051B41000000E04C6A5841CDCCCCCC8C051B4166666666576A58413333333333051B41CDCCCC4C5D6A58419A999999BB041B41CDCCCC8C6D6A58419A999999E5031B4133333373766A5841000000005C031B4133333353766A584166666666FC021B41CDCCCC2C7E6A58416666666698021B419A9999397F6A58416666666624021B419A9999B9836A58419A9999990F011B41CDCCCC4C8B6A5841000000005E001B41CDCCCC8C8B6A584100000000D8FF1A41000000C08E6A5841666666669AFF1A419A9999D9936A5841CDCCCCCC14FF1A4133333373976A584133333333E3FE1A41CDCCCC2C9B6A5841CDCCCCCC6CFE1A41000000009D6A58410000000096FD1A419A999959A36A58410000000044FD1A419A999999A26A58419A9999994DFC1A41666666E6A26A584133333333EDFB1A4133333353A46A5841CDCCCCCCFCFA1A41CDCCCC0CA56A5841CDCCCCCC7CFA1A4100000080A46A58413333333315FA1A41CDCCCC0CA16A58413333333321F91A41CDCCCC2CA16A584166666666A4F81A41000000809D6A5841CDCCCCCC20F81A41666666669C6A5841CDCCCCCCDEF71A41000000209A6A58419A99999987F71A41666666269A6A5841666666668AF61A419A9999F9966A5841666666661AF61A419A9999599A6A58419A9999990DF51A41CDCCCCAC996A58419A99999961F41A419A999939986A5841333333332FF41A419A9999B9946A584166666666C2F31A4133333393956A58416666666674F31A41333333139B6A584100000000BAF21A41333333B39E6A58413333333331F21A41CDCCCCCCA46A584133333333ABF11A419A9999D9A56A58416666666606F11A4166666626AD6A58410000000090F01A41000000C0AE6A5841000000004CF01A4133333333B56A5841666666669AEF1A4166666646B76A58419A999999C3EE1A41CDCCCC0CBC6A584133333333ABEE1A419A9999F9BF6A58413333333335EE1A4133333353C46A584166666666F4ED1A419A999939C96A58419A999999DBED1A4100000080CE6A5841000000005CED1A419A9999B9D06A5841333333331BED1A41CDCCCCACD46A58419A99999959EC1A419A999979D76A58413333333303EC1A41666666C6DD6A584166666666D8EB1A41000000A0E46A5841CDCCCCCC52EB1A419A9999F9E96A584166666666DAEA1A419A999959F56A58416666666670EA1A41CDCCCCECF76A58413333333383E91A41333333B3F66A5841CDCCCCCC92E81A41CDCCCC4CFA6A584133333333EDE71A4100000060FA6A5841CDCCCCCC72E71A4166666666F46A5841CDCCCCCCD6E61A41CDCCCC6CF66A584100000000A6E51A419A999939FD6A584100000000B6E41A4166666666036B584166666666EEE31A41CDCCCC0C056B5841CDCCCCCC48E31A4133333393036B584133333333E5E21A419A9999F9056B5841CDCCCCCC2AE21A41666666E60C6B58413333333327E11A41333333D30B6B5841000000002CE01A41CDCCCC0C186B58419A999999F7DF1A41666666A6196B58419A99999935DF1A41333333531A6B5841666666666EDE1A419A9999B91E6B584166666666CCDD1A41000000001F6B58419A9999992DDD1A4166666686246B584100000000F2DC1A4133333353256B58413333333389DC1A41666666662C6B58419A99999915DC1A41333333D32E6B584100000000B6DB1A41CDCCCC0C376B58419A99999939DB1A4133333313396B58419A999999EDD91A419A9999394A6B584166666666D2D91A41000000E04F6B58410000000046D91A4100000000556B58413333333373D81A41666666465F6B58416666666638D81A41333333F3646B5841CDCCCCCCC8D71A41CDCCCCEC676B5841000000003AD71A41000000A06F6B584166666666D4D61A41333333937A6B584133333333BDD71A41000000A08B6B584100000000D4D71A41666666E68F6B58419A999999C5D71A419A999919986B5841000000000ED81A4100000000B46B5841666666662AD81A41666666A6B86B58410000000038D81A41CDCCCC2CC36B58416666666634D81A41666666E6CF6B5841CDCCCCCC24D91A41CDCCCC8CE86B58416666666670D91A4100000000ED6B584166666666F0D91A41CDCCCC0CF06B58419A99999971DA1A4166666646F56B584133333333F9DA1A419A999999FC6B5841CDCCCCCC6CDB1A4166666626FD6B58419A99999915DC1A41CDCCCC2C006C58419A99999959DC1A419A999999FD6B584166666666FCDC1A419A999979FF6B58419A99999927DD1A41333333F3FB6B584133333333C3DD1A4133333393F76B58419A999999F3DD1A4133333313EA6B58416666666618DF1A41666666A6E56B584100000000AEDF1A41CDCCCCECE56B5841000000009AE21A419A999959EF6B58410000000062E31A4133333353F36B584166666666C0E31A41666666C6F76B58419A99999909E41A41CDCCCCAC016C5841CDCCCCCC1CE41A41333333731B6C5841666666666CE41A4133333393246C58416666666636E51A41666666A6356C5841666666669CE51A4100000000456C58419A999999D3E51A41666666E6516C58419A99999941E61A4166666686556C58419A9999994DE71A4133333313536C5841CDCCCCCC2CE81A41CDCCCC2C586C58413333333395E91A41CDCCCC0C5F6C5841CDCCCCCCC8E91A41333333D3606C5841CDCCCCCC16EA1A419A9999F96A6C5841CDCCCCCC26EB1A419A999959756C584133333333BDEB1A4133333393796C584133333333FBEB1A4166666626796C58410000000062EC1A4133333333756C584133333333B9EC1A41CDCCCC2C746C58419A999999E7EC1A419A9999D96F6C5841333333334BED1A419A9999796D6C58419A999999B1ED1A41000000C0676C5841CDCCCCCC1EEE1A4166666686666C58410000000060EE1A4133333333636C584100000000E6EE1A4133333353626C58410000000054EF1A4166666666666C5841333333336DEF1A41666666E6696C58410000000062EF1A4133333373736C58413333333375EF1A4100000000766C58410000000044F01A41000000607B6C5841CDCCCCCC70F01A41CDCCCCCC806C584100000000A8F01A41333333D38E6C58416666666616F11A419A9999799B6C5841CDCCCCCC74F11A4166666606A26C584100000000A6F11A4100000080B06C5841333333330BF21A419A999999B96C5841CDCCCCCC88F21A41CDCCCC2CBF6C5841333333333BF31A41333333D3C26C584100000000C0F31A41CDCCCCCCC96C58419A99999901F41A41CDCCCCECCA6C58419A999999EDF41A419A999919D76C5841666666661AF51A4133333333E26C5841CDCCCCCC02F51A419A9999D9E86C58413333333387F41A419A999939F46C58413333333333F41A4100000000F76C58419A999999E9F31A4100000000016D5841CDCCCCCC4CF31A41CDCCCC4C106D58419A99999931F31A4166666626176D5841CDCCCCCC38F31A41000000601D6D58416666666694F31A41666666E6266D58419A999999B7F31A419A9999192E6D58419A9999990DF41A4100000040386D5841CDCCCCCCEAF41A41333333734B6D58413333333363F51A4133333313586D58413333333393F51A41CDCCCC2C626D58416666666606F81A41CDCCCC0C936D5841CDCCCCCCE6F81A4133333313A66D58410000000050F91A4133333333E66D58410000000020FA1A419A9999994E6E5841CDCCCCCC8AFA1A4100000020806E58413333333395FC1A419A9999F9776E58413333333333001B419A999979656E584166666666D4011B41333333D35E6E5841CDCCCCCC04021B41000000C0686E58416666666676051B4100000000746E5841CDCCCCCC52091B419A999959806E584133333333FF0B1B419A9999198A6E584133333333AB0E1B4133333373926E584133333333A70E1B41666666C6976E58419A999999570E1B4133333313C26E584100000000500E1B4166666666DA6E58419A999999770E1B419A9999D9FC6E58419A9999994F0E1B419A999999116F584100000000EC0E1B4166666626106F5841CDCCCCCC260F1B419A9999F90D6F5841CDCCCCCCF40F1B419A9999D90D6F58410000000072101B41CDCCCC2C0F6F584133333333E5101B41000000C00C6F5841CDCCCCCC5A111B41000000E0276F58410000000008121B41666666862F6F58410000000092121B4100000000246F584100000000D2121B4133333333266F5841CDCCCCCC28131B41CDCCCC2C1D6F58419A99999991131B41CDCCCCAC1E6F5841CDCCCCCCDA131B41666666C6196F58416666666652141B419A9999B90E6F58413333333385141B419A999979066F584166666666DC141B41CDCCCCECFE6E58413333333303151B419A9999D9F76E584133333333CF151B41333333B3FF6E58416666666674161B41666666A60A6F58410000000008181B41666666C6286F58416666666610191B41000000E0356F584166666666101A1B419A9999F9446F584100000000F81A1B41000000C0556F584166666666A2191B419A9999F9686F58419A999999DF181B4133333393746F58416666666638181B41666666C6806F58419A999999E1171B4100000000896F5841666666661A181B41000000E08B6F5841333333331B181B4166666626916F584100000000F2181B419A999919A76F5841333333336D191B41333333D3AE6F584166666666621A1B4133333373BA6F584100000000FC1A1B419A9999D9BE6F5841CDCCCCCC541B1B4133333333BF6F5841CDCCCCCCC01B1B41CDCCCC4CB86F5841CDCCCCCCCC1C1B4100000080B16F5841333333334F1D1B41666666A6AA6F58419A9999992B1E1B41CDCCCC6C9C6F584133333333811E1B419A9999F99C6F584166666666F81F1B41CDCCCCECB06F584133333333ED201B4100000020BD6F58419A999999AF211B4133333393C86F584166666666F4221B41666666C6D76F58419A999999B3231B41000000E0C26F5841000000004E251B41CDCCCC0CA26F58419A9999993B261B41000000A0946F5841000000009A291B4100000080676F584166666666002C1B41CDCCCC8C516F584100000000642C1B41000000E0506F584133333333BB2C1B41CDCCCC2C536F584100000000BA2D1B41333333B3606F584133333333FB2D1B41333333535E6F58419A999999792E1B4166666606686F58419A99999999301B4133333393556F584166666666EE311B41000000004D6F5841666666663C321B4133333373596F584133333333BB321B4100000000696F58410000000012361B41CDCCCCCC4E6F5841333333334B361B4100000000566F5841333333334D371B41333333134D6F58419A99999995371B41333333934F6F584100000000E8371B4166666646596F584166666666E2381B41666666E6796F584166666666A4391B419A9999F98F6F584166666666423A1B41000000008B6F584133333333E93A1B4133333393826F584166666666FA3A1B41333333F3866F5841CDCCCCCCF8401B41666666A6816F5841CDCCCCCC82411B41333333739E6F5841CDCCCCCCBC421B4166666686D66F58416666666684431B4133333373D56F5841CDCCCCCCF4431B41666666E6D26F58419A999999C3471B4133333373B86F584100000000CC481B41000000A0B16F5841666666663A4B1B41CDCCCC2CA36F5841CDCCCCCC584C1B41000000409E6F584100000000E04D1B41000000A0996F5841333333330D501B41333333939B6F58419A999999CF501B41000000E09B6F58410000000058511B41CDCCCC8C996F5841333333333D531B41CDCCCCCC8A6F58416666666602541B4166666626866F5841CDCCCCCCD2551B4166666666856F584133333333C5581B4166666686806F584166666666505A1B41666666867E6F5841CDCCCCCC085A1B419A9999398C6F584166666666D6591B41CDCCCC2C9E6F584100000000D0591B4100000040B46F5841CDCCCCCCAC591B4166666626C66F58419A999999A5591B4166666626DD6F5841000000003C5A1B4166666626D76F58419A999999055B1B41CDCCCCACD36F584166666666085C1B4133333313D16F584133333333B55C1B4166666646CE6F5841666666669C5E1B41CDCCCC4CC06F584166666666485F1B4166666626B66F58416666666698601B4100000000AA6F584133333333E9601B4100000080ED6F584100000000E0611B41CDCCCCECEE6F58419A99999931621B41CDCCCC6CF16F5841CDCCCCCCF4621B419A999939F16F58413333333373621B41333333B3E26F5841CDCCCCCCB8621B419A999959DD6F58413333333303631B4100000000DB6F5841333333330D631B41333333D3D26F58419A99999979631B4100000060C56F58419A999999DF631B4100000020BB6F58413333333327641B4100000000B86F58419A99999953641B41CDCCCC8CB26F5841CDCCCCCC30641B41CDCCCC6CA96F5841CDCCCCCC42641B41333333B3A46F5841CDCCCCCC0A641B419A9999B9926F58410000000026641B41333333938B6F58410000000068641B4133333373866F5841CDCCCCCC20641B41666666267E6F584100000000B0631B41CDCCCC8C7C6F5841666666660E631B41000000007D6F584133333333B3621B41666666867E6F5841CDCCCCCC60621B41333333537C6F5841666666664C621B4133333393786F5841333333335F621B41333333D36F6F584100000000CE621B41CDCCCCCC686F584133333333FF621B41333333D3676F5841CDCCCCCCA6631B41666666C66A6F584133333333EF631B4133333353686F5841CDCCCCCC5E641B4166666686616F584133333333C9641B419A999979566F584166666666B2641B41666666A6506F58419A999999F3631B41CDCCCCEC496F584166666666DA631B41666666A6456F584100000000FC631B4166666686416F584133333333B3631B419A9999593A6F584133333333B9631B419A9999D9356F58419A999999FF631B41CDCCCC6C2D6F58416666666604641B419A9999B9206F5841CDCCCCCC2E641B41666666461A6F58419A99999921641B419A9999D9136F58416666666668631B419A9999B9056F58419A99999971631B41333333D3016F5841CDCCCCCCB0631B41CDCCCCACFF6E584100000000B2631B4100000060FA6E58410000000050631B419A999939F26E58410000000052631B4166666606EA6E584100000000A2641B41CDCCCC2CDD6E584166666666E8641B41333333F3D46E58416666666658651B4166666666D06E5841CDCCCCCC5E651B41333333F3C96E5841CDCCCCCCD4651B41CDCCCC8CC86E5841666666664C651B41CDCCCC2CC56E5841333333336B631B4133333393BB6E584100000000B6611B4133333333B66E58419A999999C5611B41CDCCCC8CAE6E584166666666A4611B41CDCCCC8C9F6E5841CDCCCCCC62601B41333333D39C6E584100000000B85E1B4133333333916E584166666666885E1B41666666268E6E584166666666325D1B41666666266D6E5841666666667A5C1B4166666666606E58419A999999315C1B41333333B34E6E5841CDCCCCCCFC5B1B41333333B3466E5841666666669A5B1B41CDCCCC6C416E58419A999999135B1B41666666E6416E5841CDCCCCCC1A591B41333333333C6E58410000000014581B419A9999D93B6E58419A999999A9531B419A9999B9486E58413333333339501B419A999939526E5841000000002E4F1B4166666666526E584133333333CB4E1B4133333393516E5841CDCCCCCC1E4E1B41000000A0446E5841CDCCCCCCB64D1B41333333933E6E5841666666664C4D1B41CDCCCCEC3A6E58419A999999C34C1B4100000020386E5841CDCCCCCCB24B1B41333333B3366E58419A999999A54B1B419A999959246E584133333333B34B1B41000000C01E6E5841CDCCCCCC644B1B4166666666186E584166666666044B1B41333333D30D6E58419A9999995D4A1B4100000040F76D584166666666A6491B419A9999F9E16D584133333333A7491B41000000A0CF6D584166666666C8481B4166666626B06D5841666666667C481B419A9999F9A76D5841CDCCCCCC46481B41666666E6A46D58416666666688491B41666666665E6D584100000000C2471B4133333313626D5841000000000A471B41000000E0656D584100000000E8451B41000000A0666D584133333333AB441B4100000020656D58419A99999953441B419A999979406D58410000000026441B4133333393396D584100000000CC421B41333333D3436D5841CDCCCCCCA6421B41CDCCCCCC456D58410000000014411B41666666E6466D5841CDCCCCCC0A3F1B41666666C6466D5841CDCCCCCC523E1B419A9999D9476D58419A999999CF3D1B4100000000476D5841000000006C3D1B419A999999486D58419A9999995B391B419A9999D95B6D58410000000052381B419A999959646D58410000000020381B4100000080696D584100000000BC371B4166666686696D58410000000018371B419A999999726D5841333333333B361B41CDCCCCAC7A6D584100000000A2351B41CDCCCC0C796D58410000000080341B41666666C67D6D584100000000F4331B41CDCCCCEC7E6D584166666666D8321B41000000007E6D5841CDCCCCCC14321B41666666867E6D58419A9999992F311B419A9999F9806D584166666666B82F1B41333333B3806D58419A999999252F1B41CDCCCC0C676D584166666666022F1B41333333135E6D584100000000502E1B41CDCCCC0C436D584166666666162D1B41666666E6406D58419A999999872B1B41333333133A6D5841CDCCCCCCAC2A1B419A999999386D5841000000004A291B41333333733E6D58410000000024291B41666666E6466D584100000000B2281B4100000080486D58419A9999990F281B41000000A0466D5841333333335F271B41CDCCCCAC3C6D5841333333336D251B4166666666486D58419A999999B7221B4166666666556D5841000000005A221B41333333D3556D58419A999999A5211B41000000A05A6D58410000000036211B419A9999194A6D584100000000D61F1B41000000C04F6D5841333333337D1F1B4100000020426D5841CDCCCCCCC21E1B41CDCCCCEC466D5841CDCCCCCCA41D1B41CDCCCC6C506D58419A999999B11C1B419A999999566D584100000000F81C1B41CDCCCC6C636D584133333333911C1B41000000A0656D5841CDCCCCCCDE1A1B4166666666736D5841CDCCCCCCC0191B4133333333616D5841000000000C191B41CDCCCC8C586D584166666666AE151B419A999999376D58416666666620151B41CDCCCC8C3A6D58419A999999B3141B41CDCCCCCC276D58410000000010141B41000000C0136D584100000000C8121B41333333F3F16C584133333333FB111B4133333333E26C58419A999999E5111B4133333333DE6C58416666666672111B4133333353D46C58419A999999AD101B41000000E0C06C58419A99999901101B41CDCCCCECB86C5841CDCCCCCC440F1B4133333353AE6C58419A999999ED0F1B41CDCCCCAC9C6C58419A999999FF0F1B419A999959986C584166666666180F1B41CDCCCC4C916C5841CDCCCCCC420E1B4166666606896C584100000000640E1B41CDCCCC6C806C584133333333290E1B41333333536D6C584133333333050D1B41666666E6446C584133333333D50B1B41CDCCCC8C226C5841333333334B0C1B41666666A61C6C584100000000220C1B4166666626196C584133333333770B1B4166666626056C584100000000A60A1B41000000A0EE6B584166666666600B1B41666666E6E76B584100000000DC0B1B4100000000E16B58419A999999C30A1B4100000060C86B584100000000480A1B41666666A6B86B584133333333B7081B4166666626786B5841000000008A081B41CDCCCCAC716B5841CDCCCCCC06091B41CDCCCCEC6D6B584100000000760A1B4100000020656B584166666666F0091B419A9999B9506B5841666666668C091B4166666626516B58410000000050091B4100000060426B58416666666612091B41CDCCCC2C376B58419A999999E3081B419A9999D9326B58419A999999D7091B41CDCCCCCC1E6B5841000000003A0A1B4133333333156B5841CDCCCCCCCA0A1B41333333131E6B5841333333330B0B1B419A999999176B584100000000880B1B4133333373136B58419A999999F3081B419A9999D9F96A5841CDCCCCCCC4091B4100000040EB6A5841333333332F0A1B41333333D3E16A5841CDCCCCCC560A1B4100000080DB6A5841666666669C0A1B4166666606C96A584133333333EB0A1B41333333D3AA6A584166666666140B1B41CDCCCC2C9E6A584100000000420B1B4166666666966A584100000000EA0B1B4100000020866A584166666666CA0B1B419A9999197A6A584133333333A1091B41CDCCCCEC7B6A5841333333331B081B41666666867E6A58419A99999971071B41CDCCCCCC386A58419A99999971071B41CDCCCCCC386A5841	01010000206A080000A47F25C4A9031B41333333E3156D5841	330080000	Z	Porte-de-Benauge	3300800	33008	33	75	19
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	01010000206A080000F50BB328007B164133333363126D5841	330090101	H	Le Moulleau-Les Abatilles	3300901	33009	33	75	3
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	01010000206A080000D2DABD6B917F1641000000901D6E5841	330090102	H	Pereire-Ville d'Hiver	3300901	33009	33	75	2
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	01010000206A080000EA03CF79939216419A999949386E5841	330090103	H	Ville d'Été	3300901	33009	33	75	1
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	01010000206A08000028D882AD559F1641343333A30C6E5841	330090104	H	Saint-Ferdinand	3300901	33009	33	75	1
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	01010000206A080000F68D93A157A81641666666D6AE6D5841	330090105	H	Aiguillon	3300901	33009	33	75	2
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	01010000206A0800003C3C3C7CD1EC18413333334395995841	330100000	Z	Arcins	3301000	33010	33	75	7
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	01010000206A0800002F44A64B5C151741000000E0027D5841	330110000	Z	Arès	3301100	33011	33	75	49
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	01010000206A080000EAD02829C3EA184100000060E88F5841	330120000	Z	Arsac	3301200	33012	33	75	32
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	01010000206A080000CE0E0072B4E91941CCCCCCBC02825841	330130101	H	Nord	3301301	33013	33	75	4
01060000206A08000001000000010300000001000000AA01000033333333AFD31941000000C0BD80584166666666B4D31941000000E0BD80584100000000BAD31941666666E6BD8058419A999999D3D3194166666626BE8058416666666604D41941666666E6BE8058419A9999992DD4194166666646BF8058419A9999995BD419419A999999BF8058410000000062D41941666666A6BF805841000000008ED4194133333313C080584100000000B6D419419A999999C08058419A999999D7D419419A999939C1805841CDCCCCCC26D51941CDCCCC8CC1805841CDCCCCCC2AD5194133333393C18058413333333311D61941CDCCCCACC3805841CDCCCCCCB2D6194166666626C580584100000000E4D619419A999999C5805841333333337DD719419A9999F9C6805841333333338DD7194100000020C7805841CDCCCCCC10D819419A999959C8805841CDCCCCCC16D8194166666666C8805841333333332FD81941000000A0C88058410000000044D81941333333D3C8805841333333336DD819419A999939C98058419A9999998BD81941CDCCCC8CC980584166666666B2D8194133333373C980584166666666BCD8194166666666C9805841CDCCCCCCF4D8194133333313C9805841CDCCCCCC20D91941333333F3C88058416666666640D91941CDCCCC2CC98058413333333353D91941CDCCCC8CC9805841000000006CD9194166666606CA8058419A999999A7D919419A9999B9CB805841CDCCCCCCC8D91941333333D3CC80584166666666F2D9194133333353CE805841666666662ADA19419A999939D08058413333333371DA1941333333F3D2805841CDCCCCCCB8DA194166666686D580584100000000E0DA19419A9999D9D68058419A99999903DB1941CDCCCCECD78058419A99999927DB1941000000A0D88058419A9999993BDB19419A999939D98058416666666650DB194100000000DA805841000000005ADB1941333333B3DA805841333333336BDB1941333333B3DB8058410000000070DB1941CDCCCC8CDC8058413333333379DB194133333353DD805841CDCCCCCC84DB1941000000E0DD8058419A99999995DB194166666626DE80584100000000A8DB1941CDCCCC0CDE805841CDCCCCCCBCDB194166666606DF805841CDCCCCCCCADB1941000000C0DF80584133333333E7DB194133333353E18058413333333301DC194100000020E28058413333333323DC19419A9999B9E3805841666666665ADC19419A999959E68058410000000066DC1941333333D3E68058410000000090DC194100000080E880584166666666C4DC1941333333B3EA8058419A999999E1DC1941333333D3EB805841CDCCCCCC08DD194133333313ED8058416666666630DD194133333333EE8058419A99999957DD1941CDCCCC4CEF805841666666667ADD194133333313F080584100000000B4DD194100000000F180584166666666F2DD1941000000E0F1805841000000001CDE194133333373F28058419A9999995FDE194100000060F3805841000000008CDE19419A999939F480584133333333A5DE1941000000C0F480584100000000B6DE1941CDCCCC4CF580584133333333C3DE1941CDCCCCCCF580584100000000CEDE194166666646F68058419A999999DFDE19419A999919F78058419A999999EFDE194100000000F88058419A99999901DF194100000040F98058419A99999913DF194166666626FB8058410000000022DF19419A9999F9FC8058416666666630DF19419A999919FF8058419A9999993DDF194100000080018158419A99999949DF19410000006004815841CDCCCCCC5EDF194166666646088158419A9999997BDF1941666666660D8158419A99999981DF1941333333D30E8158419A99999991DF19419A9999591281584100000000AADF1941000000E0158158419A999999BBDF1941CDCCCC2C1881584100000000D6DF1941CDCCCCCC1A81584133333333F3DF1941333333131E8158410000000016E01941CDCCCCCC218158413333333319E0194166666626228158419A99999941E019413333335326815841CDCCCCCC80E01941666666262B81584133333333ABE01941666666662E815841000000002EE11941CDCCCCEC378158416666666670E11941000000203D815841CDCCCCCC70E11941666666263D8158419A9999997FE11941333333133E8158419A99999997E119419A9999993F81584166666666D2E11941000000E04281584133333333F3E11941CDCCCC8C44815841CDCCCCCC30E21941CDCCCC2C488158419A99999991E21941000000E04D8158419A999999EBE219416666662654815841CDCCCCCC16E319419A9999D9568158416666666638E31941333333B358815841333333335BE31941CDCCCC8C598158419A99999985E31941CDCCCCEC5A8158419A999999ADE31941CDCCCC6C5C81584133333333E5E31941333333135F8158413333333335E41941666666C6628158410000000078E41941666666A665815841666666669CE41941CDCCCC8C678158419A999999BDE4194100000040698158419A99999909E519419A9999396D815841CDCCCCCC9CE519419A9999D97481584100000000E6E519419A9999B978815841666666662AE61941000000407D815841CDCCCCCC38E61941CDCCCCAC7E815841CDCCCCCC44E619419A9999D9808158413333333349E61941CDCCCCAC818158419A99999953E61941CDCCCCAC81815841333333335DE61941000000E0818158416666666666E61941CDCCCC4C82815841000000006EE61941CDCCCCEC82815841CDCCCCCC74E61941000000C0838158410000000080E619419A99993984815841666666668CE61941333333B3848158419A9999999BE619419A9999198581584133333333ABE61941CDCCCC6C8581584100000000BAE619419A9999B98581584100000000CAE61941CDCCCC0C8681584100000000DAE61941666666668681584133333333E9E61941666666C6868158419A999999F9E61941CDCCCC2C87815841333333330BE719413333339387815841333333331DE719419A9999F987815841333333332FE7194100000060888158419A9999993FE719419A9999B988815841CDCCCCCC4EE71941CDCCCC0C898158419A9999995DE719410000006089815841666666666AE71941CDCCCCAC898158410000000074E71941333333138A8158413333333379E71941666666868A815841CDCCCCCC86E719419A9999998B8158410000000094E71941CDCCCCAC8C8158419A999999A3E71941333333B38D81584133333333A7E71941333333F38D81584166666666D0E719419A999939908158419A99999923E81941666666A6948158413333333333E8194133333393958158416666666668E81941CDCCCCAC988158419A999999B3E819419A9999B99D815841CDCCCCCCE0E8194133333393A081584166666666FEE8194166666646A28158413333333321E91941CDCCCCACA38158416666666646E91941666666A6A48158410000000070E91941CDCCCC4CA581584166666666A4E919419A999999A5815841CDCCCCCCD0E91941CDCCCC8CA58158419A99999907EA194100000020A5815841333333334DEA1941333333F3A3815841CDCCCCCCB2EA194100000080A28158413333333341EB194100000040A0815841333333338BEB1941000000409F81584100000000B8EB1941333333D39E81584166666666D6EB19419A9999999E81584100000000F2EB1941CDCCCC8C9E815841CDCCCCCC24EC1941333333139F815841333333338DEC1941000000A0A0815841666666660CED19419A999939A38158416666666638ED194133333393A4815841333333336BED194100000000A68158419A99999997ED194166666646A781584133333333FFED1941000000E0AA815841CDCCCCCC92EE1941333333D3B0815841CDCCCCCCAEEE1941CDCCCCECB18158419A999999D5EE194166666686B381584166666666EEEE1941CDCCCC8CB4815841CDCCCCCC16EF1941CDCCCC2CB6815841000000001CEF194166666666B68158413333333397EF1941CDCCCCECB98158413333333305F01941CDCCCCCCBA8158416666666668F01941CDCCCCCCBA8158413333333329F11941000000E0B98158410000000052F11941333333B3B9815841CDCCCCCC5EF2194166666626B88158413333333377F2194166666606B8815841CDCCCCCC10F319419A999939B7815841000000004AF31941000000C0B7815841333333335DF31941CDCCCCECB7815841CDCCCCCCC8F31941CDCCCC0CBA8158419A9999998DF419419A9999D9BE8158419A9999993BF519419A999959C4815841CDCCCCCC10F6194166666686CB8158410000000094F61941333333B3CF81584166666666F4F61941000000C0D2815841000000006EF7194133333313D68158416666666680F71941CDCCCC8CD6815841333333338BF71941333333D3D681584133333333EFF71941CDCCCC4CD9815841CDCCCCCC5EF81941CDCCCCECDB815841CDCCCCCCD6F819419A9999B9DD815841666666667EF919419A999919E08158410000000040FA1941CDCCCC6CE2815841666666667EFA1941333333D3E38158419A9999999DFA1941CDCCCCECE58158419A999999ABFA19419A999979E881584166666666B6FA1941CDCCCCCCEB815841CDCCCCCCBCFA194133333353EF8158419A99999939FB194133333393EF815841CDCCCCCC70FB1941333333B3EF815841CDCCCCCCA6FC1941CDCCCC4CF081584166666666C0FD1941CDCCCCECF081584166666666BCFD1941333333B3ED81584166666666B6FD194100000020EA8158416666666678FD1941CDCCCC2CDB815841333333330FFD194166666646B38158419A99999935FD1941666666C6A6815841CDCCCCCC70FD194100000080A081584100000000A8FD19419A999979998158419A99999947FD19416666668696815841333333332BFD1941CDCCCCCC9381584133333333B5FC1941000000E082815841333333334BFC1941CDCCCC2C758158419A999999D1FB194100000040678158410000000044FB19419A9999595981584166666666CEFA1941CDCCCC2C4D8158419A9999998DFA19413333337346815841CDCCCCCC64FA19419A9999F93E8158410000000038FA1941000000403A8158419A999999CBF919413333335334815841CDCCCCCCA6F919419A99995930815841666666669AF919419A9999D92A8158419A999999A5F919419A9999D926815841CDCCCCCCB4F919419A9999992181584100000000E8F91941333333D31B8158419A9999991FFA1941CDCCCCCC168158413333333367FA194166666606148158416666666676FA1941666666460F8158413333333385FA1941666666060781584166666666C2FA19416666668601815841CDCCCCCCF4F919419A999959028158410000000080F919419A99999902815841666666662AF9194133333373EA8058413333333323F9194100000080E8805841CDCCCCCC08F919419A999939E18058419A999999E7F81941666666C6D780584133333333E1F8194133333353D480584133333333D3F819419A999959CC80584133333333C3F8194133333313C38058410000000068F8194166666686C48058419A99999957F81941666666C6C480584166666666E8F7194100000080C68058419A99999971F719419A999959C88058416666666668F7194166666626C6805841000000005AF7194133333393C28058410000000052F71941666666A6C0805841666666663AF7194133333333BA8058419A9999992BF71941666666A6B5805841666666660CF71941CDCCCC8CAE8058419A999999DDF619419A9999D9A680584166666666D2F61941666666A6A480584100000000D2F61941333333F39E80584133333333D3F61941CDCCCC6C95805841CDCCCCCC2EF619419A99991995805841333333332FF61941CDCCCCAC8E805841CDCCCCCC2EF61941CDCCCC0C818058419A9999998FF519419A9999397A805841333333338BF51941CDCCCCEC79805841CDCCCCCCB0F519419A999959788058410000000030F61941666666A673805841666666664AF6194133333333728058419A99999945F61941000000A071805841CDCCCCCC18F61941333333736C8058413333333301F61941333333F36980584133333333D3F51941CDCCCCAC658058419A99999987F51941CDCCCC4C6B805841CDCCCCCC5CF51941333333536D8058416666666630F51941CDCCCC0C6F8058419A999999CDF4194166666686708058419A99999907F41941333333137180584166666666C8F319419A99999968805841666666666EF31941000000A05C805841CDCCCCCC12F319419A999959508058419A999999B9F2194166666666448058419A99999971F21941666666A63D8058416666666690F11941CDCCCCEC318058416666666602F11941CDCCCCAC2A805841CDCCCCCC9CF01941CDCCCC8C1D8058419A99999907F019410000002013805841CDCCCCCCB6EF1941CDCCCC2C0D80584100000000DCEE1941CDCCCC0C138058410000000074EE19419A9999191480584100000000F8ED19416666666611805841CDCCCCCC64ED19419A999979158058419A999999C9EC1941CDCCCC8C1A805841666666661AEC1941666666A61F805841666666666AEB19419A9999B91F805841CDCCCCCC82EA19419A99999920805841333333339BE919419A99993921805841333333332BE91941666666862180584133333333CBE719419A9999F9228058419A99999913E719410000004025805841CDCCCCCC62E6194166666626278058416666666620E619419A9999B927805841CDCCCCCC2AE6194100000080248058419A9999992BE61941666666C6228058416666666624E61941333333D321805841CDCCCCCC2AE61941666666A6208058413333333323E61941333333331F805841CDCCCCCC28E61941333333D31D805841666666661CE61941666666E619805841333333331FE619419A9999F9168058419A99999919E6194100000000168058413333333327E61941666666E6108058413333333329E61941333333F30E8058416666666634E61941000000400D805841CDCCCCCC4CE619419A9999990B8058419A99999961E6194166666686098058410000000068E619419A999939088058410000000072E61941CDCCCC0C068058416666666672E61941CDCCCCAC048058410000000070E61941333333F301805841CDCCCCCC6EE6194100000060008058410000000078E6194133333333FD7F58416666666666E61941666666E6FA7F58413333333351E6194100000040F97F5841000000002CE61941CDCCCC4CF87F584100000000FCE51941333333F3F47F584133333333E1E51941000000A0F17F584100000000D4E51941333333D3F07F584133333333B1E51941000000C0EB7F584166666666AAE51941000000E0E87F584133333333ADE51941666666C6E67F584100000000B4E51941666666A6E17F58419A999999AFE5194133333373DE7F5841CDCCCCCCAEE51941000000C0DA7F5841CDCCCCCCA8E519419A9999D9D77F584166666666AEE519419A9999D9D57F58419A9999999BE5194133333393D37F5841CDCCCCCC78E5194133333333D17F58410000000074E519419A999999CD7F5841CDCCCCCC78E5194133333373C77F5841CDCCCCCC82E519419A9999D9BB7F58419A99999989E5194133333373B07F58410000000080E5194166666626AB7F58419A99999983E5194100000000A37F58416666666670E519419A9999599F7F5841CDCCCCCC5CE51941CDCCCCAC9B7F5841000000004CE519419A9999399A7F58413333333337E51941333333B3997F5841CDCCCCCC88E41941666666E6A07F58416666666620E4194166666686A47F5841CDCCCCCC9CE319419A999919A97F5841333333331BE3194100000020AD7F5841CDCCCCCCF6E2194100000000AE7F584133333333DFE219419A9999F9AD7F58419A9999998DE1194133333353AD7F58416666666604E11941000000E0AC7F584100000000EEE0194100000020AC7F58419A999999DFE019419A9999D9AA7F584133333333CDE019419A999979A87F5841333333338FE019419A9999399C7F58410000000070E01941CDCCCC8C967F58410000000034E01941CDCCCCEC8C7F5841CDCCCCCC06E01941CDCCCCEC867F584166666666D8DF194100000000837F584166666666A0DF1941333333D37F7F5841CDCCCCCC3EDF1941CDCCCC4C7C7F584100000000F8DE19419A999999797F584166666666D0DE1941000000E0777F5841CDCCCCCCA6DE1941CDCCCC4C757F58416666666614DE1941666666066B7F58410000000092DD19419A9999396F7F58416666666642DC1941333333937A7F58416666666666DA1941666666268B7F58413333333335DA1941666666468C7F58410000000004DA1941000000008D7F58419A9999997DD919419A9999F98E7F58419A9999995FD81941CDCCCC0C937F584100000000DED71941333333F3947F58416666666692D71941CDCCCCCC957F5841CDCCCCCC90D71941CDCCCC8C977F5841000000008CD7194133333393A07F58419A99999987D719419A9999D9A77F58416666666682D71941333333B3AD7F5841333333337BD719419A9999B9B27F58413333333379D7194133333353B47F58410000000078D719419A999919B57F58413333333377D71941000000A0B57F58410000000076D71941CDCCCC4CB67F5841CDCCCCCC74D7194133333313B77F58419A99999973D71941000000E0B77F5841CDCCCCCC72D7194166666646B87F58410000000070D719419A9999D9B97F5841000000006ED7194166666606BB7F5841666666666CD71941333333D3BB7F5841CDCCCCCC6AD71941000000A0BC7F58413333333369D7194166666666BD7F5841CDCCCCCC66D7194133333393BE7F58416666666662D71941CDCCCC8CC07F5841CDCCCCCC60D719419A999959C17F5841666666665ED7194166666646C27F5841333333335BD71941333333B3C37F58416666666658D71941000000E0C47F58410000000054D7194133333373C67F58410000000050D7194166666606C87F5841CDCCCCCC4CD7194133333333C97F58413333333349D719419A999959CA7F58413333333347D7194166666626CB7F58416666666644D7194133333313CC7F58410000000040D719419A999979CD7F58419A9999993DD7194166666646CE7F58419A99999937D719419A999939D07F58416666666632D71941666666C6D17F584100000000F2D61941CDCCCCACE37F58416666666602D619419A999959228058419A999999F3D5194166666686248058416666666636D51941666666C650805841666666669ED41941CDCCCC2C78805841333333337DD41941666666E6808058419A99999937D4194166666606938058413333333301D4194133333333A280584100000000EAD31941333333D3AF805841CDCCCCCCB0D31941333333B3BC80584133333333AFD31941000000C0BD805841	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	01010000206A080000C06801DD73E51941343333B3AA805841	330130104	H	Sud	3301301	33013	33	75	4
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	01010000206A08000013EA1E762B9F1B419A9999298F8C5841	330140000	Z	Les Artigues-de-Lussac	3301400	33014	33	75	10
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	01010000206A080000400FAFB13CF71A4166666646FF835841	330150000	Z	Arveyres	3301500	33015	33	75	17
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	01010000206A0800008A5A9AC479421A4166666656CF8A5841	330160000	Z	Asques	3301600	33016	33	75	6
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	01010000206A080000F85CF97601FF1A419A99995976565841	330170000	Z	Aubiac	3301700	33017	33	75	6
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	01060000206A080000010000000103000000010000006D010000666666667C401A41000000400C9258419A9999992F421A413333337333925841CDCCCCCC2C431A419A9999B94F92584166666666AA431A41666666E65A92584166666666DA431A41666666A661925841CDCCCCCC88441A41666666A6809258419A99999941451A41666666269A925841000000009A451A4100000040A99258419A999999D3451A4100000080BD9258416666666696451A41CDCCCC6CD1925841CDCCCCCCA2451A41CDCCCC6CD792584166666666C8461A41CDCCCC6CFD9258413333333321471A41CDCCCCEC0B935841CDCCCCCC5E471A41000000601B935841CDCCCCCC44471A41CDCCCCEC26935841CDCCCCCCDC461A4100000080359358413333333379461A41666666663D9358413333333361471A41CDCCCCEC5C9358419A9999991B491A41333333939693584100000000224A1A41666666E6BB93584133333333014C1A419A9999D901945841333333339D4E1A41CDCCCC4CEE935841CDCCCCCC104F1A4100000080FD93584133333333FB4F1A419A999979FC935841CDCCCCCC60501A419A9999B91694584166666666F2501A419A9999D90F9458413333333351511A41CDCCCCAC2F94584166666666E4511A413333333330945841CDCCCCCCAC511A41000000E04B94584100000000BE531A41CDCCCCEC53945841666666668A541A41666666A64894584166666666C6551A413333333360945841666666666A561A41000000A0699458419A99999915571A419A9999F97094584166666666AE571A416666660679945841666666660E581A4100000060809458419A999999AD591A413333339358945841CDCCCCCCD25A1A41666666666594584100000000265C1A413333339349945841CDCCCCCC9A5D1A41000000202A945841CDCCCCCC4A5E1A41333333F31D9458419A9999997D5F1A41CDCCCC6C16945841CDCCCCCC0E601A4100000000119458416666666612601A419A999919069458419A99999975611A41333333B30194584166666666EE631A4133333333F49358416666666664631A4166666686D69358419A999999BB661A419A9999F9B99358410000000008671A41000000A0C69358419A99999933681A41CDCCCCCCBC93584100000000026B1A4100000000C99358419A999999F96A1A419A999939BF935841666666662A6B1A4133333373AF935841CDCCCCCCEE6B1A419A9999599693584100000000D26C1A419A99999988935841CDCCCCCC3E6D1A41333333137F93584100000000E26D1A41000000E07C93584166666666EE6E1A41000000807B9358419A99999907701A4100000040789358413333333391711A41666666C6709358413333333385721A41CDCCCCEC6693584100000000D4721A41CDCCCC4C629358416666666662731A41666666C65D9358416666666692731A419A9999B968935841CDCCCCCC96731A41666666066F9358410000000072731A41CDCCCCAC729358419A999999FD721A419A9999998593584100000000E8721A419A9999798B93584100000000E6731A41CDCCCC0CA5935841CDCCCCCCD8731A41333333B3B09358416666666650731A4166666666B99358419A999999F3721A4166666606C393584100000000AC721A41333333F3CE93584133333333B7721A4166666606D79358419A99999909731A41CDCCCC4CE49358413333333325731A41333333F3EE93584133333333CB731A410000006000945841000000004A741A41CDCCCC8C0794584166666666AA741A41000000A016945841CDCCCCCCDE741A4166666666199458419A999999D5741A41CDCCCC2C209458419A999999E1741A41333333D33094584100000000D2741A41CDCCCC0C3994584133333333FD741A41666666064794584166666666FE741A41CDCCCC6C4D94584133333333E1741A419A9999595A945841CDCCCCCC70741A419A999919769458410000000078741A4166666686809458416666666694741A41000000E08894584166666666FE741A419A9999F9919458410000000018751A419A999939999458416666666608751A41CDCCCCEC9D9458416666666638751A41CDCCCCECA3945841CDCCCCCCD4751A41333333B3AE9458410000000018771A41CDCCCCCCAE945841333333334F781A41666666E6AF9458419A999999A9781A4133333393B1945841CDCCCCCC16791A41666666A6B694584166666666AA791A4166666666BB94584100000000B67A1A41666666A6C294584100000000227B1A41666666E6C694584100000000867B1A41666666E6CC94584100000000D07C1A41CDCCCCCCD2945841CDCCCCCC767D1A4133333333D8945841CDCCCCCCB07D1A4100000020DC945841CDCCCCCC607E1A41333333D3DF94584166666666827F1A419A999939F19458413333333323801A4166666646F6945841666666662A811A41000000A0F79458410000000082811A4166666646F99458413333333317821A4100000080FE94584166666666C4821A419A9999F9059558416666666680831A41666666660A9558419A999999E9831A41666666C606955841CDCCCCCC5C841A41333333530695584100000000CC841A41CDCCCC8C019558419A99999931851A4133333393F99458419A999999C5851A41333333B3F59458419A99999911861A41333333F3FA945841CDCCCCCC30861A419A99993900955841CDCCCCCC90861A419A999979FB9458419A99999909871A4133333333FB9458419A999999F3871A416666668604955841000000001C891A41333333B30595584133333333BF891A410000008004955841CDCCCCCC648A1A419A999919FF94584133333333878B1A419A99993901955841333333337F8C1A41333333D3FE9458419A999999078E1A41CDCCCCACFD94584166666666A28E1A41333333B3FF94584166666666248F1A41CDCCCCCCFF94584133333333D78F1A419A999959029558419A999999B5901A419A9999B9009558410000000090911A416666668604955841666666661C921A41333333B30A955841CDCCCCCC30921A41333333730E9558416666666650921A41000000A046955841CDCCCCCC4C941A41666666A6439558419A999999E7941A41666666E6419558413333333397951A41333333334295584166666666D4971A410000000035955841333333338B981A41666666A63295584133333333EB981A419A9999D939955841CDCCCCCC6E9A1A41CDCCCC2C3595584100000000189D1A41666666662A95584133333333E3A01A41666666461795584133333333E9A01A41CDCCCC0C13955841CDCCCCCC88A01A41CDCCCC6C079558419A999999C99E1A4133333393DD9458419A9999994B9E1A419A999999CE94584100000000AA9D1A4100000080B4945841CDCCCCCC389D1A4133333393A494584133333333719C1A41333333138C9458419A999999E99A1A419A999959599458419A999999BB981A41CDCCCCEC0F94584100000000DE971A41333333F3139458413333333365971A4100000080109458419A9999990D971A41CDCCCCAC059458416666666608971A41666666E6EE935841000000001A971A4100000020D6935841666666664A971A41CDCCCC6CC8935841CDCCCCCCC2971A4133333313BE935841CDCCCCCCC0971A41CDCCCCACB8935841CDCCCCCC74971A4133333393AF93584100000000E2961A41333333D3A893584166666666C0951A419A999939989358410000000074951A41333333B39293584133333333C3941A41000000207B935841333333339F941A41666666A66E93584100000000AC941A416666668663935841333333337F941A419A9999394E9358419A9999998D931A41000000C03E9358419A9999991F931A41333333D33493584100000000FC921A419A9999992E935841333333335F921A41666666E60B9358419A999999E3911A41CDCCCCCCF4925841CDCCCCCC84911A4100000000E8925841000000004A911A41CDCCCC0CDC9258410000000014911A4133333333C19258416666666636911A419A9999B9A9925841000000005A911A4133333393A992584100000000F2901A4166666626939258416666666664901A41333333D38292584133333333E98F1A41CDCCCC6C7892584133333333C58F1A41000000E0719258419A99999905901A41CDCCCC4C65925841333333334B901A41CDCCCCCC61925841CDCCCCCC90901A41333333135892584100000000EE901A419A9999B9519258419A99999985901A419A999919489258419A9999994F901A41333333133E9258419A9999998B901A41CDCCCC2C39925841000000005A901A419A9999592792584133333333A7901A41333333532792584100000000EA921A41CDCCCCCC20925841CDCCCCCCAA921A419A9999590A92584100000000C2931A4133333333069258413333333389941A419A9999D9FF9158419A99999961951A41333333D3D79158419A999999DD951A41000000A0CF9158416666666694961A4133333313CD915841CDCCCCCCFC961A419A9999D9C49158419A99999923971A4133333313BC9158413333333323971A41CDCCCC0CB59158416666666624981A41000000809D91584166666666EA981A41000000E09891584133333333FF991A419A9999D99491584133333333179A1A413333339382915841000000005E991A41CDCCCCAC8191584133333333A3981A41000000807F915841333333335B971A419A9999597691584166666666AC961A41CDCCCC0C6F9158419A999999EB951A419A99999962915841000000009E961A41000000405391584166666666D4961A419A999939499158413333333383961A41666666463F91584133333333D5971A410000006031915841CDCCCCCCCC971A41CDCCCC8C289158413333333383981A41CDCCCCCC1F915841CDCCCCCC84981A41CDCCCCCC17915841CDCCCCCC38981A41CDCCCC0C1091584100000000CC971A41666666860E915841000000004E961A41CDCCCC0CEC90584133333333F3961A41CDCCCC8CE590584166666666A4961A41CDCCCC0CDC9058413333333329971A41CDCCCC4CD6905841333333335F971A41000000E0D09058419A999999FD961A41000000C0C490584166666666CA961A419A999919BC9058413333333385961A419A999939B790584166666666C8951A4133333313A29058413333333347951A41333333738C905841333333332D951A41000000208B9058413333333347941A416666660665905841CDCCCCCC34951A41CDCCCCEC559058419A99999901951A41CDCCCC2C49905841000000009C941A41CDCCCC8C3B905841666666667E941A41333333D32C9058413333333349941A419A9999991F9058419A9999990F941A41333333D31A9058419A99999981931A41000000E00A9058413333333389921A41000000A0EC8F58419A99999931911A4166666686DD8F5841CDCCCCCC42901A4100000080D08F584166666666528F1A41666666A6BD8F584100000000388F1A41CDCCCCCCBC8F5841CDCCCCCC9C8E1A41666666C6C28F584100000000208E1A41CDCCCC0CC58F5841000000007A8D1A41000000E0C58F58419A999999B18C1A41000000E0C48F58419A9999995D8C1A41CDCCCCCCC58F5841CDCCCCCC828B1A419A999959CC8F584100000000528A1A41666666A6DD8F584133333333098A1A41CDCCCC6CDC8F584100000000B6891A41000000E0CC8F58413333333315891A41000000A0B98F584133333333AD881A41000000E0B28F584133333333FB871A4133333313AD8F5841CDCCCCCC8A871A41000000C0AD8F584100000000BA861A419A9999D9B48F5841CDCCCCCCF8851A41CDCCCCECBC8F5841CDCCCCCC8E851A4100000020C08F5841CDCCCCCCFE821A41000000E0CB8F5841CDCCCCCC1E811A4100000080DD8F58416666666652801A41666666C6E38F584133333333257F1A4133333353C58F584166666666867E1A41CDCCCC8CAF8F5841000000001E7E1A41CDCCCCCC9D8F584166666666927D1A419A9999B9A08F5841333333331D7D1A4100000060A98F5841CDCCCCCCB47C1A41333333B3B68F58419A999999CF7B1A41666666A6C28F5841333333337F7B1A4133333333C08F5841666666661A7B1A41000000C0B88F5841CDCCCCCCB67A1A41CDCCCC8CBC8F584166666666EA791A41000000A0CA8F58413333333379791A4133333353CF8F58419A999999BF781A41666666C6D98F58416666666654771A4100000000E38F58419A999999FF761A4166666626E78F58419A99999967761A4166666606EB8F58419A99999947751A41CDCCCC8CF98F58413333333399741A41666666A604905841333333331D741A41000000800890584166666666DE731A419A9999790D9058416666666654731A41666666661490584133333333FD711A419A9999191E905841666666666A711A419A9999D924905841CDCCCCCC64701A41666666462990584166666666C26D1A41666666E63890584166666666BE6C1A41CDCCCCAC3F905841666666669E6B1A41000000A04990584166666666F6691A419A99999931905841000000002E691A419A9999F9269058419A99999995681A419A999979379058419A9999997F681A419A9999993D9058413333333389681A41666666E6449058410000000064681A41666666265390584100000000C8681A419A9999795A9058419A99999905691A4166666646679058419A99999943691A41333333F3779058410000000036691A41CDCCCC4C829058416666666614691A41666666C686905841CDCCCCCCFC681A41666666869290584100000000F0681A419A999919AC90584100000000C6681A419A999959BA90584133333333CF681A41666666C6BF9058419A9999991D691A41666666C6C79058410000000010691A4133333353CA905841CDCCCCCCE2671A41CDCCCC6CD5905841CDCCCCCC0A671A4133333373DE90584166666666E2651A4133333373F090584166666666EC651A41CDCCCC4CF4905841CDCCCCCC4C661A41CDCCCC2CFE90584100000000A4651A413333331302915841CDCCCCCC7E651A41333333D3F49058413333333375651A4133333373E9905841333333336B641A4133333353E190584100000000FA631A41CDCCCCCCE4905841CDCCCCCCC0621A419A9999F9E89058410000000050611A41333333B3EC905841000000002E611A41666666E6E590584133333333515F1A4100000040EC90584100000000E05D1A41CDCCCC4CF0905841CDCCCCCC525C1A41333333F3F0905841333333333F5A1A4133333373DF905841CDCCCCCC64591A4133333333DF90584100000000AC581A419A999919E0905841CDCCCCCC22581A41333333D3E4905841CDCCCCCC7E571A41333333D3EE9058419A999999FB571A41CDCCCC8C0491584166666666DE561A413333335309915841CDCCCCCCA4561A41CDCCCC4C0D9158419A999999E3561A41666666861B915841CDCCCCCCC2561A41666666C61E915841000000008E551A41333333B3259158410000000080521A41333333F3379158419A9999997B521A419A9999D93A91584166666666FE521A419A9999394C9158419A9999996D511A4166666666569158419A999999514F1A41666666E65F9158419A999999194E1A41000000C046915841000000005A4D1A419A9999D9539158419A999999A94C1A41000000605C91584166666666684C1A41333333F36091584133333333314C1A41CDCCCCAC6A91584166666666F84B1A41333333736D915841CDCCCCCCF24A1A41333333537391584133333333AB4A1A419A9999D97691584100000000004A1A4166666626849158419A9999992F491A416666668690915841CDCCCCCC7C481A41666666A6999158419A99999915481A41CDCCCC8CA2915841CDCCCCCCAE471A41666666C6A69158419A9999992D471A41333333B3B6915841666666667E461A4100000020C79158410000000000461A41CDCCCC6CCF91584100000000C6441A4133333313E6915841CDCCCCCCA2431A41CDCCCCAC009258410000000056431A41333333330492584100000000AE421A419A9999D90492584100000000DE411A41CDCCCC2C079258416666666658411A41333333D309925841666666667C401A41000000400C925841666666667C401A41000000400C925841	01010000206A080000B42697C4046A1A413333336373925841	330180000	Z	Val de Virvée	3301800	33018	33	75	21
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	01010000206A08000058BB6F032BAF1741CDCCCCBC2B735841	330190000	Z	Audenge	3301900	33019	33	75	82
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	01010000206A08000090D130C16A721C4166666636F3715841	330200000	Z	Auriolles	3302000	33020	33	75	7
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	01010000206A0800005628C287FA531B4100000080945A5841	330210000	Z	Auros	3302100	33021	33	75	15
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	01060000206A080000010000000103000000010000005102000033333333ADA918419A999919E48D5841333333335BA9184133333353DE8D5841CDCCCCCCF4A7184100000020CB8D584133333333FDA61841CDCCCC6CBE8D584100000000A4A318419A999939918D584133333333499F1841333333D3558D584166666666209F18419A999999518D5841000000009A9E184100000080508D58419A9999994B9E1841333333D34C8D5841CDCCCCCC789B184100000000268D5841000000003A9818419A999979FA8C58410000000020961841666666C6DD8C5841666666666295184166666646D48C5841CDCCCCCC149418419A9999B9C18C584133333333E19218419A999959B28C584166666666028F1841000000E07D8C584166666666BC89184100000000378C584166666666A28918419A999999338C58419A99999939861841666666E6048C584100000000808418419A999979EE8B584166666666968318419A9999B9E18B58419A999999CD801841CDCCCC8CBC8B584166666666307C1841CDCCCCACBC8B5841333333334B77184166666686BC8B58410000000072761841CDCCCCACBA8B5841666666660C761841333333D3D18B5841000000009C751841333333B3EE8B5841666666662A751841CDCCCC2C088C5841333333339B721841333333D3A38C58419A999999E571184100000000D18C584166666666C07018419A9999F93E8D58410000000050701841000000206C8D58419A999999FB6F1841000000008C8D584166666666AA6F1841333333F3A78D5841CDCCCCCC506F18419A999999CA8D5841000000001C6F184100000080D88D584133333333CF6E1841666666C6028E584133333333796E1841000000201D8E584166666666EE6D184133333393418E584166666666AC6D184100000000518E58419A999999996D1841666666E6588E58419A999999956D1841000000E0688E584100000000C06D1841333333138B8E58419A999999D76D18419A999999948E58419A999999576F184100000000C78E58410000000050701841333333530A8F58419A9999998D701841666666C6168F58419A9999998F701841000000C0258F584100000000E070184133333333288F5841CDCCCCCC22711841666666E63F8F58419A999999637118419A999919648F584133333333A1711841CDCCCC8C708F58413333333393721841666666A6808F5841CDCCCCCC94721841666666668E8F5841CDCCCCCC5A721841666666669D8F58416666666672721841000000E0B88F5841CDCCCCCC2872184166666666CA8F5841CDCCCCCCC27118419A999919D88F5841666666666C7118419A999999DD8F5841333333338D71184166666686E58F584133333333E1711841CDCCCC4CE98F5841CDCCCCCCE671184166666626F08F58413333333359721841666666E6F28F584133333333D172184166666646FB8F5841333333335F73184133333373009058413333333371741841CDCCCC0C189058416666666678741841333333B320905841666666661A751841333333732590584100000000DA7518419A99993932905841CDCCCCCC4E761841000000A0379058410000000076761841CDCCCC6C3B9058419A999999537618410000008045905841000000009476184133333313469058419A999999BB761841CDCCCC4C4B905841666666663A7718410000008056905841CDCCCCCCA6771841CDCCCCEC6390584133333333D77718419A9999B96590584133333333AF781841000000A0669058410000000044791841000000C06B905841666666661E791841666666A673905841CDCCCCCCDA781841666666A67290584100000000BE7818419A9999197690584133333333E5781841CDCCCC4C799058419A999999FF7818419A99995981905841666666667A791841666666468290584100000000127A18419A99993985905841000000001C7A1841666666A6889058419A999999837A1841000000A08B90584100000000847A1841333333D38E905841666666663A7A18419A99991992905841000000001C7A1841CDCCCCCC9F905841333333333D7A18419A999939A790584100000000EE791841CDCCCC4CB0905841CDCCCCCC96791841000000C0AE905841CDCCCCCC7A79184133333333B69058419A99999907791841666666E6BD905841000000003879184133333333C59058419A999999E779184133333333CF905841333333339D7A1841666666A6DB90584166666666DE7A1841000000E0E590584133333333177B18419A9999F9E2905841CDCCCCCC587B184133333333E7905841CDCCCCCC567B1841CDCCCC4CED90584100000000CA7B1841CDCCCC6CEF90584166666666EE7B1841CDCCCC0CF690584166666666247C1841333333B3F690584100000000367C184100000000FB905841CDCCCCCC6A7C18419A999999FB9058419A9999994F7C1841CDCCCC0C0B915841000000008A7C1841666666C620915841000000007C7D1841666666A62191584166666666DC7D1841CDCCCCEC2F91584166666666D47D1841000000C036915841333333338B7D1841666666263C915841CDCCCCCCA47D1841000000C047915841666666661A7E1841666666264791584166666666327E18416666662649915841CDCCCCCCC07E18419A9999994C91584133333333DF7E1841333333B35491584166666666D47E1841666666E65B9158419A999999797E1841000000E06191584133333333F57D18416666666663915841CDCCCCCC3A7E1841CDCCCC2C6F91584166666666247E184166666686799158419A9999994D7E1841CDCCCCCC7A91584100000000527E18419A99995987915841CDCCCCCCA87E1841666666E68B9158419A999999857E1841333333F392915841CDCCCCCCAC7E1841333333F3999158419A999999817E18419A999999A091584100000000187E1841CDCCCCECA69158419A999999B97D1841CDCCCCACA591584166666666447D1841000000E0AF9158419A999999857D1841CDCCCC4CAF91584166666666867D1841CDCCCCECB3915841333333333B7D1841666666C6BF9158419A999999EB7C184133333393C291584100000000E67C18419A999959C59158419A999999477D184166666666C69158419A999999777D18419A9999D9CC91584100000000327D18419A999979D191584133333333357D18419A999959D5915841CDCCCCCC707D18419A999919D691584133333333C37D184100000060DB91584166666666F87D1841CDCCCC6CDA91584166666666E27D184100000060DF915841CDCCCCCC267E18419A9999F9E8915841666666660A7E184166666646ED915841CDCCCCCCAA7D18419A999999E9915841666666663E7D184100000080F0915841CDCCCCCC9C7D184133333393F5915841666666669E7D1841000000800292584133333333557D184133333313089258419A999999937D1841CDCCCC6C0A9258419A999999A97D18419A9999591292584166666666E27D18419A9999B919925841CDCCCCCCAA7D18419A9999591E9258419A999999D17D1841CDCCCCEC2092584166666666A47D18419A9999992E925841333333332B7D1841666666662F9258419A9999994F7D1841CDCCCC4C35925841333333332F7D18419A9999F93692584100000000687D1841CDCCCCEC3B9258419A9999994F7D1841000000203F92584100000000867D1841000000E04392584100000000CA7D18419A9999395092584166666666187E1841CDCCCCEC52925841000000003C7E1841666666A65A92584133333333157E184166666666629258419A999999857E18419A999979659258419A999999B17E18419A9999796092584166666666847E1841000000205B925841CDCCCCCC387F1841000000005E925841333333334B7F184166666686639258419A999999237F1841333333B36D92584166666666767F1841666666666E925841333333338B7F1841333333F38892584133333333717F18419A9999798C92584166666666F27E18419A9999198D925841CDCCCCCCD27E1841CDCCCC6C97925841CDCCCCCC9E7E1841333333D39F92584133333333F17E1841000000409E92584166666666187F1841CDCCCCCCA092584166666666D47E18419A9999D9A59258419A999999DD7E18419A999939A892584166666666627F18419A9999D9A4925841666666666A7F184166666686B492584100000000367F184166666646BA9258419A999999337F1841CDCCCCECC09258419A999999FB7E184133333393C09258419A999999CF7E1841CDCCCCECC392584100000000887E1841CDCCCCECBC925841333333332D7E184166666686C2925841333333335D7E184133333353C992584133333333F17D18419A999939D0925841666666660C7E184100000020D892584166666666C67D1841666666C6DC925841333333339F7D184133333373D792584100000000747D18419A999979DD925841000000003E7D184166666626D992584100000000047D184133333393E092584133333333BD7C1841CDCCCC2CE192584100000000A27C184166666646E79258419A999999137C184166666606E49258419A999999ED7B184100000040E6925841CDCCCCCC407C184166666686E7925841CDCCCCCC6A7C184133333333ED925841CDCCCCCCA67C18419A999999ED92584100000000B27C184166666606F192584133333333257C1841000000C0F792584100000000F47B1841333333F3FC925841CDCCCCCC867B1841CDCCCCACFE92584166666666967B1841CDCCCCAC0593584133333333BD7B1841666666C60893584100000000AC7B1841CDCCCC0C0D9358419A999999477B1841CDCCCC2C0C93584166666666427B1841CDCCCC6C1093584166666666807B1841666666C61293584100000000CE7B1841CDCCCC4C1A935841CDCCCCCCC87B1841333333D31D935841666666667C7B18413333331320935841666666665A7B18419A9999592B93584100000000C27B1841666666262D93584100000000047C1841CDCCCCEC3393584166666666047C1841000000403793584100000000887B1841000000E037935841CDCCCCCCB47B1841000000603B935841666666668C7B1841000000E03E935841CDCCCCCCD87B1841CDCCCC0C3F93584166666666A47B1841333333334293584133333333277C18419A9999B94B9358419A999999E97B1841CDCCCC2C4E935841CDCCCCCC127C1841666666465393584166666666027D18419A999919569358419A999999EF7C18419A9999796293584100000000267D1841CDCCCC0C6C9358419A999999417C1841000000007A935841666666664E7C18419A99993983935841000000003A7C1841000000A085935841000000007A7C1841666666C69393584100000000E67C1841666666669593584100000000567D1841000000009A9358419A9999993D7E184100000040AC93584166666666747E1841000000E0B393584100000000BC7E184133333333B993584166666666567F1841CDCCCC6CC1935841CDCCCCCCAA7F184100000040CC9358419A999999AB7F184166666646D3935841CDCCCCCC7C7F184100000000D793584133333333C57F1841CDCCCCCCDA93584133333333F57F184100000020EA935841CDCCCCCC08801841000000A0F49358416666666664801841CDCCCC6CF6935841333333335F801841CDCCCC6CFB93584133333333A1801841666666A601945841CDCCCCCCF08018419A99991903945841000000001E81184100000040089458410000000068811841666666860B9458419A999999FB811841333333B30A945841000000005E82184133333393109458416666666682821841666666861A94584133333333BD821841CDCCCCEC199458419A999999B1831841666666A62894584100000000D6831841CDCCCC4C2C945841CDCCCCCCDA831841333333B3369458419A999999A3831841CDCCCC6C3B94584166666666D0831841CDCCCC2C4C945841333333331984184166666646539458419A999999E5841841CDCCCCCC5E9458410000000006861841CDCCCC0C6794584133333333EB861841333333F36794584100000000368718413333337365945841CDCCCCCCC2871841666666666694584166666666D0871841333333F36C9458419A99999929891841CDCCCC4C7D9458419A999999418918419A9999D984945841CDCCCCCC328A1841000000E09E9458419A9999997D8A184166666626AE94584133333333758A1841CDCCCC8CB994584100000000CC8A184133333333C0945841000000008A8B184166666686C3945841000000006E8B1841666666E6CE94584100000000E28A18419A999959D794584166666666E68A184166666686DA94584100000000948B1841666666A6E594584166666666628B18419A9999D9E994584100000000928B1841CDCCCC8CEB945841000000009E8B18419A999959F194584133333333C78C18419A999939F5945841666666662A8D184100000040FC945841CDCCCCCCE88C18419A9999D9FC94584133333333258C1841000000A003955841CDCCCCCC8E8B18416666662607955841CDCCCCCCFE8A1841333333F30C955841666666668C8A1841CDCCCC6C0B9558416666666656891841333333531C95584166666666A0881841CDCCCC6C2D9558419A9999997D89184166666666399558419A9999996D8A18410000008044955841CDCCCCCC7A8B18419A9999395F955841CDCCCCCCBA8B1841000000A05E95584100000000168D18419A999919739558419A999999178E18413333335381955841CDCCCCCC488E1841666666268695584166666666648E184166666626A795584166666666AE8E1841CDCCCC6CB995584133333333158F184100000060CC955841CDCCCCCC488F1841000000E0E1955841CDCCCCCCB48F1841333333B3ED95584133333333CD8F184166666666FC9558419A9999999B8F18419A9999190A96584100000000C48F1841000000200E9658413333333369901841CDCCCC6C0D96584133333333CD901841333333F30E9658416666666622911841333333F31296584133333333E1911841CDCCCC6C199658419A9999993B921841000000C01D9658419A99999979921841666666A61996584166666666F2921841333333D31F965841333333331B931841CDCCCC4C27965841CDCCCCCC809318419A999939319658419A999999BD931841333333F33996584133333333879418413333339347965841CDCCCCCC2A9718419A999979719658419A99999963991841CDCCCC6C8C9658419A999999ED991841333333B38F9658419A999999CB9A1841CDCCCC0C92965841666666665A9B1841CDCCCC0C95965841CDCCCCCCB49B1841CDCCCCAC9996584166666666F89B1841CDCCCC4CA196584133333333419C1841CDCCCCCCA49658419A999999AF9C184133333333AD96584100000000069E1841CDCCCCACB296584166666666529E1841CDCCCC2CB296584133333333119F1841CDCCCCECAB96584166666666A29F18419A9999D9A99658419A9999993BA01841333333F3AD96584133333333DBA018419A999959B896584133333333F9A11841CDCCCC6CC896584133333333A7A2184133333393CF9658419A9999999BA3184100000060D6965841000000000CA4184133333373D89658419A9999994FA41841000000E0D79658419A9999995FA41841333333D3D3965841CDCCCCCCA8A41841CDCCCCACD19658413333333309A5184133333353D8965841666666665EA61841666666C6E4965841CDCCCCCC8EA718419A999919EF965841CDCCCCCCD6A81841666666C6F4965841666666663CA9184166666626F796584166666666F8AA1841666666A603975841CDCCCCCC54AB18419A999959089758419A999999C5AB1841333333130B97584133333333DBAD1841CDCCCC0C1C975841CDCCCCCC56AE18419A999919219758416666666664AF1841000000402A97584100000000A2B01841CDCCCC2C2D97584166666666B0B11841333333D32C9758413333333349B518419A999939299758419A999999DDB51841CDCCCCAC10975841CDCCCCCC0CB71841CDCCCCAC0D97584166666666FEB6184100000060219758419A999999DDB618419A9999B93697584133333333C5B61841666666063E975841666666669CB618419A9999F956975841CDCCCCCC46B71841333333D35A975841CDCCCCCC8CB81841666666066497584133333333F7B81841666666A669975841CDCCCCCCBCB9184100000040719758416666666606BD1841000000C09297584100000000EABD1841CDCCCC2C93975841333333332DC01841666666669597584166666666C0C218419A999999B2975841CDCCCCCCE4C51841CDCCCC4CD59758419A999999E7C61841666666E6DF97584166666666DEC618419A999919E79758416666666624C7184133333353F097584100000000B0C8184100000000029858413333333301C9184166666686009858416666666642C91841CDCCCC8C0A985841CDCCCCCC72C91841CDCCCC2C0A98584133333333B7C918419A9999790F9858416666666622CA18416666662612985841666666669CCA1841333333D30D98584166666666D6CA18419A9999F910985841333333330DCB1841000000A00F985841CDCCCCCCCECB184166666686109858419A999999CDCC1841000000C00C9858419A99999981CD1841666666A60C9858419A999999A9CD1841000000E00D985841CDCCCCCC50CE1841CDCCCC0C0B9858410000000074CE184133333373029858416666666650CF1841333333D3009858413333333391CF1841000000A0FE9758419A9999993DD01841CDCCCC4CEE9758413333333397D01841CDCCCCCCEA975841CDCCCCCC36D11841CDCCCC0CEB9758413333333391D11841000000E0EC975841CDCCCCCC3AD218419A999999EA9758419A999999C1D2184166666686EA9758419A99999997D318419A999939E39758419A9999992BD318419A9999D9D0975841CDCCCCCCF4D21841666666A6C99758419A999999E5D2184166666626A897584166666666B8D21841333333D37497584100000000D4D218419A99995969975841CDCCCCCC66D31841CDCCCCCC4D975841CDCCCCCC52D31841CDCCCCAC489758419A999999AFD31841CDCCCC8C339758416666666600D41841333333532997584166666666D8D418419A9999B9249758419A99999941D51841000000C01B9758413333333381D51841CDCCCCAC129758419A999999C7D6184133333373F4965841666666663ED718419A999979EC9658419A999999BFD7184133333313E69658416666666628D8184133333393DD9658410000000092D818419A999939CF96584133333333ABD81841666666C6C89658419A999999A9D8184166666606BC96584133333333CBD81841CDCCCC4CB29658410000000050D8184100000040979658419A999999C3D718419A9999B98696584100000000AED71841333333737E965841CDCCCCCCA4D718410000006071965841CDCCCCCC72D7184133333313669658410000000016D71841000000C0579658410000000032D61841000000E02E96584166666666BED51841000000600A9658419A999999A7D51841333333F3FE955841CDCCCCCC9AD51841CDCCCCCCEB95584133333333BFD5184133333373DE95584166666666B6D518419A9999D9D49558410000000094D518419A999939C99558413333333371D51841333333F3B6955841666666666AD51841CDCCCC0CA69558410000000048D51841333333539B9558413333333397D41841666666C698955841CDCCCCCC22D4184166666646989558419A99999909D418419A9999798B9558413333333343D41841000000C06A955841000000006ED51841666666C62A95584100000000BED51841000000401D9558410000000010D61841CDCCCC0C14955841000000006CD61841000000C001955841CDCCCCCC64D61841CDCCCCACF6945841333333333DD61841CDCCCCECEA945841CDCCCCCCA8D51841333333B3DC945841CDCCCCCC56D5184166666626D394584166666666F2D418419A999999CD94584133333333C9D41841666666A6C19458419A9999999FD51841666666C6C394584166666666A4D81841CDCCCC0CC79458413333333335DA18419A999979BF9458419A999999D3DA184133333353BD945841CDCCCCCC36DD18419A9999D9B7945841666666660EDE1841CDCCCCCCB99458419A999999C7DE1841CDCCCC8CB9945841CDCCCCCCA8E018419A9999B9B69458416666666680E21841333333B3C09458419A99999977E318419A999939C79458419A999999F1E3184133333333C99458410000000082E4184100000080C894584100000000DEE31841666666A6B4945841CDCCCCCC4CE31841666666A6B0945841CDCCCCCCECE1184166666606AA945841333333337BE01841CDCCCC2CA094584100000000E0DF18419A9999199B9458419A9999994BDF1841000000E09794584133333333A3DE18419A9999F98F9458419A999999E5DD184133333313819458419A9999990DDD18419A9999397494584100000000DCDC18419A9999B96F945841CDCCCCCC08DC1841000000A062945841CDCCCCCC88DB1841666666E65B9458413333333343DA184166666686559458419A999999F5D918419A999979439458419A99999993D91841CDCCCC4C3A945841CDCCCCCC66D91841000000E031945841333333331FD91841333333F329945841CDCCCCCC8AD818419A99991914945841CDCCCCCC56D818419A999979099458410000000058D7184133333393E893584166666666D6D618419A999939DC93584133333333ADD6184133333333D393584133333333C9D61841CDCCCC2CCB9358410000000014D718419A9999B9C09358410000000000D718419A9999F9B69358410000000024D71841CDCCCCECAD9358419A999999C9D71841000000C0AA93584100000000D6D91841CDCCCC6C9C935841CDCCCCCC32DA1841CDCCCCAC9C9358419A99999915DB1841000000609993584166666666F4DB18419A9999198E935841CDCCCCCCA2DC1841CDCCCC4C86935841666666660EDD1841CDCCCCEC82935841CDCCCCCCF0DD1841333333B37E9358419A999999E7DE184133333313779358419A99999917DE1841333333136993584133333333D5DD1841000000C0679358413333333367DD18410000004061935841CDCCCCCC30DD1841000000E055935841666666665EDD18413333335347935841666666667ADD18419A9999B932935841666666666EDD1841CDCCCCCC21935841000000007EDD1841000000E018935841CDCCCCCCBADD1841333333D3089358410000000028DF18419A999959EC92584100000000DEDF1841CDCCCCCCD792584166666666D8DF1841333333F3CD925841CDCCCCCC7EDF1841CDCCCCECBC92584133333333CBDE1841CDCCCC2CA6925841000000006CDE184166666606A19258413333333399DD1841CDCCCCEC9992584166666666ECDC1841000000E08F92584166666666C0DC1841000000A08792584133333333FFDC1841000000E0729258419A99999967DD18419A99995957925841666666668ADD1841000000805192584100000000E6DD1841000000604A92584133333333D5DD1841CDCCCC2C469258416666666620DD1841000000C0309258410000000062DC1841666666862692584166666666ECDA184100000060179258419A99999983DA1841CDCCCC6C0F92584100000000E0D918410000002006925841666666661ED9184100000040F791584100000000C0D8184166666686F6915841CDCCCCCCA4D8184166666686EE9158419A9999999BD8184166666606E291584166666666BED81841CDCCCC2CCF915841CDCCCCCC1ED91841000000E0C2915841CDCCCCCC24D91841000000C0B4915841CDCCCCCC54D9184100000040AC915841CDCCCCCC16D9184133333333A19158416666666682D8184166666646959158419A999999B7D71841333333B37F9158413333333351D71841000000C0779158419A999999A9D61841000000E072915841CDCCCCCC7ED61841000000206A91584166666666E2D51841CDCCCC6C609158410000000078D418419A9999194891584133333333EBD31841CDCCCCEC4191584166666666AED318419A9999F93C915841000000000ED31841CDCCCCCC3691584133333333D1D218419A99999930915841CDCCCCCC5CD218419A9999591A915841CDCCCCCC26D21841000000C0119158410000000032D21841CDCCCC2C089158419A9999991FD21841CDCCCC6C0091584166666666EED11841666666A6FC9058419A999999BBD0184133333353F8905841333333337DCF18419A999999ED905841333333338BCE18419A9999B9DE90584133333333FDCD184133333393CE9058416666666670CD184166666626C79058419A9999990BCD184133333373BE9058416666666616CC18419A9999D9B59058416666666662CB1841CDCCCC2CB290584133333333ADCA184166666686A9905841CDCCCCCCBCC91841CDCCCCACA390584166666666DCC71841CDCCCCAC9D9058419A999999D7C61841CDCCCC0C95905841CDCCCCCC72C61841000000E08E9058413333333349C61841666666268190584166666666E4C51841333333337C9058410000000030C51841CDCCCC4C7790584166666666DAC31841000000806890584100000000D4C21841666666E655905841000000002EC2184100000040439058419A999999A1C11841333333933F905841CDCCCCCC14C118416666662638905841000000004CC01841666666C63090584100000000BCBE18419A9999B92E905841333333333BBC1841CDCCCC0C259058416666666636BB1841333333B31D9058413333333329B81841000000A00C9058419A99999907B718416666660605905841666666662CB6184166666626E08F5841CDCCCCCC34B5184166666606B98F58419A99999937B31841666666A6678F584100000000F2B1184100000060328F58416666666644B01841666666E6EE8E58419A99999941AF1841666666E6C48E584133333333D5AE1841666666C6B48E58416666666678AE1841CDCCCC6CA48E58410000000054AD184166666606778E5841CDCCCCCCB0AC1841333333F35C8E584133333333B1AB184100000020368E584166666666FAA9184133333333F28D58419A999999ABA918419A9999B9E68D584133333333ADA918419A999919E48D584133333333ADA918419A999919E48D5841	01010000206A080000AFB6629F57AB18419A999929E6915841	330220000	Z	Avensan	3302200	33022	33	75	53
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	01010000206A080000841857A701E019416666662656705841	330230000	Z	Ayguemorte-les-Graves	3302300	33023	33	75	6
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	01010000206A080000C4639141B0F61B419A9999F9CC655841	330240000	Z	Bagas	3302400	33024	33	75	4
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	01010000206A0800006A290DB593461B4166666686C1715841	330250000	Z	Baigneaux	3302500	33025	33	75	8
01060000206A08000001000000010300000001000000AD0300003333333371241A419A999979E75B5841333333336D241A419A999959E75B5841CDCCCCCC4E241A41666666A6E55B58413333333311241A41CDCCCCACE05B5841CDCCCCCCE0231A41CDCCCC0CDC5B58419A999999D7231A4100000020DB5B58419A999999A3231A41CDCCCC0CD65B5841CDCCCCCC32231A419A999959CC5B584100000000C8221A419A999919C25B5841CDCCCCCC7A221A4133333373BA5B58413333333359221A419A999939B75B58410000000014221A41333333B3B25B58419A99999903221A41CDCCCC4CB15B58416666666694211A4100000080A95B5841666666663E211A41CDCCCCECA25B5841CDCCCCCCCE201A4133333333985B58410000000044201A41CDCCCCEC8B5B5841666666662C201A419A9999D9895B58419A999999851F1A419A9999797A5B5841CDCCCCCCAA1E1A41CDCCCC6C665B58419A999999091E1A4166666606575B5841CDCCCCCCEC1D1A4166666606555B584133333333591D1A41CDCCCC6C4D5B58419A9999998F1C1A4166666606425B5841CDCCCCCCAE1B1A419A9999F9355B584133333333031B1A41666666A62C5B584133333333BB1A1A41333333B3285B584166666666AE1A1A4166666666275B584100000000A41A1A419A9999B9255B5841CDCCCCCC961A1A41666666E6225B584100000000901A1A41CDCCCCCC215B5841CDCCCCCC681A1A41000000001F5B58419A999999351A1A41666666061C5B58419A999999ED191A41CDCCCCEC165B5841000000008E191A41000000A00F5B58416666666666191A419A9999790C5B584100000000EC181A419A999919035B58410000000092181A41CDCCCC0CFD5A5841666666662A181A4100000060F55A5841CDCCCCCCE8171A419A999979F05A584166666666A0171A41CDCCCC2CEB5A58416666666674171A419A9999F9E75A58416666666648171A419A9999D9E45A58416666666606171A41333333B3E05A584133333333D9161A41000000C0DD5A584166666666B2161A41333333B3DA5A584100000000A4161A4133333353D95A5841333333338F161A419A9999B9D75A5841CDCCCCCC6A161A41CDCCCCECD65A58413333333341161A41000000A0D35A5841333333331D161A41000000E0D05A58419A999999EF151A4133333313CD5A58419A999999A7151A419A999919C85A58410000000064151A41333333B3C25A5841CDCCCCCC1E151A419A9999B9BD5A5841CDCCCCCCDC141A41CDCCCC0CB95A5841000000009A141A4100000020B45A58419A9999991F141A419A999999A65A58413333333347141A419A999919A45A58410000000012161A419A9999D99E5A58419A999999F3191A41333333B3935A584133333333E71A1A4100000080915A584166666666261C1A41333333D38E5A584133333333C91D1A4100000060885A5841CDCCCCCCDC1D1A419A9999D9855A5841333333338B1D1A41CDCCCC2C785A58419A9999999D1D1A41CDCCCCEC6C5A58419A999999271E1A419A9999D95D5A584100000000C41F1A41000000E0525A58413333333309201A41000000604C5A58410000000046201A41000000C0485A58410000000072201A4100000020465A58419A99999999201A4166666626445A58410000000002211A419A9999393E5A58419A99999937211A41666666C63A5A584100000000D6211A4166666686335A5841CDCCCCCC1C221A41666666C6305A58410000000034221A4133333333305A5841000000005C221A4166666606305A584100000000D6221A4100000040305A58419A99999917231A41CDCCCC2C305A5841CDCCCCCC40231A41CDCCCC6C2F5A5841CDCCCCCC5E231A419A9999F92E5A584100000000D2231A419A9999592E5A58413333333313241A41333333932D5A58413333333361241A41333333532B5A5841000000009A241A4133333373285A584166666666E4241A41CDCCCC6C245A58413333333313251A419A9999D9225A58413333333367251A41000000601F5A5841CDCCCCCCA8251A41666666661E5A584166666666B8251A41000000001E5A584133333333DF251A41666666261C5A58419A999999FB251A419A9999591A5A5841CDCCCCCC34261A41000000E0195A58416666666672261A419A999999185A584133333333AB261A4100000000175A58413333333303271A419A999939165A58410000000052271A4100000020175A58410000000088271A4100000080175A584133333333AF271A4133333393175A584166666666C6271A41000000C0135A58419A999999D3271A41666666E6105A5841CDCCCCCCE6271A419A9999590F5A58419A999999FF271A41666666A60D5A5841CDCCCCCC16281A41666666660B5A5841666666662C281A41CDCCCCCC095A58416666666652281A4166666646085A58419A9999994D281A4133333373055A5841CDCCCCCC6A281A419A999919025A5841666666668E281A4133333313005A584166666666BC281A4166666606FD59584133333333DB281A41CDCCCC2CFB595841666666660C291A41666666A6FA5958416666666636291A4166666646F9595841CDCCCCCC4A291A4166666606F75958419A9999993F291A41CDCCCC4CF55958413333333351291A41CDCCCC2CF25958419A9999997D291A4100000040EF5958413333333393291A41CDCCCCCCEE59584133333333B1291A4133333393ED595841CDCCCCCCBC291A41000000C0EC59584133333333F9291A419A999999E959584133333333092A1A41666666A6E6595841333333332D2A1A41666666A6E3595841CDCCCCCC482A1A4166666666E1595841000000004A2A1A4166666666DD59584100000000442A1A4166666686DB595841333333334D2A1A4100000060D959584166666666482A1A41333333F3D5595841666666665A2A1A41CDCCCC2CD5595841CDCCCCCC8E2A1A41CDCCCCCCD45958419A999999A72A1A4100000060D559584100000000CC2A1A419A999979D559584100000000DA2A1A4166666626D559584133333333F72A1A41333333B3D359584100000000162B1A4166666606D15958419A999999212B1A419A999939CF59584166666666282B1A41666666E6CD595841333333333B2B1A419A999919CC595841666666664E2B1A4166666686CC5958419A999999712B1A41000000A0CC59584166666666942B1A41CDCCCC0CCC59584133333333BB2B1A4133333393CB5958419A999999DD2B1A419A999959CA59584133333333F72B1A4100000020C9595841333333330B2C1A4133333353C7595841CDCCCCCC242C1A4100000060C659584100000000322C1A41CDCCCC6CC4595841333333334D2C1A41333333F3C05958419A9999996B2C1A4133333393BE595841666666669C2C1A419A999959BD595841CDCCCCCCC62C1A4133333393BC5958419A999999E72C1A41666666A6BB595841CDCCCCCC022D1A4100000080B9595841CDCCCCCC0E2D1A41CDCCCC8CB759584133333333232D1A4100000020B6595841CDCCCCCC402D1A41CDCCCCACB55958419A999999672D1A41CDCCCC8CB559584166666666862D1A41000000C0B45958419A999999C52D1A41333333D3B459584100000000F22D1A41CDCCCC4CB1595841CDCCCCCC182E1A4133333393A659584100000000602E1A41333333F39F59584166666666FC2E1A410000002098595841000000009E2F1A41666666A6935958419A99999959301A410000008091595841CDCCCCCC14311A41000000409059584100000000B4311A41666666E68A59584100000000F4311A419A9999D9845958419A99999925321A41666666E680595841000000008C321A41333333F37E595841000000002E331A41666666467F59584166666666BE331A41000000207C5958416666666626341A4133333333745958410000000096341A419A9999196E59584100000000F0341A419A9999B96A595841CDCCCCCC52351A41CDCCCCCC635958410000000026361A41000000A05A595841666666663E361A41CDCCCCEC555958413333333359361A419A9999593E5958419A99999959361A41CDCCCC4C305958413333333341361A419A9999792B59584133333333D3341A419A999919135958413333333337331A41CDCCCC0C0359584166666666EA311A4133333313FD5858416666666624321A4166666606E95858410000000092321A419A999979E75858413333333341331A4133333373E85858419A999999B3331A4133333353E7585841CDCCCCCCD6331A4133333313E55858419A999999F1321A419A9999D9C7585841333333338F321A4100000040A75858419A9999992B331A419A9999B9A05858416666666696331A419A9999B99958584100000000A2341A41CDCCCC8C8F585841CDCCCCCC14361A41000000C08158584166666666A0361A41333333537E58584100000000C8361A41333333D38C5858419A99999955371A419A9999F9975858413333333353381A4100000060975858410000000014381A41000000808758584166666666B6371A4133333353705858419A9999994D371A413333333352585841333333330D371A41CDCCCC2C435858419A999999E3371A419A9999391A58584166666666C6371A4133333373155858419A9999995D371A416666666615585841CDCCCCCC2C371A41CDCCCC8C155858419A99999903371A41CDCCCCEC1558584100000000C8361A41CDCCCC2C185858410000000050361A41000000801D58584100000000E4351A41333333B31C5858410000000014361A4166666646125858410000000048371A4100000020D957584100000000FC361A419A999939D657584100000000D4361A4100000000D5575841CDCCCCCCFA371A41000000A0B0575841CDCCCCCCD2381A41CDCCCCCC935758416666666656391A41000000407357584166666666083A1A41CDCCCC2C65575841000000002E3A1A41CDCCCCAC5357584166666666503A1A41333333732A57584100000000363A1A419A99997902575841666666662A3A1A4100000080F656584166666666A23A1A41CDCCCC8CF6565841666666668A3A1A4166666666E95658419A999999DF391A419A999979E256584166666666F6381A419A999999CB56584100000000AE381A419A999979C556584133333333CD371A4133333393B15658419A99999939381A41CDCCCC4CA356584133333333FB351A41CDCCCC0C3D5658413333333333351A419A9999D91A5658419A9999999B341A41666666860056584166666666FC331A419A999979DF5558416666666636331A4100000000C05558419A999999AF301A41000000007555584166666666E02F1A41CDCCCCCC6155584166666666842E1A41CDCCCC4C49555841CDCCCCCC702E1A419A9999394855584100000000602E1A4133333313465558419A999999232E1A41666666663E55584133333333B92D1A410000002031555841666666665A2D1A41000000602455584100000000DE2C1A4166666666165558419A999999BF2A1A419A999979F554584166666666AA291A419A9999D9E054584100000000A4261A419A9999F90155584100000000A4241A41333333B31B5558416666666686241A419A9999391D5558419A999999A3231A413333337329555841CDCCCCCC84231A419A9999192B555841666666660E221A419A9999593E55584133333333DB201A41666666264E55584166666666721F1A41CDCCCC8C5C555841333333332F1F1A41CDCCCCEC6055584166666666F01E1A41000000406A55584100000000A81F1A410000006088555841333333332D1D1A41CDCCCC6CAA5558419A9999992F1D1A4166666666BE555841000000003A1D1A41000000A0CF55584166666666DE1A1A41666666A6EB55584100000000EE181A41666666E6035658419A999999FB121A413333335361565841666666661A111A41666666268356584166666666D0101A41333333937F565841000000004C101A419A99993975565841CDCCCCCC2C0E1A410000000080565841CDCCCCCCF40D1A41333333937756584133333333110C1A419A9999B97F56584100000000B40B1A41CDCCCC0C8C56584100000000BE091A41000000E079565841CDCCCCCCB4071A419A9999D93456584133333333F1051A41666666A6F75558419A99999963051A4100000040EA55584166666666C6041A41333333D3DF555841CDCCCCCCD4041A4133333313D65558419A999999E7041A4133333353CD5558419A999999AB041A41000000E0CA55584100000000B4031A419A999939CA5558419A9999993B021A41333333F3E05558410000000020011A419A9999B9C4555841CDCCCCCCF8FF1941CDCCCC0CB45558413333333353FE19419A999959B2555841666666660AFC194100000020AF5558416666666648FA1941000000C0AC5558419A99999949F9194166666646AC55584166666666C8F9194133333313955558416666666686F81941666666468D5558419A9999995DF81941CDCCCCCC855558416666666660F71941666666E68D555841CDCCCCCC34F71941333333538B5558419A999999FBF61941CDCCCC2C895558419A999999C7F6194166666606885558416666666688F619419A99999986555841CDCCCCCC58F6194166666626855558413333333313F6194133333333825558419A999999EDF519419A9999798155584100000000DEF51941000000A07E555841CDCCCCCCBAF519419A9999997C555841CDCCCCCC92F51941666666867C5558416666666666F51941666666E67D5558419A99999947F51941666666C67E555841CDCCCCCC2EF51941CDCCCC8C7E5558413333333313F51941000000A07C55584166666666F6F41941333333537A55584166666666D8F41941000000007855584100000000B6F4194100000020755558419A99999995F4194133333313725558410000000064F41941666666066D5558419A99999941F41941000000A0695558410000000018F419419A9999D964555841CDCCCCCCE8F31941CDCCCC8C5F55584100000000BCF319419A9999D95A555841333333339DF319419A9999F9585558410000000076F319419A9999B958555841CDCCCCCC4CF319419A999939595558410000000006F319419A9999395A55584100000000AEF21941333333F35B555841666666665CF219419A9999B95D5558419A999999DBF119416666664660555841333333335FF11941666666266255584133333333C7F0194166666666655558410000000054F01941CDCCCC8C67555841CDCCCCCCECEF1941CDCCCCCC695558419A9999998FEF1941333333D36B5558410000000046EF1941333333D36C5558419A999999E5EE1941333333936D5558419A999999A9EE19419A9999196E5558419A99999949EE1941000000806E5558410000000020EE1941333333536E55584166666666D2ED19419A9999796E55584100000000A0ED1941333333F36E555841CDCCCCCC84ED1941666666866F555841CDCCCCCC7AED19419A9999D96E555841CDCCCCCC62ED1941000000606E555841000000002CED19419A9999396E55584100000000BEEC1941666666866D5558413333333345EC1941666666066D555841CDCCCCCCD2EB1941CDCCCC8C6C555841CDCCCCCC52EB1941666666066C55584100000000F8EA1941666666866B55584166666666ACEA1941333333536B555841333333334DEA1941666666066B55584133333333C1E91941000000406A5558416666666616E919419A9999796955584100000000B6E819419A99991969555841000000006AE81941666666C668555841333333332DE819419A999979685558419A99999905E819413333337367555841CDCCCCCCF4E719419A9999796655584166666666E4E71941000000006455584133333333C3E71941666666465E555841000000009EE71941666666E6585558419A99999971E71941333333D3515558413333333355E71941333333534D5558410000000040E7194166666666495558410000000018E71941333333D343555841CDCCCCCC00E719419A9999F93F55584133333333EDE61941CDCCCCCC3C5558419A999999AFE619419A9999D93C5558413333333327E61941666666A63C5558419A999999B7E51941333333933C5558416666666636E51941CDCCCC6C3C5558419A999999C1E41941666666863C555841666666664CE41941CDCCCC8C3C55584100000000EAE31941000000603C555841333333339FE31941333333533C5558413333333347E319419A9999193C555841CDCCCCCC54E31941CDCCCCEC3E5558419A99999961E31941CDCCCC2C425558413333333379E31941000000C047555841CDCCCCCC88E31941666666E64A5558419A9999999DE31941000000405055584133333333ADE31941000000405555584166666666CAE319419A9999795C5558419A999999E1E31941000000A062555841CDCCCCCCF0E319419A9999F96555584100000000FEE319419A9999D968555841000000000EE41941000000006B555841CDCCCCCC10E41941000000606B555841000000001AE419419A9999196F5558410000000020E4194133333373745558413333333325E41941CDCCCCAC765558413333333329E41941CDCCCC0C7A555841333333332FE41941666666667B5558410000000036E419416666668680555841666666662CE41941CDCCCC4C895558419A99999919E41941666666E68F5558419A999999FDE3194133333373955558419A999999D3E31941666666869A555841CDCCCCCCA2E31941666666669F555841CDCCCCCC8EE3194133333393A25558416666666676E319419A999999A75558419A9999997BE319419A9999D9AC555841CDCCCCCC84E3194100000000B25558416666666690E31941666666E6B55558416666666698E3194133333393B85558419A99999957E319419A999999B95558410000000006E3194100000000BB555841CDCCCCCCB0E2194166666666BD555841333333334DE21941333333F3BF555841CDCCCCCCEEE119419A999939C25558416666666686E11941CDCCCC6CC45558419A99999927E11941CDCCCC0CC65558413333333301E11941666666A6C655584166666666D2E01941000000E0C75558416666666684E019419A9999B9C75558410000000022E01941CDCCCC2CC755584166666666B4DF1941CDCCCC8CC65558416666666668DF1941666666E6C5555841CDCCCCCCF2DE194133333313C5555841000000009ADE194100000000C4555841666666666EDE194133333373C35558410000000014DE194100000060C255584166666666D2DD1941666666E6C15558416666666682DD1941666666C6C15558419A9999991FDD194166666666C1555841CDCCCCCCC6DC1941000000C0C05558413333333365DC194133333353C05558413333333315DC1941333333D3BF55584100000000CCDB194133333333C0555841666666668ADB1941666666C6C05558413333333337DB1941CDCCCC0CC1555841CDCCCCCCE2DA19419A9999D9C0555841000000008ADA1941333333B3C05558410000000030DA1941333333B3C055584100000000EED91941000000A0C055584166666666B4D91941CDCCCCACBF555841666666668ED91941333333F3BE5558419A99999955D91941333333F3BE5558419A99999945D9194166666606BF555841CDCCCCCC96D81941CDCCCC4CC05558413333333393D8194166666686BE5558413333333391D819419A999959BD5558413333333379D819419A999919BC5558419A99999949D81941000000A0BB555841CDCCCCCC1ED81941333333F3BB5558413333333309D8194166666606BD55584166666666FAD71941333333F3BE555841CDCCCCCCDED7194166666626C05558419A999999C1D7194100000000C05558419A9999999DD719419A999999BF5558416666666654D719419A999939BE5558419A999999F9D6194100000080BD55584166666666B4D6194100000060BD555841CDCCCCCC5CD6194100000060BD555841666666665AD6194133333373BD555841333333331DD6194133333353BD55584166666666E0D51941333333D3BC555841000000008ED5194100000020BC5558416666666656D51941000000E0BB5558419A99999901D51941CDCCCC8CBB5558419A999999CBD41941CDCCCC2CCC555841CDCCCCCC46D41941333333B3015658410000000010D41941CDCCCCEC2856584166666666CCD31941666666A6685658413333333381D31941666666E68C56584166666666D0CE194100000040A75658410000000098CB1941CDCCCC8CCC5658416666666640C91941CDCCCC6CEC565841CDCCCCCC00C71941CDCCCC2C085758419A99999923C51941666666261B575841CDCCCCCC84C419419A9999B92257584133333333EDC21941666666E6335758416666666632C21941333333F33A5758416666666620C01941CDCCCC4C515758419A99999953BE19419A9999D9645758413333333395BC1941333333137A575841CDCCCCCCAABB1941CDCCCCCC7C575841666666660EBC1941CDCCCC2CC35758419A99999905BC1941666666E6CA57584166666666FABB1941333333D3D157584100000000F8BB1941000000E0D257584166666666D0BB194100000060E057584133333333DBBC194100000020F05758416666666640BE19419A999919065858413333333327BF1941CDCCCCEC3C585841CDCCCCCC78BF19419A9999594958584100000000CCBF1941CDCCCC4C6258584166666666CCBF1941CDCCCCCC6458584100000000BCBC1941CDCCCCAC90585841333333339FBC1941333333F392585841CDCCCCCCAABC19419A999999955858419A999999CFBC1941000000C0985858416666666604BD19419A9999999D5858419A9999990FBD1941000000E09E5858419A99999919BD1941CDCCCC6CA0585841CDCCCCCC1CBD1941000000C0A25858419A9999990BBD1941666666E6A6585841CDCCCCCC06BD19419A999919AA5858413333333311BD1941333333B3AD585841CDCCCCCC20BD1941CDCCCCCCB25858410000000032BD194133333373B85858416666666648BD194133333333BB585841333333335FBD194166666686BF5858419A9999997DBD19419A999999C45858419A99999993BD194100000000C958584166666666A2BD194100000020CD585841CDCCCCCCACBD194100000020CF5858419A999999D7BD1941CDCCCC8CD358584100000000FCBD194133333313D65858416666666646BE1941333333F3D85858419A99999905BF194166666686E55858419A9999998BBF1941666666C6EE585841CDCCCCCCAABF1941CDCCCC2CF95858410000000086C01941666666C60A59584166666666D6C01941000000000C595841CDCCCCCCEAC019419A9999F910595841CDCCCCCC2EC119413333337314595841CDCCCCCC46C21941333333331559584100000000AAC21941000000C01659584100000000DAC21941CDCCCCEC185958419A99999915C319416666662618595841CDCCCCCC3AC319416666668616595841CDCCCCCC6EC31941666666661259584100000000E2C31941333333530F595841000000002CC41941666666C60D5958410000000058C41941000000E00759584166666666ACC419419A9999D9015958410000000086C5194166666666055958410000000024C61941666666060B5958413333333383C619419A9999F90A5958419A999999EBC61941CDCCCC4C085958413333333313C7194133333353055958410000000004C71941CDCCCC8C025958419A99999923C71941666666E6FE585841CDCCCCCC20C71941666666A6FA585841CDCCCCCC4AC719419A9999D9F85858419A99999925C71941CDCCCC6CF45858416666666660C7194100000000F3585841CDCCCCCCC6C71941333333F3F258584133333333DDC719419A9999D9F05858419A999999B5C71941333333B3ED58584100000000BAC7194100000020EA58584133333333DDC71941CDCCCC4CE6585841CDCCCCCC32C81941CDCCCC0CE2585841333333337BC8194166666686E05858419A9999992BC91941666666A6DB5858419A99999967C9194133333333DD585841666666667AC9194166666666E1585841CDCCCCCCA6C91941333333F3E458584133333333C7C91941CDCCCCCCE558584100000000D6C91941000000E0E258584100000000F4C9194166666686E15858419A99999919CA19419A999999E55858413333333349CA194133333393E55858416666666694CA194100000020E658584133333333EBCA19419A999999E35858419A9999990DCB194166666606DE585841CDCCCCCC02CB19419A9999D9D6585841CDCCCCCC56CB1941333333B3D15858419A999999CFCB19419A9999D9D0585841666666665CCC194166666646D8585841CDCCCCCC92CC194133333353DA585841CDCCCCCCEECC1941CDCCCCCCD8585841000000001ECD19419A999919D4585841333333334FCD19419A9999D9D05858419A999999B5CD194133333313D15858419A999999FBCD1941000000E0CF5858410000000020CE1941CDCCCCACC85858416666666642CE1941666666E6C55858419A99999977CE194133333353C7585841333333339DCE194133333393CB5858419A99999987CE19419A9999F9D05858419A999999CDCE1941333333F3D15858413333333387CF19419A9999D9D65858419A999999D9CF19419A9999F9D7585841CDCCCCCC1CD019419A9999F9D35858419A99999931D01941CDCCCCECCB5858419A99999981D0194133333373CB585841CDCCCCCCD8D01941CDCCCCACCA585841666666663ED1194133333333C558584166666666B0D11941000000C0C05858419A9999993BD2194100000020BC5858416666666690D219419A999999B95858416666666698D219419A999979C458584166666666CED219419A999979D458584100000000D2D21941CDCCCC4CD858584166666666D0D2194166666646DC58584166666666C8D2194133333313E058584100000000CCD219419A9999B9E458584133333333D5D21941666666C6E758584100000000E6D219419A9999B9E9585841CDCCCCCC00D31941000000C0EC585841000000000ED31941CDCCCC0CF0585841CDCCCCCC02D31941CDCCCC0CF358584100000000ECD2194166666666F658584133333333E3D21941CDCCCC4CFA585841CDCCCCCCD2D21941CDCCCCCCFC5858419A999999ADD2194133333313FE585841CDCCCCCC84D219419A9999F9FF585841666666666CD2194166666606035958410000000056D219413333337307595841CDCCCCCC42D21941CDCCCCAC0A5958419A9999992BD21941CDCCCCEC0F595841000000000AD21941333333731559584166666666E8D119419A9999D91959584133333333D1D11941000000801F59584133333333C9D11941333333532459584100000000CCD119413333339327595841CDCCCCCCD8D119419A9999792B59584100000000E4D119419A9999393059584166666666FCD11941333333F334595841333333330BD219410000008039595841666666662CD21941666666C63A5958410000000050D21941000000A03C5958413333333383D21941666666C63E59584100000000A8D21941CDCCCCAC405958419A999999C1D21941CDCCCCEC4359584166666666D4D219410000006046595841CDCCCCCCD2D219419A9999994859584100000000DED21941666666464C59584166666666ECD21941000000A051595841CDCCCCCCF0D21941CDCCCCEC5559584100000000DED219419A9999B95959584166666666C2D21941666666265D59584133333333B7D219419A9999F95F5958419A999999A9D219419A9999196359584166666666A4D219416666666666595841CDCCCCCCA4D21941CDCCCC6C6B5958419A999999B5D219419A9999D96F595841CDCCCCCCDAD21941CDCCCCAC775958419A999999C7D21941333333337A5958419A999999BDD21941CDCCCCCC7C595841CDCCCCCCBED21941CDCCCCAC7F59584133333333C3D219419A9999F981595841CDCCCCCCCED21941666666A683595841CDCCCCCCF2D219419A9999D9845958413333333315D3194100000060875958416666666604D31941CDCCCC4C8B59584133333333F1D21941333333938C59584100000000E2D21941333333D38E59584133333333E9D21941CDCCCC6C905958419A999999EDD21941333333B392595841CDCCCCCCEED2194166666686945958419A999999F1D21941666666A6975958419A99999937D31941666666E69D5958410000000064D31941666666C6A0595841666666668AD3194166666646A3595841CDCCCCCCA0D31941CDCCCCCCA65958419A999999B5D3194133333313AB59584133333333C5D319419A9999D9AF59584100000000D2D3194100000060B3595841CDCCCCCCDCD3194166666606B759584100000000EAD3194166666626B95958416666666602D41941666666E6BC5958413333333317D4194133333333C0595841CDCCCCCC2CD4194166666606C3595841CDCCCCCC36D4194166666686C65958413333333337D4194133333313CA5958413333333335D4194133333393CE5958413333333335D4194166666686D1595841000000003ED4194133333393D25958410000000050D419419A999959D35958419A99999967D419419A9999F9D4595841333333337BD41941000000E0D6595841666666668AD41941CDCCCC8CD959584133333333BBD41941CDCCCCCCE1595841666666662AD5194166666626F3595841333333339DD5194133333393055A58413333333311D61941CDCCCC0C185A5841CDCCCCCC9CD61941333333732E5A584166666666E8D61941333333133B5A5841CDCCCCCC28D71941333333B3445A58410000000044DB19419A999919B75A58419A9999997DDF1941666666A6435B584100000000BADF19419A9999D9495B58419A999999ADE01941333333F3635B584166666666EAE019419A9999B9745B58419A999999D3E0194100000080775B584166666666C2E019419A9999797C5B584100000000AEE01941CDCCCCEC815B5841CDCCCCCCACE01941666666A6835B584166666666B8E019419A9999F9865B5841CDCCCCCCDCE01941000000808F5B58416666666620E11941666666E69F5B58416666666648E1194133333393A95B5841CDCCCCCC68E119419A9999F9AF5B5841000000007AE1194133333313B45B58419A99999993E1194100000060BA5B5841CDCCCCCCAEE1194133333313C15B58419A999999D1E1194133333373C95B584166666666ECE11941CDCCCC2CD05B58410000000006E21941CDCCCCACD45B58413333333323E219419A9999D9D95B5841666666663AE2194133333333DE5B58416666666652E21941000000C0E25B5841666666666EE2194166666666E75B584166666666A4E219419A999999F05B5841CDCCCCCCF4E219419A9999B9FE5B5841CDCCCCCC3EE31941666666860B5C5841CDCCCCCC78E3194133333313155C58413333333377E3194133333313165C58419A9999996DE319419A999919175C58419A9999993BE3194166666646165C584166666666F8E21941000000E0145C5841CDCCCCCCBCE21941666666C6135C5841333333336DE21941CDCCCC0C135C58410000000016E219419A9999F9115C584166666666BEE11941CDCCCC6C105C5841666666665EE11941CDCCCC8C0E5C5841CDCCCCCCEAE019419A9999190C5C58410000000074E01941666666A6095C58419A99999907E019419A999959075C584166666666A2DF1941CDCCCC4C055C5841CDCCCCCC6ADF194133333353045C58413333333317DF1941CDCCCC4C025C584133333333BDDE194166666666005C58413333333379DE194100000020FF5B58413333333331DE1941333333D3FD5B584133333333F3DD19419A9999D9FC5B5841CDCCCCCCAEDD194166666626FC5B58419A99999955DD194100000060FB5B584100000000DEDC194100000020FA5B58413333333355DC194133333313F95B584100000000E8DB194133333333F85B5841CDCCCCCC96DB194133333373F75B5841CDCCCCCC46DB1941333333D3F65B5841000000000EDB19419A999979F65B5841666666669EDA194100000020F65B58410000000030DA19419A9999B9F55B584100000000C8D919419A999959F55B5841CDCCCCCC50D9194100000000F55B584133333333BDD81941CDCCCCACF45B584166666666B4D519419A9999F91B5C5841666666668CD51941000000401D5C58413333333365D5194100000040225C584166666666EAD5194166666646DA5C5841CDCCCCCCD6D619419A999999D65C5841666666660CD719419A999999D55C5841CDCCCCCC80D719419A9999B9D05C58419A999999F1D71941CDCCCCCCD05C5841666666662CD81941CDCCCC6CCE5C5841000000004ED81941CDCCCCACCE5C58410000000082D81941666666A6CF5C584166666666ACD8194133333373D05C58419A999999C9D8194166666606D15C584100000000F0D81941000000C0D15C5841CDCCCCCCFED8194100000020D25C5841666666661AD91941666666C6D25C58410000000030D919419A9999B9D25C5841333333334BD91941000000C0D15C58416666666666D91941CDCCCC2CD15C58413333333385D91941CDCCCCACD15C584100000000A8D91941000000A0D25C58419A999999CBD91941666666C6D25C58410000000008DA1941000000A0D05C58413333333373DA1941333333F3CD5C58413333333321DB194100000020C75C5841666666664ADB19419A999959C35C5841CDCCCCCC88DB19419A9999B9BE5C584166666666D6DB1941CDCCCCACBE5C58419A99999923DC19419A999999BC5C5841333333338FDC194100000020BD5C584133333333C1DC194100000040BD5C584133333333E1DC1941000000E0B95C5841666666662EDD19419A999959B85C5841CDCCCCCC6CDD1941CDCCCCACBA5C584133333333BDDD19419A999919BD5C58413333333305DE1941000000C0BA5C58413333333357DE19419A999959B85C584100000000B4DE19419A999999B85C5841CDCCCCCC08DF19419A9999D9B85C58419A9999993FDF19419A999919B85C58413333333383DF1941000000E0BA5C584100000000E0DF194100000040BC5C58413333333331E0194166666666BF5C584133333333B7E019419A999979BE5C584166666666F0E01941333333D3C05C584166666666F0E0194166666646C35C5841000000004AE11941CDCCCC0CC35C5841333333332DE11941CDCCCC4CC95C5841000000005CE11941CDCCCC6CCC5C5841CDCCCCCC86E119419A999939CE5C584133333333B7E119419A999919CA5C584133333333C9E1194100000000CE5C58419A99999993E2194133333333CA5C584100000000D6E21941666666A6CC5C5841666666668CE219419A999959CF5C5841CDCCCCCC9AE2194100000060D65C584100000000F8E21941CDCCCC2CD85C5841000000005AE3194166666646D65C58410000000082E31941333333F3D95C58419A99999997E319419A9999D9DC5C58419A999999EDE3194133333353DC5C5841CDCCCCCC04E41941000000A0DA5C5841CDCCCCCC58E41941CDCCCC2CDB5C5841CDCCCCCC96E4194166666666E35C584166666666ACE419419A999959E45C584100000000D0E4194166666626E55C584166666666F6E4194166666666E55C58416666666624E51941000000A0E45C5841CDCCCCCC5AE5194133333393E35C5841CDCCCCCC92E51941CDCCCC0CE35C584100000000C0E519419A9999B9E25C58416666666608E6194133333313E35C5841666666664CE61941CDCCCC6CE45C58419A99999997E6194133333313E25C584166666666FAE619419A9999D9E05C5841CDCCCCCC3EE719419A999919E05C5841CDCCCCCC84E71941CDCCCCCCE05C58416666666666E8194133333333DC5C58419A9999997BE8194133333373E05C58410000000012E91941000000A0E15C58419A99999975E91941000000C0E55C58416666666618EA194166666666E55C5841CDCCCCCC4AEA1941CDCCCC2CE95C5841CDCCCCCCD2EA194166666666E95C5841CDCCCCCC4AEB1941000000C0E75C5841CDCCCCCC78EB194100000020E65C5841CDCCCCCCD4EB19419A9999D9E55C58410000000042EC1941CDCCCC2CE65C58410000000068EC194166666666E55C58416666666664EC194166666666E25C58416666666684EC194166666626E05C58410000000024ED194100000060DE5C5841333333333FED1941333333B3D75C584166666666BEED19419A999979D15C58413333333309EE1941CDCCCC6CD35C58413333333381EE19419A999939D75C58419A999999E1EE19419A999999D85C58419A999999E1EE1941CDCCCC0CDB5C58419A99999957EF1941333333F3DA5C58419A99999947EF194166666686DE5C58419A99999995EF19419A9999F9DD5C58419A999999D1EF1941CDCCCC2CDB5C58410000000036F0194100000080DB5C58410000000056F01941CDCCCC4CDD5C584100000000ACF019419A9999B9DC5C584133333333B5F01941CDCCCC8CE25C5841CDCCCCCC86F1194166666666E35C5841CDCCCCCCC2F1194166666606DD5C58419A999999DBF1194100000020D95C58419A99999937F21941CDCCCC4CD95C5841CDCCCCCCA4F21941000000C0DA5C584133333333F7F219419A9999D9D95C5841CDCCCCCCA8F3194133333313D95C58416666666614F41941000000A0D75C58419A9999999FF4194133333373D75C58419A999999E7F4194100000040D75C58419A9999992FF51941000000C0D45C5841666666668CF5194100000000D55C5841CDCCCCCCF4F51941333333D3D05C58413333333367F61941333333B3CD5C584166666666AAF61941000000A0CC5C584100000000E2F61941CDCCCC6CD05C58419A99999925F71941000000E0D25C5841CDCCCCCC90F71941CDCCCCECD15C584100000000E6F71941666666E6D15C584133333333F7F71941CDCCCCACCF5C5841CDCCCCCC56F8194100000080CA5C584166666666B4F819419A999919CC5C584133333333FFF819419A999939CD5C5841333333333DF91941CDCCCC8CCA5C58419A99999979F9194166666666CB5C5841CDCCCCCC90F91941000000C0CE5C584100000000E8F91941000000C0D05C58419A99999949FA194166666646D15C58416666666662FA1941CDCCCCACCF5C5841333333338FFA194100000060D05C584100000000CEFA194100000020D35C58413333333303FB1941CDCCCC8CD45C58416666666620FB1941CDCCCC4CD05C58416666666652FB1941CDCCCC6CD05C58419A99999989FB1941000000A0D45C58419A999999D9FB1941CDCCCC6CD35C5841666666663CFC1941CDCCCC4CD05C58410000000080FC194100000060CF5C58419A999999A7FC1941000000C0CD5C584133333333DFFC1941000000E0CE5C5841333333331DFD1941CDCCCC8CCE5C58416666666654FD19419A9999B9D05C5841CDCCCCCC86FD19419A999919D55C58419A999999D1FD194166666626D35C58419A999999E1FD194100000080CD5C584100000000E4FD19419A999939A25C5841CDCCCCCCF8FD1941000000009C5C58416666666616FE19419A999939995C5841000000005A011A41000000607A5C5841CDCCCCCC5C021A4100000000745C5841666666662E031A4100000020735C58413333333337061A419A9999F9645C58416666666670061A4100000040655C584166666666BA061A41CDCCCCEC645C58416666666602071A4100000000645C5841666666664C071A4100000000635C584133333333A3071A41CDCCCCCC615C584100000000E2071A41CDCCCCAC605C58419A99999911081A41666666A6605C58410000000030081A4166666686605C58416666666654081A4166666666605C58410000000098081A41333333B35F5C584133333333E9081A41666666865E5C5841CDCCCCCC34091A419A9999395D5C58413333333377091A41666666065C5C5841CDCCCCCCAA091A41000000205B5C584133333333F7091A41666666C6595C5841CDCCCCCC3A0A1A41333333F3585C584166666666860A1A41333333F3575C584133333333AD0A1A4166666666575C58419A999999E50A1A4133333393565C584100000000240B1A41666666C6555C584133333333870B1A4166666686545C5841CDCCCCCCEC0B1A419A9999F9525C5841333333333B0C1A41000000C0515C5841CDCCCCCC6A0C1A41CDCCCCAC505C58419A999999AF0C1A4133333353505C5841CDCCCCCCE60C1A41CDCCCCEC4F5C584133333333230D1A41CDCCCCAC4E5C584133333333590D1A41666666A64D5C584133333333A70D1A41333333534C5C58419A9999991D0E1A41333333534A5C584133333333790E1A41333333B3485C584100000000F20E1A4100000080465C58410000000046141A4133333333325C58419A999999B5161A4166666606275C584166666666E2161A419A999959265C58419A99999931171A41333333F3245C5841000000009E171A4100000080235C58419A999999FD171A41333333D3215C5841333333333D181A41333333B3205C5841000000006E181A41CDCCCCEC1F5C58419A99999991181A419A9999591F5C58419A999999E3181A41CDCCCC0C1E5C5841666666665A191A41000000401C5C58419A999999A7191A41333333331B5C584166666666021A1A41333333B3195C58419A999999831A1A41CDCCCCAC175C584100000000E61A1A41CDCCCCEC155C5841666666663C1B1A41CDCCCC6C145C5841CDCCCCCC841B1A4166666626135C58419A999999C71B1A4100000000125C5841333333330D1C1A419A9999D9105C584100000000401C1A41333333F30F5C5841CDCCCCCC621C1A41000000800F5C584166666666841C1A41CDCCCC2C0F5C5841000000009C1C1A41666666E60E5C584100000000E01D1A419A9999F9075C58413333333371241A419A999979E75B5841	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	01010000206A080000FFB7D88150031A41CCCCCC4CE5585841	330260000	Z	Balizac	3302600	33026	33	75	42
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	01010000206A08000067D11A30A6B01B4100000070FE605841	330270000	Z	Barie	3302700	33027	33	75	5
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	01010000206A0800003962DA9389B91A41CDCCCC8CAC7C5841	330280000	Z	Baron	3302800	33028	33	75	10
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