SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep36;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep36 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep36','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep36','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep36','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep36"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000FC07C81DA59F2241666666064F295941	360010000	Z	Aigurande	3600100	36001	36	24	28
01060000206A08000001000000010300000001000000B40300009A999999C14622419A999959146E594100000000CE462241CDCCCC8C156E594133333333F546224133333373196E59413333333337472241000000E01F6E594133333333A0472241333333532A6E594166666666AF472241000000C02B6E594133333333B9472241CDCCCC2C2D6E594166666666C4472241666666C62E6E594100000000D147224133333393306E594100000000E2472241666666E6336E59410000000011482241333333133F6E5941666666666D48224166666666556E5941CDCCCCCC7448224133333333576E5941000000007D482241666666C6586E5941CDCCCCCC8A4822419A9999D95A6E59419A999999B448224133333373606E594100000000D84822419A999919656E59419A999999E148224100000040666E594133333333EC48224133333373676E5941CDCCCCCCF5482241666666A6686E594166666666FF482241333333B3696E59419A999999164922419A9999D96B6E5941CDCCCCCC3D492241000000C06E6E594133333333424922419A9999396F6E5941000000004949224100000020706E5941CDCCCCCC6B49224100000040776E5941CDCCCCCC77492241CDCCCCAC796E594166666666D2492241333333738B6E594133333333E7492241666666468F6E594166666666F349224133333353916E59419A9999990B4A22419A999959946E5941000000000F4A2241CDCCCC0C976E5941CDCCCCCC194A2241666666069A6E594133333333394A22419A999979A16E594100000000424A22419A9999B9A36E594133333333494A22419A9999B9A56E594133333333534A2241666666E6A86E5941CDCCCCCC5D4A224133333333AD6E5941000000007A4A2241CDCCCCACB86E5941CDCCCCCC964A2241CDCCCC6CC46E5941CDCCCCCCB34A224100000080CE6E594133333333CB4A22419A9999D9D76E5941CDCCCCCCD64A2241CDCCCC8CDD6E5941CDCCCCCCE54A2241CDCCCCACE46E594100000000F24A22419A999919EB6E594166666666034B2241333333F3F36E594133333333154B2241333333D3FC6E594100000000284B22419A999999066F59419A9999992B4B224166666646086F5941333333332F4B2241000000C0096F594166666666354B2241333333930B6F5941333333333F4B22419A9999790E6F594166666666684B22419A9999F9186F5941000000006C4B2241333333131A6F594100000000704B2241666666861B6F5941CDCCCCCC734B2241666666461E6F594100000000784B22419A9999F9206F59419A9999997A4B22419A999939226F5941333333337F4B2241000000C0236F594166666666844B22419A999939256F59419A999999894B224100000080266F59419A999999924B224100000060286F594100000000A34B2241333333532A6F594100000000FB4B22419A999939366F5941666666662C4C2241CDCCCC6C3D6F594133333333524C2241333333B3426F594100000000764C2241CDCCCCCC476F59419A999999844C22419A9999794A6F5941000000008E4C22419A9999194C6F59419A999999954C2241000000A04D6F5941CDCCCCCC9C4C2241333333334F6F594100000000A44C2241CDCCCCAC506F594100000000AA4C2241CDCCCC0C526F594166666666AF4C224166666686536F594100000000B44C224133333313556F59419A999999B74C2241000000C0566F594166666666B94C224166666686586F594166666666BB4C2241CDCCCC6C5A6F594133333333BE4C2241CDCCCC4C5F6F59419A999999BF4C2241333333B3606F594100000000C24C224166666626626F59419A999999C44C2241CDCCCCAC636F594166666666C74C224166666666656F594100000000CA4C2241000000E0666F594100000000CD4C224166666626686F594166666666D04C224133333333696F594100000000D44C2241333333536A6F594166666666D94C2241CDCCCC8C6B6F5941CDCCCCCCDF4C2241000000C06C6F594133333333E74C2241CDCCCC2C6E6F594166666666F44C2241000000A0706F5941CDCCCCCC374D2241666666A67C6F5941000000007B4D224100000080886F594166666666814D224100000060896F594133333333894D22419A9999F9896F59419A999999924D2241666666668A6F594133333333A04D2241000000A08A6F5941000000009C4D224133333373896F59419A999999994D224133333353886F5941CDCCCCCC984D22419A999939876F594133333333994D224166666606866F5941CDCCCCCC9A4D22419A999999846F594133333333A14D22419A999979826F59419A999999BE4D2241CDCCCC8C7A6F594100000000C34D22419A999939796F594166666666C64D2241CDCCCCCC776F59419A999999C84D224100000020766F59419A999999C94D224166666686746F594133333333CA4D2241CDCCCCEC726F594133333333CA4D2241CDCCCC2C716F5941CDCCCCCCC64D2241000000C06C6F594100000000C64D2241666666E66A6F59419A999999C54D22419A999999696F5941CDCCCCCCC54D22419A999919686F594133333333C74D2241CDCCCC4C666F5941CDCCCCCCCA4D22419A9999F9636F5941CDCCCCCCCC4D2241333333D3626F5941333333330B4E224166666666656F5941CDCCCCCC184E2241000000E0656F59419A999999244E224100000060666F5941666666662E4E2241000000E0666F594100000000394E22419A999999676F594133333333444E224100000080686F5941CDCCCCCC504E2241000000A0696F594133333333604E2241CDCCCC4C6B6F5941CDCCCCCC774E2241CDCCCC0C6E6F5941CDCCCCCC844E22419A9999996F6F594133333333934E224133333353716F594100000000B44E22419A999939766F5941CDCCCCCC0E4F224100000040846F594100000000134F2241CDCCCC2C856F594166666666154F224100000000866F594100000000194F224166666626896F59419A999999224F224166666606946F5941CDCCCCCC264F22419A999999956F5941666666662D4F224133333373976F5941CDCCCCCC324F2241666666C6986F594133333333444F2241333333939D6F594166666666564F224133333373A26F5941CDCCCCCC674F224133333353A76F5941CDCCCCCC6B4F22419A999939A96F5941CDCCCCCC6B4F2241CDCCCCACAA6F5941000000006B4F2241CDCCCC6CAB6F594100000000764F2241333333F3AC6F5941666666667F4F2241333333F3B06F5941000000008B4F2241333333D3B66F59419A999999984F224100000020BD6F59419A9999999C4F22419A9999D9BF6F5941CDCCCCCCA04F2241000000A0C26F594166666666A54F2241333333D3C66F594166666666A54F22419A999919CC6F594133333333A84F2241000000E0CF6F594100000000AC4F224166666646D46F594166666666AE4F2241CDCCCCCCD76F59419A999999AB4F224166666626D96F594166666666A84F2241CDCCCCCCDA6F594166666666A84F2241666666C6DC6F59419A999999A64F224166666626E26F59419A999999A54F224100000080E56F594100000000A54F2241CDCCCCACE96F5941CDCCCCCCA84F2241CDCCCCACF16F594100000000AB4F2241333333F3F66F5941CDCCCCCCAD4F22419A9999B9FC6F59419A999999AE4F2241000000200170594133333333AF4F2241000000E003705941CDCCCCCCAC4F2241666666C60570594166666666A74F22416666660608705941CDCCCCCC9D4F22419A9999D90970594166666666884F2241333333130D70594166666666754F22419A9999390F705941CDCCCCCC6D4F2241333333731070594166666666664F2241000000801270594166666666654F22413333335315705941CDCCCCCC654F22419A99993916705941CDCCCCCC664F2241CDCCCC8C17705941666666666A4F2241CDCCCCAC1970594100000000744F22419A9999191D7059419A999999894F22419A99993922705941CDCCCCCC9F4F22410000006027705941CDCCCCCCAE4F2241666666E62A70594166666666BC4F2241000000802E70594166666666C84F2241000000E03270594133333333D54F2241666666A63770594166666666DD4F2241000000203B70594100000000EA4F22419A9999D93F705941CDCCCCCCF64F2241000000C0447059410000000003502241CDCCCCAC4A705941666666660F502241000000E050705941333333331A50224100000060577059419A99999924502241CDCCCC2C5E705941666666662C502241CDCCCC8C62705941CDCCCCCC315022419A9999D9677059413333333349502241000000206D7059419A999999645022419A9999F96E70594133333333C0502241000000607170594100000000ED5022419A99997970705941CDCCCCCC31512241CDCCCC8C71705941CDCCCCCC42512241CDCCCCEC737059416666666658512241666666E675705941CDCCCCCCB4512241CDCCCC2C7370594166666666E851224166666666707059419A99999947522241000000806C7059413333333349522241333333936D705941666666664D522241333333936F7059419A999999535222416666668671705941CDCCCCCC5A5222419A999979737059410000000066522241666666A675705941CDCCCCCC715222413333335379705941CDCCCCCC7A522241666666E67B7059410000000080522241333333B37D705941CDCCCCCC84522241666666867F7059416666666686522241000000E0807059419A99999984522241CDCCCC2C827059410000000083522241666666A68370594166666666A0522241000000408570594166666666F352224166666666897059419A999999C4522241CDCCCCEC8F70594100000000B6522241CDCCCCEC9C70594133333333E25222419A999939A67059413333333326532241CDCCCCCCA77059413333333341532241333333F3AC705941000000002D532241CDCCCCECB4705941333333330B53224133333373BD705941333333331453224133333353BE705941333333332053224100000080BF705941CDCCCCCC2E53224133333313C07059416666666642532241666666C6C0705941333333334F5322419A999959C17059416666666663532241666666C6C2705941666666666E532241CDCCCC2CC4705941666666667053224133333393C5705941333333337053224166666626C7705941333333336B532241CDCCCCCCC87059419A99999968532241000000A0CA705941666666666A532241000000A0CE7059419A9999996F53224100000040D37059419A9999997753224100000020D7705941333333338453224100000020DC7059416666666688532241333333B3DE7059419A9999998D532241CDCCCCACE270594133333333A253224133333393F1705941CDCCCCCCA853224133333393F670594166666666B0532241666666E6FB7059419A999999B5532241000000A000715941CDCCCCCCB753224100000040047159419A999999B9532241333333B3067159419A999999C0532241666666860971594166666666CA532241333333130C7159419A999999D15322419A9999790E71594166666666D5532241000000A01171594100000000D55322413333331314715941CDCCCCCCD053224133333373187159419A999999CA5322419A9999191B71594133333333DD532241666666C61C715941CDCCCCCCDF532241666666261E715941CDCCCCCCE453224166666646227159419A999999E6532241CDCCCC2C2471594100000000F15322413333337325715941666666660B542241333333D327715941000000001E542241666666262D7159413333333338542241CDCCCC4C2C7159413333333353542241000000A02F715941000000006C54224100000060377159419A999999855422419A9999593D71594100000000BA542241333333B34571594166666666D0542241666666A64C715941CDCCCCCCCA542241333333B34E71594100000000B95422419A99993950715941000000008B5422413333333352715941666666665C542241CDCCCC6C527159410000000052542241CDCCCC2C547159416666666662542241666666465771594133333333715422419A9999995A7159419A9999995F542241000000E05D715941CDCCCCCC4A542241CDCCCC6C607159419A99999953542241666666C66B7159410000000096542241CDCCCC2C6F715941666666669D542241666666E6727159410000000082542241CDCCCCCC76715941000000008C5422413333335379715941000000009054224133333393837159419A9999999D542241333333B38F7159416666666634542241333333D3967159419A999999305422410000002098715941000000002E54224166666646997159419A9999992E5422419A9999D99A715941333333332F542241000000609C71594100000000EE532241333333B39E71594133333333F153224133333373A4715941333333331E542241666666E6A87159419A9999994654224100000060AE7159410000000052542241000000E0B9715941333333339154224166666686D071594100000000ED54224133333353CF715941333333333C55224166666686CD715941000000003E552241CDCCCCACCF7159419A99999941552241CDCCCC4CD27159416666666645552241CDCCCC4CD57159419A99999947552241000000A0D8715941CDCCCCCC48552241CDCCCCCCDA715941000000004955224133333393DD715941CDCCCCCC475522419A999979E2715941CDCCCCCC455522419A9999F9E6715941333333334255224133333353EE715941666666663E552241333333B3F67159419A9999993B5522419A999979FE7159413333333339552241666666860372594166666666365522410000008006725941CDCCCCCC31552241333333330A725941333333332B552241CDCCCC8C0E725941333333332955224100000060117259416666666629552241CDCCCC4C13725941333333332A5522410000000015725941CDCCCCCC2A552241CDCCCCAC16725941333333332E552241000000C0187259410000000034552241000000A01B725941CDCCCCCC4055224133333333207259413333333349552241333333B322725941666666664F552241CDCCCC4C247259410000000057552241CDCCCC8C257259410000000063552241CDCCCC2C27725941CDCCCCCC6D5522410000006028725941000000007A5522419A999999297259419A99999985552241CDCCCCCC2A7259410000000093552241666666462C7259419A9999999D552241CDCCCCEC2D72594133333333A75522419A9999F92F7259419A999999AC552241333333933172594133333333D9552241000000A03E7259410000000012562241000000803B7259416666666630562241333333533A7259410000000059562241CDCCCC6C3872594166666666705622410000006037725941666666668D5622419A9999193672594100000000AE562241666666863472594166666666CA562241666666263372594100000000EB562241333333333272594133333333035722410000000031725941000000001C572241CDCCCC0C30725941CDCCCCCC35572241666666C62E725941CDCCCCCC51572241CDCCCC2C2D7259410000000068572241333333B32B72594100000000895722419A9999792A72594100000000AD572241333333D32872594100000000D0572241CDCCCCCC2772594100000000E75722419A9999592572594133333333F9572241000000E0227259410000000018582241666666E6237259419A999999585822413333339328725941333333336A5822416666662628725941CDCCCCCC97582241666666C62672594100000000455922413333335325725941000000006D5922419A99999925725941CDCCCCCC7F5922419A9999B925725941CDCCCCCC455A2241CDCCCC8C267259419A999999AE5A22410000008025725941666666661E5B2241CDCCCC8C22725941333333334C5B2241000000202172594133333333745B22413333335320725941CDCCCCCC9D5B2241CDCCCC6C2172594133333333D05B2241CDCCCC0C24725941666666660C5C2241CDCCCCCC267259419A999999515C22410000004029725941CDCCCCCC885C2241666666462A72594133333333A45C2241666666C62B7259419A999999B45C2241000000402F7259419A999999D95C22419A9999993072594100000000F25C2241333333533172594166666666075D224100000040327259419A9999994F5D2241CDCCCC2C3672594166666666995D2241666666863C72594166666666B85D2241666666A63F725941CDCCCCCC0C5E22419A99995945725941333333335E5E22419A9999F94972594100000000A05E2241666666464A7259419A999999E75E2241CDCCCC8C4A725941666666661E5F2241666666464D72594133333333525F2241CDCCCCEC4D725941333333339F5F22419A9999194C72594166666666D35F2241333333734B72594100000000EC5F2241000000404B7259413333333323602241CDCCCCCC4A725941CDCCCCCC5C602241333333334A7259419A99999993602241000000604972594166666666C560224133333373487259413333333326612241666666C64672594166666666336122413333333346725941666666663A612241000000204672594166666666496122419A9999D9457259419A9999995C612241666666A64572594100000000726122413333337345725941CDCCCCCC8E6122419A99993945725941666666669A612241333333334572594100000000A5612241CDCCCCEC44725941CDCCCCCCB26122419A9999594472594100000000BF6122419A9999F94372594100000000D36122419A9999994372594133333333E3612241000000204372594133333333FD6122419A9999B94272594100000000066222419A99997942725941CDCCCCCC1362224100000000427259419A999999256222419A999999417259416666666630622241CDCCCC8C41725941666666663C6222419A999919417259419A9999994B622241CDCCCCAC4072594133333333576222410000006040725941CDCCCCCC69622241333333F33F72594133333333796222419A9999993F7259419A99999988622241000000403F7259413333333393622241333333333F725941CDCCCCCC97622241666666C63F725941333333339F622241333333D33F7259419A999999AD622241666666A63F725941CDCCCCCCB9622241666666663F72594133333333C2622241000000203F72594166666666CA6222419A9999B93E725941CDCCCCCCDC622241CDCCCC6C3E72594166666666ED622241000000603E72594133333333F96222419A9999793E7259416666666605632241333333333E7259419A9999992B6322419A9999F93C725941CDCCCCCC4C632241666666263C725941333333335A6322419A9999193C725941CDCCCCCC8A632241000000203B72594133333333AA632241333333D33A72594133333333BF632241CDCCCCEC3A72594166666666CE632241CDCCCC4C3B72594133333333E6632241CDCCCCCC3B72594166666666FB632241000000C03C725941CDCCCCCC076422419A9999393D7259413333333322642241666666E63D7259416666666639642241333333333E72594133333333496422419A9999393E7259416666666653642241666666A63E725941333333335C642241CDCCCC0C3F7259419A99999969642241000000203F72594133333333786422419A9999993F7259419A999999836422416666662640725941CDCCCCCC91642241CDCCCC8C40725941000000009D642241666666E64072594166666666A9642241333333734172594166666666BC642241666666664272594133333333CE642241333333F34272594166666666DF642241666666E64272594133333333EB642241666666C64272594100000000F7642241666666A642725941333333330C6522419A9999394272594100000000116522410000002042725941333333332C65224100000040427259419A999999396522413333337342725941333333333D652241CDCCCC8C42725941CDCCCCCC47652241333333F3427259419A99999957652241333333F3427259413333333368652241CDCCCCCC427259419A99999976652241CDCCCCAC42725941CDCCCCCC81652241000000A0427259419A9999998A652241666666C642725941333333339165224166666626437259410000000095652241333333B34372594166666666996522419A999919447259419A9999999F6522410000008044725941CDCCCCCCAB652241333333F344725941CDCCCCCCB865224133333393457259419A999999C4652241666666E6457259419A999999D56522419A9999194672594133333333E6652241666666264672594100000000FE65224100000040467259410000000027662241CDCCCC4C467259410000000048662241CDCCCC8C467259419A99999967662241CDCCCC8C467259419A9999998F66224100000020477259419A999999B8662241666666C647725941CDCCCCCCD8662241000000804872594133333333E3662241666666A648725941CDCCCCCCF1662241666666E648725941666666660F67224166666686497259419A9999992B6722419A9999594A725941CDCCCCCC3D672241333333B34A725941CDCCCCCC54672241666666A64A7259413333333366672241333333734A7259410000000080672241666666064A725941666666669B672241CDCCCC8C497259419A999999B7672241333333F34872594100000000D3672241333333934872594100000000EC6722419A99991948725941CDCCCCCC086822419A99999947725941666666662468224100000040477259419A9999993F6822413333331347725941666666665A6822419A9999F946725941CDCCCCCC74682241333333734672594100000000956822419A99995946725941CDCCCCCCB1682241CDCCCC4C4672594166666666C96822419A9999F94572594166666666E4682241333333B3457259419A99999900692241666666464572594166666666146922419A9999394572594100000000236922413333337345725941666666662E692241CDCCCCEC457259419A9999993E692241CDCCCC8C467259413333333351692241CDCCCC0C477259419A99999962692241666666A6477259419A9999996E6922419A9999D9477259416666666685692241333333D34772594133333333986922419A9999194872594133333333AC6922410000004048725941CDCCCCCCC3692241333333334872594100000000D069224133333333487259419A999999E8692241000000404872594133333333016A2241333333734872594166666666346A2241333333B347725941333333335A6A22413333339347725941CDCCCCCC7F6A224100000080477259419A9999999F6A2241000000604772594166666666C06A22413333333347725941CDCCCCCCD56A2241CDCCCCAC467259419A999999EA6A22419A9999F94472594166666666086B2241666666E6417259419A999999226B22419A9999793E725941CDCCCCCC456B2241333333F33B725941CDCCCCCC6B6B22419A9999B93972594166666666C46B2241333333F334725941CDCCCCCC0B6C224166666626307259419A999999306C2241000000402D72594166666666426C22419A9999992B72594166666666136D224166666646257259419A999999DF6D2241CDCCCCCC1F7259419A999999F26D2241666666661F72594133333333026E22419A9999591F725941333333330A6E22419A9999191F725941CDCCCCCC1B6E2241333333F31B725941CDCCCCCC486E2241666666A61A72594166666666636E2241CDCCCC4C1A72594133333333836E2241000000601A725941333333338F6E2241CDCCCC6C1A7259419A999999996E2241666666C61972594133333333A66E22413333331318725941CDCCCCCCB86E224166666646157259419A9999998D6E2241CDCCCC8C0B725941CDCCCCCCE76E2241CDCCCC8CFF715941CDCCCCCC1D6F22419A9999F9F971594133333333576F224100000040F371594133333333B76F224100000040E871594166666666C66F2241CDCCCC6CDD7159419A99999904702241000000C0D3715941666666661870224100000020CC7159419A9999991E702241000000C0BC715941000000001B7022419A9999F9B7715941CDCCCCCC0E7022419A999959A97159416666666607702241CDCCCCCCA671594166666666FD6F22419A999979A471594100000000F26F224100000080A271594100000000E86F2241CDCCCCCC9F71594133333333E56F2241666666869E71594166666666E86F22419A9999999C71594100000000EE6F2241333333739A71594133333333E76F22413333339392715941CDCCCCCCDE6F22419A9999998D7159419A999999E36F2241666666A68971594100000000047022413333335385715941666666663A702241000000208571594100000000687022410000002084715941000000009D702241333333138471594133333333EF7022410000000084715941333333330C712241CDCCCC0C82715941CDCCCCCC31712241333333137E7159419A999999647122419A9999D97D71594166666666AC712241333333937B71594133333333EB7122419A9999F978715941666666661D722241666666E675715941CDCCCCCC60722241333333D3757159419A9999999E722241CDCCCCEC7571594100000000BA7222413333333375715941CDCCCCCCE4722241333333737D71594166666666287322416666662673715941CDCCCCCCD5742241666666E6317159419A999999BF742241CDCCCC4C28715941CDCCCCCC5C742241333333D3F1705941CDCCCCCC0D7422419A999939E17059413333333351742241333333D3DC705941333333335574224133333353DC705941000000005E74224133333393DA7059419A9999997B74224100000000D770594100000000A074224133333313D370594100000000C87422419A9999B9CD7059419A999999CF742241333333D3CB7059419A999999E574224133333333C6705941333333331C752241000000A0C57059413333333354752241CDCCCC6CC4705941666666666B752241666666E6C07059419A99999984752241666666C6BA70594133333333777522419A999979AB70594166666666367522419A9999B993705941CDCCCCCC28752241CDCCCC2C867059413333333327752241333333538270594133333333037522413333333373705941CDCCCCCCBD7422419A9999D9567059419A99999974742241000000E0387059416666666665742241CDCCCC0C3A70594166666666C97322419A99993946705941CDCCCCCCB7732241000000403F7059410000000055732241CDCCCC4C1C7059416666666653732241CDCCCCAC1B7059410000000008732241333333930170594133333333CA722241CDCCCC6CEB6F5941CDCCCCCC9D722241CDCCCC4CDB6F5941CDCCCCCC6372224133333393C66F59410000000055722241333333D3C16F5941000000004A72224133333333BE6F5941000000003D7222419A9999D9BA6F59419A9999991372224133333313B26F594166666666D8712241666666E6A56F5941333333339571224100000080986F59419A99999958712241666666868C6F59419A9999994B712241666666068A6F5941CDCCCCCC10712241000000207E6F594100000000F37022419A999939786F59419A999999EA70224133333393766F594133333333E6702241CDCCCCAC756F5941CDCCCCCCD8702241000000A0736F59419A999999A1702241CDCCCC8C6A6F5941666666664B702241666666465C6F59419A999999E96F2241CDCCCC6C4C6F594133333333886F2241CDCCCCEC3C6F5941000000003F6F2241333333D3316F59419A999999386F2241000000C0306F5941666666668D6E2241666666C62E6F5941333333336F6E22419A9999592E6F59419A999999D96D22419A999919306F594100000000796D224100000040316F594100000000076D2241333333B3326F5941333333335B6C22419A999959366F59419A999999A96B2241666666062B6F594100000000CD6A2241000000201D6F594166666666906A22419A9999F9186F594100000000A169224166666606216F5941000000009669224133333393216F59419A99999993692241000000A0206F59413333333385692241666666A61F6F5941666666667A692241666666E61E6F59419A999999FD682241CDCCCC0C1A6F5941333333339E6822419A999979166F5941CDCCCCCC5E6822419A9999F9136F59416666666645682241666666E6126F59419A99999930682241333333F3116F5941333333330E682241333333730F6F594100000000D7672241000000800B6F5941CDCCCCCCAA67224166666666086F594166666666866722419A999979056F594133333333686722419A999999026F59419A9999992A672241CDCCCC4CFC6E5941CDCCCCCCEE662241CDCCCCECF56E594100000000E2662241333333B3F46E59419A999999D6662241666666A6F36E59419A999999CE66224166666626F36E5941CDCCCCCCC366224166666646F26E5941CDCCCCCCB966224166666686F16E594100000000B066224166666606F16E59419A999999A4662241CDCCCCACF06E5941666666669866224100000080F06E5941333333338D66224166666686F06E5941CDCCCCCC8266224133333393F06E5941CDCCCCCC77662241666666C6F06E5941CDCCCCCC66662241CDCCCC2CF16E5941666666664A66224133333333F26E5941666666661C66224133333333F46E5941CDCCCCCC0866224133333333F56E594166666666D865224166666686F76E594100000000C565224166666686F86E594133333333B3652241CDCCCC6CF96E59419A9999999365224100000000FB6E59419A9999999265224133333313FB6E59419A999999FE64224133333333F16E594133333333CF64224133333373F26E5941333333335E642241666666C6EB6E5941CDCCCCCC5164224100000040E86E59419A9999995E6222419A999919CC6E59419A9999994A622241CDCCCC6CCA6E59419A99999918622241000000A0C66E594100000000C56122419A999999BC6E59416666666668612241000000E0B26E594166666666CF60224133333373AC6E5941666666668F602241666666E6AA6E594133333333F25F22419A999979A86E594166666666E55F224100000040A86E5941CDCCCCCCC65F224100000080A76E594133333333AF5F22419A9999D9A66E5941666666668A5F22419A999999A56E5941CDCCCCCC5C5F2241000000A0A36E59419A9999990E5F224166666626A06E594133333333C55E22419A9999D99C6E594166666666AC5E2241333333D39B6E5941666666669E5E2241000000409B6E5941000000008E5E2241666666C69A6E5941333333337E5E2241000000809A6E5941333333336D5E2241666666869A6E59419A9999995C5E22419A9999B99A6E5941000000003C5E2241000000809B6E59419A999999155E224133333353986E594133333333065E2241CDCCCC0C996E59419A999999FD5D22419A999999996E594166666666F55D2241666666269A6E594166666666EE5D22419A9999999A6E594100000000E65D2241666666069B6E59419A999999DB5D2241333333539B6E5941CDCCCCCCCF5D22419A9999399B6E59419A999999C05D22419A9999D99A6E594100000000A75D2241CDCCCC8C9A6E5941CDCCCCCC905D2241333333539A6E59419A999999835D2241000000209A6E59419A999999715D2241000000009A6E5941000000005E5D2241000000809A6E594166666666475D2241CDCCCC4C9B6E59419A9999992A5D22419A9999F99B6E5941CDCCCCCC505C2241CDCCCC2CA16E5941000000002B5C2241333333F3A16E5941CDCCCCCC025C2241666666A6A26E594166666666E25B2241333333B3A26E59419A999999BF5B22419A9999B9A26E5941CDCCCCCC915B2241000000C0A26E59419A999999695B22419A999999A26E5941333333334B5B22419A999959A26E59419A999999365B224133333353A26E5941666666662A5B2241CDCCCC6CA26E5941CDCCCCCCF0592241333333B3806E5941CDCCCCCC9E59224100000000796E59416666666669592241CDCCCCAC6F6E59416666666641592241CDCCCC0C6D6E5941333333330859224100000060666E59419A9999990859224133333313636E59419A999999C6582241666666A65C6E5941CDCCCCCC70582241CDCCCCCC506E594100000000995822419A9999F9426E594133333333CE5822419A999919326E59419A999999D258224133333373306E59419A999999DD5822419A9999392D6E594133333333E8582241333333B32A6E5941CDCCCCCCF158224100000020276E5941CDCCCCCCF75822419A999939246E59419A999999FB582241CDCCCCEC216E59419A999999FE582241666666861F6E594133333333FC582241000000C0196E594100000000FA58224133333353116E594166666666F7582241000000C0FF6D59419A999999F5582241CDCCCC2CF96D594133333333F4582241333333D3F66D594100000000F158224133333373F46D594166666666ED582241CDCCCC8CF26D5941CDCCCCCCE9582241CDCCCCACF06D594100000000E55822419A9999D9EE6D594166666666DE582241CDCCCC0CED6D594100000000D858224166666646EB6D59419A999999CA582241000000E0E76D59419A999999AD5822419A999939E16D5941666666669E5822419A9999B9DD6D59410000000059582241CDCCCCCCCD6D59419A9999994E58224100000020CB6D5941CDCCCCCC4558224100000060C86D5941CDCCCCCC3F582241CDCCCC2CC66D59419A9999993958224100000080C36D59410000000036582241666666E6C06D5941666666663158224166666666BC6D5941666666661E58224166666606A66D59413333333308582241666666A68B6D59419A99999904582241CDCCCC6C876D59419A9999990158224133333353846D594133333333FE57224133333313816D59419A999999F7572241000000007D6D5941CDCCCCCCF05722419A999999796D5941CDCCCCCCE5572241CDCCCC0C746D59419A999999BC572241CDCCCC0C616D594133333333B4572241333333535D6D594133333333AC572241CDCCCC8C5A6D5941CDCCCCCCA1572241000000E0576D5941CDCCCCCC9357224166666606556D59419A99999983572241666666A6526D5941666666667157224100000020506D5941CDCCCCCC0757224133333393426D594100000000FA562241CDCCCCCC406D594133333333EB562241333333933E6D594166666666E2562241000000E03C6D5941CDCCCCCCDA562241CDCCCC2C3B6D594166666666D456224133333353396D594100000000D3562241000000E0386D594100000000CE5622419A999919376D594166666666C85622419A999999346D59419A999999B156224166666626266D59419A999999AE562241666666C6236D594166666666AC562241666666C6216D594166666666AB5622419A999919206D594133333333AB562241666666861E6D594166666666AC562241333333B31C6D5941CDCCCCCCAE562241000000A01A6D594100000000B7562241CDCCCC6C166D5941CDCCCCCCAA562241666666A6166D594166666666A6562241333333F3166D5941666666669E56224100000080176D5941666666668D56224100000060186D5941333333334D562241666666E61C6D5941000000001F56224133333333206D59416666666615562241000000E0206D59419A9999990A562241CDCCCCAC216D594166666666FD552241CDCCCCCC226D594133333333E755224100000040256D59416666666664552241CDCCCCCC356D5941333333331C552241000000803E6D59419A999999AD5422419A9999B94C6D5941333333339D542241666666A64E6D59419A9999998D542241000000C0506D59413333333349542241666666A65B6D5941333333330E542241000000A0646D594133333333C4532241CDCCCCEC6F6D59419A999999A053224166666626756D59410000000086532241666666A6796D59410000000067532241333333937F6D5941666666661E532241666666268D6D594100000000165322419A9999798E6D5941666666660C532241CDCCCC8C8F6D594133333333015322419A9999D9906D59419A999999F452224166666606926D594100000000E85222419A999919936D594100000000CC522241666666E6926D5941CDCCCCCC975222419A9999D98E6D5941CDCCCCCC7C522241333333F38E6D59419A9999995C5222419A999919906D59410000000009522241666666C6996D5941CDCCCCCCDC512241333333939F6D594133333333AA512241CDCCCCECA56D594133333333935122419A9999F9AB6D5941666666667A512241CDCCCCACB26D5941333333336D512241CDCCCC8CB36D5941CDCCCCCC5F51224100000040B46D59419A9999995051224100000000B56D59416666666642512241666666A6B56D5941CDCCCCCC3451224133333333B66D59410000000029512241CDCCCC8CB66D59416666666616512241666666E6B66D5941000000000651224166666606B76D594166666666F7502241CDCCCCECB66D594100000000E9502241333333D3B66D594133333333DA502241333333B3B66D5941CDCCCCCCCB50224100000080B66D594100000000BD50224133333333B66D594133333333AF502241CDCCCCACB56D594133333333A150224133333313B56D5941666666669250224166666666B46D59419A99999983502241666666A6B36D59419A99999977502241666666E6B26D59416666666669502241CDCCCCACB16D59419A99999957502241CDCCCC6CB06D5941CDCCCCCC47502241CDCCCC2CAF6D5941CDCCCCCC3A50224100000040AE6D5941333333332F50224133333353AD6D5941333333332450224166666686AC6D59416666666617502241666666C6AB6D5941CDCCCCCC0750224100000000AB6D59419A999999F14F2241666666E6A96D594166666666E24F224133333333A96D5941CDCCCCCCD14F2241666666A6A86D5941CDCCCCCCBF4F224166666606A86D59419A999999B54F2241333333B3A76D59419A999999AB4F2241000000A0A76D5941CDCCCCCCA14F2241333333B3A76D5941CDCCCCCC954F224166666606A86D594133333333524F2241333333D3AA6D5941CDCCCCCC3E4F224166666606AC6D5941666666662E4F22419A999919AD6D5941000000001D4F22419A999959AE6D594100000000124F22419A9999F9AE6D5941CDCCCCCC064F22419A999979AF6D59419A999999D34E2241666666A6B06D59419A999999BC4E224100000020B16D594166666666994E22419A999919B26D5941333333333D4E224166666666B56D5941CDCCCCCC264E2241000000E0B56D594133333333104E2241666666E6B56D594133333333FB4D224100000060B56D5941CDCCCCCCD34D22419A9999F9B36D5941CDCCCCCCC84D2241CDCCCC8CB36D594166666666BC4D224166666626B36D594133333333AE4D2241666666E6B26D594100000000A04D2241333333B3B26D5941CDCCCCCC8E4D224133333373B26D594133333333804D22419A999919B26D594100000000714D2241333333D3B16D594100000000614D2241CDCCCC4CB16D594133333333504D2241333333D3B06D5941666666663F4D2241CDCCCC6CB06D5941CDCCCCCC2D4D2241CDCCCC2CB06D5941333333331C4D224100000000B06D594100000000F94C2241333333F3AF6D59419A999999ED4C2241CDCCCCECAF6D59419A999999E04C2241666666A6AF6D59419A999999D54C2241CDCCCC2CAF6D594100000000CA4C224133333393AE6D594100000000AA4C22419A999939AC6D59419A999999874C2241666666A6A96D594100000000434C2241333333F3A46D5941CDCCCCCC2E4C22419A999959A36D594166666666FA4B22419A9999799F6D594166666666B14B2241000000609D6D5941666666668A4B2241CDCCCC0C9D6D5941000000007E4B2241333333F39C6D5941CDCCCCCC684B2241000000809F6D5941333333332C4B224100000060A66D594166666666FF4A22419A999979AB6D594166666666DC4A2241CDCCCC8CAF6D59419A999999C54A224100000080B26D59419A999999B34A224100000000B56D5941CDCCCCCC814A224166666606BC6D594166666666734A22419A9999F9BD6D594100000000644A224100000000C06D5941000000005C4A2241333333D3C06D59419A999999514A2241000000E0C16D5941CDCCCCCC404A224166666686C36D59419A999999314A2241CDCCCC0CC56D5941666666662E4A2241CDCCCC4CC56D5941CDCCCCCC094A224166666686C86D594133333333F7492241CDCCCC2CCA6D594133333333EC4922419A999959CB6D594100000000C84922419A9999F9CE6D59419A999999BA492241CDCCCC2CD06D594100000000AA492241CDCCCCACD16D5941CDCCCCCC804922419A999939D56D59410000000074492241CDCCCC4CD66D5941333333336B49224100000040D76D59419A999999624922419A999939D86D5941CDCCCCCC55492241000000E0D96D5941666666664B4922419A999919DB6D5941333333333F49224166666686DC6D5941CDCCCCCC31492241000000E0DD6D59419A99999901492241CDCCCCACE26D5941CDCCCCCCE7482241CDCCCC8CE56D5941CDCCCCCCD148224133333333E86D594100000000B948224100000020EB6D5941333333338548224100000000F26D5941333333337648224100000020F46D5941000000006A48224133333353F56D5941CDCCCCCC5C48224100000080F66D5941666666665048224133333373F76D5941000000004448224133333393F86D5941333333331648224133333313FC6D59419A999999E947224133333353FF6D594166666666BB47224166666606036E5941333333338547224133333373076E59419A99999957472241666666A60A6E59413333333323472241666666060E6E59419A999999EE46224166666686116E59419A999999C14622419A999959146E5941	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	01010000206A080000D06FD18ED260224133333373B46F5941	360020000	Z	Aize	3600200	36002	36	24	17
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	01010000206A08000058555595E8EA2241CCCCCC0CDA4C5941	360030000	Z	Ambrault	3600300	36003	36	24	26
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	01010000206A080000E6D8C0CD7B9A2241CDCCCC6C217A5941	360040000	Z	Anjouin	3600400	36004	36	24	29
01060000206A08000001000000010300000001000000D602000066666666A27122419A9999F9F0475941CDCCCCCCBB71224166666646F347594166666666E271224133333353F6475941CDCCCCCC91722241CDCCCC0C06485941CDCCCCCCE4722241666666060D485941000000001E74224100000060284859419A9999998B7422419A9999F93148594100000000CD7422419A999979374859419A9999992B752241666666A63F485941666666668375224100000040474859416666666670762241000000405C4859416666666696762241CDCCCC6C5F485941333333331A772241666666866A485941000000009577224133333333754859419A9999991A78224166666626814859419A999999AF782241CDCCCCEC8D4859416666666638792241333333D3994859419A999999A37922419A999919A3485941CDCCCCCC6C7A22419A999999B4485941000000009B7A224166666626B94859419A999999D27B224100000040D5485941CDCCCCCC907D2241CDCCCCACFB48594133333333FD7D22419A99997903495941CDCCCCCC297E2241CDCCCC4C074959419A999999847E2241333333530F4959419A999999357F22419A9999B91E49594133333333AA7F2241CDCCCCCC2849594133333333D07F2241666666A62C4959413333333323802241CDCCCC8C3349594166666666AD802241333333533F4959419A999999AE8122419A99997955495941CDCCCCCCCE822241666666066F49594166666666F98222416666664672495941CDCCCCCCD0842241666666269B495941666666665585224166666626A6495941000000006185224166666646A7495941333333338385224133333393AA495941000000009C852241333333F3AC4959419A9999999885224133333373AF495941666666668F85224166666606B649594166666666878522419A9999B9BC495941000000008185224133333373C4495941000000007D85224100000020C94959419A99999976852241CDCCCC2CCF4959413333333370852241666666A6D3495941666666666C8522419A9999B9D749594166666666668522419A9999F9DE495941000000006485224100000060E34959419A9999996385224100000080E4495941333333335E85224100000000EA495941000000005885224133333373EE4959419A9999994E852241CDCCCC2CF44959419A999999EA842241333333D3F14959413333333370842241333333B3114A59419A9999998385224100000020244A59419A9999999285224133333393264A59419A999999A7852241CDCCCC8C284A59419A999999AC85224100000020294A594133333333B8852241333333932A4A594100000000C9852241000000202C4A59419A999999DA852241333333932D4A594100000000EB852241000000A02F4A59419A999999F48522419A999999314A5941CDCCCCCCFA8522419A999919344A594133333333FF85224133333353364A59416666666612862241333333D33F4A5941000000002486224133333373494A5941CDCCCCCC2D862241CDCCCC6C4D4A5941CDCCCCCC33862241CDCCCC6C4F4A5941333333333C862241CDCCCC4C514A59419A999999498622419A999939544A5941CDCCCCCC5686224100000080564A594133333333618622419A999959584A59419A9999996A862241333333B35A4A59416666666671862241333333535D4A594100000000868622419A999939644A59419A9999999A862241CDCCCC2C6B4A594100000000B3862241CDCCCC4C744A594133333333D4862241CDCCCC4C804A594166666666F28622419A9999598C4A59419A999999FC862241333333B3904A59419A999999028722419A999979924A59416666666609872241333333B3944A59419A99999911872241333333F3974A59419A9999991A872241000000009B4A59413333333324872241333333939F4A59419A9999992D872241CDCCCCACA44A5941000000003787224166666646AA4A5941666666663E872241333333B3B04A5941000000004A87224133333313B74A59410000000053872241CDCCCCCCBB4A5941CDCCCCCC5E872241CDCCCCACC04A5941CDCCCCCC6F8722419A999939C74A5941CDCCCCCC83872241000000E0CD4A59416666666694872241CDCCCC8CD24A594166666666A5872241666666C6D64A594166666666AC872241000000A0D84A59419A999999B08722419A999939DA4A594100000000B68722419A999979DB4A594166666666C0872241666666C6DE4A594100000000D4872241666666C6E44A5941CDCCCCCCE7872241666666E6EA4A594133333333F587224133333393EE4A59419A999999FD87224100000040F24A59419A999999048822419A9999B9F44A5941666666660888224100000060F64A59419A99999909882241000000E0F74A5941CDCCCCCC0A88224133333333F94A5941000000000C882241333333F3FA4A5941CDCCCCCC0D8822419A9999D9FC4A59413333333310882241333333B3FE4A594100000000128822419A999919004B5941666666661488224100000080014B59419A9999991588224166666626034B5941333333331588224133333353044B5941CDCCCCCC13882241CDCCCCAC054B59419A9999990E88224166666646084B59419A999999078822419A9999B90C4B5941000000000B88224100000040114B5941000000001888224166666626164B5941CDCCCCCC2C8822419A9999791E4B5941CDCCCCCC41882241666666662B4B5941666666664F8822419A999919354B59416666666653882241333333F33B4B5941333333335B8822419A9999D9434B5941666666665F882241333333134C4B59419A999999718822419A999919564B5941CDCCCCCCFA88224133333313584B5941CDCCCCCCFF88224133333313594B594166666666068922419A9999595A4B59410000000012892241666666065D4B59419A9999992189224100000040614B59419A9999992C892241CDCCCC8C644B5941CDCCCCCC3B892241333333D3684B59419A999999508922419A9999196D4B5941CDCCCCCC6A892241CDCCCC2C714B5941333333337D892241000000C0734B5941666666669389224100000020764B594100000000B2892241000000C0784B59419A999999CD892241666666E67A4B59419A999999E6892241333333337D4B5941333333330A8A2241333333D3804B594133333333378A22419A9999B9854B5941000000009A8A2241666666C6904B594100000000B88A22419A9999B9944B594133333333C58A2241CDCCCC0C964B594133333333CB8A2241333333F3964B59419A9999998B8C22419A9999B9BD4B59419A9999992D8D224100000000CB4B594166666666B18D22419A999959D64B594100000000E28D22419A999939DA4B59419A999999158E22419A999939E04B5941CDCCCCCC728E224100000040ED4B59419A999999858E224133333393EF4B59419A999999988E2241666666C6F14B594133333333AC8E2241CDCCCCECF34B594166666666B48E2241000000E0F44B59419A9999998A902241666666C62F4C594166666666EE902241000000C03A4C59410000000017912241333333533C4C594100000000499122419A9999993E4C5941CDCCCCCC7C91224133333333414C594133333333A89122419A999959434C59419A999999C6912241000000C0444C594100000000E0912241666666A6454C59419A999999F99122419A999959464C5941000000002C922241CDCCCC6C474C59419A9999997A9222419A999999484C594100000000EC922241333333534A4C5941CDCCCCCC57932241333333334B4C5941CDCCCCCC889322419A9999D94B4C594100000000AA9322419A9999794C4C594100000000D1932241000000A04D4C59413333333302942241333333534F4C5941000000001F94224133333373504C5941000000003794224133333353514C5941000000004B942241333333D3514C5941CDCCCCCC6094224133333313524C5941000000007B9422419A999939524C5941666666669694224166666666524C5941000000000195224166666646534C5941CDCCCCCC36952241CDCCCCCC534C5941666666663A952241000000E0534C5941333333332F95224100000060584C5941333333331E9522419A9999995D4C5941CDCCCCCC16952241666666A6604C5941CDCCCCCC14952241333333D3624C5941CDCCCCCC1495224166666646644C5941666666661A952241000000806A4C5941333333331D952241333333136E4C5941CDCCCCCC1D9522419A999939724C5941000000001E952241333333D3734C59419A9999992795224100000040754C59410000000040952241666666A6774C5941000000004B95224133333313794C59416666666652952241000000A07A4C5941333333335C952241CDCCCC8C7D4C5941000000006B9522419A999919844C5941CDCCCCCC7B952241666666868B4C5941CDCCCCCCA6952241CDCCCC0C8A4C5941CDCCCCCCD2952241666666E6884C5941666666660D9622419A999959874C59413333333351962241000000C0854C5941000000009696224133333373844C5941CDCCCCCC45972241CDCCCCEC804C59410000000058972241666666E6804C59419A9999997A972241CDCCCC8C814C594133333333979722419A999939824C59419A999999DB9722419A9999F9844C5941CDCCCCCC21982241CDCCCC2C884C59410000000087982241333333938C4C59419A999999CE9822419A9999998F4C594133333333F098224166666606914C5941333333331299224100000020924C5941CDCCCCCC3A992241CDCCCC0C934C59419A99999999992241CDCCCCCC944C5941000000001F9A224100000060964C594166666666409A22419A999919974C5941333333335F9A224100000020984C594133333333869A2241000000C0994C594100000000B09A2241000000209C4C594133333333E59A2241333333B39F4C5941333333331F9B22419A999959A34C59419A9999995F9B224133333373A64C594100000000A29B2241333333B3A94C594166666666F29B2241CDCCCC2CAE4C5941333333336B9C224100000080B54C594133333333F99C2241333333D3BF4C5941000000002E9D2241000000A0B74C5941CDCCCCCCA09D2241333333D3A54C594133333333DF9D2241CDCCCC2C9C4C5941CDCCCCCCFF9D2241CDCCCC0C984C5941CDCCCCCC179E2241666666E6954C5941CDCCCCCC4B9E224166666666914C5941CDCCCCCC789E22419A9999998D4C594133333333CD9E2241000000C0854C59419A999999069F2241000000807F4C594166666666269F2241CDCCCC0C7C4C5941000000006D9F224133333353744C5941CDCCCCCCE09F2241666666E6654C59416666666647A02241333333F3574C59419A99999976A0224133333333514C59419A999999A4A02241333333134B4C594166666666C8A022419A9999D9454C594166666666EBA0224100000080404C5941CDCCCCCC07A12241333333F33B4C5941333333332BA12241CDCCCCAC364C59416666666649A12241CDCCCCCC324C59413333333366A122419A9999392F4C59416666666692A12241CDCCCC6C2A4C594166666666D2A12241333333F3224C59419A99999900A22241000000A01D4C59410000000012A22241666666861B4C5941000000001DA2224166666626184C5941666666663EA22241000000400F4C59419A9999995BA2224133333373084C59413333333366A2224166666626064C59419A9999996FA22241666666C6044C59416666666679A2224166666646034C5941CDCCCCCC8CA22241333333F3004C59419A999999A9A22241CDCCCC0CFE4B594133333333BAA22241CDCCCCCCFC4B594166666666D0A222419A9999B9FA4B59416666666603A3224166666646F54B59410000000047A3224133333393ED4B59416666666668A32241CDCCCCECE94B594166666666A9A32241CDCCCC0CE44B59419A999999ECA322419A999999DE4B59419A99999921A422419A999999DA4B59413333333351A422419A9999F9D74B5941CDCCCCCCA8A4224100000020D44B59419A99999914A5224100000040CF4B5941000000003CA522419A999939CD4B59416666666659A522419A999999CB4B5941333333336CA52241CDCCCCECC94B5941CDCCCCCC90A5224100000020C74B5941CDCCCCCC9FA522419A999999C54B594133333333A9A52241333333F3C34B5941CDCCCCCCADA52241666666C6C14B594133333333B3A52241CDCCCC8CBE4B594166666666C9A5224133333353A04B594133333333D0A5224100000080984B594100000000D7A52241333333B3924B594100000000E0A52241666666068E4B5941CDCCCCCCEFA52241666666A6874B59419A999999E7A52241666666667D4B594166666666F5A52241666666C67D4B5941333333333EA62241333333537F4B5941CDCCCCCCA1A6224100000020814B59410000000027A72241666666A6834B594100000000B7A722419A999919864B59416666666645A822419A9999D9884B5941CDCCCCCC86A822419A9999398A4B594166666666A2A82241CDCCCC8C8A4B594100000000B4A82241333333938A4B594133333333C5A822419A9999598A4B594100000000D1A82241CDCCCCEC894B5941CDCCCCCCDCA8224166666646894B59419A999999EDA822419A999919884B594100000000FFA8224100000080864B5941CDCCCCCC13A9224100000080844B59419A99999930A92241000000C0814B59419A99999971A92241333333937B4B59419A999999A6A92241CDCCCCAC764B59419A99999905AA2241000000806D4B5941CDCCCCCC36AA2241333333F3684B5941CDCCCCCC54AA2241666666E6664B59419A99999957AA22419A9999B9664B59419A9999997AAA2241333333B3644B5941CDCCCCCC9AAA224166666646634B59416666666604AB2241CDCCCCAC5E4B5941CDCCCCCC39AB2241CDCCCC8C5C4B594133333333ACAB2241666666C6574B59419A999999C1AB22419A9999F9564B5941CDCCCCCCDAAB224133333353564B59419A999999F3AB2241333333D3554B5941333333331CAC2241000000C0554B5941333333335EAC2241333333D3554B59416666666697AC224100000020564B5941CDCCCCCCC6AC224133333333564B594100000000ECAC22419A999959554B59419A9999992DAD22419A9999D9514B59419A999999E0AD22419A9999B9454B5941666666667CAE2241666666863B4B59419A999999EEAE2241CDCCCC8C334B5941CDCCCCCC01AF224133333393324B5941CDCCCCCCFBAE224166666686314B5941CDCCCCCCFBAE22419A9999D92E4B594166666666F9AE2241333333332B4B59419A999999F1AE224100000000254B594133333333E4AE2241333333F31C4B59419A999999D2AE22419A999979154B59419A999999C6AE2241CDCCCC4C104B5941CDCCCCCCBDAE2241333333D30A4B594100000000B0AE2241CDCCCC6C004B5941CDCCCCCCA5AE2241666666A6F84A5941666666668FAE2241333333F3EA4A59416666666678AE22419A999999DE4A5941CDCCCCCC69AE224133333393D64A5941CDCCCCCC5DAE2241CDCCCCACCD4A59410000000052AE2241000000C0C44A5941000000004EAE22419A999919C14A5941000000004DAE224100000020C04A59416666666659AE224100000020C04A59416666666663AE22419A9999D9BF4A5941000000008CAE224166666606BC4A594100000000BDAE2241CDCCCCACB74A59410000000010AF2241333333F3AF4A5941CDCCCCCC49AF224100000040AA4A59419A9999996DAF224166666646A64A59410000000095AF2241CDCCCC6CA04A59419A999999BCAF224100000060994A59416666666602B02241CDCCCC8C8C4A5941000000004CB02241333333D37F4A5941CDCCCCCC85B02241CDCCCCAC754A5941CDCCCCCCBDB02241666666A66B4A594133333333C4B022419A9999196B4A5941CDCCCCCCE5B022419A9999B9654A5941CDCCCCCC1AB12241666666265D4A5941666666663CB122419A9999B9564A5941CDCCCCCC54B1224166666686514A59419A9999996AB12241000000204E4A5941666666668CB12241333333134A4A594133333333AFB1224166666606464A594166666666D4B1224133333393404A594166666666F5B12241000000203C4A5941CDCCCCCC0AB222419A9999D9394A5941000000003FB22241CDCCCC8C354A594100000000A1B22241666666862D4A59419A999999CEB222419A9999D9294A594133333333E0B22241000000C0284A594100000000F8B222419A9999F9264A59413333333339B32241CDCCCCCC214A5941CDCCCCCC98B32241666666261A4A594100000000C9B32241CDCCCC2C164A59410000000010B42241000000000F4A59416666666661B4224133333373064A594166666666B0B42241CDCCCC0CFE4959419A999999D9B4224100000060F949594166666666F4B4224166666666F6495941666666662BB5224133333313F0495941CDCCCCCC60B52241333333B3E9495941666666669AB5224166666606E34959419A999999C2B52241333333D3DD49594133333333F3B52241CDCCCCCCD84959410000000009B6224133333333D6495941CDCCCCCC14B6224166666606D54959419A9999991CB6224133333333D4495941CDCCCCCC2CB62241666666E6D14959419A99999954B62241CDCCCC6CCC4959410000000093B622419A999979C34959419A999999B3B6224100000040BF49594166666666CEB62241666666E6BB49594133333333DEB62241CDCCCC4CBA4959419A999999F0B622419A9999F9B84959413333333315B7224166666686B64959419A9999994EB7224166666646B34959410000000062B7224133333353B24959416666666677B7224166666686B1495941CDCCCCCC93B72241333333D3B049594166666666C4B7224133333373AF495941CDCCCCCCFBB72241CDCCCC0CAE495941666666662CB822419A9999D9AC4959416666666649B8224166666606AC4959419A9999996EB82241CDCCCC2CAB4959419A99999994B82241CDCCCC6CAA495941CDCCCCCCBDB82241CDCCCCCCA949594100000000D9B8224166666646A949594133333333E7B822419A9999F9A84959419A999999F0B82241666666C6A84959413333333301B9224166666606A8495941000000000BB92241CDCCCC4CA7495941CDCCCCCC0CB9224100000020A74959419A99999919B92241CDCCCCECA7495941CDCCCCCC24B92241333333F3A74959410000000047B9224133333353A74959410000000077B92241CDCCCC4CA649594133333333AAB92241333333B3A549594133333333CDB92241CDCCCC6CA549594166666666F1B9224166666646A5495941CDCCCCCC07BA22419A999939A5495941333333333EBA22419A999959A54959410000000067BA224133333353A5495941CDCCCCCC91BA224133333353A5495941CDCCCCCCD7BA2241666666C6A44959413333333303BB22419A999939A4495941CDCCCCCC13BB224133333393A3495941333333331DBB22419A9999B9A2495941CDCCCCCC49BB224166666606A64959419A9999995EBB2241666666A6A7495941CDCCCCCC67BB2241CDCCCC6CA7495941666666667ABB22419A999979A7495941CDCCCCCC99BB2241CDCCCC6CA749594166666666B2BB224166666626A749594133333333D0BB22419A999979A64959419A999999E2BB22419A9999D9A5495941CDCCCCCCF7BB2241000000C0A44959419A99999906BC2241333333F3A34959413333333314BC224133333373A34959419A9999991CBC22419A9999F9A24959410000000020BC2241CDCCCCCCA2495941000000002BBC224166666666A2495941CDCCCCCC38BC2241CDCCCCECA1495941CDCCCCCC4DBC2241CDCCCCECA04959410000000064BC2241CDCCCC6C9F4959419A9999997DBC2241333333739D4959416666666697BC22419A9999599B49594133333333B8BC2241666666A6984959419A999999D6BC2241CDCCCC6C9649594100000000EEBC2241333333B394495941CDCCCCCC02BD224133333313934959419A99999919BD22419A999919914959416666666638BD2241666666068E4959413333333350BD22419A9999798B4959410000000069BD224166666626894959410000000086BD22419A999979864959413333333396BD2241000000208549594100000000A1BD2241333333338449594133333333B8BD2241CDCCCC6C8249594100000000CCBD2241CDCCCCEC804959419A999999E1BD2241000000607F49594166666666F1BD2241CDCCCCAC7D4959410000000008BE22419A9999797B495941666666661CBE2241CDCCCC2C794959416666666633BE2241CDCCCCEC75495941CDCCCCCC3FBE22410000002074495941000000004CBE224166666646724959419A9999995BBE2241333333D36E495941CDCCCCCC71BE2241666666666A495941000000007CBE2241666666C6674959410000000086BE22419A9999F9644959419A999999A0BE2241666666265E49594100000000BABE2241333333D356495941CDCCCCCCD0BE22413333333350495941CDCCCCCCE5BE22419A9999594A495941CDCCCCCC06BF2241000000C041495941333333331DBF2241000000803B4959419A99999935BF22419A99993935495941333333333FBF224133333353324959416666666642BF224100000000314959410000000033BF2241666666062F495941333333330BBF22410000006029495941CDCCCCCCD9BE22419A9999392249594133333333C1BE2241666666E61E4959416666666696BE2241CDCCCCEC18495941333333336BBE2241666666E6134959410000000029BE2241666666460C495941CDCCCCCC0ABE2241666666C6084959419A999999CBBD2241CDCCCC8C0149594166666666A5BD2241000000C0FC4859410000000084BD2241CDCCCCCCF84859410000000064BD224100000040F44859410000000042BD224100000000EF4859419A9999991CBD22419A9999D9E8485941CDCCCCCC03BD2241CDCCCC6CE448594100000000F0BC2241CDCCCC2CE148594133333333E9BC224100000020E04859419A999999A6BC2241333333F3D54859419A9999997CBC2241CDCCCC6CCF485941000000001FBC2241CDCCCC0CC04859416666666602BC2241CDCCCC2CBC4859419A999999E1BB2241CDCCCCECB6485941CDCCCCCCB3BB2241333333B3AF485941000000007EBB224166666606A84859419A9999995BBB2241CDCCCCCCA2485941000000003BBB2241CDCCCC2C9D485941666666661BBB224133333353974859419A999999F0BA22419A9999D98F48594133333333D1BA2241333333138A48594166666666C0BA224100000020874859419A999999B0BA2241CDCCCC0C844859419A999999AABA2241333333D3824859419A9999997BBA2241CDCCCC8C7A4859419A9999993BBA2241333333D3704859416666666607BA22419A9999796948594100000000A9B92241666666C65F4859416666666673B922419A9999595A485941000000002EB9224100000080534859419A99999903B92241666666E64F4859416666666667B922419A9999F9504859413333333379B9224133333353514859416666666685B92241666666665148594133333333A1B922419A9999B9514859419A999999FBB92241666666C652485941CDCCCCCCB0BA2241000000405448594100000000D9BA2241666666065548594166666666E9BA22413333331355485941CDCCCCCCEFBA2241666666465548594133333333BDBB22419A9999D983475941000000001DBC22416666662686475941000000008EBC2241CDCCCC4C89475941CDCCCCCC08BD22419A9999D98C475941666666666BBD2241333333138F475941000000007BBD2241000000C08F4759419A99999985BD22419A99991990475941333333338CBD224133333373904759419A999999A0BD22419A9999D99147594100000000CCBD2241333333B394475941CDCCCCCC31BE2241333333339C475941CDCCCCCC7BBE2241000000C0A147594166666666E4BE2241CDCCCCACA947594133333333A3BE22410000006083475941CDCCCCCC1DBE2241CDCCCC0C4F475941CDCCCCCC53BD22419A9999D9F54659416666666665BD2241CDCCCCCCF54659410000000075BD2241CDCCCCCCF5465941CDCCCCCC8EBD2241CDCCCCECF5465941CDCCCCCC85BE2241CDCCCCACF846594100000000EBBF2241CDCCCC6CD04659410000000044C02241333333D3C346594100000000FAC02241333333D39C46594166666666EFC02241CDCCCC2C9546594133333333ECC02241CDCCCC6C8F46594100000000ECC02241333333F38A46594100000000EDC02241CDCCCCAC87465941CDCCCCCCEEC02241000000408546594166666666F3C022419A999979814659419A999999FDC02241666666267B465941CDCCCCCC0AC12241333333B3744659410000000022C12241CDCCCCCC6C465941000000003FC1224133333353634659416666666650C122419A9999995D4659413333333383C12241666666864C46594166666666B1C12241000000E03C465941CDCCCCCCDAC122419A9999D92E465941CDCCCCCCEAC12241CDCCCC4C28465941CDCCCCCCF3C122419A9999B92346594166666666F9C12241000000201F4659419A999999FAC122419A9999791B465941CDCCCCCCFAC12241000000E01A46594166666666FAC122416666666614465941CDCCCCCCF9C122419A9999590B46594133333333F8C12241CDCCCC6CED45594166666666F5C12241CDCCCCECD34559419A999999F4C12241000000E0CC455941CDCCCCCCF0C12241333333D39745594100000000ECC12241CDCCCCAC6545594133333333ECC122419A999979624559419A999999ECC12241CDCCCCAC5545594100000000E7C12241CDCCCCEC1F45594166666666E2C1224100000080F144594133333333E1C1224100000040E644594133333333DCC122419A9999599F445941CDCCCCCCDBC12241333333939A445941CDCCCCCCD9C1224133333393734459419A999999D9C12241000000E07044594133333333D8C12241CDCCCC8C55445941CDCCCCCCD4C12241000000A02B445941CDCCCCCCD2C12241CDCCCC8C14445941666666664AC02241333333F3E5435941CDCCCCCC36C0224100000080E44359413333333370BF2241CDCCCC4CCB4359419A99999922B82241000000C0144359419A99999980B422419A9999F9BE425941666666665CB3224133333373B54259416666666642B3224133333313B4425941CDCCCCCC38B32241666666E6B34259419A99999930B3224166666646B3425941666666662EB3224100000080B24259413333333330B322419A999939B1425941666666660EB322419A999959AE4259419A999999FDB2224100000000AE42594166666666F2B22241000000C0AF42594133333333E5B22241CDCCCCECAF425941CDCCCCCCD7B22241666666A6AF425941CDCCCCCCA7B22241333333B3AC425941CDCCCCCC81B2224133333353AA4259410000000000B222419A999939AD42594133333333A2B12241666666A6AD4259416666666607B1224100000060AD4259410000000055B0224100000020AE4259416666666659B022419A999999A2425941CDCCCCCCA5AF2241000000E0A142594166666666A0AF224133333353A8425941000000009DAF224133333353AE425941CDCCCCCC9AAF224166666606B34259416666666697AF224166666626B74259413333333395AF2241333333F3BA425941CDCCCCCC8EAF224100000060BF4259416666666683AF2241CDCCCC8CC44259410000000078AF2241666666A6C8425941CDCCCCCC6AAF22419A999979CD4259410000000062AF2241CDCCCCECD14259413333333359AF224133333313D74259410000000053AF2241CDCCCCCCDA4259419A99999948AF2241000000E0DF4259419A99999939AF2241666666E6E7425941333333332EAF224166666626EC425941333333331FAF224133333373F24259413333333305AF224166666666F9425941CDCCCCCCEDAE2241CDCCCC6CFF4259419A999999DBAE22419A9999790343594166666666BFAE2241333333730943594133333333ACAE2241666666260B435941CDCCCCCC91AE2241CDCCCC2C0B4359419A99999970AE2241666666260C4359413333333354AE2241CDCCCCCC0C4359419A99999932AE22419A9999F90E435941CDCCCCCC15AE2241CDCCCCAC104359419A999999FEAD2241000000A01143594166666666E5AD22419A9999B912435941CDCCCCCCC3AD22410000000016435941CDCCCCCC8EAD22419A9999991B4359419A99999940AD22419A9999F9244359419A99999926AD22413333333329435941CDCCCCCC23AD2241666666062B4359419A99999932AD22419A9999392D4359419A99999915AD2241333333133043594133333333BCAC2241333333D338435941000000009FAC2241CDCCCC0C3C4359413333333393AC2241666666C63D4359410000000088AC224100000000424359416666666609AC2241333333B3424359413333333358AB2241666666A643435941000000005FAA2241666666664B435941CDCCCCCC42A822419A9999B961435941CDCCCCCC12A8224100000000604359419A999999F1A72241000000405F4359419A999999C4A72241333333B35F435941000000009BA7224100000060614359416666666689A62241666666C674435941CDCCCCCCC09F22419A9999F9AC43594133333333A09F224133333373B2435941666666666F9F224100000060BA43594100000000319F224100000000C5435941000000000F9F22419A9999F9CB4359419A999999089F2241000000E0CC43594100000000F09E22419A999919D343594100000000E49E224100000020D6435941CDCCCCCCCB9E22419A999979DC4359419A999999B79E2241333333F3E043594133333333A79E224133333353E343594133333333649E22419A999959ED435941CDCCCCCC169E22419A9999B9F843594133333333F19D2241666666C6FF4359419A999999D49D2241CDCCCCAC0644594166666666FF98224133333353654459416666666617942241CDCCCC8CCF44594133333333AB8F224100000000D944594100000000008F22419A999959DA445941666666666B8E224100000040DC44594166666666C28D2241CDCCCC4CDD4459419A9999997F8B22419A9999D9E24459419A999999678B2241CDCCCC0CE3445941CDCCCCCC228A224166666606E644594133333333D188224166666606E9445941000000008987224133333313EC445941CDCCCCCCA586224166666646EE4459413333333385862241CDCCCC0CEF445941666666666D8622419A999979F14459419A99999956842241333333D33E4559419A999999DC822241000000C07545594166666666A7822241333333137D455941CDCCCCCC97802241CDCCCCACC945594166666666778022419A999979CE4559419A9999993480224100000000D845594133333333A77F224166666646EC45594133333333FC7E22419A999939054659419A999999DA7E2241CDCCCCEC09465941CDCCCCCC467E2241CDCCCCAC1E46594133333333CA7D2241CDCCCC0C31465941CDCCCCCC727D2241333333733D465941333333331F7D22416666668649465941666666660B7D2241666666664C46594166666666FB7C2241333333D34E465941CDCCCCCCD07B2241666666467B46594100000000397B2241CDCCCC6C9046594133333333497A224133333393B14659419A9999991D7A224166666666B746594133333333BF792241000000E0C546594133333333B579224133333373C7465941CDCCCCCC25792241666666A6DC4659419A99999932782241CDCCCC6CFF46594100000000F17722419A99999909475941000000007B772241666666861A47594133333333FD762241CDCCCCEC2B47594100000000DB762241CDCCCCAC30475941000000008D762241333333133C47594100000000EB752241666666C65347594133333333FD742241CDCCCC4C7647594166666666607422419A9999D98C4759419A999999A5732241CDCCCCECA747594100000000B372224133333313CA4759419A999999D37122419A999999EA47594166666666B9712241000000C0ED47594166666666A27122419A9999F9F0475941	01060000206A080000010000000103000000010000000001000066666666A27122419A9999F9F04759419A9999998B7422419A9999F931485941666666668375224100000040474859416666666670762241000000405C485941333333331A772241666666866A4859419A9999991A7822416666662681485941CDCCCCCC6C7A22419A999999B4485941000000009B7A224166666626B94859419A999999D27B224100000040D5485941CDCCCCCC907D2241CDCCCCACFB48594133333333FD7D22419A9999790349594133333333AA7F2241CDCCCCCC2849594133333333D07F2241666666A62C4959419A999999AE8122419A99997955495941CDCCCCCCCE822241666666066F49594166666666F98222416666664672495941CDCCCCCCD0842241666666269B495941666666665585224166666626A6495941000000009C852241333333F3AC49594166666666878522419A9999B9BC4959413333333370852241666666A6D3495941333333335E85224100000000EA4959419A9999994E852241CDCCCC2CF44959419A999999EA842241333333D3F14959413333333370842241333333B3114A59419A9999998385224100000020244A594100000000EB852241000000A02F4A5941CDCCCCCCFA8522419A999919344A5941CDCCCCCC33862241CDCCCC6C4F4A594133333333618622419A999959584A59419A9999999A862241CDCCCC2C6B4A59419A9999991A872241000000009B4A59410000000053872241CDCCCCCCBB4A5941CDCCCCCC83872241000000E0CD4A594166666666AC872241000000A0D84A594133333333F587224133333393EE4A5941666666660888224100000060F64A59419A9999991588224166666626034B5941000000000B88224100000040114B5941CDCCCCCC2C8822419A9999791E4B5941666666664F8822419A999919354B5941666666665F882241333333134C4B59419A999999718822419A999919564B5941CDCCCCCCFA88224133333313584B5941CDCCCCCC3B892241333333D3684B5941333333337D892241000000C0734B5941333333330A8A2241333333D3804B5941000000009A8A2241666666C6904B594133333333CB8A2241333333F3964B59419A9999998B8C22419A9999B9BD4B594100000000E28D22419A999939DA4B59419A999999158E22419A999939E04B5941CDCCCCCC728E224100000040ED4B594166666666B48E2241000000E0F44B59419A9999998A902241666666C62F4C594166666666EE902241000000C03A4C59419A999999C6912241000000C0444C5941000000002C922241CDCCCC6C474C594100000000EC922241333333534A4C594100000000AA9322419A9999794C4C5941000000003794224133333353514C5941666666663A952241000000E0534C5941CDCCCCCC16952241666666A6604C5941000000001E952241333333D3734C5941000000004B95224133333313794C5941CDCCCCCC7B952241666666868B4C59413333333351962241000000C0854C5941CDCCCCCC45972241CDCCCCEC804C594133333333979722419A999939824C594133333333F098224166666606914C59419A99999999992241CDCCCCCC944C5941000000001F9A224100000060964C594133333333869A2241000000C0994C5941333333331F9B22419A999959A34C594100000000A29B2241333333B3A94C5941333333336B9C224100000080B54C594133333333F99C2241333333D3BF4C594133333333DF9D2241CDCCCC2C9C4C5941CDCCCCCCFF9D2241CDCCCC0C984C594133333333CD9E2241000000C0854C5941000000006D9F224133333353744C5941CDCCCCCCE09F2241666666E6654C594166666666C8A022419A9999D9454C5941333333332BA12241CDCCCCAC364C59410000000012A22241666666861B4C59413333333366A2224166666626064C59416666666668A32241CDCCCCECE94B59419A99999921A422419A999999DA4B59419A99999914A5224100000040CF4B59416666666659A522419A999999CB4B594133333333A9A52241333333F3C34B594133333333B3A52241CDCCCC8CBE4B594166666666C9A5224133333353A04B594100000000D7A52241333333B3924B5941CDCCCCCCEFA52241666666A6874B59419A999999E7A52241666666667D4B5941333333333EA62241333333537F4B594100000000B7A722419A999919864B5941CDCCCCCC86A822419A9999398A4B594133333333C5A822419A9999598A4B594100000000FFA8224100000080864B5941CDCCCCCC36AA2241333333F3684B59419A9999997AAA2241333333B3644B59419A999999C1AB22419A9999F9564B59419A999999F3AB2241333333D3554B5941CDCCCCCCC6AC224133333333564B59419A9999992DAD22419A9999D9514B5941666666667CAE2241666666863B4B59419A999999EEAE2241CDCCCC8C334B594166666666F9AE2241333333332B4B594133333333E4AE2241333333F31C4B59419A999999C6AE2241CDCCCC4C104B5941CDCCCCCCA5AE2241666666A6F84A5941CDCCCCCC69AE224133333393D64A5941000000004DAE224100000020C04A59416666666663AE22419A9999D9BF4A59410000000010AF2241333333F3AF4A59419A9999996DAF224166666646A64A59410000000095AF2241CDCCCC6CA04A59416666666602B02241CDCCCC8C8C4A5941CDCCCCCCBDB02241666666A66B4A5941CDCCCCCC1AB12241666666265D4A59419A9999996AB12241000000204E4A5941CDCCCCCC0AB222419A9999D9394A59419A999999CEB222419A9999D9294A594100000000C9B32241CDCCCC2C164A594166666666B0B42241CDCCCC0CFE495941666666662BB5224133333313F04959419A999999C2B52241333333D3DD4959419A9999991CB6224133333333D44959410000000093B622419A999979C349594133333333DEB62241CDCCCC4CBA4959416666666677B7224166666686B14959416666666649B8224166666606AC4959410000000077B92241CDCCCC4CA649594133333333CDB92241CDCCCC6CA5495941CDCCCCCC91BA224133333353A54959413333333303BB22419A999939A4495941333333331DBB22419A9999B9A24959419A9999995EBB2241666666A6A74959419A999999E2BB22419A9999D9A5495941CDCCCCCC4DBC2241CDCCCCECA04959419A99999919BD22419A9999199149594100000000A1BD224133333333844959419A999999E1BD2241000000607F495941666666661CBE2241CDCCCC2C79495941000000004CBE22416666664672495941CDCCCCCC71BE2241666666666A4959416666666642BF224100000000314959416666666696BE2241CDCCCCEC184959419A999999CBBD2241CDCCCC8C014959410000000064BD224100000040F448594100000000F0BC2241CDCCCC2CE14859419A9999997CBC2241CDCCCC6CCF485941000000001FBC2241CDCCCC0CC04859419A9999995BBB2241CDCCCCCCA24859419A9999997BBA2241CDCCCC8C7A4859416666666607BA22419A99997969485941000000002EB9224100000080534859419A99999903B92241666666E64F485941CDCCCCCCEFBA2241666666465548594133333333BDBB22419A9999D983475941CDCCCCCC08BD22419A9999D98C475941666666666BBD2241333333138F47594100000000CCBD2241333333B39447594166666666E4BE2241CDCCCCACA947594133333333A3BE22410000006083475941CDCCCCCC1DBE2241CDCCCC0C4F475941CDCCCCCC53BD22419A9999D9F5465941CDCCCCCC8EBD2241CDCCCCECF5465941CDCCCCCC85BE2241CDCCCCACF846594100000000EBBF2241CDCCCC6CD04659410000000044C02241333333D3C346594100000000FAC02241333333D39C46594166666666EFC02241CDCCCC2C95465941CDCCCCCCEEC022410000004085465941CDCCCCCC0AC12241333333B374465941CDCCCCCCDAC122419A9999D92E465941CDCCCCCCF3C122419A9999B923465941CDCCCCCCFAC12241000000E01A46594100000000ECC12241CDCCCCAC654559419A999999ECC12241CDCCCCAC5545594133333333E1C1224100000040E6445941CDCCCCCCDBC12241333333939A44594133333333D8C12241CDCCCC8C55445941CDCCCCCCD2C12241CDCCCC8C14445941666666664AC02241333333F3E5435941CDCCCCCC36C0224100000080E44359413333333370BF2241CDCCCC4CCB4359419A99999922B82241000000C0144359419A99999980B422419A9999F9BE425941666666665CB3224133333373B54259419A99999930B3224166666646B3425941666666660EB322419A999959AE425941CDCCCCCCD7B22241666666A6AF425941CDCCCCCC81B2224133333353AA4259410000000000B222419A999939AD4259416666666607B1224100000060AD4259410000000055B0224100000020AE4259416666666659B022419A999999A2425941CDCCCCCCA5AF2241000000E0A14259413333333395AF2241333333F3BA425941CDCCCCCC6AAF22419A999979CD4259419A99999939AF2241666666E6E7425941333333331FAF224133333373F2425941CDCCCCCCEDAE2241CDCCCC6CFF42594166666666BFAE2241333333730943594133333333ACAE2241666666260B4359413333333354AE2241CDCCCCCC0C43594166666666E5AD22419A9999B912435941CDCCCCCC8EAD22419A9999991B4359419A99999926AD224133333333294359419A99999932AD22419A9999392D43594133333333BCAC2241333333D3384359413333333393AC2241666666C63D4359410000000088AC224100000000424359413333333358AB2241666666A643435941000000005FAA2241666666664B435941CDCCCCCC42A822419A9999B9614359419A999999F1A72241000000405F435941000000009BA7224100000060614359416666666689A62241666666C674435941CDCCCCCCC09F22419A9999F9AC43594100000000319F224100000000C54359419A999999089F2241000000E0CC4359419A999999B79E2241333333F3E0435941CDCCCCCC169E22419A9999B9F84359419A999999D49D2241CDCCCCAC0644594166666666FF98224133333353654459416666666617942241CDCCCC8CCF44594100000000008F22419A999959DA445941666666666B8E224100000040DC44594166666666C28D2241CDCCCC4CDD4459419A9999997F8B22419A9999D9E244594133333333D188224166666606E9445941CDCCCCCCA586224166666646EE445941666666666D8622419A999979F14459419A99999956842241333333D33E4559419A999999DC822241000000C07545594166666666A7822241333333137D455941CDCCCCCC97802241CDCCCCACC945594133333333FC7E22419A99993905465941CDCCCCCC467E2241CDCCCCAC1E46594166666666FB7C2241333333D34E465941CDCCCCCCD07B2241666666467B4659419A9999991D7A224166666666B7465941CDCCCCCC25792241666666A6DC4659419A99999932782241CDCCCC6CFF465941000000007B772241666666861A47594100000000DB762241CDCCCCAC3047594133333333FD742241CDCCCC4C764759419A999999A5732241CDCCCCECA747594100000000B372224133333313CA4759419A999999D37122419A999999EA47594166666666A27122419A9999F9F047594166666666A27122419A9999F9F0475941	01010000206A08000036FF0F2657972241000000E0B9475941	360050000	Z	Ardentes	3600500	36005	36	24	63
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	01010000206A08000054000EB69FD421413333334381365941	360060000	Z	Argenton-sur-Creuse	3600600	36006	36	24	29
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	01010000206A080000EE17D7F57FCE2141666666563E5E5941	360070000	Z	Argy	3600700	36007	36	24	39
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	01060000206A08000001000000010300000001000000C5000000CDCCCCCCFC3A2141000000A0F95A5941CDCCCCCC3E3B214100000040FF5A5941CDCCCCCC653B2141333333B3045B59419A999999793B2141333333F30D5B594100000000A93B2141666666261D5B5941CDCCCCCC023C2141666666262A5B594100000000563C2141000000E02D5B5941CDCCCCCCCD3C21419A9999B92E5B5941CDCCCCCCEE3C214166666686315B594166666666123D21419A9999793C5B594100000000C43C2141CDCCCCCC4A5B5941000000007E3C214100000020535B59419A9999997B3C2141666666E6595B594133333333C9402141000000A0C95B594100000000A741214100000040E05B5941CDCCCCCC0B42214100000040E85B5941333333330E432141CDCCCCEC015C594100000000F7452141CDCCCC2C565C59410000000034462141333333535E5C59416666666663482141333333139B5C594166666666164E21419A999919F75C5941000000007A4E214100000080EF5C5941333333334C512141CDCCCC8CB45C59419A99999951522141CDCCCC0C9C5C5941CDCCCCCCE2552141CDCCCCEC4C5C59410000000010582141000000201B5C59419A999999F05B214133333313A45B594100000000BF5B2141333333339A5B5941CDCCCCCC355C2141333333738A5B5941666666662C5C2141666666867C5B59419A999999E85D21419A999999555B594133333333765E2141000000404D5B5941333333333B602141000000E0295B59419A999999D4602141000000C01E5B59410000000022622141666666A61B5B5941CDCCCCCC27622141333333F3205B59410000000063622141666666C62A5B594100000000616321419A9999391D5B594166666666BD632141CDCCCC6C1B5B59413333333323672141CDCCCCCC105B594166666666CD672141666666C6105B59413333333342682141333333D3135B594100000000A46921419A9999790C5B5941CDCCCCCC1F6A2141333333B30B5B594133333333D66A21419A999939095B5941CDCCCCCC046B21419A9999F9055B5941CDCCCCCC8D6B2141CDCCCCCC0E5B594100000000D96B2141CDCCCCEC185B594166666666416C2141666666660C5B594100000000A26C21419A999979FB5A594166666666F36C21419A999919F05A594100000000876D214133333373DF5A5941CDCCCCCCED6E21419A999959CC5A594166666666F96E21419A9999D9C85A59419A9999994871214133333313B95A59419A999999BB722141000000C0AE5A5941666666669772214100000060A65A5941666666664B722141CDCCCC6C915A5941666666661F722141CDCCCC6C885A5941666666666E712141000000004B5A594100000000597121419A999939405A5941CDCCCCCC4B712141000000C02F5A5941666666665D712141333333F3255A5941000000005F712141666666E6175A59410000000079712141CDCCCCCC005A59410000000072712141000000C0F55959419A99999916712141666666A6DC5959419A999999E670214166666646CD59594100000000B3702141CDCCCC6CB6595941CDCCCCCCA87021419A999939AC59594166666666AB7021419A999919A25959419A999999A2702141CDCCCCCC985959419A99999994702141000000E0955959419A999999D8702141333333B3885959419A9999992671214100000000805959419A9999999D7221419A9999796B59594133333333DC7221419A9999D9685959416666666640732141CDCCCC4C6659594166666666797521419A9999995A595941CDCCCCCCCF76214133333373515959413333333321772141666666864E595941333333336C7721419A9999794959594166666666877A2141333333B3FF58594100000000AB7A21419A9999F9FC58594166666666127B214133333373F8585941000000003E7B21419A999999F758594133333333D57A2141CDCCCCECD658594100000000F67A21419A9999B9C85859419A999999F97A2141666666C6B958594166666666E57A2141CDCCCC8CB158594166666666737A21419A999979A55859419A999999057A21419A9999F99C58594100000000B4792141CDCCCC8C9058594100000000817921413333339380585941333333335B792141666666266D5859413333333363792141CDCCCC4C6558594133333333F7782141000000A043585941CDCCCCCC42782141000000A0485859413333333334782141CDCCCC8C475859419A999999947721419A9999D94C585941333333335A762141333333D358585941CDCCCCCCAD752141666666265B58594100000000E47421419A9999D9595859419A999999767421419A9999D9555859419A99999909742141333333134F58594100000000DD722141CDCCCC6C2C58594133333333876F2141666666A61E5859419A999999F16E2141666666E61658594166666666476E21419A9999990858594100000000EC6D21419A99999901585941CDCCCCCC686D2141CDCCCC4C18585941666666668D6C2141000000803A58594133333333596C21413333337341585941CDCCCCCC8D6B2141CDCCCCEC3958594100000000436B21419A9999F93358594100000000EF6A21419A99995929585941CDCCCCCC1A6A214100000000185859419A999999D868214166666626365859413333333325672141CDCCCCAC26585941CDCCCCCC45652141333333531A58594100000000F86421419A9999B91658594100000000676421419A999939FC5759413333333363632141CDCCCC2CE35759419A99999905632141CDCCCC4CDC57594166666666E062214166666626E0575941CDCCCCCC78622141CDCCCC6CD3575941CDCCCCCC5E60214166666686E45759413333333322602141CDCCCCCCE6575941333333330D5F2141000000A0F55759419A9999998B5E2141CDCCCC4CF9575941000000002F5D21416666668605585941000000004B5C2141666666860E5859419A999999175A214166666666E95759419A999999C557214133333333C1575941000000006D5721419A999979BC5759410000000040572141CDCCCCECC9575941333333332957214100000080CD57594100000000A55621419A9999F9EC575941000000006B56214100000040F35759419A9999996956214100000060F55759419A99999901562141333333530C58594100000000955521413333335327585941000000007A552141000000002A58594100000000635521419A9999B93A585941333333335155214133333373425859419A9999993855214100000040475859419A99999908552141333333F34B585941CDCCCCCCE3542141333333535458594133333333BD5421419A9999595858594133333333825421419A9999396A5859419A99999953542141000000607A58594100000000455421413333337387585941CDCCCCCC1F542141000000A08C58594133333333C05321419A9999999D585941CDCCCCCCAD53214100000000A55859416666666697532141000000E0B6585941CDCCCCCC5853214100000000C3585941CDCCCCCC48532141333333F3CC58594166666666CF52214166666626DC58594100000000A752214133333313E9585941666666661A522141333333330259594100000000145221419A9999D9105959419A999999E4512141CDCCCC4C2159594166666666A2512141666666462E595941CDCCCCCC74512141000000A03C5959410000000047512141CDCCCC6C575959419A999999295121419A9999995F59594133333333145121419A99993969595941000000007A502141CDCCCCAC9C595941000000002E5021419A999939B259594166666666934F2141666666E6AA59594166666666AA4D2141CDCCCC0C935959419A999999634D2141CDCCCC0C8F59594166666666404D2141333333538A5959419A999999BB4A214133333333AA595941000000002E482141CDCCCCCCD1595941000000008647214166666666D3595941666666663E4521419A999999D75959419A99999902422141CDCCCCCCCF59594166666666BA41214166666626D05959410000000004412141000000A0CF5959419A999999AD3D21419A9999D9CB59594133333333883D2141CDCCCC0CDE5959419A999999493D214133333313EE595941CDCCCCCCD83C2141CDCCCCECFD5959419A999999953C214133333353025A5941666666662D3C2141666666061E5A5941333333330C3C2141CDCCCC8C2E5A594166666666CA3B21419A999919605A59419A999999C43B214133333393695A594166666666DE3B214100000080885A59419A999999E13B214133333393905A59419A999999F63B214133333353A35A594133333333B63B214166666626C75A594166666666443B21419A999959E05A5941CDCCCCCCFC3A2141000000A0F95A5941CDCCCCCCFC3A2141000000A0F95A5941	01010000206A080000CA265EF9B6562141000000B05A5A5941	360080000	Z	Arpheuilles	3600800	36008	36	24	22
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	01010000206A08000054EF2964A06022419A9999C93C435941	360090000	Z	Arthon	3600900	36009	36	24	48
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	01010000206A0800003863282D02E1204133333363BD545941	360100000	Z	Azay-le-Ferron	3601000	36010	36	24	61
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	01060000206A08000001000000010300000001000000E80000009A999999426522419A9999F976755941000000008D652241000000209A755941CDCCCCCCB565224166666666A875594166666666C665224166666606C3755941333333330C662241666666E6D4755941666666664A662241333333D3E17559419A9999997F66224166666606EF755941333333338866224166666686F67559419A999999816622419A9999191F7659419A999999FC6522419A9999D942765941CDCCCCCCD6652241CDCCCCAC4E765941CDCCCCCCC26522419A9999196E765941CDCCCCCCC9652241333333F37176594133333333486622419A9999199876594133333333736622419A9999F9A27659413333333374662241666666C6A7765941CDCCCCCC5D66224133333373BC7659416666666666662241CDCCCC4CC9765941333333337D662241000000A0DE765941CDCCCCCCAA662241666666E6ED7659419A9999990967224166666626FD7659416666666657672241000000200477594100000000F1672241CDCCCC4C1377594100000000E36822419A9999392A77594100000000AD692241CDCCCC4C4077594166666666FA6922413333331348775941666666661C6A22419A999979527759419A999999856A22419A99997961775941CDCCCCCC7D6B2241000000807377594133333333076C2241CDCCCC8C7E775941CDCCCCCC896C22419A9999F98B77594100000000B46C2241333333B39277594133333333D86C22419A9999599C775941333333338A6D22419A999959B177594100000000B56D224166666606B977594100000000F56D2241333333D3D1775941CDCCCCCC126E2241CDCCCCECD77759419A9999995E6E224133333393E2775941CDCCCCCCA26E224133333313F077594166666666B26E2241CDCCCC2CF577594133333333D66E2241666666C6087859419A999999056F2241000000401278594133333333F06F2241000000003178594166666666527022410000008038785941CDCCCCCC8A7022419A9999793B785941000000002471224166666646487859416666666653722241CDCCCC2C7D7859419A999999BC722241CDCCCCEC8F7859419A999999F8722241333333139C7859413333333323732241CDCCCCCCA1785941CDCCCCCC8F73224100000020AA78594100000000BC73224166666686A978594100000000EF7322419A999939AF7859416666666607742241CDCCCC4CB7785941666666661E742241333333F3C878594100000000A1742241666666E6E9785941CDCCCCCCF4742241000000E0FB785941666666666F752241000000001A79594133333333A67522419A9999B91A79594166666666AC752241CDCCCC0C317959419A999999ED752241CDCCCC2C2F795941CDCCCCCC13772241333333332E795941333333334077224100000040347959410000000085772241666666863A7959419A999999D1772241000000A03E7959416666666645782241666666664179594100000000F77922419A999959577959419A999999187A2241666666064A79594166666666487A22419A9999593D795941333333334C7A2241333333733579594166666666397A2241CDCCCC0C2A7959419A9999998D7A2241CDCCCC4C167959419A999999B67A2241333333331879594133333333AC7B2241333333532A79594100000000D87B2241CDCCCC0C2E79594100000000BF7C2241CDCCCCEC3C7959419A999999007D224166666646317959419A999999677D22419A9999B92679594133333333817D2241CDCCCC6C2579594166666666CE7D22419A9999B92579594133333333037E22419A99995929795941CDCCCCCCA07E2241CDCCCCCC2E7959419A999999267F22410000004032795941CDCCCCCC667F224133333373317959419A999999BA7F2241666666C63279594166666666EA7F2241333333533A795941CDCCCCCC018022419A9999394279594133333333318022419A9999594879594166666666618022419A9999D94A79594100000000C9802241333333334B795941666666660B812241CDCCCCCC4C7959413333333378812241333333735679594166666666B78122419A999999607959419A999999F7812241000000C067795941CDCCCCCCE7812241333333B36B79594166666666C0812241000000208D7959419A999999F68222419A9999B9A07959419A999999C184224133333333BE795941333333330C852241333333F3C6795941CDCCCCCCDF8522419A9999F9E17959419A99999942862241CDCCCCECFE7959419A9999991C8722419A9999191F7A59419A999999CA872241000000C0077A594166666666FE872241CDCCCC8CEA7959419A9999991A882241666666E6D5795941CDCCCCCC4588224133333313C5795941000000006E8822419A9999F9B17959410000000071882241333333739E7959419A99999969882241CDCCCC8C96795941CDCCCCCC85882241CDCCCCAC8479594133333333488822419A9999D97F795941333333336588224100000080697959419A99999969882241CDCCCCCC6179594133333333818822419A9999595179594166666666AD882241666666463E7959419A9999998A882241000000802D795941000000006F8822419A999999267959413333333394882241333333130D795941CDCCCCCCA288224100000000087959413333333301892241333333F3F2785941666666666C892241CDCCCC8CDD785941CDCCCCCC9989224100000020CF78594166666666C7892241666666A6CD78594166666666168A224166666686BB785941CDCCCCCC4E8A2241333333F3AA78594166666666828A2241000000409878594166666666888A2241000000E09278594133333333678A2241333333F3877859419A999999F68922416666662672785941000000008D892241000000C05878594166666666738922419A9999B950785941CDCCCCCC2E892241000000C03F785941CDCCCCCC5D892241666666663778594100000000A8892241000000C02E785941CDCCCCCCFB892241CDCCCC2C29785941CDCCCCCCCD8A22419A9999791F785941000000000F8B2241000000A01B785941333333336E8C2241333333B30278594133333333A38C2241666666A6FA77594133333333488D224166666626EF77594166666666FC8D2241333333B3DD7759419A999999BF8E224133333313CC775941CDCCCCCC278F224100000020C5775941CDCCCCCC3F90224133333333AE77594133333333C4912241000000205D77594133333333FC9222416666666623775941666666669C9322416666660609775941CDCCCCCC6094224100000000E276594133333333FD942241CDCCCC4CBC765941333333338495224100000020A076594166666666E19522419A9999798F7659413333333376962241000000407076594166666666BA9622419A9999D9627659410000000003972241000000C05876594166666666DB9622419A99997957765941CDCCCCCC93962241000000A04976594100000000D395224100000060297659419A9999991E952241CDCCCCEC087659416666666664942241333333F3EE755941666666664B942241CDCCCC2CE975594133333333029422419A999999DD75594133333333E6932241000000A0D6755941000000002193224166666626B5755941666666669E922241CDCCCCCCA2755941CDCCCCCC2F9222419A9999B9967559419A999999DC912241CDCCCCCC8A755941000000007C912241333333B37E75594133333333BD90224100000080737559410000000029902241CDCCCC4C69755941000000009B8E2241333333134B755941CDCCCCCCC68D2241000000203A755941CDCCCCCCA18D2241CDCCCC4C347559419A999999448D2241333333532B7559419A999999E38C2241000000C020755941666666663B8C2241CDCCCC8C0A75594100000000F48B2241CDCCCC2C04755941666666666C8B224100000080FC74594166666666448B2241CDCCCC0CF874594166666666158B2241CDCCCC2CEA74594100000000328B2241CDCCCC8CE4745941333333333F8B22419A999959DD745941CDCCCCCC1F8B2241CDCCCCECD7745941CDCCCCCCAB8A22419A999939CB745941666666667E8A2241CDCCCCECC374594166666666CF89224166666646C474594166666666A2892241000000A0C27459416666666669892241CDCCCCACBC7459419A999999288922419A999939B3745941CDCCCCCCED88224100000060A6745941333333334F8822419A9999F97D7459419A9999992C8822413333335378745941333333333A852241CDCCCC2C7474594133333333138522419A9999B97274594166666666F88422419A9999F96E74594133333333D8842241CDCCCC6C5C745941000000007C842241000000C04B7459419A9999997B842241333333D3457459410000000055842241666666263B7459419A9999992E84224133333393347459419A999999A7842241333333D32A7459413333333312852241CDCCCC6C1E74594133333333F2832241CDCCCC0CFE73594166666666838322419A999979FB7359419A99999956832241CDCCCC0CF973594133333333FC8122419A999939D673594100000000C28122419A9999F9CE735941CDCCCCCC8A7F22419A9999F97F73594166666666F57E2241CDCCCC8C6C73594100000000597E2241333333F35973594166666666EB7D2241CDCCCCAC5E7359419A999999D97B2241333333D36E7359419A999999577622419A9999B99673594100000000277522419A9999B9A1735941CDCCCCCCD57422419A999979A673594133333333496F22419A999999DC7359419A999999C06D2241000000C04E7459419A999999B26B2241666666C6E9745941CDCCCCCCA26A22419A999979F47459419A999999E2692241666666C6FD74594166666666D4692241CDCCCC8CFF74594133333333D8692241666666660675594133333333F2692241666666C61175594166666666E5692241666666C61675594133333333B4692241333333F31975594166666666BC6822413333337325755941CDCCCCCCE46722419A99999930755941CDCCCCCC5C672241333333D335755941CDCCCCCCC06622419A9999193E755941333333338C662241666666C643755941333333334A6622419A9999D94E7559419A999999426522419A9999F9767559419A999999426522419A9999F976755941	01010000206A080000FCBAD0ADA17D2241000000E0C2765941	360110000	Z	Bagneux	3601100	36011	36	24	25
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	01010000206A080000A7BAE84B34FF21419A999989B92C5941	360120000	Z	Baraize	3601200	36012	36	24	16
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	01010000206A0800002EAE10B55A0B2241333333E3936A5941	360130000	Z	Baudres	3601300	36013	36	24	28
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	01010000206A08000013FDF55492E921419A999979E72C5941	360140000	Z	Bazaiges	3601400	36014	36	24	19
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	01010000206A0800007ACA46F3F95E2141666666E68C225941	360150000	Z	Beaulieu	3601500	36015	36	24	8
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	01010000206A08000007060606F60B2141343333D360345941	360160000	Z	Bélâbre	3601600	36016	36	24	41
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	01010000206A080000960976341C292341666666766F435941	360170000	Z	La Berthenoux	3601700	36017	36	24	40
01060000206A080000010000000103000000010000007E0400003333333334BA2041000000808C3B59413333333334BA2041000000E0913B5941000000003EBA2041333333D3963B5941666666664EBA2041CDCCCC8C9B3B59410000000064BA2041CDCCCC4CA13B59419A9999997EBA2041666666A6A73B59419A99999991BA20419A9999B9AC3B59419A9999999CBA204100000000B03B5941CDCCCCCCA1BA2041CDCCCC0CB23B594100000000A3BA204133333353B43B59419A99999901BB2041CDCCCC4CBA3B5941333333336ABB2041666666A6C03B5941CDCCCCCC87BB204100000080C23B59419A99999975BB20419A9999D9CE3B59416666666671BB2041CDCCCCCCF73B59416666666676BB2041333333D3063C594100000000A8BB2041666666C60A3C594166666666A5BB20419A999999123C59419A99999994BB20419A9999B9183C59419A9999998DBB204133333353243C59419A99999982BB2041333333732E3C59413333333355BB2041333333B3583C59419A999999BDBB2041333333F35D3C59416666666661BC20419A999959663C594100000000A9BC2041666666466B3C59413333333333BD204100000060733C59419A99999966BD204100000080763C59419A999999C7BD20419A9999B97B3C59410000000093BE2041CDCCCCEC863C5941333333336ABF2041CDCCCCEC903C594133333333A3BF204133333313943C594100000000E1BF20419A999999963C594166666666F6BF2041CDCCCC0C983C59416666666618C02041333333939A3C5941CDCCCCCC34C02041000000A09C3C59410000000058C020419A9999399E3C59419A9999999BC020419A999979A13C59419A999999F6C02041CDCCCCCCA53C59419A99999949C120419A999959AA3C5941CDCCCCCC96C1204133333393AE3C59419A999999F2C12041666666C6B33C59416666666633C2204100000020B83C59416666666669C22041CDCCCC0CBC3C594166666666BEC22041666666A6C03C5941666666661AC3204133333393C53C59413333333380C32041CDCCCCECCA3C594100000000E9C3204133333353D03C59410000000037C42041CDCCCC4CD43C5941000000007EC42041000000A0D73C594100000000BAC4204133333353DA3C5941000000009AC420419A9999D9DB3C5941666666666DC4204166666606DE3C594166666666ECC22041000000A0F43C59419A999999A6C22041CDCCCCCC0F3D5941CDCCCCCC96C22041666666C6153D59419A9999998DC220419A9999191C3D59413333333384C220419A9999D9233D5941333333337FC22041CDCCCCAC273D59413333333379C22041000000802D3D59419A99999974C22041CDCCCC6C333D59410000000072C220419A9999F9363D59419A9999996EC22041333333333C3D59419A9999996DC2204133333393423D5941CDCCCCCC6CC22041CDCCCC4C483D59410000000069C22041CDCCCC8C4E3D59416666666665C22041CDCCCC6C553D59416666666661C22041666666665C3D59419A9999995BC22041000000A0653D59413333333356C22041000000A06E3D5941CDCCCCCC53C2204166666666763D5941CDCCCCCC93C220419A999959753D5941CDCCCCCCC8C2204166666686743D59419A999999F0C22041000000E0733D59413333333312C32041666666E6733D59416666666632C3204100000060743D59419A9999995DC3204133333353753D59416666666689C32041CDCCCCAC763D594133333333B9C320419A9999D9773D594133333333E0C32041CDCCCCEC783D59419A99999908C42041666666C6793D59413333333325C42041CDCCCC2C7A3D59413333333349C42041333333537A3D5941CDCCCCCC6AC42041CDCCCC2C7A3D594166666666C2C420419A999999773D5941CDCCCCCC2CC5204100000020733D59410000000088C52041333333336F3D594133333333C0C52041333333F36C3D59419A999999F7C52041000000606B3D59416666666658C62041CDCCCC0C693D59419A9999999EC62041CDCCCC4C673D5941CDCCCCCCCDC6204166666626663D594100000000E9C620419A9999B9653D5941CDCCCCCC09C720419A9999D9653D5941000000002EC7204166666686663D59419A99999954C7204100000040683D5941000000008DC72041666666C66A3D594166666666B8C720419A9999796C3D59419A999999DBC720419A9999596D3D59410000000007C82041CDCCCCCC6D3D59416666666637C82041333333B36D3D5941CDCCCCCC68C82041333333936D3D594166666666AEC82041666666466D3D594100000000E4C82041666666266D3D5941000000001EC92041CDCCCCEC6C3D5941CDCCCCCC34C920419A9999D96C3D59410000000044C9204100000040753D59416666666650C920419A9999197D3D5941333333335DC920419A9999B9863D5941CDCCCCCC6BC92041CDCCCC8C913D59416666666678C92041333333539C3D59413333333387C9204133333373A63D59410000000097C9204100000060AD3D5941CDCCCCCCA5C92041CDCCCCACB33D5941CDCCCCCCB9C9204166666626B93D5941CDCCCCCCD8C92041000000C0BE3D5941CDCCCCCCFAC920419A999979C53D5941CDCCCCCC1DCA204133333373CC3D59416666666644CA2041000000C0D33D59419A99999969CA204133333333DA3D5941CDCCCCCC8ACA2041333333D3DF3D5941CDCCCCCCA6CA204100000080E33D594133333333C5CA20419A9999F9E63D594166666666EBCA204100000060EC3D59416666666619CB20419A999979F23D59413333333340CB2041CDCCCC2CF73D59419A99999964CB2041666666E6FA3D59410000000088CB204166666666FE3D5941CDCCCCCCB7CB204166666626033E594133333333F0CB2041000000E0083E59419A9999991FCC2041333333730D3E59419A9999995CCC20419A9999F9053E5941CDCCCCCC99CC204100000060FE3D5941CDCCCCCCD4CC204133333333093E59419A99999906CD2041CDCCCCAC113E5941CDCCCCCC0ECD204133333333133E59416666666631CD2041CDCCCCAC193E5941333333334ECD2041000000C01E3E5941CDCCCCCC55CD2041CDCCCC2C203E59413333333354CD204166666646213E5941CDCCCCCC4ECD2041CDCCCC8C223E59419A9999994ECD20419A9999B9233E59410000000053CD2041666666C6243E5941CDCCCCCC60CD20419A999979273E5941666666667ACD2041000000002C3E5941CDCCCCCC8ECD2041666666C62F3E5941CDCCCCCCA7CD204133333353343E594100000000C2CD2041000000603A3E594166666666D9CD204166666606403E5941CDCCCCCCEECD2041CDCCCC0C453E59410000000006CE2041666666464A3E59419A99999922CE2041333333B3503E5941000000003ECE204133333353573E59419A99999952CE20419A9999D95C3E59416666666664CE2041666666A6623E5941CDCCCCCC72CE2041CDCCCCEC673E5941333333337ACE20419A9999596B3E59419A99999979CE2041000000806D3E59410000000081CE2041CDCCCC6C6E3E59416666666693CE2041CDCCCCCC703E59419A999999A4CE20419A999999713E594166666666BBCE204166666606713E594166666666D2CE20419A9999796F3E594166666666E8CE2041000000A06D3E594133333333FDCE2041333333936C3E5941CDCCCCCC18CF2041333333536C3E59416666666634CF2041666666C66C3E59416666666649CF2041000000C06C3E5941666666665ECF2041CDCCCC8C6C3E5941333333336DCF20419A9999996C3E5941CDCCCCCC77CF2041CDCCCCAC6D3E59413333333385CF20419A999919703E5941000000008FCF2041666666E6713E5941000000009CCF2041CDCCCCAC723E5941CDCCCCCCA2CF2041666666C6733E594166666666A4CF20419A9999B9743E59410000000045D0204133333333883E5941666666662AD0204166666686923E59419A99999914D02041CDCCCC0C9D3E594100000000D7CF2041CDCCCC4CA73E594133333333AACF204100000080AE3E59419A9999995BCF204100000080B73E5941CDCCCCCC16CF20419A999979BF3E594166666666D3CE204100000020C53E594133333333A0CE20419A9999D9C93E59419A99999936CE2041666666C6CB3E5941333333332ECE2041CDCCCCECCB3E59413333333327CE20419A9999D9DB3E59419A9999992ACE204100000060DF3E59410000000036CE2041CDCCCC8CEB3E59410000000042CE204100000060F13E59416666666651CE2041000000E0F53E5941CDCCCCCC64CE20419A999979F93E59419A9999997BCE204166666686FB3E59410000000097CE20419A999919FD3E5941CDCCCCCCC1CE2041CDCCCC0CFF3E594133333333F4CE20419A999979013F59419A9999991FCF204100000060043F59410000000045CF20419A999999073F5941CDCCCCCC6ECF2041000000600B3F59413333333398CF2041CDCCCC2C0F3F5941CDCCCCCCC0CF2041666666A6123F59419A999999ECCF20419A9999D9163F59413333333316D02041000000601B3F5941CDCCCCCC38D020419A9999D91F3F59416666666662D0204166666626253F5941CDCCCCCC88D020419A9999992A3F594166666666AAD02041666666A62F3F5941CDCCCCCCD0D02041000000A0353F594100000000F4D020419A9999F93A3F5941000000000CD120419A9999993E3F5941CDCCCCCC16D1204133333333403F59419A99999923D12041000000C0413F5941333333331FD1204100000060443F5941CDCCCCCC21D12041000000A0463F5941CDCCCCCC28D12041CDCCCC4C493F5941CDCCCCCC3BD12041000000E04F3F59416666666649D1204100000020553F59419A9999995DD12041000000005C3F59419A9999996ED12041CDCCCCAC623F59419A9999997DD1204133333313683F59416666666689D12041000000806C3F5941333333333BD2204133333313AE3F59419A9999992FD320419A9999B9DC3F5941CDCCCCCC46D3204166666666E13F5941CDCCCCCC5CD320419A999979E63F59419A9999997CD3204133333393ED3F59416666666697D320419A999919F43F5941CDCCCCCCB2D320419A999999FA3F594100000000D1D320413333337301405941CDCCCCCCEED32041333333B307405941666666660CD42041333333130E405941333333331AD420410000008011405941CDCCCCCC21D420416666668612405941666666662DD4204100000000144059419A99999931D420410000004016405941CDCCCCCC3BD42041666666E619405941666666664ED42041CDCCCC4C1F4059419A9999995BD420413333337322405941000000006CD42041333333B325405941CDCCCCCC82D42041CDCCCC0C2A4059419A9999999FD42041666666262E405941CDCCCCCCBED42041666666E63140594166666666E5D420413333333336405941333333330AD52041333333F3394059419A9999992BD52041666666063E405941000000004DD520413333331342405941CDCCCCCC7AD520413333335347405941333333339BD52041333333F34A40594100000000BCD520419A9999194F40594166666666DAD52041333333535240594100000000F1D520416666666654405941000000000CD62041CDCCCC4C56405941000000002AD62041CDCCCCCC574059419A99999942D62041000000C058405941CDCCCCCC6ED62041333333135A405941333333339FD62041CDCCCCAC5B40594166666666D1D62041000000805D4059410000000000D72041333333B35F4059416666666630D720419A9999B9624059416666666665D720410000000066405941333333339BD72041666666E66840594166666666D0D720419A9999996B4059413333333303D82041666666666D4059419A9999991CD82041CDCCCCEC6D4059419A99999934D82041666666066E4059416666666650D82041666666666D405941CDCCCCCC66D82041666666266D405941CDCCCCCC80D82041000000806D405941CDCCCCCCA0D820419A9999B96E40594100000000C7D820419A9999397040594133333333D7D82041000000C0704059419A999999EAD820419A9999B970405941CDCCCCCC02D92041CDCCCCEC6F405941666666661BD920419A9999B96E4059419A99999935D92041666666866C4059416666666653D920419A9999D969405941666666665ED92041CDCCCCEC68405941000000006FD920413333333368405941000000007ED92041CDCCCC2C684059413333333395D92041666666266940594166666666AED92041666666866A40594133333333BED92041CDCCCC4C6C40594166666666C8D92041000000E06B4059419A999999D3D920419A9999B96B40594100000000DBD92041333333136B40594100000000E8D920419A9999396C40594166666666F8D920419A9999596C405941000000000FDA2041666666266C405941000000002ADA2041333333136B4059419A9999994DDA2041CDCCCC6C69405941CDCCCCCC73DA2041333333F3674059419A99999995DA2041333333B3664059419A999999B3DA2041CDCCCC2C66405941CDCCCCCCCEDA20419A9999196640594100000000F0DA2041CDCCCC4C664059410000000004DB204100000040664059419A99999917DB204133333333654059419A99999931DB2041CDCCCC0C63405941666666664BDB20410000006060405941CDCCCCCC81DB2041CDCCCC6C5A40594100000000B2DB20419A9999195540594166666666DEDB20419A999959504059410000000005DC2041000000804C4059410000000024DC2041333333D3494059413333333351DC20419A999919464059416666666697DC2041666666C64040594100000000D3DC2041000000603C4059416666666614DD20419A99997937405941CDCCCCCC74DD2041000000E02F40594100000000A6DD2041CDCCCC0C2B405941CDCCCCCCD2DD2041666666462740594166666666F8DD20419A999919244059419A99999916DE2041CDCCCCCC21405941CDCCCCCC34DE204133333353204059416666666666DE2041000000201E40594133333333C0DE2041333333131A405941000000000EDF2041CDCCCC0C16405941000000005EDF2041333333531140594133333333B9DF20419A9999190C405941000000000BE020419A99999907405941CDCCCCCC54E02041666666C6034059410000000095E02041CDCCCCCC0040594133333333E4E02041CDCCCC0CFE3F59413333333332E1204166666626FB3F59416666666671E120419A999959F93F59410000000091E12041CDCCCC6CF83F594166666666ABE1204133333373F73F5941CDCCCCCCB8E1204100000040F63F5941CDCCCCCCC6E120419A9999F9F33F59419A999999D4E120419A999959F03F59419A999999E0E1204166666666EC3F594100000000EFE12041CDCCCCCCE93F5941000000001FE22041CDCCCC6CE83F59413333333347E22041CDCCCCCCE63F59419A9999996DE22041CDCCCC8CE53F59413333333388E2204166666626E53F5941CDCCCCCCA4E22041333333F3E43F594166666666CFE2204100000080E43F594166666666FAE22041666666E6E43F59419A99999919E32041000000A0E43F5941CDCCCCCC3EE32041CDCCCC6CE43F5941000000005AE320419A9999F9E33F5941000000007AE32041666666A6E23F59416666666698E320419A999959E13F594100000000BEE3204133333393DF3F59419A999999E3E320419A9999B9DE3F59413333333313E4204166666686DE3F59413333333345E4204133333333DF3F59410000000072E4204133333373DF3F59413333333391E4204100000080DF3F594100000000ADE4204166666646DF3F59419A999999C3E4204133333373DE3F5941CDCCCCCCE3E4204100000020DD3F59410000000008E5204100000080DA3F59419A99999921E520419A9999F9D73F5941CDCCCCCC3FE52041000000E0D43F59410000000075E52041333333F3D03F594133333333BFE520419A999919CC3F594166666666FFE52041666666E6C73F59413333333339E6204133333333C43F5941CDCCCCCC58E62041666666E6C13F5941666666668BE620419A9999B9C83F59419A999999BBE62041666666E6CF3F594166666666E5E6204133333333D63F594133333333FAE6204100000060D93F59410000000003E72041000000E0DA3F5941CDCCCCCC26E72041000000A0E13F59410000000049E72041333333F3E83F59416666666666E72041666666C6EF3F59419A99999982E72041CDCCCC8CF73F59413333333398E7204166666686FE3F594166666666A9E720416666662604405941CDCCCCCCBAE72041000000000B40594100000000CEE72041000000800D40594133333333E8E72041CDCCCCEC104059419A99999905E82041000000C015405941CDCCCCCC1FE82041333333531B4059419A99999945E8204100000000234059410000000066E82041333333D3294059410000000084E8204166666686304059413333333395E82041CDCCCC0C3440594133333333A4E8204133333393364059419A999999AFE82041333333D337405941CDCCCCCC3FE920419A9999D94540594133333333A8E92041000000E04F40594133333333C3E920419A999999524059416666666615EA2041CDCCCCEC59405941666666666CEA2041666666866140594166666666A5EA2041333333D366405941CDCCCCCCC1EA2041000000206940594133333333D8EA2041333333136A4059410000000034EB2041333333336F405941333333338BEB2041000000C07440594133333333D6EB20419A9999797940594133333333FFEB2041CDCCCC8C7C405941000000003AEC2041CDCCCC2C814059419A99999964EC204100000020844059419A99999985EC2041000000C08440594166666666ACEC204100000020864059419A999999CDEC204166666646894059419A999999EBEC2041666666268D405941CDCCCCCCF6EC2041000000808F4059410000000032ED20413333335399405941333333333BED2041666666C69A4059413333333349ED2041666666C69B4059416666666666ED2041666666469D40594166666666E7ED20419A999919A44059410000000039EE204100000080A84059416666666690EE2041666666A6AC40594166666666CEEE2041CDCCCCECAF40594166666666EDEE204166666686B14059413333333302EF2041666666C6B2405941333333330EEF2041333333B3B3405941666666662CEF204166666646B7405941333333338DEF2041CDCCCCECC140594166666666CAEF20419A9999B9C8405941CDCCCCCCE4EF204133333313CB405941CDCCCCCCFBEF204166666666CC4059410000000011F0204100000000CE405941CDCCCCCC15F0204133333353CE4059419A9999993EF020419A999979D1405941666666666CF0204166666666D5405941CDCCCCCC95F020419A999959DA4059419A999999C7F0204166666646E040594166666666E0F0204133333393E3405941CDCCCCCC11F120419A999979E8405941000000003AF1204100000020EC405941CDCCCCCC60F1204100000000F140594133333333B1F12041666666E6FC40594100000000ECF12041333333B305415941000000000AF22041000000C0094159419A99999926F22041333333530D415941CDCCCCCC8FF22041000000C01941594133333333EFF220419A9999B9244159419A99999955F320419A9999D92F41594100000000A0F32041666666A63741594133333333E2F32041666666463F415941000000008AF42041CDCCCCCC4A4159419A9999992AF52041000000E0554159419A999999F3F5204166666646654159416666666681F620419A9999D970415941CDCCCCCCDAF62041666666C65D415941CDCCCCCC16F72041CDCCCCAC50415941000000003CF720419A9999D9484159419A99999956F7204133333313444159413333333376F72041000000C03F415941333333339FF72041CDCCCC8C3B415941CDCCCCCCBDF72041666666C6384159419A999999E2F7204133333373364159419A99999933F8204100000060314159419A9999999EF820419A9999992A415941CDCCCCCC0AF920413333339323415941000000006AF92041CDCCCCAC1D41594166666666F7F92041000000E01441594133333333C5FA2041CDCCCC8C074159410000000081FB204133333373FB4059419A999999CDFB20419A999999F6405941CDCCCCCC2BFC204133333353054159419A99999982FE2041CDCCCCEC3C4159413333333399FE2041666666A63C415941CDCCCCCCADFE2041CDCCCC0C3B415941CDCCCCCCE9FE2041000000A0354159410000000055FF2041666666662C41594100000000D1FF2041000000C02141594166666666590021419A99991916415941CDCCCCCCBF0021419A9999B90D41594100000000C1032141666666263F4159419A999999B2032141666666C6464159410000000012042141CDCCCCEC4A415941000000008B042141666666064E415941666666668F042141333333B34E4159419A999999FE062141666666C68A415941333333330708214100000020844159416666666601092141CDCCCC0C7F41594100000000640A2141CDCCCC2C9941594133333333BD0A2141000000A09F41594133333333030B2141000000A0A4415941666666661D0B21419A999999A641594133333333250B2141CDCCCCCCA7415941666666663D0C214133333333BB41594166666666A10C2141CDCCCC4CAC41594133333333F80C21419A9999599F41594133333333710D21419A9999B9A2415941CDCCCCCCB80D21419A999979954159419A999999D90D2141CDCCCC2C8E415941CDCCCCCC580E2141333333736F415941CDCCCCCC8F0E2141333333536841594133333333450F2141333333137841594166666666CB0F2141000000A083415941CDCCCCCCCF102141333333139E415941CDCCCCCCFF112141000000A0BA41594100000000B9112141666666C6C94159419A99999951122141666666E6DB41594133333333DF122141333333D3EC41594100000000261321419A999939F5415941CDCCCCCC9B132141666666A6E34159410000000066172141000000602441594166666666A4182141CDCCCC2CE4405941CDCCCCCC231B21410000008062405941CDCCCCCC291B21419A9999395F405941333333331F1B2141CDCCCC4C5D40594133333333DD1A2141333333D356405941CDCCCCCC791A21419A9999194D40594100000000211A21419A9999194540594166666666E2192141333333533E405941CDCCCCCC91192141CDCCCC6C36405941333333332B1921419A9999592B40594100000000D01821419A99991921405941000000006918214166666666164059410000000049182141333333F3124059419A999999EB17214133333393084059419A999999A617214133333313014059419A99999948172141333333B3F63F5941666666661317214166666646F13F59419A999999041721419A9999F9EF3F594166666666DC1621419A999939ED3F594166666666971621419A999919E83F5941333333332916214133333313E03F59416666666690152141666666A6D43F594166666666221521419A9999B9CC3F594166666666E914214100000080C93F59419A999999D414214133333393C63F594133333333C51421419A999959C33F594100000000BD14214166666666C13F594100000000B2142141CDCCCC4CBE3F5941CDCCCCCC4C1421419A9999D9C93F594100000000311421419A999959CA3F5941CDCCCCCC1614214166666646CA3F59419A999999F313214100000040C83F59419A999999D9132141333333B3C33F5941666666669E132141CDCCCC2CB73F5941000000005A132141CDCCCC8CA53F5941CDCCCCCC49132141CDCCCC4CA53F594166666666D9122141666666A6A33F5941CDCCCCCC72122141CDCCCCECA13F59410000000071122141CDCCCC2C9A3F59416666666692122141666666A67A3F59416666666683122141000000E0773F59413333333356122141000000E06B3F5941333333330C122141666666465B3F594133333333C2112141CDCCCCEC4B3F594133333333A211214166666626453F59413333333382112141666666C63B3F5941CDCCCCCC2F1121419A9999F9273F594166666666FE102141333333531C3F594166666666BC102141666666060D3F5941000000008B10214133333333013F5941CDCCCCCC7E102141000000E0FD3E594100000000711021419A999939FB3E59410000000035102141000000E0F13E594100000000021021419A9999F9E93E594133333333E40F2141CDCCCC2CE63E5941CDCCCCCCAD0F2141CDCCCCCCDF3E5941666666668B0F21419A999939DC3E594166666666580F21419A999959D53E594166666666310F2141CDCCCC0CCF3E5941333333330E0F21419A9999D9C73E59419A999999E50E214166666626C33E5941CDCCCCCCB40E21419A9999D9BE3E5941666666666C0E21419A999919B93E594166666666560E214166666666B63E5941CDCCCCCC410E2141333333F3B33E594133333333230E2141CDCCCCECAD3E594133333333010E2141333333B3A63E59419A999999EB0D2141333333F3A03E594100000000D90D21419A9999999A3E594100000000C10D2141333333B3903E594133333333A50D214166666646853E59419A999999980D214133333353813E5941666666666F0D2141CDCCCC0C783E5941000000004D0D2141000000606E3E5941000000002B0D21419A999979663E594133333333FE0C21419A9999D95B3E594166666666DA0C214166666606533E594100000000090D21419A9999794C3E594133333333230D214133333333493E594133333333540D2141CDCCCC2C433E5941333333338D0D2141000000E0373E594133333333B80D214166666666253E59419A999999C50D2141666666461E3E59419A999999CF0D21419A9999D9193E594133333333DD0D2141CDCCCC8C143E59419A999999F20D21419A9999990F3E594100000000070E21419A9999F90B3E5941CDCCCCCC360E2141000000A0053E594100000000660E21419A999999FF3D5941666666665F0E2141666666C6FC3D5941000000004E0E214100000060F53D59419A9999993A0E21419A999939EE3D594100000000270E214166666686EA3D5941CDCCCCCC060E2141000000E0E43D594133333333F60D2141000000C0E13D59419A999999E50D2141666666C6DD3D59419A999999D30D214100000080D83D59419A999999C10D214133333313D13D5941CDCCCCCCB40D214133333313CB3D5941666666669F0D21419A999919C53D5941CDCCCCCC920D2141333333D3C13D594166666666720D214166666666BA3D594100000000510D2141666666E6B33D594166666666300D214100000080AE3D5941333333331F0D21419A9999B9AB3D5941666666660B0D214133333373A93D594133333333EC0C214133333393A63D594100000000B90C214133333373A23D5941CDCCCCCC920C2141666666069F3D5941CDCCCCCC6C0C2141333333D3993D59419A999999450C21419A999959943D594166666666FE0B21419A999939893D59419A999999C50B2141CDCCCCAC803D594166666666A80B2141666666667C3D5941000000009C0B2141333333537B3D594166666666970B21419A9999597B3D5941CDCCCCCC8D0B2141666666E6743D5941CDCCCCCC8A0B2141CDCCCC0C723D5941CDCCCCCCAC0B2141CDCCCC4C703D594166666666E40B21419A9999196D3D594133333333220C2141CDCCCC0C693D594166666666750C2141666666C6613D5941333333334A0C2141000000A0513D59419A9999992B0C214133333313473D59419A999999220C2141333333D3413D5941666666661D0C2141000000403E3D59419A9999991F0C2141CDCCCCAC3A3D5941CDCCCCCC2D0C2141CDCCCC2C373D5941CDCCCCCC440C214133333333343D5941000000006B0C2141CDCCCCCC2E3D594133333333BB0C21419A9999B9243D594133333333AD0C214133333393093D594133333333A40C2141333333B3093D59419A999999880C2141666666660A3D594133333333740C21419A9999790B3D594166666666730C2141CDCCCC0CF83C594100000000AF0C214100000000F33C5941CDCCCCCCAE0C214100000080F03C59419A999999830C21419A9999D9D83C5941CDCCCCCC820C214100000060D63C5941CDCCCCCC7E0C214166666606D13C594100000000790C21419A999919CC3C594133333333770C21419A9999F9C73C5941666666667B0C214100000020BF3C5941CDCCCCCC810C21419A999979B23C594100000000860C2141666666C6A83C5941CDCCCCCC970C2141333333D3A53C594166666666970C21419A9999B99F3C594133333333430C2141333333339D3C594100000000190C21419A9999B99B3C594100000000E10B2141CDCCCC0C983C594100000000A60B2141000000A0933C59419A9999997A0B2141666666868D3C5941333333335F0B21419A999939873C59419A999999410B2141333333137E3C594133333333F60A214133333313823C594133333333B6092141000000E0903C5941000000002A09214100000000913C5941666666666D082141666666868F3C594133333333B8072141333333D3893C5941333333339C062141666666A6823C59419A999999D3052141000000807F3C59419A99999989052141CDCCCCAC813C59419A999999090521419A9999F9873C59419A999999CE042141333333F37B3C59419A9999990E042141CDCCCCAC5B3C59419A99999901042141CDCCCC0C4F3C594166666666E70321419A9999594F3C59419A99999985032141000000004F3C5941CDCCCCCC16032141000000A04E3C5941CDCCCCCCDF022141000000004E3C594133333333CD022141CDCCCCAC4D3C5941666666669F0221419A9999394C3C5941666666663C022141666666E6483C59419A999999F101214133333373463C594133333333CA01214133333373453C594133333333B9012141333333F3443C5941CDCCCCCC9101214100000060443C5941333333334401214133333333433C594133333333CF002141666666E6413C5941CDCCCCCC910021419A9999F9403C5941CDCCCCCC9E0021419A9999F9373C5941CDCCCCCCA90021419A9999B92E3C59419A999999B200214100000000283C594100000000BB002141CDCCCCCC203C59419A999999C40021419A9999191D3C594133333333D3002141000000E0193C594100000000FA002141CDCCCCEC123C5941CDCCCCCC20012141666666C60B3C594133333333480121419A9999D9053C5941333333337C01214166666686FD3B5941333333339F0121419A999959F83B5941CDCCCCCCD60121419A999919F13B594166666666320221419A999999E63B5941CDCCCCCC7A02214100000000E03B59419A9999999F02214166666626D93B594166666666B7022141CDCCCC6CD23B594166666666C3022141CDCCCC2CCD3B594133333333C9022141666666A6C43B594133333333CA0221419A999979B43B594133333333C7022141333333D3A73B594166666666CC0221419A9999F9963B594166666666D80221419A9999F98D3B59419A999999EC022141000000C0853B5941CDCCCCCC2403214133333313713B594100000000FB012141666666A6653B594100000000ADFE2041CDCCCCCC563B59416666666665FD204100000060563B59413333333389FC2041000000605C3B59419A999999F8FB204100000000623B594133333333DFFB204166666646583B594100000000C0FB2041CDCCCC8C4C3B59419A999999B9FB204133333353443B594166666666CFFB204166666646343B594166666666E0FB2041333333B3223B594133333333E7FB20419A9999B91F3B594100000000EBFB2041000000401D3B594166666666EBFB2041333333F31B3B594166666666E7FB2041CDCCCCAC1A3B594166666666E2FB2041000000A0193B594166666666DDFB2041000000E0183B5941CDCCCCCCE7FB204100000040173B59419A9999990DFC2041CDCCCCEC103B59416666666641FC2041666666E6073B59416666666677FC204100000000FF3A5941CDCCCCCCA6FC204100000060F63A594166666666E2FC204100000060EE3A59413333333307FD20419A999939EA3A5941000000004FFD2041333333D3E23A59416666666698FD204100000040DC3A5941333333339EFD2041CDCCCCACDB3A59419A999999D3FD204100000060D63A594166666666FAFD20419A999979D23A59413333333371FE2041666666C6C63A594166666666E0FE20419A9999B9BB3A59419A99999932FF204100000000B23A5941666666666FFF2041CDCCCCCCA73A594133333333AEFF204100000040993A594133333333CEFF2041666666E68D3A59419A999999D1FF20419A9999B98C3A59416666666607002141000000E0793A5941000000004000214166666666653A5941666666667800214133333353513A594100000000A4002141666666C6413A5941CDCCCCCCD200214133333333323A59413333333301012141333333B3243A594133333333570121419A9999190D3A5941000000009E01214166666666FA39594133333333EA012141CDCCCCCCE53959413333333324022141000000C0D5395941000000005C02214133333373C73959410000000096022141000000E0B939594166666666D102214166666606AF395941000000000503214166666606A63959416666666667032141666666E694395941CDCCCCCC1C032141333333938E395941CDCCCCCCBF022141000000C086395941666666665B022141000000A07E395941CDCCCCCCE4012141333333B3743959419A99999971012141666666266B3959410000000006012141CDCCCC2C62395941666666668E002141666666465839594166666666170021419A9999794E39594166666666A3FF2041666666C6443959410000000013FF2041000000A0383959419A9999990CFF20419A9999993A3959413333333309FF2041000000403F3959413333333306FF20410000002043395941CDCCCCCCFFFE20419A9999F94A395941333333335CFC20419A999999483959416666666632FC2041666666A64A39594133333333F7FB20419A9999194E39594166666666C2FB20410000002051395941CDCCCCCCA5FB2041CDCCCCAC52395941666666668EFB20419A99999954395941333333334DFB2041000000805C3959419A9999992DFB20419A9999B9603959419A999999F8FA20419A9999996739594100000000C8FA20419A9999D96C39594133333333A0FA2041666666A6713959416666666675FA204100000020773959413333333361FA2041333333F3793959410000000042FA20419A9999997D3959419A9999992EFA2041333333937F3959410000000011FA204100000060823959419A999999EBF92041000000408539594166666666C4F92041000000A0873959419A9999999DF92041000000A089395941333333337AF92041CDCCCCEC8A395941000000005EF92041333333738B3959410000000049F92041333333738B3959416666666615F92041CDCCCCCC8C39594100000000D2F82041666666C68D395941000000009FF82041CDCCCC4C8F3959413333333358F820413333339392395941CDCCCCCC16F8204100000080953959419A999999E3F72041666666E697395941CDCCCCCCB9F72041CDCCCCCC9A3959419A999999FFF62041666666A6A93959410000000045F62041333333D3BA3959410000000014F6204166666626C039594133333333F6F52041333333B3C43959419A999999D4F52041666666E6CA39594100000000ADF5204133333393D33959413333333395F520419A999919D5395941666666667BF52041000000E0D43959416666666650F5204166666666D2395941CDCCCCCCDFF4204133333353CA3959419A999999AFF420419A999999C83959413333333399F4204100000080C7395941CDCCCCCC84F4204100000080C63959419A99999960F420419A9999B9C53959416666666611F420419A999939C639594100000000C9F320419A9999F9C6395941CDCCCCCC9BF3204133333353C8395941CDCCCCCC7CF320419A999999C93959419A99999949F32041000000E0CB395941CDCCCCCC18F3204166666626CF3959419A99999905F3204166666666D039594100000000EFF22041000000C0D139594166666666C8F1204133333333E639594100000000ABF1204133333333E33959419A9999998DF1204166666626E1395941000000006CF12041CDCCCC4CDF395941333333335CF12041333333F3DE395941CDCCCCCC49F1204166666646DF3959416666666627F12041666666A6E03959419A999999F7F0204166666686E13959419A999999D2F020419A999919E33959413333333379F020419A999959E73959413333333326F02041CDCCCC8CEA395941CDCCCCCCF9EF204100000060EC39594166666666DBEF2041CDCCCCECEC395941CDCCCCCCC8EF20419A999919EE395941333333337BEF2041333333B3F53959413333333332EF2041666666E6FC39594133333333F8EE20419A999919033A59419A99999995EE2041333333B3083A59410000000058EE20419A9999190C3A59410000000003EE204166666666113A5941CDCCCCCCA3ED20419A999919163A59410000000056ED2041CDCCCCEC1A3A59416666666601ED204100000060203A594133333333C8EC204100000060233A5941CDCCCCCCACEC2041CDCCCC4C253A59410000000078EC204100000060283A5941CDCCCCCC4BEC2041000000602A3A59410000000013EC2041333333F32C3A59419A999999DCEB20419A9999B92F3A594133333333B9EB2041333333F3313A5941CDCCCCCC62EB20419A999979363A5941CDCCCCCC1AEB2041000000C0393A594133333333D8EA2041666666C63C3A594100000000A7EA2041CDCCCC4C3E3A5941666666665DEA2041CDCCCC0C403A59413333333318EA2041CDCCCC0C413A59419A999999F4E920419A999999413A5941CDCCCCCCDDE9204100000020423A594166666666BFE920419A999939433A5941CDCCCCCCA8E9204133333373443A5941CDCCCCCC8AE920419A999979463A5941CDCCCCCC43E92041000000404C3A5941CDCCCCCCE2E820419A9999F9533A5941333333339DE8204133333393593A5941CDCCCCCC7CE82041CDCCCC2C5C3A59410000000051E82041666666865E3A59416666666616E82041666666A6623A59419A999999DDE72041CDCCCCAC663A5941CDCCCCCCAFE720419A9999196A3A59413333333383E72041000000006E3A59416666666651E72041000000C0723A5941CDCCCCCC25E72041666666C6773A5941CDCCCCCCFEE62041666666C67C3A5941CDCCCCCCDEE620419A999999813A5941CDCCCCCCBEE6204133333333873A59419A9999998BE62041333333B3903A59413333333361E62041333333D3993A5941000000001DE62041666666E6A73A594166666666ECE52041666666C6B23A594100000000D5E52041CDCCCCCCAF3A594166666666B6E52041333333D3AC3A59410000000092E52041000000C0A93A59419A99999969E520419A9999D9A53A59410000000043E5204166666606A23A59416666666629E52041333333539F3A5941CDCCCCCC17E52041000000009F3A59419A999999F5E42041000000809E3A594133333333C0E42041CDCCCCCC9B3A5941CDCCCCCC85E42041666666A6953A59419A99999933E42041000000208D3A59413333333314E42041666666C6883A59413333333310E4204166666646863A594133333333FBE32041666666E6823A594166666666E7E320419A9999B97F3A594133333333ACE32041333333D37C3A5941333333336AE32041CDCCCC4C7B3A5941CDCCCCCC31E320419A999979793A5941CDCCCCCC0FE3204133333313793A594166666666FCE220419A999939783A5941CDCCCCCCF1E22041333333F3763A5941CDCCCCCCE8E22041333333F3743A594133333333EAE2204166666606723A594166666666D8E22041333333B3713A594133333333B3E220419A9999B9713A59410000000072E22041333333B3703A5941CDCCCCCC06E220419A9999996E3A5941CDCCCCCCC8E12041CDCCCCEC6D3A5941000000007AE12041000000006E3A59410000000071E12041CDCCCCCC6F3A5941666666665BE12041333333B3733A59419A99999942E1204166666606773A5941CDCCCCCC0EE12041CDCCCC0C743A59419A999999E4E020419A9999F9703A59419A999999B5E02041666666C66D3A59419A9999998BE02041CDCCCC4C6B3A5941000000005FE0204133333333693A5941000000002CE020419A9999B9663A594100000000FBDF20419A999999643A594100000000DDDF204166666686633A594166666666C0DF204166666666623A59416666666694DF204166666646613A5941CDCCCCCC66DF204133333313603A5941CDCCCCCC39DF2041333333735E3A5941CDCCCCCC03DF2041000000205D3A594100000000CFDE20419A9999B95B3A594166666666AEDE2041666666E65A3A59419A9999999BDE20419A9999395A3A59410000000086DE2041333333B3603A59419A99999976DE204166666646663A5941CDCCCCCC6CDE2041666666866D3A5941000000004FDE20419A9999796D3A59419A99999932DE20419A9999F96D3A59410000000018DE2041666666066E3A59419A99999903DE20419A9999796D3A594100000000EEDD2041333333536C3A594100000000CDDD20419A9999196A3A5941333333337DDD204100000080633A5941CDCCCCCC34DD2041CDCCCCEC5D3A594166666666EDDC2041CDCCCCAC573A59419A999999BEDC204166666666533A59419A99999992DC204133333333503A59419A9999995EDC2041666666064D3A5941000000002FDC20419A9999594A3A5941000000000EDC20419A999919483A59419A999999EEDB2041666666C6443A59419A999999C7DB204166666606403A59413333333396DB204100000060393A5941666666666CDB204133333393343A59413333333340DB204100000040303A59419A99999905DB2041666666662A3A5941CDCCCCCCD2DA20419A999939253A59419A9999999DDA2041666666461F3A59410000000071DA20419A9999591A3A5941666666664CDA204100000000173A59419A99999929DA204100000000153A5941000000000DDA20419A999939143A594100000000E4D920419A9999D9123A59419A999999B0D92041666666C60F3A59416666666673D92041000000C00C3A59410000000029D92041666666E6083A594100000000EAD8204133333313063A594166666666AED82041000000E0033A59419A9999996DD82041333333F3013A5941CDCCCCCC34D82041000000A0FF395941CDCCCCCCF9D72041333333F3FC39594100000000B5D7204133333353F9395941CDCCCCCC76D720419A999919F6395941666666663DD72041CDCCCC0CF3395941666666660BD7204133333353F039594133333333E5D6204166666666EE3959419A999999C1D6204133333313ED39594166666666A2D62041CDCCCCACEC3959419A99999989D62041CDCCCC4CEC395941CDCCCCCC76D6204100000080EB395941333333334ED62041000000A0E8395941333333331DD6204133333373E439594100000000E7D52041CDCCCC0CE039594133333333B8D5204166666626DD3959410000000087D5204100000060D9395941CDCCCCCC8CD520419A999939DF395941CDCCCCCC8ED520419A999939E7395941666666668BD5204133333353F1395941CDCCCCCC85D5204133333373FC395941CDCCCCCC7ED52041000000E0083A59419A9999997AD5204133333373143A59416666666677D52041000000A01E3A59413333333378D52041CDCCCC8C263A5941666666667AD52041000000E02F3A5941CDCCCCCC7CD520419A9999B9393A5941666666667FD5204133333353403A5941CDCCCCCC84D520419A9999D9473A59419A99999989D520419A999979513A5941333333338ED52041000000A0593A5941333333338FD52041CDCCCC4C633A5941CDCCCCCC90D52041CDCCCCCC6C3A5941CDCCCCCC93D5204100000060783A59416666666695D520419A9999F9833A59416666666696D52041333333F38C3A5941CDCCCCCC99D5204166666646923A594100000000A3D52041666666E6973A59419A999999BED5204166666686A63A5941CDCCCCCCCBD5204133333353AF3A594100000000D6D52041000000C0B53A594100000000E0D5204166666686B93A594166666666F4D520419A999999BC3A59419A999999D7D520419A999919BC3A5941CDCCCCCCC6D52041CDCCCC0CBC3A594133333333C0D520419A999919BC3A59419A999999ABD520419A999959BC3A5941666666668AD52041333333F3BC3A59410000000058D52041CDCCCC0CBE3A5941000000001CD5204166666646C03A59419A999999DBD4204133333373C23A59419A99999989D4204133333373C53A59413333333346D420419A9999F9C73A5941666666660AD4204133333393CA3A594100000000DCD32041CDCCCCCCCC3A5941000000006DD3204133333373E93A5941CDCCCCCC05D220419A9999B9FA3A5941CDCCCCCCEED02041000000E0053B59410000000023D12041333333F30F3B59413333333360D12041CDCCCC8C1B3B59413333333330D12041333333F31E3B59413333333301D1204100000020233B594166666666C9D0204166666686283B5941666666668FD02041666666862E3B59410000000066D020419A999999323B59416666666647D0204100000020363B59419A99999928D020419A9999D93A3B5941CDCCCCCC06D0204100000060413B594100000000ECCF204166666606473B594133333333D7CF20419A9999194B3B594166666666C6CF20419A9999794D3B59419A999999ADCF20419A9999B94F3B5941000000008FCF2041666666C6513B5941333333337BCF20419A999979533B59410000000070CF20419A9999B9553B59413333333370CF20419A9999F9583B5941CDCCCCCC77CF2041666666E65C3B59410000000087CF204100000060633B59419A99999998CF2041333333136A3B5941666666669FCF2041CDCCCCCC6D3B59419A9999993DCE2041333333F3773B59419A999999ACCD2041000000E07C3B594133333333A9CD2041666666A67B3B59419A9999998CCD20419A999959733B59413333333375CD2041CDCCCCCC6F3B59416666666650CD2041333333F36B3B59413333333324CD204100000000673B59419A999999FACC204100000080623B59419A999999D5CC20419A9999595F3B5941CDCCCCCCA1CC2041333333F35B3B59419A9999996CCC2041666666C6583B59419A99999912CC2041CDCCCCAC643B5941CDCCCCCC8BCB204100000060703B5941666666661ACB204133333393793B59413333333322CB2041333333537C3B59410000000023CB204133333333803B59410000000022CB204100000080843B59419A9999991BCB2041333333938A3B59413333333313CB204166666606903B594100000000FFCA2041333333339C3B59419A999999EDCA204100000060A83B59419A999999E0CA2041666666C6B13B59419A999999D2CA2041CDCCCCCCB83B59419A999999C8CA204166666686BB3B594166666666A2CA2041CDCCCC0CB63B59419A99999978CA204133333353B03B59419A99999946CA2041CDCCCC4CAA3B59419A99999901CA204166666686A23B594166666666D1C92041666666069D3B59413333333396C9204133333393963B5941CDCCCCCC72C9204166666606923B59410000000036C920419A9999F98A3B594100000000F9C8204166666606823B59419A999999BFC8204133333333793B5941000000008CC820419A9999B9713B5941CDCCCCCC65C82041333333136C3B5941000000004EC82041666666E6693B5941CDCCCCCC3DC8204133333333693B59419A99999926C8204133333353683B5941333333330FC8204166666686683B5941CDCCCCCC02C820419A9999D9683B594100000000F1C7204133333353693B5941CDCCCCCCD5C72041CDCCCC2C693B5941CDCCCCCCBDC7204133333353683B594100000000A7C7204166666686663B5941000000008BC72041000000A0623B5941CDCCCCCC53C72041000000005B3B5941666666661FC72041CDCCCCAC533B594166666666FBC62041333333934E3B59419A999999DAC62041333333D34A3B5941CDCCCCCCB7C620419A999939483B59416666666691C62041666666E6453B59413333333359C62041666666A6433B5941CDCCCCCC1BC62041CDCCCC0C413B594133333333D3C52041666666A63D3B5941666666668CC52041666666063A3B59419A99999945C5204133333313373B5941CDCCCCCC20C52041333333F3353B594100000000F2C420419A999999343B5941CDCCCCCCCAC42041666666E6323B5941CDCCCCCCACC4204100000020313B59410000000094C42041000000802E3B5941CDCCCCCC69C42041000000A0313B59410000000031C420419A999939343B594166666666E9C32041666666C6373B594166666666A9C32041000000003B3B5941CDCCCCCC6EC320419A9999B93D3B59413333333345C320419A9999D93F3B59416666666620C3204133333333423B594100000000FBC220419A999979453B594100000000C7C22041000000C0493B5941CDCCCCCC9DC220419A9999594D3B5941CDCCCCCC6EC2204100000020523B59413333333343C2204100000000563B5941CDCCCCCC0AC220419A9999195B3B59419A999999D7C12041000000405F3B5941CDCCCCCC9CC12041666666C6633B59413333333364C12041666666E6673B5941000000002DC12041333333B36C3B594100000000BBBD2041CDCCCC4C693B5941666666668EBD2041666666A6423B59419A99999956BD2041000000C0443B5941000000001EBD2041000000C0463B594100000000BEBC2041CDCCCCCC483B59416666666683BC20419A9999F9423B59416666666675BC204100000080463B59413333333367BC204166666646483B5941000000004FBC20419A9999794B3B59416666666629BC2041CDCCCC2C503B59419A99999917BC20419A999979523B5941CDCCCCCCFBBB204166666646553B594133333333E8BB20419A999919573B594166666666D0BB204100000080583B594100000000BCBB2041000000205A3B594133333333ADBB2041666666A65B3B5941CDCCCCCCA6BB2041CDCCCCAC5C3B59419A99999985BB20419A9999B9603B59410000000068BB20419A999939643B5941333333334EBB204166666666673B5941CDCCCCCC30BB2041CDCCCC4C6A3B59413333333313BB2041666666866C3B594100000000F3BA20419A9999996F3B594133333333DFBA2041CDCCCC6C713B5941CDCCCCCCD6BA204100000080723B5941CDCCCCCCABBA20419A9999D9773B59416666666686BA2041000000807C3B59410000000057BA204100000000833B5941CDCCCCCC46BA2041CDCCCC4C853B5941CDCCCCCC3ABA20419A9999F9863B5941CDCCCCCC36BA20419A999959893B59413333333334BA2041000000808C3B5941	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	01010000206A080000D71ADABCE5EA204166666616973D5941	360180000	Z	Le Blanc	3601800	36018	36	24	57
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	01010000206A0800008A888868EF082341CDCCCC1CC34B5941	360190000	Z	Bommiers	3601900	36019	36	24	29
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	01010000206A0800003CCA594D403F21419A9999091A225941	360200000	Z	Bonneuil	3602000	36020	36	24	12
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	01060000206A08000001000000010300000001000000A0000000666666667CE5224100000080F1625941CDCCCCCCDDE522419A999999F16259416666666645E6224133333353F56259413333333374E62241333333D3FA625941CDCCCCCCA3E62241333333930C63594133333333C5E6224133333373156359410000000033E722416666664627635941CDCCCCCC82E722419A999919326359419A999999A4E72241CDCCCC4C346359416666666694E82241000000E03E6359413333333339E82241CDCCCCCC476359410000000069E622419A9999B976635941CDCCCCCC50E6224166666626786359416666666661E622419A9999397E635941666666669CE622419A9999798763594166666666EAE622419A9999798D635941CDCCCCCC39E82241666666C6A16359419A9999997CEA22419A999979BD63594100000000F8E922419A999979E16359419A999999E4E922419A999919E9635941CDCCCCCCC4E9224166666606066459416666666662E922419A9999D9346459410000000058E9224100000000366459419A999999A1E8224133333313956459416666666684E822419A999959A06459419A99999979E722419A9999391165594166666666D5E62241CDCCCCCC63655941666666662DE622419A999939976559416666666668E6224100000060986559410000000020E922419A999919AC6559413333333355E9224133333393AC655941CDCCCCCC4CEA224133333313A36559416666666691EA22419A999919A16559410000000064EB22419A999939A065594133333333B7EB224133333393A06559419A99999925EC224133333393A26559410000000018ED22419A999979AC655941000000007CED22419A999999AE6559419A99999900EE2241CDCCCC6CAF655941CDCCCCCC6CEE224133333373AD65594133333333BAEE22419A999979AA65594100000000F3EE2241CDCCCC0CAA6559419A99999955EF2241666666A6AC6559413333333394EF224166666686B06559413333333355F02241333333D3C26559419A9999999AF0224133333313C86559416666666638F1224133333313CB6559416666666669F1224100000060B26559413333333395F32241CDCCCCEC5464594100000000C1F52241666666A61E64594100000000E1F62241000000E00264594166666666A9F82241CDCCCC2CD46359416666666632FE224133333373556359416666666673FF22419A9999F9346359419A999999B30023419A9999191463594133333333B20023413333339311635941CDCCCCCC7900234133333333F6625941666666664B0023419A999919E26259410000000005002341CDCCCC2CCE6259419A999999BDFF224133333353B862594133333333B1FF22419A9999D9AE62594166666666FFFF2241CDCCCCAC8A6259419A9999991D0023413333339375625941CDCCCCCC3D002341CDCCCCEC81625941000000005C002341333333B389625941CDCCCCCC860023419A999999906259419A999999D3002341CDCCCCAC98625941666666667101234166666646A362594133333333BA012341CDCCCC2CAA6259419A999999DF012341333333D3AF6259419A999999A90723419A9999394462594100000000A5092341333333F32162594133333333120A23419A9999191962594133333333DA0B234166666666FB6159419A999999810A234100000080A761594166666666F0062341CDCCCCACC760594166666666C10523419A9999997D6059419A999999FD042341000000404E60594100000000CF042341000000E0436059419A999999BD042341CDCCCCAC3B605941666666669E042341333333F338605941CDCCCCCC93042341CDCCCC2C3460594133333333A20423419A9999392F605941CDCCCCCC9E0423419A9999D9196059419A9999992C042341666666461E6059410000000096032341666666E61F605941CDCCCCCC8A0223419A9999391D60594166666666E2012341666666061860594133333333990123413333337313605941CDCCCCCC3F012341666666061060594100000000BE00234100000080096059419A9999997900234100000080156059419A99999949002341CDCCCC4C1B605941666666661A002341000000401B60594133333333D2FF224100000060186059419A99999902FF224133333373156059419A999999A8FE22419A999979156059410000000052FE2241000000E0166059413333333342FE224100000020156059419A999999D1FD2241333333F314605941CDCCCCCC8AFD2241CDCCCCEC166059419A99999907FD2241666666061C6059419A999999C0FC2241000000601C605941CDCCCCCC3CFC2241666666061A6059419A999999FBFB2241333333131760594100000000E1FB224166666686116059410000000003FC22419A9999790E6059410000000094FB2241333333330F6059419A99999996FA2241666666E60C605941333333331CFA2241CDCCCCAC0C6059410000000085F92241000000E00D60594133333333E1F822419A9999D90F6059419A9999998FF822419A9999991160594166666666D0F722416666664617605941000000001CF72241CDCCCCCC1D605941CDCCCCCCA6F62241666666C6246059419A9999991FF62241666666C633605941666666669CF522419A9999593A605941666666669BF422419A999959446059410000000060F42241666666864760594100000000E3F32241CDCCCC4C506059413333333373F32241CDCCCC4C536059419A99999971F222410000006055605941CDCCCCCC5FF12241333333B35E6059410000000000F12241CDCCCC6C606059413333333342F02241666666465E6059416666666627EF224133333333556059410000000078EE2241CDCCCC4C526059410000000028EE2241CDCCCC6C526059419A99999993ED22413333337350605941000000003CEC2241666666A64860594100000000C5EB224100000000496059419A99999949EB22419A9999D94B60594166666666C9EA22419A9999F94F6059419A99999960EA22410000008055605941CDCCCCCC5AE92241CDCCCCEC59605941666666660AE92241333333D35C6059416666666662E82241666666E66460594133333333FBE722419A999999676059419A99999971E722410000004068605941CDCCCCCC51E722419A9999996960594166666666B1E62241666666C674605941CDCCCCCCAEE62241CDCCCCCC8460594166666666C7E62241CDCCCC8CD260594100000000FBE622419A999979EB6059416666666619E822419A9999994C6159410000000033EA2241CDCCCC6CE26159410000000069EA22419A999939F5615941CDCCCCCCD8EA2241333333D30962594100000000C3EC2241CDCCCCAC5B6259419A9999995EEC22410000004063625941CDCCCCCCC4EB2241000000206B6259413333333318EB2241CDCCCCCC7162594100000000AAEA2241666666E6776259419A9999993CE9224133333353956259410000000046E6224133333313D26259419A9999998EE5224100000080E06259413333333393E52241666666E6E6625941666666667CE5224100000080F1625941666666667CE5224100000080F1625941	01010000206A0800000CE8BBE2F6F22241CDCCCC9CEA625941	360210000	Z	Les Bordes	3602100	36021	36	24	16
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	01060000206A080000010000000103000000010000003D0100009A9999994D3822419A999979193D594166666666683822419A9999D92E3D59419A9999998F3822419A9999993C3D59419A9999999338224100000020453D59419A99999930392241CDCCCC8C753D5941CDCCCCCC46392241000000A0763D594166666666613922419A9999B97C3D5941666666669B392241666666A6943D59419A999999C6392241CDCCCC8CA13D594133333333FD392241333333F3AD3D594133333333393A224133333393B93D59419A999999A63A2241666666C6C73D594100000000D53A2241333333B3D43D594100000000013B224133333393DE3D594100000000193B224166666666EC3D594100000000D53A22419A999979FC3D59419A999999B83A224133333393013E5941CDCCCCCCA63A22419A9999F9133E5941CDCCCCCCB03A224166666666183E594100000000EC3A2241000000C01E3E594100000000AD3B2241666666C6273E5941CDCCCCCCE63B2241CDCCCC6C2F3E5941CDCCCCCC123C2241666666C63B3E59419A999999323C2241CDCCCC8C4A3E594100000000233C2241CDCCCCAC523E5941000000000B3C2241000000A0563E59419A999999C53B22419A9999D9593E594166666666BD3B2241666666065E3E59419A999999CF3B224166666606643E5941CDCCCCCCAF3B2241000000E06B3E594100000000C03B22419A9999B9713E594133333333A13B224133333393783E5941666666669A3B2241666666467E3E594133333333363B2241333333D38F3E5941CDCCCCCC313B22419A9999599B3E5941CDCCCCCC013B224166666606A73E594133333333023B224133333393AB3E59419A999999553B224133333373AC3E594100000000943B2241333333F3BB3E594166666666B93B2241666666A6C13E5941333333339E3B2241000000A0D33E594100000000763B22419A9999F9E13E594166666666D63B2241CDCCCCCCED3E5941CDCCCCCC0A3E224166666626F33E5941CDCCCCCCA33E22419A9999B9F23E59419A9999990E3F22419A999979F03E59419A999999D340224100000060E43E5941CDCCCCCC9542224133333353D93E59419A9999994744224166666606CF3E594166666666F04422419A999979CB3E5941333333332345224166666666CD3E5941000000008D45224133333333CD3E594133333333FF452241CDCCCCCCCE3E594166666666A847224133333353C13E59419A99999949482241CDCCCCECBC3E5941000000006348224133333313BD3E594166666666BC482241CDCCCCECC33E59416666666676492241CDCCCC0CD83E5941666666669E492241CDCCCC4CDB3E5941CDCCCCCCF549224166666646DB3E59419A999999964A2241CDCCCC2CD83E5941333333331A4B2241000000A0D33E594133333333CB4B2241CDCCCCCCCE3E594166666666414C2241666666A6CC3E5941CDCCCCCC144D22419A999959CE3E59419A999999994D224166666686CE3E594133333333AB4E2241333333B3C53E5941666666662D4F224133333353BE3E5941666666662A50224100000000B53E5941CDCCCCCC395122419A999939B43E5941666666666E51224133333313B53E594133333333F15122419A999919B33E59419A9999993A522241CDCCCC4CB03E5941333333338152224166666606AF3E594100000000B053224133333313AD3E5941CDCCCCCCDF532241666666A6BA3E5941000000005654224133333373BD3E594133333333F254224133333373BD3E5941CDCCCCCC4055224166666606B83E59419A999999C1552241CDCCCC4CAA3E594100000000E5552241CDCCCC0CA83E5941333333331E56224166666626AA3E5941666666665256224100000000AA3E594100000000A056224166666666A63E594100000000B3562241CDCCCCCC973E5941CDCCCCCC9E562241666666868D3E59413333333394562241000000007C3E5941666666669C56224133333353793E59410000000005572241000000006C3E59419A9999995B572241333333D3583E5941CDCCCCCC80572241CDCCCC0C533E5941CDCCCCCC7E572241CDCCCC0C453E5941CDCCCCCCC3572241CDCCCC6C2B3E59419A999999C4572241000000C0223E594166666666A857224133333313203E59419A99999984572241000000A0203E5941CDCCCCCC78572241666666A61D3E5941333333338D57224133333353183E59419A99999985572241CDCCCC0C153E5941CDCCCCCC585722419A999919123E59419A9999993A57224133333353093E5941333333330E572241333333B3043E5941666666660C572241000000C0003E5941CDCCCCCC4C57224100000000FE3D5941CDCCCCCC525722419A9999F9F43D5941333333333957224166666646F43D5941CDCCCCCC14572241000000A0F73D594100000000F656224100000020F63D594133333333FB56224100000020EB3D5941666666660B5722419A999939E63D59419A999999FF562241666666C6D73D59419A99999916572241666666C6D23D59419A9999994757224133333373D33D59419A9999995A572241CDCCCCCCC93D5941666666665A5722419A9999B9C33D59413333333373572241CDCCCC6CB73D59419A999999B657224100000040AE3D5941CDCCCCCCCC572241CDCCCC4C943D5941CDCCCCCCD9582241000000A0883D594166666666A35922419A9999D97C3D59419A999999775A2241333333937A3D5941CDCCCCCC0F5B2241333333537A3D594166666666015B224166666626713D59419A999999005B22419A999999663D594133333333C05A2241CDCCCCAC503D5941666666665A5A224166666686323D594166666666395A2241666666E6293D5941CDCCCCCCDB5B22419A9999D9F13C594100000000E15B22419A9999B9B93C59419A999999865B22419A999919953C5941333333332B5B22419A9999796C3C59419A999999425B2241333333D3573C594166666666765B2241CDCCCCAC4C3C5941000000004C5C2241CDCCCC4C463C594166666666BE5C224166666626423C59419A999999BA5D22419A9999F93C3C594100000000135E2241333333B3323C5941000000006F5E2241000000602A3C59419A999999845F22419A9999D9073C5941CDCCCCCC815F2241CDCCCC0CFD3B5941CDCCCCCCEF5F22419A9999D9DC3B59419A999999FD5F224100000000D63B59419A99999901602241CDCCCCCCC83B59419A999999F85F2241333333B3BF3B59419A999999E45F22419A999999993B5941CDCCCCCCD55F22419A999939843B5941CDCCCCCCF65F2241666666C66B3B594100000000F55F2241CDCCCCCC613B594133333333DF5F2241CDCCCCAC583B5941CDCCCCCC955F2241666666E6483B594100000000725F22419A9999F93E3B594100000000575F224100000040343B594166666666625F224166666686303B594166666666A25F22419A9999F92E3B5941CDCCCCCC146022419A9999792A3B59419A9999997D602241333333B31A3B59419A999999D9602241000000E00E3B5941000000000E6122419A999979F23A5941666666667061224166666626DD3A59413333333397612241333333B3D73A594133333333615F224166666666643A59419A9999990B5F2241666666E65E3A594133333333365E2241666666664F3A594133333333FA5D2241333333934B3A59419A999999CE5D2241666666E6463A59419A999999AC5D2241CDCCCCAC343A594166666666835D2241000000402A3A59419A999999505D2241000000401A3A594166666666225D2241333333530E3A5941CDCCCCCCB95C22419A999959FB39594100000000255C2241CDCCCC2CE63959419A999999095C22419A999959DC395941666666661D5C22419A999999D5395941333333338F5B224100000060C6395941666666664C5B224100000080BC395941CDCCCCCCEB5A224133333353B539594133333333B95A2241CDCCCC0CB3395941CDCCCCCCAF5A2241CDCCCC4CAA39594100000000735A2241CDCCCCCC9739594133333333995A2241CDCCCC0C95395941CDCCCCCC575A2241333333937E3959419A999999095A22419A9999D971395941666666669D59224166666686633959419A9999995F5922413333335359395941333333334A5922419A99993951395941CDCCCCCC41592241CDCCCCEC473959416666666645592241000000A0383959419A999999595922419A9999B92A395941000000003A592241666666861F395941333333332B592241CDCCCCEC1239594133333333255922419A999959F83859410000000038592241CDCCCC4CE4385941000000003659224100000000D43859413333333318592241000000A0CE385941333333338058224166666626BB38594100000000685822419A999939B43859419A9999992C58224133333313AE38594133333333ED57224166666666A438594100000000E6572241666666E6EE37594166666666B557224166666666EF3759419A9999997457224100000020F33759419A999999015722419A999999F337594166666666885622419A9999D9F1375941666666660B562241000000E0EE375941333333336855224133333353E837594133333333C0542241666666A6DF375941CDCCCCCC6654224100000040DD375941CDCCCCCC6654224100000000E037594166666666275422419A999959EB375941000000008E5222410000004017385941CDCCCCCC17512241CDCCCC0C40385941000000006550224166666606533859410000000031502241666666C6593859413333333327502241000000206C385941666666660B502241666666C6703859413333333302502241000000407D38594100000000ED4F2241CDCCCC6C87385941CDCCCCCCD94F22419A9999798A38594133333333A54F22419A99995999385941333333333E4F2241333333D3AC385941CDCCCCCCBA4E2241CDCCCC0CC338594166666666984E2241333333D3CA385941666666665C4E224166666686D138594133333333154E2241000000A0DB3859419A999999C54D22419A999999E838594133333333B54D22419A999999E9385941CDCCCCCCBE4D22419A999999F338594100000000EE4D2241333333730839594100000000924D2241666666660D39594133333333494D22410000004015395941CDCCCCCC354D22419A9999391B3959419A999999C14C2241666666462639594133333333D14C2241CDCCCC6C2F39594133333333894C2241333333F33139594100000000164C22419A9999393839594166666666994B22419A9999B93D39594133333333364B2241666666864639594133333333194B22419A9999594B39594133333333D64A2241CDCCCC8C4539594166666666AE4A22419A9999B951395941000000005B4A2241000000A0533959419A999999084A22416666668659395941000000006F4922419A9999F95C3959410000000057492241000000E05B395941CDCCCCCCFD4822419A9999F96E39594100000000FE4822419A99997971395941CDCCCCCCC9482241CDCCCCCC7939594100000000D84822413333337381395941666666661A492241CDCCCC4C913959419A99999900492241CDCCCC4C9539594166666666B348224133333373913959419A9999994148224166666666893959419A9999998D4722419A99999984395941CDCCCCCCCB452241333333D383395941CDCCCCCCE04422419A99991983395941CDCCCCCC52442241666666C68A395941000000002A4422419A9999D98E3959419A999999C5432241000000C0A73959419A9999998343224100000040B23959413333333303432241000000C0C0395941333333334F42224100000000D4395941CDCCCCCC0F422241CDCCCC2CD9395941000000007841224166666646DC395941666666666C412241000000E0E0395941000000000D412241333333D3F5395941CDCCCCCC63402241CDCCCC8C123A5941333333338F3F2241333333332C3A5941CDCCCCCCD53E22419A9999B9563A5941CDCCCCCC643E2241CDCCCC2C6F3A594133333333823A224166666646183A594166666666293A2241666666E6A13A59413333333370392241333333D3B83A59419A999999453922419A9999D9B93A594100000000F43822419A9999B9B63A5941CDCCCCCCF038224100000020BA3A5941333333336638224166666646EA3A59419A99999968382241333333F3EC3A594166666666F03822419A999979093B59410000000058392241000000C0123B5941000000005F3A2241CDCCCC8C273B59419A999999BC3B224100000000393B594100000000D23C224166666626773B594100000000703C224166666686813B5941CDCCCCCCB33C2241666666E68E3B594133333333A83C2241000000E0AD3B59419A999999F53C2241CDCCCCACBC3B59419A9999993F3D2241000000E0D23B59419A999999213D2241666666A6D83B5941666666662C3D224100000020E53B594100000000C73D224133333373253C59419A9999990B3E224100000040323C594166666666253E2241CDCCCC6C353C594100000000873E2241333333B34D3C594166666666B63E2241333333935F3C594166666666B83E22419A999979643C594166666666663E2241666666266F3C59419A9999995E3E2241333333B3763C594166666666613E224133333393823C594133333333543E2241CDCCCC2C8D3C5941666666662A3E224166666666933C594166666666D13D2241CDCCCCEC983C594133333333893D224100000060993C594100000000013D2241000000E0913C5941333333337D3C2241CDCCCC2C8F3C59419A9999990B3C2241666666268F3C594133333333C63B2241000000A0903C594100000000313B224166666606973C594100000000CF3A2241666666E69E3C594166666666693A224166666686AB3C594166666666043A22419A999939BF3C5941CDCCCCCCC439224133333313CE3C594100000000A2392241333333D3D33C5941CDCCCCCCFB3822419A999919E53C5941CDCCCCCCA33822419A9999D9F03C59419A9999995C382241666666260B3D59419A9999994D3822419A999979193D59419A9999994D3822419A999979193D5941	01010000206A080000E2183CEB454E224100000050693B5941	360220000	Z	Bouesse	3602200	36022	36	24	24
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	01010000206A080000E1A27425E04622419A9999F926685941	360230000	Z	Bouges-le-Château	3602300	36023	36	24	35
01060000206A08000001000000010300000001000000640000003333333365442241000000C097635941666666669344224133333313FB635941CDCCCCCCD94422419A999919406459419A9999996D45224100000080B56459419A999999D1452241666666E6C6645941000000001E482241333333334065594133333333A2482241333333735D655941CDCCCCCCE4492241333333B3A165594100000000EA4E2241000000C053665941333333338F512241333333136E66594166666666985122419A9999B96E6659419A999999A0512241333333536F66594133333333A95122419A999919706659419A999999B351224166666626716659419A999999BB512241333333B37166594166666666C3512241333333137266594133333333CA512241666666467266594133333333D1512241000000607266594100000000D95122419A9999397266594133333333E1512241666666E6716659419A999999E8512241CDCCCC4C71665941666666662F542241333333D38966594133333333F95422419A999919916659419A999999FF54224166666666916659416666666603552241333333D3916659419A9999994D5B22419A999939C866594133333333EE612241CDCCCC8CE766594166666666E762224166666646D566594166666666246522413333337343665941333333330C6622410000000008665941000000004766224133333333F5655941CDCCCCCC9D66224166666626C865594166666666CE662241000000E0B2655941000000004B672241CDCCCC0C6465594133333333A7672241CDCCCCCCEF64594166666666E967224166666646B66459413333333397682241666666665D645941CDCCCCCCDB6822419A99995949645941000000003D69224166666646216459419A9999997E6A2241666666C6A7635941666666661D6C2241666666C60963594166666666E76B22419A9999B9086359419A999999C06B22419A999919086359419A999999626B2241666666660663594133333333196B22419A9999F9046359419A999999A06A2241CDCCCC8C0263594133333333366A22419A9999790063594166666666A36922419A999999FD625941CDCCCCCC2669224166666626FB625941CDCCCCCCDD682241666666A6F96259410000000073682241CDCCCC6CF8625941CDCCCCCC316822419A999999F762594100000000B4672241CDCCCC4CF66259419A9999993767224133333313F56259416666666629672241000000E0F462594133333333FE66224100000060F462594166666666C366224166666606F462594166666666FF65224100000080F262594100000000706522419A999959F1625941CDCCCCCCE7642241000000E0EF6259413333333328642241CDCCCCECED6259419A9999991264224100000000EE6259419A99999907642241CDCCCC6CED625941CDCCCCCCFE632241666666E6EC625941CDCCCCCCF7632241333333D3EB625941CDCCCCCCEB632241CDCCCCECE9625941CDCCCCCCDA632241CDCCCCCCE76259413333333380632241666666C6DD6259419A9999993463224166666686D562594133333333FF622241000000E0CF625941CDCCCCCC54622241666666A6BD6259419A999999BE612241666666C6AD625941333333330E612241CDCCCC0C9B6259416666666676602241666666C68A62594166666666445F2241000000C069625941666666660D5F22419A9999F96362594133333333F95E22413333335362625941CDCCCCCCE95E224166666606616259419A999999D75E2241CDCCCCCC5F625941CDCCCCCC9D5E2241000000805B62594133333333F75D22419A9999594C6259419A9999990C5C2241666666062662594166666666255A22419A999979FE615941333333331659224166666646E8615941CDCCCCCCB558224166666646DC615941333333334858224133333353D261594166666666B85722419A999999C36159419A99999956572241000000E0B96159416666666606572241CDCCCCCCB161594133333333C7562241CDCCCC0CAB615941CDCCCCCCB156224100000040A861594100000000AB5622419A9999B9A66159410000000007532241000000E0DA615941666666663052224166666646E461594166666666544F2241666666660162594133333333F64C2241000000801D62594166666666B94C2241666666C62762594166666666944C2241CDCCCCCC2F62594166666666F44A2241CDCCCCAC7C6259413333333365442241000000C097635941	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	01010000206A0800003B64F651E35622419A9999B944645941	360240000	Z	Bretagne	3602400	36024	36	24	18
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	01010000206A0800006D044B86C7132341000000304B335941	360250000	Z	Briantes	3602500	36025	36	24	23
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	01010000206A080000742469A1A6672241666666B6755E5941	360260000	Z	Brion	3602600	36026	36	24	44
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	01010000206A080000EBFB3074E4DA2241CDCCCC1C7B545941	360270000	Z	Brives	3602700	36027	36	24	20
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	01010000206A080000BE12A3E33F8B2241666666C6602D5941	360280000	Z	La Buxerette	3602800	36028	36	24	11
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	01010000206A080000D0A03E17E44C2241333333B394715941	360290000	Z	Buxeuil	3602900	36029	36	24	20
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