SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep37;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep37 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep37','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep37','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep37','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep37"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800003DE0B264DB1B2041CCCCCC0C5D5F5941	370010000	Z	Abilly	3700100	37001	37	24	31
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	01010000206A080000FE2D0B2F71FA1E419A9999A9D7975941	370020000	Z	Ambillou	3700200	37002	37	24	50
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	01010000206A0800000517AD1883C520416666663667925941	370030101	H	Nord-Nord-Est	3700301	37003	37	24	7
01060000206A0800000100000001030000000100000005010000CDCCCCCC4AB5204133333393759159413333333359B520419A9999B9789159419A9999995EB520419A9999D9799159419A99999970B520413333335380915941000000007CB520413333335387915941333333337DB52041CDCCCC8C89915941CDCCCCCC86B52041666666A69B9159413333333389B520419A9999D99F9159413333333389B52041000000C0A59159419A99999989B52041CDCCCCACAD9159416666666689B52041333333D3AF915941CDCCCCCC89B5204100000060B0915941666666668AB52041CDCCCC8CB1915941666666668DB52041CDCCCCACB6915941666666669AB520419A9999F9C2915941CDCCCCCC9EB520419A999919C791594133333333A2B52041CDCCCCCCC8915941CDCCCCCCABB520419A9999B9CD91594100000000B8B520419A999979D291594133333333C6B520419A9999D9D69159419A999999D4B5204133333333D99159419A999999DCB52041333333F3D9915941CDCCCCCCECB52041CDCCCC6CDB915941CDCCCCCC29B6204133333313DF915941000000002FB62041000000A0DF9159419A9999993DB620419A999939E19159413333333351B6204100000020E49159410000000063B62041CDCCCCCCE89159416666666692B62041CDCCCC2CF591594133333333A4B6204166666606F49159419A999999C4B62041666666C6F29159419A999999C6B6204100000040F49159419A999999C7B62041666666A6F591594133333333C9B62041CDCCCC6CF79159419A999999C8B6204100000060F99159419A999999C5B6204100000000FB9159419A999999C2B62041333333B3FC9159419A999999BFB6204166666646FE9159410000000064B62041333333F31A925941333333335DB620419A9999D91C925941333333339FB620419A999939209259413333333313B72041666666A6259259419A99999960B720419A999979299259419A99999973B72041000000802A92594166666666B6B72041000000A02D92594100000000D8B72041CDCCCC4C2F9259419A999999F8B720419A9999F9309259410000000019B820419A9999D9329259419A99999947B82041333333D3359259413333333388B82041333333733A925941666666669DB82041CDCCCC4C36925941CDCCCCCCC5B82041000000202D92594133333333EBB82041000000C02A925941333333330CB92041000000A0279259413333333311B92041333333F3269259419A99999977B920419A9999F918925941CDCCCCCC72B92041333333D3179259413333333340B920413333337313925941CDCCCCCC17B9204133333393109259419A999999B4B820413333335309925941666666669DB82041000000A007925941000000008AB820419A999999069259410000000062B8204166666626059259410000000053B8204100000040049259410000000074B82041333333D3F9915941CDCCCCCC7EB82041CDCCCC6CF89159419A999999A5B8204133333373F7915941CDCCCCCCCAB8204133333393F6915941333333331AB9204133333393F49159413333333336B920419A9999D9F3915941CDCCCCCC71B920419A9999B9F291594133333333A2B9204166666686F191594166666666A5B92041CDCCCC4CF491594133333333A8B9204100000080F591594166666666AFB92041333333D3F5915941CDCCCCCCEDB92041CDCCCC8CF59159416666666601BA20419A999939F59159416666666695BA2041666666A6F39159419A999999A7BA204133333393F39159416666666694BA2041333333D3F09159413333333389BA204100000040EF9159413333333375BA2041000000E0EB9159416666666687BA2041CDCCCC4CEB91594166666666A6BA20419A999959EA915941CDCCCCCCD7BA2041666666A6E7915941CDCCCCCCF2BA20419A999979E5915941CDCCCCCC0ABB204166666686E39159419A99999917BB20419A999919E29159413333333328BB20419A999939E09159419A9999994FBB204166666686DC915941333333336EBB204100000000D9915941CDCCCCCCD2BB20419A9999D9CB915941CDCCCCCC14BC2041CDCCCCECC1915941666666661CBC20419A9999B9C0915941666666667EBC2041CDCCCCACB09159419A99999992BC204133333353AD915941CDCCCCCC92BC204166666646AD91594133333333ADBC20419A9999D9A891594133333333B9BC2041333333D3A691594166666666CEBC204166666646A391594133333333CFBC2041CDCCCC2CA3915941CDCCCCCCDDBC2041000000A0A191594100000000FABC2041666666869E9159419A99999914BD2041000000E09C915941CDCCCCCC2BBD20419A9999F99B9159419A9999997DBD20416666668699915941CDCCCCCC8CBD20419A9999199991594100000000DBBD2041CDCCCCCC9691594100000000EBBD2041CDCCCC4C969159416666666602BE2041000000A0959159416666666634BE2041333333339491594100000000FABE2041CDCCCC8C8E9159419A99999906BF2041666666268E915941CDCCCCCC43BF2041333333338C91594133333333ACBF2041666666468991594133333333C9BF20419A999979889159419A999999EBBF20416666668687915941CDCCCCCCF9BF20410000002087915941CDCCCCCC73C020416666666683915941666666667BC02041CDCCCC2C8391594166666666B4C02041333333738191594166666666C8C020419A9999D9809159413333333336C12041666666C67D9159413333333349C120419A9999397D915941333333339BC12041666666E67A91594133333333D0C12041CDCCCC6C799159413333333360C2204133333333759159419A99999974C22041000000A074915941CDCCCCCC86C22041333333137491594133333333A6C22041666666267391594100000000D8C22041333333B3719159419A9999990EC3204133333313709159419A9999991AC320419A9999B96F9159410000000048C32041000000006E9159416666666653C32041333333936D915941666666667BC32041333333736B915941CDCCCCCC9CC320419A99999968915941CDCCCCCCBCC32041CDCCCC0C6591594100000000DEC320419A9999596091594166666666F4C32041666666865C9159419A99999908C420419A9999B9589159410000000004C42041333333B3579159413333333304C4204166666686569159410000000007C42041CDCCCCCC55915941CDCCCCCCEEC32041000000C053915941CDCCCCCC9EC32041CDCCCCCC4C915941CDCCCCCC66C320413333337347915941000000005AC32041CDCCCCAC459159416666666652C320416666666644915941000000003FC32041000000A03F9159413333333329C32041666666463A9159413333333326C32041CDCCCC4C399159419A999999F3C22041CDCCCC2C299159419A999999EDC22041666666262891594166666666E9C22041666666A62791594133333333E6C220419A9999F927915941CDCCCCCCE0C22041CDCCCC0C2891594166666666DBC22041333333D32791594100000000D8C22041333333532791594166666666D7C220419A9999D926915941CDCCCCCCCFC22041666666E62691594100000000BDC2204166666626279159419A99999982C12041CDCCCC8C2F9159419A99999970C1204166666606309159413333333319C12041000000603291594100000000B9C02041333333F334915941666666669FC02041000000A0359159413333333380C02041CDCCCC6C369159413333333319C0204133333333399159410000000017C02041666666E6389159413333333313C02041333333D3389159419A9999990FC02041666666E638915941CDCCCCCC0CC020416666662639915941CDCCCCCC06C02041000000E0389159419A999999E5BF2041CDCCCCAC3791594166666666B6BF204100000060359159413333333379BF204166666666329159413333333357BF2041CDCCCC8C319159413333333324BF20413333335331915941CDCCCCCC04BF204100000060319159410000000004BF2041CDCCCC0C319159416666666601BF2041CDCCCCAC309159419A999999FEBE204100000080309159419A999999F8BE2041000000C03091594166666666F7BE20419A9999193191594100000000F7BE2041666666863191594133333333EABE2041666666063291594100000000C9BE2041CDCCCC8C32915941333333339DBE20419A9999B9329159419A9999996EBE20419A99999932915941333333332ABE20410000000032915941CDCCCCCC03BE2041333333B33091594100000000F4BD2041666666263091594133333333DDBD2041333333132F91594100000000C7BD2041000000002E9159413333333391BD2041666666462A9159419A99999967BD2041333333F327915941000000003BBD20419A9999F9259159413333333309BD204100000020249159413333333389BC20419A999979209159416666666672BC2041333333D31F915941CDCCCCCC3EBC2041666666661E915941CDCCCCCCD8BB20419A9999991B91594166666666AFBB2041CDCCCC8C229159416666666680BB204133333393299159416666666627BB2041333333D3369159410000000005BB2041CDCCCC2C3D9159419A999999EEBA20419A9999194391594100000000D4BA20419A9999D94B915941CDCCCCCCD1BA2041CDCCCCAC4C91594100000000C3BA20416666664652915941CDCCCCCCB8BA2041666666465591594166666666ADBA2041666666A658915941CDCCCCCC76BA2041CDCCCC4C65915941CDCCCCCC6CBA2041CDCCCCAC679159416666666667BA20419A999999699159410000000065BA20419A9999F96B915941666666663EBA2041333333336C9159410000000037BA2041666666466C915941666666660BBA2041666666466C915941666666660BBA20419A9999796E9159413333333309BA204133333333749159413333333300BA2041CDCCCC4C7891594166666666C5B92041000000608791594133333333B1B920419A9999598D9159410000000079B92041000000208C9159419A99999918B92041333333338B9159413333333303B92041333333B38B915941CDCCCCCCF8B82041000000408C91594166666666D8B82041333333B38E9159419A999999CDB82041333333938F91594100000000C4B82041333333539091594166666666ACB82041CDCCCC4C909159419A99999923B820419A999979909159416666666601B820413333331391915941CDCCCCCCDAB7204133333333919159419A9999997EB720416666666691915941333333337DB72041000000E089915941333333337DB72041CDCCCCAC88915941000000007CB72041CDCCCCAC8591594133333333FFB62041CDCCCCCC84915941CDCCCCCCC6B620419A999999849159419A999999ACB62041000000A084915941CDCCCCCCA1B6204133333373849159419A9999999FB620419A999979889159413333333390B6204100000020889159419A9999998AB62041333333F3879159413333333374B620410000002086915941333333336DB620419A999959859159410000000068B620419A99993984915941333333331BB6204100000020809159419A99999903B62041CDCCCC2C7E91594100000000F2B52041333333137C91594166666666C9B520419A99999975915941CDCCCCCCB0B52041CDCCCC2C739159413333333398B5204133333333729159416666666688B5204100000020729159410000000077B5204166666686729159419A99999972B52041CDCCCCCC72915941666666665EB520413333333374915941CDCCCCCC4AB520413333339375915941	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	01010000206A080000E5F8EBBB14B9204100000010AB915941	370030102	H	Centre 1	3700301	37003	37	24	1
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	01010000206A080000CE04E856B9BB204134333383C1905941	370030104	H	Centre 2	3700301	37003	37	24	2
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	01060000206A08000001000000010300000001000000C40000009A999999FEBE204100000080309159413333333379BF204166666666329159419A999999E5BF2041CDCCCCAC379159413333333319C02041333333333991594100000000BDC2204166666626279159419A999999F3C22041CDCCCC2C299159413333333329C32041666666463A915941CDCCCCCC66C3204133333373479159410000000007C42041CDCCCCCC55915941000000001AC420419A9999F954915941000000004FC4204100000040479159410000000098C42041333333133C91594100000000FBC42041666666A6329159413333333384C52041CDCCCCEC2B915941333333330EC62041CDCCCC8C299159419A999999F5C62041666666A62691594100000000B6C8204166666686209159413333333300C92041CDCCCC6C21915941333333335EC920419A9999F9239159410000000077CA2041333333132D91594100000000FDCA2041CDCCCCAC2E915941CDCCCCCC4FCB2041333333D32D9159419A999999C3CB2041CDCCCCCC299159410000000093CC2041666666E61F9159419A999999D6CC20419A9999191A9159419A99999915CD204166666686169159413333333345CD2041666666861A91594133333333ADCD2041000000A0289159416666666648CE20410000006044915941000000007ECE2041CDCCCC4C5091594166666666B6CE2041333333B350915941CDCCCCCCD7CE2041666666A6599159413333333304CF2041CDCCCC2C69915941666666664FCF2041000000807A9159419A99999906D02041333333336C915941333333335DD020413333339361915941333333339AD020416666666655915941CDCCCCCCB9D02041666666E64C91594166666666CAD020419A9999F94491594166666666DDD02041333333932F915941CDCCCCCCDBD02041000000802191594100000000CCD220419A9999192C915941000000001CD32041000000C0309159416666666608D42041CDCCCC2CFC9059413333333336D62041333333B32291594133333333BED62041666666062B9159419A9999990BD72041333333D3239159413333333322D82041333333531F9159419A999999AAD820419A999939219159419A999999C4D82041CDCCCCCC22915941000000000ED920410000008019915941CDCCCCCC59D92041333333F315915941CDCCCCCC08DA2041000000C0149159419A999999DCDA20419A99995900915941CDCCCCCC09DB2041000000C0FC905941CDCCCCCC42DB20419A9999B9E2905941CDCCCCCCDADB2041000000C0DA9059419A999999B5DC2041666666A6C39059419A999999E5DC20419A999999B890594133333333FADC204100000000B790594100000000DEDD204100000080AA905941CDCCCCCC31DE2041CDCCCCECA99059419A999999D0DE20419A999939A49059410000000094DF20419A9999999F9059416666666624E02041000000009E90594100000000A3E020419A9999599A905941CDCCCCCC6AE12041000000408F9059419A999999D1E12041CDCCCCAC8A9059416666666629E220413333339385905941CDCCCCCCB9E22041666666267F905941666666665BE32041333333936A9059416666666633E3204100000060BF8F594100000000ACE32041666666E6AF8F594133333333BFE320419A9999998D8F5941666666663BE42041333333B37C8F59419A999999D5E420419A999979738F59416666666632E5204166666606758F59416666666637E52041333333B3618F59416666666631E5204100000000578F59419A99999945E5204133333313528F59410000000087E52041333333B3478F5941000000009CE5204100000060418F5941CDCCCCCCE2E52041666666063A8F59419A999999CDE52041333333932E8F59413333333388E520419A9999792F8F5941333333332CE520419A9999591C8F5941CDCCCCCCE3E4204133333373108F594133333333A1E420419A999939018F5941CDCCCCCC18E52041333333B3FB8E59416666666674E520419A9999D9F88E59413333333356E620419A9999B9F68E5941CDCCCCCCD5E62041666666E6F48E59413333333347E720419A999979F18E5941CDCCCCCC90E7204166666686ED8E5941666666662FE62041CDCCCC0C678E59419A9999997FE520419A9999B9248E5941333333336EE52041CDCCCCCC1C8E5941666666666DE42041000000E0BA8D5941666666662AE3204133333353408D59419A999999A9E220419A9999990E8D5941333333334AE2204133333333198D594133333333F6E12041666666E61B8D5941CDCCCCCC99E120419A9999791D8D59413333333353E12041666666E6288D5941333333335CE12041666666662B8D59419A99999922E12041333333932F8D59419A999999BBE02041333333D3338D5941333333333CE02041CDCCCC0C448D594100000000DBDF2041333333B3548D59419A9999999EDF2041CDCCCCAC5C8D59413333333358DE2041CDCCCC4C448D59416666666609DD204100000040338D5941CDCCCCCCC4DB2041000000002C8D5941CDCCCCCCA5DB2041333333532C8D5941CDCCCCCCA2DB20419A9999D9288D5941CDCCCCCCD4DA2041CDCCCC2C218D5941000000004EDA2041666666E6188D59416666666626DA204166666626158D5941666666664DD9204133333333FD8C5941000000000ED920419A999959018D5941CDCCCCCC9DD82041CDCCCC6C048D5941CDCCCCCCFDD720419A999939048D59419A9999991AD720419A999919EB8C59419A999999A8D62041666666E6FA8C594166666666ECD52041666666E6138D5941000000004BD52041333333932A8D59419A999999BAD4204100000060378D5941CDCCCCCC6CD42041CDCCCC0C3F8D59419A9999993DD42041CDCCCCCC458D59416666666671D320419A9999F93B8D59410000000028D3204100000020348D59413333333361D22041CDCCCCAC1A8D59419A99999938D22041666666C6168D594166666666D6D12041666666C6128D5941000000009AD12041000000E00A8D59419A99999976D12041CDCCCC6C048D59410000000012D120419A999979EA8C5941CDCCCCCCBFD02041666666A6DB8C59413333333338D02041666666C6DF8C5941CDCCCCCC26D0204133333353DF8C594100000000E4CF20419A999959EA8C59416666666630CF2041CDCCCCCCFB8C5941CDCCCCCC10CF204166666626038D59413333333373CE204133333393158D5941CDCCCCCCB7CD2041666666062A8D59419A9999999ECD2041666666A6308D5941666666669BCD204100000020378D59410000000086CD2041333333933D8D5941666666662FCD20419A999939478D5941666666665CCC20419A9999D9598D5941CDCCCCCC73CC2041CDCCCC4C658D5941CDCCCCCC6FCC2041000000E06E8D59419A99999957CC2041333333B3798D59419A99999924CC20419A999939848D59419A999999B0CB2041CDCCCCECA08D5941CDCCCCCC71CB204166666626AF8D5941666666663ACB2041CDCCCCACBE8D5941CDCCCCCC19CB2041CDCCCC8CCE8D59410000000008CB2041666666C6E08D5941CDCCCCCC02CB2041000000A0EF8D5941666666660ACB2041333333F3F68D5941CDCCCCCC41CB2041333333B3178E594166666666A3CB2041333333734D8E59413333333331CC2041CDCCCC6CAA8E5941CDCCCCCC50CC204166666606BC8E59419A999999E6CA204166666646EE8E594133333333BCC920419A999919178F59416666666670C920419A999959248F59419A999999FAC820419A9999F93F8F594100000000BFC82041000000C04A8F59419A9999992EC82041CDCCCC0C5F8F594166666666EDC720419A9999D9698F5941CDCCCCCC9EC72041CDCCCCCC788F59419A99999911C72041000000A0958F5941333333334EC62041CDCCCC2CB78F594133333333C0C5204133333393CE8F5941000000008AC520419A999939D88F59419A999999CFC42041333333B3049059419A9999997BC42041333333F30E9059419A999999E4C320419A999999129059410000000033C320419A9999F917905941333333333EC12041CDCCCCAC2B905941CDCCCCCCF2C020419A9999392E90594166666666E8C02041333333933B90594166666666A6C020419A999919549059419A99999975C02041000000E0619059419A99999902C0204100000060889059419A999999F7BF20419A999959929059410000000001C0204133333393A69059419A9999990FC0204133333393D490594166666666E3BF2041CDCCCCACE290594100000000F0BF2041666666C6F09059419A999999DABF2041CDCCCCCCF8905941666666665BBF2041CDCCCC6C119159419A999999FEBE204100000080309159419A999999FEBE20410000008030915941	01010000206A080000EC650DFC61D72041343333332A8F5941	370030103	H	Est-Sud Est	3700301	37003	37	24	15
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	01010000206A080000E45412D80DB52041666666968A8F5941	370030105	H	Ouest Sud-Ouest	3700301	37003	37	24	17
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	01010000206A080000F884C9A830441E41CCCCCCFC09755941	370040000	Z	Anché	3700400	37004	37	24	8
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	01010000206A0800003E79582828621F413333334311635941	370050000	Z	Antogny-le-Tillac	3700500	37005	37	24	17
01060000206A08000001000000010300000001000000B40300009A9999994F671F41000000A0878459419A99999971671F410000006089845941000000008E671F419A9999198C84594166666666B6671F41CDCCCCEC9184594166666666CC671F41666666A69984594100000000DA671F419A9999D9A084594166666666EC671F41CDCCCCCCA4845941CDCCCCCCF6671F41666666E6A68459416666666652681F419A9999B9B3845941666666666E681F4166666626B684594100000000A4681F4100000080B8845941CDCCCCCC08691F41CDCCCCECBB8459419A999999A3691F41000000E0C1845941CDCCCCCC046A1F4100000000C68459419A9999999F6A1F4166666666CB8459419A999999376B1F4133333333D0845941CDCCCCCCBA6B1F41666666E6D58459419A999999F16B1F4166666686D78459419A999999C96C1F4100000080DB8459419A999999EB6C1F419A999999DC845941CDCCCCCCFA6C1F41CDCCCCACDD845941666666661C6D1F4133333313E084594166666666C46D1F419A999999E3845941CDCCCCCC286E1F41CDCCCC4CE6845941CDCCCCCC686E1F419A999979E984594100000000D86E1F41666666A6EF8459419A999999F36E1F4133333333F18459419A9999992B6F1F4133333373F5845941666666664A6F1F41CDCCCC6CF9845941CDCCCCCC966F1F419A999919FB84594100000000B86F1F41000000E0FB84594100000000D06F1F41CDCCCCECFC845941CDCCCCCCD86F1F41333333B3FD84594100000000D86F1F41CDCCCC2CFE84594166666666D66F1F4133333373FF845941CDCCCCCCC66F1F41CDCCCC0C0285594166666666B26F1F41333333F306855941CDCCCCCCA26F1F41CDCCCC2C0C85594166666666A06F1F419A9999B91085594166666666A66F1F41666666061385594133333333B36F1F41666666E614855941CDCCCCCCD46F1F41333333731885594100000000E06F1F41666666A619855941000000002E701F41CDCCCCAC1D855941CDCCCCCCD0701F419A999979248559419A99999967711F419A9999D9298559416666666684711F41666666E62A855941000000008E711F419A9999392B855941333333331F721F41CDCCCC4C3085594100000000B2721F41CDCCCCCC348559410000000028741F419A9999F93E8559419A9999999B741F419A999979428559419A999999CB741F41CDCCCC8C4485594100000000F8741F419A999919488559419A99999935751F41CDCCCC0C4D8559413333333355751F410000004050855941333333335B751F41333333B3508559416666666696751F41666666265585594166666666B4751F4100000060578559419A999999C7761F419A9999B96785594133333333FD761F41CDCCCCEC6A8559413333333317771F419A9999796C8559416666666656771F41333333F36F855941666666666C771F41333333F370855941CDCCCCCC10781F419A9999B9788559419A9999992B791F41333333738585594166666666287A1F41333333D390855941333333337F7A1F419A9999F99385594100000000F07A1F410000008097855941666666662A7B1F41666666C69885594166666666667B1F41333333139A8559419A999999B97C1F41333333D39F8559419A999999037D1F41666666A6A185594100000000827D1F4100000020A585594100000000227E1F4100000020AB85594133333333A77E1F41CDCCCCACB185594166666666DE7E1F41CDCCCCECB485594133333333177F1F41333333D3B885594133333333537F1F4166666686BD85594166666666567F1F4166666626BE8559419A99999945801F41000000E0CE8559416666666660811F4133333373E18559416666666664811F4100000020E2855941CDCCCCCCB8811F4166666626E685594100000000E2811F41666666A6E88559410000000050821F4166666686EF85594166666666A6821F41000000A0F6855941CDCCCCCCEA821F4166666666FD8559413333333337831F410000000008865941CDCCCCCC40831F41666666A60A8659416666666686831F419A9999791E86594133333333A9831F41CDCCCCCC248659419A999999D5831F41666666662B865941333333330F841F419A9999F9328659416666666688841F419A9999F93F86594133333333D7841F41000000C04A8659410000000016851F41CDCCCC6C528659410000000030851F4133333393558659413333333345851F41333333D357865941CDCCCCCC0C861F4100000020668659419A99999951861F41CDCCCCAC6B8659416666666676861F419A9999996F865941666666661C871F41333333136C86594166666666BE881F419A9999596686594100000000C6881F4166666626668659413333333393891F41000000006486594100000000BA891F419A9999996286594100000000C4891F41333333D36586594133333333DD891F419A9999196E86594166666666128A1F419A9999797C865941CDCCCCCC308A1F41000000208686594100000000568A1F41000000809086594166666666A48A1F419A9999D9A5865941CDCCCCCCB48A1F4166666646AA865941CDCCCCCCC08A1F41666666C6B086594133333333C78A1F419A999999BB86594166666666C88A1F419A9999D9C486594100000000288B1F4166666626D186594166666666CC8B1F41000000A0E78659419A999999418C1F419A9999B9F086594166666666A08D1F41666666460187594100000000E08B1F41333333B345875941CDCCCCCC2E8C1F41666666264A87594133333333598C1F41CDCCCC6C4E875941CDCCCCCC648C1F41333333734F87594100000000E48C1F419A9999595687594166666666168D1F4133333393588759419A999999A58D1F41000000405D87594166666666D48D1F41666666C65E875941333333333F8E1F419A99993962875941CDCCCCCC6A8E1F419A99995963875941CDCCCCCCA08E1F413333337365875941000000005A8F1F419A999999708759419A999999798F1F41000000007387594166666666DC8F1F4166666646798759419A99999931901F41CDCCCC0C7E875941CDCCCCCC6A901F4133333373818759419A9999997D901F41CDCCCC4C808759419A999999A1901F41333333937F875941CDCCCCCCBE921F419A9999F979875941CDCCCCCCE8921F41000000A079875941666666666E931F410000008078875941CDCCCCCC4E941F41000000A07687594133333333BF951F4100000020758759419A99999997961F41666666A67487594133333333B5961F419A9999F9748759419A9999993B981F41000000E0788759419A999999A5981F41666666C67987594133333333EF981F41CDCCCC8C79875941CDCCCCCC12991F413333331379875941CDCCCCCC6E991F4166666626778759419A999999D1991F41666666867587594133333333E9991F41CDCCCC6C7587594100000000C69B1F41000000E07687594166666666289D1F4166666606788759419A999999919D1F41333333F3778759419A999999D19D1F41333333F37687594166666666129F1F41000000E06E87594133333333FF9F1F419A999999698759419A999999C1A01F419A9999196587594100000000A2A11F4100000060608759419A99999973A21F41000000805C87594133333333A9A21F41CDCCCC8C5B87594166666666FAA31F413333331357875941CDCCCCCCACA51F41333333F3548759410000000050A61F419A9999D9538759419A99999977A71F419A9999D951875941CDCCCCCC6AAA1F41333333B34C8759413333333343AB1F41CDCCCCEC47875941CDCCCCCC76AC1F41CDCCCC4C40875941CDCCCCCC3CAD1F41333333133B8759413333333373AD1F41666666A6398759416666666614AF1F419A9999392D8759413333333361AF1F419A9999592C875941333333338FAF1F41000000202C87594166666666F0AF1F41CDCCCC0C39875941666666660CB01F419A9999193C875941CDCCCCCC28B01F41333333333F8759419A99999959B01F41CDCCCC8C4387594133333333AFB01F4100000060498759416666666606B11F41666666A64D875941000000004CB11F419A9999B9508759419A999999B1B11F41CDCCCC2C548759419A99999907B21F4166666666568759419A99999955B21F41000000E056875941333333336DB21F41CDCCCCCC5687594133333333CDB21F4133333393568759416666666636B31F41CDCCCCEC55875941CDCCCCCCCEB31F41CDCCCCAC55875941000000002EB41F4133333373558759419A999999ABB41F41CDCCCC8C56875941000000000EB61F41CDCCCC2C5887594166666666BEB61F41000000A0588759410000000010B71F419A999999588759416666666658B71F419A9999D957875941000000008EB71F41666666E656875941CDCCCCCCB8B71F410000000056875941CDCCCCCCE6B71F41CDCCCCCC53875941CDCCCCCC40B81F41333333F34F8759410000000092B81F419A9999794D87594166666666E6B81F41666666E64B87594166666666C6B91F41CDCCCCCC478759410000000074BA1F419A999939458759419A99999961BA1F419A9999393B875941CDCCCCCC44BA1F41CDCCCCCC08875941CDCCCCCC22BA1F419A999979CC865941333333331DBA1F41CDCCCCCCC1865941000000000CBA1F4133333373A08659419A999999FFB91F41333333739B86594133333333F9B91F41666666C698865941CDCCCCCCF6B91F41000000409386594166666666ECB91F41666666468C8659419A999999E5B91F41333333737D8659419A999999E5B91F41000000C073865941666666661CB51F41CDCCCC6C888659410000000064B41F41CDCCCCAC67865941333333334DB41F41CDCCCCAC638659413333333337B41F41000000C05F8659419A99999913B41F41CDCCCC2C5A8659413333333397B31F41000000A04686594100000000C2B31F4133333373448659410000000038B41F41333333133F8659413333333339B61F419A9999F931865941CDCCCCCCB4B51F41666666C61D865941000000005EB41F41000000E0E78559419A99999971B31F419A9999B9C28559419A99999995B21F4166666666BA855941CDCCCCCCC8B11F419A999959A08559410000000008B21F41000000C09D8559413333333377B21F41666666A6968559416666666632B31F4166666626898559413333333367B31F41333333D38385594100000000B2B31F41333333737A85594166666666BCB31F41666666C679855941CDCCCCCCE6B31F41333333D376855941CDCCCCCC6EB41F419A9999796F855941CDCCCCCC0AB51F41333333336A855941CDCCCCCC18B51F4133333373698559419A999999A1B51F41CDCCCC2C628559410000000024B61F41CDCCCCCC5A855941CDCCCCCC50B61F41CDCCCCEC5A855941CDCCCCCC78B61F41000000C05A855941CDCCCCCC9CB61F41CDCCCC2C5A85594166666666F4B61F41000000C0588559410000000028B71F419A999919578559419A99999947B71F419A999919568559419A9999996FB71F419A9999B954855941666666668EB71F41666666A653855941CDCCCCCC36B71F41CDCCCC2C4B8559419A99999923B71F419A9999194B85594166666666EEB61F41333333D34A85594166666666E2B61F419A9999994A8559410000000082B61F413333335343855941CDCCCCCC4EB61F41CDCCCC6C3F8559410000000034B61F41666666464085594166666666ECB51F413333335340855941CDCCCCCC5CB51F41CDCCCC8C3D85594133333333C7B41F419A999959388559410000000066B41F41CDCCCC6C328559419A9999990FB41F41333333132D85594100000000B4B31F41000000E0298559416666666652B31F41000000E0278559419A9999998FB21F413333339327855941CDCCCCCC9EB11F41333333D3228559419A9999990BB11F41666666061F85594166666666E8B01F41CDCCCC0C1E8559416666666610B01F416666660614855941333333338DAF1F41333333F3098559413333333317AF1F41666666A6FF84594133333333BDAE1F41333333F3F28459413333333385AE1F4166666606EB845941CDCCCCCC22AE1F4166666686E084594166666666C0AD1F41CDCCCC4CDB8459419A9999996BAD1F419A999979D68459413333333383AC1F4100000040B18459410000000040AC1F419A999979A38459410000000032AC1F4166666686988459410000000002AC1F41CDCCCCAC8A845941CDCCCCCC40AC1F419A999959888459419A999999B5AD1F41666666C67E84594166666666C8AD1F41CDCCCC4C7E84594166666666F6AD1F4166666666818459419A99999935AF1F41000000407A84594100000000CAAE1F41000000805F8459419A999999B5AE1F41333333535A8459416666666682AE1F41666666C64E8459419A9999995BAE1F41000000C044845941000000001EAE1F41333333D3348459416666666608AE1F419A9999592F84594166666666FCB01F41CDCCCC6CF28359413333333307B11F41CDCCCCECF28359419A999999A3B11F4166666666FB835941CDCCCCCCE6B11F41CDCCCC6CFE8359419A999999FFB11F4166666666FF835941333333331BB21F41333333730084594166666666CAB21F419A9999F905845941333333339BB31F41CDCCCC8C0C84594133333333C9B31F41333333530E84594133333333DDB31F41333333330884594100000000E6B31F419A999959FD83594166666666FAB31F41CDCCCCACEF8359416666666604B41F41CDCCCC0CE88359413333333307B41F419A999999E28359419A999999FDB31F4133333393DB83594100000000E8B31F41000000E0D783594133333333C9B31F41333333F3D383594100000000ACB31F419A999919D1835941000000009AB31F4166666666CF8359419A99999981B31F4133333393CD83594133333333E3B21F41000000A0A2835941000000002CB21F419A9999D97583594100000000FAB21F41CDCCCCAC6B8359419A99999955B31F41666666E666835941CDCCCCCC90B31F419A9999D9638359419A99999915B41F41333333535C83594100000000D0B41F41666666E650835941000000001AB51F41CDCCCC0C4C8359416666666636B51F41333333B34A8359419A9999994BB51F419A9999B9498359410000000082B51F416666664646835941CDCCCCCCFAB51F410000002040835941666666663AB61F419A9999393C8359410000000038B71F41666666C6258359419A99999973B71F419A9999F91E83594100000000B0B71F41CDCCCC0C1983594133333333D9B71F41CDCCCC8C148359416666666606B81F419A99997910835941000000009CB81F41CDCCCC4C0883594166666666ACB81F4166666666078359410000000022B91F41000000A005835941666666665CB91F41CDCCCCCC058359410000000092BA1F41CDCCCC6C0B8359416666666600BB1F41333333330D8359419A9999991BBB1F41666666260D8359416666666692BB1F41CDCCCC4C0B8359413333333331BC1F41CDCCCCEC078359416666666646BC1F41000000C0078359419A999999D3BC1F410000008004835941CDCCCCCC14BD1F41666666860383594100000000D6BD1F41666666E6FF825941CDCCCCCCE6BD1F4133333393FF82594100000000C0BE1F4133333313FB8259416666666618BF1F4100000040FA825941666666669ABF1F41000000E0F98259413333333399C01F4133333333F98259419A999999D1C01F4166666646F98259416666666644C11F4166666626FB825941666666664EC11F419A999979F78259419A9999995BC11F419A999999F3825941000000006CC11F4100000040E9825941666666667CC11F41CDCCCCACE5825941666666668EC11F41CDCCCC8CE382594133333333B3C11F419A999999DC8259419A999999D1C21F41CDCCCC4CD48259419A999999F7C11F41666666C6C582594133333333D3C11F41CDCCCC2CC38259419A999999ABC11F419A999959C0825941666666669EC11F41000000A0BE825941000000009EC11F4100000040BE8259419A9999999BC11F41333333B3BC8259419A999999C1C11F4100000060B2825941CDCCCCCCC4C11F41CDCCCC6CB182594100000000DAC11F41666666E6B18259413333333311C21F4133333373B3825941CDCCCCCC44C21F4100000000B48259419A9999995BC21F41CDCCCC8CB4825941666666665EC21F419A999979B68259419A99999959C21F4100000020B8825941666666666AC21F4100000060B9825941CDCCCCCCF4C21F419A999999BB825941333333330BC31F419A999919BD8259419A9999995DC31F41CDCCCC8CC78259413333333383C31F419A9999F9C88259419A999999B9C31F41CDCCCC0CC9825941CDCCCCCC28C41F4133333333C9825941CDCCCCCC3EC41F41333333F3BC825941CDCCCCCC54C51F4166666646C2825941CDCCCCCCE4C51F41CDCCCC0CBD8259410000000030C61F41000000E0AE82594100000000C4C61F419A999919AC82594100000000F2C61F41000000A0A08259419A999999EFC61F41CDCCCCCC9F82594166666666E4C61F413333331393825941CDCCCCCCEAC61F41CDCCCC0C8B82594133333333EBC61F41333333538A8259416666666608C71F419A99999981825941CDCCCCCC04C71F419A9999B97D8259413333333305C71F41666666C6778259419A999999EFC61F41CDCCCCCC748259410000000092C61F41CDCCCC2C708259410000000054C61F41000000C06D825941CDCCCCCC30C61F41666666466D8259416666666628C61F4166666606678259410000000020C61F41000000405D825941333333332BC61F41CDCCCCAC57825941000000002AC61F41000000A04F825941CDCCCCCC00C61F41000000E04A8259419A999999CFC51F41000000E04782594100000000F0C51F410000008043825941666666660AC61F419A9999593D8259410000000014C61F419A9999D939825941CDCCCCCC12C61F410000004030825941666666660CC61F41333333B32C82594100000000F8C51F41666666A6268259416666666624C61F41333333131F8259416666666624C61F41CDCCCC0C1C8259413333333315C61F41666666C618825941CDCCCCCC02C61F4133333353128259419A99999901C61F41666666860F8259416666666608C61F41333333B30C8259419A99999905C61F41CDCCCC0C0A8259419A999999F9C51F41333333130782594166666666F4C51F41333333D3058259419A9999991DC61F41CDCCCCCC01825941666666669AC61F41CDCCCC6CFA8159410000000000C71F4133333313F58159413333333327C71F41CDCCCC8CF38159410000000058C71F41CDCCCC6CEE8159416666666688C71F41CDCCCCECEB81594133333333B7C71F4166666686EA81594133333333EBC71F4100000020EA815941000000002AC81F41CDCCCC4CEA815941CDCCCCCC58C81F419A9999B9E9815941CDCCCCCC7AC81F41CDCCCCCCE781594100000000B8C81F41CDCCCCCCDF81594133333333DFC81F4133333393D981594100000000FCC81F4166666606D88159419A99999919C91F41666666E6D6815941CDCCCCCC6AC91F419A999999CC815941CDCCCCCC8CC91F41000000A0CA81594166666666C2C91F41333333F3C881594166666666E4C91F41CDCCCCCCC68159416666666600CA1F41CDCCCC4CC4815941000000000ACA1F4100000080C18159419A99999911CA1F419A9999F9BA815941666666661ECA1F4166666666B88159410000000022CA1F4133333393B7815941000000004ACA1F419A9999F9B581594133333333BDCA1F41CDCCCC4CB581594166666666EECA1F419A999959B4815941333333330BCB1F419A999979B3815941000000005CCB1F4166666606B18159410000000088CB1F41CDCCCC2CB081594100000000BECB1F41000000C0AF81594133333333E1CB1F419A999999AD81594166666666F2CB1F4133333313AB81594133333333F7CB1F4133333333A881594100000000CECB1F419A9999999C8159419A999999CBCB1F41CDCCCCCC9981594100000000BCCB1F4166666666968159419A9999999DCB1F41000000A0938159419A99999925CB1F41666666268D815941333333330FCB1F419A9999B9898159410000000000CB1F41CDCCCC0C8681594166666666F6CA1F41666666068281594133333333D9CA1F419A9999D97981594166666666D4CA1F41CDCCCC6C7281594166666666D8CA1F41000000406F81594100000000E6CA1F419A9999196C8159419A9999990BCB1F4100000060658159419A9999992BCB1F41666666E661815941000000004ECB1F419A9999595F8159410000000078CB1F41000000405D815941CDCCCCCC08CC1F41CDCCCCAC598159410000000068CC1F41000000E05781594166666666CCCC1F41CDCCCC4C55815941CDCCCCCC12CD1F419A99999951815941666666663ECD1F41333333134D8159419A9999997FCD1F416666664649815941CDCCCCCCBECD1F41000000A046815941CDCCCCCCD6CD1F41000000204581594133333333E1CD1F41666666C643815941CDCCCCCCEACD1F41000000204281594133333333E5CD1F41666666464081594100000000D4CD1F41000000A03F81594100000000A2CD1F419A9999D9408159413333333395CD1F41000000C040815941333333338DCD1F41000000E03F8159419A99999989CD1F419A9999793E8159413333333387CD1F41666666463C815941333333338BCD1F41666666663A815941333333339BCD1F41CDCCCC0C3981594100000000BACD1F419A999959378159419A999999C5CD1F419A9999F935815941CDCCCCCCBECD1F4133333373348159410000000094CD1F41666666E632815941666666667ACD1F4166666686318159413333333373CD1F419A9999592F8159413333333375CD1F41000000002E815941CDCCCCCC82CD1F41333333732C81594100000000BECD1F419A9999792981594133333333E1CD1F4166666666298159416666666626CE1F41000000E02981594100000000C0CE1F41000000202C81594133333333F3CE1F419A9999992B8159419A99999943CF1F413333331329815941CDCCCCCC56CF1F41333333F328815941666666666ACF1F419A99993929815941CDCCCCCCA0CF1F41666666862A81594166666666D8CF1F41CDCCCCAC2C81594166666666F6CF1F419A9999B92E8159419A9999990FD01F41CDCCCCCC318159419A99999941D01F41CDCCCCCC33815941CDCCCCCC62D01F419A9999B9358159419A99999977D01F416666666636815941000000008CD01F41666666E635815941CDCCCCCCBCD01F4133333353378159419A999999CBD01F41666666263781594133333333D9D01F41CDCCCC6C36815941CDCCCCCCEAD01F41000000A0338159413333333321D11F4166666606318159416666666642D11F4133333393308159416666666672D11F41CDCCCC2C2F81594100000000A0D11F41333333F32F8159419A999999B9D11F41666666C62F8159413333333307D21F41333333532D815941666666662AD21F41333333732B815941CDCCCCCCE0D11F410000006025815941000000004CD11F41CDCCCC6C1A8159419A99999919D11F41666666261681594133333333D3D01F41CDCCCC2C118159419A999999BFD01F41333333D30F815941CDCCCCCC78D01F416666662609815941CDCCCCCC4AD01F41666666460581594133333333EBCF1F4166666646FE80594166666666E8CF1F4166666606FE805941000000008ACF1F4100000040F5805941666666664ACF1F41333333D3EE8059410000000032CF1F4133333353EA8059419A9999992DCF1F41CDCCCC6CE48059419A99999941CF1F4166666606D9805941CDCCCCCC52CF1F41666666C6D2805941CDCCCCCC6ACF1F41CDCCCCECCE805941CDCCCCCC7CCF1F4100000040CD8059419A999999ADCF1F41333333B3C78059419A999999BBCF1F41CDCCCC0CC380594166666666C4CF1F4166666646BB80594166666666BCCF1F4166666606B58059419A999999A3CF1F419A9999B9A980594133333333A1CF1F41666666669E80594100000000B4CF1F419A999999998059419A999999BBCF1F41333333739280594100000000BCCE1F41000000609580594133333333A7CE1F41000000E095805941333333331FCE1F41000000809880594100000000C4CD1F41333333B39B8059419A9999998FCD1F41000000A094805941CDCCCCCC06CD1F416666660697805941000000003ACB1F41666666669E805941CDCCCCCC26CB1F41666666C6998059410000000086C91F419A999939A280594100000000A0C91F419A9999F9A88059413333333367C81F41666666C6AC805941000000009EC81F4100000000C28059419A999999A3C81F4166666646C480594166666666D0C81F41CDCCCC0CD780594133333333F9C81F4166666606E58059419A999999FBC81F4166666646E780594166666666F0C81F419A9999F9E8805941CDCCCCCCC6C81F41CDCCCC0CE8805941CDCCCCCC8AC81F4166666646E78059410000000054C81F4133333393E680594133333333C3C71F41CDCCCC0CE4805941000000008AC71F4100000040E2805941666666664CC71F4166666686DF80594100000000F4C61F419A999939DC805941CDCCCCCCA4C61F4100000000DA805941CDCCCCCC48C61F4100000040D880594133333333ADC51F419A9999B9D68059410000000050C51F41000000E0D680594166666666F4C41F4166666686D780594166666666D4C41F4100000020D880594100000000BCC41F4100000000D98059419A999999AFC41F4133333333DA80594166666666AAC41F419A9999F9DA8059419A99999997C41F4166666646DC8059416666666670C41F4166666646DD8059413333333327C11F41CDCCCCACE68059419A999999ABC01F41CDCCCC2CE980594133333333AFC01F419A9999F9EC80594133333333F7C01F4166666646FF8059413333333317C11F416666662605815941666666664AC11F419A9999190C81594100000000A0C11F419A9999B914815941CDCCCCCCCEC11F413333339318815941CDCCCCCCF2C11F419A9999791C815941CDCCCCCC22C21F419A9999B921815941666666666AC21F41000000E02A8159419A9999999DC21F41CDCCCCEC328159419A999999C1C21F419A9999793A81594100000000DCC21F419A9999793F8159419A999999F9C21F41333333D3468159413333333309C31F4100000040498159416666666644C31F419A9999594F815941CDCCCCCC82C31F41333333B3548159410000000090C31F41000000E05581594100000000C0C31F419A9999B95A815941CDCCCCCCCEC31F41333333335D81594166666666D2C31F41000000405F81594100000000CAC31F419A9999B96381594133333333EDC11F41000000C0648159419A9999999DB71F41CDCCCC6C6A815941CDCCCCCCA8B71F41000000E0668159419A999999BDB71F41333333735B81594100000000BAB71F419A9999195681594166666666A0B71F4166666646448159419A99999995B71F41000000003881594166666666AAB71F410000004029815941CDCCCCCCC2B71F419A9999B920815941CDCCCCCCDCB71F41666666E619815941CDCCCCCC44B81F41CDCCCCEC078159419A9999995BB81F410000000004815941000000005EB81F41CDCCCC6C038159410000000068B81F416666662601815941CDCCCCCC7EB81F41CDCCCCACFB8059419A99999997B81F4166666626F28059416666666692B81F41666666C6EA8059419A99999969B81F4100000000DC8059413333333353B81F4133333313CB8059410000000054B81F41333333F3C88059410000000050B81F4166666686C58059413333333345B81F41CDCCCCACC48059413333333337B81F41333333B3C2805941333333330FB81F41CDCCCCECB880594100000000E6B71F419A9999B9AB80594100000000E4B71F4133333393AA805941CDCCCCCCDEB71F41333333F3A78059419A999999DBB71F41333333939F80594166666666E4B71F41000000A09B8059410000000010B81F419A9999798F805941CDCCCCCC10B81F41333333338E805941CDCCCCCC12B81F41CDCCCC2C8B8059419A99999907B81F41666666A6828059419A99999901B81F41333333737F8059410000000000B81F41666666A67E80594100000000E6B71F41666666E6708059419A999999E5B71F41666666C6708059419A999999CFB71F41CDCCCC0C6D805941CDCCCCCCB0B71F419A9999F9698059413333333341B71F41333333736180594133333333B5B61F410000008051805941333333339FB61F41333333B34F8059419A99999971B61F41CDCCCC4C4D805941333333335FB61F416666664650805941000000002CB61F413333337357805941CDCCCCCCE0B51F41333333735E805941666666663CB51F41CDCCCC6C6A805941CDCCCCCC54B41F41000000407B805941CDCCCCCC0EB41F41000000208C8059419A999999EFB31F41CDCCCCCC94805941CDCCCCCC9CB31F41CDCCCCCCAB8059419A9999998DB31F4133333373B1805941333333334DB31F419A999999B2805941CDCCCCCC7CB21F41333333F3B880594166666666E2B11F4133333393BA805941666666665EB11F41CDCCCCACBD80594133333333F3B01F41333333D3C18059416666666648B01F419A999999CA8059419A99999921B01F419A9999D9CC80594166666666FAAF1F4133333393D080594166666666B2AF1F41CDCCCCCCD8805941CDCCCCCC68AF1F41000000A0E2805941333333334DAF1F41CDCCCCACE68059419A999999E1AE1F41CDCCCCECFD80594100000000C2AE1F4100000000028159419A99999999AE1F41666666C6058159416666666660AE1F419A999919098159419A9999997BAD1F4133333393128159410000000042AD1F4133333353158159410000000022AD1F419A99995917815941CDCCCCCC0EAD1F41CDCCCCCC188159419A999999E1AC1F41666666A61D8159419A999999BBAC1F4100000000238159413333333379AC1F41CDCCCC4C2A8159410000000040AC1F41000000602E81594100000000BEAB1F419A9999F932815941CDCCCCCC32AB1F41666666E636815941000000000EAB1F41333333F337815941CDCCCCCC8EAA1F419A9999793C815941CDCCCCCC66AA1F419A9999193E815941666666663CAA1F41666666664081594100000000E0A91F41CDCCCCEC46815941CDCCCCCC34A91F41666666A656815941000000000EA91F41000000405B81594166666666B4A81F419A99991962815941666666665CA81F419A9999B9678159419A999999DBA71F41333333536E8159416666666662A71F419A999939738159416666666658A61F41CDCCCCAC79815941CDCCCCCCCCA51F41000000807C81594133333333D9A41F41333333937F8159419A9999996DA41F410000004081815941CDCCCCCC0AA41F41333333138281594100000000B4A31F4166666646838159413333333365A31F419A9999D98481594166666666C8A21F41666666E6898159410000000092A21F419A9999F98A815941666666666CA21F41CDCCCCEC8D8159419A9999992FA21F41000000A09181594166666666DEA11F4100000000948159419A99999993A11F41666666E6968159419A9999992FA11F419A99995999815941333333330BA11F41CDCCCCEC9A8159416666666694A01F41CDCCCC0CA08159413333333351A01F41CDCCCCECA38159419A999999D59F1F41CDCCCCACAC81594166666666AE9F1F41CDCCCC6CAF81594166666666789F1F419A999979B2815941CDCCCCCCB89E1F41333333F3BE8159419A999999459E1F4166666626C481594133333333BD9D1F41333333B3C881594100000000EC9C1F4166666646CE815941CDCCCCCC989C1F4133333393D081594166666666D69A1F419A9999D9DE815941000000000E9A1F4133333333E78159410000000078991F419A999979ED8159413333333327991F41CDCCCCCCF1815941CDCCCCCC16991F41333333B3F28159419A999999C1981F41000000E0F78159416666666682981F41000000A0FC8159419A99999947981F413333331302825941333333332B981F41666666C604825941000000000E981F41000000A0078259419A99999985971F41CDCCCCAC008259419A9999996D971F41CDCCCC6CFF81594100000000B6961F419A999959F28159413333333371961F4133333373ED8159419A99999949961F41CDCCCC2CEC8159413333333323961F4100000040ED8159419A999999D7951F41000000E0ED81594133333333C1951F41CDCCCC6CEE815941CDCCCCCCB0951F4100000060F081594166666666B0951F419A9999D9F381594166666666A4951F4133333333F58159419A99999991951F4100000040F68159416666666682951F41CDCCCCACF6815941000000007C951F41CDCCCCACF68159413333333329951F419A9999B9F68159413333333315951F41000000C0F681594166666666E0941F41000000A0F7815941CDCCCCCCAE941F419A9999D9FA815941666666667A941F4166666666FF8159413333333355941F41666666A6018259410000000038941F41CDCCCCAC02825941333333330F941F419A9999D902825941CDCCCCCCFE931F41666666E6028259419A999999E5931F4100000080038259419A999999C7931F416666668605825941666666664C931F41CDCCCC8C0A82594100000000D6921F419A99993913825941CDCCCCCCA8921F413333331316825941000000008E921F41333333B3198259419A99999963921F41000000E01C8259416666666648921F419A9999D91E8259416666666630921F41CDCCCCEC1F82594133333333D1911F41333333F3218259419A99999993911F4100000040248259416666666608911F41000000402D82594133333333F3901F419A9999F92E825941CDCCCCCCD8901F41333333B3348259419A999999AD901F41000000C0388259419A99999955901F41666666063C825941CDCCCCCC44901F41666666063E8259410000000004901F4166666646428259419A999999E18F1F41666666E64282594166666666A08F1F419A999919448259419A999999578F1F41000000E04582594100000000388F1F419A999919478259419A999999298F1F419A9999194982594133333333218F1F41666666C64B825941666666661C8F1F419A9999394D82594166666666E48E1F41CDCCCC0C5582594133333333DF8E1F41CDCCCCCC5982594133333333D18E1F41000000005C825941000000009C8E1F41000000806182594133333333658E1F41000000E06582594166666666568E1F416666660667825941333333333F8E1F413333337369825941CDCCCCCC228E1F41666666666C825941CDCCCCCCFA8D1F419A9999796F825941CDCCCCCCDA8D1F41333333F37082594166666666D48D1F41000000407182594100000000A08D1F41CDCCCCAC7282594166666666848D1F41666666867482594100000000628D1F410000002076825941000000004A8D1F419A9999D97682594100000000208D1F41666666467782594166666666F08C1F41333333737682594133333333D58C1F41666666E67482594166666666C48C1F41CDCCCCEC7382594166666666B68C1F410000008073825941CDCCCCCC5E8C1F4133333353728259419A9999993F8C1F4133333373728259419A9999992B8C1F41333333F3728259419A9999990D8C1F41333333937482594133333333B78B1F41333333137C8259419A999999818B1F41333333B37E825941000000007A8B1F419A9999197F825941CDCCCCCC6E8B1F419A9999D97F82594133333333698B1F41333333338082594133333333658B1F419A9999798082594133333333578B1F41333333738182594133333333278B1F419A9999D984825941CDCCCCCC148B1F41CDCCCC6C86825941CDCCCCCC108B1F41666666C686825941000000000E8B1F41CDCCCC0C8782594100000000F88A1F41000000008982594166666666C48A1F41333333B38C82594133333333C38A1F41333333938E825941CDCCCCCCC88A1F41CDCCCC6C9082594166666666E88A1F41CDCCCCEC93825941CDCCCCCCEA8A1F419A9999F99482594166666666E68A1F41666666E69582594133333333E38A1F419A99999996825941CDCCCCCCD88A1F41000000209782594166666666728A1F41CDCCCC8C998259419A999999538A1F419A9999D99A82594166666666448A1F41666666069C8259419A9999993F8A1F41333333B39C825941000000003E8A1F4100000080A08259419A999999098A1F41000000E0A7825941CDCCCCCCDC891F41666666A6AF8259419A999999D5891F41666666E6B182594166666666DE891F4133333373B3825941CDCCCCCCE6891F41000000A0B582594166666666128A1F419A9999F9B882594100000000188A1F41CDCCCC6CBA82594166666666148A1F41333333F3BB82594166666666F6891F4133333313C0825941CDCCCCCCFA891F41CDCCCC8CC3825941CDCCCCCCD0891F41000000A0CF82594133333333F7891F41666666A6D3825941666666660E8A1F4133333333D682594166666666288A1F419A999939D98259419A9999994B8A1F4133333393DD82594133333333558A1F419A999999DE825941666666665C8A1F419A999959DF825941CDCCCCCC6A8A1F41CDCCCC0CE1825941666666667E8A1F419A999959E38259419A999999A18A1F4133333373E78259419A999999DF8A1F41666666C6EE82594133333333F18A1F41666666A6F082594100000000608B1F41333333F3FC82594100000000AC8B1F41333333D30583594100000000F68B1F41CDCCCCCC0D835941666666663C8D1F41666666A63283594166666666688D1F41666666863683594133333333ED8B1F41CDCCCC4C3F8359419A9999990F8B1F41CDCCCC6C44835941CDCCCCCCBC8A1F41000000006C83594166666666908A1F419A99995979835941CDCCCCCC408A1F41CDCCCC0C8C835941666666662E8A1F419A9999D98D8359419A99999951881F4133333393C08359419A9999994F881F41666666E6C1835941666666663E881F4100000060D08359416666666630881F4133333313D7835941CDCCCCCC04881F4166666666F9835941CDCCCCCCDE871F41666666C61984594166666666CC871F4166666646248459419A9999999D871F41000000A04984594133333333A1871F41000000604C845941333333330B861F41CDCCCC0C578459413333333313851F41333333F35D8459413333333397841F41333333F3618459419A9999997B841F410000002062845941CDCCCCCCFC831F419A9999D961845941CDCCCCCC00831F41333333F35E845941CDCCCCCC0A821F41333333135C8459413333333377811F41CDCCCC0C5A845941CDCCCCCC00801F41666666A65584594166666666607F1F419A9999D95384594166666666227F1F41CDCCCC8C538459419A999999D57E1F413333339355845941CDCCCCCC7A7D1F419A99991961845941CDCCCCCC4A7D1F41333333B362845941333333333D7C1F41CDCCCC2C6B845941CDCCCCCC2A7C1F41000000206C845941CDCCCCCC107C1F41000000606D845941CDCCCCCC7E7B1F41000000A05384594100000000687B1F41333333934F845941CDCCCCCCCC7A1F419A9999393484594133333333C37A1F41CDCCCC8C3284594100000000DA781F416666668633845941CDCCCCCC9A781F41666666A63384594100000000A2771F4166666626348459419A9999997D771F41CDCCCC6C3A8459419A99999961771F419A9999793D845941000000003C771F41CDCCCC2C40845941CDCCCCCC0C771F4100000040428459419A999999AF761F410000004044845941CDCCCCCC7A761F41000000A0458459413333333371761F419A99995943845941666666666C761F419A999939428459413333333367761F41CDCCCCEC408459410000000056761F41666666263E8459410000000034761F41333333533A845941CDCCCCCCF6751F410000002037845941CDCCCCCC84751F4166666606348459416666666638751F41333333B3328459419A999999B1741F41CDCCCC2C318459419A9999999B741F41333333F3308459413333333323741F419A9999F930845941CDCCCCCCF4731F4100000080318459416666666660731F4166666626328459419A9999992F731F410000002033845941CDCCCCCCE8721F41CDCCCC2C35845941CDCCCCCCA0721F419A9999D937845941000000005C721F41000000603A8459410000000016721F41666666463C84594100000000D6711F419A9999B93D84594133333333B1711F419A9999993C8459419A9999996D711F41CDCCCC8C3A84594133333333BD701F41CDCCCC2C36845941CDCCCCCC90701F4100000020358459419A999999F76F1F410000000031845941000000008A6F1F41666666E62E84594100000000586F1F41CDCCCC2C2E8459419A999999236F1F419A9999D92D8459419A999999C76E1F41CDCCCC4C2E84594133333333676E1F41CDCCCCEC2F84594133333333076E1F419A9999593184594133333333D16D1F41333333933284594166666666AC6D1F410000006033845941CDCCCCCC7E6D1F41666666C63484594166666666406D1F41000000003884594166666666026D1F41333333333B845941666666669C6C1F41666666A64284594166666666686C1F419A9999F946845941CDCCCCCC526C1F41333333D34884594166666666286C1F419A9999994D84594100000000166C1F41CDCCCC8C50845941CDCCCCCC026C1F419A9999795D84594166666666D26B1F419A9999F96684594100000000BE6B1F41CDCCCC8C6984594100000000566B1F41666666A673845941666666662E6B1F41666666E67684594166666666F86A1F41333333537A8459419A9999998D6A1F41000000607C8459419A999999276A1F419A9999597D845941CDCCCCCCE6691F41666666867D84594133333333D3681F41333333D37C8459419A999999A3681F41CDCCCC2C7D8459413333333391681F41666666C67D8459416666666606681F419A9999598284594166666666AC671F41000000C085845941666666667E671F419A9999F9868459419A9999994F671F41000000A087845941	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	01010000206A0800000218BC0C129E1F4134333353E5835941	370060000	Z	Artannes-sur-Indre	3700600	37006	37	24	21
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	01010000206A080000DCF3A5DAB2291E419A9999691C6E5941	370070000	Z	Assay	3700700	37007	37	24	15
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	01010000206A0800009A3A1AAFE586204100000050B2875941	370080000	Z	Athée-sur-Cher	3700800	37008	37	24	34
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	01010000206A080000551A83AA0AC520419A9999190A9E5941	370090000	Z	Autrèche	3700900	37009	37	24	21
01060000206A08000001000000010300000001000000D103000066666666AD842041666666067FA1594100000000AE8420416666666681A159419A999999B78420413333337384A1594133333333C88420413333333385A1594133333333D6842041000000A085A1594133333333E48420419A99995986A159419A999999F18420416666668687A1594166666666018520410000008088A15941CDCCCCCC18852041666666E689A159413333333338852041333333738BA15941333333335B852041666666A68DA159419A999999788520410000002090A15941000000008A852041333333F391A15941CDCCCCCC9A852041333333B393A1594133333333AF852041333333F395A15941CDCCCCCCB38520410000004097A1594166666666B5852041CDCCCCAC98A1594133333333AE852041666666069CA1594133333333AB852041333333539EA15941CDCCCCCCAE85204100000040A0A1594166666666B785204100000080A2A15941CDCCCCCCC48520419A999979A6A159419A999999D185204100000020A8A1594100000000DE85204133333373A9A1594100000000EA852041000000A0AAA1594100000000F4852041CDCCCC8CACA1594100000000F985204133333393ADA1594166666666FD852041333333F3AEA15941666666660086204133333393B0A15941333333330986204133333373B2A15941CDCCCCCC12862041CDCCCC0CB4A15941CDCCCCCC1C862041CDCCCCECB4A159419A999999258620419A9999F9B5A15941000000002986204100000020B7A15941000000002C862041CDCCCC2CB9A159419A9999992B86204166666666BBA15941000000002F86204166666626BDA159416666666630862041666666E6BFA15941333333333386204100000040C3A15941CDCCCCCC3686204166666606C6A15941666666663B862041CDCCCC8CC6A1594133333333458620419A999959C6A15941000000004E8620419A9999F9C5A159419A9999995B86204100000000C6A15941CDCCCCCC5C86204133333313C6A159413333333366862041000000A0C6A15941CDCCCCCC6C86204100000020C7A159413333333371862041CDCCCC0CC7A159413333333375862041CDCCCCACC6A15941CDCCCCCC79862041CDCCCCECC6A15941666666667D86204133333393C7A159410000000081862041333333D3C8A15941CDCCCCCC8386204133333313CAA15941000000008786204133333373CBA159419A9999998A86204100000000CFA15941333333338F862041333333F3D3A159410000000093862041CDCCCC0CD9A1594166666666968620419A999919DFA15941666666669786204100000000E3A15941666666669186204133333313E7A159419A99999988862041CDCCCC8CEAA159416666666683862041333333B3EDA159410000000083862041CDCCCCCCF0A159419A9999998786204166666646F3A159419A9999998D8620419A999959F6A159419A99999993862041CDCCCCECF8A15941000000009D8620419A9999B9FBA1594133333333A786204133333373FEA1594166666666AE8620416666662601A2594100000000B4862041CDCCCCEC03A25941CDCCCCCCBA8620413333331306A259419A999999BF862041CDCCCC0C08A2594100000000C4862041CDCCCC2C0AA259419A999999C8862041000000000CA2594100000000C9862041666666060EA259419A999999C98620413333331311A2594133333333C8862041000000E014A2594100000000CC862041333333F317A2594166666666CF862041000000A01AA2594133333333D6862041333333731DA25941CDCCCCCCDA8620413333335320A259419A999999E18620416666664622A25941CDCCCCCCEB8620419A99993924A2594133333333F5862041CDCCCC8C26A259419A999999FD8620413333335329A25941666666660C8720419A9999F92CA259419A999999188720419A9999F92FA25941CDCCCCCC23872041CDCCCCAC32A25941000000002D8720413333339334A25941333333333C8720416666666638A25941333333334E872041333333933CA259419A999999578720419A9999193FA259419A9999995E8720416666668641A25941CDCCCCCC6B872041CDCCCC6C43A2594100000000808720413333335347A259419A9999998D8720416666668649A259410000000097872041CDCCCC8C4BA2594166666666A78720410000000050A2594166666666BD8720410000004055A2594166666666D2872041CDCCCCEC5AA259419A999999E98720410000006060A2594133333333F6872041333333B362A25941CDCCCCCC008820419A99997964A25941CDCCCCCC0A882041000000E065A2594133333333178820419A99991967A2594100000000208820416666668668A25941CDCCCCCC23882041000000606AA259419A999999238820419A9999196CA259419A99999921882041666666266EA25941CDCCCCCC1C882041000000806FA259419A99999918882041CDCCCCCC70A2594100000000118820413333337372A259410000000001882041CDCCCC0C74A2594100000000E48720419A99991976A2594133333333CD872041CDCCCCAC77A2594133333333C1872041CDCCCC0C79A2594166666666BC872041CDCCCC0C7AA259419A999999BB872041666666E67BA2594166666666BC872041666666667EA2594100000000BE8720419A9999F980A25941CDCCCCCCBF8720419A9999D983A2594133333333C0872041333333F386A2594133333333BD8720410000002089A259419A999999B7872041333333F38AA2594166666666B1872041CDCCCCEC8CA25941CDCCCCCCA28720419A9999B990A2594166666666A2872041CDCCCCEC90A25941666666669F872041CDCCCC0C93A25941333333339D872041666666E694A259419A9999999F8720410000004097A2594166666666A4872041666666469AA2594166666666B5872041000000409FA2594166666666CC87204166666606A7A2594133333333DF8720419A999939ACA2594100000000F5872041CDCCCC4CB0A25941000000001C8820419A999939B7A25941CDCCCCCC4888204100000060BFA25941000000006F88204100000000C7A25941CDCCCCCC8A882041000000E0CCA259419A9999999788204166666666D0A259419A99999999882041CDCCCC6CD3A25941CDCCCCCC9888204100000060D6A259419A9999999E882041CDCCCC4CDAA2594166666666B48820419A9999F9DFA2594100000000D1882041CDCCCC0CE8A2594166666666EF882041666666A6F1A2594100000000118920419A999979FAA25941CDCCCCCC30892041666666C604A3594133333333468920410000006009A359419A9999995A8920419A9999790DA359416666666676892041CDCCCCAC11A359419A9999999B892041CDCCCC0C17A359419A999999BE892041666666061CA3594166666666E58920410000006020A35941CDCCCCCC058A20419A99997924A359419A999999258A2041CDCCCC4C2AA35941333333333A8A20419A9999592EA3594100000000568A20410000004033A3594100000000748A2041000000A037A3594133333333938A2041666666E63BA359419A999999A78A20410000004040A3594166666666B38A20419A9999D943A359419A999999B88A20419A9999B947A35941CDCCCCCCB68A2041000000004CA359419A999999AA8A2041666666664FA359419A999999978A2041CDCCCC0C52A35941CDCCCCCC7F8A20413333339353A359419A999999638A20413333335355A359419A999999438A2041CDCCCCEC56A35941CDCCCCCC2D8A20413333337358A35941CDCCCCCC208A20419A9999395AA359419A999999198A20419A9999995DA359419A999999128A20419A9999D963A3594100000000078A2041000000A06AA3594166666666008A20419A99991970A3594100000000FA892041000000C078A3594100000000F58920419A99997981A359419A999999EF892041333333D387A3594166666666EB892041666666E68BA3594100000000EA892041CDCCCC2C8DA359419A999999EA892041CDCCCCEC8EA3594100000000F38920413333335390A3594100000000FB8920410000008091A359419A9999990A8A20413333333394A35941666666661A8A2041CDCCCCCC97A359419A9999992F8A2041000000409CA35941CDCCCCCC438A20419A999939A1A359419A999999628A204133333313A9A35941CDCCCCCC7D8A20419A9999D9ADA3594166666666978A20419A999979B2A3594133333333AF8A20419A999979B7A35941CDCCCCCCBA8A204133333333BBA35941CDCCCCCCC28A204100000040BEA3594100000000C68A2041000000A0C2A3594166666666CA8A204100000020C9A3594100000000CA8A204133333353CDA359419A999999C28A204166666626D0A359419A999999B78A204100000060D2A3594133333333AF8A204133333393D4A3594166666666AA8A2041000000A0D7A3594166666666A98A20419A999979DBA3594100000000B38A2041000000E0DDA3594133333333C28A20419A999979DFA3594100000000D78A204100000020E0A3594100000000EC8A204166666666E0A3594100000000008B2041CDCCCCECE0A3594133333333118B204100000080E2A35941CDCCCCCC1F8B204166666646E4A35941333333332F8B204133333313E7A35941333333333E8B2041333333B3E9A35941CDCCCCCC538B204166666666EDA3594100000000918B2041CDCCCC8CEDA3594133333333ED8B204133333333ECA35941333333330B8C20419A999919ECA3594133333333148C204133333373EAA3594100000000548C2041666666C6E8A3594133333333848C204166666646E8A3594100000000D68C204166666646ECA3594100000000E18C2041CDCCCC2CF7A359419A999999038D204166666686FEA359419A999999F28C2041666666E611A4594133333333D78C20419A99993914A45941CDCCCCCCE98C2041666666863AA45941CDCCCCCC768C2041CDCCCC4C3EA4594166666666FB8B20413333335338A45941333333339A8B20410000008040A459419A9999998C8B2041000000A046A45941000000007E8B20419A9999194CA45941CDCCCCCC6F8B20413333339352A45941666666666A8B20410000000059A459419A999999678B20419A9999595EA4594100000000708B2041333333B363A4594166666666808B2041000000A067A45941333333339C8B2041333333B36BA459419A999999C08B2041CDCCCCCC6FA4594166666666D48B20416666666671A45941CDCCCCCCE78B20419A99999972A459419A999999FC8B2041CDCCCC8C74A4594133333333128C2041CDCCCC8C76A459419A9999991D8C20410000006078A4594166666666248C2041000000207AA459419A999999278C20419A9999197DA459419A9999992D8C2041CDCCCC2C80A4594166666666338C20419A99999983A45941CDCCCCCC338C2041333333D383A45941CDCCCCCC3C8C20413333335386A45941CDCCCCCC468C20419A99995989A4594133333333498C2041333333D38BA459419A999999478C2041333333138DA4594166666666458C2041000000808EA45941CDCCCCCC398C20410000008091A459419A999999248C20419A99999995A45941333333330A8C20419A9999F99AA4594100000000F68B20419A9999199FA4594133333333EA8B204133333333A2A4594166666666E48B2041333333F3A4A4594133333333E38B2041666666A6A7A4594100000000E58B204100000080A9A4594100000000E68B2041666666A6AAA45941CDCCCCCCEB8B204166666666ADA45941CDCCCCCCF08B20419A999999AEA45941CDCCCCCCF58B204100000000B0A4594166666666FA8B20419A999919B1A459419A999999048C204133333313B3A459419A9999990A8C204133333333B4A459419A999999128C2041333333F3B4A4594100000000208C2041CDCCCCECB5A459419A999999268C204100000060B6A4594133333333318C204100000020B7A45941CDCCCCCC3D8C204100000060B8A459419A9999994A8C2041CDCCCCACB9A4594100000000578C204100000080BBA45941666666665E8C2041CDCCCCECBCA4594100000000648C204166666626BEA45941CDCCCCCC688C2041CDCCCCCCBFA45941000000006C8C20419A999999C1A4594133333333768C2041CDCCCC4CC4A45941000000007A8C20419A999979C5A4594166666666808C20419A9999B9C6A459419A999999888C204133333333C8A45941000000008E8C204166666686C9A4594166666666748C204166666686D6A4594100000000648C204100000020E3A4594100000000688C20419A9999F9ECA4594133333333808C20419A999959FAA4594100000000988C204100000060FFA4594133333333BC8C2041CDCCCC2C04A5594133333333E88C2041CDCCCCCC05A5594133333333108D20416666662606A5594166666666768D2041CDCCCC4C07A559419A999999A08D20419A9999F914A559419A999999BB8D2041333333D31DA55941CDCCCCCCDD8D2041CDCCCC4C1CA55941000000001F8E2041CDCCCCAC18A55941CDCCCCCC458E20419A9999F916A55941666666665F8E20413333333316A5594133333333788E2041666666A615A5594133333333998E20419A99993915A5594166666666BB8E20419A9999D914A5594133333333D28E2041000000E014A5594133333333DF8E20410000004015A559419A999999EA8E20410000002016A55941CDCCCCCCF38E20413333337317A559419A999999048F20419A9999B91BA55941000000000A8F20419A9999191DA5594166666666118F2041666666E61EA55941666666661F8F20419A99995921A55941333333332A8F20419A9999B922A5594166666666398F2041333333D323A5594100000000548F2041CDCCCCCC24A5594166666666738F2041CDCCCCCC25A5594166666666BA8F2041CDCCCC0C28A5594166666666F48F20410000008029A559410000000004902041000000202AA559419A9999996F902041000000A031A5594133333333769020416666660632A559419A999999CA9020410000000037A559410000000006912041000000803AA55941CDCCCCCC0D9120419A9999F93AA559410000000013912041666666463BA559419A9999992F9120419A9999F93CA55941333333337F912041000000603FA559419A999999FA912041CDCCCCCC43A55941CDCCCCCC3F9220410000004046A5594166666666709220416666660648A559419A9999999E9220419A9999B931A5594133333333D69220416666666633A5594133333333E19220410000002034A559419A9999991A932041666666E635A55941666666663A9320419A99993936A559416666666650932041000000A039A55941CDCCCCCC879320413333333341A5594166666666C1932041CDCCCC6C49A55941CDCCCCCCEE9320419A9999D94FA5594100000000019420410000006053A559419A999999049420410000004055A559419A99999904942041333333F356A55941CDCCCCCC179420419A99995958A5594100000000209420419A99991959A55941000000002B942041333333F359A55941CDCCCCCC37942041CDCCCC2C5AA55941666666665F942041666666E65AA559419A9999999F9420419A9999395BA559419A999999BE942041CDCCCC4C5BA5594100000000DC9420419A9999595BA5594133333333129520419A9999F95BA55941333333335B952041000000605DA559419A9999996B952041333333D35DA55941CDCCCCCC8C952041000000205FA559419A999999AB9520419A9999D960A559419A999999D4952041333333D363A559419A999999F9952041CDCCCCAC66A55941333333334E9620410000002055A55941CDCCCCCCBD962041333333F33DA55941CDCCCCCC649720416666666651A5594133333333609720413333335353A55941000000004F972041000000E056A559410000000045972041CDCCCCCC5AA559416666666643972041CDCCCCEC5DA55941000000004B9720419A99991960A55941CDCCCCCC549720419A99997961A559413333333389972041CDCCCC8C66A559410000000049972041000000807BA55941CDCCCCCC59972041000000607CA559419A999999AF972041000000807FA55941333333333C9820413333331385A55941000000003E9820416666662685A55941CDCCCCCC709820410000008087A55941000000008D982041333333D388A5594133333333AB982041666666668AA5594133333333D2982041333333338BA5594100000000DE982041000000808BA55941CDCCCCCC1B992041333333538DA55941CDCCCCCC71992041CDCCCC8C8BA55941CDCCCCCC98992041666666C68AA559419A999999CC9920419A9999B989A55941CDCCCCCC359A2041666666A687A5594166666666469A20413333335387A5594133333333859A2041CDCCCC0C86A55941333333336F9A2041666666467DA5594100000000719A20419A9999197CA55941CDCCCCCC779A20419A9999D971A5594133333333819A2041CDCCCCEC66A559419A999999889A20410000004061A559419A999999929A2041000000C05DA55941000000009E9A2041CDCCCCEC5AA55941CDCCCCCCC79A20410000002054A559419A999999EE9A2041000000604EA5594133333333179B2041000000A049A5594166666666359B20419A99995946A55941000000001B9B20416666660639A55941333333330B9B20419A9999592EA559419A999999049B2041000000E026A55941CDCCCCCC119B20416666666620A5594133333333479B20416666660614A55941CDCCCCCC929B2041000000A004A5594166666666BC9B204166666686FEA459419A999999119C20419A999959F6A45941CDCCCCCC6C9C2041333333F3EBA45941CDCCCCCCB89C204133333393E1A4594133333333DC9C20419A999979D9A4594133333333369D20419A999959C4A459419A999999809D204166666626ADA4594166666666A19D204100000040ADA4594166666666C09D204166666626AEA45941CDCCCCCCE19D2041CDCCCC0CAFA4594133333333F09D2041CDCCCC0CAFA459419A999999FE9D20419A999939AEA459419A999999099E2041000000A0ACA45941000000002E9E204166666606A4A45941CDCCCCCC499E2041333333139EA4594133333333579E2041CDCCCC0C9AA459419A999999599E20413333339397A459419A999999529E20416666660696A4594133333333469E2041666666E693A4594100000000409E20416666664691A4594133333333429E2041333333B38DA45941666666664F9E2041333333F384A459419A9999995D9E2041666666C67CA45941CDCCCCCC5D9E2041CDCCCC8C77A45941CDCCCCCC569E2041333333F370A459419A9999994F9E2041666666E669A45941CDCCCCCC4F9E2041CDCCCCAC66A4594100000000589E20419A99991963A459419A9999996A9E20419A9999795DA45941CDCCCCCC969E2041666666E654A45941CDCCCCCCA69E2041666666E650A45941CDCCCCCCEB9E2041666666E647A45941666666663E9F2041333333D346A45941333333336E9F20416666668642A459419A9999997E9F20419A9999793FA459419A999999979F20416666666637A4594133333333B29F2041000000E02EA4594166666666E49F2041333333B322A459410000000014A020419A9999F919A45941000000004EA020410000004012A459419A999999B9A020413333337309A45941CDCCCCCC5BA22041333333D3F3A35941CDCCCCCC01A32041CDCCCC8CE9A35941CDCCCCCCCAA32041CDCCCC0CE1A3594133333333C1A4204166666666DFA359419A99999903A52041CDCCCCECDFA359410000000049A5204133333313E3A359419A999999A8A520419A999959EAA35941333333331FA62041CDCCCC6CFFA359413333333348A620413333337305A459419A999999AEA620419A9999D914A4594133333333D1A620410000006018A459419A99999903A720419A9999B91CA459413333333337A720416666668620A459410000000055A720419A9999B922A459410000000021A82041CDCCCC4C2FA459416666666672A820413333331335A4594133333333AEA82041666666463AA4594133333333C1A82041666666C63CA459413333333300AA20419A9999F92DA45941000000007EAA2041000000E00BA459416666666625AB204133333353E4A359416666666632AB2041666666A6DFA35941CDCCCCCC30AB2041333333D3DAA3594100000000FEAA2041CDCCCC4CCAA359419A999999FAAA2041666666A6C5A35941CDCCCCCC01AB204100000000C1A359416666666661AB2041CDCCCC6CA4A3594166666666A2AB20416666666694A3594100000000ECAB20419A9999197DA35941333333332AAC2041333333B36EA359416666666640AC2041333333D367A35941CDCCCCCC57AC2041CDCCCC8C51A359419A99999987AC20419A99999933A359413333333394AC20416666664625A35941333333339CAC2041666666E615A359419A999999A1AC20419A9999390DA3594166666666A7AC20413333339308A3594133333333B8AC2041CDCCCC0C03A3594100000000E0AC2041CDCCCC8CFFA2594166666666FDAC204100000000FDA259416666666619AD2041CDCCCCCCFBA25941333333333CAD2041000000E0FAA25941CDCCCCCC72AD204133333313F9A25941666666669DAD2041CDCCCC6CF6A259419A999999BDAD204166666606F4A2594133333333E0AD2041CDCCCCECF1A259419A9999990BAE204133333373F0A25941CDCCCCCC3EAE204100000040EFA25941CDCCCCCC74AE204133333393EEA25941666666669EAE204100000040EDA259410000000002AF20419A999939E9A259419A99999966AF2041000000A0E4A2594166666666C8AF204133333313E0A25941CDCCCCCC11B0204100000000DDA259419A9999994EB02041666666E6DAA25941CDCCCCCC7FB02041000000C0D8A2594133333333D6B02041333333B3D4A259416666666605B1204133333393D4A25941CDCCCCCC3DB12041CDCCCC6CD6A25941333333332AB22041CDCCCCCCDFA25941CDCCCCCC4FB22041CDCCCC4CE2A25941CDCCCCCC65B220419A999959E4A2594100000000F0B2204166666606F5A2594133333333BEB320419A9999190DA35941CDCCCCCCCAB32041CDCCCC6C0FA3594100000000D1B32041CDCCCC2C14A35941CDCCCCCCF1B32041333333B33DA359419A99999937B420419A9999593CA359413333333354B42041333333133BA35941CDCCCCCC87B42041CDCCCCEC36A35941CDCCCCCCCFB42041CDCCCC0C32A3594133333333EEB52041000000C01FA359416666666618B720419A9999D909A359413333333310B8204133333393F7A25941000000002CB820419A999979F5A25941CDCCCCCC2EB8204133333333F5A259410000000048B820419A999959F2A259410000000066B8204133333313EEA259419A999999BAB82041666666E6DFA2594133333333DDB820419A9999D9DAA2594100000000F8B820419A999939D7A259413333333312B92041CDCCCCACD3A259413333333324B92041CDCCCC0CD1A25941666666663BB920419A9999D9CDA25941CDCCCCCC7DB92041CDCCCC4CC3A259413333333388B9204133333313C2A25941666666669BB92041CDCCCC6CC0A25941CDCCCCCCA4B920419A9999D9BFA2594166666666E2B92041333333F3BBA25941CDCCCCCC04BA2041333333D3B8A25941CDCCCCCC37BA2041333333D3B2A25941333333336CBA204133333333ADA25941CDCCCCCCEDBA2041666666E69EA259410000000032BB2041000000A096A2594166666666ECBB2041666666A682A259419A9999999BBD2041666666660EA259413333333353BE2041CDCCCC4CF7A15941000000007ABE204166666626F0A1594133333333A6BE204100000020E3A1594166666666BABE20419A999919DFA159419A99999918BF2041000000A0D2A159410000000030BF2041000000A0CEA15941666666665DBF2041CDCCCCECBBA1594133333333CCBF20416666662694A1594100000000D2BF2041666666068DA15941CDCCCCCCCFBF2041333333F382A1594100000000BEBF2041CDCCCCCC7AA1594133333333A6BF20413333335374A159413333333378BF2041CDCCCC6C6DA159416666666673BF2041333333B365A15941666666667DBF2041000000E05BA1594166666666A1BF2041333333B343A159419A999999ACBF20410000006031A159419A999999A0BF20410000000024A159416666666675BF2041666666A612A159419A9999994BBF2041333333F302A15941666666662BBF204166666686F4A059416666666681BE2041000000E0C8A05941CDCCCCCC59BE204100000080BFA05941666666664CBE20419A999939B3A059416666666601BE2041CDCCCC8CB2A059419A9999994CBD2041CDCCCCAC86A0594100000000C3BC2041000000407FA059413333333310BD2041000000406AA05941CDCCCCCCFBBC2041000000C068A05941CDCCCCCCC2BC2041CDCCCCCC66A059410000000098BC2041666666C661A059416666666690BC20419A9999F95FA059416666666686BC2041333333935DA059419A999999D5BB2041000000004EA05941000000005DBB2041666666A645A059416666666656BB20416666666646A05941CDCCCCCC4DBB2041CDCCCCCC46A059419A99999944BB2041333333D346A05941666666663CBB20419A99997946A05941CDCCCCCC34BB2041CDCCCCCC45A059410000000003BB20419A9999593FA059419A999999BEBA2041CDCCCCCC36A0594133333333A7BA2041000000E033A059413333333385BA2041666666E62EA059416666666672BA2041CDCCCC6C2CA059419A9999996DBA2041666666862BA059419A9999996CBA2041000000402AA059413333333377BA20410000002023A059416666666682BA2041666666261CA05941CDCCCCCC8DBA2041000000E015A059410000000099BA20410000008011A059419A999999A3BA20419A9999790DA0594100000000A5BA2041333333930CA0594133333333A3BA2041666666660BA059416666666688BA2041CDCCCCCC01A059419A99999975BA2041CDCCCC2CFC9F59419A9999996BBA2041666666C6F99F59416666666662BA20419A999999F79F5941333333335ABA204100000000F69F59419A9999994CBA20419A999939F49F5941333333332FBA2041CDCCCC0CF19F594133333333FEB9204133333393EC9F594100000000C6B9204166666606E79F594166666666A3B9204166666686E39F59410000000086B920419A999939E19F59419A9999995EB92041CDCCCC6CDE9F5941000000003AB920419A999919DC9F59419A99999913B920419A9999B9D99F59419A999999ECB82041333333F3D69F594100000000C4B820419A999939D49F594133333333A5B8204166666686D19F59410000000081B82041CDCCCC4CCD9F59413333333346B820419A9999F9C59F5941666666664EB82041CDCCCC2CBD9F5941CDCCCCCC52B82041CDCCCC0CB79F59419A99999957B8204166666626B19F59419A9999995AB8204166666646AB9F5941333333335BB82041000000C0A89F5941000000005BB82041CDCCCC4CA79F59416666666657B82041333333F3A59F59416666666644B82041333333F3A19F5941000000003EB8204100000080A09F5941333333333BB82041CDCCCCAC9E9F59419A9999993CB820419A9999399D9F59413333333343B82041333333939B9F5941333333335BB8204100000060979F5941CDCCCCCC3FB8204133333373969F59416666666621B8204166666646959F594133333333FFB720419A9999B9949F59419A99999954B720419A9999F9929F594133333333AEB620419A999959919F5941000000002AB62041333333F38F9F5941CDCCCCCCBEB52041666666068F9F59413333333341B52041CDCCCC8C8D9F5941CDCCCCCC2DB52041CDCCCC4C8D9F59413333333316B52041333333B38C9F59410000000003B52041CDCCCC0C8C9F59410000000053B4204166666686899F59419A999999D2B32041666666C6839F59413333333381B320419A9999B9809F59413333333336B32041000000207F9F59419A999999ECB22041333333937E9F594133333333B5B12041333333737F9F594166666666A1B1204166666626539F59419A999999B0B12041000000E04D9F5941CDCCCCCC3FB22041CDCCCCCC309F59413333333388B220419A999919239F5941333333338AB12041CDCCCC8CE69E59419A99999915B1204100000080D69E59419A999999B0B020419A999979C69E5941CDCCCCCC5DAF2041000000A0C69E59419A9999991BAD2041000000A0BE9E59419A999999E5AC20419A9999B9BE9E5941CDCCCCCCDFAB2041CDCCCC2CC79E594166666666A0AA2041000000C0D09E59413333333330AA2041CDCCCC6CD49E59419A9999991BAA204133333353DE9E594100000000DDA920419A999999FC9E594100000000DAA920419A999919FE9E59419A999999BEA92041333333F3009F594133333333A7A92041333333B3009F5941000000009BA9204133333393009F5941CDCCCCCC77A920419A999979009F5941CDCCCCCC4AA92041CDCCCC2C019F59419A99999918A920419A9999F9029F594100000000EEA820419A9999F9049F594100000000C9A8204100000080079F594100000000A3A82041CDCCCC2C0A9F5941CDCCCCCC92A82041333333D3089F59416666666637A820419A999939019F59416666666611A8204133333313FE9E59416666666683A72041CDCCCCCCF29E59413333333374A620419A9999B9EA9E59410000000004A5204133333353D59E59419A99999919A120419A9999F9A19E5941CDCCCCCC18A12041CDCCCCCC899E59416666666635A12041CDCCCC2C809E59419A9999994E9B204133333373399E5941333333339B9A204100000000429E594133333333BF9920419A999939389E594133333333B3992041000000003E9E59419A999999AC99204100000080419E594166666666AC9920419A9999D9449E594166666666AC992041CDCCCCAC4B9E594166666666A2992041CDCCCC2C4D9E59413333333386992041333333D34E9E5941333333332399204100000040539E594100000000819820419A9999D95A9E59419A9999990B9820419A999919609E594133333333C99720419A999919639E59419A9999999397204100000020659E5941333333336F972041000000E0669E594133333333609720419A9999F9679E5941666666664F972041CDCCCC8C699E59419A99999927972041000000A06F9E594166666666F8962041333333B3759E594133333333C9962041333333337A9E59419A999999AC962041666666A67C9E5941CDCCCCCC99962041666666A67D9E59416666666688962041000000407E9E5941333333337F962041000000607E9E5941CDCCCCCC76962041CDCCCC4C7E9E59416666666678962041CDCCCCEC799E59413333333374962041CDCCCC0C749E59419A99999968962041666666666E9E594133333333B7952041333333D34D9E5941CDCCCCCC87952041666666C6519E59419A9999994A95204100000040699E5941333333332E952041333333736F9E594166666666239520419A999999729E59416666666615952041333333F3739E594133333333FA942041333333F3739E59419A999999D7942041CDCCCCAC719E5941CDCCCCCCB99420419A999939719E59419A999999A79420419A999959719E5941666666668494204166666666749E59419A9999995A9420419A999999779E5941666666663D9420419A9999197A9E5941CDCCCCCC26942041CDCCCC0C7C9E59416666666600942041CDCCCC8C809E594100000000E1932041CDCCCC2C839E594166666666AC93204166666646859E594166666666599320419A9999F9869E5941666666664E93204133333333879E59419A9999993493204133333393879E5941666666662A932041333333D3879E5941000000002993204100000020899E5941CDCCCCCC269320419A9999B98B9E5941CDCCCCCC259320419A9999798D9E59413333333324932041CDCCCC4C8F9E59419A99999924932041CDCCCC0C919E59419A999999249320419A999999929E594133333333259320419A999999949E5941000000002393204100000060969E594166666666209320419A9999D9979E5941CDCCCCCC0E932041666666C69A9E59410000000005932041CDCCCCAC9B9E594133333333F5922041666666069D9E59419A999999E7922041666666469E9E594133333333D6922041000000E09F9E594100000000C792204166666646A19E594100000000BB92204100000080A29E594166666666B19220419A999919A49E594100000000AE92204166666666A59E594100000000AE9220419A9999D9A69E594166666666AE92204100000080A89E59419A999999AF9220419A999979A99E594100000000B2922041666666C6AA9E5941CDCCCCCCB692204133333373AC9E594133333333BC92204166666686AE9E594133333333C2922041CDCCCC8CB09E5941CDCCCCCCC9922041CDCCCC6CB29E59419A999999D4922041CDCCCC0CB49E594166666666E4922041333333B3B59E5941CDCCCCCCF39220419A9999B9B69E5941CDCCCCCCFF922041000000E0B79E59419A9999990993204166666646B99E59413333333315932041CDCCCC0CBB9E5941333333331C93204100000000BD9E59419A999999279320419A999959BE9E594133333333329320419A999919C19E59419A99999934932041CDCCCC6CC29E5941000000003D9320419A999919C49E59419A9999992093204133333313C79E59419A999999F092204100000040CF9E594166666666C792204133333393D49E594133333333AC92204166666686D69E5941CDCCCCCC90922041CDCCCC8CD79E5941333333336D922041333333D3D99E5941333333334E92204100000000DB9E59419A999999349220419A999979DB9E5941CDCCCCCC06922041CDCCCC2CDF9E59419A9999990492204166666646DF9E594100000000D69120419A999979E19E594100000000B99120419A9999D9E39E594100000000A8912041333333D3E49E5941000000007D912041CDCCCCCCE59E59410000000064912041000000E0E59E5941666666664B9120419A999959E69E5941666666661991204166666666E89E59419A999999EA902041000000A0E89E5941CDCCCCCCD9902041CDCCCC6CE99E59419A999999C590204166666626EB9E594133333333B89020419A999999EB9E5941666666665F90204166666646ED9E5941333333332990204133333373ED9E5941CDCCCCCC378F204166666646F19E59419A999999198F2041CDCCCC8CF29E594166666666F18E2041333333B3F39E59419A999999CA8E2041CDCCCC8CF59E59419A999999768E20419A999959FB9E59419A9999995C8E20419A9999F9FD9E59419A999999D08D2041666666860A9F5941CDCCCCCC8E8D2041CDCCCC8C129F594166666666BE8D204166666686189F594166666666F38D204100000020209F59419A999999068E2041000000A0239F5941666666660C8E204100000000279F5941666666661E8E2041CDCCCC8C3C9F594166666666248E2041CDCCCC6C479F594166666666298E2041333333F3509F594133333333328E20419A9999D95B9F594133333333358E2041666666865F9F5941CDCCCCCC4A8D204133333353629F5941333333335A8D204100000040739F594166666666728D2041666666868A9F5941CDCCCCCC7E8D2041333333D3929F594133333333878D204133333333969F59419A999999978D2041CDCCCC8C969F5941000000008D8D204133333373A99F594100000000698D20419A999959C09F594166666666498D2041333333F3D19F5941333333330F8D2041333333F3E19F5941CDCCCCCCEB8C20419A999999EA9F594166666666CA8C2041333333F303A0594100000000D08C20413333335308A0594133333333CB8C2041000000C00DA0594100000000D78C20410000004011A0594166666666D88C20413333331313A0594166666666D58C20416666668615A05941CDCCCCCCCD8C2041CDCCCC2C18A0594166666666B88C2041666666661DA0594166666666878C20419A99997928A05941CDCCCCCC668C20410000004033A05941666666663D8C2041333333533FA0594166666666308C2041CDCCCC8C43A05941000000004A8C20419A99999944A0594100000000648C2041000000C045A0594133333333778C2041CDCCCCEC45A05941333333338D8C20416666662646A0594133333333AD8C20416666662647A0594166666666CC8C20416666668648A0594100000000E38C2041000000404AA059419A999999EA8C2041CDCCCCAC4BA0594166666666E88C20419A9999D94DA059419A999999DD8C20419A9999F950A059419A999999C98C20419A9999F954A05941333333337F8C2041666666C65BA0594166666666428C2041CDCCCC2C5FA05941CDCCCCCC078C20419A99997961A059419A999999D58B20413333333370A0594166666666D68B20410000006072A0594133333333A38B20419A9999B976A059419A9999996D8B2041666666C67AA059419A999999328B20419A9999B97FA0594166666666B78B20419A9999B989A0594100000000508C2041333333F384A05941CDCCCCCCB38C2041000000C082A0594100000000378D20419A9999F981A0594100000000FA8D2041CDCCCC0C7FA059419A999999418E2041CDCCCCEC7DA059419A9999998F8E2041333333537AA05941333333331F8F20413333331371A059419A999999708F2041000000E073A05941000000008F8F2041000000A074A0594100000000A68F2041333333B374A05941CDCCCCCCD28F2041CDCCCC6C74A05941CDCCCCCC679020419A9999F971A05941000000007E9020419A99991978A0594100000000919020419A9999D97BA0594166666666A4902041000000A080A05941CDCCCCCCB0902041333333D384A0594133333333BD902041CDCCCC2C8AA0594100000000D19020419A99999995A0594166666666F19020419A9999799FA05941000000000891204166666606A5A059419A9999990B9120419A999959A7A059419A999999579120419A999919A8A059416666666699912041333333B3A9A059419A999999CB912041333333B3AEA05941CDCCCCCCDA912041666666E6B2A05941CDCCCCCCDB912041666666A6B6A05941CDCCCCCCCF912041000000E0BFA0594166666666DB91204133333393CAA0594133333333E391204133333313D9A059419A999999D9912041CDCCCC6CEDA0594166666666C39120419A99991900A15941CDCCCCCC959120419A99997914A159416666666673912041333333F326A15941333333332A912041CDCCCC0C38A15941CDCCCCCCC1902041CDCCCC2C57A15941000000007D902041CDCCCCCC6BA159419A9999994F9020419A9999F97FA159419A99999938902041CDCCCC6C89A15941666666661D9020416666664692A159419A999999F28F2041333333939DA159419A999999ED8F2041000000409EA1594100000000DA8F2041666666A6A1A159419A999999CD8F2041CDCCCC8CA5A15941CDCCCCCCC88F2041333333F3A5A15941666666668D8F204100000080A8A15941333333337C8F204133333313A9A159419A999999788F204133333333A9A159419A999999678F204166666646A9A1594166666666548F2041CDCCCC2CA9A159419A999999D98E204166666626AAA1594166666666358E2041666666C6AAA1594166666666708D204100000060AAA159419A999999148D2041CDCCCC6CAAA1594166666666C48C2041000000C0AAA1594100000000BF8C2041333333D3AAA1594133333333BD8C2041CDCCCC0CA9A1594100000000A38C2041666666C692A1594166666666988C20416666662687A15941CDCCCCCC928C2041CDCCCC2C85A159419A9999997E8C2041333333B381A1594166666666668C20419A9999B97EA1594133333333028C2041CDCCCC0C70A1594133333333E58B2041000000C06CA1594100000000D28B2041000000206BA1594100000000B68B2041CDCCCC6C69A15941CDCCCCCC348B2041CDCCCCCC5DA1594133333333EC8A20416666660659A1594133333333A28A2041CDCCCC0C53A15941CDCCCCCC618A20419A9999994BA1594166666666438A20419A99999946A15941CDCCCCCC198A2041333333133DA159419A999999028A2041CDCCCCCC35A1594133333333E7892041000000602DA1594166666666C1892041333333B323A159419A9999999E892041666666C619A15941CDCCCCCC5F892041000000200CA159419A9999993A8920416666668603A15941333333330A892041CDCCCCECFAA059419A999999E1882041CDCCCC6CF0A05941CDCCCCCCDA88204133333313EFA05941CDCCCCCCCA88204100000080ECA0594133333333BC882041666666E6E8A0594100000000B88820419A999959E6A05941CDCCCCCCBA88204100000040E4A0594166666666BD882041333333D3DFA05941333333334388204166666606D9A0594100000000DA87204100000000D2A0594133333333BF8720419A999999CFA059419A999999B387204166666606D1A0594166666666A3872041666666C6D3A05941333333339687204166666686D5A059419A9999999387204166666606D6A05941000000006787204133333353DDA05941CDCCCCCC5B8720419A999939DFA05941CDCCCCCC46872041666666A6E1A05941666666662E872041CDCCCC4CE4A059419A9999991C87204133333373E6A059419A999999F486204100000080EBA05941CDCCCCCCC986204166666626F1A0594166666666A686204133333333F6A05941666666667E86204166666646FBA0594166666666568620419A99995900A159413333333334862041CDCCCC4C04A159416666666621862041333333B306A159419A999999148620419A99993909A15941666666660B862041CDCCCC2C0BA15941CDCCCCCC06862041333333530CA1594100000000FD8520419A9999D90EA159419A999999EA8520410000008011A1594133333333DF852041333333F313A1594166666666D5852041000000C016A159419A999999D08520413333333319A1594133333333CB852041CDCCCC8C1BA1594166666666C6852041000000201FA1594166666666C0852041000000E021A15941CDCCCCCCBB8520413333331324A159419A999999B08520413333335329A15941CDCCCCCCA7852041666666A62EA15941CDCCCCCCA48520416666662633A159419A999999A28520419A99997936A159419A9999999A852041333333533AA159416666666691852041666666C63DA159410000000088852041CDCCCC0C40A15941333333337A8520416666662643A15941CDCCCCCC698520413333333347A15941333333335C852041CDCCCC2C4AA15941666666664C852041333333334EA15941CDCCCCCC398520410000000052A15941CDCCCCCC16852041666666665AA1594133333333FD842041CDCCCC8C60A159419A999999EB8420413333331366A1594100000000E1842041CDCCCC2C69A1594133333333DB8420419A9999D96BA1594133333333D2842041333333F36EA1594166666666C38420419A9999F973A1594133333333B78420419A99995978A15941CDCCCCCCAF8420419A9999D97BA1594166666666AD842041666666067FA15941	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	01010000206A080000F0C2BFC1A3A22041CDCCCC0CE1A15941	370100000	Z	Auzouer-en-Touraine	3701000	37010	37	24	34
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	01010000206A080000D0B1841882BF1D41CDCCCCBC137F5941	370110000	Z	Avoine	3701100	37011	37	24	12
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	01010000206A080000CBA9C59EEEFC1E419A9999F95D7A5941	370120000	Z	Avon-les-Roches	3701200	37012	37	24	33
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	01010000206A080000D27A94461E2F1E413433336396905941	370130000	Z	Avrillé-les-Ponceaux	3701300	37013	37	24	33
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	01060000206A08000001000000010300000001000000BB0100003333333385AA1E419A999999328559419A9999998BAA1E41333333B343855941CDCCCCCCC8AA1E41CDCCCC2C53855941333333337FAB1E41333333F3578559413333333315AC1E41CDCCCC4C5A8559413333333383AC1E41CDCCCC0C598559416666666604AD1E41CDCCCCAC538559410000000072AD1E41333333534C855941CDCCCCCCC4AD1E4166666686408559419A99999931AE1E41CDCCCCAC3485594100000000B2AE1E419A9999D9288559419A99999953AF1E413333331323855941333333334DB11E419A9999191B85594100000000C0B11E41CDCCCCEC218559413333333387B21E41000000002C8559416666666624B31E419A9999B91E8559413333333301B41E419A9999791385594100000000ACB41E4166666646108559419A999999ABB51E419A999999178559419A999999E5B51E41CDCCCCAC1C8559419A99999939B71E419A9999B91B8559419A9999990FB91E416666664618855941333333339FB91E41000000A01C85594133333333BFBA1E41000000602B85594133333333E7BB1E41666666C63785594133333333C9BC1E41333333D33E8559419A99999913BE1E41CDCCCC6C4B8559419A99999909C01E41666666C65F855941CDCCCCCC30C11E41333333936A855941CDCCCCCCBAC11E41666666466E855941CDCCCCCCB8C21E41CDCCCCCC6F8559416666666654C31E41666666067485594166666666EAC31E419A9999B97A855941CDCCCCCC74C41E41000000C07C85594133333333C1C61E41CDCCCC2C7D8559419A99999989C71E41333333137C8559416666666658C91E41666666C67B85594166666666C0CA1E41CDCCCC8C7D85594133333333CFCB1E41666666868085594133333333A5CC1E4166666686818559419A999999A9CD1E41CDCCCC6C818559416666666646CF1E41000000007F8559410000000038D21E41CDCCCC6C7F85594133333333DFD31E41CDCCCC2C7E855941CDCCCCCCC2D51E419A9999F97A85594133333333FDD61E416666666675855941000000005ED71E419A99991975855941666666665AD81E41CDCCCC0C79855941CDCCCCCCC4D81E41000000A07B8559413333333353DA1E41000000E0888559413333333339DB1E41333333738F8559413333333355DD1E41000000C09C8559410000000074DE1E41CDCCCC4CA2855941CDCCCCCC6EDF1E41CDCCCCCCA5855941CDCCCCCCECDF1E41CDCCCC6CA98559416666666616E11E4133333373B7855941CDCCCCCCB0E11E41CDCCCC4CBC8559419A99999941E21E41CDCCCC4CBF8559419A99999949E31E419A999999C285594133333333B9E51E41666666C6D78559416666666688E61E419A9999F9E08559416666666696E71E41333333D3EE8559410000000010E91E41333333F3FB85594100000000A6E91E410000008000865941CDCCCCCCD4EA1E41000000200F86594100000000AEEB1E419A9999391B8659419A9999997FEC1E41000000202486594100000000BCED1E41000000E033865941000000003EEE1E41333333B3388659413333333371EF1E41000000E04886594133333333FBF01E41CDCCCC4C548659419A9999990BF21E41666666665E8659416666666660F31E41333333335F8659419A999999A1F41E4100000040618659413333333393F51E419A9999196286594133333333E7F61E419A9999B9608659413333333379F71E41666666065F8659410000000072F81E41666666665F865941333333334FF91E41CDCCCC6C5C8659419A99999911FA1E41CDCCCC0C5B8659419A999999AFFA1E419A9999F95D86594100000000A2FB1E41333333136586594133333333BFFC1E41333333F36F8659419A9999992BFE1E419A9999397F8659419A99999985FE1E41CDCCCCCC83865941CDCCCCCCE0FE1E4166666626808659419A999999F9FF1E419A99991982865941333333330D011F419A9999D98486594133333333B3011F4133333393878659419A99999943021F419A9999B9878659419A9999993B041F41CDCCCC4C83865941666666660A051F41666666E6818659410000000034061F41CDCCCC8C838659419A999999B5061F41CDCCCC6C8386594100000000D4071F41000000C08086594166666666D0081F4100000000818659410000000068091F419A9999597786594166666666C2091F416666668666865941CDCCCCCC700A1F41333333F35D86594100000000F80A1F419A9999195A86594133333333930B1F41CDCCCC6C598659419A999999A30D1F41666666C65986594133333333150E1F41CDCCCC4C50865941000000006A0F1F41000000A0568659413333333301101F4100000080518659413333333343111F419A9999D950865941333333330D121F4166666606548659413333333301131F419A9999794D8659419A999999CD141F419A99993940865941666666664A151F41333333D3478659419A99999959151F41CDCCCC4C448659419A999999D3161F413333333339865941CDCCCCCCE6171F419A999919368659410000000062191F41333333133386594100000000421D1F41CDCCCC0CD98559410000000072211F419A9999799A855941666666665A221F41333333F39085594133333333D9221F41CDCCCCAC8A855941333333332D231F41333333138B85594100000000C0261F41333333B36D855941CDCCCCCC58271F41000000006C8559413333333391271F41000000C0658559419A9999996F271F419A9999B96385594100000000B8281F4100000020558559419A99999937291F41CDCCCC6C50855941666666667C2B1F41666666463D855941666666661C2C1F419A99995937855941CDCCCCCC882D1F41CDCCCCEC2785594133333333CD2E1F41000000C01D85594100000000842F1F41CDCCCC8C1285594166666666FA2F1F41333333930C8559419A999999AD301F41666666C605855941CDCCCCCC3E311F419A999979FD8459416666666656321F419A9999F9EB8459419A9999998F331F419A999939D7845941CDCCCCCC3C341F41CDCCCC0CCD8459419A99999967331F4166666666C58459410000000034341F41333333F3B78459413333333391361F41CDCCCCCC8384594100000000E6371F41333333F3698459413333333369381F41CDCCCC0C5F8459419A9999992F391F419A999979508459419A999999CF3A1F41666666C6538459419A999999213B1F41666666E651845941666666664C3C1F4166666686458459419A9999995F3D1F41CDCCCCCC3C84594133333333AB3F1F41666666262C845941CDCCCCCC34411F41CDCCCC2C2684594166666666FC411F4100000060218459410000000092421F419A9999D91B8459419A99999961431F413333331312845941CDCCCCCC42441F41CDCCCC2C04845941333333331D451F4100000040FB8359413333333345471F41CDCCCCCCE28359413333333385471F4133333333E183594100000000A4471F4166666686E983594133333333B54B1F41000000E0DF835941000000005C501F41666666E6F3835941000000005C501F419A999959EA8359416666666646501F41333333D3C68359413333333345501F41333333F3BA8359413333333367501F41000000A0A483594166666666B0501F41CDCCCC8C9683594166666666D6501F410000002089835941CDCCCCCC7C511F419A9999F96B835941333333338B511F41CDCCCCCC46835941CDCCCCCCE8521F41CDCCCC0C4883594100000000E0531F41333333734C83594133333333AF541F419A9999F94B835941666666662E551F41333333134D83594166666666AE551F41666666C64F835941CDCCCCCC30561F4166666646508359410000000046561F419A9999D9378359410000000088571F4166666666318359419A999999CF571F41CDCCCC4C2E835941CDCCCCCCF6571F410000002020835941666666661E581F416666668618835941333333339B581F41CDCCCC8C0D83594166666666D0581F41000000E00183594166666666D4581F419A999939DF825941CDCCCCCC2C591F419A999999CD8259413333333351591F41666666E6C3825941333333335D591F4100000080B98259419A9999999D591F41CDCCCCECA782594166666666F2591F4166666606A1825941CDCCCCCC505B1F41000000E0888259419A999999BD5B1F41666666067D82594100000000FA5B1F41000000A07982594166666666CA5B1F419A99999977825941CDCCCCCCD05A1F41CDCCCC6C66825941CDCCCCCC6C5A1F4166666606628259416666666618591F413333331357825941666666668A581F41CDCCCC0C1E825941CDCCCCCC62581F41CDCCCC8C14825941CDCCCCCCE0571F41000000A008825941333333338F571F41000000C0FC81594133333333A3571F4133333393ED815941CDCCCCCC08581F419A9999F9EC81594133333333FB571F41666666E6DD81594166666666AC561F4100000020DD8159410000000012551F41CDCCCCCCDC81594133333333D5531F4100000000DC815941CDCCCCCC30531F419A999999DA81594133333333B7521F41333333D3D68159413333333345521F4100000060D0815941333333339D511F419A999999D2815941CDCCCCCC1A511F4133333313D0815941333333336D501F4166666646CF81594166666666504F1F41666666A6D081594100000000604E1F4166666686CD81594100000000224B1F41333333B3D7815941CDCCCCCCD6491F4100000020DB81594166666666E6481F41333333D3D881594166666666CE471F419A999919D4815941CDCCCCCCE4461F41CDCCCC6CD58159413333333343461F4133333333DB8159419A99999905451F419A999979F881594166666666AA441F4166666646F58159410000000070441F41000000C0F78159419A9999990F441F4100000020008259410000000088431F419A9999D903825941666666662C421F41CDCCCC4C02825941666666660A401F4100000020FE8159419A999999B13E1F41666666E6FD81594133333333C13D1F419A999999FC81594100000000D63C1F4133333393F2815941666666667C3B1F4100000060E78159419A9999991F3A1F41000000C0DE8159410000000012391F41CDCCCC0CDD81594100000000FE371F41333333D3DF815941CDCCCCCC7C361F419A999919E58159419A999999FB351F41CDCCCCACEA81594133333333FF341F4100000000F28159416666666694331F41666666E6F9815941CDCCCCCCAE311F41666666860582594100000000AC301F41CDCCCC2C0E825941333333336F2F1F419A9999D9168259419A9999996B2E1F41666666A61A8259419A999999AF2D1F41333333F31B825941CDCCCCCCCC2C1F41CDCCCCEC1E82594166666666BC2B1F419A9999192182594166666666142B1F410000004025825941666666661E2A1F41333333B32C8259413333333383291F416666664633825941666666664C281F41666666863982594166666666BE271F4100000080408259419A9999991D271F41CDCCCC2C4D8259413333333397261F416666666652825941333333331B261F41CDCCCC6C5382594100000000AA251F4100000080508259416666666658251F41333333B34A8259419A999999F1241F41333333534782594100000000EA231F41333333D349825941333333338D231F41CDCCCC0C47825941CDCCCCCC22231F41CDCCCCAC3982594133333333D3221F41000000C028825941CDCCCCCCA4221F41000000A0268259416666666662221F41666666A61D8259410000000050221F41CDCCCCCC13825941CDCCCCCC0E221F41333333F30B825941333333337F211F419A9999B90482594166666666F0201F41666666660482594133333333111F1F419A9999990F82594100000000961E1F41666666E61082594133333333BF1D1F419A9999590D8259419A999999C11C1F41333333730B82594133333333E51B1F41666666660D825941666666661C1B1F41CDCCCC8C1182594100000000121A1F413333331310825941CDCCCCCC78181F41000000801182594100000000E2131F41333333331882594166666666CE111F41666666C61F8259416666666656101F419A99993923825941000000003A0F1F419A9999B92E825941CDCCCCCC4A0E1F41333333D33982594166666666D80D1F416666668649825941CDCCCCCC780D1F41666666665982594100000000D20C1F41666666666C82594100000000620C1F41666666867682594133333333E10B1F41333333D37F825941333333336D0B1F41666666A68282594133333333C90A1F41CDCCCC6C84825941666666663A0A1F41000000008F82594100000000D2091F41666666E69B82594166666666A2091F41CDCCCCCC9F82594166666666E6081F4100000040A18259419A9999997B081F41CDCCCC0C9A8259410000000018081F41333333D3988259410000000096071F41666666E69B8259410000000078061F4100000000A8825941CDCCCCCCE0051F4100000060A38259419A99999983051F41666666E6A7825941CDCCCCCCE2041F419A9999F9B48259410000000062041F41CDCCCC2CBD82594166666666DA031F4133333353C3825941CDCCCCCC60031F41000000C0CE825941333333332D031F4133333333D18259416666666650021F41CDCCCC8CD282594166666666E4001F41333333B3D0825941CDCCCCCC48001F41CDCCCC0CD48259419A999999ADFF1E41CDCCCCCCD98259410000000054FF1E419A999959E2825941CDCCCCCCBEFE1E41666666A6E3825941CDCCCCCCC0FD1E4133333353DF825941000000000AFD1E41CDCCCCECD88259419A9999994DFC1E41333333D3D7825941CDCCCCCC84FB1E4100000000DD8259419A999999E3FA1E41CDCCCCCCE482594166666666AAFA1E419A9999B9EB8259419A9999991BFA1E4166666646F0825941666666666CF91E419A999959F082594133333333F7F81E4133333393ED8259419A999999F9F71E41333333B3ED8259419A99999981F61E41000000C0F08259410000000092F51E41CDCCCC8CF8825941666666669CF41E419A999999FF82594100000000E0F31E41000000E0FE8259410000000016F31E419A9999B9FB825941000000005AF21E41333333D3FB825941000000002AF11E419A9999B90583594133333333A3F01E4166666666128359419A99999923F01E4100000080228359416666666662EF1E410000000030835941666666669AEE1E41333333D3398359410000000004ED1E41666666264F8359413333333381EB1E41333333B36583594166666666DEE91E41CDCCCC0C7F835941CDCCCCCCEEE81E41CDCCCC6C81835941666666666AE71E41666666668D835941000000000AE71E419A99995994835941CDCCCCCC8EE61E41666666A697835941333333332DE61E4100000080968359410000000070E51E41CDCCCCAC8F835941333333331BE51E419A9999D98A8359419A999999BFE41E419A999979888359410000000072E41E41666666268A835941666666662CE41E41CDCCCC2C97835941333333330DE41E41CDCCCC8CA28359419A999999B3E31E4100000020AB83594100000000F2E21E4133333333B6835941CDCCCCCC3CE21E419A999959BB835941000000005AE11E41CDCCCC4CBC8359419A999999BDE01E41CDCCCC4CB8835941CDCCCCCC98DF1E419A9999D9B8835941CDCCCCCCD6DE1E41CDCCCC6CBD83594100000000C8DD1E41CDCCCC2CCC835941CDCCCCCC66DD1E4133333373CD8359413333333399DB1E41000000A0C9835941333333338BD91E419A999919C98359410000000026D81E41CDCCCCACC983594166666666AAD71E41333333F3C8835941CDCCCCCC7CD71E4166666666CB8359419A999999A9D61E4100000060DF8359419A999999A7D51E41CDCCCC8CEF835941000000006ED51E41000000E0F48359410000000028D51E4133333313FF8359413333333373D41E413333337306845941CDCCCCCC5CD31E41333333F30F8459419A99999959D21E4133333353138459419A999999F1D11E410000006013845941666666667CD11E41000000001184594133333333C7D01E41000000C014845941CDCCCCCC36CF1E41333333D326845941CDCCCCCC6ECE1E419A99997930845941000000008CCD1E41CDCCCC0C358459410000000088CC1E41666666863184594133333333C5CB1E41CDCCCC0C32845941333333333DCB1E41CDCCCC8C3684594166666666D6CA1E41333333F33F845941333333336FCA1E41333333B345845941CDCCCCCC14CA1E41CDCCCC2C48845941CDCCCCCC72C91E41000000E0498459416666666618C91E41333333934D845941CDCCCCCCE4C81E413333331352845941333333337DC81E419A9999F95484594100000000FEC61E41333333935584594133333333A9C61E419A9999F9518459419A999999C5C51E413333331350845941CDCCCCCC4AC51E413333335351845941666666667AC31E41666666266A845941000000001AC31E419A9999B9728459416666666678C21E419A9999197A84594133333333EDC01E41CDCCCC2C7F8459419A99999957C01E419A9999D97E84594166666666E8BF1E4166666606788459419A999999F1BE1E41CDCCCC8C7884594133333333FBBD1E41CDCCCCEC7B84594100000000B4BD1E4166666686788459419A9999997FBD1E41666666A670845941666666668CBD1E41CDCCCCAC6C845941CDCCCCCC36BC1E41CDCCCC2C6E8459416666666612BC1E416666660670845941CDCCCCCC0EBC1E41CDCCCC8C7F8459416666666624BB1E419A9999997E84594133333333ABB91E41666666467E8459413333333367B81E41666666067F8459416666666616B81E41666666C683845941CDCCCCCC40B81E41CDCCCC4C88845941333333335FB81E4166666606938459410000000032B81E413333331395845941333333330BB71E41CDCCCC6C9A84594133333333C5B51E41CDCCCC4C9C8459410000000028B51E41666666269E84594133333333B5B41E41666666269A84594166666666D8B31E41333333D3978459416666666652B31E41000000008F8459413333333371B21E419A999979898459416666666624B21E4133333313948459419A9999997FB11E41CDCCCC4C96845941CDCCCCCC26B11E41000000C09F8459419A99999913B11E4100000080A7845941CDCCCCCC88B01E4100000000AD84594100000000ECB01E41666666A6B18459419A9999997BB01E419A9999B9B784594100000000B6B01E41000000C0BC8459419A999999ADB01E419A9999F9C384594100000000D6B01E419A999999C7845941000000009EB01E4100000080CB8459410000000012B01E4133333393CD8459413333333393AF1E41000000E0D58459416666666622AF1E4166666626D58459416666666614AF1E4166666646D98459413333333373AF1E4100000040DD845941CDCCCCCC80AF1E419A999979E18459419A999999E7AF1E419A999919E18459413333333371AF1E41CDCCCC2CE884594100000000FEAE1E419A999959E88459419A9999991FAE1E41333333F3E6845941333333332FAE1E4166666666ED845941CDCCCCCCE0AD1E419A999959F58459416666666682AD1E41CDCCCCECF9845941666666662AAD1E41CDCCCCACFB8459413333333325AD1E41000000000085594100000000E2AC1E419A9999F9078559419A99999993AC1E419A9999990A8559419A99999975AC1E419A99991913855941000000003AAC1E419A9999591385594133333333CBAB1E41CDCCCC2C0E8559416666666646AB1E413333339313855941666666664AAB1E41000000E01A85594100000000CAAA1E4133333313258559413333333385AA1E419A999999328559413333333385AA1E419A99999932855941	01010000206A080000C489A55070071F41666666B62A845941	370140000	Z	Azay-le-Rideau	3701400	37014	37	24	27
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	01060000206A0800000100000001030000000100000012010000CDCCCCCCEF4A20416666660649895941666666665C4B2041CDCCCCAC588959419A999999224C2041666666A6818959419A999999574C2041333333339189594133333333684C204133333333998959419A999999B44C204133333313A089594166666666344D2041CDCCCC8CB18959419A9999994D4D20419A999919B7895941CDCCCCCC9E4D204133333393BD895941CDCCCCCC3C4E2041666666E6C689594133333333584E204100000080C9895941333333337A4E20419A999999E38959419A999999364E20419A9999F9E4895941333333333F4E2041333333F3EA89594166666666AB4E2041000000C0EB895941CDCCCCCCE64E2041666666A6FE89594133333333034F2041333333B30A8A594166666666604F20419A999959238A5941000000002E502041666666E6428A594166666666A0502041666666C63E8A59419A9999991B512041333333B3378A5941CDCCCCCC4E512041000000C0328A5941333333334F512041666666463F8A59410000000060512041000000C0438A594133333333A0512041666666E64D8A59419A999999F251204100000020678A5941CDCCCCCC5952204166666606838A59419A999999A2522041666666E6998A594166666666C252204133333313988A59410000000097532041CDCCCC0C9D8A594166666666AD532041333333139F8A59419A99999917542041CDCCCC6CA28A59419A9999997B542041CDCCCC2CA98A59419A999999D254204133333313B88A594100000000465520419A9999B9C78A5941CDCCCCCCEA552041333333F3D58A59419A99999961562041CDCCCC0CDD8A594133333333E95620419A999939F28A5941CDCCCCCC37572041666666E6F48A59410000000090572041666666E6FE8A59416666666626582041333333F30D8B59413333333380582041CDCCCCEC158B59419A999999C95820419A999919098B5941666666663C59204100000060108B59419A999999C859204133333373178B594166666666535A2041000000A0208B594100000000735A204133333393258B594133333333A75A2041CDCCCCCC1E8B594166666666945B204133333373478B594100000000945B2041666666E64A8B5941000000003D5C204100000000568B594166666666305D2041CDCCCC2C658B594166666666C05E2041000000C0808B5941000000004A60204100000000A58B5941CDCCCCCC686020419A999959A78B59419A999999AB6020419A9999B9A38B59419A999999B5602041000000A0A68B59419A999999E960204166666686AA8B59419A9999996861204100000040AD8B594100000000A2612041666666A6B68B59419A999999BE61204100000080B38B594100000000146220419A999979C38B5941666666665562204133333313CD8B5941CDCCCCCC2E63204100000020E88B5941CDCCCCCC8263204100000000EF8B5941CDCCCCCC866320419A999959F38B594166666666D36320419A999939058C5941CDCCCCCC22642041666666461B8C594100000000C76120419A9999B9438C5941333333330562204100000080528C594133333333C5622041CDCCCC2C788C5941CDCCCCCC63632041CDCCCC6C9D8C5941CDCCCCCC91632041333333F39B8C5941000000000E6420419A9999F9C78C594133333333796420419A999959D08C59419A999999E864204166666686CC8C59419A999999BA652041CDCCCC8CF28C59419A999999DA662041CDCCCC0C068D59413333333337672041000000A0398D5941666666669E6720419A999979358D594100000000FA67204100000060368D5941CDCCCCCC1B68204166666626358D5941CDCCCCCC4B682041000000A02E8D59416666666686692041CDCCCC0C128D594166666666356A2041666666A60F8D59419A999999FF6A204133333313098D594166666666536B204133333353078D59419A9999999A6B20419A999919078D594166666666106C2041666666C6028D5941000000002B6C20419A9999B9028D59419A9999998F6C20419A9999D9088D5941CDCCCCCCDF6C20419A999999078D59419A9999995C6D2041CDCCCCAC008D594100000000D36D2041CDCCCC4CF98C594133333333126E2041666666E6F38C594166666666B96E204100000000EA8C59419A999999F26E204100000060E78C59419A999999556F204133333313E88C59419A999999956F204166666646E58C594100000000D16F2041CDCCCC6CDF8C59419A9999993D7020419A9999F9D88C59419A999999967020419A999919DA8C5941666666663E7120419A9999F9C88C59419A99999978712041333333F3C48C594166666666CB7120419A9999D9C18C5941CDCCCCCCFA71204100000060C18C59413333333346722041CDCCCCACBD8C594133333333BC72204133333373B58C594133333333D372204133333333B28C59419A999999E4722041000000E0A98C594100000000257320419A999959A18C594100000000797320419A9999799B8C594133333333937320419A999979968C594100000000EB732041CDCCCCEC8E8C594100000000EF74204100000060848C59419A99999930752041CDCCCC8C858C59413333333383752041CDCCCC8C808C594166666666AA752041333333F37F8C5941333333335F762041333333D3798C594133333333EA762041000000C07A8C5941CDCCCCCC1D772041666666867C8C59416666666689772041000000407B8C5941CDCCCCCCCD77204166666686788C59419A9999994A78204100000080718C59413333333374782041CDCCCCEC6D8C594133333333BB782041CDCCCCCC6B8C59419A9999992D792041666666466D8C5941CDCCCCCCBD79204166666626688C5941CDCCCCCC1B7A2041CDCCCC2C568C594100000000577A2041CDCCCCAC518C594166666666B47A2041CDCCCC2C508C5941666666663B7B2041333333934B8C5941CDCCCCCC9B7B204133333393498C5941CDCCCCCC497C2041666666C6478C594133333333BC7C2041666666064E8C5941CDCCCCCCF17C20419A9999D9528C594100000000307D204133333353518C5941CDCCCCCC737D2041666666264C8C594133333333C47D204133333353448C594133333333B97D204166666666428C594100000000147B204133333353A98B59419A999999BE7A2041CDCCCC4C968B5941000000005A7A2041333333337D8B5941CDCCCCCC4E7A2041CDCCCC0C6F8B59419A999999337A2041CDCCCCAC638B594166666666E879204133333373528B59419A999999E479204133333353438B5941000000000B7A20419A999959318B594166666666057A204133333333248B594166666666DB7920419A999919018B594166666666E37920419A999939F38A594166666666167A2041666666C6DE8A5941CDCCCCCC167A2041666666C6D68A594166666666F7792041333333F3CD8A5941666666668379204166666606B98A59413333333354792041666666A6A98A59419A999999347920419A9999F9888A59410000000015792041333333B36F8A594166666666C17820419A999939638A594166666666BD77204166666626468A59416666666685772041333333733C8A59419A9999993177204166666666238A59419A9999990B772041000000C01D8A59410000000080762041CDCCCC6CDB895941000000009E76204166666626DB895941666666668B7620419A999979C6895941333333333575204133333373C3895941000000000775204100000060BD89594166666666C8742041CDCCCC8C9E8959419A999999BC742041000000C09B8959419A9999997E7420410000004082895941333333337E742041CDCCCC0C768959419A999999B7742041CDCCCCCC5E8959419A999999C8742041000000203789594133333333EC742041666666062F8959416666666671742041333333F327895941CDCCCCCC7B742041666666A626895941666666667C742041CDCCCCAC1A8959410000000068742041333333530A895941666666665374204133333313FF885941000000002574204133333313F588594166666666E973204133333393EB88594133333333B273204100000040E68859419A99999979732041666666A6DA8859416666666675732041000000A0D38859416666666685732041000000A0C2885941333333339673204100000080B9885941666666668D7320419A999919AF8859413333333376732041666666C6A68859419A9999990E732041CDCCCC2C888859413333333327732041666666A67B8859419A999999547320419A9999196B88594166666666D5722041333333334D88594133333333EB722041333333B34988594100000000A9722041333333533C885941666666665F712041CDCCCC2C0088594166666666EC6F20419A999919B7875941666666663E6F2041000000209B87594166666666906E204133333333828759419A999999716E2041666666467C87594133333333E06D2041666666C67587594133333333CE6C2041CDCCCCCC2B8759419A999999506C2041666666463387594133333333C26B20410000000039875941CDCCCCCC326B2041000000003C87594166666666CE6A2041333333933C8759419A999999436A2041CDCCCCCC3B87594100000000A96920419A9999793C8759413333333355682041333333734487594100000000D06720419A999979468759419A9999995A6620419A9999994787594166666666CA65204166666626428759410000000062652041CDCCCCAC428759410000000063642041CDCCCC4C46875941CDCCCCCCE26320419A9999594B8759419A9999995A622041000000C064875941CDCCCCCCE0612041333333F36D8759419A99999999612041333333D37087594166666666EC6020419A999999758759419A999999495F2041000000407C8759419A999999AF5E20419A9999F97E87594166666666455E2041333333D37F875941CDCCCCCC0C5E2041333333137E875941CDCCCCCCCD5C20419A9999B96787594133333333155C2041CDCCCCEC5987594100000000CE5B2041CDCCCCCC56875941666666661E5B2041666666465287594133333333FC5A2041CDCCCC0C5587594100000000635A2041333333D35887594166666666E759204166666606658759419A9999990C592041000000E06E87594133333333BB5820410000006070875941CDCCCCCC8F5820419A999979818759416666666679582041333333F38D8759413333333349582041CDCCCC0CAF875941000000002858204100000060C1875941333333330C58204100000080C28759410000000064572041000000A0C38759416666666683572041CDCCCC6CCE8759419A9999998757204166666666D5875941CDCCCCCC4157204133333333DF875941CDCCCCCC38572041CDCCCC2CE88759419A9999994B5720419A999939FF8759419A999999485720419A9999B936885941CDCCCCCC91562041CDCCCCCC408859419A99999950562041666666863B885941000000002B5520419A9999D9288859419A999999315420410000002027885941CDCCCCCCCF53204100000020278859419A99999900532041666666462488594100000000D6522041CDCCCCAC30885941CDCCCCCC3D522041333333335988594100000000AC512041CDCCCCCC808859419A99999935512041666666C69B885941CDCCCCCC1651204166666666A6885941000000000E5120419A9999D9AF8859413333333313512041CDCCCCECBB885941CDCCCCCC06502041CDCCCC4CA88859419A999999644F2041CDCCCC6C9B88594166666666194F20419A9999199688594166666666934E2041333333738E885941CDCCCCCC4D4E20419A9999F98B88594100000000D34D20419A9999B98988594133333333CC4C2041333333138A88594133333333B64C2041333333D3A188594166666666AD4C2041000000A0B4885941CDCCCCCCA54C204133333313B7885941CDCCCCCC8B4C2041666666C6DA88594166666666774C2041333333F3EA88594133333333664C2041000000400289594100000000354C2041000000A0388959419A999999494B20413333333343895941CDCCCCCCEF4A20416666660649895941CDCCCCCCEF4A20416666660649895941	01010000206A08000085F69DCA8E632041CDCCCC3C318A5941	370150000	Z	Azay-sur-Cher	3701500	37015	37	24	23
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	01010000206A08000044196CE2169E204100000090AD7B5941	370160000	Z	Azay-sur-Indre	3701600	37016	37	24	14
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	01010000206A080000DEF3EE7768BF1F41333333F3248B5941	370180102	H	Centre Ville	3701801	37018	37	24	1
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	01060000206A08000001000000010300000001000000020100003333333397751F41333333B3FB885941CDCCCCCCA4751F41666666A616895941CDCCCCCCD0751F419A9999392C8959419A999999FF751F41333333733E89594166666666FE761F41666666863E89594100000000AC761F419A9999194B89594100000000AA761F41CDCCCC0C4F895941CDCCCCCCF0761F41000000E04E895941CDCCCCCC44781F41CDCCCC4C57895941333333337B791F41666666266E89594166666666CA7D1F41333333B3B38959419A999999837D1F4133333353BD89594100000000827D1F41666666A6C889594133333333A57D1F4100000040CF895941000000009E7F1F419A999919C889594133333333C5801F419A999939C78959413333333347801F4166666606ED895941CDCCCCCC54801F419A9999B91A8A5941333333332B801F419A999979238A594100000000E47F1F41333333F33A8A59419A99999951801F419A9999593B8A5941CDCCCCCCC0811F4166666646448A59410000000062811F419A9999794F8A594100000000D2811F419A9999F95A8A5941000000004E821F419A9999B9658A594133333333C1821F419A9999B96D8A594166666666E2821F4133333333758A5941000000003C831F419A9999F97A8A59419A99999957831F41CDCCCC2C7F8A59419A99999987841F419A9999198D8A59410000000042841F41333333B3978A594133333333AD841F419A9999D99A8A5941000000004E861F41000000A0A38A594166666666DE861F41CDCCCC0CA58A5941CDCCCCCCFC871F419A999939AC8A5941CDCCCCCC62891F4166666686B68A59416666666664891F41CDCCCCCCB98A59419A999999BF891F41333333F3BA8A59419A999999AF8A1F4166666646C48A594166666666128C1F4133333373CF8A594100000000648C1F41CDCCCC6CCF8A594133333333698D1F419A999939CC8A594100000000008E1F4133333333CD8A594166666666848E1F41CDCCCCACD08A5941CDCCCCCCCA8E1F419A999959D08A5941CDCCCCCC848F1F41CDCCCC8CD38A594133333333E58F1F41333333F3D78A5941666666660A911F419A9999D9E08A59419A99999969911F4133333393E58A5941333333331B921F41CDCCCCECF38A59416666666664921F41333333F3FD8A59416666666690921F4100000060138B59419A9999999D921F41000000A0258B59419A99999921951F41CDCCCC2C248B59416666666650951F41CDCCCCEC328B59419A9999995F951F41333333533F8B5941CDCCCCCC32951F4166666666508B594100000000C8961F41CDCCCC0C568B59419A99999949981F41CDCCCC8C6C8B594100000000A4981F41000000E06D8B59410000000032991F41666666A6778B5941000000006C991F41333333D3788B594133333333159A1F4166666686848B59419A999999ED991F4166666646928B594133333333BD9A1F4166666626A88B594133333333B59A1F41666666C6BC8B594166666666A09A1F419A999919BF8B5941CDCCCCCCB49A1F4133333313CC8B5941CDCCCCCC4E9A1F4100000000E08B594166666666629A1F41333333B3EC8B594133333333459A1F41CDCCCCECF68B594100000000849B1F41000000200F8C5941CDCCCCCCB29B1F419A9999190F8C5941CDCCCCCC9E9B1F419A9999591E8C594166666666989B1F4100000020308C594166666666A49B1F41666666664C8C5941333333337B9B1F41333333B3588C59419A9999995F9B1F41CDCCCCCC5B8C594100000000A89C1F41CDCCCCCC588C5941CDCCCCCCBEA01F41666666664E8C59416666666672A11F41333333337C8C59419A9999990BA21F4166666646828C59419A9999991DA21F41666666E67F8C594166666666C8A21F419A9999F9828C594133333333DFA31F4100000080838C59419A999999E5A31F41666666268E8C5941CDCCCCCCAAA31F41CDCCCC0CA18C59410000000090A31F41666666E6B18C59416666666652A31F41666666C6CC8C59419A99999941A31F419A9999D9ED8C594133333333C9A41F41000000C0F48C5941CDCCCCCCC0A61F4100000000018D59419A999999A9A81F41000000E0098D5941CDCCCCCC4CAB1F4166666646138D594166666666A6AC1F41CDCCCCAC188D594133333333C1AE1F41000000A01F8D59416666666690B01F41333333B3238D59416666666640B21F4100000000248D59419A999999D9B21F4133333333258D594133333333B3B41F41333333D3308D594166666666F8B41F41666666662A8D59416666666666B51F4166666666258D594166666666F2B61F41CDCCCC8C028D59413333333335B71F41000000E0FA8C5941333333338FB71F41666666A6E38C5941CDCCCCCC90B71F41666666C6C58C59413333333385B71F41CDCCCC6CBD8C59419A9999995FB71F41666666A6B68C5941CDCCCCCCD6B61F41666666A6A48C5941000000009EB61F41CDCCCC6C9B8C59419A9999995BB61F41000000A08B8C59419A99999943B61F419A9999B9818C59419A9999993BB61F4133333353708C5941CDCCCCCC70B61F41000000E0428C59419A99999957B61F4133333393228C5941666666662AB61F41666666661A8C59410000000046B61F4166666646138C59416666666624B61F4166666686108C59410000000032B61F41333333B3048C594100000000EEB51F4133333313D98B594133333333EFB51F4166666606D28B59416666666658B61F419A999959C48B5941CDCCCCCC08B71F4133333353B38B59416666666628B71F41666666A6A58B59416666666602B71F41333333739B8B594166666666AAB61F4166666666968B594133333333F9B51F4133333313928B594166666666A8B51F41000000408C8B5941000000009CB51F41CDCCCC2C848B594100000000C2B51F41333333B3678B5941666666661AB61F41000000C0448B5941666666664CB61F41000000E03A8B594166666666AAB61F419A999999308B5941CDCCCCCC1AB71F419A999959278B59416666666696B71F419A9999F9208B59410000000010B81F41CDCCCCCC208B59413333333353B91F4166666606278B59419A999999B9B91F4166666626218B59413333333307B91F41000000C01A8B59419A99999923B71F41666666060B8B594133333333DDB51F4166666686F28A594100000000DAB41F4166666626DB8A59419A99999923B41F41666666A6CF8A594166666666B2B31F41000000C0C68A5941666666662AB31F4133333333BA8A59410000000070B21F419A999959A68A5941000000007EB21F4100000080838A5941CDCCCCCC6EB21F41CDCCCC6C728A59410000000026B31F4166666646768A59419A999999E9BA1F41CDCCCCEC9E8A5941CDCCCCCCBEBD1F41666666A6AE8A594166666666AAC21F4133333393C88A59419A999999EBC51F4166666606D98A594133333333E7C51F41CDCCCC6CCB8A5941CDCCCCCC20C71F41CDCCCC6CCF8A5941CDCCCCCC4AC81F4100000040D68A59410000000010C91F41CDCCCCECD88A5941CDCCCCCCE4C91F41000000A0D98A5941CDCCCCCC7CC91F41000000A0BA8A59419A99999953C91F41CDCCCC4CA48A59416666666684C91F41000000A0908A59416666666648C91F4133333393838A5941000000000CC91F419A9999396C8A594166666666FEC81F41333333F35D8A5941CDCCCCCCD8C81F41CDCCCCCC488A594133333333D3C81F41000000E0368A594100000000EEC81F41333333F3228A5941CDCCCCCC4CC91F41CDCCCCCC128A5941CDCCCCCC88C91F4166666606048A594133333333A1C91F4133333373F5895941CDCCCCCC04C81F41CDCCCCCCDC895941666666664EC71F41CDCCCCACD3895941666666662CC61F419A999959C6895941666666662CC51F419A999939BD89594166666666E8C31F41666666C6B38959416666666644C31F419A999979AD8959410000000018C21F41666666E69E89594133333333EFC01F41666666468E8959413333333345C01F41CDCCCC4C82895941666666660EC01F41000000A07C89594100000000DCBE1F419A9999B95589594166666666C8BE1F41333333F34F8959416666666668BD1F41333333B31389594133333333E9BB1F41666666C6D6885941CDCCCCCC64BA1F41000000809A8859416666666634B91F41666666A668885941CDCCCCCC5CB81F41CDCCCC0C46885941CDCCCCCC96B81F419A9999D9458859410000000078B81F419A9999B94188594133333333E1B71F419A9999B9348859419A999999A1B61F41666666861E885941CDCCCCCCE0B51F41CDCCCCEC1188594100000000C4B41F41CDCCCCAC048859416666666600B41F41000000A0ED8759413333333361B41F4100000000BD87594100000000A6B41F4166666606A68759419A999999ABB41F41CDCCCC8C56875941000000002EB41F4133333373558759419A99999955B21F41000000E0568759419A99999907B21F416666666656875941000000004CB11F419A9999B95087594133333333AFB01F4100000060498759419A99999959B01F41CDCCCC8C4387594166666666F0AF1F41CDCCCC0C39875941333333338FAF1F41000000202C8759416666666614AF1F419A9999392D8759413333333373AD1F41666666A6398759413333333343AB1F41CDCCCCEC47875941CDCCCCCC6AAA1F41333333B34C875941CDCCCCCCACA51F41333333F35487594166666666FAA31F41333333135787594133333333A9A21F41CDCCCC8C5B87594100000000A2A11F41000000606087594166666666129F1F41000000E06E8759419A999999D19D1F41333333F37687594166666666289D1F41666666067887594133333333E9991F41CDCCCC6C7587594133333333EF981F41CDCCCC8C798759419A999999A5981F41666666C6798759419A99999997961F41666666A674875941CDCCCCCC4E941F41000000A076875941CDCCCCCCBE921F419A9999F9798759419A999999A1901F41333333937F875941CDCCCCCC6A901F4133333373818759419A99999931901F41CDCCCC0C7E87594100000000888F1F41333333937F875941CDCCCCCC988B1F41333333D393875941CDCCCCCCC6891F419A9999F99D8759419A99999947891F4166666666A18759419A9999991F881F41000000E0B08759413333333371861F419A999999BB8759416666666612861F419A9999B9C487594100000000D8851F4100000040D987594166666666AA851F4133333353E38759410000000062851F41CDCCCC2CE787594166666666DE841F4133333333F28759419A99999989821F41CDCCCC0C1F885941000000003E811F41000000803688594133333333C7801F41666666C6458859419A9999991D801F41000000C0568859410000000008801F41666666E6648859419A999999817F1F41CDCCCCAC6E885941666666666A7F1F41000000A07288594100000000687F1F41333333137C88594100000000B07E1F41666666668F885941000000008A7E1F41CDCCCCEC9788594100000000827E1F41CDCCCC2CA188594100000000627E1F4133333373A4885941000000006C7C1F4133333333B1885941666666667E7A1F41CDCCCCCCBC8859419A999999AB791F4166666646C38859416666666634791F4166666686C18859413333333331781F4166666606BC8859410000000010771F41333333F3B8885941CDCCCCCC28761F41CDCCCC0CB988594166666666E0751F4133333353FA8859413333333397751F41333333B3FB8859413333333397751F41333333B3FB885941	01010000206A08000004C02D9878A41F41666666762C8A5941	370180101	H	Ouest Ville	3701801	37018	37	24	18
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	01010000206A0800007953ED3D13C91F41CCCCCC0C118D5941	370180103	H	Est Ville	3701801	37018	37	24	8
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	01010000206A08000093653BA4943420416666666601595941	370190000	Z	Barrou	3701900	37019	37	24	31
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	01010000206A0800005822F45770CC2041333333F33B735941	370200000	Z	Beaulieu-lès-Loches	3702000	37020	37	24	4
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	01010000206A080000E22BBE22950820416666663666A55941	370210000	Z	Beaumont-Louestault	3702100	37021	37	24	56
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	01010000206A080000707070F04CBC1D41333333736F7C5941	370220000	Z	Beaumont-en-Véron	3702200	37022	37	24	19
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	01010000206A08000028A3F5476236214166666626D5785941	370230000	Z	Beaumont-Village	3702300	37023	37	24	19
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	01010000206A08000079C3DAB74FED1D4166666696B5895941	370240000	Z	Benais	3702400	37024	37	24	20
01060000206A08000001000000010300000001000000E000000033333333FB1C1F4100000080DC8B5941000000000E1D1F41333333F3DE8B594100000000221D1F419A999999E48B594100000000341D1F419A9999F9E98B5941000000004E1D1F41CDCCCCACF08B5941000000006A1D1F41CDCCCCACF58B5941CDCCCCCC941D1F419A999959FC8B594133333333D71D1F419A999919048C5941666666665C1F1F4166666666318C59416666666658211F41000000006D8C5941666666664C221F4133333373898C594133333333B9221F4133333373958C5941CDCCCCCCD0221F4133333313988C59410000000042231F41CDCCCC6CA58C59410000000070231F41333333F3AC8C59413333333381231F419A9999B9AF8C594133333333BF231F419A9999F9B88C594100000000CC231F419A9999D9BA8C594133333333D1231F4100000020BB8C59419A999999F9231F4100000020BD8C594133333333FB261F41000000A0F78C594133333333A52A1F419A9999192F8D594166666666FE2E1F41CDCCCCEC608D5941CDCCCCCC002F1F4166666606618D59416666666638331F41000000A0898D59419A99999911351F41666666468E8D594166666666D63D1F41CDCCCC2CB98D5941CDCCCCCC0E481F41CDCCCC6CDC8D594133333333734D1F419A9999F9188E594166666666E24F1F41000000E02E8E5941666666666C511F41CDCCCC0C3D8E59416666666684561F4100000060458E59419A999999AD5D1F41CDCCCC0C638E59419A9999996D611F4100000020668E59410000000034631F419A9999396E8E594166666666FE651F41333333B37A8E5941CDCCCCCCD6671F41333333B3828E594100000000866A1F419A9999F98A8E5941CDCCCCCC946E1F4100000000958E5941CDCCCCCCBC6E1F4166666666958E5941CDCCCCCCB66F1F41CDCCCCCC978E59419A9999999F701F419A9999F99A8E5941333333334F711F41666666669D8E5941CDCCCCCC6C711F41666666C69D8E5941000000009C721F41000000C0A58E59416666666614731F41CDCCCC0CA98E594166666666207D1F419A999999DA8E59410000000032811F4100000060E88E5941CDCCCCCC9E821F419A999939D28E594133333333B7821F419A9999B9D08E5941CDCCCCCCE0821F41333333B3C48E59419A999999C7821F41333333D3C48E594100000000EA821F4100000000B78E5941CDCCCCCC00831F41666666E6AD8E59416666666640831F4100000040948E5941333333336B831F419A9999197F8E59413333333383831F4166666666778E594166666666BA831F41000000E0638E5941CDCCCCCCE6831F41333333F34F8E594133333333F7831F419A999979468E59419A99999901841F4166666646418E59410000000006841F41CDCCCC4C3F8E59410000000012841F41666666C6398E59419A99999915841F4133333393388E59419A9999992D841F41CDCCCC0C2E8E59419A999999EB831F41000000202D8E594166666666CA831F41333333932C8E59419A9999992D831F41333333D3288E59419A99999931831F419A9999F9258E59419A99999939831F4100000080238E5941CDCCCCCC68831F41000000001B8E5941000000008C831F41666666C6148E594166666666B6831F419A999999098E594133333333C7831F41CDCCCCEC018E5941CDCCCCCCCA831F41CDCCCC6C008E5941CDCCCCCCCE831F4100000000FC8D594100000000D4831F41CDCCCCCCF68D594100000000C8831F4133333393EC8D594166666666CA831F419A999959EA8D59419A9999993F831F419A9999B9E88D5941CDCCCCCC32831F41CDCCCCCCE58D59413333333301831F4166666606E58D5941CDCCCCCCA8801F419A9999B9DB8D594133333333FD7B1F41CDCCCC2CC98D594100000000E8761F4100000000B58D5941666666660C761F41333333F3B18D594133333333BD751F419A9999D9B08D59419A9999996D701F41666666269B8D594166666666D26D1F41000000E0908D594100000000006B1F41CDCCCCCC848D59419A999999AF6A1F4166666606848D5941CDCCCCCC946A1F4133333353848D5941666666665E6A1F4100000040868D59419A9999993D6A1F419A9999F9868D59419A999999276A1F41CDCCCCCC868D59419A999999ED691F41CDCCCCAC858D59416666666600691F419A9999F9818D594100000000B0681F419A999939808D5941666666665A681F419A9999197C8D5941000000001E681F41666666067A8D59419A99999933671F41000000A0768D59413333333319661F4100000080718D5941333333331F651F41CDCCCCEC6C8D59419A99999901651F41666666666C8D594166666666F0631F41CDCCCC0C678D59416666666610631F4133333333628D594100000000D0621F41CDCCCCCC608D594133333333E1601F41CDCCCC0C558D594166666666E85F1F41333333734E8D594100000000245E1F41000000A0418D594133333333855D1F41666666A63D8D5941CDCCCCCC8A5D1F41CDCCCC6C3B8D5941CDCCCCCCDC581F41CDCCCCEC168D5941CDCCCCCC62561F41000000A0038D5941CDCCCCCCEA4D1F4133333393C18C594100000000DA4D1F4100000080C18C594166666666D24D1F419A9999F9C18C59419A999999D14D1F4166666626C28C594166666666CC4D1F41CDCCCCCCC38C5941CDCCCCCCCC4D1F41CDCCCC0CC78C594166666666BE4D1F4166666626C78C5941CDCCCCCCBE4D1F419A999939C98C594133333333C34D1F4166666626CB8C5941666666669E4D1F4100000080CA8C59419A999999E74C1F4100000060C68C59419A999999B94C1F41CDCCCCCCBB8C5941CDCCCCCC8E4C1F419A9999F9B98C59419A999999A34C1F4133333393B78C594166666666884B1F41333333B3AE8C59419A9999997F4B1F4166666666AE8C5941CDCCCCCCF4491F41666666C6A28C594166666666DE491F419A9999B9A38C5941666666669C491F4133333313A68C59416666666682491F4166666686A58C59419A9999990D481F41333333939A8C5941333333331D471F4133333333938C5941CDCCCCCC2E451F4133333333848C5941CDCCCCCC86441F41CDCCCC4C7F8C59419A99999921431F419A9999F9748C59419A99999957411F4100000080668C594166666666903F1F419A999959588C594166666666683D1F4166666686478C59419A999999533D1F41666666A6468C5941CDCCCCCC1E3D1F41CDCCCC2C458C59419A999999D53C1F4100000000438C594100000000563C1F41000000603F8C594100000000C23B1F41000000C03A8C594133333333873A1F41CDCCCCEC328C594133333333153A1F4133333333538C594100000000FE391F419A9999B9528C59419A999999AB391F41CDCCCC8C528C59413333333339381F41CDCCCC8C548C59413333333335381F4133333393548C59419A999999B7371F4100000060558C5941CDCCCCCCD2361F41666666A6578C59419A999999B5361F4166666686578C594100000000DC351F4100000080538C59419A999999BB351F41CDCCCC6C528C59419A999999C5351F41CDCCCC6C538C594166666666B2351F4133333393558C59410000000088351F41CDCCCCCC588C5941333333334B351F41CDCCCC2C5C8C59413333333319351F41666666465E8C59413333333329351F41666666266B8C59416666666616351F41666666666B8C59419A999999FB321F419A9999D9778C5941CDCCCCCC98311F4166666626788C59419A99999979311F41000000C0778C59419A999999C5301F41333333D3728C594100000000362F1F41333333335C8C5941666666667E2E1F41CDCCCC6C568C594100000000E02D1F41CDCCCCAC4E8C5941333333339F2D1F41333333F34C8C5941000000002A2D1F419A9999D9498C594166666666082C1F41333333B3428C5941666666665E2B1F41CDCCCC8C3E8C594100000000FA2B1F4100000000278C594166666666042C1F41666666E6248C59419A999999172C1F4100000020218C594100000000042C1F41CDCCCCEC208C594166666666A62B1F419A9999F91F8C594166666666042A1F41666666061C8C594166666666AC281F419A9999D9158C59416666666668281F41666666A6148C594133333333CF271F41CDCCCC8C118C59413333333341271F4100000080108C59416666666604271F41000000C00F8C59419A9999998D261F41333333330D8C59416666666650261F41000000E00B8C5941CDCCCCCC02261F4100000060098C59413333333373241F4100000060FE8B5941000000003E241F41CDCCCC4CFD8B59410000000064231F41000000E0FB8B5941333333332F231F419A9999F9FA8B594100000000FE221F41CDCCCCACF98B594166666666DA221F419A9999B9F88B5941CDCCCCCCBA221F419A999919F88B5941CDCCCCCC7E221F41000000E0F68B5941CDCCCCCC3C221F41666666E6F48B59419A99999923221F4133333373F38B59416666666604221F41000000E0F08B594133333333FD211F41333333B3EF8B59419A999999ED211F4166666686EF8B5941CDCCCCCCDE211F4166666626EF8B5941CDCCCCCCC8211F4133333393ED8B59419A999999BD211F4100000080EB8B5941CDCCCCCCBA211F41333333B3E98B5941CDCCCCCC8E211F4133333353E78B59419A9999996F211F41000000A0E68B59419A99999957211F4100000020E68B59416666666644211F41CDCCCCACE58B59410000000042211F41000000A0E58B5941000000002C211F419A999959E58B594100000000F2201F4166666666E48B594100000000D0201F4166666686E38B59416666666670201F4166666686E18B594166666666DA1F1F41666666C6DD8B594100000000061F1F419A999959D98B594133333333AF1E1F4100000080D88B594133333333A31E1F41CDCCCC2CD78B594100000000881E1F4133333373D68B5941000000006A1E1F41000000E0D48B5941000000004E1E1F4133333353D08B594133333333FB1C1F4100000080DC8B5941	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	01010000206A0800003932317928481F41CDCCCCEC5A8D5941	370250000	Z	Berthenay	3702500	37025	37	24	7
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	01060000206A080000010000000103000000010000001A01000000000000FA762041CDCCCC2CB3625941CDCCCCCCA3772041000000E0C3625941CDCCCCCCE0772041CDCCCC8CD1625941000000005A78204166666626E4625941CDCCCCCC7978204100000040F162594133333333A4782041000000C0F162594166666666077920419A999999DE625941000000003F792041666666E6DD62594100000000C8792041CDCCCCCCE56259419A999999FC7920419A9999B9D4625941666666669C7A2041CDCCCCCCD5625941CDCCCCCCD87A2041000000C0DA62594100000000487B204100000060ED625941333333337A7B2041CDCCCC0CF162594133333333A37B204100000000006359419A999999CB7B20413333337307635941333333337D7B204166666686206359419A999999387B20413333339334635941CDCCCCCC257B2041333333134663594133333333E17A2041666666E658635941666666669E7A2041666666C677635941CDCCCCCC767A2041333333B38E6359419A9999994B7A2041666666069863594166666666507A2041CDCCCCACA463594133333333387A204133333333B163594166666666DD7920419A9999F9C263594166666666087A204100000080E2635941CDCCCCCC197A204133333393E46359419A999999197A2041CDCCCC0CEC63594166666666FE792041000000E0F863594133333333F77920416666660601645941CDCCCCCC037A2041333333B30A64594100000000E6792041666666861264594133333333A87920419A9999591B645941CDCCCCCCF2782041CDCCCC6C29645941666666666F782041000000203A645941CDCCCCCCC9772041333333B34C6459413333333342782041666666264F645941666666661579204100000060556459419A999999817920419A9999595664594166666666C1792041CDCCCC6C596459419A999999277A20413333339362645941CDCCCCCC717A2041333333F36D64594166666666D77A20410000002077645941CDCCCCCC067B2041CDCCCC8C7F6459419A9999996F7B20419A9999F9806459419A999999537D2041333333F38B64594166666666CB7D2041CDCCCC4C8C64594100000000F17F2041000000E0846459410000000015812041666666468164594166666666A08120410000004007655941000000007F812041000000201C65594166666666708120419A9999F930655941000000002980204100000040DD655941CDCCCCCCD97F2041333333D30D6659419A9999998D7F2041CDCCCC0C416659419A9999996A7F2041333333534D665941CDCCCCCC797F2041CDCCCC0C5266594166666666737F2041CDCCCCCC58665941CDCCCCCCAC7F2041CDCCCC8C6966594100000000157F2041000000207B66594166666666BF7F20419A9999D99166594100000000137F2041CDCCCC2CC266594133333333217F204133333313C66659419A99999979802041CDCCCC2C14675941666666669F81204133333313516759419A999999B3812041CDCCCC4C526759419A9999996A8220413333339381675941333333339D822041000000808B6759419A99999943832041333333B3B667594133333333EE83204166666646B66759419A999999E484204166666646BC6759419A9999991187204166666606C8675941333333334187204133333353C867594166666666DA882041CDCCCCACBC675941CDCCCCCC0589204100000040BC675941CDCCCCCC2F8B2041000000C0AD67594166666666B68B2041333333B331685941CDCCCCCCC88B2041CDCCCCCC466859419A999999C38B2041000000604C6859419A999999C48B2041000000806468594100000000BB8B2041000000E0686859419A999999EA8B2041CDCCCC0C6B685941000000002F8C2041333333137C68594100000000248C2041CDCCCCEC90685941666666661A8C2041666666A6B0685941CDCCCCCC548C2041333333F3B0685941CDCCCCCCBD9220419A999939D2685941CDCCCCCC4497204133333373E8685941000000009A972041CDCCCC4CE36859419A999999B9972041666666E6EA6859419A9999990D9820419A999919FA685941CDCCCCCCE29A20419A9999793669594100000000179B2041CDCCCC2C3969594100000000689E2041000000801869594100000000999E20410000006013695941333333334EA020419A99995903695941CDCCCCCCD2A020419A999919FD685941000000000CA120419A999959F96859416666666676A120419A999999F4685941CDCCCCCC2EAB2041333333B3EC68594100000000E5AC204166666626F16859419A99999912AD2041CDCCCCACD3685941CDCCCCCC93AD20419A9999997C68594100000000ABAE2041333333337B685941CDCCCCCCDCAE2041000000807A6859419A99999983B02041333333136B685941666666665BB22041CDCCCC2C5A685941CDCCCCCC9AB22041333333935668594100000000B9B320413333333340685941CDCCCCCC11B520419A9999B92568594166666666E0B52041000000601668594100000000F7B52041000000E012685941CDCCCCCC00B62041666666E6066859416666666656B6204100000060DF6759419A9999995EB6204166666626D36759416666666682B620419A999979C467594100000000B0B62041666666E6BB67594133333333ABB62041CDCCCC6CAC675941CDCCCCCCBDB6204166666686AA675941CDCCCCCCFEB620410000006087675941CDCCCCCC37B720413333335370675941CDCCCCCC79B72041333333535B67594100000000D7B720419A999999416759413333333316B82041666666662A6759416666666658B820416666660614675941CDCCCCCCDDB82041333333D3F76659419A9999992BB92041CDCCCC8CE36659416666666608BA2041CDCCCC2CA3665941CDCCCCCC80BA204100000040946659419A999999ABBB2041000000C0756659416666666684BC20419A9999995C665941CDCCCCCCD0BD20419A9999D94D6659410000000099BE20419A99999945665941666666668ABF20419A9999394F66594100000000DBBF204133333333546659410000000078C02041000000E043665941CDCCCCCC9FC02041333333533E665941666666666CC12041000000C02966594133333333BCC12041CDCCCC0C21665941333333331FC22041000000E017665941333333332AC22041666666660E6659410000000058C320419A9999B9F06559410000000006C42041CDCCCC2CE365594133333333A4C42041CDCCCC8CD765594100000000DCC42041CDCCCCACD16559413333333377C5204100000000BB655941CDCCCCCCC5C5204166666646AE65594100000000E9C5204166666606A66559410000000013C62041333333B3966559416666666663C620419A9999D9606559419A99999977C62041333333D350655941333333332BC62041000000E04A6559413333333333C52041666666C6406559413333333303C520419A9999793C65594133333333E1C42041000000E03365594100000000FCC32041000000E0216559419A99999907C320419A9999790965594133333333CCC220410000002004655941000000002FC2204100000020F964594100000000D1C12041CDCCCC2CF6645941CDCCCCCC5BC12041CDCCCCECF36459416666666640C0204133333333F16459413333333326C0204100000000EF64594133333333C1BF2041CDCCCC8CDB6459413333333369BF204166666606D36459419A999999E8BE2041333333D3C86459419A9999998EBE20419A999979C46459419A9999990ABE204166666646C06459416666666685BD204100000040BB6459413333333391BC204166666606B66459413333333321BC20419A9999D9B16459416666666618BB2041CDCCCC0CAB645941CDCCCCCCA2BA204100000000996459419A999999D2B92041000000807A6459413333333309B92041000000E05664594100000000E1B8204100000020556459419A99999947B8204100000060476459410000000033B92041CDCCCCEC25645941000000006FB820419A999979E5635941666666668DB82041000000A0E363594166666666A1B82041CDCCCCCCDC635941CDCCCCCC9EB82041333333F3CC63594166666666BFB82041CDCCCC0CAF63594166666666BEB820419A9999D9A4635941CDCCCCCC75B820419A9999597B6359416666666659B820413333337361635941000000003FB820419A9999995963594133333333A9B82041333333B33B635941CDCCCCCCC1B820419A999999326359419A999999AEB62041CDCCCCCCE56259416666666690B6204100000040E0625941666666662AB62041CDCCCC8CBE625941000000000EB6204133333313B762594133333333BAB520419A9999F9A56259410000000092B52041CDCCCC8CA06259419A9999995DB52041666666069F6259419A999999E9B42041333333939E62594100000000B9B42041CDCCCC8C9B6259419A99999979B42041333333339E625941CDCCCCCC9FB32041CDCCCC6C92625941CDCCCCCCD7B12041333333B3A262594166666666F7AF204100000080B46259419A99999929AF2041000000A0BB625941CDCCCCCC9FAE2041CDCCCC2CC16259419A999999B6AD20419A999999CF6259419A99999918AC204133333373EA625941333333333DAB204133333333F96259416666666657A92041333333F32063594100000000DEA82041333333532B6359413333333374A82041CDCCCC4C1D6359413333333356A82041333333531D635941CDCCCCCCFCA72041CDCCCCEC24635941CDCCCCCCCAA720419A9999F92463594133333333FDA520419A99993906635941CDCCCCCC72A52041333333D3F7625941CDCCCCCCC8A42041CDCCCC8C0F63594133333333D0A320416666662628635941CDCCCCCCDDA22041CDCCCCCC05635941333333335AA220419A9999D9FB625941333333337DA22041CDCCCCECF4625941CDCCCCCCA9A22041CDCCCC2CEF6259410000000061A22041000000A0E6625941000000000FA2204133333353D46259419A999999DEA020419A9999D9EF625941CDCCCCCCB6A0204166666626F1625941000000007AA020419A999979E362594100000000CD9F2041CDCCCC6CB5625941CDCCCCCC859F204166666606A4625941CDCCCCCCF79E2041333333B38362594133333333D99E20419A999979786259419A999999A69E2041CDCCCCCC6F6259419A999999739E20419A9999995F62594100000000419E2041CDCCCC0C5A62594133333333F79D20419A9999D96A62594133333333E59D2041000000606D625941CDCCCCCC839D20416666668674625941333333339A9D2041CDCCCC0C84625941000000005F9D20419A9999D99162594133333333BA9C204100000000A862594133333333619C204166666646AE6259419A999999D89B204100000000B3625941CDCCCCCCBC9B204100000080B5625941666666665F9A2041000000E0AC625941333333330F9A20419A9999B9A662594166666666C8992041CDCCCC4C9A6259416666666661992041333333336C6259410000000024992041666666C65562594166666666DA98204166666686466259419A999999B1972041000000C0506259419A9999995C9620419A9999F960625941000000004D962041CDCCCCCC63625941000000004A962041000000E06A62594166666666A2952041333333B36F625941666666666D942041000000807C6259419A999999219220419A99995997625941333333339B912041CDCCCC2C9E62594100000000EE902041CDCCCC6CA26259419A999999A3902041CDCCCC4CA2625941000000003D90204133333333A5625941CDCCCCCCCB8F2041333333B3AF625941666666663C8E20419A999919B5625941000000006B8D204133333393BB62594133333333FD8C2041CDCCCCECBC62594100000000538C204100000060B962594166666666D389204166666686B76259419A9999991187204166666646AD625941333333339C832041CDCCCCECA3625941CDCCCCCC4D822041CDCCCCACA6625941CDCCCCCC2A82204133333373A26259419A99999907822041CDCCCCCCA16259410000000088802041000000009E625941CDCCCCCC837F2041333333B39C62594166666666E07E2041666666869C6259419A9999999A7D20419A9999F99A62594166666666A87C2041CDCCCC4C9A625941666666663E7A2041333333339662594100000000C27820419A9999998C6259410000000014772041CDCCCC0C88625941000000001C772041CDCCCCEC8F62594100000000FA762041CDCCCC2CB362594100000000FA762041CDCCCC2CB3625941	01010000206A080000A0797012BFA2204166666656C6655941	370260000	Z	Betz-le-Château	3702600	37026	37	24	47
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