SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep39;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep39 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep39','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep39','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep39','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep39"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000AB93DDB755DC2A4133333313476D5941	390010000	Z	Abergement-la-Ronce	3900100	39001	39	27	7
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	01060000206A080000010000000103000000010000008A0000009A99999966892B419A999979E05C594133333333CA892B41000000A0E15C59419A999999E3892B41666666A6E45C5941CDCCCCCC008A2B4133333353F05C5941000000005E8A2B41666666A6005D59419A999999DD8A2B4100000020145D5941CDCCCCCC398B2B419A999919235D5941CDCCCCCC798B2B41000000A0295D5941CDCCCCCCB98B2B41CDCCCC4C2E5D59419A999999148C2B41CDCCCC4C385D5941CDCCCCCC048C2B4100000080465D594166666666038C2B4133333373545D5941CDCCCCCC0F8C2B419A999919605D59419A999999308C2B41333333F36A5D5941CDCCCCCC428C2B419A9999B97C5D59419A9999997C8C2B41333333B3965D5941666666669F8C2B4100000080995D5941CDCCCCCCE98C2B419A999999A65D59419A999999128D2B4133333333B45D594100000000638D2B4133333353C05D5941CDCCCCCC8E8D2B4100000060D05D5941CDCCCCCC9C8D2B4100000040E05D594100000000988D2B4133333393EC5D594166666666838D2B41CDCCCC0C055E5941CDCCCCCC7C8D2B419A9999791F5E594166666666868D2B419A999959295E594133333333768D2B41000000E0395E594133333333338D2B4166666686445E59419A999999258D2B4133333373495E5941CDCCCCCC348D2B41000000404D5E59419A999999758D2B41000000E0555E5941CDCCCCCCDA8D2B419A9999595C5E594133333333008E2B41333333F3625E594133333333198E2B41333333F34F5E5941CDCCCCCC6D8E2B41CDCCCC2C485E594100000000288E2B41CDCCCCCC355E5941CDCCCCCC108E2B41CDCCCC4C2D5E5941333333338B8E2B41000000C0245E594100000000A68E2B41CDCCCC8C1A5E594100000000EC8E2B41666666A6235E59419A999999688F2B41666666C63B5E59419A999999848F2B41CDCCCCAC435E594166666666AC8F2B4100000020445E594166666666FC8F2B41CDCCCCEC4F5E5941333333337A902B41000000E0605E594133333333C3902B419A9999195B5E594100000000EF902B41666666065D5E5941CDCCCCCC72912B4166666606505E5941CDCCCCCC0D922B41CDCCCCCC3B5E594133333333B5922B41333333534B5E594100000000F2922B419A999999435E594100000000AF932B4100000040515E59416666666628942B41CDCCCC0C595E5941000000002D952B41333333936B5E59416666666643952B419A9999D9745E59419A999999DE952B41CDCCCC4C805E5941CDCCCCCC11972B41CDCCCC6C9E5E5941CDCCCCCC1D972B419A9999B9A45E59419A99999941972B4166666626A75E5941333333335B972B4166666666A55E59419A999999C4972B419A9999F9AB5E5941CDCCCCCC24982B419A999979BB5E5941666666666B982B41000000E0BE5E59419A999999A3982B41CDCCCC4CBD5E59413333333334992B4166666666BB5E59410000000073992B41CDCCCCECB45E59419A999999AC992B419A9999D9B45E59419A999999259A2B41CDCCCC6CB85E5941CDCCCCCCB09A2B41333333F3C05E59419A999999139B2B4166666626A15E59419A999999329B2B4100000000955E59419A9999993B9B2B419A999959895E594100000000139C2B4166666666895E5941333333330B9C2B41333333337A5E59419A999999D89C2B419A9999F9695E594166666666F19E2B41CDCCCC2C405E59410000000017A02B41000000C0255E594166666666B49F2B4133333333195E5941000000001F9F2B4100000040FD5D594166666666A19E2B41CDCCCC2CEC5D5941000000001A9F2B41CDCCCC8CE85D59419A999999549F2B4166666606F25D594166666666CD9F2B419A9999F9F05D594166666666D09F2B4100000040DD5D5941333333339D9F2B4133333393CA5D59419A999999A69F2B4133333353C45D59410000000000A02B419A999979BB5D594133333333E1A02B41666666A6B35D594100000000CAA02B41CDCCCC8CAC5D5941333333335A9F2B419A9999D9715D5941666666661C9F2B41CDCCCC6C6A5D594100000000E29E2B41333333335F5D594166666666409E2B41CDCCCC8C465D594166666666A89D2B41333333F32C5D59419A999999519D2B41CDCCCC4C245D5941CDCCCCCC189D2B41666666262F5D594100000000EF9B2B41333333F3125D59419A999999F49A2B4166666606F55C594166666666829A2B419A9999F9FA5C594133333333919A2B41CDCCCC8CEE5C59419A999999829A2B41000000C0DD5C594100000000869A2B41CDCCCCACD55C59419A9999998A992B41666666E6B25C59419A99999905992B4133333353B75C59419A999999C0972B41CDCCCC4CB65C59410000000000972B41666666A6AB5C59416666666638962B41000000A0935C59416666666656952B4100000020795C5941333333332C952B41333333F37A5C59410000000081942B419A999939A05C5941666666666A942B41333333F3B65C5941CDCCCCCCE9932B4133333333B65C5941CDCCCCCC8F932B4166666686B65C594133333333C2922B4166666666B45C59413333333381922B41666666C6B55C59410000000053922B41CDCCCC0CB55C594166666666D2912B41CDCCCCECA95C5941000000009A912B419A999959A95C59410000000027912B41333333F3AA5C5941CDCCCCCCBA902B41CDCCCC0CA65C59410000000085902B41666666A6A25C59419A99999940902B419A999979975C59413333333310902B4166666686935C59419A999999B68F2B41000000A0945C5941666666663C8F2B419A9999198F5C594166666666AF8E2B41666666C6895C594133333333608E2B41CDCCCC4C8C5C594100000000488D2B41000000609C5C594133333333248D2B41000000809F5C594166666666938C2B419A999939AF5C594100000000178C2B41333333D3B95C594166666666858B2B41CDCCCC0CC75C594133333333238B2B41333333D3C85C5941CDCCCCCC678A2B419A9999F9C15C59419A9999991D8A2B41000000E0C45C594166666666B9892B4133333353D05C59419A99999966892B419A999979E05C59419A99999966892B419A999979E05C5941	01010000206A080000EF953FE18C962B41000000509C5D5941	390020000	Z	Abergement-le-Grand	3900200	39002	39	27	4
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	01010000206A080000AED44A6D7C9F2B41CDCCCCFCCE5C5941	390030000	Z	Abergement-le-Petit	3900300	39003	39	27	2
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	01010000206A0800001F542FB77B352C4100000050F45D5941	390040000	Z	Abergement-lès-Thésy	3900400	39004	39	27	5
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	01010000206A08000062F1557AA6E12B41000000E04A625941	390060000	Z	Aiglepierre	3900600	39006	39	27	7
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	01060000206A080000010000000103000000010000007E0000003333333327572B41CDCCCC6C263959413333333320582B41333333D3AB3959410000000018582B41CDCCCCCCC4395941CDCCCCCC36582B4100000080D2395941CDCCCCCCDA582B41CDCCCC8CF239594133333333E05A2B4100000080EE3959419A999999E15B2B41CDCCCCAC123A594100000000235C2B41CDCCCC0C1A3A594133333333895C2B419A999979203A594100000000685D2B419A999999273A5941000000003A5E2B41666666A6313A5941000000007C5E2B41CDCCCC0C313A59419A999999F45E2B4100000060273A5941666666668B5F2B4166666626473A594166666666B35F2B419A999999493A594166666666DB5F2B41CDCCCC8C493A59419A999999F85F2B41CDCCCC4C3E3A59416666666652602B41333333F33C3A594100000000B0602B41CDCCCC6C463A594100000000DF602B41666666C6463A59416666666607612B41000000C04B3A59419A9999991C612B41333333335D3A59419A99999913612B41333333F36A3A594166666666CC602B41333333F3713A5941333333331F612B4100000060753A5941000000000F612B419A999939983A5941666666660D612B41CDCCCC8CA53A5941333333331E612B41000000E0AD3A5941CDCCCCCC7B612B41CDCCCC4CA93A594100000000C6612B419A9999B9A23A594133333333E8612B41CDCCCCCCAD3A59410000000025622B41CDCCCC2CBE3A5941CDCCCCCC8A622B41000000E0D73A5941CDCCCCCCE2622B4133333373EB3A594100000000FE622B4100000040F03A5941666666665D632B41333333F3F93A5941666666668C632B4100000000003B59413333333306642B4133333353123B59416666666631642B419A9999591A3B59419A99999950642B41666666C6233B5941CDCCCCCC45642B41666666C6333B5941CDCCCCCC4D642B41000000E0423B59413333333367642B419A9999F9533B59410000000090642B4100000020613B59419A999999AC642B4166666646763B59410000000017652B4100000020753B59419A999999F1652B41CDCCCC0C663B59416666666606662B41666666C6603B5941CDCCCCCC4F662B419A999979393B5941CDCCCCCCA6662B4100000020383B594100000000AB662B419A9999193D3B594100000000E9662B41CDCCCC2C403B59419A9999993E672B41CDCCCC2C413B594133333333CA672B41000000203F3B594166666666B7672B419A999959183B594133333333E0672B419A9999D9163B594166666666C2672B41000000A0053B5941333333339B672B41CDCCCC6CF23A594166666666ED662B41666666E6F13A5941CDCCCCCCBC662B419A9999D9F03A59413333333395662B4133333373EC3A5941CDCCCCCCD3662B419A999939D73A594133333333EC662B41000000A0D23A59413333333330672B41666666E6D03A59416666666637672B41333333F3B63A59413333333315672B41000000C0AE3A594100000000E3662B419A999919A73A5941CDCCCCCC85662B41666666C69C3A59419A99999914662B41CDCCCC2C923A59419A99999903672B41000000A0773A59416666666643672B419A9999597B3A5941CDCCCCCC99672B41000000A07D3A59419A999999A7682B419A999919833A594133333333D3692B4166666686813A59419A999999AE6A2B41CDCCCC0C7B3A5941CDCCCCCC0F6B2B4166666666763A5941000000002D6B2B41CDCCCC4C763A59419A999999146C2B419A9999B96F3A5941CDCCCCCC7A6C2B41333333D36B3A5941CDCCCCCCC86C2B41666666266A3A594100000000C96C2B419A9999796B3A594166666666206D2B419A999959673A594100000000836D2B41000000A0693A594166666666826D2B4166666666603A5941333333337C6E2B41333333D3533A59419A999999B9702B4133333313413A59416666666695722B419A9999193B3A594133333333FA732B419A999999113A59416666666657752B41CDCCCCACAE39594166666666C5762B41666666E6823959419A99999973752B419A99997981395941CDCCCCCC95752B419A9999391E395941CDCCCCCC8C712B41666666A6AA38594133333333CB6D2B41666666A69D38594166666666566D2B41333333B39A38594133333333436D2B41CDCCCCACB638594100000000606D2B419A999999C638594133333333446D2B41CDCCCC8CD0385941333333337A6C2B41000000A0D03859419A999999416C2B4133333313D2385941CDCCCCCC146C2B41CDCCCCCCD73859419A999999B36B2B4100000080DC385941CDCCCCCC776B2B419A999999DC38594166666666496B2B4100000080E43859419A999999E16A2B41CDCCCC4CEC3859419A999999AD692B4166666626EE385941CDCCCCCC14682B41333333D3F93859410000000039672B41CDCCCC8CFC38594133333333D5662B4166666626FD385941333333332C642B4166666626E838594100000000BE632B4166666646E3385941333333331E632B4133333333E238594166666666EC622B41000000C0E43859419A999999FF5F2B41CDCCCC8CEF3859419A999999665E2B419A9999B9F8385941666666669F5D2B41333333B30139594166666666B05C2B41CDCCCCEC0B395941CDCCCCCC885B2B419A9999790F395941CDCCCCCC4E5A2B41333333F31B395941000000003E5A2B41CDCCCC0C0F39594133333333DD592B41000000601139594166666666A2592B419A999979113959419A9999999C592B41CDCCCC6C1B3959413333333310592B41CDCCCC2C1D3959413333333327572B41CDCCCC6C263959413333333327572B41CDCCCC6C26395941	01010000206A08000018ECEA34DB672B4134333303093A5941	390070000	Z	Alièze	3900700	39007	39	27	6
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	01010000206A080000E028BBBFE44A2B41CDCCCC1CF0785941	390080000	Z	Amange	3900800	39008	39	27	7
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	01010000206A0800004831E065ED2B2C419A9999096A585941	390090000	Z	Andelot-en-Montagne	3900900	39009	39	27	13
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	01010000206A08000024B5F475F20C2B4133333393C9275941	390100000	Z	Andelot-Morval	3901000	39010	39	27	10
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	01010000206A0800008E453D31C2A72A419A99996974615941	390110000	Z	Annoire	3901100	39011	39	27	16
01060000206A0800000100000001030000000100000081050000CDCCCCCC1BDE2B419A999959565559419A999999EBD42B41CDCCCCAC3E565941CDCCCCCCE4CC2B41000000C0035759413333333386CC2B41CDCCCC2C095759419A9999998BCA2B419A99997939575941CDCCCCCC7FCA2B419A9999B93A5759419A9999996ACA2B41000000403D5759419A9999994ECA2B4166666626405759413333333327CA2B419A9999794457594100000000FFC92B41666666E647575941CDCCCCCCCEC92B41CDCCCCEC4B57594166666666A7C92B41000000604F575941666666667BC92B419A999999535759419A9999995BC92B4100000060565759419A9999994AC52B4100000040B55759419A9999993CC52B4166666686B65759419A99999977C92B419A999939605859413333333391C92B41666666066458594166666666BFC92B41CDCCCC6C6B58594100000000CBC92B41000000A06D58594100000000E8C92B41333333D371585941666666660ACA2B4133333353775859419A999999B5CA2B41CDCCCC0C9558594133333333EACB2B419A9999D9C7585941000000002ECD2B419A9999D9F85859416666666698CB2B41CDCCCCEC6B595941CDCCCCCCC5CA2B413333339399595941333333338ECA2B4100000040A2595941333333338DCA2B41666666A6A3595941000000008BCA2B41CDCCCC4CA55959410000000086CA2B4100000080A75959419A9999997DCA2B41000000E0A95959416666666675CA2B4133333353AC5959419A9999996ACA2B419A999959AF595941CDCCCCCC57CA2B4100000060B45959410000000057CA2B41000000A0B45959416666666635CA2B41CDCCCC8CBE5959419A99999922CA2B419A9999B9C2595941CDCCCCCC31CA2B4100000020D45959419A99999937CA2B41666666E6DE5959413333333348CA2B41000000E0E75959410000000069CA2B41000000E0F1595941CDCCCCCC0BCA2B4133333373F659594100000000ECC92B4166666606F8595941CDCCCCCCBDC92B4133333313FA595941333333338AC92B419A999979FC595941CDCCCCCC7BC92B4100000000FD5959416666666671C92B4100000040025A5941CDCCCCCC64C92B4100000060065A5941CDCCCCCC5CC92B41CDCCCC0C0A5A59410000000058C92B41333333D30E5A59410000000055C92B419A999939125A59416666666653C92B41000000E0145A59410000000052C92B419A999939175A59416666666650C92B419A999959225A5941333333335BC92B4100000060285A59413333333382C92B41000000603E5A59416666666686C92B41666666C6405A59416666666687C92B41CDCCCC2C415A59413333333395C92B41CDCCCC2C475A594133333333A3C92B41666666264D5A594100000000B1C92B4166666626535A594100000000BFC92B4166666626595A5941CDCCCCCCDAC92B4166666626655A5941CDCCCCCCFFC92B419A999999725A59419A99999906CA2B41333333D37E5A59419A999999F5C92B41333333538D5A5941CDCCCCCCEDC92B419A999959925A5941CDCCCCCCEFC92B41333333B3995A594133333333E8C92B41666666C69F5A59419A999999E1C92B419A999939AA5A59419A999999DEC92B4100000080AE5A594166666666DEC92B41CDCCCC6CB15A594100000000E0C92B4100000080B35A5941CDCCCCCCE4C92B4133333313B65A594166666666D9C92B41000000A0B75A594133333333CEC92B41666666C6B95A59419A999999D2C92B4100000040BB5A594133333333D4C92B41CDCCCC8CBC5A59419A999999DCC92B41CDCCCCACC25A594133333333DDC92B4166666606C65A594133333333D6C92B4100000060C95A5941CDCCCCCCAAC92B419A999939CC5A594166666666ACC92B419A999999D25A5941CDCCCCCCBFC92B4100000040D95A594133333333C1C92B41333333F3EC5A594166666666B6C92B419A9999F9FA5A5941CDCCCCCCACC92B419A999979055B59419A99999977C92B4166666606025B5941CDCCCCCC1FC92B4133333313F95A594100000000ECC82B4100000060F45A594100000000C3C82B41CDCCCCCCF65A5941CDCCCCCCA9C82B4100000000F75A59413333333376C82B41CDCCCCCCF75A59413333333353C82B41000000A0FC5A59413333333320C82B4100000080015B5941CDCCCCCCD0C72B4166666686045B59413333333386C72B419A9999D90A5B5941666666665AC72B41CDCCCCCC105B59419A99999941C72B4100000040155B59419A9999992DC72B41666666661D5B59419A99999904C72B41CDCCCC6C245B594100000000C7C62B419A999959265B5941CDCCCCCC75C62B4133333353255B5941000000003BC62B41666666C6255B59419A99999907C62B4133333393285B5941CDCCCCCCD8C52B41666666662B5B59419A999999A3C52B4100000080285B59416666666684C52B419A999939255B5941000000004FC52B41333333F3215B5941000000001DC52B41000000C0225B594133333333DFC42B4100000060235B5941CDCCCCCC74C42B419A9999391F5B59413333333344C42B41000000201F5B594166666666F9C32B41333333F3185B59419A999999CFC32B41333333F30F5B59416666666611C42B41000000A0095B5941CDCCCCCCAAC32B41CDCCCC2CFB5A59410000000058C32B41000000E0E95A59416666666631C32B41CDCCCC2CEC5A59410000000017C32B4100000060E85A5941CDCCCCCC00C32B41666666A6EA5A594166666666E4C22B419A9999D9E65A59416666666656C22B4100000000F25A5941666666661BC22B419A999959E75A5941CDCCCCCC9DC12B4133333333ED5A5941CDCCCCCC77C12B41333333D3F15A5941666666665AC12B419A9999B9EC5A5941000000002CC12B41CDCCCC0CEF5A594100000000A7C02B4100000060F65A59410000000076C02B4100000080F95A59413333333342C02B419A9999F9FC5A5941CDCCCCCC01C02B41000000C0F95A594166666666BABF2B41CDCCCC2CFF5A59419A9999995CBF2B4133333333045B59416666666630BF2B4100000080FA5A59419A9999991CBF2B4133333353F65A59419A99999910BF2B4100000060F35A59413333333305BF2B4133333353F25A59419A999999FCBE2B419A999959F15A594166666666F4BE2B41CDCCCCACF05A5941CDCCCCCCEABE2B41000000A0F05A59419A999999DFBE2B4133333333F15A594100000000CEBE2B41666666A6F25A59413333333398BE2B4100000040F75A5941CDCCCCCC4FBE2B4166666686FD5A59413333333316BE2B4166666686025B594166666666EBBD2B4133333333065B594133333333C9BD2B4166666626095B5941666666669FBD2B41666666C60C5B59419A9999998FBD2B41333333F30D5B5941333333337DBD2B41000000600F5B59416666666644BD2B41333333D3135B5941333333331CBD2B4166666646175B59419A99999911BD2B4100000020195B59416666666612BD2B419A9999991A5B5941CDCCCCCCBDBC2B4133333393105B59419A9999999FBC2B41666666A60B5B5941CDCCCCCC85BC2B41333333D3065B59413333333354BC2B4166666646FF5A5941CDCCCCCC2EBC2B41CDCCCC4CFF5A5941000000000ABC2B4166666606005B59419A999999ABBB2B41000000C0FF5A59413333333373BB2B4166666606FB5A59419A9999995DBB2B4100000060F95A59410000000055BB2B419A999919F95A5941CDCCCCCC07BB2B4133333373FA5A59419A999999E0BA2B4100000060FB5A594100000000D7BA2B419A9999F9FB5A5941CDCCCCCCB0BA2B41666666C6FD5A59419A99999981BA2B41000000C0FF5A5941CDCCCCCC69BA2B419A999999005B5941CDCCCCCC41BA2B4100000060025B59419A999999F5B92B41000000C0055B59419A999999BCB92B41CDCCCCAC075B5941000000008CB92B41CDCCCC0C0A5B59413333333380B92B419A9999790A5B59416666666675B92B419A9999790B5B59413333333365B92B41CDCCCCAC0C5B5941000000003AB92B41CDCCCC8C0F5B59419A99999921B92B419A999959115B5941CDCCCCCC07B92B41333333F3135B594133333333DBB82B41CDCCCC8C185B594100000000C5B82B41666666C61A5B594133333333A4B82B419A9999591E5B59413333333367B82B41CDCCCC4C245B59419A9999994DB82B4100000020265B59413333333321B82B4133333373295B59413333333303B82B41666666662B5B594133333333C9B72B41666666662F5B594133333333A7B72B4100000000325B59416666666671B72B4166666686355B5941CDCCCCCC23B72B419A9999D93A5B59419A99999911B72B41333333333C5B5941CDCCCCCC63B62B41CDCCCC4C475B59419A9999991AB62B41000000A04A5B59419A99999905B62B419A9999994D5B594133333333D9B52B419A999979515B594100000000DBB52B41000000E04E5B594166666666D8B52B4166666686465B59419A999999EBB52B41CDCCCC2C405B594100000000E4B52B41333333F3375B59419A999999D5B52B4100000020315B594166666666B7B52B41CDCCCCAC275B5941333333339CB52B41CDCCCC2C205B59410000000092B52B419A9999391A5B59416666666687B52B41333333D3115B59410000000079B52B41666666260B5B5941000000007AB52B4133333353055B59416666666698B52B419A999999FD5A594166666666AEB52B4133333313F75A594166666666B6B52B41CDCCCC2CF25A5941CDCCCCCCCDB52B4100000020E85A594133333333D1B52B41CDCCCC4CDE5A594100000000DDB52B419A9999D9D15A5941CDCCCCCCF7B52B4166666686CA5A59419A999999F6B52B41CDCCCCCCB75A59419A999999FDB52B419A999999B05A594166666666CEB52B419A9999F9A25A594166666666C2B52B41333333B3965A594100000000D8B52B41CDCCCCAC885A5941CDCCCCCC05B52B41CDCCCC0C885A594100000000A0B42B419A999999875A59410000000089B42B41333333538C5A5941333333333CB42B41CDCCCC8C915A5941CDCCCCCCA0B32B41000000A0955A59416666666677B32B419A999919915A594133333333FCB22B4133333333805A594166666666BDB22B41000000C0755A59419A9999997FB02B4166666686AC5A5941CDCCCCCC82B02B419A9999B9B25A59419A99999985B02B419A9999F9C05A5941CDCCCCCC1CB02B4166666626C75A5941CDCCCCCC4BAF2B41000000E0D35A5941CDCCCCCCE1AE2B419A9999B9DA5A5941CDCCCCCC3BAE2B4166666606E55A59419A99999903AD2B41333333B3E85A59419A999999CDAC2B41000000C0EA5A5941CDCCCCCC84AC2B4166666666EC5A5941000000001CAC2B41CDCCCC8CEE5A594166666666D2AB2B4100000020FA5A5941CDCCCCCCBAAB2B41CDCCCC2CFE5A59416666666676AB2B4166666606045B5941CDCCCCCC5EAB2B4166666626065B5941CDCCCCCC2CAB2B41000000C00D5B594133333333F5AA2B4133333333155B594166666666E7AA2B4133333393185B594166666666CAAA2B41333333731C5B5941CDCCCCCCAFAA2B419A999939215B594100000000A9AA2B4100000060245B5941CDCCCCCCA3AA2B41333333D3295B594100000000A0AA2B41666666462F5B59416666666673AA2B4166666646355B59419A99999961AA2B41CDCCCCCC385B59416666666652AA2B419A9999B93D5B59410000000036AA2B419A9999194B5B5941CDCCCCCC0BAA2B41333333135E5B59419A999999EAA92B419A999959665B594100000000ABA92B41666666C6705B59419A9999998DA92B4100000000755B59419A9999997EA92B41000000A07A5B59416666666634A92B41CDCCCC0C8F5B59419A99999906A92B4166666606985B5941CDCCCCCCDFA82B41333333D39C5B594166666666B4A82B419A9999F99E5B59419A9999996FA82B419A999919A05B5941666666664EA82B41666666A6A35B59416666666621A82B4166666666A45B59410000000007A82B41CDCCCC2CA65B594133333333F3A72B4100000080A55B59419A999999E9A72B419A9999B9A55B594100000000E7A72B41333333B3AC5B5941CDCCCCCCE6A72B4100000020B75B5941CDCCCCCCECA72B4133333393C05B594100000000F6A72B41CDCCCCACC95B59416666666602A82B41000000E0D15B59419A99999914A82B419A9999F9DB5B5941333333332AA82B4166666686E45B5941666666663DA82B419A999959EC5B5941CDCCCCCC55A82B41333333B3F35B594166666666F1A82B41CDCCCC6CF35B5941CDCCCCCCEAA92B4166666666F35B59419A999999D6AA2B41CDCCCCCCF85B59416666666645AB2B419A999919055C594166666666ACAC2B41CDCCCCEC385C594166666666F4AC2B41CDCCCC4C5A5C594166666666F9AC2B41CDCCCC4C5A5C5941000000000EAD2B419A9999995A5C5941333333331EAD2B41CDCCCC2C5B5C59410000000034AD2B41333333735C5C59413333333341AD2B41CDCCCCAC5D5C5941000000004FAD2B41CDCCCC6C5F5C59419A99999964AD2B419A9999B9625C59413333333375AD2B4100000060655C5941CDCCCCCC85AD2B41CDCCCC6C675C5941CDCCCCCC9BAD2B4100000060695C594100000000D7AD2B41000000006D5C594100000000F1AD2B41000000E06E5C5941333333330CAE2B4166666666715C59413333333320AE2B4133333393735C5941333333333BAE2B41CDCCCCEC765C59416666666656AE2B41333333B37A5C59410000000071AE2B41666666A67E5C59410000000087AE2B41CDCCCCAC815C594100000000A5AE2B41CDCCCC4C855C5941CDCCCCCCC0AE2B4133333353885C594100000000C8AE2B419A999959895C594166666666D9AE2B41000000608C5C594133333333F3AE2B419A999939915C5941666666660DAF2B4166666666965C59413333333324AF2B41333333B39A5C59413333333347AF2B4133333373A15C5941000000006CAF2B4166666646A85C59416666666684AF2B41CDCCCC8CAC5C59419A999999A7AF2B4100000020B25C5941000000004AAF2B4166666646B75C59416666666604AF2B419A999919B95C59416666666641AE2B41666666C6B85C5941CDCCCCCC1AAE2B41CDCCCC8CBA5C594166666666C2AD2B419A999979C45C59410000000030AD2B4100000000DF5C59419A999999D3AC2B4100000060F15C5941333333338BAC2B4133333333F85C59410000000066AA2B41666666A6075D5941CDCCCCCCA4A92B419A9999F9155D59416666666672A92B41CDCCCC0C1C5D5941CDCCCCCC51A92B41000000C0215D5941000000002EA92B41333333D3275D59419A9999991AA92B41666666662B5D5941333333335BA92B41666666A6335D59410000000091A92B41666666A63E5D594133333333B2A92B41CDCCCCAC475D594100000000EBA92B41CDCCCC2C545D5941CDCCCCCC24AA2B419A999959635D59410000000034AA2B4133333373685D59419A99999921AA2B4133333393695D59419A9999990FAA2B419A9999796E5D5941CDCCCCCC10AA2B41CDCCCCAC765D59419A99999911AA2B41666666C67A5D5941CDCCCCCC15AA2B41333333D37D5D59419A9999991FAA2B41333333937F5D59410000000027AA2B4100000060825D5941333333332AAA2B41000000208A5D5941CDCCCCCC24AA2B41666666268F5D59413333333316AA2B41666666A6995D5941CDCCCCCCF7A92B41CDCCCC4CA35D59419A999999CBA92B4166666646AE5D59419A999999C1A92B41CDCCCC6CB35D594166666666BBA92B4100000040BC5D594100000000BAA92B4133333393C15D594100000000C1A92B41000000A0C65D594100000000CBA92B4166666626CF5D59419A999999C7A92B41333333D3D15D594166666666BEA92B41CDCCCCACD35D594133333333B7A92B41CDCCCCECD55D594100000000B6A92B41000000A0D75D5941CDCCCCCCC1A92B41000000A0D95D594100000000DEA92B4133333313DC5D594133333333EFA92B4133333393DE5D594133333333F3A92B41666666C6E05D594100000000F3A92B41000000A0E25D59419A999999F0A92B4100000060E45D59419A999999E5A92B419A999979E55D5941CDCCCCCCD3A92B4133333393E55D594133333333B8A92B419A999959E45D594100000000A1A92B41666666C6E35D5941666666668BA92B41333333B3E35D59410000000081A92B4166666606E45D5941CDCCCCCC76A92B4100000000E55D59410000000094A92B4166666606E95D594166666666ABA92B41333333D3EB5D5941CDCCCCCCCAA92B419A999999ED5D594100000000F1A92B41CDCCCC6CF25D594133333333EFA92B41CDCCCCACF65D594100000000F4A92B419A999979FB5D5941CDCCCCCC17AA2B4100000060015E59413333333323AA2B4100000060045E5941333333333EAA2B41666666A6095E59413333333367AA2B41CDCCCCAC125E59416666666682AA2B41333333F3185E594133333333A5AA2B41CDCCCC6C235E59419A99999925AB2B41666666A63F5E59410000000047AB2B4166666606445E5941333333334FAB2B4100000000485E59413333333357AB2B419A9999D9525E59410000000064AB2B41666666E6615E59419A999999D0AB2B41000000805F5E5941CDCCCCCC1EAC2B41333333F35D5E5941CDCCCCCC69AC2B41CDCCCC4C5C5E5941CDCCCCCCB9AC2B419A9999B95A5E5941CDCCCCCC25AD2B4133333373585E59419A99999985AD2B419A999979565E5941CDCCCCCC95AD2B4100000080675E59419A999999AAAD2B4166666606795E59419A999999D8AD2B419A999979935E59419A999999EBAD2B41666666A69C5E5941CDCCCCCC0CAE2B41666666269C5E59410000000035AE2B419A9999D99A5E59413333333362AE2B4100000040995E5941CDCCCCCC84AE2B41CDCCCCEC975E5941CDCCCCCC9DAE2B4166666646975E594133333333CAAE2B41000000C0965E594133333333E9AE2B41CDCCCC4C975E59416666666604AF2B419A9999D9985E59413333333326AF2B41CDCCCCCC9A5E59410000000028AF2B41666666E69A5E59410000000041AF2B419A9999D99A5E5941666666665EAF2B41000000C09A5E59416666666676AF2B419A9999999A5E59419A99999986AF2B41666666A6995E59410000000090AF2B41333333D3985E59419A99999995AF2B41000000A0975E5941666666669BAF2B4133333353955E5941000000009DAF2B41CDCCCC6C925E59419A9999999CAF2B419A999919905E594133333333A1AF2B419A9999198D5E594133333333AEAF2B41333333D38A5E594166666666D0AF2B41CDCCCC6C895E59419A999999ECAF2B4166666626895E5941CDCCCCCC08B02B41CDCCCC0C8A5E59413333333321B02B41000000208C5E59419A9999992CB02B41000000408E5E59419A99999932B02B4100000000925E59416666666634B02B41333333D3945E5941CDCCCCCC35B02B419A999939985E59419A99999939B02B41666666469A5E59419A99999945B02B41000000C09C5E59416666666660B02B41000000009E5E5941666666668BB02B41CDCCCCCC9E5E594166666666C1B02B41333333939D5E5941CDCCCCCC13B12B41000000209B5E5941CDCCCCCC53B12B41CDCCCCCC975E59419A99999965B12B41000000E0965E59413333333372B12B41CDCCCCAC965E5941666666667CB12B41000000E0965E5941000000008BB12B41000000E0975E594166666666BBB12B41333333F39C5E5941CDCCCCCCEDB12B419A999999A25E59413333333313B22B4133333393A75E59410000000020B22B4100000060A95E5941CDCCCCCC3CB22B419A9999B9AA5E59410000000059B22B419A999919AF5E59410000000075B22B4166666626B45E5941666666668BB22B41000000E0B85E59413333333397B22B419A9999D9BF5E59419A999999A4B22B4133333393C35E594100000000BBB22B41CDCCCC4CC65E59410000000053B22B41666666A6CC5E5941000000007BB22B419A9999D9D05E594100000000A7B22B4100000060D55E5941CDCCCCCCDBB22B419A9999B9DA5E59410000000006B32B4133333393DE5E5941000000001EB32B4133333313E05E59416666666639B32B41000000C0E05E59419A99999941B32B419A9999B9CB5E59419A99999951B32B41CDCCCCACCA5E5941666666666CB32B419A999979C85E59413333333391B32B41CDCCCC2CC45E59419A999999AEB32B4133333353C15E5941CDCCCCCCE9B32B419A9999F9BC5E5941CDCCCCCC06B42B41CDCCCC8CBB5E59419A99999926B42B41CDCCCC8CBA5E59419A99999938B42B4166666666BA5E5941CDCCCCCC6EB42B41CDCCCC4CBB5E5941000000009FB42B4166666626BC5E594133333333B2B42B41333333F3BD5E594166666666B8B42B41CDCCCC8CBF5E594133333333C9B42B419A999919C65E594133333333D1B42B41333333F3C85E594100000000E0B42B4133333393CA5E594166666666F8B42B419A9999D9CA5E5941CDCCCCCC1DB52B4166666686C95E5941CDCCCCCC40B52B41CDCCCC4CC75E59413333333352B52B41CDCCCC0CC55E59419A9999996AB52B41CDCCCC6CC05E5941333333337CB52B41CDCCCC2CBC5E59410000000081B52B41CDCCCCECB85E59410000000084B52B41666666E6B35E5941666666668CB52B4133333333B15E5941CDCCCCCC9DB52B4166666686AE5E5941CDCCCCCCB8B52B4133333393AB5E594133333333D7B52B4166666646AA5E59416666666607B62B41CDCCCC2CAA5E5941CDCCCCCC17B62B41000000A0AA5E5941333333332BB62B4166666626AB5E5941CDCCCCCC5CB62B419A999999AF5E59413333333369B62B4133333393B55E59410000000078B62B41CDCCCC0CB85E59419A9999997DB62B4166666686BB5E5941CDCCCCCC95B62B41333333D3BF5E594133333333AEB62B41CDCCCCCCC55E594133333333BAB62B419A999999C95E5941CDCCCCCCDFB62B41000000E0CB5E594100000000FAB62B41666666A6CC5E59419A99999970B62B419A999999CF5E594166666666E4B62B41CDCCCC4CDB5E5941CDCCCCCCDEB62B41666666A6DC5E594133333333DDB62B4100000040DE5E5941CDCCCCCCDFB62B41333333D3DF5E59419A999999EAB62B419A9999B9E15E59416666666603B72B4133333313E45E5941333333331BB72B4166666606E55E59413333333346B72B41CDCCCC6CE55E59416666666665B72B419A999939E55E5941CDCCCCCC88B72B41CDCCCCCCE45E59419A999999B8B72B41CDCCCCACE45E59419A999999E6B72B41000000C0E45E5941666666663AB82B41000000C0E35E59419A99999955B82B4166666646E35E5941CDCCCCCC70B82B4100000020E35E5941333333338CB82B41CDCCCC6CE35E594100000000B2B82B419A999979E45E594166666666D8B82B4100000060E65E59416666666607B92B41CDCCCC4CE85E5941CDCCCCCC29B92B419A999979E95E5941CDCCCCCC6DB92B4100000040EB5E59416666666693B92B4100000060EB5E594166666666BDB92B419A999919EB5E594133333333EAB92B4133333393E95E594100000000F2B92B4100000000E95E5941CDCCCCCC14BA2B41000000C0DD5E5941CDCCCCCC03BA2B41333333D3D35E59416666666608BA2B419A999919CE5E59410000000020BA2B419A999959C35E5941CDCCCCCC26BA2B4166666646C05E59419A99999932BA2B41666666A6BD5E59413333333349BA2B41666666E6BB5E59416666666671BA2B4166666686BA5E5941CDCCCCCCB0BA2B4133333313B95E59419A999999CFBA2B41666666C6B85E594133333333E4BA2B41CDCCCCCCB85E5941CDCCCCCC24BB2B4100000000BA5E5941CDCCCCCC57BB2B41CDCCCC2CBB5E594166666666CCBB2B419A999979BD5E59413333333322BC2B4133333353C05E59413333333303BD2B4133333373CC5E59419A99999904BD2B419A999979CC5E5941333333330EBD2B419A9999B9CC5E5941CDCCCCCC2BBD2B4100000080CD5E59416666666647BD2B41CDCCCCECCD5E59416666666660BD2B4100000000CE5E5941666666667EBD2B4100000040CD5E59419A999999BCBD2B4166666646CA5E594166666666D8BD2B4100000040C85E594133333333FEBD2B41CDCCCC6CC55E59419A9999993EBE2B41666666E6BF5E59419A99999961BE2B4133333373BC5E59410000000086BE2B41666666E6B75E594133333333AEBE2B419A9999D9B15E594166666666CBBE2B4100000020AD5E594100000000FDBE2B4133333333A65E59419A9999993CBF2B41000000409C5E59416666666663BF2B41333333B3965E5941CDCCCCCC76BF2B419A999939955E59410000000080BF2B419A999979935E59413333333382BF2B419A999999915E5941000000007FBF2B419A9999398B5E5941000000007DBF2B4166666666825E5941CDCCCCCC8BBF2B41000000607C5E5941000000009CBF2B419A9999F9765E59419A999999AFBF2B41CDCCCC2C715E59419A999999B6BF2B41000000806E5E59419A999999C3BF2B41CDCCCC4C6C5E594166666666DDBF2B419A9999996A5E59419A9999991AC02B41000000E0685E59410000000035C02B41333333B3675E5941CDCCCCCC59C02B4166666606675E594133333333B4C02B419A9999F9655E59419A999999DFC02B4133333353655E5941CDCCCCCC06C12B419A9999F9645E59419A99999961C12B41CDCCCCCC645E594133333333B3C12B41CDCCCC6C625E59419A9999991EC22B419A9999B95F5E59419A99999950C22B41CDCCCCEC605E5941CDCCCCCC84C22B41666666A6815E5941CDCCCCCC9EC22B4133333393865E594133333333C1C22B41000000408E5E59419A999999F3C22B41CDCCCC0C9A5E59419A99999900C32B41CDCCCC0C9D5E59419A9999990FC32B4133333373A05E59419A99999927C32B41666666E6A55E5941CDCCCCCC37C32B419A999939A95E5941666666664CC32B41000000C0AD5E59419A99999965C32B419A9999B9B35E5941CDCCCCCC7EC32B4133333333BA5E59416666666687C32B4133333373BD5E59416666666683C32B41CDCCCC4CBF5E5941333333337AC32B419A9999D9C05E59410000000062C32B419A9999D9C25E5941CDCCCCCC36C32B41333333B3C55E5941666666661CC32B41666666E6C75E59419A99999910C32B419A9999F9C95E59410000000007C32B4133333353CD5E59419A99999900C32B41000000C0D05E59419A999999FAC22B41CDCCCC2CD55E594100000000F4C22B41CDCCCCACDB5E594166666666EFC22B41666666E6DD5E5941CDCCCCCCE8C22B4133333333DF5E594166666666DAC22B4166666606E15E5941CDCCCCCCCDC22B41CDCCCC2CE25E5941CDCCCCCCB2C22B4100000040E45E5941666666668FC22B41333333B3E65E59410000000070C22B41CDCCCC0CE95E59410000000060C22B419A9999B9EA5E59419A9999995AC22B419A999919EC5E5941000000005BC22B4133333373ED5E59416666666660C22B41666666E6EE5E59413333333372C22B4166666626F25E59416666666686C22B419A999979F55E59419A99999991C22B4100000080F75E59416666666693C22B419A9999D9F85E5941CDCCCCCC9AC22B4100000040F95E5941CDCCCCCC9DC22B419A9999B9F95E594166666666A7C22B41CDCCCC0CFB5E594166666666C0C22B4166666646FF5E594100000000DDC22B4166666686035F59419A999999F7C22B41000000C0075F5941CDCCCCCC12C32B419A9999B90B5F59419A9999992EC32B41000000400F5F5941666666664AC32B41000000C0125F59413333333352C32B4100000000145F59413333333352C32B419A999999155F59419A9999994CC32B419A9999B9165F59419A99999937C32B4100000080195F5941CDCCCCCC1DC32B41CDCCCC4C1D5F59410000000016C32B41333333331F5F5941CDCCCCCC12C32B4166666626215F59419A99999912C32B4133333393245F59419A99999916C32B4100000020265F59416666666625C32B4166666646285F59416666666648C32B41666666862C5F5941666666667CC32B41CDCCCC0C335F5941CDCCCCCC8CC32B4166666646355F59419A9999998CC32B4166666606365F59419A99999963C32B41333333733B5F59419A9999994BC32B41CDCCCCCC3E5F59419A99999930C32B4100000020435F59413333333326C32B4100000040455F59413333333319C32B41CDCCCC8C485F5941666666660AC32B41333333734C5F594166666666FFC22B4133333333505F59419A999999F7C22B4100000020525F59419A999999E4C22B41666666A6555F59419A999999B6C22B41000000005D5F5941CDCCCCCC84C22B41000000A0655F59416666666660C22B419A9999196C5F5941CDCCCCCC46C22B4100000000705F59416666666651C22B419A999919715F5941666666666AC22B41333333F3725F5941CDCCCCCC88C22B4166666606755F594133333333ABC22B41333333D3775F5941CDCCCCCCBFC22B419A9999D9795F594133333333D6C22B419A9999797C5F594100000000EFC22B41000000E07F5F59419A99999902C32B41000000A0825F59410000000011C32B4133333373845F59413333333327C32B41333333F3865F5941333333333FC32B41666666E6885F59419A9999995FC32B41333333F38A5F59419A99999981C32B419A9999198D5F5941CDCCCCCCBBC32B41333333F3905F594166666666E0C32B4133333353935F5941CDCCCCCCF9C32B41CDCCCC0C955F5941000000002AC42B4133333313985F59416666666635C42B41000000E0985F59419A9999994CC42B41333333939A5F59419A99999964C42B41CDCCCCCC9C5F5941333333337AC42B41000000409F5F59416666666691C42B41CDCCCC4CA25F594166666666AEC42B4133333333A75F594100000000D0C42B41CDCCCCECAC5F594133333333F0C42B41CDCCCC6CB25F59410000000015C52B4166666626B95F5941000000003CC52B41CDCCCC4CC05F59413333333364C52B41CDCCCCACC75F5941000000007FC52B4133333393CC5F59419A99999966C52B41333333D3D25F5941CDCCCCCC4FC52B41000000C0D65F59419A9999992EC52B4100000060DB5F594133333333F3C42B419A999999E25F5941CDCCCCCCB7C42B41000000C0E95F5941333333337AC42B4133333353F15F59419A99999939C42B4166666686F95F5941CDCCCCCC0AC42B41CDCCCC8CFF5F594166666666E2C32B419A99999905605941CDCCCCCCBCC32B41666666C60B60594100000000A5C32B41333333D3106059413333333385C32B41000000801C6059419A99999971C32B41CDCCCC8C256059413333333370C32B41CDCCCC0C286059419A99999973C32B41333333332A6059413333333389C32B41000000C02E60594166666666A2C32B4166666686326059419A999999AFC32B41CDCCCCAC3560594133333333B7C32B41CDCCCC0C3A60594133333333B6C32B41666666063D605941CDCCCCCCB2C32B41000000A04060594100000000A7C32B419A999939496059419A999999A0C32B41000000404F605941000000009BC32B410000006058605941CDCCCCCC94C32B41333333535D6059419A99999984C32B4100000060646059416666666669C32B41333333536D6059413333333344C32B41666666A678605941000000000EC32B419A9999F98860594166666666E5C22B419A9999B99460594166666666B9C22B4166666666A1605941000000001BC42B4100000040966059419A9999997EC42B41666666E68F605941CDCCCCCCC0C42B41666666E68960594133333333FCC52B41CDCCCCAC5B6059419A999999A2C62B419A99995942605941666666669EC72B41000000603E6059416666666621C82B41333333F3416059416666666678C82B41CDCCCC2C45605941CDCCCCCCBBC82B413333333349605941666666669FC82B41CDCCCCEC57605941CDCCCCCC7DC92B41CDCCCCCC62605941CDCCCCCCAEC92B41666666A664605941CDCCCCCCEEC92B41000000005A6059419A999999F4C92B41666666C658605941CDCCCCCCFBC92B419A999959576059416666666609CA2B41333333F353605941CDCCCCCC1ACA2B41333333F351605941333333332BCA2B416666668650605941333333333FCA2B419A9999594F6059413333333351CA2B41666666064F6059419A9999996ACA2B41666666C64E605941CDCCCCCC7FCA2B41666666864E6059413333333399CA2B41333333134E60594133333333B0CA2B41333333134D605941CDCCCCCCC3CA2B41666666C64B60594100000000D0CA2B41666666664A6059419A999999EACA2B41666666C6446059410000000002CB2B419A9999B93F605941CDCCCCCC15CB2B41000000C0386059416666666625CB2B41666666C631605941CDCCCCCC29CB2B4100000000306059416666666626CB2B41000000202D60594166666666F6CA2B419A99991929605941CDCCCCCCCFCA2B41333333532560594133333333A2CA2B419A999939216059413333333387CA2B41333333131F605941333333336CCA2B419A9999191D605941CDCCCCCC77CA2B419A9999791C605941000000007FCA2B41666666C619605941CDCCCCCC8BCA2B41666666A6156059419A9999999FCA2B419A9999391060594133333333B9CA2B41333333B30A60594166666666CACA2B41666666E60660594100000000DDCA2B41CDCCCC2C0360594166666666EECA2B41333333D300605941CDCCCCCC03CB2B4133333333FF5F59419A99999919CB2B41CDCCCCECFD5F59419A9999992FCB2B41CDCCCC4CFC5F5941CDCCCCCC49CB2B41000000E0F95F59410000000065CB2B41333333B3F75F5941333333337ACB2B41000000A0F65F59419A9999998FCB2B4166666606F65F594133333333A5CB2B4133333353F55F594133333333B8CB2B4166666606F45F59419A999999C5CB2B4133333393F25F594166666666D6CB2B419A999939F05F594133333333F3CB2B419A999979EB5F5941333333330DCC2B41000000C0E75F5941CDCCCCCC2BCC2B419A999979E35F5941CDCCCCCC42CC2B4133333333E05F5941000000005ACC2B4100000040DC5F5941000000006ACC2B41000000A0D85F5941000000007FCC2B4100000000D45F59413333333398CC2B419A999959CF5F5941CDCCCCCCA9CC2B4100000000CC5F594166666666C3CC2B419A999919C75F5941CDCCCCCCDBCC2B41000000A0C25F5941CDCCCCCCF6CC2B4133333393BD5F59413333333316CD2B4100000020B85F59413333333330CD2B419A999919B45F5941CDCCCCCC3CCD2B4166666686B15F5941CDCCCCCC45CD2B4166666606B05F5941333333335BCD2B4166666626AF5F594100000000B1CD2B419A999919AB5F594100000000D8CD2B41666666E6A85F5941666666661ACE2B4100000000A65F59419A99999950CE2B4166666606A45F5941333333336BCE2B419A999999A35F5941CDCCCCCC67CE2B4166666646895F5941CDCCCCCC67CE2B4166666686845F59410000000068CE2B419A999999825F59419A99999966CE2B4133333313785F59413333333365CE2B41666666C66C5F59410000000063CE2B4100000040655F59410000000060CE2B41000000C05D5F5941333333335BCE2B419A999919585F5941CDCCCCCC55CE2B4133333333515F5941333333334FCE2B41CDCCCCEC4A5F59419A99999946CE2B4133333373445F5941333333333FCE2B41CDCCCC8C3F5F59419A99999933CE2B419A9999D9385F59410000000025CE2B41CDCCCC0C315F59413333333319CE2B41CDCCCC8C2A5F59413333333307CE2B4166666626215F5941CDCCCCCCF1CD2B419A999939155F594100000000E0CD2B41CDCCCC8C0B5F594166666666CFCD2B419A999939025F59419A999999BECD2B41CDCCCCECF95E594133333333A9CD2B41666666E6F05E59410000000098CD2B41CDCCCC2CEA5E59410000000087CD2B41666666A6E35E59410000000076CD2B41CDCCCCACDD5E5941CDCCCCCC64CD2B419A9999B9D75E59419A99999951CD2B41CDCCCCECD05E5941666666663CCD2B4166666606C95E5941CDCCCCCC25CD2B41CDCCCC8CC05E5941000000001DCD2B4166666606BD5E5941CDCCCCCC15CD2B4166666626BA5E59416666666610CD2B41000000A0B75E59410000000027CD2B4166666686B55E59419A9999994DCD2B4166666646B35E59413333333378CD2B41666666A6B15E59419A99999960CD2B419A9999D9AE5E59410000000043CD2B41CDCCCC2CAC5E59416666666628CD2B419A999979AA5E59410000000022CD2B419A9999B9A55E5941666666661BCD2B4166666626A45E5941CDCCCCCC09CD2B4166666606A25E594133333333FECC2B419A9999B99F5E594166666666F8CC2B41CDCCCCEC9D5E594133333333F1CC2B41CDCCCCCC995E5941CDCCCCCCE9CC2B4166666686945E594166666666E2CC2B41333333138E5E594100000000DFCD2B41000000806B5E594100000000FCCD2B4133333393605E5941CDCCCCCC03CE2B41CDCCCCEC5E5E59413333333309CE2B419A9999595C5E5941666666660CCE2B4133333393555E5941CDCCCCCC0FCE2B41000000804B5E59413333333313CE2B4100000080465E5941CDCCCCCC09CE2B419A9999193F5E594100000000FECD2B419A9999D9375E5941CDCCCCCC4FCF2B41666666E6365E5941666666669FD02B41CDCCCCEC195E5941CDCCCCCCA6D02B41CDCCCCCCFC5D59419A99999938D02B41CDCCCCECF75D59416666666639D02B41333333B3F15D5941CDCCCCCC4FD02B4133333393E75D59419A999999D0D02B419A999979B95D59419A9999993CD12B4100000080AF5D5941CDCCCCCC4AD12B4133333373A65D5941CDCCCCCCB3D12B4100000040A35D59419A999999EAD12B4166666646A65D594166666666C6D22B41CDCCCCCCA45D5941CDCCCCCC13D32B41000000C0A35D5941000000001BD32B4166666646885D5941CDCCCCCC76D32B41000000C07D5D59416666666695D32B419A9999D97D5D594166666666DBD32B41666666C67D5D5941CDCCCCCC5DD42B41000000E0835D5941CDCCCCCC3CD52B419A9999798E5D5941CDCCCCCC56D52B41000000608B5D5941666666667ED52B41666666E6875D594100000000B0D52B419A9999F9835D594166666666C9D52B41333333B3825D594166666666DDD52B41000000E0815D59413333333346D62B41CDCCCC2C825D5941666666666DD62B4133333373825D5941CDCCCCCCA6D62B41666666A6825D59419A99999900D72B41333333B3815D5941333333336FD72B41CDCCCC2C825D59419A999999BDD72B41CDCCCCAC845D59410000000003D82B41CDCCCCEC8A5D59419A99999932D82B41666666C6905D59419A9999993CD82B419A9999D9925D59419A99999947D82B41CDCCCC6C945D59419A9999995AD82B4166666666965D594166666666A3D82B41000000809B5D5941CDCCCCCCF4D82B419A9999399F5D5941666666660AD92B41666666669F5D59419A9999992DD92B41666666C6AB5D59413333333338D92B41CDCCCC6CAE5D5941000000004FD92B41333333F3B35D59419A99999965D92B4166666686B95D5941666666667CD92B4133333313BF5D59413333333393D92B41666666A6C45D5941666666669BD92B419A9999B9C75D5941CDCCCCCCF9D92B4100000040EB5D5941CDCCCCCC18DA2B419A999939FA5D5941CDCCCCCC3ADA2B41CDCCCCCC055E5941CDCCCCCC44DA2B41000000400A5E5941CDCCCCCC47DA2B41000000C00C5E5941000000004EDA2B41000000600F5E59410000000052DA2B4166666606115E59410000000058DA2B419A999959135E59419A99999966DA2B41333333D3185E59410000000093DA2B41666666C6245E594100000000AFDA2B41CDCCCCAC2B5E59419A999999D0DA2B41CDCCCCEC335E59419A999999E1DA2B419A999939385E594100000000FEDA2B419A9999593E5E5941000000000DDB2B41CDCCCC2C405E59413333333327DB2B419A999919425E59419A999999A9DB2B419A999999485E59419A999999CEDB2B41666666C64C5E5941CDCCCCCCF3DB2B41333333F3505E59413333333363DC2B41000000805D5E594100000000B3DC2B4133333353675E5941000000001FDD2B4133333393715E59419A99999901DD2B4166666626815E5941CDCCCCCCD4DC2B41666666668A5E594133333333ECDC2B4166666686C75E59416666666607DD2B41CDCCCCEC2D5F5941333333339CDC2B4100000040575F59416666666630DC2B419A999999765F5941CDCCCCCC9EDB2B41333333B3B25F59416666666681DB2B41CDCCCC6CBF5F59419A99999941DA2B41CDCCCC8CDD5F5941666666660ADA2B4133333393006059410000000029DA2B41000000200E605941CDCCCCCC84DA2B413333331318605941333333339EDA2B419A99997926605941000000002CDB2B419A99997941605941CDCCCCCC86DB2B41000000C03E6059416666666608DD2B4133333313476059410000000096DD2B41CDCCCCAC5D60594100000000E8DF2B41666666A67B6059410000000014E22B419A9999D99D6059419A99999992E22B419A9999F99D60594166666666C0E22B419A9999799C60594166666666FCE22B413333337395605941CDCCCCCC48E32B41666666868C605941CDCCCCCC38E42B41CDCCCC8C6E60594133333333FDE42B419A9999B951605941CDCCCCCC8FE52B41666666A63760594100000000ECE52B41CDCCCCAC206059413333333310E62B41000000A015605941CDCCCCCCE6E62B419A9999D9F55F59419A999999C3E62B419A999919EE5F5941CDCCCCCC8EE52B41CDCCCC2CC45F59410000000073E52B419A999979C05F59419A99999979E52B4166666646BB5F594166666666A7E52B4100000080B95F59419A9999995AE62B4100000080B35F594100000000CDE62B41CDCCCC6CAD5F59419A99999921E72B41CDCCCC8CA55F5941CDCCCCCC70E72B419A9999799B5F594166666666A6E72B41CDCCCCAC9F5F5941333333339CE82B4166666606BD5F59416666666607E92B4166666666AF5F5941CDCCCCCC94E92B41333333D39A5F5941666666660AEA2B4100000040805F5941CDCCCCCC69EA2B41CDCCCC8C705F594133333333BEEA2B41CDCCCC6C685F594166666666A9EA2B41000000E0555F59413333333348EA2B41000000403A5F59410000000071EA2B419A999999315F59416666666659EA2B419A9999B92A5F59410000000039EA2B4166666606275F59419A99999901EA2B41CDCCCCEC235F594166666666E7E92B41666666261A5F59419A999999BEE92B41333333B30D5F59419A999999D1E92B41666666C6055F5941CDCCCCCCD2E92B41CDCCCCACF75E594166666666A8E92B419A999919E95E5941CDCCCCCC46EA2B4133333313D95E59419A9999991AEB2B4133333353F45E5941CDCCCCCC42EB2B41CDCCCC0CF85E5941CDCCCCCC83EB2B419A9999D9FD5E5941000000001AEC2B41000000A00A5F594166666666D5EC2B41666666C6185F59413333333336ED2B41CDCCCC6C1C5F59410000000054ED2B41333333D31B5F59413333333390ED2B41CDCCCCEC205F594166666666F2ED2B41333333B33A5F59419A999999E7EF2B4133333393065F59410000000090F02B419A999919F45E5941CDCCCCCC9DF12B419A999939D65E594166666666D4F12B4166666606C95E59413333333316F22B41CDCCCC4CB25E59419A9999992FF22B41333333B3A35E59413333333342F22B41333333B38F5E5941CDCCCCCC40F22B419A9999B97B5E59410000000069F22B419A9999796B5E594166666666B8F22B41000000E0465E5941CDCCCCCCE8F22B4166666646355E5941CDCCCCCC10F32B41666666C6265E594100000000DFF22B41CDCCCCEC235E59419A999999ABF22B41000000E0205E5941CDCCCCCC3BF22B41CDCCCCEC195E59413333333316F22B4133333393175E594100000000B5F12B419A9999D9115E59416666666676F12B41000000200E5E59419A99999943F12B41CDCCCCEC0A5E59413333333305F12B4100000020075E59419A999999D7F02B4166666606045E59419A99999996F02B41333333D3FF5D5941333333337AF02B419A9999B9FD5D5941CDCCCCCC62F02B4133333373FB5D59413333333350F02B4166666606F95D5941CDCCCCCC13F02B4133333313F15D594100000000E0EF2B4166666686EA5D594166666666C2EF2B41000000C0E75D594133333333A6EF2B41333333B3E55D5941CDCCCCCC44EF2B419A999999E05D594166666666D4EE2B419A999999DA5D5941CDCCCCCC9AEE2B419A9999B9D75D5941CDCCCCCC66EE2B41000000A0D55D59410000000038EE2B4166666646D45D59410000000014EE2B41666666C6D35D5941CDCCCCCCD9ED2B41333333D3D25D5941000000009CED2B41333333B3D15D59419A9999996CED2B4166666606D15D59413333333302ED2B4133333373CF5D59419A999999CEEC2B41666666C6CE5D59416666666661EC2B41666666E6CC5D5941CDCCCCCC0EEC2B4100000080CB5D5941CDCCCCCCF0EB2B41000000E0CA5D59419A999999F5E92B41CDCCCCCCC55D594100000000B9E82B41CDCCCCECBF5D59413333333389E82B4166666666BF5D59416666666661E82B419A999959BE5D59410000000051E82B4133333393BD5D59419A9999993FE82B419A999959BC5D5941333333332AE82B41CDCCCC6CBA5D59413333333309E82B41000000E0B65D59419A999999CFE72B419A999939B05D5941CDCCCCCCA8E72B4100000000AC5D5941000000008BE72B4166666646A85D59413333333335E72B419A9999399E5D594133333333FAE62B4166666686965D59419A999999E1E62B41CDCCCC4C935D594166666666A8E62B41333333D38A5D59419A9999997AE62B41CDCCCCAC835D59419A99999946E52B41000000806D5D5941333333332FE52B41CDCCCCEC6D5D5941CDCCCCCC1CE52B419A9999196E5D59413333333311E52B41CDCCCC8C6D5D59410000000003E52B41666666666C5D594133333333FAE42B41CDCCCCAC6A5D594166666666F4E42B419A999979675D594100000000EEE42B41CDCCCC2C655D594133333333E2E42B41CDCCCCCC625D594133333333CFE42B4166666626605D594100000000B5E42B41666666E65D5D59419A999999A1E42B419A9999795C5D5941666666668DE42B41333333935B5D5941CDCCCCCC78E42B419A9999F95A5D5941333333335CE42B41000000805A5D59410000000046E42B41666666865A5D59410000000036E42B41CDCCCCCC5A5D59410000000016E42B4166666646595D594133333333DEE32B419A999999565D594100000000AAE32B4166666606545D5941CDCCCCCC74E32B4133333393515D59416666666626E32B4166666646595D59410000000076E22B41CDCCCC6C665D5941CDCCCCCCDFE12B41333333136D5D5941CDCCCCCCC6E02B419A9999B97C5D59419A999999FFDF2B41CDCCCCAC855D5941CDCCCCCC69DF2B419A999959885D59416666666611DF2B41333333B3845D594166666666CADE2B41666666C6785D594133333333F1DE2B41333333336D5D59419A999999F6DE2B41666666266B5D5941CDCCCCCCF5DE2B41CDCCCC0C685D594133333333EDDE2B41CDCCCC0C645D594133333333E2DE2B41333333B3605D594133333333D8DE2B4166666686605D59419A999999B4DE2B41333333935F5D5941CDCCCCCC1CDD2B41000000804B5D59419A9999993EDC2B41CDCCCC8C435D594166666666C7DB2B41000000404D5D594133333333B5DA2B41000000006C5D594133333333ACDA2B41CDCCCC6C6B5D5941666666669EDA2B41666666466B5D59416666666692DA2B419A9999596B5D5941CDCCCCCC82DA2B41666666666C5D59416666666672DA2B419A9999996E5D5941CDCCCCCC63DA2B4100000080705D5941CDCCCCCC55DA2B4166666646725D5941CDCCCCCC71D82B41333333B3495D59416666666672D82B4100000000425D59413333333378D82B419A9999993B5D59410000000082D82B41333333932E5D5941CDCCCCCC8FD82B41000000E02A5D59413333333394D82B4166666606295D5941CDCCCCCC9DD82B41333333F3235D5941000000009CD82B41666666C6205D5941CDCCCCCCA0D82B41666666261D5D594133333333DDD92B41CDCCCC0C105D59413333333303DA2B419A9999F9135D594133333333D6DA2B41000000000C5D59419A9999992CDB2B4166666606F95C59413333333380DB2B4133333313E25C59413333333389DB2B41000000E0C55C59413333333386DB2B419A999959C45C59413333333385DB2B4100000000C25C59416666666684DB2B419A999919BF5C59416666666684DB2B419A999999BB5C5941666666666FDB2B4133333373BB5C5941333333334DDB2B41CDCCCC8CBB5C5941666666661FDB2B419A9999D9BB5C59419A99999903DB2B4166666686BC5C594166666666F0DA2B4166666686BE5C59419A999999B7DA2B419A9999F9BB5C5941CDCCCCCCAADA2B41666666A6BB5C5941CDCCCCCC95DA2B41CDCCCC6CBA5C59419A99999972DA2B419A9999F9B85C59419A99999966DA2B41333333B3BA5C59410000000024DA2B4133333393BD5C5941CDCCCCCC11DA2B4166666626BE5C594133333333F9D92B4133333393BE5C594100000000D7D92B41CDCCCC8CBF5C5941CDCCCCCC89D92B419A999919BF5C59416666666658D92B41000000E0BC5C59413333333338D92B41000000A0BA5C5941333333331ED92B41333333B3B95C594166666666D2D82B41CDCCCC8CB95C594133333333B1D82B41CDCCCC4CB95C59413333333394D82B4133333353B95C5941CDCCCCCC6FD82B41666666E6B95C59416666666657D82B4166666646BB5C59413333333338D82B41CDCCCC6CBB5C59419A99999910D82B41000000A0BB5C59419A999999E4D72B41CDCCCC0CBA5C594166666666D4D72B4166666666B75C594100000000BCD72B419A9999F9B55C5941CDCCCCCC78D72B4133333333AF5C59410000000070D72B4166666666AD5C59419A99999968D72B4166666626A85C59410000000062D72B419A9999D9A45C5941CDCCCCCC62D72B419A999919A05C59410000000064D72B41333333739E5C59410000000081D72B419A9999399F5C594166666666A3D72B41CDCCCC0CA05C59419A999999BCD72B4100000060A05C594133333333D1D72B419A999979A05C59419A999999E7D72B4133333353A05C59413333333326D72B41333333B3845C5941000000002DD72B4100000020765C59419A99999934D72B41CDCCCCAC735C59410000000045D72B4100000000725C59410000000083D72B41666666C6725C59419A999999D6D72B41CDCCCC0C785C59419A9999995FD82B41000000607B5C59410000000099D82B4133333373795C594100000000B4D82B4133333353755C594133333333C0D82B419A999919715C594100000000F4D82B41CDCCCCCC615C5941666666660ED92B41000000205E5C5941CDCCCCCC25D92B41666666E65D5C5941000000008ED92B41CDCCCCAC655C5941CDCCCCCCB1D92B4166666666655C59416666666604DA2B4100000060635C5941666666665BDA2B4133333373655C5941666666669EDA2B4100000080635C5941CDCCCCCCDEDA2B41CDCCCCEC5C5C59416666666636DB2B41333333B35A5C5941CDCCCCCC45DB2B4100000040585C59410000000055DB2B41666666A6565C5941666666666CDB2B41333333F3545C5941CDCCCCCC7ADB2B41CDCCCCCC535C5941000000008BDB2B4100000080515C5941333333339ADB2B41666666C64E5C594133333333AFDB2B419A9999594C5C59419A999999D5DB2B419A999999475C59413333333308DC2B41666666A6425C59419A99999917DC2B4166666606415C5941333333335EDC2B4166666686405C5941CDCCCCCCB2DC2B41000000E03E5C5941CDCCCCCCF0DC2B41000000403D5C59410000000016DD2B41CDCCCC0C3B5C594100000000C8DC2B419A9999F9295C594100000000D6DC2B4100000020285C594100000000E9DC2B4100000040265C5941CDCCCCCC01DD2B41CDCCCC2C245C59413333333323DD2B419A999939225C5941CDCCCCCC41DD2B41CDCCCCAC205C5941CDCCCCCC52DD2B41333333F31E5C59410000000062DD2B419A9999391D5C59419A9999996CDD2B41333333D31A5C5941CDCCCCCC6EDD2B4166666646185C5941CDCCCCCC6BDD2B4133333393165C59419A99999963DD2B419A999939155C59419A9999993CDD2B4166666626125C59410000000020DD2B4100000040105C59410000000012DD2B41333333130F5C59416666666606DD2B41666666660D5C59416666666600DD2B41666666460A5C59416666666602DD2B4133333333075C59419A99999909DD2B419A999939045C59413333333311DD2B4133333353015C5941CDCCCCCC32DD2B419A999979F85B59413333333352DD2B41CDCCCC4CF05B5941000000005CDD2B419A999979ED5B5941000000005EDD2B41CDCCCC6CEA5B59419A9999995DDD2B4166666686E75B59419A9999995BDD2B4133333333E45B5941666666665DDD2B419A999999E15B59413333333363DD2B41CDCCCC0CDF5B5941000000006FDD2B4166666606DD5B5941CDCCCCCC7EDD2B4100000080DB5B59419A99999991DD2B4133333333DA5B59419A999999ACDD2B419A9999D9D85B5941CDCCCCCCC2DD2B419A9999B9D75B59419A999999C3DD2B41CDCCCC8CD75B5941CDCCCCCCCEDD2B41CDCCCCCCD55B594100000000E0DD2B4133333373D35B5941CDCCCCCCFFDD2B41666666C6CE5B5941000000001EDE2B41000000A0CB5B5941000000003BDE2B419A999919C65B59410000000040DE2B4100000060C25B59410000000040DE2B41CDCCCC8CBE5B59416666666635DE2B41CDCCCC8CB95B5941333333332CDE2B41CDCCCC8CB85B59419A99999907DE2B4100000080B45B59410000000001DE2B41CDCCCCECAF5B59419A999999FADD2B4133333353AA5B59419A9999990EDE2B41333333B3A45B59419A99999924DE2B4133333313A05B59419A9999992EDE2B41000000C09C5B5941666666662CDE2B41CDCCCC6C985B5941CDCCCCCC1FDE2B41000000A0955B59419A99999927DE2B41CDCCCC8C915B59413333333350DE2B41CDCCCCAC8E5B59413333333356DE2B419A9999198B5B59410000000054DE2B4133333393885B5941666666664FDE2B419A999979835B59413333333349DE2B41666666667F5B59413333333351DE2B41333333537B5B59410000000057DE2B4166666646795B59410000000069DE2B41666666E6745B5941CDCCCCCC66DE2B419A999959715B5941000000006DDE2B419A9999996A5B5941666666666EDE2B4166666626695B5941000000006EDE2B419A999939675B5941333333336EDE2B41000000C0655B5941CDCCCCCC6DDE2B419A9999D9635B59419A99999964DE2B41000000E05E5B59419A9999995FDE2B419A9999995C5B5941CDCCCCCC5CDE2B41666666665A5B5941000000005ADE2B41666666A6585B59416666666657DE2B41333333D3565B59419A99999942DE2B41666666C6505B594100000000C2DD2B4166666686455B5941CDCCCCCCB2DD2B4133333313415B594166666666B3DD2B419A9999193C5B5941333333333DDE2B4100000020315B5941CDCCCCCCE6DE2B419A9999991D5B5941000000001CDF2B419A9999790E5B59419A99999929DF2B41666666E6035B5941000000004EDF2B4100000040EC5A5941CDCCCCCC64DF2B419A999919D95A59416666666674DF2B4133333353D25A59419A99999925DF2B419A999959CD5A5941CDCCCCCC30DF2B4166666646C05A59419A999999B7DF2B419A9999D9905A5941CDCCCCCCAADF2B41666666266A5A59419A999999F1DF2B41666666665A5A59419A999999F3DF2B4133333313565A5941CDCCCCCCF7DF2B4100000020515A5941CDCCCCCCFFDF2B419A9999594D5A5941CDCCCCCC05E02B41333333734B5A5941000000000DE02B41CDCCCCEC495A59419A99999928E02B41666666C6445A59413333333348E02B41CDCCCC6C3F5A59413333333354E02B41666666063D5A59419A9999995AE02B419A9999593A5A59419A9999995EE02B419A999959305A5941CDCCCCCC61E02B41000000602D5A59419A9999996CE02B41333333D3285A59410000000073E02B41333333D3275A5941666666667BE02B419A999939275A59419A9999998EE02B41CDCCCC6C255A5941CDCCCCCCA0E02B4166666666235A59419A999999AEE02B4166666626205A5941CDCCCCCCB5E02B41000000E01B5A5941CDCCCCCCB3E02B41CDCCCC0C185A594166666666B3E02B4133333393155A59419A999999A0E02B41CDCCCCEC0D5A59419A99999988E02B4100000040075A5941000000007FE02B41333333D3035A59413333333360E02B4100000020FF595941333333335EE02B419A999999F85959413333333368E02B41CDCCCCACF2595941333333336EE02B419A999919EE595941CDCCCCCC66E02B4100000000EC595941CDCCCCCC3CE02B4133333313E55959413333333316E02B41666666E6DC595941666666660DE02B419A999999DB59594166666666D1DF2B419A9999F9C35959416666666654DF2B41CDCCCC6C7A59594166666666CBDF2B41CDCCCCCC6D5959416666666647E02B41CDCCCC2C66595941CDCCCCCC92E02B419A9999996059594133333333BBE02B419A9999595B5959419A999999E0E02B416666660657595941CDCCCCCC20E12B410000008048595941CDCCCCCC6BE12B4133333353415959410000000089E12B41CDCCCC0C4059594100000000B5E12B41CDCCCC6C3F59594166666666DAE12B41CDCCCCEC3C59594133333333F2E12B419A9999F9365959419A9999991AE22B4133333373315959413333333343E22B41333333532D595941333333336DE22B41CDCCCC2C295959419A999999A7E22B41333333D3235959419A999999E8E22B41333333731E595941CDCCCCCCF6E22B416666662619595941CDCCCCCC06E32B41333333D3135959419A9999991DE32B419A9999F911595941666666663CE32B4166666686115959416666666653E32B41CDCCCC8C13595941CDCCCCCC53E32B41666666A619595941000000004CE32B41CDCCCC2C1F5959416666666651E32B41333333B325595941CDCCCCCC51E32B41666666662C5959416666666652E32B4166666686325959413333333349E32B41000000203D5959410000000031E32B4100000000465959416666666622E32B41666666C6485959419A99999911E32B419A9999394B5959419A99999902E32B41000000204D595941CDCCCCCCF4E22B419A9999F94E59594166666666E5E22B410000008051595941CDCCCCCCB2E22B419A999979595959419A99999999E22B41333333F35C595941000000008AE22B41666666665F5959413333333383E22B41CDCCCCCC605959410000000032E22B4100000020695959419A9999992FE22B41666666066A5959413333333327E22B41666666466B5959419A99999919E22B41CDCCCCEC6C595941666666660FE22B419A9999196E59594133333333F4E12B41CDCCCC0C7259594100000000E0E12B419A99997977595941CDCCCCCCD0E12B419A9999197C5959419A999999CBE12B41CDCCCC8C7E59594133333333C9E12B41333333F38159594133333333C8E12B41CDCCCCCC885959419A999999C5E12B41000000E08A59594133333333AAE22B4133333333B95959410000000037E32B41CDCCCCCCC65959410000000099E32B41333333B3CB595941CDCCCCCCEAE32B419A999999C65959410000000094E42B41CDCCCC6CBC595941666666668DE52B41CDCCCC2CB7595941CDCCCCCC62E52B41000000A0B05959419A9999993CE52B41000000C0AA59594133333333E6E42B4166666606A359594100000000CEE42B41000000E0A05959419A99999944E52B41666666C68C5959413333333330E52B41CDCCCC0C895959410000000085E42B410000000074595941000000009BE42B41000000606E59594133333333ACE42B419A9999F969595941CDCCCCCCABE42B419A9999B96359594166666666ABE42B419A9999795D59594100000000ABE42B419A999939575959419A999999AAE42B419A9999F95059594133333333AAE42B41000000C04A595941CDCCCCCCCCE42B41333333734159594166666666E6E42B41CDCCCCEC3D5959419A999999FDE42B41000000C037595941333333331BE52B41CDCCCCAC2F5959419A99999938E52B41CDCCCCAC285959419A99999964E52B41000000001A595941333333336BE52B41CDCCCC6C0F595941333333333BE52B41CDCCCC0C015959419A99999919E52B4133333333FA5859416666666602E52B41CDCCCC2CF758594100000000AEE42B41CDCCCCCCF05859410000000061E42B4100000080EA585941CDCCCCCCB3E32B41333333D3EA585941CDCCCCCCFCE12B41666666060E59594166666666A3E12B41000000E0FC585941CDCCCCCCDEDE2B41000000007858594166666666CADE2B41666666C6715859419A999999DDDE2B416666668666585941CDCCCCCCD1DE2B41CDCCCC4C4C585941333333337FDE2B41CDCCCCAC25585941CDCCCCCC7DDE2B41CDCCCCAC1158594166666666CCDE2B41000000A0FD5759416666666604DF2B4133333333F3575941CDCCCCCC60DF2B419A999979E9575941CDCCCCCC91DF2B41CDCCCCACE35759413333333330E02B4166666646C6575941000000005DE02B4100000000BF57594100000000A5E02B41CDCCCCCCB15759419A999999EBE02B4100000040AB5759419A99999965E12B41333333539B5759419A99999929E22B41666666A6855759416666666629E32B41CDCCCCCC4E5759419A99999995E32B41333333B33557594100000000CCE22B41333333731A57594166666666ADE22B419A9999F91257594100000000CBE22B41333333B30C5759419A9999997DE32B4166666606FB5659410000000069E32B41CDCCCC0CF1565941000000003BE62B4133333373B0565941333333331DE62B41CDCCCC2CA75659416666666605E62B41666666C695565941CDCCCCCCC6E52B41CDCCCCAC855659413333333357E52B416666662671565941CDCCCCCCA2E52B41CDCCCC4C6356594166666666D1E52B41CDCCCCCC595659419A99999983E42B4100000080295659416666666699E32B41666666060F5659410000000067E12B41CDCCCC8CCE5559413333333394DE2B41CDCCCCCC6A555941CDCCCCCC1BDE2B419A99995956555941	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	01010000206A080000E608750276D42B41CDCCCCACFB5A5941	390130000	Z	Arbois	3901300	39013	39	27	46
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	01010000206A0800007DB55FA8E3332B41333333D331775941	390140000	Z	Archelange	3901400	39014	39	27	5
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	01060000206A08000001000000010300000001000000D4000000CDCCCCCC3C032C4166666666DC4D5941CDCCCCCCB1032C41CDCCCCECE84D5941666666663D042C41CDCCCC0CFA4D5941CDCCCCCC11052C4133333373114E59419A999999AB052C41333333B3234E59419A999999EB052C41333333D3284E59413333333323062C41666666262B4E5941CDCCCCCC80062C419A9999F9304E594166666666C7062C41000000E0364E594166666666F1062C41000000203C4E5941CDCCCCCC19072C4133333373474E59410000000002072C41666666064B4E594166666666D7062C419A9999995E4E59419A999999B0062C41333333D36C4E59410000000093062C41CDCCCC2C724E59416666666634052C41333333B3984E594166666666B6072C41000000E0F04E59410000000022092C41333333731F4F594100000000AC0A2C41666666A6524F594133333333280B2C41333333F3474F5941CDCCCCCCB30B2C41666666263A4F5941CDCCCCCC100C2C419A9999592D4F594166666666C70C2C41CDCCCCEC0C4F5941CDCCCCCC1F0D2C419A999999FA4E594166666666F20D2C41666666A60F4F5941666666662E0E2C4166666606214F59419A999999630E2C419A9999B9284F594100000000A20E2C41666666262D4F594133333333180F2C419A999979304F59419A9999999C0F2C41000000403F4F59410000000056102C41000000404B4F5941CDCCCCCCD1102C41CDCCCC8C504F5941333333338B102C41CDCCCCAC614F59410000000020102C41CDCCCC4C6F4F5941CDCCCCCCB90F2C419A999979874F594100000000900F2C41333333D38D4F59419A9999991C0F2C41333333339A4F5941CDCCCCCCD70E2C41CDCCCC4CA34F594100000000E20E2C4166666606A84F594133333333D80E2C419A999919B24F594133333333F30E2C4166666666BA4F5941CDCCCCCC970E2C4166666666C14F59419A999999400E2C4100000040C54F594133333333F10D2C4166666606CB4F5941CDCCCCCCCE0D2C41666666E6D54F59419A999999DE0D2C41CDCCCCCCDA4F5941333333330E0E2C4100000000E24F59419A9999990E0E2C4166666606ED4F594166666666190E2C4100000080F14F5941000000006D0E2C4166666626F64F59419A9999994A0F2C41CDCCCC6C005059419A999999EA0F2C41CDCCCCAC135059416666666631102C41333333D31A505941CDCCCCCC63102C419A99999923505941CDCCCCCC68102C41000000802F50594100000000C90F2C41666666C64A50594100000000920F2C419A9999F95F50594133333333230F2C419A9999397B50594166666666930F2C416666660685505941666666669C0F2C419A9999198D5059419A9999997D0F2C41CDCCCCCC97505941CDCCCCCCA40F2C41333333B3B05059410000000031102C41CDCCCC2CA9505941CDCCCCCCBD102C41333333B3A45059416666666649112C41CDCCCCCCA550594133333333AA112C41333333B3A5505941CDCCCCCCF8112C41CDCCCCCCA65059419A9999995E122C41CDCCCC8CA250594166666666CE122C41333333939B505941CDCCCCCC7B132C41000000408E50594133333333CC132C41000000008E5059410000000039142C419A9999F9835059410000000085142C41666666A6805059419A999999F6142C41666666E67E505941666666662A152C419A9999F97B505941CDCCCCCCAD152C41333333736D505941CDCCCCCCEC152C4100000040695059413333333313162C41000000A063505941CDCCCCCC45162C41333333734A50594100000000A9162C41000000C033505941CDCCCCCC2E172C419A9999391B5059416666666656172C4166666606175059410000000071172C419A999919175059419A9999999B172C4166666646115059419A99999911182C41CDCCCC4C055059413333333353182C41666666C6FD4F5941000000009F182C4166666646F04F5941CDCCCCCC3E192C41666666A6D14F59416666666658192C419A999919CE4F59416666666657192C4133333393C44F594133333333A3192C4133333353BC4F594166666666001A2C4100000060BC4F594166666666911A2C4166666606C04F594166666666A21A2C419A999919B84F594166666666CC1A2C4133333373B34F594133333333171B2C41CDCCCC2CAE4F594166666666731B2C41000000C09A4F594166666666B71B2C4133333353884F5941CDCCCCCCB01B2C4166666606824F594100000000041C2C41000000207E4F59419A9999991A1C2C419A9999F9794F594166666666131C2C419A999919744F5941CDCCCCCCEC1B2C419A9999B96F4F5941333333335A1B2C4133333393644F594133333333211B2C41000000E0664F594133333333C81A2C41CDCCCC2C654F594166666666AC1A2C41CDCCCC8C604F59419A999999751A2C419A999919514F594166666666251A2C419A9999D9424F5941CDCCCCCCE5192C41CDCCCCEC3B4F594166666666D8192C41000000E0374F594133333333BE192C41CDCCCC8C244F5941666666669C192C41000000001A4F5941333333332D192C41CDCCCC0C0C4F59410000000013192C4133333313054F594133333333A1182C41000000C0F84E5941000000000E182C41CDCCCC8CEF4E5941CDCCCCCCC9172C419A999919EF4E5941CDCCCCCC97172C4100000000F74E59419A99999947172C419A9999F9F74E59419A9999990C172C41CDCCCC8CF14E59419A999999D0162C41CDCCCCACE14E594133333333D7162C419A999979BF4E594100000000C1162C419A9999F9B54E5941333333337D162C41666666C6AC4E59413333333314162C419A9999B9A44E594100000000ED152C419A999959A34E59419A999999C8152C419A999919A54E59410000000070152C41CDCCCC6C9E4E59413333333319152C41333333539D4E59419A999999AA142C4133333313964E59416666666669142C41CDCCCC0C8C4E59416666666656142C4166666606804E5941CDCCCCCC2F142C4100000020764E594133333333F7132C419A9999D96C4E59419A999999BF132C4166666666684E59419A99999960132C41333333536A4E59416666666614132C41CDCCCC8C664E59410000000001132C41CDCCCCAC5F4E59419A999999D8122C419A999939574E59419A999999EB122C41000000004C4E5941CDCCCCCCE6122C41666666C6454E594166666666C4122C41000000E03B4E59419A999999AA122C41000000603A4E5941CDCCCCCC4D122C41666666463E4E59416666666622122C41000000E03B4E5941CDCCCCCCFA112C41333333B3354E5941CDCCCCCCC0112C419A999999244E5941333333336B112C419A999959134E5941666666663D112C41666666E60E4E59419A999999EA102C41333333530E4E5941CDCCCCCCB2102C4133333353054E594166666666B1102C41CDCCCC2CFC4D5941333333339F102C419A999939F74D5941333333339D102C41666666A6F04D594166666666AF102C41666666C6EA4D594166666666A4102C419A9999D9DA4D59416666666693102C41000000C0D54D59413333333322102C41333333B3CD4D59419A999999C30F2C4100000000CE4D59419A999999730F2C419A999919C64D594100000000120F2C4100000020B54D59419A999999270F2C419A999939AE4D5941666666668D0F2C41CDCCCC0CA84D594166666666C70F2C4133333333A34D59410000000001102C419A9999B99A4D59419A99999917102C41CDCCCCAC944D5941666666661D102C41CDCCCCAC8A4D59419A9999994D102C419A9999B97E4D5941000000004D102C41CDCCCC8C6F4D59416666666657102C4166666666694D59413333333340102C41666666065E4D59413333333312102C41666666865B4D594133333333DC0F2C41CDCCCCEC5A4D5941666666666A0F2C41CDCCCCAC4B4D594100000000560F2C41666666C6464D5941CDCCCCCC190F2C419A999939404D5941CDCCCCCC880E2C41CDCCCC4C334D594100000000630E2C419A9999F92E4D5941CDCCCCCC350E2C41666666E62D4D594133333333090E2C41CDCCCC0C314D5941CDCCCCCCEC0D2C4100000080384D5941CDCCCCCCDE0D2C419A999959404D5941CDCCCCCCCB0D2C4166666606434D5941CDCCCCCCA40D2C4166666626434D594166666666380D2C419A9999593E4D59419A999999060D2C41000000403A4D59419A9999999D0C2C41333333B32C4D594166666666670C2C419A9999B9274D594166666666F30B2C419A999979214D59419A999999A50B2C4133333313124D594133333333690B2C4100000080034D5941666666664D0B2C41CDCCCC0CFA4C5941333333333A0B2C41666666A6DC4C5941CDCCCCCCDA0A2C4100000000D14C594100000000CD0A2C4166666646CB4C594100000000C30A2C4166666686BB4C5941CDCCCCCCB00A2C419A999959B64C594133333333710A2C41000000A0B74C59419A999999270A2C4133333373C14C594166666666F2092C41333333F3C54C594133333333A0092C4133333313C34C5941CDCCCCCCA8092C419A999999C84C594166666666D0092C41CDCCCC6CCD4C594166666666200A2C41CDCCCC4CDA4C5941CDCCCCCC450A2C4100000020E64C594133333333200A2C41333333F3EF4C5941CDCCCCCC7A0A2C4100000040FB4C59419A999999B0052C41666666667D4D5941666666662A062C4100000060894D5941CDCCCCCC3C032C4166666666DC4D5941CDCCCCCC3C032C4166666666DC4D5941	01010000206A0800008324AF954F0E2C41000000C0B24E5941	390150000	Z	Ardon	3901500	39015	39	27	5
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	01010000206A080000E871C24676672B419A9999B9BB245941	390160000	Z	Arinthod	3901600	39016	39	27	27
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	01010000206A08000010AF4B63EF462B41333333F3744D5941	390170000	Z	Arlay	3901700	39017	39	27	20
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	01010000206A080000B80852FA80382B41000000E0FF1B5941	390180000	Z	Aromas	3901800	39018	39	27	26
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	01010000206A08000084923B05D0D12B416666668628625941	390190000	Z	Les Arsures	3901900	39019	39	27	4
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	01010000206A0800000A0C138A568A2C419A9999C90C495941	390200000	Z	Arsure-Arsurette	3902000	39020	39	27	13
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	01010000206A0800007566EC7D71462B419A9999E939395941	390210000	Z	La Chailleuse	3902100	39021	39	27	25
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	01010000206A0800002C37449E63EF2A41666666C6905F5941	390220000	Z	Asnans-Beauvoisin	3902200	39022	39	27	16
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	01010000206A08000046F6843BDE572B41343333D3DF755941	390240000	Z	Audelange	3902400	39024	39	27	5
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	01060000206A080000010000000103000000010000000101000000000000CEE12A41333333935A3859413333333304E22A41000000005E385941000000003CE22A41000000205C3859413333333350E22A41CDCCCCAC5F3859416666666654E22A413333331367385941333333336CE22A419A9999D9673859413333333381E22A41666666866238594100000000BCE22A41000000806738594100000000BFE22A419A9999396C385941000000000FE32A41000000E0753859419A99999938E32A41666666E673385941CDCCCCCC5DE32A41000000807A385941666666668CE32A41000000807938594133333333A1E32A41333333538038594133333333BCE32A41333333B37D38594133333333DEE32A41CDCCCCAC8038594133333333E2E32A416666660685385941CDCCCCCC08E42A419A9999998B385941CDCCCCCC2DE42A4133333373893859413333333350E42A41333333D38C3859413333333352E42A419A9999F98F385941333333337DE42A419A9999D993385941CDCCCCCCB9E42A41333333F39438594166666666B1E42A41666666A69A3859419A999999C9E42A41666666869C3859410000000014E52A41000000E09B3859410000000012E52A419A999999A13859410000000039E52A4100000000A53859419A9999996EE52A41000000C0A2385941CDCCCCCC77E52A41333333F3A838594100000000ADE52A4166666666A93859410000000008E62A41CDCCCC8CAE385941333333333BE62A41333333F3AF3859416666666683E62A41CDCCCCCCAC3859419A999999FDE62A419A999979B03859419A99999918E72A4133333313AE3859419A99999944E72A41000000C0AF3859419A99999969E72A4166666646AD3859416666666698E72A41666666A6AE38594100000000AEE72A4166666626AC38594166666666C4E72A419A999959AE385941CDCCCCCCFBE72A41000000E0AB385941333333330FE82A419A9999D9A6385941CDCCCCCC77E82A41666666C6A6385941CDCCCCCC98E82A41CDCCCC2CAA385941CDCCCCCCECE82A41CDCCCC0CA93859410000000006E92A41000000A0AD385941333333335EE92A41CDCCCC4CAF3859416666666680E92A41CDCCCC2CAD3859419A999999B6E92A4166666686AD385941CDCCCCCCE6E92A41333333F3A5385941333333330DEA2A41CDCCCC2C9D3859413333333347EA2A41000000609D3859413333333353EA2A419A9999B9993859416666666641EA2A419A99993993385941000000004BEA2A410000006090385941000000008BEA2A41CDCCCC0C8A38594166666666E7EA2A41CDCCCC4C7F3859419A99999903EB2A41666666C6773859413333333336EB2A4166666686713859419A99999972EB2A41CDCCCC6C6D38594166666666FEEB2A419A9999D9573859419A9999991DEC2A413333337350385941CDCCCCCC5DEC2A41666666A6473859416666666684EC2A413333333345385941CDCCCCCCA7EC2A41000000C03C38594166666666EAEC2A4133333353353859410000000011ED2A41333333D32C385941CDCCCCCCCCED2A41CDCCCCCC1D38594133333333F7EE2A41000000E0023859419A99999935EF2A4133333313FC3759419A99999989EF2A41000000E0F537594100000000D1EF2A4100000020EF375941000000003DF02A41666666A6E73759410000000077F02A41000000C0E4375941CDCCCCCC38F12A41333333B3D5375941CDCCCCCCC9F12A419A999979C8375941333333331FF22A41000000E0C33759410000000018F32A419A9999F9AB3759413333333371F32A41666666A6A03759413333333348F32A41333333339437594166666666C4F22A41CDCCCC4C7937594166666666ECF22A4133333353763759419A99999982F32A419A9999597337594100000000AAF32A41CDCCCC2C703759419A999999F2F32A41CDCCCCCC713759416666666616F42A41000000806E37594100000000DAF42A410000000063375941CDCCCCCCF5F42A41000000C0623759419A9999991BF52A41666666265E3759419A99999956F52A41CDCCCCCC5A3759419A9999996DF52A41CDCCCC4C5337594166666666BCF52A419A9999D94D375941CDCCCCCCF8F52A41333333334B375941CDCCCCCC3BF62A419A999939443759419A9999996BF62A419A9999794137594100000000BCF62A41CDCCCC2C403759410000000065F72A41666666263C3759419A99999999F72A4166666626373759419A999999FDF72A41CDCCCCAC333759413333333319F82A41333333B32F375941CDCCCCCC7FF82A41333333932A37594133333333C4F82A41CDCCCCCC2A375941CDCCCCCCFCF92A41666666861F3759410000000048FA2A41000000602137594100000000A2FA2A41000000A01D3759416666666628FB2A41333333731C3759416666666684FB2A419A9999191F37594133333333D6FB2A41333333731C375941CDCCCCCC16FC2A4166666626183759413333333352FC2A4100000040113759419A9999996EFC2A41000000C00B375941333333332AFC2A41CDCCCC0C05375941333333336BFC2A4166666646FF36594100000000A1FC2A419A9999D9FE36594166666666F5FC2A4100000020FB365941CDCCCCCC09FD2A41CDCCCCECFD3659419A9999994AFD2A41CDCCCCCCFD36594133333333B7FD2A419A9999D9F23659419A99999901FE2A419A999959F1365941000000001AFE2A41CDCCCC0CF63659410000000061FE2A419A9999D9FA3659419A999999E9FE2A4133333313FD365941CDCCCCCC31FF2A41000000E0FB3659413333333354FF2A419A999979F836594133333333B5FF2A41000000A0E43659419A999999E6FF2A4166666666D83659419A9999995BFF2A419A999919B036594133333333F1FF2A41CDCCCCACA4365941CDCCCCCC04002B41666666669E36594166666666E5FF2A41333333738A3659419A9999998AFF2A41CDCCCC2C7736594166666666DE002B41CDCCCCCC623659410000000028012B41000000605F3659419A9999995E012B410000002058365941CDCCCCCC03022B41CDCCCCEC493659416666666652022B419A9999994F365941CDCCCCCC86022B41333333734F36594100000000D2022B41666666A653365941CDCCCCCCEB022B41CDCCCC2C413659419A999999DE022B41666666E62C36594133333333E9022B41666666A61736594100000000D5022B41CDCCCCCC0136594100000000D7022B4166666626FA35594133333333C4022B419A999959F435594100000000D4022B4166666666EE355941333333334C022B419A9999F9B2355941CDCCCCCC04022B41CDCCCC0C9F3559413333333366022B41666666A6A6355941CDCCCCCCE6022B419A999959A23559416666666689022B4133333333913559410000000075022B41000000E088355941CDCCCCCC35022B41333333F37935594166666666DB012B41666666065E35594133333333A9012B41000000205D355941CDCCCCCC6E012B410000006025355941CDCCCCCC2B012B419A9999B9143559419A99999925012B41000000000D3559419A999999D3002B41CDCCCC4C013559416666666685002B4133333353123559416666666663FF2A41666666664B355941CDCCCCCC2EFF2A41CDCCCCAC3F355941CDCCCCCC71FE2A419A9999594C3559416666666649FE2A4166666626463559419A99999921FE2A4133333333463559416666666664FD2A416666666650355941CDCCCCCCD5FC2A41333333B35F3559416666666692FC2A41000000604F3559410000000022FC2A419A9999793735594166666666C0FB2A41CDCCCCEC163559410000000013FB2A419A999959193559416666666648FA2A41000000E03B355941000000001CFA2A41CDCCCCCC3F355941666666668DF82A41CDCCCCCC583559410000000062F82A419A99993954355941333333332DF72A41333333D3663559419A99999935F62A410000004076355941CDCCCCCC15F62A413333331370355941CDCCCCCCE4F52A41CDCCCCAC5F3559419A99999951F52A41333333F36535594133333333E1F42A41000000A0693559413333333331F42A41000000A071355941CDCCCCCC04F42A41CDCCCC4C7835594166666666E5F32A41000000007A35594100000000F7F22A41333333737D3559416666666660F22A41CDCCCCCC7D355941CDCCCCCC15F22A419A9999B97C35594100000000E1F12A41CDCCCC2C7E3559416666666613F12A41CDCCCC2C7E3559419A99999993F02A413333333378355941333333334CF02A410000000076355941000000000EF02A41333333F375355941CDCCCCCCC0EF2A41CDCCCC8C793559410000000072EF2A419A9999B97E355941CDCCCCCC20EF2A41666666C67D35594133333333DEEE2A41CDCCCCEC753559410000000089EE2A419A999979703559413333333348EE2A41333333F375355941CDCCCCCCEEED2A41CDCCCC2C8D35594100000000DAED2A419A9999799F355941CDCCCCCCCBED2A41666666A6C13559419A9999994FED2A41333333B3C7355941CDCCCCCC0AED2A41CDCCCCACD235594100000000C4EC2A419A999959E33559413333333328EC2A41000000A0FF35594133333333E6EB2A416666660617365941666666669CEB2A419A9999D9283659419A9999996FEB2A41CDCCCC0C3E3659410000000027EB2A41666666864A36594100000000E3EA2A4133333373493659416666666612EA2A41CDCCCC8C8136594133333333ECE92A419A9999F98D365941CDCCCCCCA5E92A41000000E09E3659416666666670E92A41333333339F365941CDCCCCCC32E92A4166666686A43659419A999999E1E82A419A9999D9AE36594166666666AFE82A41CDCCCC8CB7365941666666669DE82A41333333B3BE365941666666669CE82A41CDCCCC8CC6365941CDCCCCCC5CE82A41333333B3D3365941000000004EE82A41000000E0DB3659419A999999FEE72A41333333F3E53659416666666669E72A419A999999ED3659419A9999994BE72A41000000A0F23659410000000043E72A4100000020043759419A99999925E72A41666666260E37594133333333FEE62A41CDCCCCAC153759419A999999A4E62A41666666061C37594133333333DEE52A419A9999F92E375941CDCCCCCCBDE52A41000000C033375941000000007BE52A41333333533A375941CDCCCCCC57E52A41333333B33F3759416666666621E52A419A9999595D3759419A999999F7E42A41000000E07837594133333333DCE42A41000000A08E3759416666666691E42A4166666686BC3759416666666686E42A4133333353C6375941CDCCCCCC72E42A4133333393CE3759416666666677E32A419A9999D90F385941333333334CE32A419A9999F916385941000000002AE32A41CDCCCC2C26385941CDCCCCCC2CE32A41CDCCCCAC323859413333333316E32A41CDCCCC0C383859419A9999991DE32A41CDCCCCCC3B3859419A999999F6E22A41333333933B385941CDCCCCCCE8E22A41CDCCCCEC3E38594100000000B6E22A4133333333433859416666666692E22A419A9999D9423859419A99999980E22A41CDCCCC2C463859416666666649E22A4133333313483859410000000046E22A419A9999794A3859419A99999912E22A41333333334E385941666666660AE22A410000000052385941CDCCCCCCECE12A41CDCCCC4C5338594100000000EDE12A419A9999995738594100000000CEE12A41333333935A38594100000000CEE12A41333333935A385941	01010000206A080000407EBC5C18F42A4133333323DA365941	390250000	Z	Augea	3902500	39025	39	27	8
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	01060000206A08000001000000010300000001000000DB00000033333333BD512B41CDCCCC0C546759419A999999DA512B419A9999997E675941CDCCCCCCE3512B4133333373A16759419A999999DF512B41000000C0A367594100000000FB512B41666666A6B86759413333333334522B41666666C6CB675941333333333F522B41333333D3D36759416666666624522B4100000020DD67594133333333ED512B41333333F3E4675941333333333F522B4166666626E9675941CDCCCCCC7C522B41CDCCCCECF1675941333333339D522B41000000C0F96759419A999999F6522B410000004006685941333333333E532B419A9999F9076859416666666689532B413333333314685941CDCCCCCCCF532B41CDCCCCEC226859410000000009542B419A9999D92B6859419A9999998D542B41333333533E68594133333333D6512B4166666606496859413333333362522B41CDCCCCCC836859419A99999990522B419A99999983685941CDCCCCCC7F532B419A999939DB685941000000009B522B41CDCCCC6CE1685941CDCCCCCC5A522B419A9999D9F1685941000000001C542B4100000060EC685941CDCCCCCC3C542B41000000800A6959413333333355542B41666666E61C695941333333337E542B41CDCCCC0C4569594100000000A7542B419A9999F9546959410000000057552B41333333538E69594100000000CD542B41000000009D6959419A999999E4542B41333333739E6959413333333302562B41CDCCCC0CAB6959419A999999B4562B41CDCCCC2CB4695941CDCCCCCC9B572B4100000040BF695941000000003C592B4100000000D16959410000000093592B41CDCCCCECD369594100000000975B2B4133333373EB69594133333333335C2B41CDCCCCECF169594166666666D95B2B41000000200B6A594133333333E95A2B41000000204B6A59413333333330552B4100000000FC6B5941CDCCCCCC1F552B4133333353036C5941CDCCCCCC21542B41CDCCCC4C4B6C594133333333EE532B4133333313596C5941CDCCCCCC9D532B41333333F3716C59416666666668532B4133333333806C59419A9999997A522B4133333313C66C5941CDCCCCCCDA512B41666666C6F26C59419A999999D3512B41000000A0F56C59416666666642522B4133333373FA6C5941333333332C542B4166666606116D594166666666E5542B419A9999D9196D594100000000F5552B419A9999D9256D59419A999999CA572B41000000203B6D59419A99999933582B419A9999793F6D594133333333B6582B4100000020466D594166666666C1582B41666666E6416D59419A9999996D592B419A9999190E6D594100000000EA592B4133333353E96C594100000000795A2B4166666646BB6C5941000000008A5A2B419A999919B76C5941333333331A5B2B41333333D38C6C59419A999999C45B2B4100000000576C59419A999999FC5B2B4100000040476C594166666666155C2B41333333333C6C5941000000006A5C2B41333333F3336C5941CDCCCCCC6F5C2B41CDCCCCCC286C594100000000805C2B41333333931E6C594133333333985C2B41CDCCCC2C196C59419A999999B75C2B419A9999F9166C594133333333DC5C2B419A9999F90B6C5941CDCCCCCC465D2B41000000C0E66B594166666666AB5D2B41333333F3C86B5941CDCCCCCC135E2B4166666666A16B5941CDCCCCCC695E2B41CDCCCC6C866B5941000000001D5F2B419A9999F94F6B5941CDCCCCCC09602B4166666646076B59413333333346602B4133333313F46A594100000000CF602B419A999999CA6A59419A9999994E612B4166666606A36A59416666666643622B41CDCCCCCC556A5941333333331E632B41CDCCCC4C126A59419A99999967632B41CDCCCC8CFA6959410000000020642B41CDCCCCCCC16959419A999999D2642B419A999979886959419A9999995A652B41000000405E695941CDCCCCCCAF652B419A9999B94469594133333333AD652B41000000A03E6959419A99999989652B419A9999793C69594133333333EA642B41333333B33C695941CDCCCCCC40642B4100000020436959419A999999DD632B419A9999394D695941666666663A622B41CDCCCC2C55695941000000002D612B41333333B35B69594133333333DD602B41666666C65B6959419A99999913602B41666666064369594166666666365F2B41666666462F695941CDCCCCCC625E2B416666660614695941CDCCCCCC115E2B41000000200569594133333333AD5D2B419A999939FB685941CDCCCCCC705D2B41CDCCCC4CF6685941666666668E5D2B4166666646F168594166666666235E2B41000000A0E4685941CDCCCCCC545E2B41333333D3DB685941666666665E5E2B4133333353D4685941CDCCCCCC845D2B4166666606B468594100000000185D2B41CDCCCC2C9F685941CDCCCCCCCF5C2B41333333B38A68594133333333BA5C2B41666666E67E68594100000000AF5B2B41CDCCCCEC0A68594133333333A75B2B4133333353056859419A9999996B5B2B41CDCCCC4CF4675941333333336B5B2B4133333393F067594166666666E35B2B41CDCCCCECF267594133333333015C2B4166666666F06759419A999999EC5B2B41CDCCCCACE7675941000000009B5B2B4166666646D167594166666666185B2B41CDCCCC2CC667594133333333DC5A2B41000000C0C367594166666666C85A2B4166666646C66759419A999999965A2B4133333353C66759419A999999D4592B41000000A089675941666666663E5A2B41666666267D6759419A99999944592B41666666465867594166666666A7582B41CDCCCCEC48675941666666668F582B41000000C0446759419A99999958582B41000000A0296759416666666667582B419A99999921675941CDCCCCCC9C582B41666666061267594166666666C3582B41000000600B6759413333333332592B41333333F3006759416666666676592B41CDCCCC8CFE66594100000000635A2B4166666626FC6659419A999999825A2B41666666E6FC665941CDCCCCCC075B2B41CDCCCCECEA665941666666663B5B2B419A9999D9DE6659419A9999997D5B2B41000000C0D86659419A999999015C2B4133333313D6665941CDCCCCCC2B5C2B419A9999F9D9665941CDCCCCCC455C2B41333333D3D9665941000000009F5C2B419A999979D36659419A9999994E5C2B4133333313C4665941CDCCCCCC285C2B4133333373B76659419A999999535C2B41333333F3B4665941CDCCCCCCD35D2B4100000040A566594166666666A65E2B41333333F39C66594166666666345E2B419A999959706659419A999999EC5D2B41333333735766594133333333D05D2B41333333534366594166666666335E2B41000000003C6659419A999999545D2B41666666C6E865594166666666135D2B41CDCCCCACF0655941CDCCCCCC925C2B4166666666F9655941000000002F5C2B419A9999990C665941CDCCCCCCEB5B2B4166666666136659419A999999C85B2B4133333333156659419A999999595B2B419A9999B916665941CDCCCCCCF05A2B419A9999591B66594166666666965A2B41CDCCCCAC21665941666666665A5A2B41000000202366594166666666F5592B41666666A62E665941666666668F592B4133333373336659413333333377592B419A9999D938665941CDCCCCCC76592B419A999979476659413333333356592B41CDCCCCAC506659413333333334592B419A999959516659419A999999D1582B419A999999496659413333333387582B410000000048665941CDCCCCCC62582B41666666464A6659413333333347582B41000000605666594100000000F1572B41CDCCCCAC696659416666666690572B41CDCCCC6C73665941CDCCCCCC7F572B41666666C6766659419A99999982572B41666666A67C66594166666666A4572B41666666A6856659419A999999A2572B41000000C08A6659419A99999947572B419A99999995665941CDCCCCCC2D572B419A9999199766594166666666C5562B419A9999B9926659419A99999972562B41333333738B665941CDCCCCCC48562B419A9999B989665941CDCCCCCCD3552B419A9999198C6659419A999999BD552B41666666268A6659413333333397552B41333333F37A6659410000000066552B41CDCCCCCC70665941CDCCCCCC3F552B4100000000606659416666666631552B41333333135D66594133333333DD542B4100000080586659419A9999999A542B41CDCCCC8C5B6659419A99999975542B4166666626636659419A9999991B542B41333333936E66594166666666A1532B410000000075665941333333336D532B41000000007B665941CDCCCCCC37532B41000000A07B665941000000009E522B41CDCCCCEC63665941000000005E522B419A999979636659416666666626522B41CDCCCCCC67665941CDCCCCCCEE512B41CDCCCC8C776659419A999999E7512B41333333F37D665941CDCCCCCCFA512B41333333F391665941CDCCCCCCC5512B41333333F39A6659419A999999F8512B41666666C6AB66594100000000AD522B4100000080EA665941CDCCCCCCD5522B4100000000F1665941CDCCCCCCBB532B419A999959F066594100000000C8532B419A9999D9FD6659419A999999A6532B419A9999590B6759419A99999970532B4100000040106759413333333303532B419A9999991367594100000000DA522B41333333D31567594100000000CC532B419A9999991F6759413333333308542B41333333732267594166666666A6532B41333333532B6759410000000036532B41666666A63A675941CDCCCCCCC3522B419A99995948675941CDCCCCCC80522B41CDCCCC0C5367594133333333BD512B41CDCCCC0C5467594133333333BD512B41CDCCCC0C54675941	01010000206A08000011AB6A04D45C2B410000000097695941	390260000	Z	Augerans	3902600	39026	39	27	8
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	01010000206A08000024BC3481CF302B419A99991954365941	390270000	Z	Augisey	3902700	39027	39	27	9
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	01010000206A08000043B18C43717E2B4166666646DB5D5941	390280000	Z	Aumont	3902800	39028	39	27	8
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	01010000206A08000006E9B658DCC72A4166666646B76C5941	390290000	Z	Aumur	3902900	39029	39	27	9
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	01010000206A080000B632B07535292B41343333B3F4735941	390300000	Z	Authume	3903000	39030	39	27	8
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	01010000206A0800008EF5ACEDAC7F2B4100000090297A5941	390310000	Z	Auxange	3903100	39031	39	27	5
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	01010000206A08000034341553C4052C41333333E3B2265941	390320000	Z	Avignon-lès-Saint-Claude	3903200	39032	39	27	8
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	01010000206A080000E021856CAA122B41666666B6D0625941	390340000	Z	Balaiseaux	3903400	39034	39	27	6
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	01060000206A08000001000000010300000001000000C5000000333333333FCD2A4133333373602B5941000000007BCD2A4166666626732B594100000000A8CD2A419A9999D9852B594166666666AECD2A419A9999B9962B594100000000B2CD2A41000000409F2B5941CDCCCCCC95CD2A4100000040B82B5941666666668ECD2A41CDCCCC2CC12B59416666666683CD2A41000000C0CE2B59413333333391CE2A419A9999F9D02B59416666666654CF2A419A999999CE2B5941CDCCCCCC07D12A4100000060C92B5941CDCCCCCC1CD12A419A999999C92B5941CDCCCCCC34D12A4133333353C92B59419A9999994FD12A41000000E0C72B59410000000079D12A41666666A6C62B594133333333BDD12A4166666666C52B594166666666FBD12A41000000E0C32B59416666666603D22A41CDCCCC2CC42B59419A99999959D22A41CDCCCCACC42B5941CDCCCCCCE2D42A4100000000BF2B59410000000034D62A41333333B3BE2B5941333333339ED92A4100000000BE2B594100000000DBD92A419A9999B9B92B5941CDCCCCCCFCD92A419A999959B72B59413333333305DA2A41666666C6B62B5941333333333BDA2A419A999919B32B5941000000004ADB2A4100000000AD2B5941CDCCCCCCBFDB2A4100000060AA2B5941CDCCCCCCFBDB2A4133333353AA2B5941666666661ADC2A4166666606B32B59413333333325DC2A4100000040BE2B59416666666639DC2A419A9999F9C12B59413333333316DD2A419A999979CF2B594133333333E9DD2A4100000000E22B5941CDCCCCCC43DE2A41000000E0EB2B5941CDCCCCCC7FDE2A41333333D3EB2B59410000000001DF2A41333333B3E12B59419A9999995ADF2A419A999999DC2B5941CDCCCCCCE6DF2A4133333373E12B5941CDCCCCCC85E02A4166666606D62B5941CDCCCCCCADE02A4100000000D62B594166666666EBE02A41666666A6ED2B59416666666678E12A41000000C0FD2B594133333333BFE12A41666666660B2C5941CDCCCCCC05E22A41333333D3122C59419A999999E1E22A4133333393122C5941CDCCCCCC58E32A419A9999F90A2C5941CDCCCCCC8AE32A41CDCCCCAC092C5941CDCCCCCC6BE32A41333333B3FA2B5941CDCCCCCC7EE32A41333333B3EB2B5941CDCCCCCC9BE32A41CDCCCCECDD2B5941CDCCCCCCAEE32A41CDCCCC6CD12B59419A999999CCE32A41666666A6CD2B59419A999999C6E42A4100000020D12B5941333333335CE52A419A9999F9CB2B5941CDCCCCCC40E62A419A999939BA2B59419A999999EAE62A41CDCCCC0CBA2B5941000000003AE72A419A9999B9B32B59416666666689E72A41666666E6AA2B594166666666C5E72A41333333D3AA2B59419A99999965E82A41666666E6B02B59416666666687E92A419A9999D9B12B59419A99999913EA2A4133333333B42B5941CDCCCCCCD0EA2A4100000080AC2B59416666666620EB2A4166666666A72B59416666666684EB2A41CDCCCC8CA82B594100000000CBEB2A419A999979B22B594166666666CBEB2A419A999979B72B59416666666618EC2A41CDCCCC4CAF2B5941666666662EEC2A4133333353AE2B59419A99999946EC2A4133333333AE2B5941333333332FEC2A41666666469F2B5941CDCCCCCC36EB2A419A9999F9622B59416666666695EA2A41CDCCCC6C312B59419A999999A9EA2A41666666C6302B5941CDCCCCCCE7EA2A41CDCCCCAC2B2B59413333333340EB2A41666666C6222B5941CDCCCCCC63EB2A4166666606202B59416666666681EB2A41666666261F2B5941CDCCCCCC7BEB2A41000000A00B2B59419A999999D5EB2A4133333313F32A594166666666E0EB2A41CDCCCC8CE52A594100000000E8EB2A4100000080E42A5941CDCCCCCC21EC2A419A9999F9E22A5941666666665EEC2A41666666C6DF2A594100000000A6EC2A41333333B3DB2A594166666666E2EC2A4133333393D52A594133333333EAEC2A419A999979D32A594166666666ECEC2A4166666686BC2A5941CDCCCCCCE2EC2A4133333333A52A5941CDCCCCCCC9EC2A4100000000A52A59413333333396EC2A419A9999D9A42A59410000000013EC2A419A999939A62A594100000000F7EB2A4100000080A62A594133333333ECEB2A41333333D3A62A59419A99999978EB2A419A9999B9912A59419A99999936EB2A41CDCCCCEC8B2A59419A9999991AEB2A41000000A08D2A59419A999999DDEA2A419A9999598F2A5941CDCCCCCC8FEA2A41666666A68F2A59413333333386EA2A41666666268D2A59416666666670EA2A41000000208C2A5941000000005CEA2A41666666268C2A59410000000043EA2A419A9999398D2A59416666666628EA2A419A9999998C2A59419A999999DBE92A41000000E0872A594100000000CCE92A419A999979872A59416666666628E92A4100000080882A5941CDCCCCCC24E92A419A9999F9802A5941666666660AE92A41000000A0712A594133333333FEE82A41666666466A2A594166666666E8E82A41666666A6632A594166666666DCE82A419A999959602A594100000000C7E82A41000000E05C2A5941666666669AE82A41CDCCCC6C632A59416666666659E82A41666666066B2A59419A99999908E82A4133333313732A59419A999999BFE72A419A9999F9772A59413333333389E72A41666666C67A2A59416666666657E72A41CDCCCC4C7C2A59416666666633E72A41000000207C2A59419A9999990AE72A41666666E67A2A594166666666BCE62A41666666A6772A59410000000090E62A4166666626752A59419A999999EBE52A4100000060712A5941CDCCCCCC7FE52A4100000000702A5941CDCCCCCCE6E42A41333333736D2A5941333333335DE42A41CDCCCCAC6A2A59410000000004E42A41CDCCCCAC682A5941CDCCCCCCB2E32A41333333B3672A5941333333331EE32A4100000080642A5941CDCCCCCC7EE22A41CDCCCC2C622A5941CDCCCCCC3BE22A4166666606622A59413333333321E22A41CDCCCC0C622A5941000000000DE22A41CDCCCC8C632A5941CDCCCCCCF5E12A41666666A6672A5941CDCCCCCCEAE12A4100000040692A5941CDCCCCCCC9E12A41666666865F2A5941CDCCCCCC5FE12A41666666C65E2A59416666666654E12A41333333D35A2A594133333333C3E02A41333333D3572A594166666666B8E02A4166666686592A59419A999999A5E02A41CDCCCC6C5B2A59416666666683E02A41666666265D2A5941CDCCCCCC21E02A4100000080512A5941CDCCCCCCD6DF2A41333333134F2A5941CDCCCCCCD5DF2A41CDCCCC8C592A5941666666669DDF2A4133333333552A5941CDCCCCCC69DF2A419A999939542A5941666666665FDF2A41000000E05D2A59416666666624DF2A41666666865D2A5941CDCCCCCC23DF2A41CDCCCC2C562A594166666666B7DE2A41666666A64C2A594100000000BDDE2A4100000060422A59416666666695DE2A41CDCCCC2C3D2A59419A99999939DD2A41000000203F2A5941333333331BDD2A419A999939392A5941000000009EDC2A41CDCCCC2C3E2A59413333333304DC2A4100000020462A59419A99999942DB2A41CDCCCCCC472A5941333333337DDA2A4166666646522A59419A999999C5D92A41000000005E2A594166666666FBD82A41333333B3682A59413333333302D92A41CDCCCCAC862A594100000000C2D82A4166666606842A594133333333A4D82A41CDCCCC6C832A59419A999999E0D72A41000000A0832A5941CDCCCCCCE3D72A419A999959A22A59410000000015D82A41333333B3B02A594133333333EDD62A4166666606BA2A594100000000E8D62A419A999979B22A59416666666626D62A4133333353B32A59410000000065D52A419A999979A82A5941000000009BD22A41666666C6B42A5941CDCCCCCCA7D12A4100000080D92A59410000000031D12A41CDCCCCACEC2A5941CDCCCCCC93D02A419A999919022B5941CDCCCCCC3BD02A41CDCCCC6C0F2B594100000000C8CF2A419A9999B9202B5941000000007ECF2A4133333333292B59416666666639CF2A41333333532A2B59419A999999EBCE2A41000000202D2B5941CDCCCCCCA0CE2A41333333732E2B59410000000080CE2A41666666C62E2B5941CDCCCCCC61CE2A41CDCCCC0C2F2B59419A9999998ECD2A41000000002C2B5941CDCCCCCC88CD2A41CDCCCCEC2B2B5941333333335BCD2A41CDCCCC8C2B2B5941000000005ECD2A41666666462D2B5941CDCCCCCC60CD2A4166666626302B5941CDCCCCCC5ECD2A4100000020332B5941CDCCCCCC58CD2A419A999999372B59416666666652CD2A41CDCCCC4C3E2B5941333333334DCD2A419A999939482B59410000000048CD2A4166666606542B59413333333345CD2A41CDCCCC4C5B2B5941333333333FCD2A4133333373602B5941	01010000206A080000917FBD2B5DDD2A41CCCCCCFC252B5941	390350000	Z	Balanod	3903500	39035	39	27	5
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	01010000206A08000065064A4780572B416666669686645941	390370000	Z	Bans	3903700	39037	39	27	4
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	01010000206A080000734EC7490AAE2B413333339388355941	390380000	Z	Barésia-sur-l'Ain	3903800	39038	39	27	11
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	01010000206A0800008C1A906BAA972B41000000E004785941	390390000	Z	La Barre	3903900	39039	39	27	3
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	01010000206A080000661E62440EB02B41000000D02D525941	390400000	Z	Barretaine	3904000	39040	39	27	9
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	01010000206A0800009C65EC17018B2B41666666B6E9465941	390410000	Z	Baume-les-Messieurs	3904100	39041	39	27	13
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	01060000206A08000001000000010300000001000000490000006666666645332B419A9999B961725941CDCCCCCC96332B419A99993977725941CDCCCCCC6E342B4133333333AD725941CDCCCCCCC6342B419A999939BE72594166666666F1342B4100000080D2725941CDCCCCCC3F362B4133333353287359419A9999990B372B4133333353607359416666666678372B41CDCCCCCC7B735941333333330F382B41000000C06C7359419A9999998A382B41CDCCCC2C577359419A99999921392B41CDCCCC4C4973594133333333B9392B419A9999594173594100000000373A2B41666666662F73594100000000013B2B41CDCCCCAC0E7359419A999999543B2B41666666E61673594166666666833B2B4166666626147359419A999999DE3C2B41CDCCCC4CEE72594133333333AE3D2B41333333F3E272594100000000143F2B41CDCCCC8CDA725941333333330D412B4133333393D0725941666666664D412B4166666606E172594100000000DF412B4133333333C4725941000000003B412B41333333336D7259416666666676402B4100000020077259410000000059402B41000000C0F2715941CDCCCCCCBF422B419A9999591F72594100000000ED422B41CDCCCCCCE0715941CDCCCCCCF3422B41CDCCCCACCE7159410000000004432B41666666A6BD7159410000000024432B41333333B3917159419A9999993B432B41333333B37E7159419A99999952432B41666666A6637159410000000041432B4100000000587159419A99999906432B41CDCCCC6C4C715941CDCCCCCCD7422B41CDCCCCAC477159416666666663422B41CDCCCCEC4071594133333333B8412B41000000603C715941CDCCCCCCF7402B419A999959367159419A99999927402B41000000202D71594133333333093F2B41000000A01C71594166666666563E2B41333333B30E715941CDCCCCCCE23D2B419A9999B9037159419A999999833D2B419A999979F770594133333333CA3C2B4100000000E4705941000000002F3C2B4166666606D57059419A999999513B2B4166666646C17059419A999999F53A2B4133333353BA70594166666666283A2B419A999999D270594166666666E7392B419A999999D7705941CDCCCCCCBA392B419A9999D9E070594100000000F6372B41CDCCCCCC187159419A9999992F372B419A9999192F7159410000000085362B419A9999993F71594133333333AB352B41CDCCCC8C517159419A999999E3342B41333333F35E715941CDCCCCCC11352B41333333336271594133333333EE352B41CDCCCCCC7B7159419A9999990E362B413333339382715941CDCCCCCC1C372B41CDCCCC2CAE715941333333334B372B4133333333B9715941CDCCCCCCFA352B41CDCCCC0CE071594100000000C0362B41666666E6037259413333333336362B41CDCCCC4C0A7259419A99999918362B41333333130E7259419A99999926342B419A9999592672594166666666E0332B41CDCCCCEC2372594100000000F7332B41333333333F725941333333334A342B41333333B34F725941666666666C342B41666666066272594166666666DD332B4100000020537259419A9999997C332B41666666265A7259416666666645332B419A9999B9617259416666666645332B419A9999B961725941	01010000206A08000068153998CB3A2B41333333231C725941	390420000	Z	Baverans	3904200	39042	39	27	3
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	01060000206A080000010000000103000000010000006E010000CDCCCCCC31F52A4100000000E93B59416666666638F52A4166666666163C59419A9999997CF62A41000000A0403C594133333333BBF62A419A999919453C594166666666EBF62A41333333D34D3C594166666666EFF62A41CDCCCC2C533C5941CDCCCCCC23F72A419A9999995C3C59419A9999996AF72A419A999979583C59419A9999996DF72A4133333373553C59419A9999998FF72A419A9999F9543C594133333333C7F72A41333333B3593C594166666666E6F72A41000000405E3C59419A999999E0F72A41333333B3643C59416666666610F82A41CDCCCCEC6A3C59410000000026F82A41CDCCCCCC6A3C5941CDCCCCCC55F82A4133333313633C5941CDCCCCCCCEF82A419A9999D9663C5941CDCCCCCC05F92A41666666E6633C59413333333356F92A41333333F3623C59410000000087F92A4100000020613C594100000000A4F92A41333333B3623C594133333333BCF92A4100000080683C59410000000002FA2A419A9999D9673C5941CDCCCCCC34FA2A41000000606F3C59413333333396FA2A41666666A6713C59419A999999C8FA2A41333333937B3C59419A9999992CFB2A41000000407E3C59413333333394FB2A4100000000773C594166666666D7FB2A4166666666753C5941CDCCCCCCF3FB2A4100000040723C5941CDCCCCCC15FC2A4166666606723C59419A99999933FC2A419A999979793C5941CDCCCCCC78FC2A4166666646793C59410000000091FC2A41CDCCCC6C753C594100000000B9FC2A4166666646733C5941CDCCCCCC97FC2A41666666E66B3C5941CDCCCCCCC0FC2A41000000406C3C59410000000009FD2A419A999979743C59416666666614FD2A41666666867F3C5941666666663FFD2A419A9999197F3C59413333333371FD2A419A9999F9813C5941CDCCCCCCA0FD2A4100000080823C59419A999999BBFD2A41333333D3873C5941CDCCCCCCE7FD2A41CDCCCC2C893C5941CDCCCCCCBFFE2A41000000C0843C594166666666E3FE2A4133333373853C594166666666B4FF2A4133333393813C594133333333E1FF2A41000000A0813C594133333333F7FF2A41666666867B3C5941333333332E002B41000000807F3C59419A999999B2002B41CDCCCCCC843C5941CDCCCCCC21012B41333333D38A3C59413333333361012B41CDCCCC4C903C5941666666669A012B4100000020893C59419A999999FC012B41000000E07F3C594166666666B9022B419A9999D9713C59413333333305032B41000000A0693C5941CDCCCCCC56032B41000000806F3C59416666666681032B4166666626783C59419A999999AB032B41CDCCCC6C7A3C594166666666EE032B419A999919773C59413333333327042B41666666667B3C5941CDCCCCCC58042B4166666686823C59410000000083042B4100000000843C59419A999999B3042B4100000020833C5941CDCCCCCCF4042B419A9999797F3C5941CDCCCCCC11052B41333333137C3C59419A999999C1052B41000000A07F3C59419A99999931062B4166666626753C59419A9999994D062B41CDCCCCCC703C59419A9999994F062B419A9999196B3C59419A9999998B062B41000000206B3C594133333333A3062B4166666626673C5941000000008D062B41666666A65E3C5941CDCCCCCCAF062B41666666E65B3C59419A999999DA062B419A9999995B3C59419A999999F4062B41CDCCCCCC573C59419A999999E2062B41CDCCCCEC543C5941CDCCCCCCE4062B41333333134B3C59410000000009072B4166666646443C59416666666622072B41666666C6423C59419A99999935072B41CDCCCC8C3D3C59410000000000072B4100000040383C59413333333304072B41CDCCCCAC333C5941666666666B072B419A999979313C59419A99999968072B419A999999283C5941666666669F072B41000000E01E3C5941CDCCCCCCDB072B41CDCCCC6C1A3C5941666666660C082B41CDCCCCAC193C5941666666662F082B419A9999F9143C59419A9999992F082B4133333313103C594133333333260A2B41000000E0F33B5941CDCCCCCCC10A2B41333333F3EB3B594133333333E00B2B41666666A6D63B5941CDCCCCCC330C2B41666666C6D43B59419A9999994F0C2B41000000C0D93B5941000000009E0C2B4166666686D33B594100000000800C2B41000000C0C33B594166666666250D2B41666666C6BA3B59419A999999680D2B41CDCCCC6CC53B594133333333880D2B419A999939C73B5941CDCCCCCCCE0D2B4100000080BF3B594166666666D80D2B4100000080BC3B59419A9999991D0E2B4133333373B63B5941CDCCCCCC3F0E2B419A9999B9B03B594100000000650E2B419A999939AE3B594166666666AE0E2B4100000020AC3B5941000000002A0F2B4166666666AA3B594100000000BE0E2B41CDCCCCCCA43B5941CDCCCCCCA20E2B4100000080A03B59419A999999860E2B41666666268E3B59419A999999370E2B419A9999B9673B5941CDCCCCCC060E2B4100000060683B59419A999999DE0D2B41000000605A3B594100000000A90D2B419A9999195C3B5941333333339F0D2B4100000080583B5941666666664D0D2B4100000000483B5941333333333E0D2B41CDCCCC8C3B3B594133333333FA0C2B41666666061E3B59419A999999B20C2B4133333333033B594166666666900C2B419A9999B9F23A594166666666AB0D2B4100000020E83A594166666666C20D2B41333333D3EE3A59419A999999B70F2B4100000000CB3A5941CDCCCCCC5D0F2B41CDCCCC0CBD3A594100000000950F2B419A999959A83A594100000000EC0F2B419A9999198F3A594133333333B90F2B4166666606853A5941333333333C0F2B4100000060473A59419A999999650F2B41CDCCCC2C3B3A5941333333334A0F2B419A9999F92E3A594166666666790E2B41333333F33C3A5941666666665B0E2B419A9999B93B3A594133333333320E2B41666666862B3A594100000000030F2B41333333531C3A5941333333333B0F2B41333333F3243A5941CDCCCCCC80112B41666666E6033A59419A999999DA112B41CDCCCC4C013A59410000000017122B419A9999B9083A59410000000099122B419A999999083A59416666666606132B419A999939023A59419A99999905132B41000000C0F5395941333333336C132B419A9999F9F3395941CDCCCCCC9B132B4166666666FE39594166666666D0132B419A999999F53959416666666665142B4100000000EB3959419A9999996B142B419A999959E3395941CDCCCCCCED152B41CDCCCCECBE3959419A99999932162B41CDCCCC8CC13959419A9999995F172B419A9999D9AA39594166666666AF172B41666666C6AA3959416666666654192B41CDCCCCAC903959416666666693192B41333333D39D39594166666666CE192B41333333D3A239594133333333C7192B41000000609C395941333333337B192B41000000A0883959419A999999A9192B41000000A08439594133333333D3192B41333333939139594166666666321A2B419A9999198839594100000000FF192B419A9999B976395941000000005D1A2B41333333D371395941CDCCCCCC6A1B2B41CDCCCC8C713959419A999999EB1B2B41000000006B395941333333336D1C2B41666666465D39594133333333301C2B419A9999594E39594100000000301C2B41000000E04B39594166666666A71C2B410000004044395941CDCCCCCCC41C2B419A9999793B3959419A999999541E2B41CDCCCCAC2C395941CDCCCCCC311E2B41CDCCCC4C1B395941000000004E1E2B41CDCCCC4C1539594100000000641E2B4133333353FB38594166666666521E2B419A9999B9E538594100000000081E2B41CDCCCC6CCE38594133333333FC1D2B419A999939C33859419A999999FB1D2B4100000040B938594100000000371E2B41CDCCCC6CB038594133333333E01E2B41000000C0A838594133333333251F2B41333333F39A38594100000000751F2B419A9999199738594100000000BB1F2B4166666646983859416666666629202B41666666A69F385941CDCCCCCCF1202B4133333333A83859419A9999997D212B41CDCCCC0CA8385941CDCCCCCC44222B41333333139F385941CDCCCCCCE3222B41CDCCCC6C923859419A99999978232B41666666C68038594166666666E6242B41CDCCCC2C483859419A9999995B252B4133333393223859419A9999995A252B419A999959123859419A99999926252B41CDCCCCACF5375941CDCCCCCCA2242B419A999919D9375941333333338E242B4100000060D03759416666666697242B41000000E0C337594166666666B4242B419A999959B73759416666666646242B419A999939B6375941CDCCCCCCEC232B41CDCCCCCCB8375941CDCCCCCC92232B4166666626BA375941CDCCCCCC6A232B41333333F3B83759410000000057212B41CDCCCCCC973759419A9999994C212B41333333D3923759410000000026212B41333333B38B3759419A99999948202B419A999939693759410000000026202B41333333F3643759419A99999918202B419A9999D95C37594100000000F51F2B419A9999795837594166666666041F2B410000006043375941CDCCCCCCD41E2B41CDCCCC4C41375941000000002A1E2B41000000A03337594100000000F81D2B41CDCCCC0C2B375941666666669A1D2B41000000401E37594133333333711D2B419A9999B91A375941333333339F1C2B41333333B305375941CDCCCCCC481C2B419A999939F836594133333333E71B2B41000000A0EE3659419A9999998D1B2B4166666646DF3659419A999999251B2B41666666A6C8365941CDCCCCCC181A2B419A9999B9B236594166666666D1192B41333333D39E365941666666666D192B4166666626923659419A99999989182B41666666C67D365941CDCCCCCC23182B41CDCCCC6C6F365941CDCCCCCCB6172B419A99993967365941000000007B172B41CDCCCC0C5E36594100000000A8162B41666666A6413659419A99999978162B410000004032365941333333339E152B41CDCCCCCC4436594133333333B3142B41000000405D3659413333333367142B4100000080663659410000000011142B4133333373693659419A9999995E132B419A99991980365941CDCCCCCC6F112B4133333353C536594133333333D1102B4100000040D836594133333333C50F2B4100000040F036594166666666300F2B41666666E601375941CDCCCCCC070E2B41333333332F37594133333333240E2B4133333333443759419A999999240D2B416666662656375941CDCCCCCC5E0C2B419A9999D971375941CDCCCCCCFA0B2B41333333F3713759419A9999999C0A2B413333339369375941CDCCCCCC880A2B419A9999196C37594133333333470A2B41666666668F375941CDCCCCCCFE092B419A9999F9883759419A999999A6092B41CDCCCC4CA33759413333333397092B41CDCCCC4CAA37594166666666F2082B41333333739F375941CDCCCCCCD2082B4100000020A037594100000000A2082B4133333313A837594100000000BB082B4166666666AA375941333333334E082B4100000080BB375941CDCCCCCC30082B41CDCCCC6CBE3759419A99999981082B4100000080C4375941CDCCCCCC78072B41333333B3D437594166666666FF062B419A999999B63759419A99999969062B41000000A0A1375941000000001B062B4133333353A53759413333333365062B41CDCCCCACBC3759419A9999996D042B41000000A0EB37594100000000F3042B41333333F305385941666666663A052B41CDCCCCCC113859419A999999CD042B4166666686173859419A9999996A042B4100000020243859410000000072032B41000000E035385941000000000F032B419A9999794238594166666666A3022B4133333313633859419A999999C4012B419A99995980385941333333339C012B41333333938A385941333333333D012B41000000C09E3859413333333312012B41000000A0A5385941CDCCCCCC94002B41CDCCCCECC93859419A9999997E002B41CDCCCC8CD43859419A9999996F002B419A9999D9E1385941333333336E002B41CDCCCC4CEA385941CDCCCCCC40002B41CDCCCCECFC385941CDCCCCCC1E002B4166666626063959419A99999904002B41CDCCCCAC093959419A99999974FF2A41000000600D3959413333333301FF2A41333333730D395941CDCCCCCCE5FE2A419A9999990F3959419A999999B6FE2A419A9999F9163959419A9999996DFE2A419A9999590A3959416666666690FD2A41333333B30D395941000000006FFD2A41CDCCCC2C03395941CDCCCCCC23FD2A4100000080FA385941CDCCCCCCF1FC2A41333333D30939594166666666B9FC2A41000000800D3959419A999999B0FC2A4133333393053959419A99999996FC2A4100000060FB3859410000000028FC2A41000000C0EB38594133333333B5FB2A41666666E6E73859419A9999997DFB2A4133333313F43859416666666669FB2A41CDCCCC8CFB3859419A99999976FB2A4166666626103959416666666678FB2A4100000020293959413333333365FB2A4166666666343959416666666652FB2A41666666A6443959416666666667FB2A419A9999D95439594166666666A4FB2A41666666C66339594166666666C3FB2A41000000007439594133333333BAFB2A41000000407F3959419A9999994DFB2A419A9999D9903959413333333345FB2A41CDCCCC4C96395941666666665AFB2A4166666666A23959410000000084FB2A41666666E6AF39594100000000CFFB2A41000000A0D239594166666666D5FB2A41000000E0E639594100000000FEFB2A4133333313F23959416666666630FC2A41666666C6F53959413333333381FC2A41CDCCCC6C033A59410000000096FC2A41666666E60F3A59419A999999BEFC2A41333333D3193A59413333333366FE2A4133333393513A59416666666685FE2A41CDCCCC4C643A59413333333314FF2A419A9999598D3A59419A99999946FF2A41CDCCCC0C963A594100000000FBFF2A419A9999599D3A59413333333323002B41CDCCCC0CA13A5941CDCCCCCC24002B4166666686B73A59419A999999F3FF2A4133333313C43A594133333333F4FF2A41CDCCCCCCCC3A59416666666657002B41CDCCCCACDC3A59410000000059002B4166666666F93A5941666666667DFF2A41333333B3003B594100000000C1FE2A41666666260F3B59419A999999C9FD2A41333333731F3B594166666666C6FC2A4166666626233B594133333333FBFC2A41666666662F3B5941CDCCCCCC35FD2A41CDCCCC8C3A3B594133333333FEFC2A419A9999394D3B59419A99999900FD2A41333333B35F3B59416666666615FD2A41CDCCCC2C703B59410000000036FD2A41CDCCCCEC813B5941666666660FFD2A419A999979853B59410000000031FC2A41CDCCCCAC883B59419A99999920FC2A41CDCCCCEC923B59419A999999F1FB2A4166666626993B594133333333C2FB2A4133333393A23B59410000000053FB2A41CDCCCCCC9D3B59419A99999941FB2A4166666646B63B59419A99999930FB2A41666666E6B93B5941CDCCCCCC05FB2A4100000040BB3B594133333333ABFA2A41CDCCCC2CB83B5941000000001FFA2A41000000C0BE3B59419A999999CAF92A4100000000C83B59413333333322FA2A4133333373DD3B5941CDCCCCCC2CFA2A41CDCCCC2CE63B5941CDCCCCCC23FA2A41CDCCCCECF33B5941CDCCCCCCF2F92A41333333B3013C594100000000E9F92A41000000E0063C594100000000ADF92A41000000A00D3C5941CDCCCCCC90F92A41CDCCCCEC0C3C59413333333326F92A419A9999B9FD3B594133333333FAF82A4100000020F93B5941CDCCCCCCACF82A419A9999D9F63B5941333333335CF82A41CDCCCC8CEF3B5941333333331EF82A4133333373F13B5941CDCCCCCCF3F72A4133333313F13B5941CDCCCCCCD5F72A41CDCCCC4CEE3B59413333333385F72A4166666626E33B59419A99999920F72A4166666686DA3B5941666666668AF62A41CDCCCCACD53B59419A9999993AF62A4166666606D73B59419A99999993F52A41CDCCCCACE43B5941CDCCCCCC31F52A4100000000E93B5941CDCCCCCC31F52A4100000000E93B5941	01010000206A080000641B9BB4EF0B2B41CCCCCC6C62395941	390430000	Z	Beaufort-Orbagna	3904300	39043	39	27	17
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	01010000206A08000008E66982FE512B419A999959C0335941	390450000	Z	Beffia	3904500	39045	39	27	5
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	01010000206A080000265977AF922F2C4166666606D01C5941	390460000	Z	Bellecombe	3904600	39046	39	27	12
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	01010000206A0800000201974717942C41000000A024385941	390470000	Z	Bellefontaine	3904700	39047	39	27	24
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	01060000206A08000001000000010300000001000000DC0000009A99999958582B41000000A029675941666666668F582B41000000C04467594166666666A7582B41CDCCCCEC486759419A99999944592B416666664658675941666666663E5A2B41666666267D6759419A999999D4592B41000000A0896759419A999999965A2B4133333353C667594166666666C85A2B4166666646C667594133333333DC5A2B41000000C0C367594166666666185B2B41CDCCCC2CC6675941000000009B5B2B4166666646D16759419A999999EC5B2B41CDCCCCACE767594133333333015C2B4166666666F067594166666666E35B2B41CDCCCCECF2675941333333336B5B2B4133333393F06759419A9999996B5B2B41CDCCCC4CF467594133333333A75B2B41333333530568594100000000AF5B2B41CDCCCCEC0A68594133333333BA5C2B41666666E67E685941CDCCCCCCCF5C2B41333333B38A68594100000000185D2B41CDCCCC2C9F685941CDCCCCCC845D2B4166666606B4685941666666665E5E2B4133333353D4685941CDCCCCCC545E2B41333333D3DB68594166666666235E2B41000000A0E4685941666666668E5D2B4166666646F1685941CDCCCCCC705D2B41CDCCCC4CF668594133333333AD5D2B419A999939FB685941CDCCCCCC115E2B410000002005695941CDCCCCCC625E2B41666666061469594166666666365F2B41666666462F6959419A99999913602B41666666064369594133333333DD602B41666666C65B695941000000002D612B41333333B35B695941666666663A622B41CDCCCC2C556959419A999999DD632B419A9999394D695941CDCCCCCC40642B41000000204369594133333333EA642B41333333B33C6959419A99999989652B419A9999793C69594133333333AD652B41000000A03E695941CDCCCCCCAF652B419A9999B9446959419A9999995A652B41000000405E6959419A999999D2642B419A999979886959410000000020642B41CDCCCCCCC16959419A99999967632B41CDCCCC8CFA695941333333331E632B41CDCCCC4C126A59416666666643622B41CDCCCCCC556A59419A9999994E612B4166666606A36A594100000000CF602B419A999999CA6A59413333333346602B4133333313F46A5941CDCCCCCC09602B4166666646076B5941000000001D5F2B419A9999F94F6B5941CDCCCCCC695E2B41CDCCCC6C866B5941CDCCCCCC135E2B4166666666A16B594166666666AB5D2B41333333F3C86B5941CDCCCCCC465D2B41000000C0E66B594133333333DC5C2B419A9999F90B6C59419A999999B75C2B419A9999F9166C594133333333985C2B41CDCCCC2C196C594100000000805C2B41333333931E6C5941CDCCCCCC6F5C2B41CDCCCCCC286C5941000000006A5C2B41333333F3336C594166666666155C2B41333333333C6C59419A999999FC5B2B4100000040476C59419A999999C45B2B4100000000576C5941333333331A5B2B41333333D38C6C5941000000008A5A2B419A999919B76C594100000000795A2B4166666646BB6C594100000000EA592B4133333353E96C59419A9999996D592B419A9999190E6D594166666666C1582B41666666E6416D594133333333B6582B4100000020466D5941CDCCCCCC325A2B4166666626576D594166666666C55A2B41000000605E6D594133333333315B2B41000000C0626D59419A999999D75C2B41CDCCCC8C766D5941CDCCCCCC9B5D2B41666666267F6D594133333333D75F2B41000000A0996D5941666666661C612B4133333313A86D594166666666C6622B4133333313BC6D59419A9999997B652B41666666A6DB6D5941000000006C662B4133333353E76D59413333333392662B41CDCCCC6CD66D59419A999999AA662B4100000080D16D5941333333338D672B4100000020876D59419A9999999E682B41666666662A6D59410000000014692B41CDCCCC0C066D59416666666627692B41CDCCCC8CFE6C594166666666A3692B41CDCCCCACD56C594133333333BB692B41CDCCCCECC86C59419A999999136A2B41CDCCCC0CAB6C594166666666856A2B419A999999866C5941CDCCCCCC846B2B41CDCCCCCC2F6C594166666666936B2B41000000A0296C594133333333186B2B41666666C60A6C5941CDCCCCCCE26A2B419A999919FA6B59419A999999526A2B419A999939D46B5941000000006A6B2B4133333393BA6B5941000000003D6D2B41CDCCCC2CA76B594100000000476D2B41CDCCCCECA56B594133333333A16D2B41000000007F6B5941CDCCCCCCBD6D2B41000000A0796B594100000000616E2B41CDCCCCAC426B5941333333338E6F2B4133333313DA6A59413333333337712B4100000080486A59419A999999FB722B41000000C0B26959410000000095742B419A9999192F6959419A999999AF742B41000000802369594166666666DA742B41333333B315695941CDCCCCCCF5742B41000000600969594166666666FE752B41CDCCCC0CAF68594133333333E5752B419A9999B9A968594133333333D5752B41CDCCCCEC9C6859416666666695752B41333333539E685941333333336D752B419A9999599C6859416666666657752B41333333B3A1685941666666660D752B41666666E69C6859419A99999986742B4166666626986859410000000023742B41666666868F685941CDCCCCCC26742B41333333738868594100000000F9732B41333333F38A68594100000000BD732B41000000008B685941333333339F732B419A999979876859410000000063732B41CDCCCC2C8F68594100000000AE722B41CDCCCCEC93685941CDCCCCCC04722B41666666069668594166666666C4712B41000000A0916859419A99999981712B41666666668A68594100000000E9702B41000000808D6859419A99999903712B41666666E6906859416666666663702B4166666626946859419A9999993B702B41000000A085685941000000000A702B419A9999D95F6859419A999999F66F2B41000000E021685941333333331A702B4133333353FB67594166666666E56F2B41CDCCCC8CF867594166666666AB6F2B41333333D3F267594166666666DC6F2B419A9999D9DD675941CDCCCCCC43702B4133333313D56759416666666675702B41000000E0C46759410000000041702B41666666C6C1675941CDCCCCCC4A702B4100000060B26759419A999999A9702B419A999979B36759410000000096702B419A999939AA6759410000000037702B419A9999598C67594133333333EC6F2B4133333393826759419A999999A36F2B41333333537D6759419A9999992A702B41CDCCCCAC76675941666666669F702B419A9999B978675941333333339A702B41666666A6706759416666666678702B413333333367675941000000004A702B41333333335E67594166666666DC6F2B41CDCCCC2C4E6759419A999999E26E2B41CDCCCC2C456759419A999999B46E2B41000000E041675941666666668C6E2B41CDCCCC2C376759419A9999997C6E2B419A9999B92C675941CDCCCCCC4E6E2B41000000401967594100000000F46D2B413333331314675941000000008A6D2B41666666861767594100000000D66C2B4100000020226759419A999999746C2B419A99995924675941333333333A6C2B416666662622675941CDCCCCCCE76B2B41000000001D675941CDCCCCCCBB6B2B41CDCCCC2C1D6759419A999999116B2B419A9999192B6759419A999999A96A2B419A9999D91A6759419A9999995F6A2B410000006018675941666666664C6A2B41000000401567594166666666026A2B41666666661067594166666666D8692B41000000E0036759419A9999996E692B41333333D3FA66594100000000EE682B41000000E0F86659413333333393682B419A9999F9EE6659410000000032682B41333333F3E76659419A9999990A682B41000000A0E266594133333333A2672B4100000060D0665941CDCCCCCC5F662B419A99993996665941333333330D662B41333333D386665941CDCCCCCCF6652B419A9999598566594100000000EF652B41666666C67F66594133333333C9652B419A999959756659419A99999995652B4133333393626659410000000091652B419A99991955665941000000007E652B41000000604E665941CDCCCCCC4C652B410000008043665941666666660A652B4100000080306659419A999999CB642B419A999979136659413333333348642B41CDCCCCCC176659419A999999A5632B41333333F3E56559413333333301632B419A999959EE6559419A99999909612B41666666E6086659416666666679602B419A9999391066594166666666D55F2B41333333531966594166666666A65E2B419A9999B931665941333333332D5E2B419A9999993C66594133333333D05D2B4133333353436659419A999999EC5D2B41333333735766594166666666345E2B419A9999597066594166666666A65E2B41333333F39C665941CDCCCCCCD35D2B4100000040A56659419A999999535C2B41333333F3B4665941CDCCCCCC285C2B4133333373B76659419A9999994E5C2B4133333313C4665941000000009F5C2B419A999979D3665941CDCCCCCC455C2B41333333D3D9665941CDCCCCCC2B5C2B419A9999F9D96659419A999999015C2B4133333313D66659419A9999997D5B2B41000000C0D8665941666666663B5B2B419A9999D9DE665941CDCCCCCC075B2B41CDCCCCECEA6659419A999999825A2B41666666E6FC66594100000000635A2B4166666626FC6659416666666676592B41CDCCCC8CFE6659413333333332592B41333333F30067594166666666C3582B41000000600B675941CDCCCCCC9C582B4166666606126759416666666667582B419A999999216759419A99999958582B41000000A0296759419A99999958582B41000000A029675941	01010000206A080000977E6DC5FB6A2B4100000030E9695941	390480000	Z	Belmont	3904800	39048	39	27	16
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	01010000206A0800005DD665ED88642B410000002093575941	390490000	Z	Bersaillin	3904900	39049	39	27	14
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	01010000206A08000046BD003CEEDF2B41666666C6F64F5941	390500000	Z	Besain	3905000	39050	39	27	13
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	01010000206A080000CC5A2FD53D092B419A99994918765941	390510000	Z	Biarne	3905100	39051	39	27	6
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	01010000206A0800005066475EA87A2C410000000087475941	390520000	Z	Bief-des-Maisons	3905200	39052	39	27	6
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	01060000206A08000001000000010300000001000000CA00000033333333C98E2C41333333B304545941CDCCCCCC498F2C419A99997919545941CDCCCCCC998F2C41666666A61E545941CDCCCCCC918F2C41666666E633545941666666669B902C41000000003654594133333333DB902C419A9999F92A5459419A99999945912C419A9999392E545941CDCCCCCC4F912C41CDCCCCEC37545941CDCCCCCCE5902C41666666463A5459416666666661902C419A9999594454594100000000F68F2C41CDCCCC6C48545941666666666F912C41CDCCCCAC9D5459410000000063912C4100000000A2545941000000004F912C4166666626B25459413333333332912C4100000040D2545941333333330F912C419A999939E35459416666666611912C419A999999EA5459410000000048912C419A9999D9FA5459419A99999962912C41CDCCCC0C05555941666666666F912C41333333F31355594100000000F1902C419A999939