SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep40;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep40 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep40','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep40','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep40','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep40"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000DFDC828CED8D1A41000000A083005841	400010101	H	Rive Gauche	4000101	40001	40	75	34
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	01010000206A080000C6CC8FAFFCC71A41666666969F055841	400010102	H	Rive Droite	4000101	40001	40	75	24
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	01010000206A08000004F3DBF6014518413433337392F85741	400020000	Z	Amou	4000200	40002	40	75	27
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	01010000206A0800006DC16F4FB55016416666663611075841	400030000	Z	Angoumé	4000300	40003	40	75	8
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	01010000206A080000808329323F43154133333353B5025841	400040000	Z	Angresse	4000400	40004	40	75	8
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	01010000206A08000038AC7DC3CBC61941CDCCCCBC5BF95741	400050000	Z	Arboucave	4000500	40005	40	75	10
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	01010000206A08000013F775A36E3818413333334381285841	400060000	Z	Arengosse	4000600	40006	40	75	63
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	01010000206A080000709B0B3719DE18419A99993943F75741	400070000	Z	Argelos	4000700	40007	40	75	7
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	01010000206A080000F9D4F92A29131941000000F01A4D5841	400080000	Z	Argelouse	4000800	40008	40	75	23
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	01010000206A080000DE7102DC5F0B1841CDCCCC6CD7F75741	400110000	Z	Arsague	4001100	40011	40	75	7
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	01010000206A080000B09038729E0E1A41CDCCCC2C2E135841	400120000	Z	Artassenx	4001200	40012	40	75	5
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	01060000206A080000010000000103000000010000000402000033333333E3A01A41CDCCCC8C5C18584166666666F0A01A41333333D361185841CDCCCCCC88A11A41CDCCCC0C6418584100000000E0A11A419A9999F961185841666666661EA21A4100000040631858410000000022A21A41CDCCCCAC681858416666666694A11A41000000A06F1858416666666666A11A41333333B3771858410000000012A11A41666666267D1858413333333301A11A41CDCCCC0C841858419A999999ABA11A419A9999398918584166666666B4A11A4100000040901858416666666662A11A41666666C692185841CDCCCCCC24A11A410000008098185841CDCCCCCC68A11A41CDCCCCEC9E185841CDCCCCCCAEA11A419A9999999F1858410000000026A21A41666666469A1858419A999999B1A21A4133333353991858413333333307A31A419A9999199D18584100000000F6A21A4133333333A11858413333333381A21A41333333F3A51858416666666670A21A4133333373A81858416666666694A21A419A999959B11858410000000000A31A4166666666B1185841CDCCCCCCB2A31A41CDCCCCACAD185841CDCCCCCC0CA41A4166666666A418584166666666CAA41A41666666E6A218584133333333D3A51A41666666C6A51858419A99999939A71A41CDCCCCECA3185841333333339DA71A419A999999A4185841333333334BA81A41000000C09E18584133333333B7A81A41333333939D18584100000000F8A91A419A9999B9A0185841CDCCCCCC4EAA1A4100000000A318584100000000C2AA1A41CDCCCC2CAA18584133333333DFAA1A41333333D3B618584166666666E4AA1A41CDCCCC0CC21858416666666604AB1A419A999959D2185841000000003EAB1A4133333333E21858416666666644AB1A4166666686F01858419A9999996DAB1A419A9999B9F7185841666666662CAC1A41333333B305195841333333336FAC1A410000004011195841CDCCCCCCCCAC1A419A9999791B195841333333331BAD1A41CDCCCC2C1F19584133333333B5AD1A419A9999591E1958416666666662AE1A41CDCCCC0C131958419A999999DFAE1A419A999979101958419A9999998DAF1A413333337311195841666666661CB01A41CDCCCC2C0D19584166666666E6B01A41CDCCCC4C0C1958410000000062B11A41000000E01219584133333333B9B11A41000000A0231958410000000028B11A41333333F32919584166666666E4B01A419A9999792919584166666666F0AF1A41000000A02419584100000000D4AF1A419A9999B926195841CDCCCCCCD6AF1A41000000402E1958419A999999F5AF1A4166666646371958416666666674AF1A419A9999B93E1958410000000032AF1A410000002054195841CDCCCCCC3AAE1A419A9999D95A1958410000000030AE1A413333331361195841CDCCCCCC50AE1A419A9999D9681958413333333363AE1A41CDCCCCCC78195841333333333FAE1A41CDCCCCEC85195841CDCCCCCCF8AD1A41CDCCCCEC891958416666666650AD1A41333333D38D1958410000000024AD1A419A9999F98A19584166666666FAAC1A41666666E68219584133333333BBAC1A41333333F37B1958416666666604AC1A41666666667719584133333333A7AB1A41CDCCCC8C79195841CDCCCCCC74AB1A419A9999D97E195841CDCCCCCC76AA1A41000000A08B1958416666666664AA1A41666666C692195841333333337DAA1A41CDCCCC6C9C1958419A999999FFAA1A4166666686A51958419A99999965AB1A419A999979A81958419A9999997FAB1A4133333393B01958419A9999992BAB1A4133333333B81958413333333321AB1A4166666666BE19584166666666A0AB1A41CDCCCC8CC919584100000000BEAB1A4166666686CE19584133333333E5AB1A4100000060DD19584100000000E4AB1A41666666E6E8195841CDCCCCCCF8AB1A41CDCCCC4CED1958419A99999979AB1A4133333393EF195841CDCCCCCCBCAA1A41CDCCCCCCF5195841666666665EAA1A41CDCCCC6CFB19584166666666E2A91A4133333373001A58419A999999ABA91A419A9999B9041A58410000000080A91A419A9999390C1A584133333333D3A91A41666666061C1A5841CDCCCCCCD4A91A4133333333291A58419A9999990BAA1A41000000203A1A58413333333329AA1A41000000604A1A5841666666660EAA1A41CDCCCCCC501A5841CDCCCCCC22AA1A4133333333551A584100000000DEAA1A4100000040671A5841CDCCCCCCCEAB1A41666666867A1A584133333333FDAB1A419A999939861A58419A999999D9AB1A41CDCCCC8C931A58416666666608AC1A41000000409F1A58410000000054AC1A41666666C6A51A5841CDCCCCCCA0AC1A419A999979B21A5841CDCCCCCC9CAC1A419A9999B9BD1A5841CDCCCCCCC2AC1A41CDCCCC2CBF1A584100000000F2AC1A41CDCCCCACB51A5841666666665EAD1A4100000080AA1A58410000000058AD1A419A9999D9A01A58413333333325AD1A41CDCCCC8C991A584166666666C8AC1A41666666E6941A584100000000CCAC1A41000000E08D1A584133333333A7AC1A4166666646801A5841CDCCCCCCBCAC1A41333333D37A1A5841CDCCCCCC38AD1A41CDCCCC6C721A58413333333383AD1A41000000A06F1A5841CDCCCCCCBCAD1A419A999979711A58419A999999D9AD1A419A9999F9791A5841666666663AAE1A41CDCCCC4C781A5841CDCCCCCC7CAE1A4133333313701A584100000000F2AE1A41666666C66C1A5841333333337BAF1A41CDCCCC8C6F1A58419A99999901B01A41CDCCCC6C6C1A58410000000076B01A41CDCCCC4C641A58416666666660B01A419A9999D9561A5841CDCCCCCCB0B01A41000000E04E1A5841CDCCCCCC62B01A41333333B34B1A584166666666DCAF1A419A999999501A5841333333337BAF1A41666666E64E1A58416666666670AF1A41CDCCCC0C491A584100000000E0AF1A41333333B3421A58419A999999EFAF1A41666666263D1A58419A999999A1B01A419A9999193A1A5841333333339DB11A419A9999F9361A58419A999999BFB11A41666666C6321A5841000000006AB11A419A9999B91F1A58416666666670B11A419A9999B9191A58419A999999ABB11A419A9999B9161A58419A99999907B21A41333333330D1A5841000000001EB21A4100000040FD1958419A99999935B21A419A9999D9F91958419A99999993B21A41666666C6F619584133333333EBB21A41CDCCCCECF61958410000000076B31A41CDCCCC2CFA1958410000000040B41A4100000060FA195841CDCCCCCCDCB41A4166666686F7195841333333332FB51A4133333313F319584166666666FEB51A41333333B3E3195841333333331BB61A41000000E0DC1958419A999999F3B51A419A999939CD1958413333333389B51A41000000A0C5195841CDCCCCCCC2B51A4133333353BE1958416666666672B61A41333333B3BB19584133333333DDB61A41CDCCCCECBB195841333333337FB81A4100000040AD1958410000000096B81A4133333353A6195841666666665AB81A4133333373A2195841333333339FB71A41666666869B19584166666666CAB61A41000000009A1958416666666686B61A4166666686981958410000000068B61A41666666C68E195841333333337DB61A41000000E08719584100000000B2B61A41333333F383195841666666667AB71A41CDCCCC8C8219584133333333FFB81A4100000080861958419A99999991B91A419A99999988195841CDCCCCCC9AB91A41000000A0831958413333333345B91A4100000080731958416666666642B91A419A9999396E1958413333333369B91A41000000E062195841666666660AB91A4133333373591958413333333325B81A41666666464A19584100000000EEB71A419A999999441958416666666612B81A4133333373401958410000000076B81A41333333334019584166666666D0B81A41CDCCCCCC3B19584166666666F6B81A41CDCCCC8C351958419A99999923B91A41333333D3201958419A9999993FB91A41000000E01A19584133333333B3B91A41666666660C19584100000000D8B91A41666666460019584133333333E9BA1A4100000000DA18584100000000F6BA1A419A9999D9D3185841CDCCCCCCD0BA1A41CDCCCCECC61858419A999999FBBA1A41CDCCCCACBE1858416666666632BB1A419A999959BB1858416666666636BC1A4133333353B6185841666666669EBC1A4100000060AE18584100000000E4BC1A4166666606A3185841CDCCCCCC00BD1A41000000608C185841CDCCCCCC4ABD1A41000000808418584133333333EFBD1A41666666C67D185841CDCCCCCC74BE1A41333333B37D185841CDCCCCCC9CBE1A41666666E67F185841CDCCCCCC8ABE1A419A9999F99318584133333333ADBE1A419A99991999185841CDCCCCCCF4BE1A41000000C09A18584100000000DABF1A41000000009718584100000000E8C01A419A99997995185841333333331DC11A41666666468918584100000000F0C11A41333333F38C185841333333332BC21A4133333393901858419A9999991FC21A41666666A69518584166666666C0C11A41333333B398185841CDCCCCCC44C11A419A9999D9A11858416666666610C11A41000000E0AA185841666666661EC11A419A999999B31858419A9999996BC11A4100000060C4185841CDCCCCCCBAC11A4100000080C71858413333333311C21A4166666646C7185841CDCCCCCCD4C21A4166666646C01858416666666618C31A41000000C0B21858416666666696C31A4133333333B0185841666666667CC31A419A999939BF18584100000000B2C31A419A9999F9C1185841000000004CC41A4100000080BF1858410000000092C41A4133333333C01858413333333333C51A41666666C6C818584100000000E4C51A419A999979D61858419A99999935C61A4133333353DF1858416666666684C61A4133333353EB1858419A999999F1C61A41000000C0EA18584100000000CCC71A419A999939E118584166666666AAC81A4133333313D018584100000000ECC81A4100000020CC1858410000000052C91A4100000080CF185841000000005EC91A419A999919D5185841333333331FC91A41CDCCCC6CE01858413333333301C91A41CDCCCC2CE9185841000000000CC91A419A999979EF1858410000000046C91A419A999999F5185841CDCCCCCC98C91A4166666646F71858419A999999DFC91A419A999999F41858413333333303CA1A41CDCCCC4CF018584133333333C5C91A4100000000E41858419A99999919CA1A41000000C0DF1858416666666678CA1A4100000080DF185841000000001ACB1A4100000020E9185841666666663ECB1A41333333B3EC18584133333333CBCB1A41CDCCCCACF0185841333333330BCC1A4100000020FA1858419A99999913CC1A419A9999D9061958410000000034CC1A41000000C00B1958419A9999998BCC1A41000000400C195841CDCCCCCCBACC1A41CDCCCC8C091958413333333313CD1A4100000080FC185841333333338FCD1A41CDCCCCACF81858413333333371CE1A4166666666F41858413333333301CF1A41333333B3F41858410000000094CF1A4100000020FB185841CDCCCCCC38D01A419A999939FE1858419A9999999DD01A419A999959F718584100000000BAD01A41000000E0EF18584166666666B6D01A41CDCCCC4CE918584166666666EED01A41666666A6E51858419A999999EBD11A4166666666E518584133333333F5D11A419A999959DA18584166666666D4D11A4166666666CC185841CDCCCCCCFAD11A41CDCCCC8CBF185841CDCCCCCC80D21A4133333373B118584133333333C1D21A41666666E6AC1858413333333365D31A41CDCCCC8CA81858419A99999997D31A4133333373A518584100000000ECD31A41CDCCCC8C9B18584166666666ECD31A413333337396185841333333338DD31A41CDCCCCEC8B18584133333333DBD31A4133333373791858416666666636D41A419A99991976185841CDCCCCCCCCD41A41333333F381185841CDCCCCCCF8D41A419A999939821858413333333333D51A41666666E67B1858410000000070D51A41000000806318584166666666ACD51A41666666065F1858410000000004D61A4100000060601858419A9999994BD61A4166666626671858419A99999981D61A410000004069185841CDCCCCCCB2D61A41000000E0631858419A999999B7D61A41666666A65C1858419A99999973D61A419A9999394F1858419A999999ABD61A41000000604718584100000000A8D71A419A9999D93A1858419A999999FFD71A41000000E0371858416666666686D91A413333335333185841CDCCCCCCAAD91A4133333333341858413333333323DA1A41333333933118584133333333BFDA1A4133333353311858419A99999913DB1A41333333132F1858419A99999989DB1A41CDCCCCCC211858416666666672DC1A419A99995918185841CDCCCCCC74DD1A41666666E6031858419A999999B7DC1A419A999979FB1758416666666698DB1A41CDCCCC0CFF17584133333333DDDA1A4166666686FA1758419A99999931DA1A419A999939F8175841000000008ED81A4100000020F41758413333333337D81A4166666646E61758416666666670D81A41CDCCCC2CDA175841CDCCCCCCE8D81A41333333F3D4175841CDCCCCCC9AD91A41333333B3D01758416666666634DA1A41CDCCCC4CC3175841333333336DDC1A4166666666A81758416666666688DC1A41CDCCCCACA717584133333333F3DD1A41666666468517584133333333AFDF1A419A9999397F17584133333333B7E01A419A9999997A1758419A9999996BE21A416666662674175841CDCCCCCC6EE31A410000006072175841CDCCCCCC04E41A416666660673175841CDCCCCCCA0E41A419A99993972175841333333331DE61A41CDCCCC2C6C175841333333330DE71A41333333D365175841666666667CE71A41000000405E17584133333333DBE71A419A9999796317584133333333D9E81A4166666686651758419A999999F5E81A41333333F36B1758416666666668E91A419A9999F976175841666666662AEA1A410000002084175841333333339BEA1A41CDCCCCCC9A175841CDCCCCCCEAEA1A41333333939E1758413333333319EC1A4166666646A5175841CDCCCCCC80EC1A41000000A0A81758419A999999B1EC1A41CDCCCC6CAE17584133333333ABEC1A41666666A6B21758413333333337EC1A41CDCCCC8CB71758419A9999994DEC1A41CDCCCC2CC21758419A999999E9EB1A41CDCCCCCCC9175841000000006AEC1A4133333373C817584100000000E6ED1A41CDCCCCCCC81758416666666680EE1A4166666626C317584166666666AAEE1A4100000040BC175841CDCCCCCC2EEE1A41333333F3A41758419A99999941EE1A41CDCCCC4C9C17584166666666A0EE1A4133333353971758416666666612EF1A41CDCCCCEC9C1758410000000052EF1A41333333D39D17584100000000F8EF1A419A9999F997175841333333338DF01A41000000C095175841CDCCCCCCC2F01A419A9999D98E175841CDCCCCCCBCF01A41333333B3871758413333333377F01A41333333D376175841CDCCCCCC9CF01A41000000A06F17584133333333E1F01A41333333336D1758419A99999901F21A419A999919691758413333333379F21A41666666C6651758416666666622F31A41000000205E1758419A999999ADF31A419A9999B9551758416666666636F41A419A999999481758419A999999A1F41A41666666664117584166666666FAF41A41333333D33D175841CDCCCCCC4AF51A419A9999F93C175841CDCCCCCC32F51A41333333B3341758419A9999991FF51A41CDCCCC4C1617584100000000C0F41A41666666E60F1758419A999999BFF41A419A9999190C1758419A99999937F51A41000000A00C175841000000005AF51A419A9999D90A175841666666664AF51A41CDCCCCAC021758413333333371F51A41666666E6FB1658416666666632F51A41CDCCCCACE516584166666666C8F41A4133333353DF165841CDCCCCCCD4F41A41CDCCCC8CDC165841CDCCCCCC58F51A419A9999B9D41658410000000094F51A419A9999F9CD16584100000000E2F51A41CDCCCC4CBF1658419A999999B7F61A41CDCCCC0CB91658413333333311F71A41666666E6B41658419A9999993DF71A4133333373AE1658410000000064F71A4100000020A11658419A999999F7F71A41CDCCCC0C90165841CDCCCCCC14F81A4133333353891658416666666618F81A4100000040801658419A99999993F81A41CDCCCC2C7416584100000000F2F81A41333333736F1658413333333387F91A41333333936B165841CDCCCCCC3AFA1A4166666626691658413333333383FB1A419A999959611658416666666618FC1A41666666265B165841666666668AFC1A41666666C653165841000000000EFC1A41CDCCCCCC341658410000000070FA1A41666666063016584133333333DDF81A413333335319165841000000002AF81A41CDCCCCECF9155841CDCCCCCCB0F71A41CDCCCC4CEE1558419A99999947F71A41CDCCCCACE91558419A9999999DF61A41000000E0E81558419A9999998FF51A419A999919E615584133333333F5F31A41CDCCCC0CE115584100000000B8F11A41000000C0E21558419A9999993FF11A41333333D3DD155841CDCCCCCC02F11A41000000A0D71558419A999999ADEF1A41CDCCCC4CCB1558413333333335EF1A41000000A0C71558419A999999DFEE1A41CDCCCC6CBC15584100000000D8EE1A419A9999F9A6155841CDCCCCCCA2EE1A41CDCCCC4C9D155841CDCCCCCC00EE1A419A999959921558413333333315ED1A41333333D385155841CDCCCCCC96EB1A4100000000651558410000000014EB1A41666666865B1558416666666622EA1A41CDCCCC4C481558416666666656E91A4166666686611558419A999999CFE91A41CDCCCC8C70155841CDCCCCCC48E91A41CDCCCCCC7E1558419A999999FDE71A41666666869015584100000000ECE61A41000000009C155841000000005AE51A4133333333AB1558419A9999994DE41A41CDCCCCECB115584133333333ABE31A4100000000BD155841000000006CE31A41CDCCCCCCC5155841CDCCCCCCF0E21A419A9999B9CA155841666666669AE11A41666666A6D3155841CDCCCCCC0CE01A419A999959E515584100000000AEDD1A41CDCCCC4CF315584100000000D8DC1A4133333333FC155841666666662CDC1A41666666A6001658419A99999917DB1A41666666E6041658410000000062DA1A41CDCCCCAC0916584133333333A3D91A413333339307165841CDCCCCCC04D91A413333333309165841000000002AD81A41333333F30D16584166666666AED71A419A999999111658416666666642D71A41333333F31E165841CDCCCCCCC6D61A41333333B323165841000000006CD51A41666666A62E1658419A99999981D31A41CDCCCCCC47165841CDCCCCCC9AD21A41000000C051165841000000004AD11A4166666626671658416666666670D01A410000000079165841CDCCCCCC20D01A41CDCCCC0C791658410000000008CF1A41CDCCCCAC6C165841333333333FCD1A4166666626661658410000000072CC1A419A9999B95F16584133333333A5CB1A41CDCCCCAC56165841CDCCCCCCECCA1A41000000A05E1658419A99999959CA1A41CDCCCC6C60165841CDCCCCCC8AC91A41CDCCCC8C5E1658410000000086C81A41666666E6611658413333333385C71A4166666646621658419A99999913C71A41CDCCCCCC641658410000000018C51A419A999919771658410000000032C41A413333339381165841333333339BC31A413333335387165841CDCCCCCC0CC31A419A9999198A165841CDCCCCCC1AC31A41000000209816584133333333E7C21A41000000209C165841333333331DC21A41CDCCCC6C9E1658419A999999EBC01A4166666626AB1658416666666674C01A41666666C6B0165841CDCCCCCCDABF1A4166666686BA1658419A99999941BF1A41333333B3C81658419A9999999FBE1A41000000C0D116584133333333CFBD1A4166666646D51658410000000082BD1A4166666646DA1658413333333385BC1A41CDCCCCCCE216584166666666F0BB1A4166666606EF1658419A999999BDBA1A419A9999B91017584166666666E6B91A41CDCCCC2C0D1758413333333309B71A41CDCCCCECF81658419A9999991DB61A4100000020EF1658416666666610B51A41666666A6E21658416666666652B41A419A9999B9DA1658419A999999FDB21A4166666686C81658416666666668B21A41000000E0D31658419A999999C9B11A4133333373DB165841CDCCCCCC64AF1A419A999919F0165841666666663AAF1A4166666606F21658419A99999991AD1A419A9999B9FD1658419A999999FFAC1A419A9999190017584166666666FCAB1A41CDCCCC0C021758419A99999911AC1A419A9999794A175841000000002AAC1A41666666265B175841CDCCCCCC0EAD1A41CDCCCCCC641758413333333349AD1A41CDCCCCEC6E1758410000000036AD1A41000000E08917584133333333D9AD1A4100000000A41758416666666652AE1A41CDCCCC6CB01758419A99999937AF1A41666666C6C317584133333333CBAE1A41CDCCCCACCE17584100000000A6AE1A41333333B3CF1758416666666608AE1A41000000A0CE17584133333333C3AD1A41666666C6D317584133333333B7AD1A41000000A0D91758410000000046AD1A4100000080E9175841CDCCCCCC3EAD1A4100000000ED1758419A999999A9AC1A4133333393F0175841CDCCCCCCD8AB1A419A9999D9F717584100000000D2AA1A41666666260518584133333333A3AA1A41333333F30C1858419A99999971AA1A419A9999790F185841000000008EA91A41666666860D1858416666666634A91A419A9999B90D185841CDCCCCCCB6A81A41666666461C1858416666666658A81A41CDCCCCAC1F18584133333333E3A71A419A99993921185841333333339BA71A41666666E62A1858413333333395A71A4133333393351858416666666648A71A41333333733A18584133333333EBA61A41333333D3471858410000000074A61A41000000404B185841CDCCCCCC3CA61A41000000004B185841CDCCCCCCBCA51A419A9999594518584166666666BEA51A41CDCCCC2C3E1858419A99999997A51A416666662636185841666666664CA51A410000002033185841CDCCCCCCFCA41A41000000E0331858419A99999985A41A41666666E638185841CDCCCCCC12A41A419A9999793B185841CDCCCCCCAAA31A41333333F3401858419A999999E3A21A41CDCCCC2C46185841CDCCCCCC9EA21A41000000204F1858413333333309A21A41CDCCCCCC4F185841CDCCCCCC5AA11A41000000405418584133333333E3A01A41CDCCCC8C5C18584133333333E3A01A41CDCCCC8C5C185841	01010000206A080000372FEA8E31C41A41343333F302185841	400130000	Z	Arthez-d'Armagnac	4001300	40013	40	75	11
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	01010000206A080000E8800B2744731A413333339365295841	400140000	Z	Arue	4001400	40014	40	75	49
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	01010000206A080000D03CA34963891C4134333303322E5841	400150000	Z	Arx	4001500	40015	40	75	24
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	01010000206A0800008E37B0A704851941333333D3E5FF5741	400160000	Z	Aubagnan	4001600	40016	40	75	3
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	01010000206A08000036257CE7F9101941000000B09F065841	400170000	Z	Audignon	4001700	40017	40	75	9
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	01010000206A080000BEEBD72B92E51741666666F6AA0F5841	400180000	Z	Audon	4001800	40018	40	75	8
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	01010000206A080000D2AC6351054E164133333373873D5841	400190000	Z	Aureilhan	4001900	40019	40	75	12
01060000206A08000001000000010300000001000000DC020000000000007AE71841CDCCCC8CD211584166666666D8E71841CDCCCC0CD41158413333333305E818419A999919D61158419A9999992DE81841CDCCCC4CD9115841CDCCCCCC4EE818419A9999B9DE115841CDCCCCCC76E8184100000060DF115841CDCCCCCCAEE8184100000040E01158419A999999FDE818419A999959E01158419A99999927E918419A9999B9DD115841333333335DE9184133333373D91158410000000094E91841CDCCCCECD511584166666666BCE91841000000E0D41158416666666620EA1841CDCCCC6CD4115841CDCCCCCCAAEA184100000020D4115841CDCCCCCC34EB184166666646D3115841666666667AEB1841CDCCCCCCD11158419A999999B1EB1841CDCCCC0CCF115841CDCCCCCCECEB184133333373CB1158419A99999985EC1841CDCCCC2CC51158419A999999C1EC1841000000A0C4115841CDCCCCCC28ED1841CDCCCCCCC31158410000000066ED18419A999959C2115841CDCCCCCCBAED184100000060C01158413333333301EE184100000020BD115841CDCCCCCC66EE1841CDCCCCCCB8115841CDCCCCCCF0EE184133333373B41158419A99999931EF1841CDCCCC8CB31158410000000084F0184100000020B31158419A999999C3F01841CDCCCCCCB1115841000000004CF11841333333F3B011584100000000AEF1184100000040B01158419A99999913F2184100000020AE115841666666668EF21841CDCCCC0CAD115841CDCCCCCCD4F218419A9999F9AC1158419A99999907F3184100000000AD115841CDCCCCCC2EF3184133333333AD115841CDCCCCCC72F3184133333313AE115841CDCCCCCCBAF318419A9999F9AE11584133333333EDF31841CDCCCC6CAF115841CDCCCCCC2EF4184100000060AF1158419A9999997FF4184100000020AF115841CDCCCCCC18F5184166666646AE11584166666666A0F51841000000E0AD115841CDCCCCCC56F6184166666686AC11584166666666D4F6184166666666AB115841333333335FF7184133333353A9115841CDCCCCCC94F71841666666C6A811584100000000F4F7184166666666A811584166666666F2F71841000000A0AA11584166666666F0F7184166666646AC11584100000000F2F718419A9999B9AD11584133333333FDF7184100000040AE1158419A9999990FF81841CDCCCCECAE1158413333333339F8184133333373AF1158416666666680F81841333333B3AF1158419A9999993DF91841666666A6AE11584166666666C0F9184166666686AE115841CDCCCCCCEEF918419A9999F9AE115841666666661AFA184133333393AF115841CDCCCCCC2AFA18419A9999F9AF1158416666666638FA18419A9999F9B01158419A9999998BFE1841CDCCCC8CB411584166666666F4FF1841CDCCCCACB11158419A999999FB01194133333353A6115841CDCCCCCC20041941333333F3B01158419A999999C506194133333393C011584100000000B41219413333333307125841000000008E1319413333335308125841333333337115194133333353F21158419A99999907171941333333B3011258419A99999929191941CDCCCC6C01125841CDCCCCCC462119410000006004125841CDCCCCCCE8221941333333F3E711584100000000AE2219419A9999F9D21158419A9999997524194166666626D51158416666666672251941CDCCCCACCC1158419A99999927261941CDCCCC6CD11158410000000064261941000000C0D211584100000000E42619419A9999D9C3115841000000000C2719419A999939BE115841CDCCCCCC342719419A9999F9B8115841CDCCCCCC64271941333333D3B21158419A9999998927194100000020AE11584100000000B2271941CDCCCC0CA91158419A999999CF27194166666646A6115841000000001228194166666666A11158410000000038281941000000E09D11584166666666522819419A9999799A1158419A99999965281941CDCCCCEC961158410000000098281941333333B38F115841CDCCCCCCDE281941CDCCCC8C87115841CDCCCCCC2E291941000000E07D1158413333333375291941CDCCCC4C7511584133333333BF291941000000406C11584133333333F32919419A9999F965115841666666661C2A1941CDCCCC4C60115841666666663C2A1941666666A65B11584100000000562A19416666662658115841666666666E2A19419A9999B9531158419A999999772A1941333333D34E115841333333337F2A1941CDCCCC0C4A115841333333338F2A19419A9999594511584166666666A82A1941666666E63E1158419A999999CF2A1941CDCCCCEC37115841CDCCCCCCF42A19419A999959321158419A999999232B1941666666062C1158419A9999994B2B19419A999939261158419A999999772B1941CDCCCCCC1F115841CDCCCCCC8C2B1941000000201D11584166666666B22B19416666660619115841CDCCCCCCCA2B1941CDCCCCEC151158419A999999E52B194100000000121158419A999999F12B1941CDCCCC6C11115841666666661A2C19419A9999D90F11584100000000322C19419A9999390F115841666666664C2C1941000000200F115841000000003C2C19419A9999B90D11584166666666362C1941333333F30B11584100000000462C1941333333330811584100000000522C1941333333530511584100000000682C194100000080FD10584100000000842C19419A9999D9F21058419A9999999D2C19419A9999F9E710584166666666B62C194100000020DD10584166666666C62C1941333333D3D710584133333333D32C194166666666D41058419A999999F12C19419A9999B9CF105841666666660E2D1941333333F3CB1058419A999999352D194166666686C61058419A999999572D194166666626C210584166666666782D194100000060BD105841333333339B2D1941CDCCCCCCB810584100000000AC2D1941CDCCCCECB610584133333333832B194166666606B710584100000000662B194166666666B110584166666666482B194100000020A6105841CDCCCCCCF82A19419A9999D995105841CDCCCCCCAC2A1941000000E08B10584100000000322A1941333333138110584166666666C0291941CDCCCCEC771058416666666658291941333333F36D10584100000000D42819410000008061105841CDCCCCCCA4281941CDCCCC2C5E1058419A99999975281941000000005A105841CDCCCCCC422819419A9999B952105841CDCCCCCC22281941333333D34B10584166666666F6271941CDCCCC0C4710584133333333C7271941CDCCCC4C431058419A999999A3271941CDCCCCEC3E105841666666668A271941000000003C105841CDCCCCCC62271941CDCCCCCC381058419A9999994D271941CDCCCC8C35105841000000004A27194100000060321058410000000046271941000000602E1058419A9999993D271941666666462B1058416666666624271941000000A026105841333333330F271941000000A02110584166666666FE261941333333731D10584100000000F02619419A9999791810584100000000EA2619419A9999D9141058419A999999DD26194133333353111058419A999999CF261941000000C00D10584166666666BE261941000000E00910584100000000BC261941666666A60810584133333333BF261941000000800510584133333333CD261941CDCCCC6C0110584100000000D626194100000060FE0F584100000000EC261941666666E6FA0F5841666666660C27194100000040F60F58416666666626271941CDCCCCECF20F58416666666638271941666666C6F00F58416666666636271941CDCCCC0CEE0F5841CDCCCCCC3E2719419A999919E10F58419A99999949271941CDCCCCECDC0F58416666666650271941CDCCCC2CDA0F5841CDCCCCCC5227194100000060CC0F5841333333335F2719419A9999B9C40F58419A9999996F27194100000000C00F5841CDCCCCCC6E271941CDCCCC4CBB0F58410000000050271941CDCCCC6CB50F58419A9999994127194133333333AD0F5841666666664027194100000060A40F5841000000002A2719419A9999F99F0F584166666666082719419A9999B99B0F58413333333309271941666666269B0F584100000000062719419A999979990F58419A999999FF26194100000020980F584166666666F626194133333313960F584166666666D626194133333313910F5841000000006E261941CDCCCC2C810F58413333333331261941666666A6790F5841CDCCCCCC16261941CDCCCC2C760F584133333333FF2519419A9999F9730F584100000000F4251941CDCCCC8C720F5841CDCCCCCCE42519419A9999796F0F5841CDCCCCCCD0251941333333336B0F584100000000B82519419A9999B9650F5841CDCCCCCC9C25194133333353610F58419A99999991251941666666865F0F58419A9999994F251941333333D3410F5841333333334F25194100000040410F5841333333334D251941000000203F0F5841666666664A251941000000A03C0F5841CDCCCCCC402519419A9999393A0F5841CDCCCCCC20251941CDCCCC6C330F58419A999999ED241941000000C02B0F5841CDCCCCCCC024194166666666240F584100000000A824194166666626200F58413333333393241941000000801C0F5841000000007624194166666666170F58413333333367241941666666C6140F5841000000003C2419419A9999D90E0F5841CDCCCCCC082419419A999939090F58419A999999DB231941333333D3020F584100000000B42319419A999979FD0E58419A99999989231941333333F3F90E58419A99999947231941000000C0F50E58419A9999990923194166666626F20E5841CDCCCCCCDE221941CDCCCCECEE0E584166666666C822194133333313EC0E584133333333AB221941333333F3E60E58410000000084221941CDCCCCCCDF0E5841333333335B22194100000080D90E5841CDCCCCCC30221941333333B3D30E58419A9999990B22194100000060CE0E58419A9999990922194133333313CE0E5841CDCCCCCC06221941000000E0CC0E5841666666660622194166666646CB0E5841CDCCCCCC0A2219419A9999D9C90E5841CDCCCCCC12221941CDCCCC4CC80E58416666666620221941000000E0C60E5841666666663222194133333353BD0E5841666666661C22194133333353BD0E5841333333330D22194100000020BD0E58413333333303221941CDCCCCACBC0E584100000000FE211941CDCCCC8CBB0E5841CDCCCCCCEC2119419A9999B9B70E58419A999999C721194166666626B60E5841666666669821194166666646B50E58413333333357211941CDCCCC8CB50E5841666666661E21194166666626B60E584133333333FB201941CDCCCC2CB60E584133333333E320194100000060B50E58419A999999E120194166666606B40E584100000000E8201941666666C6B10E58419A999999E720194166666686AF0E584100000000DA2019419A9999F9AD0E584166666666C2201941000000C0AD0E584166666666AC201941CDCCCCACAD0E5841CDCCCCCCC4201941333333B39D0E5841000000008C201941666666E6950E58419A99999937201941333333D38D0E584100000000E61F194100000020830E584133333333CD1F1941CDCCCCEC5E0E584133333333891F194100000040420E58419A9999994B1F1941CDCCCC4C330E584100000000F81E1941000000E0170E584133333333011F1941CDCCCC4CCF0D58419A999999A91E1941333333D3CA0D58419A999999451E1941CDCCCCACC40D5841CDCCCCCC321E19419A9999B9C20D584133333333291E1941666666E6BF0D584166666666341E194100000020BB0D584133333333571E19419A999979B60D584166666666941E194166666646AF0D584100000000AE1E194100000020AA0D584166666666B81E1941333333F3A50D584133333333B91E1941CDCCCCECA20D584100000000AE1E1941666666E6A00D5841666666669C1E1941CDCCCC2C9E0D584100000000721E1941666666469B0D5841CDCCCCCCEC1D1941CDCCCCCC930D5841CDCCCCCCBA1D19419A9999F98E0D58419A999999A71D1941000000E08A0D584166666666B21D194133333333850D5841CDCCCCCCF81D1941000000407D0D5841CDCCCCCC281E1941666666C6720D5841333333331B1E194166666666660D58419A999999231E194100000080510D58419A999999291E19419A999979470D5841CDCCCCCC3E1E1941000000203E0D5841CDCCCCCC4C1E1941666666C6340D584133333333691E1941CDCCCC8C290D5841666666668C1E19419A9999391C0D584166666666AC1E1941333333D30F0D584166666666B61E19419A9999B9060D584100000000FA1E1941CDCCCCCC080D5841666666660C1F1941333333B3060D58419A999999251F194166666606FE0C584133333333371F1941CDCCCC2CF80C5841CDCCCCCC7C1F1941CDCCCC4CEB0C584100000000A81F1941666666C6E00C584100000000A01F19419A999979DC0C584166666666941F1941333333F3DA0C5841CDCCCCCCC020194133333313B90C584166666666D020194133333353B70C584100000000102219419A9999B9930C58419A9999998322194133333393860C5841000000001623194166666646760C5841CDCCCCCCA0231941CDCCCCAC660C584133333333CF23194133333393610C5841000000002A241941000000A0570C58410000000084241941000000804D0C584100000000FE241941666666863F0C5841000000008625194166666646300C5841000000008825194166666606300C584133333333DD251941CDCCCC6C260C5841666666660A261941CDCCCCEC200C5841CDCCCCCC362619419A9999B91A0C5841000000005A26194133333333150C58413333333375261941000000C0100C5841000000005C25194133333353030C58419A9999998B2419419A9999F9F10B584100000000DC23194166666686E30B58416666666620231941CDCCCC8CD60B58419A999999A9221941000000C0CC0B5841666666665A201941CDCCCCAC9B0B5841CDCCCCCC8E1F1941666666669B0B584133333333271F194100000080980B5841CDCCCCCC9E1E1941000000C08F0B584133333333E71D194133333333890B5841CDCCCCCC4A1D194100000020890B58419A999999731C19419A999939860B584133333333111C19419A999939870B58419A999999991B19419A9999B9880B584166666666401B19419A9999198A0B584100000000FC1A1941666666A68B0B58419A999999C71A1941666666468D0B58419A999999C11919419A999919AA0B5841CDCCCCCCBC1919419A999959B50B584100000000C2191941CDCCCCCCC40B58419A999999E3191941CDCCCC6CCD0B584133333333011A1941000000E0D60B584100000000141A194166666686DC0B584133333333DD191941333333B3E10B5841333333339119194133333313E50B584133333333EF1819419A999979E70B58416666666628181941CDCCCCCCEA0B58410000000074171941000000A0EF0B584166666666CA1619419A999979F50B5841333333330F1719419A999939FE0B58413333333381171941666666A60C0C5841000000003E181941CDCCCCAC260C5841CDCCCCCC44171941666666262C0C584100000000241619419A999979320C58416666666630151941000000C0370C584166666666D6131941000000403F0C5841000000007A13194166666646410C584100000000E81219419A999979440C5841666666661812194166666606490C5841CDCCCCCC42111941000000A04D0C58419A99999991101941CDCCCC8C510C584133333333A50F1941666666C6560C584100000000920F1941CDCCCC2C570C584133333333A90E1941333333335C0C5841CDCCCCCCC20D19419A999939610C5841CDCCCCCCE00C1941CDCCCC2C660C584166666666A60C194133333373670C5841CDCCCCCC8A0B1941CDCCCC8C6D0C584100000000CC0A1941000000A0710C5841333333338109194100000000790C5841666666668A081941666666667E0C584133333333AF071941CDCCCC2C830C58419A999999FB06194166666606870C58419A9999995D061941666666868A0C58410000000046061941666666068B0C5841666666663C061941666666A6890C5841333333332D061941CDCCCCCC860C5841333333331B061941CDCCCCAC830C58419A999999FB051941CDCCCC6C810C5841CDCCCCCCDA051941000000407F0C584133333333B9051941000000607D0C5841333333339D051941666666867B0C5841333333338B051941666666067A0C58416666666684051941CDCCCC2C780C5841333333338105194100000020760C58419A9999996F051941CDCCCC8C720C58419A9999995F0519419A999959700C5841CDCCCCCC48051941000000606E0C584133333333210519419A9999396C0C58416666666600051941333333936A0C584133333333DB04194100000060690C584166666666C4041941000000E0670C584133333333AB04194133333313660C5841CDCCCCCC8E0419419A9999F9630C5841666666667C0419419A999999620C584100000000700419419A999939610C5841CDCCCCCC6E0419419A9999995F0C58419A999999770419419A9999195E0C58410000000086041941CDCCCC0C5C0C58413333333393041941000000A05A0C58416666666698041941000000A0590C5841000000009604194100000040580C5841CDCCCCCC86041941CDCCCCCC560C5841000000007804194133333393550C5841000000006004194133333313540C5841666666664604194100000080530C58413333333327041941CDCCCCAC520C58419A9999991504194100000020510C58413333333313041941CDCCCC8C4E0C58410000000014041941000000204C0C58413333333319041941000000C04A0C5841000000001C04194100000080480C58416666666618041941666666E6450C5841CDCCCCCC0E0419419A999979440C584166666666020419419A999959430C584100000000FE031941000000C0410C58410000000002041941CDCCCC2C3E0C58419A9999990D041941CDCCCC6C3B0C58416666666612041941CDCCCCCC370C58413333333315041941CDCCCC4C350C58419A99999913041941000000A0330C584133333333110419419A999959320C5841000000000E04194100000000310C5841333333330F041941666666462F0C5841000000001C041941333333332E0C58413333333339041941333333B32D0C5841666666665E041941CDCCCC0C2D0C58419A99999977041941000000402C0C5841333333338B041941CDCCCCEC2A0C5841CDCCCCCC9E04194166666646290C584166666666B6041941CDCCCC6C270C5841CDCCCCCCBE041941CDCCCC2C250C584100000000C40419419A999959220C584133333333C5041941666666861F0C584133333333C30419419A9999391D0C58419A999999BD041941333333331B0C584133333333B504194100000040190C584133333333A904194100000080170C5841666666669C0419419A9999F9150C584133333333950419419A999979140C58413333333391041941CDCCCC4C120C584133333333970419419A999979100C58419A999999A1041941CDCCCCCC0E0C5841CDCCCCCCAC041941666666260D0C58419A999999B1041941000000400B0C584166666666AE041941333333F3090C58419A99999995041941666666A6010C5841CDCCCCCC88041941CDCCCCCCFB0B5841CDCCCCCC6E04194166666606F30B58419A9999994B041941000000C0EE0B58419A9999990304194100000040ED0B584133333333C50319419A999979ED0B5841CDCCCCCC64031941CDCCCC4CF10B58419A9999995D03194133333353F20B5841666666665403194100000060F40B5841000000005003194133333393F60B58419A9999994F03194133333373F80B5841333333335103194133333373FA0B5841CDCCCCCC560319419A999959FC0B5841000000005E03194100000080FD0B5841CDCCCCCC5E031941CDCCCCCCFE0B5841CDCCCCCC56031941333333F3FF0B5841000000004C031941CDCCCC8C010C58419A9999993D031941000000A0020C58419A99999933031941CDCCCCCC020C58416666666626031941CDCCCC6C020C5841333333332103194100000080010C5841666666661E03194133333393000C5841666666661A031941CDCCCCCCFF0B5841CDCCCCCC0E03194133333313000C5841CDCCCCCCFE02194133333353010C584133333333E702194133333333030C584100000000D6021941000000A0040C5841CDCCCCCC5C02194100000020FE0B5841CDCCCCCC5C021941CDCCCCECEB0B584100000000E80119419A9999F9FB0B5841333333335F011941666666E60B0C584100000000E8001941CDCCCC0C150C58419A9999994F001941333333531E0C584100000000B2FF184166666666280C5841333333330DFF184133333313300C58413333333355FE184133333353370C58419A999999A7FD18419A9999F93B0C5841CDCCCCCCDAFC184166666626410C5841666666660AFC1841CDCCCCEC450C5841666666668AFB18419A9999F9470C5841000000007AFB1841CDCCCCCC3A0C58416666666668FA1841000000603C0C58416666666646F9184166666606390C584100000000D6F81841666666E6340C5841666666664AF81841CDCCCC8C310C584133333333D3F71841CDCCCC2C2F0C58410000000054F71841CDCCCC4C2D0C5841CDCCCCCC04F71841666666A62A0C58419A999999D7F61841CDCCCC2C280C584133333333A1F618419A999939260C58419A9999992FF61841CDCCCC4C250C584166666666C6F5184133333373230C58413333333325F51841CDCCCC6C1F0C584100000000C6F418419A9999D91C0C58413333333331F418419A9999191A0C5841333333336DF318419A999939120C5841CDCCCCCC20F31841333333F30F0C58410000000066F31841333333B31A0C58416666666696F31841333333D3230C58416666666656F41841666666E6380C5841CDCCCCCCBAF41841CDCCCC4C440C58410000000034F51841CDCCCC2C500C58413333333377F51841666666065A0C58410000000044F518419A999919650C58410000000066F5184133333393650C5841000000007CF51841666666E6660C584100000000A0F518419A999919690C584133333333C9F518419A9999596E0C5841CDCCCCCCDAF518419A999919750C584133333333F3F51841333333B3790C5841CDCCCCCC3EF6184166666666840C58413333333349F61841CDCCCC0C890C58410000000054F61841000000208F0C58419A99999965F6184166666626930C5841CDCCCCCC98F618419A999919970C58419A999999D5F618419A9999F9980C58410000000042F71841333333D39A0C58419A9999996FF718419A9999F9A10C58419A99999991F71841333333D3A60C5841CDCCCCCCD6F718419A999999B20C58419A9999991BF81841000000E0BC0C58419A9999994BF81841CDCCCC8CC20C58419A99999945F8184100000040C90C58416666666654F81841CDCCCC2CD30C58413333333341F81841333333D3DB0C5841000000004AF8184133333353EA0C58410000000088F8184166666626F30C5841000000000CF91841333333B3F70C5841000000009CF61841333333B30E0D5841CDCCCCCC72F618419A999999110D5841CDCCCCCC3EF61841CDCCCC2C140D58419A99999913F6184100000040160D584166666666F0F5184100000080170D58419A999999CBF51841333333D3170D584133333333AFF51841CDCCCC6C170D5841000000007AF51841000000A0160D58413333333325F5184166666626160D584166666666FAF41841666666E6150D58419A999999E3F41841333333D3150D58419A999999C5F41841000000C0150D5841333333339DF4184133333393150D5841333333337BF4184166666686150D5841666666668CF41841333333732E0D584133333333CDF418419A999999410D58413333333303F51841000000E0490D58416666666624F518419A9999395A0D5841CDCCCCCC50F51841CDCCCCCC640D58416666666640F51841000000E06E0D58419A999999E5F41841CDCCCC2C860D5841CDCCCCCC62F418419A9999599B0D58419A99999903F7184133333353A50D5841666666665CF71841CDCCCC6CA30D58410000000066F71841CDCCCCACA50D5841CDCCCCCC78F71841CDCCCC4CA90D5841333333332BF91841333333B3AD0D5841CDCCCCCC9EFA184100000020B20D58419A99999963FB184133333313B20D5841CDCCCCCCB2FD184166666626A70D5841CDCCCCCC4EFE1841333333D3A50D584133333333E9FE184166666626A40D58419A99999969FF184166666666A20D5841666666661E0019419A999979A00D5841666666667E0019419A9999D99F0D5841CDCCCCCCC2001941333333739F0D58419A999999ED001941333333939E0D58419A999999190119419A9999599D0D584166666666520119419A9999B99D0D584133333333890119419A9999B99D0D5841CDCCCCCC9E011941333333539D0D584100000000AE011941333333739C0D58419A999999B7011941000000A09B0D5841CDCCCCCCBC011941CDCCCC0C9C0D584100000000BC0119419A9999B99C0D584133333333BB011941CDCCCC4CA00D584133333333C3011941000000A0A60D584133333333D1011941CDCCCCACAE0D584100000000DC011941000000C0B70D5841CDCCCCCCEC011941666666E6C20D584100000000F6011941333333D3C80D58413333333317FF1841CDCCCCACDE0D58413333333311FF18419A999959010E5841CDCCCCCC04FF184100000060620E58419A999999D9FE184166666606630E58419A99999973FE184166666626640E5841CDCCCCCC40FE1841000000C0640E5841CDCCCCCC02FE1841333333F3650E584166666666CAFD1841333333F3660E5841CDCCCCCC8CFD1841666666A6670E58419A9999995FFD1841000000E0670E58416666666640FD184166666686670E58419A999999EFFC184166666606670E58416666666688FC184133333393660E58410000000018FC184100000060660E584133333333B1FB1841666666C6650E58419A99999975FB1841666666E6650E5841CDCCCCCCEEFA184166666686660E5841CDCCCCCC78FA1841CDCCCC4C670E584166666666E2F91841CDCCCCEC670E5841000000002CF91841CDCCCCCC680E58419A99999987F818419A9999196A0E58416666666656F81841666666666C0E58416666666640F81841CDCCCC2C6E0E58419A99999925F818419A9999396F0E58413333333311F818419A9999D9700E5841CDCCCCCC0AF81841333333B3720E5841000000000AF818419A999919750E58419A9999990FF8184100000040780E5841666666660EF818419A9999197B0E5841000000000EF81841666666667B0E5841000000000EF81841CDCCCC6C7E0E58419A9999990DF8184133333373840E5841CDCCCCCC0CF81841CDCCCC2C8B0E58416666666612F81841CDCCCCCC910E58413333333319F81841666666269F0E58416666666638F81841CDCCCC0CA10E58410000000060F81841CDCCCC4CA20E58413333333391F8184166666646A20E584166666666BEF81841000000A0A20E58419A999999CFF8184166666606A40E584166666666E8F81841666666E6A50E584166666666ECF8184133333353A80E584100000000FAF818419A9999F9A90E58416666666614F91841333333D3AA0E5841333333332BF9184133333373AA0E58416666666638F91841333333F3A90E58419A99999947F91841CDCCCC2CAA0E58410000000060F9184133333373AB0E584166666666D2F918419A9999B9B20E5841CDCCCCCCFEF9184166666606B70E5841CDCCCCCC24FA1841333333F3BB0E5841666666661EFA1841CDCCCC2CC30E58419A9999990FFA184100000040CF0E58416666666610FA1841333333D3D50E584100000000FEF91841CDCCCC4CDB0E5841CDCCCCCCA2F918419A999979E40E5841333333337BF91841CDCCCC0CE80E5841CDCCCCCC6AF918419A999959EB0E5841000000006CF918419A999959F40E5841666666665CF9184166666646FE0E58419A9999993DF91841CDCCCCCC060F5841000000002AF91841CDCCCC0C0E0F5841666666662AF918419A999919110F5841CDCCCCCC0CF9184166666686140F584166666666D2F81841000000A0180F584100000000C0F81841666666661A0F5841CDCCCCCCBAF81841CDCCCCAC1C0F584100000000B6F81841000000A0210F584100000000B6F81841CDCCCCEC230F584133333333A7F8184133333333260F58419A99999947F818419A9999792C0F5841CDCCCCCC36F81841000000602E0F58419A9999992FF81841CDCCCC4C310F58419A99999939F818419A9999D9330F5841CDCCCCCC50F8184100000060360F58419A99999967F8184166666666380F58419A9999999BF818419A9999F93E0F584100000000CCF81841CDCCCC2C460F58416666666664F9184100000020510F5841000000003CFA18419A9999195F0F58419A9999996FFA184166666626640F584133333333A9FA1841000000206D0F584166666666C6FA184133333353730F58419A999999B9FA1841CDCCCC8C810F584133333333B9FA1841CDCCCC0C8B0F584166666666A6FA1841000000808D0F5841CDCCCCCC86FA1841CDCCCC2C910F58419A99999981FA18419A999939940F5841666666667CFA184166666626970F5841333333336FFA184166666646980F58410000000024FA1841666666E69B0F584100000000F2F91841000000C0A00F584166666666CAF91841CDCCCCECA40F584100000000C2F9184100000080A90F584166666666C0F91841CDCCCC4CAC0F5841CDCCCCCCA4F918419A9999F9AE0F5841CDCCCCCC68F91841333333D3B20F5841CDCCCCCC4CF91841000000C0B50F58410000000026F9184166666606BE0F584100000000F6F8184166666626C60F58419A999999EDF81841333333D3C90F5841CDCCCCCCE6F81841CDCCCC2CD00F584100000000E8F818419A999919DB0F58419A999999E1F81841CDCCCCCCE10F58419A999999B9F81841CDCCCC2CE90F58419A999999ABF81841000000E0EA0F58416666666690F81841CDCCCC2CEE0F5841CDCCCCCC5CF81841333333B3F60F5841CDCCCCCC4EF8184133333313FF0F58419A9999995DF81841000000400C105841666666665AF81841666666C60D1058413333333347F81841333333B30F1058410000000024F818419A999959111058419A999999EBF71841CDCCCCAC14105841333333333BF71841666666061C105841CDCCCCCC02F718419A9999D91F10584100000000D6F61841666666062310584100000000C8F618413333331327105841CDCCCCCCCAF618419A9999B92B10584133333333DFF61841666666C63410584133333333EFF618419A9999F93C10584133333333F5F61841333333D3451058413333333309F718419A9999394E1058410000000016F71841CDCCCC0C51105841333333338FF71841333333B35F1058410000000002F818419A9999B97E105841CDCCCCCC6AF71841000000807F1058413333333313F618416666660682105841333333337FF31841CDCCCCCC861058410000000032F318419A999959871058419A999999D5F2184100000000881058410000000076F21841666666A6881058413333333319F21841333333338910584100000000D0F118419A9999998910584100000000C4F11841000000008B10584133333333B5F11841CDCCCCEC8F10584100000000A8F118410000008097105841CDCCCCCC94F1184166666606A41058419A99999985F11841CDCCCC8CAB1058413333333373EB184166666686C4105841CDCCCCCC14EA1841CDCCCCECC81058419A999999F7E9184100000080C91058410000000068EA1841666666E6F71058410000000064EA184166666646FB1058419A9999995FEA18419A99997902115841CDCCCCCC54EA1841666666660D1158419A99999945EA184166666666171158413333333339EA1841666666A61C115841CDCCCCCC14EA1841000000802511584100000000FAE91841CDCCCC8C2C11584166666666F2E918419A9999192F11584166666666C8E81841000000605D11584166666666C2E718419A9999F9AA115841CDCCCCCCD4E71841CDCCCCECB8115841CDCCCCCCC0E7184133333313C4115841000000007AE71841CDCCCC8CD2115841	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	01010000206A080000F06DBD4B190E194166666696C70E5841	400200000	Z	Aurice	4002000	40020	40	75	18
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	01010000206A080000C0CCA29AAEA71541000000E099115841	400210000	Z	Azur	4002100	40021	40	75	17
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	01010000206A080000A2C87E1B46411A416666660662005841	400220000	Z	Bahus-Soubiran	4002200	40022	40	75	15
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	01010000206A080000621E7BEABE0C184166666606AE035841	400230000	Z	Baigts	4002300	40023	40	75	12
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	01010000206A080000AD7DC35A32EE1841666666469B075841	400240000	Z	Banos	4002400	40024	40	75	6
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	01010000206A080000E2768471B5E61941666666A6F9115841	400250000	Z	Bascons	4002500	40025	40	75	19
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	01010000206A080000435B6199F843194166666696500E5841	400260000	Z	Bas-Mauco	4002600	40026	40	75	12
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	01010000206A080000750357586DEC18419A9999B9FAF45741	400270000	Z	Bassercles	4002700	40027	40	75	7
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	01010000206A080000D18F3D94631D1841CDCCCC9C55FF5741	400280000	Z	Bastennes	4002800	40028	40	75	7
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	01010000206A08000023627C4977A41941333333937DFE5741	400290000	Z	Bats	4002900	40029	40	75	7
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	01010000206A08000066E526C61D471C41CCCCCC4C732C5841	400300000	Z	Baudignan	4003000	40030	40	75	24
01060000206A0800000100000001030000000100000095030000333333335B8017410000008046135841000000009083174133333393521358419A999999C18F1741000000006D135841CDCCCCCC2A921741000000007213584133333333BB921741CDCCCC8C7213584100000000EC9C1741666666A683135841666666669A9D1741CDCCCC0C85135841CDCCCCCC289F174100000040881358413333333303A01741CDCCCC2C8A135841CDCCCCCC5EA117419A9999998C1358413333333331A21741333333138E135841666666667AA71741666666869A13584100000000F4AB174166666666A31358419A99999905AF1741666666A69513584166666666BCB01741CDCCCC0C9E135841333333334BB317419A9999F9A9135841CDCCCCCC4CB3174133333373B6135841CDCCCCCC76B31741CDCCCCACC613584100000000C8B31741000000A0D01358413333333305B4174133333393DA135841000000001EB41741CDCCCC8CDF135841CDCCCCCC32B4174166666606E7135841666666667EB61741CDCCCCCC3114584133333333B7B71741333333532B1458410000000026B91741333333D32A14584100000000B8B917419A9999B938145841CDCCCCCCFCB91741000000C04D14584100000000E4B91741666666864D14584166666666CAB91741333333334D1458419A999999AFB917419A9999994C145841000000009EB91741CDCCCCEC4B1458413333333377B9174100000020491458413333333363B91741000000E0461458410000000024B91741333333134614584166666666F8B817419A99991947145841CDCCCCCCBCB81741CDCCCCCC4C145841666666668EB81741CDCCCC6C501458416666666686B8174166666686531458419A999999DFB81741CDCCCCEC5C1458419A999999E5B817419A9999595F1458419A999999A3B81741000000E05F145841666666667AB8174133333313601458419A99999935B81741CDCCCC0C5E14584133333333EDB717419A9999F95914584100000000AEB71741CDCCCCEC571458419A99999979B717419A9999F957145841333333334BB71741666666E65A1458419A99999949B71741CDCCCCCC621458413333333339B71741000000E0641458410000000068B717419A9999F96F145841CDCCCCCCF6B717410000002085145841CDCCCCCC70B81741CDCCCC4C9514584133333333ABB91741666666C6AB14584133333333ABBA1741CDCCCC0CBA14584100000000D4BA17419A999959BE14584100000000D2BD174100000040A4145841000000003EBE1741333333D3B214584133333333ABBB174133333353DD14584100000000EEBB174133333393E71458413333333323BC1741CDCCCC8CEF1458416666666652BC17419A999999F7145841666666667EBC1741CDCCCC6CFB1458410000000082C117419A9999195C155841333333337DC117419A9999195D1558416666666684C11741CDCCCC6C62155841CDCCCCCCCEC117413333339368155841CDCCCCCC44C21741333333D37215584133333333CFC21741666666267E1558413333333333C31741CDCCCC0C861558419A99999987C31741CDCCCC2C8C1558419A99999993C31741000000A08E1558410000000088C317419A9999D990155841666666666EC3174100000040941558419A9999995FC3174100000040981558419A99999943C31741666666269C1558413333333319C317419A9999D9A315584133333333F3C21741333333F3AA155841CDCCCCCCCAC2174166666686B21558419A999999A7C2174166666626B9155841CDCCCCCC88C2174133333313BF155841CDCCCCCC62C2174133333353C61558419A99999935C2174133333313CF155841000000000AC217419A9999F9D615584133333333DFC1174133333353DF15584133333333B9C1174133333393E6155841CDCCCCCC88C117419A999999EF1558416666666646C11741333333D3FA155841666666660AC11741333333B30616584133333333C7C017413333333314165841000000008CC01741666666E61F165841000000005EC0174133333353281658419A99999921C01741000000C0331658419A999999EFBF1741333333333D16584166666666C2BF1741CDCCCC0C46165841CDCCCCCCB0BF1741000000A0491658419A999999A5BF1741000000E04B165841CDCCCCCC68BF1741666666C656165841666666662CBF17416666660663165841CDCCCCCCFEBE1741CDCCCC2C6B16584100000000D6BE1741333333D372165841CDCCCCCCACBE1741666666E6781658410000000024C017419A9999397516584166666666E0C21741666666266E16584100000000E0D81741CDCCCC0C3A1658413333333325D91741CDCCCCAC391658410000000018DF1741CDCCCCCC2B16584166666666CEE11741333333F3241658419A999999C1E11741000000A02616584100000000BCE117419A9999592816584166666666BCE11741000000E02A165841CDCCCCCCC4E11741666666C62D16584166666666DCE11741333333532F1658419A999999FDE11741666666A6311658410000000000E21741666666A63216584133333333FFE11741333333333416584133333333F5E117419A9999793516584133333333DBE11741333333733716584100000000C0E117419A99991939165841CDCCCCCCB8E11741666666463A1658419A999999B7E117419A9999393C165841CDCCCCCCBAE11741000000403F16584100000000C0E11741CDCCCC2C4416584166666666BCE11741CDCCCCCC4716584133333333B3E11741333333B34B16584133333333A7E11741333333334E1658416666666698E1174100000000501658419A99999993E11741CDCCCC8C511658419A99999997E1174100000000531658419A999999A9E117419A99997954165841CDCCCCCCE2E117419A9999D956165841000000004CE21741666666A65A165841000000007CE21741000000005D1658416666666682E21741333333335E165841CDCCCCCC82E217419A9999795F1658413333333379E21741666666C6601658416666666664E21741333333B361165841CDCCCCCC44E21741CDCCCCCC61165841CDCCCCCC0CE2174166666626621658419A999999EDE11741666666066316584166666666C8E117419A9999D9641658419A99999991E11741CDCCCC0C67165841CDCCCCCC78E117413333331368165841CDCCCCCC64E117416666662668165841CDCCCCCC1EE1174166666646681658416666666602E11741000000C06816584100000000E8E01741333333F36916584133333333DDE017419A9999596B165841CDCCCCCCDAE017419A9999F96B16584166666666DCE017419A9999796E165841CDCCCCCCE2E017419A9999F97016584166666666F2E01741000000407516584133333333FFE0174133333333761658416666666606E117419A9999B976165841666666663CE11741333333F3761658413333333359E1174166666626771658419A9999997FE117419A9999F9761658416666666696E11741CDCCCC6C7616584166666666B6E117419A999939741658419A999999D1E11741333333537116584166666666F0E11741666666066F1658410000000008E21741666666066E1658413333333327E21741CDCCCC4C6E165841333333333BE217419A9999796F1658416666666644E21741CDCCCC8C71165841CDCCCCCC48E21741CDCCCCAC74165841000000004EE21741CDCCCC2C77165841333333335DE21741333333D378165841666666666EE21741666666E6791658419A99999983E21741666666E67A16584166666666CAE217419A9999F97C1658416666666648E317419A999939831658419A99999987E317419A999959861658419A9999999DE317419A9999198816584100000000A6E31741000000208A16584166666666AAE31741000000408C16584133333333B3E31741CDCCCC8C8F1658419A999999C7E31741CDCCCC4C93165841CDCCCCCCCAE31741CDCCCC4C9516584166666666C6E317413333337397165841CDCCCCCCB4E317419A99997998165841CDCCCCCC9EE317410000002099165841000000006CE31741666666C699165841CDCCCCCCF8E21741333333339916584166666666A2E2174100000080991658410000000066E21741666666E699165841000000003AE21741333333339B1658419A9999991DE21741333333B39C1658419A999999EDE11741000000209F1658419A999999D7E11741CDCCCC4CA116584100000000CEE11741333333B3A316584100000000D0E117419A999959A516584166666666E8E1174133333393A6165841CDCCCCCC08E21741CDCCCCECA6165841333333333FE2174166666666A61658413333333371E217419A999979A41658419A9999999DE2174133333353A216584100000000B6E21741CDCCCC6CA216584100000000CCE21741333333F3A216584166666666E2E21741CDCCCC4CA41658413333333303E31741CDCCCCECA61658410000000040E31741333333F3AA1658419A99999983E3174133333393B0165841000000008EE31741CDCCCC6CB3165841CDCCCCCC8AE31741CDCCCC6CB81658419A99999973E317419A9999D9BE165841000000005AE3174166666646C3165841000000002AE3174133333313C61658419A999999E5E2174166666606C816584133333333A7E21741CDCCCCECC81658416666666668E2174133333393C81658419A99999923E21741000000A0C81658419A999999F9E1174100000060C916584100000000DEE11741CDCCCC8CCB16584100000000DAE1174133333313CE16584166666666E2E117419A999959D0165841CDCCCCCCFEE117419A999919D3165841333333331DE2174133333373D41658410000000056E2174133333333D516584133333333ABE21741666666E6D516584133333333F3E2174100000000D61658419A99999917E317419A999999D61658416666666638E317419A9999D9D71658413333333365E31741333333F3D91658410000000054E617419A9999F9CD1658419A999999EDE8174133333353C61658413333333379E91741666666C6C31658410000000012EB1741CDCCCC2CBB165841CDCCCCCC48EC1741333333F3B0165841000000002CEF1741CDCCCCAC971658419A999999F5EF1741CDCCCC2C8F165841666666661EF01741000000A08B1658410000000060F017419A9999B984165841CDCCCCCC94F017419A9999397E1658419A999999C9F017419A9999997716584166666666E0F01741666666A67416584100000000E8F017419A9999D97216584133333333E9F01741333333F37116584100000000EAF0174100000060711658419A999999EFF01741000000606F1658413333333315F11741000000806B165841CDCCCCCC5EF1174133333333651658410000000094F117416666664660165841666666669AF11741666666A65F165841CDCCCCCCAEF11741666666A65D16584133333333B3F11741666666465D1658419A999999CDF117419A9999195A1658419A999999EFF1174166666666551658419A99999909F217416666664651165841CDCCCCCC48F217419A9999D94A165841CDCCCCCC86F21741CDCCCC4C4416584133333333A7F21741CDCCCCAC3F165841CDCCCCCCB0F21741333333333A1658416666666686F2174100000040271658419A9999996DF21741CDCCCC4C041658410000000028F21741000000A0D81558419A99999911F21741CDCCCCACC415584100000000FCF11741CDCCCC6CB91558419A999999E3F117419A9999F998155841333333334BF11741CDCCCC6C201558416666666634F117419A999999121558419A9999999FF017419A99991913155841000000009EF01741666666A609155841666666669AF0174133333393FD1458413333333397F01741CDCCCCECF11458419A9999998FF0174133333353CF145841333333338FF017419A999919CD145841CDCCCCCC8CF0174100000020C3145841333333335BF1174100000060BD1458410000000098F117419A9999D9B31458410000000054F117419A999979AD1458416666666684F01741CDCCCC2CA41458419A99999981F01741000000809B145841CDCCCCCC7CF01741000000808B1458413333333321F31741CDCCCCAC551458416666666646F41741666666863F145841000000002CF51741666666E62E14584133333333C5F5174100000000231458416666666674F51741666666661D14584133333333BFF51741CDCCCC8C181458410000000092F617419A9999D90A14584100000000E2F61741666666A605145841CDCCCCCCACF7174133333393F8135841CDCCCCCCC6F71741333333F3F61358419A999999CDF81741CDCCCCACE613584100000000BAF8174100000000E51358419A999999ADF81741CDCCCC0CE41358419A99999999F81741CDCCCC2CE31358419A99999977F817419A999979E21358419A9999994DF8174166666686E1135841333333333BF8174133333393E0135841CDCCCCCCFAF71741CDCCCC2CDF135841CDCCCCCC72F71741CDCCCC2CDC1358413333333327F71741CDCCCC4CDA1358419A999999FFF61741CDCCCC4CD913584100000000E0F6174166666686D81358419A99999995F61741CDCCCCACD61358416666666648F61741000000C0D4135841CDCCCCCC1AF617419A999999D3135841CDCCCCCCC2F5174100000000D11358419A99999971F51741333333F3CD13584166666666FCF51741333333939013584166666666B4F517416666666689135841CDCCCCCCA0F517419A9999798A1358419A9999997DF517419A9999598C135841CDCCCCCC6EF41741666666469B13584100000000ECF2174133333313B01358416666666604F217419A999999BC1358410000000060F117419A9999B9C4135841CDCCCCCC30F117419A9999D9C613584166666666A2F0174100000000CD13584133333333E3EF1741CDCCCC6CD31358410000000052EF1741CDCCCCECD6135841333333338BEE1741CDCCCC8CDB13584100000000E6ED174133333353DE1358410000000050ED174133333333E013584100000000CAEC174166666686E1135841333333333FEC174133333333E21358419A999999FBEB17419A999959E21358419A999999BFEB174100000080E21358413333333389EB174166666666E21358413333333331EB174133333313E213584166666666A6EA1741CDCCCC8CE1135841000000002AEA1741CDCCCC0CE1135841CDCCCCCCF2E917419A9999D9E01358410000000026E91741333333F3DF13584100000000CEE8174166666686DF13584133333333BFE8174100000080DF1358419A999999C3E8174166666626DE13584133333333C7E81741CDCCCCECDB13584166666666CAE81741333333D3D913584100000000CEE81741333333B3D41358419A999999E7E8174133333333D3135841CDCCCCCC2CE91741666666A6D3135841333333334DE91741333333F3D4135841000000007CE9174133333373D7135841666666669AE91741666666C6D713584133333333B7E91741CDCCCC6CD713584100000000D0E91741000000C0D4135841CDCCCCCCCAE91741000000A0CC13584100000000CEE9174166666606C813584166666666D6E9174166666686C413584133333333E3E917419A999919C01358419A999999E1E91741CDCCCC4CBE13584133333333D5E9174166666666BC1358419A999999B5E91741666666A6BA135841CDCCCCCC6CE91741333333B3B81358416666666642E9174100000020B71358416666666634E91741CDCCCCCCB51358413333333331E9174133333333B41358410000000034E917419A999939B21358419A9999994BE9174133333353B0135841666666666EE9174133333353AE13584100000000ACE91741333333B3AC13584133333333E1E91741CDCCCCACAB1358416666666600EA1741CDCCCCCCAA135841000000001AEA174166666666A91358413333333327EA17419A999939A71358419A9999992BEA174133333393A41358410000000028EA174166666686A01358413333333329EA1741333333939F1358419A99999997EA1741333333D39D13584166666666DCEA1741333333339D13584166666666FCEA17419A9999799D1358410000000024EB1741000000A09F1358419A9999993FEB174166666686A2135841333333335FEB174133333333A41358419A9999997DEB174166666666A4135841CDCCCCCC98EB174100000040A3135841CDCCCCCCB4EB174133333313A113584166666666E0EB1741333333339E13584166666666F2EB1741333333739D1358419A99999911EC1741000000609C1358419A99999931EC17419A9999199C1358419A99999953EC1741666666069C135841CDCCCCCC6EEC1741CDCCCC0C9C1358419A99999987EC1741333333B39C13584166666666A8EC1741333333139F13584133333333B1EC174166666606A013584166666666BEEC1741CDCCCC0CA213584100000000CAEC174133333373A3135841CDCCCCCCDAEC174166666666A4135841CDCCCCCCECEC17419A9999B9A41358410000000000ED17419A999999A41358416666666610ED1741CDCCCC4CA4135841CDCCCCCC22ED1741000000A0A3135841CDCCCCCC3AED174100000040A2135841CDCCCCCC52ED174133333313A01358419A99999969ED1741000000409C135841666666666CED17419A9999199A1358419A9999996BED17410000008098135841333333336BED17416666660698135841666666665EED17419A99993996135841000000004CED17410000000094135841000000004AED174100000080921358413333333349ED17410000002091135841CDCCCCCC48ED1741666666868F135841333333334DED1741666666668D1358416666666666ED1741CDCCCCCC861358419A99999993ED17419A9999F97E13584100000000BCED17413333337379135841CDCCCCCCD0ED17419A9999F9771358419A99999905EE174100000000751358413333333349EE1741CDCCCC8C71135841CDCCCCCC54EE17410000004070135841CDCCCCCC5CEE1741666666066F135841333333335DEE1741000000206E135841000000005CEE17419A9999D96C1358416666666658EE1741000000206C135841666666664EEE1741333333136B1358419A99999941EE1741CDCCCC0C6A135841666666662AEE1741333333B369135841CDCCCCCC0CEE17419A9999F9691358410000000002EE17419A9999D9691358419A999999FBED1741333333736913584100000000F8ED1741000000C06813584166666666F8ED1741333333B36713584133333333FFED17419A9999F9661358416666666608EE17419A99999966135841333333331FEE174100000020661358416666666658EE17419A999939651358416666666690EE17419A9999F963135841CDCCCCCCA4EE17419A9999996213584100000000B0EE17419A9999396013584166666666BCEE17413333335359135841CDCCCCCCC0EE1741CDCCCC0C5513584133333333CBEE1741CDCCCC4C5213584133333333CDEE1741333333535113584100000000CEEE17419A9999795013584166666666C8EE1741CDCCCC2C4D13584100000000CAEE1741333333D34913584100000000D2EE1741333333734513584100000000DEEE1741CDCCCC4C3E13584166666666EEEE1741CDCCCC0C3A1358419A999999F5EE174166666646361358416666666606EF1741333333B32F1358410000000014EF1741CDCCCC2C2A1358410000000022EF1741333333F3251358413333333329EF17416666664621135841CDCCCCCC36EF1741CDCCCCCC1A135841666666663CEF17419A999959191358416666666644EF174133333313171358419A99999941EF1741CDCCCCCC14135841CDCCCCCC4AEF1741333333D3121358419A99999955EF174133333393101358416666666654EF17419A9999F90D1358413333333351EF1741000000600B135841666666664EEF1741000000800A1358419A9999994BEF174133333393091358410000000032EF17419A999959071358416666666628EF174133333333051358419A99999925EF1741333333D3031358413333333327EF17419A9999B9021358419A99999929EF1741CDCCCC8C011358413333333329EF174100000060001358416666666626EF1741666666C6FE1258419A99999921EF1741CDCCCC2CFD125841CDCCCCCC18EF174100000080FB1258419A9999990FEF17419A9999F9F81258416666666608EF174166666686F61258413333333305EF174133333333F41258413333333303EF1741000000C0F11258410000000002EF1741333333B3EF1258416666666604EF1741000000A0ED1258413333333307EF174133333393EB1258419A99999905EF174133333393E91258413333333303EF174100000040E81258419A999999FFEE1741666666E6E612584100000000F8EE1741CDCCCC2CE4125841CDCCCCCCF2EE1741CDCCCC4CE11258419A999999EBEE174133333373DE12584166666666E6EE174100000080DC12584133333333E5EE17419A999999DA12584166666666E4EE17419A9999D9D8125841CDCCCCCCE4EE174133333373D6125841CDCCCCCCE4EE1741CDCCCC0CD412584133333333E3EE174166666646D112584100000000E2EE174166666666CE1258419A999999DFEE1741CDCCCC8CCB12584166666666DCEE1741CDCCCC4CC812584100000000D8EE17419A999919C512584133333333D3EE17419A9999F9C112584166666666CEEE174166666686BE1258419A999999C9EE1741CDCCCCCCBB12584133333333C5EE17419A9999B9B912584100000000C0EE174133333313B812584133333333BDEE174166666666B61258419A999999BBEE17419A999919B51258419A999999BBEE174166666626B312584133333333B3EE17419A999959AD1258419A999999ADEE174166666686AA1258416666666690EE1741CDCCCCEC911258413333333367EE174100000020841258410000000042EE1741666666A67E12584166666666DEED1741CDCCCCAC781258419A999999C7ED1741333333537412584133333333C1ED1741CDCCCC6C6F12584100000000BEED1741666666666C1258419A99999965ED174166666666661258419A99999937ED1741333333535D1258419A99999917ED1741CDCCCC8C56125841CDCCCCCC02ED17419A9999F951125841CDCCCCCCDAEC1741333333B34C12584133333333C9EC1741CDCCCCCC4712584100000000E8EC174133333393441258419A99999909ED17413333331342125841CDCCCCCC0EED1741333333934012584133333333F7EC174166666606391258419A999999E5EC17410000000033125841CDCCCCCCE4EC1741CDCCCC8C2C12584133333333FDEC1741666666A627125841CDCCCCCC3AED1741333333F3241258416666666686ED1741000000A01F125841CDCCCCCC8EED1741CDCCCC4C1E125841CDCCCCCC88ED1741333333931C125841666666665EED17419A9999791B1258416666666620ED1741CDCCCC8C1A125841CDCCCCCC00ED1741CDCCCCAC181258419A999999FDEC1741666666A6151258410000000014ED17410000006013125841CDCCCCCC7EED1741000000C00F125841333333339DED1741333333330E125841CDCCCCCCA2ED1741000000200C1258410000000086ED1741CDCCCCCC071258419A99999947ED17419A9999B9021258413333333347ED17413333337300125841333333333BED17419A9999B9FB1158410000000054ED1741000000C0F7115841000000007EED1741333333B3F411584133333333B3ED174166666626F311584100000000DAED17419A9999D9F011584100000000E8ED174166666606EE11584100000000DCED174133333313EA11584166666666D2ED1741CDCCCC6CE811584133333333D7ED174100000080E6115841CDCCCCCCE4ED1741CDCCCCECE4115841CDCCCCCCECED1741000000E0E211584166666666ECED17419A999999E111584166666666EEED1741333333D3DF11584166666666D8ED174133333353DA1158416666666694ED17419A9999B9D21158419A99999981ED1741CDCCCCACCE115841CDCCCCCC74ED174166666686C9115841000000005AED1741333333D3C21158413333333345ED17419A999999BF115841CDCCCCCC3AED1741CDCCCC2CBE1158419A9999993FED1741333333B3BB1158419A99999955ED1741CDCCCC8CB91158416666666664ED174100000080B71158416666666668ED17419A9999F9B61158419A99999977ED1741CDCCCC2CB4115841666666663EED174133333393AD1158419A999999E5EC174133333353A41158419A99999981EC1741666666A69A115841CDCCCCCC2CEC1741CDCCCC0C9211584100000000EEEB1741CDCCCCEC891158419A999999B3EB17419A999959821158416666666696EB1741CDCCCC2C7D115841CDCCCCCC90EB174166666606781158419A99999995EB17419A999919721158419A999999B5EB1741666666666B115841CDCCCCCCF6EB1741333333F361115841000000003EEC1741666666A6591158413333333385EC1741000000C050115841CDCCCCCCD0EC1741000000E048115841000000002EED1741CDCCCC8C411158419A99999999ED17419A9999393A1158416666666604EE1741CDCCCCAC351158413333333385EE17419A99993930115841000000000CEF1741CDCCCCEC2C115841CDCCCCCCB2EF17419A9999192A1158416666666670F017416666662628115841CDCCCCCC54F11741CDCCCC2C251158410000000004F217419A9999F9221158419A9999998FF21741CDCCCC6C2011584100000000FAF21741CDCCCC4C1D115841333333333BF31741000000E0191158416666666666F31741CDCCCCEC141158419A99999981F31741333333D30F1158416666666688F31741000000800E1158419A99999995F31741CDCCCC8C071158410000000098F31741CDCCCC0CFF1058419A99999981F3174133333353F71058416666666646F3174100000040F010584100000000E0F2174166666626E91058416666666656F21741000000C0E11058419A999999AFF117419A9999F9DA1058419A99999971F11741CDCCCCECD8105841CDCCCCCCF0F01741333333B3D41058419A99999971F0174166666666D11058419A999999D9EF174133333393CF1058413333333361EF1741CDCCCC4CCD10584100000000F4EE174133333393C91058413333333359EE1741CDCCCC2CC21058413333333383ED1741333333D3B710584100000000D2EC174166666666AD105841333333333DEC174133333353A310584133333333E1EB1741333333539B10584133333333A1EB1741CDCCCCEC931058419A99999975EB1741000000A08B10584166666666F4EA17419A9999B99210584133333333E3EA17419A9999599310584133333333ADEA1741333333B394105841CDCCCCCC64EA1741CDCCCC6C961058413333333303EA17419A9999D99910584166666666C0E91741CDCCCC4C9C105841CDCCCCCC96E91741333333F39E1058413333333387E9174100000020A11058419A99999985E9174166666686A2105841000000006EE917419A9999D9A01058419A99999937E91741CDCCCC8C9810584100000000FCE8174133333313901058419A999999C1E81741666666E688105841666666669AE81741CDCCCC8C83105841333333337BE81741000000607E1058410000000058E81741CDCCCC0C7A105841CDCCCCCC32E817419A99993976105841CDCCCCCC18E817419A999959731058416666666602E81741666666A66F1058419A999999DDE71741CDCCCCCC661058419A999999B7E71741333333F35D10584133333333A3E71741CDCCCCEC58105841333333338FE7174133333313541058410000000082E71741CDCCCC0C501058413333333381E71741CDCCCC8C4C105841000000007EE71741CDCCCC0C49105841CDCCCCCC60E717419A9999B944105841CDCCCCCC16E71741666666263C10584100000000BEE61741666666A6311058419A99999957E617413333331326105841CDCCCCCC06E61741666666C61C10584166666666D2E51741666666461610584100000000A4E517419A9999B9101058410000000074E517419A9999190C1058410000000042E517410000002009105841666666660CE51741333333730710584166666666F6E41741333333F306105841CDCCCCCCCEE417413333337305105841333333339BE41741CDCCCCCC01105841666666666EE417419A9999D9FC0F5841666666663EE41741CDCCCCACF60F5841CDCCCCCC1AE4174133333373F10F58410000000012E41741CDCCCCACED0F5841666666660AE4174166666686E40F58419A99999905E41741666666C6DD0F58413333333305E41741000000A0D70F5841CDCCCCCC04E41741333333F3D30F58416666666600E41741CDCCCCECD20F584133333333F9E317419A999999D20F584166666666E8E3174133333313D20F584133333333C3E3174166666626D20F58410000000014E3174166666646D40F58419A99999975E217419A9999F9D50F584133333333FDE117419A9999F9D60F584100000000BEE117419A9999B9D70F58416666666606E117419A9999B9D80F584100000000A2E0174133333353DB0F58419A99999913E01741CDCCCC2CDC0F5841CDCCCCCC92DF17419A9999F9DB0F5841666666660EDF17419A999999DA0F58419A99999977DE174100000000D80F584100000000B4DD17419A9999D9D40F584133333333F5DC1741000000E0D00F5841CDCCCCCC3EDC17419A999979CC0F5841CDCCCCCCA0DB1741000000A0C60F5841CDCCCCCC04DB1741CDCCCC6CC00F58410000000080DA1741000000A0BB0F58410000000004DA1741CDCCCCECB70F58410000000086D9174133333393B50F58419A999999E3D81741000000A0B40F5841666666663CD81741CDCCCC0CB50F58419A999999B3D7174133333393B60F5841333333332BD71741CDCCCC4CB90F5841000000005CD61741333333F3BC0F5841CDCCCCCCE4D51741000000C0BE0F5841CDCCCCCC54D5174166666646C00F584100000000A6D417419A999919C00F584166666666F0D31741000000C0BD0F58413333333341D317419A9999F9BC0F5841CDCCCCCCBAD2174100000040BC0F5841CDCCCCCC52D2174166666606BD0F584133333333FBD11741CDCCCCCCBE0F584133333333B9D11741000000A0C10F58419A9999996DD1174166666686C70F58419A99999937D117419A999999CE0F5841000000000AD1174100000060D60F584166666666E6D01741CDCCCCACDE0F584166666666A6D017419A999999E70F5841CDCCCCCC3CD01741CDCCCC6CF00F584166666666DECF174100000080F50F58413333333397CF174100000000F70F58419A99999951CF174133333373F70F5841333333331BCF174100000000F70F58419A999999E5CE174100000060F40F5841333333339DCE1741333333D3EF0F58419A99999963CE1741CDCCCCACE90F58410000000046CE17419A9999B9E20F58410000000028CE174133333393D70F58413333333305CE1741333333B3CF0F584166666666CACD17419A999979C80F5841666666667ACD174166666626C30F5841000000000ACD17419A9999F9BE0F5841CDCCCCCC9CCC1741666666C6BB0F5841666666663ACC1741CDCCCC4CB90F584100000000D2CB174166666666B80F58410000000058CB1741333333F3B80F58419A999999AFCA1741666666C6BB0F584166666666F2C9174166666626BF0F5841CDCCCCCC04C91741000000C0C20F58410000000028C8174100000060C60F5841666666666AC7174100000020CA0F584100000000C8C61741CDCCCCACCE0F5841000000002CC6174166666626D40F58416666666684C51741000000C0DB0F5841CDCCCCCCE0C41741666666A6E30F5841CDCCCCCC4CC417419A9999F9E90F58410000000098C317419A9999D9EC0F5841CDCCCCCC08C31741666666E6F80F58419A99999987C21741CDCCCC2C011058413333333323C21741333333930710584100000000CAC11741CDCCCC4C0B10584100000000B8C11741CDCCCCEC0B105841000000007EC11741000000000E105841CDCCCCCC30C11741333333531010584133333333D3C017413333335312105841666666661EC01741666666461410584166666666DCBF1741666666C6141058419A99999929BF1741CDCCCCCC141058419A9999998FBE1741000000C0121058419A999999DDBD1741000000E00F1058416666666630BD1741666666E61010584166666666C8BC1741333333D310105841CDCCCCCC32BC1741CDCCCC2C101058413333333319BB1741000000400D1058413333333349BA1741CDCCCCAC071058410000000060B9174133333313081058419A9999995DB81741666666E605105841666666666EB717419A9999F90210584100000000B2B6174100000020021058419A99999947B617413333337302105841333333334FB51741666666C6031058419A999999E1B417419A9999D9031058419A999999FFB317419A999979FF0F58419A99999953B317419A999919F70F584133333333E3B2174133333373EF0F5841666666668CB21741666666E6E60F58416666666640B2174133333373DA0F5841CDCCCCCC46B2174100000040D30F58410000000062B21741CDCCCC0CCC0F58416666666680B21741000000E0C40F58410000000090B217419A9999D9BD0F58419A999999ABB2174100000040B30F584100000000A8B2174133333333AD0F5841CDCCCCCC9EB217419A999939A40F58410000000092B21741000000409C0F5841333333337BB2174100000000960F58413333333355B2174133333333900F584166666666F0B11741333333B3870F58419A999999A1B11741000000C0840F58416666666608B11741000000C0810F5841666666668EB017419A999999800F58419A999999EDAF17419A999959800F5841CDCCCCCC30AF174166666626810F5841333333337DAE174100000040810F584166666666DAAD174100000060810F5841CDCCCCCCFEAC174100000080800F5841CDCCCCCC5CAC1741000000607F0F584166666666C0AB1741333333337F0F5841666666663CAB174133333313800F58413333333319AB1741333333F3800F584166666666ECAA1741CDCCCC0C820F5841333333335DAA174133333353860F5841666666660CAA1741000000E08B0F584133333333C7A91741333333B3970F5841CDCCCCCC92A91741CDCCCCECA10F58410000000082A91741CDCCCC0CA90F58413333333373A91741CDCCCCECB10F5841CDCCCCCC60A91741333333D3BB0F5841CDCCCCCC68A91741666666C6C50F5841CDCCCCCC7AA91741666666A6CD0F584100000000CEA91741333333D3DC0F58416666666624AA1741666666E6E70F5841CDCCCCCC7EAA1741CDCCCCCCF00F58419A999999F9AA1741666666E6F80F58410000000054AB1741666666C6011058419A999999D5AB1741000000C0091058413333333359AC1741CDCCCC8C0F10584100000000FEAC1741000000C019105841666666667CAD174100000060201058419A999999DBAD17419A99993927105841000000001EAE1741333333F32C105841666666663CAE174100000040311058419A99999951AE1741000000C0381058419A99999965AE17419A9999F9401058419A99999965AE174100000000451058416666666654AE1741333333334D1058410000000044AE174133333333551058410000000034AE1741333333D35C105841333333331BAE1741CDCCCC0C631058413333333305AE17419A9999F9691058419A999999E9AD1741000000007110584166666666BEAD1741666666A678105841000000009CAD1741CDCCCC8C7D105841CDCCCCCC7AAD17416666664683105841CDCCCCCC5AAD1741666666A687105841000000003AAD1741000000208C105841666666661AAD17419A9999998F10584133333333F7AC1741000000809210584166666666DCAC1741333333B39410584100000000C0AC1741CDCCCC2C971058419A99999953AD174100000000971058419A9999996DAD1741000000A096105841CDCCCCCC8AAD1741666666069610584166666666DEAD17416666660694105841000000002CAE1741666666C6901058419A99999977AE1741000000A08E10584166666666B8AE1741666666068D1058419A9999991FAF1741333333938A105841CDCCCCCC80AF1741CDCCCC6C891058419A999999C9AF1741CDCCCC8C8810584100000000D8AF17419A99995988105841000000003AB01741666666C6881058410000000070B01741CDCCCCAC8A1058419A999999CBB017419A9999598E1058413333333373B11741333333339810584100000000B2B11741000000809B1058416666666614B21741000000C09D1058413333333375B2174133333353A010584100000000F8B217419A9999B9A6105841CDCCCCCC26B31741CDCCCC2CAA1058416666666626B31741666666C6B01058413333333325B3174133333313B61058416666666644B31741CDCCCCACBA105841000000005CB3174100000080BC105841666666666AB3174133333353BD105841CDCCCCCC78B31741CDCCCCACBD1058410000000088B31741000000E0BD1058416666666698B31741CDCCCC0CBE10584100000000AAB3174133333313BE10584133333333C5B3174133333313BE1058419A999999DFB317419A9999F9BD10584133333333FDB31741333333D3BD1058419A99999919B41741CDCCCC8CBD1058419A99999931B4174100000080BD105841CDCCCCCC4AB4174133333353BD105841666666665EB4174166666626BD105841333333336FB4174166666626BD1058416666666680B41741333333D3BD1058416666666690B417419A9999F9BE1058419A9999999DB417419A999919C010584133333333ADB4174100000080C11058419A999999C5B4174100000080C3105841CDCCCCCCDCB41741000000E0C5105841333333331BB51741CDCCCCCCCA105841333333336FB51741CDCCCC8CD1105841666666669EB51741333333B3D610584133333333B3B51741666666E6D91058419A999999B7B51741CDCCCC0CDC10584133333333BFB51741333333B3DD10584166666666E0B517419A999919E01058419A99999901B6174133333393E1105841CDCCCCCC1EB617419A999939E3105841CDCCCCCC30B6174133333393E4105841000000004AB6174100000000E61058416666666660B61741CDCCCC8CE61058419A99999977B61741CDCCCC8CE61058413333333391B6174100000040E6105841CDCCCCCCA4B61741666666A6E510584133333333B9B61741000000C0E4105841CDCCCCCCCCB617419A999939E410584100000000E6B617419A9999F9E31058416666666602B71741CDCCCC0CE41058419A99999921B71741CDCCCC6CE4105841333333333BB7174100000020E5105841CDCCCCCC4CB71741666666A6E5105841000000005EB71741CDCCCC2CE61058410000000070B71741666666C6E6105841CDCCCCCC82B7174166666626E71058416666666696B7174133333313E710584100000000B0B717419A999999E6105841CDCCCCCCCCB717419A9999D9E510584133333333E9B7174166666606E510584100000000FAB71741666666C6E4105841CDCCCCCC0AB81741CDCCCC6CE5105841333333331FB81741333333B3E6105841333333332DB81741666666C6E71058410000000038B81741000000C0E8105841000000003CB8174133333333E91058419A999999E3B817419A999979EF1058410000000036B91741CDCCCC6CF4105841666666663EB91741000000E0F51058419A99999943B9174133333353FB105841333333335FB9174133333393FE10584133333333B3B917416666668605115841333333330DB91741666666A60A1158419A99999997B81741333333331C11584100000000FAB71741666666862B1158413333333383B7174133333393351158419A99999995B61741CDCCCC6C431158410000000046B61741333333F3451158419A99999921B6174133333373611158419A999999A1B51741666666066F115841CDCCCCCC14B51741CDCCCC4C831158419A9999994FB517419A9999F99411584100000000C2B4174133333353A0115841CDCCCCCC86B417419A999959A51158416666666648B3174100000040AE115841CDCCCCCC22B2174166666686B411584166666666D6AF1741CDCCCC0CB7115841CDCCCCCCCAAE1741333333B3BC115841666666664CAE174100000020C3115841CDCCCCCCAEAD174133333373D311584166666666C0AC1741CDCCCC0CE0115841CDCCCCCCE0A9174166666666F91158419A99999931A317419A99993930125841666666669898174133333393861258419A999999F990174133333373C8125841333333335B8017410000008046135841	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	01010000206A0800000A50B79663B91741000000F02C135841	400310000	Z	Bégaar	4003100	40031	40	75	28
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	01010000206A0800002C6A56CD0ECC1841000000D0674C5841	400320000	Z	Belhade	4003200	40032	40	75	29
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