SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep43;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep43 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep43','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep43','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep43','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep43"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000C58AC5FA6A7026419A9999F9FFAF5841	430010000	Z	Agnat	4300100	43001	43	84	20
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	01010000206A080000D825954F9C7E2741000000A0BB905841	430020000	Z	Aiguilhe	4300200	43002	43	84	1
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	01010000206A08000057A372B5F4032741666666360E9F5841	430030000	Z	Allègre	4300300	43003	43	84	24
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	01010000206A080000C8D0C655DAC12741666666C6C07F5841	430040000	Z	Alleyrac	4300400	43004	43	84	11
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	01060000206A080000010000000103000000010000003902000000000000D8E826419A999959828058419A999999D8E826419A9999198B8058416666666616E9264100000080A68058413333333334E9264100000080B08058419A999999A0E92641666666A6AC805841CDCCCCCC16EA264166666606A78058416666666692EA2641666666E69E8058410000000025EB26419A9999B99980584100000000CBEC2641000000409E8058416666666688ED2641CDCCCC4C9A80584166666666A6ED2641666666469A80584100000000DAF02641CDCCCCCCDA805841666666669DF02641000000C0EE8058413333333369F02641666666C6FC805841CDCCCCCC23F02641666666660A81584166666666C4EF26416666668619815841CDCCCCCC7FEF264100000020288158413333333328EF2641333333D34081584100000000B7EE2641000000C05D81584133333333A0EE2641333333B366815841666666667EEE26416666668678815841333333335CEE2641333333338481584100000000D3ED2641CDCCCCACA481584100000000C4ED2641CDCCCC2CA98158416666666687ED2641000000E0C38158410000000076ED26419A999979CF8158413333333375ED2641CDCCCC6CEA815841CDCCCCCC9DED26419A9999990282584133333333B1ED264166666666138258419A999999D2ED2641CDCCCCCC2682584100000000F2ED26419A999939318258416666666640EE2641666666E6428258419A99999954EE2641666666C64A8258419A9999992FEE2641CDCCCC8C5F8258410000000030EE2641000000E063825841CDCCCCCC7CEE2641CDCCCCAC61825841000000008BEF2641000000C062825841CDCCCCCC7FF02641666666A6868258419A999999ECF026419A9999398E8258410000000059F12641000000E09182584100000000C2F12641333333F3938258413333333360F1264133333313A18258410000000066F12641CDCCCC8CAF825841333333337FF1264166666646B482584100000000E2F12641CDCCCC4CBB8258416666666639F2264133333313C68258419A99999972F22641CDCCCC6CC98258419A99999995F2264100000060C98258419A9999993CF32641666666A6C28258416666666673F32641CDCCCC2CD182584166666666C4F3264133333353E1825841CDCCCCCCC5F32641CDCCCC0CF48258419A999999A9F32641CDCCCC8C0F8358419A99999982F32641333333931E835841666666667DF326419A9999B9268358416666666609F4264100000000328358419A9999992DF42641666666E635835841000000009BF42641000000C03D8358410000000007F5264133333373428358419A99999933F52641CDCCCC0C468358410000000074F526419A999959518358419A9999997FF52641CDCCCCCC57835841333333337FF526419A9999396A8358419A9999999BF526419A9999797B83584166666666D2F526419A9999798D8358410000000018F62641666666C6A9835841666666663BF626419A9999D9B28358419A99999977F62641CDCCCCCCBB8358416666666614F7264166666626D78358419A9999996DF72641CDCCCC8CE28358419A999999C2F72641CDCCCC0CF2835841CDCCCCCC1AF8264100000040F88358413333333357F82641CDCCCC0C018458416666666653F82641CDCCCCEC0D8458416666666693F826419A9999791F8458419A999999D0F826413333339332845841333333330DF9264100000080498458419A9999992DF9264133333313608458413333333348F92641333333F397845841CDCCCCCC6AF92641333333B3B1845841000000008DF9264100000060C184584133333333A9F926419A9999D9C884584166666666C7F926419A999919CB8458410000000018FA2641000000E0CC8458416666666663FA26419A999999CB8458419A99999945FB2641000000A0C1845841000000009EFB2641666666C6DB8458419A999999AAFB26419A999999E68458410000000097FB2641000000A0FC8458416666666673FB264100000000128558419A99999970FB264133333393168558416666666687FB264100000060208558419A999999A5FB26419A9999792785584133333333D7FB2641000000C02E8558419A99999902FC26419A99997932855841CDCCCCCC37FC26419A9999993485584166666666A3FC2641666666263B85584133333333BDFC26419A9999594085584133333333D4FC2641CDCCCCEC4E8558419A999999CEFC2641333333535C85584133333333B7FC2641CDCCCCAC698558419A999999C5FC26419A9999196E8558416666666653FD2641000000A05E855841000000002DFE2641CDCCCC6C4085584166666666B7FE2641CDCCCC8C28855841CDCCCCCCFDFE264100000080148558416666666638FF26413333337300855841CDCCCCCCAFFF264133333393F784584100000000FFFF264100000080ED845841CDCCCCCCDA00274166666646ED8458416666666663012741666666A6EA845841333333335B01274166666686E48458419A9999991F012741333333B3C784584133333333370127419A9999D9C4845841333333334901274133333333BE845841CDCCCCCC85012741000000A0B684584133333333C70127419A9999D9B3845841000000004802274133333333AC845841333333338302274166666626A284584166666666B40227419A99999995845841CDCCCCCCD00227419A999919808458416666666601032741CDCCCCCC6A8458419A99999932032741666666C66084584133333333770327419A9999B94C8458410000000063032741000000404A845841CDCCCCCC62032741000000404584584100000000F90327419A9999992E84584133333333790427410000008015845841CDCCCCCC7704274166666646008458419A9999996705274100000080018458413333333357062741000000C0FE835841CDCCCCCCC4062741666666A6F9835841333333333C07274166666606F283584133333333A9072741CDCCCC2CE483584100000000E4072741000000E0D383584100000000E3072741666666E6C483584100000000C4072741CDCCCCACB5835841666666663207274133333373C0835841CDCCCCCCB306274133333333D08358413333333361062741666666E6D383584133333333D70527419A9999F9D5835841333333336405274100000040D283584100000000F60427419A999939C7835841CDCCCCCCA204274100000080C2835841666666667404274166666646C283584166666666AA032741CDCCCC0CAE83584133333333A003274133333313A98358419A999999D103274166666686A1835841CDCCCCCC70042741000000A098835841333333338E0427419A9999199183584133333333AB042741333333538383584166666666DC042741CDCCCC8C75835841CDCCCCCCDB042741CDCCCC0C6E8358413333333376042741CDCCCC6C56835841CDCCCCCC6B04274133333333508358410000000093042741CDCCCC6C4283584100000000EB0427419A9999D926835841333333331D052741333333D30D835841CDCCCCCCB7042741333333B3F882584100000000C104274133333333EC8258419A999999C604274100000080AC825841000000001C04274133333333A0825841CDCCCCCC070427419A9999799C8258419A999999060427419A9999398D825841CDCCCCCC6C042741666666C69582584133333333920427419A9999598882584166666666360427419A9999796A8258419A9999992C0427419A9999F95D8258419A99999967042741333333B36182584100000000E50427419A9999B967825841666666660905274166666606688258413333333324052741CDCCCC2C648258416666666644052741333333735982584100000000630527419A9999F9558258419A99999996052741CDCCCC8C5582584133333333F1052741CDCCCC4C5A8258419A9999993B0627413333333348825841CDCCCCCCBB0627419A99999931825841CDCCCCCC320727419A999979228258413333333396072741000000201C82584133333333E6072741CDCCCC0C1C82584100000000B4092741000000402182584133333333E8092741000000E01D8258419A9999995F0A2741000000C00C82584166666666B30A2741333333D3FC8158419A999999E40A2741666666C6FB8158419A999999650B27419A9999F9FE81584166666666AC0B27419A999959FE81584166666666250C274100000020F9815841CDCCCCCC8E0B27419A999959DB815841CDCCCCCC750B2741CDCCCC4CD581584166666666570B274166666646D681584166666666100B27419A999939CB81584133333333970B274100000060C2815841CDCCCCCCD10B274133333393AF81584100000000020C2741CDCCCC4C9581584166666666010C2741333333538B8158419A999999130C2741333333937381584100000000310C2741CDCCCC8C69815841666666666C0C274100000000628158419A999999330D2741CDCCCC4C57815841CDCCCCCC0E0D2741666666864E81584100000000F80C27419A9999593F8158419A999999DA0C2741000000E039815841CDCCCCCC9A0C2741CDCCCC8C3481584100000000400C2741666666063381584100000000CD0B2741CDCCCC4C3381584100000000D30B2741333333B32D8158419A9999996E0C274100000060238158419A999999F50C2741CDCCCC6C18815841000000006D0D2741CDCCCC8C15815841CDCCCCCCBC0D2741333333731581584100000000530E2741CDCCCC4C1A81584166666666070F27419A9999D9228158419A999999570F274100000040258158419A999999290F2741CDCCCCAC0781584100000000C51027419A999939F0805841000000001A11274133333373FC8058410000000055122741000000C0ED805841333333337D122741CDCCCC6CD680584166666666F712274166666606D88058419A9999990E132741CDCCCC2CC58058413333333337132741CDCCCC0CB98058419A9999998F1327419A999979A280584100000000AD1327419A9999B99980584166666666921327413333333390805841CDCCCCCCE9132741666666068C80584166666666FE132741CDCCCC8C8280584166666666DC1327413333333377805841CDCCCCCCDE1327419A9999F97080584100000000F51327413333339369805841666666662B142741000000605D805841333333334B1427419A9999D95880584100000000A1142741CDCCCCCC568058419A999999EA142741000000005880584166666666251527419A999939578058419A99999981152741666666265180584133333333FA152741CDCCCC4C3B8058410000000021162741333333733780584100000000771627416666666632805841CDCCCCCCB2162741CDCCCC2C298058419A999999D4162741CDCCCC2C1A8058416666666603172741666666A60A8058419A999999301727413333337303805841000000008917274166666606F97F584166666666BB17274166666686EF7F5841CDCCCCCC0B182741666666E6E77F5841000000002F182741666666A6DF7F5841CDCCCCCC2C18274133333373D97F5841CDCCCCCCFF17274166666606C47F58416666666612182741CDCCCCACA47F5841CDCCCCCC7018274100000040857F584166666666CD1827419A9999D97A7F58419A999999F9182741333333D3777F5841000000009F192741333333B3737F58419A999999211A27419A9999796C7F5841CDCCCCCC491A2741CDCCCCEC687F5841CDCCCCCC621A27419A9999F9637F58419A999999801A2741CDCCCC2C577F5841666666663519274100000080437F5841CDCCCCCC691927419A9999B9357F584166666666FE1927419A999999277F58419A999999931A2741333333731D7F5841CDCCCCCCB91A2741CDCCCC2C037F584166666666C21A274133333333F07E58419A999999B71A27419A999979E27E584166666666B51A2741666666E6CB7E58419A999999EE1A2741666666A6C87E584100000000011B274166666646C27E584100000000FB1A274133333333BC7E584100000000BF1A2741CDCCCCACA87E5841CDCCCCCC591A274100000020A97E58419A9999994E1A274166666666967E58419A999999071A2741000000C0887E584166666666E7192741CDCCCCCC6F7E5841CDCCCCCC3D1927419A9999B9697E584133333333C318274166666626437E58410000000042182741666666064C7E58413333333310182741333333534D7E5841CDCCCCCC72172741CDCCCCCC477E5841000000007917274100000080417E5841CDCCCCCCD6172741CDCCCC8C257E584166666666F4172741000000401E7E5841CDCCCCCCBE1727419A9999391A7E5841CDCCCCCC64172741CDCCCC4C1A7E5841666666660B172741666666A6207E584100000000C41627419A999979297E5841000000008F162741000000A0377E58419A9999995A16274133333353367E5841000000000A16274133333393367E5841CDCCCCCCD515274133333333407E584100000000D6152741333333F3437E5841CDCCCCCC9A152741000000404F7E5841000000007D15274166666686507E5841000000002C15274100000060407E58419A99999921152741666666663B7E58419A999999AC152741000000802D7E584100000000E8152741333333F3257E584133333333FB152741333333F31B7E5841000000000616274133333333097E58419A9999990A152741333333730E7E584100000000001527419A999939047E5841666666660614274100000040087E5841CDCCCCCCD3132741CDCCCC0CFD7D5841333333338D132741666666A6F57D58416666666692122741CDCCCC6CE47D5841333333332E122741666666C6E07D5841CDCCCCCCFC11274133333393E97D584100000000DF1127419A999919EC7D58419A999999CA112741000000A0E47D584133333333C911274166666666CF7D58416666666605122741000000A0B77D5841666666660E122741000000A0A87D584166666666F011274166666666A77D58413333333351112741CDCCCC4CB07D58416666666651112741CDCCCC0CB47D5841000000007811274100000040BF7D5841333333330B1127419A999919CD7D584133333333ED10274166666666CE7D5841CDCCCCCCA61027419A9999B9C57D5841000000008910274100000080C97D5841000000002A102741CDCCCC8CDC7D58419A999999E70F27419A999979D47D584166666666C00F27419A999939BD7D5841000000002A0F2741666666E6B57D58419A9999990B0F2741CDCCCC6CAE7D584133333333B10E274166666646A87D58419A999999610E27419A999959AD7D58419A999999050D274133333373C57D58419A999999BF0C274166666686C57D584100000000820C27419A9999F9C37D584133333333520C27419A9999D9BC7D5841CDCCCCCC390C274133333353BD7D5841CDCCCCCCDD0B2741333333B3B57D58419A999999710B2741666666E6AA7D58419A9999993C0B27419A9999F9A37D5841CDCCCCCC390B2741000000609F7D5841000000001F0B27419A999999987D584166666666D50A2741666666E68C7D584166666666600A274133333393867D584166666666270A2741CDCCCC4C7C7D5841CDCCCCCCCB092741CDCCCCAC647D5841333333337F0A2741000000005D7D584166666666200B274133333373577D58419A999999E70A2741333333133C7D5841CDCCCCCCB00A27419A999999337D584100000000780A2741666666C62E7D5841666666666F092741CDCCCC6C237D58419A999999EF082741CDCCCC8C1E7D584166666666C1072741000000C0177D58419A99999971072741CDCCCCAC187D58416666666636072741000000E0147D584133333333C90627419A999919147D58419A9999997D06274100000060157D58416666666621062741333333B31D7D5841CDCCCCCCFB05274133333333267D584133333333C2052741333333132E7D58419A999999DD052741CDCCCC8C377D584100000000EF052741CDCCCCEC4E7D584100000000CE0527419A9999D95C7D584166666666CB052741333333B37C7D584100000000E90527419A9999B98F7D58416666666627062741CDCCCC0CA07D58419A9999998606274166666626AE7D584100000000D60627419A999979B87D58410000000037072741CDCCCCECC07D5841666666668407274100000000C47D58419A999999FD07274133333333C57D5841666666666908274100000000C57D5841CDCCCCCCAE0827419A999999C37D584100000000F608274133333353BE7D58416666666649092741333333B3BB7D5841666666669209274166666626BB7D5841CDCCCCCCD109274133333393BC7D584166666666160A274133333333C27D58419A9999993A0A2741333333F3C97D5841000000005A0A274100000000F27D5841CDCCCCCC520A2741000000E0027E5841CDCCCCCC1E0A27419A999999107E584133333333BA09274166666666227E584133333333950927419A9999D9277E584100000000690927419A9999F9297E584166666666ED082741333333132C7E5841CDCCCCCC16082741666666462E7E58419A9999992B072741666666E62F7E5841666666669D0627419A9999392E7E58419A99999936062741CDCCCCAC2F7E58419A999999AC0527419A9999D9327E58419A999999800527419A9999D9357E584100000000500527419A9999793B7E5841CDCCCCCC3705274166666626447E58416666666676052741333333F3557E58419A9999998D05274100000020587E5841CDCCCCCCF705274166666646597E5841CDCCCCCC48062741000000605C7E584166666666B5062741CDCCCCCC617E58419A999999DF0627419A999939667E5841CDCCCCCCF1062741666666E6727E5841CDCCCCCCDA062741333333F3817E58419A999999E7062741666666C68B7E58413333333322072741CDCCCCAC917E584166666666D507274100000040977E5841000000003F082741666666C6997E5841000000007908274133333313A07E5841CDCCCCCCA9082741333333B3A87E584100000000BD0827419A9999D9AF7E584166666666B6082741000000E0BA7E5841666666668008274133333373D67E5841666666666F082741CDCCCCCCE77E5841CDCCCCCC6C082741666666A6FA7E58419A9999997D082741333333D31D7F5841333333337E082741666666662D7F58419A9999996B08274133333373367F584100000000430827419A9999B93E7F58419A999999130827419A999979457F58419A999999B3072741333333D35C7F58413333333348072741CDCCCCEC687F5841CDCCCCCCAF062741000000A07F7F5841CDCCCCCC52062741333333138B7F58419A999999F7052741CDCCCC8C927F584133333333BA042741CDCCCC6CA87F5841333333339A04274133333393AE7F58413333333386042741CDCCCC6CBE7F58413333333347042741CDCCCC6CCB7F584133333333F0032741CDCCCC4CD77F5841CDCCCCCCC003274100000080DB7F5841333333337603274166666666DF7F584100000000290327419A999999E17F58419A999999A602274133333393E07F5841666666665C0227419A9999F9DA7F5841CDCCCCCC4B02274133333353D77F58416666666640022741000000E0C67F584166666666F2012741CDCCCC8CB87F5841CDCCCCCC6B012741666666E6A77F58416666666643012741CDCCCC0CA57F584133333333D6002741333333D39F7F58419A99999925002741333333B3947F58419A999999E3FF2641666666868F7F58419A99999996FF26419A9999398C7F5841666666664BFF2641CDCCCCEC847F58413333333319FF26419A999999817F584133333333DDFE2641333333F3807F5841CDCCCCCC72FE2641333333D3827F58419A99999920FE264133333313837F58410000000038FE2641333333137B7F58416666666631FE26419A9999D9747F58413333333300FE2641666666E6697F584166666666F0FD2641000000605F7F58419A9999993DFE26419A9999D9497F5841666666666EFE2641CDCCCC4C387F58416666666681FE2641CDCCCCCC2B7F584133333333D1FE26419A999939297F584166666666E5FE2641333333B32B7F58413333333337FF264133333353487F584133333333E1FF2641666666A64A7F584100000000FFFF264100000020487F584133333333250027419A9999D92D7F5841666666665F00274100000000257F58416666666653002741000000C01F7F58410000000020002741666666E61D7F5841000000000F0027419A9999F9127F58419A999999CBFF264100000080047F584100000000BCFF264133333373FE7E58419A9999999CFE264133333353017F5841CDCCCCCC4CFE2641666666A6027F58419A999999FAFD264166666646E27E584133333333DCFD2641CDCCCC0CDC7E58413333333396FD264100000020DC7E5841666666664FFD26419A999979CF7E5841CDCCCCCCD0FC2641CDCCCC4CCA7E58416666666694FC2641CDCCCCCCD57E5841CDCCCCCCFBFB2641333333D3CF7E58419A999999ACFB2641666666A6D87E5841000000002EFB2641CDCCCCACE37E5841666666669DFA26419A9999B9DA7E58419A99999973FA2641666666A6D67E5841000000001FFA264166666606CB7E58419A9999990DFA264166666626C67E58410000000061FA2641666666C6BE7E5841CDCCCCCC91FA264100000000AC7E58410000000092FA264166666686907E5841CDCCCCCC87FA2641666666068E7E584166666666DEF926419A9999D98E7E58419A9999999EF9264166666646937E5841666666664AF92641CDCCCC4C9B7E5841CDCCCCCC3CF92641000000A0997E58419A999999F5F826419A9999F9867E58416666666600F926419A999979757E584133333333B0F82641CDCCCCCC717E58410000000088F826419A9999996B7E58419A999999A0F72641000000E04A7E5841333333331BF72641000000E0397E5841CDCCCCCCDAF62641666666C62F7E5841CDCCCCCCB5F62641000000402C7E58419A99999972F626419A9999B9337E58413333333315F626419A999919297E5841CDCCCCCC52F52641333333F3187E584133333333A1F42641000000400F7E58419A9999997DF42641666666C61D7E58419A99999919F426419A999919387E58419A999999FBF3264166666666397E58413333333397F32641000000C0307E58410000000097F32641000000402E7E58410000000019F42641666666E6137E5841000000004BF42641CDCCCC8C087E58419A999999B2F326419A999979FA7D5841666666665AF32641666666C6EF7D584133333333BBF22641000000A0F97D58410000000014F22641000000C0017E58416666666604F2264166666686FA7D584133333333DBF126419A999979F57D58416666666616F12641666666A60D7E584100000000DEF02641333333130B7E5841CDCCCCCC94F02641000000E00A7E5841333333335AF026419A9999B9087E58413333333356F0264133333373F97D5841CDCCCCCC4BF0264133333333F37D58410000000073F02641CDCCCCACE67D584166666666B5F02641CDCCCC8CDB7D58413333333351F026419A999939CE7D584133333333E6EF264133333353DA7D5841CDCCCCCC78EF2641333333B3E07D584133333333BAEE2641666666E6D67D584166666666A6EE2641CDCCCC6CD97D5841CDCCCCCC61EE26419A9999F9EA7D58413333333327EE264166666646007E58419A9999990AEE264166666686157E584133333333FDEC264133333393197E5841CDCCCCCCADEC2641666666E61F7E584100000000F7EB2641333333D3387E58419A999999B1EB2641333333733D7E5841000000008AEB264133333333467E58413333333370EB2641666666A6477E584100000000C5EA2641333333335E7E5841CDCCCCCCB4EA2641000000E0647E584133333333C9EA2641333333D3697E58413333333308EB26419A9999F9967E58419A99999913EB264133333333AC7E58413333333331EB264166666626C57E5841CDCCCCCC30EB2641666666C6E97E58419A9999994FEB2641666666A6EF7E584100000000A6EB264166666646F57E58419A9999992EEC264133333353F97E58419A9999993AEC264166666686187F58419A999999A9EC2641666666A6287F584166666666F0EC2641CDCCCC0C357F58419A999999DAEC264166666626507F5841000000008FEC2641666666664E7F58419A99999928EC2641333333D34D7F5841666666662BEC26419A9999395D7F58410000000036EC264133333333677F5841CDCCCCCCAEEC264133333393737F584133333333ECEC26419A9999F9897F5841000000001FED2641CDCCCC6C967F5841333333338EED264166666606A97F58419A9999996BEE264166666606C37F5841CDCCCCCC6BEE264166666686C57F5841CDCCCCCC1CEE26419A999959D37F58419A99999997EB2641CDCCCC2C2F805841333333330FEB26413333333341805841CDCCCCCCC4EA26419A9999993F805841CDCCCCCCAFE92641CDCCCC2C458058410000000045E92641000000A046805841CDCCCCCC24E926413333331354805841000000002FE92641CDCCCC8C56805841000000003AE9264166666686658058416666666626E92641CDCCCC0C6D80584100000000D8E826419A9999598280584100000000D8E826419A99995982805841	01010000206A0800002ADA9D3A11FE2641666666B641815841	430050000	Z	Alleyras	4300500	43005	43	84	25
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	01010000206A080000986294E3EC1F2641CDCCCCBCF59A5841	430060000	Z	Ally	4300600	43006	43	84	31
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	01010000206A08000059930368432E2841666666666B925841	430070000	Z	Araules	4300700	43007	43	84	32
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	01010000206A0800005D06C8B6D8892741000000F0AD7C5841	430080000	Z	Arlempdes	4300800	43008	43	84	14
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	01010000206A0800005707CF12C8582641CDCCCC8CC7965841	430090000	Z	Arlet	4300900	43009	43	84	6
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	01010000206A0800006BDDA5A514A4274100000070258A5841	430100000	Z	Arsac-en-Velay	4301000	43010	43	84	12
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	01010000206A080000EC6C4A25426F26419A99994972985841	430110000	Z	Aubazat	4301100	43011	43	84	17
01060000206A0800000100000001030000000100000002080000CDCCCCCC1E2228419A999979B3B3584100000000AD22284133333373BDB358419A999999952228419A9999F9C5B35841666666664D232841CDCCCCECC6B35841333333338F23284166666646C7B3584100000000F123284133333373C8B35841CDCCCCCC2E24284166666626CCB35841CDCCCCCC3C2428419A999959CCB35841333333334A242841333333B3CCB35841CDCCCCCC5624284133333353CDB358419A999999692428419A9999F9CCB35841333333338F24284133333353CCB3584133333333A124284133333373CCB3584166666666AF24284100000000CDB3584166666666C0242841666666E6CDB35841CDCCCCCCCD2428419A999959CEB35841CDCCCCCCD324284133333393CEB3584133333333F324284166666686CFB358419A9999990325284166666606D0B35841CDCCCCCC1F252841000000E0D0B358416666666629252841000000A0D1B35841CDCCCCCC3F252841CDCCCC2CD3B3584166666666562528419A999959D4B35841666666666825284166666646D5B358419A9999996F2528419A999999D5B35841CDCCCCCC83252841000000A0D6B35841000000009725284100000080D7B3584166666666A6252841000000E0D7B3584133333333B1252841CDCCCCECD8B3584166666666C325284133333333DAB3584100000000D22528419A999999DAB358419A999999002628419A9999F9D8B35841666666662726284100000060D7B358416666666632262841333333F3D6B35841CDCCCCCC5C26284100000060D5B35841333333337126284100000060D5B35841000000007F26284133333393D5B358419A9999998A2628419A9999B9D5B35841CDCCCCCC972628419A999959D6B35841000000009A2628419A999959D7B3584166666666AE2628419A999919DCB358419A999999C6262841CDCCCCACE0B3584100000000EA26284133333353E5B3584133333333FD262841CDCCCC4CE7B35841CDCCCCCC14272841CDCCCCECE7B35841000000002427284166666646E8B35841000000002F272841333333D3E8B35841CDCCCCCC3A2728419A9999B9E9B358413333333348272841333333D3E9B35841CDCCCCCC6E27284166666646EAB358419A9999997E272841CDCCCC8CEAB35841666666668A272841CDCCCC8CEAB358419A99999995272841CDCCCCECE9B3584166666666A1272841333333B3E8B3584100000000AD272841333333B3E7B3584166666666B92728419A9999B9E6B3584133333333C2272841333333D3E5B3584133333333CE272841333333B3E5B358419A999999DB272841CDCCCC2CE5B358419A999999E727284100000020E4B3584133333333F6272841CDCCCC4CE3B35841666666660228284166666626E3B35841CDCCCCCC15282841333333B3E3B35841CDCCCCCC26282841CDCCCCACE4B35841333333333A282841333333F3E5B358419A9999994D282841666666E6E6B35841CDCCCCCC5E2828419A9999B9E7B358419A9999996E28284133333373E8B35841000000007C282841CDCCCC4CE9B358419A9999998D282841000000A0EAB35841666666669A282841CDCCCC2CECB3584100000000A62828419A999959EDB35841CDCCCCCCB2282841333333D3EDB35841CDCCCCCCC0282841CDCCCC4CEEB3584166666666D02828419A9999B9EEB358419A999999DF2828419A9999F9EEB3584100000000F028284133333373EFB35841CDCCCCCCFC28284166666646EFB35841000000000429284133333333EEB3584100000000082928419A9999D9ECB35841333333330E29284133333393EBB358419A9999991729284133333313EBB358419A99999921292841666666A6E9B35841333333332D292841CDCCCC0CE9B358419A9999993A2928419A9999B9E9B35841333333334629284133333333E9B3584133333333542928419A999919E8B35841CDCCCCCC5F292841000000C0E6B358416666666663292841CDCCCC2CE6B3584133333333682928419A999979E5B35841333333337E2928419A999939E4B35841CDCCCCCC8729284133333313E3B358419A999999912928419A9999D9E1B358419A9999999829284100000040E0B35841666666669C2928419A999999DEB3584100000000A629284166666666DDB35841CDCCCCCCB32928419A9999D9DCB358419A999999C0292841333333D3DCB35841CDCCCCCCD029284133333313DDB3584100000000E02928419A9999B9DDB358419A999999F0292841CDCCCC8CDDB3584100000000112A2841CDCCCCACDDB3584100000000242A284166666626DDB3584166666666372A2841333333D3DCB3584166666666452A2841000000A0DCB3584133333333572A284133333333DCB3584166666666682A284100000000DCB3584166666666752A2841CDCCCC8CDBB3584166666666822A2841CDCCCC4CDAB35841CDCCCCCC8B2A2841000000E0D8B3584100000000942A284100000080D7B35841CDCCCCCCA12A2841CDCCCC2CD6B358419A999999B42A28419A999939D5B358419A999999B42A284166666686D6B358419A999999B42A2841CDCCCCCCD6B35841CDCCCCCCB22A284133333353D8B3584166666666B02A2841CDCCCC0CDAB358419A999999AD2A28419A9999B9DBB3584166666666A92A28419A9999B9DDB3584100000000A52A284166666646DFB35841666666669F2A2841000000A0E0B3584166666666962A284166666626E2B35841666666668D2A284100000080E3B3584133333333822A2841CDCCCCACE4B3584133333333752A2841333333D3E5B35841000000006D2A2841CDCCCCECE6B3584133333333512A28419A9999B9EAB35841333333334A2A284166666626ECB35841CDCCCCCC432A28419A999999EDB35841CDCCCCCC3A2A2841CDCCCCCCEEB358419A9999992F2A28419A999919F0B358419A999999282A284100000000F1B358419A999999222A28419A9999D9F1B35841666666661E2A284166666626F3B358419A9999991C2A2841666666C6F4B3584166666666172A28419A999999F6B3584166666666132A2841CDCCCC6CF8B35841CDCCCCCC0E2A284166666606FAB358419A999999082A2841666666A6FBB3584100000000FF29284100000000FDB35841CDCCCCCCF229284133333333FEB3584133333333E7292841000000C0FEB35841CDCCCCCCDB292841000000E0FEB3584133333333CE292841666666E6FEB3584166666666C229284100000000FFB3584100000000B929284133333333FFB3584133333333B029284166666686FFB3584166666666AA2928410000000000B458419A999999A42928410000000001B4584100000000A22928410000008002B45841CDCCCCCCA02928410000002004B4584166666666A12928410000008005B4584133333333A32928416666666607B458419A999999A42928419A99991909B4584100000000A6292841000000A00AB458419A999999A8292841666666860CB4584133333333AB292841000000600EB45841CDCCCCCCAE292841CDCCCC0C10B458419A999999B32928410000006011B4584100000000B9292841666666E612B4584100000000BF2928413333335314B4584100000000C52928419A99999915B4584100000000CD292841666666E616B4584133333333D32928413333335318B4584133333333DA292841CDCCCC4C1AB4584133333333DF292841CDCCCC2C1CB458419A999999E3292841333333F31DB4584100000000E62928419A9999991FB45841CDCCCCCCE4292841CDCCCC4C21B4584133333333E1292841333333F322B45841CDCCCCCCDC292841666666C624B4584133333333D82928416666668626B4584100000000D52928419A9999B928B4584133333333D4292841CDCCCCCC2AB458419A999999D4292841333333532CB4584166666666D5292841333333D32DB4584100000000D6292841000000802FB4584166666666D72928416666660631B4584100000000D82928416666664632B4584166666666D6292841333333F333B45841CDCCCCCCD2292841333333F334B45841CDCCCCCCCB2928413333333336B4584100000000C3292841CDCCCC4C37B4584133333333BC292841CDCCCCEC38B4584100000000BA292841000000403AB4584100000000B6292841CDCCCCAC3BB45841CDCCCCCCB12928419A9999B93CB4584133333333AD292841333333D33DB4584100000000A7292841000000E03EB4584100000000A12928413333333340B458419A9999999C2928413333339343B45841CDCCCCCC972928419A99997945B45841CDCCCCCC94292841666666C646B45841CDCCCCCC902928410000006048B45841666666668B2928413333331349B458410000000083292841333333D349B45841666666667C292841333333B34AB45841CDCCCCCC75292841CDCCCC6C4CB4584100000000712928419A9999F94DB45841333333336B292841666666664FB4584133333333662928419A9999F950B4584100000000612928413333339352B45841000000005A292841333333B353B4584100000000522928419A9999B954B45841CDCCCCCC522928410000004056B458413333333354292841CDCCCCAC57B45841CDCCCCCC54292841666666C659B458419A99999954292841CDCCCCEC5BB458416666666654292841666666065EB458416666666655292841000000C061B4584133333333572928413333331364B458419A99999959292841333333B365B45841666666665A2928419A99993967B45841CDCCCCCC592928419A99993968B4584100000000582928413333333369B458416666666656292841666666066AB45841000000005A292841000000A06BB45841CDCCCCCC5F292841666666666DB458416666666667292841333333F36EB45841000000006F2928419A99995970B45841CDCCCCCC752928410000000072B4584166666666772928419A9999D973B4584133333333732928416666662675B45841666666666D292841333333F376B45841000000006A292841333333D378B45841CDCCCCCC6A292841CDCCCC4C7AB45841333333336A292841333333337CB458416666666667292841000000007EB458413333333365292841CDCCCC0C80B45841000000005F292841CDCCCCAC81B45841666666665A292841CDCCCC2C83B45841CDCCCCCC5A292841666666C684B45841CDCCCCCC592928419A99995986B4584166666666542928416666660688B45841333333334E2928416666668689B458416666666647292841333333F38AB4584133333333452928419A9999D98CB4584100000000462928419A9999198FB4584100000000482928419A9999F990B45841CDCCCCCC47292841CDCCCCEC92B4584133333333462928419A9999D994B45841CDCCCCCC3E2928419A99991997B4584166666666372928416666660699B458419A99999930292841333333939BB45841CDCCCCCC2E292841333333339CB45841000000002B292841333333739DB458410000000025292841000000809FB45841CDCCCCCC1B29284133333373A1B45841333333331329284133333313A4B45841000000000D2928419A9999B9A6B45841CDCCCCCC0A292841333333F3A8B458416666666606292841333333B3ABB458419A9999990229284100000080ADB458419A999999FF28284166666626AFB45841000000000429284166666686B2B45841CDCCCCCC0529284166666646B4B45841333333330F29284166666626B7B4584100000000152928419A999999B8B45841CDCCCCCC1429284133333313BBB45841CDCCCCCC0F292841CDCCCCCCBCB4584133333333072928419A999919BEB45841CDCCCCCCFB282841CDCCCC8CBFB458419A999999F7282841CDCCCC4CC1B4584100000000F92828419A999959C3B45841CDCCCCCCFE28284100000080C5B458419A99999906292841333333B3C7B45841CDCCCCCC0B2928419A999959C9B45841333333330E292841CDCCCCACCBB45841CDCCCCCC0D29284133333393CDB45841000000000A29284100000000CFB45841333333330429284100000020D0B4584100000000F3282841666666C6D1B4584133333333E128284133333333D4B4584166666666DB282841CDCCCC6CD5B458419A999999D4282841666666A6D7B4584100000000CE282841666666C6DAB4584100000000CB282841CDCCCC6CDDB4584100000000C428284133333333E0B45841CDCCCCCCBB28284166666646E2B45841CDCCCCCCB0282841666666A6E4B458419A999999A6282841CDCCCC4CE6B45841000000009B2828419A999979E7B45841666666668B2828419A9999D9E8B45841000000007F28284100000060EAB4584166666666742828419A999979EBB45841CDCCCCCC652828419A999919ECB45841000000005B28284133333393EBB45841CDCCCCCC50282841000000E0E9B45841CDCCCCCC47282841CDCCCC6CE8B458419A999999402828419A999919E7B45841CDCCCCCC39282841000000E0E5B4584100000000272828419A999959E3B45841CDCCCCCC1728284133333313E2B45841666666660A282841CDCCCC8CE1B4584133333333FD272841333333F3E0B4584100000000F627284133333333E0B4584133333333E727284133333393DDB4584100000000DC272841333333F3DBB4584100000000CF27284100000000DBB458419A999999C4272841666666E6DAB4584166666666BD272841666666E6DAB4584166666666B427284166666606DBB4584166666666AC272841CDCCCCACDBB4584100000000A12728419A999999DCB45841333333339927284133333393DEB4584100000000932728419A9999F9DFB45841CDCCCCCC86272841333333D3E1B45841333333337D272841000000E0E2B45841CDCCCCCC72272841000000C0E4B45841333333336E272841666666E6E5B45841000000006B272841666666A6E6B458413333333365272841CDCCCC0CE8B45841000000005E272841666666E6E9B45841000000005627284166666666EBB45841000000004E2728419A999999ECB45841333333334527284166666686EDB458419A99999939272841333333D3EEB45841CDCCCCCC2C272841CDCCCC8CEFB45841CDCCCCCC1C272841666666E6EFB458419A9999990C272841333333F3EFB45841CDCCCCCCFF262841333333F3EFB4584100000000F226284133333373F0B458419A999999E326284133333393F1B45841CDCCCCCCD7262841333333D3F2B4584100000000CE26284133333333F3B458419A999999BF26284133333333F3B4584166666666AB262841CDCCCC8CF3B45841666666669E262841000000C0F3B458416666666696262841CDCCCCECF3B45841CDCCCCCC8B26284100000060F4B45841000000007D262841CDCCCC2CF5B45841000000006126284166666686F5B45841666666665526284100000080F5B458419A9999993D26284133333333F5B458419A9999993226284166666626F5B458419A9999992A26284166666626F5B458419A9999992226284166666686F5B45841333333331A26284166666606F6B458419A999999072628419A9999D9F7B45841CDCCCCCCF525284133333353FAB4584133333333E7252841CDCCCC4CFCB4584100000000E0252841000000E0FDB45841CDCCCCCCD725284133333333FFB4584100000000CF252841CDCCCCCC00B558419A999999C32528410000000002B55841CDCCCCCCB82528416666666603B55841CDCCCCCCAB2528410000006005B5584166666666A02528416666664607B5584133333333952528419A99997908B558410000000080252841000000200AB558416666666678252841333333130BB558419A99999972252841000000000CB558419A9999995D252841666666A60DB558419A9999994F2528419A9999190FB55841CDCCCCCC472528413333333310B558419A999999432528419A99995911B55841666666663E2528416666666613B558413333333338252841000000C014B558419A99999931252841666666E615B558419A99999920252841CDCCCC4C17B55841000000000E2528410000008018B5584100000000022528413333331319B558419A999999F5242841000000001AB5584166666666E9242841333333331BB5584100000000DC242841000000601CB558419A999999D12428419A9999191DB55841CDCCCCCCC92428419A9999B91DB5584133333333C2242841CDCCCC8C1EB558419A999999BB242841333333531FB5584133333333B3242841CDCCCC4C20B5584100000000AC2428413333333321B5584133333333A52428419A99991922B55841666666669D2428419A99995923B55841CDCCCCCC972428413333339324B558410000000090242841CDCCCCCC26B5584133333333842428419A9999F928B558410000000079242841666666A62BB558419A99999970242841CDCCCC0C2EB55841CDCCCCCC65242841CDCCCC8C30B55841000000004A242841CDCCCC2C31B558419A999999422428416666666631B558419A9999993C242841CDCCCC8C31B55841000000002E2428410000004032B558413333333315242841666666C633B55841CDCCCCCC042428419A9999B934B55841CDCCCCCCF8232841CDCCCC4C35B55841CDCCCCCCEF232841333333B335B5584133333333E12328410000006036B558419A999999BE232841CDCCCCCC37B55841CDCCCCCC92232841CDCCCCCC39B5584133333333802328419A9999393DB5584166666666762328419A9999193FB558419A9999996D232841000000A040B5584100000000592328413333339343B5584100000000392328416666668647B558419A999999302328413333335348B558413333333328232841333333F348B55841333333331E232841CDCCCC0C49B558419A999999152328416666660649B558413333333308232841000000E048B558419A999999FC222841CDCCCC2C49B558419A999999ED222841CDCCCCAC49B558419A999999D4222841000000604AB55841CDCCCCCCED2228413333335351B5584100000000C7222841CDCCCCEC5EB558413333333378232841666666666CB55841CDCCCCCC85232841666666066FB55841CDCCCCCC702328410000008078B558419A99999973232841CDCCCC8C7AB558419A999999752328419A9999397CB558419A9999996C232841333333937DB558413333333366232841CDCCCCCC7EB55841000000005A2328410000000081B55841CDCCCCCC5D2328413333335381B55841CDCCCCCC732328410000006083B5584100000000882328416666668685B5584100000000B42328416666668689B5584100000000DD232841666666268DB5584133333333ED232841333333338EB558419A999999FD232841666666E68EB55841000000000F242841CDCCCC8C8FB558410000000017242841000000E08FB55841666666662B242841CDCCCC8C90B558416666666634242841CDCCCCCC90B55841666666663D2428419A9999D990B558416666666646242841000000C090B55841CDCCCCCC6C242841CDCCCCCC90B558410000000091242841CDCCCCCC90B55841CDCCCCCCBA242841666666E690B55841CDCCCCCCCF2428419A99991991B5584100000000E42428419A99997991B55841CDCCCCCCEE242841000000C091B5584100000000F32428419A9999D991B5584100000000FE2428413333331392B558419A999999212528410000000093B558419A999999512528413333331394B55841CDCCCCCC572528413333333394B558419A99999972252841CDCCCCCC94B558419A9999999B2528410000008095B558419A999999B92528413333335396B55841CDCCCCCCD32528419A9999F996B5584166666666E6252841CDCCCCAC97B5584100000000F4252841CDCCCC4C98B55841CDCCCCCC03262841CDCCCC4C99B558419A9999990B262841666666E699B558419A99999916262841CDCCCC8C99B55841000000001C262841666666C698B558419A999999202628413333337398B5584100000000382628419A9999B997B55841CDCCCCCC4A262841CDCCCC0C97B5584133333333692628419A9999F995B5584166666666882628419A9999B994B5584133333333A52628419A99997993B5584133333333A72628416666666693B55841CDCCCCCCC0262841CDCCCC8C92B5584133333333D02628410000002092B5584166666666E2262841000000A091B5584133333333F8262841CDCCCC4C91B55841CDCCCCCC13272841666666E690B55841CDCCCCCC342728419A99999990B558419A9999995A2728419A99995990B5584100000000802728413333335390B5584133333333832728419A99995990B55841CDCCCCCCA32728419A99997990B558419A999999C1272841333333D390B55841CDCCCCCCDA2728413333333391B5584100000000F6272841333333D391B5584166666666132828419A99997992B55841333333332C2828419A9999F992B558416666666642282841000000A093B558416666666647282841666666C693B55841666666665D2828410000008094B55841666666666D2828419A9999D994B558419A999999792828419A9999F994B558410000000085282841CDCCCC0C95B55841CDCCCCCC96282841000000E094B55841666666669E282841000000C094B5584133333333A9282841CDCCCC8C94B5584166666666CC282841CDCCCC0C94B558419A999999DC2828416666662694B5584166666666EC2828410000008094B5584133333333F92828410000000095B558419A9999990C2928419A99991996B5584166666666202928416666668697B558416666666627292841CDCCCC0C98B55841CDCCCCCC4D292841CDCCCC2C9BB55841CDCCCCCC7A292841666666C69EB55841CDCCCCCCA12928419A9999D9A1B5584100000000CA2928419A999939A5B55841CDCCCCCCEB292841CDCCCC0CA8B55841666666660F2A284100000000ABB558419A9999992C2A284166666666ADB5584100000000482A28419A999959AFB5584133333333602A2841333333B3B0B55841666666667D2A2841333333D3B1B558419A9999998D2A284166666646B2B55841666666669C2A28419A999999B2B558419A999999A72A284100000080B2B558419A999999B52A2841333333D3B1B558419A999999BD2A2841CDCCCC4CB3B5584166666666C72A284100000000B5B5584166666666CE2A28419A999919B6B5584166666666F72A2841CDCCCC0CBDB5584166666666032B2841CDCCCC2CBFB55841666666662D2B284166666686C6B55841CDCCCCCC3B2B28419A9999D9C8B55841CDCCCCCC452B2841333333F3C9B55841CDCCCCCC492B2841CDCCCC4CCAB55841CDCCCCCC532B2841CDCCCC4CCBB5584166666666602B284166666646CCB5584166666666732B284166666646CDB558419A999999802B2841666666E6CDB55841000000008E2B284100000040CEB55841CDCCCCCCAB2B28419A9999D9CEB5584100000000BF2B2841CDCCCC0CCFB558419A999999C52B284133333333CFB558419A999999E52B2841666666E6CFB5584133333333092C2841000000E0D0B55841CDCCCCCC262C284133333313D2B5584100000000492C2841333333B3D3B55841333333336B2C2841333333D3D5B5584133333333862C28419A999999D7B5584100000000982C28419A9999B9D8B5584133333333982C2841333333F3D8B55841CDCCCCCC9C2C284133333373DAB55841CDCCCCCCA42C2841CDCCCC6CDCB5584100000000B62C2841CDCCCC8CE0B5584100000000BC2C28419A999939E2B5584133333333C02C28419A999959E3B55841CDCCCCCCC02C2841CDCCCC4CE4B5584100000000BF2C284100000080E6B5584166666666D22C284100000060E8B5584166666666DF2C2841CDCCCCACE9B55841CDCCCCCC4B2D2841666666A6DFB55841CDCCCCCC6C2D2841CDCCCCCCDEB55841333333338B2D2841000000E0DDB5584133333333992D2841666666E6DCB5584100000000AB2D284166666606DCB55841CDCCCCCCB02D28419A9999D9DBB5584100000000BC2D284133333373DBB5584100000000CF2D284133333313DBB558419A999999E82D284100000080DAB5584133333333FF2D28419A999979D9B558419A9999990E2E284133333393D8B558419A9999991D2E2841666666A6D7B5584100000000282E2841CDCCCC0CD7B5584100000000442E284166666626D6B55841000000005E2E28419A999979D5B5584100000000742E28419A9999B9D4B5584100000000872E284166666626D4B558419A999999992E284133333393D3B558419A999999AC2E2841CDCCCC2CD3B558419A999999BB2E284133333313D3B5584133333333CF2E28419A999999D2B5584166666666D62E284100000060D2B5584166666666F32E284166666646D1B55841000000000F2F2841000000E0CFB5584100000000252F284100000080CEB55841CDCCCCCC2B2F2841666666E6CDB558419A999999332F2841CDCCCC2CCDB55841CDCCCCCC482F284100000000CCB5584166666666592F2841333333D3CAB55841333333336A2F284133333393C9B5584166666666732F2841333333D3C8B55841CDCCCCCC772F2841000000E0C7B5584166666666912F2841CDCCCCACC4B55841CDCCCCCCA62F28419A999919C1B5584100000000C62F2841333333D3BDB5584133333333E32F2841CDCCCC0CBBB5584133333333FA2F284133333333B8B55841CDCCCCCC033028419A9999B9B7B55841000000000E302841CDCCCC2CB7B55841CDCCCCCC1F3028419A999999B6B55841333333332A302841CDCCCC0CB6B55841CDCCCCCC35302841CDCCCC0CB5B558416666666643302841CDCCCC8CB3B55841CDCCCCCC4E302841CDCCCCECB1B558419A9999995B30284166666606B0B558419A999999643028419A999999AEB55841CDCCCCCC703028419A999959ADB558419A9999997D30284100000080ACB558419A9999998A302841000000C0ABB55841CDCCCCCC9E30284100000060AAB5584166666666C030284100000040A8B5584133333333D730284133333393A6B5584133333333F33028419A9999B9A4B558419A9999990431284133333353A3B55841CDCCCCCC2131284100000040A2B558419A999999443128419A9999F9A0B55841000000008D312841CDCCCC0C9EB55841CDCCCCCCC1312841666666669CB558419A999999D33128419A9999599BB558419A999999E8312841000000C099B55841CDCCCCCCFD312841666666C697B5584166666666073228416666662696B558419A9999990D322841000000C094B5584100000000103228419A99991993B558413333333311322841CDCCCC6C91B55841CDCCCCCC113228419A9999598FB5584100000000133228419A9999198EB55841CDCCCCCC19322841000000A08CB558410000000027322841333333D38AB55841333333332E3228413333337389B5584166666666373228416666664687B5584133333333423228419A9999F984B55841333333334E322841333333F382B55841CDCCCCCC52322841000000E081B55841666666665A322841666666E681B55841666666666A3228419A9999D981B558419A9999997A3228413333333382B55841000000008E3228410000006083B55841CDCCCCCC9A3228410000008084B5584100000000A83228413333333385B55841CDCCCCCCAE322841CDCCCC6C85B5584166666666B63228416666666685B558419A999999BF3228410000004085B5584166666666C93228416666666684B5584133333333D03228419A99993983B5584100000000DA322841000000A081B5584166666666EB322841666666E67FB558413333333302332841333333B37DB558419A99999919332841000000007CB55841CDCCCCCC273328419A9999F97AB558413333333341332841666666867AB55841CDCCCCCC4A332841666666467AB558410000000054332841CDCCCC4C78B558419A99999961332841000000C076B558419A9999996C332841CDCCCCCC74B558413333333376332841CDCCCC0C72B55841CDCCCCCC7E332841333333736EB5584133333333853328419A9999196DB558410000000094332841CDCCCCCC69B55841CDCCCCCC94332841CDCCCC4C68B558410000000095332841000000C066B558416666666695332841666666E665B558419A9999999B332841666666C663B5584100000000AF3328416666660660B5584133333333BB332841CDCCCC6C5DB55841CDCCCCCCC1332841CDCCCC4C5CB558419A999999CB332841CDCCCC8C5AB5584133333333D7332841CDCCCC6C58B5584133333333DA332841333333B356B5584166666666DB332841CDCCCC2C55B558419A999999DD332841666666C653B5584100000000E3332841000000A052B5584166666666EB3328419A99999951B5584133333333F23328419A99997950B5584133333333FE332841CDCCCC6C4EB558419A9999990C342841333333134DB55841333333331D342841666666064BB55841666666662F342841CDCCCC0C49B558410000000039342841CDCCCC2C47B55841000000003E342841333333B345B558416666666645342841333333B343B55841CDCCCCCC513428413333331342B55841000000005A3428410000000041B558419A99999989342841000000003DB55841333333339C342841CDCCCC6C3BB558419A999999AF342841666666063AB55841CDCCCCCCC6342841666666C637B558419A999999D1342841333333F335B5584133333333D8342841CDCCCC0C34B5584166666666DF342841000000A031B558419A999999ED342841CDCCCCCC2FB55841CDCCCCCC053528419A9999F92CB558413333333330352841666666C628B558413333333359352841666666A623B55841CDCCCCCC71352841CDCCCCCC1FB5584133333333833528419A9999191DB558410000000095352841333333331AB55841CDCCCCCCA5352841666666C617B5584166666666B5352841000000E015B5584166666666C73528419A99993913B5584166666666DD3528410000004010B5584100000000F03528419A9999190EB558413333333303362841000000A00BB558416666666613362841CDCCCC2C09B55841CDCCCCCC263628410000002007B5584100000000363628419A99991906B55841333333333E3628410000008005B55841CDCCCCCC513628416666664605B5584133333333623628416666666605B55841CDCCCCCC73362841333333F305B558419A9999998E362841333333B307B55841CDCCCCCCB93628410000006009B558419A999999CB3628419A9999B909B5584100000000FA362841666666860AB558410000000006372841CDCCCC4C0AB558410000000011372841CDCCCC0C0AB558419A9999992A3728413333339308B55841CDCCCCCC44372841666666E606B5584166666666513728416666660606B5584133333333623728419A9999D904B558419A9999998A3728413333337303B5584166666666AF3728419A9999F902B55841CDCCCCCCD23728419A99993903B558410000000006382841333333F302B5584133333333283828416666668601B55841CDCCCCCC453828419A99993900B55841CDCCCCCC5D382841CDCCCC2CFFB45841666666668238284100000040FEB458419A99999994382841000000E0FDB4584133333333A0382841CDCCCCACFDB45841CDCCCCCCB738284166666666FDB458419A999999CC38284166666666FDB458419A999999DB38284133333393FDB4584100000000E83828419A9999B9FDB4584100000000F6382841000000C0FDB458419A99999902392841333333F3FDB45841000000000C392841CDCCCC0CFEB4584166666666163928419A999919FEB45841CDCCCCCC1C392841666666A6FDB458410000000022392841666666E6FCB45841CDCCCCCC26392841000000A0FBB45841000000002B392841CDCCCC6CFAB45841666666663039284166666606F9B45841CDCCCCCC363928419A999939F7B45841333333333B3928419A999959F6B4584166666666423928419A9999F9F4B458419A9999994739284100000020F4B45841333333334D392841000000A0F3B458413333333358392841CDCCCC0CF3B458413333333361392841CDCCCC8CF2B45841CDCCCCCC6F39284100000020F2B45841CDCCCCCC81392841666666A6F1B458419A99999990392841CDCCCC4CF1B45841333333339D392841000000E0F0B4584100000000A939284100000080F0B4584100000000B439284133333313F0B4584133333333BA392841000000E0EFB4584166666666C739284100000080EFB458419A999999D4392841000000E0EEB4584100000000E039284133333333EEB4584100000000E8392841CDCCCCECECB45841CDCCCCCCF0392841CDCCCC6CEBB45841CDCCCCCC003A28419A999999E8B45841CDCCCCCC1F3A2841CDCCCCACE2B4584100000000333A28419A999939DFB458419A9999994C3A2841000000A0DAB458419A9999995D3A284133333333D7B45841CDCCCCCC703A2841000000A0D3B4584133333333843A2841333333B3CFB458419A999999923A2841333333B3CCB4584100000000A13A28419A999939CAB45841CDCCCCCCAB3A2841666666A6C8B45841CDCCCCCCAF3A284166666606C8B4584166666666B83A2841CDCCCCCCC6B458419A999999C53A284133333313C5B4584166666666D23A28419A9999F9C3B4584100000000E23A28419A9999B9C2B4584100000000F23A2841000000E0C1B4584133333333053B2841CDCCCC8CC0B458419A999999183B284100000060BFB458419A9999992E3B284166666606BEB4584133333333463B2841000000A0BCB4584100000000583B28419A999919BBB4584100000000673B284133333393B9B4584133333333723B284100000060B8B45841666666667F3B284166666626B7B45841000000008A3B2841CDCCCC0CB6B45841CDCCCCCC963B2841CDCCCCECB4B45841CDCCCCCCA13B28419A9999F9B3B4584100000000AF3B28419A999979B3B458419A999999BD3B284100000040B3B4584100000000CD3B284166666646B3B458419A999999CA3B284100000060BBB4584100000000C63B2841CDCCCCECC9B4584100000000C93B284133333393CBB458419A999999CD3B2841CDCCCC0CCDB4584133333333D23B284166666606CEB4584100000000DA3B284133333313CFB458419A999999EA3B28419A999999D0B4584100000000F93B284166666626D2B4584100000000023C284133333353D3B4584133333333083C28419A999979D4B458419A9999990B3C28419A9999B9D5B45841666666660D3C2841333333F3D6B45841CDCCCCCC0E3C2841CDCCCCACD8B45841CDCCCCCC0F3C284100000060DBB4584100000000153C2841CDCCCCCCDFB4584166666666193C28419A999979E3B45841CDCCCCCC203C28419A999959E6B45841CDCCCCCC243C2841CDCCCCECE7B45841000000002A3C28419A999999E9B45841000000002E3C2841CDCCCC6CEAB4584166666666343C284166666646EBB458419A9999993D3C28419A999939ECB45841CDCCCCCC4B3C2841333333D3EDB4584133333333553C28419A999919EFB45841CDCCCCCC5E3C2841CDCCCC0CF1B4584100000000693C284100000060F4B45841CDCCCCCC743C284133333313F8B4584100000000803C2841CDCCCC0CFCB4584166666666883C284166666666FFB45841CDCCCCCC8D3C2841000000C001B55841666666668E3C28419A99999902B5584166666666283D2841333333F303B558419A9999992F3D2841CDCCCCEC0AB55841CDCCCCCC203D28419A99991913B55841000000001B3D28419A99991916B5584100000000173D2841666666C617B55841CDCCCCCC153D28413333333318B5584133333333153D28410000008018B55841333333330D3D2841666666861AB5584100000000023D28419A9999591CB5584166666666EC3C28419A9999F91FB5584133333333DF3C2841666666E621B55841333333330F3D28419A9999F924B5584133333333353D2841666666E631B558419A9999998A3D2841000000E02DB5584133333333E63D2841000000E02AB55841000000003E3E2841666666E623B5584133333333673E2841000000E022B55841CDCCCCCCDC3E28410000006022B55841CDCCCCCCC83F2841CDCCCC4C18B55841CDCCCCCCEF3F28419A99995918B5584100000000254028419A99997918B5584100000000A3402841CDCCCCAC18B55841CDCCCCCCC6402841000000C018B55841000000006A412841666666261EB5584166666666CF422841333333B30CB558416666666668442841CDCCCC4C0DB55841000000007C4428413333339311B5584100000000AE4428419A99991910B558419A999999C9442841000000A015B558419A99999949452841000000A016B5584100000000694528419A9999D916B55841333333337D4528416666660617B55841000000008B4528419A9999F916B5584166666666AB4528419A9999D916B55841CDCCCCCCAB452841CDCCCC0C17B5584166666666B5452841666666461CB558419A999999F2452841333333332FB5584166666666F94528416666660631B5584133333333134628416666662638B558413333333325462841666666063BB558419A9999993B4628419A9999993EB55841000000004C4628413333339344B5584133333333514628419A9999194BB55841CDCCCCCC54462841CDCCCC8C4FB55841666666665D462841CDCCCC8C58B55841CDCCCCCC71462841666666065FB5584133333333724628410000000063B5584166666666864628419A99997968B5584100000000CE462841333333F36DB558413333333327472841CDCCCCCC74B55841666666668F472841CDCCCC2C7AB55841CDCCCCCC13482841CDCCCC0C82B55841333333334C4828419A9999F986B558413333333374482841CDCCCCEC88B5584133333333C3482841333333B38CB5584166666666D0482841333333538DB55841CDCCCCCCE2482841000000C08EB558410000000049492841333333B396B55841333333339D4928419A9999999BB5584100000000AE492841333333939BB5584133333333B9492841333333939BB55841CDCCCCCC6D4A284100000060A6B5584100000000904A2841CDCCCC4CAEB55841000000009F4A284166666666ABB55841CDCCCCCCCF4A2841CDCCCC0CA4B5584166666666D14A2841CDCCCC0CA3B5584133333333D94A284133333313A2B5584133333333E24A284166666686A1B5584133333333E84A284133333373A1B5584133333333E94A2841CDCCCC2CA1B558419A999999E94A28419A9999399FB5584166666666ED4A28419A9999599DB558419A999999F64A2841000000809BB55841CDCCCCCC054B2841CDCCCCAC98B55841CDCCCCCC204B28419A99997993B55841CDCCCCCC2F4B28413333339390B55841CDCCCCCC364B2841333333338FB55841333333333B4B2841000000408EB55841CDCCCCCC414B2841CDCCCCCC8CB55841333333334B4B28419A9999398BB55841000000005D4B2841666666068AB5584166666666774B2841CDCCCC6C88B55841CDCCCCCC944B2841333333D386B5584166666666B54B2841CDCCCCCC85B5584100000000D34B28410000000084B5584166666666F84B28419A99997982B55841000000003E4C28410000004081B55841CDCCCCCC604C2841666666A680B5584166666666674C2841666666E67FB558419A999999724C2841333333937EB558419A9999997F4C2841CDCCCC2C7DB55841CDCCCCCC894C2841000000C07CB55841CDCCCCCC904C2841666666C67CB5584100000000994C2841CDCCCCCC7CB5584100000000B54C28419A9999F97CB5584166666666D04C2841666666A67DB5584166666666F34C2841000000007FB5584166666666104D2841666666E680B55841000000002A4D28419A99995983B558419A999999404D28413333333386B5584133333333494D28410000008087B5584166666666504D28413333339388B55841CDCCCCCC5A4D28419A9999598AB5584133333333644D28419A9999998CB5584133333333714D2841000000A08EB5584100000000A44D2841000000808AB558419A999999F24D28419A99991984B558419A999999034E28413333331385B55841CDCCCCCC174E28413333335386B5584100000000254E2841CDCCCC6C87B5584166666666334E28419A99991989B55841CDCCCCCC474E2841000000A08CB55841CDCCCCCC4B4E28419A9999598DB55841CDCCCCCC5B4E28416666664690B55841333333335C4E28419A99995990B5584100000000634E28419A9999F98FB558419A999999884E2841333333F38DB5584100000000AF4E28419A9999D98BB5584133333333F54E2841CDCCCC0C88B5584166666666FE4E28419A99995987B558419A999999444F28419A99995981B558419A999999464F28410000000081B55841000000007A4F2841000000C07CB55841333333338B4F28419A9999F97BB5584166666666914F2841000000C07AB5584100000000E34F28413333335373B558419A999999415028419A9999196BB55841333333334C5028413333335367B558416666666615512841333333D34AB55841000000005D5128419A99995939B55841333333335D5128419A99993939B558419A9999995C5128419A99991937B558419A99999976522841CDCCCC0C23B558419A9999997E5228419A9999991CB5584100000000E5522841000000C00CB558419A9999999153284133333313F2B4584133333333A553284166666686F1B4584133333333C6532841666666A6F0B458419A999999DE53284133333333F0B45841CDCCCCCCF45328419A999979EFB45841CDCCCCCC06542841CDCCCC8CEEB45841333333331954284133333373EDB45841666666662D542841CDCCCC2CECB458413333333347542841333333D3E9B45841000000005E542841CDCCCC8CE7B45841333333336F542841666666C6E5B45841CDCCCCCC8054284133333313E4B45841CDCCCCCC9754284166666686E2B4584100000000A9542841CDCCCC0CE1B45841CDCCCCCCB6542841000000C0DFB45841CDCCCCCCC75428419A999999DDB458416666666649542841CDCCCC2CC7B458419A9999991E54284133333393BFB45841CDCCCCCCF6532841CDCCCC8CBDB4584166666666DB532841333333D3BBB4584100000000CB532841CDCCCC6CBAB4584166666666BF53284166666686B9B45841CDCCCCCCB553284100000000B9B4584133333333A9532841000000C0B8B45841666666669C532841CDCCCCCCB8B45841000000008553284100000080B9B458419A999999685328419A999999BAB458416666666652532841CDCCCCECBAB45841CDCCCCCC435328419A9999D9BAB45841000000003553284166666646B9B458419A99999923532841CDCCCCACB8B4584100000000005328419A9999B9B7B4584166666666ED52284100000060B6B4584100000000C552284100000040B4B45841000000009C522841CDCCCCACB2B458416666666671522841333333F3B1B458419A9999995F52284133333313B1B458416666666654522841666666E6B0B45841000000003652284133333313B0B45841333333331552284133333393AFB45841CDCCCCCCEF5128419A9999B9AEB4584133333333CD512841CDCCCC0CADB458419A999999AB51284100000000ABB45841CDCCCCCC8D51284133333373A9B458419A9999996A51284166666666A7B458419A9999994B51284133333393A6B4584133333333315128419A999959A5B458413333333317512841CDCCCCECA2B4584133333333FE502841333333D39FB458419A999999EB502841000000009CB458419A999999DA5028413333337397B4584166666666CF502841CDCCCC0C95B45841CDCCCCCCC1502841333333D393B45841CDCCCCCCA8502841CDCCCC8C94B458419A99999989502841666666C696B4584133333333755028419A99991998B4584133333333575028410000006097B45841CDCCCCCC3A5028419A9999B995B45841666666662F502841CDCCCC8C94B45841CDCCCCCC1F5028410000006094B45841666666662D5028413333339390B458413333333338502841000000008EB45841CDCCCCCC425028419A9999D98BB458416666666653502841000000C08AB45841333333335B5028410000002089B45841CDCCCCCC5F502841333333D386B45841CDCCCCCC6B5028419A99999984B45841CDCCCCCC7F502841000000A081B458413333333391502841000000A07DB4584133333333A1502841000000807AB4584133333333AD5028419A9999B976B4584133333333B95028410000000073B45841CDCCCCCCBD502841CDCCCC8C70B45841CDCCCCCCC55028419A9999F96DB4584133333333D3502841CDCCCCCC6AB4584166666666E15028419A99999966B4584166666666E95028410000000063B4584133333333F55028419A9999B95FB458413333333304512841000000205DB458416666666620512841000000E05AB458419A99999939512841333333B359B4584133333333615128419A99991958B4584100000000805128413333333357B458419A999999A4512841333333B356B45841CDCCCCCCC35128413333337356B45841CDCCCCCCE85128416666664655B458413333333303522841000000A053B458419A9999991A5228419A99993951B4584100000000285228419A9999D94EB45841CDCCCCCC2D522841333333534BB45841000000002D5228416666664648B458416666666629522841333333F345B458410000000028522841333333F344B458416666666613522841333333F33BB4584100000000FF5128419A99993935B4584100000000DE5128419A9999992BB4584100000000C45128416666664626B45841CDCCCCCCB0512841CDCCCCAC23B45841666666668E5128419A99993920B45841CDCCCCCC80512841000000E01DB458419A99999979512841333333B31AB4584100000000785128416666662618B458419A99999980512841666666C615B45841CDCCCCCC845128416666662615B45841666666668D512841CDCCCCCC13B45841CDCCCCCCA65128410000002012B4584166666666CC5128410000002010B458419A999999F8512841333333130EB45841CDCCCCCC19522841333333530BB4584166666666345228413333335308B45841CDCCCCCC44522841CDCCCC4C06B45841666666664F5228419A99995904B458413333333355522841000000E002B45841CDCCCCCC595228410000000001B45841666666665D522841CDCCCC4CFEB35841000000005F5228419A999999FBB35841333333335F522841000000E0F9B35841CDCCCCCC5E52284133333353F7B35841000000005D522841333333D3F4B35841000000005A522841CDCCCC6CF2B35841000000005552284166666646F0B35841CDCCCCCC4E5228419A999959EEB35841CDCCCCCC43522841333333F3EBB35841333333333A522841CDCCCC4CEAB35841333333332E522841666666A6E8B35841000000001E522841CDCCCC6CE6B358419A9999990B522841333333F3E4B3584166666666F15128419A9999F9E3B358419A999999E4512841CDCCCC2CE3B358419A999999D25128419A999979E2B3584166666666BE512841CDCCCCACE1B3584100000000AB51284166666646E0B35841666666669A512841333333D3DEB358419A9999998C51284166666646DDB35841CDCCCCCC845128419A9999F9DBB358419A9999997B512841666666E6D9B35841666666667751284100000080D7B35841000000007751284100000020D5B358416666666679512841CDCCCC6CD3B358419A9999997D51284133333393D1B358410000000082512841666666C6CFB358410000000086512841000000A0CDB3584166666666875128419A9999D9CBB35841CDCCCCCC88512841CDCCCCACC8B35841000000008A512841CDCCCC2CC6B35841000000008D512841666666E6C3B358419A9999999251284133333373C1B35841666666669C512841CDCCCCACBEB3584100000000AA51284166666666BBB358419A999999BA51284133333393B8B35841CDCCCCCCD25128419A999919B6B3584100000000EE51284100000060B4B35841000000000A5228419A999919B3B35841CDCCCCCC2452284166666666B2B35841CDCCCCCC4452284100000060B2B35841CDCCCCCC5952284166666626B3B358413333333374522841CDCCCCCCB4B3584100000000955228419A999959B7B3584100000000B652284100000040BAB358419A999999C5522841CDCCCCCCBBB3584100000000D2522841CDCCCCECBDB35841CDCCCCCCD952284100000060C0B3584166666666DB52284133333373C4B3584100000000DB522841666666E6C6B358419A999999DA522841333333D3C8B35841CDCCCCCCD3522841666666A6CBB35841CDCCCCCCC95228419A999979CEB35841CDCCCCCCC052284100000080D0B3584100000000BC52284133333333D2B35841CDCCCCCCB8522841000000A0D3B3584133333333B852284166666686D5B3584133333333BA522841CDCCCCACD6B3584166666666C05228419A999979D8B3584100000000CD52284166666666DAB3584100000000E052284133333333DDB358410000000004532841000000E0E0B358419A9999991653284133333393E2B35841333333332153284166666626E3B358419A9999992F53284166666686E3B35841CDCCCCCC3D5328419A999999E3B35841666666664C532841CDCCCC6CE3B358413333333358532841666666E6E2B35841CDCCCCCC69532841CDCCCCECE1B358419A9999997D532841CDCCCC4CE0B35841666666669153284133333333DEB35841666666669C53284100000020DCB358419A999999A953284100000040D9B3584100000000B25328419A999939D7B35841CDCCCCCCB853284100000040D5B3584100000000BE53284100000060D3B3584133333333C1532841CDCCCCACD1B358419A999999C2532841333333F3CEB3584133333333C053284133333393CCB35841CDCCCCCCBB5328419A9999F9CAB3584166666666B653284100000000C9B3584166666666B2532841CDCCCCACC6B3584100000000AF5328419A999959C4B3584166666666AD53284133333353C2B358419A999999AC53284100000060C0B3584100000000AA5328419A999939BEB3584166666666A553284166666666BCB35841666666669E5328419A999959BAB3584100000000985328419A9999B9B7B358410000000094532841666666E6B4B358410000000091532841CDCCCCECB1B35841CDCCCCCC8E53284166666606AFB35841CDCCCCCC8B532841666666C6ABB3584166666666885328419A999939A9B3584133333333835328419A9999D9A6B35841CDCCCCCC7A532841000000E0A3B35841333333336F532841000000A09EB35841CDCCCCCC6B5328419A9999599CB35841CDCCCCCC6B532841CDCCCC4C9AB35841000000006E5328419A99993998B3584133333333725328410000006096B358419A9999997A5328410000006094B3584166666666875328413333337392B35841CDCCCCCC9C532841333333F38FB358419A999999CD532841333333138CB3584100000000FB532841000000C088B35841CDCCCCCC175428410000002087B35841000000002A5428410000004086B3584133333333425428416666668685B35841333333335E5428416666664684B35841CDCCCCCC805428410000006082B358413333333394542841666666E680B3584166666666A6542841CDCCCCCC7FB35841CDCCCCCCAF542841CDCCCCAC7EB35841CDCCCCCCB6542841000000407DB3584166666666B9542841000000007CB3584133333333BA542841333333337AB3584133333333B95428419A99995978B3584133333333B75428419A99999975B3584133333333B35428419A9999B970B3584100000000AA542841333333F36BB3584133333333A35428416666664669B3584133333333A25428419A99993968B358419A99999999542841CDCCCC2C63B35841CDCCCCCC8E542841666666A65EB358416666666687542841666666865BB35841CDCCCCCC7E5428416666664659B3584166666666755428413333333357B358419A9999996B5428413333337355B358410000000061542841CDCCCC0C54B3584166666666555428413333331352B358419A9999994A5428413333337350B3584166666666415428419A9999D94EB358419A99999938542841CDCCCCAC4CB35841CDCCCCCC33542841666666E64AB358419A99999931542841CDCCCCEC48B35841CDCCCCCC30542841CDCCCCCC46B3584100000000325428410000002045B3584133333333345428416666666643B35841CDCCCCCC3A542841666666E640B358410000000042542841333333733EB35841CDCCCCCC46542841000000A03CB35841CDCCCCCC4D542841333333D339B358419A9999995A5428416666662636B358413333333363542841CDCCCC4C34B358419A9999996F5428416666664632B35841CDCCCCCC81542841333333F32EB3584100000000965428419A9999D92AB35841CDCCCCCCA45428419A9999B927B35841CDCCCCCCAF5428419A99993926B3584133333333BA5428416666660625B3584166666666C5542841CDCCCCCC23B35841CDCCCCCCCE542841333333F322B3584166666666DC542841666666C621B3584166666666EA5428419A9999D920B3584100000000F85428416666660620B35841CDCCCCCC01552841000000401FB35841333333330D5528419A9999391EB35841000000001A552841333333731DB35841000000002F552841333333D31CB35841CDCCCCCC3C552841000000801CB35841000000004C552841CDCCCC2C1CB35841666666665A552841CDCCCC8C1BB358419A999999655528419A9999D91AB358419A99999974552841333333D319B358419A999999815528410000002019B358416666666692552841CDCCCC4C18B3584133333333A7552841CDCCCC2C17B35841CDCCCCCCBC552841666666A615B3584100000000CB5528419A9999D914B3584100000000DE552841666666E613B3584100000000EE5528410000002013B3584133333333FC5528419A99999912B358419A999999055628413333333312B35841CDCCCCCC0E562841CDCCCC2C11B35841CDCCCCCC1F562841CDCCCC2C0FB358413333333326562841333333730EB3584100000000305628419A9999790DB358413333333338562841000000200DB35841CDCCCCCC43562841666666460DB35841666666664E5628419A9999190EB3584100000000585628419A9999590FB35841CDCCCCCC615628416666662610B358419A99999970562841CDCCCCCC10B35841CDCCCCCC7B5628419A9999D910B358416666666686562841000000A010B358416666666693562841333333530FB358419A999999A0562841CDCCCC8C0DB3584133333333A85628419A9999D90BB3584100000000B6562841CDCCCC8C05B3584133333333C3562841CDCCCCACFFB2584166666666CB56284133333373FCB2584100000000D35628419A999959FAB25841CDCCCCCCDB562841666666E6F7B2584166666666E656284133333333F6B25841CDCCCCCCF156284166666626F5B25841CDCCCCCCFB562841666666A6F4B258419A9999990957284100000040F4B2584133333333165728419A999919F4B2584133333333215728419A9999B9F3B258419A9999992A572841333333D3F2B258419A999999325728419A999959F1B258413333333349572841CDCCCCECECB25841000000004B57284166666606EAB25841CDCCCCCC49572841666666C6E7B25841666666664157284166666646E4B2584166666666355728419A9999D9E0B258419A99999928572841333333B3DDB25841CDCCCCCC19572841000000C0D9B25841666666660A57284133333313D6B2584100000000F856284166666606D3B2584100000000E756284100000020D1B2584133333333D5562841333333F3CFB2584133333333BE56284100000040CFB258419A999999B2562841333333F3CEB2584100000000A456284166666626CEB258419A99999988562841333333D3CEB25841CDCCCCCC795628419A9999B9CFB25841000000006B5628419A999939D1B25841333333335C562841666666C6D3B25841000000004956284100000060D8B258410000000037562841000000C0DBB25841CDCCCCCC23562841000000A0DEB258419A999999045628419A9999F9E1B25841CDCCCCCCE455284100000040E5B2584100000000CB552841CDCCCC4CE7B2584133333333AB55284166666606E9B25841333333338F55284100000000EAB25841000000007755284133333393EAB25841CDCCCCCC5E552841000000A0EAB25841CDCCCCCC4655284100000060EAB258419A9999993455284100000000EAB25841CDCCCCCC1F552841CDCCCC0CE9B25841333333330D552841CDCCCC8CE7B258413333333305552841CDCCCCECE6B2584100000000E95428419A9999D9E3B2584166666666D3542841666666C6E0B2584166666666C3542841CDCCCC8CDDB2584100000000B8542841CDCCCCCCD9B25841CDCCCCCCB2542841000000A0D6B258419A999999B054284100000040D2B25841CDCCCCCCB154284100000080CCB2584166666666B5542841CDCCCC4CC8B258419A999999BF542841333333D3C3B25841CDCCCCCCCA542841CDCCCC0CC1B2584133333333D9542841000000E0BEB25841CDCCCCCCF754284100000000BCB258419A9999991A55284166666686B8B258410000000031552841333333D3B5B258413333333342552841CDCCCCCCB2B25841000000005055284166666626AFB2584100000000585528419A9999D9A9B25841CDCCCCCC5C55284166666626A5B25841CDCCCCCC5A552841666666E6A0B258419A99999954552841333333739DB25841CDCCCCCC45552841CDCCCCAC99B2584133333333355528410000000097B25841333333331B5528413333337394B2584100000000F9542841CDCCCCAC91B2584133333333C6542841666666E68EB25841333333339F542841000000408DB258419A9999998C542841333333B38CB258419A99999975542841666666468CB258419A99999962542841333333138CB258419A9999994C5428419A9999398CB258419A99999937542841333333738CB258419A99999927542841CDCCCC8C8CB25841CDCCCCCC165428419A9999998CB258413333333303542841000000A08CB2584166666666F2532841666666C68CB2584166666666DE532841000000208DB258419A999999C9532841666666A68DB2584100000000BE532841000000208EB25841CDCCCCCCB45328419A9999798EB2584100000000A1532841666666A68FB258419A999999915328416666660691B2584166666666825328419A9999D992B25841333333336B532841000000C095B25841666666665F5328419A99997997B25841CDCCCCCC4F532841000000C099B25841CDCCCCCC4A532841333333739EB258419A9999994453284166666646A0B25841000000003B532841CDCCCCACA1B25841333333332B53284133333333A2B258419A9999991A532841CDCCCC4CA2B25841000000000D53284133333313A2B25841333333330053284166666646A1B2584100000000F8522841CDCCCC0CA0B2584166666666F1522841666666869EB2584166666666ED522841000000A09CB258419A999999EA522841333333D39AB2584133333333E95228410000006097B2584133333333DB5228419A9999D994B2584133333333D85228410000002094B2584166666666D35228416666660693B2584166666666CC5228419A99997990B25841CDCCCCCCC8522841CDCCCCEC8DB258419A999999C8522841000000608CB258419A999999C8522841666666068AB258419A999999C95228410000002086B25841CDCCCCCCCA522841CDCCCCCC81B2584166666666CB522841CDCCCC4C7DB2584100000000C65228419A99993978B25841CDCCCCCCC0522841666666A673B2584100000000B65228419A99995970B25841333333339E5228419A9999196CB258419A9999999B522841CDCCCCAC6BB25841666666666B5228419A9999F965B25841CDCCCCCC3A522841333333B35FB258419A99999921522841CDCCCC0C5DB25841CDCCCCCCF5512841CDCCCC0C5AB2584100000000D65128413333335358B2584100000000B35128419A9999F956B258419A9999998B5128416666660656B2584133333333755128410000004054B258410000000067512841333333B352B25841CDCCCCCC575128413333331350B25841CDCCCCCC4D512841666666264CB25841CDCCCCCC475128419A99995947B258419A99999946512841CDCCCCCC3FB2584166666666505128413333331337B25841CDCCCCCC665128413333337328B2584100000000705128410000006025B258410000000085512841CDCCCC4C20B258419A9999999F512841CDCCCC2C1CB258419A999999B3512841333333D317B25841CDCCCCCCB7512841CDCCCCEC13B258419A999999B25128416666662612B25841000000009E512841666666460EB258416666666679512841333333F306B258419A999999FE50284100000040F2B1584166666666D95028419A999939EBB1584100000000C0502841CDCCCC6CE1B1584100000000BE502841CDCCCCECDEB158419A999999A05028419A9999F9DEB158419A9999996E5028419A999919DFB158419A9999993C50284166666626DFB1584166666666F64F284100000040DAB1584166666666EE4F28419A999919D1B158419A9999992D4F284133333393BAB158419A999999E04E284133333393BCB1584133333333CA4E284100000060BDB1584100000000A34E284133333313BFB1584100000000844E28419A999959C0B1584133333333684E2841CDCCCCCCC0B158419A999999604E2841333333D3C2B1584133333333604E2841333333F3C4B15841CDCCCCCC5E4E2841000000C0C7B15841333333335A4E28419A999919CAB158419A9999994D4E284100000020CCB15841333333333F4E2841000000C0CDB15841CDCCCCCC2D4E2841333333F3CDB15841333333332C4E284100000000CEB15841333333331E4E2841CDCCCCACCDB15841CDCCCCCC0C4E2841CDCCCC6CCBB1584133333333FF4D284166666606C9B1584100000000F04D28419A9999B9C4B1584166666666E64D2841666666A6C0B1584100000000E54D28419A999979BDB1584133333333DD4D28419A999999BBB15841CDCCCCCCD94D2841CDCCCCCCBAB1584133333333CE4D284100000060B9B1584133333333C24D28419A9999B9B8B1584100000000AD4D2841000000C0B8B15841666666669F4D28419A999979B9B15841000000008C4D2841CDCCCCCCBAB1584166666666784D2841333333F3BCB15841333333335D4D284100000020BFB158419A999999454D2841333333F3BFB158419A999999334D28419A999979BFB1584166666666224D284133333333BEB1584133333333124D2841333333B3BDB1584100000000004D2841000000C0BDB1584133333333F04C2841CDCCCC4CBEB1584166666666DC4C284166666666BFB1584133333333C94C2841333333B3C0B15841CDCCCCCCB64C2841333333D3C2B1584133333333A84C2841000000A0C3B1584166666666964C284166666626C4B15841333333338C4C28419A9999B9C4B1584100000000894C2841CDCCCCECC4B15841CDCCCCCC7E4C2841CDCCCCACC5B1584166666666704C28419A999959C6B15841CDCCCCCC764C2841CDCCCC8CC4B1584100000000874C28419A999919BFB1584166666666964C2841333333D3B8B1584166666666A14C284166666626B3B1584166666666AD4C284133333333ADB1584100000000B94C2841333333B3A3B15841CDCCCCCCC34C2841333333F399B1584166666666C94C28419A99999995B15841CDCCCCCCAF4B28419A9999B987B158419A999999DD4A28416666664673B1584100000000C84A28419A9999F973B158419A999999A54A28419A99999974B15841CDCCCCCC784A2841666666E675B158419A999999574A28413333333377B1584100000000324A28419A99997979B15841CDCCCCCCF14928419A9999197DB158419A999999C04928416666664680B158419A9999998D4928410000000083B158416666666669492841666666E684B158419A99999953492841000000A085B15841CDCCCCCC2F4928416666660686B15841000000000D4928410000000086B1584166666666E54828419A9999F985B1584133333333E64828410000002084B1584100000000E44828419A99999980B1584166666666DF482841CDCCCC0C7DB1584133333333D54828419A99993979B1584100000000C44828410000004072B15841CDCCCCCCB0482841333333D368B158419A9999999B482841333333935CB158419A9999998D482841CDCCCCCC54B158419A999999854828410000000050B158419A99999983482841333333D34DB15841000000007D4828413333337348B1584166666666764828413333337348B158419A99999970482841CDCCCC4C46B15841CDCCCCCC6E482841666666C644B158419A9999996F482841000000E042B158413333333370482841CDCCCCEC41B158419A99999976482841CDCCCC6C3EB15841000000007C482841CDCCCCCC3BB158419A99999985482841CDCCCC4C38B1584133333333914828410000006035B158419A999999A3482841CDCCCC2C30B1584133333333AF482841000000602CB158419A99999991482841CDCCCC6C2CB158416666666636482841CDCCCC6C2AB15841CDCCCCCC19482841333333B329B1584100000000B0472841333333F326B15841CDCCCCCC7B4728419A9999B925B158419A99999963472841CDCCCC2C26B158410000000051472841CDCCCC4C26B1584133333333434728416666664626B15841CDCCCCCC324728410000000026B15841CDCCCCCC214728419A99995926B158419A9999991B472841333333D326B158416666666611472841333333B328B1584100000000FE462841333333B32AB15841CDCCCCCCEE462841333333932BB1584133333333E8462841CDCCCCAC2BB158419A999999E2462841000000C02BB1584133333333D04628419A9999192CB15841CDCCCCCCB1462841CDCCCC6C2AB158416666666699462841000000A028B158410000000089462841CDCCCC6C27B15841333333336D4628410000008026B1584133333333554628416666660626B1584166666666284628416666668626B15841333333330F462841CDCCCCCC26B15841000000000C4628419A9999D926B1584100000000DE4528413333331328B1584166666666AF452841666666E629B15841CDCCCCCC91452841666666462BB15841333333336F4528419A9999592BB158419A9999996D452841666666462BB158419A99999944452841000000C029B15841CDCCCCCC21452841CDCCCCEC27B158419A999999044528419A99999926B1584166666666E8442841666666C626B1584133333333CE4428413333337327B1584166666666AD442841CDCCCCCC27B158419A9999998F4428416666660627B158419A99999980442841CDCCCC4C26B1584100000000804428413333333326B15841666666666A4428413333339321B1584166666666514428419A9999391BB15841CDCCCCCC48442841CDCCCC8C19B15841000000003C4428413333331317B158419A9999991C442841666666C613B1584133333333F6432841CDCCCC4C11B1584133333333F24328413333339310B15841CDCCCCCCE4432841CDCCCC2C0EB15841CDCCCCCCD94328419A9999590BB15841CDCCCCCCC54328410000002005B15841CDCCCCCCB34328419A9999D901B158410000000084432841333333D3FCB058416666666652432841666666A6FAB05841CDCCCCCCF542284133333333F6B0584166666666A242284166666666F4B058419A9999996942284100000040F6B05841CDCCCCCC3C422841000000E0F6B058416666666616422841CDCCCC2CF5B0584100000000ED412841CDCCCC0CF1B05841333333339141284166666606E6B05841CDCCCCCC66412841CDCCCC4CE0B05841CDCCCCCC424128419A999919DBB05841666666661E412841CDCCCC6CDAB058410000000002412841333333D3DAB0584166666666E34028419A9999B9DBB0584133333333E0402841333333D3DBB0584166666666CE40284133333373DBB05841CDCCCCCCB4402841666666A6D7B05841CDCCCCCCB1402841CDCCCCACD5B05841CDCCCCCCA94028419A9999B9D0B0584100000000A440284133333393CAB0584100000000A940284166666626C2B05841333333338C402841333333B3BDB05841CDCCCCCC6A40284133333393BCB058416666666625402841CDCCCC6CBFB0584100000000244028419A999979BFB058419A999999CE3F2841666666E6C2B058419A999999B43F284166666626C3B058419A999999623F28419A9999F9C3B0584166666666343F2841CDCCCC0CC3B0584133333333063F2841CDCCCC4CBFB0584166666666DF3E284166666666B9B05841CDCCCCCCC43E2841CDCCCC6CB7B05841000000007F3E284166666686B6B0584133333333333E284166666666B7B058419A999999113E284100000000B7B05841CDCCCCCCFF3D284100000060B5B058419A999999053E284166666666AFB0584100000000163E28419A999959A7B05841CDCCCCCC1B3E2841CDCCCCEC9EB058419A9999991A3E2841CDCCCC4C98B05841333333330F3E2841CDCCCC4C95B0584100000000FA3D28416666666692B0584133333333D93D28419A9999B98FB0584100000000CA3D2841CDCCCCEC8BB0584133333333B63D28416666662688B058419A999999903D2841000000C083B0584166666666733D2841000000C081B058419A9999993E3D2841000000A07FB058419A999999F93C2841666666867CB0584133333333C63C28419A9999197BB05841666666669D3C2841CDCCCC0C78B058419A9999996A3C2841CDCCCC6C74B05841CDCCCCCC463C28419A9999B971B0584166666666403C2841333333536EB05841666666664B3C2841333333F369B0584166666666623C28410000006066B0584100000000713C2841666666A663B0584133333333743C28410000006060B058419A999999623C2841666666C65EB05841CDCCCCCC373C28419A9999995EB0584133333333083C2841CDCCCC2C5CB0584166666666CC3B28416666662655B05841666666669B3B2841CDCCCC0C50B05841CDCCCCCC703B2841333333534EB0584133333333403B2841666666064CB0584100000000073B2841CDCCCCAC4BB0584166666666C53A2841333333534DB0584133333333AE3A2841CDCCCCAC4EB05841CDCCCCCC8F3A28419A99997950B0584166666666603A28416666664656B058419A999999393A2841000000205EB05841666666661B3A2841000000C065B05841CDCCCCCC083A2841CDCCCC6C68B0584100000000073A2841CDCCCC6C68B0584100000000E5392841333333D368B058419A999999B43928419A9999F965B05841CDCCCCCC893928410000000061B05841333333337C392841333333535CB05841666666667C3928416666660657B058419A9999997D3928410000002053B058410000000074392841CDCCCC4C4FB058410000000054392841000000A04DB058419A9999991A392841333333134EB0584166666666E93828416666664650B0584100000000DF3828410000008050B05841CDCCCCCCA6382841CDCCCCCC51B05841666666665F382841CDCCCCCC51B0584133333333493828416666668651B0584166666666113828419A9999D950B0584100000000DB372841000000C051B058419A999999A3372841CDCCCCAC53B05841CDCCCCCC70372841CDCCCC8C53B058410000000032372841CDCCCCAC51B0584166666666F1362841666666264FB0584133333333C8362841000000C04EB0584100000000A6362841CDCCCCEC50B05841666666667C362841666666E655B058416666666654362841CDCCCCAC57B05841333333332B362841333333F356B058419A999999FA352841333333D353B0584100000000CE352841666666864FB0584166666666AF352841CDCCCC4C4DB05841666666667F352841666666C64CB058413333333365352841000000C04DB05841CDCCCCCC4E3528419A9999994EB05841666666662B352841CDCCCC2C51B0584100000000103528416666664654B058419A99999907352841CDCCCCEC54B0584166666666EF342841CDCCCCCC56B058419A999999113528410000002062B0584166666666273528410000000076B058419A9999992F352841CDCCCCAC84B058413333333319352841333333738DB058416666666610352841000000A095B05841CDCCCCCC1D352841333333D3A3B05841CDCCCCCC4835284133333373C3B05841666666665B3528419A999979CDB05841CDCCCCCC67352841CDCCCC2CD4B05841CDCCCCCC77352841000000E0D9B05841333333338F35284100000000DEB0584166666666BB352841000000C0E5B05841000000000C3628419A999919EEB05841333333335236284100000080F5B05841666666669E3628419A999959FEB0584133333333C8362841666666C602B158419A999999EC362841000000A006B158416666666608372841CDCCCC8C08B1584166666666953728410000004012B15841CDCCCCCC04382841666666E61CB158419A99999952382841666666C627B15841CDCCCCCC713828419A9999D92EB15841333333339A382841CDCCCCCC3AB15841CDCCCCCC7D382841CDCCCCCC44B1584100000000503828419A9999194CB1584133333333E7372841333333B355B1584133333333B13728410000002057B15841CDCCCCCC8D372841CDCCCC0C58B15841333333330B3728413333333359B158419A999999FE3628416666666659B1584133333333A33628419A9999F95AB1584100000000583628413333339359B158419A9999993E3628419A99991959B158416666666633362841000000A059B158419A999999F1352841CDCCCCAC5CB158419A9999999F3528419A99995965B158413333333372352841333333F36CB15841CDCCCCCC6E352841CDCCCC8C6DB15841333333336F352841CDCCCCCC6DB158410000000070352841666666E672B158419A999999783528413333337377B15841666666667C352841CDCCCC4C7AB15841CDCCCCCC5F352841000000A079B15841CDCCCCCC4A3528410000002079B1584166666666353528419A99999978B158416666666621352841CDCCCC4C78B1584100000000F23428416666662678B15841CDCCCCCCBE3428416666660677B15841333333339B342841000000E073B1584166666666703428416666664670B15841CDCCCCCC38342841CDCCCCEC64B15841CDCCCCCC15342841CDCCCC2C65B158419A9999990A3428410000008065B158419A999999F53328419A99991966B1584166666666D5332841CDCCCC8C67B15841CDCCCCCCB3332841000000C068B158413333333396332841333333736AB158413333333381332841333333136CB158410000000072332841CDCCCC2C6DB15841CDCCCCCC603328419A9999396EB15841CDCCCCCC423328419A99993970B15841CDCCCCCC21332841CDCCCC2C73B1584166666666033328419A9999B975B1584100000000EA322841666666C677B1584166666666CF322841000000207AB158419A999999B6322841333333B37CB15841666666669F322841333333537EB158416666666640322841CDCCCC6C86B15841666666663C322841CDCCCC4C87B15841333333333A322841000000E087B158419A9999993A322841000000A089B15841CDCCCCCC3A322841000000408AB158413333333339322841CDCCCC2C8EB15841CDCCCCCC343228416666664692B15841CDCCCCCC20322841CDCCCC4C96B158419A99999913322841666666E698B158410000000007322841CDCCCCEC99B1584166666666F5312841000000609BB158419A999999DD3128419A9999799CB158419A999999C83128419A9999999EB1584166666666C431284100000000A1B1584100000000C431284166666626A3B1584100000000BA312841CDCCCC6CA5B1584100000000AE3128419A999939A7B1584100000000A03128419A999939A9B158413333333392312841666666C6A9B1584133333333843128419A9999F9A8B15841CDCCCCCC743128419A999959A7B15841666666666D312841333333B3A6B1584166666666653128419A9999B9A6B15841666666665A312841000000A0A7B158416666666649312841666666E6A7B158419A9999993131284166666686A8B15841333333331E312841000000A0A9B15841666666661931284166666646ABB158419A99999910312841000000A0ADB15841000000000C312841CDCCCCCCAFB158419A999999F43028419A999959B3B1584100000000E430284133333373B4B158419A999999D0302841CDCCCCCCB5B1584133333333C230284133333333B7B1584100000000B330284166666606B8B15841CDCCCCCC9C30284100000000B9B15841000000008F30284133333373BAB15841CDCCCCCC7E302841666666E6BBB15841666666666930284166666666BCB158419A99999945302841CDCCCCACBCB158413333333338302841CDCCCCACBDB158410000000022302841CDCCCC8CBEB15841CDCCCCCC0E302841000000A0BEB15841CDCCCCCC04302841CDCCCC4CBEB15841CDCCCCCCFD2F28419A9999D9BDB1584100000000F12F28419A999919BDB1584100000000E32F28419A999999BBB1584100000000D02F28419A999979BAB1584166666666C22F284100000020BAB1584166666666B32F284133333313BAB15841CDCCCCCC9A2F284133333373BAB1584166666666832F284166666646BAB158419A999999712F284133333353B9B1584100000000672F284133333333B8B15841CDCCCCCC5B2F284166666686B6B15841333333334D2F28419A999999B3B15841CDCCCCCC3B2F284133333313B2B1584166666666222F28419A999939B0B15841000000000E2F284100000040AFB1584100000000FC2E2841CDCCCC8CAEB1584133333333E52E28419A999959AEB1584100000000C62E28419A999939AEB1584100000000B52E2841333333D3ADB1584133333333A72E284166666686ADB158419A9999998D2E28419A999959ADB15841666666667F2E28419A999999ADB15841CDCCCCCC742E2841CDCCCC6CAEB1584100000000702E2841CDCCCC0CAFB15841CDCCCCCC672E284133333333B0B15841CDCCCCCC642E2841CDCCCC6CB0B1584166666666542E28419A9999B9B1B1584100000000422E28419A999999B3B1584100000000322E284100000000B5B15841333333331E2E2841333333D3B5B15841333333330B2E28419A999979B7B1584166666666FF2D2841000000C0B8B1584166666666012E2841000000C0B8B158419A999999062E284100000040BAB15841666666660B2E2841333333D3BBB15841CDCCCCCC0B2E284100000040BCB15841CDCCCCCC0A2E284100000060BDB1584166666666072E28419A9999D9BEB1584133333333042E2841CDCCCC2CC0B158419A999999002E2841CDCCCCACC1B158419A999999FF2D2841333333D3C2B15841CDCCCCCCFE2D2841000000E0C3B15841CDCCCCCCFE2D284133333393C5B1584133333333FB2D2841CDCCCC6CC7B15841CDCCCCCCF62D2841666666A6C8B1584100000000F22D2841CDCCCC2CCAB1584166666666EC2D2841CDCCCCECCCB1584133333333E52D2841CDCCCC8CD1B15841CDCCCCCCE12D28419A9999B9D3B15841CDCCCCCCDD2D28419A999919D7B1584133333333D92D284133333373D8B1584100000000D52D284133333393D9B1584133333333CC2D2841000000C0DAB15841CDCCCCCCBE2D28419A9999F9DCB158419A999999B62D284100000080DFB1584133333333B42D28419A9999D9E0B1584100000000B12D2841666666E6E2B15841CDCCCCCCAF2D2841CDCCCC4CE5B1584100000000AB2D2841CDCCCC4CE7B15841CDCCCCCCA02D2841CDCCCCECE9B15841CDCCCCCC932D2841333333B3ECB1584166666666832D2841000000C0EEB15841CDCCCCCC782D2841333333B3F0B158419A999999662D2841666666C6F3B15841CDCCCCCC5D2D28419A999939F5B1584166666666542D284133333393F6B1584166666666502D28419A999999F7B15841000000004B2D284100000040F9B158419A999999492D28419A999919FBB1584100000000422D28419A999979FDB158419A999999392D2841CDCCCC4C00B25841666666662E2D2841CDCCCC8C03B2584133333333282D2841CDCCCC0C05B258419A999999192D2841333333B306B258419A999999042D2841000000A007B2584100000000F72C28416666660608B258419A999999DA2C2841CDCCCCCC09B2584166666666CF2C2841CDCCCC4C0BB2584100000000C02C2841333333B30CB2584100000000B32C2841666666060FB25841333333339E2C28419A9999B911B2584100000000912C2841333333B313B2584133333333882C28416666662615B25841333333337B2C28413333331317B25841CDCCCCCC702C2841333333D318B2584100000000622C28419A9999391BB2584133333333532C28419A9999391DB2584166666666432C2841333333931FB258419A999999352C28410000008021B258419A999999282C28419A9999D922B25841CDCCCCCC152C28419A9999F924B25841CDCCCCCC032C28416666662626B258419A999999EA2B28419A9999D927B2584133333333D92B2841CDCCCCEC28B2584166666666C62B28419A9999D929B2584166666666B52B2841CDCCCCCC2AB25841CDCCCCCCA62B2841CDCCCC2C2CB258419A999999962B28419A9999792FB25841CDCCCCCC852B2841000000C032B2584133333333692B2841CDCCCC4C37B2584166666666562B2841CDCCCC8C3AB25841666666663A2B2841000000003DB25841CDCCCCCC242B2841CDCCCCEC3EB25841666666660D2B2841333333F340B258419A999999FE2A28413333335342B2584166666666EB2A28416666666643B2584166666666DD2A2841666666E644B25841CDCCCCCCD12A2841CDCCCC2C47B2584100000000D12A28419A9999B949B2584166666666D32A2841333333734CB2584100000000CB2A2841CDCCCCAC4FB258419A999999C02A2841333333D352B25841CDCCCCCCB32A2841CDCCCC8C55B258419A999999A12A28416666668657B25841000000009B2A28410000002058B2584133333333E8292841CDCCCC8C63B2584100000000A0292841CDCCCC0C6AB25841666666661A292841CDCCCC2C75B2584100000000F3282841333333D379B2584166666666DB282841666666A68BB2584133333333D52828419A99995991B258419A999999D1282841666666A692B2584166666666DA2828419A99993994B2584166666666E3282841000000C095B2584100000000E7282841CDCCCC6C96B2584100000000F92828419A99997999B2584133333333072928419A9999199CB25841333333330D292841CDCCCC6C9DB2584100000000142928419A9999199FB258419A9999991829284166666686A0B25841666666661B292841333333F3A1B25841333333331C292841000000E0A2B25841000000001D292841333333B3A3B25841000000001F29284100000080A5B2584100000000202928419A999919A7B25841333333332029284100000080A8B25841000000002029284133333393AAB25841CDCCCCCC1E292841CDCCCCECACB258419A9999991D292841000000C0AEB25841333333331D292841CDCCCC6CAFB258419A9999991B292841CDCCCC4CB1B25841CDCCCCCC1729284100000060B3B258419A9999991229284133333333B6B25841333333330E29284166666626B8B2584166666666082928419A999939BBB258410000000005292841000000A0BDB258419A99999900292841333333B3C0B25841CDCCCCCCFA28284166666646C4B2584100000000F3282841333333F3C7B25841CDCCCCCCEE2828419A999979C9B2584133333333E828284166666606CCB2584166666666E728284133333353CCB2584133333333DE282841333333B3CFB2584133333333CA282841CDCCCCCCD6B2584133333333BB2828419A999959DCB25841CDCCCCCCB72828419A9999B9DDB258419A999999B128284133333373E0B2584133333333AA282841CDCCCC0CE4B2584166666666A4282841333333D3E6B2584100000000A028284133333393E9B258419A99999999282841CDCCCC0CECB25841333333338D28284133333393F1B258419A99999989282841000000E0F2B25841000000008428284133333333F6B258410000000080282841000000C0F9B258419A9999997E282841000000E0FCB25841000000007E2828413333333300B358419A999999812828410000008003B3584166666666872828413333335306B35841333333338E2828416666662609B358413333333397282841666666E60BB3584133333333A1282841666666E60EB3584100000000AC2828410000004011B3584100000000B5282841CDCCCC0C13B3584133333333BA2828419A9999F913B35841CDCCCCCCC02828413333333315B3584100000000C8282841CDCCCCAC16B3584100000000D1282841000000E018B3584133333333D8282841CDCCCCAC1AB3584133333333E0282841CDCCCCAC1CB3584133333333E9282841CDCCCC6C1EB3584133333333F42828410000006020B3584100000000FC282841333333D321B3584100000000012928419A9999F922B358413333333305292841CDCCCC4C24B358419A999999092928419A99993926B35841000000000D292841666666E627B358419A9999990E2928416666664629B358419A9999990F292841333333B32BB358410000000010292841333333132EB3584100000000102928419A9999792EB35841CDCCCCCC102928419A99993930B358416666666611292841333333B331B3584166666666142928410000006034B358413333333317292841000000E036B358419A99999918292841333333B338B358410000000018292841666666263AB35841CDCCCCCC16292841CDCCCC2C3BB358410000000012292841CDCCCC8C3CB358416666666609292841CDCCCC0C3EB3584166666666002928419A9999393FB3584133333333DE282841CDCCCC8C42B3584100000000CB2828416666668644B3584133333333B12828419A99997946B35841000000009E2828416666664648B35841CDCCCCCC95282841CDCCCC4C49B358419A99999983282841333333134CB358413333333374282841666666864EB35841CDCCCCCC69282841CDCCCCEC50B358416666666662282841333333D352B35841CDCCCCCC58282841CDCCCC6C55B358410000000053282841CDCCCC6C57B35841000000004F2828410000006059B35841000000004D282841666666665CB35841CDCCCCCC4A282841333333F35DB35841666666664A282841000000605EB358419A99999947282841333333B35FB358419A999999422828410000002061B35841666666663D2828419A99991962B358419A999999382828419A99999962B35841333333332D2828416666668663B3584100000000232828416666664664B358419A999999192828413333331365B3584133333333092828419A9999B966B35841CDCCCCCCFF272841CDCCCC8C67B3584133333333FA272841000000E067B3584100000000F32728419A9999F967B35841CDCCCCCCEA2728410000000068B3584166666666DB272841333333D367B3584133333333C72728419A99997967B358419A999999B9272841CDCCCC4C67B3584166666666A6272841CDCCCC2C67B35841000000009B2728416666662667B358419A9999998A272841CDCCCC4C67B3584133333333832728413333337367B35841000000007B272841666666C667B358416666666678272841000000E067B35841CDCCCCCC6A272841CDCCCC6C68B35841666666665A272841000000E068B358419A99999945272841CDCCCC2C69B35841333333332D2728419A99997969B358416666666604272841CDCCCC2C6AB3584166666666E0262841000000406AB35841CDCCCCCCC9262841CDCCCC2C6AB3584133333333B9262841000000406AB3584166666666A8262841333333936AB3584166666666A1262841666666C66AB358419A9999999C262841CDCCCCEC6AB35841333333338B262841666666E66BB358419A99999978262841333333536DB358419A99999958262841CDCCCC0C70B3584166666666432628413333335372B358419A99999926262841CDCCCC0C75B3584133333333182628419A99995976B35841000000000E2628410000000077B3584166666666FC252841CDCCCCCC77B3584133333333EA2528410000000079B358419A999999E4252841000000A079B35841CDCCCCCCDB252841CDCCCC4C7BB358419A999999D4252841000000C07DB3584100000000CD2528419A99995980B3584166666666C42528419A99993982B358419A999999B32528410000008084B35841000000009A2528413333339387B35841333333338D2528419A99997989B35841333333337D252841666666A68BB358419A9999996D252841CDCCCC2C8DB358410000000063252841CDCCCCEC8DB35841CDCCCCCC57252841333333738EB35841000000004A252841333333D38EB35841000000003D252841333333D38EB358416666666627252841CDCCCCCC8EB358416666666619252841666666C68EB35841666666660B252841333333D38EB358413333333303252841333333F38EB3584133333333FC242841CDCCCC0C8FB35841CDCCCCCCE3242841000000A08FB35841CDCCCCCCC4242841CDCCCCAC90B3584166666666A6242841CDCCCCEC91B3584133333333A02428413333333392B358413333333399242841CDCCCC8C92B35841CDCCCCCC852428413333335393B358419A999999722428419A9999D993B358413333333356242841666666C694B358419A999999232428410000004096B35841CDCCCCCC1E2428416666666696B35841CDCCCCCC062428419A99995997B35841CDCCCCCCE82328416666668698B3584133333333E4232841666666C698B358419A999999DC2328410000004099B35841CDCCCCCCCA232841CDCCCC6C9AB3584166666666A2232841000000609DB358419A99999992232841333333F39EB358416666666668232841CDCCCC4CA2B35841333333335523284166666686A3B3584100000000462328419A999919A4B35841666666661B2328419A9999F9A5B358419A9999990923284100000000A7B358419A999999FB2228419A999979A7B358419A999999E122284100000000A8B3584133333333BD22284100000040A9B3584133333333A722284100000040AAB35841666666669022284133333353ABB358419A9999997922284100000060ACB358419A999999652228419A999979ADB358413333333353222841333333F3AEB35841CDCCCCCC1E2228419A999979B3B35841	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	01010000206A08000070391AB71F3F2841343333C31AB35841	430120000	Z	Aurec-sur-Loire	4301200	43012	43	84	23
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	01010000206A080000F1F5CD43DBEE2641666666D61F975841	430130000	Z	Vissac-Auteyrac	4301300	43013	43	84	18
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	01010000206A0800004D739BE601A9254166666696FAAE5841	430140000	Z	Autrac	4301400	43014	43	84	8
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	01010000206A08000014669180035126419A9999C9878A5841	430150000	Z	Auvers	4301500	43015	43	84	21
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	01010000206A080000D85ABD436D432641666666F6BAB45841	430160000	Z	Auzon	4301600	43016	43	84	17
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	01010000206A08000021B2D6DF5A5026419A99994905B15841	430170000	Z	Azérat	4301700	43017	43	84	18
01060000206A08000001000000010300000001000000ED04000066666666EA142741333333F31A8A58419A999999EE1427419A999999218A584133333333FD1427419A999999288A58410000000008152741000000C02D8A5841666666661F15274133333353368A58413333333338152741333333D33D8A58419A9999994515274133333393408A5841333333334E15274100000060428A5841CDCCCCCC6A1527419A999979498A584100000000811527419A9999394F8A58419A999999911527419A999919578A5841CDCCCCCCA21527419A999979618A58419A999999B41527419A9999D96B8A584166666666BA152741666666E6708A584133333333C1152741CDCCCC0C758A584133333333CD152741666666267B8A584100000000DB1527419A9999F9818A584100000000E7152741333333D3878A58419A999999FE15274166666626918A5841CDCCCCCC0B162741333333D3988A58410000000013162741333333B39D8A58413333333315162741CDCCCC0C9F8A58419A999999211627419A9999D9AA8A584133333333281627419A9999F9AF8A58419A9999992716274166666626B88A584100000000231627419A9999D9BE8A58410000000018162741333333F3C58A58419A99999911162741000000C0CD8A58419A9999990D162741CDCCCC2CD58A5841666666660C16274166666666D78A5841CDCCCCCC0C162741CDCCCC4CDB8A5841666666660F1627419A9999B9E48A5841CDCCCCCC0F162741666666C6E58A58410000000010162741333333B3E68A58413333333316162741000000A0EC8A58419A9999991C162741000000E0F48A5841666666661F16274100000040FB8A584100000000211627419A9999B9018B58410000000021162741333333D3058B5841666666661D162741000000800A8B584166666666141627419A999919128B5841CDCCCCCC101627419A999919178B5841CDCCCCCC101627419A9999591C8B5841000000001816274166666626248B5841666666661D1627419A999959288B5841CDCCCCCC191627419A9999B9328B5841CDCCCCCC15162741333333133F8B5841CDCCCCCC121627419A9999B9468B5841CDCCCCCC0C162741333333B34B8B5841333333330216274100000040508B584133333333FC1527419A999919538B58419A999999F915274100000060548B58419A999999DB152741CDCCCC6C5F8B584166666666C615274133333353678B584166666666B0152741666666C66F8B5841333333338F15274100000020798B5841CDCCCCCC70152741333333B3808B5841000000006B152741000000C0828B58410000000081152741CDCCCC0C828B58419A9999998E152741CDCCCCAC818B584166666666A8152741CDCCCCEC808B5841CDCCCCCCCE15274100000060808B584100000000E6152741666666E6808B5841666666660B162741CDCCCC0C828B5841666666664216274166666626848B5841000000004616274166666646848B5841CDCCCCCC8A1627419A999979868B584133333333A1162741CDCCCCEC868B584100000000D41627419A999959888B58413333333309172741CDCCCCEC898B58416666666632172741000000A08A8B5841000000006F172741333333738A8B584166666666A7172741CDCCCC0C8A8B584133333333D1172741CDCCCC6C898B5841666666660618274100000060888B5841CDCCCCCC28182741CDCCCC8C878B58419A9999993A182741CDCCCCEC868B58419A9999994E182741CDCCCC2C868B584133333333651827419A9999F9848B58419A9999998718274100000060848B58419A9999999F18274166666686848B5841CDCCCCCCBD18274100000000858B5841CDCCCCCCDE182741000000A0858B584166666666FA18274100000080868B58419A99999945192741CDCCCCCC878B584133333333C8192741666666E6918B5841000000004B1A2741000000C0A08B584133333333A51A274166666666A48B5841333333338B1B2741666666A6A68B58419A9999990D1C274100000080B08B584100000000DC1C27419A9999B9B78B5841CDCCCCCC1F1D27419A999919B78B58419A9999996D1D274166666666B58B5841CDCCCCCCB41D27419A999959B58B58419A999999E11D274133333373B68B5841666666660A1E274166666626BA8B5841CDCCCCCC1F1E2741000000E0BB8B58419A999999391E274166666686BD8B5841666666666A1E27419A999959C08B5841000000009C1E274100000060C28B58419A999999C31E274166666606C58B584133333333E21E2741CDCCCC4CC78B584133333333F61E274166666646C98B5841CDCCCCCC031F2741CDCCCC6CCB8B5841000000001E1F274166666606D08B5841333333333A1F274133333393D38B584100000000611F2741000000C0D88B5841333333338A1F274166666646DE8B58419A999999C41F2741CDCCCC8CE68B584166666666E41F2741000000A0EB8B584100000000F21F2741333333F3ED8B5841000000000120274133333373F08B5841333333335B20274100000020FE8B584100000000842027419A999919048C584133333333A6202741CDCCCCCC098C584166666666DC202741000000C0098C5841CDCCCCCC3B212741333333130C8C58419A999999212127419A999979188C58413333333362212741333333331F8C5841000000008A212741CDCCCCCC118C58419A999999BC212741000000A00B8C58419A99999902222741CDCCCC4C0F8C58419A9999991B232741000000C0218C58419A9999993923274133333373208C5841666666668B242741000000E0058C5841666666669F2427419A9999D9058C5841CDCCCCCCD2242741666666061B8C58413333333324252741CDCCCC6C318C58419A99999943252741CDCCCC8C428C584133333333EE25274166666666468C5841333333332A26274100000060508C58419A9999993E26274133333313598C5841000000003F262741333333D35C8C5841000000002126274100000080608C58419A999999F7252741666666A6658C584100000000BC252741333333B36A8C5841CDCCCCCC9E2527419A9999B9748C58419A99999959252741CDCCCC4C818C5841666666665A252741666666468D8C5841666666665A252741666666C68D8C5841333333336F25274100000000998C58413333333317262741000000A0A68C5841666666667F262741333333D3AE8C5841CDCCCCCC6926274166666646B68C58416666666679262741CDCCCCECB78C584166666666C126274166666646BD8C584100000000F026274166666606C18C58410000000032272741CDCCCC8CB88C5841CDCCCCCCD5272741CDCCCC2CC78C584133333333BE272741CDCCCC6CD08C584100000000D9272741333333B3D28C584133333333D6272741000000E0D38C5841CDCCCCCCD3272741666666E6D48C5841CDCCCCCCD02727419A999919D68C584100000000CA272741333333F3D88C584100000000C927274166666646DA8C584133333333C827274133333333DB8C584133333333C827274100000000DD8C584100000000C8272741666666A6DD8C584100000000C627274166666666DE8C584166666666BF2727419A9999D9DF8C5841CDCCCCCCB22727419A999939E28C58419A9999998227274166666646EB8C58416666666670272741CDCCCC8CEE8C5841000000006D272741333333F3EF8C5841CDCCCCCC6E2727419A9999D9F18C58419A99999951272741CDCCCCCCF28C5841CDCCCCCC55272741CDCCCCACF38C5841000000006827274166666646F68C58410000000074272741666666A6F78C5841666666669227274100000040FB8C584166666666C0272741CDCCCC2C008D584166666666E327274100000060048D5841333333330B282741CDCCCCAC098D58416666666629282741CDCCCC8C0C8D58416666666650282741333333B30F8D5841000000006A2827419A999919128D58413333333376282741CDCCCCAC138D5841666666668028274166666686158D5841CDCCCCCC89282741333333B3188D58413333333391282741000000A01C8D584166666666982827419A999979218D5841333333339A28274100000000278D58410000000096282741CDCCCC4C308D58419A9999999928274100000020368D5841CDCCCCCC982827419A9999393A8D5841000000009C282741333333B33B8D5841CDCCCCCCA42827419A9999193E8D58419A999999B5282741666666A6428D5841CDCCCCCCD028274133333353478D58419A999999F4282741666666664B8D58419A99999914292741666666864F8D5841333333333A29274133333313568D5841CDCCCCCC4A292741666666C6578D58413333333368292741CDCCCC6C5A8D5841666666668D292741CDCCCC6C5D8D58419A999999A429274100000040608D584100000000AF29274166666666628D58419A999999B52927419A999999648D584166666666BD2927419A999959698D584166666666C4292741000000006C8D584133333333CD292741333333536D8D584100000000DF292741CDCCCC0C6F8D58419A999999212A2741CDCCCC8C768D584133333333452A2741666666C67A8D5841000000005D2A2741CDCCCCEC7D8D5841666666667A2A274100000020838D58419A999999942A274133333393878D5841CDCCCCCCB22A27419A9999198D8D584100000000CE2A27419A999919928D5841CDCCCCCCDE2A2741CDCCCC8C948D58419A999999EB2A2741CDCCCCCC958D58419A999999F92A27419A999939978D584100000000A32B2741CDCCCC8CB58D5841CDCCCCCCD52B27419A999979BF8D58419A999999E92B274133333373BF8D5841CDCCCCCC602C27419A999919B48D5841CDCCCCCC922C2741CDCCCC0CB48D58419A999999472D27419A9999D9C28D584166666666652D2741CDCCCC8CC18D584133333333D12D274133333393B28D584166666666D22D274133333373B28D5841CDCCCCCC032E274166666626AC8D5841CDCCCCCCE52D27419A9999B9A58D584166666666DB2D274133333373A38D5841CDCCCCCCEA2D2741333333739B8D584133333333F82D274133333373948D584100000000F82D274100000080908D584133333333F72D274133333333848D5841CDCCCCCC1E2E2741CDCCCCEC7D8D584100000000822E2741333333D3738D584100000000A02E2741CDCCCCCC738D584100000000D22E274100000000758D584166666666212F2741CDCCCCAC6E8D584166666666492F2741000000E06F8D5841CDCCCCCCC72F274100000060738D58419A999999DB2F2741CDCCCCEC738D5841CDCCCCCCD72F2741000000C06F8D584100000000CD2F27419A999999618D58419A999999C82F2741333333D35A8D584133333333C42F27419A999959568D584133333333BE2F2741000000C0518D584133333333B72F27419A9999194B8D5841CDCCCCCCB12F2741CDCCCC2C428D584133333333AA2F274133333313388D584166666666A52F274133333333348D5841CDCCCCCCB32F2741CDCCCC2C348D5841CDCCCCCCB52F2741CDCCCC2C348D5841CDCCCCCCBC2F274133333353348D5841CDCCCCCCC42F2741CDCCCCEC348D584166666666CC2F2741333333B3358D584133333333DB2F27419A999959388D584166666666E12F274133333353398D5841CDCCCCCCE82F2741000000203A8D584133333333F42F2741666666C63A8D5841CDCCCCCCFF2F2741CDCCCCEC3A8D5841CDCCCCCC073027419A9999D93A8D58419A9999990F302741CDCCCC2C3A8D5841000000001D30274100000040388D5841000000002730274133333333378D5841666666662E302741000000E0368D5841333333333C302741CDCCCC0C378D58419A9999996030274166666666388D58419A9999997C30274166666686398D5841666666668D3027419A9999F93A8D5841CDCCCCCCA3302741CDCCCCEC3D8D584100000000BF30274133333313418D5841CDCCCCCCDC30274100000080438D584133333333F33027419A9999F9448D58413333333305312741000000E0458D5841CDCCCCCC1531274100000040468D5841666666662A31274100000080468D58419A99999944312741000000C0468D58419A999999573127419A999979478D5841CDCCCCCC65312741CDCCCC2C488D58419A9999997D312741333333134A8D58419A9999999B3127419A9999394C8D584133333333B6312741666666C64D8D584133333333D7312741CDCCCC2C4F8D58419A999999F33127419A999959508D5841CDCCCCCC0C322741333333B3518D5841CDCCCCCC23322741CDCCCC6C538D5841CDCCCCCC47322741CDCCCC0C568D5841CDCCCCCC77322741333333B3588D58419A9999999F322741333333935A8D584133333333BF322741333333535C8D5841CDCCCCCCD8322741666666065E8D5841CDCCCCCCEA322741CDCCCC4C5F8D584133333333F63227419A999979608D5841CDCCCCCC07332741333333F3628D5841333333331833274133333393658D58419A999999273327419A999999678D5841000000003733274100000040698D58410000000046332741000000606A8D584166666666523327419A9999F96A8D5841000000005D332741CDCCCC2C6B8D58413333333367332741666666066B8D58419A99999972332741666666866A8D5841333333338233274100000080698D58413333333397332741CDCCCCAC688D5841CDCCCCCCA933274133333353688D5841CDCCCCCCCF33274133333353688D584133333333E333274133333393688D584133333333E9332741000000E0688D584166666666EC33274100000000698D5841CDCCCCCCF4332741CDCCCC0C6A8D584100000000043427419A9999196C8D58419A999999103427419A9999D96D8D5841CDCCCCCC17342741CDCCCC4C6E8D5841000000001F3427419A9999B96E8D58419A9999992A342741666666E66E8D58419A99999938342741333333D36E8D5841666666664A3427419A9999596E8D58410000000063342741333333136E8D5841666666667B342741666666466E8D5841666666668D3427419A9999F96E8D584100000000A134274100000000708D58419A999999D634274100000080728D58419A99999909352741CDCCCC8C748D5841666666663235274133333393758D58416666666652352741000000C0768D58419A9999996135274133333373778D5841CDCCCCCC7D352741333333336D8D5841CDCCCCCCAE352741666666665F8D584166666666CC35274100000020598D584166666666EA3527419A999919598D584166666666B7362741000000205B8D58419A999999BA362741333333F3598D584166666666BF3627419A999939598D584100000000CA3627419A999939588D584100000000D63627419A999959578D584166666666E236274166666606578D584100000000F9362741000000C0568D584133333333163727419A999959568D58416666666626372741666666E6558D58419A9999993A37274166666606558D58416666666659372741000000A0538D5841333333336F372741CDCCCCAC528D5841666666667837274166666666528D5841CDCCCCCC86372741CDCCCC0C528D58419A99999991372741CDCCCCCC518D584100000000A937274166666626518D58419A999999CD372741CDCCCC2C508D58419A99999998372741000000E0638D58413333333399372741000000206A8D584166666666B0372741000000006F8D5841000000007F382741000000606C8D584133333333A2382741CDCCCCEC6F8D5841666666667638274100000060808D5841000000006D382741000000608A8D58419A999999C738274100000000928D58419A999999FC382741CDCCCC4C948D584100000000DB382741333333139F8D58419A999999DC3827419A999999A28D58419A999999DA382741000000A0A58D584133333333D33827419A9999F9AA8D584133333333D3382741000000A0AC8D5841CDCCCCCCD8382741CDCCCC8CAF8D584166666666E338274166666646B38D584100000000F738274133333373B78D5841333333330E3927419A999959BC8D5841000000002339274100000020C18D58419A99999931392741CDCCCC0CC58D5841666666663F392741CDCCCC0CCA8D5841666666664D39274166666686CF8D58413333333361392741000000C0D58D58419A999999753927419A999959DC8D58419A9999998639274100000060E18D58419A99999992392741CDCCCCECE38D58419A9999999B392741CDCCCC2CE58D584133333333B53927419A999919E88D584133333333C2392741CDCCCCCCE98D584166666666C2392741333333F3E98D58419A999999C439274100000000EB8D584166666666C4392741000000C0EB8D584166666666D639274100000020EA8D584100000000FB392741CDCCCCCCE58D584166666666183A2741CDCCCCACE28D584133333333223A2741666666A6E18D58419A9999993F3A2741CDCCCC8CDE8D5841000000005B3A274100000020DC8D584100000000963A274100000040D78D584133333333B43A27419A999999D48D5841CDCCCCCCB53A274100000080D48D584100000000CB3A27419A999939D38D5841CDCCCCCCDF3A2741666666A6D18D584100000000043B274133333393CE8D5841333333331C3B274166666626CC8D58419A9999992C3B274166666606CB8D5841666666664E3B27419A999939C98D584133333333653B274100000000C88D584133333333A03B2741333333B3CC8D5841CDCCCCCC793C2741CDCCCCACF58D584133333333B63C274133333393028E584100000000D43C2741CDCCCC0C008E58419A999999233D27419A9999B9F98D58419A999999373D2741333333B3F98D584100000000E33D274100000080128E5841000000007A3E274133333393228E5841CDCCCCCC563F274133333353318E58416666666665402741666666063F8E584133333333C8402741333333B32E8E584166666666FA40274100000020318E584166666666A541274133333333418E584166666666B9412741CDCCCC2C418E5841CDCCCCCCFE4127419A9999193C8E58410000000031422741CDCCCC8C3E8E5841000000004F422741000000803E8E5841333333336C4227419A999959358E584166666666EC422741666666263A8E58413333333303432741666666063B8E584166666666D04227419A9999B9268E584166666666A54227419A9999390B8E584133333333E142274166666666078E58419A999999A843274133333333028E584166666666F843274100000020028E58419A999999C0442741666666A6058E5841CDCCCCCCBF442741666666A6FB8D5841CDCCCCCCD344274166666666FA8D58419A9999991945274133333313F98D5841000000001B45274133333353F08D5841CDCCCCCC88452741333333F3EE8D58419A999999874527419A999939DC8D584133333333AF45274133333373D88D584133333333FF4527419A999999D98D58419A99999981462741333333B3DF8D584100000000E64627419A999919E78D5841333333335F472741333333F3FA8D5841CDCCCCCC28482741333333F3148E58419A999999DC482741666666C6148E584100000000DC482741666666C60A8E58419A999999A349274133333313088E584100000000254A2741333333B3008E58419A9999997E4A27419A999919FE8D58419A999999814B274133333393F28D5841CDCCCCCCB64C274166666686E98D584166666666564D27419A9999D9E68D584133333333C24D274100000080DC8D584100000000504E274133333313E48D584133333333B44E27419A9999F9E88D584133333333D24E2741333333F3E88D5841CDCCCCCCD34E2741333333F3E88D584133333333DA4E27419A999939E68D58419A999999DD4E27419A9999B9E38D584133333333E04E274100000000E28D58419A999999E24E27419A9999B9DC8D5841CDCCCCCCE74E2741CDCCCC0CDA8D58419A999999EA4E2741CDCCCCACD88D58419A999999ED4E2741000000E0D48D584100000000EB4E2741666666A6D18D58419A999999E84E274100000080CE8D58419A999999E74E274133333393C88D584166666666E64E27419A999999C68D58419A999999EC4E274100000060C18D58419A999999EE4E274100000060BF8D584166666666EB4E27419A999919BC8D584166666666E84E2741333333F3B88D584133333333E44E27419A999979B78D58419A999999D14E2741333333D3B48D584166666666CB4E27419A9999B9B28D584166666666BC4E2741666666E6A28D584166666666B14E274100000060998D584133333333B44E27419A999959978D584166666666BA4E2741333333F3958D5841CDCCCCCCDF4E2741CDCCCCCC908D5841CDCCCCCCF34E27419A9999398D8D584100000000064F2741000000E08A8D584100000000BE4E2741000000208B8D584100000000BE4E2741CDCCCC6C8A8D584133333333BE4E2741CDCCCC4C898D584100000000BF4E2741CDCCCC8C878D584133333333C14E274133333313848D5841CDCCCCCCBB4E2741333333B37F8D584133333333AC4E27419A999939798D584133333333A14E274133333393738D584100000000834E27419A9999796B8D5841000000005E4E27419A999999608D584166666666574E2741333333735C8D5841000000004A4E274133333373588D58419A999999414E274133333313558D5841333333333F4E274133333353538D5841000000003C4E2741CDCCCCEC508D5841CDCCCCCC3C4E2741CDCCCC6C4F8D584133333333454E2741666666064E8D5841666666664C4E2741000000204D8D58419A9999994F4E2741CDCCCC8C4C8D5841CDCCCCCC534E2741666666E64B8D584166666666574E2741CDCCCCAC498D584166666666574E27419A9999F9488D584133333333504E27419A999919448D58419A9999994E4E274100000000438D5841000000002D4E2741CDCCCC6C388D5841000000002D4E27419A999919378D584100000000334E2741666666A6358D584166666666504E274133333393318D5841666666665C4E2741000000C0308D58419A9999996A4E2741333333D32F8D58419A999999754E2741000000802E8D584166666666934E2741333333F3268D584133333333944E274100000040268D58419A999999854E274133333393238D584100000000824E2741CDCCCCEC228D584133333333794E2741666666061F8D5841CDCCCCCC684E2741333333531A8D5841CDCCCCCC4B4E27419A999999148D584133333333474E274166666686128D5841000000004B4E2741000000600E8D5841CDCCCCCC564E2741CDCCCC8C078D5841333333335F4E27419A9999D9028D584100000000664E27419A999939008D584100000000674E274166666626F98C584100000000674E27419A999919F68C58419A999999744E274133333353F18C58419A999999864E2741CDCCCCACED8C58419A9999998D4E2741CDCCCCCCEB8C584166666666964E27419A999959E68C5841CDCCCCCC964E2741000000A0E48C5841333333337C4E2741666666C6DC8C58419A999999604E274133333333D38C5841CDCCCCCC564E274100000060CF8C5841CDCCCCCC544E2741CDCCCC8CCE8C584166666666534E274166666686CB8C5841CDCCCCCC574E2741333333B3C98C5841000000008D4E27419A9999F9BF8C584133333333CE4E274100000020B48C584166666666DC4E27419A9999F9A78C58419A999999E44E2741000000008F8C58419A9999991F4F2741333333F37F8C58419A999999504F274166666666678C584133333333544F2741666666A6668C5841CDCCCCCC6C4F2741CDCCCC4C608C5841CDCCCCCC954F27419A9999B9558C58419A999999A54F2741CDCCCC0C4F8C5841CDCCCCCCB14F2741000000204C8C5841CDCCCCCCC64F2741CDCCCCCC488C584133333333D44F27419A999939458C5841CDCCCCCCFB4F2741000000A0398C58410000000006502741000000A0328C584166666666155027419A9999B92A8C58413333333319502741CDCCCCCC288C5841666666661F50274100000080268C5841000000001E50274166666606148C58419A99999931502741666666460F8C5841333333333B50274100000080078C5841000000004F50274100000080068C58419A9999996B5027419A999939F28B58419A9999997350274100000000D38B5841CDCCCCCCE1502741000000E0D78B58416666666645512741000000E0D58B58413333333389512741CDCCCC8CD48B58416666666657512741CDCCCC6CC58B58419A999999E6502741CDCCCCACB88B5841000000007C50274166666646BB8B5841000000003650274133333393BC8B58419A999999B34F27419A999939B58B58419A999999814F274166666606B48B5841CDCCCCCC454F27419A999999B68B584133333333F54E2741333333B3AC8B584100000000B34E274100000080A58B58419A999999A64E2741CDCCCC2CA48B58419A999999A34E2741666666E6A38B58419A999999534E2741000000209B8B5841CDCCCCCCF24D274166666626918B584133333333CB4D2741CDCCCCCC8C8B584133333333B24D2741000000E08B8B58419A999999724D274100000060898B58419A999999694D2741CDCCCC0C898B58419A9999994E4D2741CDCCCCCC868B5841CDCCCCCC284D27419A999919828B584133333333F84C2741CDCCCC4C7F8B584166666666CF4C2741000000407E8B584133333333C54C2741000000007E8B58419A999999A44C2741000000E07D8B5841CDCCCCCC7E4C2741666666A67D8B5841CDCCCCCC4A4C2741666666067C8B584133333333224C2741CDCCCC6C798B58419A999999014C274100000060768B584166666666FC4B274133333313768B5841CDCCCCCCFB4B2741CDCCCC6C758B584100000000FA4B27419A999919738B584133333333F24B274133333353698B584100000000F94B274166666646608B58419A999999F84B2741333333D35E8B584133333333F74B2741333333F3578B584100000000EA4B2741000000204F8B584166666666EA4B2741333333F34A8B584166666666EB4B274133333393428B584133333333E24B2741333333733D8B584166666666CE4B274133333313368B5841CDCCCCCCAA4B274133333353298B584133333333A54B274166666606268B5841CDCCCCCCA44B2741333333D3258B5841333333339B4B274133333393218B5841666666669B4B2741000000201E8B584100000000A44B2741666666261A8B58419A999999A64B274166666606198B584133333333AF4B27419A999999148B584100000000AC4B2741000000000F8B584100000000A24B2741000000400C8B58419A999999704B2741CDCCCC8C028B584100000000664B274133333373008B584100000000574B2741666666A6FD8A584133333333334B27419A999979F68A584166666666FE4A2741666666E6EB8A5841CDCCCCCCCE4A274100000060E18A584133333333AB4A2741666666C6DB8A5841CDCCCCCC8E4A2741666666A6D58A5841CDCCCCCC834A2741333333B3D08A5841333333337F4A2741666666A6CE8A584133333333144A274166666666CB8A584166666666EB492741333333D3C68A584100000000C7492741CDCCCC0CC28A58413333333390492741333333B3AE8A58413333333352492741333333739A8A5841CDCCCCCC2B492741000000608E8A584133333333BF482741CDCCCC2C828A5841CDCCCCCC82482741666666867A8A58419A9999997D482741CDCCCCCC7A8A58410000000074482741000000007B8A5841333333336E482741666666C67A8A5841333333331F48274133333393718A584166666666AD472741000000A0658A584100000000804727419A999979628A58416666666638472741000000C05B8A5841CDCCCCCC0B47274133333313588A58419A999999FE46274100000000578A5841CDCCCCCCE346274166666646568A58419A999999D546274133333333558A5841333333339E462741000000E0508A58416666666675462741333333B34E8A5841000000005B462741CDCCCC6C4C8A58413333333327462741333333F3458A58419A999999F3452741CDCCCC4C418A5841CDCCCCCCD1452741333333933E8A58419A999999C44527419A9999F93D8A584166666666BA452741666666E63D8A5841CDCCCCCCAE452741000000403E8A5841CDCCCCCCDB45274100000060308A584100000000E3452741CDCCCC4C248A584133333333FB452741000000E01A8A5841000000003E462741666666C60E8A584133333333234627419A9999590B8A5841666666660446274166666626098A58419A999999F0452741CDCCCC8C058A584100000000DE45274133333313028A584100000000C1452741333333D3FC895841CDCCCCCC9B452741666666E6F5895841CDCCCCCC7D452741CDCCCCECEF895841000000006945274166666646EC89584133333333604527419A999999EA895841666666665F4527419A9999D9E9895841000000006445274100000020E989584166666666404527419A9999B9E289584100000000F544274100000000CA89584166666666DE44274166666666CC895841CDCCCCCCDF4427419A999979D089584133333333B84427419A999979D28958419A999999C943274100000080C18958419A999999A94327419A999919C8895841CDCCCCCC91432741333333B3C889584166666666664327419A999919C589584133333333E442274133333373B9895841CDCCCCCCCE4227419A999919B6895841CDCCCCCCA542274166666666B68958419A99999982422741666666A6B3895841CDCCCCCC574227419A999919B28958419A99999936422741666666C6AF89584133333333E741274100000020A2895841CDCCCCCC84412741333333D3A0895841000000000B41274166666666A289584133333333084127419A9999F99C895841333333330741274133333373998958419A999999074127416666668697895841000000000C41274166666686958958419A9999991A412741CDCCCC2C918958413333333323412741000000608E895841CDCCCCCC26412741000000008C8958419A999999284127419A9999F987895841000000002841274100000040868958419A99999925412741000000608589584100000000294127416666668684895841666666662E412741333333B3818958419A999999344127419A9999F97F895841333333333F412741CDCCCC2C7E895841CDCCCCCC4E412741666666A67B895841333333335C412741666666667889584166666666654127419A9999B973895841000000006C412741CDCCCCCC6D8958419A99999977412741CDCCCC8C67895841CDCCCCCC834127413333339363895841000000008B412741000000E061895841333333339141274166666646618958416666666694412741000000C05F8958419A9999999A412741000000A05C8958419A999999A4412741000000C05689584166666666A9412741000000C05289584100000000AA412741666666A65089584166666666AA412741000000404F89584100000000A6412741000000004B8958419A999999A5412741000000004689584133333333A9412741666666A64189584133333333AF412741666666A63E8958419A999999B24127419A9999B93B8958419A999999B1412741333333D335895841CDCCCCCCB0412741333333932F89584100000000B4412741CDCCCCAC2C89584133333333B8412741333333D32989584166666666CC412741333333732389584133333333E2412741666666A61D89584166666666F2412741CDCCCC8C1989584100000000FD412741000000C0178958416666666609422741333333F3158958419A9999991942274166666666138958410000000021422741CDCCCC8C12895841CDCCCCCC2B422741333333D3118958413333333337422741CDCCCC8C10895841CDCCCCCC40422741CDCCCC8C0E8958410000000051422741000000200A8958410000000059422741333333130789584166666666614227413333331301895841666666666B42274133333333F8885841666666667142274166666666F1885841CDCCCCCC72422741333333B3ED88584133333333754227419A9999B9EA885841000000007A4227419A9999B9E78858410000000080422741000000A0E58858419A9999998642274100000080E488584133333333904227419A999959E28858419A9999999A4227419A999919DF885841CDCCCCCCA74227419A9999B9D988584133333333BE422741333333F3D288584166666666C842274133333393CE88584100000000CC42274166666606CC88584133333333CE422741CDCCCCACC588584166666666D542274166666646BA88584100000000DE42274166666666B08858419A999999E3422741CDCCCC2CAC88584166666666EF422741333333738E88584166666666EE422741666666468C88584100000000E8422741666666A68A8858419A999999E6422741CDCCCCCC888858419A999999E942274100000040878858419A999999EA4227419A999939858858419A999999EF422741666666C68388584166666666F74227419A999959828858413333333301432741666666A677885841CDCCCCCC01432741000000A07488584166666666FB422741000000E0728858419A99999909432741000000206B8858413333333319432741CDCCCC6C5D885841000000004F4327419A999919498858419A99999993432741CDCCCC8C35885841333333338D4527419A9999794C88584166666666B54627419A9999B95A88584166666666E6462741333333B34B885841000000002D472741666666E638885841000000002C472741666666A6288858413333333321472741CDCCCC6C1D88584166666666F7462741000000000288584133333333F746274133333313DE8758419A99999911472741000000E0BC87584100000000B44627419A9999D9B8875841CDCCCCCC8446274133333393B68758410000000073462741CDCCCC8CB58758413333333364462741333333B3B487584100000000464627419A999979B28758419A999999DD452741CDCCCC4CAA875841CDCCCCCCD145274166666666A987584166666666C245274133333373A8875841CDCCCCCCB145274133333373A7875841333333339F45274166666686A6875841666666669745274100000020A6875841000000008445274100000060A587584166666666714527419A999999A4875841000000004A45274166666646A3875841CDCCCCCC20452741CDCCCCACA18758416666666603452741CDCCCCCCA087584100000000E9442741000000C09F87584133333333D4442741333333D39E87584166666666C54427419A9999D99D87584133333333A3442741CDCCCC4C9B8758419A999999704427416666660697875841000000001A4427419A99991990875841CDCCCCCCBE4327413333331388875841666666669E4327416666664685875841CDCCCCCC8B4327419A9999D9828758410000000060432741333333537B875841666666662F43274100000020728758419A99999904432741CDCCCCEC6987584166666666E34227419A9999596D87584100000000D1422741000000206F87584166666666A1422741CDCCCCEC72875841CDCCCCCC88422741CDCCCC2C718758410000000015422741000000C0568758419A9999999D412741000000404A8758416666666669412741333333D3458758419A99999937412741000000403F875841CDCCCCCC0F412741666666C64187584166666666B74027419A99999959875841CDCCCCCCAD4027419A9999995E875841333333338840274166666686668758413333333341402741CDCCCCEC6387584166666666E03F2741CDCCCC2C64875841CDCCCCCCBA3F2741333333D3678758419A9999998C3F274133333353628758419A999999903F27419A9999D95D87584166666666723F2741333333135B87584166666666A23F2741000000A04F875841666666667A3F2741000000004D875841000000008C3F27419A9999F946875841333333338A3F2741000000603C87584133333333B23F27416666662634875841CDCCCCCCA53F2741CDCCCC4C3287584166666666993F2741CDCCCCEC30875841CDCCCCCC893F27419A9999D92F8758419A9999997D3F2741666666262F87584133333333713F2741666666E62D87584100000000353F27419A9999D92A8758419A9999999B3E27410000008025875841CDCCCCCC2D3E2741333333F322875841000000000D3E2741000000E02A87584166666666A03D27419A99993940875841CDCCCCCC473D27413333333354875841CDCCCCCC6D3D2741333333D35B87584166666666743D27419A9999D966875841666666663F3D2741666666E66B8758419A999999BB3C27419A9999397E87584166666666623C27419A9999F977875841333333333B3C2741CDCCCC2C81875841CDCCCCCC1C3C274100000060878758419A999999F03B2741666666A68F8758419A999999C63B2741666666269387584166666666963B27419A9999B99087584133333333F43A2741000000808587584133333333B13A2741333333F37E87584133333333AB3A27416666662672875841CDCCCCCC763A27419A9999796E87584133333333653A2741666666467187584133333333553A2741CDCCCC4C74875841666666663E3A27413333333379875841CDCCCCCC2E3A27419A9999F97C8758419A999999263A2741333333737F87584100000000BF392741000000A073875841CDCCCCCC5F39274133333313698758419A99999908392741333333F360875841666666664F382741000000404A875841CDCCCCCC0B3827419A999979418758419A99999937372741000000801D875841000000008C362741333333730387584166666666C2352741CDCCCC6CE986584166666666A43527419A999939E8865841CDCCCCCC7235274166666606EC86584133333333C0342741CDCCCC2C008758419A999999AC342741333333F3038758416666666611352741333333D3128758419A999999EC352741666666063D87584166666666F6352741666666663D875841CDCCCCCC05362741000000E03E875841CDCCCCCC2C3627419A999999438758410000000051362741CDCCCCEC4787584166666666723627419A9999794C87584166666666913627419A9999D95087584100000000C436274166666646588758416666666633372741000000A0688758419A9999996B3727410000008070875841666666668F3727419A9999F97487584133333333A0372741000000A0768758419A999999A7372741CDCCCCCC7687584166666666D6372741666666867587584100000000213827419A9999997287584100000000263827416666666672875841000000003E3827419A9999D975875841CDCCCCCC693827419A9999597B875841CDCCCCCC91382741666666868087584100000000B03827419A9999B984875841CDCCCCCCC43827419A9999D987875841CDCCCCCCE9382741000000608C875841CDCCCCCC1E392741666666E692875841CDCCCCCC4C3927419A9999D9988758413333333370392741333333F39D8758419A9999997B39274166666606A0875841666666668A39274100000040A38758416666666692392741000000A0A48758413333333397392741000000C0A5875841CDCCCCCC1639274133333373A4875841CDCCCCCCCE382741CDCCCC8CA7875841CDCCCCCC7C38274100000060AB8758413333333379382741000000C0AB8758419A99999968382741CDCCCC8CAD8758410000000066382741666666E6AE875841333333336B38274166666646B0875841CDCCCCCC8F38274133333333B5875841000000004839274100000000BB87584100000000303927419A999939C28758410000000024392741CDCCCCCCC487584166666666123927419A999999C78758419A999999FF382741000000A0C987584100000000EB38274133333373CB87584100000000E3382741CDCCCC0CCC87584166666666E9382741CDCCCC4CCD87584100000000FB38274166666626D08758419A99999917392741333333D3D3875841CDCCCCCC4A39274100000060D9875841666666665F3927419A999959DB87584100000000FF392741666666C6EB875841CDCCCCCC4F3A27419A999919F7875841CDCCCCCCF23A2741333333D30788584100000000783C2741333333132088584133333333783C2741333333932288584166666666643C274133333353268858419A999999D93B27419A9999793588584100000000623B27419A9999993A885841333333331E3A2741000000004888584133333333EC392741000000E04D885841CDCCCCCC9D3927413333331354885841000000006439274133333393568858419A999999443927419A9999395988584166666666E1382741666666E65D88584133333333C1382741666666C65E885841333333339C392741333333B3838858410000000039392741000000C08B885841333333333E392741666666868C885841CDCCCCCC41392741CDCCCC0C8E8858410000000039392741000000209288584100000000223927419A9999599E885841CDCCCCCC1F39274166666626A088584166666666213927419A9999F9A1885841CDCCCCCC9C38274166666626928858416666666666382741333333138F8858419A999999BF3827419A9999798288584166666666D2382741666666867E8858416666666693382741CDCCCC8C768858419A9999994F382741666666C66D8858416666666638382741000000606A885841CDCCCCCC22382741CDCCCCEC678858419A99999908382741CDCCCCEC6A88584166666666DC372741333333736F88584100000000B937274133333333728858419A9999999537274133333373748858419A999999793727416666660677885841CDCCCCCC68372741333333137988584166666666553727419A9999197C8858419A99999940372741CDCCCCEC7E885841666666668336274133333333698858419A9999991B3627419A9999F97D8858419A99999909362741000000007E88584166666666A1352741CDCCCC0C72885841666666669335274100000020758858419A99999987352741CDCCCCCC7888584100000000763527419A9999F97E8858416666666651352741333333138C885841CDCCCCCC483527419A99995990885841CDCCCCCC41352741CDCCCC2C958858410000000036352741333333B39C885841666666662F352741333333739F885841666666662E352741000000E09F8858419A9999992C3527419A999959A08858419A99999919352741CDCCCC0C9E8858410000000003352741333333339A885841CDCCCCCCF7342741CDCCCC6C9788584100000000F0342741333333739488584100000000EA342741666666869288584100000000DD34274166666666908858419A999999D0342741000000008F885841CDCCCCCCBF342741000000A08D8858419A999999B5342741666666068588584100000000BA342741666666C67A88584100000000B63427419A999959728858413333333372342741333333335F8858419A99999965342741CDCCCC2C5A88584100000000593427419A9999B955885841333333333B342741CDCCCCEC4F8858413333333313342741CDCCCCCC4B88584166666666B1332741000000E041885841000000008C332741CDCCCCAC3A8858419A9999996C33274100000080358858410000000055332741333333D333885841333333333A3327416666668631885841CDCCCCCC123327419A9999593288584133333333DB32274133333393318858413333333388322741000000E02A8858419A99999945322741333333732388584100000000263227419A999919208858419A999999FB3127419A9999391D88584100000000C7312741333333731A885841CDCCCCCCB13127419A9999191A885841CDCCCCCC8F312741CDCCCC6C168858416666666665312741333333F3118858410000000047312741666666460E885841666666662F312741666666C60A8858416666666623312741CDCCCCEC0888584133333333F4302741CDCCCCAC0188584166666666692F2741333333F3CC87584100000000732F2741CDCCCCECC78758419A9999997C2F2741CDCCCCACC187584100000000FA2E274133333353B58758419A999999EF2E27419A999919AF875841CDCCCCCC292F2741CDCCCC4C9787584166666666E32E2741666666A68E87584133333333B52F2741000000E07B87584166666666DE2F2741000000C06A8758419A999999AF2F27419A99995966875841333333337F2F2741333333F36087584133333333782F2741000000A05F875841666666666E2F2741666666A65C875841CDCCCCCC682F2741333333B35887584100000000772F2741CDCCCC2C5887584100000000B12F2741CDCCCC0C5687584100000000C62F2741666666865587584166666666CE2F27419A9999995487584166666666D52F27419A9999B94F87584100000000E12F27413333337347875841CDCCCCCCF02F27419A9999594387584166666666083027419A999999408758416666666626302741666666E63E87584100000000DD302741CDCCCC8C368758419A9999991B312741CDCCCC4C34875841666666664C30274100000060118758419A999999053027419A9999B90387584166666666FB2F27419A99993901875841333333330F302741333333B3FE8658419A99999992302741333333D3F586584133333333C430274166666606F2865841000000003A312741CDCCCCECD3865841CDCCCCCC9C3127419A999999C38658419A999999B4322741CDCCCC0CC286584166666666E632274100000080BF86584100000000F9322741000000C0AC86584100000000033327419A9999B9AC865841CDCCCCCC7B3327419A999919B98658419A99999926342741666666E6C7865841666666662B3527419A9999D9D68658419A999999DF352741CDCCCCECDC86584166666666E935274166666666DA865841333333338E352741666666C6C78658419A999999F734274133333373BB865841CDCCCCCC8834274133333313B08658419A9999998834274133333313AB86584100000000B0342741CDCCCC8CA386584133333333F53427419A9999B99986584100000000FF3427419A9999F9958658419A999999B8342741CDCCCCCC9086584166666666B8342741CDCCCC0C8D8658419A99999925352741333333F3828658413333333357352741666666E67C865841CDCCCCCCB53427419A999919658658419A9999994033274166666646328658413333333376322741666666060D86584133333333DA30274166666646CB855841CDCCCCCCAA30274100000000BE8558413333333326302741333333B3E585584133333333EB2F274100000080F38558419A9999996E2F2741666666C6028658419A999999622F2741333333730286584133333333552F27410000002002865841CDCCCCCC362F27416666664601865841CDCCCCCC2C2F2741CDCCCC4C01865841CDCCCCCC142F2741000000600086584133333333192E2741333333B3F685584133333333002E274133333333F585584166666666AD2D274166666686F1855841CDCCCCCC872D2741CDCCCCACEF855841CDCCCCCC512D274100000020ED85584166666666352D274166666606EC85584133333333182D274133333393EA855841CDCCCCCCF32C2741000000A0E885584100000000BF2C27419A9999B9E58558419A9999999B2C274100000020E485584133333333602C2741CDCCCC0CE28558419A9999995D2C274166666626E38558419A9999994B2C2741CDCCCC8CEA8558419A999999392C2741CDCCCC8CF485584166666666252C274133333313FE855841CDCCCCCC0B2C2741333333130A86584166666666F22B27419A9999F91486584166666666D92B27416666660620865841CDCCCCCCD32B27419A9999592286584133333333BC2B2741000000A02B865841CDCCCCCCB62B27419A9999792E865841CDCCCCCC8E2B2741000000E04386584166666666842B2741000000C04B8658419A9999997A2B2741666666C65486584166666666752B27419A9999D95B86584133333333722B27419A99991962865841333333336F2B27419A9999B96686584166666666692B2741333333D36B865841CDCCCCCC5E2B2741333333936F86584100000000452B2741000000607786584133333333122B2741CDCCCC0C84865841CDCCCCCCD42A27419A999939948658419A999999AA2A2741666666069E86584166666666912A2741333333D3A3865841333333336C2A27419A999999AB865841CDCCCCCC452A27419A999959B2865841666666661E2A274100000060B986584133333333F729274133333313C086584166666666C3292741333333B3C98658413333333388292741CDCCCC2CD486584166666666782927419A9999F9D686584133333333412927419A9999D9E0865841333333330C292741666666A6E986584166666666EF2827419A9999F9ED8658413333333371282741CDCCCCCCE3865841666666669F27274166666686E18658419A999999D626274100000040D5865841CDCCCCCCB826274166666686D6865841CDCCCCCC8726274133333313E386584100000000A525274166666686118758419A99999911252741666666A634875841CDCCCCCCCC24274133333333468758410000000057242741CDCCCC0C6387584100000000072427419A99997970875841666666668423274100000080858758410000000081232741333333F38A87584100000000B1232741CDCCCC4C8E87584133333333E0232741000000C091875841000000000E24274166666686958758419A9999993B2427413333337399875841CDCCCCCC6E2427419A9999799E87584133333333902427419A9999D9A187584166666666AA242741CDCCCCACA487584133333333BF24274100000060A78758419A999999D52427419A999979A98758419A999999E024274133333313AA87584166666666D7242741333333D3AA87584166666666CE242741CDCCCC4CAB875841CDCCCCCCB92427419A9999B9AB875841000000009B24274133333313AC875841666666668C24274133333333AC875841CDCCCCCC8124274100000080AC8758410000000063242741CDCCCC0CAE875841CDCCCCCC382427419A999959B0875841666666661424274166666626B287584100000000EC2327419A9999D9B387584100000000CC232741333333B3B48758419A9999999E23274133333333B58758419A9999996123274100000000B68758413333333334232741CDCCCC8CB68758419A9999992323274133333373B6875841000000001023274133333313B687584133333333FE22274133333373B58758419A999999E422274166666626B487584100000000CD222741CDCCCCECB28758419A999999A7222741333333B3B1875841333333338F22274166666606B1875841000000007A2227419A9999D9B0875841CDCCCCCC6522274166666646B18758416666666654222741666666E6B18758416666666641222741CDCCCC2CB38758419A9999992A22274100000000B5875841CDCCCCCCFC21274100000080B887584166666666BF212741000000A0BC875841333333339F2127419A9999D9BE8758419A99999982212741000000C0C0875841000000006C21274133333393C28758410000000056212741CDCCCCCCC4875841000000003A21274100000080C88758419A99999917212741333333B3CC87584133333333F0202741CDCCCC4CD1875841CDCCCCCCC7202741CDCCCC6CD5875841000000009C2027419A999979D98758419A9999997D202741333333F3DC8758413333333357202741CDCCCC8CE2875841333333332E202741000000A0E887584166666666FE1F274166666606F087584166666666BB1F2741CDCCCC6CF9875841000000007E1F2741CDCCCCAC01885841CDCCCCCC601F2741CDCCCC0C06885841666666666A1F2741666666C607885841000000005C1F2741666666C6098858419A999999451F27419A9999190C885841333333331F1F2741666666860F88584166666666FF1E2741333333931288584133333333EA1E2741CDCCCC0C1588584166666666D51E274100000060188858419A999999B11E2741333333B31E88584166666666761E27419A999999298858419A999999531E2741000000202F8858419A9999991B1E2741CDCCCCEC3688584166666666FD1D2741000000E03A885841CDCCCCCCE21D2741000000003E885841CDCCCCCCCE1D27410000004040885841CDCCCCCCC21D27413333331342885841CDCCCCCCB41D27419A9999B944885841CDCCCCCCA41D2741666666E646885841CDCCCCCC8D1D274100000020498858419A9999996D1D2741000000404C8858419A999999531D27419A9999194E8858419A9999993E1D2741000000204F885841CDCCCCCC111D27419A9999D9508858419A999999D41C2741CDCCCC4C5388584100000000B91C2741333333F35488584166666666781C27419A9999D94F88584133333333CF1B27419A9999596F885841333333339D1B2741CDCCCC6C6F88584166666666E91A27419A9999D9708858419A9999997B1A27419A99991972885841CDCCCCCC311A27419A9999197C8858419A999999D81927410000006078885841CDCCCCCC97192741333333137288584100000000EE182741333333736F8858419A9999996F182741CDCCCC0C6E88584133333333021827419A9999397188584166666666BE172741000000E074885841666666662C172741CDCCCCEC868858419A999999D2162741CDCCCCEC90885841333333337A1627419A9999D99F88584133333333AE16274100000060A3885841CDCCCCCC54162741666666C6BD885841333333334C162741CDCCCC8CD6885841000000003D16274133333333E988584133333333F0152741CDCCCCCCE9885841333333334915274166666666ED885841333333334F152741666666A6EE885841333333335A15274133333353F68858419A999999641527419A9999D9FB8858410000000070152741CDCCCCACFE8858419A9999998015274133333373018958419A9999999B1527419A99995906895841CDCCCCCCAB152741666666A60B89584166666666B9152741333333730F89584133333333C4152741000000401189584133333333DF152741000000C013895841CDCCCCCC0C162741666666C61689584100000000211627419A9999F917895841CDCCCCCC1C162741666666E61D895841CDCCCCCC161627416666666626895841666666662416274133333333268958410000000025162741CDCCCC2C288958410000000021162741CDCCCCCC2A89584100000000161627419A9999F92F8958419A9999990A1627413333335336895841CDCCCCCCFC152741333333D33F89584133333333F3152741666666464889584166666666EA152741333333B35089584166666666E3152741666666E6588958419A999999DD152741CDCCCCAC5F895841CDCCCCCCCE152741000000406C89584133333333C6152741666666E67389584100000000BD1527419A9999597A895841CDCCCCCCAB15274133333313828958419A9999999D152741CDCCCC4C8989584100000000931527419A9999B98F89584133333333891527410000006096895841CDCCCCCC7C152741333333139D895841333333336C15274100000020A5895841CDCCCCCC5B15274133333313AD895841333333334F1527419A999979B4895841666666664015274166666686BD895841333333333115274133333313C6895841666666661E152741666666E6CF8958419A99999915152741666666A6D5895841CDCCCCCC0B1527419A999979DF8958416666666604152741CDCCCCECE68958419A999999F914274100000020F2895841CDCCCCCCF41427419A999979FC8958419A999999F114274100000020078A584133333333ED14274100000080138A584133333333EC142741CDCCCC2C168A584100000000EC142741CDCCCC8C168A584166666666EA142741333333F31A8A5841	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	01010000206A0800004731FBB3612D274133333373FF895841	430180000	Z	Bains	4301800	43018	43	84	38
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	01010000206A080000646F072FB47C2741666666B6EA785841	430190000	Z	Barges	4301900	43019	43	84	7
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	01010000206A0800007E2DDD9C90042841666666B692AD5841	430200000	Z	Bas-en-Basset	4302000	43020	43	84	47
01060000206A0800000100000001030000000100000015030000666666661F92274133333313EF985841666666661F9227419A9999F9F29858410000000034922741000000A0FF9858410000000062922741333333B3069958410000000098922741CDCCCC4C0B99584133333333C6922741000000001599584166666666E4922741CDCCCC6C1E99584166666666F59227419A9999592B9958419A999999F8922741CDCCCCAC2D99584100000000F89227416666664630995841CDCCCCCCF5922741CDCCCC6C3B995841CDCCCCCCFE9227413333331346995841CDCCCCCC1E932741000000605999584100000000539327416666662667995841666666666A932741666666A66F9958413333333387932741000000007A99584166666666C0932741333333D3969958419A999999C29327419A9999B99999584166666666D19327419A999959A499584133333333DC93274133333353AF99584100000000F79327419A999999BA99584166666666E8932741CDCCCC2CC89958419A999999A6932741666666A6DB9958419A9999998793274133333373E3995841CDCCCCCC7393274166666686E8995841333333337393274100000000EE9958416666666665932741666666A6F2995841CDCCCCCC6693274100000080F5995841CDCCCCCC7893274166666646FA99584100000000C19327419A9999790D9A5841CDCCCCCCCE932741CDCCCC2C119A5841000000000F942741333333B31C9A5841000000006F942741000000002A9A58419A999999CB94274166666666329A5841CDCCCCCCE89427419A9999F93B9A5841CDCCCCCC65952741000000604A9A584133333333A295274166666646569A584166666666C2952741333333B3679A5841333333331A962741CDCCCCCC8B9A5841CDCCCCCC41962741333333D3999A5841666666666C962741333333D3A89A5841666666669A9627419A9999D9C59A584133333333AC9627419A999979D69A584166666666C696274166666686EE9A584133333333D296274166666666049B584100000000D396274166666606069B584133333333A8962741333333D3099B584133333333A49627419A9999390A9B5841CDCCCCCC84962741000000000F9B5841CDCCCCCC7696274100000080119B58419A99999930962741CDCCCC2C1E9B584166666666D59527419A9999F92C9B584133333333B69527419A999939329B5841666666664C95274100000020449B58419A999999D0942741666666C6599B58416666666688942741CDCCCCAC689B5841333333336C9427419A999959729B5841666666665C942741CDCCCCCC779B58416666666655942741CDCCCC2C7B9B5841CDCCCCCC5294274166666646839B5841CDCCCCCC539427419A9999D9839B58419A9999996F942741CDCCCCEC929B5841333333339694274166666686A59B5841000000009B94274133333333BA9B5841CDCCCCCC8B9427419A999939D19B5841000000009A9427419A999939DD9B584133333333A1942741CDCCCC2CE39B58419A999999A79427419A999939E59B584100000000C794274166666626EF9B584100000000D4942741333333D3F29B58419A999999D694274133333353FD9B584100000000E1942741666666C6069C5841666666660A9527419A999919119C58419A99999925952741666666C6179C5841666666662F952741666666C61A9C58419A999999389527419A9999991D9C5841333333335295274166666606229C58419A9999996B9527419A9999B9259C58419A99999987952741CDCCCCEC2C9C5841000000008C952741CDCCCC0C2E9C58419A99999992952741CDCCCC4C2F9C5841CDCCCCCCA795274166666686339C584166666666B69527419A999919379C58419A999999C3952741333333F33D9C584166666666C99527419A999939419C58419A999999CC952741CDCCCC0C439C584100000000D795274133333333479C584166666666E6952741333333734B9C584166666666EF952741000000E04C9C584133333333FF952741333333534F9C584100000000069627419A999999509C5841000000000A962741666666E6539C5841CDCCCCCC079627419A999979599C58419A99999902962741CDCCCC6C609C58410000000009962741666666E6659C5841000000000C96274100000060689C5841000000000C96274100000080689C5841333333331F9627419A9999997D9C58416666666620962741CDCCCC4C7F9C58419A9999992596274100000020809C5841666666664D9627419A999979869C5841000000004F9627419A9999B9869C58419A9999996096274100000080899C58416666666694962741000000408E9C58419A999999E696274133333313959C5841CDCCCCCC3F972741333333F39C9C584133333333A397274133333313A59C584100000000DA972741333333D3AA9C58419A999999F6972741000000A0AD9C58419A9999990F98274100000060AE9C584133333333299827419A999939AE9C5841333333332A98274133333333AE9C5841333333336E982741CDCCCCACAC9C58413333333388982741333333F3AC9C584100000000AD98274166666606AF9C584100000000CA982741333333F3B29C58419A999999449927419A999999C79C58419A999999999927419A999999D29C5841CDCCCCCCB9992741333333D3D69C584166666666BE992741CDCCCC4CD79C5841333333333A9A274100000040E49C5841CDCCCCCC5B9A2741333333D3E99C584100000000649A2741CDCCCC4CEC9C5841CDCCCCCC6F9A27419A9999D9EF9C58419A999999819A274100000060FB9C5841666666668D9A2741000000E0029D58419A9999998B9A2741CDCCCC6C079D584133333333899A27419A9999D9089D584133333333619A2741CDCCCC0C249D5841000000005A9A274166666606299D58419A999999379A27419A999919409D5841333333331D9A27419A9999F9499D5841CDCCCCCCF9992741000000A0529D584133333333D099274133333333589D584133333333B1992741000000405B9D584100000000B6992741000000E05B9D584133333333CA992741CDCCCC6C5E9D584100000000CF992741CDCCCC0C5F9D58419A999999DE992741666666E6609D584166666666EF992741CDCCCC4C649D58419A999999F199274100000080659D584133333333F799274100000040689D584100000000049A27419A9999D96C9D584100000000109A274133333373709D584166666666129A274166666626719D5841CDCCCCCC1D9A274166666626739D5841666666662F9A27419A999999749D5841CDCCCCCC3E9A274166666626759D584133333333609A2741666666C6759D584133333333799A274100000080769D5841333333339D9A27419A999939779D5841CDCCCCCCB99A2741666666C6779D58419A999999D49A2741666666A6789D584166666666E69A2741000000C0799D584133333333039B2741333333B3779D5841CDCCCCCC8F9B2741333333336B9D584100000000D99B2741666666A6639D584100000000F29B2741CDCCCC8C609D584166666666759C2741CDCCCC2C509D584100000000A59C2741333333334C9D584133333333C89C2741333333534B9D5841CDCCCCCCD19C2741000000204B9D58419A999999FD9C2741666666E64B9D584133333333129D2741666666264E9D584100000000209D274100000060529D584133333333229D2741CDCCCC0C539D58419A999999309D274133333373579D584100000000609D274100000080619D5841000000006D9D27419A9999F9659D584166666666729D27419A9999B9679D5841CDCCCCCC7C9D2741000000206B9D584166666666859D2741000000406C9D584166666666A19D2741000000806D9D584166666666BA9D2741666666A66E9D584100000000EA9D274166666606719D58419A9999992F9E274100000080739D584133333333389E2741666666E6739D58419A999999749E2741CDCCCCEC769D58419A999999E69E2741CDCCCC8C7C9D58419A999999599F2741000000C0819D584133333333769F274166666606839D58419A9999993AA22741666666C6A29D5841666666664EA22741000000C0A29D5841CDCCCCCC9DA22741CDCCCC2C9B9D58419A999999D9A22741000000A0989D58419A99999929A32741666666C6999D58410000000056A4274133333373A39D5841CDCCCCCCF6A42741666666C6AF9D58416666666683A527419A9999D9BA9D58419A999999FBA527419A999979BE9D58419A9999990FA6274133333373BE9D58410000000069A62741000000E0B69D5841CDCCCCCCF3A627419A9999F9A79D58416666666607A727419A9999F9A29D5841CDCCCCCC10A727419A9999799B9D58416666666656A7274166666666969D58416666666688A727419A999919959D5841CDCCCCCCDAA72741666666E6969D584166666666DEA7274100000000979D584133333333F6A727419A9999B9939D5841CDCCCCCC09A82741333333738D9D5841CDCCCCCC62A8274100000020829D5841CDCCCCCC47A9274166666666759D584166666666ABA92741CDCCCC4C709D58419A99999926AB2741666666A6699D584100000000C6AB27419A999939639D58419A9999990EAC2741000000405F9D58419A99999909AC27419A9999795B9D584100000000ECAB2741CDCCCC4C4D9D58413333333381AC2741333333933D9D5841CDCCCCCC4EAC274100000060379D58419A99999958AC2741000000E0349D5841666666663CAD2741666666A6169D5841000000007DAD2741CDCCCC4C109D58410000000082AD2741CDCCCC4C119D58419A999999A7AD274166666626149D584133333333D9AD2741CDCCCC4C179D5841CDCCCCCCF8AD2741666666E6199D5841666666660AAE27419A9999B91B9D58413333333324AE2741333333931F9D58413333333340AE274166666606249D5841333333334EAE2741000000C0259D58410000000074AE2741CDCCCC0C299D58419A99999983AE2741666666862B9D5841666666668DAE2741CDCCCC8C2D9D5841CDCCCCCC95AE274133333353309D5841CDCCCCCCCDAE2741CDCCCC0C319D58419A9999990BAF274100000000339D58410000000040AF274166666606359D58419A99999995AF2741000000002F9D584100000000CAAF2741333333F3279D58419A99999907B02741000000C0289D58419A9999996DB02741CDCCCC0C219D58419A99999985B0274166666686199D5841CDCCCCCCB1B02741666666C6159D584133333333E9B02741000000201A9D58410000000000B127419A9999D9189D58416666666617B12741CDCCCC8C179D58410000000043B12741000000E0159D58419A99999961B1274166666686159D58410000000080B1274100000000169D58419A99999999B1274133333313179D584166666666AFB1274166666626199D584100000000BDB12741666666261B9D58419A999999F0B22741000000200F9D584133333333A6B32741CDCCCC6C079D584166666666B0B32741000000E0079D5841CDCCCCCCBCB32741CDCCCC8C079D5841CDCCCCCCE5B32741666666E6039D5841CDCCCCCCFCB3274133333373029D58419A99999906B42741CDCCCC2C029D5841CDCCCCCC14B42741666666C6029D58419A99999928B42741CDCCCC4C059D5841000000003AB427419A9999B9069D58416666666651B42741CDCCCC6C079D5841CDCCCCCC62B427419A999939079D58410000000073B42741CDCCCC8C069D584100000000A4B4274100000040039D5841CDCCCCCCC5B427419A999959019D5841CDCCCCCCD2B4274166666686FB9C584133333333E1B4274133333333F59C58419A999999E6B42741000000C0F29C58416666666605B5274166666666EC9C5841333333332DB5274100000000E29C5841CDCCCCCC45B52741000000A0DB9C5841CDCCCCCC61B52741CDCCCC4CD79C58419A99999973B5274100000080D59C58416666666680B52741666666A6D49C58419A999999B9B52741333333B3D29C584166666666D0B5274100000080D19C584166666666F2B52741CDCCCCCCCA9C5841666666660FB6274133333353C49C58419A99999912B6274133333393C19C5841CDCCCCCC14B62741000000C0BD9C58419A99999919B6274166666626BC9C5841666666664CB6274133333393B39C58410000000050B6274100000000B29C58419A9999995BB62741CDCCCCECAA9C58419A99999960B62741000000A0A99C5841000000006CB62741666666469B9C58416666666693B62741000000C0939C58419A99999928B727419A9999D98A9C5841CDCCCCCC12B72741666666A6709C5841333333333BB72741333333735D9C58419A9999993AB72741000000E0599C5841CDCCCCCC46B72741000000C04E9C5841666666664BB72741666666C6479C5841CDCCCCCC4FB7274133333333469C58419A9999996EB7274133333313419C5841666666667EB72741000000E03D9C58419A99999992B7274133333313389C5841000000009BB72741CDCCCC4C359C5841CDCCCCCCA2B72741000000402D9C584133333333AAB72741CDCCCC4C259C584100000000A7B72741CDCCCC6C1D9C58419A999999A2B72741CDCCCC0C1B9C58416666666696B72741333333F3179C584133333333D5B7274166666606139C58419A999999CCB72741666666060E9C584100000000CFB727419A9999B9089C58419A999999D5B7274133333333009C584133333333D3B72741666666A6FA9B584100000000CBB72741333333B3F49B5841CDCCCCCCB7B7274166666646EB9B5841CDCCCCCCAFB7274166666626E49B5841CDCCCCCCA7B7274100000000D79B58419A999999A2B7274166666666C99B58419A9999999DB72741666666A6C09B58410000000091B72741CDCCCC8CB99B58410000000077B72741333333F3AD9B58413333333366B7274166666646A59B5841666666665FB72741666666A69D9B5841333333335FB7274133333353959B58413333333359B7274166666686949B5841CDCCCCCC17B72741333333338F9B5841CDCCCCCCD2B62741000000008B9B584100000000D2B6274166666626879B5841CDCCCCCCC9B6274166666666759B584166666666C8B62741666666C6739B584166666666C5B62741CDCCCCCC729B58419A999999B0B62741333333936F9B5841666666669DB62741000000E06B9B5841333333338CB62741CDCCCCCC659B5841CDCCCCCC7EB62741000000405F9B58410000000071B62741666666A6579B5841333333336BB62741CDCCCC0C4F9B5841CDCCCCCC66B6274166666646449B5841666666665DB62741666666C63E9B58416666666645B6274100000060369B5841CDCCCCCC21B62741000000202C9B58413333333306B62741CDCCCCEC209B584166666666F1B527419A9999D9179B584100000000DCB52741333333B3119B58419A999999C0B527419A9999190D9B584133333333A4B52741333333730A9B58416666666686B52741CDCCCCEC089B5841000000006FB527419A999939069B58416666666672B527419A999919049B58416666666671B52741666666A6019B5841333333336AB52741000000A0FE9A5841666666664EB5274100000020F89A58419A99999927B5274100000060F09A58416666666613B52741000000E0EB9A584166666666FDB427419A999999E49A5841CDCCCCCCE7B42741666666E6DB9A584100000000DCB42741666666E6D79A584166666666CCB427419A9999D9D59A5841CDCCCCCC9DB4274166666626D19A5841CDCCCCCC7CB4274166666686CD9A5841CDCCCCCC6DB42741CDCCCC2CCA9A58419A9999995EB42741CDCCCC6CC59A58416666666653B427419A9999D9C09A58410000000046B42741CDCCCC2CBD9A5841CDCCCCCCECB32741CDCCCCACAA9A584133333333B7B32741000000A0A29A5841CDCCCCCCD0B32741333333738C9A5841CDCCCCCCA3B32741666666C67D9A58410000000097B327419A9999D9559A58413333333387B327419A999999429A5841333333336FB32741333333D3399A58416666666661B327419A9999F92F9A5841CDCCCCCC58B32741666666462D9A58413333333339B327419A999999299A58416666666626B32741CDCCCC8C269A58419A9999991FB32741333333F3249A58419A9999991BB32741333333F3229A5841000000001EB32741CDCCCC6C1E9A58416666666633B32741333333D3189A5841666666663FB327419A999939159A58419A99999940B32741333333B3129A58419A9999993DB32741333333730F9A5841CDCCCCCC19B32741333333B3069A58419A999999F0B22741666666E6FB99584133333333BDB2274133333393F29958419A99999998B2274166666606EC995841000000007AB2274100000040E4995841333333335DB227419A999999DB9958410000000040B22741333333D3D99958416666666636B227419A999979D89958413333333327B2274100000080D29958413333333314B2274100000020C9995841CDCCCCCCFCB12741CDCCCC8CC29958419A999999D3B12741CDCCCCECB799584133333333CAB12741666666A6B499584100000000C4B127419A999979A799584166666666BBB12741CDCCCCAC9D99584100000000B8B12741000000809999584100000000A1B12741333333B3929958413333333382B12741CDCCCCAC8C9958419A9999996FB12741333333B388995841666666665FB127419A999959839958416666666651B127419A9999397F995841000000003FB12741000000C07B9958413333333321B127419A9999D9759958419A9999990DB12741CDCCCCAC709958419A999999F4B02741666666666799584133333333D6B027419A99993960995841CDCCCCCCB0B02741CDCCCC2C589958410000000092B02741333333D3519958413333333379B02741CDCCCC6C499958416666666673B02741CDCCCCCC46995841333333337BB0274100000020469958419A99999978B02741333333B344995841CDCCCCCC75B02741000000A03E9958419A99999975B0274100000060369958416666666672B02741333333B3349958410000000070B02741CDCCCCEC339958419A99999976B02741333333732C9958419A9999997DB02741666666E626995841333333337CB0274100000000249958419A99999971B02741333333531F9958410000000058B027419A99999917995841000000004FB027410000006014995841000000004EB02741CDCCCC6C139958413333333350B02741666666060F9958413333333356B02741333333B30A995841CDCCCCCC77B02741CDCCCC0C0099584166666666A4B0274166666606F398584166666666C6B027419A999939E898584166666666CCB02741000000A0E5985841CDCCCCCCCFB0274100000000E098584166666666D5B02741000000C0DC985841CDCCCCCCEAB02741333333D3D49858419A99999908B1274133333313C9985841CDCCCCCC2CB12741000000E0BA9858419A99999940B12741666666E6B2985841000000005EB12741CDCCCCECAA985841CDCCCCCC14B12741666666669E9858419A99999901B127419A9999399F98584166666666FAB02741333333339F98584133333333EDB02741000000E09E985841CDCCCCCCDFB02741333333D39D9858419A999999D8B02741CDCCCCAC9C98584100000000D5B02741666666069B98584166666666D3B02741333333D39898584133333333D4B0274133333393959858419A999999FFB027410000002090985841666666668BB02741666666867D985841333333335FB02741666666468B9858410000000054B027419A9999998A985841333333334BB027416666668689985841333333333EB027419A999979889858413333333334B02741CDCCCC4C87985841666666662DB0274100000000869858413333333321B027416666668684985841666666660FB02741CDCCCCCC82985841CDCCCCCC03B02741000000408198584100000000E9AF2741000000E0799858419A999999E1AF2741000000007998584100000000D6AF274100000040789858419A999999C8AF2741333333D3779858410000000095AF27410000006077985841000000007DAF2741CDCCCC0C77985841CDCCCCCC61AF27419A99997976985841CDCCCCCC4FAF2741666666A6769858413333333339AF27416666666677985841333333332EAF27410000004077985841333333331CAF2741333333D376985841333333330FAF2741CDCCCC8C75985841333333330CAF2741CDCCCCEC73985841CDCCCCCC0BAF2741333333F371985841CDCCCCCC0EAF2741000000C06F9858419A99999916AF2741666666666D9858419A9999992FAF274166666666689858413333333338AF27419A9999D966985841CDCCCCCC40AF274100000000659858416666666646AF274100000060639858416666666648AF2741666666A6619858410000000048AF2741CDCCCC0C609858419A99999940AF27419A9999395E985841CDCCCCCC39AF2741CDCCCC2C5D9858413333333327AF2741333333935B985841CDCCCCCC0FAF2741666666665A9858419A999999FEAE27419A9999195998584166666666E8AE2741CDCCCC6C579858419A999999DFAE27419A9999795698584166666666D8AE27419A999919559858419A999999D1AE2741CDCCCCCC529858419A999999CCAE2741000000A05198584166666666C6AE27419A999979509858419A999999BCAE2741333333B34F9858419A999999B3AE2741666666C64E9858419A999999A9AE2741000000004E985841333333339FAE2741000000A04D9858416666666688AE2741000000804D9858419A99999978AE27419A9999394E985841CDCCCCCC69AE2741CDCCCC2C4F985841CDCCCCCC59AE2741CDCCCC8C4F9858419A9999994DAE2741000000804F9858416666666643AE2741000000004F9858410000000035AE2741CDCCCC6C4D9858413333333327AE2741000000604B9858413333333318AE2741666666C6489858416666666608AE274133333333469858416666666600AE2741CDCCCCAC4498584100000000F6AD27419A99997942985841CDCCCCCCEAAD2741333333B33F985841CDCCCCCCE0AD2741666666263C9858419A999999DBAD2741666666E6389858419A999999D7AD2741CDCCCCEC3698584166666666D2AD2741000000203598584100000000CCAD2741666666A6339858419A999999C4AD2741333333133398584100000000BAAD2741333333533298584100000000B1AD274100000000319858416666666609AD2741CDCCCC4C279858419A99999900AD2741CDCCCC0C2998584166666666FDAC2741CDCCCCAC299858419A999999F4AC2741333333332A98584100000000E4AC2741333333532A98584166666666D2AC2741000000402A98584133333333C9AC2741CDCCCC0C2A98584133333333DBAC2741333333F3139858419A9999990AAD2741333333F3EB9758410000000013AD27419A999979B7975841666666662FAD27419A999939A29758413333333342AD27419A9999B9909758410000000040AD274100000040709758410000000036AD2741666666C66D9758410000000033AD2741CDCCCCEC679758419A999999E2AC2741333333F361975841CDCCCCCCC4AC27413333339359975841333333338AAC27419A99997952975841CDCCCCCCF6AC2741666666264D97584166666666F0AC2741666666064897584133333333ACAC27419A9999F94297584133333333ABAB274100000040249758413333333314AB2741CDCCCCEC1297584166666666F6AA27413333333314975841000000009DAA2741CDCCCCCC1B975841333333336FAA2741CDCCCC6C1F9758410000000072AA2741666666C62A975841CDCCCCCC62AA274133333313369758419A999999A5A92741666666063F97584133333333DDA82741666666A647975841666666667AA827419A9999D9469758413333333377A82741CDCCCCEC469758413333333381A727419A9999994E9758419A9999993BA72741CDCCCCAC539758413333333343A6274166666626699758413333333325A627413333333369975841CDCCCCCCC5A52741000000A05997584133333333ACA52741666666A655975841CDCCCCCC8AA52741666666C6509758413333333367A52741000000404B975841CDCCCCCC52A527419A999919489758419A9999993BA527413333333345975841000000002DA5274133333333439758416666666627A5274166666666429758419A9999991BA527419A9999D940975841CDCCCCCC04A52741333333D33D9758416666666601A52741000000603D9758419A999999F7A42741666666463C97584100000000EFA427419A9999993B975841CDCCCCCCE9A42741333333133A97584133333333E1A42741333333133A97584166666666A8A427416666664638975841CDCCCCCC72A427419A99999936975841666666664BA427419A9999B935975841666666663EA42741CDCCCC6C359758416666666629A4274133333313329758419A99999917A42741000000E02E9758413333333308A42741000000802C975841CDCCCCCCFAA32741CDCCCCCC2A97584100000000F2A327419A9999192997584133333333E9A327419A99991927975841CDCCCCCCE0A32741666666862397584166666666DDA3274166666606229758419A999999D7A327419A9999591F97584100000000D0A327419A9999B91D975841CDCCCCCCC8A32741666666C61C97584133333333C0A32741CDCCCC2C1C97584166666666B8A32741CDCCCC6C1B975841CDCCCCCCACA32741CDCCCC4C1A975841CDCCCCCC94A3274166666686179758419A99999981A32741333333B3159758419A9999996EA32741000000E0139758413333333360A3274166666666129758419A99999952A327419A9999D9109758410000000045A327419A9999B90E9758413333333337A32741333333330C9758419A9999992DA327419A9999F909975841CDCCCCCC2AA327419A999999099758419A99999920A3274133333333089758410000000016A32741666666C60697584100000000F3A2274100000020029758419A999999D8A22741CDCCCC2CFE96584166666666BEA22741CDCCCC6CFA96584166666666A0A22741666666E6F6965841000000008AA2274166666606F4965841333333337BA2274133333393F19658419A99999970A22741CDCCCC8CEE965841333333336AA2274166666646EC9658413333333367A22741000000A0E9965841CDCCCCCC66A22741000000E0E79658419A99999966A2274166666686E6965841333333339FA12741CDCCCC8CE496584166666666F4A02741000000C0D5965841CDCCCCCCC4A027419A9999D9D296584133333333C7A0274166666606D59658419A999999C6A0274133333353D7965841CDCCCCCCC2A02741333333F3D8965841CDCCCCCCBAA02741000000E0DA96584166666666BAA0274166666606DB9658419A999999B4A0274133333373DC96584100000000A8A0274166666666DE965841CDCCCCCC97A02741CDCCCC8CDF9658419A99999984A02741666666A6E0965841CDCCCCCC6BA0274133333353E19658413333333369A0274166666666E19658413333333337A02741CDCCCCECDF96584100000000F29F2741666666C6D296584100000000CE9F2741333333D3D296584166666666B49F27419A999919D39658419A999999989F27419A999979D29658419A999999699F2741000000E0CF9658419A999999589F274100000080CE965841CDCCCCCC4F9F274100000020CD9658419A9999993B9F2741666666A6CA965841666666662A9F2741000000E0C8965841CDCCCCCC1A9F2741333333D3C79658419A999999EF9E2741CDCCCCECC69658419A999999C39E27419A9999B9C696584133333333BB9E27419A9999F9C696584166666666B59E2741CDCCCC2CC796584133333333AE9E2741666666E6C796584100000000A99E2741CDCCCCCCC8965841000000009D9E274100000000CB9658419A999999759E2741333333F3D296584166666666599E274133333393D8965841CDCCCCCC509E27419A999959DA96584100000000489E27419A999919DC965841666666662F9E274133333333E196584133333333249E2741333333B3E29658419A999999129E27419A999959E496584133333333FA9D274100000080E6965841CDCCCCCCE19D2741CDCCCCCCE796584133333333AF9D274100000020EA965841333333338C9D2741000000E0EB965841CDCCCCCC659D2741CDCCCCCCEE96584133333333559D274166666666F0965841666666663C9D274166666686F39658419A999999159D27419A999979F7965841CDCCCCCC129D2741CDCCCCCCF7965841CDCCCCCC059D274133333353F996584100000000FE9C2741CDCCCCACFA965841CDCCCCCCF79C2741CDCCCC6CFC96584166666666FC9C27419A999979FC965841CDCCCCCC059D274100000020FD96584133333333099D27419A999959FD96584100000000379D2741333333330497584133333333609D27419A9999790A975841000000006B9D27419A9999790C975841CDCCCCCC6F9D2741000000C00D9758419A9999996F9D2741333333D30F975841333333336F9D2741CDCCCCAC1397584133333333729D27419A99997916975841666666667D9D2741333333331C97584133333333849D2741333333531F975841CDCCCCCCA29D2741CDCCCCEC2897584166666666AD9D2741333333132C9758419A999999B49D2741CDCCCC2C2E9758419A999999BD9D2741333333533097584133333333C79D2741000000E031975841CDCCCCCCD89D2741333333F33397584166666666E89D2741666666463597584166666666D19D2741CDCCCCAC35975841CDCCCCCCBB9D27413333331336975841666666669F9D27419A9999993697584100000000859D2741333333D337975841333333335C9D2741666666A63997584133333333319D2741CDCCCC6C3B97584133333333E49C2741CDCCCC6C3E97584133333333B49C27416666666640975841CDCCCCCC9A9C2741000000C041975841000000006C9C274100000060449758419A999999369C274100000060479758419A999999209C27419A9999F9489758419A999999109C2741666666464A97584133333333049C2741666666864B97584133333333FA9B2741CDCCCCCC4C97584100000000F29B2741333333134E975841CDCCCCCCE99B2741666666865097584100000000DF9B2741000000A0539758419A999999DD9B27419A9999F9539758419A999999069C2741333333735B975841000000006C9C2741333333D371975841CDCCCCCC949C2741666666467E97584166666666089D2741666666668D97584166666666079D2741000000008E975841CDCCCCCCEF9C27419A9999D99F97584133333333289D27419A9999B9A0975841333333332D9D2741333333D3A097584133333333249D274133333393A4975841CDCCCCCC1B9D2741CDCCCCCCA8975841000000000E9D2741CDCCCCCCB19758419A999999029D274166666606BA97584100000000FB9C2741666666E6C09758419A999999F49C2741CDCCCC8CC497584100000000E79C27419A9999D9CA97584100000000D99C274133333333D197584133333333A69C2741333333B3E897584100000000A19C2741000000A0EB97584100000000A09C27419A9999F9ED9758419A999999A09C2741CDCCCC6CEE97584166666666A29C2741CDCCCCCCEF975841CDCCCCCCA79C27419A999999F19758419A999999B39C274166666606F497584133333333BC9C274133333333F59758419A999999C69C27419A999999F697584100000000D39C2741CDCCCC0CF997584100000000DA9C2741000000E0FA97584133333333DE9C2741CDCCCCCCFD9758419A999999E19C27419A9999F90398584166666666E29C27419A9999190C985841CDCCCCCCEF9C2741CDCCCCAC2198584100000000F19C274133333373239858419A999999F29C2741CDCCCC4C2598584100000000F29C2741CDCCCC0C2898584133333333169D2741CDCCCC4C2D98584133333333159D2741CDCCCC6C2E98584100000000119D27419A9999D92F98584133333333039D274133333313339858419A999999F69C2741666666863598584100000000EB9C2741666666663898584166666666E69C2741CDCCCC8C3A98584166666666E09C2741666666463E98584166666666D59C2741000000E04298584133333333B59C2741000000804A98584166666666789C27410000004054985841CDCCCCCC5D9C2741CDCCCC4C5D98584133333333529C2741666666A65D98584133333333F09B2741CDCCCCCC60985841000000005E9B2741333333536298584133333333329B2741000000E061985841CDCCCCCCFD9A27419A9999597C98584100000000449A2741333333536D98584133333333129A2741CDCCCC6C7198584133333333F89927419A9999597498584100000000EA992741CDCCCCCC769858419A9999990C9A27416666666682985841333333330D9A27419A9999998A98584133333333079A2741CDCCCCCC91985841000000000F9A2741333333339898584166666666139A2741CDCCCCCC9B98584166666666F7992741000000E09C98584166666666D9992741666666269F9858419A999999B2992741666666469E9858413333333397992741333333B39D9858410000000022992741333333D39B9858419A9999998D9827419A999919A19858410000000034982741333333F3A498584166666666E497274166666646AB98584133333333C7972741333333B3B3985841CDCCCCCCA9972741CDCCCC2CB99858416666666699972741CDCCCC2CBD985841000000008A97274166666626BD9858413333333367972741666666E6BD9858419A99999946972741666666C6D09858419A999999F49627419A999999DA9858419A9999997D96274133333333DE9858410000000068962741666666A6DD9858419A999999399627419A999959DC985841333333331B962741CDCCCCACDB9858416666666610962741333333F3DA985841CDCCCCCC0596274100000040DA98584166666666FD9527419A9999F9D898584133333333F69527419A9999D9D798584100000000F095274133333373D598584166666666E4952741666666A6D298584166666666D29527419A999919D1985841CDCCCCCC9095274166666666CE9858410000000075952741CDCCCCACCC985841333333334795274166666646C89858419A9999991895274166666666C39858419A999999D4942741CDCCCC8CC598584133333333A194274133333333C7985841CDCCCCCC3C942741CDCCCC4CCE98584100000000C8932741000000C0D4985841CDCCCCCC8C93274133333353D998584133333333E09227419A9999D9E19858419A999999A6922741CDCCCC0CE5985841CDCCCCCC79922741666666E6E69858419A9999997192274133333333E7985841333333334A9227419A999999E8985841CDCCCCCC43922741CDCCCC8CE9985841CDCCCCCC3F92274100000020EA985841CDCCCCCC3892274133333333EB985841666666661F92274133333313EF985841	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	01010000206A080000FDACF93867A42741CDCCCC7C469A5841	430210000	Z	Beaulieu	4302100	43021	43	84	23
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	01010000206A080000DC35DAC7BA282641000000F08AAC5841	430220000	Z	Beaumont	4302200	43022	43	84	12
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