SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep45;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep45 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep45','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep45','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep45','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep45"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A08000008EF3F4F49E72441343333C3DFB55941	450010000	Z	Adon	4500100	45001	45	24	25
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	01010000206A0800007C49B8998E37254100000040E0B95941	450020000	Z	Aillant-sur-Milleron	4500200	45002	45	24	27
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	01010000206A080000E011372AD1EA24416666668696CF5941	450040103	H	Les Goths	4500401	45004	45	24	24
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	01010000206A080000B668DC5219D624419A9999D9C8CC5941	450040101	H	Le Bourg	4500401	45004	45	24	5
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	01010000206A080000105E9AB873C52441CDCCCC3CF5CC5941	450040102	H	Saint-Firmin	4500401	45004	45	24	7
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	01010000206A080000A82A272212D2244166666666EDCF5941	450040201	H	Viroy A	4500402	45004	45	24	2
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	01060000206A080000010000000103000000010000003D0000000000000035C624419A999939EBCE594133333333D2C82441CDCCCC8C0CCF59419A999999CEC82441000000000ECF59419A99999973C92441CDCCCCCC13CF5941666666667CC924419A9999B914CF5941CDCCCCCCA1CA24419A9999F91FCF5941333333335CCB24410000008027CF59410000000007CB2441666666C64DCF59419A9999995DCB2441CDCCCC4C51CF59416666666629CB2441333333736ACF59416666666650CB2441333333D36BCF5941CDCCCCCC0DCB2441000000008ACF5941CDCCCCCC26CB2441666666C688CF594100000000FACA244100000080A4CF5941666666660BCB24419A9999F9A4CF594100000000EACA244100000060B3CF5941CDCCCCCCA9CA244133333393CBCF594166666666DACA2441CDCCCC4CCDCF5941333333339CCA244133333333EBCF594133333333E7CC24419A999919FBCF59419A9999991FCD2441CDCCCC4CDECF59416666666672CD2441333333D3B6CF594133333333C2CD24419A9999D98ECF5941CDCCCCCCD2CD24419A99991984CF5941CDCCCCCC55CE2441CDCCCC6C80CF59416666666647CF24413333339373CF59419A9999996CCF24416666666670CF59413333333389D024410000002054CF5941000000007AD12441333333F336CF59419A999999B6D12441CDCCCCEC2DCF59419A99999903D22441666666E61ECF5941CDCCCCCC7CD224416666664612CF59419A999999C3D22441CDCCCC0C0DCF59410000000069D32441CDCCCC0C04CF5941CDCCCCCCDFD324416666664603CF59416666666605D52441CDCCCCEC05CF59419A9999992DD62441CDCCCC0C07CF59416666666651D624419A9999F9E3CE5941333333332AD62441CDCCCC2CC1CE59416666666627D62441CDCCCC0CBCCE59413333333344D62441333333D39BCE59416666666650D624410000002087CE5941333333335AD624413333337365CE594166666666AFD524413333331366CE59416666666647CE2441CDCCCCEC73CE5941CDCCCCCC9BCD24419A99999974CE59419A9999992ECD24419A99993974CE594100000000A6CC2441CDCCCC4C72CE5941CDCCCCCCF7CB2441000000E06DCE5941000000000FCB2441666666C664CE59419A999999AEC924410000008055CE594133333333D5C82441000000E04CCE59413333333369C824419A9999D949CE5941CDCCCCCCDBC724419A99997947CE59410000000065C724413333331347CE5941CDCCCCCCB9C624410000000049CE5941CDCCCCCC89C624413333339392CE59419A99999965C6244133333373C7CE59410000000056C624419A9999B9D6CE59410000000035C624419A999939EBCE59410000000035C624419A999939EBCE5941	01010000206A08000020E8B4F159CE24419A9999F920CF5941	450040202	H	Viroy B	4500402	45004	45	24	2
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	01010000206A0800009C4DE4C8CC2423419A99993933EE5941	450050000	Z	Andonville	4500500	45005	45	24	12
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	01010000206A08000076F15C6620C822413433338300B95941	450060000	Z	Ardon	4500600	45006	45	24	55
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	01010000206A08000087ECBF60B9D0224134333333FBD85941	450080000	Z	Artenay	4500800	45008	45	24	20
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	01010000206A0800007C9E31830B1723413433339370DC5941	450090000	Z	Aschères-le-Marché	4500900	45009	45	24	21
01060000206A08000001000000010300000001000000DB00000033333333309D2341CDCCCCEC05DD594100000000409D2341333333F30EDD59419A9999994D9D23410000006016DD59419A999999729D2341CDCCCC6C28DD594166666666819D2341666666062EDD5941CDCCCCCC9C9D23413333335338DD594100000000E79D2341CDCCCC2C55DD594133333333159E23416666664665DD59419A999999229E2341000000E069DD594100000000309E2341333333D370DD5941666666663B9E2341333333B375DD59419A9999993D9E2341333333B376DD5941000000004D9E23419A9999597CDD594100000000619E2341333333F381DD594100000000769E2341CDCCCCEC87DD59419A999999949E2341CDCCCC4C90DD594133333333B59E23416666668699DD594133333333E89E234133333353A7DD594166666666EE9E2341CDCCCC0CA9DD59419A999999009F2341CDCCCC0CAEDD594133333333089F234133333373B0DD5941000000000D9F2341333333B3B1DD5941666666660F9F23419A9999D9B2DD5941CDCCCCCC139F234133333353B4DD594166666666229F2341000000E0B8DD5941CDCCCCCC279F2341CDCCCCCCBADD5941666666662E9F2341000000C0BDDD594166666666359F23419A999999C2DD5941333333333A9F2341000000E0C7DD5941666666663D9F2341CDCCCCACCCDD5941000000003E9F23419A9999F9D0DD5941666666663E9F23419A999999D4DD5941CDCCCCCC409F234133333333DADD594133333333389F234166666626E5DD59419A999999879E2341CDCCCCCC71DE5941666666664F9F23419A9999F96DDE594100000000A89F2341CDCCCCECBBDE594133333333CD9F2341000000A0D8DE5941333333331CA023410000002022DF5941CDCCCCCCD39F23410000004023DF594133333333A59E23416666666622DF594133333333CF9E2341CDCCCC8C29DF59419A9999993E9F2341333333F33DDF5941333333336E9F23410000004046DF594133333333B89F23410000002053DF59410000000030A023410000002067DF59419A9999993FA02341666666C669DF594166666666CCA023419A99997981DF59413333333328A12341CDCCCCAC90DF59419A99999983A12341666666269FDF5941CDCCCCCCC5A123419A9999B9A9DF594166666666CEA1234100000020ABDF594100000000D4A12341CDCCCC0CACDF594133333333DEA12341000000C0ADDF5941CDCCCCCCE8A1234100000060AFDF5941000000002AA423419A9999B990DF5941000000006DA42341666666468DDF594133333333B0A42341CDCCCCECA2DF59413333333375A423419A999979A6DF5941666666666DA4234166666666A9DF5941000000007CA4234166666626AFDF5941333333338BA42341666666E6AEDF59419A999999BEA42341CDCCCC6CAEDF594100000000D0A4234166666686AEDF594166666666EFA423419A999999AEDF594166666666F6A42341666666A6AEDF59410000000033A5234133333393ABDF59419A999999DAA5234133333353C7DF59419A99999959A6234133333393DCDF5941CDCCCCCCBBA62341333333B3D4DF59419A999999D0A823419A9999F9A8DF594133333333EEA82341CDCCCCACB4DF594133333333FFA8234100000000B4DF59413333333379A9234133333393AEDF59413333333390A92341CDCCCC2CADDF594100000000D4A92341CDCCCC2CAADF5941CDCCCCCCF0A92341666666A6A8DF59419A999999F5A923419A9999F9A9DF59419A999999FDA92341CDCCCCACA9DF5941333333332AAA23419A9999F9A7DF59419A99999958AA234133333313A6DF59416666666668AA23419A999979A6DF5941333333336FAA2341000000E0A6DF59416666666675AA234166666686A5DF59416666666682AA234166666606A4DF59419A999999EFAA2341333333539ADF59410000000079AB2341000000808FDF59413333333399AB2341333333F38CDF594133333333AEAB2341333333538BDF594166666666B0AB23419A9999398BDF59419A99999964AB2341666666C67ADF59410000000008AB23419A9999594BDF59419A999999FFAA2341666666C635DF59419A999999FDAA23410000008030DF594100000000FEAA2341333333332FDF59410000000002AB23419A9999F923DF59419A99999902AB23416666668622DF59419A99999901AB2341000000A021DF594133333333FFAA2341666666C61CDF59419A999999FCAA2341333333B314DF59419A999999FAAA23419A9999190EDF594100000000F9AA23419A9999B906DF59410000000071AB2341CDCCCC0C06DF5941CDCCCCCC8CAB2341333333F302DF5941CDCCCCCC3BAC2341000000C0FDDE5941CDCCCCCC20AE2341333333D3EDDE59419A99999945AE2341CDCCCC4CFFDE59419A99999947AE2341666666A601DF59416666666600AF2341333333B3F7DE594133333333F0B0234133333313DDDE594133333333EFB12341CDCCCC6CCFDE59419A99999904B223419A999959CFDE5941000000000CB22341CDCCCC4CD0DE59416666666621B2234100000040D1DE59410000000084B3234166666626BEDE59419A99999981B3234133333393B9DE5941CDCCCCCCAEB42341000000A0A9DE5941666666666AB42341CDCCCC2C80DE59419A999999F0B323413333339337DE59410000000091B323419A9999393CDE59419A999999D2B2234133333373CBDD5941333333338BB3234166666686C2DD594100000000B4B423419A9999F9B3DD5941333333337CB52341CDCCCCECA9DD594166666666CEB5234100000040A6DD5941CDCCCCCCDBB52341CDCCCCECA5DD59419A999999E5B52341666666C6A4DD5941CDCCCCCCF4B52341666666C6A2DD594100000000D1B52341CDCCCCACA0DD594133333333A9B523419A9999D99EDD59416666666686B52341CDCCCCAC9DDD5941666666666CB52341CDCCCCEC9CDD59416666666640B52341CDCCCC2C9CDD5941000000001EB52341CDCCCC4C9BDD5941CDCCCCCC09B523419A9999999ADD594166666666EEB423410000004099DD594133333333D7B42341000000C097DD594133333333C4B42341CDCCCC4C96DD594133333333B4B42341333333D394DD594100000000A3B423416666662693DD59413333333370B42341333333138DDD5941000000003EB42341CDCCCC6C85DD594133333333F7B323419A9999D97ADD5941CDCCCCCCD2B323416666664676DD594100000000B0B323416666664671DD59419A99999992B32341000000406CDD5941CDCCCCCC7EB32341CDCCCC2C68DD59410000000071B323416666662665DD5941333333335DB323416666662660DD59419A99999936B323419A9999D956DD59410000000026B32341666666A652DD59419A99999915B32341666666864EDD59413333333310B32341CDCCCC8C4DDD594133333333E6B223410000000046DD594100000000D2B22341333333F342DD594133333333C6B22341333333B341DD59419A999999BAB223416666666640DD5941666666669CB22341333333533DDD59413333333382B22341666666E63ADD59413333333377B22341000000E039DD59410000000061B22341333333D337DD5941333333332BB223413333335332DD59419A99999916B223419A99997930DD59416666666600B22341333333732EDD59419A999999DFB12341000000402BDD59419A999999CCB123416666660629DD59419A999999ADB123416666660625DD594133333333C0B12341666666C61FDD59419A999999C1B12341000000001FDD594100000000CBB12341666666061ADD594100000000D8B12341666666E60FDD5941CDCCCCCCE8B12341CDCCCCEC03DD59419A999999F2B1234133333393FEDC59413333333306B2234133333373F6DC59419A99999935B22341333333F3E4DC5941CDCCCCCC54B2234100000060DADC59413333333382B2234100000020CBDC59416666666660B123419A9999B9CCDC5941CDCCCCCC51B02341CDCCCC8CCEDC59413333333344AF2341333333F3CFDC594166666666FEAE2341CDCCCC6CD0DC59419A99999982AE234100000040D1DC5941CDCCCCCC3AAE2341000000C0D1DC59419A99999931AD2341CDCCCC0CD3DC59410000000042AC2341000000C0D4DC5941000000002AAC2341CDCCCCECD4DC5941CDCCCCCC6FAB2341CDCCCCCCD5DC5941CDCCCCCC6AAB2341000000A0D6DC59419A99999966AB23419A999939D5DC59419A99999960AA2341000000A0D9DC59419A999999BFA823419A9999B9E0DC5941CDCCCCCCC7A82341333333F3E3DC594166666666D9A82341CDCCCC8CEADC59419A999999E4A82341CDCCCCCCEEDC59419A999999FFA6234100000060F7DC5941CDCCCCCCFCA6234133333333F7DC59419A999999E2A6234166666646F5DC5941CDCCCCCCAAA62341CDCCCC2CF1DC594100000000A0A623419A999959F0DC5941666666668FA62341666666E6EEDC59419A99999984A6234133333393EDDC59413333333371A6234166666646EBDC5941000000006FA6234100000000EBDC59419A99999939A6234100000020E4DC59410000000015A623419A999999DFDC59419A9999990EA62341333333F3DEDC59416666666606A62341000000C0DEDC594133333333FCA52341666666C6DEDC59410000000098A5234133333393E0DC5941333333333AA5234100000040E2DC594100000000D1A42341333333D3E3DC59416666666649A42341CDCCCCECE5DC594133333333BBA323419A999919E8DC59413333333365A3234133333393E9DC59413333333309A32341333333F3EADC59419A999999CFA22341666666E6EBDC594133333333BAA2234100000040ECDC59416666666696A2234100000080ECDC594133333333309D2341CDCCCCEC05DD5941	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	01010000206A080000F2AF7AE266A923419A99991955DE5941	450100000	Z	Ascoux	4501000	45010	45	24	7
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	01010000206A080000E8D9E613F8722341333333A30ADD5941	450110000	Z	Attray	4501100	45011	45	24	17
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	01010000206A0800003A32874642A72341CDCCCC5CD2EE5941	450120000	Z	Audeville	4501200	45012	45	24	13
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	01060000206A08000001000000010300000001000000750000006666666666FF2341CDCCCC4C8FEB594100000000BEFF2341CDCCCCAC9BEB5941333333335D00244166666606B5EB5941CDCCCCCC8B012441333333D3E3EB5941666666666C01244166666646EBEB59413333333321012441666666462EEC59413333333314012441333333B335EC59419A9999996F0224419A99993938EC5941666666666B032441333333D338EC59410000000018032441CDCCCC0C63EC5941CDCCCCCC850724419A99991979EC594100000000810724416666668680EC594166666666C5092441666666C6AEEC594133333333C709244166666606ABEC594100000000310A244166666666ACEC594100000000140B24419A999919C3EC594133333333750B24419A9999D9C9EC594166666666B20B2441CDCCCCCCCBEC594166666666290C244133333333D3EC5941000000006B0C244166666666C6EC59419A999999690D244166666666D1EC59419A9999998F0D244133333373C8EC5941333333337C0D244133333353C1EC59419A999999B10D244133333313B7EC594166666666C60D24419A9999B9A7EC59419A999999F10D2441666666E69FEC594133333333D10D24416666662698EC594100000000060E2441000000A086EC5941666666663D0E2441CDCCCC4C80EC59419A9999994C0E2441000000C075EC594133333333820E2441CDCCCC8C6CEC59419A9999990F0F2441000000E069EC5941666666662E1024416666664663EC59419A9999996B1024419A9999995CEC594166666666A4102441000000204BEC59419A999999C8102441000000C038EC5941CDCCCCCCCF102441666666E62DEC594166666666F51024419A9999D921EC5941333333331B1124419A9999F909EC5941CDCCCCCC551124419A99999901EC5941CDCCCCCCAC11244100000060FCEB59419A999999D81124419A999939F6EB594100000000F6112441CDCCCCACF4EB5941666666666912244100000040E5EB5941CDCCCCCCA112244166666606E2EB59419A999999FA1224419A9999F9DFEB59419A99999938132441CDCCCC2CDCEB5941333333337413244166666686DAEB594133333333A013244100000000D6EB594100000000DA13244100000040D7EB5941333333334114244133333313D6EB59410000000091142441000000A0D2EB5941CDCCCCCCDC142441333333B3D9EB5941CDCCCCCCF6142441CDCCCC2CDAEB59416666666610152441333333F3D4EB5941666666663E15244166666666D1EB59419A99999989152441333333B3CFEB594133333333F21524419A999959D1EB5941666666663D16244166666666CEEB59410000000083162441CDCCCC0CCFEB59419A999999CE16244166666646D4EB59419A999999F416244166666646CEEB5941333333330D1724419A999959CEEB5941CDCCCCCC2E172441000000A0D2EB5941CDCCCCCC4D17244133333333D0EB5941333333336B172441666666C6C8EB594100000000DC172441333333D3BCEB5941CDCCCCCC171824419A999919B3EB5941666666663F182441333333D392EB594100000000561824416666666687EB59413333333398182441666666467BEB5941CDCCCCCCA21824419A99999977EB59413333333399182441333333936BEB594133333333801824419A99991967EB594100000000F51724419A9999195CEB594166666666AA1724410000008054EB5941333333335B1724419A99997952EB5941CDCCCCCC15172441666666664AEB594100000000B71624416666660642EB59419A9999996F1624410000004038EB59419A999999401624416666662630EB5941333333332F1624410000008026EB59419A999999F215244133333393F9EA5941CDCCCCCC7E15244133333393E2EA594166666666E01424419A999939C5EA5941CDCCCCCCC914244100000040C0EA5941666666667B14244100000080B4EA5941CDCCCCCCB313244133333353BEEA5941CDCCCCCC3B13244133333373C6EA594133333333CB122441000000E0CCEA59419A999999071224419A9999B9D4EA59419A99999907112441666666E6DFEA5941333333337A1024413333331304EB5941CDCCCCCC5E1024410000004005EB5941000000007F1024419A999919F1EA59419A9999995E0D2441CDCCCC0CE4EA59419A9999995A0D2441CDCCCCCCE7EA5941CDCCCCCCE00A24419A999999DCEA594133333333CF0A24419A999999EFEA594166666666C9082441CDCCCC8CDFEA5941CDCCCCCCD4072441CDCCCC6CD5EA5941CDCCCCCC5B072441CDCCCC8CEAEA594166666666BE062441CDCCCC6C08EB59410000000029062441000000600FEB5941CDCCCCCC0F062441000000001DEB594100000000F4052441000000201FEB5941CDCCCCCC4E052441666666C60CEB594166666666890424413333331330EB59419A999999E5032441333333F328EB5941CDCCCCCC4A0324413333337320EB5941CDCCCCCCDB022441CDCCCC2C31EB59416666666692012441666666A65AEB5941CDCCCCCC930024419A9999F972EB5941333333336D002441CDCCCC4C79EB5941000000000A002441333333F386EB59416666666666FF2341CDCCCC4C8FEB59416666666666FF2341CDCCCC4C8FEB5941	01010000206A0800000C1AFFB4290C2441666666E6C3EB5941	450130000	Z	Augerville-la-Rivière	4501300	45013	45	24	4
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	01010000206A08000094724B7494F22341CCCCCCECC2E65941	450140000	Z	Aulnay-la-Rivière	4501400	45014	45	24	16
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	01010000206A0800005076E505D84E234100000000ABEE5941	450150000	Z	Autruy-sur-Juine	4501500	45015	45	24	27
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	01010000206A08000013EDC91B947624419A99999923A45941	450160000	Z	Autry-le-Châtel	4501600	45016	45	24	51
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	01060000206A08000002000000010300000001000000870000003333333350002441CDCCCCECA1CA59419A99999959002441666666C6A6CA594166666666720024419A999959A8CA5941333333337700244133333353B0CA5941000000009600244133333393B9CA5941CDCCCCCC7C002441333333B3C0CA5941000000008B002441CDCCCCACC9CA594100000000B400244166666666D0CA59410000000009012441CDCCCCCCEACA59419A999999260124419A999959FBCA59419A999999570124410000008007CB594133333333D2012441333333B31BCB59419A999999FD0124410000006025CB59419A9999991B022441666666A628CB5941333333334A022441CDCCCC4C32CB5941666666665D022441666666263BCB59416666666674022441333333933FCB59419A999999AE0224413333333342CB5941CDCCCCCCF1022441000000C04BCB594166666666350324410000008051CB59419A999999430324416666662655CB5941CDCCCCCC7C032441666666065ACB594166666666840324413333331362CB594133333333E50324410000000060CB59416666666603042441666666A661CB594166666666FF0324419A9999F966CB59419A9999992D042441666666E66BCB5941333333335F042441333333736ECB59410000000096042441000000A077CB5941CDCCCCCCC5042441333333537ACB5941000000000C052441CDCCCC0C81CB59419A9999994D0524410000004084CB594100000000AA052441CDCCCC2C8CCB59419A999999E6052441333333138ECB5941000000004E0624419A9999B99ACB59413333333374062441333333539DCB59419A9999999C06244100000000A4CB594100000000F106244166666606AACB5941000000003B0724419A999919AECB5941333333335607244100000020B1CB59410000000036092441CDCCCC4CEACB594133333333A9092441CDCCCCACF5CB594133333333320A24419A9999B9FDCB594133333333590A24416666662605CC5941CDCCCCCC850A24410000000008CC594133333333B20A2441333333D310CC594133333333070B2441CDCCCC8C1ACC5941666666661E0B24416666662622CC594166666666390B2441CDCCCCEC32CC5941333333336B0B2441666666E639CC5941CDCCCCCCCE0B2441CDCCCC4C3DCC5941CDCCCCCCF80B2441000000A043CC594133333333400C2441666666A646CC5941CDCCCCCC670C2441000000204DCC594100000000A10C24413333339350CC594166666666C30C24410000002056CC594133333333D20C24419A9999D95CCC5941666666660B0D24419A9999F960CC594166666666300D2441333333336BCC594166666666870D24416666668678CC5941CDCCCCCCA80D24413333331379CC594166666666B90D24416666666691CC594166666666EE0D24413333333395CC594166666666110E24419A99993993CC594166666666490E24410000004097CC59419A999999760E2441CDCCCCAC94CC594100000000150F2441CDCCCCAC90CC594133333333600F24419A99995990CC594100000000860F24410000006092CC594133333333DE0F24416666666692CC59410000000085102441CDCCCC4C8ECC5941CDCCCCCCD3102441CDCCCC6C89CC594133333333751124419A9999798CCC594166666666A71224419A9999F98FCC59416666666674132441666666869ECC594166666666B9132441CDCCCCACA0CC59413333333309142441333333B39FCC5941333333335B142441333333339BCC5941666666661F142441666666C692CC594133333333FA132441CDCCCCAC78CC5941CDCCCCCCDF132441666666A66ACC5941CDCCCCCCB91324416666666660CC5941CDCCCCCC59132441333333134CCC5941666666664F1324416666668644CC5941000000004B1324419A99993934CC59410000000043132441000000602FCC594133333333EE122441333333F320CC59416666666668122441000000C00FCC59416666666624122441000000E002CC5941CDCCCCCCC6112441666666A6F3CB5941000000006E112441000000E0EACB5941CDCCCCCC1A112441333333D3E0CB594133333333D110244166666606D5CB5941333333333210244100000080B8CB5941CDCCCCCCA10F244166666606A0CB59419A999999840F24419A9999799DCB5941000000006D0F2441666666A689CB5941CDCCCCCC060F2441CDCCCCAC0ECB594166666666E50E2441CDCCCC8CF4CA5941CDCCCCCCBE0E244166666686DBCA5941CDCCCCCC6C0E244133333353BCCA594100000000320E2441000000E0A7CA59419A999999070E2441CDCCCC2C96CA594166666666FC0D2441000000208CCA59419A999999E30D24419A9999F989CA594166666666570D24419A99993978CA594133333333030D24419A9999396CCA5941CDCCCCCC8F0C24419A9999196ECA59419A999999570C2441666666E66CCA59419A999999F60B24416666666667CA594166666666BD0B2441CDCCCC6C6ACA594133333333F10A24410000006082CA594100000000DE0A24419A99993982CA594133333333720A2441666666C67BCA5941CDCCCCCC150924413333335364CA59419A999999B50824410000002073CA594100000000CD072441CDCCCCCC99CA59419A999999030724419A999939B8CA594133333333AD06244166666606C3CA5941CDCCCCCC3406244100000060CACA594133333333C1052441CDCCCC6CCDCA5941CDCCCCCC3805244133333353D2CA594100000000CA042441CDCCCC4CD5CA594133333333D6032441333333F3DCCA5941CDCCCCCC540324419A9999D9E1CA594133333333DE022441666666C6DFCA59419A99999967022441CDCCCC8CDBCA5941333333331002244133333313D7CA594100000000DA012441333333B3D2CA594166666666990124419A9999D9C9CA594100000000090124419A999959B2CA59419A999999CB00244166666626A9CA59419A9999998900244166666626A3CA59413333333350002441CDCCCCECA1CA59413333333350002441CDCCCCECA1CA59410103000000010000002201000000000000FD1E2441666666260FCD59419A999999531F2441CDCCCCAC21CD5941CDCCCCCC7D1F2441666666E62DCD5941333333337B1F24419A9999B935CD5941CDCCCCCCA31F24413333337364CD594133333333D91F2441666666A666CD5941666666668A212441CDCCCC4C44CD5941666666668C232441666666061ACD59419A999999B92424416666668600CD5941CDCCCCCC18252441666666E6F8CC5941000000000D2624416666668631CD594133333333C3262441CDCCCCCC27CD594166666666052724413333333335CD59413333333359272441000000603DCD59413333333302282441666666664FCD59413333333345282441333333F357CD5941666666665B2824419A9999395ECD5941666666667B282441CDCCCCEC6ECD5941CDCCCCCC70282441333333B379CD5941CDCCCCCC752824410000000086CD594100000000A0282441CDCCCCCC93CD5941333333338F28244100000020ABCD59410000000092282441666666C6C7CD5941666666668C28244133333393D1CD5941CDCCCCCCA6282441666666E6E2CD594166666666C4282441666666A6FDCD5941CDCCCCCCE1282441000000E010CE59410000000048292441000000403BCE594133333333A22924419A99993962CE5941CDCCCCCCD6292441000000005ECE594100000000382A2441CDCCCC0C59CE5941333333330E2B2441666666C650CE5941CDCCCCCC8C2B2441333333136DCE59419A999999F72B24413333331374CE594100000000002E24413333339356CE594100000000D02E2441333333F37CCE594166666666E12E2441000000407ECE594100000000A22F2441666666067BCE594100000000C43024419A99991975CE5941333333339F302441666666466BCE59410000000060312441666666A65ACE5941333333330F3324419A9999D92CCE594100000000F6342441333333F3FBCD5941CDCCCCCC6834244100000040D8CD5941CDCCCCCC013424419A999959BDCD5941CDCCCCCCF833244166666666B9CD594100000000B93324419A9999B9B4CD5941000000006F332441333333B3ADCD5941000000004233244133333373ABCD5941666666664133244166666686A8CD594166666666653324419A9999B99CCD594100000000C7332441CDCCCC4C81CD594166666666E03324419A9999597DCD5941333333332F342441666666E669CD5941333333335C3524419A9999392ACD59419A9999999E3524419A9999191DCD59416666666683362441CDCCCC6C14CD59419A999999253724413333339307CD594133333333F3372441000000A0F9CC5941333333337C3824419A999999F1CC594166666666E63824419A999979FDCC5941CDCCCCCCDE3824410000004028CD594166666666E2382441666666062BCD59419A9999994D3A24413333335315CD5941333333338D3A24416666660613CD5941CDCCCCCC683B2441333333B30CCD5941666666662D3C2441CDCCCC2C24CD594166666666933D24413333337379CD594133333333E03D2441666666A68CCD594166666666063F24419A9999F9D1CD59419A999999B13F244166666606FBCD5941333333330B4024413333333311CE594133333333FF3E24419A9999B917CE594133333333953F2441CDCCCC0C3BCE5941CDCCCCCC833E24419A9999F940CE59419A999999B73E24419A99993944CE59419A999999CE3E2441000000C047CE59419A999999143F2441CDCCCC6C5CCE5941CDCCCCCC283F2441333333B35FCE594100000000273F24416666668670CE594166666666313F24419A9999F978CE5941333333334B3F2441666666E6A8CE5941666666664C3F2441CDCCCC2CB5CE594100000000313F2441333333B3C5CE5941CDCCCCCC2C3F244166666666D7CE5941333333331F3F2441CDCCCCACD9CE59419A999999B73E2441666666E6D6CE594133333333B53E24419A9999F9D8CE59419A999999743F2441000000E016CF594166666666963F24413333337325CF594100000000514124410000000012CF59419A999999CF412441666666260CCF5941000000009D4224419A9999D903CF594166666666B64224410000004004CF59419A999999844424419A9999791ECF5941333333334A44244166666606A5CE59419A9999990A4424419A9999F96ECE5941CDCCCCCC214524410000004078CE5941CDCCCCCCD1452441CDCCCCEC7ACE59413333333307462441000000207BCE59419A999999414724419A9999B978CE594133333333C0472441CDCCCCAC72CE5941CDCCCCCC5A4A2441CDCCCCCC6ECE5941CDCCCCCC2E4A24413333337352CE59419A999999234A2441000000804ECE5941CDCCCCCC754B24413333331347CE59419A999999664B24410000006022CE5941666666660D4C24410000006021CE5941000000003D4D2441333333931ECE594166666666344D2441666666E61BCE5941000000001D4D24419A999939EECD59419A999999474D244166666626ECCD594100000000454D2441CDCCCC6CE6CD594100000000EC4D24419A9999F9DECD594100000000BB4E24419A999979D3CD59419A999999A54E2441CDCCCC8CC7CD5941CDCCCCCC704F2441666666A6C3CD5941666666666D4F2441333333B3B4CD5941CDCCCCCC8A502441000000C0B1CD5941000000008F502441CDCCCCEC9DCD594166666666A95024419A99991992CD5941666666665B5124416666664660CD5941000000006B512441CDCCCCAC56CD594133333333665124416666664650CD5941000000003A512441333333733CCD59419A99999935512441000000602DCD594166666666655124419A99993916CD594100000000705124419A9999590ACD5941333333337A512441CDCCCCCCEECC594133333333A251244100000060D8CC5941CDCCCCCCDC5124419A999979C3CC59410000000071512441333333F3C1CC5941000000009B5124419A999939B7CC594133333333CC512441666666A6ADCC5941CDCCCCCC1C52244133333393A0CC594100000000B351244133333373A1CC5941CDCCCCCC9C512441000000E09BCC5941CDCCCCCCAF502441333333F335CC59413333333379502441CDCCCC4C20CC5941CDCCCCCC6A5024416666662609CC5941666666666E50244166666686FBCB5941CDCCCCCC7F50244166666606ECCB59419A999999B55024419A999939C6CB59419A999999C9502441666666E6ABCB594133333333FB5024419A9999399ACB59419A99999921512441666666A692CB5941CDCCCCCC875124419A99991979CB5941CDCCCCCC995124419A99991972CB59419A999999B9512441666666E658CB59419A999999B85124410000006053CB5941CDCCCCCC85512441666666063ACB594166666666005124416666664639CB5941666666667C5024416666666639CB594100000000534F2441333333B334CB5941CDCCCCCC7A4E2441CDCCCCEC2CCB5941000000001D4E2441666666662BCB594166666666A24D24419A9999992ACB5941CDCCCCCCD24C24410000002028CB5941333333335B4C2441666666A627CB594133333333584B2441000000C027CB59419A999999244A24419A9999F926CB59419A999999514824413333339327CB594133333333F0472441CDCCCC6C28CB5941CDCCCCCC8F472441CDCCCC8C27CB59419A99999927472441CDCCCCEC23CB59419A999999974624416666666635CB59419A999999C24524410000008056CB5941CDCCCCCC3F452441333333B36DCB5941666666669B442441000000407BCB594166666666964324413333337381CB5941CDCCCCCCD4422441333333D37FCB5941CDCCCCCC7A412441666666A675CB59419A9999992F4124419A99991973CB5941CDCCCCCCF0402441333333F36BCB5941000000008A402441666666C658CB59419A9999999F3F2441666666A62BCB5941CDCCCCCCC13E244133333373E6CA5941CDCCCCCC4A3F2441333333D3E3CA594166666666403F2441000000A0DECA5941CDCCCCCC963E2441666666A6B4CA5941CDCCCCCCB63E244166666626B2CA59419A999999CC3E244166666626ADCA5941CDCCCCCC3F3F24419A999999A5CA5941666666662A3F2441CDCCCCACA0CA594100000000F13E24419A9999F99FCA5941CDCCCCCCA03E2441000000009DCA5941CDCCCCCC753E244133333393A1CA5941CDCCCCCC3F3E24419A999959A1CA5941CDCCCCCCF43D2441CDCCCCECA3CA5941CDCCCCCCBA3D244166666646A3CA594133333333753D244133333353A6CA5941666666663D3D244166666686A5CA594133333333EB3C2441CDCCCCACA8CA59419A999999973C2441CDCCCC2CA9CA594100000000C43B24419A999959B1CA59419A999999673B24419A999999B2CA594166666666293B2441CDCCCCACAFCA5941CDCCCCCCEB3A244133333393A8CA594133333333C13A24419A999979A6CA5941CDCCCCCC2C3A244100000000A4CA59419A999999D139244100000060A3CA5941333333339B3924419A999959A4CA594166666666A138244100000000AECA594166666666083824419A9999F9BDCA594166666666CB37244166666686C1CA594100000000C737244133333353C6CA594133333333A337244100000020C9CA5941CDCCCCCC01372441CDCCCCCCCACA594100000000D2362441CDCCCC4CC7CA594166666666A1362441000000A0C8CA5941000000005436244133333373C4CA594166666666BD352441333333B3CECA5941666666668C35244133333373CECA59416666666606352441CDCCCC4CCACA5941CDCCCCCC50342441CDCCCC8CC7CA59419A9999991C342441333333B3C9CA59416666666656332441333333F3CCCA594133333333B532244166666606CACA5941333333338832244133333313CBCA59419A999999F4312441666666C6C7CA59419A9999999F31244100000040C7CA5941333333336E312441CDCCCCACC8CA594166666666473124419A999959C6CA59419A9999990C31244166666626C7CA59413333333373302441CDCCCC6CC5CA59419A9999994030244166666646C7CA594166666666EF2F2441CDCCCC2CC8CA594133333333302F24419A999959C5CA594166666666E72E2441CDCCCCCCC2CA5941666666663F2E24419A9999B9CACA594100000000EB2D2441CDCCCCACD0CA5941333333337F2D2441333333B3DFCA59419A9999993B2D244166666626E8CA5941CDCCCCCC8E2C244166666686F7CA594133333333562C24413333335306CB594166666666DC2B2441333333F32ECB59419A999999BB2B24413333335333CB5941CDCCCCCC2A2B2441666666A640CB594166666666C32A24410000004043CB59419A9999995A2A24410000004047CB5941CDCCCCCCB7292441666666A64ECB59413333333379292441CDCCCC0C45CB594133333333FB282441333333B34DCB594166666666CE282441CDCCCCEC4FCB59419A99999930282441CDCCCCEC3DCB594166666666972724413333339326CB59419A999999622724419A9999591FCB5941333333333A2724416666662624CB59410000000001272441CDCCCC2C1CCB594100000000B3262441666666A613CB59413333333325262441CDCCCC6C22CB5941CDCCCCCC6B252441000000C032CB59410000000050232441000000E064CB59419A9999990E232441CDCCCC2C6DCB5941CDCCCCCC8B222441CDCCCCAC7BCB594100000000BE222441CDCCCC0C81CB59419A99999926232441CDCCCCCC92CB59410000000056232441CDCCCCEC9CCB594133333333C72324419A9999F9B1CB594166666666012424419A9999D9B5CB594100000000C7232441CDCCCCCCBECB5941666666665123244166666666D9CB5941000000002923244166666606DFCB5941000000002023244133333313E7CB5941666666668222244133333393E7CB5941CDCCCCCC7F222441333333D3E9CB59410000000049232441CDCCCCEC07CC5941CDCCCCCCCD2224413333331371CC59419A99999952222441CDCCCC4C76CC5941CDCCCCCC482224419A9999F957CC5941CDCCCCCCCC212441333333B34BCC59419A99999934212441333333933DCC594100000000851F2441CDCCCCCC74CC59419A999999981F24410000004086CC594133333333B71F2441333333738CCC594133333333EA1F24413333339392CC594100000000DA20244166666666A8CC5941CDCCCCCC3D212441CDCCCC8CB9CC59419A999999FE202441CDCCCC2CBBCC594100000000F020244166666606C3CC5941CDCCCCCCD9202441333333B3C5CC59419A9999998C2024419A999979C9CC594166666666DC1F244166666606CFCC5941CDCCCCCCEF1F244166666646DCCC594100000000C61F24419A9999D9DECC594100000000D51F244133333353E8CC5941CDCCCCCCEF1F2441333333D301CD5941000000006F1F24410000006009CD594100000000FD1E2441666666260FCD594100000000FD1E2441666666260FCD5941	01010000206A080000A0A0ED77AC38244166666666E1CC5941	450170000	Z	Auvilliers-en-Gâtinais	4501700	45017	45	24	21
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	01010000206A08000044D81F88042F24419A9999F9B5DB5941	450180000	Z	Auxy	4501800	45018	45	24	20
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	01010000206A08000092CC2EC452382241000000C019C45941	450190000	Z	Baccon	4501900	45019	45	24	33
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	01010000206A080000C6CB16B0284922419A999979EDBF5941	450200000	Z	Le Bardon	4502000	45020	45	24	12
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	01010000206A08000078D487B9BD0124419A9999294FDC5941	450210000	Z	Barville-en-Gâtinais	4502100	45021	45	24	10
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	01010000206A080000CA7FBEA65EED23416666663658D95941	450220000	Z	Batilly-en-Gâtinais	4502200	45022	45	24	10
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	01010000206A080000F22A12EF1B1925419A9999F902A65941	450230000	Z	Batilly-en-Puisaye	4502300	45023	45	24	17
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	01010000206A080000989999D9A1522241CCCCCC4C1FBC5941	450240000	Z	Baule	4502400	45024	45	24	12
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	01010000206A080000AAAAAAF899332341000000406BE25941	450250000	Z	Bazoches-les-Gallerandes	4502500	45025	45	24	37
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	01010000206A08000080FD099852582541000000E074DE5941	450260000	Z	Bazoches-sur-le-Betz	4502600	45026	45	24	15
01060000206A080000010000000103000000010000001705000033333333680924410000008091C959413333333368092441CDCCCCCC92C95941666666666E0924419A9999B996C959416666666679092441333333F39BC959413333333388092441666666E6A1C959419A999999970924419A9999F9A8C9594166666666A6092441666666A6AEC959419A999999B70924419A999939B6C95941CDCCCCCCC309244166666686BAC9594100000000D1092441000000E0C0C95941CDCCCCCCDE0924419A999999C7C959419A999999EC09244166666606CEC9594133333333F809244100000060D3C959419A999999060A2441333333F3D8C9594100000000140A2441333333F3DEC95941CDCCCCCC1E0A24419A999979E3C95941CDCCCCCC2F0A244133333373E8C959419A999999310A244133333313E9C959419A9999993E0A244166666686EDC9594133333333530A24419A999999F4C95941333333336A0A24419A9999F9FBC959419A9999997E0A2441000000A002CA5941CDCCCCCC910A24416666664609CA5941CDCCCCCCA00A24419A9999990DCA594100000000A70A2441000000E00FCA59419A999999AA0A2441666666C612CA594166666666AD0A24413333331315CA594166666666AE0A24416666662618CA59419A999999AF0A2441000000E018CA59419A999999B10A2441000000E019CA5941CDCCCCCCB80A24419A9999B91BCA5941CDCCCCCCC10A2441666666C61DCA594100000000D60A2441CDCCCC4C20CA5941CDCCCCCCFB0A24410000006025CA5941CDCCCCCC270B2441CDCCCCAC2BCA5941666666665A0B2441333333F331CA5941CDCCCCCC8C0B24416666666639CA59419A999999BD0B24419A99997940CA594100000000E50B2441CDCCCC0C46CA59419A999999FA0B24410000000049CA594100000000140C2441333333734CCA594133333333470C2441666666A653CA594166666666850C2441666666065CCA59419A999999940C2441CDCCCC2C5ECA5941CDCCCCCCA50C2441000000A060CA594100000000C80C24410000006065CA594133333333EC0C2441333333D369CA594133333333030D24419A9999396CCA5941333333330F0D2441CDCCCCEC6DCA5941000000001C0D2441666666E66FCA59419A9999993A0D24416666664674CA594166666666570D24419A99993978CA594100000000760D2441000000C07BCA594100000000A10D24413333337381CA594100000000CA0D24413333337386CA59419A999999E30D24419A9999F989CA594166666666F00D24419A9999598BCA594166666666FC0D2441000000208CCA594166666666000E2441333333338FCA594100000000040E2441CDCCCC8C91CA594133333333060E24416666666694CA59419A999999070E2441CDCCCC2C96CA59419A9999990F0E24419A99999999CA5941CDCCCCCC190E2441000000809CCA594100000000210E24419A9999B99ECA594133333333260E244133333393A1CA59419A999999280E2441000000C0A3CA594100000000320E2441000000E0A7CA59419A999999440E2441666666A6AECA59419A9999994C0E2441CDCCCC8CB1CA5941CDCCCCCC6C0E244133333353BCCA5941CDCCCCCC7B0E2441CDCCCC0CC2CA5941CDCCCCCC850E2441000000A0C5CA59419A9999999A0E2441CDCCCCCCCDCA59419A9999999D0E2441CDCCCC0CCFCA5941CDCCCCCCA30E244166666626D2CA59419A999999A80E24419A9999D9D4CA59419A999999B00E244133333373D7CA5941CDCCCCCCB80E24419A999919D9CA5941CDCCCCCCBE0E244166666686DBCA59419A999999C20E24419A9999D9DDCA59419A999999C60E244166666606E1CA5941CDCCCCCCCA0E244133333393E3CA594100000000D00E244166666666E6CA594166666666D40E244100000000E9CA59419A999999D70E2441666666E6EBCA594166666666DA0E2441CDCCCCECEECA59419A999999DF0E2441CDCCCCCCF1CA594166666666E50E2441CDCCCC8CF4CA5941CDCCCCCCE80E2441666666C6F7CA594100000000EB0E2441333333F3FACA594133333333EE0E2441000000A0FDCA59419A999999F20E2441CDCCCCEC00CB594166666666F70E24413333335304CB594166666666FC0E2441333333B307CB594100000000020F24419A9999F90ACB594133333333040F24419A9999990CCB5941CDCCCCCC060F2441CDCCCCAC0ECB5941666666660A0F24416666660612CB5941CDCCCCCC0A0F24410000008012CB5941666666660D0F24413333337315CB5941CDCCCCCC100F2441000000C019CB5941CDCCCCCC130F2441000000601DCB594133333333170F2441CDCCCCCC21CB5941CDCCCCCC190F2441333333D325CB5941CDCCCCCC1A0F24419A99993927CB5941000000001C0F24410000006029CB5941666666661E0F2441CDCCCC8C2CCB594166666666210F24410000006030CB5941CDCCCCCC230F24410000004033CB59419A999999290F24413333337338CB5941CDCCCCCC340F24419A99999945CB594166666666420F24419A9999F955CB594100000000470F2441CDCCCCAC5BCB5941000000004D0F2441CDCCCC4C63CB594100000000570F2441000000406FCB59419A999999610F2441333333737BCB59419A999999690F24419A99995984CB5941000000006D0F2441666666A689CB59419A9999996B0F2441CDCCCCEC8ACB594166666666710F2441CDCCCC0C8DCB594133333333740F2441CDCCCC8C8FCB594100000000750F24416666660690CB59419A9999997C0F2441000000E097CB59419A999999840F24419A9999799DCB594166666666900F2441CDCCCCCC9DCB594166666666960F2441666666669ECB5941CDCCCCCC9B0F2441000000209FCB5941CDCCCCCCA10F244166666606A0CB594100000000CC0F2441CDCCCC2CA7CB594133333333EA0F24419A999939ACCB5941CDCCCCCC0A102441666666E6B1CB5941333333333210244100000080B8CB59413333333382102441CDCCCC0CC7CB594100000000A710244133333393CDCB594133333333D110244166666606D5CB594133333333F7102441CDCCCC6CDBCB5941CDCCCCCC1A112441333333D3E0CB59413333333343112441333333F3E5CB5941000000006E112441000000E0EACB5941000000009F112441666666A6EFCB5941CDCCCCCCC6112441666666A6F3CB59419A999999D611244166666626F6CB594133333333DE112441CDCCCCACF7CB594100000000E9112441CDCCCCCCF9CB594166666666F611244133333353FCCB59419A99999915122441666666C600CC59416666666624122441000000E002CC59410000000034122441333333F305CC5941CDCCCCCC3E122441CDCCCCCC08CC5941666666664A122441333333F30ACC5941CDCCCCCC54122441333333D30CCC59416666666668122441000000C00FCC594100000000A0122441666666E616CC594133333333D8122441666666061ECC594133333333EE122441333333F320CC594100000000FE1224419A99995923CC5941000000000E1324416666662626CC59419A99999923132441333333332ACC59419A999999241324419A9999592ACC59419A99999934132441333333532DCC59419A9999993B132441666666A62ECC59410000000043132441000000602FCC5941000000004B1324419A99993934CC5941333333334D1324413333339339CC5941333333334E132441333333933FCC5941666666664F1324416666668644CC59413333333351132441000000C046CC59413333333352132441CDCCCC2C48CC5941CDCCCCCC59132441333333134CCC5941CDCCCCCC6F1324413333337351CC5941333333339C132441666666A65ACC594133333333AD132441333333F35DCC5941CDCCCCCCB91324416666666660CC59419A999999D31324419A99995966CC5941CDCCCCCCDF132441666666A66ACC5941CDCCCCCCE91324419A9999B96FCC594133333333F51324413333339376CC594133333333F7132441CDCCCC6C77CC594133333333FA132441CDCCCCAC78CC5941666666661F142441666666C692CC5941333333335B142441333333339BCC5941CDCCCCCC5D142441CDCCCC0C9BCC59419A99999972142441CDCCCC0C99CC5941CDCCCCCC8F1424413333337396CC59419A999999B91424413333333394CC59419A999999E81424413333339392CC59419A999999E9142441CDCCCC8C92CC5941000000000F1524419A99993991CC5941666666665E152441333333538ECC59416666666683152441000000208DCC59416666666692152441CDCCCCAC8CCC594100000000B51524419A9999998CCC5941CDCCCCCCFB152441000000608CCC59413333333331162441666666A68BCC5941000000005C162441333333D38ACC59410000000073162441CDCCCCAC8ACC59410000000084162441333333538ACC5941333333339B1624416666660689CC594133333333CF162441CDCCCCEC86CC594100000000D5162441666666E686CC594166666666EE1624416666664686CC5941CDCCCCCCFA1624410000008085CC5941333333330B172441333333F384CC59413333333328172441666666A683CC594166666666411724410000000082CC5941CDCCCCCC58172441CDCCCCAC80CC5941CDCCCCCC741724410000004080CC594133333333961724419A9999B97ECC59419A999999D9172441333333137BCC594100000000311824419A99999976CC5941CDCCCCCC45182441CDCCCC2C75CC5941666666664E182441333333F374CC5941CDCCCCCC571824413333333375CC59413333333361182441000000C074CC59416666666679182441CDCCCCCC74CC5941CDCCCCCC87182441000000E074CC5941CDCCCCCC98182441333333B374CC5941CDCCCCCCA2182441CDCCCCCC74CC594166666666A9182441CDCCCCAC76CC594166666666AF1824419A99999978CC5941CDCCCCCCAF1824419A9999797ACC594166666666AD182441CDCCCC0C7CCC594100000000AA1824419A9999997DCC594133333333AB182441CDCCCCEC7DCC594100000000B0182441333333537ECC594100000000B5182441CDCCCCAC7ECC594100000000C5182441CDCCCC8C7ECC59419A999999CE182441CDCCCC8C7ECC594100000000D6182441666666E67ECC594166666666DB182441CDCCCC2C7FCC594133333333E1182441CDCCCC2C7FCC5941CDCCCCCCE8182441000000007FCC594133333333EC182441333333D37ECC594133333333F3182441000000607ECC594133333333F9182441CDCCCC0C7ECC5941CDCCCCCCFE182441CDCCCCCC7DCC5941CDCCCCCC05192441000000607DCC5941CDCCCCCC09192441333333137DCC59419A9999990F1924419A9999997CCC5941CDCCCCCC13192441666666067CCC594100000000181924419A9999397BCC5941CDCCCCCC1A1924419A9999D97ACC59410000000020192441CDCCCC6C7ACC59413333333325192441666666267ACC5941666666662F1924413333337379CC5941000000003A1924416666668678CC59410000000052192441666666E675CC594133333333731924410000002072CC59410000000084192441666666C670CC5941CDCCCCCC8E1924419A99999970CC5941333333339C192441333333B370CC5941CDCCCCCCB41924416666666672CC59419A999999D71924410000006075CC594166666666FB1924416666662677CC594100000000151A24416666664678CC59419A999999321A2441CDCCCC2C78CC5941333333334D1A2441CDCCCC6C77CC59419A999999681A24419A99999976CC5941CDCCCCCC751A24419A99999976CC594166666666901A2441666666A677CC594133333333AB1A2441CDCCCCEC78CC594166666666BE1A24416666664679CC594166666666CD1A2441CDCCCCEC78CC59419A999999E01A2441666666A677CC594100000000F01A2441666666C675CC59419A999999FE1A24419A99993975CC5941000000000D1B2441666666C674CC594133333333161B24410000002075CC594100000000251B2441CDCCCCEC75CC594133333333321B2441333333B375CC5941CDCCCCCC3C1B2441333333B374CC5941000000003F1B24413333331374CC5941CDCCCCCC411B24410000000073CC5941CDCCCCCC511B24410000002071CC5941CDCCCCCC611B2441CDCCCC0C6FCC594166666666711B2441CDCCCCCC6CCC594133333333801B2441CDCCCCAC69CC5941333333338D1B2441666666C666CC594100000000991B24419A99993965CC594133333333A51B24419A99999964CC594166666666A81B2441CDCCCC4C64CC59419A999999B61B24419A99999964CC594166666666C61B2441CDCCCC8C65CC5941CDCCCCCCD21B2441000000C066CC59419A999999DB1B24410000006067CC594133333333E31B2441000000A067CC5941CDCCCCCCE91B24416666668667CC59419A999999EE1B24419A99999967CC594166666666F61B2441CDCCCC0C68CC5941CDCCCCCCFA1B24416666660668CC5941CDCCCCCCFE1B2441666666C667CC59419A999999111C2441333333F366CC5941000000001A1C24419A9999B966CC59419A9999991E1C2441333333D366CC5941000000002A1C24410000004067CC594133333333381C2441333333B367CC59419A9999994C1C2441666666C667CC5941000000005A1C2441000000C067CC594133333333611C24410000006067CC5941CDCCCCCC651C2441666666A666CC5941333333336E1C24410000004063CC59419A999999721C24419A9999D961CC5941CDCCCCCC7F1C24413333339360CC59419A9999998A1C24410000004060CC594133333333971C24419A99993960CC594133333333A01C2441000000805FCC594133333333AD1C2441CDCCCC6C5DCC594133333333B21C2441CDCCCC2C5DCC594133333333B91C24419A9999D95CCC5941CDCCCCCCBE1C2441CDCCCC2C5CCC5941CDCCCCCCE11C2441CDCCCC2C59CC5941CDCCCCCC041D2441CDCCCCAC55CC594166666666191D2441666666C653CC59419A9999993D1D24419A9999595BCC59419A999999521D2441333333B35ACC5941CDCCCCCC7C1D2441666666A65ACC594100000000A51D24419A9999B95ACC594100000000E31D24419A9999D95ACC5941CDCCCCCC3B1E2441CDCCCC0C5BCC5941000000004E1E2441CDCCCC4C5FCC594166666666621E2441666666A665CC5941666666668C1E24419A99997971CC594133333333941E24416666664673CC594166666666A51E24413333337372CC594166666666EC1E2441CDCCCC8C6ECC5941000000000F1F2441000000E06DCC594100000000271F2441CDCCCCAC6DCC5941CDCCCCCC2A1F2441CDCCCCEC6DCC5941666666662E1F24419A9999596ECC594166666666471F2441CDCCCC8C73CC5941000000004F1F24419A99999975CC5941666666665F1F24413333335375CC594133333333641F24419A99993975CC5941CDCCCCCC681F24410000002075CC594100000000851F2441CDCCCCCC74CC59419A99999934212441333333933DCC59419A99999983212441000000C044CC5941CDCCCCCCCC212441333333B34BCC5941666666663D222441CDCCCCEC56CC5941CDCCCCCC482224419A9999F957CC59413333333349222441CDCCCC8C58CC5941666666664C2224410000004059CC5941000000004D222441666666665BCC5941000000004E2224419A99991961CC59419A99999952222441CDCCCC4C76CC5941CDCCCCCCCD2224413333331371CC594100000000D82224419A99997968CC5941666666660B232441666666863CCC594166666666162324410000002033CC59410000000049232441CDCCCCEC07CC59419A99999934232441000000E004CC5941333333332D232441333333D303CC594133333333292324413333333303CC594100000000B0222441666666C6F0CB5941CDCCCCCC7F222441333333D3E9CB5941666666668222244133333393E7CB59419A999999B422244100000080E7CB594100000000D122244166666606E7CB59419A999999EE22244133333313E7CB5941CDCCCCCC1123244100000020E7CB5941000000002023244133333313E7CB59419A9999992423244100000020E6CB594166666666292324419A999939E4CB59416666666629232441333333D3E1CB5941000000002923244166666606DFCB5941000000002D23244166666666DECB59410000000043232441666666C6DBCB5941666666665123244166666666D9CB594166666666592324419A999999D6CB59419A9999995F23244100000060D5CB59419A9999996B232441CDCCCC8CD3CB59419A9999997C232441333333D3CFCB5941666666668E23244166666646CBCB5941333333339B2324419A999979C8CB594166666666A023244133333353C7CB5941CDCCCCCCAE232441CDCCCC6CC3CB594100000000C7232441CDCCCCCCBECB5941CDCCCCCCDE23244100000080BBCB59419A999999EE2324419A999959B8CB594166666666F4232441000000C0B6CB594166666666012424419A9999D9B5CB594133333333C72324419A9999F9B1CB594133333333B9232441000000C0AECB5941CDCCCCCC9A23244166666666A9CB59410000000056232441CDCCCCEC9CCB594133333333292324419A9999F993CB594100000000272324413333339393CB59419A99999926232441CDCCCCCC92CB59419A999999C7222441000000E082CB594100000000BE222441CDCCCC0C81CB594166666666B8222441333333F380CB594100000000B32224410000000081CB594166666666A8222441666666E67FCB5941CDCCCCCC8B222441CDCCCCAC7BCB59419A9999990E232441CDCCCC2C6DCB59410000000050232441000000E064CB594133333333F02324416666660656CB59413333333324252441CDCCCC8C39CB5941CDCCCCCC6B252441000000C032CB59410000000098252441000000002FCB594166666666D0252441CDCCCCCC29CB59413333333325262441CDCCCC6C22CB59419A99999932262441666666E620CB5941CDCCCCCC59262441CDCCCC4C1DCB5941CDCCCCCC8C2624419A9999B917CB5941666666669F2624419A99999915CB594100000000B3262441666666A613CB594133333333D52624419A99995917CB59410000000001272441CDCCCC2C1CCB594133333333352724413333337323CB5941333333333A2724416666662624CB59419A9999994F2724416666668621CB59419A999999622724419A9999591FCB594100000000762724416666662621CB594166666666972724413333339326CB594100000000CD272441000000C02ECB594166666666FE272441CDCCCC0C36CB5941CDCCCCCC15282441666666C639CB5941CDCCCCCC18282441000000403ACB59419A99999930282441CDCCCCEC3DCB59410000000058282441666666C642CB59419A9999998D2824413333331349CB594166666666B72824419A9999794DCB594166666666CE282441CDCCCCEC4FCB5941CDCCCCCCD7282441CDCCCCEC4FCB594133333333FB282441333333B34DCB5941CDCCCCCC48292441CDCCCC0C48CB59413333333379292441CDCCCC0C45CB5941CDCCCCCCB7292441666666A64ECB594133333333BD292441CDCCCC6C4ECB594133333333C0292441CDCCCC4C4ECB594100000000F12924419A9999194CCB5941CDCCCCCC242A2441666666C649CB59419A9999995A2A24410000004047CB594100000000972A2441666666C644CB594166666666C32A24410000004043CB59419A999999E62A24419A99997942CB5941CDCCCCCCEF2A24416666664642CB5941CDCCCCCC172B2441CDCCCC6C41CB5941CDCCCCCC2A2B2441666666A640CB59419A999999592B2441666666663CCB5941333333338C2B24413333339337CB59419A999999BB2B24413333335333CB594133333333D22B2441666666E630CB594166666666DC2B2441333333F32ECB594133333333E22B2441333333F32CCB594100000000EE2B24413333337328CB594100000000202C24413333339318CB594133333333562C24413333335306CB5941333333335F2C2441666666A603CB594166666666782C244133333313FCCA5941CDCCCCCC7E2C2441CDCCCC8CFACA594133333333832C24419A999979F9CA5941CDCCCCCC8E2C244166666686F7CA594166666666E12C24419A9999D9EFCA59419A9999993B2D244166666626E8CA5941000000004E2D244100000020E6CA594166666666522D2441CDCCCC8CE5CA5941333333337F2D2441333333B3DFCA594100000000BA2D244100000000D7CA5941CDCCCCCCDF2D244100000020D2CA594100000000EB2D2441CDCCCCACD0CA5941666666660C2E2441333333B3CDCA5941666666663F2E24419A9999B9CACA5941CDCCCCCC5F2E244166666626C9CA5941CDCCCCCCB22E244133333313C5CA594166666666E72E2441CDCCCCCCC2CA594166666666F42E24419A999919C3CA5941CDCCCCCC022F2441CDCCCC8CC3CA5941333333330E2F244100000000C4CA5941CDCCCCCC132F24419A999939C4CA594133333333212F24419A9999B9C4CA594133333333302F24419A999959C5CA5941333333333B2F2441CDCCCCACC5CA5941CDCCCCCC472F2441CDCCCCECC5CA594166666666522F2441000000E0C5CA5941CDCCCCCC5C2F244133333333C6CA5941CDCCCCCC642F24419A999959C6CA5941CDCCCCCC6D2F244133333353C6CA5941CDCCCCCC7E2F244133333373C6CA594133333333922F2441000000A0C6CA5941333333339C2F24419A9999B9C6CA594166666666A82F2441333333D3C6CA5941CDCCCCCCB62F24419A9999F9C6CA594166666666CC2F244100000060C7CA59419A999999DA2F2441666666A6C7CA594100000000E72F244100000000C8CA594166666666EF2F2441CDCCCC2CC8CA594133333333F62F244166666626C8CA594133333333FB2F244166666606C8CA5941CDCCCCCC03302441666666C6C7CA5941666666660C302441333333B3C7CA5941CDCCCCCC13302441666666A6C7CA5941666666661B302441666666C6C7CA5941CDCCCCCC26302441666666A6C7CA5941333333332C30244100000060C7CA5941666666663630244133333353C7CA59419A9999994030244166666646C7CA5941333333334B302441CDCCCCECC6CA59419A9999995630244133333373C6CA5941CDCCCCCC5F30244166666626C6CA5941CDCCCCCC69302441000000C0C5CA59413333333373302441CDCCCC6CC5CA5941000000007730244100000060C5CA5941CDCCCCCC7E3024419A9999B9C5CA594166666666853024419A9999D9C5CA5941333333338E30244166666606C6CA5941333333339530244100000040C6CA5941CDCCCCCC9B30244166666686C6CA594166666666A73024419A999999C6CA594100000000B1302441CDCCCCACC6CA5941CDCCCCCCBA30244166666686C6CA594100000000C13024419A999959C6CA594133333333CA30244166666626C6CA594100000000D3302441333333F3C5CA594166666666D930244166666606C6CA594100000000E130244166666626C6CA594133333333F330244100000040C6CA594100000000FE30244133333373C6CA59410000000006312441000000E0C6CA59419A9999990C31244166666626C7CA5941666666661331244133333333C7CA5941666666661C312441CDCCCC4CC7CA5941000000002831244133333333C7CA5941000000003131244133333313C7CA5941CDCCCCCC3631244166666686C6CA5941CDCCCCCC3F312441CDCCCC4CC6CA594166666666473124419A999959C6CA59419A9999994E312441CDCCCC8CC6CA59419A99999955312441666666E6C6CA5941333333335C312441CDCCCC8CC7CA59413333333366312441CDCCCC6CC8CA5941333333336E312441CDCCCCACC8CA5941000000007531244166666686C8CA5941000000007D3124419A999959C8CA5941000000008731244166666646C8CA5941000000009131244166666606C8CA59410000000099312441333333B3C7CA59419A9999999F31244100000040C7CA594133333333B031244133333353C7CA594100000000B63124419A999999C7CA5941CDCCCCCCBC31244100000000C8CA59419A999999C331244166666626C8CA594166666666C9312441CDCCCC2CC8CA594100000000D531244166666606C8CA594100000000E33124419A9999F9C7CA594133333333ED312441333333D3C7CA59419A999999F4312441666666C6C7CA594166666666FE312441333333F3C7CA5941666666660932244100000040C8CA5941333333330F32244133333373C8CA594100000000173224419A999919C9CA5941CDCCCCCC1E32244133333373C9CA59419A999999243224419A999979C9CA5941000000002D32244166666666C9CA59410000000035322441CDCCCC4CC9CA59419A999999433224419A999939C9CA5941CDCCCCCC4D32244166666646C9CA59410000000056322441CDCCCC6CC9CA5941CDCCCCCC5E3224419A999999C9CA59416666666665322441CDCCCCECC9CA5941000000007132244166666646CACA5941666666667D3224419A999999CACA5941333333338832244133333313CBCA59410000000090322441CDCCCC0CCBCA59416666666695322441CDCCCC0CCBCA5941666666669A322441333333D3CACA594133333333A332244100000080CACA594133333333B532244166666606CACA594100000000BE32244100000040CACA594166666666C93224419A9999B9CACA594166666666D4322441CDCCCCECCACA594100000000DF32244100000000CBCA594100000000EE32244166666606CBCA59419A999999FC32244100000020CBCA5941333333330A33244133333373CBCA59416666666615332441333333B3CBCA59416666666620332441000000C0CBCA5941666666662B332441333333D3CBCA5941CDCCCCCC3C332441CDCCCC2CCCCA5941333333334D3324419A999999CCCA59416666666656332441333333F3CCCA5941333333336233244100000000CDCA59419A99999970332441333333F3CCCA5941CDCCCCCC7D332441333333D3CCCA594166666666883324419A999999CCCA59416666666691332441CDCCCC2CCCCA5941666666669C33244133333313CCCA5941CDCCCCCCA03324419A9999F9CBCA594100000000AC332441CDCCCCACCBCA594100000000C433244100000040CBCA594166666666F133244100000080CACA59419A9999991C342441333333B3C9CA59419A9999992F34244133333313C9CA5941CDCCCCCC3F34244166666686C8CA594133333333493424419A9999D9C7CA5941CDCCCCCC50342441CDCCCC8CC7CA5941666666665A34244166666686C7CA594166666666683424419A999999C7CA5941000000007B3424419A9999D9C7CA5941666666668D342441CDCCCC6CC8CA59410000000096342441CDCCCC8CC8CA5941333333339F342441CDCCCCACC8CA59419A999999B43424419A9999F9C8CA594100000000CC34244133333353C9CA594100000000EC3424419A9999D9C9CA59416666666606352441CDCCCC4CCACA5941CDCCCCCC2335244133333313CBCA59413333333340352441666666E6CBCA5941CDCCCCCC5135244166666686CCCA5941000000005C352441000000C0CCCA594100000000653524419A9999B9CCCA5941CDCCCCCC6D35244166666606CDCA5941CDCCCCCC7D352441666666C6CDCA5941333333338735244133333333CECA5941666666668C35244133333373CECA5941666666669A352441000000C0CECA594166666666AA352441666666E6CECA594100000000B5352441CDCCCCECCECA594166666666BD352441333333B3CECA59419A999999C4352441CDCCCC0CCECA5941CDCCCCCCC935244133333353CDCA594100000000D335244166666686CCCA5941CDCCCCCCE1352441666666C6CBCA594100000000F0352441CDCCCC0CCBCA594133333333FD3524419A999939CACA59419A9999990636244166666666C9CA59410000000013362441000000C0C8CA59419A999999203624419A999939C8CA5941000000002E362441666666C6C7CA5941CDCCCCCC3736244100000080C7CA5941CDCCCCCC42362441333333B3C6CA59419A9999994C3624419A999959C5CA5941000000005436244133333373C4CA5941CDCCCCCC5836244100000020C4CA5941CDCCCCCC5E362441CDCCCC0CC4CA59419A9999996436244133333333C4CA59419A99999969362441CDCCCCACC4CA5941666666667036244100000080C5CA5941CDCCCCCC7636244133333353C6CA5941CDCCCCCC80362441000000E0C6CA5941333333338D36244100000080C7CA5941333333339936244100000020C8CA594166666666A1362441000000A0C8CA594166666666A7362441CDCCCCACC8CA594100000000AF36244133333353C8CA5941CDCCCCCCB6362441333333D3C7CA594100000000BE36244100000080C7CA594133333333C836244133333353C7CA594100000000D2362441CDCCCC4CC7CA594166666666DC362441CDCCCC6CC7CA594100000000E63624419A9999F9C7CA594166666666ED362441000000C0C8CA594166666666F3362441666666A6C9CA594133333333FA362441CDCCCC6CCACA5941CDCCCCCC01372441CDCCCCCCCACA5941333333330D372441666666C6CACA5941333333332237244133333393CACA594100000000373724419A999959CACA5941333333334737244100000020CACA59416666666653372441CDCCCCCCC9CA5941333333335C372441000000C0C9CA5941CDCCCCCC72372441333333B3C9CA59419A9999997D372441666666A6C9CA5941333333338937244166666686C9CA59416666666697372441CDCCCC4CC9CA594133333333A337244100000020C9CA59419A999999B0372441CDCCCCACC8CA59419A999999BC37244166666626C8CA594100000000C43724419A999979C7CA594100000000C737244133333353C6CA594100000000C7372441CDCCCC0CC5CA594166666666C6372441000000A0C3CA594133333333C8372441666666A6C2CA594166666666CB37244166666686C1CA594166666666D2372441666666A6C0CA594100000000DD372441333333D3BFCA5941CDCCCCCCE837244100000060BFCA594166666666F537244166666606BFCA59413333333300382441CDCCCC8CBECA594166666666083824419A9999F9BDCA59419A99999914382441333333D3BCCA59419A9999992C382441CDCCCC2CBACA59419A9999993F382441CDCCCC6CB8CA5941666666665C38244166666686B5CA5941CDCCCCCC74382441CDCCCCECB2CA5941000000007D38244166666606B2CA59419A9999998538244100000000B1CA5941CDCCCCCC9438244133333333AFCA594166666666A138244100000000AECA5941CDCCCCCCB03824419A9999F9ACCA594166666666C0382441CDCCCC2CACCA59419A999999D138244133333393ABCA594100000000DE38244133333313ABCA59419A999999ED38244133333373AACA594133333333FE3824419A9999D9A9CA5941CDCCCCCC0C392441000000A0A9CA5941CDCCCCCC1E39244166666646A9CA5941000000002E3924419A999999A8CA5941333333333F3924419A9999B9A7CA5941CDCCCCCC4D39244133333333A7CA5941333333335A3924419A9999F9A6CA59419A99999968392441CDCCCC6CA6CA594166666666783924419A9999B9A5CA5941000000008C392441000000E0A4CA5941333333339B3924419A999959A4CA5941CDCCCCCCA639244100000020A4CA594100000000B339244133333313A4CA59419A999999C3392441CDCCCCCCA3CA59419A999999D139244100000060A3CA594166666666DD39244166666646A3CA594133333333F1392441CDCCCC4CA3CA594166666666043A244100000080A3CA594100000000193A2441000000C0A3CA5941CDCCCCCC2C3A244100000000A4CA5941CDCCCCCC423A244166666666A4CA5941CDCCCCCC5B3A24419A9999D9A4CA594100000000763A24419A999959A5CA594100000000913A2441333333B3A5CA59419A999999AA3A244133333313A6CA59419A999999BB3A244100000060A6CA594133333333C13A24419A999979A6CA59419A999999D63A24419A999919A7CA594100000000E33A2441666666C6A7CA5941CDCCCCCCEB3A244133333393A8CA594133333333F43A2441666666E6A9CA594166666666FF3A244166666606ABCA59419A9999990C3B24419A999939ACCA594166666666173B244166666686ADCA594133333333213B2441666666C6AECA594166666666293B2441CDCCCCACAFCA59419A999999353B2441000000A0B0CA594133333333443B24419A999979B1CA59419A999999573B2441CDCCCC0CB2CA59419A999999603B24419A999979B2CA59419A999999673B24419A999999B2CA5941333333336E3B244100000040B2CA594166666666793B2441333333F3B1CA594100000000883B24419A9999D9B1CA594100000000963B2441000000C0B1CA5941CDCCCCCCAE3B24419A999999B1CA594100000000C43B24419A999959B1CA5941CDCCCCCCDA3B2441333333B3B0CA594166666666F73B2441CDCCCC8CAFCA594133333333173C24419A999939AECA5941666666663A3C2441666666A6ACCA594100000000543C2441CDCCCC6CABCA5941CDCCCCCC6F3C2441CDCCCC4CAACA5941CDCCCCCC823C24419A999999A9CA59419A999999973C2441CDCCCC2CA9CA594166666666B53C2441666666E6A8CA594100000000D23C2441CDCCCCACA8CA594133333333EB3C2441CDCCCCACA8CA59419A999999F63C24419A999959A8CA5941CDCCCCCC083D2441333333D3A7CA594166666666183D244133333373A7CA5941CDCCCCCC263D2441333333D3A6CA594133333333343D244133333313A6CA5941666666663D3D244166666686A5CA59419A999999483D244133333373A5CA5941CDCCCCCC593D2441000000A0A5CA594166666666673D244100000020A6CA594133333333753D244133333353A6CA5941CDCCCCCC833D244100000000A6CA5941666666668D3D244133333393A5CA5941CDCCCCCC903D2441CDCCCC6CA5CA5941000000009B3D2441CDCCCCACA4CA59419A999999A23D24419A9999F9A3CA59419A999999AC3D24419A999979A3CA5941CDCCCCCCBA3D244166666646A3CA59419A999999CE3D244100000080A3CA594133333333E23D2441333333D3A3CA5941CDCCCCCCF43D2441CDCCCCECA3CA59419A999999043E244133333393A3CA59419A9999991B3E24419A9999D9A2CA59419A999999303E2441666666C6A1CA5941CDCCCCCC3F3E24419A999959A1CA59419A9999994C3E24419A999959A1CA594100000000593E244166666666A1CA59419A999999683E2441333333B3A1CA5941CDCCCCCC753E244133333393A1CA59419A999999803E2441000000E0A0CA594166666666873E2441CDCCCC8C9FCA5941666666668D3E2441666666269ECA594166666666953E2441CDCCCC4C9DCA5941CDCCCCCCA03E2441000000009DCA594133333333B23E2441CDCCCC0C9DCA59419A999999C43E2441000000409DCA594100000000D03E2441666666A69DCA594100000000DC3E2441333333939ECA59419A999999E73E2441CDCCCC8C9FCA594100000000F13E24419A9999F99FCA594166666666073F24419A999959A0CA5941000000001D3F2441CDCCCC8CA0CA5941666666662A3F2441CDCCCCACA0CA59419A999999363F24419A999939A0CA5941666666663E3F2441CDCCCC4C9FCA594166666666453F2441666666E69DCA5941333333334C3F2441666666A69CCA5941CDCCCCCC553F2441666666A69BCA594133333333633F24419A9999399BCA594100000000793F2441CDCCCCAC9ACA594166666666883F2441CDCCCC6C9ACA594100000000993F2441000000809ACA594166666666AE3F2441CDCCCCCC9ACA594100000000C53F24419A9999199BCA59419A999999D03F2441CDCCCC4C9BCA594166666666DF3F2441CDCCCCEC9ACA594100000000F33F2441CDCCCC2C9ACA594166666666084024419A99993999CA5941CDCCCCCC1A4024410000008098CA5941666666662A402441666666E697CA594133333333274024410000004095CA594166666666284024413333331392CA59419A9999992D4024419A9999398FCA5941000000003C402441000000008ECA59419A9999994B402441333333F38DCA59419A9999995E402441666666268FCA5941CDCCCCCC774024419A99993991CA5941CDCCCCCC814024419A99995992CA59419A99999963402441CDCCCC0C85CA59410000000001402441CDCCCCAC59CA59419A999999174024410000008059CA5941CDCCCCCC2D4024416666668659CA5941CDCCCCCC41402441666666C659CA5941CDCCCCCC62402441000000005ACA59413333333376402441666666465ACA5941CDCCCCCC81402441333333335ACA59410000000089402441CDCCCCCC59CA5941333333338C402441CDCCCCEC58CA59419A9999998D4024416666664658CA5941CDCCCCCC904024410000008056CA5941333333339A4024416666668652CA594166666666A2402441333333734ECA594100000000A8402441000000604BCA594166666666AB4024419A99999948CA594100000000AD402441CDCCCCCC45CA59419A999999AE402441666666A642CA5941CDCCCCCCAF402441000000C040CA59419A999999B1402441CDCCCCAC3ECA594166666666664024410000008039CA594166666666204024419A99999934CA5941CDCCCCCC14402441666666C633CA594100000000FF3F24419A99995932CA5941CDCCCCCCE73F2441CDCCCCEC30CA5941CDCCCCCCCF3F2441CDCCCCAC2FCA594133333333CA3F2441333333732FCA594133333333A53F2441666666E62DCA5941000000005D3F2441CDCCCC2C2BCA59419A999999373F2441333333D329CA594166666666203F24419A9999D928CA594133333333043F24419A99997927CA594133333333DF3E24410000000026CA594100000000C53E2441CDCCCC2C25CA59419A999999A73E2441CDCCCC8C24CA59419A999999873E24416666660624CA59419A999999693E24419A99999923CA5941333333334E3E24416666664623CA5941CDCCCCCC363E2441CDCCCCCC22CA5941CDCCCCCC213E24419A99993922CA594166666666073E24413333333321CA5941CDCCCCCCDD3D2441CDCCCC0C1FCA5941CDCCCCCC5C3D2441000000A017CA594133333333383D24410000008015CA5941CDCCCCCC243D24410000006014CA594133333333223D24419A99993914CA5941333333331C3D2441666666E613CA59419A999999143D24413333339313CA594166666666093D2441CDCCCC6C13CA59419A999999033D24410000008013CA594133333333D63C2441333333D310CA594100000000EE3B24416666662603CA594133333333B23B24419A999999FFC9594133333333063B24419A9999B9FBC9594100000000043B2441333333B3FBC9594166666666433A244100000020FBC959419A999999323A2441CDCCCC4CFCC9594166666666AF392441CDCCCC4CFDC959416666666699392441333333F3FDC959419A99999987392441CDCCCC4CFEC95941CDCCCCCC7F392441CDCCCC6CFBC95941333333336C39244100000080F2C95941666666660C39244100000040F4C9594166666666C83824419A999979F5C9594166666666AC382441666666A6F5C95941CDCCCCCC93382441CDCCCC0CF5C95941000000004538244100000060F2C95941000000001838244166666686F2C95941CDCCCCCCEC37244133333333F2C959419A999999B5372441333333F3F1C9594100000000A1372441000000E0F1C959419A999999A3372441333333B3F2C9594166666666A6372441CDCCCCACF3C95941CDCCCCCCA537244133333373F4C95941CDCCCCCCAB37244166666686F6C9594166666666AE37244133333393F8C9594100000000AF37244166666646FAC9594166666666AC372441000000C0FBC9594133333333A737244166666606FDC95941333333339B372441000000C0FEC95941666666669437244100000080FFC95941000000008D3724416666664600CA594100000000773724416666660602CA5941333333336B3724419A9999F901CA594133333333553724419A9999F901CA594133333333383724416666664602CA594166666666243724419A99999902CA5941CDCCCCCC1A3724419A99999902CA594100000000103724416666668602CA5941CDCCCCCCFB3624410000000002CA594133333333E73624416666668601CA5941CDCCCCCCD53624413333335301CA594133333333BD362441CDCCCC2C01CA5941000000004C3624419A9999B901CA5941666666662F362441000000E001CA59419A999999EA3524410000004002CA59419A9999997D352441CDCCCCCC02CA5941CDCCCCCC353524416666662603CA594133333333013524410000006003CA5941CDCCCCCCE3342441000000A003CA594133333333CA342441333333F303CA594166666666AA3424419A99995904CA5941333333338F342441333333D304CA59419A999999763424416666662605CA594133333333613424410000004005CA594100000000573424419A99993905CA594100000000473424416666662605CA5941CDCCCCCC083424419A9999B904CA59410000000004342441CDCCCCAC04CA594133333333E13324416666666604CA5941CDCCCCCCD23324416666664604CA5941CDCCCCCCB73324419A99991904CA59416666666694332441CDCCCC0C04CA594100000000723324416666664604CA5941333333334E3324419A9999B904CA594166666666243324413333331305CA594100000000FC3224419A99995905CA594100000000DF3224419A99997905CA59419A999999C93224410000006005CA5941CDCCCCCCB53224419A99993905CA5941000000006E3224416666664604CA5941CDCCCCCC61322441666666E603CA5941CDCCCCCC50322441CDCCCCAC03CA59419A9999993C322441666666A603CA59410000000023322441000000C003CA59410000000002322441333333B303CA594133333333E03124419A99995903CA594133333333D53124410000004003CA594166666666C6312441CDCCCC0C03CA5941CDCCCCCCB8312441CDCCCCCC02CA5941CDCCCCCCAE3124413333335302CA594133333333A03124419A9999F901CA594100000000903124419A99991902CA59419A9999996D3124419A99995902CA5941CDCCCCCC623124410000006002CA5941333333334B3124410000008002CA5941CDCCCCCC293124419A99999902CA5941CDCCCCCC12312441666666E602CA594166666666013124410000004003CA594133333333ED3024410000002003CA59419A999999D13024419A9999D902CA5941CDCCCCCCA73024413333333302CA59416666666688302441333333B301CA5941CDCCCCCC743024416666660601CA59419A999999613024419A9999F9FFC95941333333334F3024419A999919FFC959416666666631302441666666C6FDC959419A9999990E30244100000060FCC95941CDCCCCCCF52F244100000080FBC959419A999999DE2F2441CDCCCCACFAC95941CDCCCCCCA52F2441CDCCCCCCF8C9594133333333742F244166666606F7C95941CDCCCCCC5C2F244100000040F6C9594166666666432F2441CDCCCC2CFBC9594166666666292F2441CDCCCC2C00CA59419A999999152F2441000000A004CA594166666666132F24419A9999F904CA5941CDCCCCCC042F24410000008007CA59419A999999FE2E24419A9999D908CA5941CDCCCCCCFC2E24413333331309CA5941CDCCCCCCEF2E24419A9999F907CA594100000000D02E24413333335305CA594100000000AF2E24419A99991902CA59419A999999892E2441CDCCCC4CFEC95941CDCCCCCC632E24419A999999FAC95941CDCCCCCC3B2E244133333353F6C95941CDCCCCCC252E2441CDCCCCACF3C9594133333333142E2441CDCCCCACF1C95941CDCCCCCCFE2D24419A9999F9EEC9594166666666E72D244100000080ECC9594133333333CF2D2441CDCCCCACE9C9594100000000C22D24419A9999D9E7C959419A999999B82D2441CDCCCCECE5C959419A999999B12D244166666686E3C959419A999999B02D244100000020E3C9594166666666A82D24419A9999F9DFC959419A999999A32D24419A999999DDC95941CDCCCCCC9F2D2441333333F3DBC959419A9999999A2D244133333353DAC9594100000000922D2441CDCCCC8CD8C95941666666667D2D244133333333D5C9594166666666672D244133333353D1C95941333333335E2D2441000000C0CFC9594133333333552D244100000040CEC95941CDCCCCCC412D2441CDCCCCCCCAC95941000000003B2D2441000000A0C9C95941CDCCCCCC1B2E2441333333B3B5C959419A999999F32D2441333333B3B0C9594100000000E52D24419A999959AFC95941CDCCCCCCD42D2441CDCCCC6CADC9594133333333B32D244100000080A9C959419A999999882D2441CDCCCC4CA4C959419A9999997B2D2441333333B3A2C95941CDCCCCCC782D2441CDCCCCECA1C95941000000007D2D244133333333A1C959419A9999999C2D24419A9999199EC9594133333333BB2D2441CDCCCC0C9BC9594100000000C82D2441666666C699C9594133333333DA2D2441666666E697C95941CDCCCCCCE12D2441CDCCCCEC96C9594166666666E42D24410000002096C9594166666666E22E2441333333137DC95941CDCCCCCCFE2E2441333333137EC959419A9999990B2F2441000000807EC9594166666666652F2441CDCCCCAC81C9594100000000A72F2441333333F383C9594166666666BF2F2441CDCCCCCC84C95941000000000A3024413333337387C959410000000009302441CDCCCC8C86C9594100000000083024416666668685C9594100000000093024419A99995984C95941333333330C302441CDCCCCAC82C95941CDCCCCCC1C3024419A9999797CC9594100000000313024419A99997975C9594133333333383024419A9999D973C959416666666644302441CDCCCC4C6FC95941333333334D302441333333936BC959413333333354302441CDCCCC2C69C95941333333335E302441CDCCCC0C67C95941000000006E3024419A99999963C95941000000007F3024416666660660C959419A9999998B3024419A9999595DC959419A999999A9302441CDCCCCAC55C95941CDCCCCCCC2302441333333D34EC9594166666666DD3024413333337347C9594166666666E63024419A9999D944C959419A999999F03024413333339342C959410000000002312441CDCCCC2C3EC9594166666666193124410000002039C959419A999999303124419A9999F933C959413333333341312441CDCCCC0C30C959410000000055312441333333332CC9594100000000673124419A9999B928C959419A999999753124416666662626C9594100000000823124419A9999B924C95941333333338E3124410000002023C959413333333392312441666666C621C9594166666666943124410000008020C959419A9999997D312441666666A61FC95941CDCCCCCC60312441000000A01EC95941000000004B312441333333731DC95941666666662B3124419A9999F91BC959413333333312312441CDCCCC8C1AC95941CDCCCCCCFD302441000000C019C9594166666666ED3024419A99991919C95941CDCCCCCCE2302441333333B318C959416666666690302441CDCCCC6C04C95941000000007E302441333333D3FFC85941CDCCCCCC3230244166666646EDC85941333333330230244133333353E1C859419A999999822F24419A9999D9C1C85941333333339C2F2441333333D3B4C85941CDCCCCCCBE2F244166666646A3C85941666666662B2F24419A999979A6C85941CDCCCCCC792E2441CDCCCC4CAAC8594166666666862D2441CDCCCC8CAFC8594166666666702D2441333333D3ADC85941666666664B2D24419A9999F9AAC8594133333333FE2C2441333333F3A4C85941000000008D2C2441CDCCCC2C9CC8594166666666482C2441CDCCCC8C95C859419A9999993E2C2441000000A094C859419A9999992E2C2441CDCCCCAC93C859419A9999992B2C2441CDCCCC6C93C8594133333333142C24413333339391C8594166666666132C2441CDCCCC6C91C85941CDCCCCCCEB2B24413333339389C85941CDCCCCCCC62B24413333335388C8594100000000BF2A24419A99997981C85941CDCCCCCCA02A2441CDCCCCAC80C8594100000000A12A2441CDCCCCAC7FC85941000000009F2A2441CDCCCC2C74C85941CDCCCCCC9B2A24410000008068C859419A9999999B2A2441CDCCCC4C62C85941000000009D2A24413333335361C85941333333339D2A2441666666465FC85941333333338B2A2441333333535FC859419A999999F7292441CDCCCC0C60C859416666666668292441CDCCCCEC60C859419A999999242924410000002061C8594100000000162924413333335360C8594133333333F5282441333333D360C8594166666666EE282441666666E660C859419A999999792824410000008063C8594100000000422824419A99993964C859419A9999990A2824416666668663C8594100000000B82724416666666661C859419A99999983272441000000C05FC859419A99999966272441CDCCCC8C5FC8594100000000082724413333331361C85941000000009F2624419A99993963C859413333333377262441333333D363C85941CDCCCCCC42262441CDCCCCAC64C859410000000034262441666666E664C85941CDCCCCCC0E2624413333333366C85941CDCCCCCCDD252441000000E068C85941CDCCCCCCD02524419A99997969C859419A999999BC252441CDCCCC6C6AC85941CDCCCCCCA5252441666666066BC85941666666668E252441666666A66BC859413333333383252441333333F36BC859419A999999E9242441CDCCCC0C6EC8594133333333BC242441666666866EC85941000000008D242441666666066FC859410000000045242441CDCCCCCC6FC85941CDCCCCCC0E242441666666A670C859419A999999F6232441CDCCCC0C71C8594166666666D1232441666666A671C85941CDCCCCCC142324419A99995975C8594133333333122324416666666675C85941CDCCCCCCCF222441CDCCCCCC76C859419A999999B1222441666666E676C8594166666666AA222441666666A676C85941000000009E222441333333B375C8594100000000732224419A9999D971C859419A999999602224419A99993970C85941CDCCCCCC2D222441666666A66BC859419A9999991A222441666666E669C85941333333330B222441333333B368C8594100000000EB2124419A99999966C8594133333333B1212441CDCCCCEC62C859419A99999972212441333333F35EC85941666666663E212441CDCCCC4C5BC85941666666661A212441666666A658C85941CDCCCCCCF1202441666666A655C859419A999999C5202441CDCCCC4C52C85941CDCCCCCCBB202441CDCCCC8C51C85941CDCCCCCC8B202441666666A64DC859410000000066202441333333B34AC85941666666665A202441333333F349C8594166666666512024419A99999949C859419A99999939202441333333F347C85941333333332D202441CDCCCC2C47C85941CDCCCCCC22202441000000A046C859413333333310202441000000E045C859419A999999E91F24410000006044C85941CDCCCCCCB91F2441333333B342C8594100000000981F24419A99999941C85941CDCCCCCC831F24419A9999F940C8594133333333731F2441000000A040C859419A9999995A1F24416666662640C859419A999999411F2441666666E63FC85941CDCCCCCC281F2441666666C63FC8594166666666151F24410000000040C85941CDCCCCCC0A1F24410000002040C8594166666666E31E24410000008040C8594133333333B91E2441CDCCCC0C41C85941CDCCCCCC991E24419A99995941C8594133333333861E24419A9999F941C8594166666666401E2441666666A641C8594166666666F71D24419A99995940C8594100000000601D2441333333B33BC859419A9999998F1C2441666666C634C859419A999999201C24410000004031C8594166666666181B2441666666C626C85941CDCCCCCCB81A2441CDCCCC6C22C859419A9999996F1A24419A9999191FC85941CDCCCCCCD01924410000000018C8594133333333AA1924419A99999917C859419A9999997F192441333333F316C8594100000000761924410000002018C85941CDCCCCCC52192441CDCCCC4C16C8594133333333121924410000006013C8594166666666E8182441000000E010C85941CDCCCCCCB91824419A9999F90CC8594166666666841824419A99995908C85941000000004A182441CDCCCC6C03C85941CDCCCCCC471824410000004003C859419A999999F717244100000040FCC7594133333333CF1724419A9999D9F8C7594166666666A617244166666666F5C75941333333337F172441CDCCCCECF1C75941666666666B172441000000C0EFC759413333333346172441666666A6EBC75941666666663217244133333393E9C75941000000000917244133333333E5C75941CDCCCCCCBE16244133333373DDC75941CDCCCCCC5816244166666686D2C7594100000000301624419A999919CEC75941333333331D162441000000A0CCC75941666666666114244100000080C2C75941000000001A142441CDCCCC8CCAC75941666666667412244100000000B6C75941CDCCCCCCC9112441CDCCCCCCDEC75941333333333C11244133333353CAC75941333333330C11244100000020D5C75941000000000311244100000040D7C7594133333333C8102441CDCCCCCCE5C75941333333339710244133333313F1C759416666666694102441CDCCCCCCF1C75941000000007610244166666646F9C759413333333366102441333333B3FCC75941CDCCCCCC501024416666668600C85941000000004E1024419A9999D901C85941CDCCCCCC43102441CDCCCC8C04C85941666666662E1024410000006009C8594100000000131024419A9999990FC859419A9999990B1024419A9999D911C8594166666666051024413333331313C85941CDCCCCCCFD0F24413333337314C85941CDCCCCCCF20F2441000000C016C8594133333333E90F2441CDCCCC6C18C8594133333333D60F2441666666E61AC859419A999999BB0F24419A9999591EC85941000000009C0F24413333339322C8594100000000780F24413333333327C85941000000005A0F2441333333D32AC85941CDCCCCCC570F24419A9999192BC859419A9999993D0F2441666666662EC859419A999999320F2441CDCCCCEC2FC8594166666666160F24419A99997933C8594133333333FD0E2441CDCCCC6C36C85941CDCCCCCCF30E24416666668637C8594133333333E70E2441CDCCCC0C39C8594133333333C70E2441333333333DC859419A999999A50E2441CDCCCC6C41C8594133333333930E24410000000044C8594100000000840E24410000008046C85941666666666E0E2441333333B34AC859419A999999570E2441000000A04FC859419A999999440E2441666666C653C859419A9999993D0E24416666664655C85941CDCCCCCC330E24416666666657C85941CDCCCCCC1F0E24419A9999395CC8594166666666140E2441CDCCCC0C5FC8594166666666080E24413333333362C8594133333333020E24413333333364C85941CDCCCCCCFD0D2441666666A665C859419A999999FA0D2441CDCCCCAC66C859419A999999F10D24419A99997969C8594100000000E00D2441CDCCCC0C6FC8594133333333D80D2441000000A071C8594133333333D40D2441333333D372C8594100000000CE0D24416666668674C8594166666666C30D2441CDCCCC0C77C85941CDCCCCCCB30D2441666666067AC8594133333333AF0D2441CDCCCCCC7AC8594166666666A60D2441000000407CC859419A999999A20D2441666666E67CC85941CDCCCCCC8F0D2441333333937FC85941333333337C0D24410000004082C8594166666666690D24410000008084C8594133333333570D2441666666A686C8594100000000470D24410000000089C85941666666663E0D2441000000808AC8594133333333370D2441333333D38BC85941000000001E0D2441CDCCCC8C90C85941CDCCCCCC030D2441CDCCCC0C96C85941CDCCCCCCEC0C2441666666C69BC8594166666666D60C244100000080A1C8594133333333C80C24419A999999A5C85941CDCCCCCCC10C24419A9999F9A7C85941CDCCCCCCBD0C244166666606A9C8594100000000C30C244166666686ABC8594166666666BF0C24419A999939ADC85941CDCCCCCCB80C2441333333D3AEC8594133333333AB0C244166666626B2C85941000000008B0C244100000020B9C8594133333333640C244133333333C0C8594100000000390C244166666626C8C85941CDCCCCCC2F0C2441CDCCCCCCC9C8594166666666070C24419A999959D1C859419A999999D20B244133333393DBC859419A999999BA0B244133333353E1C8594133333333A60B244100000000E5C8594100000000360B244166666646F9C85941CDCCCCCC720B2441000000A029C959419A999999690B24419A9999592BC9594133333333650B2441333333332CC9594133333333620B2441000000402DC9594166666666600B2441666666862EC959419A999999560B24410000004030C95941CDCCCCCC4B0B24416666668632C9594166666666370B2441000000E037C9594100000000100B2441CDCCCC0C40C9594166666666E30A24413333333349C9594100000000B40A2441000000A051C9594166666666890A2441333333335AC95941CDCCCCCC640A2441333333F360C95941333333333E0A24419A99991968C95941000000006D0924419A9999D98EC9594133333333680924410000008091C95941	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	01010000206A080000CA8BBCC8102524419A99992928CA5941	450270000	Z	Beauchamps-sur-Huillard	4502700	45027	45	24	18
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	01010000206A08000050C5EAA45A40224100000070AFB85941	450280000	Z	Beaugency	4502800	45028	45	24	17
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	01010000206A08000064E8697BF0E12441000000A0DF9D5941	450290000	Z	Beaulieu-sur-Loire	4502900	45029	45	24	49
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	01010000206A080000228427A043102441000000C074D85941	450300000	Z	Beaune-la-Rolande	4503000	45030	45	24	21
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	01010000206A080000275144D4C0FB23413333337377CD5941	450310000	Z	Bellegarde	4503100	45031	45	24	5
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	01010000206A080000B20B88F5713825413433336304E05941	450320000	Z	Le Bignon-Mirabeau	4503200	45032	45	24	13
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	01010000206A080000450541F819142441333333F384E05941	450330000	Z	Boësses	4503300	45033	45	24	13
01060000206A08000001000000010300000001000000FC00000066666666BE1023419A9999F944C959419A9999999C112341000000E056C9594100000000D3112341000000405BC9594100000000F4112341666666E65DC959416666666617122341000000C060C9594133333333411223416666662664C9594100000000B9122341CDCCCCCC6DC9594100000000DA1223413333337370C959419A99999969132341666666067CC9594133333333A21423419A99993995C95941CDCCCCCC4E162341666666C6B7C959419A999999B716234100000080C0C959416666666669172341000000A0CDC959419A9999996F17234133333333CEC95941000000007C172341CDCCCC0CD0C95941CDCCCCCC8F172341CDCCCCECD1C959419A999999A0172341CDCCCCECD2C959413333333380182341CDCCCCECE4C95941CDCCCCCC1219234133333393F0C959419A99999976192341000000E0F6C95941CDCCCCCCB8192341666666E6FDC9594100000000FC1923419A99993902CA5941333333333A1A23416666662607CA5941CDCCCCCC851A2341CDCCCC6C0DCA594166666666E11A23419A9999B913CA59419A999999E71A23413333331315CA594166666666F01A23416666660617CA59419A999999FC1A23419A9999B919CA5941CDCCCCCCA01B2341666666263ECA594133333333BF1B23419A99995944CA5941CDCCCCCCD71B2341CDCCCCCC48CA594133333333EF1B2341333333934CCA594133333333FC1B2341000000604ECA594100000000421C2341CDCCCCAC56CA594100000000771C2341CDCCCC8C5CCA59419A999999851D2341CDCCCC4C7BCA594133333333331E23419A9999398FCA5941CDCCCCCC4C1E23419A99991992CA5941000000000C1F234166666626A8CA594133333333A01F23419A999959B9CA59419A999999B71F23419A999979BCCA59419A999999D61F23419A9999B9BFCA5941CDCCCCCC0520234166666666C4CA594133333333352023419A999999C8CA5941000000008A2023419A999919CFCA594133333333F6202341000000C0D7CA59419A99999923212341CDCCCCCCDBCA5941333333333D2123419A999979DECA5941CDCCCCCCB32123419A999999EBCA594100000000CF212341CDCCCCECEECA5941CDCCCCCCE9212341CDCCCC2CF2CA59419A999999042223419A999999EDCA5941000000001922234166666606EACA59419A9999993D2223419A999919DFCA5941000000005422234166666666D9CA5941000000005E222341000000E0D6CA5941CDCCCCCC72222341CDCCCC8CD1CA5941333333337E222341666666A6CECA5941CDCCCCCC94222341333333D3C8CA594133333333C122234166666686BBCA59413333333300232341666666E6A8CA5941666666661A23234133333373A1CA594166666666412323410000006096CA59416666666663232341666666868ECA5941CDCCCCCC7B232341000000A085CA594166666666812323419A99993984CA59419A999999AE2323413333337378CA594100000000FE2323416666668663CA59416666666626242341666666C658CA59419A99999929242341333333F357CA59419A99999954242341333333934CCA59419A999999D4232341666666863DCA59419A99999998232341CDCCCC6C32CA5941666666660A232341CDCCCCEC1ECA5941CDCCCCCC04232341333333731ECA59419A9999995E2323419A9999591DCA594100000000D1232341333333331CCA5941666666666E242341CDCCCCCC19CA59419A999999B2242341666666C618CA594166666666332523410000004016CA5941CDCCCCCC65252341666666E614CA5941CDCCCCCC872523416666668612CA594166666666BE252341333333F312CA594100000000D82523416666662613CA594166666666B32623419A9999390FCA594133333333EA27234100000060FBC959413333333330282341666666E6F6C95941000000002B292341CDCCCCCCF4C95941666666661C2A2341666666E6F3C95941000000006E2A23419A999999F3C9594133333333142B2341CDCCCC6CF2C9594166666666802B234133333393F2C95941CDCCCCCCED2B23419A999979F2C95941333333332E2C23419A9999F9F1C9594100000000702C23419A9999F9F0C959419A999999C92C234166666606EFC95941666666663B2D23419A999919EDC9594100000000BE2D2341CDCCCC4CEAC9594166666666BF2D234133333353E7C959419A999999BA2D234100000040DFC9594100000000B72D2341000000A0D9C95941CDCCCCCC8C2D2341CDCCCC0CAAC9594133333333712D2341CDCCCC0C94C95941CDCCCCCC6A2D2341666666E68FC95941CDCCCCCC612D2341CDCCCCEC8BC95941CDCCCCCC522D2341000000208AC9594166666666532D2341333333D387C9594166666666552D23419A99997980C95941CDCCCCCC582D2341000000C07AC95941000000009D2F23416666662679C95941666666667F2F23419A99991971C959416666666615302341000000005EC959413333333300302341666666265AC9594133333333902F2341CDCCCC0C4AC9594133333333402F2341CDCCCC8C3EC95941CDCCCCCC432F2341CDCCCC4C2FC95941CDCCCCCC782F2341333333D316C95941CDCCCCCC622F23410000000003C95941000000004B2F2341CDCCCC4CFAC85941000000004E2F2341CDCCCCCCF0C8594100000000542F234133333353EDC85941CDCCCCCC582F23419A9999D9EBC85941CDCCCCCC5D2F234166666646EAC8594133333333392F234166666626E1C8594133333333AA2E2341CDCCCC4CB6C85941CDCCCCCC922E234133333313B9C8594166666666782E2341CDCCCCCCBAC8594133333333632E234166666686BBC85941666666667D2C234133333393ADC85941CDCCCCCC582C2341CDCCCC6CA2C8594166666666472C23419A9999199DC85941000000000A2C2341CDCCCC8C86C859419A999999EE2B2341000000207DC859419A999999D52B23410000008075C8594166666666AB2B2341000000006BC8594166666666952B23416666666664C85941CDCCCCCC642B23410000006057C859419A999999512B23413333331352C8594166666666302B2341333333134AC859419A9999991F2B23416666660647C85941666666660D2B23416666664644C85941CDCCCCCCF62A23419A9999D941C859419A999999982A23419A9999393AC859419A999999822A23416666660638C85941333333336B2A2341000000E034C85941CDCCCCCC4C2A2341000000202FC85941CDCCCCCC2F2A2341CDCCCC2C28C859419A999999072A23419A9999B91BC8594100000000E8292341333333F30FC8594166666666D92923419A9999190BC859419A99999981292341333333B308C859419A999999FA282341000000C005C85941CDCCCCCC792823416666662603C85941CDCCCCCC402823416666662602C8594133333333B0272341CDCCCC0CFFC75941CDCCCCCC39272341CDCCCC0CFCC759416666666657262341000000C0F5C75941000000000526234166666646F3C75941000000000C252341000000E0EDC75941666666666B24234133333313ECC75941CDCCCCCCA3232341CDCCCC0CEAC75941000000009E2323419A9999B9EAC759419A99999994232341CDCCCC6CEBC759419A999999842323419A999959ECC759419A999999C822234166666666F5C759419A999999BE222341666666E6F5C75941CDCCCCCC6F222341000000E0F9C7594166666666F1212341CDCCCCECFFC7594133333333BE2123419A999979FFC75941000000009221234166666606FFC759416666666669212341000000A0FEC75941CDCCCCCCF3202341CDCCCC0CFEC7594100000000E6202341CDCCCCECFDC7594133333333D01F2341CDCCCCACFBC759419A9999997A1E234133333353F9C759419A999999191E2341CDCCCC4CF8C759419A999999361D2341CDCCCC4CF6C75941000000001B1D234100000080F5C7594166666666BA1C234133333353F1C759419A9999996D1C2341CDCCCC4CEDC7594133333333371C23419A9999D9EAC7594133333333251C2341CDCCCC6CEAC75941000000000C1C23419A999939EAC7594100000000E91B234166666646EEC7594133333333A61B234133333353E6C75941333333339F1B234133333373E5C75941CDCCCCCC781B2341666666C6DFC75941000000003F1B23419A9999F9D8C759419A9999990F1B234166666606D2C7594100000000D01A2341333333D3C6C7594166666666711A2341333333B3BAC75941CDCCCCCC441A2341666666A6B7C75941CDCCCCCC091A23419A999979B2C759410000000033192341000000809AC75941CDCCCCCC2D192341666666269BC7594133333333F9182341333333F3A0C7594166666666D2182341CDCCCC8CA6C7594166666666B2182341666666E6ABC7594133333333A1182341CDCCCC2CB0C7594166666666981823419A9999B9B0C75941666666668718234133333393B3C759419A9999997118234166666686B8C75941333333335618234166666606BEC75941CDCCCCCC4B18234166666606C0C75941000000003E182341CDCCCC4CC3C75941000000003818234133333333C5C75941000000002D182341000000E0C9C75941000000002B182341CDCCCCECCFC75941333333332D1823419A999979D8C759419A9999992A18234166666686DBC75941666666661F182341CDCCCC8CE1C75941CDCCCCCC1718234133333333E4C75941CDCCCCCCF817234133333353ECC759419A999999D117234100000080F5C75941CDCCCCCCC817234166666626F9C7594166666666C6172341666666C6FAC75941CDCCCCCCC6172341000000A0FBC7594100000000C8172341CDCCCC8CFFC7594100000000CE1723416666660605C8594133333333D5172341000000800DC8594100000000D91723413333331312C8594100000000E3172341CDCCCC8C1AC8594166666666E5172341CDCCCC2C1DC8594166666666F1172341666666862BC859419A999999FB172341000000A034C8594133333333D11723410000006036C8594133333333941723416666666638C8594166666666721723413333335339C85941666666664A172341CDCCCC2C3AC859419A99999916172341333333133BC859419A99999989162341000000203DC859419A9999996B162341CDCCCC8C3DC859410000000002162341333333F33EC8594100000000C81423410000004042C8594100000000A0142341333333F342C85941CDCCCCCC951423419A99995943C85941666666666E1423416666662645C85941CDCCCCCC511323413333339354C8594100000000301323416666666656C85941CDCCCCCCA01223419A9999195EC85941666666660C122341CDCCCCCC66C8594166666666E71123413333333369C859419A999999831323413333333397C859413333333361132341CDCCCCCC9EC859410000000045132341333333B3A5C8594166666666EC1223419A9999D9BBC8594166666666E312234166666606BEC859419A9999997D1223419A999999D6C85941666666665E12234166666686DEC859416666666693112341333333B310C9594133333333441123413333333324C9594166666666BE1023419A9999F944C95941	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	01010000206A0800005C5432392E2023413433338347C95941	450340000	Z	Boigny-sur-Bionne	4503400	45034	45	24	8
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	01010000206A080000367D8D5DA0E723413433337377D45941	450350000	Z	Boiscommun	4503500	45035	45	24	16
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	01010000206A0800009E322876B9BE24410000009079B85941	450360000	Z	Boismorand	4503600	45036	45	24	25
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	01060000206A0800000100000001030000000100000098000000CDCCCCCC39022341CDCCCCAC59EB594133333333610223410000004062EB594133333333A10223416666664672EB594100000000DC0223413333337382EB59416666666658032341333333D37EEB5941CDCCCCCC6E032341CDCCCC2C87EB59419A999999E20323419A999959B2EB59419A9999998403234100000000BBEB594133333333B5032341333333D3CEEB59419A999999D6032341000000A0DEEB5941333333330204234133333393F3EB5941000000001D042341333333D301EC5941CDCCCCCC37042341000000600FEC59416666666645042341000000A015EC5941000000004C042341333333F317EC5941CDCCCCCC7E042341666666662AEC5941CDCCCCCCD8042341CDCCCC4C48EC594100000000E70423419A99991948EC594133333333830623410000002042EC594166666666DB0623419A9999B95EEC594133333333240723419A99993976EC5941CDCCCCCC360723416666660676EC5941666666660E0823413333339375EC5941000000007F0823419A99993999EC594100000000DF0823416666662695EC5941333333330C0923419A99993993EC59416666666631092341CDCCCCAC91EC59419A9999999E092341CDCCCC0C8DEC594100000000A60923419A9999B98CEC594133333333C8092341666666468BEC59419A999999E5092341666666068AEC594166666666660A23413333339384EC5941CDCCCCCC650B234166666646A3EC5941CDCCCCCC740B234100000020A5EC594166666666500C2341000000E0C0EC594100000000E10C234133333333BCEC594133333333ED0D2341666666E6EDEC59419A999999FE0D234133333393EFEC594166666666420F2341333333D311ED594133333333FD0F2341333333332BED594133333333791023419A99997969ED5941CDCCCCCCD2102341CDCCCC8C67ED59419A99999908112341000000A085ED594133333333FE102341CDCCCCEC9EED594166666666F4102341CDCCCC2CB3ED594166666666C4112341000000E0B0ED594100000000B112234133333333AEED5941CDCCCCCCCF132341333333339EED5941666666662F152341CDCCCC8C8AED594166666666441523410000002090ED5941CDCCCCCCD9152341333333138AED5941CDCCCCCC7C172341000000408EED5941CDCCCCCCE9172341333333138FED59419A9999997B182341666666A690ED59419A9999993B1923419A99991992ED59419A99999940192341000000C08BED59413333333343192341CDCCCC4C8AED5941CDCCCCCC47192341333333B389ED594100000000CF1923413333335384ED594166666666271A2341CDCCCC4C81ED5941000000002D1A2341666666267CED59419A9999996A1A2341000000207AED594100000000EC1A2341000000C076ED5941000000004F1B23410000004075ED59419A999999AD1B2341666666C674ED594166666666E51B2341000000E074ED594100000000221C2341333333D374ED594166666666A71C2341000000A072ED594133333333301D2341000000A070ED594133333333911D2341333333736FED5941333333333F1E23419A9999B96CED594133333333D01E2341CDCCCCEC69ED5941666666663E1F23419A9999D966ED594166666666271F2341666666C659ED5941333333331E1F23419A99999953ED5941666666664D1F23416666666651ED594133333333711F23410000006050ED5941333333338E1F23410000002050ED59419A999999491F2341666666A62AED59419A999999D81E23419A9999B92AED5941666666669D1E23419A9999B92AED5941666666669C1E2341666666E626ED59419A9999998B1E2341333333F307ED59419A999999C91E23419A999979DEEC5941CDCCCCCC881E23410000000096EC59419A9999997B1C23419A999919A5EC5941CDCCCCCC5B1C2341CDCCCC4CA5EC5941CDCCCCCC671C23419A9999D992EC594166666666771C2341333333D37AEC59419A999999791C23419A9999D970EC594133333333821C2341333333D35EEC594100000000821C2341CDCCCCAC5AEC594166666666541C2341666666862BEC594166666666261C2341000000E02CEC5941000000001F1C23419A9999F928EC594133333333CA1A23416666662675EB5941CDCCCCCC691A2341666666E67AEB594100000000861923419A99995932EB59410000000053182341CDCCCCCC3AEB594133333333E6162341000000E044EB59419A999999B5162341000000202DEB594100000000C0152341CDCCCC8C30EB5941CDCCCCCCED1423410000002033EB5941CDCCCCCC5D1223416666664640EB5941CDCCCCCC820F2341CDCCCCEC4EEB594100000000130F2341333333F327EB594166666666FC0E2341666666461FEB594133333333EF0E2341666666461AEB594166666666D90E2341666666460FEB59419A9999998F0D23419A9999390EEB594100000000670D23419A9999B9D8EA5941333333333B0D2341CDCCCCECDAEA5941CDCCCCCC7D0C2341CDCCCCECE2EA594166666666350C23419A999999B1EA5941CDCCCCCC850B2341CDCCCCECB4EA5941333333334A0B2341666666068DEA594166666666FE0A2341666666664FEA594166666666020B23419A99995943EA59419A999999020B23413333337331EA5941CDCCCCCC8B092341CDCCCC8C3CEA594100000000A80623413333339355EA59410000000091062341CDCCCC4C56EA5941333333334A062341000000A058EA594100000000C90523413333337336EA59419A999999E6052341CDCCCCEC29EA594133333333E6052341666666E622EA5941CDCCCCCCDD052341CDCCCCEC18EA5941CDCCCCCCEB052341666666E617EA59410000000077052341CDCCCCCC08EA59419A99999975042341333333F316EA5941333333330A052341666666C63FEA594166666666D80423416666666641EA59419A9999993E052341CDCCCC8C74EA5941CDCCCCCCD0032341666666867FEA594166666666BE0323419A99995980EA594166666666C4022341000000C086EA5941000000008F022341CDCCCCAC90EA5941CDCCCCCC90022341666666E6A7EA59413333333391022341666666E6AEEA5941CDCCCCCC0A042341CDCCCC8CA3EA59410000000024042341CDCCCCCCA2EA5941666666663504234166666646A2EA59419A99999969042341333333B3A0EA5941CDCCCCCCA304234166666666B6EA594100000000750423419A9999F9B7EA59416666666662042341000000A0B8EA5941666666664804234100000080B9EA5941000000008F02234100000060C8EA5941CDCCCCCCB4022341CDCCCC0C04EB594166666666F1022341CDCCCCEC31EB59413333333312032341666666064FEB5941CDCCCCCC39022341CDCCCCAC59EB5941	01010000206A08000068DAC982A40F23419A9999B9D6EB5941	450370000	Z	Boisseaux	4503700	45037	45	24	7
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	01010000206A0800008EB820462BBB2341333333D362E45941	450380000	Z	Bondaroy	4503800	45038	45	24	7
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	01010000206A080000A6AC76CABEF92341CDCCCC6CD2B95941	450390000	Z	Bonnée	4503900	45039	45	24	12
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