SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep48;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep48 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep48','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep48','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep48','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep48"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000BD62FBBC58B5254100000020EA7B5841	480010000	Z	Albaret-le-Comtal	4800100	48001	48	76	30
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	01010000206A0800009C4B57606CF3254100000030B37D5841	480020000	Z	Albaret-Sainte-Marie	4800200	48002	48	76	16
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	01010000206A0800000C358AAFC80127419A9999190E5A5841	480030000	Z	Allenc	4800300	48003	48	76	39
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	01010000206A080000542AD55F6D732741000000B014505841	480040000	Z	Altier	4800400	48004	48	76	55
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	01010000206A080000DC2C0BCA17FA2541333333C31F5E5841	480050000	Z	Antrenas	4800500	48005	48	76	17
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	01060000206A0800000100000001030000000100000002010000CDCCCCCC40962541CDCCCC2CE17A58413333333351962541333333F3E57A5841CDCCCCCC7E962541CDCCCCACE77A584133333333BD96254133333373ED7A584100000000DC9625419A999919F67A584133333333149725419A999999FB7A5841000000001C9725419A999979127B58416666666646972541CDCCCC4C1D7B5841000000007A972541666666A6247B5841CDCCCCCC9D972541CDCCCC0C267B58419A999999DF972541000000C0307B5841CDCCCCCC1698254166666606377B5841CDCCCCCC3C98254100000000417B58419A999999459825419A999999487B58419A99999971982541CDCCCCAC527B58416666666603992541333333335D7B5841CDCCCCCCA2992541CDCCCCCC6D7B584166666666FD992541CDCCCCEC777B584166666666339A254166666666807B5841CDCCCCCC699A25419A999959837B5841CDCCCCCC939A25419A999999877B584133333333CB9A2541000000408A7B5841CDCCCCCC1B9B25419A9999998B7B5841000000005C9B2541CDCCCC2C8E7B584166666666A79B254166666626967B584133333333E99B2541666666E6A47B584166666666069C2541666666A6AD7B5841CDCCCCCC509C2541CDCCCC6CC07B584133333333919C2541CDCCCCACD47B5841CDCCCCCCA69C2541333333D3DE7B584100000000A99C2541000000E0E57B5841666666667D9C2541666666C6FD7B5841CDCCCCCC809C2541CDCCCC2C097C5841CDCCCCCCAA9C25419A9999190F7C584100000000FD9C254133333333157C5841CDCCCCCC1D9D2541666666661D7C5841CDCCCCCC7A9D2541000000C0267C584166666666E99D2541CDCCCCCC0A7C584100000000C09E2541000000A0BF7B584100000000239F2541CDCCCC0CB37B584166666666D69F2541CDCCCCEC957B58419A999999B69F2541333333B3927B5841333333338E9F254166666626867B5841666666665C9F2541666666C67C7B5841CDCCCCCC8C9F254100000040747B584100000000DB9F2541CDCCCC6C5C7B5841CDCCCCCCEE9F2541CDCCCCEC597B5841CDCCCCCC52A02541CDCCCC0C5B7B584133333333B7A0254133333333617B584100000000E9A02541666666E65F7B58419A99999942A12541CDCCCC8C597B5841333333339DA12541333333B3637B58419A999999F5A22541666666A6677B58413333333307A325419A999959797B58419A9999996BA3254133333333727B58419A999999D4A32541CDCCCC6C6D7B58410000000016A42541666666E6827B5841666666663AA425419A9999F98B7B58416666666668A42541666666868C7B584100000000DAA4254166666686807B58416666666648A52541666666467B7B5841CDCCCCCC92A5254133333373747B5841CDCCCCCC43A62541CDCCCCEC7D7B5841CDCCCCCC8EA72541CDCCCC8C917B58410000000011A8254166666666967B58410000000039A8254100000060967B58416666666624A82541666666E68E7B58419A999999C9A7254100000040817B5841666666668CA72541333333D36F7B5841CDCCCCCC8DA725419A999999647B584166666666D3A72541666666865F7B5841CDCCCCCCD1A72541CDCCCC0C497B58419A9999999FA725419A999919447B5841CDCCCCCC91A6254166666626437B58410000000073A62541CDCCCC2C397B584100000000CDA625419A999919397B584166666666CCA625419A9999192F7B5841CDCCCCCC70A625419A9999B9187B58419A9999992AA62541CDCCCC8C127B58416666666680A525419A9999B90D7B58410000000062A5254166666686077B58413333333375A5254100000040FC7A58410000000086A525419A999939EB7A5841CDCCCCCC83A52541CDCCCCECE57A5841CDCCCCCC9FA52541CDCCCC4CDE7A58419A999999D7A5254133333313D77A58419A999999F2A52541666666C6CF7A5841CDCCCCCC64A6254100000020C47A5841333333336BA6254133333313C17A58419A999999A7A62541333333B3BB7A58419A99999910A72541CDCCCC0CAB7A58416666666653A72541333333F3A17A5841000000007DA72541CDCCCC8C9F7A58410000000096A72541000000C0977A584133333333CEA72541CDCCCC8C907A584133333333FBA725419A999999827A58413333333315A82541000000807E7A584166666666F0A82541CDCCCC2C877A58419A99999921A92541666666A67A7A584166666666FDA92541666666667A7A584133333333F2A92541CDCCCC2C6A7A58410000000069AA254133333393587A5841000000005EAA25419A9999994A7A58410000000030AB2541CDCCCCEC3F7A58419A9999996EAB254133333333487A584100000000EFAB2541CDCCCC0C467A584166666666F6AB2541CDCCCCCC477A58419A9999995BAC25419A9999394E7A5841333333337BAC2541CDCCCCEC4C7A58416666666675AC25419A9999D90C7A5841333333331DAC2541333333D3757958416666666655AB25419A9999995C79584166666666ACAB254133333333527958419A999999E7AB25419A9999994C7958416666666653AC25416666664644795841666666669EAC2541333333733A7958416666666603AD254100000080317958413333333359AD25413333337328795841666666666AAD2541333333931679584133333333CDAD25419A999939067958416666666613AE2541666666A608795841666666669EAE254166666606FC785841CDCCCCCCB1AE254100000080F47858419A9999998EAE2541CDCCCC2CD678584100000000F8AD25419A999939E378584166666666CAAD254166666686DA7858413333333304AD2541CDCCCC6CF1785841CDCCCCCCA7AC2541000000E0E77858416666666621AC2541000000C0E0785841000000004DAC2541333333F3C17858410000000055AC25419A9999F9A3785841CDCCCCCC4AAC254100000040A078584166666666F0AB25419A9999199A785841CDCCCCCCA4AA2541666666468C7858419A99999945AA2541CDCCCC2C8C785841CDCCCCCCF6A92541000000C0917858419A9999994FA92541CDCCCC8C8B7858419A99999927A9254100000020837858419A999999E9A8254166666606797858416666666658A82541000000206B785841333333334DA82541666666466778584133333333DDA72541000000805C7858419A99999915A72541333333335F78584166666666EDA62541000000405A7858413333333343A6254133333373557858419A9999997BA52541CDCCCC8C3F7858419A9999999BA52541333333132D78584166666666CEA4254100000060267858419A999999D7A42541000000601C78584100000000C3A425416666666612785841333333333FA4254133333393F477584166666666C7A32541333333F3F577584133333333B3A325419A999939F2775841000000006BA3254133333313D3775841666666662EA3254166666626C977584100000000E3A1254166666606AE775841CDCCCCCCE2A1254166666686AB775841CDCCCCCC1DA225419A9999F99E7758419A9999991DA22541000000409B7758416666666686A12541CDCCCC2C86775841666666664CA12541333333937677584100000000BBA02541333333D3787758416666666689A025419A9999597A7758410000000057A02541000000E0817758413333333309A02541CDCCCCAC8877584133333333F79F2541666666068C77584133333333FE9F2541333333B3907758413333333324A02541666666C6967758413333333338A025419A9999D99C7758416666666659A0254133333393A0775841CDCCCCCC73A02541CDCCCCACA7775841CDCCCCCC6BA02541000000E0AD7758416666666687A02541CDCCCC6CB8775841CDCCCCCC6EA02541666666A6C37758419A99999943A02541000000A0CC77584166666666C69F2541CDCCCC0CEE775841CDCCCCCC949F2541CDCCCC6CF877584166666666719F25410000008006785841666666665C9F2541CDCCCCAC1678584100000000519F2541333333D31978584133333333059F25419A9999592278584166666666B09E2541666666462378584133333333529E2541666666C625785841CDCCCCCC119E254166666666237858419A999999C49D254166666626227858419A999999759D2541CDCCCCAC1E7858419A9999991E9D2541CDCCCCAC1C78584166666666D39C2541CDCCCC2C19785841CDCCCCCC7C9C254133333353197858419A9999995A9C2541000000401B7858419A9999994F9C25419A9999B9267858419A9999994D9C25419A99991932785841CDCCCCCC529C25419A9999D9467858419A999999459C25419A9999395978584100000000DD9B2541666666C65B78584166666666869B2541000000805B785841CDCCCCCC1A9B2541666666466078584100000000C59A25419A9999596A785841CDCCCCCC8B9A2541000000806F7858419A9999991B9A2541333333937D78584166666666E2992541CDCCCCAC8778584100000000039A2541333333F389785841000000002A9A2541CDCCCC0C9678584166666666209A2541666666A6A07858419A999999EA992541CDCCCCACB9785841CDCCCCCCE6992541333333D3C5785841CDCCCCCCF099254133333353087958419A999999FB992541333333131F79584100000000289A2541CDCCCC2C4F7958419A999999159A254100000080587958419A999999D9992541CDCCCC0C5F795841666666666A992541000000E0667958413333333330992541333333936C7958419A999999079925419A9999B976795841CDCCCCCCD79825419A9999799079584133333333DD982541000000E095795841CDCCCCCC13992541000000209E79584100000000889925419A9999F99F795841CDCCCCCC7F9A254100000080AC79584166666666979A2541000000A0AF795841CDCCCCCCAA9A254100000020B779584133333333979A2541CDCCCC4CC479584100000000689A25419A999939CD7958419A999999359A254100000080D479584133333333A399254100000000E4795841666666660999254166666606EF7958419A999999B898254100000040F3795841000000008E98254166666606FA795841333333337A98254166666666017A5841000000008698254133333393077A584166666666BB9825419A9999F9107A584100000000E0982541000000E01B7A5841CDCCCCCC6499254133333353387A584133333333F1992541000000C0517A5841CDCCCCCCFC9925419A9999B95A7A584133333333E199254100000000617A58413333333349992541000000A06A7A5841333333331C992541333333136C7A5841CDCCCCCCDF982541666666A66B7A584133333333C698254133333353677A584133333333899825419A999959667A5841666666664F982541CDCCCCAC627A58410000000025982541666666C6617A584100000000D697254166666606647A584100000000909725419A9999396A7A58419A9999995A972541CDCCCC8C727A58419A99999946972541000000E07A7A58419A9999994A972541CDCCCC8C7E7A58419A9999997397254100000040887A58410000000094972541000000409A7A58419A9999998B97254166666666A17A5841CDCCCCCC68972541CDCCCCCCAB7A58410000000007972541CDCCCC0CB67A584166666666EA962541666666A6BD7A5841666666667D96254166666686CE7A5841666666665A96254100000080D67A5841CDCCCCCC40962541CDCCCC2CE17A5841CDCCCCCC40962541CDCCCC2CE17A5841	01010000206A0800005ADD579550A32541CDCCCCDCD0795841	480070000	Z	Arzenc-d'Apcher	4800700	48007	48	76	8
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	01010000206A080000D6E0C0A39BD52641000000E0EF655841	480080000	Z	Arzenc-de-Randon	4800800	48008	48	76	70
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	01010000206A080000BA1E85AB390F2641343333334A695841	480090000	Z	Peyre en Aubrac	4800900	48009	48	76	153
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	01010000206A080000BC39A124D0192741CDCCCC3CFE705841	480100000	Z	Auroux	4801000	48010	48	76	35
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	01010000206A08000043277CEC12E8254166666676337A5841	480120000	Z	Les Monts-Verts	4801200	48012	48	76	29
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	01010000206A0800000F0518B243B326419A999909B9595841	480130000	Z	Badaroux	4801300	48013	48	76	21
01060000206A080000010000000103000000010000003B0E000000000000E3A32741CDCCCC2CF752584133333333EBA3274100000000FB5258416666666608A427410000008001535841000000001CA42741CDCCCC8C06535841000000001EA4274100000080075358410000000027A427416666664609535841CDCCCCCC3AA42741666666E60C5358416666666642A4274100000000105358419A9999993EA4274100000040145358416666666642A427419A99991916535841CDCCCCCC49A427410000008017535841000000004EA4274100000060195358419A99999952A42741CDCCCC0C1A535841CDCCCCCC5BA42741CDCCCC2C1A5358410000000075A42741666666061A535841CDCCCCCC82A42741CDCCCC8C1A535841000000008DA42741333333331B535841CDCCCCCC9AA42741000000A01B53584100000000A6A42741333333131B53584133333333B4A42741666666A61A53584100000000C2A42741000000E01A53584100000000CBA42741333333531B53584133333333CEA42741000000201C53584166666666D9A42741CDCCCCCC1C5358419A999999E7A427419A9999591D535841CDCCCCCCF0A42741666666E61D5358419A999999F4A427419A9999D91F5358419A999999F7A427419A9999D9225358413333333300A527419A99997925535841CDCCCCCC09A527419A9999392A535841CDCCCCCC04A52741666666A62E535841CDCCCCCC01A527419A99993932535841666666660AA52741CDCCCC6C355358416666666616A527416666664637535841CDCCCCCC1DA52741000000E0375358413333333337A52741CDCCCC6C385358413333333346A52741CDCCCCAC385358419A9999994EA52741333333D3385358410000000068A52741000000803A5358416666666673A52741CDCCCCAC3C5358413333333385A52741666666E63E535841CDCCCCCC94A52741666666A641535841000000009DA52741CDCCCCAC4353584166666666AAA52741666666464553584133333333B4A527419A9999D94553584133333333BFA527416666662647535841CDCCCCCCC6A52741CDCCCCEC4953584100000000E0A52741333333934C53584100000000F1A527419A9999394E53584133333333FBA527416666664650535841666666660DA62741CDCCCCCC515358410000000015A6274133333393525358416666666620A6274100000020525358419A99999927A627419A999919525358419A99999933A62741333333F3525358419A99999939A627413333331354535841666666663EA6274133333373545358416666666648A6274166666686545358419A99999951A627410000006054535841CDCCCCCC55A627416666664655535841CDCCCCCC52A62741666666065A5358416666666656A62741000000E05A535841333333335CA62741000000005C5358419A99999970A62741CDCCCC4C5E5358419A99999978A62741000000A060535841CDCCCCCC7FA627410000000062535841CDCCCCCC8AA627413333337363535841000000008DA627413333339364535841000000008BA627419A999999665358419A99999988A62741333333D367535841CDCCCCCC8BA62741CDCCCCCC685358416666666695A627419A9999996953584166666666A4A62741333333B36B535841CDCCCCCCA9A627419A9999D96C5358419A999999BBA62741666666E66F535841CDCCCCCCBCA627419A9999B97253584100000000BBA627419A99997974535841CDCCCCCCB9A627419A9999F975535841CDCCCCCCC4A62741333333F377535841CDCCCCCCCFA62741666666E67853584133333333E7A627419A9999F97953584166666666F3A62741333333B37A5358410000000000A727419A9999D97B5358419A9999991AA72741666666067C5358410000000026A727419A9999F97B5358413333333330A72741000000407B535841000000003FA72741666666A67B535841000000004DA72741333333F37C535841CDCCCCCC55A72741666666267E5358419A99999958A727416666660680535841CDCCCCCC61A727419A999959825358416666666668A727413333331383535841333333336DA727419A9999F9835358410000000077A7274166666606865358416666666673A72741CDCCCCAC875358410000000070A7274133333353895358413333333372A72741000000C0895358410000000081A727419A9999198B5358410000000088A72741333333F38B535841000000008FA72741CDCCCCAC905358416666666692A727419A9999B9915358416666666694A72741CDCCCC0C935358410000000094A72741000000E094535841CDCCCCCC91A72741333333B3965358416666666693A727419A9999B9985358416666666690A72741333333539A5358413333333388A72741CDCCCC4C9B5358416666666680A727419A9999599D5358419A99999970A7274133333333A25358419A9999996AA727419A9999D9A35358419A99999960A72741666666A6A5535841CDCCCCCC57A72741CDCCCC4CA75358419A99999956A727419A9999B9A95358416666666659A72741666666E6AB5358419A99999951A727419A9999B9AD5358413333333346A72741CDCCCC0CB05358416666666645A7274133333373B1535841333333334CA72741CDCCCCECB45358416666666650A72741CDCCCCCCB85358413333333355A727419A999979BC5358419A99999956A7274133333313C05358410000000060A72741333333D3C6535841666666665BA7274133333313C9535841CDCCCCCC59A7274100000060C95358416666666648A727419A9999B9CC535841666666663AA72741CDCCCC0CD05358413333333337A72741333333D3D1535841CDCCCCCC35A72741CDCCCCECD45358410000000054A72741000000A0D85358410000000064A92741666666E6ED535841666666662FAA2741666666A6F55358419A9999996BAA27419A9999F9F75358419A999999E5AA274100000020FC53584100000000BEAA2741000000A0215458416666666670AB2741CDCCCC8C41545841333333335AAC2741000000809254584100000000A5AC2741000000E0A65458416666666691AC274166666606AB5458419A9999997DAC274166666646B0545841CDCCCCCC66AC274133333373B55458410000000042AC274133333313BD5458410000000027AC274100000080C2545841CDCCCCCC1CAC274166666606C6545841CDCCCCCC14AC2741666666C6C95458419A9999990EAC2741CDCCCC8CCC545841CDCCCCCCFFAB2741666666A6D1545841CDCCCCCCEAAB2741666666A6D854584100000000DAAB2741CDCCCCCCDE54584166666666CAAB27419A9999F9E3545841CDCCCCCCB3AB274166666646EB54584100000000A2AB2741CDCCCC6CF15458416666666694AB27419A9999D9F55458419A9999998FAB2741CDCCCC2CF75458419A99999989AB2741CDCCCCECF8545841CDCCCCCC7EAB274166666666FB545841666666666FAB27419A999999FE5458419A99999956AB2741CDCCCCCC03555841666666663BAB274133333393095558410000000023AB2741333333730E555841CDCCCCCCFCAA2741666666E61555584133333333E2AA2741CDCCCC8C1B55584166666666C4AA2741CDCCCCAC2255584166666666A4AA27419A9999592A555841CDCCCCCC8CAA27416666660630555841333333337AAA274133333393345558413333333365AA2741CDCCCC4C395558419A99999954AA2741333333933D555841333333337CAA2741333333F33A55584166666666BEAA2741666666E636555841CDCCCCCCEBAA27410000006034555841000000001DAB27410000002032555841333333334DAB27410000006030555841333333337BAB2741333333F32E555841CDCCCCCCAEAB2741000000602D55584100000000D6AB27419A9999D92B5558419A999999E4AB2741333333132B5558410000000009AC2741666666862B5558413333333322AC2741CDCCCC2C2C555841000000004BAC2741CDCCCCEC2D5558413333333386AC27410000008030555841CDCCCCCCC8AC274166666626335558416666666626AD2741CDCCCCCC375558419A99999937AD27419A9999B9385558410000000050AD2741333333F3395558419A9999995BAD2741CDCCCC4C3A555841CDCCCCCC6EAD2741666666663A555841000000008DAD2741CDCCCCCC39555841CDCCCCCCAEAD2741666666863955584100000000DAAD2741CDCCCCAC395558410000000004AE2741333333533A555841CDCCCCCC28AE2741666666663B555841333333333DAE2741333333F33B555841CDCCCCCC4FAE27419A9999D93C5558410000000080AE27419A9999D93F55584133333333A9AE27419A9999394255584100000000C9AE274133333373445558419A999999E1AE2741CDCCCC0C4655584133333333E9AE274166666666465558419A999999F8AE274133333313475558419A99999918AF2741333333F348555841CDCCCCCC4BAF2741CDCCCCEC4A5558413333333375AF2741000000204D55584166666666CFAF2741666666E64F55584100000000E4AF2741000000205055584100000000FFAF27416666662650555841666666661DB027419A99997950555841CDCCCCCC39B02741CDCCCC6C515558413333333355B0274133333313535558413333333370B0274100000040555558419A99999996B027416666660659555841CDCCCCCCBFB027419A9999395C55584133333333EAB02741333333F35E5558419A99999911B12741333333B360555841CDCCCCCC22B127410000004061555841CDCCCCCC36B12741CDCCCCCC64555841666666664EB127419A9999F9695558416666666665B12741000000206F555841CDCCCCCC73B127419A99997972555841666666667FB12741CDCCCC2C77555841CDCCCCCC91B12741333333938055584133333333A4B12741000000A08A555841CDCCCCCCB1B12741CDCCCC6C9055584166666666C2B12741CDCCCC2C9755584100000000D9B1274166666606A255584133333333F3B12741CDCCCCACAD555841333333330CB22741333333B3B8555841CDCCCCCC39B2274133333333CC555841333333334DB22741CDCCCC0CD15558413333333371B2274100000060D055584133333333B4B22741CDCCCC4CCE55584133333333EFB2274100000000CC555841666666662DB32741000000C0C95558419A99999963B327419A999939C8555841000000008DB327419A999999C855584166666666DCB32741333333B3C95558419A9999991AB4274100000060CB5558416666666649B4274133333313CD555841CDCCCCCC82B42741CDCCCC8CCE5558419A999999B0B4274166666646CE5558416666666628B5274100000020CD555841666666668CB5274166666606CD5558419A999999E6B52741CDCCCCACD055584100000000E7B52741CDCCCCECD655584166666666CAB52741CDCCCCECEA5558419A99999999B527419A999979FC555841000000007CB52741000000C002565841333333337CB5274100000040055658419A99999968B52741000000400A565841CDCCCCCC05B527419A999959195658419A999999CCB42741666666262E56584100000000ACB42741333333B32E5658416666666691B4274166666606315658416666666662B42741CDCCCC0C335658410000000030B42741666666E6355658419A99999916B4274100000040395658419A999999F9B32741666666E63C565841CDCCCCCCDFB32741CDCCCC2C42565841CDCCCCCCB8B32741333333734A56584100000000A2B3274166666626555658413333333388B32741333333F35D5658419A99999985B32741CDCCCCEC605658416666666642B3274100000020695658416666666634B327413333331369565841000000001AB327413333339369565841CDCCCCCC05B32741333333B369565841CDCCCCCCFCB227416666664669565841CDCCCCCCEEB227419A9999596956584133333333E7B22741CDCCCC2C6A565841CDCCCCCCD1B22741666666266B56584133333333BDB22741666666866B5658419A999999A4B22741333333536B5658419A9999998DB22741CDCCCCCC6B5658419A99999975B227419A9999596D565841CDCCCCCC67B227419A9999396F565841666666665BB2274166666646715658419A9999994CB2274100000020745658419A99999940B22741CDCCCC2C78565841CDCCCCCC3EB22741666666C67A565841CDCCCCCC3CB22741333333F37B565841CDCCCCCC39B22741666666C67D5658416666666635B22741CDCCCC2C81565841000000002EB2274100000040835658410000000027B227419A99997984565841CDCCCCCC18B2274166666686855658419A99999910B22741CDCCCCEC86565841666666660AB22741000000C08756584166666666FEB12741333333B38756584100000000F4B12741000000608756584133333333E3B127416666662688565841CDCCCCCCD0B127419A9999D98756584100000000BCB12741000000608756584166666666ACB127419A9999398756584166666666A2B1274166666686865658413333333394B127419A9999B9855658413333333381B12741CDCCCCCC84565841CDCCCCCC6EB127419A999959835658419A99999959B12741333333D3825658410000000048B127416666666682565841000000003AB127419A999959825658419A9999992BB12741CDCCCC0C81565841CDCCCCCC21B1274100000060805658416666666622B12741333333537F5658419A99999925B12741000000207D5658416666666624B12741CDCCCC4C7A565841333333331EB127419A999959785658413333333318B1274133333373775658416666666611B12741000000A0765658419A9999990BB12741000000607356584133333333F8B0274100000060715658419A999999E0B027419A9999D9705658419A999999C1B02741333333F37256584166666666A6B02741666666A6765658413333333378B02741000000A07A5658419A9999994DB02741333333537D565841CDCCCCCC18B02741CDCCCC4C7E56584100000000D3AF2741000000407E56584166666666A5AF2741333333D37C565841666666667FAF2741333333D379565841333333335BAF2741CDCCCC0C765658419A99999936AF27419A99995973565841CDCCCCCC1AAF27419A9999197256584100000000FEAE2741CDCCCC8C725658419A999999E2AE2741CDCCCC8C6F56584166666666CEAE2741333333536C5658419A999999CDAE2741CDCCCC8C67565841CDCCCCCCC7AE2741000000406556584133333333B0AE274133333393635658416666666688AE2741000000C062565841CDCCCCCC5CAE274133333373625658410000000040AE27419A99999960565841CDCCCCCC26AE27419A9999995C565841CDCCCCCC12AE2741000000A05B56584133333333F1AD2741333333F35C56584166666666D6AD2741666666265F56584100000000B3AD274166666626645658416666666699AD27419A999979685658413333333371AD2741666666666F5658410000000051AD274100000000765658413333333338AD2741000000E07B5658416666666623AD2741CDCCCC6C805658419A9999990EAD274133333373845658413333333311AD274100000040855658410000000028AD2741333333D38B565841000000003EAD27419A9999D990565841CDCCCCCC55AD2741CDCCCC0C975658410000000056AD2741000000809D565841000000004CAD274166666666A4565841000000003EAD2741CDCCCC8CA8565841333333333DAD274100000020AF565841000000004EAD2741CDCCCC6CB7565841CDCCCCCC54AD2741333333B3BB565841CDCCCCCC5AAD2741CDCCCC8CC0565841666666665CAD2741CDCCCC8CC65658416666666658AD2741000000E0CA565841666666664BAD2741CDCCCC2CD2565841333333333BAD2741CDCCCC6CD65658419A9999992FAD274100000000DD5658419A9999992CAD2741CDCCCC6CE4565841CDCCCCCC33AD2741000000A0EB5658416666666632AD27419A9999D9F25658413333333326AD2741000000C0F7565841CDCCCCCC28AD27419A999999FA5658410000000034AD2741666666C601575841333333332BAD2741CDCCCC6C085758419A99999917AD2741000000A01057584133333333FBAC27419A99999914575841CDCCCCCCE6AC27419A9999391C57584100000000E9AC2741666666662657584100000000F0AC27419A9999D93357584100000000EFAC2741666666E6395758419A999999D9AC2741000000603D575841CDCCCCCCD0AC2741000000E04057584166666666DBAC27419A999999455758419A999999E4AC27419A9999D94A575841CDCCCCCCD7AC2741666666E65057584166666666C4AC2741000000C0555758419A999999ABAC2741CDCCCC8C5E57584100000000AAAC2741CDCCCCEC6557584133333333B0AC2741333333736D57584100000000A7AC2741666666C6735758416666666692AC27419A999979775758419A99999990AC2741666666267E5758416666666691AC27419A9999D9855758410000000091AC2741000000608D5758413333333381AC2741333333B3965758419A9999997EAC27419A9999399E575841CDCCCCCC77AC2741333333F3A55758419A99999970AC2741CDCCCCACAE5758419A9999992AAC2741CDCCCCCCB35758416666666615AC2741CDCCCCACBE57584100000000F4AB27419A999979D5575841666666660BAC274100000000D6575841CDCCCCCC45AC2741CDCCCCACD7575841CDCCCCCC93AC274100000040DA5758419A999999A2AC27419A9999D9DA57584100000000A4AC2741666666E6DA5758419A999999CDAC2741CDCCCC2CDD57584133333333DBAC2741666666E6DD5758419A999999F3AC2741333333F3DE575841CDCCCCCC01AD2741CDCCCC6CDF5758410000000024AD27419A999999DF5758419A99999942AD27419A9999F9DF5758419A99999955AD27419A999999E05758410000000019AD274100000080EF5758419A9999999FAC2741666666A6045858416666666643AC2741CDCCCC8C0B585841CDCCCCCCFEAB27416666662614585841CDCCCCCCE2AB2741CDCCCCEC1C58584166666666D1AB27419A999939225858419A999999C3AB27419A9999D92758584100000000B9AB2741CDCCCCEC2B58584166666666B5AB27413333335331585841CDCCCCCCB3AB2741CDCCCCCC34585841CDCCCCCCA7AB27410000004038585841666666669AAB2741333333733C5858410000000096AB2741CDCCCC0C415858419A99999991AB2741CDCCCCCC47585841666666668AAB2741000000804E5858419A99999987AB2741CDCCCC4C555858410000000080AB2741CDCCCCCC5B585841000000007FAB2741CDCCCC2C61585841CDCCCCCC77AB274100000080675858419A99999974AB2741666666A66B585841CDCCCCCC6AAB2741CDCCCC8C6F5858410000000065AB27419A99997972585841CDCCCCCC59AB2741CDCCCC2C75585841CDCCCCCC59AB2741333333B3785858416666666657AB2741000000607B585841000000004EAB2741666666067F585841CDCCCCCC41AB27419A99995983585841333333332CAB274166666666875858419A9999990FAB2741333333138D5858416666666601AB27419A9999998F58584133333333E9AA2741CDCCCC8C9558584133333333F7AA2741000000809958584100000000FCAA2741CDCCCC4C9E5858410000000005AB27419A999919A0585841CDCCCCCC11AB27419A9999B9A05858416666666628AB2741CDCCCCACA05858416666666640AB27419A9999F9A05858413333333352AB274100000080A25858419A9999995EAB27419A9999F9A45858410000000070AB274100000060AB585841333333336FAB274133333373AC5858419A9999996AAB274166666626AE5858419A99999969AB2741CDCCCC0CB05858413333333369AB2741000000A0B15858419A9999995BAB2741000000C0B45858416666666645AB274100000060B8585841CDCCCCCC2AAB2741CDCCCC4CBA585841666666661AAB274166666686BD585841666666660CAB274100000020C058584166666666E6AA2741CDCCCC6CC558584100000000CBAA274133333393C858584100000000BEAA27419A999979CB58584100000000A3AA2741000000C0D1585841CDCCCCCCA0AA274133333313D558584166666666A2AA2741333333D3D958584100000000A4AA274166666646DE58584133333333A4AA27419A999959E15858413333333398AA274166666626E45858419A99999987AA27419A999979E55858419A99999977AA2741CDCCCC6CE5585841666666666AAA2741666666C6E55858413333333364AA274100000020E8585841CDCCCCCC56AA2741666666E6E75858419A99999939AA274166666606EA5858410000000034AA2741CDCCCC6CEB585841CDCCCCCC2DAA274166666626EC5858410000000027AA274100000040EE585841CDCCCCCC20AA2741333333F3EF5858419A99999920AA2741CDCCCC0CF1585841666666662EAA2741CDCCCC8CF2585841CDCCCCCC4AAA2741333333B3F35858419A9999995FAA274133333373F5585841333333337CAA274133333393F9585841CDCCCCCC89AA274100000020FC5858416666666697AA274100000040FF5858416666666698AA2741666666E6005958416666666696AA27410000002006595841666666668CAA2741666666A608595841666666668FAA2741CDCCCCCC0B5958413333333390AA27413333337311595841000000008FAA27419A99993915595841CDCCCCCC88AA274166666606185958416666666689AA2741333333D31A5958410000000088AA2741666666661D5958419A9999997CAA2741CDCCCC4C1F595841000000006FAA274100000040235958413333333370AA27410000000026595841CDCCCCCC6DAA2741666666A6295958413333333366AA2741CDCCCC4C2C5958413333333359AA2741CDCCCCAC2F5958419A99999957AA27413333333332595841333333335DAA2741CDCCCCCC345958419A99999960AA27419A999919365958416666666673AA2741CDCCCC0C385958419A9999998BAA2741CDCCCC2C395958419A99999996AA27419A9999393B595841333333339BAA2741CDCCCC8C3D595841333333339FAA2741333333733F59584133333333B2AA2741000000C04059584100000000B9AA2741666666464259584166666666C5AA27419A9999B94359584166666666CEAA27413333331345595841CDCCCCCCD9AA2741CDCCCC2C4659584100000000E6AA2741CDCCCCEC475958419A999999EDAA2741000000804959584133333333F1AA27419A9999B94B5958419A999999F6AA2741CDCCCC4C4D5958413333333300AB2741666666464E5958416666666612AB2741333333734E5958410000000022AB2741000000404E5958419A99999931AB2741000000C04E595841000000003DAB2741000000804F595841000000004DAB27416666662650595841CDCCCCCC61AB2741CDCCCC0C50595841CDCCCCCC78AB2741CDCCCCAC4F595841000000008FAB2741CDCCCC0C4F595841CDCCCCCC98AB2741CDCCCC2C4F59584100000000ADAB27419A9999195059584133333333BAAB2741333333535159584133333333C2AB2741000000205359584133333333CAAB2741000000A05459584166666666DBAB2741CDCCCC4C5559584133333333EAAB27410000004056595841CDCCCCCCFEAB2741CDCCCC2C565958419A99999923AC2741CDCCCC0C555958413333333339AC274133333353535958410000000050AC2741333333D3515958410000000061AC2741666666E6515958419A9999996FAC274133333373525958410000000087AC274100000060535958419A999999A4AC27419A999979545958419A999999BDAC2741666666A65559584100000000D3AC27410000000056595841CDCCCCCCE7AC2741666666E6555958419A999999F8AC2741CDCCCCEC55595841CDCCCCCC0AAD27416666668655595841000000001CAD274133333353545958416666666632AD2741000000E0535958419A9999993FAD2741CDCCCC0C535958410000000055AD2741000000C0515958416666666661AD274133333393505958413333333375AD2741666666864E595841CDCCCCCC8DAD2741666666064C595841666666669CAD2741666666A64A5958419A999999AAAD2741000000804959584133333333BBAD2741CDCCCCCC4759584133333333CFAD2741666666464659584166666666DFAD274133333393455958419A999999EDAD2741CDCCCC2C455958416666666605AE2741CDCCCCCC435958419A9999990FAE274133333373425958416666666617AE274166666646415958419A99999923AE274133333353405958413333333331AE2741CDCCCC2C405958410000000053AE27413333337340595841333333335EAE27419A9999F93F5958419A9999996CAE2741666666E63D5958419A99999975AE2741333333B33A5958419A99999979AE2741000000C0375958416666666683AE27419A999939355958413333333389AE2741CDCCCC8C335958419A9999998AAE2741CDCCCC2C325958419A99999990AE27419A9999D93059584166666666A0AE2741CDCCCC4C2F59584133333333B4AE27419A9999F92C5958419A999999E1AE2741CDCCCC8C2759584133333333F9AE27419A999939245958413333333316AF2741CDCCCC2C205958419A9999992FAF27419A9999B91D5958416666666654AF2741333333F31B595841CDCCCCCC7CAF27419A9999D9195958419A9999999EAF2741CDCCCCCC18595841CDCCCCCCB3AF2741CDCCCC4C17595841CDCCCCCCC2AF2741333333931659584166666666E1AF274100000000175958410000000012B02741CDCCCC2C18595841CDCCCCCC35B027419A99997918595841666666665BB02741666666E6165958410000000082B027410000006015595841666666669CB027419A9999391359584166666666B8B02741000000001059584100000000DDB02741333333530D59584166666666FCB02741CDCCCC0C0B5958413333333308B127419A9999B909595841666666662CB12741CDCCCC0C085958410000000031B12741000000C007595841CDCCCCCCCFB127419A999999FD5858413333333385B22741333333B3FC58584166666666FAB2274100000020FC5858419A9999991FB427419A999999FB5858416666666636B4274133333313EE585841333333333BB4274166666646EA5858419A9999994AB42741CDCCCCCCE85858410000000062B42741000000A0E65858416666666654B42741000000A0D95858419A99999954B42741666666A6D45858413333333354B4274100000080D1585841CDCCCCCC51B4274166666686CE5858413333333353B4274100000040CB5858413333333357B42741CDCCCC2CC7585841666666665CB4274133333353C35858419A99999968B42741CDCCCC6CC05858410000000069B427419A999919C0585841666666666DB42741CDCCCCACBD585841333333338DB42741CDCCCCECBA585841CDCCCCCCA3B42741000000A0B858584133333333AFB4274100000020B758584100000000C8B42741666666C6B4585841CDCCCCCCD4B4274100000000B35858419A999999DCB42741000000C0B158584100000000EAB4274166666686B058584133333333F8B42741CDCCCCACAF5858410000000008B52741CDCCCC8CAE585841000000001FB52741333333F3AC5858416666666633B5274133333353AB5858410000000048B527419A999979A9585841CDCCCCCC59B527419A999919A8585841666666666FB5274166666666A6585841CDCCCCCC81B52741666666C6A45858410000000095B52741000000A0A358584166666666A9B5274166666626A258584133333333BFB5274133333373A058584100000000D3B52741333333F39E58584100000000E3B52741000000609D58584100000000F2B52741CDCCCCAC9B585841CDCCCCCCFEB52741CDCCCC6C9A5858413333333306B62741CDCCCCCC995858416666666614B6274133333393985858419A99999930B6274166666626965858419A99999932B62741CDCCCC0C96585841666666663BB62741333333B395585841000000004CB627419A999979945858413333333353B62741333333F3935858410000000058B627410000008093585841000000005CB627419A9999D992585841CDCCCCCC5EB62741CDCCCC2C925858419A99999960B6274100000080915858413333333362B627413333337390585841CDCCCCCC65B62741000000208E58584166666666A2B62741333333F38058584133333333A6B627419A9999997F5858419A999999A6B62741000000407F58584133333333A7B627419A9999D97E58584100000000ABB62741666666867C58584166666666B2B62741CDCCCCEC7858584133333333B8B62741000000C07658584100000000BDB627419A9999B974585841CDCCCCCCC1B62741000000A07258584166666666C6B62741666666C67058584166666666C7B627419A9999396F58584166666666C8B62741000000806D585841CDCCCCCCCCB62741333333136A585841CDCCCCCCD0B62741333333736758584133333333CEB62741333333F36458584133333333CBB627413333333363585841CDCCCCCCCAB627419A9999796158584166666666CAB62741CDCCCCEC5F58584166666666CAB627419A9999795C58584100000000CCB62741000000C057585841CDCCCCCCCBB62741CDCCCC8C51585841CDCCCCCCCCB62741666666E64C585841CDCCCCCCDCB627416666664648585841CDCCCCCCF6B62741333333B342585841CDCCCCCC04B727419A9999B93F5858419A9999990BB727419A9999593E5858419A9999990FB72741333333933D5858419A99999922B72741CDCCCCCC39585841000000002FB727419A9999D9365858413333333334B727419A99993935585841CDCCCCCC39B727419A9999D9335858419A99999940B72741000000A032585841666666664FB727416666664630585841000000005FB727419A9999592D5858410000000076B72741666666262A5858416666666687B727419A99991927585841CDCCCCCC94B72741CDCCCCCC24585841CDCCCCCCA1B72741CDCCCCEC215858419A999999ACB72741CDCCCC0C1F585841CDCCCCCCB2B72741CDCCCC0C1D58584133333333B7B72741666666861B585841CDCCCCCCB9B72741666666661A58584166666666BAB72741000000201958584133333333BAB72741666666261858584133333333B2B72741000000E014585841CDCCCCCCABB727419A99997913585841666666669DB727410000004011585841CDCCCCCC8DB72741CDCCCC4C105858413333333387B727410000006010585841CDCCCCCC7FB72741333333B310585841000000007CB72741666666E610585841CDCCCCCC6FB72741333333F3105858413333333362B727419A9999B910585841000000005AB7274100000000105858419A9999994DB72741000000C00D5858410000000043B72741666666A60C585841333333333DB72741666666460C5858413333333329B72741000000C00C585841000000001AB72741CDCCCC0C0D5858413333333305B72741000000200C58584100000000FEB62741666666460B58584133333333F9B62741666666060B58584133333333F0B62741666666860B58584166666666E9B62741CDCCCCAC0C58584133333333E4B62741666666060D5858419A999999DCB62741000000E00C585841CDCCCCCCD5B62741CDCCCC4C0C58584133333333CDB62741000000800B585841CDCCCCCCC9B62741666666860A58584166666666C8B62741CDCCCCAC08585841CDCCCCCCCAB62741333333130758584133333333CDB62741333333530558584133333333CFB627419A9999D90358584133333333D1B627419A999959025858419A999999D4B62741CDCCCCACFF575841CDCCCCCCE2B6274133333373FD57584166666666E9B62741666666C6FC5758416666666607B7274100000080FA575841333333333DB72741666666A6F45758413333333346B72741CDCCCCECF35758410000000053B727419A999919F3575841000000005CB72741000000A0F2575841CDCCCCCC65B7274133333313F2575841CDCCCCCC70B72741CDCCCC8CF15758419A9999997BB7274100000020F1575841CDCCCCCC84B72741CDCCCCACF0575841000000008DB7274100000040F05758416666666694B7274100000040F05758419A9999999DB7274166666686F05758419A999999A5B72741333333D3F057584133333333B1B72741666666E6F05758419A999999BCB72741000000E0F057584133333333CCB727419A999999F057584166666666D6B7274166666646F0575841CDCCCCCCE0B72741CDCCCCACEF5758416666666601B82741CDCCCCCCEC5758419A9999990CB82741000000A0EB575841333333331AB8274166666626EA5758413333333324B8274133333353E95758416666666638B82741666666E6E75758413333333347B827419A999979E6575841CDCCCCCC4DB8274133333333E4575841666666664EB8274166666606E35758410000000050B82741000000A0E15758413333333352B82741000000A0DE5758413333333358B82741CDCCCC2CDC575841CDCCCCCC5BB8274100000060D95758410000000056B8274133333333D85758413333333351B8274133333353D75758413333333346B8274166666666D6575841000000003BB827419A9999F9D5575841CDCCCCCC34B82741333333F3D55758416666666633B82741333333F3D55758410000000023B82741666666C6D6575841CDCCCCCC11B827419A9999D9D557584166666666F8B727419A999939D35758419A999999E7B727419A9999B9D157584133333333DBB72741CDCCCC2CD15758419A999999CAB72741CDCCCC6CD0575841CDCCCCCCBEB72741CDCCCC0CCF5758419A999999B2B72741666666A6CD57584100000000ABB727419A999979CC57584100000000A4B7274133333373CB575841333333339AB72741333333D3C95758419A99999997B7274166666646C8575841CDCCCCCC9BB727419A999919C7575841666666669CB727419A9999F9C6575841333333339FB7274133333313C657584133333333A5B727419A9999F9C457584133333333AEB7274133333313C45758419A999999BBB72741CDCCCCECC257584166666666CEB72741333333F3C0575841CDCCCCCCE3B7274100000000BF57584100000000F0B7274166666666BE57584166666666FCB72741CDCCCC4CBD5758413333333306B82741CDCCCC4CBC575841666666660EB82741000000E0BA575841333333331BB8274166666646B85758416666666629B82741CDCCCC6CB7575841CDCCCCCC33B82741CDCCCCCCB6575841CDCCCCCC35B827419A9999B9B65758419A99999948B8274133333373B55758416666666671B82741CDCCCCECB25758416666666698B82741CDCCCCACAF5758419A999999ACB82741666666A6AE57584100000000D9B82741CDCCCC2CAC57584166666666EDB8274166666686AA57584133333333FFB82741666666A6A8575841000000001DB927419A999959A65758419A99999935B9274100000080A45758419A99999949B92741333333D3A1575841CDCCCCCC59B92741666666A69F5758416666666674B92741333333F39B5758416666666690B92741666666C697575841666666669CB92741CDCCCC6C955758419A999999A3B92741000000609357584100000000AAB92741CDCCCC2C9157584133333333B7B92741CDCCCC4C8E57584133333333C3B92741333333738C57584166666666C9B927410000004089575841CDCCCCCCCEB927419A9999B98757584133333333DFB92741333333D38557584100000000EBB92741666666E68357584166666666F6B9274133333353825758410000000004BA2741CDCCCCAC7F5758416666666625BA27419A99995979575841CDCCCCCC30BA27410000000077575841000000003EBA2741CDCCCCAC745758413333333355BA2741CDCCCC4C715758419A99999969BA2741CDCCCC8C6E5758410000000075BA27419A9999F96C5758413333333388BA27419A9999596A575841CDCCCCCC97BA2741333333936857584133333333A1BA2741CDCCCC6C6757584100000000ACBA2741000000206657584166666666BABA2741CDCCCCAC6457584100000000CCBA2741666666866357584100000000DCBA2741000000E062575841CDCCCCCCE5BA2741333333936257584100000000F1BA27419A9999B96257584100000000FCBA27416666662663575841CDCCCCCC07BB2741CDCCCC6C635758416666666613BB27419A999959635758419A9999991EBB27419A99997963575841333333332DBB27419A9999D963575841CDCCCCCC3CBB2741666666C6645758416666666651BB2741000000C066575841CDCCCCCC66BB2741CDCCCCEC665758419A9999997ABB27413333333366575841CDCCCCCC8CBB2741CDCCCCAC65575841CDCCCCCC9EBB2741333333336557584166666666A6BB2741000000206557584100000000BEBB2741333333F36457584166666666DDBB2741000000606457584100000000F0BB2741CDCCCCEC6357584133333333FBBB2741CDCCCC6C635758413333333304BC2741333333D362575841666666660EBC2741CDCCCC0C62575841000000001DBC27413333335361575841666666662DBC2741CDCCCC4C605758410000000037BC27419A99993960575841000000003CBC2741000000A05F5758416666666641BC2741666666465F575841CDCCCCCC48BC27419A9999D95E5758416666666650BC2741666666E65E5758416666666658BC2741CDCCCC6C5F5758419A99999961BC2741666666A65E5758413333333367BC2741CDCCCC8C5D575841666666666EBC27419A9999795C5758410000000074BC2741333333B35B575841666666667DBC2741000000A05B5758410000000089BC2741333333935B5758416666666691BC2741CDCCCCAC5A575841CDCCCCCC97BC27413333337359575841333333339BBC27416666662658575841CDCCCCCC9EBC2741666666665657584166666666A1BC2741000000405457584100000000A5BC2741666666265157584100000000A8BC2741000000A04F57584133333333A8BC27419A9999D94D57584166666666A9BC2741666666264C57584166666666ADBC2741666666464A575841CDCCCCCCADBC27419A9999B94857584133333333ACBC27416666664647575841CDCCCCCCABBC2741000000A0465758419A999999AABC27419A9999F94157584166666666AABC2741000000C03E5758419A999999AEBC2741333333733C57584166666666AEBC27419A9999593B5758419A999999ABBC2741CDCCCC4C3A575841CDCCCCCCA8BC2741333333F33857584133333333AABC2741333333B33757584166666666ACBC27419A9999793557584100000000AABC27419A9999F93357584166666666A9BC2741666666263357584166666666AFBC27419A99999931575841CDCCCCCCB3BC2741666666E62F57584166666666B8BC2741666666062E575841CDCCCCCCB9BC27419A9999592C57584100000000BFBC2741333333532A5758419A999999C3BC2741333333732757584100000000C7BC27413333339325575841CDCCCCCCCCBC27419A9999592357584166666666D4BC27416666664621575841CDCCCCCCDCBC2741000000601E57584166666666DEBC2741000000E01C57584100000000DFBC27419A9999D91B5758419A999999E0BC2741333333B31A575841CDCCCCCCE2BC2741CDCCCCCC1957584133333333E6BC2741333333B31857584166666666E9BC2741000000E0175758419A999999EDBC2741333333F31657584166666666F1BC2741666666E615575841CDCCCCCCF9BC2741CDCCCCEC145758419A99999900BD2741CDCCCCCC11575841CDCCCCCC04BD2741333333B310575841000000000EBD2741CDCCCCEC0E5758413333333312BD2741666666E60D5758410000000017BD2741666666A60C575841CDCCCCCC1ABD27419A9999390B575841CDCCCCCC18BD274166666686065758419A99999918BD27419A99993905575841CDCCCCCC14BD27416666664603575841CDCCCCCC11BD2741000000C001575841CDCCCCCC0EBD27413333335300575841666666660DBD2741CDCCCC0CFF5658419A9999990DBD2741666666C6FD5658419A9999990DBD274166666686FC5658419A9999990BBD2741CDCCCCECFA565841CDCCCCCC0ABD27419A999999F9565841CDCCCCCC06BD2741333333D3F75658419A99999904BD27419A999939F656584133333333FFBC274100000060F45658419A999999F3BC2741000000C0F256584100000000EDBC274100000060F1565841CDCCCCCCE9BC2741CDCCCC4CEE565841CDCCCCCCEDBC2741666666C6EC5658419A999999EBBC274166666686EB56584100000000EABC274100000080E956584133333333E8BC274100000060E856584133333333E5BC27419A999919E756584166666666E3BC274166666626E656584166666666E2BC2741666666C6E456584166666666DFBC274166666666E356584166666666D9BC274100000060E2565841CDCCCCCCD8BC274166666646E15658419A999999DBBC2741333333F3DF565841CDCCCCCCD8BC274100000000DE565841CDCCCCCCD2BC27419A999979DC565841CDCCCCCCD1BC274166666606DC56584100000000D0BC2741333333F3D956584100000000CFBC274133333333D856584133333333C9BC2741CDCCCC4CD656584166666666C0BC2741666666C6D456584100000000B5BC274100000000D456584133333333ABBC274133333353D35658419A999999A5BC27419A999959D156584100000000A1BC2741333333D3CF565841666666669CBC274133333393CE5658413333333397BC2741CDCCCC6CCD5658410000000092BC274100000000CC565841666666668BBC2741CDCCCC2CCA565841CDCCCCCC81BC274166666646C8565841666666666CBC274166666686C7565841333333335ABC274166666646C75658413333333346BC274133333333C8565841CDCCCCCC38BC27419A999939C85658410000000028BC27419A9999B9C75658410000000013BC274133333373C75658419A99999908BC274100000060C75658419A999999FFBB2741CDCCCCECC656584133333333F6BB274166666686C656584166666666ECBB2741CDCCCC2CC656584100000000DFBB2741333333D3C556584100000000D4BB27419A999999C556584133333333C9BB2741CDCCCC6CC5565841CDCCCCCCBCBB27419A999939C5565841CDCCCCCCB0BB274100000000C556584100000000A4BB27419A9999B9C45658419A99999998BB274100000060C4565841CDCCCCCC84BB274133333373C3565841000000007ABB2741CDCCCCCCC25658410000000068BB274100000080C15658410000000067BB2741CDCCCC4CC15658416666666662BB274166666646C05658413333333362BB27419A999979BE5658419A9999995CBB27419A9999B9BC5658410000000050BB27419A9999B9B95658419A99999940BB274133333393B65658413333333335BB274166666606B4565841666666662DBB2741000000C0B1565841CDCCCCCC2ABB274166666606B05658419A99999929BB2741CDCCCCACAE565841666666662DBB27419A9999D9AC5658413333333331BB2741CDCCCCACAA565841666666663FBB2741CDCCCC6CA85658413333333355BB2741CDCCCC8CA6565841CDCCCCCC5FBB274166666686A5565841000000006CBB2741666666E6A35658410000000077BB2741666666E6A25658416666666684BB274166666606A2565841CDCCCCCC9ABB2741333333F3A056584166666666B5BB274133333353A056584100000000E1BB274166666626A156584133333333EBBB274133333313A456584166666666F0BB274166666646A55658419A999999FBBB274133333393A5565841CDCCCCCC05BC274166666686A55658416666666613BC27419A999939A55658410000000022BC2741CDCCCCACA45658413333333331BC274166666666A45658419A9999994ABC27419A9999D9A35658410000000066BC274166666646A3565841666666668EBC274133333313A4565841000000009FBC274100000080A4565841CDCCCCCCB4BC274133333353A456584166666666CFBC274166666626A456584100000000ECBC274133333353A456584100000000FCBC2741666666C6A35658416666666600BD2741000000C0A3565841CDCCCCCC16BD2741CDCCCCACA3565841CDCCCCCC39BD2741666666C6A3565841666666665FBD2741000000C0A35658419A99999975BD2741333333F3A35658416666666681BD27419A999919A45658419A99999992BD27419A999939A456584133333333ABBD274133333353A356584166666666BEBD274100000080A256584166666666CDBD2741333333D3A15658419A999999DCBD2741666666A6A056584133333333E6BD2741333333539F565841CDCCCCCCEBBD27419A9999599E5658419A999999F1BD2741333333539D56584100000000F9BD2741333333339C5658419A999999FDBD2741000000809B5658413333333303BE2741CDCCCCCC9A5658413333333309BE2741CDCCCC8C9A565841CDCCCCCC13BE2741000000209A565841000000001ABE2741666666C6995658419A99999925BE2741333333F398565841000000002EBE2741CDCCCC2C985658419A99999934BE27416666668697565841000000003BBE27419A99997996565841333333333FBE274133333393945658416666666647BE2741CDCCCC0C92565841333333334DBE274166666626905658419A99999953BE2741333333938E5658419A99999957BE2741CDCCCCCC8C565841CDCCCCCC58BE2741333333538B5658419A99999959BE27419A9999B989565841666666665ABE27419A99995988565841CDCCCCCC5CBE27419A9999B984565841000000005EBE274100000020805658416666666660BE27419A9999397E5658416666666662BE2741333333537C5658416666666665BE2741333333D37A565841CDCCCCCC69BE2741CDCCCC6C785658410000000074BE2741000000E074565841000000007CBE274166666686725658416666666681BE274100000000715658416666666689BE2741666666866F565841CDCCCCCC8DBE2741CDCCCCCC6E565841CDCCCCCC92BE2741CDCCCCEC6D565841CDCCCCCC9ABE2741000000406C565841666666669EBE2741333333136B565841CDCCCCCCA0BE2741CDCCCC4C6A56584166666666A4BE2741666666A668565841CDCCCCCCA7BE2741CDCCCC0C6756584166666666AEBE274100000020655658419A999999B0BE27419A9999996456584133333333BEBE2741000000C0625658419A999999C6BE2741333333B361565841CDCCCCCCCABE2741333333136156584100000000CEBE2741333333936056584100000000D3BE27419A9999595F565841CDCCCCCCD7BE27419A9999595D565841CDCCCCCCDBBE27419A9999D95A5658419A999999E0BE2741CDCCCCEC5756584166666666E8BE27419A9999F95556584166666666F2BE274166666686525658419A999999FABE27419A99997950565841CDCCCCCC03BF2741333333334E565841666666660CBF2741333333334C5658413333333312BF2741000000604A5658419A99999919BF27419A999939485658419A99999921BF27419A99997947565841333333332EBF27419A999919465658416666666636BF27416666660644565841333333333EBF2741CDCCCC2C415658419A9999993FBF2741CDCCCCEC405658413333333346BF27419A9999B93F565841000000004BBF2741000000603E565841000000004FBF2741000000003D5658419A99999955BF27419A9999193C5658419A99999960BF2741666666A63A5658416666666664BF2741000000203A5658410000000074BF27413333331338565841000000007FBF27410000000036565841CDCCCCCC86BF2741000000E0335658416666666690BF2741333333B3315658413333333397BF2741666666462F565841000000009ABF2741CDCCCC6C2D565841000000009EBF27419A9999992B5658419A999999A2BF2741666666862A56584166666666ACBF2741CDCCCCCC275658419A999999B2BF2741666666262656584133333333B8BF274133333393245658419A999999BEBF2741333333D32256584133333333C3BF2741CDCCCC2C21565841CDCCCCCCC7BF2741000000E01F56584133333333CDBF2741000000801E56584166666666D2BF2741333333F31C5658419A999999D7BF2741CDCCCC4C1B565841CDCCCCCCDEBF2741CDCCCC8C1856584166666666E2BF2741CDCCCC6C17565841CDCCCCCCE6BF2741CDCCCC0C1656584100000000EDBF2741666666861456584100000000F3BF2741666666661356584166666666F7BF27419A999919125658419A999999FBBF27419A9999F9105658419A999999FBBF27413333339310565841CDCCCCCCFABF2741333333530F56584166666666F7BF2741CDCCCC8C0D5658419A999999F4BF2741666666860C565841CDCCCCCCF3BF2741CDCCCC2C0C56584133333333F0BF2741CDCCCCAC0A56584133333333E8BF27410000000006565841CDCCCCCCE4BF27419A9999B904565841CDCCCCCCDEBF2741333333730356584166666666D6BF2741000000000256584133333333D0BF2741000000C000565841CDCCCCCCC9BF2741333333B3FF55584100000000C0BF274133333373FE55584100000000B9BF274166666646FD55584133333333B1BF2741000000E0FB5558419A999999ABBF274133333333FA5558419A999999A6BF27419A9999D9F8555841CDCCCCCC9FBF2741CDCCCC0CF75558410000000098BF274166666646F5555841666666668CBF274133333393F25558413333333385BF274166666606F15558413333333380BF27419A999979EF555841666666667DBF274166666666ED555841333333337BBF2741000000E0EB555841000000007ABF2741CDCCCCECE95558416666666678BF27419A999939E85558416666666679BF274100000040E7555841000000007ABF27419A999999E6555841666666667BBF2741CDCCCC0CE55558419A9999997ABF274166666606E45558410000000078BF2741666666C6E25558410000000072BF274166666606E05558419A99999970BF2741CDCCCCACDE5558413333333370BF27419A999959DD5558419A99999972BF2741000000E0DB5558413333333373BF2741000000C0DA5558416666666674BF2741666666C6D95558419A99999975BF27419A999919D95558410000000077BF2741CDCCCCECD75558413333333377BF2741CDCCCC6CD65558416666666677BF274100000000D55558416666666679BF2741CDCCCC8CD35558410000000082BF2741CDCCCC4CD05558410000000088BF27419A999959CD5558419A9999999ABF2741333333F3C65558419A999999A4BF2741CDCCCCECC455584133333333A6BF274133333393C455584133333333ADBF2741333333F3C2555841CDCCCCCCB0BF2741666666C6C155584100000000BEBF274166666666BF55584166666666C7BF274100000080BE55584166666666CEBF27419A999959BD55584100000000DCBF2741CDCCCC2CBB5558419A999999EDBF27419A999999B85558416666666603C0274100000040B6555841CDCCCCCC12C02741CDCCCC6CB45558419A99999920C02741CDCCCC0CB35558413333333331C02741333333B3B15558419A9999993FC02741666666E6AF5558416666666648C02741000000C0AD555841CDCCCCCC4DC02741CDCCCCCCAC5558419A99999952C02741333333F3AB555841333333335BC02741000000E0A9555841666666665CC027419A999939A85558419A99999966C0274100000000A65558410000000071C02741CDCCCC8CA45558413333333377C0274100000000A35558419A9999997DC0274166666626A15558419A99999987C02741666666C69E5558419A9999998EC02741CDCCCCAC9D5558419A99999995C02741666666669C555841000000009BC02741333333F39A55584133333333A0C02741000000409955584166666666A4C027419A9999D997555841CDCCCCCCA8C027419A9999B99655584133333333B1C02741CDCCCCCC9255584133333333B7C02741000000A09155584133333333BEC02741666666269155584100000000C6C02741000000C09055584166666666D4C02741333333538F55584100000000DCC02741333333338E55584133333333DCC02741000000A08C55584133333333DFC027419A9999798A5558419A999999DFC027419A9999198955584166666666E3C027419A9999798655584100000000ECC02741000000C083555841CDCCCCCCF2C0274133333393825558416666666623C12741000000807E555841CDCCCCCC2AC12741CDCCCCAC7D555841CDCCCCCC2DC12741CDCCCC6C7D5558416666666636C12741666666A67C5558416666666640C12741333333137C5558419A9999994CC12741666666C67B5558410000000059C12741CDCCCC6C7A555841CDCCCCCC5EC12741333333B379555841CDCCCCCC6EC12741CDCCCC0C775558416666666671C1274133333393765558413333333382C12741000000A073555841666666669EC127410000004070555841CDCCCCCCA1C12741CDCCCCCC6F55584133333333A9C12741666666E66E55584166666666B6C12741CDCCCC0C6D55584166666666CCC12741666666C66A55584166666666E6C12741333333D3675558410000000002C227413333335364555841CDCCCCCC0DC22741CDCCCC6C635558416666666621C2274133333333625558410000000028C2274133333373615558419A9999993BC22741000000405F555841CDCCCCCC42C22741CDCCCCAC5E555841333333334EC22741333333135E5558419A9999995AC22741333333B35D5558416666666666C22741333333935D555841000000006FC22741000000205D5558413333333377C227419A9999995C5558416666666682C227419A9999795B5558419A99999987C227419A9999F959555841666666668BC22741CDCCCCCC58555841000000008DC22741000000A0575558410000000096C22741666666865655584166666666A4C22741333333D3545558419A999999ABC227419A9999395455584166666666B4C22741000000805355584100000000BBC22741CDCCCCAC5255584133333333CEC22741CDCCCC0C5055584166666666D2C22741666666064F55584100000000D6C22741CDCCCCAC4D55584166666666D6C22741333333334C55584100000000DBC22741666666A64855584166666666DEC22741000000004755584100000000DEC22741CDCCCC6C4555584100000000DDC22741000000004455584133333333D6C22741CDCCCC8C4155584133333333CFC22741666666864055584166666666CBC22741CDCCCCCC3F555841CDCCCCCCC6C22741000000203F5558419A999999BCC22741666666063F55584166666666B3C22741666666C63E5558419A999999ABC227419A9999593E55584133333333A2C227419A9999193D5558419A9999999EC22741666666063C555841666666669BC22741333333D33A5558413333333391C227413333337339555841CDCCCCCC86C22741000000E0385558410000000074C227413333331338555841666666665FC227413333333337555841666666664AC227419A999959365558419A99999936C22741666666C6355558413333333324C227419A99995935555841CDCCCCCC0FC22741CDCCCCEC3455584133333333F6C12741666666E63355584100000000EDC12741CDCCCCEC32555841CDCCCCCCE5C12741666666E63155584166666666DAC12741CDCCCCCC305558419A999999CEC12741666666A62F55584166666666C2C12741666666A62E5558419A999999B5C12741666666A62D5558419A999999ABC127419A9999D92C555841333333339FC127419A9999F92B5558416666666697C12741CDCCCC4C2B5558413333333396C12741CDCCCC2C2B5558413333333393C12741CDCCCC8C29555841CDCCCCCC81C1274100000080265558410000000073C127419A99993924555841333333336BC127419A99993923555841333333335DC12741000000C022555841CDCCCCCC53C127416666666622555841666666664AC12741000000C0215558416666666641C127419A999979205558419A99999936C127419A9999391D555841CDCCCCCC35C12741000000801B5558419A99999937C127419A9999391A5558419A99999935C12741666666E6185558416666666632C12741CDCCCC6C17555841666666662FC12741000000A0155558419A9999992EC12741CDCCCC2C145558410000000031C127419A999999125558413333333331C12741333333F3105558416666666631C12741CDCCCC0C0F5558413333333338C12741000000000C555841CDCCCCCC3EC12741CDCCCC4C0A555841CDCCCCCC43C127419A9999B9085558419A99999947C12741CDCCCCCC06555841000000004BC1274100000040055558416666666652C127416666668602555841000000005EC12741333333F3FC5458419A9999995EC12741333333B3FB545841000000005CC127419A999979FA5458410000000057C12741CDCCCCACF45458410000000068C1274133333333F2545841333333337DC1274100000020EF5458416666666688C127419A999919EE5458419A99999992C1274100000080ED545841666666669BC1274100000000ED54584166666666A2C12741CDCCCC4CEC545841CDCCCCCCBDC12741000000A0EA54584166666666CCC1274100000080EA54584100000000DBC1274133333373EA54584133333333F1C12741666666E6EA54584100000000FCC1274133333353EB5458413333333305C22741666666A6EB545841000000001AC22741CDCCCC6CEA5458413333333326C22741000000E0E7545841000000002CC22741333333D3E6545841CDCCCCCC34C2274100000000E6545841CDCCCCCC4DC22741CDCCCCACE4545841CDCCCCCC55C2274100000040E4545841CDCCCCCC60C22741000000A0E3545841333333336EC2274166666666E2545841666666667BC2274100000040E1545841CDCCCCCC93C227419A999959DD5458416666666696C2274100000000DC5458419A9999999AC227419A999959DA54584100000000A0C22741CDCCCCECD854584166666666A6C227419A9999B9D754584100000000ABC2274166666686D6545841CDCCCCCCACC227419A999959D554584100000000AEC227419A9999D9D3545841CDCCCCCCAEC2274100000080D2545841CDCCCCCCAEC2274166666606D154584166666666B3C227419A999959CE54584133333333B5C227419A999999C854584100000000B1C2274166666626C55458419A999999A5C227419A9999D9BF54584133333333A4C22741CDCCCCCCBE545841000000009BC227419A999919BC545841333333338EC22741000000A0BB545841CDCCCCCC85C227419A999919BB5458413333333363C2274100000020B95458410000000050C2274166666646B7545841333333333EC22741CDCCCC6CB45458410000000023C22741000000C0AF5458419A9999991DC2274133333393AF5458419A999999F9C127419A999919AE545841CDCCCCCCEAC12741CDCCCC4CAA545841CDCCCCCCE9C12741CDCCCC8CA954584133333333E6C127419A9999B9A654584100000000CFC12741CDCCCC0CA4545841666666669BC12741333333339F5458410000000092C127419A9999399C5458413333333381C12741666666869A5458416666666673C12741333333D3985458416666666664C127419A99991998545841CDCCCCCC53C12741000000C0975458410000000053C12741CDCCCC2C955458419A99999952C12741333333D38F5458413333333353C12741666666E68D5458410000000050C12741333333538B5458410000000052C127419A9999B989545841CDCCCCCC5BC12741CDCCCCEC875458419A99999968C12741666666E6865458419A99999979C1274133333373845458416666666698C12741CDCCCC8C7F54584166666666A5C127419A9999D97B54584166666666B4C12741000000207754584133333333C3C127410000004071545841CDCCCCCCD9C12741333333D36A54584100000000E0C12741000000006654584133333333E3C12741333333D3615458419A999999E2C12741666666E65E54584133333333E0C127419A9999D95C545841CDCCCCCCB1C12741666666665854584133333333A7C127419A999919575458410000000080C127410000008052545841000000005CC127419A9999D94F545841CDCCCCCC53C12741666666464F5458419A9999994EC12741000000204E5458419A9999994DC12741333333B34C545841666666663CC12741333333D34A5458419A99999926C127419A9999194A545841CDCCCCCC18C12741000000404A545841333333330EC12741000000A04A545841CDCCCCCC04C12741000000004B5458419A999999F5C027419A9999794B54584100000000E9C02741666666A64B54584100000000DEC02741666666664B5458419A999999CEC02741333333B34B54584133333333AFC02741666666C649545841CDCCCCCC9AC02741666666C6485458416666666695C027416666662648545841CDCCCCCC83C027416666664647545841666666667AC02741000000E046545841CDCCCCCC63C027419A9999D9455458419A9999995AC027419A9999D9445458410000000056C02741CDCCCC0C445458410000000045C02741000000C03F5458410000000042C027419A9999F93E545841CDCCCCCC3FC02741333333F33D5458419A99999940C02741CDCCCCAC385458410000000043C02741333333B336545841333333335AC027419A9999792F5458410000000061C02741666666662D545841666666666EC02741666666862A545841CDCCCCCC75C0274133333313285458419A99999980C027419A999979235458410000000085C0274133333353225458419A999999B8C02741666666861E54584133333333BFC02741333333131E54584100000000C8C02741000000601D545841CDCCCCCCE5C027416666662618545841CDCCCCCCE9C027419A9999F91654584133333333EDC02741333333D315545841CDCCCCCCF2C027413333335314545841CDCCCCCCF7C0274133333313135458419A999999FCC0274133333393115458419A99999905C127419A9999990F545841666666661AC12741666666C60D545841333333333CC12741666666860B5458419A99999958C127410000000008545841000000009CC12741666666460554584133333333A5C12741333333930454584133333333B4C12741CDCCCC6C0354584100000000C1C127419A9999B9015458419A999999C4C12741000000E000545841CDCCCCCCC8C1274133333393FE535841CDCCCCCCCBC1274166666646FC5358419A999999CDC1274133333333F953584166666666D5C1274166666666F653584100000000DBC127419A999939F453584166666666DDC1274166666686F253584166666666DDC12741CDCCCCECF05358419A999999DBC12741CDCCCCCCEE5358419A999999D8C1274166666646ED5358419A999999D3C127419A9999B9EA53584100000000D1C1274166666626E953584133333333D4C12741CDCCCCECE653584133333333D0C127419A999939E553584100000000C0C12741CDCCCCCCE153584166666666B6C12741666666E6DF5358416666666689C12741666666E6D8535841CDCCCCCC81C12741CDCCCC6CD55358416666666672C1274166666686D25358419A99999966C127419A999959D15358413333333353C1274166666626CF5358416666666647C1274166666686CD535841333333333DC1274100000000CC5358413333333335C1274100000000CB535841333333331DC12741333333D3C65358419A999999F3C02741CDCCCCCCC05358419A999999EDC02741CDCCCC2CC053584100000000CBC0274133333393B753584166666666BCC02741CDCCCCECB053584100000000BCC0274133333353AD5358419A999999BEC027419A9999B9AA5358419A999999CAC0274100000000A853584166666666DEC02741CDCCCC8CA553584166666666E7C02741000000A0A45358419A99999901C12741333333B39F5358410000000009C12741CDCCCCEC9D5358416666666624C12741333333739A535841CDCCCCCC52C1274133333353965358416666666675C1274133333353925358410000000087C12741666666868F535841CDCCCCCC90C12741333333538D535841666666669AC12741000000A08B53584100000000A9C127413333339388535841CDCCCCCCACC12741CDCCCC8C87535841CDCCCCCCBFC12741666666C68553584166666666F4C12741333333337F53584166666666FEC12741000000807C5358416666666602C22741333333737B5358410000000005C2274166666606795358416666666609C227413333339376535841666666660EC2274166666646735358410000000010C2274166666606715358410000000011C22741000000A06F5358413333333300C22741666666866653584166666666FBC12741666666666553584133333333F0C127419A9999B961535841CDCCCCCCECC12741333333D35F5358419A999999ECC12741333333B35E53584133333333EDC12741333333B35D53584133333333F7C12741000000005B53584166666666DBC12741666666A655535841CDCCCCCCC4C12741666666E65453584133333333B9C1274166666666555358419A999999A8C12741CDCCCCAC54535841666666669BC127419A9999394F535841CDCCCCCC8EC127419A9999794D535841333333337FC12741000000804C5358410000000071C127419A9999D94B535841CDCCCCCC5EC12741000000204B5358413333333358C12741666666E64A535841333333334EC12741333333334B535841CDCCCCCC41C12741000000404B5358410000000037C12741CDCCCC2C4B535841CDCCCCCC29C127419A9999994A535841CDCCCCCC23C12741000000C049535841CDCCCCCC1BC127416666666647535841CDCCCCCCFAC027419A99993945535841CDCCCCCCEFC02741000000804453584100000000E5C0274166666666435358419A999999D9C02741CDCCCC0C4253584100000000D3C027419A9999D94053584166666666D8C02741333333333D5358419A999999D4C02741666666C63B535841CDCCCCCCCFC02741333333933A5358419A999999CAC02741666666463853584100000000C0C027419A9999193453584100000000C0C02741CDCCCC8C315358419A999999BFC02741333333133053584100000000BCC027419A9999D92E53584100000000B7C02741666666C62D53584133333333ADC02741CDCCCC8C2B5358419A999999A2C027413333339328535841CDCCCCCC9DC02741CDCCCC0C265358419A9999999EC027419A99993923535841CDCCCCCCA0C02741000000C01F5358419A999999A1C02741CDCCCC2C1D5358419A999999A5C02741333333131B53584166666666ABC02741333333931953584166666666AEC02741333333B3185358419A999999CFC027413333335314535841CDCCCCCCD5C02741333333731353584133333333DAC02741666666C6115358419A999999E0C02741CDCCCC0C105358419A999999EAC02741CDCCCCCC0D53584100000000F7C02741333333B30B5358419A9999990EC127413333337308535841333333332EC12741CDCCCCAC04535841000000003AC12741666666E6025358413333333344C127419A999979005358419A99999948C1274133333353FF5258419A9999994DC12741CDCCCC4CFE525841CDCCCCCC53C1274133333353FD525841000000005CC12741CDCCCC8CFC525841CDCCCCCC60C1274133333353FC5258419A99999981C12741CDCCCCCCFD52584133333333A5C127419A999999FA525841CDCCCCCCBEC12741000000C0F852584166666666DBC12741333333F3F652584133333333EFC12741CDCCCC4CF55258416666666601C22741CDCCCC0CF35258419A99999904C2274166666606F25258410000000008C2274133333313F1525841CDCCCCCC14C2274133333393EC5258419A9999991DC22741CDCCCC2CE85258410000000032C22741CDCCCC2CDD525841000000003AC22741CDCCCC2CD9525841000000003BC22741CDCCCCACD75258416666666640C22741333333D3D4525841CDCCCCCC45C2274100000040D25258419A9999994BC2274166666606D05258419A9999994FC22741666666A6CC525841333333334BC2274133333393CB5258413333333344C22741333333B3CA5258419A99999934C2274166666666C85258419A99999928C2274133333333C6525841000000001EC22741000000E0C45258413333333312C2274100000020C4525841666666660DC2274166666606C3525841333333330BC227419A999999C152584100000000FFC12741666666C6B8525841CDCCCCCCFDC12741000000A0B65258419A99999906C2274133333393B55258419A9999990AC2274133333313B55258416666666618C22741CDCCCC8CB3525841333333332AC22741666666C6B25258419A99999935C2274133333353B1525841333333335DC22741333333D3AD5258413333333367C227419A999919AC525841666666666AC22741000000E0AA525841666666666FC22741CDCCCC0CA95258416666666678C22741000000A0A55258416666666680C2274133333333A35258413333333387C22741CDCCCC8C9E525841CDCCCCCC88C22741CDCCCC8C9C5258419A99999986C22741666666A6995258419A9999997DC227419A9999F997525841CDCCCCCC77C22741333333D397525841666666666BC22741333333D397525841333333335DC22741000000E0975258410000000047C22741333333D3975258413333333340C227419A999979975258413333333329C22741000000E0965258416666666627C22741000000C096525841CDCCCCCC0CC22741CDCCCC6C935258410000000003C22741000000609352584166666666FCC127416666666693525841CDCCCCCCF4C12741000000C0935258419A999999EDC127419A99993994525841CDCCCCCCE5C127419A9999B99452584133333333D9C12741CDCCCC8C955258419A999999C3C12741CDCCCCAC945258419A999999B5C127419A9999D9925258410000000097C1274133333393905258419A99999982C12741666666E68D525841333333336EC12741666666068B5258416666666663C127413333339389525841CDCCCCCC4EC12741333333D386525841666666663EC127410000008082525841333333332AC12741333333537D5258416666666629C127419A99995978525841666666662FC1274100000060745258419A99999938C1274133333333735258410000000041C12741666666A672525841CDCCCCCC5AC12741333333F36E5258410000000062C12741000000606D5258419A9999998FC12741CDCCCC0C66525841CDCCCCCCABC1274100000000595258419A99999990C127410000004044525841CDCCCCCCC0C1274133333353385258419A99999906C2274166666606265258416666666641C2274166666626135258419A99999966C227419A999999005258410000000079C22741333333B3F6515841333333338AC227419A999939EE51584133333333A6C2274100000020E651584166666666B5C22741333333B3E351584100000000D1C22741CDCCCC6CDF515841CDCCCCCCFAC227419A9999B9D95158413333333303C3274100000080D9515841CDCCCCCC1CC32741CDCCCCECD85158410000000032C327419A999939D9515841CDCCCCCC3FC3274166666666D9515841CDCCCCCC4EC32741666666A6D95158410000000057C3274133333373D9515841000000005AC3274100000000D95158413333333362C32741333333D3D75158416666666673C327419A9999B9D2515841666666667EC32741CDCCCCACD05158416666666689C32741CDCCCCACCF515841CDCCCCCC97C327419A9999F9CD5158419A999999B2C3274100000060CB51584166666666DCC3274166666606C851584100000000E7C32741CDCCCC2CC751584166666666F8C32741000000A0C6515841333333330CC4274100000020C65158413333333329C42741CDCCCC0CC5515841333333333FC427419A9999F9C35158413333333362C4274133333393C2515841CDCCCCCCC2C4274166666626BD51584133333333D1C42741666666C6BC51584100000000E5C4274166666646BC515841CDCCCCCCF4C427419A999979BB5158413333333308C52741666666A6B95158410000000018C52741CDCCCCACB75158416666666639C52741CDCCCC0CB1515841CDCCCCCC4FC52741666666E6AB515841333333335DC5274100000060AA5158413333333365C52741CDCCCC2CA9515841333333336CC52741CDCCCC8CA75158419A9999996EC5274166666606A6515841333333336EC5274133333393A3515841CDCCCCCC6EC52741333333F3A05158416666666677C527419A9999599D515841333333337EC52741000000409B5158413333333382C527410000006098515841CDCCCCCC81C52741333333B37B515841333333337AC527416666666678515841CDCCCCCC72C527419A9999F9755158419A99999960C52741CDCCCCCC6B515841333333335FC52741CDCCCC2C695158419A9999995CC527413333335366515841CDCCCCCC5BC527410000002064515841000000005EC5274166666686615158416666666661C52741666666665F5158410000000068C527419A9999B95C5158413333333378C5274166666686585158410000000082C5274100000000575158419A99999992C52741CDCCCC6C555158419A999999A8C527419A9999B95351584166666666C3C527410000006052515841CDCCCCCC05C627419A9999994E5158419A9999991CC62741CDCCCCEC4C515841000000003CC627419A9999D94A5158413333333366C627419A9999B94851584166666666AAC6274166666686465158419A999999CEC62741000000E0465158419A999999EBC627419A99995947515841000000000BC7274100000020485158416666666635C727413333335348515841CDCCCCCC5EC72741333333D3475158410000000091C72741CDCCCC6C4651584100000000BEC727419A9999D94351584100000000F2C727410000000040515841333333330BC82741000000203E5158416666666630C82741333333B3395158416666666641C82741333333D336515841CDCCCCCC4BC827410000004034515841CDCCCCCC58C827419A99993930515841333333335CC82741666666A62A5158419A9999995CC82741CDCCCCEC27515841666666665CC827416666662625515841333333335FC82741000000C0225158419A99999966C827419A99999920515841000000006EC82741CDCCCC6C1E5158413333333377C82741666666A61B5158413333333384C827410000000018515841CDCCCCCC95C82741CDCCCC4C13515841CDCCCCCCA2C82741CDCCCC2C0F51584166666666ADC82741333333130C51584100000000B0C827419A9999990851584133333333B3C82741666666460051584100000000B0C8274133333333FC50584133333333ACC8274133333313F850584166666666ABC8274133333313F5505841CDCCCCCCAAC8274133333393F350584100000000AAC8274100000000F250584133333333A7C82741000000C0EE5058419A999999A0C827419A999959EB505841CDCCCCCC6CC8274133333353D25058416666666666C82741CDCCCC4CC7505841CDCCCCCC66C82741333333F3C35058419A99999976C8274166666626B95058419A99999988C8274100000060AC5058416666666693C827419A9999D9A5505841333333339CC8274166666646A3505841CDCCCCCCA9C82741666666E6A05058419A999999BCC82741000000209E505841CDCCCCCCCFC82741000000009B50584133333333DEC827416666668698505841CDCCCCCCF6C82741666666C692505841CDCCCCCC04C927419A9999198F5058416666666610C92741CDCCCCCC8C5058419A99999910C92741000000C08C5058410000000014C927419A9999198C5058416666666623C92741CDCCCCEC88505841CDCCCCCC34C927419A9999F9855058410000000043C9274100000020845058416666666647C927419A9999B983505841CDCCCCCC32C927419A99999980505841CDCCCCCC30C92741CDCCCC4C805058416666666624C92741333333937E5058419A99999919C92741666666667C505841CDCCCCCC05C927419A99993978505841CDCCCCCCFEC82741CDCCCC0C775058419A999999FAC827413333339376505841CDCCCCCCE8C827410000008075505841CDCCCCCCDDC82741000000E074505841CDCCCCCCC1C82741000000007450584133333333B5C82741CDCCCCEC7350584133333333A1C82741666666C6735058410000000088C8274133333373735058410000000059C82741CDCCCC0C735058419A9999994DC827419A9999F972505841CDCCCCCC3EC827419A999959725058419A99999933C827416666666671505841000000002AC827416666662671505841CDCCCCCC1EC82741CDCCCC8C705058419A99999911C827419A9999F96F5058416666666606C82741000000806F50584100000000FCC72741CDCCCC6C6F50584133333333F3C72741000000606F50584166666666DEC72741CDCCCCAC6E50584166666666BDC72741000000806D5058419A999999AAC72741CDCCCC0C6D505841333333339AC72741000000C06C5058416666666681C72741666666A66C505841666666666BC72741333333D36C505841666666665FC72741000000E06C5058413333333352C72741666666E66C5058410000000047C72741333333B36C5058419A9999993DC72741666666266C5058416666666635C727419A9999396B505841666666662DC72741000000406A505841CDCCCCCC27C72741000000E068505841CDCCCCCC24C727419A9999D9675058419A99999920C7274133333353655058410000000020C72741000000E0635058410000000020C727419A999919625058410000000020C72741CDCCCC4C605058410000000020C72741666666E65D5058410000000020C727419A9999B95A5058419A99999922C72741666666C6585058419A99999925C727413333333356505841333333332EC72741CDCCCC6C53505841CDCCCCCC32C72741333333F3515058419A99999943C72741333333734D505841666666664FC72741000000C049505841CDCCCCCC55C72741333333F3475058419A99999956C7274100000000455058419A99999953C72741CDCCCC8C43505841333333334DC7274133333313425058419A99999946C72741000000A0405058413333333340C72741000000603F5058416666666629C72741CDCCCCAC3C505841CDCCCCCC17C72741333333B33B505841CDCCCCCC0FC727419A9999993B505841CDCCCCCC05C727419A9999193B5058413333333302C72741CDCCCC4C3A50584100000000F9C627413333335339505841CDCCCCCCEEC62741CDCCCCCC385058419A999999E4C62741666666463850584166666666D9C62741333333B337505841CDCCCCCCCFC62741666666263750584166666666C5C62741CDCCCC0C3750584133333333C2C62741000000C03650584133333333BEC62741000000603650584133333333B5C62741000000A03550584100000000ABC627419A9999393450584100000000A4C62741CDCCCC4C33505841666666669BC6274133333313325058419A99999993C627419A999919315058419A99999985C62741333333D32F5058413333333377C62741CDCCCCEC2E5058419A9999996DC62741CDCCCCCC2D5058410000000064C62741666666A62C505841CDCCCCCC5AC627419A9999B92B505841000000004BC62741000000A0295058416666666647C627413333339328505841CDCCCCCC40C6274133333373265058410000000040C62741CDCCCC6C25505841000000003EC627416666660624505841CDCCCCCC3BC6274100000080225058413333333337C62741666666C6205058413333333331C62741000000001F505841333333332EC62741CDCCCCAC1D505841000000002CC62741333333B31B505841666666662DC62741666666261A5058419A9999992FC62741666666A6185058410000000031C6274166666626175058416666666631C627419A9999B9155058413333333333C627419A99991914505841CDCCCCCC35C62741666666C612505841CDCCCCCC3AC627410000004011505841CDCCCCCC3FC62741666666860F505841CDCCCCCC45C62741CDCCCCAC0D5058416666666650C62741333333930A5058416666666654C62741CDCCCC8C09505841CDCCCCCC56C6274133333333085058416666666656C62741000000E006505841CDCCCCCC55C62741333333B3055058419A99999959C6274166666666045058410000000067C627419A99999901505841CDCCCCCC6BC62741333333D3005058413333333372C62741666666C6FF4F5841CDCCCCCC76C62741666666E6FE4F58416666666678C62741CDCCCCECFD4F58410000000078C62741333333F3FC4F5841CDCCCCCC75C6274100000080FB4F58419A99999975C62741CDCCCC2CFA4F58413333333373C627419A9999B9F84F5841000000006AC62741333333B3F64F5841666666665EC627419A9999D9F44F58413333333356C62741000000A0F34F5841000000004CC62741000000A0F24F58419A99999947C62741CDCCCC2CF24F5841666666663EC6274100000040F14F58410000000037C6274133333353F04F58416666666629C6274100000060EF4F5841000000001FC62741CDCCCC0CEF4F58410000000016C6274133333313EF4F58419A9999990AC62741CDCCCC2CEF4F584100000000FCC5274133333353EF4F584100000000F2C5274166666626EF4F584133333333E8C52741333333F3EE4F584166666666E1C5274133333353EE4F584133333333D4C527419A999999EC4F584133333333CFC5274166666626EB4F5841CDCCCCCCC9C52741000000E0E94F584166666666C5C52741CDCCCC8CE84F584133333333C1C52741CDCCCC6CE74F58419A999999B3C52741333333F3E44F5841CDCCCCCC9EC5274166666686E24F5841CDCCCCCC97C527419A999999E14F58416666666689C5274166666686E04F58413333333378C527419A999999DF4F5841CDCCCCCC65C52741000000E0DF4F5841666666665BC52741000000E0DF4F58413333333354C52741CDCCCC0CE04F58419A9999994BC5274100000020E04F5841CDCCCCCC42C5274100000080E04F5841333333333BC52741000000A0E04F58410000000034C52741CDCCCC0CE14F5841000000002DC52741CDCCCCACE14F58419A99999925C5274166666606E24F5841666666661CC5274133333373E24F58416666666614C5274166666646E34F5841CDCCCCCC0DC5274100000020E44F5841CDCCCCCC06C5274100000000E54F58413333333300C52741333333F3E54F584166666666F8C4274100000000E74F584133333333F1C42741333333F3E74F584100000000EAC427419A999979E84F5841CDCCCCCCE2C4274133333393E84F584133333333DCC427419A999999E84F58419A999999D0C42741666666A6E84F5841CDCCCCCCC8C427419A9999B9E84F58419A999999BBC42741333333D3E84F584166666666A2C4274133333313E84F58410000000096C4274166666646E74F58416666666694C427419A9999F9E54F58419A99999996C42741CDCCCC6CE44F5841333333339BC42741CDCCCC2CE34F584100000000A3C4274166666666E04F58419A999999A5C427419A999959DF4F584100000000AEC42741666666A6DE4F58419A999999B7C427419A999919DD4F58419A999999BCC42741666666C6DB4F584166666666BEC42741CDCCCCACDA4F58419A999999BEC427419A999979D94F5841CDCCCCCCBDC4274133333393D84F5841CDCCCCCCB8C427419A999919D74F584166666666B1C427419A999919D64F58419A999999AEC42741000000E0D54F584133333333ABC42741CDCCCCCCD54F584166666666A3C427419A999939D54F58419A9999999FC4274100000080D44F58410000000099C4274133333353D34F5841CDCCCCCC93C42741CDCCCC4CD24F58416666666688C4274100000000D04F58416666666682C4274166666626CE4F5841CDCCCCCC81C42741CDCCCCACCC4F58416666666681C4274100000040CB4F5841666666667FC42741000000E0C94F5841000000007EC4274100000040C84F5841333333337DC42741000000E0C64F5841666666667DC42741666666A6C54F5841666666667DC4274166666686C44F5841CDCCCCCC7CC4274166666626C34F5841CDCCCCCC79C42741666666C6C14F58419A99999975C4274133333393C04F58410000000073C4274133333313BF4F58416666666671C42741000000C0BD4F5841CDCCCCCC71C4274100000020BC4F58410000000072C427419A999919BA4F58416666666673C427419A999959B84F58416666666671C427419A999979B64F58419A9999996EC427419A9999B9B34F5841666666666AC42741CDCCCC0CB04F5841333333336AC42741666666C6AE4F5841CDCCCCCC6CC4274133333313AD4F5841CDCCCCCC6AC4274100000020A94F58410000000065C42741333333B3A54F58416666666660C42741000000E0A44F5841CDCCCCCC5BC4274133333313A44F58416666666655C4274133333373A34F5841000000004CC4274133333313A34F5841000000003FC4274100000000A34F58419A99999934C427419A9999F9A24F5841666666661FC4274166666666A34F58410000000012C42741666666E6A34F58410000000007C42741CDCCCC4CA44F58416666666600C4274166666686A44F5841CDCCCCCCEBC3274166666686A54F584133333333DEC32741666666E6A54F584166666666CDC3274166666626A64F5841CDCCCCCCBCC3274133333313A64F58419A999999B3C3274133333313A64F584133333333ACC3274166666686A64F5841CDCCCCCCA2C32741000000A0A74F5841CDCCCCCC9BC3274133333373A84F58416666666691C32741CDCCCCECA84F58413333333388C3274166666626A94F58416666666684C32741333333F3A84F58410000000081C32741666666C6A84F5841CDCCCCCC7DC3274166666686A84F58410000000078C3274166666666A84F5841CDCCCCCC70C3274166666686A84F5841CDCCCCCC69C32741CDCCCCACA84F58416666666665C32741666666C6A84F58419A99999961C327419A9999B9A84F5841000000005DC3274133333373A84F58416666666659C327419A9999F9A74F5841CDCCCCCC56C32741CDCCCC6CA74F58419A99999953C3274133333373A64F58416666666650C32741CDCCCC0CA44F5841333333334CC32741CDCCCC4CA24F58413333333349C32741666666E6A04F58416666666646C3274166666606A04F58416666666645C32741CDCCCC4C9F4F5841CDCCCCCC45C32741666666A69E4F58410000000048C327419A9999D99D4F58419A9999994BC327419A9999199D4F5841666666665BC32741000000609B4F5841CDCCCCCC5FC32741000000C09A4F58416666666662C32741000000C0994F58419A99999963C32741CDCCCC2C994F58416666666669C32741666666E6984F58413333333371C327419A999979984F5841666666667BC32741333333D3974F58413333333383C3274133333373964F5841000000008DC3274166666606954F58416666666691C327419A999919944F58416666666692C32741CDCCCCCC924F58416666666692C3274166666646914F5841CDCCCCCC91C32741333333938F4F58416666666690C32741333333138E4F5841333333338EC32741000000C08C4F5841CDCCCCCC8AC32741CDCCCC4C8B4F58419A9999997BC327419A9999F9864F58419A9999996AC32741333333F3824F58410000000065C32741CDCCCC4C804F58410000000066C32741000000207F4F5841CDCCCCCC6AC32741666666467E4F58419A99999970C32741000000807D4F5841CDCCCCCC7FC327419A9999F97A4F5841CDCCCCCC89C3274133333373794F5841333333338EC32741000000A0784F5841333333338FC32741666666E6774F58413333333390C327419A999919774F58410000000091C32741333333F3754F5841CDCCCCCC8FC32741CDCCCCEC744F5841333333338DC32741333333F3734F58419A99999989C327419A9999B9724F58410000000086C32741CDCCCCCC714F58419A99999983C3274100000020714F5841666666667BC32741333333336F4F58410000000077C327419A9999196E4F58410000000073C32741333333136D4F5841000000006EC32741000000206C4F58419A99999965C32741333333336B4F5841666666665DC32741CDCCCC4C6A4F58416666666656C3274133333393694F5841CDCCCCCC4EC327419A9999F9684F5841CDCCCCCC45C3274133333373684F5841CDCCCCCC3BC3274100000040684F5841CDCCCCCC2FC3274166666646684F58416666666629C3274100000060684F5841CDCCCCCC24C327419A999979684F5841333333331FC32741CDCCCCAC684F5841000000001BC32741000000E0684F58416666666616C327419A999939694F58419A99999911C32741CDCCCCAC694F5841333333330CC32741CDCCCC4C6A4F58410000000008C32741CDCCCCEC6A4F58413333333303C32741333333936B4F58419A999999FEC22741CDCCCC0C6C4F584133333333F8C227419A9999D96C4F584166666666F3C22741000000806D4F584100000000EDC227419A9999796E4F584100000000E8C22741333333936F4F5841CDCCCCCCE4C22741CDCCCC2C704F584133333333E2C22741000000E0704F584133333333DCC227419A999959714F584100000000CFC22741CDCCCC2C724F584166666666C4C2274166666666734F584133333333B6C2274100000060754F584166666666A8C2274100000060774F5841CDCCCCCC8DC22741CDCCCC0C794F58416666666684C2274100000040794F5841666666667EC227419A9999F9784F58419A9999997AC22741333333B3784F58413333333375C22741CDCCCC8C784F5841000000006FC2274166666686784F5841CDCCCCCC67C227419A999919784F58419A99999963C22741000000C0774F58410000000064C2274133333333774F5841CDCCCCCC62C22741000000C0764F58410000000060C2274166666626764F5841666666665DC227419A999999754F58419A9999995BC227419A999939754F5841CDCCCCCC59C22741CDCCCCAC744F5841CDCCCCCC59C22741CDCCCCEC734F5841333333335AC2274133333373714F58410000000056C227419A999979704F58419A99999953C22741333333D36F4F58413333333352C227419A9999396F4F58416666666648C22741333333B36D4F5841666666663FC22741666666266C4F5841CDCCCCCC3AC22741333333536B4F58419A99999937C22741333333536A4F58413333333336C227419A9999F9684F5841CDCCCCCC35C2274100000040674F5841CDCCCCCC35C2274100000020664F58413333333336C22741666666E6644F5841666666663CC22741CDCCCCCC624F58416666666648C227419A9999D95F4F58416666666654C227419A9999595D4F5841000000005EC227419A9999995B4F5841CDCCCCCC69C22741000000805A4F58413333333374C22741333333D3584F58419A99999978C22741000000A0574F58413333333378C2274133333373564F58419A99999977C22741CDCCCCEC544F58419A99999975C2274133333333544F5841CDCCCCCC71C22741666666A6534F5841CDCCCCCC6DC227419A9999F9524F5841666666666BC22741000000E0514F58419A9999996BC2274133333313514F5841CDCCCCCC6CC2274166666666504F5841000000006EC22741666666A64F4F5841333333336DC22741000000204F4F5841CDCCCCCC6AC22741CDCCCC8C4E4F58413333333368C22741CDCCCC0C4E4F58416666666660C227419A9999194D4F58419A99999959C22741000000A04C4F5841CDCCCCCC4AC22741CDCCCCCC4B4F5841000000003AC22741666666E64A4F5841CDCCCCCC1DC227419A999979494F584166666666FEC127419A999939474F584166666666E8C12741000000A0454F5841CDCCCCCCDAC12741666666A6444F584133333333B9C1274133333333424F58419A999999A4C127419A999939414F58413333333394C1274166666606414F5841333333338CC1274166666686404F58419A99999985C127419A9999D93F4F5841CDCCCCCC82C12741CDCCCCEC3D4F58419A99999982C127419A9999F93C4F58413333333383C127419A9999393C4F58413333333383C12741000000403B4F58410000000082C12741666666E63A4F5841333333337BC127419A9999F9394F5841CDCCCCCC71C127419A999919384F58416666666665C1274166666646364F5841333333335EC127419A999959354F58419A99999957C1274100000040344F58413333333351C127419A9999D9324F5841CDCCCCCC4CC12741CDCCCC6C314F5841666666664BC12741333333D32F4F5841CDCCCCCC49C12741666666C62D4F5841666666664AC12741000000002C4F5841CDCCCCCC4AC12741333333332A4F5841333333334BC1274166666666284F5841000000004EC1274133333333264F5841CDCCCCCC51C1274133333393244F5841CDCCCCCC56C1274166666646234F5841CDCCCCCC5CC12741000000A0214F58419A99999968C12741333333F31E4F5841000000006FC12741CDCCCC4C1D4F5841CDCCCCCC74C12741666666661B4F58413333333377C12741666666A6194F58419A9999997AC1274133333373174F5841333333337DC127419A999999154F58416666666680C127419A999959144F58416666666684C12741CDCCCCCC124F58410000000085C127419A9999F9104F5841CDCCCCCC85C12741000000600F4F58413333333383C12741000000000E4F58419A99999980C12741333333530C4F58413333333380C12741666666060B4F58410000000081C127419A999939094F58410000000080C1274133333333074F5841333333337AC1274100000080044F58410000000074C12741CDCCCC8C024F58419A9999996FC1274133333313014F58419A9999996AC1274166666666004F5841000000005EC12741666666E6FF4E58419A99999955C1274100000060FF4E5841333333334BC127419A9999B9FE4E58419A9999993EC1274100000040FE4E58410000000035C1274100000000FE4E5841000000002DC1274100000060FD4E5841CDCCCCCC28C1274166666626FD4E5841333333331EC1274100000040FC4E58413333333315C127419A999959FB4E58419A9999990DC12741000000A0FA4E58416666666604C12741333333D3F94E584133333333F6C0274133333313F94E5841CDCCCCCCEAC027419A999959F84E5841CDCCCCCCE0C02741666666A6F74E584166666666D3C0274166666666F74E584133333333C8C02741CDCCCC6CF74E584133333333C1C02741333333D3F64E58419A999999B8C0274100000000F64E584166666666AFC0274166666666F54E584133333333A3C02741CDCCCCCCF44E58416666666699C0274133333313F44E58413333333394C0274100000060F34E5841000000008CC027419A9999D9F24E58419A99999983C02741CDCCCCECF24E58419A9999997BC0274100000060F24E58419A9999996EC0274166666666F24E5841333333335CC0274100000040F24E58410000000056C027419A999999F14E5841666666664AC0274166666686F14E5841CDCCCCCC42C027419A9999F9F14E58419A99999937C02741CDCCCC4CF24E58413333333331C02741CDCCCC4CF24E58416666666623C0274100000020F24E58410000000018C02741666666C6F14E5841666666660DC0274166666626F14E58419A999999FDBF2741000000A0F04E5841CDCCCCCCEFBF2741CDCCCCCCF04E584166666666E6BF274166666666F14E584166666666DBBF27419A9999D9F14E584100000000CFBF274166666646F24E584166666666C7BF274133333393F24E58419A999999ACBF27419A9999F9F34E5841333333339CBF274100000020F54E5841CDCCCCCC88BF2741333333F3F54E58419A9999997BBF274133333333F64E58419A9999996CBF274100000040F64E58410000000062BF274166666646F64E58419A9999995BBF274166666646F64E58416666666650BF274166666646F64E58410000000041BF274133333313F64E58413333333337BF274133333313F64E58413333333325BF2741CDCCCCECF54E58413333333315BF2741000000C0F54E58419A99999901BF274100000060F44E5841CDCCCCCCF5BE274133333393F34E5841CDCCCCCCEEBE274166666626F34E584100000000E9BE2741333333B3F24E584100000000E3BE2741CDCCCCACF24E584166666666DCBE274100000000F34E58419A999999D1BE2741666666A6F34E584100000000C7BE27419A999979F44E584133333333BFBE27419A999939F54E584166666666B7BE274100000000F64E58419A999999B0BE274100000040F64E584133333333AABE274100000060F64E584100000000A3BE274166666666F64E5841CDCCCCCC98BE2741CDCCCC6CF64E5841666666667ABE274100000000F64E5841CDCCCCCC70BE2741666666E6F54E5841000000006BBE2741CDCCCC0CF64E58410000000064BE274100000020F64E5841333333335BBE2741000000E0F54E5841CDCCCCCC51BE2741CDCCCCACF54E58413333333348BE274133333373F54E5841666666663DBE274133333313F54E5841000000002FBE2741000000E0F44E58419A99999927BE2741CDCCCCECF44E58410000000020BE274133333393F44E58410000000016BE274133333333F44E5841333333330DBE2741000000C0F34E58416666666602BE27419A999939F34E58419A999999F7BD2741CDCCCCACF24E58419A999999EFBD274166666686F24E5841CDCCCCCCE6BD274100000040F24E58419A999999DCBD2741CDCCCCCCF14E58419A999999C6BD274133333333F14E584166666666A5BD2741CDCCCCECEF4E58413333333399BD274133333353EF4E58419A9999998FBD2741CDCCCC8CEE4E58410000000087BD27419A9999D9ED4E5841000000007EBD274166666626ED4E58416666666674BD2741CDCCCCCCEC4E58419A9999996ABD27419A999959EC4E58419A99999961BD274133333393EB4E5841666666665ABD27419A999919EB4E58419A99999947BD2741CDCCCCCCEA4E58413333333346BD2741666666C6EA4E5841CDCCCCCC3EBD2741CDCCCCCCEA4E58416666666632BD274100000020EA4E58413333333326BD27419A999999E94E58419A99999914BD2741333333B3E94E58410000000005BD274133333353EA4E584166666666F0BC2741000000C0EA4E5841CDCCCCCCE6BC2741000000C0EA4E58419A999999D8BC274166666646EA4E58419A999999CEBC2741CDCCCC8CE94E5841CDCCCCCCC3BC27419A9999D9E74E584166666666BDBC274166666646E54E584133333333BEBC27419A999959E04E584166666666C5BC2741666666E6DC4E584166666666D2BC274166666646D84E584133333333E3BC27419A999999D44E5841CDCCCCCCE7BC2741CDCCCC6CD24E584100000000E8BC2741CDCCCC6CD04E584133333333E2BC27419A999999CE4E58419A999999D0BC2741CDCCCC0CCD4E584166666666C2BC274133333393CB4E584133333333B4BC27419A9999D9C84E584133333333AABC2741333333D3C64E5841333333339CBC2741CDCCCC6CC54E58419A9999998EBC27419A999919C54E58410000000080BC274166666646C54E58413333333372BC274166666626C64E58416666666661BC274133333333C74E58413333333354BC274166666666C74E58416666666643BC2741333333F3C64E58416666666638BC2741CDCCCCECC54E5841666666662EBC2741CDCCCC0CC44E58419A99999927BC2741333333B3C14E58413333333321BC274133333373BF4E5841CDCCCCCC1ABC2741333333F3BC4E58419A99999910BC274100000000BB4E5841CDCCCCCC05BC274100000020BA4E584133333333F4BB2741000000A0B94E584100000000E3BB27419A999939B94E584100000000CFBB2741000000E0B84E584166666666B9BB2741000000A0B84E584166666666A6BB2741CDCCCC8CB84E58419A99999995BB274133333353B84E58416666666657BB2741333333B3B54E58413333333343BB274166666666B34E5841CDCCCCCC37BB27419A9999F9AF4E5841CDCCCCCC33BB2741CDCCCCECAB4E58416666666638BB274100000000A84E5841333333333CBB2741333333D3A54E5841666666665DBB2741333333739E4E5841CDCCCCCC7BBB274133333393944E584100000000A2BB2741666666E6874E58419A999999E6BB2741000000A0744E5841CDCCCCCC0DBC2741333333F3674E5841CDCCCCCC30BC27419A999939594E5841666666661ABC2741000000A0584E5841CDCCCCCCF9BB2741666666C6564E58419A999999EABB2741CDCCCC4C544E58419A999999E1BB2741333333B3504E5841CDCCCCCCDDBB2741CDCCCCAC4C4E584100000000C3BB2741CDCCCC2C484E5841666666669DBB2741666666C6444E5841CDCCCCCC6CBB2741333333F3424E5841666666662EBB2741CDCCCC8C424E58416666666610BB274166666606414E58410000000000BB2741CDCCCC8C3E4E5841CDCCCCCCFABA2741000000403B4E58419A999999FFBA274100000020384E58416666666600BB2741000000C0334E584166666666F2BA274133333333304E58419A999999C2BA2741000000A02A4E58410000000080BA27419A9999D9254E58419A9999994CBA27419A999939214E584100000000FDB9274166666686164E58419A999999AFB92741333333530A4E58419A99999971B9274100000080014E5841333333333AB92741666666A6F64D58416666666624B9274166666666EE4D58419A9999991FB92741CDCCCCACE04D58410000000021B9274100000020D24D58419A9999993AB927419A9999B9C64D5841CDCCCCCC43B9274100000000BB4D5841000000003CB9274133333353B64D58419A99999921B92741666666C6B24D58410000000016B92741333333F3AD4D5841CDCCCCCCFCB82741CDCCCC0C994D584133333333EFB82741CDCCCC2C864D5841CDCCCCCCF5B82741CDCCCCAC774D584166666666EAB82741000000C0734D584100000000C2B82741666666A66E4D5841CDCCCCCCA3B827419A9999796A4D58419A99999999B8274166666686674D58416666666699B8274166666606654D5841666666669AB82741CDCCCCAC624D584166666666A0B8274133333353604D584100000000C3B8274100000020594D58413333333324B92741CDCCCC8C454D58419A99999933B92741000000603B4D58416666666636B9274100000080304D58419A99999939B92741333333D3254D58416666666654B92741CDCCCC8C1A4D5841666666667FB92741000000200F4D58419A999999BFB9274133333393004D58419A999999CFB92741000000C0F84C58419A999999E9B927419A9999D9E94C584133333333CDB927419A999999E74C584166666666BEB92741CDCCCC8CE64C58419A999999A3B92741CDCCCC6CE54C58416666666692B92741CDCCCC8CE44C58416666666686B927419A9999F9E34C58413333333373B927419A9999B9E34C58419A9999995FB9274166666666E34C58413333333349B9274100000000E34C5841CDCCCCCC2FB9274166666666E24C5841000000001EB92741666666E6E14C58410000000015B927419A999939E14C5841666666660CB92741000000A0E04C58419A99999905B9274166666646E04C584133333333FFB82741CDCCCC4CE04C584100000000F9B82741CDCCCCCCE14C5841CDCCCCCCF2B82741CDCCCCECE24C5841CDCCCCCCE9B82741CDCCCC0CE44C5841CDCCCCCCE3B8274166666606E54C584133333333D9B8274166666646E64C58419A999999D1B827419A9999F9E64C58419A999999B9B82741666666C6E94C584166666666AAB8274166666646EB4C5841666666669BB827419A9999D9EC4C5841CDCCCCCC8FB82741000000A0EE4C58413333333380B82741CDCCCC6CF04C58410000000074B82741CDCCCC0CF24C58410000000066B827419A999979F34C5841000000005DB82741666666E6F44C5841000000004FB827419A999979F64C5841CDCCCCCC42B8274133333333F84C58419A9999993BB82741666666E6F94C58419A99999934B8274100000080FB4C58419A9999992DB8274166666646FD4C58413333333324B82741CDCCCCCCFE4C58419A99999918B8274133333373004D5841CDCCCCCC0DB82741CDCCCC4C014D58410000000002B8274100000060024D58419A999999ECB7274100000000054D58419A999999D9B727419A999919074D584100000000CBB72741000000E0084D58419A999999BDB72741000000000B4D5841CDCCCCCCACB72741666666060D4D58419A9999999FB72741333333530E4D5841666666668FB72741666666A60F4D58410000000079B7274166666666114D58410000000068B727419A9999B9124D58416666666658B7274166666686144D58419A99999947B72741CDCCCCAC164D58410000000037B727419A9999D9184D58410000000028B72741666666A61A4D5841CDCCCCCC1AB72741000000601C4D5841666666660CB727419A9999F91D4D584166666666FEB62741666666261F4D584100000000E7B627419A9999F9204D584100000000D8B6274100000040224D58419A999999C9B62741000000C0234D5841CDCCCCCCBEB62741666666E6244D584133333333B5B62741000000C0254D584100000000AAB6274100000020264D58419A99999998B62741333333B3264D58413333333382B6274133333353264D58419A9999996EB62741CDCCCC2C264D58410000000051B627419A999939264D5841666666663FB627419A999939264D58419A99999927B6274100000040264D58410000000010B6274100000060264D584133333333FCB52741000000A0264D5841CDCCCCCCECB52741CDCCCCAC264D584100000000D7B52741CDCCCCCC264D5841CDCCCCCCC8B5274166666646274D584166666666B9B5274100000000284D58419A999999A9B527419A9999D9284D5841333333339CB52741CDCCCCAC294D5841000000008EB52741CDCCCC2C2A4D58413333333385B52741666666662A4D58419A99999978B52741000000802A4D5841333333336CB52741000000602A4D5841CDCCCCCC5EB52741CDCCCC4C2A4D58410000000052B52741333333132A4D58419A99999945B52741666666C6294D58419A99999938B52741000000C0294D58419A9999992EB527419A9999B9294D58419A99999922B5274166666686294D58419A99999917B5274133333373294D58419A99999909B52741CDCCCC6C294D584166666666FEB42741333333B3294D584100000000F4B42741CDCCCCEC294D5841CDCCCCCCEDB42741000000202A4D5841CDCCCCCCE1B42741666666262A4D58419A999999DAB427419A9999192A4D584166666666CDB427419A999999294D584133333333B6B42741000000E0284D58419A999999A9B42741CDCCCCAC284D5841333333339FB42741333333F3284D58419A99999996B4274133333373294D58410000000091B427419A999999294D58410000000089B42741000000C0294D58419A9999997EB42741000000402A4D58416666666674B42741000000602A4D5841CDCCCCCC68B42741CDCCCC4C2A4D5841000000005DB42741333333132A4D58416666666653B42741333333D3294D5841CDCCCCCC4AB42741333333B3294D58416666666641B42741666666A6294D58410000000037B42741333333D3294D5841333333334AB3274166666666284D5841333333337DB22741666666862E4D584133333333FBB12741CDCCCC2C2C4D58416666666696B12741000000402B4D5841CDCCCCCCACB02741666666C6354D58416666666676B02741000000E0364D58416666666659B0274166666666374D58410000000037B02741CDCCCC6C374D5841000000001AB02741CDCCCCCC364D584166666666D2AF2741CDCCCC2C364D584133333333BFAF274133333373394D5841CDCCCCCCA1AF274166666606454D58413333333390AF274133333353474D5841000000006EAF2741CDCCCCCC4B4D5841000000004CAF27419A9999F9504D5841CDCCCCCC20AF274133333353534D5841666666660CAF274100000000574D58419A999999FEAE2741333333135A4D584100000000F4AE2741666666665C4D584166666666EEAE27419A9999F95D4D584133333333E8AE2741666666C65F4D584100000000E3AE274100000000624D584133333333DDAE2741000000A0634D584133333333D3AE2741333333B3644D5841CDCCCCCCCCAE274166666626654D584133333333C6AE2741000000A0654D58419A999999B6AE274100000080664D584100000000ABAE27419A9999F9694D58416666666696AE2741666666866D4D58416666666683AE274133333353704D58413333333375AE2741CDCCCC0C734D58416666666666AE274166666626764D58410000000047AE2741666666A67A4D58419A9999993AAE2741000000407D4D5841666666662EAE274133333393804D5841666666661AAE274133333393834D58416666666606AE274100000000874D584166666666E7AD2741333333538C4D584100000000D0AD2741000000A0904D584133333333BDAD274133333373944D58419A999999AEAD27419A999959984D5841CDCCCCCC94AC274166666686A54D584166666666E1AB2741333333F3AB4D584100000000DEAB274166666646B94D58419A999999DCAB2741CDCCCC6CBF4D5841CDCCCCCCDBAB2741333333B3CC4D584133333333DDAB27419A999919CE4D584100000000DEAB27419A999959CF4D584166666666DEAB2741333333B3D04D5841CDCCCCCCDCAB2741CDCCCC6CD24D58419A999999DCAB274166666606D44D584166666666DCAB2741000000C0D54D5841CDCCCCCCDCAB274133333333D74D58419A999999DDAB2741333333B3D84D584133333333DEAB2741333333B3DA4D5841CDCCCCCCDFAB274166666686DC4D58419A999999E0AB274133333353DE4D5841CDCCCCCCE1AB274166666646E04D5841CDCCCCCCE1AB27419A999999E14D584133333333E0AB2741CDCCCC8CE34D584166666666DCAB2741CDCCCC4CE54D584100000000D8AB27419A999919E74D58419A999999C6AB2741000000A0EC4D58419A999999B3AB27419A9999D9F04D5841CDCCCCCCAAAB27419A999959F34D584100000000A8AB27419A999959F44D584100000000A7AB27419A9999D9F54D58419A999999A6AB2741CDCCCCCCF64D5841CDCCCCCCA7AB274100000060F84D58419A999999ACAB2741CDCCCC2CFB4D5841CDCCCCCCB0AB2741CDCCCCECFD4D5841CDCCCCCCB2AB274133333313004E584133333333B3AB27419A999939014E584100000000B3AB274133333393024E58419A999999B0AB2741333333D3034E584166666666ADAB274166666666054E584133333333A9AB2741666666A6064E5841CDCCCCCC8BAB2741333333130C4E5841000000006EAB274100000020124E5841666666665BAB2741000000E0154E58419A99999948AB2741000000601B4E58410000000035AB274100000060204E5841666666662AAB274133333393244E58419A99999926AB2741CDCCCC4C274E58410000000025AB27419A9999992A4E58410000000012AB2741000000C02E4E58410000000007AB2741CDCCCCAC314E58413333333301AB2741000000E0344E584133333333FFAA2741CDCCCCAC374E584133333333FDAA2741333333933A4E584133333333FAAA2741000000E03C4E584100000000F8AA2741CDCCCCCC3D4E5841CDCCCCCCF4AA2741333333F33E4E584133333333EFAA27419A9999D93F4E5841CDCCCCCCE7AA2741CDCCCCCC404E584133333333DBAA274166666606424E584133333333CEAA2741000000C0424E584100000000C3AA27419A999939434E584100000000B9AA274100000060434E5841CDCCCCCCB1AA274166666646434E584133333333A0AA2741666666A6424E5841CDCCCCCC89AA274166666686424E5841CDCCCCCC74AA274100000040424E58413333333369AA2741CDCCCC4C424E58419A9999995EAA2741000000A0424E58419A99999931AA27419A999919454E5841CDCCCCCC14AA274166666606474E58410000000010AA274166666666474E584100000000FBA9274166666666494E584100000000B8A927419A999939554E5841CDCCCCCC88A92741CDCCCC2C594E58419A99999966A92741CDCCCC8C614E58410000000053A92741666666666A4E58419A9999994DA92741CDCCCC4C714E58416666666644A92741CDCCCC0C774E5841CDCCCCCC2BA92741333333D3964E5841CDCCCCCCECA82741CDCCCCAC9B4E584166666666A2A82741CDCCCC6CA14E5841333333334FA82741666666A6AA4E58416666666627A8274166666606B34E58419A9999991CA8274100000080B64E5841000000007CA8274100000080C04E584166666666C7A8274166666606C74E58413333333304A92741CDCCCC6CD34E58413333333319A9274166666666E14E58410000000006A927419A999919EA4E584133333333CBA82741333333F3FC4E584166666666B8A82741333333730E4F5841CDCCCCCC60A8274166666646304F58413333333345A8274166666626424F5841333333338BA82741666666A6424F58419A9999996AA92741333333D3424F58419A9999995EA92741CDCCCC0C494F5841666666665DA92741666666A64F4F5841666666665CA927419A999979554F58416666666659A92741666666E6614F58410000000022A9274133333313654F58410000000015A927419A999939664F5841CDCCCCCC09A92741333333F3664F584100000000FFA8274133333333684F58419A999999F6A82741CDCCCC4C694F584166666666F0A82741666666466A4F584133333333EBA82741CDCCCCCC6B4F58419A999999E4A82741000000406D4F58419A999999DEA82741CDCCCC2C6E4F584133333333C2A82741CDCCCCCC6F4F584100000000A0A82741CDCCCCEC714F58413333333377A82741CDCCCC4C744F5841000000006EA827419A9999F9744F5841CDCCCCCC67A82741666666A6754F5841CDCCCCCC61A82741CDCCCC6C764F5841333333335DA82741CDCCCC8C774F58419A9999995AA82741CDCCCCAC784F58419A99999959A82741CDCCCC4C794F58413333333353A827419A9999597A4F5841333333334BA827419A9999397A4F58410000000045A827419A9999F9794F5841333333333FA82741666666C6794F58413333333337A82741666666067A4F5841CDCCCCCC30A82741CDCCCC6C7A4F58416666666628A82741666666067B4F5841666666661BA82741CDCCCCAC7B4F5841000000000AA82741CDCCCCEC7C4F5841CDCCCCCCF3A72741333333137E4F5841CDCCCCCCE7A72741CDCCCC4C7E4F584100000000D6A72741CDCCCCCC7E4F584166666666BEA72741333333D37F4F584166666666A0A72741CDCCCC6C814F5841CDCCCCCC8DA72741000000A0824F5841CDCCCCCC6CA727419A999939864F58419A9999991DA72741333333738D4F5841000000001BA72741333333B38D4F584100000000FFA627419A9999B9904F584133333333DFA627419A9999F9944F58419A999999C4A6274166666626984F58419A999999AFA62741333333939A4F58410000000097A62741666666A69C4F58410000000080A62741333333B39E4F58419A99999960A627419A999959A24F58416666666646A6274166666686A44F58419A99999934A627419A999979A64F58419A99999919A62741CDCCCCECA84F5841CDCCCCCC10A62741666666A6A94F5841CDCCCCCC0BA6274133333333AA4F5841CDCCCCCC02A62741CDCCCC4CAB4F5841CDCCCCCCF2A52741CDCCCC8CAD4F58419A999999E9A527419A999999AE4F5841CDCCCCCCE2A5274166666646AF4F58419A999999DDA52741666666C6AF4F5841CDCCCCCCD7A5274100000060B04F584100000000D3A5274100000000B14F584166666666CEA5274166666606B34F584133333333E1A52741CDCCCCCCB34F584166666666E6A52741CDCCCC6CB44F584100000000EBA52741CDCCCC0CB54F584166666666EEA5274166666686B54F58419A999999F1A5274166666686B64F5841CDCCCCCCF3A5274133333353B74F58419A999999F8A5274100000000B84F58419A999999FDA527419A9999D9B84F58419A99999901A62741666666E6B94F58416666666606A62741000000E0BA4F5841666666660CA6274133333333BC4F58410000000014A627419A999939BD4F5841CDCCCCCC1AA6274166666666BE4F58419A9999991FA62741CDCCCC6CBF4F58413333333323A627419A999999C04F58419A99999924A62741333333D3C14F58416666666627A62741666666C6C34F58419A99999928A627419A9999D9C44F58419A9999992DA62741000000E0C54F5841CDCCCCCC30A62741CDCCCCCCC64F58413333333333A62741333333D3C74F58416666666634A62741333333D3C84F58419A99999933A62741CDCCCCECC94F58413333333331A62741CDCCCC2CCB4F58419A9999992EA62741333333F3CB4F5841CDCCCCCC2FA62741000000A0CC4F58413333333333A6274100000020CE4F5841CDCCCCCC36A627419A999959CF4F58410000000038A62741000000C0D04F58410000000038A62741000000A0D14F5841000000003BA6274133333353D24F58416666666640A62741000000E0D24F58410000000046A62741666666E6D34F5841CDCCCCCC48A62741000000A0D44F58419A9999994DA62741CDCCCC8CD54F58419A99999953A6274100000040D64F5841666666665CA627419A9999D9D74F5841CDCCCCCC62A62741CDCCCCECD84F5841000000006AA627419A9999D9D94F58419A99999972A6274100000020DB4F5841CDCCCCCC7AA627419A999979DC4F58410000000086A627419A999919DE4F5841CDCCCCCC8DA627419A9999F9DE4F58410000000094A627419A999959DF4F584133333333A0A62741CDCCCCACDF4F584133333333A7A6274166666606E04F5841CDCCCCCCABA62741666666E6E04F584133333333B1A6274166666606E24F584100000000B8A62741000000A0E34F58419A999999BCA6274100000060E44F5841CDCCCCCCC0A627419A999919E54F58419A999999C7A62741CDCCCCCCE54F584100000000D4A62741000000E0E84F58419A999999D8A627419A9999F9E94F584100000000E2A627419A999999EC4F584166666666E3A6274133333353ED4F5841CDCCCCCCE3A6274100000000EE4F584133333333E5A62741666666A6EE4F584166666666E7A6274100000040EF4F584133333333EEA6274133333313F04F584133333333F5A62741333333F3F04F584133333333FBA627419A999999F14F5841CDCCCCCCFCA62741CDCCCCCCF14F5841333333330EA7274166666686F34F58416666666619A72741666666E6F34F5841CDCCCCCC2CA727419A999999F54F58416666666636A7274133333353F64F5841CDCCCCCC3EA72741CDCCCC0CF74F58419A99999947A72741000000E0F74F5841666666664FA72741000000C0F84F58410000000056A7274133333393F94F5841666666665EA7274133333333FA4F58410000000067A72741666666C6FA4F5841333333336FA7274133333313FB4F58419A99999975A727419A999939FB4F5841666666667CA7274133333393FB4F5841CDCCCCCC7DA7274133333313FC4F5841CDCCCCCC7DA727419A9999F9FC4F5841666666667CA727419A9999F9FD4F5841CDCCCCCC7BA7274133333353FF4F58413333333381A72741666666C6FF4F5841CDCCCCCC84A727419A99995900505841CDCCCCCC87A72741333333F300505841666666668BA72741000000E0015058419A9999998DA727419A99999902505841CDCCCCCC8FA7274166666606035058413333333392A727419A9999590350584133333333A0A72741CDCCCC2C045058419A999999A7A72741CDCCCCAC045058419A999999AAA72741000000E00450584100000000B8A72741333333D30550584133333333BEA7274133333313065058419A999999C9A727416666666606505841CDCCCCCCD4A72741000000A006505841CDCCCCCCE0A72741CDCCCCAC0650584166666666EAA72741333333B30650584133333333F7A72741000000C0065058413333333301A82741666666C606505841666666660BA82741333333D3065058410000000013A827416666662607505841666666661BA82741666666A6075058416666666623A827419A999939085058419A9999992FA827410000000009505841CDCCCCCC3BA82741CDCCCCEC095058413333333346A82741333333F30A505841000000004EA82741CDCCCCAC0B5058413333333356A827419A9999390C5058419A99999960A82741CDCCCCAC0C5058419A9999996AA827419A9999F90C5058416666666677A827419A9999390D505841CDCCCCCC80A82741333333930D505841CDCCCCCC8DA82741000000E00D5058416666666698A82741000000800E50584133333333A3A82741CDCCCC2C0F50584166666666ACA82741666666C60F50584100000000BAA82741666666661050584133333333C1A82741CDCCCC0C1150584100000000D8A82741666666C61350584133333333F6A82741666666A6175058416666666610A92741333333331B5058419A99999919A92741666666061D505841000000001EA92741333333131E5058413333333324A92741666666261F5058416666666629A9274166666646205058416666666631A92741CDCCCC4C21505841666666663AA9274166666666225058416666666643A927416666664623505841333333334CA92741CDCCCCEC235058410000000057A92741000000C024505841666666665EA927419A999939255058413333333365A92741000000A025505841333333336CA9274166666606265058413333333370A92741CDCCCC4C265058410000000078A92741000000A0265058419A9999997CA9274166666626275058413333333381A92741666666E6275058410000000087A92741000000A028505841000000008BA92741CDCCCC2C295058419A9999998EA92741666666A62A5058419A99999999A92741CDCCCC8C2B50584100000000A0A92741333333D32C50584166666666A2A927419A9999992D50584133333333A4A92741CDCCCC8C2E505841CDCCCCCCA8A92741333333D32F50584133333333ADA927419A9999F9305058419A999999B2A92741666666063250584166666666BAA92741000000403350584133333333C4A92741CDCCCCAC3450584100000000CEA92741CDCCCCEC3550584133333333DAA92741666666463750584133333333E2A9274100000020385058419A999999EEA9274100000020395058419A999999F6A927419A9999B939505841CDCCCCCC02AA2741333333133A505841000000000AAA2741666666263A505841000000001BAA2741000000603A505841666666661FAA2741333333933A5058413333333326AA27419A9999993B505841CDCCCCCC29AA2741666666463C5058413333333330AA27419A9999F93C5058419A99999936AA2741333333733D505841000000003EAA2741CDCCCCEC3D5058416666666646AA27419A9999F93D505841333333334FAA2741666666C63D505841666666665BAA2741000000E03D5058410000000062AA27419A9999193E505841CDCCCCCC68AA27419A9999793E5058410000000074AA2741CDCCCCEC3E505841000000007BAA2741333333D33E5058419A99999984AA2741333333533E505841CDCCCCCC8BAA27419A9999B93D5058410000000095AA2741666666263D505841333333339FAA27419A9999593C50584100000000A6AA27419A9999993B50584133333333ADAA2741000000803B50584166666666B6AA2741666666C63B505841CDCCCCCCBAAA2741333333D33B505841CDCCCCCCC3AA27419A9999B93B50584133333333CCAA2741CDCCCCAC3B50584133333333D7AA27419A9999793B505841CDCCCCCCE1AA2741CDCCCC4C3B50584166666666ECAA2741333333933B50584133333333F9AA2741CDCCCCEC3B5058419A99999903AB2741000000203C505841666666660EAB2741333333333C505841666666661EAB2741CDCCCC2C3C5058413333333326AB2741666666263C5058419A99999939AB2741CDCCCC4C3C505841CDCCCCCC42AB27419A9999393C505841333333334BAB2741CDCCCC6C3C505841CDCCCCCC59AB27419A9999793C505841333333335CAB2741000000803C5058419A9999996AAB2741000000A03C5058410000000072AB2741666666863C5058410000000077AB2741666666A63C505841000000007CAB2741CDCCCCCC3C5058413333333381AB27419A9999193D5058413333333386AB2741CDCCCC8C3D505841000000008DAB2741333333733E5058416666666690AB2741CDCCCC0C3F505841000000009AAB2741CDCCCC6C3F50584133333333A0AB2741666666C63F5058419A999999A6AB2741CDCCCC2C4050584133333333ADAB27419A99997940505841CDCCCCCCB1AB27419A9999B940505841CDCCCCCCB6AB2741000000C040505841CDCCCCCCBBAB2741000000A04050584100000000C2AB274133333313405058419A999999C7AB2741333333933F50584100000000CDAB2741000000603F505841CDCCCCCCD4AB2741333333333F505841CDCCCCCCD9AB2741000000403F50584133333333DFAB2741000000803F5058419A999999E4AB2741CDCCCC4C4050584166666666EDAB274166666686415058419A999999FCAB274100000080445058416666666608AC2741CDCCCCCC46505841333333330EAC2741333333B3475058416666666613AC27410000008048505841000000001FAC27416666666649505841000000002CAC2741000000804A5058416666666632AC27419A9999194B5058410000000037AC2741000000604B5058419A9999993EAC2741333333B34B5058419A99999943AC2741333333134C5058419A99999947AC27419A9999B94C505841333333334AAC2741666666464D505841CDCCCCCC4EAC2741333333334E505841CDCCCCCC4FAC2741CDCCCC0C4F5058419A99999950AC27419A9999D94F5058413333333355AC27419A9999D9515058416666666657AC2741000000C0525058419A99999958AC27419A999999535058416666666659AC274100000080545058413333333359AC274166666646555058410000000059AC2741000000C0565058419A99999958AC2741666666C6575058410000000059AC27416666668658505841CDCCCCCC59AC274133333373595058419A9999995BAC2741666666665A5058419A9999995CAC2741333333135B505841000000005FAC2741CDCCCC4C5C5058413333333363AC2741CDCCCC4C5D5058413333333367AC2741000000005E505841000000006FAC2741CDCCCCCC5E5058410000000079AC2741333333735F5058410000000081AC2741CDCCCC0C60505841666666668BAC27410000000061505841666666668FAC27419A9999B9615058413333333395AC2741CDCCCC8C625058419A9999999BAC2741000000606350584100000000A5AC2741CDCCCC2C6450584100000000AFAC2741333333136550584166666666B9AC27413333331366505841CDCCCCCCCBAC2741666666266850584100000000D5AC27413333331369505841CDCCCCCCD9AC27419A999959695058419A999999E3AC274133333353695058419A999999F7AC27410000002069505841CDCCCCCC06AD2741CDCCCC0C695058419A9999990FAD274100000080685058413333333315AD2741CDCCCC6C68505841CDCCCCCC1BAD274133333353685058413333333323AD27419A9999F967505841666666662AAD274166666666675058410000000034AD27419A99993966505841000000003BAD2741666666C6645058419A99999940AD274100000000645058410000000048AD27416666660663505841CDCCCCCC4EAD274166666626625058419A99999955AD2741666666A6615058419A9999995DAD27419A9999F9605058419A99999962AD274100000080605058419A9999996CAD27419A999959605058410000000075AD274100000000605058419A9999997EAD2741333333935F5058419A99999987AD2741000000405F5058419A9999998EAD2741333333135F5058419A9999999AAD2741CDCCCC0C5F50584100000000A3AD2741333333335F5058419A999999ACAD2741000000A05F50584166666666B5AD2741666666066050584133333333BEAD2741666666666050584100000000C5AD27419A999979605058419A999999C8AD274133333373605058419A999999CFAD2741333333B360505841CDCCCCCCD6AD27419A9999D96050584166666666DDAD27419A9999B96050584166666666E2AD27419A9999396050584100000000E8AD2741666666865F50584100000000EEAD2741000000005F505841CDCCCCCCF3AD2741666666A65E50584100000000FBAD27419A9999995E505841CDCCCCCC04AE2741666666E65E5058419A99999911AE2741CDCCCCAC5F505841CDCCCCCC39AE2741666666C6625058419A99999942AE2741666666C663505841000000004BAE27419A999979645058410000000053AE2741333333F3645058416666666660AE27416666664665505841000000006BAE2741666666C6655058413333333374AE2741CDCCCC8C665058419A9999997CAE274133333373675058419A99999984AE27416666666668505841000000008DAE2741CDCCCC4C69505841CDCCCCCC92AE2741000000C0695058413333333398AE27419A9999F96950584166666666A0AE2741333333F36950584166666666A7AE2741333333D369505841CDCCCCCCAEAE27419A9999F96950584133333333B5AE27419A9999796A50584100000000BDAE2741000000206B50584133333333C6AE2741333333F36B5058419A999999CEAE2741666666866C5058419A999999D5AE2741333333F36C50584133333333DEAE2741CDCCCCAC6C50584100000000E8AE2741333333F36B50584133333333F2AE27419A9999596B5058419A999999FCAE27419A9999D96A505841CDCCCCCC01AF27419A9999B96A5058419A99999907AF2741333333336B505841CDCCCCCC0EAF27419A9999D96B5058410000000015AF2741333333336C505841666666661CAF2741000000406C5058416666666625AF2741CDCCCCEC6B5058416666666632AF2741000000806B5058419A99999940AF2741000000006B5058413333333352AF2741333333336A5058419A9999995DAF2741CDCCCCAC69505841333333336BAF27419A9999B968505841CDCCCCCC71AF27419A99991968505841333333337BAF27419A9999D9665058419A99999982AF2741333333D3655058419A99999987AF27419A99991965505841333333338FAF27419A99999964505841666666669AAF27419A9999D96350584133333333A7AF27419A999979635058419A999999B2AF2741CDCCCC6C6350584133333333BEAF27410000006063505841CDCCCCCCC4AF2741CDCCCC2C635058419A999999CBAF274100000000635058419A999999D8AF2741CDCCCCCC6250584166666666EAAF2741000000A06250584133333333F8AF274166666666625058413333333303B0274100000020625058419A99999909B02741333333B361505841333333330DB02741666666A660505841CDCCCCCC0EB02741666666865F5058410000000011B02741333333535E5058416666666616B02741000000205D505841000000001DB02741CDCCCC4C5C5058413333333326B02741CDCCCCEC5B5058416666666630B02741666666C65B5058419A9999993DB02741CDCCCC0C5C5058419A99999948B02741666666665C5058416666666655B02741333333935C5058410000000062B02741000000805C505841000000006DB027419A9999195C505841CDCCCCCC7AB02741333333535B5058410000000081B02741000000E05A5058413333333388B02741000000A05A5058416666666694B027419A9999F95A5058419A9999999EB02741CDCCCC0C5B50584133333333A9B027419A9999995A5058419A999999B6B02741000000C0595058419A999999C5B02741CDCCCC6C5950584100000000D3B027419A9999595950584100000000EFB02741CDCCCC8C5850584166666666FEB02741CDCCCC2C585058416666666607B12741CDCCCC0C58505841333333330DB12741666666C6575058413333333314B127413333335357505841CDCCCCCC1AB127419A999999565058419A9999991FB12741CDCCCCCC55505841333333332DB127416666666654505841CDCCCCCC39B12741CDCCCCCC535058410000000045B127416666668653505841666666664EB1274100000040535058410000000061B127419A9999B9525058419A99999969B1274100000060525058413333333377B12741CDCCCC0C525058419A9999997FB12741333333D351505841333333338CB12741CDCCCCAC515058413333333393B127416666668651505841333333339FB127419A99997951505841CDCCCCCCAAB12741000000A05150584166666666B6B12741666666E65150584100000000C2B127413333335352505841CDCCCCCCCDB12741666666A65250584100000000DAB12741000000E052505841CDCCCCCC02B227419A999919535058419A99999916B227419A999959535058419A99999922B22741000000A053505841333333332BB22741000000E0535058419A99999935B2274100000060545058413333333341B227419A99993955505841CDCCCCCC49B2274100000000565058416666666650B22741000000A0565058416666666656B227413333333357505841333333335BB22741000000A0575058419A99999963B22741CDCCCCEC575058413333333379B227419A9999795850584133333333A8B22741CDCCCCCC5950584166666666C9B22741666666665A50584133333333D7B22741000000605A5058419A999999DEB22741000000605A505841CDCCCCCCF2B22741000000A0595058419A999999F5B227416666668659505841000000000AB32741000000C0585058416666666631B32741000000A058505841CDCCCCCC3CB32741666666C6585058416666666655B32741333333D3585058416666666663B32741333333B358505841CDCCCCCC73B3274133333373585058413333333383B327413333333358505841CDCCCCCCACB327419A99997957505841CDCCCCCCB6B327419A9999595750584100000000C3B32741000000605750584100000000CEB32741333333535750584100000000D8B32741CDCCCC6C5750584166666666E3B327419A9999795750584100000000EEB32741CDCCCCAC575058410000000001B427416666668658505841CDCCCCCC09B427419A999919595058413333333311B42741CDCCCC8C595058419A99999925B427419A9999395A5058410000000032B42741CDCCCC8C5A5058419A9999993FB42741000000E05A505841333333334AB427419A9999195B5058413333333355B42741666666465B5058410000000060B42741666666465B505841CDCCCCCC69B42741CDCCCC2C5B505841CDCCCCCC72B42741000000005B505841666666667CB42741666666C65A5058419A99999987B427419A9999795A5058419A99999992B42741000000405A505841000000009EB427419A9999395A5058419A999999B0B42741000000205A50584166666666BEB42741000000205A50584166666666D1B427419A9999395A50584133333333E6B42741CDCCCC6C5A505841CDCCCCCCF3B42741666666A65A505841CDCCCCCCFFB427419A9999D95A505841333333330BB527419A9999F95A505841CDCCCCCC16B527419A9999395B5058413333333325B52741000000805B505841CDCCCCCC32B52741333333D35B505841000000003FB527419A9999395C505841000000004AB52741CDCCCCCC5C5058413333333355B52741333333935D5058419A9999995FB52741666666465E5058416666666668B527419A9999D95E5058410000000073B52741333333935F505841000000007CB527419A99995960505841CDCCCCCC80B52741CDCCCC2C615058416666666687B527413333337362505841000000008AB527416666664663505841CDCCCCCC8CB52741CDCCCC8C64505841333333338FB52741CDCCCCCC65505841CDCCCCCC92B5274133333393685058413333333396B52741000000806B5058416666666697B52741333333136D5058410000000099B52741000000206E505841000000009BB52741000000E06F505841333333339EB52741000000207150584100000000A0B52741CDCCCC4C72505841CDCCCCCCA1B52741000000607350584100000000A3B527416666666674505841CDCCCCCCA4B52741000000607550584100000000A8B527419A99997976505841CDCCCCCCABB527419A9999797750584100000000B0B52741CDCCCC2C7850584133333333B5B52741CDCCCC0C7950584166666666BDB527419A9999B97950584166666666C2B52741666666467A50584166666666C9B52741333333B37A5058419A999999CBB52741CDCCCC2C7B50584100000000CCB52741333333B37B50584100000000CCB52741666666467C50584166666666CCB527419A9999197D5058419A999999CDB52741000000E07D5058419A999999D1B52741CDCCCCAC7E505841CDCCCCCCD7B52741CDCCCC6C7F5058419A999999E0B527419A9999B97F5058419A999999E8B52741000000E07F505841CDCCCCCCEFB52741000000C07F505841CDCCCCCCF6B52741CDCCCC8C7F5058419A999999FCB527419A9999797F5058416666666601B62741333333937F5058419A99999907B62741000000E07F5058416666666610B6274166666646805058416666666618B627419A9999B9805058413333333320B6274133333333815058413333333329B62741000000C081505841CDCCCCCC30B62741CDCCCC4C825058410000000038B6274166666606835058413333333346B62741333333F3835058419A9999994EB627419A9999D9845058416666666654B627413333335385505841CDCCCCCC56B627416666668685505841000000005DB62741333333D385505841CDCCCCCC66B62741CDCCCC2C86505841333333336EB6274133333353865058410000000080B627413333337386505841CDCCCCCCA5B627419A9999198750584100000000B5B62741CDCCCC4C8850584100000000BEB627419A99999989505841CDCCCCCCCCB62741666666668A50584100000000D6B62741666666268B505841CDCCCCCCD6B62741666666268C5058419A999999D8B62741333333538E50584166666666DFB627413333333390505841CDCCCCCCF0B627419A99997992505841000000000FB72741CDCCCC0C95505841000000001FB72741CDCCCCEC965058413333333334B72741333333D399505841666666664BB72741CDCCCCAC9E5058419A9999994DB72741000000609F5058410000000057B7274166666646A25058413333333357B72741000000C0A3505841666666665AB7274166666606A5505841CDCCCCCC62B72741666666C6A65058416666666662B7274166666666A85058419A99999961B7274166666686AA5058413333333364B72741CDCCCCACAC5058413333333365B727419A9999B9AE5058419A99999960B72741CDCCCC4CB0505841333333335FB727419A999979B1505841333333335EB7274100000060B2505841CDCCCCCC67B7274166666666B8505841CDCCCCCC77B72741000000C0BD505841CDCCCCCC85B7274100000080C15058413333333388B7274100000040C25058416666666688B7274133333333C35058419A99999986B727419A999979C45058413333333371B727419A999919C95058419A9999996DB72741333333B3CB505841333333336CB72741333333B3CD505841CDCCCCCC6EB7274166666666CE5058416666666682B727419A999919D0505841000000008CB72741CDCCCC4CD05058416666666690B72741CDCCCCECD0505841CDCCCCCC8EB727419A999919D75058419A9999998AB72741CDCCCC2CDE505841666666668DB72741CDCCCC0CE25058410000000098B727419A999939E650584166666666ABB7274133333353E950584100000000C8B7274166666666EE50584133333333EBB7274100000080F35058419A999999FCB72741CDCCCC8CF7505841CDCCCCCC0FB827419A999999FB5058410000000012B82741333333D3FC5058419A99999918B827419A99991900515841CDCCCCCC22B827416666668602515841666666662FB827410000000004515841000000004CB827410000002006515841000000005FB82741333333530651584166666666A7B82741000000E00151584100000000E3B8274166666606FD5058419A999999FFB8274100000000FA5058419A99999920B9274100000020F95058416666666634B92741CDCCCCCCF75058410000000040B9274100000040F75058419A99999945B927419A999959F6505841CDCCCCCC4AB927419A9999D9F45058413333333354B9274133333333F35058416666666661B92741CDCCCC0CF25058419A99999969B9274133333313F25058419A99999982B927419A9999D9F5505841333333338AB92741000000A0F6505841CDCCCCCC91B927419A9999B9F650584166666666A5B927419A999959F65058419A999999ABB9274166666686F650584133333333B0B9274100000000F750584166666666CAB92741CDCCCCACFB50584100000000D9B92741CDCCCC8C0151584133333333EEB92741CDCCCCAC0451584100000000F5B92741666666A6055158419A999999FFB9274100000040085158419A999999FFB92741666666C6095158419A999999FAB92741333333530B51584100000000F8B92741666666660D51584166666666FEB92741666666C6135158419A999999FCB92741CDCCCC8C155158419A999999ECB927410000008018515841CDCCCCCCE3B927419A9999791A51584133333333E0B92741666666E61C515841CDCCCCCCDDB92741000000201F515841CDCCCCCCD3B92741CDCCCCAC20515841CDCCCCCCC7B927419A9999192451584100000000BFB92741000000A02951584100000000B6B92741CDCCCCAC30515841CDCCCCCCAFB92741000000A03451584133333333AFB92741CDCCCC6C3651584166666666B1B92741000000403751584133333333C4B92741CDCCCC4C3A515841CDCCCCCCD4B92741000000403E51584100000000D9B92741333333734051584100000000E1B92741CDCCCC6C415158416666666602BA27416666662643515841666666661FBA27413333335344515841CDCCCCCC31BA274100000000465158419A99999950BA2741CDCCCC8C4B5158413333333356BA2741000000E04F5158419A99999956BA2741000000C0545158413333333353BA2741333333B355515841CDCCCCCC45BA27419A99991957515841333333332FBA2741333333D35A5158413333333317BA274133333393615158419A99999910BA2741CDCCCC8C675158410000000014BA2741CDCCCC0C6B5158410000000029BA2741000000406E5158419A99999936BA27419A999959725158413333333345BA2741333333B3745158416666666660BA2741CDCCCCAC765158416666666678BA274100000060795158416666666689BA27419A9999997B515841000000008EBA2741666666C67B515841CDCCCCCCA0BA2741666666A67B51584133333333A8BA2741CDCCCC0C7C51584166666666ADBA27419A9999597F51584166666666B6BA274166666666805158419A999999BABA2741CDCCCCCC80515841CDCCCCCCCEBA2741000000C08351584100000000E6BA2741333333D384515841333333330DBB27416666664685515841666666662EBB27413333335385515841333333334BBB27416666668686515841000000006EBB27416666662688515841333333339BBB27419A9999B98851584100000000C9BB27419A999939885158419A999999DABB27419A9999B98851584100000000DEBB274166666626895158419A999999E1BB2741333333938B515841CDCCCCCCEABB2741666666E68C51584100000000FCBB2741333333F38D5158419A99999913BC2741666666868E515841000000002ABC2741CDCCCCAC8F5158416666666638BC274166666646915158416666666646BC2741CDCCCC0C955158410000000046BC27413333339398515841CDCCCCCC39BC2741333333339B515841CDCCCCCC08BC27419A9999199F5158419A999999BABB27419A9999F9A1515841333333334CBB27419A9999B9A45158419A99999909BB274100000020A651584133333333A5BA274166666686AB515841000000006EBA274100000060AF515841000000005FBA274133333353B2515841CDCCCCCC57BA274100000060B75158413333333362BA274166666626BB515841000000007BBA2741CDCCCC8CBC515841CDCCCCCCA4BA274133333373BE51584166666666C5BA274133333313C151584100000000D4BA274100000020C3515841CDCCCCCCD7BA2741CDCCCC6CC45158419A999999D5BA2741CDCCCC2CC7515841CDCCCCCCD9BA27419A9999B9C85158419A999999E6BA274100000000C951584100000000FFBA2741333333D3C95158419A9999990DBB274166666606CB5158419A99999923BB2741CDCCCC8CCE515841333333332EBB27419A9999B9CF515841333333333ABB2741333333F3D2515841CDCCCCCC4BBB2741666666E6D85158416666666652BB2741000000C0DB5158416666666652BB274100000080DE515841000000004EBB2741000000C0E05158413333333351BB274133333393E45158419A99999951BB2741666666A6E75158416666666655BB2741666666C6E8515841CDCCCCCC5BBB27419A9999B9E95158410000000068BB274133333393EB515841CDCCCCCC69BB274166666626ED515841CDCCCCCC66BB2741CDCCCC0CF65158419A99999967BB2741000000E0F9515841CDCCCCCC7DBB2741CDCCCC8C03525841666666669DBB2741CDCCCC8C0C52584100000000B2BB274166666686115258419A999999BCBB274166666686135258419A999999C4BB2741333333B31452584133333333D3BB27419A99991915525841CDCCCCCCEABB2741CDCCCCAC14525841CDCCCCCC17BC27419A999939135258416666666627BC274166666646135258410000000030BC27419A9999F912525841000000003DBC27419A999959115258419A9999994DBC2741CDCCCCEC0F525841666666665BBC2741333333130F5258410000000072BC2741CDCCCC0C0E5258419A99999997BC2741000000800C5258419A999999A8BC2741666666260B52584166666666BCBC2741CDCCCCCC0A52584133333333D9BC27419A9999190B52584166666666EDBC2741333333330C52584166666666F9BC2741000000A00D52584166666666FDBC2741CDCCCCAC0F52584100000000FBBC27410000004013525841CDCCCCCCFCBC274166666606165258410000000023BD2741000000201E5258416666666644BD274166666626265258410000000049BD274133333313285258416666666655BD2741333333132D5258419A99999984BD2741333333D334525841CDCCCCCC96BD2741CDCCCC2C3852584100000000ACBD27419A99999939525841CDCCCCCC9BBD2741666666863A5258413333333394BD2741333333F33A5258419A9999995CBD2741333333333E525841CDCCCCCC47BD2741333333333F5258413333333314BD2741CDCCCCAC3F525841CDCCCCCCF0BC27419A999939405258419A999999BBBC274100000000445258419A9999999FBC2741000000A045525841666666667CBC274133333393465258413333333363BC2741CDCCCC4C47525841CDCCCCCC34BC27419A9999194A525841000000000CBC2741333333534B52584133333333E3BB2741666666464D525841CDCCCCCCC7BB2741000000004E52584100000000A9BB27419A9999994E5258413333333391BB2741000000C04F525841CDCCCCCC76BB274100000080525258410000000055BB2741CDCCCC0C56525841666666662DBB2741CDCCCCCC58525841333333330CBB2741666666665B52584133333333E2BA2741666666065E525841CDCCCCCCD6BA27419A9999595E52584100000000D3BA2741666666065E5258419A999999D5BA2741666666E65B525841CDCCCCCCD1BA2741CDCCCC2C5B52584100000000C8BA27419A9999995A525841CDCCCCCCABBA2741CDCCCC2C5A5258419A9999996EBA2741CDCCCC0C595258419A9999993DBA2741666666A657525841CDCCCCCC00BA27419A99997956525841CDCCCCCCF0B92741666666865652584166666666D3B92741CDCCCCEC5652584100000000BDB927413333331358525841CDCCCCCCB4B92741CDCCCC4C5852584166666666A7B92741333333F3575258419A99999995B927419A99997957525841333333337CB92741333333B3575258413333333362B9274133333333595258419A9999995AB9274133333393595258410000000039B92741CDCCCC0C5A525841000000002DB92741333333D35A525841CDCCCCCC1EB92741000000605D5258410000000018B92741CDCCCCAC605258419A99999912B927413333337366525841CDCCCCCC0BB92741000000606B525841CDCCCCCC0EB927419A99991970525841666666660CB9274133333393705258413333333306B92741000000807152584133333333E7B82741333333D37452584100000000D4B827410000002076525841CDCCCCCCBFB827419A9999197852584100000000B2B82741CDCCCC8C7A525841666666669BB82741000000E07B5258416666666671B82741666666467D525841CDCCCCCC20B827413333335380525841CDCCCCCCFFB72741CDCCCC0C82525841CDCCCCCCE3B72741000000A08352584100000000B2B72741333333B38452584166666666A1B7274133333353855258413333333382B7274133333353865258413333333364B727419A999959875258410000000054B72741000000C0875258416666666636B72741CDCCCC4C875258419A99999915B72741CDCCCCAC875258419A999999FCB62741333333B38852584133333333E3B62741CDCCCCAC8A52584166666666CAB62741666666068B525841333333339EB62741CDCCCC8C8A525841333333337AB62741000000A08A5258410000000071B62741CDCCCCAC8A5258419A9999996BB62741333333538A525841CDCCCCCC60B627419A999999885258419A99999956B62741CDCCCCCC875258410000000047B62741CDCCCCCC87525841CDCCCCCC29B627419A9999F9875258413333333316B627419A999979875258413333333301B62741000000008652584100000000E4B52741666666A68252584100000000CEB52741666666268152584133333333BDB52741CDCCCC0C805258410000000072B52741000000A0765258413333333362B5274100000020735258416666666645B52741CDCCCCEC6E525841666666662FB52741666666666C525841666666661DB52741000000406B525841CDCCCCCCFEB427419A9999596A52584166666666E2B42741CDCCCC2C6A5258419A999999C6B42741000000E06952584133333333B2B427410000002068525841CDCCCCCCA6B42741CDCCCCAC675258419A99999994B42741666666E6675258410000000088B4274100000080685258419A9999997EB42741666666E6685258410000000069B42741CDCCCC6C68525841000000003AB4274100000020695258413333333326B42741CDCCCC2C6A525841333333330FB42741CDCCCC6C6D5258416666666602B42741333333136F52584166666666D1B32741000000C0705258419A999999A2B327419A99997970525841333333337EB327419A99993972525841CDCCCCCC5AB32741333333F375525841CDCCCCCC37B32741000000C078525841333333331BB327419A9999D97A525841666666660DB32741666666667B5258410000000007B32741666666067D5258416666666605B32741CDCCCC0C815258413333333305B3274166666686855258419A99999900B327419A9999398752584133333333FCB22741333333F38852584166666666FDB22741666666868B5258419A999999F8B22741666666A68C525841CDCCCCCCF1B22741000000C08D5258419A999999DEB22741666666069052584133333333D0B227419A9999199052584100000000C3B227419A9999D98F52584100000000B6B227419A9999198F525841CDCCCCCCADB22741000000408E5258410000000098B227419A9999598D5258416666666671B22741666666868D5258413333333359B227419A9999F98C5258419A9999994DB22741000000408C5258419A99999931B227419A9999398B525841333333330DB227419A9999598B52584166666666FDB12741CDCCCC4C8B52584133333333EBB12741CDCCCC6C8A525841CDCCCCCCC9B12741CDCCCCCC86525841CDCCCCCCC3B127419A9999B98552584100000000C0B12741666666C68352584133333333B0B12741666666068152584100000000A7B12741000000807F5258419A99999988B12741000000607D525841CDCCCCCC7EB12741CDCCCC4C7C5258416666666676B127419A9999997A525841CDCCCCCC6CB12741000000E0745258419A9999996BB12741666666E66F5258416666666667B12741000000606D5258413333333364B12741000000606B5258413333333363B127419A999959695258410000000067B127416666664665525841CDCCCCCC67B1274166666686635258416666666667B127410000006061525841000000006BB12741333333735E5258419A9999997AB12741CDCCCCAC58525841000000007AB127410000008057525841000000007AB127419A9999D9555258410000000078B12741666666E654525841CDCCCCCC70B12741CDCCCC2C54525841333333334DB1274100000060515258419A99999930B12741333333B34E5258419A9999991FB127419A9999994D5258413333333302B12741000000E04C52584100000000D6B02741000000A04B525841CDCCCCCCB6B02741CDCCCC0C495258419A999999A5B02741CDCCCC0C485258410000000079B02741333333B3465258419A9999995AB027419A999999445258410000000039B02741CDCCCC8C4052584166666666FDAF2741000000C03D525841CDCCCCCCF1AF2741CDCCCCEC3C52584100000000D8AF2741CDCCCC0C3852584100000000D1AF2741000000203752584166666666C3AF274166666666365258416666666688AF27413333337334525841333333334FAF2741666666C632525841CDCCCCCC2DAF2741333333D3325258416666666601AF2741666666463552584100000000D2AE2741000000C03652584100000000ABAE27419A9999B93752584166666666A1AE27410000004038525841000000009DAE274100000020395258416666666698AE2741333333F33B525841CDCCCCCC92AE2741000000603D525841666666668AAE2741000000A03F525841666666667BAE274133333313425258413333333353AE274133333353455258419A99999938AE274133333333495258413333333323AE2741333333734F5258410000000010AE2741000000605752584166666666F7AD2741666666265F5258419A999999D5AD2741CDCCCC0C6752584133333333D0AD27419A9999196A5258419A999999CEAD2741333333736B525841CDCCCCCCB1AD2741000000E06E525841CDCCCCCCA3AD2741333333B3705258410000000090AD274133333373715258413333333373AD27416666668672525841CDCCCCCC5CAD27413333339373525841000000004AAD27419A99997974525841333333333CAD274133333393755258416666666635AD2741666666A6765258419A99999931AD2741333333D378525841CDCCCCCC2CAD2741333333F3795258410000000019AD2741000000607B525841000000000DAD27419A9999F97B525841CDCCCCCCFEAC2741000000007F5258419A999999D0AC2741666666C67F525841CDCCCCCCC5AC27419A9999998052584166666666BEAC2741333333F382525841CDCCCCCCBAAC2741000000E0835258419A99999987AC274166666626885258419A9999995AAC2741CDCCCC8C8C525841CDCCCCCC4BAC2741666666068F5258413333333341AC27419A9999B98F525841666666662EAC2741333333738F5258416666666602AC27419A9999798E52584100000000F9AB2741666666268F52584133333333CFAB2741333333F39152584166666666AEAB274166666666935258419A99999983AB274100000060945258413333333358AB27416666664696525841666666663DAB27416666666698525841CDCCCCCC0DAB2741000000A09A52584100000000D7AA2741333333339D5258419A9999999FAA27419A9999B99F525841CDCCCCCC75AA274166666626A15258416666666637AA274133333333A452584100000000F6A9274100000060A652584166666666B3A9274166666686A9525841CDCCCCCC8AA9274166666686AA525841CDCCCCCC6EA9274100000040AB525841333333335CA92741000000C0AB525841CDCCCCCC4CA92741CDCCCCACAB525841000000003FA92741CDCCCCECAA5258413333333324A927419A999999A8525841000000001FA92741333333F3A7525841333333331BA927419A999939A5525841CDCCCCCC1AA92741666666E6A3525841333333330BA9274133333333A052584166666666F9A82741000000009E52584100000000F4A82741000000609A52584100000000E7A827419A99991998525841CDCCCCCCCFA82741CDCCCC0C9652584100000000C3A82741000000009652584100000000BBA82741000000E09552584100000000B5A82741333333F39452584166666666A5A82741333333D39052584133333333A2A827419A99995990525841CDCCCCCC94A827419A999979905258419A9999996EA82741666666A6925258416666666648A82741CDCCCCCC93525841000000002DA82741000000E093525841CDCCCCCCFFA72741666666A69552584100000000B4A72741CDCCCC6C985258413333333373A72741CDCCCC6C9A525841000000004CA72741333333339B5258413333333342A72741666666C69B5258410000000031A72741000000209E5258416666666625A72741333333B39E5258419A99999918A72741CDCCCC2C9F525841000000000AA7274166666626A05258413333333304A7274100000020A15258419A99999900A7274133333393A152584100000000E7A6274100000080A2525841CDCCCCCCD1A6274133333313A4525841666666669CA62741000000E0A45258419A99999977A62741000000E0A65258413333333358A62741333333B3A6525841000000004BA6274166666606A75258416666666641A627419A999999A8525841333333333BA62741000000E0A95258413333333320A6274133333353AA525841666666661BA6274166666606AA5258419A99999900A62741666666E6A8525841CDCCCCCCF2A52741000000E0A852584133333333E7A5274133333333A952584133333333DCA5274133333393A852584166666666C8A5274133333353A852584133333333B4A52741CDCCCC6CA952584133333333A9A52741666666E6AA52584100000000A1A527419A9999D9AF525841CDCCCCCC90A527419A9999D9B6525841000000008DA5274133333373B85258410000000088A52741666666C6BC5258419A99999983A527419A999959C0525841333333338AA527419A999959C25258419A99999993A52741CDCCCC8CC352584100000000CAA5274166666626C7525841CDCCCCCCDDA5274166666606CA5258419A999999E9A52741CDCCCC2CCE5258419A999999ECA52741CDCCCC8CD0525841CDCCCCCCE8A527419A999939D6525841CDCCCCCCE5A52741000000A0D6525841CDCCCCCCDCA5274100000000D7525841CDCCCCCC9BA52741CDCCCC4CD75258419A99999953A52741666666E6D8525841CDCCCCCC1EA527419A9999B9D852584166666666FDA4274166666666D852584100000000DEA42741333333D3D752584166666666C4A427419A9999F9D75258419A999999BEA42741CDCCCC6CD752584133333333B1A4274166666646D6525841000000008EA42741666666E6D5525841CDCCCCCC64A427419A999939D75258413333333352A42741333333D3D75258413333333334A4274133333353D7525841000000002BA42741333333D3D75258419A99999925A4274166666686D95258410000000022A42741CDCCCCACDC5258416666666618A42741CDCCCCACDE5258416666666612A42741000000A0E05258410000000008A427419A9999B9E25258416666666602A427419A999999E4525841CDCCCCCCFCA32741CDCCCC2CE852584166666666FBA32741333333B3EB52584133333333F3A32741666666A6EF5258419A999999EBA32741333333F3F152584100000000E3A32741CDCCCC2CF7525841	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	01010000206A0800005FF1157FB7B22741333333431B535841	480150000	Z	Pied-de-Borne	4801500	48015	48	76	28
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	01010000206A080000088D83DDC36E2641333333D3FF515841	480160000	Z	Balsièges	4801600	48016	48	76	33
01060000206A0800000100000001030000000100000073040000CDCCCCCC9CAB2541CDCCCC6C184B58413333333327AD2541333333934B4B58419A9999994AAD254133333333504B5841666666665BAD254100000020754B58413333333365AD254100000000A54B5841000000006DAD254166666686CA4B584133333333ADAD254133333373CF4B5841CDCCCCCC89AD254133333393E24B5841666666664AAD2541666666E6EC4B584100000000BEAD254100000020F84B58419A999999EEAD254166666686F74B58419A9999991AAE254166666666F74B5841666666664EAE254166666666F84B58413333333370AE25419A999979FA4B5841CDCCCCCC93AE2541CDCCCC8CFD4B5841CDCCCCCCC4AE2541CDCCCCCC014C58416666666601AF254133333333044C5841CDCCCCCC2DAF254100000040064C58410000000059AF2541CDCCCC2C074C5841CDCCCCCC80AF254100000020094C5841CDCCCCCC9BAF2541000000400A4C584166666666C2AF2541CDCCCC6C0A4C584166666666F4AF25419A9999B9094C58419A99999918B02541333333B30A4C58413333333338B02541000000200C4C5841CDCCCCCC65B02541333333530F4C5841000000008CB02541666666C6114C584166666666B3B025419A999919124C584100000000D8B0254100000000144C58410000000009B1254133333333174C58419A99999927B12541666666A6184C5841333333334EB12541000000E01A4C58419A99999979B12541000000601B4C5841666666669FB12541666666A61B4C584133333333BFB12541CDCCCCEC1A4C5841CDCCCCCCE2B12541666666A61A4C5841CDCCCCCC02B225419A9999191B4C58410000000022B22541000000E01D4C5841333333334CB2254166666686204C5841CDCCCCCC72B22541CDCCCC4C214C58416666666692B22541666666C6224C584100000000B4B2254133333333274C584133333333CCB22541333333B3294C584133333333E7B22541333333B32E4C584166666666FEB2254133333353324C5841000000000AB325419A9999F9354C58410000000015B32541000000603A4C58416666666622B32541000000E03E4C5841333333332FB32541CDCCCC8C424C58416666666643B325419A999919464C58419A9999995DB32541000000E0484C5841000000007CB325419A9999D9494C58419A9999999DB32541333333334B4C584100000000BFB325419A9999F94C4C584166666666D4B32541333333934E4C584133333333F2B3254100000020524C58410000000006B4254100000000554C58413333333311B4254166666626594C5841CDCCCCCC16B42541CDCCCCEC5C4C58413333333321B425419A999939604C58416666666632B42541CDCCCC4C614C5841CDCCCCCC4AB4254100000000624C5841666666666DB4254133333313624C58410000000084B42541CDCCCC4C624C584100000000A4B4254100000060634C58419A999999BCB42541666666C6644C58419A999999CDB42541CDCCCC4C664C584100000000D8B42541CDCCCC6C684C584100000000DDB42541CDCCCC4C6C4C58419A999999DCB4254166666686704C58419A999999D6B4254133333353734C584133333333CDB4254166666606774C58419A999999CCB4254133333353794C584133333333D0B42541CDCCCCCC7D4C584133333333D9B42541CDCCCC2C814C584100000000EEB425419A9999B9874C5841CDCCCCCCFBB42541666666668B4C58410000000006B52541666666268F4C58410000000005B525419A9999F9924C584166666666FFB425419A999999974C58419A999999FAB42541CDCCCCEC9A4C58419A999999FBB42541CDCCCC6CA04C584100000000FDB42541CDCCCC2CA34C584133333333FEB42541666666A6A74C584133333333FAB4254166666606A94C5841CDCCCCCCEAB42541666666C6AA4C58419A999999D5B42541000000A0AB4C5841CDCCCCCCC4B425419A999939AC4C584166666666BAB4254100000060AD4C58419A999999B8B42541CDCCCCCCAF4C58419A999999C6B42541666666C6B34C584100000000C9B42541CDCCCCCCB64C5841CDCCCCCCB9B4254100000040B94C5841CDCCCCCC9EB4254133333313BB4C58416666666686B4254100000040BE4C5841333333337AB4254166666606C14C5841CDCCCCCC79B4254100000060C34C5841666666667EB4254133333313C64C58416666666691B425419A999979C94C5841CDCCCCCCA0B425419A9999D9CD4C58419A999999ACB42541666666A6D14C584166666666A7B42541CDCCCC2CD64C5841666666669DB4254100000020D84C5841666666668CB425419A999979DA4C58410000000077B42541CDCCCCACDC4C5841333333336EB42541CDCCCCCCDE4C58419A9999996CB42541CDCCCCCCE24C58413333333378B4254166666606E84C5841CDCCCCCC87B42541000000C0EA4C58419A9999998DB4254133333313EE4C5841CDCCCCCC88B4254100000060F34C58410000000085B42541000000C0F84C58416666666684B4254100000020FE4C5841CDCCCCCC85B42541666666C6024D58410000000092B42541333333B3064D58416666666697B425419A9999190C4D5841CDCCCCCC9EB42541666666860F4D58419A9999999FB42541CDCCCCEC124D58416666666694B4254166666666144D5841666666667BB42541CDCCCC0C164D5841666666666BB4254133333333184D58419A99999960B42541666666461A4D5841CDCCCCCC52B42541333333731E4D58410000000052B425419A999939254D58410000000057B42541333333532B4D5841000000005FB42541CDCCCC8C2E4D58419A99999970B425419A9999F9304D58410000000083B4254166666626374D58416666666692B42541000000003D4D584133333333A7B4254100000040434D584100000000C3B42541CDCCCC8C494D584133333333DDB425419A9999D94E4D58416666666604B5254133333353554D58419A9999991AB52541666666A6594D58410000000020B525419A9999395A4D5841CDCCCCCC2DB52541666666C65B4D58416666666652B52541666666665E4D5841000000006AB52541CDCCCC4C604D58419A99999972B52541CDCCCCCC614D5841CDCCCCCC85B525419A999919654D58413333333396B52541666666E6674D58419A9999995EB52541000000206D4D5841000000005AB52541333333936D4D5841000000004BB52541CDCCCCAC724D58419A99999943B5254166666646754D58419A99999933B525419A9999B97D4D5841666666660FB525419A9999D98B4D58419A999999EEB42541CDCCCC4C9B4D584166666666F0B4254133333373A84D584166666666E9B4254166666626B44D584100000000D5B42541CDCCCC0CBC4D5841CDCCCCCC94B425419A9999B9C84D58416666666650B4254100000060D44D5841CDCCCCCC1AB425419A999999DA4D584133333333F3B32541333333B3DC4D584100000000BEB3254100000080DD4D58416666666681B325419A999999DE4D58419A9999994EB325419A9999D9E24D584166666666E5B22541CDCCCCACEB4D5841CDCCCCCC69B22541666666C6F64D58410000000029B2254100000020FC4D584133333333DAB1254166666646004E5841CDCCCCCC76B1254100000060034E5841CDCCCCCC17B12541333333B3064E584133333333AAB02541000000600A4E584166666666ABB02541CDCCCCEC0D4E58419A999999B7B02541666666E62E4E5841CDCCCCCCEAB0254100000040454E5841333333330CB125419A9999F94F4E58419A99999955B12541333333D36A4E58419A99999988B12541000000407C4E584133333333ACB12541CDCCCC6C894E5841CDCCCCCCB5B125419A9999F9884E584166666666BDB12541666666E6874E5841CDCCCCCCC9B125419A999979844E5841CDCCCCCCD5B12541000000E0814E584166666666E5B12541000000A07F4E5841CDCCCCCCFCB12541666666067C4E5841CDCCCCCC06B2254133333353794E58413333333312B2254133333393774E5841CDCCCCCC21B22541CDCCCC8C764E58419A99999934B22541333333F3754E58413333333358B225419A999979754E5841333333336DB2254100000000754E58416666666681B22541000000C0734E58419A9999998FB22541CDCCCC6C724E58416666666699B22541CDCCCC4C704E584133333333A9B22541666666666B4E584100000000BAB2254100000060674E5841CDCCCCCCBDB2254100000080664E5841CDCCCCCCC3B2254166666626654E584100000000CEB225419A999919634E58419A999999DDB2254166666606604E584166666666E9B225419A9999B95C4E58419A999999F4B225419A999939584E58413333333309B32541333333D3534E58416666666623B3254133333353504E58410000000046B32541CDCCCC6C4D4E58419A99999952B32541CDCCCCCC4B4E584166666666EFB32541CDCCCC2C384E58416666666665B42541CDCCCCAC2A4E5841CDCCCCCC6DB4254166666666254E58413333333393B42541CDCCCC4C204E5841CDCCCCCCF6B42541000000601E4E58410000000019B52541333333931E4E58419A99999934B52541333333131E4E5841CDCCCCCC50B52541000000C01C4E58419A99999962B52541000000201B4E58410000000077B52541000000C0194E5841CDCCCCCC85B52541CDCCCCCC184E5841CDCCCCCC8EB52541000000A0174E58419A9999999EB5254133333313144E584166666666A4B52541000000A0124E584166666666ACB5254166666606134E58419A999999CFB52541333333B3154E5841CDCCCCCCEDB5254166666606194E58419A999999ECB625419A9999D9164E584133333333F7B62541666666C6164E5841CDCCCCCCE2B725419A999999144E584166666666F2B72541000000E0114E5841CDCCCCCC08B82541666666E60E4E58416666666623B82541666666860C4E58410000000054B82541CDCCCC8C094E58413333333393B8254133333373064E584133333333E5B82541666666E6024E5841333333331BB9254133333373004E58413333333340B92541000000A0FE4D58413333333363B9254100000040FC4D58416666666688B92541CDCCCC0CF94D5841CDCCCCCCA9B92541CDCCCC8CF64D58419A999999CFB92541CDCCCCACF44D58419A999999FAB92541666666E6F24D5841CDCCCCCC18BA25419A999939F24D5841CDCCCCCC2DBA254166666666F24D58413333333340BA25419A9999F9F24D5841666666666DBA2541CDCCCC2CF54D584133333333ADBA2541CDCCCC0CF94D584100000000D7BA25419A999919FB4D584100000000DBBA2541CDCCCC2CFB4D584133333333E5BA254166666666FB4D58416666666605BB2541000000A0FB4D58413333333308BB2541000000A0FB4D5841CDCCCCCC10BB2541666666A6FB4D58419A9999992ABB2541000000C0FB4D58410000000040BB254133333373FC4D58419A9999995CBB254133333373F94D5841000000006DBB2541000000C0F74D5841CDCCCCCC78BB254166666686F64D5841666666667ABB25419A999959F64D5841666666660CBC254133333333E74D58416666666611BC2541CDCCCCACE64D58419A99999921BC254166666606E54D58410000000079BC25419A9999D9E24D5841333333338BBC254166666666E24D5841333333338ABC2541666666E6E54D5841CDCCCCCC77BC2541CDCCCCCCEB4D5841CDCCCCCC6ABC2541333333D3FB4D5841000000006FBC254133333353034E5841000000005EBC25419A999919044E5841CDCCCCCC3DBC2541CDCCCCAC054E584133333333CEBB2541333333B30A4E5841CDCCCCCC6BBB2541333333330F4E58419A9999995BBB25419A999919104E58419A9999993ABB2541333333F3114E58413333333327BB254133333313134E584166666666FFBA2541333333F3154E58419A999999E0BA254133333353194E584100000000BFBA25419A9999591E4E5841000000008EBA25419A999939244E5841CDCCCCCC5ABA25419A999939294E5841333333333CBA2541000000602B4E58419A99999928BA25419A9999192C4E58410000000010BA2541000000202B4E584133333333FDB92541CDCCCC2C294E584100000000E6B9254166666646254E584133333333DAB9254133333333214E584133333333CEB92541CDCCCC6C1D4E58419A999999BFB92541000000E01A4E584100000000A1B92541CDCCCC8C184E58410000000080B925419A999939174E58413333333351B925419A9999F9164E58413333333321B9254133333373174E584100000000FBB82541CDCCCCEC184E5841CDCCCCCCDDB825419A9999F91A4E584166666666C6B82541000000801D4E584100000000A4B8254100000020224E58410000000084B82541000000C0274E5841CDCCCCCC74B82541CDCCCCEC2B4E58410000000069B82541CDCCCC2C304E58410000000057B8254133333313334E58419A99999955B8254133333333334E58419A99999945B82541CDCCCC0C354E5841CDCCCCCC2CB8254133333353374E58419A99999919B82541CDCCCC4C3A4E5841666666660EB825419A9999D93D4E58419A999999FFB725419A999979434E5841CDCCCCCCF8B72541000000A04A4E58419A999999F8B72541CDCCCC6C4F4E58413333333302B82541333333F3534E58419A99999918B8254133333373584E58419A99999930B82541CDCCCCEC5B4E58410000000055B82541000000005F4E58413333333376B82541000000A0604E58416666666697B8254166666626624E584133333333B1B82541000000C0644E584166666666B9B825419A9999B9674E584100000000BFB82541333333936B4E584166666666C4B82541666666E6724E58419A999999CFB8254166666646784E584166666666E3B82541CDCCCC8C804E58419A999999F0B82541000000C0834E584166666666FBB8254100000060864E5841333333331FB92541333333138E4E5841333333335AB925419A9999199B4E58416666666683B9254100000020A54E58410000000099B92541000000C0A84E584133333333C5B92541CDCCCC0CAD4E584166666666F7B9254133333373B24E58410000000028BA254100000000B94E5841666666663DBA254100000080BC4E5841000000004ABA25419A9999B9C04E58413333333351BA2541000000C0C44E58416666666651BA2541666666A6CB4E58410000000050BA254100000080D24E58413333333353BA254133333313D64E5841333333335FBA2541666666A6DA4E58413333333378BA25419A999999E14E58419A9999999CBA25419A9999B9EA4E58419A9999999DBA2541333333F3EA4E5841CDCCCCCCB1BA25419A999939F04E584100000000B5BA2541000000E0F04E584100000000CDBA2541333333B3F54E5841CDCCCCCCE9BA2541333333F3F94E58410000000008BB254100000040FE4E5841666666661BBB2541CDCCCCAC024F58416666666624BB254133333373064F58419A9999992ABB2541666666860C4F58410000000028BB25419A9999F9104F58419A9999991DBB2541CDCCCC2C174F58413333333315BB25419A9999B91F4F58413333333313BB25419A999959294F58419A9999990DBB254100000040304F5841666666660ABB254100000000374F58416666666610BB2541333333933F4F58413333333317BB254133333333424F584133333333F7BB25419A9999F93E4F584100000000E7BC25419A9999F93F4F584133333333D7BD25419A9999F9454F58410000000015BE2541666666E6454F58416666666643BE254100000000404F58419A99999964BE2541333333D3404F58419A9999997BBE2541CDCCCCAC484F58416666666684BE2541CDCCCC8C4E4F584166666666B9BE2541666666864C4F58419A999999ECBE2541666666A6424F58419A9999990CBF2541333333533A4F58413333333322BF2541CDCCCCCC354F58410000000049BF25419A9999992C4F58416666666685BF25419A9999592B4F5841666666661AC02541666666A6314F5841000000004EC02541CDCCCC4C304F5841CDCCCCCC60C02541333333532C4F5841333333339CC02541000000C0244F584133333333E3C025419A999919174F584100000000E5C0254166666626174F584133333333F4C025419A999999174F58419A99999904C12541333333D3174F58416666666617C12541CDCCCC4C174F5841333333332AC1254166666686164F5841000000003CC1254100000080164F5841666666664DC12541CDCCCC8C164F5841CDCCCCCC69C1254133333333164F58416666666686C125419A999939154F58419A999999C4C12541666666E61F4F5841CDCCCCCCF4C125419A9999991C4F58419A99999911C2254133333333194F5841666666662CC2254133333373154F58419A9999994AC2254133333353104F58419A99999958C22541000000600E4F58413333333362C22541333333D30C4F5841CDCCCCCC67C22541CDCCCCAC0C4F58419A9999996CC225419A9999B90C4F58416666666671C22541333333730D4F5841CDCCCCCC14C2254166666666F74E584100000000D7C12541000000C0DA4E5841000000005DC12541666666E6BC4E5841000000000CC1254100000000AE4E5841666666665CC02541666666866E4E5841CDCCCCCC5EC02541CDCCCCEC6A4E58410000000086C02541000000A0654E58419A999999D1C0254166666666624E584100000000E9C0254133333393664E58413333333312C125419A9999796B4E58413333333328C12541CDCCCCCC6E4E58413333333338C12541CDCCCC2C714E58419A99999942C1254133333353744E5841CDCCCCCC52C2254166666666734E5841CDCCCCCC79C2254100000080724E5841CDCCCCCC7EC32541333333B36C4E58416666666678C4254166666626674E5841CDCCCCCCD5C5254166666646644E58419A999999C1C62541666666C6634E584100000000C5C6254100000020684E584166666666C7C62541000000C06C4E58419A999999CCC62541000000A0704E584166666666D4C6254133333393784E58419A999999D8C625419A9999797E4E5841CDCCCCCCE0C6254166666666844E58419A999999E8C625419A9999598A4E584166666666EFC62541CDCCCCCC8F4E584133333333F3C62541CDCCCC8C914E5841000000000DC725419A9999B99D4E5841666666661CC72541333333B3A34E5841CDCCCCCC28C7254100000020AA4E5841CDCCCCCC31C72541CDCCCC8CB04E5841000000003AC72541666666C6B54E58416666666645C725419A999959BB4E58419A9999994CC72541333333F3C04E58413333333352C725419A9999F9C64E5841CDCCCCCC52C7254133333313CA4E58419A99999952C725419A999979CC4E58416666666659C7254166666626CF4E58410000000072C725419A999979CD4E58410000000082C725419A999999CC4E5841000000008FC7254100000080CC4E58413333333398C725419A9999D9CC4E5841666666669DC72541000000C0CD4E5841000000009FC72541CDCCCC8CCE4E58419A9999999DC72541333333B3CF4E58413333333395C7254133333353D14E5841333333337FC7254133333333D54E5841000000006AC72541CDCCCCECD94E58413333333359C7254100000060DE4E5841333333334FC7254133333393E24E58410000000049C72541CDCCCC8CE74E58416666666645C72541CDCCCC4CED4E58419A99999945C7254166666606F34E5841CDCCCCCC44C72541000000A0F74E58416666666640C725419A9999B9FE4E58416666666641C72541CDCCCC4C034F58419A99999943C72541CDCCCC0C084F58419A99999943C7254133333333084F584166666666EBC725419A9999190D4F58419A99999949C82541000000C0164F5841CDCCCCCC3AC82541333333B32B4F5841666666663DC8254166666666524F5841CDCCCCCC65C82541666666C6614F5841333333339CC82541333333136A4F58419A999999ACC8254166666606724F584133333333B0C825419A9999597A4F584133333333ADC8254100000020894F584166666666A8C825419A9999D98D4F5841000000009CC8254100000060924F58419A9999998EC82541CDCCCC4C954F5841333333338DC82541666666A6994F5841CDCCCCCC7EC825419A999919A84F5841CDCCCCCC74C82541333333B3B04F5841333333336CC82541CDCCCC4CB94F58410000000069C82541666666E6BF4F5841CDCCCCCC68C82541000000E0C34F58419A9999996DC8254100000060C74F58416666666679C82541666666E6CC4F5841CDCCCCCC84C82541666666A6D24F58416666666688C82541CDCCCCECD54F58413333333387C8254100000060D94F58410000000082C825419A999919DD4F5841333333337AC8254166666606E04F58410000000070C8254133333333E24F5841000000003CC9254166666686DB4F5841CDCCCCCC5BC92541000000E0DC4F58419A99999983C92541CDCCCC2CDF4F584100000000B5C9254133333353E24F584133333333E9C9254166666686E64F58413333333319CA25419A999979EA4F58410000000031CA2541CDCCCC4CEC4F5841666666664BCA25419A999999ED4F58410000000060CA2541CDCCCC6CEE4F58419A9999997ECA2541CDCCCC8CEF4F5841666666669DCA25419A999979F04F584166666666BFCA2541000000A0F14F58419A999999D1CA2541CDCCCCECF14F5841CDCCCCCCE2CA2541CDCCCC0CF24F58419A999999F4CA2541CDCCCC6CF24F58416666666605CB254166666606F34F58410000000015CB2541CDCCCCCCF34F5841CDCCCCCC26CB254166666606F54F58416666666635CB254100000020F64F5841CDCCCCCC42CB254100000020F74F58419A9999994ECB254100000080F74F58419A99999961CB2541333333B3F74F5841CDCCCCCC7CCB2541000000C0F74F58413333333395CB2541333333D3F74F58419A999999ABCB2541000000E0F74F584166666666C3CB254100000040F84F5841CDCCCCCCD6CB254133333353F84F584133333333F4CB254133333333F84F5841666666666BCC25419A999959F64F5841CDCCCCCC28CD2541CDCCCC2CF14F5841666666667BCE254133333353DF4F5841CDCCCCCC40CF2541666666A6D24F5841CDCCCCCC31CF254133333353CF4F58410000000020CF25419A999959CC4F5841CDCCCCCCC7CE2541CDCCCC0CAC4F5841CDCCCCCCD0CE2541CDCCCC4C9E4F584133333333EECE254166666646944F58413333333347CF2541333333B3874F58419A9999999CCF2541CDCCCC0C7B4F584166666666B5CF2541CDCCCC0C7A4F5841CDCCCCCCCCCF254100000060784F584133333333ECCF2541CDCCCC4C754F58416666666619D025419A9999D9704F58419A99999937D02541666666466E4F58413333333394D025419A999919784F58419A999999EED02541666666466C4F5841CDCCCCCC89D12541666666C65E4F5841666666669ED125419A999939614F58413333333347D2254166666666754F58413333333388D22541CDCCCC4C7D4F584133333333E3D22541666666E6854F5841CDCCCCCCFFD22541000000C0864F5841CDCCCCCC0FD325419A999939874F58413333333326D32541666666E6874F58416666666683D32541000000E0844F58413333333397D3254133333333844F58419A999999C9D325419A999999824F5841CDCCCCCC0DD425419A9999598A4F58419A99999978D42541666666068B4F58416666666685D42541333333138B4F58419A99999999D42541333333338B4F584100000000D2D42541333333938B4F5841333333330FD525419A9999F98B4F58410000000025D52541CDCCCC6C8D4F5841666666662ED52541333333138E4F58419A99999978D525419A9999998F4F584100000000B5D525419A9999798E4F58419A999999FCD52541666666468A4F5841000000005ED62541CDCCCC4C874F5841CDCCCCCCB0D625419A999959884F58416666666609D72541000000208E4F58416666666677D72541666666C6954F5841CDCCCCCCA9D7254166666646994F5841000000004ED82541666666A6A54F5841CDCCCCCCDBD92541CDCCCCECAF4F58410000000011DA2541CDCCCC6CB54F5841CDCCCCCC41DA254166666606BD4F58410000000081DA25419A999919CC4F5841666666669DDB25419A9999B9B24F5841CDCCCCCCAADB2541CDCCCC8CB14F5841CDCCCCCCF6DC2541000000C09B4F5841000000000BDD25419A9999B9934F5841000000001BDD25419A9999B97C4F5841CDCCCCCC23DD25419A9999F96A4F5841CDCCCCCCC3DD254100000020634F584100000000C4DE254133333353644F58419A999999A2DF2541CDCCCC0C5B4F5841666666661AE0254133333313564F5841000000004AE02541000000804A4F58419A9999992AE025419A9999B92B4F5841CDCCCCCC0BE02541666666C61C4F584133333333F7DF2541CDCCCC0C144F5841CDCCCCCCC6DF2541000000600F4F584100000000B8DF2541666666860D4F58410000000056DF254100000080014F58419A99999919DF2541CDCCCC4CFB4E58416666666604DF254133333353F64E584133333333B4DE2541333333B3E34E58419A99999935DE254133333353CA4E58419A99999957DE2541666666C6C84E58413333333373DE2541666666E6C74E5841CDCCCCCC99DE25419A999919C54E5841CDCCCCCCBBDE254100000020C34E5841CDCCCCCCD3DE25419A999999C04E584133333333E7DE2541CDCCCCECBE4E58419A99999901DF2541CDCCCCCCBD4E5841333333331DDF254166666686BA4E58416666666630DF254133333313B94E58416666666654DF25419A999979B84E58413333333372DF254133333393B84E58416666666695DF2541666666C6B74E5841CDCCCCCCBFDF254166666606B74E584166666666E6DF25419A9999F9B54E58419A99999907E02541CDCCCCACB54E58416666666605E0254166666646A04E58413333333303E02541000000E08D4E58410000000003E02541666666468A4E5841000000006EE0254166666646814E58416666666675E0254133333313744E58413333333364E0254100000020564E584166666666D6DF254166666686574E58419A99999940DF2541CDCCCC6C564E58413333333318DE2541666666E64D4E584133333333B6DD2541000000604D4E58413333333388DD25419A9999F94C4E584100000000BDDC2541333333D34B4E584133333333ACDC2541CDCCCC6C4B4E58419A99999999DC2541666666264A4E5841CDCCCCCC37DC2541333333333F4E584133333333CCDB254166666666374E584100000000B8DB25419A999939374E5841333333338FDB254166666626374E58419A9999995BDB25419A999999354E5841000000000CDA2541666666261E4E5841CDCCCCCC29D8254133333373F54D58410000000028D8254166666606F14D58413333333349D825419A999999ED4D5841000000007ED8254166666606E84D5841CDCCCCCCABD8254166666626E34D584166666666DFD82541666666E6DD4D5841CDCCCCCC13D92541CDCCCC0CD74D58416666666636D92541000000A0D34D58416666666640D9254100000000D34D5841CDCCCCCC58D92541666666C6D04D5841000000006CD92541333333B3CD4D58413333333388D9254100000040C94D584133333333A2D92541CDCCCC0CC64D584100000000CAD925419A999919C14D584166666666CBD925419A999959BF4D58419A999999CCD925419A999919BE4D584100000000CED92541000000A0BC4D58419A999999CED925419A999999BB4D584133333333EDD92541CDCCCC4CB94D58419A999999FAD9254133333333B84D58419A99999909DA25419A9999F9B54D58416666666615DA2541333333B3B34D5841333333332EDA2541000000A0AF4D5841CDCCCCCC32DA254100000040AE4D58416666666638DA2541CDCCCC2CAC4D58419A99999945DA2541666666C6A74D58410000000056DA2541CDCCCCECA34D58419A9999995BDA2541CDCCCC8CA04D58410000000067DA25419A9999F99D4D58419A99999975DA2541000000C09C4D5841CDCCCCCC8DDA25419A9999399B4D5841CDCCCCCCA1DA2541CDCCCC6C9A4D584133333333AFDA25419A999919994D584100000000BADA254166666646974D5841CDCCCCCC32DB2541000000808A4D58419A99999951DB25419A9999B9884D58413333333371DB254133333373844D584100000000A9DB2541000000A07B4D584100000000E4DB2541CDCCCC6C724D584166666666B8DB2541000000806C4D58419A999999CFDB25419A999959674D5841666666669ADB2541CDCCCCCC614D5841CDCCCCCC90DB2541CDCCCCCC604D5841CDCCCCCC36DB254166666666574D5841CDCCCCCC48DB2541000000E0544D58416666666651DB254133333373534D58416666666658DB2541333333F3504D5841000000005ADB2541333333334C4D5841333333335EDB2541CDCCCC0C484D5841000000006ADB25419A9999D9434D58419A9999997CDB2541000000C0404D58413333333390DB2541000000403E4D584133333333A6DB2541333333933C4D584133333333BDDB25419A9999793C4D58419A999999DBDB2541000000203E4D5841CDCCCCCCF3DB2541333333B33F4D58416666666605DC2541CDCCCC6C414D58416666666610DC2541666666C6414D5841000000001CDC2541000000E0404D5841CDCCCCCC23DC25419A9999993F4D58419A99999926DC25419A9999D93D4D5841000000002BDC2541333333733B4D5841CDCCCCCC30DC2541666666E6394D58413333333340DC2541666666C6374D58419A9999994CDC2541CDCCCCAC364D58419A9999995DDC2541CDCCCC8C364D5841333333337ADC254166666626374D58419A999999A0DC254166666606394D58419A999999BDDC25419A9999993A4D584100000000CEDC2541CDCCCCAC3A4D5841CDCCCCCCDADC2541CDCCCCEC394D584133333333E5DC254133333313374D584133333333EBDC2541CDCCCC4C334D584166666666FBDC25419A9999192E4D5841666666660BDD25419A9999D9294D58416666666612DD254100000020264D5841000000001DDD2541CDCCCC6C244D5841000000002BDD2541CDCCCC6C234D5841666666665DDD254133333333214D58419A9999999CDD2541CDCCCC4C204D584166666666BEDD2541666666A61F4D584166666666CDDD2541000000C01E4D5841CDCCCCCCD8DD2541000000601D4D58419A999999E8DD2541666666461C4D58410000000004DE2541333333531B4D58416666666624DE2541666666261A4D58419A99999943DE254166666646184D5841333333334FDE254133333353174D58419A9999994EDE2541666666E6154D5841333333334EDE2541666666E6144D5841CDCCCCCC50DE254166666666124D58416666666651DE254133333333104D58413333333378DE2541000000A00F4D584166666666DEDE2541000000A00E4D58410000000005DF2541CDCCCCEC0E4D58416666666624DF25419A9999390F4D58419A9999993EDF25419A9999F90E4D5841666666665CDF2541666666660E4D58419A99999977DF2541666666A60D4D58410000000075DF2541CDCCCCAC0C4D5841333333336EDF25419A9999390A4D5841CDCCCCCC1FDF254133333333ED4C584100000000B4DE254100000080DF4C58410000000075DE254166666686DA4C58413333333339DE254133333313DD4C58410000000044DC254100000060C34C5841CDCCCCCCC1DB254166666686BE4C58410000000074DB254166666606C24C5841333333331BDB25419A9999D9BC4C5841CDCCCCCC05DB2541CDCCCC8CB64C58419A999999D5DA2541CDCCCC8CAE4C58413333333385DA2541666666E6A34C5841333333338CDA254133333333A24C5841333333339DDA2541CDCCCC0CA04C5841