SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep50;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep50 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep50','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep50','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep50','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep50"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000005AEAFB4C5618419A9999E9D2505A41	500020000	Z	Agneaux	5000200	50002	50	28	7
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	01060000206A080000030000000103000000010000001F000000333333337D4716410000008077465A4100000000944716419A9999397E465A41CDCCCCCCCA4716419A9999997E465A41CDCCCCCC284816410000002075465A41333333337F481641666666E670465A4133333333954816410000006066465A41666666665A4816419A99999965465A4100000000C4481641333333535B465A416666666682491641666666264F465A4166666666224A1641000000C050465A4133333333CB4A1641CDCCCCAC47465A41333333339B4A16413333337340465A4133333333EF4A1641333333333E465A4166666666164B16419A9999D937465A4133333333BF4B1641333333732F465A4166666666F24B1641666666E628465A41CDCCCCCC6A4D1641666666A613465A41666666668C4D1641666666860E465A4100000000844D16419A99993908465A41333333334F4D1641666666A604465A4133333333DD4C16419A9999790D465A419A999999254C16413333335317465A4100000000C84B1641666666E61F465A419A999999E74916416666662642465A41CDCCCCCC4E4916416666668648465A419A999999E1481641CDCCCC6C48465A4133333333A34816419A9999B94A465A41CDCCCCCC004816419A9999D957465A41CDCCCCCC7C471641333333D373465A41333333337D4716410000008077465A41333333337D4716410000008077465A410103000000010000000E0000009A999999CF4C16419A9999D9A4465A419A999999034D1641666666A6A6465A41CDCCCCCCA44D164166666666A7465A41CDCCCCCC1C4E164166666646A9465A41333333334F4E164133333373B1465A41666666664C4E164166666666BD465A41666666665E4E1641CDCCCC6CC4465A4100000000D64E1641333333F3BA465A41CDCCCCCC5A4E1641000000C0AB465A4133333333B94D1641CDCCCCAC9A465A41000000005E4D1641000000209B465A4100000000C44C1641000000009F465A419A999999CF4C16419A9999D9A4465A419A999999CF4C16419A9999D9A4465A41010300000001000000DA01000033333333AD6816419A9999D9824C5A419A999999996816419A9999197E4C5A41CDCCCCCCBE671641CDCCCC4C664C5A41CDCCCCCC486716419A9999994D4C5A4100000000BC661641333333933D4C5A41666666664266164100000080314C5A419A999999E1651641000000E0294C5A4100000000746516419A999919254C5A419A99999965651641CDCCCCAC1B4C5A41333333333F65164166666606154C5A4133333333BF641641CDCCCC8C094C5A41333333337164164100000020FE4B5A41333333337D64164133333393FC4B5A41333333332564164100000040E54B5A41CDCCCCCCBC63164166666646DB4B5A4100000000CA63164166666606D64B5A41333333330B64164166666646CB4B5A4133333333416416419A999999C74B5A41CDCCCCCC8C64164100000020BB4B5A419A99999939651641666666C6A64B5A41CDCCCCCC22651641CDCCCC6C994B5A4100000000506516419A999919994B5A41CDCCCCCC46651641333333B38A4B5A41333333337965164100000060874B5A419A9999993D651641666666C6804B5A4133333333496516419A9999B97B4B5A416666666604651641333333737C4B5A4100000000EC641641CDCCCCCC6F4B5A4133333333D7641641333333D36F4B5A419A999999836416419A9999995C4B5A41CDCCCCCC4E64164166666686584B5A41333333335B6416419A999959504B5A4133333333CD6316419A999999424B5A416666666656631641666666A6434B5A41CDCCCCCCDC621641CDCCCC8C3B4B5A4133333333BF62164100000040334B5A419A99999945621641000000402A4B5A419A9999996F62164166666686254B5A41666666666C621641000000A0204B5A41000000002A62164166666626204B5A41333333337161164100000080164B5A41000000003861164133333333094B5A419A99999905611641CDCCCC4C084B5A419A999999716016419A999939FF4A5A4100000000C25F164166666686F14A5A4166666666E05F164100000080ED4A5A419A999999A35F16419A999919E64A5A41CDCCCCCCD25F1641666666C6E24A5A419A999999D55F1641CDCCCC0CCE4A5A419A999999B55F164133333333C84A5A4166666666A46016419A9999D9A84A5A41CDCCCCCC5A6116419A9999D9964A5A41CDCCCCCCD4611641CDCCCC8C8F4A5A41666666664E621641000000A0864A5A41CDCCCCCC90621641CDCCCCEC7F4A5A4166666666E2621641CDCCCCEC804A5A419A99999965631641CDCCCCEC734A5A41CDCCCCCC94631641666666A6754A5A4133333333D363164133333353684A5A41000000002264164100000000684A5A4166666666F0631641CDCCCC8C574A5A4100000000BE6316419A9999994D4A5A419A999999FF621641333333334A4A5A419A999999296316419A9999F9464A5A41000000003063164100000040404A5A4100000000FE621641CDCCCCCC394A5A41333333332F631641666666C6374A5A419A99999929631641666666E6324A5A4100000000E4621641000000602D4A5A41CDCCCCCCF4621641000000602B4A5A410000000096621641000000E0284A5A41CDCCCCCCA662164133333393254A5A410000000046621641000000A0214A5A410000000036621641333333D30F4A5A419A99999977621641333333130A4A5A419A999999B562164166666666FE495A4133333333AB6216419A9999F9FB495A41CDCCCCCCD2611641000000E0EB495A419A9999999F61164133333373E9495A4100000000F65F1641CDCCCC4CE1495A419A9999990B5F16419A999919DC495A41CDCCCCCCE25D16419A999959D3495A41333333338D5C164166666626C6495A4166666666BA5B164100000000BC495A419A999999935A1641CDCCCC2CAB495A419A9999997D591641333333739C495A419A999999BF5816413333335391495A4100000000DA571641333333D385495A4133333333FB5616419A99995979495A41CDCCCCCCE2561641333333D36E495A419A99999901571641CDCCCC6C6B495A41CDCCCCCCBA561641CDCCCCCC5E495A413333333325561641CDCCCC4C59495A4133333333E5551641000000E054495A41CDCCCCCCB0551641666666264B495A41CDCCCCCCC85516419A9999B93F495A41666666666A561641000000E034495A413333333383561641CDCCCCCC30495A41CDCCCCCC72561641000000402B495A419A999999C3561641333333B32A495A41CDCCCCCC5A561641000000601E495A416666666680561641CDCCCC0C1B495A4133333333875616410000000010495A41CDCCCCCCCC5616413333335312495A4133333333F7561641666666A60B495A4133333333275716419A9999F90F495A41000000007C571641CDCCCC8C1F495A4100000000A4571641000000A029495A4100000000C25716410000002029495A419A999999AF571641666666E61F495A41333333335D571641CDCCCC6C10495A4133333333BF56164133333333FE485A4166666666CA561641CDCCCC6CFC485A41666666666056164100000040F4485A4133333333C755164166666666E6485A41000000009255164133333333E3485A410000000020551641666666E6D5485A41CDCCCCCCAC541641333333B3C3485A419A99999951541641CDCCCC0CBA485A41666666668853164100000020A9485A419A9999991F5316419A999939A7485A41CDCCCCCC8E521641CDCCCC6C9D485A419A99999923521641000000C094485A4166666666365116419A9999D986485A4166666666B45016419A9999D97D485A41CDCCCCCCA84F16416666668668485A41333333334B4F16419A99993965485A41CDCCCCCC024F16419A9999995E485A4166666666F84D16416666662659485A4133333333B54D16416666660656485A4133333333594D16419A9999B947485A41000000007C4D16413333339342485A419A999999DF4C1641000000A048485A4166666666B84C16419A99993948485A4166666666884C16419A99991941485A4100000000F24C1641000000E02D485A41CDCCCCCC444D1641CDCCCC8C22485A4133333333B74D16419A9999B91B485A4133333333874E1641666666C619485A4166666666264F16419A99999924485A419A999999D74E1641666666A61B485A41333333338B4E1641000000E015485A41CDCCCCCCA84D1641CDCCCCECFB475A419A999999474D164166666626EF475A4166666666E84C16419A9999B9E5475A4133333333014C16419A999919CB475A4166666666904B164100000040C8475A41000000003E4B164100000060C3475A419A999999174B164100000040BE475A41CDCCCCCCC04A1641CDCCCCACB9475A419A9999992B4B1641333333D3A6475A4166666666A24B1641333333738F475A4166666666D84B1641CDCCCC8C82475A4166666666DE4B1641000000C07C475A4100000000C24B1641CDCCCC4C73475A41000000008E4B1641333333B36C475A4166666666384B1641000000E065475A4133333333914A1641000000E055475A4100000000B04A1641CDCCCC6C4C475A4100000000084B16419A99991941475A4100000000064C1641333333933D475A419A999999674C16410000000040475A4100000000D24C1641666666E63D475A41000000009C4C1641CDCCCC2C46475A4166666666964C1641CDCCCC6C53475A419A999999ED4C1641CDCCCCAC3C475A419A9999996F4D16416666666637475A41CDCCCCCC404D16419A9999F93D475A4166666666424D16416666662642475A4100000000704D1641CDCCCC6C39475A41CDCCCCCCFE4D1641666666462A475A41CDCCCCCC3C4E16419A9999F925475A41CDCCCCCC9E4E1641CDCCCCEC18475A419A999999A94E16416666660609475A419A999999CB4E1641666666E6F6465A41CDCCCCCCB04E164100000060E0465A41666666668C4E164166666606D7465A419A9999993D4E1641333333D3CC465A4100000000004E164166666666C8465A41CDCCCCCC444D164166666666BE465A419A999999074D164166666686B7465A419A999999594D164133333373B2465A41666666663C4D164133333393AF465A4133333333F34C1641CDCCCC4CB0465A41CDCCCCCCF04C1641333333B3B6465A4166666666344C164100000080B2465A4100000000124C1641CDCCCC6CB4465A4100000000564A164133333373BF465A41CDCCCCCC8A491641CDCCCCACC2465A4100000000DE4916419A999939BD465A4100000000004A1641333333D3B7465A41CDCCCCCC964A16419A9999D9B2465A4133333333574B164166666686AF465A41CDCCCCCCF44B1641666666A6AE465A419A999999ED4B1641CDCCCCACAB465A41666666664C4C164166666606AA465A4166666666984C164100000020A6465A4133333333734C164100000060A1465A419A9999991B4B1641000000A0A7465A41CDCCCCCC464A1641CDCCCC4CAC465A4133333333E7491641CDCCCC0CAD465A4100000000D849164100000040A9465A419A999999694A1641CDCCCC4C9F465A41CDCCCCCCC04A1641333333D39D465A4166666666DC4A1641CDCCCC2C93465A419A999999634B1641666666468D465A4133333333B14B16410000002086465A419A999999114C16416666660680465A4166666666004C1641CDCCCC0C7E465A41CDCCCCCCF84A1641CDCCCC4C8A465A4100000000644A16419A9999D992465A4166666666184A1641333333B394465A41000000005C4A1641666666468D465A41CDCCCCCC684B1641666666E679465A4166666666004C16410000000071465A41CDCCCCCC9A4C16410000008065465A4100000000184D16419A9999395F465A41CDCCCCCC764D1641333333335C465A4100000000444E1641000000405B465A4133333333554E1641333333D361465A4133333333214E16419A99997968465A4100000000DC4D1641333333F37E465A4166666666F44D16419A99993982465A41666666662A4E1641CDCCCC8C80465A41666666667C4E1641000000E06A465A41000000007E4E16419A99995966465A41CDCCCCCC2E4E1641CDCCCCAC4F465A4100000000344E1641000000C044465A4100000000604E16410000000037465A41333333333F4E16419A9999F936465A419A999999C54D1641333333D32F465A41000000007A4D16416666666630465A41CDCCCCCC344D1641CDCCCCAC38465A4100000000604C16416666668646465A41CDCCCCCC2E4C1641333333F34A465A4100000000504B1641000000C054465A4100000000A44A1641CDCCCC0C67465A4166666666064A1641CDCCCC8C75465A4166666666F8481641666666A684465A41000000007A4816410000004089465A41CDCCCCCCA0471641000000008F465A41000000000E471641CDCCCC0C8E465A41CDCCCCCCDE461641666666A68B465A41333333336B461641333333D394465A41CDCCCCCC624516419A9999F9A4465A419A9999998944164166666686AD465A4133333333A54416419A9999F9A7465A41333333339744164166666626A2465A4100000000E8441641666666A69D465A419A999999A1441641000000E098465A419A999999714416416666666699465A416666666604451641CDCCCC6C8D465A419A9999999B4516419A99993989465A41CDCCCCCCDA4516419A99997981465A4166666666184616419A99999981465A41333333332B461641333333537C465A419A999999674616419A9999B97A465A419A999999734616416666664675465A419A99999925471641333333D35E465A41CDCCCCCC724716419A9999994F465A413333333363471641CDCCCCAC49465A4133333333C7471641666666C633465A416666666612481641CDCCCC2C2E465A419A9999993D481641666666262F465A4100000000B4481641CDCCCC2C2B465A4133333333174916419A99999925465A419A999999734916410000006024465A4133333333514916419A9999192B465A41000000000A4916416666662631465A4100000000CA481641666666463C465A4166666666D8481641CDCCCC0C41465A413333333355491641333333D33C465A4100000000864916410000004035465A4133333333F9491641000000202D465A41CDCCCCCC704A1641333333931A465A41CDCCCCCCA84A1641666666E615465A419A999999E34A16416666666615465A4133333333CB4B1641CDCCCC8C08465A4100000000AE4C1641333333B300465A4166666666C64C16419A999959FC455A4166666666A24D1641CDCCCC8CF1455A4100000000CE4D1641CDCCCCACEC455A41CDCCCCCC524E164100000040E3455A419A9999993F4E1641CDCCCCECE0455A4100000000F24D164100000020E2455A41CDCCCCCC5A4D1641CDCCCCACE8455A419A999999794B1641666666E600465A41CDCCCCCCC44A1641CDCCCCEC08465A4166666666EE4916419A9999F910465A419A999999F9481641CDCCCC8C17465A41666666664C481641666666861A465A41333333332B471641000000201D465A4166666666384716419A99999919465A41CDCCCCCC964616410000002019465A41666666660E471641CDCCCCAC0B465A4100000000564716419A99997906465A419A999999274716419A9999D905465A416666666686461641000000800E465A4166666666224616419A9999B917465A413333333381441641000000804B465A419A999999FB431641666666C65D465A41666666666C4316413333331375465A4166666666F8421641000000E089465A4133333333594216419A999979AC465A4100000000AE41164133333353D3465A419A99999949411641000000A0EE465A41333333339B4016419A9999F924475A41CDCCCCCCFA3F16416666660655475A419A999999A13F1641000000606C475A4100000000483F1641000000807B475A4100000000E43E1641000000C079475A41CDCCCCCC023F1641CDCCCC8C7C475A4133333333833E1641666666E6A0475A41CDCCCCCCE43D1641666666E6CA475A41CDCCCCCC2C3D164166666626FD475A4166666666BA3C1641000000A01F485A41CDCCCCCC0A3C1641666666E64A485A41CDCCCCCC843B16416666664669485A41000000002E3B1641CDCCCC6C7B485A4166666666D63A16413333335390485A419A999999853A16419A999979A6485A41CDCCCCCC343A164133333313C0485A4166666666043A1641CDCCCC6CD4485A4100000000C63916419A999959F4485A41333333339F391641000000000C495A41666666666E3916419A99999933495A41CDCCCCCC5C391641CDCCCCEC47495A41CDCCCCCC2C3916416666668655495A41CDCCCCCCFE3816413333333358495A419A999999DB3816410000002055495A4100000000A0381641000000805F495A410000000090381641000000806C495A41000000002C3816410000000076495A4100000000FC3716410000008089495A4100000000E83716410000008097495A4100000000C037164100000000A9495A410000000058371641000000C0E1495A41000000002C37164100000080F6495A4100000000DC36164100000000234A5A4100000000F436164100000000294A5A4100000000A036164100000080284A5A4100000000D0361641000000802B4A5A410000000070361641000000804E4A5A41000000003436164100000080724A5A4100000000E835164100000080994A5A4100000000CC35164100000040AB4A5A4100000000C435164100000040BF4A5A4100000000D035164100000000CD4A5A4100000000A8351641000000C0CE4A5A4100000000C0351641000000C0D34A5A4100000000A035164100000000F44A5A410000000078351641000000800C4B5A41000000007835164100000000124B5A41000000003435164100000040354B5A41000000006834164100000000354B5A41000000007834164100000040364B5A41000000003435164100000080374B5A4100000000E8341641000000005D4B5A419A999999EB341641666666A6664B5A4100000000B834164100000040814B5A41000000009C34164100000000854B5A41000000002034164100000080BA4B5A41000000002034164100000040BF4B5A4100000000F433164100000000D64B5A41000000000C34164100000080D94B5A4100000000CC33164100000000F44B5A41000000005C331641000000801B4C5A410000000070331641000000401C4C5A410000000068331641000000802B4C5A41000000007C331641000000C0324C5A4100000000C03316419A9999993A4C5A4166666666A8331641CDCCCC4C404C5A410000000060331641666666265E4C5A41CDCCCCCC063316419A9999B9794C5A419A9999992132164166666666B54C5A41CDCCCCCCBE33164133333313B54C5A41666666664034164166666646A74C5A41000000006A3416419A9999D99B4C5A41CDCCCCCC50341641333333F38D4C5A416666666656341641666666C67D4C5A41000000009C34164166666666754C5A4133333333E734164166666646714C5A41CDCCCCCC1635164133333313584C5A419A999999913416419A9999B9524C5A419A999999AD341641CDCCCCCC454C5A41000000006E341641CDCCCC8C3E4C5A41666666668A3416419A9999993A4C5A41000000005A3416419A9999D9264C5A419A9999996F341641CDCCCC0C174C5A41CDCCCCCC8C341641666666A60C4C5A41CDCCCCCC8434164133333333064C5A4166666666C2341641666666E6024C5A41666666669034164100000060F74B5A419A999999A73416419A999959EE4B5A4100000000FE3416419A9999B9E14B5A41666666664C35164133333393E14B5A410000000080351641666666C6E74B5A4133333333B535164133333333F24B5A419A999999D7351641666666A60D4C5A4133333333B1351641666666A6274C5A4166666666CE3516419A9999D92D4C5A41CDCCCCCCB035164100000040314C5A419A999999D735164100000040364C5A419A9999992D361641000000203B4C5A4100000000F0361641000000C03B4C5A410000000050381641000000005E4C5A41CDCCCCCC3C3816419A999959604C5A4100000000D4381641CDCCCCAC6B4C5A413333333347391641666666667A4C5A41000000007039164100000000864C5A41000000008039164100000080A54C5A410000000090391641333333D3B24C5A41CDCCCCCC203A164166666606B34C5A419A999999AB3E16419A9999B9B14C5A419A99999957411641000000E0B14C5A4133333333C741164133333393B64C5A41000000001E4216419A999939B84C5A41000000008C421641CDCCCC4CBD4C5A41CDCCCCCC16431641000000C0BE4C5A410000000040431641000000A0C14C5A4166666666DE43164166666686C14C5A41333333334D4416419A9999D9BC4C5A41666666665C44164133333353BF4C5A41666666665C451641CDCCCCACBD4C5A413333333349461641666666A6B94C5A41CDCCCCCC6A46164133333313B84C5A419A9999995B461641666666C6B04C5A4166666666B64616419A9999F9B04C5A41000000008446164166666626AD4C5A410000000018481641666666A6B14C5A41CDCCCCCC3848164133333313B54C5A4166666666AA481641333333B3B64C5A419A99999981491641CDCCCCACB34C5A4166666666904A16419A9999D9B04C5A4100000000144B164133333373B14C5A41CDCCCCCCD44B164166666626AB4C5A419A999999554C164100000060A54C5A4166666666624C164133333353A24C5A41666666667E4D164166666686964C5A41333333338F4E16419A9999598F4C5A4133333333714F164100000080864C5A4166666666984F16419A999959864C5A4100000000A2501641333333137B4C5A419A9999991F511641666666C6724C5A4166666666D4511641CDCCCC8C6D4C5A419A9999996F5216419A9999196B4C5A41000000002C53164100000000654C5A4166666666CA53164100000000624C5A419A999999A554164166666606584C5A41CDCCCCCC1E551641333333D3534C5A41666666668E561641CDCCCC0C4A4C5A41666666668A561641333333D3484C5A419A999999C157164133333373424C5A419A999999BB58164133333353424C5A416666666652591641333333333F4C5A41CDCCCCCC145A1641666666C63D4C5A41CDCCCCCC4A5A1641CDCCCC4C444C5A41CDCCCCCCD85A1641CDCCCC4C514C5A4133333333335B1641CDCCCCCC554C5A4133333333D55B164166666646644C5A419A999999135C164100000040674C5A41666666667A5C16419A9999B9684C5A4133333333AF5D164100000020674C5A4133333333E95D16419A9999196A4C5A41CDCCCCCC6A5F1641666666A65E4C5A41000000007660164133333393544C5A4166666666CA611641CDCCCC6C5E4C5A4166666666FA641641333333D3734C5A419A9999991D6516419A9999D9754C5A4100000000F66616419A999939854C5A419A9999990B681641000000E08B4C5A4166666666A4681641CDCCCC2C854C5A4133333333AD6816419A9999D9824C5A4133333333AD6816419A9999D9824C5A41	01010000206A08000037FF8C69884716410000009051495A41	500030000	Z	Agon-Coutainville	5000300	50003	50	28	13
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	01010000206A08000038A272F7619C1841343333637D5B5A41	500040000	Z	Airel	5000400	50004	50	28	10
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	01010000206A0800009C5D6F3975191841000000F07A555A41	500060000	Z	Amigny	5000600	50006	50	28	4
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	01010000206A0800000EBB732B4B7416410000009025355A41	500080000	Z	Anctoville-sur-Boscq	5000800	50008	50	28	2
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	01010000206A080000CE022FE688D41741CCCCCC5C028A5A41	500130000	Z	Anneville-en-Saire	5001300	50013	50	28	6
01060000206A080000010000000103000000010000000A03000000000000FE5317419A9999F9F4675A41000000000A5417419A999919F6675A41333333333754174133333353FC675A4100000000485517419A9999991E685A4133333333B95617413333331341685A4100000000B0571741000000A053685A4166666666BA571741666666A653685A419A999999D35717416666662652685A419A999999315817413333331354685A4166666666DA5717419A9999995F685A41CDCCCCCCBE571741000000C062685A41CDCCCCCCB85717416666660664685A4166666666D2571741000000C064685A4133333333D75717410000002065685A410000000008581741CDCCCC6C66685A4133333333215817419A9999D966685A4166666666A05817410000002068685A419A999999A55817419A9999196C685A419A999999A5581741CDCCCC2C6E685A4166666666885817419A9999597A685A413333333379581741CDCCCC6C7A685A4133333333EB5717419A99993994685A41CDCCCCCCD6571741666666E696685A419A999999BB5717410000008099685A41CDCCCCCCE856174133333373A6685A41CDCCCCCC645617419A999959AB685A41666666660256174133333353AF685A419A999999595517419A999939B7685A4133333333BF54174133333353BD685A41000000006655174166666666C6685A4100000000D856174100000000C2685A410000000000571741000000C0C1685A4133333333375717419A999959C2685A419A99999935571741CDCCCCECC3685A41CDCCCCCC2457174100000000C7685A41CDCCCCCCF256174166666666D9685A4133333333EF56174100000000DE685A4166666666E0561741666666E6E7685A4166666666D856174166666686EA685A41666666669C561741CDCCCC4CF9685A41CDCCCCCCB6561741CDCCCC2CF9685A4100000000585717419A999979F9685A4133333333B557174100000020F9685A41CDCCCCCCDC571741333333B3F8685A41000000003C5817419A999939F7685A41666666660859174100000080F2685A416666666640591741CDCCCCECF0685A4133333333895917419A999939EE685A41CDCCCCCCE4591741CDCCCCACE9685A4166666666F05917419A999919EB685A4100000000325A174166666626F7685A419A9999993B5A174166666606F7685A4100000000325C17419A999939F7685A4100000000385C17419A9999B9F7685A419A999999695C1741666666A6F8685A419A999999715C174133333353F7685A419A999999A35C174100000020F8685A4100000000A65C1741CDCCCC6CF8685A419A999999C15C1741CDCCCCCCF8685A4100000000D05C174133333313F6685A419A999999715D174133333353FE685A419A9999997F5D174100000020FF685A41000000007E5D1741CDCCCC6CFF685A4100000000FE5D17416666662606695A41666666663E5E17419A9999D909695A416666666658601741333333D32A695A41CDCCCCCC78601741CDCCCC0C2C695A419A999999F16017419A99993932695A41CDCCCCCCEC601741000000E032695A41CDCCCCCCAA611741666666C63B695A419A999999B1611741000000603B695A4100000000B6621741666666C646695A4166666666DC621741333333B348695A4166666666BA6317413333335352695A419A999999EF641741333333D35E695A4133333333F1641741000000405F695A41666666662C651741000000C062695A419A99999959661741000000A071695A41000000002E671741000000607B695A41666666663A6717419A9999397C695A41CDCCCCCC526917419A9999F994695A4133333333F9691741666666E69B695A41000000003A6A1741CDCCCC2C9E695A41666666669C6A17419A9999F9A0695A419A999999E36A174133333373A2695A41CDCCCCCC386B1741666666A6A3695A41000000009E6B1741666666C6A4695A419A999999196C1741666666C6A5695A41CDCCCCCCA86C17419A999939A6695A41666666669A6D174166666686A7695A4100000000F26D17419A999959A8695A4166666666346E17419A9999F9A9695A41666666663E6E1741000000C0A9695A4100000000366E174100000040AA695A41CDCCCCCC2E6E1741CDCCCCECAD695A4166666666406E174166666606B0695A41CDCCCCCC606E1741333333B3B2695A419A9999997D6E1741666666A6B4695A41CDCCCCCCDE6E174133333393B9695A4166666666E86E17419A9999B9B9695A4133333333996F1741000000A0C3695A4166666666CE6F1741CDCCCCCCC6695A41CDCCCCCCFA6F17419A999999CA695A4166666666107017419A999939CD695A416666666622701741CDCCCC4CD0695A41000000002E701741CDCCCC8CD3695A41000000003A701741CDCCCC8CD8695A41666666663C70174133333353DD695A41CDCCCCCC4270174100000080DE695A41CDCCCCCC4E701741CDCCCC2CDF695A410000000058701741CDCCCC2CDF695A41CDCCCCCC66701741CDCCCCCCDF695A41CDCCCCCCD07017419A9999D9E0695A4133333333AB711741CDCCCC2CE4695A41CDCCCCCCD071174166666686E4695A4166666666FA72174100000080E3695A419A9999990374174133333353E3695A41CDCCCCCC4C741741CDCCCCACE2695A4166666666E8741741000000E0F1695A4166666666EC751741666666660A6A5A4166666666F0751741333333730A6A5A4133333333117617419A9999590D6A5A410000000032761741000000800F6A5A41333333337B791741CDCCCC2C346A5A4166666666EE7F1741000000007B6A5A41CDCCCCCCB48517419A999919BB6A5A4100000000C68517419A999939BC6A5A4166666666D0851741000000E0BD6A5A41CDCCCCCCD885174166666686BE6A5A4166666666F885174166666626C26A5A4166666666D28617419A999979C36A5A41333333333587174100000020C56A5A416666666618881741666666E6C96A5A4166666666FA8817419A999959CD6A5A419A9999999B89174133333353CE6A5A41CDCCCCCCFE89174133333393CE6A5A41CDCCCCCC788A1741666666E6CD6A5A41CDCCCCCCA48B174166666686C96A5A41333333333B8C1741CDCCCCACC66A5A4166666666D48C1741333333D3C26A5A41CDCCCCCC1A8D1741CDCCCCCCC06A5A41CDCCCCCC668D174100000080BD6A5A4100000000A88D1741CDCCCC8CAF6A5A41000000000E8E1741333333739E6A5A4166666666608E174166666646936A5A4166666666FA8E174166666606836A5A4100000000708F174133333333756A5A419A999999818F174133333353726A5A4166666666928F1741000000206E6A5A41333333339D8F1741000000006A6A5A41666666669E8F17419A999939666A5A419A999999978F1741000000E0616A5A419A999999878F17419A9999595E6A5A4133333333758F17419A9999795B6A5A4166666666FA8E1741666666264E6A5A419A999999E18E1741000000004C6A5A419A9999999F8E1741333333334C6A5A4133333333818E1741666666E64C6A5A4100000000C88D17419A9999D94A6A5A41CDCCCCCC6C8C17419A9999B9476A5A41333333332F8C17419A9999B9466A5A4166666666E28B1741000000A0446A5A4133333333C58B1741000000A0436A5A4100000000B28B1741000000E0426A5A419A999999978B174133333333416A5A4166666666768B1741666666463E6A5A4166666666568B1741CDCCCCEC3A6A5A4166666666408B174100000000386A5A4133333333278B1741666666A6336A5A41CDCCCCCC188B1741666666E62D6A5A4100000000228B174133333313286A5A4166666666728B1741CDCCCCEC196A5A4100000000A88B1741CDCCCC0C116A5A4133333333B98B1741000000E00E6A5A4166666666D68B17419A9999990B6A5A41000000003E8C1741CDCCCC4C026A5A41CDCCCCCC6E8C174133333313FD695A4133333333878C174166666606F9695A419A999999978C174133333373F5695A41CDCCCCCCB08C17419A999959EE695A4166666666B28C174100000060EA695A4133333333A98C174166666666D4695A4133333333B38C17419A999999CF695A419A999999B98C17419A9999F9CD695A41CDCCCCCCBC8C17419A999959CD695A4166666666F88C174166666646C7695A41CDCCCCCC048D174166666666C6695A41CDCCCCCC168D1741CDCCCC2CC5695A419A9999992F8D1741333333F3C3695A4100000000668D1741CDCCCC0CC2695A4100000000E88D17419A999999BE695A41000000004E8E17419A999959BC695A41CDCCCCCCB08E174166666686BA695A4166666666288F1741CDCCCC6CB8695A41CDCCCCCCC08F174133333333B6695A41333333332F90174100000040B5695A41666666666E901741CDCCCC8CB0695A41000000008C90174100000000AF695A41CDCCCCCCAE90174133333393AD695A4133333333D590174133333353AC695A416666666616911741CDCCCCCCAA695A41666666669C91174166666606A9695A41000000003692174133333393A5695A4166666666A6921741666666C6A3695A4133333333C3921741CDCCCC0CA2695A4166666666F8931741000000C099695A416666666636941741666666E697695A41CDCCCCCCEC941741000000C093695A4100000000689517419A99995991695A41CDCCCCCC30961741333333F38D695A41333333336B961741666666468D695A419A999999B19617419A9999D98C695A416666666604971741000000E08C695A4133333333179917419A9999F990695A41CDCCCCCC989917416666668691695A41CDCCCCCCC0991741CDCCCCEC90695A4100000000E09917419A99997995695A4100000000EE991741666666E699695A41CDCCCCCCF6991741666666669E695A4166666666FE9917419A999919A7695A41CDCCCCCC049A1741CDCCCC4CA9695A4100000000189A1741000000A0AD695A41666666663C9A1741333333D3B2695A419A9999996B9A174133333313B7695A41CDCCCCCCBE9A174166666686BD695A41CDCCCCCC169B174133333353C3695A41CDCCCCCC349B1741666666E6C4695A4100000000609B1741CDCCCC6CC6695A419A9999998B9B1741000000A0C7695A41CDCCCCCCB89B174100000080C8695A4100000000DC9B1741666666E6C8695A41CDCCCCCC129C1741000000E0C8695A4100000000249C174133333393C8695A419A999999519C174133333313C7695A419A999999619C174166666626C6695A4166666666829C17419A999999C3695A41CDCCCCCC009D1741333333F3B5695A4166666666329D1741CDCCCC4CB1695A41CDCCCCCC5E9D1741CDCCCCCCAD695A4166666666869D174166666606AB695A419A999999BB9D1741666666E6A7695A41CDCCCCCCE29D17419A999939A6695A419A999999239E1741666666C6A4695A4166666666389E1741CDCCCC8CA4695A419A999999519E1741CDCCCCACA4695A419A999999619E1741666666E6A4695A4166666666949E174133333353A6695A4100000000789F1741CDCCCC2CB0695A4100000000D09F174133333393B3695A41CDCCCCCC28A01741CDCCCC4CB6695A41CDCCCCCC4CA0174166666626B7695A41CDCCCCCC82A01741000000E0B7695A41CDCCCCCCD4A01741333333D3B7695A4133333333FBA0174166666686B7695A419A99999927A117419A9999B9B6695A416666666688A11741CDCCCC6CB4695A41CDCCCCCCB0A117419A999939B1695A41CDCCCCCCDAA1174133333313AC695A4100000000FAA11741CDCCCC6CA6695A41000000000CA2174166666626A1695A413333333317A21741000000A09A695A41666666662AA21741000000C08A695A41666666663AA217413333333385695A416666666654A21741000000407F695A41CDCCCCCC7EA217416666660677695A4100000000BAA21741666666466F695A419A999999C9A21741666666A66A695A41CDCCCCCCE0A31741CDCCCCCC65695A41CDCCCCCC46A417413333331365695A419A999999DDA517410000002058695A413333333327A617416666662655695A419A9999999DA61741000000604C695A410000000032A71741000000203F695A419A9999993DA71741CDCCCCCC3C695A416666666642A71741666666E635695A4166666666D4A61741000000201D695A4166666666C6A61741000000C010695A4166666666CEA617419A9999D907695A419A999999E1A61741CDCCCC6CFF685A41CDCCCCCC38A7174133333333F8685A41333333336DA71741000000A0F5685A419A99999921A81741CDCCCC0CEE685A4133333333FFA817419A9999D9E5685A419A99999909AA174133333393DB685A410000000048AA174133333373D9685A416666666636AB17419A999979CE685A419A9999994DAC174166666666B7685A41CDCCCCCCECAB1741000000A0AF685A4166666666F2AB1741333333D3B0685A41CDCCCCCCF0AB1741CDCCCC4CB2685A419A999999EDAB174100000000B3685A41CDCCCCCCE0AB174166666606B4685A416666666662AB1741666666C6A7685A41CDCCCCCC52AB1741CDCCCC8CA5685A413333333349AB1741333333F3A2685A419A99999947AB1741CDCCCC2CA0685A41666666664CAB1741666666C69D685A410000000054AB17419A9999799B685A413333333361AB17419A9999D998685A419A99999967AB17419A99997996685A41000000006AAB17413333333393685A41CDCCCCCC68AB1741666666668C685A416666666652AB17413333333381685A410000000050AB1741CDCCCCAC7D685A416666666652AB1741000000007C685A419A9999995DAB17416666668679685A41666666668AAB17419A99993974685A41333333336BAC1741333333535B685A413333333393AC1741000000E055685A4100000000C0AC1741666666864E685A4166666666D0AC17419A9999994B685A419A999999D9AC17410000004048685A416666666694AC17413333331346685A410000000048AC17416666666642685A4100000000D2AB1741333333333B685A419A9999998DAB1741333333B336685A410000000060AB17413333337334685A41666666663AAB17413333331333685A419A999999C5AA17419A9999B931685A4166666666AEAA1741CDCCCC8C30685A41CDCCCCCC8CAA1741666666662B685A413333333351AA17410000002020685A413333333329AA17413333333316685A416666666616AA1741CDCCCC8C12685A410000000004AA1741666666A610685A419A999999ADA91741333333F309685A41CDCCCCCC7EA91741333333B305685A410000000076A91741CDCCCCAC03685A413333333369A91741000000C0FE675A413333333357A91741CDCCCC2CFB675A419A99999949A91741000000C0F9675A41CDCCCCCC2AA91741000000E0F7675A41CDCCCCCCD6A8174166666686F4675A41CDCCCCCC3AA81741666666C6EF675A416666666608A81741666666E6ED675A419A999999DFA7174133333393EB675A410000000036A71741000000A0DE675A413333333317A717419A999959DD675A41333333339BA61741CDCCCC2CDA675A413333333339A61741333333B3D8675A419A9999994DA5174166666686D4675A419A9999990DA51741666666E6D2675A41CDCCCCCCA4A41741333333D3CE675A419A99999955A4174100000080CA675A416666666634A41741CDCCCC6CC9675A41CDCCCCCCEAA31741CDCCCCECC9675A4100000000D8A3174166666666CA675A41CDCCCCCCCCA317419A999919CB675A41CDCCCCCCCAA31741CDCCCC2CCF675A419A999999D9A317419A9999B9D5675A4100000000DAA317419A999999D7675A4166666666CCA317419A9999F9D8675A4100000000A8A317419A999999D9675A41333333338DA21741333333F3DB675A416666666654A2174166666646DC675A41666666662AA2174133333313DC675A419A999999F7A11741333333D3DA675A41CDCCCCCC8CA1174100000040D6675A419A99999957A117419A999939D4675A410000000028A117419A999999D3675A410000000002A1174166666626D4675A4133333333F1A0174100000060D5675A4100000000EAA01741000000C0D6675A4133333333EDA01741CDCCCCCCD8675A4100000000F2A01741666666C6DA675A419A99999903A11741CDCCCCECDD675A41CDCCCCCC22A1174100000020E2675A41333333333BA117419A999919E6675A41CDCCCCCC3CA117419A999979E7675A41666666662EA11741CDCCCCECE8675A416666666618A11741CDCCCCCCE9675A416666666612A11741333333D3E9675A4133333333F5A0174133333393E9675A4100000000DAA017419A9999F9E8675A4100000000BCA01741CDCCCC8CE7675A41CDCCCCCC8AA017419A999939E4675A419A99999971A0174166666666E3675A41333333335FA0174166666686E3675A41333333334BA017419A999939E4675A4166666666E49F174133333373E9675A4100000000989F174100000000EE675A41333333338B9F17419A999959F0675A419A999999839F17419A9999B9F2675A4166666666529F174166666626FC675A419A999999379F1741CDCCCCECFD675A4166666666129F1741666666E6FE675A419A999999F79E1741CDCCCC4CFF675A41333333331B9E17413333337301685A41CDCCCCCCF49D17413333339301685A4100000000C89D17416666666601685A41CDCCCCCC7E9D1741000000C000685A41CDCCCCCC4C9D1741CDCCCCCC00685A4100000000F49C1741CDCCCC6C03685A4100000000989C17410000008004685A41333333336D9C1741CDCCCC2C04685A4166666666509C17419A99997903685A41666666662C9C17416666666601685A4100000000169C1741333333F3FE675A419A999999E59B174166666626F4675A419A999999D59B1741666666C6F1675A4100000000C89B17419A999939F0675A4166666666B89B17419A9999F9EE675A4166666666989B17419A999979ED675A41CDCCCCCC549B17419A999919EB675A4133333333319B1741CDCCCC4CEA675A41CDCCCCCC0A9B174166666626EB675A419A999999A39A174166666626F2675A41000000008C9A174100000080F3675A41CDCCCCCC789A17419A999939F4675A41666666664E9A1741CDCCCCECF4675A41CDCCCCCCC29917419A999959F5675A41CDCCCCCCEA98174133333313F5675A4133333333D3981741CDCCCC8CF5675A4133333333659817419A999999F8675A41000000007E97174100000040FE675A410000000002971741CDCCCC8C02685A419A999999C1961741333333B303685A413333333391961741CDCCCCEC03685A41000000006C961741333333B303685A4166666666B49217419A9999F9F5675A419A9999991B901741333333B3EC675A4133333333E98F1741CDCCCCCCEB675A41000000004E8E174100000060E6675A41000000002A8E174133333393E5675A41CDCCCCCCDA8D1741CDCCCC6CE3675A4166666666BC8D17419A999919E2675A41CDCCCCCCA28D1741000000A0DF675A4100000000968D1741CDCCCC8CDC675A4166666666908D17419A999919D8675A41333333339F8D1741CDCCCCECCE675A419A9999999D8D174166666646CC675A4133333333898D1741333333F3C8675A41CDCCCCCC688D1741000000E0C5675A41333333334D8D17419A9999B9C2675A419A9999993F8D174133333333BC675A419A999999358D1741CDCCCC2CBA675A4133333333278D1741CDCCCC0CB9675A4133333333178D174166666666B8675A4166666666C48C1741CDCCCCECB6675A41333333339F8C1741666666A6B5675A41CDCCCCCC608C174133333333AF675A41333333334D8C1741666666C6AD675A4166666666348C1741CDCCCC6CAC675A4100000000168C1741333333D3AB675A4166666666068C17419A9999B9AB675A4133333333CD8B17419A999939AC675A4100000000B28B1741CDCCCC6CAB675A4100000000A48B17419A9999D9A9675A419A9999999D8B174133333373A8675A41000000009A8B1741CDCCCCECA4675A419A999999978B17410000006099675A41333333338F8B17416666664697675A41333333337D8B1741CDCCCCAC95675A4166666666668B17413333331395675A4166666666528B17419A9999F994675A41000000003A8B1741000000A095675A41CDCCCCCC2E8B17413333333396675A4133333333D98A1741000000809E675A41CDCCCCCCC68A1741666666C69F675A4166666666B68A174166666686A0675A41CDCCCCCCA48A1741333333B3A0675A41333333338F8A1741CDCCCC4CA0675A4100000000808A1741666666869E675A4166666666688A17416666662696675A41666666665C8A17419A9999F98E675A419A9999994D8A17419A9999F98C675A41CDCCCCCC428A17419A9999398C675A41CDCCCCCC2E8A1741CDCCCCAC8B675A4100000000048A1741CDCCCC6C8B675A4166666666DE891741CDCCCC8C8B675A416666666688891741666666868C675A416666666670891741333333538D675A410000000048891741333333738F675A41000000002C891741CDCCCC6C90675A41CDCCCCCC108917410000008090675A4133333333F98817419A9999398F675A4166666666E0881741666666668C675A4133333333D18817413333337389675A4100000000D0881741CDCCCCCC87675A4166666666D48817416666664686675A4133333333DF881741333333D384675A4100000000FE881741CDCCCC4C82675A41CDCCCCCC1C891741333333B380675A419A9999994B8917419A9999797E675A4166666666CC8917413333337379675A4100000000E8891741666666C677675A419A999999E98917410000004077675A4133333333DF891741000000C075675A4100000000D6891741333333F374675A41CDCCCCCCBC8917416666662674675A41000000009C8917419A9999B972675A41000000008C8917410000008071675A419A99999985891741000000A070675A419A999999618917413333333368675A419A999999498917413333333361675A419A99999933891741333333535A675A41CDCCCCCC248917413333335354675A41000000001A8917410000000053675A419A999999038917413333331352675A419A99999993881741333333534F675A419A99999975881741666666264E675A419A9999995F8817419A9999F94C675A41CDCCCCCC54881741000000004C675A41666666664E881741000000004B675A410000000048881741666666E644675A413333333331881741CDCCCC6C42675A4133333333D7871741666666463D675A41CDCCCCCC768717416666662639675A413333333313871741CDCCCCCC35675A4166666666FA8617416666666634675A4100000000EC861741CDCCCCAC2F675A419A999999E5861741000000A027675A4133333333DF861741666666C625675A4133333333BD8617410000002020675A4100000000B4861741000000201D675A41CDCCCCCCA28617419A9999F91A675A416666666690861741666666461A675A41CDCCCCCC68861741333333D319675A419A99999927861741666666A619675A41CDCCCCCCFE851741333333F319675A419A99999903851741CDCCCC2C1F675A4133333333E1841741666666261F675A419A999999D1841741333333331E675A41CDCCCCCCCC841741000000201D675A4100000000DA8417416666662616675A4166666666DE8417419A9999B911675A4166666666D8841741666666E60F675A41CDCCCCCCA28417413333333307675A413333333393841741666666A6FD665A419A9999998B8417419A999919FC665A4100000000828417419A999939FB665A419A99999975841741CDCCCC8CFA665A41333333334F84174133333333F9665A4100000000308417419A999979F8665A419A9999991B84174100000060F8665A416666666600841741000000A0F8665A4166666666DC83174166666666F9665A4133333333CB83174166666646FA665A4133333333B9831741666666A6FB665A4166666666848317413333331301675A41CDCCCCCC6C831741333333B302675A41CDCCCCCC188317419A9999D906675A4166666666FA8217419A9999F907675A4166666666E2821741333333B308675A419A999999BB8217419A99997909675A416666666692821741CDCCCC2C0A675A419A9999993F821741CDCCCC2C0B675A41CDCCCCCCF0811741666666A60B675A4166666666C48117419A9999D90A675A4100000000B6811741333333D309675A4100000000AA8117416666668608675A4100000000A8811741CDCCCC0C08675A41CDCCCCCCAC811741666666E605675A4133333333FB81174133333373FD665A41000000003282174166666666F5665A41333333335D82174166666626EA665A41333333335B8217419A999959E8665A419A99999951821741333333B3E7665A41666666661682174166666626E6665A4100000000FE8117419A9999D9E5665A4133333333D781174100000060E6665A41666666669881174100000060F0665A419A9999998181174100000000F3665A41CDCCCCCC628117419A9999B9F5665A41CDCCCCCC368117419A999939F7665A410000000002811741333333F3F7665A4166666666E0801741666666C6F7665A4100000000BE80174166666606F7665A419A999999AD80174133333353F6665A419A99999977801741CDCCCCECF1665A41CDCCCCCC0280174100000060EA665A4100000000F87F174133333313E9665A4166666666D07F1741000000A0E7665A4100000000B27F1741666666A6E6665A419A999999857F17419A999999E5665A4100000000EE7E174133333313E3665A4100000000DC7E1741000000A0E2665A4100000000B07D1741666666E6D8665A419A9999991D7B1741CDCCCCECC2665A4166666666FC791741CDCCCC0CB8665A41CDCCCCCCC07917419A999939B6665A41000000009079174100000000B5665A419A999999CB781741CDCCCC6CB0665A41CDCCCCCC0678174133333313AA665A41CDCCCCCCD4771741666666E6A7665A4166666666CC771741666666C6A5665A4166666666C2771741CDCCCC4CA1665A4133333333B5771741CDCCCCCC97665A41CDCCCCCCB27717419A9999F992665A4100000000B6771741000000E08F665A4100000000BC7717419A9999F98B665A419A999999CB7717413333333387665A4133333333C57717416666660685665A419A999999BD7717419A99999984665A419A999999AB7717419A9999F983665A416666666688771741000000C083665A419A999999657717419A9999F983665A41666666664E771741666666C684665A419A9999993D7717410000000086665A4100000000307717413333331388665A416666666612771741333333738E665A416666666602771741666666C690665A419A999999E97617419A9999F992665A4100000000C67617416666666695665A4100000000A6761741666666C696665A4133333333657617410000006098665A4166666666567617416666668698665A41000000004A7617410000004098665A41CDCCCCCC347617413333333397665A4166666666207617410000006094665A4100000000127617416666668690665A410000000004761741CDCCCC0C88665A4166666666EC751741CDCCCCCC83665A4100000000D4751741666666A681665A4166666666B8751741CDCCCCAC7F665A419A99999957751741000000C07A665A41000000003C751741333333B379665A41333333331D7517419A9999D978665A419A999999DF741741CDCCCCAC77665A4166666666887417419A9999B976665A419A999999557417410000008077665A41CDCCCCCC28741741CDCCCC0C79665A41CDCCCCCCF8731741666666067B665A4133333333C57317419A9999397E665A41000000008C7317419A9999F982665A41666666666E731741000000E083665A41666666665C731741000000A083665A413333333353731741CDCCCC2C83665A41000000004E7317416666668682665A4100000000227317413333333379665A419A9999990D7317419A99997973665A4100000000FC7217419A99991970665A4133333333E37217419A9999396E665A4133333333BD7217419A9999396C665A41CDCCCCCC8C721741CDCCCCCC6A665A413333333355721741000000C069665A410000000064711741CDCCCC6C6B665A4133333333DD701741333333136C665A4100000000B27017419A9999996C665A416666666694701741CDCCCC8C6D665A41333333334D7017413333333372665A419A9999993F7017410000008074665A419A999999457017419A99993977665A419A99999981701741CDCCCC0C7D665A419A99999987701741333333137E665A419A99999985701741000000A07F665A4100000000807017419A99993980665A41000000006C701741333333B380665A410000000054701741CDCCCCEC80665A4166666666B66F17419A99993981665A4133333333136F17419A99993981665A419A999999F96E1741CDCCCCAC81665A4100000000C66E17419A99999983665A4166666666B46E17413333337384665A41333333338D6E1741333333F386665A41000000007E6E1741000000E088665A41666666667C6E1741CDCCCC0C8A665A419A9999997F6E1741333333538B665A41333333339B6E1741CDCCCCEC8D665A4133333333A16E1741CDCCCCAC8F665A419A9999999F6E17419A99995994665A41CDCCCCCC9A6E17410000000096665A4166666666946E17416666660697665A419A9999998B6E17419A99999997665A419A9999997D6E17419A9999F997665A41CDCCCCCC4E6E17413333337397665A4100000000146E1741666666C695665A4100000000D26D17419A99993994665A4133333333916D17419A99997993665A419A999999636D17413333333393665A4100000000486D17413333335393665A41CDCCCCCC1A6D17416666662693665A419A999999CB6C1741666666C691665A4100000000846C1741000000A091665A41666666663C6C17419A99995992665A419A999999EB6B17419A9999F993665A419A999999DB6B17416666662694665A4133333333BF6B1741333333F393665A4166666666A86B17419A99995992665A4133333333816B17419A9999B98D665A4100000000646B1741000000A089665A41CDCCCCCC586B17416666668688665A41CDCCCCCC3E6B17419A9999F986665A41333333330B6B17419A99999984665A41CDCCCCCCD26A17416666668682665A4133333333916A1741666666E680665A4100000000646A17419A99997980665A419A999999E36917419A99999980665A419A9999998B6917419A99991980665A419A9999993B691741333333D396665A419A99999929691741666666C69E665A41000000002069174100000020A8665A41CDCCCCCC2069174166666606AA665A413333333365691741CDCCCC8CAA665A4100000000046A174100000040AC665A4133333333956A17419A999959AD665A4133333333796A1741666666C6B0665A4100000000766A174100000040B2665A419A9999997B6A1741CDCCCC2CB3665A4166666666206A174166666686BC665A4133333333236A174100000000BD665A419A999999CF6817419A9999D9BA665A4100000000726817419A9999D9C8665A41666666662A681741666666E6D1665A41000000008E67174166666606E4665A41CDCCCCCCA0671741CDCCCC8CE4665A4100000000946617419A9999B906675A41000000004E6617419A9999F903675A4133333333FB65174133333393FF665A410000000082651741666666C6F6665A41CDCCCCCC7265174100000040F7665A413333333353651741CDCCCC4CF9665A41000000003C651741000000A0FB665A416666666606651741CDCCCCCCFF665A413333333395641741000000E002675A4100000000906417413333333303675A41666666666A641741CDCCCC0C06675A419A999999476417410000006009675A41000000002A641741333333D30C675A41CDCCCCCC1A641741CDCCCC0C0F675A4100000000146417419A99991912675A4133333333116417413333335316675A419A999999116417416666666623675A4166666666206317419A99991921675A41CDCCCCCCD8621741CDCCCC4C21675A4100000000F4621741000000402A675A4166666666F86217419A99991931675A4166666666F26217416666660639675A41CDCCCCCCE46217413333333342675A4100000000D4621741CDCCCC0C54675A41333333339B6217410000000056675A413333333369621741CDCCCCCC58675A4133333333496217419A9999995F675A41333333330D621741000000E06A675A4166666666EE611741CDCCCCCC6A675A41CDCCCCCC2C6117410000004069675A4100000000F4601741666666467C675A416666666602601741CDCCCCEC8D675A419A999999B75F1741666666A692675A419A9999993B5F1741000000C098675A4166666666F05E1741000000E09C675A4133333333FF5D174166666666AD675A4166666666385D17419A999979A6675A419A999999DF5C17419A999939A4675A4166666666465C174166666686A1675A4166666666745C1741333333D395675A4100000000FA5A1741CDCCCC6C8C675A419A9999997F5A17413333339392675A41666666666A5A17416666662693675A419A999999FF591741CDCCCC6C95675A4100000000CC5917410000000096675A419A999999795917410000004096675A41000000006C591741000000C096675A41CDCCCCCCF85817419A9999D99D675A41666666667858174100000040A7675A41666666667258174166666666A8675A41000000006E581741333333D3A9675A419A9999993B5817419A999919B1675A419A9999992B58174166666646B2675A41000000001A581741CDCCCC2CB3675A4166666666EC5717419A9999B9B4675A4166666666C2571741000000E0B5675A419A999999AB571741333333B3B6675A4133333333A157174100000060B7675A4133333333455717419A999919C2675A41666666669C561741333333D3CF675A41000000005056174166666626DD675A41333333331F5617419A9999B9E6675A41CDCCCCCC18561741000000C0E8675A41CDCCCCCCF2551741CDCCCCECE9675A419A999999375517419A9999B9EE675A41CDCCCCCC0E5517419A999979F0675A419A999999E1541741000000C0F1675A4166666666B654174133333373F2675A410000000076541741000000A0F2675A41000000000E54174166666686F4675A41CDCCCCCC0054174166666686F4675A4100000000FE5317419A9999F9F4675A41	01060000206A080000010000000103000000010000005101000000000000FE5317419A9999F9F4675A4100000000485517419A9999991E685A4133333333B95617413333331341685A4100000000B0571741000000A053685A419A999999D35717416666662652685A419A999999315817413333331354685A41CDCCCCCCB85717416666660664685A4133333333215817419A9999D966685A4166666666A05817410000002068685A419A999999A5581741CDCCCC2C6E685A413333333379581741CDCCCC6C7A685A4133333333EB5717419A99993994685A419A999999BB5717410000008099685A41CDCCCCCCE856174133333373A6685A41666666660256174133333353AF685A4133333333BF54174133333353BD685A41000000006655174166666666C6685A4100000000D856174100000000C2685A4133333333375717419A999959C2685A41CDCCCCCCF256174166666666D9685A4166666666E0561741666666E6E7685A41666666669C561741CDCCCC4CF9685A4133333333B557174100000020F9685A41000000003C5817419A999939F7685A41666666660859174100000080F2685A41CDCCCCCCE4591741CDCCCCACE9685A4100000000325A174166666626F7685A419A999999715C174133333353F7685A419A999999C15C1741CDCCCCCCF8685A4100000000D05C174133333313F6685A41666666663E5E17419A9999D909695A416666666658601741333333D32A695A41CDCCCCCCEC601741000000E032695A4166666666BA6317413333335352695A419A999999EF641741333333D35E695A41666666662C651741000000C062695A419A99999959661741000000A071695A41CDCCCCCC526917419A9999F994695A4133333333F9691741666666E69B695A419A999999E36A174133333373A2695A419A999999196C1741666666C6A5695A41666666669A6D174166666686A7695A4166666666346E17419A9999F9A9695A41CDCCCCCC2E6E1741CDCCCCECAD695A419A9999997D6E1741666666A6B4695A4166666666E86E17419A9999B9B9695A4166666666CE6F1741CDCCCCCCC6695A416666666622701741CDCCCC4CD0695A41CDCCCCCC4270174100000080DE695A41CDCCCCCCD071174166666686E4695A41CDCCCCCC4C741741CDCCCCACE2695A4166666666EC751741666666660A6A5A410000000032761741000000800F6A5A41333333337B791741CDCCCC2C346A5A4166666666EE7F1741000000007B6A5A41CDCCCCCCB48517419A999919BB6A5A4166666666F885174166666626C26A5A4166666666D28617419A999979C36A5A416666666618881741666666E6C96A5A4166666666FA8817419A999959CD6A5A41CDCCCCCCFE89174133333393CE6A5A41CDCCCCCC788A1741666666E6CD6A5A41333333333B8C1741CDCCCCACC66A5A41CDCCCCCC1A8D1741CDCCCCCCC06A5A41CDCCCCCC668D174100000080BD6A5A4100000000A88D1741CDCCCC8CAF6A5A41000000000E8E1741333333739E6A5A4166666666608E174166666646936A5A4166666666FA8E174166666606836A5A4100000000708F174133333333756A5A41333333339D8F1741000000006A6A5A419A999999978F1741000000E0616A5A4133333333758F17419A9999795B6A5A419A999999E18E1741000000004C6A5A4133333333818E1741666666E64C6A5A41CDCCCCCC6C8C17419A9999B9476A5A4100000000B28B1741000000E0426A5A4166666666568B1741CDCCCCEC3A6A5A4133333333278B1741666666A6336A5A4100000000228B174133333313286A5A4100000000A88B1741CDCCCC0C116A5A41CDCCCCCC6E8C174133333313FD695A41CDCCCCCCB08C17419A999959EE695A4133333333A98C174166666666D4695A41CDCCCCCCBC8C17419A999959CD695A419A9999992F8D1741333333F3C3695A4100000000E88D17419A999999BE695A4166666666288F1741CDCCCC6CB8695A41333333332F90174100000040B5695A41666666666E901741CDCCCC8CB0695A4133333333D590174133333353AC695A4166666666A6921741666666C6A3695A4133333333C3921741CDCCCC0CA2695A416666666636941741666666E697695A41CDCCCCCCEC941741000000C093695A41CDCCCCCC30961741333333F38D695A416666666604971741000000E08C695A4133333333179917419A9999F990695A41CDCCCCCCC0991741CDCCCCEC90695A4100000000E09917419A99997995695A4166666666FE9917419A999919A7695A41666666663C9A1741333333D3B2695A41CDCCCCCCBE9A174166666686BD695A41CDCCCCCC349B1741666666E6C4695A419A9999998B9B1741000000A0C7695A41CDCCCCCC129C1741000000E0C8695A4166666666829C17419A999999C3695A41CDCCCCCC009D1741333333F3B5695A4166666666869D174166666606AB695A41CDCCCCCCE29D17419A999939A6695A4166666666389E1741CDCCCC8CA4695A4166666666949E174133333353A6695A4100000000789F1741CDCCCC2CB0695A41CDCCCCCC28A01741CDCCCC4CB6695A41CDCCCCCCD4A01741333333D3B7695A416666666688A11741CDCCCC6CB4695A41CDCCCCCCDAA1174133333313AC695A41000000000CA2174166666626A1695A41666666662AA21741000000C08A695A41CDCCCCCC7EA217416666660677695A419A999999C9A21741666666A66A695A41CDCCCCCCE0A31741CDCCCCCC65695A41CDCCCCCC46A417413333331365695A419A999999DDA517410000002058695A413333333327A617416666662655695A419A9999999DA61741000000604C695A410000000032A71741000000203F695A416666666642A71741666666E635695A4166666666D4A61741000000201D695A4166666666C6A61741000000C010695A419A999999E1A61741CDCCCC6CFF685A41CDCCCCCC38A7174133333333F8685A419A99999921A81741CDCCCC0CEE685A410000000048AA174133333373D9685A416666666636AB17419A999979CE685A419A9999994DAC174166666666B7685A41CDCCCCCCECAB1741000000A0AF685A41CDCCCCCCE0AB174166666606B4685A416666666662AB1741666666C6A7685A419A99999947AB1741CDCCCC2CA0685A419A99999967AB17419A99997996685A41CDCCCCCC68AB1741666666668C685A416666666652AB1741000000007C685A41666666668AAB17419A99993974685A41333333336BAC1741333333535B685A419A999999D9AC17410000004048685A410000000048AC17416666666642685A419A9999998DAB1741333333B336685A41666666663AAB17413333331333685A4166666666AEAA1741CDCCCC8C30685A410000000004AA1741666666A610685A41CDCCCCCC7EA91741333333B305685A413333333357A91741CDCCCC2CFB675A41CDCCCCCC2AA91741000000E0F7675A41CDCCCCCC3AA81741666666C6EF675A419A999999DFA7174133333393EB675A410000000036A71741000000A0DE675A41333333339BA61741CDCCCC2CDA675A419A9999994DA5174166666686D4675A41CDCCCCCCA4A41741333333D3CE675A416666666634A41741CDCCCC6CC9675A41CDCCCCCCCCA317419A999919CB675A4100000000DAA317419A999999D7675A4100000000A8A317419A999999D9675A41333333338DA21741333333F3DB675A419A999999F7A11741333333D3DA675A419A99999957A117419A999939D4675A410000000002A1174166666626D4675A4100000000F2A01741666666C6DA675A41333333333BA117419A999919E6675A416666666618A11741CDCCCCCCE9675A4100000000DAA017419A9999F9E8675A41CDCCCCCC8AA017419A999939E4675A41333333334BA017419A999939E4675A4100000000989F174100000000EE675A4166666666529F174166666626FC675A419A999999F79E1741CDCCCC4CFF675A41333333331B9E17413333337301685A41CDCCCCCC4C9D1741CDCCCCCC00685A4100000000989C17410000008004685A4166666666509C17419A99997903685A4100000000169C1741333333F3FE675A419A999999E59B174166666626F4675A4166666666B89B17419A9999F9EE675A4133333333319B1741CDCCCC4CEA675A419A999999A39A174166666626F2675A41666666664E9A1741CDCCCCECF4675A41CDCCCCCCEA98174133333313F5675A41000000007E97174100000040FE675A410000000002971741CDCCCC8C02685A41000000006C961741333333B303685A4166666666B49217419A9999F9F5675A41000000004E8E174100000060E6675A41CDCCCCCCDA8D1741CDCCCC6CE3675A41CDCCCCCCA28D1741000000A0DF675A4166666666908D17419A999919D8675A41333333339F8D1741CDCCCCECCE675A4133333333898D1741333333F3C8675A41333333334D8D17419A9999B9C2675A419A999999358D1741CDCCCC2CBA675A41333333339F8C1741666666A6B5675A4166666666348C1741CDCCCC6CAC675A4100000000B28B1741CDCCCC6CAB675A419A9999999D8B174133333373A8675A419A999999978B17410000006099675A41333333337D8B1741CDCCCCAC95675A41CDCCCCCC2E8B17413333333396675A4166666666B68A174166666686A0675A4100000000808A1741666666869E675A41666666665C8A17419A9999F98E675A41CDCCCCCC2E8A1741CDCCCCAC8B675A416666666688891741666666868C675A41000000002C891741CDCCCC6C90675A4133333333F98817419A9999398F675A4133333333D18817413333337389675A4100000000FE881741CDCCCC4C82675A419A999999E98917410000004077675A419A99999985891741000000A070675A419A999999618917413333333368675A41CDCCCCCC248917413333335354675A419A99999993881741333333534F675A41666666664E881741000000004B675A410000000048881741666666E644675A4133333333D7871741666666463D675A4166666666FA8617416666666634675A419A999999E5861741000000A027675A41CDCCCCCCA28617419A9999F91A675A41CDCCCCCCFE851741333333F319675A419A99999903851741CDCCCC2C1F675A41CDCCCCCCCC841741000000201D675A4166666666DE8417419A9999B911675A41CDCCCCCCA28417413333333307675A413333333393841741666666A6FD665A4100000000308417419A999979F8665A4166666666DC83174166666666F9665A4166666666848317413333331301675A41CDCCCCCC188317419A9999D906675A416666666692821741CDCCCC2C0A675A4166666666C48117419A9999D90A675A41CDCCCCCCAC811741666666E605675A41000000003282174166666666F5665A41333333335D82174166666626EA665A419A99999951821741333333B3E7665A4133333333D781174100000060E6665A41666666669881174100000060F0665A41CDCCCCCC628117419A9999B9F5665A4166666666E0801741666666C6F7665A419A999999AD80174133333353F6665A4100000000F87F174133333313E9665A419A999999857F17419A999999E5665A4100000000DC7E1741000000A0E2665A419A9999991D7B1741CDCCCCECC2665A4166666666FC791741CDCCCC0CB8665A419A999999CB781741CDCCCC6CB0665A41CDCCCCCCD4771741666666E6A7665A41CDCCCCCCB27717419A9999F992665A419A999999CB7717413333333387665A419A999999AB7717419A9999F983665A419A9999993D7717410000000086665A416666666602771741666666C690665A4100000000C67617416666666695665A4133333333657617410000006098665A41CDCCCCCC347617413333333397665A4100000000127617416666668690665A410000000004761741CDCCCC0C88665A4166666666B8751741CDCCCCAC7F665A41333333331D7517419A9999D978665A4166666666887417419A9999B976665A41CDCCCCCCF8731741666666067B665A41000000008C7317419A9999F982665A41000000004E7317416666668682665A4100000000FC7217419A99991970665A4133333333BD7217419A9999396C665A413333333355721741000000C069665A4133333333DD701741333333136C665A416666666694701741CDCCCC8C6D665A41333333334D7017413333333372665A419A999999457017419A99993977665A419A99999981701741CDCCCC0C7D665A410000000054701741CDCCCCEC80665A4133333333136F17419A99993981665A4166666666B46E17413333337384665A41000000007E6E1741000000E088665A419A9999999F6E17419A99995994665A419A9999997D6E17419A9999F997665A4100000000D26D17419A99993994665A4100000000846C1741000000A091665A419A999999EB6B17419A9999F993665A4166666666A86B17419A99995992665A4100000000646B1741000000A089665A41CDCCCCCCD26A17416666668682665A4100000000646A17419A99997980665A419A9999998B6917419A99991980665A419A9999993B691741333333D396665A41CDCCCCCC2069174166666606AA665A4133333333956A17419A999959AD665A419A9999997B6A1741CDCCCC2CB3665A4133333333236A174100000000BD665A419A999999CF6817419A9999D9BA665A4100000000726817419A9999D9C8665A41000000008E67174166666606E4665A41CDCCCCCCA0671741CDCCCC8CE4665A4100000000946617419A9999B906675A4133333333FB65174133333393FF665A410000000082651741666666C6F6665A416666666606651741CDCCCCCCFF665A413333333395641741000000E002675A41CDCCCCCC1A641741CDCCCC0C0F675A419A999999116417416666666623675A4166666666206317419A99991921675A41CDCCCCCCD8621741CDCCCC4C21675A4166666666F86217419A99991931675A4100000000D4621741CDCCCC0C54675A413333333369621741CDCCCCCC58675A41333333330D621741000000E06A675A41CDCCCCCC2C6117410000004069675A4100000000F4601741666666467C675A416666666602601741CDCCCCEC8D675A4166666666F05E1741000000E09C675A4133333333FF5D174166666666AD675A4166666666385D17419A999979A6675A4166666666465C174166666686A1675A4166666666745C1741333333D395675A4100000000FA5A1741CDCCCC6C8C675A419A9999997F5A17413333339392675A419A999999FF591741CDCCCC6C95675A419A999999795917410000004096675A41CDCCCCCCF85817419A9999D99D675A41666666667858174100000040A7675A419A9999993B5817419A999919B1675A4133333333A157174100000060B7675A4133333333455717419A999919C2675A41666666669C561741333333D3CF675A41CDCCCCCC18561741000000C0E8675A4166666666B654174133333373F2675A4100000000FE5317419A9999F9F4675A4100000000FE5317419A9999F9F4675A41	01010000206A080000A0FD33776C811741000000A09C685A41	500160000	Z	Appeville	5001600	50016	50	28	13
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	01010000206A0800003C14459C8F8E1641666666A65E125A41	500190000	Z	Aucey-la-Plaine	5001900	50019	50	28	9
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	01010000206A08000002C0B5B38F0318419A9999B904725A41	500210000	Z	Audouville-la-Hubert	5002100	50021	50	28	6
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	01010000206A080000A42618EF049E1741CDCCCC0C817F5A41	500220000	Z	Aumeville-Lestre	5002200	50022	50	28	3
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	01010000206A080000588130F28D861741000000508D655A41	500230000	Z	Auvers	5002300	50023	50	28	19
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	01010000206A080000C9E57DF9F3961741CDCCCC5C5B5C5A41	500240000	Z	Auxais	5002400	50024	50	28	8
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	01010000206A080000DAB29AC3312717413333334304235A41	500250101	H	Quartier Centre Ville	5002501	50025	50	28	1
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	01010000206A080000EBE2920F181D1741CDCCCCBC94235A41	500250102	H	Quartier Périphérique Nord-Ouest	5002501	50025	50	28	3
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	01010000206A080000690B6F7E023317419A9999497C225A41	500250103	H	Quartier H.L.M.	5002501	50025	50	28	1
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	01010000206A08000008835343F53F17419A9999A9CA205A41	500250201	H	Saint-Martin-des-Champs	5002502	50025	50	28	7
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	01010000206A08000038BD40A0AEA517416666669680765A41	500260000	Z	Azeville	5002600	50026	50	28	3
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	01010000206A080000068AB61A99D116419A99995991255A41	500270000	Z	Bacilly	5002700	50027	50	28	16
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	01010000206A08000022C559ECA07F1741CCCCCCECB83C5A41	500280000	Z	La Baleine	5002800	50028	50	28	4
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	01010000206A0800005E6436D13879194133333343BE185A41	500290000	Z	Barenton	5002900	50029	50	28	36
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	01010000206A080000A08FE42179EC1741000000A0618D5A41	500300000	Z	Barfleur	5003000	50030	50	28	1
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	01010000206A080000D2A726A026A7154100000020DF6F5A41	500310000	Z	Barneville-Carteret	5003100	50031	50	28	10
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	01060000206A08000001000000010300000001000000E900000000000000B4B61841666666868D4E5A410000000088B7184166666646A64E5A4133333333F3B718419A999939AD4E5A4166666666BCB718419A999999BB4E5A41000000004AB8184133333313C14E5A416666666682B918419A999979C94E5A410000000044B9184100000040D84E5A419A99999955B91841CDCCCCECE64E5A41666666669AB91841CDCCCCECEE4E5A41666666665ABA184133333353FF4E5A41CDCCCCCCF2BA1841CDCCCC0C0E4F5A419A999999A9BB1841CDCCCC6C244F5A419A9999999BBB1841CDCCCCCC274F5A419A9999992FBC1841000000E0324F5A416666666602BD1841000000804D4F5A41CDCCCCCCA6BC18419A9999195D4F5A4100000000B6BE1841CDCCCCEC674F5A416666666684BE1841666666467A4F5A41CDCCCCCC40BE1841000000C08E4F5A41CDCCCCCC26BE1841000000E09A4F5A419A99999937BE184100000080A04F5A416666666692BE184100000040AA4F5A419A9999990DBF184100000020B54F5A419A99999903BF1841CDCCCC8CBA4F5A4100000000BEBE184133333313C54F5A419A999999E7BD184133333393E84F5A41666666669CBD1841000000C0E84F5A410000000036BD184166666626F74F5A419A999999A7BE1841666666E604505A41333333337DBE18419A9999590F505A41CDCCCCCC88BE18419A99997911505A41CDCCCCCC04BE1841000000C024505A41CDCCCCCCF0BD18419A9999D92C505A41CDCCCCCC56BD1841CDCCCCAC45505A410000000036BE1841CDCCCCAC47505A413333333347BE1841CDCCCC4C51505A410000000096BE18419A99991955505A4133333333D1BE1841333333F363505A413333333303BE1841333333D389505A419A999999D1BD1841000000409C505A4100000000E8BD18419A9999F99C505A41CDCCCCCC9ABD1841666666A6B7505A410000000074BD184166666646BF505A41CDCCCCCCA8C118419A9999D9D9505A419A999999BFC4184133333393ED505A41CDCCCCCCB6C51841CDCCCC2CCC505A41000000005EC61841333333D3BB505A41CDCCCCCC06C71841000000E0A6505A41000000008CC718419A9999F998505A4133333333C7C81841CDCCCC2C7D505A419A999999C5C818416666668675505A41CDCCCCCCA0C818416666668670505A4133333333FBC81841666666A665505A413333333327C91841333333F368505A419A999999D7C91841666666C66C505A410000000018CA18413333339370505A4100000000CCCA1841333333D373505A419A999999D3CB1841CDCCCCCC7D505A419A99999945CC1841CDCCCCCC7B505A4100000000D0CC18410000006085505A41666666664CCD18410000008088505A41CDCCCCCCCECD18419A99993990505A41CDCCCCCCA4CD1841CDCCCC4C97505A410000000024CF1841333333F3A3505A4166666666E0D0184133333373AE505A419A99999987D11841CDCCCC6CB4505A4166666666DCD118419A9999D9BB505A4166666666DCD11841CDCCCC6CC0505A413333333331D218419A999979C4505A4133333333A5D2184100000020C6505A419A999999F3D2184166666686C4505A413333333363D3184166666606C6505A410000000036D41841CDCCCC6CC4505A41000000005ED41841333333F3C5505A413333333383D51841333333D3C5505A419A999999E9D51841666666C6C7505A419A9999993FD61841333333F3C0505A416666666684D7184166666666C2505A41333333333FD81841CDCCCC0CC6505A410000000098D81841666666E6C4505A416666666652D918419A999979C6505A4133333333FFD91841000000C0C9505A416666666670DA1841000000E0C9505A413333333319DB18419A9999D9C7505A419A999999E7DB184100000060C8505A41CDCCCCCC1CDC184166666646CB505A419A99999977DC184166666626CA505A419A999999C7DC184166666626C5505A413333333383DD1841000000C0C2505A4100000000AADE184133333373BC505A413333333317DF1841666666C6BD505A41CDCCCCCC90DF18419A999999BC505A410000000054E018419A999959BE505A413333333349E018419A999939B8505A41CDCCCCCC58E41841666666E6BA505A41CDCCCCCC7CE41841666666C6BA505A41CDCCCCCCA8E4184166666626A2505A41CDCCCCCCB6E518413333337389505A41CDCCCCCCBCE61841CDCCCC6C74505A41CDCCCCCC22E718416666662670505A419A9999997BE91841CDCCCC4C5C505A41000000005EEA18410000008053505A413333333325EA1841000000C04B505A413333333329EB1841000000A048505A41333333335FEC18419A99995942505A410000000036EE18419A9999F930505A41CDCCCCCC2AEF18410000006029505A41000000005EF01841333333F322505A41CDCCCCCCCEF01841666666A621505A4166666666BCF11841CDCCCCCC22505A41CDCCCCCCC4F31841000000A02B505A4133333333B1F41841333333D32D505A41333333332DF61841CDCCCC2C33505A413333333309F81841000000403B505A4133333333FBF918419A9999D942505A410000000086FB1841CDCCCCEC46505A4166666666E2F918419A99995937505A410000000002F81841CDCCCCEC20505A410000000094F71841CDCCCC8C1C505A419A9999997BF618419A9999D913505A41CDCCCCCC1CF51841333333F309505A419A99999977F31841666666C601505A4100000000AEF11841CDCCCC0CFB4F5A4166666666A8F21841666666E6CC4F5A4133333333F3F11841666666E6C94F5A419A999999A1F1184100000060C74F5A41666666663EF018419A999919BF4F5A41CDCCCCCCA0F01841CDCCCC6CB34F5A419A999999A5EF1841333333B3AC4F5A419A9999994FF018419A9999198B4F5A41CDCCCCCC52F01841333333937E4F5A4100000000A2EF1841000000607A4F5A4166666666FAEE184100000080704F5A419A999999EDEE1841333333136D4F5A419A999999DBED18419A9999995A4F5A413333333375ED18419A999919564F5A4100000000DCEC1841000000A04C4F5A41000000007AEC1841CDCCCCAC4B4F5A413333333343EC1841CDCCCCAC474F5A41CDCCCCCCD0EB184100000020444F5A416666666662EB184100000060434F5A4166666666A0EA1841CDCCCCAC3D4F5A4100000000E2E91841000000402F4F5A419A99999903E91841666666E6294F5A41333333336FE81841000000A0294F5A41CDCCCCCC4CE71841CDCCCCCC254F5A419A9999998FE61841CDCCCCEC244F5A41000000005CE51841CDCCCC2C2A4F5A41CDCCCCCC80E4184100000020284F5A419A999999C1E21841333333D3224F5A41666666664EE21841666666C61E4F5A419A99999927E21841000000601F4F5A419A999999B3E1184133333333194F5A413333333371E11841000000A0174F5A4100000000D2E01841000000600F4F5A41666666667EE01841333333130D4F5A41000000007EE018419A999939094F5A4166666666E2DF184100000000F94E5A419A99999935DF1841333333D3EB4E5A41CDCCCCCC80DC1841666666A6D24E5A419A9999993DDC1841333333D3D34E5A41666666663CDC1841000000C0CD4E5A416666666662DD184133333353CD4E5A416666666696DE18419A999939B54E5A4100000000EADE1841000000C0AB4E5A410000000080DF184133333373974E5A419A999999D7DF1841333333D3904E5A41666666661CE018419A999999884E5A416666666616E018419A9999B9824E5A416666666646E01841000000007B4E5A4100000000C2E01841666666C6784E5A41CDCCCCCCB6E11841333333F3704E5A4166666666EAE118419A9999196C4E5A4100000000CAE1184100000060664E5A419A99999913E21841333333B3614E5A419A999999BDE21841CDCCCCCC5F4E5A41CDCCCCCCDEE2184133333313624E5A419A99999941E31841666666065B4E5A4166666666B6E218419A9999F93F4E5A419A9999995DE21841666666A6324E5A413333333329E2184133333313234E5A41CDCCCCCC48E1184133333393254E5A4166666666C8DF184133333313264E5A4133333333FDDE184166666686254E5A4166666666A2DC1841666666C60B4E5A4133333333E1DB1841CDCCCC0C034E5A41333333339BDB18419A999979014E5A410000000086DA1841000000C0F74D5A41CDCCCCCC6AD9184100000080EF4D5A416666666692D818419A9999F9EB4D5A4133333333E1D61841666666C6DE4D5A419A999999EBD518419A999979DB4D5A4100000000F2D418419A999959DB4D5A419A9999995DD118419A999959CD4D5A419A999999C1CF1841CDCCCC6CC24D5A419A9999996FCE18419A999979C94D5A419A9999992DCE18419A999979DA4D5A4100000000CACB18419A999919DA4D5A410000000070C9184100000080D54D5A419A99999919C91841333333F3D34D5A416666666670C61841CDCCCC0CD04D5A413333333399C5184166666686CF4D5A41CDCCCCCC68C518419A999919D24D5A4100000000F4C418419A999939E04D5A41CDCCCCCC9AC41841333333F3E74D5A4100000000FCC318419A9999B9FD4D5A419A999999EBC318419A999999FE4D5A413333333399C31841000000C01C4E5A41CDCCCCCC70C31841CDCCCCAC544E5A41666666662CC31841333333B3554E5A41000000007AC11841000000C05F4E5A416666666614C11841CDCCCCCC604E5A41CDCCCCCC18C018419A999999604E5A419A999999A1BF1841CDCCCCEC694E5A41CDCCCCCC36BF1841333333B36B4E5A4133333333A3BD184100000060894E5A41CDCCCCCC1CBD18419A999939854E5A4100000000DABC18419A9999B97F4E5A4133333333D3BB1841666666267B4E5A4100000000EEBA1841666666C67A4E5A413333333383BA184166666626794E5A4133333333F5B91841CDCCCCCC794E5A41CDCCCCCCE4B91841CDCCCCAC734E5A419A99999991B9184100000020724E5A419A999999EDB8184100000080764E5A4100000000A4B81841CDCCCC2C7C4E5A41333333332DB81841666666A67F4E5A41CDCCCCCC1AB81841CDCCCC2C824E5A41CDCCCCCCB0B71841666666C6844E5A416666666692B718419A999979834E5A4100000000E8B6184133333313894E5A4100000000B4B61841666666868D4E5A4100000000B4B61841666666868D4E5A41	01010000206A080000D40BBDC033D5184134333313584F5A41	500320000	Z	La Barre-de-Semilly	5003200	50032	50	28	8
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	01010000206A080000710A5C22766F1541666666465C755A41	500330000	Z	Baubigny	5003300	50033	50	28	6
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	01010000206A08000096CF45C08E901841CCCCCC8C724D5A41	500340000	Z	Baudre	5003400	50034	50	28	4
01060000206A080000010000000103000000010000001A0100009A9999994F4617410000008012675A41666666666C4617419A99991912675A41CDCCCCCC904617413333337310675A4100000000A0471741666666E606675A41333333333B4817419A9999B901675A413333333383481741333333D300675A4133333333CB491741CDCCCCCCFD665A41CDCCCCCC464A174133333373FC665A41CDCCCCCC4C4A1741CDCCCCECFC665A4100000000504A1741666666A6FD665A4100000000304A1741CDCCCCCC05675A4133333333014A17416666664610675A4100000000EE4917419A9999D919675A4100000000E8491741CDCCCC8C1F675A41CDCCCCCC524A1741CDCCCC0C1F675A4100000000A44A1741CDCCCCEC1D675A41CDCCCCCCC24A1741333333F31D675A4133333333154B17419A9999D91E675A41666666660A4C17410000006022675A4133333333134C1741CDCCCCCC21675A419A999999474C1741000000201C675A419A9999995F4C1741333333D31A675A41666666668C4C1741333333131C675A41CDCCCCCCBA4C1741000000E01D675A419A999999014D1741CDCCCC4C21675A41CDCCCCCC664D17416666668625675A4100000000F04D1741666666662A675A4100000000364E1741CDCCCC8C2D675A41000000004C4E1741666666C62E675A4166666666604E1741CDCCCC2C30675A4100000000744E1741333333F332675A419A999999714E17413333335333675A41666666667A4E1741CDCCCC2C34675A4133333333A14E17410000004036675A4100000000AE4E17410000004037675A4133333333A94E1741CDCCCC6C37675A41CDCCCCCCAC4E1741CDCCCC6C38675A41CDCCCCCCE64E1741000000203D675A41666666660C5017419A99999952675A41333333334B5017419A9999D956675A419A9999995F5117416666660666675A41CDCCCCCC725117416666666667675A4166666666AC5117419A9999796A675A41CDCCCCCC725217419A9999F972675A413333333399521741333333F374675A413333333329531741333333537B675A41666666665C531741000000E07D675A413333333375531741333333D37F675A41CDCCCCCC9E5317419A9999F983675A4166666666BC531741000000C085675A419A999999E7531741CDCCCC0C85675A41333333333F5417419A9999B982675A416666666680541741000000A081675A413333333399541741CDCCCC4C83675A4133333333C15417419A9999B986675A4133333333F3541741000000608A675A41666666666C5517410000002090675A4100000000EA5517410000008095675A4133333333355617413333333398675A419A999999F9561741CDCCCC2C9E675A4166666666E4571741CDCCCC6CA4675A41CDCCCCCC58581741CDCCCC6CA8675A41000000006458174100000040A8675A41666666667258174166666666A8675A41666666667858174100000040A7675A41CDCCCCCCF85817419A9999D99D675A41000000006C591741000000C096675A419A999999795917410000004096675A4100000000CC5917410000000096675A419A999999FF591741CDCCCC6C95675A41666666666A5A17416666662693675A419A9999997F5A17413333339392675A4100000000FA5A1741CDCCCC6C8C675A4166666666745C1741333333D395675A4166666666465C174166666686A1675A419A999999DF5C17419A999939A4675A4166666666385D17419A999979A6675A4133333333FF5D174166666666AD675A4166666666F05E1741000000E09C675A419A9999993B5F1741000000C098675A419A999999B75F1741666666A692675A416666666602601741CDCCCCEC8D675A4100000000F4601741666666467C675A41CDCCCCCC2C6117410000004069675A4166666666EE611741CDCCCCCC6A675A41333333330D621741000000E06A675A4133333333496217419A9999995F675A413333333369621741CDCCCCCC58675A41333333339B6217410000000056675A4100000000D4621741CDCCCC0C54675A41CDCCCCCCE46217413333333342675A4166666666F26217416666660639675A4166666666F86217419A99991931675A4100000000F4621741000000402A675A41CDCCCCCCD8621741CDCCCC4C21675A4166666666206317419A99991921675A419A999999116417416666666623675A4133333333116417413333335316675A4100000000146417419A99991912675A41CDCCCCCC1A641741CDCCCC0C0F675A41000000002A641741333333D30C675A419A999999476417410000006009675A41666666666A641741CDCCCC0C06675A4100000000906417413333333303675A413333333395641741000000E002675A416666666606651741CDCCCCCCFF665A41000000003C651741000000A0FB665A413333333353651741CDCCCC4CF9665A41CDCCCCCC7265174100000040F7665A410000000082651741666666C6F6665A4133333333FB65174133333393FF665A41000000004E6617419A9999F903675A4100000000946617419A9999B906675A41CDCCCCCCA0671741CDCCCC8CE4665A41000000008E67174166666606E4665A41666666662A681741666666E6D1665A4100000000726817419A9999D9C8665A419A999999CF6817419A9999D9BA665A4133333333236A174100000000BD665A4166666666206A174166666686BC665A419A9999997B6A1741CDCCCC2CB3665A4100000000766A174100000040B2665A4133333333796A1741666666C6B0665A4133333333956A17419A999959AD665A4100000000046A174100000040AC665A413333333365691741CDCCCC8CAA665A41CDCCCCCC2069174166666606AA665A41000000002069174100000020A8665A419A99999929691741666666C69E665A419A9999993B691741333333D396665A419A9999998B6917419A99991980665A419A99999961691741000000C07E665A4166666666406917419A9999397D665A413333333333691741000000607C665A4166666666146917419A99999979665A4133333333F3681741333333B377665A4100000000DC681741666666C676665A4166666666926817413333337374665A4166666666786817416666664673665A4166666666E8671741CDCCCCEC68665A41333333339F671741666666A662665A413333333355671741666666265D665A41666666664C671741CDCCCCAC5C665A410000000042671741333333735C665A4100000000226717419A9999395C665A413333333307671741000000E05C665A4133333333E7661741333333335E665A4133333333A96617419A99991962665A41CDCCCCCC8A6617416666668663665A410000000076661741333333F363665A419A999999656617419A9999F963665A4100000000006617419A9999B960665A4100000000EA6517419A99993960665A4133333333D36517410000002060665A4166666666AE6517419A9999F960665A4100000000466517413333331366665A4133333333296517416666662667665A413333333307651741333333D367665A4166666666F8641741CDCCCC8C67665A4100000000DA6417419A99991966665A4166666666B4641741333333D35F665A419A99999997641741333333535C665A41666666667C641741CDCCCC0C5A665A41666666664A641741333333B356665A419A9999991F6417413333339354665A4100000000F46317419A9999F952665A4166666666B86317419A99997951665A419A99999941631741333333534F665A41000000000C631741000000A04D665A4166666666FE6217419A9999994C665A4100000000DE6217419A99997948665A4100000000CA6217410000004043665A419A999999CF6217416666662640665A41CDCCCCCCA4621741000000803D665A410000000082621741666666863D665A41000000005E6217419A9999193E665A4100000000806117413333333344665A41CDCCCCCC026117419A9999B946665A4100000000A65F1741666666C64C665A419A9999991D5F1741333333B34E665A41CDCCCCCCE65E1741CDCCCC6C37665A4166666666AC5717416666660644665A410000000032571741333333F348665A41CDCCCCCC3E5517419A99991947665A419A9999992F551741CDCCCCCC46665A41666666660C551741333333F345665A4133333333E35417410000008044665A41333333336F541741333333933F665A4133333333B35317410000006036665A419A9999996F5317419A99991934665A419A999999E35217410000000030665A41333333337F521741666666862C665A41CDCCCCCCA4511741666666862D665A41333333330D511741CDCCCC4C2D665A41CDCCCCCCA0501741333333332F665A4166666666F44F1741CDCCCC4C31665A419A999999A54F17413333331334665A4133333333934F17416666662634665A4133333333034F17419A99991933665A41000000006C4E1741666666C62E665A4133333333334E1741000000402D665A419A999999154E1741CDCCCCAC2C665A4166666666EE4D1741666666862C665A41666666662C4D17419A9999F92C665A41333333330B4D1741000000802C665A4100000000EE4C1741333333732B665A4100000000D64C1741CDCCCC2C2B665A4166666666C24C1741333333B32B665A41CDCCCCCCB24C1741666666C62C665A41CDCCCCCCA24C1741666666862D665A41CDCCCCCC8E4C17419A9999F92D665A4133333333634C1741333333732E665A41CDCCCCCC124C1741333333F330665A41CDCCCCCC4A4B17413333333336665A4133333333FD4A1741CDCCCCEC38665A41CDCCCCCC924A17419A9999B93D665A419A9999994F4A1741CDCCCC2C41665A419A999999034A17416666660646665A41CDCCCCCC9E491741333333534F665A416666666692491741333333D350665A41333333336F4917413333339352665A41333333335D4917416666662653665A419A999999394917416666664658665A41CDCCCCCC22491741000000005A665A41CDCCCCCC10491741666666065B665A4166666666D2481741CDCCCCAC5D665A4100000000BC4817419A9999B960665A419A999999AB481741CDCCCC6C62665A4166666666A04817410000000065665A413333333395481741CDCCCC0C66665A419A999999A5471741000000E077665A41333333334F4717419A9999B97E665A41666666662A4717410000006082665A41000000000A471741CDCCCC8C86665A41CDCCCCCCF6461741CDCCCC6C88665A41CDCCCCCCD24617419A9999598A665A41CDCCCCCCB8461741000000808C665A4166666666A24617410000004090665A41333333339F4617419A99995991665A4133333333B5461741000000A092665A4100000000C04617419A9999D993665A4133333333F34617416666660697665A419A999999134717413333337399665A41CDCCCCCC60471741333333B3A0665A4166666666B2471741CDCCCC0CA7665A4166666666D84717419A999959AA665A41333333330748174166666646AF665A413333333323481741CDCCCC4CB5665A419A99999939481741CDCCCC0CB8665A41000000006448174133333353BC665A419A9999997148174133333373BE665A41333333337F481741CDCCCC4CC1665A41CDCCCCCC84481741CDCCCCCCC4665A41CDCCCCCC80481741000000C0C6665A410000000072481741333333F3C8665A419A99999929481741333333B3CE665A41CDCCCCCC1E481741CDCCCCCCCF665A41CDCCCCCC0A48174133333353D2665A41CDCCCCCCF847174166666686D5665A4166666666EE47174133333333D8665A4166666666EA471741CDCCCC6CDA665A41CDCCCCCCF04717419A999939DD665A4100000000FA47174166666666DF665A41CDCCCCCCFA47174133333353E1665A419A999999E947174133333353E6665A4100000000EA47174166666606EA665A4133333333DF4717419A999939ED665A41CDCCCCCCB8471741CDCCCC0CF4665A419A999999A14717419A999939F6665A4133333333934717419A999939F8665A410000000076471741CDCCCCCCFD665A419A999999634717419A9999F9FE665A4166666666184717416666662601675A4133333333E9461741CDCCCC8C03675A4166666666BC4617419A99995906675A41CDCCCCCC8A461741666666E607675A41CDCCCCCC6A4617419A9999390A675A41666666665E461741000000200E675A41000000005C461741CDCCCC2C10675A410000000050461741000000E010675A4133333333554617419A9999D911675A419A9999994F4617410000008012675A41	01060000206A08000001000000010300000001000000700000009A9999994F4617410000008012675A41333333333B4817419A9999B901675A41CDCCCCCC464A174133333373FC665A4100000000504A1741666666A6FD665A4133333333014A17416666664610675A4100000000E8491741CDCCCC8C1F675A4100000000A44A1741CDCCCCEC1D675A41666666660A4C17410000006022675A419A9999995F4C1741333333D31A675A4100000000F04D1741666666662A675A4166666666604E1741CDCCCC2C30675A41666666667A4E1741CDCCCC2C34675A41CDCCCCCCE64E1741000000203D675A41333333334B5017419A9999D956675A4166666666AC5117419A9999796A675A41666666665C531741000000E07D675A4166666666BC531741000000C085675A416666666680541741000000A081675A4133333333F3541741000000608A675A4133333333355617413333333398675A4166666666E4571741CDCCCC6CA4675A41CDCCCCCC58581741CDCCCC6CA8675A419A999999795917410000004096675A419A999999FF591741CDCCCC6C95675A419A9999997F5A17413333339392675A4100000000FA5A1741CDCCCC6C8C675A4166666666745C1741333333D395675A4166666666465C174166666686A1675A4166666666385D17419A999979A6675A4133333333FF5D174166666666AD675A4166666666F05E1741000000E09C675A416666666602601741CDCCCCEC8D675A4100000000F4601741666666467C675A41CDCCCCCC2C6117410000004069675A41333333330D621741000000E06A675A413333333369621741CDCCCCCC58675A4100000000D4621741CDCCCC0C54675A4166666666F86217419A99991931675A41CDCCCCCCD8621741CDCCCC4C21675A4166666666206317419A99991921675A419A999999116417416666666623675A41CDCCCCCC1A641741CDCCCC0C0F675A413333333395641741000000E002675A416666666606651741CDCCCCCCFF665A410000000082651741666666C6F6665A4133333333FB65174133333393FF665A4100000000946617419A9999B906675A41CDCCCCCCA0671741CDCCCC8CE4665A41000000008E67174166666606E4665A4100000000726817419A9999D9C8665A419A999999CF6817419A9999D9BA665A4133333333236A174100000000BD665A419A9999997B6A1741CDCCCC2CB3665A4133333333956A17419A999959AD665A41CDCCCCCC2069174166666606AA665A419A9999993B691741333333D396665A419A9999998B6917419A99991980665A4100000000DC681741666666C676665A4166666666786817416666664673665A413333333355671741666666265D665A4100000000226717419A9999395C665A41CDCCCCCC8A6617416666668663665A4100000000006617419A9999B960665A4166666666AE6517419A9999F960665A413333333307651741333333D367665A4100000000DA6417419A99991966665A419A99999997641741333333535C665A4100000000F46317419A9999F952665A41000000000C631741000000A04D665A4100000000DE6217419A99997948665A419A999999CF6217416666662640665A41CDCCCCCCA4621741000000803D665A41000000005E6217419A9999193E665A4100000000806117413333333344665A4100000000A65F1741666666C64C665A419A9999991D5F1741333333B34E665A41CDCCCCCCE65E1741CDCCCC6C37665A4166666666AC5717416666660644665A410000000032571741333333F348665A41CDCCCCCC3E5517419A99991947665A4133333333E35417410000008044665A4133333333B35317410000006036665A41333333337F521741666666862C665A41CDCCCCCCA4511741666666862D665A41333333330D511741CDCCCC4C2D665A4166666666F44F1741CDCCCC4C31665A419A999999A54F17413333331334665A4133333333034F17419A99991933665A419A999999154E1741CDCCCCAC2C665A41666666662C4D17419A9999F92C665A4100000000D64C1741CDCCCC2C2B665A41CDCCCCCC4A4B17413333333336665A419A9999994F4A1741CDCCCC2C41665A419A999999034A17416666660646665A419A999999394917416666664658665A4166666666D2481741CDCCCCAC5D665A413333333395481741CDCCCC0C66665A41333333334F4717419A9999B97E665A41333333339F4617419A99995991665A419A999999134717413333337399665A4166666666D84717419A999959AA665A41000000006448174133333353BC665A41CDCCCCCC84481741CDCCCCCCC4665A419A99999929481741333333B3CE665A4166666666EA471741CDCCCC6CDA665A41CDCCCCCCFA47174133333353E1665A4133333333DF4717419A999939ED665A410000000076471741CDCCCCCCFD665A4166666666184717416666662601675A41CDCCCCCC6A4617419A9999390A675A419A9999994F4617410000008012675A419A9999994F4617410000008012675A41	01010000206A08000002824BE0A6571741000000A0EB665A41	500360000	Z	Baupte	5003600	50036	50	28	2
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	01010000206A0800008E593541422B17413333334376335A41	500380000	Z	Beauchamps	5003800	50038	50	28	4
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	01010000206A08000074403766703A18416666669626405A41	500390000	Z	Beaucoudray	5003900	50039	50	28	5
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	01010000206A080000D06D280565F21841CCCCCCDCA6275A41	500400000	Z	Beauficel	5004000	50040	50	28	9
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