SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep52;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep52 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep52','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep52','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep52','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep52"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800000840CF97C1AA2A41666666466FDE5941	520010000	Z	Ageville	5200100	52001	52	44	20
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	01010000206A080000C8A3AF36B18E2B4100000080F3D45941	520020000	Z	Aigremont	5200200	52002	52	44	5
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	01010000206A08000025236AB49CF92A419A9999891BF75941	520030000	Z	Aillianville	5200300	52003	52	44	24
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	01010000206A08000025670FBA94812A419A9999D9F8035A41	520040000	Z	Aingoulaincourt	5200400	52004	52	44	5
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	01010000206A0800006A8EDD2682AB2941343333A3C2DD5941	520050000	Z	Aizanville	5200500	52005	52	44	4
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	01010000206A080000411D0EB7619D2941CDCCCCCCD40E5A41	520060000	Z	Allichamps	5200600	52006	52	44	3
01060000206A080000010000000103000000010000001C010000CDCCCCCC2CD829419A9999599FF55941666666662DD829419A999919A8F559410000000089D829419A999979BEF55941CDCCCCCCD9D82941666666E6CAF5594166666666FBD829419A999999E2F5594133333333CED829419A9999D929F6594100000000D9D82941333333D333F6594166666666D9D829410000004039F65941CDCCCCCC70D92941CDCCCC4C38F659413333333300DA2941CDCCCCEC38F659413333333377DA2941666666263BF6594100000000EEDA2941333333933CF659410000000071DB2941CDCCCC6C3CF65941CDCCCCCCB5DB29419A9999593CF6594166666666B0DD2941000000C046F65941666666660EDE2941666666C649F65941666666668BDE2941666666C64CF6594166666666E8DE29416666666653F659410000000027DF29410000002056F65941333333336BDF29410000008059F65941CDCCCCCCA5DF2941333333D35CF6594100000000C6DF2941000000205FF6594133333333E4DF2941333333D360F65941CDCCCCCC11E029416666668662F659413333333331E02941CDCCCC0C64F65941CDCCCCCC32E02941CDCCCC2C64F65941666666667CE02941CDCCCCAC51F6594133333333DFE02941CDCCCC6C40F659416666666647E129416666668633F65941CDCCCCCCEFE129419A9999D91CF659416666666659E22941CDCCCC2C18F65941333333338BE229419A99993914F65941CDCCCCCCA9E32941CDCCCC8C0AF659410000000014E42941333333730AF6594133333333CFE42941CDCCCCAC08F6594166666666EFE52941CDCCCC2C06F65941CDCCCCCC07E729419A999919FCF559419A99999946E7294166666666F9F559419A99999913E8294133333373F2F559413333333377E829419A999999EFF559419A999999B5E8294166666606ECF55941333333333BE929419A9999F9E0F5594100000000AEE9294166666606D9F559419A9999999EEA294166666606C9F559413333333348EB294133333313BCF559413333333335EB2941000000C0B9F55941CDCCCCCC2BEB2941CDCCCCACB4F559413333333354EB2941CDCCCC4CB2F55941CDCCCCCC82EB2941000000E0B1F55941CDCCCCCCCDEB2941000000A0B0F559416666666612EC2941CDCCCC6CADF559413333333395EC294100000060A9F5594166666666BAEC2941CDCCCC6CA5F55941CDCCCCCC7AED2941CDCCCC0C94F559419A999999D4ED2941333333938AF55941CDCCCCCC1BEE29416666660685F55941000000009BEE2941666666C678F55941CDCCCCCCE8EE29413333337372F55941CDCCCCCC29EF29419A9999596BF559410000000059EF2941CDCCCC0C66F559419A999999C1EF2941000000A059F5594133333333F0EF29419A9999B953F559416666666618F029419A9999994EF559419A99999940F029419A99997949F559413333333372F029419A9999F943F55941CDCCCCCCEDF029419A99997931F559419A9999998BF12941000000401CF5594133333333C3F129419A99995914F559419A99999914F22941CDCCCC8C08F55941000000002CF229419A9999D90CF55941333333335EF22941CDCCCC6C13F559413333333352F229410000008008F559416666666618F229419A999919F3F4594100000000A4F229419A999919E4F4594133333333F7F22941000000C0D6F4594133333333F0F2294166666666D1F459419A999999CDF22941666666E6C7F45941666666667EF22941CDCCCC6CB6F4594166666666B9F22941CDCCCCACB1F45941CDCCCCCC51F32941CDCCCC0CACF45941000000009DF32941666666E6A7F45941CDCCCCCC44F42941CDCCCC6CA2F459419A9999994AF529410000000098F459416666666624F62941CDCCCC2C8FF4594166666666FBF629419A99995986F45941CDCCCCCC5BF72941CDCCCC2C81F459413333333367F829419A9999B979F45941333333330CF929413333331374F4594133333333B1F92941000000E06CF459413333333353FA29416666664665F459419A99999920FB2941CDCCCC4C5BF459419A9999990EFB2941666666C656F45941CDCCCCCC34FB2941000000003FF459413333333373FB29419A9999593EF4594133333333AEFB2941CDCCCC0C38F45941CDCCCCCC30FC2941CDCCCCCC32F45941CDCCCCCC51FC2941333333131EF459419A9999997BFC2941CDCCCCAC11F459419A999999F9FC2941CDCCCC4CF7F359419A99999944FD29419A999999E5F3594166666666A0FD294100000040D6F35941333333336FFD2941CDCCCCCCD4F35941CDCCCCCC33FD2941CDCCCCACD3F359419A999999FBFC2941CDCCCC2CD2F35941CDCCCCCC92FC2941333333F3CCF359419A999999E1FC294100000060BBF359413333333309FD294133333313B5F359419A9999991CFD2941CDCCCC8CADF359413333333316FC2941000000A089F3594133333333BBFB29419A99993978F359419A99999988FB2941666666C670F359419A99999988FB2941666666466EF3594133333333F9FA2941333333735AF35941CDCCCCCCBBFA29416666660644F359419A999999B0FA2941CDCCCCCC33F35941CDCCCCCCD6FA29416666664618F359419A99999907FB29410000004009F359419A9999991AFB29419A9999F9F8F2594166666666FBFA294166666686E7F259410000000082FA2941CDCCCCACD3F259419A999999ABF92941CDCCCC6CAEF25941000000006FF9294100000080A4F2594133333333C3F82941333333F387F25941CDCCCCCC8EF829410000000083F259419A9999998BF82941CDCCCC6C82F259419A99999972F82941CDCCCC0C7EF259416666666668F82941CDCCCC4C7AF25941CDCCCCCC7DF829416666664674F259419A9999993AF82941666666C66DF2594100000000D0F729419A99991966F25941333333334CF729419A9999795CF2594100000000EBF629416666662655F259419A999999A2F62941666666C64FF259410000000051F629413333337348F25941CDCCCCCCF2F52941CDCCCCEC41F2594166666666A7F529419A9999F93AF25941666666664CF52941666666A633F25941CDCCCCCCCEF42941CDCCCCCC2AF25941666666666AF429419A99991923F25941666666660FF42941000000601BF2594133333333F9F329419A9999B916F2594133333333FFF329419A99991910F259419A999999E2F32941000000A00CF25941CDCCCCCC9DF329419A9999F909F25941666666665FF32941000000C007F25941333333332DF329419A99999906F259413333333332F3294166666666F5F15941666666662BF3294133333353ECF1594166666666E0F229419A999959EBF159416666666663F22941333333F3E7F1594166666666D3F129419A999999E4F15941CDCCCCCC46F1294133333393E3F1594133333333BFF0294100000040E3F159419A99999991F0294100000060E3F15941CDCCCCCC49F0294166666606E5F15941CDCCCCCCF8EF2941CDCCCC0CE7F15941CDCCCCCCA7EF2941CDCCCCCCE9F159413333333382EF2941000000C0E8F159413333333359EF29419A9999F9E0F159419A9999993CEF2941333333D3D8F159419A9999991DEF294133333353D3F1594100000000F1EE2941000000C0D4F1594100000000A2EE294100000000D6F159413333333342EE2941333333F3D5F1594166666666A9ED29419A999919D5F15941CDCCCCCC6AED29419A999919D4F159419A99999902ED294100000080D1F15941CDCCCCCC6DEC29419A9999B9CDF159416666666651EC2941CDCCCC6CCCF15941CDCCCCCC3CEC294133333373CAF1594166666666C9EB294133333373CDF159419A9999995CEB2941000000E0CFF159419A9999990DEB2941CDCCCC2CD1F15941CDCCCCCCC4EA2941000000C0D1F159410000000071EA2941000000A0D1F15941CDCCCCCC1EEA2941CDCCCC4CD1F1594100000000B4E92941666666C6D0F159419A9999992BE9294166666686D0F15941CDCCCCCC4FE8294133333353D1F1594166666666D7E72941000000E0D1F15941333333335BE72941333333D3D2F159419A999999CAE62941666666C6D4F159410000000086E6294166666666D5F159419A99999909E62941CDCCCC4CD5F15941333333334CE5294133333373D4F15941333333332DE429419A999959D3F15941CDCCCCCCDFE32941CDCCCC6CD3F15941CDCCCCCCD0E32941CDCCCC0CDAF159413333333393E3294166666646E6F159419A99999952E3294133333373F2F159416666666617E329419A9999B9FCF15941CDCCCCCCC4E22941CDCCCCCC0AF259419A999999A2E22941666666860FF2594133333333A9E229410000006015F2594100000000B0E22941CDCCCC2C1DF259416666666649E22941CDCCCCCC20F2594100000000F8E129410000008021F259410000000079E12941CDCCCC2C32F259419A99999963E12941666666A637F25941666666663BE12941CDCCCC2C3DF259419A99999919E129416666660645F259419A99999907E12941333333934FF25941333333330EE129419A9999B95DF25941CDCCCCCC2CE12941CDCCCC6C66F25941666666662DE12941CDCCCCEC6DF2594166666666DFE029410000008089F259419A999999BEE029419A9999999AF259410000000094E0294166666626AEF259419A99999963E02941000000E0C2F25941666666663AE0294100000020D2F25941CDCCCCCC13E02941666666E6E4F259419A999999FCDF294166666646F0F2594133333333E3DF294133333333FAF2594166666666BEDF29419A9999790AF35941CDCCCCCC96DF2941000000800FF35941CDCCCCCC0BDF2941666666661DF35941000000009CDE29419A99991926F35941333333333BDE29419A9999192FF35941CDCCCCCC87DD2941666666063FF359419A999999B7DC29419A9999D94EF3594100000000F7DB29419A9999D95FF359419A9999996EDB2941333333136CF3594133333333EFDA29410000002077F35941CDCCCCCC88DA2941CDCCCCCC81F359413333333341DA2941333333B387F359416666666609DA2941333333138CF35941CDCCCCCCC1D929419A9999198EF35941000000008DD929410000000094F359413333333371D929419A9999B998F359419A99999936D9294133333333A0F359419A999999FED82941CDCCCCACA7F3594166666666F5D82941333333F3B7F359416666666606D92941666666C6C1F359416666666613D9294166666626CBF35941000000002DD92941333333B3D3F359410000000034D9294166666686DBF359410000000041D9294133333313E4F359410000000037D929419A999959ECF35941333333332FD92941CDCCCCECF2F359410000000036D9294133333393F9F359416666666659D929413333333307F459413333333376D929416666660614F459416666666696D929419A9999D922F4594166666666C3D92941333333F333F459419A999999E6D92941666666A63FF459416666666606DA29419A9999F948F45941CDCCCCCC1FDA29416666662651F459410000000043DA2941666666A65BF45941CDCCCCCC6FDA29419A9999996BF459419A9999999CDA2941333333137DF459419A999999B9DA2941333333738DF45941CDCCCCCCC3DA29410000000098F4594166666666CEDA2941CDCCCCECA9F45941CDCCCCCCCCDA294166666646BCF4594133333333BEDA2941CDCCCCCCCFF4594166666666ACDA2941CDCCCCECDBF459413333333394DA294166666646E7F459419A9999998BDA2941000000A0F2F459419A9999997FDA2941CDCCCC6CFAF45941CDCCCCCCAEDA29419A999919FDF45941CDCCCCCCA0DA2941CDCCCC2C02F55941333333339BDA29416666668602F55941CDCCCCCC81DA2941CDCCCC4C04F559410000000070DA29419A9999D905F55941000000005FDA29419A9999B907F559416666666651DA29413333337309F55941CDCCCCCC42DA2941CDCCCCEC0BF55941666666662CDA29419A99995910F559410000000017DA2941CDCCCCEC14F55941CDCCCCCC07DA29419A9999B917F5594133333333F7D92941666666661AF55941CDCCCCCCDED92941666666261DF5594100000000C5D92941000000E01FF5594100000000A3D92941CDCCCCAC22F55941666666667FD929416666666625F559419A99999947D92941000000A028F55941CDCCCCCC3FD92941333333B336F559410000000003D92941CDCCCC6C4BF559413333333317D929419A99997962F55941CDCCCCCC11D929413333335371F5594166666666DAD82941666666867BF55941CDCCCCCC89D82941666666C685F559410000000072D829416666660694F55941CDCCCCCC2CD829419A9999599FF55941	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	01010000206A080000A5BE3DEDF1EA2941CCCCCC0C19F45941	520070000	Z	Ambonville	5200700	52007	52	44	14
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	01060000206A080000010000000103000000010000000102000033333333B5562A419A99993958EC594133333333D8562A41666666A65DEC5941666666661D572A419A99999964EC59410000000069572A41333333B36EEC594166666666B4572A41000000A075EC5941CDCCCCCC12582A41CDCCCCCC82EC59413333333384582A41CDCCCC2C8FEC594100000000A4582A419A9999B997EC59419A999999D6582A41CDCCCC0CA1EC594133333333DD582A41CDCCCC0CA8EC594100000000D2582A41CDCCCCACB7EC5941CDCCCCCCE4582A419A999939B9EC594100000000AD592A4166666626BCEC5941CDCCCCCC6E5A2A4100000060C1EC59419A999999D25A2A4166666646C1EC594100000000565B2A41333333B3C2EC5941000000009B5B2A4166666686C6EC594133333333E05B2A4166666646CEEC59419A999999705C2A41333333D3D9EC594166666666E75C2A4133333353E4EC59419A999999305D2A4100000000EEEC5941666666669D5D2A41000000E0FFEC59419A999999CB5D2A416666664614ED59419A9999991F5E2A416666660635ED5941666666664B5E2A413333331340ED5941000000008B5E2A41000000C047ED594100000000A95E2A41666666A649ED594100000000365F2A41CDCCCC4C4BED594166666666D35F2A410000004045ED59419A9999999C602A419A99995942ED59410000000062612A41333333D341ED594166666666ED612A41000000403FED59410000000037632A41CDCCCC6C3AED59416666666603642A41CDCCCC8C36ED59416666666640642A410000006034ED5941CDCCCCCCD1642A41CDCCCC0C2BED5941666666663F652A419A99995929ED5941000000008C652A41000000202AED59419A99999921662A419A9999F92DED5941CDCCCCCCF7662A416666662630ED59413333333366672A41333333D32EED594166666666F6672A419A9999D929ED59419A9999992D682A419A99997925ED5941333333338D682A410000006018ED5941CDCCCCCCB1682A410000000015ED594166666666E4682A41CDCCCC4C13ED59413333333377692A41333333D310ED59419A999999EA692A41000000C00FED594133333333386A2A41000000200EED59419A9999995E6A2A41333333D30EED5941CDCCCCCC906B2A419A9999191BED59419A999999556C2A41666666C62CED5941CDCCCCCC726C2A41CDCCCC4C32ED594166666666C16C2A41CDCCCCEC38ED5941CDCCCCCC6D6D2A41333333D34DED5941CDCCCCCC0F6E2A41000000E06CED59419A999999756E2A410000004088ED59419A999999E46E2A41666666C6B4ED594133333333EB6E2A4166666606BBED594100000000D36E2A4166666686C7ED594100000000AE6E2A4100000060CFED5941000000009C6E2A4133333333D7ED5941333333339D6E2A4100000060E8ED59419A999999B06E2A4133333313F4ED59419A9999997E6F2A41CDCCCC4CF2ED5941CDCCCCCCBC6F2A41CDCCCC4CEEED59413333333333702A4166666646EAED59410000000065702A419A999919E7ED59410000000001712A41333333F3E6ED5941333333339D712A41CDCCCC8CE7ED594100000000CF712A4100000060E4ED59413333333319722A419A9999B9DBED5941CDCCCCCC95722A4100000020D6ED59419A999999F9722A4133333373D4ED594100000000A0732A4100000060D0ED5941CDCCCCCC50742A41000000A0CEED59419A99999982742A4100000000CDED5941CDCCCCCCCD742A41CDCCCC0CD0ED59413333333336752A419A9999F9D0ED59419A99999965762A41CDCCCC2CD5ED594133333333F9762A4133333313D6ED5941CDCCCCCCE4782A41333333D3D9ED59419A9999992C792A4166666646DCED594100000000FC792A4100000020DEED5941333333335F7A2A41CDCCCC6CE0ED594133333333E77A2A41333333F3E1ED594166666666A47C2A419A999939E9ED5941CDCCCCCC0D7D2A41CDCCCCACE8ED5941333333338F7D2A41CDCCCC4CE2ED594166666666007F2A4166666626DAED5941CDCCCCCCA27F2A4166666686CFED5941666666662C802A419A999959C9ED59419A9999997D802A419A9999B9C3ED59413333333369812A4100000060AEED59410000000020822A41CDCCCC0CDDED59419A99999999822A41666666A6F4ED594100000000EB822A41CDCCCCCC09EE59413333333396862A410000000042EE5941CDCCCCCC3B882A41CDCCCC0C5DEE5941CDCCCCCCE4882A41333333D38AEE59416666666653892A413333337393EE5941CDCCCCCCED892A4166666686B7EE5941CDCCCCCCAB8A2A41CDCCCC0CBBEE594133333333CB8A2A4100000000CFEE594133333333DF8A2A4100000040D0EE594133333333CF8B2A419A999979D2EE5941CDCCCCCC0B8C2A41666666E6D9EE594133333333BA8C2A410000000000EF594100000000F38C2A413333333302EF5941000000002B8D2A410000000007EF5941000000006A8D2A41666666860AEF594100000000A08D2A41000000C013EF59419A999999B48E2A419A9999D93BEF59419A999999318F2A41666666263EEF5941333333334A8F2A41333333F339EF594133333333398F2A41666666262AEF5941CDCCCCCC198F2A41000000E01EEF59419A999999258F2A419A9999391AEF59419A999999458F2A413333331319EF594133333333C78F2A41CDCCCCCC19EF59413333333309902A410000004019EF5941333333332A902A41666666A61FEF59413333333350902A41666666A620EF5941CDCCCCCC77902A41666666461CEF5941333333336B902A416666664618EF59413333333339902A41CDCCCC6C18EF5941CDCCCCCC2A902A41000000E014EF59419A99999963902A413333339310EF5941CDCCCCCC83902A410000004004EF59419A999999B1902A41333333B304EF594100000000E0902A41000000A001EF5941CDCCCCCC54912A41666666060AEF59416666666675912A41CDCCCCAC09EF594100000000A4912A41666666C602EF594133333333FC912A41333333D3FDEE59413333333344922A41CDCCCCECFEEE59419A99999950922A4133333333F6EE5941666666667D922A4133333393F3EE594133333333AC922A4133333313F5EE594133333333F9922A419A9999F9E8EE5941000000005B932A4100000020DEEE594166666666FF952A4100000020DFEE59413333333307962A4100000060E9EE59419A9999994E982A4166666686E8EE59419A99999939982A41666666A6D7EE59419A99999999972A4100000080D8EE59413333333339972A419A9999D9D2EE59416666666634972A419A9999D9C5EE5941666666665B972A4133333393B5EE5941333333335B972A4133333313B3EE5941CDCCCCCC30972A4133333393B5EE59413333333333972A4166666666ABEE594166666666B9972A419A999919AAEE5941000000002B982A419A9999798DEE59419A999999B0972A413333331383EE594100000000A7972A41CDCCCC8C7FEE59419A999999E3982A413333333365EE594133333333ED982A413333337361EE5941CDCCCCCCF3982A419A9999792FEE59419A9999992E992A41CDCCCCAC1CEE59416666666691992A41333333930DEE594166666666449A2A41666666A6FFED594133333333359A2A4133333373D1ED594133333333CA9A2A41CDCCCCCCC5ED59419A999999139A2A41666666069DED594100000000F09B2A41666666C66CED59419A999999219C2A419A99997966ED5941333333330D9C2A410000008061ED594100000000D99B2A41333333D35DED59419A999999449C2A419A9999F93BED5941666666663A9C2A410000008039ED594100000000A49B2A416666662632ED594133333333F19B2A419A9999D908ED594100000000559C2A410000008007ED59419A999999BF9C2A41666666E6D7EC594166666666C99C2A4166666666D5EC5941CDCCCCCC919D2A41CDCCCC6CDBEC5941CDCCCCCCB99D2A41666666E6DDEC5941CDCCCCCCCD9D2A41000000A0DCEC5941CDCCCCCC2D9E2A4166666606C1EC5941CDCCCCCC559E2A4100000000C1EC594133333333169F2A4166666606C8EC594100000000349F2A41000000C0C6EC594166666666B19F2A4166666626A1EC5941666666665CA02A41000000005CEC59419A999999D4A02A41000000605EEC5941000000009DA12A41666666E666EC594166666666CFA12A419A9999596EEC594133333333DAA12A413333339379EC59413333333343A32A41CDCCCC6C89EC59410000000075A32A410000006089EC594166666666FDA32A41000000C054EC5941CDCCCCCC38A42A41333333334DEC5941CDCCCCCC88A42A41000000604EEC594166666666B1A42A41333333D355EC594133333333C6A42A416666668663EC594166666666C0A62A41666666066AEC59410000000054A82A41666666C63FEC594133333333D1AA2A4100000080FCEB5941CDCCCCCC04AB2A41CDCCCC2CF4EB59413333333313AB2A41CDCCCC4CE7EB59419A99999987AB2A419A999919C3EB594166666666BAAB2A41333333D3B5EB5941666666668AAC2A410000004091EB5941CDCCCCCC88AD2A419A99999962EB594133333333EEAD2A413333339350EB59413333333380AE2A41000000E039EB59413333333307AF2A41666666A623EB5941333333335DAF2A410000008014EB5941CDCCCCCCBEAF2A4100000060FDEA5941CDCCCCCC9AB02A419A9999F9CBEA594100000000F7B02A419A999979BAEA5941CDCCCCCC9BB12A419A9999B9A3EA5941333333331DB22A41CDCCCCEC8DEA594133333333BEB22A41666666C674EA5941CDCCCCCC58B32A413333337355EA594166666666B6B32A413333337343EA59419A99999966B42A419A99995927EA59416666666639B52A413333339301EA594133333333A3B52A41CDCCCC0CF3E959416666666606B62A4100000000E9E959419A9999997CB72A419A9999B9ADE959419A999999CCB82A416666664688E959419A99999938B92A41CDCCCC6C6BE959413333333342B92A41CDCCCC6C66E95941CDCCCCCCBFB82A41CDCCCC4C60E959410000000029B82A419A99997951E95941333333337DB72A41CDCCCCCC44E9594100000000F6B62A41CDCCCCAC42E95941333333339DB62A41CDCCCC4C3FE95941CDCCCCCC31B62A419A9999D93CE959419A99999933B52A41333333F333E95941333333339CB42A419A99993932E95941CDCCCCCCEEB32A41666666C632E95941666666662BB32A41666666862BE959419A999999F7B12A416666668624E959410000000005B22A41333333531EE95941000000008BB12A41CDCCCC6C1AE959419A999999E3B02A41000000802BE95941666666668AB02A419A99999935E95941CDCCCCCC1CB02A41333333B33AE959419A9999999BAF2A41333333D344E959419A9999992EAF2A41333333F353E9594166666666DFAE2A41666666C65CE95941CDCCCCCC5EAE2A41666666E670E959416666666610AE2A419A9999B988E95941333333330AAD2A41333333D3B4E959416666666674AC2A4100000000D1E95941CDCCCCCC48AC2A4133333353D7E959410000000026AC2A4100000060D7E95941CDCCCCCCB2AB2A41666666A6D2E95941000000002EAB2A41666666C6D0E959419A99999984AA2A4166666646CFE959413333333355AA2A4166666606CDE959416666666609A92A4133333393BAE95941666666668CA82A41CDCCCC0CB4E95941666666669AA72A41333333B3A8E959413333333378A72A41666666C6A5E95941CDCCCCCC15A72A419A999999A0E959419A999999E8A62A41000000209DE959410000000087A62A41CDCCCC0C99E95941CDCCCCCC20A62A419A99997991E959419A999999BAA52A41000000608CE959413333333389A32A41CDCCCC2C6FE959419A99999991A22A41000000A062E95941CDCCCCCC35A22A410000002061E9594166666666E2A02A41666666665FE95941CDCCCCCC3BA02A41CDCCCC8C5AE9594100000000DE9E2A41CDCCCCEC5AE9594166666666629D2A41333333D35DE95941333333336E9D2A41CDCCCC0C78E95941CDCCCCCCB59D2A41333333F390E9594133333333F29D2A410000002097E9594166666666249E2A413333339399E95941CDCCCCCC619E2A41CDCCCC2C7FE959419A9999993C9F2A41000000408EE9594100000000839F2A419A9999D990E959419A999999BC9F2A419A9999998EE95941CDCCCCCCDF9F2A41333333338FE95941CDCCCCCC39A02A41000000209CE959419A9999999EA02A4133333393A2E95941CDCCCCCCBDA02A41333333D3A5E95941000000004AA12A41000000A0BAE959419A9999999CA12A41CDCCCCECD2E95941666666669DA12A419A9999F9E0E95941CDCCCCCC7BA12A4133333353ECE959419A999999E1A02A419A99997905EA59419A99999987A02A419A9999B90FEA59416666666608A02A41666666E61AEA59419A999999DF9F2A410000006024EA59419A999999F59F2A416666664630EA59410000000056A02A41333333933FEA59419A999999B3A02A419A99991946EA5941CDCCCCCC23A12A419A9999D946EA59419A999999F5A12A41CDCCCCCC41EA594166666666D6A22A41CDCCCC0C39EA59419A9999991BA32A410000006037EA59419A99999982A32A419A99997937EA594166666666C4A32A41CDCCCC8C35EA59419A99999902A42A419A99995935EA5941CDCCCCCC7EA42A41000000203AEA5941000000000FA52A41333333B33EEA5941CDCCCCCC5DA52A41CDCCCCAC47EA5941CDCCCCCCCCA52A41666666864FEA5941CDCCCCCC23A62A41CDCCCC8C5EEA5941CDCCCCCC7AA62A41666666C674EA59419A99999993A62A419A9999797EEA5941333333338BA62A419A99999988EA5941666666664AA62A41000000C095EA5941666666660CA62A419A999999A4EA594133333333D2A52A419A999959ACEA5941000000007BA52A41666666C6B3EA59410000000049A52A41666666A6B6EA594166666666E2A42A4133333353B9EA59410000000048A42A4100000080BBEA594100000000E0A32A41CDCCCC2CBCEA59413333333362A32A419A999999BEEA5941666666660AA32A419A999939BFEA5941CDCCCCCC73A22A41000000A0C1EA59419A999999FDA12A419A999999C4EA5941CDCCCCCC98A12A41666666E6C8EA5941CDCCCCCC61A12A4100000020CDEA5941CDCCCCCCC2A02A41333333F3DDEA594100000000A5A02A41666666C6E3EA59419A99999981A02A419A999979EFEA5941CDCCCCCC77A02A413333333312EB594100000000D4A02A413333335331EB59419A999999F3A02A416666660649EB594166666666D6A02A41CDCCCC8C55EB59410000000087A02A41000000605EEB59413333333323A02A419A9999795EEB594100000000A19F2A41000000E05AEB594100000000D89E2A419A99999949EB5941000000005F9E2A419A9999F93BEB594133333333189E2A41333333932FEB59419A999999B49D2A41CDCCCC6C33EB5941CDCCCCCCAA9D2A41CDCCCCEC35EB594133333333C99D2A41666666263CEB59419A999999C99D2A416666666642EB5941666666667A9D2A419A9999794CEB594166666666349D2A41CDCCCCCC4DEB594133333333EE9C2A41000000A047EB594133333333B19C2A41333333F339EB5941000000007C9C2A41CDCCCC8C0AEB594100000000689C2A41CDCCCC8C0AEB594166666666059C2A413333337316EB5941CDCCCCCC059C2A41666666C620EB59419A999999F89B2A41333333332CEB5941CDCCCCCCCB9B2A41333333B334EB594133333333589B2A41666666E640EB59419A999999A79A2A419A9999F94FEB5941333333338F9A2A413333331355EB594100000000899A2A419A9999795EEB5941000000001D9B2A416666660697EB594100000000379B2A4100000080A7EB594100000000339B2A41CDCCCCCCB7EB59419A999999389B2A41666666C6C3EB5941CDCCCCCC499B2A419A999939D0EB5941CDCCCCCC449B2A41CDCCCCECDDEB5941CDCCCCCC369B2A4166666606E7EB594133333333FF9A2A41666666C6FDEB594166666666AD9A2A41000000A003EC59416666666677992A413333333300EC59413333333359992A41000000C0FDEB5941CDCCCCCC44992A4166666686F7EB5941333333335F992A4166666646C4EB59419A99999936992A4133333353BAEB59413333333303992A4166666626A5EB59413333333345982A419A9999D9A2EB59419A99999907982A41CDCCCC6C8CEB59413333333306982A41333333F375EB5941CDCCCCCCDC972A410000000062EB5941CDCCCCCC9F972A413333331353EB59413333333345972A41CDCCCCEC47EB59413333333308972A41000000803BEB59419A99999907972A41000000C032EB5941CDCCCCCC1A972A410000004026EB59419A99999922972A41000000C005EB5941666666669F962A41CDCCCC2CF3EA594166666666E9952A4100000060D5EA594100000000D5952A41666666E6CDEA59413333333387962A419A9999F9B5EA59419A99999997962A410000004080EA59419A999999B4962A419A99997972EA594166666666C7962A419A9999F960EA5941333333339F962A41000000405DEA59419A999999B5922A419A9999D93DEA59413333333379922A41CDCCCC6C36EA5941000000005A922A419A9999F924EA5941666666661C922A41CDCCCC8C0EEA5941CDCCCCCCA2912A4133333373F4E95941000000003E912A4133333313E8E9594100000000D9902A41CDCCCCECD7E95941666666662E902A4100000020CEE959419A999999F18F2A41333333F3C2E9594100000000798F2A41333333D3B7E95941000000003C8F2A41666666A6A7E95941CDCCCCCCFD8E2A410000004087E95941CDCCCCCCF28E2A416666664678E9594133333333868F2A41000000E053E95941000000008F8F2A41000000E044E9594166666666A28F2A41000000203CE9594166666666B58F2A419A9999D92BE9594166666666A18F2A41000000E02BE95941CDCCCCCC518F2A419A9999F930E95941333333330C8F2A416666664637E95941CDCCCCCCFF8D2A41CDCCCC8C4BE95941CDCCCCCC288E2A41000000C05BE95941CDCCCCCC158E2A416666664668E959419A999999478D2A41333333339EE9594133333333028D2A4166666606A7E9594133333333778C2A41666666E6B4E95941333333333C8C2A419A999939C0E95941000000003D8C2A41333333B3CCE9594166666666668C2A41666666E6E1E959419A999999718C2A41000000A0F4E9594100000000A18B2A413333335306EA5941333333336F8B2A41666666A607EA594100000000C48A2A4133333353F6E95941333333337E8A2A4166666666F6E9594166666666F0892A4133333353DCE9594166666666D2892A419A999919DBE95941CDCCCCCC9F892A41CDCCCC6CD2E9594166666666B8882A41CDCCCC2CBCE95941000000005E882A4166666606B6E959419A9999998A872A41666666C69FE959410000000012872A41CDCCCCEC95E95941666666667A862A419A9999D97BE959410000000034862A41CDCCCCAC75E9594166666666ED852A41000000806AE95941333333339D852A419A99991968E959419A9999996A852A41666666265EE9594133333333A9842A41666666262BE95941CDCCCCCC80842A41333333F324E959419A9999996D842A419A9999191AE9594133333333F0832A419A9999391FE9594100000000E7832A41000000001DE9594133333333B1832A419A9999F91EE959419A9999997E822A41666666A620E959419A999999C8812A41CDCCCCAC1DE95941666666664E812A41000000001FE9594166666666D7802A416666666623E9594133333333E97F2A41666666462DE95941CDCCCCCC5B7F2A419A99997934E959419A999999227F2A410000002039E9594133333333687E2A41CDCCCCEC4BE95941000000003F7E2A416666664651E9594100000000C27D2A419A99993969E9594100000000907D2A416666660674E9594100000000537D2A419A9999B984E95941000000001E7D2A41666666C68FE959419A999999F17C2A419A9999F996E95941CDCCCCCCBA7B2A41333333D3BFE959419A999999167B2A419A9999D9DBE95941000000000F7B2A4100000040DFE9594133333333857A2A4133333373FAE959419A9999996E7A2A41CDCCCC8C00EA594100000000DE792A41CDCCCC8C35EA5941CDCCCCCCAE792A416666668644EA59416666666621792A41CDCCCC0C60EA59416666666630792A419A99995961EA594166666666B0782A41333333737EEA5941000000006C782A416666660695EA5941333333333C782A41CDCCCC4CB4EA59419A99999996782A4133333373BAEA59413333333384782A4133333333D2EA59413333333353782A4100000000E0EA5941000000003E772A41666666C605EB594133333333D0762A41000000E005EB59419A99999939762A41CDCCCC4CFDEA59419A999999FD752A4100000060FDEA594100000000C2752A41CDCCCC6C02EB59419A99999990752A419A9999390BEB59413333333341752A41CDCCCCCC12EB59419A99999916742A419A99995923EB59419A99999982732A410000004040EB594133333333296F2A41CDCCCC4C27EC594133333333016F2A413333335327EC594166666666EC6E2A41000000E01AEC5941CDCCCCCCCD6E2A416666662612EC594166666666E76D2A416666666608EC594166666666796D2A416666664607EC5941CDCCCCCC266C2A41000000E017EC5941CDCCCCCCAE6B2A410000004019EC594133333333646A2A41000000E00BEC5941000000009C692A419A9999D905EC5941CDCCCCCC5A652A410000008009EC59419A999999E5622A41CDCCCCEC0DEC5941CDCCCCCCC7622A41333333B311EC5941333333333E622A413333331331EC5941CDCCCCCCC7612A41333333F348EC5941666666668D612A41333333B352EC5941CDCCCCCC30612A413333333364EC59419A999999F3602A41666666A674EC59410000000059602A41CDCCCCCC8DEC5941CDCCCCCCDD5F2A4100000020A6EC594166666666A05F2A419A999979B3EC594166666666635F2A41000000E0B0EC5941CDCCCCCC6B5F2A4100000080ACEC5941CDCCCCCC3B5F2A4100000000ABEC59419A999999EF5E2A41666666E699EC594133333333505E2A41CDCCCCAC69EC594100000000175E2A41CDCCCCAC5BEC594133333333C05D2A413333335328EC594133333333A75C2A41000000E015EC59419A9999999D5A2A419A999979F8EB5941666666663E592A41CDCCCCACE1EB59416666666602592A41CDCCCCACE3EB59413333333377582A4166666626EEEB594100000000DC572A4166666666F7EB594166666666BD572A419A999919FBEB594133333333B5562A419A99993958EC594133333333B5562A419A99993958EC5941	01010000206A080000C221B528B9852A41000000F02AEC5941	520080000	Z	Andelot-Blancheville	5200800	52008	52	44	33
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	01010000206A08000096AA0CCB531C2B41000000A01CCB5941	520090000	Z	Andilly-en-Bassigny	5200900	52009	52	44	9
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	01010000206A08000004873604B8182A41666666F6ABE75941	520110000	Z	Annéville-la-Prairie	5201100	52011	52	44	5
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	01010000206A08000058D8EF7EB07D2A416666663655FC5941	520120000	Z	Annonville	5201200	52012	52	44	6
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	01010000206A080000A98D533B426A2B4100000000B1C25941	520130000	Z	Anrosey	5201300	52013	52	44	11
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	01010000206A080000087550C74F612A4166666696B0B95941	520140000	Z	Aprey	5201400	52014	52	44	16
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	01010000206A080000A4AF9E7118522B41666666A625C45941	520150000	Z	Arbigny-sous-Varennes	5201500	52015	52	44	10
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	01010000206A0800001421FBC794F62941666666164AC15941	520160000	Z	Arbot	5201600	52016	52	44	13
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	01010000206A0800002EB9BCBF15F329419A99994956CC5941	520170000	Z	Arc-en-Barrois	5201700	52017	52	44	50
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	01010000206A080000235B1AC6F6B1294166666656B9F75941	520190000	Z	Arnancourt	5201900	52019	52	44	9
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	01010000206A08000038C8E626F4BC294134333353FC0B5A41	520210000	Z	Attancourt	5202100	52021	52	44	12
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	01010000206A080000EA316F285CCC2941333333E37CC85941	520220000	Z	Aubepierre-sur-Aube	5202200	52022	52	44	43
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	01010000206A0800003285A8BA2F302A41666666B6C0BA5941	520230000	Z	Auberive	5202300	52023	52	44	71
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	01010000206A08000096B395F0CE1E2B419A999909C6DF5941	520250000	Z	Audeloncourt	5202500	52025	52	44	12
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	01010000206A0800009B28D9B593532A41333333D3ECB55941	520270000	Z	Aujeurres	5202700	52027	52	44	13
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	01010000206A080000FB4E57D561002A41333333B3B6BF5941	520280000	Z	Aulnoy-sur-Aube	5202800	52028	52	44	9
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	01010000206A0800004263BEC982352A41CDCCCC4C6A055A41	520290000	Z	Autigny-le-Grand	5202900	52029	52	44	4
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	01010000206A080000D3B913859E352A41CCCCCC1C5B065A41	520300000	Z	Autigny-le-Petit	5203000	52030	52	44	3
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	01010000206A080000026BED2245DD29416666667690DF5941	520310000	Z	Autreville-sur-la-Renne	5203100	52031	52	44	32
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	01010000206A0800006A56559870222B41CDCCCC6C22CF5941	520330000	Z	Avrecourt	5203300	52033	52	44	8
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	01010000206A080000C17DC5ED9AAB2941000000C01C035A41	520340000	Z	Bailly-aux-Forges	5203400	52034	52	44	11
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	01010000206A08000014BEDBF8E4812A416666660625B75941	520350000	Z	Baissey	5203500	52035	52	44	10
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	01010000206A0800003412DC81A9CF2A41000000B02EC85941	520370000	Z	Bannes	5203700	52037	52	44	10
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	01010000206A080000B06E3005EA302B419A99994946DB5941	520380000	Z	Bassoncourt	5203800	52038	52	44	7
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	01010000206A0800000A5619D0A2CC29413333334391FC5941	520390000	Z	Baudrecourt	5203900	52039	52	44	9
01060000206A080000010000000103000000010000004F02000066666666A6022A41333333738CBD594166666666B1022A41CDCCCC6C9BBD59419A999999F8022A419A999999ABBD59419A99999916032A41CDCCCCCCACBD59413333333369032A4133333313A9BD59416666666693032A41CDCCCC8CB1BD594100000000A8032A4133333353BABD5941CDCCCCCC97032A419A999999CBBD594100000000AA032A41CDCCCC6CD6BD594166666666D0032A4100000060E2BD5941333333332B042A41666666A6F2BD59419A99999960042A41666666A600BE594100000000A5042A41CDCCCC2C0DBE5941CDCCCCCCE3042A419A99999915BE59419A99999918052A419A9999F916BE59416666666659052A419A99995916BE59419A999999A4052A419A9999591ABE59419A999999CF052A41666666E621BE5941666666660C062A41666666E62FBE59419A9999993C062A41000000A038BE5941CDCCCCCC6C062A416666660644BE5941000000007C062A41CDCCCCAC48BE5941CDCCCCCCBA062A41333333D34BBE5941CDCCCCCC3F072A41CDCCCC0C55BE5941666666669F072A41666666E65EBE594133333333AE072A41CDCCCC8C60BE59410000000018082A419A9999396CBE5941333333335C082A416666668675BE59416666666664082A41000000A080BE59413333333361082A41000000009BBE5941CDCCCCCC53082A4166666606B3BE5941CDCCCCCC51082A4133333393B8BE59413333333361082A4100000020BEBE59416666666666082A4100000080C2BE5941CDCCCCCC75082A41CDCCCC4CC6BE5941CDCCCCCCB4082A4133333333D0BE59410000000015092A41333333F3E1BE5941666666664C092A41000000A0EABE59413333333377092A419A9999F9EEBE594166666666A2092A41000000E0F8BE59419A999999E1092A413333339306BF594133333333490A2A41333333B315BF59419A9999998F0A2A419A9999791BBF594100000000CC0A2A419A99999923BF59419A999999F90A2A41000000C02BBF594100000000FF0A2A413333337330BF594133333333090B2A41CDCCCCEC33BF5941CDCCCCCC1A0B2A419A9999B937BF5941000000001B0B2A41666666A63ABF5941333333332A0B2A41000000C03EBF59419A999999390B2A41333333D342BF59419A999999460B2A410000004049BF594100000000600B2A41000000804EBF5941666666669C0B2A416666662655BF594100000000E60B2A41333333B35EBF594100000000F00B2A41CDCCCCEC5FBF5941CDCCCCCCEF0B2A41000000E060BF59419A999999EA0B2A41333333F361BF59419A999999E50B2A41CDCCCC6C62BF594166666666E70B2A413333335363BF594133333333ED0B2A410000002064BF5941CDCCCCCCF50B2A413333337364BF59419A999999020C2A416666662664BF5941000000000F0C2A41CDCCCC2C64BF5941CDCCCCCC140C2A41CDCCCC4C65BF594166666666170C2A413333337366BF5941CDCCCCCC180C2A41CDCCCC6C68BF594100000000160C2A41333333D36ABF59419A999999170C2A41333333336CBF5941666666661B0C2A41333333736DBF594166666666220C2A419A9999596EBF594100000000320C2A41000000406FBF59419A9999993D0C2A41CDCCCC0C70BF59419A999999420C2A419A99993971BF594100000000460C2A41000000A072BF59419A9999994E0C2A41CDCCCC4C74BF594100000000550C2A419A99991976BF59419A999999550C2A41CDCCCC0C78BF5941CDCCCCCC4F0C2A419A9999D978BF5941CDCCCCCC450C2A410000006079BF5941333333333B0C2A41000000007ABF594133333333370C2A41333333137BBF59419A999999390C2A41333333937CBF59419A999999400C2A41666666067EBF5941CDCCCCCC480C2A41333333537FBF594133333333500C2A41000000E080BF59419A999999510C2A41666666A682BF5941333333334D0C2A41333333D383BF594133333333440C2A416666666685BF594133333333410C2A41000000C086BF594166666666430C2A41CDCCCCCC87BF594100000000480C2A419A99997989BF5941666666664E0C2A41333333938BBF5941CDCCCCCC4F0C2A41CDCCCC2C8DBF594100000000530C2A41CDCCCCAC8FBF59419A999999530C2A41000000A091BF594166666666540C2A416666662694BF5941666666664F0C2A416666664695BF5941CDCCCCCC4A0C2A41666666E695BF5941CDCCCCCC4D0C2A419A9999F996BF594166666666520C2A413333331398BF5941000000004E0C2A410000004099BF5941CDCCCCCC480C2A419A9999D99ABF594133333333480C2A41333333539CBF5941666666664A0C2A419A9999F99DBF594100000000490C2A41CDCCCC2CA0BF59419A999999440C2A4166666666A2BF594166666666390C2A4133333373A7BF5941666666662D0C2A41000000C0AABF594166666666170C2A41CDCCCCECAEBF594166666666030C2A41CDCCCCCCB2BF594166666666F60B2A41CDCCCCCCB4BF594100000000EC0B2A4100000020B6BF594166666666DF0B2A4166666646B7BF594166666666D60B2A4133333313B9BF59419A999999CB0B2A419A9999F9BBBF59419A999999B50B2A419A999919C2BF5941CDCCCCCCA80B2A41666666E6C5BF594100000000A30B2A419A999939C8BF59419A999999A00B2A41333333D3CABF594166666666A30B2A41CDCCCCACCCBF594166666666AD0B2A4133333393D0BF59419A999999BA0B2A4133333333D4BF594100000000CA0B2A4100000020D7BF594100000000D20B2A41666666A6D8BF5941CDCCCCCCDD0B2A419A999959DABF5941CDCCCCCCE60B2A41666666E6DBBF594100000000EE0B2A4133333393DDBF59419A999999EE0B2A4133333333DFBF5941CDCCCCCCE90B2A41666666E6E0BF594100000000EC0B2A4100000080E2BF594166666666F50B2A41333333D3E3BF594133333333020C2A419A999959E5BF5941CDCCCCCC120C2A41CDCCCCACE6BF5941CDCCCCCC200C2A419A999959E7BF594166666666260C2A4133333393E8BF59419A999999270C2A41CDCCCC4CEABF5941000000002A0C2A41CDCCCCCCEBBF5941666666662C0C2A4100000020EDBF59419A999999340C2A4166666626EEBF59419A9999994E0C2A41666666A6F0BF5941666666665D0C2A4100000060F2BF594166666666650C2A419A999919F4BF5941000000006E0C2A41666666E6F6BF59419A999999750C2A4100000040F9BF594100000000750C2A419A999979FBBF594133333333740C2A4100000000FEBF594133333333750C2A419A99993901C0594166666666790C2A419A9999B903C05941333333337A0C2A413333339305C05941666666667E0C2A416666660607C0594166666666870C2A41CDCCCCAC08C059419A9999998F0C2A41000000200AC0594100000000950C2A41CDCCCCEC0BC0594166666666970C2A41666666060EC05941CDCCCCCC9B0C2A41CDCCCC2C10C0594166666666A10C2A41000000C011C05941CDCCCCCCA90C2A413333335313C0594100000000B00C2A41666666E614C0594166666666B00C2A41CDCCCCAC16C0594133333333B10C2A419A99995918C059419A999999B50C2A41333333131AC05941CDCCCCCCBF0C2A41666666461CC0594133333333C80C2A41CDCCCCCC1DC0594133333333CC0C2A41666666461FC0594133333333CF0C2A419A99991921C059419A999999D40C2A416666662623C05941CDCCCCCCDA0C2A41666666A624C05941CDCCCCCCE00C2A419A9999D925C0594133333333E50C2A41666666A627C05941CDCCCCCCE70C2A41000000A029C05941CDCCCCCCE50C2A41CDCCCC0C2BC059419A999999E50C2A41000000A02CC0594100000000EC0C2A41666666A62EC0594166666666F60C2A410000004032C05941CDCCCCCC020D2A41CDCCCC6C37C05941666666664A0D2A41333333D32AC05941666666665E0D2A41CDCCCC8C29C059419A999999A40D2A419A9999792EC0594100000000F50D2A41000000A034C0594166666666EB0D2A410000006038C0594133333333A60D2A41333333F344C059419A999999920D2A419A9999F949C059419A999999F70D2A419A9999195AC0594166666666480E2A410000008066C0594133333333710E2A41333333F372C05941CDCCCCCC860E2A41666666A68AC05941CDCCCCCC9B0E2A41000000A099C05941CDCCCCCCD80E2A41CDCCCC4CA7C05941CDCCCCCC3D0F2A41CDCCCCACB8C05941666666663F0F2A41CDCCCCECCDC0594100000000960E2A419A999999D5C0594166666666640E2A41666666E6DBC0594133333333650E2A4100000020E7C05941333333335F0E2A419A9999D921C15941000000004D0E2A419A9999193CC1594133333333500E2A41CDCCCC0C69C159419A9999994B0E2A41333333F36DC15941CDCCCCCC950E2A419A99995971C1594100000000D50E2A413333337374C1594100000000170F2A41CDCCCC0C78C159419A9999996C0F2A41666666267CC1594166666666A10F2A41333333737EC159419A999999CE0F2A41CDCCCCAC7FC159413333333315102A413333337381C159410000000072102A41CDCCCCEC82C1594166666666BF102A419A99997984C15941CDCCCCCC10112A41666666C686C15941CDCCCCCC51112A416666668688C159410000000099112A41000000C08AC1594100000000F1112A41333333938DC15941000000003A122A41CDCCCC6C8FC159419A9999998C122A41CDCCCC2C92C1594100000000CA122A416666660694C159419A999999EB122A41CDCCCCCC95C15941333333330A132A416666668697C15941000000002F132A41666666669AC159413333333360132A41666666669FC15941333333338D132A419A999959A4C1594133333333BE132A41666666A6AAC1594166666666DC132A4100000000AFC15941CDCCCCCC2F142A41000000E0BAC159416666666687142A419A999959C8C1594133333333AF142A419A9999B9CDC15941CDCCCCCCC2142A4133333393CFC1594133333333D1142A4166666666D0C1594100000000F5142A419A9999F9D1C159419A9999999B152A419A999919D9C15941CDCCCCCC26162A4100000080DEC15941CDCCCCCC7A162A4133333313E2C1594100000000BD162A41333333D3E4C1594100000000D6162A4166666646E5C159419A999999E5162A4133333353E5C1594133333333F3162A41666666E6E4C159416666666601172A41000000A0E3C159416666666627172A41333333F3DEC159413333333345172A4100000000DBC159413333333359172A41CDCCCCECD8C159410000000068172A4100000080D7C15941000000000B192A41000000E0AAC1594100000000021A2A413333335392C1594166666666131A2A41666666E690C15941CDCCCCCC281B2A41333333337AC159419A9999999C1B2A413333331371C1594166666666E11B2A41000000206AC1594100000000171C2A413333337362C1594133333333271C2A419A9999995EC159419A999999641C2A419A9999794EC1594133333333C61C2A413333337336C1594133333333031D2A41333333932BC1594133333333E51C2A419A99991929C15941CDCCCCCCE91B2A41666666E612C15941333333335D1B2A41CDCCCC0C09C1594100000000031B2A41666666A606C15941CDCCCCCC6C1A2A41333333D301C1594166666666121A2A41CDCCCC6CFAC05941CDCCCCCCB7192A4166666686F0C05941333333333F192A4166666666E5C059410000000007182A4166666606C4C059419A999999CE162A41000000A09DC059416666666655162A41666666068BC0594166666666FA152A41000000A079C0594133333333BD152A413333333368C0594100000000A8152A410000000058C059416666666684142A41333333933BC059419A99999929142A41CDCCCC6C30C0594133333333B0132A41333333531BC059416666666683132A41666666E610C059416666666690132A41CDCCCCEC0FC0594166666666A6132A41CDCCCC8C0EC0594100000000BA132A41666666660DC059419A999999CD132A41333333330CC0594133333333DB132A419A9999790BC0594133333333E7132A41666666E60AC0594133333333FF132A419A9999390AC059413333333322142A419A99995909C059419A99999945142A41CDCCCC6C08C05941666666667D142A410000002007C059419A999999AA142A416666662606C0594133333333D0142A41333333B304C0594133333333F6142A419A99999902C059410000000038152A41666666A6FDBF5941666666665F152A41666666C6FABF5941333333337A152A41666666E6F8BF594133333333A5152A41666666A6F7BF594133333333DD152A419A9999F9F5BF5941000000000C162A41CDCCCCECF4BF59410000000034162A41CDCCCC8CF4BF59419A99999955162A41CDCCCC8CF4BF59416666666671162A419A9999D9F4BF59419A99999985162A41000000C0F4BF5941CDCCCCCCA5162A41333333F3F3BF5941CDCCCCCCE2162A419A9999F9F1BF5941666666660E172A41CDCCCCECF0BF59416666666623172A41666666A6F0BF59419A9999991B172A41CDCCCCECE0BF594166666666FC162A419A999979CFBF594166666666ED162A4133333313C5BF594166666666EF162A4166666606C5BF59419A99999913172A419A999939C4BF59413333333339172A41CDCCCCACC3BF59419A99999960172A4166666606C3BF5941CDCCCCCC91172A4166666686C2BF594166666666C1172A4166666626C2BF5941CDCCCCCCF0172A4133333333C2BF59413333333319182A41CDCCCC4CC2BF5941666666665A182A41000000A0C2BF594133333333A8182A419A9999F9C2BF594133333333DC182A419A999939C3BF5941CDCCCCCC02192A4166666626C3BF5941333333332D192A41666666A6C2BF5941CDCCCCCCF3182A4100000020BFBF594166666666E1182A4166666686BDBF59419A999999A7182A4133333353B8BF59419A99999961182A419A9999F9B1BF59416666666625182A419A999999ACBF594133333333EC172A419A999999A7BF5941CDCCCCCCD4172A41000000C0A5BF59416666666669182A410000002089BF594133333333A4182A41333333D378BF59419A999999A3182A419A9999D96EBF594100000000B7182A413333335367BF594100000000AC1A2A41000000A0E8BE594166666666841B2A41CDCCCC2CB5BE594133333333B51B2A4166666626A6BE594133333333221C2A416666664698BE594100000000C11C2A410000002089BE59419A999999F21C2A413333331384BE59419A999999231D2A416666660675BE594166666666371D2A416666664671BE594100000000681D2A419A9999395DBE594133333333711D2A419A99993953BE5941CDCCCCCC661D2A41000000004DBE5941CDCCCCCC5B1D2A41000000003EBE59419A999999DB1D2A41666666A61EBE5941333333330C1E2A419A9999990ABE594100000000291E2A419A999919F9BD594100000000141E2A4100000020EABD594133333333F51D2A41CDCCCCACDDBD594166666666171D2A41CDCCCCACC3BD594133333333B31C2A41666666C6BEBD594100000000CD1B2A4166666606BABD5941CDCCCCCC541B2A4166666666B6BD594100000000FA182A419A99995986BD59419A9999991C182A419A9999D96EBD5941CDCCCCCC53172A413333339362BD594166666666BD162A419A9999395BBD59419A9999990F162A419A9999594EBD59419A999999A6152A419A9999F95FBD59410000000092152A41CDCCCC6C63BD59410000000062152A41666666E66DBD5941333333335B152A41666666A66FBD59410000000023152A41000000607FBD5941CDCCCCCC1A152A41CDCCCC0C82BD594166666666D8142A41333333B393BD59410000000097142A41000000E09BBD59413333333389142A419A9999599DBD59413333333370142A41666666C69EBD59416666666665142A41000000409FBD59419A99999955142A41666666269FBD59419A99999945142A41000000609FBD59416666666612142A4100000040A0BD59419A99999905142A419A9999F9A0BD5941CDCCCCCCF1132A41CDCCCC0CA3BD59419A999999EC132A41000000E0A1BD594166666666E0132A419A9999D9A0BD59419A999999C8132A419A9999B99DBD5941CDCCCCCCAA132A41333333539ABD5941000000009F132A41CDCCCCCC98BD5941CDCCCCCC97132A410000004097BD59416666666694132A41666666A695BD5941CDCCCCCC91132A41CDCCCCEC93BD5941CDCCCCCC8D132A413333337392BD5941CDCCCCCC86132A41CDCCCCCC90BD5941666666667D132A41CDCCCCAC8FBD59413333333370132A419A9999798EBD5941CDCCCCCC61132A41000000808DBD5941CDCCCCCC52132A41333333938CBD59410000000043132A41000000808BBD5941CDCCCCCC3C132A41666666868ABD59413333333336132A413333335389BD5941000000002D132A410000002088BD5941CDCCCCCC1E132A41666666C686BD59410000000014132A410000004086BD59410000000007132A410000008086BD59419A999999FA122A41000000C086BD594133333333EF122A413333331387BD594166666666E3122A410000004087BD5941CDCCCCCCD6122A413333331387BD59419A999999D0122A41CDCCCC6C86BD5941CDCCCCCCCC122A41CDCCCC6C85BD594133333333CA122A41333333F383BD594166666666C9122A419A99997982BD594100000000CA122A419A9999B980BD59419A999999CC122A419A9999F97EBD594100000000CD122A419A9999B97CBD59419A999999CA122A419A9999197BBD594100000000C7122A41333333F378BD594133333333C6122A413333335377BD594133333333C8122A41000000C075BD59419A999999CC122A41333333B373BD59419A999999D1122A410000000072BD59419A999999D5122A41CDCCCC6C6FBD5941CDCCCCCCD6122A41CDCCCC4C6DBD59419A999999D3122A41666666E66BBD594133333333CE122A41333333F36ABD594133333333CD122A410000006069BD5941CDCCCCCCD0122A419A99991968BD594133333333D8122A41000000A066BD59419A999999E0122A419A9999B964BD594166666666E4122A41CDCCCCEC62BD594166666666E5122A41666666E660BD594166666666E4122A41333333335FBD594100000000E1122A419A9999F95CBD594133333333DD122A41CDCCCC6C5BBD594166666666D6122A419A9999195ABD594133333333CD122A416666662659BD594166666666BB122A416666668658BD594100000000AC122A419A99997958BD5941CDCCCCCC97122A41CDCCCC6C58BD59413333333387122A419A99991958BD5941CDCCCCCC7A122A416666664657BD59416666666675122A410000004056BD59419A99999977122A41CDCCCC8C54BD59419A99999980122A41CDCCCC4C53BD59410000000088122A419A99991952BD5941333333338F122A419A99999950BD59410000000091122A41666666E64EBD5941000000008F122A41CDCCCCCC4CBD5941000000008B122A41333333334BBD59416666666682122A419A99991949BD59410000000076122A419A99991947BD5941666666666C122A41CDCCCC6C45BD59416666666665122A413333337343BD5941333333335B122A41333333D341BD5941666666664F122A41000000C03FBD59416666666647122A41333333B33DBD59413333333342122A419A9999F93ABD5941000000003C122A41CDCCCCAC38BD59410000000033122A41CDCCCC8C36BD5941333333332B122A41666666E634BD59416666666626122A413333333333BD59413333333328122A41CDCCCC2C31BD5941666666662D122A41666666662FBD59419A9999992F122A41CDCCCCCC2CBD5941CDCCCCCC2C122A41666666C62ABD59413333333328122A41666666A628BD59413333333320122A41666666A626BD59410000000012122A41666666A625BD59413333333304122A41CDCCCCEC24BD59419A999999F0112A416666660624BD594133333333D8112A413333331323BD59419A999999C7112A419A99995922BD59419A999999BE112A419A99995921BD59419A999999B7112A41333333F31FBD594166666666B3112A41666666261EBD594166666666B0112A41000000201CBD594133333333AE112A41666666061ABD594100000000AF112A410000000018BD594100000000B4112A410000006016BD59419A999999BB112A410000000015BD59419A999999C4112A41CDCCCC0C14BD59419A999999CC112A419A9999B912BD594100000000D0112A41CDCCCC0C11BD594166666666CA112A41333333130FBD594166666666C6112A41666666260CBD594166666666C4112A41CDCCCCAC09BD5941CDCCCCCCC1112A413333333307BD5941CDCCCCCCC1112A41CDCCCC8C04BD59419A999999C1112A41666666E600BD59419A999999C5112A419A9999B9FABC594100000000C8112A419A9999F9F4BC594166666666CA112A419A999959F0BC5941CDCCCCCCCA112A4166666626EDBC5941CDCCCCCCCB112A41666666E6E9BC59419A999999CD112A4166666686E7BC59419A999999CD112A4166666626E5BC594166666666C9112A419A9999F9E1BC59419A999999C7112A41333333F3DEBC594166666666C7112A41666666E6DCBC594166666666CB112A4133333333DBBC59419A999999D5112A41CDCCCC8CD9BC594133333333DE112A41000000C0D7BC59419A999999DB112A419A9999D9D4BC594133333333D9112A41666666E6D3BC594133333333DE112A419A999919D2BC594100000000E9112A41CDCCCCACD0BC594166666666EF112A419A9999F9CEBC594166666666E9112A41666666C6CCBC59419A999999E7112A4100000080CABC594100000000EF112A41666666A6C8BC594166666666F3112A419A999999C6BC594100000000F4112A419A9999B9C3BC5941CDCCCCCCF0112A4100000060C0BC594100000000ED112A41666666A6BCBC594100000000EB112A4166666686BABC594166666666E9112A41000000A0B7BC594100000000EA112A4133333313B4BC5941CDCCCCCCEA112A4100000040B1BC594133333333EC112A4166666646AEBC594100000000ED112A41CDCCCC4CABBC594100000000EB112A41666666A6A7BC594100000000EA112A419A999979A5BC594133333333E5112A41CDCCCC4CA3BC594100000000E2112A41666666C6A0BC59419A999999DE112A41CDCCCC4C9EBC594166666666DA112A419A9999199BBC594100000000D6112A413333335399BC594133333333CF112A419A9999F997BC594166666666C7112A416666666696BC5941CDCCCCCCC2112A413333337394BC5941CDCCCCCCC1112A419A99997992BC594100000000C3112A416666664690BC594166666666C1112A41000000808DBC594100000000C3112A41666666068CBC594166666666C4112A416666664689BC5941CDCCCCCCC4112A413333331387BC5941CDCCCCCCCA112A41333333B384BC5941CDCCCCCCD0112A413333331383BC5941CDCCCCCCD7112A410000004081BC594166666666E1112A41333333F37EBC59419A999999E7112A419A9999997CBC594100000000EB112A41333333D374BC594100000000EA112A41333333D372BC594166666666E5112A413333331371BC594166666666DD112A41666666866FBC594133333333DC112A41333333D36DBC594133333333E3112A41000000406CBC594133333333EA112A41666666C66ABC594133333333F5112A41000000E069BC59413333333306122A41666666E669BC59413333333318122A419A9999D968BC59419A9999991A122A419A99999967BC59416666666618122A41333333F365BC59419A99999912122A41666666E663BC5941000000000B122A41666666A662BC594166666666FE112A41666666C661BC59419A999999ED112A419A99999960BC594133333333E3112A41666666465FBC594133333333D9112A419A9999F95CBC594166666666C8112A41CDCCCCCC5ABC594166666666BC112A413333333359BC5941CDCCCCCCB0112A41333333F356BC594166666666A4112A41666666A655BC59419A99999994112A419A99999954BC5941CDCCCCCC88112A419A99995953BC59419A99999979112A419A9999B951BC5941000000006B112A41CDCCCC6C50BC59419A9999995C112A419A9999194FBC59419A99999950112A41333333B34DBC5941CDCCCCCC46112A41000000004CBC59410000000041112A419A9999B949BC5941666666663D112A419A99993947BC59419A9999993A112A419A9999D943BC59410000000036112A41666666E640BC59410000000032112A41666666C63EBC5941333333332F112A419A9999B93CBC59419A9999992E112A41666666E639BC59413333333330112A419A9999F936BC59413333333330112A41666666C634BC59410000000089102A41666666A63DBC59419A999999B80F2A419A9999D951BC5941333333332D0F2A41000000C05ABC594166666666D30E2A41333333D35ABC594100000000330E2A41000000C054BC594133333333920D2A413333333347BC5941CDCCCCCC6A0D2A419A9999B94EBC594100000000EA0C2A419A99995960BC594133333333FC0B2A419A9999597DBC5941CDCCCCCCFA0A2A419A9999599FBC594166666666D30A2A4100000060A9BC594133333333A20A2A41CDCCCCACB4BC5941333333333F0A2A4166666646C1BC5941666666668C092A4133333373D0BC5941000000003D092A4166666606D8BC59416666666629092A41CDCCCC4CDEBC594133333333E5082A419A999959F7BC594133333333BE082A410000006006BD59419A99999979082A413333333319BD59410000000003082A41CDCCCC8C2EBD5941666666668C072A41CDCCCC2C40BD59410000000015072A41CDCCCC0C49BD59416666666693062A41CDCCCCAC4BBD59419A99999911062A41333333134DBD59416666666668052A419A9999B959BD5941CDCCCCCCC5032A41CDCCCC2C69BD59413333333376032A41000000C06DBD59413333333344032A41CDCCCC4C6EBD594133333333EB022A41666666A679BD594133333333B0022A413333337387BD594166666666A6022A41333333738CBD5941	01060000206A08000001000000010300000001000000FB00000066666666A6022A41333333738CBD594166666666B1022A41CDCCCC6C9BBD59419A999999F8022A419A999999ABBD59419A99999916032A41CDCCCCCCACBD59413333333369032A4133333313A9BD59416666666693032A41CDCCCC8CB1BD594100000000A8032A4133333353BABD5941CDCCCCCC97032A419A999999CBBD594100000000AA032A41CDCCCC6CD6BD594166666666D0032A4100000060E2BD5941333333332B042A41666666A6F2BD59419A99999960042A41666666A600BE594100000000A5042A41CDCCCC2C0DBE5941CDCCCCCCE3042A419A99999915BE59419A99999918052A419A9999F916BE59416666666659052A419A99995916BE59419A999999A4052A419A9999591ABE59419A999999CF052A41666666E621BE5941666666660C062A41666666E62FBE59419A9999993C062A41000000A038BE5941000000007C062A41CDCCCCAC48BE5941CDCCCCCCBA062A41333333D34BBE5941CDCCCCCC3F072A41CDCCCC0C55BE59410000000018082A419A9999396CBE5941333333335C082A416666668675BE59416666666664082A41000000A080BE59413333333361082A41000000009BBE5941CDCCCCCC51082A4133333393B8BE5941CDCCCCCC75082A41CDCCCC4CC6BE5941CDCCCCCCB4082A4133333333D0BE59410000000015092A41333333F3E1BE5941666666664C092A41000000A0EABE59413333333377092A419A9999F9EEBE59419A999999E1092A413333339306BF594133333333490A2A41333333B315BF59419A9999998F0A2A419A9999791BBF594100000000CC0A2A419A99999923BF59419A999999F90A2A41000000C02BBF5941000000001B0B2A41666666A63ABF59419A999999460B2A410000004049BF594100000000600B2A41000000804EBF594100000000F00B2A41CDCCCCEC5FBF594133333333ED0B2A410000002064BF5941000000000F0C2A41CDCCCC2C64BF5941666666661B0C2A41333333736DBF59419A9999993D0C2A41CDCCCC0C70BF59419A999999550C2A41CDCCCC0C78BF59419A999999390C2A41333333937CBF59419A999999510C2A41666666A682BF594133333333410C2A41000000C086BF594166666666540C2A416666662694BF594100000000490C2A41CDCCCC2CA0BF5941666666662D0C2A41000000C0AABF594166666666D60B2A4133333313B9BF594100000000A30B2A419A999939C8BF59419A999999BA0B2A4133333333D4BF594100000000EE0B2A4133333393DDBF594100000000EC0B2A4100000080E2BF5941CDCCCCCC200C2A419A999959E7BF5941666666662C0C2A4100000020EDBF5941666666665D0C2A4100000060F2BF59419A999999750C2A4100000040F9BF594133333333750C2A419A99993901C05941CDCCCCCCE70C2A41000000A029C059419A999999E50C2A41000000A02CC05941CDCCCCCC020D2A41CDCCCC6C37C05941666666664A0D2A41333333D32AC05941666666665E0D2A41CDCCCC8C29C0594100000000F50D2A41000000A034C0594166666666EB0D2A410000006038C0594133333333A60D2A41333333F344C059419A999999920D2A419A9999F949C0594166666666480E2A410000008066C0594133333333710E2A41333333F372C05941CDCCCCCC860E2A41666666A68AC05941CDCCCCCC9B0E2A41000000A099C05941CDCCCCCCD80E2A41CDCCCC4CA7C05941CDCCCCCC3D0F2A41CDCCCCACB8C05941666666663F0F2A41CDCCCCECCDC0594100000000960E2A419A999999D5C0594166666666640E2A41666666E6DBC0594133333333650E2A4100000020E7C05941333333335F0E2A419A9999D921C15941000000004D0E2A419A9999193CC1594133333333500E2A41CDCCCC0C69C159419A9999994B0E2A41333333F36DC1594166666666A10F2A41333333737EC159413333333315102A413333337381C1594166666666BF102A419A99997984C15941CDCCCCCC51112A416666668688C1594100000000CA122A416666660694C15941000000002F132A41666666669AC15941333333338D132A419A999959A4C15941CDCCCCCC2F142A41000000E0BAC159416666666687142A419A999959C8C15941CDCCCCCCC2142A4133333393CFC159419A9999999B152A419A999919D9C1594100000000BD162A41333333D3E4C159416666666601172A41000000A0E3C159410000000068172A4100000080D7C15941000000000B192A41000000E0AAC1594100000000021A2A413333335392C15941CDCCCCCC281B2A41333333337AC159419A9999999C1B2A413333331371C1594166666666E11B2A41000000206AC1594100000000171C2A413333337362C1594133333333C61C2A413333337336C1594133333333031D2A41333333932BC15941CDCCCCCCE91B2A41666666E612C15941333333335D1B2A41CDCCCC0C09C15941CDCCCCCC6C1A2A41333333D301C1594166666666121A2A41CDCCCC6CFAC05941CDCCCCCCB7192A4166666686F0C05941333333333F192A4166666666E5C059410000000007182A4166666606C4C059419A999999CE162A41000000A09DC059416666666655162A41666666068BC0594166666666FA152A41000000A079C0594133333333BD152A413333333368C0594100000000A8152A410000000058C059416666666684142A41333333933BC059419A99999929142A41CDCCCC6C30C0594133333333B0132A41333333531BC059416666666683132A41666666E610C0594133333333E7132A41666666E60AC059419A999999AA142A416666662606C0594133333333F6142A419A99999902C05941333333337A152A41666666E6F8BF594133333333DD152A419A9999F9F5BF59410000000034162A41CDCCCC8CF4BF59419A99999985162A41000000C0F4BF59416666666623172A41666666A6F0BF59419A9999991B172A41CDCCCCECE0BF594166666666ED162A4133333313C5BF594166666666C1172A4166666626C2BF594133333333DC182A419A999939C3BF5941333333332D192A41666666A6C2BF5941CDCCCCCCF3182A4100000020BFBF5941CDCCCCCCD4172A41000000C0A5BF59416666666669182A410000002089BF594133333333A4182A41333333D378BF59419A999999A3182A419A9999D96EBF594100000000B7182A413333335367BF594100000000AC1A2A41000000A0E8BE594166666666841B2A41CDCCCC2CB5BE594133333333B51B2A4166666626A6BE594133333333221C2A416666664698BE59419A999999F21C2A413333331384BE59419A999999231D2A416666660675BE594166666666371D2A416666664671BE594100000000681D2A419A9999395DBE594133333333711D2A419A99993953BE5941CDCCCCCC5B1D2A41000000003EBE59419A999999DB1D2A41666666A61EBE5941333333330C1E2A419A9999990ABE594100000000291E2A419A999919F9BD594100000000141E2A4100000020EABD594133333333F51D2A41CDCCCCACDDBD594166666666171D2A41CDCCCCACC3BD594133333333B31C2A41666666C6BEBD594100000000CD1B2A4166666606BABD5941CDCCCCCC541B2A4166666666B6BD594100000000FA182A419A99995986BD59419A9999991C182A419A9999D96EBD5941CDCCCCCC53172A413333339362BD594166666666BD162A419A9999395BBD59419A9999990F162A419A9999594EBD59410000000092152A41CDCCCC6C63BD59410000000062152A41666666E66DBD594166666666D8142A41333333B393BD59413333333389142A419A9999599DBD59416666666665142A41000000409FBD59416666666612142A4100000040A0BD5941CDCCCCCCF1132A41CDCCCC0CA3BD5941000000009F132A41CDCCCCCC98BD5941CDCCCCCC86132A41CDCCCCCC90BD59410000000043132A41000000808BBD59410000000014132A410000004086BD594166666666E3122A410000004087BD594133333333CA122A41333333F383BD594133333333C8122A41000000C075BD5941CDCCCCCCD6122A41CDCCCC4C6DBD5941CDCCCCCCD0122A419A99991968BD594166666666E4122A41333333335FBD594133333333CD122A416666662659BD59413333333387122A419A99991958BD59416666666675122A410000004056BD5941333333338F122A419A99999950BD5941000000008B122A41333333334BBD59416666666647122A41333333B33DBD59416666666626122A413333333333BD59419A9999992F122A41CDCCCCCC2CBD59413333333320122A41666666A626BD59419A999999C7112A419A99995922BD59419A999999B7112A41333333F31FBD594100000000AF112A410000000018BD59419A999999CC112A419A9999B912BD59419A999999C1112A41666666E600BD59419A999999CD112A4166666626E5BC594166666666C7112A41666666E6DCBC594133333333DE112A41000000C0D7BC594133333333D9112A41666666E6D3BC594166666666EF112A419A9999F9CEBC59419A999999E7112A4100000080CABC594100000000F4112A419A9999B9C3BC594166666666E9112A41000000A0B7BC594100000000EA112A419A999979A5BC594166666666DA112A419A9999199BBC5941CDCCCCCCC2112A413333337394BC5941CDCCCCCCC4112A413333331387BC59419A999999E7112A419A9999997CBC594100000000EA112A41333333D372BC594133333333DC112A41333333D36DBC594133333333EA112A41666666C66ABC59413333333318122A419A9999D968BC5941000000000B122A41666666A662BC59419A999999ED112A419A99999960BC5941CDCCCCCCB0112A41333333F356BC5941CDCCCCCC46112A41000000004CBC5941333333332F112A419A9999B93CBC59413333333330112A41666666C634BC59410000000089102A41666666A63DBC59419A999999B80F2A419A9999D951BC5941333333332D0F2A41000000C05ABC594166666666D30E2A41333333D35ABC594100000000330E2A41000000C054BC594133333333920D2A413333333347BC5941CDCCCCCC6A0D2A419A9999B94EBC594100000000EA0C2A419A99995960BC594133333333FC0B2A419A9999597DBC5941CDCCCCCCFA0A2A419A9999599FBC594133333333A20A2A41CDCCCCACB4BC5941333333333F0A2A4166666646C1BC5941666666668C092A4133333373D0BC5941000000003D092A4166666606D8BC59416666666629092A41CDCCCC4CDEBC594133333333BE082A410000006006BD59419A99999979082A413333333319BD59410000000003082A41CDCCCC8C2EBD5941666666668C072A41CDCCCC2C40BD59410000000015072A41CDCCCC0C49BD59416666666693062A41CDCCCCAC4BBD59419A99999911062A41333333134DBD59416666666668052A419A9999B959BD5941CDCCCCCCC5032A41CDCCCC2C69BD59413333333376032A41000000C06DBD59413333333344032A41CDCCCC4C6EBD594133333333EB022A41666666A679BD594133333333B0022A413333337387BD594166666666A6022A41333333738CBD594166666666A6022A41333333738CBD5941	01010000206A0800004CDA9A8816122A41333333230EBF5941	520400000	Z	Bay-sur-Aube	5204000	52040	52	44	10
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	01010000206A080000CC260786C47B2A41666666A664C95941	520420000	Z	Beauchemin	5204200	52042	52	44	12
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	01010000206A080000330411432F342B41666666A6B7B45941	520430000	Z	Belmont	5204300	52043	52	44	7
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	01010000206A08000088B56FE0DD712A41000000F06FF25941	520440000	Z	Roches-Bettaincourt	5204400	52044	52	44	41
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	01010000206A08000056442D8EA8CF2941CCCCCCAC34195A41	520450000	Z	Bettancourt-la-Ferrée	5204500	52045	52	44	5
01060000206A08000001000000010300000001000000F00100003333333345772941CDCCCC8C98F4594133333333E677294100000060A7F459416666666673782941333333F3B9F45941CDCCCCCCEC782941CDCCCC4CD0F45941CDCCCCCC297929419A9999F9DDF4594133333333EF7A29419A99997914F559419A9999996A7B29413333339329F5594166666666897B29416666660636F55941666666668A7B29416666660645F55941CDCCCCCC807B2941666666864CF55941333333337C7C29410000004061F5594166666666237C29413333335374F5594100000000FC7B29419A9999D97BF55941000000003A7C29413333331382F5594133333333E47C29419A99991993F5594166666666157D2941CDCCCC0C93F55941CDCCCCCC467D2941000000808BF5594100000000067E2941666666069EF5594100000000BB7E294133333353AFF559419A9999991F7F2941333333F3B7F559419A999999CC7F294166666646C9F55941666666662880294166666666E3F559419A99999997802941666666C6F4F55941333333332E8129419A9999D9FFF559410000000047822941CDCCCC4C0DF659419A999999D38229410000006019F65941CDCCCCCC23832941CDCCCC0C1DF6594133333333BF8429419A99999935F659419A999999D8852941666666C64BF65941333333331F8629413333337354F65941000000002C862941CDCCCC2C62F65941CDCCCCCCB8862941666666466DF65941CDCCCCCCE08629419A9999B96FF6594133333333FF862941CDCCCCEC75F65941333333338C8729416666660686F65941333333334B882941CDCCCC0C96F6594100000000CE88294166666666A2F65941000000001F89294133333313B1F659419A9999994C8A29419A9999F9CAF6594100000000028B294166666646E1F65941CDCCCCCC2C8B294133333373E4F6594100000000508B294100000040E1F65941000000005B8B2941333333F3DFF6594133333333828B2941000000C0D9F6594133333333A28B294133333333D4F6594100000000C68B294166666686CDF6594166666666E88B29419A9999B9C6F65941000000000E8C2941CDCCCCECBEF65941666666663D8C294133333333B6F6594166666666668C294133333373AEF6594166666666898C294100000080A8F65941CDCCCCCCA88C2941CDCCCCACA4F65941CDCCCCCCC88C2941000000A0A0F6594166666666F78C29419A9999B99BF6594133333333248D2941CDCCCC8C97F65941CDCCCCCC668D2941333333D392F6594133333333A48D29419A9999B98EF6594100000000D48D2941CDCCCCAC8CF659419A999999068E2941000000608BF6594166666666388E2941666666A68AF6594133333333608E2941CDCCCC8C8AF65941000000007D8E2941333333B38AF65941CDCCCCCCA78E2941CDCCCCAC8AF659419A999999C68E2941000000A08AF6594166666666F58E2941000000E089F65941666666661A8F29416666662689F65941CDCCCCCC828F29419A99999984F659413333333354902941000000207EF65941CDCCCCCC8F9029413333331379F65941CDCCCCCCCA902941000000006AF6594100000000F1902941000000804EF65941333333335D9129416666666635F6594166666666DC912941000000402BF65941000000002C922941CDCCCC6C27F65941CDCCCCCC1B932941CDCCCC2C27F659413333333386942941666666462FF659419A999999759429410000000028F65941000000008B942941CDCCCCEC20F65941666666668A942941CDCCCC8C19F65941CDCCCCCC799429419A9999B90AF65941666666667C9429419A99995901F659419A999999949429419A999999F5F55941666666669094294100000000E6F5594100000000A594294166666666D4F55941CDCCCCCCBC94294133333333C3F559419A999999E4942941666666C6B9F5594100000000139529419A9999F9AFF5594133333333799529419A999919A6F55941CDCCCCCCF59529419A9999399AF55941CDCCCCCC7A9629419A9999D98CF559419A999999AF962941CDCCCCAC89F5594133333333E19629410000000083F559419A9999991F972941CDCCCC2C7DF55941333333338D9729413333331378F55941CDCCCCCCC09729416666660670F55941CDCCCCCCE8972941CDCCCCEC68F5594133333333EE972941333333935DF5594100000000F7972941CDCCCC6C53F559419A99999915982941000000C04CF55941CDCCCCCC21982941CDCCCC4C47F559413333333324982941000000203DF55941333333331A9829413333339334F559419A99999929982941000000802DF559413333333307982941CDCCCCCC1BF559419A9999993F982941666666A61CF55941000000006D9829419A9999791DF55941CDCCCCCC9C9829419A9999191EF559419A999999BF9829419A9999B91EF559419A999999F7982941333333931FF559410000000044992941666666E620F559419A9999999B992941CDCCCCAC22F5594100000000B69929410000004023F5594100000000459A29419A99999926F5594133333333AB9A29410000004029F55941000000002F9B29419A9999F92BF5594100000000929B2941000000202EF55941000000009D9B29419A9999592EF5594133333333C89B2941666666662FF55941CDCCCCCC019C2941CDCCCCCC30F55941CDCCCCCC1E9C29419A99997931F55941CDCCCCCC499C2941CDCCCC8C32F559419A9999997D9C2941666666A633F5594133333333AE9C29419A99995934F559419A999999CC9C2941000000A034F5594166666666F09C2941666666C63BF55941666666667A9D2941666666A642F5594133333333179E2941333333734BF55941666666668E9E2941CDCCCCEC53F559410000000066A02941333333D353F5594133333333BAA029419A99991954F5594100000000FCA029419A9999F955F559416666666634A129419A99991957F559419A9999996CA129419A99993958F5594100000000A7A129413333339355F559413333333382A229419A9999194AF55941CDCCCCCCD4A229416666666645F55941CDCCCCCC57A329413333331344F5594100000000C5A32941CDCCCC2C43F5594133333333FDA329419A9999993FF559419A99999942A42941000000E037F559419A9999996EA42941CDCCCC6C21F559416666666680A42941000000E016F559419A999999B0A429410000000003F5594133333333C6A42941CDCCCC6CF6F459419A999999CBA4294100000040ECF45941CDCCCCCCE4A4294166666606E4F4594100000000EDA4294100000000DDF459419A9999990BA529419A9999F9D4F459419A99999964A52941666666E6C5F459413333333371A5294166666606BEF45941000000007AA5294133333333B6F459416666666682A5294166666646A9F45941000000007BA52941CDCCCCAC99F45941666666666AA52941000000408BF459410000000079A52941000000607EF459416666666685A52941333333737AF45941333333338BA52941333333D373F4594100000000CAA529419A99991968F4594133333333DEA529413333339360F459413333333325A62941CDCCCCCC54F459410000000066A629416666660649F459419A99999981A629410000002043F459413333333399A62941666666A63EF45941CDCCCCCCCEA62941CDCCCC6C33F4594133333333F3A62941CDCCCC4C27F45941333333334CA72941000000E012F45941666666667BA72941333333F309F4594100000000A9A72941CDCCCCEC03F459410000000000A82941CDCCCC0CFCF35941000000002EA82941666666C6F6F35941CDCCCCCC54A82941000000C0E7F359413333333368A829419A9999B9DDF35941000000008DA829419A999999D7F359419A999999C7A829419A999959CDF359419A999999ECA82941CDCCCCECC5F359419A9999992DA92941CDCCCC0CBEF35941666666667BA9294166666646B9F3594133333333ADA929419A999919B6F3594166666666EBA9294133333313B4F35941CDCCCCCC1AAA2941CDCCCC4CB0F359416666666656AA29419A999939ABF35941CDCCCCCC5FAA29419A999939A0F359416666666673AA29410000002091F35941CDCCCCCC7EAA2941000000408FF35941000000008BAA2941CDCCCCCC8BF3594133333333A2AA2941CDCCCC8C84F3594166666666B6AA2941CDCCCC8C7DF3594100000000CDAA2941000000C074F3594166666666DAAA2941333333336DF3594100000000E0AA29419A9999B969F35941CDCCCCCCE1AA29419A9999F965F359419A999999DDAA29410000006061F3594100000000D3AA2941000000A05AF3594100000000C5AA29419A99995954F3594100000000B6AA2941666666E64FF3594166666666A9AA2941666666E64AF359419A999999A2AA29410000002046F359419A999999A1AA29416666668641F35941CDCCCCCCA3AA2941333333933CF3594166666666A8AA2941666666E632F3594166666666B2AA29410000004029F3594133333333BBAA2941CDCCCC6C23F3594133333333C1AA2941666666C61EF3594133333333C3AA2941666666661AF35941CDCCCCCCC2AA2941666666C614F3594100000000C1AA2941333333530EF3594166666666C1AA29413333339308F3594100000000C2AA29416666666604F35941CDCCCCCCC9AA29419A999979FEF25941CDCCCCCCEBAA29419A999959EDF25941CDCCCCCCFFAA2941CDCCCC0CEDF259413333333309AB2941666666C6ECF259419A99999912AB2941000000E0EBF259410000000018AB2941CDCCCC0CEBF259419A99999925AB294133333373E8F259419A9999992DAB29419A9999F9E6F259410000000042AB2941333333F3E3F25941CDCCCCCC58AB29419A999959E0F25941CDCCCCCC79AB294100000000DBF259413333333389AB294100000080D8F259413333333392AB29419A999939D7F25941666666669AAB294133333373D6F2594166666666ADAB294166666686D5F259419A999999CEAB294166666646D4F2594133333333F4AB2941333333D3D2F259419A99999915AC2941CDCCCC8CD1F259413333333324AC294166666626D1F25941CDCCCCCC34AC2941333333F3D0F259413333333355AC2941CDCCCCCCD0F259416666666679AC294100000060D0F2594133333333B2AC2941333333D3CFF2594166666666D8AC294133333353CFF25941CDCCCCCC00AD294166666666CEF259410000000035AD2941000000E0CCF25941000000008DAD2941CDCCCC2CCAF2594166666666D1AD2941333333B3C7F25941000000003EAE2941333333F3C2F25941CDCCCCCC56AE294166666626C2F259410000000078AE2941CDCCCC0CC1F25941CDCCCCCC62AE29419A999999B7F259410000000053AE2941CDCCCCACB0F259410000000043AE294100000040AAF259419A99999917AE2941333333139CF2594100000000F3AD2941666666A694F259419A999999E1AD29419A99991991F259419A999999D9AD2941CDCCCCAC8EF259419A999999D7AD2941CDCCCCCC8DF259419A999999AAAD2941333333738CF259413333333372AD2941666666868CF259413333333327AD2941333333D38BF2594133333333DCAC2941000000208BF259419A999999B6AC29410000004087F25941CDCCCCCC89AC29419A99993979F259410000000044AC2941333333B369F259419A99999909AC29419A99993962F2594166666666B6AB2941333333934FF259419A9999995BAB29413333333343F259419A999999F6AA2941CDCCCCEC46F25941CDCCCCCC92AA2941CDCCCCCC47F259410000000048AA2941CDCCCCAC48F2594166666666F0A929419A9999F947F25941CDCCCCCCADA92941666666A643F2594100000000A3A92941CDCCCCEC35F259416666666688A92941333333332BF259413333333365A92941000000001DF259410000000064A929416666660609F259419A99999976A9294100000040F6F159419A999999C4A92941333333B3DAF1594133333333C4A9294133333373D4F15941CDCCCCCC71A9294166666606D3F159416666666613A92941000000C0C9F1594133333333BBA82941333333B3BFF159410000000044A829419A999919B4F15941CDCCCCCCE5A729419A9999F9ADF1594166666666ADA7294100000020AAF15941000000001DA729419A999919A0F1594100000000ACA629413333333399F159419A99999960A62941CDCCCC0C93F15941CDCCCCCC2FA629419A9999B98BF1594133333333D5A52941333333937FF1594133333333CAA529419A9999D971F159419A999999C9A52941CDCCCC0C71F1594133333333B4A529416666662655F15941CDCCCCCC9FA52941CDCCCCEC4EF159419A999999CFA429410000002068F15941CDCCCCCC94A42941CDCCCC6C78F159416666666693A42941333333F39AF159419A99999987A42941CDCCCCCCA2F159413333333366A4294133333333A9F15941CDCCCCCC20A4294166666606B2F1594166666666DBA32941666666C6B3F15941666666667FA329419A999919B3F159410000000044A32941666666C6B2F159419A9999990BA32941000000E0B0F159419A999999C3A22941CDCCCC0CADF15941CDCCCCCC68A229419A9999D9A8F159413333333314A22941CDCCCC6CA5F1594166666666B4A1294133333333A6F159410000000075A1294133333353A8F15941000000003AA12941CDCCCC4CACF15941CDCCCCCCF8A029419A999939B2F159419A999999B7A0294166666626B8F159416666666676A029419A999959BBF159419A99999931A02941CDCCCCCCBBF1594166666666F99F2941CDCCCCECB9F159419A999999B79F2941666666A6B7F15941CDCCCCCC629F2941000000E0B1F15941CDCCCCCC3C9F2941CDCCCC0CACF1594100000000039F2941CDCCCCECA5F15941CDCCCCCC909E2941666666C6A6F159419A9999995B9E2941000000E0A4F15941CDCCCCCC389E294166666686A8F1594100000000FD9D294166666626A6F1594100000000E29D2941CDCCCCCCA4F1594133333333CA9D294133333353A3F1594100000000B59D294166666646A2F15941333333339F9D2941333333F3A0F15941CDCCCCCC8B9D294166666626A0F15941666666667C9D2941666666A69EF15941333333336B9D29419A9999B99CF1594100000000549D2941666666669AF159419A9999993E9D2941000000A098F15941CDCCCCCC2B9D2941333333B396F159419A9999991C9D29419A99991995F15941CDCCCCCC0F9D29416666662694F1594133333333FD9C29419A99991994F15941CDCCCCCCED9C2941666666A694F1594100000000D89C29413333335395F1594133333333C09C29419A99993995F1594166666666AF9C29419A99999995F1594166666666979C29416666662696F1594133333333879C2941666666E696F15941CDCCCCCC779C2941CDCCCC2C98F1594133333333689C29410000006099F159419A999999589C2941000000809AF15941000000004A9C29419A9999F99BF1594166666666389C29419A9999399DF15941000000002C9C29419A9999599EF1594133333333239C2941666666A69FF1594133333333149C2941000000C09FF1594166666666069C2941CDCCCCACA0F159419A999999FB9B29419A999939A2F1594100000000E99B2941000000A0A3F1594133333333DA9B2941000000C0A4F15941CDCCCCCCC89B2941666666A6A5F1594133333333B79B294100000080A7F15941CDCCCCCCA89B29419A999919A9F1594166666666939B294166666646AAF15941CDCCCCCC829B2941CDCCCC8CABF159419A999999709B294166666686ADF15941666666665D9B294100000080AFF15941000000004A9B2941CDCCCC2CB1F1594100000000399B2941000000C0B2F15941CDCCCCCC269B2941666666E6B4F159419A999999169B294133333333B6F1594100000000019B2941CDCCCCECB7F1594100000000EE9A2941CDCCCC6CB9F1594133333333D49A294166666646BBF15941CDCCCCCCB89A2941333333F3BCF15941666666669C9A294100000020BFF1594166666666839A294133333313C1F159419A999999649A294100000040C3F15941CDCCCCCCB59929419A9999D9CCF159419A9999999F992941CDCCCC0CCEF15941666666664499294100000000D2F15941666666661A992941333333B3D3F1594166666666F798294166666646D5F159419A999999DD9829419A999939D6F159419A999999C598294166666666D7F1594166666666B098294100000060D8F15941333333339C98294133333393D8F159410000000084982941333333D3D8F15941CDCCCCCC6E98294100000040D9F159416666666656982941CDCCCC2CDAF15941000000004698294100000000DBF159419A9999993498294166666606DCF15941666666662598294133333393DDF15941000000001C982941CDCCCCCCDEF15941CDCCCCCC0E982941CDCCCC2CE0F159419A999999FF972941CDCCCC4CE1F15941CDCCCCCCF0972941CDCCCC0CE2F1594166666666E5972941000000A0E2F15941CDCCCCCC7C97294133333333CBF15941333333334A97294166666686C2F1594166666666039729419A999959B7F1594166666666DB962941666666E6B4F15941333333337896294100000040C0F1594100000000CD942941CDCCCC6CE6F1594100000000FE93294166666626F3F15941CDCCCCCCF0922941CDCCCCECFAF1594100000000519229419A999959FCF15941CDCCCCCCF6912941333333B3F8F159419A999999819029419A9999D9E3F159419A999999099029419A999979E1F15941CDCCCCCCD38E294133333353E3F15941666666663C8E29419A999939E7F15941000000000B8E29419A999939EAF15941CDCCCCCCCF8D29419A999959EBF1594100000000828D294133333353ECF1594133333333978D294166666646E5F15941CDCCCCCC9C8D294100000080DBF1594100000000518D294133333333D0F159419A9999991B8D294133333313CAF15941CDCCCCCC058D2941333333D3C0F1594166666666558A2941CDCCCC8CD0F1594100000000108A294100000060D8F159419A9999998E89294100000000E0F15941CDCCCCCC80882941CDCCCC4CE0F15941333333333B882941000000A0E6F1594166666666C387294100000000E8F15941CDCCCCCCCA86294100000000FBF15941CDCCCCCC678629419A9999D908F25941CDCCCCCC368629410000006015F259419A999999EB852941333333733DF25941CDCCCCCCED852941CDCCCCEC5DF259419A999999DB852941CDCCCC6C79F2594133333333A78529416666668687F25941666666669B852941CDCCCCAC87F25941666666667F8529416666660687F2594166666666588529410000004086F25941333333331B8529413333339384F25941CDCCCCCCF18429416666668683F259419A999999CB842941333333D382F2594166666666AE842941666666E680F25941666666668E842941333333937EF2594133333333688429419A9999997BF25941333333334D8429413333339379F259410000000027842941CDCCCC0C76F25941000000000A842941CDCCCC0C73F25941CDCCCCCCE78329413333333370F2594133333333008329419A9999B95DF2594133333333D8822941000000C05DF2594166666666E0812941000000C07AF25941CDCCCCCC908129419A9999D97FF2594166666666188129419A9999B979F259419A99999995802941000000E06AF2594133333333318029419A9999B964F2594133333333697F29413333337362F2594100000000AB7E2941666666A65CF2594100000000BC7E294133333393C5F259419A999999D07E2941CDCCCC0CCDF25941333333335D7F2941000000E0D6F259419A9999995D7F294100000020DDF259419A999999077F2941333333B3F8F259419A999999277E2941000000204FF359419A999999F77D2941CDCCCCAC6AF3594100000000D67D29419A99991976F359419A999999BF7D29419A9999F975F3594166666666237D2941666666C67FF3594133333333257D29410000002081F3594100000000287D29416666668683F3594166666666277D29410000000086F3594133333333247D29410000002088F35941CDCCCCCC1C7D2941CDCCCCAC8AF3594166666666067D29410000000090F3594133333333E37C2941666666E697F3594100000000D97C2941333333739AF3594100000000C17C2941CDCCCC2CA0F35941CDCCCCCC9E7C294133333333A8F35941CDCCCCCC857C2941666666C6ADF35941000000006B7C294133333313B4F3594100000000607C2941CDCCCC0CB8F3594100000000557C294100000000BFF359419A999999547C2941666666A6BFF3594133333333037C294100000060D5F3594166666666657B2941666666C6F4F35941CDCCCCCC5C7B2941666666060AF45941666666661D7B29413333335319F4594166666666FF7A2941000000E01BF45941CDCCCCCCCE7A29413333335320F4594100000000A07A2941CDCCCCAC24F45941CDCCCCCC707A2941666666C628F45941000000006E7A29416666660629F459419A999999327A2941000000602DF4594100000000F97929413333335331F45941CDCCCCCCCE792941000000C034F4594133333333CB7929413333331335F45941CDCCCCCC9C7929419A9999393AF459419A999999757929413333331340F4594133333333597929413333337345F45941333333332F792941333333B34DF4594166666666067929419A99991956F4594100000000E0782941CDCCCCAC5DF4594133333333B7782941333333D364F459419A99999995782941666666C669F45941666666668E782941CDCCCCEC6AF4594100000000787829419A9999796EF45941CDCCCCCC56782941666666E672F4594133333333357829413333331377F4594133333333307829419A9999B977F45941CDCCCCCC237829416666664679F459410000000000782941000000C07DF4594100000000CB772941CDCCCC2C84F4594100000000917729419A9999198BF459419A99999961772941CDCCCC4C91F459413333333345772941CDCCCC8C98F45941	01060000206A08000001000000010300000001000000150100003333333345772941CDCCCC8C98F4594133333333E677294100000060A7F459416666666673782941333333F3B9F45941CDCCCCCCEC782941CDCCCC4CD0F45941CDCCCCCC297929419A9999F9DDF4594133333333EF7A29419A99997914F559419A9999996A7B29413333339329F5594166666666897B29416666660636F55941666666668A7B29416666660645F55941CDCCCCCC807B2941666666864CF55941333333337C7C29410000004061F5594100000000FC7B29419A9999D97BF5594133333333E47C29419A99991993F5594166666666157D2941CDCCCC0C93F55941CDCCCCCC467D2941000000808BF5594100000000BB7E294133333353AFF559419A9999991F7F2941333333F3B7F559419A999999CC7F294166666646C9F55941666666662880294166666666E3F559419A99999997802941666666C6F4F55941333333332E8129419A9999D9FFF559410000000047822941CDCCCC4C0DF659419A999999D38229410000006019F65941CDCCCCCC23832941CDCCCC0C1DF6594133333333BF8429419A99999935F659419A999999D8852941666666C64BF65941333333331F8629413333337354F65941000000002C862941CDCCCC2C62F65941CDCCCCCCE08629419A9999B96FF6594133333333FF862941CDCCCCEC75F65941333333338C8729416666660686F65941333333334B882941CDCCCC0C96F6594100000000CE88294166666666A2F65941000000001F89294133333313B1F659419A9999994C8A29419A9999F9CAF6594100000000028B294166666646E1F65941CDCCCCCC2C8B294133333373E4F65941000000005B8B2941333333F3DFF6594100000000C68B294166666686CDF65941000000000E8C2941CDCCCCECBEF6594166666666898C294100000080A8F65941CDCCCCCCC88C2941000000A0A0F6594133333333248D2941CDCCCC8C97F6594133333333A48D29419A9999B98EF6594100000000D48D2941CDCCCCAC8CF6594166666666388E2941666666A68AF659419A999999C68E2941000000A08AF65941666666661A8F29416666662689F65941CDCCCCCC828F29419A99999984F659413333333354902941000000207EF65941CDCCCCCC8F9029413333331379F65941CDCCCCCCCA902941000000006AF6594100000000F1902941000000804EF65941333333335D9129416666666635F6594166666666DC912941000000402BF65941000000002C922941CDCCCC6C27F65941CDCCCCCC1B932941CDCCCC2C27F659413333333386942941666666462FF659419A999999759429410000000028F65941000000008B942941CDCCCCEC20F65941666666668A942941CDCCCC8C19F65941CDCCCCCC799429419A9999B90AF65941666666667C9429419A99995901F659419A999999949429419A999999F5F55941666666669094294100000000E6F55941CDCCCCCCBC94294133333333C3F5594100000000139529419A9999F9AFF55941CDCCCCCCF59529419A9999399AF55941CDCCCCCC7A9629419A9999D98CF559419A999999AF962941CDCCCCAC89F5594133333333E19629410000000083F559419A9999991F972941CDCCCC2C7DF55941333333338D9729413333331378F55941CDCCCCCCE8972941CDCCCCEC68F5594100000000F7972941CDCCCC6C53F55941CDCCCCCC21982941CDCCCC4C47F559413333333324982941000000203DF55941333333331A9829413333339334F559419A99999929982941000000802DF559413333333307982941CDCCCCCC1BF559410000000044992941666666E620F5594100000000B69929410000004023F5594133333333AB9A29410000004029F55941000000009D9B29419A9999592EF559419A9999997D9C2941666666A633F559419A999999CC9C2941000000A034F5594166666666F09C2941666666C63BF55941666666667A9D2941666666A642F5594133333333179E2941333333734BF55941666666668E9E2941CDCCCCEC53F559410000000066A02941333333D353F5594133333333BAA029419A99991954F559419A9999996CA129419A99993958F5594100000000A7A129413333339355F55941CDCCCCCCD4A229416666666645F5594100000000C5A32941CDCCCC2C43F5594133333333FDA329419A9999993FF559419A99999942A42941000000E037F559416666666680A42941000000E016F559419A999999B0A429410000000003F5594133333333C6A42941CDCCCC6CF6F459419A999999CBA4294100000040ECF45941CDCCCCCCE4A4294166666606E4F4594100000000EDA4294100000000DDF459419A9999990BA529419A9999F9D4F459419A99999964A52941666666E6C5F45941000000007AA5294133333333B6F459416666666682A5294166666646A9F45941000000007BA52941CDCCCCAC99F45941666666666AA52941000000408BF45941333333338BA52941333333D373F4594100000000CAA529419A99991968F4594133333333DEA529413333339360F459410000000066A629416666660649F45941CDCCCCCCCEA62941CDCCCC6C33F4594133333333F3A62941CDCCCC4C27F45941333333334CA72941000000E012F45941666666667BA72941333333F309F4594100000000A9A72941CDCCCCEC03F45941000000002EA82941666666C6F6F359413333333368A829419A9999B9DDF359419A999999C7A829419A999959CDF359419A999999ECA82941CDCCCCECC5F359419A9999992DA92941CDCCCC0CBEF3594133333333ADA929419A999919B6F3594166666666EBA9294133333313B4F359416666666656AA29419A999939ABF359416666666673AA29410000002091F3594133333333A2AA2941CDCCCC8C84F3594100000000CDAA2941000000C074F35941CDCCCCCCE1AA29419A9999F965F3594100000000D3AA2941000000A05AF3594166666666A9AA2941666666E64AF359419A999999A1AA29416666668641F3594166666666A8AA2941666666E632F3594133333333C1AA2941666666C61EF3594100000000C2AA29416666666604F35941CDCCCCCCEBAA29419A999959EDF259413333333309AB2941666666C6ECF25941666666669AAB294133333373D6F259419A99999915AC2941CDCCCC8CD1F2594166666666D8AC294133333353CFF25941000000008DAD2941CDCCCC2CCAF259410000000078AE2941CDCCCC0CC1F259410000000043AE294100000040AAF259419A99999917AE2941333333139CF259419A999999D7AD2941CDCCCCCC8DF2594133333333DCAC2941000000208BF259419A999999B6AC29410000004087F25941CDCCCCCC89AC29419A99993979F259410000000044AC2941333333B369F259419A99999909AC29419A99993962F2594166666666B6AB2941333333934FF259419A9999995BAB29413333333343F259419A999999F6AA2941CDCCCCEC46F259410000000048AA2941CDCCCCAC48F2594166666666F0A929419A9999F947F25941CDCCCCCCADA92941666666A643F2594100000000A3A92941CDCCCCEC35F259413333333365A92941000000001DF259410000000064A929416666660609F259419A99999976A9294100000040F6F159419A999999C4A92941333333B3DAF1594133333333C4A9294133333373D4F15941CDCCCCCC71A9294166666606D3F159416666666613A92941000000C0C9F1594133333333BBA82941333333B3BFF159410000000044A829419A999919B4F15941000000001DA729419A999919A0F1594100000000ACA629413333333399F159419A99999960A62941CDCCCC0C93F1594133333333D5A52941333333937FF1594133333333B4A529416666662655F15941CDCCCCCC9FA52941CDCCCCEC4EF159419A999999CFA429410000002068F15941CDCCCCCC94A42941CDCCCC6C78F159416666666693A42941333333F39AF159419A99999987A42941CDCCCCCCA2F159413333333366A4294133333333A9F15941CDCCCCCC20A4294166666606B2F1594166666666DBA32941666666C6B3F159410000000044A32941666666C6B2F159413333333314A22941CDCCCC6CA5F1594166666666B4A1294133333333A6F159410000000075A1294133333353A8F15941000000003AA12941CDCCCC4CACF159419A999999B7A0294166666626B8F159416666666676A029419A999959BBF159419A99999931A02941CDCCCCCCBBF159419A999999B79F2941666666A6B7F15941CDCCCCCC629F2941000000E0B1F15941CDCCCCCC3C9F2941CDCCCC0CACF1594100000000039F2941CDCCCCECA5F15941CDCCCCCC909E2941666666C6A6F159419A9999995B9E2941000000E0A4F15941CDCCCCCC389E294166666686A8F15941CDCCCCCC8B9D294166666626A0F15941CDCCCCCC0F9D29416666662694F1594133333333879C2941666666E696F15941CDCCCCCC829B2941CDCCCC8CABF15941CDCCCCCC269B2941666666E6B4F159419A999999649A294100000040C3F159419A9999999F992941CDCCCC0CCEF1594166666666B098294100000060D8F159410000000084982941333333D3D8F159419A9999993498294166666606DCF1594166666666E5972941000000A0E2F15941CDCCCCCC7C97294133333333CBF1594166666666039729419A999959B7F1594166666666DB962941666666E6B4F15941333333337896294100000040C0F1594100000000CD942941CDCCCC6CE6F1594100000000FE93294166666626F3F15941CDCCCCCCF0922941CDCCCCECFAF1594100000000519229419A999959FCF15941CDCCCCCCF6912941333333B3F8F159419A999999819029419A9999D9E3F159419A999999099029419A999979E1F15941CDCCCCCCD38E294133333353E3F15941666666663C8E29419A999939E7F15941000000000B8E29419A999939EAF1594100000000828D294133333353ECF1594133333333978D294166666646E5F15941CDCCCCCC9C8D294100000080DBF1594100000000518D294133333333D0F159419A9999991B8D294133333313CAF15941CDCCCCCC058D2941333333D3C0F1594166666666558A2941CDCCCC8CD0F1594100000000108A294100000060D8F159419A9999998E89294100000000E0F15941CDCCCCCC80882941CDCCCC4CE0F15941333333333B882941000000A0E6F1594166666666C387294100000000E8F15941CDCCCCCCCA86294100000000FBF15941CDCCCCCC678629419A9999D908F25941CDCCCCCC368629410000006015F259419A999999EB852941333333733DF25941CDCCCCCCED852941CDCCCCEC5DF259419A999999DB852941CDCCCC6C79F2594133333333A78529416666668687F259419A999999CB842941333333D382F25941333333334D8429413333339379F25941000000000A842941CDCCCC0C73F2594133333333008329419A9999B95DF2594133333333D8822941000000C05DF2594166666666E0812941000000C07AF25941CDCCCCCC908129419A9999D97FF2594166666666188129419A9999B979F259419A99999995802941000000E06AF2594133333333318029419A9999B964F2594133333333697F29413333337362F2594100000000AB7E2941666666A65CF2594100000000BC7E294133333393C5F259419A999999D07E2941CDCCCC0CCDF25941333333335D7F2941000000E0D6F259419A9999995D7F294100000020DDF259419A999999077F2941333333B3F8F259419A999999277E2941000000204FF359419A999999F77D2941CDCCCCAC6AF3594100000000D67D29419A99991976F359419A999999BF7D29419A9999F975F3594166666666237D2941666666C67FF35941CDCCCCCC1C7D2941CDCCCCAC8AF35941000000006B7C294133333313B4F359419A999999547C2941666666A6BFF3594133333333037C294100000060D5F3594166666666657B2941666666C6F4F35941CDCCCCCC5C7B2941666666060AF45941666666661D7B29413333335319F45941000000006E7A29416666660629F4594133333333CB7929413333331335F459419A999999757929413333331340F4594100000000E0782941CDCCCCAC5DF4594100000000787829419A9999796EF459419A99999961772941CDCCCC4C91F459413333333345772941CDCCCC8C98F459413333333345772941CDCCCC8C98F45941	01010000206A080000CCA232781C9129419A9999991AF45941	520470000	Z	Beurville	5204700	52047	52	44	23
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	01010000206A080000B2026124DB852A410000007096DE5941	520500000	Z	Biesles	5205000	52050	52	44	24
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	01010000206A080000F271DF6DFC602B41CDCCCC1CEBC15941	520510000	Z	Bize	5205100	52051	52	44	2
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	01010000206A0800000014AAE5F9E9294134333393B6E45941	520530000	Z	Blaisy	5205300	52053	52	44	6
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	01010000206A0800000854A1F16F0D2A416666669660FB5941	520550000	Z	Blécourt	5205500	52055	52	44	7
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	01010000206A08000058DA2C4ECCEF2941CDCCCC3C16D85941	520560000	Z	Blessonville	5205600	52056	52	44	10
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	01010000206A080000B26F581BDF8E29419A9999E933F85941	520570000	Z	Blumeray	5205700	52057	52	44	15
01060000206A08000001000000010300000001000000460300000000000057122A419A99997997E559419A9999995B122A41CDCCCCCC9CE559413333333361122A41666666C6A1E55941666666666A122A41CDCCCC4CA6E559410000000077122A41333333F3A9E559416666666681122A4166666606AEE559410000000085122A4100000040B0E55941CDCCCCCC84122A4133333313B4E559416666666683122A419A999919B7E55941000000007F122A4133333373B9E559419A9999997B122A41CDCCCC0CBDE559419A99999978122A4133333313C0E559413333333378122A4166666666C3E55941CDCCCCCC93132A4100000040D3E559419A9999997B142A419A9999B9EFE559419A99999926152A41666666C6FFE559413333333363152A419A9999B909E659419A999999B5152A419A9999D92DE65941000000006A162A416666662635E659416666666688162A41000000203AE659419A99999928172A41333333F33EE659410000000033172A41CDCCCC2C45E659413333333365172A41000000E048E659419A999999AB172A41CDCCCC4C50E659419A999999F1172A419A99997951E6594166666666A9192A410000000051E659419A999999A1192A419A9999B972E659419A999999B6192A41333333B381E6594100000000B11A2A41CDCCCCAC87E6594133333333291B2A41CDCCCC8C8CE65941666666669F1B2A41666666868CE65941CDCCCCCCB21B2A41000000408DE659419A999999C11B2A41000000608DE65941CDCCCCCCD11B2A41666666468DE6594166666666E21B2A41000000E08CE6594100000000F11B2A41000000008CE65941CDCCCCCCFC1B2A41000000C08AE65941CDCCCCCC0D1C2A41CDCCCC8C89E6594100000000191C2A419A99991989E65941666666664F1C2A4133333313BBE6594166666666541C2A4166666606BBE659419A999999711C2A419A999979BAE6594133333333A01C2A41CDCCCCECB8E6594166666666B11C2A41CDCCCC0CB8E6594100000000CA1C2A4133333353B7E6594133333333E81C2A41CDCCCC8CB6E6594100000000031D2A41000000C0B5E6594166666666141D2A41CDCCCC8CB5E6594166666666201D2A419A9999F9B5E6594133333333291D2A419A999959B7E65941CDCCCCCC351D2A4133333393B9E659419A9999994E1D2A41000000A0BDE659419A999999691D2A41CDCCCC8CC1E6594166666666871D2A4166666606C6E659419A9999999F1D2A41CDCCCCECC9E659419A999999B31D2A41CDCCCC0CCDE65941CDCCCCCCC71D2A41CDCCCCCCCFE6594166666666DD1D2A41666666E6D1E65941CDCCCCCCEF1D2A4166666666D3E65941CDCCCCCC041E2A4100000040D5E6594100000000171E2A4133333393D6E65941000000002B1E2A41CDCCCC4CD7E65941CDCCCCCC3F1E2A419A999959D7E65941CDCCCCCC551E2A419A9999F9D6E6594166666666A91E2A41666666C6F0E6594100000000041F2A41CDCCCC6CF9E6594133333333901F2A4100000000FDE6594166666666AF1F2A419A9999B90FE75941000000001F202A413333339328E759416666666652202A41000000803CE75941333333334A202A41000000C056E759419A999999E81F2A41333333D379E75941CDCCCCCCBE1F2A410000002087E7594100000000E91F2A419A9999798AE759416666666628202A41333333538FE759416666666667202A419A9999F993E7594133333333A7202A41666666C698E7594166666666F0202A419A9999599DE759419A9999993A212A4100000020A2E759413333333378212A41666666E6A5E7594133333333BA212A4133333313AAE75941CDCCCCCCFB212A419A9999D9ADE759419A99999935222A419A999959B0E759419A99999984222A4166666626B3E75941333333339A222A4133333373B3E7594133333333B2222A419A999979B3E7594133333333C6222A4166666626B3E759413333333334232A41666666E6B4E75941CDCCCCCC66232A41333333D3BEE75941666666667C232A41CDCCCCCCD7E75941333333332A252A4133333353D7E759410000000011292A4166666646D1E75941CDCCCCCC282A2A419A9999F9D0E7594133333333932B2A4133333333E9E7594100000000D22B2A4166666626DDE75941CDCCCCCCF22B2A419A999919D8E7594100000000062C2A41000000E0D4E75941CDCCCCCC112C2A4166666686D2E7594133333333182C2A41CDCCCC6CD0E75941666666661D2C2A4133333373CFE759419A999999312C2A4133333393CCE7594133333333472C2A41666666C6C8E759419A9999995C2C2A4133333333C4E7594100000000722C2A419A999979BEE75941CDCCCCCC832C2A41CDCCCC2CBAE759419A9999999A2C2A419A999919B7E759419A999999C12C2A4100000060B1E75941CDCCCCCCCE2C2A419A9999B9B4E759419A999999D42C2A41CDCCCC6CB5E75941CDCCCCCCE52C2A41CDCCCCCCB6E759419A999999F92C2A41333333D3B7E7594133333333052D2A4133333333B8E759419A999999102D2A4100000060B8E75941666666661D2D2A4133333353B8E75941CDCCCCCC282D2A419A999979B8E7594166666666322D2A419A999919B9E75941000000003A2D2A419A999919BAE759419A9999993D2D2A41333333B3BBE7594166666666432D2A41666666A6BEE7594133333333492D2A4100000000C0E75941CDCCCCCC4D2D2A41333333F3C0E75941CDCCCCCC442D2A4100000060C3E75941CDCCCCCC432D2A4166666606C4E759419A999999472D2A41000000E0C4E75941CDCCCCCC512D2A41CDCCCC8CC5E7594100000000602D2A4133333353C6E759419A999999662D2A4100000040C7E7594100000000692D2A419A999939C8E7594166666666692D2A41000000A0C9E75941CDCCCCCC742D2A41CDCCCC0CCCE75941666666668A2D2A4100000080D0E759419A999999942D2A41CDCCCC0CD2E759419A999999A42D2A4100000080D4E759419A999999C62D2A41666666E6D8E759419A999999012E2A4166666626E1E7594100000000352E2A4166666646E8E7594166666666552E2A41CDCCCC6CEBE75941333333336D2E2A419A9999F9ECE7594100000000792E2A419A999999EDE7594133333333842E2A4133333393EEE75941666666668A2E2A41CDCCCC8CEFE7594100000000882E2A41CDCCCC6CF0E75941333333336E2E2A4133333313F2E75941CDCCCCCC422E2A41000000A0F4E75941666666661A2E2A41CDCCCC2CF7E7594133333333082E2A4133333353F8E7594166666666E72D2A4133333353FBE759419A999999E02D2A41CDCCCC2CFCE7594166666666DE2D2A41CDCCCC8CFDE7594100000000D62D2A4100000020FDE7594133333333CB2D2A419A9999F9FCE7594166666666C32D2A419A999919FDE7594166666666BA2D2A419A999999FDE7594166666666962D2A410000008000E8594133333333702D2A416666668603E85941000000002B2D2A416666660609E85941666666660D2D2A41000000200BE8594133333333032D2A41000000C00BE8594133333333252D2A419A99999918E85941666666661C2D2A419A9999192AE8594133333333032E2A419A99995936E8594100000000B22E2A41000000A03AE8594100000000B02E2A41666666463CE8594100000000C42E2A41CDCCCC6C3EE8594100000000D62E2A419A9999793FE8594166666666052F2A41CDCCCCAC40E85941CDCCCCCC472F2A413333337342E859419A999999802F2A413333331344E8594166666666B52F2A410000008045E8594133333333DD2F2A419A9999B946E859416666666608302A41CDCCCC0C48E85941666666662C302A410000004049E85941CDCCCCCC57302A419A9999D94AE85941000000006D302A41666666E64BE85941CDCCCCCC7A302A419A9999394DE859419A999999B1302A416666662654E8594133333333CC302A41666666E657E85941CDCCCCCCDB302A41333333335AE8594133333333F7302A419A9999B95EE85941CDCCCCCC0E312A416666668662E85941CDCCCCCC21312A41CDCCCCCC64E859416666666633312A410000008067E859416666666667312A419A9999596FE8594133333333C1312A419A9999397CE85941CDCCCCCC0D322A419A99997987E859413333333344322A41333333338FE859419A99999952322A41CDCCCCCC91E85941000000004E322A419A9999F991E8594133333333F8312A410000006095E85941333333338B312A419A9999F999E85941666666664F312A41333333939CE85941CDCCCCCC2E312A419A9999399EE859419A99999917312A41666666A69FE8594133333333B4302A4100000080C1E85941CDCCCCCC64302A4133333353CAE85941000000004E2F2A4100000060D8E859419A999999082F2A41333333F3DFE8594133333333B02E2A4166666646F5E8594166666666C42E2A4100000040FAE8594133333333472F2A419A9999D907E95941CDCCCCCC8D2F2A416666668610E95941CDCCCCCCB52F2A419A99997910E959419A999999D32F2A41333333B30CE959419A99999905302A41666666260FE959416666666660302A41CDCCCC4C1AE959419A99999939302A41333333932AE959419A99999939302A41333333132DE959410000000094302A419A9999F931E95941CDCCCCCC70312A419A9999B940E959410000000037312A410000004061E95941333333332E312A410000004070E959419A999999F3302A41CDCCCC8C85E959419A99999908312A416666664693E959419A99999976312A416666666694E9594133333333C4312A419A9999D973E95941CDCCCCCC33322A41666666C676E959410000000051322A41666666E677E959419A9999995A322A416666666678E959410000000067322A419A99995979E959416666666670322A41000000807AE959419A99999975322A41000000A07BE95941CDCCCCCC7D322A41333333D37DE959419A99999980322A410000004080E959419A99999981322A419A99997988E95941CDCCCCCC80322A41000000808AE95941000000008A322A41333333D38EE95941000000008E322A41000000A092E959419A9999998E322A416666662695E95941333333338B322A413333339397E959419A99999982322A419A9999F999E959419A99999973322A41000000409EE959410000000063322A41000000C0A2E95941CDCCCCCC56322A4166666626A6E959419A9999994C322A41CDCCCC8CA9E959413333333348322A41CDCCCCECABE95941CDCCCCCC45322A41333333F3ADE959419A99999948322A41666666A6AFE95941CDCCCCCC51322A41CDCCCCACB1E95941CDCCCCCC5C322A4100000060B3E959410000000068322A41666666E6B4E95941CDCCCCCC73322A4100000000B6E959410000000087322A41333333F3B6E959419A99999999322A4133333353B7E95941CDCCCCCCB0322A419A999999B7E959419A999999C8322A4133333393B7E9594133333333DC322A4133333333B7E9594166666666F4322A41666666A6B6E95941CDCCCCCC05332A4166666686B6E959410000000017332A41CDCCCC8CB6E959410000000029332A41CDCCCC2CB7E959410000000036332A4100000060B8E959413333333343332A4166666666B9E959419A99999956332A41666666E6B9E95941666666666B332A4133333393BAE95941333333337F332A419A999999BBE95941CDCCCCCC8F332A419A9999F9BCE959419A999999A0332A41666666C6BEE9594100000000BC332A4133333313C1E9594166666666C9332A419A999979C2E95941CDCCCCCCD6332A41000000E0C3E9594133333333DF332A4100000040C5E9594133333333EA332A4166666626C7E9594100000000EE332A41CDCCCCCCC8E959419A999999ED332A419A999979CAE9594100000000E9332A4133333333CDE959419A999999DD332A41CDCCCCACD1E9594133333333D3332A4133333313D4E9594166666666C7332A4100000060D5E959419A999999B4332A419A999959D6E9594133333333A0332A4166666646D6E959419A99999983332A41CDCCCCCCD5E95941CDCCCCCC71332A4100000000D5E959416666666664332A4100000020D4E95941CDCCCCCC56332A41CDCCCC8CD2E95941000000004B332A41000000A0D1E95941333333333E332A41CDCCCC6CD1E95941CDCCCCCC26332A4166666686D1E959416666666619332A41CDCCCC2CD2E95941CDCCCCCC0A332A4133333333D3E9594166666666FB322A41000000C0D4E959419A999999EC322A41CDCCCC0CD7E959419A999999E3322A4133333373D9E959419A999999DC322A41666666C6DBE9594166666666D8322A41000000E0DDE9594166666666D6322A41333333D3DFE959419A999999D7322A4133333353E2E959419A999999DB322A4166666626E5E959419A999999E3322A419A9999B9E7E9594166666666F0322A41333333F3ECE95941CDCCCCCCF9322A4100000040F0E959419A99999901332A419A9999D9F2E959416666666607332A419A999999F4E959410000000015332A419A999979F6E95941666666661E332A4100000000F8E959419A99999928332A41CDCCCCECF9E959413333333330332A4133333393FBE959413333333336332A419A999959FDE959419A99999938332A4133333353FFE959419A99999936332A410000004001EA5941CDCCCCCC31332A41000000C002EA59419A9999992A332A41CDCCCC6C04EA59416666666622332A41000000A006EA5941666666661D332A410000004008EA59416666666617332A419A9999D909EA5941333333330D332A419A9999D90BEA59416666666604332A41666666460DEA594100000000E6322A413333337310EA594100000000D9322A419A9999B912EA594166666666C1322A41666666A615EA594166666666AA322A419A9999B918EA594133333333A3322A41000000001AEA5941CDCCCCCC99322A41666666C61BEA59419A99999994322A41000000A01DEA59413333333392322A413333337320EA59419A99999993322A41333333F322EA59410000000099322A41666666A625EA5941000000009C322A419A9999F927EA59416666666699322A41333333F329EA59413333333392322A41CDCCCCAC2CEA5941666666668C322A41666666662EEA59410000000077322A419A99995931EA5941333333336B322A41333333D332EA59413333333359322A416666668634EA5941000000004C322A419A9999B935EA59410000000039322A41CDCCCC8C36EA5941CDCCCCCC24322A413333335337EA5941CDCCCCCC14322A419A99999937EA59416666666603322A41CDCCCC4C37EA59419A999999F3312A41666666A636EA594166666666DE312A416666660636EA5941CDCCCCCCCB312A41333333B335EA594100000000B9312A413333337335EA59419A999999A7312A413333337335EA59416666666696312A41000000C035EA59419A9999997F312A419A9999B936EA5941333333336A312A41666666C637EA59419A9999995E312A410000006038EA5941000000004F312A41333333133AEA59419A99999947312A41CDCCCC2C3BEA59419A9999993D312A419A9999B93DEA59410000000037312A41000000603FEA5941333333332D312A416666660641EA59416666666620312A413333331343EA59419A99999913312A416666668644EA59410000000007312A41CDCCCCAC45EA59419A999999F3302A41333333F346EA594166666666E0302A419A99999947EA5941CDCCCCCCCF302A410000002048EA59419A999999BE302A41666666C648EA594166666666B3302A410000002049EA594100000000A3302A41CDCCCCEC49EA5941CDCCCCCC99302A419A9999F949EA5941000000008A302A41000000C049EA5941CDCCCCCC7F302A416666666649EA59410000000074302A413333335349EA59410000000065302A41CDCCCC6C49EA59416666666656302A41333333F349EA5941CDCCCCCC48302A41333333B34AEA59413333333337302A419A9999994BEA5941CDCCCCCC11302A41333333934DEA5941CDCCCCCCE32F2A419A9999F94FEA5941CDCCCCCCCE2F2A413333335351EA594166666666BD2F2A41333333D352EA59419A999999A52F2A416666664655EA5941666666669B2F2A419A9999B956EA594133333333862F2A41CDCCCCCC5AEA5941000000007D2F2A41333333D35DEA59419A999999742F2A41000000C061EA59419A9999996C2F2A416666662666EA594133333333672F2A41000000E06CEA594133333333622F2A41CDCCCCEC70EA594100000000602F2A413333335375EA59419A999999612F2A419A99993978EA594100000000662F2A41000000607AEA5941000000006F2F2A41CDCCCCAC7BEA5941666666667D2F2A41666666067DEA5941666666668C2F2A41000000607EEA594133333333A02F2A41CDCCCC4C80EA594133333333B52F2A410000000082EA594133333333C62F2A41CDCCCC4C83EA5941CDCCCCCCD22F2A41666666E684EA5941CDCCCCCCD92F2A41333333F386EA594166666666DE2F2A416666662689EA5941CDCCCCCC15302A41000000208CEA594166666666FC302A410000002097EA5941333333335B322A419A9999B9A5EA59419A9999996E342A41666666A6C0EA5941CDCCCCCCED342A41666666C699EA5941CDCCCCCC33352A413333337398EA59413333333356362A41666666E6A0EA59416666666651372A419A9999D9B5EA59419A9999998D372A41CDCCCC8CB9EA594133333333C9372A419A999939B3EA59410000000069382A41333333D3B1EA5941CDCCCCCC86382A4166666686B0EA594100000000E0382A41333333F3A3EA59416666666639392A419A9999999DEA594133333333A6392A41000000008CEA5941CDCCCCCCF5392A41CDCCCCEC86EA594133333333283A2A419A9999198DEA5941CDCCCCCC6E3A2A416666664698EA5941000000007A3A2A41000000C0A9EA594100000000A23A2A41333333B3A9EA59419A999999F13A2A41000000A0A4EA594166666666413B2A41CDCCCC4CA3EA59419A999999693B2A41000000C0A5EA5941CDCCCCCC0A3C2A4133333393B9EA5941CDCCCCCC963C2A41CDCCCCACBAEA594166666666053D2A41CDCCCC8CC4EA5941333333334B3D2A419A9999F9C1EA594100000000AF3D2A419A999999C0EA594166666666EB3D2A41CDCCCC8CC5EA594133333333773E2A4166666626C4EA594166666666033F2A41000000C0C7EA59419A999999DA402A419A9999F9DEEA5941333333331C422A419A999919FAEA5941CDCCCCCCAE432A41666666E622EB59410000000079442A41666666A645EB594133333333FB442A41000000E050EB5941CDCCCCCC00452A413333337352EB59419A9999990A452A419A99997954EB5941CDCCCCCC16452A410000002058EB59413333333324452A41333333B35AEB5941666666663B452A41333333335EEB5941666666664D452A41000000E060EB5941666666665B452A413333331363EB59410000000078452A410000006068EB59419A99999992452A41CDCCCC2C6CEB5941CDCCCCCCB2452A413333331371EB594133333333CC452A416666664675EB5941CDCCCCCCE6452A419A9999F978EB59419A99999934462A41666666A67EEB594166666666BD462A41CDCCCC4C94EB5941CDCCCCCCE8462A419A99999997EB5941CDCCCCCC09472A41666666A69AEB5941CDCCCCCC57472A41CDCCCC2CA4EB59410000000079472A41333333D3A8EB5941000000008B472A41666666C6ACEB59410000000098472A4133333313B1EB5941CDCCCCCC9D472A4166666626B4EB594166666666EB482A419A999959CBEB59410000000096492A41666666E6D3EB594166666666904A2A4100000060DCEB594166666666F24C2A419A999979E4EB5941CDCCCCCCB54E2A419A999979FAEB5941CDCCCCCC22512A41CDCCCC8C11EC59416666666673512A41333333F318EC5941CDCCCCCCA5512A41666666A621EC59419A999999B5522A41333333133EEC594100000000F4522A416666668644EC594166666666FD522A41333333B345EC59419A9999993A532A419A9999794DEC59413333333373532A413333337354EC59413333333399532A413333331359EC594100000000C5532A419A9999B95DEC594133333333F1532A416666662663EC5941CDCCCCCC10542A41CDCCCC8C68EC59416666666630542A41333333736CEC59413333333363542A413333335377EC5941333333337C542A41000000A079EC5941CDCCCCCCA1542A41333333F37BEC594133333333DA542A41000000007FEC59410000000006552A410000008080EC5941CDCCCCCC31552A416666660682EC59413333333357552A410000000082EC5941CDCCCCCC95552A41CDCCCCEC81EC594133333333BB552A41CDCCCCAC82EC59419A999999E2552A41333333B380EC59419A99999915562A416666662679EC59413333333335562A41CDCCCC2C74EC5941CDCCCCCC51562A419A9999996FEC5941000000006B562A41000000C06AEC5941CDCCCCCC70562A419A99997969EC5941666666668A562A416666660664EC594133333333A3562A41000000E05DEC594133333333B5562A419A99993958EC594100000000C4562A41333333B352EC5941CDCCCCCCD4562A41CDCCCCCC4CEC5941CDCCCCCCDE562A41CDCCCC2C49EC594100000000F3562A419A9999F941EC5941CDCCCCCC05572A41666666E63BEC59410000000017572A416666660636EC5941333333332F572A41CDCCCC8C2DEC5941CDCCCCCC47572A41333333D324EC59416666666673572A413333333315EC5941CDCCCCCC91572A419A9999790AEC594166666666B3572A4133333393FEEB594166666666BD572A419A999919FBEB5941CDCCCCCCC4572A419A999979F9EB594100000000CE572A41CDCCCC6CF8EB594100000000DC572A4166666666F7EB5941CDCCCCCC2A582A41000000E0F2EB59413333333377582A4166666626EEEB5941CDCCCCCCC3582A419A999939E8EB59416666666602592A41CDCCCCACE3EB59410000000074582A419A9999D9C0EB59410000000036582A41CDCCCCECA2EB59419A99999909582A416666660662EB59419A999999EA572A41CDCCCC0C53EB59416666666667572A419A9999393FEB5941CDCCCCCC0C572A413333335335EB5941666666668A562A419A9999392FEB59419A999999E9552A41666666A621EB5941666666663A552A416666664618EB594100000000B4522A419A999959EBEA594166666666C1512A4133333313D9EA5941CDCCCCCC84512A4166666666D0EA59413333333320512A4166666686C6EA5941CDCCCCCC01512A41CDCCCC4CC0EA5941CDCCCCCC60502A4100000080B1EA594133333333D44F2A41666666A6A7EA59419A9999995B4F2A41666666469BEA5941CDCCCCCCB94E2A419A9999F97FEA594100000000724E2A41333333D365EA594133333333354E2A416666666659EA594133333333FD4C2A410000000038EA5941CDCCCCCC424B2A410000000013EA59419A999999794A2A419A999939FFE9594100000000D9492A4100000020FEE959419A999999B2492A41333333F3F0E959413333333396492A4100000060E3E95941666666667E492A41000000C0DAE959416666666653492A41333333D3BFE95941CDCCCCCC16492A41666666A6B4E959419A999999E4482A41333333F3B0E95941000000009E482A41CDCCCC0CA7E95941CDCCCCCC73482A419A99999986E959416666666636482A41333333F373E95941333333332B482A413333337362E959419A9999993E482A413333337358E9594166666666AB482A419A99995949E9594133333333D3482A41CDCCCC8C45E9594100000000D3482A41CDCCCCCC41E95941CDCCCCCCE6482A416666668640E959419A9999998B492A41666666A6F6E8594133333333B9492A41666666A6B5E859419A999999DF492A41000000E09DE8594166666666E9492A410000002084E85941CDCCCCCCE2492A419A99999983E85941CDCCCCCCDD492A41CDCCCCAC82E85941CDCCCCCCDA492A410000004081E8594166666666D9492A41666666267FE8594166666666DA492A41333333937BE8594166666666DD492A41CDCCCCCC77E8594133333333DF492A410000004074E859419A999999E2492A419A9999D96FE8594133333333E3492A41000000206BE8594133333333E2492A416666662666E8594100000000E4492A41333333D35EE8594133333333024A2A416666666650E8594100000000834A2A410000000040E8594133333333AA4A2A419A9999B934E859419A999999B44A2A410000008029E85941333333339F4A2A416666666612E8594133333333BB4A2A41000000600AE8594100000000EE4A2A41333333B309E85941333333332A4B2A41000000E00AE85941CDCCCCCC504B2A41CDCCCCEC13E8594100000000A14B2A41666666E612E85941CDCCCCCC824C2A4166666666E2E75941CDCCCCCC0D4D2A41333333D3C9E759419A999999254D2A4100000080C4E7594100000000304D2A4166666646C3E759419A999999344D2A419A9999D9C2E75941666666663E4D2A41666666E6C1E75941CDCCCCCC454D2A41333333D3C0E759419A999999514D2A41666666A6BDE7594133333333594D2A419A999979BBE7594166666666634D2A419A999979B8E75941666666666F4D2A41000000E0B4E75941CDCCCCCC774D2A4166666666B2E7594166666666824D2A41000000E0B0E7594100000000904D2A41666666A6AFE75941666666669C4D2A4133333393AEE75941CDCCCCCCA84D2A419A9999F9ACE7594133333333B24D2A41333333B3A9E7594166666666B64D2A4166666686A5E759419A999999B74D2A419A9999D9A2E759419A999999B94D2A419A9999B9A0E7594100000000BD4D2A41000000A09EE75941CDCCCCCCCF4D2A41CDCCCC4C9AE7594100000000E14D2A41000000E097E7594133333333F84D2A41333333B395E75941000000000A4E2A41333333D393E7594166666666264E2A419A99999991E759419A9999993B4E2A413333331390E75941CDCCCCCC554E2A41666666268EE759419A9999996D4E2A41000000008DE75941CDCCCCCC804E2A41CDCCCC4C8CE7594100000000934E2A41666666468CE759419A999999A84E2A41666666268CE759419A999999CA4E2A41000000808CE7594100000000E34E2A419A9999398FE7594133333333F14E2A41000000E090E75941333333330A4F2A419A9999B993E759419A999999144F2A413333337395E75941666666661F4F2A416666660697E75941000000002F4F2A41000000A099E75941CDCCCCCC3E4F2A41666666869CE7594166666666494F2A41CDCCCCCC9EE759419A999999544F2A419A999959A3E75941CDCCCCCC584F2A4166666666A5E75941CDCCCCCC5E4F2A4133333353A9E75941CDCCCCCC5F4F2A41CDCCCC4CAAE75941CDCCCCCCB34F2A41CDCCCC2CABE759419A999999DD4F2A4100000020C4E75941CDCCCCCCFB4F2A419A999999C6E759419A999999A5502A4166666666C6E7594166666666E1502A419A999919C5E759419A999999FE502A4133333393B8E7594133333333E9502A419A999999A4E7594133333333CA502A416666666694E75941CDCCCCCCC8502A41CDCCCC6C80E75941CDCCCCCCEF502A41000000E073E759419A9999990F522A419A99995954E759419A999999A3522A41333333B338E75941CDCCCCCC06532A419A9999992EE759416666666692532A41333333B32AE759413333333382542A413333333329E75941CDCCCCCC03552A413333331324E75941000000008F552A41CDCCCCEC19E759419A999999A2552A416666662616E759419A999999CA552A419A9999D914E759419A99999960562A41333333F315E759419A999999BA562A419A99995918E759416666666664572A41CDCCCCEC16E75941CDCCCCCCDB572A41CDCCCC4C0FE75941CDCCCCCC2A582A419A99997901E759413333333334582A419A9999F9F9E6594133333333EE572A41CDCCCC8CF7E6594100000000FE562A41CDCCCC8CF1E65941333333337C562A4133333373F5E659410000000036562A41666666C6F1E6594100000000AA552A41CDCCCCACF0E6594100000000BB542A41CDCCCCECFAE65941333333335D532A41CDCCCC4CFBE65941666666662B532A419A999919FFE659419A999999EF522A416666666600E75941CDCCCCCCF6522A41CDCCCC2CD7E659419A99999927532A41000000E0C6E659419A9999999E532A4166666606B9E659413333333365542A4133333353A7E659419A99999996542A41666666869EE6594166666666A9542A41000000C08BE65941CDCCCCCC89542A41CDCCCC4C75E659413333333357542A41000000606BE6594166666666E8532A410000004060E659419A99999901532A41000000C052E65941666666664D522A41333333734BE659416666666699512A41666666664AE65941CDCCCCCC21512A41666666464EE65941333333331D4C2A419A99999990E6594133333333CD4B2A41333333F391E6594166666666894B2A419A9999598BE65941CDCCCCCC8B4B2A410000008089E65941000000008A4B2A416666668687E6594133333333864B2A416666668686E659419A9999997D4B2A419A9999F984E6594166666666634B2A416666660682E6594133333333414B2A41333333737DE65941000000001F4B2A413333339377E6594133333333024B2A41CDCCCC0C71E6594133333333D54A2A410000006069E6594133333333954A2A41333333335EE659419A9999996D4A2A41666666A656E6594166666666424A2A41666666A64FE6594166666666344A2A41CDCCCC6C4EE65941CDCCCCCC184A2A41CDCCCCAC4CE6594166666666FB492A41CDCCCC0C4BE659419A999999DC492A41333333D348E6594166666666C8492A419A99995946E65941CDCCCCCCB4492A41666666C642E65941CDCCCCCC87492A41CDCCCC0C39E659410000000056492A41666666062EE659416666666628492A413333339322E659419A99999916492A41666666C61DE6594100000000F2482A410000000013E659419A999999DF482A419A9999590EE6594100000000D3482A41000000800CE659419A9999994B482A419A99997918E65941333333335B462A419A99997948E6594100000000BC452A41666666E653E6594166666666B8442A41CDCCCCEC57E659410000000049442A41666666264AE659416666666648442A41CDCCCC6C4AE659413333333336442A419A99995951E65941CDCCCCCC21442A41000000205AE659416666666618442A41CDCCCCEC60E659419A99999912442A41CDCCCCCC67E659416666666618442A416666666672E65941333333331C442A41666666E674E65941CDCCCCCCA2432A413333337377E659410000000086432A419A9999B987E65941000000005E432A410000000089E65941CDCCCCCC35432A41CDCCCC4C85E65941CDCCCCCC12422A41000000E072E659410000000077402A419A99995955E6594133333333D63E2A41CDCCCC4C34E659419A999999AF3E2A416666664630E65941666666668F3E2A41333333D32CE659419A999999713E2A41CDCCCCCC29E659419A999999503E2A413333337326E659419A999999123E2A41666666C62CE65941CDCCCCCCA53D2A41000000E03BE65941CDCCCCCC7D3D2A41CDCCCCEC3BE659419A999999EA3C2A41CDCCCC4C2FE6594133333333D33C2A419A9999392FE659419A999999BE3C2A41000000E02DE659419A9999998C3C2A41CDCCCCCC29E6594166666666383C2A416666660624E659419A999999D53B2A41000000801CE659419A999999783B2A419A99995915E659419A9999991F3B2A41CDCCCC0C0FE6594100000000D03A2A41333333F308E6594133333333603A2A413333339300E6594100000000F2392A4133333373F8E5594100000000B9392A41333333D3F3E55941CDCCCCCCAB392A41CDCCCCCCF2E55941CDCCCCCCA2392A419A999979F2E559416666666694392A4133333373F2E559410000000085392A4133333313F3E559419A99999965392A419A999959F5E559413333333305392A410000008013E659416666666630382A41666666260BE659413333333367382A41CDCCCC4C00E65941CDCCCCCC63382A4166666626D8E559410000000073382A41CDCCCCEC90E55941333333333F382A41000000C076E55941CDCCCCCC1C382A416666664670E559416666666642372A41333333D367E55941666666661B372A41000000005CE55941CDCCCCCC03372A410000000054E5594100000000EE362A41333333B34DE5594100000000E4362A41000000004BE55941CDCCCCCCD2362A41333333D347E5594166666666AC362A41666666A641E55941333333338F362A41666666A63CE55941000000007C362A41333333B33AE559419A9999995E362A413333339338E55941000000004A362A41CDCCCC0C37E559413333333337362A41CDCCCC2C35E55941333333330C362A410000006030E5594166666666DB352A41333333B329E5594166666666B2352A41000000C024E559419A99999992352A41CDCCCC0C21E559416666666688352A419A99991920E559413333333381352A41333333B31FE55941000000007A352A41000000A01FE559416666666672352A419A9999991FE5594100000000A3342A4133333393DEE459410000000067342A419A999999E1E459419A9999991F342A4133333373E5E459413333333376332A41CDCCCC2CCBE459419A9999997D312A41000000809EE459419A999999B2302A41000000A091E4594100000000AF302A41CDCCCC4C92E45941CDCCCCCC66302A41666666268DE459416666666608302A41666666C686E45941CDCCCCCCA92F2A419A99995980E45941CDCCCCCC962F2A41000000C07EE4594133333333922F2A41000000C07DE4594100000000612F2A41333333337BE45941000000005A2F2A41333333337CE45941666666661C2F2A41CDCCCC2C83E4594133333333CB2E2A419A9999198BE4594100000000AF2E2A41CDCCCCCC8DE459419A999999742E2A413333337393E459419A999999562E2A410000006096E4594166666666D52D2A4166666686A2E4594100000000922D2A4100000040A9E459419A999999582D2A4100000020A8E4594133333333512D2A419A999959A3E459419A999999332D2A416666668696E4594166666666142D2A419A99991986E4594166666666E52C2A419A9999D970E4594133333333BD2C2A41333333735FE45941000000009F2C2A416666668651E45941333333337F2C2A41333333B343E45941CDCCCCCC502C2A410000002031E4594100000000272C2A41CDCCCCCC20E4594133333333FA2B2A41CDCCCC0C0EE45941CDCCCCCCE02B2A41CDCCCC4C03E45941CDCCCCCCDE2B2A41CDCCCC6C02E4594166666666D52B2A410000002003E45941000000007A2B2A41CDCCCCCC09E4594133333333282B2A410000004010E4594133333333C52A2A41CDCCCCCC17E4594133333333662A2A41333333731FE459419A999999F7292A41000000E027E45941333333339A292A41666666462FE459410000000035292A410000000037E4594133333333B5282A410000000041E45941CDCCCCCC42282A41333333F349E45941CDCCCCCCD2272A410000008052E459413333333371272A41CDCCCC2C5AE4594100000000F2262A410000000064E45941CDCCCCCC47262A41CDCCCC4C71E459413333333367252A41CDCCCCEC39E459410000000079232A41000000E057E459416666666695212A41000000A075E459419A999999DD1F2A413333335390E4594166666666D51F2A410000002089E45941CDCCCCCCBF1F2A413333337380E459419A999999911F2A413333333372E45941CDCCCCCCED1D2A41000000E08DE45941CDCCCCCC5D1C2A4166666686A8E45941333333335D1C2A4166666686BBE4594166666666C71B2A41CDCCCC2CBEE4594166666666B31B2A41333333F3BCE4594100000000A81B2A419A9999F9A8E45941CDCCCCCC9D1B2A4100000040A5E45941CDCCCCCCC11A2A419A999939A4E459419A999999D51A2A41CDCCCC0CA9E45941CDCCCCCCFE1A2A4166666626B3E45941CDCCCCCC091B2A4100000020C2E459419A999999F61A2A41666666A6CEE4594100000000B21A2A4133333373E1E459419A999999441A2A4133333353EAE4594133333333C3192A41333333B3F0E459419A9999996F182A41CDCCCC4CF2E459416666666601182A41CDCCCCECEFE4594100000000CB162A4166666646E6E4594133333333BD152A41CDCCCC8CE6E459419A9999996D152A4166666666EAE45941333333333C152A4133333373F4E45941333333330C152A419A99993911E5594166666666CC152A410000008031E55941CDCCCCCCB8152A410000000039E559413333333391152A41CDCCCC4C3FE559419A999999F1142A419A9999F941E559419A99999984142A41333333934EE559419A99999935142A41666666A65DE5594166666666F9132A419A9999395BE55941333333339F132A413333335356E55941666666668B132A413333339357E55941666666663C132A41666666E667E5594133333333EE122A419A9999F980E559410000000057122A419A99997997E55941	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	01010000206A080000A085E9C9E63C2A413333334343E85941	520580000	Z	Bologne	5205800	52058	52	44	31
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	01010000206A0800005FBE729895032B413333331340CE5941	520590000	Z	Bonnecourt	5205900	52059	52	44	11
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