SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep55;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep55 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep55','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep55','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep55','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep55"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800008AA004B23B002B41CDCCCC8CA10C5A41	550010000	Z	Abainville	5500100	55001	55	44	14
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	01010000206A08000094D750A6B90B2B41333333E332555A41	550020000	Z	Abaucourt-Hautecourt	5500200	55002	55	44	10
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	01060000206A08000001000000010300000001000000E00000003333333350FE294133333333B6665A416666666655FE2941000000E0BB665A4100000000CFFE29419A999979C6665A41666666667BFE294100000040D2665A416666666622FF2941333333B3E5665A419A99999980FF2941CDCCCC8CDE665A410000000097002A41CDCCCC6C06675A410000000051002A410000006010675A4166666666A4002A41333333331B675A419A999999C1002A416666668619675A41CDCCCCCC5D012A41666666862B675A419A999999AA002A41000000A04B675A41CDCCCCCC78012A416666666657675A410000000004022A410000002065675A41CDCCCCCCD7012A419A9999796F675A41CDCCCCCC3B052A419A999939AC675A413333333315052A41CDCCCCCCB9675A416666666616052A4100000060CB675A419A99999922052A41666666C6CF675A416666666613052A41CDCCCCACD5675A416666666625052A419A9999B9DE675A41000000002B052A4100000000E8675A4100000000F8042A4166666686F0675A4133333333DF042A419A999919FE675A4133333333AC042A41CDCCCC0C0A685A419A99999986042A41CDCCCC8C0E685A413333333374042A416666660615685A410000000038042A410000008016685A41333333330D042A41000000001A685A4100000000ED032A41666666E622685A4166666666C7032A41666666C626685A41CDCCCCCCAA032A41000000E02F685A4166666666A6032A41333333933A685A4133333333BB032A41333333333F685A4100000000BE032A41333333F34D685A4133333333A8032A413333337356685A41666666669F032A416666662665685A41666666661F042A410000000072685A419A99999942042A41CDCCCC6C78685A419A999999CC042A41CDCCCC2C97685A41666666661E052A4100000000A4685A419A9999998A052A419A999919AD685A41CDCCCCCCFE052A41333333D3BD685A410000000037062A41CDCCCC8CC9685A41000000005F062A419A999939D7685A41333333338D062A41CDCCCCACF0685A41CDCCCCCC61072A41CDCCCC6CEB685A419A999999A6082A41CDCCCCECE8685A41CDCCCCCC430A2A41CDCCCC0CDD685A41666666662C0A2A4166666666CE685A41CDCCCCCC250A2A41333333D3C1685A41333333333D0A2A41CDCCCC0CB5685A4166666666C60A2A419A9999999D685A419A999999E40A2A41CDCCCC6C95685A4100000000FA0A2A41CDCCCC8C86685A4100000000FE0A2A41CDCCCC4C6F685A4133333333060B2A413333337363685A419A9999992C0B2A410000006046685A4133333333740B2A41333333B325685A4100000000D70B2A41333333D3FC675A419A999999B80E2A41CDCCCCACFD675A41333333332A0F2A41CDCCCCAC05685A41CDCCCCCC3B102A413333331316685A41CDCCCCCCF9112A410000000029685A41666666666E122A41CDCCCCCC2C685A41666666667B122A416666662632685A419A999999C4122A413333331359685A41CDCCCCCCF2122A41666666C676685A41000000007B132A41666666466D685A41000000000A142A41333333D368685A41CDCCCCCC68142A41CDCCCC8C64685A4100000000D9142A41333333135E685A41000000006A152A41000000C053685A419A99999996152A419A9999394F685A413333333312162A419A9999D94A685A416666666614162A41CDCCCCEC32685A4133333333D3162A41666666C60F685A419A999999E3162A4133333393FC675A41CDCCCCCCFD162A419A999959F9675A4133333333D2172A41000000C0A5675A413333333372182A41CDCCCC4CAE675A41CDCCCCCCD1182A410000004094675A410000000050192A419A99999975675A4166666666D1192A41000000C07F675A41666666669D1A2A41CDCCCCAC65675A4100000000BA1A2A416666666667675A41CDCCCCCC051B2A419A9999F95A675A4133333333351B2A41333333334E675A419A999999571B2A419A9999593D675A4133333333641B2A41333333131F675A41333333335C1B2A419A9999991A675A4133333333BA1A2A41333333731D675A4100000000E21A2A41CDCCCCAC0D675A4100000000081B2A41666666E6F6665A41CDCCCCCCD51A2A41666666E6F2665A41CDCCCCCC6A1A2A41666666C6F4665A419A9999995A1A2A41CDCCCCACD5665A419A999999411A2A41CDCCCC8CD4665A4100000000611A2A41CDCCCCCCB0665A416666666695192A419A999959B3665A413333333390192A41666666A6A1665A419A999999E0192A419A9999599E665A4100000000FD192A41333333F392665A41CDCCCCCC071A2A419A99997981665A41666666660A1A2A41000000206A665A41CDCCCCCC54192A41666666C652665A4166666666CD182A41000000803F665A419A99999993182A41CDCCCC2C36665A413333333329182A41000000C02C665A4100000000B3172A41CDCCCC2C17665A416666666623172A41333333F3F9655A41CDCCCCCC00172A4133333393F1655A419A999999F9162A419A999979DA655A419A999999AB162A419A9999F9CE655A410000000096162A41666666E6C6655A41CDCCCCCC28162A41000000C0B8655A419A999999F1152A4166666606B5655A4133333333CF152A419A9999D9B0655A41CDCCCCCC68152A419A9999999D655A416666666605152A41CDCCCCCC90655A41666666669A142A416666668688655A419A99999960142A416666666681655A4133333333E5132A419A9999796C655A41CDCCCCCCA6132A416666666666655A41333333337C132A41666666A65E655A41CDCCCCCC4F132A410000000063655A4166666666D7122A41CDCCCCAC4B655A416666666696122A41CDCCCCEC3D655A419A9999994D122A419A9999992C655A413333333310122A41666666E605655A41CDCCCCCC05122A419A9999D9F6645A41CDCCCCCC1D122A41CDCCCCCCE7645A41CDCCCCCC40122A419A999979D9645A41CDCCCCCC21122A419A999959D8645A41333333339A122A4100000060B2645A413333333385122A41666666C6A3645A41000000005E122A41CDCCCCAC91645A4166666666FC112A413333335389645A41CDCCCCCC39112A41666666267F645A41CDCCCCCC44112A41666666866F645A4133333333FA102A41666666466C645A4166666666B4102A413333333370645A419A99999973102A419A9999796B645A419A9999991B102A41666666466C645A4166666666AA0F2A419A9999F969645A4133333333B10F2A410000000063645A4100000000470F2A419A9999595F645A419A999999B50E2A41333333B358645A419A9999992B0E2A413333333359645A4100000000D50D2A41333333B35C645A41CDCCCCCC9C0D2A41CDCCCC6C67645A4133333333490D2A41CDCCCC4C7D645A41333333332B0D2A41000000807C645A4166666666120C2A41000000C07D645A4100000000E60A2A41333333D381645A4133333333730A2A416666662686645A4100000000190A2A41CDCCCCAC8E645A4100000000110A2A41666666469E645A41333333333C0A2A4100000080BF645A419A9999999D0A2A4100000000F0645A4166666666C50A2A41CDCCCCCCFB645A4100000000140B2A41000000E005655A41CDCCCCCCAA0A2A41CDCCCC2C12655A41666666669F092A419A9999B935655A419A9999990A092A416666668647655A4133333333DA072A419A9999796D655A416666666610082A416666660672655A419A99999978082A416666664675655A410000000036082A41666666C68A655A4100000000A9072A4100000000B1655A4133333333E4072A419A999999B2655A41CDCCCCCCCA072A4100000020C3655A41CDCCCCCCF1072A41000000E0BD655A410000000017082A419A999959BF655A419A99999923082A419A9999F9C8655A410000000046082A419A9999F9C9655A41CDCCCCCC70082A41000000A0C6655A413333333371082A41CDCCCC0CC0655A416666666691082A41333333F3BD655A419A999999C4082A419A999959C0655A419A999999F1082A4100000000BF655A41CDCCCCCC3A092A41333333B3C7655A410000000043092A419A9999F9CB655A41CDCCCCCC65092A41666666E6CC655A4100000000D1092A4166666666CC655A4133333333EF092A4166666666D2655A41666666668E092A4100000000DC655A416666666655092A419A9999D9DB655A41333333330F092A41CDCCCCCCDE655A41CDCCCCCCCE082A419A999939E4655A41666666667B082A4133333333EE655A41CDCCCCCC04082A4100000040FA655A419A999999A7072A41CDCCCC2C00665A419A99999967072A410000000001665A4100000000DB062A419A99991905665A41CDCCCCCC77062A41CDCCCCCC0B665A413333333360052A416666666613665A4100000000E3042A419A99993918665A41CDCCCCCC7C042A419A9999F928665A41333333335F042A419A9999192F665A41666666660E042A41666666063B665A4100000000DE032A41CDCCCCEC3C665A4166666666B9032A419A99995943665A4133333333A3032A419A99999943665A410000000079032A41333333F348665A419A9999991C032A41666666C64D665A419A99999908032A416666662650665A419A999999E3022A41333333135B665A4166666666BF022A41000000E069665A41CDCCCCCCA6022A41CDCCCCAC6B665A416666666668022A419A99995976665A419A99999939022A413333337374665A419A99999912022A419A9999B976665A41CDCCCCCC7A012A41CDCCCC4C87665A416666666629012A41666666E68A665A41CDCCCCCCE0002A41666666A68F665A413333333352002A41000000C090665A416666666695FF29416666660698665A413333333348FF2941CDCCCC4C9A665A4133333333E6FE294166666686A1665A419A99999992FE294100000040A9665A41CDCCCCCC5DFE2941CDCCCCCCB0665A413333333350FE294133333333B6665A413333333350FE294133333333B6665A41	01010000206A080000C2BDB009300C2A41333333F3A3665A41	550040000	Z	Aincreville	5500400	55004	55	44	9
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	01010000206A080000D07B56FCC8382B419A9999F9210B5A41	550050000	Z	Amanty	5500500	55005	55	44	11
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	01010000206A0800002C6C0EA6F5D52A4166666606B3415A41	550070000	Z	Ambly-sur-Meuse	5500700	55007	55	44	6
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	01010000206A0800007EE0B09704392B41CCCCCC5CB55B5A41	550080000	Z	Amel-sur-l'Étang	5500800	55008	55	44	15
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	01010000206A0800003A448539D7B12A41666666F6FD455A41	550090000	Z	Ancemont	5500900	55009	55	44	13
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	01010000206A0800004ECAAC00DEED29410000001041175A41	550100000	Z	Ancerville	5501000	55010	55	44	21
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	01010000206A080000006BB8BC53BC294100000060B9265A41	550110000	Z	Andernay	5501100	55011	55	44	4
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	01010000206A08000087F2DFDB8A3A2B41343333A3102F5A41	550120000	Z	Apremont-la-Forêt	5501200	55012	55	44	33
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	01010000206A0800002367C78B573D2B41666666868B6C5A41	550130000	Z	Arrancy-sur-Crusnes	5501300	55013	55	44	20
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	01010000206A0800002811DA5F5F0D2A4166666696EC4F5A41	550140000	Z	Aubréville	5501400	55014	55	44	29
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	01010000206A08000093EED6BFC1212A41343333E328175A41	550150000	Z	Aulnois-en-Perthois	5501500	55015	55	44	11
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	01060000206A08000001000000010300000001000000E7000000CDCCCCCC9C0C2A413333333383425A419A999999D60C2A419A9999798B425A419A999999F20C2A413333335394425A4133333333340E2A419A9999F9A5425A41000000002C102A419A999959CC425A419A999999C7112A4100000040EC425A419A99999909132A419A99997906435A419A99999975132A41000000800D435A41CDCCCCCCBB142A41666666E620435A41CDCCCCCC93152A41CDCCCCAC2C435A410000000099162A419A9999D931435A41CDCCCCCCED162A416666660634435A41CDCCCCCC7A172A41CDCCCC2C3D435A41000000000C182A41333333734E435A4166666666A8182A413333339358435A41CDCCCCCC4D192A410000000061435A41333333330C1A2A41CDCCCCAC67435A419A9999998E1A2A41CDCCCCCC67435A4133333333F41A2A410000004069435A4100000000871B2A410000000065435A419A999999DA1B2A419A99995963435A4133333333231C2A416666660664435A419A9999992E1D2A419A9999D96A435A4133333333DC1D2A410000000072435A41000000009F1E2A419A99997976435A41333333330A1F2A41333333937A435A4166666666571F2A410000000083435A419A999999791F2A419A9999796C435A419A999999AA1F2A41CDCCCC4C48435A413333333384202A419A9999994C435A419A999999E6202A41333333934D435A4133333333EA202A419A9999393F435A4133333333CD202A41000000E035435A4133333333CA202A41CDCCCCCC29435A419A999999E9202A41333333F324435A4166666666B9212A41666666A614435A4100000000C2212A410000006012435A413333333300222A41000000A00F435A41000000009D222A41666666260D435A4133333333B0222A41333333530A435A41CDCCCCCC18232A41CDCCCC2C0A435A419A9999993B232A41333333F305435A419A999999A6232A419A9999B906435A41CDCCCCCCF2232A41000000A002435A413333333318242A419A9999D9FB425A410000000053242A41333333F3FB425A413333333314242A413333335318435A4133333333EF232A41333333B32B435A419A999999DC242A419A9999792E435A41333333330E252A41000000402D435A4100000000C4252A41CDCCCC2C2F435A4100000000A9262A419A9999D930435A413333333376272A416666666634435A41CDCCCCCCF8272A41CDCCCC2C35435A41CDCCCCCC7E2A2A416666662631435A419A999999FD2A2A41CDCCCCEC2F435A41CDCCCCCCFB2B2A41666666062B435A4133333333AD2C2A41CDCCCCEC29435A41CDCCCCCC4D2D2A41000000402A435A4133333333912D2A419A99991910435A419A999999052E2A4100000000DF425A410000000020302A4100000060F1425A416666666662322A416666668603435A4100000000AF352A41000000001B435A41333333332E362A41333333F31F435A410000000010372A41333333932C435A419A999999DF382A41CDCCCCEC47435A41000000005E392A41000000A050435A41333333333A392A41CDCCCC8C62435A419A999999323A2A416666668669435A419A9999997D3B2A41333333F377435A4166666666423C2A419A99991980435A419A999999A63C2A41000000C054435A4166666666D93C2A419A99991956435A4100000000033D2A419A9999B949435A419A999999473D2A413333335325435A4166666666A93D2A416666662626435A4166666666B43D2A419A9999D920435A4100000000903D2A41CDCCCCACEA425A41333333338C3D2A41000000C0CF425A4166666666A03D2A4133333313C1425A419A999999FA3D2A41333333B39C425A4166666666513D2A41333333538E425A4133333333793C2A419A9999597F425A41333333330E3C2A413333331379425A41CDCCCCCC4F3B2A41000000C06C425A4133333333053B2A41CDCCCCEC68425A4100000000813B2A41000000C045425A419A999999723A2A41CDCCCC4C2F425A41000000001F392A41000000E022425A419A99999905392A41333333B325425A4166666666FD362A419A99991911425A41666666667C352A41333333F302425A419A99999915362A41333333D3E8415A4100000000E7352A41CDCCCC4CE5415A41CDCCCCCCD0352A41333333B3E9415A41000000006B352A4100000060DF415A41000000003C352A41CDCCCC0CEC415A413333333358342A41666666C6D3415A41CDCCCCCC15342A41333333F3E0415A416666666632332A416666668606425A4100000000FC302A4133333393F6415A4100000000AC2F2A410000002002425A4166666666352F2A416666668604425A41CDCCCCCC372E2A41333333F30B425A41CDCCCCCCE72D2A41000000C00D425A4133333333E02C2A410000000006425A4100000000202D2A4100000020E9415A41000000003E2B2A419A999919D8415A41CDCCCCCCB72B2A41CDCCCCAC96415A4100000000D52B2A413333337383415A41CDCCCCCC662A2A41CDCCCCCC84415A4133333333FB292A419A9999F986415A4166666666FF292A41666666C67F415A4133333333C6282A416666660680415A41CDCCCCCCB5282A41666666A673415A4100000000B7272A410000008078415A41CDCCCCCC94272A41666666C65F415A41CDCCCCCC49272A413333333360415A410000000042272A410000000057415A4166666666F4262A41000000C059415A4166666666AE262A41000000C052415A410000000012262A416666668657415A41333333338D252A41666666465C415A413333333357242A419A9999D95D415A4100000000C4232A41CDCCCC0C5F415A4133333333B1232A41000000E058415A419A99999985232A416666660654415A419A99999983232A419A99997949415A410000000061232A41CDCCCCCC43415A419A99999955232A41666666663E415A419A99999976232A419A9999793C415A4133333333C0232A419A99993940415A416666666631242A41000000E034415A419A99999949242A413333331330415A410000000048242A41CDCCCC8C25415A41333333335C242A41666666A620415A413333333388242A410000002020415A419A9999999F242A41333333B325415A4100000000A8242A41333333F32C415A4133333333DA242A410000006036415A41CDCCCCCC3B252A410000000036415A419A9999996D252A41CDCCCC4C33415A41333333339B252A41666666A62B415A41333333333F252A41000000000B415A41CDCCCCCC20252A4100000080F7405A41CDCCCCCCC9242A419A999999FA405A41666666664B242A4100000080D6405A416666666618232A41333333D399405A41333333337F212A419A99999998405A41CDCCCCCC0D212A41000000A099405A410000000003212A41CDCCCC2C95405A419A999999FF202A41CDCCCCEC87405A419A999999E6202A41333333537E405A4133333333CA202A41000000A06B405A4100000000C6202A41666666E650405A41CDCCCCCCA8202A41333333533B405A41CDCCCCCC64202A413333331337405A419A99999988202A41666666A62A405A41000000005D202A41CDCCCC8C19405A41333333334D202A41666666E60F405A4133333333BB1F2A419A9999590F405A4133333333C11F2A419A999919F73F5A4166666666D61D2A41CDCCCCCCCD3F5A4100000000D41C2A4133333373B43F5A4100000000641C2A4166666606B13F5A4100000000C01B2A41000000E0AE3F5A4166666666921B2A419A999979AF3F5A41333333334E1B2A419A999919BF3F5A4100000000DD1A2A4166666646D53F5A4100000000AC1A2A41CDCCCCACC83F5A4166666666721A2A4166666666C73F5A4100000000731A2A41666666A6C93F5A4100000000F1192A4133333373D33F5A410000000070192A4100000040DC3F5A41000000003A182A41CDCCCC6CEF3F5A410000000029182A419A999999F23F5A419A999999A3172A419A999919FE3F5A41CDCCCCCC10172A41333333F309405A419A999999D9162A419A9999190C405A41666666669B162A41666666C60B405A4133333333A9162A41000000400E405A41CDCCCCCCD8162A41666666A624405A41666666661E172A419A99995921405A41CDCCCCCC40172A41666666E62A405A416666666620172A41000000803E405A419A999999EC162A413333333350405A4133333333FB162A41CDCCCCEC5D405A41CDCCCCCC16172A41CDCCCCEC6A405A413333333327172A41666666867D405A41333333332B172A41333333738F405A41CDCCCCCC25172A41CDCCCC0CA6405A419A99999913172A41CDCCCC2CB8405A41CDCCCCCC12172A419A9999B9C2405A41CDCCCCCC00172A41000000E0C9405A41CDCCCCCC3C172A419A9999F9CC405A419A9999997A172A419A999919DB405A41000000005D172A4100000080E8405A419A99999901172A4100000000E3405A4133333333C9162A41666666A6F2405A413333333388162A4133333333FC405A41000000000F162A41666666E615415A4166666666D0152A41333333532A415A4133333333A0152A41000000203E415A410000000009152A41000000E038415A41CDCCCCCC0D152A419A9999595C415A413333333320152A41CDCCCC2C67415A4100000000F6142A41666666266E415A4133333333E4142A41333333137B415A419A99999916152A41333333D380415A413333333318152A416666664697415A41333333330A152A41CDCCCC0CA6415A410000000063152A4133333353D6415A410000000076152A41CDCCCCACEB415A419A99999913152A419A9999B9F7415A41CDCCCCCCCE142A419A9999191C425A41CDCCCCCC0C142A41666666C614425A41CDCCCCCCD4132A419A99999946425A410000000089132A419A99995947425A4166666666E3122A416666668647425A4100000000D2112A416666662646425A41666666665A112A41CDCCCCEC4C425A419A999999CD102A41CDCCCCAC58425A4133333333920F2A41333333736D425A4166666666430F2A419A99997965425A41666666662D0F2A41333333F36A425A4100000000A40E2A413333335367425A41666666664F0E2A41CDCCCC2C76425A419A999999F90D2A416666660675425A41CDCCCCCC9C0C2A413333333383425A41CDCCCCCC9C0C2A413333333383425A41	01010000206A0800005BF59F105D202A419A9999A99E415A41	550170000	Z	Autrécourt-sur-Aire	5501700	55017	55	44	11
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	01010000206A080000688CB7B839142A41666666B6F37B5A41	550180000	Z	Autréville-Saint-Lambert	5501800	55018	55	44	4
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	01010000206A080000A60470C7D2612B416666663693435A41	550210000	Z	Avillers-Sainte-Croix	5502100	55021	55	44	5
01060000206A08000001000000010300000001000000D20000006666666698962A41333333D3EB7C5A410000000055972A419A999959FE7C5A419A9999990F982A41CDCCCC4C147D5A419A9999998E982A41666666E6207D5A41CDCCCCCCC8982A41000000A0297D5A419A9999994A992A41666666863A7D5A419A9999996D992A41666666863E7D5A413333333393992A41000000E0437D5A41CDCCCCCC089A2A41CDCCCCCC527D5A4133333333F3992A41000000A0577D5A41CDCCCCCC289A2A41333333B35F7D5A4100000000429A2A41CDCCCC2C797D5A4100000000C39A2A41666666C6777D5A419A999999D39A2A41333333B3897D5A4166666666439B2A4133333393847D5A41CDCCCCCCD89B2A41666666467D7D5A419A999999119C2A419A9999797D7D5A41666666664E9C2A419A9999D97E7D5A41CDCCCCCCD49C2A41333333738C7D5A4100000000039D2A41CDCCCC4C857D5A419A999999BC9D2A41333333F3A27D5A4166666666059E2A4166666626A07D5A41CDCCCCCC149F2A419A999979917D5A419A999999329F2A4133333313977D5A41CDCCCCCC8C9F2A4166666686957D5A41CDCCCCCC889F2A41CDCCCC2CA07D5A4133333333C8A22A41666666A6A27D5A4166666666D0A22A419A999919AC7D5A413333333323A62A41333333B3A87D5A4133333333AEA62A41666666E6B27D5A413333333359A72A41666666C6C07D5A413333333383A72A419A999939C97D5A419A99999944A82A4133333313CD7D5A41CDCCCCCCF0A92A41333333D3DB7D5A4166666666CAA92A41666666E6ED7D5A4100000000F1A92A4100000040FD7D5A41666666662DAA2A41666666860B7E5A413333333397AA2A4166666626057E5A416666666692AA2A41000000800D7E5A413333333392AA2A419A9999F90D7E5A410000000092AA2A41CDCCCC0C127E5A41333333338CAA2A41CDCCCC0C147E5A416666666676AA2A4166666646177E5A41CDCCCCCC6DAA2A41CDCCCCAC187E5A413333333392AA2A41000000C01C7E5A4133333333C4AA2A41CDCCCC8C277E5A410000000026AB2A41CDCCCCCC357E5A419A99999990AB2A41333333D33F7E5A4100000000CFAB2A419A999939477E5A41CDCCCCCC05AC2A41333333534E7E5A410000000025AC2A419A9999D9517E5A41CDCCCCCC4BAC2A419A9999B9547E5A419A9999998CAC2A41CDCCCCEC577E5A41333333338BAF2A41CDCCCC2C777E5A419A99999911B02A41666666A6667E5A4133333333F3AF2A4166666646617E5A413333333376AF2A41333333F34A7E5A416666666649AF2A4100000060427E5A41CDCCCCCC29AF2A419A999999377E5A416666666619AF2A41333333D32D7E5A41000000000FAF2A419A9999591F7E5A419A999999FEAE2A41333333B30F7E5A4100000000E1AE2A41666666C6FB7D5A4100000000C7AE2A41666666C6E97D5A41CDCCCCCCB9AE2A41333333D3E47D5A41000000009BAE2A41333333F3DD7D5A41CDCCCCCCC3AF2A419A9999999F7D5A41CDCCCCCCFEAF2A41000000E0A37D5A410000000034B02A4100000080987D5A410000000061B02A41CDCCCCCC8E7D5A413333333389B02A419A9999B9867D5A41333333338DB02A41666666C6857D5A41000000004EAF2A4166666666797D5A41000000008AAF2A4100000060607D5A4100000000B3AF2A419A9999D9587D5A41333333337CAF2A41666666064E7D5A419A9999995AAF2A41CDCCCC8C427D5A410000000044AF2A41000000E02B7D5A41333333334AAF2A41CDCCCC4C1E7D5A413333333350AF2A419A9999B9107D5A413333333366AF2A4100000040FD7C5A410000000086AF2A41666666C6EE7C5A4166666666CEAF2A4100000020D47C5A4133333333CEAF2A41000000E0D27C5A416666666661AE2A41000000C0D27C5A41CDCCCCCC54AE2A4133333353C47C5A41CDCCCCCCB2AE2A4133333393C17C5A41666666661EAE2A419A9999F95F7C5A41000000005BAE2A41333333F35D7C5A410000000076AE2A41333333135D7C5A41666666668FAE2A41000000805C7C5A4166666666B5AE2A41666666065C7C5A4166666666E5AE2A41000000405C7C5A413333333302AF2A41333333B35C7C5A416666666629AF2A41CDCCCCCC5D7C5A41CDCCCCCC59AF2A41000000405F7C5A416666666698AF2A4133333333617C5A410000000083AF2A41666666A65C7C5A413333333340AF2A4100000020557C5A413333333318AF2A41000000A0517C5A4100000000E7AE2A4133333313507C5A419A999999C1AE2A41000000604F7C5A41CDCCCCCC94AE2A41333333134D7C5A413333333355AE2A4100000060487C5A416666666625AE2A4100000020497C5A41CDCCCCCC1FAE2A419A999959457C5A419A999999F0AD2A4100000060277C5A419A999999E0AD2A419A9999191F7C5A4100000000D3AD2A41CDCCCC8C1A7C5A4166666666BBAD2A419A999919147C5A4133333333A7AD2A41000000E0107C5A41CDCCCCCC3AAD2A4133333373067C5A4100000000D3AC2A4100000020067C5A41CDCCCCCCB5AC2A41000000E0067C5A416666666686AC2A4100000000FF7B5A419A999999D2AA2A41CDCCCCACCC7B5A416666666673AA2A41666666C6C87B5A4166666666FFA92A41333333F3C77B5A419A999999D3A92A4166666666C97B5A41CDCCCCCCB1A92A41CDCCCC4CC37B5A4100000000BEA92A41333333B3BC7B5A41CDCCCCCC29AA2A4100000040A97B5A41CDCCCCCC58AA2A41CDCCCCECA07B5A419A99999931AA2A419A9999199C7B5A419A999999A4A92A41000000008C7B5A419A9999990EA92A4133333313817B5A419A999999E7A82A4133333393827B5A419A999999A6A82A4166666646837B5A41666666666BA82A41CDCCCC4C827B5A410000000003A82A419A9999797F7B5A41CDCCCCCCCDA72A41333333337C7B5A416666666673A72A4100000060777B5A419A99999942A62A41666666E6617B5A41666666663DA62A41666666C6597B5A41CDCCCCCCAEA52A41333333534F7B5A413333333388A42A41666666A6427B5A41CDCCCCCC21A42A41333333333F7B5A410000000027A32A4133333313367B5A41333333337EA22A4133333353357B5A41000000007DA02A41CDCCCC2C257B5A41CDCCCCCCBE9F2A4166666646217B5A4100000000099F2A41CDCCCCCC1D7B5A4166666666DC9E2A419A9999992F7B5A4166666666DE9E2A41666666464C7B5A41CDCCCCCCF49E2A419A9999F95A7B5A4166666666E19E2A419A9999F9647B5A41CDCCCCCC749E2A419A9999D9877B5A41000000002F9E2A41CDCCCC8C9D7B5A419A999999259E2A419A9999B99A7B5A419A9999991B9E2A419A999979987B5A419A9999990C9E2A4133333333967B5A4133333333F29D2A41000000E0937B5A41000000005D9D2A4166666626AE7B5A419A999999EE9C2A41CDCCCCACA97B5A419A999999919C2A4166666666C87B5A4133333333F49B2A419A9999F9C37B5A4133333333989B2A4133333393E37B5A4133333333429B2A4166666626DF7B5A419A999999919A2A419A9999B9D47B5A41CDCCCCCC729A2A41CDCCCC0CD37B5A4133333333439A2A41000000A0E47B5A4100000000079A2A4166666646DF7B5A419A999999D0992A4133333333E77B5A413333333388992A41000000A0F67B5A416666666656992A41CDCCCC6C0D7C5A41333333331B992A419A999999227C5A41000000001B992A41000000E0287C5A419A9999991D992A41000000402D7C5A41CDCCCCCC14992A41333333932F7C5A41CDCCCCCCF5982A41333333D3307C5A4166666666F1982A4100000040327C5A4133333333EB982A41000000E0367C5A419A999999E5982A41000000E0387C5A419A999999CA982A41000000E03B7C5A4166666666BF982A41666666863D7C5A4166666666B8982A41333333B3427C5A4166666666B1982A41000000A0487C5A4133333333A8982A41666666C6527C5A41CDCCCCCC9F982A4100000060597C5A41CDCCCCCC93982A41000000005F7C5A410000000082982A41CDCCCC6C637C5A419A99999977982A41CDCCCC2C667C5A410000000077982A4166666626697C5A41CDCCCCCC81982A4133333333707C5A410000000081982A419A9999B9727C5A41666666665D982A41CDCCCC0C777C5A419A9999994B982A419A9999997A7C5A416666666640982A4133333333807C5A413333333337982A41333333B3867C5A419A99999925982A41666666C68C7C5A41000000000F982A41CDCCCC0C947C5A4166666666FD972A4166666606987C5A4100000000B1972A41666666E6A17C5A419A99999967972A41CDCCCC6CAC7C5A410000000048972A41666666A6B17C5A410000000037972A419A9999D9B37C5A410000000038972A41CDCCCCCCB77C5A41666666662E972A41CDCCCCCCB97C5A413333333327972A41CDCCCCACBB7C5A41333333331A972A41CDCCCC6CBF7C5A41CDCCCCCC10972A419A9999B9C57C5A4100000000FC962A41CDCCCC8CCA7C5A4166666666F7962A41000000A0D07C5A413333333307972A4166666606D37C5A41000000000E972A41000000C0D57C5A4100000000E4962A41CDCCCC2CDE7C5A4100000000AB962A41333333B3E87C5A419A999999A1962A419A999979E97C5A41CDCCCCCC9E962A4100000040EA7C5A416666666698962A41333333D3EB7C5A41	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	01010000206A080000B026DC43AFA22A4134333323C87C5A41	550220000	Z	Avioth	5502200	55022	55	44	6
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	01010000206A0800007A787CF550202A419A999979DD545A41	550230000	Z	Avocourt	5502300	55023	55	44	15
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	01010000206A080000DCA516F6D3D12A41000000609A5E5A41	550240000	Z	Azannes-et-Soumazannes	5502400	55024	55	44	18
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	01010000206A0800008C219DBFB3572A413333338396735A41	550250000	Z	Baâlon	5502500	55025	55	44	15
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	01010000206A080000FE05EC3041272B41666666660F0E5A41	550260000	Z	Badonvilliers-Gérauvilliers	5502600	55026	55	44	21
01060000206A08000001000000010300000001000000FE01000033333333A4D52A419A9999F9053A5A4133333333ACD52A41CDCCCC8C0B3A5A4166666666D2D52A4133333353143A5A413333333333D62A419A999959223A5A41666666664FD62A41CDCCCC2C253A5A419A9999996ED62A41333333B3273A5A419A999999D0D62A41666666462E3A5A410000000058D72A41000000A0373A5A4166666666FCD72A419A999919423A5A41CDCCCCCC47D82A4100000020463A5A41333333331DD92A4133333353453A5A41333333332CD92A419A999919453A5A413333333349D92A41CDCCCC8C443A5A410000000073D92A41000000C0433A5A419A999999BFD92A41333333B3423A5A4133333333F9D92A41000000E0413A5A413333333321DA2A4100000020413A5A419A99999949DA2A41333333F33F3A5A41CDCCCCCC62DA2A419A9999B93E3A5A416666666699DA2A41CDCCCC2C3B3A5A4100000000DBDA2A419A999919373A5A41666666660EDB2A4166666626343A5A419A99999947DB2A41666666A6303A5A416666666684DB2A41000000002E3A5A419A999999C0DB2A41CDCCCCCC2B3A5A41CDCCCCCCF7DB2A41333333332A3A5A41CDCCCCCC2DDC2A4133333393283A5A413333333366DC2A41666666C6263A5A419A9999996FDC2A4166666686233A5A419A99999972DC2A4166666646213A5A41000000007ADC2A41333333131B3A5A410000000082DC2A4100000000163A5A416666666684DC2A41CDCCCC6C143A5A41CDCCCCCC8BDC2A41CDCCCCEC0F3A5A413333333392DC2A41000000200C3A5A4133333333A3DC2A41000000A0053A5A4166666666BDDC2A4133333373FD395A41CDCCCCCCCDDC2A4166666646F8395A4166666666D5DC2A419A999919F5395A4100000000D9DC2A41000000E0F3395A419A999999E6DC2A41CDCCCCACEF395A4133333333F3DC2A419A999939EC395A4166666666FFDC2A4166666606E8395A410000000013DD2A41666666E6E0395A419A99999929DD2A41333333F3D9395A419A9999993CDD2A4100000000D4395A41666666664DDD2A419A999999CE395A4133333333D9E02A41CDCCCC4C273A5A41333333331EE22A41CDCCCCEC3F3A5A4166666666EEE22A41000000E04C3A5A416666666691E22A419A999959653A5A41CDCCCCCC45E32A41666666266F3A5A4100000000AAE32A41CDCCCCCC723A5A4133333333AAE32A41CDCCCC0C743A5A416666666647E32A41666666A6853A5A41000000009AE32A41CDCCCC2C8A3A5A41CDCCCCCC83E32A419A9999998E3A5A4100000000CCE32A41000000C0903A5A419A999999C2E32A4100000040983A5A419A99999966E42A41666666E6A03A5A41000000003CE42A419A999959AD3A5A416666666614E42A41666666A6B33A5A41CDCCCCCCE3E32A4166666626C13A5A41CDCCCCCC60E52A4100000080D53A5A4100000000ACE52A4100000020E73A5A41333333334DE62A41000000C00E3B5A41000000005EE62A419A999919123B5A419A99999997E62A419A9999991E3B5A41CDCCCCCCDEE62A41333333F32A3B5A419A9999991AE72A41666666C6343B5A41CDCCCCCC1AE72A41000000C0353B5A41CDCCCCCC2AE72A419A999979373B5A419A99999951E72A41000000E03D3B5A416666666692E72A419A999939493B5A41CDCCCCCCD6E72A4133333333543B5A41CDCCCCCC0BE82A41666666A65C3B5A419A9999995CE82A419A999919693B5A4100000000A7E82A4166666686743B5A4100000000EFE82A41666666E67E3B5A41CDCCCCCC35E92A41000000E0883B5A41CDCCCCCC63E92A4133333333963B5A41666666666EE92A41333333139E3B5A41CDCCCCCC38EA2A419A999939C43B5A419A99999965EA2A41666666A6C03B5A41333333330EEB2A41CDCCCC8CE33B5A419A999999B6EB2A41CDCCCC0C083C5A4133333333FCEB2A41CDCCCCCC013C5A41CDCCCCCC83ED2A41CDCCCC0C573C5A419A99999966ED2A4133333353623C5A413333333386ED2A4166666686653C5A419A999999CAED2A419A999939623C5A413333333330EE2A419A9999597C3C5A41CDCCCCCC44EE2A41333333D3833C5A416666666670EE2A419A9999F98F3C5A419A999999AEEE2A41666666868D3C5A41CDCCCCCCF6EE2A41000000208A3C5A41CDCCCCCC3EEF2A4166666606873C5A41666666666EEF2A4100000020853C5A413333333388EF2A419A999939833C5A4100000000A5EF2A419A999959803C5A419A999999D2EF2A41333333937B3C5A410000000015F02A41666666E6753C5A410000000060F02A41666666A66E3C5A4133333333A0F02A4133333353693C5A419A999999DDF02A41CDCCCCAC633C5A41000000000DF12A41000000E05E3C5A419A99999951F12A41CDCCCC0C583C5A413333333392F12A4166666606513C5A4100000000C4F12A41666666664B3C5A4166666666F3F12A41CDCCCC4C453C5A41000000000AF22A4166666626423C5A410000000039F22A41CDCCCC8C3B3C5A416666666675F22A4100000060323C5A41000000009FF22A41333333F3293C5A419A999999B7F22A41333333B3243C5A4133333333DDF22A41000000001B3C5A4133333333FBF22A41CDCCCCAC113C5A419A99999921F32A41CDCCCC2C073C5A416666666645F32A4100000020FE3B5A41CDCCCCCC58F32A419A999939F93B5A41CDCCCCCC67F32A41333333D3F53B5A410000000083F32A41CDCCCC8CEE3B5A41000000008CF32A4166666686EC3B5A419A99999998F32A41CDCCCCECEA3B5A4166666666AAF32A4133333333E93B5A4133333333C2F32A41333333B3E73B5A4166666666D7F32A41333333D3E63B5A4133333333EBF32A4166666646E63B5A4100000000FCF32A4100000040E63B5A41CDCCCCCC11F42A41CDCCCCCCE63B5A410000000030F42A41CDCCCC0CE83B5A413333333341F42A41CDCCCCECE83B5A41CDCCCCCC65F42A4100000000ED3B5A419A99999972F42A41666666A6EE3B5A41000000007BF42A4100000000F13B5A41333333337FF42A4100000040F43B5A41CDCCCCCC80F42A41CDCCCC8CF73B5A419A99999983F42A41CDCCCC8CFA3B5A416666666689F42A4133333373FD3B5A416666666698F42A41CDCCCC0C003C5A4166666666ADF42A41666666A6013C5A4166666666BEF42A4100000060023C5A4166666666D8F42A4100000060023C5A4100000000E3F42A41CDCCCC0C023C5A419A999999F2F42A4166666646013C5A416666666601F52A4133333353003C5A41CDCCCCCC0FF52A4100000020FF3B5A41333333331EF52A41CDCCCCACFD3B5A419A9999992FF52A41333333F3FB3B5A413333333344F52A4100000000FA3B5A416666666662F52A4166666686F73B5A41CDCCCCCC82F52A419A999979F53B5A41CDCCCCCCA1F52A419A999959F33B5A4133333333B2F52A419A9999F9F13B5A41CDCCCCCCC1F52A41CDCCCC0CF03B5A4100000000CDF52A41000000E0ED3B5A4100000000D9F52A4100000000EB3B5A4133333333DFF52A41CDCCCC2CE93B5A4133333333E4F52A4166666646E73B5A419A999999E8F52A419A9999F9E43B5A41CDCCCCCCEEF52A4133333353DF3B5A419A999999EDF52A419A999919DD3B5A419A999999E9F52A4166666606DA3B5A41CDCCCCCCE5F52A419A999959D83B5A4166666666DBF52A41333333D3D53B5A4166666666E9F52A41333333D3D23B5A419A999999EAF52A4166666686D03B5A4100000000ECF52A4166666626CD3B5A41CDCCCCCCE8F52A419A999999C63B5A41CDCCCCCCDDF52A41333333B3C13B5A4166666666D7F52A41CDCCCC4CBD3B5A41CDCCCCCCD3F52A41000000A0BB3B5A4166666666D1F52A419A999959BA3B5A4133333333CCF52A419A999999B83B5A4133333333C4F52A41000000C0B63B5A4166666666BAF52A419A9999B9B43B5A4133333333ADF52A41CDCCCC6CB23B5A41666666669DF52A41CDCCCC4CB03B5A41CDCCCCCC9BF52A419A999959AE3B5A419A99999998F52A419A9999F9AA3B5A416666666684F52A41666666A6A23B5A419A9999997BF52A41333333739C3B5A419A9999997CF52A4166666626993B5A41CDCCCCCC63F52A419A9999198A3B5A41CDCCCCCC6AF52A4100000020893B5A41000000006FF52A41666666A6873B5A41666666666AF52A4100000040813B5A410000000068F52A41000000207C3B5A41666666666DF52A41333333137A3B5A41CDCCCCCC7AF52A419A9999B9793B5A41CDCCCCCC8DF52A41333333D37A3B5A4100000000ADF52A41333333937C3B5A419A999999C5F52A41666666067D3B5A419A999999E5F52A419A9999997D3B5A410000000001F62A41333333B37B3B5A41CDCCCCCC26F62A41666666A67A3B5A410000000032F62A41000000207C3B5A41CDCCCCCC45F62A41000000407D3B5A410000000067F62A41000000607D3B5A416666666672F62A419A9999597E3B5A41000000007FF62A41000000E0823B5A41CDCCCCCC8DF62A419A999919873B5A4100000000A8F62A41CDCCCC6C8B3B5A4166666666BEF62A419A9999598D3B5A41CDCCCCCCD2F62A41000000E08E3B5A41CDCCCCCCDAF62A41666666468F3B5A4100000000E2F62A419A9999998F3B5A419A999999F5F62A41333333938B3B5A41666666660EF72A4100000060863B5A410000000023F72A41666666A6813B5A419A9999992CF72A41CDCCCC6C7E3B5A41333333332AF72A41CDCCCCCC783B5A41000000002BF72A41666666E6733B5A416666666630F72A419A9999B9703B5A41000000003BF72A419A9999596E3B5A41000000004EF72A41666666066C3B5A41CDCCCCCC66F72A41333333136A3B5A41000000007EF72A41CDCCCC4C693B5A410000000096F72A41CDCCCC8C683B5A41CDCCCCCCA2F72A419A9999B9683B5A41CDCCCCCCC2F72A419A9999D9693B5A419A999999D6F72A41CDCCCC0C6A3B5A4166666666E8F72A419A9999B9693B5A4100000000F6F72A4166666606693B5A416666666633F82A41CDCCCC0C613B5A419A9999996AF82A4133333353583B5A410000000079F82A419A999979553B5A41CDCCCCCC7BF82A4133333313533B5A413333333373F82A419A9999B9503B5A41CDCCCCCC6EF82A41CDCCCCCC4D3B5A41CDCCCCCC69F82A41CDCCCC0C4B3B5A41000000006AF82A4100000060483B5A416666666667F82A41333333F3463B5A410000000064F82A419A9999D9453B5A419A99999957F82A41CDCCCC4C443B5A41CDCCCCCC44F82A41000000C0433B5A410000000027F82A4166666606443B5A413333333310F82A419A999999453B5A41CDCCCCCCFDF72A41666666C6463B5A4133333333E9F72A41333333734A3B5A4100000000B8F72A41CDCCCC0C4E3B5A4166666666B1F72A41CDCCCCCC4F3B5A41CDCCCCCCA5F72A41666666C6503B5A416666666697F72A41666666E6503B5A41333333338AF72A419A9999F94D3B5A41333333336BF72A4100000040463B5A41CDCCCCCC58F72A41333333D3403B5A419A99999955F72A41666666E63C3B5A41333333335AF72A4133333313393B5A41CDCCCCCC67F72A41333333F3343B5A41333333336BF72A4133333313333B5A41CDCCCCCC78F72A41333333D3303B5A41CDCCCCCC9EF72A41CDCCCC8C2C3B5A4166666666C1F72A41CDCCCC6C293B5A4166666666E0F72A4166666686253B5A41CDCCCCCCE8F72A41333333D3233B5A419A999999EAF72A41CDCCCC6C203B5A4100000000DFF72A41666666A61A3B5A419A999999CFF72A419A999959153B5A4133333333C7F72A4100000020143B5A41CDCCCCCCB1F72A41CDCCCCCC113B5A419A99999984F72A41CDCCCC8C0D3B5A413333333359F72A41CDCCCC0C093B5A41000000004CF72A4166666626073B5A416666666646F72A4100000040063B5A41CDCCCCCC42F72A419A999939053B5A410000000040F72A419A9999B9033B5A41333333333FF72A419A9999F9003B5A416666666640F72A419A9999D9FD3A5A419A99999937F72A41CDCCCCCCF93A5A41000000002FF72A4133333313F73A5A410000000021F72A4100000020F43A5A41000000000EF72A41CDCCCC0CF13A5A4100000000F5F62A4166666686ED3A5A419A999999EDF62A4133333333EC3A5A419A999999EDF62A4133333313EB3A5A419A999999EBF62A4133333373E83A5A4166666666E9F62A41CDCCCC4CE43A5A41CDCCCCCCDEF62A419A9999D9E03A5A4166666666D9F62A41CDCCCCECDD3A5A41CDCCCCCCDBF62A419A999979DA3A5A419A999999E2F62A4100000020D83A5A419A999999EFF62A4166666606D73A5A41CDCCCCCCF9F62A4133333393D53A5A41CDCCCCCCF9F62A41333333F3D33A5A4133333333F7F62A4166666626D33A5A4100000000F3F62A41000000E0D13A5A41CDCCCCCCFDF62A41CDCCCC6CD13A5A410000000004F72A4100000060D03A5A416666666605F72A41000000A0CE3A5A416666666608F72A419A9999D9CC3A5A419A9999990BF72A41CDCCCC6CCB3A5A41CDCCCCCC15F72A419A999939C93A5A419A9999991CF72A41CDCCCCACC73A5A41333333331CF72A419A999919C63A5A416666666618F72A4100000060C33A5A410000000017F72A4133333373BF3A5A410000000019F72A41CDCCCCECBC3A5A410000000020F72A419A9999F9B93A5A41CDCCCCCC2AF72A41333333B3B73A5A419A99999933F72A41CDCCCCACB63A5A41CDCCCCCC47F72A41000000C0B53A5A41000000006BF72A41000000C0B53A5A41CDCCCCCC81F72A41000000A0B53A5A410000000092F72A41CDCCCC2CB53A5A4100000000A1F72A4133333393B33A5A4133333333AEF72A4166666666B13A5A419A999999B1F72A41000000E0AF3A5A4166666666B4F72A4100000080AE3A5A4100000000B8F72A419A999979AC3A5A4133333333C2F72A41CDCCCCECAA3A5A419A999999D6F72A41000000C0A83A5A419A999999E8F72A41000000A0A73A5A4133333333FBF72A4166666606A73A5A41666666660EF82A4133333353A63A5A41CDCCCCCC1AF82A41333333D3A53A5A416666666630F82A4166666606A63A5A410000000044F82A41666666A6A63A5A416666666655F82A41666666A6A73A5A419A9999996DF82A41333333D3A83A5A419A9999997FF82A419A999979AA3A5A41CDCCCCCC93F82A41000000C0AB3A5A419A999999A7F82A41333333B3AB3A5A4166666666B6F82A4133333373AA3A5A4166666666BEF82A4166666606A93A5A41CDCCCCCCC2F82A41CDCCCC8CA73A5A41CDCCCCCCC3F82A41CDCCCC4CA53A5A419A999999C0F82A41CDCCCC2CA33A5A4166666666B3F82A419A9999999F3A5A41CDCCCCCCA8F82A419A9999199D3A5A4133333333A3F82A41000000809B3A5A4133333333A3F82A419A999959993A5A4133333333A8F82A4133333373973A5A419A999999AFF82A41666666A6943A5A4166666666B5F82A41666666A6913A5A4166666666C2F82A41666666068F3A5A4166666666D9F82A41CDCCCC6C8E3A5A4100000000F2F82A41CDCCCCAC8E3A5A419A9999990CF92A41000000808F3A5A41000000001DF92A419A9999D9903A5A416666666627F92A419A999999923A5A416666666634F92A41CDCCCCEC933A5A41333333334BF92A41333333B3963A5A419A9999995CF92A41CDCCCC2C993A5A416666666673F92A41000000A09B3A5A416666666683F92A41666666E69C3A5A41CDCCCCCC9AF92A419A9999B99D3A5A4166666666B5F92A41666666C69D3A5A419A999999D5F92A41CDCCCCEC9C3A5A4100000000E6F92A41000000E09B3A5A41CDCCCCCCEDF92A41666666469A3A5A4100000000F0F92A41666666E6963A5A41CDCCCCCCECF92A419A999999933A5A4100000000E5F92A419A999999913A5A419A999999D7F92A4166666666903A5A4100000000C5F92A419A9999198F3A5A419A9999994CF92A4100000040803A5A419A99999942F92A41666666667F3A5A419A99999938F92A41666666467D3A5A416666666631F92A419A9999397B3A5A41000000002BF92A4133333353753A5A413333333325F92A4133333333723A5A416666666620F92A41000000206F3A5A41CDCCCCCC18F92A41CDCCCCEC6C3A5A419A99999909F92A41333333936A3A5A410000000007F92A419A9999396A3A5A419A999999FFF82A419A999979693A5A4100000000F4F82A41000000E0683A5A4166666666E1F82A41666666E6683A5A4166666666C1F82A41666666C6693A5A4100000000BEF82A41333333F3693A5A41CDCCCCCCAFF82A41666666666A3A5A4166666666A7F82A41CDCCCC6C6A3A5A41333333339FF82A41000000E0693A5A41CDCCCCCC9AF82A4166666646693A5A410000000097F82A41CDCCCCAC683A5A419A9999998EF82A419A9999F9653A5A419A99999985F82A4166666606633A5A41666666667DF82A419A999979603A5A419A99999974F82A41CDCCCC0C5E3A5A419A99999965F82A41666666065B3A5A413333333358F82A41CDCCCCCC583A5A41000000004AF82A41666666E6563A5A410000000039F82A4166666606553A5A419A9999992AF82A4100000020533A5A41666666661DF82A41000000E0503A5A41CDCCCCCC12F82A41666666C64D3A5A41CDCCCCCC0BF82A41000000204B3A5A41333333330AF82A41000000C0473A5A41000000000AF82A41666666E6443A5A413333333305F82A4166666606433A5A4100000000FEF72A4100000040423A5A4133333333F4F72A4100000020423A5A4100000000EAF72A4133333393413A5A4133333333E5F72A41000000E03F3A5A4100000000E5F72A41666666663D3A5A4100000000E7F72A41333333533B3A5A4166666666EBF72A41000000A0373A5A4100000000F8F72A4166666606333A5A413333333303F82A41000000A02F3A5A4133333333F9F72A41666666C62B3A5A41CDCCCCCCF1F72A41333333332A3A5A41CDCCCCCCE6F72A4100000040273A5A4133333333E5F72A41666666C6253A5A4133333333E6F72A41CDCCCC8C233A5A419A999999E8F72A41CDCCCC8C213A5A419A999999ECF72A419A9999791E3A5A41CDCCCCCCF2F72A41CDCCCCEC1A3A5A4133333333F9F72A41000000C0173A5A419A99999900F82A4100000060143A5A41CDCCCCCC09F82A41CDCCCC2C0F3A5A41CDCCCCCC0EF82A4100000020093A5A413333333310F82A41666666C6063A5A41666666660EF82A4166666626053A5A41000000000AF82A4166666626033A5A419A99999905F82A419A999919013A5A4133333333FFF72A41666666E6FD395A410000000001F82A41666666C6FA395A41CDCCCCCC03F82A4166666606F8395A41CDCCCCCC06F82A419A9999B9F3395A41CDCCCCCC09F82A41666666E6EF395A41666666660BF82A41666666A6ED395A416666666609F82A4100000040EC395A416666666606F82A419A999979EB395A419A99999902F82A4100000020EA395A4166666666FFF72A41CDCCCC4CE8395A419A99999900F82A4166666666E6395A41CDCCCCCC01F82A419A999959E4395A413333333300F82A41000000C0E2395A419A999999FCF72A4100000040E0395A4100000000FCF72A41666666A6D9395A419A999999F9F72A41333333F3D5395A4133333333F4F72A4166666686D4395A4100000000EEF72A419A999979D3395A4100000000D6F72A41CDCCCC6CD1395A419A999999D8F62A41000000A0CF395A4133333333D5F62A41CDCCCC2CD6395A413333333322F62A4133333313D4395A410000000097F52A419A9999B9D1395A413333333365F52A4133333333D4395A41666666665FF52A4166666666D9395A419A999999AAF42A41666666A6DA395A413333333387F42A41333333F3D1395A413333333369F42A4166666646CA395A41333333332FF42A4133333353BD395A4133333333E0F32A419A999919B1395A413333333393F32A41000000E0A3395A410000000036F32A41000000A097395A419A999999FFF22A413333339390395A4100000000C3F22A41CDCCCCAC85395A4166666666B2F22A41333333D381395A41000000009CF22A41000000A07C395A41CDCCCCCC75F22A41666666C66D395A413333333355F22A41333333335F395A413333333333F22A41000000A053395A410000000092F12A41000000A058395A4100000000C4F12A41CDCCCC2C6E395A41CDCCCCCCCEF12A41CDCCCCCC72395A419A99999948F12A41CDCCCC6C6E395A41CDCCCCCC2FF12A41000000C060395A41CDCCCCCC15F12A419A99995962395A413333333328F12A41CDCCCC0C69395A4100000000FDF02A41333333736A395A419A999999B5F02A416666660663395A413333333355EF2A410000008069395A419A9999994FEF2A41CDCCCC8C64395A4100000000A7EE2A419A9999F966395A413333333325EE2A416666668668395A413333333360ED2A419A9999196C395A416666666655ED2A413333331360395A4166666666A1EC2A41666666C65C395A410000000066EC2A41CDCCCC2C88395A41CDCCCCCC8DEB2A41666666467C395A416666666679EB2A41CDCCCCCC74395A416666666633EB2A41000000E074395A413333333315EB2A41CDCCCC2C70395A41000000009BEA2A41333333D34F395A41CDCCCCCC86EA2A419A9999594D395A416666666667EA2A410000006056395A410000000019EA2A41333333F34F395A41CDCCCCCC45EA2A41CDCCCC0C48395A419A999999FAE92A419A9999F941395A4133333333C4E92A41000000204B395A41666666667BE92A413333333346395A419A9999994CE92A419A99993950395A4133333333EDE82A410000000049395A413333333366E72A410000006012395A419A99999988E72A413333337309395A410000000096E52A4100000060E6385A4100000000C4E52A419A999939DE385A416666666680E42A419A999939CA385A41CDCCCCCC97E42A41000000E0C1385A419A999999F0E42A41000000A0A4385A41666666669BE32A419A9999198F385A4133333333CBE12A410000004079385A4100000000BFDF2A41000000606C385A419A9999995CDF2A41333333536E385A4166666666DDDE2A41CDCCCCEC72385A4166666666A5DD2A419A999919A1385A410000000044DA2A41000000200D395A4166666666DFD72A419A99999959395A41CDCCCCCCE5D72A41333333935A395A41CDCCCCCC43D72A41333333534D395A41CDCCCCCCF3D62A416666668658395A41CDCCCCCCA1D62A410000004067395A419A99999991D62A41000000806C395A413333333383D62A41CDCCCC2C74395A4166666666F3D52A419A999999D4395A41CDCCCCCCA8D52A41333333D3FF395A4133333333A4D52A419A9999F9053A5A41	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	01010000206A08000046175D0657EE2A41666666567E3A5A41	550270000	Z	Bannoncourt	5502700	55027	55	44	9
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	01010000206A08000050EB143D93F8294100000090AD645A41	550280000	Z	Bantheville	5502800	55028	55	44	14
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	01060000206A080000010000000103000000010000003800000000000000AF312A41000000E0F5255A4100000000BD312A413333339301265A419A999999EE312A41666666260F265A410000000000322A41CDCCCC2C17265A41000000000A322A41666666C621265A416666666623322A410000000027265A419A9999997C322A416666662634265A4166666666FC322A41333333133F265A41CDCCCCCCC7332A41000000A048265A4133333333FE332A41333333134D265A416666666637342A419A9999594D265A416666666673342A419A9999D948265A4133333333AA342A41000000C040265A4100000000FE342A41CDCCCC4C4A265A41000000001F352A41333333B350265A410000000079352A41333333B346265A4133333333B0352A419A99991942265A416666666636362A41000000602B265A419A9999997F362A41000000E023265A4133333333C1362A413333337317265A413333333319372A41333333730D265A419A99999942372A419A99999906265A41000000006A372A41000000C002265A4133333333C5372A41CDCCCC4CF1255A419A999999F5372A41CDCCCCCCEC255A413333333323382A419A999939E5255A419A99999929382A419A999999E1255A419A99999981382A41666666C6D5255A4166666666AD382A4166666606D4255A41CDCCCCCCBC382A41CDCCCCACD0255A4100000000FF372A419A9999B9BF255A41CDCCCCCCAB372A419A999999B6255A41CDCCCCCC33372A41CDCCCC8CAB255A41CDCCCCCCE8362A41CDCCCCCCAB255A413333333347362A4100000080B5255A4133333333E3352A419A999999B8255A41666666666E352A41CDCCCC0CBB255A41CDCCCCCC04352A4166666686BE255A4166666666F9332A419A999979CE255A41CDCCCCCCD2332A4100000060CB255A4166666666E1332A41000000E0C4255A419A999999CF332A4100000000C1255A41CDCCCCCC92332A4100000080C9255A419A9999997C332A4166666646C6255A41CDCCCCCC72332A41CDCCCC4CBC255A41000000005D332A41333333B3BD255A41333333333C332A4133333313C6255A41000000000B332A419A9999D9CE255A419A999999DA322A4133333393CD255A413333333373322A41CDCCCCCCD6255A41CDCCCCCC19322A41333333D3DB255A4100000000E1312A41CDCCCCECE0255A4100000000C5312A41666666C6E5255A4166666666B3312A4166666646ED255A4100000000AF312A41000000E0F5255A4100000000AF312A41000000E0F5255A41	01010000206A080000B9DC25B89C342A41666666F6FD255A41	550290106	H	Centre Ville	5502901	55029	55	44	0
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	01060000206A080000010000000103000000010000003100000000000000AC352A41000000C0D2265A416666666616362A4166666626E3265A41CDCCCCCCA0362A41CDCCCC8CED265A41666666660F372A41666666A6F4265A4166666666F3372A41666666E600275A41666666663F382A41666666E608275A41666666669A382A41CDCCCCCC05275A41CDCCCCCCE9382A41000000001A275A41CDCCCCCCEC382A41CDCCCCEC23275A416666666607392A41333333D321275A410000000032392A410000008024275A413333333331392A41666666262A275A410000000066392A419A9999B929275A41666666664A3A2A41333333732B275A41CDCCCCCC783A2A41CDCCCC0C2A275A4166666666B53A2A410000008036275A4100000000C63B2A419A9999D928275A419A9999990B3D2A413333333319275A4133333333C53C2A4100000060FD265A419A9999999D3C2A41333333F3F3265A41CDCCCCCC823C2A41CDCCCCACE6265A4133333333553C2A4100000060D4265A4133333333EC3B2A4100000040BF265A4100000000E13B2A4133333333C2265A41333333337E3B2A41333333B3C7265A4133333333293B2A4166666646D2265A419A999999E53A2A4166666646C7265A41000000006C3A2A4100000000B5265A4166666666B13B2A413333339393265A41CDCCCCCC463B2A41666666A682265A4166666666F63A2A416666660677265A4166666666B73A2A41000000C073265A419A999999113A2A419A99999976265A4133333333D7392A41333333F378265A410000000088392A41CDCCCC0C7F265A413333333321392A41333333D38A265A41CDCCCCCC05392A419A9999D98C265A416666666698382A41000000C09C265A413333333353382A419A999919A5265A4133333333FE372A41CDCCCCCCAA265A41CDCCCCCCA4372A419A999919AE265A4166666666F4362A4133333313B3265A41CDCCCCCC91362A41CDCCCCACB8265A41666666665A362A4133333313BD265A41CDCCCCCC11362A419A9999B9C4265A4166666666DA352A419A9999F9CB265A41CDCCCCCCB4352A419A9999D9CE265A4100000000AC352A41000000C0D2265A4100000000AC352A41000000C0D2265A41	01010000206A0800005F1000610A392A4133333343D5265A41	550290101	H	Côte Sainte-Catherine	5502901	55029	55	44	0
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	01010000206A080000B01ADBE1D4332A41333333534E275A41	550290102	H	Marbeaumont Gare Fédération	5502901	55029	55	44	4
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	01010000206A080000A8FC7AD8C8452A4166666676C1255A41	550290103	H	Marbot-Hinot Bradfer	5502901	55029	55	44	6
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	01010000206A080000506FF2A7622E2A419A999959C8255A41	550290104	H	La Libération	5502901	55029	55	44	4
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	01010000206A080000380E6A32CE2E2A41CCCCCC3C5C235A41	550290105	H	Ville Haute	5502901	55029	55	44	9
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	01010000206A0800001281980FFCDD2941CDCCCC2CB11C5A41	550310000	Z	Baudonvilliers	5503100	55031	55	44	3
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	01010000206A08000042043AC4DAB62A41000000F0692D5A41	550320000	Z	Baudrémont	5503200	55032	55	44	7
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	01010000206A0800004C0C75423AD9294166666636575B5A41	550330000	Z	Baulny	5503300	55033	55	44	4
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	01010000206A0800005796FFFA47B92A41000000F09B755A41	550340000	Z	Bazeilles-sur-Othain	5503400	55034	55	44	8
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	01010000206A08000002A9BF15172C2A419A999959BC1C5A41	550350000	Z	Bazincourt-sur-Saulx	5503500	55035	55	44	10
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	01060000206A08000001000000010300000001000000EB0000009A999999EA022A41666666E6A6705A4100000000F2022A4166666626AC705A419A9999991E032A419A999959B6705A419A99999968032A41CDCCCCACC3705A4100000000A1032A4166666606CC705A419A99999974042A4133333373E8705A410000000008052A41CDCCCC6CFA705A41CDCCCCCC54052A416666666606715A419A9999998E052A41CDCCCCAC0B715A413333333351062A41333333931A715A41CDCCCCCC92062A419A99993920715A413333333345072A41000000E02C715A4133333333A4072A41CDCCCCEC34715A416666666681082A410000000046715A41CDCCCCCCDF082A41666666A64F715A413333333328092A41333333535C715A41CDCCCCCC77092A410000008068715A4100000000470A2A419A99997971715A4133333333B00A2A41CDCCCCCC73715A4100000000CF0A2A41CDCCCCCC6F715A4100000000280B2A41666666E672715A4100000000C10B2A41CDCCCC0C74715A419A9999992C0C2A41CDCCCC0C73715A4133333333820C2A41333333B374715A4100000000BC0C2A41CDCCCCEC72715A41000000005B0D2A419A9999F966715A4133333333BF0D2A419A9999996F715A4166666666410E2A419A9999D967715A41CDCCCCCCAD0E2A41CDCCCC8C5F715A41CDCCCCCC0A0F2A41000000A059715A4166666666600F2A419A9999F95D715A41CDCCCCCCD30F2A41333333D356715A419A999999DE0F2A41000000A04E715A416666666677102A41666666E651715A4166666666A6102A419A9999D953715A41CDCCCCCCB8102A410000002057715A416666666633112A41CDCCCC0C55715A4133333333BD112A41CDCCCCEC43715A41CDCCCCCC23122A41000000203F715A41CDCCCCCC9B122A41000000002E715A4100000000F4122A419A99991923715A413333333337132A419A9999B925715A413333333357132A413333333325715A4100000000D7132A419A9999D918715A41CDCCCCCCFE132A419A9999F910715A4133333333B5142A419A9999B9FE705A41666666660E152A419A999919F7705A416666666661152A41000000A0F7705A410000000085152A419A9999F9F3705A41333333331D162A41CDCCCC2C09715A41333333335B162A41333333B306715A416666666611172A41000000E013715A416666666652172A41666666C60E715A419A999999CA172A41333333B31A715A41666666668B182A410000002031715A4133333333E4182A416666664638715A41CDCCCCCCC9192A419A9999F93F715A41000000002C1A2A419A9999D949715A4166666666551A2A416666660656715A4100000000761A2A41CDCCCC0C64715A419A999999A21A2A41666666466D715A419A999999311B2A41CDCCCC4C7A715A4133333333C21B2A410000002083715A419A999999B11C2A41CDCCCC4C8E715A4133333333181D2A416666668687715A41CDCCCCCC491D2A419A9999F97F715A419A999999341D2A410000000071715A4100000000791D2A41333333F357715A4100000000D11D2A419A99997941715A4166666666C71D2A419A9999793D715A41CDCCCCCCC11D2A41666666862D715A419A999999301E2A4166666646FA705A419A999999361E2A419A9999B9EF705A41CDCCCCCC1D1E2A41CDCCCC8CEB705A41CDCCCCCC251E2A41CDCCCC4CE1705A41333333330F1E2A419A9999B9DD705A41000000000A1E2A419A999979D0705A4100000000EA1D2A419A999919C8705A4100000000AA1D2A41333333B3BC705A4133333333761D2A41CDCCCCECB7705A41333333335F1D2A41CDCCCC6CB0705A41CDCCCCCC0B1D2A4166666666A8705A4100000000C61C2A41333333F3A3705A419A999999BC1C2A41333333F39D705A419A999999761C2A410000008096705A41666666665D1C2A419A9999998C705A4166666666071C2A413333339381705A4133333333E51B2A41666666C676705A419A999999C01B2A413333333370705A4133333333881B2A41CDCCCCEC69705A4166666666441B2A41CDCCCC4C64705A4133333333291B2A41666666A66A705A41000000000C1B2A41CDCCCC8C69705A4133333333CF1A2A41666666A661705A419A999999861A2A416666668664705A419A999999821A2A41000000406C705A41CDCCCCCC661A2A41CDCCCCAC6E705A419A999999421A2A41666666066E705A4166666666431A2A410000000069705A4166666666201A2A41666666E668705A4100000000DD192A419A9999B971705A4133333333C6192A410000008078705A4100000000A2192A41CDCCCCCC79705A41333333335E192A416666660678705A413333333342192A41666666E67B705A416666666651192A41CDCCCC0C85705A41000000001B192A41666666868A705A4100000000F4182A41CDCCCCAC8A705A4166666666C3182A410000002088705A4100000000A9182A41666666668C705A4133333333C6182A419A99995991705A4100000000F7182A419A9999D994705A419A999999F1182A419A99991999705A4166666666D7182A41000000C09A705A419A999999B7182A41000000A095705A41666666668B182A41333333B393705A41CDCCCCCC4F182A41333333D39F705A419A99999911182A41333333939D705A4133333333E4172A4100000000A1705A419A999999B8172A4100000060A9705A41CDCCCCCC74172A41333333F3A9705A410000000053172A4133333353AF705A41CDCCCCCCCE162A41666666C6BE705A4133333333C4162A41666666C6C1705A419A999999CB162A41666666C6CF705A41CDCCCCCCBE162A4133333393D2705A41CDCCCCCC70162A419A999979D3705A41000000002F162A419A9999B9D9705A419A999999EE152A419A999979DA705A4100000000D7152A419A999919E1705A410000000099152A41CDCCCC4CE8705A410000000091152A4133333313EE705A419A99999939152A4166666646DC705A416666666698142A4133333373C8705A4100000000F5132A4166666666B3705A41CDCCCCCCA9102A41333333F34D705A413333333367102A41333333F343705A4133333333A10F2A41000000E029705A41000000000F0F2A41333333731E705A41CDCCCCCC930E2A41333333D312705A41CDCCCCCCF20D2A41000000C005705A41CDCCCCCC800D2A41333333D3FA6F5A4133333333270D2A4166666626E96F5A4133333333BA0C2A41CDCCCC4CD86F5A4133333333960C2A419A9999F9D06F5A419A9999998C0C2A419A999959CB6F5A4133333333C00B2A4166666606AE6F5A4133333333650B2A41666666A69C6F5A4133333333AD0A2A419A999919806F5A4166666666660A2A41333333B3736F5A419A99999983092A419A999979566F5A41333333333C082A419A999919086F5A4100000000D1072A41CDCCCCCCEA6E5A410000000071072A4133333333E06E5A419A99999958072A4133333353D56E5A41CDCCCCCC6A072A41333333F3CD6E5A41CDCCCCCCA9072A41333333D3BD6E5A4133333333DF072A4133333333AE6E5A41666666660D082A41333333D3A36E5A413333333368082A419A9999B9946E5A419A999999F1082A41666666A67F6E5A413333333355092A41000000A06D6E5A41333333336B092A41CDCCCC0C676E5A4166666666C2092A419A999959526E5A4166666666650A2A41000000C0296E5A4133333333C30A2A41CDCCCCEC196E5A41000000007F0B2A419A999999036E5A419A999999360D2A41000000C0D36D5A4100000000F20D2A4133333313BD6D5A41CDCCCCCCC90E2A41CDCCCCCC916D5A41CDCCCCCCF20E2A4133333333976D5A4100000000170F2A41CDCCCCAC776D5A4100000000650F2A4166666646536D5A41000000008F0E2A4100000020586D5A41666666662C0E2A41000000E03F6D5A41000000000C0C2A41000000C0316D5A419A9999995B0A2A41CDCCCCAC216D5A41666666669A092A41CDCCCCCC1C6D5A41CDCCCCCC1C082A4133333373126D5A4166666666B9062A41000000800B6D5A419A99999977062A41666666C60F6D5A4166666666C1062A41000000A0286D5A41CDCCCCCCC9062A4133333333336D5A4133333333A9062A41333333F3566D5A4133333333A2062A419A9999B9816D5A410000000034062A4100000060906D5A413333333325062A419A999959966D5A41666666662C062A41CDCCCC4C9A6D5A4100000000A8052A4166666606C46D5A41CDCCCCCC52052A41000000A0DC6D5A41CDCCCCCCC4042A41CDCCCCECF66D5A419A99999966042A41666666860E6E5A419A9999992B032A41666666A6766E5A416666666664032A41CDCCCCCC7B6E5A419A9999997C032A41333333D3806E5A410000000021032A4166666686A06E5A41666666660B032A419A999959AB6E5A4166666666F9022A4100000080BD6E5A4100000000F5022A41CDCCCC4CD56E5A419A999999FA022A41666666A6E36E5A4100000000C9052A41CDCCCC2CD66E5A4166666666D8052A4100000020DB6E5A419A999999FB052A41CDCCCC2CDF6E5A410000000060062A41333333F3E46E5A410000000095062A419A999979EC6E5A41CDCCCCCCC3072A419A9999D93B6F5A41333333338F072A41CDCCCC2C826F5A416666666626072A4133333393826F5A41CDCCCCCC2B072A4166666606896F5A413333333379072A41CDCCCCCC896F5A419A99999934072A41000000A09C6F5A41666666665F072A419A999919A06F5A410000000009072A41000000C0B16F5A41CDCCCCCCC7072A4133333333C06F5A41000000007E072A4100000040D16F5A41CDCCCCCC19072A41CDCCCCCCCB6F5A419A999999E2062A4133333373D96F5A410000000020072A41CDCCCC8CDE6F5A41CDCCCCCCC2062A4166666686F36F5A419A99999904072A41CDCCCCCCF36F5A41CDCCCCCC31072A4133333393F66F5A410000000026082A41CDCCCC8C1D705A413333333391082A41CDCCCCCC3E705A4133333333FD082A419A9999B945705A413333333330092A41000000804C705A41333333336D082A413333335354705A4100000000A0082A410000008060705A419A9999995C082A41000000605F705A4166666666EA072A419A9999996A705A41CDCCCCCCA7072A41000000E077705A413333333382052A4100000040BB705A4133333333ED032A416666662694705A4133333333B9032A419A99997999705A419A999999EA022A41666666E6A6705A419A999999EA022A41666666E6A6705A41	01010000206A080000F27879EA82082A419A999929496F5A41	550360000	Z	Beauclair	5503600	55036	55	44	5
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	01010000206A080000383393E559072A41CCCCCC3CB8725A41	550370000	Z	Beaufort-en-Argonne	5503700	55037	55	44	11
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	01010000206A080000D9D3FEFCFAEA2941343333735E435A41	550380000	Z	Beaulieu-en-Argonne	5503800	55038	55	44	30
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	01010000206A080000002F7616FBB72A41000000D0FF5B5A41	550390000	Z	Beaumont-en-Verdunois	5503900	55039	55	44	8
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	01060000206A080000010000000103000000010000003A0100006666666627332A419A9999F9A73B5A419A9999991B352A41CDCCCCCCC53B5A41CDCCCCCCF1342A41CDCCCC6CD73B5A41CDCCCCCC71342A4133333373083C5A4133333333D2332A4133333393473C5A4100000000BA352A41CDCCCC6C7F3C5A413333333342362A419A999959763C5A41CDCCCCCC88362A4100000040703C5A410000000030372A41333333935B3C5A410000000075372A41333333B35E3C5A4166666666A9392A4100000060843C5A4133333333013A2A41000000A0893C5A41CDCCCCCCF63A2A41333333739B3C5A4133333333903B2A41666666C6A53C5A4133333333513C2A41333333B3B83C5A4100000000D53C2A4100000080C93C5A41666666662B3D2A419A999959CD3C5A41CDCCCCCCC83D2A4100000000D63C5A4166666666413E2A4100000060DD3C5A4100000000FC3E2A4166666666EA3C5A41CDCCCCCC8A3F2A4166666626F53C5A419A9999999D3F2A4133333353ED3C5A41CDCCCCCC6B3F2A4133333333E73C5A4166666666723F2A4166666646DE3C5A419A999999AD3F2A41000000E0D33C5A41CDCCCCCCD13F2A419A999999D03C5A41000000003D402A419A9999B9CD3C5A41CDCCCCCC65402A41CDCCCC0CD03C5A413333333392402A4133333333CE3C5A4100000000A4402A41CDCCCCACC63C5A4133333333F9402A4166666626C83C5A41333333335D412A4100000080D03C5A41333333337F412A41000000A0C63C5A41CDCCCCCC13422A4100000020D23C5A416666666665422A41CDCCCC2CD93C5A41CDCCCCCC69432A4133333353ED3C5A41CDCCCCCC2A442A4166666646FF3C5A4133333333C7442A41000000C00E3D5A416666666628452A419A999939193D5A41666666660B462A41000000C01E3D5A41CDCCCCCC47462A419A9999791F3D5A41CDCCCCCC99472A419A9999D91D3D5A4100000000C2472A41666666261D3D5A4166666666C6472A41333333F3133D5A410000000030492A4166666666103D5A41CDCCCCCCF6492A41CDCCCCAC0F3D5A419A9999998B4A2A4100000020133D5A41CDCCCCCC984B2A4133333353163D5A419A9999999C4B2A4166666626113D5A419A999999BE4B2A4133333313123D5A419A999999064E2A41CDCCCC8C1C3D5A4100000000EC4E2A419A999919223D5A4100000000974F2A41333333B3253D5A419A999999D14F2A4133333393373D5A4166666666FD4F2A41000000E03C3D5A413333333389502A41000000E0453D5A41CDCCCCCCE0502A41333333B34C3D5A41CDCCCCCC96512A419A999979613D5A4166666666C5512A419A999939693D5A41CDCCCCCCE0512A419A999959703D5A419A99999940522A41CDCCCCEC903D5A419A999999BA522A4133333313B33D5A41000000003D532A41CDCCCCECCE3D5A41666666665C532A41000000E0D83D5A4133333333A7532A41666666A6FA3D5A41000000007F542A4100000020FC3D5A410000000054552A41666666A6FC3D5A416666666647552A41CDCCCCCC053E5A410000000029552A419A999999103E5A41CDCCCCCC17552A41000000801A3E5A419A9999994B552A419A9999991E3E5A419A999999A3552A41333333B3283E5A4100000000D6552A41000000602C3E5A419A99999922562A41CDCCCC0C2D3E5A41333333336D562A4100000020303E5A41CDCCCCCCE1562A41666666263A3E5A41666666661C572A41333333F3453E5A419A9999994C572A41000000A0493E5A4100000000CF572A41CDCCCC8C5A3E5A419A999999F2572A41666666C6603E5A416666666645582A41666666C6563E5A4100000000C1582A41CDCCCC6C4C3E5A41CDCCCCCCF0582A41CDCCCC8C433E5A41333333331C592A41000000C0433E5A41CDCCCCCC64592A41000000003F3E5A41CDCCCCCC41592A41CDCCCC0C353E5A41333333334C592A41000000402B3E5A41CDCCCCCC95592A4133333373213E5A4100000000DC592A41CDCCCCEC2B3E5A419A9999993B5A2A419A9999392B3E5A4166666666545A2A41CDCCCC6C2C3E5A41333333335C5A2A419A9999D9323E5A41CDCCCCCCCA5A2A4166666646343E5A4166666666A25B2A419A999999293E5A4133333333005D2A4166666626153E5A4166666666775D2A41666666A60C3E5A4133333333A55D2A419A9999B90B3E5A41000000004B5E2A41000000800F3E5A41CDCCCCCC625E2A419A999959053E5A419A9999997B5E2A4133333373043E5A41CDCCCCCC25602A4133333373D43D5A41000000009C612A4100000060E03D5A416666666658632A4166666626EC3D5A410000000071632A41333333D3D33D5A41CDCCCCCC83632A4100000080A23D5A41CDCCCCCCC6632A419A9999B9763D5A4133333333B0632A4133333373693D5A41CDCCCCCC8A632A41CDCCCCCC5A3D5A41CDCCCCCC41632A41000000A0483D5A41CDCCCCCC0D632A41000000E0423D5A4100000000AF622A41666666A6453D5A4166666666F6622A419A999939273D5A41CDCCCCCC8A632A419A999939F33C5A4100000000E0632A4133333313D93C5A419A99999950642A4100000040AD3C5A41CDCCCCCC2A642A419A999939953C5A410000000029642A41333333938D3C5A41CDCCCCCC40642A41000000A0743C5A4166666666EF642A41666666864F3C5A41CDCCCCCC13652A41000000E0503C5A41CDCCCCCC83652A41333333D33F3C5A41666666669C652A41333333F3373C5A41333333338F652A41000000202D3C5A413333333363652A419A9999F9203C5A419A9999992A652A419A9999D9193C5A4133333333E2642A41333333D30D3C5A416666666608652A41000000C0D53B5A41CDCCCCCCE3642A41000000C0D13B5A419A999999C2642A41CDCCCCACC03B5A4133333333A6642A4100000080B93B5A410000000091642A4166666606A83B5A4133333333A4642A41000000E07E3B5A4166666666A9642A419A999919663B5A4133333333C8642A4100000000633B5A41CDCCCCCC2D652A419A999959603B5A4100000000FE642A41666666C64A3B5A41333333331D652A41666666663C3B5A41666666660A652A4166666686333B5A419A999999E2632A419A9999B9223B5A419A999999D5632A41000000C01C3B5A410000000004642A41000000400F3B5A410000000014642A419A999939043B5A4166666666C7642A41CDCCCC8CD63A5A416666666659642A4166666606D33A5A419A9999995D632A41000000A0CE3A5A4133333333CA632A41333333D38F3A5A4166666666CB632A4166666646873A5A416666666655632A41666666067F3A5A419A999999A1632A41666666865C3A5A419A99999905642A4166666686543A5A4133333333C6642A419A999999493A5A419A99999940652A4133333313443A5A410000000074652A41666666463D3A5A416666666607662A41000000C0303A5A419A999999F0662A41333333D3193A5A416666666641672A41333333F30F3A5A413333333377682A41333333F3FF395A41CDCCCCCCCE682A41333333B3F8395A419A9999992B692A41333333F3F2395A4133333333BA692A4166666606E8395A4100000000016A2A419A999979F2395A4166666666326A2A41666666E6FB395A4166666666646B2A4166666646103A5A4133333333A56C2A41CDCCCC8C203A5A4166666666346D2A41333333B32B3A5A41CDCCCCCC9C6E2A4166666606463A5A41666666660C6F2A419A9999F94E3A5A4166666666366F2A4166666606503A5A4133333333706F2A41000000804D3A5A41666666668A6F2A41666666E6493A5A419A999999C26F2A41CDCCCCAC3B3A5A410000000009702A4133333393243A5A41CDCCCCCC846F2A4100000080113A5A41CDCCCCCCBB6F2A41333333D3F9395A4166666666BF6F2A41CDCCCC0CEE395A419A999999FD6E2A4166666646E1395A4133333333B16E2A41CDCCCCECDF395A4100000000546E2A41333333B3DB395A4100000000106E2A41CDCCCC0CD7395A4133333333D26D2A4133333333D1395A4133333333726D2A419A999959C1395A419A999999426D2A4166666646BB395A41CDCCCCCC926C2A41666666E6AD395A41CDCCCCCC5D6C2A41666666E6A7395A4100000000386B2A410000006095395A4166666666376A2A416666668689395A419A9999997D692A413333337383395A419A999999F2682A41000000A07F395A41CDCCCCCC5D682A41CDCCCC4C7D395A419A9999992C682A41666666467B395A419A9999993D672A41CDCCCC6C97395A4133333333B6662A419A9999B9A2395A419A9999995C662A41000000E0AC395A419A99999943662A41CDCCCC8CBA395A416666666624662A419A999979C1395A41CDCCCCCCE6652A4166666686C5395A41CDCCCCCCBA642A419A9999F9D1395A410000000057642A4133333393D8395A416666666676632A41333333B3E8395A41666666662A632A419A999939F3395A41CDCCCCCCFC622A41000000A0ED395A419A99999979622A419A999959FB395A41CDCCCCCC26622A4166666666EC395A4133333333AB612A419A999999D9395A41CDCCCCCC1A612A4100000080E9395A419A999999CB602A41666666E6EF395A41333333336D602A4166666666EF395A41333333334C5F2A4100000020F2395A419A999999495E2A41000000C0F6395A4133333333CB5C2A4166666626F8395A41CDCCCCCCF65B2A4133333373F3395A41000000002A5B2A4100000020EE395A4166666666A85A2A4133333313EF395A4100000000AF592A41333333D3E6395A41CDCCCCCC11592A41CDCCCC0CE4395A413333333355582A4100000040E4395A41CDCCCCCC49572A4166666646E1395A419A999999BC562A41CDCCCCACE6395A41CDCCCCCC76562A4100000040EF395A41333333333B562A41666666C6FA395A4133333333E8552A41CDCCCCAC053A5A419A999999B4552A4166666626133A5A41666666667C552A419A999939253A5A41CDCCCCCC6D552A41666666E6363A5A413333333351552A41CDCCCCEC3A3A5A4166666666FA542A41333333533C3A5A419A999999BF542A41333333933A3A5A41666666663C542A4133333373273A5A419A99999983542A419A9999991F3A5A410000000026542A4166666606173A5A413333333343542A41000000000D3A5A419A99999974542A41333333F3023A5A41CDCCCCCCCC542A41000000E0E9395A410000000094532A41000000A0D4395A413333333397532A4133333393C8395A4133333333B5532A41CDCCCC4CC2395A4133333333E1532A41CDCCCC6CBE395A416666666600542A4133333313B7395A419A9999995F532A41CDCCCCACAB395A41666666662C532A41CDCCCCECCC395A416666666611532A41CDCCCCACCD395A416666666697522A4133333313BD395A41CDCCCCCCA2522A41CDCCCC0CAF395A4100000000A3512A419A9999B983395A419A9999997A502A413333333359395A4133333333444F2A41CDCCCC4C28395A419A999999264E2A419A9999F9FD385A4100000000994E2A4166666626F5385A419A999999FE4D2A4166666646DD385A4166666666C24D2A4166666606D0385A41000000008E4D2A4166666686C7385A4100000000344D2A419A999979A2385A4100000000E34C2A41666666A688385A419A999999CF4C2A419A9999F983385A4166666666E64C2A41666666C67E385A4100000000A34C2A413333335373385A41000000006C4C2A41333333936C385A4166666666B64B2A41333333F35B385A419A999999B04B2A41CDCCCC0C43385A41CDCCCCCC434B2A416666660639385A4100000000C94A2A41000000802B385A41666666665A4A2A41CDCCCC6C20385A419A9999997A492A41666666060B385A413333333386482A4166666626F8375A41CDCCCCCC8F472A41CDCCCCECE8375A41CDCCCCCC3A472A41CDCCCC8CE4375A4133333333BA462A41333333D3DA375A419A9999990A462A4133333353D3375A410000000098452A41666666C6CF375A419A999999C9442A41CDCCCCACCB375A419A99999995442A419A9999B9F3375A416666666678442A41333333B3F2375A419A99999955432A41000000E0F0375A413333333303432A4133333393EF375A416666666610432A416666668605385A410000000047432A41333333332C385A416666666631432A419A9999994E385A410000000086432A419A9999D94D385A4166666666F5422A410000000079385A41CDCCCCCCA6422A41CDCCCC6C8C385A41CDCCCCCC24422A41333333B3B1385A419A999999CF412A4166666666C8385A4166666666FA402A419A999999F9385A41CDCCCCCC9A402A419A999939F2385A4166666666E73F2A41000000E016395A419A999999723F2A419A99999923395A419A999999993E2A419A9999D93D395A4166666666653E2A419A9999B92F395A419A9999993A3D2A41CDCCCC6C64395A41CDCCCCCC413C2A41000000E07B395A41CDCCCCCC713B2A41CDCCCCAC8D395A419A999999AB3A2A41000000A09B395A419A999999353A2A419A9999799D395A419A999999C6392A4166666606AA395A41CDCCCCCC75382A419A9999B9D5395A4133333333A2372A4100000040E9395A413333333384362A419A9999D9F5395A4133333333A2362A4133333353293A5A4166666666A1362A419A9999393E3A5A41CDCCCCCC8E362A4100000020613A5A419A999999A0362A41CDCCCC6C913A5A41CDCCCCCCB7362A419A9999F9D63A5A41CDCCCCCCC6362A41CDCCCC4CE93A5A41CDCCCCCCB9362A419A9999F9F43A5A41666666660B362A4166666626203B5A419A9999999F352A419A9999F91C3B5A41CDCCCCCC7A342A4133333353133B5A419A99999959342A4133333333133B5A4100000000E6332A41333333B3463B5A4100000000C3332A41000000005D3B5A41CDCCCCCCB6332A419A999979703B5A419A99999992332A41000000008C3B5A416666666627332A419A9999F9A73B5A416666666627332A419A9999F9A73B5A41	01010000206A080000386C1A350C4D2A41CDCCCC2C173B5A41	550400000	Z	Beausite	5504000	55040	55	44	26
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	01060000206A08000001000000010300000001000000BF0000000000000004292A419A9999B95D295A41CDCCCCCC0F292A413333339365295A419A9999993F292A413333335373295A41000000008F292A416666666685295A41CDCCCCCC182A2A41CDCCCC2C93295A419A999999322A2A41333333739D295A419A999999C82A2A4100000080B9295A419A999999DF2A2A41CDCCCCCCC1295A419A999999EE2A2A4100000020CE295A419A999999112B2A41CDCCCCECD8295A4133333333202B2A41CDCCCCECE0295A419A9999992A2B2A4166666606EF295A4133333333652B2A41666666C6F0295A4100000000E62B2A41000000A0FF295A419A999999302C2A41CDCCCCEC0B2A5A419A999999712C2A41CDCCCCAC0C2A5A4166666666412E2A41333333D30D2A5A419A9999993D2F2A41CDCCCC2C042A5A416666666675302A4133333353F5295A419A99999962312A41333333D3EB295A4133333333C5322A4100000000E9295A41666666663A342A419A999919E1295A410000000083352A41CDCCCC0CDE295A4100000000CE362A4100000020DF295A416666666684372A41666666A6E6295A410000000007382A41666666A6F1295A419A999999F7382A41000000600B2A5A41CDCCCCCCB8392A419A9999D91E2A5A419A999999963A2A419A9999592D2A5A4133333333B43B2A4100000060372A5A41333333335D3C2A41666666C63A2A5A419A9999993E3E2A4100000060162A5A4133333333073E2A41666666462F2A5A41CDCCCCCC2E3E2A41CDCCCC6C372A5A419A999999513F2A419A999919532A5A419A999999F93F2A41666666C6562A5A41CDCCCCCC7F402A419A9999B9582A5A41CDCCCCCCD0402A41CDCCCC4C5C2A5A41CDCCCCCCE6402A41666666465A2A5A41666666664B412A4166666666652A5A41CDCCCCCC8E412A419A9999D96A2A5A4100000000B9422A41CDCCCC4C7F2A5A419A9999990D432A41666666267A2A5A41CDCCCCCCD9442A4133333333552A5A413333333318452A41000000204E2A5A410000000078452A41CDCCCCAC4B2A5A419A999999B0452A419A999979462A5A41CDCCCCCCCF452A41333333F33B2A5A419A99999925462A41000000C00C2A5A419A999999A0462A4133333353F1295A4100000000D0462A41CDCCCCECED295A4100000000EA462A4133333313E0295A416666666616472A41000000E0D6295A419A9999995E472A4133333313CC295A419A999999CB472A41CDCCCCECBE295A419A9999998D482A41CDCCCC8CAD295A4133333333DD482A41CDCCCCECA7295A419A999999A9482A41CDCCCCEC8D295A419A9999999B482A413333339369295A416666666699482A419A9999D958295A41CDCCCCCCB2482A416666660650295A4100000000D3482A41666666064C295A4166666666ED482A41CDCCCC4C44295A419A999999B2482A41CDCCCC0C3D295A4166666666D4482A410000002039295A41CDCCCCCC63492A419A9999991D295A4166666666A8492A410000008011295A41CDCCCCCCE1492A419A9999B90A295A41666666662B4A2A4133333373FF285A41666666665E4A2A41333333B3F4285A410000000099492A4133333333E0285A41CDCCCCCCEF492A41666666C6CE285A419A999999C24A2A41333333D3DC285A4166666666764A2A41CDCCCC2CCA285A4100000000584A2A4133333353C4285A419A999999E4492A4133333393BD285A4133333333A3492A4100000000B8285A4133333333E8492A41CDCCCC8CA9285A41666666663F4A2A41000000A090285A41CDCCCCCC614A2A413333339385285A4100000000564A2A41000000006D285A419A999999804A2A416666660666285A419A9999999F4A2A419A99993959285A4100000000924A2A416666668640285A4133333333994A2A41666666A628285A4166666666CB4A2A41CDCCCC6C15285A4100000000C84A2A419A9999D908285A419A999999E64A2A413333331303285A4133333333DD4A2A4166666646FB275A4133333333184B2A41CDCCCCECEC275A4166666666C74A2A4166666666E1275A4166666666914A2A41CDCCCC2CD3275A4133333333434A2A4166666626CF275A41CDCCCCCC4E4A2A4166666646C9275A419A999999314A2A419A9999F9C6275A41333333333A4A2A41000000E0C0275A41CDCCCCCCE4492A41CDCCCC8CB8275A419A999999DD492A4100000080A1275A4166666666F7492A410000008083275A419A999999DC492A41CDCCCCCC7A275A41CDCCCCCC68492A41000000A08E275A419A99999925492A41666666E687275A419A9999996B492A41333333F376275A4100000000D6492A419A9999F965275A419A999999DE472A41CDCCCC6C36275A4166666666C1472A41000000C037275A419A99999904472A419A9999D92E275A4166666666B1462A41333333D34C275A41CDCCCCCC52462A410000000071275A413333333324462A41666666266E275A4166666666D5452A41333333536D275A416666666672452A41CDCCCC4C6E275A41CDCCCCCC65452A41666666E66A275A419A99999913452A416666666661275A41333333339D442A416666666655275A41666666663F442A41CDCCCC0C4D275A410000000026442A41666666464F275A41CDCCCCCC1B442A41000000604A275A4100000000A2432A416666664648275A41333333330A432A41000000E04D275A413333333305432A41CDCCCC6C4C275A41CDCCCCCCC5422A419A9999D94F275A416666666695422A41CDCCCCCC54275A410000000021422A41CDCCCC6C5E275A4166666666B8412A419A9999394F275A413333333356412A41333333F345275A413333333367412A41000000A042275A41CDCCCCCC11412A41666666463F275A41CDCCCCCCDD402A41000000E037275A41333333335D402A41CDCCCC2C34275A419A99999922402A419A9999F937275A4133333333F73F2A41666666C63F275A41CDCCCCCC843F2A41CDCCCC4C4B275A4133333333813F2A416666666650275A41333333333C3F2A413333335353275A41CDCCCCCC033F2A41000000204C275A419A999999D93E2A41666666063E275A419A999999B33E2A410000000024275A419A999999A93E2A419A99999914275A41CDCCCCCCA03D2A41333333B315275A4100000000233D2A413333331318275A4100000000C63B2A419A9999D928275A419A99999946392A419A9999D948275A413333333331392A41CDCCCCAC4C275A410000000044392A419A9999595D275A419A99999945392A41CDCCCC0C69275A419A9999993B392A410000008075275A41666666664C392A419A99997980275A41CDCCCCCC70392A41666666468E275A41000000004E392A419A99991994275A416666666616392A41CDCCCC8C98275A4100000000F2382A41000000C09D275A410000000096382A41666666A6A3275A4100000000DA372A41CDCCCC4CA8275A41CDCCCCCCB7372A4166666646AA275A41000000002D372A419A9999B9A8275A41CDCCCCCCB4362A4133333373A3275A413333333380362A4133333353E0275A416666666631362A4100000040F1275A413333333302362A4166666626FE275A419A99999976352A419A9999192B285A413333333304352A419A9999393B285A419A9999999D342A41CDCCCCEC3C285A410000000056342A413333337353285A413333333301342A41CDCCCCEC68285A4166666666FB332A419A9999B96C285A413333333328332A41333333539E285A41666666662C332A41CDCCCC4CB4285A413333333328332A4100000080C7285A41CDCCCCCCA5322A41000000A0CB285A419A99999944322A41CDCCCC8CD2285A41CDCCCCCCFA302A4133333353E1285A419A9999995F302A41CDCCCCCCE9285A41666666662C302A41666666E6F3285A419A99999912302A41666666A6FC285A419A999999B72F2A419A9999B9F8285A41000000003E2F2A419A999939F8285A419A999999932E2A41CDCCCC2CF3285A419A999999E02C2A4133333393EC285A41333333333F2B2A41CDCCCC8CEB285A41333333331E2B2A419A9999B9FB285A419A9999992B2B2A410000000009295A4133333333D22A2A41CDCCCC0C0E295A41666666669C2A2A410000006014295A410000000058292A419A9999791C295A41CDCCCCCC44292A41000000E029295A41666666664F292A419A99999936295A416666666620292A413333335341295A41000000001B292A41666666E64F295A410000000004292A419A9999B95D295A410000000004292A419A9999B95D295A41	01010000206A0800008A9BEB34A33E2A41666666E6C9285A41	550410000	Z	Behonne	5504100	55041	55	44	9
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	01010000206A0800002A419E1205B32A4100000050044D5A41	550420000	Z	Belleray	5504200	55042	55	44	5
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	01010000206A080000225847BD3FAF2A4133333383AA525A41	550430000	Z	Belleville-sur-Meuse	5504300	55043	55	44	10
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	01010000206A08000048189879BD862A419A999989FB2F5A41	550440000	Z	Belrain	5504400	55044	55	44	8
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	01010000206A080000D5CB6F4F4FD52A41666666A6894F5A41	550450000	Z	Belrupt-en-Verdunois	5504500	55045	55	44	9
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	01010000206A0800003BED9C39799F2B419A9999292D3C5A41	550460000	Z	Beney-en-Woëvre	5504600	55046	55	44	18
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	01010000206A080000002E5E2564542A41000000D042515A41	550470000	Z	Béthelainville	5504700	55047	55	44	12
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	01010000206A0800009A8419E11E4E2A4134333393AD595A41	550480000	Z	Béthincourt	5504800	55048	55	44	13
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	01010000206A080000516A13A7B5EA29419A99992953245A41	550490000	Z	Beurey-sur-Saulx	5504900	55049	55	44	12
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	01060000206A08000001000000010300000001000000A90000006666666608CA2A4166666646E9585A41666666666BCA2A4133333333EF585A416666666601CB2A4166666646FA585A4100000000B3CB2A410000000009595A419A999999F6CC2A41CDCCCC8C28595A416666666675CD2A419A99999934595A41CDCCCCCC77CE2A41CDCCCCCC33595A4166666666DECE2A419A9999B930595A41CDCCCCCC35CF2A419A9999192B595A419A9999999FCF2A41CDCCCCAC25595A419A999999FFCF2A41CDCCCC4C24595A41666666666DD02A419A99999924595A4133333333D2D02A41CDCCCC6C26595A419A9999992AD12A41CDCCCCEC29595A4100000000C8D12A416666668633595A41CDCCCCCC0DD22A41666666E639595A413333333336D22A419A99993937595A41CDCCCCCCBCD22A41CDCCCC6C40595A4166666666CDD22A41000000C042595A416666666620D32A419A9999B954595A41CDCCCCCC44D32A41666666E65E595A41CDCCCCCC5BD32A416666666669595A410000000062D32A41000000A074595A416666666659D32A41CDCCCCAC86595A419A999999C7D32A41666666A687595A4100000000C5D32A419A9999397D595A4100000000A4D42A416666664672595A419A999999D4D42A419A9999197C595A419A999999A9D52A419A99995984595A419A999999DBD52A41000000C07A595A41CDCCCCCC84D62A410000000083595A416666666635D62A41000000E099595A4133333333FBD62A419A9999B9A1595A41CDCCCCCCEED62A419A999999B0595A41CDCCCCCC8ED72A4100000040B1595A419A99999953D72A41333333D3C3595A41000000003DD92A41333333F3C6595A41666666662ED92A4100000020D6595A419A9999999CDA2A41000000A0E0595A4100000000B4DA2A41666666A6D6595A416666666640DB2A41333333B3D9595A419A99999960DC2A4133333393E2595A413333333330DE2A4133333333FF595A41666666665BDE2A4133333333FB595A416666666641DF2A41666666A6FF595A419A9999997DDF2A4100000000F0595A419A999999DDDF2A4166666626F8595A413333333318E02A419A9999D9FB595A41CDCCCCCC5DE02A419A999939FE595A4100000000B5E02A41000000A0F4595A41000000003EE12A41CDCCCCACE3595A410000000018E22A419A9999B9BF595A4100000000F2E32A419A999979C7595A410000000072E62A4100000000E9595A419A99999963E82A419A9999F9125A5A416666666632E92A41333333D3F5595A41CDCCCCCCAEE92A41666666C6D8595A413333333324EA2A41CDCCCC2CB8595A41666666669FEA2A41CDCCCC2CB7595A4133333333CBEB2A41000000E0B6595A416666666674EC2A41333333F3AD595A4166666666F3ED2A41333333D393595A4166666666EAEE2A41000000A090595A419A99999939EF2A419A99993990595A4133333333EFEF2A41CDCCCCAC90595A419A999999D6EF2A416666660687595A4166666666CAEF2A41333333B35C595A4133333333BAEF2A41333333D344595A41CDCCCCCCD0EF2A41333333F33F595A41333333338EED2A41CDCCCC4C3D595A410000000073ED2A410000004032595A413333333354ED2A41333333131B595A41CDCCCCCC4AED2A41000000C00E595A410000000025EC2A41CDCCCC0C16595A4166666666EAEB2A41666666E615595A413333333364EB2A41666666C60F595A4166666666A1EA2A41666666A601595A419A999999D3E92A419A999939F6585A410000000099E92A4133333373F1585A419A9999996CE92A419A999959F0585A41CDCCCCCCDFE92A41666666C6C3585A41CDCCCCCCBBE82A41000000A095585A41000000005DE82A41666666A694585A410000000001E82A41000000A090585A410000000045E72A419A9999D984585A4166666666A0E62A41666666A678585A419A999999CEE42A419A9999795D585A4166666666EBE42A419A9999394D585A41CDCCCCCCB0E42A413333337341585A419A999999AFE32A419A9999592E585A41666666661AE42A41666666A613585A41333333336CE42A416666662601585A419A9999998DE42A4100000000F6575A419A999999E8E32A41CDCCCC4CE8575A4166666666BEE22A41333333F3CD575A41CDCCCCCCBAE02A41000000C09F575A419A99999968E02A413333331397575A41CDCCCCCC29E02A419A9999198F575A410000000085E02A419A9999197D575A410000000090DF2A419A9999B968575A4100000000ABDF2A413333339351575A410000000022E22A413333333375575A41CDCCCCCC53E22A41666666A665575A41CDCCCCCCE1E02A419A99991953575A41CDCCCCCCA9DF2A416666662642575A416666666688DF2A419A99995937575A410000000076DF2A41CDCCCCCC2B575A41CDCCCCCC79DF2A410000004021575A413333333396DF2A416666664617575A419A99999967DF2A410000002016575A419A99999982DE2A41333333530D575A41CDCCCCCC89DD2A416666664600575A4133333333BADC2A419A999939F1565A41333333333EDC2A41333333B3F0565A41CDCCCCCC9BDB2A41666666C6F4565A41CDCCCCCCA3DA2A4133333373F2565A4133333333EFD92A419A9999F9F1565A41000000007BD92A419A9999B9F3565A4133333333F5D82A419A9999B9FA565A416666666681D82A419A9999B9FF565A419A99999915D82A41CDCCCCEC08575A41000000008ED72A41CDCCCCAC18575A410000000057D72A410000006024575A416666666693D62A41666666A616575A41CDCCCCCCFED52A419A99999905575A413333333382D52A41CDCCCCACFB565A419A999999AAD32A4166666686E1565A419A99999942D42A4166666606C0565A4133333333DCD42A419A9999B9A5565A419A9999995AD42A41CDCCCC2C9A565A416666666666D32A41CDCCCCEC86565A419A99999977D22A416666664677565A419A99999933D12A41666666E68D565A419A99999956CF2A4100000020B5565A4100000000D7CE2A41CDCCCC4CC2565A416666666677CE2A41CDCCCC2CC4565A41666666667ACE2A41666666C6CA565A41CDCCCCCCC9CE2A41333333B3CF565A419A99999951CE2A41666666C6DB565A4166666666E4CD2A41333333B3E7565A41CDCCCCCC65CE2A41333333D3FD565A416666666630CF2A41666666C625575A413333333369CF2A416666666630575A419A9999991BD02A41666666A676575A419A99999948CF2A41CDCCCCAC84575A4166666666C6CE2A41333333337C575A410000000092CE2A41CDCCCC0C77575A41666666660CCE2A416666660666575A4100000000BCCD2A41000000805D575A416666666680CD2A41CDCCCC4C59575A413333333333CD2A419A9999D956575A41666666662ACD2A419A9999B95A575A413333333364CD2A410000002069575A419A9999998BCD2A41666666E67B575A4100000000CFCD2A41CDCCCCEC9F575A4133333333E2CD2A41CDCCCC8CAF575A4100000000F9CD2A4133333373C9575A419A99999909CE2A41666666E6D3575A410000000041CE2A4100000080EA575A41000000006ECE2A41CDCCCC6CF8575A41CDCCCCCC61CB2A41000000201D585A419A99999908CD2A419A999939A0585A413333333397CD2A41CDCCCC8CC5585A4133333333EBCC2A4166666606CE585A41666666668ACB2A41CDCCCC2CE0585A41333333332DCB2A4133333333DF585A41CDCCCCCC50CA2A41333333B3D6585A416666666608CA2A4166666646E9585A416666666608CA2A4166666646E9585A41	01010000206A080000457F9F045CD82A416666665647585A41	550500000	Z	Bezonvaux	5505000	55050	55	44	9
01060000206A080000010000000103000000010000003D0100009A99999963912A41CDCCCC4C9F0F5A416666666647922A4100000000B20F5A41CDCCCCCC6F922A41333333F3B60F5A419A99999936922A419A999939E00F5A419A9999991A922A41000000C0FB0F5A419A999999FD912A41666666C609105A4166666666E3912A419A9999D91B105A4100000000B0912A41333333932B105A4133333333BA912A41333333532F105A4166666666E2912A416666660633105A416666666685912A419A9999F94B105A416666666654922A410000002052105A4100000000E1922A419A9999795A105A41000000000F942A41000000E07B105A419A9999994B942A41CDCCCC8C84105A419A99999969942A416666664683105A41000000003F952A41666666C668105A41CDCCCCCC6D962A410000000052105A410000000007972A41333333B364105A419A9999995C972A416666660660105A41CDCCCCCCFC972A41CDCCCCAC55105A416666666648982A41000000E06C105A41CDCCCCCCAD982A416666660683105A416666666622992A419A9999F97D105A4166666666BF992A419A99991972105A41CDCCCCCCD5992A41CDCCCC4C76105A41CDCCCCCCF4992A410000004085105A419A9999993A9A2A41CDCCCCEC83105A41CDCCCCCC689A2A416666668681105A41CDCCCCCCED9A2A41000000007B105A41CDCCCCCC289B2A41666666868A105A4166666666A6992A41666666069C105A4100000000CD992A419A999999A9105A4100000000AE992A4133333313AC105A410000000082992A4133333393AF105A41666666664C992A4166666686B4105A419A99999915992A4133333333B9105A4100000000BC982A4166666686C1105A4166666666A0982A416