SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep57;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep57 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep57','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep57','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep57','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep57"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000C96E0BA04CD02C419A999919485D5A41	570010000	Z	Aboncourt	5700100	57001	57	44	6
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	01010000206A0800003F9F0DC35AE12C419A9999C9052E5A41	570020000	Z	Aboncourt-sur-Seille	5700200	57002	57	44	4
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	01010000206A0800005A0786B91BB62E41CCCCCCFC5F195A41	570030000	Z	Abreschviller	5700300	57003	57	44	41
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	01010000206A080000E6B37148B0632D416666669671395A41	570040000	Z	Achain	5700400	57004	57	44	5
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	01010000206A08000097C6AA7CDDB02E419A9999A9B2495A41	570060000	Z	Achen	5700600	57006	57	44	12
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	01010000206A080000184DFC73100C2D4134333353A8425A41	570070000	Z	Adaincourt	5700700	57007	57	44	3
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	01010000206A08000066FC305BA7682D41343333D352435A41	570080000	Z	Adelange	5700800	57008	57	44	6
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	01010000206A08000012C594A646C12C41CDCCCC5CAE305A41	570090000	Z	Ajoncourt	5700900	57009	57	44	3
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	01010000206A0800003C2293EC22D42C410000005081365A41	570100000	Z	Alaincourt-la-Côte	5701000	57010	57	44	4
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	01010000206A080000885791B819032E41CCCCCC6CC43B5A41	570110000	Z	Albestroff	5701100	57011	57	44	19
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	01010000206A08000012B82AC8FB1E2C41CDCCCC5C70685A41	570120000	Z	Algrange	5701200	57012	57	44	7
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	01010000206A0800001ADB636E4B422E41000000604E575A41	570130000	Z	Alsting	5701300	57013	57	44	6
01060000206A08000001000000010300000001000000200100000000000091E62D4133333313DF475A41CDCCCCCCF8E62D4100000080E3475A4100000000F5E72D41333333F3EC475A419A9999990AE82D4133333333ED475A41CDCCCCCC0CE82D419A9999F9EA475A41666666664DE82D41CDCCCC2CD3475A41000000009FE82D419A999959BA475A4133333333C1E82D41CDCCCCACAE475A4133333333ECE82D419A9999B9A2475A419A99999923E92D41CDCCCC0C91475A419A9999993EE92D410000008086475A416666666626E92D410000008083475A4133333333D4E82D41333333737C475A41CDCCCCCCC8E82D41000000807B475A41CDCCCCCC26E82D41CDCCCCAC6E475A410000000015E82D41666666466D475A4100000000E1E72D41CDCCCCCC68475A4166666666CEE72D419A99993967475A41CDCCCCCC8AE72D41666666E661475A41000000002DE72D41000000A05C475A4100000000ABE62D410000006056475A410000000097E62D41CDCCCC4C55475A419A99999957E62D41CDCCCCEC51475A4133333333ECE52D41666666664B475A4133333333E4E52D419A99991949475A419A999999D7E52D410000002042475A4133333333E5E52D41333333D341475A4166666666D0E52D41333333D33E475A41CDCCCCCCBFE52D41333333D33B475A4166666666AAE52D416666668632475A4133333333AAE52D41000000402D475A4133333333ABE52D413333337321475A41CDCCCCCCBAE52D416666666614475A4166666666CBE52D410000008009475A4133333333E3E52D4166666606F6465A4133333333F2E52D419A999939F6465A410000000000E62D4166666646EB465A416666666603E62D41333333B3E6465A410000000008E62D41333333B3E0465A41000000000AE62D41CDCCCCECD9465A41000000000AE62D41CDCCCCACD6465A41CDCCCCCC13E62D4100000060D6465A41CDCCCCCC2EE62D41000000A0D6465A41000000006EE62D41333333B3D5465A41CDCCCCCC8AE62D4100000040D5465A41000000008BE62D41CDCCCC2CD5465A41333333338EE62D4166666606D4465A41CDCCCCCC93E62D4166666626CF465A41333333339DE62D41CDCCCCCCC6465A419A999999ACE62D41666666C6BB465A4166666666BAE62D4100000020B1465A41CDCCCCCCC1E62D41333333F3AA465A4100000000CAE62D419A999939AA465A419A999999DDE62D41CDCCCC2CA7465A416666666600E72D419A999919A1465A41666666661FE72D41666666A69B465A41CDCCCCCC2AE72D41CDCCCC4C9A465A41333333333AE72D416666668693465A416666666687E72D41333333F384465A41CDCCCCCCE5E72D41000000C06D465A41CDCCCCCC17E82D41CDCCCC4C61465A416666666656E82D410000006052465A416666666660E82D41333333F34F465A4133333333E0E82D419A99997931465A419A9999993AE92D41666666061B465A419A999999A2E92D419A99993901465A413333333377E92D41000000E0FC455A41CDCCCCCC89E92D4133333373F8455A419A999999C0E92D4166666666E8455A4133333333C7E92D4133333353E4455A4166666666F1E92D4166666646D9455A419A99999924EA2D41CDCCCCECCA455A419A99999991E92D4166666686BF455A41CDCCCCCC4EE92D419A999999B9455A419A999999DDE82D41CDCCCC6CC1455A419A99999970E82D41666666A6CB455A41CDCCCCCC0AE82D4100000060A6455A4133333333B5E72D4133333393A7455A4133333333B3E72D41CDCCCC0C99455A41CDCCCCCC53E72D41666666C691455A41CDCCCCCCFFE62D41333333338E455A41CDCCCCCCBCE62D419A99995998455A41666666667DE62D41000000C0B8455A41CDCCCCCCAAE52D41333333F3A6455A413333333358E52D41666666A6A2455A419A999999F2E52D41CDCCCCCC89455A41CDCCCCCC77E52D419A9999F97C455A41CDCCCCCC6EE42D41666666866A455A410000000057E42D419A99997967455A41666666664FE42D41000000606A455A413333333347E42D41666666C670455A41CDCCCCCC46E42D41CDCCCC4C71455A41CDCCCCCCC5E32D41666666C667455A41333333336BE32D41666666267F455A413333333345E42D41333333F38C455A416666666647E42D41000000C090455A41CDCCCCCC4EE42D410000006097455A410000000068E42D41666666A69F455A413333333323E42D4133333353A9455A410000000008E32D413333333394455A419A999999B8E22D4100000000A6455A4133333333BEE22D41CDCCCC6CA6455A419A99999904E32D419A9999F9AA455A410000000077E32D419A999919B3455A419A99999991E32D41333333F3B5455A4166666666C5E32D4166666606BA455A419A999999AAE32D41CDCCCC6CBF455A416666666681E32D41333333B3C7455A410000000035E32D419A9999B9C1455A41CDCCCCCC25E32D41333333B3C0455A41CDCCCCCCDEE22D4133333313BC455A4133333333D3E22D41666666A6BB455A4133333333C9E22D4100000080BB455A41CDCCCCCC71E22D41CDCCCCECCB455A41666666665EE22D4133333393CF455A419A9999990EE22D4100000080CC455A4133333333CDE12D419A9999D9C8455A41CDCCCCCCF6E02D41000000E0BC455A419A99999968E12D41666666069F455A41CDCCCCCC81E12D41000000209B455A4166666666A4E12D416666664692455A419A999999A9E12D416666668691455A4133333333B0E12D410000008091455A41CDCCCCCCCAE12D41666666268B455A419A99999916E12D41666666067C455A41CDCCCCCCAFE12D41333333335B455A410000000066E12D41333333B356455A41CDCCCCCCBAE02D419A9999D941455A41666666669FE02D41666666063F455A41333333338CE02D41333333333C455A41666666669AE02D41666666A639455A4166666666B0E02D416666668636455A4133333333DCE02D41666666A62F455A41666666660FE12D410000000029455A419A99999926E12D41CDCCCC8C25455A41CDCCCCCC38E12D413333331323455A41333333333EE12D41CDCCCC4C22455A419A99999974E12D416666660626455A410000000081E12D416666662624455A4133333333A5E12D419A9999991E455A419A999999E8E12D41CDCCCC6C14455A410000000002E22D416666668610455A419A99999925E22D419A99999909455A413333333332E22D41000000C007455A410000000052E22D410000006004455A41000000005AE22D413333335302455A413333333399E22D4133333373F7445A41CDCCCCCCC0E22D41000000A0ED445A41CDCCCCCCCEE22D4133333353E9445A4100000000D0E22D4166666646E7445A419A999999E2E22D4166666626E0445A4100000000E8E22D419A9999B9DE445A413333333307E32D41CDCCCC6CD6445A413333333316E32D4166666606D2445A41333333331AE32D41CDCCCCCCD0445A410000000024E32D4100000000CD445A41CDCCCCCC34E32D419A999979C3445A41666666663CE32D41CDCCCC0CBD445A410000000010E32D41000000A0BC445A4166666666C8E22D4166666646BB445A41CDCCCCCC78E22D4133333333B8445A41666666665AE22D41CDCCCC8CB6445A410000000041E22D4166666626B5445A419A999999ECE12D4166666666B1445A41CDCCCCCCA4E12D4100000000AF445A416666666639E12D41333333D3AA445A413333333304E12D41CDCCCCCCA8445A41CDCCCCCCF0E02D41CDCCCC2CA8445A41CDCCCCCC94E02D4100000040A5445A41666666665EE02D41666666C6A2445A41CDCCCCCC4EE02D41333333D3A1445A41000000002FE02D41333333D39F445A41CDCCCCCC05E02D41000000009E445A4166666666E3DF2D41000000409D445A4166666666D4DF2D41666666C69D445A41CDCCCCCCBEDF2D41000000809D445A416666666690DF2D41000000A09B445A413333333367DF2D419A99993999445A413333333349DF2D416666664696445A419A99999932DF2D41CDCCCCCC94445A41666666661FDF2D413333339393445A41CDCCCCCC14DF2D416666666692445A41CDCCCCCCA8DE2D416666666688445A410000000044DE2D41000000C083445A4166666666B4DD2D41666666E67C445A41CDCCCCCC18DD2D419A9999B975445A4133333333F7DC2D41666666E673445A4133333333A2DB2D416666662666445A4166666666A5DB2D41000000A068445A419A99999966DB2D41000000E0A3445A419A999999FEDA2D41CDCCCC0CC1445A413333333389DA2D41CDCCCC4CE1445A410000000076DA2D41CDCCCCCCE5445A41CDCCCCCC6ADA2D4100000020F0445A41CDCCCCCC66DA2D41666666C6F9445A419A99999968DA2D41333333B303455A413333333374DA2D416666660609455A41CDCCCCCC7CDA2D419A9999B90B455A4133333333B8DA2D41666666E624455A41CDCCCCCCB6DA2D41CDCCCC0C2A455A41CDCCCCCCB9DA2D41000000E031455A4100000000B8DA2D416666664635455A4166666666ABDA2D41666666663D455A4100000000A4DA2D41333333933F455A419A999999A6DA2D41CDCCCC8C40455A416666666696DA2D410000004041455A41666666665BDA2D41333333734D455A419A99999934DA2D41CDCCCC6C53455A413333333313DA2D416666660658455A410000000003DA2D41CDCCCC6C5A455A419A999999FAD92D419A9999B95B455A4100000000D3D92D41CDCCCCCC60455A4100000000A3D92D410000002066455A41333333336ED92D41CDCCCC0C6B455A410000000016D92D416666662672455A41CDCCCCCCE5D82D413333339377455A4166666666A2D82D41000000407E455A419A99999978D82D41CDCCCCAC83455A419A99999967D82D416666668686455A4133333333F8D72D41000000E0A6455A4133333333F3D72D419A9999D9A8455A419A999999DBD72D419A999919B0455A4133333333BCD72D41666666C6B8455A419A9999998BD72D41333333D3C2455A413333333376D72D41666666C6C7455A41333333336DD72D41CDCCCC4CCA455A419A99999966D72D41CDCCCCECCE455A41000000006AD72D41CDCCCC4CD4455A41666666666ED72D41CDCCCC8CD8455A41CDCCCCCC74D72D41333333B3DC455A4166666666A2D72D4100000060EF455A413333333312D82D4100000020FB455A4166666666AFD82D419A9999B908465A4166666666F5D82D41CDCCCC0C10465A4133333333B5D82D41666666C61E465A410000000072D82D41333333334E465A41CDCCCCCC44D82D41000000C062465A410000000014D82D41CDCCCC2C70465A4133333333EAD72D419A99997976465A419A999999BBD72D41CDCCCC4C7E465A4166666666A0D72D413333335382465A419A99999978D72D419A99993988465A4100000000F7D62D41666666869D465A41333333333DD82D4100000040CC465A413333333316D92D4166666646EA465A413333333395D92D4100000060FD465A4100000000CCD92D41666666C603475A41666666660ADA2D41CDCCCCAC0B475A41666666660FDA2D419A9999390C475A419A99999936DA2D413333339310475A4133333333CFDA2D41333333B320475A41CDCCCCCC54DB2D41000000802B475A416666666671DB2D419A9999D92C475A4100000000B7DC2D419A9999B948475A4133333333DADC2D419A9999B94B475A4133333333F4DC2D41333333F34D475A419A999999F2DC2D410000004052475A419A99999971DD2D413333331358475A41CDCCCCCCA6DD2D41333333935B475A41CDCCCCCCECDD2D41666666865D475A419A9999991DDE2D41666666665E475A41333333334EDE2D41666666C65F475A41CDCCCCCCA9DE2D419A9999D963475A410000000066DF2D41CDCCCC8C6C475A419A99999997DF2D41CDCCCCCC6F475A41CDCCCCCC0EE02D41000000607A475A419A999999F7E02D419A9999198F475A419A9999998FE12D419A9999999C475A4166666666B2E12D41666666869D475A41CDCCCCCCF0E12D41666666E69E475A41CDCCCCCCF9E12D41000000009F475A413333333342E22D4166666626A0475A41CDCCCCCC45E22D419A999939A0475A410000000096E22D4100000040A2475A419A999999E9E22D4100000080A4475A41CDCCCCCCF8E22D41CDCCCC0CA5475A41CDCCCCCC4FE32D41CDCCCC2CA8475A41CDCCCCCC9FE32D4166666666AA475A419A999999D8E32D4166666686AB475A413333333300E42D41000000C0AB475A4100000000F3E32D4133333373B3475A4166666666E5E32D4133333393BD475A4166666666E5E32D41666666C6BD475A41CDCCCCCCD3E32D419A9999D9C9475A413333333317E42D419A999979CB475A41CDCCCCCCB8E42D419A9999D9CF475A419A9999995AE62D41000000C0DC475A410000000091E62D4133333313DF475A41	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	01010000206A08000040128DE6D6E02D410000002028465A41	570140000	Z	Altrippe	5701400	57014	57	44	5
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	01010000206A080000AEDBA13AE7AE2D4134333393844A5A41	570150000	Z	Altviller	5701500	57015	57	44	5
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	01010000206A080000040A9FFA4E402D410000001018605A41	570160000	Z	Alzing	5701600	57016	57	44	5
01060000206A08000001000000010300000001000000500100000000000090102C41666666A659515A4100000000A4102C41666666465E515A410000000007112C413333337370515A413333333335112C416666666677515A419A99999953112C41666666E67C515A41CDCCCCCC71112C419A9999D981515A4133333333BC112C41CDCCCCCC89515A41CDCCCCCC56122C41666666E693515A41CDCCCCCC90122C41000000A096515A4100000000D7122C41CDCCCC8C98515A419A99999995122C4100000020A1515A419A9999996F122C4166666626A6515A4100000000D6122C41CDCCCC0CB0515A419A9999991C132C4100000000B7515A419A999999A3132C41000000E0CD515A419A999999CA132C4133333313DF515A4100000000C8132C419A9999D9FB515A419A99999995132C41000000A018525A413333333381132C413333337320525A419A99999995132C416666662622525A4100000000D8132C41333333B328525A4100000000F7132C41000000E02C525A41000000001D142C419A99999931525A41000000004F142C410000000037525A41000000008C142C41333333733D525A419A999999C3142C416666668643525A4166666666FE142C419A99997949525A416666666648152C41CDCCCC8C51525A410000000064152C41333333F354525A41CDCCCCCC73152C41333333F356525A4133333333B9152C419A9999D95E525A4100000000D0152C410000008061525A4166666666D9152C419A99999962525A4100000000E1152C41000000E063525A419A999999E9152C419A99997965525A410000000000162C413333335368525A41000000001D162C419A9999396C525A41666666664C162C410000006072525A41000000005D162C416666666674525A41000000006E162C410000000076525A419A99999988162C419A99993979525A419A999999BF162C419A9999B980525A4133333333CC162C41CDCCCC8C82525A419A9999990C172C41CDCCCC4C89525A410000000020172C41666666E68A525A413333333334172C41000000A08C525A4100000000D9172C410000002099525A4133333333FD172C419A9999199B525A419A9999995B182C41CDCCCC4C9F525A41CDCCCCCC59182C41666666E6A0525A41CDCCCCCCD2182C4166666606A6525A410000000048192C4166666666AB525A413333333362192C4100000080AB525A416666666665192C4166666666AB525A41000000008D192C41CDCCCC4CAA525A41CDCCCCCCD0192C4100000000A8525A4100000000091A2C41CDCCCC2CA6525A419A999999281A2C41CDCCCC8CA5525A4100000000531A2C4133333313A5525A41CDCCCCCC891A2C419A999919A5525A419A999999E71A2C4166666646A5525A41CDCCCCCC3C1B2C419A9999F9A5525A4100000000821B2C41000000E0A6525A41CDCCCCCCB11B2C41000000A0A7525A4133333333E01B2C41000000A0A8525A419A999999111C2C4100000040AA525A4133333333391C2C41CDCCCC2CAC525A41666666666D1C2C419A999979AF525A41000000008D1C2C41CDCCCC6CB1525A41000000009C1C2C41000000E0B1525A419A999999721C2C4100000080BC525A41666666669F1B2C4100000060F2525A4166666666A61B2C41000000A0F2525A4100000000701B2C413333337319535A41CDCCCCCC4F1B2C41CDCCCC6C31535A4166666666481B2C419A9999393B535A41CDCCCCCC761B2C41666666E63C535A41CDCCCCCCC01B2C41CDCCCC8C3E535A4133333333111C2C419A9999F940535A4166666666471C2C41000000A043535A41CDCCCCCC7B1C2C41CDCCCC4C47535A419A999999D21C2C413333337350535A4133333333211D2C41333333D357535A4133333333131D2C419A99999959535A4166666666061E2C41666666467C535A419A999999261E2C41333333337F535A419A9999999E1F2C4133333373A3535A4166666666D81F2C419A9999199A535A416666666628202C419A9999399E535A41333333335A202C41000000A09F535A41CDCCCCCC2A212C41666666A6A7535A41666666668E212C41CDCCCCACAE535A4100000000CD212C419A9999D9A8535A41CDCCCCCCA0222C41CDCCCC4CB6535A4133333333D4222C419A9999B9BB535A41000000005B232C41000000608F535A419A99999971232C410000006091535A41333333335E232C416666666698535A41CDCCCCCC63232C410000000099535A4166666666D8232C41333333B3A0535A413333333359242C41333333D3A8535A41CDCCCCCC3B262C4166666606C9535A41666666668C262C4100000020B6535A41CDCCCCCC8F262C4100000040A2535A410000000093262C413333335398535A410000000097262C419A99995995535A41000000009F262C413333335393535A416666666634272C41333333339F535A41666666665F282C4166666666B9535A4166666666FF282C419A999959C7535A416666666625292C419A999979C0535A413333333371292C41666666C6B1535A4133333333BC292C41666666E6A1535A41CDCCCCCC132A2C413333333392535A41666666661E2A2C416666668693535A41000000006C2A2C419A9999399C535A4166666666B02A2C419A999919A3535A4100000000E02A2C4133333373A7535A41CDCCCCCCF72A2C41CDCCCC6CA9535A4100000000032B2C4100000020AB535A41CDCCCCCC082B2C4166666666AC535A41CDCCCCCC082B2C41CDCCCC6CAD535A41CDCCCCCC062B2C41CDCCCCECAE535A41CDCCCCCC002B2C4166666626B1535A419A999999E62A2C419A9999B9B8535A41CDCCCCCCCB2A2C419A999979BF535A4166666666BE2A2C4100000080C2535A41CDCCCCCCB52A2C41CDCCCC4CC4535A419A999999972A2C41333333D3C8535A419A999999762A2C4133333333CE535A419A999999552A2C419A9999B9D3535A419A9999993F2A2C41CDCCCC0CD8535A419A999999392A2C419A999999D9535A4100000000312A2C41666666C6DB535A41000000002C2A2C4100000040DD535A419A999999272A2C419A999979DE535A41CDCCCCCC232A2C4166666626E0535A41CDCCCCCC222A2C419A9999F9E0535A419A999999222A2C4166666666E2535A41000000002D2A2C41666666A6E4535A419A9999993D2A2C419A999999E6535A4166666666552A2C4100000080E9535A41666666665E2A2C41000000E0EA535A4166666666622A2C41000000E0EB535A419A999999642A2C41CDCCCC0CED535A419A999999632A2C419A999999EE535A41333333336E2A2C4133333393EF535A41CDCCCCCC712A2C419A9999F9F0535A4166666666762A2C41CDCCCC4CF2535A41666666667F2A2C419A999979F3535A41CDCCCCCC8B2A2C419A999979F4535A4133333333B42A2C4100000080F7535A4100000000CD2A2C41333333D3F8535A4166666666E42A2C4133333393FA535A4100000000EE2A2C419A999979FC535A4166666666F32A2C41CDCCCC2CFE535A4166666666FA2A2C41CDCCCC6CFF535A419A999999042B2C416666668600545A41CDCCCCCC0E2B2C410000004001545A41CDCCCCCC192B2C413333333302545A41CDCCCCCC292B2C41CDCCCC4C05545A41CDCCCCCC322B2C41CDCCCCAC07545A41CDCCCCCC332B2C419A99991908545A4133333333482B2C41666666460B545A419A9999994E2B2C41666666460D545A41CDCCCCCC562B2C419A9999B90E545A4166666666612B2C413333333310545A41CDCCCCCC752B2C410000006012545A4133333333882B2C413333339314545A4166666666982B2C41000000C015545A41CDCCCCCCA92B2C41CDCCCCEC16545A41CDCCCCCCB92B2C416666660618545A4166666666CD2B2C419A99995919545A41000000002F2C2C416666660620545A419A999999DE2C2C41000000802B545A4100000000F02C2C41000000A02C545A41CDCCCCCC502D2C416666668633545A419A999999C32D2C41CDCCCCAC3B545A4100000000C32D2C41CDCCCC2C41545A41CDCCCCCC162E2C413333335348545A419A9999991A2E2C41000000A048545A4100000000E42E2C41666666E655545A4133333333312F2C419A9999F95A545A419A9999997D2F2C413333339355545A419A999999952F2C41666666E653545A41333333339B2F2C41333333134F545A419A9999999F2F2C41000000604B545A419A999999952F2C41000000203A545A41333333338D2F2C413333331332545A419A9999998B2F2C416666666630545A41CDCCCCCC912F2C416666666629545A4100000000B62F2C416666668621545A41000000008E2F2C41666666660F545A4133333333BB2F2C41CDCCCCECF4535A4100000000BC2F2C419A999979F4535A4133333333CD2F2C419A999939F0535A41CDCCCCCCE42F2C41CDCCCC6CEA535A41CDCCCCCC06302C41CDCCCC0CE2535A4100000000F72F2C41000000A0D3535A419A999999EC2F2C419A9999D9C9535A4166666666C72F2C41666666E6C4535A4133333333B22F2C41CDCCCC0CC2535A419A9999999C2F2C41CDCCCC2CBF535A41333333332C2E2C41CDCCCCCC8D535A4100000000232E2C41CDCCCC8C8C535A419A999999982E2C410000004083535A41CDCCCCCCA92E2C41000000E081535A41666666661F2F2C416666664679535A419A9999992A2F2C419A99997978535A4100000000AB2F2C41666666C669535A41CDCCCCCCE82F2C413333333367535A419A99999934302C413333335367535A413333333379302C41666666C65A535A4100000000CC302C41000000E049535A4100000000BA302C41666666A643535A41CDCCCCCCAB302C41666666263D535A41CDCCCCCC98302C413333339337535A419A99999972302C41333333D32E535A419A99999947302C41CDCCCCCC25535A41666666660F302C419A9999D917535A41CDCCCCCCDA2F2C41666666660B535A4100000000C92F2C413333331308535A419A9999998E2F2C4133333313EA525A41CDCCCCCC752F2C4100000020D7525A4166666666192F2C4133333313B2525A4166666666FB2E2C41666666E6A5525A4166666666B52E2C41CDCCCC4C89525A4100000000472E2C41CDCCCC4C69525A41CDCCCCCC142E2C41666666465E525A4133333333062E2C41333333135B525A4166666666E32D2C419A99999953525A416666666686332C4100000080AD515A41CDCCCCCC4A322C41CDCCCCAC83515A419A9999990A322C419A9999397A515A410000000032312C41CDCCCCCC59515A41000000005B312C419A9999F951515A41000000004E312C4133333373FA505A419A999999BD312C41666666E6EA505A41CDCCCCCC41322C41CDCCCCACE6505A410000000045332C41000000A0F4505A410000000091342C41666666261C515A419A999999DD342C41000000A020515A4100000000A8342C41333333931A515A41CDCCCCCC83342C419A9999F913515A413333333372342C41000000E00E515A41333333335F342C416666666609515A413333333332342C41333333B300515A413333333309342C41CDCCCC2CF9505A41CDCCCCCCDE332C4166666646F1505A4100000000D0332C41000000A0EE505A4100000000CC332C41CDCCCCECED505A4100000000BD332C4100000020EA505A4100000000A6332C41666666A6E4505A413333333391332C419A999999DF505A41CDCCCCCC7B332C419A9999B9DC505A41000000005E332C41CDCCCC2CD9505A416666666637332C4166666666D5505A41CDCCCCCC14332C4166666626D3505A4133333333F5322C4166666666D0505A4100000000CB322C41333333F3CC505A413333333390322C419A9999D9C8505A416666666658322C41CDCCCCECC4505A416666666626322C419A999999C1505A419A999999FA312C419A999979BE505A41CDCCCCCCD6312C4133333353BB505A41CDCCCCCCAA312C41333333D3B6505A419A99999984312C41666666E6B2505A419A99999967312C4133333373AD505A41333333335A312C4166666626AA505A416666666648312C419A999939A8505A419A9999994C312C41CDCCCC6CA7505A41CDCCCCCC37312C419A999979A6505A41333333331F312C41000000E0A5505A41666666660B312C419A9999B9A4505A4166666666F9302C4133333353A4505A4133333333ED302C4133333353A4505A4166666666E5302C41666666C6A3505A41CDCCCCCCDE302C4100000040A3505A4166666666CF302C41333333B3A2505A4100000000C6302C41666666A6A2505A4166666666BF302C41CDCCCC2CA2505A4133333333B9302C4133333393A1505A419A999999B7302C419A999999A1505A419A999999E72E2C41333333337D505A419A999999552E2C41333333F3A7505A41333333338B2C2C41000000E07B505A4100000000302C2C41333333B38A505A419A999999662B2C41666666865B505A4100000000CF292C413333331395505A4133333333B9292C41CDCCCCEC96505A41CDCCCCCC4E292C4100000020A2505A419A9999999A282C419A9999B9B5505A416666666696282C419A999939B6505A41000000002D282C41333333B3C0505A4133333333BE272C419A9999F9CB505A41CDCCCCCC4B272C419A9999F9D7505A419A99999907272C4133333333DF505A4133333333C6262C41CDCCCC4CE6505A41CDCCCCCCA0262C41000000C0E8505A419A9999993A262C4166666666F1505A419A999999B3252C41CDCCCCECFB505A4166666666A6252C41666666A6FC505A41CDCCCCCCA4252C41333333D3FC505A419A9999998C252C4133333373FF505A41333333333B252C41666666C604515A41CDCCCCCCAB242C41CDCCCC2C0A515A410000000076242C419A9999B909515A419A99999905242C419A99999905515A4166666666671F2C4100000060AF505A41000000005F1D2C41CDCCCC2C2E515A419A999999F91A2C419A99995911515A41CDCCCCCCF81A2C416666666611515A4100000000451A2C419A99997911515A4166666666111A2C41CDCCCC4C1F515A41CDCCCCCC0A1A2C41666666E620515A4133333333C0192C41000000C01E515A41CDCCCCCC5B192C419A9999191C515A419A99999907192C41CDCCCCAC18515A4133333333AB182C410000000014515A41000000004B182C41333333530F515A4100000000F1162C4166666666D7505A41CDCCCCCC82152C41CDCCCC2C25515A419A9999993E152C41CDCCCCEC26515A4166666666F5142C413333337329515A4100000000BF142C41666666C629515A41333333331C142C41333333B327515A419A9999997F132C419A99993927515A41333333333A132C419A9999392A515A4133333333B8122C41333333B331515A419A99999986122C41CDCCCC8C34515A41666666667C122C413333339335515A4133333333EB112C416666668640515A41666666664A112C41000000A04C515A4100000000FC102C413333335352515A419A999999C2102C419A99995956515A410000000090102C41666666A659515A41	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	01010000206A08000014ABE8CBD9212C41CCCCCCAC5C525A41	570170000	Z	Amanvillers	5701700	57017	57	44	10
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	01010000206A080000A947E1FA122B2D41343333D3B3305A41	570180000	Z	Amelécourt	5701800	57018	57	44	8
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	01010000206A080000A635232F4A4A2C41333333538E5D5A41	570190101	H	Centre	5701901	57019	57	44	3
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	01060000206A08000001000000010300000001000000220000006666666656572C41333333D39A5D5A41CDCCCCCC15582C419A9999F99F5D5A410000000079582C419A999959A15D5A416666666617592C419A999979A05D5A4133333333055A2C419A9999B99B5D5A41CDCCCCCCAF5A2C41333333739A5D5A4133333333105C2C4133333373A05D5A419A9999990C5C2C41CDCCCC2C975D5A41666666661A5C2C41000000E0805D5A41CDCCCCCC265C2C419A999959655D5A4100000000835C2C41CDCCCC2C2D5D5A4166666666D35C2C41333333132F5D5A4166666666675D2C419A999919E35C5A4133333333545D2C4166666686E25C5A41CDCCCCCC915D2C419A9999F9C25C5A419A9999999D5D2C4100000080BA5C5A419A9999995C5D2C4100000000AD5C5A4166666666675C2C41000000E0975C5A4100000000245C2C419A999979A15C5A419A999999CF5B2C419A9999D99F5C5A41CDCCCCCCBD5A2C41333333B39C5C5A419A999999B25A2C41000000C09A5C5A4166666666B45A2C419A9999D9915C5A419A999999D2582C41000000608C5C5A413333333394582C41CDCCCCAC8C5C5A41666666667A582C41333333B3845C5A419A99999947582C419A9999B9825C5A41000000002D582C4100000020AB5C5A416666666617582C4133333353C75C5A4166666666FF572C4166666646E05C5A419A999999D4572C4166666686125D5A419A99999988572C41666666C6675D5A416666666656572C41333333D39A5D5A416666666656572C41333333D39A5D5A41	01010000206A0800001EE4D174745A2C41666666460F5D5A41	570190102	H	Est	5701901	57019	57	44	1
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	01010000206A0800005C5BCFF930282C4100000030AE585A41	570190103	H	Ouest	5701901	57019	57	44	7
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	01010000206A080000E36676BE8BEF2C41CDCCCC3C49455A41	570200000	Z	Ancerville	5702000	57020	57	44	5
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	01010000206A0800004C6033C1AA282C4166666606C7475A41	570210000	Z	Ancy-Dornot	5702100	57021	57	44	10
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	01010000206A0800004838A57956192C41343333331D6B5A41	570220000	Z	Angevillers	5702200	57022	57	44	9
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	01060000206A080000010000000103000000010000009400000066666666BA872C419A9999B9AE565A41CDCCCCCCD2872C41CDCCCC8CCD565A416666666625882C4100000080FB565A410000000077882C41666666262C575A419A99999999882C41333333134E575A419A999999D9882C41CDCCCCCC49575A41666666663B892C41000000E04E575A41666666666B892C41CDCCCC0C53575A4166666666AF892C413333337355575A41000000004B8A2C41CDCCCC2C52575A419A9999996C8A2C419A9999594E575A41CDCCCCCCD78A2C41CDCCCC2C4D575A41CDCCCCCC078B2C41000000404A575A41333333335A8B2C41333333D340575A4100000000B88B2C41CDCCCC4C44575A4133333333E18B2C419A9999D93A575A4166666666308C2C41000000002D575A4133333333578C2C41333333D320575A4166666666D68C2C41333333B3FC565A419A999999CA8F2C41CDCCCC2C0D575A41666666668F902C41000000C019575A419A99999919932C41666666C658575A41CDCCCCCC77932C41666666864E575A4100000000B8932C41CDCCCC0C44575A4133333333D7932C41CDCCCCEC3C575A4133333333F8932C41333333D338575A41CDCCCCCC6D942C41333333D323575A413333333399942C41CDCCCCCC28575A4133333333BF942C41000000A02F575A419A999999EF942C419A9999D93B575A419A999999F4952C41CDCCCCAC23575A41CDCCCCCCE4962C419A9999F937575A4133333333C0962C41000000404C575A4133333333BC962C41CDCCCC6C52575A416666666616972C41000000E052575A41666666669C972C419A9999F956575A413333333346982C419A9999795E575A413333333376992C416666668676575A41CDCCCCCC029A2C410000004081575A41000000005A992C419A99993998575A41000000002B992C419A9999599F575A4133333333A8992C41666666A6AF575A4133333333B2982C4133333393C7575A413333333335982C419A999919D2575A4133333333D4962C41CDCCCC2CE8575A413333333346972C419A99999909585A41CDCCCCCC9F962C41000000A016585A419A99999954972C419A99997938585A41CDCCCCCCF2972C41666666C631585A41CDCCCCCC25982C413333339348585A41CDCCCCCC4F982C419A9999B94C585A416666666675982C41000000004D585A41CDCCCCCCCF982C416666662648585A419A9999997B992C41000000C03B585A41333333330C9A2C41333333732D585A4166666666589A2C419A9999B939585A4100000000229B2C419A9999991E585A419A999999E39A2C413333335319585A4166666666ED9A2C413333339313585A41CDCCCCCC729B2C41CDCCCC0C00585A4100000000019C2C4100000080EE575A4133333333779C2C41666666E6E5575A419A999999B79C2C419A999939DE575A41000000000F9D2C41333333B3D0575A41CDCCCCCC399D2C4166666606CF575A419A999999099E2C4100000040D4575A41666666660BA02C419A9999F998575A41CDCCCCCCE2A02C41333333B394575A410000000025A32C41666666868A575A41CDCCCCCC7EA32C413333337388575A41666666660BA42C41CDCCCC8C5D575A41CDCCCCCC13A32C41CDCCCC4C52575A416666666693A22C41CDCCCC0C4C575A41CDCCCCCC01A32C41666666A6F5565A41666666662BA32C4100000040CA565A4100000000B8A22C41333333B3BD565A41000000005CA22C4100000020B2565A4133333333AFA12C4166666686A0565A41CDCCCCCCB7A12C41CDCCCCEC8A565A41CDCCCCCC43A02C41CDCCCCCC94565A419A9999994E9F2C413333339396565A4166666666D69E2C419A9999B988565A419A999999AC9D2C41333333737D565A41666666664B9D2C419A9999D97B565A4100000000599D2C419A9999D976565A4100000000DF9C2C41CDCCCC0C73565A4166666666629C2C41CDCCCC2C68565A4100000000449C2C41333333D361565A419A999999DE9A2C41CDCCCC2C4D565A419A999999469A2C416666660657565A413333333350992C41666666E647565A41666666663F992C416666668637565A41CDCCCCCC29992C41CDCCCCAC29565A41CDCCCCCC1C992C419A9999B919565A416666666613992C416666664616565A416666666609992C4166666626C1555A41CDCCCCCCD6982C419A9999B9C3555A416666666677982C419A999959C3555A419A99999931972C4100000000C0555A41CDCCCCCC23962C41CDCCCC8CBC555A41CDCCCCCCCE952C41666666E6BF555A4166666666A4952C419A9999F9C5555A41CDCCCCCC0C952C4100000060D5555A419A999999C2942C419A999959DB555A41CDCCCCCC2D942C41666666C6E1555A41CDCCCCCC8B932C4166666606E6555A4100000000D6922C4166666686E8555A419A99999907922C4133333313E9555A41000000007E912C4166666646E8555A419A999999EB902C4166666646E9555A41CDCCCCCCD2902C41666666A6EA555A4133333333B5902C419A9999D9E0555A419A99999985902C4166666686E1555A41CDCCCCCCB78F2C4100000060CE555A419A9999997B8F2C41CDCCCCECC7555A419A999999448F2C4166666646CD555A4133333333AB8E2C41333333B3D7555A41000000003E8E2C4100000080DC555A419A999999D38D2C4100000080DA555A4166666666638D2C41CDCCCCCCD6555A41666666663F8D2C41CDCCCC4CD4555A4133333333508D2C41CDCCCC4CDD555A419A9999992B8D2C4133333373DC555A4100000000008D2C419A999919EA555A419A999999DF8C2C41CDCCCC2CEB555A419A999999EA8C2C416666668603565A419A999999308C2C410000004007565A419A9999996E8B2C41000000E00C565A4166666666D08A2C419A9999B915565A419A999999B2892C41CDCCCCEC28565A416666666643892C419A9999590F565A41CDCCCCCCF8882C41CDCCCC4C06565A416666666686882C41000000E000565A41333333337F882C41666666E604565A4166666666AC882C419A99997910565A41CDCCCCCCCC882C41333333B31E565A4100000000C9882C419A9999D929565A4100000000B1882C41666666E62D565A419A999999A9882C41000000A036565A41CDCCCCCC70882C41CDCCCC6C46565A410000000072882C419A9999594F565A419A99999933882C41333333335D565A41CDCCCCCC20882C410000006063565A419A99999916882C41CDCCCC8C74565A419A999999F0872C419A99995988565A41CDCCCCCCEA872C419A9999B994565A4166666666BA872C419A9999B9AE565A4166666666BA872C419A9999B9AE565A41	01010000206A0800002ED882569F982C41CDCCCCEC04575A41	570240000	Z	Antilly	5702400	57024	57	44	5
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	01010000206A080000E062EDCE7F0C2D41CDCCCC7C575F5A41	570250000	Z	Anzeling	5702500	57025	57	44	6
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	01010000206A08000000886217F2DB2C4166666646B9735A41	570260000	Z	Apach	5702600	57026	57	44	3
01060000206A080000010000000103000000010000007C0100006666666667422D41CDCCCC4C25415A41333333336B422D41666666E624415A410000000088422D416666662623415A413333333399422D419A9999D922415A4133333333AB422D413333337322415A419A999999AB422D419A9999191D415A41CDCCCCCCEA422D41000000601D415A416666666611432D41CDCCCC4CFD405A41CDCCCCCCB6422D41CDCCCCACFB405A416666666688422D4166666646FA405A413333333386422D41000000C0F4405A413333333386422D4133333313EC405A4166666666DC422D41CDCCCC2CEE405A413333333305432D41CDCCCC2CEF405A41CDCCCCCC24432D419A999959E0405A419A99999959432D41CDCCCCCCCC405A419A99999955432D4133333313CC405A41000000004C432D419A999959CB405A419A99999998422D419A999939C3405A41000000006A422D419A9999F9C1405A41666666668B422D4100000000AD405A41CDCCCCCC07432D41000000A0A9405A41000000001F432D41CDCCCCECA6405A419A9999996E432D419A9999B99D405A419A999999B2432D41666666A68D405A4100000000C4432D41CDCCCC8C89405A4166666666A9432D416666662688405A4100000000A2432D41000000C087405A416666666626442D410000002067405A416666666640442D41666666E667405A41333333337A442D419A9999D94C405A41CDCCCCCC84442D410000000048405A416666666681442D41333333F346405A410000000082442D41CDCCCCCC43405A410000000083442D416666664640405A41000000007E442D41000000C034405A419A99999972442D413333339328405A413333333365442D419A9999B920405A416666666665442D41333333D31E405A419A9999996B442D41666666261E405A413333333396442D41333333331C405A41CDCCCCCCAC442D41CDCCCC2C1B405A4133333333D2442D41666666C618405A419A9999991F452D416666660613405A41CDCCCCCC39452D410000008010405A41CDCCCCCC61452D41333333930A405A41CDCCCCCC73452D410000008007405A41CDCCCCCC83452D41333333B303405A4166666666BC452D41666666E6FA3F5A41CDCCCCCCCF452D4133333393F83F5A4100000000E2452D41000000A0F53F5A41666666660E462D41666666A6EC3F5A410000000024462D4133333313E93F5A419A99999962462D419A999939E33F5A41CDCCCCCC94462D419A9999D9DF3F5A4100000000E8462D419A9999F9D83F5A419A999999FA462D419A999939D73F5A41666666661C472D41000000C0D13F5A416666666620472D41CDCCCCECCF3F5A41000000001C472D41CDCCCCECC83F5A41666666662F472D4133333353C53F5A41CDCCCCCC35472D41CDCCCC8CC33F5A419A99999937472D4133333353BF3F5A410000000035472D4100000080BD3F5A410000000012472D41000000C0B93F5A41CDCCCCCC0A472D41666666C6B73F5A410000000002472D4166666646AA3F5A416666666603472D4133333353A73F5A41CDCCCCCC09472D41CDCCCCECA13F5A41CDCCCCCC10472D41CDCCCCCC9F3F5A419A9999991D472D419A9999599D3F5A410000000036472D41CDCCCCEC963F5A419A9999994D472D4166666626923F5A410000000054472D41000000608F3F5A416666666659472D419A9999F98C3F5A41000000005D472D41CDCCCCCC893F5A419A99999955472D41CDCCCC2C833F5A419A99999949472D41000000207F3F5A419A99999930472D41333333537A3F5A419A9999990E472D41000000A0743F5A419A999999FA462D41333333336D3F5A4166666666D7462D419A9999196A3F5A41CDCCCCCCC6462D419A999999673F5A419A999999C1462D4133333333663F5A4166666666E0462D41CDCCCC4C613F5A410000000005472D41000000805C3F5A419A9999990B472D41000000005B3F5A416666666607472D41000000E0593F5A41CDCCCCCCDF462D41666666E6553F5A4100000000CF462D41CDCCCCCC533F5A41CDCCCCCCA0462D41CDCCCC8C4D3F5A41333333338E462D41CDCCCC0C4A3F5A41CDCCCCCC7A462D41CDCCCCAC443F5A419A99999975462D4133333313413F5A41CDCCCCCC77462D41666666C63C3F5A41CDCCCCCC7D462D41666666C6303F5A41CDCCCCCC7C462D41000000A02E3F5A41CDCCCCCC76462D41333333D32C3F5A413333333373462D41333333932A3F5A41CDCCCCCC73462D419A999979283F5A41666666666F462D41CDCCCCAC243F5A41CDCCCCCC6F462D41333333D3203F5A419A9999997D462D4166666646183F5A416666666679462D419A9999B9173F5A419A99999956462D41CDCCCCCC163F5A41CDCCCCCC41462D41000000C0163F5A4133333333F6452D41333333D3143F5A410000000081452D4100000000133F5A41000000004C452D4166666626113F5A413333333318452D41333333530E3F5A4166666666D1442D41333333D30B3F5A419A999999A7442D41CDCCCC0C0B3F5A41666666669D442D41666666460E3F5A41000000004F442D4133333373113F5A419A9999992F442D41333333F3093F5A410000000026442D41666666E6093F5A4166666666FF432D4100000060093F5A4100000000F7432D419A9999F9083F5A410000000015442D4133333353083F5A41CDCCCCCC2B442D4133333353063F5A41666666663F442D41CDCCCC4C043F5A419A99999958442D4166666606003F5A41CDCCCCCC80442D419A999919F83E5A419A999999A3442D41666666A6EF3E5A4133333333BE442D41000000A0EA3E5A4133333333B8442D419A999919EA3E5A416666666642442D41CDCCCCACDF3E5A41CDCCCCCC02452D41666666E6DD3E5A419A99999906452D419A9999D9DD3E5A41000000005B452D4133333373D93E5A41CDCCCCCC5A452D41000000A0D83E5A413333333350452D41CDCCCC2CBB3E5A41666666665D452D419A9999D9AA3E5A416666666621452D4166666626A93E5A419A9999995E452D4166666626743E5A419A99999973452D41CDCCCC0C4F3E5A41CDCCCCCCFF452D4166666666473E5A410000000023462D4100000080463E5A410000000063442D41333333732E3E5A41666666666E442D41000000402A3E5A410000000082442D4100000060253E5A419A99999987442D4166666606243E5A419A9999999F442D41CDCCCCCC1B3E5A41666666664F442D419A9999391E3E5A4133333333D3432D41333333F3213E5A416666666688432D4133333333243E5A413333333382432D41000000001A3E5A41333333332B432D41000000C01A3E5A41CDCCCCCCC6422D419A9999391C3E5A4133333333AD422D4133333333163E5A419A9999996A422D4100000080063E5A413333333341422D419A9999B9FC3D5A419A9999999C412D41666666C6E33D5A413333333378412D4133333393DC3D5A419A999999E2412D4100000040CF3D5A4100000000CC412D419A999979CB3D5A41333333332D412D4166666686B93D5A41CDCCCCCC59402D41CDCCCC2CA33D5A4166666666DC3F2D41CDCCCC2C9D3D5A419A999999C13F2D41000000E0A63D5A41000000006E3F2D419A999939C13D5A419A9999998D3F2D41666666E6C53D5A41666666669F3F2D4100000020C93D5A4166666666AF3F2D4100000020CC3D5A4100000000C13F2D4100000060CF3D5A4100000000D43F2D41CDCCCC2CD43D5A4100000000E73F2D41000000A0DA3D5A4166666666EB3F2D4133333353DC3D5A4100000000F03F2D4100000020DF3D5A4100000000F23F2D419A999919E13D5A41CDCCCCCCF33F2D41333333F3E23D5A41CDCCCCCCF13F2D4166666606E73D5A4100000000ED3F2D41CDCCCC4CEA3D5A41CDCCCCCCDC3F2D4133333393EE3D5A419A999999C23F2D41CDCCCC6CF23D5A4166666666973F2D41CDCCCC4CF83D5A4166666666713F2D41CDCCCC2CFD3D5A4133333333663F2D419A999919FF3D5A41CDCCCCCC5C3F2D419A9999B9003E5A41CDCCCCCC4F3F2D41666666C6043E5A4166666666363F2D41000000E00E3E5A41333333332D3F2D4133333353133E5A4166666666913E2D41CDCCCC0C0D3E5A419A999999AC3D2D41CDCCCC2C013E5A4133333333AC3D2D4133333353023E5A419A999999A53D2D41CDCCCC8C033E5A4100000000633D2D41666666660E3E5A4100000000683D2D41333333931B3E5A4133333333723D2D4100000020373E5A419A9999997C3D2D41333333B3523E5A41CDCCCCCC863D2D41000000406E3E5A41CDCCCCCC6D3D2D419A9999796E3E5A41333333331E3D2D41CDCCCC2C6F3E5A4133333333E93C2D4100000000703E5A41CDCCCCCC653C2D4166666626733E5A41666666661F3C2D41333333D3743E5A4133333333D93B2D4100000020763E5A419A999999AC3B2D41CDCCCC8C763E5A4100000000983B2D4166666686763E5A4166666666203B2D41CDCCCC6CB33E5A419A999999AA3B2D419A9999B9B23E5A41CDCCCCCCCC3A2D419A9999B9BE3E5A4100000000C43A2D4133333313B83E5A419A999999C03A2D419A999979B53E5A4133333333243A2D419A999939B83E5A419A999999A0392D4133333333BA3E5A41CDCCCCCC9D392D419A999959BD3E5A41333333338C392D4133333353D13E5A41CDCCCCCC72392D4100000040EE3E5A419A99999972392D4166666686EE3E5A413333333372392D4100000040EF3E5A41666666665D392D41CDCCCCECEF3E5A41000000004E392D41CDCCCC0CF13E5A413333333334392D41666666C6F13E5A41000000000E392D419A9999F9F03E5A419A999999E3382D419A999999EE3E5A41CDCCCCCCD4382D41CDCCCCECED3E5A41CDCCCCCCD8382D41CDCCCCACEE3E5A419A999999E9382D41CDCCCCACF23E5A4133333333ED382D4166666666F33E5A4166666666FB382D4133333373F43E5A416666666604392D4133333373F63E5A41CDCCCCCC06392D419A999979F83E5A410000000010392D419A999919FA3E5A410000000021392D4100000060FE3E5A413333333322392D4166666606013F5A416666666626392D419A9999D9013F5A41CDCCCCCC2B392D4133333313023F5A410000000039392D41333333F3013F5A413333333341392D4166666646023F5A416666666645392D41333333D3023F5A419A99999948392D419A999939043F5A410000000040392D4100000040073F5A41666666664A392D4133333333083F5A413333333371392D4166666626083F5A410000000078392D419A999979083F5A419A9999997B392D4133333313093F5A41000000007B392D41333333730A3F5A41666666666E392D419A9999590D3F5A41666666666D392D41333333F30D3F5A41333333336F392D41666666660E3F5A410000000095392D41666666A6103F5A41CDCCCCCCAA392D41666666C6123F5A4166666666AB392D4100000060143F5A4133333333A0392D41333333D3163F5A419A9999999E392D4133333393183F5A41CDCCCCCCA6392D41CDCCCCEC183F5A4133333333C1392D41333333931B3F5A419A999999D6392D41000000E01C3F5A419A999999E8392D41000000001F3F5A4166666666E7392D41CDCCCCCC1F3F5A41CDCCCCCCD8392D41666666E6203F5A4133333333D7392D4166666666223F5A4133333333F7392D41666666E62E3F5A4166666666FE392D4133333373333F5A4133333333FE392D419A999979353F5A4166666666F4392D4166666646373F5A419A999999D5392D41333333D3393F5A41CDCCCCCCCF392D419A9999993A3F5A419A999999D0392D41000000C03F3F5A4100000000C3392D41000000804A3F5A419A999999BB392D41666666264C3F5A419A999999B0392D41CDCCCC8C4D3F5A4100000000AB392D41000000004F3F5A4166666666B3392D4100000000513F5A419A999999B4392D419A9999F9513F5A419A999999AE392D419A999919533F5A4133333333A4392D4100000020543F5A416666666698392D41CDCCCCAC543F5A413333333397392D41CDCCCCEC553F5A41666666668E392D419A999959593F5A416666666689392D41333333335C3F5A41666666668E392D41333333F35E3F5A41333333338D392D41CDCCCCEC603F5A419A99999974392D41CDCCCC2C653F5A41666666666A392D41CDCCCC4C683F5A413333333366392D41000000606A3F5A413333333368392D41CDCCCCEC6B3F5A419A99999966392D41333333736D3F5A410000000057392D4133333373703F5A413333333366392D41333333B3783F5A416666666662392D41000000E0793F5A41333333335A392D41666666267B3F5A419A99999940392D41CDCCCC2C893F5A41CDCCCCCC2B392D41666666A68E3F5A416666666604392D419A999979A13F5A410000000002392D419A9999F9A23F5A419A99999903392D41666666C6A73F5A4133333333FE382D41CDCCCCCCA93F5A419A99999900392D41333333F3AC3F5A41CDCCCCCCFA382D4133333393AE3F5A419A999999EB382D419A999959B03F5A41CDCCCCCCE9382D419A9999B9B23F5A4166666666F4382D419A9999B9B63F5A4166666666F1382D41666666E6B83F5A419A999999D8382D419A9999F9BE3F5A419A999999D6382D419A9999D9C03F5A4100000000D9382D41666666A6C33F5A419A999999D7382D4100000080C63F5A4100000000D1382D4166666626C93F5A4100000000C6382D4133333373CB3F5A4100000000C8382D41666666A6CD3F5A4100000000CE382D4133333393CF3F5A4166666666C1382D419A999919D23F5A41000000008C382D419A999919F03F5A413333333321392D41CDCCCCECF73F5A416666666632392D4133333353F73F5A413333333353392D41000000A0F73F5A41CDCCCCCC5F392D4166666666F73F5A419A99999965392D4166666646F63F5A41333333336B392D4133333393F83F5A41666666666E392D41CDCCCCECF93F5A41CDCCCCCC6C392D41CDCCCCECFB3F5A416666666671392D416666664601405A41666666666D392D41333333B309405A41CDCCCCCC71392D41000000A00C405A41666666667F392D41000000A010405A419A9999997F392D41CDCCCC6C15405A419A9999997A392D413333337317405A419A99999976392D41000000201C405A410000000081392D41666666A623405A410000000082392D416666662626405A416666666680392D419A99997928405A413333333382382D41666666A626405A41666666669D382D419A99995915405A419A99999941382D41CDCCCC2C15405A4100000000DA372D41666666C651405A4100000000F4372D41666666C652405A419A999999E5372D416666668658405A4166666666A9372D413333339370405A41333333330D372D41000000E09B405A410000000061372D4100000080A0405A4166666666D5372D419A999979A6405A41CDCCCCCC9C372D41666666C6B6405A41333333339B372D4166666666BA405A4100000000C7372D419A999919BD405A4133333333F9372D4100000020BF405A419A99999919382D4100000040C1405A413333333323382D4133333353C2405A416666666650382D4166666686C7405A416666666659382D4166666686C8405A419A99999964382D419A999979C9405A410000000078382D419A999919CB405A41333333333D3A2D41666666C6F0405A4133333333593A2D4133333313F3405A4100000000753A2D41CDCCCC6CF5405A41CDCCCCCC833A2D41000000A0F6405A4166666666023B2D416666668600415A41666666661E3B2D413333335302415A4100000000523B2D41666666E603415A4133333333CC3B2D41CDCCCC8C0A415A4166666666003C2D41666666260D415A4133333333493C2D413333339310415A4100000000783C2D41000000201D415A41CDCCCCCCF03C2D410000008023415A41CDCCCCCCE53C2D41000000E033415A4166666666DA3C2D410000008045415A41CDCCCCCC953C2D419A9999593F415A419A9999999E3C2D413333331346415A41CDCCCCCC523C2D41CDCCCCAC48415A41CDCCCCCC203D2D41333333135D415A41000000008F3D2D41CDCCCC6C68415A4133333333EA3D2D41CDCCCC2C72415A4100000000213E2D419A99997977415A419A999999EC3D2D41333333D384415A4100000000EE3D2D41CDCCCCEC84415A4133333333893E2D419A99995991415A41CDCCCCCCD83E2D419A9999B997415A4133333333DF3E2D41CDCCCC0C95415A419A999999043F2D41000000A08F415A41666666661B3F2D41666666068C415A419A999999233F2D41666666068A415A41CDCCCCCC2F3F2D41333333B387415A41CDCCCCCC813F2D41CDCCCC6C77415A4133333333A63F2D41666666C67A415A4100000000D43F2D41333333B37D415A4166666666B1402D419A9999B94D415A419A9999994C402D41666666A646415A410000000008412D419A9999D915415A416666666667422D41CDCCCC4C25415A41	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	01010000206A080000BA364FC71E402D41343333239A3F5A41	570270000	Z	Arraincourt	5702700	57027	57	44	5
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	01010000206A080000F5E6F7A26F7F2C41000000A0F9565A41	570280000	Z	Argancy	5702800	57028	57	44	11
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	01010000206A080000F2987771FA2D2D41CDCCCCECDF435A41	570290000	Z	Arriance	5702900	57029	57	44	7
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	01010000206A0800007C0F52D7CF2F2C419A99993914405A41	570300000	Z	Arry	5703000	57030	57	44	7
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	01010000206A080000B282537A6DA12C419A999919BC4A5A41	570310000	Z	Ars-Laquenexy	5703100	57031	57	44	6
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	01010000206A08000038DCF888E1142C41000000F0354A5A41	570320103	H	Sud	5703201	57032	57	44	10
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	01010000206A080000B0389CF9E5352C419A9999C9C7495A41	570320104	H	Nord	5703201	57032	57	44	2
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	01010000206A0800006358D4B228B12E419A99996953265A41	570330000	Z	Arzviller	5703300	57033	57	44	5
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	01010000206A0800006ABC74B392472E41CDCCCC4C251E5A41	570340000	Z	Aspach	5703400	57034	57	44	4
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	01010000206A0800003086452DBDE32D41666666A6B3295A41	570350000	Z	Assenoncourt	5703500	57035	57	44	17
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	01010000206A08000086244EBA72F32C419A999979472B5A41	570360000	Z	Attilloncourt	5703600	57036	57	44	3
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	01010000206A080000B9E186DB95CE2C41666666D67F445A41	570370000	Z	Aube	5703700	57037	57	44	5
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	01010000206A080000E0B25568C5E82B4100000010A9725A41	570380000	Z	Audun-le-Tiche	5703800	57038	57	44	15
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	01010000206A08000054DE73D1D74C2C41343333C3CA465A41	570390000	Z	Augny	5703900	57039	57	44	15
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	01010000206A0800002F6C00F1EACD2C41000000F0BB325A41	570400000	Z	Aulnois-sur-Seille	5704000	57040	57	44	5
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	01010000206A08000058EF092F0FE32B41CDCCCCCCD96D5A41	570410000	Z	Aumetz	5704100	57041	57	44	10
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	01010000206A080000D4F431311EE92D4166666646081E5A41	570420000	Z	Avricourt	5704200	57042	57	44	10
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	01010000206A0800009B9B185CE9742C4134333343085C5A41	570430000	Z	Ay-sur-Moselle	5704300	57043	57	44	5
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	01010000206A080000C465703229EF2D419A999969E1255A41	570440000	Z	Azoudange	5704400	57044	57	44	16
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	01010000206A080000449BE5434CF92C41343333C3293A5A41	570450000	Z	Bacourt	5704500	57045	57	44	4
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