SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep58;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep58 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep58','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep58','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep58','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep58"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A08000001000000010300000001000000510300000000000046CB26419A999979667059419A99999949CB2641000000C068705941CDCCCCCC53CB26419A9999396B7059410000000058CB2641CDCCCCEC6C7059419A99999983CB2641CDCCCCEC777059419A99999985CB264100000000797059416666666685CB2641CDCCCC2C7A705941CDCCCCCC84CB26419A9999997B7059410000000087CB2641666666867D7059413333333389CB2641333333D37E7059419A9999998DCB264133333353807059413333333397CB26410000006082705941333333339CCB26413333339384705941666666669CCB2641666666C6857059413333333396CB2641000000A0877059413333333390CB2641CDCCCC2C8A7059419A99999990CB2641666666E68B7059410000000094CB2641666666868E705941CDCCCCCC95CB26419A99991996705941CDCCCCCC96CB26419A999919987059416666666694CB26419A9999F9997059413333333391CB2641666666869B7059416666666689CB26419A9999399E7059410000000082CB2641333333D3A0705941CDCCCCCC7ECB264133333353A2705941333333337DCB26419A999999A5705941000000007CCB264166666606A8705941CDCCCCCC7ECB26419A9999D9AA7059416666666682CB2641CDCCCCECAC705941000000008BCB2641000000A0AE705941000000008FCB2641CDCCCC6CB0705941000000008ECB2641CDCCCC2CB2705941333333338FCB264133333353B57059419A99999992CB264166666606B7705941CDCCCCCC9CCB264166666646B870594133333333ACCB2641333333F3B870594166666666C4CB264166666646BA705941CDCCCCCCD3CB2641000000E0BB70594100000000D9CB26419A9999D9BC70594166666666DECB264166666646BE70594100000000E5CB264166666686BF70594133333333ECCB264166666626C070594133333333F3CB26419A999959C070594133333333F8CB264133333353C0705941CDCCCCCCFECB26419A9999D9BF7059419A99999905CC26419A999939BF7059416666666618CC264166666666BE7059416666666627CC264166666626BE7059416666666633CC264166666606BE705941333333333DCC264166666646BE705941333333338DCC2641000000C0B870594100000000DDCC2641CDCCCC6CB7705941000000000FCD2641000000A0B87059419A99999991CD26419A999939C17059419A999999DDCE264133333393C370594166666666F1CE26419A9999B9C37059410000000003CF2641333333D3C37059419A99999912CF26419A9999F9C370594166666666F3CF264133333393C570594133333333A7D0264100000060C5705941CDCCCCCC4FD1264166666666BD7059413333333358D12641CDCCCCACC0705941333333336DD1264166666626C6705941333333338CD1264166666626CA705941CDCCCCCCA9D126419A9999D9CC705941CDCCCCCCE4D1264100000020D07059419A99999909D2264100000060D37059410000000024D226419A999919D67059413333333343D22641333333D3DA705941CDCCCCCC53D2264100000080DE7059419A99999955D2264166666686DF705941333333337ED22641666666E6F47059413333333393D22641000000C0FC705941CDCCCCCCAFD22641000000400671594100000000E4D22641666666E611715941CDCCCCCC0BD3264100000060187159416666666634D32641333333731D7159419A99999978D32641CDCCCCAC2471594100000000C5D32641666666A62A7159413333333311D42641CDCCCCEC307159410000000042D42641000000C0367159419A9999996ED42641666666863D71594166666666A1D42641333333B34871594100000000BED42641CDCCCCEC4F715941CDCCCCCCF7D42641000000805B7159419A99999949D52641333333B36B715941333333338CD52641CDCCCC0C7B71594166666666A4D52641CDCCCCCC82715941CDCCCCCCDDD52641CDCCCC0CAB715941CDCCCCCC0FD62641666666E6C7715941333333331CD6264133333373D07159416666666657D62641CDCCCC8CE87159413333333383D626419A9999D9F87159419A99999999D6264100000000FE71594133333333E8D62641333333730D7259416666666620D726419A99997917725941CDCCCCCC41D726419A9999F9167259413333333368D72641000000A0167259413333333373D72641CDCCCCAC16725941333333338BD72641333333F316725941CDCCCCCCA1D72641333333731772594166666666B9D7264166666626187259419A999999C7D72641000000801872594133333333EAD726419A9999F9187259416666666617D826419A999979197259416666666627D82641666666A6197259410000000037D82641000000A019725941666666664AD826413333337319725941666666667BD82641CDCCCCEC187259419A9999998ED82641333333F318725941CDCCCCCC99D826416666662619725941CDCCCCCCA6D82641666666861972594166666666AFD82641666666E6197259419A999999B6D82641000000601A725941CDCCCCCCBED82641333333331B72594100000000F2D82641666666A62072594133333333FED8264166666606227259419A99999906D9264133333353237259419A9999990BD926410000006024725941000000000FD92641CDCCCC6C25725941CDCCCCCC12D9264166666646277259410000000017D926419A99999929725941000000001AD92641333333B32B7259419A9999991CD92641CDCCCC0C2D7259413333333325D926419A9999B92F7259413333333328D9264133333373307259419A9999992FD92641666666A631725941CDCCCCCC0AD92641CDCCCCCC347259419A999999F7D8264100000000387259419A999999EBD82641666666E63B725941CDCCCCCCCBD82641CDCCCC2C5A72594100000000D8D826419A9999D96872594133333333E4D826419A9999F976725941CDCCCCCC62D92641CDCCCC0C8172594133333333D9D92641CDCCCC4C95725941CDCCCCCC31DA26419A9999F9AA7259419A9999999EDA2641000000A0BC7259413333333304DB2641333333D3C47259413333333360DB264166666606CB7259416666666688DB26419A9999B9DF725941666666667EDB26419A9999D9E07259413333333374DB2641CDCCCC0CE2725941CDCCCCCC6BDB264166666646E3725941CDCCCCCC63DB264166666686E4725941333333335DDB2641CDCCCCCCE57259416666666658DB264166666646E77259410000000052DB26419A999979E9725941CDCCCCCC4CDB2641666666A6EB7259413333333349DB264100000000EE725941CDCCCCCC46DB264133333333F07259416666666644DB26419A999919F37259410000000042DB2641000000A0F57259419A99999940DB264133333333F77259419A9999993EDB2641CDCCCC0CFA7259419A99999937DB264100000060047359419A99999934DB2641CDCCCCAC0A735941CDCCCCCC30DB2641000000200F735941333333332EDB26413333335311735941333333332BDB26413333331313735941CDCCCCCC27DB2641CDCCCCCC14735941CDCCCCCC22DB26413333335316735941333333331EDB264133333373177359413333333316DB2641CDCCCC0C19735941333333330CDB2641666666C61A7359416666666605DB2641666666C61B7359419A99999901DB2641CDCCCC2C1C7359419A9999995BDB2641000000C0367359416666666699DB2641CDCCCC6C5373594133333333E1DB2641333333D36E735941000000005DDC264166666686A473594166666666A2DC264100000040A3735941CDCCCCCCD1DC2641666666A6A273594133333333F3DC26419A9999B9A27359419A999999FFDC2641000000E0A2735941CDCCCCCC35DD26419A9999199E7359416666666695DE2641333333938C73594100000000F5DE2641CDCCCC0C897359416666666628DF2641666666268E7359410000000064DF26419A999999987359419A9999992DDF264100000040A0735941CDCCCCCCDEDE26419A999999B77359419A999999A7DF2641000000E0C4735941333333334AE1264166666666D67359419A9999990CE2264166666666D97359410000000016E2264166666686D37359416666666656E226419A999979D17359410000000093E2264166666666D17359413333333309E32641CDCCCCECD6735941666666666DE326419A9999F9DB73594133333333B8E326419A999939E37359419A999999E9E32641333333D3E773594166666666C3E3264133333353FC7359419A999999EBE3264166666646017459416666666632E4264133333313087459413333333387E42641333333930F7459419A999999E2E42641000000A01A745941CDCCCCCC14E52641000000201F7459410000000066E5264100000040157459419A9999997AE52641CDCCCC0C1974594100000000B5E52641333333532074594100000000E6E526413333335321745941CDCCCCCC8DE62641666666E634745941CDCCCCCC15E726419A999919477459413333333391E72641333333135B74594133333333C9E726419A9999D95D745941000000005FE826419A99999974745941CDCCCCCC0BE82641CDCCCC4C7C745941666666667BE82641333333F39374594133333333E2E82641CDCCCCCCA974594133333333C5E8264133333313BA7459419A999999C0E8264166666666C3745941CDCCCCCCE6E82641333333F3D87459419A999999D6E8264100000000ED74594133333333BCE82641000000000175594166666666BBE8264133333333047559419A999999BCE82641666666C60675594166666666BAE826419A9999F90975594133333333BCE82641666666260C75594100000000B9E826419A9999590D75594133333333B3E826410000002010755941000000004DE82641CDCCCC6C0C7559410000000017E82641333333730975594100000000FCE726419A99997909755941CDCCCCCCC0E72641000000E00A7559416666666652E72641333333530B75594133333333FBE6264133333393117559419A9999996BE626419A99995925755941333333330BE62641333333F3397559419A999999F0E52641666666064975594166666666ECE526419A9999795475594133333333E0E52641CDCCCCEC637559419A99999919EB2641000000A0007659419A999999A0EB26419A99993911765941333333336FEC26419A9999992A76594133333333C0ED264133333353517659416666666633EF2641333333F35376594100000000C8EF2641000000C04C7659410000000075F0264100000000447659416666666649F1264100000020327659413333333375F12641666666862B7659419A99999904F22641CDCCCCAC11765941CDCCCCCC64F226419A999979067659419A99999970F22641CDCCCC6C03765941CDCCCCCC75EF2641666666C6E27559416666666677EC264100000000C27559416666666634ED26419A9999797A75594166666666C8ED26419A9999D9377559419A999999CEED264133333353297559419A999999EAED264133333393247559419A999999F4ED26419A9999B9237559413333333302EE26416666662622755941333333331BEE26419A9999B91F755941333333333BEE2641000000001E7559413333333356EE2641CDCCCC6C1C755941666666666BEE26419A9999791A755941CDCCCCCC77EE2641CDCCCCCC187559419A999999B4EE2641666666A613755941CDCCCCCCECEE264100000080177559416666666629EF2641000000801E755941000000004AEF2641CDCCCCCC23755941CDCCCCCC64EF2641CDCCCCEC2E755941CDCCCCCC77EF2641000000C03A7559410000000095EF2641333333B33B75594133333333B8EF2641666666863A75594133333333D5F026419A9999992C755941CDCCCCCC39F22641000000C0317559419A9999994CF226419A9999B92D755941333333338BF22641CDCCCCEC2A7559419A99999925F3264166666686267559416666666677F3264133333353237559419A999999B7F32641CDCCCCAC2075594133333333DCF326419A9999591D755941CDCCCCCCEAF32641666666861A75594166666666F7F32641CDCCCCECE17459413333333305F4264133333353DE7459416666666667F4264133333353D2745941333333336FF4264133333373CF7459419A99999905F42641000000E0C77459413333333332F42641333333D3C07459416666666685F42641CDCCCC8CB6745941CDCCCCCCD9F42641CDCCCC4CB374594133333333CDF4264100000000AB74594133333333C8F42641333333D39474594133333333C9F42641666666E6677459419A999999D1F42641000000A065745941333333335BF5264166666666637459410000000078F526410000008063745941CDCCCCCC91F52641000000806974594166666666AAF52641333333B36974594100000000ECF52641CDCCCC6C61745941CDCCCCCCFBF526419A9999D95F745941CDCCCCCC31F62641333333D35D7459419A9999994EF62641CDCCCCEC5D745941333333335DF62641000000006274594166666666F0F62641333333535474594133333333AAF726410000000041745941666666663BF8264100000080317459419A9999993CF82641333333731C7459410000000050F82641666666661B745941666666666CF826419A9999F91774594166666666D6F8264133333313177459410000000025F926419A999979187459416666666653F926410000004015745941000000007EF92641666666660F74594166666666A4F92641000000E00474594166666666D2F9264166666646F173594133333333FBF92641666666C6E67359413333333329FA2641CDCCCC8CDE735941CDCCCCCC8EFA264100000020E07359419A999999A0FA264100000080D373594100000000D9FA2641333333D3C27359419A99999913FB2641000000C0C67359410000000094FB2641CDCCCC4CCD735941666666660BFC2641CDCCCC4CD4735941333333337EFC2641CDCCCCCCB47359410000000078FC2641000000C0B17359410000000039FC2641333333D3AE735941CDCCCCCC11FC264166666606AC735941666666660DFC2641000000C0A97359413333333323FC264100000000A77359413333333333FC264100000060A3735941666666665EFC2641000000A0987359419A99999984FC264166666626907359410000000015FC2641666666467E73594166666666AFFB2641CDCCCC6C717359413333333375FB264166666646687359419A9999994FFB2641666666A662735941000000002CFB26419A9999F96073594100000000E1FA2641000000C05E735941CDCCCCCCC7FA2641666666A63B73594166666666C8FA264100000000377359419A999999D7FA26419A9999D931735941CDCCCCCCD1FA2641333333732973594166666666C4FA264100000080177359419A99999964FA2641CDCCCC8CF87259410000000020FA26419A999979DE72594100000000FEF9264133333313D072594166666666D6FA264133333393C6725941CDCCCCCCADFA264133333333BB7259419A99999995FA264133333353B57259419A9999997AFA264166666626B1725941CDCCCCCCB0FA2641000000C0AC725941CDCCCCCCC0FA26419A9999D9AA7259419A999999ADFA2641CDCCCC8C9B7259419A999999E4FA2641CDCCCC0C8E725941CDCCCCCCAFFA26419A9999597E7259410000000094FA2641333333B3757259410000000051FA2641CDCCCC4C717259410000000095F9264100000060677259416666666664F92641CDCCCCAC63725941000000004DF9264166666626597259419A99999918F92641666666A6507259419A99999905F92641CDCCCC4C4B725941666666662DF926419A999999487259413333333375F92641CDCCCC0C4372594100000000ADF92641333333533E7259413333333389F9264100000080327259419A99999915F92641CDCCCC6C1572594100000000B4F82641CDCCCC6CF9715941000000008EF8264133333353EB7159413333333301F92641666666A6DA715941000000004DF9264133333333CF7159419A99999975F9264133333353C87159419A9999997DF92641000000C0C57159416666666604F82641333333D3B77159419A999999FEF626419A999959B071594133333333D3F6264133333393C9715941CDCCCCCC86F52641CDCCCCCCB6715941000000005CF5264100000060C57159416666666612F426419A9999D9B37159413333333329F4264166666626AE7159419A9999996BF42641333333B3A2715941666666661AF52641000000008B7159419A9999990BF52641CDCCCCAC7C715941CDCCCCCC35F5264133333373537159419A99999926F526416666668650715941CDCCCCCC07F52641CDCCCC8C4571594133333333C0F426419A9999592B7159416666666680F42641666666C619715941CDCCCCCC3DF42641CDCCCCCC1E715941000000001AF426419A9999F91A715941CDCCCCCCF4F326419A9999F91671594133333333DFF32641CDCCCCAC087159410000000031F4264166666686027159410000000076F32641CDCCCCECE47059419A999999FFF22641CDCCCCECD6705941666666660FF32641CDCCCC0CD4705941666666661DF32641CDCCCCCCD17059413333333318F326419A9999D9D07059419A99999924F3264133333373CD7059416666666633F3264166666606CA7059419A99999941F326419A999999C77059413333333352F326419A9999D9C57059413333333361F326419A9999B9C4705941333333335CF3264166666686C07059419A999999C5F2264166666666AD7059413333333381F22641CDCCCCCCB37059410000000039F2264133333353A970594166666666C1F1264166666666B6705941000000008CF1264133333313B07059410000000059F1264100000040AA705941CDCCCCCC42F12641CDCCCCCCA77059419A99999928F12641CDCCCCCCA57059419A99999915F12641333333D3A47059419A99999901F1264100000060A370594100000000E5F02641CDCCCC0CA070594100000000BEF026419A9999399B70594166666666A0F0264100000040957059416666666688F026413333333391705941CDCCCCCC5FF02641CDCCCC8C8A705941CDCCCCCC4EF02641CDCCCC6C877059413333333346F02641000000007A705941CDCCCCCC2CF0264133333313727059410000000009F02641666666E66A70594166666666A8EF264100000000607059413333333387EF2641333333B35B705941CDCCCCCC3BEF26419A9999F94C705941666666662EEF26419A999919477059413333333344EF2641CDCCCCCC387059410000000042EF2641CDCCCC0C2A7059419A99999935EF26416666664621705941333333331BEF264166666606177059419A999999F1EE2641333333B30D7059419A999999CFEE26419A999959067059413333333394EE264100000060027059419A999999FBED264133333373FB6F5941CDCCCCCC55ED264133333393EA6F59416666666674ED26419A9999B9E06F5941CDCCCCCCF2EC264100000060DB6F594133333333A9EC264100000080D36F5941CDCCCCCC7FEC2641CDCCCC2CCD6F5941CDCCCCCC43EC2641CDCCCCACC06F5941666666661BEC26419A9999B9B66F594100000000F8EB264166666626AF6F594100000000D5EB26419A999919AC6F594166666666A6EB2641333333B3A86F59410000000041EB26419A999979A46F59419A999999DCEA2641666666A69E6F594166666666C0EA2641CDCCCCCC9A6F5941CDCCCCCCBBEA2641000000A0976F5941CDCCCCCCC2EA2641CDCCCC6C946F59419A999999EBEA26419A999979906F59419A99999919EB2641333333138A6F59413333333336EB264166666666846F594166666666EAEA2641333333737F6F594133333333ACE82641333333B3646F59419A99999995E82641CDCCCC4C576F5941000000006EE8264133333333426F59416666666663E82641333333D33C6F5941CDCCCCCC5DE82641CDCCCCEC386F5941000000005DE82641CDCCCC0C366F59413333333361E826419A9999B9326F59410000000068E82641333333332D6F59416666666678E82641CDCCCCCC236F59419A99999987E826419A9999F9196F59419A9999998CE8264133333333166F59419A99999993E8264166666666106F59413333333398E82641333333B30A6F5941000000009FE82641CDCCCC6C066F5941CDCCCCCCA3E826419A9999B9016F5941CDCCCCCCAEE82641666666A6006F59419A999999C8E82641333333F3FE6E59419A99999915E92641666666A6FA6E59419A9999993FE9264133333333F86E59416666666660E9264133333313F66E5941CDCCCCCC90E92641CDCCCC4CF26E59419A999999B7E926419A9999F9EE6E5941CDCCCCCCDCE9264100000000EC6E5941333333330DEA264166666606E96E5941000000004FEA264100000020E56E5941CDCCCCCC89EA264166666606E16E5941CDCCCCCCB1EA264133333313DE6E594133333333C7EA264133333393DB6E594133333333F0EA2641333333F3D56E5941000000001EEB264100000020CF6E59410000000050EB2641CDCCCC4CC76E5941CDCCCCCC8CEB2641CDCCCC4CBD6E59419A999999B8EB26419A999919B66E594166666666F2EB2641333333F3AC6E5941CDCCCCCC18EC2641CDCCCCCCA56E59419A99999935EC2641CDCCCC0CA06E59413333333355EC2641666666C69A6E5941CDCCCCCC74EC2641000000C0956E59410000000094EC264133333313916E594133333333B8EC2641666666468A6E594100000000DDEC264100000020826E594100000000FEEC264166666606796E59410000000011ED2641000000E0726E5941CDCCCCCC21ED2641333333D36D6E59413333333337ED2641333333D3676E59416666666655ED264166666646606E59419A99999975ED2641000000A0586E59413333333397ED26419A9999D9506E59419A999999C3ED264133333313486E594166666666F1ED2641CDCCCC0C3F6E59416666666603EE2641333333D33A6E5941000000000AEE264166666606376E5941333333330FEE26419A9999D92F6E59416666666616EE26419A999959256E59410000000007EE26419A9999F9106E594166666666DCED2641666666A60F6E59413333333380ED2641333333D30E6E5941CDCCCCCC23ED26419A9999D90F6E59419A99999948EC26419A999939136E59419A9999991DEC26419A9999B9136E594166666666E5EB26419A999979106E59413333333340EB2641333333F3046E59419A999999B1EA264166666606FC6D594100000000D1E9264100000040DA6D5941000000001FE9264133333393CD6D59419A999999C3E8264133333353C86D5941000000006DE82641666666C6C36D59419A99999925E8264166666606BF6D59413333333301E82641333333F3BE6D594166666666FDE7264100000020C76D594133333333F1E726419A999959CA6D594133333333E7E726419A999959CF6D594166666666D4E7264166666626D66D59419A999999C5E72641000000C0DB6D59419A999999B9E726419A999939E26D594133333333AEE7264133333333E66D5941CDCCCCCCA9E726419A9999D9E96D5941666666669CE72641CDCCCCACEC6D59410000000073E7264100000020F26D59416666666661E72641CDCCCC6CF86D59416666666657E726419A999939FC6D59419A99999953E72641CDCCCC4C006E59413333333352E72641333333F3056E5941666666664BE726419A9999D9096E59419A99999949E72641000000400E6E59413333333340E726419A9999F9106E59419A99999930E726419A9999D9116E5941333333330EE72641CDCCCC0C116E594100000000E4E62641000000600F6E59419A999999B4E626419A9999B90D6E5941CDCCCCCC96E62641333333D30B6E5941000000006FE626419A999959096E5941666666664EE62641CDCCCC2C086E59416666666644E62641CDCCCCAC086E59413333333340E62641CDCCCCCC096E59419A99999944E62641666666A60B6E59419A9999994FE62641CDCCCCAC0C6E59410000000061E62641666666860F6E5941CDCCCCCC6AE626419A999979126E59410000000076E626419A9999D9156E59419A9999995EE62641333333B31D6E5941000000005CE62641CDCCCCEC216E59416666666643E62641666666A6296E5941000000004DE62641333333132B6E5941666666664EE626419A9999992C6E59410000000049E626419A9999792E6E5941333333333EE62641000000802F6E5941333333333AE6264100000080346E59413333333340E6264166666626396E5941CDCCCCCC3BE62641000000003F6E59413333333337E62641000000C0426E59413333333331E62641000000A0456E594166666666D1E52641CDCCCC0C426E5941CDCCCCCCAFE526419A999999406E5941333333337AE52641333333333F6E59410000000045E52641000000803D6E5941CDCCCCCC05E526419A9999B93B6E594166666666E3E42641666666463B6E594166666666C0E42641CDCCCCCC3B6E594166666666A6E42641333333733D6E5941CDCCCCCC98E426419A999919406E5941000000007AE42641CDCCCC0C416E59413333333347E4264166666606416E59419A99999917E42641CDCCCCCC3F6E594166666666F0E32641666666063F6E594133333333D4E32641000000A03E6E59419A99999989E32641CDCCCC4C3F6E5941000000006CE3264166666606406E5941CDCCCCCC4DE32641333333333F6E5941000000002AE32641CDCCCC8C3E6E59416666666612E32641000000E03C6E59419A999999F3E22641CDCCCC4C3E6E5941CDCCCCCCD8E22641CDCCCCCC3D6E594133333333C4E22641CDCCCCEC3D6E594166666666B2E22641666666063F6E5941000000009EE22641CDCCCCAC416E59416666666681E22641CDCCCCAC446E5941000000005DE2264133333353466E59410000000029E22641666666E6476E59416666666602E2264166666606486E59419A999999F0E12641000000A0496E594100000000FBE12641000000004C6E59410000000000E226419A9999F94D6E594166666666F7E1264166666606516E5941CDCCCCCCF0E1264166666666536E5941CDCCCCCCEFE12641CDCCCCCC546E594100000000D2E12641333333335A6E5941CDCCCCCCACE12641666666A6616E594166666666B7E126419A999999686E594166666666B1E126419A9999D96B6E5941CDCCCCCCA3E12641666666C66E6E5941CDCCCCCC80E12641000000C06F6E59419A9999996FE12641CDCCCC4C736E5941CDCCCCCC3EE1264133333353826E5941666666660EE12641000000E0986E59419A999999DDE026419A999999A56E59419A99999976E02641CDCCCC2CA66E5941333333333FE0264100000040A66E59419A9999993EE02641000000E09D6E5941666666663AE026419A9999999C6E59413333333330E02641666666669C6E59416666666615E02641CDCCCCCC9D6E594166666666F5DF264100000060A16E594166666666DFDF2641CDCCCC0CA36E5941CDCCCCCCD5DF2641333333B3B86E594133333333DCDF2641000000A0C36E594100000000D7DF264100000020C96E59419A999999D0DF264133333393CB6E59419A999999BDDF26419A9999D9CC6E5941666666669BDF2641666666E6CC6E59413333333372DF26419A999939CC6E59413333333340DF26419A9999F9C96E5941CDCCCCCCDBDE264133333353C46E59419A99999987DE2641666666C6C26E59416666666605DE264166666626BF6E59410000000007DE2641333333F3B86E59410000000098DD264166666606B76E5941CDCCCCCC1DDD264100000060B56E59410000000003DD2641333333F3C26E594100000000ECDC2641CDCCCCECCA6E5941CDCCCCCC4CDC264133333333C26E59410000000027DC264166666626D16E59416666666611DC264133333373D86E59419A999999BDDB2641CDCCCC2CD36E594133333333A9DB2641666666C6D96E5941333333339CDB264100000080E06E5941CDCCCCCC95DB264100000020E36E59413333333394DC264166666646F66E59413333333390DD264133333353096F59419A9999993DDD2641CDCCCC6C216F59413333333377DC26419A999959176F5941CDCCCCCC2DDC26419A999999136F59410000000020DC2641CDCCCC6C1B6F5941000000000BDC2641666666A6206F59413333333311DC26419A9999D9286F59413333333319DC2641000000002C6F5941CDCCCCCC12DC2641666666C62D6F59410000000002DC2641333333332E6F594166666666D3DB2641CDCCCC6C2C6F59419A9999995FDB2641CDCCCC8C2A6F59413333333313DB2641CDCCCC4C2B6F594166666666C2DA26419A9999792C6F5941CDCCCCCC88DA2641000000C02E6F594133333333FED9264166666626336F594100000000DCD9264133333393326F594100000000C2D926419A9999B9306F59416666666629D9264166666666216F594166666666ECD82641000000201B6F594133333333BBD8264133333333176F5941000000009FD82641CDCCCC4C146F59416666666679D82641CDCCCC2C136F5941CDCCCCCC64D82641666666A6136F59416666666658D82641333333D3146F59419A99999939D82641333333131A6F59413333333328D82641000000C01E6F59416666666613D82641CDCCCC0C226F594133333333FBD7264166666626246F594100000000DED72641CDCCCC6C246F594166666666C1D7264133333333246F59416666666685D72641CDCCCC2C236F59413333333351D7264100000040226F59419A99999924D726419A9999D91F6F59419A999999FAD6264100000080136F5941CDCCCCCCE0D62641666666060D6F594166666666C2D6264100000080066F5941CDCCCCCC7BD62641000000A0FE6E5941333333330DD6264100000080F26E594133333333EBD52641CDCCCCACF86E594100000000B2D526419A9999B9026F59416666666694D5264166666606076F59416666666688D52641333333530A6F59416666666679D526419A9999B90E6F5941CDCCCCCC67D52641CDCCCCCC136F59419A9999994AD52641CDCCCC6C1D6F5941CDCCCCCC63D42641666666C60D6F5941CDCCCCCC3ED4264133333333166F5941000000001FD42641333333331D6F5941CDCCCCCCF8D32641CDCCCC2C266F5941CDCCCCCCE9D32641333333B32A6F5941CDCCCCCCD6D3264100000060306F59419A999999B5D3264100000020376F59419A99999995D32641333333333E6F59419A99999972D32641CDCCCC2C466F5941000000005DD32641000000204C6F5941333333334AD326419A9999F9516F5941000000003ED3264100000040556F59419A9999992CD326419A999959596F5941333333331FD32641666666C65B6F5941CDCCCCCC11D32641333333535D6F5941CDCCCCCCFFD226419A9999795F6F59419A999999ECD2264100000040626F5941CDCCCCCCDAD2264133333393646F594166666666CAD2264133333393666F594133333333B7D2264166666686686F5941000000009CD22641333333F3696F5941CDCCCCCC6FD22641666666866C6F5941000000002ED22641333333D36F6F594133333333F3D12641666666E6726F5941CDCCCCCCAAD12641666666C6766F59413333333383D126419A9999D9776F5941333333336CD126419A999939786F5941CDCCCCCC5AD1264100000080786F59419A99999949D12641000000A0786F59416666666639D1264100000060796F59413333333326D12641333333937B6F5941666666660AD12641666666A67F6F594133333333E9D02641666666A6856F59419A999999D2D0264166666606896F5941CDCCCCCCBED02641666666268B6F59419A9999997FD02641333333D3986F59419A9999997AD026419A9999599A6F594166666666F0CF2641333333B3966F5941CDCCCCCCB0CF2641333333939C6F59413333333398CF264166666666A26F594133333333A1CF2641CDCCCC2CA46F59413333333380CF26419A999999AC6F5941CDCCCCCC5BCF2641333333D3B26F59416666666655CF2641CDCCCC2CB66F59410000000046CF264166666646BA6F59410000000044CF264100000020C86F5941666666662FCF264166666626CE6F59419A99999920CF26419A999959CF6F5941CDCCCCCC44CF2641666666E6D26F59419A99999966CF264133333353D76F59419A99999930CF26419A999979DD6F59416666666609CF26419A999999E16F5941CDCCCCCCE7CE2641666666A6E66F59419A999999DDCE264100000020E86F5941CDCCCCCCCECE2641CDCCCC4CE96F5941CDCCCCCCB9CE2641000000A0EA6F5941CDCCCCCCA7CE2641000000C0EB6F5941000000009ACE2641CDCCCC0CED6F59419A99999993CE2641CDCCCC2CEE6F59410000000094CE2641333333D3EF6F5941CDCCCCCC97CE26419A9999F9F06F5941000000009FCE264166666666F26F5941CDCCCCCCA3CE26419A9999F9F36F5941CDCCCCCCA3CE26419A9999F9F56F5941333333339ECE264133333313F76F59419A99999998CE264133333333F86F59416666666692CE26419A999979F96F59419A9999998ECE264166666606FB6F5941333333338ECE2641CDCCCCCCFC6F59419A9999998ECE26419A999959FE6F59410000000091CE264133333353FF6F5941CDCCCCCC96CE2641CDCCCC0C0070594133333333A0CE2641333333D300705941CDCCCCCCA8CE2641000000400170594133333333B3CE264166666626027059419A999999B5CE2641CDCCCC8C03705941CDCCCCCCB3CE2641666666E604705941CDCCCCCCB2CE2641666666460670594100000000B0CE26419A9999F909705941CDCCCCCCA9CE2641000000200D7059419A999999A7CE2641CDCCCCAC0E7059419A9999999ECE2641666666C6117059410000000099CE264133333373137059413333333399CE2641666666C614705941333333339CCE264133333393157059419A999999A3CE26416666664616705941CDCCCCCCA6CE2641000000401770594166666666A4CE2641CDCCCC6C18705941CDCCCCCC9DCE26419A9999191A7059419A99999998CE26419A9999591B705941CDCCCCCC8FCE26419A9999D91C705941CDCCCCCC82CE2641666666461E7059419A99999965CE2641CDCCCC6C20705941333333335ACE26419A99999921705941CDCCCCCC56CE2641666666A6227059419A99999952CE2641CDCCCCCC23705941000000004FCE2641CDCCCC2C25705941666666664BCE2641000000E0257059416666666640CE26419A999919277059416666666639CE26419A999959287059416666666635CE2641CDCCCC6C297059413333333334CE26419A9999F92A7059410000000037CE2641666666062C705941CDCCCCCC3DCE2641333333932E705941333333333ECE26419A999919307059413333333339CE2641CDCCCCAC31705941000000002FCE264133333353337059413333333323CE264166666646347059413333333316CE2641666666E6347059419A99999904CE2641CDCCCC6C3570594100000000E1CD26416666660636705941CDCCCCCCCECD2641CDCCCC4C367059419A999999C4CD26419A9999193670594166666666BBCD2641333333533570594100000000B8CD2641000000A03470594133333333B8CD264100000080337059419A999999BACD26410000000032705941CDCCCCCCBACD2641333333F33070594100000000B8CD264133333313307059419A999999B1CD26419A9999392F705941666666667FCD2641CDCCCCCC2B705941CDCCCCCC3ECD264166666646277059416666666632CD2641666666E6267059419A9999991ACD26419A99993925705941CDCCCCCC13CD264100000080247059419A9999990ACD26419A99995924705941CDCCCCCC03CD2641CDCCCCAC2370594166666666FBCC2641CDCCCC8C227059419A999999F2CC26419A9999792270594166666666EBCC2641CDCCCC8C2270594133333333DCCC2641666666462370594133333333C5CC2641333333F32470594100000000A0CC264166666666287059419A99999989CC2641666666662B7059416666666681CC2641CDCCCC6C2C7059413333333372CC2641CDCCCC4C2D7059416666666662CC2641000000A02D7059413333333350CC2641666666E62D705941666666663FCC2641000000402E705941CDCCCCCC34CC2641666666E62E7059413333333327CC26410000006030705941333333331ECC26419A999939327059413333333319CC2641333333D3337059416666666618CC26419A99993935705941CDCCCCCC19CC26413333335336705941000000001CCC26419A99991938705941666666661BCC2641333333B33F705941000000001ECC2641CDCCCCCC41705941CDCCCCCC1ACC264133333313437059416666666617CC2641CDCCCCEC43705941000000000CCC26419A9999D9447059419A999999FECB2641000000A04570594100000000EFCB2641CDCCCCEC4670594133333333E3CB26419A99997948705941CDCCCCCCDECB2641666666E64970594133333333DCCB2641666666E64B70594133333333D9CB2641CDCCCC2C4D70594100000000D4CB2641CDCCCC6C4E705941CDCCCCCCCDCB2641666666664F70594166666666C2CB264133333333517059419A999999AFCB2641CDCCCCEC5370594133333333A7CB26410000006055705941CDCCCCCCA2CB26410000008057705941CDCCCCCC99CB2641666666A6597059410000000093CB2641CDCCCCEC5A705941CDCCCCCC8ACB2641000000605C7059413333333383CB26419A9999595D705941333333335FCB2641666666A660705941333333334BCB2641CDCCCC4C647059410000000046CB26419A99997966705941	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	01010000206A08000058CB1BE3CFE726419A9999B905725941	580010000	Z	Achun	5800100	58001	58	27	25
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	01010000206A080000FE64DF451E892541333333D3F3935941	580020000	Z	Alligny-Cosne	5800200	58002	58	27	35
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	01010000206A0800000618384206122841333333D3007B5941	580030000	Z	Alligny-en-Morvan	5800300	58003	58	27	49
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	01010000206A080000D2AF468870CB2641CCCCCC3CA3675941	580040000	Z	Alluy	5800400	58004	58	27	28
01060000206A08000001000000010300000001000000D40100009A9999993C93264100000080418E5941000000004A9326419A9999995E8E594166666666B8932641CDCCCC8C688E594133333333F3932641000000A06D8E594166666666FB932641000000C06E8E5941CDCCCCCC4C94264133333373728E5941CDCCCCCC0C9526419A9999398E8E59419A999999F79526419A999979A68E59419A999999E7962641CDCCCCACA38E5941666666666E9726419A9999199B8E594166666666EB972641333333B3998E5941333333339998264133333353B38E594133333333859826419A999979E68E5941CDCCCCCC4B99264166666626D98E594100000000A69A264100000020EA8E59419A999999119C264133333313038F59419A9999993B9D264100000000208F59419A999999289F2641333333F34E8F594133333333BF9F2641666666465B8F59419A9999994BA02641000000A0628F5941CDCCCCCC15A126419A9999F9628F59410000000048A1264133333313638F5941CDCCCCCC47A12641000000C0608F59410000000061A12641666666C6568F59419A9999996BA1264166666686558F5941CDCCCCCC97A1264100000020528F594100000000AEA1264100000060508F5941000000000BA22641666666464C8F59419A99999963A22641CDCCCCCC498F594166666666C7A2264166666606488F594133333333ECA22641000000E0478F59419A99999905A32641333333F3478F5941CDCCCCCC24A3264100000060448F5941CDCCCCCC5DA32641666666E6388F5941000000009FA32641666666663C8F59419A9999999EA42641CDCCCCCC488F5941CDCCCCCCE1A52641CDCCCCEC508F59419A99999933A72641000000C0568F59413333333318A82641CDCCCC8C528F59416666666644A8264133333353378F5941000000007AA826419A9999B9318F59413333333398A8264166666666298F5941000000002BA9264166666606FB8E59413333333302AA26419A999919B68E59419A99999987AA26419A999919888E59419A99999975AA264166666606758E59416666666660AA264133333393638E59416666666615AA264133333373178E594133333333ADA92641CDCCCCACAD8D594100000000B6A9264133333393AC8D59419A999999D0A926419A9999F9A98D5941CDCCCCCCE7A92641000000E0A78D5941CDCCCCCC06AA26419A999939A58D5941CDCCCCCC24AA2641333333B3A28D5941666666663EAA26419A999999A08D59419A99999959AA2641000000809E8D59416666666682AA26419A9999599B8D59419A999999A2AA26419A9999B9988D594100000000BBAA264100000080968D594133333333CBAA264100000080948D5941CDCCCCCCCFAA2641000000E0938D594166666666D8AA264100000060948D594166666666E6AA264166666686948D59419A99999915AB26419A999959948D59416666666637AB2641CDCCCC2C948D59419A9999996CAB264166666606948D59419A99999993AB2641666666C6938D59419A999999A8AB264133333353938D59419A999999CEAB26419A999919928D594100000000F2AB2641666666E6908D59410000000017AC2641000000808F8D5941CDCCCCCC2DAC2641CDCCCCCC8E8D59410000000044AC2641333333338E8D59419A9999996AAC26419A9999F98D8D5941666666669DAC2641666666268E8D5941CDCCCCCCD5AC2641666666068E8D594133333333F4AC2641CDCCCCEC8D8D5941CDCCCCCCFAAC2641000000A08D8D59419A99999900AD2641666666068E8D5941666666660AAD2641CDCCCC0C8E8D59413333333330AD2641000000A08D8D59410000000045AD26419A9999398D8D59416666666674AD2641333333F38B8D594133333333ACAD2641000000608A8D59419A999999E7AD2641000000C0888D5941CDCCCCCC16AE26419A999979878D59416666666645AE264133333333868D5941CDCCCCCC74AE264166666626858D59413333333399AE264133333373848D59419A999999C8AE2641000000C0838D594133333333E1AE26419A999999838D5941CDCCCCCC24AF2641CDCCCC4C838D59416666666654AF26419A999919838D5941CDCCCCCC69AF2641666666C6828D594100000000A8AF26419A999999818D5941CDCCCCCCE5AF2641CDCCCC4C808D59410000000003B02641CDCCCCAC7F8D5941CDCCCCCC2EB02641000000807E8D5941000000006BB026419A9999B97C8D59413333333393B02641666666867B8D594166666666B1B02641666666C67A8D5941CDCCCCCCC7B026419A9999997A8D59419A999999F6B026419A9999B97A8D59413333333313B12641000000C07A8D5941CDCCCCCC3DB12641000000C07A8D59419A9999996FB12641333333D37A8D594133333333A2B126419A9999F97A8D594166666666DEB12641333333137B8D59419A999999F3B12641000000607B8D594166666666F7B12641666666E67F8D59419A999999FCB1264166666606878D59410000000001B22641000000408C8D59413333333302B22641666666E68F8D59416666666603B22641333333D3918D59419A99999904B22641CDCCCCEC928D5941CDCCCCCC0AB2264166666686938D5941CDCCCCCC13B22641CDCCCCCC948D59416666666636B226419A999959968D5941CDCCCCCC5BB22641666666C6978D59410000000078B22641666666E6988D594166666666A9B22641CDCCCC6C9A8D594100000000CCB22641666666869B8D594100000000FDB22641666666E69C8D59413333333326B32641333333339E8D59416666666644B32641000000009F8D59419A99999952B32641000000209F8D59410000000062B32641CDCCCC2C9F8D59419A9999991FB4264133333353A48D5941CDCCCCCCF4B526419A999979AF8D594133333333F8B52641CDCCCC4CC18D5941CDCCCCCCE1B6264133333393C18D5941CDCCCCCC00B72641666666E6C08D5941CDCCCCCC1BB7264100000020C38D5941000000003FB72641CDCCCC4CC68D59419A99999965B7264133333313CA8D5941000000008DB7264100000040CD8D594133333333A1B7264133333333CF8D594166666666ABB7264100000060D08D59419A999999B3B72641666666A6D18D594133333333B9B7264166666646D38D5941CDCCCCCCC2B72641666666C6D68D594133333333C9B7264100000080DA8D594166666666CFB72641000000C0DD8D594100000000D3B726419A9999F9DF8D594133333333D7B72641666666E6E18D5941CDCCCCCCDDB7264133333393E48D594166666666E3B7264166666666E68D594133333333E9B726419A9999B9E78D594166666666EFB72641CDCCCC8CE88D5941CDCCCCCCF7B726419A999919E98D59410000000007B826419A999959E98D5941333333332FB82641333333B3E98D59419A99999955B82641666666E6E98D59416666666671B82641CDCCCCECE98D59410000000098B8264100000080E98D59419A999999C2B82641CDCCCC4CE98D594100000000D5B826419A999959E98D594166666666E8B82641666666C6E98D594166666666FDB82641CDCCCC8CEA8D5941CDCCCCCC16B9264166666626EB8D5941CDCCCCCC46B9264166666666EC8D5941666666665BB9264100000000ED8D59413333333394B92641CDCCCCECED8D594133333333AEB9264100000080ED8D59419A99999908BA264100000000E88D59416666666625BA264133333373E58D59413333333332BA2641CDCCCC6CE48D59410000000040BA26419A999939E38D59410000000044BA264133333333E38D59413333333347BA264100000060E38D59413333333366BA264133333313E88D59419A99999976BA264100000080EA8D59416666666698BA2641CDCCCC2CEF8D5941333333339FBA264133333313F08D5941CDCCCCCC52BB2641666666C60B8E59413333333388BB26419A9999F9188E594166666666BABB2641666666A61C8E5941CDCCCCCCF3BB2641CDCCCC4C208E59419A99999954BC264100000080218E5941666666667CBD2641CDCCCC2C218E594133333333DAC22641666666A62A8E594133333333DEC22641CDCCCC4C278E594133333333E2C22641000000801F8E594133333333E4C22641333333B31B8E594133333333E7C22641CDCCCC8C178E594133333333E9C226419A999979138E5941CDCCCCCCE9C22641000000200F8E594166666666E7C22641666666A60A8E594166666666DFC22641666666C6078E5941CDCCCCCCD4C22641000000E0048E594166666666CBC2264133333393028E5941CDCCCCCCBEC226419A9999F9FF8D594133333333B8C2264100000040FD8D594100000000B5C2264133333313F88D594100000000B7C22641CDCCCC6CF48D594100000000BBC226419A9999B9F08D594133333333C2C2264133333333ED8D59419A999999CBC226419A9999F9EA8D594133333333D8C226419A999939E98D594133333333ECC2264133333333E78D59413333333300C3264133333393E58D59419A9999991DC32641CDCCCCCCE38D59413333333339C32641000000E0E18D5941000000005AC326419A9999B9DF8D5941000000007EC3264133333333DD8D5941CDCCCCCCA8C3264100000040DB8D594100000000CEC32641CDCCCC6CD98D5941CDCCCCCCEFC32641CDCCCC4CD78D59413333333313C4264100000020D58D59413333333329C4264100000060D38D5941CDCCCCCC42C4264166666646D18D59419A99999957C4264166666626CF8D59419A99999968C4264133333333CD8D59419A99999979C42641333333F3CA8D5941CDCCCCCC8EC42641666666E6C78D59419A9999999EC42641333333F3C48D59419A999999A6C4264100000000C18D594100000000ABC42641666666E6BD8D5941CDCCCCCCAEC42641CDCCCCACBA8D59419A999999B2C4264166666646B78D594166666666B3C426419A9999D9B48D594100000000B3C42641333333D3B08D59419A999999B1C4264133333333AE8D594100000000B0C4264100000080AA8D59419A999999A9C42641CDCCCC2CA78D5941333333339FC42641000000C0A38D5941CDCCCCCC90C426419A9999999E8D59419A99999988C42641333333D3998D59410000000080C42641000000A0948D5941CDCCCCCC75C42641666666C68E8D5941CDCCCCCC71C42641CDCCCC6C8B8D5941CDCCCCCC68C4264100000060888D5941333333335EC426419A9999B9858D59416666666650C426419A9999B9828D59413333333349C42641666666E67F8D5941CDCCCCCC42C42641000000407B8D5941CDCCCCCC40C42641333333D3778D59410000000045C426419A9999D9738D5941CDCCCCCC48C42641666666E6708D5941333333334FC42641CDCCCCAC6D8D5941333333335DC4264100000060688D59419A99999966C42641CDCCCCCC648D59416666666671C426419A999919618D59416666666681C42641666666665D8D5941000000008EC42641333333135B8D5941CDCCCCCC9FC4264133333333588D594100000000B5C4264166666606558D594166666666CCC4264166666666518D59419A999999E2C42641CDCCCC4C4E8D5941CDCCCCCCF3C426419A9999B94B8D5941CDCCCCCC00C52641333333B3498D59419A9999990BC52641333333F3468D59416666666616C526419A999959448D59419A99999920C5264166666686418D5941666666662DC52641666666E63E8D5941666666663EC52641CDCCCCEC3B8D59419A9999994DC5264166666646398D5941CDCCCCCC5DC52641CDCCCC4C368D59413333333375C52641CDCCCC8C328D5941000000008EC52641333333D32D8D5941333333339DC52641000000E02A8D594100000000AAC52641000000E0278D594100000000B4C52641000000A0248D59419A999999BEC5264166666646218D594100000000C6C52641CDCCCCCC1C8D59419A999999CAC52641666666A6188D5941CDCCCCCCD0C526419A9999F9128D5941CDCCCCCCD3C526419A9999990F8D594133333333D4C52641CDCCCCAC0D8D594166666666D4C526419A9999590C8D5941CDCCCCCCBDC52641000000600C8D59419A999999A0C526419A9999590C8D5941CDCCCCCC8AC526419A9999590C8D5941000000007AC52641333333F30B8D59419A999999ADC2264100000000FE8C5941666666668ABC2641CDCCCC2CDA8C59416666666650B826419A9999D9B08C59416666666662B62641333333139B8C59416666666692B52641000000E08A8C59410000000040B52641333333F37A8C594100000000CFB42641666666865F8C5941333333334FB42641666666A6618C5941CDCCCCCCFDB3264100000020448C594133333333C0B32641666666262C8C594166666666AAB32641333333732C8C5941000000008DB32641333333B32C8C59419A9999996DB32641000000002D8C5941CDCCCCCC54B32641666666462D8C59419A99999930B32641333333D32D8C5941CDCCCCCC0DB32641000000402E8C5941CDCCCCCCEEB22641000000A02E8C594133333333D0B226419A9999D92E8C594100000000BDB22641666666E62E8C594133333333A4B22641666666C62E8C5941666666668CB22641333333732E8C5941000000006CB22641666666A62D8C5941666666664CB22641CDCCCCCC2C8C59410000000030B22641CDCCCCEC2B8C59410000000023B22641666666662B8C59419A99999917B22641333333732A8C5941CDCCCCCC31B22641CDCCCC0C258C59419A99999945B226419A999919218C5941666666663EB2264133333393208C59419A99999934B22641000000A0208C5941333333331AB22641666666461F8C59419A9999990EB22641000000C01E8C59410000000006B22641666666661D8C5941CDCCCCCCCEB12641666666661A8C59419A999999C5B12641000000201A8C594133333333AEB126419A999979198C59413333333392B12641CDCCCCCC188C59410000000071B12641333333F3178C5941CDCCCCCC4FB1264100000020178C5941CDCCCCCC3BB12641666666A6168C59410000000024B126419A999959168C59413333333310B1264166666646168C594100000000FDB02641CDCCCC4C168C594133333333E3B02641CDCCCC4C168C5941CDCCCCCCC0B0264133333333168C59410000000097B02641CDCCCCEC158C5941666666667CB02641CDCCCC6C158C5941333333336AB02641333333F3148C59419A99999959B0264133333333148C5941CDCCCCCC48B0264133333333138C5941CDCCCCCC2EB0264166666666118C5941CDCCCCCC12B02641CDCCCC4C0F8C594133333333FDAF2641000000E00D8C5941CDCCCCCCE9AF2641000000E00C8C594166666666D0AF2641CDCCCCCC0B8C594166666666B9AF2641000000000B8C5941CDCCCCCC98AF2641333333330A8C59419A99999978AF2641000000A0098C5941CDCCCCCC59AF264133333333098C59419A99999939AF264100000000098C5941CDCCCCCC15AF2641CDCCCCEC088C594166666666F4AE2641CDCCCCAC088C59419A999999D6AE264100000060088C594100000000C1AE26419A999919088C5941333333339FAE2641000000C0078C5941333333337BAE26419A999939078C5941000000005DAE2641CDCCCCAC068C59416666666637AE264166666606068C59410000000017AE264166666646058C594166666666E8AD264166666666048C5941CDCCCCCCBBAD26419A999999038C5941CDCCCCCC9BAD26419A999919038C59419A99999975AD264133333393028C5941000000005AAD264133333333028C59419A99999946AD26419A9999F9018C59413333333323AD264100000000028C594133333333FDAC2641666666E6018C594166666666E2AC2641CDCCCCCC018C594100000000BDAC2641333333D3018C5941CDCCCCCC9BAC2641CDCCCC0C028C59416666666675AC264100000040028C5941666666663FAC2641666666A6028C59419A99999905AC264166666606038C594100000000D7AB2641CDCCCC4C038C5941666666669EAB26419A999979038C59410000000067AB264133333393038C59413333333341AB264133333393038C59419A99999908AB2641666666C6038C594166666666D7AA2641CDCCCCAC038C594133333333A4AA2641000000C0038C59416666666678AA26419A9999B9038C5941CDCCCCCC55AA264133333373038C59416666666635AA2641CDCCCCEC028C59419A99999921AA264166666686028C594166666666FAA92641333333B3018C5941CDCCCCCCBEA9264133333333008C59416666666697A9264133333333FF8B5941CDCCCCCC86A92641000000A0FE8B5941CDCCCCCC81A9264100000080FE8B5941CDCCCCCC7DA92641CDCCCCACFE8B5941666666667AA92641666666E6FC8B5941000000004EA9264166666626FB8B5941000000002CA92641666666C6F88B5941333333330FA92641CDCCCC8CF68B59419A999999FCA8264100000060F48B594100000000F1A82641000000C0ED8B594100000000E0A8264166666646E68B594133333333C8A82641CDCCCC0CE18B594166666666ABA826419A9999F9DD8B59413333333389A826419A999939DB8B5941CDCCCCCC27A8264100000040D08B594133333333EFA726419A9999D9CA8B594166666666BFA726419A999999C88B59410000000083A726419A9999D9C78B5941666666665AA726419A999999C58B59419A99999913A72641333333F3BE8B594100000000C4A6264133333373B58B5941000000003FA626419A9999B9AA8B59410000000001A6264100000040A98B594100000000C6A42641000000C09E8B5941333333337BA42641CDCCCCAC9A8B59416666666657A32641000000C0758B594166666666ACA226419A9999B95F8B5941CDCCCCCC54A2264100000080568B5941CDCCCCCC33A22641CDCCCC8C568B59413333333365A12641333333D3588B5941666666660EA026419A9999D95D8B59419A9999991A9F2641000000C0618B59419A9999993F9E26419A9999F9618B59419A9999990D9D2641000000C0608B5941666666669D9B2641666666865D8B5941CDCCCCCC769A26419A9999D94E8B59419A999999279A26419A9999394A8B594133333333D6992641000000E0738B594133333333569A264166666606828B5941CDCCCCCC219A2641000000C0898B59419A9999998399264133333333828B594133333333FE982641CDCCCCCC7C8B59419A99999925982641000000A07A8B59413333333334972641666666A6838B59410000000083962641000000008D8B59416666666647962641CDCCCC0C928B5941CDCCCCCC039626419A9999D9978B594166666666E29526419A999919A08B59419A999999E795264100000060CF8B594133333333A2952641000000C0D78B5941000000008A952641666666C6E98B5941000000004E952641000000E0F78B594100000000ED9426419A999919048C5941CDCCCCCC3F942641333333B3118C59419A99999931952641666666262A8C59416666666638952641CDCCCC6C2A8C59419A99999951952641333333132B8C5941333333336A952641666666862B8C5941000000007E9526419A9999B92B8C5941CDCCCCCC94952641CDCCCCCC2B8C59419A999999CE952641666666862B8C5941666666661C9626419A9999F92A8C59410000000042962641000000C02A8C594100000000A8962641666666462A8C594166666666DE962641666666062A8C5941666666662B972641666666A6298C594100000000079726419A9999B9408C594133333333B996264166666646618C5941666666667396264100000000848C59419A9999991496264133333373A78C594166666666ED952641CDCCCC2CBA8C594133333333F5952641CDCCCC4CC68C59419A99999957962641666666A6D48C5941666666669697264133333313CD8C5941CDCCCCCC3B97264166666686FE8C5941CDCCCCCC29972641000000A0068D594133333333AC97264100000060218D59410000000048992641666666062C8D5941333333337999264133333393478D5941CDCCCCCC4B9A2641666666A64E8D5941333333333D9A2641CDCCCC6C5E8D59419A999999EF992641000000E0728D59419A999999CF992641666666C67B8D59416666666602972641CDCCCC6C918D5941CDCCCCCC389526419A999939BD8D5941CDCCCCCC3095264166666606BE8D5941CDCCCCCCC7942641CDCCCC0CD38D594166666666B6942641000000C0E08D59419A999999C0942641333333D3EE8D59419A999999BE942641CDCCCC2CFF8D5941CDCCCCCC9D942641000000400A8E59413333333380942641666666C6138E5941CDCCCCCC57942641666666E61F8E5941333333334F9426419A9999B9218E59419A999999E993264166666626338E5941CDCCCCCC92932641333333B33A8E59410000000060932641000000403D8E59419A9999993C93264100000080418E5941	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	01010000206A0800007CA7506A77AF2641CCCCCC9C568D5941	580050000	Z	Amazy	5800500	58005	58	27	14
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	01010000206A0800003BEE660C9D812641CDCCCCDC4A605941	580060000	Z	Anlezy	5800600	58006	58	27	22
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	01010000206A0800006291B4702E3925419A9999A9FD9C5941	580070000	Z	Annay	5800700	58007	58	27	27
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	01010000206A08000093AD663D590727419A9999B946855941	580080000	Z	Anthien	5800800	58008	58	27	20
01060000206A0800000100000001030000000100000054010000CDCCCCCCFAD22541666666C6EC7D59410000000002D32541CDCCCCCCF17D59410000000026D325419A999919027E5941333333332AD32541666666E6027E59413333333331D3254100000060067E59413333333337D32541000000C0097E5941CDCCCCCC3DD32541000000C00C7E59413333333344D32541333333930E7E5941666666664CD32541666666A6107E5941CDCCCCCC5AD325419A999959137E594100000000B9D32541CDCCCC4C217E5941CDCCCCCC29D425419A9999B9327E59416666666648D42541333333333A7E59419A99999955D42541333333533F7E5941333333335CD42541CDCCCC2C437E5941CDCCCCCC5DD425419A999999477E5941666666665DD42541CDCCCCAC487E59416666666658D42541000000204A7E5941666666664FD42541333333934C7E59419A99999944D42541333333734E7E5941CDCCCCCC3CD42541333333934F7E59419A99999931D42541CDCCCC6C517E59419A9999992AD42541CDCCCCCC527E59416666666624D42541CDCCCCAC547E59419A99999920D42541666666E6567E5941CDCCCCCC1BD42541000000605B7E5941CDCCCCCC1BD4254166666646607E5941CDCCCCCC1BD4254133333373647E59416666666614D425419A999939677E59419A99999910D42541333333336A7E5941CDCCCCCC17D42541CDCCCC8C717E5941CDCCCCCC2CD42541000000E0757E5941333333333DD42541333333537B7E59419A9999993ED42541666666A6817E59410000000027D4254166666666887E59419A99999920D42541CDCCCCCC9B7E59413333333336D4254100000020AF7E5941666666663BD42541CDCCCCCCBB7E59413333333339D42541666666A6BF7E59413333333326D42541666666A6C27E594133333333F8D32541CDCCCCCCC57E59416666666605D4254166666686CD7E59410000000001D42541000000A0D47E59419A999999F6D3254100000040D77E5941000000009ED32541333333D3D77E5941CDCCCCCC57D3254166666646E37E59413333333353D32541CDCCCCACE87E59419A9999998DD325419A9999D9EB7E594100000000E0D3254100000000F27E59419A99999919D42541666666A6F47E5941333333336ED42541333333F3F77E59419A9999990BD52541666666A6FE7E59419A99999969D52541CDCCCCCC037F59419A9999993CD52541333333D3197F5941CDCCCCCC39D52541666666661D7F59419A999999AED525419A9999191C7F59419A9999990BD625419A9999D91C7F59419A99999972D62541CDCCCC6C1E7F594100000000DBD6254166666606227F5941CDCCCCCC23D72541CDCCCCAC257F594133333333A2D72541666666462D7F594166666666DCD72541666666E6317F5941CDCCCCCCDDD7254133333353397F59419A999999D6D725419A9999F93C7F5941666666663ED7254100000060577F59413333333380D6254100000060757F5941CDCCCCCC9AD625419A999939757F594166666666E9D62541CDCCCCEC767F5941CDCCCCCC49D72541333333B37A7F59413333333335D82541333333F3867F59419A999999CFD8254100000080907F59419A9999996BD92541000000C09A7F59416666666682D92541666666269C7F59419A9999999BD925419A9999B99D7F5941CDCCCCCC9AD9254133333373A07F594133333333E6D9254166666646A67F59416666666603DA2541000000E0B57F59413333333320DA254100000040C47F59416666666603DA254166666626CF7F5941CDCCCCCC20DA254166666686D77F59410000000044DA2541666666E6DE7F5941CDCCCCCC64DA254133333393E27F5941666666668ADA254133333393E57F5941CDCCCCCCD4DA2541CDCCCC8CE87F594133333333EEDA2541333333B3E97F5941CDCCCCCC09DB25419A9999F9E87F5941CDCCCCCC27DB2541666666E6E57F59419A99999950DB254133333353E47F5941333333336ADB254133333333E47F5941CDCCCCCC94DB254100000000E77F5941CDCCCCCCD0DB254166666666EB7F59419A99999907DC254100000080EE7F5941CDCCCCCC6CDC2541CDCCCCCCF87F594100000000B8DC254100000060FD7F5941CDCCCCCCC6DC254166666646FE7F594133333333CBDC2541000000A0FE7F594166666666E7DC2541333333F300805941CDCCCCCC5ADD25419A9999790A80594166666666AADD25419A99997910805941CDCCCCCC2BDE254166666646168059410000000084DE25419A99993919805941CDCCCCCCE7DE2541CDCCCC0C1A8059413333333373DF2541333333F31C80594166666666D8DF2541CDCCCCEC22805941CDCCCCCC1FE02541333333D328805941666666665CE025419A9999992E80594100000000B7E02541000000803B8059419A999999CFE02541333333933F80594166666666F6E02541333333533E805941CDCCCCCCC3E12541000000802A805941CDCCCCCC4EE22541CDCCCC0C1E80594133333333A7E22541666666462580594166666666B1E22541666666462780594100000000B7E225416666660627805941CDCCCCCCC0E225419A9999D9268059419A999999F3E22541333333B3248059413333333334E32541333333D323805941000000007AE325413333339323805941CDCCCCCCA1E32541333333B323805941CDCCCCCCF7E3254133333353238059410000000075E425419A999979218059410000000093E425416666664621805941CDCCCCCCA5E42541333333132180594100000000B4E42541CDCCCCAC2080594133333333CAE425419A9999192080594166666666E4E42541CDCCCC0C1F80594166666666FFE42541CDCCCCEC1D8059413333333315E52541000000C01C805941666666662CE52541666666461B8059413333333346E525416666668619805941CDCCCCCC5FE525413333331318805941666666667BE525419A999979168059410000000092E525419A9999F91480594100000000A0E525419A9999D91380594166666666AEE525419A999959128059419A999999BBE52541CDCCCCCC1080594166666666CAE52541666666E60E80594166666666D4E52541666666860D80594166666666DFE525419A9999390C80594166666666ECE52541666666260B8059416666666609E6254166666626098059419A9999991CE6254100000000088059419A99999931E62541333333D3068059419A9999994CE6254100000060058059410000000056E62541000000A0048059419A99999959E62541CDCCCC8C03805941000000005AE625419A999939028059419A99999989E6254100000040028059416666666684E6254133333313FE7F59413333333380E625419A9999D9F97F5941666666667DE6254133333373F47F5941CDCCCCCC7CE6254166666626EE7F59419A9999997DE62541000000E0E77F59410000000080E62541333333F3E17F5941333333336CE7254133333393D67F594166666666D1E72541333333B3D27F594100000000F6E725419A999959D27F594133333333FFE725419A999959DC7F59419A99999914E82541CDCCCC0CE47F59416666666628E8254100000020E87F59419A99999959E82541333333B3EA7F59419A99999980E82541000000A0EB7F59410000000001E9254100000060E97F59419A9999992BEA254100000080E07F594100000000B2EA25419A999959DE7F59410000000018EB2541CDCCCCCCE37F59410000000062EB2541333333D3E67F59419A999999A8EB2541666666C6E77F59416666666611EC2541666666A6E67F59419A99999973EC2541CDCCCC4CE67F594133333333E3EC2541666666A6E77F59413333333351ED2541CDCCCC2CE97F594166666666DEED25419A999979EA7F59419A9999992EEE2541666666C6E97F5941000000006DEE25419A999919E87F5941CDCCCCCCE6EE254133333313E17F59410000000069EF25419A9999B9DA7F59419A999999BCEF2541333333F3D77F59419A999999D8EF2541CDCCCC2CD77F594166666666F1EF254133333393D67F59410000000002F025419A999959D67F59410000000012F0254133333333D67F5941CDCCCCCC1EF0254166666606D67F59410000000036F025419A999919D67F5941666666664FF02541CDCCCCACD57F59410000000066F0254166666626D57F59419A9999997CF0254133333373D47F594133333333A5F025419A999919D37F5941CDCCCCCCC6F0254100000000D27F594166666666EAF02541000000A0D07F59419A999999F5F0254100000080D07F594166666666A3F1254166666686C07F59419A999999FFF125419A999919B77F5941000000001FF2254100000000B07F5941333333334FF22541333333F3A57F594166666666A1F2254166666666967F59419A999999D0F22541CDCCCC8C937F59410000000034F32541666666468F7F5941333333335EF32541CDCCCCAC8C7F5941CDCCCCCC57F225419A9999F95C7F5941CDCCCCCC41F22541333333B3577F5941CDCCCCCCB1F22541666666664C7F5941CDCCCCCC7EF2254166666626407F5941CDCCCCCC1BF22541333333932F7F594133333333ECF12541666666C6277F594166666666B1F125419A9999D91E7F59419A999999DEF025419A999999007F5941333333339EF0254100000080F77E5941333333335DF0254166666646E67E59410000000013F02541000000A0D57E59419A999999E6EF254100000040CB7E5941CDCCCCCC92EF254100000040B57E5941000000004AEF254166666666A47E59419A999999E0EE25419A9999398F7E59419A99999990EE25419A999979817E594166666666F9ED2541666666E66E7E5941333333337EED254133333333637E59410000000056ED254100000000637E594100000000E0EC25419A999939567E59410000000053EC254100000060477E594133333333E4EB2541000000003B7E594166666666CAEA2541333333531D7E59416666666609EA254166666666057E594100000000D2E9254166666686FD7D59419A99999929E9254100000060D87D594100000000BAE825419A999979C97D5941CDCCCCCC7FE8254100000000C17D59410000000062E82541CDCCCC8CB77D5941CDCCCCCCC6E72541666666A6927D594166666666A7E72541000000E08D7D59419A99999984E7254133333353847D5941CDCCCCCC01E7254100000080687D5941CDCCCCCCC1E6254166666606657D5941666666664EE625419A999939627D59419A99999949E625419A9999795E7D5941CDCCCCCC80E6254166666646567D5941CDCCCCCC92E6254100000020497D5941CDCCCCCC88E6254166666666407D59416666666651E6254166666606327D59419A9999990DE6254133333313277D594166666666B2E52541000000402E7D5941333333337CE52541CDCCCCCC307D5941000000003BE52541CDCCCCEC317D594133333333C5E42541CDCCCCAC327D5941CDCCCCCC95E32541333333B3307D5941CDCCCCCCCEE22541000000602D7D594133333333EAE2254133333373267D59419A99999910E325419A999959207D5941666666665AE325419A999979167D594133333333B9E32541000000A0127D59419A999999EAE32541CDCCCC6C0F7D59419A99999917E42541333333530D7D5941CDCCCCCCDAE3254166666686FE7C594166666666BFE325419A999999FF7C59419A9999999CE325419A9999F9007D59413333333347E3254166666606057D59410000000007E32541CDCCCCCC087D59419A999999E1E22541333333330C7D594100000000B1E22541CDCCCCCC137D5941000000008AE2254133333353207D5941CDCCCCCC67E22541333333F32C7D59419A99999950E22541666666A62C7D59419A999999E7E12541000000E0207D594100000000AEE12541CDCCCC4C1B7D59419A99999967E125419A9999D9187D59413333333318E1254100000080177D594100000000EBE02541CDCCCC0C157D5941CDCCCCCCAAE02541666666C60C7D5941333333336CE0254133333393067D5941666666663DE02541CDCCCC8C047D59419A999999EFDF254166666626037D59410000000083DF2541CDCCCC4C047D5941000000003ADF2541333333B3067D5941000000000DDF254100000080067D594100000000D0DE254133333333027D5941000000006ADE254100000040F27C5941CDCCCCCC2CDE25419A9999B9E87C59419A99999962DE2541CDCCCCACE37C594166666666A3DE254100000060DE7C5941000000005DDE2541666666A6D47C5941CDCCCCCCECDD25419A999959BC7C594100000000BADD254133333393AD7C59419A999999ACDD2541CDCCCC8CA67C5941CDCCCCCC31DD254100000000AC7C59413333333315DD254166666646AA7C5941CDCCCCCC01DD2541CDCCCC0CA47C5941CDCCCCCCF2DC2541333333B3A47C594100000000E5DC2541CDCCCCCCA57C5941CDCCCCCCADDC2541333333D3A97C5941000000001EDC25419A999939B47C594133333333A9DB2541333333D3BC7C59416666666661DB25419A999939C27C59410000000054DB25419A999939C37C59419A99999917DB2541666666A6C77C59419A999999E6DA254133333313CB7C5941CDCCCCCCBEDA254133333393CD7C5941CDCCCCCC97DA2541333333B3CF7C59416666666673DA25419A9999B9D17C5941CDCCCCCC2FDA2541CDCCCCCCD47C59419A999999F0D9254100000080D77C5941CDCCCCCCD6D925419A999999D87C594166666666AAD92541000000A0DA7C59416666666674D9254166666646DD7C5941CDCCCCCC4ED9254133333373DE7C59410000000026D9254133333353DE7C594133333333FCD8254166666646DD7C594133333333B6D8254133333313DB7C5941666666667BD82541000000E0D87C59419A99999913D8254166666626D57C5941CDCCCCCCA8D7254100000060D17C59413333333334D7254166666646CD7C594166666666D2D62541333333F3C97C594100000000D5D625419A999999D17C59419A999999BAD6254166666606DA7C5941666666668ED6254166666606E87C59413333333389D62541333333D3F17C5941CDCCCCCC5ED62541666666C6FD7C59416666666646D625419A9999D9027D59419A99999943D625419A999959077D59416666666661D6254166666646117D59416666666692D62541CDCCCC6C1F7D594100000000C6D62541CDCCCCAC377D594133333333D8D6254166666666437D594100000000E3D6254100000020577D594100000000EBD625419A999919697D594100000000EDD62541666666E6757D5941CDCCCCCCE4D62541000000407D7D59419A999999C2D62541666666A6847D59413333333361D62541333333F3967D5941CDCCCCCC28D6254133333353A07D59413333333307D625419A999939A47D59413333333381D52541000000C0AB7D59410000000042D52541000000A0AE7D59416666666609D52541666666E6B07D594166666666BFD425419A999919B17D5941CDCCCCCCECD32541333333F3B07D59416666666624D3254100000020AF7D5941666666661AD3254100000040B67D5941CDCCCCCC09D32541CDCCCC4CD17D5941CDCCCCCCFAD22541666666C6EC7D5941	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	01010000206A0800008ECBD26F21E12541666666B6737E5941	580090000	Z	Arbourse	5800900	58009	58	27	9
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	01010000206A0800002F6C04E626B42741343333C33B685941	580100000	Z	Arleuf	5801000	58010	58	27	60
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	01010000206A080000C08D737D14A72641000000D002965941	580110000	Z	Armes	5801100	58011	58	27	9
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	01010000206A080000DA331095DB5D2541666666D62C9D5941	580120000	Z	Arquian	5801200	58012	58	27	34
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	01010000206A08000014D821FF594E2641CCCCCCACF97D5941	580130000	Z	Arthel	5801300	58013	58	27	8
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	01010000206A080000C6E6F186E330264166666636327E5941	580140000	Z	Arzembouy	5801400	58014	58	27	13
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	01010000206A0800009A9999D9B4A126410000009060855941	580150000	Z	Asnan	5801500	58015	58	27	5
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	01060000206A08000001000000010300000001000000D0000000000000007AA826419A9999B9318F594100000000ABA826419A9999392F8F594133333333EAA826419A9999B9248F59410000000025A926419A9999F9208F594133333333D5A92641333333931E8F5941CDCCCCCC84AA2641000000A01A8F594133333333E3AA2641333333931B8F5941333333333EAB2641333333531E8F594133333333A3AB264133333393238F59413333333380AC26419A999999338F59419A999999FBAD264100000000538F59419A99999943AE264166666606578F59419A999999F7AE2641333333D35B8F59419A99999994AF26419A9999B95E8F59419A9999990FB02641666666665D8F5941666666665EB0264100000000568F594100000000A2B1264166666666558F5941CDCCCCCC9CB2264166666646558F594100000000C6B2264166666686538F594100000000E7B32641CDCCCC6C398F594133333333C0B42641000000E03C8F594100000000BFB42641CDCCCCAC3E8F5941666666661BB52641000000C0408F5941000000002AB52641666666A63C8F59413333333377B52641CDCCCCEC408F594133333333CCB52641666666E63F8F5941CDCCCCCC65B62641666666A63C8F5941CDCCCCCC6BB626419A9999593E8F5941CDCCCCCC4AB82641333333D3438F59419A99999905B92641000000805A8F5941333333337BB9264133333333688F594166666666BBB92641000000806D8F594166666666F8BA2641333333737F8F594100000000FCBA26419A999999818F59416666666604BC2641333333F3B08F5941CDCCCCCC1BBC264100000060B98F5941CDCCCCCC32BC2641CDCCCC2CC68F5941666666665DBC264100000000E48F5941CDCCCCCC65BC264166666626E68F5941000000003ABD26419A9999B9ED8F59413333333347BD26419A999979F08F59419A99999965BD2641CDCCCC6C069059413333333384BD2641000000E01190594166666666B5BD26419A9999391D905941CDCCCCCCFABD2641CDCCCC0C2A905941666666665CBE2641000000404890594166666666E9BE2641333333935D90594100000000E8BE2641000000606790594133333333F4BE26419A9999D9969059419A999999FDBE2641666666C6A2905941333333331CBF2641333333F3B99059410000000072BF26419A999919D2905941000000009EBF2641000000C0DB90594166666666CEBF264133333393E19059413333333379C0264133333393F390594133333333B4C02641CDCCCC4CEB9059416666666602C12641CDCCCC2CD9905941333333334BC12641666666E6CC905941333333336EC1264100000000C990594100000000B5C1264133333373C5905941CDCCCCCCF9C1264100000000C09059416666666646C22641333333F3B69059410000000057C22641CDCCCCECAF9059416666666644C226419A9999B9AA905941666666661BC226419A999959A5905941CDCCCCCCD4C1264100000080A1905941000000009BC126419A9999B9A09059416666666675C12641CDCCCCEC9B9059413333333358C126419A999999929059419A99999953C1264133333353899059419A9999995EC12641666666A679905941000000007DC126419A999999709059416666666680C126419A9999796B905941CDCCCCCC6AC126419A9999395B9059413333333394C12641666666E64C9059419A999999BBC12641CDCCCC2C489059419A99999900C2264166666686439059419A9999993CC22641000000E03B905941CDCCCCCC66C22641000000E030905941CDCCCCCC8AC2264166666666249059419A99999990C226419A9999191B9059419A999999B7C22641CDCCCC8C1690594100000000E7C22641CDCCCC8C17905941CDCCCCCC71C32641000000202B9059410000000088C326410000006030905941CDCCCCCC80C326419A9999594490594133333333A2C32641CDCCCCAC4C9059419A999999DBC326419A9999794F9059416666666624C4264100000020489059416666666651C42641000000403F9059419A9999996FC426419A9999192B9059419A99999968C42641CDCCCCCC219059413333333312C42641333333B30E90594166666666F5C32641333333530390594166666666E5C3264133333353F78F5941CDCCCCCCB5C32641000000E0F08F5941000000006EC3264133333393ED8F5941666666665CC326419A999959EB8F5941CDCCCCCC55C326419A9999F9E38F59413333333368C32641CDCCCC8CDC8F594133333333B1C32641666666C6D18F594166666666EEC32641333333D3C38F59419A9999990AC4264166666646B88F59413333333308C4264100000020AE8F59413333333312C42641000000E0A38F594133333333FEC32641666666469B8F5941CDCCCCCC58C32641CDCCCCEC8D8F5941CDCCCCCC21C326419A999919878F59413333333372C22641333333736A8F59410000000041C22641000000605F8F59416666666628C2264166666606578F59419A999999FFC12641CDCCCCEC4E8F59419A9999990CC226419A999919488F5941CDCCCCCC8FC22641CDCCCCAC3D8F594133333333ABC22641666666E62C8F594133333333BFC226419A999939268F59410000000004C32641333333F3168F59410000000013C32641333333530E8F59419A999999F5C22641CDCCCC0C058F594100000000C7C22641333333F3FF8E5941CDCCCCCC80C22641CDCCCCEC008F59410000000054C2264100000040078F59413333333318C2264166666686178F594133333333D6C12641666666C6238F594133333333AEC126419A999939278F5941333333336AC12641CDCCCC6C268F59413333333328C12641333333931F8F59419A999999EFC02641000000E0128F5941000000008DC02641CDCCCC8C018F5941CDCCCCCC61C0264100000080F28E59416666666675C026419A9999D9E68E59413333333394C0264166666666E28E59419A999999F9C0264100000020E38E5941333333332CC126419A9999D9E08E59416666666645C1264100000080DD8E59410000000059C126419A999959CF8E59416666666645C1264100000080BE8E59410000000022C12641CDCCCCECB48E59419A99999912C12641000000E0AD8E59419A99999928C126419A999939A98E59419A99999992C1264166666626A48E594133333333C7C12641666666A6A08E5941CDCCCCCCE9C126419A9999399A8E59419A999999E6C12641000000C08E8E594133333333B1C126419A9999197F8E59410000000092C12641CDCCCCCC788E59419A99999952C12641CDCCCC4C718E5941CDCCCCCCF8C02641CDCCCC0C6C8E59410000000062C02641CDCCCC6C6C8E59410000000041C02641333333B36A8E59416666666630C02641666666E6658E59416666666630C02641000000C05F8E59410000000052C0264166666666568E5941333333337BC02641CDCCCC8C4E8E5941CDCCCCCCDEC0264100000020468E59410000000022C1264166666666438E594133333333C7C1264166666626438E59413333333315C226419A999979418E5941CDCCCCCC67C22641666666063E8E5941CDCCCCCC97C22641CDCCCC4C3A8E594100000000C8C226419A9999F9318E594133333333DAC22641666666A62A8E5941666666667CBD2641CDCCCC2C218E59419A99999954BC264100000080218E5941CDCCCCCCF3BB2641CDCCCC4C208E59413333333388BB26419A9999F9188E5941CDCCCCCC52BB2641666666C60B8E5941333333339FBA264133333313F08D59413333333347BA264100000060E38D594133333333AEB9264100000080ED8D5941666666665BB9264100000000ED8D594100000000D5B826419A999959E98D59416666666671B82641CDCCCCECE98D5941CDCCCCCCF7B726419A999919E98D594133333333E9B726419A9999B9E78D59419A999999B3B72641666666A6D18D594133333333A1B7264133333333CF8D5941CDCCCCCC00B72641666666E6C08D5941CDCCCCCCE1B6264133333393C18D594133333333F8B52641CDCCCC4CC18D5941CDCCCCCCF4B526419A999979AF8D59419A9999991FB4264133333353A48D59410000000062B32641CDCCCC2C9F8D59416666666644B32641000000009F8D59410000000078B22641666666E6988D5941CDCCCCCC13B22641CDCCCCCC948D59419A99999904B22641CDCCCCEC928D59419A999999F3B12641000000607B8D5941CDCCCCCCC7B026419A9999997A8D59410000000003B02641CDCCCCAC7F8D59416666666654AF26419A999919838D59419A999999C8AE2641000000C0838D59416666666645AE264133333333868D59410000000045AD26419A9999398D8D5941666666660AAD2641CDCCCC0C8E8D59410000000044AC2641333333338E8D59419A999999A8AB264133333353938D594166666666E6AA264166666686948D594100000000BBAA264100000080968D5941CDCCCCCCE7A92641000000E0A78D594133333333ADA92641CDCCCCACAD8D59416666666660AA264133333393638E59419A99999987AA26419A999919888E59413333333302AA26419A999919B68E5941000000002BA9264166666606FB8E59413333333398A8264166666666298F5941000000007AA826419A9999B9318F5941000000007AA826419A9999B9318F5941	01010000206A0800004C14499D99B7264100000060358F5941	580160000	Z	Asnois	5801600	58016	58	27	6
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	01010000206A080000934AAC12910E2741CDCCCCFC83715941	580170000	Z	Aunay-en-Bazois	5801700	58017	58	27	45
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	01010000206A0800001BAA4DB32D54264100000010A8805941	580180000	Z	Authiou	5801800	58018	58	27	7
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	01010000206A080000E3C86E9186682741343333D3EE505941	580190000	Z	Avrée	5801900	58019	58	27	13
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	01010000206A08000007C0FD4E1B2A2641343333E3594E5941	580200000	Z	Avril-sur-Loire	5802000	58020	58	27	25
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	01010000206A0800002D8012667DE42541333333437B4C5941	580210000	Z	Azy-le-Vif	5802100	58021	58	27	47
01060000206A08000001000000010300000001000000AD020000666666665A1B274133333393A889594100000000721B27419A9999F9AC8959419A9999998B1B27419A9999F9B089594100000000AE1B274100000080B68959419A999999CC1B27419A999919BB8959419A999999EE1B274133333393C089594100000000F41B274133333313C289594133333333001C274100000000C3895941333333333F1C2741333333D3CC8959419A999999871C274100000040D889594133333333D91C274100000040E5895941000000004B1D274133333353F7895941CDCCCCCC741D27419A9999B9FD8959419A9999998C1D2741CDCCCC6C018A5941CDCCCCCCB41D274133333313078A594100000000D41D2741333333930B8A594100000000F71D274100000060118A59419A999999181E274133333393168A594133333333341E2741CDCCCC0C1B8A594100000000541E2741333333B31F8A594133333333701E2741000000A0248A594100000000871E2741333333F3288A5941000000009A1E2741000000C02C8A594133333333AD1E2741CDCCCC0C318A59419A999999C61E274100000040368A594166666666D11E2741CDCCCC0C388A594133333333DF1E2741000000803B8A594100000000F41E2741000000C03E8A5941333333332D1F2741CDCCCCAC478A59419A999999711F2741CDCCCCCC528A594133333333D61F27419A999919628A5941CDCCCCCCF81F274166666686678A59410000000031202741666666266D8A5941CDCCCCCC4B202741666666266F8A5941666666666520274133333373718A5941000000008920274166666606768A59419A9999999120274166666606778A5941333333339D2027419A999979798A594133333333B02027419A9999B97C8A594100000000C6202741000000A0808A59419A999999D42027419A999959838A594133333333E2202741333333F3858A594166666666E6202741CDCCCC2C878A59419A999999EA20274166666666888A594133333333F9202741CDCCCC4C8C8A59419A99999900212741000000808E8A5941000000000921274166666666918A5941666666660C212741000000C0938A5941000000000E212741CDCCCCEC958A59410000000010212741000000A0988A59416666666612212741333333F39A8A59413333333314212741000000009C8A594100000000182127419A9999599D8A59419A9999991F212741333333139F8A59416666666629212741333333D3A08A59419A99999936212741CDCCCCECA28A5941CDCCCCCC4721274100000020A58A5941333333335B21274133333393A68A5941CDCCCCCC682127419A999979A78A59410000000079212741CDCCCC0CA88A59410000000089212741CDCCCC0CA88A594166666666CD212741333333B3A78A594166666666E2212741000000A0A78A5941CDCCCCCCF2212741333333F3A78A59419A99999903222741CDCCCCACA88A5941666666660F22274100000080A98A594100000000192227419A999999AA8A5941CDCCCCCC1E222741666666E6AB8A59416666666621222741CDCCCCACAD8A5941CDCCCCCC2122274133333373B08A59419A99999923222741CDCCCCCCB28A5941000000002C22274166666646B68A5941333333333622274133333333B98A5941666666663322274166666626BA8A59413333333344222741333333D3BB8A5941000000005C222741000000E0BE8A5941333333337022274133333313C28A5941333333338122274100000040C48A5941000000009122274100000000C68A594100000000A7222741333333D3C78A59419A999999AE22274100000000CB8A59419A999999CA222741CDCCCC6CD08A594166666666ED2227419A9999D9D68A59419A999999F8222741333333F3D88A59419A999999092327419A999979DC8A59419A9999991723274133333353DF8A59413333333323232741000000E0E18A5941CDCCCCCC2F232741CDCCCC6CE48A5941333333334223274133333373E78A59413333333353232741CDCCCC0CEA8A5941333333336523274166666686EC8A59419A9999997223274133333393ED8A59419A99999963232741CDCCCCCCED8A5941333333334323274100000040EF8A5941333333331D232741CDCCCCECF08A594100000000FA22274166666686F28A594166666666D0222741CDCCCC6CF48A5941CDCCCCCCA4222741000000A0F68A5941333333338822274133333313F88A59419A9999996D222741666666E6F98A5941000000006E222741333333B3FA8A5941333333335D2227419A9999B9FC8A59416666666648222741CDCCCC6CFF8A5941000000002622274166666606048B5941000000000D22274100000040078B59419A999999E52127419A9999390C8B594100000000C8212741000000E00F8B594166666666A8212741666666A6138B59413333333392212741666666E6158B59413333333384212741CDCCCC0C178B5941000000007521274100000040188B59410000000069212741CDCCCCAC198B5941333333334A2127419A9999791D8B594166666666232127419A9999B9218B59413333333312212741333333B3238B594166666666022127419A999979258B594133333333ED202741333333B3288B59419A999999DF2027419A9999B92A8B59419A999999D1202741666666062D8B594166666666C52027419A9999992F8B594166666666BB202741CDCCCCEC328B5941CDCCCCCCB02027419A9999F9378B59419A999999A0202741333333533E8B59419A9999998E20274166666666458B5941333333337F202741000000604C8B59410000000078202741CDCCCC0C508B5941000000007420274166666646528B5941CDCCCCCC6F202741CDCCCC0C558B5941333333336E202741CDCCCC6C588B5941666666666D202741333333F35C8B5941666666666A20274166666666628B5941000000006720274166666686668B5941CDCCCCCC63202741000000E0698B5941333333335F202741CDCCCCAC6D8B5941000000005820274133333393708B5941666666664D20274100000040748B5941333333334120274133333313788B5941CDCCCCCC34202741000000A07A8B59410000000029202741CDCCCC0C7D8B5941000000001B2027419A9999B97F8B5941666666660B202741CDCCCCAC828B594166666666012027419A999979848B5941CDCCCCCCF41F27419A999939868B594166666666E91F274133333333888B594100000000E01F2741333333538A8B59419A999999D51F2741CDCCCC0C8D8B594166666666CE1F2741333333538F8B594166666666C91F274133333333928B5941CDCCCCCCC41F274100000040958B594100000000C31F274100000000978B5941CDCCCCCCB81F2741666666A69C8B59419A999999B21F2741CDCCCC6CA28B5941CDCCCCCCB41F2741CDCCCCCCAA8B594166666666C51F2741CDCCCC2CB58B594133333333DA1F274100000040C78B594100000000E41F274100000020D78B59419A999999D51F274166666666E28B594166666666D51F27419A999939E88B594100000000E81F2741CDCCCCCCF18B59419A999999F71F27419A9999F9F88B59419A999999012027419A999999FD8B59410000000017202741666666460A8C594133333333212027419A999999148C59413333333329202741333333131A8C5941CDCCCCCC382027419A999959198C594100000000552027419A9999D9188C59410000000074202741CDCCCC0C198C594166666666A120274133333373198C5941CDCCCCCCBA202741333333331A8C5941CDCCCCCCD5202741666666261C8C5941CDCCCCCCF4202741CDCCCCCC208C59413333333313212741CDCCCC2C1D8C5941333333332B2127419A9999391B8C5941666666664E212741333333331B8C59419A9999999D212741333333F31E8C59419A9999992723274100000000328C5941CDCCCCCC55232741333333B3348C59416666666670232741CDCCCC6C378C5941CDCCCCCC88232741000000E03C8C59419A999999AC2327419A999939458C594100000000B8232741666666264A8C594133333333E42327419A999939518C5941CDCCCCCCF3232741666666C6548C594166666666FF232741333333735C8C59413333333311242741CDCCCC8C608C59419A999999342427419A999959678C5941CDCCCCCC3D242741666666666D8C59410000000036242741CDCCCC4C7A8C5941000000002A2427419A9999D9828C5941CDCCCCCC44242741000000E0878C59413333333357242741000000808A8C59410000000073242741333333138E8C59416666666687242741000000C0908C5941333333339624274100000080938C594133333333A62427419A999979978C594100000000AD24274166666626998C594166666666F02427419A999979A68C5941CDCCCCCC2D25274100000080AF8C5941666666667E25274100000040B88C594133333333BF25274100000000BE8C59419A999999ED2527419A999919C28C5941CDCCCCCC0C262741666666C6C58C5941666666662D26274133333393C98C59413333333353262741333333B3CD8C5941333333337126274166666646D18C594133333333AF26274100000020D88C59419A999999C2262741666666A6DA8C594100000000CF26274100000020DD8C594166666666D52627419A999939E08C594133333333D92627419A999959E38C5941CDCCCCCCE7262741CDCCCC6CE78C59419A999999F6262741CDCCCCACE98C5941CDCCCCCC08272741CDCCCCCCEB8C5941CDCCCCCC192727419A999999ED8C59416666666632272741000000C0F08C59413333333389272741333333D3FB8C594133333333E0272741CDCCCC4C058D59416666666602282741CDCCCC6C078D59419A9999992128274133333393088D59410000000035282741666666C6088D5941666666664B282741CDCCCC8C088D59416666666672282741333333F3078D59419A9999999728274166666626078D5941CDCCCCCCA8282741666666E6068D594100000000B3282741CDCCCC2C078D59419A999999A6282741000000C0098D5941666666669F282741000000C00D8D5941CDCCCCCC9A28274133333333138D594100000000972827419A999939178D5941000000008E282741CDCCCC6C1A8D594166666666E3282741CDCCCC0C3D8D5941CDCCCCCC24292741666666E65B8D59419A99999952292741666666A66D8D5941000000007E292741CDCCCC0C7E8D594133333333962927419A999979878D594133333333AD292741000000A08F8D594100000000BD292741333333F3958D5941CDCCCCCCD4292741333333D39E8D594133333333E8292741666666E6A58D594166666666FF29274166666686AF8D594133333333112A274166666686B68D594100000000242A274166666646BD8D5941CDCCCCCC342A274100000000C48D5941333333333D2A274133333373C98D5941CDCCCCCC4A2A274133333393D18D594166666666502A274100000020D98D59419A999999552A274133333353DD8D5941CDCCCCCC5E2A2741000000A0E38D59419A999999652A2741333333B3E88D5941666666666E2A27419A999979EE8D5941CDCCCCCC742A2741000000E0F38D5941CDCCCCCC802A2741333333F3F98D5941666666668C2A2741333333F3FD8D5941CDCCCCCC952A2741333333D3018E59419A999999912A2741000000A0118E594100000000AD2A2741CDCCCC0C158E5941CDCCCCCCCE2A2741CDCCCC8C188E5941CDCCCCCCF42A2741666666061C8E5941666666661B2B2741000000E01F8E5941CDCCCCCC322B274100000000228E5941CDCCCCCC4E2B27419A9999B9248E594166666666702B2741CDCCCCAC268E5941CDCCCCCCA42B274133333393298E5941CDCCCCCCCC2B2741333333B32B8E594133333333DA2B2741333333732C8E594100000000E22B2741666666062D8E594166666666EF2B2741666666C62D8E594100000000072C2741000000602F8E594100000000192C2741666666C6308E594166666666282C2741CDCCCCAC318E59419A999999362C2741CDCCCC4C328E5941CDCCCCCC462C2741CDCCCC8C328E594166666666602C27419A9999F9318E59419A999999852C27419A999979308E59419A999999B42C2741666666E62E8E594166666666D12C2741CDCCCC0C2D8E594100000000F12C2741CDCCCC0C2A8E5941CDCCCCCC092D2741666666A6288E5941666666662D2D2741CDCCCCCC268E594133333333552D2741333333F3258E594166666666732D274166666606258E59419A999999972D274166666626248E594166666666CE2D2741CDCCCC4C238E594133333333042E2741666666C6228E594166666666242E274133333393218E5941CDCCCCCC4C2E274133333313208E5941CDCCCCCC7C2E2741CDCCCC4C1E8E594166666666A82E27419A9999B91D8E594100000000342F274133333373188E594133333333742F274166666626158E594166666666A62F2741666666C61B8E5941000000000F30274100000080248E5941666666666030274166666646278E594166666666B8302741666666C6258E5941000000005231274166666646208E5941000000005A3227419A9999F9298E594166666666B9322741666666062C8E594133333333CD3227419A9999192C8E5941CDCCCCCCE5322741666666A62C8E5941CDCCCCCCFF322741333333B32D8E594166666666193327419A9999192F8E5941333333333033274133333313318E5941666666664233274166666646328E59419A9999995F3327419A999959338E59419A99999979332741666666C6338E59419A9999998D332741666666C6338E594133333333A93327419A9999B9338E594133333333B43327419A999999338E594133333333BC332741000000C0338E59419A999999C13327419A999939348E59419A999999C6332741CDCCCCEC348E59413333333325342741666666A62D8E5941666666667A34274100000060218E5941000000009B342741333333D31E8E59419A999999F83427419A9999191E8E59410000000077352741CDCCCC4C1C8E594100000000B235274100000080198E5941000000003636274133333393F68D59419A9999993E362741CDCCCCECEC8D5941000000003036274100000040E28D5941CDCCCCCC2336274100000080D18D5941333333332436274166666646BB8D59419A99999939362741CDCCCCCCB58D5941CDCCCCCC9136274133333313A88D594100000000C0362741000000009F8D59413333333319372741000000A08B8D5941CDCCCCCC31372741666666C6868D59419A999999553727419A999999838D594133333333153827419A999939778D5941CDCCCCCC2538274133333333768D5941000000003738274100000040758D59419A9999994238274133333373748D59419A9999994F38274133333393738D5941333333335F38274166666646728D5941333333336B38274166666666718D59416666666677382741CDCCCCAC708D594133333333823827419A999939708D59419A99999996382741666666C66F8D59419A999999A4382741CDCCCCAC6F8D594100000000B1382741333333936F8D59419A999999C2382741666666266F8D594166666666D1382741333333D36E8D5941CDCCCCCCE0382741666666666E8D594166666666EF382741000000E06D8D594133333333FB382741666666866D8D594100000000083927419A9999596D8D59416666666612392741666666466D8D59416666666619392741333333136D8D59419A9999991F392741000000606E8D5941CDCCCCCC27392741000000806F8D59410000000033392741CDCCCC4C708D5941666666663E3927419A9999D9708D5941333333334D39274100000040718D594166666666643927419A9999D9718D59419A999999793927419A999959728D59419A9999999739274133333313738D594133333333B4392741666666E6738D59419A999999CA392741000000A0748D5941CDCCCCCCDC39274100000080758D594133333333EF39274133333373768D59419A999999FD39274100000060778D59419A999999093A27419A999959788D594166666666123A27419A999919798D5941000000001C3A2741000000207A8D59419A999999253A2741333333337B8D59419A999999313A2741333333937C8D5941333333333C3A2741666666A67D8D594133333333473A2741666666867E8D594133333333533A2741333333337F8D5941333333335F3A2741CDCCCCAC7F8D5941CDCCCCCC6E3A274166666626808D594133333333873A27419A9999B9808D5941CDCCCCCC8A3A2741000000A07E8D594100000000963A2741333333337B8D59419A999999A23A2741333333D3778D59419A999999B63A274133333333738D5941CDCCCCCCC93A2741000000A06F8D594133333333D83A2741000000006D8D594166666666DF3A27419A9999996A8D594133333333EA3A274166666666668D59419A999999F43A2741CDCCCC2C628D594166666666FA3A2741666666865F8D594100000000053B2741666666265D8D5941000000001C3B2741CDCCCCEC5A8D594100000000363B274166666666598D59419A999999473B2741CDCCCC0C588D594100000000543B274100000040568D594133333333643B27419A9999D9528D594133333333713B2741CDCCCC2C4F8D5941333333337A3B2741666666A64B8D5941666666667E3B274100000040498D594100000000833B274133333313468D594100000000903B2741000000203E8D594133333333A23B274166666686368D594166666666BF3B2741333333B32D8D5941CDCCCCCCCE3B2741000000E0288D594100000000D33B2741000000A0238D594100000000E63B2741666666E6138D59419A999999F03B2741666666860C8D594100000000003C2741000000A00A8D5941333333332A3C274166666646098D594166666666363C2741666666E6088D594166666666C13C27419A9999F9048D59419A9999991E3D2741333333F3018D5941CDCCCCCC593D2741CDCCCCECFE8C5941333333339E3D27419A999979FA8C594100000000E13D274166666686F48C594100000000173E274100000000EF8C5941333333333A3E2741000000C0E78C594133333333AD3E2741CDCCCC4CF28C5941CDCCCCCCE23E2741000000C0F88C594133333333F93E27419A999979008D5941CDCCCCCC343F2741333333D31A8D59419A999999573F2741CDCCCC4C218D594133333333BE3F2741666666A6298D59419A999999A43F27419A9999F9338D594133333333A13F274166666666358D5941CDCCCCCCFE3F2741666666A63A8D5941000000005E402741666666863B8D594100000000B540274100000060398D5941666666664C41274133333313368D5941CDCCCCCCC4412741CDCCCCCC348D594100000000B04227419A9999F9358D5941666666663F432741666666463B8D59410000000023442741CDCCCC0C4F8D5941333333338344274100000000568D594166666666B544274133333393568D594133333333E544274166666666558D594166666666C7442741CDCCCC4C4F8D594166666666C044274166666626478D5941CDCCCCCCD24427419A9999B93F8D5941CDCCCCCCF1442741CDCCCC2C3C8D59410000000017452741000000203C8D59419A9999995545274166666626418D59410000000094452741000000A0428D59419A999999A64527419A999939428D5941CDCCCCCCB245274166666646408D594100000000B94527419A9999F93B8D59419A999999BB45274100000040338D594166666666E9452741333333F3258D59419A999999014627419A9999591D8D59416666666601462741000000401A8D594100000000D2452741666666060F8D594133333333B245274133333353058D594100000000BB45274100000040008D594133333333D745274166666646FE8C5941666666661E46274166666626F98C59419A9999992D46274133333313F48C59419A99999913462741CDCCCC4CE58C59419A9999990C4627419A999979D88C5941000000000C4627419A999979D18C594166666666E94527419A999959C98C594100000000D3452741CDCCCCCCC08C594166666666D245274133333373B78C594133333333D4452741CDCCCC0CA38C594133333333FF452741666666C69C8C59416666666627462741333333F3948C5941CDCCCCCC2F4627419A9999998B8C5941000000002F4627419A9999997D8C59416666666643462741333333F3688C59419A999999394627419A9999F9618C5941333333331A462741CDCCCCEC5C8C59419A999999F4452741CDCCCC6C5B8C594166666666D845274100000060568C594133333333C84527419A9999D94D8C594133333333A245274100000080468C59410000000070452741000000603E8C5941666666663745274100000060398C5941CDCCCCCC11452741CDCCCC6C328C59419A999999DC442741333333F32E8C5941000000009B44274133333333298C5941000000007844274133333313218C5941666666666B442741CDCCCCEC1C8C5941CDCCCCCC51442741666666A6148C5941666666663B4427419A9999B90B8C594166666666154427419A999999038C59419A999999E0432741000000E0028C594133333333B5432741CDCCCCCC068C59413333333393432741CDCCCC2C098C59416666666683432741666666A6078C59416666666670432741000000E0FF8B5941CDCCCCCC4A43274166666666FC8B5941CDCCCCCC02432741333333D3F78B5941CDCCCCCCCC42274166666686E88B5941000000009A42274166666666D98B59413333333361422741000000A0CC8B59419A9999994D42274100000060C18B5941CDCCCCCC5F42274100000060B88B594133333333A3422741CDCCCCECA98B594133333333AC422741CDCCCC4CA38B5941333333339F422741CDCCCC8C9B8B59413333333376422741CDCCCCCC938B5941000000004D422741CDCCCC2C888B59419A99999939422741000000A07F8B59410000000036422741CDCCCCAC768B59413333333345422741666666466F8B5941CDCCCCCC66422741CDCCCCAC668B59413333333366422741666666465F8B59419A9999996842274166666626558B59419A99999958422741666666C64D8B5941666666663F422741333333B34A8B59419A99999913422741CDCCCCAC458B594166666666AC412741000000C0408B5941666666668341274166666666398B5941CDCCCCCC824127419A999999318B594166666666824127419A9999992A8B5941000000006341274133333333258B5941000000002E412741CDCCCC4C238B594166666666024127419A9999B9238B5941CDCCCCCCCD4027419A999939298B594166666666A5402741CDCCCCAC298B5941CDCCCCCC6040274100000040268B5941CDCCCCCC47402741000000E0258B5941CDCCCCCCEA3F27419A9999592D8B594133333333CF3F274133333373328B594133333333A13F2741333333D33B8B59419A9999994D3F2741333333B3438B5941333333330C3F274133333353458B594100000000CE3E2741CDCCCCAC428B59419A999999793E274166666606408B59419A999999473E2741000000003D8B594166666666343E2741666666C6368B5941CDCCCCCC2D3E27419A9999992E8B594133333333EF3D2741CDCCCCCC2A8B594133333333C03D2741CDCCCC8C268B594133333333973D2741333333B31B8B594166666666A03D2741333333B3158B594100000000F73D2741333333D30D8B594133333333283E2741CDCCCC8C078B594166666666373E2741666666E6008B5941333333332D3E274100000040F58A594133333333363E2741CDCCCC2CF08A594166666666613E27419A9999B9E88A594100000000613E2741CDCCCC0CE48A59419A999999603E27419A999999DE8A59419A999999693E274133333333D78A5941CDCCCCCC5F3E274166666666D18A594133333333273E2741CDCCCC6CCA8A594166666666173E274166666666C58A59419A9999992F3E274133333373BC8A5941CDCCCCCC3E3E2741333333F3B68A594100000000163E27419A999959B28A5941CDCCCCCC023E274100000020AC8A594133333333FC3D2741666666E6A58A5941CDCCCCCC4B3E27419A999939918A59419A999999543E2741CDCCCCCC898A59419A999999443E2741000000A0818A5941CDCCCCCC273E27419A9999D97D8A5941000000001E3E2741666666A67C8A594100000000033E2741333333937F8A5941CDCCCCCCC23D2741333333B38E8A594133333333693D2741CDCCCCEC968A5941666666662D3D2741666666669B8A594133333333F13C2741333333B39C8A594100000000C93C2741000000809B8A594133333333733C2741333333D3928A594133333333A03B2741666666068E8A594166666666783B2741CDCCCCAC8E8A594166666666FB3A27419A9999B9958A594166666666D93A27419A999939968A594133333333A63A2741CDCCCC0C978A5941CDCCCCCC0F3A274133333373988A59419A99999983392741000000E0998A5941666666665639274166666606988A5941333333334639274100000020968A594133333333CC382741000000C0878A594133333333783827419A999919838A5941CDCCCCCC553727419A999959868A59413333333341372741CDCCCC8C858A59419A99999925372741CDCCCC0C818A59410000000011372741CDCCCCCC7F8A59419A999999863627419A9999597D8A59419A99999968362741CDCCCC6C7B8A5941000000001735274133333393748A5941CDCCCCCCB23427419A999979678A59419A9999998533274100000020548A594166666666B6322741666666664A8A5941CDCCCCCCB0312741CDCCCCEC1C8A594166666666233127419A999959058A5941666666660231274166666626FA89594166666666FA3027419A9999F9D08959419A9999991F312741666666E6CB895941CDCCCCCC6331274100000000C889594100000000B9312741333333F3C88959419A99999916322741666666A6A3895941CDCCCCCC29322741666666A699895941CDCCCCCC00322741666666468989594133333333E8312741666666267889594166666666D131274100000000798959419A999999AF312741CDCCCCEC798959419A9999998F312741CDCCCC0C7B8959419A9999996F312741666666C67C8959410000000052312741CDCCCCAC7E895941CDCCCCCC383127419A9999F980895941000000001E312741666666A6838959413333333303312741000000408689594100000000F2302741333333938789594166666666E130274100000080888959419A999999CA3027416666660689895941CDCCCCCCA5302741CDCCCC6C8989594166666666783027419A9999B9898959410000000052302741CDCCCC2C8A8959419A99999931302741000000008B895941CDCCCCCC25302741CDCCCC2C8B8959416666666616302741666666868C8959410000000010302741000000608C895941CDCCCCCC0B302741333333138D8959410000000006302741000000E08D895941CDCCCCCCF52F2741CDCCCC6C8F89594100000000E02F2741666666869189594133333333CB2F274100000060928959419A999999B02F2741000000E09289594133333333982F2741666666A69389594166666666912F27419A9999D993895941CDCCCCCC882F2741333333D394895941666666667F2F27419A9999599889594100000000752F274133333353A089594100000000652F274166666606AF89594166666666612F2741CDCCCC4CB8895941CDCCCCCC542F274133333333BE8959419A999999382F274166666626C3895941000000002C2F27419A999999C8895941333333332C2F274166666626CC895941333333333E2F27419A999979D3895941666666665D2F2741000000E0DB8959419A9999995D2F274166666686E089594100000000552F2741CDCCCCCCE389594100000000122F2741CDCCCC0CEC89594133333333622E274133333393F6895941CDCCCCCC192E2741CDCCCCCCF789594166666666932D274133333313FA89594100000000772D2741666666A6FA89594100000000572D2741666666E6FE89594100000000142D2741666666660E8A5941CDCCCCCCE72C274100000040158A594100000000B62C2741CDCCCCAC198A5941333333336B2C2741CDCCCC8C208A5941CDCCCCCC322C274100000040258A594166666666102C2741666666062A8A594100000000FF2B2741333333B32C8A5941CDCCCCCCEE2B274133333333308A594166666666E62B274166666606328A594133333333DF2B274100000040328A594133333333E82B2741CDCCCC8C388A59419A999999EE2B2741CDCCCCAC3D8A5941CDCCCCCCF42B2741CDCCCC2C428A5941CDCCCCCCF82B2741333333F3468A594166666666FA2B2741000000004B8A594100000000FC2B274100000000508A59419A999999FD2B2741CDCCCC0C558A594100000000022C2741333333F3598A5941CDCCCCCC052C2741666666A65D8A5941333333339E2B274166666606548A594166666666AD2A2741000000E0418A59419A999999F12927419A9999B9348A594166666666AF2927419A9999D9348A5941333333332E2927419A999939338A594100000000C52827419A999919458A5941CDCCCCCCB728274133333353458A5941000000008E28274133333353408A594133333333DB272741CDCCCC0C048A594100000000EC24274166666646D489594100000000E82227419A999919AD89594100000000BA222741000000A0A6895941333333332D222741333333B392895941CDCCCCCC002227419A9999B98E89594100000000A8212741666666C687895941CDCCCCCC722127416666664680895941666666665C212741666666669089594133333333E91F2741000000008D8959419A999999191F27419A9999F98D8959419A999999981E27419A99999986895941CDCCCCCCD61D2741666666467B895941333333337A1D27419A9999D976895941CDCCCCCCEF1C27419A9999D97089594133333333DC1C2741666666E66F895941CDCCCCCCC01C2741CDCCCC0C6F8959419A999999A91C2741000000A06E895941CDCCCCCC7C1C2741000000C06D89594133333333511C2741CDCCCCEC6C895941CDCCCCCC1E1C27419A9999B96B89594133333333FB1B2741333333F36A895941CDCCCCCCE71B2741CDCCCC8C6A89594166666666CC1B2741000000406A895941666666665A1B274133333393A8895941	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	01010000206A080000663C98A62C312741000000E0D18B5941	580230000	Z	Bazoches	5802300	58023	58	27	15
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	01010000206A080000DC290B331ACB26410000000071735941	580240000	Z	Bazolles	5802400	58024	58	27	29
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	01010000206A0800005C9CD6AC891B2641CDCCCC2C4D555941	580250000	Z	Béard	5802500	58025	58	27	8
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	01010000206A0800005C8A8246DC98264166666636CE7F5941	580260000	Z	Beaulieu	5802600	58026	58	27	16
01060000206A08000001000000010300000001000000950200000000000069CD25419A999999A5755941CDCCCCCC8FCD254133333393AA755941666666669BCD254133333393AC75594166666666BFCD254133333393AF755941333333331FCE2541CDCCCC6CC4755941666666663ECE2541000000E0CC755941000000003ECE254166666666CE755941CDCCCCCC66CE25419A9999D9DA7559416666666685CE25419A9999B9E9755941000000009BCE2541000000C0FD755941333333338CCE2541333333F3167659410000000088CE25419A999959217659416666666686CE2541666666C62B7659416666666677CE2541000000403C7659410000000075CE2541333333F3527659410000000070CE2541CDCCCC6C5F765941333333335DCE2541666666A6757659413333333358CE25419A9999F9957659410000000056CE2541333333F3A67659416666666659CE2541CDCCCC4CB67659413333333359CE254133333393C37659419A99999957CE2541CDCCCC4CCE7659416666666642CE254166666666D4765941CDCCCCCC36CE25419A999999D77659413333333313CE2541CDCCCC0CDA7659419A99999907CE2541666666A6DB76594100000000FDCD2541CDCCCCACDE76594133333333F6CD254133333393E5765941CDCCCCCCF6CD254133333313ED76594133333333F7CD2541CDCCCCACF27659410000000006CE25419A999999F8765941666666663BCE254133333333087759413333333362CE25419A999919127759413333333383CE2541CDCCCC8C1D7759419A999999AACE25419A99999932775941CDCCCCCCB8CE2541CDCCCC4C41775941CDCCCCCCE2CE254166666666697759413333333304CF25410000002073775941CDCCCCCC3DCF254166666666827759416666666668CF2541333333338E775941000000008FCF254133333373977759419A999999F8CF254133333373B3775941666666662AD025419A999939C0775941CDCCCCCC41D025419A999999CA7759419A99999956D02541666666A6D4775941666666665FD025419A999999D97759410000000091D02541000000C0F7775941CDCCCCCCA5D02541CDCCCC2C0178594100000000B8D025413333337305785941000000000DD12541CDCCCC2C1E7859419A99999988D125419A9999593D78594166666666FED12541333333735F785941333333337ED225410000002074785941CDCCCCCCC8D22541CDCCCC2C817859419A999999DDD22541333333139A78594166666666E2D225419A9999D9A77859413333333334D325419A9999F9C17859413333333358D32541000000C0CD785941666666666AD325419A9999D9D27859419A99999955D3254133333353DB78594100000000E2D22541CDCCCCACEA785941333333335CD22541CDCCCC6CFA785941CDCCCCCC16D225419A99997904795941CDCCCCCC63D12541666666E61D7959419A99999949D1254133333333237959419A9999998FD125419A9999992B79594133333333D5D12541666666E632795941666666660CD225419A9999D9377959416666666657D22541333333133B7959419A999999E0D22541666666663E795941CDCCCCCC42D3254100000000417959419A999999B0D325419A9999B9457959419A99999921D425419A9999594D7959413333333341D425410000008050795941000000009AD42541000000E0467959419A999999BFD42541333333F3417959419A99999903D525419A9999193C7959410000000026D52541000000A03A7959413333333349D52541CDCCCCEC387959416666666697D52541CDCCCC8C377959419A999999DFD525419A9999F9377959419A999999F6D525410000008034795941666666663AD62541333333B32C7959416666666602D725419A9999F922795941CDCCCCCC11D825413333337312795941000000002AD92541333333130379594166666666FBD92541CDCCCCACF77859419A9999996CDA254166666626F3785941666666668CDA254166666646F37859419A999999B8DA2541CDCCCCECF378594133333333FDDA254133333353F67859419A9999992ADB2541333333F3F57859419A999999A1DB254133333373EC785941CDCCCCCCDBDB2541CDCCCCACE4785941CDCCCCCC15DC25419A999939DD785941CDCCCCCC5DDC2541CDCCCCACDA7859410000000096DC25419A999979D9785941666666669CDC2541CDCCCCACDB78594133333333ABDC25419A999919DE785941CDCCCCCCACDC254100000060E37859419A999999B5DC2541CDCCCC4CE5785941CDCCCCCCD1DC25419A999999E678594133333333FBDC254166666666E5785941000000002DDD2541CDCCCC0CE378594166666666AADD254133333373D77859410000000030DE254166666686C97859410000000071DE254100000080BD7859410000000099DE2541333333B3B77859413333333335DF25419A999979B57859419A99999979DF2541CDCCCC6CB278594166666666A4DF2541000000E0B078594133333333B5DF254100000080B078594100000000BEDF254133333393B078594166666666BFDF254100000040AF78594133333333CCDF254133333373AF785941000000000AE0254166666646AD7859416666666631E0254166666686AB7859416666666664E0254100000080A87859410000000075E0254166666626A77859413333333386E0254133333333A57859410000000095E02541CDCCCC8CA378594133333333B8E02541CDCCCC8CA0785941CDCCCCCCCBE025419A9999799E785941CDCCCCCCDBE02541666666069B78594133333333FFE02541666666E6987859419A9999992DE1254166666666987859416666666634E12541666666669C7859419A9999993BE125419A9999B9A4785941CDCCCCCC3CE12541CDCCCCACAD7859410000000041E12541CDCCCCACC2785941666666663CE125419A999959C87859419A99999937E1254100000000D07859413333333336E125419A999959D77859416666666636E12541CDCCCC6CD87859416666666636E1254133333373DA7859416666666631E1254133333333E4785941CDCCCCCC2BE1254100000080EC7859410000000022E1254133333373F67859419A9999991BE125419A9999B9FE785941CDCCCCCC06E125419A9999F9077959419A999999E8E02541666666A61079594133333333CEE02541000000A0167959419A999999A7E02541000000A01E795941333333338AE025419A999939257959416666666677E02541333333D32B7959419A99999967E02541CDCCCCEC32795941666666665BE02541000000403E7959419A99999956E025413333337345795941CDCCCCCC4DE02541666666C64A7959416666666647E02541333333734F7959413333333314E12541666666C67A79594100000000F8E02541CDCCCC4C7E79594133333333C4E02541333333D3867959416666666694E02541333333D38E795941CDCCCCCC63E025419A99995997795941333333335DE02541333333B3997959416666666662E02541333333539C7959419A99999970E0254133333373A17959416666666681E0254166666606A8795941666666668FE0254133333313AE7959419A9999999BE025419A999979B87959419A99999998E0254100000000BE7959419A99999985E0254166666686C5795941333333336CE0254133333333CB79594166666666A8E02541666666A6D879594133333333F6E025419A9999F9F07959419A9999991AE125419A999979FB795941666666662FE12541333333B3067A5941CDCCCCCC30E1254133333333147A5941000000001DE12541333333331D7A59419A999999F5E0254133333353297A594133333333CAE0254133333313317A594133333333C6E02541000000C0347A594166666666CBE025419A999939387A59419A999999DBE02541CDCCCC0C3B7A594133333333F1E025419A9999793F7A594166666666FBE02541CDCCCC8C427A5941000000000AE125419A9999B9477A59413333333312E12541666666064A7A5941333333331BE125419A9999F94B7A5941000000002EE12541333333F34D7A59413333333344E12541000000E04F7A5941666666665BE12541CDCCCCAC517A5941CDCCCCCC6FE125419A999919547A5941333333338AE12541000000A0577A594100000000A1E12541333333935B7A594100000000C3E1254166666606617A59419A999999DFE1254100000040667A594100000000F7E12541333333D3697A5941666666660BE22541CDCCCC4C6C7A59413333333312E22541000000006E7A5941000000003AE22541CDCCCC8C757A5941CDCCCCCC3FE225419A9999197B7A59413333333330E22541666666A67C7A59413333333325E22541333333B37C7A5941CDCCCCCC20E22541333333B3807A59419A99999902E22541CDCCCC4C897A59419A999999F0E12541666666868F7A594166666666EFE12541000000E0917A5941CDCCCCCCF4E1254100000020957A59419A999999FBE12541CDCCCCAC967A5941CDCCCCCC05E225419A999979987A59419A9999991BE22541333333139B7A5941CDCCCCCC20E22541666666669C7A59410000000024E22541333333539F7A5941CDCCCCCC26E225419A999999A47A5941000000002BE225419A999979A67A59413333333343E22541CDCCCC6CAA7A59419A9999995CE22541000000A0AC7A59410000000088E22541CDCCCC4CAB7A59419A999999BDE225419A999979AB7A59419A999999DFE225419A999959AC7A5941CDCCCCCC23E325419A9999B9AE7A5941CDCCCCCC78E3254100000060B27A594100000000E2E32541333333D3B77A59413333333332E4254133333333BE7A59410000000091E42541000000E0C67A594100000000F0E4254100000040D27A594133333333EFE4254100000040D77A5941CDCCCCCCECE42541CDCCCC8CDC7A59419A999999F6E42541000000A0DE7A5941CDCCCCCC08E52541666666C6DF7A5941CDCCCCCCE4E5254133333373F97A59416666666644E62541333333D3007B5941000000008DE62541333333B3077B59416666666617E725419A999919147B59416666666653E72541000000E01A7B59410000000077E72541666666061D7B594133333333BAE725419A9999D91D7B594133333333C2E72541666666261E7B594166666666CCE72541333333731E7B594133333333D9E72541CDCCCC8C1E7B594100000000DEE72541000000E01E7B59419A999999E8E72541000000A01D7B5941CDCCCCCCFDE72541CDCCCC8C1B7B5941CDCCCCCC0AE825419A9999791A7B59413333333313E82541000000C0197B5941666666662BE82541CDCCCCAC177B59419A99999947E8254166666666157B59419A9999995EE82541666666C6137B5941CDCCCCCC76E82541000000A0127B59413333333386E8254166666606127B59419A9999999BE82541CDCCCC0C117B59419A999999B5E8254166666626107B594100000000E5E82541666666660E7B594166666666F5E82541333333F30D7B5941000000000BE92541000000800D7B59419A9999992FE92541CDCCCC2C0D7B594133333333D3E92541666666060C7B59419A999999F0E92541CDCCCC8C0B7B59413333333313EA25419A9999390B7B5941CDCCCCCC29EA2541000000600B7B59413333333361EA2541CDCCCC4C0B7B59419A9999997AEA2541000000600B7B5941CDCCCCCCB0EA2541CDCCCC6C0B7B59419A999999F2EA2541CDCCCC8C0B7B59410000000019EB2541666666660B7B5941CDCCCCCC3CEB2541666666060B7B59419A9999995BEB25419A9999990A7B5941CDCCCCCC7DEB2541000000E0097B59419A999999ACEB25419A9999D9087B5941CDCCCCCCEBEB254166666646077B5941666666662AEC254100000080057B59413333333382EC2541CDCCCC6C047B59419A999999E7EC2541CDCCCC2C047B5941000000000BED2541000000A0027B59416666666645ED2541CDCCCCCCFE7A5941CDCCCCCC6FED25419A999979FA7A59410000000099ED2541CDCCCC0CF47A59413333333303EE2541333333F3E87A5941333333332EEE25419A999939E67A5941666666667CEE25419A9999F9E37A5941CDCCCCCC2EEF254133333393DC7A59410000000059F0254100000040CB7A59419A99999972F025419A999959C97A59410000000088F12541000000C0B47A5941666666667BF22541CDCCCCCCA27A594100000000B6F22541666666469E7A5941666666663EF32541666666C6917A594166666666ACF32541000000A0897A59419A9999993BF42541000000A07D7A5941666666660CF52541CDCCCC8C6E7A594166666666BBF52541000000E0687A5941666666660FF62541666666C6637A5941333333338CF625419A999979587A594166666666D1F6254166666666567A5941CDCCCCCC34F72541666666C6557A594166666666D1F72541666666C6567A59410000000043F82541000000005E7A5941CDCCCCCC79F82541CDCCCC6C627A59410000000094F8254166666666627A594133333333BFF8254166666606617A594100000000F7F82541000000A05C7A59410000000028F92541000000C0527A59413333333386F92541CDCCCCCC3E7A594133333333B9F92541CDCCCC0C377A5941CDCCCCCCE8F925419A9999B92F7A59413333333343FA2541666666E61E7A594133333333A1FA25419A999999137A59410000000096FA2541666666A6127A5941333333338DFA254133333393127A59413333333385FA2541CDCCCC8C127A5941333333337DFA2541333333F3117A59413333333378FA254100000020117A59413333333370FA2541CDCCCC2C107A59410000000062FA2541000000400F7A5941666666664EFA25419A9999390E7A5941CDCCCCCC3EFA2541000000000D7A5941000000002BFA2541CDCCCC4C0A7A594100000000F7F92541CDCCCC8C047A594100000000BBF9254166666646FF7959419A9999996DF9254166666626F97959410000000003F925419A999919F27959419A999999BCF8254133333353ED795941666666666CF82541CDCCCC4CE87959413333333303F825419A9999B9E27959419A999999A2F72541CDCCCC2CDF7959410000000078F72541666666C6DC7959410000000025F72541000000C0D1795941CDCCCCCCDEF62541333333D3CA795941666666669FF625419A999919C57959413333333355F62541CDCCCC8CBE7959416666666614F625419A999959B879594100000000DAF525419A999939B3795941CDCCCCCC80F5254100000060AC795941CDCCCCCC31F52541CDCCCCACA47959419A99999901F52541000000A09F79594100000000AAF4254133333333957959419A99999959F42541000000E08A7959413333333334F4254166666646847959413333333311F42541666666467B795941CDCCCCCCDBF32541CDCCCC6C6E79594166666666B6F32541000000E0657959416666666690F32541CDCCCC0C5A795941CDCCCCCC81F3254100000080527959419A99999977F32541000000A04D795941666666667DF32541CDCCCC8C497959413333333395F325413333339342795941CDCCCCCCA6F32541CDCCCC6C3A7959419A999999A9F32541CDCCCC4C3779594133333333A9F32541CDCCCCCC347959419A999999C6F32541CDCCCCEC33795941000000000CF4254133333393317959416666666655F42541666666E62D79594166666666FBF42541CDCCCCCC2A79594166666666BDF525419A9999F9267959416666666647F62541333333B3247959413333333383F62541CDCCCC4C24795941CDCCCCCCA2F62541CDCCCCEC2279594100000000CBF62541000000A01F7959419A99999936F72541CDCCCCAC0F7959413333333377F7254166666646FE7859419A9999998EF725419A999959F5785941CDCCCCCCB5F7254133333313EA78594100000000C9F7254133333353DC78594166666666DFF72541666666C6CB785941CDCCCCCCE7F725419A999959BB78594100000000ECF72541333333B3AE785941CDCCCCCCF9F7254166666606A47859419A9999990AF82541CDCCCC8C9C785941CDCCCCCC1DF825416666664691785941666666663DF825419A999999847859419A99999964F8254133333373757859416666666664F8254166666686717859419A99999968F82541333333D3677859416666666696F825419A9999B96078594100000000F0F82541CDCCCCCC55785941333333331FF92541333333B34C785941333333334EF92541666666A6437859410000000059F92541666666863E785941000000004FF92541666666463B785941333333334DF9254133333353357859419A9999995CF9254133333313307859413333333389F92541CDCCCC4C2878594100000000C1F92541CDCCCC8C20785941CDCCCCCCEBF92541000000201F7859419A99999976FA25419A999999197859416666666697FA2541666666261578594166666666E9FA254100000060097859416666666664FB254100000000F37759413333333397FB2541CDCCCC0CE877594100000000DDFB254166666686D87759419A999999F7FB2541000000E0CA775941666666661EFC254133333333BD7759410000000061FC2541CDCCCC4CB4775941000000009CFC254133333353AF7759419A999999E4FC2541CDCCCC6CA177594133333333EEFC2541666666269B77594100000000FAFC2541000000C0947759419A999999ECFC2541666666068477594100000000BFFC25419A9999796A775941CDCCCCCCA3FC2541CDCCCC4C5A775941000000008FFC2541333333D34D7759413333333381FC2541333333333D7759419A999999A1FC2541000000203777594166666666B2FC254100000080377759416666666611FD2541666666A6367759416666666688FD25416666666634775941CDCCCCCCD9FD2541000000E0317759410000000017FE2541333333B32A7759410000000040FE2541CDCCCC4C227759419A99999957FE2541333333F316775941666666669BFE2541333333D3FF7659419A999999B5FE254166666606F376594100000000D8FE254166666666E476594166666666FFFE254133333373D47659410000000022FF2541CDCCCCECC87659419A9999997CFF25419A999919B8765941CDCCCCCCACFF25419A9999F9B1765941333333331500264100000080A676594100000000810026419A999919997659419A999999B3002641000000408C76594133333333F2002641333333137E76594133333333390126419A9999F9717659416666666672012641333333B36B765941333333331302264100000000627659410000000056022641666666065C765941CDCCCCCC9E022641666666E65476594133333333BF022641666666E64F76594166666666C102264166666686487659419A99999904032641CDCCCC8C36765941CDCCCCCC3A032641333333D32C7659419A9999994F0326419A999939257659419A9999997C0326419A9999991476594133333333B5032641333333D3F77559419A999999CD032641000000A0EB75594100000000E80326419A9999B9E27559410000000098032641000000A0D4755941666666667C0326419A999979D6755941CDCCCCCCFF02264100000080DB755941CDCCCCCCE402264133333353D47559419A999999B8022641333333B3CD7559419A9999998A022641000000E0C37559419A999999EE01264166666646AA755941CDCCCCCC9101264100000020A07559419A99999948012641000000A098755941333333330C012641333333B393755941CDCCCCCCFE00264133333313947559419A999999ED002641000000209575594133333333CB002641CDCCCC8C9B75594166666666B4002641666666E6A27559413333333395002641000000C0B6755941CDCCCCCC8F00264166666646BD755941666666668A002641CDCCCC4CBE755941666666667B00264166666666BE7559413333333363002641333333D3BD75594100000000B2FF254166666626BA755941CDCCCCCCA9FF2541666666E6BC755941000000006CFF25419A999959C7755941333333332BFF2541000000C0D075594100000000E0FE25419A999939CB7559419A99999976FE254133333393C67559419A9999993AFE254133333353C5755941CDCCCCCC04FE254100000040C27559413333333362FD2541666666C6B875594166666666CDFC2541CDCCCCCCAE755941CDCCCCCCC3FC254166666646AE75594133333333BBFC25419A999919AE75594166666666A5FC25419A999919AD755941333333336DFC254166666626AA7559413333333329FC25419A999979A675594100000000F5FB254100000020A375594100000000C9FB2541000000E09F755941333333338EFB25419A9999199B755941333333336EFB254100000060987559416666666631FB2541333333D3937559413333333301FB25419A9999F98F755941CDCCCCCCF7FA2541333333F38E75594133333333EEFA2541666666268D755941CDCCCCCCE9FA2541666666868B75594100000000E4FA2541333333338A75594133333333D8FA25419A9999998875594133333333BAFA2541333333138575594133333333A2FA25419A999999827559410000000096FA2541666666A6807559419A9999998FFA25419A9999997E7559413333333386FA25419A9999197B755941000000007AFA254166666626787559419A99999972FA2541CDCCCCEC74755941CDCCCCCC74FA25419A9999B972755941CDCCCCCC81FA254166666686707559419A9999998FFA2541333333B36D755941333333339EFA25419A9999D96A75594100000000A9FA254166666626677559419A999999AEFA25416666666663755941CDCCCCCCAAFA2541CDCCCC6C6175594133333333A7FA2541000000605F755941333333338BFA2541333333B359755941000000004AFA25419A9999194E755941CDCCCCCCEDF92541CDCCCC8C3F755941333333339FF9254166666686337559410000000041F925419A999919257559416666666613F92541333333131E7559410000000000F925419A9999591B7559419A99999923F92541000000E0187559419A999999E9F82541666666C613755941333333337EF82541000000C00A755941666666662DF82541333333330175594166666666D0F7254133333353FA7459416666666668F7254100000000F574594166666666F8F6254166666686F27459410000000070F62541CDCCCC0CEE745941CDCCCCCC56F625419A999979EE7459416666666601F6254100000020EF745941CDCCCCCCE3F5254133333353EE7459419A999999D6F5254100000020ED74594133333333CAF52541333333B3EA74594166666666B0F525419A999979E67459410000000092F52541666666A6E37459410000000063F525419A999939E1745941666666664FF5254133333333DF745941000000003EF52541CDCCCC8CDB7459419A9999992CF5254166666666D97459410000000013F5254100000060D7745941CDCCCCCCD8F425419A999919D274594133333333D7F4254133333313C974594100000000D5F4254166666666BC745941CDCCCCCCD1F42541333333D3B77459419A999999CCF425419A999999B1745941CDCCCCCCC8F42541CDCCCCACAD74594133333333BAF42541000000E0A874594166666666B2F4254166666686A674594100000000ACF4254166666626A574594133333333A3F42541333333D3A374594133333333A1F4254133333373A2745941666666663EF4254100000000A0745941CDCCCCCCFFF32541CDCCCC6C9774594166666666E6F32541000000C090745941CDCCCCCCCCF325416666660687745941CDCCCCCCC8F325419A9999F97F745941CDCCCCCCCCF32541333333537474594100000000E5F32541000000E06A745941000000000EF42541000000E060745941000000005AF42541666666264D745941666666669DF425419A9999D93674594133333333CEF42541000000602474594166666666A3F42541666666E626745941CDCCCCCC84F425413333339328745941CDCCCCCC67F42541333333132A7459416666666650F42541CDCCCCEC29745941333333333FF425410000008027745941CDCCCCCC27F4254100000040237459413333333315F42541CDCCCC4C2174594133333333F4F32541CDCCCC0C1F7459419A999999D0F32541000000E01E745941000000009CF32541CDCCCCEC1F7459410000000076F325419A9999F91F745941CDCCCCCC58F32541333333331D7459410000000030F325419A9999F9187459416666666607F32541CDCCCC6C1574594100000000EEF22541666666A6147459419A999999B4F225413333333317745941666666665CF22541666666261D7459416666666634F22541666666C62274594100000000F8F12541000000002E74594100000000D1F125413333339337745941CDCCCCCCBDF125419A9999194074594166666666AAF125416666666645745941CDCCCCCC96F125416666666649745941CDCCCCCC59F125419A9999F9497459416666666612F12541000000C04874594133333333E7F025419A9999D94974594100000000CEF02541000000805074594100000000ABF025416666662657745941CDCCCCCC8DF02541CDCCCCCC61745941CDCCCCCC90F025419A9999396D74594166666666D8EF25419A99993961745941333333338DEF25419A9999D95D74594100000000EDEE25419A9999595B7459419A99999970EE25419A9999795B74594133333333FAED25419A9999595B7459419A999999C4ED25419A9999195A745941333333337DED254133333333567459419A999999FDEC2541666666464D745941666666669AEC2541CDCCCC8C6174594133333333A5EC2541333333F36474594133333333B8EC2541000000206774594166666666B9EB25419A99995985745941CDCCCCCCA3EB2541333333F384745941CDCCCCCCA6EB2541666666268B74594100000000A8EB25419A9999B98E74594100000000A6EB2541CDCCCC0C9474594133333333A5EB25419A9999F996745941CDCCCCCCA7EB2541CDCCCCAC9A7459419A999999ACEB2541333333139E74594166666666B3EB254166666626A174594166666666BAEB25419A9999B9A37459419A999999C1EB2541CDCCCC0CA67459419A999999CAEB2541000000C0A874594166666666D3EB2541000000C0AB745941CDCCCCCCDDEB2541CDCCCC4CAF74594166666666ECEB2541000000A0B374594100000000FCEB2541666666A6B87459419A999999FFEB254133333353BA745941CDCCCCCC04EC254100000000BF7459416666666609EC254133333393C77459419A99999909EC254100000060D274594100000000DEEB2541666666C6DF7459419A999999D3EB2541CDCCCC4CE174594100000000ABEB254100000040E974594166666666A6EB254166666686EC7459413333333381EB25419A999979EE745941333333334BEB2541CDCCCCACF4745941CDCCCCCCC5EA25419A999999F77459413333333375EA254133333373F77459419A99999907EA254133333353FA7459419A999999ECE9254100000060FC745941333333338DE925419A9999D9FE745941000000003DE9254100000040047559419A99999901E92541333333B30775594166666666AEE82541CDCCCC0C0B7559413333333385E725419A9999F91E75594166666666C8E5254100000000397559410000000039E42541333333D34E7559419A99999991E2254166666646657559419A99999949E12541CDCCCCAC727559410000000030E025419A9999397F7559413333333385DF2541333333B3867559419A999999F6DE25419A999979857559419A9999992DDE25410000008083755941666666662EDE25419A999959897559410000000028DE2541666666668A7559416666666620DE25419A9999598A755941CDCCCCCC16DE25419A9999398A7559419A99999944DB2541CDCCCC2C6F75594166666666ECDA25419A9999996A75594166666666CBDA2541666666066C75594166666666A0DA2541333333736E755941666666667FDA2541CDCCCCEC6F7559419A99999961DA2541333333D370755941000000003DDA2541CDCCCC2C71755941000000000BDA2541666666267175594100000000CAD92541333333F37075594133333333BED92541000000C070755941CDCCCCCC7BD92541333333D36D7559416666666667D925413333331362755941666666666BD9254100000020597559419A9999996DD925419A9999B94B755941CDCCCCCC68D925419A999939487559416666666668D9254100000060427559416666666634D92541CDCCCC8C3B75594100000000A8D82541CDCCCC2C27755941CDCCCCCC78D82541666666C624755941CDCCCCCC2ED82541666666A62575594133333333EFD7254166666686257559413333333358D725419A9999592A75594100000000CCD62541333333D3317559413333333367D625413333337339755941000000000DD625419A9999D93E7559419A999999E2D525419A9999B9427559413333333394D52541666666A6437559419A999999A2D42541CDCCCC0C4C755941CDCCCCCC08D42541CDCCCCAC507559419A99999962D325419A9999195575594100000000A0D225419A9999795F7559419A999999C8D12541000000206D75594100000000D0D025419A9999997B75594133333333E3CF2541000000A086755941CDCCCCCC89CE2541000000009575594133333333BECD2541CDCCCCCC9F7559410000000069CD25419A999999A5755941	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	01010000206A080000963746CB43E62541CCCCCC4C99775941	580270000	Z	Beaumont-la-Ferrière	5802700	58027	58	27	29
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	01010000206A080000F6499FA4024F2641343333B3A55C5941	580280000	Z	Beaumont-Sardolles	5802800	58028	58	27	30
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	01010000206A0800004656C580CB83264100000050BB895941	580290000	Z	Beuvron	5802900	58029	58	27	10
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	01010000206A080000D89CE73845E42641CCCCCCDC0B635941	580300000	Z	Biches	5803000	58030	58	27	25
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