SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep65;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep65 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep65','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep65','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep65','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep65"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000689EE4467C621B4100000000CDB35741	650010000	Z	Adast	6500100	65001	65	76	1
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	01010000206A080000268614B1A3B01B41666666F6DEC55741	650020000	Z	Adé	6500200	65002	65	76	8
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	01060000206A080000010000000103000000010000000E01000000000000C89B1D413333339348A057419A999999079C1D416666660659A057419A999999439C1D419A9999F962A05741CDCCCCCC269D1D41333333137DA05741CDCCCCCCBA9E1D41333333D39FA057419A999999479F1D4100000080A8A05741CDCCCCCC76A01D4133333393C2A0574100000000B8A01D4166666646CBA0574166666666D0A01D419A9999F9ECA05741CDCCCCCCFAA01D41CDCCCCECFFA057410000000024A11D41666666A608A157413333333389A11D41333333D313A1574166666666CCA21D41000000E02DA1574166666666D0A21D419A9999D94BA1574133333333E5A21D413333331352A15741000000007CA41D41333333D36AA1574166666666B8A41D41CDCCCC4C6DA1574133333333B3A51D41666666E67BA1574100000000F2A51D41000000C084A157419A999999F5A51D41333333B38BA15741666666665EA61D413333337394A15741333333338FA61D419A9999199BA1574100000000CCA61D41000000E0A7A1574133333333A3A61D41CDCCCCECABA15741666666661AA71D4166666666BEA157419A99999957A81D419A9999F9D7A157416666666684A81D41CDCCCCCCF0A15741CDCCCCCC48A81D416666664607A2574133333333A3A81D41CDCCCCEC10A25741CDCCCCCC04A91D41CDCCCCAC1DA25741333333332FA91D413333339328A257410000000038A91D410000000030A257413333333361A91D416666664635A25741666666665AA91D41CDCCCC6C41A25741333333333FAF1D41CDCCCCEC4CA257416666666616B31D416666662650A25741000000002AB31D41CDCCCCAC60A257413333333307B41D41CDCCCC4C5DA25741333333332DB41D41000000005FA257419A9999993DB51D41CDCCCC0C5EA2574166666666C8B51D41000000C05BA25741333333333BB61D41CDCCCCAC57A2574166666666AAB61D41333333F35BA25741CDCCCCCCA8B81D41000000606DA257413333333399B91D410000004072A257413333333361BA1D41666666A674A25741CDCCCCCC8CBB1D410000004073A257419A999999EDBF1D41CDCCCCAC64A257416666666690C11D419A9999395EA25741333333332FC21D41666666A656A257419A999999BDC31D41333333F34EA25741000000000CC41D41CDCCCCAC43A25741CDCCCCCC5AC41D41666666E63AA257419A999999B5C41D41666666A63EA257413333333349C51D416666660632A257419A999999E7C51D41333333B327A257410000000004C81D41CDCCCCEC2EA2574166666666DAC71D419A9999191CA25741000000003AC81D41333333F301A257419A9999998BC81D419A9999F9F3A1574100000000B6C81D41CDCCCC6CEFA157419A99999985C81D41CDCCCCACE8A157416666666658C91D4133333393CEA15741CDCCCCCC44C91D41CDCCCC8CC1A157419A999999F5C81D41333333F3B7A157419A999999F5C81D41CDCCCCEC98A15741CDCCCCCCE2C81D413333339334A15741CDCCCCCCC0C81D41000000602FA15741CDCCCCCC1EC91D41333333B31FA15741666666662AC91D41000000A010A157410000000052C91D419A99991909A157416666666694C91D41CDCCCCEC01A15741000000007CC91D41CDCCCCACF9A05741666666661EC91D41CDCCCCECF2A057413333333351C81D41333333B3E7A0574100000000E4C71D41CDCCCCACDFA0574166666666C2C71D4133333333D8A057419A999999B9C71D41CDCCCC8CC5A0574133333333DDBC1D41666666C6D4A05741333333333BBC1D419A999939C9A057419A9999999DBB1D419A999939C2A057419A999999E9BA1D4166666646B5A057419A9999994FBA1D41000000A0A7A057410000000016BA1D41CDCCCC2CA0A057419A99999991B91D41CDCCCCCC99A05741333333334FB81D41CDCCCC0C8EA05741666666661AB81D413333339387A05741CDCCCCCC7EB71D41333333B37DA0574133333333C3B61D41000000806EA05741333333334BB61D419A9999396CA05741CDCCCCCCB8B51D41000000E05BA05741666666663CB51D410000002056A057410000000068B41D41666666864EA05741CDCCCCCC50B41D41CDCCCC0C4BA05741666666669CB41D416666660643A05741333333335FB41D41CDCCCC8C33A0574133333333E5B31D410000008020A0574100000000C2B31D41666666261FA0574100000000B0B31D410000006024A057413333333353B31D419A9999B91EA0574133333333D1B21D41000000E011A057410000000092B21D41000000C00DA05741CDCCCCCCC0B11D416666668605A057419A99999907B11D4133333333F69F5741CDCCCCCCE4B01D41666666A6EB9F574166666666DCAF1D4133333393C29F574100000000C4AF1D4133333353BC9F574166666666ECAF1D4100000080B29F57419A999999D3AD1D4100000060999F574166666666CAAC1D4166666626889F5741CDCCCCCCF2AC1D41000000E0829F574133333333F7AC1D41000000407B9F5741CDCCCCCC48AD1D419A9999F95A9F5741333333337DAD1D4133333313539F57416666666684AD1D4166666646499F57419A999999B9AD1D41000000803B9F5741CDCCCCCCD4AD1D41333333932F9F5741333333336DAD1D41333333D30B9F574100000000CAAC1D4133333333F49E5741666666669AAB1D4100000020D59E57413333333317AA1D4100000020BB9E57410000000078A91D41000000C0A79E5741333333339DA91D41000000E09B9E5741000000000AAA1D41666666C6989E57419A999999D9AA1D41CDCCCC0C8F9E5741333333338FAA1D41000000607E9E57410000000048AB1D4166666626739E5741CDCCCCCC4CAC1D41666666A6699E57416666666654AC1D41CDCCCCEC649E5741333333330FAC1D419A9999395F9E57419A9999998BAC1D4133333393569E57410000000092AD1D419A9999B9469E5741000000001EAE1D41CDCCCCCC439E57413333333371AE1D41000000602A9E57419A999999A7AE1D419A999999169E57410000000036AF1D4100000020F89D57419A9999990DB01D41CDCCCCCCD69D57410000000000B01D41CDCCCCCCC99D5741CDCCCCCCD8AF1D4100000060BF9D5741000000009EAF1D41CDCCCCACBD9D57413333333351AF1D4133333353B39D574133333333D7AE1D41CDCCCCACAD9D5741CDCCCCCC40AE1D4166666686A19D5741CDCCCCCCA8AD1D4133333313929D57413333333329AD1D41666666868E9D5741666666666CAC1D4133333333819D57419A99999983AC1D419A999939799D5741CDCCCCCC80AC1D41CDCCCC4C6F9D574133333333A1AC1D41666666E6639D57410000000030AD1D419A999979529D5741CDCCCCCCDEAD1D419A999999489D5741CDCCCCCC50AE1D41666666E63B9D5741CDCCCCCC56AF1D419A9999D9389D574166666666BEAF1D41666666A6449D574166666666B0B01D4166666626449D57413333333313B11D419A999919409D57419A9999994BB11D4100000000379D57419A99999941B11D419A9999192F9D5741CDCCCCCC6CB11D4133333353229D57410000000072B11D419A999959199D5741000000005CB11D41CDCCCC2C099D57413333333319B11D41333333F3F39C574133333333C7B01D4100000040E69C5741000000007EB01D41666666C6DD9C5741000000003AB01D41000000A0DA9C57410000000088AF1D4100000040D99C57410000000054AE1D41CDCCCC2CD09C57410000000058AE1D419A9999B9CE9C57419A99999975B11D41333333F3BD9C57416666666640B31D419A999979B79C57419A9999991FB41D4100000060B29C57410000000036B51D419A999939A89C5741CDCCCCCC72B61D419A999919959C57419A99999939B71D41000000808D9C5741666666662CB91D4100000040889C5741333333337FBA1D4133333393809C57419A999999DFBA1D41CDCCCC8C679C57419A999999DDBA1D4133333393589C5741CDCCCCCCA0BA1D419A999919519C5741CDCCCCCC64BA1D41666666E64F9C5741666666669AB81D41000000205A9C5741CDCCCCCC0EB81D41333333335A9C57416666666644B71D4133333393479C574166666666DAB61D41666666A6389C57413333333375B61D41333333B32E9C574100000000ACB51D4133333393239C574133333333E3B41D41CDCCCC2C1C9C5741CDCCCCCC7EB41D41000000C0159C57419A99999941B41D41666666460E9C5741CDCCCCCCA0B31D41000000A0059C57413333333311B21D4133333353079C574100000000BCB11D41000000E0FB9B5741666666661AB11D419A999939EE9B574166666666A0B01D4133333353DF9B5741CDCCCCCCA8AE1D419A999959C09B57419A99999921AC1D419A999979A19B5741333333336BAB1D419A9999998D9B5741CDCCCCCCB4AA1D41333333F37A9B5741333333339BA91D41000000E06A9B57416666666642A81D41CDCCCC8C639B5741666666663AA61D4133333313609B5741666666669CA51D41666666666B9B57416666666612A51D41333333B37B9B5741000000009EA41D41000000C0949B5741CDCCCCCC78A41D419A9999F9A89B5741CDCCCCCC6AA41D4133333333D79B574133333333CDA31D4100000080E79B57413333333381A31D41000000C0059C5741333333334FA31D419A9999B9329C57419A999999EDA21D4166666606439C5741666666663CA21D4133333313579C57416666666614A11D41333333B3719C574133333333EB9F1D419A9999D9859C574133333333119F1D4133333373929C574100000000809D1D4100000020A49C574166666666E09C1D4133333373A59C5741CDCCCCCCB89C1D419A9999F9A79C5741333333332F9C1D4166666686B89C5741333333339D9D1D4133333313CB9C57419A9999991B9F1D419A999999E29C57413333333373A01D41666666E6FD9C57419A9999995FA01D41666666E6029D574100000000EA9F1D41CDCCCCEC119D5741CDCCCCCC749F1D419A999939279D57419A9999993B9F1D419A9999793B9D57419A9999992B9F1D41333333B35A9D5741CDCCCCCC549F1D41CDCCCC2C629D574166666666569F1D419A999959699D5741CDCCCCCCDA9E1D4100000000729D574133333333E59D1D4166666626919D574133333333D39D1D41CDCCCCCC979D5741CDCCCCCCE69D1D41666666069E9D574166666666369E1D4100000000AB9D5741333333338B9E1D41666666E6CD9D574133333333C99E1D419A9999D9DC9D574133333333579F1D4166666646EE9D5741333333339BA01D41333333D30F9E574166666666D8A01D41666666C6199E574133333333F3A01D419A9999B92D9E57419A999999F5A01D419A9999793F9E574133333333A1A01D4133333373529E574100000000EAA11D41CDCCCC8C639E5741CDCCCCCC14A21D41000000C0789E57410000000060A21D41CDCCCC0C879E574100000000BEA21D41000000C0909E574133333333D7A21D41666666A6999E57419A99999939A31D419A9999B9A39E5741CDCCCCCC04A41D41333333F3AD9E57419A99999927A41D4100000020B69E5741CDCCCCCCC4A31D4166666686C69E574133333333DBA31D41CDCCCCECCD9E57419A99999921A41D41000000E0D49E5741666666663CA41D4133333313E89E5741CDCCCCCC7CA41D419A9999F9FB9E574133333333E5A41D41666666060C9F574166666666FCA41D4133333333129F574133333333D5A41D4133333333179F57419A999999C3A41D4133333393289F5741666666669CA41D4133333373319F5741000000003AA41D41000000C03B9F57419A99999951A21D4100000000549F57419A99999995A01D41CDCCCCAC6B9F57419A9999996FA01D41CDCCCCEC7B9F57419A9999996F9F1D4166666686969F5741333333330D9F1D4133333353A49F57419A999999119E1D41000000A0E19F574133333333EF9C1D413333337325A05741333333338D9C1D41000000C035A0574100000000C89B1D413333339348A0574100000000C89B1D413333339348A05741	01010000206A080000382E72F469A81D4100000050ED9E5741	650030000	Z	Adervielle-Pouchergues	6500300	65003	65	76	9
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	01060000206A08000001000000010300000001000000330000006666666630541B41333333F369BA5741CDCCCCCCB4561B41000000006EBA57419A999999B15B1B4133333353B5BA57419A99999963591B419A9999D92DBB57419A9999996D5A1B41333333F31EBC574100000000A45B1B413333337316BC57419A999999D55C1B416666668615BC5741000000001E5D1B41666666A616BC5741CDCCCCCC585E1B413333339316BC574166666666A85E1B410000000018BC574100000000D25F1B41CDCCCC8C17BC5741CDCCCCCCC6601B413333335319BC5741CDCCCCCCAE611B41CDCCCCCC19BC5741CDCCCCCC06631B41333333931CBC5741CDCCCCCC76631B419A9999B91ABC57413333333325651B41333333F30ABC57416666666604661B419A99997907BC5741CDCCCCCC62681B41666666A609BC5741333333339B691B41000000400CBC5741666666663E6E1B4133333353F4BB5741000000000E721B4100000040C5BB574166666666CE761B4100000040B8BB5741CDCCCCCCFA781B41CDCCCC6CAEBB574100000000267A1B419A999959B2BB57413333333303841B419A999999F1BB57413333333319861B41666666A6EBBB57419A99999925881B4100000040E4BB574166666666A6881B41CDCCCC2CE3BB5741CDCCCCCCD2851B4100000040B1BB57419A999999537F1B419A99991918BB5741000000003A7E1B41CDCCCC6C06BB574166666666A27B1B41333333B3EEBA5741CDCCCCCC287C1B416666664601BA5741CDCCCCCC427C1B41666666A6D7B95741CDCCCCCC667C1B41CDCCCCCCCAB95741CDCCCCCC547C1B419A999939B1B95741666666669E7B1B413333331398B9574100000000887B1B41333333138AB957419A9999998D7B1B419A9999B981B9574133333333717B1B41000000C07BB957419A999999C3661B41333333D34AB95741CDCCCCCCDA631B419A99991901B9574100000000565F1B41666666460AB95741CDCCCCCC985D1B419A9999D991B95741CDCCCCCC4C5C1B41666666C6AAB95741CDCCCCCCEC5C1B419A9999F9ACB9574133333333635C1B4100000080CDB9574100000000345C1B41333333B3FAB9574133333333535C1B4166666626FBB957416666666630541B41333333F369BA57416666666630541B41333333F369BA5741	01010000206A0800007942DD0F7B6A1B41CDCCCC7C90BA5741	650040000	Z	Agos-Vidalos	6500400	65004	65	76	6
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	01010000206A0800008D00E1AA87731C41CDCCCC1C4EC95741	650050000	Z	Allier	6500500	65005	65	76	4
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	01010000206A08000094CC853E851B1D419A9999C9D0AA5741	650060000	Z	Ancizan	6500600	65006	65	76	42
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	01010000206A0800001A9C0ACFFA2E1C41666666262DD85741	650070000	Z	Andrest	6500700	65007	65	76	6
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	01010000206A080000F2B580412E1E1E41CCCCCC9C47BD5741	650090000	Z	Anères	6500900	65009	65	76	3
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	01010000206A0800002284EC7C7E9C1C419A9999093DCB5741	650100000	Z	Angos	6501000	65010	65	76	3
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	01010000206A080000911BB901B9D11B41333333333ABF5741	650110000	Z	Les Angles	6501100	65011	65	76	3
01060000206A080000010000000103000000010000008101000033333333AFA81E41000000607CB5574166666666B0A81E41333333F37DB5574100000000B2A81E41666666A680B55741CDCCCCCCB2A81E41CDCCCCAC81B5574100000000B6A81E419A99999983B55741CDCCCCCCBAA81E41000000A085B5574166666666C4A81E419A99991988B5574100000000CEA81E419A9999598AB5574133333333DBA81E41333333738CB5574166666666ECA81E41333333D38EB5574166666666F6A81E413333339390B55741CDCCCCCC00A91E419A9999D992B557419A9999990FA91E419A9999B994B557413333333323A91E41CDCCCC4C97B55741CDCCCCCC34A91E419A9999F998B55741000000003EA91E41333333B399B55741000000004AA91E419A9999D99AB55741CDCCCCCC56A91E41333333B39BB55741333333336BA91E41CDCCCC8C9CB557416666666680A91E41666666869DB55741333333339BA91E41333333139EB5574133333333B1A91E419A9999D99EB557419A999999C9A91E41000000809FB5574133333333EDA91E41666666A6A0B557419A99999911AA1E4100000080A1B55741CDCCCCCC22AA1E41CDCCCC0CA2B557419A99999937AA1E41333333B3A2B55741000000004CAA1E4100000060A3B557419A9999995FAA1E41CDCCCC2CA4B557413333333375AA1E41333333D3A4B557413333333389AA1E4133333353A5B557416666666694AA1E41CDCCCCCCA5B557410000000098AA1E41333333F3A5B5574166666666A2AA1E419A9999B9A6B5574166666666A6AA1E4166666666A8B55741CDCCCCCCA8AA1E4166666686AAB55741CDCCCCCCACAA1E419A9999F9ABB55741CDCCCCCCB2AA1E419A999939ADB5574133333333B7AA1E4100000080AEB5574133333333BDAA1E4166666646B0B5574133333333C3AA1E4166666686B1B5574133333333C5AA1E4133333373B2B557419A999999C9AA1E4166666666B3B557419A999999CBAA1E4166666606B5B55741CDCCCCCCCCAA1E41666666C6B6B5574133333333CDAA1E41666666C6B7B5574166666666CEAA1E419A999939B9B55741CDCCCCCCCEAA1E41CDCCCC4CBAB5574100000000CEAA1E41CDCCCC6CBBB557419A999999CBAA1E4166666686BCB55741CDCCCCCCC8AA1E41333333F3BDB5574166666666C8AA1E4100000060BFB5574100000000C8AA1E41CDCCCC8CC0B5574100000000CAAA1E419A9999F9C1B55741CDCCCCCCD0AA1E4166666666C3B557419A999999D9AA1E41333333D3C4B5574100000000E0AA1E41333333F3C5B55741CDCCCCCCE8AA1E4100000040C7B557419A999999F5AA1E419A9999F9C8B5574133333333FBAA1E41000000E0C9B557416666666602AB1E41CDCCCCECCAB55741CDCCCCCC0AAB1E4166666626CCB557416666666614AB1E4133333333CDB557413333333327AB1E419A999919CEB557416666666634AB1E4100000060CEB557419A9999993FAB1E4100000060CEB557416666666648AB1E419A999959CEB55741CDCCCCCC58AB1E4133333353CEB557416666666668AB1E4166666646CEB55741CDCCCCCC78AB1E4100000020CEB55741666666668EAB1E41666666C6CDB5574166666666A4AB1E419A999959CDB55741CDCCCCCCBEAB1E41CDCCCCCCCCB557419A999999DFAB1E41000000E0CBB557410000000002AC1E4100000000CBB557413333333325AC1E419A9999F9C9B557413333333357AC1E419A999999C8B557416666666676AC1E41333333D3C7B557419A99999995AC1E41333333F3C6B5574133333333B9AC1E41CDCCCC0CC6B557419A999999E1AC1E41CDCCCC4CC5B557419A9999990DAD1E41CDCCCC8CC4B557419A99999939AD1E419A9999B9C3B557413333333361AD1E419A999919C3B55741333333338FAD1E4166666646C2B557419A999999B9AD1E4133333373C1B5574100000000DAAD1E41333333F3C0B557419A999999F1AD1E419A9999B9C0B55741666666661AAE1E41CDCCCC4CC0B557416666666646AE1E419A9999F9BFB55741666666665AAE1E41333333D3BFB557416666666676AE1E41666666A6BFB557419A9999998FAE1E4133333373BFB5574100000000A2AE1E4100000060BFB5574133333333B3AE1E4100000060BFB557419A999999C5AE1E4100000060BFB5574166666666D6AE1E4133333373BFB5574166666666E8AE1E419A999999BFB55741CDCCCCCCFCAE1E41CDCCCC6CC0B55741666666660EAF1E4100000060C1B55741CDCCCCCC1AAF1E4166666626C2B55741CDCCCCCC24AF1E41000000C0C2B55741CDCCCCCC2EAF1E4133333333C4B557416666666636AF1E4133333393C5B557416666666642AF1E419A999979C7B55741666666664CAF1E419A999999C9B55741CDCCCCCC5CAF1E4133333313CCB55741333333336DAF1E41CDCCCCACCEB55741CDCCCCCC82AF1E41333333F3D0B557410000000094AF1E4166666646D3B557419A999999A9AF1E4166666666D5B55741CDCCCCCCC6AF1E41CDCCCCCCD7B5574133333333DFAF1E419A9999F9D9B557419A999999F5AF1E419A999979DBB55741333333330FB01E41CDCCCC0CDDB55741CDCCCCCC38B01E41CDCCCC6CDFB55741000000004CB01E419A999919E0B55741666666666AB01E41333333F3E0B55741CDCCCCCC92B01E41CDCCCC8CE2B55741CDCCCCCCB0B01E41333333F3E3B5574166666666D4B01E419A999999E6B5574133333333E3B01E4133333373E7B5574166666666FAB01E4100000000E9B557413333333305B11E4166666606EAB557413333333319B11E4166666646EBB55741CDCCCCCC26B11E4166666646ECB557413333333339B11E4100000040EDB557410000000058B11E41CDCCCCACEEB557410000000082B11E4133333313F0B55741000000009CB11E4100000000F1B5574133333333BDB11E41CDCCCCCCF1B557419A999999D7B11E4166666646F2B5574133333333F3B11E419A999979F2B557419A99999911B21E41000000A0F2B557416666666632B21E4100000080F2B55741CDCCCCCC4AB21E4100000060F2B55741CDCCCCCC5EB21E4100000000F2B55741000000006EB21E41666666A6F1B557413333333385B21E41333333D3F0B55741333333339BB21E41666666C6EFB5574100000000AEB21E419A999959EEB5574133333333BDB21E419A9999F9ECB5574100000000CAB21E4100000000EBB55741CDCCCCCCD2B21E419A999979E9B55741CDCCCCCCDEB21E41CDCCCCACE7B557419A999999EFB21E4133333333E5B5574100000000F8B21E419A9999B9E3B557419A99999905B31E4133333393E2B557416666666616B31E41CDCCCC6CE1B557410000000032B31E419A9999D9DFB55741000000005EB31E419A9999F9DDB55741666666668AB31E419A999999DCB55741CDCCCCCCA8B31E419A9999F9DBB5574100000000C8B31E41000000C0DBB5574133333333EFB31E41CDCCCC4CDBB557419A9999990FB41E4133333373DBB557413333333327B41E41CDCCCCACDBB557413333333347B41E4100000020DCB55741CDCCCCCC64B41E41000000A0DCB55741CDCCCCCC74B41E4100000020DDB55741CDCCCCCC86B41E41CDCCCC8CDDB55741000000009AB41E4166666626DEB5574166666666AAB41E41666666C6DEB55741CDCCCCCCC0B41E41666666C6DFB5574133333333D7B41E419A999959E1B557419A999999EFB41E4100000060E3B55741666666660AB51E419A9999D9E4B55741CDCCCCCC2EB51E41CDCCCCCCE6B557413333333341B51E41000000A0E7B557413333333357B51E41CDCCCC6CE8B557419A99999975B51E4100000080E9B557416666666698B51E4100000080EAB557419A999999BFB51E4133333333EBB557419A99999903B61E41666666A6ECB55741CDCCCCCC0AB61E41000000E0ECB55741333333330FB61E419A9999F9ECB55741CDCCCCCC56B61E41CDCCCC6CEEB557410000000054B61E4133333333EDB557413333333343B61E41000000C0E5B55741CDCCCCCC2EB61E41666666C6E0B5574133333333EDB51E419A999919B6B5574166666666C8B61E4100000000B1B557419A99999929BB1E41CDCCCC2CA5B55741CDCCCCCC22BF1E41666666669AB5574100000000C6C01E41333333B397B5574100000000FCC21E4100000020AAB557419A999999DDC41E419A999919BAB557413333333341C51E41CDCCCCCCB8B557413333333333C71E4133333393AEB5574166666666DCC91E419A9999B99CB557413333333359CC1E41CDCCCCEC8BB557413333333325CF1E41333333D373B5574166666666D8CF1E41000000806DB55741CDCCCCCCB2D01E410000006063B557410000000060D11E419A99995932B5574166666666E8D11E41CDCCCC0C18B557413333333349D21E416666668601B557413333333333D21E41CDCCCC4CF1B457416666666632D21E4133333353ECB45741000000000AD21E419A999999E8B457419A999999E1D11E4100000020E6B45741CDCCCCCCB8D11E41666666E6DFB45741666666667CD11E41CDCCCCECDAB4574166666666EED01E4166666606CCB4574166666666C6D01E41CDCCCCCCCAB4574100000000C6D01E41CDCCCC4CC8B457413333333339D01E41000000A0BFB45741CDCCCCCC98CF1E419A999939BDB4574133333333B9CE1E4133333353BDB4574166666666BACE1E4133333353C7B45741CDCCCCCC1ACE1E41666666A6C8B45741CDCCCCCC7ACD1E419A999939C6B457410000000016CD1E41CDCCCC0CC0B4574133333333EDCC1E41333333D3B9B457419A99999939CC1E41CDCCCC2CBBB45741CDCCCCCC32CA1E41CDCCCC6CC0B45741CDCCCCCCC8C31E4166666686C2B4574133333333D5C11E41666666C6C1B4574100000000D4C11E41CDCCCC8CB7B4574133333333FDBD1E41CDCCCC0CB7B45741CDCCCCCCE8BD1E41333333D3B5B4574100000000D4BD1E419A999959AEB457416666666690BB1E4166666626ACB457419A999999FFBA1E410000004089B457416666666666BA1E41666666A681B4574133333333ADB91E41CDCCCCEC90B45741333333335DB91E419A9999F990B45741CDCCCCCC8EB91E41333333D37AB457410000000046B91E413333337378B457419A9999993DB71E41CDCCCC0C65B457419A9999990DB71E410000008066B457410000000008B71E410000008066B4574100000000E0B61E41000000C065B45741CDCCCCCC7EB61E41000000E061B45741CDCCCCCC1AB61E41666666865EB457419A999999EFB51E41333333735DB4574100000000A2B51E41666666065CB457419A99999959B51E41000000405BB457410000000052B51E41666666465BB45741CDCCCCCCDAB41E41CDCCCCCC5AB457419A999999A7B41E419A9999795AB45741333333335FB31E41666666A63EB45741CDCCCCCC4AB31E41333333F33EB45741333333332BB31E41CDCCCC8C3FB4574100000000FCB21E416666668640B457419A999999D9B21E410000008041B457419A9999999DB21E41CDCCCCCC43B457410000000032B21E416666668647B457410000000000B21E419A9999B949B45741CDCCCCCC62B11E41CDCCCCEC4FB45741666666662EB11E41666666E651B4574100000000BEB01E41CDCCCC0C55B45741CDCCCCCC5AB01E416666666658B45741CDCCCCCCE0AF1E41CDCCCC8C5AB4574166666666AAAF1E41666666C65BB457419A99999999AF1E41CDCCCC2C5CB457410000000012AF1E41333333B35EB4574133333333A7AE1E41CDCCCC6C5FB45741333333334BAE1E416666664661B45741CDCCCCCC0EAE1E413333337363B457419A999999CDAD1E419A99995966B45741CDCCCCCC80AD1E413333339368B45741CDCCCCCC4AAD1E41000000C06AB457413333333323AD1E419A9999396DB45741CDCCCCCCF0AC1E41666666E671B45741CDCCCCCCC6AC1E410000000075B457419A9999997DAC1E419A9999B978B457416666666630AC1E41666666467CB45741666666662AAC1E41333333937CB457416666666600AC1E41CDCCCCEC7DB457413333333383AB1E41CDCCCC8C80B457410000000054AB1E41CDCCCCEC81B4574166666666F6AA1E41CDCCCC6C83B457413333333365AA1E41666666A686B457410000000048AA1E410000002087B45741333333332BAA1E41000000A087B45741CDCCCCCC38AA1E419A9999B98BB457419A99999943AA1E41333333138DB45741CDCCCCCC50AA1E41000000E08EB457410000000058AA1E41000000A08FB457419A9999995DAA1E416666668690B45741CDCCCCCC62AA1E41CDCCCC6C91B457416666666668AA1E41000000C092B45741CDCCCCCC6EAA1E419A9999B993B45741666666667CAA1E41666666C694B457416666666690AA1E419A99993996B457419A999999A3AA1E416666662697B4574100000000BEAA1E41000000E098B4574100000000CAAA1E419A9999599AB4574166666666D8AA1E41333333539CB45741CDCCCCCCE4AA1E41CDCCCC8C9EB4574100000000EEAA1E4166666626A1B457419A999999F7AA1E419A9999B9A3B45741CDCCCCCC04AB1E41333333D3A6B457419A99999911AB1E4100000040AAB457419A99999919AB1E41666666E6ABB45741666666661EAB1E41666666A6ADB457416666666622AB1E41000000C0AFB457410000000022AB1E4166666626B2B45741000000001CAB1E419A999999B4B45741CDCCCCCC10AB1E41CDCCCC0CB7B457416666666602AB1E4166666606B9B457419A999999F3AA1E4133333333BAB4574133333333DBAA1E4166666666BBB45741CDCCCCCCBCAA1E41666666A6BCB4574166666666ACAA1E4133333393BDB457410000000094AA1E419A999959BFB45741000000007AAA1E41333333F3C1B457416666666664AA1E41CDCCCC6CC4B457413333333353AA1E4166666626C7B45741CDCCCCCC4EAA1E41666666E6C7B457419A99999945AA1E4133333393C9B45741000000003AAA1E4100000040CCB457416666666632AA1E41333333F3CEB45741333333332DAA1E41CDCCCC6CD1B45741CDCCCCCC2CAA1E41CDCCCC0CD5B457410000000032AA1E41000000E0D8B457410000000032AA1E41CDCCCC0CDCB457419A99999931AA1E41000000A0DEB45741CDCCCCCC28AA1E4100000080E2B45741CDCCCCCC20AA1E4166666606E6B457416666666616AA1E4100000040E9B45741CDCCCCCC0CAA1E41CDCCCC8CEAB457416666666608AA1E4166666646EBB45741CDCCCCCCFCA91E41CDCCCC0CEDB4574133333333F3A91E4133333353EEB4574166666666E6A91E41000000C0EFB4574166666666DEA91E4100000000F1B4574133333333D7A91E41000000A0F2B4574100000000CEA91E41666666E6F4B4574166666666C4A91E41333333F3F6B457419A999999B7A91E41CDCCCC4CF9B45741CDCCCCCCA8A91E4166666646FBB457416666666698A91E419A999979FDB457410000000086A91E41666666C6FFB45741333333337DA91E419A9999F901B557416666666672A91E41CDCCCC4C04B557419A9999996BA91E41CDCCCCAC06B557419A99999967A91E41CDCCCCAC09B557410000000060A91E419A9999990CB55741000000005CA91E41333333B30FB55741CDCCCCCC5AA91E41000000C012B55741666666665AA91E41CDCCCC8C15B557419A9999995BA91E410000004018B55741000000005EA91E419A9999B91BB557413333333361A91E41CDCCCC6C1EB557419A99999967A91E41CDCCCC4C21B55741CDCCCCCC72A91E41666666A625B55741CDCCCCCC7CA91E41CDCCCCEC29B55741CDCCCCCC86A91E41000000602DB557410000000090A91E416666660630B557416666666694A91E419A9999B932B55741333333339BA91E410000002035B5574133333333A1A91E410000002038B55741CDCCCCCCA6A91E41666666E63BB5574133333333A7A91E41000000003DB5574166666666A6A91E419A9999593DB5574166666666A2A91E41000000C040B557410000000098A91E41CDCCCC0C44B557413333333391A91E41000000C046B557419A99999987A91E410000004048B55741CDCCCCCC7CA91E41000000004AB557416666666670A91E419A9999194CB557419A99999957A91E41666666E64FB55741CDCCCCCC46A91E419A9999F952B557419A9999992BA91E410000006057B557416666666620A91E413333337359B557416666666612A91E41666666A65BB557413333333305A91E41666666E65DB5574100000000F8A81E410000004060B5574133333333EDA81E413333337362B55741CDCCCCCCE2A81E419A9999B964B5574100000000DAA81E416666668666B55741CDCCCCCCD0A81E41CDCCCC6C68B5574166666666C8A81E41000000606AB557419A999999BFA81E419A9999D96CB55741CDCCCCCCB8A81E41CDCCCC8C6EB557419A999999B7A81E41666666E66FB5574166666666B6A81E419A99995971B557419A999999B3A81E41333333D372B557419A999999B3A81E41CDCCCC4C74B5574100000000B4A81E410000002075B5574166666666B4A81E41333333F376B5574100000000B4A81E41CDCCCC4C79B5574133333333AFA81E41000000607CB55741	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	01010000206A0800008A0965939DBD1E41CDCCCCFC19B55741	650120000	Z	Anla	6501200	65012	65	76	3
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	01060000206A08000001000000010300000001000000600000000000000046651C419A99997987E557416666666652661C419A9999D992E557416666666632671C410000006097E5574133333333AF671C41333333B39BE5574133333333B3681C41CDCCCC4C9FE5574133333333BB6A1C41CDCCCC4CA1E55741333333334D6C1C41333333B3AEE55741333333337F6D1C41000000A0C6E5574166666666F86E1C41CDCCCC8CD9E55741666666664A6F1C41CDCCCC6CD7E557419A99999903701C4100000040D6E5574166666666C6701C4100000080DBE55741666666664E711C4166666626DBE557419A99999957711C41000000A0D2E557419A9999999B711C4133333373CBE5574133333333D3721C41CDCCCCECC4E55741000000003C731C419A999959C1E55741CDCCCCCC14751C4100000020AEE5574133333333C3751C419A999919A8E557419A99999963771C41000000209EE55741CDCCCCCCDC771C41666666A69CE557410000000098781C41CDCCCCEC9FE5574100000000E6781C419A9999799EE557416666666612791C419A9999999AE557419A99999925791C419A9999F991E5574133333333FF781C41333333D384E55741000000001C791C41CDCCCCEC7BE557410000000064791C413333339376E55741000000004E791C41000000606FE5574100000000D4791C41000000605BE55741666666668E7A1C413333331347E557419A9999999D7A1C419A9999F942E557419A999999D77A1C413333335341E557419A9999993F7B1C419A99993935E557419A9999998F7B1C413333335327E5574133333333D37B1C413333333321E5574133333333057C1C41000000C012E5574133333333D37B1C419A9999B906E5574133333333157C1C419A999959F8E45741666666665A7C1C41CDCCCC6CF1E457413333333363791C41CDCCCCCCDFE45741CDCCCCCC0A791C4166666626CFE457419A9999994F791C41CDCCCC8CA6E45741CDCCCCCC307A1C419A999939ACE4574166666666CE7A1C419A9999597DE4574166666666687A1C41CDCCCCCC65E45741666666667C7A1C41CDCCCC4C61E4574166666666C8791C41000000E05EE457419A9999992D7A1C41000000804BE457413333333375791C410000006044E457419A999999D7781C41666666C637E45741CDCCCCCC14781C41CDCCCC8C2FE45741CDCCCCCC7C781C41666666E603E457416666666678781C41333333B3E4E35741666666666E771C419A999959D3E3574100000000E2761C41CDCCCCACCFE357416666666608771C41CDCCCC2CC3E35741CDCCCCCCA6771C419A999999B6E357419A999999CD771C4133333313B0E357419A99999969771C41000000E0ADE357419A99999951761C41666666C6ACE357410000000038751C41333333F39DE357419A999999A7731C41666666A696E357419A9999997F731C41CDCCCCEC97E35741CDCCCCCC32731C41333333B3AFE35741CDCCCCCCDC721C41CDCCCC2CB8E35741CDCCCCCCC4711C4166666686B3E35741333333339D701C419A999999AFE357413333333369701C419A999939B0E35741333333331D701C4166666686BCE3574100000000D66F1C4133333353BEE357419A999999E76E1C419A9999D9BBE3574166666666106E1C41666666C6B4E35741CDCCCCCCCA6D1C4166666626AFE357419A999999356D1C4166666626BAE3574166666666FE6C1C4166666686CAE357419A999999D36C1C4100000060E3E35741CDCCCCCCA46C1C41CDCCCCACE6E357419A999999556C1C4166666626FFE357419A999999076A1C4166666626FEE3574100000000B8691C410000004032E45741666666669E691C41000000806BE4574166666666B6691C41333333739DE45741CDCCCCCCD8691C41CDCCCC4CB0E45741333333334D691C41000000A0B3E45741333333337D681C4133333393BBE457416666666642681C419A999999C4E45741333333332B681C4166666646FBE4574100000000F0671C41666666E622E557419A9999994B681C41000000E02AE557419A999999ED671C410000008049E557419A99999919671C41333333135EE557413333333383661C410000004068E557419A99999993651C419A9999D97EE557410000000046651C419A99997987E557410000000046651C419A99997987E55741	01010000206A080000F65325F40B711C419A999999B7E45741	650130000	Z	Ansost	6501300	65013	65	76	2
01060000206A0800000100000001030000000100000020010000CDCCCCCCF4A61E41666666261BB45741000000008CA71E41333333B326B45741CDCCCCCCB6A71E41666666E629B45741CDCCCCCC0CA81E416666662630B457416666666618A81E41CDCCCC2C31B45741CDCCCCCC2AA81E410000008032B45741666666663EA81E41000000C033B457416666666650A81E41333333F334B457416666666664A81E419A99995936B45741CDCCCCCC78A81E416666660638B45741666666668EA81E419A9999193AB45741000000009EA81E41000000C03BB4574133333333ADA81E41CDCCCC0C3DB457419A999999BFA81E41000000C03EB4574133333333D1A81E41CDCCCC6C40B4574133333333DBA81E413333331342B4574133333333DFA81E413333331344B4574166666666E4A81E41CDCCCC0C46B457419A999999EBA81E41666666A648B4574166666666F0A81E419A9999F949B457419A999999F5A81E41666666664BB45741CDCCCCCCFEA81E41333333134DB457410000000008A91E41000000004FB457419A99999913A91E416666662651B45741333333331FA91E41000000A053B457413333333325A91E41CDCCCCEC54B45741000000002CA91E41CDCCCC8C56B457410000000034A91E416666668658B457419A99999939A91E41666666265AB457419A9999993DA91E41666666865BB457416666666642A91E419A9999395DB457419A99999947A91E41666666065FB45741666666664AA91E41CDCCCC2C60B457413333333355A91E416666662662B457410000000062A91E41CDCCCC6C64B45741CDCCCCCC72A91E41CDCCCC2C67B45741CDCCCCCC80A91E41CDCCCC6C69B457419A9999998FA91E41666666C66BB457410000000094A91E419A9999996CB45741000000009EA91E41333333F36DB4574133333333A9A91E41666666066FB4574133333333B5A91E41666666A670B45741CDCCCCCCC2A91E413333337372B4574166666666D0A91E410000000075B4574100000000DEA91E419A99995977B4574100000000EEA91E41666666467AB45741CDCCCCCCFEA91E41666666867DB457416666666606AA1E41CDCCCCEC7FB45741CDCCCCCC10AA1E410000000082B45741CDCCCCCC20AA1E416666668685B45741333333332BAA1E41000000A087B457410000000048AA1E410000002087B457413333333365AA1E41666666A686B4574166666666F6AA1E41CDCCCC6C83B457410000000054AB1E41CDCCCCEC81B457413333333383AB1E41CDCCCC8C80B457416666666600AC1E41CDCCCCEC7DB45741666666662AAC1E41333333937CB457416666666630AC1E41666666467CB457419A9999997DAC1E419A9999B978B45741CDCCCCCCC6AC1E410000000075B45741CDCCCCCCF0AC1E41666666E671B457413333333323AD1E419A9999396DB45741CDCCCCCC4AAD1E41000000C06AB45741CDCCCCCC80AD1E413333339368B457419A999999CDAD1E419A99995966B45741CDCCCCCC0EAE1E413333337363B45741333333334BAE1E416666664661B4574133333333A7AE1E41CDCCCC6C5FB457410000000012AF1E41333333B35EB457419A99999999AF1E41CDCCCC2C5CB4574166666666AAAF1E41666666C65BB45741CDCCCCCCE0AF1E41CDCCCC8C5AB45741CDCCCCCC5AB01E416666666658B4574100000000BEB01E41CDCCCC0C55B45741666666662EB11E41666666E651B45741CDCCCCCC62B11E41CDCCCCEC4FB457410000000000B21E419A9999B949B457410000000032B21E416666668647B457419A9999999DB21E41CDCCCCCC43B457419A999999D9B21E410000008041B4574100000000FCB21E416666668640B45741333333332BB31E41CDCCCC8C3FB45741CDCCCCCC4AB31E41333333F33EB45741333333335FB31E41666666A63EB4574133333333C1B31E419A9999B93CB4574133333333FFB31E41CDCCCC2C3BB457416666666632B41E413333335339B45741000000004EB41E419A9999F937B45741CDCCCCCC64B41E41333333B336B457419A99999983B41E413333339335B45741333333339FB41E416666660635B4574100000000CEB41E41000000E033B4574166666666F6B41E41333333D332B45741CDCCCCCC18B51E41000000C031B457410000000032B51E41666666C630B45741333333334DB51E41666666A62FB45741CDCCCCCC66B51E41333333732EB457419A99999975B51E41666666A62DB457410000000084B51E41000000802CB457410000000094B51E41CDCCCC4C2BB4574100000000C0B51E419A9999B927B4574133333333E1B51E410000006024B4574133333333FDB51E41000000A021B45741000000000CB61E419A99991920B45741666666660AB61E41000000C01FB457419A999999E5B51E41000000C015B4574166666666EAB51E41333333D313B4574100000000F2B51E419A99991912B4574133333333F9B51E410000000011B4574166666666FCB51E41CDCCCC0C10B457416666666600B61E41666666460EB457410000000006B61E41CDCCCCAC0BB457413333333309B61E41CDCCCC2C0AB45741333333330DB61E419A99995909B457413333333319B61E410000000006B457419A99999929B61E413333335304B457410000000036B61E419A9999F902B457419A9999993FB61E41CDCCCCAC01B457419A99999957B61E41CDCCCC2CFFB35741CDCCCCCC70B61E419A999999FCB357416666666680B61E41000000A0FAB357410000000090B61E41CDCCCCCCF8B35741333333339DB61E419A999939F7B3574166666666B6B61E419A999919F4B35741CDCCCCCCCCB61E41333333F3F0B3574166666666EAB61E41666666A6EBB3574166666666EEB61E4166666646EAB35741CDCCCCCCF6B61E41CDCCCC2CE7B357419A999999F9B61E4133333393E4B3574100000000FAB61E4133333313E2B3574166666666F2B61E4100000060DEB3574166666666ECB61E419A9999F9DAB3574100000000F2B61E4166666626D8B35741333333330FB71E41666666A6D5B35741000000000EB71E41000000E0CFB357419A99999913B71E419A999979CEB357410000000022B71E41333333F3CBB357413333333335B71E41666666E6C8B357419A9999993FB71E4100000080C7B357419A99999957B71E4133333393C4B357410000000068B71E4133333373C3B35741CDCCCCCC7AB71E419A999939C2B357419A99999985B71E41666666C6C1B35741000000008AB71E41666666A6C1B35741CDCCCCCC98B71E4166666666C1B35741CDCCCCCCACB71E4133333393C0B3574133333333D3B71E4100000040BFB35741CDCCCCCCF0B71E4166666626BEB35741CDCCCCCCF8B71E419A999959BDB3574100000000F4B71E419A999919B9B357419A999999F3B71E4100000000B6B3574166666666F2B71E4166666606B2B3574166666666F0B71E419A999999ADB3574100000000EEB71E41CDCCCC2CABB3574166666666ECB71E4133333333A8B3574100000000EAB71E4166666686A3B3574100000000E6B71E41CDCCCC8CA0B3574100000000E2B71E41333333939DB35741CDCCCCCCE0B71E41000000209BB35741CDCCCCCCDCB71E41CDCCCC6C97B3574133333333DBB71E416666660695B3574133333333D9B71E41CDCCCC8C90B35741CDCCCCCCD4B71E41666666068CB357419A999999CFB71E419A9999B989B35741CDCCCCCCBCB71E41000000E085B3574100000000B2B71E416666666683B357419A999999ADB71E419A9999D97FB3574133333333ABB71E41333333537CB3574100000000AEB71E41CDCCCCAC78B35741CDCCCCCCAEB71E416666668675B3574133333333ABB71E41333333F370B35741CDCCCCCCA8B71E41333333F36CB3574133333333A5B71E413333333368B35741CDCCCCCCA0B71E419A99991962B35741CDCCCCCC9CB71E41000000E05EB357410000000096B71E41666666C65AB357410000000092B71E416666666656B35741CDCCCCCC88B71E41CDCCCCEC51B35741CDCCCCCC86B71E419A9999794FB357416666666684B71E41000000604DB357413333333383B71E41000000604BB357419A99999983B71E416666662648B357410000000084B71E416666660646B357410000000082B71E41CDCCCC2C41B35741CDCCCCCC80B71E41333333533FB35741CDCCCCCC7EB71E41333333333BB357419A9999997FB71E410000006038B35741333333337FB71E41CDCCCCEC35B35741666666667EB71E41CDCCCCEC33B35741333333337DB71E41CDCCCC4C31B35741666666667CB71E41CDCCCCEC2EB35741333333337BB71E419A9999F92BB35741000000007EB71E41666666C627B357416666666686B71E413333335324B357413333333393B71E416666668620B35741CDCCCCCCA0B71E41333333731DB357413333333397B71E41CDCCCC6C1BB357416666666696B71E419A9999B919B357419A9999999DB71E41CDCCCC4C18B3574166666666A2B71E41CDCCCCCC16B3574100000000A4B71E41333333D315B35741CDCCCCCCA8B71E41666666E612B3574166666666A4B71E419A9999B90FB3574166666666AAB71E41666666060CB3574166666666BEB71E419A99999907B3574166666666C6B71E41000000A005B3574133333333CBB71E416666662604B35741CDCCCCCCCCB71E41333333D301B3574133333333CBB71E4133333313FEB2574100000000CAB71E41666666E6FBB25741CDCCCCCCCAB71E4166666646FAB2574166666666D8B71E419A999919F7B257419A999999E1B71E419A999999F4B25741CDCCCCCCDEB71E41CDCCCC4CF1B2574166666666D8B71E4166666686EEB2574133333333C9B71E41000000A0EAB2574166666666C0B71E4100000060E7B2574100000000BAB71E41000000C0E5B2574100000000C0B61E41666666C6DDB25741333333331FB61E41000000E0D3B2574100000000CEB51E41CDCCCC6CCCB25741CDCCCCCC06B51E4166666646D0B2574166666666B4B31E41333333F3DBB257410000000080B31E41000000A0DCB25741CDCCCCCC54B31E41CDCCCC2CDCB25741000000001AB31E4133333353DCB2574100000000D8B21E419A999919DCB257413333333395B21E41666666C6DBB257419A99999969B21E4133333353DBB257410000000042B21E41CDCCCCECDAB25741CDCCCCCC14B21E4133333313DBB257419A999999EFB11E419A9999B9DBB257419A999999CBB11E41CDCCCC8CDCB2574133333333A3B11E4166666666DEB257416666666676B11E419A999919E1B25741CDCCCCCC6AB11E41000000C0E3B25741CDCCCCCC66B11E4100000020E7B257419A9999995DB11E4166666626EAB25741666666663CB11E41666666A6ECB25741CDCCCCCC0CB11E41666666A6EFB2574166666666E4B01E419A9999F9F1B2574166666666BCB01E419A999939F5B25741666666669AB01E4100000000FAB25741CDCCCCCC7CB01E41CDCCCCACFDB257410000000062B01E419A99995900B35741CDCCCCCC48B01E416666660602B35741CDCCCCCC28B01E41333333F302B357410000000010B01E416666662603B3574133333333B5AF1E41666666C602B35741CDCCCCCC8EAF1E419A9999F908B357410000000070AF1E41666666660EB35741333333335BAF1E41CDCCCC0C11B35741000000003AAF1E416666660612B357419A99999913AF1E41CDCCCC8C12B3574133333333E5AE1E41666666E612B3574100000000CCAE1E41666666C613B35741CDCCCCCCB8AE1E41CDCCCCCC15B357419A999999ADAE1E416666662618B357413333333397AE1E41CDCCCC4C1DB35741CDCCCCCC88AE1E419A9999D920B357413333333371AE1E413333339323B357419A99999955AE1E416666666625B35741CDCCCCCC10AE1E41CDCCCCCC28B3574133333333E1AD1E41000000E02BB357419A99999983AD1E416666666631B35741000000003CAD1E41CDCCCC8C37B3574100000000FCAC1E41333333733FB35741CDCCCCCCC4AC1E413333331347B3574100000000ACAC1E41666666064CB35741666666661EAC1E413333335351B357419A9999997FAB1E41666666A657B357419A99999959AB1E41666666A666B35741CDCCCCCC1EAB1E41CDCCCC6C6FB357419A999999D1AA1E413333337383B357419A99999921AA1E4100000080A0B3574100000000C0A91E41666666C6B0B3574133333333FDA81E419A999999D7B3574133333333E9A81E419A9999D9D8B3574100000000D6A81E419A9999D9DDB35741CDCCCCCCAEA81E4100000020E4B357416666666674A81E4100000020EEB357416666666660A81E4166666666EFB35741CDCCCCCC60A81E4166666626F2B357419A999999C3A71E413333333306B4574133333333D9A71E41CDCCCC6C11B45741000000000CA71E41666666261AB45741CDCCCCCCF4A61E41666666261BB45741	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	01010000206A080000A04D03DAEBB01E41000000B0A9B35741	650140000	Z	Antichan	6501400	65014	65	76	1
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	01010000206A08000087051F9091501D410000003060D95741	650150000	Z	Antin	6501500	65015	65	76	8
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	01010000206A080000B448B54C637D1C41000000F0B2C25741	650160000	Z	Antist	6501600	65016	65	76	2
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	01010000206A080000389925076F991C41666666B6B49D5741	650170000	Z	Aragnouet	6501700	65017	65	76	109
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	01010000206A08000034A0EEF08C6D1A419A9999396DB45741	650180000	Z	Arbéost	6501800	65018	65	76	15
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	01010000206A080000C98B70EA16451C419A9999B92EC65741	650190000	Z	Arcizac-Adour	6501900	65019	65	76	5
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	01010000206A080000E75D0C0B57E01B416666669668C05741	650200000	Z	Arcizac-ez-Angles	6502000	65020	65	76	2
01060000206A08000001000000010300000001000000410100009A999999B10F1B41CDCCCCECA3AF5741CDCCCCCCDC101B419A9999B9B3AF574100000000C4131B419A999939DBAF5741000000009E161B4100000080FFAF574166666666A4171B416666660622B05741333333332D181B41CDCCCC4C36B057419A9999994D181B416666662659B057413333333365181B419A99995978B057413333333373181B41CDCCCC8C8EB0574166666666FC181B41333333934CB157419A999999ED141B419A9999797AB157416666666650141B41CDCCCC0C83B15741CDCCCCCC3E151B419A99995996B157410000000080161B4133333313B0B15741CDCCCCCCB8181B4166666666DDB15741CDCCCCCCE81A1B419A99991908B2574133333333EF1B1B41333333731EB2574133333333971D1B41333333F33FB25741CDCCCCCC7A1E1B413333333354B2574100000000B81F1B419A9999996EB257410000000076231B4166666606BCB2574100000000EA231B4133333353CDB257419A99999905251B41CDCCCC6C23B357416666666646261B410000008075B357410000000088261B41CDCCCC0C83B357413333333387271B419A9999B9BFB357419A99999973281B41CDCCCC2CFAB3574166666666FC271B419A99995927B45741CDCCCCCCA2281B41CDCCCCAC4AB457416666666606291B419A9999595DB4574133333333B1291B419A9999F966B4574166666666642A1B41CDCCCC0C74B457419A9999994F2B1B419A9999D982B457419A9999999F2C1B413333333398B45741333333333F2D1B419A9999F9A0B457419A9999997F2D1B419A999979A6B4574100000000322E1B419A9999D9DEB457419A9999992B2F1B419A9999D91DB55741CDCCCCCC462F1B41CDCCCCAC2AB5574166666666FC2E1B41333333F32DB5574166666666022F1B419A9999F931B557419A9999990D2F1B416666660636B557419A9999991D2F1B413333331339B55741CDCCCCCC302F1B41CDCCCC2C3BB55741CDCCCCCC562F1B41666666E63CB5574133333333852F1B41CDCCCCEC3DB557419A999999C52F1B41CDCCCCCC3EB557410000000012301B419A9999593FB557416666666650301B41333333B33FB55741CDCCCCCC7E301B41333333F33FB5574166666666CA301B410000002040B55741333333330F311B41CDCCCC6C40B55741CDCCCCCC3C311B410000004041B557416666666658311B41000000C042B55741000000007A311B41666666C646B557410000000088311B41CDCCCCEC48B557413333333389311B410000002049B557416666666690311B41333333334BB557410000000092311B413333337354B557419A9999998B311B413333339358B557419A99999975311B41666666C65CB55741CDCCCCCC60311B416666662660B55741666666664C311B41CDCCCC6C63B55741333333333D311B41CDCCCC6C66B557419A9999992D311B41CDCCCCEC69B557410000000020311B41CDCCCC4C6CB557410000000020311B41333333936EB55741333333332F311B41CDCCCCCC70B55741CDCCCCCC4C311B416666660673B557410000000068311B41000000A074B5574166666666A0311B410000008075B5574133333333EF311B416666662676B557416666666628321B41666666A676B55741000000005A321B410000008077B55741CDCCCCCC88321B419A99999979B5574166666666A4321B41666666A67CB5574133333333B7321B41CDCCCCCC80B5574100000000C2321B413333333385B557419A999999CD321B419A9999B988B5574133333333D5321B41333333738BB5574100000000E8321B41333333538EB55741333333330F331B419A99997991B55741000000003A331B419A99993993B557410000000066331B41CDCCCC4C95B557416666666698331B41CDCCCC2C98B5574166666666B8331B419A9999799AB5574133333333DF331B41CDCCCC6C9DB557419A999999F3331B41666666E6A1B5574100000000F8331B4166666606A5B55741CDCCCCCCEE331B41000000A0A6B5574100000000C2331B4133333393A8B55741666666669C331B41CDCCCCECA9B55741666666665A331B41CDCCCC0CACB55741CDCCCCCC16331B41CDCCCC6CAEB55741CDCCCCCCDC321B419A9999F9B0B5574133333333CF321B4166666666B2B55741CDCCCCCCCE321B41CDCCCCECB3B5574100000000D6321B41CDCCCCECB5B5574133333333F3321B41333333B3B7B55741666666660E331B419A999919B8B557419A9999994F331B41666666A6B7B55741CDCCCCCC84331B4133333393B6B55741CDCCCCCCB6331B4100000000B5B5574133333333FD331B41CDCCCC4CB4B557413333333335341B4166666606B5B55741CDCCCCCC60341B419A999939B6B557410000000088341B41CDCCCC8CB7B557419A999999A7341B419A999959B9B5574100000000C8341B4133333333BCB5574133333333E7341B41CDCCCC0CC0B5574100000000FC341B4133333333C5B5574166666666FE341B41CDCCCC0CCAB5574133333333FD341B4100000080CDB5574100000000FC341B41CDCCCC6CD0B557419A999999FD341B419A999959D3B557419A999999FF341B4166666646D4B557419A9999990B351B4166666606D7B557416666666618351B41CDCCCCECD8B557419A99999931351B419A9999D9DAB55741CDCCCCCC54351B41000000E0DCB55741000000006A351B419A999939DEB55741000000008E351B419A999939DFB5574166666666A8351B4133333393DFB557419A999999C7351B41333333D3DFB557419A999999EB351B41000000C0DFB55741333333330B361B419A999979DFB55741CDCCCCCC24361B419A999919DFB55741000000003C361B4133333313DFB55741CDCCCCCC52361B41CDCCCC2CDFB55741CDCCCCCC68361B41000000E0DFB557419A9999997B361B41CDCCCC4CE1B55741CDCCCCCC86361B4166666686E3B557419A9999998B361B4133333373E5B557413333333391361B41CDCCCC2CE7B557419A9999999B361B4100000020E9B5574100000000AC361B41666666C6EAB5574133333333BF361B41CDCCCC4CECB5574166666666D4361B41333333F3EDB5574166666666E8361B419A999999EFB5574166666666F6361B4133333393F0B557413333333307371B4133333333F2B55741CDCCCCCC12371B419A999939F4B55741CDCCCCCC14371B4166666646F5B55741CDCCCCCC14371B4100000020F7B557410000000014371B41666666A6F8B55741CDCCCCCC1A371B41666666E6FAB557416666666624371B419A9999B9FCB55741000000002C371B41CDCCCC8CFEB557419A9999992B371B419A99991900B657416666666624371B41666666A601B65741333333331F371B416666660603B657413333333321371B416666662604B657419A9999992B371B41000000A005B657410000000038371B41000000E006B657419A99999949371B413333337308B65741333333335D371B419A9999390AB657410000000070371B41333333F30BB657419A99999987371B41333333B30DB6574133333333A1371B41CDCCCC2C0FB6574100000000B6371B416666666610B6574100000000CE371B41CDCCCCAC11B6574133333333E5371B41333333D312B657419A999999FB371B410000008013B657419A9999990F381B410000008013B657413333333329381B416666662613B65741333333333F381B419A99999912B65741CDCCCCCC56381B413333335312B657419A99999971381B410000008012B65741CDCCCCCC90381B419A9999D912B65741CDCCCCCCB0381B413333335313B65741CDCCCCCCC8381B410000004014B6574100000000DE381B41666666C615B65741CDCCCCCCEE381B410000006017B657419A99999915391B41CDCCCC0C1AB657419A99999931391B41333333331BB65741CDCCCCCC4A391B41333333131CB657419A99999965391B41666666C61CB65741CDCCCCCC84391B419A9999591DB6574100000000BE391B419A9999191EB6574100000000D8391B419A9999F91EB657419A999999E7391B41CDCCCC2C20B6574133333333F5391B419A99991922B65741CDCCCCCCF8391B410000008024B6574133333333FB391B410000002028B6574166666666003A1B419A9999392BB657419A999999073A1B419A9999392EB657419A9999990B3A1B416666662630B657419A999999153A1B419A9999B931B6574166666666283A1B419A9999F932B65741666666663A3A1B419A9999F933B657419A999999493A1B419A99997934B657419A999999633A1B41CDCCCC8C34B65741CDCCCCCC783A1B419A99995934B6574133333333953A1B410000002034B65741CDCCCCCCB83A1B419A99995934B6574100000000E83A1B410000002035B6574166666666163B1B41666666E635B65741000000003C3B1B41CDCCCC6C36B6574100000000663B1B419A9999F936B6574133333333893B1B416666664637B6574133333333A13B1B41CDCCCC0C37B657419A999999C73B1B419A9999D935B65741000000000C3C1B419A9999B933B65741333333335D3C1B413333339332B65741CDCCCCCCA43C1B416666668631B65741CDCCCCCCD43C1B419A99995931B65741CDCCCCCCFC3C1B419A99993931B6574100000000223D1B410000006031B657419A999999473D1B41666666E631B657419A999999693D1B41CDCCCCEC32B65741666666668E3D1B41CDCCCC4C34B65741CDCCCCCCBA3D1B41CDCCCCCC35B65741CDCCCCCCE43D1B41CDCCCC0C37B657419A999999173E1B41CDCCCC8C38B657419A999999473E1B41CDCCCC0C3AB65741000000007E3E1B419A9999193BB65741CDCCCCCCB23E1B41000000403CB6574133333333ED3E1B419A9999593DB65741CDCCCCCC143F1B41333333533EB65741666666663C3F1B419A9999793FB6574166666666663F1B416666668641B65741333333339B3F1B41000000C044B6574166666666E43F1B41000000004AB657410000000068401B41CDCCCCEC37B657419A999999A9401B41333333F323B65741CDCCCCCC8E411B416666662614B657419A999999C5421B416666662607B657416666666654471B419A9999B9D1B557416666666670471B41CDCCCCACCFB55741CDCCCCCC66481B41CDCCCC0CC5B557419A999999194A1B4100000080B3B5574100000000044B1B41333333D3A9B55741333333336B4B1B41666666A693B5574166666666EE4B1B41CDCCCCEC6BB55741333333330D4C1B41CDCCCC4C61B557419A999999594C1B41000000A04CB5574166666666FC491B41CDCCCC2C08B557413333333353471B419A999939B1B4574100000000CE451B41666666466FB45741000000005A451B419A9999195AB457419A9999999D431B41000000C012B45741CDCCCCCC26431B4100000080FEB3574100000000C8411B4133333333CAB357410000000050411B41666666A6B1B3574166666666C0401B4100000060A0B3574166666666CE411B419A99993979B357416666666612421B419A9999D970B35741CDCCCCCC76421B416666660665B357419A9999991F431B41000000E04FB3574166666666E0431B419A9999B930B3574133333333DD441B41333333F31BB3574133333333BF461B4133333393F1B257419A999999F3471B4133333373D3B25741CDCCCCCC2A4A1B41333333139EB2574100000000924A1B41CDCCCC8C72B25741333333330D4B1B41333333B321B2574166666666E0471B41CDCCCC0C24B2574166666666C2461B413333333324B257419A999999BB451B410000006014B257413333333345441B41333333F300B257410000000058431B419A999919F4B157419A9999998F401B4166666686CFB157419A999999D13F1B419A999999C6B15741CDCCCCCCBA3E1B419A999939B7B157419A999999CF3C1B419A9999F99EB15741000000001A3C1B41CDCCCCEC96B15741333333338F3B1B410000004092B15741333333337B3B1B41CDCCCC6C90B15741333333334B3B1B41666666468EB1574166666666123B1B41666666468CB1574100000000B83A1B41CDCCCC2C8AB15741CDCCCCCC90391B413333339381B157416666666604361B41666666E664B15741333333338D341B416666662658B15741333333333D341B41CDCCCCCC49B1574166666666CE331B41CDCCCC4C38B15741CDCCCCCC84331B41000000002FB157416666666692311B41666666C6E8B057419A999999B92F1B41CDCCCC4CA3B0574100000000402F1B41666666C68AB05741000000004A2E1B41CDCCCC6C54B0574100000000D42D1B41666666C634B05741CDCCCCCC562B1B41333333F3A2AF574133333333B92B1B419A99999997AF574166666666582C1B410000000090AF57419A999999372D1B419A9999B981AF574166666666E42D1B41333333D376AF5741000000001E2E1B413333339362AF574100000000362E1B413333339306AF574100000000242E1B41CDCCCCECFAAE574100000000CC2D1B4100000080EDAE5741333333338B2E1B419A999979C0AE574100000000402E1B4133333393B9AE5741666666663A2B1B419A9999F96DAE5741000000005A2A1B41CDCCCCCC57AE5741CDCCCCCC7C291B410000000041AE5741000000008A281B416666662628AE5741666666660E281B41333333731CAE574166666666FA231B419A9999191FAE57419A99999923211B41333333D31FAE574166666666161F1B41333333F330AE574100000000D61D1B410000004038AE5741CDCCCCCCD61B1B419A99995945AE5741CDCCCCCC36171B413333331338AE57419A99999937161B419A99999935AE57413333333335141B41CDCCCC8C2FAE57410000000028141B41000000E02EAE5741333333331D141B41000000E02EAE57419A999999FD131B41CDCCCC0C2FAE5741CDCCCCCCD2131B41000000E02FAE57419A999999AB131B419A99993930AE57416666666680131B41000000E02FAE57416666666656131B41666666262FAE574166666666E0121B41333333D32CAE5741CDCCCCCC80111B410000002029AE5741CDCCCCCC98111B413333335388AE57419A99999909121B419A99993906AF5741666666660C121B41333333D31DAF5741CDCCCCCCD4111B419A99991931AF57419A999999DF0F1B41000000009AAF57419A999999B10F1B41CDCCCCECA3AF5741	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	01010000206A0800007085F7EAED331B413333331332B25741	650210000	Z	Arcizans-Avant	6502100	65021	65	76	15
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	01060000206A08000001000000010300000001000000920000003333333399E61A41CDCCCCCC1FB857410000000066E71A419A9999B922B85741333333330BE81A419A99991927B857416666666658E81A419A99999926B85741CDCCCCCCA6E81A41333333D322B8574166666666BEE91A410000000021B8574100000000C8EA1A410000002025B85741CDCCCCCCFEEA1A41CDCCCC6C24B85741CDCCCCCC5CEB1A41666666E61EB85741CDCCCCCCC6EB1A419A9999391CB857419A999999DBEC1A41666666E61EB8574100000000FAED1A419A9999191DB857419A99999945EE1A41666666E61BB8574100000000ACEE1A41CDCCCC4C1DB857419A999999C7EE1A416666668620B857419A999999D5EE1A410000008029B85741666666668EEE1A410000004033B857413333333373EE1A419A9999193CB85741CDCCCCCC88EE1A41000000E03FB85741CDCCCCCC30EF1A41CDCCCC0C45B85741000000009EF01A41CDCCCC2C48B857410000000066F11A413333337347B85741333333339FF11A41666666064DB8574100000000F4F11A41CDCCCC8C51B857413333333379F21A41666666265CB8574166666666B0F21A419A9999D95DB85741666666663EF31A41000000205CB8574100000000D2F31A419A9999B95EB85741000000001EF41A419A9999B95DB857413333333335F51A410000008061B8574166666666DAF51A413333339361B857416666666630F71A41CDCCCC6C58B85741CDCCCCCC54F71A419A99995954B85741CDCCCCCCE2F71A41CDCCCCEC4CB857419A99999991F81A41CDCCCC8C48B857416666666616F81A41CDCCCCAC40B85741CDCCCCCCB2F71A41CDCCCC0C32B857416666666622F71A413333335329B85741CDCCCCCCBCF61A419A9999F926B857410000000014F71A41333333F31FB857416666666640F71A41666666A618B85741333333339FF71A41CDCCCC6C0FB857419A99999907F81A41CDCCCCCC01B8574166666666E4F81A4166666666F4B757413333333349F91A41666666C6F2B757413333333357F91A41666666E6E9B7574166666666BCF91A4100000060E6B7574133333333E9FA1A41333333F3D2B75741CDCCCCCC58FB1A41666666C6D4B757419A999999E5FB1A4166666646D0B757419A9999990DFC1A41333333D3CBB757410000000030FC1A419A9999F9C2B757413333333395FC1A41CDCCCC2CC4B757419A9999998BFD1A4166666606B8B75741CDCCCCCCD6FD1A41CDCCCC4CB2B7574133333333F9FD1A4133333393ACB7574133333333F7FD1A41000000609EB757416666666652FE1A419A9999998CB75741666666666EFE1A41CDCCCC8C7AB75741CDCCCCCC9EFE1A41000000006CB7574166666666EEFE1A41CDCCCC8C60B7574133333333EDFE1A416666660658B757413333333309FF1A419A9999B944B7574100000000DAFE1A41CDCCCCCC37B757410000000002FF1A41000000C025B75741000000002EFF1A41333333B319B757419A99999973FF1A41333333F30DB75741333333336DFF1A413333335307B7574100000000B0FE1A419A999999F7B65741666666663AFE1A41666666C6EFB6574100000000EAFD1A4100000000E2B657413333333319FE1A41333333D3E1B657416666666612FF1A41000000A0DCB65741666666667C001B4100000020D4B657416666666646011B4166666606D0B657410000000058031B4133333333C4B65741000000000A051B4166666666B9B65741CDCCCCCC0C061B4166666666ABB65741CDCCCCCCD2071B41CDCCCC4C8CB6574100000000D4081B410000008079B657416666666646091B416666660675B65741CDCCCCCC98091B41CDCCCC2C64B65741CDCCCCCCC80A1B41666666C635B65741666666660A0B1B41333333132DB6574100000000320B1B41333333531EB6574100000000000B1B41CDCCCC2C04B657419A999999F50A1B4166666626F6B5574166666666CA0A1B4133333333D5B557419A999999AB0B1B41666666C6AAB5574133333333E50B1B419A9999D997B557419A999999290C1B41333333B35CB55741CDCCCCCCD80C1B41000000E0F1B457419A999999E70C1B419A999999E2B457419A999999250D1B41CDCCCC2CD4B4574133333333890C1B41CDCCCC2CCEB45741666666661E0C1B419A999979C3B4574133333333FD0A1B4166666686BCB45741CDCCCCCC700A1B419A9999B9B2B457413333333365091B4166666646A8B45741CDCCCCCCF2071B41CDCCCCACA0B457416666666614061B41CDCCCCEC73B4574133333333D5051B419A9999996EB457419A99999929051B41CDCCCCEC66B45741CDCCCCCC9A041B41333333F364B457419A999999DB031B410000004060B457410000000066031B419A9999B959B457419A999999E7021B419A9999F956B457413333333327021B41CDCCCCCC55B4574133333333DD011B410000004053B45741000000004E011B41333333F348B4574133333333FDFF1A41CDCCCC8C42B457410000000094FF1A41666666E63EB457419A99999991FE1A41333333133BB457419A9999990BFE1A419A9999F936B45741CDCCCCCCA4FD1A41333333B330B457410000000000FD1A419A9999F92BB45741000000006CFC1A41000000802DB4574133333333DBFB1A413333333333B4574133333333D1FA1A419A99995936B457416666666682FA1A41CDCCCC0C34B45741CDCCCCCC26FA1A41000000402EB45741CDCCCCCC9EF91A410000000028B457410000000018F91A41000000A023B45741CDCCCCCC6EF81A410000002023B457419A99999907F81A41000000C01EB45741333333337FF71A41000000601EB4574133333333A5F61A41333333D362B457419A9999991BF51A41333333F3C6B45741333333333BF41A413333331303B5574166666666BEF41A419A99997942B557413333333369F51A41CDCCCC6C49B5574133333333BFF61A41333333735BB557419A999999BFF61A41333333335FB557419A99999939F51A41333333F31FB65741666666665EF41A41CDCCCCAC35B6574100000000FCF31A419A99993942B65741333333335BF31A416666660659B65741000000009AF01A41CDCCCCACB9B657416666666628EF1A4133333313F1B65741CDCCCCCC94EE1A419A99991901B75741000000006CED1A41333333132CB757413333333369EB1A41000000A074B757416666666636E71A41000000400AB8574133333333FBE61A416666668610B857413333333399E61A41CDCCCCCC1FB857413333333399E61A41CDCCCCCC1FB85741	01010000206A080000F4F7676966FF1A41000000003CB65741	650220000	Z	Arcizans-Dessus	6502200	65022	65	76	5
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	01010000206A0800007C5D207942D81D419A9999A914AD5741	650230000	Z	Ardengost	6502300	65023	65	76	6
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	01010000206A0800002465E02972CB1C413333334376BF5741	650240000	Z	Argelès-Bagnères	6502400	65024	65	76	3
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	01010000206A080000B2DCD388AA511B41333333133FB75741	650250000	Z	Argelès-Gazost	6502500	65025	65	76	3
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	01010000206A080000511CFCFD6B7D1E419A9999A9B9D25741	650260000	Z	Aries-Espénan	6502600	65026	65	76	6
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	01010000206A0800004F2DA72AA0411E4133333363C5C75741	650280000	Z	Arné	6502800	65028	65	76	8
01060000206A0800000100000001030000000100000019020000666666663EE51A41CDCCCC2C26B05741333333332FE61A41666666E63CB057419A999999B5E61A41333333F343B05741CDCCCCCCCEE71A41333333F358B057413333333335E81A41333333B373B05741CDCCCCCCD8E71A41CDCCCC0C77B057410000000064E71A41000000E078B057413333333367E61A41333333D37CB05741CDCCCCCCB2E71A41666666269DB05741000000000AE81A41CDCCCCCCA0B05741666666661CEB1A41CDCCCCECC5B057413333333361EB1A4100000020C7B057419A999999E7EB1A4100000060B8B057419A99999951EC1A41666666C6D9B057416666666662EC1A4133333353DBB05741666666666EEC1A4100000080DCB057419A99999977EC1A4100000040DDB05741333333338DEC1A41CDCCCC8CDEB0574100000000A4EC1A419A999939E0B057419A999999A5EC1A4166666686E0B0574133333333A7EC1A41333333F3E0B0574100000000AAEC1A419A999999E1B057419A999999ABEC1A4100000020E2B057419A999999AFEC1A419A9999F9E2B0574100000000B2EC1A41333333D3E3B05741CDCCCCCCB2EC1A41666666E6E4B05741CDCCCCCCB2EC1A41666666E6E5B057419A999999B3EC1A41CDCCCCECE6B0574133333333B1EC1A41666666A6E8B0574166666666AAEC1A41000000A0EAB05741CDCCCCCCA4EC1A4166666646ECB05741CDCCCCCCA4EC1A41CDCCCC0CEDB05741CDCCCCCCA6EC1A419A9999B9EDB0574100000000AAEC1A41CDCCCCCCEEB0574100000000ACEC1A4133333393EFB057419A999999B9EC1A4100000060F1B0574100000000CAEC1A4166666606F3B0574166666666DEEC1A4133333393F4B057416666666614ED1A41CDCCCC6CF9B05741CDCCCCCC4CED1A41333333B3FEB057419A99999981ED1A41000000C003B157419A9999999BED1A41000000E006B1574100000000B0ED1A413333335309B1574166666666B8ED1A41CDCCCCCC0AB1574133333333CFED1A41333333B30FB1574166666666DAED1A41CDCCCCCC12B1574166666666E4ED1A413333339315B15741CDCCCCCCF2ED1A419A99991917B157419A999999FDED1A41CDCCCC6C18B157419A99999909EE1A41000000201AB15741CDCCCCCC1AEE1A41CDCCCCAC1EB157413333333333EE1A410000002024B15741666666664EEE1A419A9999D928B157419A9999996BEE1A41CDCCCC8C2DB15741CDCCCCCC88EE1A419A99991931B15741CDCCCCCCB2EE1A41333333B338B1574133333333C7EE1A419A9999593DB1574133333333CFEE1A41666666263FB1574133333333CFEE1A41CDCCCCEC40B1574100000000BEEE1A41CDCCCCAC42B157419A999999ABEE1A413333333343B157419A9999998FEE1A41333333B343B15741CDCCCCCCD0F01A41333333D346B157410000000058F21A41333333B343B15741666666661AF31A419A99999943B15741CDCCCCCC82F51A419A9999D969B157416666666662F61A413333331377B1574100000000F8F61A41CDCCCC4C7FB1574100000000AAF71A41CDCCCC6C8CB157419A9999996DF81A419A9999F998B157419A99999969FA1A41CDCCCC8CB9B157419A99999931FC1A41CDCCCC4CD7B1574100000000D6FC1A4100000060DFB157419A9999996DFE1A4166666626F2B15741CDCCCCCC4C011B419A9999994FB257416666666618021B419A9999196CB257410000000070021B410000002076B2574166666666AC021B41CDCCCC6C7CB2574100000000D6021B413333337384B257413333333337031B419A99999994B25741CDCCCCCCB2031B41CDCCCC4CA0B25741CDCCCCCC22041B419A9999F9A9B25741CDCCCCCCA0041B41CDCCCCCCAFB257419A9999999B041B41CDCCCCACCBB25741333333338B041B4133333333D1B257416666666688041B41CDCCCCECD7B25741CDCCCCCC8A041B41333333B3DDB257410000000098041B419A9999F9E3B2574133333333AB041B4100000000EBB2574133333333C5041B419A9999D9F0B2574133333333E9041B4100000000F7B257419A999999F9051B413333337304B357413333333389071B419A9999F914B3574166666666A8081B413333331320B357410000000058091B419A99997928B35741CDCCCCCC520A1B410000002030B3574133333333210B1B416666662637B3574166666666680B1B419A99997945B3574100000000C40B1B41000000804EB3574100000000740C1B41000000407AB35741CDCCCCCC7C0C1B41000000C080B35741CDCCCCCC8A0C1B41000000E087B35741CDCCCCCCCA0C1B419A9999D995B3574133333333DF0C1B419A99991999B35741CDCCCCCC1A0D1B4133333313A1B357419A999999730D1B41000000E0ADB3574100000000CC0D1B419A999939BBB35741666666662A0E1B419A999959C8B357419A9999998F0E1B41333333B3D5B3574133333333E30E1B419A9999F9DEB35741CDCCCCCCFC0E1B41666666A6E7B3574166666666180F1B4166666666F6B357419A9999994F101B41000000802EB45741CDCCCCCCDA101B419A9999D945B45741000000007C0C1B419A9999F963B4574133333333750B1B419A9999396CB4574100000000520B1B41CDCCCC8C6EB457419A999999B30A1B410000006071B45741000000005E0A1B41CDCCCCCC72B4574100000000D6091B416666666673B457419A99999961091B41CDCCCCEC71B457416666666618091B41666666A66FB45741666666661E091B416666668674B457419A999999FD081B410000008074B457419A99999931081B41000000A074B45741000000008C071B413333339374B457419A9999995B071B413333335374B4574133333333ED061B41000000A072B457416666666672061B41CDCCCC6C71B45741000000002C061B41333333B370B457416666666608061B410000000070B4574133333333D5051B419A9999996EB457416666666614061B41CDCCCCEC73B45741CDCCCCCCF2071B41CDCCCCACA0B457413333333365091B4166666646A8B45741CDCCCCCC700A1B419A9999B9B2B4574133333333FD0A1B4166666686BCB45741666666661E0C1B419A999979C3B4574133333333890C1B41CDCCCC2CCEB457419A999999250D1B41CDCCCC2CD4B457419A999999E70C1B419A999999E2B45741CDCCCCCCD80C1B41000000E0F1B457419A999999290C1B41333333B35CB5574133333333E50B1B419A9999D997B557419A999999AB0B1B41666666C6AAB5574166666666CA0A1B4133333333D5B557419A999999F50A1B4166666626F6B5574100000000000B1B41CDCCCC2C04B6574100000000320B1B41333333531EB65741666666660A0B1B41333333132DB65741CDCCCCCCC80A1B41666666C635B65741CDCCCCCC98091B41CDCCCC2C64B657416666666646091B416666660675B6574100000000D4081B410000008079B65741CDCCCCCCD2071B41CDCCCC4C8CB65741CDCCCCCC0C061B4166666666ABB657410000000094051B419A999939B2B65741000000000A051B4166666666B9B657410000000058031B4133333333C4B657416666666646011B4166666606D0B65741666666667C001B4100000020D4B657416666666612FF1A41000000A0DCB657413333333319FE1A41333333D3E1B6574100000000EAFD1A4100000000E2B65741CDCCCCCC22FE1A4100000000EBB65741666666663AFE1A41666666C6EFB6574100000000B0FE1A419A999999F7B65741333333331BFF1A419A99991900B75741333333336DFF1A413333335307B757419A99999973FF1A41333333F30DB75741000000002EFF1A41333333B319B757410000000002FF1A41000000C025B7574133333333EDFE1A416666668630B7574100000000DAFE1A41CDCCCCCC37B75741CDCCCCCCEEFE1A419A9999D93CB757413333333309FF1A419A9999B944B757419A999999FFFE1A41CDCCCC0C4BB7574133333333EDFE1A416666660658B7574166666666EEFE1A41CDCCCC8C60B75741CDCCCCCCD0FE1A416666664666B75741CDCCCCCC9EFE1A41000000006CB757419A99999981FE1A419A99999973B75741666666666EFE1A41CDCCCC8C7AB757416666666660FE1A41CDCCCC0C84B757416666666652FE1A419A9999998CB757413333333329FE1A41000000C096B7574133333333F7FD1A41000000609EB757419A999999FDFD1A4133333393A6B7574133333333F9FD1A4133333393ACB75741CDCCCCCCD6FD1A41CDCCCC4CB2B757419A9999998BFD1A4166666606B8B75741CDCCCCCC26FD1A4166666626BDB757419A999999C7FC1A4100000040C2B757413333333395FC1A41CDCCCC2CC4B757416666666658FC1A41333333F3C2B757410000000030FC1A419A9999F9C2B757410000000012FC1A4133333313C7B757419A9999990DFC1A41333333D3CBB757419A999999E5FB1A4166666646D0B757410000000090FB1A4166666626D3B75741CDCCCCCC58FB1A41666666C6D4B757410000000030FB1A4133333333D3B7574133333333E9FA1A41333333F3D2B75741CDCCCCCCACFA1A41666666C6D6B757419A99999943FA1A4166666626DDB7574166666666BCF91A4100000060E6B757413333333357F91A41666666E6E9B757410000000044F91A419A9999F9EEB757413333333349F91A41666666C6F2B757416666666626F91A41CDCCCC0CF4B7574166666666E4F81A4166666666F4B75741000000008AF81A41333333D3F9B757419A99999907F81A41CDCCCCCC01B85741333333339FF71A41CDCCCC6C0FB857416666666640F71A41666666A618B857410000000014F71A41333333F31FB85741CDCCCCCCBCF61A419A9999F926B857416666666622F71A413333335329B857410000000048F71A419A9999992CB85741CDCCCCCCB2F71A41CDCCCC0C32B8574133333333C5F71A416666662634B8574133333333E1F71A41000000C037B85741CDCCCCCCFEF71A419A9999593DB857416666666616F81A41CDCCCCAC40B857419A9999994BF81A419A99997942B857416666666682F81A413333331347B857419A99999991F81A41CDCCCC8C48B8574100000000C0F81A41666666C646B8574166666666F0F81A41CDCCCC6C45B857410000000060F91A41333333D344B857419A99999973F91A41CDCCCC6C45B8574100000000BAF91A41666666A646B85741CDCCCCCC02FA1A41CDCCCCAC47B857413333333339FB1A413333333347B85741CDCCCCCC74FB1A410000000048B85741CDCCCCCCBAFB1A41CDCCCC8C49B8574100000000DCFB1A41333333F349B857419A99999953FC1A41CDCCCC4C49B8574100000000CCFC1A41CDCCCC6C47B85741CDCCCCCC08FD1A410000006047B857419A9999994FFD1A419A9999D947B85741000000008EFD1A416666660649B8574166666666BAFD1A410000004049B857419A999999C7FD1A416666666649B8574133333333FFFD1A41333333134AB85741CDCCCCCC74FE1A41CDCCCC2C4BB857410000000094FE1A41000000404BB8574166666666B0FE1A41333333F34AB857419A999999F1FE1A419A9999F948B857413333333301FF1A416666662648B85741CDCCCCCC0EFF1A419A9999D946B857416666666618FF1A41666666C644B857410000000018FF1A41666666A643B8574166666666FCFE1A41666666463FB8574100000000FEFE1A41CDCCCCAC3DB857419A99999911FF1A41666666E63BB857410000000056FF1A416666664638B8574166666666A0FF1A41CDCCCCAC36B857410000000086001B419A9999B936B857413333333313011B419A99995936B857410000000070011B413333337337B85741666666669E011B41333333D338B857419A999999C9011B419A99999939B85741CDCCCCCCEC011B41000000C039B85741000000002E021B41CDCCCCCC38B85741CDCCCCCCC0021B410000006034B85741333333332B031B410000006032B85741666666667A031B419A9999392FB857419A999999D3031B41000000002BB8574100000000E4031B41666666062AB857410000000028041B41666666C623B85741CDCCCCCC4C041B41000000A020B85741666666666E041B41CDCCCC6C1EB85741000000009A041B41CDCCCC6C1CB857419A999999D1041B41CDCCCC6C1BB8574166666666E2041B41000000401BB857419A99999919051B41666666A61BB8574166666666B2051B41666666E610B857410000000012061B41CDCCCCAC0FB85741000000005A071B419A9999790CB85741CDCCCCCC20081B416666668609B857419A9999995D081B410000002009B8574100000000080A1B41666666C602B857419A999999C10A1B4166666666FFB75741333333336B0B1B41CDCCCCACFCB7574133333333470C1B4133333333FAB7574133333333CD0D1B41CDCCCC2CF7B7574133333333070E1B4166666606F7B75741CDCCCCCC260E1B41CDCCCC2CF7B7574166666666480E1B41000000C0F7B75741CDCCCCCC7C101B41333333D3F9B75741666666668A131B4166666666FFB757419A99999983171B41CDCCCC2CE2B757419A999999591A1B41000000E0CDB7574100000000EA1C1B41CDCCCCECACB7574100000000A41F1B4133333313A4B7574166666666FA271B41666666268BB7574133333333A12E1B41CDCCCCAC89B75741CDCCCCCC4A311B41333333534AB7574133333333C3311B41000000E03BB75741CDCCCCCC98321B41CDCCCCAC28B7574166666666EA331B419A9999D90EB75741333333337F361B4100000060EAB65741CDCCCCCC80381B41666666E6C2B6574166666666323B1B419A9999B980B65741666666660C3B1B41000000A07EB6574166666666903A1B419A99999978B65741CDCCCCCC763A1B419A9999F977B65741666666665E3A1B41333333B377B657419A999999473A1B41666666C677B6574133333333EB391B41CDCCCC8C60B65741000000001C391B41CDCCCC6C46B65741333333337F391B416666662641B6574166666666283A1B419A9999F932B657419A999999153A1B419A9999B931B657419A9999990B3A1B416666662630B657419A999999073A1B419A9999392EB6574166666666003A1B419A9999392BB6574133333333FB391B410000002028B65741CDCCCCCCF8391B410000008024B6574133333333F5391B419A99991922B657419A999999E7391B41CDCCCC2C20B6574100000000D8391B419A9999F91EB6574100000000BE391B419A9999191EB65741CDCCCCCC84391B419A9999591DB657419A99999965391B41666666C61CB65741CDCCCCCC4A391B41333333131CB657419A99999931391B41333333331BB657419A99999915391B41CDCCCC0C1AB65741CDCCCCCCEE381B410000006017B6574100000000DE381B41666666C615B65741CDCCCCCCC8381B410000004014B65741CDCCCCCCB0381B413333335313B65741CDCCCCCC90381B419A9999D912B657419A99999971381B410000008012B65741CDCCCCCC56381B413333335312B65741333333333F381B419A99999912B657413333333329381B416666662613B657419A9999990F381B410000008013B657419A999999FB371B410000008013B6574133333333E5371B41333333D312B6574100000000CE371B41CDCCCCAC11B6574100000000B6371B416666666610B6574133333333A1371B41CDCCCC2C0FB657419A99999987371B41333333B30DB657410000000070371B41333333F30BB65741333333335D371B419A9999390AB657419A99999949371B413333337308B657410000000038371B41000000E006B657419A9999992B371B41000000A005B657413333333321371B416666662604B65741333333331F371B416666660603B657416666666624371B41666666A601B657419A9999992B371B419A99991900B65741000000002C371B41CDCCCC8CFEB557416666666624371B419A9999B9FCB55741CDCCCCCC1A371B41666666E6FAB557410000000014371B41666666A6F8B55741CDCCCCCC14371B4100000020F7B55741CDCCCCCC14371B4166666646F5B55741CDCCCCCC12371B419A999939F4B557413333333307371B4133333333F2B5574166666666F6361B4133333393F0B5574166666666E8361B419A999999EFB5574166666666D4361B41333333F3EDB5574133333333BF361B41CDCCCC4CECB5574100000000AC361B41666666C6EAB557419A9999999B361B4100000020E9B557413333333391361B41CDCCCC2CE7B557419A9999998B361B4133333373E5B55741CDCCCCCC86361B4166666686E3B557419A9999997B361B41CDCCCC4CE1B55741CDCCCCCC68361B41000000E0DFB55741CDCCCCCC52361B41CDCCCC2CDFB55741000000003C361B4133333313DFB55741CDCCCCCC24361B419A999919DFB55741333333330B361B419A999979DFB557419A999999EB351B41000000C0DFB557419A999999C7351B41333333D3DFB5574166666666A8351B4133333393DFB55741000000008E351B419A999939DFB55741000000006A351B419A999939DEB55741CDCCCCCC54351B41000000E0DCB557419A99999931351B419A9999D9DAB557416666666618351B41CDCCCCECD8B557419A9999990B351B4166666606D7B557419A999999FF341B4166666646D4B557419A999999FD341B419A999959D3B5574100000000FC341B41CDCCCC6CD0B5574133333333FD341B4100000080CDB5574166666666FE341B41CDCCCC0CCAB5574100000000FC341B4133333333C5B5574133333333E7341B41CDCCCC0CC0B5574100000000C8341B4133333333BCB557419A999999A7341B419A999959B9B557410000000088341B41CDCCCC8CB7B55741CDCCCCCC60341B419A999939B6B557413333333335341B4166666606B5B5574133333333FD331B41CDCCCC4CB4B55741CDCCCCCCB6331B4100000000B5B55741CDCCCCCC84331B4133333393B6B557419A9999994F331B41666666A6B7B55741666666660E331B419A999919B8B5574133333333F3321B41333333B3B7B5574100000000D6321B41CDCCCCECB5B55741CDCCCCCCCE321B41CDCCCCECB3B5574133333333CF321B4166666666B2B55741CDCCCCCCDC321B419A9999F9B0B55741CDCCCCCC16331B41CDCCCC6CAEB55741666666665A331B41CDCCCC0CACB55741666666669C331B41CDCCCCECA9B5574100000000C2331B4133333393A8B55741CDCCCCCCEE331B41000000A0A6B5574100000000F8331B4166666606A5B557419A999999F3331B41666666E6A1B5574133333333DF331B41CDCCCC6C9DB5574166666666B8331B419A9999799AB557416666666698331B41CDCCCC2C98B557410000000066331B41CDCCCC4C95B55741000000003A331B419A99993993B55741333333330F331B419A99997991B5574100000000E8321B41333333538EB5574133333333D5321B41333333738BB557419A999999CD321B419A9999B988B5574100000000C2321B413333333385B5574133333333B7321B41CDCCCCCC80B5574166666666A4321B41666666A67CB55741CDCCCCCC88321B419A99999979B55741000000005A321B410000008077B557416666666628321B41666666A676B5574133333333EF311B416666662676B5574166666666A0311B410000008075B557410000000068311B41000000A074B55741CDCCCCCC4C311B416666660673B55741333333332F311B41CDCCCCCC70B557410000000020311B41333333936EB557410000000020311B41CDCCCC4C6CB557419A9999992D311B41CDCCCCEC69B55741333333333D311B41CDCCCC6C66B55741666666664C311B41CDCCCC6C63B55741CDCCCCCC60311B416666662660B557419A99999975311B41666666C65CB557419A9999998B311B413333339358B557410000000092311B413333337354B557416666666690311B41333333334BB557413333333389311B410000002049B557410000000088311B41CDCCCCEC48B55741000000007A311B41666666C646B557416666666658311B41000000C042B55741CDCCCCCC3C311B410000004041B55741333333330F311B41CDCCCC6C40B5574166666666CA301B410000002040B55741CDCCCCCC7E301B41333333F33FB557416666666650301B41333333B33FB557410000000012301B419A9999593FB557419A999999C52F1B41CDCCCCCC3EB5574133333333852F1B41CDCCCCEC3DB55741CDCCCCCC562F1B41666666E63CB55741CDCCCCCC302F1B41CDCCCC2C3BB557419A9999991D2F1B413333331339B557419A9999990D2F1B416666660636B5574166666666022F1B419A9999F931B5574166666666FC2E1B41333333F32DB55741CDCCCCCC462F1B41CDCCCCAC2AB557419A9999992B2F1B419A9999D91DB5574100000000322E1B419A9999D9DEB457419A9999997F2D1B419A999979A6B45741333333333F2D1B419A9999F9A0B457419A9999999F2C1B413333333398B457419A9999994F2B1B419A9999D982B4574166666666642A1B41CDCCCC0C74B4574133333333B1291B419A9999F966B457416666666606291B419A9999595DB45741CDCCCCCCA2281B41CDCCCCAC4AB4574166666666FC271B419A99995927B457419A99999973281B41CDCCCC2CFAB357413333333387271B419A9999B9BFB357410000000088261B41CDCCCC0C83B357416666666646261B410000008075B357419A99999905251B41CDCCCC6C23B3574100000000EA231B4133333353CDB257410000000076231B4166666606BCB2574100000000B81F1B419A9999996EB25741CDCCCCCC7A1E1B413333333354B2574133333333971D1B41333333F33FB2574133333333EF1B1B41333333731EB25741CDCCCCCCE81A1B419A99991908B25741CDCCCCCCB8181B4166666666DDB157410000000080161B4133333313B0B15741CDCCCCCC3E151B419A99995996B157416666666650141B41CDCCCC0C83B157419A999999ED141B419A9999797AB1574166666666FC181B41333333934CB157413333333373181B41CDCCCC8C8EB057413333333365181B419A99995978B057419A9999994D181B416666662659B05741333333332D181B41CDCCCC4C36B0574166666666A4171B416666660622B05741000000009E161B4100000080FFAF574100000000C4131B419A999939DBAF5741CDCCCCCCDC101B419A9999B9B3AF57419A999999B10F1B41CDCCCCECA3AF57419A999999DF0F1B41000000009AAF5741CDCCCCCCD4111B419A99991931AF5741666666660C121B41333333D31DAF57419A99999909121B419A99993906AF5741CDCCCCCC98111B413333335388AE5741CDCCCCCC80111B410000002029AE5741333333337D0C1B419A9999991CAE5741666666665E0C1B41666666E60FAE5741CDCCCCCC420C1B41666666E6F4AD574166666666620B1B4133333333E5AD5741CDCCCCCC84091B41CDCCCC8CCEAD57419A999999D9081B41CDCCCCACBEAD57416666666614081B419A9999D99AAD57416666666642071B41CDCCCCCC8DAD57410000000070061B41000000607CAD57419A999999A7041B41000000C073AD57416666666600031B41CDCCCCEC69AD574166666666E2011B41333333D367AD574133333333E1FD1A41333333F34EAD57410000000016F51A41CDCCCC8C26AE574100000000FEF11A410000004073AE57419A9999997FEF1A419A999959B2AE57413333333329EB1A41CDCCCCAC1BAF574100000000BCE81A416666668652AF57419A9999991FE81A41333333F35FAF57416666666658E71A41333333137AAF574133333333FFE61A419A9999198BAF5741666666663EE61A419A999919ABAF574166666666D6E51A4100000000B9AF5741000000007AE51A41666666C6CBAF5741666666667EE51A4133333393D7AF57416666666688E51A41CDCCCC0CE4AF57413333333381E51A41333333B301B057410000000082E51A41000000600CB05741666666663EE51A41CDCCCC2C26B05741	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	01010000206A080000BA8246CF3E141B4100000080CCB25741	650290000	Z	Arras-en-Lavedan	6502900	65029	65	76	25
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	01010000206A0800002A8B143857841D419A9999C9A7AB5741	650310000	Z	Arreau	6503100	65031	65	76	11
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	01010000206A080000A918106E015F1A41000000D011AD5741	650320000	Z	Arrens-Marsous	6503200	65032	65	76	99
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	01010000206A0800005C84E06638021C41CCCCCCBC9DBD5741	650330000	Z	Arrodets-ez-Angles	6503300	65033	65	76	5
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	01060000206A0800000100000001030000000100000070000000CDCCCCCCCA231D41666666C64AB85741000000001E241D41CDCCCCEC60B857419A9999997D241D41CDCCCCCC5FB857419A9999990B251D419A99991965B85741333333332D251D41CDCCCC8C75B85741CDCCCCCCFC251D410000008073B85741666666669A261D41666666C684B857416666666684251D413333339382B85741CDCCCCCCBC241D410000006082B85741333333338B241D41333333539AB8574100000000B4251D41666666469BB8574166666666FA251D4166666626B3B857416666666620261D4100000060B1B8574133333333D1261D41CDCCCC4CB0B857419A9999993B271D4100000000B4B85741666666663C271D4166666666B9B85741666666667A261D419A9999B9CEB857416666666698261D4166666646D6B85741CDCCCCCCE0261D41333333F3D8B85741CDCCCCCC10281D4166666666D6B8574166666666E2281D419A999939D7B85741000000008C291D41CDCCCCECDBB857419A9999993D2B1D419A999979DDB85741333333336B2B1D4100000040E3B8574166666666242B1D4133333313EAB8574100000000122B1D41000000E0F2B8574166666666562B1D419A9999B9FEB857419A999999912B1D41000000C000B95741CDCCCCCC422C1D413333337302B95741CDCCCCCC7A2D1D4166666646FBB85741CDCCCCCC362E1D419A9999D9F8B8574166666666842F1D4133333313F8B857410000000082301D419A999999FFB8574133333333E9301D419A999919FEB8574133333333A1311D41666666A600B95741CDCCCCCC30321D41333333F306B9574133333333F3331D41333333D312B957413333333369341D41CDCCCC8C17B95741666666667E341D41CDCCCC6C1BB957419A9999994D341D41333333B327B957419A999999BB341D41666666462EB957419A999999F1341D41666666862EB957416666666686361D419A99993929B957419A9999991D371D41333333B328B95741666666663A371D41000000002BB957419A99999939371D419A99993934B957419A99999955371D41CDCCCC4C39B9574133333333D5371D419A99991935B957419A99999949381D41333333F332B95741000000005C381D41000000A02BB957416666666614381D41333333D321B95741CDCCCCCC40381D41000000201BB9574166666666BC381D41333333330DB9574133333333BB381D41000000A007B95741000000000E391D41CDCCCC0C00B95741CDCCCCCC2E391D41CDCCCCACF9B85741666666667C391D41CDCCCC0CF4B857419A99999985391D41CDCCCC2CEBB8574100000000D2391D41CDCCCCACE9B8574133333333F1391D41666666C6E2B85741CDCCCCCC483A1D41333333D3D8B85741666666663C3A1D419A999939D2B857419A999999E7391D41666666E6CCB857416666666656391D4100000020B7B857419A99999963391D41CDCCCC0CAEB857419A999999F5391D410000006091B85741666666661C3A1D41333333338BB8574133333333633A1D413333337385B85741333333337D3A1D41333333137AB85741666666666C3A1D413333333374B8574100000000AC3A1D419A9999796DB857419A9999998D3A1D41666666466BB857419A999999D13A1D419A9999B965B8574100000000D83A1D413333333362B8574100000000203B1D41666666265BB85741333333334B3B1D41CDCCCCCC49B857419A999999353B1D41666666863EB8574133333333F33A1D41CDCCCC4C33B8574133333333633A1D419A9999792EB85741CDCCCCCC2E381D410000000021B857413333333309381D419A9999192AB85741CDCCCCCC9A361D41333333733CB85741CDCCCCCC42351D419A99997951B857413333333351341D41000000A058B857419A99999909331D419A9999195AB857419A999999D7321D419A99999967B85741CDCCCCCC12331D419A99995970B857413333333373331D410000004073B8574166666666CA341D410000000078B857419A999999AF341D419A99993989B85741333333337F331D41666666668BB85741CDCCCCCCF0321D419A99991975B857410000000040311D41333333F353B857419A999999852F1D419A99999946B857419A999999892F1D41CDCCCCCC52B85741CDCCCCCCB02C1D419A9999196FB857419A9999998D2B1D419A9999D964B8574100000000EA2A1D41000000605DB8574166666666142A1D41CDCCCCCC57B8574166666666E2291D419A9999595CB857416666666630291D41333333B355B857413333333335291D41000000C04FB857419A999999AF281D41CDCCCCEC38B857413333333377281D41333333F330B85741666666666A271D419A99993918B857410000000044271D41CDCCCC0C10B8574166666666C6261D419A99993916B857410000000002261D41000000002FB8574133333333FD241D419A9999D92CB857419A999999C3241D41333333B340B85741CDCCCCCCCA231D41666666C64AB85741CDCCCCCCCA231D41666666C64AB85741	01010000206A08000062064F92B22F1D41000000F0A3B85741	650340000	Z	Arrodets	6503400	65034	65	76	1
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	01010000206A0800009F00EE09C64B1C41CDCCCCAC48E25741	650350000	Z	Artagnan	6503500	65035	65	76	5
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	01010000206A080000FADCCCE67E941B4100000030F8B35741	650360000	Z	Artalens-Souin	6503600	65036	65	76	4
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	01010000206A0800007E07C67339091D410000000032C35741	650370000	Z	Artiguemy	6503700	65037	65	76	3
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	01010000206A080000CE7D207AD1CA1B419A999959E1BD5741	650380000	Z	Artigues	6503800	65038	65	76	1
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	01010000206A080000985708F944691D419A99994977AE5741	650390000	Z	Aspin-Aure	6503900	65039	65	76	12
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	01010000206A080000B0BD7EA19E901B41343333C345BE5741	650400000	Z	Aspin-en-Lavedan	6504000	65040	65	76	2
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	01060000206A0800000100000001030000000100000010010000CDCCCCCC44E91C41333333534CB657419A99999909EA1C416666666664B6574133333333D3EC1C41000000C0CBB657413333333325EE1C4166666646E0B657419A9999990DF01C41CDCCCC6CF8B657419A99999987F01C419A99999908B7574100000000E2F11C41000000E03CB757416666666616F31C41CDCCCCAC5FB75741000000001EF41C41000000C07EB757413333333325F51C41333333D398B757416666666676F51C41666666C6A2B757410000000020F91C41CDCCCC2CF0B757419A99999995FA1C41666666860FB85741666666668AFB1C41CDCCCC2C2CB85741CDCCCCCC56FC1C41333333933EB85741666666665CFD1C416666668653B85741CDCCCCCC80FD1C41CDCCCC8C57B85741CDCCCCCC6AFD1C41CDCCCCEC68B857413333333383FD1C419A9999D96EB8574166666666B2FD1C419A99993970B8574166666666A4FD1C41CDCCCC6C76B857416666666610FE1C41333333F383B857419A99999929FE1C41666666E68CB857419A99999953FE1C413333333391B857419A999999BDFE1C413333337395B8574100000000E0FE1C413333337399B85741666666663AFF1C4100000080ADB85741CDCCCCCCAAFF1C4166666646B9B85741CDCCCCCCB4FF1C419A999979C2B85741333333339DFF1C41333333F3D4B8574100000000A4FF1C41333333B3E1B8574133333333D5FF1C41000000E0F3B857419A99999923001D416666666602B95741666666669C001D419A9999F90EB9574166666666E8001D41666666461CB957416666666630011D410000004022B957419A9999994B011D413333337327B957419A99999927011D41666666E645B957419A9999990B011D419A9999794EB957410000000052001D410000006067B957413333333381001D41CDCCCCEC6EB957419A999999EDFF1C41666666E699B957419A9999999DFF1C419A999979AAB95741CDCCCCCC00FF1C4166666626C1B9574166666666C2FE1C4100000000CFB9574133333333D5FE1C41666666A6D2B95741CDCCCCCC40FF1C41666666E6D6B95741CDCCCCCC96FF1C41666666E6E0B9574100000000A0FF1C4100000040F6B957419A9999995FFF1C419A99995902BA57413333333337FF1C419A9999D911BA574166666666FCFE1C419A9999D91ABA5741CDCCCCCC4CFE1C41333333B32BBA57419A99999955FE1C410000006031BA57419A99999985FF1C41CDCCCC0C43BA57419A9999996F001D419A99993966BA57419A9999993FFF1C41666666E687BA5741CDCCCCCCDEFE1C419A9999998CBA5741000000001EFE1C419A9999B98ABA57413333333313FD1C419A9999B98ABA574100000000B0FC1C41333333338CBA5741CDCCCCCC34FC1C419A99991990BA574100000000DEFB1C41333333339ABA57419A999999D9FB1C419A9999F9A3BA57416666666626FC1C4166666646ABBA5741CDCCCCCC2EFC1C41000000C0B0BA574100000000CEFB1C41333333D3CCBA5741CDCCCCCC62FB1C4133333333D3BA57413333333323FB1C41CDCCCCACE2BA574166666666C4FA1C41000000A0F4BA57413333333373FA1C41333333B307BB574166666666A2FA1C419A99991923BB574133333333CBFA1C419A9999D933BB5741333333333FFB1C41333333B33FBB574166666666FEFC1C41CDCCCCCC6FBB574133333333F7FD1C419A9999D984BB57419A99999919001D4133333333A2BB5741CDCCCCCCCA011D41333333F3C0BB57413333333383021D4166666626CCBB57419A999999D5031D41666666E6D5BB57416666666612041D419A999999DABB5741000000006E041D41666666A6EBBB57419A99999997041D4166666606F0BB5741CDCCCCCCDC041D4166666686F1BB574166666666A6051D4100000020F0BB5741CDCCCCCCD2051D41CDCCCC2CE8BB57410000000030061D41CDCCCC4CE1BB57410000000026061D4133333373D8BB574100000000F8051D41333333F3CEBB574100000000DE051D4133333333C0BB57413333333347061D41000000E0B0BB57416666666658061D4100000040ABBB5741666666660A071D4100000000A8BB57419A99999927071D41CDCCCC6CA4BB57419A99999915071D41000000E099BB57410000000084071D41CDCCCC0C8DBB57416666666632081D419A9999998ABB574166666666A0081D410000004084BB5741333333337F081D41000000007BBB574133333333A1081D419A99997976BB574100000000900B1D41666666A66BBB574166666666800F1D41CDCCCC4C6FBB574133333333BF141D41333333F353BB574166666666A8181D41000000002BBB574166666666AE1C1D41333333B3DFBA57419A9999998D231D41000000A099BA5741CDCCCCCC80251D419A9999796CBA57419A999999EB251D41CDCCCCEC63BA574166666666CC231D41CDCCCCAC2BBA57419A9999993F231D41CDCCCC0C13BA574100000000CC201D4166666646F1B95741CDCCCCCC7A1F1D4166666686C7B9574133333333F51E1D419A999979AAB9574133333333811E1D419A9999998FB95741CDCCCCCC521E1D419A9999997FB9574166666666D21E1D41CDCCCC2C6EB9574100000000D21F1D416666666648B957419A99999903201D41CDCCCC6C3AB95741CDCCCCCC52201D41000000C02FB95741CDCCCCCCAC211D41CDCCCCEC26B9574100000000B6221D419A9999B912B957410000000058231D41333333530EB957419A999999A3231D41666666E60AB9574133333333F3231D41CDCCCCEC02B95741CDCCCCCC32241D419A999999F5B857419A99999987241D4133333333EEB85741CDCCCCCCA4241D41CDCCCC8CE6B8574166666666E4241D4166666646DFB85741333333333F251D41666666C6D9B857419A999999D5251D419A999959D4B85741CDCCCCCC7A261D41333333B3D2B857416666666698261D419A999959CAB85741666666663C271D4166666666B9B857419A9999993B271D4100000000B4B8574133333333D1261D41CDCCCC4CB0B8574133333333FF251D41CDCCCC8CB2B857410000000096251D41CDCCCC2CB8B8574133333333F9241D419A9999B9BAB857419A9999994F241D41000000C0B7B857416666666622231D41CDCCCCECC0B8574100000000BC221D4133333373BFB857413333333373221D4133333353B1B85741CDCCCCCC34221D4166666626ABB8574133333333ED211D41000000A0A9B8574166666666A2211D4166666666ABB85741000000006E201D4133333373AEB857413333333335201D4166666646ACB85741666666661E201D4100000040A5B8574166666666BE1F1D41333333539AB8574133333333711F1D416666666696B8574100000000001F1D41000000A097B85741666666668E1E1D41666666669DB8574100000000D81D1D41CDCCCCECA2B8574166666666641D1D41333333F3A2B85741333333330D1D1D41CDCCCC8C9DB8574100000000F61C1D416666662693B8574166666666B41C1D41CDCCCC4C89B85741CDCCCCCC481C1D410000000085B8574166666666221B1D41333333D37FB85741CDCCCCCC8A1A1D41000000A076B857419A9999994D1A1D41333333336FB85741CDCCCCCC4E1A1D410000000069B85741CDCCCCCCDE1A1D419A9999B957B85741CDCCCCCCE21A1D41333333534DB8574133333333D11A1D410000004045B85741333333337F1A1D419A9999F93FB857416666666682191D413333331336B8574166666666F4181D419A9999192EB8574166666666A0181D419A99997926B8574133333333FD181D41666666661BB85741CDCCCCCC70191D410000004015B8574166666666CA191D419A99999912B85741CDCCCCCCDE191D41333333F30CB857410000000004191D413333337301B85741CDCCCCCCFE181D41666666E6FBB757416666666632191D41CDCCCCECF6B757419A999999CD191D41666666C6EEB7574133333333E7191D41333333D3E2B75741CDCCCCCCC8191D41333333B3DDB7574100000000C0191D4166666686D2B75741CDCCCCCC9E191D41CDCCCCCCCCB757416666666630191D41000000C0C4B757416666666636191D4100000080C0B757410000000082191D419A9999B9B8B757419A999999F9191D4166666666A8B7574133333333F3191D419A9999399BB7574100000000061A1D419A99991990B757419A999999E9191D410000008089B7574166666666EA191D410000000081B75741333333334B1A1D41000000607CB75741333333331F1B1D419A9999F97BB7574100000000521B1D419A9999D97CB7574100000000BA1B1D413333339385B7574100000000141C1D413333331388B7574133333333931C1D41000000A087B75741666666661C1D1D41000000A084B75741000000008A1D1D41CDCCCC6C7DB757419A999999B51D1D41666666A674B75741666666669E1D1D41CDCCCCCC6BB75741CDCCCCCCCC1D1D41CDCCCCCC68B7574166666666981E1D416666664667B7574166666666941F1D419A99997969B757419A999999AF1F1D41CDCCCC2C66B75741CDCCCCCC601F1D41333333B35AB757419A999999511F1D410000008051B757416666666618201D410000008046B757410000000026211D419A99997942B757410000000090211D41CDCCCC6C3CB757419A999999F3211D41666666062CB7574100000000EA211D41CDCCCC6C27B757419A999999AD211D41666666C620B757419A99999959211D41666666061BB75741CDCCCCCC56211D41CDCCCC8C0FB7574166666666B2211D419A9999990BB75741CDCCCCCCC2211D410000008008B7574166666666B2211D41000000C0FAB65741000000007A211D41000000E0F5B65741CDCCCCCCDE201D41000000A0EFB65741CDCCCCCC18201D4100000060E1B6574133333333B31F1D41CDCCCC0CD7B6574133333333A51F1D41CDCCCC2CD2B657419A999999B51F1D4166666686C6B657419A999999D31F1D4100000000BFB65741333333337D1F1D4133333333B9B6574100000000EE1E1D41000000E0B2B657419A999999F91D1D41000000C0A4B6574166666666D01D1D419A999999A0B6574133333333DB1D1D41000000A09AB65741CDCCCCCC521E1D413333339393B657419A999999DD1E1D41000000A087B65741333333330B1F1D413333333380B6574133333333051F1D41CDCCCC8C7CB6574166666666A41E1D41666666E670B65741000000007C1E1D416666668669B65741CDCCCCCC421E1D41000000C057B6574166666666481E1D41333333D351B65741333333339D1E1D419A9999B933B6574166666666181F1D41333333B325B65741CDCCCCCC621F1D41666666C621B6574133333333BD1F1D416666660621B657416666666602201D410000004019B6574100000000D01F1D41333333D312B65741333333333D1F1D419A99993916B65741CDCCCCCCBE1E1D41000000E014B657419A9999999D1E1D416666662612B65741CDCCCCCC9A1E1D41CDCCCC8C0BB6574100000000CA1E1D413333339303B65741CDCCCCCCC01E1D4133333313F8B557419A999999D11E1D419A999979F3B55741CDCCCCCC341F1D41666666A6E8B5574166666666761F1D4133333313DBB557419A9999994B1F1D4166666606CDB5574133333333891F1D41CDCCCC2CCBB5574166666666881F1D419A9999D9C3B5574166666666441F1D41666666A6BEB5574100000000401F1D41000000E0B7B5574166666666B81F1D4100000060A7B557419A999999E11F1D4133333373A4B55741CDCCCCCC72201D41666666C69FB5574100000000B4201D419A99993998B557419A9999992D211D41CDCCCC4C92B55741CDCCCCCCEE211D41333333938BB55741CDCCCCCC20221D41333333131EB5574133333333FF211D4166666626FCB4574166666666B8211D41666666A6FDB45741333333337F181D410000004027B557419A999999870D1D419A9999D9E8B457419A9999990F0D1D41CDCCCC2CEAB45741CDCCCCCC64FA1C41333333739DB55741000000006EEF1C41666666C60AB65741CDCCCCCC44E91C41333333534CB65741CDCCCCCC44E91C41333333534CB65741	01010000206A080000E228A423E40B1D41333333436DB85741	650410000	Z	Asque	6504100	65041	65	76	16
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