SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep66;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep66 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep66','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep66','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep66','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep66"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000565B9003AE19254100000000BA785741	660010000	Z	L'Albère	6600100	66001	66	76	16
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	01060000206A0800000100000001030000000100000085000000CDCCCCCCA3602541666666860A8B574133333333DF5E25419A9999D9F28A5741333333331F5D254133333373D98A574166666666C15B254100000000C58A574100000000E459254100000080988A5741CDCCCCCC4C592541000000C0848A57419A99999975582541333333536A8A57419A99999922582541666666265F8A574133333333A0572541CDCCCCEC498A5741666666666F572541000000A03D8A574166666666E856254133333333238A57419A99999983562541000000200D8A574133333333095625419A999919F689574166666666A45525419A999919E789574133333333465525419A999939D68957413333333321552541CDCCCCECCB89574166666666F7542541666666E6C4895741000000009554254133333313BB89574133333333F95225419A99997997895741333333333D5225413333337385895741CDCCCCCCB0512541666666467B8957419A99999916512541666666E67189574166666666984F25419A99997955895741333333334A4F2541666666065489574133333333A94E25419A9999794D895741000000003D4E2541666666E64C895741CDCCCCCCEB4C2541000000E05D89574133333333934C2541333333535F89574166666666344C2541666666065E89574133333333C54A2541000000005689574100000000EB4925410000000052895741333333338B492541333333F35089574100000000064925413333333352895741CDCCCCCCC2482541CDCCCCEC548957413333333322482541000000E05589574166666666C8472541666666C65A8957419A99999979472541000000E06289574166666666584725410000000065895741666666665F4725410000004068895741CDCCCCCCDB462541333333F38389574100000000A1462541333333538E89574166666666694625419A9999F994895741666666663045254100000060B78957416666666649442541333333D3D68957413333333311452541CDCCCCECE9895741333333338E442541CDCCCC4CF989574100000000D245254166666686158A57416666666646442541CDCCCC2C578A57419A9999991B432541000000808A8A57419A999999E2422541333333F3938A574100000000A54225419A9999399C8A574133333333174325419A999959A68A57413333333388422541CDCCCCECBA8A5741CDCCCCCCE7422541CDCCCCACC88A57419A99999947422541000000E0DB8A5741CDCCCCCC9D422541000000A0EA8A574133333333FF42254133333313F98A5741333333334C43254133333333EF8A574166666666D04325419A9999D9038B574166666666E344254133333393EC8A57419A9999995045254166666646E28A574133333333CD45254133333333DC8A574166666666EF46254100000060CF8A5741CDCCCCCC1A4725419A9999D9CC8A5741CDCCCCCCB0472541666666C6C68A5741CDCCCCCC434825419A9999B9BF8A574133333333B5482541000000A0D48A574166666666934825419A999959DC8A57419A999999E1472541666666A61B8B5741CDCCCCCCB34725419A999959298B5741000000009E4825419A9999391E8B57413333333371492541000000A0198B574133333333C3492541666666461A8B57419A9999996C4A25419A9999991D8B574133333333004B2541CDCCCC0C2E8B57419A999999CC4B25419A999999418B574100000000054C254100000060468B5741CDCCCCCC3B4C25419A9999D94D8B57419A999999A94C2541000000A0618B574166666666064D2541333333F36E8B574133333333574D2541CDCCCC8C7C8B574133333333674D2541CDCCCCAC808B5741CDCCCCCC7B4D25419A9999597C8B574166666666CA4D254133333333718B574133333333EE4D25419A999959708B574166666666D64E2541CDCCCC6C8C8B574100000000054F25419A9999997F8B5741333333330C4F2541333333737B8B574100000000834F25419A9999F97E8B57419A9999990550254166666666778B5741CDCCCCCCA65025419A9999B9718B574133333333F5502541CDCCCC4C768B57410000000028512541CDCCCCEC818B5741CDCCCCCC6E512541CDCCCCCC968B5741CDCCCCCC11532541666666C68C8B5741666666662C53254100000080938B57419A999999F35325419A999999BB8B574133333333995425419A9999D9AC8B57413333333391542541333333D3A18B5741CDCCCCCC2E55254133333313898B574133333333075625419A999979AA8B5741333333331056254133333333AB8B574100000000B9562541CDCCCC8C958B574166666666D6562541CDCCCC6C938B57410000000093572541333333D3AA8B57419A999999B25725419A999979AB8B574166666666A45825419A999939988B5741CDCCCCCCD659254133333373BF8B57419A999999095B2541CDCCCC6CE78B5741CDCCCCCC425B25419A999999EF8B5741CDCCCCCC115C254133333353E48B5741CDCCCCCC615C254133333353EC8B5741CDCCCCCCE95C254166666686FD8B5741CDCCCCCCF05C254166666646FF8B5741CDCCCCCC975D254166666626F68B57419A999999F05D254133333373F28B5741CDCCCCCC245E25419A9999D9ED8B5741CDCCCCCC665E254166666606E48B57419A999999E45E2541CDCCCC6CDA8B574166666666035F254166666606D38B574100000000105F254100000060CC8B574133333333515F25419A999999B58B57419A999999685F25419A9999B9AB8B57419A9999991E5F254100000000978B574100000000195F2541CDCCCC4C8F8B5741000000004D5F25419A999939738B57419A999999A25F2541333333D3678B5741CDCCCCCC975F254133333333608B574100000000575F25419A999979428B574133333333155F2541666666E6258B5741666666669B60254133333373148B5741CDCCCCCCA3602541666666860A8B5741CDCCCCCCA3602541666666860A8B5741	01010000206A080000A6A5A555B84E254100000020A58A5741	660020000	Z	Alénya	6600200	66002	66	76	6
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	01010000206A080000197AA197958D24416666666605765741	660030000	Z	Amélie-les-Bains-Palalda	6600300	66003	66	76	29
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	01010000206A08000057D695F5EAFA22416666665668845741	660040000	Z	Les Angles	6600400	66004	66	76	43
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	01010000206A080000C2D0B936B4C92241000000A0D8805741	660050000	Z	Angoustrine-Villeneuve-des-Escaldes	6600500	66005	66	76	87
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	01010000206A0800003C6E3CEECE292441333333B32D985741	660060000	Z	Ansignan	6600600	66006	66	76	8
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	01010000206A080000A5B18975C3172441000000D0818D5741	660070000	Z	Arboussols	6600700	66007	66	76	14
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	01060000206A080000010000000103000000010000002B0000003333333314682541CDCCCCCC568057416666666666682541CDCCCC2C5D8057419A999999776825419A99999960805741CDCCCCCCD96825419A9999596580574133333333D6692541333333D37A80574166666666266A2541CDCCCC0C7F805741666666664B6A254133333373838057419A999999766A25419A99995983805741CDCCCCCCB96A25419A9999D98880574166666666126B2541000000209280574133333333816B25419A999999998057419A999999C76B25419A9999599B805741CDCCCCCC596C25419A9999B9978057419A9999995A6C25419A9999B99D80574133333333B66C2541CDCCCCCC968057419A999999306D2541000000A09280574100000000986D2541CDCCCCCC938057419A999999F36D2541333333739780574133333333E96D2541000000209580574166666666006E25419A9999B98F805741CDCCCCCC386E2541333333939180574100000000CA6E25413333335392805741CDCCCCCCF26E2541CDCCCCAC9180574133333333336F25419A9999F984805741CDCCCCCC8F6E2541CDCCCCAC7880574133333333196F2541333333935D805741CDCCCCCC1E6F2541CDCCCCCC5880574166666666696F25419A9999995280574100000000BB6F2541000000C04980574166666666D56F25419A9999B94480574133333333C56F25419A999979428057419A999999686F25419A9999593D80574166666666046E2541000000202880574100000000616D2541CDCCCC0C1E805741666666662A6D2541000000E01580574100000000136D2541666666861580574133333333066D254166666626E87F574133333333156D2541000000A0E37F57419A999999016D2541CDCCCCCCDC7F5741666666662A6B2541000000600A80574166666666676925419A999979358057413333333314682541CDCCCCCC568057413333333314682541CDCCCCCC56805741	01010000206A08000040ECF2803E6C2541666666063D805741	660080102	H	Le Village	6600801	66008	66	76	0
01060000206A08000001000000010300000001000000F70D00006666666683522541666666C6548357419A9999991F522541000000605F8357419A999999085225419A9999796083574133333333D15125413333333366835741666666669F5125419A9999B96C835741CDCCCCCCFB512541CDCCCC4C77835741CDCCCCCC2D522541000000007D8357419A999999D0512541CDCCCCEC95835741666666664451254100000040BB835741CDCCCCCCFA502541666666E6CE83574133333333F6502541CDCCCC2CD083574166666666A650254133333373E5835741333333333E50254166666686F583574166666666EC4F2541666666A603845741CDCCCCCCD64F25419A9999590784574166666666CE4F25419A9999D908845741CDCCCCCCC84F2541CDCCCC2C0B84574100000000954F2541CDCCCC6C2184574133333333884F2541000000E0268457419A999999654F25419A99993938845741000000004D4F2541666666A644845741CDCCCCCC004F25410000004050845741CDCCCCCC5B4E25419A99995969845741666666661E4E25419A9999B97284574133333333164E2541CDCCCCEC7384574166666666064E2541333333537684574100000000024E2541666666067784574166666666954E2541000000607A845741CDCCCCCCE94E2541666666A67C845741666666666D4F2541CDCCCC6C80845741CDCCCCCC8F4F2541333333F38084574133333333D94F2541666666268284574133333333F74F2541000000A08284574100000000AA5025416666668687845741CDCCCCCC1A512541333333538B8457416666666673512541666666E68C8457413333333398512541CDCCCC8C8D84574166666666605225419A9999B990845741CDCCCCCC955225419A999999918457413333333328532541000000E094845741333333332C5325419A9999F9948457419A9999993253254100000020958457419A99999949532541000000C095845741666666664D532541666666E695845741CDCCCCCC5B5325419A9999F9958457419A999999645325419A9999799684574100000000A053254133333333978457410000000002542541CDCCCCCC978457419A9999994D542541CDCCCC4C98845741CDCCCCCC71542541CDCCCC8C9884574100000000D6542541CDCCCC6C9884574133333333B455254166666666998457416666666641572541000000009984574166666666665725419A9999D99884574100000000B55725419A99997998845741CDCCCCCC1258254133333333978457419A9999995A582541CDCCCC6C9484574133333333E3582541CDCCCCCC9884574133333333615925419A9999D99C845741CDCCCCCCC759254166666626A084574100000000A55A254100000040A784574166666666E65B254133333393B18457419A999999FF5C2541000000A0BA84574166666666BA5D2541000000A0C084574166666666B05E254166666686C884574100000000B75E2541000000C0C884574100000000C95E254166666606C984574166666666125F2541000000C0CA84574133333333335F254100000080CB845741666666664A5F254100000020CC845741CDCCCCCC525F254166666626CC845741CDCCCCCC82612541666666E6CC8457413333333393622541CDCCCC4CCD845741333333332D63254100000080CD84574166666666F8632541666666C6CD8457416666666640642541000000E0CD8457419A9999994B64254133333313D08457419A9999991A652541000000C0ED845741000000001E6525419A999959ED8457419A9999992A65254100000080EE845741CDCCCCCCA9652541333333530185574133333333AD652541666666C6018557410000000037662541000000C01385574166666666516625413333333317855741CDCCCCCC5D662541CDCCCCCC188557416666666667662541333333131A855741CDCCCCCC796625419A9999791C8557410000000082662541000000801D8557410000000094662541000000E01F85574100000000E5662541CDCCCC6C2A855741CDCCCCCC9C67254166666666428557410000000072682541666666A65E8557413333333394682541CDCCCC6C5E85574166666666A7692541CDCCCCAC5C855741CDCCCCCC076A2541000000205C8557419A999999196A2541666666065C85574166666666B56A2541CDCCCC0C5B855741CDCCCCCC566B2541666666065A85574133333333F06C254100000080578557419A999999146D2541CDCCCC4C5785574166666666426D25410000000057855741333333335C6E2541000000405585574166666666C96E2541333333935485574133333333726F254166666606578557419A9999999B6F2541000000A057855741000000000F70254133333353598557419A9999991B722541CDCCCCEC60855741CDCCCCCC6E7225410000002062855741666666665173254133333373658557419A999999B3732541000000E06685574133333333F07425419A9999796B8557419A999999697525419A9999396D85574166666666A8752541000000206E8557419A999999E8752541CDCCCC0C6F85574100000000327625410000002070855741CDCCCCCC5D762541666666C6708557419A9999991F7725419A99999973855741000000008A7725410000002075855741CDCCCCCCE977254166666686768557419A999999F7772541000000C076855741666666662B7825419A999979778557413333333348782541666666E677855741666666669C78254100000020798557419A99999904792541000000A07A855741333333331E792541000000007B855741333333331C7925419A99991979855741CDCCCCCC17792541CDCCCC4C6D8557419A9999991679254133333313668557419A99999919792541333333D35F8557419A99999917792541000000205A855741333333331A792541333333B354855741000000001F79254166666686528557419A999999257925419A9999994D8557419A9999992E792541CDCCCC4C488557419A99999934792541CDCCCC2C428557419A99999947792541000000203C855741CDCCCCCC5979254133333353378557410000000072792541CDCCCCAC348557419A9999997679254166666686338557419A9999997A792541333333B330855741CDCCCCCC83792541000000402E8557419A999999C0792541000000200B8557419A999999C77925413333331309855741CDCCCCCCC47925419A9999790085574166666666BF7925419A9999F9FB84574100000000BE792541CDCCCCECF784574133333333B1792541666666C6EF84574166666666AD792541CDCCCC8CEB84574166666666AA79254133333353E784574100000000AF792541CDCCCC8CE284574166666666AC79254100000060DF8457419A999999A4792541CDCCCC2CD88457416666666697792541666666E6D38457416666666696792541666666C6CC845741000000009279254133333373C6845741CDCCCCCC93792541666666A6C08457419A9999999979254166666606B68457419A9999999979254100000080B1845741333333339C7925419A999939AB845741666666669C792541000000C0A484574166666666A0792541000000C0A08457419A999999A3792541666666069E84574100000000AF7925419A9999999C84574133333333BA792541000000009A8457419A999999CA792541333333B39484574166666666D77925419A9999399084574166666666D97925419A9999F98D845741CDCCCCCCD9792541333333738B845741CDCCCCCCD8792541666666268984574133333333CC792541333333737A84574166666666C979254166666626768457419A999999C77925419A99999971845741CDCCCCCCC9792541CDCCCCAC6184574100000000CA792541000000005084574133333333CC792541000000604984574166666666CF7925419A9999D94484574100000000D5792541000000E04084574166666666DD7925419A9999793C84574166666666E9792541000000403784574133333333097A25419A9999B92A84574133333333157A2541333333132584574100000000177A2541CDCCCCEC238457419A999999177A2541666666E6228457419A999999177A2541CDCCCC2C2184574133333333167A2541333333531F84574133333333127A2541000000201D845741CDCCCCCC017A25419A9999391584574133333333007A2541CDCCCCAC128457419A999999FF792541666666C60F8457419A999999007A2541CDCCCC8C0B84574133333333037A254100000020068457419A9999990D7A25419A999979F58357419A9999990D7A254133333333F4835741000000000C7A25419A999999F1835741666666660C7A2541333333B3EE8357419A9999990E7A25419A999979EB83574100000000167A25419A9999D9E283574100000000187A2541CDCCCC8CDE83574100000000187A25419A999959DC83574100000000177A2541CDCCCC6CDA835741000000000F7A2541000000E0D3835741666666660A7A25419A999999CF835741CDCCCCCC087A254133333333CD835741CDCCCCCC087A254100000000CB835741333333330A7A2541333333F3C883574100000000157A25419A999919C2835741CDCCCCCC1B7A254100000020BC8357419A999999207A254166666646B583574166666666237A2541CDCCCC6CAC835741CDCCCCCC257A25419A999919A883574100000000287A25419A999939A6835741000000002F7A254166666626A283574100000000317A254100000080A0835741CDCCCCCC317A25419A9999D99C83574133333333307A2541000000C099835741CDCCCCCC2D7A25419A9999B9978357419A999999287A2541CDCCCC8C95835741CDCCCCCC2B7A25416666668692835741000000002B7A25419A9999D99183574166666666297A25413333337391835741CDCCCCCC257A2541CDCCCC2C91835741CDCCCCCC147A2541CDCCCCAC90835741CDCCCCCCFE792541666666E68F8357419A999999FE792541666666468E83574166666666167A2541333333D38E835741666666661F7A2541CDCCCC2C8F835741666666662A7A25419A9999D98F835741CDCCCCCC2D7A2541333333F38F83574100000000307A2541666666E68F83574166666666337A2541333333B38F83574100000000357A2541333333738F83574100000000427A25419A9999398C835741666666663F7A25410000002084835741CDCCCCCC387A2541CDCCCCAC76835741CDCCCCCC377A25416666664672835741CDCCCCCC377A2541666666C66E835741CDCCCCCC387A2541000000006C835741666666663A7A2541333333F36983574133333333487A2541000000005A835741000000004A7A2541CDCCCC2C56835741000000004A7A2541CDCCCC2C5483574133333333487A2541000000004F83574166666666437A25419A9999D946835741000000003F7A254133333353418357419A9999993E7A2541000000603F83574166666666407A25419A9999593D835741CDCCCCCC4A7A2541000000603783574166666666607A2541666666E62B835741CDCCCCCC807A2541333333931B8357419A999999867A25419A999919188357419A999999877A2541CDCCCC6C16835741CDCCCCCC877A2541CDCCCC0C1283574133333333897A2541666666660F8357419A9999998C7A2541333333F30B83574133333333977A25419A9999190483574100000000997A25419A9999990183574133333333977A254133333313FD82574166666666907A2541000000A0F1825741CDCCCCCC8B7A2541CDCCCCECEB8257419A999999847A25419A999939E582574166666666817A2541333333D3DF82574166666666807A2541CDCCCC0CDC825741CDCCCCCC807A254133333393D68257419A999999827A25419A9999D9CF8257419A999999847A2541000000A0CB825741CDCCCCCC967A2541CDCCCC4CB7825741CDCCCCCCA17A2541CDCCCCECAC82574100000000A67A25419A9999D9AA8257419A999999B87A254166666606A4825741CDCCCCCCBB7A2541CDCCCC8CA282574166666666BE7A2541000000A0A082574100000000C97A2541666666E695825741CDCCCCCCCE7A2541CDCCCC6C918257419A999999D67A2541666666668C82574133333333DD7A2541333333D38782574133333333E47A25419A9999D980825741CDCCCCCCEC7A2541666666067A82574166666666EF7A2541666666867782574100000000F77A2541CDCCCCAC6C8257419A999999027B2541666666E65E825741666666660D7B25419A9999794C82574133333333167B25413333333340825741666666661E7B25419A999979378257419A999999337B2541666666C6248257419A9999993A7B2541CDCCCCCC1D825741CDCCCCCC3E7B2541666666E61882574166666666437B25419A9999590F82574133333333477B2541666666E60982574166666666517B254166666666FE815741CDCCCCCC6D7B2541CDCCCCECE08157419A9999997A7B2541000000A0D08157419A999999907B254100000040BD81574133333333AA7B2541666666A6A881574133333333B17B2541CDCCCC4CA1815741CDCCCCCCB87B2541000000009781574100000000BB7B25419A9999D9928157419A999999B97B2541333333538F81574100000000B37B2541333333138881574133333333B37B2541333333538781574166666666B47B2541333333B38681574166666666B47B25419A99991986815741CDCCCCCCB57B2541CDCCCCAC85815741CDCCCCCCB87B25419A9999F98281574133333333BB7B254100000000828157419A999999BC7B2541000000008181574133333333BE7B254166666686808157419A999999BE7B2541666666068081574133333333C57B2541CDCCCC8C7D81574100000000CB7B2541000000807A8157419A999999D87B2541666666E67181574133333333DF7B2541666666A66C8157419A999999EA7B25419A9999196081574100000000F47B2541CDCCCC8C5781574133333333FA7B2541333333935281574100000000FC7B25419A9999994F81574166666666FE7B2541000000604D81574100000000017C25419A9999D94881574100000000037C2541666666C64681574133333333107C2541333333F33B81574166666666107C25410000000036815741CDCCCCCC0F7C254166666606348157419A999999117C254133333313308157419A999999157C2541333333932B8157419A9999991A7C2541000000002881574133333333247C2541CDCCCCCC21815741CDCCCCCC357C25416666662615815741CDCCCCCC377C2541CDCCCC2C13815741CDCCCCCC3B7C2541CDCCCC4C1181574100000000427C2541333333330C815741666666664D7C2541000000400581574166666666587C254133333393FF805741666666665A7C2541666666A6FD80574100000000637C254166666686F8805741333333336D7C2541333333D3F0805741000000006E7C254166666606EF805741333333336E7C254166666646EB805741666666666C7C2541000000C0E5805741CDCCCCCC6D7C2541CDCCCCACE180574100000000747C254166666606DA805741CDCCCCCC7D7C254133333393D180574100000000827C2541CDCCCC8CCB8057419A999999847C254133333333C980574166666666887C254133333393C6805741666666668D7C25419A999999C38057419A9999999E7C2541666666A6BA80574166666666AF7C25419A9999F9B0805741CDCCCCCCC47C2541333333D3A58057419A999999D37C2541CDCCCC8C9C80574133333333DA7C2541CDCCCCEC988057419A999999F57C2541CDCCCCCC8B80574100000000FF7C25419A9999D9868057419A999999077D2541666666A68180574166666666217D25419A9999D96E80574166666666287D2541666666C66A8057419A9999992E7D254100000000688057419A999999357D254166666666658057419A9999993C7D2541666666266380574100000000477D25419A99995960805741CDCCCCCC4D7D2541666666465E8057419A9999995C7D2541000000C058805741333333336A7D2541666666C652805741CDCCCCCC887D2541333333B343805741000000008F7D2541CDCCCC2C41805741666666669E7D2541CDCCCC8C3B805741CDCCCCCCBC7D2541000000002E80574133333333CE7D2541CDCCCCAC2680574133333333DA7D2541666666462280574166666666E47D25419A9999591F80574133333333EA7D2541666666461E8057419A999999FB7D2541666666A61A80574133333333077E2541CDCCCC8C18805741CDCCCCCC197E2541333333B31580574133333333257E254133333333148057419A999999377E2541000000401280574100000000567E2541000000600F805741000000005C7E2541666666660F80574133333333667E2541666666E60F8057419A999999877E2541000000801280574133333333BB7E25419A999919168057419A999999CE7E2541CDCCCC2C17805741CDCCCCCCD77E2541000000801780574166666666E47E2541666666C6178057419A999999F57E2541333333D31780574133333333057F2541333333931780574133333333157F254166666686178057419A999999227F25419A99993917805741CDCCCCCC397F2541CDCCCC0C17805741666666666A7F25410000004016805741CDCCCCCC767F2541CDCCCC4C1680574166666666807F2541666666261680574166666666887F25419A999939168057419A999999957F2541000000E0158057419A999999BC7F25419A9999391580574100000000CA7F2541666666C61480574100000000D37F254166666646148057419A999999D97F2541CDCCCCCC13805741CDCCCCCCE57F2541000000801280574100000000EC7F25419A9999B9118057419A999999F37F25416666666610805741CDCCCCCCF97F2541333333930F8057410000000001802541666666260E8057413333333303802541333333730D8057419A99999904802541666666860C8057419A9999990A8025419A9999D90A805741CDCCCCCC0F8025410000008008805741CDCCCCCC13802541333333730780574133333333198025416666668606805741CDCCCCCC1B802541333333F305805741CDCCCCCC22802541CDCCCC4C038057419A999999268025413333335302805741000000003080254133333333FF7F57413333333333802541CDCCCC4CFD7F57419A9999993380254166666606FC7F57419A99999932802541CDCCCC2CFB7F57419A9999992F80254100000060FA7F5741333333332C802541CDCCCCCCF97F57419A9999992580254133333333F97F5741000000001F802541CDCCCCECF87F5741CDCCCCCC16802541333333D3F87F57419A9999990E8025419A9999F9F87F574133333333078025419A999959F97F57416666666600802541666666E6F97F5741CDCCCCCCFB7F254166666626FC7F5741CDCCCCCCFB7F2541CDCCCC0CFD7F574133333333FA7F2541666666E6FD7F5741CDCCCCCCF77F254133333393FE7F5741CDCCCCCCF27F25419A999999FF7F574100000000F17F2541CDCCCC2C0080574166666666F07F2541666666E60080574100000000F17F2541CDCCCCEC0180574166666666EF7F2541000000200380574133333333EC7F2541CDCCCC2C0480574100000000DF7F2541CDCCCCEC078057419A999999D97F2541333333F30980574100000000D27F2541000000A00B80574166666666CE7F2541000000A00C80574100000000CC7F2541000000800D80574100000000C87F25419A9999590E80574100000000C27F2541666666E60E805741CDCCCCCCBD7F2541666666260F80574133333333B37F2541333333930F805741CDCCCCCC9C7F25410000000010805741333333332B7F25413333331311805741CDCCCCCC087F254166666646118057419A999999EE7E2541CDCCCC4C118057419A999999DC7E2541666666261180574166666666D27E2541333333D31080574133333333CA7E2541333333731080574133333333AA7E2541666666C60E80574166666666847E2541000000A00C805741666666665B7E2541000000000A805741CDCCCCCC597E2541000000C009805741CDCCCCCC597E25410000008009805741333333335B7E25410000000009805741000000005C7E25419A9999390880574100000000607E2541CDCCCCAC0780574100000000627E2541CDCCCCAC0780574166666666637E2541000000800780574166666666637E25410000000007805741666666663C7E2541000000C0048057419A999999137E2541333333730380574166666666CC7D2541333333330480574100000000957D2541333333530580574166666666607D254133333393068057419A9999992B7D2541666666C608805741CDCCCCCC007D2541CDCCCC4C0B80574100000000D27C2541000000800E805741CDCCCCCCCD7C2541333333930E80574166666666C67C2541333333130F805741CDCCCCCCB07C2541CDCCCC2C118057419A999999A87C2541666666C611805741CDCCCCCCA37C25419A99995912805741000000009B7C2541CDCCCCCC1280574166666666967C25419A9999391380574100000000837C254100000040148057419A9999997E7C2541CDCCCC8C14805741666666667B7C25419A9999D914805741CDCCCCCC757C25419A99999915805741CDCCCCCC707C254133333313168057419A9999996E7C254133333393168057419A9999996D7C254133333333178057419A9999996C7C254166666666178057419A999999657C25416666664618805741000000005F7C2541CDCCCC4C19805741CDCCCCCC527C2541666666A61B8057419A999999467C2541000000C01E80574100000000437C2541000000801F805741000000003F7C2541CDCCCC2C2180574100000000367C2541333333732280574166666666337C2541CDCCCCEC2280574100000000287C25419A9999792580574100000000227C25413333339326805741333333331F7C2541CDCCCC6C27805741333333331C7C25419A9999F928805741CDCCCCCC137C2541000000C02A80574133333333107C25419A9999592B805741CDCCCCCC0C7C2541333333932B805741333333330A7C2541CDCCCC2C2C80574133333333067C25419A9999992C805741CDCCCCCC027C2541CDCCCC2C2D80574133333333017C2541CDCCCC8C2D805741CDCCCCCC007C2541333333D32D80574166666666037C2541CDCCCC6C2E80574166666666037C2541CDCCCCAC2E8057419A999999017C25419A9999F92E8057419A999999FF7B25419A9999192F805741CDCCCCCCE57B2541666666862E80574100000000E57B2541666666862E8057419A999999E37B2541666666C62D8057419A999999EC7B2541000000402D8057419A999999F17B2541000000C02C805741CDCCCCCCF37B2541666666662C80574100000000E77B25419A9999192B805741CDCCCCCCE57B2541000000C02A8057419A999999E77B25419A9999F92980574133333333EB7B2541CDCCCC0C2980574133333333EF7B25413333339328805741CDCCCCCCF77B2541CDCCCC0C2880574100000000FB7B2541333333132880574100000000FD7B25419A999939288057419A999999FD7B25416666662628805741CDCCCCCCFE7B2541CDCCCC0C2780574166666666007C25416666664626805741CDCCCCCC037C2541000000802580574133333333067C25416666668624805741CDCCCCCC0B7C25419A999959238057419A9999990C7C25410000006022805741333333330F7C2541333333932180574100000000117C2541333333732080574166666666137C2541333333D31F8057419A999999187C2541666666E61E805741CDCCCCCC1B7C25419A9999F91D80574166666666207C2541333333331D80574100000000297C2541000000001C8057419A9999992F7C25419A9999D91A80574133333333347C2541333333731A805741000000003A7C2541333333131A805741CDCCCCCC3C7C2541333333B31980574166666666507C2541000000C0158057419A9999995C7C2541666666E61380574100000000647C25419A999919138057419A999999657C2541000000C012805741CDCCCCCC697C25410000002012805741CDCCCCCC747C2541333333F3108057419A999999847C2541666666A60F805741000000008C7C2541666666460F8057419A999999937C2541CDCCCC4C0F80574133333333967C2541000000200F80574100000000997C2541CDCCCCCC0E8057419A999999A17C2541666666860D80574133333333AB7C2541000000600C8057419A999999AE7C2541000000400C8057419A999999B37C25419A9999390C8057419A999999B67C2541333333130C8057419A999999C57C2541666666C60A8057419A999999D57C2541333333D309805741CDCCCCCCDE7C2541666666E608805741CDCCCCCCE77C25419A999939088057419A999999EE7C2541000000600780574133333333F27C25416666664607805741CDCCCCCCF57C25419A9999F90680574166666666FC7C254133333393068057419A999999027D254166666606068057419A9999990C7D2541CDCCCC8C05805741333333331E7D254166666666048057419A999999487D25410000004002805741CDCCCCCC757D2541000000C000805741333333338E7D25416666662600805741CDCCCCCC987D25419A9999B9FF7F5741000000009D7D2541333333B3FF7F574133333333A57D2541333333D3FF7F5741CDCCCCCCAC7D2541666666A6FF7F574166666666C57D254133333373FF7F574166666666007E25419A9999B9FE7F5741333333332C7E25419A999959FE7F5741CDCCCCCC3C7E2541CDCCCC0CFE7F574100000000427E2541CDCCCCCCFD7F5741CDCCCCCC457E254100000080FD7F574100000000487E2541CDCCCC2CFD7F574100000000497E25419A9999D9FC7F5741CDCCCCCC487E254100000080FC7F574100000000487E254166666646FC7F574100000000417E254100000040FB7F5741333333333E7E254100000040ED7F5741000000003E7E254166666626ED7F5741CDCCCCCC1A7E25419A999919ED7F57419A999999177E2541CDCCCC6CDB7F574100000000AF7D2541CDCCCC8CD57F574166666666A27D254133333313D97F5741333333336F7D2541CDCCCC2CD67F574133333333697D25419A9999B9D17F5741666666663B7D254166666626CF7F574166666666D67C254166666646EB7F57419A999999B87B25419A999979DB7F574100000000007C2541CDCCCCCCC77F574166666666DC7C254100000020D47F57419A999999DF7C254100000040D37F574100000000037C254100000000C77F574133333333717B2541000000C0BE7F57419A999999647B254100000040C27F57419A9999995B7B25419A9999B9C17F574133333333697B2541000000A0BD7F574133333333597B25419A9999D9BC7F574133333333577B254166666686BC7F5741CDCCCCCC557B2541CDCCCC0CBC7F57419A999999577B254133333333BB7F574166666666757B2541666666E6B27F57419A999999EF7B2541333333B3B97F5741CDCCCCCCFD7B2541666666C6B57F57419A999999027C254100000000B67F574100000000057C254100000040B57F57419A999999007C25419A9999F9B47F5741CDCCCCCC0F7C25419A9999D9B07F57419A999999C37B2541CDCCCCCCAC7F5741CDCCCCCCD07B2541CDCCCCCCA87F5741CDCCCCCCD87B25419A999999A67F5741CDCCCCCCE17B25419A999959A47F574166666666E37B2541CDCCCCACA37F5741CDCCCCCCFC7B25419A999919A57F5741CDCCCCCC047C254166666686A47F5741333333330F7C254133333373A17F574133333333197C2541333333F3A17F5741CDCCCCCC0D7C25419A999919A57F574133333333117C254133333333A67F5741CDCCCCCCDB7C25419A999939B17F5741CDCCCCCCE87C254133333393AD7F574100000000117D25419A999979AB7F574133333333187D254166666686AB7F57419A999999237D25419A9999B9AB7F5741CDCCCCCC317D254100000060AC7F574133333333427D2541CDCCCCECAC7F5741CDCCCCCC487D254133333353AD7F5741000000004E7D254166666686AD7F574133333333547D254166666606AE7F5741333333335A7D2541CDCCCC4CAE7F574133333333677D25419A999919AF7F5741666666667A7D254166666606B07F574100000000857D2541000000A0B07F5741000000008E7D254100000000B17F574166666666957D254133333393B17F57419A999999A77D25419A9999B9B27F574166666666BA7D2541333333B3B37F574100000000C77D2541666666A6B47F5741CDCCCCCCD97D2541CDCCCCCCB57F574133333333E17D254133333373B67F574100000000E97D2541CDCCCCECB67F5741CDCCCCCCEE7D254166666666B77F574100000000F77D2541CDCCCC4CB87F574100000000FE7D25419A999979B97F574166666666047E254100000040BA7F574166666666057E254100000080BA7F57419A999999047E254166666666BB7F574100000000EE7D254166666606C37F574100000000EA7D254100000060C37F574100000000E47D254166666686C37F574166666666E17D2541000000C0C37F574100000000E07D2541CDCCCC0CC47F574100000000E07D254100000040C57F5741CDCCCCCCE17D254100000080C57F5741000000000A7E254133333393C77F574100000000107E254133333373C77F574100000000147E25419A999919C77F5741000000001A7E254100000000C67F5741666666661B7E254100000080C57F5741CDCCCCCC177E254133333373C47F5741CDCCCCCC217E254100000000C47F574100000000217E254100000000C37F5741000000001F7E254100000040C27F574166666666207E25419A9999B9C07F5741CDCCCCCC237E254166666666BF7F5741333333332A7E254166666626BD7F574166666666347E254166666646BA7F5741CDCCCCCC397E254133333373B77F574133333333407E2541666666E6B57F574133333333447E25419A999959B57F5741666666664B7E2541666666E6B47F57419A999999587E25419A999979B37F574133333333647E2541000000E0B17F574133333333807E2541CDCCCC8CAD7F5741000000008F7E254133333393AB7F57419A999999A17E254166666646A97F574133333333AA7E25419A9999B9A87F574166666666B37E25419A999959A87F57419A999999B77E25419A999939A87F574100000000BD7E254166666646A87F574166666666CA7E2541CDCCCCECA97F5741CDCCCCCCD17E2541CDCCCC0CAB7F574100000000D47E2541CDCCCCACAB7F57419A999999D47E2541333333F3AE7F574166666666D37E2541333333F3B07F574133333333D07E2541CDCCCC6CB27F5741CDCCCCCCC47E254166666606B67F5741CDCCCCCCBF7E254133333373B77F574133333333BC7E254166666626B87F574100000000B87E254100000040B97F574166666666B07E2541CDCCCC6CB97F57419A999999A97E2541333333B3B97F574166666666A67E254166666606BA7F5741CDCCCCCCA27E25419A999999BA7F57419A9999999C7E254166666686BC7F574133333333997E254133333313BE7F574100000000997E254133333313BF7F5741CDCCCCCC9A7E254100000080C07F574166666666A77E2541CDCCCC8CC27F5741CDCCCCCCAE7E254166666646C37F57419A999999C87E254166666606C57F574100000000F77E2541CDCCCC8CC87F574100000000137F254166666666CA7F574100000000297F2541CDCCCC4CCC7F57419A999999467F254166666666CE7F57419A999999547F2541CDCCCC8CCF7F5741000000005F7F254100000040D07F57419A999999647F254100000060D77F5741CDCCCCCC6C7F25419A999939E47F574166666666737F2541CDCCCC8CF07F574166666666757F2541666666E6F67F574100000000737F2541666666E6F77F57419A9999996E7F2541333333F3F87F57419A9999996A7F2541CDCCCC8CF97F5741CDCCCCCC627F25419A999979FA7F57419A999999607F25419A9999D9FA7F5741000000005C7F254166666646FC7F57419A9999995A7F254100000000FD7F5741333333335A7F254133333393FD7F5741CDCCCCCC5B7F2541333333D3FE7F5741CDCCCCCC5D7F254133333393FF7F5741333333335F7F25419A9999D9FF7F57419A999999627F2541CDCCCC2C00805741CDCCCCCC677F25419A99997900805741CDCCCCCC6D7F2541333333B30080574100000000747F2541000000C000805741CDCCCCCC7D7F2541CDCCCC8C0080574100000000847F2541CDCCCC2C0080574166666666897F254133333393FF7F5741666666668F7F2541CDCCCC8CFE7F57419A999999927F2541CDCCCCCCFD7F57419A999999947F2541333333D3FC7F574100000000977F254133333333FC7F5741666666669F7F2541000000C0F87F574100000000A27F25419A999919F77F574166666666A27F254133333353F67F574166666666A17F2541666666E6F27F57419A9999999E7F25419A999919EF7F5741000000009F7F2541666666A6EC7F5741333333339B7F25419A9999F9E97F5741CDCCCCCC9A7F25419A999999E77F574166666666997F25419A9999B9E67F5741CDCCCCCC987F25419A9999F9E47F574166666666967F254133333333E37F574166666666967F254100000080E07F5741CDCCCCCC947F2541333333B3DE7F574166666666937F254166666646DA7F57419A999999907F2541CDCCCCCCD77F574100000000907F2541CDCCCC4CD57F5741000000008E7F254166666686D37F5741333333338C7F2541666666C6D07F5741CDCCCCCC8B7F25419A9999D9CE7F5741333333338C7F254100000040CD7F57419A9999998E7F25419A9999F9CC7F574100000000927F25419A9999D9CC7F574166666666A57F25419A999999CC7F574100000000BB7F25419A999939CC7F574100000000D07F254100000000CC7F57419A999999D67F25419A9999D9CB7F574100000000DA7F2541666666A6CB7F574166666666DC7F254133333353CB7F574100000000DE7F2541666666E6CA7F574133333333DE7F25419A999959CA7F574166666666DC7F2541666666A6C97F574100000000D87F2541333333B3C87F57419A999999D37F2541CDCCCC2CC87F5741CDCCCCCCCF7F25419A9999F9C77F574166666666C37F254133333373C87F574166666666BD7F254133333393C87F574100000000847F254166666606C97F57419A9999997F7F25419A999939C77F5741666666667E7F254133333353C67F5741000000007C7F254166666686C17F5741CDCCCCCC797F2541666666A6BE7F574100000000797F2541000000C0B97F574133333333807F25419A9999B9B77F5741CDCCCCCC887F2541CDCCCC2CB47F574133333333907F254166666686B27F5741CDCCCCCCA57F254133333393AC7F5741CDCCCCCCBB7F254100000000A77F574100000000D17F2541666666E6A17F574100000000ED7F2541000000A09B7F5741666666661180254133333313947F57419A99999948802541CDCCCC0C897F5741000000006E80254100000060817F5741CDCCCCCC75802541666666E67F7F574166666666798025419A9999F97E7F57419A999999828025419A9999F97C7F57419A999999A980254100000020757F574133333333B280254166666606737F574100000000BD8025419A999919717F574100000000F380254100000000667F5741000000000C81254133333333617F5741CDCCCCCC2D812541CDCCCC0C5B7F574133333333408125419A9999D9577F57410000000058812541666666E6537F574100000000688125419A999979517F57419A9999997C812541333333934E7F57410000000093812541333333934B7F574100000000A481254166666666497F574100000000B4812541000000A0477F5741CDCCCCCCBD812541000000C0467F574166666666D881254133333313447F574133333333F68125419A999979417F57419A999999218225419A9999193E7F57410000000035822541333333D33C7F57410000000047822541CDCCCCCC3B7F57419A99999959822541000000003B7F57416666666670822541000000403A7F5741333333337C822541666666063A7F5741666666668C8225419A9999F9397F57413333333391822541000000E0397F5741333333339B82254100000080397F57419A9999999D82254100000080397F5741CDCCCCCCA3822541333333733A7F574166666666A9822541000000003B7F574133333333AE822541333333533B7F574100000000B08225419A9999593B7F5741CDCCCCCCB2822541666666463B7F574100000000B7822541000000E03A7F5741CDCCCCCCB8822541000000003B7F574100000000BC822541666666C63B7F57419A999999BE822541CDCCCC0C3C7F5741CDCCCCCCC1822541CDCCCC0C3C7F57419A999999CB822541666666A63B7F574100000000CE822541333333B33B7F574100000000D0822541000000E03B7F574133333333D3822541CDCCCC4C3C7F5741CDCCCCCCD4822541CDCCCCAC3C7F574133333333D1822541333333533D7F574133333333CF822541000000003E7F574100000000CB822541CDCCCC8C3E7F57419A999999CB822541000000C03E7F5741CDCCCCCCCD822541666666C63E7F5741CDCCCCCCD38225419A9999393E7F574133333333DB822541666666C63D7F5741CDCCCCCCDE8225419A9999393D7F574100000000EC822541000000C03C7F574166666666F18225419A9999593C7F5741CDCCCCCCF2822541666666263C7F574133333333F3822541CDCCCCEC3B7F57419A999999F2822541CDCCCCCC3B7F574133333333EB822541333333133B7F574133333333E0822541000000603B7F574133333333DE822541333333533B7F574166666666DD822541000000403B7F574133333333DC822541000000E03A7F574166666666DB822541666666063A7F5741CDCCCCCCDB822541CDCCCC6C397F574133333333DD822541000000C0387F57419A999999E282254166666666377F574133333333E982254100000040367F574133333333F282254133333333357F57413333333302832541CDCCCC8C337F5741000000000E8325419A9999F9317F5741666666661683254166666666317F5741333333332C832541666666862F7F5741CDCCCCCC49832541666666462D7F57419A9999995E832541CDCCCCCC2B7F57416666666680832541666666A6297F5741333333339283254100000060287F5741CDCCCCCC9983254100000000287F574100000000A7832541CDCCCC2C277F574100000000B3832541000000A0267F574166666666D583254100000080257F574100000000E283254100000040257F5741CDCCCCCCE283254133333393257F574100000000E5832541CDCCCC0C267F574100000000E8832541CDCCCC4C267F5741CDCCCCCCEA83254166666666267F574166666666EE8325419A999959267F57419A999999F48325419A9999F9257F574166666666F9832541666666C6257F574133333333FE832541000000C0257F574133333333028425419A9999D9257F57410000000005842541CDCCCC0C267F5741333333330784254133333353267F5741666666660684254100000000277F5741000000000784254166666626277F57419A999999088425419A999939277F5741333333330E84254133333333277F57419A99999915842541CDCCCCCC267F5741000000001C842541666666A6267F57419A99999923842541666666C6267F5741666666662C84254133333333277F57419A9999992F84254100000080277F5741CDCCCCCC2E84254166666626287F57419A99999932842541666666C6287F5741666666663084254100000060297F57419A999999308425419A9999B9297F57410000000032842541CDCCCC0C2A7F57419A99999933842541666666262A7F5741666666663C842541666666C6297F57419A99999950842541CDCCCCCC297F5741CDCCCCCC5A842541CDCCCC8C297F57419A9999996084254166666686297F57419A9999996D84254100000000297F5741666666666F842541CDCCCCCC287F5741CDCCCCCC6E842541CDCCCC0C287F5741CDCCCCCC6F842541000000E0277F57419A999999728425419A9999D9277F5741000000007A842541CDCCCC0C287F5741CDCCCCCC7D84254133333313287F5741666666667F842541666666E6277F574100000000818425419A999919277F57413333333383842541CDCCCCCC267F5741000000008884254100000080267F5741333333338C84254166666686267F5741333333339084254133333353267F574133333333938425419A999919267F5741333333339B8425419A999939257F5741CDCCCCCCA484254133333393247F57419A999999A884254133333393247F574100000000AE84254100000020257F57419A999999B484254133333393257F57419A999999BC8425419A9999B9257F574166666666BF842541333333B3257F574133333333C48425419A999979257F574133333333C9842541666666E6247F57419A999999CC842541666666A6247F5741CDCCCCCCD184254166666686247F574166666666D68425419A999999247F5741CDCCCCCCDB842541CDCCCC8C247F574100000000DE842541000000A0247F5741CDCCCCCCDF842541666666C6247F57419A999999E18425419A999959257F574133333333E38425419A999999257F57419A999999E68425419A9999D9257F574100000000EC8425419A999919267F57419A999999F384254133333313267F574166666666008525419A999999257F57419A9999990485254166666686257F57419A99999905852541000000C0257F57419A999999058525419A999979267F57419A9999990685254100000000277F5741CDCCCCCC0C852541000000E0277F5741000000000B852541666666E6287F57419A9999990B85254100000020297F5741666666660C85254133333333297F5741CDCCCCCC1D8525419A9999B9297F57410000000028852541000000202A7F57419A99999938852541000000002A7F5741CDCCCCCC3B852541666666862A7F5741000000003F852541333333B32A7F57413333333343852541CDCCCCCC2A7F57419A9999994A852541000000C02A7F5741CDCCCCCC4C8525419A9999992A7F5741333333334C8525419A9999592A7F574100000000488525419A9999D9297F5741333333334685254133333373297F57419A999999468525419A999939297F57419A999999478525419A999919297F5741000000005F852541CDCCCCAC277F5741CDCCCCCC67852541CDCCCCEC267F5741666666667885254166666646257F5741000000008185254133333393247F5741000000008B852541333333F3237F5741000000009E8525419A9999F9227F57419A999999B385254166666626227F574100000000C985254166666686217F574100000000E185254166666626217F5741333333330B862541666666A6207F5741666666662F86254133333373207F5741666666664C86254166666646207F5741000000005E86254166666686207F5741333333336986254100000000217F5741CDCCCCCC6F86254166666666217F57419A9999998886254100000040237F574166666666978625419A999999247F5741CDCCCCCC9E86254133333373257F57419A999999B6862541666666A6287F574133333333BF862541000000002A7F574100000000C5862541666666062B7F574100000000C7862541666666A62B7F574166666666C78625419A9999392C7F574100000000C68625419A9999F92C7F574166666666C0862541000000C02E7F5741CDCCCCCCBF862541CDCCCC2C2F7F574166666666C0862541000000802F7F574166666666C286254166666606307F574133333333CA86254100000080307F574166666666CF86254133333313317F574166666666D3862541333333B3317F574133333333D4862541333333F3317F574166666666D486254133333393327F574100000000D7862541CDCCCC2C337F574100000000D986254133333353347F57419A999999D986254133333353357F574133333333DA862541CDCCCC8C357F5741CDCCCCCCDC862541000000C0357F5741CDCCCCCCDE862541000000C0357F574100000000E2862541CDCCCC8C357F574100000000E6862541666666C6347F574133333333E88625419A999979347F574133333333EA862541CDCCCCCC337F574166666666ED86254133333393317F574166666666EF86254100000020317F574133333333F186254100000000317F574133333333F386254166666606317F574133333333F5862541CDCCCC4C317F574100000000F6862541000000C0317F574166666666F586254133333353327F574100000000F6862541333333B3327F5741CDCCCCCCF986254166666606337F57419A999999FE86254133333333337F57419A999999008725419A999919337F57416666666601872541333333F3327F5741666666660387254100000040317F5741666666660487254166666626317F5741333333330887254100000000317F5741333333330D8725419A9999F9307F57419A9999991087254133333313317F57419A9999991287254133333353317F5741CDCCCCCC15872541CDCCCC8C327F574133333333198725419A999959337F5741CDCCCCCC1D872541CDCCCC0C347F57419A9999991F872541CDCCCC2C347F5741CDCCCCCC2087254100000020347F5741CDCCCCCC21872541666666E6337F57413333333323872541333333D3327F57419A999999248725419A999979327F57419A9999992787254166666666327F57419A9999992D87254133333373327F57416666666634872541000000A0327F57416666666639872541333333D3327F5741333333333E872541CDCCCC2C337F57416666666644872541333333F3337F5741666666664587254166666686347F57416666666647872541CDCCCC0C357F5741666666664A8725419A999999357F57419A9999994C8725419A9999B9357F5741333333334E87254100000060357F5741CDCCCCCC4F872541666666A6347F57419A99999951872541CDCCCC6C347F57419A999999558725419A999959347F5741000000006387254166666686347F57419A9999996687254166666666347F574133333333688725419A999919347F574100000000698725419A999959337F5741666666666B8725419A999919337F574100000000708725419A9999F9327F574166666666808725419A999939337F57419A9999998887254166666626337F5741CDCCCCCC92872541CDCCCCAC327F5741666666669A87254133333333327F5741CDCCCCCCA7872541333333D3307F57419A999999AF87254133333353307F57419A999999B7872541CDCCCCEC2F7F574100000000C9872541666666662F7F574100000000D7872541666666262F7F5741CDCCCCCCE0872541333333132F7F5741CDCCCCCCE6872541666666262F7F574100000000EC872541333333532F7F5741CDCCCCCCF18725419A9999B92F7F574100000000F487254166666606307F57419A999999F587254100000020307F574100000000F98725419A999919307F574133333333FE872541000000E02F7F57413333333300882541CDCCCCEC2F7F5741666666660188254100000020307F5741CDCCCCCC01882541CDCCCC2C317F5741333333330388254166666666317F57419A9999990588254133333393317F57416666666608882541CDCCCCAC317F5741000000000D882541333333B3317F5741CDCCCCCC0F8825419A999999317F5741666666661288254100000060317F5741CDCCCCCC15882541CDCCCC4C317F57413333333324882541CDCCCC0C327F5741333333333C88254100000020337F57419A99999941882541CDCCCC6C337F57416666666644882541333333B3337F57410000000045882541333333F3337F57419A9999994388254166666686347F57419A999999438825419A9999D9347F5741333333334588254133333373357F57419A9999994788254166666606367F5741CDCCCCCC48882541CDCCCC2C367F5741666666664B88254166666646367F57416666666653882541CDCCCC0C367F5741CDCCCCCC56882541CDCCCC4C367F574166666666598825419A9999B9367F57419A9999995A882541333333D3367F5741666666665F882541666666A6367F5741000000006C882541CDCCCCEC357F5741CDCCCCCC6F882541CDCCCCCC357F5741CDCCCCCC95882541CDCCCC2C367F574166666666A188254166666626367F574100000000AD88254166666606367F574133333333B1882541000000E0357F574100000000B78825419A999979357F574166666666BA88254166666606357F574166666666BD882541CDCCCC4C347F57419A999999CF882541CDCCCC6C327F57419A999999DF882541000000A0307F5741CDCCCCCCE8882541333333D32F7F574100000000F6882541666666E62E7F57419A999999FF882541000000602E7F57419A999999098925419A9999F92D7F57410000000011892541333333D32D7F5741333333331F892541CDCCCC4C2D7F5741CDCCCCCC23892541333333332D7F57410000000027892541333333332D7F5741CDCCCCCC28892541CDCCCC4C2D7F57419A99999931892541000000E02D7F57410000000035892541CDCCCC4C2E7F5741CDCCCCCC36892541333333D32E7F57413333333338892541666666C62F7F57419A9999993989254133333313307F5741666666663E89254100000080307F57419A9999994089254133333393307F574166666666458925419A999999307F57419A9999994E89254133333333307F5741CDCCCCCC508925419A9999F92F7F574133333333528925419A9999992F7F57413333333352892541CDCCCC4C2F7F57410000000051892541333333F32E7F5741CDCCCCCC4E892541000000C02E7F5741CDCCCCCC44892541000000202E7F57413333333342892541000000A02D7F57413333333342892541333333332D7F5741CDCCCCCC43892541CDCCCC8C2C7F57413333333346892541666666262C7F5741CDCCCCCC49892541666666C62B7F57416666666656892541666666062B7F57419A9999995B892541333333D32A7F5741666666665F892541000000C02A7F574133333333628925419A9999D92A7F57410000000070892541CDCCCC4C2C7F5741CDCCCCCC6F892541666666662C7F57419A9999996B892541CDCCCC8C2C7F5741333333336B8925419A9999B92C7F5741000000006D892541CDCCCCEC2C7F57410000000073892541CDCCCC2C2D7F57419A99999976892541333333332D7F57419A99999977892541666666E62C7F57410000000078892541333333332C7F5741000000007D892541CDCCCCEC2A7F5741000000008089254133333393297F574100000000828925419A999919297F5741666666668589254100000000297F5741666666668B89254166666626297F57416666666695892541333333932A7F57419A99999998892541CDCCCCCC2A7F5741333333339C892541666666E62A7F5741CDCCCCCCA08925419A9999D92A7F574100000000A4892541333333B32A7F574166666666AE89254166666686297F57419A999999BA892541CDCCCCAC287F57419A999999C489254133333313287F5741CDCCCCCCCA892541333333F3277F574133333333D3892541CDCCCCEC277F57419A999999D789254100000000287F574133333333DF892541333333F3277F574166666666E7892541CDCCCC8C277F5741CDCCCCCCEB892541CDCCCC6C277F57419A999999F38925419A999999277F57419A999999FA89254100000000287F574100000000FD8925419A999939287F574100000000FE892541CDCCCC6C287F574100000000FD89254166666606297F57419A999999FD892541CDCCCC2C297F574100000000038A2541CDCCCCAC297F57419A9999990A8A2541CDCCCC8C2A7F574166666666118A2541000000E02A7F5741333333331C8A2541000000202B7F574133333333208A2541CDCCCC0C2B7F574166666666228A2541666666E62A7F574166666666348A254133333313297F5741000000003C8A2541CDCCCC6C287F574166666666428A254166666606287F574166666666478A2541666666E6277F5741CDCCCCCC4C8A254133333313287F574133333333548A2541000000A0287F5741CDCCCCCC588A25419A9999D9287F57419A9999995E8A2541CDCCCCEC287F574133333333658A25419A9999D9287F574133333333748A254133333373287F57419A9999997A8A25419A999959287F574100000000808A25419A999959287F5741CDCCCCCC888A254100000080287F5741666666668D8A25419A999979287F574166666666928A25419A999959287F574166666666A38A2541666666A6277F57419A999999A88A254133333393277F5741CDCCCCCCC48A25419A9999B9277F574166666666D18A2541666666E6277F574100000000DB8A254166666626287F57419A999999DD8A254100000020287F574133333333DE8A2541CDCCCCEC277F57419A999999DD8A2541000000C0277F574166666666D18A25419A999919277F574166666666D18A254166666606277F574166666666D28A2541CDCCCCEC267F5741CDCCCCCCD58A2541000000E0267F574133333333DE8A25419A999919277F5741CDCCCCCCF38A2541333333D3277F57419A999999008B254100000020287F5741CDCCCCCC118B254100000060287F5741000000001E8B25419A999919287F5741CDCCCCCC258B25419A9999D9277F5741CDCCCCCC268B2541CDCCCCCC277F574100000000288B254166666686277F574166666666298B254166666686267F574133333333288B254133333313267F574166666666288B2541333333B3257F574100000000268B254166666666257F574100000000268B25419A999939257F5741333333332A8B2541666666E6237F5741666666662D8B2541CDCCCC8C227F574133333333308B25419A9999F9217F574166666666358B254133333393217F574166666666388B254100000080217F57419A9999993A8B254133333393217F5741000000003F8B254133333313227F574133333333428B2541CDCCCC4C227F574100000000478B254100000060227F5741000000004A8B25419A999959227F574166666666518B2541CDCCCC0C227F5741CDCCCCCC588B2541666666A6217F5741333333335C8B254100000060217F5741000000005C8B254100000020217F5741CDCCCCCC588B2541666666E6207F5741CDCCCCCC4A8B25419A9999B9207F57419A999999468B25419A999999207F5741CDCCCCCC458B254100000080207F5741CDCCCCCC458B254133333353207F574133333333498B254100000020207F574100000000558B254133333333207F574166666666588B25419A9999F91F7F5741333333335A8B2541333333F31F7F574166666666618B25419A999979207F5741CDCCCCCC648B254166666686207F57419A999999638B254133333333207F57419A9999995E8B25419A9999991F7F574166666666578B2541333333131F7F5741666666664A8B2541666666A61E7F574166666666368B2541333333731E7F574100000000338B2541333333531E7F5741CDCCCCCC308B2541333333131E7F574100000000308B25419A9999B91D7F5741CDCCCCCC2F8B25419A9999191D7F5741CDCCCCCC308B2541333333931C7F574100000000328B25419A9999791C7F5741333333333F8B25419A9999B91C7F574133333333418B2541000000C01C7F5741CDCCCCCC428B25419A9999991C7F57419A999999428B2541CDCCCC6C1C7F574166666666418B2541666666461C7F5741CDCCCCCC378B2541CDCCCCEC1B7F574100000000358B2541666666C61B7F5741CDCCCCCC328B2541333333931B7F574166666666318B2541CDCCCC4C1B7F57419A999999308B2541333333F31A7F574166666666308B2541000000001A7F57419A999999328B254133333313187F5741CDCCCCCC348B254100000020177F574100000000388B2541CDCCCC6C167F5741CDCCCCCC3B8B254166666606167F5741666666663D8B25419A9999B9157F57419A999999408B2541CDCCCC6C147F574133333333428B254133333313147F574100000000478B254133333393137F5741333333334C8B25419A999939137F574166666666518B254166666626137F5741CDCCCCCC538B254100000040137F574166666666588B254166666686137F5741666666665F8B2541CDCCCC2C147F574100000000668B25419A999979147F5741666666667C8B25419A999999147F574166666666868B2541000000C0147F5741CDCCCCCCA28B254133333393157F574166666666B98B25419A999999157F5741CDCCCCCCB98B25419A999979157F574166666666B68B254100000000157F574166666666A98B2541666666C6137F5741CDCCCCCCA48B25419A999939137F57419A999999A38B254166666686127F57419A999999A38B254100000000127F574166666666A48B2541666666A6107F5741CDCCCCCCA68B25419A9999790F7F57419A999999A88B2541333333F30E7F574100000000B18B2541000000200D7F574100000000B68B25419A9999590C7F574166666666C08B25419A9999F90A7F574166666666C38B2541333333730A7F574133333333C58B2541333333330A7F5741CDCCCCCCC88B25419A9999F9097F574100000000CE8B25419A9999B9097F574133333333DC8B2541CDCCCC4C097F574133333333E28B254166666626097F574133333333EA8B254100000020097F574100000000F18B254100000060097F57419A999999F48B2541000000A0097F574100000000F78B2541333333F3097F5741CDCCCCCCF88B25419A9999790A7F5741CDCCCCCCFA8B25419A9999B90A7F574100000000FF8B2541666666E60A7F574166666666048C2541333333F30A7F5741000000000C8C2541000000C00A7F574100000000178C2541CDCCCC2C0A7F5741333333331B8C2541333333130A7F574166666666218C2541333333130A7F574133333333258C2541000000400A7F574133333333278C25419A9999790A7F57419A9999992D8C2541666666860B7F5741CDCCCCCC328C2541666666260C7F57419A999999388C25419A9999990C7F5741CDCCCCCC3D8C2541CDCCCCCC0C7F5741CDCCCCCC428C2541CDCCCCAC0C7F57419A999999458C25419A9999790C7F5741333333334E8C2541666666660B7F5741CDCCCCCC538C2541000000E00A7F574166666666598C2541000000A00A7F574133333333698C25419A9999590A7F5741333333336F8C2541000000200A7F574100000000718C2541000000000A7F574133333333738C2541CDCCCCAC097F5741CDCCCCCC738C254133333353097F57419A999999738C254100000020097F5741CDCCCCCC708C2541333333B3087F5741CDCCCCCC6B8C254100000040087F5741000000005E8C2541CDCCCC0C087F5741666666664F8C2541333333F3077F5741CDCCCCCC4C8C25419A999979077F574100000000528C254166666646077F574100000000598C254133333333077F5741CDCCCCCC6D8C254133333373067F574166666666868C2541CDCCCC4C047F574100000000898C2541000000E0037F5741CDCCCCCC898C254133333353037F5741333333338A8C254100000040027F57419A999999888C2541000000E0017F574100000000888C254100000020017F5741000000008E8C25419A9999B9017F574166666666958C2541333333D3017F57419A999999978C2541666666C6017F57419A999999998C254133333393017F5741666666669B8C25419A999939017F5741333333339D8C2541666666A6007F5741000000009E8C25419A9999B9FF7E57419A9999999D8C254166666646FF7E5741000000009B8C2541CDCCCCECFD7E57419A999999928C2541CDCCCC2CFD7E5741CDCCCCCC938C25419A999959FC7E57419A9999999B8C2541CDCCCC8CFC7E57419A9999999F8C2541CDCCCCECFA7E57419A999999A68C2541000000E0F97E57419A999999AD8C25419A999939F97E574100000000BE8C2541666666A6F87E5741CDCCCCCCF58C254100000000F77E574100000000118D2541CDCCCC4CF67E574166666666268D2541000000E0F57E5741CDCCCCCC458D25419A999979F57E574133333333678D25419A999939F57E574133333333798D254133333333F57E5741000000008D8D254166666666F57E57419A999999A68D2541000000E0F57E5741CDCCCCCCB78D254166666666F67E574100000000A28D2541333333B3F17E5741CDCCCCCC8B8D2541333333B3ED7E5741CDCCCCCC738D25419A999979EA7E5741666666666D8D2541CDCCCCCCE97E574100000000668D2541000000E0E87E57419A9999995E8D25419A999919E87E574133333333558D254166666686E77E574100000000C78C254100000040DD7E574100000000208C2541CDCCCCECCD7E574166666666F18B25419A999999CA7E574166666666CA8B25419A999939C97E5741CDCCCCCC7E8B2541CDCCCC8CCB7E57419A999999E48A2541CDCCCCECD87E5741CDCCCCCCDD8A254133333353D97E5741CDCCCCCCC18A2541333333B3D97E5741CDCCCCCCA18A254100000020DA7E574100000000798A254133333353DA7E574166666666338A2541CDCCCCACDA7E5741CDCCCCCC198A2541666666A6DB7E574100000000148A2541333333B3DB7E5741CDCCCCCC108A2541333333B3DB7E574133333333068A2541000000C0DB7E57419A999999FA8925419A9999F9DB7E57419A999999DD8925419A999959DC7E5741333333338A892541666666E6DD7E5741000000006E892541666666A6DF7E5741CDCCCCCC46892541CDCCCC2CE27E5741333333332289254133333353E47E57419A999999DE882541666666E6E87E57419A999999CB882541CDCCCC2CEB7E5741333333339F882541333333B3EE7E5741000000009C882541000000E0EE7E5741333333339288254166666606EF7E57419A999999888825419A999919EF7E5741CDCCCCCC7E88254166666606EF7E5741333333337288254133333353EE7E5741000000006988254133333393ED7E5741CDCCCCCC5D882541666666A6EB7E57416666666657882541CDCCCC6CEA7E57413333333328882541000000C0EE7E5741CDCCCCCCE587254133333333F47E5741CDCCCCCC98872541CDCCCC0CFA7E5741CDCCCCCC4B8725419A9999B9FE7E57410000000029872541000000C0007F5741CDCCCCCC16872541666666C6017F57419A999999C5862541666666E6057F57419A99999988862541CDCCCC6C087F57413333333336862541333333530B7F574133333333E5852541666666E60D7F5741333333339B852541000000A00F7F5741CDCCCCCC4785254100000020117F57419A999999FF842541333333D3117F574100000000BB84254133333313127F57419A99999959842541333333F3117F5741000000001084254133333373117F574133333333A683254166666646107F5741333333332A832541000000E00E7F57413333333392812541000000600A7F5741000000001E81254100000080097F57419A9999998C8025419A999939097F5741333333330B8025419A9999F9097F574100000000877F2541666666460B7F574133333333097F25419A9999590D7F574133333333B47E2541000000200F7F5741CDCCCCCC937E25419A9999B90F7F5741CDCCCCCC117E254166666666127F5741CDCCCCCC857D2541CDCCCC6C157F5741CDCCCCCC0F7D2541333333D3177F574100000000F57C254166666646187F5741CDCCCCCCEB7C254133333353197F5741CDCCCCCCCE7C2541666666C61C7F574166666666C67C2541CDCCCCCC1D7F574166666666B17C2541000000A01F7F57419A999999A17C2541666666A6207F5741666666669A7C25419A999919217F57419A9999996D7C254133333313237F5741CDCCCCCC347C2541CDCCCC2C257F574100000000FE7B254166666626277F574166666666E87B2541CDCCCC0C287F574166666666D87B2541000000C0287F57419A999999AD7B2541CDCCCC2C2B7F574100000000A77B2541333333932B7F5741666666669A7B25419A9999592C7F574100000000907B2541666666062D7F574133333333827B2541CDCCCCEC2D7F574166666666797B25419A9999792E7F57419A999999577B254133333393307F574166666666207B2541CDCCCC0C347F574133333333E67A2541CDCCCCCC377F574166666666607A254100000060407F574100000000377A254166666606437F57419A999999227A2541CDCCCC4C447F5741666666660C7A25419A9999B9457F5741CDCCCCCCB3792541333333734B7F574133333333927925419A9999994D7F57419A999999277925419A999959547F57419A99999910792541333333D3557F574133333333CA782541666666465A7F574166666666B17825419A9999D95B7F57419A999999AB782541333333335C7F57419A99999988782541333333735E7F5741CDCCCCCC287825419A999999647F57416666666624782541000000E0647F57419A9999991E78254166666646657F574133333333EE7725419A999959687F5741333333338E772541333333736E7F5741000000005E772541CDCCCC8C717F574100000000D5762541CDCCCC4C7A7F574133333333C9762541CDCCCC0C7B7F57410000000030762541666666E6847F57419A999999F6752541CDCCCC8C887F574100000000EC75254100000040897F57419A9999995A75254166666686927F5741666666663F75254166666646947F57419A999999F374254100000000997F57419A999999C0742541333333539D7F5741000000009974254166666686A07F5741000000008174254133333373A27F5741CDCCCCCC777425419A999959A37F574100000000707425419A999999A47F5741666666666F74254166666626A57F5741666666666E742541666666A6A67F5741333333337674254100000000A97F57419A9999997674254100000080AA7F57419A9999997774254166666606AC7F5741000000007A742541CDCCCCACAD7F57419A9999997D74254133333373AF7F5741CDCCCCCC8274254133333353B17F57413333333389742541CDCCCC4CB37F5741666666669174254166666626B57F5741666666669A7425419A9999F9B67F574133333333A4742541666666C6B87F57419A999999AE742541CDCCCC8CBA7F574166666666B97425419A999959BC7F574166666666C474254166666606BE7F574133333333D074254133333393BF7F574166666666DC74254100000000C17F574166666666E9742541CDCCCC0CC27F57419A999999F674254166666626C37F5741666666660475254166666606C47F57410000000012752541000000E0C47F5741000000001F752541666666E6C57F5741333333332E7525419A999999C67F5741666666663D75254133333333C77F5741666666664D752541333333D3C77F5741666666665E75254100000040C87F5741CDCCCCCC6F75254166666686C87F5741CDCCCCCC817525419A999999C87F5741333333339375254166666686C87F57419A999999A375254100000060C87F574100000000B275254166666626C87F57419A999999BE752541CDCCCCECC77F574100000000C8752541000000C0C77F574166666666D975254100000080C77F574133333333F5752541333333D3C67F5741666666661C76254166666626C67F5741CDCCCCCC4B762541CDCCCC0CC57F5741CDCCCCCC65762541000000A0C47F574100000000807625419A999919C47F5741CDCCCCCC8C762541000000E0C37F57413333333399762541666666A6C37F5741CDCCCCCCA476254166666686C37F5741CDCCCCCCAF76254133333373C37F5741CDCCCCCCB976254133333353C37F57419A999999C8762541CDCCCC2CC37F574133333333EE7625419A999999C27F57413333333336772541000000E0C17F57410000000077772541CDCCCC6CC17F5741333333337C772541333333D3C37F5741CDCCCCCC85772541000000E0C37F5741CDCCCCCC8D77254100000040C47F5741000000009377254133333313C57F57419A999999967725419A999919C67F5741CDCCCCCC977725419A999919C77F5741000000009677254133333313C87F5741CDCCCCCC9177254133333313C97F5741CDCCCCCC8A772541000000A0C97F57419A999999807725419A999919CA7F5741333333337577254166666626CA7F574166666666727725419A9999B9CC7F5741333333336D772541000000C0CE7F5741000000006677254166666666D07F5741CDCCCCCC5477254166666666D37F5741CDCCCCCC13772541CDCCCC6CDE7F5741666666660377254166666646E17F574133333333E5762541666666E6E57F574100000000BB76254133333333EB7F574100000000B0762541CDCCCC8CEC7F5741CDCCCCCCA5762541CDCCCCACED7F5741CDCCCCCC9D762541000000A0EE7F5741CDCCCCCC6C762541666666E6F47F574100000000507625419A999999F87F5741000000004D7625419A9999F9F87F5741000000001E76254100000080FE7F57410000000014762541666666A6FF7F57419A9999990C76254166666686008057413333333301762541000000400180574133333333F47525419A9999190280574100000000CE752541CDCCCC4C0580574166666666B57525419A999979078057413333333363752541333333B30E805741666666664B752541CDCCCCCC10805741666666662D7525419A9999791380574133333333117525419A9999F91580574166666666FF742541666666C6178057419A999999DE742541CDCCCC0C1C805741CDCCCCCCD1742541CDCCCC8C1D80574166666666B97425413333333320805741CDCCCCCCBA742541333333F32080574100000000BA7425419A9999B92180574133333333B7742541333333932280574133333333B3742541CDCCCC0C23805741CDCCCCCCAD74254133333353238057419A999999A7742541000000602380574166666666A17425416666662623805741333333339C742541666666A6228057416666666682742541333333D3248057419A9999996D742541666666C6268057416666666659742541000000A0288057416666666647742541000000C0298057413333333333742541000000C02B8057419A99999947742541CDCCCCAC2D8057416666666677742541333333133480574166666666AD742541666666463B805741CDCCCCCCC9742541CDCCCC6C3E8057413333333310742541CDCCCC6C5480574166666666F7732541CDCCCC6C5C80574133333333F5732541666666E65C805741CDCCCCCCA9732541CDCCCC8C74805741666666668A732541333333137D8057410000000006742541000000808480574166666666267425416666666686805741666666669F742541000000A08D80574133333333D37425419A9999B99080574133333333D8742541000000009180574133333333D4742541CDCCCCEC9480574166666666D17425419A9999999980574100000000D27425419A9999399C80574100000000D7742541666666869D80574133333333DD742541333333F39D805741CDCCCCCCE5742541333333539E80574133333333F8742541333333F39E8057410000000001752541000000609F805741000000001E752541000000C0A08057413333333330752541CDCCCC2CA2805741333333333875254166666606A3805741CDCCCCCC30752541666666A6A48057410000000029752541333333B3A98057413333333327752541CDCCCC2CAD8057419A99999920752541CDCCCC2CB9805741333333331E7525419A999979BD805741666666661C752541CDCCCCACC08057419A999999FA7425419A9999B9C080574166666666FE74254100000060D680574100000000477525419A999959D9805741000000007B752541CDCCCC4CD9805741CDCCCCCCFD75254133333333D78057419A99999930762541CDCCCC6CD6805741000000002D762541CDCCCC2CDB805741333333331376254133333333E880574133333333E9752541000000A0FE8057419A999999DB752541666666E60381574133333333C27525419A99997903815741333333334B752541000000C001815741CDCCCCCC48752541CDCCCC8C0381574100000000467525419A9999D9048157416666666639752541CDCCCCCC078157419A99999932752541000000400A815741CDCCCCCC21752541333333530F815741666666662375254166666606108157416666666629752541CDCCCC4C108157416666666641752541666666861E8157416666666619752541333333131F81574166666666DF742541333333132381574133333333BD742541333333932581574133333333A1742541CDCCCC4C2981574133333333A1742541333333932D815741333333336774254133333393328157419A9999994E742541CDCCCC2C35815741333333334E74254100000020358157416666666602742541000000C0248157419A999999E6732541666666861E8157413333333396732541333333730C815741CDCCCCCC5C732541CDCCCCAC028157416666666642732541333333B3FE805741CDCCCCCC3473254100000060FD805741CDCCCCCC32732541CDCCCC2CFD805741333333332F732541333333F3FC8057419A99999928732541666666A6FC8057419A9999992173254166666666FC8057419A9999991B73254133333333FC805741CDCCCCCC0E73254100000000FC8057413333333307732541666666E6FB8057419A999999FA722541666666E6FB80574166666666E772254133333313FC80574166666666BB722541CDCCCCCCFC8057419A999999A572254166666686FD805741333333339A72254133333353FE8057419A9999999772254166666686FE805741000000008B722541666666E6FF805741CDCCCCCC7F722541CDCCCCAC018157419A999999767225419A999919038157419A9999996D722541CDCCCC0C048157416666666669722541CDCCCC4C048157413333333362722541666666A604815741333333335872254100000000058157419A9999994D722541CDCCCC4C058157419A9999993E72254133333373058157419A9999992C7225416666666605815741666666661872254166666606058157419A999999B17125416666662601815741333333338671254166666666FF8057419A9999996F7125419A999959FE8057410000000014702541000000001C81574100000000EA6F2541666666C61E81574100000000D66F2541666666062181574100000000C86F2541666666C62381574100000000C06F2541000000002781574133333333B66F2541000000002B8157419A999999AD6F2541CDCCCCEC2B81574133333333A06F25419A9999592D815741CDCCCCCC9C6F2541000000A02D815741CDCCCCCC686E25416666660645815741CDCCCCCC016E2541333333D32B81574100000000FD6D2541000000E02A81574166666666F46D2541000000E02981574100000000E76D2541666666C62881574100000000E06D2541333333532881574166666666D46D25410000006028815741CDCCCCCCC56D2541000000802981574133333333B96D2541333333B32A81574100000000B46D2541666666062C81574133333333A76D2541666666A62E8157419A9999998B6D25419A9999793381574133333333566D25419A9999D93A815741CDCCCCCC396D2541CDCCCC2C3F81574166666666056D2541333333134781574166666666E76C2541000000204D8157419A999999DF6C25419A9999594F81574100000000DB6C2541333333335181574133333333D96C2541333333D3528157419A999999D86C2541CDCCCCAC54815741CDCCCCCCD86C25410000000056815741CDCCCCCCD46C25416666664657815741CDCCCCCCCC6C2541CDCCCC4C5881574133333333C26C25419A9999D958815741CDCCCCCCB96C2541666666C65981574100000000B26C2541666666C65A81574133333333AA6C2541333333135C815741666666669A6C2541666666C65D81574133333333986C2541CDCCCC4C5E8157419A999999916C2541333333536081574100000000886C2541CDCCCC4C6381574133333333666C2541666666066C815741000000005E6C2541000000206E8157419A9999994E6C254100000020728157419A999999146C2541666666067F8157419A999999F96B2541CDCCCC0C8481574166666666E76B25419A9999798781574133333333D56B2541000000E08A81574166666666D36B25419A9999398B81574166666666C76B2541CDCCCC0C8D81574100000000C76B25419A9999198D81574166666666556B2541333333F39A8157419A999999536B2541333333339B81574133333333356B25419A9999599F81574133333333296B254166666606A181574166666666FB6A2541CDCCCC0C9F81574100000000C36A2541CDCCCC0C9C8157419A999999986A2541CDCCCC0C99815741CDCCCCCC676A2541333333B395815741CDCCCCCCE0692541000000408B81574133333333D46925419A9999F9898157419A999999B26925416666668686815741CDCCCCCC966925419A9999198481574100000000746925413333331381815741CDCCCCCC44692541000000E07D8157419A9999991C692541000000C07B8157419A9999990F692541CDCCCC0C7B8157410000000000692541000000A07A81574133333333BC682541CDCCCCAC7881574100000000A3682541CDCCCC8C77815741CDCCCCCC8768254133333393758157416666666647682541000000C06F8157416666666610682541CDCCCCAC6B8157419A999999C86625416666666643815741CDCCCCCCC4662541000000E041815741CDCCCCCCB9662541000000E03E8157410000000097662541666666E634815741CDCCCCCC7C662541333333932E8157413333333366662541666666C6298157413333333365662541333333F3298157413333333352662541CDCCCC6C2D815741CDCCCCCC13662541666666C63881574133333333F6652541666666263E81574100000000AB6525419A9999394B815741CDCCCCCC9A652541CDCCCC6C4E815741333333338E65254133333313518157419A99999983652541333333B353815741666666668065254133333313558157419A9999997E652541CDCCCC8C568157419A9999997F652541666666E65881574133333333856525419A9999F9598157419A999999896525419A9999995B815741333333338A652541CDCCCC0C5D8157410000000088652541666666865E8157419A99999981652541666666066081574100000000796525419A99991961815741666666666F652541666666C661815741CDCCCCCC626525416666664662815741000000005865254166666646628157419A9999994D65254100000020628157419A99999944652541000000A061815741333333333D652541000000E060815741CDCCCCCC286525419A99993963815741000000001A6525416666660665815741666666660D652541666666C66681574100000000F56425419A9999B96A815741CDCCCCCCAE642541000000407781574166666666B363254133333333A48157419A999999A863254100000020A681574133333333A1632541CDCCCC6CA78157410000000093632541333333F3A9815741666666661D632541000000A0BE815741CDCCCCCC0E6325419A999979C1815741CDCCCCCCE56225419A999999C9815741CDCCCCCCD8622541CDCCCC8CCD815741CDCCCCCCD2622541000000A0CF81574133333333D16225419A9999F9D0815741CDCCCCCCCF62254133333393D28157419A999999D162254166666606D381574133333333D5622541000000C0D481574166666666D5622541CDCCCC6CD6815741CDCCCCCCD162254100000020D8815741CDCCCCCCCB62254166666666D981574133333333C26225419A9999D9DA81574100000000B7622541CDCCCCACDB8157419A999999AA62254133333333DC815741000000009D6225419A999959DC815741333333339762254100000040DC815741666666668F62254100000020DC815741666666668562254133333393DB815741000000007B6225419A9999B9DA8157410000000073622541CDCCCC8CD9815741666666667262254166666686DB81574100000000706225419A9999D9DC815741666666666B622541666666E6DD8157419A99999957622541CDCCCCACE1815741CDCCCCCC51622541333333B3E281574133333333176225419A999919ED81574166666666EA612541CDCCCC0CF58157419A999999CD61254166666686FA81574100000000A96125419A9999590182574133333333836125410000008008825741000000006E612541CDCCCC6C0B8257416666666663612541333333530D8257416666666649612541333333F3118257419A9999992F612541CDCCCC2C178257419A9999992661254100000000198257419A99999923612541666666661A825741333333331F612541666666261C8257419A9999991A612541000000801E825741CDCCCCCC18612541333333732082574133333333186125419A999919228257413333333319612541000000A0238257419A9999991B61254100000040258257419A9999991F612541CDCCCC4C27825741000000002561254100000040298257410000000031612541000000A02C8257413333333338612541666666C62E82574166666666526125410000002036825741CDCCCCCC5F6125419A9999193A8257410000000063612541000000603B825741CDCCCCCC64612541CDCCCC0C3D825741333333335F6125413333331340825741666666665A612541000000A0418257419A9999995461254100000000438257419A9999994B61254133333373448257410000000045612541CDCCCC8C448257413333333335612541CDCCCC6C458257410000000029612541666666C6468257419A99999918612541000000E0468257413333333306612541666666E64682574166666666EA6025413333331346825741000000007D602541666666663F825741000000006C602541CDCCCCEC3D8257413333333365602541000000A03C82574166666666626025419A9999193C8257419A9999995E602541000000A0398257416666666664602541CDCCCCCC348257410000000071602541666666A62D8257410000000081602541333333F32182574166666666826025410000004021825741CDCCCCCC82602541CDCCCC2C2182574166666666856025419A9999D91F82574133333333A1602541333333D31282574166666666AB602541CDCCCCCC0A82574166666666B26025419A9999590582574133333333BD60254166666686F98157419A999999C0602541333333B3E981574166666666C36025419A999979DE81574166666666C3602541CDCCCCACD28157419A999999C1602541CDCCCC6CC18157419A999999C1602541666666E6AD8157419A999999C0602541333333939A8157419A999999C06025419A9999398B81574133333333BD602541666666066581574100000000BC602541CDCCCC4C5A81574166666666BC602541000000C04881574133333333B9602541000000C02F8157419A999999B86025419A9999392881574100000000B8602541333333731E81574100000000B8602541CDCCCCEC1781574166666666B76025419A9999790F81574133333333B7602541666666E60B815741CDCCCCCCB6602541333333530681574133333333B66025419A999999FC80574166666666B560254100000000EF8057419A999999B4602541CDCCCCACDD80574133333333B460254100000040DB805741CDCCCCCCB4602541333333D3D58057419A999999B460254100000040D58057419A999999B5602541CDCCCC4CCD80574166666666B660254166666666CA80574166666666B8602541666666A6C280574133333333BD60254133333313BA8057419A999999C360254100000020B280574166666666CB602541CDCCCCCCAA80574166666666D5602541666666C6A380574166666666DD602541CDCCCCEC9D805741CDCCCCCCF8602541000000E08E805741CDCCCCCC0F612541333333D384805741666666661461254100000020838057419A999999336125419A99997977805741CDCCCCCC54612541CDCCCC0C6D8057419A99999976612541000000C063805741CDCCCCCCAD612541000000205680574166666666E6612541000000404A805741CDCCCCCC0B62254100000020438057416666666639622541333333933B8057413333333381622541000000E02F8057419A999999BD6225419A9999B9268057419A99999902632541000000401D8057416666666609632541666666861C80574100000000186325419A9999F91A805741333333331C632541CDCCCC6C1A805741CDCCCCCC2C6325410000006018805741CDCCCCCC31632541333333D317805741000000004C6325419A9999F914805741000000005F632541000000E01280574166666666686325419A9999D911805741666666666B6325416666668611805741CDCCCCCC83632541333333F30E80574166666666906325419A9999990D805741CDCCCCCC976325419A9999D90C8057419A999999AF632541000000600A8057410000000002642541333333D3028057416666666657642541666666E6FB7F574133333333B7642541333333D3F47F5741CDCCCCCC4B65254166666646EB7F5741666666664C65254100000040EB7F574166666666C665254100000060E47F574133333333E3662541333333D3D47F574100000000F6662541333333D3D37F574166666666FF66254133333353D37F5741333333330067254166666646D37F57413333333309672541CDCCCCCCD27F5741000000004D672541CDCCCC2CCF7F5741666666663068254133333313C37F5741333333331E692541CDCCCC0CB67F574133333333286A2541333333B3A77F57419A999999106B2541CDCCCC0C9B7F5741CDCCCCCC1A6B2541666666869A7F574100000000206B2541000000409A7F5741666666665E6C2541000000E0887F57419A999999666C2541CDCCCC6C887F5741000000005C6D25419A9999397B7F5741666666663F6E25419A9999D96E7F5741CDCCCCCC096F2541CDCCCCEC637F574133333333E06F254133333373587F5741666666661F702541333333F3547F5741333333336B702541000000C0507F574133333333B9702541000000A04C7F57419A99999904712541CDCCCC8C487F57419A9999996E712541CDCCCCCC427F5741CDCCCCCCA9712541CDCCCC8C3F7F574166666666B3712541666666063F7F57419A999999C2712541333333333E7F57419A999999047225419A9999993A7F5741CDCCCCCC25722541333333D3387F5741666666665F722541333333D3357F5741CDCCCCCCA7722541CDCCCC6C327F574100000000DE72254133333313307F574166666666FC722541666666C62E7F574166666666377325419A9999992C7F5741000000005C7325419A9999392B7F574100000000F0732541666666E6267F5741CDCCCCCC667425419A999999247F574133333333BB74254166666686237F5741000000001A752541333333D3227F57419A9999998B7525419A999999227F5741CDCCCCCCE375254133333353227F574100000000347625419A999919227F57419A99999974762541CDCCCCCC217F574133333333C5762541666666A6207F5741333333331B772541666666461F7F5741CDCCCCCC64772541CDCCCC4C1D7F574133333333E9772541333333D3187F5741CDCCCCCC4B782541CDCCCC6C147F574100000000927825419A9999B9107F5741333333339B782541CDCCCC2C107F57419A999999A4782541000000A00F7F574133333333E07825419A9999390C7F5741666666666B792541666666C6027F57419A999999207A254100000080F67E57419A999999AC7A2541CDCCCCCCEC7E5741CDCCCCCC2F7B25419A9999D9E37E5741CDCCCCCCB07B254100000000DB7E57419A999999347C2541333333D3D17E574166666666AB7C2541666666A6C97E574166666666F67C2541666666E6C47E574100000000387D2541CDCCCCECC07E574166666666747D254133333313BE7E574133333333BC7D25419A999939BB7E57419A999999107E2541000000E0B87E5741666666661F7E2541CDCCCC8CB87E5741CDCCCCCC717E2541333333D3B67E574166666666C67E2541666666C6B57E574166666666227F254166666646B47E57419A999999407F2541666666C6B37E57419A999999727F25419A999999AC7E57419A9999998E7F254166666626A77E57419A999999A47F254166666606A37E574166666666A57F2541CDCCCCCCA27E57419A999999A27F2541CDCCCCCCA17E574100000000A37F2541666666C6A07E5741CDCCCCCCA37F254166666646A07E574133333333A87F2541000000C09E7E574166666666AD7F25419A9999B99D7E5741CDCCCCCCB57F2541333333F39C7E574166666666C07F2541666666869C7E57419A999999C97F2541666666469C7E5741CDCCCCCCD47F25419A9999799C7E574100000000DB7F25419A9999B99C7E574100000000E67F2541000000A09D7E57419A999999EB7F2541CDCCCC4C9F7E574100000000EE7F2541CDCCCC0CA07E5741333333330980254133333393A17E5741CDCCCCCC0C802541333333B3A17E5741CDCCCCCC2080254100000040A27E5741666666663D80254133333353A27E57413333333359802541CDCCCC0CA27E57419A99999978802541CDCCCC4CA17E5741000000008D8025419A999999A07E5741CDCCCCCCAC802541333333139F7E57419A999999C0802541333333B39D7E57419A999999D6802541666666269C7E5741CDCCCCCCED802541000000E0997E574100000000FF80254133333393977E5741333333331681254100000000977E5741000000001A812541000000A0967E5741CDCCCCCC558125419A9999798E7E5741CDCCCCCC868125419A999959857E574133333333AC812541000000C07C7E574133333333D38125419A9999D9707E574100000000FB8125419A999999637E57419A9999990B822541666666A6617E57419A99999919822541666666E65D7E57416666666623822541333333335B7E574133333333338225419A9999D9567E57413333333352822541000000E0507E57416666666671822541333333534C7E57410000000076822541666666A64B7E5741CDCCCCCC7082254100000020497E57419A9999996782254166666686447E5741666666665F822541CDCCCCEC417E5741CDCCCCCC5A8225419A9999F93D7E57413333333353822541333333733A7E5741000000004E8225419A999939347E5741666666664D822541000000802D7E5741CDCCCCCC4C8225419A9999B92B7E57419A99999944822541666666A6277E574166666666338225419A9999F9217E57413333333324822541666666661E7E57419A99999914822541CDCCCCCC197E57419A99999910822541CDCCCC0C187E57419A999999088225419A999959147E574166666666FE8125419A9999990F7E574100000000FA8125419A9999990D7E5741CDCCCCCCF5812541CDCCCC8C0C7E57419A999999E8812541CDCCCC4C097E5741CDCCCCCCE1812541666666C6067E574133333333DF8125419A9999F9007E574133333333E0812541666666C6FE7D574166666666E1812541333333F3FC7D574166666666E98125419A9999F9F87D574166666666F8812541CDCCCCCCF37D5741CDCCCCCCFF812541000000E0EF7D5741CDCCCCCC0082254133333353EC7D57419A999999FC8125419A999959E47D57413333333306822541000000A0DE7D57413333333301822541666666E6D97D574133333333EC812541333333B3CF7D57419A999999E681254100000040CC7D57419A999999D7812541000000E0C87D5741CDCCCCCCCA8125419A999999C77D5741CDCCCCCCBA812541CDCCCCECC67D574133333333A48125419A999979C67D5741CDCCCCCC9381254166666626C67D5741CDCCCCCC51812541666666A6C57D57419A99999942812541CDCCCCECC47D5741000000002E812541CDCCCCECC37D5741CDCCCCCC16812541666666E6C17D574133333333F680254100000040BC7D5741CDCCCCCCF08025419A999959BB7D574166666666D080254166666646B67D574133333333C5802541000000A0B37D574133333333B880254100000020AE7D57419A999999B480254166666606AC7D574100000000B280254100000080AA7D5741CDCCCCCCAA80254166666606A47D574166666666AA802541CDCCCCACA07D5741CDCCCCCCA9802541666666669C7D5741000000009A80254166666666957D5741CDCCCCCC7E8025419A9999798E7D5741333333336F802541333333138C7D57419A99999963802541CDCCCC6C897D5741333333335D802541CDCCCC0C877D574133333333598025419A9999D9837D574100000000588025419A9999D9827D57413333333349802541666666C67F7D57419A999999418025419A9999B97A7D57416666666634802541333333B3777D5741CDCCCCCC2D8025419A9999D9757D57419A99999926802541CDCCCCCC737D5741CDCCCCCC0E802541000000E0697D5741CDCCCCCC0D80254133333313647D57413333333314802541666666065E7D574133333333108025419A9999F9537D5741666666661580254133333373507D57419A99999930802541CDCCCC2C4B7D57413333333344802541666666A6447D57410000000047802541000000C0417D574133333333468025419A9999793F7D57416666666641802541000000603D7D5741666666663A8025419A9999993B7D57410000000026802541000000C0387D57419A999999F37F254100000060337D574166666666D97F2541333333F3307D5741CDCCCCCCB57F2541666666A62E7D574166666666747F25419A9999D92D7D574166666666487F2541000000002D7D5741CDCCCCCC057F2541CDCCCC0C2D7D574100000000AB7E2541333333332F7D574100000000817E2541333333D3307D574133333333747E25419A9999D9307D57419A999999507E2541333333732F7D574133333333407E25419A9999792E7D5741CDCCCCCC327E2541666666062D7D5741CDCCCCCC267E2541666666862B7D574166666666157E25419A999979287D574100000000067E25419A999939227D5741CDCCCCCC037E2541CDCCCCEC1E7D5741CDCCCCCC007E25419A9999991A7D574100000000067E254166666626147D574100000000027E2541CDCCCC0C107D574133333333097E25419A9999790B7D5741CDCCCCCC197E254166666686067D574166666666437E2541CDCCCCECFD7C5741000000005A7E25419A9999D9F77C5741666666665C7E25419A9999D9F67C5741000000005C7E254166666686F27C5741CDCCCCCC5D7E254166666606F27C5741333333336D7E2541000000C0F07C574100000000707E2541CDCCCC2CEF7C5741000000006D7E2541333333B3ED7C57419A9999995F7E2541666666A6EB7C574100000000247E25419A999979E67C57419A999999137E254166666606E67C5741CDCCCCCCE17D254100000040E67C574100000000CA7D25419A9999D9E57C57419A999999BC7D254166666666E67C574166666666B47D254100000080E77C574133333333987D2541CDCCCC0CEA7C574100000000827D25419A999939EB7C574166666666577D254100000000EC7C5741CDCCCCCC267D254166666606EC7C57419A999999137D2541000000A0EC7C5741CDCCCCCCF87C254133333333EE7C574166666666F27C254166666646EE7C574100000000E47C2541000000C0ED7C574100000000C67C25419A9999B9EB7C574166666666B67C2541333333D3E97C574166666666AD7C2541CDCCCC2CE87C5741CDCCCCCC987C254133333353DE7C574166666666987C2541CDCCCC6CDA7C5741000000009E7C2541CDCCCC0CD67C574100000000987C254133333373D27C5741CDCCCCCCB47C2541666666C6C77C574133333333C17C254166666626C57C574166666666D47C254100000080C27C57419A999999097D2541666666A6BE7C5741000000002C7D25419A999979BD7C5741000000008E7D2541CDCCCC6CBC7C57419A9999999D7D25419A999939BB7C574133333333A37D254166666646BA7C574100000000A67D254100000020B87C5741CDCCCCCCA67D254166666666B27C574166666666A27D25419A999939B07C5741333333338B7D2541CDCCCCACAA7C57419A999999767D254100000080A37C574100000000717D25419A9999599D7C574100000000697D2541333333339A7C574133333333687D254100000020917C5741333333336D7D2541CDCCCC6C8F7C574100000000867D2541000000E08A7C57419A9999999F7D254100000000857C574166666666AB7D2541CDCCCCAC817C57419A999999B57D2541333333937F7C574100000000F57D2541CDCCCC8C757C574133333333047E2541CDCCCC6C747C574100000000187E2541333333F3737C574100000000397E254100000080747C574166666666477E254166666606757C574166666666627E254133333393767C57419A999999737E254166666626787C5741CDCCCCCC817E2541333333F3797C574133333333977E2541666666A67B7C574133333333A77E2541333333F37B7C57419A999999B17E2541666666867C7C5741CDCCCCCCD07E2541666666E67F7C574166666666E87E254166666606827C574166666666F47E2541CDCCCC6C827C57419A999999147F25419A9999F9817C57419A999999237F254100000040827C5741000000003E7F254166666666837C5741CDCCCCCC4C7F2541CDCCCC6C837C5741CDCCCCCC687F25419A9999D9807C5741CDCCCCCC7F7F2541333333537D7C5741666666668B7F2541666666A67A7C5741000000009B7F2541333333B3757C574133333333A87F254100000040737C574100000000BF7F2541333333F36F7C5741CDCCCCCCD47F2541666666666A7C574166666666F77F2541CDCCCCEC627C574100000000088025419A999919607C57413333333317802541666666865C7C5741666666661A802541000000805B7C5741CDCCCCCC20802541CDCCCC8C597C5741333333332E8025419A999939537C57413333333334802541CDCCCC8C507C57413333333336802541000000404E7C5741CDCCCCCC32802541000000A0497C5741666666662A8025419A9999D9437C5741CDCCCCCC1B802541666666463F7C5741000000001D8025419A9999593E7C57419A99999920802541333333933B7C57416666666620802541333333B3387C5741000000002F802541666666E6317C5741CDCCCCCC338025419A999979307C57416666666640802541000000802C7C5741000000005980254133333393247C5741CDCCCCCC5B802541CDCCCCEC227C57413333333362802541666666261F7C5741666666666F802541333333B3197C5741666666666F80254166666646187C57410000000069802541333333B3157C5741333333336B8025419A999939137C5741CDCCCCCC57802541666666260D7C57416666666651802541CDCCCC0C0C7C57419A999999488025419A9999B90B7C5741000000002B802541333333730D7C57416666666612802541CDCCCCCC0D7C5741CDCCCCCCFD7F2541666666C60C7C574133333333E77F2541CDCCCCCC097C574133333333E07F2541000000A0087C574133333333D87F2541CDCCCC4C047C5741CDCCCCCCCB7F2541CDCCCC0C007C574166666666C67F254166666666FC7B574166666666C77F2541CDCCCCECF87B5741CDCCCCCCD47F2541333333F3F17B574166666666E47F2541CDCCCCECEB7B574133333333E57F25419A9999F9E97B57419A999999E57F2541CDCCCC6CE97B574133333333DC7F2541333333F3E57B574100000000DD7F254100000060E57B574133333333DE7F254166666626E47B574100000000E27F2541333333D3E27B574133333333EB7F254100000000E17B5741CDCCCCCC0E802541CDCCCC0CDA7B57419A9999992180254166666666D47B5741CDCCCCCC25802541333333D3D17B57413333333329802541CDCCCC6CCD7B57419A9999992C80254100000040C97B57419A9999993980254133333393C27B5741000000004080254166666646C07B574166666666508025419A999919BD7B57410000000078802541CDCCCC4CB77B574166666666868025419A999999B47B5741CDCCCCCC8B802541333333D3B27B5741000000009680254133333353AF7B5741000000009E8025419A999939AA7B574166666666A0802541000000A0A87B57419A999999B1802541CDCCCCACA37B574100000000BA80254100000040A27B574100000000BB802541CDCCCC4C9F7B574100000000C4802541666666869D7B574166666666C5802541CDCCCCAC9C7B574166666666CA8025419A999939967B574133333333CD802541666666A6927B57419A999999CC80254133333313917B57419A999999C5802541666666468D7B57419A999999AB80254100000060867B57416666666698802541666666E6827B57416666666697802541333333B3827B57419A9999997E8025419A999919807B5741333333335F8025419A9999997D7B5741CDCCCCCC548025419A9999197C7B57410000000051802541000000207A7B57410000000052802541666666C6757B5741CDCCCCCC57802541000000A0747B5741CDCCCCCC5D8025419A999959747B5741CDCCCCCC908025419A999979737B5741333333339D802541000000A0727B574133333333BC802541CDCCCC6C717B574133333333CD80254100000040707B57419A999999E1802541333333136E7B57419A999999EB802541333333336C7B5741666666660D81254133333373647B5741000000002D81254133333353597B5741333333332F8125419A9999B9567B5741000000002C81254166666646547B574166666666258125419A9999F9517B57416666666618812541666666A64E7B574133333333E58025419A9999F9457B574100000000CF802541CDCCCC2C437B574133333333AF802541666666A6407B574166666666678025419A9999793C7B57416666666654802541333333133C7B5741666666661E802541000000403C7B57419A9999990C802541666666263B7B574133333333F87F2541000000E0397B574100000000E37F2541CDCCCCCC377B574166666666DD7F2541000000E0367B57419A999999D17F254133333373327B57419A999999CF7F2541333333B3307B574166666666D47F2541666666462F7B5741CDCCCCCCD87F2541CDCCCCAC2C7B574133333333DA7F25419A999939257B5741CDCCCCCCE67F2541333333F3227B574100000000F87F254166666606217B5741CDCCCCCCFD7F25419A9999791F7B57419A999999FE7F2541000000201D7B57419A999999FA7F25419A999939187B574100000000FF7F254166666606177B57413333333307802541CDCCCC0C167B5741CDCCCCCC1780254166666646157B574166666666428025419A999959157B57413333333376802541333333F3147B5741000000007E802541CDCCCC6C147B574166666666898025419A9999B9137B5741000000009180254166666666127B5741CDCCCCCC928025419A9999D9107B5741CDCCCCCC8F8025419A9999590F7B57419A99999973802541000000000B7B5741666666666A80254166666666087B5741000000006C8025419A9999B9057B57419A99999971802541CDCCCC6C027B57419A999999798025419A999919007B5741CDCCCCCC7D80254100000020FC7A5741000000009180254166666666FB7A57410000000097802541CDCCCC2CFA7A57419A99999995802541666666C6F87A5741000000008580254166666686F57A5741CDCCCCCC8680254100000020F47A5741CDCCCCCC8F802541666666E6F27A5741333333339D802541CDCCCC2CF27A574133333333C18025419A9999F9F17A574133333333D4802541CDCCCC6CF27A574133333333DC802541333333D3F27A574100000000E48025419A999939F37A574100000000FD80254166666646F67A574166666666168125419A9999F9F97A5741CDCCCCCC20812541CDCCCC8CFB7A5741000000002E81254100000080FC7A5741000000003F812541CDCCCCECFC7A574100000000528125419A999939FD7A57419A9999995F81254166666646FD7A57419A9999996D812541CDCCCC4CFD7A5741000000009381254166666686FE7A574100000000A9812541CDCCCC4CFD7A574166666666B8812541000000E0FB7A57419A999999CC81254100000080F97A574100000000DB81254100000040F77A574166666666EC812541666666A6F47A57419A999999FE812541CDCCCC0CF37A57419A9999990E822541CDCCCC4CF17A57413333333316822541CDCCCCCCEE7A5741666666661282254166666666EC7A5741333333330E82254133333353EB7A5741666666660982254166666626EA7A57419A999999FE81254166666626E87A574100000000F7812541CDCCCCCCE67A574133333333EB8125419A999959E47A57419A999999D18125419A999939E17A574100000000B6812541333333D3DC7A574133333333A181254100000060DA7A57419A999999808125419A999999D57A5741666666666181254133333373CE7A5741333333335581254133333353CC7A57416666666652812541CDCCCCCCCB7A5741666666662C8125419A999959C87A5741666666661A81254133333393C57A57410000000010812541CDCCCCACC27A5741CDCCCCCCFE80254100000080BC7A574133333333FB80254166666606B97A57419A999999FE802541000000E0B67A57416666666610812541666666E6B27A5741000000002A81254100000040B07A5741CDCCCCCC6081254133333373AD7A5741CDCCCCCC778125419A9999F9AC7A57419A99999984812541333333B3AC7A5741CDCCCCCC958125419A9999B9AC7A574133333333B8812541CDCCCC6CAD7A574166666666DF81254100000000AF7A574166666666FB812541333333B3AF7A57419A999999138225419A9999D9B07A5741333333332F822541333333B3B27A5741CDCCCCCC41822541333333F3B27A57419A9999995482254100000020B27A57419A99999967822541CDCCCC8CB07A57419A9999997882254100000080AE7A57413333333384822541CDCCCCECAB7A57410000000092822541CDCCCCCCA67A57419A999999A68225419A999959A37A574100000000AA8225419A9999F9A07A574100000000AA822541666666A69A7A574133333333B0822541000000E0957A5741CDCCCCCCBF82254100000040917A57419A999999DD8225419A9999198D7A574133333333F682254133333333897A5741CDCCCCCC1983254133333393857A5741666666665883254166666646827A5741666666668C8325419A999999807A574133333333C5832541666666A67D7A574100000000F5832541333333B37B7A57413333333303842541333333F37A7A57419A99999922842541666666C6787A574166666666368425419A9999F9767A5741CDCCCCCC6284254166666626747A57419A99999973842541333333B3727A5741666666668F842541666666C6717A5741CDCCCCCCA1842541CDCCCC4C707A57419A999999AD842541333333136E7A574133333333B0842541333333936D7A574100000000B7842541CDCCCCCC6A7A57419A999999C88425419A999939687A574133333333D084254166666686677A574166666666F4842541000000A0657A5741666666660685254100000000637A5741333333331D852541000000A05F7A574166666666608525419A9999F94E7A57410000000068852541CDCCCC6C4C7A5741666666666C852541CDCCCCAC497A57416666666675852541666666A6447A57419A9999997785254133333393417A5741666666667A852541000000003E7A57419A9999997E852541666666463A7A57419A9999997A8525419A9999B9347A5741000000008D8525419A9999D92E7A5741000000009E852541333333D32A7A574100000000B3852541CDCCCC0C277A574166666666C685254133333313247A574100000000E3852541CDCCCC4C217A5741CDCCCCCCF3852541666666261F7A57419A999999048625419A9999B91C7A5741333333330C862541CDCCCCEC1A7A57419A9999990C862541333333D3197A5741000000000D862541CDCCCC0C187A5741CDCCCCCC068625419A999939137A57419A999999FA852541333333530D7A5741CDCCCCCCEB852541333333B3087A574133333333E985254133333333057A574100000000E985254166666626027A5741CDCCCCCCEF85254133333313FF795741CDCCCCCCF885254166666626FC7957419A9999990186254166666606FA795741333333330F862541333333B3F6795741333333331D862541CDCCCC8CF27957419A9999992D86254166666666EB7957410000000030862541CDCCCC0CE6795741333333332C86254100000040E3795741CDCCCCCC2086254166666646DF795741666666661E8625419A9999D9DE795741333333331486254100000020DD79574133333333F1852541000000E0D979574100000000C785254100000020D579574166666666B3852541666666A6D37957419A999999D1852541666666C6D0795741CDCCCCCC63862541CDCCCCECC2795741CDCCCCCC6C8625419A999919C279574100000000C786254166666686B97957419A9999992A87254166666626B079574133333333BB87254133333373A27957419A99999915892541333333B3817957413333333333892541666666E67E795741666666665D892541666666E67A79574100000000C3882541000000206D79574166666666B7882541666666866C79574133333333AF8825419A9999B96A79574133333333A4882541CDCCCCAC6879574100000000988825419A999979677957419A9999998D88254166666626667957419A999999848825410000006065795741CDCCCCCC7C88254100000000657957413333333373882541666666E6647957419A99999962882541000000C064795741000000004C882541CDCCCC8C6479574166666666428825419A99993963795741CDCCCCCC368825413333337361795741666666662D8825419A999919607957416666666620882541000000405E79574100000000138825419A9999595C79574100000000078825419A9999195A79574133333333FB8725419A999939587957419A999999EB872541000000605679574133333333DA872541000000C05379574100000000B4872541CDCCCC0C4E79574166666666A7872541333333734D7957419A999999A3872541333333734C795741CDCCCCCC9D8725419A9999594B79574133333333938725419A9999994A79574100000000898725419A9999594A795741000000007D872541CDCCCC4C4A7957413333333370872541666666464A79574166666666608725419A9999D949795741CDCCCCCC53872541CDCCCC6C4979574166666666CF862541CDCCCC6C377957419A999999B5862541666666862879574133333333B0862541CDCCCCCC2679574166666666A8862541CDCCCC6C247957419A999999A48625419A9999B921795741CDCCCCCCA3862541000000802179574100000000A3862541333333531A79574100000000E88525419A9999F9E7785741666666668A8425419A999979D1785741CDCCCCCC1C8325419A999979D478574166666666C28225419A999959CF78574166666666ED81254133333373BA785741000000006F812541CDCCCC0CAE785741333333333A812541666666C6A778574100000000A3802541CDCCCCCC9B78574133333333458025419A999939947857410000000026802541000000C09078574166666666C27F25419A9999398A785741333333337B7F25419A9999598678574166666666E27D254133333373787857419A999999D37C2541666666C6707857419A999999917C2541000000C07078574100000000777C2541000000C07078574166666666E47B2541CDCCCCCC7078574166666666BF7B2541CDCCCCCC707857419A999999877B2541333333D37078574100000000587B2541CDCCCCCC70785741CDCCCCCC517B25419A9999D9707857419A9999992E7B2541333333137178574166666666887A2541666666467278574100000000CE7925419A99999973785741CDCCCCCC9F792541CDCCCCEC737857419A9999999579254100000000747857419A9999998C792541333333137478574166666666697925419A999939747857416666666637792541CDCCCCAC7478574100000000337925419A9999B9747857413333333300792541333333137578574166666666E0782541666666A6757857419A999999BF782541CDCCCC4C7678574100000000947825410000002077785741666666668078254166666686777857413333333370772541CDCCCCAC7C78574166666666F6762541666666E67F78574133333333C5762541CDCCCCEC807857419A999999B9762541666666E6807857419A999999A17625419A9999997D7857419A99999983762541CDCCCCCC7A785741CDCCCCCC617625410000006077785741000000004F7625419A9999597578574133333333347625419A99995974785741CDCCCCCC197625419A9999F9737857419A999999FF752541000000C07278574166666666E17525419A9999797278574133333333C87525413333331372785741CDCCCCCCAB7525413333333371785741333333339775254166666646717857419A9999998275254133333333717857419A9999996C75254100000000717857410000000050752541333333F36F785741CDCCCCCC3A75254166666606707857413333333327752541666666C6717857410000000012752541000000E071785741CDCCCCCCFF742541000000807178574133333333E874254133333353707857419A999999D17425419A9999D96F78574166666666BB7425419A9999396F78574133333333A47425419A9999B96F785741666666668E74254133333353707857413333333379742541CDCCCCEC7078574100000000627425410000006071785741333333334C742541000000A071785741000000003D742541000000C072785741CDCCCCCC2C7425419A99999973785741333333331A742541666666C6747857419A9999990B7425419A999959757857419A999999F6732541666666467678574133333333E37325419A9999B97778574100000000CB732541CDCCCCCC787857419A999999B57325419A9999B979785741CDCCCCCC9F7325419A9999597A785741CDCCCCCC87732541000000207B785741000000006D732541000000807B785741CDCCCCCC5C732541000000A07D7857419A9999994A732541000000407F785741000000003A73254133333333817857416666666628732541CDCCCCEC827857416666666618732541000000A08478574133333333067325416666666686785741CDCCCCCCF2722541CDCCCCEC8778574133333333E4722541666666E68978574166666666D37225419A9999598B7857419A999999C2722541666666C68C7857419A999999B0722541CDCCCC4C8E785741666666669E722541CDCCCCEC8F7857419A99999989722541333333B3907857410000000074722541333333F3917857419A9999995F722541CDCCCCCC92785741666666664A7225416666666693785741CDCCCCCC3672254133333313947857419A99999921722541000000C094785741333333330D722541CDCCCC6C9578574100000000F87125419A99999995785741CDCCCCCCE2712541CDCCCCAC9578574133333333CC712541666666C695785741CDCCCCCCB7712541666666069678574166666666A27125419A99991996785741CDCCCCCC8B71254133333333967857419A99999976712541CDCCCCEC95785741333333335F712541CDCCCC6C95785741000000004D712541333333D394785741000000003971254166666666947857419A99999925712541666666469378574166666666137125419A9999F991785741CDCCCCCCE5702541333333538D78574133333333987025419A999939887857410000000079702541666666A682785741CDCCCCCC687025419A999919817857419A9999995A702541CDCCCC2C7F785741000000004D702541CDCCCC2C7D785741CDCCCCCC3C702541333333737B785741666666662D702541000000E079785741000000001A702541CDCCCC2C797857410000000004702541CDCCCC2C7978574133333333EE6F2541CDCCCC2C7978574100000000D86F2541000000C0787857419A999999C26F25419A9999B97778574100000000AF6F25410000004076785741CDCCCCCC9C6F2541333333B3747857419A9999998C6F2541CDCCCC0C737857419A999999826F2541333333D370785741000000007A6F2541CDCCCCCC6E785741333333336B6F2541000000E06C7857419A9999995B6F2541666666266B785741CDCCCCCC446F2541CDCCCCEC6878574100000000306F2541333333D367785741000000001F6F25419A9999D965785741CDCCCCCC0E6F2541666666066478574133333333FD6E2541000000206278574133333333EA6E2541CDCCCC0C60785741CDCCCCCCDA6E2541666666665E78574133333333C96E2541666666665C785741CDCCCCCCB66E2541000000405A78574133333333A76E25410000004058785741CDCCCCCC946E25419A9999195678574100000000866E25419A9999595478574100000000736E2541CDCCCC8C52785741000000005F6E2541CDCCCCEC51785741CDCCCCCC4A6E2541666666E6507857419A999999366E2541333333734F78574166666666246E2541333333534E78574100000000116E25419A9999194D78574166666666FD6D2541333333D34B785741CDCCCCCCED6D2541333333F34A78574133333333DB6D2541333333934978574133333333CC6D2541CDCCCCCC487857419A999999B26D2541666666864778574133333333A26D254166666606477857419A999999856D2541666666E646785741CDCCCCCC6C6D25419A99993946785741000000005C6D25413333331346785741CDCCCCCC466D2541CDCCCC6C46785741CDCCCCCC316D25416666660647785741666666661D6D2541666666C64778574166666666FC6C2541CDCCCCEC48785741CDCCCCCCE66C2541333333F3497857419A999999CB6C2541333333334C78574100000000B36C25419A9999394C7857419A9999999D6C2541333333B34B785741CDCCCCCC866C2541666666C64A785741CDCCCCCC716C2541666666A649785741000000005D6C2541000000A04878574133333333466C25419A9999D94778574133333333306C25410000000047785741000000001D6C2541666666264778574100000000056C2541666666664778574133333333EF6B2541666666664778574166666666D96B2541666666864778574166666666C96B2541000000A04478574133333333BB6B2541333333D33F78574100000000AE6B2541000000A03C785741333333339D6B2541666666063A7857419A999999896B2541333333D338785741CDCCCCCC766B254166666686377857419A999999646B25419A9999393678574100000000536B2541333333933478574100000000436B2541CDCCCCEC3278574133333333356B25410000008030785741CDCCCCCC276B2541000000602E785741000000000F6B2541333333B32A785741CDCCCCCCFB6A2541000000A0297857419A999999DD6A25419A9999B92978574100000000CC6A2541666666E62978574166666666B66A2541666666062A785741CDCCCCCC9F6A25419A9999D9297857419A999999886A25419A9999D92978574133333333736A25419A99999929785741333333335F6A254133333313297857419A9999994A6A2541666666A628785741CDCCCCCC336A2541333333F327785741666666661E6A25416666664627785741666666667D6925419A9999B91D785741666666666A692541CDCCCC6C1C785741CDCCCCCCE1682541000000A0137857410000000094682541CDCCCCAC0E785741333333336A682541000000600A785741CDCCCCCC57682541333333D3087857416666666646682541CDCCCC2C07785741CDCCCCCC36682541CDCCCC6C057857419A999999266825413333337303785741000000001568254133333373017857416666666605682541000000A0FF77574133333333F3672541666666E6FD77574100000000E16725419A999959FC77574166666666CF6725419A999919FC7757419A999999B9672541CDCCCCACFB7757419A999999A5672541666666E6FA775741CDCCCCCC8B672541CDCCCC0CFA7757419A999999786725419A999979F9775741CDCCCCCC666725419A9999F9F6775741CDCCCCCC5967254133333393F47757419A9999994B672541CDCCCC0CF2775741000000003F67254166666626EE77574166666666CE66254100000080DF77574133333333BC662541333333F3DD775741CDCCCCCC82662541CDCCCC0CD6775741000000000366254100000080C4775741666666669B652541333333F3B6775741666666668065254133333373B3775741666666666C652541666666A6B0775741333333335B6525419A999939AE7757413333333348652541000000A0AB7757413333333332652541333333F3A8775741000000002165254133333353A7775741666666660865254166666606A977574166666666F3642541333333B3A9775741CDCCCCCCDF642541666666A6AA775741CDCCCCCCCD642541333333D3AC77574166666666C164254166666606AF77574166666666B864254133333373B177574166666666AF642541CDCCCCCCB37757419A999999AA64254133333393B677574100000000A364254100000000B977574133333333956425419A9999D9BA775741333333338764254133333373BC7757419A99999984642541CDCCCC0CBD775741000000007164254133333333BE775741000000005864254133333313C07757413333333302642541CDCCCC0CC577574133333333C663254100000080CA7757416666666693632541666666E6D07757419A9999997463254133333353D3775741333333332A632541CDCCCC4CD87757419A999999DA622541CDCCCC2CD977574166666666AF622541CDCCCCECDD77574166666666806225419A999919E37757419A9999995762254100000000E9775741CDCCCCCCEB612541000000A0F2775741CDCCCCCC8061254133333373FA775741666666663861254166666606FE7757416666666625612541000000E0FE7757419A9999990F612541CDCCCCCCFF775741CDCCCCCCFC602541000000C00078574166666666E8602541CDCCCCAC0178574100000000D46025419A9999590278574133333333C06025419A9999D90278574133333333AF6025419A9999D9037857419A9999999860254133333333057857410000000073602541333333D3057857419A999999486025413333337304785741CDCCCCCC29602541333333530A78574166666666126025419A9999190E7857416666666602602541CDCCCCEC0F78574133333333F25F25416666664611785741CDCCCCCCDC5F25419A9999391278574100000000C65F2541333333131278574166666666AE5F2541000000A0117857419A999999975F25419A99997911785741CDCCCCCC815F2541000000E010785741666666666E5F25416666666612785741CDCCCCCC585F2541CDCCCC0C1478574100000000465F2541333333931578574166666666395F2541CDCCCC2C1678574100000000275F2541000000C016785741000000001A5F2541CDCCCC6C177857419A999999085F25410000006018785741CDCCCCCCF35E2541666666661B7857419A999999EE5E25419A9999992078574166666666C85E2541333333F323785741666666668C5E2541333333532B785741CDCCCCCC855E2541666666062F785741CDCCCCCC925E2541CDCCCC6C367857419A9999998B5E2541000000803D78574133333333855E2541333333933F785741CDCCCCCC5B5E2541CDCCCCCC4578574133333333145E2541000000204978574100000000FD5D2541000000804A78574166666666E85D2541333333B34B785741CDCCCCCCD35D2541333333134D7857419A999999C05D25419A9999994E78574133333333AC5D2541666666265078574133333333955D2541000000A051785741666666667F5D25419A9999595378574166666666755D2541CDCCCC8C56785741333333335F5D254100000040597857419A999999475D2541000000C05B785741000000002F5D25419A9999995C785741000000001F5D2541666666A65E7857419A999999055D25413333331361785741CDCCCCCCF15C2541CDCCCCAC6278574100000000D85C2541CDCCCCCC63785741CDCCCCCCC35C2541333333D36578574133333333A95C2541000000A06B785741666666661E5D2541666666A667785741666666664B5D254100000020667857419A999999835D25419A99993966785741000000003C5F2541333333D36878574133333333665F2541666666066A7857419A999999985F2541333333336B785741CDCCCCCC35612541333333B36F785741333333337461254100000020717857419A999999E2622541333333D37B785741000000000E642541333333139978574100000000536425419A9999D99F7857419A9999999664254133333373A6785741333333330365254133333313B17857419A999999626525419A999959BA785741CDCCCCCC7A662541000000E0CD78574100000000826725419A9999F9E87857419A999999D967254100000000F0785741CDCCCCCCB8682541CDCCCC2CFF7857419A999999606925419A99993906795741CDCCCCCC056A2541CDCCCC4C0A7957419A9999999B6A2541CDCCCCAC12795741CDCCCCCC2F6B25419A9999592279574133333333356B2541333333932379574166666666DD6B2541333333333B795741333333339B6C25419A9999D95579574133333333A16C2541000000405879574100000000C26C254166666686657957419A999999D16C2541CDCCCCCC6B79574100000000516D2541CDCCCC4C9F795741CDCCCCCC5A6D254133333333A3795741CDCCCCCC836D2541666666C6B3795741CDCCCCCC946D2541333333B3BA7957419A999999C36D2541CDCCCC8CCD79574100000000546F2541666666266F7A57419A9999990C6F25419A999979AB7A57419A9999990A6F25419A999979B17A57419A9999990A6F2541CDCCCC8CB47A57419A999999086F2541333333B3B57A57419A999999F56E25419A999979B97A574133333333E86E254166666666BC7A574100000000E06E2541CDCCCC2CBF7A574133333333DC6E25419A999959C17A574166666666E26E254166666606C47A574166666666DE6E254100000020C87A574133333333D96E2541000000C0CA7A574166666666DF6E254166666646CD7A574133333333DF6E2541CDCCCCACCF7A5741CDCCCCCC646E2541CDCCCC0CF67A574166666666D96D254166666686117B5741CDCCCCCCB06D254166666686197B574166666666AB6D2541000000E01B7B57419A999999A66D2541000000001E7B574100000000676D2541666666A6397B574166666666516D25419A9999F9427B5741CDCCCCCC426D2541CDCCCC4C497B574100000000286D2541333333F3547B57419A999999186D2541333333B35B7B574100000000E36C254166666606737B57419A999999C46C25419A999999787B57419A999999916C254100000000827B574133333333296B25419A999959C47B5741000000000E6B254100000060C97B574133333333096B2541666666A6CA7B574166666666F469254133333373147C574166666666EB6925419A9999D9167C57410000000069692541CDCCCCAC397C57419A9999991A692541333333F33E7C5741000000007B682541666666A6497C574133333333B9632541CDCCCC4C9B7C57416666666690632541666666E69D7C574100000000596225419A9999D9B17C57416666666629622541666666E6B47C5741000000004F612541666666E6C27C574100000000A3602541333333F3CD7C57413333333374602541CDCCCCECD07C574100000000EA5E2541CDCCCC2CEA7C5741CDCCCCCC2A5E254100000000F17C574166666666155E2541000000C0F17C57419A999999FE5D254133333393F27C574166666666CB5D254166666666F47C574166666666865D2541333333D3F67C57419A999999695D2541000000E0F77C5741666666665E5D254100000040F87C574166666666485D254166666606F97C5741333333333E5D254166666666F97C574133333333535C254100000080F77C57419A9999999B5A25419A9999F9F37C574166666666605A2541666666C6F27C574100000000195A254166666646F17C574100000000B059254133333313EF7C5741000000008959254166666646EE7C5741CDCCCCCC5859254166666646ED7C574133333333EE582541CDCCCC0CEB7C574100000000C958254100000040EA7C57419A9999996F58254166666666E87C5741CDCCCCCC5A572541666666A6E27C5741CDCCCCCC2A572541666666A6E17C57419A9999995756254100000040DD7C57410000000094552541CDCCCC2CD97C57413333333383552541CDCCCCCCD87C5741CDCCCCCC7C5525419A9999F9D67C57419A9999996B552541CDCCCC8CD37C5741CDCCCCCC4D552541000000E0CF7C57419A9999992E5525419A999959D17C57416666666618552541333333B3D17C5741CDCCCCCC0055254133333353D17C574166666666E75425419A999979D07C5741CDCCCCCCCF54254166666686CF7C574166666666B654254166666666CE7C5741666666669A54254166666686CD7C5741666666668854254100000040CD7C57419A99999975542541333333F3CC7C5741000000004A54254166666666CC7C5741CDCCCCCC1B5425419A9999B9CB7C574133333333F753254166666646CB7C574100000000D85325419A9999B9CA7C574100000000A45325419A999919CB7C5741CDCCCCCC4553254166666626CA7C5741CDCCCCCC305325419A999959CA7C574133333333135325419A999999CA7C5741CDCCCCCCE55225419A999939CA7C57419A999999DF522541666666C6CA7C57419A999999D05225419A999919CC7C574133333333B5522541333333D3CD7C5741666666669352254100000020CE7C57419A999999805225419A999999CD7C57419A9999997452254100000020CE7C5741666666665C522541000000E0CE7C57416666666655522541666666E6CE7C57419A9999993252254166666646CD7C574133333333235225419A9999B9CC7C57416666666618522541CDCCCCACCC7C5741333333330652254133333313CD7C57419A9999990352254100000040CD7C5741CDCCCCCCDE512541CDCCCC6CCD7C574166666666D351254100000020CD7C57419A999999C8512541CDCCCC0CCC7C574100000000B2512541666666E6CA7C57416666666695512541000000A0CA7C5741000000008C5125419A999919CA7C574100000000655125419A999959C97C5741666666662D512541666666E6C97C5741CDCCCCCC1C51254166666666C97C574100000000FE50254166666666C87C574133333333E95025419A999939C87C574100000000DC50254166666606C87C574100000000B35025419A9999B9C97C57419A999999A0502541000000A0C97C57419A9999997B502541000000A0C97C574100000000665025419A999959CA7C5741666666664C50254133333393CC7C5741000000001B5025419A9999F9CF7C57419A9999990C50254100000060D07C57419A999999F14F254166666686D07C57419A999999EB4F254100000080D07C574100000000CC4F25419A999979D17C574100000000BB4F2541333333F3D17C5741CDCCCCCCA84F254133333373D27C5741CDCCCCCCA34F2541666666A6D27C574133333333714F25419A999979D17C5741000000006B4F254166666626D17C5741CDCCCCCC5A4F2541666666E6CF7C574133333333504F254133333393CF7C57419A999999414F2541CDCCCC4CCE7C5741CDCCCCCC2C4F254166666666CC7C574133333333224F2541CDCCCC8CCB7C57419A999999114F2541333333F3CB7C574166666666054F25419A9999B9CC7C5741CDCCCCCCF94E2541666666E6CC7C5741CDCCCCCCED4E25419A999959CC7C574166666666E54E2541000000E0CB7C57419A999999F44D2541CDCCCCACC07C5741CDCCCCCCD34D25419A999979C97C574166666666BC4D2541666666C6CF7C5741333333339F4D2541000000A0D77C5741CDCCCCCC1B4E2541CDCCCC2CDD7C5741CDCCCCCC374E2541CDCCCC6CDE7C5741CDCCCCCC4B4E254166666666DF7C5741333333336E4E2541000000E0E27C5741666666667C4E254100000020E57C57419A999999804E254100000060E77C57419A9999998C4E2541000000A0E97C574133333333DE4E25419A999939F37C574100000000EE4E2541CDCCCC0CF57C5741CDCCCCCC8C4E2541333333D3037D574100000000424E2541CDCCCC2C0F7D5741CDCCCCCC264E2541666666461D7D5741333333331C4E2541333333D3267D574133333333184E2541666666062E7D574133333333094E2541000000A0337D574100000000F94D2541333333733B7D5741CDCCCCCCD94D2541666666A6427D57419A999999D14D254133333353457D574133333333CB4D25419A9999D94B7D574133333333C44D254133333353507D5741CDCCCCCCBB4D25419A999959547D574133333333AF4D25419A999979597D57419A999999A74D2541CDCCCC2C5D7D57419A9999999E4D2541000000C0617D574133333333974D2541CDCCCC2C647D5741CDCCCCCC954D2541333333D3667D57419A999999924D2541CDCCCCAC697D574166666666924D2541333333136C7D574133333333904D25419A9999B96D7D574133333333864D25419A9999396F7D57419A999999794D2541CDCCCC2C717D574133333333704D254166666606747D5741333333336B4D254166666606767D574100000000644D2541CDCCCCAC787D57419A9999995F4D2541333333537A7D574166666666594D25419A9999F97C7D574100000000554D2541333333737F7D574133333333524D2541000000C0817D57419A999999504D25419A9999B9837D57419A9999994F4D2541333333D3857D574100000000504D2541CDCCCC4C887D574133333333534D2541000000608A7D574166666666574D2541CDCCCC8C8C7D5741333333335A4D2541666666068F7D5741666666665D4D25419A999959917D574133333333604D254166666666937D5741CDCCCCCC644D2541000000C0957D574133333333684D254166666646987D574166666666694D2541CDCCCC6C9A7D5741666666666A4D25419A9999F99C7D574133333333644D2541333333339F7D5741CDCCCCCC5A4D254100000040A17D574166666666534D254100000000A47D574133333333484D2541CDCCCCACA77D574133333333434D25419A9999F9A87D574166666666484D254133333353AC7D574166666666504D25419A999919B07D574100000000554D2541000000E0B37D57419A999999524D2541CDCCCC8CB67D5741666666664B4D254100000080B97D5741000000004F4D2541666666C6BB7D5741CDCCCCCC554D25419A999939BE7D574133333333584D2541CDCCCC4CC07D574166666666574D2541000000E0C27D574166666666504D254100000000C67D574133333333514D2541000000E0C87D574166666666534D2541CDCCCC0CCE7D574133333333564D25419A999999D77D574166666666564D2541666666C6D77D5741666666665C4D254100000020DD7D5741333333335E4D2541333333F3E07D57419A999999534D254100000060E67D574166666666454D2541333333D3E97D5741000000002F4D254166666686EC7D57419A999999204D254133333353EE7D57419A999999144D2541000000C0F07D5741CDCCCCCC0D4D2541666666C6F37D5741666666660A4D25419A999939FB7D5741CDCCCCCC014D2541CDCCCC2CFD7D574100000000F94C254166666626FE7D574133333333EA4C2541CDCCCC4CFE7D574133333333DE4C2541333333D3FE7D574100000000CA4C254100000040017E5741CDCCCCCCB84C2541666666C6047E574133333333B14C2541333333F3077E574133333333984C2541000000E00B7E5741CDCCCCCC924C2541000000A00E7E574100000000934C254133333353117E5741666666668F4C254166666686147E57419A9999998E4C254166666666157E5741CDCCCCCC8B4C2541CDCCCCEC197E574100000000754C2541333333D31F7E5741000000006B4C254100000020257E574166666666664C254100000060277E5741333333335C4C25419A9999B92F7E57419A999999584C25419A999979317E5741CDCCCCCC4D4C254166666686347E574100000000324C2541666666C6387E57419A999999234C2541333333333A7E57419A999999034C2541CDCCCC8C3B7E574100000000EB4B25419A9999D93B7E5741CDCCCCCCDA4B2541333333533D7E57419A999999D34B2541CDCCCC6C3F7E574100000000D24B254133333353417E574100000000D84B254166666646467E57419A999999D64B2541CDCCCC6C487E574166666666CB4B2541333333F34B7E5741CDCCCCCCC14B2541333333F34E7E574166666666B44B2541000000A0507E57419A9999999B4B25419A999979527E5741666666667F4B25419A999979557E57419A999999674B25419A9999D9577E57419A999999384B2541000000A05D7E5741CDCCCCCC1D4B2541000000A0627E57419A999999024B25419A9999D9667E574133333333DE4A2541333333536B7E57419A999999C44A2541000000E06E7E574133333333B24A2541666666866F7E57419A9999999D4A25419A9999B96E7E5741CDCCCCCC8F4A2541666666666E7E574166666666744A254100000080707E57419A9999996F4A2541666666E6757E5741CDCCCCCC724A25419A9999D9787E5741CDCCCCCC754A2541666666C67B7E574133333333784A2541666666667E7E5741CDCCCCCC764A2541CDCCCC0C837E5741CDCCCCCC6E4A2541666666E6847E574133333333654A25419A999999867E5741CDCCCCCC5C4A2541333333D3877E5741CDCCCCCC554A25419A9999F9887E5741CDCCCCCC4D4A2541333333538A7E5741CDCCCCCC484A2541666666C68B7E574166666666464A2541CDCCCC4C8D7E574166666666464A2541CDCCCC2C907E574166666666454A2541666666C6917E57419A999999404A25419A999919947E574166666666384A254100000000967E5741CDCCCCCC2E4A2541000000A0977E574166666666214A254166666666997E574133333333134A2541333333B39A7E574100000000024A2541CDCCCC2C9C7E57419A999999F3492541000000A09D7E574133333333E8492541666666C69E7E57419A999999E0492541000000E09F7E574133333333D14925419A999919A37E5741CDCCCCCCCD49254133333353A47E5741CDCCCCCCCF492541CDCCCC8CA57E574166666666DC492541666666A6AA7E574133333333E449254133333333AA7E57419A999999FA492541666666E6A87E5741CDCCCCCC144A254133333333A87E574166666666274A254166666666A87E57419A999999334A2541333333F3A87E574166666666544A25419A999979AA7E57419A999999174B25419A9999B9B47E5741666666663D4B254100000040B67E5741CDCCCCCC3F4B2541CDCCCC4CB67E574166666666564B254166666666B67E574100000000A44B254100000060B57E574166666666204C2541666666C6B37E5741CDCCCCCCD84C254100000060B17E574100000000ED4C25419A999939B17E574166666666594D254166666646B07E574166666666744D25419A999939B07E574166666666894D2541CDCCCC2CB07E574166666666A54D254100000020B07E5741CDCCCCCC264E254100000060B07E57419A9999993C4E25419A999999B07E574166666666754E254133333333B17E5741666666667F4E254133333353B17E574133333333894E254166666666B17E57419A999999B34E25419A9999D9B17E57419A999999F54E2541333333D3B37E5741666666663D4F2541CDCCCC4CB77E574133333333864F25419A999979BB7E5741CDCCCCCC894F254133333393BB7E574166666666D24F254166666666BD7E57416666666602502541000000A0BE7E57416666666632502541000000A0BF7E574166666666565025419A999959C07E5741000000005E50254166666686C07E57419A999999DD5025419A9999B9BF7E57419A99999983512541666666A6BD7E57419A9999993A522541CDCCCC6CBB7E5741666666664252254166666666BB7E5741000000006152254100000040BB7E574166666666635225419A999939BB7E5741333333337752254166666686BB7E5741000000008E5225419A9999D9BB7E574100000000B75225419A999959BD7E574166666666E752254133333313BF7E57419A99999933532541333333B3C37E57416666666663532541333333B3C77E574166666666665325419A999959CA7E5741000000006B53254166666626CF7E5741000000006B53254166666646CF7E5741666666666A532541CDCCCCCCD27E574100000000695325419A999919D77E5741333333336A5325419A999979DC7E5741666666666A53254133333373DD7E5741000000006B53254133333313E17E5741333333336D53254100000020E57E5741CDCCCCCC7353254133333393EB7E5741CDCCCCCC7D5325419A9999D9F07E57419A9999998A53254166666686F67E5741666666668F532541CDCCCC0CFA7E5741CDCCCCCC8F532541CDCCCC2CFB7E57413333333391532541666666A6FF7E5741666666669153254133333393077F574166666666915325419A999919087F57410000000092532541CDCCCCEC0C7F57413333333392532541333333730E7F5741CDCCCCCC96532541CDCCCCAC137F57416666666699532541333333B3167F5741333333339D532541000000001B7F5741CDCCCCCC9F532541666666E61D7F5741CDCCCCCCA453254166666666267F574133333333AB532541333333132C7F574166666666B0532541666666062F7F574166666666B7532541CDCCCC0C337F574133333333BE53254133333333387F574133333333C1532541000000403A7F574166666666C2532541666666063B7F574133333333C4532541333333D33B7F574166666666CA532541333333733E7F574133333333DD532541CDCCCCCC437F574133333333F853254100000080497F5741CDCCCCCC14542541000000A04F7F5741333333333354254100000080587F5741CDCCCCCC41542541000000605C7F57410000000046542541333333735D7F5741CDCCCCCC4F54254133333313607F5741CDCCCCCC5854254133333353627F5741333333336554254100000060657F5741333333337C5425419A9999796B7F5741CDCCCCCC94542541666666E6717F574133333333A354254166666686757F574166666666B154254133333313797F574166666666BD542541333333137C7F574166666666CD542541CDCCCCEC7F7F574133333333D854254133333393827F574133333333E25425419A9999F9847F574166666666E4542541000000C0857F57419A999999F55425419A9999F98B7F57416666666606552541CDCCCC8C927F57413333333316552541CDCCCC8C9A7F5741CDCCCCCC1E552541666666069D7F57410000000028552541666666A69F7F5741CDCCCCCC2D55254166666666A17F57419A99999930552541000000E0A27F5741666666663855254166666666A77F5741CDCCCCCC4A55254100000060AE7F5741333333336255254100000020B57F5741333333336655254100000080B67F57419A9999997555254100000080BB7F5741000000007D55254133333373BE7F57419A9999998B55254166666626C47F574166666666A355254133333333CD7F574133333333BA552541000000C0D77F574133333333BE552541333333D3D97F574100000000CD552541CDCCCCCCE17F57419A999999D75525419A999959E77F574166666666DE552541666666E6EA7F574100000000E95525419A999979EE7F574166666666EF55254133333393F07F57419A999999F1552541CDCCCC6CF17F57416666666602562541333333D3F77F57419A9999990A5625419A999959FC7F5741000000000D562541333333B3FD7F5741666666661256254166666646018057416666666616562541666666E603805741333333331A56254133333353068057410000000023562541333333530E805741666666662956254166666666128057410000000030562541666666E61480574166666666335625419A9999F9158057419A9999993A56254133333313188057416666666645562541000000801A8057416666666647562541333333F31A8057410000000056562541CDCCCC0C1E805741CDCCCCCC5E562541333333F31F80574100000000705625410000006024805741CDCCCCCC79562541333333F3278057419A99999981562541333333932E805741CDCCCCCC88562541000000C0328057410000000098562541CDCCCC2C3D805741666666669E562541CDCCCCCC4180574100000000A2562541CDCCCC4C4480574166666666B0562541666666E64F8057419A999999B456254100000060538057419A999999BC5625419A9999195A8057419A999999BD562541333333D35A80574166666666C2562541666666C65F8057419A999999CA562541CDCCCC8C6780574166666666CB562541CDCCCC4C6880574166666666CD562541666666E66980574100000000D65625419A9999D97080574100000000E1562541CDCCCC0C7880574100000000E5562541000000A07A8057419A999999ED562541CDCCCC2C8080574166666666F05625419A999959828057419A999999F05625416666668682805741CDCCCCCCF4562541CDCCCCCC8580574100000000F55625419A99997986805741CDCCCCCCF7562541666666E68B8057419A999999F7562541666666A68C80574133333333F7562541CDCCCCAC9180574133333333F6562541666666469B80574100000000F6562541666666069C80574133333333F85625419A999919A5805741CDCCCCCCF85625419A999979AD80574166666666F9562541CDCCCCCCB380574133333333FB5625419A999999B680574133333333FC56254133333353B88057410000000000572541666666A6BA805741666666660157254166666686BB805741000000000C57254166666626BF8057419A999999155725419A999959C18057419A999999285725419A9999B9C5805741666666665257254133333333CF80574100000000675725419A999939D58057419A9999996A572541666666C6D7805741333333336B572541CDCCCCECD8805741CDCCCCCC76572541CDCCCC2CD7805741CDCCCCCCA2572541333333F3D180574133333333B857254100000060CF80574133333333C957254100000080CD8057419A999999CF572541333333D3CC80574100000000D657254166666626CC80574100000000E55725419A9999B9CA80574100000000FE5725419A999979C8805741666666661F58254166666626C68057419A9999992758254133333373C5805741CDCCCCCC3D58254100000000C4805741333333334A582541000000A0C2805741333333335658254100000000C1805741000000006D582541CDCCCCECBC805741666666667D58254166666626BA805741CDCCCCCC8A582541333333F3B78057419A9999999758254166666626B680574100000000A558254100000060B480574166666666B4582541CDCCCCCCB2805741CDCCCCCCBF5825419A9999B9B18057419A999999CA582541000000C0B08057419A999999D7582541333333D3AF8057419A999999E258254100000000AF805741CDCCCCCCED582541000000E0AD80574100000000FA58254133333373AC805741333333330359254100000000AB805741CDCCCCCC0B59254133333353A9805741CDCCCCCC1A59254100000040A68057413333333330592541333333F3A08057413333333338592541333333B3A2805741666666664759254166666646A7805741666666664B59254166666686A8805741666666666B59254100000020B180574133333333745925419A999999B4805741333333337959254166666626B78057419A9999997A592541CDCCCC2CB9805741666666667D59254166666646BB8057416666666683592541CDCCCC8CBD8057416666666689592541333333D3BF8057419A9999999059254100000000C2805741CDCCCCCC9859254100000060C480574100000000A95925419A999999C9805741CDCCCCCCAC592541333333B3CA80574166666666B75925419A9999B9CD80574133333333C059254166666666D080574133333333C8592541666666A6D280574166666666CD592541CDCCCC8CD48057419A999999D0592541666666C6D580574133333333D659254133333333D88057419A999999C15925419A999959D880574166666666C9592541CDCCCCACDC80574133333333CD592541CDCCCC0CDF8057419A999999E2592541CDCCCCACE880574100000000115A25419A9999B9F780574100000000205A2541000000A0FC80574133333333265A2541000000C0FF80574133333333495A2541333333F30A815741CDCCCCCC515A2541CDCCCCEC0D81574100000000575A2541CDCCCCCC0F8157419A9999996F5A25419A9999591881574166666666715A2541000000001A81574100000000755A2541666666261D815741CDCCCCCC885A2541CDCCCC0C228157419A999999C65A25419A999959308157419A999999EA5A25419A9999193981574133333333015B25419A9999F93E8157419A999999045B25410000000040815741333333330B5B25419A9999394281574166666666155B254166666666468157419A999999225B254166666606498157419A999999825B2541333333B36381574100000000E75B25419A9999397F81574133333333F05B2541000000C081815741CDCCCCCCF95B254133333373848157419A9999991A5C2541CDCCCC6C8D815741CDCCCCCC185C2541666666C68E8157419A9999991D5C2541CDCCCCEC9281574100000000225C25416666666694815741333333333B5C2541333333139D81574166666666565C254166666666A5815741666666666D5C254166666666AC81574100000000725C2541CDCCCC0CAE81574166666666805C254100000060B3815741CDCCCCCC835C254166666686B481574133333333915C254100000060B9815741CDCCCCCC925C25419A999919BA815741666666669C5C2541000000C0BE815741CDCCCCCCA35C2541CDCCCCECC281574100000000A75C25419A999939C581574166666666B45C25419A999919D281574133333333C05C25419A999979E481574166666666C15C2541333333D3E6815741CDCCCCCCC15C2541333333D3EC815741CDCCCCCCC25C254100000060F281574100000000C55C254166666646F68157419A999999C85C2541CDCCCCCCF981574166666666CD5C2541666666C6FC81574166666666D35C254100000080FF81574100000000DA5C2541666666660282574166666666DF5C2541CDCCCCCC0482574133333333E65C2541000000E006825741CDCCCCCCED5C2541CDCCCCCC08825741CDCCCCCCF65C2541333333B30A82574100000000015D2541CDCCCC4C0C82574133333333095D2541000000C00D82574100000000135D2541000000200F8257419A9999991A5D2541CDCCCC8C1082574100000000205D25419A99993912825741666666664D5D25410000004024825741333333334E5D25410000008025825741000000004E5D25419A99995927825741CDCCCCCC405D25413333333329825741CDCCCCCCA75C2541666666063D82574133333333535C25419A9999F94782574100000000295C2541000000604182574100000000255C2541333333B34082574166666666175C25410000008042825741666666660A5C2541000000004482574166666666D95B2541CDCCCCAC4A82574100000000AF5B2541333333734F82574100000000845B25413333335354825741CDCCCCCC4E5B25419A9999195A82574166666666195B2541CDCCCCEC5F825741CDCCCCCC755A2541666666C671825741666666662D5A2541666666C67982574100000000165A2541000000007D82574166666666F7592541000000608082574133333333B5592541333333538B8257419A9999998A59254166666666928257416666666650592541666666269D82574166666666D5582541CDCCCCCCB382574100000000C958254100000020B6825741333333338358254100000040C3825741333333336F5825419A999959C68257416666666678582541CDCCCC4CC78257419A999999AB58254100000040CC8257419A9999990C592541333333B3D4825741333333334A592541333333D3D9825741CDCCCCCC63592541333333F3DA825741CDCCCCCC6B59254133333353DB825741000000008B5925419A999939DC8257419A9999999D59254133333373DC82574100000000B15925419A999999DC82574133333333C0592541CDCCCC8CDC82574133333333CA5925419A999979DC82574166666666D15925419A999939EC82574166666666DF592541CDCCCC6CEE82574100000000EC5925419A9999F9F0825741CDCCCCCC035A254100000040F582574133333333155A25419A9999B9F982574133333333255A2541000000A0FD82574133333333255A254133333393FF82574166666666225A25413333335301835741CDCCCCCC225A2541333333F308835741CDCCCCCC2A5A25419A9999790C83574100000000395A25419A9999F90F835741CDCCCCCC455A254100000080128357419A999999605A2541CDCCCC6C1483574166666666735A2541CDCCCC8C168357419A999999845A2541333333B3188357419A999999885A2541333333B3198357419A999999B65A2541333333131F8357419A999999DA5A2541666666E62183574100000000FA5A2541333333932383574133333333105B2541000000202783574100000000275B2541333333D32A83574100000000355B25419A9999D92B8357419A999999485B25419A9999992C8357419A999999605B2541000000C02D835741333333337F5B254133333333308357419A999999825B25419A9999793083574166666666AF5B25419A9999393483574166666666CF5B254133333393378357419A999999D55B25419A99995938835741666666661B5C25410000000041835741666666662D5C254133333353438357419A9999993F5C2541666666A645835741333333335B5C2541CDCCCC2C4983574100000000745C2541000000604C835741666666660D5D2541CDCCCC6C5E8357419A999999765C2541000000806F8357419A999999705C254133333333708357419A999999415C25416666668675835741333333332B5C25410000000078835741CDCCCCCC125C2541666666E6798357419A999999FC5B2541666666467B83574166666666E25B2541333333737C83574100000000C85B2541333333B37D8357419A999999A75B2541CDCCCC0C7F835741333333337F5B254100000020828357419A999999425B25419A9999798583574166666666335B2541CDCCCCCC85835741CDCCCCCC165B2541666666868583574100000000FF5A2541333333738483574166666666BC5A25419A9999B97E83574166666666AD5A2541666666A67D8357419A999999975A2541000000A07B83574100000000A4592541666666C6858357419A999999785925419A99999987835741CDCCCCCC44592541333333D39A8357413333333311592541CDCCCC0CAC8357419A999999FE582541666666A6B183574133333333F158254166666626B483574166666666E558254133333353B683574166666666A15825419A9999D9A78357419A9999999C582541CDCCCCCCA68357419A9999998B5825419A999939A3835741333333337A582541666666869F83574133333333755825419A9999799E835741CDCCCCCC6A582541CDCCCCCC9B835741CDCCCCCC4F58254133333313928357419A99999945582541CDCCCCCC8E8357419A99999938582541CDCCCC4C8A8357419A99999929582541000000808583574166666666185825419A9999798083574100000000095825419A9999797B83574100000000F8572541CDCCCCEC7583574100000000E1572541666666A66F83574166666666CE572541CDCCCC4C698357419A999999BD5725416666662662835741CDCCCCCCAE572541333333935C835741333333339D572541CDCCCCEC568357419A9999998B572541CDCCCCCC51835741333333337A572541000000604C83574100000000675725419A9999B9458357413333333353572541666666863E83574100000000425725416666662638835741CDCCCCCC2A572541000000C030835741CDCCCCCC1457254133333373298357419A9999990C572541000000C02683574166666666F5562541333333F31E835741CDCCCCCCE556254133333393188357419A999999D2562541333333F31183574100000000BF562541000000600C8357419A999999A7562541000000A0068357419A99999991562541CDCCCCCC018357416666666670562541CDCCCC2CFC82574166666666585625419A9999B9F88257419A9999993F5625419A9999F9F5825741CDCCCCCC285625419A999979F382574133333333F155254100000040EF825741000000009A55254100000040FE825741000000005D552541666666C608835741CDCCCCCCE0542541CDCCCC2C1E83574133333333D7542541CDCCCC4C218357419A999999C65425416666664624835741CDCCCCCCA8542541333333F3288357419A9999998A5425419A9999B92D83574100000000535425413333333336835741333333334B5425419A99995937835741000000003E5425419A99995939835741CDCCCCCC12542541333333334083574133333333E9532541CDCCCC4C4883574166666666D0532541000000604D835741CDCCCCCCBC5325410000008051835741000000008D532541333333335B83574133333333745325410000008060835741CDCCCCCC6E532541333333B3618357413333333365532541666666C6638357410000000044532541333333336A8357410000000018532541000000206683574133333333CE522541000000C05D8357416666666683522541666666C654835741	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	01010000206A080000D8E19FADC46525419A9999F9907E5741	660080101	H	Plage et Écarts	6600801	66008	66	76	53
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	01010000206A0800006077E0923F6825413333334324815741	660080103	H	Massane Nord	6600801	66008	66	76	2
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	01010000206A08000084232AECD2702541333333E38D7F5741	660080104	H	Périphérie Sud	6600801	66008	66	76	3
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	01010000206A0800007C5739FED4732441000000E04B765741	660090000	Z	Arles-sur-Tech	6600900	66009	66	76	29
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	01010000206A080000914CBD8DDF52234100000020BF815741	660100000	Z	Ayguatébia-Talau	6601000	66010	66	76	30
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	01010000206A0800008294228DF315254133333393FF865741	660110000	Z	Bages	6601100	66011	66	76	12
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	01010000206A080000D1D9F33D21E92441333333A3C2915741	660120000	Z	Baho	6601200	66012	66	76	8
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	01010000206A080000E03135F01C29244100000000D2825741	660130000	Z	Baillestavy	6601300	66013	66	76	18
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	01010000206A0800009D23031FC2DF2441666666C6D2955741	660140000	Z	Baixas	6601400	66014	66	76	19
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	01060000206A08000001000000010300000001000000C20000009A99999956F52441CDCCCCCCB2835741CDCCCCCC46F62441666666E6BC83574100000000A9F62441000000A0C18357416666666600F7244100000080D083574133333333FEF6244133333333D8835741333333339EF7244100000060E483574133333333E5F724419A9999F9E583574100000000F1F724419A999959DA8357416666666615F8244166666686DB83574100000000F5F8244100000040F48357416666666642F92441CDCCCC4C0784574100000000E3F92441333333F302845741000000005AFA24419A999939FD83574100000000B9FA244166666686F4835741CDCCCCCC00FB24419A999919F0835741CDCCCCCC83FB244133333393ED835741CDCCCCCC7AFC2441CDCCCC0C018457413333333339FD24419A9999D91B84574166666666DAFC24419A9999192F845741CDCCCCCC10FD244100000000398457419A999999E1FC2441CDCCCC0C3F8457410000000076FD244100000040538457419A9999990CFD2441000000C0608457413333333321FD244100000080628457410000000090FD24410000006071845741CDCCCCCCB7FD244133333313708457410000000019FE2441333333F364845741CDCCCCCCB8FD24419A999999568457410000000026FE2441CDCCCC6C4D8457419A99999979FF24419A99995935845741CDCCCCCCCD002541333333331F845741CDCCCCCCFA002541666666A61C845741CDCCCCCC6F0125419A9999B92A84574133333333DF012541333333D31B845741CDCCCCCC1B022541000000202584574100000000A90225419A9999F9128457419A99999936032541000000400684574100000000190325419A99995904845741666666666B032541666666E6F48357416666666627042541CDCCCC8CCE83574166666666C1042541CDCCCCCCC08357419A999999E6052541CDCCCC2CA5835741666666664F072541CDCCCCEC96835741666666665C072541CDCCCC8C8D83574166666666AE072541CDCCCC8C85835741CDCCCCCC400825416666660682835741CDCCCCCC680825419A99993983835741666666667E092541000000409E83574166666666D5092541CDCCCCECA8835741CDCCCCCC620A2541CDCCCCECB6835741CDCCCCCC400B25419A999959D883574166666666EF0B2541CDCCCC4CF6835741CDCCCCCC100C254100000080FA83574166666666060D254166666626138457419A999999950D2541000000E01D84574100000000E70D2541333333132684574133333333510E25419A9999B92E84574100000000920E2541CDCCCC0C2084574166666666D00E2541666666861C84574100000000FA0E2541000000C00D8457419A9999994D0F2541000000A000845741333333337A0F254100000020F783574100000000D10F25419A999959F08357413333333337102541666666E6DC8357413333333386102541333333F3D2835741000000001E112541666666C6C28357419A9999996811254100000060B783574133333333871125419A9999B9B08357419A999999BE11254133333353AE8357419A99999920122541CDCCCC2CA7835741333333330E132541333333D31D835741CDCCCCCC0F1425419A9999B99182574100000000711425416666664669825741333333337715254133333313FF815741CDCCCCCC9216254133333393A18157410000000078162541CDCCCC0C9F815741CDCCCCCC4A16254133333373A1815741333333330F162541666666C69F8157419A999999C01525413333333398815741666666667B1525419A99999966815741666666667B1425419A999959258157413333333385132541CDCCCCCC02815741000000003413254100000020FC80574100000000B4122541333333B3EE805741CDCCCCCCA51125419A9999F9E780574133333333DF1025419A999999E4805741CDCCCCCC6C102541CDCCCC0CDF8057419A999999191025419A9999D9D9805741CDCCCCCCE80F254166666666D5805741CDCCCCCC930F254100000020CB80574166666666220F2541666666A6C1805741666666666F0E2541CDCCCC0CB880574166666666F60D2541000000C0B0805741666666661B0D254166666646A6805741CDCCCCCC600C2541333333D396805741CDCCCCCCE90B2541CDCCCCAC8A8057419A9999999A0B2541666666A67E8057419A9999994A0B2541333333537580574100000000AC0A2541CDCCCCEC5E8057419A9999994A0A2541CDCCCC4C66805741CDCCCCCCCA0925419A9999196E805741CDCCCCCC65092541000000E072805741000000000F092541CDCCCC4C7A8057413333333386082541CDCCCC8C8C8057416666666666082541666666868F8057413333333313082541CDCCCCAC908057419A999999E5072541333333339480574100000000BE072541CDCCCC8C9C805741CDCCCCCCA70725419A9999799E8057419A9999992C07254100000040A4805741CDCCCCCCFF06254133333313AE80574166666666D406254133333373AF8057419A999999930625419A999939AC805741000000007F062541000000A0B58057419A99999961062541333333F3B8805741CDCCCCCC1D062541666666A6BA80574166666666CD052541666666A6B7805741000000004B05254100000040B7805741666666667804254133333313AD80574133333333AF032541000000809E8057410000000099032541000000E09D8057419A9999996E03254100000000A2805741CDCCCCCCFF02254100000040A98057419A999999DB022541666666E6AE80574100000000F8012541000000A09E80574133333333C001254100000080B2805741CDCCCCCC81012541666666A6A98057419A999999FB002541666666869F805741333333336A002541CDCCCCCC978057419A99999939002541333333938E8057419A99999926002541CDCCCC8C938057416666666622002541CDCCCC6C9D80574166666666FEFF2441CDCCCC2CA28057419A99999930002541CDCCCC2CAB8057419A9999991E00254133333353AE8057419A9999996CFF2441000000C0ED805741666666664CFF24419A999979F88057416666666620FF24413333333302815741CDCCCCCCD3FE2441000000E00B8157410000000097FE24419A99995911815741000000003EFE2441000000201581574100000000C1FD2441000000C0178157419A9999996EFD2441333333331E815741000000004BFD2441666666E62481574133333333D2FC244100000080428157419A99999936FC24410000004065815741CDCCCCCC08FC2441666666666E81574100000000E3FB2441CDCCCC6C788157419A9999992EFC24419A9999197A815741666666667CFC2441000000E08481574100000000A1FC244100000000908157413333333318FD244166666626A181574133333333B1FD2441CDCCCCACB881574133333333E6FD2441333333F3C2815741CDCCCCCCEDFD244100000060CD81574100000000DBFD244133333333DA81574166666666B9FD2441666666E6E98157413333333337FD2441CDCCCCACFE815741CDCCCCCC19FD2441CDCCCC6C058257419A99999910FD2441000000200F825741000000003FFD2441CDCCCC2C118257413333333357FD2441333333D314825741666666660AFD24419A999919198257419A99999992FC244133333353248257419A999999C2FB2441000000E0388257416666666692FB2441666666A63E825741000000004BFB2441333333D34982574133333333E5FA2441CDCCCCAC5482574100000000EEFA2441CDCCCC2C5D8257419A999999AAFA2441333333B3648257419A9999999DFA2441333333D36F8257419A99999983FA2441000000C075825741000000002EFA2441333333738E82574133333333F8F9244166666686938257419A999999E2F92441666666469882574100000000A7F9244100000060AE825741000000006FF92441000000C0BB825741000000006AF9244100000020C5825741CDCCCCCC7CF9244166666686CF82574166666666D5F924419A999999E48257419A99999926F92441CDCCCC4CEB825741666666660DF9244100000040F682574100000000F6F8244166666666F582574100000000CEF82441000000800A8357416666666674F82441CDCCCC4C218357413333333321F824410000002028835741CDCCCCCCADF72441CDCCCC0C3783574166666666BDF7244166666646428357419A9999996AF72441666666A64E835741CDCCCCCCDDF624413333331368835741CDCCCCCC2FF62441CDCCCC0C8C83574166666666B3F5244133333353A08357419A99999956F52441CDCCCCCCB28357419A99999956F52441CDCCCCCCB2835741	01010000206A080000706105A18C072541666666C667825741	660150000	Z	Banyuls-dels-Aspres	6601500	66015	66	76	11
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	01010000206A0800008A89A9CDBF9425419A999969FA765741	660160101	H	Ouest	6601601	66016	66	76	36
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