SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep70;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep70 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep70','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep70','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep70','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep70"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01060000206A080000010000000103000000010000008F0000003333333313CB2C41CDCCCCACCFBE59419A9999992BCB2C4166666606E9BE59413333333390CB2C41333333531BBF5941CDCCCCCCD8CB2C41CDCCCC0C49BF59419A999999C7CB2C419A99997951BF594166666666D8CD2C41000000C078BF5941CDCCCCCC97CE2C416666666687BF59419A9999994ED02C41666666269DBF59419A9999991DD12C41666666C6ABBF59410000000064D22C4166666646BBBF5941CDCCCCCCD2D32C41CDCCCCECD7BF5941CDCCCCCC18D52C41CDCCCCACEABF59410000000004D62C41CDCCCCECF6BF594133333333D6D62C41CDCCCC4C01C0594166666666E7D62C41666666C6FBBF5941CDCCCCCC8CD72C41666666A613C0594166666666DDD82C416666662642C059410000000066D92C413333339354C059410000000017DA2C41000000A084C059413333333356DA2C41CDCCCC0C58C059416666666695DA2C419A9999F93AC059419A999999E7DA2C41000000C02AC059410000000074DB2C41CDCCCC4C1EC0594166666666E0DB2C41666666E616C059419A9999991ADC2C419A99993905C05941CDCCCCCC75DC2C41CDCCCCCCE7BF5941333333339ADC2C41CDCCCCECD2BF5941333333335ADD2C419A9999D97ABF5941000000000FDE2C41333333F36ABF59410000000078DE2C41000000C05FBF5941CDCCCCCCC0DE2C410000004055BF594166666666E8DE2C419A9999B947BF59419A99999917DF2C41333333B330BF59419A99999972DF2C419A9999992EBF59419A999999EBDF2C419A9999D930BF594133333333ABE02C41CDCCCCEC2EBF59419A999999ECE02C41666666862FBF59410000000057E12C419A9999F935BF594166666666A0E12C41CDCCCC4C3CBF594166666666D9E12C410000000045BF5941666666669FE22C416666664622BF59413333333340E32C41333333D306BF5941CDCCCCCC12E42C4100000020E6BE59410000000057E42C41333333B3E0BE5941CDCCCCCC55E42C4133333353DDBE5941333333337CE42C4166666606D2BE59413333333377E52C41CDCCCC0CAEBE59419A99999990E52C4133333373A8BE59410000000015E62C416666668686BE59419A999999B6E62C41CDCCCC4C5CBE594100000000CBE62C410000000058BE59416666666601E72C413333339351BE59419A9999991CE72C419A9999D92ABE59416666666612E82C41CDCCCCCC2ABE5941CDCCCCCC14E92C419A9999F90FBE59410000000062E92C416666660606BE594100000000D8E72C41666666E6E6BD5941CDCCCCCC93E72C419A999939DCBD59419A9999996AE72C4166666646D3BD5941CDCCCCCC8EE82C419A999999A8BD59419A99999920E82C41333333F398BD594100000000D2E72C41CDCCCCCC8EBD5941CDCCCCCC83E72C41CDCCCC2C87BD59416666666644E72C413333331383BD59416666666622E72C41000000007FBD59410000000070E62C416666662670BD59419A99999907E62C41CDCCCC4C65BD59419A9999993AE52C41CDCCCC2C74BD5941666666661EE52C416666664671BD59419A999999B4E52C41666666E660BD5941CDCCCCCC18E52C41000000A053BD59416666666694E42C41333333D368BD59419A9999992CE42C419A99995960BD59419A9999993DE42C41333333D35CBD59416666666669E32C41CDCCCC8C4FBD5941CDCCCCCC5BE32C41333333B348BD594133333333F8E22C410000000042BD5941666666661DE22C41666666262BBD59416666666666E12C413333339312BD59413333333390E12C419A9999790CBD5941666666666DE12C41000000A007BD59413333333383E12C41666666E603BD59416666666639E12C4133333353FDBC5941000000000DE12C41666666C6FCBC59413333333377E02C41000000C00DBD59416666666659E02C419A9999D90ABD59413333333359DF2C41000000402DBD59413333333330DF2C41CDCCCCCC31BD59419A99999970DF2C419A99995938BD5941CDCCCCCC46DF2C41000000E03DBD5941CDCCCCCC5EDE2C416666668623BD5941CDCCCCCC40DE2C41CDCCCC8C23BD59416666666614DE2C413333333337BD5941CDCCCCCCB2DD2C41333333532DBD5941CDCCCCCCD7DC2C41333333B313BD59419A999999B0DC2C41000000801CBD594100000000B7DB2C419A9999B943BD59419A99999956DB2C413333331355BD59416666666624DB2C410000006051BD594133333333BEDB2C41CDCCCC6C37BD59410000000069DB2C41000000802FBD59419A999999C2DA2C41CDCCCC4C4FBD5941333333338EDA2C41CDCCCCCC49BD5941000000005CDA2C419A9999D955BD59416666666694D92C41333333934BBD5941666666665ED92C416666666662BD59419A999999DCD82C416666666660BD5941333333330BD82C41666666465EBD59416666666646D72C419A9999195EBD59419A99999916D72C419A99997966BD5941CDCCCCCC02D72C41000000C067BD59419A999999E0D62C419A99995980BD594100000000E8D62C410000004097BD594166666666C2D62C41666666C6B7BD59419A99999954D62C419A9999F9D5BD594100000000CDD52C4166666686D7BD594133333333A3D52C41000000C0D9BD5941CDCCCCCC51D52C41666666E6E2BD594133333333B2D42C4133333393F2BD59419A999999CDD32C41000000C0D1BD5941CDCCCCCC1FD32C4166666646BBBD5941CDCCCCCCE0D22C41000000A0B4BD594133333333B8D12C41CDCCCC2CAABD59416666666678D02C4166666646A9BD5941CDCCCCCC6ACF2C41CDCCCC0CACBD594100000000AFCE2C4100000080B5BD5941CDCCCCCC84CE2C41CDCCCC6CBBBD59416666666646CE2C41000000C0BBBD59419A99999924CE2C419A999999D8BD594133333333CBCD2C4133333333E7BD5941CDCCCCCCA4CD2C419A999979FCBD59419A99999922CD2C4100000020FABD5941CDCCCCCC54CC2C4100000020F3BD59416666666604CC2C419A999939F3BD5941CDCCCCCCD0CB2C419A9999F915BE5941CDCCCCCC45CB2C41CDCCCC8C3BBE59416666666617CB2C41333333335ABE5941333333331CCB2C410000000061BE59410000000040CB2C41CDCCCCEC7BBE59419A9999995ECB2C41000000E09EBE59416666666650CB2C41CDCCCCCCADBE59413333333313CB2C41CDCCCCACCFBE59413333333313CB2C41CDCCCCACCFBE5941	01010000206A080000582BE39C16D82C4133333363BFBE5941	700010000	Z	Abelcourt	7000100	70001	70	27	8
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	01060000206A08000001000000010300000001000000BF000000CDCCCCCC5E172C41000000201BB9594133333333D1172C416666664627B95941CDCCCCCCA9182C41333333B33BB9594166666666F1182C41CDCCCC4C43B95941CDCCCCCC1C192C41333333134FB959410000000035192C41CDCCCC4C5AB95941CDCCCCCC73192C41666666C66AB959419A99999975192C416666664678B95941CDCCCCCC4D192C419A9999D97DB959410000000063192C41000000408AB959416666666659192C41666666C691B959410000000043192C41CDCCCC2C96B959413333333314192C41333333939AB959416666666648192C4166666646AFB95941333333338A192C41666666E6BFB959413333333371192C41CDCCCC0CC8B959413333333376192C41CDCCCCACE0B959413333333381192C4166666626EAB95941CDCCCCCCD6192C4100000020F7B959419A999999011A2C4166666606FCB95941333333332E1A2C41666666C604BA5941000000008F1A2C419A9999191ABA594166666666C11A2C41333333D326BA594100000000E81A2C41666666C632BA5941CDCCCCCC351B2C41666666463FBA59419A999999531B2C41CDCCCC2C41BA5941CDCCCCCC7D1B2C41CDCCCCEC4ABA594100000000B71B2C41000000C05ABA594133333333CC1B2C41000000E066BA5941333333334E1C2C419A9999B98BBA5941CDCCCCCCEA1B2C41000000E094BA59419A999999B91B2C41CDCCCCAC9DBA594100000000EA1A2C4100000060BEBA5941000000005F192C410000008003BB5941CDCCCCCCD5182C41000000A02BBB5941CDCCCCCC201A2C41000000C03CBB594133333333B3192C413333339353BB594166666666AF1A2C413333335363BB59419A999999D01D2C41666666869BBB59419A999999131E2C419A9999D9A3BB594133333333C01D2C4166666686B1BB594166666666C01D2C4166666626B6BB5941CDCCCCCC081E2C41000000C0C1BB5941666666664C1E2C419A999919C7BB594166666666451E2C419A999979E0BB59419A999999641E2C4133333373F4BB594133333333E81E2C41666666460DBC594100000000FD1E2C410000004017BC5941333333336C1F2C41000000E029BC5941333333330A202C419A99995933BC594166666666FE202C419A9999B951BC59419A999999AE212C41CDCCCCAC64BC594166666666BD212C41CDCCCC0C6ABC594133333333E4222C419A99997986BC5941CDCCCCCCFF232C4166666666A3BC594100000000CB232C4133333393B4BC594133333333B8232C4133333313C6BC59413333333354242C41CDCCCC8CCFBC5941333333336D252C41CDCCCC8CDEBC59419A9999999A252C41666666C6E4BC594100000000D9252C4133333393E8BC59419A999999F9252C41CDCCCC8CE5BC59416666666647262C419A999939ECBC5941CDCCCCCCCE262C4133333333D9BC59413333333314272C4166666666D0BC59410000000068272C41CDCCCC0CB8BC59419A999999BA272C41000000409EBC59416666666661282C419A9999D96FBC59416666666688282C41666666A66BBC59419A9999998A2A2C41333333B38BBC5941333333339F2A2C416666660680BC594100000000D02A2C41000000C07ABC594100000000F12B2C41CDCCCCEC66BC59419A999999AD2C2C41333333B376BC594166666666CB2C2C410000004074BC5941CDCCCCCCF32C2C41CDCCCC6C6CBC5941CDCCCCCC082D2C419A99995965BC59419A9999992B2D2C419A99999963BC594133333333FC2D2C419A99997968BC5941000000004A2E2C413333333366BC594133333333742E2C419A9999D95EBC594166666666B82F2C41666666064CBC59419A99999950302C419A9999F96CBC5941CDCCCCCC7E302C41000000A065BC594166666666C9312C419A9999D97DBC5941CDCCCCCCDC312C41000000E07BBC5941333333335E322C41666666A687BC5941CDCCCCCC96322C41000000C085BC594166666666C0322C413333335396BC59419A999999D9322C419A9999D99CBC59410000000030332C41666666E6A6BC59416666666658332C41666666E6A7BC5941333333332C342C419A9999197EBC59413333333321352C419A9999D950BC59410000000056352C41CDCCCCAC4EBC59419A999999C7352C419A99991959BC59419A99999917362C41666666E65DBC59410000000042362C419A9999F95EBC5941000000005E362C41333333135BBC59416666666623372C41000000A02BBC59419A999999D6372C419A9999F909BC5941666666662A392C41CDCCCC8C15BC59419A999999293A2C41666666C61DBC5941666666668C3A2C41CDCCCC8C02BC594166666666A93A2C4166666686DFBB5941666666661B3A2C41CDCCCC8CDABB5941000000008D392C4133333353CDBB59410000000057392C41666666C6C2BB5941000000003A392C41666666A6B6BB59410000000052392C41CDCCCC4CA7BB5941666666668F392C413333333391BB594100000000A7382C41CDCCCC2C96BB594133333333E5372C41CDCCCC0C4CBB59416666666693372C419A99991920BB594133333333FD362C41333333D3FEBA5941CDCCCCCC22372C4133333353EEBA5941CDCCCCCC38372C41CDCCCCCCDABA59413333333358372C419A999999CFBA594100000000CF362C41333333D3C9BA59419A999999F9362C4166666686ADBA594133333333DF342C410000004084BA59416666666608352C419A9999997DBA594100000000E4342C41000000C073BA5941CDCCCCCCC5342C41CDCCCCCC6EBA5941CDCCCCCC1A342C410000000060BA5941000000001A342C41000000C054BA59410000000072342C41CDCCCCAC36BA5941333333337B342C41CDCCCC6C2BBA59419A99999928342C41CDCCCC0C21BA5941000000000F342C41333333B318BA59419A99999966332C419A99993909BA59413333333345332C41666666060CBA59410000000013332C41CDCCCC6C0CBA5941333333332B322C419A9999590ABA59410000000081312C419A9999790BBA594100000000CE302C41666666A603BA5941333333335B302C4133333373FCB95941CDCCCCCCA22F2C419A9999D9F9B95941333333335A2F2C41CDCCCCECF9B95941666666661E2F2C41333333F3F5B95941CDCCCCCCD72E2C4166666606ECB9594100000000D22D2C4133333393CFB959419A999999592D2C4133333373C9B9594100000000F52C2C4133333353BEB959419A999999722C2C419A999939B8B95941CDCCCCCCE52B2C4100000060A9B95941CDCCCCCC6D2B2C4166666686A9B959419A9999994F2B2C41CDCCCC0CA7B95941333333331D2B2C419A9999599EB959419A999999D62A2C41333333F396B9594100000000862A2C41666666068DB95941CDCCCCCC5C2A2C419A9999597AB95941666666663E2A2C410000006075B95941666666669E292C41CDCCCC4C74B959416666666608292C419A9999B970B959419A999999E0282C410000004073B9594100000000C3282C416666664678B959416666666669282C41000000A07EB959419A999999E7272C416666660680B959416666666697272C419A9999597CB959419A99999901272C41666666867CB9594166666666BB262C419A9999197AB95941CDCCCCCC6A262C41CDCCCC6C71B9594133333333CD252C413333331371B959419A99999942252C41666666C67DB959410000000074242C41333333937BB959419A99999970232C41000000A07EB959413333333315232C41CDCCCCCC87B95941CDCCCCCC31222C413333333375B95941CDCCCCCC9C212C41666666C663B959410000000043212C41000000005CB959416666666669212C416666668651B959410000000069212C419A99999949B95941CDCCCCCC80202C410000002028B959419A99999911202C410000008015B9594166666666F21E2C419A999939F9B8594100000000DF1D2C4166666626E9B85941000000004E1C2C41333333D3D6B859419A9999994E1C2C4133333353DEB859419A999999301C2C419A999959DEB85941000000008F1B2C41CDCCCC6CD9B8594166666666631B2C41333333F3F3B8594166666666091B2C4100000000F3B859413333333307192C4100000080E3B8594166666666FB182C4166666606E9B8594166666666DB182C41CDCCCC6CECB859410000000090182C419A999919E8B85941CDCCCCCC40182C41CDCCCCACF4B859419A999999D4172C41666666860CB95941CDCCCCCC5E172C41000000201BB95941CDCCCCCC5E172C41000000201BB95941	01010000206A0800008BAFF8CA9E282C4100000090E4BA5941	700020000	Z	Aboncourt-Gesincourt	7000200	70002	70	27	11
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	01010000206A080000D64A1EBA56582B4134333323EFA45941	700030000	Z	Achey	7000300	70003	70	27	7
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	01010000206A08000074CA969BCF1B2D419A9999A9AFB55941	700040000	Z	Adelans-et-le-Val-de-Bithaine	7000400	70004	70	27	17
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	01010000206A0800001C356941E6322D41000000B0F8A85941	700050000	Z	Aillevans	7000500	70005	70	27	6
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	01010000206A08000000FBFF83D9F82C419A9999C90BCE5941	700060000	Z	Aillevillers-et-Lyaumont	7000600	70006	70	27	37
01060000206A08000001000000010300000001000000D80100009A9999997D0A2D41333333D315B8594100000000CC0A2D41CDCCCCEC20B8594133333333160C2D410000002052B8594133333333950C2D419A9999D98BB85941CDCCCCCC0C0D2D4100000000C1B859419A9999993B0D2D419A9999F9D9B8594133333333CC0C2D41333333D3DBB859419A999999CB0C2D419A999999E4B8594166666666F90C2D41000000A021B95941666666660D0D2D419A99999921B95941CDCCCCCC840D2D419A9999F919B95941CDCCCCCC990D2D419A9999F927B95941CDCCCCCC740D2D413333337330B9594166666666BC0D2D41CDCCCC0C45B9594100000000F30D2D41333333D351B95941666666667C0E2D416666664674B9594133333333D90E2D410000006088B95941000000000A0F2D41CDCCCC4C9AB9594133333333600F2D4100000040A9B95941333333331A102D41666666A6C5B959419A9999992E102D41000000E0CBB95941333333332F102D4100000060D3B9594166666666FB0F2D41CDCCCC4CE7B959413333333322102D4133333313F1B95941CDCCCCCC10102D41CDCCCC0CF8B95941CDCCCCCC04102D41CDCCCCCC00BA594100000000F00F2D419A9999990BBA59419A999999BB0F2D416666668638BA594100000000D40F2D41000000E052BA5941CDCCCCCCC60F2D41000000205CBA5941CDCCCCCC21102D419A9999F978BA59419A99999940102D419A9999398CBA59419A99999967102D41CDCCCC8C9EBA5941CDCCCCCC770F2D419A999999A7BA594100000000110F2D4100000040A9BA59419A999999030F2D41CDCCCC2CAEBA59419A9999995A0F2D419A999979CFBA5941000000008A0F2D41CDCCCCACCDBA594100000000C30F2D41CDCCCCECCABA594100000000C80F2D41000000C0CBBA5941000000000C102D4133333393D3BA59419A99999960102D41CDCCCC4CDDBA5941CDCCCCCC63102D41333333F3DFBA59410000000061102D41CDCCCCACE2BA59416666666666102D41333333B3EABA59413333333373102D419A9999D9EFBA5941333333337F102D419A999939F7BA59410000000083102D41333333F3FBBA5941CDCCCCCC86102D410000006001BB5941CDCCCCCC81102D41000000401DBB59410000000088102D419A9999D921BB59416666666684102D41CDCCCC8C27BB59413333333384102D419A9999992BBB5941000000009F102D41CDCCCCEC39BB594133333333A7102D419A9999D93BBB594133333333A7102D41666666864ABB594166666666AD102D416666666664BB5941CDCCCCCCBE102D416666664676BB594100000000BF102D419A99999976BB594100000000CB102D41000000C080BB594100000000C7102D419A99995984BB5941CDCCCCCC73102D419A99999997BB5941666666665A102D419A999919A7BB5941333333335F102D419A999999B7BB59413333333367102D4133333353BEBB5941CDCCCCCC68102D41000000E0C0BB59419A9999997D102D4100000000BFBB59419A99999987102D41CDCCCC2CC3BB594166666666A2102D41333333D3CBBB59416666666628112D4100000020C3BB59413333333365112D4100000000BBBB5941CDCCCCCCF0112D41666666C6B4BB5941666666664E122D41000000A0B0BB59416666666679122D4133333373AFBB5941CDCCCCCC91122D4133333313AFBB594166666666A4122D419A999959ADBB594133333333AB122D41666666E6ACBB594133333333C5122D41CDCCCC6CACBB59419A999999DC122D4133333313ABBB594100000000E9122D41CDCCCC2CAABB59419A999999EB122D4100000000AABB5941CDCCCCCC05132D41333333F3AABB59413333333315132D4133333333ABBB59413333333323132D4100000060AABB59419A99999938132D4133333373ACBB5941666666660A142D4100000080C0BB59410000000030142D419A999939C8BB594133333333E9132D4100000020D1BB59413333333376132D4133333313C8BB5941CDCCCCCC3D132D4166666606C9BB59419A9999990C132D4100000060CBBB594100000000F1122D419A999919D2BB5941333333331D132D4166666646DCBB59416666666677122D41CDCCCC0CE7BB59413333333386122D419A9999F9EEBB594166666666D3122D41000000C004BC594100000000F9122D41CDCCCCAC0FBC59410000000072132D419A9999B91EBC594133333333C3132D410000008028BC59419A999999F4132D419A9999392ABC59410000000026142D41333333D329BC59410000000080142D41333333D322BC5941CDCCCCCCDC142D41333333531EBC59410000000013152D416666662621BC59416666666622152D419A9999F92BBC59419A99999908152D419A9999B92BBC5941000000009B142D41CDCCCC2C32BC59413333333361142D419A9999B937BC5941CDCCCCCC18142D41333333533FBC5941000000003E142D419A99993944BC5941CDCCCCCC70142D41CDCCCC6C46BC594166666666A2142D41CDCCCC6C4EBC5941CDCCCCCCB1142D41CDCCCC0C4FBC594166666666C3142D419A9999194CBC59419A99999906152D41333333734BBC59410000000030152D41666666C645BC5941CDCCCCCC48152D41CDCCCCAC3ABC5941CDCCCCCC37152D41666666E633BC59410000000062152D416666664632BC5941000000008C152D41000000E030BC5941CDCCCCCCA7152D41666666462FBC594166666666D3152D41333333B32CBC594100000000EE152D41CDCCCC4C2BBC5941CDCCCCCC11162D41333333132BBC59419A99999919162D41333333132ABC5941666666662A162D413333335328BC59419A99999938162D416666668627BC59410000000050162D413333331328BC59410000000069162D416666660629BC5941CDCCCCCC95162D41CDCCCCCC26BC594166666666B8162D413333331324BC594166666666C0162D41CDCCCCCC25BC594100000000C7162D410000006027BC594133333333C7162D41CDCCCC4C2ABC594166666666D0162D41333333732BBC5941333333330F172D41333333332CBC59410000000022172D41000000002BBC59419A9999992F172D41CDCCCC0C28BC59410000000039172D41333333B325BC5941333333334B172D41CDCCCC2C22BC59416666666659172D416666666620BC5941000000006C172D41333333331FBC59413333333397172D416666666620BC59419A999999C0172D410000002025BC5941CDCCCCCCD1172D41CDCCCCEC27BC5941333333330B182D416666664623BC5941666666663C182D41000000A021BC59419A9999995B182D419A99999921BC59419A9999999C182D419A99997920BC5941CDCCCCCCC6182D41CDCCCC8C1FBC59419A99999911192D41000000C01EBC5941333333339D192D41CDCCCCCC1EBC594100000000FC192D419A9999391FBC5941CDCCCCCC301A2D41000000A015BC59419A999999BB1A2D41666666661ABC5941666666661A1B2D419A9999B91EBC594133333333AE1A2D41CDCCCC6C23BC5941666666667F1A2D41CDCCCC8C24BC5941333333331F1A2D416666664621BC59410000000085192D419A9999592DBC59419A99999996182D419A9999D942BC5941CDCCCCCC55182D410000004048BC594100000000B6182D419A9999B957BC594100000000BB182D41333333335CBC594133333333AF182D41666666A669BC59419A999999B5182D41333333B378BC594100000000BD182D410000000084BC59419A999999D4182D419A9999998DBC5941CDCCCCCCFB182D41333333F399BC594133333333FB182D419A9999599CBC5941333333331D192D419A9999D9A4BC59413333333357192D419A999919A7BC594166666666D0192D4166666666A5BC59419A999999571A2D41333333D3A0BC5941CDCCCCCCC11A2D41CDCCCC2CA3BC5941CDCCCCCC421B2D419A999979AABC594100000000661B2D4100000020ABBC5941CDCCCCCC901B2D41000000609EBC594133333333B01B2D419A9999199FBC59419A999999C91B2D419A9999B99FBC594133333333D91B2D4166666686A2BC5941CDCCCCCCD51B2D4166666606A5BC594100000000EE1B2D4133333393A5BC59419A9999990B1C2D4166666686A6BC5941666666662C1C2D41CDCCCC4CA7BC594100000000501C2D4166666646A7BC594133333333561C2D419A999939A7BC5941000000008E1C2D4100000080A6BC594100000000C11C2D4133333353A5BC594133333333E01C2D4133333393A2BC594166666666F21C2D41333333539EBC5941CDCCCCCC051D2D41000000A099BC59419A9999990F1D2D410000008096BC594133333333221D2D419A99997993BC594166666666461D2D419A9999B98FBC5941CDCCCCCC741D2D41000000A08CBC59419A999999A31D2D41000000408ABC594133333333C91D2D41000000A086BC594133333333F61D2D413333337384BC5941CDCCCCCC161E2D41CDCCCC2C83BC5941000000003A1E2D416666662683BC594133333333621E2D413333337383BC5941CDCCCCCC0F1F2D419A9999399BBC594166666666ED1F2D41CDCCCCACA0BC59419A99999909202D4133333333A2BC59410000000030202D410000006096BC59419A9999997B202D41666666469FBC594166666666F3202D41CDCCCC6CB0BC5941CDCCCCCC35212D4100000080B2BC59410000000082212D41CDCCCCECB2BC59419A999999B3212D41333333F3B3BC594133333333E9212D4133333313B4BC5941000000001C222D4100000040B5BC59416666666653222D41CDCCCC6CB6BC594133333333A2222D41000000C0B4BC5941000000001B232D4133333373B6BC5941000000007F232D4133333353B6BC594100000000E3232D41666666C6B7BC5941CDCCCCCC27242D41CDCCCC0CBABC5941000000005A242D419A999979B9BC59419A999999A6252D4100000000B0BC594133333333CD252D41333333D3B2BC59413333333320282D4100000060D4BC59410000000049282D41CDCCCCACD7BC5941000000004E282D41CDCCCCACD8BC59410000000091282D419A9999D9E8BC5941CDCCCCCCBF282D41000000A0F4BC59416666666627292D416666668604BD594100000000AC292D419A9999D917BD594133333333BB292D41CDCCCCCC19BD5941CDCCCCCC2E2A2D41CDCCCCAC28BD59419A999999A12A2D410000002035BD59419A9999992C2B2D41CDCCCC6C41BD5941333333332C2C2D41CDCCCCAC4DBD5941CDCCCCCC1D2D2D410000004058BD5941000000002C2E2D41000000C064BD5941CDCCCCCC682E2D41333333B368BD594133333333B72E2D413333331370BD594166666666F02E2D410000004077BD59419A9999995A2F2D41CDCCCC6C81BD594100000000C72F2D410000000089BD59410000000029302D41000000C08EBD59416666666667302D419A9999B993BD594133333333B6302D413333339399BD59416666666611312D419A9999F9B2BD59419A9999995A312D4100000040C1BD59413333333301322D41CDCCCCCCC7BD59419A99999975322D4100000060C8BD5941CDCCCCCC04332D41666666A6E4BD59419A99999985332D41000000A004BE5941CDCCCCCCEC332D41CDCCCCEC1BBE59413333333385342D41CDCCCC6C24BE59419A999999C7342D41000000601DBE594100000000EC342D419A9999B9EDBD59416666666650352D4100000000D0BD59413333333399352D41333333B3C4BD594100000000A7352D4133333313BDBD59419A999999F6352D41666666E6ADBD594133333333FD352D41333333B3A4BD594166666666F1352D413333335394BD59416666666699352D41CDCCCC6C91BD59410000000039352D416666664690BD59419A9999998B342D41000000608FBD5941CDCCCCCCE6332D41CDCCCC0C8FBD594100000000BD332D41333333F38EBD594133333333A9332D41666666868EBD5941666666666D332D41CDCCCC0C8BBD594100000000EE322D419A9999B983BD59419A999999B7322D41CDCCCCEC7FBD5941CDCCCCCCAA322D41CDCCCCEC7FBD59416666666695322D41666666867DBD59419A99999970322D41666666067ABD5941CDCCCCCC49322D413333339376BD5941CDCCCCCC3A322D41333333B373BD59416666666635322D41666666C673BD5941CDCCCCCC08322D416666662670BD5941CDCCCCCCFE312D41000000606FBD594100000000F6312D41CDCCCCAC6EBD594100000000EE312D41666666466EBD5941CDCCCCCCCD312D41000000606CBD594133333333C1312D41CDCCCC4C6BBD59419A999999AE312D41CDCCCC6C6ABD5941CDCCCCCCA4312D41CDCCCC0C6ABD59419A99999989312D41333333B368BD5941333333336F312D419A99995966BD5941CDCCCCCC4A312D41CDCCCCAC62BD5941CDCCCCCCFB302D419A9999995ABD594133333333F4302D419A9999D959BD59419A999999EB302D416666666658BD594100000000F0302D41333333D355BD594100000000ED302D41CDCCCCAC55BD5941666666669C302D41666666C64FBD5941666666665F2F2D410000000031BD594133333333162F2D419A99993928BD594133333333CD2E2D41333333B324BD59419A999999AC2E2D413333331321BD59419A9999995C2E2D419A9999191ABD59419A999999F42D2D41666666860DBD5941666666667B2D2D410000000001BD5941CDCCCCCC1A2D2D4100000080E0BC5941CDCCCCCC012D2D41333333D3DBBC594100000000F42C2D4166666646D7BC594133333333692C2D41000000E0B6BC5941666666665A2C2D4166666686B1BC59419A999999E02B2D416666664698BC594100000000AF2B2D41000000E083BC594166666666622B2D410000002055BC594133333333152B2D419A99997933BC59419A999999802A2D413333335317BC594166666666202A2D416666664606BC5941666666661E2A2D416666660600BC594133333333F0282D41CDCCCC4CE8BB5941666666667E282D41CDCCCC0CDFBB594100000000EB272D41000000A0D6BB5941CDCCCCCC19272D41333333F3CBBB5941333333337C262D4100000040C3BB59410000000070262D41CDCCCCCCC2BB5941CDCCCCCCD6252D4100000060B6BB59410000000029252D419A9999B9A7BB59413333333324252D419A9999B9A6BB59410000000022252D41000000A0A5BB59410000000027252D41000000C0A4BB59410000000018242D41CDCCCCCC8BBB5941000000004C232D419A9999197CBB5941CDCCCCCCEA222D41666666E676BB59419A99999975222D419A9999D981BB5941CDCCCCCC4F222D413333335380BB59413333333321222D413333335382BB59413333333323222D41CDCCCC6C70BB594133333333F2212D41666666C66FBB594100000000E9212D419A99991972BB594100000000DB212D410000002072BB59419A999999D1212D410000002072BB594166666666C3212D41666666A66EBB59419A999999B0212D41000000806DBB594133333333A7212D419A9999D96FBB59419A99999994212D41000000A071BB5941666666668B212D41CDCCCCCC72BB59419A99999978212D419A99997970BB5941000000006F212D419A9999B96EBB5941CDCCCCCC65212D410000008070BB5941CDCCCCCC57212D410000004072BB59413333333345212D416666664672BB5941CDCCCCCC3B212D416666664672BB59419A99999932212D413333339377BB59413333333364212D419A9999997FBB59419A99999933212D41000000E083BB59410000000021212D41333333D386BB5941CDCCCCCCF2202D41666666A68FBB594133333333B8202D41CDCCCC0C9EBB594133333333B0202D41666666C6A2BB594100000000AE202D419A999939A4BB5941CDCCCCCC96202D419A999919AABB59416666666676202D41666666A6ADBB59419A99999936202D419A9999D9AFBB594100000000911F2D419A9999F98EBB594100000000A51F2D41000000A08BBB594133333333C21F2D410000000083BB59419A999999AB1F2D419A9999397BBB5941CDCCCCCC06202D41CDCCCC0C6EBB59410000000043202D41000000E073BB5941CDCCCCCC67202D41666666C66DBB5941333333339C202D410000008066BB594100000000C3202D419A99995961BB59416666666664202D413333333354BB5941666666664F1F2D41CDCCCC6C3EBB594100000000281F2D419A9999393DBB594100000000071F2D419A99993938BB5941CDCCCCCCE81E2D41000000A035BB59419A999999D91E2D419A99997935BB5941CDCCCCCCF11E2D41000000002BBB5941CDCCCCCC1B1F2D41CDCCCCCC23BB594133333333371F2D41333333331CBB59419A999999241F2D41000000A01BBB594133333333161F2D419A9999791ABB594166666666031F2D41333333D315BB594100000000031F2D419A9999B911BB5941666666660B1F2D41666666C607BB594166666666CF1E2D41CDCCCC4C04BB59419A999999631E2D41333333F3FCBA5941CDCCCCCC071E2D4100000060F6BA59419A999999081E2D4166666646F6BA5941000000001C1E2D41CDCCCC8CF1BA59419A999999361E2D41333333B3EBBA5941333333334F1E2D4166666626E5BA5941333333335D1E2D41CDCCCC6CE0BA594166666666891E2D41CDCCCC6CD7BA5941CDCCCCCCA51E2D4133333353D1BA594133333333B71E2D4100000040CBBA594100000000CC1E2D41CDCCCCACC0BA594100000000DA1E2D4166666666BABA594166666666DD1E2D41CDCCCCACB5BA5941CDCCCCCCCB1E2D413333337393BA594133333333451F2D41CDCCCC2C7FBA594133333333F81E2D41CDCCCC6C78BA59419A9999997C1F2D41333333935CBA59419A999999D71F2D41000000804ABA594100000000B61F2D41666666A63EBA5941333333333C202D41CDCCCC4C37BA594166666666F8202D41000000802FBA59419A9999992B212D410000006029BA5941CDCCCCCCDA202D419A9999F915BA594100000000A8202D41666666460BBA594100000000F41F2D410000000007BA594100000000C31F2D41666666A6FEB95941333333337E1F2D4100000060EEB95941666666665B1F2D4133333373D5B95941333333334B1F2D41333333B3CCB9594100000000461F2D419A999939C7B959419A999999F91E2D41CDCCCCCCC7B95941000000008E1E2D4166666666C8B95941000000000E1E2D419A9999D9B3B9594100000000C21D2D4166666686A4B95941CDCCCCCC781D2D4166666686A7B95941CDCCCCCC101D2D41CDCCCC8C94B95941CDCCCCCC881C2D41333333B37CB95941CDCCCCCC571C2D416666660671B9594166666666541C2D41CDCCCC4C67B9594133333333701C2D41333333D362B9594100000000581C2D41333333F35CB959419A999999D51B2D41000000E03BB959419A9999998F1B2D419A9999B93DB959419A9999996A1B2D41666666A61DB9594166666666421B2D41CDCCCC6C1CB9594166666666011B2D41000000A020B9594100000000A61A2D41CDCCCC0C2CB95941333333334F1A2D41333333B335B9594133333333121A2D41000000E031B959419A999999C8192D413333331337B95941CDCCCCCC5D192D41000000203FB959416666666633192D419A99997942B95941000000002F192D419A9999B921B959413333333362182D41CDCCCC0C1EB95941CDCCCCCC85182D41333333B30BB95941CDCCCCCC35182D41CDCCCC8C0AB95941666666663F182D416666664604B95941CDCCCCCC7F182D41333333F3F0B85941000000009B182D41CDCCCC0CE3B859416666666654182D4133333373DEB859410000000052182D419A999999DAB859413333333317182D41CDCCCC4CD4B8594166666666ED172D41000000C0CEB859416666666698172D41CDCCCCACC7B85941CDCCCCCC35172D41CDCCCCCCC4B85941CDCCCCCCBA162D419A999939BEB859419A99999979162D41CDCCCC4CBFB859416666666645162D4133333353C3B859419A99999914162D41CDCCCC8CCAB85941CDCCCCCCC2152D4100000080C0B85941CDCCCCCC44152D41000000C0A7B85941333333339E142D419A99995980B859410000000059142D41333333F36FB859416666666606142D41333333535AB8594100000000F6132D416666666655B859416666666636132D413333331359B8594133333333D6122D41000000A065B859419A99999939122D41000000C064B85941CDCCCCCCDF112D416666660665B859419A999999D1112D413333331365B85941000000001E112D41666666C65EB8594133333333E1102D41666666A65CB85941666666667E102D410000006058B859413333333340102D413333337356B85941CDCCCCCCF60F2D419A99995954B85941333333331A0F2D41333333734BB85941CDCCCCCC700E2D41000000404FB859419A999999BB0D2D41333333D351B8594166666666DB0C2D41CDCCCC0C56B85941666666665E0C2D413333335346B8594166666666890B2D41CDCCCC6C2CB8594133333333A90A2D419A9999D911B859419A9999997D0A2D41333333D315B85941	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	01010000206A0800004F781CCCCF172D41CDCCCC0C1BBB5941	700070000	Z	Ailloncourt	7000700	70007	70	27	9
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	01010000206A080000D0BAF6EAF5C32C41CCCCCC4C70C45941	700080000	Z	Ainvelle	7000800	70008	70	27	7
01060000206A080000010000000103000000010000003B02000066666666BD0C2C41666666669BC6594100000000120D2C419A9999B9A2C6594100000000370D2C41000000E0C3C6594166666666540F2C4100000020FDC659419A999999FC122C416666666658C7594166666666DC122C416666666661C75941CDCCCCCC26132C419A99999966C759416666666651132C41CDCCCCCC6BC75941CDCCCCCC7E132C416666662664C759419A999999A8132C41000000C05BC7594133333333C2132C419A99995956C7594166666666D5132C41000000C051C7594133333333E4132C41CDCCCC8C4FC7594100000000F2132C41666666E650C759410000000001142C416666668652C759419A99999913142C416666666654C75941000000002A142C41CDCCCC8C56C75941666666663F142C41CDCCCCAC58C759413333333358142C41666666065BC75941CDCCCCCC63142C419A9999395CC75941666666666B142C41666666A65BC759410000000080142C419A9999995BC759413333333390142C41333333F35BC759410000000092142C41000000E05CC75941333333339A142C41CDCCCC2C60C7594100000000A5142C419A9999B963C759419A999999AE142C410000000067C7594166666666B6142C41333333936AC7594166666666BB142C41CDCCCCCC6DC7594133333333BD142C41CDCCCCEC70C75941CDCCCCCCBC142C419A99999973C75941CDCCCCCCBA142C41000000E076C7594166666666B9142C410000004079C7594100000000B6142C41666666067CC7594166666666B0142C41000000A07EC7594133333333A8142C41666666A681C759419A9999999A142C416666660685C75941666666668D142C410000008088C75941333333337D142C41333333138CC759419A9999996D142C41CDCCCC4C8FC75941CDCCCCCC5C142C41333333D392C75941333333334E142C416666662695C75941CDCCCCCC3D142C41000000E097C759410000000028142C41333333139BC759410000000013142C41333333939DC75941CDCCCCCCF3132C4133333373A1C7594133333333EC132C4100000040A2C75941333333338C142C4166666606BAC75941CDCCCCCCBE142C4133333333C2C759416666666692142C41CDCCCC8CC7C759419A99999977132C4133333373E8C75941CDCCCCCC8C132C4166666606EBC75941000000008C132C41333333F3EBC75941333333334B132C41CDCCCC0CF7C75941000000000E132C41666666E600C8594100000000FC122C41CDCCCCEC05C85941CDCCCCCCAA122C413333339314C859416666666644122C41666666462BC859419A999999ED122C413333331338C859416666666667132C41CDCCCC8C41C8594100000000D0132C41CDCCCC8C4CC859410000000017142C416666664642C85941666666666D142C413333337340C859419A9999992A152C41CDCCCCEC5FC859419A99999925152C41666666A662C859410000000019152C413333337366C8594100000000FB142C41000000806CC8594166666666E8142C41333333F36FC85941CDCCCCCCCD142C410000008072C85941CDCCCCCCBB142C41CDCCCCCC74C8594133333333A9142C41333333B376C859416666666693142C419A99993979C859419A9999997D142C41666666067BC859416666666665142C419A9999B97DC85941CDCCCCCC4F142C41666666A67FC85941666666663F142C419A9999D980C85941CDCCCCCC33142C41CDCCCCAC81C859416666666629142C41333333D381C85941000000001E142C41CDCCCC0C82C859410000000008142C41333333D381C8594166666666FA132C410000008081C8594166666666E7132C419A9999D980C8594100000000D4132C41CDCCCC2C80C8594100000000BD132C41333333337FC859419A999999AA132C41333333B37EC859419A9999999E132C41666666667EC859419A99999986132C41000000207EC859416666666668132C41333333137EC85941333333334F132C41CDCCCC4C7EC85941000000002D132C41666666067FC85941CDCCCCCC02132C419A9999F97FC859419A999999E5122C419A99999980C8594133333333C3122C416666660681C859419A999999D9122C413333339394C85941CDCCCCCCE3122C413333331397C85941333333332B132C419A999939ACC859410000000090132C419A9999D9B9C8594166666666DC132C41000000C0C4C8594100000000D3132C41333333B3C5C85941CDCCCCCCCC132C4100000040C6C85941CDCCCCCCB4132C41000000A0C8C8594166666666A9132C4166666606CAC85941CDCCCCCC9B132C4100000040CBC85941000000008F132C4166666626CCC85941000000007F132C41CDCCCCCCCDC859410000000070132C4133333393D0C85941CDCCCCCC5A132C4133333313D4C85941CDCCCCCC2B132C419A999939DCC859413333333316132C4166666686E0C85941000000000B132C4100000060E2C859419A99999902132C41CDCCCC2CE4C859419A999999EB122C4133333313E8C8594100000000BB122C41000000E0F1C8594166666666AC122C41CDCCCC8CF5C859416666666694122C4100000000FCC85941000000005A122C41333333B30AC959410000000049122C41333333F30FC959419A9999993F122C413333335312C959419A99999933122C416666662617C959419A99999925122C41333333F31CC959419A9999990F122C419A9999B925C95941333333330B122C41666666A627C959410000000003122C41000000002BC959419A999999F9112C410000002030C959419A999999E9112C413333333338C9594100000000DD112C41000000203FC959419A999999D3112C41666666E643C9594100000000CC112C41666666864BC9594100000000CA112C41000000004DC9594133333333C9112C41333333534FC9594166666666CB112C419A99991952C95941CDCCCCCCCD112C413333333355C95941333333338A112C41CDCCCCCC66C9594100000000D1112C41333333F371C95941000000002D122C419A99991991C95941CDCCCCCC7F122C419A9999F9B8C95941CDCCCCCC94122C4133333333C9C9594133333333AF122C419A999999D8C959419A9999995D122C4100000000DEC95941CDCCCCCC6C132C419A999919F6C959419A9999998F132C419A9999D9F6C9594100000000B1132C419A999939F6C9594133333333DE132C419A999919F4C959419A99999913142C41CDCCCC6CEBC959416666666658142C41666666A6E3C95941333333339B142C4133333333DAC9594166666666FC142C4166666646C8C959413333333361152C41666666A6B4C959419A999999A7152C4100000000A4C959419A999999D8152C419A99997995C9594133333333FA152C41CDCCCC0C85C959419A99999918162C41CDCCCCEC80C959413333333323162C419A9999D979C959419A99999949162C410000006072C95941333333337A162C41333333B374C9594100000000B5162C41666666E66BC95941666666661A172C41CDCCCC8C60C95941CDCCCCCC56172C41666666A669C95941000000007E172C419A99997967C959419A9999999C172C41333333F362C9594100000000FC172C41333333535AC95941CDCCCCCC35182C419A9999B954C95941CDCCCCCC8F182C416666668662C95941CDCCCCCCB1182C410000008068C9594100000000FB182C419A9999D963C95941000000005A192C419A9999995DC9594133333333B2192C41CDCCCC6C5EC95941666666660F1A2C419A9999B95DC959419A9999995E1A2C41CDCCCC8C6DC959419A999999221B2C419A9999D969C9594133333333531C2C410000008062C9594166666666091D2C41000000A05FC959419A9999995E1D2C41333333B35EC9594166666666A41D2C41666666466FC95941CDCCCCCCBF1D2C41333333F373C959419A9999990E1E2C413333337373C9594133333333701E2C416666666674C959419A999999B91E2C419A99991977C959419A999999DF1E2C41000000A079C9594133333333EF1E2C419A9999997CC95941CDCCCCCC1B1F2C416666664681C95941666666665B1F2C41CDCCCCAC85C95941CDCCCCCC951F2C419A9999198AC9594166666666C51F2C410000000095C959416666666601202C4166666626A3C95941666666664B202C41CDCCCC8CB6C959413333333377202C41000000A0C3C959419A99999988202C41CDCCCCECC3C959410000000099202C41CDCCCCECC3C9594100000000AB202C4133333333C3C959419A999999CE202C4166666686C2C9594166666666EE202C41333333B3C2C959419A99999915212C41333333D3C3C95941CDCCCCCC33212C419A9999F9BEC959419A99999943212C419A999999BDC959410000000057212C41CDCCCC4CBCC959410000000071212C419A999919BAC95941CDCCCCCC8F212C4133333333B7C9594166666666BD212C4166666686B2C9594133333333E1212C41CDCCCC6CAEC9594166666666F5212C41000000C0ABC95941CDCCCCCC1E222C41CDCCCC8CA6C95941666666668C222C41666666269EC959413333333397222C41000000E0A0C95941666666669F222C4166666646A2C959419A999999B5222C4166666686A5C959419A999999D9222C419A999979A9C959419A999999F1222C41666666C6ABC95941CDCCCCCC02232C4133333373ADC95941333333330C232C4100000060AEC95941CDCCCCCC0D232C4166666686AEC959410000000023232C419A999999B0C95941000000003B232C41CDCCCCECB2C959419A99999956232C41CDCCCC4CB6C9594100000000E8232C41CDCCCC2CAFC95941CDCCCCCC2B252C419A99995993C9594100000000C6252C419A9999398AC959419A999999BB262C41000000E087C95941666666668D272C410000008085C95941CDCCCCCC81272C416666666680C95941CDCCCCCC7D272C41CDCCCC0C7CC95941CDCCCCCC7D272C41333333B37BC95941000000007E272C419A9999F97AC95941000000007E272C419A99993977C95941CDCCCCCC85272C419A9999F971C9594166666666A3272C41CDCCCC8C62C959419A999999BC272C419A99997954C9594166666666D7272C419A99995945C9594100000000F1272C41666666863AC95941333333330D282C413333339330C959413333333329282C41CDCCCC2C2AC95941CDCCCCCC52282C41CDCCCC2C20C959413333333382282C41CDCCCC0C15C959416666666697282C419A9999190FC95941333333339A282C41333333530BC95941333333339B282C416666666607C959419A99999996282C416666664602C959413333333386282C419A999959FDC859413333333367282C419A9999F9F6C859413333333346282C419A9999B9F0C859410000000027282C419A999919EAC859419A9999991D282C419A999959E6C859416666666617282C419A999999E1C859419A99999916282C4100000000E1C85941CDCCCCCC13282C41CDCCCC4CDEC8594133333333FC272C4100000000CCC8594100000000EB272C419A9999D9BAC8594133333333E3272C419A999979B3C859419A999999E3272C41333333B3AAC859419A999999E2272C41000000A0A3C859419A999999E1272C4100000080A2C8594166666666DB272C41666666C69EC8594166666666CD272C419A9999F99BC859419A999999B9272C41CDCCCC0C9AC85941CDCCCCCCA5272C410000002098C85941666666666D272C41333333F391C85941CDCCCCCC43272C41CDCCCC0C8CC859413333333330272C41333333F387C859413333333325272C413333339384C859413333333323272C41666666C681C859419A99999924272C41666666C67DC859413333333331272C419A9999797AC85941CDCCCCCC48272C416666664675C85941666666666B272C419A99993970C859410000000081272C419A9999796CC859419A9999998E272C419A9999F968C859410000000099272C41CDCCCCCC65C859419A9999999E272C413333339363C85941000000009F272C41CDCCCC4C62C85941333333339F272C41000000C060C85941000000009F272C41666666A65EC85941CDCCCCCC99272C41333333335DC859413333333391272C41CDCCCC0C5CC85941333333336F272C41333333D358C859413333333347272C416666662656C859410000000014272C419A99991955C8594133333333F1262C416666666653C8594166666666A4262C41333333334EC859416666666663262C416666668648C85941CDCCCCCC19262C413333335344C8594133333333CB252C416666666640C859416666666686252C419A9999B93CC859410000000040252C419A99997938C859419A999999DF242C410000002031C859416666666671242C41000000C028C85941CDCCCCCC22242C419A99995923C8594166666666EC232C41CDCCCCCC20C8594166666666B2232C41666666061FC859419A99999982232C41333333731DC85941CDCCCCCC53232C41666666A61AC85941CDCCCCCC19232C419A99995915C8594100000000D0222C419A9999790DC859419A9999998D222C413333339304C85941CDCCCCCC57222C4100000000FBC75941666666663D222C41333333F3F2C75941CDCCCCCC37222C4100000020EFC759419A99999938222C4166666686EBC75941666666663D222C41666666A6E7C759413333333349222C4166666606E4C759413333333363222C419A999959DFC759410000000083222C419A999999DBC75941666666669A222C419A999999D8C7594166666666AA222C4100000080D6C759419A999999E2222C419A9999F9D0C75941CDCCCCCCEF222C419A9999B9CFC759410000000028232C41CDCCCC6CCAC75941CDCCCCCC71232C41333333B3C3C7594166666666A4232C419A9999F9BFC75941CDCCCCCCD9232C4100000040B7C7594133333333DA232C41333333F3B6C75941CDCCCCCCDF232C4166666686AEC759419A999999E0232C419A999959A6C759419A999999E0232C41CDCCCCAC9DC7594166666666DF232C410000000097C759419A999999DB232C410000008094C759419A999999DA232C416666668693C75941CDCCCCCCC6232C41666666A68EC7594133333333A0232C41333333F389C75941333333337F232C413333339385C759413333333363232C413333339380C75941333333335C232C41666666667EC759410000000049232C41CDCCCC8C78C759419A99999940232C410000000076C75941CDCCCCCC39232C41333333D373C75941CDCCCCCC24232C413333333370C75941000000001B232C41666666866FC75941CDCCCCCCEC222C41333333F369C75941CDCCCCCCB5222C41666666E662C759419A9999998A222C41000000E05BC75941333333336D222C41CDCCCCAC56C75941333333335E222C419A9999B955C75941CDCCCCCC23222C416666662652C7594100000000CF212C41CDCCCC2C4DC759419A9999999A212C41000000C04BC75941CDCCCCCC74212C41666666864BC75941666666664D212C41666666A64BC7594100000000BB202C41666666264FC759413333333327202C419A99995953C75941000000008E1F2C41666666A657C7594133333333041F2C41333333935BC75941CDCCCCCC801E2C41000000205FC75941333333332E1E2C413333339360C75941CDCCCCCCF11D2C413333339360C75941CDCCCCCCC11D2C416666662660C7594166666666931D2C41000000405FC75941CDCCCCCC4B1D2C41CDCCCC0C5CC7594166666666EF1C2C41CDCCCCAC56C7594133333333981C2C41333333D350C75941CDCCCCCC521C2C41000000A04AC7594133333333161C2C41666666E644C7594133333333E01B2C419A9999F93EC75941CDCCCCCCA61B2C413333333338C75941CDCCCCCC701B2C419A9999392FC7594100000000421B2C41CDCCCC2C25C759419A999999161B2C41CDCCCC6C1BC7594133333333FB1A2C41000000C014C7594133333333F51A2C41CDCCCC4C13C759419A999999EC1A2C41CDCCCC6C12C7594166666666E11A2C410000004011C7594166666666C61A2C41CDCCCC6C0EC7594133333333C11A2C41CDCCCCCC0DC7594166666666A51A2C41000000A00AC75941CDCCCCCC931A2C41000000A008C759419A9999995A1A2C41333333B303C7594166666666231A2C4166666626FFC659419A999999F2192C4133333353FBC6594100000000CB192C419A9999B9F8C659419A9999998A192C4133333373F5C659416666666653192C4133333373F4C659419A99999922192C41000000C0F3C65941CDCCCCCC07192C41666666A6F3C65941CDCCCCCCEB182C419A9999F9F2C6594100000000D7182C4166666666F2C6594133333333C7182C4133333313F1C6594100000000B7182C41000000C0EEC6594166666666A7182C4133333393EAC65941CDCCCCCC99182C419A9999D9E4C659416666666696182C419A9999F9E0C659419A99999999182C41666666A6DDC65941000000009E182C4166666606DBC659419A999999A6182C4166666626D8C6594133333333B5182C419A999979D5C65941CDCCCCCCD7182C41333333B3CFC65941000000000A192C41CDCCCC2CCAC659419A99999954192C41666666E6C1C659419A999999A3192C419A999999B8C659419A999999CE192C4100000060B4C6594133333333DD192C4133333353B3C65941CDCCCCCCF1192C419A999979B2C65941CDCCCCCC081A2C41CDCCCC8CB2C65941CDCCCCCC1B1A2C41000000C0B2C659419A999999421A2C419A999959B4C65941000000004F1A2C41000000E0B5C6594133333333641A2C4133333393B8C659419A999999891A2C4133333353BFC6594100000000AE1A2C41333333D3C7C6594166666666D21A2C4100000060CFC659419A999999E51A2C419A999999D2C65941CDCCCCCCFA1A2C41666666E6D3C65941000000000B1B2C4166666666D4C659419A999999241B2C41CDCCCCECD4C6594166666666431B2C4166666606D5C659419A999999551B2C41333333F3D4C6594133333333571B2C41000000E0D4C65941333333336C1B2C41CDCCCC2CD4C6594166666666841B2C41333333B3D2C65941333333338C1B2C41333333D3CEC659419A9999998D1B2C4166666606CCC65941666666668D1B2C41333333D3C7C6594100000000881B2C4100000020C2C659419A999999781B2C419A999979BCC659419A999999661B2C419A999919B7C659419A999999381B2C41CDCCCCACADC6594100000000F41A2C4166666606A3C65941000000009D1A2C413333335395C6594133333333571A2C41CDCCCCCC8AC6594100000000401A2C41333333B389C65941CDCCCCCC131A2C41000000A086C6594166666666E2192C410000000084C6594133333333B8192C419A99993981C65941333333339A192C419A9999397FC659413333333382192C41333333337DC659419A99999976192C41666666867BC659413333333375192C41666666867AC659410000000075192C410000004077C659416666666675192C419A99993972C659419A99999974192C41666666C66DC659410000000072192C419A9999396BC659410000000071192C41333333B369C65941CDCCCCCC75192C419A9999B967C65941000000007E192C416666660666C65941666666668E192C41CDCCCC2C64C6594133333333A9192C416666664662C65941CDCCCCCCBD192C416666668661C6594166666666C9192C416666660660C6594100000000CB192C419A9999D95FC659419A999999D7192C41333333735DC659419A999999E4192C41333333535AC65941CDCCCCCCD4192C413333339353C6594133333333BB192C41CDCCCCCC4CC65941000000009B192C413333331346C659419A9999995E192C41666666863DC65941CDCCCCCC20192C410000004036C659419A999999FF182C419A9999D931C65941CDCCCCCCCF182C419A9999592BC6594133333333A3182C41CDCCCC4C23C659410000000064182C413333339319C6594166666666FA172C41000000800CC6594133333333A0172C419A9999D901C65941000000007B172C4133333313FCC55941333333334E172C41333333B3F4C559413333333325172C4133333333EBC5594100000000FA162C4100000000E4C5594133333333C9162C41CDCCCC8CDDC55941CDCCCCCC7E162C419A9999F9D5C55941CDCCCCCC28162C41CDCCCC8CCDC55941CDCCCCCCE7152C419A9999D9C7C5594100000000C9152C4100000060C5C559419A999999B7152C419A9999F9C3C55941CDCCCCCC93152C419A999919C1C55941000000003B152C41CDCCCCACB6C559413333333313152C41666666E6B0C5594100000000B5142C41CDCCCCECA2C559419A99999978142C419A9999B99CC559416666666658142C41000000209AC559410000000004142C41666666A694C5594166666666C9132C41333333B390C5594166666666A3132C41CDCCCC0C8EC559410000000093132C41666666268CC559413333333364132C41333333738EC559419A99999950132C41000000208FC559410000000033132C410000002090C55941666666660E132C41666666A690C559419A999999E6122C41666666A690C55941CDCCCCCCC5122C41666666868FC5594100000000A7122C41666666868DC559413333333386122C41000000008AC55941666666667A122C416666664687C559413333333370122C41CDCCCCCC81C559410000000072122C419A9999197CC559416666666674122C419A99997978C55941333333337B122C41CDCCCCEC76C55941CDCCCCCC87122C410000002074C5594133333333A9122C419A99997971C5594100000000D3122C41000000206FC5594100000000EE122C41CDCCCC4C6DC55941000000000E132C41000000A06BC55941CDCCCCCCFC122C419A9999D95FC5594166666666ED122C41CDCCCC4C56C559419A999999DA122C41CDCCCC0C4DC559419A999999BC122C419A9999994FC559416666666667122C419A9999F956C5594100000000FE112C413333331360C55941CDCCCCCCC9112C41CDCCCCEC6DC5594100000000A6112C41666666C67CC559419A99999994112C41000000208DC559410000000060112C413333337397C559419A9999993D112C413333337395C559410000000027112C419A99999994C559419A99999904112C41666666C692C5594166666666DA102C416666660690C5594133333333CA102C41000000C08DC5594100000000AF102C41333333F387C55941CDCCCCCC97102C419A99999980C559413333333391102C41666666A679C55941000000008A102C41333333D36FC559413333333386102C41000000006AC55941CDCCCCCC85102C413333339367C55941CDCCCCCC84102C419A99991964C55941666666667F102C41000000C061C55941333333335A102C41666666465CC559410000000044102C419A9999B959C559413333333339102C419A99993959C559419A99999900102C413333331356C5594133333333420F2C41CDCCCC6C52C55941666666669C0E2C410000004050C5594166666666690E2C41CDCCCC6C50C5594100000000550E2C416666666654C55941CDCCCCCC460E2C41333333F356C5594100000000550E2C41000000405EC5594166666666660E2C41CDCCCCEC65C5594133333333780E2C41333333136FC55941000000008A0E2C413333331373C559419A999999940E2C413333337374C55941000000009C0E2C413333335376C5594100000000AC0E2C41333333B377C5594100000000BA0E2C413333335379C5594100000000BB0E2C41CDCCCCEC7AC5594133333333B70E2C419A9999597CC5594133333333B10E2C41CDCCCC0C7EC55941CDCCCCCCAB0E2C416666664680C5594133333333AA0E2C410000008084C55941CDCCCCCCA90E2C41333333F386C559419A999999A40E2C41333333B389C5594100000000A70E2C41000000408EC5594133333333A80E2C41666666C692C559419A999999A80E2C41CDCCCCEC95C5594100000000A60E2C41000000C09BC5594133333333A40E2C4166666686A1C55941CDCCCCCC9F0E2C4100000080A5C55941CDCCCCCC980E2C41CDCCCC0CABC5594100000000940E2C41333333B3AEC55941333333338B0E2C41CDCCCCACB5C5594166666666860E2C4100000000BBC55941CDCCCCCC8E0E2C41CDCCCC6CBFC55941CDCCCCCCA50E2C41666666E6C5C5594100000000CE0E2C4133333373CCC5594166666666EF0E2C4100000080D0C5594100000000360F2C419A999999D8C559419A999999650F2C4133333313DEC5594166666666B10F2C419A9999F9E5C55941333333335A0F2C4166666646F9C5594100000000560F2C419A999919FDC55941CDCCCCCC500F2C416666660602C65941CDCCCCCC790F2C419A9999F910C659419A999999840F2C41333333331CC6594100000000710F2C413333333321C6594100000000210F2C41CDCCCC0C20C65941CDCCCCCCF20E2C410000004025C659419A999999C70E2C41666666262AC659419A999999960E2C41CDCCCCEC37C659419A999999A10E2C41666666A645C65941666666668E0E2C41CDCCCCEC50C6594133333333490E2C41000000005BC65941CDCCCCCC170E2C41666666C663C6594166666666DA0D2C41CDCCCCCC6BC65941CDCCCCCC6A0D2C41CDCCCC6C76C6594166666666410D2C419A9999F980C6594166666666140D2C41333333F38CC6594133333333D30C2C41CDCCCCCC97C6594166666666BD0C2C41666666669BC65941	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	01010000206A080000CACCCC4CE81B2C419A9999D9A1C75941	700090000	Z	Aisey-et-Richecourt	7000900	70009	70	27	8
01060000206A0800000100000001030000000100000054010000CDCCCCCC89612C41CDCCCCEC82CD59413333333397612C413333333384CD5941000000009E612C416666660686CD59419A999999E1622C41000000C083CD59413333333329632C41000000C0C2CD5941CDCCCCCCCB622C4166666686C3CD59419A999999A7622C41000000E0BCCD59410000000074622C419A999939B6CD5941CDCCCCCC26622C4166666626B1CD59419A999999B8612C41CDCCCCACADCD59419A999999BB612C4166666646B5CD5941CDCCCCCCCD612C419A9999B9C2CD594133333333DC612C41CDCCCCCCCECD594133333333E0612C4133333313D2CD594166666666E4612C4100000000D5CD594166666666EC612C4166666666DBCD594100000000F5612C4100000060E1CD59419A999999FF612C41CDCCCC4CE7CD5941333333330A622C41666666A6EDCD59413333333311622C41CDCCCC4CF3CD5941666666661D622C41CDCCCC8C08CE594100000000EE612C41CDCCCC6C2ECE59419A999999EC612C419A9999794CCE594100000000F5612C41666666A666CE59416666666610622C419A9999798DCE5941CDCCCCCC53622C41666666A6ADCE59416666666684622C4133333393BFCE5941CDCCCCCC9D622C41000000A0DBCE594100000000A5622C4133333393EFCE5941CDCCCCCCCB622C419A99993903CF5941CDCCCCCCAF622C419A9999B916CF59419A999999D6622C41000000602BCF594133333333EB622C41666666E638CF59419A99999954632C419A99999965CF5941CDCCCCCCB7632C416666662696CF59410000000032642C416666664692CF59413333333374642C41333333B396CF5941000000009B642C419A9999999ECF59419A999999AF642C41CDCCCC2CADCF5941666666668C662C41000000C0B9CF59410000000092662C4133333353B8CF59419A99999996662C4133333333B6CF5941CDCCCCCCA2662C4100000080B2CF594100000000AF662C41666666C6ADCF594100000000B8662C41333333D3A7CF594133333333BD662C419A999939A4CF59419A99999957672C4133333393A3CF5941333333334E672C41CDCCCC8CBBCF5941CDCCCCCC5F672C41CDCCCC6CBBCF59416666666680672C41333333F3BBCF59416666666685672C419A999919BCCF5941CDCCCCCC8D672C419A999979BCCF59419A9999999D672C4166666626BDCF594166666666C2672C4166666606C0CF594100000000D7672C4133333393C1CF594100000000DD672C419A999939C1CF59419A999999EE672C41CDCCCC8CC1CF59419A99999926682C41CDCCCCACB9CF5941CDCCCCCC27682C419A999999B7CF5941666666663A682C4133333333B4CF5941333333334B682C41CDCCCCCCB0CF59410000000061682C419A999939ABCF5941CDCCCCCC7B682C4166666606A2CF594133333333AA682C41000000A09BCF59419A999999D0682C413333339396CF594166666666DC682C413333333395CF59413333333323692C41333333B38CCF59413333333360692C41333333F384CF594100000000AB692C419A9999797ECF594100000000E0692C419A9999B97DCF594100000000266A2C41666666A67DCF5941666666664E6A2C41CDCCCC6C7ECF594100000000746A2C41666666A683CF594166666666906A2C416666664687CF59419A999999A96A2C41CDCCCC6C8ACF5941CDCCCCCCD86A2C41CDCCCC4C8ECF5941CDCCCCCCFD6A2C410000000090CF5941666666664E6B2C410000004092CF5941333333339C6B2C410000004092CF5941CDCCCCCCCB6B2C419A9999F993CF59419A999999EB6B2C41CDCCCCCC96CF5941000000000E6C2C41CDCCCC4C9DCF5941666666662A6C2C419A9999D9A2CF594133333333376C2C41333333D3A6CF5941CDCCCCCC426C2C41CDCCCC8CA8CF594100000000546C2C4100000020A9CF59419A9999996B6C2C4133333353A8CF59419A9999997B6C2C4100000060A5CF59419A999999886C2C4100000040A0CF5941333333339F6C2C41000000609BCF594133333333B36C2C419A9999599ACF594166666666D16C2C41000000009ACF594166666666FE6C2C41000000809BCF594133333333186D2C41666666469DCF5941666666662D6D2C41000000C0A0CF5941000000004A6D2C419A999979A6CF594166666666556D2C4166666686A8CF5941CDCCCCCC566D2C41000000C0A8CF5941666666665E6D2C419A999919AACF5941333333336C6D2C41666666C6ABCF5941000000007E6D2C41666666C6ACCF594133333333986D2C4133333353ADCF594166666666BA6D2C4100000020ADCF5941CDCCCCCCD16D2C419A9999B9ACCF5941CDCCCCCCE46D2C41CDCCCC6CACCF59419A999999006E2C419A9999D9ACCF594133333333336E2C419A999979AECF59419A999999566E2C4133333373AFCF594166666666786E2C4166666666B1CF5941CDCCCCCC976E2C41CDCCCC0CB4CF5941CDCCCCCCBF6E2C41CDCCCCACB6CF5941CDCCCCCCEC6E2C41333333B3B8CF5941CDCCCCCC246F2C4133333313BBCF594133333333416F2C41CDCCCC6CBCCF594133333333766F2C4133333333C1CF594133333333B06F2C41000000C0C5CF594100000000B86F2C419A999959C6CF594133333333E36F2C419A999999C9CF594166666666FA6F2C4133333353CBCF5941666666660E702C419A9999D9CFCF59413333333319702C4100000080D2CF59413333333331702C419A999999D9CF5941666666664B702C4133333313E0CF59419A9999996C702C41666666E6E6CF59416666666676702C419A9999F9E8CF5941000000007D702C4166666666EACF5941CDCCCCCC85702C4166666606ECCF5941000000008D702C4166666626EDCF5941CDCCCCCC9D702C4100000060EFCF59419A999999B3702C41CDCCCCCCF1CF59419A999999CE702C41666666E6F3CF594166666666E4702C4133333353F5CF59419A999999F8702C4133333333F7CF59419A99999910712C41333333B3F9CF59410000000027712C4166666606FBCF59419A99999944712C4100000020FDCF59413333333362712C4166666606FFCF59413333333371712C41CDCCCC2C00D059410000000082712C41CDCCCC6C00D059410000000093712C41CDCCCC0C01D0594100000000A3712C416666664601D0594166666666B7712C410000008001D0594100000000C3712C413333335302D0594100000000D7712C410000002003D05941CDCCCCCCE8712C416666666603D05941CDCCCCCCFF712C41666666C604D05941CDCCCCCC20722C41666666A606D059410000000035722C419A99991908D05941000000004D722C419A99993909D059419A99999962722C41000000800BD05941CDCCCCCC7B722C41666666460DD05941CDCCCCCC92722C41666666660FD0594133333333A6722C41333333D310D05941CDCCCCCCB3722C41000000C011D059419A999999C7722C41CDCCCCEC11D059419A999999CF722C410000000012D0594166666666E7722C41CDCCCCCC11D059419A99999902732C41CDCCCCEC10D059419A99999914732C41333333F30FD059416666666625732C41000000400FD059413333333334732C419A9999D90ED05941CDCCCCCC45732C41666666460FD059410000000058732C41333333730FD059419A9999996D732C41666666860FD059413333333381732C41CDCCCC8C0FD05941CDCCCCCC9C732C41000000A00FD0594133333333B6732C41CDCCCCAC0FD05941CDCCCCCCC7732C41CDCCCC0C10D0594100000000D4732C419A99995910D059419A999999E4732C419A9999D910D059419A999999F3732C413333339311D059419A99999907742C41CDCCCC0C12D05941666666662E742C413333337312D05941333333334E742C419A99993913D05941666666668C742C41333333D314D0594100000000B4742C41000000E015D05941CDCCCCCCC4742C413333333316D05941CDCCCCCCFE742C41000000A017D05941CDCCCCCC23752C419A99995918D059419A9999993D752C419A9999D918D05941CDCCCCCC66752C41666666A619D05941333333338F752C41666666261AD059419A999999BA752C41CDCCCCCC1AD059419A999999E0752C419A9999191BD059413333333311762C41666666461BD05941000000006C762C41CDCCCC8C1AD0594166666666A9762C41CDCCCCCC18D05941CDCCCCCCC4762C41666666E617D05941CDCCCCCCE9762C419A9999B916D05941333333333D772C413333337315D05941000000005F772C413333331315D059419A99999996772C41CDCCCCEC14D0594100000000C3772C41333333F314D059419A999999F0772C419A9999B914D05941CDCCCCCC1B782C413333339313D05941CDCCCCCC44782C410000008011D05941000000007C782C41666666060FD059413333333380782C41333333D30ED05941CDCCCCCCBB782C41000000400CD05941666666660D792C413333333309D059410000000097792C4166666626F8CF594133333333267A2C41CDCCCC2CEFCF5941CDCCCCCCA37A2C41CDCCCC2CEBCF594166666666D77A2C41333333F3E1CF5941CDCCCCCCE47A2C41CDCCCC2CD6CF594166666666E57A2C41000000A0D2CF5941CDCCCCCCD77A2C4100000060CBCF594166666666B47A2C41CDCCCC8CB8CF5941CDCCCCCCA07A2C41CDCCCC8CB6CF59419A999999997A2C41333333D3B2CF594166666666A87A2C41CDCCCC0CADCF59410000000022792C41666666E687CF59413333333304772C410000006051CF59416666666675762C41CDCCCC0C41CF59419A9999993E762C419A99999947CF594166666666D8752C41000000603DCF59416666666620762C416666664633CF59410000000082752C419A9999D920CF59416666666693752C410000006014CF59410000000078752C41000000A010CF5941CDCCCCCC4D752C41000000E00ACF5941CDCCCCCC29752C419A9999F905CF5941CDCCCCCC20752C41000000C004CF594100000000F2742C4133333373FECE5941CDCCCCCCCB742C419A999959F8CE5941CDCCCCCCB2742C41000000E0F3CE5941CDCCCCCCA1742C41CDCCCCACF0CE59419A99999991742C41CDCCCC6CEDCE5941000000007D742C419A9999B9E8CE59419A9999996B742C4100000080E4CE5941666666665A742C41CDCCCCCCDFCE5941CDCCCCCC47742C41CDCCCC2CDBCE59419A99999931742C419A999919D5CE5941CDCCCCCC18742C41666666E6CDCE59419A99999902742C41333333F3C7CE594166666666F0732C419A999959C2CE594100000000DF732C41000000A0BCCE5941CDCCCCCCD2732C4100000020B8CE5941CDCCCCCCC7732C41000000E0B3CE594166666666BB732C4166666626AECE5941CDCCCCCCAE732C41CDCCCCACA8CE59419A999999A5732C4166666626A4CE5941666666669E732C4166666666A0CE59410000000069732C413333331398CE5941CDCCCCCC41732C419A99995991CE5941666666661F732C419A9999F987CE5941CDCCCCCCFB722C41CDCCCCCC75CE594166666666A6722C41000000E05FCE5941333333335A722C419A99993957CE5941666666663B722C41CDCCCCAC4FCE59419A999999F3712C416666662636CE594166666666A9712C41666666E630CE5941333333337E712C41666666C62ACE59413333333369712C41CDCCCC4C25CE59419A99999959712C41CDCCCC8C1CCE59413333333343712C41333333B304CE59413333333348712C4133333333FACD59416666666614712C41666666C6EFCD5941CDCCCCCCDA702C4100000060F1CD594100000000BE702C41000000E0EFCD59416666666669702C419A999919E4CD59413333333305702C4166666646E6CD594100000000EF6F2C41CDCCCC6CE4CD594100000000D86F2C4166666646DACD5941CDCCCCCC4C6F2C4100000080D1CD5941CDCCCCCCE06E2C41666666A6C7CD594133333333396F2C41000000A0B8CD5941666666662B6F2C419A9999B9B3CD594166666666D06E2C419A999999A3CD594166666666616E2C41CDCCCC2C8CCD5941CDCCCCCC716E2C410000002086CD5941000000007E6E2C413333337383CD5941333333337D6E2C41333333F37FCD59419A9999997B6E2C41CDCCCCEC7CCD59419A999999816E2C410000008078CD59419A999999826E2C419A9999D976CD594100000000926E2C41CDCCCCAC74CD594100000000956E2C41CDCCCC8C73CD5941CDCCCCCC906E2C41666666A671CD5941333333338B6E2C41CDCCCCCC6ECD59419A9999998F6E2C41333333536ECD5941333333339E6E2C41333333536ECD594100000000A36E2C41000000C06DCD594133333333986E2C41CDCCCC6C6ACD594133333333966E2C419A99997969CD5941CDCCCCCC9A6E2C419A99991967CD5941000000009A6E2C410000006065CD59419A9999999D6E2C41000000E063CD594166666666996E2C41CDCCCCAC61CD5941CDCCCCCC956E2C419A9999B95FCD59419A9999998D6E2C41333333D35CCD5941666666668E6E2C419A9999395BCD5941666666668C6E2C41000000E057CD59419A999999846E2C41333333B354CD594166666666856E2C41CDCCCC4C52CD594100000000836E2C416666660651CD594166666666776E2C410000002050CD594133333333726E2C41CDCCCC0C4FCD594133333333696E2C41000000A04ACD594100000000646E2C410000008049CD5941333333334E6E2C41CDCCCCCC47CD5941CDCCCCCC456E2C413333335346CD59419A999999426E2C413333337344CD59419A9999993A6E2C416666664640CD5941CDCCCCCC2C6E2C41666666063CCD59419A999999166E2C41666666E637CD5941666666660C6E2C419A9999F935CD594166666666616D2C410000006014CD594133333333DE6C2C419A99995909CD594100000000856C2C4100000040FACC5941333333333F6C2C4100000040FECC59419A999999E76B2C41333333D302CD5941333333331A6B2C41CDCCCCCC04CD594133333333A96A2C413333333304CD594100000000786A2C419A99993921CD5941666666662A6A2C413333333317CD594100000000266A2C416666664614CD594100000000006A2C41CDCCCC2C0FCD594100000000CB692C413333339308CD59410000000092692C413333333310CD5941CDCCCCCCE4672C41000000202ECD5941000000004D672C410000000037CD5941333333334F672C41000000E037CD59410000000000672C41000000C03BCD594166666666B7662C419A9999F93FCD59419A9999999E662C416666660639CD59419A99999954662C419A9999793ECD594166666666E9652C41333333731BCD5941CDCCCCCCF1642C410000008028CD59410000000033632C41666666063ACD59416666666612622C41CDCCCC4C3BCD59413333333311622C41333333B33FCD5941666666660B622C41CDCCCCAC43CD594133333333FD612C41333333134ACD594133333333E4612C41CDCCCC6C56CD594166666666D9612C419A9999395BCD594166666666BB612C419A9999B969CD594100000000A4612C41666666E675CD5941CDCCCCCC8E612C416666666680CD5941CDCCCCCC89612C41CDCCCCEC82CD5941	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	01010000206A0800002C8C96F99B6A2C419A9999B98ACE5941	700100000	Z	Alaincourt	7001000	70010	70	27	6
01060000206A080000010000000103000000010000006801000000000000B34C2D41CDCCCCCC47C55941CDCCCCCCB54C2D419A9999B981C5594133333333D14C2D410000008088C5594100000000044D2D416666666694C559419A999999194D2D419A9999199AC55941CDCCCCCC204D2D41000000809DC5594100000000254D2D41CDCCCCECA0C5594133333333244D2D4133333333A5C55941CDCCCCCC224D2D4166666666A7C559419A999999204D2D41333333F3ABC559419A9999991A4D2D4166666626B4C55941CDCCCCCC154D2D41CDCCCC8CBCC559419A999999134D2D41333333B3C1C55941CDCCCCCC144D2D41333333D3C5C5594166666666184D2D4166666686CAC5594133333333204D2D41000000E0CEC5594100000000354D2D4133333333D7C5594166666666454D2D41333333D3DCC55941CDCCCCCC574D2D41CDCCCC2CE2C55941666666666B4D2D419A9999D9E6C55941CDCCCCCC864D2D41000000E0ECC55941333333339A4D2D4133333353F0C55941CDCCCCCCD44D2D41CDCCCC2CFBC55941CDCCCCCCEE4D2D4100000000FFC559419A9999990B4E2D419A99997902C65941333333334C4E2D413333333309C6594100000000B14E2D41CDCCCC2C13C65941CDCCCCCCBC4E2D416666666614C659419A9999996E4F2D416666666627C6594166666666E14F2D41333333731AC6594100000000B8502D413333335304C65941CDCCCCCC89522D419A9999B9D3C559413333333393522D41000000C0D2C559413333333393522D4133333373D5C559410000000097522D419A999979DEC5594100000000BF522D4133333333EBC5594166666666EC522D41CDCCCC6CF3C559410000000032532D419A999939F8C559413333333371532D41CDCCCC4CF9C5594166666666BF532D4133333333F9C559416666666622542D4133333333F7C559419A99999988542D419A999999F5C55941CDCCCCCCE8542D4100000040F6C55941CDCCCCCC61552D41000000A000C6594100000000FF552D41000000200FC659419A99999944562D41333333B314C65941CDCCCCCC9B562D419A9999D916C6594100000000D2562D41CDCCCC8C17C659413333333329572D413333335316C659413333333350572D416666668615C65941333333337D572D410000008015C659419A99999986572D41CDCCCC0C15C659419A99999994572D416666660615C6594133333333A3572D41CDCCCC2C15C6594166666666BD572D41CDCCCCAC15C6594133333333E2572D413333335316C659410000000010582D419A9999D916C659419A9999992E582D416666664617C659410000000050582D413333335318C65941666666666F582D413333335319C659413333333393582D419A9999791AC65941CDCCCCCCB0582D41CDCCCC4C1BC6594100000000E2582D41666666661CC659419A99999909592D41CDCCCC8C1DC659410000000035592D41000000A01EC65941333333334F592D419A9999791FC659410000000088592D419A9999B921C659416666666684592D410000004023C659410000000086592D41000000E025C65941333333338C592D41666666462AC659419A99999995592D416666660630C65941666666669B592D419A99995933C6594100000000A2592D41000000A035C659419A999999A7592D41666666C637C6594100000000AE592D41666666663BC659419A999999B6592D419A9999B93DC6594100000000BF592D41CDCCCC0C40C6594133333333C7592D41CDCCCC0C43C6594133333333D3592D41333333D346C659419A999999E0592D41CDCCCC6C49C65941CDCCCCCCF5592D41333333B34CC659419A999999025A2D419A9999994EC65941CDCCCCCC135A2D416666666650C6594100000000315A2D41666666C652C6594100000000495A2D41000000E054C659419A999999795A2D416666666658C6594100000000985A2D41666666C65AC6594133333333C55A2D41333333B35EC65941CDCCCCCCDE5A2D419A99995961C659419A999999135B2D41333333B366C6594100000000245B2D41CDCCCC6C68C65941000000002D5B2D41666666466AC65941CDCCCCCC2E5B2D41333333D36BC659419A999999325B2D41000000E06BC659419A999999555B2D41CDCCCC4C6DC6594166666666765B2D41666666666EC659419A999999965B2D41333333936FC659419A999999AA5B2D416666666670C6594100000000C05B2D419A99997971C6594166666666D55B2D41333333D372C6594100000000ED5B2D41333333D374C6594166666666065C2D41666666A676C65941000000001D5C2D413333333378C6594100000000315C2D41CDCCCC0C79C65941000000004A5C2D41000000E079C659419A999999635C2D41CDCCCCAC7AC6594166666666775C2D419A9999797BC65941CDCCCCCC8B5C2D419A9999797CC6594166666666E75C2D419A9999D97CC65941CDCCCCCCD45D2D410000006058C65941CDCCCCCC175E2D419A9999394AC6594166666666235E2D419A9999B947C65941CDCCCCCC3F5E2D41CDCCCCAC44C65941666666664C5E2D41000000C043C65941CDCCCCCC575E2D419A99991943C659419A9999996A5E2D41666666A642C6594166666666965E2D419A99995942C65941CDCCCCCCBA5E2D419A9999D941C6594166666666F55E2D410000002040C65941CDCCCCCC3E5F2D41333333F33DC659419A999999645F2D41666666663CC65941000000009E5F2D416666664638C659419A999999B45F2D416666664637C6594100000000BF5F2D416666664636C6594133333333CC5F2D41CDCCCCCC33C6594100000000E55F2D41666666E62EC659410000000004602D41333333D32AC659419A9999990D602D419A99997929C659413333333314602D413333335328C659413333333324602D41CDCCCC4C26C659416666666636602D41000000E024C65941666666665E602D41000000C021C65941333333338C602D41333333D31DC6594166666666D1602D419A9999B918C6594133333333F2602D413333331316C65941000000001A612D41CDCCCC8C11C65941333333334F612D41666666E60BC659416666666669612D419A99999909C65941CDCCCCCC89612D41666666C606C65941666666669E612D419A9999D9FEC559419A999999C6612D41333333F3FCC5594133333333A7622D419A99999913C6594100000000CF622D41CDCCCC4C12C65941000000001E632D419A99997904C65941666666662E632D419A999979F3C559419A99999951632D41CDCCCC6CF3C55941CDCCCCCC24642D41CDCCCC8CFCC559410000000067642D4100000000FEC559413333333322652D4133333333D3C55941CDCCCCCC26652D4133333333C8C55941CDCCCCCC36652D41666666C6C4C559419A99999950652D4166666686BDC559416666666653652D41000000E0BCC559419A9999998C652D4100000040BCC559410000000098652D41000000C0BCC559416666666634662D4133333373BEC55941666666669D662D41CDCCCC4CCBC55941000000002A672D4166666626D5C5594100000000AC672D4100000040D6C55941CDCCCCCCDB672D419A9999F9B6C55941CDCCCCCC6D672D41000000A0B5C559410000000073672D41CDCCCCCCB1C55941333333337C672D4166666686B1C559413333333386672D419A9999F9B0C55941000000008E672D4133333313B0C559419A99999993672D41CDCCCC0CAFC559419A99999997672D4100000000ADC559416666666699672D4133333313A8C55941333333339D672D41666666E6A2C5594166666666A0672D41666666E6A1C55941CDCCCCCCA6672D4100000040A1C5594133333333B2672D41CDCCCCACA0C55941CDCCCCCCBB672D41666666469AC559410000000099662D410000006094C559419A999999F0662D41333333F38EC55941000000002B672D41CDCCCC8C8AC5594166666666DE662D41666666C682C559413333333344662D41000000C07AC55941CDCCCCCC62642D413333331362C559410000000060642D41333333F361C55941333333331A642D419A9999595DC5594100000000A7632D419A99997953C559419A9999994E632D41333333934BC559419A99999900632D41666666A642C559419A999999D2622D41000000603AC55941333333339F622D41666666C630C559410000000074622D41333333D327C55941CDCCCCCC65622D41333333D31AC55941CDCCCCCC67622D41CDCCCC2C10C55941CDCCCCCC7E622D419A99997902C559419A99999980622D419A999979F7C459410000000068622D41333333D3ECC459413333333333622D4100000040DFC459419A99999924622D4133333373DBC45941CDCCCCCC03622D4166666646D7C45941CDCCCCCCF8612D4166666646D3C459419A999999DA612D4133333353C6C459416666666624622D4133333393B9C459413333333364622D4133333333B5C459413333333358622D419A999939B5C45941333333331C622D41CDCCCC8CB4C459419A999999F4612D4100000080B1C4594133333333CD612D419A9999D9AFC45941CDCCCCCCAE612D41CDCCCCECAEC45941CDCCCCCC92612D419A999999ACC459413333333374612D4133333313ABC459410000000045612D4100000060A9C459410000000022612D41000000A0A8C4594166666666FB602D4133333353A8C4594133333333E4602D41333333D3A7C4594133333333CE602D4100000040A7C4594166666666B4602D41CDCCCC0CA7C45941CDCCCCCCA4602D4166666646A7C459410000000093602D41CDCCCCECA7C45941666666667F602D41000000A0A8C459419A99999970602D41666666A6A8C459419A9999995F602D419A999939A8C45941000000001B602D419A999999A5C45941CDCCCCCC0E602D419A999939A5C4594133333333FE5F2D419A9999B9A4C4594166666666F75F2D41CDCCCC8CA4C459419A999999EE5F2D4100000060A4C4594100000000DC5F2D41CDCCCCACA4C459419A999999765E2D4166666686A9C45941CDCCCCCC605E2D41666666C6A7C45941CDCCCCCC445E2D41CDCCCCECA5C459419A9999992C5E2D419A999979A3C4594133333333125E2D41CDCCCCCCA1C459419A999999FC5D2D41CDCCCC0CA1C459419A999999ED5D2D41CDCCCC6CA0C459419A999999D15D2D419A9999D99DC459419A999999C25D2D41666666C69BC4594100000000B95D2D419A9999599AC4594133333333AB5D2D419A9999F998C45941CDCCCCCC8C5D2D41666666468AC459419A999999635D2D419A9999D978C4594100000000275D2D41CDCCCCEC6EC4594100000000F35C2D410000004052C4594100000000AC5C2D413333331342C459419A999999145C2D41000000C02BC459419A999999FF5B2D41CDCCCC0C1EC4594166666666AF5B2D41000000601AC4594100000000905B2D41CDCCCC6C06C45941CDCCCCCC3F5B2D416666668601C4594133333333485B2D4166666646ECC3594133333333625A2D410000002059C35941CDCCCCCCE0592D41000000405EC35941000000005F592D41666666E660C359416666666640592D41333333F356C359416666666618592D419A99993958C359419A999999C8582D413333339359C3594100000000B4582D419A9999994FC359410000000096582D41000000A04FC359413333333346582D419A99997953C359419A999999F6572D41CDCCCC0C56C3594133333333F6572D41CDCCCC0C51C359419A999999A4572D41666666A63AC359416666666667572D419A9999B926C359416666666621572D41CDCCCCCC26C359410000000022572D41CDCCCC4C2EC3594100000000AA562D41CDCCCCAC2FC3594100000000A0562D41333333732EC3594100000000AA552D41666666C61BC3594166666666A4552D41CDCCCCCC1DC359410000000067552D41CDCCCC2C30C35941CDCCCCCC49552D41CDCCCC4C3CC359419A9999992E552D419A99997956C35941000000002D552D419A99995957C359410000000027552D419A9999F95AC359413333333311552D41CDCCCCCC67C35941CDCCCCCCE6542D41CDCCCCEC7DC3594100000000A3542D41000000E094C35941333333336A542D41666666C6A2C35941666666662E542D41CDCCCC2CAAC359413333333327542D4133333313ABC35941666666661C542D41333333B3ABC359419A999999FD532D4133333373ADC3594166666666D3532D41000000A0ACC35941CDCCCCCCC6532D4100000060ACC3594100000000B2532D4166666686AAC3594166666666A2532D4166666686A8C35941000000007B532D41666666C6A4C359419A9999994D532D4100000020A3C359413333333311532D41333333F3A1C3594100000000DF522D4166666666A1C3594166666666AF522D41666666E6A1C35941333333337C522D419A999959A3C359413333333356522D4166666646A4C35941CDCCCCCC33522D41666666C6A3C3594100000000E3512D4166666686A1C3594100000000A5512D419A9999999FC35941000000006B512D41CDCCCCAC9EC359413333333348512D41000000609EC359419A9999992D512D41CDCCCC0CA0C35941666666660A512D419A999999A2C3594166666666F5502D4166666626A4C3594166666666E6502D41333333D3A4C359419A999999D2502D41333333B3A5C35941CDCCCCCCC7502D41CDCCCC2CA6C35941000000009E502D41CDCCCC4CA6C35941000000008A502D4166666666A5C359413333333385502D41CDCCCC2CA5C359413333333381502D4100000000A5C359416666666667502D41333333F3A2C359416666666648502D4133333333A1C359413333333325502D4133333333A2C3594100000000E44F2D419A9999D9A8C35941333333338A4F2D41333333D3B4C35941CDCCCCCC5E4F2D4100000080BCC35941CDCCCCCC594F2D419A999959BDC35941666666664D4F2D41333333F3C6C3594166666666444F2D41CDCCCC2CCEC3594166666666324F2D419A999919D8C35941CDCCCCCC2D4F2D41CDCCCCCCD8C35941CDCCCCCC074F2D4100000060DEC3594166666666DF4E2D4166666666DFC3594166666666B64E2D4100000080E9C3594100000000DB4D2D419A9999F9EFC35941000000003D4E2D410000004002C45941666666663E4E2D419A99991903C45941333333334B4E2D416666666607C4594133333333634E2D41000000600FC45941CDCCCCCC724E2D41000000A016C4594100000000784E2D413333331319C45941000000007D4E2D41CDCCCC0C1AC4594133333333854E2D41666666C61AC45941000000008C4E2D41000000001BC45941CDCCCCCC6A4E2D41CDCCCC4C29C45941CDCCCCCC894E2D410000004038C45941666666663A4E2D41333333933EC4594100000000144E2D419A99999957C4594166666666D94D2D416666662669C4594166666666924D2D410000006070C459419A999999624D2D41CDCCCC2C74C45941000000004B4D2D419A9999997AC4594166666666244D2D416666664683C4594100000000014D2D41333333738AC4594166666666E94C2D41000000A091C4594100000000D54C2D41CDCCCC0C9BC459419A999999D24C2D41333333B3A3C4594166666666D34C2D4133333313B0C4594166666666C54C2D4100000020BFC4594100000000B74C2D41CDCCCC6CC7C4594166666666B74C2D41CDCCCC4CCCC45941CDCCCCCCB84C2D41CDCCCC0CCDC4594133333333CD4C2D4166666626D7C45941CDCCCCCCE84C2D41666666C6DFC45941666666661C4D2D41000000C0E8C45941333333334D4D2D41333333F3F0C45941CDCCCCCC6E4D2D41CDCCCC4CFAC459419A9999998D4D2D41CDCCCC4C03C5594166666666A94D2D41666666C60DC5594133333333DD4D2D410000002017C55941000000002F4E2D41CDCCCCAC1FC5594166666666654E2D41666666A625C5594133333333B14E2D41333333732DC5594166666666BD4E2D413333331330C5594166666666B74E2D413333335332C559419A9999990C4D2D419A9999B942C5594100000000B34C2D41CDCCCCCC47C55941	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	01010000206A080000975616C150572D41CDCCCCACCCC45941	700110000	Z	Amage	7001100	70011	70	27	7
01060000206A080000010000000103000000010000000C04000000000000943D2C419A9999391EBF5941CDCCCCCCAD3D2C41666666A61EBF594166666666BB3D2C41CDCCCC4C1FBF594100000000DB3D2C41000000C020BF594166666666F23D2C413333337321BF59419A999999FB3D2C419A99993922BF594133333333093E2C416666668622BF594133333333113E2C419A99993922BF594133333333283E2C416666666622BF5941666666662E3E2C419A99997922BF59419A999999353E2C416666662623BF594100000000393E2C410000008023BF5941000000003C3E2C410000002024BF5941CDCCCCCC413E2C419A9999F924BF5941000000004C3E2C41000000C025BF5941CDCCCCCC5D3E2C419A99993926BF5941333333336B3E2C416666666626BF59419A999999793E2C410000008026BF594133333333943E2C413333335327BF59419A9999999F3E2C419A9999D927BF594166666666B63E2C416666662628BF594100000000C23E2C413333335328BF5941CDCCCCCCC93E2C410000000028BF594133333333D33E2C41000000A027BF5941CDCCCCCCDC3E2C419A99999927BF59419A999999E93E2C416666666628BF594100000000F73E2C410000002029BF594166666666103F2C41CDCCCC6C2ABF5941333333332A3F2C41CDCCCC0C2CBF594100000000393F2C41666666262DBF594166666666473F2C41000000002EBF5941000000005A3F2C41666666062EBF59419A999999643F2C419A9999F92DBF5941333333336E3F2C41666666262DBF5941CDCCCCCC7A3F2C41666666262DBF594133333333863F2C41333333932DBF5941666666668E3F2C41333333D32EBF594133333333983F2C41666666A62FBF5941CDCCCCCC9F3F2C410000004030BF594100000000B33F2C419A9999B930BF5941CDCCCCCCC03F2C413333337331BF594133333333D33F2C41CDCCCC4C30BF594133333333E23F2C41000000802FBF594100000000E93F2C41CDCCCCAC2EBF594100000000EC3F2C419A9999592DBF5941CDCCCCCCEE3F2C41000000A02BBF59419A999999F13F2C41CDCCCC4C2ABF594133333333F93F2C419A99995929BF59413333333301402C419A99991927BF59419A99999915402C41CDCCCC4C21BF59419A9999991E402C41CDCCCCAC1EBF59416666666625402C41CDCCCC2C1CBF59419A9999992C402C41CDCCCC4C1ABF59416666666634402C41333333B318BF5941000000003C402C416666668616BF5941000000005A402C41666666E61EBF5941CDCCCCCC3A412C41666666860BBF594133333333BC412C41666666E603BF5941000000001B422C41CDCCCC4CFCBE59419A99999966422C41333333330BBF59419A999999AD422C41000000E018BF594100000000E1422C41CDCCCC0C2EBF5941000000003E432C41CDCCCC8C27BF59413333333366432C416666668626BF5941333333337C432C410000000026BF59419A99999961442C41CDCCCCAC04BF5941000000003D452C4166666626FCBE59419A999999F1452C4100000080E8BE59419A9999992A462C41000000E0E1BE59419A99999928462C4133333373DEBE594133333333E8452C41CDCCCC4CDEBE594100000000F6452C41CDCCCC4C97BE594133333333F3452C41666666A68BBE5941666666668F462C41333333D383BE59416666666658472C41000000C07ABE59410000000014482C419A9999D970BE594166666666BC482C41333333F368BE59419A9999996E492C41CDCCCC4C7EBE59419A999999E0492C41333333938ABE5941000000001A4A2C416666660692BE594133333333D64B2C410000000084BE5941333333333B4C2C41333333B391BE594133333333924C2C419A9999199DBE594133333333234D2C4133333393AEBE594166666666A84D2C41CDCCCCECB1BE59419A999999D04D2C4100000060B4BE594133333333034E2C41CDCCCC4CBEBE5941CDCCCCCCDC4D2C4100000020C7BE5941CDCCCCCCCD4E2C41CDCCCC4CE7BE5941000000001A4F2C419A999999EFBE59419A999999464F2C41CDCCCC6CF2BE5941CDCCCCCC784F2C4100000060F7BE59419A999999B54F2C41CDCCCC8C02BF594100000000B84F2C416666664624BF594166666666AE4F2C41666666862ABF594166666666E14F2C41333333B33ABF59419A999999F54F2C41CDCCCC2C3DBF59419A999999604E2C416666662663BF594166666666ED4E2C419A9999B984BF5941000000003E4F2C413333335397BF594133333333A34F2C41333333F3A9BF594166666666A44F2C41333333F3ADBF594100000000674F2C419A9999B9B5BF594133333333724F2C41CDCCCC0CC7BF59419A999999904F2C41666666A6CFBF594166666666CE4F2C4100000060D9BF5941666666663F502C4166666686E8BF5941CDCCCCCC01502C41CDCCCC8CEEBF594100000000A3502C419A9999D9FFBF59419A999999F3502C41666666060BC05941000000000B512C41666666460EC0594100000000DE502C419A9999D914C059413333333303512C41333333B324C059413333333321512C41000000A033C059416666666642512C413333331337C05941000000005E512C41666666C639C059413333333375512C41333333933CC05941333333339D512C41CDCCCC0C41C0594100000000D1512C419A99995947C0594166666666F6512C41666666064CC059419A99999928522C41CDCCCCCC52C0594133333333BF522C41000000003BC05941CDCCCCCC1B532C416666662631C059416666666641532C419A9999592BC059416666666662532C416666662630C0594166666666C1532C41333333933AC059419A999999E8532C41CDCCCCEC36C05941CDCCCCCC04542C413333331334C059419A99999926542C41000000802FC05941666666664E542C410000008029C059410000000073542C419A99991924C059416666666696542C41CDCCCCCC1DC05941CDCCCCCCC1542C41333333B315C0594166666666E6542C41333333130FC05941000000000E552C41CDCCCC0C08C059416666666625552C413333331304C05941CDCCCCCC54552C419A9999B905C05941CDCCCCCCB6552C41000000800EC059413333333323562C413333333318C0594100000000D9562C41CDCCCC4C29C0594166666666F1562C41000000C01FC059413333333320572C41CDCCCC4C22C059410000000052572C410000000021C05941CDCCCCCCB4572C41666666660FC059419A999999E2572C41333333B311C059410000000002582C410000004013C05941CDCCCCCC0F582C41666666A613C059413333333322582C41CDCCCC2C14C05941666666663F582C410000002012C059413333333355582C41000000400FC059419A9999997B582C41000000C010C05941CDCCCCCC7C582C41CDCCCCEC16C059419A99999980582C419A9999D918C059416666666688582C41000000001BC05941CDCCCCCC9E582C41CDCCCC8C21C0594133333333B5582C41666666E627C059419A999999CB582C41333333132EC0594100000000DD582C41CDCCCC0C33C05941CDCCCCCCE2582C410000008034C0594166666666EE582C419A99991936C0594133333333F3582C413333339336C05941CDCCCCCC05592C416666666638C05941000000002A592C41CDCCCCCC3DC05941333333333A592C410000002040C05941CDCCCCCC42592C41000000A042C05941CDCCCCCC48592C41CDCCCC4C45C059416666666647592C41CDCCCC8C48C059416666666649592C419A9999594BC05941666666665F592C41666666A652C059410000000078592C413333339359C059413333333386592C41666666065DC059419A99999990592C41CDCCCC0C5FC059419A9999999A592C410000002060C059419A999999A9592C41333333F360C05941CDCCCCCCC4592C41CDCCCCCC61C0594100000000DE592C41CDCCCC2C63C0594166666666F4592C416666666665C05941CDCCCCCC095A2C41000000C067C05941CDCCCCCC195A2C41666666666AC0594100000000255A2C41666666C66CC05941333333332C5A2C41CDCCCC4C6FC059419A999999365A2C413333335372C05941CDCCCCCC435A2C413333333375C0594100000000535A2C416666664678C059419A999999605A2C41000000207BC05941CDCCCCCC745A2C41666666667FC0594133333333895A2C41666666A683C05941666666669C5A2C416666668686C0594100000000B45A2C41333333538AC059419A999999BB5A2C41000000808CC059419A999999C05A2C41333333538FC05941CDCCCCCCC25A2C419A99991991C05941CDCCCCCCCB5A2C416666664694C05941CDCCCCCCD75A2C41333333B397C0594133333333EE5A2C41666666869CC059419A999999015B2C41CDCCCC2CA0C05941000000000E5B2C41333333B3A3C0594166666666135B2C4100000080A6C05941CDCCCCCC1B5B2C419A999959A9C0594100000000355B2C41CDCCCC8CAFC05941000000004F5B2C41666666C6B3C0594133333333A35B2C419A999979B2C0594133333333895F2C419A999999B0C0594100000000A05F2C419A999999AFC05941CDCCCCCC90612C41CDCCCCAC99C059416666666655612C419A99993992C059416666666600612C41666666E68BC059419A99999986602C419A9999597DC059416666666616602C41CDCCCC4C6DC0594133333333B65F2C416666668656C05941666666669A5F2C419A9999F94CC059419A999999775F2C410000002041C059419A999999485F2C41CDCCCC0C37C0594166666666FA5E2C41666666E635C0594100000000C85E2C416666662633C0594100000000B75E2C41CDCCCC0C2EC05941CDCCCCCC515F2C41CDCCCC4C17C05941CDCCCCCCD85F2C416666664602C05941666666660D602C41CDCCCC6CECBF59413333333339602C419A999919D8BF5941CDCCCCCC9F602C4100000000C2BF594133333333DA602C41333333B3ACBF5941666666663C612C419A99999993BF59419A999999DA612C41333333B37BBF59416666666607622C41CDCCCCCC74BF5941000000008C622C419A99995961BF59413333333380622C419A99997959BF59416666666689622C41CDCCCCAC56BF594133333333F0622C410000002045BF59419A99999914632C41333333B339BF59416666666644632C41CDCCCC8C30BF59410000000078632C410000006028BF5941666666665F632C419A99991922BF59419A999999FA632C41CDCCCCAC11BF59419A99999912642C41000000A00EBF59419A999999BC632C410000002009BF594133333333C8632C41333333B3FEBE594100000000E5632C4166666646F6BE59419A999999E6632C419A999979EFBE594100000000EA632C41000000A0E2BE594133333333E9632C41CDCCCC6CD9BE594166666666F5632C41000000E0D2BE594133333333FB632C41CDCCCC2CC9BE59419A9999991F642C419A9999F9B5BE5941333333332B642C419A999999A8BE59416666666628642C41333333B399BE59413333333327642C41CDCCCCAC96BE59410000000021642C41333333D387BE5941000000001A642C419A9999F97DBE5941CDCCCCCC18642C419A9999597CBE5941CDCCCCCC16642C41666666867ABE59413333333336642C41CDCCCCCC79BE5941CDCCCCCC4E642C419A99993979BE59416666666697642C41333333F377BE59419A999999EC642C413333331377BE59410000000018652C41000000C076BE59410000000031652C416666668676BE59419A99999949652C419A99993975BE59419A99999957652C419A99997974BE59419A9999998C652C41CDCCCCCC73BE594166666666A7652C41666666E673BE594100000000B0652C416666660674BE594133333333B4652C41000000A074BE5941CDCCCCCCB3652C41CDCCCC2C76BE59419A999999B0652C419A99995979BE59419A999999B1652C41666666667BBE5941CDCCCCCCB2652C41666666A67CBE5941CDCCCCCCBE652C41CDCCCC4C7DBE5941CDCCCCCCD0652C419A9999B97DBE59419A999999DA652C41666666667DBE59413333333301662C41CDCCCCAC7DBE59416666666629662C41000000A080BE59413333333354662C416666662685BE5941CDCCCCCC79662C419A9999B98CBE59419A99999997662C416666668692BE594100000000AE662C419A9999D995BE5941CDCCCCCCC0662C41333333D397BE5941CDCCCCCCD7662C41CDCCCC2C99BE59413333333309672C41333333139BBE5941000000002C672C419A9999B99DBE59419A99999947672C4133333353A1BE5941CDCCCCCC55672C419A9999B9A3BE5941CDCCCCCC75672C41CDCCCC8CA7BE594100000000CE672C419A99993999BE5941CDCCCCCCDE672C41666666C694BE594166666666CD672C419A99997990BE5941666666668D662C413333333371BE5941CDCCCCCC25662C413333335364BE59410000000070662C41CDCCCC0C64BE594133333333C1662C41333333D361BE594100000000BC662C41CDCCCC8C5DBE59413333333357662C41CDCCCCEC4FBE59419A99999940662C41CDCCCCCC4ABE59416666666608662C41000000E040BE5941CDCCCCCC9E652C419A99999928BE5941CDCCCCCC59652C41000000C01BBE594133333333F4642C410000006005BE59410000000008652C419A99999901BE59416666666691652C41CDCCCC6CFBBD594100000000BC652C41666666E603BE594100000000EE652C419A99999902BE59419A9999990B662C41333333D3FEBD5941666666665B662C419A999939FCBD59416666666619672C4166666646FDBD594166666666F1672C41CDCCCC8C01BE59419A9999992E682C419A999979F6BD5941CDCCCCCCE5682C416666660608BE59419A999999F3682C41CDCCCC4C03BE5941CDCCCCCC0C6A2C41CDCCCC2C1DBE59419A999999206A2C41666666E61BBE59419A999999416A2C41666666861EBE59419A9999996F6A2C419A99999910BE59419A999999546A2C41666666A60EBE594133333333296A2C41CDCCCC0C07BE5941CDCCCCCC146A2C419A9999B901BE594133333333146A2C4100000060F7BD594133333333226A2C41000000A0F3BD5941666666661A6A2C4166666646EDBD5941000000002F6A2C4166666646DFBD594100000000796A2C4166666606ACBD594166666666816A2C41000000A0A6BD594100000000C16A2C41CDCCCC2C9ABD59419A999999EB6A2C416666668691BD5941333333330C6B2C41000000808EBD5941CDCCCCCC8A6A2C41333333D37EBD5941666666664E6A2C41CDCCCC6C77BD594166666666256A2C41000000C06FBD594166666666EB692C419A9999F963BD59419A9999997E692C41666666664EBD594166666666FF682C413333339333BD59419A9999998E682C41333333931DBD5941000000005E682C41000000A014BD5941CDCCCCCC22682C41333333B30ABD59410000000003682C419A99991905BD59419A999999D4672C41CDCCCC2CFCBC594100000000B2672C41CDCCCCECF2BC5941CDCCCCCC98672C419A999979EABC5941CDCCCCCC68672C4133333353DDBC5941000000004A672C41CDCCCC4CD5BC59413333333326672C41CDCCCC4CCBBC5941CDCCCCCC0D672C419A999959C4BC5941CDCCCCCCF8662C41666666C6BEBC594133333333DA662C4100000060B9BC59419A999999AE662C41CDCCCC2CB4BC59413333333386662C4166666606AEBC59419A99999968662C419A9999D9A9BC5941CDCCCCCC3C662C4133333353A3BC5941CDCCCCCC1D662C41CDCCCC6C9FBC59416666666617662C41000000A09DBC59419A9999990B662C41666666269ABC5941CDCCCCCCF8652C419A99991994BC594133333333D5652C41000000008CBC594100000000AC652C419A9999F983BC59416666666672652C41666666467BBC59416666666632652C41CDCCCCAC72BC594133333333DA642C41666666A668BC5941000000008C642C419A99993960BC59419A99999942642C419A99999958BC59410000000006642C41333333D353BC594100000000C4632C41333333B34EBC5941CDCCCCCC85632C41CDCCCCAC49BC5941000000003E632C419A99997944BC5941666666661E632C416666666642BC5941333333338C632C41333333F324BC594100000000A1632C41333333531FBC5941333333337A632C41CDCCCCAC1DBC59419A99999964632C419A9999391CBC5941000000004D632C419A9999991ABC59410000000028632C419A99991917BC594100000000E4622C41CDCCCCAC10BC59419A99999997622C41CDCCCC2C09BC5941333333334A622C419A99991901BC59419A999999FB612C4100000000FABB594100000000AF612C4166666666F3BB59419A99999972612C4100000060EDBB59419A99999937612C4166666666E8BB59419A999999EF602C419A999939E3BB59419A999999A8602C41333333B3DEBB59413333333347602C419A999999D9BB59419A999999F05F2C4166666686D4BB594133333333AE5F2C41333333F3D0BB594133333333835F2C41000000C0CEBB594133333333205F2C41CDCCCCECC9BB59419A999999C85E2C41CDCCCCACC5BB5941333333337F5E2C41CDCCCC0CC2BB594100000000275E2C4133333353BDBB5941000000001E5E2C41CDCCCCCCBCBB594133333333EF5D2C4133333313BABB5941CDCCCCCC9C5D2C41CDCCCC2CB4BB594166666666595D2C419A999999AFBB594166666666E65C2C41000000A0A8BB594166666666D05C2C4100000060A7BB594100000000C85C2C41666666E6A6BB594133333333845C2C41333333B3A2BB5941CDCCCCCC335C2C41666666469EBB594100000000F65B2C41666666069BBB594100000000AA5B2C41333333B396BB594100000000615B2C41666666C692BB594100000000335B2C419A99995990BB594133333333225B2C419A9999798FBB59419A999999055B2C41CDCCCC8C8DBB594166666666B95A2C416666660689BB5941333333337B5A2C416666668685BB5941000000003F5A2C419A9999D982BB59419A999999035A2C419A9999B980BB5941CDCCCCCCB9592C419A9999997EBB59410000000078592C419A9999997CBB59410000000035592C419A9999397ABB59419A999999F0582C41CDCCCC0C77BB594133333333BB582C41CDCCCC8C74BB59419A99999986582C413333337371BB5941000000002B582C41666666E66BBB59416666666610582C41CDCCCC6C6ABB5941CDCCCCCCD3572C413333337366BB59413333333387572C41CDCCCC0C62BB5941000000004B572C41CDCCCCCC5EBB5941666666661D572C41666666265BBB59419A999999D9562C410000008054BB5941666666667F562C41000000404DBB59410000000037562C41CDCCCC6C46BB59410000000003562C41CDCCCC8C41BB5941CDCCCCCCC6552C41333333133CBB59419A9999999B552C41CDCCCC8C38BB5941666666667C552C419A99991936BB59416666666661552C41CDCCCC2C34BB59416666666651552C419A99993933BB59410000000047552C41333333B332BB59413333333346552C41666666A632BB59413333333322552C419A9999D930BB59419A999999CC542C41CDCCCC0C2DBB59416666666690542C41CDCCCC2C2ABB5941333333335B542C41CDCCCCAC27BB594100000000FE532C413333337322BB59419A999999BB532C41333333D31EBB59413333333370532C41333333531ABB5941333333331F532C410000000015BB59419A999999F7522C416666662612BB59419A999999CD522C41000000600FBB594166666666B6522C41333333D30DBB594100000000A6522C41333333D30CBB59410000000093522C41CDCCCCAC0BBB5941CDCCCCCC79522C41666666260ABB59416666666635522C410000008005BB59416666666608522C41CDCCCCAC02BB594166666666F9512C419A9999B901BB594166666666B4512C4100000060FDBA59413333333387512C41CDCCCCECFABA5941000000007E512C4166666666FABA59416666666634512C4100000020F7BA5941CDCCCCCCF0502C419A9999F9F3BA5941CDCCCCCCDB502C4100000000F3BA5941333333339E502C4166666646F0BA5941CDCCCCCC96502C41333333F3EFBA59410000000068502C419A9999D9EDBA59410000000023502C41CDCCCC4CEABA59419A999999D24F2C4166666646E6BA5941CDCCCCCCC94F2C41CDCCCCCCE5BA594100000000AF4F2C4133333353E4BA59419A999999984F2C4133333373E2BA59419A999999894F2C41CDCCCCECE0BA594100000000674F2C4166666606DDBA5941CDCCCCCC384F2C41CDCCCC2CD7BA59419A999999FB4E2C419A9999D9CEBA59419A999999CA4E2C41333333F3C8BA594100000000A74E2C4100000000C4BA594133333333964E2C41CDCCCCACC1BA594100000000884E2C41333333B3BFBA5941000000007C4E2C41CDCCCC0CBEBA59419A999999734E2C41CDCCCC0CBDBA5941CDCCCCCC694E2C41000000E0BBBA594133333333594E2C41CDCCCCCCB9BA594133333333564E2C4166666666B9BA5941CDCCCCCC3E4E2C4133333373B6BA5941333333333A4E2C419A9999D9B5BA5941CDCCCCCC114E2C41CDCCCC6CB1BA594133333333F14D2C419A999959AEBA594166666666CC4D2C41666666A6AABA594100000000A84D2C41333333D3A7BA59419A9999998E4D2C4100000000A6BA5941666666667F4D2C41666666C6A4BA594166666666704D2C419A999999A3BA5941CDCCCCCC5A4D2C4133333373A2BA59419A999999424D2C4166666646A1BA59419A999999124D2C41CDCCCC2C9FBA5941CDCCCCCCD64C2C41666666069DBA594166666666864C2C41666666469ABA59419A9999992F4C2C416666664697BA594133333333E54B2C419A99995994BA59419A999999624B2C419A9999B98FBA594133333333E54A2C419A9999398BBA59419A999999994A2C410000008088BA59419A999999804A2C419A99999987BA5941CDCCCCCCF1492C41CDCCCCAC6BBA59416666666647492C419A99997979BA59416666666626492C41333333137BBA59419A999999F7482C41666666667DBA5941CDCCCCCCC9482C41666666E680BA59410000000087482C419A99997985BA5941CDCCCCCC48482C41CDCCCCAC89BA59416666666613482C41333333938CBA594133333333DD472C413333331390BA5941CDCCCCCCA5472C41333333D393BA59419A9999996C472C410000000098BA5941CDCCCCCC2D472C41333333B39DBA59419A999999E2462C41000000E0A4BA5941333333339E462C41666666C6AABA59413333333356462C4166666646B0BA59413333333303462C41333333D3B6BA59419A999999BF452C41000000A0BCBA59413333333392452C4133333393BFBA59419A9999998C452C4133333373BFBA5941333333337E452C419A999959BFBA59416666666670452C4133333353C0BA5941CDCCCCCC67452C4100000020C1BA59410000000061452C4100000080C2BA59419A99999957452C41CDCCCCCCC4BA59419A9999994F452C41CDCCCC6CC5BA59416666666647452C419A999999C5BA5941000000003B452C4166666646C5BA5941666666662F452C4133333313C5BA59410000000026452C41CDCCCC2CC5BA59410000000012452C41333333F3C6BA59419A999999FE442C4100000080C8BA59419A999999ED442C4166666666CBBA59419A999999DD442C4100000080CEBA594100000000D2442C4166666646CFBA594133333333BF442C41CDCCCC0CD1BA5941CDCCCCCCB4442C41CDCCCC4CD2BA59419A999999A2442C4133333353D3BA59413333333385442C4100000000D5BA5941CDCCCCCC6A442C419A999959D6BA59413333333340442C4100000040D9BA59416666666631442C41333333D3DABA5941333333331E442C4166666606DCBA5941333333330C442C4166666646DCBA59410000000003442C41CDCCCC8CDCBA594100000000F3432C4133333333DCBA5941CDCCCCCCE6432C4133333373DBBA594100000000DA432C4100000080DABA594100000000C5432C419A999959D9BA59419A999999AB432C419A999939D7BA59419A999999A1432C41CDCCCC4CD6BA59419A99999995432C41333333D3D5BA59419A9999998A432C41CDCCCC8CD5BA5941000000007D432C41000000E0D5BA59413333333364432C4166666646D6BA59416666666648432C41CDCCCC0CD7BA59413333333331432C41666666E6D7BA59410000000021432C419A999999D8BA5941CDCCCCCC15432C419A9999D9D8BA59413333333308432C41000000C0D8BA59419A999999F8422C419A999999D8BA59419A999999EF422C4100000060D8BA594133333333DF422C41333333F3D7BA594166666666D3422C41333333F3D7BA594100000000C9422C4133333333D8BA594100000000B3422C4166666646D9BA59416666666698422C4166666626DBBA5941333333336F422C419A9999D9DDBA5941000000005E422C419A9999F9DFBA59419A9999994B422C41000000E0E2BA59419A9999993F422C419A999919E5BA5941CDCCCCCC37422C4133333353E6BA59410000000031422C419A9999D9E6BA5941000000002D422C41CDCCCCCCE6BA59416666666627422C4100000080E6BA59419A99999923422C41CDCCCCCCE5BA59413333333321422C4166666606E5BA5941CDCCCCCC16422C41CDCCCCCCE1BA5941000000000B422C4166666646DEBA594100000000FF412C41CDCCCC8CDCBA594133333333F3412C41333333D3DBBA59419A999999E6412C41CDCCCC4CDBBA594166666666D3412C419A999999DABA5941CDCCCCCCC6412C41CDCCCC4CDABA59419A999999BF412C4166666666DABA594100000000B6412C41333333D3DABA59419A999999AD412C4100000080DBBA594166666666A4412C41666666C6DCBA5941CDCCCCCC9E412C419A999939DEBA59410000000099412C4100000000E0BA5941CDCCCCCC91412C4133333353E1BA59410000000089412C41333333B3E2BA59419A9999997E412C41CDCCCC8CE3BA59419A99999974412C41000000A0E4BA5941666666666A412C4166666646E5BA59413333333345412C4133333333E9BA5941CDCCCCCC50412C41CDCCCCACFDBA5941CDCCCCCC5A412C410000006000BB59416666666669412C413333337303BB5941CDCCCCCC70412C416666662605BB59419A99999975412C416666664606BB59410000000077412C416666668607BB5941CDCCCCCC76412C41CDCCCC8C08BB59419A99999975412C410000006009BB59416666666673412C41000000E009BB59419A99999970412C41000000200BBB5941666666666F412C41333333130CBB59410000000072412C41666666460DBB59419A99999978412C419A9999F90FBB5941CDCCCCCC82412C41000000E012BB59419A99999986412C41CDCCCC0C15BB59416666666688412C416666664616BB59413333333388412C416666662618BB59413333333389412C41666666061BBB5941000000008F412C41666666661DBB59419A99999995412C41CDCCCCEC1EBB5941000000009E412C419A99997920BB59419A999999A7412C41CDCCCCAC21BB59419A999999B3412C41666666C622BB59419A999999BC412C41666666E623BB59419A999999C2412C410000000026BB594166666666C7412C41666666A627BB594100000000CB412C416666666629BB5941CDCCCCCCCA412C41CDCCCC2C2BBB59419A999999C5412C41333333B32CBB594133333333C2412C419A9999D92DBB59419A999999BF412C41666666062FBB594100000000C2412C41CDCCCC0C31BB59419A999999C8412C41CDCCCC6C32BB59419A999999DB412C41666666C635BB5941CDCCCCCCE6412C416666662637BB59419A999999E8412C413333331338BB59419A999999E7412C41666666A638BB594133333333E6412C413333333339BB5941CDCCCCCCE9412C419A9999193BBB594133333333EC412C41000000C03CBB5941CDCCCCCCEE412C41CDCCCC6C3EBB5941CDCCCCCCF2412C419A9999B93FBB5941CDCCCCCCF2412C41CDCCCCAC41BB59419A999999F9412C413333333344BB594133333333FE412C41000000C046BB59416666666607422C419A9999F948BB59413333333314422C419A9999594BBB5941CDCCCCCC26422C41CDCCCCAC4FBB5941CDCCCCCC2C422C413333331351BB59416666666635422C419A9999B953BB59410000000047422C419A99995958BB5941000000004F422C41333333535ABB59416666666654422C41666666E65CBB59410000000055422C41CDCCCCCC5EBB5941CDCCCCCC53422C416666660663BB59410000000054422C419A9999596BBB5941CDCCCCCC50422C413333333374BB59410000000051422C419A99999979BB59413333333352422C419A9999397DBB59416666666656422C41000000A07EBB5941CDCCCCCC6A422C41CDCCCC0C80BB5941CDCCCCCC92422C41CDCCCCEC81BB5941CDCCCCCCB2422C41666666A683BB594166666666D9422C419A9999D985BB59416666666608432C416666664689BB5941CDCCCCCC40432C41666666468CBB5941CDCCCCCC45432C41666666668DBB5941CDCCCCCC52432C41333333B38DBB5941CDCCCCCC5D432C41666666E68DBB5941CDCCCCCC67432C41333333338EBB5941333333337F432C41CDCCCC8C8EBB594133333333AF432C41CDCCCCCC8EBB5941CDCCCCCCC1432C41333333D38EBB59419A999999DB432C416666664690BB59416666666603442C41666666E693BB59413333333328442C416666660697BB59419A99999953442C41333333939ABB59419A9999998F442C41000000C09EBB594133333333A5442C419A999919A1BB5941CDCCCCCCA9442C41666666C6A1BB594100000000B2442C41CDCCCCECA3BB594133333333B1442C4166666666A7BB594133333333B0442C419A9999B9A9BB594133333333AD442C41666666C6ABBB594166666666AB442C4133333373ADBB5941CDCCCCCCA9442C41CDCCCC8CAFBB594133333333B5442C4133333333B1BB594166666666BB442C4166666606B2BB594133333333D5442C419A9999B9B2BB594100000000E3442C41666666E6B2BB59413333333304452C41CDCCCCECB2BB5941CDCCCCCC1A452C4100000080B2BB59413333333325452C4166666646B2BB59416666666642452C41000000E0B2BB5941000000006A452C4100000080B3BB59416666666679452C4166666686B4BB5941000000007F452C41CDCCCC6CB6BB59413333333381452C41333333D3B8BB59410000000080452C41CDCCCCCCBABB5941333333337C452C41CDCCCCCCBEBB5941000000007C452C41CDCCCC6CC1BB5941666666667F452C41666666C6C2BB59416666666689452C41000000C0C3BB5941CDCCCCCC92452C4133333333C4BB594100000000BA452C4100000060C4BB594166666666E6452C41CDCCCCACC4BB59413333333324462C4100000060C7BB59413333333341462C41CDCCCCCCC7BB5941000000005F462C4100000020C8BB59419A99999978462C419A999939C8BB5941000000008A462C419A999959C8BB5941CDCCCCCCA2462C419A999919C9BB59419A999999AC462C41CDCCCC2CCABB594100000000B9462C4166666686CBBB594133333333C4462C41CDCCCC8CCCBB59419A999999D4462C4133333393CEBB59419A999999E2462C419A999959D0BB594133333333FB462C41000000A0D2BB5941CDCCCCCC0D472C41CDCCCC6CD4BB59410000000022472C4133333313D5BB59419A99999939472C41666666A6D5BB59413333333346472C419A999979D5BB59416666666659472C41000000A0D4BB59416666666665472C4133333393D4BB59413333333375472C41000000A0D4BB5941CDCCCCCC82472C4100000000D5BB59413333333395472C4133333313D6BB5941CDCCCCCCAB472C4133333313D8BB594133333333C9472C4133333353DABB594166666666E4472C41CDCCCC8CDCBB594133333333FB472C4100000040DEBB5941000000000E482C4166666606DFBB59419A9999992C482C4133333353E0BB59419A99999938482C419A9999D9E0BB5941000000004C482C4100000020E2BB5941333333335F482C4100000080E3BB5941666666666F482C41CDCCCC6CE4BB59410000000083482C4166666606E5BB5941000000009A482C41333333B3E5BB594133333333AE482C41CDCCCCECE5BB5941CDCCCCCCBE482C4166666646E6BB594166666666DA482C41666666A6E6BB594100000000EB482C41000000C0E6BB5941CDCCCCCCF5482C4166666646E6BB594166666666FB482C419A9999B9E5BB59419A99999902492C4166666606E5BB5941000000000F492C41CDCCCC8CE4BB59410000000019492C4133333373E4BB59410000000025492C419A9999B9E4BB59416666666630492C419A9999B9E5BB59413333333337492C4133333353E6BB59419A9999993C492C419A999999E7BB5941333333333F492C4166666646E8BB59419A9999993E492C41000000C0E8BB59419A9999993F492C41CDCCCCACE9BB59419A99999941492C419A999959EABB5941000000004D492C4133333353EABB59416666666658492C419A999939EABB59413333333362492C419A999999EABB59419A9999996A492C41333333D3EBBB59416666666671492C4166666686EDBB5941333333337E492C41000000A0EFBB5941666666668A492C41666666A6F0BB59413333333399492C4133333333F1BB594100000000A5492C41666666A6F1BB59419A999999BA492C419A9999B9F1BB594100000000CB492C4133333313F2BB5941CDCCCCCCE2492C41000000C0F1BB594133333333F7492C419A999959F1BB594100000000044A2C419A999919F1BB5941CDCCCCCC0F4A2C41666666A6F0BB5941333333331A4A2C419A999939F1BB594100000000234A2C419A9999B9F2BB5941333333332A4A2C41666666E6F3BB5941666666662E4A2C41333333D3F5BB5941CDCCCCCC344A2C41CDCCCC6CF7BB5941CDCCCCCC3B4A2C4133333393F9BB594166666666434A2C4100000060FCBB5941333333334E4A2C4133333353FEBB594133333333544A2C41CDCCCCACFFBB59419A9999995D4A2C413333337300BC5941333333336E4A2C41CDCCCC8C00BC59419A9999997E4A2C419A99993901BC5941333333338D4A2C416666664602BC594166666666A54A2C416666668603BC594166666666B64A2C41CDCCCCEC04BC59419A999999C54A2C41CDCCCCEC05BC594100000000D84A2C41000000E007BC5941CDCCCCCCE24A2C41333333D309BC594133333333EE4A2C41CDCCCCEC0ABC59419A999999FA4A2C41000000A00BBC594100000000124B2C41333333D30BBC5941CDCCCCCC234B2C41666666060BBC5941CDCCCCCC2E4B2C41666666660ABC59419A999999364B2C410000008009BC5941333333333C4B2C416666662608BC5941CDCCCCCC434B2C419A9999F906BC5941000000004C4B2C419A99995906BC59419A999999534B2C41666666C605BC59419A9999995F4B2C41333333F305BC59419A999999694B2C41666666C606BC59419A999999724B2C41666666C607BC5941CDCCCCCC784B2C413333331309BC59419A9999997D4B2C419A9999590ABC59419A999999874B2C41000000200CBC594100000000984B2C41000000400DBC594166666666AD4B2C41CDCCCCEC0EBC594166666666BB4B2C41000000C00FBC594133333333CA4B2C41CDCCCC2C10BC59419A999999D64B2C41CDCCCC4C10BC594100000000E74B2C419A99993910BC594133333333144C2C416666660611BC594166666666314C2C41000000A011BC5941CDCCCCCC514C2C41000000E011BC5941CDCCCCCC624C2C41333333F311BC594100000000784C2C41CDCCCC6C11BC5941CDCCCCCC854C2C41666666E610BC594133333333904C2C413333335310BC5941666666669C4C2C41CDCCCCCC0FBC59419A999999A44C2C41CDCCCCAC0FBC594133333333AD4C2C413333331310BC594133333333B64C2C41000000E010BC5941CDCCCCCCBE4C2C419A99993912BC59419A999999CA4C2C41000000A013BC5941CDCCCCCCD54C2C410000002015BC59419A999999E84C2C416666664616BC594166666666FC4C2C419A99999917BC5941666666660B4D2C410000006019BC594166666666194D2C41CDCCCCCC1ABC594166666666274D2C419A9999191BBC594133333333324D2C419A9999591BBC594166666666434D2C419A9999991ABC5941CDCCCCCC534D2C41CDCCCC2C19BC594133333333664D2C419A9999F917BC59419A999999704D2C413333331317BC5941000000007C4D2C416666664616BC594133333333954D2C413333335316BC594100000000A94D2C41CDCCCC6C16BC5941CDCCCCCCBA4D2C41CDCCCC8C16BC59419A999999C54D2C41666666E616BC59419A999999D34D2C41000000A017BC59419A999999DD4D2C41666666A618BC594133333333E34D2C41CDCCCCCC19BC594100000000EB4D2C41333333B31BBC5941CDCCCCCCF94D2C41333333731FBC59419A999999FF4D2C416666666620BC59419A999999084E2C419A9999F920BC59419A999999154E2C41000000A020BC5941333333331D4E2C410000002020BC594100000000244E2C41000000601FBC5941CDCCCCCC264E2C41666666661EBC5941666666662C4E2C41333333D31DBC5941CDCCCCCC324E2C419A9999391DBC594100000000424E2C41CDCCCC4C1DBC59419A9999994B4E2C41666666661DBC59419A999999524E2C41000000A01DBC5941000000005B4E2C41666666A61EBC594166666666624E2C419A9999F91FBC594133333333664E2C410000006021BC5941000000006C4E2C419A99999922BC594133333333764E2C410000008024BC5941000000007B4E2C41CDCCCCAC25BC5941CDCCCCCC804E2C41CDCCCC2C26BC5941666666668E4E2C413333331326BC59419A999999954E2C41CDCCCC8C25BC594166666666A24E2C419A9999F924BC594166666666AE4E2C41333333D324BC594133333333B74E2C416666664625BC594166666666BF4E2C41000000C025BC594166666666CE4E2C416666664628BC594100000000D34E2C41CDCCCC4C29BC59419A999999D54E2C41666666E629BC594133333333DA4E2C41CDCCCC0C2ABC594166666666E34E2C41CDCCCCEC29BC5941CDCCCCCCF24E2C413333335329BC5941CDCCCCCCFC4E2C416666660629BC594133333333044F2C41333333D328BC59419A999999114F2C419A99995929BC594133333333214F2C41333333332ABC5941333333332F4F2C41333333332BBC59419A9999993F4F2C419A9999B92BBC59419A9999995B4F2C41333333932BBC5941CDCCCCCC8E4F2C41000000E02ABC59419A999999C74F2C419A9999392ABC594166666666EB4F2C41666666C629BC59410000000011502C41CDCCCC6C29BC59413333333321502C413333337329BC5941666666662E502C419A9999D929BC59419A99999938502C41666666A62ABC59416666666642502C41000000002BBC59419A9999994B502C41333333132BBC59413333333353502C41CDCCCCAC2ABC5941000000005C502C41666666A629BC59416666666665502C41666666C628BC59419A9999996D502C416666662628BC5941CDCCCCCC83502C41333333F327BC5941666666669A502C410000002028BC594100000000B3502C41CDCCCCEC27BC594133333333C2502C419A99991928BC594133333333C8502C41000000C028BC59419A999999D3502C416666666629BC594133333333DD502C41000000A029BC594100000000E7502C419A9999F928BC594100000000F2502C413333331328BC59419A999999FA502C419A99993927BC5941CDCCCCCC00512C410000002026BC5941CDCCCCCC0C512C413333333325BC5941CDCCCCCC15512C41000000C024BC5941CDCCCCCC1E512C41666666E624BC59413333333329512C41666666E625BC59419A99999934512C413333337326BC5941666666663E512C413333331327BC5941CDCCCCCC53512C41CDCCCCEC26BC59413333333369512C416666666626BC5941CDCCCCCC81512C41333333F324BC594133333333AF512C41CDCCCC0C23BC594166666666D1512C41333333F321BC5941CDCCCCCCE2512C41CDCCCC4C22BC59419A999999FD512C419A9999B922BC59419A99999916522C41CDCCCC4C22BC5941CDCCCCCC22522C41000000E021BC5941CDCCCCCC31522C41000000C021BC5941333333334D522C41000000C021BC5941000000005B522C419A99991921BC59416666666661522C413333333321BC59416666666670522C41CDCCCC4C21BC5941CDCCCCCC87522C419A99997921BC5941CDCCCCCC9D522C413333335321BC594166666666B9522C413333335320BC594133333333D3522C41333333931EBC594166666666E0522C41000000201EBC594166666666F2522C41000000201EBC59413333333304532C41000000601EBC5941CDCCCCCC20532C41666666461FBC5941666666662E532C41000000801FBC5941CDCCCCCC36532C41CDCCCCCC1EBC5941CDCCCCCC3E532C41CDCCCC6C1EBC5941666666664C532C419A9999991DBC5941666666665C532C41000000601DBC5941CDCCCCCC6A532C419A9999D91DBC59416666666684532C41CDCCCCEC1FBC59419A999999AA532C41CDCCCCAC22BC59419A999999E2532C416666668626BC59419A99999928542C41CDCCCC6C2CBC59410000000065542C416666668630BC59419A9999998F542C41333333F332BC594100000000B0542C413333335335BC594166666666D4542C410000008038BC594133333333E7542C410000008039BC594133333333FC542C41666666263ABC59419A9999990A552C41CDCCCC4C3ABC59419A9999995C542C41CDCCCCAC62BC59419A999999A4542C41CDCCCCCC70BC59419A99999988542C41CDCCCCEC77BC59410000000042542C41666666267CBC594133333333B4532C419A9999797DBC5941666666661C532C413333335378BC5941CDCCCCCCDF522C416666666685BC59419A9999999E522C41666666A693BC59413333333316522C41000000E09DBC59419A99999959512C41CDCCCC4CA9BC59413333333330502C41333333B3B0BC594166666666BF4F2C4100000080BABC59419A999999284F2C4100000040D0BC594166666666894E2C4166666666C1BC5941333333335E4E2C41333333D3CCBC5941CDCCCCCCFB4D2C4166666686DBBC59419A9999990B4E2C4100000020F1BC5941CDCCCCCCFA4D2C413333335309BD594133333333DE4D2C41666666A61CBD594166666666AC4D2C41000000602BBD594133333333264D2C419A9999F93FBD5941CDCCCCCC4C4D2C419A9999D95BBD5941666666664D4C2C416666664681BD594166666666E14B2C41CDCCCC6C83BD59419A999999D34B2C416666664684BD594133333333AA4B2C41666666E684BD594100000000D44A2C419A9999F983BD594100000000354A2C41CDCCCC4C83BD59410000000088492C41333333737FBD59413333333309492C419A9999B97EBD59419A999999BD482C41333333F381BD59419A99999974482C41CDCCCC8C81BD5941666666664E482C41000000807DBD59410000000025482C41CDCCCC4C78BD59416666666600482C416666664674BD594100000000F3472C419A99995975BD594133333333E6472C419A99999978BD594133333333BC472C41666666C683BD5941CDCCCCCC99472C41000000E08BBD5941CDCCCCCC96472C41333333138DBD59410000000097472C41333333F38DBD59419A99999996472C413333331390BD5941CDCCCCCC95472C410000006092BD59410000000090472C41666666E694BD59413333333386472C419A9999B996BD5941333333336F472C41666666669ABD59419A99999952472C41666666469EBD5941666666661E472C41333333B3A3BD59416666666600472C41CDCCCC4CA6BD594100000000DE462C4100000040AEBD59419A999999A3462C419A999939B1BD59419A9999991A462C4166666686BABD5941CDCCCCCCD1452C4100000060BFBD5941666666662E462C4100000020D3BD594166666666C7462C41333333B3FEBD5941000000004B472C416666668617BE594166666666D8472C419A9999D92DBE59413333333315482C41666666463ABE5941000000001C482C410000002044BE594100000000A1472C419A99995942BE59410000000089462C410000000036BE594166666666D8452C41CDCCCC6C0BBE5941CDCCCCCC9B452C41000000C002BE5941CDCCCCCCF1442C41333333B301BE5941333333330C442C41CDCCCC6C04BE5941CDCCCCCC3A432C41666666260CBE5941CDCCCCCC91422C413333339317BE59410000000011422C41333333F327BE59416666666639412C41000000E047BE59419A9999994A412C41000000E051BE59413333333351412C410000004059BE5941333333335C412C41000000C05FBE5941333333336A412C419A9999F964BE5941000000008A412C41666666066FBE59419A9999998E412C41CDCCCCAC71BE59410000000095412C413333339376BE59413333333395412C419A9999D976BE59419A99999999412C41000000A07BBE59419A999999A1412C41CDCCCC8C82BE594133333333AA412C41666666A68ABE594133333333B2412C41CDCCCC8C91BE5941CDCCCCCCB7412C413333333396BE5941CDCCCCCC44412C41666666C698BE5941333333333B412C419A999919B3BE5941666666666B402C4133333313B7BE59413333333383402C41666666E6C3BE59416666666690402C419A999919D1BE5941CDCCCCCCBA3F2C419A999979CDBE59419A9999996A3F2C41333333D3C9BE59419A9999991A3F2C41666666A6C8BE594133333333AA3E2C41333333B3C6BE594100000000AD3E2C4166666686CCBE5941CDCCCCCC893E2C41CDCCCC2CF2BE5941666666667C3E2C413333335313BF5941CDCCCCCC373E2C410000004013BF594166666666B93D2C419A9999F912BF59419A9999999D3D2C41CDCCCC6C17BF594100000000943D2C419A9999391EBF5941	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	01010000206A080000E811113B4D592C419A9999498FBD5941	700120000	Z	Amance	7001200	70012	70	27	18
01060000206A0800000100000001030000000100000047020000666666668A6F2C41000000C0FCD5594133333333936F2C4133333373FDD55941CDCCCCCCB06F2C4100000020FFD5594100000000DC6F2C413333335302D65941666666662D702C419A99995908D659410000000046702C41666666C609D659410000000038702C41CDCCCC6C0CD659419A9999993B702C41000000C00DD659410000000049702C41333333B30FD659413333333354702C410000002012D659410000000061702C410000000016D65941CDCCCCCC70702C410000000019D65941333333338A702C41000000401FD65941666666669D702C41666666A622D6594133333333A9702C416666662625D65941CDCCCCCCBD702C419A99991929D65941CDCCCCCC0E712C419A99999933D65941666666663A712C413333337338D659413333333385712C41CDCCCC4C52D6594100000000E1712C41333333736CD65941000000007A732C419A9999B99CD65941333333338B732C419A9999999FD659419A999999A6732C4166666626A4D6594100000000ED732C41333333D3ACD659410000000033742C41000000C0ACD65941CDCCCCCC64742C4133333333AAD659419A999999FA742C41CDCCCCCCA8D659410000000063762C419A999999B4D65941CDCCCCCC7C762C419A999979B6D6594133333333F0762C419A999999BDD659419A999999A3772C4166666666CAD65941CDCCCCCC1C782C419A999979D2D659419A999999A3782C4133333393DCD659413333333353792C419A9999F9EAD6594100000000077A2C41CDCCCC8CF9D6594133333333677A2C413333333301D7594166666666847A2C416666660604D7594166666666C27A2C41CDCCCC8C0AD7594100000000E87B2C419A9999592BD759419A999999277C2C419A9999F91FD759419A999999587C2C41CDCCCC6C13D75941CDCCCCCC147D2C4100000000F9D6594100000000EC7C2C41CDCCCC0CEFD65941CDCCCCCCF57C2C41CDCCCC4CEBD6594100000000457D2C419A9999F9DFD65941CDCCCCCC447D2C419A999979DDD65941CDCCCCCC3F7C2C4100000080CDD65941666666660D7C2C4133333313C6D65941CDCCCCCC027C2C419A999959BDD6594166666666027C2C419A999959B8D65941666666665C7C2C4100000000B7D6594166666666D87D2C41333333D3BCD65941666666661E7E2C4100000080BBD6594166666666637E2C4133333333B0D65941000000002B7F2C419A9999F9AAD65941CDCCCCCC837F2C41666666E69BD65941CDCCCCCCB57F2C419A9999999AD6594166666666B97F2C41000000C096D6594166666666C87F2C41333333D387D659413333333317802C410000004076D659419A99999966802C41CDCCCCEC6FD6594133333333EB812C41666666065ED659419A99999994822C419A99999957D6594100000000F8822C410000000050D659419A999999AF842C41666666864FD659410000000059852C419A9999D947D6594100000000D0852C419A9999B938D659410000000029862C41666666E62AD6594133333333D9862C419A999939F6D5594100000000A8872C41CDCCCC8CCBD559416666666681882C41333333D3A5D559410000000020892C41CDCCCC2C94D559416666666647892C41666666668BD5594100000000DC892C410000008078D5594166666666B68A2C416666668665D5594133333333FD8A2C419A9999995BD5594166666666EF8A2C41000000604CD55941000000000C8B2C413333339343D55941666666661D8B2C41000000403ED55941666666661F8B2C419A9999D92FD55941000000000C8B2C41000000E026D559419A999999DC8A2C419A9999391BD5594166666666BC8A2C41000000600ED5594166666666A88A2C41CDCCCCECF8D45941333333338B8A2C419A999919EAD459419A9999996B8A2C4166666626E3D4594166666666328A2C4133333353D6D4594100000000F3892C4166666686C9D4594133333333BA892C419A999999BED45941CDCCCCCC77892C4133333333B2D45941CDCCCCCC60892C4133333333A4D45941CDCCCCCC4C892C419A99997991D459419A99999945892C41666666C685D459413333333318892C419A9999796AD459419A99999917892C419A99991961D459416666666623892C416666662658D45941333333334E892C41CDCCCC2C4BD459410000000060892C41000000603CD459416666666662892C419A9999D931D45941000000004C892C413333335327D459419A99999925892C41000000401BD45941000000000F892C41CDCCCCCC0ED45941CDCCCCCC20892C416666666605D459410000000052892C41CDCCCC6CFAD35941000000008A892C419A999959F3D3594100000000CB892C419A999939ECD35941CDCCCCCC3A8A2C41CDCCCCECE3D359419A9999998E8A2C4133333333DDD3594133333333498B2C41CDCCCC4CD1D35941333333339A8B2C41CDCCCC4CCDD3594100000000018C2C4100000080C8D3594133333333618C2C41CDCCCC8CC2D359419A999999B58C2C4133333333C3D3594166666666428D2C41CDCCCCCCC5D35941CDCCCCCC5C8D2C419A999939C8D359419A9999998F8D2C41CDCCCCCCCCD3594100000000398E2C41666666667ED3594100000000D08D2C41666666065DD35941CDCCCCCCE48C2C41333333D30FD359419A999999A08C2C4100000000F7D25941CDCCCCCC928C2C41333333F3F1D2594133333333758C2C419A999979E9D2594100000000958C2C419A999939E5D2594100000000BD8C2C41CDCCCCECDED2594133333333E88C2C41000000E0D6D2594100000000078D2C419A999939D0D259419A999999178D2C41666666C6C8D2594166666666208D2C41666666C6BFD25941000000002E8D2C41333333F3B8D25941666666664B8D2C419A9999D9B2D2594133333333788D2C4100000020AED2594166666666978D2C4100000060AAD2594133333333AB8D2C4166666646A6D2594166666666B78D2C41CDCCCC8CA1D259419A999999B88D2C41CDCCCC4C9BD2594100000000D98D2C419A99999995D25941CDCCCCCC198E2C419A9999398BD2594166666666518E2C416666668683D2594100000000838E2C41CDCCCCCC7CD25941000000009A8E2C41000000C077D259419A999999B28E2C41000000E070D2594133333333C68E2C41333333336AD2594133333333D78E2C41666666A667D2594166666666F98E2C41CDCCCC4C64D25941000000000F8F2C416666662661D25941666666661B8F2C41666666065ED259419A999999308F2C41666666C655D25941333333333B8F2C410000008051D25941CDCCCCCC5E8F2C41666666664BD25941666666668D8F2C41CDCCCCCC47D259419A999999CB8F2C41CDCCCC6C45D2594133333333E98F2C41666666A643D25941CDCCCCCC49902C419A99999940D25941333333338B902C41000000603ED2594133333333B5902C41000000C03CD2594100000000C3902C41333333933BD25941CDCCCCCC00912C41CDCCCC4C33D25941CDCCCCCC47912C41666666C627D259416666666648912C41333333B326D259416666666648912C419A9999D925D25941333333334B912C41333333F324D25941000000004F912C41CDCCCC4C24D259413333333350912C413333335323D25941CDCCCCCC53912C419A9999B920D259410000000046912C419A9999191AD25941333333333F912C419A99999912D25941666666663B912C41666666860BD259416666666618912C419A99997904D2594166666666FF902C419A9999F9FFD159419A999999F0902C419A999919FED1594100000000E7902C419A9999F9FCD1594100000000DC902C4100000000FCD15941CDCCCCCCD2902C4100000020FBD1594166666666CC902C4166666626FAD15941CDCCCCCCC6902C4166666646F9D15941CDCCCCCCC4902C4166666686F8D159419A999999C3902C41666666E6F7D1594166666666C0902C4100000060F7D1594133333333BA902C41CDCCCCCCF6D159419A999999B3902C41CDCCCC8CF6D1594133333333AE902C4100000020F6D1594100000000A8902C4166666666F5D15941CDCCCCCCA2902C41CDCCCC6CF4D159419A9999999D902C4133333353F3D159410000000099902C4166666606F1D15941CDCCCCCC97902C41CDCCCC2CF0D159419A99999997902C4133333373EFD159416666666697902C41666666E6EDD159413333333397902C41CDCCCCCCECD159416666666697902C41CDCCCC8CEBD159419A99999997902C41666666C6EAD159413333333398902C41CDCCCCECE7D15941000000009B902C419A999999E6D1594166666666A8902C419A999919E2D159419A999999BD902C41CDCCCC2CE0D1594133333333BD902C4166666626DBD159419A99999909912C41CDCCCCECCFD159416666666611912C4166666666C0D159413333333305912C41666666C6BBD1594133333333C8902C41333333B3B8D159416666666667902C41666666A6B2D15941CDCCCCCC37902C4133333373AFD15941CDCCCCCCEF8F2C4166666646AFD15941CDCCCCCCC78F2C419A9999F9B2D1594166666666B98F2C41000000A0B4D1594100000000AD8F2C41000000C0B5D1594133333333A48F2C4166666646B6D15941CDCCCCCC938F2C4100000000B7D159419A999999868F2C41CDCCCC0CB7D1594166666666778F2C41666666A6B6D15941CDCCCCCC628F2C41666666E6B5D1594100000000508F2C41CDCCCC2CB5D159419A9999993F8F2C4133333313B5D1594100000000308F2C419A999939B5D15941000000001F8F2C419A999959B5D1594100000000158F2C4100000060B5D15941CDCCCCCC028F2C419A999979B5D159419A999999DD8E2C419A999979B5D1594133333333C68E2C4100000060B5D1594100000000B58E2C4166666606B5D1594100000000A68E2C4166666686B4D1594100000000A58E2C41CDCCCC6CB4D159419A999999918E2C41666666C6B2D159419A999999758E2C4166666626B2D15941333333335A8E2C4100000020B1D1594133333333428E2C4166666666AFD1594100000000168E2C4166666646ADD15941CDCCCCCCE68D2C419A9999F9ABD1594100000000B78D2C419A9999F9AAD15941CDCCCCCCB38D2C41CDCCCCECAAD1594166666666878D2C4133333393AAD1594133333333648D2C419A9999B9A9D15941CDCCCCCC378D2C41CDCCCCACA8D1594133333333FD8C2C41000000A0A6D15941CDCCCCCCCD8C2C41CDCCCC6CA4D15941000000009C8C2C4100000020A2D159419A999999718C2C4166666646A0D15941CDCCCCCC408C2C419A9999D99ED1594166666666088C2C41666666269DD15941CDCCCCCCDA8B2C41CDCCCC0C9BD15941000000009B8B2C41666666A698D1594100000000628B2C413333331396D1594100000000368B2C41000000E093D15941CDCCCCCC1E8B2C419A9999F991D15941333333330E8B2C41666666C68FD159419A999999FF8A2C41666666268DD159419A999999F38A2C41333333338AD159419A999999E48A2C419A99991986D15941CDCCCCCCCE8A2C413333331381D15941CDCCCCCCAC8A2C41000000207ED15941666666668F8A2C41333333337FD15941000000006B8A2C413333333380D15941CDCCCCCC488A2C41000000C080D15941CDCCCCCC328A2C41CDCCCCAC80D15941666666661B8A2C410000000080D159419A999999048A2C419A9999197FD1594166666666F2892C419A9999D97DD1594166666666DC892C41666666C67BD1594133333333A9892C416666666677D15941666666668F892C419A99991975D159416666666677892C41666666C672D159410000000061892C41000000A06FD159419A9999994E892C41000000006CD15941000000003B892C41CDCCCCAC69D159416666666625892C419A99991968D15941CDCCCCCC0A892C41666666A666D1594100000000E8882C416666662664D1594100000000D2882C416666666661D159419A999999BF882C419A9999795ED15941CDCCCCCCB3882C41000000605AD159419A999999B0882C419A99999956D159419A999999B1882C41000000E054D15941CDCCCCCCB8882C41000000C052D1594166666666C1882C41CDCCCC0C51D1594133333333CC882C419A9999B94FD1594133333333D2882C41333333F34DD1594166666666D6882C419A9999D94BD15941CDCCCCCCD6882C41333333F349D159419A999999D6882C41666666E647D1594100000000D4882C419A9999F945D1594100000000CE882C416666662644D1594100000000C4882C41CDCCCCCC42D1594133333333B8882C41CDCCCCAC41D1594100000000A1882C41666666463FD15941CDCCCCCC8C882C41CDCCCCAC3DD15941CDCCCCCC7F882C41000000203CD159413333333379882C41000000603AD159413333333374882C41333333B338D159419A9999996E882C41666666A633D15941333333336A882C41333333B328D159419A9999996E882C419A99991914D159413333333374882C41CDCCCCCC00D159410000000081882C4133333313F1D059419A9999998E882C41CDCCCCACE8D05941000000009B882C419A9999D9E3D059419A999999AD882C41666666E6DFD0594166666666C1882C41333333D3DCD0594100000000DB882C419A999979DAD059419A999999FA882C41000000C0D8D059410000000039892C4133333373D6D05941333333339C892C41CDCCCC8CD3D059419A9999994F8A2C41333333B3D1D0594100000000E68A2C4133333333D0D05941CDCCCCCC188B2C41CDCCCC0CD0D05941CDCCCCCC528B2C41000000A0CFD0594133333333818B2C4133333373CED059419A999999A88B2C4133333333CDD05941CDCCCCCCDE8B2C4166666646C9D059419A999999FE8B2C419A999939C6D05941CDCCCCCC028C2C41333333D3C5D05941000000000F8C2C4100000000C4D0594166666666138C2C419A999919C3D0594166666666168C2C41000000C0C1D05941333333331A8C2C41CDCCCCCCBFD059419A9999991A8C2C41666666C6BED05941CDCCCCCC198C2C41000000E0BCD0594100000000158C2C4166666606BBD05941333333330C8C2C4100000000B9D05941000000000B8C2C41CDCCCC0CB8D05941CDCCCCCC088C2C41CDCCCC4CB7D0594100000000048C2C419A999999B6D0594100000000F98B2C419A999979B4D059419A999999EA8B2C41666666E6B1D0594166666666D68B2C419A999979AED05941CDCCCCCCC38B2C41333333D3ABD059419A999999B08B2C41CDCCCCACA9D0594166666666998B2C419A9999F9A6D05941000000007D8B2C41CDCCCC4CA4D05941333333335F8B2C4100000060A2D05941CDCCCCCC378B2C41CDCCCCAC9FD05941000000001F8B2C41666666669ED0594133333333038B2C41CDCCCC0C9DD059419A999999EC8A2C419A9999F99AD059419A999999CD8A2C41000000E098D0594133333333C28A2C413333331398D0594100000000BA8A2C41CDCCCC4C97D0594133333333B28A2C41666666E696D0594100000000A48A2C41CDCCCC8C96D05941666666668E8A2C413333337399D0594166666666828A2C41CDCCCC2C99D0594166666666788A2C41000000A098D059419A999999688A2C419A99993998D05941CDCCCCCC5E8A2C41CDCCCCCC97D05941333333334E8A2C416666666697D0594100000000408A2C419A9999F996D0594166666666388A2C41333333D396D05941333333332C8A2C419A99999996D05941CDCCCCCC1B8A2C413333331396D05941CDCCCCCC068A2C41CDCCCC6C95D05941CDCCCCCCED892C410000006094D05941CDCCCCCCD3892C413333333393D0594100000000C2892C413333335392D05941CDCCCCCCB3892C416666664691D0594100000000A5892C41CDCCCC6C90D059413333333399892C41666666068FD059419A99999990892C41333333338ED059419A99999988892C41000000608DD059419A9999997B892C41000000608CD059416666666674892C419A9999D98BD05941CDCCCCCC66892C419A9999398BD05941333333335A892C41CDCCCC8C8AD059419A9999994F892C41000000E089D059419A99999948892C41CDCCCC2C89D059419A9999993C892C416666668688D059419A99999932892C41333333F387D059413333333326892C41666666C687D059419A99999920892C41CDCCCC4C87D05941333333331A892C41CDCCCC6C86D059416666666614892C41CDCCCC4C85D05941CDCCCCCC10892C410000006084D059419A99999910892C41666666C682D05941666666660F892C413333335381D059419A9999990D892C410000000080D059419A99999908892C41CDCCCC0C7FD059413333333303892C419A9999197ED05941CDCCCCCCF4882C41333333137DD0594166666666F3882C419A9999F97CD05941CDCCCCCCE2882C41666666C67BD0594100000000C8882C41CDCCCC8C7AD0594166666666AA882C41CDCCCC8C79D05941CDCCCCCC92882C41000000A078D059413333333379882C419A9999B977D059419A99999953882C413333337376D059419A9999992C882C410000006074D05941333333330B882C41666666A672D0594166666666EB872C416666668670D05941CDCCCCCCC5872C419A9999196ED05941CDCCCCCCA0872C41666666066CD05941666666668A872C41000000606AD05941CDCCCCCC7B872C419A9999F968D05941666666666E872C419A9999B967D05941CDCCCCCC56872C41CDCCCC4C66D059419A99999940872C41333333F364D05941CDCCCCCC20872C410000008063D059413333333305872C41CDCCCCEC61D0594100000000E6862C410000004060D0594166666666CE862C41000000005FD0594166666666B6862C41CDCCCC4C5DD0594133333333A3862C41000000005CD059419A9999998F862C41666666C65AD059416666666686862C419A9999595AD05941666666667D862C41CDCCCCEC59D059410000000069862C41666666A658D05941666666665A862C410000000058D05941CDCCCCCC4E862C410000008057D059410000000041862C419A9999F956D059410000000033862C410000000057D05941000000002A862C410000002057D059410000000020862C419A99999957D059416666666616862C410000004058D059410000000010862C410000002059D05941333333330B862C41000000605AD05941CDCCCCCC09862C41666666665BD059416666666609862C419A9999395CD059413333333303862C419A9999F95CD0594133333333FD852C41333333935DD05941CDCCCCCCF4852C41333333335ED05941CDCCCCCCEE852C41000000C05ED059419A999999E6852C419A9999995FD0594133333333DE852C419A9999F95FD0594100000000D1852C41CDCCCCEC5FD0594166666666DB862C41CDCCCCEC73D05941CDCCCCCCA4882C41CDCCCCCC85D0594166666666A1882C41CDCCCC6C98D059413333333340892C419A9999B9ABD0594166666666B5882C419A999939ABD05941CDCCCCCC14882C41CDCCCC6CADD0594100000000A0872C41CDCCCCCCB0D059413333333345872C41CDCCCCACB4D0594166666666FE862C419A999999BBD05941CDCCCCCC21862C4100000060ACD059413333333339852C41000000009CD059416666666622852C4133333353A1D05941000000008E832C41CDCCCCAC8FD059419A9999997C832C416666662691D05941CDCCCCCC56832C41666666469CD059419A9999992F842C41CDCCCCECA5D059413333333379852C41CDCCCC8CBBD059413333333375862C41333333B3CAD05941CDCCCCCC73862C4166666606CFD05941333333334A862C4100000000FBD05941666666662B862C419A9999D914D1594133333333EB852C41000000A02AD1594166666666AE852C413333333338D159410000000058852C41333333B337D15941CDCCCCCC21852C419A99991940D1594100000000D7842C41666666C64BD1594133333333A9842C41000000C047D15941CDCCCCCC0B832C410000006095D159413333333398822C41333333B397D1594166666666C6812C41666666C698D1594100000000FB802C41000000009AD15941000000004C802C419A9999D998D15941666666663C802C41000000A091D15941333333335E7F2C41CDCCCC2CA1D15941CDCCCCCCD67E2C41666666C6ACD1594100000000A37E2C419A999939B3D1594166666666F37E2C41000000A0C4D159419A999999CC7E2C4133333333C7D159419A999999EE7D2C419A999979C8D15941CDCCCCCC067E2C41666666C6D7D1594133333333707D2C4100000020DCD1594133333333BC7D2C419A9999B90CD259419A9999997E7D2C41000000A00DD2594133333333877D2C41CDCCCC0C16D2594166666666CF7E2C41000000A00FD25941CDCCCCCCCB7E2C413333333317D2594100000000D97E2C413333335322D259419A999999F27E2C416666662646D25941000000000B7F2C41000000806CD2594166666666447F2C419A99993979D25941333333339E7F2C419A99991987D25941CDCCCCCC2A802C41000000807BD25941000000001F802C419A9999B97FD259419A99999935802C41CDCCCC6C87D25941000000005F802C41000000609BD259416666666683802C41333333F3C0D259419A99999956802C41000000C0C8D2594133333333F87F2C419A9999D9C8D2594133333333E77F2C41666666E6CCD259419A9999991D802C419A9999F9D7D2594166666666AE802C419A9999B9E0D259413333333301812C41666666E6FBD25941CDCCCCCC02802C41666666A60AD359413333333364802C419A99999948D359410000000058802C410000002049D35941666666663C802C41333333D349D359410000000025802C41333333334AD359413333333307802C41666666C64AD359419A999999DC7F2C419A9999994AD359419A999999A57F2C41CDCCCC6C4AD359419A999999727F2C41333333B34AD3594100000000467F2C41666666A64AD3594100000000267F2C41000000A04AD35941CDCCCCCC087F2C41000000E04AD3594166666666F17E2C419A9999594BD3594166666666D67E2C41333333934CD3594100000000B17E2C41666666A64ED35941666666668A7E2C419A9999F950D35941CDCCCCCC5F7E2C410000004053D35941CDCCCCCC347E2C41CDCCCC8C55D35941333333331B7E2C41333333B356D3594166666666F47D2C416666668658D3594100000000D47D2C41CDCCCC0C5AD3594133333333C37D2C41333333B35AD3594100000000917D2C41333333335BD359419A999999637D2C41333333535BD35941CDCCCCCC2E7D2C41000000605BD3594166666666107D2C41CDCCCC2C5BD3594166666666CE7C2C41000000405FD3594166666666DB7C2C419A9999B973D35941CDCCCCCCBE7D2C419A99991980D3594100000000AC7D2C41CDCCCC4C8BD359419A999999BB7D2C410000004091D3594166666666E77D2C41CDCCCCEC93D359419A9999995A7E2C413333337392D3594133333333297F2C416666666691D3594166666666247F2C41000000A08AD359419A9999998E7F2C419A9999F983D35941666666660C802C416666660680D35941666666666C802C416666664684D359419A999999E1802C41000000C09AD3594166666666A8812C419A9999798AD359413333333355822C41666666E675D359419A99999954822C419A9999B9C6D35941CDCCCCCC51822C41333333531BD45941CDCCCCCC167D2C41333333D3CAD35941666666668E7B2C41000000A0B2D3594133333333657B2C41666666A6AFD3594133333333407B2C41CDCCCC6CADD3594166666666087B2C4166666606AAD359419A999999CF7A2C4166666666A6D359419A9999999A7A2C41CDCCCCACA3D359419A9999996C7A2C4100000040A0D359413333333369792C41000000E090D35941000000000F792C419A9999F98BD359419A99999905792C419A9999B994D3594166666666F0782C41CDCCCCCCD3D35941CDCCCCCC0C792C41CDCCCC8CDDD359419A999999C7782C419A999979C1D459416666666698782C41333333D35CD559416666666694782C413333333395D55941CDCCCCCC79772C41CDCCCC2C90D559416666666646762C410000004089D55941CDCCCCCC1D752C419A99993980D55941CDCCCCCCEC712C41666666E66DD5594166666666E2712C416666664670D5594166666666D4712C416666660673D55941CDCCCCCCC3712C410000006076D5594100000000BA712C41666666A678D5594166666666AA712C41666666C67AD55941CDCCCCCC9A712C41000000807CD55941CDCCCCCC8C712C41666666C67ED55941333333337A712C41000000E080D559413333333365712C41666666E683D559419A9999993C712C41CDCCCC2C88D559416666666628712C419A9999F98AD559419A999999E2702C41666666E686D5594166666666D7702C416666668688D55941CDCCCCCCBC702C41CDCCCC0C8DD5594166666666A9702C419A99995990D55941CDCCCCCCA3702C413333337391D559416666666688702C41CDCCCCAC96D559416666666667702C41333333539FD55941333333334C702C4100000040A7D559419A99999936702C41666666A6ACD559413333333324702C4133333313B2D55941CDCCCCCC11702C419A999979B7D559410000000002702C4100000040BCD5594166666666EE6F2C4166666646C2D5594166666666DD6F2C4100000000C7D559419A999999CE6F2C41333333B3CAD5594166666666C16F2C41CDCCCC4CCED5594166666666B56F2C41666666A6D1D5594100000000AB6F2C4166666666D4D5594166666666946F2C419A999919DAD55941000000008C6F2C4100000080DBD559419A999999946F2C4100000060DFD559419A999999AF6F2C41CDCCCC4CE7D5594133333333B56F2C4100000000EBD559419A999999AD6F2C4133333393F0D559419A9999999D6F2C4100000060F7D55941666666668A6F2C41000000C0FCD55941	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	01010000206A0800007CB130D205882C4166666696BAD35941	700130000	Z	Ambiévillers	7001300	70013	70	27	12
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	01010000206A0800002BC758A3B8322D41333333D3E4B25941	700140000	Z	Amblans-et-Velotte	7001400	70014	70	27	10
01060000206A080000010000000103000000010000006901000066666666EE4F2C413333337398B859413333333346522C419A9999D909B95941666666665D522C41CDCCCC6C0DB959419A99999970522C41333333F30BB959419A99999957552C4166666646D3B85941333333337D552C419A999979CEB85941CDCCCCCCBE552C419A9999F9C4B859410000000024562C4166666666C0B859413333333334562C4166666646C3B85941CDCCCCCC54562C4166666606C9B85941CDCCCCCCFD572C416666664613B95941CDCCCCCC14582C41333333930DB9594166666666CF592C41CDCCCCACA6B8594166666666395A2C416666666693B85941333333330F5A2C41333333138EB85941CDCCCCCCF1592C41000000A087B859419A999999DD592C419A99997982B859419A999999D3592C41666666A67CB8594133333333D3592C416666668676B8594133333333D5592C41000000C072B8594133333333625A2C41333333F372B85941CDCCCCCC775A2C41666666E64BB8594100000000995A2C41333333934EB85941CDCCCCCCAA5A2C419A9999F94EB8594133333333C35A2C41333333B34EB859419A999999E25A2C41333333D34CB85941000000000A5B2C410000002048B85941CDCCCCCC315B2C416666662644B8594166666666475B2C419A9999F942B85941000000007A5B2C41000000E041B8594100000000B05B2C419A99999942B859419A999999F65B2C41CDCCCCCC43B859419A9999992D5C2C41CDCCCC6C44B85941CDCCCCCC5A5C2C41CDCCCC8C30B859419A999999605C2C41CDCCCC6C2BB8594100000000395E2C41333333533FB85941666666663F5E2C41CDCCCC2C1AB859419A9999993F5E2C413333331319B859419A999999585E2C413333335316B85941CDCCCCCC7F5E2C41CDCCCC0C12B8594100000000AE5E2C41000000600FB859419A999999CB5E2C41CDCCCCAC0DB8594100000000DA5E2C41666666060FB85941CDCCCCCCEC5E2C419A99995910B85941CDCCCCCC1C5F2C41666666E612B85941CDCCCCCC245F2C416666662613B859419A9999993F5F2C419A9999F913B859419A9999995C5F2C416666668614B85941333333337E5F2C410000002015B85941CDCCCCCCA25F2C410000008015B85941CDCCCCCCC65F2C41CDCCCC2C16B85941CDCCCCCCEB5F2C419A9999D916B85941CDCCCCCC08602C41000000C017B85941000000001B602C41333333B318B859416666666627602C41333333331AB85941000000002C602C41CDCCCC2C1CB859413333333331602C41666666C61DB859419A9999993C602C413333335320B85941000000004E602C416666660623B85941666666665B602C41CDCCCCCC25B859419A9999996E602C419A99999928B85941CDCCCCCC82602C41CDCCCC6C2BB859419A9999999C602C41333333332EB8594133333333AB602C413333333330B8594100000000C0602C41333333B333B85941CDCCCCCCD0602C41CDCCCCEC35B859419A999999E4602C413333335337B8594100000000F7602C416666660639B859416666666613612C419A9999D93AB859419A99999934612C41000000C03CB85941CDCCCCCC54612C41666666263EB85941CDCCCCCC7E612C41CDCCCC6C3FB8594166666666A5612C41CDCCCC8C40B859419A999999CC612C41CDCCCCAC41B8594100000000FD612C413333339343B859419A9999992B622C419A99999945B859410000000050622C410000004047B85941000000006D622C41666666C648B85941666666668A622C419A9999994AB8594100000000AA622C41000000604CB85941CDCCCCCCC2622C419A9999B94DB85941CDCCCCCCDA622C41CDCCCC2C4EB85941CDCCCCCCF1622C41CDCCCC8C4EB85941CDCCCCCC0F632C419A9999594FB85941CDCCCCCC2C632C410000002050B859410000000047632C419A99999950B859419A99999974632C41CDCCCC4C51B85941666666667A632C419A99995951B859413333333315642C41000000A053B85941333333339B642C410000000054B8594100000000C4642C413333339356B8594100000000DC642C41000000005BB859419A999999E6642C410000004061B859410000000002652C419A99997961B85941666666660F652C413333339361B85941CDCCCCCC34652C41333333F362B859410000000057652C41666666E665B859419A99999978652C419A99997967B85941333333339B652C413333337369B859419A999999AE652C41333333736BB859419A999999BD652C41CDCCCCEC6FB85941CDCCCCCCC1652C419A99997974B8594133333333C2652C41333333D377B8594133333333C2652C419A9999D978B8594100000000C4652C41666666C679B859419A999999D5652C41000000A07AB8594166666666EC652C41666666067BB859410000000002662C419A9999B97AB85941CDCCCCCC15662C41666666867AB859419A99999921662C416666668679B859419A99999929662C41666666A677B85941000000002F662C419A99993975B859413333333339662C413333335372B85941000000003A662C41CDCCCCAC71B85941333333333B662C41CDCCCCEC70B859416666666641662C41CDCCCC8C70B859413333333348662C419A9999F96FB859419A9999994A662C41000000006FB85941000000004D662C41CDCCCC8C6DB859410000000052662C41000000206DB859413333333361662C419A9999396BB85941000000006C662C41CDCCCC0C6AB85941CDCCCCCC59662C410000002067B859419A99999941662C413333339364B85941000000002F662C416666662663B859410000000012662C419A99993962B8594166666666F0652C413333335361B859419A999999D1652C41CDCCCC2C60B8594166666666BD652C41333333F35EB8594100000000AE652C41CDCCCCAC5DB85941333333338F652C41666666065AB85941666666666C652C41000000E055B85941CDCCCCCC55652C41000000E053B859410000000045652C413333335352B85941CDCCCCCC0F652C419A9999394EB8594133333333DE642C41333333734AB8594166666666B0642C41666666E647B859419A9999998A642C419A99993946B859413333333363642C41333333F344B859410000000029642C41666666E642B85941CDCCCCCCEE632C41333333B340B859419A999999B5632C419A9999393EB859419A999999F8632C413333333323B8594133333333B2642C419A9999992BB859419A999999CF642C41CDCCCC4C2CB85941CDCCCCCCCD642C41666666A628B85941666666668F642C41CDCCCCCC1AB85941333333336A642C410000004012B859419A9999995A642C416666664605B8594133333333D4642C419A9999F906B859416666666634652C410000006007B859419A99999984652C41CDCCCCCC09B859416666666606662C416666666608B859410000000038662C419A99999904B859416666666623662C41000000E0FBB75941000000000F662C41666666E6F6B759413333333349662C4100000020F3B759419A999999A8652C41000000C0D2B75941CDCCCCCC8D652C4133333373C6B7594100000000CE652C4166666606BFB75941000000008F652C41CDCCCC6CA6B759410000000086662C410000008096B759410000000039662C413333337381B759419A999999F9652C41000000007EB759419A99999909662C41666666866AB7594100000000C6672C41CDCCCC6C67B75941333333331F672C419A9999794AB75941666666666B672C416666666645B759419A999999B7672C413333331340B7594100000000F4672C41333333F33BB75941CDCCCCCC1C682C410000004039B759419A9999994E682C416666662637B759413333333383682C41CDCCCC8C35B759419A999999C7682C419A9999B933B759419A99999904692C419A99997932B759410000000061692C413333339330B759416666666681692C41CDCCCCEC2FB759419A999999FB692C41CDCCCC6C2DB7594133333333156A2C41000000802DB759419A9999990F6A2C413333337321B75941CDCCCCCC9F692C419A9999D904B759416666666663692C41000000A0F7B65941333333333C692C419A999919F2B659419A99999925692C41000000C0E5B6594100000000AD682C4166666666D9B659413333333382682C41666666E6D4B65941333333333B682C4133333373D9B65941CDCCCCCC16682C41CDCCCC0CD7B6594166666666D0672C4166666666CEB65941CDCCCCCC0F672C4100000040BEB6594133333333CA662C41333333B3BBB65941000000004A662C41333333D3C4B6594133333333E2652C41000000C0C7B6594133333333B4652C419A999939C6B65941333333336E652C41CDCCCC0CC5B65941666666661E652C41000000A0C7B659419A9999997E642C41CDCCCC0CC9B6594133333333D8632C4133333373CBB659419A999999BC632C419A999999C8B6594100000000B6632C4133333353C2B659410000000048632C41666666E6BCB659410000000040622C41CDCCCC6CAEB65941666666663E622C419A9999B9ACB65941000000003D622C4133333393ABB659413333333334622C41CDCCCC4CA4B659416666666630622C41CDCCCC8C9EB659410000000033622C41000000C099B65941666666663E622C419A9999F993B659416666666604622C41CDCCCC8C87B659419A9999991C612C41CDCCCC8C68B6594166666666E0602C410000006067B659419A999999AE602C41CDCCCCEC69B659419A99999989602C419A9999596FB659419A99999974602C41CDCCCCAC70B6594100000000DE5F2C41666666667AB6594133333333725F2C41CDCCCC8C81B659419A9999992B5F2C41000000E084B65941333333330A5F2C41CDCCCC2C88B65941CDCCCCCC375F2C41666666E691B659419A999999675E2C410000004097B65941666666660C5E2C41CDCCCC6C7BB6594133333333B15D2C416666664680B65941000000009F5D2C413333339379B659419A999999885D2C41333333B373B65941CDCCCCCC705D2C41666666066DB6594133333333675D2C416666662667B6594100000000585D2C419A9999F95EB65941CDCCCCCC535D2C416666662657B6594100000000575D2C41CDCCCC6C50B65941666666663A5D2C410000008054B6594133333333155D2C41666666C657B6594133333333E25C2C413333337359B659419A999999935C2C41666666C65BB6594100000000385C2C41CDCCCC6C5FB65941CDCCCCCC075C2C41CDCCCC2C64B659419A999999EC5B2C419A9999F96CB6594166666666B25B2C410000000075B65941666666667C5B2C41666666067AB65941CDCCCCCC025B2C410000002086B659419A999999AB5A2C41000000608DB6594166666666585A2C419A99993992B65941CDCCCCCCF7592C41CDCCCCCC97B6594100000000B7592C419A9999D999B65941CDCCCCCC8D592C419A9999F99AB65941CDCCCCCC6A592C41000000409BB659419A99999968592C41666666469BB659410000000067592C41666666469CB659413333333361592C41000000C09DB65941CDCCCCCC52592C41CDCCCC0CA0B659419A99999930592C419A9999D9A2B65941CDCCCCCC04592C41CDCCCCACA4B6594100000000DE582C41CDCCCCACA6B6594166666666BE582C41333333D3A9B6594133333333AA582C4166666646ADB65941000000009A582C4166666646B1B659419A99999993582C41000000C0B4B659410000000091582C41CDCCCC6CB8B65941000000008C582C41000000E0C1B659419A9999998B582C41000000C0C3B659419A99999989582C4100000060CAB659413333333389582C41666666E6CDB65941CDCCCCCC79582C4100000000CDB659410000000072582C41CDCCCC4CCBB659416666666661582C4166666646C7B65941CDCCCCCC52582C41CDCCCCCCC2B65941666666663C582C4166666626BEB65941000000002B582C4133333333BBB659410000000025582C41000000C0C0B659416666666621582C419A999919C9B65941333333331F582C4166666666D0B659416666666621582C4166666686D5B65941CDCCCCCC26582C41CDCCCCECDFB659419A9999992B582C41CDCCCC4CE6B65941666666662B582C4133333353EAB6594166666666FD582C41666666E61BB759419A999999EC582C41CDCCCCEC1CB7594100000000D6582C41333333F31DB759419A999999BC582C41CDCCCC0C1FB759413333333376582C41CDCCCCCC21B75941CDCCCCCC28582C41CDCCCC0C25B759419A99999910582C416666664626B7594133333333F0572C416666664627B75941CDCCCCCCC1572C41666666C628B75941333333337C572C41CDCCCC6C2BB759419A99999950572C41000000C02CB75941666666663B572C41666666662DB7594133333333FF562C419A9999D92EB75941333333330C572C416666660633B75941CDCCCCCC11572C41333333D334B75941000000001A572C416666666637B759416666666626572C419A9999993BB75941CDCCCCCC2E572C419A9999593DB759419A99999936572C41CDCCCCEC3EB759416666666650572C419A99993944B759410000000076572C419A9999194EB759416666666683572C419A99999959B75941CDCCCCCC8D572C413333335362B759416666666695572C413333339368B759419A999999E4572C410000006067B7594166666666D8572C419A9999596DB759419A999999D5572C41666666E66EB75941CDCCCCCCD0572C41CDCCCC6C76B759419A9999998A572C410000004078B759419A99999952572C41000000C079B759413333333320572C41666666067AB7594166666666D7562C41333333737AB7594166666666F7562C419A9999F982B759416666666614572C41000000A08AB759416666666615572C41333333D38BB75941000000001B572C41CDCCCCEC91B759416666666666572C419A9999799BB75941CDCCCCCC79572C41000000409DB75941CDCCCCCCA1572C41333333F3A0B75941666666668A572C419A999939A4B759419A9999994F572C4166666686ACB759419A99999930572C41000000E0B0B75941666666662A572C41666666C6B1B7594100000000C3572C41CDCCCC6CC0B7594166666666BD572C41CDCCCCCCCFB7594100000000B5572C419A999919D6B75941666666665C572C41000000A0E0B7594100000000D3562C41666666A6CBB759416666666620562C41666666C6DEB759419A9999994A562C4166666686E7B75941CDCCCCCC27562C41666666A6EBB759419A999999F4552C419A999939E3B7594100000000CB552C419A999959E4B75941CDCCCCCC99552C4133333353D5B759419A9999996B552C4166666646D2B75941CDCCCCCC5F552C4100000020D3B75941000000003A552C4133333313D6B75941333333331F552C419A9999D9D9B7594166666666F4542C4166666666DCB75941CDCCCCCCA4542C419A999979E1B759419A9999998A542C4166666626E4B75941CDCCCCCCA9542C4133333373EDB7594100000000BA542C41333333F3F2B75941666666660B542C41CDCCCC0C09B859410000000082542C419A99997928B859416666666681542C419A99999940B8594133333333A7542C41666666E649B85941666666661B552C41000000805FB859419A99999932552C416666666662B859416666666674552C41666666E664B8594100000000E3552C419A99991966B85941CDCCCCCC29562C41CDCCCC0C69B859419A9999991B562C41000000606EB859410000000014562C410000004071B8594166666666EB552C41000000607AB85941CDCCCCCCA4552C41CDCCCCAC95B85941CDCCCCCC8D552C41CDCCCCAC9EB85941CDCCCCCC5C552C41CDCCCCAC94B859419A999999FC542C41666666A681B8594133333333CE542C41333333B378B85941666666668F542C41333333F36CB859410000000051542C41CDCCCC8C61B85941666666661B542C41666666A656B859419A999999EC532C419A9999B94DB8594100000000C8532C419A9999F946B8594133333333A8532C419A99999949B8594166666666EE4F2C413333337398B85941	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	01010000206A0800009EB79538965E2C4166666666B8B75941	700150000	Z	Amoncourt	7001500	70015	70	27	4
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	01010000206A080000FFE55F66A6802D41333333C378C75941	700160000	Z	Amont-et-Effreney	7001600	70016	70	27	17
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	01010000206A0800008C09170E3B792C4166666666B9C55941	700170000	Z	Anchenoncourt-et-Chazel	7001700	70017	70	27	14
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	01010000206A0800002C45AB44756D2B419A9999D90F975941	700180000	Z	Ancier	7001800	70018	70	27	5
01060000206A08000001000000010300000001000000930000009A99999960682C4166666626F8A659416666666675682C41CDCCCC6C07A75941666666668E682C41000000A022A75941CDCCCCCCA6682C413333335334A759419A999999BB682C419A99991941A7594100000000C0682C41333333D352A759419A999999C0682C41CDCCCC8C5DA7594133333333CB682C41CDCCCCCC65A759410000000005692C41000000407DA759410000000027692C419A9999798CA759419A99999931692C41CDCCCC2C97A75941CDCCCCCC17692C41CDCCCC4CA0A7594100000000F8682C419A999999AFA75941CDCCCCCCF8682C419A9999F9BBA75941333333330A692C41CDCCCC2CC9A75941CDCCCCCC1B692C41CDCCCCCCD8A759419A9999994E692C4133333393ECA75941CDCCCCCC5D692C419A999979F1A759410000000069692C41CDCCCC0CF5A75941CDCCCCCC7D692C41666666C6FBA7594133333333C4692C41000000C009A85941666666660A6A2C41CDCCCCAC17A8594166666666396A2C41000000801FA85941CDCCCCCC066B2C41CDCCCCEC41A859419A999999E76B2C41000000E088A8594166666666586C2C419A999979B4A8594133333333B46C2C4100000060CDA85941666666663D6E2C416666660603A959419A9999994E6E2C41CDCCCC6C02A959419A999999876E2C41CDCCCC4C00A9594100000000BB6E2C4100000040FEA85941CDCCCCCCD96E2C4100000000FDA8594166666666F46E2C419A999919FCA859419A999999096F2C4166666666FBA859419A9999992F6F2C41CDCCCC4CFAA8594100000000556F2C41000000E0F8A859419A9999997A6F2C4133333353F7A85941CDCCCCCCA86F2C4133333353F5A8594166666666D16F2C41000000E0F3A85941CDCCCCCCF36F2C4133333353F2A859410000000014702C41666666C6F0A859419A99999930702C41CDCCCCCCEEA859419A99999994702C4166666686FAA859413333333353712C41CDCCCC8C05A9594166666666FD712C41000000600AA9594133333333C5722C41666666260AA95941000000001F732C41CDCCCC8C07A959419A99999946732C41666666C603A9594133333333AD742C41666666E6F1A8594166666666E0782C4166666646B7A85941CDCCCCCC25792C41333333F3B0A85941666666662D7A2C41CDCCCCECA7A85941333333336E7A2C41000000A0A4A85941CDCCCCCCB57A2C4133333313A1A859419A999999127B2C41000000609CA859419A999999647B2C419A99993998A859419A999999867B2C41666666C696A85941CDCCCCCCAD7B2C41CDCCCCEC94A859419A999999CC7B2C419A99997993A85941666666669C7C2C416666660688A859419A9999991D7D2C41666666E67DA8594166666666527E2C41333333936EA859419A999999557F2C41CDCCCC8C65A859413333333376802C410000000055A85941CDCCCCCC06802C41666666A63EA85941000000006F7F2C413333335323A8594133333333AE7E2C41CDCCCC0CF9A7594166666666A47D2C41666666E6A1A75941CDCCCCCCDC7C2C4100000020A7A7594133333333B47C2C41CDCCCC6C9EA7594133333333967C2C41333333F39BA7594133333333C57B2C41CDCCCCECA9A75941000000006C7B2C41000000C0B2A7594100000000447B2C41CDCCCC0CB4A7594100000000FD7A2C41666666E6A3A759419A9999998D7A2C416666660690A7594133333333287A2C41666666E67AA75941333333330A7A2C41CDCCCCAC79A759419A999999BA792C41666666C67EA759410000000012792C41CDCCCC6C90A7594100000000F4782C419A99997990A759413333333348782C41CDCCCC2C75A759419A999999BA772C419A9999595CA75941333333330B772C41CDCCCC4C64A7594166666666F8762C41CDCCCC8C5FA75941CDCCCCCCBD762C410000004051A75941333333336C762C41333333933CA75941333333333A752C41CDCCCC8C50A759419A999999EA742C410000006054A75941000000001F742C41000000E01EA75941000000000B742C41666666A61DA7594166666666BB732C419A9999B922A75941CDCCCCCC61732C413333339326A759410000000043732C41000000A01CA759419A9999991A732C41CDCCCC6C16A75941000000007B722C419A9999591AA759419A999999E5712C410000000022A75941CDCCCCCC6E712C419A9999D92FA75941CDCCCCCCE3702C41000000C03DA7594166666666E86E2C41666666865DA7594166666666A26E2C419A9999995DA75941CDCCCCCC8D6E2C410000002056A7594133333333F66D2C41CDCCCC0C3CA7594133333333FF6D2C41CDCCCC4C2EA75941CDCCCCCCCC6D2C410000002028A75941CDCCCCCCCB6C2C41333333F311A7594166666666A26C2C41CDCCCC6C0FA75941000000007E6C2C41333333130DA75941666666665F6C2C41666666060BA7594100000000426C2C410000000009A759419A999999296C2C413333333307A7594100000000116C2C419A99995905A75941CDCCCCCCFF6B2C419A99993904A7594100000000F16B2C419A9999D903A7594166666666E26B2C41CDCCCCAC03A759419A999999D66B2C41000000A003A7594166666666CB6B2C41666666E603A7594133333333BE6B2C41666666A604A7594100000000B36B2C41333333B305A7594166666666AC6B2C41CDCCCC4C06A7594166666666A56B2C41333333D307A7594166666666A16B2C410000002009A75941000000008E6B2C419A9999D904A759419A9999997F6B2C41666666C600A7594100000000746B2C41CDCCCC0CFDA6594166666666626B2C41CDCCCC2CF8A65941000000005A6B2C41666666C6F3A6594166666666496B2C41666666A6EDA659419A999999356B2C4133333393E5A6594100000000276B2C419A999959E0A6594133333333236B2C4166666666DDA65941CDCCCCCC216B2C4166666666D9A65941CDCCCCCC196B2C41CDCCCC0CD5A65941CDCCCCCC0F6B2C41666666E6D2A6594133333333F96A2C4166666686CEA6594133333333D06A2C41CDCCCCECC8A6594100000000A66A2C4133333373C4A659419A999999766A2C41666666A6BFA6594133333333056A2C419A999979B4A6594100000000EE692C419A9999D9B2A65941666666663B692C419A999939A6A659416666666681682C41000000A095A659419A99999971682C4166666626A3A65941333333336F682C419A999979ADA65941666666667A682C41CDCCCC6CC0A659413333333362682C41CDCCCC0CE1A659419A99999960682C4166666626F8A65941	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	01010000206A080000C42CA481A3732C41CDCCCCFCD0A75941	700190000	Z	Andelarre	7001900	70019	70	27	4
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	01010000206A0800006CAFC8D5AB772C413333333302A75941	700200000	Z	Andelarrot	7002000	70020	70	27	6
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	01010000206A08000095763D61059A2D41000000F014B15941	700210000	Z	Andornay	7002100	70021	70	27	1
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	01010000206A080000FE2209773CBC2B41000000D035985941	700220000	Z	Angirey	7002200	70022	70	27	9
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	01060000206A08000001000000010300000001000000B70000000000000010A02C419A9999191AC95941666666665CA02C41CDCCCCCC1EC959416666666615A12C41000000002EC95941CDCCCCCCD0A12C41CDCCCCEC41C95941CDCCCCCC31A22C419A99995954C9594100000000DDA12C41666666A659C95941CDCCCCCCBFA12C41000000605DC959419A9999996EA22C413333339378C9594166666666E3A22C41000000A0ACC95941CDCCCCCC68A32C4100000080D7C959419A99999925A52C41666666461CCA5941CDCCCCCC6CA52C419A9999D917CA5941CDCCCCCCD2A52C41333333F315CA5941333333330DA62C41CDCCCC0C0ACA59416666666625A72C419A99993909CA59419A9999994EA72C41000000400DCA594100000000DEA72C41666666260ECA5941666666664CA92C41CDCCCCCC0ECA59413333333304AA2C41CDCCCCAC0FCA5941CDCCCCCC58AD2C4133333333C3C959410000000047AD2C41333333F38AC95941CDCCCCCCEEAC2C410000002077C95941CDCCCCCC05AD2C41CDCCCC8C71C95941CDCCCCCCEFAC2C41666666864DC959413333333371AD2C41666666A638C9594133333333B3AD2C416666664630C95941CDCCCCCC1CAE2C41666666262CC959413333333355AE2C41CDCCCCEC2AC95941CDCCCCCC58AE2C419A99997924C959416666666691AE2C410000006020C9594166666666AAAE2C416666662617C95941CDCCCCCCF6AE2C41666666A60AC95941CDCCCCCCF6AE2C41CDCCCC0CF7C859416666666603AF2C41333333B3EEC85941000000002EAF2C41CDCCCC0CE6C85941CDCCCCCC70AF2C419A9999F9DBC859419A999999ACAF2C41666666A6D6C85941CDCCCCCC68B02C41666666E6C2C85941333333330AB12C41CDCCCC6CAEC859410000000042B12C41000000C0A8C8594133333333F6B12C41000000609CC85941CDCCCCCC0DB32C41CDCCCC4C8EC85941CDCCCCCC47B32C41CDCCCC0C8AC859410000000082B32C41000000A083C8594100000000B1B32C413333337375C8594133333333D8B32C410000000074C85941000000009EB42C41000000A078C85941CDCCCCCC21B52C41CDCCCCAC84C85941666666669DB52C416666668691C85941333333334DB62C4133333313A8C85941000000002EB72C419A999999BBC8594100000000CDB72C41CDCCCCCCC8C859416666666640B82C419A999979D0C859413333333382B82C419A9999F9D6C859419A999999D6B82C4100000080DDC85941333333330CB92C41CDCCCCACDAC859419A999999B4B92C41000000A0E6C8594133333333C5B92C41CDCCCC8CEBC85941CDCCCCCCD9B92C41000000A0E0C85941CDCCCCCCF6B92C41CDCCCC4CD9C85941CDCCCCCC01BA2C419A999939D2C8594100000000FFB92C41666666C6CAC85941666666662FBA2C41CDCCCCECBFC8594133333333BDBA2C41CDCCCC6CADC85941CDCCCCCCCBBA2C41CDCCCCCCA7C859416666666630BB2C41333333B3A1C8594166666666C1BB2C41CDCCCC4C9EC859413333333308BC2C41CDCCCC2CA1C859413333333357BC2C41CDCCCCCC9FC859419A99999963BC2C41CDCCCCEC9AC85941CDCCCCCCB1BC2C41CDCCCCCC91C8594100000000C1BC2C41CDCCCC2C89C859419A999999ADBC2C41666666C67BC859419A999999B7BC2C41666666E674C8594100000000A8BC2C41666666466FC85941CDCCCCCC8ABC2C41333333136CC859419A99999940BC2C41CDCCCCCC6BC859419A99999917BC2C416666668667C85941CDCCCCCCAFBB2C413333339365C8594133333333AABB2C410000006060C85941CDCCCCCC6EBB2C416666664658C85941CDCCCCCC42BB2C41000000004FC859419A99999924BB2C41000000C041C8594133333333ECBA2C41666666C62CC8594100000000B2BA2C419A99995914C859419A99999985BA2C41333333B303C859413333333350BA2C41000000C001C859410000000052BA2C41000000E0FDC759416666666671BA2C41333333F3FAC75941333333336EBA2C4100000040F2C75941CDCCCCCC2ABA2C4166666606EBC7594166666666FDB92C419A999979E3C7594133333333D1B92C419A999919D7C75941CDCCCCCCCFB92C41666666A6C7C75941CDCCCCCCFEB92C41CDCCCCACABC7594166666666F8B92C41000000E0A1C75941CDCCCCCC57BA2C419A9999F9ACC75941CDCCCCCC73BA2C41333333F3ACC75941333333339FBA2C41CDCCCCECB1C75941000000003EBB2C419A9999B9ACC759419A999999BEBB2C4133333333A7C759416666666645BC2C41333333D39CC759419A99999912BD2C41CDCCCCEC36C75941CDCCCCCC86BC2C41666666C616C75941333333334FBC2C41666666A600C759413333333312BC2C419A999979F0C6594166666666C0BB2C4133333313D5C65941666666665BBB2C4133333333C6C6594133333333D7B82C41333333B384C659416666666633B82C41666666C674C659419A9999991DB82C416666668665C659416666666602B82C413333333359C659419A999999A5B62C413333331366C65941000000006DB52C41333333B36BC65941CDCCCCCC26B52C41CDCCCC4C6AC65941CDCCCCCC7CB42C41333333F36BC659416666666616B42C41000000E06DC6594166666666A6B32C41CDCCCC6C5FC65941CDCCCCCC3DB32C41CDCCCC4C47C65941CDCCCCCC0BB32C413333335338C6594133333333D1B22C41CDCCCCAC2FC659419A99999992B22C41CDCCCC4C29C65941CDCCCCCC9DB22C416666666620C659419A99999989B22C41333333F317C659416666666643B22C41333333B30CC65941CDCCCCCCFEB12C41666666A6FDC55941CDCCCCCCEEB12C4133333313F8C559419A999999C3B12C41333333D3F3C5594133333333B6B12C41000000C0ECC55941CDCCCCCCB5B12C4133333353DFC55941CDCCCCCCA8B12C419A999959D6C5594100000000AFB12C41000000E0C6C55941000000009CB12C41666666E6BCC55941000000006DB12C419A999939C4C559416666666643B12C4100000080C2C559413333333308B12C4133333393B3C559419A999999CDB02C41333333D3B3C559413333333356B02C4133333313C3C55941CDCCCCCC1AB02C4133333373C9C5594100000000ECAF2C419A999999CCC559413333333392AF2C419A999919D6C55941000000006EAF2C419A999979DBC559413333333343AE2C4133333333F4C5594166666666ADAC2C41333333731EC659410000000048AC2C419A9999394CC65941CDCCCCCC93AB2C41CDCCCC0C95C65941CDCCCCCC75AA2C419A9999D9D9C659410000000001AA2C41333333F306C759419A9999992EA92C413333333324C759413333333312A82C41CDCCCC6C4DC759419A999999F4A72C413333337352C7594166666666EAA62C419A9999996CC759419A999999C3A52C41333333D380C75941CDCCCCCC5CA52C41333333B385C7594166666666E3A42C410000008090C75941000000009EA42C41333333939AC759413333333342A42C4166666666B7C75941CDCCCCCCFCA32C41CDCCCC0CD4C7594100000000B1A32C419A999999D8C7594133333333D3A32C4166666646EAC75941000000003AA32C4100000000EDC759413333333369A32C4133333373FEC75941666666668EA32C41CDCCCCAC14C85941CDCCCCCC95A32C416666668622C85941666666666BA32C419A9999592BC859419A999999AAA22C419A99995941C859419A999999F7A22C41333333F34AC859416666666676A22C41000000A057C859419A99999973A22C410000006063C85941333333332CA22C41000000E066C859419A99999933A22C41333333536AC85941CDCCCCCCFCA02C41333333F379C85941CDCCCCCC23A12C419A9999998DC859419A99999962A02C41666666C69DC859416666666658A02C41CDCCCC8CA6C859413333333319A02C41CDCCCC6CBCC859413333333340A02C4166666646CFC859419A99999972A02C41666666A6CFC859419A99999975A02C419A999919E0C85941000000004CA02C4133333333F8C85941CDCCCCCC13A02C419A9999D90FC959410000000010A02C419A9999191AC959410000000010A02C419A9999191AC95941	01010000206A080000D4E92D5AF4AE2C41666666E6E7C75941	700230000	Z	Anjeux	7002300	70023	70	27	9
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	01010000206A08000068F994EFDC312B419A99996924915941	700240000	Z	Apremont	7002400	70024	70	27	14
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	01060000206A08000001000000010300000001000000F9000000CDCCCCCCF6FE2B419A99993977B859419A99999921FF2B416666664691B8594166666666AFFF2B419A999959A5B859410000000051002C4100000000C5B859413333333387002C4166666606DAB8594100000000B6002C41CDCCCCACE4B85941333333331B012C41CDCCCC0CF6B8594100000000AA012C419A99999905B9594100000000B9012C41CDCCCCCC16B9594100000000DF012C41CDCCCC0C22B959416666666614022C41CDCCCCAC29B9594133333333AC012C413333337334B9594133333333DB002C41CDCCCC8C4DB959413333333375002C416666666657B95941333333337F002C41CDCCCC6C5DB959419A9999999E002C416666668665B959419A9999998D002C41CDCCCCAC68B95941CDCCCCCCA1002C419A99991973B959416666666684002C41000000A07AB959413333333378FF2B41666666A692B95941CDCCCCCC5AFF2B41CDCCCCEC98B95941666666665BFF2B41666666A6A1B95941CDCCCCCCF4FF2B4133333333D7B9594166666666CDFF2B4100000080DDB9594100000000ECFF2B4133333333E6B95941CDCCCCCC32002C41000000E0F3B959410000000023002C4133333393F9B959419A999999FDFF2B4166666626FFB9594100000000C0002C41CDCCCCEC13BA5941666666668E002C41000000801FBA5941CDCCCCCC47012C41000000A02BBA594166666666F1002C41000000A044BA5941CDCCCCCC1F012C413333337347BA5941666666666E012C419A99993947BA59413333333353012C413333337352BA5941CDCCCCCCAE002C419A9999398ABA594133333333E4002C41CDCCCC2C8DBA5941666666665F012C41CDCCCCEC90BA59416666666686022C41333333D39FBA59410000000017032C41CDCCCCECA2BA594166666666DF032C4166666686A8BA59419A99999946042C4100000000A8BA5941CDCCCCCCAA042C41CDCCCC4CAABA594133333333B9042C41000000809FBA59416666666647052C41CDCCCC4CA2BA59416666666657052C41333333B399BA5941CDCCCCCC5F052C41666666868BBA594100000000A6052C419A9999F981BA594100000000C2052C419A9999D97ABA5941CDCCCCCCEF052C41CDCCCCCC65BA5941000000002B062C419A99995966BA5941666666665A062C410000006046BA5941CDCCCCCCAF062C41333333B34ABA59419A99999907072C41000000602ABA5941CDCCCCCCB1062C41666666E621BA5941333333337D062C416666668618BA594166666666B8052C419A999919F1B95941000000000D062C4166666646E8B95941000000008A062C41000000E0D6B959413333333342062C4133333313CBB9594100000000C4052C41CDCCCCCCBFB959413333333382052C4133333333ADB959413333333325052C419A99999995B95941CDCCCCCC53042C41CDCCCCAC6FB95941666666665D052C41CDCCCCCC4EB9594100000000B2052C419A99997948B9594100000000DA052C41CDCCCCAC49B959416666666622062C413333335358B959416666666653062C41CDCCCCCC5EB95941CDCCCCCC84062C41666666E659B959419A999999E1072C41000000E083B959416666666648082C41CDCCCC2C95B95941CDCCCCCC98082C41CDCCCCEC87B95941666666661A082C419A99993979B9594133333333AB082C41666666A660B959419A999999BE082C41000000605AB9594166666666DC082C419A9999D957B95941CDCCCCCC4A092C419A9999F95DB95941CDCCCCCC7E092C41333333134EB959419A999999280A2C419A9999F952B95941CDCCCCCC250A2C41666666265DB9594100000000EA0A2C416666668659B9594166666666A70B2C419A9999F952B9594133333333B80C2C41CDCCCC4C40B95941CDCCCCCC2F0D2C41CDCCCC2C3BB95941333333335C0E2C41CDCCCC0C3AB95941CDCCCCCC760E2C41333333D332B9594100000000EC0F2C419A99991937B9594166666666A3102C419A9999193EB959410000000054112C416666668645B959410000000099122C41CDCCCC4C4EB959410000000089122C41CDCCCC2C3BB9594100000000DD122C41000000203CB959419A999999E2122C416666668634B95941000000003B132C410000008034B959410000000056132C41333333D352B959416666666611142C41CDCCCCCC56B95941CDCCCCCC58142C41000000A045B959419A999999A4142C41000000603FB959413333333330152C419A9999393AB95941CDCCCCCC7D152C419A9999D938B95941CDCCCCCCC2152C419A9999793DB9594100000000D3152C41000000C038B95941CDCCCCCC06162C416666668637B95941000000005E162C419A99999930B9594100000000D8162C419A99997923B95941CDCCCCCC5E172C41000000201BB959419A999999D4172C41666666860CB95941CDCCCCCC40182C41CDCCCCACF4B859410000000090182C419A999919E8B8594166666666DB182C41CDCCCC6CECB8594166666666FB182C4166666606E9B859413333333307192C4100000080E3B8594166666666091B2C4100000000F3B8594166666666631B2C41333333F3F3B85941000000008F1B2C41CDCCCC6CD9B859419A999999301C2C419A999959DEB859419A9999994E1C2C4133333353DEB85941000000004E1C2C41333333D3D6B8594100000000DF1D2C4166666626E9B8594166666666C81E2C4100000080F6B859419A999999131F2C4133333333CCB85941666666666A1F2C4100000040AAB859419A9999999D1F2C4100000000A2B85941CDCCCCCC111F2C41000000209BB85941666666661F1E2C41CDCCCC4C8EB8594100000000091E2C41CDCCCCAC73B85941CDCCCCCC0F1E2C410000006050B85941666666667A1E2C416666662655B85941666666668D1E2C41333333134DB8594100000000F21D2C419A9999F947B8594166666666A71C2C419A9999593EB8594133333333531C2C41CDCCCC0C3FB8594133333333D31B2C419A99995942B859419A999999761B2C41000000803CB85941666666664F1B2C41000000403DB859419A999999B81A2C41333333533BB85941CDCCCCCC6F1A2C41CDCCCC8C37B8594166666666181A2C413333331322B85941CDCCCCCCE2192C419A99999909B8594100000000511A2C41CDCCCC4CEBB75941CDCCCCCC751A2C41000000E0DAB7594166666666961A2C41000000E0D8B7594166666666ED1A2C41CDCCCC6CC6B7594133333333DF1A2C41666666A6C3B75941CDCCCCCC0E1B2C41000000E0BCB7594166666666981B2C41CDCCCC2C9FB7594133333333FC1B2C419A9999598FB759419A999999001D2C419A9999195AB759419A999999431D2C41CDCCCC6C57B75941CDCCCCCCE51D2C419A9999B941B7594100000000771E2C41000000802AB759419A999999BD1E2C416666668621B75941CDCCCCCC251F2C413333337317B759419A999999BF1F2C41CDCCCCACFFB659416666666661202C419A9999B9E3B659419A999999E5202C41000000E0C9B659416666666610222C410000004098B659416666666699222C41CDCCCCCC86B65941CDCCCCCCC2222C41000000407CB65941CDCCCCCCCF232C41000000C041B659419A9999991A242C416666664638B65941CDCCCCCC4A242C419A99997921B6594100000000E7242C41CDCCCC6CEAB55941333333330B252C419A9999B9D1B559410000000039252C41666666E6CBB5594100000000FD252C4100000000BDB559410000000087262C41CDCCCC8CB5B559419A99999957272C4133333393A5B5594133333333FA272C416666664698B5594133333333BE282C41333333B385B55941CDCCCCCCA8292C41666666A67EB5594166666666542A2C41666666C67AB55941CDCCCCCC242A2C41CDCCCCEC66B5594166666666132A2C41CDCCCCEC5BB5594166666666BA292C41CDCCCCCC4CB55941000000005D292C41000000C03EB559416666666632292C41CDCCCC4C34B559419A99999905292C41666666A621B55941333333334D282C419A9999391FB55941333333338B272C413333331315B5594166666666C3252C41333333B312B559419A999999E1242C419A99991918B55941333333337F232C41000000401EB559410000000003232C41666666661EB559416666666613222C41CDCCCCCC1FB55941CDCCCCCC42202C41333333F32CB55941CDCCCCCC571F2C41333333532AB55941CDCCCCCCBF1E2C419A9999792AB5594100000000361E2C41333333D32FB55941CDCCCCCCA61C2C416666666644B5594133333333DC1B2C419A99997947B5594133333333951A2C410000000049B5594133333333621A2C41CDCCCC2C46B559413333333335192C41CDCCCC4C2EB559413333333320182C419A99993924B55941333333339F172C413333331322B55941333333330B172C41666666C61AB55941666666662D162C41000000A010B559419A999999D5152C419A9999190CB55941333333335D152C41000000E001B559419A999999AF142C419A999939FCB45941CDCCCCCC81132C4166666666F6B45941CDCCCCCC48132C419A999939F8B4594133333333E00F2C41666666661DB55941CDCCCCCCC00F2C419A99993921B559419A999999E30E2C41000000E033B5594133333333F40C2C419A99995955B55941CDCCCCCC680B2C419A9999796CB55941CDCCCCCC980A2C419A9999B97DB55941CDCCCCCC09092C419A999979ACB5594166666666A6082C4133333393B6B55941666666663A072C4133333333C9B559419A99999953062C41666666E6FBB5594133333333F6052C413333331317B659419A9999992B052C41CDCCCC8C3EB65941CDCCCCCC1B042C413333331382B659419A999999E1032C41666666E68FB659419A99999921042C419A99993998B6594166666666BD032C4100000060ACB659419A9999994A032C41333333B3CCB659416666666691022C41666666C6F1B65941CDCCCCCC38022C419A99991907B75941CDCCCCCCF3012C41CDCCCCEC14B759419A99999991012C41000000C02CB759419A9999994C012C41333333933AB759410000000012012C41000000E04FB759413333333393002C419A9999797AB759419A99999978002C41CDCCCC8C8FB75941CDCCCCCCAD002C41CDCCCC4C9EB7594133333333DC002C419A999959A7B759419A99999923012C4166666686BCB75941333333332E012C4100000080C6B75941CDCCCCCC20012C419A999919D9B759419A999999E6002C419A9999D9D6B759410000000079002C419A999979F5B759419A99999954002C419A99995902B85941333333332F002C416666662613B859410000000018002C419A9999B916B859416666666618002C41000000601EB859419A999999EEFF2B41666666E627B85941CDCCCCCCBFFF2B41666666A62FB859410000000096FF2B41CDCCCCAC3CB859413333333376FF2B41000000A051B85941666666664AFF2B41CDCCCC6C62B85941333333332FFF2B419A99995969B859419A999999FBFE2B41000000A070B85941CDCCCCCCF6FE2B419A99993977B85941CDCCCCCCF6FE2B419A99993977B85941	01010000206A08000076036E67F70D2C41CDCCCCACCEB75941	700250000	Z	Arbecey	7002500	70025	70	27	17
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	01010000206A0800003ADC8999514F2B419A999979C1985941	700260000	Z	Arc-lès-Gray	7002600	70026	70	27	12
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	01010000206A080000978F721F585F2B41CDCCCC9C9EAE5941	700270000	Z	Argillières	7002700	70027	70	27	10
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	01010000206A080000CD252C810D412C41666666166FAA5941	700280000	Z	Aroz	7002800	70028	70	27	7
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	01060000206A08000001000000010300000001000000C40000009A9999992C1F2D41333333F3FAAB594100000000B21F2D41CDCCCCCC28AC594166666666EA1F2D41333333333AAC59419A99999907202D419A99993945AC59413333333344202D416666664664AC5941666666666F202D41333333F377AC59419A99999976202D41000000C07DAC59419A9999996C202D419A99997994AC5941CDCCCCCC68202D41CDCCCCCCB7AC59413333333373202D4133333353D6AC5941666666662F212D41000000C0D8AC59410000000043212D41CDCCCCECE2AC59413333333378212D41CDCCCC6CEAAC59419A9999997D212D41CDCCCC4CEEAC5941000000009E212D41333333B321AD5941CDCCCCCC1B212D41666666C627AD59419A99999930212D419A9999B931AD5941CDCCCCCC5C212D41CDCCCC0C33AD5941CDCCCCCCF8212D419A99991963AD5941333333337E222D419A9999998FAD59410000000008232D41666666A680AD59419A999999EB232D41CDCCCC8CA6AD5941333333338C242D4133333373C5AD59419A999999B4242D4166666626CEAD59419A999999CD242D4133333313D0AD59413333333352252D4133333353C4AD59419A999999FC262D419A9999390DAE59416666666624272D41CDCCCCAC0AAE59410000000057272D410000006013AE5941CDCCCCCCA6272D41CDCCCCCC10AE5941CDCCCCCCD6282D41CDCCCCEC4EAE5941333333330A292D419A9999D962AE59416666666620292D41CDCCCC0C82AE5941666666667C292D41CDCCCC6CA2AE59419A999999002A2D41000000C0C2AE594166666666AC2A2D41CDCCCC4CDFAE59419A999999C02A2D4166666686E0AE5941666666661A2B2D41CDCCCC2CDFAE594100000000CC2D2D41333333B3DFAE59419A9999990B2F2D419A999919DEAE59419A9999996F2F2D4100000040DFAE59419A999999672F2D41666666E6BFAE59419A999999A02F2D4133333373AFAE5941666666669D2F2D419A9999F9A1AE59419A999999482F2D41CDCCCC4C89AE594166666666052F2D413333331362AE594166666666F72E2D416666666651AE594100000000762F2D41333333134CAE59419A999999CC2F2D41666666E63DAE59419A99999934302D41333333531EAE59419A999999A22F2D416666668619AE59416666666636302D41000000E0E0AD5941000000009E302D419A999919E5AD59419A999999D1302D41CDCCCC2CD3AD5941333333331F312D4166666666BBAD59419A9999999C312D4100000060C2AD594133333333D1312D41333333F3ADAD5941000000002E322D4100000020A2AD59413333333361322D419A99995995AD5941CDCCCCCC19332D419A9999F990AD594133333333B4332D41666666A695AD59413333333329342D41666666C697AD5941000000009E342D41CDCCCC8C96AD59419A999999B1342D41666666C692AD59419A99999983352D41CDCCCCCC93AD5941CDCCCCCC19362D41000000E099AD5941000000004B362D41000000A09DAD5941333333337C362D41333333337BAD5941CDCCCCCC3B362D41000000C07AAD5941666666662F362D41CDCCCCEC5FAD5941CDCCCCCC90372D416666660658AD594166666666A6372D41000000E080AD5941666666664B382D419A99997988AD5941000000006D382D41CDCCCC2C8EAD5941333333330F392D41CDCCCC2C92AD59413333333318392D41CDCCCC2C79AD59419A999999773A2D41000000E042AD5941CDCCCCCCD43C2D413333339345AD594100000000123D2D413333335346AD594133333333143D2D41CDCCCC4C3DAD59419A999999353D2D41333333F33DAD5941000000005E3D2D419A9999D92BAD5941CDCCCCCC323D2D41CDCCCC0C16AD594166666666023D2D41333333B303AD59419A999999CF3C2D4166666666F9AC594100000000603C2D41CDCCCCCCEFAC594166666666473C2D4166666666F6AC5941666666663F3B2D41666666E6F3AC594100000000273B2D4166666606D4AC594166666666F13B2D41666666A6D6AC5941000000004B3D2D41CDCCCCACD4AC59419A999999B53D2D41CDCCCC4CC9AC5941CDCCCCCC1C3E2D4133333393B9AC594166666666503E2D4100000000AEAC59419A999999343E2D41333333339CAC5941CDCCCCCC0D3E2D419A9999798BAC59419A999999CD3D2D41666666E679AC59419A999999ED3C2D41666666A646AC5941CDCCCCCC963C2D416666668630AC5941CDCCCCCC5D3C2D419A9999B920AC5941000000002F3C2D419A9999590EAC594100000000D93B2D419A9999F9E9AB594166666666A93B2D419A9999D9DBAB5941CDCCCCCC803B2D4166666606D2AB594133333333D83A2D4166666626A3AB5941CDCCCCCC353B2D41CDCCCCECA1AB59419A999999F43A2D41CDCCCCAC8AAB5941CDCCCCCC983A2D41CDCCCC4C6FAB594133333333983A2D41CDCCCC0C69AB594100000000F23A2D413333333365AB5941000000005A3C2D41CDCCCC0C52AB5941666666667C3C2D41333333F34BAB59419A999999B33C2D41CDCCCC8C47AB594100000000973C2D41333333933AAB5941CDCCCCCC573C2D41333333B333AB59419A9999993A3C2D41CDCCCC2C1DAB5941666666661E3C2D416666666615AB594100000000DF3B2D41CDCCCC2C0AAB594133333333AE3B2D41CDCCCCEC05AB5941CDCCCCCCCC3B2D41666666A6FBAA594166666666C43B2D419A9999F9F0AA5941CDCCCCCC953B2D41666666A6E1AA5941CDCCCCCC4B3B2D419A999979D4AA5941CDCCCCCC4D3B2D41666666E6C9AA5941CDCCCCCC373B2D419A9999D9C6AA594133333333343B2D4133333313BEAA59419A999999103B2D41CDCCCC6CB1AA594166666666003B2D419A999979A8AA594166666666E23A2D419A9999F99FAA59419A999999B23A2D41666666A696AA594166666666B63A2D41333333B389AA594166666666C23A2D41CDCCCCEC82AA5941CDCCCCCCE53A2D419A9999D97EAA594166666666D83A2D41333333D371AA594166666666F13A2D41000000C06BAA594100000000EB3A2D41333333B362AA5941CDCCCCCC683A2D41666666C66CAA594166666666E7392D41CDCCCC2C73AA5941000000006E392D413333337375AA594133333333D5382D41CDCCCCCC72AA59410000000084382D410000008068AA59419A999999E8372D410000004058AA5941333333335F372D419A9999D966AA5941CDCCCCCC31372D419A9999B96DAA594166666666DE352D416666660664AA59410000000029352D410000002059AA5941000000003B342D416666668641AA5941CDCCCCCCF9322D41000000602BAA59419A9999994F322D413333339326AA5941CDCCCCCC83302D413333339324AA594100000000E42F2D419A99993927AA594133333333032F2D41CDCCCCEC31AA594100000000DF2D2D41333333D33CAA594100000000B42D2D41333333733DAA5941333333335D2D2D41666666E64FAA5941CDCCCCCC532C2D41333333D39BAA594100000000F92B2D410000004082AA594100000000692B2D416666664687AA594100000000C32A2D419A9999D97EAA59419A9999992C2A2D416666662695AA5941CDCCCCCC7B292D41CDCCCC6CA3AA5941CDCCCCCC38292D41333333F3B3AA594100000000FE272D4100000060CFAA59413333333347272D41666666A6D1AA59419A99999935272D4133333393C6AA594100000000E0262D4100000080CBAA594133333333EC262D4133333353DCAA594133333333E2262D419A999999DDAA5941CDCCCCCC8F252D41333333B3F0AA594100000000B6242D419A9999B9FBAA59413333333360242D4100000040FEAA59419A99999938242D41333333F3F5AA594166666666A8232D41333333D3F6AA594100000000A6232D41CDCCCC6CFDAA5941000000006A232D41000000A009AB594100000000D8222D41CDCCCC2C1CAB59419A999999F2212D41666666262BAB594166666666FD212D41000000E038AB5941000000007A222D41333333337CAB594100000000D4222D419A9999197CAB5941CDCCCCCCD3222D410000002098AB5941CDCCCCCCB8212D419A9999199EAB59413333333395222D419A9999D9E3AB594100000000B4222D41CDCCCC4CF0AB5941333333335E222D419A9999D9EBAB5941000000002D222D4133333353F6AB5941CDCCCCCCF5212D4166666646FCAB59419A9999998C212D419A9999B9FCAB59419A99999938212D4166666626F4AB59419A9999990B212D41333333D3EAAB59416666666698202D419A999939D8AB59413333333320202D4166666686CBAB594166666666A81F2D41333333B3C4AB5941666666663B1F2D419A999939CDAB59419A9999992C1F2D41333333F3FAAB59419A9999992C1F2D41333333F3FAAB5941	01010000206A0800002A0B031B312F2D41343333D382AC5941	700290000	Z	Arpenans	7002900	70029	70	27	12
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	01060000206A0800000100000001030000000100000074000000CDCCCCCC79622B41666666863B8F594166666666CF622B419A9999593D8F5941CDCCCCCC02632B41666666C63E8F59413333333330652B41CDCCCCAC2D8F5941000000006C672B41333333B3128F5941CDCCCCCC03682B41CDCCCCCC0A8F5941000000007B682B419A999919088F5941666666667A692B41CDCCCC0C108F5941CDCCCCCCA8692B41CDCCCC8C0B8F594166666666F2692B41000000C0078F594100000000586B2B41333333D3118F594133333333CF6B2B41000000C00D8F5941666666660F6C2B41333333F3F78E594133333333EF6C2B41000000C0198F5941333333333E6D2B419A9999D9328F5941CDCCCCCC3C6D2B419A999959398F59419A9999993B6D2B41666666C63F8F5941CDCCCCCC3D6D2B419A9999F9428F594166666666236D2B41666666C65F8F5941CDCCCCCC4B6D2B41CDCCCC2C6E8F59419A9999996C6D2B419A9999D97A8F594100000000516D2B41000000E07D8F594100000000126D2B419A9999B9858F59419A999999766D2B419A9999F9968F594100000000AE6D2B41CDCCCC6C928F5941CDCCCCCCB56D2B419A999919858F59419A999999EE6D2B41CDCCCC4C858F5941333333333D6E2B41333333B3848F594166666666936E2B419A999959838F594100000000D26E2B41CDCCCC8C828F5941333333331D6F2B419A999939818F5941666666665E6F2B41666666E6808F594100000000866F2B41666666C6818F59419A999999A16F2B41CDCCCCAC828F5941CDCCCCCCD76F2B41CDCCCC4C838F59419A99999908712B41CDCCCC6C838F59410000000037712B4166666646858F5941333333335C712B419A9999B9868F59419A9999996B712B4166666686878F5941CDCCCCCCA2712B41CDCCCC6C638F594133333333D3712B419A9999B9618F594166666666EB712B4166666606608F594100000000FE712B41666666865F8F5941333333333F722B41CDCCCC4C598F5941333333338C722B419A999959518F594100000000B0722B41CDCCCC6C4D8F5941000000003E732B41000000403D8F5941666666668B732B4100000060378F59419A999999AE732B41CDCCCCCC318F594133333333B3732B41000000602B8F5941333333337D732B41000000E0228F5941000000007B732B41CDCCCC8C1B8F59416666666612742B419A999939E88E59419A999999DF732B4166666646DE8E5941CDCCCCCCA5742B4133333353C68E5941CDCCCCCCB9742B4133333313C58E5941CDCCCCCCA9742B419A9999B9C18E59416666666687742B4100000060BD8E59419A999999FD742B4100000020B08E59419A99999947742B419A9999B9868E59419A99999953732B41333333D3518E59419A99999916732B41CDCCCC2C578E594133333333F6722B41000000205A8E594133333333E0722B41333333735C8E59419A999999D0722B41CDCCCC4C5D8E59419A999999AE722B419A9999B95E8E5941CDCCCCCC83722B4133333393618E5941333333335B722B419A9999B9638E59416666666639722B41333333B3648E5941000000002A722B4133333353658E59410000000020722B4133333393658E59413333333314722B41000000C0668E5941333333330C722B4100000080678E59419A999999EA712B41CDCCCCAC698E594166666666C6712B41666666066C8E594133333333AC712B41333333936D8E59413333333302712B419A9999196E8E5941666666665E6F2B41CDCCCC2C108E5941333333334A6F2B41333333F30E8E594100000000BF6E2B419A9999D9178E5941CDCCCCCC336E2B419A999939238E594100000000F86D2B41CDCCCC8C248E5941CDCCCCCCE36D2B4133333313228E594133333333EF6C2B4100000020DB8D5941CDCCCCCCC66C2B41CDCCCCECD48D5941CDCCCCCC9E6C2B419A9999F9D48D5941333333339A6B2B4166666606CA8D59419A999999036B2B41CDCCCCACBD8D59419A999999186A2B41333333D39D8D5941CDCCCCCCFF682B419A9999D9A98D59416666666603672B41CDCCCCECD48D5941CDCCCCCCB4662B419A9999D9F38D59419A99999972662B41CDCCCCEC168E59419A99999954662B41666666C6218E59410000000009662B41666666662B8E5941CDCCCCCCC6652B4133333313508E594133333333CB652B419A9999B9768E59413333333360652B4133333313A08E5941CDCCCCCC55652B4100000000AE8E5941000000002A652B4166666686B58E59410000000090642B4100000000C88E5941CDCCCCCC5B642B41CDCCCCACCE8E59416666666623642B41333333B3D28E594133333333E4632B419A9999D9D58E5941CDCCCCCCAD632B4166666606D98E5941333333337E632B41333333D3DC8E59419A99999936632B4133333393E68E59419A999999F4622B4100000040F38E594133333333C9622B419A9999D9FD8E5941CDCCCCCCB2622B419A9999D9038F5941CDCCCCCCA6622B41000000200B8F594166666666A0622B419A9999D9128F59416666666696622B41CDCCCCEC1B8F59419A9999998A622B41CDCCCC4C248F59419A99999980622B419A9999592D8F5941CDCCCCCC79622B41666666863B8F5941	01010000206A080000FA6AEB28006D2B4166666666938E5941	700300000	Z	Arsans	7003000	70030	70	27	2
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	01010000206A080000DABF9C45746B2D410000000080A95941	700310000	Z	Athesans-Étroitefontaine	7003100	70031	70	27	13
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	01010000206A0800006C49149359E62A4100000060219B5941	700320000	Z	Attricourt	7003200	70032	70	27	6
01060000206A08000001000000010300000001000000490100003333333377E82B41CDCCCC4C02BB5941CDCCCCCC15E92B41CDCCCC4C21BB5941CDCCCCCC8EE92B41CDCCCCAC3BBB59419A99999903EA2B419A9999B953BB59413333333347EA2B41CDCCCC0C5CBB59419A99999949EB2B41333333F373BB59419A99999912ED2B41666666A69FBB5941CDCCCCCC91ED2B41000000A0ABBB5941CDCCCCCCBEED2B41666666E6ADBB5941666666663DEE2B419A999999AFBB5941CDCCCCCCCEEE2B419A9999B9B2BB594166666666B5EF2B41CDCCCCECB2BB59416666666673F02B4166666686B5BB594133333333F6F02B419A999959BCBB59419A99999971F12B41CDCCCCECC6BB59413333333330F22B41000000E0D1BB594166666666C9F22B4166666606DBBB59416666666666F32B4166666606E6BB5941CDCCCCCCA9F32B4133333373ECBB59410000000079F42B41333333930FBC5941CDCCCCCC7BF42B41CDCCCC8C15BC5941333333337CF42B410000008016BC59413333333386F42B41666666062BBC5941CDCCCCCC80F42B41CDCCCCAC4ABC5941CDCCCCCC9BF42B413333333357BC59419A999999C1F42B41CDCCCC0C5FBC59410000000023F52B419A9999B968BC594166666666A9F52B416666660670BC59413333333337F62B419A99997975BC5941CDCCCCCCE6F62B41CDCCCC0C7FBC5941CDCCCCCCBFF72B41333333F390BC594100000000F8F72B410000000096BC594133333333D4F82B419A9999399DBC5941CDCCCCCC52F92B41CDCCCCEC9EBC5941CDCCCCCCF6F92B4166666646A5BC59413333333363FA2B4133333333ABBC59413333333347FB2B419A9999F9B7BC59419A999999A4FC2B4166666626D3BC594100000000CCFC2B4166666686CFBC5941333333330DFD2B4133333353D1BC5941CDCCCCCC82FD2B4166666646D3BC5941CDCCCCCC8BFD2B4133333353CFBC5941CDCCCCCC02FE2B41333333B3C2BC59419A99999931FE2B41666666E6BEBC594133333333E8FE2B41CDCCCCCCC0BC594100000000CEFF2B419A999939BDBC5941CDCCCCCCAEFF2B419A999959B6BC59419A9999998A002C41CDCCCC0CAFBC59419A999999F8002C41CDCCCC6CABBC59410000000012012C4133333333AABC59410000000017022C41333333139EBC594166666666EA022C41666666A690BC5941000000001C032C419A9999598ABC5941CDCCCCCCE4032C410000002099BC5941000000002B042C41CDCCCCCC9CBC59419A99999984042C41333333F398BC594166666666C0042C41666666E693BC59413333333310052C41CDCCCC8C92BC5941000000003E052C419A99995993BC5941CDCCCCCC7B052C41333333F387BC59419A9999998C052C41333333F384BC59419A99999985052C41CDCCCC6C81BC59410000000080052C41000000E07CBC59410000000080052C41333333F379BC59419A99999983052C41CDCCCCAC77BC59419A99999992052C41CDCCCCCC74BC59419A999999A8052C416666664674BC594166666666BE052C416666666674BC594100000000DB052C41CDCCCC0C75BC59419A999999E8052C413333335374BC5941CDCCCCCCEE052C419A9999F972BC59419A999999EC052C413333339371BC594166666666E5052C416666660670BC5941CDCCCCCCE1052C41000000206FBC594100000000E3052C41666666866DBC594166666666EB052C41CDCCCCAC6BBC59419A999999F8052C41666666E669BC5941CDCCCCCC06062C419A9999D968BC59416666666613062C416666664667BC5941CDCCCCCC17062C416666662665BC5941000000001F062C419A9999F964BC59410000000030062C416666666665BC59416666666646062C41333333D365BC5941666666664B062C41666666C665BC5941CDCCCCCC4E062C419A99993964BC59419A99999952062C419A9999D962BC59413333333354062C419A99993961BC5941000000005B062C41666666E65FBC59413333333368062C41CDCCCCCC5FBC59416666666684062C419A9999F960BC59419A9999999B062C416666662661BC594100000000A6062C413333335361BC5941CDCCCCCCB5062C419A9999595FBC5941CDCCCCCCC9062C41333333735EBC5941CDCCCCCCDD062C41666666665DBC59419A999999FB062C419A9999395ABC5941666666660A072C413333333356BC5941666666661B072C41333333B353BC5941333333335A072C41333333933DBC594100000000A1072C41000000003ABC5941CDCCCCCCC4072C41000000C032BC5941CDCCCCCCA1072C41CDCCCC6C2FBC5941CDCCCCCC8E072C419A9999792DBC59413333333369072C419A99999929BC59419A99999933072C419A99991924BC5941CDCCCCCCB3062C410000000017BC5941CDCCCCCC3B062C41000000400BBC594100000000F7052C410000008000BC5941CDCCCCCCD2052C419A9999D9FABB5941CDCCCCCCB8052C41333333D3E7BB594100000000B7052C4166666606E6BB594100000000B3052C4133333393DBBB594133333333B5052C4133333313D1BB59419A999999B5052C41CDCCCCACCEBB594166666666BA052C41000000E0C9BB594100000000BE052C41333333D3C7BB594166666666BE052C41666666E6C5BB5941CDCCCCCCB6052C4100000040C4BB5941CDCCCCCCAA052C41CDCCCCCCC2BB59410000000099052C41000000A0C1BB59413333333380052C41CDCCCC8CC0BB59413333333372052C4133333313BFBB59419A99999966052C419A9999D9BCBB5941CDCCCCCC60052C41CDCCCC6CB9BB59419A9999995D052C41333333F3B6BB5941000000006B052C419A999919B4BB5941000000006F052C4100000060B2BB5941000000006B052C41CDCCCC8CB0BB59419A9999995D052C41333333F3ADBB5941000000005C052C41000000C0ABBB59419A99999961052C4133333333AABB59419A9999996C052C4100000000A9BB59416666666678052C41CDCCCC0CA7BB5941CDCCCCCC7D052C41333333B3A5BB59419A9999997D052C4100000020A4BB5941000000007C052C4100000040A2BB5941333333337D052C41000000409FBB5941333333337E052C41666666C69CBB59419A99999984052C419A9999F99ABB59419A9999998E052C416666662699BB59419A99999999052C41CDCCCCCC95BB594100000000A8052C41CDCCCCAC94BB594100000000BC052C41CDCCCCCC93BB5941CDCCCCCCC2052C41CDCCCC0C92BB5941CDCCCCCCC1052C419A9999F98FBB5941CDCCCCCCBB052C41333333338EBB5941CDCCCCCCB4052C41333333138CBB594100000000AC052C419A9999F98ABB59410000000094052C41333333B38ABB5941CDCCCCCC78052C41CDCCCC0C8ABB59413333333370052C419A9999F988BB59416666666671052C41CDCCCCCC87BB5941000000007A052C410000004086BB5941666666668B052C41000000A085BB59419A99999991052C419A99991985BB5941CDCCCCCC93052C410000004083BB5941CDCCCCCC93052C416666664681BB59419A99999996052C419A9999F980BB594166666666C8052C419A9999197CBB5941CDCCCCCCD8052C41666666867ABB5941CDCCCCCCCE052C413333335379BB594166666666BA052C41333333D376BB5941666666668A052C413333335375BB59410000000034042C41000000C06ABB5941333333333D042C41000000C060BB5941CDCCCCCC60032C410000004058BB59419A99999956032C41000000C055BB59416666666674032C419A9999F951BB5941000000007E032C419A9999394EBB594166666666BE022C41333333F332BB59410000000014022C41000000E02CBB59419A999999E1012C413333337325BB594166666666D6012C419A9999F913BB594133333333B7012C41000000C003BB594166666666CA012C4100000040F7BA59410000000006022C41CDCCCC6CE4BA59410000000036022C4166666666D5BA59413333333349022C4166666666CBBA594100000000F9012C419A9999B9C7BA594166666666FE002C4100000040BABA59416666666642012C41333333B39EBA5941666666665F012C41CDCCCCEC90BA594133333333E4002C41CDCCCC2C8DBA5941CDCCCCCCAE002C419A9999398ABA5941CDCCCCCCC7002C41333333B381BA59413333333353012C413333337352BA59419A9999995D012C41CDCCCC0C4EBA5941666666666E012C419A99993947BA5941CDCCCCCC1F012C413333337347BA594166666666F1002C41000000A044BA5941CDCCCCCC47012C41000000A02BBA5941CDCCCCCC16012C41CDCCCC6C28BA5941666666668E002C41000000801FBA594100000000C0002C41CDCCCCEC13BA59419A999999FDFF2B4166666626FFB959410000000023002C4133333393F9B95941CDCCCCCC32002C41000000E0F3B9594100000000ECFF2B4133333333E6B9594166666666CDFF2B4100000080DDB9594133333333EBFF2B419A9999F9DAB95941CDCCCCCCF4FF2B4133333333D7B95941666666665BFF2B41666666A6A1B95941CDCCCCCC5AFF2B41CDCCCCEC98B959413333333378FF2B41666666A692B959416666666684002C41000000A07AB95941CDCCCCCCA1002C419A99991973B959419A9999998D002C41CDCCCCAC68B959419A9999999E002C416666668665B95941333333337F002C41CDCCCC6C5DB959413333333375002C416666666657B9594133333333DB002C41CDCCCC8C4DB9594133333333AC012C413333337334B95941CDCCCCCC82012C41666666E62CB959419A999999CF002C41333333D320B959419A99999903002C41CDCCCCEC17B9594133333333C4FF2B41333333F318B959413333333365FF2B41000000800FB95941CDCCCCCC87FE2B4100000000F8B8594166666666F6FD2B419A999919EFB859419A999999D5FD2B419A999979EFB8594166666666B5FD2B419A999999FCB8594100000000A0FD2B413333339305B959413333333371FD2B41CDCCCC8C08B95941CDCCCCCC0DFD2B41CDCCCC6C28B9594133333333F3FC2B416666662642B9594166666666E4FC2B419A9999F94DB9594133333333A9FC2B410000004053B959419A999999A0FC2B413333333353B959419A99999997FC2B410000002053B95941CDCCCCCC8DFC2B410000008053B95941CDCCCCCC79FC2B41CDCCCCAC54B959410000000066FC2B41CDCCCC2C56B95941CDCCCCCC47FC2B419A99995957B959419A99999925FC2B41CDCCCCAC58B959416666666605FC2B41000000E059B9594166666666EBFB2B41CDCCCCCC5AB959419A999999D5FB2B41000000805BB9594100000000C2FB2B41666666065CB9594100000000B0FB2B41000000005DB95941CDCCCCCC99FB2B41666666E65DB959410000000087FB2B41000000805EB959419A99999975FB2B41666666065FB959410000000069FB2B419A9999395FB95941000000005DFB2B419A9999595FB95941CDCCCCCC51FB2B41CDCCCC0C5FB95941CDCCCCCC44FB2B41666666865EB959416666666639FB2B41333333D35DB95941333333332CFB2B419A9999D95CB95941666666661FFB2B41CDCCCC6C5BB959419A9999990CFB2B419A9999B959B9594133333333F8FA2B416666662658B9594166666666EAFA2B419A99995957B9594133333333E0FA2B416666660657B9594166666666D5FA2B41333333F356B959419A99999996FA2B41666666C651B95941333333332EFA2B416666662649B959419A999999C1F92B41000000405DB9594133333333A8F82B413333339344B959410000000080F82B410000002042B959410000000099F72B410000002032B959419A99999966F72B41666666462CB959419A999999D9F62B419A9999D91BB959410000000012F62B41333333D30CB959410000000091F52B41333333332BB959410000000069F52B419A9999392BB95941CDCCCCCC8FF42B419A99993917B95941CDCCCCCC12F42B410000006007B9594100000000D8F32B416666666611B95941CDCCCCCC60F32B41CDCCCC0C23B95941CDCCCCCC11F32B410000002035B959416666666626F32B41CDCCCC0C38B959416666666636F32B41CDCCCC6C3AB95941333333334FF32B41CDCCCC4C3FB95941CDCCCCCC65F32B419A99993945B959413333333381F32B419A9999D94AB95941333333339BF32B410000008050B9594166666666B4F32B41666666E655B95941CDCCCCCCCBF32B41CDCCCCCC59B9594166666666E1F32B419A9999D95CB9594166666666FCF32B41666666E65FB959410000000017F42B41CDCCCC0C63B959413333333333F42B41000000E065B95941CDCCCCCC4DF42B416666662668B959416666666669F42B41666666066AB959416666666695F42B41666666466DB95941CDCCCCCCB5F42B41000000606FB959413333333394F42B419A99997979B959419A99999974F42B410000002083B959413333333309F42B413333333382B959419A99999960F32B41CDCCCC6C78B95941CDCCCCCCBBF22B41CDCCCC6C6AB959419A99999955F22B41333333535EB95941666666661BF22B419A9999D961B959419A999999D8F12B41CDCCCCAC68B95941666666665FF12B419A9999B966B959419A9999995EF12B41CDCCCC8C73B959416666666648F12B416666664682B959419A999999E7F02B41CDCCCC2C80B9594133333333FEEF2B413333331372B95941CDCCCCCC67EF2B41CDCCCCEC67B959419A999999ECEE2B410000008081B959419A999999EAEE2B416666666683B959419A999999E6EE2B416666668687B95941666666666AEE2B4133333353A1B959419A999999A5ED2B4100000040CDB95941333333335AED2B41666666E6DBB9594133333333B2ED2B41CDCCCCCCE2B959410000000081EC2B410000008036BA5941CDCCCCCC0AEC2B419A9999994FBA594100000000DFEB2B41666666465ABA5941CDCCCCCC0BEC2B419A9999595DBA5941333333332EEC2B41333333B365BA59410000000035EC2B41CDCCCCCC6EBA5941666666664EEC2B410000000076BA5941CDCCCCCC74EC2B41000000E07BBA59419A999999F3EB2B41666666E691BA594133333333CEEB2B41000000209ABA594133333333C5EB2B419A9999799EBA594133333333A2EB2B41000000809DBA59410000000082EB2B41666666469CBA59410000000066EB2B41000000209BBA59419A99999934EB2B41CDCCCC8C98BA59419A99999923EB2B419A9999D99DBA5941CDCCCCCCF5EA2B4133333313A8BA59410000000034EA2B4166666686CFBA59410000000021EA2B4166666606D3BA59419A999999EDE92B41666666A6CFBA5941CDCCCCCCD4E92B4133333333D2BA59413333333377E82B41CDCCCC4C02BB5941	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	01010000206A080000ED914178D2F52B419A9999E9DCBA5941	700350000	Z	Augicourt	7003500	70035	70	27	9
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	01010000206A080000123F11206D7E2C41666666B6AE905941	700360000	Z	Aulx-lès-Cromary	7003600	70036	70	27	4
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	01010000206A0800000EF57352448D2B41666666C6F0A15941	700370000	Z	Autet	7003700	70037	70	27	11
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	01010000206A08000058B9CB20EA952C419A9999A9289D5941	700380000	Z	Authoison	7003800	70038	70	27	16
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	01010000206A080000C17EC7AEA9E02B4166666606628F5941	700390000	Z	Autoreille	7003900	70039	70	27	10
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	01010000206A080000F290033AE6072D41666666E61EAB5941	700400000	Z	Autrey-lès-Cerre	7004000	70040	70	27	6
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	01010000206A080000639C8E45C0F62A419A9999C9D5975941	700410000	Z	Autrey-lès-Gray	7004100	70041	70	27	32
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	01010000206A080000F817D8FC1F282D410000009028A35941	700420000	Z	Autrey-le-Vay	7004200	70042	70	27	3
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	01010000206A080000AE7D04171A2D2B419A9999897E9D5941	700430000	Z	Auvet-et-la-Chapelotte	7004300	70043	70	27	14
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	01010000206A080000B2A90B748E932C419A999909C2B35941	700440000	Z	Auxon	7004400	70044	70	27	13
01060000206A080000010000000103000000010000005601000033333333A6A92B41666666C66E8B59419A999999E3A92B41666666E6838B5941CDCCCCCCDDA92B41000000A0888B59419A999999DFA92B419A9999398C8B59410000000095AA2B4133333373CA8B594100000000D2AA2B419A9999F9DE8B59410000000010AB2B419A999919018C59419A99999930AB2B41000000A0128C5941000000001EAB2B419A9999194A8C59419A9999991DAB2B41333333934B8C59413333333314AB2B41000000E0598C594133333333F3AA2B41666666066B8C59419A999999EDAA2B4133333333738C594166666666FBAA2B41CDCCCCCC878C59413333333302AB2B41666666E6918C59410000000026AB2B41CDCCCCECA48C594166666666FCAB2B419A999999B48C5941000000001FAC2B4100000060BA8C59419A9999995BAE2B41000000E0178D59413333333360AF2B419A9999F94C8D59419A99999961AF2B41000000404D8D59416666666615B02B419A9999B9748D5941CDCCCCCC96B02B41CDCCCCCC8F8D5941000000000CB12B4133333313AC8D59419A99999958B12B419A9999F9C78D5941CDCCCCCCFDB12B419A999959FA8D5941CDCCCCCCF5B12B41666666E6FD8D594133333333EFB12B41000000E0008E594133333333FDB12B41666666C6058E59419A99999926B22B419A9999F90C8E594166666666D1B32B41333333F34E8E5941CDCCCCCC8EB42B4100000060688E594166666666A1B42B41666666C66B8E59410000000063B52B419A9999398B8E594100000000E3B52B419A9999797F8E59419A999999ABB62B419A999919718E5941CDCCCCCCDEB72B41CDCCCCEC4F8E5941333333334FB82B4100000020408E594133333333FDB82B41666666A61D8E59419A99999997B92B41CDCCCCCC0C8E5941CDCCCCCC6BBA2B4100000020F88D594100000000E8BA2B419A999999F68D5941000000007EBB2B4100000060EF8D5941CDCCCCCC29BC2B41CDCCCC2CE68D594166666666C6BC2B419A9999B9DF8D59419A9999991ABD2B4166666646F68D5941CDCCCCCC8DBD2B4166666686EE8D5941CDCCCCCC77BD2B41333333D3E98D59419A99999949BD2B419A999939E28D5941000000002ABD2B41CDCCCCACDA8D59419A9999991CBD2B41CDCCCC8CD88D59419A99999905BD2B4166666666D48D594100000000F7BC2B41CDCCCC2CD18D59419A999999E2BC2B41CDCCCCACCB8D594100000000DABC2B4100000080C88D594133333333D5BC2B419A999979C48D594166666666D6BC2B4100000080C18D59419A999999D8BC2B41333333F3BD8D594166666666DCBC2B4100000040BB8D594100000000E0BC2B41333333B3B88D594166666666E7BC2B4166666686B68D594166666666F0BC2B419A9999D9B38D59419A999999F8BC2B4133333333B08D59419A99999900BD2B41CDCCCC4CAD8D5941333333330ABD2B4166666646A98D59419A99999915BD2B41333333F3A58D59410000000020BD2B41CDCCCC2CA48D59410000000037BD2B41CDCCCC2CA18D59410000000065BD2B41CDCCCCAC9B8D59410000000085BD2B41000000C0968D5941666666669DBD2B41000000C0978D59419A9999992DBE2B419A9999B99D8D594100000000E2BE2B4100000020A28D5941CDCCCCCC65BF2B41333333D3A98D594100000000B3BF2B419A9999B9B58D5941CDCCCCCC2EC02B4133333313BD8D594100000000C5C02B4133333353BB8D59419A99999930C12B419A999939B78D59419A9999996BC12B41333333B3BD8D59419A99999985C12B4133333313C58D5941CDCCCCCC91C12B4133333373C88D5941333333339CC12B419A999999CB8D594100000000A9C12B419A9999B9CE8D5941CDCCCCCCBCC12B4133333393D38D594166666666CEC12B419A9999F9D88D5941CDCCCCCCE8C12B41CDCCCC8CDF8D59410000000017C22B41333333F3EB8D59410000000034C22B41666666C6F38D59419A99999960C22B41CDCCCC4CFF8D59413333333395C22B419A9999990D8E594166666666CDC22B41666666261C8E594133333333EDC22B41000000A0248E5941CDCCCCCC0AC32B41333333732C8E5941666666662CC32B41CDCCCC8C358E59413333333353C32B41666666463F8E59413333333377C32B41CDCCCCAC488E59416666666691C32B41666666664F8E59410000000081C42B419A9999391E8E594166666666F7C42B41000000A0078E594100000000ACC52B41CDCCCC6C118E59419A99999933C72B419A9999F92E8E59410000000094C72B41CDCCCC8C3A8E59419A999999DDC82B41333333533C8E59413333333327C92B41CDCCCC2C358E59419A99999951CA2B4166666666388E594100000000DBCA2B419A9999D9328E5941333333336ACB2B41CDCCCC0C358E594100000000C5CB2B41CDCCCCAC388E59410000000022CC2B41CDCCCC8C378E59413333333312CD2B41000000C0358E5941333333335BCD2B4166666606378E594133333333A5CD2B41333333B3398E5941666666661DCE2B41333333533D8E5941666666663BCE2B41666666C63F8E594133333333F9CE2B41CDCCCCAC4C8E5941CDCCCCCC89D02B41666666864A8E594166666666ECD02B41000000A0448E5941000000003AD12B4133333353398E59413333333378D12B4166666646398E594166666666B4D12B41333333D3398E59410000000011D22B4133333313468E594133333333D9D32B41CDCCCCCC068E5941333333339FD32B419A999919FF8D594166666666B5D42B4100000080D68D594166666666A3D52B4100000080BF8D594100000000E9D62B41000000A08D8D59410000000017D72B41666666468B8D59419A9999994ED72B41333333537B8D59419A9999996DD72B41CDCCCC4C738D5941CDCCCCCC74D72B4133333393708D59416666666666D72B41CDCCCC6C698D59410000000047D72B41CDCCCCEC5F8D5941CDCCCCCC0ED72B4100000000518D594166666666D2D62B41666666663F8D5941666666669BD62B4100000060318D59416666666671D62B4166666606258D5941000000005AD62B41333333B31F8D59419A99999943D62B41CDCCCC2C198D59419A99999941D62B41CDCCCCAC188D5941000000002AD62B419A999979118D59410000000004D62B4100000000078D59419A999999E1D52B4100000060FB8C5941CDCCCCCCBED52B41333333F3EF8C594100000000A9D52B4100000080EA8C5941333333339CD52B41333333B3E88C59419A9999997FD52B41CDCCCC8CE28C594100000000DCD52B41000000E0BF8C594100000000F9D52B41333333B3B68C59416666666674D62B419A999999A48C594133333333CFD62B41333333D3968C59416666666600D72B419A9999D9828C59419A99999914D72B41000000405E8C5941000000000CD72B41666666A61B8C59410000000009D72B4133333353038C59419A9999990CD72B41333333D3FE8B5941CDCCCCCC0ED72B4100000060FA8B59419A9999990ED72B4100000080F78B5941CDCCCCCC0DD72B41666666C6F38B59419A9999990DD72B419A9999B9EF8B59419A9999990CD72B4100000000EA8B5941333333330BD72B4133333353E58B5941CDCCCCCC08D72B41CDCCCC2CE18B59413333333308D72B419A999999DC8B59410000000008D72B419A9999B9D68B59416666666608D72B419A999959D58B59413333333308D72B41333333B3D38B59416666666609D72B4100000080D18B59416666666608D72B419A9999D9CF8B59416666666605D72B419A9999F9CC8B5941CDCCCCCC03D72B419A999979CA8B59413333333306D72B4166666606C88B59413333333308D72B4133333373C48B5941CDCCCCCC07D72B4166666626C08B5941CDCCCCCC03D72B41CDCCCCCCBA8B5941000000000AD62B41000000C0858B594100000000D0D52B41000000E0778B59413333333399D52B419A9999F96D8B5941CDCCCCCC6ED52B4133333393648B5941666666665BD52B41000000005D8B59416666666654D52B419A9999995A8B5941CDCCCCCC52D52B41333333B3578B5941CDCCCCCC51D52B419A9999D9538B5941CDCCCCCC53D52B41333333F34D8B59419A99999954D52B419A999979488B59410000000058D52B41000000C0428B5941CDCCCCCC59D52B41666666E63D8B5941333333335DD52B41666666C6378B59413333333361D52B41333333B32F8B5941CDCCCCCC5FD52B419A9999192B8B59419A9999995FD52B4100000040288B5941000000005DD52B41666666C6238B5941CDCCCCCC59D52B41666666461F8B59413333333357D52B41000000A01C8B59419A99999954D52B419A999999198B59419A9999994BD52B4133333393158B59416666666645D52B419A9999D9138B5941666666663FD52B4133333333128B59419A99999929D52B41CDCCCC4C0E8B59419A999999E7D42B41000000A0058B594100000000F9D32B41666666C6F18A59419A9999995FD32B4166666686DE8A5941CDCCCCCC2BD22B4166666606B08A594133333333C4D12B41333333D3998A594133333333AAD12B41666666C6958A59419A99999998D12B41CDCCCC0C938A59419A99999982D12B41333333B38F8A59413333333372D12B41CDCCCC6C8C8A59419A9999995CD12B4166666686888A5941000000004AD12B41CDCCCC2C858A59419A9999992AD12B41CDCCCC8C7E8A59410000000011D12B419A9999F9788A594166666666FFD02B4100000040758A594133333333E4D02B41666666666F8A594166666666D1D02B41000000806A8A5941CDCCCCCCC1D02B41CDCCCC8C678A594133333333A2D02B41000000E0618A5941CDCCCCCC1FD02B419A9999794F8A59419A99999947CF2B41CDCCCCCC338A5941CDCCCCCC54CC2B41000000C09C895941CDCCCCCCF4CB2B41CDCCCC2C88895941000000007BCA2B4133333353388959419A99999942C72B41CDCCCC6C2189594166666666B2C52B41CDCCCC2C1F895941000000009FC52B410000000023895941CDCCCCCC94C52B4133333373228959416666666680C52B41CDCCCCAC228959419A99999965C52B419A999979238959419A99999948C52B416666664624895941CDCCCCCC29C52B41666666C624895941CDCCCCCC06C52B41000000202589594100000000E6C42B419A9999B924895941CDCCCCCCC3C42B41CDCCCC2C2489594166666666B9C42B410000002024895941CDCCCCCCB0C42B41000000202489594100000000A8C42B41CDCCCC4C24895941CDCCCCCC9EC42B41000000A0248959419A99999986C42B41666666E6248959413333333369C42B41333333D3248959410000000044C42B41000000E0248959413333333325C42B419A999999248959419A999999FCC32B416666660624895941CDCCCCCCE2C32B41333333D32389594100000000CEC32B419A999939238959419A999999B9C32B4133333313228959419A999999A6C32B41CDCCCCCC1F8959416666666696C32B41666666061E8959413333333384C32B41333333331D895941000000006BC32B41000000001D895941000000005FC32B41CDCCCC4C1D895941333333333DC32B41000000601E8959419A99999915C32B41333333731F8959419A999999E8C22B41CDCCCC6C20895941CDCCCCCCC5C22B419A9999592189594100000000ACC22B410000002022895941333333339CC22B4100000020228959413333333393C22B41000000C021895941666666668AC22B416666668620895941666666667FC22B41333333731E8959410000000076C22B41000000401D895941000000006EC22B41000000A01C8959413333333360C22B41333333131D8959416666666645C22B41CDCCCC2C1E895941CDCCCCCC17C22B41CDCCCCEC1F89594133333333FEC12B41CDCCCC0C21895941CDCCCCCCE0C12B41CDCCCC0C2289594166666666C3C12B419A99991923895941333333339FC12B4133333393248959419A99999988C12B419A999959258959413333333366C12B4166666646268959416666666644C12B416666666627895941000000002DC12B4166666666288959416666666617C12B41666666A6298959419A999999FFC02B41CDCCCC0C2B89594133333333EEC02B41000000E02B895941CDCCCCCCD5C02B419A9999992C89594100000000B4C02B41CDCCCC0C2D8959419A9999998AC02B41333333D32D8959416666666667C02B41CDCCCC4C2E895941CDCCCCCC41C02B419A9999D92E895941666666661DC02B41CDCCCC4C2F895941000000000CC02B41000000602F8959419A999999FBBF2B41CDCCCC6C2F895941CDCCCCCCEBBF2B41333333B32F8959419A999999DDBF2B41000000003089594166666666C9BF2B41CDCCCCAC3089594133333333B7BF2B41333333333189594133333333A5BF2B41000000E0318959416666666688BF2B41CDCCCCCC32895941000000006FBF2B419A99997933895941CDCCCCCC5CBF2B41000000E033895941CDCCCCCC44BF2B416666662634895941666666662ABF2B4166666686348959410000000018BF2B41666666A6348959419A99999911BF2B41666666C63489594100000000F8BE2B41CDCCCCEC348959419A999999DDBE2B41000000C0348959419A999999BEBE2B419A9999B93489594166666666B0BD2B41666666C6468959416666666689BC2B41CDCCCCCC5089594133333333B5BC2B41CDCCCCAC5D8959419A99999904BD2B41666666C66C8959416666666617BD2B4100000060798959419A99999974BD2B41333333539C8959410000000092BB2B419A999999B589594100000000ADBB2B419A9999B9D089594133333333C0B92B4166666606F489594166666666BFB62B41CDCCCCCC4E8A594133333333A8B62B419A999999508A5941666666667DB62B41CDCCCCCC558A59416666666629B62B41CDCCCCCC5F8A594166666666D8B52B4100000080698A59419A99999996B52B41333333F3718A5941CDCCCCCC64B52B41CDCCCCAC788A59410000000032B52B419A9999D97D8A5941CDCCCCCCFAB42B4166666606848A594133333333B1B42B41333333938C8A5941666666668CB42B419A9999B9908A59416666666668B42B41CDCCCC8C948A5941666666664AB42B419A9999D9978A59416666666620B42B41666666269C8A594166666666FFB32B419A9999599F8A594133333333C7B32B4133333313A48A594100000000A5B32B41CDCCCCACA68A59419A99999991B32B41666666A6A78A59419A99999989B32B41666666C6A78A59413333333382B32B4166666686A78A5941666666667BB32B419A9999D9A68A594166666666EAAF2B419A9999D9F58A5941666666667EAF2B41CDCCCC4CE48A59410000000095AE2B4100000020ED8A5941333333336CAE2B419A999939F18A5941333333331CAE2B4133333353F88A594100000000CEAD2B419A999919FF8A59410000000082AD2B419A9999D9058B59419A99999951AD2B41CDCCCCCC098B5941000000002DAD2B41000000A00C8B594166666666D8AC2B41333333D3128B59419A9999997BAB2B41CDCCCCEC368B59410000000070AB2B4100000040388B59410000000069AB2B419A9999D9388B59410000000057AB2B41000000C0398B594133333333A6A92B41666666C66E8B5941	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	01010000206A0800009485129FDDC02B4166666686D48B5941	700450000	Z	Avrigney-Virey	7004500	70045	70	27	22
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	01010000206A080000A909C69B98442D4133333363FFAB5941	700460000	Z	Les Aynans	7004600	70046	70	27	8
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	01010000206A080000949AFA2EA5592C419A9999D9A9A65941	700470000	Z	Baignes	7004700	70047	70	27	3
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	01010000206A0800009CB923541F6B2B413433332301855941	700480000	Z	Bard-lès-Pesmes	7004800	70048	70	27	5
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	01010000206A0800000A8F23469ED62B41333333531CC65941	700490000	Z	Barges	7004900	70049	70	27	8
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	01010000206A080000348E26E225A62C413333333380945941	700500000	Z	La Barre	7005000	70050	70	27	2
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	01060000206A08000001000000010300000001000000A20000009A999999043E2C419A9999598ECE59419A9999996D3E2C41CDCCCCCCA8CE594133333333E83E2C4166666686C3CE5941CDCCCCCC4D3F2C419A999979EECE5941CDCCCCCC493F2C41CDCCCC8CF8CE5941CDCCCCCC70412C41CDCCCCCC09CF594100000000F6412C419A9999D910CF59419A999999B3422C410000004020CF5941666666667A432C41CDCCCC2C33CF59413333333374442C419A9999793CCF59410000000020452C410000004049CF5941CDCCCCCC43452C41000000204BCF594100000000DD452C41333333F34CCF5941000000008F462C413333331354CF59416666666637472C41CDCCCC0C5ACF5941000000007A472C416666662659CF5941CDCCCCCCCE472C41666666A659CF59413333333322482C41000000605CCF5941333333333F482C41666666A65ECF5941CDCCCCCCC3482C41CDCCCC6C59CF5941666666665E4A2C410000002057CF594100000000C84A2C419A9999B94DCF594166666666014B2C419A9999794BCF594166666666334B2C419A99991944CF5941CDCCCCCC564B2C41000000A02ECF5941CDCCCCCC8B4B2C413333335326CF594133333333B14B2C41666666E624CF59419A999999884C2C410000006027CF594166666666DB4C2C41CDCCCC8C26CF5941CDCCCCCC754D2C41000000A020CF594133333333DF4D2C41666666C612CF5941CDCCCCCCFF4D2C419A9999390ACF5941333333330D4E2C413333333303CF594166666666564E2C41CDCCCC0C08CF594166666666154F2C41CDCCCCAC0BCF594133333333804F2C41000000A00ECF59419A9999992A502C41666666860DCF594166666666F1502C41666666E607CF5941000000002C512C416666662607CF59413333333372512C410000002008CF59410000000098512C419A99995910CF5941000000002D522C410000002010CF59410000000060522C413333331307CF5941333333339F522C413333331303CF59419A999999F6522C41CDCCCC8C00CF59413333333370532C41CDCCCC2CFFCE5941000000002A542C416666664601CF5941000000004C542C41000000E005CF59419A9999996D542C419A9999F90FCF5941CDCCCCCC98542C416666664618CF594100000000C6542C41CDCCCC4C1ECF59410000000058552C41666666862ECF5941666666667D552C419A99999931CF594133333333BB552C41000000E033CF594100000000E9552C413333333338CF5941333333335B562C419A9999393FCF5941CDCCCCCC85562C416666666640CF59413333333302572C41CDCCCCAC40CF5941666666662D572C41666666C641CF59410000000075572C413333339347CF59419A99999904582C41000000C047CF5941000000005B582C419A9999D946CF5941CDCCCCCC8D582C41CDCCCCCC47CF5941CDCCCCCCCD582C41CDCCCCEC46CF5941666666664B592C41CDCCCC6C49CF594100000000E7592C41000000204ECF594166666666315A2C41000000404DCF594133333333965A2C419A9999794DCF5941CDCCCCCC595B2C41000000004FCF594100000000735B2C419A9999B94CCF594100000000A85B2C419A9999994CCF5941CDCCCCCC4A5C2C413333331351CF59419A999999505C2C41000000403ECF594133333333865C2C413333339320CF594100000000A75C2C419A99999919CF5941333333330E5D2C41CDCCCCEC13CF5941000000006E5D2C41CDCCCC6C0CCF59419A999999925D2C41666666C607CF5941CDCCCCCCE25D2C419A9999B9EBCE5941000000000D5E2C4100000040E0CE5941333333333E5E2C41CDCCCC8CC9CE59419A999999445E2C41CDCCCC8CC0CE594166666666485E2C4166666666ABCE5941CDCCCCCC3A5E2C41CDCCCCCC97CE594133333333075E2C41666666E682CE594100000000145E2C413333331376CE59419A999999385E2C41CDCCCCCC69CE5941CDCCCCCC5F5E2C41333333D360CE594133333333715E2C41000000205ACE5941000000007C5E2C41CDCCCC0C4ECE59419A999999A25E2C41000000C044CE594133333333CD5E2C41333333D330CE594166666666DC5E2C410000000022CE594166666666315F2C413333333308CE594133333333165F2C4100000020F4CD5941CDCCCCCCE05E2C4100000020E5CD5941CDCCCCCCA15E2C41333333D3D5CD5941000000004D5E2C4133333313C5CD5941CDCCCCCCA25C2C41CDCCCCAC96CD594100000000715C2C410000002092CD59419A999999DC5B2C41666666C686CD594166666666705B2C419A9999397CCD594133333333735B2C41666666268CCD594100000000435B2C41333333D394CD59419A999999905A2C41CDCCCCEC88CD5941CDCCCCCC845A2C413333331391CD59419A999999505A2C419A99991998CD59419A999999E8592C419A99993997CD59419A99999968592C419A9999D9A1CD5941CDCCCCCCDF582C4166666626AFCD59410000000024592C4100000020B9CD5941CDCCCCCC99582C41333333B3D4CD59413333333359582C4100000060D5CD59419A9999992D582C4100000060DBCD594133333333BA572C419A999999DFCD5941333333332E572C419A999999F8CD5941CDCCCCCCD6562C419A99995905CE59416666666693562C41000000A00BCE594133333333E6562C41666666261BCE5941CDCCCCCC84562C413333335322CE5941CDCCCCCC90562C410000006030CE5941CDCCCCCC85562C41333333D343CE59413333333368562C41666666064FCE59419A999999FC552C410000000061CE5941CDCCCCCCA4552C41000000006BCE594133333333DD552C419A99997971CE5941333333338A552C41CDCCCCCC73CE594133333333E9542C41333333935CCE59419A99999979542C41CDCCCC4C68CE5941CDCCCCCCDC532C419A99997956CE5941333333331D532C41CDCCCC8C44CE5941CDCCCCCC4B532C41CDCCCC6C38CE59419A9999993D532C416666660634CE594100000000AD522C413333331329CE5941CDCCCCCC16522C410000006020CE5941333333332F512C41CDCCCC4C14CE59410000000062502C419A9999590ECE594100000000C84F2C419A9999D908CE594166666666AD4F2C41CDCCCCAC17CE594100000000904F2C41CDCCCC2C1ACE5941CDCCCCCC614F2C41000000A00FCE594133333333EB4E2C410000008006CE594133333333AF4E2C419A9999B917CE594166666666714E2C416666660627CE594100000000064E2C41000000C038CE5941CDCCCCCC754D2C41666666864BCE594100000000234D2C41000000205BCE594100000000ED4C2C410000000069CE59419A999999D94C2C413333337378CE594166666666D94C2C410000000082CE594133333333FE4C2C41000000C0A8CE594100000000154D2C41000000C0BCCE594133333333194D2C41CDCCCCACD3CE594166666666284D2C4166666686DFCE594166666666CF4C2C4166666686E0CE59419A999999B04C2C4133333373DECE59410000000076462C41000000E0B9CE59416666666616452C41666666E6B1CE594100000000E2432C41CDCCCC4CABCE59413333333355412C41333333739CCE59419A999999043E2C419A9999598ECE59419A999999043E2C419A9999598ECE5941	01010000206A08000054E5130B23512C419A9999196ECE5941	700510000	Z	La Basse-Vaivre	7005100	70051	70	27	4
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	01010000206A080000F65475AF7AA22C41CDCCCC2C8BC15941	700520000	Z	Bassigney	7005200	70052	70	27	6
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	01010000206A080000012960F6EA022C41CDCCCCDC3E9E5941	700530000	Z	Les Bâties	7005300	70053	70	27	8
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