SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep72;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep72 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep72','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep72','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep72','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep72"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800001C369E8EC5921D410000005014DB5941	720010000	Z	Aigné	7200100	72001	72	52	13
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	01010000206A0800008811EE3B0F981E41666666A6C0FE5941	720020000	Z	Aillières-Beauvoir	7200200	72002	72	52	15
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	01060000206A0800000100000001030000000100000020000000000000009AC61D419A9999F913D059419A999999BBC61D41333333B321D05941CDCCCCCC2EC71D41666666663BD059413333333363C71D410000000044D05941CDCCCCCCA6CA1D41666666662DD05941666666666ACA1D419A99991924D05941000000008ECA1D413333331322D05941CDCCCCCCDCCA1D413333333308D059419A9999995BCB1D41000000A009D05941CDCCCCCC30CC1D416666662603D059410000000050CC1D41CDCCCC2CFFCF5941CDCCCCCC7CCC1D419A999919ECCF59413333333307CD1D4100000040EDCF59413333333325CD1D4100000040E3CF5941CDCCCCCC8ACD1D4100000040E4CF59419A99999921CE1D41000000E0D0CF594133333333C9CD1D41333333D3D0CF594100000000AACB1D41000000E0D6CF59419A99999981CA1D4166666666D4CF5941CDCCCCCC42CA1D419A999999D4CF594166666666F6C71D4133333313DFCF59416666666624C81D41333333B3E5CF59419A99999901C91D41CDCCCC4CE1CF59416666666646C91D419A999979E1CF5941CDCCCCCC1AC91D41000000C0F1CF594133333333A7C81D41666666C6F7CF5941CDCCCCCCBCC81D41333333B3FACF59410000000092C71D419A9999D904D05941CDCCCCCCB4C71D410000006009D05941333333332BC71D41CDCCCC8C0DD05941000000009AC61D419A9999F913D05941000000009AC61D419A9999F913D05941	01010000206A080000566EBED528C91D41343333E30AD05941	720030104	H	Les Perrières	7200301	72003	72	52	0
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	01010000206A080000A810E42010B21D419A999949DECF5941	720030101	H	Les Ruisseaux	7200301	72003	72	52	8
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	01060000206A080000010000000103000000010000002E000000CDCCCCCCA0C61D41333333F3B6D05941CDCCCCCCB8C61D4100000020B9D05941000000008EC91D419A999959C0D05941CDCCCCCCBEC91D419A999919C2D059416666666676C91D41333333B3E1D05941CDCCCCCC8EC91D4100000020E9D0594100000000B6C91D41CDCCCC4CECD059416666666632CC1D41CDCCCC2CFBD059410000000036CD1D41333333D3D7D059419A999999DFCD1D419A9999D9C7D059419A999999A5CE1D4133333353BFD05941CDCCCCCC56CF1D419A999999C0D059419A99999959D11D419A999919CAD059419A999999FDD11D4133333313CBD0594100000000BCD21D4166666666CAD059416666666640D31D4100000060C8D059419A999999D9D31D4133333313C2D05941666666664CD41D4133333373B9D0594133333333D1D21D4133333353A9D059419A999999EFD11D41333333B3BCD05941CDCCCCCCAED11D4100000020BFD059419A9999991FD11D4100000000BED0594100000000EAD01D41333333F3B9D0594133333333AFD01D4100000040ADD059410000000098D01D4133333393ADD0594133333333BFCE1D419A9999B9A8D059416666666606CF1D41CDCCCC0C8ED0594166666666F2CE1D41666666868BD05941333333333BCD1D419A99997986D0594133333333FFCC1D41000000009DD05941000000005ECC1D41CDCCCCAC9BD059413333333389CC1D410000008084D05941CDCCCCCC4CCB1D416666666681D059419A9999990BCB1D41CDCCCC8C97D059410000000042CA1D41333333F395D059413333333395CA1D419A9999F974D05941CDCCCCCC90CA1D419A9999396BD0594133333333C7C91D41CDCCCC4C65D059419A99999971C91D41CDCCCC0C70D059413333333349C91D41000000207BD05941CDCCCCCC56C91D419A9999F981D0594133333333F3C81D419A99999984D05941CDCCCCCCE0C81D41CDCCCC2C8AD059416666666618C71D41666666C685D05941CDCCCCCCA0C61D41333333F3B6D05941CDCCCCCCA0C61D41333333F3B6D05941	01010000206A080000054DED55B9CB1D4166666686B2D05941	720030102	H	Le Chaoué	7200301	72003	72	52	0
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	01010000206A080000D05657BDD7D31D416666666603D05941	720030103	H	La Tour aux Fées	7200301	72003	72	52	1
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	01060000206A08000001000000010300000001000000B3000000666666665ADC1D4166666666CACF59416666666668DC1D4133333353B4CF5941666666665ADC1D41666666C6A0CF5941CDCCCCCC34DC1D41CDCCCC0C8ECF5941CDCCCCCC02DC1D41000000A07ECF59419A99999987DB1D419A9999396ACF5941333333336BDB1D410000000061CF59419A9999996DDB1D410000002044CF59419A9999998FDB1D41666666A636CF5941666666661EDC1D416666666621CF59419A999999DBDC1D41000000C00CCF5941CDCCCCCC72DD1D41000000E000CF5941000000007CDE1D41CDCCCCCCF5CE594133333333A7DE1D419A999979F2CE594100000000DADE1D41333333D3E9CE594166666666F6DE1D41CDCCCC6CE0CE5941CDCCCCCC20DF1D41333333B3C5CE59410000000036DF1D4133333333AECE5941CDCCCCCC32DF1D41000000C09FCE59419A99999917DF1D416666664690CE5941CDCCCCCCEADE1D41000000A07ECE5941CDCCCCCC84DE1D41CDCCCCCC63CE59419A9999992BDE1D416666662643CE594166666666CADD1D419A9999992FCE5941CDCCCCCC86DD1D41666666E61ECE5941666666661ADD1D41666666660ECE5941CDCCCCCCE2DB1D41666666E6EECD594100000000FADA1D4166666646CDCD59419A99999961DA1D41333333F3B3CD59419A99999943DA1D4133333333ABCD59419A99999937DA1D41CDCCCC4C99CD5941666666666CDA1D413333335387CD59413333333383D41D419A99991984CD5941333333332DD21D416666668687CD59413333333313CB1D419A99991998CD594100000000EAC81D41000000409ECD594133333333FFC71D41666666E684CD59416666666648C61D41CDCCCCCC3DCD59416666666606C61D41000000A03ECD594133333333A5C41D413333333348CD59419A9999997DC31D41CDCCCCEC4CCD59413333333343C01D416666660657CD59416666666622BD1D419A9999B961CD59419A999999B1BC1D41666666A663CD5941000000006EBA1D41CDCCCC6C6FCD594133333333AFB71D416666668680CD5941CDCCCCCCF0B61D41666666A682CD59419A99999983B61D410000002085CD59410000000054B61D41CDCCCC2C8ACD5941CDCCCCCC4CB41D419A99999994CD5941CDCCCCCCAEB31D41333333D398CD59410000000044B11D4133333333A2CD59419A999999C7B01D41CDCCCC6CA3CD5941CDCCCCCCD0B01D41666666A685CD594100000000C6B01D410000004076CD5941CDCCCCCCCAB01D41666666A666CD594133333333E7B01D419A99991958CD5941CDCCCCCC84B01D41666666C653CD594133333333BFAF1D41333333133ACD59413333333381AF1D41CDCCCC6C2ACD59410000000038AF1D419A9999F92CCD59410000000034AE1D41333333333ACD59419A999999DFAC1D41333333134ACD594166666666AAAC1D41333333334ACD59416666666608AA1D410000006044CD5941000000008CA81D41CDCCCC8C1CCD594133333333BBA71D41333333930CCD59419A99999963A71D41CDCCCC8C03CD5941CDCCCCCCDAA61D4166666606F1CC5941333333338BA61D419A9999B9D9CC594100000000CCA51D419A9999D9C3CC59410000000036A51D4100000020B8CC5941333333337BA31D41666666069CCC59413333333395A11D4100000040BACC59419A999999239F1D4100000020A5CC594133333333ED9E1D4100000080A7CC59419A9999994D9E1D41CDCCCC6CB9CC594166666666629D1D4166666686DCCC5941000000004A9F1D419A99993918CD594166666666A89D1D41CDCCCCAC28CD5941CDCCCCCC089D1D41666666462BCD594166666666CC9C1D41CDCCCC8C27CD594133333333399C1D41333333D331CD5941CDCCCCCCCA9A1D41CDCCCC0C40CD59419A99999901981D41CDCCCC6C42CD5941CDCCCCCCF0961D413333339341CD5941000000001A971D413333333348CD59419A999999F7971D41CDCCCC0C54CD594100000000A0951D41CDCCCC8C75CD594166666666FA951D419A9999D991CD59419A999999C5951D410000004096CD59419A9999994D961D41666666A6A3CD5941CDCCCCCC18961D4100000020A6CD594100000000DA971D41333333F3C2CD5941CDCCCCCC5E981D419A999939CCCD594166666666C4981D419A9999D9D4CD5941CDCCCCCC689A1D41333333F301CE59419A999999DD9A1D41CDCCCC2C0CCE5941333333335B9E1D419A9999794DCE59419A999999099F1D41666666E659CE59419A9999992BA01D41000000806BCE59419A99999983A11D419A9999397FCE59419A9999990DA21D419A99995989CE5941CDCCCCCC40A21D419A9999998FCE59416666666678A21D41000000809ACE59419A99999905A41D41333333B3F2CE5941CDCCCCCC54A41D419A999979FFCE594166666666DCA41D41CDCCCCCC0CCF59410000000040A61D41CDCCCC4C28CF59410000000086A61D419A9999592FCF59419A9999994BA71D41666666C64CCF5941CDCCCCCC80A71D41CDCCCCEC5ACF59413333333341A81D41CDCCCC6C5ECF5941CDCCCCCCC8A91D41CDCCCC4C6ACF5941CDCCCCCC3EAC1D416666666682CF5941666666662AAD1D41333333F380CF594166666666C6AD1D41333333B379CF59416666666672AE1D410000008074CF5941000000006EAF1D410000000070CF5941000000007EB01D41CDCCCC0C6DCF594100000000FEB01D41000000606ACF59419A99999971B21D41CDCCCC6C5FCF594133333333FDB31D419A9999996CCF5941333333334BB41D41000000C06FCF59416666666616B51D41CDCCCCEC7ACF594166666666DCB61D41000000A064CF5941CDCCCCCC70B71D419A9999F95BCF59419A9999991DB81D41CDCCCCCC4FCF59419A9999994DB81D41333333D34DCF59419A999999B5B81D419A9999D950CF5941333333335BB91D41666666C66BCF59413333333377B91D41666666C66CCF5941333333339DBC1D41333333136DCF5941CDCCCCCCA2BC1D41333333B384CF59419A999999C7BD1D41CDCCCC4C84CF5941CDCCCCCCACBD1D413333337369CF59419A999999B7BE1D419A99995969CF5941CDCCCCCCD4BE1D41666666A655CF5941333333330BBF1D419A99995947CF59416666666644BF1D41CDCCCCEC3CCF5941666666668AC41D41333333F33ACF59413333333339C51D41000000A03BCF59410000000076C51D41000000C053CF5941CDCCCCCC28C61D41CDCCCCAC4DCF59419A9999999FC61D41000000A04FCF59416666666620C81D419A9999B950CF59416666666602C81D410000006061CF59410000000032C81D41000000E060CF5941CDCCCCCCF0C81D41CDCCCC8C63CF59419A99999973C91D41000000405FCF5941CDCCCCCC5AC91D419A99993966CF59419A99999961C91D41CDCCCC2C6DCF594166666666C0C91D413333331379CF5941CDCCCCCC90CB1D41333333737FCF59416666666688CC1D41333333739FCF5941CDCCCCCC8ACD1D41000000E0A4CF594100000000F6CD1D41333333D3A4CF59419A9999997FCE1D419A9999B995CF5941CDCCCCCC24CF1D419A99991980CF59410000000076D01D41000000607ACF59419A99999959D01D410000002089CF59419A999999E7D01D41000000E085CF5941CDCCCCCCF0D21D419A9999B97CCF5941CDCCCCCC46D31D41666666C67ACF5941CDCCCCCC86D41D41000000A069CF594166666666E4D41D419A9999B960CF5941333333332BD51D419A99991960CF594133333333F5D51D41666666E658CF5941CDCCCCCCA2D61D419A9999394DCF59410000000050D81D413333331355CF5941333333335BD81D41333333D35ECF59410000000042D81D419A99999974CF5941333333334DD81D41000000207ECF594100000000ACD81D41000000A087CF5941666666662ED91D41CDCCCC6CA1CF59419A9999994DD91D41CDCCCCACACCF5941333333337BD91D41333333F3CCCF5941666666665ADC1D4166666666CACF5941666666665ADC1D4166666666CACF5941	01010000206A080000DFFAE01768BD1D41CDCCCC3C33CE5941	720030105	H	Campagne-Hautes Métairies	7200301	72003	72	52	9
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	01010000206A0800006453F85CF5E41C41000000801AD85941	720040000	Z	Amné	7200400	72004	72	52	16
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	01010000206A0800001838F44FDFF01D4166666656EBFA5941	720050000	Z	Ancinnes	7200500	72005	72	52	27
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	01010000206A080000D03D0E15198B1D419A9999F9EEFE5941	720060000	Z	Arçonnay	7200600	72006	72	52	8
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	01010000206A080000D4CC8181B7041F41CDCCCC2C2CD25941	720070000	Z	Ardenay-sur-Mérize	7200700	72007	72	52	12
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	01060000206A080000010000000103000000010000002A000000000000005CE21D410000004042CE594166666666A8E21D419A99993948CE59419A999999D5E21D413333339350CE5941333333333DE31D41666666E669CE59410000000090E31D410000000077CE59419A9999993BE41D41CDCCCC6C8BCE5941333333335FE51D41CDCCCCECAFCE5941000000009AE51D4166666666B1CE5941333333339BE51D4166666626ABCE59416666666600E61D416666664696CE59419A99999947E61D41000000C08BCE594100000000C6E61D419A9999D981CE59413333333359E71D419A9999B971CE59419A999999EBE71D41CDCCCCEC6ACE5941CDCCCCCC4EE81D410000004069CE59410000000002E91D419A9999F96ACE59419A99999907EA1D410000002070CE59410000000066EA1D41666666465DCE5941CDCCCCCC8EEE1D41666666065ACE5941CDCCCCCC60EF1D41CDCCCCEC56CE594100000000DCEF1D41CDCCCCCC53CE5941CDCCCCCC0CF31D419A9999B941CE59413333333375F01D419A999999CACD594100000000C0EF1D4100000060A2CD59416666666634EF1D41333333B389CD59416666666604EF1D41000000A083CD59410000000082EE1D41333333137ACD59413333333307EE1D416666660673CD5941000000006EED1D41CDCCCC4C6DCD594133333333C3EC1D416666664669CD59413333333303EC1D416666666666CD59419A999999F1E81D41CDCCCC4C5ECD59419A99999939E51D41666666E654CD59410000000056E41D416666660683CD59419A999999C9E31D41CDCCCC6CA1CD59419A9999997FE31D4133333333B5CD5941000000005EE31D41CDCCCC4CC1CD59416666666632E31D41CDCCCCCCD7CD594133333333D5E21D4166666606FFCD5941CDCCCCCC60E21D41CDCCCC6C36CE5941000000005CE21D410000004042CE5941000000005CE21D410000004042CE5941	01010000206A08000018C4113E3BEA1D419A99995901CE5941	720080101	H	La Gautrie	7200801	72008	72	52	1
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	01060000206A08000001000000010300000001000000CD000000666666666CDA1D413333335387CD59419A99999937DA1D41CDCCCC4C99CD59419A99999943DA1D4133333333ABCD59419A99999961DA1D41333333F3B3CD594100000000FADA1D4166666646CDCD5941CDCCCCCCE2DB1D41666666E6EECD5941666666661ADD1D41666666660ECE5941CDCCCCCC86DD1D41666666E61ECE594166666666CADD1D419A9999992FCE59419A9999992BDE1D416666662643CE5941CDCCCCCC84DE1D41CDCCCCCC63CE5941CDCCCCCCEADE1D41000000A07ECE59419A99999917DF1D416666664690CE5941CDCCCCCC32DF1D41000000C09FCE59410000000036DF1D4133333333AECE59413333333323DF1D41000000A0C3CE59410000000080E01D4166666646C5CE5941CDCCCCCC0AE21D4133333353C4CE594133333333E5E21D4166666626C2CE59410000000042E41D419A999959BBCE5941000000009AE51D4166666666B1CE5941333333335FE51D41CDCCCCECAFCE59419A9999993BE41D41CDCCCC6C8BCE59410000000090E31D410000000077CE5941333333333DE31D41666666E669CE59419A999999D5E21D413333339350CE594166666666A8E21D419A99993948CE5941000000005CE21D410000004042CE5941CDCCCCCC60E21D41CDCCCC6C36CE594133333333D5E21D4166666606FFCD59416666666632E31D41CDCCCCCCD7CD5941000000005EE31D41CDCCCC4CC1CD59419A9999997FE31D4133333333B5CD59419A999999C9E31D41CDCCCC6CA1CD59410000000056E41D416666660683CD59419A99999939E51D41666666E654CD59419A999999F1E81D41CDCCCC4C5ECD59413333333303EC1D416666666666CD594133333333C3EC1D416666664669CD5941000000006EED1D41CDCCCC4C6DCD59413333333307EE1D416666660673CD59410000000082EE1D41333333137ACD59416666666604EF1D41000000A083CD5941666666668CEF1D419A99999998CD594133333333E3EF1D41000000C0AACD59416666666698F01D419A9999B9A5CD5941CDCCCCCCFEF01D41CDCCCCACA5CD59413333333329F21D419A9999F9A0CD5941CDCCCCCC5CF21D41333333B3A4CD5941000000001CF31D4100000020A3CD59419A999999CDF31D4133333393A4CD594166666666E8F41D4133333373A2CD59419A99999919F61D41000000809DCD594100000000D2F61D41000000A099CD5941CDCCCCCCEEF71D410000002097CD59419A99999997F81D410000006096CD59419A9999996BFA1D41CDCCCC6C96CD5941333333339BFA1D41666666E694CD5941CDCCCCCCF8FC1D41000000E07ACD5941000000004AFD1D410000004075CD59419A9999998F001E41333333537ACD59413333333393001E41333333F34DCD5941000000009E001E41CDCCCCAC38CD59419A999999B1001E41CDCCCCEC2CCD594100000000EA001E41666666461ACD59419A999999E1001E41000000600CCD5941666666667C001E41000000C0EFCC59410000000074001E4100000060E8CC59410000000080001E419A9999D9B2CC59419A9999998D001E419A99993998CC594166666666C4001E41CDCCCC4C76CC5941CDCCCCCC0C011E41CDCCCC4C62CC59419A99999991011E41CDCCCC4C4DCC5941CDCCCCCC40021E419A9999F935CC59419A999999C9021E41CDCCCC6C28CC5941CDCCCCCC56031E416666664626CC59419A99999971041E41666666862ACC59410000000010051E413333335333CC59416666666698051E413333333339CC594166666666A0091E41CDCCCC4CCACB5941CDCCCCCC780A1E41000000E0CFCB594133333333150B1E4133333373BCCB594133333333D90B1E419A9999D9A0CB59419A999999470C1E41666666C680CB5941CDCCCCCCCC0C1E416666666661CB5941000000008E0D1E413333331330CB5941CDCCCCCC8C0D1E419A9999992ACB5941CDCCCCCC420D1E41666666262DCB594100000000FA0C1E41CDCCCCCC2CCB594100000000D4081E416666660616CB59419A9999999D081E416666668615CB5941CDCCCCCC0C091E41666666C6F3CA5941CDCCCCCCAA071E41CDCCCCECEBCA5941333333336F061E41666666E6E6CA59416666666684051E41333333B3DCCA594166666666DE041E419A999979D2CA59419A999999BD031E41333333B3C3CA594166666666CE011E4100000060A8CA594133333333FB011E41000000C0A6CA594166666666DE011E41CDCCCC8C9ACA5941333333333B011E41CDCCCC8C8CCA5941666666669CFF1D419A9999D977CA5941666666665CFF1D419A99993979CA5941666666661AFF1D419A9999397FCA5941333333338DFE1D416666662688CA5941666666664CFD1D41666666C699CA59419A999999D7FC1D41666666C69ECA594166666666D4FB1D4166666646A6CA594100000000F6FA1D4133333313AACA59416666666612FA1D41CDCCCC0CA8CA5941CDCCCCCC38F91D41CDCCCC6CA3CA59419A99999901F71D41666666269CCA59419A999999ABF51D41CDCCCC0C9CCA594133333333C7F41D41666666E69CCA59413333333331F31D419A9999D99ACA59413333333337F21D419A9999F99ACA594166666666E0F01D41000000C088CA5941333333336FF01D413333337380CA59410000000008EF1D41666666A662CA5941666666667EED1D410000004043CA59410000000056EC1D41333333932CCA5941333333333DEC1D41666666A62BCA59419A99999985EA1D419A99999927CA594100000000CCE91D419A99997912CA5941CDCCCCCC34EA1D4166666646E7C9594100000000A2EA1D41CDCCCCCCD4C95941CDCCCCCC10EA1D419A9999D9D2C959419A999999C9E81D41CDCCCC4CC8C9594133333333F9E71D41CDCCCC4CC2C95941CDCCCCCC36E71D41000000A0B9C95941CDCCCCCC7AE51D41333333D3A0C959410000000094E41D413333333391C9594100000000A8E31D41333333F39EC95941CDCCCCCC8AE31D41333333B3A1C959413333333305E31D41000000E09DC9594133333333BBE21D419A9999B99DC9594166666666F4E11D4100000020A0C959419A999999D9E11D419A9999999EC959419A999999D5E11D41CDCCCC2C95C959413333333369E11D413333337393C959419A99999991E01D413333331394C959410000000022DF1D419A99991997C95941CDCCCCCCA6DE1D41000000609CC9594166666666F6DD1D4100000000ACC959419A999999E1DD1D41CDCCCCECC5C959416666666698DD1D41666666E6CCC95941CDCCCCCC5EDD1D41666666E6CDC95941000000004ADC1D41333333D3CAC9594100000000ACDB1D419A999939C4C95941CDCCCCCC6ADB1D41CDCCCC8CB7C959413333333333DB1D4100000000B1C9594100000000ECDA1D41CDCCCCECACC959419A9999998BD91D41333333B3A3C9594100000000F8D81D416666668699C959419A9999999DD81D419A999959A0C9594100000000D8D61D4166666646BDC959419A999999C3D11D41000000E00BCA5941CDCCCCCCE2CF1D419A9999592CCA594133333333E1CE1D41333333133BCA59410000000078CE1D41333333934CCA5941CDCCCCCCDACD1D410000004057CA59416666666684CC1D41666666C675CA594100000000A4CB1D419A99997980CA594100000000E4CC1D41666666669ACA59419A999999E1CD1D419A9999D9B0CA5941CDCCCCCC72CE1D4100000020BBCA59410000000094CF1D419A999959C9CA5941CDCCCCCC48D11D41000000C0DDCA5941CDCCCCCCCAD21D41CDCCCCACEDCA5941333333333DD51D41666666C606CB594166666666C4D71D41CDCCCC0C25CB59419A99999933D91D419A99995939CB594100000000D2DA1D41000000E052CB594166666666EADB1D41333333735CCB594133333333FFDC1D419A99995962CB59413333333375DE1D41000000206CCB59410000000008DF1D41CDCCCCEC72CB594100000000A8DF1D41000000C077CB59419A99999929E11D419A9999598CCB5941000000001EE21D419A9999599FCB594100000000D6E21D4133333393B5CB59419A9999995DE31D4166666686CFCB5941CDCCCCCCC8E31D419A9999F9FACB59413333333313E41D413333331311CC594133333333F7E31D419A99993923CC59419A9999999BE31D419A99995935CC59410000000060E31D419A9999B93BCC594166666666F6E21D41CDCCCC4C43CC594133333333EFE11D419A99997950CC5941CDCCCCCC68E11D419A99999958CC59416666666688E01D41CDCCCC4C6BCC594166666666FCDF1D41CDCCCC4C7ACC594133333333A7DF1D416666666687CC59419A99999953DF1D41CDCCCCCC98CC594166666666DEDE1D41CDCCCC2CBDCC59413333333373DE1D4166666686D1CC59410000000038DE1D419A9999B9D9CC594100000000BEDD1D41CDCCCC6CEFCC5941CDCCCCCC52DD1D413333331305CD594133333333C9DC1D41CDCCCCAC1ACD594166666666B2DB1D419A99995949CD5941666666662EDB1D41666666A664CD59413333333381DA1D419A99997982CD5941666666666CDA1D413333335387CD5941666666666CDA1D413333335387CD5941	01010000206A0800007C292D673FF31D41666666362BCC5941	720080102	H	Bourg et Écarts	7200801	72008	72	52	10
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	01010000206A0800008EFDE02D907F1C41666666C6E1BD5941	720090000	Z	Arthezé	7200900	72009	72	52	9
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	01010000206A08000000AC0C90B9EC1B41CDCCCCECC9C85941	720100000	Z	Asnières-sur-Vègre	7201000	72010	72	52	13
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	01010000206A08000078B58478022F1D4100000020CBF65941	720110000	Z	Assé-le-Boisne	7201100	72011	72	52	29
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	01010000206A080000E422091B837F1D419A999989EDE95941	720120000	Z	Assé-le-Riboul	7201200	72012	72	52	17
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	01010000206A08000004ED85994B281E419A9999D942B15941	720130000	Z	Aubigné-Racan	7201300	72013	72	52	32
01060000206A0800000100000001030000000100000040030000CDCCCCCCA4971E419A9999B938025A4133333333C7971E41CDCCCC8C39025A41CDCCCCCC26981E41666666C63B025A419A99999971981E41000000403D025A419A999999B5981E41666666263E025A41CDCCCCCC04991E41000000E03E025A41333333334F991E41666666A63F025A41CDCCCCCC86991E41666666C640025A41CDCCCCCCB0991E41333333F341025A41CDCCCCCCDA991E419A9999D943025A4100000000309A1E41CDCCCCCC47025A4166666666769A1E419A9999794B025A4133333333AB9A1E419A9999794D025A419A999999F59A1E410000008050025A419A999999599B1E416666668654025A4100000000C89B1E41666666E659025A41000000001E9C1E419A9999D95D025A41CDCCCCCC629C1E419A99997960025A4166666666B69C1E41000000E062025A419A999999159D1E416666664665025A4133333333419D1E41CDCCCC4C66025A419A999999739D1E41CDCCCC2C67025A419A999999819D1E413333333367025A419A999999959D1E413333333367025A41CDCCCCCCAE9D1E41CDCCCC0C67025A419A999999C19D1E416666668666025A4100000000DA9D1E416666666665025A419A999999FB9D1E41CDCCCC2C64025A4100000000129E1E410000002063025A4166666666249E1E410000006062025A41000000003A9E1E41CDCCCC4C62025A4166666666549E1E410000006063025A419A999999F59E1E41CDCCCCAC6C025A419A999999B99E1E41CDCCCC2C6E025A419A9999992B9F1E41CDCCCC2C77025A41CDCCCCCC9A9F1E41666666E67D025A41CDCCCCCCD69F1E41000000007F025A419A999999C99F1E41333333B380025A4133333333ADA01E41333333F38C025A410000000026A11E410000000095025A4166666666F0A11E41000000A0A4025A413333333325A61E41666666C6C6025A41CDCCCCCCE2A51E419A9999B9CD025A4166666666B8A51E41000000E0D4025A41666666669EA51E4100000060D9025A416666666692A51E41CDCCCC6CDB025A410000000022A61E4100000060E0025A410000000044A61E41CDCCCC8CE1025A410000000064A61E4166666646DF025A4100000000B0A61E4166666686E3025A41CDCCCCCC14A71E4100000060E9025A41CDCCCCCC68A71E41CDCCCC8CEE025A41CDCCCCCCCAA71E419A999999F4025A4133333333E3A71E4166666626F9025A419A999999F1A71E4133333373FC025A413333333349A81E41333333D301035A419A9999997BA81E41000000A004035A416666666644A91E410000008012035A419A999999B5A91E41CDCCCCCC1A035A41CDCCCCCC12AA1E41666666A621035A41CDCCCCCCF0A91E416666664627035A4133333333ABA91E41333333532D035A41CDCCCCCC8CA91E419A9999F92F035A419A99999935A91E413333335339035A4100000000AAA91E419A9999F93F035A419A99999919AA1E41666666C645035A41000000005AAA1E410000006042035A4100000000A8AA1E41CDCCCC6C3F035A413333333303AB1E41CDCCCCEC3C035A413333333341AB1E41000000603B035A419A9999997DAB1E41333333133A035A4166666666D0AB1E416666666637035A41666666662CAC1E419A9999F93B035A41333333336FAC1E41333333733B035A41666666669CAC1E41CDCCCCAC38035A41333333333DAD1E41666666062F035A413333333367AD1E419A99999935035A41666666668EAD1E419A9999B936035A416666666676AE1E419A9999B932035A416666666692AE1E41666666A639035A419A999999B1AE1E41666666264A035A4166666666B2AE1E41CDCCCC6C4B035A4133333333B9AE1E416666662654035A419A999999B3AE1E41666666265D035A4166666666AAAE1E41666666E65F035A416666666696AE1E41333333B362035A410000000072AE1E419A9999D965035A413333333355AE1E41666666C667035A410000000044AE1E410000006069035A419A9999993FAE1E41666666066A035A41333333333DAE1E41666666866B035A416666666642AE1E419A9999B96E035A410000000054AE1E416666666672035A4133333333AFAE1E419A9999F982035A4100000000BEAE1E419A99995985035A41000000005CAF1E413333333382035A41CDCCCCCC98B01E419A9999B981035A416666666606B21E413333331387035A41333333330FB21E41CDCCCC4C8C035A413333333319B21E41CDCCCC0C92035A419A9999991BB21E41000000A093035A419A99999929B21E41333333339A035A416666666638B21E419A9999199E035A41CDCCCCCC4EB21E4166666646A2035A41CDCCCCCC68B21E41CDCCCC4CA6035A419A999999ABB21E41000000C0AD035A4100000000D0B21E4133333353B1035A419A999999F3B21E419A9999D9AF035A416666666604B31E4133333333AF035A41CDCCCCCC2AB31E41000000C0AD035A41333333336DB31E41333333B3AB035A4133333333C5B31E4133333353A9035A419A9999990BB41E41666666A6A7035A413333333351B41E41CDCCCC6CA6035A4133333333A3B41E4133333393A5035A410000000018B51E41333333B3A4035A4166666666CEB51E4133333373A3035A413333333321B61E41CDCCCC2CA3035A413333333339B61E4133333313B0035A41666666664EB61E41000000A0B6035A419A9999995BB61E41000000A0B9035A410000000082B61E419A999999C1035A4166666666DAB61E4133333333CE035A416666666666B71E41CDCCCCACD9035A41CDCCCCCC0CB81E41CDCCCC0CE4035A419A999999BDB81E41333333D3E8035A419A9999994BB91E41000000A0ED035A419A999999DFB91E419A999959F3035A41CDCCCCCC64BA1E41000000A0F5035A416666666626BB1E41000000E0F5035A4133333333ADBB1E4100000080F6035A419A999999E9BB1E41000000C0F7035A413333333341BC1E419A999979FD035A4166666666EABC1E41333333F308045A41666666667CBD1E413333331312045A41CDCCCCCC2ABE1E41666666861D045A4133333333BFBE1E419A9999D926045A416666666608BF1E41666666062E045A41000000002EBF1E410000000033045A416666666632BF1E41333333F333045A410000000056BF1E410000002037045A410000000098BF1E41CDCCCC4C3E045A41CDCCCCCCBCBF1E419A99993942045A4133333333F5BF1E416666660647045A410000000014C01E41666666C648045A41CDCCCCCC1CC01E416666664649045A413333333359C01E41333333934B045A4133333333A7C01E41333333934E045A41666666665CC11E413333339355045A419A9999998FC11E41666666C650045A416666666698C11E41333333F34F045A4166666666C6C11E41666666A651045A41CDCCCCCC7AC21E410000006058045A41CDCCCCCCE6C21E41000000605E045A41CDCCCCCC06C31E41CDCCCC2C60045A413333333305C31E419A99995962045A416666666604C31E410000008064045A410000000006C31E41CDCCCC4C67045A41CDCCCCCC08C31E413333339369045A410000000014C31E41CDCCCC8C6C045A419A99999925C31E41CDCCCC6C6F045A416666666600C41E41CDCCCCCC73045A410000000022C41E41000000A076045A41CDCCCCCC4AC41E41000000007A045A416666666672C41E41666666A67D045A410000000086C41E416666664681045A413333333395C41E410000006086045A41CDCCCCCC8CC41E41000000808A045A41CDCCCCCC7AC41E41666666A68F045A41CDCCCCCC6CC41E419A9999D992045A41000000006CC41E41CDCCCC0C93045A419A9999995FC41E41333333F395045A41000000002EC41E41666666E696045A4100000000F8C31E419A99993998045A41CDCCCCCCC6C31E419A9999399A045A41000000009AC31E41666666469C045A413333333375C31E41666666669E045A413333333343C31E419A999979A2045A41333333332BC31E4100000020A4045A419A99999915C31E419A999919A5045A41CDCCCCCCFCC21E4166666686A5045A4133333333FBC21E4100000080A5045A41CDCCCCCCE4C21E4100000080A5045A4133333333DFC21E41CDCCCCCCA7045A419A999999FDC21E419A999939AA045A416666666660C31E41000000C0B4045A413333333399C31E41CDCCCC8CB9045A419A999999DFC31E419A9999D9C0045A419A999999FDC31E419A9999F9C4045A413333333369C41E4133333373D7045A419A99999971C41E41CDCCCC2CDA045A41666666667EC41E41CDCCCCCCDF045A41CDCCCCCC84C41E4100000020E7045A41666666668AC41E419A999979EE045A41000000008EC41E41666666A6F0045A416666666698C41E41666666C6F2045A4100000000AEC41E419A999979F7045A4100000000B4C41E4100000000FA045A4166666666AEC41E41CDCCCC2CFC045A4100000000A8C41E41CDCCCCCCFF045A41CDCCCCCCAEC41E41000000E000055A4166666666B8C41E410000006002055A419A999999CDC41E416666660604055A41CDCCCCCCD8C41E41000000C004055A4100000000E4C41E419A99997905055A4133333333E7C41E41CDCCCCAC05055A41CDCCCCCC14C51E416666660607055A41CDCCCCCC42C51E413333339308055A419A9999996DC51E41333333130A055A41CDCCCCCC7AC51E419A9999590B055A41CDCCCCCC80C51E41333333F30B055A410000000096C51E41666666060E055A416666666694C51E41CDCCCCAC0F055A41CDCCCCCC90C51E419A9999D914055A416666666690C51E410000004017055A41CDCCCCCCA4C51E41666666E61A055A41CDCCCCCCDCC51E419A9999791C055A410000000036C61E419A9999791D055A41666666669AC61E41000000A01D055A419A999999EDC61E41CDCCCC8C1B055A413333333333C71E410000006018055A413333333359C71E419A99991916055A41CDCCCCCC8EC71E41CDCCCC2C16055A4133333333B9C71E413333337318055A41CDCCCCCCC2C71E41666666C61F055A41CDCCCCCCE6C71E41CDCCCC0C22055A419A999999EDC71E41CDCCCC6C22055A413333333325C81E410000006022055A419A99999949C81E41666666861E055A419A9999996FC81E413333337319055A419A9999999DC81E419A99991915055A41CDCCCCCCD6C81E413333335312055A41CDCCCCCC20C91E41666666A611055A410000000050C91E41CDCCCCEC11055A416666666682C91E41666666E611055A419A999999A1C91E419A9999F910055A4133333333C5C91E41000000000F055A419A999999CFC91E41000000000C055A4100000000BCC91E41CDCCCCEC08055A41CDCCCCCC92C91E41666666A605055A413333333381C91E41666666A603055A41CDCCCCCC80C91E419A99995901055A419A9999999FC91E41000000E0FD045A410000000000CA1E41000000C0F5045A410000000030CA1E41CDCCCC2CF3045A41000000005ECA1E41CDCCCC0CF2045A419A99999997CA1E419A9999D9F1045A4133333333CDCA1E41CDCCCC6CF2045A419A999999DDCA1E41666666E6F2045A41333333331BCB1E41666666C6F8045A419A9999994BCB1E4100000000FA045A410000000082CB1E41CDCCCC2CF8045A4100000000BCCB1E41CDCCCC0CF5045A419A999999E3CB1E41CDCCCC4CF2045A41CDCCCCCC24CC1E4166666626EF045A410000000064CC1E41666666A6EC045A41000000008ACC1E4166666666EA045A419A9999999BCC1E419A9999B9E7045A4166666666A8CC1E4100000060E4045A419A999999B3CC1E41000000A0E0045A4100000000C8CC1E41CDCCCC6CDD045A41CDCCCCCCE6CC1E4100000040DA045A4100000000EACC1E419A9999D9D8045A4166666666E6CC1E4133333373D6045A4166666666D8CC1E41000000A0D1045A4133333333B7CC1E41666666C6CC045A4166666666B6CC1E41666666A6CB045A4100000000C0CC1E4100000080CA045A4100000000D6CC1E419A9999D9C9045A4166666666F2CC1E419A9999D9C9045A419A9999990DCD1E419A9999D9CA045A41666666663CCD1E419A999959CD045A416666666656CD1E41CDCCCCCCCD045A41CDCCCCCC76CD1E4166666606CD045A419A9999997FCD1E4166666606CC045A416666666680CD1E41333333B3CA045A41333333337FCD1E41CDCCCC6CC9045A4100000000A2CD1E41CDCCCCACBF045A410000000058CE1E4133333313B7045A410000000096CE1E41CDCCCC4CB4045A419A999999DBCE1E41000000C0B1045A4133333333EFCE1E41CDCCCC8CAE045A4166666666EECE1E4166666666AD045A4100000000E2CE1E4133333373AC045A4133333333C7CE1E4100000060AB045A419A99999965CE1E419A999919A8045A419A99999961CE1E4166666666A6045A413333333367CE1E41666666C6A4045A419A99999973CE1E41000000A0A2045A419A9999998DCE1E4166666606A1045A4166666666A0CE1E41CDCCCC4C97045A410000000084CE1E41000000C091045A41333333332DCE1E41666666068B045A41333333333DCE1E413333331388045A416666666676CE1E419A99995987045A41666666660CCF1E41666666E681045A413333333329CF1E41000000807E045A413333333343CF1E419A9999F97B045A41CDCCCCCC64CF1E410000000068045A419A999999CBCF1E410000002068045A41CDCCCCCC12D01E41CDCCCCCC75045A41333333333FD01E41CDCCCC4C76045A41666666663ED01E41CDCCCC8C70045A416666666652D01E410000002069045A41666666668ED01E419A99991969045A41CDCCCCCCDED01E41CDCCCC0C6E045A41CDCCCCCCE4D01E419A9999396E045A41CDCCCCCC24D11E413333331370045A41666666666AD11E41333333536D045A413333333371D11E410000006062045A4100000000EED11E41CDCCCC8C5F045A416666666686D21E41000000C05E045A41CDCCCCCC38D31E41000000A050045A4100000000AED31E41333333F34B045A4100000000DED31E416666666644045A413333333397D41E419A9999993F045A410000000076D41E419A9999B93D045A41000000001AD41E41666666A63A045A41CDCCCCCCB4D31E41000000202B045A413333333325D31E41000000001D045A410000000054D31E416666662619045A419A9999999BD31E416666662616045A41CDCCCCCC24D41E41000000001C045A413333333383D41E41CDCCCCAC1D045A419A999999A9D41E41CDCCCCAC19045A4100000000B4D41E416666664614045A419A999999D1D41E41333333930F045A413333333341D41E41CDCCCCEC0D045A41CDCCCCCC4ED41E41333333730A045A413333333393D41E410000002007045A4133333333F7D41E413333333306045A410000000012D51E419A999959FE035A41CDCCCCCC64D51E41333333D3F9035A4100000000F4D51E419A9999D9F3035A41000000001AD61E4166666626EB035A41333333331BD61E41CDCCCC0CE0035A41CDCCCCCC0CD61E41CDCCCCCCD9035A4133333333A9D51E419A999999DB035A419A999999F1D41E41666666E6DC035A41666666667CD41E4166666686D5035A416666666644D41E4100000040D2035A419A99999959D41E419A999959CD035A410000000040D51E41666666A6CA035A416666666678D51E4133333393C6035A419A9999994DD51E41CDCCCC2CC3035A41666666662ED51E41666666C6BF035A41000000000AD51E419A999959BE035A419A999999C9D41E41000000A0B7035A4100000000A4D41E4133333393B2035A419A99999987D41E4166666666AF035A413333333363D41E41CDCCCC6CAD035A413333333349D41E4133333353AA035A41666666664AD41E41CDCCCC8CA8035A41666666666ED41E41CDCCCCECA4035A41666666667CD41E4133333393A3035A416666666662D51E41333333D39C035A4166666666E8D51E41CDCCCCCC98035A410000000006D61E41333333938F035A41666666662CD61E41CDCCCC8C8B035A41CDCCCCCC2ED61E41000000C087035A41666666663ED61E413333339383035A413333333349D61E41CDCCCCCC80035A419A999999EFD51E41333333137A035A41CDCCCCCCA4D51E41666666C674035A413333333329D61E41666666266F035A41CDCCCCCC9CD61E419A9999D964035A4133333333C5D61E419A9999395D035A410000000060D61E41CDCCCCAC52035A413333333375D61E41666666A64D035A41CDCCCCCCC2D61E413333337346035A41CDCCCCCC22D71E41333333B340035A410000000060D71E419A99993942035A41CDCCCCCCD4D71E419A9999F945035A4166666666DCD71E419A9999B93F035A419A999999B3D71E41000000E031035A4133333333FBD71E41333333332E035A413333333357D81E41666666862F035A4166666666B2D81E41333333132D035A4133333333E3D81E41000000E024035A41CDCCCCCC00D91E413333331322035A419A99999911D91E41CDCCCC6C20035A413333333319D91E41666666E61D035A419A99999917D91E41CDCCCCCC1B035A416666666608D91E416666666618035A41CDCCCCCCD6D81E41CDCCCC8C12035A4133333333B5D81E419A9999B911035A410000000088D81E41000000A011035A413333333353D81E41CDCCCC4C12035A416666666622D81E416666668612035A4100000000F8D71E41000000C011035A4100000000E4D71E41666666C610035A41CDCCCCCCE0D71E41CDCCCC6C0F035A4133333333E5D71E41CDCCCC0C0E035A4133333333FDD71E41000000200D035A416666666616D81E41CDCCCCEC0C035A41CDCCCCCC30D81E41666666660D035A416666666644D81E41CDCCCCEC0D035A41CDCCCCCC54D81E41CDCCCC6C0D035A41333333335FD81E41000000200C035A41666666666CD81E419A9999F908035A413333333397D81E41000000E005035A4133333333CBD81E410000006003035A4166666666D2D81E419A99991902035A41CDCCCCCCCED81E419A9999B900035A419A9999998FD81E4133333393FE025A41CDCCCCCC7AD81E419A9999D9FB025A4133333333B5D71E41CDCCCC0CF6025A419A99999915D81E41CDCCCC2CF2025A413333333357D81E4166666666EB025A4133333333E5D71E4100000020E7025A416666666626D81E419A999919DF025A419A9999992FD81E41CDCCCCECD1025A41CDCCCCCCB6D71E41666666A6C5025A4133333333BBD71E4133333353BD025A413333333317D81E4100000060B5025A410000000004D81E4100000040B5025A4166666666F2D71E419A9999B9B5025A4166666666AED71E4166666686B7025A41333333330FD71E419A9999F9BB025A413333333383D61E4166666646C0025A419A999999FFD51E419A999999C3025A41666666668AD51E4133333313C7025A41666666667AD51E41000000A0C7025A413333333373D51E41333333B3C7025A419A9999996DD51E4166666686C7025A41000000006AD51E4166666626C7025A413333333365D51E4100000040C6025A416666666658D51E41333333F3C3025A419A99999949D51E41CDCCCC6CC1025A41CDCCCCCC40D51E41333333F3BF025A41000000003ED51E41000000C0BE025A41000000003ED51E41000000A0BD025A410000000040D51E41CDCCCC2CBC025A41CDCCCCCC40D51E41CDCCCCECBB025A413333333345D51E41000000E0BA025A41CDCCCCCC4ED51E419A999939B9025A41000000005ED51E4166666646B7025A41333333337BD51E41CDCCCC2CB4025A416666666690D51E4166666606B2025A419A999999A3D51E4166666626B0025A41CDCCCCCCAED51E41CDCCCC2CAF025A4100000000B4D51E4133333353AE025A419A999999B3D51E419A999939AD025A4100000000B0D51E419A9999F9AB025A4133333333A1D51E4166666626A7025A41CDCCCCCC92D51E419A999939A2025A41CDCCCCCC86D51E41CDCCCC6C9E025A416666666684D51E419A9999F99D025A419A9999997DD51E41333333B39B025A413333333373D51E416666666699025A413333333365D51E416666662697025A41CDCCCCCC5AD51E41666666C695025A41CDCCCCCC52D51E41333333B394025A41333333333BD51E413333333392025A41000000001ED51E41333333B38F025A41CDCCCCCCF8D41E41666666C68C025A4166666666C2D41E41000000E088025A416666666688D41E416666660685025A416666666656D41E41CDCCCC8C81025A419A99999937D41E41000000C07F025A41000000001AD41E41666666267E025A4166666666FED31E41000000407D025A4100000000DAD31E41666666067D025A4100000000B6D31E41000000407D025A41666666669AD31E419A9999D97D025A416666666684D31E41333333937E025A41333333336FD31E41CDCCCC0C7F025A416666666654D31E41CDCCCC4C7F025A41000000002CD31E41666666667F025A413333333309D31E41CDCCCC6C7F025A419A999999E7D21E41666666667F025A4166666666D8D21E41CDCCCC4C7F025A41CDCCCCCCCAD21E41CDCCCC0C7F025A4100000000C2D21E41CDCCCCAC7E025A4100000000BCD21E41000000407E025A4100000000B6D21E41000000607D025A41CDCCCCCCAED21E41CDCCCC6C7C025A413333333397D21E41666666467B025A41333333335FD21E41333333F378025A41CDCCCCCC1AD21E416666660677025A41CDCCCCCCDED11E41CDCCCC6C75025A4100000000A6D11E41CDCCCC0C74025A41CDCCCCCC76D11E41000000A072025A41666666664ED11E413333337371025A413333333335D11E41000000C070025A419A9999991FD11E41000000E06F025A41000000000CD11E41000000E06E025A4100000000F8D01E41333333136E025A41CDCCCCCCDED01E41333333536D025A419A999999C9D01E419A9999996C025A4133333333B7D01E41CDCCCC0C6C025A416666666698D01E419A9999B96B025A416666666678D01E41CDCCCC8C6B025A413333333359D01E41CDCCCC2C6B025A410000000034D01E41333333936A025A416666666610D01E410000006069025A4100000000F2CF1E413333337368025A41CDCCCCCCE6CF1E416666660668025A4100000000E2CF1E41000000A067025A4133333333E1CF1E41CDCCCC0C67025A419A999999E7CF1E410000002066025A419A999999F1CF1E41000000E064025A41CDCCCCCCFCCF1E416666662663025A410000000004D01E413333339361025A413333333307D01E41CDCCCCCC5F025A416666666606D01E41CDCCCC2C5E025A413333333303D01E41CDCCCC6C5C025A41CDCCCCCCFACF1E410000008059025A4133333333EBCF1E413333335355025A4133333333D5CF1E419A99991950025A41333333339BCF1E41333333534F025A41000000007ACF1E419A9999994F025A41000000005ECF1E41000000C04F025A41CDCCCCCC4ACF1E41666666C64F025A419A9999993BCF1E41333333B34F025A41333333332DCF1E41000000604F025A419A99999923CF1E41000000E04E025A41CDCCCCCC1CCF1E419A9999594E025A416666666614CF1E41000000804D025A41CDCCCCCC0CCF1E41333333B34C025A413333333303CF1E41000000E04B025A4133333333F7CE1E41666666464B025A419A999999EDCE1E41666666264B025A419A999999DBCE1E41666666664B025A41CDCCCCCCC6CE1E41666666264C025A4133333333AFCE1E419A9999394D025A41CDCCCCCCA2CE1E41000000C04D025A41CDCCCCCC92CE1E41666666464E025A413333333381CE1E41666666E64E025A419A99999971CE1E41666666464F025A41CDCCCCCC60CE1E41000000404F025A419A99999947CE1E419A9999D94E025A41CDCCCCCC34CE1E41CDCCCCCC4E025A419A99999923CE1E41333333134F025A410000000014CE1E41CDCCCCAC4F025A413333333309CE1E41CDCCCC4C50025A4100000000FECD1E410000002051025A4100000000F0CD1E41000000C051025A4166666666D6CD1E419A99991952025A41CDCCCCCCB8CD1E41CDCCCC6C52025A41000000007CCD1E41CDCCCC8C53025A41CDCCCCCC46CD1E416666668654025A416666666608CD1E410000006055025A419A999999BDCC1E413333331356025A410000000076CC1E410000008056025A410000000038CC1E41CDCCCCCC56025A419A99999905CC1E416666664657025A41CDCCCCCCD0CB1E41CDCCCC0C58025A410000000096CB1E410000008059025A410000000050CB1E41CDCCCCAC5B025A41666666660CCB1E419A9999B95D025A41CDCCCCCCF8CA1E41333333335E025A4100000000ECCA1E41666666665E025A419A999999DFCA1E41000000605E025A4133333333D5CA1E419A9999195E025A4166666666CACA1E41CDCCCCAC5D025A41CDCCCCCCBACA1E41000000C05C025A4166666666ACCA1E41333333D35B025A41333333339BCA1E41000000E05A025A419A9999997DCA1E419A99999959025A41333333335BCA1E41CDCCCC4C58025A413333333321CA1E419A9999B955025A419A999999DDC91E41000000A052025A4100000000B8C91E41CDCCCCAC50025A41CDCCCCCC8AC91E419A9999994D025A41333333335DC91E416666668649025A416666666636C91E419A9999D945025A416666666614C91E416666668642025A416666666600C91E41CDCCCC0C41025A4133333333F9C81E410000004040025A4166666666F6C81E41333333333F025A4166666666B8C81E41000000403D025A410000000098C81E41CDCCCC0C3C025A41333333337DC81E419A9999F93A025A410000000058C81E416666660639025A416666666618C81E416666668635025A4100000000E8C71E41000000E032025A4133333333E1C71E410000008032025A4133333333D9C71E41CDCCCC0C32025A4100000000A8C71E41CDCCCC4C2F025A419A9999998BC71E41000000C02D025A413333333373C71E419A9999B92C025A41000000005AC71E41CDCCCCCC2B025A41333333333FC71E41CDCCCC0C2B025A410000000028C71E419A9999792A025A410000000008C71E41CDCCCCAC29025A41CDCCCCCCF2C61E416666660629025A4100000000D8C61E419A9999F927025A419A999999BDC61E419A9999D926025A4166666666A0C61E41CDCCCC8C25025A41CDCCCCCC82C61E413333335324025A41CDCCCCCC66C61E410000002023025A41333333334FC61E416666660622025A41CDCCCCCC3AC61E41CDCCCCCC20025A41CDCCCCCC2CC61E41000000E01F025A41CDCCCCCC22C61E41333333F31E025A41333333331BC61E41000000201E025A416666666612C61E41333333731D025A416666666602C61E419A9999B91C025A419A999999F1C51E41333333331C025A41CDCCCCCCE0C51E41333333B31B025A419A999999D5C51E41CDCCCC4C1B025A4166666666CCC51E41333333931A025A4133333333B3C51E41333333F317025A41CDCCCCCC9CC51E410000008015025A416666666696C51E41333333B314025A419A99999993C51E419A99995914025A41CDCCCCCC8AC51E41CDCCCC2C13025A41000000007AC51E41CDCCCCCC10025A41CDCCCCCC6CC51E41000000E00E025A413333333363C51E41333333530D025A41666666665EC51E41666666C60B025A41CDCCCCCC5CC51E41000000200A025A41CDCCCCCC5CC51E41333333F307025A41666666665CC51E416666662605025A419A9999995BC51E419A99999903025A410000000056C51E41333333F301025A41CDCCCCCC4AC51E41333333F300025A41333333332FC51E41CDCCCC8CFF015A413333333303C51E4133333353FD015A419A999999C9C41E41CDCCCCCCFA015A410000000078C41E41CDCCCCACF7015A4166666666B8C41E41000000E0E9015A4100000000B4C41E419A9999F9E5015A4100000000B6C41E4166666626E2015A41000000007AC41E4166666626E1015A416666666626C41E4133333353DE015A419A999999A1C31E41333333B3D8015A41CDCCCCCC68C31E419A9999F9D5015A419A99999921C31E41CDCCCC2CD0015A410000000012C31E4166666686CE015A410000000012C31E4166666646CD015A419A99999927C31E4166666646CB015A41333333333DC31E41CDCCCC2CC9015A416666666646C31E4166666646C7015A41CDCCCCCC16C31E4133333373C3015A4100000000DAC21E41000000C0BE015A413333333377C21E41CDCCCC0CBA015A413333333311C21E419A9999D9B1015A41CDCCCCCCBAC11E4133333353AA015A41333333339BC11E41000000E0A6015A416666666696C11E4100000020A4015A4100000000CAC11E41CDCCCCECA0015A41333333334DC11E416666666699015A416666666602C11E416666668696015A419A999999BFC01E4133333373A1015A416666666664C01E41CDCCCC6CAE015A41000000003EC01E419A999999B3015A41666666661EC01E4100000000B8015A41CDCCCCCCF2BF1E4100000020B7015A4100000000C4BF1E4100000040B6015A413333333357BF1E4100000040B4015A41CDCCCCCC22BF1E4133333353B3015A4166666666F0BE1E4100000080B2015A419A999999C3BE1E4166666606B2015A4133333333B5BE1E419A9999D9B1015A4133333333ADBE1E41000000A0B1015A419A999999A7BE1E41CDCCCC4CB1015A41CDCCCCCCA4BE1E41333333B3B0015A4100000000A6BE1E41000000E0AF015A4133333333A9BE1E41000000E0AE015A41CDCCCCCCAEBE1E419A9999F9AC015A4100000000B0BE1E4133333373AC015A41CDCCCCCCB4BE1E41666666C6AA015A41CDCCCCCCB8BE1E41666666E6A8015A4133333333BBBE1E41CDCCCCACA6015A4133333333BDBE1E4100000020A4015A419A999999BBBE1E41333333F3A1015A41CDCCCCCCB8BE1E419A9999399F015A41CDCCCCCCB4BE1E41333333939C015A41CDCCCCCCB0BE1E419A9999599A015A4166666666AABE1E41000000E097015A4100000000A2BE1E41CDCCCC2C95015A413333333395BE1E416666666692015A41CDCCCCCC86BE1E41000000C08F015A416666666678BE1E41666666668D015A41CDCCCCCC6ABE1E41000000A08B015A41CDCCCCCC52BE1E419A9999F988015A419A99999929BE1E419A9999F984015A419A99999903BE1E41CDCCCCEC81015A4133333333DFBD1E41000000E07E015A4100000000BCBD1E41666666E67B015A410000000098BD1E41000000A078015A41000000007ABD1E41666666E675015A41CDCCCCCC60BD1E410000006073015A419A9999994BBD1E416666662671015A419A99999939BD1E419A9999F96E015A41333333332BBD1E41333333536D015A413333333319BD1E41666666A66B015A419A99999905BD1E41000000406A015A4133333333E9BC1E41666666C668015A4100000000C6BC1E413333333367015A41CDCCCCCCB4BC1E419A99999966015A4166666666A2BC1E41CDCCCCEC65015A410000000072BC1E41CDCCCC2C64015A410000000038BC1E419A9999F961015A413333333309BC1E419A9999D95F015A41CDCCCCCCD4BB1E41333333935D015A4166666666A2BB1E41666666465B015A41000000006CBB1E41CDCCCCEC58015A419A99999947BB1E41CDCCCC8C57015A41333333331FBB1E413333333356015A41CDCCCCCC06BB1E41CDCCCC6C55015A4133333333F9BA1E41333333D354015A41CDCCCCCCF0BA1E413333335354015A4133333333EBBA1E413333337353015A4133333333E7BA1E416666664652015A41CDCCCCCCE2BA1E416666662651015A4166666666DEBA1E413333333350015A4133333333D7BA1E41333333334F015A4100000000CEBA1E41666666664E015A4166666666BCBA1E41CDCCCCAC4D015A419A999999A3BA1E41333333F34C015A413333333375BA1E41666666C64B015A41CDCCCCCC3ABA1E419A9999594A015A4100000000FAB91E419A9999B948015A41CDCCCCCCBCB91E419A9999F946015A416666666688B91E410000008045015A419A99999951B91E41CDCCCC0C44015A419A99999923B91E419A9999D942015A4100000000F6B81E41CDCCCCEC41015A419A999999E3B81E41333333D341015A4100000000CEB81E41CDCCCCAC41015A41CDCCCCCCA0B81E416666664642015A41000000006EB81E41CDCCCCCC42015A419A9999995BB81E41CDCCCC0C43015A41666666664AB81E416666662643015A41000000003AB81E419A99991943015A41CDCCCCCC28B81E419A9999F942015A419A99999915B81E41000000A042015A419A999999EBB71E413333339341015A410000000098B71E419A9999193F015A410000000072B71E41000000E03D015A416666666648B71E41CDCCCC8C3C015A416666666622B71E41333333533B015A41000000000EB71E41333333933A015A419A999999F9B61E410000008039015A4133333333E9B61E41CDCCCC8C38015A41CDCCCCCCD8B61E413333333337015A41CDCCCCCCCAB61E41CDCCCCAC35015A4133333333C1B61E41CDCCCC8C34015A4133333333ABB61E413333337333015A419A99999977B61E419A9999D934015A41333333333BB61E419A99993936015A4100000000E0B51E410000002038015A419A99999983B51E419A9999D939015A41CDCCCCCC38B51E41000000203B015A410000000004B51E41666666E63B015A4166666666DCB41E419A9999793C015A41CDCCCCCCB8B41E41333333D33C015A41666666669AB41E41666666063D015A410000000080B41E41333333133D015A419A99999969B41E41333333133D015A410000000054B41E419A9999F93C015A41666666663CB41E41000000C03C015A413333333327B41E419A9999793C015A41CDCCCCCC0EB41E41666666063C015A41CDCCCCCCF2B31E419A9999593B015A4166666666C8B31E41000000403A015A41CDCCCCCC60B31E41CDCCCC4C37015A419A999999C7B21E413333335333015A4166666666E6AF1E41000000C01F015A419A99999913AE1E41666666E613015A410000000046AB1E416666660603015A410000000010AA1E413333331304015A413333333335A91E419A99997904015A416666666606A91E413333339304015A41000000007CA81E419A9999F906015A419A9999993FA71E41CDCCCC2C12015A419A999999E1A61E41000000A019015A419A999999B9A61E41666666461D015A419A99999977A61E413333331325015A419A999999C7A51E41666666E63A015A419A999999F5A41E41666666E654015A419A999999C3A41E41CDCCCCEC59015A419A9999998FA41E41666666465E015A413333333361A41E419A99991961015A419A9999993BA41E419A9999F962015A41000000000CA41E41CDCCCCCC64015A4133333333CDA31E410000006066015A416666666670A31E41CDCCCC4C68015A41CDCCCCCC1AA31E41000000A069015A413333333303A31E41666666066A015A419A999999DDA21E41333333136C015A419A99999935A31E41000000A072015A413333333347A31E41CDCCCC4C74015A410000000050A31E419A99997976015A419A9999996BA31E410000006084015A410000000084A31E41000000808D015A41333333339DA31E41333333B396015A419A999999EFA21E413333337392015A41666666666CA21E419A9999F9A0015A41CDCCCCCC12A21E4100000000AD015A4100000000D8A11E419A999979B5015A416666666688A11E41000000E0B2015A41CDCCCCCC78A11E419A999959B2015A41333333330BA11E41333333B3AF015A4100000000E2A01E41CDCCCCACAE015A416666666682A01E41CDCCCC4CAA015A416666666624A01E41666666C6A6015A4133333333BB9F1E4133333313B2015A4100000000429F1E41CDCCCC8CC0015A4100000000C49E1E4166666686DA015A419A999999A19E1E4133333333DC015A41666666665A9E1E4133333393DF015A4166666666249E1E4133333353E1015A419A999999E39D1E4166666686E2015A4166666666AA9D1E41CDCCCC0CE4015A41000000006C9D1E41CDCCCCACE5015A41666666663A9D1E41000000E0E7015A419A999999079D1E41CDCCCC2CEA015A41CDCCCCCC7A9C1E41666666C6F3015A41CDCCCCCC349C1E41666666A6F8015A4100000000909B1E419A9999D903025A4100000000009B1E41333333B30D025A419A999999879A1E419A99995916025A41666666663A9A1E419A9999391B025A41666666660A9A1E41333333131D025A4100000000E0991E41000000401E025A41000000006A991E41666666A620025A41CDCCCCCCD0981E413333339323025A4100000000B6981E419A99991924025A41CDCCCCCC8E981E41333333F324025A41CDCCCCCC74981E410000008025025A413333333367981E419A99995926025A41CDCCCCCC52981E416666668628025A41666666662A981E41000000802D025A419A999999F9971E41CDCCCC0C32025A419A999999F1971E41333333B332025A4100000000D6971E410000002035025A41CDCCCCCCB4971E419A9999B937025A41CDCCCCCCA4971E419A9999B938025A41	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	01010000206A080000EEBA8F492EC11E419A99997915035A41	720150000	Z	Les Aulneaux	7201500	72015	72	52	8
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	01010000206A08000098615AE82A771B41000000F0B7CA5941	720160000	Z	Auvers-le-Hamon	7201600	72016	72	52	48
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	01010000206A080000B447E17ABFC11C41666666263CD45941	720170000	Z	Auvers-sous-Montfaucon	7201700	72017	72	52	8
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	01010000206A080000B496A2C4A9C11E410000003055F05941	720180000	Z	Avesnes-en-Saosnois	7201800	72018	72	52	6
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	01010000206A0800004F0FAE72B7DD1B41000000603ED15941	720190000	Z	Avessé	7201900	72019	72	52	19
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	01010000206A080000CAE72B5570152041CDCCCC2CC8EB5941	720200000	Z	Avezé	7202000	72020	72	52	21
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	01010000206A0800000EB52102793E1C41CCCCCC4C32C55941	720210000	Z	Avoise	7202100	72021	72	52	24
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	01010000206A08000095AC522F5C321C41666666D6A1BB5941	720220000	Z	Le Bailleul	7202200	72022	72	52	28
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	01010000206A080000770E4C72A3441E41666666566BE65941	720230000	Z	Ballon-Saint Mars	7202300	72023	72	52	32
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