SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep75;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep75 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep75','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep75','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep75','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep75"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A080000010000000103000000010000003300000000000000DAD7234100000060002E5A41CDCCCCCCECD7234100000020052E5A410000000060D82341666666C6202E5A41000000006FD8234133333333242E5A413333333380D823419A999919282E5A41CDCCCCCCEFD82341CDCCCC6C432E5A41CDCCCCCCF6D823419A999959452E5A410000000005D923419A9999D9482E5A41333333332CD92341CDCCCC2C492E5A41333333334AD9234133333373482E5A41CDCCCCCC69D9234133333373472E5A4133333333EBD92341000000203F2E5A41000000007ADA2341CDCCCC2C362E5A41CDCCCCCC2DDB2341666666E62A2E5A41CDCCCCCC59DC234166666606182E5A4166666666CFDC2341666666C6102E5A413333333385DD234100000060052E5A41CDCCCCCCD7DD2341CDCCCC8C002E5A4133333333E7DD2341CDCCCCACFF2D5A4100000000F3DD23419A9999F9FE2D5A41CDCCCCCCE9DD2341CDCCCC0CFE2D5A4166666666DEDD2341CDCCCCECFB2D5A4166666666D2DD2341CDCCCC8CF82D5A419A999999CBDD2341000000A0F62D5A4100000000B1DD23419A999979EF2D5A4100000000A2DD2341000000E0EB2D5A410000000097DD234100000000EA2D5A41000000005ADD234100000080D92D5A419A99999911DD234100000080C52D5A41666666660BDD2341CDCCCCCCC32D5A41CDCCCCCCEDDC234166666666BC2D5A4166666666E1DC234100000080B92D5A4166666666D2DC2341CDCCCCCCB52D5A419A999999C4DC234133333393B22D5A4166666666C3DC23419A999919B12D5A4133333333CDDC2341CDCCCC2CAE2D5A41333333339ADC234166666666B12D5A410000000044DB2341CDCCCC4CC62D5A413333333320DB23419A999979C82D5A419A999999B9DA2341CDCCCC2CCF2D5A41CDCCCCCC9ADA2341CDCCCC2CD12D5A41333333336BDA234133333353D42D5A416666666616DA23419A999979D92D5A4133333333B1D9234100000000E02D5A419A99999979D923419A9999F9E42D5A410000000038D9234133333353E92D5A41000000002AD923419A999919EB2D5A419A99999902D9234133333393ED2D5A413333333389D8234100000060F52D5A41666666665CD823419A999939F82D5A4100000000DAD7234100000060002E5A41	01060000206A080000010000000103000000010000001100000000000000DAD7234100000060002E5A413333333380D823419A999919282E5A410000000005D923419A9999D9482E5A41CDCCCCCC69D9234133333373472E5A4133333333EBD92341000000203F2E5A413333333385DD234100000060052E5A4100000000F3DD23419A9999F9FE2D5A4166666666DEDD2341CDCCCCECFB2D5A410000000097DD234100000000EA2D5A41666666660BDD2341CDCCCCCCC32D5A419A999999C4DC234133333393B22D5A4133333333CDDC2341CDCCCC2CAE2D5A413333333320DB23419A999979C82D5A4133333333B1D9234100000000E02D5A41000000002AD923419A999919EB2D5A4100000000DAD7234100000060002E5A4100000000DAD7234100000060002E5A41	01010000206A080000CECCCC4C0ADB2341CDCCCC3CFA2D5A41	751010105	D	Tuileries	7510101	75101	75	11	0
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	01060000206A0800000100000001030000000100000027000000333333338AD7234133333313EC2D5A4100000000DAD7234100000060002E5A41000000002AD923419A999919EB2D5A4133333333B1D9234100000000E02D5A413333333320DB23419A999979C82D5A41000000001EDD23419A999979A92D5A4100000000A0DD2341CDCCCCCCA42D5A4100000000A3DE2341333333B3992D5A410000000072DF2341CDCCCCEC8E2D5A4133333333F1DF2341333333F3882D5A410000000092E02341CDCCCC8C822D5A419A9999996FE12341CDCCCCCC7E2D5A41CDCCCCCC5BE22341CDCCCC4C792D5A4133333333DAE32341666666E66A2D5A41666666665BE4234166666626632D5A410000000081E6234166666666472D5A416666666621E62341666666462A2D5A41CDCCCCCC5EE523419A9999F9362D5A419A999999B6E42341666666063D2D5A41CDCCCCCC61E42341666666A63E2D5A419A9999994FE32341CDCCCCCC452D5A416666666629E32341666666C63D2D5A416666666658E42341666666660A2D5A41666666668FE4234100000040052D5A416666666639E52341CDCCCC8CF72C5A41333333330FE5234166666626F02C5A419A999999C2E42341000000A0F52C5A416666666616E423419A999919052D5A41CDCCCCCCD8E32341333333B30C2D5A41333333336CE32341CDCCCC4C1E2D5A419A99999933E323419A999959292D5A4133333333BFE22341CDCCCCAC382D5A4100000000BEE123419A999959542D5A416666666619E1234133333393662D5A419A9999995DE02341666666866F2D5A410000000068DD2341000000A08D2D5A410000000090DB23419A9999D9AD2D5A41333333338AD7234133333313EC2D5A41333333338AD7234133333313EC2D5A41	01010000206A080000372D894F67E123419A999929742D5A41	751010199	D	Seine et Berges	7510101	75101	75	11	0
01060000206A080000010000000103000000010000003E000000CDCCCCCC22E6234166666646952D5A416666666629E62341666666A6992D5A41666666662EE623419A9999599C2D5A410000000034E6234100000000A02D5A419A99999938E6234133333353A22D5A419A9999993EE623419A999959A32D5A41CDCCCCCC4CE62341CDCCCC4CA42D5A41CDCCCCCC74E62341CDCCCC2CA32D5A41CDCCCCCCAEE62341666666E6A12D5A4133333333B2E62341CDCCCCCCA12D5A419A999999BFE62341333333D3A62D5A41CDCCCCCCCDE6234166666626AC2D5A4133333333D8E6234166666606B02D5A4133333333DDE62341666666C6AF2D5A41CDCCCCCCE4E62341CDCCCC6CAF2D5A4133333333E8E62341333333B3B02D5A4166666666E9E6234133333313B12D5A4100000000EEE62341CDCCCCCCB22D5A416666666614E7234100000000C12D5A413333333327E72341CDCCCCECC72D5A416666666637E72341000000E0CD2D5A419A99999939E723419A9999B9CE2D5A41666666664AE72341000000E0D42D5A419A9999994DE72341CDCCCC0CD62D5A416666666656E7234100000000D92D5A41CDCCCCCC6CE72341000000C0E02D5A41CDCCCCCC71E7234133333313E32D5A416666666672E7234166666666E32D5A413333333372E7234133333313E42D5A413333333372E7234166666626E52D5A419A9999998EE72341333333B3EF2D5A419A999999ADE7234133333313FB2D5A4166666666A4E7234133333313FF2D5A410000000034E82341000000A0F82D5A41CDCCCCCCB3E82341666666A6F22D5A41CDCCCCCCBFE8234133333313F22D5A410000000099E823419A9999D9E42D5A41CDCCCCCC72E8234133333353D82D5A41CDCCCCCC4CE8234100000000CC2D5A413333333349E82341333333D3CA2D5A41333333330BE82341666666A6B62D5A416666666605E823419A9999B9B42D5A4166666666D2E72341333333B3A32D5A4100000000A8E72341666666E6952D5A419A9999997AE72341333333D3862D5A410000000038E72341333333B3702D5A41333333332AE72341666666266C2D5A410000000026E72341333333B36A2D5A41CDCCCCCC18E72341000000806B2D5A41CDCCCCCCCDE6234100000020702D5A419A999999C8E623419A999979702D5A419A999999B3E62341000000C0712D5A41CDCCCCCCB5E62341CDCCCCCC742D5A419A999999B4E6234133333373762D5A419A999999B2E6234166666646772D5A4133333333A8E62341000000007A2D5A41CDCCCCCC8AE6234166666626802D5A416666666683E6234166666606822D5A41333333337EE62341000000A0832D5A416666666663E6234133333353892D5A41333333335BE62341000000E0882D5A41CDCCCCCC22E6234166666646952D5A41	01060000206A0800000100000001030000000100000011000000CDCCCCCC22E6234166666646952D5A419A99999938E6234133333353A22D5A41CDCCCCCC4CE62341CDCCCC4CA42D5A4133333333B2E62341CDCCCCCCA12D5A4133333333D8E6234166666606B02D5A41CDCCCCCCE4E62341CDCCCC6CAF2D5A419A9999994DE72341CDCCCC0CD62D5A419A999999ADE7234133333313FB2D5A4166666666A4E7234133333313FF2D5A41CDCCCCCCBFE8234133333313F22D5A410000000026E72341333333B36A2D5A419A999999B3E62341000000C0712D5A419A999999B2E6234166666646772D5A416666666663E6234133333353892D5A41333333335BE62341000000E0882D5A41CDCCCCCC22E6234166666646952D5A41CDCCCCCC22E6234166666646952D5A41	01010000206A08000072B6E10D7FE72341000000B0B52D5A41	751010201	H	Les Halles 1	7510102	75101	75	11	0
01060000206A080000010000000103000000010000003300000033333333F5E123419A999959BE2D5A4133333333F6E123419A9999B9BE2D5A41CDCCCCCC13E223419A999959C92D5A413333333328E223419A999999D02D5A419A99999948E2234166666646CF2D5A410000000068E2234100000040CD2D5A4133333333C2E2234133333313C92D5A419A99999928E323419A999979C42D5A4100000000C8E32341666666E6BD2D5A41CDCCCCCCE5E32341333333B3BC2D5A419A9999993EE42341CDCCCC6CBA2D5A416666666664E423419A9999F9B82D5A41666666669BE42341000000C0B62D5A4100000000C3E423419A9999D9B52D5A410000000034E523419A9999B9B22D5A410000000042E5234133333353B22D5A419A9999994AE52341000000E0B12D5A41CDCCCCCC5BE52341666666C6B02D5A419A99999974E52341CDCCCC2CAF2D5A4100000000C0E5234100000040A82D5A4166666666CEE52341333333D3A62D5A41CDCCCCCCE8E5234133333333A12D5A419A99999910E623419A999979982D5A41CDCCCCCC22E6234166666646952D5A41333333335BE62341000000E0882D5A416666666663E6234133333353892D5A41333333337EE62341000000A0832D5A416666666683E6234166666606822D5A41CDCCCCCC8AE6234166666626802D5A4133333333A8E62341000000007A2D5A419A999999B2E6234166666646772D5A419A999999B4E6234133333373762D5A41CDCCCCCCB5E62341CDCCCCCC742D5A419A999999B3E62341000000C0712D5A413333333320E623419A9999F97A2D5A4166666666B2E52341000000E0812D5A41666666666AE5234133333353862D5A419A99999932E52341000000E0892D5A4166666666BDE4234133333353912D5A4100000000BAE4234166666686912D5A4166666666B8E42341000000A0912D5A4166666666B7E42341333333B3912D5A4100000000AEE4234100000040922D5A419A99999967E42341CDCCCC8C962D5A41CDCCCCCCCAE3234133333373A02D5A4100000000ADE3234133333353A22D5A41CDCCCCCC25E32341333333F3AA2D5A41CDCCCCCCEFE2234166666666AE2D5A413333333358E22341CDCCCC0CB82D5A41333333330DE223419A9999D9BC2D5A4133333333F5E123419A999959BE2D5A41	01060000206A080000010000000103000000010000001000000033333333F5E123419A999959BE2D5A413333333328E223419A999999D02D5A419A99999928E323419A999979C42D5A41CDCCCCCCE5E32341333333B3BC2D5A419A9999993EE42341CDCCCC6CBA2D5A41666666669BE42341000000C0B62D5A410000000042E5234133333353B22D5A419A99999974E52341CDCCCC2CAF2D5A4166666666CEE52341333333D3A62D5A41333333335BE62341000000E0882D5A416666666663E6234133333353892D5A419A999999B2E6234166666646772D5A419A999999B3E62341000000C0712D5A4100000000ADE3234133333353A22D5A4133333333F5E123419A999959BE2D5A4133333333F5E123419A999959BE2D5A41	01010000206A0800006484E0ACD7E42341333333D3A02D5A41	751010202	H	Les Halles 2	7510102	75101	75	11	0
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	01060000206A08000001000000010300000001000000200000009A999999F8E12341000000A0D22D5A41000000002CE2234133333393E82D5A410000000081E2234133333373062E5A4166666666BCE22341666666E6182E5A41CDCCCCCCD5E323419A9999B9FF2D5A41333333330BE42341333333D3F92D5A41CDCCCCCC46E4234133333373F62D5A419A9999992CE4234166666686EC2D5A41CDCCCCCCFCE323419A999939EC2D5A419A999999CAE32341CDCCCC2CE92D5A419A999999BAE3234133333373E42D5A419A999999D3E32341CDCCCCECDC2D5A419A999999EDE323419A999979DA2D5A4166666666C7E3234166666626D22D5A416666666669E4234133333333CB2D5A416666666688E4234100000080CA2D5A41000000002FE5234133333313C32D5A410000000092E52341CDCCCC6CBF2D5A4133333333D8E6234166666606B02D5A4133333333B2E62341CDCCCCCCA12D5A41CDCCCCCC4CE62341CDCCCC4CA42D5A419A99999938E6234133333353A22D5A41CDCCCCCC22E6234166666646952D5A4166666666CEE52341333333D3A62D5A419A99999974E52341CDCCCC2CAF2D5A410000000042E5234133333353B22D5A41666666669BE42341000000C0B62D5A419A9999993EE42341CDCCCC6CBA2D5A41CDCCCCCCE5E32341333333B3BC2D5A419A99999928E323419A999979C42D5A419A999999F8E12341000000A0D22D5A419A999999F8E12341000000A0D22D5A41	01010000206A080000EB071D15F2E22341000000B0D62D5A41	751010203	H	Les Halles 3	7510102	75101	75	11	0
01060000206A080000010000000103000000010000003A000000333333330BE42341333333D3F92D5A410000000055E52341CDCCCC8C1A2E5A416666666657E52341333333731A2E5A41CDCCCCCC65E52341CDCCCCCC192E5A41333333336CE523419A999979192E5A41CDCCCCCC7EE52341000000A0182E5A41CDCCCCCC91E52341666666C6172E5A41CDCCCCCC4EE62341333333130F2E5A419A999999D5E62341333333B3082E5A41000000004AE7234100000060032E5A4166666666A4E7234133333313FF2D5A419A999999ADE7234133333313FB2D5A419A9999998EE72341333333B3EF2D5A413333333372E7234166666626E52D5A413333333372E7234133333313E42D5A416666666672E7234166666666E32D5A41CDCCCCCC71E7234133333313E32D5A41CDCCCCCC6CE72341000000C0E02D5A416666666656E7234100000000D92D5A419A9999994DE72341CDCCCC0CD62D5A419A99999949E723419A999939D62D5A419A999999F4E623419A9999F9D92D5A410000000089E62341CDCCCCCCDE2D5A41000000005CE62341666666C6E02D5A419A9999995AE623419A9999D9E02D5A41CDCCCCCC58E62341CDCCCCECE02D5A41CDCCCCCC4BE6234100000080E12D5A41333333333EE6234100000020E22D5A41CDCCCCCC3AE6234166666646E22D5A416666666639E6234133333353E22D5A416666666633E623419A999999E22D5A41000000002DE62341000000E0E22D5A41333333331FE6234100000080E32D5A41CDCCCCCC14E623419A9999F9E32D5A419A9999990CE6234100000040E42D5A419A999999ECE5234133333353E52D5A419A999999D6E5234133333313E62D5A4166666666CAE52341CDCCCC4CE72D5A4166666666C0E5234100000060E82D5A419A999999B5E52341CDCCCC8CE92D5A4133333333A4E5234133333353EB2D5A413333333386E5234100000080EB2D5A41666666666AE523419A9999B9EB2D5A413333333359E523419A9999D9EB2D5A41CDCCCCCC2DE52341333333B3ED2D5A4100000000EDE4234166666686F02D5A4133333333C7E42341000000A0F12D5A41CDCCCCCCC0E423419A999959F12D5A41CDCCCCCCB9E42341CDCCCC4CF12D5A419A999999B4E42341CDCCCC4CF12D5A4166666666B0E423419A999959F12D5A41CDCCCCCCACE4234166666686F12D5A419A99999991E42341333333D3F22D5A41CDCCCCCC7FE42341333333B3F32D5A416666666653E42341333333B3F52D5A41CDCCCCCC46E4234133333373F62D5A41000000002EE42341CDCCCCECF72D5A41333333330BE42341333333D3F92D5A41	01060000206A080000010000000103000000010000000D000000333333330BE42341333333D3F92D5A410000000055E52341CDCCCC8C1A2E5A4166666666A4E7234133333313FF2D5A419A999999ADE7234133333313FB2D5A419A9999994DE72341CDCCCC0CD62D5A41CDCCCCCC14E623419A9999F9E32D5A419A999999D6E5234133333313E62D5A4133333333A4E5234133333353EB2D5A413333333359E523419A9999D9EB2D5A4100000000EDE4234166666686F02D5A4166666666B0E423419A999959F12D5A41333333330BE42341333333D3F92D5A41333333330BE42341333333D3F92D5A41	01010000206A0800009BA2291AE2E52341000000E0F82D5A41	751010204	H	Les Halles 4	7510102	75101	75	11	0
01060000206A08000001000000010300000001000000630000009A999999BAE3234133333373E42D5A4166666666C0E32341CDCCCCCCE62D5A419A999999CAE32341CDCCCC2CE92D5A41CDCCCCCCCAE3234133333333E92D5A4166666666CBE32341CDCCCC2CE92D5A4166666666D6E3234133333373E92D5A4133333333E8E32341CDCCCC0CEB2D5A41CDCCCCCCFCE323419A999939EC2D5A416666666613E42341000000E0EC2D5A419A99999914E42341000000E0EC2D5A410000000026E42341000000C0EC2D5A41666666662AE423419A999999EC2D5A419A9999992CE4234166666686EC2D5A413333333333E42341000000C0EF2D5A41666666663DE42341666666C6F32D5A41000000003FE423419A999939F42D5A413333333342E42341CDCCCC2CF52D5A413333333343E423419A999999F52D5A41CDCCCCCC46E4234133333373F62D5A416666666653E42341333333B3F52D5A41CDCCCCCC7FE42341333333B3F32D5A419A99999991E42341333333D3F22D5A41CDCCCCCCACE4234166666686F12D5A4166666666B0E423419A999959F12D5A419A999999B4E42341CDCCCC4CF12D5A41CDCCCCCCB9E42341CDCCCC4CF12D5A41CDCCCCCCC0E423419A999959F12D5A4133333333C7E42341000000A0F12D5A4100000000EDE4234166666686F02D5A41CDCCCCCC2DE52341333333B3ED2D5A413333333359E523419A9999D9EB2D5A41666666666AE523419A9999B9EB2D5A413333333386E5234100000080EB2D5A4133333333A4E5234133333353EB2D5A419A999999B5E52341CDCCCC8CE92D5A4166666666C0E5234100000060E82D5A4166666666CAE52341CDCCCC4CE72D5A419A999999D6E5234133333313E62D5A419A999999ECE5234133333353E52D5A419A9999990CE6234100000040E42D5A41CDCCCCCC14E623419A9999F9E32D5A41333333331FE6234100000080E32D5A41000000002DE62341000000E0E22D5A416666666633E623419A999999E22D5A416666666639E6234133333353E22D5A41CDCCCCCC3AE6234166666646E22D5A41333333333EE6234100000020E22D5A41CDCCCCCC4BE6234100000080E12D5A41CDCCCCCC58E62341CDCCCCECE02D5A419A9999995AE623419A9999D9E02D5A41000000005CE62341666666C6E02D5A410000000089E62341CDCCCCCCDE2D5A419A999999F4E623419A9999F9D92D5A419A99999949E723419A999939D62D5A419A9999994DE72341CDCCCC0CD62D5A41666666664AE72341000000E0D42D5A419A99999939E723419A9999B9CE2D5A416666666637E72341000000E0CD2D5A413333333327E72341CDCCCCECC72D5A416666666614E7234100000000C12D5A4100000000EEE62341CDCCCCCCB22D5A4166666666E9E6234133333313B12D5A4133333333E8E62341333333B3B02D5A41CDCCCCCCE4E62341CDCCCC6CAF2D5A4133333333DDE62341666666C6AF2D5A4133333333D8E6234166666606B02D5A4166666666D1E6234100000060B02D5A4100000000C5E62341CDCCCCECB02D5A4133333333A7E6234100000060B22D5A419A99999989E62341CDCCCCCCB32D5A41CDCCCCCC51E623419A999979B62D5A413333333318E6234100000040B92D5A410000000092E52341CDCCCC6CBF2D5A41666666666EE52341333333B3C02D5A41CDCCCCCC4FE52341CDCCCCCCC12D5A41333333333DE5234100000020C22D5A41CDCCCCCC36E52341333333B3C22D5A41000000002FE5234133333313C32D5A4100000000ECE42341CDCCCC0CC62D5A416666666688E4234100000080CA2D5A410000000070E42341CDCCCC0CCB2D5A416666666669E4234133333333CB2D5A410000000010E4234166666606CF2D5A4166666666F2E3234133333353D02D5A4166666666C7E3234166666626D22D5A4166666666BBE32341CDCCCCACD32D5A4133333333CBE32341000000A0D32D5A4100000000DDE3234100000060D52D5A419A999999DFE32341CDCCCC2CD62D5A4100000000E3E3234133333333D72D5A419A999999EDE323419A999979DA2D5A4133333333E6E32341CDCCCCECDA2D5A419A999999DFE323419A999979DB2D5A419A999999D3E32341CDCCCCECDC2D5A41CDCCCCCCC9E3234166666666DF2D5A41CDCCCCCCC6E323419A999979E22D5A4100000000C5E32341CDCCCC2CE32D5A419A999999BFE32341666666E6E32D5A419A999999BAE3234133333373E42D5A41	01060000206A08000001000000010300000001000000160000009A999999BAE3234133333373E42D5A419A999999CAE32341CDCCCC2CE92D5A41CDCCCCCCFCE323419A999939EC2D5A419A9999992CE4234166666686EC2D5A41CDCCCCCC46E4234133333373F62D5A4166666666B0E423419A999959F12D5A4100000000EDE4234166666686F02D5A413333333359E523419A9999D9EB2D5A4133333333A4E5234133333353EB2D5A419A999999D6E5234133333313E62D5A41CDCCCCCC14E623419A9999F9E32D5A419A9999994DE72341CDCCCC0CD62D5A41CDCCCCCCE4E62341CDCCCC6CAF2D5A410000000092E52341CDCCCC6CBF2D5A41000000002FE5234133333313C32D5A416666666688E4234100000080CA2D5A416666666669E4234133333333CB2D5A4166666666C7E3234166666626D22D5A419A999999EDE323419A999979DA2D5A419A999999D3E32341CDCCCCECDC2D5A419A999999BAE3234133333373E42D5A419A999999BAE3234133333373E42D5A41	01010000206A080000EE4CA24883E52341333333E3D22D5A41	751010205	A	Les Halles 5	7510102	75101	75	11	0
01060000206A080000010000000103000000010000001700000066666666BCE22341666666E6182E5A4166666666DAE22341CDCCCC4C212E5A419A999999E1E2234166666646232E5A4100000000F1E2234166666666262E5A419A999999F3E22341000000E0262E5A419A9999990EE323419A9999192D2E5A416666666618E32341666666A62F2E5A410000000025E32341666666C6322E5A41333333332DE32341CDCCCCAC342E5A410000000041E32341333333B3332E5A416666666651E323419A9999D9322E5A41000000006AE32341666666A6312E5A4166666666BAE323419A9999B92D2E5A41CDCCCCCCF3E323419A9999F92A2E5A413333333340E42341000000A0272E5A41CDCCCCCCCEE42341666666E6202E5A410000000055E52341CDCCCC8C1A2E5A41333333330BE42341333333D3F92D5A4100000000FAE323419A9999B9FB2D5A41CDCCCCCCD5E323419A9999B9FF2D5A410000000084E3234166666606072E5A4133333333F6E223419A9999B9132E5A4166666666BCE22341666666E6182E5A41	01060000206A080000010000000103000000010000000900000066666666BCE22341666666E6182E5A419A999999E1E2234166666646232E5A41333333332DE32341CDCCCCAC342E5A41CDCCCCCCF3E323419A9999F92A2E5A410000000055E52341CDCCCC8C1A2E5A41333333330BE42341333333D3F92D5A41CDCCCCCCD5E323419A9999B9FF2D5A4166666666BCE22341666666E6182E5A4166666666BCE22341666666E6182E5A41	01010000206A0800009C9322CC01E4234100000050162E5A41	751010206	A	Les Halles 6	7510102	75101	75	11	0
01060000206A08000001000000010300000001000000300000003333333385DD234100000060052E5A4133333333DDDD2341666666261F2E5A41666666668ADE2341333333734E2E5A4133333333C3DE2341000000C05E2E5A4100000000DEDE2341333333D3662E5A410000000068DF234166666666602E5A4100000000B1DF2341000000005D2E5A419A999999C5DF2341CDCCCC0C5C2E5A41CDCCCCCC21E02341333333D3572E5A41000000006DE0234133333393542E5A410000000086E023419A999979532E5A4100000000FEE02341CDCCCC4C4E2E5A419A999999BAE1234166666686452E5A4166666666A9E12341CDCCCCAC3F2E5A419A999999E7E12341666666E63C2E5A41666666660EE22341333333333B2E5A41000000000EE22341CDCCCC0C3B2E5A419A999999DAE12341CDCCCC2C292E5A41000000006BE12341CDCCCC4C022E5A4133333333C9E12341CDCCCCECFD2D5A41CDCCCCCC3AE22341666666E6F82D5A410000000057E22341666666A6F72D5A41000000002CE2234133333393E82D5A41000000001DE22341000000C0E12D5A419A99999918E22341666666C6DF2D5A416666666601E2234133333313D62D5A419A999999F8E12341000000A0D22D5A41333333335FE1234100000080DA2D5A410000000005E1234100000020DF2D5A4100000000EAE0234166666606E12D5A4100000000DDE02341CDCCCCACE12D5A41CDCCCCCC7FE0234133333313E62D5A416666666677E0234133333373E62D5A419A99999965E0234100000040E72D5A410000000057E023419A9999F9E72D5A41333333331CE02341000000C0EA2D5A4133333333EEDF234100000040ED2D5A41CDCCCCCCE7DF23419A999979EE2D5A41666666667FDF2341CDCCCC6CF82D5A41CDCCCCCC6DDF23419A999919FA2D5A41666666662ADF2341CDCCCC8C002E5A41000000004CDE2341CDCCCC4C152E5A41000000000FDE234166666606062E5A41333333330ADE2341666666E6042E5A4100000000F3DD23419A9999F9FE2D5A4133333333E7DD2341CDCCCCACFF2D5A41CDCCCCCCD7DD2341CDCCCC8C002E5A413333333385DD234100000060052E5A41	01060000206A08000001000000010300000001000000150000003333333385DD234100000060052E5A4133333333DDDD2341666666261F2E5A41666666668ADE2341333333734E2E5A4100000000DEDE2341333333D3662E5A41CDCCCCCC21E02341333333D3572E5A4100000000FEE02341CDCCCC4C4E2E5A419A999999BAE1234166666686452E5A4166666666A9E12341CDCCCCAC3F2E5A41666666660EE22341333333333B2E5A41000000006BE12341CDCCCC4C022E5A410000000057E22341666666A6F72D5A41000000002CE2234133333393E82D5A419A999999F8E12341000000A0D22D5A410000000005E1234100000020DF2D5A4100000000DDE02341CDCCCCACE12D5A41333333331CE02341000000C0EA2D5A41CDCCCCCCE7DF23419A999979EE2D5A41000000004CDE2341CDCCCC4C152E5A4100000000F3DD23419A9999F9FE2D5A413333333385DD234100000060052E5A413333333385DD234100000060052E5A41	01010000206A080000286BAA08BEDF23419A9999391A2E5A41	751010301	H	Palais Royal 1	7510103	75101	75	11	0
01060000206A0800000100000001030000000100000021000000000000006BE12341CDCCCC4C022E5A419A999999DAE12341CDCCCC2C292E5A41000000000EE22341CDCCCC0C3B2E5A41666666660EE22341333333333B2E5A419A999999E7E12341666666E63C2E5A4166666666A9E12341CDCCCCAC3F2E5A419A999999BAE1234166666686452E5A41CDCCCCCCF4E12341CDCCCCCC422E5A410000000012E2234133333373412E5A41333333332BE2234166666646402E5A416666666653E22341333333733E2E5A419A9999995AE223419A9999193E2E5A4166666666C0E22341CDCCCCAC392E5A419A999999EAE22341CDCCCCCC372E5A4100000000FFE22341CDCCCCEC362E5A419A99999915E323419A9999D9352E5A41000000001DE323419A999979352E5A41333333332DE32341CDCCCCAC342E5A410000000025E32341666666C6322E5A416666666618E32341666666A62F2E5A419A9999990EE323419A9999192D2E5A419A999999F3E22341000000E0262E5A4100000000F1E2234166666666262E5A419A999999E1E2234166666646232E5A4166666666DAE22341CDCCCC4C212E5A4166666666BCE22341666666E6182E5A413333333395E22341CDCCCC2C0D2E5A410000000081E2234133333373062E5A413333333368E22341333333B3FD2D5A410000000057E22341666666A6F72D5A41CDCCCCCC3AE22341666666E6F82D5A4133333333C9E12341CDCCCCECFD2D5A41000000006BE12341CDCCCC4C022E5A41	01060000206A080000010000000103000000010000000A000000000000006BE12341CDCCCC4C022E5A41666666660EE22341333333333B2E5A4166666666A9E12341CDCCCCAC3F2E5A419A999999BAE1234166666686452E5A41333333332DE32341CDCCCCAC342E5A419A999999E1E2234166666646232E5A413333333395E22341CDCCCC2C0D2E5A410000000057E22341666666A6F72D5A41000000006BE12341CDCCCC4C022E5A41000000006BE12341CDCCCC4C022E5A41	01010000206A080000CE25FCAA41E223419A9999191D2E5A41	751010302	A	Palais Royal 2	7510103	75101	75	11	0
01060000206A080000010000000103000000010000002300000000000000F3DD23419A9999F9FE2D5A41333333330ADE2341666666E6042E5A41000000000FDE234166666606062E5A41000000004CDE2341CDCCCC4C152E5A41666666662ADF2341CDCCCC8C002E5A41CDCCCCCC6DDF23419A999919FA2D5A41666666667FDF2341CDCCCC6CF82D5A41CDCCCCCCE7DF23419A999979EE2D5A4133333333EEDF234100000040ED2D5A41333333331CE02341000000C0EA2D5A410000000057E023419A9999F9E72D5A419A99999965E0234100000040E72D5A416666666677E0234133333373E62D5A41CDCCCCCC7FE0234133333313E62D5A4100000000DDE02341CDCCCCACE12D5A4100000000EAE0234166666606E12D5A410000000005E1234100000020DF2D5A41333333335FE1234100000080DA2D5A419A999999F8E12341000000A0D22D5A41CDCCCCCC01E2234166666626D22D5A413333333328E223419A999999D02D5A41CDCCCCCC13E223419A999959C92D5A4133333333F6E123419A9999B9BE2D5A4133333333F5E123419A999959BE2D5A4133333333AEE0234100000000D32D5A419A99999982E02341000000C0D52D5A41CDCCCCCC4EE0234166666606D92D5A4166666666C8DF2341CDCCCCECE02D5A4100000000BFDF234100000080E12D5A41CDCCCCCCB5DF23419A999919E22D5A4133333333A3DF2341CDCCCC4CE32D5A4166666666EADE23419A999959EF2D5A41666666660DDE234133333353FD2D5A4133333333F6DD2341666666C6FE2D5A4100000000F3DD23419A9999F9FE2D5A41	01060000206A080000010000000103000000010000000D00000000000000F3DD23419A9999F9FE2D5A41000000004CDE2341CDCCCC4C152E5A41CDCCCCCCE7DF23419A999979EE2D5A41333333331CE02341000000C0EA2D5A4100000000DDE02341CDCCCCACE12D5A410000000005E1234100000020DF2D5A41CDCCCCCC01E2234166666626D22D5A413333333328E223419A999999D02D5A4133333333F5E123419A999959BE2D5A41CDCCCCCC4EE0234166666606D92D5A4166666666C8DF2341CDCCCCECE02D5A4100000000F3DD23419A9999F9FE2D5A4100000000F3DD23419A9999F9FE2D5A41	01010000206A0800006A3396E9BFDF2341CDCCCC5CE92D5A41	751010303	A	Palais Royal 3	7510103	75101	75	11	0
01060000206A08000001000000010300000001000000180000000000000005D923419A9999D9482E5A419A99999910D92341CDCCCCAC4B2E5A416666666616D92341333333334D2E5A4133333333ABD92341CDCCCC8C742E5A410000000068DA2341666666A6682E5A41CDCCCCCC98DA23419A9999D9652E5A41CDCCCCCC08DB2341CDCCCCCC5F2E5A41666666664FDB2341CDCCCCCC5A2E5A416666666682DB2341000000E0562E5A4133333333EDDB2341333333B34E2E5A4100000000D8DC23419A999999382E5A416666666639DD2341CDCCCC6C2F2E5A4166666666AADD234133333333242E5A4133333333DDDD2341666666261F2E5A413333333385DD234100000060052E5A4166666666CFDC2341666666C6102E5A41CDCCCCCC59DC234166666606182E5A41CDCCCCCC2DDB2341666666E62A2E5A41000000007ADA2341CDCCCC2C362E5A4133333333EBD92341000000203F2E5A41CDCCCCCC69D9234133333373472E5A41333333334AD9234133333373482E5A41333333332CD92341CDCCCC2C492E5A410000000005D923419A9999D9482E5A41	01060000206A08000001000000010300000001000000180000000000000005D923419A9999D9482E5A419A99999910D92341CDCCCCAC4B2E5A416666666616D92341333333334D2E5A4133333333ABD92341CDCCCC8C742E5A410000000068DA2341666666A6682E5A41CDCCCCCC98DA23419A9999D9652E5A41CDCCCCCC08DB2341CDCCCCCC5F2E5A41666666664FDB2341CDCCCCCC5A2E5A416666666682DB2341000000E0562E5A4133333333EDDB2341333333B34E2E5A4100000000D8DC23419A999999382E5A416666666639DD2341CDCCCC6C2F2E5A4166666666AADD234133333333242E5A4133333333DDDD2341666666261F2E5A413333333385DD234100000060052E5A4166666666CFDC2341666666C6102E5A41CDCCCCCC59DC234166666606182E5A41CDCCCCCC2DDB2341666666E62A2E5A41000000007ADA2341CDCCCC2C362E5A4133333333EBD92341000000203F2E5A41CDCCCCCC69D9234133333373472E5A41333333334AD9234133333373482E5A41333333332CD92341CDCCCC2C492E5A410000000005D923419A9999D9482E5A41	01010000206A08000058C3C54B6ADB2341CDCCCCDC3B2E5A41	751010401	H	Place Vendôme 1	7510104	75101	75	11	0
01060000206A080000010000000103000000010000001F00000033333333ABD92341CDCCCC8C742E5A410000000019DA23419A9999F9912E5A416666666603DA2341000000409D2E5A410000000022DA23419A9999199F2E5A410000000051DA2341000000C0A02E5A419A9999996DDA234133333393A12E5A4100000000CEDA2341CDCCCC8CA42E5A4100000000A4DB2341333333D3AA2E5A4133333333BCDB23419A9999B9A72E5A419A999999C8DB234133333313A62E5A413333333371DC2341666666468E2E5A4166666666D6DC23419A999979802E5A4133333333F0DC2341666666E67D2E5A41CDCCCCCC04DD2341666666467C2E5A419A99999960DD2341000000C0772E5A4133333333C3DD234166666686732E5A419A99999915DE2341666666C66F2E5A4100000000DEDE2341333333D3662E5A4133333333C3DE2341000000C05E2E5A41666666668ADE2341333333734E2E5A4133333333DDDD2341666666261F2E5A4166666666AADD234133333333242E5A416666666639DD2341CDCCCC6C2F2E5A4100000000D8DC23419A999999382E5A4133333333EDDB2341333333B34E2E5A416666666682DB2341000000E0562E5A41666666664FDB2341CDCCCCCC5A2E5A41CDCCCCCC08DB2341CDCCCCCC5F2E5A41CDCCCCCC98DA23419A9999D9652E5A410000000068DA2341666666A6682E5A4133333333ABD92341CDCCCC8C742E5A41	01060000206A080000010000000103000000010000001F00000033333333ABD92341CDCCCC8C742E5A410000000019DA23419A9999F9912E5A416666666603DA2341000000409D2E5A410000000022DA23419A9999199F2E5A410000000051DA2341000000C0A02E5A419A9999996DDA234133333393A12E5A4100000000CEDA2341CDCCCC8CA42E5A4100000000A4DB2341333333D3AA2E5A4133333333BCDB23419A9999B9A72E5A419A999999C8DB234133333313A62E5A413333333371DC2341666666468E2E5A4166666666D6DC23419A999979802E5A4133333333F0DC2341666666E67D2E5A41CDCCCCCC04DD2341666666467C2E5A419A99999960DD2341000000C0772E5A4133333333C3DD234166666686732E5A419A99999915DE2341666666C66F2E5A4100000000DEDE2341333333D3662E5A4133333333C3DE2341000000C05E2E5A41666666668ADE2341333333734E2E5A4133333333DDDD2341666666261F2E5A4166666666AADD234133333333242E5A416666666639DD2341CDCCCC6C2F2E5A4100000000D8DC23419A999999382E5A4133333333EDDB2341333333B34E2E5A416666666682DB2341000000E0562E5A41666666664FDB2341CDCCCCCC5A2E5A41CDCCCCCC08DB2341CDCCCCCC5F2E5A41CDCCCCCC98DA23419A9999D9652E5A410000000068DA2341666666A6682E5A4133333333ABD92341CDCCCC8C742E5A41	01010000206A080000477221C3D0DC2341343333D3622E5A41	751010402	A	Place Vendôme 2	7510104	75101	75	11	0
01060000206A080000010000000103000000010000003700000066666666C3DC23419A999919B12D5A419A999999C4DC234133333393B22D5A4166666666D2DC2341CDCCCCCCB52D5A4166666666E1DC234100000080B92D5A41CDCCCCCCEDDC234166666666BC2D5A41666666660BDD2341CDCCCCCCC32D5A419A99999911DD234100000080C52D5A41000000005ADD234100000080D92D5A410000000097DD234100000000EA2D5A4100000000A2DD2341000000E0EB2D5A4100000000B1DD23419A999979EF2D5A419A999999CBDD2341000000A0F62D5A4166666666D2DD2341CDCCCC8CF82D5A4166666666DEDD2341CDCCCCECFB2D5A41CDCCCCCCE9DD2341CDCCCC0CFE2D5A4100000000F3DD23419A9999F9FE2D5A4133333333F6DD2341666666C6FE2D5A41666666660DDE234133333353FD2D5A4166666666EADE23419A999959EF2D5A4133333333A3DF2341CDCCCC4CE32D5A41CDCCCCCCB5DF23419A999919E22D5A4100000000BFDF234100000080E12D5A4166666666C8DF2341CDCCCCECE02D5A41CDCCCCCC4EE0234166666606D92D5A419A99999982E02341000000C0D52D5A4133333333AEE0234100000000D32D5A4133333333F5E123419A999959BE2D5A41333333330DE223419A9999D9BC2D5A413333333358E22341CDCCCC0CB82D5A41CDCCCCCCEFE2234166666666AE2D5A419A999999C7E2234166666606A02D5A4100000000A7E2234166666646942D5A416666666683E22341CDCCCC8C872D5A41CDCCCCCC5BE22341CDCCCC4C792D5A41333333332CE22341666666667A2D5A410000000029E223419A9999797A2D5A419A9999996FE12341CDCCCCCC7E2D5A41CDCCCCCC45E123419A9999797F2D5A4133333333BBE02341000000C0812D5A419A999999A9E023419A999919822D5A410000000092E02341CDCCCC8C822D5A41000000005FE0234100000040842D5A4133333333F1DF2341333333F3882D5A419A99999992DF2341000000608D2D5A410000000072DF2341CDCCCCEC8E2D5A4166666666B9DE234133333393982D5A4100000000A3DE2341333333B3992D5A416666666689DE2341666666A69A2D5A41CDCCCCCC69DE23419A9999F99B2D5A4100000000A0DD2341CDCCCCCCA42D5A41666666668DDD2341333333F3A42D5A41666666664BDD2341666666A6A72D5A41000000001EDD23419A999979A92D5A4133333333CDDC2341CDCCCC2CAE2D5A4166666666C3DC23419A999919B12D5A41	01060000206A080000010000000103000000010000001300000066666666C3DC23419A999919B12D5A41666666660BDD2341CDCCCCCCC32D5A410000000097DD234100000000EA2D5A4166666666DEDD2341CDCCCCECFB2D5A4100000000F3DD23419A9999F9FE2D5A4166666666C8DF2341CDCCCCECE02D5A41CDCCCCCC4EE0234166666606D92D5A41CDCCCCCCEFE2234166666666AE2D5A41CDCCCCCC5BE22341CDCCCC4C792D5A419A9999996FE12341CDCCCCCC7E2D5A410000000092E02341CDCCCC8C822D5A4133333333F1DF2341333333F3882D5A410000000072DF2341CDCCCCEC8E2D5A4100000000A3DE2341333333B3992D5A4100000000A0DD2341CDCCCCCCA42D5A41000000001EDD23419A999979A92D5A4133333333CDDC2341CDCCCC2CAE2D5A4166666666C3DC23419A999919B12D5A4166666666C3DC23419A999919B12D5A41	01010000206A0800006A66663E89DF2341333333F3BA2D5A41	751010104	A	Saint-Germain l'Auxerrois 4	7510101	75101	75	11	0
01060000206A080000010000000103000000010000002200000033333333F7E323419A9999D9682D5A413333333314E423419A9999F96F2D5A41CDCCCCCC32E42341000000C0762D5A41CDCCCCCC47E423419A9999B97B2D5A41666666667FE4234100000060862D5A41666666669DE423419A9999198C2D5A4100000000BAE4234166666686912D5A4166666666BDE4234133333353912D5A419A99999932E52341000000E0892D5A41666666666AE5234133333353862D5A4166666666B2E52341000000E0812D5A413333333320E623419A9999F97A2D5A419A999999B3E62341000000C0712D5A419A999999C8E623419A999979702D5A41CDCCCCCCCDE6234100000020702D5A41CDCCCCCC18E72341000000806B2D5A410000000026E72341333333B36A2D5A41000000001FE7234166666666682D5A410000000006E723419A999919602D5A4133333333EEE6234133333333582D5A4133333333E4E623419A9999D9542D5A419A999999C4E623419A9999994A2D5A4133333333BCE62341CDCCCC0C492D5A4166666666A0E62341333333B3452D5A410000000081E6234166666666472D5A416666666663E623419A9999F9482D5A41CDCCCCCC57E6234133333393492D5A41666666663CE62341666666064B2D5A4166666666D2E523419A999939502D5A419A99999985E523419A999919542D5A410000000024E5234100000020592D5A419A999999F3E42341000000605B2D5A41666666665BE4234166666626632D5A4133333333F7E323419A9999D9682D5A41	01060000206A080000010000000103000000010000000A00000033333333F7E323419A9999D9682D5A41CDCCCCCC47E423419A9999B97B2D5A4100000000BAE4234166666686912D5A410000000026E72341333333B36A2D5A419A999999C4E623419A9999994A2D5A4166666666A0E62341333333B3452D5A41666666663CE62341666666064B2D5A41666666665BE4234166666626632D5A4133333333F7E323419A9999D9682D5A4133333333F7E323419A9999D9682D5A41	01010000206A080000D938FACD7FE52341CDCCCCBC6D2D5A41	751010101	H	Saint-Germain l'Auxerrois 1	7510101	75101	75	11	0
01060000206A08000001000000010300000001000000170000006666666629E32341666666C63D2D5A41000000003EE32341CDCCCC8C412D5A419A9999994FE32341CDCCCCCC452D5A41000000003EE42341333333933F2D5A41CDCCCCCC61E42341666666A63E2D5A419A999999B6E42341666666063D2D5A419A99999926E52341CDCCCC2C392D5A41CDCCCCCC5EE523419A9999F9362D5A41CDCCCCCC8BE5234100000080342D5A416666666621E62341666666462A2D5A41CDCCCCCCE1E5234166666626182D5A4100000000D5E523419A9999F9142D5A419A999999C7E52341CDCCCCCC112D5A41CDCCCCCCC1E5234133333373102D5A416666666639E52341CDCCCC8CF72C5A41666666668FE4234100000040052D5A419A99999985E4234133333353062D5A41333333336EE4234133333333082D5A416666666658E42341666666660A2D5A41666666663FE42341666666460E2D5A419A99999934E42341CDCCCC2C102D5A4100000000E0E32341666666061F2D5A416666666629E32341666666C63D2D5A41	01060000206A080000010000000103000000010000000C0000006666666629E32341666666C63D2D5A419A9999994FE32341CDCCCCCC452D5A41CDCCCCCC61E42341666666A63E2D5A419A999999B6E42341666666063D2D5A41CDCCCCCC5EE523419A9999F9362D5A416666666621E62341666666462A2D5A41CDCCCCCCC1E5234133333373102D5A416666666639E52341CDCCCC8CF72C5A41666666668FE4234100000040052D5A416666666658E42341666666660A2D5A416666666629E32341666666C63D2D5A416666666629E32341666666C63D2D5A41	01010000206A0800004AF102B9F0E42341666666961B2D5A41	751010102	A	Saint-Germain l'Auxerrois 2	7510101	75101	75	11	0
01060000206A0800000100000001030000000100000016000000CDCCCCCC5BE22341CDCCCC4C792D5A416666666683E22341CDCCCC8C872D5A4100000000A7E2234166666646942D5A419A999999C7E2234166666606A02D5A41CDCCCCCCEFE2234166666666AE2D5A41CDCCCCCC25E32341333333F3AA2D5A4100000000ADE3234133333353A22D5A41CDCCCCCCCAE3234133333373A02D5A419A99999967E42341CDCCCC8C962D5A4100000000AEE4234100000040922D5A4166666666B7E42341333333B3912D5A4166666666B8E42341000000A0912D5A4100000000BAE4234166666686912D5A41666666669DE423419A9999198C2D5A41666666667FE4234100000060862D5A41CDCCCCCC47E423419A9999B97B2D5A41CDCCCCCC32E42341000000C0762D5A413333333314E423419A9999F96F2D5A4133333333F7E323419A9999D9682D5A4133333333DAE32341666666E66A2D5A419A9999995CE32341000000A06F2D5A41CDCCCCCC5BE22341CDCCCC4C792D5A41	01060000206A0800000100000001030000000100000008000000CDCCCCCC5BE22341CDCCCC4C792D5A41CDCCCCCCEFE2234166666666AE2D5A4100000000BAE4234166666686912D5A41CDCCCCCC47E423419A9999B97B2D5A4133333333F7E323419A9999D9682D5A4133333333DAE32341666666E66A2D5A41CDCCCCCC5BE22341CDCCCC4C792D5A41CDCCCCCC5BE22341CDCCCC4C792D5A41	01010000206A080000FE75229F8DE32341343333D3892D5A41	751010103	A	Saint-Germain l'Auxerrois 3	7510101	75101	75	11	0
01060000206A080000010000000103000000010000001E0000003333333333DE234100000060B42E5A416666666650DE23419A999919B52E5A4133333333EDDE2341CDCCCC2CAF2E5A419A9999990BDF234133333313AE2E5A410000000020DF2341CDCCCC4CAD2E5A41CDCCCCCC8BDF2341CDCCCC6CA92E5A41CDCCCCCC1AE0234133333333A42E5A419A99999932E023419A999959A32E5A410000000072E02341CDCCCC0CA12E5A4166666666ABE023419A9999F99E2E5A41666666669DE023419A9999798C2E5A410000000084E023419A999919802E5A41333333336FE02341000000E0772E5A41CDCCCCCC66E0234133333393742E5A419A9999995EE0234166666626712E5A41000000005CE02341CDCCCC0C702E5A41CDCCCCCC21E02341333333D3572E5A419A999999C5DF2341CDCCCC0C5C2E5A4100000000B1DF2341000000005D2E5A410000000068DF234166666666602E5A4100000000DEDE2341333333D3662E5A419A999999CEDE2341666666066E2E5A41CDCCCCCC94DE234166666606882E5A41333333338EDE2341666666E68A2E5A41CDCCCCCC84DE2341CDCCCC4C8F2E5A410000000073DE234100000040972E5A41CDCCCCCC71DE2341666666E6972E5A419A99999953DE2341CDCCCC6CA52E5A41666666663FDE2341666666C6AE2E5A413333333333DE234100000060B42E5A41	01060000206A080000010000000103000000010000000A0000003333333333DE234100000060B42E5A416666666650DE23419A999919B52E5A4133333333EDDE2341CDCCCC2CAF2E5A4166666666ABE023419A9999F99E2E5A41666666669DE023419A9999798C2E5A410000000084E023419A999919802E5A41CDCCCCCC21E02341333333D3572E5A4100000000DEDE2341333333D3662E5A413333333333DE234100000060B42E5A413333333333DE234100000060B42E5A41	01010000206A080000B644FCDE94DF234100000010842E5A41	751020501	A	Gaillon 1	7510205	75102	75	11	0
01060000206A080000010000000103000000010000001C00000000000000A4DB2341333333D3AA2E5A413333333338DC23419A999959AF2E5A419A99999947DC23419A9999D9AF2E5A4133333333C6DC234133333313B42E5A4133333333D0DC234100000060B42E5A41CDCCCCCCFBDD2341666666C6BD2E5A41000000003DDE2341CDCCCC8CBF2E5A416666666650DE23419A999919B52E5A413333333333DE234100000060B42E5A41666666663FDE2341666666C6AE2E5A419A99999953DE2341CDCCCC6CA52E5A41CDCCCCCC71DE2341666666E6972E5A410000000073DE234100000040972E5A41CDCCCCCC84DE2341CDCCCC4C8F2E5A41333333338EDE2341666666E68A2E5A41CDCCCCCC94DE234166666606882E5A419A999999CEDE2341666666066E2E5A4100000000DEDE2341333333D3662E5A419A99999915DE2341666666C66F2E5A4133333333C3DD234166666686732E5A419A99999960DD2341000000C0772E5A41CDCCCCCC04DD2341666666467C2E5A4133333333F0DC2341666666E67D2E5A4166666666D6DC23419A999979802E5A413333333371DC2341666666468E2E5A419A999999C8DB234133333313A62E5A4133333333BCDB23419A9999B9A72E5A4100000000A4DB2341333333D3AA2E5A41	01060000206A080000010000000103000000010000000B00000000000000A4DB2341333333D3AA2E5A41CDCCCCCCFBDD2341666666C6BD2E5A41000000003DDE2341CDCCCC8CBF2E5A416666666650DE23419A999919B52E5A413333333333DE234100000060B42E5A4100000000DEDE2341333333D3662E5A419A99999960DD2341000000C0772E5A41CDCCCCCC04DD2341666666467C2E5A4166666666D6DC23419A999979802E5A4100000000A4DB2341333333D3AA2E5A4100000000A4DB2341333333D3AA2E5A41	01010000206A08000098BB04D764DD234166666646932E5A41	751020502	A	Gaillon 2	7510205	75102	75	11	0
01060000206A0800000100000001030000000100000014000000000000003DDE2341CDCCCC8CBF2E5A41000000002DDF23419A9999F9C62E5A41333333336DDF2341333333F3C82E5A416666666686DF23419A9999B9C92E5A419A99999931E0234166666686CF2E5A41CDCCCCCCB8E023419A9999B9D32E5A41CDCCCCCCCEE02341CDCCCC6CD42E5A4100000000BBE023419A999999B62E5A4166666666B5E0234100000020AE2E5A4133333333ACE0234100000000A02E5A4166666666ABE023419A9999F99E2E5A410000000072E02341CDCCCC0CA12E5A419A99999932E023419A999959A32E5A41CDCCCCCC1AE0234133333333A42E5A41CDCCCCCC8BDF2341CDCCCC6CA92E5A410000000020DF2341CDCCCC4CAD2E5A419A9999990BDF234133333313AE2E5A4133333333EDDE2341CDCCCC2CAF2E5A416666666650DE23419A999919B52E5A41000000003DDE2341CDCCCC8CBF2E5A41	01060000206A0800000100000001030000000100000008000000000000003DDE2341CDCCCC8CBF2E5A416666666686DF23419A9999B9C92E5A41CDCCCCCCCEE02341CDCCCC6CD42E5A4166666666ABE023419A9999F99E2E5A4133333333EDDE2341CDCCCC2CAF2E5A416666666650DE23419A999919B52E5A41000000003DDE2341CDCCCC8CBF2E5A41000000003DDE2341CDCCCC8CBF2E5A41	01010000206A0800006068A5A381DF234134333313BB2E5A41	751020503	A	Gaillon 3	7510205	75102	75	11	0
01060000206A080000010000000103000000010000002F000000CDCCCCCC21E02341333333D3572E5A41000000005CE02341CDCCCC0C702E5A419A9999995EE0234166666626712E5A41CDCCCCCC66E0234133333393742E5A41333333336FE02341000000E0772E5A410000000084E023419A999919802E5A41666666669DE023419A9999798C2E5A4166666666ABE023419A9999F99E2E5A419A9999990CE12341333333739B2E5A41333333334CE1234166666626992E5A4100000000C5E12341CDCCCCCC942E5A416666666633E2234166666666902E5A410000000086E22341000000208D2E5A41666666668FE22341000000C08C2E5A410000000047E3234133333393852E5A410000000096E3234133333373822E5A416666666699E323419A999999802E5A410000000098E32341333333737F2E5A41CDCCCCCC8EE32341000000A07B2E5A413333333361E323419A999919682E5A41CDCCCCCC3CE3234166666666582E5A41333333331AE323419A999959492E5A416666666613E32341CDCCCC8C462E5A416666666618E323419A9999D9452E5A416666666636E32341666666C6432E5A41333333334CE32341666666063F2E5A41CDCCCCCC4DE32341CDCCCCAC3E2E5A41CDCCCCCC50E323419A9999993D2E5A413333333352E32341000000C03B2E5A410000000049E323419A9999B9392E5A41CDCCCCCC3BE3234166666666362E5A41333333332DE32341CDCCCCAC342E5A41000000001DE323419A999979352E5A419A99999915E323419A9999D9352E5A4100000000FFE22341CDCCCCEC362E5A419A999999EAE22341CDCCCCCC372E5A4166666666C0E22341CDCCCCAC392E5A419A9999995AE223419A9999193E2E5A416666666653E22341333333733E2E5A41333333332BE2234166666646402E5A410000000012E2234133333373412E5A41CDCCCCCCF4E12341CDCCCCCC422E5A419A999999BAE1234166666686452E5A4100000000FEE02341CDCCCC4C4E2E5A410000000086E023419A999979532E5A41000000006DE0234133333393542E5A41CDCCCCCC21E02341333333D3572E5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC21E02341333333D3572E5A410000000084E023419A999919802E5A41666666669DE023419A9999798C2E5A4166666666ABE023419A9999F99E2E5A4100000000C5E12341CDCCCCCC942E5A410000000096E3234133333373822E5A410000000098E32341333333737F2E5A416666666613E32341CDCCCC8C462E5A416666666636E32341666666C6432E5A413333333352E32341000000C03B2E5A41333333332DE32341CDCCCCAC342E5A419A9999995AE223419A9999193E2E5A4100000000FEE02341CDCCCC4C4E2E5A41CDCCCCCC21E02341333333D3572E5A41CDCCCCCC21E02341333333D3572E5A41	01010000206A0800001E6F8177DEE12341343333136C2E5A41	751020601	H	Vivienne 1	7510206	75102	75	11	0
01060000206A080000010000000103000000010000002100000066666666ABE023419A9999F99E2E5A4133333333ACE0234100000000A02E5A4166666666B5E0234100000020AE2E5A4100000000BBE023419A999999B62E5A41CDCCCCCCCEE02341CDCCCC6CD42E5A4166666666DDE02341666666E6D42E5A4166666666E1E0234166666606D52E5A41CDCCCCCC3CE12341000000E0D72E5A413333333368E123419A999939D92E5A413333333390E1234133333373DA2E5A4100000000FBE1234133333393DD2E5A416666666651E2234166666626E02E5A41666666668EE223419A9999F9E12E5A41CDCCCCCC75E32341CDCCCCCCDA2E5A41000000009BE32341CDCCCC8CD92E5A410000000047E423419A9999F9D32E5A41CDCCCCCC27E423419A999999C22E5A416666666614E42341666666E6B72E5A413333333307E42341CDCCCC8CB02E5A4100000000FEE3234100000040AD2E5A41CDCCCCCCF5E3234133333353AA2E5A4100000000E5E32341CDCCCCCCA12E5A4166666666DEE32341666666869E2E5A4166666666D6E32341666666669B2E5A410000000096E3234133333373822E5A410000000047E3234133333393852E5A41666666668FE22341000000C08C2E5A410000000086E22341000000208D2E5A416666666633E2234166666666902E5A4100000000C5E12341CDCCCCCC942E5A41333333334CE1234166666626992E5A419A9999990CE12341333333739B2E5A4166666666ABE023419A9999F99E2E5A41	01060000206A080000010000000103000000010000000A00000066666666ABE023419A9999F99E2E5A41CDCCCCCCCEE02341CDCCCC6CD42E5A41666666668EE223419A9999F9E12E5A410000000047E423419A9999F9D32E5A413333333307E42341CDCCCC8CB02E5A4166666666DEE32341666666869E2E5A410000000096E3234133333373822E5A4100000000C5E12341CDCCCCCC942E5A4166666666ABE023419A9999F99E2E5A4166666666ABE023419A9999F99E2E5A41	01010000206A080000987021D162E2234134333393B32E5A41	751020602	A	Vivienne 2	7510206	75102	75	11	0
01060000206A08000001000000010300000001000000250000003333333340E42341000000A0272E5A413333333364E4234166666666342E5A419A9999996CE4234100000060372E5A4100000000ADE423419A9999194E2E5A41CDCCCCCCB5E42341666666A6502E5A419A999999B8E42341666666C6532E5A4133333333BCE423419A999959562E5A419A999999BFE42341333333F3592E5A419A999999C0E42341000000C05C2E5A41CDCCCCCCC1E42341333333F35E2E5A419A999999C8E4234133333393602E5A4166666666CCE42341CDCCCCEC5E2E5A4100000000E5E4234166666606542E5A4100000000EBE42341CDCCCCAC512E5A4133333333F1E42341666666064F2E5A416666666602E52341333333D34E2E5A410000000020E52341CDCCCCEC4E2E5A41333333332BE52341666666E64E2E5A41CDCCCCCC63E52341666666C64E2E5A41000000009EE52341000000E04C2E5A419A99999911E623419A999919492E5A416666666698E62341333333B3442E5A413333333389E6234100000000372E5A41CDCCCCCC82E62341000000A0312E5A419A9999997EE623419A9999192E2E5A41333333337EE62341666666C62D2E5A41666666666EE6234166666646222E5A419A9999995EE62341CDCCCCCC182E5A41CDCCCCCC4EE62341333333130F2E5A41CDCCCCCC91E52341666666C6172E5A41CDCCCCCC7EE52341000000A0182E5A41333333336CE523419A999979192E5A41CDCCCCCC65E52341CDCCCCCC192E5A416666666657E52341333333731A2E5A410000000055E52341CDCCCC8C1A2E5A41CDCCCCCCCEE42341666666E6202E5A413333333340E42341000000A0272E5A41	01060000206A080000010000000103000000010000000A0000003333333340E42341000000A0272E5A41CDCCCCCCB5E42341666666A6502E5A419A999999C8E4234133333393602E5A4133333333F1E42341666666064F2E5A41CDCCCCCC63E52341666666C64E2E5A416666666698E62341333333B3442E5A41333333337EE62341666666C62D2E5A41CDCCCCCC4EE62341333333130F2E5A413333333340E42341000000A0272E5A413333333340E42341000000A0272E5A41	01010000206A080000F040903E88E523419A9999093E2E5A41	751020701	H	Mail 1	7510207	75102	75	11	0
01060000206A08000001000000010300000001000000360000006666666613E32341CDCCCC8C462E5A41333333331AE323419A999959492E5A41CDCCCCCC3CE3234166666666582E5A413333333361E323419A999919682E5A41CDCCCCCC8EE32341000000A07B2E5A410000000098E32341333333737F2E5A416666666699E323419A999999802E5A410000000096E3234133333373822E5A419A999999C4E3234166666666802E5A416666666694E4234100000020772E5A413333333394E52341000000806C2E5A4166666666A1E52341CDCCCCEC6B2E5A4100000000A3E52341000000E06B2E5A41000000001AE62341000000C0662E5A41CDCCCCCCB1E62341000000E0602E5A419A999999AFE62341000000205E2E5A4166666666AEE62341333333935C2E5A416666666698E62341333333B3442E5A419A99999911E623419A999919492E5A41000000009EE52341000000E04C2E5A41CDCCCCCC63E52341666666C64E2E5A41333333332BE52341666666E64E2E5A410000000020E52341CDCCCCEC4E2E5A416666666602E52341333333D34E2E5A4133333333F1E42341666666064F2E5A4100000000EBE42341CDCCCCAC512E5A4100000000E5E4234166666606542E5A4166666666CCE42341CDCCCCEC5E2E5A419A999999C8E4234133333393602E5A41CDCCCCCCC1E42341333333F35E2E5A419A999999C0E42341000000C05C2E5A419A999999BFE42341333333F3592E5A4133333333BCE423419A999959562E5A419A999999B8E42341666666C6532E5A41CDCCCCCCB5E42341666666A6502E5A4100000000ADE423419A9999194E2E5A419A9999996CE4234100000060372E5A413333333364E4234166666666342E5A413333333340E42341000000A0272E5A41CDCCCCCCF3E323419A9999F92A2E5A4166666666BAE323419A9999B92D2E5A41000000006AE32341666666A6312E5A416666666651E323419A9999D9322E5A410000000041E32341333333B3332E5A41333333332DE32341CDCCCCAC342E5A41CDCCCCCC3BE3234166666666362E5A410000000049E323419A9999B9392E5A413333333352E32341000000C03B2E5A41CDCCCCCC50E323419A9999993D2E5A41CDCCCCCC4DE32341CDCCCCAC3E2E5A41333333334CE32341666666063F2E5A416666666636E32341666666C6432E5A416666666618E323419A9999D9452E5A416666666613E32341CDCCCC8C462E5A41	01060000206A08000001000000010300000001000000110000006666666613E32341CDCCCC8C462E5A410000000098E32341333333737F2E5A410000000096E3234133333373822E5A416666666694E4234100000020772E5A41000000001AE62341000000C0662E5A41CDCCCCCCB1E62341000000E0602E5A416666666698E62341333333B3442E5A41CDCCCCCC63E52341666666C64E2E5A4133333333F1E42341666666064F2E5A419A999999C8E4234133333393602E5A41CDCCCCCCB5E42341666666A6502E5A413333333340E42341000000A0272E5A41333333332DE32341CDCCCCAC342E5A413333333352E32341000000C03B2E5A416666666636E32341666666C6432E5A416666666613E32341CDCCCC8C462E5A416666666613E32341CDCCCC8C462E5A41	01010000206A08000094B509FCC4E5234100000030552E5A41	751020702	H	Mail 2	7510207	75102	75	11	0
01060000206A08000001000000010300000001000000270000000000000096E3234133333373822E5A4166666666D6E32341666666669B2E5A4166666666DEE32341666666869E2E5A4100000000E5E32341CDCCCCCCA12E5A41CDCCCCCCF5E3234133333353AA2E5A4100000000FEE3234100000040AD2E5A413333333307E42341CDCCCC8CB02E5A41333333330DE423419A999939AD2E5A419A9999991EE423419A9999D9A82E5A4166666666D4E4234166666686A12E5A410000000026E52341333333F39D2E5A413333333355E52341666666469B2E5A41666666666FE523419A9999F9992E5A41CDCCCCCCDDE52341CDCCCC0C942E5A41CDCCCCCCFFE523419A9999599E2E5A413333333335E62341666666E6B12E5A419A99999962E623419A999979C22E5A41666666668DE62341CDCCCC0CC12E5A419A9999990FE7234133333313BD2E5A419A99999907E72341CDCCCC6CAC2E5A419A999999FCE62341000000E09D2E5A41CDCCCCCCF7E62341666666A6932E5A4133333333F3E623419A9999398A2E5A4100000000F2E6234166666606892E5A4166666666EFE62341666666A6852E5A41CDCCCCCCEAE62341CDCCCC6C7F2E5A4100000000E3E62341666666E67C2E5A4133333333C9E6234100000060732E5A41CDCCCCCCBDE62341333333536F2E5A4166666666B5E62341000000C0672E5A41CDCCCCCCB3E62341333333F3622E5A41CDCCCCCCB1E62341000000E0602E5A41000000001AE62341000000C0662E5A4100000000A3E52341000000E06B2E5A4166666666A1E52341CDCCCCEC6B2E5A413333333394E52341000000806C2E5A416666666694E4234100000020772E5A419A999999C4E3234166666666802E5A410000000096E3234133333373822E5A41	01060000206A08000001000000010300000001000000100000000000000096E3234133333373822E5A4166666666DEE32341666666869E2E5A413333333307E42341CDCCCC8CB02E5A419A9999991EE423419A9999D9A82E5A410000000026E52341333333F39D2E5A41CDCCCCCCDDE52341CDCCCC0C942E5A41CDCCCCCCFFE523419A9999599E2E5A419A99999962E623419A999979C22E5A419A9999990FE7234133333313BD2E5A41CDCCCCCCEAE62341CDCCCC6C7F2E5A41CDCCCCCCBDE62341333333536F2E5A41CDCCCCCCB1E62341000000E0602E5A41000000001AE62341000000C0662E5A416666666694E4234100000020772E5A410000000096E3234133333373822E5A410000000096E3234133333373822E5A41	01010000206A08000016D8BADD55E52341000000F08E2E5A41	751020703	H	Mail 3	7510207	75102	75	11	0
01060000206A08000001000000010300000001000000120000003333333307E42341CDCCCC8CB02E5A416666666614E42341666666E6B72E5A41CDCCCCCC27E423419A999999C22E5A410000000047E423419A9999F9D32E5A419A99999977E4234100000060D22E5A419A999999CEE5234100000040C72E5A4166666666F6E52341000000E0C52E5A419A99999962E623419A999979C22E5A413333333335E62341666666E6B12E5A41CDCCCCCCFFE523419A9999599E2E5A41CDCCCCCCDDE52341CDCCCC0C942E5A41666666666FE523419A9999F9992E5A413333333355E52341666666469B2E5A410000000026E52341333333F39D2E5A4166666666D4E4234166666686A12E5A419A9999991EE423419A9999D9A82E5A41333333330DE423419A999939AD2E5A413333333307E42341CDCCCC8CB02E5A41	01060000206A08000001000000010300000001000000090000003333333307E42341CDCCCC8CB02E5A410000000047E423419A9999F9D32E5A419A99999962E623419A999979C22E5A41CDCCCCCCFFE523419A9999599E2E5A41CDCCCCCCDDE52341CDCCCC0C942E5A410000000026E52341333333F39D2E5A419A9999991EE423419A9999D9A82E5A413333333307E42341CDCCCC8CB02E5A413333333307E42341CDCCCC8CB02E5A41	01010000206A0800005BDFF73626E52341666666E6B42E5A41	751020704	A	Mail 4	7510207	75102	75	11	0
01060000206A080000010000000103000000010000003700000066666666A4E7234133333313FF2D5A410000000046E823419A9999F9052E5A41000000004BE82341666666460B2E5A416666666653E82341666666A6132E5A416666666654E82341666666E6142E5A41333333335AE8234133333393192E5A41CDCCCCCC5DE82341666666061C2E5A41666666666CE8234100000080222E5A41000000007EE82341CDCCCC6C292E5A413333333384E823419A9999192C2E5A413333333390E8234166666686312E5A41CDCCCCCC95E82341666666C6332E5A4133333333A5E823419A999959382E5A419A999999C7E82341CDCCCC2C422E5A4133333333DFE8234100000000492E5A4133333333E6E82341CDCCCC0C4B2E5A4166666666F0E82341000000004E2E5A41CDCCCCCCFAE82341CDCCCC8C512E5A410000000006E923419A999919562E5A41CDCCCCCC1DE923419A9999795F2E5A41333333332CE923419A999939662E5A413333333332E92341333333F3682E5A41333333333BE92341CDCCCC2C6D2E5A416666666651E9234133333373772E5A410000000057E92341000000407A2E5A419A99999963E92341000000807F2E5A410000000074E9234100000060862E5A410000000080E92341333333138B2E5A419A99999984E92341000000808C2E5A413333333397E9234100000040932E5A4100000000A5E923419A9999F9972E5A41CDCCCCCCBDE92341333333139E2E5A419A999999C5E923419A999979A02E5A4100000000F7E92341333333539E2E5A410000000047EA2341000000C09A2E5A41333333336BEA234100000020992E5A4166666666AEEA234133333333962E5A419A9999998FEA2341CDCCCCAC8B2E5A41333333338EEA2341CDCCCC2C8B2E5A410000000079EA23419A999999842E5A41000000005FEA2341CDCCCC0C7C2E5A419A9999994EEA234166666686762E5A413333333337EA2341666666A66E2E5A416666666620EA2341333333F3662E5A419A9999990FEA23419A999979612E5A4100000000FCE92341CDCCCC2C5B2E5A4133333333EEE92341CDCCCCAC562E5A419A999999ACE923419A999999402E5A416666666657E9234133333333252E5A413333333313E92341000000800E2E5A4100000000FDE8234133333333072E5A41CDCCCCCCBFE8234133333313F22D5A41CDCCCCCCB3E82341666666A6F22D5A410000000034E82341000000A0F82D5A4166666666A4E7234133333313FF2D5A41	01060000206A080000010000000103000000010000000F00000066666666A4E7234133333313FF2D5A410000000046E823419A9999F9052E5A41CDCCCCCC5DE82341666666061C2E5A41CDCCCCCC95E82341666666C6332E5A4166666666F0E82341000000004E2E5A41CDCCCCCC1DE923419A9999795F2E5A410000000074E9234100000060862E5A4100000000A5E923419A9999F9972E5A419A999999C5E923419A999979A02E5A4166666666AEEA234133333333962E5A419A999999ACE923419A999999402E5A416666666657E9234133333333252E5A41CDCCCCCCBFE8234133333313F22D5A4166666666A4E7234133333313FF2D5A4166666666A4E7234133333313FF2D5A41	01010000206A080000469771A755E92341666666064A2E5A41	751020801	H	Bonne Nouvelle 1	7510208	75102	75	11	0
01060000206A0800000100000001030000000100000014000000CDCCCCCC4EE62341333333130F2E5A419A9999995EE62341CDCCCCCC182E5A41666666666EE6234166666646222E5A41333333337EE62341666666C62D2E5A419A9999997EE623419A9999192E2E5A41CDCCCCCC82E62341000000A0312E5A413333333389E6234100000000372E5A416666666698E62341333333B3442E5A410000000093E72341CDCCCC4C3A2E5A419A999999A4E72341666666E6392E5A41000000007CE72341666666C6282E5A413333333373E7234166666646272E5A419A9999995AE72341000000E01D2E5A410000000048E7234100000060162E5A41000000004BE82341666666460B2E5A410000000046E823419A9999F9052E5A4166666666A4E7234133333313FF2D5A41000000004AE7234100000060032E5A419A999999D5E62341333333B3082E5A41CDCCCCCC4EE62341333333130F2E5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC4EE62341333333130F2E5A41333333337EE62341666666C62D2E5A416666666698E62341333333B3442E5A419A999999A4E72341666666E6392E5A41000000007CE72341666666C6282E5A410000000048E7234100000060162E5A41000000004BE82341666666460B2E5A410000000046E823419A9999F9052E5A4166666666A4E7234133333313FF2D5A41CDCCCCCC4EE62341333333130F2E5A41CDCCCCCC4EE62341333333130F2E5A41	01010000206A080000C5475F8BE5E6234133333313202E5A41	751020802	H	Bonne Nouvelle 2	7510208	75102	75	11	0
01060000206A080000010000000103000000010000001D0000006666666698E62341333333B3442E5A4166666666AEE62341333333935C2E5A419A999999AFE62341000000205E2E5A41CDCCCCCCB1E62341000000E0602E5A419A999999D4E62341666666465F2E5A41333333330DE723419A9999F95C2E5A41CDCCCCCCEAE7234133333393532E5A419A99999950E82341CDCCCC2C4F2E5A419A9999997CE82341666666464D2E5A4133333333DFE8234100000000492E5A419A999999C7E82341CDCCCC2C422E5A4133333333A5E823419A999959382E5A41CDCCCCCC95E82341666666C6332E5A413333333390E8234166666686312E5A413333333384E823419A9999192C2E5A41000000007EE82341CDCCCC6C292E5A41666666666CE8234100000080222E5A41CDCCCCCC5DE82341666666061C2E5A41333333335AE8234133333393192E5A416666666654E82341666666E6142E5A416666666653E82341666666A6132E5A41000000004BE82341666666460B2E5A410000000048E7234100000060162E5A419A9999995AE72341000000E01D2E5A413333333373E7234166666646272E5A41000000007CE72341666666C6282E5A419A999999A4E72341666666E6392E5A410000000093E72341CDCCCC4C3A2E5A416666666698E62341333333B3442E5A41	01060000206A080000010000000103000000010000000B0000006666666698E62341333333B3442E5A41CDCCCCCCB1E62341000000E0602E5A4133333333DFE8234100000000492E5A41CDCCCCCC95E82341666666C6332E5A41CDCCCCCC5DE82341666666061C2E5A41000000004BE82341666666460B2E5A410000000048E7234100000060162E5A41000000007CE72341666666C6282E5A419A999999A4E72341666666E6392E5A416666666698E62341333333B3442E5A416666666698E62341333333B3442E5A41	01010000206A0800009AF842801CE8234100000010362E5A41	751020803	H	Bonne Nouvelle 3	7510208	75102	75	11	0
01060000206A0800000100000001030000000100000028000000CDCCCCCCB1E62341000000E0602E5A41CDCCCCCCB3E62341333333F3622E5A4166666666B5E62341000000C0672E5A41CDCCCCCCBDE62341333333536F2E5A410000000037E7234133333353762E5A41333333336FE7234166666626792E5A419A99999972E7234133333353792E5A416666666615E8234166666666822E5A41CDCCCCCCEEE72341333333938C2E5A4166666666A6E823419A999919972E5A410000000000E92341666666469C2E5A413333333362E92341666666E6A12E5A413333333367E9234100000080A22E5A41CDCCCCCC6BE9234100000060A42E5A41333333338DE92341CDCCCCECA22E5A419A999999C5E923419A999979A02E5A41CDCCCCCCBDE92341333333139E2E5A4100000000A5E923419A9999F9972E5A413333333397E9234100000040932E5A419A99999984E92341000000808C2E5A410000000080E92341333333138B2E5A410000000074E9234100000060862E5A419A99999963E92341000000807F2E5A410000000057E92341000000407A2E5A416666666651E9234133333373772E5A41333333333BE92341CDCCCC2C6D2E5A413333333332E92341333333F3682E5A41333333332CE923419A999939662E5A41CDCCCCCC1DE923419A9999795F2E5A410000000006E923419A999919562E5A41CDCCCCCCFAE82341CDCCCC8C512E5A4166666666F0E82341000000004E2E5A4133333333E6E82341CDCCCC0C4B2E5A4133333333DFE8234100000000492E5A419A9999997CE82341666666464D2E5A419A99999950E82341CDCCCC2C4F2E5A41CDCCCCCCEAE7234133333393532E5A41333333330DE723419A9999F95C2E5A419A999999D4E62341666666465F2E5A41CDCCCCCCB1E62341000000E0602E5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCCB1E62341000000E0602E5A41CDCCCCCCBDE62341333333536F2E5A416666666615E8234166666666822E5A41CDCCCCCCEEE72341333333938C2E5A413333333362E92341666666E6A12E5A41CDCCCCCC6BE9234100000060A42E5A419A999999C5E923419A999979A02E5A4100000000A5E923419A9999F9972E5A410000000074E9234100000060862E5A41CDCCCCCC1DE923419A9999795F2E5A4133333333DFE8234100000000492E5A41CDCCCCCCB1E62341000000E0602E5A41CDCCCCCCB1E62341000000E0602E5A41	01010000206A080000AFEFFD2F49E82341333333E3762E5A41	751020804	H	Bonne Nouvelle 4	7510208	75102	75	11	0
01060000206A080000010000000103000000010000001F000000CDCCCCCCBDE62341333333536F2E5A4133333333C9E6234100000060732E5A4100000000E3E62341666666E67C2E5A41CDCCCCCCEAE62341CDCCCC6C7F2E5A4166666666EFE62341666666A6852E5A4100000000F2E6234166666606892E5A4133333333F3E623419A9999398A2E5A41CDCCCCCCF7E62341666666A6932E5A419A999999FCE62341000000E09D2E5A419A99999907E72341CDCCCC6CAC2E5A419A9999990FE7234133333313BD2E5A419A99999943E7234100000000BB2E5A410000000081E7234133333393B82E5A4166666666BCE723419A999939B62E5A41CDCCCCCCFFE72341CDCCCC6CB32E5A41666666661AE8234133333353B22E5A41CDCCCCCC4DE8234133333333B02E5A413333333386E82341333333D3AD2E5A4133333333B5E823419A9999F9AB2E5A4166666666CCE82341CDCCCC0CAB2E5A41CDCCCCCC6BE9234100000060A42E5A413333333367E9234100000080A22E5A413333333362E92341666666E6A12E5A410000000000E92341666666469C2E5A4166666666A6E823419A999919972E5A41CDCCCCCCEEE72341333333938C2E5A416666666615E8234166666666822E5A419A99999972E7234133333353792E5A41333333336FE7234166666626792E5A410000000037E7234133333353762E5A41CDCCCCCCBDE62341333333536F2E5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCCBDE62341333333536F2E5A41CDCCCCCCEAE62341CDCCCC6C7F2E5A419A9999990FE7234133333313BD2E5A4166666666BCE723419A999939B62E5A41CDCCCCCC6BE9234100000060A42E5A413333333362E92341666666E6A12E5A41CDCCCCCCEEE72341333333938C2E5A416666666615E8234166666666822E5A41CDCCCCCCBDE62341333333536F2E5A41CDCCCCCCBDE62341333333536F2E5A41	01010000206A0800007AA79375C0E7234100000060952E5A41	751020805	H	Bonne Nouvelle 5	7510208	75102	75	11	0
01060000206A0800000100000001030000000100000030000000CDCCCCCC1CEB2341333333136F2E5A413333333344EB2341CDCCCC2C7C2E5A419A99999947EB2341666666467D2E5A41CDCCCCCC58EB234100000000832E5A416666666669EB2341CDCCCC8C892E5A419A99999974EB23419A9999198B2E5A419A9999997EEB2341333333D38B2E5A416666666688EB2341000000608C2E5A41333333338AEB2341CDCCCC4C8C2E5A4166666666ACEB2341333333F38A2E5A41CDCCCCCCC4EB23419A9999F9892E5A419A999999F6EB234100000020882E5A4100000000E9EC23419A9999D9802E5A419A99999937ED2341CDCCCC8C7E2E5A410000000072ED2341666666C67C2E5A41333333338CED23419A9999F97B2E5A4100000000B1ED2341CDCCCCEC7A2E5A4100000000CEED2341333333137A2E5A419A9999997AEE23419A999919752E5A41333333333CEF2341CDCCCC6C6F2E5A41CDCCCCCC77EF2341CDCCCCEC6D2E5A41CDCCCCCC98EF2341CDCCCCEC6C2E5A419A999999D9EF2341333333F36A2E5A4133333333EDEF234166666606692E5A4100000000FFEF23419A999939672E5A416666666607F02341CDCCCC6C662E5A416666666615F0234166666606652E5A410000000020F02341333333F3632E5A410000000022F02341666666C6632E5A41666666662EF0234166666686622E5A41CDCCCCCC2BF02341CDCCCC4C622E5A41CDCCCCCCEAEF23419A9999995D2E5A4100000000C9EF23419A9999D95A2E5A4166666666B0EF2341CDCCCCEC582E5A41CDCCCCCCA1EF2341333333D3582E5A41000000004EEF2341333333935C2E5A4100000000EAEE23419A999939602E5A41CDCCCCCC80EE234133333333642E5A419A9999991EEE2341666666E6672E5A4100000000C0ED2341333333536B2E5A41666666666DED23419A9999796E2E5A41333333333CED2341CDCCCC4C702E5A416666666639ED2341000000E06E2E5A413333333334ED2341CDCCCC4C6C2E5A410000000034ED2341333333336C2E5A41CDCCCCCC1FED2341CDCCCC8C602E5A4166666666D6EB2341333333D3692E5A41CDCCCCCC1CEB2341333333136F2E5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCC1CEB2341333333136F2E5A416666666669EB2341CDCCCC8C892E5A416666666688EB2341000000608C2E5A419A999999F6EB234100000020882E5A41333333338CED23419A9999F97B2E5A419A999999D9EF2341333333F36A2E5A41666666662EF0234166666686622E5A4166666666B0EF2341CDCCCCEC582E5A41333333333CED2341CDCCCC4C702E5A41CDCCCCCC1FED2341CDCCCC8C602E5A41CDCCCCCC1CEB2341333333136F2E5A41CDCCCCCC1CEB2341333333136F2E5A41	01010000206A080000D456BA16FAEC2341343333B3722E5A41	751030901	H	Arts et Métiers 1	7510309	75103	75	11	0
01060000206A080000010000000103000000010000001E0000006666666608EB23419A999999682E5A41CDCCCCCC1CEB2341333333136F2E5A4166666666D6EB2341333333D3692E5A41CDCCCCCC1FED2341CDCCCC8C602E5A410000000034ED2341333333336C2E5A413333333334ED2341CDCCCC4C6C2E5A416666666639ED2341000000E06E2E5A41333333333CED2341CDCCCC4C702E5A41666666666DED23419A9999796E2E5A4100000000C0ED2341333333536B2E5A419A9999991EEE2341666666E6672E5A41CDCCCCCC80EE234133333333642E5A4100000000EAEE23419A999939602E5A41000000004EEF2341333333935C2E5A41CDCCCCCCA1EF2341333333D3582E5A410000000096EF2341666666A6562E5A410000000030EF23419A9999594F2E5A41000000001CEF2341000000004F2E5A4100000000DAEE2341000000404C2E5A4166666666B5EE2341000000A04A2E5A41000000008BEE2341CDCCCCCC482E5A416666666659EE23419A9999B9462E5A410000000024EE23419A999979442E5A41CDCCCCCC10EE23419A9999B9472E5A41CDCCCCCCF9EC23419A999999532E5A4100000000AAEC23419A999939572E5A419A99999921EC2341000000205D2E5A419A999999B7EB2341000000E0612E5A41000000002BEB23419A9999D9672E5A416666666608EB23419A999999682E5A41	01060000206A080000010000000103000000010000000F0000006666666608EB23419A999999682E5A41CDCCCCCC1CEB2341333333136F2E5A41CDCCCCCC1FED2341CDCCCC8C602E5A41333333333CED2341CDCCCC4C702E5A41000000004EEF2341333333935C2E5A41CDCCCCCCA1EF2341333333D3582E5A410000000096EF2341666666A6562E5A410000000030EF23419A9999594F2E5A41000000001CEF2341000000004F2E5A410000000024EE23419A999979442E5A41CDCCCCCC10EE23419A9999B9472E5A41CDCCCCCCF9EC23419A999999532E5A41000000002BEB23419A9999D9672E5A416666666608EB23419A999999682E5A416666666608EB23419A999999682E5A41	01010000206A08000044F106C8E8ED2341333333B35A2E5A41	751030902	H	Arts et Métiers 2	7510309	75103	75	11	0
01060000206A08000001000000010300000001000000240000000000000073EB23419A9999D92B2E5A4166666666A5EB234133333373392E5A419A99999921EC2341000000205D2E5A4100000000AAEC23419A999939572E5A41CDCCCCCCF9EC23419A999999532E5A41CDCCCCCC10EE23419A9999B9472E5A410000000024EE23419A999979442E5A416666666659EE23419A9999B9462E5A41000000008BEE2341CDCCCCCC482E5A4166666666B5EE2341000000A04A2E5A4100000000DAEE2341000000404C2E5A41000000001CEF2341000000004F2E5A4100000000ECEE23419A9999F9482E5A419A999999D4EE234133333353452E5A4100000000CAEE2341CDCCCCAC432E5A41CDCCCCCC98EE2341000000E03A2E5A419A99999975EE2341666666C6332E5A41CDCCCCCC34EE234100000060282E5A413333333314EE234166666646222E5A4166666666FBED23419A9999191E2E5A4100000000E7ED2341333333D31A2E5A419A999999D6ED23419A999939182E5A4133333333C5ED2341666666C6152E5A4166666666B9ED2341CDCCCC8C142E5A4166666666F1EC2341666666061D2E5A419A99999952EC2341000000A0242E5A419A9999993CEC234166666686252E5A419A99999920EC2341666666A6262E5A413333333306EC2341333333B3272E5A4100000000FEEB234166666606282E5A4133333333F0EB234133333373282E5A4133333333E1EB234100000000292E5A4133333333DCEB234133333313292E5A4133333333C7EB234100000040292E5A419A99999981EB23419A9999592A2E5A410000000073EB23419A9999D92B2E5A41	01060000206A08000001000000010300000001000000100000000000000073EB23419A9999D92B2E5A4166666666A5EB234133333373392E5A419A99999921EC2341000000205D2E5A41CDCCCCCC10EE23419A9999B9472E5A410000000024EE23419A999979442E5A41000000001CEF2341000000004F2E5A4100000000ECEE23419A9999F9482E5A41CDCCCCCC98EE2341000000E03A2E5A413333333314EE234166666646222E5A4166666666B9ED2341CDCCCC8C142E5A4166666666F1EC2341666666061D2E5A419A99999952EC2341000000A0242E5A4133333333E1EB234100000000292E5A419A99999981EB23419A9999592A2E5A410000000073EB23419A9999D92B2E5A410000000073EB23419A9999D92B2E5A41	01010000206A0800002C53AD460FED2341CCCCCC9C362E5A41	751030903	H	Arts et Métiers 3	7510309	75103	75	11	0
01060000206A0800000100000001030000000100000024000000000000002AEB2341CDCCCC6C092E5A41CDCCCCCC54EB2341CDCCCC6C182E5A41CDCCCCCC56EB23419A999939192E5A419A99999971EB2341000000E0232E5A419A99999981EB23419A9999592A2E5A4133333333C7EB234100000040292E5A4133333333DCEB234133333313292E5A4133333333E1EB234100000000292E5A4133333333F0EB234133333373282E5A4100000000FEEB234166666606282E5A413333333306EC2341333333B3272E5A419A99999920EC2341666666A6262E5A419A9999993CEC234166666686252E5A419A99999952EC2341000000A0242E5A4166666666F1EC2341666666061D2E5A4166666666B9ED2341CDCCCC8C142E5A41CDCCCCCCB4ED23419A9999F9132E5A419A999999B0ED234166666686132E5A4133333333AEED23419A999939132E5A4100000000A9ED234100000060122E5A41CDCCCCCCA2ED234133333333112E5A419A99999994ED2341000000C00E2E5A416666666661ED234133333393052E5A41CDCCCCCC3AED23419A9999F9FE2D5A41CDCCCCCC0BED234133333313F62D5A413333333303ED2341CDCCCC4CF42D5A4133333333EEEC23419A9999F9EF2D5A41000000007AEC234133333313F72D5A416666666676EC234166666646F72D5A410000000040EC234133333373FA2D5A41CDCCCCCC1AEC2341666666A6FC2D5A416666666610EC234100000040FD2D5A4166666666FBEB234166666666FE2D5A4166666666D5EB234133333373002E5A410000000055EB2341CDCCCC6C072E5A41000000002AEB2341CDCCCC6C092E5A41	01060000206A080000010000000103000000010000000B000000000000002AEB2341CDCCCC6C092E5A419A99999981EB23419A9999592A2E5A4133333333E1EB234100000000292E5A419A99999952EC2341000000A0242E5A4166666666F1EC2341666666061D2E5A4166666666B9ED2341CDCCCC8C142E5A41CDCCCCCC3AED23419A9999F9FE2D5A4133333333EEEC23419A9999F9EF2D5A416666666610EC234100000040FD2D5A41000000002AEB2341CDCCCC6C092E5A41000000002AEB2341CDCCCC6C092E5A41	01010000206A080000D4076CAB5BEC2341666666160C2E5A41	751030904	H	Arts et Métiers 4	7510309	75103	75	11	0
01060000206A080000010000000103000000010000002A0000003333333313E92341000000800E2E5A416666666657E9234133333333252E5A419A999999ACE923419A999999402E5A4133333333EEE92341CDCCCCAC562E5A4100000000FCE92341CDCCCC2C5B2E5A419A9999990FEA23419A999979612E5A416666666620EA2341333333F3662E5A413333333337EA2341666666A66E2E5A419A9999994EEA234166666686762E5A41000000005FEA2341CDCCCC0C7C2E5A410000000079EA23419A999999842E5A41333333338EEA2341CDCCCC2C8B2E5A419A9999998FEA2341CDCCCCAC8B2E5A4166666666AEEA234133333333962E5A4133333333C8EA234166666626952E5A416666666615EB23419A9999B9912E5A416666666633EB234133333353902E5A41666666665AEB2341000000608E2E5A413333333372EB2341CDCCCC4C8D2E5A416666666688EB2341000000608C2E5A419A9999997EEB2341333333D38B2E5A419A99999974EB23419A9999198B2E5A416666666669EB2341CDCCCC8C892E5A41CDCCCCCC58EB234100000000832E5A419A99999947EB2341666666467D2E5A413333333344EB2341CDCCCC2C7C2E5A41CDCCCCCC1CEB2341333333136F2E5A416666666608EB23419A999999682E5A41000000002BEB23419A9999D9672E5A419A999999B7EB2341000000E0612E5A419A99999921EC2341000000205D2E5A4166666666A5EB234133333373392E5A410000000073EB23419A9999D92B2E5A419A99999981EB23419A9999592A2E5A419A99999971EB2341000000E0232E5A41CDCCCCCC56EB23419A999939192E5A41CDCCCCCC54EB2341CDCCCC6C182E5A41000000002AEB2341CDCCCC6C092E5A41CDCCCCCC6DEA2341CDCCCC4C142E5A41000000001DEA2341CDCCCC8C192E5A419A99999963E92341666666C6112E5A413333333313E92341000000800E2E5A41	01060000206A08000001000000010300000001000000100000003333333313E92341000000800E2E5A419A999999ACE923419A999999402E5A4166666666AEEA234133333333962E5A416666666688EB2341000000608C2E5A416666666669EB2341CDCCCC8C892E5A416666666608EB23419A999999682E5A41000000002BEB23419A9999D9672E5A419A99999921EC2341000000205D2E5A4166666666A5EB234133333373392E5A410000000073EB23419A9999D92B2E5A419A99999981EB23419A9999592A2E5A41000000002AEB2341CDCCCC6C092E5A41CDCCCCCC6DEA2341CDCCCC4C142E5A41000000001DEA2341CDCCCC8C192E5A413333333313E92341000000800E2E5A413333333313E92341000000800E2E5A41	01010000206A080000FF042B0FD9EA2341343333A34B2E5A41	751030905	H	Arts et Métiers 5	7510309	75103	75	11	0
01060000206A08000001000000010300000001000000300000009A99999975EE2341666666C6332E5A41CDCCCCCC98EE2341000000E03A2E5A4100000000CAEE2341CDCCCCAC432E5A419A999999D4EE234133333353452E5A4100000000ECEE23419A9999F9482E5A41000000001CEF2341000000004F2E5A410000000030EF23419A9999594F2E5A410000000096EF2341666666A6562E5A41CDCCCCCCA1EF2341333333D3582E5A4166666666B0EF2341CDCCCCEC582E5A4100000000C9EF23419A9999D95A2E5A41CDCCCCCCEAEF23419A9999995D2E5A41CDCCCCCC2BF02341CDCCCC4C622E5A41666666662EF0234166666686622E5A413333333335F02341666666E6612E5A41CDCCCCCC35F023419A9999D9612E5A413333333341F02341CDCCCCCC602E5A410000000048F0234166666626602E5A416666666650F02341666666665F2E5A41CDCCCCCC57F023419A9999B95E2E5A41CDCCCCCC69F02341CDCCCC0C5D2E5A41CDCCCCCC6DF02341333333B35C2E5A41666666668DF023419A999939512E5A41666666669CF02341CDCCCC2C4C2E5A4100000000B3F02341000000A0432E5A41CDCCCCCCBCF02341000000203F2E5A4166666666C1F02341333333F33C2E5A419A999999DCF0234166666606342E5A419A999999EDF02341666666862E2E5A41CDCCCCCCFFF02341CDCCCCCC282E5A41666666660EF123419A999959242E5A4166666666F8F02341666666C6212E5A4133333333DDF02341333333D31D2E5A419A999999BEF0234133333353192E5A4100000000A7F02341CDCCCC0C162E5A413333333385F023419A999919142E5A410000000059F023419A9999B9122E5A41666666662AF023419A999939112E5A41CDCCCCCCE9EF2341333333730F2E5A4166666666B4EF234133333393152E5A41333333339CEF234166666606182E5A419A99999971EF2341CDCCCC4C1C2E5A41CDCCCCCC69EF2341666666061D2E5A41CDCCCCCC3AEF23419A9999D9202E5A413333333317EF234166666606242E5A41CDCCCCCCDCEE2341CDCCCCCC292E5A4133333333C8EE2341333333D32B2E5A419A99999975EE2341666666C6332E5A41	01060000206A08000001000000010300000001000000100000009A99999975EE2341666666C6332E5A4100000000ECEE23419A9999F9482E5A41000000001CEF2341000000004F2E5A410000000030EF23419A9999594F2E5A41666666662EF0234166666686622E5A41CDCCCCCC6DF02341333333B35C2E5A4100000000B3F02341000000A0432E5A4166666666C1F02341333333F33C2E5A41666666660EF123419A999959242E5A4100000000A7F02341CDCCCC0C162E5A413333333385F023419A999919142E5A41CDCCCCCCE9EF2341333333730F2E5A41CDCCCCCC69EF2341666666061D2E5A413333333317EF234166666606242E5A419A99999975EE2341666666C6332E5A419A99999975EE2341666666C6332E5A41	01010000206A08000027D3A5FDACEF234133333373372E5A41	751031001	H	Enfants Rouges 1	7510310	75103	75	11	0
01060000206A0800000100000001030000000100000023000000333333338FF02341CDCCCC6CB62D5A419A99999990F0234133333333BB2D5A416666666690F02341CDCCCC0CC42D5A416666666691F0234100000060C62D5A416666666694F0234133333333C92D5A41666666669AF023419A9999F9DD2D5A41666666669FF02341333333B3F12D5A4133333333A1F023419A9999B9F72D5A419A999999A5F02341CDCCCCAC072E5A419A999999A6F02341333333130E2E5A4133333333A7F0234100000040122E5A4100000000ABF02341000000E0122E5A4166666666ACF023419A999999132E5A41CDCCCCCCACF0234100000060142E5A41CDCCCCCCABF02341CDCCCC0C152E5A41CDCCCCCCA9F02341666666A6152E5A4100000000A7F02341CDCCCC0C162E5A419A999999BEF0234133333353192E5A4133333333DDF02341333333D31D2E5A4166666666F8F02341666666C6212E5A41666666660EF123419A999959242E5A41CDCCCCCC2BF123419A9999991A2E5A41CDCCCCCC43F12341CDCCCCEC122E5A41CDCCCCCC4AF12341CDCCCCAC102E5A410000000097F123419A999959F82D5A419A999999C3F1234133333333EA2D5A4166666666CCF12341CDCCCCACE62D5A419A999999D2F123419A9999B9E12D5A4100000000E0F12341666666E6D52D5A4133333333FDF1234100000040BE2D5A416666666605F2234166666666B72D5A419A99999912F22341000000A0AC2D5A4133333333FAF12341CDCCCCACAC2D5A4133333333E9F12341666666E6AC2D5A41333333338FF02341CDCCCC6CB62D5A41	01060000206A080000010000000103000000010000000A000000333333338FF02341CDCCCC6CB62D5A419A999999A5F02341CDCCCCAC072E5A4100000000A7F02341CDCCCC0C162E5A41666666660EF123419A999959242E5A419A999999C3F1234133333333EA2D5A4166666666CCF12341CDCCCCACE62D5A419A99999912F22341000000A0AC2D5A4133333333E9F12341666666E6AC2D5A41333333338FF02341CDCCCC6CB62D5A41333333338FF02341CDCCCC6CB62D5A41	01010000206A0800001EEDAA8632F1234100000070E82D5A41	751031002	H	Enfants Rouges 2	7510310	75103	75	11	0
01060000206A080000010000000103000000010000002A00000033333333EEEC23419A9999F9EF2D5A413333333303ED2341CDCCCC4CF42D5A41CDCCCCCC0BED234133333313F62D5A41CDCCCCCC3AED23419A9999F9FE2D5A416666666661ED234133333393052E5A419A99999994ED2341000000C00E2E5A41CDCCCCCCA2ED234133333333112E5A4100000000A9ED234100000060122E5A4133333333AEED23419A999939132E5A419A999999B0ED234166666686132E5A41CDCCCCCCB4ED23419A9999F9132E5A4166666666B9ED2341CDCCCC8C142E5A4100000000C8ED2341CDCCCCAC132E5A419A999999CDED2341666666E6122E5A419A99999911EE2341000000A0092E5A416666666683EE234100000020FA2D5A41333333338FEE2341000000C0F82D5A4100000000CBEE234133333313F12D5A419A999999D2EE234100000000F02D5A4166666666E2EE2341000000C0ED2D5A419A99999913EF2341CDCCCC4CE92D5A419A9999991DEF23419A999959E82D5A416666666665EF2341CDCCCCECE12D5A419A9999996AEF234133333373E12D5A4166666666AEEF2341333333D3DA2D5A41CDCCCCCCD6EF2341666666E6D62D5A41CDCCCCCC0FF02341CDCCCC4CD12D5A413333333377F0234133333313C72D5A416666666691F0234100000060C62D5A416666666690F02341CDCCCC0CC42D5A419A99999990F0234133333333BB2D5A41333333338FF02341CDCCCC6CB62D5A419A999999FDEF23419A999959BA2D5A4133333333BDEF234166666606BC2D5A410000000041EF23419A999979BF2D5A41CDCCCCCCB4EE234100000040C32D5A4133333333A9EE234166666646C32D5A4100000000A0EE234100000000C42D5A41000000002EEE23419A999979D02D5A4100000000CDED2341000000A0DA2D5A41666666662FED234100000020EB2D5A4133333333EEEC23419A9999F9EF2D5A41	01060000206A080000010000000103000000010000000F00000033333333EEEC23419A9999F9EF2D5A41CDCCCCCC3AED23419A9999F9FE2D5A4133333333AEED23419A999939132E5A4100000000C8ED2341CDCCCCAC132E5A416666666683EE234100000020FA2D5A4166666666E2EE2341000000C0ED2D5A419A9999996AEF234133333373E12D5A413333333377F0234133333313C72D5A416666666691F0234100000060C62D5A41333333338FF02341CDCCCC6CB62D5A4100000000A0EE234100000000C42D5A41000000002EEE23419A999979D02D5A41666666662FED234100000020EB2D5A4133333333EEEC23419A9999F9EF2D5A4133333333EEEC23419A9999F9EF2D5A41	01010000206A080000B1307B0B55EE234134333323E52D5A41	751031003	H	Enfants Rouges 3	7510310	75103	75	11	0
01060000206A080000010000000103000000010000003300000066666666B9ED2341CDCCCC8C142E5A4133333333C5ED2341666666C6152E5A419A999999D6ED23419A999939182E5A4100000000E7ED2341333333D31A2E5A4166666666FBED23419A9999191E2E5A413333333314EE234166666646222E5A41CDCCCCCC34EE234100000060282E5A419A99999975EE2341666666C6332E5A4133333333C8EE2341333333D32B2E5A41CDCCCCCCDCEE2341CDCCCCCC292E5A413333333317EF234166666606242E5A41CDCCCCCC3AEF23419A9999D9202E5A41CDCCCCCC69EF2341666666061D2E5A419A99999971EF2341CDCCCC4C1C2E5A41333333339CEF234166666606182E5A4166666666B4EF234133333393152E5A41CDCCCCCCE9EF2341333333730F2E5A41666666662AF023419A999939112E5A410000000059F023419A9999B9122E5A413333333385F023419A999919142E5A4100000000A7F02341CDCCCC0C162E5A41CDCCCCCCA9F02341666666A6152E5A41CDCCCCCCABF02341CDCCCC0C152E5A41CDCCCCCCACF0234100000060142E5A4166666666ACF023419A999999132E5A4100000000ABF02341000000E0122E5A4133333333A7F0234100000040122E5A419A999999A6F02341333333130E2E5A419A999999A5F02341CDCCCCAC072E5A4133333333A1F023419A9999B9F72D5A41666666669FF02341333333B3F12D5A41666666669AF023419A9999F9DD2D5A416666666694F0234133333333C92D5A416666666691F0234100000060C62D5A413333333377F0234133333313C72D5A41CDCCCCCC0FF02341CDCCCC4CD12D5A41CDCCCCCCD6EF2341666666E6D62D5A4166666666AEEF2341333333D3DA2D5A419A9999996AEF234133333373E12D5A416666666665EF2341CDCCCCECE12D5A419A9999991DEF23419A999959E82D5A419A99999913EF2341CDCCCC4CE92D5A4166666666E2EE2341000000C0ED2D5A419A999999D2EE234100000000F02D5A4100000000CBEE234133333313F12D5A41333333338FEE2341000000C0F82D5A416666666683EE234100000020FA2D5A419A99999911EE2341000000A0092E5A419A999999CDED2341666666E6122E5A4100000000C8ED2341CDCCCCAC132E5A4166666666B9ED2341CDCCCC8C142E5A41	01060000206A080000010000000103000000010000001100000066666666B9ED2341CDCCCC8C142E5A413333333314EE234166666646222E5A419A99999975EE2341666666C6332E5A413333333317EF234166666606242E5A41CDCCCCCC69EF2341666666061D2E5A41CDCCCCCCE9EF2341333333730F2E5A413333333385F023419A999919142E5A4100000000A7F02341CDCCCC0C162E5A419A999999A5F02341CDCCCCAC072E5A416666666694F0234133333333C92D5A413333333377F0234133333313C72D5A419A9999996AEF234133333373E12D5A4166666666E2EE2341000000C0ED2D5A416666666683EE234100000020FA2D5A4100000000C8ED2341CDCCCCAC132E5A4166666666B9ED2341CDCCCC8C142E5A4166666666B9ED2341CDCCCC8C142E5A41	01010000206A080000FC90D8B17AEF2341666666E6002E5A41	751031004	H	Enfants Rouges 4	7510310	75103	75	11	0
01060000206A080000010000000103000000010000001B0000009A99999976F023419A9999395E2D5A41000000007CF02341333333B3702D5A419A99999980F02341CDCCCC2C822D5A419A99999984F02341666666A6902D5A410000000085F0234133333333912D5A410000000086F0234166666646952D5A419A99999987F02341CDCCCC2C9B2D5A41333333338FF02341CDCCCC6CB62D5A4133333333E9F12341666666E6AC2D5A4133333333FAF12341CDCCCCACAC2D5A419A99999912F22341000000A0AC2D5A41333333331DF22341000000C0A32D5A413333333330F22341333333F3932D5A41CDCCCCCC44F22341CDCCCC8C822D5A41333333334CF22341666666667C2D5A41CDCCCCCC63F2234133333333692D5A416666666648F22341666666C6682D5A41666666660DF2234166666626672D5A413333333305F22341CDCCCCCC662D5A410000000000F223419A999939662D5A4166666666FEF12341CDCCCCAC652D5A4166666666FEF12341666666A6642D5A41000000001FF2234133333373512D5A410000000095F12341666666C6552D5A41000000000BF12341333333535A2D5A419A99999988F02341333333535E2D5A419A99999976F023419A9999395E2D5A41	01060000206A080000010000000103000000010000000B0000009A99999976F023419A9999395E2D5A41333333338FF02341CDCCCC6CB62D5A4133333333E9F12341666666E6AC2D5A419A99999912F22341000000A0AC2D5A41CDCCCCCC63F2234133333333692D5A41666666660DF2234166666626672D5A4166666666FEF12341666666A6642D5A41000000001FF2234133333373512D5A419A99999988F02341333333535E2D5A419A99999976F023419A9999395E2D5A419A99999976F023419A9999395E2D5A41	01010000206A0800008A37798D5FF123419A999999892D5A41	751031101	H	Les Archives 1	7510311	75103	75	11	0
01060000206A080000010000000103000000010000001C000000666666665BF02341CDCCCC0C2F2D5A41666666666CF0234133333313352D5A41333333336FF0234133333353402D5A410000000072F02341000000404B2D5A419A99999976F023419A9999395E2D5A419A99999988F02341333333535E2D5A41000000000BF12341333333535A2D5A410000000095F12341666666C6552D5A41000000001FF2234133333373512D5A4166666666FEF12341666666A6642D5A4166666666FEF12341CDCCCCAC652D5A410000000000F223419A999939662D5A413333333305F22341CDCCCCCC662D5A41666666660DF2234166666626672D5A416666666648F22341666666C6682D5A41CDCCCCCC63F2234133333333692D5A416666666683F22341333333534E2D5A41CDCCCCCC9AF223419A9999F93B2D5A4133333333BFF22341CDCCCC4C1C2D5A4100000000A0F22341666666C61B2D5A413333333315F2234166666646202D5A4166666666D1F12341666666A6222D5A4100000000ABF123419A9999B9232D5A41CDCCCCCC2FF1234166666646272D5A4133333333B7F02341000000C02A2D5A410000000095F02341000000602C2D5A41666666666CF023419A9999392E2D5A41666666665BF02341CDCCCC0C2F2D5A41	01060000206A080000010000000103000000010000000E000000666666665BF02341CDCCCC0C2F2D5A41666666666CF0234133333313352D5A419A99999976F023419A9999395E2D5A419A99999988F02341333333535E2D5A41000000001FF2234133333373512D5A4166666666FEF12341666666A6642D5A41666666660DF2234166666626672D5A41CDCCCCCC63F2234133333333692D5A4133333333BFF22341CDCCCC4C1C2D5A4100000000A0F22341666666C61B2D5A4166666666D1F12341666666A6222D5A4133333333B7F02341000000C02A2D5A41666666665BF02341CDCCCC0C2F2D5A41666666665BF02341CDCCCC0C2F2D5A41	01010000206A0800004C178B717FF123419A9999C9452D5A41	751031102	H	Les Archives 2	7510311	75103	75	11	0
01060000206A0800000100000001030000000100000022000000CDCCCCCC1CEC2341333333F3942D5A413333333370EC2341CDCCCC8CA22D5A41CDCCCCCCE0EC2341000000E0B42D5A410000000086ED234100000040A42D5A41CDCCCCCCBFED2341000000E09E2D5A4133333333E6ED2341CDCCCC4C9B2D5A41666666665AEE2341000000A0902D5A4166666666FDEE23419A9999997F2D5A416666666621EF2341333333D37B2D5A416666666626EF234100000080772D5A41CDCCCCCC2BEF23419A9999B9742D5A41CDCCCCCC2EEF2341CDCCCC0C742D5A413333333335EF234133333333732D5A413333333386EF2341000000C06D2D5A41CDCCCCCC19F02341666666C6632D5A41CDCCCCCC66F02341333333935E2D5A419A99999976F023419A9999395E2D5A410000000072F02341000000404B2D5A41333333336FF0234133333353402D5A41666666666CF0234133333313352D5A41666666665BF02341CDCCCC0C2F2D5A410000000087EF2341333333933B2D5A4133333333E7EE234166666646452D5A419A99999955EE2341CDCCCC6C512D5A419A99999945EE23419A9999D9522D5A41CDCCCCCC88ED2341000000C0632D5A419A99999985ED23419A999919642D5A419A99999943ED23419A9999996B2D5A413333333332ED2341CDCCCC8C6D2D5A4166666666EAEC23419A999919782D5A4100000000CBEC2341333333B37C2D5A41666666665AEC2341000000408D2D5A410000000033EC2341000000C0922D5A41CDCCCCCC1CEC2341333333F3942D5A41	01060000206A0800000100000001030000000100000011000000CDCCCCCC1CEC2341333333F3942D5A41CDCCCCCCE0EC2341000000E0B42D5A410000000086ED234100000040A42D5A41666666665AEE2341000000A0902D5A416666666621EF2341333333D37B2D5A413333333335EF234133333333732D5A41CDCCCCCC66F02341333333935E2D5A419A99999976F023419A9999395E2D5A41666666666CF0234133333313352D5A41666666665BF02341CDCCCC0C2F2D5A4133333333E7EE234166666646452D5A419A99999955EE2341CDCCCC6C512D5A41CDCCCCCC88ED2341000000C0632D5A413333333332ED2341CDCCCC8C6D2D5A41666666665AEC2341000000408D2D5A41CDCCCCCC1CEC2341333333F3942D5A41CDCCCCCC1CEC2341333333F3942D5A41	01010000206A080000F99426FF3DEE23419A999979702D5A41	751031103	H	Les Archives 3	7510311	75103	75	11	0
01060000206A0800000100000001030000000100000020000000CDCCCCCCE0EC2341000000E0B42D5A4133333333CAED2341CDCCCC2CDA2D5A4100000000CDED2341000000A0DA2D5A41000000002EEE23419A999979D02D5A4100000000A0EE234100000000C42D5A4133333333A9EE234166666646C32D5A41CDCCCCCCB4EE234100000040C32D5A410000000041EF23419A999979BF2D5A4133333333BDEF234166666606BC2D5A419A999999FDEF23419A999959BA2D5A41333333338FF02341CDCCCC6CB62D5A419A99999987F02341CDCCCC2C9B2D5A410000000086F0234166666646952D5A410000000085F0234133333333912D5A419A99999984F02341666666A6902D5A419A99999980F02341CDCCCC2C822D5A41000000007CF02341333333B3702D5A419A99999976F023419A9999395E2D5A41CDCCCCCC66F02341333333935E2D5A41CDCCCCCC19F02341666666C6632D5A413333333386EF2341000000C06D2D5A413333333335EF234133333333732D5A41CDCCCCCC2EEF2341CDCCCC0C742D5A41CDCCCCCC2BEF23419A9999B9742D5A416666666626EF234100000080772D5A416666666621EF2341333333D37B2D5A4166666666FDEE23419A9999997F2D5A41666666665AEE2341000000A0902D5A4133333333E6ED2341CDCCCC4C9B2D5A41CDCCCCCCBFED2341000000E09E2D5A410000000086ED234100000040A42D5A41CDCCCCCCE0EC2341000000E0B42D5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCCE0EC2341000000E0B42D5A4100000000CDED2341000000A0DA2D5A4100000000A0EE234100000000C42D5A41333333338FF02341CDCCCC6CB62D5A419A99999976F023419A9999395E2D5A41CDCCCCCC66F02341333333935E2D5A413333333335EF234133333333732D5A416666666621EF2341333333D37B2D5A41666666665AEE2341000000A0902D5A410000000086ED234100000040A42D5A41CDCCCCCCE0EC2341000000E0B42D5A41CDCCCCCCE0EC2341000000E0B42D5A41	01010000206A080000241213912DEF2341666666169D2D5A41	751031104	H	Les Archives 4	7510311	75103	75	11	0
01060000206A080000010000000103000000010000001700000000000000A9EA23419A9999B9DE2D5A4166666666D3EA234100000060EC2D5A413333333301EB234100000020FB2D5A41000000002AEB2341CDCCCC6C092E5A410000000055EB2341CDCCCC6C072E5A4166666666D5EB234133333373002E5A4166666666FBEB234166666666FE2D5A416666666610EC234100000040FD2D5A41CDCCCCCC1AEC2341666666A6FC2D5A410000000040EC234133333373FA2D5A416666666676EC234166666646F72D5A41000000007AEC234133333313F72D5A4133333333EEEC23419A9999F9EF2D5A41666666662FED234100000020EB2D5A4100000000CDED2341000000A0DA2D5A4133333333CAED2341CDCCCC2CDA2D5A41CDCCCCCCE0EC2341000000E0B42D5A41333333337DEC23419A9999F9BF2D5A41CDCCCCCC59EC234100000020C32D5A413333333329EC23419A999979C72D5A41333333338BEB234133333333D32D5A41333333335CEB2341CDCCCC6CD52D5A4100000000A9EA23419A9999B9DE2D5A41	01060000206A080000010000000103000000010000000D00000000000000A9EA23419A9999B9DE2D5A413333333301EB234100000020FB2D5A41000000002AEB2341CDCCCC6C092E5A416666666610EC234100000040FD2D5A4133333333EEEC23419A9999F9EF2D5A41666666662FED234100000020EB2D5A4100000000CDED2341000000A0DA2D5A41CDCCCCCCE0EC2341000000E0B42D5A41333333337DEC23419A9999F9BF2D5A413333333329EC23419A999979C72D5A41333333338BEB234133333333D32D5A4100000000A9EA23419A9999B9DE2D5A4100000000A9EA23419A9999B9DE2D5A41	01010000206A080000945E627013EC2341CDCCCCECE42D5A41	751031201	H	Sainte-Avoye 1	7510312	75103	75	11	0
01060000206A08000001000000010300000001000000130000003333333331EA23419A9999D9B42D5A410000000043EA23419A999919BB2D5A41333333334EEA234166666606BF2D5A41666666665BEA2341CDCCCCACC32D5A416666666671EA234166666666CB2D5A4166666666A1EA23419A999959DC2D5A4100000000A9EA23419A9999B9DE2D5A41333333335CEB2341CDCCCC6CD52D5A41333333338BEB234133333333D32D5A413333333329EC23419A999979C72D5A41CDCCCCCC59EC234100000020C32D5A41333333337DEC23419A9999F9BF2D5A41CDCCCCCCE0EC2341000000E0B42D5A413333333370EC2341CDCCCC8CA22D5A41CDCCCCCC1CEC2341333333F3942D5A41000000000BEC23419A9999B9962D5A41CDCCCCCCCBEB2341000000C09A2D5A41CDCCCCCC21EB234133333393A52D5A413333333331EA23419A9999D9B42D5A41	01060000206A080000010000000103000000010000000A0000003333333331EA23419A9999D9B42D5A4100000000A9EA23419A9999B9DE2D5A41333333338BEB234133333333D32D5A413333333329EC23419A999979C72D5A41333333337DEC23419A9999F9BF2D5A41CDCCCCCCE0EC2341000000E0B42D5A41CDCCCCCC1CEC2341333333F3942D5A41000000000BEC23419A9999B9962D5A413333333331EA23419A9999D9B42D5A413333333331EA23419A9999D9B42D5A41	01010000206A0800005AA3EC807FEB2341CDCCCCFCB72D5A41	751031202	H	Sainte-Avoye 2	7510312	75103	75	11	0
01060000206A08000001000000010300000001000000180000003333333349E82341333333D3CA2D5A41CDCCCCCC4CE8234100000000CC2D5A41CDCCCCCC72E8234133333353D82D5A410000000099E823419A9999D9E42D5A41CDCCCCCCBFE8234133333313F22D5A413333333323E9234133333373ED2D5A41666666669AE92341CDCCCCCCE72D5A419A999999D1E9234166666666E52D5A41666666661BEA234133333333E22D5A410000000054EA23419A9999B9DF2D5A416666666658EA234166666686DF2D5A4166666666A1EA23419A999959DC2D5A416666666671EA234166666666CB2D5A41666666665BEA2341CDCCCCACC32D5A41333333334EEA234166666606BF2D5A410000000043EA23419A999919BB2D5A413333333331EA23419A9999D9B42D5A419A9999991BEA2341333333D3B52D5A4133333333A9E9234166666606BB2D5A419A9999995EE9234166666666BE2D5A410000000030E9234100000080C02D5A41CDCCCCCC22E9234133333313C12D5A419A999999B2E8234166666606C62D5A413333333349E82341333333D3CA2D5A41	01060000206A08000001000000010300000001000000070000003333333349E82341333333D3CA2D5A41CDCCCCCCBFE8234133333313F22D5A41666666669AE92341CDCCCCCCE72D5A4166666666A1EA23419A999959DC2D5A413333333331EA23419A9999D9B42D5A413333333349E82341333333D3CA2D5A413333333349E82341333333D3CA2D5A41	01010000206A080000944CDB2C72E923419A999929D22D5A41	751031203	H	Sainte-Avoye 3	7510312	75103	75	11	0
01060000206A0800000100000001030000000100000012000000CDCCCCCCBFE8234133333313F22D5A4100000000FDE8234133333333072E5A413333333313E92341000000800E2E5A419A99999963E92341666666C6112E5A41000000001DEA2341CDCCCC8C192E5A41CDCCCCCC6DEA2341CDCCCC4C142E5A41000000002AEB2341CDCCCC6C092E5A413333333301EB234100000020FB2D5A4166666666D3EA234100000060EC2D5A4100000000A9EA23419A9999B9DE2D5A4166666666A1EA23419A999959DC2D5A416666666658EA234166666686DF2D5A410000000054EA23419A9999B9DF2D5A41666666661BEA234133333333E22D5A419A999999D1E9234166666666E52D5A41666666669AE92341CDCCCCCCE72D5A413333333323E9234133333373ED2D5A41CDCCCCCCBFE8234133333313F22D5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCCBFE8234133333313F22D5A413333333313E92341000000800E2E5A41000000001DEA2341CDCCCC8C192E5A41CDCCCCCC6DEA2341CDCCCC4C142E5A41000000002AEB2341CDCCCC6C092E5A413333333301EB234100000020FB2D5A4166666666A1EA23419A999959DC2D5A41666666669AE92341CDCCCCCCE72D5A41CDCCCCCCBFE8234133333313F22D5A41CDCCCCCCBFE8234133333313F22D5A41	01010000206A08000095558007E0E923419A999999F62D5A41	751031204	H	Sainte-Avoye 4	7510312	75103	75	11	0
01060000206A080000010000000103000000010000001100000033333333E4E923419A9999B95A2D5A41CDCCCCCC06EA2341333333D3632D5A41000000004FEA2341CDCCCC4C782D5A416666666681EA234133333333862D5A4133333333AAEA2341666666068F2D5A4100000000B4EA23419A999919912D5A4100000000FAEA23419A9999199E2D5A41CDCCCCCC21EB234133333393A52D5A41CDCCCCCCCBEB2341000000C09A2D5A41000000000BEC23419A9999B9962D5A41CDCCCCCC1CEC2341333333F3942D5A419A999999B0EB234133333313812D5A413333333375EB234133333333762D5A41333333332EEB234133333333692D5A41CDCCCCCCF6EA2341CDCCCC2C5F2D5A41CDCCCCCC96EA23419A9999D94D2D5A4133333333E4E923419A9999B95A2D5A41	01060000206A080000010000000103000000010000001100000033333333E4E923419A9999B95A2D5A41CDCCCCCC06EA2341333333D3632D5A41000000004FEA2341CDCCCC4C782D5A416666666681EA234133333333862D5A4133333333AAEA2341666666068F2D5A4100000000B4EA23419A999919912D5A4100000000FAEA23419A9999199E2D5A41CDCCCCCC21EB234133333393A52D5A41CDCCCCCCCBEB2341000000C09A2D5A41000000000BEC23419A9999B9962D5A41CDCCCCCC1CEC2341333333F3942D5A419A999999B0EB234133333313812D5A413333333375EB234133333333762D5A41333333332EEB234133333333692D5A41CDCCCCCCF6EA2341CDCCCC2C5F2D5A41CDCCCCCC96EA23419A9999D94D2D5A4133333333E4E923419A9999B95A2D5A41	01010000206A0800003B6B9BC5FBEA2341000000B07C2D5A41	751041301	H	Saint-Merri 1	7510413	75104	75	11	0
01060000206A080000010000000103000000010000002600000033333333EEE72341000000C05D2D5A41CDCCCCCCFFE72341000000A0632D5A410000000016E82341333333136B2D5A41CDCCCCCC18E82341CDCCCC0C6C2D5A41000000003FE8234133333393782D5A419A9999994BE82341CDCCCCAC772D5A410000000075E8234133333353822D5A419A99999977E82341CDCCCC4C832D5A419A99999995E82341333333138E2D5A416666666698E823419A9999398F2D5A4166666666B1E8234100000020982D5A41CDCCCCCCB1E8234100000040982D5A4166666666B4E8234166666646992D5A4100000000C1E82341000000C09D2D5A4100000000F7E82341CDCCCC2CB02D5A416666666621E9234133333393BF2D5A41CDCCCCCC22E9234133333313C12D5A410000000030E9234100000080C02D5A419A9999995EE9234166666666BE2D5A4133333333A9E9234166666606BB2D5A419A9999991BEA2341333333D3B52D5A413333333331EA23419A9999D9B42D5A41CDCCCCCC21EB234133333393A52D5A4100000000FAEA23419A9999199E2D5A4100000000B4EA23419A999919912D5A4133333333AAEA2341666666068F2D5A416666666681EA234133333333862D5A41000000004FEA2341CDCCCC4C782D5A41CDCCCCCC06EA2341333333D3632D5A4133333333E4E923419A9999B95A2D5A419A99999986E92341000000C0472D5A419A999999FDE82341333333734E2D5A419A999999EEE82341CDCCCC4C4F2D5A416666666646E82341000000E0582D5A410000000033E823419A9999F9592D5A410000000008E82341CDCCCC6C5C2D5A4166666666F4E72341333333535D2D5A4133333333EEE72341000000C05D2D5A41	01060000206A080000010000000103000000010000000F00000033333333EEE72341000000C05D2D5A41000000003FE8234133333393782D5A419A9999994BE82341CDCCCCAC772D5A410000000075E8234133333353822D5A4100000000F7E82341CDCCCC2CB02D5A41CDCCCCCC22E9234133333313C12D5A413333333331EA23419A9999D9B42D5A41CDCCCCCC21EB234133333393A52D5A4100000000B4EA23419A999919912D5A416666666681EA234133333333862D5A4133333333E4E923419A9999B95A2D5A419A99999986E92341000000C0472D5A419A999999FDE82341333333734E2D5A4133333333EEE72341000000C05D2D5A4133333333EEE72341000000C05D2D5A41	01010000206A080000DCEAC8E37BE92341000000C0842D5A41	751041302	H	Saint-Merri 2	7510413	75104	75	11	0
01060000206A08000001000000010300000001000000210000000000000026E72341333333B36A2D5A41333333332AE72341666666266C2D5A410000000038E72341333333B3702D5A419A9999997AE72341333333D3862D5A4100000000A8E72341666666E6952D5A4166666666D2E72341333333B3A32D5A416666666605E823419A9999B9B42D5A41333333330BE82341666666A6B62D5A413333333349E82341333333D3CA2D5A419A999999B2E8234166666606C62D5A41CDCCCCCC22E9234133333313C12D5A416666666621E9234133333393BF2D5A4100000000F7E82341CDCCCC2CB02D5A4100000000C1E82341000000C09D2D5A4166666666B4E8234166666646992D5A41CDCCCCCCB1E8234100000040982D5A4166666666B1E8234100000020982D5A416666666698E823419A9999398F2D5A419A99999995E82341333333138E2D5A419A99999977E82341CDCCCC4C832D5A410000000075E8234133333353822D5A419A9999994BE82341CDCCCCAC772D5A41000000003FE8234133333393782D5A41CDCCCCCC18E82341CDCCCC0C6C2D5A410000000016E82341333333136B2D5A41CDCCCCCCFFE72341000000A0632D5A4133333333EEE72341000000C05D2D5A4100000000E2E72341666666865E2D5A4166666666C8E72341CDCCCC2C602D5A419A999999A4E7234100000080622D5A419A9999993AE723419A999959692D5A41333333332FE723419A9999196A2D5A410000000026E72341333333B36A2D5A41	01060000206A080000010000000103000000010000000A0000000000000026E72341333333B36A2D5A413333333349E82341333333D3CA2D5A41CDCCCCCC22E9234133333313C12D5A4100000000F7E82341CDCCCC2CB02D5A410000000075E8234133333353822D5A419A9999994BE82341CDCCCCAC772D5A41000000003FE8234133333393782D5A4133333333EEE72341000000C05D2D5A410000000026E72341333333B36A2D5A410000000026E72341333333B36A2D5A41	01010000206A080000350BA4DC1FE8234100000090922D5A41	751041303	H	Saint-Merri 3	7510413	75104	75	11	0
01060000206A080000010000000103000000010000003000000066666666A0E62341333333B3452D5A4133333333BCE62341CDCCCC0C492D5A419A999999C4E623419A9999994A2D5A4133333333E4E623419A9999D9542D5A4133333333EEE6234133333333582D5A410000000006E723419A999919602D5A41000000001FE7234166666666682D5A410000000026E72341333333B36A2D5A41333333332FE723419A9999196A2D5A419A9999993AE723419A999959692D5A419A999999A4E7234100000080622D5A4166666666C8E72341CDCCCC2C602D5A4100000000E2E72341666666865E2D5A4133333333EEE72341000000C05D2D5A4166666666F4E72341333333535D2D5A410000000008E82341CDCCCC6C5C2D5A410000000033E823419A9999F9592D5A416666666646E82341000000E0582D5A419A999999EEE82341CDCCCC4C4F2D5A419A999999FDE82341333333734E2D5A419A99999986E92341000000C0472D5A416666666649EA2341000000603E2D5A41CDCCCCCC11EA2341333333F32A2D5A410000000008EA234166666686272D5A419A99999904EA2341666666A6242D5A4133333333FEE923419A999999222D5A4166666666E8E92341666666661B2D5A419A999999DEE923419A9999F9172D5A41CDCCCCCCD4E9234100000020162D5A4166666666C1E92341333333F3132D5A419A999999B2E92341333333F3112D5A41CDCCCCCCA2E923419A9999B90F2D5A419A99999985E9234100000080122D5A41CDCCCCCC74E92341333333D3132D5A41000000006BE9234133333393142D5A413333333353E9234133333373162D5A416666666647E92341000000A0182D5A419A99999928E92341CDCCCC0C1B2D5A416666666607E92341666666861D2D5A4100000000E2E82341CDCCCC4C202D5A4100000000D2E8234133333373212D5A41666666668BE82341CDCCCC4C262D5A41CDCCCCCCDCE7234166666646322D5A4100000000B8E723419A9999F9342D5A41CDCCCCCC89E72341CDCCCC6C382D5A419A99999942E72341000000A03C2D5A41CDCCCCCC25E723419A9999593E2D5A4166666666A0E62341333333B3452D5A41	01060000206A080000010000000103000000010000000E00000066666666A0E62341333333B3452D5A419A999999C4E623419A9999994A2D5A410000000026E72341333333B36A2D5A4166666666F4E72341333333535D2D5A419A999999FDE82341333333734E2D5A416666666649EA2341000000603E2D5A419A999999DEE923419A9999F9172D5A41CDCCCCCCA2E923419A9999B90F2D5A416666666647E92341000000A0182D5A4100000000D2E8234133333373212D5A41CDCCCCCCDCE7234166666646322D5A41CDCCCCCC89E72341CDCCCC6C382D5A4166666666A0E62341333333B3452D5A4166666666A0E62341333333B3452D5A41	01010000206A08000054CDA487BDE82341CDCCCC7C3D2D5A41	751041304	A	Saint-Merri 4	7510413	75104	75	11	0
01060000206A08000001000000010300000001000000080000009A99999986E92341000000C0472D5A4133333333E4E923419A9999B95A2D5A41CDCCCCCC96EA23419A9999D94D2D5A416666666691EA2341666666064D2D5A41333333338CEA2341CDCCCCEC4B2D5A410000000063EA2341000000403D2D5A416666666649EA2341000000603E2D5A419A99999986E92341000000C0472D5A41	01060000206A08000001000000010300000001000000060000009A99999986E92341000000C0472D5A4133333333E4E923419A9999B95A2D5A41CDCCCCCC96EA23419A9999D94D2D5A410000000063EA2341000000403D2D5A419A99999986E92341000000C0472D5A419A99999986E92341000000C0472D5A41	01010000206A0800000FAF8F5A16EA23419A9999794C2D5A41	751041305	A	Saint-Merri 5	7510413	75104	75	11	0
01060000206A080000010000000103000000010000001B0000003333333350E62341333333B3382D5A41CDCCCCCC74E62341333333D3432D5A419A9999997AE62341000000A0452D5A410000000081E6234166666666472D5A4166666666A0E62341333333B3452D5A41CDCCCCCC25E723419A9999593E2D5A419A99999942E72341000000A03C2D5A41CDCCCCCC89E72341CDCCCC6C382D5A4100000000B8E723419A9999F9342D5A41CDCCCCCCDCE7234166666646322D5A41666666668BE82341CDCCCC4C262D5A4100000000D2E8234133333373212D5A4100000000E2E82341CDCCCC4C202D5A416666666607E92341666666861D2D5A419A99999928E92341CDCCCC0C1B2D5A416666666647E92341000000A0182D5A413333333353E9234133333373162D5A41000000006BE9234133333393142D5A41CDCCCCCC74E92341333333D3132D5A419A99999985E9234100000080122D5A41CDCCCCCCA2E923419A9999B90F2D5A413333333396E92341CDCCCC4C082D5A413333333382E9234166666666FC2C5A4100000000AFE823419A999999112D5A4100000000C7E723419A999939232D5A416666666659E6234166666646382D5A413333333350E62341333333B3382D5A41	01060000206A080000010000000103000000010000000C0000003333333350E62341333333B3382D5A410000000081E6234166666666472D5A41CDCCCCCC89E72341CDCCCC6C382D5A41CDCCCCCCDCE7234166666646322D5A4100000000D2E8234133333373212D5A416666666647E92341000000A0182D5A41CDCCCCCCA2E923419A9999B90F2D5A413333333382E9234166666666FC2C5A4100000000AFE823419A999999112D5A4100000000C7E723419A999939232D5A413333333350E62341333333B3382D5A413333333350E62341333333B3382D5A41	01010000206A0800005473B0E14BE8234166666656222D5A41	751041399	D	Seine et Berges 1	7510413	75104	75	11	0
01060000206A0800000100000001030000000100000037000000CDCCCCCCA2E923419A9999B90F2D5A419A999999B2E92341333333F3112D5A4166666666C1E92341333333F3132D5A41CDCCCCCCD4E9234100000020162D5A419A999999DEE923419A9999F9172D5A4166666666E8E92341666666661B2D5A4133333333FEE923419A999999222D5A419A99999904EA2341666666A6242D5A410000000008EA234166666686272D5A41CDCCCCCC11EA2341333333F32A2D5A416666666649EA2341000000603E2D5A410000000063EA2341000000403D2D5A413333333303EB234166666626362D5A41CDCCCCCC46EB234166666626332D5A41000000005BEB234100000040322D5A41CDCCCCCC5BEB234133333333322D5A410000000062EB2341333333F3312D5A4133333333F1EB23419A9999992B2D5A41CDCCCCCC3AEC2341666666C6272D5A41CDCCCCCCB9EC2341CDCCCC8C212D5A41000000004DED23419A9999F91A2D5A4100000000B4ED234100000000162D5A41CDCCCCCCEDED23419A9999D9132D5A416666666683EE2341333333530D2D5A41CDCCCCCCD5EE2341333333B3082D5A419A99999941EF234133333393002D5A419A99999974EF23419A9999B9FC2C5A419A9999994CEF234100000040F62C5A41666666663CEF234100000020F22C5A41000000002FEF2341333333B3EE2C5A410000000014EF234100000020E92C5A41333333330CEF234133333373E72C5A4166666666ECEE234100000000E02C5A4133333333D6EE234166666606DC2C5A41CDCCCCCC83EE2341CDCCCC4CCE2C5A413333333380EE2341CDCCCCCCCD2C5A41CDCCCCCC69EE23419A999999CA2C5A416666666659EE23419A999939C82C5A41666666663DEE2341666666C6C32C5A419A9999992FEE23419A999919C12C5A419A9999992BEE2341666666E6BF2C5A41CDCCCCCC22EE234133333393BD2C5A416666666611EE234133333393BE2C5A419A99999900EE2341CDCCCC8CBF2C5A419A999999C0ED2341CDCCCC0CC42C5A419A99999950ED2341333333F3CB2C5A419A99999946ED234133333333CD2C5A419A9999999BEC2341000000C0D82C5A41CDCCCCCCE4EB234100000080E52C5A41000000006EEB2341CDCCCC6CED2C5A4100000000F8EA234166666666F62C5A413333333329EA234100000040062D5A41CDCCCCCCEDE92341666666E60A2D5A41CDCCCCCCCEE92341CDCCCC4C0C2D5A41CDCCCCCCA2E923419A9999B90F2D5A41	01060000206A0800000100000001030000000100000014000000CDCCCCCCA2E923419A9999B90F2D5A419A999999DEE923419A9999F9172D5A416666666649EA2341000000603E2D5A4133333333F1EB23419A9999992B2D5A41CDCCCCCCB9EC2341CDCCCC8C212D5A4100000000B4ED234100000000162D5A416666666683EE2341333333530D2D5A41CDCCCCCCD5EE2341333333B3082D5A419A99999974EF23419A9999B9FC2C5A419A9999994CEF234100000040F62C5A4166666666ECEE234100000000E02C5A41CDCCCCCC83EE2341CDCCCC4CCE2C5A419A9999992FEE23419A999919C12C5A41CDCCCCCC22EE234133333393BD2C5A419A99999950ED2341333333F3CB2C5A419A99999946ED234133333333CD2C5A41000000006EEB2341CDCCCC6CED2C5A41CDCCCCCCEDE92341666666E60A2D5A41CDCCCCCCA2E923419A9999B90F2D5A41CDCCCCCCA2E923419A9999B90F2D5A41	01010000206A08000034E0D4BAF3EC2341666666A6FE2C5A41	751041401	H	Saint-Gervais 1	7510414	75104	75	11	0
01060000206A08000001000000010300000001000000210000000000000063EA2341000000403D2D5A41333333338CEA2341CDCCCCEC4B2D5A416666666691EA2341666666064D2D5A41CDCCCCCC96EA23419A9999D94D2D5A41CDCCCCCCF6EA2341CDCCCC2C5F2D5A41333333332EEB234133333333692D5A413333333375EB234133333333762D5A419A999999B0EB234133333313812D5A41CDCCCCCC1CEC2341333333F3942D5A410000000033EC2341000000C0922D5A41666666665AEC2341000000408D2D5A4100000000CBEC2341333333B37C2D5A4166666666EAEC23419A999919782D5A413333333332ED2341CDCCCC8C6D2D5A419A99999943ED23419A9999996B2D5A419A99999985ED23419A999919642D5A410000000058ED23419A9999D95C2D5A410000000034ED2341666666C6572D5A419A99999926ED2341000000E0552D5A41CDCCCCCC03ED2341CDCCCCEC502D5A41CDCCCCCCF8EC2341666666C6512D5A4166666666ABEC2341000000E0572D5A419A99999982EC2341000000604F2D5A419A9999995EEC234166666646472D5A41CDCCCCCC2EEC23419A9999993C2D5A410000000010EC234133333353352D5A4133333333F1EB23419A9999992B2D5A410000000062EB2341333333F3312D5A41CDCCCCCC5BEB234133333333322D5A41000000005BEB234100000040322D5A41CDCCCCCC46EB234166666626332D5A413333333303EB234166666626362D5A410000000063EA2341000000403D2D5A41	01060000206A080000010000000103000000010000000D0000000000000063EA2341000000403D2D5A41333333338CEA2341CDCCCCEC4B2D5A41333333332EEB234133333333692D5A41CDCCCCCC1CEC2341333333F3942D5A41666666665AEC2341000000408D2D5A413333333332ED2341CDCCCC8C6D2D5A419A99999985ED23419A999919642D5A41CDCCCCCC03ED2341CDCCCCEC502D5A4166666666ABEC2341000000E0572D5A410000000010EC234133333353352D5A4133333333F1EB23419A9999992B2D5A410000000063EA2341000000403D2D5A410000000063EA2341000000403D2D5A41	01010000206A080000A4D68D423DEC2341343333A3612D5A41	751041402	H	Saint-Gervais 2	7510414	75104	75	11	0
01060000206A080000010000000103000000010000001B00000033333333F1EB23419A9999992B2D5A410000000010EC234133333353352D5A41CDCCCCCC2EEC23419A9999993C2D5A419A9999995EEC234166666646472D5A419A99999982EC2341000000604F2D5A4166666666ABEC2341000000E0572D5A41CDCCCCCCF8EC2341666666C6512D5A41CDCCCCCC03ED2341CDCCCCEC502D5A419A99999926ED2341000000E0552D5A410000000034ED2341666666C6572D5A410000000058ED23419A9999D95C2D5A419A99999985ED23419A999919642D5A41CDCCCCCC88ED2341000000C0632D5A419A99999945EE23419A9999D9522D5A419A99999955EE2341CDCCCC6C512D5A4133333333E7EE234166666646452D5A4166666666AFEE234100000020372D5A41CDCCCCCC5FEE23419A9999792F2D5A419A99999939EE2341CDCCCCAC282D5A413333333317EE23419A999979202D5A416666666602EE2341000000C01A2D5A41CDCCCCCCEDED23419A9999D9132D5A4100000000B4ED234100000000162D5A41000000004DED23419A9999F91A2D5A41CDCCCCCCB9EC2341CDCCCC8C212D5A41CDCCCCCC3AEC2341666666C6272D5A4133333333F1EB23419A9999992B2D5A41	01060000206A080000010000000103000000010000000F00000033333333F1EB23419A9999992B2D5A410000000010EC234133333353352D5A4166666666ABEC2341000000E0572D5A41CDCCCCCC03ED2341CDCCCCEC502D5A419A99999985ED23419A999919642D5A419A99999955EE2341CDCCCC6C512D5A4133333333E7EE234166666646452D5A4166666666AFEE234100000020372D5A41CDCCCCCC5FEE23419A9999792F2D5A413333333317EE23419A999979202D5A41CDCCCCCCEDED23419A9999D9132D5A4100000000B4ED234100000000162D5A41CDCCCCCCB9EC2341CDCCCC8C212D5A4133333333F1EB23419A9999992B2D5A4133333333F1EB23419A9999992B2D5A41	01010000206A0800005EB3E8B36EED2341CDCCCCDC392D5A41	751041403	H	Saint-Gervais 3	7510414	75104	75	11	0
01060000206A0800000100000001030000000100000011000000CDCCCCCCEDED23419A9999D9132D5A416666666602EE2341000000C01A2D5A413333333317EE23419A999979202D5A419A99999939EE2341CDCCCCAC282D5A41CDCCCCCC5FEE23419A9999792F2D5A4166666666AFEE234100000020372D5A4133333333E7EE234166666646452D5A410000000087EF2341333333933B2D5A41666666665BF02341CDCCCC0C2F2D5A41CDCCCCCCF3EF2341666666C6142D5A4100000000C5EF2341CDCCCCEC082D5A419A9999998DEF2341666666E6FA2C5A419A99999974EF23419A9999B9FC2C5A419A99999941EF234133333393002D5A41CDCCCCCCD5EE2341333333B3082D5A416666666683EE2341333333530D2D5A41CDCCCCCCEDED23419A9999D9132D5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCCEDED23419A9999D9132D5A413333333317EE23419A999979202D5A41CDCCCCCC5FEE23419A9999792F2D5A4166666666AFEE234100000020372D5A4133333333E7EE234166666646452D5A41666666665BF02341CDCCCC0C2F2D5A419A9999998DEF2341666666E6FA2C5A41CDCCCCCCD5EE2341333333B3082D5A416666666683EE2341333333530D2D5A41CDCCCCCCEDED23419A9999D9132D5A41CDCCCCCCEDED23419A9999D9132D5A41	01010000206A0800003E8105B911EF2341CDCCCC9C1D2D5A41	751041404	H	Saint-Gervais 4	7510414	75104	75	11	0
01060000206A080000010000000103000000010000001A0000003333333382E9234166666666FC2C5A413333333396E92341CDCCCC4C082D5A41CDCCCCCCA2E923419A9999B90F2D5A41CDCCCCCCCEE92341CDCCCC4C0C2D5A41CDCCCCCCEDE92341666666E60A2D5A413333333329EA234100000040062D5A4100000000F8EA234166666666F62C5A41000000006EEB2341CDCCCC6CED2C5A41CDCCCCCCE4EB234100000080E52C5A419A9999999BEC2341000000C0D82C5A419A99999946ED234133333333CD2C5A419A99999950ED2341333333F3CB2C5A419A999999C0ED2341CDCCCC0CC42C5A419A99999900EE2341CDCCCC8CBF2C5A416666666611EE234133333393BE2C5A4133333333FCED234100000060B82C5A410000000011EE2341000000E0B62C5A413333333322EE234166666666B52C5A41CDCCCCCC1AEE234133333393B42C5A41CDCCCCCC12EE23419A999939B32C5A4166666666EDED234100000000AD2C5A4133333333E7ED2341CDCCCC2CAE2C5A41CDCCCCCC71ED2341CDCCCCCCB72C5A4166666666CDEB2341666666C6D32C5A41333333334BEA2341CDCCCC6CEE2C5A413333333382E9234166666666FC2C5A41	01060000206A080000010000000103000000010000001A0000003333333382E9234166666666FC2C5A413333333396E92341CDCCCC4C082D5A41CDCCCCCCA2E923419A9999B90F2D5A41CDCCCCCCCEE92341CDCCCC4C0C2D5A41CDCCCCCCEDE92341666666E60A2D5A413333333329EA234100000040062D5A4100000000F8EA234166666666F62C5A41000000006EEB2341CDCCCC6CED2C5A41CDCCCCCCE4EB234100000080E52C5A419A9999999BEC2341000000C0D82C5A419A99999946ED234133333333CD2C5A419A99999950ED2341333333F3CB2C5A419A999999C0ED2341CDCCCC0CC42C5A419A99999900EE2341CDCCCC8CBF2C5A416666666611EE234133333393BE2C5A4133333333FCED234100000060B82C5A410000000011EE2341000000E0B62C5A413333333322EE234166666666B52C5A41CDCCCCCC1AEE234133333393B42C5A41CDCCCCCC12EE23419A999939B32C5A4166666666EDED234100000000AD2C5A4133333333E7ED2341CDCCCC2CAE2C5A41CDCCCCCC71ED2341CDCCCCCCB72C5A4166666666CDEB2341666666C6D32C5A41333333334BEA2341CDCCCC6CEE2C5A413333333382E9234166666666FC2C5A41	01010000206A080000E235778FB4EB234100000020DF2C5A41	751041499	D	Seine et Berges 2	7510414	75104	75	11	0
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	01060000206A080000010000000103000000010000001000000033333333AAEE2341333333738B2C5A4166666666AAEE2341666666C6922C5A41000000007EEF23419A9999999F2C5A41000000001FF223419A999979C52C5A41CDCCCCCCB0F22341CDCCCC6CCC2C5A419A9999997BF223419A999979C22C5A419A9999999DF1234166666686682C5A416666666627F12341CDCCCC6C3A2C5A4166666666FFF02341333333F3342C5A413333333348F12341333333332A2C5A4166666666E6F02341666666E61F2C5A416666666691F0234166666686322C5A41CDCCCCCCC6EE2341CDCCCC4C6E2C5A419A999999AFEE234166666606772C5A4133333333AAEE2341333333738B2C5A4133333333AAEE2341333333738B2C5A41	01010000206A080000D62C6B3C38F023419A9999E9752C5A41	751041501	H	Arsenal 1	7510415	75104	75	11	0
01060000206A080000010000000103000000010000002E000000CDCCCCCC22EE234133333393BD2C5A419A9999992BEE2341666666E6BF2C5A419A9999992FEE23419A999919C12C5A41666666663DEE2341666666C6C32C5A416666666659EE23419A999939C82C5A41CDCCCCCC69EE23419A999999CA2C5A413333333380EE2341CDCCCCCCCD2C5A41CDCCCCCC83EE2341CDCCCC4CCE2C5A4133333333D6EE234166666606DC2C5A4166666666ECEE234100000000E02C5A41333333330CEF234133333373E72C5A410000000014EF234100000020E92C5A41000000002FEF2341333333B3EE2C5A41666666663CEF234100000020F22C5A419A9999994CEF234100000040F62C5A419A99999974EF23419A9999B9FC2C5A419A9999998DEF2341666666E6FA2C5A419A999999B5EF234133333373F72C5A41CDCCCCCCDDEF2341666666A6F42C5A4100000000FEEF234100000080F22C5A410000000037F02341333333F3EE2C5A416666666697F02341CDCCCC2CE92C5A410000000047F0234133333373DB2C5A419A999999C6EF234166666686C52C5A41CDCCCCCC0CF02341333333D3BE2C5A419A999999A2EF2341666666E6B02C5A4133333333F7EF234133333373A62C5A419A999999B2EF234133333393A22C5A41CDCCCCCC92EF2341666666C6A02C5A41000000007EEF23419A9999999F2C5A413333333364EF2341000000C09D2C5A419A99999951EF2341666666C69C2C5A419A99999937EF2341666666669B2C5A41333333331DEF2341666666E6992C5A4166666666AAEE2341666666C6922C5A41CDCCCCCCA9EE2341000000409A2C5A4133333333A5EE23419A9999F9A52C5A419A999999A2EE234133333333A92C5A4133333333A1EE234166666686AA2C5A419A99999997EE234100000020AE2C5A419A9999998AEE2341CDCCCCECB02C5A41CDCCCCCC76EE2341333333D3B32C5A41CDCCCCCC61EE2341333333B3B72C5A413333333353EE234133333373B92C5A41333333333EEE2341CDCCCC6CBB2C5A41CDCCCCCC22EE234133333393BD2C5A41	01060000206A0800000100000001030000000100000013000000CDCCCCCC22EE234133333393BD2C5A419A9999992FEE23419A999919C12C5A41CDCCCCCC83EE2341CDCCCC4CCE2C5A4166666666ECEE234100000000E02C5A419A9999994CEF234100000040F62C5A419A99999974EF23419A9999B9FC2C5A4100000000FEEF234100000080F22C5A416666666697F02341CDCCCC2CE92C5A419A999999C6EF234166666686C52C5A41CDCCCCCC0CF02341333333D3BE2C5A419A999999A2EF2341666666E6B02C5A4133333333F7EF234133333373A62C5A41333333331DEF2341666666E6992C5A4166666666AAEE2341666666C6922C5A4133333333A1EE234166666686AA2C5A419A9999998AEE2341CDCCCCECB02C5A41CDCCCCCC61EE2341333333B3B72C5A41CDCCCCCC22EE234133333393BD2C5A41CDCCCCCC22EE234133333393BD2C5A41	01010000206A0800005651B1B40FEF2341000000E0C62C5A41	751041502	H	Arsenal 2	7510415	75104	75	11	0
01060000206A080000010000000103000000010000002D0000009A999999A2EF2341666666E6B02C5A41CDCCCCCC0CF02341333333D3BE2C5A419A999999C6EF234166666686C52C5A410000000047F0234133333373DB2C5A416666666697F02341CDCCCC2CE92C5A419A999999A4F0234133333373E82C5A41CDCCCCCCA7F0234166666646E82C5A4133333333CDF0234166666626E62C5A41CDCCCCCC08F1234166666626E32C5A419A9999991AF1234133333353E22C5A410000000038F12341CDCCCCECE02C5A41CDCCCCCC7DF12341333333D3DD2C5A41CDCCCCCC9AF1234133333393DC2C5A4133333333B4F12341666666E6DB2C5A4166666666D3F1234166666606DB2C5A41CDCCCCCCF3F1234166666626DA2C5A4100000000FBF123419A9999F9D92C5A410000000004F2234166666646DD2C5A416666666612F2234166666686E22C5A410000000016F223419A9999D9E32C5A413333333319F223419A9999F9E42C5A41666666661BF22341CDCCCC8CE62C5A41333333338FF22341CDCCCC8CE42C5A419A999999CEF2234133333353E32C5A4166666666E2F22341000000A0E12C5A416666666601F32341CDCCCCECE52C5A413333333311F3234166666626D82C5A416666666612F323419A999939D72C5A41CDCCCCCC14F323419A999919D52C5A416666666617F323419A9999D9D22C5A410000000012F32341666666C6D02C5A41000000000BF32341CDCCCC0CCE2C5A4133333333EBF22341CDCCCC4CCB2C5A41CDCCCCCCB0F22341CDCCCC6CCC2C5A413333333353F22341333333F3C72C5A419A99999940F2234100000000C72C5A41000000001FF223419A999979C52C5A419A99999903F22341CDCCCCECC32C5A4100000000C3F12341CDCCCC4CC02C5A41CDCCCCCCAAF12341333333F3BE2C5A419A99999949F123419A999979B92C5A41333333331FF1234133333313B72C5A4166666666FAF0234100000000B52C5A4133333333F7EF234133333373A62C5A419A999999A2EF2341666666E6B02C5A41	01060000206A08000001000000010300000001000000130000009A999999A2EF2341666666E6B02C5A41CDCCCCCC0CF02341333333D3BE2C5A419A999999C6EF234166666686C52C5A416666666697F02341CDCCCC2CE92C5A410000000038F12341CDCCCCECE02C5A41CDCCCCCC9AF1234133333393DC2C5A4100000000FBF123419A9999F9D92C5A41666666661BF22341CDCCCC8CE62C5A419A999999CEF2234133333353E32C5A4166666666E2F22341000000A0E12C5A416666666601F32341CDCCCCECE52C5A416666666617F323419A9999D9D22C5A41000000000BF32341CDCCCC0CCE2C5A4133333333EBF22341CDCCCC4CCB2C5A41CDCCCCCCB0F22341CDCCCC6CCC2C5A41000000001FF223419A999979C52C5A4133333333F7EF234133333373A62C5A419A999999A2EF2341666666E6B02C5A419A999999A2EF2341666666E6B02C5A41	01010000206A0800004654BDF50DF123419A999979C72C5A41	751041503	H	Arsenal 3	7510415	75104	75	11	0
01060000206A080000010000000103000000010000002A0000009A9999998DEF2341666666E6FA2C5A4100000000C5EF2341CDCCCCEC082D5A41CDCCCCCCF3EF2341666666C6142D5A41666666665BF02341CDCCCC0C2F2D5A41666666666CF023419A9999392E2D5A410000000095F02341000000602C2D5A4133333333B7F02341000000C02A2D5A41CDCCCCCC2FF1234166666646272D5A4100000000ABF123419A9999B9232D5A4166666666D1F12341666666A6222D5A413333333315F2234166666646202D5A4100000000A0F22341666666C61B2D5A4133333333BFF22341CDCCCC4C1C2D5A41CDCCCCCCE0F22341666666C6002D5A4166666666FBF2234133333333EB2C5A416666666601F32341CDCCCCECE52C5A4166666666E2F22341000000A0E12C5A419A999999CEF2234133333353E32C5A41333333338FF22341CDCCCC8CE42C5A41666666661BF22341CDCCCC8CE62C5A413333333319F223419A9999F9E42C5A410000000016F223419A9999D9E32C5A416666666612F2234166666686E22C5A410000000004F2234166666646DD2C5A4100000000FBF123419A9999F9D92C5A41CDCCCCCCF3F1234166666626DA2C5A4166666666D3F1234166666606DB2C5A4133333333B4F12341666666E6DB2C5A41CDCCCCCC9AF1234133333393DC2C5A41CDCCCCCC7DF12341333333D3DD2C5A410000000038F12341CDCCCCECE02C5A419A9999991AF1234133333353E22C5A41CDCCCCCC08F1234166666626E32C5A4133333333CDF0234166666626E62C5A41CDCCCCCCA7F0234166666646E82C5A419A999999A4F0234133333373E82C5A416666666697F02341CDCCCC2CE92C5A410000000037F02341333333F3EE2C5A4100000000FEEF234100000080F22C5A41CDCCCCCCDDEF2341666666A6F42C5A419A999999B5EF234133333373F72C5A419A9999998DEF2341666666E6FA2C5A41	01060000206A08000001000000010300000001000000100000009A9999998DEF2341666666E6FA2C5A41666666665BF02341CDCCCC0C2F2D5A4133333333B7F02341000000C02A2D5A4166666666D1F12341666666A6222D5A4100000000A0F22341666666C61B2D5A4133333333BFF22341CDCCCC4C1C2D5A416666666601F32341CDCCCCECE52C5A4166666666E2F22341000000A0E12C5A419A999999CEF2234133333353E32C5A41666666661BF22341CDCCCC8CE62C5A4100000000FBF123419A9999F9D92C5A41CDCCCCCC9AF1234133333393DC2C5A4133333333CDF0234166666626E62C5A4100000000FEEF234100000080F22C5A419A9999998DEF2341666666E6FA2C5A419A9999998DEF2341666666E6FA2C5A41	01010000206A0800004CDE4F5D48F123419A9999D9042D5A41	751041504	H	Arsenal 4	7510415	75104	75	11	0
01060000206A080000010000000103000000010000003300000066666666FFF02341333333F3342C5A419A99999909F123419A9999F9352C5A419A99999911F12341000000C0362C5A41000000001FF123419A9999D9382C5A416666666627F12341CDCCCC6C3A2C5A41666666662EF12341000000403C2C5A413333333336F12341666666663E2C5A419A99999942F1234166666686442C5A41666666665FF1234166666646502C5A41CDCCCCCC74F12341CDCCCCEC582C5A419A9999997BF123419A9999B95B2C5A419A9999997FF123419A9999595D2C5A41CDCCCCCC87F1234166666666602C5A419A9999999DF1234166666686682C5A413333333309F22341333333F3932C5A41333333333DF2234100000040A92C5A419A9999997BF223419A999979C22C5A41000000008BF22341000000A0C42C5A41CDCCCCCCB0F22341CDCCCC6CCC2C5A4133333333EBF22341CDCCCC4CCB2C5A41000000000BF32341CDCCCC0CCE2C5A419A99999900F32341333333F3C92C5A41CDCCCCCCF7F2234166666686C62C5A419A999999F1F2234100000020C42C5A4133333333CEF2234166666666B62C5A419A999999CCF22341CDCCCCCCB52C5A4166666666CAF22341666666E6B42C5A419A999999C7F22341333333D3B32C5A419A999999C6F22341CDCCCC6CB32C5A4133333333C6F2234100000040B32C5A4166666666C4F22341CDCCCC8CB22C5A4133333333C1F2234133333353B12C5A4166666666C0F2234133333313B12C5A419A99999969F22341CDCCCC4C8F2C5A41CDCCCCCC66F22341CDCCCC2C8E2C5A416666666600F223419A999979642C5A4100000000DAF12341000000E0542C5A4166666666CEF123419A999919502C5A419A999999C7F12341666666464D2C5A4166666666B5F12341CDCCCCEC452C5A413333333385F1234100000040322C5A419A99999983F1234133333373302C5A416666666665F12341CDCCCC4C2D2C5A416666666664F12341CDCCCC2C2D2C5A416666666659F12341000000002C2C5A41CDCCCCCC49F123419A9999592A2C5A413333333348F12341333333332A2C5A41CDCCCCCC40F123419A9999392B2C5A410000000026F12341333333332F2C5A41666666660DF123419A9999D9322C5A4166666666FFF02341333333F3342C5A41	01060000206A080000010000000103000000010000000C00000066666666FFF02341333333F3342C5A416666666627F12341CDCCCC6C3A2C5A419A9999999DF1234166666686682C5A419A9999997BF223419A999979C22C5A41CDCCCCCCB0F22341CDCCCC6CCC2C5A4133333333EBF22341CDCCCC4CCB2C5A41000000000BF32341CDCCCC0CCE2C5A419A99999969F22341CDCCCC4C8F2C5A413333333385F1234100000040322C5A413333333348F12341333333332A2C5A4166666666FFF02341333333F3342C5A4166666666FFF02341333333F3342C5A41	01010000206A080000B059B16802F223419A9999597B2C5A41	751041588	D	Bassin de l'Arsenal	7510415	75104	75	11	0
01060000206A080000010000000103000000010000003600000066666666EDED234100000000AD2C5A41CDCCCCCC12EE23419A999939B32C5A41CDCCCCCC1AEE234133333393B42C5A413333333322EE234166666666B52C5A410000000011EE2341000000E0B62C5A4133333333FCED234100000060B82C5A416666666611EE234133333393BE2C5A41CDCCCCCC22EE234133333393BD2C5A41333333333EEE2341CDCCCC6CBB2C5A413333333353EE234133333373B92C5A41CDCCCCCC61EE2341333333B3B72C5A41CDCCCCCC76EE2341333333D3B32C5A419A9999998AEE2341CDCCCCECB02C5A419A99999997EE234100000020AE2C5A4133333333A1EE234166666686AA2C5A419A999999A2EE234133333333A92C5A4133333333A5EE23419A9999F9A52C5A41CDCCCCCCA9EE2341000000409A2C5A4166666666AAEE2341666666C6922C5A4133333333AAEE2341333333738B2C5A41CDCCCCCCAAEE2341CDCCCC0C822C5A4166666666AAEE23419A9999D97D2C5A419A999999ACEE2341333333D3792C5A419A999999AFEE234166666606772C5A41CDCCCCCCB3EE2341CDCCCCCC742C5A4166666666B6EE234166666666732C5A4133333333BFEE2341CDCCCC2C702C5A41CDCCCCCCC6EE2341CDCCCC4C6E2C5A4100000000D7EE2341000000E06B2C5A4133333333E8EE2341333333B3692C5A4166666666FAEE234133333373672C5A413333333344EF23419A9999D95D2C5A419A999999CEEF2341333333F34B2C5A41333333331AF02341CDCCCCCC412C5A416666666627F0234133333313402C5A416666666691F0234166666686322C5A4166666666A0F02341333333532F2C5A4166666666B4F02341CDCCCC2C2B2C5A419A999999DCF0234133333333222C5A4166666666E6F02341666666E61F2C5A419A999999DAF02341000000A01E2C5A4166666666D8F02341666666661E2C5A41CDCCCCCC5DF0234100000080112C5A413333333340EF2341666666463A2C5A419A9999991EEF2341666666063F2C5A41666666666FEE2341000000E0532C5A41CDCCCCCC62EE2341000000A0652C5A413333333344EE2341CDCCCC6C712C5A41CDCCCCCC32EE23419A9999397E2C5A416666666626EE2341CDCCCCAC8B2C5A413333333327EE23419A9999D9952C5A410000000025EE2341CDCCCC0C9D2C5A413333333313EE2341CDCCCCECA52C5A4166666666EDED234100000000AD2C5A41	01060000206A080000010000000103000000010000001700000066666666EDED234100000000AD2C5A413333333322EE234166666666B52C5A4133333333FCED234100000060B82C5A416666666611EE234133333393BE2C5A41CDCCCCCC61EE2341333333B3B72C5A419A9999998AEE2341CDCCCCECB02C5A4133333333A1EE234166666686AA2C5A41CDCCCCCCA9EE2341000000409A2C5A4166666666AAEE23419A9999D97D2C5A419A999999AFEE234166666606772C5A41CDCCCCCCC6EE2341CDCCCC4C6E2C5A416666666691F0234166666686322C5A4166666666E6F02341666666E61F2C5A41CDCCCCCC5DF0234100000080112C5A419A9999991EEF2341666666063F2C5A41666666666FEE2341000000E0532C5A41CDCCCCCC62EE2341000000A0652C5A413333333344EE2341CDCCCC6C712C5A416666666626EE2341CDCCCCAC8B2C5A410000000025EE2341CDCCCC0C9D2C5A413333333313EE2341CDCCCCECA52C5A4166666666EDED234100000000AD2C5A4166666666EDED234100000000AD2C5A41	01010000206A0800009A999939A6EE234133333393682C5A41	751041599	D	Seine et Berges 3	7510415	75104	75	11	0
01060000206A080000010000000103000000010000001D00000033333333F3E92341333333F3DC2C5A419A99999904EA23419A999999E12C5A41CDCCCCCC6CEA2341333333D3DB2C5A41666666662AEB2341333333D3D02C5A41000000002FEC23419A999939C02C5A41CDCCCCCCAFEC234100000080B82C5A410000000010ED234133333393B12C5A41666666664CED2341CDCCCC8CAD2C5A41666666666BED2341CDCCCC4CAB2C5A41000000008DED234133333393A82C5A419A999999AAED23419A9999D9A52C5A41CDCCCCCCBDED2341000000C0A22C5A4166666666DBED2341CDCCCCCC9C2C5A4166666666E4ED2341666666069A2C5A41CDCCCCCCE7ED2341000000E0972C5A41CDCCCCCCDDED2341000000C08C2C5A41CDCCCCCCDEED2341000000C0872C5A41CDCCCCCC3FED2341CDCCCCAC7E2C5A4133333333FFEC234100000000832C5A41333333336DEC2341CDCCCCCC8C2C5A419A999999DCEB2341CDCCCCCC952C5A410000000080EB2341666666469C2C5A41CDCCCCCC57EB2341666666A69F2C5A41CDCCCCCC21EB234100000060A22C5A41CDCCCCCC81EA234166666626AA2C5A41000000003FEA234133333393B82C5A413333333310EA23419A999999C22C5A41000000000BEA234133333313CD2C5A4133333333F3E92341333333F3DC2C5A41	01060000206A080000010000000103000000010000001300000033333333F3E92341333333F3DC2C5A419A99999904EA23419A999999E12C5A41666666662AEB2341333333D3D02C5A41000000002FEC23419A999939C02C5A41CDCCCCCCAFEC234100000080B82C5A41666666664CED2341CDCCCC8CAD2C5A419A999999AAED23419A9999D9A52C5A4166666666DBED2341CDCCCCCC9C2C5A41CDCCCCCCE7ED2341000000E0972C5A41CDCCCCCCDEED2341000000C0872C5A41CDCCCCCC3FED2341CDCCCCAC7E2C5A41333333336DEC2341CDCCCCCC8C2C5A419A999999DCEB2341CDCCCCCC952C5A41CDCCCCCC57EB2341666666A69F2C5A41CDCCCCCC81EA234166666626AA2C5A413333333310EA23419A999999C22C5A41000000000BEA234133333313CD2C5A4133333333F3E92341333333F3DC2C5A4133333333F3E92341333333F3DC2C5A41	01010000206A080000AA66BF77CBEB234100000090AF2C5A41	751041601	H	Notre-Dame 1	7510416	75104	75	11	0
01060000206A0800000100000001030000000100000014000000CDCCCCCCA8E72341CDCCCC0CE22C5A41CDCCCCCCFFE7234100000060F72C5A41CDCCCCCC4DE82341CDCCCC8C0A2D5A41000000008BE823419A999919042D5A419A99999992E82341CDCCCC8C032D5A41666666669AE82341333333F3022D5A41CDCCCCCCBDE82341333333F3FE2C5A41CDCCCCCCD8E8234100000040FB2C5A4166666666ECE8234100000000F82C5A419A99999925E923419A999999EC2C5A410000000031E923419A999939E92C5A413333333343E92341CDCCCCECE22C5A41333333334DE9234100000080DE2C5A410000000054E9234100000040DA2C5A416666666662E923419A999939C72C5A419A9999993EE92341333333D3C82C5A419A999999D1E823419A999979CF2C5A4166666666A3E8234166666646D22C5A413333333373E823419A999939D52C5A41CDCCCCCCA8E72341CDCCCC0CE22C5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCCA8E72341CDCCCC0CE22C5A41CDCCCCCC4DE82341CDCCCC8C0A2D5A41CDCCCCCCBDE82341333333F3FE2C5A4166666666ECE8234100000000F82C5A419A99999925E923419A999999EC2C5A410000000054E9234100000040DA2C5A416666666662E923419A999939C72C5A419A9999993EE92341333333D3C82C5A41CDCCCCCCA8E72341CDCCCC0CE22C5A41CDCCCCCCA8E72341CDCCCC0CE22C5A41	01010000206A080000E62F12A979E8234134333313E62C5A41	751041602	H	Notre-Dame 2	7510416	75104	75	11	0
01060000206A0800000100000001030000000100000030000000333333330FE5234166666626F02C5A41333333332EE523419A999979F52C5A410000000038E5234166666646F72C5A416666666639E52341CDCCCC8CF72C5A41CDCCCCCCC1E5234133333373102D5A419A999999C7E52341CDCCCCCC112D5A4100000000D5E523419A9999F9142D5A41CDCCCCCCE1E5234166666626182D5A416666666621E62341666666462A2D5A4100000000B2E62341CDCCCC4C222D5A4133333333D9E6234166666626202D5A4100000000DDE62341CDCCCCEC1F2D5A416666666602E723419A9999D91D2D5A41000000000AE72341333333731D2D5A410000000030E72341333333531B2D5A41000000005AE7234133333333192D5A4166666666E0E7234166666666122D5A419A999999E9E72341CDCCCCCC112D5A419A999999F1E7234166666646112D5A419A99999900E8234100000020102D5A41CDCCCCCC4DE82341CDCCCC8C0A2D5A41CDCCCCCCFFE7234100000060F72C5A41CDCCCCCCA8E72341CDCCCC0CE22C5A413333333373E823419A999939D52C5A4166666666A3E8234166666646D22C5A419A999999D1E823419A999979CF2C5A419A9999993EE92341333333D3C82C5A416666666662E923419A999939C72C5A416666666662E923419A999999C42C5A419A9999995EE923419A999999C22C5A413333333341E9234166666666BA2C5A41333333331FE92341CDCCCCECB02C5A41666666661BE92341666666E6AF2C5A419A9999991AE92341000000A0AF2C5A416666666619E9234166666626AF2C5A419A99999908E9234133333353AA2C5A4100000000D5E82341CDCCCC6CAC2C5A413333333320E823419A9999B9B62C5A413333333315E8234166666666B72C5A413333333390E7234166666686BF2C5A41CDCCCCCC3DE72341CDCCCCACC62C5A41666666668FE62341666666C6D52C5A413333333361E6234100000080D92C5A413333333339E62341CDCCCCACDC2C5A413333333318E623419A9999B9DE2C5A41CDCCCCCCF3E52341333333F3E02C5A41333333337DE5234166666646E82C5A41333333330FE5234166666626F02C5A41	01060000206A0800000100000001030000000100000013000000333333330FE5234166666626F02C5A41CDCCCCCCC1E5234133333373102D5A416666666621E62341666666462A2D5A410000000030E72341333333531B2D5A4166666666E0E7234166666666122D5A41CDCCCCCC4DE82341CDCCCC8C0A2D5A41CDCCCCCCA8E72341CDCCCC0CE22C5A419A9999993EE92341333333D3C82C5A416666666662E923419A999939C72C5A419A9999995EE923419A999999C22C5A419A99999908E9234133333353AA2C5A4100000000D5E82341CDCCCC6CAC2C5A413333333320E823419A9999B9B62C5A413333333390E7234166666686BF2C5A41666666668FE62341666666C6D52C5A413333333339E62341CDCCCCACDC2C5A41333333337DE5234166666646E82C5A41333333330FE5234166666626F02C5A41333333330FE5234166666626F02C5A41	01010000206A080000C9E3E53A8CE6234166666636EC2C5A41	751041603	A	Notre-Dame 3	7510416	75104	75	11	0
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	01060000206A080000010000000103000000020000001F0000006666666621E62341666666462A2D5A413333333350E62341333333B3382D5A4100000000C7E723419A999939232D5A4100000000AFE823419A999999112D5A413333333382E9234166666666FC2C5A4166666666CDEB2341666666C6D32C5A41CDCCCCCC71ED2341CDCCCCCCB72C5A4133333333E7ED2341CDCCCC2CAE2C5A413333333313EE2341CDCCCCECA52C5A410000000025EE2341CDCCCC0C9D2C5A416666666626EE2341CDCCCCAC8B2C5A413333333344EE2341CDCCCC6C712C5A41CDCCCCCC62EE2341000000A0652C5A41666666666FEE2341000000E0532C5A413333333370ED2341000000606C2C5A41CDCCCCCC0AED23419A9999F9732C5A419A999999BFEA234166666666982C5A41CDCCCCCC5EEA23419A9999399D2C5A410000000001EA23419A999959A02C5A419A99999908E9234133333353AA2C5A419A9999995EE923419A999999C22C5A416666666662E923419A999939C72C5A410000000054E9234100000040DA2C5A419A99999925E923419A999999EC2C5A4166666666ECE8234100000000F82C5A41CDCCCCCCBDE82341333333F3FE2C5A41CDCCCCCC4DE82341CDCCCC8C0A2D5A4166666666E0E7234166666666122D5A410000000030E72341333333531B2D5A416666666621E62341666666462A2D5A416666666621E62341666666462A2D5A411300000033333333F3E92341333333F3DC2C5A41000000000BEA234133333313CD2C5A413333333310EA23419A999999C22C5A41CDCCCCCC81EA234166666626AA2C5A41CDCCCCCC57EB2341666666A69F2C5A419A999999DCEB2341CDCCCCCC952C5A41333333336DEC2341CDCCCCCC8C2C5A41CDCCCCCC3FED2341CDCCCCAC7E2C5A41CDCCCCCCDEED2341000000C0872C5A41CDCCCCCCE7ED2341000000E0972C5A4166666666DBED2341CDCCCCCC9C2C5A419A999999AAED23419A9999D9A52C5A41666666664CED2341CDCCCC8CAD2C5A41CDCCCCCCAFEC234100000080B82C5A41000000002FEC23419A999939C02C5A41666666662AEB2341333333D3D02C5A419A99999904EA23419A999999E12C5A4133333333F3E92341333333F3DC2C5A4133333333F3E92341333333F3DC2C5A41	01010000206A0800005644A2B739EC23419A9999E9C52C5A41	751041699	D	Seine et Berges 4	7510416	75104	75	11	0
01060000206A080000010000000103000000010000003C000000CDCCCCCC63E82341CDCCCCEC472C5A41CDCCCCCCBCE823419A999959432C5A4133333333FEE8234166666606402C5A41000000003CE923419A9999D93C2C5A416666666690E923419A999979382C5A4166666666A3E92341CDCCCC0C372C5A4166666666B6E9234166666666352C5A4133333333DEE9234133333393342C5A4100000000E7E92341CDCCCC2C342C5A4133333333F4E923419A999939332C5A413333333309EA2341000000C0312C5A41000000008FEA2341666666A6202C5A419A9999999BEA23419A9999F91E2C5A4166666666A1EA23419A9999F91D2C5A4133333333AFEA2341CDCCCCCC1D2C5A4166666666CFEA23419A9999191A2C5A419A999999ECEA2341CDCCCC8C162C5A419A99999910EB2341CDCCCC6C112C5A416666666613EB2341333333D3102C5A419A99999914EB234166666646102C5A419A99999916EB23419A9999590E2C5A416666666681EB23419A9999D9FF2B5A41CDCCCCCCBFEB23419A999999F72B5A413333333312EC23419A9999B9EC2B5A413333333308EC2341CDCCCCCCEB2B5A410000000099EB23419A999939E12B5A416666666674EB23419A9999B9DD2B5A41000000004FEB2341CDCCCC2CDA2B5A41CDCCCCCC4AEB2341666666C6D92B5A413333333312EB234166666666D42B5A4133333333E2EA234133333393D12B5A4100000000DCEA23419A999999D62B5A4133333333C9EA234133333373EB2B5A4100000000C1EA2341CDCCCCECF42B5A4166666666B6EA234166666606052C5A4100000000AFEA23419A999939102C5A419A999999A1EA234166666606102C5A410000000092EA2341000000400F2C5A41333333337DEA2341666666C60D2C5A416666666668EA23419A9999F90B2C5A410000000042EA234100000040082C5A419A99999933EA23419A9999F9062C5A41333333332EEA2341CDCCCCAC062C5A410000000029EA2341CDCCCCCC062C5A41CDCCCCCCE3E923419A9999590A2C5A41CDCCCCCCB0E92341CDCCCCEC0C2C5A41000000009CE92341000000600E2C5A416666666685E92341000000C0102C5A413333333360E92341CDCCCCAC142C5A416666666649E9234133333373172C5A410000000038E9234133333333192C5A419A99999927E92341CDCCCC0C1A2C5A41CDCCCCCC0EE92341666666661A2C5A410000000004E92341333333131F2C5A41CDCCCCCCF4E82341333333B3222C5A419A999999DDE8234133333353282C5A4133333333C8E82341000000802D2C5A4133333333B9E823419A999939312C5A41CDCCCCCC7BE8234133333393402C5A41CDCCCCCC63E82341CDCCCCEC472C5A41	01060000206A0800000100000001030000000100000016000000CDCCCCCC63E82341CDCCCCEC472C5A416666666690E923419A999979382C5A4166666666B6E9234166666666352C5A413333333309EA2341000000C0312C5A41000000008FEA2341666666A6202C5A4133333333AFEA2341CDCCCCCC1D2C5A419A99999910EB2341CDCCCC6C112C5A419A99999916EB23419A9999590E2C5A413333333312EC23419A9999B9EC2B5A413333333312EB234166666666D42B5A4133333333E2EA234133333393D12B5A4100000000C1EA2341CDCCCCECF42B5A4100000000AFEA23419A999939102C5A410000000092EA2341000000400F2C5A410000000029EA2341CDCCCCCC062C5A41000000009CE92341000000600E2C5A410000000038E9234133333333192C5A41CDCCCCCC0EE92341666666661A2C5A410000000004E92341333333131F2C5A41CDCCCCCC7BE8234133333393402C5A41CDCCCCCC63E82341CDCCCCEC472C5A41CDCCCCCC63E82341CDCCCCEC472C5A41	01010000206A08000046385F0C14EA2341343333730C2C5A41	751051701	H	Saint-Victor 1	7510517	75105	75	11	0
01060000206A0800000100000001030000000100000026000000CDCCCCCC0EE92341666666661A2C5A419A99999927E92341CDCCCC0C1A2C5A410000000038E9234133333333192C5A416666666649E9234133333373172C5A413333333360E92341CDCCCCAC142C5A416666666685E92341000000C0102C5A41000000009CE92341000000600E2C5A41CDCCCCCCB0E92341CDCCCCEC0C2C5A41CDCCCCCCE3E923419A9999590A2C5A410000000029EA2341CDCCCCCC062C5A41333333332EEA2341CDCCCCAC062C5A419A99999933EA23419A9999F9062C5A410000000042EA234100000040082C5A416666666668EA23419A9999F90B2C5A41333333337DEA2341666666C60D2C5A410000000092EA2341000000400F2C5A419A999999A1EA234166666606102C5A4100000000AFEA23419A999939102C5A4166666666B6EA234166666606052C5A4100000000C1EA2341CDCCCCECF42B5A4133333333C9EA234133333373EB2B5A4100000000DCEA23419A999999D62B5A4133333333E2EA234133333393D12B5A419A999999E7EA2341666666E6CE2B5A4166666666EEEA2341666666C6CC2B5A4133333333A5EA2341333333D3CC2B5A41CDCCCCCC77EA234166666606CD2B5A419A99999959EA234166666606CD2B5A41333333332FEA234133333373CD2B5A4133333333CAE92341666666C6CD2B5A4133333333A4E9234133333353CE2B5A410000000062E92341CDCCCC8CD02B5A410000000071E9234100000080E32B5A41CDCCCCCC6BE923419A9999D9E72B5A419A99999956E9234166666646F32B5A41CDCCCCCC3DE92341666666A6002C5A416666666624E92341666666A60E2C5A41CDCCCCCC0EE92341666666661A2C5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC0EE92341666666661A2C5A410000000038E9234133333333192C5A41000000009CE92341000000600E2C5A410000000029EA2341CDCCCCCC062C5A410000000092EA2341000000400F2C5A4100000000AFEA23419A999939102C5A4100000000C1EA2341CDCCCCECF42B5A4100000000DCEA23419A999999D62B5A4166666666EEEA2341666666C6CC2B5A4133333333CAE92341666666C6CD2B5A410000000062E92341CDCCCC8CD02B5A410000000071E9234100000080E32B5A41CDCCCCCC6BE923419A9999D9E72B5A41CDCCCCCC0EE92341666666661A2C5A41CDCCCCCC0EE92341666666661A2C5A41	01010000206A080000D0C762640BEA23419A999919F42B5A41	751051702	H	Saint-Victor 2	7510517	75105	75	11	0
01060000206A08000001000000010300000001000000310000009A9999993CE72341CDCCCCAC382C5A41333333333FE7234133333373402C5A41CDCCCCCC3DE72341333333B3472C5A41666666663FE72341CDCCCCAC572C5A4166666666C3E7234100000020512C5A4166666666D9E7234100000000502C5A41666666665CE82341CDCCCC6C492C5A41CDCCCCCC63E82341CDCCCCEC472C5A41CDCCCCCC7BE8234133333393402C5A4133333333B9E823419A999939312C5A4133333333C8E82341000000802D2C5A419A999999DDE8234133333353282C5A41CDCCCCCCF4E82341333333B3222C5A410000000004E92341333333131F2C5A41CDCCCCCC0EE92341666666661A2C5A416666666624E92341666666A60E2C5A41CDCCCCCC3DE92341666666A6002C5A419A99999956E9234166666646F32B5A41CDCCCCCC6BE923419A9999D9E72B5A410000000071E9234100000080E32B5A410000000062E92341CDCCCC8CD02B5A419A999999F3E82341666666A6D52B5A419A999999C4E82341666666A6D72B5A41CDCCCCCC91E82341CDCCCCCCD92B5A41666666665CE8234166666626DC2B5A419A99999943E8234166666646DD2B5A4133333333E6E72341CDCCCC8CE12B5A41CDCCCCCCD1E723419A999979E22B5A4166666666A2E72341CDCCCC6CE52B5A4100000000A2E7234100000000E62B5A410000000098E723419A9999D9F22B5A419A99999990E72341666666A6F92B5A41666666668FE7234100000020FC2B5A416666666693E7234100000040022C5A416666666693E72341666666A6052C5A41666666668EE7234166666626132C5A416666666687E72341333333D3182C5A41666666667FE72341CDCCCCCC1F2C5A41CDCCCCCC71E72341000000A0282C5A41666666666DE72341CDCCCC8C2A2C5A41CDCCCCCC63E72341666666462C2C5A419A9999994EE72341CDCCCC4C2F2C5A41CDCCCCCC4AE7234133333393302C5A419A9999994AE7234133333393312C5A41333333334CE72341666666E6322C5A41333333334BE7234133333373342C5A413333333349E7234100000020352C5A416666666640E72341666666C6362C5A419A9999993CE72341CDCCCCAC382C5A41	01060000206A08000001000000010300000001000000120000009A9999993CE72341CDCCCCAC382C5A41666666663FE72341CDCCCCAC572C5A41666666665CE82341CDCCCC6C492C5A41CDCCCCCC7BE8234133333393402C5A410000000004E92341333333131F2C5A41CDCCCCCC0EE92341666666661A2C5A41CDCCCCCC6BE923419A9999D9E72B5A410000000071E9234100000080E32B5A410000000062E92341CDCCCC8CD02B5A41CDCCCCCCD1E723419A999979E22B5A4166666666A2E72341CDCCCC6CE52B5A41666666668FE7234100000020FC2B5A416666666693E72341666666A6052C5A41666666668EE7234166666626132C5A41666666666DE72341CDCCCC8C2A2C5A419A9999994EE72341CDCCCC4C2F2C5A419A9999993CE72341CDCCCCAC382C5A419A9999993CE72341CDCCCCAC382C5A41	01010000206A08000028E2DEE750E82341CCCCCCFC152C5A41	751051703	H	Saint-Victor 3	7510517	75105	75	11	0
01060000206A0800000100000001030000000100000022000000666666663FE72341CDCCCCAC572C5A41333333334BE72341333333735D2C5A41CDCCCCCC53E72341666666A6612C5A416666666663E72341CDCCCC4C682C5A419A99999965E7234133333373692C5A41CDCCCCCC7AE72341000000E0712C5A419A99999986E723419A999999762C5A413333333391E723419A9999B97A2C5A413333333387E72341CDCCCC4C7D2C5A41CDCCCCCCC8E72341666666067A2C5A416666666651E82341333333F3732C5A4100000000A3E82341000000E0722C5A419A9999991EE9234100000040712C5A4100000000C0E923419A9999B96F2C5A4133333333A8EA2341666666866D2C5A416666666690EB2341666666466B2C5A41000000008CEB2341000000C0692C5A413333333386EB23419A999999682C5A41CDCCCCCC53EB234100000040612C5A419A99999928EB2341333333B35B2C5A41CDCCCCCCB7EA23419A9999F94D2C5A419A99999918EA2341CDCCCC2C3B2C5A4133333333DEE9234133333393342C5A4166666666B6E9234166666666352C5A4166666666A3E92341CDCCCC0C372C5A416666666690E923419A999979382C5A41000000003CE923419A9999D93C2C5A4133333333FEE8234166666606402C5A41CDCCCCCCBCE823419A999959432C5A41CDCCCCCC63E82341CDCCCCEC472C5A41666666665CE82341CDCCCC6C492C5A4166666666D9E7234100000000502C5A4166666666C3E7234100000020512C5A41666666663FE72341CDCCCCAC572C5A41	01060000206A080000010000000103000000010000000E000000666666663FE72341CDCCCCAC572C5A419A99999965E7234133333373692C5A413333333391E723419A9999B97A2C5A413333333387E72341CDCCCC4C7D2C5A416666666651E82341333333F3732C5A419A9999991EE9234100000040712C5A416666666690EB2341666666466B2C5A41CDCCCCCC53EB234100000040612C5A41CDCCCCCCB7EA23419A9999F94D2C5A4133333333DEE9234133333393342C5A41CDCCCCCC63E82341CDCCCCEC472C5A41666666665CE82341CDCCCC6C492C5A41666666663FE72341CDCCCCAC572C5A41666666663FE72341CDCCCCAC572C5A41	01010000206A0800005ED93EC92DE92341000000B0592C5A41	751051704	H	Saint-Victor 4	7510517	75105	75	11	0
01060000206A080000010000000103000000010000001E000000CDCCCCCC57E7234166666606892C5A419A99999966E72341333333B3892C5A410000000071E723419A9999598B2C5A41000000007FE72341000000E08F2C5A41666666668DE72341333333F3942C5A419A999999ABE72341000000209F2C5A41CDCCCCCCB0E72341333333B3A02C5A4166666666BDE72341000000E0A42C5A4166666666C3E72341000000E0A62C5A419A999999DEE7234100000020AF2C5A41CDCCCCCC5BE82341666666A6A52C5A41333333339DE82341CDCCCCACA02C5A419A999999DBE82341666666069D2C5A419A99999998E92341000000C0902C5A41CDCCCCCC21EA2341666666C6882C5A4133333333E8EA2341000000407D2C5A416666666687EB234133333353732C5A41CDCCCCCC9CEB234166666606722C5A41CDCCCCCCCCEB2341666666266F2C5A419A999999FEEB2341000000206C2C5A416666666690EB2341666666466B2C5A4133333333A8EA2341666666866D2C5A4100000000C0E923419A9999B96F2C5A419A9999991EE9234100000040712C5A4100000000A3E82341000000E0722C5A416666666651E82341333333F3732C5A41CDCCCCCCC8E72341666666067A2C5A413333333387E72341CDCCCC4C7D2C5A419A9999996FE7234133333353832C5A41CDCCCCCC57E7234166666606892C5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC57E7234166666606892C5A410000000071E723419A9999598B2C5A419A999999DEE7234100000020AF2C5A41333333339DE82341CDCCCCACA02C5A419A99999998E92341000000C0902C5A4133333333E8EA2341000000407D2C5A419A999999FEEB2341000000206C2C5A416666666690EB2341666666466B2C5A419A9999991EE9234100000040712C5A416666666651E82341333333F3732C5A413333333387E72341CDCCCC4C7D2C5A41CDCCCCCC57E7234166666606892C5A41CDCCCCCC57E7234166666606892C5A41	01010000206A0800001FAAD449A3E82341CDCCCC9C8D2C5A41	751051705	H	Saint-Victor 5	7510517	75105	75	11	0
01060000206A080000010000000103000000010000002C00000033333333DEE9234133333393342C5A419A99999918EA2341CDCCCC2C3B2C5A41CDCCCCCCB7EA23419A9999F94D2C5A419A99999928EB2341333333B35B2C5A41CDCCCCCC53EB234100000040612C5A413333333386EB23419A999999682C5A41000000008CEB2341000000C0692C5A416666666690EB2341666666466B2C5A419A999999FEEB2341000000206C2C5A413333333339EC23419A9999D9682C5A416666666654EC23419A999919672C5A413333333361EC234100000040662C5A41CDCCCCCC6DEC2341CDCCCC0C652C5A410000000086EC23419A999939622C5A4166666666A6EC2341CDCCCC0C5E2C5A4100000000AAEC23419A9999995D2C5A419A999999BFEC2341CDCCCCCC5A2C5A41666666668EED23419A999919402C5A410000000062EE234166666666242C5A41CDCCCCCC46EE23419A9999D9212C5A4100000000FFED2341333333131B2C5A41333333338DED234100000040102C5A4166666666D6EC234166666626FF2B5A4166666666B2EC2341CDCCCCCCFB2B5A41CDCCCCCCA6EC2341000000C0FA2B5A419A99999997EC2341CDCCCC4CF92B5A416666666686EC2341CDCCCCACF72B5A413333333312EC23419A9999B9EC2B5A41CDCCCCCCBFEB23419A999999F72B5A416666666681EB23419A9999D9FF2B5A419A99999916EB23419A9999590E2C5A419A99999914EB234166666646102C5A416666666613EB2341333333D3102C5A419A99999910EB2341CDCCCC6C112C5A419A999999ECEA2341CDCCCC8C162C5A4166666666CFEA23419A9999191A2C5A4133333333AFEA2341CDCCCCCC1D2C5A4166666666A1EA23419A9999F91D2C5A419A9999999BEA23419A9999F91E2C5A41000000008FEA2341666666A6202C5A413333333309EA2341000000C0312C5A4133333333F4E923419A999939332C5A4100000000E7E92341CDCCCC2C342C5A4133333333DEE9234133333393342C5A41	01060000206A080000010000000103000000010000001100000033333333DEE9234133333393342C5A41CDCCCCCCB7EA23419A9999F94D2C5A41CDCCCCCC53EB234100000040612C5A416666666690EB2341666666466B2C5A419A999999FEEB2341000000206C2C5A413333333361EC234100000040662C5A410000000086EC23419A999939622C5A41666666668EED23419A999919402C5A410000000062EE234166666666242C5A413333333312EC23419A9999B9EC2B5A419A99999916EB23419A9999590E2C5A419A99999910EB2341CDCCCC6C112C5A4133333333AFEA2341CDCCCCCC1D2C5A41000000008FEA2341666666A6202C5A413333333309EA2341000000C0312C5A4133333333DEE9234133333393342C5A4133333333DEE9234133333393342C5A41	01010000206A0800008A25273836EC2341333333132B2C5A41	751051706	A	Saint-Victor 6	7510517	75105	75	11	0
01060000206A080000010000000103000000010000002C0000009A999999DEE7234100000020AF2C5A416666666601E8234133333393B52C5A419A99999905E82341CDCCCC6CB62C5A413333333315E8234166666666B72C5A413333333320E823419A9999B9B62C5A4100000000D5E82341CDCCCC6CAC2C5A419A99999908E9234133333353AA2C5A410000000001EA23419A999959A02C5A41CDCCCCCC5EEA23419A9999399D2C5A419A999999BFEA234166666666982C5A41CDCCCCCC43EB23419A999919902C5A4133333333CBEC2341CDCCCCEC772C5A41CDCCCCCC0AED23419A9999F9732C5A413333333370ED2341000000606C2C5A41CDCCCCCCCDED2341CDCCCC8C632C5A419A999999D8ED234100000080622C5A41666666666FEE2341000000E0532C5A419A9999991EEF2341666666063F2C5A413333333340EF2341666666463A2C5A41CDCCCCCC2DEF2341666666A6392C5A41666666660DEF234166666686352C5A41CDCCCCCCDAEE234100000080302C5A41CDCCCCCCA8EE2341CDCCCCCC2B2C5A410000000062EE234166666666242C5A41666666668EED23419A999919402C5A419A999999BFEC2341CDCCCCCC5A2C5A4100000000AAEC23419A9999995D2C5A4166666666A6EC2341CDCCCC0C5E2C5A410000000086EC23419A999939622C5A41CDCCCCCC6DEC2341CDCCCC0C652C5A413333333361EC234100000040662C5A416666666654EC23419A999919672C5A413333333339EC23419A9999D9682C5A419A999999FEEB2341000000206C2C5A41CDCCCCCCCCEB2341666666266F2C5A41CDCCCCCC9CEB234166666606722C5A416666666687EB234133333353732C5A4133333333E8EA2341000000407D2C5A41CDCCCCCC21EA2341666666C6882C5A419A99999998E92341000000C0902C5A419A999999DBE82341666666069D2C5A41333333339DE82341CDCCCCACA02C5A41CDCCCCCC5BE82341666666A6A52C5A419A999999DEE7234100000020AF2C5A41	01060000206A080000010000000103000000010000002C0000009A999999DEE7234100000020AF2C5A416666666601E8234133333393B52C5A419A99999905E82341CDCCCC6CB62C5A413333333315E8234166666666B72C5A413333333320E823419A9999B9B62C5A4100000000D5E82341CDCCCC6CAC2C5A419A99999908E9234133333353AA2C5A410000000001EA23419A999959A02C5A41CDCCCCCC5EEA23419A9999399D2C5A419A999999BFEA234166666666982C5A41CDCCCCCC43EB23419A999919902C5A4133333333CBEC2341CDCCCCEC772C5A41CDCCCCCC0AED23419A9999F9732C5A413333333370ED2341000000606C2C5A41CDCCCCCCCDED2341CDCCCC8C632C5A419A999999D8ED234100000080622C5A41666666666FEE2341000000E0532C5A419A9999991EEF2341666666063F2C5A413333333340EF2341666666463A2C5A41CDCCCCCC2DEF2341666666A6392C5A41666666660DEF234166666686352C5A41CDCCCCCCDAEE234100000080302C5A41CDCCCCCCA8EE2341CDCCCCCC2B2C5A410000000062EE234166666666242C5A41666666668EED23419A999919402C5A419A999999BFEC2341CDCCCCCC5A2C5A4100000000AAEC23419A9999995D2C5A4166666666A6EC2341CDCCCC0C5E2C5A410000000086EC23419A999939622C5A41CDCCCCCC6DEC2341CDCCCC0C652C5A413333333361EC234100000040662C5A416666666654EC23419A999919672C5A413333333339EC23419A9999D9682C5A419A999999FEEB2341000000206C2C5A41CDCCCCCCCCEB2341666666266F2C5A41CDCCCCCC9CEB234166666606722C5A416666666687EB234133333353732C5A4133333333E8EA2341000000407D2C5A41CDCCCCCC21EA2341666666C6882C5A419A99999998E92341000000C0902C5A419A999999DBE82341666666069D2C5A41333333339DE82341CDCCCCACA02C5A41CDCCCCCC5BE82341666666A6A52C5A419A999999DEE7234100000020AF2C5A41	01010000206A080000A6B53CAAA0EC2341333333C36D2C5A41	751051799	D	Seine et Berges 1	7510517	75105	75	11	0
01060000206A080000010000000103000000010000001B00000033333333D1EB2341666666865E2B5A4133333333B3EC23419A999939662B5A4100000000D1EC234133333353672B5A4100000000EEEC2341000000A0682B5A419A9999991BED2341666666E66A2B5A419A99999937ED2341666666866C2B5A41CDCCCCCC62ED2341CDCCCC0C6E2B5A419A99999970ED23419A9999396E2B5A413333333305EE2341000000406F2B5A41CDCCCCCC2AEE2341000000406F2B5A4100000000B9EE23419A9999796F2B5A419A999999CAEE2341000000A06E2B5A41CDCCCCCCE5EE2341666666A66C2B5A419A999999D4EE23419A999999682B5A4100000000C9EE2341333333B3652B5A41CDCCCCCCC4EE2341CDCCCC4C642B5A419A99999939EE23419A9999395C2B5A41CDCCCCCCA5ED2341CDCCCCAC532B5A416666666648ED23419A9999194E2B5A4166666666F2EC2341333333F3482B5A410000000081EC2341CDCCCC2C422B5A413333333311EC23419A9999793B2B5A419A9999990DEC2341333333533C2B5A4133333333FFEB2341333333D3442B5A4100000000FDEB234166666666462B5A419A999999E4EB2341CDCCCCEC532B5A4133333333D1EB2341666666865E2B5A41	01060000206A080000010000000103000000010000000B00000033333333D1EB2341666666865E2B5A4100000000D1EC234133333353672B5A41CDCCCCCC62ED2341CDCCCC0C6E2B5A413333333305EE2341000000406F2B5A4100000000B9EE23419A9999796F2B5A41CDCCCCCCE5EE2341666666A66C2B5A41CDCCCCCCC4EE2341CDCCCC4C642B5A41CDCCCCCCA5ED2341CDCCCCAC532B5A413333333311EC23419A9999793B2B5A4133333333D1EB2341666666865E2B5A4133333333D1EB2341666666865E2B5A41	01010000206A080000AADFC96EE7EC234134333313582B5A41	751051801	H	Jardin des Plantes 1	7510518	75105	75	11	0
01060000206A0800000100000001030000000100000020000000333333336CE82341CDCCCC2C3D2B5A4100000000C0E823419A9999F93F2B5A41CDCCCCCCECE8234133333373412B5A41CDCCCCCCA1E9234100000060472B5A4133333333BFE923419A999959482B5A41CDCCCCCCDEE9234166666626492B5A419A99999941EA2341CDCCCC8C4B2B5A41CDCCCCCC4CEA2341333333F34B2B5A4133333333D1EA234166666686522B5A4133333333F8EA234166666666542B5A41333333335DEB234100000020592B5A413333333373EB2341000000005A2B5A410000000084EB2341333333535A2B5A4133333333A4EB2341CDCCCCCC5B2B5A4166666666B3EB2341333333335D2B5A4133333333D1EB2341666666865E2B5A419A999999E4EB2341CDCCCCEC532B5A4100000000FDEB234166666666462B5A4133333333FFEB2341333333D3442B5A419A9999990DEC2341333333533C2B5A413333333311EC23419A9999793B2B5A41000000000DEC23419A9999393B2B5A419A9999996FEB2341000000C0312B5A41CDCCCCCC12EB2341CDCCCC4C2C2B5A41333333338CEA234166666666242B5A4166666666C2E92341CDCCCC8C182B5A419A9999998CE9234100000060152B5A419A99999915E923419A9999990E2B5A419A99999902E923419A999959132B5A416666666601E92341666666A6132B5A410000000097E8234166666606312B5A41333333336CE82341CDCCCC2C3D2B5A41	01060000206A080000010000000103000000010000000A000000333333336CE82341CDCCCC2C3D2B5A4133333333BFE923419A999959482B5A41CDCCCCCC4CEA2341333333F34B2B5A4133333333D1EB2341666666865E2B5A413333333311EC23419A9999793B2B5A419A9999996FEB2341000000C0312B5A419A9999998CE9234100000060152B5A419A99999915E923419A9999990E2B5A41333333336CE82341CDCCCC2C3D2B5A41333333336CE82341CDCCCC2C3D2B5A41	01010000206A08000049DE5F0721EA2341CDCCCC7C362B5A41	751051802	H	Jardin des Plantes 2	7510518	75105	75	11	0
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	01060000206A08000001000000010300000001000000130000000000000071E7234133333393172B5A410000000009E8234100000080522B5A419A999999EBE72341CDCCCCCC5E2B5A419A999999E6E723419A9999796E2B5A41CDCCCCCCD5E72341333333937F2B5A419A999999D5E72341CDCCCC2C902B5A41000000000EE82341333333F3902B5A41CDCCCCCC15E82341666666268D2B5A419A99999978E8234133333313882B5A419A99999973E82341CDCCCC4C842B5A41666666661EE92341000000007F2B5A41CDCCCCCCFCE82341000000A0712B5A41000000007EE823419A9999D9472B5A41333333336CE82341CDCCCC2C3D2B5A419A99999915E923419A9999990E2B5A413333333368E8234133333333112B5A41CDCCCCCC7AE723419A999979162B5A410000000071E7234133333393172B5A410000000071E7234133333393172B5A41	01010000206A0800008FB730874EE82341CDCCCC7C502B5A41	751051803	H	Jardin des Plantes 3	7510518	75105	75	11	0
01060000206A080000010000000103000000010000002E000000333333336CE82341CDCCCC2C3D2B5A41CDCCCCCC70E82341333333F33F2B5A41000000007EE823419A9999D9472B5A410000000083E8234166666606492B5A413333333393E823419A9999794E2B5A419A999999A7E8234166666606552B5A4100000000CFE82341000000A0622B5A41CDCCCCCCD9E8234166666686652B5A4166666666DEE8234100000040672B5A4133333333F0E82341CDCCCC2C6D2B5A41CDCCCCCCFCE82341000000A0712B5A416666666604E92341CDCCCC8C742B5A410000000019E923419A9999997C2B5A41666666661EE92341000000007F2B5A410000000038E92341000000E07D2B5A41CDCCCCCC91E9234100000080792B5A4133333333A8E92341000000C0782B5A4166666666D5E92341000000A0762B5A4100000000E6E923419A9999D9752B5A4133333333FAE923419A9999B9752B5A41CDCCCCCC00EA2341000000E0752B5A410000000053EA234166666686792B5A4133333333B9EA23419A9999797E2B5A4133333333D1EA2341666666A67F2B5A41000000004AEB234100000060852B5A41CDCCCCCC75EB2341333333B3872B5A416666666686EB2341000000C07D2B5A41333333338BEB2341333333737B2B5A41CDCCCCCCADEB234166666666692B5A41CDCCCCCCC6EB234166666686602B5A4133333333D1EB2341666666865E2B5A4166666666B3EB2341333333335D2B5A4133333333A4EB2341CDCCCCCC5B2B5A410000000084EB2341333333535A2B5A413333333373EB2341000000005A2B5A41333333335DEB234100000020592B5A4133333333F8EA234166666666542B5A4133333333D1EA234166666686522B5A41CDCCCCCC4CEA2341333333F34B2B5A419A99999941EA2341CDCCCC8C4B2B5A41CDCCCCCCDEE9234166666626492B5A4133333333BFE923419A999959482B5A41CDCCCCCCA1E9234100000060472B5A41CDCCCCCCECE8234133333373412B5A4100000000C0E823419A9999F93F2B5A41333333336CE82341CDCCCC2C3D2B5A41	01060000206A080000010000000103000000010000000D000000333333336CE82341CDCCCC2C3D2B5A41000000007EE823419A9999D9472B5A41CDCCCCCCFCE82341000000A0712B5A41666666661EE92341000000007F2B5A4100000000E6E923419A9999D9752B5A410000000053EA234166666686792B5A41CDCCCCCC75EB2341333333B3872B5A41CDCCCCCCADEB234166666666692B5A4133333333D1EB2341666666865E2B5A41CDCCCCCC4CEA2341333333F34B2B5A4133333333BFE923419A999959482B5A41333333336CE82341CDCCCC2C3D2B5A41333333336CE82341CDCCCC2C3D2B5A41	01010000206A080000429971E647EA234133333393612B5A41	751051804	H	Jardin des Plantes 4	7510518	75105	75	11	0
01060000206A0800000100000001030000000100000030000000CDCCCCCC75EB2341333333B3872B5A419A999999EBEB2341000000008D2B5A41333333339BEC2341000000C0952B5A410000000046ED2341CDCCCCEC9D2B5A419A99999967ED2341000000809F2B5A410000000058EE234100000000AB2B5A41666666668EEE2341000000A0AD2B5A41CDCCCCCC93EE23419A9999D9AD2B5A419A999999EFEE234133333313B22B5A41333333337EEF23419A9999D9B82B5A419A9999999BEF23419A999939BA2B5A4166666666B3EF2341CDCCCC2CBB2B5A410000000001F02341666666A6BE2B5A413333333314F02341CDCCCCECBE2B5A41CDCCCCCC2CF0234100000020BE2B5A41000000001FF0234133333393BA2B5A419A9999990FF0234133333353B62B5A4133333333FFEF234166666606B22B5A4100000000DDEF2341666666A6A92B5A4133333333D4EF234133333373A72B5A419A999999CBEF2341CDCCCC4CA52B5A4166666666B6EF2341000000C09F2B5A41000000009BEF234133333313992B5A41000000006CEF2341666666A68C2B5A41333333334DEF234133333313852B5A410000000041EF2341000000A0822B5A41CDCCCCCC37EF234100000080802B5A41CDCCCCCC1CEF23419A9999B9792B5A41CDCCCCCC09EF23419A999939752B5A4100000000E6EE2341333333B36C2B5A41CDCCCCCCE5EE2341666666A66C2B5A419A999999CAEE2341000000A06E2B5A4100000000B9EE23419A9999796F2B5A41CDCCCCCC2AEE2341000000406F2B5A413333333305EE2341000000406F2B5A419A99999970ED23419A9999396E2B5A41CDCCCCCC62ED2341CDCCCC0C6E2B5A419A99999937ED2341666666866C2B5A419A9999991BED2341666666E66A2B5A4100000000EEEC2341000000A0682B5A4100000000D1EC234133333353672B5A4133333333B3EC23419A999939662B5A4133333333D1EB2341666666865E2B5A41CDCCCCCCC6EB234166666686602B5A41CDCCCCCCADEB234166666666692B5A41333333338BEB2341333333737B2B5A416666666686EB2341000000C07D2B5A41CDCCCCCC75EB2341333333B3872B5A41	01060000206A0800000100000001030000000100000010000000CDCCCCCC75EB2341333333B3872B5A419A999999EBEB2341000000008D2B5A41333333339BEC2341000000C0952B5A41CDCCCCCC93EE23419A9999D9AD2B5A410000000001F02341666666A6BE2B5A41CDCCCCCC2CF0234100000020BE2B5A41000000006CEF2341666666A68C2B5A41CDCCCCCCE5EE2341666666A66C2B5A4100000000B9EE23419A9999796F2B5A413333333305EE2341000000406F2B5A41CDCCCCCC62ED2341CDCCCC0C6E2B5A4100000000D1EC234133333353672B5A4133333333D1EB2341666666865E2B5A41CDCCCCCCADEB234166666666692B5A41CDCCCCCC75EB2341333333B3872B5A41CDCCCCCC75EB2341333333B3872B5A41	01010000206A0800008682F9A2E0ED234100000060912B5A41	751051805	H	Jardin des Plantes 5	7510518	75105	75	11	0
01060000206A080000010000000103000000010000001B000000666666661EE92341000000007F2B5A41000000002FE923419A999939952B5A41666666663CE923419A999919A42B5A419A99999994E92341666666E6A42B5A41CDCCCCCC22EA2341666666A6A52B5A41333333331BEA23419A999959A92B5A419A99999979EA2341666666A6A92B5A4100000000A0EA234166666606AA2B5A419A999999A4EA234166666626A62B5A4133333333B6EA2341CDCCCCAC962B5A4133333333BDEA2341666666468E2B5A419A999999E3EA23419A9999198F2B5A416666666663EB2341666666C6922B5A416666666666EB234100000020912B5A41CDCCCCCC75EB2341333333B3872B5A41000000004AEB234100000060852B5A4133333333D1EA2341666666A67F2B5A4133333333B9EA23419A9999797E2B5A410000000053EA234166666686792B5A41CDCCCCCC00EA2341000000E0752B5A4133333333FAE923419A9999B9752B5A4100000000E6E923419A9999D9752B5A4166666666D5E92341000000A0762B5A4133333333A8E92341000000C0782B5A41CDCCCCCC91E9234100000080792B5A410000000038E92341000000E07D2B5A41666666661EE92341000000007F2B5A41	01060000206A080000010000000103000000010000000C000000666666661EE92341000000007F2B5A41666666663CE923419A999919A42B5A41CDCCCCCC22EA2341666666A6A52B5A41333333331BEA23419A999959A92B5A4100000000A0EA234166666606AA2B5A4133333333BDEA2341666666468E2B5A416666666663EB2341666666C6922B5A41CDCCCCCC75EB2341333333B3872B5A410000000053EA234166666686792B5A4100000000E6E923419A9999D9752B5A41666666661EE92341000000007F2B5A41666666661EE92341000000007F2B5A41	01010000206A0800002005D36CF3E92341CDCCCC1C902B5A41	751051806	H	Jardin des Plantes 6	7510518	75105	75	11	0
01060000206A080000010000000103000000010000002A00000066666666A2E72341CDCCCC6CE52B5A41CDCCCCCCD1E723419A999979E22B5A4133333333E6E72341CDCCCC8CE12B5A419A99999943E8234166666646DD2B5A41666666665CE8234166666626DC2B5A41CDCCCCCC91E82341CDCCCCCCD92B5A419A999999C4E82341666666A6D72B5A419A999999F3E82341666666A6D52B5A410000000062E92341CDCCCC8CD02B5A41CDCCCCCC55E923419A9999B9C12B5A416666666650E92341666666E6BA2B5A419A99999949E92341000000C0B22B5A41666666663CE923419A999919A42B5A41000000002FE923419A999939952B5A41666666661EE92341000000007F2B5A41CDCCCCCCE4E82341000000A0802B5A4100000000BAE8234133333373822B5A4166666666A3E8234100000040832B5A419A99999973E82341CDCCCC4C842B5A419A99999978E8234133333313882B5A413333333352E823419A9999398A2B5A410000000029E82341666666268C2B5A41CDCCCCCC15E82341666666268D2B5A410000000010E82341000000208E2B5A419A9999990EE823419A9999398F2B5A41000000000EE82341333333F3902B5A419A99999900E82341000000C0902B5A419A999999D5E72341CDCCCC2C902B5A4100000000D7E723419A999959922B5A41CDCCCCCCDBE72341CDCCCC4C972B5A41CDCCCCCCE8E723419A999999A22B5A4100000000EBE723419A9999D9A42B5A41CDCCCCCCEDE72341333333D3A62B5A419A999999EDE7234100000080A92B5A4133333333EAE7234100000080AC2B5A4133333333E6E72341666666C6AF2B5A4166666666D7E723419A9999F9BD2B5A4100000000D3E7234133333393BF2B5A41CDCCCCCCCAE7234100000020C32B5A4166666666B8E7234166666646D02B5A4166666666A4E7234100000020E22B5A4166666666A2E72341CDCCCC6CE52B5A41	01060000206A080000010000000103000000010000000F00000066666666A2E72341CDCCCC6CE52B5A41CDCCCCCCD1E723419A999979E22B5A410000000062E92341CDCCCC8CD02B5A41000000002FE923419A999939952B5A41666666661EE92341000000007F2B5A419A99999973E82341CDCCCC4C842B5A419A99999978E8234133333313882B5A41CDCCCCCC15E82341666666268D2B5A41000000000EE82341333333F3902B5A419A999999D5E72341CDCCCC2C902B5A41CDCCCCCCEDE72341333333D3A62B5A4166666666D7E723419A9999F9BD2B5A4166666666B8E7234166666646D02B5A4166666666A2E72341CDCCCC6CE52B5A4166666666A2E72341CDCCCC6CE52B5A41	01010000206A0800002465667496E8234133333343B12B5A41	751051807	H	Jardin des Plantes 7	7510518	75105	75	11	0
01060000206A080000010000000103000000010000001B000000666666663CE923419A999919A42B5A419A99999949E92341000000C0B22B5A416666666650E92341666666E6BA2B5A41CDCCCCCC55E923419A9999B9C12B5A410000000062E92341CDCCCC8CD02B5A4133333333A4E9234133333353CE2B5A4133333333CAE92341666666C6CD2B5A41333333332FEA234133333373CD2B5A419A99999959EA234166666606CD2B5A41CDCCCCCC77EA234166666606CD2B5A4133333333A5EA2341333333D3CC2B5A4166666666EEEA2341666666C6CC2B5A4100000000F8EA2341333333B3CA2B5A419A99999917EB234166666626BA2B5A416666666629EB2341000000E0B02B5A419A99999936EB234133333313AA2B5A416666666663EB2341666666C6922B5A419A999999E3EA23419A9999198F2B5A4133333333BDEA2341666666468E2B5A4133333333B6EA2341CDCCCCAC962B5A419A999999A4EA234166666626A62B5A4100000000A0EA234166666606AA2B5A419A99999979EA2341666666A6A92B5A41333333331BEA23419A999959A92B5A41CDCCCCCC22EA2341666666A6A52B5A419A99999994E92341666666E6A42B5A41666666663CE923419A999919A42B5A41	01060000206A080000010000000103000000010000000C000000666666663CE923419A999919A42B5A410000000062E92341CDCCCC8CD02B5A4133333333CAE92341666666C6CD2B5A4166666666EEEA2341666666C6CC2B5A4100000000F8EA2341333333B3CA2B5A416666666663EB2341666666C6922B5A4133333333BDEA2341666666468E2B5A4100000000A0EA234166666606AA2B5A41333333331BEA23419A999959A92B5A41CDCCCCCC22EA2341666666A6A52B5A41666666663CE923419A999919A42B5A41666666663CE923419A999919A42B5A41	01010000206A0800003FBD6D6C3AEA23419A999979AD2B5A41	751051808	H	Jardin des Plantes 8	7510518	75105	75	11	0
01060000206A080000010000000103000000010000003700000033333333E2EA234133333393D12B5A413333333312EB234166666666D42B5A41CDCCCCCC4AEB2341666666C6D92B5A41000000004FEB2341CDCCCC2CDA2B5A416666666674EB23419A9999B9DD2B5A410000000099EB23419A999939E12B5A413333333308EC2341CDCCCCCCEB2B5A413333333312EC23419A9999B9EC2B5A416666666686EC2341CDCCCCACF72B5A419A99999997EC2341CDCCCC4CF92B5A41CDCCCCCCA6EC2341000000C0FA2B5A4166666666B2EC2341CDCCCCCCFB2B5A4166666666D6EC234166666626FF2B5A41333333338DED234100000040102C5A4100000000FFED2341333333131B2C5A41CDCCCCCC46EE23419A9999D9212C5A410000000062EE234166666666242C5A4133333333C5EE234133333353172C5A419A999999D8EF23419A999919F32B5A419A999999E7EF234100000020F12B5A4133333333F8EF2341333333F3EE2B5A41CDCCCCCC07F02341666666E6EC2B5A41000000003CF023419A999919E52B5A419A99999968F023419A999919E12B5A413333333384F02341333333F3DB2B5A416666666688F02341CDCCCC2CDB2B5A410000000094F0234133333333D92B5A419A9999999BF02341CDCCCCCCD72B5A41000000006BF02341000000A0CC2B5A410000000063F02341CDCCCCECCA2B5A413333333354F0234166666666C72B5A41CDCCCCCC2CF0234100000020BE2B5A413333333314F02341CDCCCCECBE2B5A410000000001F02341666666A6BE2B5A4166666666B3EF2341CDCCCC2CBB2B5A419A9999999BEF23419A999939BA2B5A41333333337EEF23419A9999D9B82B5A419A999999EFEE234133333313B22B5A41CDCCCCCC93EE23419A9999D9AD2B5A41666666668EEE2341000000A0AD2B5A410000000058EE234100000000AB2B5A419A99999967ED2341000000809F2B5A410000000046ED2341CDCCCCEC9D2B5A41333333339BEC2341000000C0952B5A419A999999EBEB2341000000008D2B5A41CDCCCCCC75EB2341333333B3872B5A416666666666EB234100000020912B5A416666666663EB2341666666C6922B5A419A99999936EB234133333313AA2B5A416666666629EB2341000000E0B02B5A419A99999917EB234166666626BA2B5A4100000000F8EA2341333333B3CA2B5A4166666666EEEA2341666666C6CC2B5A419A999999E7EA2341666666E6CE2B5A4133333333E2EA234133333393D12B5A41	01060000206A080000010000000103000000010000001200000033333333E2EA234133333393D12B5A413333333312EB234166666666D42B5A41CDCCCCCCA6EC2341000000C0FA2B5A410000000062EE234166666666242C5A41CDCCCCCC07F02341666666E6EC2B5A41000000003CF023419A999919E52B5A419A99999968F023419A999919E12B5A419A9999999BF02341CDCCCCCCD72B5A41CDCCCCCC2CF0234100000020BE2B5A410000000001F02341666666A6BE2B5A41CDCCCCCC93EE23419A9999D9AD2B5A41333333339BEC2341000000C0952B5A419A999999EBEB2341000000008D2B5A41CDCCCCCC75EB2341333333B3872B5A416666666663EB2341666666C6922B5A4100000000F8EA2341333333B3CA2B5A4133333333E2EA234133333393D12B5A4133333333E2EA234133333393D12B5A41	01010000206A080000D60A7027DCED23419A999919D62B5A41	751051809	D	Jardin des Plantes	7510518	75105	75	11	0
01060000206A080000010000000103000000010000001E0000000000000062EE234166666666242C5A41CDCCCCCCA8EE2341CDCCCCCC2B2C5A41CDCCCCCCDAEE234100000080302C5A41666666660DEF234166666686352C5A41CDCCCCCC2DEF2341666666A6392C5A413333333340EF2341666666463A2C5A41CDCCCCCC5DF0234100000080112C5A41333333334BF1234166666666EF2B5A419A99999921F123419A9999B9EA2B5A4133333333D7F023419A9999D9E22B5A41CDCCCCCCCCF02341666666C6E12B5A4133333333BDF0234100000020E02B5A4100000000BCF02341333333D3DF2B5A4133333333B0F023419A9999D9DC2B5A4100000000AAF0234133333353DB2B5A419A999999A5F02341CDCCCC2CDA2B5A419A999999A4F02341333333F3D92B5A41000000009FF023419A999999D82B5A419A9999999BF02341CDCCCCCCD72B5A410000000094F0234133333333D92B5A416666666688F02341CDCCCC2CDB2B5A413333333384F02341333333F3DB2B5A419A99999968F023419A999919E12B5A41000000003CF023419A999919E52B5A41CDCCCCCC07F02341666666E6EC2B5A4133333333F8EF2341333333F3EE2B5A419A999999E7EF234100000020F12B5A419A999999D8EF23419A999919F32B5A4133333333C5EE234133333353172C5A410000000062EE234166666666242C5A41	01060000206A080000010000000103000000010000000A0000000000000062EE234166666666242C5A413333333340EF2341666666463A2C5A41333333334BF1234166666666EF2B5A4133333333BDF0234100000020E02B5A419A9999999BF02341CDCCCCCCD72B5A419A99999968F023419A999919E12B5A41000000003CF023419A999919E52B5A41CDCCCCCC07F02341666666E6EC2B5A410000000062EE234166666666242C5A410000000062EE234166666666242C5A41	01010000206A0800006A72D55416F02341CDCCCC4C022C5A41	751051899	D	Seine et Berges 2	7510518	75105	75	11	0
01060000206A08000001000000010300000001000000190000006666666672E52341CDCCCC2C282B5A41000000007AE52341CDCCCC4C312B5A413333333382E52341CDCCCC2C382B5A416666666694E52341CDCCCC6C472B5A4166666666A1E5234100000040522B5A41CDCCCCCCA4E52341333333D3552B5A4133333333BEE52341000000C0702B5A413333333373E6234166666606632B5A410000000024E72341CDCCCC6C552B5A41CDCCCCCC96E72341CDCCCC8C4C2B5A4166666666EBE723419A999979462B5A41CDCCCCCCD9E7234133333353402B5A419A99999996E723419A999919262B5A41333333338AE723419A999979212B5A419A9999997BE72341000000C01B2B5A410000000071E7234133333393172B5A41CDCCCCCC7AE723419A999979162B5A41CDCCCCCC6EE723419A9999B9162B5A419A9999995BE72341CDCCCC2C172B5A41333333336DE62341CDCCCCAC1C2B5A419A9999995DE62341CDCCCC0C1D2B5A419A9999994CE62341CDCCCC8C1D2B5A4166666666ECE52341000000A0212B5A410000000073E5234133333393262B5A416666666672E52341CDCCCC2C282B5A41	01060000206A080000010000000103000000010000000C0000006666666672E52341CDCCCC2C282B5A41000000007AE52341CDCCCC4C312B5A4166666666A1E5234100000040522B5A4133333333BEE52341000000C0702B5A41CDCCCCCC96E72341CDCCCC8C4C2B5A4166666666EBE723419A999979462B5A410000000071E7234133333393172B5A41CDCCCCCC7AE723419A999979162B5A419A9999994CE62341CDCCCC8C1D2B5A410000000073E5234133333393262B5A416666666672E52341CDCCCC2C282B5A416666666672E52341CDCCCC2C282B5A41	01010000206A0800009A6B2319B9E6234166666666432B5A41	751051901	H	Val de Grâce 1	7510519	75105	75	11	0
01060000206A0800000100000001030000000100000025000000000000001EE22341333333B3492B5A419A99999946E22341CDCCCCCC552B5A41CDCCCCCC49E223419A9999B9562B5A410000000071E22341CDCCCC6C622B5A419A999999C5E22341000000C0792B5A41CDCCCCCCC5E22341333333D3792B5A419A999999DDE223419A999999802B5A4133333333F5E2234100000080872B5A41CDCCCCCCF8E2234166666646892B5A4100000000FAE22341666666C68A2B5A419A999999FDE22341CDCCCC6C8C2B5A410000000003E3234100000000902B5A410000000008E3234133333393972B5A41CDCCCCCC0FE32341666666A6A32B5A4166666666BEE32341CDCCCC2C962B5A419A9999992DE42341333333F38D2B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A413333333347E5234100000060792B5A4133333333BEE52341000000C0702B5A41CDCCCCCCA4E52341333333D3552B5A4166666666A1E5234100000040522B5A416666666694E52341CDCCCC6C472B5A413333333382E52341CDCCCC2C382B5A41000000007AE52341CDCCCC4C312B5A416666666672E52341CDCCCC2C282B5A410000000073E5234133333393262B5A416666666671E52341666666A6262B5A4166666666DCE42341000000C02C2B5A41333333338FE42341CDCCCCCC2F2B5A4100000000EBE3234100000040362B5A419A999999D4E3234100000020372B5A41000000007CE323419A9999D93A2B5A41666666661BE323419A9999D93E2B5A410000000090E223419A9999B9442B5A413333333354E2234166666646472B5A41666666661EE22341CDCCCCAC492B5A41000000001EE22341333333B3492B5A41	01060000206A080000010000000103000000010000000E000000000000001EE22341333333B3492B5A410000000071E22341CDCCCC6C622B5A4133333333F5E2234100000080872B5A410000000003E3234100000000902B5A41CDCCCCCC0FE32341666666A6A32B5A419A9999992DE42341333333F38D2B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A4133333333BEE52341000000C0702B5A4166666666A1E5234100000040522B5A41000000007AE52341CDCCCC4C312B5A410000000073E5234133333393262B5A419A999999D4E3234100000020372B5A41000000001EE22341333333B3492B5A41000000001EE22341333333B3492B5A41	01010000206A0800003A0AF83521E4234166666696692B5A41	751051902	H	Val de Grâce 2	7510519	75105	75	11	0
01060000206A080000010000000103000000010000001D0000009A99999961E023419A999999602B5A419A9999996BE02341333333B36C2B5A416666666670E023419A999939762B5A419A99999970E0234100000080762B5A416666666674E02341333333737E2B5A419A99999986E02341CDCCCC6C7E2B5A419A99999993E02341CDCCCCCC7E2B5A419A999999A1E02341333333737F2B5A4166666666ACE0234133333373802B5A41CDCCCCCCBBE023419A9999F9812B5A4166666666DBE02341666666468C2B5A41CDCCCCCC06E123419A9999599A2B5A4133333333B8E12341333333D3902B5A413333333335E22341CDCCCCEC892B5A419A999999C3E2234166666606822B5A419A999999DDE223419A999999802B5A41CDCCCCCCC5E22341333333D3792B5A419A999999C5E22341000000C0792B5A410000000071E22341CDCCCC6C622B5A41CDCCCCCC49E223419A9999B9562B5A419A99999946E22341CDCCCCCC552B5A41000000001EE22341333333B3492B5A413333333357E12341333333D3532B5A413333333342E12341CDCCCCEC542B5A416666666619E12341CDCCCC0C572B5A419A999999E4E02341666666C6592B5A419A999999B9E02341000000005C2B5A413333333370E02341000000E05F2B5A419A99999961E023419A999999602B5A41	01060000206A08000001000000010300000001000000090000009A99999961E023419A999999602B5A416666666674E02341333333737E2B5A41CDCCCCCCBBE023419A9999F9812B5A41CDCCCCCC06E123419A9999599A2B5A419A999999DDE223419A999999802B5A410000000071E22341CDCCCC6C622B5A41000000001EE22341333333B3492B5A419A99999961E023419A999999602B5A419A99999961E023419A999999602B5A41	01010000206A0800009AA644C58AE1234166666676712B5A41	751051903	H	Val de Grâce 3	7510519	75105	75	11	0
01060000206A080000010000000103000000010000001B000000CDCCCCCC06E123419A9999599A2B5A416666666649E1234100000020AF2B5A419A9999998FE12341CDCCCCECC62B5A4100000000BFE123419A999979D62B5A4100000000EAE1234133333333D52B5A4133333333F0E12341CDCCCC0CD52B5A413333333305E2234166666686D42B5A419A99999966E22341000000E0D02B5A419A9999998AE2234133333373CF2B5A419A999999A3E2234100000040CE2B5A410000000023E323419A999939C72B5A416666666636E3234166666626C62B5A41333333331EE323419A9999F9BD2B5A419A9999991AE32341CDCCCC6CBB2B5A41CDCCCCCC17E323419A999919B52B5A41CDCCCCCC0FE32341666666A6A32B5A410000000008E3234133333393972B5A410000000003E3234100000000902B5A419A999999FDE22341CDCCCC6C8C2B5A4100000000FAE22341666666C68A2B5A41CDCCCCCCF8E2234166666646892B5A4133333333F5E2234100000080872B5A419A999999DDE223419A999999802B5A419A999999C3E2234166666606822B5A413333333335E22341CDCCCCEC892B5A4133333333B8E12341333333D3902B5A41CDCCCCCC06E123419A9999599A2B5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC06E123419A9999599A2B5A416666666649E1234100000020AF2B5A4100000000BFE123419A999979D62B5A419A9999998AE2234133333373CF2B5A416666666636E3234166666626C62B5A419A9999991AE32341CDCCCC6CBB2B5A410000000003E3234100000000902B5A4133333333F5E2234100000080872B5A419A999999DDE223419A999999802B5A41CDCCCCCC06E123419A9999599A2B5A41CDCCCCCC06E123419A9999599A2B5A41	01010000206A0800005235F7B724E2234133333363A92B5A41	751051904	H	Val de Grâce 4	7510519	75105	75	11	0
01060000206A080000010000000103000000010000001C00000000000000BFE123419A999979D62B5A419A9999997DE2234100000000182C5A4133333333A0E22341CDCCCCAC232C5A4100000000B7E22341CDCCCCEC2A2C5A4133333333D7E22341CDCCCC0C352C5A4133333333E7E223419A999959342C5A41666666660BE32341000000C0322C5A416666666652E32341333333D32F2C5A416666666678E323419A9999392E2C5A419A99999945E3234100000040222C5A4133333333CEE32341000000601B2C5A4100000000D6E32341333333B31A2C5A4166666666DFE3234166666626192C5A4100000000EDE3234133333373162C5A419A99999909E4234166666646122C5A4133333333E0E3234100000040042C5A419A999999ADE32341CDCCCCACF12B5A419A99999980E32341000000C0E12B5A413333333369E32341CDCCCC6CD82B5A416666666636E3234166666626C62B5A410000000023E323419A999939C72B5A419A999999A3E2234100000040CE2B5A419A9999998AE2234133333373CF2B5A419A99999966E22341000000E0D02B5A413333333305E2234166666686D42B5A4133333333F0E12341CDCCCC0CD52B5A4100000000EAE1234133333333D52B5A4100000000BFE123419A999979D62B5A41	01060000206A080000010000000103000000010000000C00000000000000BFE123419A999979D62B5A419A9999997DE2234100000000182C5A4133333333D7E22341CDCCCC0C352C5A416666666678E323419A9999392E2C5A419A99999945E3234100000040222C5A4133333333CEE32341000000601B2C5A419A99999909E4234166666646122C5A4133333333E0E3234100000040042C5A416666666636E3234166666626C62B5A419A9999998AE2234133333373CF2B5A4100000000BFE123419A999979D62B5A4100000000BFE123419A999979D62B5A41	01010000206A080000BDB18504F8E22341666666F6FA2B5A41	751051905	H	Val de Grâce 5	7510519	75105	75	11	0
01060000206A0800000100000001030000000100000024000000CDCCCCCC0FE32341666666A6A32B5A41CDCCCCCC17E323419A999919B52B5A419A9999991AE32341CDCCCC6CBB2B5A41333333331EE323419A9999F9BD2B5A416666666636E3234166666626C62B5A413333333369E32341CDCCCC6CD82B5A419A99999980E32341000000C0E12B5A419A999999ADE32341CDCCCCACF12B5A4133333333E0E3234100000040042C5A419A99999909E4234166666646122C5A419A99999964E42341CDCCCC4C0E2C5A416666666679E42341666666060D2C5A41333333338EE42341CDCCCC8C0B2C5A4100000000B5E42341000000A0072C5A4100000000F2E4234166666606012C5A419A999999F0E423419A9999B9FF2B5A4133333333F1E42341000000A0FE2B5A419A999999F6E42341666666E6FC2B5A4100000000FEE4234133333353FB2B5A41CDCCCCCC12E52341333333B3F72B5A419A99999926E5234133333333F42B5A41000000004CE52341000000A0EB2B5A419A99999963E5234133333373E62B5A413333333355E52341333333F3E02B5A419A9999992BE52341CDCCCCACD12B5A41CDCCCCCC14E52341CDCCCCACC82B5A4100000000F9E42341CDCCCCCCBE2B5A4100000000D5E42341CDCCCC2CB22B5A4166666666C5E42341666666C6AC2B5A413333333389E4234166666606982B5A419A99999977E4234133333313922B5A416666666670E42341000000E08F2B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A419A9999992DE42341333333F38D2B5A4166666666BEE32341CDCCCC2C962B5A41CDCCCCCC0FE32341666666A6A32B5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC0FE32341666666A6A32B5A41333333331EE323419A9999F9BD2B5A4133333333E0E3234100000040042C5A419A99999909E4234166666646122C5A41333333338EE42341CDCCCC8C0B2C5A4100000000F2E4234166666606012C5A4100000000FEE4234133333353FB2B5A419A99999926E5234133333333F42B5A419A99999963E5234133333373E62B5A41CDCCCCCC14E52341CDCCCCACC82B5A419A99999977E4234133333313922B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A419A9999992DE42341333333F38D2B5A41CDCCCCCC0FE32341666666A6A32B5A41CDCCCCCC0FE32341666666A6A32B5A41	01010000206A080000F0C55A1035E42341CDCCCC2CCD2B5A41	751051906	H	Val de Grâce 6	7510519	75105	75	11	0
01060000206A080000010000000103000000010000002B000000CDCCCCCC5FE42341CDCCCCEC8A2B5A416666666670E42341000000E08F2B5A419A99999977E4234133333313922B5A413333333389E4234166666606982B5A4166666666C5E42341666666C6AC2B5A4100000000D5E42341CDCCCC2CB22B5A4100000000F9E42341CDCCCCCCBE2B5A41CDCCCCCC14E52341CDCCCCACC82B5A419A9999992BE52341CDCCCCACD12B5A413333333355E52341333333F3E02B5A419A99999963E5234133333373E62B5A41000000004CE52341000000A0EB2B5A419A99999926E5234133333333F42B5A41CDCCCCCC12E52341333333B3F72B5A4100000000FEE4234133333353FB2B5A419A999999F6E42341666666E6FC2B5A4133333333F1E42341000000A0FE2B5A419A999999F0E423419A9999B9FF2B5A4100000000F2E4234166666606012C5A419A999999FBE4234166666646002C5A41CDCCCCCC15E52341CDCCCC6CFD2B5A41CDCCCCCC39E52341666666E6F92B5A410000000047E5234100000000F92B5A419A99999957E523419A9999D9F72B5A41000000008AE52341000000E0F42B5A419A99999923E6234166666686ED2B5A41666666667AE6234100000040E92B5A4166666666ABE623419A9999F9E62B5A4166666666C4E62341000000A0E52B5A4166666666E5E62341000000E0E32B5A4100000000F6E62341000000C0E22B5A41CDCCCCCCF7E62341CDCCCC4CDB2B5A4166666666F9E6234166666686D32B5A419A999999FAE6234100000000CC2B5A4133333333FEE623419A999959C52B5A416666666601E7234133333373BD2B5A413333333305E72341CDCCCC2CB72B5A41333333330AE7234100000040962B5A416666666603E7234133333353922B5A413333333367E62341CDCCCC0C822B5A4133333333BEE52341000000C0702B5A413333333347E5234100000060792B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A41	01060000206A0800000100000001030000000100000012000000CDCCCCCC5FE42341CDCCCCEC8A2B5A419A99999977E4234133333313922B5A41CDCCCCCC14E52341CDCCCCACC82B5A419A99999963E5234133333373E62B5A419A99999926E5234133333333F42B5A4100000000FEE4234133333353FB2B5A4100000000F2E4234166666606012C5A41CDCCCCCC39E52341666666E6F92B5A41000000008AE52341000000E0F42B5A4166666666ABE623419A9999F9E62B5A4100000000F6E62341000000C0E22B5A419A999999FAE6234100000000CC2B5A413333333305E72341CDCCCC2CB72B5A41333333330AE7234100000040962B5A416666666603E7234133333353922B5A4133333333BEE52341000000C0702B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A41CDCCCCCC5FE42341CDCCCCEC8A2B5A41	01010000206A08000035C681C0F7E5234100000050BA2B5A41	751051907	H	Val de Grâce 7	7510519	75105	75	11	0
01060000206A080000010000000103000000010000003700000033333333BEE52341000000C0702B5A413333333367E62341CDCCCC0C822B5A416666666603E7234133333353922B5A41333333330AE7234100000040962B5A413333333305E72341CDCCCC2CB72B5A416666666601E7234133333373BD2B5A4133333333FEE623419A999959C52B5A419A999999FAE6234100000000CC2B5A4166666666F9E6234166666686D32B5A41CDCCCCCCF7E62341CDCCCC4CDB2B5A4100000000F6E62341000000C0E22B5A419A99999959E72341000000C0E42B5A4166666666A2E72341CDCCCC6CE52B5A4166666666A4E7234100000020E22B5A4166666666B8E7234166666646D02B5A41CDCCCCCCCAE7234100000020C32B5A4100000000D3E7234133333393BF2B5A4166666666D7E723419A9999F9BD2B5A4133333333E6E72341666666C6AF2B5A4133333333EAE7234100000080AC2B5A419A999999EDE7234100000080A92B5A41CDCCCCCCEDE72341333333D3A62B5A4100000000EBE723419A9999D9A42B5A41CDCCCCCCE8E723419A999999A22B5A41CDCCCCCCDBE72341CDCCCC4C972B5A4100000000D7E723419A999959922B5A419A999999D5E72341CDCCCC2C902B5A4133333333D4E72341666666068D2B5A41CDCCCCCCD3E72341000000008A2B5A4166666666D4E7234100000060862B5A41CDCCCCCCD5E72341333333937F2B5A4133333333E2E723419A999939742B5A4133333333E4E72341CDCCCC4C712B5A419A999999E6E723419A9999796E2B5A4166666666E7E72341CDCCCC2C6C2B5A4100000000E7E72341666666E6692B5A4100000000E8E7234100000060662B5A419A999999E9E72341CDCCCC8C622B5A419A999999EBE72341CDCCCCCC5E2B5A4133333333F1E72341CDCCCC0C5C2B5A4100000000F6E72341CDCCCCCC592B5A4100000000FBE7234133333393572B5A4133333333FFE72341666666A6552B5A41CDCCCCCCFDE72341000000E0542B5A41CDCCCCCCFEE72341CDCCCC0C542B5A416666666601E823419A999959532B5A410000000005E82341CDCCCCCC522B5A410000000009E8234100000080522B5A4100000000F9E72341CDCCCC8C4C2B5A419A999999F0E723419A999979492B5A4166666666EBE723419A999979462B5A41CDCCCCCC96E72341CDCCCC8C4C2B5A410000000024E72341CDCCCC6C552B5A413333333373E6234166666606632B5A4133333333BEE52341000000C0702B5A41	01060000206A080000010000000103000000010000001300000033333333BEE52341000000C0702B5A416666666603E7234133333353922B5A41333333330AE7234100000040962B5A413333333305E72341CDCCCC2CB72B5A419A999999FAE6234100000000CC2B5A4100000000F6E62341000000C0E22B5A4166666666A2E72341CDCCCC6CE52B5A4166666666B8E7234166666646D02B5A4166666666D7E723419A9999F9BD2B5A41CDCCCCCCEDE72341333333D3A62B5A4100000000D7E723419A999959922B5A41CDCCCCCCD5E72341333333937F2B5A419A999999E6E723419A9999796E2B5A419A999999EBE72341CDCCCCCC5E2B5A410000000009E8234100000080522B5A4166666666EBE723419A999979462B5A41CDCCCCCC96E72341CDCCCC8C4C2B5A4133333333BEE52341000000C0702B5A4133333333BEE52341000000C0702B5A41	01010000206A080000A65535DB6FE72341CDCCCC4C942B5A41	751051908	H	Val de Grâce 8	7510519	75105	75	11	0
01060000206A080000010000000103000000010000003A0000009A999999E9E42341666666A61E2C5A416666666608E5234166666666202C5A413333333376E52341333333F3272C5A419A9999997BE5234100000020282C5A413333333384E5234133333313282C5A41CDCCCCCC03E6234133333353222C5A41CDCCCCCC3EE62341CDCCCCAC382C5A41CDCCCCCC69E6234100000040492C5A413333333328E62341000000C04F2C5A413333333320E62341666666A6502C5A4133333333F5E52341333333B3562C5A410000000000E6234133333393592C5A419A9999992DE62341666666C6652C5A4100000000A6E62341333333935F2C5A4133333333F5E62341000000805B2C5A41666666663FE72341CDCCCCAC572C5A41CDCCCCCC3DE72341333333B3472C5A41333333333FE7234133333373402C5A419A9999993CE72341CDCCCCAC382C5A416666666640E72341666666C6362C5A413333333349E7234100000020352C5A41333333334BE7234133333373342C5A41333333334CE72341666666E6322C5A419A9999994AE7234133333393312C5A41CDCCCCCC4AE7234133333393302C5A419A9999994EE72341CDCCCC4C2F2C5A41CDCCCCCC63E72341666666462C2C5A41666666666DE72341CDCCCC8C2A2C5A41CDCCCCCC71E72341000000A0282C5A41666666667FE72341CDCCCCCC1F2C5A416666666687E72341333333D3182C5A41666666668EE7234166666626132C5A416666666693E72341666666A6052C5A416666666693E7234100000040022C5A41666666668FE7234100000020FC2B5A419A99999990E72341666666A6F92B5A410000000098E723419A9999D9F22B5A4100000000A2E7234100000000E62B5A4166666666A2E72341CDCCCC6CE52B5A419A99999959E72341000000C0E42B5A4100000000F6E62341000000C0E22B5A4166666666E5E62341000000E0E32B5A4166666666C4E62341000000A0E52B5A4166666666ABE623419A9999F9E62B5A41666666667AE6234100000040E92B5A419A99999923E6234166666686ED2B5A41000000008AE52341000000E0F42B5A419A99999957E523419A9999D9F72B5A410000000047E5234100000000F92B5A41CDCCCCCC39E52341666666E6F92B5A41CDCCCCCC15E52341CDCCCC6CFD2B5A419A999999FBE4234166666646002C5A4100000000F2E4234166666606012C5A410000000002E52341CDCCCC4C062C5A410000000023E523419A9999F9102C5A419A9999990BE52341CDCCCCEC162C5A4100000000FDE42341666666861A2C5A419A999999E9E42341666666A61E2C5A41	01060000206A08000001000000010300000001000000170000009A999999E9E42341666666A61E2C5A413333333376E52341333333F3272C5A41CDCCCCCC03E6234133333353222C5A41CDCCCCCC69E6234100000040492C5A413333333320E62341666666A6502C5A4133333333F5E52341333333B3562C5A419A9999992DE62341666666C6652C5A41666666663FE72341CDCCCCAC572C5A419A9999993CE72341CDCCCCAC382C5A419A9999994EE72341CDCCCC4C2F2C5A41666666666DE72341CDCCCC8C2A2C5A41666666668EE7234166666626132C5A416666666693E72341666666A6052C5A41666666668FE7234100000020FC2B5A4166666666A2E72341CDCCCC6CE52B5A4100000000F6E62341000000C0E22B5A4166666666ABE623419A9999F9E62B5A41000000008AE52341000000E0F42B5A41CDCCCCCC39E52341666666E6F92B5A4100000000F2E4234166666606012C5A410000000023E523419A9999F9102C5A419A999999E9E42341666666A61E2C5A419A999999E9E42341666666A61E2C5A41	01010000206A08000016761233C1E6234133333323252C5A41	751052001	H	Sorbonne 1	7510520	75105	75	11	0
01060000206A080000010000000103000000010000003200000033333333D7E22341CDCCCC0C352C5A4133333333F0E22341CDCCCCEC3C2C5A4133333333F5E22341CDCCCC6C3E2C5A413333333305E3234166666666432C5A419A9999991AE323419A9999194A2C5A413333333333E32341CDCCCCEC512C5A410000000051E32341666666065B2C5A41666666665BE323419A9999395E2C5A41CDCCCCCC63E32341000000E0602C5A4166666666E2E323419A999979882C5A41CDCCCCCCFFE32341666666A6852C5A41000000002AE423419A999999822C5A419A99999977E42341000000A07C2C5A410000000007E42341333333F3582C5A413333333306E423419A9999B9582C5A41CDCCCCCCF4E32341333333F3522C5A4100000000F4E32341CDCCCCAC522C5A4166666666C1E32341CDCCCC0C422C5A419A9999992FE42341CDCCCCAC392C5A419A9999995DE42341CDCCCC2C362C5A419A99999973E4234166666646352C5A4166666666FCE423419A999999302C5A410000000028E52341000000A02E2C5A413333333337E52341CDCCCC8C2D2C5A41333333335EE52341CDCCCCCC2A2C5A413333333384E5234133333313282C5A419A9999997BE5234100000020282C5A413333333376E52341333333F3272C5A416666666608E5234166666666202C5A419A999999E9E42341666666A61E2C5A4100000000FDE42341666666861A2C5A419A9999990BE52341CDCCCCEC162C5A410000000023E523419A9999F9102C5A410000000002E52341CDCCCC4C062C5A4100000000F2E4234166666606012C5A4100000000B5E42341000000A0072C5A41333333338EE42341CDCCCC8C0B2C5A416666666679E42341666666060D2C5A419A99999964E42341CDCCCC4C0E2C5A419A99999909E4234166666646122C5A4100000000EDE3234133333373162C5A4166666666DFE3234166666626192C5A4100000000D6E32341333333B31A2C5A4133333333CEE32341000000601B2C5A419A99999945E3234100000040222C5A416666666678E323419A9999392E2C5A416666666652E32341333333D32F2C5A41666666660BE32341000000C0322C5A4133333333E7E223419A999959342C5A4133333333D7E22341CDCCCC0C352C5A41	01060000206A080000010000000103000000010000001200000033333333D7E22341CDCCCC0C352C5A4166666666E2E323419A999979882C5A419A99999977E42341000000A07C2C5A4166666666C1E32341CDCCCC0C422C5A419A9999995DE42341CDCCCC2C362C5A410000000028E52341000000A02E2C5A413333333384E5234133333313282C5A413333333376E52341333333F3272C5A419A999999E9E42341666666A61E2C5A410000000023E523419A9999F9102C5A4100000000F2E4234166666606012C5A41333333338EE42341CDCCCC8C0B2C5A419A99999909E4234166666646122C5A4133333333CEE32341000000601B2C5A419A99999945E3234100000040222C5A416666666678E323419A9999392E2C5A4133333333D7E22341CDCCCC0C352C5A4133333333D7E22341CDCCCC0C352C5A41	01010000206A0800007A686FCD6FE32341000000C0462C5A41	751052002	H	Sorbonne 2	7510520	75105	75	11	0
01060000206A080000010000000103000000010000002100000066666666E2E323419A999979882C5A4133333333F8E323419A999979902C5A41666666661AE42341333333139C2C5A419A99999921E423419A9999B99E2C5A419A9999992DE42341CDCCCCACA22C5A410000000036E4234133333353A52C5A419A99999945E4234133333393AB2C5A41CDCCCCCC54E423419A999999B12C5A416666666695E4234166666666CB2C5A410000000096E42341000000A0CB2C5A4133333333ADE423419A9999D9D42C5A4166666666C4E4234133333313DE2C5A41CDCCCCCCDAE423419A9999F9E62C5A419A99999921E523419A999959E32C5A4100000000C2E5234133333333DB2C5A419A999999CCE52341666666A6DA2C5A4100000000E8E5234166666646D92C5A41CDCCCCCCF8E5234166666666D82C5A419A9999993EE623419A9999D9D42C5A41CDCCCCCC4DE623419A999959D32C5A410000000036E6234166666666CB2C5A410000000005E623419A9999F9BA2C5A41CDCCCCCCD4E52341333333F3AA2C5A419A999999C2E52341333333D3A42C5A416666666694E5234100000060952C5A413333333360E52341CDCCCC2C842C5A41CDCCCCCC2BE5234100000000732C5A4133333333CEE42341666666C6772C5A41CDCCCCCC8EE42341666666067B2C5A419A99999977E42341000000A07C2C5A41000000002AE423419A999999822C5A41CDCCCCCCFFE32341666666A6852C5A4166666666E2E323419A999979882C5A41	01060000206A080000010000000103000000010000000A00000066666666E2E323419A999979882C5A410000000036E4234133333353A52C5A41CDCCCCCCDAE423419A9999F9E62C5A419A9999993EE623419A9999D9D42C5A41CDCCCCCC4DE623419A999959D32C5A416666666694E5234100000060952C5A41CDCCCCCC2BE5234100000000732C5A41CDCCCCCC8EE42341666666067B2C5A4166666666E2E323419A999979882C5A4166666666E2E323419A999979882C5A41	01010000206A080000198C6E7816E5234166666696AE2C5A41	751052003	H	Sorbonne 3	7510520	75105	75	11	0
01060000206A0800000100000001030000000100000026000000CDCCCCCC2BE5234100000000732C5A413333333360E52341CDCCCC2C842C5A416666666694E5234100000060952C5A419A999999C2E52341333333D3A42C5A41CDCCCCCCD4E52341333333F3AA2C5A410000000005E623419A9999F9BA2C5A410000000036E6234166666666CB2C5A41CDCCCCCC4DE623419A999959D32C5A41CDCCCCCC7DE62341CDCCCCCCCE2C5A413333333392E62341000000E0CC2C5A4100000000C9E62341333333B3C72C5A416666666620E72341CDCCCC6CBF2C5A41CDCCCCCCA9E7234133333353B32C5A419A999999DEE7234100000020AF2C5A4166666666C3E72341000000E0A62C5A4166666666BDE72341000000E0A42C5A41CDCCCCCCB0E72341333333B3A02C5A419A999999ABE72341000000209F2C5A41666666668DE72341333333F3942C5A41000000007FE72341000000E08F2C5A410000000071E723419A9999598B2C5A419A99999966E72341333333B3892C5A41CDCCCCCC57E7234166666606892C5A419A9999996FE7234133333353832C5A413333333387E72341CDCCCC4C7D2C5A413333333391E723419A9999B97A2C5A419A99999986E723419A999999762C5A41CDCCCCCC7AE72341000000E0712C5A419A99999965E7234133333373692C5A416666666663E72341CDCCCC4C682C5A41CDCCCCCC53E72341666666A6612C5A41333333334BE72341333333735D2C5A41666666663FE72341CDCCCCAC572C5A4133333333F5E62341000000805B2C5A4100000000A6E62341333333935F2C5A419A9999992DE62341666666C6652C5A4166666666A3E523419A9999D96C2C5A41CDCCCCCC2BE5234100000000732C5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCC2BE5234100000000732C5A416666666694E5234100000060952C5A41CDCCCCCC4DE623419A999959D32C5A416666666620E72341CDCCCC6CBF2C5A419A999999DEE7234100000020AF2C5A410000000071E723419A9999598B2C5A41CDCCCCCC57E7234166666606892C5A413333333391E723419A9999B97A2C5A419A99999965E7234133333373692C5A41666666663FE72341CDCCCCAC572C5A41CDCCCCCC2BE5234100000000732C5A41CDCCCCCC2BE5234100000000732C5A41	01010000206A080000C079DF0DA0E62341000000409A2C5A41	751052004	H	Sorbonne 4	7510520	75105	75	11	0
01060000206A080000010000000103000000010000001B00000066666666C1E32341CDCCCC0C422C5A4100000000F4E32341CDCCCCAC522C5A41CDCCCCCCF4E32341333333F3522C5A413333333306E423419A9999B9582C5A410000000007E42341333333F3582C5A419A99999977E42341000000A07C2C5A41CDCCCCCC8EE42341666666067B2C5A4133333333CEE42341666666C6772C5A41CDCCCCCC2BE5234100000000732C5A4166666666A3E523419A9999D96C2C5A419A9999992DE62341666666C6652C5A410000000000E6234133333393592C5A4133333333F5E52341333333B3562C5A413333333320E62341666666A6502C5A413333333328E62341000000C04F2C5A41CDCCCCCC69E6234100000040492C5A41CDCCCCCC3EE62341CDCCCCAC382C5A41CDCCCCCC03E6234133333353222C5A413333333384E5234133333313282C5A41333333335EE52341CDCCCCCC2A2C5A413333333337E52341CDCCCC8C2D2C5A410000000028E52341000000A02E2C5A4166666666FCE423419A999999302C5A419A99999973E4234166666646352C5A419A9999995DE42341CDCCCC2C362C5A419A9999992FE42341CDCCCCAC392C5A4166666666C1E32341CDCCCC0C422C5A41	01060000206A080000010000000103000000010000000D00000066666666C1E32341CDCCCC0C422C5A419A99999977E42341000000A07C2C5A41CDCCCCCC8EE42341666666067B2C5A419A9999992DE62341666666C6652C5A4133333333F5E52341333333B3562C5A413333333320E62341666666A6502C5A41CDCCCCCC69E6234100000040492C5A41CDCCCCCC03E6234133333353222C5A413333333384E5234133333313282C5A410000000028E52341000000A02E2C5A419A9999995DE42341CDCCCC2C362C5A4166666666C1E32341CDCCCC0C422C5A4166666666C1E32341CDCCCC0C422C5A41	01010000206A08000080D8541A15E52341000000804C2C5A41	751052005	A	Sorbonne 5	7510520	75105	75	11	0
01060000206A080000010000000103000000010000001D000000CDCCCCCCDAE423419A9999F9E62C5A4133333333DFE423419A9999B9E72C5A4133333333EAE42341000000C0E92C5A41333333330FE5234166666626F02C5A41333333337DE5234166666646E82C5A41CDCCCCCCF3E52341333333F3E02C5A413333333318E623419A9999B9DE2C5A413333333339E62341CDCCCCACDC2C5A413333333361E6234100000080D92C5A41666666668FE62341666666C6D52C5A41CDCCCCCC3DE72341CDCCCCACC62C5A413333333390E7234166666686BF2C5A413333333315E8234166666666B72C5A419A99999905E82341CDCCCC6CB62C5A416666666601E8234133333393B52C5A419A999999DEE7234100000020AF2C5A41CDCCCCCCA9E7234133333353B32C5A416666666620E72341CDCCCC6CBF2C5A4100000000C9E62341333333B3C72C5A413333333392E62341000000E0CC2C5A41CDCCCCCC7DE62341CDCCCCCCCE2C5A41CDCCCCCC4DE623419A999959D32C5A419A9999993EE623419A9999D9D42C5A41CDCCCCCCF8E5234166666666D82C5A4100000000E8E5234166666646D92C5A419A999999CCE52341666666A6DA2C5A4100000000C2E5234133333333DB2C5A419A99999921E523419A999959E32C5A41CDCCCCCCDAE423419A9999F9E62C5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCCDAE423419A9999F9E62C5A41333333330FE5234166666626F02C5A41333333337DE5234166666646E82C5A413333333339E62341CDCCCCACDC2C5A41666666668FE62341666666C6D52C5A413333333390E7234166666686BF2C5A413333333315E8234166666666B72C5A419A999999DEE7234100000020AF2C5A416666666620E72341CDCCCC6CBF2C5A419A9999993EE623419A9999D9D42C5A41CDCCCCCCDAE423419A9999F9E62C5A41CDCCCCCCDAE423419A9999F9E62C5A41	01010000206A080000BA7BE1BD95E6234134333313D12C5A41	751052099	D	Seine et Berges 3	7510520	75105	75	11	0
01060000206A080000010000000103000000010000003B00000066666666A9E02341333333D3EA2C5A41CDCCCCCCBCE02341CDCCCC0CEB2C5A419A999999C8E02341333333F3EA2C5A4100000000E4E023419A999959EA2C5A419A9999993DE1234133333393E72C5A41000000007AE12341CDCCCC8CE52C5A419A999999C4E1234100000000E32C5A4133333333E9E1234166666606E22C5A416666666681E22341CDCCCC0CDF2C5A4166666666F2E223419A999939DD2C5A41000000001BE32341000000A0DC2C5A41CDCCCCCC30E323419A999959DC2C5A416666666642E323419A999939DC2C5A41CDCCCCCC4EE32341CDCCCC2CDC2C5A41CDCCCCCCB8E32341CDCCCC0CDB2C5A4133333333F7E3234166666606DA2C5A413333333303E42341333333B3D92C5A410000000027E42341000000C0D82C5A41CDCCCCCC2BE42341CDCCCC6CD82C5A410000000030E42341CDCCCC0CD82C5A41666666663AE42341666666E6D62C5A416666666640E4234100000020D62C5A419A99999944E42341CDCCCC2CD52C5A416666666645E42341CDCCCC4CD42C5A416666666644E423419A9999F9D22C5A41CDCCCCCC40E4234100000080CF2C5A416666666669E4234100000080CD2C5A416666666695E4234166666666CB2C5A41CDCCCCCC54E423419A999999B12C5A419A99999945E4234133333393AB2C5A410000000036E4234133333353A52C5A419A9999992DE42341CDCCCCACA22C5A419A99999921E423419A9999B99E2C5A41666666661AE42341333333139C2C5A4133333333F8E323419A999979902C5A4166666666E2E323419A999979882C5A4100000000CDE323419A9999F98A2C5A4133333333AAE323419A9999998D2C5A419A99999948E3234166666666942C5A410000000021E3234133333373972C5A41000000001CE3234100000040972C5A410000000016E3234100000040972C5A413333333311E3234133333373972C5A416666666600E323419A999939992C5A4133333333C8E22341666666069F2C5A4133333333A9E22341666666E6A22C5A410000000083E22341CDCCCC0CA82C5A419A99999964E2234133333373AD2C5A41666666664EE22341666666A6B12C5A413333333331E223419A999979B62C5A41666666662BE223419A999959B72C5A419A9999991BE2234133333393B82C5A41CDCCCCCC08E2234133333393BB2C5A41CDCCCCCC04E2234133333313C02C5A4100000000F6E12341CDCCCCACC02C5A41CDCCCCCCB2E12341333333F3C32C5A41CDCCCCCC1AE12341000000E0CA2C5A4166666666ABE0234100000020D02C5A4166666666A9E02341333333D3EA2C5A41	01060000206A080000010000000103000000010000001700000066666666A9E02341333333D3EA2C5A4100000000E4E023419A999959EA2C5A419A999999C4E1234100000000E32C5A416666666681E22341CDCCCC0CDF2C5A41CDCCCCCC30E323419A999959DC2C5A41CDCCCCCCB8E32341CDCCCC0CDB2C5A410000000027E42341000000C0D82C5A416666666640E4234100000020D62C5A41CDCCCCCC40E4234100000080CF2C5A416666666695E4234166666666CB2C5A410000000036E4234133333353A52C5A4166666666E2E323419A999979882C5A4100000000CDE323419A9999F98A2C5A410000000021E3234133333373972C5A413333333311E3234133333373972C5A4133333333C8E22341666666069F2C5A410000000083E22341CDCCCC0CA82C5A41666666662BE223419A999959B72C5A41CDCCCCCC08E2234133333393BB2C5A41CDCCCCCC04E2234133333313C02C5A4166666666ABE0234100000020D02C5A4166666666A9E02341333333D3EA2C5A4166666666A9E02341333333D3EA2C5A41	01010000206A0800000464341C3EE3234133333313BA2C5A41	751062101	H	Monnaie 1	7510621	75106	75	11	0
01060000206A080000010000000103000000010000002F0000000000000033E0234133333313532D5A416666666649E02341000000A05A2D5A419A9999995AE023419A9999995A2D5A413333333364E02341000000405A2D5A41666666666AE02341333333F3592D5A41CDCCCCCC8AE0234100000080582D5A41CDCCCCCC9CE02341CDCCCCAC572D5A4166666666CFE0234166666666552D5A419A99999900E12341333333F3522D5A419A99999925E1234166666646512D5A410000000049E12341000000404F2D5A413333333355E12341333333734E2D5A41666666665FE12341CDCCCCCC4D2D5A4100000000A0E12341333333D3462D5A419A999999ABE1234133333393452D5A41666666660BE22341000000203B2D5A419A9999995EE22341CDCCCC0C322D5A41CDCCCCCC88E22341CDCCCC0C2D2D5A419A99999991E223419A9999D92B2D5A4100000000A5E2234100000020292D5A4133333333B0E223419A999999272D5A41CDCCCCCC56E2234133333373142D5A419A9999992AE223419A9999F90A2D5A416666666603E2234166666626022D5A419A99999900E22341CDCCCC8C012D5A4133333333CCE12341000000C0F52C5A413333333388E123419A9999B9E62C5A41000000007AE12341CDCCCC8CE52C5A419A9999993DE1234133333393E72C5A4100000000E4E023419A999959EA2C5A419A999999C8E02341333333F3EA2C5A41CDCCCCCCBCE02341CDCCCC0CEB2C5A4166666666A9E02341333333D3EA2C5A41666666669EE0234100000000FD2C5A413333333395E02341666666A60D2D5A413333333392E0234166666646122D5A41CDCCCCCC8AE023419A9999791D2D5A41000000007FE02341333333932E2D5A41CDCCCCCC74E02341666666263D2D5A413333333373E02341000000403F2D5A419A9999996EE0234166666606462D5A419A99999965E02341666666064C2D5A416666666661E02341CDCCCCAC4D2D5A41666666665BE02341CDCCCCCC4E2D5A419A99999941E02341CDCCCC0C522D5A410000000038E023419A9999D9522D5A410000000033E0234133333313532D5A41	01060000206A08000001000000010300000001000000110000000000000033E0234133333313532D5A416666666649E02341000000A05A2D5A419A9999995AE023419A9999995A2D5A419A99999925E1234166666646512D5A41666666665FE12341CDCCCCCC4D2D5A419A9999995EE22341CDCCCC0C322D5A4133333333B0E223419A999999272D5A419A9999992AE223419A9999F90A2D5A413333333388E123419A9999B9E62C5A41000000007AE12341CDCCCC8CE52C5A4100000000E4E023419A999959EA2C5A4166666666A9E02341333333D3EA2C5A413333333395E02341666666A60D2D5A419A9999996EE0234166666606462D5A41666666665BE02341CDCCCCCC4E2D5A410000000033E0234133333313532D5A410000000033E0234133333313532D5A41	01010000206A080000B6D3B6EF8FE123419A999989222D5A41	751062102	H	Monnaie 2	7510621	75106	75	11	0
01060000206A080000010000000103000000010000002E000000000000007AE12341CDCCCC8CE52C5A413333333388E123419A9999B9E62C5A4133333333CCE12341000000C0F52C5A419A99999900E22341CDCCCC8C012D5A416666666603E2234166666626022D5A419A9999992AE223419A9999F90A2D5A41CDCCCCCC56E2234133333373142D5A4133333333B0E223419A999999272D5A419A99999916E3234166666626192D5A41666666664EE3234100000040112D5A419A99999960E323419A9999B90E2D5A41CDCCCCCC79E32341666666460B2D5A41000000009BE32341666666A6062D5A4166666666A6E32341CDCCCCEC042D5A4133333333B8E323419A999999022D5A419A999999DAE32341000000E0FE2C5A41CDCCCCCC37E423419A9999F9F52C5A41CDCCCCCC9EE4234166666686EC2C5A4133333333B6E4234133333353EA2C5A41CDCCCCCCDAE423419A9999F9E62C5A4166666666C4E4234133333313DE2C5A4133333333ADE423419A9999D9D42C5A410000000096E42341000000A0CB2C5A416666666695E4234166666666CB2C5A416666666669E4234100000080CD2C5A41CDCCCCCC40E4234100000080CF2C5A416666666644E423419A9999F9D22C5A416666666645E42341CDCCCC4CD42C5A419A99999944E42341CDCCCC2CD52C5A416666666640E4234100000020D62C5A41666666663AE42341666666E6D62C5A410000000030E42341CDCCCC0CD82C5A41CDCCCCCC2BE42341CDCCCC6CD82C5A410000000027E42341000000C0D82C5A413333333303E42341333333B3D92C5A4133333333F7E3234166666606DA2C5A41CDCCCCCCB8E32341CDCCCC0CDB2C5A41CDCCCCCC4EE32341CDCCCC2CDC2C5A416666666642E323419A999939DC2C5A41CDCCCCCC30E323419A999959DC2C5A41000000001BE32341000000A0DC2C5A4166666666F2E223419A999939DD2C5A416666666681E22341CDCCCC0CDF2C5A4133333333E9E1234166666606E22C5A419A999999C4E1234100000000E32C5A41000000007AE12341CDCCCC8CE52C5A41	01060000206A0800000100000001030000000100000011000000000000007AE12341CDCCCC8CE52C5A413333333388E123419A9999B9E62C5A419A9999992AE223419A9999F90A2D5A4133333333B0E223419A999999272D5A4133333333B8E323419A999999022D5A41CDCCCCCC37E423419A9999F9F52C5A41CDCCCCCCDAE423419A9999F9E62C5A416666666695E4234166666666CB2C5A41CDCCCCCC40E4234100000080CF2C5A416666666640E4234100000020D62C5A410000000027E42341000000C0D82C5A41CDCCCCCCB8E32341CDCCCC0CDB2C5A41CDCCCCCC30E323419A999959DC2C5A416666666681E22341CDCCCC0CDF2C5A4133333333E9E1234166666606E22C5A41000000007AE12341CDCCCC8CE52C5A41000000007AE12341CDCCCC8CE52C5A41	01010000206A080000146F8014F5E22341CDCCCC6CFA2C5A41	751062103	H	Monnaie 3	7510621	75106	75	11	0
01060000206A08000001000000010300000001000000300000009A9999995DE02341666666866F2D5A413333333302E12341CDCCCCAC672D5A416666666619E1234133333393662D5A4100000000BEE123419A999959542D5A4133333333BFE22341CDCCCCAC382D5A419A999999DDE22341333333B3342D5A4133333333E3E22341333333F3332D5A4133333333E9E2234166666626332D5A419A99999933E323419A999959292D5A41333333336CE32341CDCCCC4C1E2D5A41CDCCCCCCD8E32341333333B30C2D5A416666666616E423419A999919052D5A419A999999C2E42341000000A0F52C5A41333333330FE5234166666626F02C5A4133333333EAE42341000000C0E92C5A4133333333DFE423419A9999B9E72C5A41CDCCCCCCDAE423419A9999F9E62C5A4133333333B6E4234133333353EA2C5A41CDCCCCCC9EE4234166666686EC2C5A41CDCCCCCC37E423419A9999F9F52C5A419A999999DAE32341000000E0FE2C5A4133333333B8E323419A999999022D5A4166666666A6E32341CDCCCCEC042D5A41000000009BE32341666666A6062D5A41CDCCCCCC79E32341666666460B2D5A419A99999960E323419A9999B90E2D5A41666666664EE3234100000040112D5A419A99999916E3234166666626192D5A4133333333B0E223419A999999272D5A4100000000A5E2234100000020292D5A419A99999991E223419A9999D92B2D5A41CDCCCCCC88E22341CDCCCC0C2D2D5A419A9999995EE22341CDCCCC0C322D5A41666666660BE22341000000203B2D5A419A999999ABE1234133333393452D5A4100000000A0E12341333333D3462D5A41666666665FE12341CDCCCCCC4D2D5A413333333355E12341333333734E2D5A410000000049E12341000000404F2D5A419A99999925E1234166666646512D5A419A99999900E12341333333F3522D5A4166666666CFE0234166666666552D5A41CDCCCCCC9CE02341CDCCCCAC572D5A41CDCCCCCC8AE0234100000080582D5A41666666666AE02341333333F3592D5A410000000068E02341CDCCCC4C5D2D5A41666666665EE02341333333336B2D5A419A9999995DE02341666666866F2D5A41	01060000206A08000001000000010300000001000000140000009A9999995DE02341666666866F2D5A416666666619E1234133333393662D5A4100000000BEE123419A999959542D5A4133333333BFE22341CDCCCCAC382D5A419A99999933E323419A999959292D5A41333333336CE32341CDCCCC4C1E2D5A41CDCCCCCCD8E32341333333B30C2D5A416666666616E423419A999919052D5A419A999999C2E42341000000A0F52C5A41333333330FE5234166666626F02C5A41CDCCCCCCDAE423419A9999F9E62C5A41CDCCCCCC37E423419A9999F9F52C5A4133333333B8E323419A999999022D5A41CDCCCCCC88E22341CDCCCC0C2D2D5A419A9999995EE22341CDCCCC0C322D5A41666666665FE12341CDCCCCCC4D2D5A419A99999925E1234166666646512D5A41666666666AE02341333333F3592D5A419A9999995DE02341666666866F2D5A419A9999995DE02341666666866F2D5A41	01010000206A080000DE1AFD4DE2E223419A9999992A2D5A41	751062199	D	Seine et Berges 1	7510621	75106	75	11	0
01060000206A08000002000000010300000001000000210000006666666657DF2341CDCCCC6CE22B5A4166666666CDDF234100000000E22B5A413333333325E02341333333B3E12B5A419A99999952E0234166666646E12B5A419A9999997BE02341CDCCCCECE02B5A41CDCCCCCCC5E0234100000040E02B5A4133333333F2E023419A9999D9DF2B5A416666666603E12341CDCCCC2CDF2B5A41CDCCCCCCBAE12341CDCCCCACD62B5A4100000000BFE123419A999979D62B5A419A9999998FE12341CDCCCCECC62B5A416666666649E1234100000020AF2B5A41CDCCCCCC06E123419A9999599A2B5A4166666666DBE02341666666468C2B5A41CDCCCCCCBBE023419A9999F9812B5A41CDCCCCCC8CE02341000000E07F2B5A413333333382E02341333333B37F2B5A416666666681E02341333333B37F2B5A416666666675E02341000000C07F2B5A41333333336AE0234166666606802B5A419A9999995FE0234100000080802B5A419A99999954E0234166666646812B5A41333333334CE023419A999939822B5A41CDCCCCCC44E02341CDCCCC6C832B5A41666666663EE02341333333B3842B5A419A9999992DE0234166666606892B5A413333333314E02341CDCCCCEC862B5A41CDCCCCCC91DF2341CDCCCCECA02B5A41333333335EDF234100000000AB2B5A41666666663BDF23419A9999D9B12B5A410000000055DE2341333333D3DF2B5A413333333343DE2341CDCCCC6CE32B5A416666666657DF2341CDCCCC6CE22B5A41010300000001000000140000009A99999978DD23419A9999B9102C5A41000000007CDD2341333333F3112C5A413333333385DD2341000000A02E2C5A413333333395DD23419A999959542C5A416666666618DE23419A9999F95A2C5A41333333332CDE23419A9999F95B2C5A419A99999927DE234166666606512C5A410000000026DE2341666666E64C2C5A410000000025DE2341000000404A2C5A41666666661ADE234133333313302C5A416666666619DE2341333333B32D2C5A416666666618DE23419A9999592B2C5A413333333309DE234133333393052C5A413333333302DE234133333373F42B5A416666666604DE2341CDCCCC2CF22B5A4100000000FCDD234133333373F12B5A4166666666EEDD23419A999919F42B5A4166666666E6DD2341CDCCCCACF52B5A410000000069DD2341CDCCCCEC0E2C5A419A99999978DD23419A9999B9102C5A41	01060000206A080000020000000103000000010000000D0000006666666657DF2341CDCCCC6CE22B5A413333333325E02341333333B3E12B5A4133333333F2E023419A9999D9DF2B5A4100000000BFE123419A999979D62B5A416666666649E1234100000020AF2B5A41CDCCCCCCBBE023419A9999F9812B5A41CDCCCCCC8CE02341000000E07F2B5A41333333334CE023419A999939822B5A419A9999992DE0234166666606892B5A413333333314E02341CDCCCCEC862B5A413333333343DE2341CDCCCC6CE32B5A416666666657DF2341CDCCCC6CE22B5A416666666657DF2341CDCCCC6CE22B5A41010300000001000000080000009A99999978DD23419A9999B9102C5A413333333395DD23419A999959542C5A41333333332CDE23419A9999F95B2C5A413333333302DE234133333373F42B5A4100000000FCDD234133333373F12B5A410000000069DD2341CDCCCCEC0E2C5A419A99999978DD23419A9999B9102C5A419A99999978DD23419A9999B9102C5A41	01010000206A080000BA44CFDE47E02341CDCCCC7CB02B5A41	751062201	H	Odéon 1	7510622	75106	75	11	0
01060000206A08000001000000010300000001000000250000003333333395DD23419A999959542C5A419A999999A0DD2341666666466E2C5A419A999999ADDD23419A9999B9872C5A4100000000B9DD2341666666E6942C5A4166666666BBDD234133333313972C5A4133333333D3DD2341CDCCCC6CA62C5A41333333334FDE234166666666A42C5A41CDCCCCCC51DE234100000000A22C5A416666666651DE2341CDCCCC6CA12C5A41CDCCCCCCC3DE234100000000A32C5A4166666666D0DE2341000000A0A22C5A4133333333E4DE234100000060A22C5A41000000001ADF2341CDCCCC4CA32C5A413333333370DF2341333333D3A42C5A4166666666A1DF234100000000A52C5A4100000000B2DF234100000060A42C5A41CDCCCCCCE5DF234133333373A42C5A410000000050E0234100000080A62C5A4166666666B2E02341CDCCCC8CA82C5A4100000000D6E023419A9999196C2C5A41000000004CE02341CDCCCCCC6B2C5A419A9999990CE02341666666A66B2C5A4100000000E4DF23419A9999796B2C5A419A999999C1DF2341333333D36A2C5A4133333333A3DF23419A9999D9692C5A41CDCCCCCC8EDF2341000000E0682C5A413333333382DF234166666646682C5A416666666669DF2341CDCCCC6C672C5A41CDCCCCCC1ADF2341000000C0642C5A41CDCCCCCCFEDE2341666666C6632C5A41CDCCCCCCC0DE2341666666A6612C5A410000000077DE2341333333135F2C5A413333333353DE2341666666A65D2C5A41CDCCCCCC36DE2341CDCCCC8C5C2C5A41333333332CDE23419A9999F95B2C5A416666666618DE23419A9999F95A2C5A413333333395DD23419A999959542C5A41	01060000206A08000001000000010300000001000000110000003333333395DD23419A999959542C5A419A999999ADDD23419A9999B9872C5A4166666666BBDD234133333313972C5A4133333333D3DD2341CDCCCC6CA62C5A41333333334FDE234166666666A42C5A416666666651DE2341CDCCCC6CA12C5A41CDCCCCCCC3DE234100000000A32C5A4133333333E4DE234100000060A22C5A413333333370DF2341333333D3A42C5A41CDCCCCCCE5DF234133333373A42C5A4166666666B2E02341CDCCCC8CA82C5A4100000000D6E023419A9999196C2C5A4100000000E4DF23419A9999796B2C5A410000000077DE2341333333135F2C5A41CDCCCCCC36DE2341CDCCCC8C5C2C5A413333333395DD23419A999959542C5A413333333395DD23419A999959542C5A41	01010000206A080000D5579E293ADF2341000000007B2C5A41	751062202	H	Odéon 2	7510622	75106	75	11	0
01060000206A080000010000000103000000010000002E000000CDCCCCCCAFDD2341666666A6C02C5A4100000000BDDD234100000040C32C5A419A999999FADD234133333393C62C5A419A99999975DE2341666666C6C92C5A41CDCCCCCCBCDE2341CDCCCCACC92C5A419A999999C2DE2341333333D3C92C5A4100000000D1DE2341CDCCCC2CCA2C5A4100000000EEDE234133333333CB2C5A416666666635DF234100000080CD2C5A41CDCCCCCC8FDF234166666666D02C5A4100000000B6DF234166666606D22C5A419A999999E5DF234100000080D42C5A4133333333EEDF23419A999939D52C5A4100000000F5DF2341CDCCCCECD52C5A416666666603E0234133333313D82C5A41CDCCCCCC53E0234166666666D42C5A4166666666ABE0234100000020D02C5A41CDCCCCCC1AE12341000000E0CA2C5A41CDCCCCCCB2E12341333333F3C32C5A4100000000A8E1234133333373BE2C5A4166666666A4E12341CDCCCC2CBA2C5A4100000000A3E12341666666E6B62C5A41CDCCCCCCA1E12341333333D3B32C5A4166666666A1E12341333333F3B12C5A416666666683E1234100000020B22C5A419A99999978E12341CDCCCC6CAF2C5A410000000063E1234166666646AA2C5A4166666666B2E02341CDCCCC8CA82C5A410000000050E0234100000080A62C5A41CDCCCCCCE5DF234133333373A42C5A4100000000B2DF234100000060A42C5A4166666666A1DF234100000000A52C5A413333333370DF2341333333D3A42C5A41000000001ADF2341CDCCCC4CA32C5A4133333333E4DE234100000060A22C5A4166666666D0DE2341000000A0A22C5A41CDCCCCCCC3DE234100000000A32C5A416666666651DE2341CDCCCC6CA12C5A41CDCCCCCC51DE234100000000A22C5A41333333334FDE234166666666A42C5A4133333333D3DD2341CDCCCC6CA62C5A4133333333C0DD2341333333D3A62C5A4166666666CADD234100000000BD2C5A4100000000C9DD2341CDCCCC4CBE2C5A41CDCCCCCCC6DD23419A999939BF2C5A41CDCCCCCCAFDD2341666666A6C02C5A41	01060000206A0800000100000001030000000100000017000000CDCCCCCCAFDD2341666666A6C02C5A4100000000BDDD234100000040C32C5A419A999999FADD234133333393C62C5A419A99999975DE2341666666C6C92C5A41CDCCCCCCBCDE2341CDCCCCACC92C5A41CDCCCCCC8FDF234166666666D02C5A419A999999E5DF234100000080D42C5A416666666603E0234133333313D82C5A41CDCCCCCCB2E12341333333F3C32C5A4166666666A1E12341333333F3B12C5A416666666683E1234100000020B22C5A410000000063E1234166666646AA2C5A4166666666B2E02341CDCCCC8CA82C5A41CDCCCCCCE5DF234133333373A42C5A413333333370DF2341333333D3A42C5A4133333333E4DE234100000060A22C5A41CDCCCCCCC3DE234100000000A32C5A416666666651DE2341CDCCCC6CA12C5A41333333334FDE234166666666A42C5A4133333333C0DD2341333333D3A62C5A4166666666CADD234100000000BD2C5A41CDCCCCCCAFDD2341666666A6C02C5A41CDCCCCCCAFDD2341666666A6C02C5A41	01010000206A080000FB1B7DABB7DF234166666696BB2C5A41	751062203	H	Odéon 3	7510622	75106	75	11	0
01060000206A080000010000000103000000010000003800000066666666B2E02341CDCCCC8CA82C5A410000000063E1234166666646AA2C5A419A99999978E12341CDCCCC6CAF2C5A416666666683E1234100000020B22C5A4166666666A1E12341333333F3B12C5A41CDCCCCCCA1E12341333333D3B32C5A4100000000A3E12341666666E6B62C5A4166666666A4E12341CDCCCC2CBA2C5A4100000000A8E1234133333373BE2C5A41CDCCCCCCB2E12341333333F3C32C5A4100000000F6E12341CDCCCCACC02C5A41CDCCCCCC04E2234133333313C02C5A41CDCCCCCC08E2234133333393BB2C5A419A9999991BE2234133333393B82C5A41666666662BE223419A999959B72C5A413333333331E223419A999979B62C5A41666666664EE22341666666A6B12C5A419A99999964E2234133333373AD2C5A410000000083E22341CDCCCC0CA82C5A4133333333A9E22341666666E6A22C5A4133333333C8E22341666666069F2C5A416666666600E323419A999939992C5A413333333311E3234133333373972C5A410000000016E3234100000040972C5A41000000001CE3234100000040972C5A410000000021E3234133333373972C5A419A99999948E3234166666666942C5A4133333333AAE323419A9999998D2C5A4100000000CDE323419A9999F98A2C5A4166666666E2E323419A999979882C5A41CDCCCCCC63E32341000000E0602C5A41666666665BE323419A9999395E2C5A410000000051E32341666666065B2C5A413333333333E32341CDCCCCEC512C5A419A9999991AE323419A9999194A2C5A413333333305E3234166666666432C5A4133333333F5E22341CDCCCC6C3E2C5A4133333333F0E22341CDCCCCEC3C2C5A4133333333D7E22341CDCCCC0C352C5A4100000000B7E22341CDCCCCEC2A2C5A419A999999A4E22341666666C62C2C5A41333333339CE2234100000040332C5A413333333396E2234100000040342C5A410000000093E2234166666626352C5A419A9999996BE22341333333733E2C5A41CDCCCCCC57E223419A9999D9422C5A41000000000CE22341CDCCCC8C532C5A4100000000E8E12341000000C05B2C5A4100000000DCE12341333333135E2C5A419A999999B5E12341333333D3622C5A4166666666A1E12341CDCCCC4C652C5A41333333338AE1234166666666672C5A419A99999974E123419A9999D9682C5A41CDCCCCCC18E123419A9999996B2C5A4100000000D6E023419A9999196C2C5A4166666666B2E02341CDCCCC8CA82C5A41	01060000206A080000010000000103000000010000001800000066666666B2E02341CDCCCC8CA82C5A410000000063E1234166666646AA2C5A416666666683E1234100000020B22C5A4166666666A1E12341333333F3B12C5A41CDCCCCCCB2E12341333333F3C32C5A41CDCCCCCC04E2234133333313C02C5A41CDCCCCCC08E2234133333393BB2C5A41666666662BE223419A999959B72C5A410000000083E22341CDCCCC0CA82C5A4133333333C8E22341666666069F2C5A413333333311E3234133333373972C5A410000000021E3234133333373972C5A4100000000CDE323419A9999F98A2C5A4166666666E2E323419A999979882C5A4100000000B7E22341CDCCCCEC2A2C5A419A999999A4E22341666666C62C2C5A41333333339CE2234100000040332C5A4100000000DCE12341333333135E2C5A4166666666A1E12341CDCCCC4C652C5A419A99999974E123419A9999D9682C5A41CDCCCCCC18E123419A9999996B2C5A4100000000D6E023419A9999196C2C5A4166666666B2E02341CDCCCC8CA82C5A4166666666B2E02341CDCCCC8CA82C5A41	01010000206A08000086DE075841E223419A9999497A2C5A41	751062204	H	Odéon 4	7510622	75106	75	11	0
01060000206A080000010000000103000000010000003800000000000000FCDD234133333373F12B5A416666666604DE2341CDCCCC2CF22B5A413333333302DE234133333373F42B5A413333333309DE234133333393052C5A416666666618DE23419A9999592B2C5A416666666619DE2341333333B32D2C5A41666666661ADE234133333313302C5A410000000025DE2341000000404A2C5A410000000026DE2341666666E64C2C5A419A99999927DE234166666606512C5A41333333332CDE23419A9999F95B2C5A41CDCCCCCC36DE2341CDCCCC8C5C2C5A413333333353DE2341666666A65D2C5A410000000077DE2341333333135F2C5A41CDCCCCCCC0DE2341666666A6612C5A41CDCCCCCCFEDE2341666666C6632C5A41CDCCCCCC1ADF2341000000C0642C5A416666666669DF2341CDCCCC6C672C5A413333333382DF234166666646682C5A41CDCCCCCC8EDF2341000000E0682C5A4133333333A3DF23419A9999D9692C5A419A999999C1DF2341333333D36A2C5A4100000000E4DF23419A9999796B2C5A419A9999990CE02341666666A66B2C5A41000000004CE02341CDCCCCCC6B2C5A4100000000D6E023419A9999196C2C5A41CDCCCCCC18E123419A9999996B2C5A419A99999974E123419A9999D9682C5A41333333338AE1234166666666672C5A4166666666A1E12341CDCCCC4C652C5A419A999999B5E12341333333D3622C5A4100000000DCE12341333333135E2C5A4100000000E8E12341000000C05B2C5A41000000000CE22341CDCCCC8C532C5A41CDCCCCCC57E223419A9999D9422C5A419A9999996BE22341333333733E2C5A410000000093E2234166666626352C5A413333333396E2234100000040342C5A41333333339CE2234100000040332C5A419A999999A4E22341666666C62C2C5A4100000000B7E22341CDCCCCEC2A2C5A4133333333A0E22341CDCCCCAC232C5A419A9999997DE2234100000000182C5A4100000000BFE123419A999979D62B5A41CDCCCCCCBAE12341CDCCCCACD62B5A416666666603E12341CDCCCC2CDF2B5A4133333333F2E023419A9999D9DF2B5A41CDCCCCCCC5E0234100000040E02B5A419A9999997BE02341CDCCCCECE02B5A419A99999952E0234166666646E12B5A413333333325E02341333333B3E12B5A4166666666CDDF234100000000E22B5A416666666657DF2341CDCCCC6CE22B5A413333333343DE2341CDCCCC6CE32B5A416666666637DE2341000000C0E52B5A4100000000FCDD234133333373F12B5A41	01060000206A080000010000000103000000010000001400000000000000FCDD234133333373F12B5A413333333302DE234133333373F42B5A41333333332CDE23419A9999F95B2C5A410000000077DE2341333333135F2C5A4100000000E4DF23419A9999796B2C5A4100000000D6E023419A9999196C2C5A41CDCCCCCC18E123419A9999996B2C5A419A99999974E123419A9999D9682C5A4166666666A1E12341CDCCCC4C652C5A4100000000DCE12341333333135E2C5A41333333339CE2234100000040332C5A419A999999A4E22341666666C62C2C5A4100000000B7E22341CDCCCCEC2A2C5A419A9999997DE2234100000000182C5A4100000000BFE123419A999979D62B5A4133333333F2E023419A9999D9DF2B5A413333333325E02341333333B3E12B5A413333333343DE2341CDCCCC6CE32B5A4100000000FCDD234133333373F12B5A4100000000FCDD234133333373F12B5A41	01010000206A0800000E6E70EE50E02341666666D61D2C5A41	751062205	D	Jardin du Luxembourg	7510622	75106	75	11	0
01060000206A080000010000000103000000010000002A000000000000007CDC2341333333D39F2B5A41666666667EDC234166666666A02B5A41CDCCCCCC83DC234133333353A12B5A413333333398DC23419A9999B9A22B5A413333333398DD2341666666A6B52B5A419A999999C9DD2341000000A0A32B5A419A999999D6DD23419A999919A02B5A4133333333DDDD2341333333939E2B5A4100000000E3DD2341333333939D2B5A41000000000FDE234133333373972B5A410000000052DE2341000000C08E2B5A4166666666EBDE234100000060A02B5A41333333335EDF234100000000AB2B5A41CDCCCCCC91DF2341CDCCCCECA02B5A413333333314E02341CDCCCCEC862B5A419A9999992DE0234166666606892B5A41666666663EE02341333333B3842B5A41CDCCCCCC44E02341CDCCCC6C832B5A41333333334CE023419A999939822B5A419A99999954E0234166666646812B5A419A9999995FE0234100000080802B5A41333333336AE0234166666606802B5A416666666675E02341000000C07F2B5A416666666681E02341333333B37F2B5A413333333382E02341333333B37F2B5A41CDCCCCCC8CE02341000000E07F2B5A41CDCCCCCCBBE023419A9999F9812B5A4166666666ACE0234133333373802B5A419A999999A1E02341333333737F2B5A419A99999993E02341CDCCCCCC7E2B5A419A99999986E02341CDCCCC6C7E2B5A416666666674E02341333333737E2B5A419A99999970E0234100000080762B5A416666666670E023419A999939762B5A419A9999996BE02341333333B36C2B5A419A99999961E023419A999999602B5A4100000000C2DF2341CDCCCC4C6A2B5A41333333335BDF2341000000E0702B5A41CDCCCCCC0ADF23419A999919762B5A419A999999A5DE23419A9999797C2B5A419A99999956DD2341333333B3912B5A41000000007CDC2341333333D39F2B5A41	01060000206A0800000100000001030000000100000012000000000000007CDC2341333333D39F2B5A413333333398DC23419A9999B9A22B5A413333333398DD2341666666A6B52B5A419A999999C9DD2341000000A0A32B5A4100000000E3DD2341333333939D2B5A410000000052DE2341000000C08E2B5A4166666666EBDE234100000060A02B5A41333333335EDF234100000000AB2B5A413333333314E02341CDCCCCEC862B5A419A9999992DE0234166666606892B5A419A9999995FE0234100000080802B5A419A999999A1E02341333333737F2B5A416666666674E02341333333737E2B5A419A99999961E023419A999999602B5A4100000000C2DF2341CDCCCC4C6A2B5A419A99999956DD2341333333B3912B5A41000000007CDC2341333333D39F2B5A41000000007CDC2341333333D39F2B5A41	01010000206A080000B64562D3D6DE2341333333E38B2B5A41	751062301	H	Notre-Dame des Champs 1	7510623	75106	75	11	0
01060000206A080000010000000103000000010000001600000066666666F1DC23419A999939D92B5A416666666600DD23419A999959DA2B5A4100000000FCDD234133333373F12B5A416666666637DE2341000000C0E52B5A413333333343DE2341CDCCCC6CE32B5A410000000055DE2341333333D3DF2B5A41666666663BDF23419A9999D9B12B5A41333333335EDF234100000000AB2B5A4166666666EBDE234100000060A02B5A410000000052DE2341000000C08E2B5A41000000000FDE234133333373972B5A4100000000E3DD2341333333939D2B5A4133333333DDDD2341333333939E2B5A419A999999D6DD23419A999919A02B5A419A999999C9DD2341000000A0A32B5A413333333398DD2341666666A6B52B5A413333333381DD234166666646BE2B5A410000000077DD234133333393C12B5A41333333335DDD2341000000E0C62B5A41333333334EDD23419A999959CA2B5A41CDCCCCCC24DD2341CDCCCCACD12B5A4166666666F1DC23419A999939D92B5A41	01060000206A080000010000000103000000010000000B00000066666666F1DC23419A999939D92B5A4100000000FCDD234133333373F12B5A41333333335EDF234100000000AB2B5A4166666666EBDE234100000060A02B5A410000000052DE2341000000C08E2B5A4100000000E3DD2341333333939D2B5A419A999999C9DD2341000000A0A32B5A410000000077DD234133333393C12B5A41333333334EDD23419A999959CA2B5A4166666666F1DC23419A999939D92B5A4166666666F1DC23419A999939D92B5A41	01010000206A08000020556D7B38DE2341CCCCCCECBF2B5A41	751062302	H	Notre-Dame des Champs 2	7510623	75106	75	11	0
01060000206A080000010000000103000000010000002000000066666666B8DB2341666666A6042C5A419A999999D4DB234166666666062C5A4133333333E3DB234133333353072C5A41CDCCCCCC9BDC2341666666C6182C5A419A99999933DD2341CDCCCC6C192C5A410000000069DD2341CDCCCCEC0E2C5A4166666666E6DD2341CDCCCCACF52B5A4166666666EEDD23419A999919F42B5A4100000000FCDD234133333373F12B5A416666666600DD23419A999959DA2B5A4166666666F1DC23419A999939D92B5A41CDCCCCCC24DD2341CDCCCCACD12B5A41333333334EDD23419A999959CA2B5A41333333335DDD2341000000E0C62B5A410000000077DD234133333393C12B5A413333333381DD234166666646BE2B5A413333333398DD2341666666A6B52B5A413333333398DC23419A9999B9A22B5A41CDCCCCCC83DC234133333353A12B5A41666666667EDC234166666666A02B5A41000000007CDC2341333333D39F2B5A41333333336FDC2341666666A6A02B5A416666666656DC234166666646A22B5A41CDCCCCCC51DC2341000000A0A42B5A413333333340DC234100000060A92B5A413333333338DC23419A999939AE2B5A41CDCCCCCC25DC2341CDCCCC2CBA2B5A41000000001FDC23419A999919BE2B5A41CDCCCCCCFEDB234166666626D42B5A41CDCCCCCCEADB2341CDCCCCECE12B5A4166666666C4DB2341CDCCCC0CFC2B5A4166666666B8DB2341666666A6042C5A41	01060000206A080000010000000103000000010000001000000066666666B8DB2341666666A6042C5A4133333333E3DB234133333353072C5A41CDCCCCCC9BDC2341666666C6182C5A419A99999933DD2341CDCCCC6C192C5A4100000000FCDD234133333373F12B5A4166666666F1DC23419A999939D92B5A41333333334EDD23419A999959CA2B5A410000000077DD234133333393C12B5A413333333398DD2341666666A6B52B5A413333333398DC23419A9999B9A22B5A41000000007CDC2341333333D39F2B5A416666666656DC234166666646A22B5A413333333340DC234100000060A92B5A41000000001FDC23419A999919BE2B5A4166666666B8DB2341666666A6042C5A4166666666B8DB2341666666A6042C5A41	01010000206A08000008FAD0F98CDC234134333323DE2B5A41	751062303	H	Notre-Dame des Champs 3	7510623	75106	75	11	0
01060000206A080000010000000103000000010000000E000000CDCCCCCC8BDB2341CDCCCCAC382C5A413333333360DC23419A999959442C5A419A99999936DD2341CDCCCC4C4F2C5A413333333395DD23419A999959542C5A413333333385DD2341000000A02E2C5A41000000007CDD2341333333F3112C5A419A99999978DD23419A9999B9102C5A410000000069DD2341CDCCCCEC0E2C5A419A99999933DD2341CDCCCC6C192C5A41CDCCCCCC9BDC2341666666C6182C5A4133333333E3DB234133333353072C5A419A999999D4DB234166666666062C5A4133333333A6DB2341CDCCCC4C262C5A41CDCCCCCC8BDB2341CDCCCCAC382C5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCC8BDB2341CDCCCCAC382C5A413333333360DC23419A999959442C5A419A99999936DD2341CDCCCC4C4F2C5A413333333395DD23419A999959542C5A413333333385DD2341000000A02E2C5A41000000007CDD2341333333F3112C5A419A99999978DD23419A9999B9102C5A410000000069DD2341CDCCCCEC0E2C5A419A99999933DD2341CDCCCC6C192C5A41CDCCCCCC9BDC2341666666C6182C5A4133333333E3DB234133333353072C5A419A999999D4DB234166666666062C5A4133333333A6DB2341CDCCCC4C262C5A41CDCCCCCC8BDB2341CDCCCCAC382C5A41	01010000206A080000C20CC40A92DC2341666666762A2C5A41	751062304	H	Notre-Dame des Champs 4	7510623	75106	75	11	0
01060000206A0800000100000001030000000100000026000000CDCCCCCC41D92341666666E6DF2B5A41CDCCCCCC78D9234166666686EA2B5A4166666666D9D92341CDCCCCECFC2B5A410000000018DA2341333333D3082C5A41CDCCCCCCC5DA2341000000402A2C5A4100000000D1DA2341CDCCCC8C2C2C5A419A999999F9DA2341666666A6342C5A41CDCCCCCC58DB234100000060472C5A41CDCCCCCC6EDB2341666666264C2C5A41CDCCCCCC8BDB2341CDCCCCAC382C5A4133333333A6DB2341CDCCCC4C262C5A419A999999D4DB234166666666062C5A4166666666B8DB2341666666A6042C5A4166666666C4DB2341CDCCCC0CFC2B5A41CDCCCCCCEADB2341CDCCCCECE12B5A41CDCCCCCCFEDB234166666626D42B5A41000000001FDC23419A999919BE2B5A41CDCCCCCC25DC2341CDCCCC2CBA2B5A413333333338DC23419A999939AE2B5A413333333340DC234100000060A92B5A41CDCCCCCC51DC2341000000A0A42B5A416666666656DC234166666646A22B5A419A99999900DC2341CDCCCC0CA82B5A419A999999D2DB234166666626AB2B5A413333333377DB2341CDCCCCECB02B5A413333333321DB234133333353B62B5A413333333384DA234166666686C02B5A410000000002DA23419A999999C82B5A41CDCCCCCCDED92341333333D3CA2B5A419A999999C2D92341CDCCCC8CCC2B5A416666666685D9234166666646D02B5A413333333353D9234133333353D32B5A410000000053D923419A999979D52B5A41333333334ED92341CDCCCC2CD82B5A41CDCCCCCC4BD92341CDCCCCACD92B5A41CDCCCCCC46D9234100000020DC2B5A416666666642D9234100000080DE2B5A41CDCCCCCC41D92341666666E6DF2B5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC41D92341666666E6DF2B5A41CDCCCCCCC5DA2341000000402A2C5A41CDCCCCCC6EDB2341666666264C2C5A419A999999D4DB234166666666062C5A4166666666B8DB2341666666A6042C5A41000000001FDC23419A999919BE2B5A413333333340DC234100000060A92B5A416666666656DC234166666646A22B5A419A999999D2DB234166666626AB2B5A413333333384DA234166666686C02B5A413333333353D9234133333353D32B5A41CDCCCCCC41D92341666666E6DF2B5A41CDCCCCCC41D92341666666E6DF2B5A41	01010000206A080000184C970ABCDA23419A999949F32B5A41	751062305	H	Notre-Dame des Champs 5	7510623	75106	75	11	0
01060000206A080000010000000103000000010000001D000000CDCCCCCC61D62341666666E6052C5A4133333333B6D62341CDCCCC6C0F2C5A419A9999994FD72341CDCCCCAC202C5A4133333333B9D72341CDCCCC6C2B2C5A41000000007CD82341000000003E2C5A4100000000E5D82341666666662A2C5A41666666663CD9234100000020192C5A416666666648D923419A9999B9192C5A413333333379D92341CDCCCC8C0B2C5A41CDCCCCCCFFD9234166666666092C5A410000000018DA2341333333D3082C5A4166666666D9D92341CDCCCCECFC2B5A41CDCCCCCC78D9234166666686EA2B5A41CDCCCCCC41D92341666666E6DF2B5A416666666642D9234100000080DE2B5A41CDCCCCCC46D9234100000020DC2B5A41CDCCCCCC4BD92341CDCCCCACD92B5A41333333334ED92341CDCCCC2CD82B5A410000000053D923419A999979D52B5A413333333353D9234133333353D32B5A4100000000FAD8234100000000D92B5A41CDCCCCCCCAD8234100000000DC2B5A419A999999B1D82341CDCCCC8CDD2B5A419A99999987D82341CDCCCC2CE02B5A41CDCCCCCC9AD723419A999979EF2B5A41CDCCCCCC2FD7234133333353F62B5A419A999999F0D6234100000000FA2B5A4166666666CFD62341333333F3FB2B5A41CDCCCCCC61D62341666666E6052C5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC61D62341666666E6052C5A419A9999994FD72341CDCCCCAC202C5A4133333333B9D72341CDCCCC6C2B2C5A41000000007CD82341000000003E2C5A4100000000E5D82341666666662A2C5A41666666663CD9234100000020192C5A416666666648D923419A9999B9192C5A413333333379D92341CDCCCC8C0B2C5A410000000018DA2341333333D3082C5A41CDCCCCCC41D92341666666E6DF2B5A413333333353D9234133333353D32B5A41CDCCCCCC2FD7234133333353F62B5A4166666666CFD62341333333F3FB2B5A41CDCCCCCC61D62341666666E6052C5A41CDCCCCCC61D62341666666E6052C5A41	01010000206A080000EA8564883FD82341CCCCCC5C072C5A41	751062306	H	Notre-Dame des Champs 6	7510623	75106	75	11	0
01060000206A080000010000000103000000010000000F000000000000007CD82341000000003E2C5A410000000010D92341333333734C2C5A416666666689D923419A9999D9582C5A413333333301DA2341CDCCCC4C652C5A410000000088DA2341CDCCCC6C3B2C5A4166666666B4DA2341CDCCCC0C2D2C5A4100000000D1DA2341CDCCCC8C2C2C5A41CDCCCCCCC5DA2341000000402A2C5A410000000018DA2341333333D3082C5A41CDCCCCCCFFD9234166666666092C5A413333333379D92341CDCCCC8C0B2C5A416666666648D923419A9999B9192C5A41666666663CD9234100000020192C5A4100000000E5D82341666666662A2C5A41000000007CD82341000000003E2C5A41	01060000206A080000010000000103000000010000000F000000000000007CD82341000000003E2C5A410000000010D92341333333734C2C5A416666666689D923419A9999D9582C5A413333333301DA2341CDCCCC4C652C5A410000000088DA2341CDCCCC6C3B2C5A4166666666B4DA2341CDCCCC0C2D2C5A4100000000D1DA2341CDCCCC8C2C2C5A41CDCCCCCCC5DA2341000000402A2C5A410000000018DA2341333333D3082C5A41CDCCCCCCFFD9234166666666092C5A413333333379D92341CDCCCC8C0B2C5A416666666648D923419A9999B9192C5A41666666663CD9234100000020192C5A4100000000E5D82341666666662A2C5A41000000007CD82341000000003E2C5A41	01010000206A0800002ABEE23FA7D92341CDCCCC3C342C5A41	751062307	H	Notre-Dame des Champs 7	7510623	75106	75	11	0
01060000206A080000010000000103000000010000001E000000CDCCCCCCFFD42341666666A62B2C5A419A99999921D52341000000802D2C5A419A99999945D52341000000E02F2C5A419A999999DBD52341CDCCCC2C3A2C5A41666666665ED6234100000060432C5A41333333338FD62341000000E0462C5A4100000000A1D6234166666666482C5A4100000000C0D623419A9999394B2C5A410000000001D723419A999939512C5A41CDCCCCCC36D7234133333373562C5A419A99999957D72341000000A0592C5A4166666666FDD723419A9999B9692C5A41333333331BD82341CDCCCC8C6C2C5A41CDCCCCCC97D8234100000060782C5A4166666666CAD82341666666C67C2C5A416666666689D923419A9999D9582C5A410000000010D92341333333734C2C5A41000000007CD82341000000003E2C5A4133333333B9D72341CDCCCC6C2B2C5A419A9999994FD72341CDCCCCAC202C5A4133333333B6D62341CDCCCC6C0F2C5A41CDCCCCCC61D62341666666E6052C5A41CDCCCCCC34D62341666666460A2C5A4133333333FED52341CDCCCCCC0F2C5A4100000000DED52341333333F3122C5A4133333333A9D5234166666646182C5A410000000027D5234166666646252C5A419A99999913D52341CDCCCC0C282C5A413333333301D52341666666662B2C5A41CDCCCCCCFFD42341666666A62B2C5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCCFFD42341666666A62B2C5A419A99999945D52341000000E02F2C5A41333333338FD62341000000E0462C5A410000000001D723419A999939512C5A4166666666FDD723419A9999B9692C5A4166666666CAD82341666666C67C2C5A416666666689D923419A9999D9582C5A410000000010D92341333333734C2C5A4133333333B9D72341CDCCCC6C2B2C5A419A9999994FD72341CDCCCCAC202C5A41CDCCCCCC61D62341666666E6052C5A410000000027D5234166666646252C5A41CDCCCCCCFFD42341666666A62B2C5A41CDCCCCCCFFD42341666666A62B2C5A41	01010000206A080000983BBDDB67D72341000000B0402C5A41	751062308	H	Notre-Dame des Champs 8	7510623	75106	75	11	0
01060000206A080000010000000103000000010000001800000066666666CAD82341666666C67C2C5A413333333335D9234133333333862C5A419A9999994BD9234133333333882C5A41333333338FD92341CDCCCC2C8D2C5A41CDCCCCCCEED9234133333393942C5A416666666631DA2341333333D3992C5A4166666666B4DA2341000000E0A32C5A4133333333CEDA2341666666E6A52C5A4133333333DCDA23419A999919A72C5A41CDCCCCCCDADA234166666606A82C5A419A999999E9DA2341666666C6A52C5A4166666666F3DA23419A9999599F2C5A41CDCCCCCCF7DA2341666666C69C2C5A416666666604DB234100000040942C5A41666666661DDB23419A9999B9842C5A41CDCCCCCC6EDB2341666666264C2C5A41CDCCCCCC58DB234100000060472C5A419A999999F9DA2341666666A6342C5A4100000000D1DA2341CDCCCC8C2C2C5A4166666666B4DA2341CDCCCC0C2D2C5A410000000088DA2341CDCCCC6C3B2C5A413333333301DA2341CDCCCC4C652C5A416666666689D923419A9999D9582C5A4166666666CAD82341666666C67C2C5A41	01060000206A080000010000000103000000010000001800000066666666CAD82341666666C67C2C5A413333333335D9234133333333862C5A419A9999994BD9234133333333882C5A41333333338FD92341CDCCCC2C8D2C5A41CDCCCCCCEED9234133333393942C5A416666666631DA2341333333D3992C5A4166666666B4DA2341000000E0A32C5A4133333333CEDA2341666666E6A52C5A4133333333DCDA23419A999919A72C5A41CDCCCCCCDADA234166666606A82C5A419A999999E9DA2341666666C6A52C5A4166666666F3DA23419A9999599F2C5A41CDCCCCCCF7DA2341666666C69C2C5A416666666604DB234100000040942C5A41666666661DDB23419A9999B9842C5A41CDCCCCCC6EDB2341666666264C2C5A41CDCCCCCC58DB234100000060472C5A419A999999F9DA2341666666A6342C5A4100000000D1DA2341CDCCCC8C2C2C5A4166666666B4DA2341CDCCCC0C2D2C5A410000000088DA2341CDCCCC6C3B2C5A413333333301DA2341CDCCCC4C652C5A416666666689D923419A9999D9582C5A4166666666CAD82341666666C67C2C5A41	01010000206A080000A6FAE04321DA23419A999909712C5A41	751062309	H	Notre-Dame des Champs 9	7510623	75106	75	11	0
01060000206A080000010000000103000000010000001B00000066666666D3DA234133333333AD2C5A410000000017DB2341CDCCCC6CAF2C5A41000000006EDB2341000000C0B12C5A4166666666E2DB2341000000E0B42C5A419A999999FCDB234133333393B52C5A41666666669BDC234100000000BB2C5A419A999999A9DC23419A999979BB2C5A4166666666C4DC23419A9999B9BC2C5A41666666669FDD2341333333D3C22C5A4100000000BDDD234100000040C32C5A41CDCCCCCCAFDD2341666666A6C02C5A41000000004ADD23419A999999AC2C5A410000000009DD2341666666269F2C5A41000000009BDC234100000080882C5A41666666667CDC234133333333832C5A41333333336FDC234100000040802C5A419A999999FCDB2341666666C6682C5A41CDCCCCCCE9DB23419A9999B9642C5A41CDCCCCCC8CDB2341666666E6512C5A41CDCCCCCC6EDB2341666666264C2C5A41666666661DDB23419A9999B9842C5A416666666604DB234100000040942C5A41CDCCCCCCF7DA2341666666C69C2C5A4166666666F3DA23419A9999599F2C5A419A999999E9DA2341666666C6A52C5A41CDCCCCCCDADA234166666606A82C5A4166666666D3DA234133333333AD2C5A41	01060000206A080000010000000103000000010000000C00000066666666D3DA234133333333AD2C5A419A999999FCDB234133333393B52C5A4166666666C4DC23419A9999B9BC2C5A4100000000BDDD234100000040C32C5A41000000004ADD23419A999999AC2C5A41000000009BDC234100000080882C5A41333333336FDC234100000040802C5A41CDCCCCCC6EDB2341666666264C2C5A41666666661DDB23419A9999B9842C5A419A999999E9DA2341666666C6A52C5A4166666666D3DA234133333333AD2C5A4166666666D3DA234133333333AD2C5A41	01010000206A080000EE80403BD5DB2341CDCCCC9C862C5A41	751062310	H	Notre-Dame des Champs 10	7510623	75106	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCC6EDB2341666666264C2C5A41CDCCCCCC8CDB2341666666E6512C5A41CDCCCCCCE9DB23419A9999B9642C5A419A999999FCDB2341666666C6682C5A41333333336FDC234100000040802C5A41666666667CDC234133333333832C5A41000000009BDC234100000080882C5A410000000009DD2341666666269F2C5A41000000004ADD23419A999999AC2C5A41CDCCCCCCAFDD2341666666A6C02C5A41CDCCCCCCC6DD23419A999939BF2C5A4100000000C9DD2341CDCCCC4CBE2C5A4166666666CADD234100000000BD2C5A4133333333C0DD2341333333D3A62C5A4133333333D3DD2341CDCCCC6CA62C5A4166666666BBDD234133333313972C5A4100000000B9DD2341666666E6942C5A419A999999ADDD23419A9999B9872C5A419A999999A0DD2341666666466E2C5A413333333395DD23419A999959542C5A419A99999936DD2341CDCCCC4C4F2C5A413333333360DC23419A999959442C5A41CDCCCCCC8BDB2341CDCCCCAC382C5A41CDCCCCCC6EDB2341666666264C2C5A41	01060000206A0800000100000001030000000100000018000000CDCCCCCC6EDB2341666666264C2C5A41CDCCCCCC8CDB2341666666E6512C5A41CDCCCCCCE9DB23419A9999B9642C5A419A999999FCDB2341666666C6682C5A41333333336FDC234100000040802C5A41666666667CDC234133333333832C5A41000000009BDC234100000080882C5A410000000009DD2341666666269F2C5A41000000004ADD23419A999999AC2C5A41CDCCCCCCAFDD2341666666A6C02C5A41CDCCCCCCC6DD23419A999939BF2C5A4100000000C9DD2341CDCCCC4CBE2C5A4166666666CADD234100000000BD2C5A4133333333C0DD2341333333D3A62C5A4133333333D3DD2341CDCCCC6CA62C5A4166666666BBDD234133333313972C5A4100000000B9DD2341666666E6942C5A419A999999ADDD23419A9999B9872C5A419A999999A0DD2341666666466E2C5A413333333395DD23419A999959542C5A419A99999936DD2341CDCCCC4C4F2C5A413333333360DC23419A999959442C5A41CDCCCCCC8BDB2341CDCCCCAC382C5A41CDCCCCCC6EDB2341666666264C2C5A41	01010000206A0800008D3A0542F4DC234133333343772C5A41	751062311	H	Notre-Dame des Champs 11	7510623	75106	75	11	0
01060000206A080000010000000103000000010000002A00000066666666E0DB234166666646B92C5A4100000000E3DB23419A999919BA2C5A416666666647DC234133333333CA2C5A416666666650DC2341000000C0CC2C5A41CDCCCCCC5FDC2341CDCCCCCCD12C5A41CDCCCCCC71DC234100000060D72C5A419A9999997EDC23419A999959DB2C5A416666666698DC234100000020E32C5A419A999999E5DC2341000000E0F92C5A4166666666F0DC234166666606FD2C5A419A999999F2DC2341666666E6FC2C5A419A99999966DD234100000060F72C5A419A99999998DD234100000000F52C5A419A99999938DE2341CDCCCC6CED2C5A41CDCCCCCC6EDE23419A9999D9EA2C5A413333333395DE234166666606E92C5A419A999999B6DE234133333373E72C5A419A99999911DF234100000020E32C5A41000000005ADF2341333333B3DF2C5A41CDCCCCCCB8DF234133333333DB2C5A4100000000D4DF2341CDCCCCECD92C5A416666666603E0234133333313D82C5A4100000000F5DF2341CDCCCCECD52C5A4133333333EEDF23419A999939D52C5A419A999999E5DF234100000080D42C5A4100000000B6DF234166666606D22C5A41CDCCCCCC8FDF234166666666D02C5A416666666635DF234100000080CD2C5A4100000000EEDE234133333333CB2C5A4100000000D1DE2341CDCCCC2CCA2C5A419A999999C2DE2341333333D3C92C5A41CDCCCCCCBCDE2341CDCCCCACC92C5A419A99999975DE2341666666C6C92C5A419A999999FADD234133333393C62C5A4100000000BDDD234100000040C32C5A41666666669FDD2341333333D3C22C5A4166666666C4DC23419A9999B9BC2C5A419A999999A9DC23419A999979BB2C5A41666666669BDC234100000000BB2C5A419A999999FCDB234133333393B52C5A4166666666E2DB2341000000E0B42C5A4166666666E0DB234166666646B92C5A41	01060000206A080000010000000103000000010000000F00000066666666E0DB234166666646B92C5A416666666647DC234133333333CA2C5A4166666666F0DC234166666606FD2C5A4100000000D4DF2341CDCCCCECD92C5A416666666603E0234133333313D82C5A419A999999E5DF234100000080D42C5A41CDCCCCCC8FDF234166666666D02C5A41CDCCCCCCBCDE2341CDCCCCACC92C5A419A99999975DE2341666666C6C92C5A419A999999FADD234133333393C62C5A41666666669FDD2341333333D3C22C5A4166666666C4DC23419A9999B9BC2C5A4166666666E2DB2341000000E0B42C5A4166666666E0DB234166666646B92C5A4166666666E0DB234166666646B92C5A41	01010000206A0800000342C95D31DE234100000000D92C5A41	751062401	H	Saint-Germain des Prés 1	7510624	75106	75	11	0
01060000206A080000010000000103000000010000002E00000066666666F0DC234166666606FD2C5A410000000019DD2341CDCCCC2C0D2D5A41CDCCCCCC1EDD23419A9999B90E2D5A41CDCCCCCC74DD2341CDCCCC8C242D5A4166666666A4DD234166666606302D5A4133333333FFDD234133333333442D5A416666666644DE234133333313542D5A416666666693DE2341333333B3662D5A4133333333F6DE2341333333B3612D5A410000000080DF2341000000C05A2D5A4133333333ABDF2341CDCCCC6C592D5A4166666666BADF234133333333592D5A41CDCCCCCCE2DF23419A999939592D5A419A999999FBDF23419A9999B9592D5A416666666635E02341666666465A2D5A416666666649E02341000000A05A2D5A410000000033E0234133333313532D5A410000000038E023419A9999D9522D5A419A99999941E02341CDCCCC0C522D5A41666666665BE02341CDCCCCCC4E2D5A416666666661E02341CDCCCCAC4D2D5A419A99999965E02341666666064C2D5A419A9999996EE0234166666606462D5A413333333373E02341000000403F2D5A41CDCCCCCC74E02341666666263D2D5A41000000007FE02341333333932E2D5A41CDCCCCCC8AE023419A9999791D2D5A413333333392E0234166666646122D5A413333333395E02341666666A60D2D5A41666666669EE0234100000000FD2C5A4166666666A9E02341333333D3EA2C5A4166666666ABE0234100000020D02C5A41CDCCCCCC53E0234166666666D42C5A416666666603E0234133333313D82C5A4100000000D4DF2341CDCCCCECD92C5A41CDCCCCCCB8DF234133333333DB2C5A41000000005ADF2341333333B3DF2C5A419A99999911DF234100000020E32C5A419A999999B6DE234133333373E72C5A413333333395DE234166666606E92C5A41CDCCCCCC6EDE23419A9999D9EA2C5A419A99999938DE2341CDCCCC6CED2C5A419A99999998DD234100000000F52C5A419A99999966DD234100000060F72C5A419A999999F2DC2341666666E6FC2C5A4166666666F0DC234166666606FD2C5A41	01060000206A080000010000000103000000010000001100000066666666F0DC234166666606FD2C5A410000000019DD2341CDCCCC2C0D2D5A4166666666A4DD234166666606302D5A4133333333FFDD234133333333442D5A416666666693DE2341333333B3662D5A410000000080DF2341000000C05A2D5A41CDCCCCCCE2DF23419A999939592D5A416666666649E02341000000A05A2D5A410000000033E0234133333313532D5A41666666665BE02341CDCCCCCC4E2D5A419A9999996EE0234166666606462D5A413333333395E02341666666A60D2D5A4166666666A9E02341333333D3EA2C5A4166666666ABE0234100000020D02C5A4100000000D4DF2341CDCCCCECD92C5A4166666666F0DC234166666606FD2C5A4166666666F0DC234166666606FD2C5A41	01010000206A080000B41370ADE8DE2341000000E0172D5A41	751062402	H	Saint-Germain des Prés 2	7510624	75106	75	11	0
01060000206A0800000100000001030000000100000017000000CDCCCCCC1BDE2341000000806D2D5A419A99999932DE234133333353742D5A41CDCCCCCC34DE2341CDCCCC0C752D5A416666666661DE2341CDCCCCCC832D5A41CDCCCCCCA6DE2341CDCCCC0C812D5A41CDCCCCCC79DF2341333333B3782D5A419A9999995DE02341666666866F2D5A41666666665EE02341333333336B2D5A410000000068E02341CDCCCC4C5D2D5A41666666666AE02341333333F3592D5A413333333364E02341000000405A2D5A419A9999995AE023419A9999995A2D5A416666666649E02341000000A05A2D5A416666666635E02341666666465A2D5A419A999999FBDF23419A9999B9592D5A41CDCCCCCCE2DF23419A999939592D5A4166666666BADF234133333333592D5A4133333333ABDF2341CDCCCC6C592D5A410000000080DF2341000000C05A2D5A4133333333F6DE2341333333B3612D5A416666666693DE2341333333B3662D5A413333333352DE23419A9999596A2D5A41CDCCCCCC1BDE2341000000806D2D5A41	01060000206A0800000100000001030000000100000009000000CDCCCCCC1BDE2341000000806D2D5A416666666661DE2341CDCCCCCC832D5A419A9999995DE02341666666866F2D5A41666666666AE02341333333F3592D5A41CDCCCCCCE2DF23419A999939592D5A410000000080DF2341000000C05A2D5A416666666693DE2341333333B3662D5A41CDCCCCCC1BDE2341000000806D2D5A41CDCCCCCC1BDE2341000000806D2D5A41	01010000206A0800000D281F7C3EDF2341333333836E2D5A41	751062499	D	Seine et Berges 2	7510624	75106	75	11	0
01060000206A080000010000000103000000010000004A0000003333333399C52341CDCCCCAC6A2D5A41CDCCCCCC0CC62341CDCCCC8C7C2D5A419A99999935C62341333333F3832D5A4133333333D7C62341333333F39B2D5A41333333330CC72341333333D3A32D5A4166666666E9C72341CDCCCC2CBF2D5A419A99999955C8234100000080C92D5A410000000097C823419A999979D02D5A41CDCCCCCCEEC8234133333313D72D5A41CDCCCCCCBEC92341333333D3E42D5A413333333323CA2341333333D3EA2D5A4100000000BCCA234100000020F32D5A413333333319CB2341666666E6F62D5A419A999999A0CB23419A999999F92D5A410000000055CC234133333333FC2D5A419A9999998ACC234166666666FC2D5A419A9999998BCC234133333393FC2D5A4100000000E2CC234100000020FD2D5A416666666631CF2341000000A0FD2D5A41000000000BD1234166666606FE2D5A416666666680D1234100000020FE2D5A413333333384D123419A9999B9EA2D5A416666666684D1234166666666E92D5A410000000084D123419A999979E62D5A419A99999983D123419A9999F9E12D5A41333333335CD12341CDCCCC8CE12D5A41666666660DD123419A9999F9E02D5A4166666666D1D02341666666C6E02D5A41CDCCCCCC19CF2341CDCCCCACDF2D5A4166666666A5CE234133333373DF2D5A41000000002ECD234133333373DE2D5A41CDCCCCCCEFCC234166666626DF2D5A4133333333A7CC234166666666DF2D5A413333333374CC23419A999999DE2D5A413333333329CC234133333393DD2D5A41000000000CCC2341CDCCCC0CDD2D5A4100000000DECB2341CDCCCC8CDC2D5A419A999999A3CB234133333393DB2D5A413333333365CB234100000020DA2D5A41CDCCCCCC30CB234133333373D82D5A41CDCCCCCCF3CA234133333333D62D5A41CDCCCCCCC3CA2341CDCCCC2CD42D5A419A9999996FCA2341333333D3CF2D5A41666666666CCA2341666666A6CF2D5A410000000058CA234166666686CE2D5A410000000028CA234166666666CB2D5A410000000024CA234166666626CB2D5A419A999999F3C9234100000060C82D5A4100000000CCC9234166666666C52D5A41666666669AC92341CDCCCC2CC12D5A41000000005FC9234133333353BB2D5A413333333340C92341CDCCCC0CB82D5A41CDCCCCCC24C9234166666606B52D5A41333333330FC9234133333333B22D5A41CDCCCCCCEEC8234133333333AE2D5A41CDCCCCCCCDC8234166666606AA2D5A4100000000C7C8234166666606A92D5A413333333395C823419A9999D9A12D5A413333333393C82341CDCCCC8CA12D5A416666666656C8234166666606992D5A419A9999991EC82341000000E0912D5A4166666666CEC7234100000080872D5A4166666666A5C723419A999939822D5A41CDCCCCCC7CC72341CDCCCCEC7C2D5A41CDCCCCCCFCC62341000000406C2D5A4166666666B5C6234133333353632D5A4166666666B3C6234133333313632D5A4166666666ACC623419A999939622D5A419A99999988C623419A9999395D2D5A41000000005FC62341666666C6562D5A41000000004FC62341000000A0582D5A41CDCCCCCC22C62341000000605D2D5A41CDCCCCCC02C62341CDCCCCAC602D5A413333333399C52341CDCCCCAC6A2D5A41	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	01010000206A0800005E957CC316C82341CCCCCC1CAC2D5A41	751072899	D	Seine et Berges 3	7510728	75107	75	11	0
01060000206A08000001000000010300000001000000270000006666666628DA23419A9999F9242D5A41000000003ADA234166666626272D5A410000000050DA23419A999979292D5A416666666670DA234133333313272D5A4100000000DFDA2341666666861D2D5A410000000024DB23419A999919182D5A410000000054DB23419A999919142D5A410000000089DB2341CDCCCCAC102D5A41666666663CDC23419A9999D9062D5A4166666666F0DC234166666606FD2C5A419A999999E5DC2341000000E0F92C5A416666666698DC234100000020E32C5A419A9999997EDC23419A999959DB2C5A41CDCCCCCC71DC234100000060D72C5A41CDCCCCCC5FDC2341CDCCCCCCD12C5A416666666650DC2341000000C0CC2C5A416666666647DC234133333333CA2C5A4100000000E3DB23419A999919BA2C5A4166666666E0DB234166666646B92C5A4166666666E2DB2341000000E0B42C5A41000000006EDB2341000000C0B12C5A410000000017DB2341CDCCCC6CAF2C5A4166666666D3DA234133333333AD2C5A41CDCCCCCCDADA234166666606A82C5A4133333333DADA234100000020A82C5A4166666666D2DA234133333393AD2C5A4100000000CDDA2341CDCCCC8CB12C5A419A999999C2DA234100000000BA2C5A419A999999C6DA2341000000A0BC2C5A419A999999C2DA234100000060C22C5A41CDCCCCCCBFDA234133333393C52C5A413333333396DA2341000000E0DF2C5A413333333386DA2341CDCCCC0CEC2C5A410000000070DA234133333353FA2C5A419A99999962DA2341CDCCCC6C032D5A41CDCCCCCC5EDA2341666666E6052D5A413333333349DA2341CDCCCCEC142D5A416666666639DA234100000080212D5A416666666628DA23419A9999F9242D5A41	01060000206A080000010000000103000000010000000F0000006666666628DA23419A9999F9242D5A410000000050DA23419A999979292D5A410000000054DB23419A999919142D5A410000000089DB2341CDCCCCAC102D5A4166666666F0DC234166666606FD2C5A416666666647DC234133333333CA2C5A4100000000E3DB23419A999919BA2C5A4166666666E2DB2341000000E0B42C5A4166666666D3DA234133333333AD2C5A419A999999C2DA234100000000BA2C5A41CDCCCCCCBFDA234133333393C52C5A413333333349DA2341CDCCCCEC142D5A416666666639DA234100000080212D5A416666666628DA23419A9999F9242D5A416666666628DA23419A9999F9242D5A41	01010000206A0800008C4EC4CD99DB234166666696E72C5A41	751072501	H	Saint-Thomas d'Aquin 1	7510725	75107	75	11	0
01060000206A080000010000000103000000010000001D0000009A999999EFD8234166666646B12C5A410000000001D923419A9999D9C42C5A410000000009D923419A9999F9CD2C5A41CDCCCCCC11D923419A999919D82C5A416666666624D92341CDCCCCCCF02C5A419A9999992DD923419A9999F9F62C5A416666666662D923419A999999032D5A413333333392D92341666666860C2D5A4166666666BFD92341CDCCCC4C152D5A4100000000F9D92341333333D31E2D5A416666666628DA23419A9999F9242D5A416666666639DA234100000080212D5A413333333349DA2341CDCCCCEC142D5A41CDCCCCCC5EDA2341666666E6052D5A419A99999962DA2341CDCCCC6C032D5A410000000070DA234133333353FA2C5A413333333386DA2341CDCCCC0CEC2C5A413333333396DA2341000000E0DF2C5A41CDCCCCCCBFDA234133333393C52C5A419A999999C2DA234100000060C22C5A419A999999C6DA2341000000A0BC2C5A419A999999C2DA234100000000BA2C5A4100000000CDDA2341CDCCCC8CB12C5A4166666666A5DA23419A999979B12C5A4100000000CFD923419A999919B12C5A4166666666B5D92341CDCCCC0CB12C5A41666666666BD9234100000000B12C5A419A999999FFD82341CDCCCCECB02C5A419A999999EFD8234166666646B12C5A41	01060000206A080000010000000103000000010000000E0000009A999999EFD8234166666646B12C5A41CDCCCCCC11D923419A999919D82C5A416666666624D92341CDCCCCCCF02C5A419A9999992DD923419A9999F9F62C5A416666666662D923419A999999032D5A4166666666BFD92341CDCCCC4C152D5A416666666628DA23419A9999F9242D5A416666666639DA234100000080212D5A413333333349DA2341CDCCCCEC142D5A41CDCCCCCCBFDA234133333393C52C5A4100000000CDDA2341CDCCCC8CB12C5A419A999999FFD82341CDCCCCECB02C5A419A999999EFD8234166666646B12C5A419A999999EFD8234166666646B12C5A41	01010000206A08000038173038D5D92341666666F6E52C5A41	751072502	H	Saint-Thomas d'Aquin 2	7510725	75107	75	11	0
01060000206A0800000100000001030000000100000022000000CDCCCCCC5BD6234133333393B12C5A41CDCCCCCC5BD62341CDCCCC4CB82C5A416666666669D6234100000040CE2C5A41000000007CD62341CDCCCC4CD72C5A4133333333BED62341CDCCCCACF72C5A4133333333EBD623419A9999F90B2D5A419A99999972D723419A999999052D5A4133333333F4D7234100000040FF2C5A41000000002ED8234133333373FC2C5A416666666624D92341CDCCCCCCF02C5A41CDCCCCCC11D923419A999919D82C5A410000000009D923419A9999F9CD2C5A410000000001D923419A9999D9C42C5A419A999999EFD8234166666646B12C5A419A99999910D9234100000080A22C5A41CDCCCCCC1ED923419A9999999B2C5A41CDCCCCCC1FD92341666666269B2C5A41666666662FD923419A9999F9932C5A419A99999930D9234166666666932C5A410000000037D92341CDCCCC6C902C5A416666666639D92341333333738F2C5A419A9999994BD9234133333333882C5A413333333335D9234133333333862C5A4166666666CAD82341666666C67C2C5A41CDCCCCCC97D8234100000060782C5A41333333331BD82341CDCCCC8C6C2C5A4166666666FDD723419A9999B9692C5A419A99999957D72341000000A0592C5A41CDCCCCCC36D7234133333373562C5A419A999999FAD62341333333136F2C5A4166666666DED623419A9999797A2C5A419A999999A9D62341333333F3902C5A4133333333A3D62341666666C6942C5A41CDCCCCCC5BD6234133333393B12C5A41	01060000206A0800000100000001030000000100000022000000CDCCCCCC5BD6234133333393B12C5A41CDCCCCCC5BD62341CDCCCC4CB82C5A416666666669D6234100000040CE2C5A41000000007CD62341CDCCCC4CD72C5A4133333333BED62341CDCCCCACF72C5A4133333333EBD623419A9999F90B2D5A419A99999972D723419A999999052D5A4133333333F4D7234100000040FF2C5A41000000002ED8234133333373FC2C5A416666666624D92341CDCCCCCCF02C5A41CDCCCCCC11D923419A999919D82C5A410000000009D923419A9999F9CD2C5A410000000001D923419A9999D9C42C5A419A999999EFD8234166666646B12C5A419A99999910D9234100000080A22C5A41CDCCCCCC1ED923419A9999999B2C5A41CDCCCCCC1FD92341666666269B2C5A41666666662FD923419A9999F9932C5A419A99999930D9234166666666932C5A410000000037D92341CDCCCC6C902C5A416666666639D92341333333738F2C5A419A9999994BD9234133333333882C5A413333333335D9234133333333862C5A4166666666CAD82341666666C67C2C5A41CDCCCCCC97D8234100000060782C5A41333333331BD82341CDCCCC8C6C2C5A4166666666FDD723419A9999B9692C5A419A99999957D72341000000A0592C5A41CDCCCCCC36D7234133333373562C5A419A999999FAD62341333333136F2C5A4166666666DED623419A9999797A2C5A419A999999A9D62341333333F3902C5A4133333333A3D62341666666C6942C5A41CDCCCCCC5BD6234133333393B12C5A41	01010000206A0800003433B37AB7D72341333333E3A92C5A41	751072503	H	Saint-Thomas d'Aquin 3	7510725	75107	75	11	0
01060000206A080000010000000103000000010000001A00000033333333EBD623419A9999F90B2D5A416666666699D7234133333313362D5A41000000005BD823419A9999995A2D5A413333333391D8234133333373642D5A4166666666C1D82341333333736E2D5A41CDCCCCCCF9D82341CDCCCCAC632D5A41000000002CD92341CDCCCC0C592D5A410000000070D92341666666E64A2D5A413333333388D923419A999939462D5A41000000009AD9234166666686432D5A416666666608DA2341CDCCCC0C342D5A419A9999990FDA234133333313332D5A41333333333DDA23419A9999B92B2D5A410000000050DA23419A999979292D5A41000000003ADA234166666626272D5A416666666628DA23419A9999F9242D5A4100000000F9D92341333333D31E2D5A4166666666BFD92341CDCCCC4C152D5A413333333392D92341666666860C2D5A416666666662D923419A999999032D5A419A9999992DD923419A9999F9F62C5A416666666624D92341CDCCCCCCF02C5A41000000002ED8234133333373FC2C5A4133333333F4D7234100000040FF2C5A419A99999972D723419A999999052D5A4133333333EBD623419A9999F90B2D5A41	01060000206A080000010000000103000000010000000F00000033333333EBD623419A9999F90B2D5A416666666699D7234133333313362D5A41000000005BD823419A9999995A2D5A4166666666C1D82341333333736E2D5A41CDCCCCCCF9D82341CDCCCCAC632D5A410000000070D92341666666E64A2D5A41000000009AD9234166666686432D5A410000000050DA23419A999979292D5A4100000000F9D92341333333D31E2D5A4166666666BFD92341CDCCCC4C152D5A416666666662D923419A999999032D5A419A9999992DD923419A9999F9F62C5A416666666624D92341CDCCCCCCF02C5A4133333333EBD623419A9999F90B2D5A4133333333EBD623419A9999F90B2D5A41	01010000206A080000C4781717D2D82341666666662F2D5A41	751072504	H	Saint-Thomas d'Aquin 4	7510725	75107	75	11	0
01060000206A080000010000000103000000010000001C00000066666666C1D82341333333736E2D5A410000000026D92341CDCCCC8C812D5A41333333339CD92341CDCCCCAC982D5A419A99999966DA2341CDCCCCEC8C2D5A4166666666A6DA234166666646892D5A410000000038DB234133333313812D5A410000000062DB2341333333B37E2D5A4166666666FEDB2341666666E6752D5A4166666666BDDB23419A999999652D5A416666666686DB234166666646572D5A416666666643DB2341333333B3442D5A413333333339DB234133333373422D5A41CDCCCCCC35DB2341666666E6412D5A419A999999FFDA2341000000203C2D5A419A999999F0DA2341000000803A2D5A419A999999D7DA2341333333D3372D5A4100000000B4DA23419A9999F9332D5A416666666665DA2341333333932B2D5A410000000050DA23419A999979292D5A41333333333DDA23419A9999B92B2D5A419A9999990FDA234133333313332D5A416666666608DA2341CDCCCC0C342D5A41000000009AD9234166666686432D5A413333333388D923419A999939462D5A410000000070D92341666666E64A2D5A41000000002CD92341CDCCCC0C592D5A41CDCCCCCCF9D82341CDCCCCAC632D5A4166666666C1D82341333333736E2D5A41	01060000206A080000010000000103000000010000000B00000066666666C1D82341333333736E2D5A41333333339CD92341CDCCCCAC982D5A4166666666A6DA234166666646892D5A4166666666FEDB2341666666E6752D5A41CDCCCCCC35DB2341666666E6412D5A410000000050DA23419A999979292D5A41000000009AD9234166666686432D5A410000000070D92341666666E64A2D5A41CDCCCCCCF9D82341CDCCCCAC632D5A4166666666C1D82341333333736E2D5A4166666666C1D82341333333736E2D5A41	01010000206A080000A6968A415ADA2341CDCCCC5C5E2D5A41	751072505	H	Saint-Thomas d'Aquin 5	7510725	75107	75	11	0
01060000206A08000001000000010300000001000000260000000000000050DA23419A999979292D5A416666666665DA2341333333932B2D5A4100000000B4DA23419A9999F9332D5A419A999999D7DA2341333333D3372D5A419A999999F0DA2341000000803A2D5A419A999999FFDA2341000000203C2D5A41CDCCCCCC35DB2341666666E6412D5A413333333339DB234133333373422D5A416666666643DB2341333333B3442D5A416666666686DB234166666646572D5A4166666666BDDB23419A999999652D5A4166666666FEDB2341666666E6752D5A41333333333DDC234133333333862D5A41CDCCCCCC47DC234100000060892D5A41CDCCCCCC4DDC2341CDCCCC6C8A2D5A419A99999983DC234100000000872D5A41CDCCCCCC8DDC2341000000E0862D5A4166666666D2DC2341CDCCCC6C822D5A419A999999DEDC2341000000A0812D5A410000000065DD2341CDCCCC0C792D5A4166666666ECDD234133333353702D5A41CDCCCCCC1BDE2341000000806D2D5A413333333352DE23419A9999596A2D5A416666666693DE2341333333B3662D5A416666666644DE234133333313542D5A4133333333FFDD234133333333442D5A4166666666A4DD234166666606302D5A41CDCCCCCC74DD2341CDCCCC8C242D5A41CDCCCCCC1EDD23419A9999B90E2D5A410000000019DD2341CDCCCC2C0D2D5A4166666666F0DC234166666606FD2C5A41666666663CDC23419A9999D9062D5A410000000089DB2341CDCCCCAC102D5A410000000054DB23419A999919142D5A410000000024DB23419A999919182D5A4100000000DFDA2341666666861D2D5A416666666670DA234133333313272D5A410000000050DA23419A999979292D5A41	01060000206A080000010000000103000000010000000F0000000000000050DA23419A999979292D5A41CDCCCCCC35DB2341666666E6412D5A416666666686DB234166666646572D5A41CDCCCCCC4DDC2341CDCCCC6C8A2D5A41CDCCCCCC8DDC2341000000E0862D5A4166666666ECDD234133333353702D5A416666666693DE2341333333B3662D5A4133333333FFDD234133333333442D5A4166666666A4DD234166666606302D5A410000000019DD2341CDCCCC2C0D2D5A4166666666F0DC234166666606FD2C5A410000000089DB2341CDCCCCAC102D5A410000000054DB23419A999919142D5A410000000050DA23419A999979292D5A410000000050DA23419A999979292D5A41	01010000206A080000342BDD369CDC234133333353432D5A41	751072506	H	Saint-Thomas d'Aquin 6	7510725	75107	75	11	0
01060000206A08000001000000010300000001000000190000009A999999EFD8234166666646B12C5A419A999999FFD82341CDCCCCECB02C5A41666666666BD9234100000000B12C5A4166666666B5D92341CDCCCC0CB12C5A4100000000CFD923419A999919B12C5A4166666666A5DA23419A999979B12C5A4100000000CDDA2341CDCCCC8CB12C5A4166666666D2DA234133333393AD2C5A4133333333DADA234100000020A82C5A41CDCCCCCCDADA234166666606A82C5A4133333333DCDA23419A999919A72C5A4133333333CEDA2341666666E6A52C5A4166666666B4DA2341000000E0A32C5A416666666631DA2341333333D3992C5A41CDCCCCCCEED9234133333393942C5A41333333338FD92341CDCCCC2C8D2C5A419A9999994BD9234133333333882C5A416666666639D92341333333738F2C5A410000000037D92341CDCCCC6C902C5A419A99999930D9234166666666932C5A41666666662FD923419A9999F9932C5A41CDCCCCCC1FD92341666666269B2C5A41CDCCCCCC1ED923419A9999999B2C5A419A99999910D9234100000080A22C5A419A999999EFD8234166666646B12C5A41	01060000206A08000001000000010300000001000000070000009A999999EFD8234166666646B12C5A419A999999FFD82341CDCCCCECB02C5A4100000000CDDA2341CDCCCC8CB12C5A4133333333DCDA23419A999919A72C5A419A9999994BD9234133333333882C5A419A999999EFD8234166666646B12C5A419A999999EFD8234166666646B12C5A41	01010000206A080000BAD57D9AC6D92341CDCCCC0C9F2C5A41	751072507	A	Saint-Thomas d'Aquin 7	7510725	75107	75	11	0
01060000206A0800000100000001030000000100000014000000333333339CD92341CDCCCCAC982D5A416666666607DA23419A999979AD2D5A416666666621DA23419A9999F9AB2D5A410000000069DA2341666666C6A72D5A41CDCCCCCCDFDA2341333333B3A02D5A419A999999F7DA2341333333539F2D5A410000000041DB2341000000009B2D5A41666666665ADB234166666646992D5A413333333386DB23419A999999962D5A4133333333AEDB23419A999919942D5A419A999999F5DB23419A9999B98F2D5A41CDCCCCCC4DDC2341CDCCCC6C8A2D5A41CDCCCCCC47DC234100000060892D5A41333333333DDC234133333333862D5A4166666666FEDB2341666666E6752D5A410000000062DB2341333333B37E2D5A410000000038DB234133333313812D5A4166666666A6DA234166666646892D5A419A99999966DA2341CDCCCCEC8C2D5A41333333339CD92341CDCCCCAC982D5A41	01060000206A0800000100000001030000000100000008000000333333339CD92341CDCCCCAC982D5A416666666607DA23419A999979AD2D5A410000000041DB2341000000009B2D5A41CDCCCCCC4DDC2341CDCCCC6C8A2D5A4166666666FEDB2341666666E6752D5A4166666666A6DA234166666646892D5A41333333339CD92341CDCCCCAC982D5A41333333339CD92341CDCCCCAC982D5A41	01010000206A080000CD6D384BF1DA23419A9999E9912D5A41	751072508	A	Saint-Thomas d'Aquin 8	7510725	75107	75	11	0
01060000206A08000001000000010300000001000000210000006666666607DA23419A999979AD2D5A413333333312DA23419A9999B9AF2D5A41333333331FDA23419A9999B9B12D5A419A99999966DA2341CDCCCC0CBF2D5A419A99999960DA2341CDCCCC2CC02D5A410000000090DB23419A9999D9AD2D5A4166666666A2DC2341000000209B2D5A4133333333A6DC2341000000E09A2D5A4133333333ACDC2341CDCCCC6C9A2D5A4166666666B2DC2341666666069A2D5A419A999999B5DC2341333333D3992D5A410000000068DD2341000000A08D2D5A416666666661DE2341CDCCCCCC832D5A41CDCCCCCC34DE2341CDCCCC0C752D5A419A99999932DE234133333353742D5A41CDCCCCCC1BDE2341000000806D2D5A4166666666ECDD234133333353702D5A410000000065DD2341CDCCCC0C792D5A419A999999DEDC2341000000A0812D5A4166666666D2DC2341CDCCCC6C822D5A41CDCCCCCC8DDC2341000000E0862D5A419A99999983DC234100000000872D5A41CDCCCCCC4DDC2341CDCCCC6C8A2D5A419A999999F5DB23419A9999B98F2D5A4133333333AEDB23419A999919942D5A413333333386DB23419A999999962D5A41666666665ADB234166666646992D5A410000000041DB2341000000009B2D5A419A999999F7DA2341333333539F2D5A41CDCCCCCCDFDA2341333333B3A02D5A410000000069DA2341666666C6A72D5A416666666621DA23419A9999F9AB2D5A416666666607DA23419A999979AD2D5A41	01060000206A080000010000000103000000010000000C0000006666666607DA23419A999979AD2D5A419A99999966DA2341CDCCCC0CBF2D5A419A99999960DA2341CDCCCC2CC02D5A410000000090DB23419A9999D9AD2D5A410000000068DD2341000000A08D2D5A416666666661DE2341CDCCCCCC832D5A41CDCCCCCC1BDE2341000000806D2D5A41CDCCCCCC8DDC2341000000E0862D5A419A99999983DC234100000000872D5A410000000041DB2341000000009B2D5A416666666607DA23419A999979AD2D5A416666666607DA23419A999979AD2D5A41	01010000206A080000E7DB1AC020DC2341000000F0972D5A41	751072599	D	Seine et Berges 1	7510725	75107	75	11	0
01060000206A08000001000000010300000001000000170000009A9999992AD5234100000060212D5A41000000008DD5234166666606552D5A4100000000BBD523419A9999B96F2D5A4100000000D5D5234100000040832D5A410000000080D62341CDCCCC8C782D5A419A999999DBD6234133333373722D5A41000000005BD823419A9999995A2D5A416666666699D7234133333313362D5A4133333333EBD623419A9999F90B2D5A4133333333BED62341CDCCCCACF72C5A41000000007CD62341CDCCCC4CD72C5A416666666669D6234100000040CE2C5A41CDCCCCCC5BD62341CDCCCC4CB82C5A41CDCCCCCC5BD6234133333393B12C5A4166666666E5D5234100000080B22C5A419A9999998ED5234133333333B32C5A416666666645D52341000000C0B32C5A41333333335ED52341000000E0C52C5A41333333337ED523419A999939DD2C5A4100000000A5D523419A999919F82C5A41CDCCCCCCB5D52341666666A6032D5A41CDCCCCCCD4D52341000000C0192D5A419A9999992AD5234100000060212D5A41	01060000206A08000001000000010300000001000000170000009A9999992AD5234100000060212D5A41000000008DD5234166666606552D5A4100000000BBD523419A9999B96F2D5A4100000000D5D5234100000040832D5A410000000080D62341CDCCCC8C782D5A419A999999DBD6234133333373722D5A41000000005BD823419A9999995A2D5A416666666699D7234133333313362D5A4133333333EBD623419A9999F90B2D5A4133333333BED62341CDCCCCACF72C5A41000000007CD62341CDCCCC4CD72C5A416666666669D6234100000040CE2C5A41CDCCCCCC5BD62341CDCCCC4CB82C5A41CDCCCCCC5BD6234133333393B12C5A4166666666E5D5234100000080B22C5A419A9999998ED5234133333333B32C5A416666666645D52341000000C0B32C5A41333333335ED52341000000E0C52C5A41333333337ED523419A999939DD2C5A4100000000A5D523419A999919F82C5A41CDCCCCCCB5D52341666666A6032D5A41CDCCCCCCD4D52341000000C0192D5A419A9999992AD5234100000060212D5A41	01010000206A080000C83D24D659D62341000000901D2D5A41	751072601	H	Invalides 1	7510726	75107	75	11	0
01060000206A080000010000000103000000010000003500000033333333C5D32341CDCCCC4CB52C5A41CDCCCCCCC7D323419A9999D9B82C5A419A999999E7D32341666666A6E52C5A41CDCCCCCCE8D323419A999979E72C5A419A999999EAD3234100000000EA2C5A41CDCCCCCCFCD3234100000020052D5A419A99999918D42341333333F32D2D5A416666666627D42341000000A0452D5A419A99999928D4234100000060472D5A41CDCCCCCC35D423419A9999795C2D5A41333333333AD42341333333F3602D5A419A9999991CD42341333333B3612D5A410000000013D42341CDCCCCEC612D5A419A999999F5D32341CDCCCCAC622D5A4100000000F5D32341000000C0622D5A419A999999E1D3234133333313652D5A41CDCCCCCCE3D32341000000E06B2D5A4100000000E8D32341CDCCCCEC6F2D5A41CDCCCCCCF1D32341CDCCCC0C7A2D5A4166666666F6D323419A9999B9802D5A41CDCCCCCCF8D323419A999959842D5A419A99999900D42341333333538F2D5A413333333303D4234133333313932D5A419A99999906D4234100000000982D5A41CDCCCCCC19D4234100000040B42D5A4100000000EFD42341666666E6B12D5A4133333333F1D42341000000E0B12D5A419A9999993AD5234133333313B12D5A41CDCCCCCC48D52341000000E0B02D5A41CDCCCCCCDAD52341CDCCCCECAE2D5A4100000000D9D523419A9999D9A82D5A4166666666DBD52341000000C0A62D5A4100000000E2D52341000000C0A42D5A419A999999E8D52341CDCCCC6CA32D5A4100000000F2D52341666666A6A22D5A419A99999900D623419A9999B9A12D5A41CDCCCCCCECD5234166666626932D5A4100000000D5D5234100000040832D5A4100000000BBD523419A9999B96F2D5A41000000008DD5234166666606552D5A419A9999992AD5234100000060212D5A41CDCCCCCCD4D52341000000C0192D5A41CDCCCCCCB5D52341666666A6032D5A4100000000A5D523419A999919F82C5A41333333337ED523419A999939DD2C5A41333333335ED52341000000E0C52C5A416666666645D52341000000C0B32C5A4133333333D9D4234100000060B42C5A419A999999B0D423419A999999B42C5A419A99999982D42341000000C0B42C5A4166666666E6D32341CDCCCC2CB52C5A41CDCCCCCCE4D3234133333333B52C5A4133333333C5D32341CDCCCC4CB52C5A41	01060000206A080000010000000103000000010000001300000033333333C5D32341CDCCCC4CB52C5A419A999999E7D32341666666A6E52C5A41333333333AD42341333333F3602D5A419A999999F5D32341CDCCCCAC622D5A419A999999E1D3234133333313652D5A41CDCCCCCCF1D32341CDCCCC0C7A2D5A41CDCCCCCC19D4234100000040B42D5A419A9999993AD5234133333313B12D5A41CDCCCCCCDAD52341CDCCCCECAE2D5A4166666666DBD52341000000C0A62D5A419A99999900D623419A9999B9A12D5A4100000000BBD523419A9999B96F2D5A41000000008DD5234166666606552D5A419A9999992AD5234100000060212D5A41CDCCCCCCD4D52341000000C0192D5A41333333337ED523419A999939DD2C5A416666666645D52341000000C0B32C5A4133333333C5D32341CDCCCC4CB52C5A4133333333C5D32341CDCCCC4CB52C5A41	01010000206A080000A3CEF38DBCD423419A9999C9392D5A41	751072602	H	Invalides 2	7510726	75107	75	11	0
01060000206A08000001000000010300000001000000240000000000000035D12341000000404E2D5A416666666641D12341333333D3632D5A416666666655D12341000000E0972D5A413333333369D1234166666646B92D5A41666666667ED1234133333393DC2D5A419A99999983D123419A9999F9E12D5A410000000084D123419A999979E62D5A416666666684D1234166666666E92D5A413333333384D123419A9999B9EA2D5A416666666691D123419A999959EB2D5A419A9999999ED1234100000080EB2D5A4100000000AAD1234166666666EB2D5A4166666666B5D12341CDCCCC8CEA2D5A4166666666C8D12341666666A6EA2D5A4166666666ECD1234100000020EB2D5A416666666638D22341666666C6EA2D5A413333333339D223419A999999E72D5A410000000038D22341CDCCCCACE32D5A410000000036D2234133333333DD2D5A410000000033D2234166666626D62D5A41666666662FD2234166666606CE2D5A419A9999992CD2234166666686CA2D5A413333333322D2234100000040BD2D5A419A9999991ED22341CDCCCC0CB92D5A41333333331CD2234133333333B52D5A416666666614D2234166666666A92D5A41666666660CD22341666666069D2D5A413333333309D2234133333333982D5A419A99999903D22341666666C68F2D5A41CDCCCCCCFCD123419A999919852D5A4166666666ECD12341CDCCCC0C712D5A4133333333E9D12341666666066D2D5A4166666666E2D123419A9999D9642D5A419A99999958D12341CDCCCC8C522D5A416666666645D123419A999939502D5A410000000035D12341000000404E2D5A41	01060000206A080000010000000103000000010000000C0000000000000035D12341000000404E2D5A416666666641D12341333333D3632D5A416666666655D12341000000E0972D5A41666666667ED1234133333393DC2D5A413333333384D123419A9999B9EA2D5A416666666638D22341666666C6EA2D5A41666666662FD2234166666606CE2D5A419A9999991ED22341CDCCCC0CB92D5A41CDCCCCCCFCD123419A999919852D5A4166666666E2D123419A9999D9642D5A410000000035D12341000000404E2D5A410000000035D12341000000404E2D5A41	01010000206A080000CB7852E9B0D12341CCCCCC9C9A2D5A41	751072603	H	Invalides 3	7510726	75107	75	11	0
01060000206A080000010000000103000000010000002200000000000000D5D5234100000040832D5A41CDCCCCCCECD5234166666626932D5A419A99999900D623419A9999B9A12D5A4100000000F2D52341666666A6A22D5A419A999999E8D52341CDCCCC6CA32D5A4100000000E2D52341000000C0A42D5A4166666666DBD52341000000C0A62D5A4100000000D9D523419A9999D9A82D5A41CDCCCCCCDAD52341CDCCCCECAE2D5A41000000004FD623419A9999D9AC2D5A413333333368D6234133333373B42D5A41000000009FD62341333333D3C42D5A41CDCCCCCCCED6234166666646D32D5A4100000000C3D623419A9999B9D52D5A413333333397D62341666666C6DC2D5A416666666673D6234100000040E02D5A410000000087D62341CDCCCCCCDF2D5A4166666666A4D62341CDCCCC2CDF2D5A419A999999B1D62341000000A0DE2D5A4100000000EAD623419A999999DB2D5A410000000007D723419A999919DA2D5A410000000053D7234166666666D52D5A41000000001FD9234133333373BA2D5A416666666663D9234100000000B72D5A413333333376D92341CDCCCC0CB62D5A416666666607DA23419A999979AD2D5A41333333339CD92341CDCCCCAC982D5A410000000026D92341CDCCCC8C812D5A4166666666C1D82341333333736E2D5A413333333391D8234133333373642D5A41000000005BD823419A9999995A2D5A419A999999DBD6234133333373722D5A410000000080D62341CDCCCC8C782D5A4100000000D5D5234100000040832D5A41	01060000206A080000010000000103000000010000001200000000000000D5D5234100000040832D5A419A99999900D623419A9999B9A12D5A4166666666DBD52341000000C0A62D5A41CDCCCCCCDAD52341CDCCCCECAE2D5A41000000004FD623419A9999D9AC2D5A41CDCCCCCCCED6234166666646D32D5A413333333397D62341666666C6DC2D5A416666666673D6234100000040E02D5A4166666666A4D62341CDCCCC2CDF2D5A410000000053D7234166666666D52D5A41000000001FD9234133333373BA2D5A413333333376D92341CDCCCC0CB62D5A416666666607DA23419A999979AD2D5A410000000026D92341CDCCCC8C812D5A41000000005BD823419A9999995A2D5A419A999999DBD6234133333373722D5A4100000000D5D5234100000040832D5A4100000000D5D5234100000040832D5A41	01010000206A0800004682ABFCD6D72341343333339D2D5A41	751072604	H	Invalides 4	7510726	75107	75	11	0
01060000206A080000010000000103000000010000001A000000CDCCCCCC19D4234100000040B42D5A41CDCCCCCC1BD42341CDCCCC4CB72D5A410000000022D4234166666626C02D5A41CDCCCCCC24D4234166666646C42D5A41000000002DD4234100000080D12D5A419A99999932D4234166666646DA2D5A41333333333FD4234133333373E92D5A416666666613D5234100000060E92D5A4133333333C5D5234133333313E92D5A4166666666DCD5234100000080E82D5A41CDCCCCCC1CD6234100000060E52D5A410000000031D6234133333313E42D5A41CDCCCCCC50D62341CDCCCC0CE22D5A416666666673D6234100000040E02D5A413333333397D62341666666C6DC2D5A4100000000C3D623419A9999B9D52D5A41CDCCCCCCCED6234166666646D32D5A41000000009FD62341333333D3C42D5A413333333368D6234133333373B42D5A41000000004FD623419A9999D9AC2D5A41CDCCCCCCDAD52341CDCCCCECAE2D5A41CDCCCCCC48D52341000000E0B02D5A419A9999993AD5234133333313B12D5A4133333333F1D42341000000E0B12D5A4100000000EFD42341666666E6B12D5A41CDCCCCCC19D4234100000040B42D5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCC19D4234100000040B42D5A419A99999932D4234166666646DA2D5A41333333333FD4234133333373E92D5A4133333333C5D5234133333313E92D5A41CDCCCCCC1CD6234100000060E52D5A416666666673D6234100000040E02D5A413333333397D62341666666C6DC2D5A41CDCCCCCCCED6234166666646D32D5A41000000004FD623419A9999D9AC2D5A419A9999993AD5234133333313B12D5A41CDCCCCCC19D4234100000040B42D5A41CDCCCCCC19D4234100000040B42D5A41	01010000206A0800009FF570846ED523419A999929CB2D5A41	751072605	A	Invalides 5	7510726	75107	75	11	0
01060000206A080000010000000103000000010000004D00000000000000F0D0234100000000F22C5A4100000000F1D02341666666E6F32C5A41CDCCCCCCF2D02341CDCCCC4CF62C5A41CDCCCCCC04D12341000000000E2D5A410000000019D12341666666662A2D5A41CDCCCCCC1FD1234166666606342D5A419A99999925D12341666666263C2D5A416666666628D12341666666663F2D5A416666666631D12341CDCCCCEC492D5A410000000033D12341CDCCCC0C4C2D5A41CDCCCCCC33D12341666666C64C2D5A410000000035D12341000000404E2D5A416666666645D123419A999939502D5A419A99999958D12341CDCCCC8C522D5A4166666666E2D123419A9999D9642D5A4133333333E9D12341666666066D2D5A4166666666ECD12341CDCCCC0C712D5A41CDCCCCCCFCD123419A999919852D5A419A99999903D22341666666C68F2D5A413333333309D2234133333333982D5A41666666660CD22341666666069D2D5A416666666614D2234166666666A92D5A41333333331CD2234133333333B52D5A419A9999991ED22341CDCCCC0CB92D5A413333333322D2234100000040BD2D5A419A9999992CD2234166666686CA2D5A41666666662FD2234166666606CE2D5A410000000033D2234166666626D62D5A410000000036D2234133333333DD2D5A410000000038D22341CDCCCCACE32D5A413333333339D223419A999999E72D5A419A9999994AD2234133333313E82D5A41CDCCCCCC72D2234166666666E82D5A4166666666F7D2234100000080E82D5A41000000003FD323419A999959E82D5A4100000000A7D32341000000A0E82D5A41CDCCCCCCFED3234100000040E92D5A41333333333FD4234133333373E92D5A419A99999932D4234166666646DA2D5A41000000002DD4234100000080D12D5A41CDCCCCCC24D4234166666646C42D5A410000000022D4234166666626C02D5A41CDCCCCCC1BD42341CDCCCC4CB72D5A41CDCCCCCC19D4234100000040B42D5A419A99999906D4234100000000982D5A413333333303D4234133333313932D5A419A99999900D42341333333538F2D5A41CDCCCCCCF8D323419A999959842D5A4166666666F6D323419A9999B9802D5A41CDCCCCCCF1D32341CDCCCC0C7A2D5A4100000000E8D32341CDCCCCEC6F2D5A41CDCCCCCCE3D32341000000E06B2D5A419A999999E1D3234133333313652D5A4100000000F5D32341000000C0622D5A419A999999F5D32341CDCCCCAC622D5A410000000013D42341CDCCCCEC612D5A419A9999991CD42341333333B3612D5A41333333333AD42341333333F3602D5A41CDCCCCCC35D423419A9999795C2D5A419A99999928D4234100000060472D5A416666666627D42341000000A0452D5A419A99999918D42341333333F32D2D5A41CDCCCCCCFCD3234100000020052D5A419A999999EAD3234100000000EA2C5A4100000000D6D32341CDCCCC2CEA2C5A41CDCCCCCCB6D3234100000080EA2C5A416666666637D32341666666C6EB2C5A416666666620D323419A9999F9EB2C5A419A999999E1D2234166666686EC2C5A41CDCCCCCCBCD22341CDCCCC0CED2C5A41CDCCCCCC94D223419A999979ED2C5A41666666667AD22341333333B3ED2C5A410000000049D2234100000040EE2C5A41CDCCCCCC04D2234166666606EF2C5A4100000000EFD1234100000040EF2C5A41CDCCCCCC61D12341CDCCCCECF02C5A4100000000F0D0234100000000F22C5A41	01060000206A080000010000000103000000010000001300000000000000F0D0234100000000F22C5A419A99999925D12341666666263C2D5A410000000035D12341000000404E2D5A4166666666E2D123419A9999D9642D5A41CDCCCCCCFCD123419A999919852D5A419A9999991ED22341CDCCCC0CB92D5A41666666662FD2234166666606CE2D5A413333333339D223419A999999E72D5A41CDCCCCCC72D2234166666666E82D5A41000000003FD323419A999959E82D5A41333333333FD4234133333373E92D5A41CDCCCCCCF1D32341CDCCCC0C7A2D5A419A999999E1D3234133333313652D5A419A999999F5D32341CDCCCCAC622D5A41333333333AD42341333333F3602D5A419A999999EAD3234100000000EA2C5A419A999999E1D2234166666686EC2C5A4100000000F0D0234100000000F22C5A4100000000F0D0234100000000F22C5A41	01010000206A080000FAD6C10EE4D223419A999979682D5A41	751072606	D	Invalides 6	7510726	75107	75	11	0
01060000206A08000001000000010300000001000000310000006666666680D1234100000020FE2D5A41CDCCCCCCA3D2234100000060FE2D5A416666666626D32341333333F3FE2D5A41333333334FD3234166666626FF2D5A419A99999978D3234133333353FF2D5A419A99999966D4234100000060002E5A419A99999940D6234100000000002E5A41CDCCCCCCCBD6234133333393F72D5A41333333338AD7234133333313EC2D5A410000000022D82341CDCCCCECE22D5A419A999999FCD923419A999939C62D5A419A99999960DA2341CDCCCC2CC02D5A419A99999966DA2341CDCCCC0CBF2D5A41333333331FDA23419A9999B9B12D5A413333333312DA23419A9999B9AF2D5A416666666607DA23419A999979AD2D5A413333333376D92341CDCCCC0CB62D5A416666666663D9234100000000B72D5A41000000001FD9234133333373BA2D5A410000000053D7234166666666D52D5A410000000007D723419A999919DA2D5A4100000000EAD623419A999999DB2D5A419A999999B1D62341000000A0DE2D5A4166666666A4D62341CDCCCC2CDF2D5A410000000087D62341CDCCCCCCDF2D5A416666666673D6234100000040E02D5A41CDCCCCCC50D62341CDCCCC0CE22D5A410000000031D6234133333313E42D5A41CDCCCCCC1CD6234100000060E52D5A4166666666DCD5234100000080E82D5A4133333333C5D5234133333313E92D5A416666666613D5234100000060E92D5A41333333333FD4234133333373E92D5A41CDCCCCCCFED3234100000040E92D5A4100000000A7D32341000000A0E82D5A41000000003FD323419A999959E82D5A4166666666F7D2234100000080E82D5A41CDCCCCCC72D2234166666666E82D5A419A9999994AD2234133333313E82D5A413333333339D223419A999999E72D5A416666666638D22341666666C6EA2D5A4166666666ECD1234100000020EB2D5A4166666666C8D12341666666A6EA2D5A4166666666B5D12341CDCCCC8CEA2D5A4100000000AAD1234166666666EB2D5A419A9999999ED1234100000080EB2D5A416666666691D123419A999959EB2D5A413333333384D123419A9999B9EA2D5A416666666680D1234100000020FE2D5A41	01060000206A08000001000000010300000001000000310000006666666680D1234100000020FE2D5A41CDCCCCCCA3D2234100000060FE2D5A416666666626D32341333333F3FE2D5A41333333334FD3234166666626FF2D5A419A99999978D3234133333353FF2D5A419A99999966D4234100000060002E5A419A99999940D6234100000000002E5A41CDCCCCCCCBD6234133333393F72D5A41333333338AD7234133333313EC2D5A410000000022D82341CDCCCCECE22D5A419A999999FCD923419A999939C62D5A419A99999960DA2341CDCCCC2CC02D5A419A99999966DA2341CDCCCC0CBF2D5A41333333331FDA23419A9999B9B12D5A413333333312DA23419A9999B9AF2D5A416666666607DA23419A999979AD2D5A413333333376D92341CDCCCC0CB62D5A416666666663D9234100000000B72D5A41000000001FD9234133333373BA2D5A410000000053D7234166666666D52D5A410000000007D723419A999919DA2D5A4100000000EAD623419A999999DB2D5A419A999999B1D62341000000A0DE2D5A4166666666A4D62341CDCCCC2CDF2D5A410000000087D62341CDCCCCCCDF2D5A416666666673D6234100000040E02D5A41CDCCCCCC50D62341CDCCCC0CE22D5A410000000031D6234133333313E42D5A41CDCCCCCC1CD6234100000060E52D5A4166666666DCD5234100000080E82D5A4133333333C5D5234133333313E92D5A416666666613D5234100000060E92D5A41333333333FD4234133333373E92D5A41CDCCCCCCFED3234100000040E92D5A4100000000A7D32341000000A0E82D5A41000000003FD323419A999959E82D5A4166666666F7D2234100000080E82D5A41CDCCCCCC72D2234166666666E82D5A419A9999994AD2234133333313E82D5A413333333339D223419A999999E72D5A416666666638D22341666666C6EA2D5A4166666666ECD1234100000020EB2D5A4166666666C8D12341666666A6EA2D5A4166666666B5D12341CDCCCC8CEA2D5A4100000000AAD1234166666666EB2D5A419A9999999ED1234100000080EB2D5A416666666691D123419A999959EB2D5A413333333384D123419A9999B9EA2D5A416666666680D1234100000020FE2D5A41	01010000206A0800006284EEE503D82341000000C0D72D5A41	751072699	D	Seine et Berges 2	7510726	75107	75	11	0
01060000206A080000010000000103000000010000001B000000CDCCCCCC1CD4234166666686732C5A41333333333AD42341CDCCCC0C752C5A41CDCCCCCC3CD42341CDCCCC2C752C5A419A99999942D4234100000080752C5A4166666666FED42341000000807F2C5A41CDCCCCCC1ED5234100000020812C5A419A99999999D5234100000040872C5A419A99999913D62341000000C08C2C5A419A999999A9D62341333333F3902C5A4166666666DED623419A9999797A2C5A419A999999FAD62341333333136F2C5A41CDCCCCCC36D7234133333373562C5A410000000001D723419A999939512C5A4100000000C0D623419A9999394B2C5A4100000000A1D6234166666666482C5A41333333338FD62341000000E0462C5A41666666665ED6234100000060432C5A419A999999DBD52341CDCCCC2C3A2C5A419A99999945D52341000000E02F2C5A419A99999921D52341000000802D2C5A41CDCCCCCCFFD42341666666A62B2C5A41CDCCCCCCEDD42341666666A62E2C5A4166666666D9D4234166666606332C5A41CDCCCCCCB8D42341666666863B2C5A410000000094D423419A999959492C5A410000000077D423419A999919532C5A41CDCCCCCC1CD4234166666686732C5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC1CD4234166666686732C5A4166666666FED42341000000807F2C5A419A99999913D62341000000C08C2C5A419A999999A9D62341333333F3902C5A41CDCCCCCC36D7234133333373562C5A41333333338FD62341000000E0462C5A419A99999945D52341000000E02F2C5A41CDCCCCCCFFD42341666666A62B2C5A41CDCCCCCCB8D42341666666863B2C5A41CDCCCCCC1CD4234166666686732C5A41CDCCCCCC1CD4234166666686732C5A41	01010000206A0800005E96A310B2D52341333333C3622C5A41	751072701	H	École Militaire 1	7510727	75107	75	11	0
01060000206A080000010000000103000000010000002900000033333333DDD123419A9999793E2C5A419A999999F0D12341CDCCCCCC3F2C5A413333333315D2234100000040412C5A413333333322D2234133333373412C5A41CDCCCCCC37D2234166666606622C5A410000000054D2234166666606902C5A416666666671D223419A9999798C2C5A419A99999986D22341000000208B2C5A41666666668BD22341CDCCCC8C8A2C5A416666666696D22341CDCCCC2C892C5A41CDCCCCCCBCD2234133333353842C5A4100000000E8D22341CDCCCCEC7E2C5A4166666666F0D22341000000A07D2C5A41CDCCCCCC45D323419A999919732C5A419A9999995ED323419A9999F96A2C5A41666666666FD32341333333936C2C5A413333333397D32341666666E66D2C5A41CDCCCCCCBCD32341333333336F2C5A419A999999F7D32341333333D3712C5A416666666600D423419A999939722C5A41CDCCCCCC1CD4234166666686732C5A410000000077D423419A999919532C5A410000000094D423419A999959492C5A41CDCCCCCCB8D42341666666863B2C5A4166666666D9D4234166666606332C5A41CDCCCCCCEDD42341666666A62E2C5A41CDCCCCCCFFD42341666666A62B2C5A41CDCCCCCCCED4234133333313292C5A419A99999938D42341000000C0202C5A419A99999994D3234166666626172C5A41666666666DD32341333333F3142C5A419A99999960D3234100000040142C5A413333333346D32341CDCCCC8C122C5A41CDCCCCCC35D3234133333393142C5A41000000005AD22341CDCCCC4C2F2C5A416666666648D22341CDCCCC6C312C5A41333333333AD2234166666626332C5A41CDCCCCCCEED12341333333533C2C5A4166666666EDD12341666666863C2C5A4100000000DED12341000000603E2C5A4133333333DDD123419A9999793E2C5A41	01060000206A080000010000000103000000010000000D00000033333333DDD123419A9999793E2C5A413333333322D2234133333373412C5A410000000054D2234166666606902C5A419A99999986D22341000000208B2C5A41CDCCCCCC45D323419A999919732C5A419A9999995ED323419A9999F96A2C5A41CDCCCCCC1CD4234166666686732C5A41CDCCCCCCB8D42341666666863B2C5A41CDCCCCCCFFD42341666666A62B2C5A419A99999938D42341000000C0202C5A413333333346D32341CDCCCC8C122C5A4133333333DDD123419A9999793E2C5A4133333333DDD123419A9999793E2C5A41	01010000206A0800007C7CE01558D323419A9999394E2C5A41	751072702	H	École Militaire 2	7510727	75107	75	11	0
01060000206A0800000100000001030000000100000010000000CDCCCCCCE3CE2341000000604C2C5A41CDCCCCCCF6CE2341CDCCCC2C502C5A4133333333C8CF2341666666C6762C5A4133333333ECCF234166666686772C5A416666666606D023419A999959742C5A41CDCCCCCC91D0234166666606632C5A416666666658D12341666666664A2C5A41CDCCCCCC4DD12341CDCCCCEC492C5A41CDCCCCCCE5D023419A999999452C5A419A99999977D02341CDCCCCCC402C5A413333333322D023419A9999D93C2C5A41CDCCCCCCA2CF2341666666A6342C5A410000000014CF234166666666462C5A419A99999906CF234100000000482C5A4133333333F4CE2341666666464A2C5A41CDCCCCCCE3CE2341000000604C2C5A41	01060000206A0800000100000001030000000100000008000000CDCCCCCCE3CE2341000000604C2C5A4133333333C8CF2341666666C6762C5A4133333333ECCF234166666686772C5A416666666658D12341666666664A2C5A413333333322D023419A9999D93C2C5A41CDCCCCCCA2CF2341666666A6342C5A41CDCCCCCCE3CE2341000000604C2C5A41CDCCCCCCE3CE2341000000604C2C5A41	01010000206A080000F3F8F2DE03D023419A999999592C5A41	751072703	H	École Militaire 3	7510727	75107	75	11	0
01060000206A080000010000000103000000010000001F00000033333333ECCF234166666686772C5A41CDCCCCCCFDCF2341000000C07A2C5A41000000000FD02341000000E07D2C5A41CDCCCCCCADD02341666666C69A2C5A419A999999DAD023419A999939A32C5A419A999999F5D0234133333353A82C5A413333333319D12341000000E0AE2C5A41666666662BD12341CDCCCC0CB22C5A419A99999939D1234100000080B42C5A410000000055D123419A9999D9B02C5A41CDCCCCCC5BD1234166666606B02C5A410000000083D12341CDCCCC6CAB2C5A410000000096D12341CDCCCC4CAD2C5A413333333322D223419A999939AF2C5A419A9999992ED2234166666666AF2C5A419A99999941D223419A9999B9AF2C5A41000000006AD2234166666666B02C5A41CDCCCCCC5BD22341CDCCCC2C982C5A41CDCCCCCC57D2234100000020952C5A410000000054D2234166666606902C5A41CDCCCCCC37D2234166666606622C5A413333333322D2234133333373412C5A413333333315D2234100000040412C5A419A999999F0D12341CDCCCCCC3F2C5A4133333333DDD123419A9999793E2C5A4166666666D1D12341CDCCCCEC3F2C5A416666666671D12341333333934B2C5A416666666658D12341666666664A2C5A41CDCCCCCC91D0234166666606632C5A416666666606D023419A999959742C5A4133333333ECCF234166666686772C5A41	01060000206A080000010000000103000000010000000C00000033333333ECCF234166666686772C5A419A99999939D1234100000080B42C5A410000000083D12341CDCCCC6CAB2C5A410000000096D12341CDCCCC4CAD2C5A41000000006AD2234166666666B02C5A410000000054D2234166666606902C5A413333333322D2234133333373412C5A4133333333DDD123419A9999793E2C5A416666666671D12341333333934B2C5A416666666658D12341666666664A2C5A4133333333ECCF234166666686772C5A4133333333ECCF234166666686772C5A41	01010000206A0800009C1F077C1DD1234133333323792C5A41	751072704	H	École Militaire 4	7510727	75107	75	11	0
01060000206A08000001000000010300000001000000340000000000000025CF23419A999979F62C5A419A99999972CF23419A9999F9F52C5A41CDCCCCCC82CF2341666666E6F52C5A419A9999999BCF2341000000A0F52C5A410000000000D02341CDCCCC8CF42C5A419A9999995ED02341CDCCCCACF32C5A419A999999C9D02341000000A0F22C5A4100000000F0D0234100000000F22C5A41CDCCCCCC61D12341CDCCCCECF02C5A4100000000EFD1234100000040EF2C5A41CDCCCCCC04D2234166666606EF2C5A410000000049D2234100000040EE2C5A41666666667AD22341333333B3ED2C5A41CDCCCCCC94D223419A999979ED2C5A41CDCCCCCCBCD22341CDCCCC0CED2C5A419A999999E1D2234166666686EC2C5A416666666620D323419A9999F9EB2C5A416666666637D32341666666C6EB2C5A41CDCCCCCCB6D3234100000080EA2C5A4100000000D6D32341CDCCCC2CEA2C5A419A999999EAD3234100000000EA2C5A41CDCCCCCCE8D323419A999979E72C5A419A999999E7D32341666666A6E52C5A41CDCCCCCCC7D323419A9999D9B82C5A4133333333C5D32341CDCCCC4CB52C5A41000000008ED323419A9999F9B42C5A413333333366D32341000000C0B42C5A41CDCCCCCC43D3234100000020B42C5A41333333333FD32341CDCCCC0CB42C5A4166666666B1D2234133333393B12C5A41666666669FD2234166666646B12C5A413333333390D2234166666606B12C5A41000000006AD2234166666666B02C5A419A99999941D223419A9999B9AF2C5A419A9999992ED2234166666666AF2C5A413333333322D223419A999939AF2C5A410000000096D12341CDCCCC4CAD2C5A410000000083D12341CDCCCC6CAB2C5A41CDCCCCCC5BD1234166666606B02C5A410000000055D123419A9999D9B02C5A419A99999939D1234100000080B42C5A41666666661FD12341CDCCCC8CB72C5A413333333315D12341000000C0B82C5A4166666666E0D0234166666646BF2C5A41333333337CD0234133333393CB2C5A41CDCCCCCC68D0234100000000CE2C5A410000000061D023419A9999F9CE2C5A41CDCCCCCC46D02341CDCCCC4CD22C5A419A9999992ED023419A999959D52C5A416666666693CF2341000000C0E82C5A419A9999995BCF2341666666A6EF2C5A410000000025CF23419A999979F62C5A41	01060000206A080000010000000103000000010000000D0000000000000025CF23419A999979F62C5A41CDCCCCCC82CF2341666666E6F52C5A419A999999C9D02341000000A0F22C5A419A999999E1D2234166666686EC2C5A419A999999EAD3234100000000EA2C5A4133333333C5D32341CDCCCC4CB52C5A413333333366D32341000000C0B42C5A419A9999992ED2234166666666AF2C5A410000000096D12341CDCCCC4CAD2C5A410000000083D12341CDCCCC6CAB2C5A41333333337CD0234133333393CB2C5A410000000025CF23419A999979F62C5A410000000025CF23419A999979F62C5A41	01010000206A080000D341DD4A16D22341343333A3D02C5A41	751072705	H	École Militaire 5	7510727	75107	75	11	0
01060000206A080000010000000103000000010000002E0000000000000054D2234166666606902C5A41CDCCCCCC57D2234100000020952C5A41CDCCCCCC5BD22341CDCCCC2C982C5A41000000006AD2234166666666B02C5A413333333390D2234166666606B12C5A41666666669FD2234166666646B12C5A4166666666B1D2234133333393B12C5A41333333333FD32341CDCCCC0CB42C5A41CDCCCCCC43D3234100000020B42C5A413333333366D32341000000C0B42C5A41000000008ED323419A9999F9B42C5A4133333333C5D32341CDCCCC4CB52C5A41CDCCCCCCE4D3234133333333B52C5A4166666666E6D32341CDCCCC2CB52C5A419A99999982D42341000000C0B42C5A419A999999B0D423419A999999B42C5A4133333333D9D4234100000060B42C5A416666666645D52341000000C0B32C5A419A9999998ED5234133333333B32C5A4166666666E5D5234100000080B22C5A41CDCCCCCC5BD6234133333393B12C5A4133333333A3D62341666666C6942C5A419A999999A9D62341333333F3902C5A419A99999913D62341000000C08C2C5A419A99999999D5234100000040872C5A41CDCCCCCC1ED5234100000020812C5A4166666666FED42341000000807F2C5A419A99999942D4234100000080752C5A41CDCCCCCC3CD42341CDCCCC2C752C5A41333333333AD42341CDCCCC0C752C5A41CDCCCCCC1CD4234166666686732C5A416666666600D423419A999939722C5A419A999999F7D32341333333D3712C5A41CDCCCCCCBCD32341333333336F2C5A413333333397D32341666666E66D2C5A41666666666FD32341333333936C2C5A419A9999995ED323419A9999F96A2C5A41CDCCCCCC45D323419A999919732C5A4166666666F0D22341000000A07D2C5A4100000000E8D22341CDCCCCEC7E2C5A41CDCCCCCCBCD2234133333353842C5A416666666696D22341CDCCCC2C892C5A41666666668BD22341CDCCCC8C8A2C5A419A99999986D22341000000208B2C5A416666666671D223419A9999798C2C5A410000000054D2234166666606902C5A41	01060000206A080000010000000103000000010000000F0000000000000054D2234166666606902C5A41000000006AD2234166666666B02C5A413333333366D32341000000C0B42C5A4133333333C5D32341CDCCCC4CB52C5A419A999999B0D423419A999999B42C5A41CDCCCCCC5BD6234133333393B12C5A419A999999A9D62341333333F3902C5A419A99999913D62341000000C08C2C5A4166666666FED42341000000807F2C5A41CDCCCCCC1CD4234166666686732C5A419A9999995ED323419A9999F96A2C5A41CDCCCCCC45D323419A999919732C5A419A99999986D22341000000208B2C5A410000000054D2234166666606902C5A410000000054D2234166666606902C5A41	01010000206A0800004CC49FB676D42341CCCCCC7C902C5A41	751072706	H	École Militaire 6	7510727	75107	75	11	0
01060000206A080000010000000103000000010000003100000033333333F9CB234133333313A62C5A416666666613CC234100000080A92C5A41CDCCCCCC4ECC2341CDCCCC4CB12C5A413333333398CC2341666666E6BA2C5A4133333333B6CC2341333333B3BE2C5A4100000000BBCC234133333353BF2C5A4166666666D7CC2341CDCCCCECC22C5A4166666666DCCC234133333393C32C5A4100000000ADCD2341333333F3DD2C5A4100000000B7CD234133333333DF2C5A41CDCCCCCCD1CD234133333393E22C5A4100000000D8CD234100000060E32C5A419A999999EECD23419A999939E62C5A41CDCCCCCC24CE2341CDCCCCECEC2C5A41CDCCCCCC37CE2341CDCCCC4CEF2C5A413333333388CE234133333353F92C5A410000000099CE234166666666FB2C5A410000000025CF23419A999979F62C5A419A9999995BCF2341666666A6EF2C5A416666666693CF2341000000C0E82C5A419A9999992ED023419A999959D52C5A41CDCCCCCC46D02341CDCCCC4CD22C5A410000000061D023419A9999F9CE2C5A41CDCCCCCC68D0234100000000CE2C5A41333333337CD0234133333393CB2C5A4166666666E0D0234166666646BF2C5A413333333315D12341000000C0B82C5A41666666661FD12341CDCCCC8CB72C5A419A99999939D1234100000080B42C5A41666666662BD12341CDCCCC0CB22C5A413333333319D12341000000E0AE2C5A419A999999F5D0234133333353A82C5A419A999999DAD023419A999939A32C5A41CDCCCCCCADD02341666666C69A2C5A41000000000FD02341000000E07D2C5A41CDCCCCCCFDCF2341000000C07A2C5A4133333333ECCF234166666686772C5A4133333333C8CF2341666666C6762C5A41CDCCCCCCF6CE2341CDCCCC2C502C5A41CDCCCCCCE3CE2341000000604C2C5A419A999999D7CE23419A9999F94D2C5A41CDCCCCCCC9CE23419A9999994F2C5A41CDCCCCCC0BCE234166666606672C5A4133333333B7CD23419A999979712C5A41666666669CCD2341000000E0742C5A413333333389CD2341CDCCCC2C772C5A4100000000A1CC2341000000C0932C5A416666666627CC23419A9999D9A22C5A4133333333F9CB234133333313A62C5A41	01060000206A080000010000000103000000010000000D00000033333333F9CB234133333313A62C5A413333333398CC2341666666E6BA2C5A419A999999EECD23419A999939E62C5A410000000099CE234166666666FB2C5A410000000025CF23419A999979F62C5A41333333337CD0234133333393CB2C5A419A99999939D1234100000080B42C5A4133333333ECCF234166666686772C5A4133333333C8CF2341666666C6762C5A41CDCCCCCCE3CE2341000000604C2C5A416666666627CC23419A9999D9A22C5A4133333333F9CB234133333313A62C5A4133333333F9CB234133333313A62C5A41	01010000206A080000997908E177CE2341666666A6A42C5A41	751072707	A	École Militaire 7	7510727	75107	75	11	0
01060000206A080000010000000103000000010000001E0000000000000099CE234166666666FB2C5A4133333333CECE234100000060012D5A419A999999DACE23419A999959022D5A4100000000E2CE234166666626032D5A410000000093CF234166666626192D5A419A999999DDCF23419A999999222D5A413333333318D02341CDCCCC0C2A2D5A41CDCCCCCC23D02341666666862B2D5A4133333333AAD023419A9999993C2D5A419A999999EAD02341666666C6442D5A410000000035D12341000000404E2D5A41CDCCCCCC33D12341666666C64C2D5A410000000033D12341CDCCCC0C4C2D5A416666666631D12341CDCCCCEC492D5A416666666628D12341666666663F2D5A419A99999925D12341666666263C2D5A41CDCCCCCC1FD1234166666606342D5A410000000019D12341666666662A2D5A41CDCCCCCC04D12341000000000E2D5A41CDCCCCCCF2D02341CDCCCC4CF62C5A4100000000F1D02341666666E6F32C5A4100000000F0D0234100000000F22C5A419A999999C9D02341000000A0F22C5A419A9999995ED02341CDCCCCACF32C5A410000000000D02341CDCCCC8CF42C5A419A9999999BCF2341000000A0F52C5A41CDCCCCCC82CF2341666666E6F52C5A419A99999972CF23419A9999F9F52C5A410000000025CF23419A999979F62C5A410000000099CE234166666666FB2C5A41	01060000206A080000010000000103000000010000000A0000000000000099CE234166666666FB2C5A4100000000E2CE234166666626032D5A410000000093CF234166666626192D5A410000000035D12341000000404E2D5A419A99999925D12341666666263C2D5A4100000000F0D0234100000000F22C5A41CDCCCCCC82CF2341666666E6F52C5A410000000025CF23419A999979F62C5A410000000099CE234166666666FB2C5A410000000099CE234166666666FB2C5A41	01010000206A080000B084183264D02341000000E01D2D5A41	751072801	H	Gros Caillou 1	7510728	75107	75	11	0
01060000206A0800000100000001030000000100000013000000CDCCCCCCE7CE2341000000405A2D5A413333333340CF2341CDCCCCCC5D2D5A41CDCCCCCC5ACF2341000000005F2D5A41000000006DCF2341666666865F2D5A4166666666A9CF234166666626602D5A419A999999FACF2341666666C6602D5A41000000002AD02341CDCCCC2C612D5A41CDCCCCCC63D02341000000C0612D5A4166666666DDD02341666666E6622D5A416666666641D12341333333D3632D5A410000000035D12341000000404E2D5A419A999999EAD02341666666C6442D5A4133333333AAD023419A9999993C2D5A41CDCCCCCC23D02341666666862B2D5A413333333318D02341CDCCCC0C2A2D5A419A999999DDCF23419A999999222D5A41CDCCCCCC8ECF23419A9999993F2D5A416666666638CF2341CDCCCCAC3B2D5A41CDCCCCCCE7CE2341000000405A2D5A41	01060000206A0800000100000001030000000100000009000000CDCCCCCCE7CE2341000000405A2D5A41000000006DCF2341666666865F2D5A416666666641D12341333333D3632D5A410000000035D12341000000404E2D5A419A999999DDCF23419A999999222D5A41CDCCCCCC8ECF23419A9999993F2D5A416666666638CF2341CDCCCCAC3B2D5A41CDCCCCCCE7CE2341000000405A2D5A41CDCCCCCCE7CE2341000000405A2D5A41	01010000206A080000044B6DB9FECF234100000030422D5A41	751072802	H	Gros Caillou 2	7510728	75107	75	11	0
01060000206A080000010000000103000000010000001600000033333333F8CD2341333333534B2D5A41666666660ACE23419A9999794C2D5A41000000003ACE2341000000804F2D5A419A99999969CE234100000080522D5A41CDCCCCCC91CE2341CDCCCC0C552D5A41CDCCCCCCE7CE2341000000405A2D5A416666666638CF2341CDCCCCAC3B2D5A41CDCCCCCC8ECF23419A9999993F2D5A419A999999DDCF23419A999999222D5A410000000093CF234166666626192D5A4100000000E2CE234166666626032D5A419A999999DACE23419A999959022D5A4133333333CECE234100000060012D5A4166666666A7CE23419A999959052D5A41CDCCCCCCA2CE234166666606062D5A41666666669DCE234166666666072D5A419A99999981CE2341CDCCCCCC122D5A41CDCCCCCC68CE2341000000E01C2D5A413333333367CE2341CDCCCC8C1D2D5A419A99999956CE234100000060242D5A41CDCCCCCC37CE23419A999919312D5A4133333333F8CD2341333333534B2D5A41	01060000206A080000010000000103000000010000000A00000033333333F8CD2341333333534B2D5A41CDCCCCCCE7CE2341000000405A2D5A416666666638CF2341CDCCCCAC3B2D5A41CDCCCCCC8ECF23419A9999993F2D5A419A999999DDCF23419A999999222D5A4100000000E2CE234166666626032D5A4133333333CECE234100000060012D5A41666666669DCE234166666666072D5A4133333333F8CD2341333333534B2D5A4133333333F8CD2341333333534B2D5A41	01010000206A080000B8121F5807CF2341CDCCCCBC2A2D5A41	751072803	H	Gros Caillou 3	7510728	75107	75	11	0
01060000206A08000001000000010300000001000000210000000000000086CD2341CDCCCCAC792D5A416666666695CD2341333333937A2D5A41333333339ACD23419A9999D97A2D5A419A999999F4CD23419A999919802D5A41666666660ECE2341CDCCCC4C812D5A41333333336DCE2341CDCCCC0C852D5A41CDCCCCCC74CE23419A999959852D5A41333333331FCF2341333333138C2D5A41CDCCCCCC70CF2341666666E68E2D5A419A999999BACF23419A999999902D5A4166666666E5CF2341000000E0912D5A41CDCCCCCC01D02341666666A6922D5A41CDCCCCCC95D0234133333353952D5A41CDCCCCCC09D1234133333313972D5A410000000044D12341CDCCCCEC972D5A416666666655D12341000000E0972D5A416666666641D12341333333D3632D5A4166666666DDD02341666666E6622D5A41CDCCCCCC63D02341000000C0612D5A41000000002AD02341CDCCCC2C612D5A419A999999FACF2341666666C6602D5A4166666666A9CF234166666626602D5A41000000006DCF2341666666865F2D5A41CDCCCCCC5ACF2341000000005F2D5A413333333340CF2341CDCCCCCC5D2D5A41CDCCCCCCE7CE2341000000405A2D5A41CDCCCCCC91CE2341CDCCCC0C552D5A419A99999969CE234100000080522D5A41000000003ACE2341000000804F2D5A41666666660ACE23419A9999794C2D5A4133333333F8CD2341333333534B2D5A41CDCCCCCC8DCD23419A999979762D5A410000000086CD2341CDCCCCAC792D5A41	01060000206A080000010000000103000000010000000D0000000000000086CD2341CDCCCCAC792D5A41666666660ECE2341CDCCCC4C812D5A41333333331FCF2341333333138C2D5A41CDCCCCCC70CF2341666666E68E2D5A41CDCCCCCC01D02341666666A6922D5A41CDCCCCCC95D0234133333353952D5A416666666655D12341000000E0972D5A416666666641D12341333333D3632D5A41000000006DCF2341666666865F2D5A41CDCCCCCCE7CE2341000000405A2D5A4133333333F8CD2341333333534B2D5A410000000086CD2341CDCCCCAC792D5A410000000086CD2341CDCCCCAC792D5A41	01010000206A0800002A5C6FE374CF2341666666266D2D5A41	751072804	H	Gros Caillou 4	7510728	75107	75	11	0
01060000206A08000001000000010300000001000000220000009A99999999CB2341333333335A2D5A4166666666ADCB23419A9999B95B2D5A4166666666B3CB2341CDCCCC2C5C2D5A41CDCCCCCCD1CB2341333333735E2D5A410000000055CC23419A999959672D5A419A999999AACC2341000000206D2D5A41CDCCCCCCD0CC2341CDCCCCAC6F2D5A4133333333E0CC23419A9999B9702D5A4100000000FECC23419A9999B9722D5A419A99999931CD2341333333B3752D5A41CDCCCCCC72CD2341666666C6782D5A410000000086CD2341CDCCCCAC792D5A41CDCCCCCC8DCD23419A999979762D5A4133333333F8CD2341333333534B2D5A41CDCCCCCC37CE23419A999919312D5A419A99999956CE234100000060242D5A413333333367CE2341CDCCCC8C1D2D5A41CDCCCCCC68CE2341000000E01C2D5A419A99999981CE2341CDCCCCCC122D5A41666666669DCE234166666666072D5A41CDCCCCCCA2CE234166666606062D5A4166666666A7CE23419A999959052D5A4133333333CECE234100000060012D5A410000000099CE234166666666FB2C5A413333333376CE2341333333B3FF2C5A413333333372CE234166666626002D5A41000000005FCE23419A999979022D5A41000000005BCE2341333333F3022D5A4133333333A1CD2341CDCCCCCC192D5A410000000039CD2341000000A0262D5A4100000000E7CC2341333333B3302D5A41CDCCCCCC58CC2341CDCCCC6C422D5A4166666666AECB2341000000A0572D5A419A99999999CB2341333333335A2D5A41	01060000206A080000010000000103000000010000000B0000009A99999999CB2341333333335A2D5A41CDCCCCCCD1CB2341333333735E2D5A4100000000FECC23419A9999B9722D5A410000000086CD2341CDCCCCAC792D5A4133333333F8CD2341333333534B2D5A41666666669DCE234166666666072D5A4133333333CECE234100000060012D5A410000000099CE234166666666FB2C5A4100000000E7CC2341333333B3302D5A419A99999999CB2341333333335A2D5A419A99999999CB2341333333335A2D5A41	01010000206A080000D082328B60CD2341343333C3392D5A41	751072805	H	Gros Caillou 5	7510728	75107	75	11	0
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	01060000206A08000001000000010300000001000000140000003333333395C823419A9999D9A12D5A41CDCCCCCCEEC8234133333333AE2D5A41000000000ECA2341000000808A2D5A41CDCCCCCC34CA2341000000A0862D5A41CDCCCCCCB2CA234133333333762D5A41CDCCCCCC8BCB2341CDCCCCEC5B2D5A4100000000E7CC2341333333B3302D5A410000000099CE234166666666FB2C5A419A999999EECD23419A999939E62C5A419A99999993CD2341CDCCCCECF12C5A413333333346CC2341333333531B2D5A4100000000E3CB23419A999979282D5A41000000007FCB234166666686342D5A41CDCCCCCC12CB2341666666463F2D5A419A999999DCCA234100000080482D5A419A9999992FCA2341666666665D2D5A41666666666EC92341CDCCCC6C752D5A4133333333B4C92341666666A67E2D5A413333333395C823419A9999D9A12D5A413333333395C823419A9999D9A12D5A41	01010000206A080000A1D1AF6A7ACB2341CDCCCC7C492D5A41	751072806	H	Gros Caillou 6	7510728	75107	75	11	0
01060000206A0800000100000001030000000100000037000000000000005FC62341666666C6562D5A419A99999988C623419A9999395D2D5A4166666666ACC623419A999939622D5A4166666666B3C6234133333313632D5A4166666666B5C6234133333353632D5A4166666666BFC62341CDCCCCEC612D5A4133333333C6C62341333333D3602D5A41CDCCCCCCD2C62341333333935F2D5A419A99999930C72341CDCCCCCC532D5A416666666638C72341333333D3522D5A419A99999939C72341CDCCCCAC522D5A4133333333CDC7234166666626402D5A410000000009C823419A9999B9472D5A410000000015C82341CDCCCC4C492D5A413333333319C82341CDCCCCCC492D5A41CDCCCCCC4AC82341CDCCCC2C442D5A419A9999994DC82341333333D3432D5A4166666666B6C823419A999999362D5A4100000000BDC82341000000C0352D5A419A99999924C9234100000080282D5A419A9999993CC92341666666A6252D5A41000000008EC923419A9999F91B2D5A4100000000A0C92341000000C0192D5A4166666666B3C92341CDCCCC4C172D5A413333333316CA2341000000A00A2D5A41333333335BCA2341333333F3012D5A419A999999EBCA2341CDCCCCECEF2C5A413333333300CB23419A999959ED2C5A4100000000A1CB234133333353D92C5A419A9999993BCC2341000000C0C62C5A41CDCCCCCC63CC23419A999999C12C5A410000000085CC23419A999959BD2C5A413333333398CC2341666666E6BA2C5A41CDCCCCCC4ECC2341CDCCCC4CB12C5A416666666613CC234100000080A92C5A4133333333F9CB234133333313A62C5A4100000000D3CB2341CDCCCC2CAA2C5A4100000000CCCB2341333333F3AA2C5A4100000000C4CB2341CDCCCCECAB2C5A419A9999999BCB234100000000B12C5A41CDCCCCCC0ECB2341000000A0C22C5A4100000000FFCA23419A999979C42C5A416666666683CA23419A9999B9D32C5A413333333348CA234100000040DB2C5A41CDCCCCCCF6C9234100000020E52C5A4100000000BAC92341CDCCCCECEC2C5A41333333338BC92341333333B3F22C5A41666666660FC92341CDCCCC0C022D5A4166666666E5C823419A999919072D5A419A999999D4C8234100000020092D5A419A99999910C8234100000040212D5A41CDCCCCCC70C72341333333D3342D5A4133333333DEC62341CDCCCC4C472D5A413333333375C6234166666606542D5A41000000005FC62341666666C6562D5A41	01060000206A0800000100000001030000000100000011000000000000005FC62341666666C6562D5A4166666666B5C6234133333353632D5A4133333333CDC7234166666626402D5A413333333319C82341CDCCCCCC492D5A41CDCCCCCC4AC82341CDCCCC2C442D5A419A99999924C9234100000080282D5A41000000008EC923419A9999F91B2D5A41333333335BCA2341333333F3012D5A4100000000A1CB234133333353D92C5A419A9999993BCC2341000000C0C62C5A413333333398CC2341666666E6BA2C5A4133333333F9CB234133333313A62C5A4100000000C4CB2341CDCCCCECAB2C5A4100000000BAC92341CDCCCCECEC2C5A41CDCCCCCC70C72341333333D3342D5A41000000005FC62341666666C6562D5A41000000005FC62341666666C6562D5A41	01010000206A0800009EF44A5CA0C9234134333393042D5A41	751072807	H	Gros Caillou 7	7510728	75107	75	11	0
01060000206A080000010000000103000000010000001D000000CDCCCCCC34CA2341000000A0862D5A41CDCCCCCCF1CA2341333333738E2D5A419A999999E7CB234133333353972D5A4166666666EACB234100000040972D5A4166666666EDCB2341CDCCCC2C972D5A416666666602CC23419A999999962D5A4166666666FCCB23419A9999F9922D5A41CDCCCCCC0DCC234133333313922D5A41666666661CCC23419A999959912D5A419A99999933CC23419A999979912D5A419A9999993ECC234166666686912D5A416666666617CD2341333333B3952D5A41000000002BCD2341CDCCCC6C962D5A419A9999993ECD2341CDCCCC2C972D5A410000000086CD2341CDCCCCAC792D5A41CDCCCCCC72CD2341666666C6782D5A419A99999931CD2341333333B3752D5A4100000000FECC23419A9999B9722D5A4133333333E0CC23419A9999B9702D5A41CDCCCCCCD0CC2341CDCCCCAC6F2D5A419A999999AACC2341000000206D2D5A410000000055CC23419A999959672D5A41CDCCCCCCD1CB2341333333735E2D5A4166666666B3CB2341CDCCCC2C5C2D5A4166666666ADCB23419A9999B95B2D5A419A99999999CB2341333333335A2D5A41CDCCCCCC8BCB2341CDCCCCEC5B2D5A41CDCCCCCCB2CA234133333333762D5A41CDCCCCCC34CA2341000000A0862D5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC34CA2341000000A0862D5A41CDCCCCCCF1CA2341333333738E2D5A419A999999E7CB234133333353972D5A416666666602CC23419A999999962D5A4166666666FCCB23419A9999F9922D5A419A9999993ECC234166666686912D5A416666666617CD2341333333B3952D5A419A9999993ECD2341CDCCCC2C972D5A410000000086CD2341CDCCCCAC792D5A4100000000FECC23419A9999B9722D5A41CDCCCCCCD1CB2341333333735E2D5A419A99999999CB2341333333335A2D5A41CDCCCCCCB2CA234133333333762D5A41CDCCCCCC34CA2341000000A0862D5A41CDCCCCCC34CA2341000000A0862D5A41	01010000206A08000058EE483600CC2341CCCCCC7C772D5A41	751072808	H	Gros Caillou 8	7510728	75107	75	11	0
01060000206A0800000100000001030000000100000032000000CDCCCCCCEEC8234133333333AE2D5A41333333330FC9234133333333B22D5A41CDCCCCCC24C9234166666606B52D5A413333333340C92341CDCCCC0CB82D5A41000000005FC9234133333353BB2D5A41666666669AC92341CDCCCC2CC12D5A4100000000CCC9234166666666C52D5A419A999999F3C9234100000060C82D5A410000000024CA234166666626CB2D5A410000000028CA234166666666CB2D5A410000000058CA234166666686CE2D5A41666666666CCA2341666666A6CF2D5A419A9999996FCA2341333333D3CF2D5A41CDCCCCCCC3CA2341CDCCCC2CD42D5A41CDCCCCCCF3CA234133333333D62D5A41CDCCCCCC30CB234133333373D82D5A413333333365CB234100000020DA2D5A419A999999A3CB234133333393DB2D5A4100000000DECB2341CDCCCC8CDC2D5A41000000000CCC2341CDCCCC0CDD2D5A413333333329CC234133333393DD2D5A413333333374CC23419A999999DE2D5A4133333333A7CC234166666666DF2D5A41CDCCCCCCA7CC234166666686DB2D5A419A999999ABCC2341CDCCCCACD32D5A4166666666B3CC2341CDCCCC0CD02D5A4166666666D2CC2341666666A6CC2D5A41CDCCCCCCFACC23419A999959BB2D5A4166666666E6CC234166666666BB2D5A419A999999F2CC2341CDCCCC4CB62D5A419A999999FACC234166666626B32D5A419A9999993ECD2341CDCCCC2C972D5A41000000002BCD2341CDCCCC6C962D5A416666666617CD2341333333B3952D5A419A9999993ECC234166666686912D5A419A99999933CC23419A999979912D5A41666666661CCC23419A999959912D5A41CDCCCCCC0DCC234133333313922D5A4166666666FCCB23419A9999F9922D5A416666666602CC23419A999999962D5A4166666666EDCB2341CDCCCC2C972D5A4166666666EACB234100000040972D5A419A999999E7CB234133333353972D5A41CDCCCCCCF1CA2341333333738E2D5A41CDCCCCCC34CA2341000000A0862D5A41000000000ECA2341000000808A2D5A41CDCCCCCC99C92341333333F3982D5A41CDCCCCCC8EC92341CDCCCC4C9A2D5A419A99999901C92341000000C0AB2D5A41CDCCCCCCEEC8234133333333AE2D5A41	01060000206A0800000100000001030000000100000017000000CDCCCCCCEEC8234133333333AE2D5A41CDCCCCCC24C9234166666606B52D5A41666666669AC92341CDCCCC2CC12D5A419A999999F3C9234100000060C82D5A41CDCCCCCCC3CA2341CDCCCC2CD42D5A413333333365CB234100000020DA2D5A4100000000DECB2341CDCCCC8CDC2D5A4133333333A7CC234166666666DF2D5A4166666666B3CC2341CDCCCC0CD02D5A4166666666D2CC2341666666A6CC2D5A41CDCCCCCCFACC23419A999959BB2D5A4166666666E6CC234166666666BB2D5A419A9999993ECD2341CDCCCC2C972D5A416666666617CD2341333333B3952D5A419A9999993ECC234166666686912D5A4166666666FCCB23419A9999F9922D5A416666666602CC23419A999999962D5A419A999999E7CB234133333353972D5A41CDCCCCCCF1CA2341333333738E2D5A41CDCCCCCC34CA2341000000A0862D5A41000000000ECA2341000000808A2D5A41CDCCCCCCEEC8234133333333AE2D5A41CDCCCCCCEEC8234133333333AE2D5A41	01010000206A0800002C25114B07CB2341CCCCCCACB22D5A41	751072809	H	Gros Caillou 9	7510728	75107	75	11	0
01060000206A080000010000000103000000010000001F00000066666666E6CC234166666666BB2D5A41CDCCCCCCFACC23419A999959BB2D5A410000000057CD23419A999939BB2D5A419A9999998ECD23419A999919BB2D5A419A999999AACE2341000000A0BA2D5A413333333387CF234166666646BA2D5A41333333334ED02341CDCCCCECB92D5A413333333364D02341000000E0B92D5A4166666666EED0234133333393B92D5A413333333325D12341CDCCCC6CB92D5A413333333369D1234166666646B92D5A416666666655D12341000000E0972D5A410000000044D12341CDCCCCEC972D5A41CDCCCCCC09D1234133333313972D5A41CDCCCCCC95D0234133333353952D5A41CDCCCCCC01D02341666666A6922D5A4166666666E5CF2341000000E0912D5A419A999999BACF23419A999999902D5A41CDCCCCCC70CF2341666666E68E2D5A41333333331FCF2341333333138C2D5A41CDCCCCCC74CE23419A999959852D5A41333333336DCE2341CDCCCC0C852D5A41666666660ECE2341CDCCCC4C812D5A419A999999F4CD23419A999919802D5A41333333339ACD23419A9999D97A2D5A416666666695CD2341333333937A2D5A410000000086CD2341CDCCCCAC792D5A419A9999993ECD2341CDCCCC2C972D5A419A999999FACC234166666626B32D5A419A999999F2CC2341CDCCCC4CB62D5A4166666666E6CC234166666666BB2D5A41	01060000206A080000010000000103000000010000000C00000066666666E6CC234166666666BB2D5A41333333334ED02341CDCCCCECB92D5A413333333369D1234166666646B92D5A416666666655D12341000000E0972D5A41CDCCCCCC95D0234133333353952D5A41CDCCCCCC01D02341666666A6922D5A41CDCCCCCC70CF2341666666E68E2D5A41333333331FCF2341333333138C2D5A41666666660ECE2341CDCCCC4C812D5A410000000086CD2341CDCCCCAC792D5A4166666666E6CC234166666666BB2D5A4166666666E6CC234166666666BB2D5A41	01010000206A08000076C509983CCF23419A999989A52D5A41	751072810	H	Gros Caillou 10	7510728	75107	75	11	0
01060000206A080000010000000103000000010000001900000033333333A7CC234166666666DF2D5A41CDCCCCCCEFCC234166666626DF2D5A41000000002ECD234133333373DE2D5A4166666666A5CE234133333373DF2D5A41CDCCCCCC19CF2341CDCCCCACDF2D5A4166666666D1D02341666666C6E02D5A41666666660DD123419A9999F9E02D5A41333333335CD12341CDCCCC8CE12D5A419A99999983D123419A9999F9E12D5A41666666667ED1234133333393DC2D5A413333333369D1234166666646B92D5A413333333325D12341CDCCCC6CB92D5A4166666666EED0234133333393B92D5A413333333364D02341000000E0B92D5A41333333334ED02341CDCCCCECB92D5A413333333387CF234166666646BA2D5A419A999999AACE2341000000A0BA2D5A419A9999998ECD23419A999919BB2D5A410000000057CD23419A999939BB2D5A41CDCCCCCCFACC23419A999959BB2D5A4166666666D2CC2341666666A6CC2D5A4166666666B3CC2341CDCCCC0CD02D5A419A999999ABCC2341CDCCCCACD32D5A41CDCCCCCCA7CC234166666686DB2D5A4133333333A7CC234166666666DF2D5A41	01060000206A080000010000000103000000010000001900000033333333A7CC234166666666DF2D5A41CDCCCCCCEFCC234166666626DF2D5A41000000002ECD234133333373DE2D5A4166666666A5CE234133333373DF2D5A41CDCCCCCC19CF2341CDCCCCACDF2D5A4166666666D1D02341666666C6E02D5A41666666660DD123419A9999F9E02D5A41333333335CD12341CDCCCC8CE12D5A419A99999983D123419A9999F9E12D5A41666666667ED1234133333393DC2D5A413333333369D1234166666646B92D5A413333333325D12341CDCCCC6CB92D5A4166666666EED0234133333393B92D5A413333333364D02341000000E0B92D5A41333333334ED02341CDCCCCECB92D5A413333333387CF234166666646BA2D5A419A999999AACE2341000000A0BA2D5A419A9999998ECD23419A999919BB2D5A410000000057CD23419A999939BB2D5A41CDCCCCCCFACC23419A999959BB2D5A4166666666D2CC2341666666A6CC2D5A4166666666B3CC2341CDCCCC0CD02D5A419A999999ABCC2341CDCCCCACD32D5A41CDCCCCCCA7CC234166666686DB2D5A4133333333A7CC234166666666DF2D5A41	01010000206A080000356DE3601CCF23419A999959CE2D5A41	751072811	H	Gros Caillou 11	7510728	75107	75	11	0
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	01060000206A080000010000000103000000010000001900000066666666B5C6234133333353632D5A41CDCCCCCCFCC62341000000406C2D5A416666666656C8234166666606992D5A413333333395C823419A9999D9A12D5A4133333333B4C92341666666A67E2D5A41666666666EC92341CDCCCC6C752D5A419A9999992FCA2341666666665D2D5A419A999999DCCA234100000080482D5A41CDCCCCCC12CB2341666666463F2D5A41000000007FCB234166666686342D5A4100000000E3CB23419A999979282D5A413333333346CC2341333333531B2D5A419A99999993CD2341CDCCCCECF12C5A419A999999EECD23419A999939E62C5A413333333398CC2341666666E6BA2C5A419A9999993BCC2341000000C0C62C5A4100000000A1CB234133333353D92C5A41333333335BCA2341333333F3012D5A41000000008EC923419A9999F91B2D5A419A99999924C9234100000080282D5A41CDCCCCCC4AC82341CDCCCC2C442D5A413333333319C82341CDCCCCCC492D5A4133333333CDC7234166666626402D5A4166666666B5C6234133333353632D5A4166666666B5C6234133333353632D5A41	01010000206A080000F4AB5E2E3ECA234100000020312D5A41	751072812	D	Champ de Mars	7510728	75107	75	11	0
01060000206A080000010000000103000000010000002A0000009A9999991FCC2341000000201F2E5A41666666663BCC2341666666061F2E5A41CDCCCCCC55CC23419A9999591E2E5A41000000005CCC2341CDCCCC2C222E5A413333333363CC2341000000A0252E5A416666666660CC23419A9999192E2E5A416666666660CC23419A9999592E2E5A413333333357CC2341333333B3452E5A410000000051CC234133333353562E5A413333333349CC2341666666866E2E5A41000000003FCC234100000040852E5A419A9999993CCC2341666666A68A2E5A419A9999992CCC234133333353AE2E5A41666666662CCC234133333373AF2E5A41CDCCCCCC2ACC2341000000E0B22E5A410000000061CC2341CDCCCCECB52E5A413333333365CC234166666606B52E5A419A99999969CC234166666606B32E5A419A999999E0CC234166666626A52E5A41CDCCCCCC2CCD2341000000E09B2E5A41666666665ECD23419A9999D9952E5A4133333333B5CD23419A9999598B2E5A41CDCCCCCC48CE234100000080792E5A419A999999CECE234133333353692E5A419A9999990ECF23419A999999612E5A41000000001BCF234100000020602E5A41666666662ECF2341666666C65D2E5A41CDCCCCCC7ACE2341CDCCCC6C4C2E5A4100000000DDCD2341333333333D2E5A4133333333AACD234133333353382E5A419A999999A1CD234100000080372E5A41CDCCCCCC89CD234133333333352E5A41CDCCCCCC6CCD234166666666322E5A419A99999940CD2341000000202E2E5A4100000000D8CC234166666646232E5A419A999999C6CC234133333373212E5A4100000000B4CC2341000000601F2E5A4166666666A0CC2341000000A01E2E5A41000000008FCC2341333333131E2E5A41CDCCCCCC85CC2341000000201D2E5A419A9999995ACC2341333333B31A2E5A419A9999991FCC2341000000201F2E5A41	01060000206A080000010000000103000000010000000E0000009A9999991FCC2341000000201F2E5A41CDCCCCCC55CC23419A9999591E2E5A413333333363CC2341000000A0252E5A413333333349CC2341666666866E2E5A41CDCCCCCC2ACC2341000000E0B22E5A410000000061CC2341CDCCCCECB52E5A419A99999969CC234166666606B32E5A419A999999E0CC234166666626A52E5A41666666662ECF2341666666C65D2E5A419A99999940CD2341000000202E2E5A4100000000B4CC2341000000601F2E5A419A9999995ACC2341333333B31A2E5A419A9999991FCC2341000000201F2E5A419A9999991FCC2341000000201F2E5A41	01010000206A080000BBC7485C9DCD234166666676652E5A41	751082901	H	Champs Élysées 1	7510829	75108	75	11	0
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	01060000206A08000001000000010300000001000000130000009A9999995ACC2341333333B31A2E5A4100000000B4CC2341000000601F2E5A419A99999940CD2341000000202E2E5A419A999999FCCF2341CDCCCCAC712E5A419A999999E8D0234133333333882E5A416666666600D12341CDCCCCEC842E5A410000000048D12341000000E0802E5A413333333369D12341333333D3802E5A419A99999972D12341CDCCCCAC572E5A419A99999974D12341333333F3182E5A41333333337DD12341333333D3112E5A410000000078D0234166666666112E5A416666666638CE2341333333F30F2E5A4133333333DDCC2341333333B30E2E5A41CDCCCCCCD5CC23419A999939122E5A410000000081CC23419A9999D90F2E5A419A9999997DCC234133333313182E5A419A9999995ACC2341333333B31A2E5A419A9999995ACC2341333333B31A2E5A41	01010000206A080000F815B612D0CF2341000000D0442E5A41	751082902	A	Champs Élysées 2	7510829	75108	75	11	0
01060000206A08000001000000010300000001000000310000000000000061CC2341CDCCCCECB52E5A41CDCCCCCCACCC2341333333B3C02E5A416666666603CD234133333353D32E5A416666666618CD234133333353D72E5A41CDCCCCCC9ACD234166666626CF2E5A4100000000EECD234166666646CA2E5A419A99999929CE2341CDCCCC6CC62E5A41000000009CCE234100000000BF2E5A419A99999933CF234166666626B62E5A41CDCCCCCC5DCF2341333333B3B32E5A413333333368CF2341CDCCCC0CB32E5A41000000006DCF2341666666C6B22E5A4166666666C9CF23419A999919AD2E5A416666666620D02341666666C6A72E5A41CDCCCCCC54D0234133333373A42E5A416666666690D02341000000A0A02E5A4100000000C8D023419A9999199D2E5A4133333333DCD02341CDCCCCCC9B2E5A4100000000D0D0234100000000992E5A419A999999CCD02341333333D3972E5A4100000000CAD02341CDCCCCEC962E5A4100000000C8D0234133333353952E5A4100000000C8D0234133333353942E5A4133333333C8D0234100000040932E5A4133333333C9D02341333333F3912E5A41CDCCCCCCCAD023419A999999902E5A4166666666CCD02341333333938F2E5A4166666666CED02341000000A08E2E5A4100000000D2D02341000000408D2E5A4133333333D5D02341333333F38B2E5A4166666666D9D02341666666C68A2E5A4166666666DBD023419A9999398A2E5A419A999999E8D0234133333333882E5A4100000000D1D02341333333F3852E5A4166666666CED02341333333B3852E5A4133333333AAD0234100000040822E5A419A999999FCCF2341CDCCCCAC712E5A41666666662ECF2341666666C65D2E5A41000000001BCF234100000020602E5A419A9999990ECF23419A999999612E5A419A999999CECE234133333353692E5A41CDCCCCCC48CE234100000080792E5A4133333333B5CD23419A9999598B2E5A41666666665ECD23419A9999D9952E5A41CDCCCCCC2CCD2341000000E09B2E5A419A999999E0CC234166666626A52E5A419A99999969CC234166666606B32E5A413333333365CC234166666606B52E5A410000000061CC2341CDCCCCECB52E5A41	01060000206A080000010000000103000000010000000F0000000000000061CC2341CDCCCCECB52E5A41CDCCCCCCACCC2341333333B3C02E5A416666666618CD234133333353D72E5A4100000000EECD234166666646CA2E5A41000000009CCE234100000000BF2E5A41CDCCCCCC5DCF2341333333B3B32E5A4133333333DCD02341CDCCCCCC9B2E5A4100000000CAD02341CDCCCCEC962E5A4166666666CCD02341333333938F2E5A419A999999E8D0234133333333882E5A41666666662ECF2341666666C65D2E5A419A999999E0CC234166666626A52E5A419A99999969CC234166666606B32E5A410000000061CC2341CDCCCCECB52E5A410000000061CC2341CDCCCCECB52E5A41	01010000206A0800004675788507CF2341666666669A2E5A41	751082903	A	Champs Élysées 3	7510829	75108	75	11	0
01060000206A080000010000000103000000010000002700000033333333F5CA2341CDCCCCEC882E5A4166666666F5CA2341333333F3882E5A410000000009CB2341000000008C2E5A410000000018CB2341000000A08D2E5A4133333333D4CB2341CDCCCCACA42E5A419A99999913CC234166666666AC2E5A41666666662CCC234133333373AF2E5A419A9999992CCC234133333353AE2E5A419A9999993CCC2341666666A68A2E5A41000000003FCC234100000040852E5A413333333349CC2341666666866E2E5A410000000051CC234133333353562E5A413333333357CC2341333333B3452E5A416666666660CC23419A9999592E2E5A416666666660CC23419A9999192E2E5A413333333363CC2341000000A0252E5A41000000005CCC2341CDCCCC2C222E5A41CDCCCCCC55CC23419A9999591E2E5A41666666663BCC2341666666061F2E5A419A9999991FCC2341000000201F2E5A410000000008CC23419A9999D9202E5A41CDCCCCCCD1CB234133333313252E5A4166666666BACB2341666666A6262E5A41666666669ACB234133333353262E5A416666666677CB234166666626262E5A41CDCCCCCC78CB2341666666862A2E5A41000000007ACB2341666666C62D2E5A410000000078CB234133333373352E5A416666666670CB2341CDCCCC0C3A2E5A419A9999996FCB2341333333B33A2E5A41CDCCCCCC5ECB23419A999999452E5A41CDCCCCCC4DCB2341000000C0502E5A41666666664ACB234100000020532E5A419A99999944CB23419A9999F9562E5A419A9999992CCB23419A999979662E5A410000000026CB2341333333D36A2E5A410000000014CB234100000020762E5A4100000000FFCA23419A999939832E5A4133333333F5CA2341CDCCCCEC882E5A41	01060000206A080000010000000103000000010000000D00000033333333F5CA2341CDCCCCEC882E5A410000000018CB2341000000A08D2E5A41666666662CCC234133333373AF2E5A413333333349CC2341666666866E2E5A413333333363CC2341000000A0252E5A41CDCCCCCC55CC23419A9999591E2E5A419A9999991FCC2341000000201F2E5A4166666666BACB2341666666A6262E5A416666666677CB234166666626262E5A410000000078CB234133333373352E5A410000000026CB2341333333D36A2E5A4133333333F5CA2341CDCCCCEC882E5A4133333333F5CA2341CDCCCCEC882E5A41	01010000206A08000084526132BACB2341666666A6682E5A41	751082904	A	Champs Élysées 4	7510829	75108	75	11	0
01060000206A08000001000000010300000001000000250000006666666671C92341CDCCCC6CF72E5A419A99999986C9234133333313F92E5A419A99999990C923419A9999D9F92E5A41CDCCCCCC9DC923419A9999B9F62E5A41CDCCCCCCA9C92341333333F3F52E5A4133333333B4C92341CDCCCC0CF52E5A4166666666C0C92341CDCCCC4CF52E5A4100000000E0CA2341000000A0E32E5A413333333399CB2341CDCCCC4CD82E5A413333333320CC234166666666CC2E5A419A9999993ACC23419A999939CA2E5A41666666663CCC2341CDCCCC0CCA2E5A41CDCCCCCCACCC2341333333B3C02E5A410000000061CC2341CDCCCCECB52E5A41CDCCCCCC2ACC2341000000E0B22E5A41666666662CCC234133333373AF2E5A419A99999913CC234166666666AC2E5A4133333333D4CB2341CDCCCCACA42E5A410000000018CB2341000000A08D2E5A410000000009CB2341000000008C2E5A4166666666F5CA2341333333F3882E5A4133333333F5CA2341CDCCCCEC882E5A419A999999EFCA23419A9999F98B2E5A4133333333E9CA23419A9999F98D2E5A41CDCCCCCC9BCA234133333353A72E5A416666666698CA2341CDCCCC6CA82E5A416666666695CA2341CDCCCC6CA92E5A41CDCCCCCC92CA234100000040AA2E5A419A99999974CA234100000020B42E5A410000000035CA23419A9999F9C82E5A41CDCCCCCC2BCA23419A9999F9CB2E5A41CDCCCCCC18CA23419A9999B9D02E5A41CDCCCCCC11CA234100000060D22E5A41333333330ACA234100000020D42E5A41CDCCCCCC02CA23419A9999D9D52E5A419A99999985C92341CDCCCCACF22E5A416666666671C92341CDCCCC6CF72E5A41	01060000206A080000010000000103000000010000000E0000006666666671C92341CDCCCC6CF72E5A419A99999990C923419A9999D9F92E5A4166666666C0C92341CDCCCC4CF52E5A413333333399CB2341CDCCCC4CD82E5A41CDCCCCCCACCC2341333333B3C02E5A410000000061CC2341CDCCCCECB52E5A41CDCCCCCC2ACC2341000000E0B22E5A41666666662CCC234133333373AF2E5A410000000018CB2341000000A08D2E5A4133333333F5CA2341CDCCCCEC882E5A4133333333E9CA23419A9999F98D2E5A41CDCCCCCC2BCA23419A9999F9CB2E5A416666666671C92341CDCCCC6CF72E5A416666666671C92341CDCCCC6CF72E5A41	01010000206A080000E69757575ECB2341666666D6C42E5A41	751082905	A	Champs Élysées 5	7510829	75108	75	11	0
01060000206A080000010000000103000000010000002400000033333333C7C82341CDCCCC2C1B2F5A4100000000CEC82341000000001B2F5A41000000003CC923419A999979142F5A413333333366C9234133333393112F5A41CDCCCCCC9DC92341000000200E2F5A4166666666A0C92341333333F30D2F5A4166666666F0C923419A9999F9082F5A419A99999908CA23419A999979072F5A41CDCCCCCCDFCA2341CDCCCC0CFA2E5A416666666657CB2341000000A0F22E5A419A999999DECB234133333333EA2E5A419A99999912CC2341333333F3E62E5A41CDCCCCCC32CC2341333333F3E42E5A41000000003ACC234100000080E42E5A4166666666EFCC234133333333D92E5A416666666618CD234133333353D72E5A416666666603CD234133333353D32E5A41CDCCCCCCACCC2341333333B3C02E5A41666666663CCC2341CDCCCC0CCA2E5A419A9999993ACC23419A999939CA2E5A413333333320CC234166666666CC2E5A413333333399CB2341CDCCCC4CD82E5A4100000000E0CA2341000000A0E32E5A4166666666C0C92341CDCCCC4CF52E5A4133333333B4C92341CDCCCC0CF52E5A41CDCCCCCCA9C92341333333F3F52E5A41CDCCCCCC9DC923419A9999B9F62E5A419A99999990C923419A9999D9F92E5A419A99999986C9234133333313F92E5A416666666671C92341CDCCCC6CF72E5A410000000046C92341333333D3012F5A416666666645C9234133333313022F5A41CDCCCCCC29C92341CDCCCC6C082F5A413333333311C92341666666060E2F5A4133333333D6C8234166666666182F5A4133333333C7C82341CDCCCC2C1B2F5A41	01060000206A080000010000000103000000010000000C00000033333333C7C82341CDCCCC2C1B2F5A413333333366C9234133333393112F5A4166666666EFCC234133333333D92E5A416666666618CD234133333353D72E5A41CDCCCCCCACCC2341333333B3C02E5A413333333399CB2341CDCCCC4CD82E5A4166666666C0C92341CDCCCC4CF52E5A419A99999990C923419A9999D9F92E5A416666666671C92341CDCCCC6CF72E5A413333333311C92341666666060E2F5A4133333333C7C82341CDCCCC2C1B2F5A4133333333C7C82341CDCCCC2C1B2F5A41	01010000206A080000E85337BCE5CA23419A999969EE2E5A41	751082906	A	Champs Élysées 6	7510829	75108	75	11	0
01060000206A080000010000000103000000010000003C00000066666666EFCC234133333333D92E5A413333333368CD234100000040E52E5A410000000075CD2341CDCCCC8CE62E5A41CDCCCCCC9ECD2341666666C6EA2E5A4100000000F5CD23419A999979F32E5A4133333333F8CD2341CDCCCCCCF32E5A41000000001BCE23419A9999B9F12E5A41CDCCCCCC70CE2341333333B3EC2E5A4100000000A5CE234166666686E92E5A419A999999B8CE234100000060E82E5A41000000001FCF234166666646E22E5A41CDCCCCCC47CF23419A9999B9DF2E5A4100000000CCCF2341CDCCCC6CD72E5A419A999999AED0234100000000CA2E5A4166666666D1D02341000000C0C72E5A41666666662CD123419A9999D9C12E5A41000000005AD12341666666E6BE2E5A4100000000F1D1234133333393B52E5A416666666629D223419A999919B22E5A41000000005CD223419A9999F9AE2E5A41CDCCCCCC5DD223419A9999D9AE2E5A419A99999974D22341CDCCCC6CAD2E5A416666666655D223419A999979AA2E5A41CDCCCCCCDFD12341333333D39F2E5A41CDCCCCCCD5D12341CDCCCCEC9E2E5A4100000000C6D123419A9999599D2E5A41CDCCCCCC93D12341CDCCCC6C982E5A419A9999997ED12341CDCCCC4C962E5A41CDCCCCCC7BD12341333333B3962E5A416666666677D1234166666626972E5A41CDCCCCCC72D1234166666686972E5A419A9999996DD12341CDCCCCCC972E5A410000000068D1234100000000982E5A416666666662D12341CDCCCC0C982E5A41CDCCCCCC60D1234166666606982E5A41CDCCCCCC5CD1234100000000982E5A413333333357D12341333333D3972E5A410000000052D12341CDCCCC8C972E5A41333333334DD1234133333333972E5A419A99999948D12341000000C0962E5A410000000045D1234133333333962E5A410000000042D123419A999999952E5A416666666641D1234133333373952E5A410000000022D1234100000060972E5A4133333333DCD02341CDCCCCCC9B2E5A4100000000C8D023419A9999199D2E5A416666666690D02341000000A0A02E5A41CDCCCCCC54D0234133333373A42E5A416666666620D02341666666C6A72E5A4166666666C9CF23419A999919AD2E5A41000000006DCF2341666666C6B22E5A413333333368CF2341CDCCCC0CB32E5A41CDCCCCCC5DCF2341333333B3B32E5A419A99999933CF234166666626B62E5A41000000009CCE234100000000BF2E5A419A99999929CE2341CDCCCC6CC62E5A4100000000EECD234166666646CA2E5A41CDCCCCCC9ACD234166666626CF2E5A416666666618CD234133333353D72E5A4166666666EFCC234133333333D92E5A41	01060000206A080000010000000103000000010000001200000066666666EFCC234133333333D92E5A4133333333F8CD2341CDCCCCCCF32E5A41000000001FCF234166666646E22E5A4100000000CCCF2341CDCCCC6CD72E5A419A999999AED0234100000000CA2E5A41000000005AD12341666666E6BE2E5A419A99999974D22341CDCCCC6CAD2E5A41CDCCCCCCD5D12341CDCCCCEC9E2E5A419A9999997ED12341CDCCCC4C962E5A413333333357D12341333333D3972E5A416666666641D1234133333373952E5A416666666620D02341666666C6A72E5A41CDCCCCCC5DCF2341333333B3B32E5A41000000009CCE234100000000BF2E5A4100000000EECD234166666646CA2E5A416666666618CD234133333353D72E5A4166666666EFCC234133333333D92E5A4166666666EFCC234133333333D92E5A41	01010000206A080000789938FBAACF234134333323C42E5A41	751083003	A	Faubourg du Roule 3	7510830	75108	75	11	0
01060000206A080000010000000103000000010000002B00000033333333F8CD2341CDCCCCCCF32E5A4133333333C2CE234100000040082F5A4133333333C7CE23419A9999B9082F5A41CDCCCCCCDBCE2341666666C60A2F5A41333333335BCF23419A999959172F5A419A999999E5CF234100000000252F5A41CDCCCCCC26D02341666666C6202F5A41333333334AD02341333333531E2F5A41333333337CD02341CDCCCC8C1A2F5A4100000000DDD023419A999959112F5A41CDCCCCCC56D12341CDCCCCCC052F5A41000000005DD123419A999959052F5A4133333333A1D12341333333D3002F5A419A999999C8D1234133333333FE2E5A4166666666CAD1234133333313FE2E5A41CDCCCCCCA4D22341CDCCCCCCEF2E5A4100000000C1D2234166666646EE2E5A419A999999BDD22341CDCCCCECE82E5A41000000008ED2234133333353DD2E5A419A9999997AD22341333333F3D72E5A41CDCCCCCCD1D2234166666626C42E5A419A999999EDD2234100000080BD2E5A419A999999F0D22341333333D3BC2E5A4100000000F9D22341000000C0BA2E5A4166666666BFD22341666666A6B42E5A4100000000A3D22341CDCCCCECB12E5A419A99999974D22341CDCCCC6CAD2E5A41CDCCCCCC5DD223419A9999D9AE2E5A41000000005CD223419A9999F9AE2E5A416666666629D223419A999919B22E5A4100000000F1D1234133333393B52E5A41000000005AD12341666666E6BE2E5A41666666662CD123419A9999D9C12E5A4166666666D1D02341000000C0C72E5A419A999999AED0234100000000CA2E5A4100000000CCCF2341CDCCCC6CD72E5A41CDCCCCCC47CF23419A9999B9DF2E5A41000000001FCF234166666646E22E5A419A999999B8CE234100000060E82E5A4100000000A5CE234166666686E92E5A41CDCCCCCC70CE2341333333B3EC2E5A41000000001BCE23419A9999B9F12E5A4133333333F8CD2341CDCCCCCCF32E5A41	01060000206A080000010000000103000000010000001100000033333333F8CD2341CDCCCCCCF32E5A4133333333C2CE234100000040082F5A419A999999E5CF234100000000252F5A41333333337CD02341CDCCCC8C1A2F5A41CDCCCCCC56D12341CDCCCCCC052F5A41CDCCCCCCA4D22341CDCCCCCCEF2E5A4100000000C1D2234166666646EE2E5A419A999999BDD22341CDCCCCECE82E5A419A9999997AD22341333333F3D72E5A4100000000F9D22341000000C0BA2E5A419A99999974D22341CDCCCC6CAD2E5A41000000005AD12341666666E6BE2E5A419A999999AED0234100000000CA2E5A4100000000CCCF2341CDCCCC6CD72E5A41000000001FCF234166666646E22E5A4133333333F8CD2341CDCCCCCCF32E5A4133333333F8CD2341CDCCCCCCF32E5A41	01010000206A080000995DACF3B3D023419A999939E92E5A41	751083004	A	Faubourg du Roule 4	7510830	75108	75	11	0
01060000206A0800000100000001030000000100000033000000000000003CC923419A999979142F5A416666666646C923419A9999B9182F5A413333333348C92341000000001B2F5A413333333347C92341666666A61C2F5A413333333379C92341333333731D2F5A4166666666B5C923419A9999991E2F5A416666666612CA234133333373202F5A419A9999992CCA2341000000E0202F5A419A99999977CA234100000060222F5A4100000000ABCA234166666666232F5A410000000005CB234100000020252F5A41666666665ECB2341000000E0262F5A413333333330CC23419A9999392B2F5A41000000005CCC2341CDCCCC0C2C2F5A4133333333E2CC2341CDCCCCAC2E2F5A41333333337CCD2341333333B3312F5A41000000003DCE234100000080352F5A416666666655CE234166666606362F5A419A99999984CE2341666666E6362F5A41CDCCCCCC8DCE23419A9999F9362F5A416666666698CE234100000020372F5A41333333339FCE23419A999959372F5A4100000000C6CE23419A999979382F5A4100000000CACE23419A999979382F5A4100000000DECE2341000000C0382F5A41CDCCCCCC08CF234100000020362F5A41CDCCCCCC16CF2341000000E0342F5A416666666655CF2341666666662E2F5A419A999999E5CF234100000000252F5A41333333335BCF23419A999959172F5A41CDCCCCCCDBCE2341666666C60A2F5A4133333333C7CE23419A9999B9082F5A4133333333C2CE234100000040082F5A4133333333F8CD2341CDCCCCCCF32E5A4100000000F5CD23419A999979F32E5A41CDCCCCCC9ECD2341666666C6EA2E5A410000000075CD2341CDCCCC8CE62E5A413333333368CD234100000040E52E5A4166666666EFCC234133333333D92E5A41000000003ACC234100000080E42E5A41CDCCCCCC32CC2341333333F3E42E5A419A99999912CC2341333333F3E62E5A419A999999DECB234133333333EA2E5A416666666657CB2341000000A0F22E5A41CDCCCCCCDFCA2341CDCCCC0CFA2E5A419A99999908CA23419A999979072F5A4166666666F0C923419A9999F9082F5A4166666666A0C92341333333F30D2F5A41CDCCCCCC9DC92341000000200E2F5A413333333366C9234133333393112F5A41000000003CC923419A999979142F5A41	01060000206A080000010000000103000000010000000D000000000000003CC923419A999979142F5A413333333347C92341666666A61C2F5A41666666665ECB2341000000E0262F5A41000000005CCC2341CDCCCC0C2C2F5A4100000000DECE2341000000C0382F5A41CDCCCCCC08CF234100000020362F5A416666666655CF2341666666662E2F5A419A999999E5CF234100000000252F5A4133333333C2CE234100000040082F5A4166666666EFCC234133333333D92E5A413333333366C9234133333393112F5A41000000003CC923419A999979142F5A41000000003CC923419A999979142F5A41	01010000206A08000035A784575ACC2341000000E0092F5A41	751083005	A	Faubourg du Roule 5	7510830	75108	75	11	0
01060000206A080000010000000103000000010000002100000000000000DECE2341000000C0382F5A419A999999F7CE234166666606392F5A416666666607CF234100000020392F5A416666666613CF23419A999919392F5A41CDCCCCCC4FCF234166666666392F5A413333333395D02341000000803B2F5A419A999999BED02341000000C03B2F5A41CDCCCCCCE7D02341000000003C2F5A413333333311D1234100000000332F5A410000000029D12341CDCCCC8C2E2F5A410000000034D123419A9999D92C2F5A419A99999955D12341666666A6282F5A41333333335CD12341666666C6272F5A419A99999964D12341000000A0262F5A4100000000A9D12341CDCCCCEC1C2F5A419A999999ACD123419A9999591C2F5A4133333333DFD12341000000A0142F5A4133333333E9D12341666666E6122F5A419A9999993AD22341000000E0042F5A4133333333D2D12341333333D3FE2E5A419A999999C8D1234133333333FE2E5A4133333333A1D12341333333D3002F5A41000000005DD123419A999959052F5A41CDCCCCCC56D12341CDCCCCCC052F5A4100000000DDD023419A999959112F5A41333333337CD02341CDCCCC8C1A2F5A41333333334AD02341333333531E2F5A41CDCCCCCC26D02341666666C6202F5A419A999999E5CF234100000000252F5A416666666655CF2341666666662E2F5A41CDCCCCCC16CF2341000000E0342F5A41CDCCCCCC08CF234100000020362F5A4100000000DECE2341000000C0382F5A41	01060000206A080000010000000103000000010000000E00000000000000DECE2341000000C0382F5A41CDCCCCCCE7D02341000000003C2F5A410000000034D123419A9999D92C2F5A419A99999964D12341000000A0262F5A4133333333DFD12341000000A0142F5A419A9999993AD22341000000E0042F5A419A999999C8D1234133333333FE2E5A41CDCCCCCC56D12341CDCCCCCC052F5A41333333337CD02341CDCCCC8C1A2F5A41CDCCCCCC26D02341666666C6202F5A416666666655CF2341666666662E2F5A41CDCCCCCC08CF234100000020362F5A4100000000DECE2341000000C0382F5A4100000000DECE2341000000C0382F5A41	01010000206A0800002D5289C4FBD02341000000A01D2F5A41	751083006	A	Faubourg du Roule 6	7510830	75108	75	11	0
01060000206A08000001000000010300000001000000250000009A999999DDD42341333333F3822E5A4100000000EAD42341666666E6852E5A419A99999973D5234133333353A62E5A41CDCCCCCC7BD52341CDCCCCACA82E5A4166666666B0D5234133333333B52E5A41CDCCCCCCBAD523419A9999D9B72E5A4166666666DAD523419A999959B42E5A4133333333FDD5234100000080B02E5A419A99999925D6234166666666AC2E5A410000000055D62341333333D3A72E5A41666666667FD6234100000020A42E5A4133333333AFD6234100000060A02E5A4133333333DCD62341333333339D2E5A416666666610D723419A9999D9992E5A410000000038D723419A999979972E5A410000000041D723419A9999F9962E5A410000000066D723419A9999D9942E5A419A99999992D7234100000080922E5A419A999999BDD723419A999959902E5A41333333331BD82341CDCCCC4C8C2E5A41CDCCCCCCEAD82341333333B3802E5A4133333333ABD92341CDCCCC8C742E5A416666666616D92341333333334D2E5A419A99999910D92341CDCCCCAC4B2E5A410000000005D923419A9999D9482E5A4100000000E6D823419A999959482E5A4100000000CAD82341000000A0482E5A416666666632D823419A999939512E5A41666666667CD723419A9999D95A2E5A419A9999996CD72341000000A05B2E5A41666666663AD72341CDCCCC2C5E2E5A419A999999B5D6234166666646662E5A410000000005D6234166666606712E5A410000000087D52341333333B3782E5A419A9999995DD523419A9999397B2E5A419A999999EBD42341CDCCCC2C822E5A419A999999DDD42341333333F3822E5A41	01060000206A08000001000000010300000001000000100000009A999999DDD42341333333F3822E5A419A99999973D5234133333353A62E5A41CDCCCCCCBAD523419A9999D9B72E5A410000000055D62341333333D3A72E5A4133333333AFD6234100000060A02E5A416666666610D723419A9999D9992E5A419A999999BDD723419A999959902E5A41333333331BD82341CDCCCC4C8C2E5A41CDCCCCCCEAD82341333333B3802E5A4133333333ABD92341CDCCCC8C742E5A410000000005D923419A9999D9482E5A4100000000CAD82341000000A0482E5A416666666632D823419A999939512E5A41666666663AD72341CDCCCC2C5E2E5A419A999999DDD42341333333F3822E5A419A999999DDD42341333333F3822E5A41	01010000206A080000CD465A6C23D72341666666F67D2E5A41	751083101	A	Madeleine 1	7510831	75108	75	11	0
01060000206A08000001000000010300000001000000340000009A99999974D22341CDCCCC6CAD2E5A4100000000A3D22341CDCCCCECB12E5A4166666666BFD22341666666A6B42E5A4100000000F9D22341000000C0BA2E5A419A999999F0D22341333333D3BC2E5A419A999999EDD2234100000080BD2E5A41CDCCCCCCD1D2234166666626C42E5A419A9999997AD22341333333F3D72E5A41000000008ED2234133333353DD2E5A419A999999BDD22341CDCCCCECE82E5A4100000000C1D2234166666646EE2E5A4166666666D3D2234100000040ED2E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A4100000000BAD3234100000000E02E5A41333333339ED4234133333373D32E5A41CDCCCCCCC0D423419A999999D12E5A4166666666CED4234100000020D12E5A4100000000DDD42341333333D3D02E5A41CDCCCCCCE1D42341CDCCCC6CD02E5A4100000000F4D42341000000C0CD2E5A419A9999999FD523419A9999D9BA2E5A41CDCCCCCCBAD523419A9999D9B72E5A4166666666B0D5234133333333B52E5A41CDCCCCCC7BD52341CDCCCCACA82E5A419A99999973D5234133333353A62E5A4100000000EAD42341666666E6852E5A419A999999DDD42341333333F3822E5A41CDCCCCCCD4D42341666666C6812E5A4133333333C1D42341333333B3802E5A4100000000B6D423419A999959802E5A41CDCCCCCCA7D4234166666666802E5A41CDCCCCCC95D4234100000080802E5A419A99999984D42341333333B3802E5A410000000072D4234133333313812E5A413333333363D42341CDCCCC8C812E5A410000000053D4234133333333822E5A419A99999948D42341333333B3822E5A410000000043D4234100000020832E5A413333333334D4234100000040842E5A419A9999991FD42341333333D3862E5A41666666660ED423419A9999598A2E5A41666666660AD42341000000408B2E5A410000000000D42341333333938D2E5A41CDCCCCCCF6D32341CDCCCCCC8F2E5A419A999999F9D323419A999999902E5A419A99999907D42341CDCCCC6C942E5A4100000000F0D32341666666E6952E5A416666666646D32341CDCCCC6CA02E5A41CDCCCCCCD1D22341666666A6A72E5A413333333396D2234133333353AB2E5A41666666668FD22341666666C6AB2E5A419A99999974D22341CDCCCC6CAD2E5A41	01060000206A08000001000000010300000001000000120000009A99999974D22341CDCCCC6CAD2E5A4100000000F9D22341000000C0BA2E5A419A9999997AD22341333333F3D72E5A419A999999BDD22341CDCCCCECE82E5A4100000000C1D2234166666646EE2E5A4100000000BAD3234100000000E02E5A41CDCCCCCCC0D423419A999999D12E5A4100000000F4D42341000000C0CD2E5A41CDCCCCCCBAD523419A9999D9B72E5A419A99999973D5234133333353A62E5A419A999999DDD42341333333F3822E5A4100000000B6D423419A999959802E5A419A99999948D42341333333B3822E5A419A9999991FD42341333333D3862E5A41CDCCCCCCF6D32341CDCCCCCC8F2E5A419A99999907D42341CDCCCC6C942E5A419A99999974D22341CDCCCC6CAD2E5A419A99999974D22341CDCCCC6CAD2E5A41	01010000206A0800000BC13A5A43D4234166666686B62E5A41	751083102	A	Madeleine 2	7510831	75108	75	11	0
01060000206A080000010000000103000000010000001E0000009A999999C8D1234133333333FE2E5A4133333333D2D12341333333D3FE2E5A419A9999993AD22341000000E0042F5A41000000006DD22341CDCCCC0C082F5A4166666666AAD22341CDCCCCEC0B2F5A4166666666E9D32341666666C6152F5A416666666608D423419A9999B9162F5A419A99999928D423419A9999B9172F5A4166666666BBD42341000000401C2F5A419A99999966D5234166666686212F5A419A999999ACD52341CDCCCCAC232F5A41333333334ED62341CDCCCCAC282F5A419A999999C4D62341333333532C2F5A419A999999EDD623419A9999F92D2F5A419A999999FDD623419A9999B92E2F5A41000000000AD72341CDCCCCEC2F2F5A41CDCCCCCC13D7234133333373312F5A41CDCCCCCC2BD723419A9999B92B2F5A413333333371D72341CDCCCC6C172F5A41666666668DD7234100000020102F5A4100000000D5D62341666666E60C2F5A419A999999E4D52341000000C0082F5A4100000000C8D42341666666E6FE2E5A410000000015D4234133333393F72E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A4166666666D3D2234100000040ED2E5A4100000000C1D2234166666646EE2E5A41CDCCCCCCA4D22341CDCCCCCCEF2E5A4166666666CAD1234133333313FE2E5A419A999999C8D1234133333333FE2E5A41	01060000206A080000010000000103000000010000001E0000009A999999C8D1234133333333FE2E5A4133333333D2D12341333333D3FE2E5A419A9999993AD22341000000E0042F5A41000000006DD22341CDCCCC0C082F5A4166666666AAD22341CDCCCCEC0B2F5A4166666666E9D32341666666C6152F5A416666666608D423419A9999B9162F5A419A99999928D423419A9999B9172F5A4166666666BBD42341000000401C2F5A419A99999966D5234166666686212F5A419A999999ACD52341CDCCCCAC232F5A41333333334ED62341CDCCCCAC282F5A419A999999C4D62341333333532C2F5A419A999999EDD623419A9999F92D2F5A419A999999FDD623419A9999B92E2F5A41000000000AD72341CDCCCCEC2F2F5A41CDCCCCCC13D7234133333373312F5A41CDCCCCCC2BD723419A9999B92B2F5A413333333371D72341CDCCCC6C172F5A41666666668DD7234100000020102F5A4100000000D5D62341666666E60C2F5A419A999999E4D52341000000C0082F5A4100000000C8D42341666666E6FE2E5A410000000015D4234133333393F72E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A4166666666D3D2234100000040ED2E5A4100000000C1D2234166666646EE2E5A41CDCCCCCCA4D22341CDCCCCCCEF2E5A4166666666CAD1234133333313FE2E5A419A999999C8D1234133333333FE2E5A41	01010000206A08000090FBF8B217D52341333333830E2F5A41	751083103	A	Madeleine 3	7510831	75108	75	11	0
01060000206A0800000100000001030000000100000019000000CDCCCCCCFBD22341CDCCCC0CEB2E5A410000000015D4234133333393F72E5A4100000000C8D42341666666E6FE2E5A419A999999E4D52341000000C0082F5A4100000000D5D62341666666E60C2F5A419A999999A6D6234133333333E22E5A419A99999945D62341666666E6E32E5A41CDCCCCCC1DD6234100000040E42E5A41CDCCCCCC2FD62341CDCCCC8CDE2E5A410000000029D62341CDCCCC0CDD2E5A41000000000DD6234100000000D92E5A4133333333FCD52341666666E6D62E5A4133333333EFD523419A9999B9D52E5A419A999999DDD52341CDCCCCCCD42E5A41CDCCCCCCC8D523419A9999F9D32E5A419A99999904D62341CDCCCCECCF2E5A419A9999999FD523419A9999D9BA2E5A4100000000F4D42341000000C0CD2E5A41CDCCCCCCE1D42341CDCCCC6CD02E5A4100000000DDD42341333333D3D02E5A4166666666CED4234100000020D12E5A41CDCCCCCCC0D423419A999999D12E5A41333333339ED4234133333373D32E5A4100000000BAD3234100000000E02E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A41	01060000206A0800000100000001030000000100000011000000CDCCCCCCFBD22341CDCCCC0CEB2E5A410000000015D4234133333393F72E5A4100000000C8D42341666666E6FE2E5A419A999999E4D52341000000C0082F5A4100000000D5D62341666666E60C2F5A419A999999A6D6234133333333E22E5A41CDCCCCCC1DD6234100000040E42E5A41CDCCCCCC2FD62341CDCCCC8CDE2E5A4133333333EFD523419A9999B9D52E5A41CDCCCCCCC8D523419A9999F9D32E5A419A99999904D62341CDCCCCECCF2E5A419A9999999FD523419A9999D9BA2E5A4100000000F4D42341000000C0CD2E5A41CDCCCCCCC0D423419A999999D12E5A4100000000BAD3234100000000E02E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A41CDCCCCCCFBD22341CDCCCC0CEB2E5A41	01010000206A080000F25AA08BD3D42341CCCCCC0CE32E5A41	751083104	A	Madeleine 4	7510831	75108	75	11	0
01060000206A08000001000000010300000001000000350000009A9999999FD523419A9999D9BA2E5A419A99999904D62341CDCCCCECCF2E5A41CDCCCCCCC8D523419A9999F9D32E5A419A999999DDD52341CDCCCCCCD42E5A4133333333EFD523419A9999B9D52E5A4133333333FCD52341666666E6D62E5A41000000000DD6234100000000D92E5A410000000029D62341CDCCCC0CDD2E5A41CDCCCCCC2FD62341CDCCCC8CDE2E5A41CDCCCCCC1DD6234100000040E42E5A419A99999945D62341666666E6E32E5A419A999999A6D6234133333333E22E5A4100000000D5D62341666666E60C2F5A41666666668DD7234100000020102F5A419A999999FFD72341333333D3F02E5A41666666661AD82341CDCCCC8CE92E5A410000000030D823419A9999B9E32E5A41000000003ED82341CDCCCCECDF2E5A416666666644D8234100000020DE2E5A416666666693D8234133333353C82E5A413333333397D823419A999959C72E5A41333333339BD82341CDCCCC6CC62E5A4166666666AED82341CDCCCC8CC12E5A419A999999B6D823419A999939BF2E5A4133333333EFD823419A999939B02E5A419A9999990AD92341CDCCCCECA82E5A41CDCCCCCC22D92341CDCCCC8CA12E5A410000000031D92341000000C09C2E5A41666666664DD92341666666069A2E5A410000000080D9234166666626992E5A41CDCCCCCC93D92341CDCCCCEC992E5A41CDCCCCCCA7D92341333333B39A2E5A4133333333C5D923419A9999B99B2E5A416666666603DA2341000000409D2E5A410000000019DA23419A9999F9912E5A4133333333ABD92341CDCCCC8C742E5A41CDCCCCCCEAD82341333333B3802E5A41333333331BD82341CDCCCC4C8C2E5A419A999999BDD723419A999959902E5A419A99999992D7234100000080922E5A410000000066D723419A9999D9942E5A410000000041D723419A9999F9962E5A410000000038D723419A999979972E5A416666666610D723419A9999D9992E5A4133333333DCD62341333333339D2E5A4133333333AFD6234100000060A02E5A41666666667FD6234100000020A42E5A410000000055D62341333333D3A72E5A419A99999925D6234166666666AC2E5A4133333333FDD5234100000080B02E5A4166666666DAD523419A999959B42E5A41CDCCCCCCBAD523419A9999D9B72E5A419A9999999FD523419A9999D9BA2E5A41	01060000206A08000001000000010300000001000000190000009A9999999FD523419A9999D9BA2E5A419A99999904D62341CDCCCCECCF2E5A41CDCCCCCCC8D523419A9999F9D32E5A4133333333EFD523419A9999B9D52E5A41CDCCCCCC2FD62341CDCCCC8CDE2E5A41CDCCCCCC1DD6234100000040E42E5A419A999999A6D6234133333333E22E5A4100000000D5D62341666666E60C2F5A41666666668DD7234100000020102F5A416666666693D8234133333353C82E5A419A9999990AD92341CDCCCCECA82E5A410000000031D92341000000C09C2E5A41666666664DD92341666666069A2E5A410000000080D9234166666626992E5A416666666603DA2341000000409D2E5A410000000019DA23419A9999F9912E5A4133333333ABD92341CDCCCC8C742E5A41CDCCCCCCEAD82341333333B3802E5A41333333331BD82341CDCCCC4C8C2E5A419A999999BDD723419A999959902E5A416666666610D723419A9999D9992E5A4133333333AFD6234100000060A02E5A410000000055D62341333333D3A72E5A419A9999999FD523419A9999D9BA2E5A419A9999999FD523419A9999D9BA2E5A41	01010000206A0800007E85661838D72341CDCCCCFCC32E5A41	751083105	A	Madeleine 5	7510831	75108	75	11	0
01060000206A0800000100000001030000000100000027000000666666668DD7234100000020102F5A416666666676D82341333333330D2F5A41CDCCCCCC2BD92341CDCCCCEC0A2F5A41000000008CD92341CDCCCC8C092F5A41000000002DDA234100000000072F5A4166666666EDDA2341CDCCCC2C042F5A4100000000C9DA234166666606FA2E5A419A999999D0DA23419A999999F92E5A4166666666D8DA2341333333D3F82E5A4133333333DDDA234133333333F82E5A4133333333DFDA234166666686F72E5A41CDCCCCCCDDDA234133333373F52E5A4133333333D7DA23419A9999B9F02E5A41000000008DDA23419A9999F9BC2E5A41CDCCCCCC7ADA2341CDCCCCCCAF2E5A419A9999996DDA234133333393A12E5A410000000051DA2341000000C0A02E5A410000000022DA23419A9999199F2E5A416666666603DA2341000000409D2E5A4133333333C5D923419A9999B99B2E5A41CDCCCCCCA7D92341333333B39A2E5A41CDCCCCCC93D92341CDCCCCEC992E5A410000000080D9234166666626992E5A41666666664DD92341666666069A2E5A410000000031D92341000000C09C2E5A41CDCCCCCC22D92341CDCCCC8CA12E5A419A9999990AD92341CDCCCCECA82E5A4133333333EFD823419A999939B02E5A419A999999B6D823419A999939BF2E5A4166666666AED82341CDCCCC8CC12E5A41333333339BD82341CDCCCC6CC62E5A413333333397D823419A999959C72E5A416666666693D8234133333353C82E5A416666666644D8234100000020DE2E5A41000000003ED82341CDCCCCECDF2E5A410000000030D823419A9999B9E32E5A41666666661AD82341CDCCCC8CE92E5A419A999999FFD72341333333D3F02E5A41666666668DD7234100000020102F5A41	01060000206A080000010000000103000000010000000F000000666666668DD7234100000020102F5A41CDCCCCCC2BD92341CDCCCCEC0A2F5A4166666666EDDA2341CDCCCC2C042F5A4100000000C9DA234166666606FA2E5A41CDCCCCCCDDDA234133333373F52E5A41CDCCCCCC7ADA2341CDCCCCCCAF2E5A419A9999996DDA234133333393A12E5A416666666603DA2341000000409D2E5A410000000080D9234166666626992E5A41666666664DD92341666666069A2E5A410000000031D92341000000C09C2E5A419A9999990AD92341CDCCCCECA82E5A416666666693D8234133333353C82E5A41666666668DD7234100000020102F5A41666666668DD7234100000020102F5A41	01010000206A080000BC8CB5668CD923419A999939D32E5A41	751083106	A	Madeleine 6	7510831	75108	75	11	0
01060000206A0800000100000001030000000100000014000000CDCCCCCC13D7234133333373312F5A413333333356D72341666666A62F2F5A41CDCCCCCC5AD72341666666862F2F5A41CDCCCCCCA6D82341CDCCCCEC262F5A410000000052D92341666666A6222F5A4133333333B8D92341000000E01F2F5A410000000094DA2341000000E0192F5A41CDCCCCCCFADA2341CDCCCC2C172F5A41666666661CDB234166666646162F5A41CDCCCCCC17DB234166666626122F5A41000000000BDB2341333333730C2F5A4166666666EDDA2341CDCCCC2C042F5A41000000002DDA234100000000072F5A41000000008CD92341CDCCCC8C092F5A41CDCCCCCC2BD92341CDCCCCEC0A2F5A416666666676D82341333333330D2F5A41666666668DD7234100000020102F5A413333333371D72341CDCCCC6C172F5A41CDCCCCCC2BD723419A9999B92B2F5A41CDCCCCCC13D7234133333373312F5A41	01060000206A0800000100000001030000000100000014000000CDCCCCCC13D7234133333373312F5A413333333356D72341666666A62F2F5A41CDCCCCCC5AD72341666666862F2F5A41CDCCCCCCA6D82341CDCCCCEC262F5A410000000052D92341666666A6222F5A4133333333B8D92341000000E01F2F5A410000000094DA2341000000E0192F5A41CDCCCCCCFADA2341CDCCCC2C172F5A41666666661CDB234166666646162F5A41CDCCCCCC17DB234166666626122F5A41000000000BDB2341333333730C2F5A4166666666EDDA2341CDCCCC2C042F5A41000000002DDA234100000000072F5A41000000008CD92341CDCCCC8C092F5A41CDCCCCCC2BD92341CDCCCCEC0A2F5A416666666676D82341333333330D2F5A41666666668DD7234100000020102F5A413333333371D72341CDCCCC6C172F5A41CDCCCCCC2BD723419A9999B92B2F5A41CDCCCCCC13D7234133333373312F5A41	01010000206A080000DA608055C2D82341000000E01C2F5A41	751083107	A	Madeleine 7	7510831	75108	75	11	0
01060000206A0800000100000001030000000100000028000000666666664BD72341000000C0322F5A419A9999994CD72341000000E0332F5A419A99999950D7234166666626352F5A419A99999955D7234166666606362F5A41CDCCCCCC5BD7234166666626372F5A410000000001D82341000000803A2F5A419A999999C8D82341CDCCCCCC3C2F5A416666666648D92341666666463E2F5A413333333360D92341CDCCCC8C3E2F5A413333333383D923419A9999993F2F5A4166666666A3D923419A999999402F5A41CDCCCCCCDED923419A9999F9412F5A41CDCCCCCCF4D923419A999959422F5A416666666603DA23419A9999B9422F5A419A99999990DA2341000000E0462F5A4100000000A8DA23419A999979472F5A4100000000C4DA2341666666C6472F5A4166666666D2DA2341CDCCCC6C472F5A4100000000EBDA234133333353472F5A4100000000E7DA2341000000A0442F5A4166666666E6DA234133333313422F5A41CDCCCCCCE8DA2341000000803F2F5A4166666666EFDA234166666606392F5A419A999999F4DA234133333313342F5A4166666666F5DA234166666666332F5A413333333310DB23419A999959212F5A413333333317DB2341333333F31B2F5A413333333319DB2341666666C6192F5A41CDCCCCCC1ADB23419A9999D9172F5A41666666661CDB234166666646162F5A41CDCCCCCCFADA2341CDCCCC2C172F5A410000000094DA2341000000E0192F5A4133333333B8D92341000000E01F2F5A410000000052D92341666666A6222F5A41CDCCCCCCA6D82341CDCCCCEC262F5A41CDCCCCCC5AD72341666666862F2F5A413333333356D72341666666A62F2F5A41666666664ED7234100000000312F5A41666666664CD72341000000E0312F5A41666666664BD72341000000C0322F5A41	01060000206A080000010000000103000000010000000D000000666666664BD72341000000C0322F5A41CDCCCCCC5BD7234166666626372F5A410000000001D82341000000803A2F5A413333333360D92341CDCCCC8C3E2F5A419A99999990DA2341000000E0462F5A4100000000EBDA234133333353472F5A4166666666E6DA234133333313422F5A4166666666F5DA234166666666332F5A41666666661CDB234166666646162F5A410000000052D92341666666A6222F5A413333333356D72341666666A62F2F5A41666666664BD72341000000C0322F5A41666666664BD72341000000C0322F5A41	01010000206A08000032F3412B81D923419A9999392B2F5A41	751083108	A	Madeleine 8	7510831	75108	75	11	0
01060000206A080000010000000103000000010000002C00000066666666FED423419A999939872F5A41CDCCCCCC98D52341666666A6882F5A41000000000FD62341000000C0892F5A419A999999EFD623419A999959922F5A413333333305D7234166666626932F5A413333333367D8234100000040A12F5A41333333336CD82341666666A69F2F5A419A999999A2D82341000000808D2F5A4100000000D2D82341000000607A2F5A4133333333DDD82341CDCCCCEC752F5A419A99999947D92341CDCCCC6C4F2F5A41CDCCCCCC47D923419A9999594F2F5A41CDCCCCCC4AD92341333333334E2F5A41CDCCCCCC5BD92341666666C6472F5A413333333383D923419A9999993F2F5A413333333360D92341CDCCCC8C3E2F5A416666666648D92341666666463E2F5A419A999999C8D82341CDCCCCCC3C2F5A410000000001D82341000000803A2F5A41CDCCCCCC5BD7234166666626372F5A419A99999955D7234166666606362F5A419A99999950D7234166666626352F5A419A9999994CD72341000000E0332F5A41666666664BD72341000000C0322F5A41666666664CD72341000000E0312F5A41666666664ED7234100000000312F5A413333333356D72341666666A62F2F5A41CDCCCCCC13D7234133333373312F5A41000000000AD72341CDCCCCEC2F2F5A419A999999FDD623419A9999B92E2F5A419A999999EDD623419A9999F92D2F5A419A999999C4D62341333333532C2F5A4166666666BFD6234100000000342F5A419A999999B5D6234166666646342F5A419A999999B7D62341CDCCCC0C372F5A4133333333B9D62341333333133B2F5A4133333333C1D62341000000003D2F5A4133333333C1D62341333333B3402F5A41CDCCCCCCAAD6234133333313442F5A410000000088D6234100000020492F5A41000000007BD62341CDCCCC0C4B2F5A410000000003D623419A9999B95D2F5A41CDCCCCCCC7D52341333333F3662F5A4166666666FED423419A999939872F5A41	01060000206A080000010000000103000000010000001500000066666666FED423419A999939872F5A41000000000FD62341000000C0892F5A413333333305D7234166666626932F5A413333333367D8234100000040A12F5A419A999999A2D82341000000808D2F5A4133333333DDD82341CDCCCCEC752F5A41CDCCCCCC5BD92341666666C6472F5A413333333383D923419A9999993F2F5A413333333360D92341CDCCCC8C3E2F5A410000000001D82341000000803A2F5A41CDCCCCCC5BD7234166666626372F5A413333333356D72341666666A62F2F5A41CDCCCCCC13D7234133333373312F5A419A999999FDD623419A9999B92E2F5A419A999999C4D62341333333532C2F5A419A999999B5D6234166666646342F5A4133333333C1D62341333333B3402F5A41000000007BD62341CDCCCC0C4B2F5A41CDCCCCCCC7D52341333333F3662F5A4166666666FED423419A999939872F5A4166666666FED423419A999939872F5A41	01010000206A080000E001CA5D7CD7234166666656622F5A41	751083201	H	Europe 1	7510832	75108	75	11	0
01060000206A080000010000000103000000010000001C00000000000000A3D1234166666646822F5A419A999999C7D1234133333333812F5A41CDCCCCCCF6D1234166666686812F5A41CDCCCCCCD9D223419A999919832F5A41CDCCCCCC42D323419A9999B9832F5A41CDCCCCCC29D4234166666686852F5A419A99999997D42341CDCCCC4C862F5A4166666666FED423419A999939872F5A41CDCCCCCCC7D52341333333F3662F5A410000000003D623419A9999B95D2F5A41000000007BD62341CDCCCC0C4B2F5A410000000088D6234100000020492F5A419A9999997BD62341666666C6492F5A419A9999996CD62341666666664A2F5A419A99999963D62341CDCCCC8C4A2F5A416666666627D62341CDCCCCAC492F5A41CDCCCCCC01D52341333333D3442F5A4166666666F5D4234166666666442F5A4133333333E5D42341666666E6432F5A4100000000BBD42341CDCCCC6C422F5A4166666666AFD42341CDCCCCAC412F5A410000000020D423419A9999594A2F5A419A999999F3D32341666666064D2F5A41CDCCCCCCF2D2234166666686642F5A41CDCCCCCC24D2234166666686762F5A419A999999ECD12341000000C07B2F5A4166666666C8D12341666666E67E2F5A4100000000A3D1234166666646822F5A41	01060000206A080000010000000103000000010000001C00000000000000A3D1234166666646822F5A419A999999C7D1234133333333812F5A41CDCCCCCCF6D1234166666686812F5A41CDCCCCCCD9D223419A999919832F5A41CDCCCCCC42D323419A9999B9832F5A41CDCCCCCC29D4234166666686852F5A419A99999997D42341CDCCCC4C862F5A4166666666FED423419A999939872F5A41CDCCCCCCC7D52341333333F3662F5A410000000003D623419A9999B95D2F5A41000000007BD62341CDCCCC0C4B2F5A410000000088D6234100000020492F5A419A9999997BD62341666666C6492F5A419A9999996CD62341666666664A2F5A419A99999963D62341CDCCCC8C4A2F5A416666666627D62341CDCCCCAC492F5A41CDCCCCCC01D52341333333D3442F5A4166666666F5D4234166666666442F5A4133333333E5D42341666666E6432F5A4100000000BBD42341CDCCCC6C422F5A4166666666AFD42341CDCCCCAC412F5A410000000020D423419A9999594A2F5A419A999999F3D32341666666064D2F5A41CDCCCCCCF2D2234166666686642F5A41CDCCCCCC24D2234166666686762F5A419A999999ECD12341000000C07B2F5A4166666666C8D12341666666E67E2F5A4100000000A3D1234166666646822F5A41	01010000206A0800001A0D4A9182D4234100000020612F5A41	751083202	H	Europe 2	7510832	75108	75	11	0
01060000206A08000001000000010300000001000000360000006666666677CD234133333353AF2F5A41333333337FCD2341666666A6AF2F5A419A99999987CE234166666606BA2F5A419A999999C8CE2341333333B3BC2F5A41CDCCCCCCC0CF234100000080C62F5A419A99999969D023419A999959CD2F5A413333333385D0234100000080CE2F5A41333333339CD02341CDCCCC8CCF2F5A419A999999B4D02341333333F3D02F5A41CDCCCCCCC2D023419A999919D22F5A4166666666E1D02341666666E6D22F5A41CDCCCCCCE9D0234100000020D32F5A4166666666FFD023419A999999D32F5A416666666618D12341000000E0D32F5A416666666631D12341CDCCCC0CD42F5A419A9999994FD1234133333353D42F5A419A99999982D1234133333393D52F5A413333333364D223419A999959DA2F5A4133333333ABD22341000000E0DB2F5A41CDCCCCCCDED223419A999919DD2F5A41666666661AD323419A999939D32F5A41666666665CD3234166666606C92F5A413333333363D32341333333F3C72F5A4100000000ADD3234133333373BC2F5A4133333333DAD3234133333373B52F5A41CDCCCCCC29D423419A999919A92F5A41CDCCCCCC91D42341666666E6972F5A4166666666FED423419A999939872F5A419A99999997D42341CDCCCC4C862F5A41CDCCCCCC29D4234166666686852F5A41CDCCCCCC42D323419A9999B9832F5A41CDCCCCCCD9D223419A999919832F5A41CDCCCCCCF6D1234166666686812F5A419A999999C7D1234133333333812F5A4100000000A3D1234166666646822F5A419A99999985D123419A999979812F5A41CDCCCCCC70D12341666666A6802F5A413333333350D12341CDCCCC6C802F5A41333333333ED123419A999959802F5A419A99999958D02341333333D37E2F5A410000000078CF23419A9999397D2F5A41000000004CCF2341CDCCCC6C812F5A419A99999905CF234166666686872F5A41CDCCCCCCDFCE2341666666A68A2F5A4166666666BCCE2341CDCCCCAC8D2F5A41CDCCCCCCB0CE2341666666468D2F5A41CDCCCCCCA7CE2341000000408D2F5A4166666666A0CE2341666666A68D2F5A419A9999999ACE23419A9999798E2F5A419A99999998CE23419A9999598F2F5A410000000099CE2341CDCCCC2C902F5A419A9999999ACE23419A9999F9902F5A419A999999B3CD234100000080A82F5A416666666677CD234133333353AF2F5A41	01060000206A08000001000000010300000001000000130000006666666677CD234133333353AF2F5A41CDCCCCCCC0CF234100000080C62F5A41333333339CD02341CDCCCC8CCF2F5A41CDCCCCCCC2D023419A999919D22F5A419A9999994FD1234133333353D42F5A41CDCCCCCCDED223419A999919DD2F5A41666666661AD323419A999939D32F5A41CDCCCCCC29D423419A999919A92F5A41CDCCCCCC91D42341666666E6972F5A4166666666FED423419A999939872F5A41CDCCCCCC42D323419A9999B9832F5A419A999999C7D1234133333333812F5A4100000000A3D1234166666646822F5A41CDCCCCCC70D12341666666A6802F5A410000000078CF23419A9999397D2F5A419A9999999ACE23419A9999F9902F5A419A999999B3CD234100000080A82F5A416666666677CD234133333353AF2F5A416666666677CD234133333353AF2F5A41	01010000206A0800004201DE4BD4D0234166666636AC2F5A41	751083203	H	Europe 3	7510832	75108	75	11	0
01060000206A080000010000000103000000010000001F000000CDCCCCCCDED223419A999919DD2F5A416666666630D32341000000C0DE2F5A419A999999C8D32341CDCCCCECE12F5A4100000000CED32341CDCCCC0CE22F5A41666666663BD4234166666666E42F5A41CDCCCCCC57D42341666666E6E42F5A41CDCCCCCC77D423419A999999E52F5A41000000009BD4234133333373E62F5A410000000020D523419A999919EA2F5A419A99999922D52341CDCCCC8CE92F5A410000000033D5234100000080E62F5A410000000044D5234100000020E32F5A41000000004DD5234100000060E12F5A41CDCCCCCC70D52341CDCCCC0CD92F5A4100000000A2D5234100000080CF2F5A41CDCCCCCC1DD62341666666A6B62F5A419A9999993ED6234166666686B12F5A41CDCCCCCCFAD6234100000020952F5A413333333305D7234166666626932F5A419A999999EFD623419A999959922F5A41000000000FD62341000000C0892F5A41CDCCCCCC98D52341666666A6882F5A4166666666FED423419A999939872F5A41CDCCCCCC91D42341666666E6972F5A41CDCCCCCC29D423419A999919A92F5A4133333333DAD3234133333373B52F5A4100000000ADD3234133333373BC2F5A413333333363D32341333333F3C72F5A41666666665CD3234166666606C92F5A41666666661AD323419A999939D32F5A41CDCCCCCCDED223419A999919DD2F5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCCDED223419A999919DD2F5A41000000009BD4234133333373E62F5A410000000020D523419A999919EA2F5A41CDCCCCCC70D52341CDCCCC0CD92F5A41CDCCCCCC1DD62341666666A6B62F5A413333333305D7234166666626932F5A41000000000FD62341000000C0892F5A4166666666FED423419A999939872F5A41CDCCCCCC91D42341666666E6972F5A41CDCCCCCC29D423419A999919A92F5A41666666661AD323419A999939D32F5A41CDCCCCCCDED223419A999919DD2F5A41CDCCCCCCDED223419A999919DD2F5A41	01010000206A080000966B038AE7D42341CCCCCC8CB92F5A41	751083204	H	Europe 4	7510832	75108	75	11	0
01060000206A08000001000000010300000001000000160000000000000020D523419A999919EA2F5A419A99999970D62341CDCCCC4CF52F5A419A99999967D723419A999979FE2F5A410000000070D723419A9999B9FB2F5A419A9999998DD7234166666606F12F5A4100000000C2D72341333333D3DC2F5A4133333333E6D7234133333373D02F5A410000000009D823419A9999D9C32F5A419A99999930D8234133333393B52F5A419A99999962D8234166666606A32F5A413333333367D8234100000040A12F5A413333333305D7234166666626932F5A41CDCCCCCCFAD6234100000020952F5A419A9999993ED6234166666686B12F5A41CDCCCCCC1DD62341666666A6B62F5A4100000000A2D5234100000080CF2F5A41CDCCCCCC70D52341CDCCCC0CD92F5A41000000004DD5234100000060E12F5A410000000044D5234100000020E32F5A410000000033D5234100000080E62F5A419A99999922D52341CDCCCC8CE92F5A410000000020D523419A999919EA2F5A41	01060000206A08000001000000010300000001000000090000000000000020D523419A999919EA2F5A419A99999970D62341CDCCCC4CF52F5A419A99999967D723419A999979FE2F5A413333333367D8234100000040A12F5A413333333305D7234166666626932F5A41CDCCCCCC1DD62341666666A6B62F5A41CDCCCCCC70D52341CDCCCC0CD92F5A410000000020D523419A999919EA2F5A410000000020D523419A999919EA2F5A41	01010000206A080000E6D438F7DBD62341CDCCCCACC92F5A41	751083205	H	Europe 5	7510832	75108	75	11	0
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	01060000206A080000010000000103000000010000000D0000009A99999967D723419A999979FE2F5A41000000009AD923410000006013305A419A99999999D92341000000800F305A419A999999B5D9234166666646FA2F5A419A999999DED9234133333333D72F5A4166666666F6D9234166666626D52F5A419A999999F4D9234166666626D02F5A416666666647DA234166666646B22F5A41CDCCCCCCF7D8234133333393A82F5A419A99999970D82341CDCCCCACA22F5A413333333367D8234100000040A12F5A419A99999967D723419A999979FE2F5A419A99999967D723419A999979FE2F5A41	01010000206A0800009E12E4C5D2D8234133333303DA2F5A41	751083206	H	Europe 6	7510832	75108	75	11	0
01060000206A08000001000000010300000001000000220000009A99999999D92341000000800F305A419A9999999CD923413333337310305A41333333339ED923416666662611305A419A9999999DD92341CDCCCCCC11305A41000000009AD923410000006013305A41666666663DDA23413333337319305A413333333300DB2341333333B320305A416666666614DB23413333337321305A410000000021DB2341666666E621305A410000000035DB2341CDCCCCAC22305A413333333343DB2341CDCCCC2C23305A419A99999941DB2341333333D31C305A41CDCCCCCC41DB23419A9999391C305A416666666641DB2341333333D31B305A41333333333FDB23419A99991913305A419A99999932DB234100000080E62F5A41000000002FDB2341CDCCCC6CD92F5A41666666662DDB234133333353CF2F5A413333333325DB234133333373B92F5A416666666614DB2341666666E6B92F5A419A999999FDDA234100000020B92F5A4166666666F1DA2341CDCCCC8CB82F5A41CDCCCCCCE8DA23419A9999D9B72F5A4100000000E4DA234166666606B72F5A41666666668CDA234133333353B42F5A416666666647DA234166666646B22F5A413333333315DA23419A999999C32F5A419A999999F4D9234166666626D02F5A41CDCCCCCCF2D92341000000E0D12F5A4166666666F6D9234166666626D52F5A419A999999DED9234133333333D72F5A4133333333D6D9234166666666DE2F5A419A999999B5D9234166666646FA2F5A419A99999999D92341000000800F305A41	01060000206A080000010000000103000000010000000B0000009A99999999D92341000000800F305A41000000009AD923410000006013305A413333333343DB2341CDCCCC2C23305A413333333325DB234133333373B92F5A416666666647DA234166666646B22F5A419A999999F4D9234166666626D02F5A4166666666F6D9234166666626D52F5A419A999999DED9234133333333D72F5A419A999999B5D9234166666646FA2F5A419A99999999D92341000000800F305A419A99999999D92341000000800F305A41	01010000206A080000661E46477BDA234133333363F02F5A41	751083207	H	Europe 7	7510832	75108	75	11	0
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	01060000206A080000010000000103000000010000000F0000003333333367D8234100000040A12F5A419A99999970D82341CDCCCCACA22F5A41CDCCCCCCF7D8234133333393A82F5A4100000000E4DA234166666606B72F5A413333333325DB234133333373B92F5A41333333331BDB234133333353872F5A410000000007DB234133333373502F5A4100000000EBDA234133333353472F5A419A99999990DA2341000000E0462F5A413333333383D923419A9999993F2F5A41CDCCCCCC5BD92341666666C6472F5A4133333333DDD82341CDCCCCEC752F5A419A999999A2D82341000000808D2F5A413333333367D8234100000040A12F5A413333333367D8234100000040A12F5A41	01010000206A0800003B009E2BEDD923419A9999D9802F5A41	751083208	A	Europe 8	7510832	75108	75	11	0
01060000206A080000010000000103000000010000002D000000CDCCCCCCE7D02341000000003C2F5A41CDCCCCCC09D123419A9999393C2F5A41000000007ED22341000000A03E2F5A4166666666FBD22341333333733F2F5A4166666666DCD323419A9999B9402F5A41333333331BD4234166666626412F5A4166666666AFD42341CDCCCCAC412F5A4100000000BBD42341CDCCCC6C422F5A4133333333E5D42341666666E6432F5A4166666666F5D4234166666666442F5A41CDCCCCCC01D52341333333D3442F5A416666666627D62341CDCCCCAC492F5A419A99999963D62341CDCCCC8C4A2F5A419A9999996CD62341666666664A2F5A419A9999997BD62341666666C6492F5A410000000088D6234100000020492F5A41CDCCCCCCAAD6234133333313442F5A4133333333C1D62341333333B3402F5A4133333333C1D62341000000003D2F5A4133333333B9D62341333333133B2F5A419A999999B7D62341CDCCCC0C372F5A419A999999B5D6234166666646342F5A4166666666BFD6234100000000342F5A419A999999C4D62341333333532C2F5A41333333334ED62341CDCCCCAC282F5A419A999999ACD52341CDCCCCAC232F5A419A99999966D5234166666686212F5A4166666666BBD42341000000401C2F5A419A99999928D423419A9999B9172F5A416666666608D423419A9999B9162F5A4166666666E9D32341666666C6152F5A4166666666AAD22341CDCCCCEC0B2F5A41000000006DD22341CDCCCC0C082F5A419A9999993AD22341000000E0042F5A4133333333E9D12341666666E6122F5A4133333333DFD12341000000A0142F5A419A999999ACD123419A9999591C2F5A4100000000A9D12341CDCCCCEC1C2F5A419A99999964D12341000000A0262F5A41333333335CD12341666666C6272F5A419A99999955D12341666666A6282F5A410000000034D123419A9999D92C2F5A410000000029D12341CDCCCC8C2E2F5A413333333311D1234100000000332F5A41CDCCCCCCE7D02341000000003C2F5A41	01060000206A0800000100000001030000000100000010000000CDCCCCCCE7D02341000000003C2F5A41333333331BD4234166666626412F5A4166666666AFD42341CDCCCCAC412F5A41CDCCCCCC01D52341333333D3442F5A419A99999963D62341CDCCCC8C4A2F5A410000000088D6234100000020492F5A4133333333C1D62341333333B3402F5A419A999999B5D6234166666646342F5A419A999999C4D62341333333532C2F5A4166666666AAD22341CDCCCCEC0B2F5A419A9999993AD22341000000E0042F5A4133333333DFD12341000000A0142F5A419A99999964D12341000000A0262F5A410000000034D123419A9999D92C2F5A41CDCCCCCCE7D02341000000003C2F5A41CDCCCCCCE7D02341000000003C2F5A41	01010000206A08000032B4C876BFD3234133333333272F5A41	751083209	A	Europe 9	7510832	75108	75	11	0
01060000206A080000010000000103000000010000001C0000000000000078CF23419A9999397D2F5A419A99999958D02341333333D37E2F5A41333333333ED123419A999959802F5A413333333350D12341CDCCCC6C802F5A41CDCCCCCC70D12341666666A6802F5A419A99999985D123419A999979812F5A4100000000A3D1234166666646822F5A4166666666C8D12341666666E67E2F5A419A999999ECD12341000000C07B2F5A41CDCCCCCC24D2234166666686762F5A41CDCCCCCCF2D2234166666686642F5A419A999999F3D32341666666064D2F5A410000000020D423419A9999594A2F5A4166666666AFD42341CDCCCCAC412F5A41333333331BD4234166666626412F5A4166666666DCD323419A9999B9402F5A4166666666FBD22341333333733F2F5A41000000007ED22341000000A03E2F5A41CDCCCCCC09D123419A9999393C2F5A41CDCCCCCCE7D02341000000003C2F5A4100000000B1D0234133333353462F5A416666666697D02341333333734B2F5A41CDCCCCCC30D02341CDCCCCEC5F2F5A416666666626D02341666666A6612F5A410000000009D02341CDCCCCAC662F5A419A999999CCCF234133333313702F5A419A99999996CF23419A9999B9782F5A410000000078CF23419A9999397D2F5A41	01060000206A080000010000000103000000010000001C0000000000000078CF23419A9999397D2F5A419A99999958D02341333333D37E2F5A41333333333ED123419A999959802F5A413333333350D12341CDCCCC6C802F5A41CDCCCCCC70D12341666666A6802F5A419A99999985D123419A999979812F5A4100000000A3D1234166666646822F5A4166666666C8D12341666666E67E2F5A419A999999ECD12341000000C07B2F5A41CDCCCCCC24D2234166666686762F5A41CDCCCCCCF2D2234166666686642F5A419A999999F3D32341666666064D2F5A410000000020D423419A9999594A2F5A4166666666AFD42341CDCCCCAC412F5A41333333331BD4234166666626412F5A4166666666DCD323419A9999B9402F5A4166666666FBD22341333333733F2F5A41000000007ED22341000000A03E2F5A41CDCCCCCC09D123419A9999393C2F5A41CDCCCCCCE7D02341000000003C2F5A4100000000B1D0234133333353462F5A416666666697D02341333333734B2F5A41CDCCCCCC30D02341CDCCCCEC5F2F5A416666666626D02341666666A6612F5A410000000009D02341CDCCCCAC662F5A419A999999CCCF234133333313702F5A419A99999996CF23419A9999B9782F5A410000000078CF23419A9999397D2F5A41	01010000206A0800007831653EF6D123419A999979562F5A41	751083210	A	Europe 10	7510832	75108	75	11	0
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	01060000206A080000010000000103000000010000002100000000000000C8D0234133333353942E5A4133333333DCD02341CDCCCCCC9B2E5A416666666641D1234133333373952E5A413333333357D12341333333D3972E5A419A9999997ED12341CDCCCC4C962E5A41CDCCCCCCD5D12341CDCCCCEC9E2E5A419A99999974D22341CDCCCC6CAD2E5A419A99999907D42341CDCCCC6C942E5A41CDCCCCCCF6D32341CDCCCCCC8F2E5A419A9999991FD42341333333D3862E5A419A99999948D42341333333B3822E5A4100000000B6D423419A999959802E5A419A999999EBD42341CDCCCC2C822E5A41666666663AD72341CDCCCC2C5E2E5A416666666632D823419A999939512E5A4100000000CAD82341000000A0482E5A410000000005D923419A9999D9482E5A413333333380D823419A999919282E5A4166666666D0D72341333333F3FD2D5A413333333350D62341CDCCCC8C152E5A41666666663FD623419A999939172E5A41666666660BD62341333333F3152E5A41CDCCCCCC6ED52341CDCCCC0C152E5A41CDCCCCCC8CD22341CDCCCC2C132E5A41333333337DD12341333333D3112E5A419A99999974D12341333333F3182E5A419A99999972D12341CDCCCCAC572E5A413333333369D12341333333D3802E5A410000000048D12341000000E0802E5A416666666600D12341CDCCCCEC842E5A4166666666DBD023419A9999398A2E5A4100000000C8D0234133333353942E5A4100000000C8D0234133333353942E5A41	01010000206A080000FC7B5A26B4D4234134333373542E5A41	751082907	D	Concorde Jardin Champs Élysées	7510829	75108	75	11	0
01060000206A08000001000000010300000001000000360000000000000081CC23419A9999D90F2E5A419A99999996CC23419A999939102E5A4133333333ADCC2341CDCCCCAC102E5A41CDCCCCCCD5CC23419A999939122E5A4133333333D7CC2341CDCCCCAC102E5A4166666666DBCC23419A9999590F2E5A4133333333DDCC2341333333B30E2E5A413333333383CD2341000000600F2E5A416666666638CE2341333333F30F2E5A41CDCCCCCC03CF234166666666102E5A4133333333BECF2341CDCCCCEC102E5A410000000078D0234166666666112E5A413333333321D12341000000A0112E5A41333333337DD12341333333D3112E5A41CDCCCCCCA8D12341CDCCCC2C122E5A41CDCCCCCC8CD22341CDCCCC2C132E5A413333333336D3234133333393132E5A419A9999995DD32341333333D3132E5A41CDCCCCCC95D323419A9999D9132E5A419A9999993DD4234166666646142E5A41CDCCCCCC6ED52341CDCCCC0C152E5A41666666660BD62341333333F3152E5A413333333320D62341CDCCCC4C162E5A410000000025D6234100000060162E5A41000000002BD6234166666686162E5A416666666631D623419A9999B9162E5A41666666663FD623419A999939172E5A41666666664CD62341CDCCCCEC152E5A413333333350D62341CDCCCC8C152E5A410000000088D6234100000040122E5A419A999999E7D62341666666260C2E5A41CDCCCCCCF1D62341CDCCCC8C0B2E5A413333333315D7234133333373092E5A419A99999932D723419A9999D9072E5A410000000038D7234100000080072E5A416666666658D7234166666666052E5A4166666666D0D72341333333F3FD2D5A4166666666C8D72341000000E0FB2D5A4133333333C5D7234133333313FB2D5A41333333338AD7234133333313EC2D5A41CDCCCCCCCBD6234133333393F72D5A419A99999940D6234100000000002E5A419A99999966D4234100000060002E5A419A99999978D3234133333353FF2D5A41333333334FD3234166666626FF2D5A416666666626D32341333333F3FE2D5A41CDCCCCCCA3D2234100000060FE2D5A416666666680D1234100000020FE2D5A41000000000BD1234166666606FE2D5A416666666631CF2341000000A0FD2D5A4100000000E2CC234100000020FD2D5A419A9999998BCC234133333393FC2D5A419A9999998ACC234166666666FC2D5A410000000081CC23419A9999D90F2E5A41	01060000206A08000001000000010300000001000000360000000000000081CC23419A9999D90F2E5A419A99999996CC23419A999939102E5A4133333333ADCC2341CDCCCCAC102E5A41CDCCCCCCD5CC23419A999939122E5A4133333333D7CC2341CDCCCCAC102E5A4166666666DBCC23419A9999590F2E5A4133333333DDCC2341333333B30E2E5A413333333383CD2341000000600F2E5A416666666638CE2341333333F30F2E5A41CDCCCCCC03CF234166666666102E5A4133333333BECF2341CDCCCCEC102E5A410000000078D0234166666666112E5A413333333321D12341000000A0112E5A41333333337DD12341333333D3112E5A41CDCCCCCCA8D12341CDCCCC2C122E5A41CDCCCCCC8CD22341CDCCCC2C132E5A413333333336D3234133333393132E5A419A9999995DD32341333333D3132E5A41CDCCCCCC95D323419A9999D9132E5A419A9999993DD4234166666646142E5A41CDCCCCCC6ED52341CDCCCC0C152E5A41666666660BD62341333333F3152E5A413333333320D62341CDCCCC4C162E5A410000000025D6234100000060162E5A41000000002BD6234166666686162E5A416666666631D623419A9999B9162E5A41666666663FD623419A999939172E5A41666666664CD62341CDCCCCEC152E5A413333333350D62341CDCCCC8C152E5A410000000088D6234100000040122E5A419A999999E7D62341666666260C2E5A41CDCCCCCCF1D62341CDCCCC8C0B2E5A413333333315D7234133333373092E5A419A99999932D723419A9999D9072E5A410000000038D7234100000080072E5A416666666658D7234166666666052E5A4166666666D0D72341333333F3FD2D5A4166666666C8D72341000000E0FB2D5A4133333333C5D7234133333313FB2D5A41333333338AD7234133333313EC2D5A41CDCCCCCCCBD6234133333393F72D5A419A99999940D6234100000000002E5A419A99999966D4234100000060002E5A419A99999978D3234133333353FF2D5A41333333334FD3234166666626FF2D5A416666666626D32341333333F3FE2D5A41CDCCCCCCA3D2234100000060FE2D5A416666666680D1234100000020FE2D5A41000000000BD1234166666606FE2D5A416666666631CF2341000000A0FD2D5A4100000000E2CC234100000020FD2D5A419A9999998BCC234133333393FC2D5A419A9999998ACC234166666666FC2D5A410000000081CC23419A9999D90F2E5A41	01010000206A0800008A5F452204D22341333333E3022E5A41	751082999	D	Seine et Berges	7510829	75108	75	11	0
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	01060000206A080000010000000103000000010000001000000033333333C7C82341CDCCCC2C1B2F5A41333333336ACA2341CDCCCC0C862F5A410000000075CA234100000020892F5A419A999999EFCA2341666666A6852F5A4166666666BBCB2341000000607A2F5A419A99999971CD23419A999919552F5A410000000025CE234100000020462F5A419A999999BACE2341000000603A2F5A4100000000C6CE23419A999979382F5A419A99999984CE2341666666E6362F5A41000000005CCC2341CDCCCC0C2C2F5A41666666665ECB2341000000E0262F5A413333333347C92341666666A61C2F5A41000000003CC923419A999979142F5A4133333333C7C82341CDCCCC2C1B2F5A4133333333C7C82341CDCCCC2C1B2F5A41	01010000206A0800008DE03EC2A1CB23419A999939502F5A41	751083001	H	Faubourg du Roule 1	7510830	75108	75	11	0
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	01060000206A08000001000000010300000001000000100000000000000075CA234100000020892F5A41CDCCCCCC99CA2341CDCCCC4C922F5A416666666677CD234133333353AF2F5A419A999999B3CD234100000080A82F5A4166666666BCCE2341CDCCCCAC8D2F5A410000000078CF23419A9999397D2F5A41CDCCCCCC30D02341CDCCCCEC5F2F5A41CDCCCCCCE7D02341000000003C2F5A4100000000C6CE23419A999979382F5A419A999999BACE2341000000603A2F5A410000000025CE234100000020462F5A419A99999971CD23419A999919552F5A4166666666BBCB2341000000607A2F5A419A999999EFCA2341666666A6852F5A410000000075CA234100000020892F5A410000000075CA234100000020892F5A41	01010000206A080000BADA459DDBCD234133333333742F5A41	751083002	H	Faubourg du Roule 2	7510830	75108	75	11	0
01060000206A080000010000000103000000010000002100000066666666C5E02341666666A6A52F5A419A999999CEE023419A999939A92F5A41CDCCCCCCE1E02341666666A6B02F5A41CDCCCCCCFEE02341CDCCCCECBB2F5A419A9999990EE1234166666606C22F5A419A9999999AE223419A9999F9AF2F5A41000000007EE2234133333393A22F5A41333333336AE22341000000C0952F5A41666666664EE22341CDCCCCEC832F5A410000000039E2234166666626762F5A416666666622E223419A999959672F5A41CDCCCCCC0BE22341666666466A2F5A41CDCCCCCC6DE12341CDCCCCCC872F5A41CDCCCCCC35E12341CDCCCCCC922F5A416666666633E12341666666A6922F5A419A9999992FE1234166666686922F5A41000000002DE123419A999979922F5A41666666662BE1234133333373922F5A416666666626E123419A999979922F5A416666666622E1234133333393922F5A419A9999991EE12341333333D3922F5A41666666661BE12341CDCCCC2C932F5A413333333319E123419A999999932F5A410000000018E1234166666606942F5A413333333317E1234133333373942F5A413333333317E12341333333F3942F5A410000000018E12341CDCCCCAC952F5A419A99999919E1234100000040962F5A419A9999991CE12341333333B3962F5A41CDCCCCCC1EE12341000000E0962F5A41CDCCCCCCF9E02341000000009D2F5A41CDCCCCCCDDE02341000000A0A12F5A4166666666C5E02341666666A6A52F5A41	01060000206A080000010000000103000000010000000900000066666666C5E02341666666A6A52F5A419A9999990EE1234166666606C22F5A419A9999999AE223419A9999F9AF2F5A41000000007EE2234133333393A22F5A416666666622E223419A999959672F5A41CDCCCCCC0BE22341666666466A2F5A41CDCCCCCC1EE12341000000E0962F5A4166666666C5E02341666666A6A52F5A4166666666C5E02341666666A6A52F5A41	01010000206A08000046BA96E1BFE12341333333B3942F5A41	751093301	H	Saint-Georges 1	7510933	75109	75	11	0
01060000206A080000010000000103000000010000002C000000333333333EDF2341666666E66B2F5A410000000049DF2341666666667A2F5A419A9999994DDF2341333333D3822F5A416666666656DF2341666666668A2F5A419A99999961DF234166666646912F5A419A99999970DF23419A9999999C2F5A41000000009BDF234133333313AE2F5A416666666683E02341666666E6A42F5A416666666697E0234166666626A42F5A4133333333C1E0234100000080A22F5A41CDCCCCCCDDE02341000000A0A12F5A41CDCCCCCCF9E02341000000009D2F5A41CDCCCCCC1EE12341000000E0962F5A419A9999991CE12341333333B3962F5A419A99999919E1234100000040962F5A410000000018E12341CDCCCCAC952F5A413333333317E12341333333F3942F5A413333333317E1234133333373942F5A410000000018E1234166666606942F5A413333333319E123419A999999932F5A41666666661BE12341CDCCCC2C932F5A419A9999991EE12341333333D3922F5A416666666622E1234133333393922F5A416666666626E123419A999979922F5A41666666662BE1234133333373922F5A41000000002DE123419A999979922F5A419A9999992FE1234166666686922F5A416666666633E12341666666A6922F5A41CDCCCCCC35E12341CDCCCCCC922F5A41CDCCCCCC6DE12341CDCCCCCC872F5A41CDCCCCCC0BE22341666666466A2F5A416666666622E223419A999959672F5A419A999999DDE12341333333B3682F5A4100000000B4E1234166666686692F5A419A99999997E12341666666C6692F5A419A99999987E12341333333B3692F5A419A99999973E12341CDCCCC6C692F5A41CDCCCCCCE6E0234133333373662F5A419A999999E2E023419A999959662F5A419A999999A8E02341CDCCCC6C662F5A416666666693E02341666666C6662F5A41666666667FE023419A999919672F5A4133333333F5DF2341000000A0692F5A41333333333EDF2341666666E66B2F5A41	01060000206A080000010000000103000000010000000F000000333333333EDF2341666666E66B2F5A419A9999994DDF2341333333D3822F5A419A99999970DF23419A9999999C2F5A41000000009BDF234133333313AE2F5A41CDCCCCCCDDE02341000000A0A12F5A41CDCCCCCC35E12341CDCCCCCC922F5A41CDCCCCCC0BE22341666666466A2F5A416666666622E223419A999959672F5A4100000000B4E1234166666686692F5A419A99999973E12341CDCCCC6C692F5A419A999999E2E023419A999959662F5A419A999999A8E02341CDCCCC6C662F5A4133333333F5DF2341000000A0692F5A41333333333EDF2341666666E66B2F5A41333333333EDF2341666666E66B2F5A41	01010000206A0800009CC429095EE023419A999919892F5A41	751093302	H	Saint-Georges 2	7510933	75109	75	11	0
01060000206A080000010000000103000000010000001E0000009A999999ABDD2341CDCCCC8CC22F5A419A999999ABDD2341CDCCCCACC32F5A41CDCCCCCCABDD234100000020C62F5A4133333333ACDD2341333333F3CD2F5A4133333333B3DD234166666626D42F5A419A99999944DE2341CDCCCCCCCF2F5A41CDCCCCCCA1DE23419A9999B9CC2F5A416666666677DE23419A999999BA2F5A413333333306DF23419A999959B42F5A41000000009BDF234133333313AE2F5A419A99999970DF23419A9999999C2F5A419A99999961DF234166666646912F5A416666666656DF2341666666668A2F5A419A9999994DDF2341333333D3822F5A410000000049DF2341666666667A2F5A41333333333EDF2341666666E66B2F5A4100000000AFDE2341000000806A2F5A419A9999997BDE2341CDCCCC2C6A2F5A419A9999996ADE2341000000C0692F5A419A9999992ADE2341666666C6662F5A41000000002FDE2341333333F3672F5A413333333330DE234100000020692F5A41666666662EDE2341333333736A2F5A416666666621DE2341666666A6702F5A4100000000F9DD234166666626842F5A41CDCCCCCCF2DD234166666666872F5A419A999999B3DD234133333333A62F5A4133333333B1DD2341333333F3A72F5A4166666666ACDD23419A999939AB2F5A419A999999ABDD2341CDCCCC8CC22F5A41	01060000206A080000010000000103000000010000000F0000009A999999ABDD2341CDCCCC8CC22F5A4133333333B3DD234166666626D42F5A41CDCCCCCCA1DE23419A9999B9CC2F5A416666666677DE23419A999999BA2F5A41000000009BDF234133333313AE2F5A419A99999970DF23419A9999999C2F5A419A9999994DDF2341333333D3822F5A41333333333EDF2341666666E66B2F5A419A9999996ADE2341000000C0692F5A419A9999992ADE2341666666C6662F5A41666666662EDE2341333333736A2F5A419A999999B3DD234133333333A62F5A4166666666ACDD23419A999939AB2F5A419A999999ABDD2341CDCCCC8CC22F5A419A999999ABDD2341CDCCCC8CC22F5A41	01010000206A0800003CC80CD99CDE234166666666A12F5A41	751093303	H	Saint-Georges 3	7510933	75109	75	11	0
01060000206A080000010000000103000000010000003100000000000000E1DB234133333373F32F5A4166666666F1DB234100000000F62F5A41CDCCCCCC39DC234166666666FF2F5A416666666667DC23419A9999F9FC2F5A419A9999999FDC234166666666FA2F5A4133333333F6DC234100000080F62F5A41CDCCCCCC71DD234133333373F02F5A4133333333CEDD234133333353EC2F5A419A999999C4DD2341333333B3E32F5A4133333333B3DD234166666626D42F5A4133333333ACDD2341333333F3CD2F5A41CDCCCCCCABDD234100000020C62F5A419A999999ABDD2341CDCCCCACC32F5A419A999999ABDD2341CDCCCC8CC22F5A4166666666ACDD23419A999939AB2F5A4133333333B1DD2341333333F3A72F5A419A999999B3DD234133333333A62F5A41CDCCCCCCF2DD234166666666872F5A4100000000F9DD234166666626842F5A416666666621DE2341666666A6702F5A41666666662EDE2341333333736A2F5A413333333330DE234100000020692F5A41000000002FDE2341333333F3672F5A419A9999992ADE2341666666C6662F5A416666666610DE2341000000E0632F5A419A999999F8DD2341666666C6612F5A4166666666EADD23419A9999D9602F5A419A999999DBDD23419A999919602F5A4100000000CADD2341CDCCCCCC5F2F5A419A999999B5DD2341000000A05F2F5A4133333333A1DD2341CDCCCCAC5F2F5A410000000098DD2341333333D35F2F5A410000000090DD234133333313602F5A419A99999981DD2341666666A6602F5A419A99999960DD2341CDCCCC2C622F5A410000000056DD234133333313672F5A413333333354DD234133333333692F5A416666666620DD23419A9999197D2F5A41000000000CDD23419A9999D9842F5A419A999999EDDC2341000000208E2F5A41CDCCCCCC9EDC234100000020A62F5A41CDCCCCCC7BDC23419A9999D9B02F5A416666666666DC2341333333D3B92F5A413333333359DC234166666666BF2F5A41333333332DDC2341000000E0D12F5A41CDCCCCCC16DC234166666646DC2F5A410000000015DC234100000020DD2F5A419A999999FDDB23419A9999D9E62F5A4100000000E1DB234133333373F32F5A41	01060000206A080000010000000103000000010000001100000000000000E1DB234133333373F32F5A41CDCCCCCC39DC234166666666FF2F5A4133333333CEDD234133333353EC2F5A4133333333ACDD2341333333F3CD2F5A4166666666ACDD23419A999939AB2F5A419A999999B3DD234133333333A62F5A41666666662EDE2341333333736A2F5A419A9999992ADE2341666666C6662F5A419A999999DBDD23419A999919602F5A410000000098DD2341333333D35F2F5A419A99999960DD2341CDCCCC2C622F5A413333333354DD234133333333692F5A41000000000CDD23419A9999D9842F5A41CDCCCCCC7BDC23419A9999D9B02F5A41333333332DDC2341000000E0D12F5A4100000000E1DB234133333373F32F5A4100000000E1DB234133333373F32F5A41	01010000206A080000C6F113A418DD23419A999909AE2F5A41	751093304	H	Saint-Georges 4	7510933	75109	75	11	0
01060000206A080000010000000103000000010000002A000000333333331BDB234133333353872F5A41666666661BDB234133333313892F5A41333333331FDB23419A9999799F2F5A41CDCCCCCC24DB2341333333F3B72F5A41CDCCCCCC24DB234166666686B82F5A413333333325DB234133333373B92F5A41666666662DDB234133333353CF2F5A41000000002FDB2341CDCCCC6CD92F5A419A99999932DB234100000080E62F5A41333333333FDB23419A99991913305A416666666641DB2341333333D31B305A41CDCCCCCC41DB23419A9999391C305A419A99999941DB2341333333D31C305A413333333343DB2341CDCCCC2C23305A41CDCCCCCC5CDB23416666662624305A413333333369DB23419A99999924305A41333333337BDB2341666666A620305A41000000007FDB2341000000201D305A4100000000A3DB23419A9999390E305A419A999999B5DB23416666668605305A4100000000BADB23419A99997903305A4166666666DDDB2341CDCCCC2CF52F5A4100000000E1DB234133333373F32F5A419A999999FDDB23419A9999D9E62F5A410000000015DC234100000020DD2F5A41CDCCCCCC16DC234166666646DC2F5A41333333332DDC2341000000E0D12F5A413333333359DC234166666666BF2F5A416666666666DC2341333333D3B92F5A41CDCCCCCC7BDC23419A9999D9B02F5A41CDCCCCCC9EDC234100000020A62F5A419A999999EDDC2341000000208E2F5A41000000000CDD23419A9999D9842F5A416666666620DD23419A9999197D2F5A413333333354DD234133333333692F5A410000000056DD234133333313672F5A419A99999960DD2341CDCCCC2C622F5A416666666652DD234166666606632F5A416666666697DC2341CDCCCC8C6E2F5A41CDCCCCCCB3DB2341000000607D2F5A419A99999951DB2341666666C6832F5A41333333331BDB234133333353872F5A41	01060000206A080000010000000103000000010000000E000000333333331BDB234133333353872F5A413333333325DB234133333373B92F5A413333333343DB2341CDCCCC2C23305A413333333369DB23419A99999924305A41000000007FDB2341000000201D305A4166666666DDDB2341CDCCCC2CF52F5A41333333332DDC2341000000E0D12F5A41CDCCCCCC7BDC23419A9999D9B02F5A41000000000CDD23419A9999D9842F5A413333333354DD234133333333692F5A419A99999960DD2341CDCCCC2C622F5A416666666697DC2341CDCCCC8C6E2F5A41333333331BDB234133333353872F5A41333333331BDB234133333353872F5A41	01010000206A080000A5146C53B8DB2341CCCCCC5CC72F5A41	751093305	H	Saint-Georges 5	7510933	75109	75	11	0
01060000206A08000001000000010300000001000000240000003333333369DB23419A99999924305A41CDCCCCCC7CDB23413333335325305A413333333398DB23413333335326305A419A999999ABDB2341CDCCCC0C27305A4100000000D0DB2341666666062A305A419A99999900DC2341000000C02F305A41CDCCCCCCA1DC23419A99995942305A4100000000B0DC23419A99997941305A419A9999996ADD23416666666637305A416666666617DE2341666666462F305A419A99999935DE23419A9999D92D305A41333333332EDE2341333333D32A305A41333333332EDE23413333339329305A41CDCCCCCC32DE2341CDCCCC4C28305A41CDCCCCCC3ADE2341CDCCCC4C27305A410000000044DE23419A9999D926305A41CDCCCCCC3ADE23419A9999B923305A41666666660FDE2341CDCCCCEC0F305A4133333333F9DD2341CDCCCC0C06305A4100000000E9DD2341333333F3FD2F5A4100000000D9DD234166666606F62F5A4133333333CEDD234133333353EC2F5A41CDCCCCCC71DD234133333373F02F5A4133333333F6DC234100000080F62F5A419A9999999FDC234166666666FA2F5A416666666667DC23419A9999F9FC2F5A41CDCCCCCC39DC234166666666FF2F5A4166666666F1DB234100000000F62F5A4100000000E1DB234133333373F32F5A4166666666DDDB2341CDCCCC2CF52F5A4100000000BADB23419A99997903305A419A999999B5DB23416666668605305A4100000000A3DB23419A9999390E305A41000000007FDB2341000000201D305A41333333337BDB2341666666A620305A413333333369DB23419A99999924305A41	01060000206A08000001000000010300000001000000100000003333333369DB23419A99999924305A419A999999ABDB2341CDCCCC0C27305A4100000000D0DB2341666666062A305A41CDCCCCCCA1DC23419A99995942305A419A9999996ADD23416666666637305A419A99999935DE23419A9999D92D305A41333333332EDE23413333339329305A410000000044DE23419A9999D926305A4133333333F9DD2341CDCCCC0C06305A4100000000D9DD234166666606F62F5A4133333333CEDD234133333353EC2F5A41CDCCCCCC39DC234166666666FF2F5A4100000000E1DB234133333373F32F5A41000000007FDB2341000000201D305A413333333369DB23419A99999924305A413333333369DB23419A99999924305A41	01010000206A080000DF930F68D6DC23416666668616305A41	751093306	H	Saint-Georges 6	7510933	75109	75	11	0
01060000206A080000010000000103000000010000001700000033333333B3DD234166666626D42F5A419A999999C4DD2341333333B3E32F5A4133333333CEDD234133333353EC2F5A4100000000D9DD234166666606F62F5A4100000000E9DD2341333333F3FD2F5A4133333333F9DD2341CDCCCC0C06305A41666666660FDE2341CDCCCCEC0F305A4166666666D1DE23419A99999901305A419A999999FCDE2341CDCCCC6CFE2F5A41000000003DDF23419A999999F92F5A413333333347DF23419A9999D9F82F5A419A99999958DF234166666686F72F5A41CDCCCCCC66E0234133333373E32F5A41CDCCCCCC26E02341333333B3DB2F5A41CDCCCCCC11E0234100000080D52F5A41CDCCCCCCE8DF2341666666C6C82F5A419A999999B4DF234100000080B82F5A41000000009BDF234133333313AE2F5A413333333306DF23419A999959B42F5A416666666677DE23419A999999BA2F5A41CDCCCCCCA1DE23419A9999B9CC2F5A419A99999944DE2341CDCCCCCCCF2F5A4133333333B3DD234166666626D42F5A41	01060000206A080000010000000103000000010000000B00000033333333B3DD234166666626D42F5A4100000000D9DD234166666606F62F5A41666666660FDE2341CDCCCCEC0F305A41CDCCCCCC66E0234133333373E32F5A41CDCCCCCC26E02341333333B3DB2F5A419A999999B4DF234100000080B82F5A41000000009BDF234133333313AE2F5A416666666677DE23419A999999BA2F5A41CDCCCCCCA1DE23419A9999B9CC2F5A4133333333B3DD234166666626D42F5A4133333333B3DD234166666626D42F5A41	01010000206A080000A01E626403DF234133333393DF2F5A41	751093307	H	Saint-Georges 7	7510933	75109	75	11	0
01060000206A0800000100000001030000000100000025000000666666660FDE2341CDCCCCEC0F305A41CDCCCCCC3ADE23419A9999B923305A410000000044DE23419A9999D926305A41CDCCCCCC3ADE2341CDCCCC4C27305A41CDCCCCCC32DE2341CDCCCC4C28305A41333333332EDE23413333339329305A41333333332EDE2341333333D32A305A419A99999935DE23419A9999D92D305A410000000049DE2341333333F32C305A41CDCCCCCC4FDE2341666666A62C305A419A9999995FDE23419A9999B92B305A41CDCCCCCC75DE23419A9999792A305A419A99999990DE2341333333F328305A4100000000B6DF23413333335318305A41CDCCCCCC61E02341CDCCCC8C0E305A4100000000DEE023419A99997907305A41CDCCCCCCFBE02341333333D305305A41666666661EE12341000000E003305A41333333333CE123419A9999F902305A410000000055E123419A99993902305A419A99999941E1234100000020FE2F5A419A99999930E12341000000A0FA2F5A410000000026E123419A999999F92F5A41000000001FE123419A999919F92F5A419A99999915E12341666666C6F82F5A41333333330BE123419A9999B9F82F5A410000000002E12341CDCCCCECF82F5A4166666666F7E0234100000080F72F5A41333333339CE02341333333D3EA2F5A410000000088E02341CDCCCC0CE82F5A41CDCCCCCC66E0234133333373E32F5A419A99999958DF234166666686F72F5A413333333347DF23419A9999D9F82F5A41000000003DDF23419A999999F92F5A419A999999FCDE2341CDCCCC6CFE2F5A4166666666D1DE23419A99999901305A41666666660FDE2341CDCCCCEC0F305A41	01060000206A080000010000000103000000010000000C000000666666660FDE2341CDCCCCEC0F305A410000000044DE23419A9999D926305A41333333332EDE23413333339329305A419A99999935DE23419A9999D92D305A419A9999995FDE23419A9999B92B305A41666666661EE12341000000E003305A410000000055E123419A99993902305A419A99999930E12341000000A0FA2F5A410000000002E12341CDCCCCECF82F5A41CDCCCCCC66E0234133333373E32F5A41666666660FDE2341CDCCCCEC0F305A41666666660FDE2341CDCCCCEC0F305A41	01010000206A08000025FB15EA78DF2341343333030B305A41	751093308	H	Saint-Georges 8	7510933	75109	75	11	0
01060000206A0800000100000001030000000100000016000000000000009BDF234133333313AE2F5A419A999999B4DF234100000080B82F5A41CDCCCCCCE8DF2341666666C6C82F5A41CDCCCCCC11E0234100000080D52F5A41CDCCCCCC26E02341333333B3DB2F5A41CDCCCCCC66E0234133333373E32F5A410000000088E02341CDCCCC0CE82F5A41333333339CE02341333333D3EA2F5A4166666666F7E0234100000080F72F5A410000000002E12341CDCCCCECF82F5A413333333304E12341666666C6F62F5A41CDCCCCCC4EE12341CDCCCCECDA2F5A419A9999990EE1234166666606C22F5A41CDCCCCCCFEE02341CDCCCCECBB2F5A41CDCCCCCCE1E02341666666A6B02F5A419A999999CEE023419A999939A92F5A4166666666C5E02341666666A6A52F5A41CDCCCCCCDDE02341000000A0A12F5A4133333333C1E0234100000080A22F5A416666666697E0234166666626A42F5A416666666683E02341666666E6A42F5A41000000009BDF234133333313AE2F5A41	01060000206A080000010000000103000000010000000A000000000000009BDF234133333313AE2F5A419A999999B4DF234100000080B82F5A41CDCCCCCC26E02341333333B3DB2F5A41CDCCCCCC66E0234133333373E32F5A410000000002E12341CDCCCCECF82F5A41CDCCCCCC4EE12341CDCCCCECDA2F5A4166666666C5E02341666666A6A52F5A41CDCCCCCCDDE02341000000A0A12F5A41000000009BDF234133333313AE2F5A41000000009BDF234133333313AE2F5A41	01010000206A0800003516A4DA96E0234133333323CF2F5A41	751093309	H	Saint-Georges 9	7510933	75109	75	11	0
01060000206A08000001000000010300000001000000210000000000000002E12341CDCCCCECF82F5A41333333330BE123419A9999B9F82F5A419A99999915E12341666666C6F82F5A41000000001FE123419A999919F92F5A410000000026E123419A999999F92F5A419A99999930E12341000000A0FA2F5A419A99999941E1234100000020FE2F5A410000000055E123419A99993902305A410000000059E123410000002002305A410000000067E12341333333B301305A413333333359E2234166666686FA2F5A41666666665AE22341CDCCCC0CFA2F5A419A9999995EE22341666666C6F82F5A413333333362E22341000000C0F72F5A413333333365E2234100000040F72F5A419A9999996BE2234133333373F62F5A41666666666DE22341CDCCCC4CF52F5A41CDCCCCCC70E22341CDCCCC8CF32F5A419A99999981E2234166666646EC2F5A413333333383E22341CDCCCCACEB2F5A41CDCCCCCC86E2234133333353EA2F5A4133333333B5E22341666666A6D82F5A4166666666BAE22341666666A6D62F5A4100000000BEE2234166666646D52F5A4100000000C3E22341666666C6D32F5A41CDCCCCCCD9E22341000000A0CC2F5A41CDCCCCCCBBE22341CDCCCC6CBF2F5A4100000000B0E2234166666606BA2F5A419A9999999AE223419A9999F9AF2F5A419A9999990EE1234166666606C22F5A41CDCCCCCC4EE12341CDCCCCECDA2F5A413333333304E12341666666C6F62F5A410000000002E12341CDCCCCECF82F5A41	01060000206A080000010000000103000000010000000B0000000000000002E12341CDCCCCECF82F5A419A99999930E12341000000A0FA2F5A410000000055E123419A99993902305A413333333359E2234166666686FA2F5A4100000000BEE2234166666646D52F5A41CDCCCCCCD9E22341000000A0CC2F5A419A9999999AE223419A9999F9AF2F5A419A9999990EE1234166666606C22F5A41CDCCCCCC4EE12341CDCCCCECDA2F5A410000000002E12341CDCCCCECF82F5A410000000002E12341CDCCCCECF82F5A41	01010000206A0800006A315F0AFFE123419A9999C9D92F5A41	751093310	H	Saint-Georges 10	7510933	75109	75	11	0
01060000206A080000010000000103000000010000001B00000000000000EBDA234133333353472F5A41CDCCCCCCF1DA2341666666E6482F5A416666666601DB2341CDCCCC6C4D2F5A410000000007DB234133333373502F5A41000000000BDB23419A999919592F5A416666666612DB2341666666E6722F5A413333333313DB2341666666E6742F5A41333333331BDB234133333353872F5A419A99999951DB2341666666C6832F5A41CDCCCCCCB3DB2341000000607D2F5A416666666697DC2341CDCCCC8C6E2F5A416666666652DD234166666606632F5A419A99999960DD2341CDCCCC2C622F5A416666666667DD234133333393602F5A419A9999996DDD2341333333135E2F5A410000000071DD2341333333935B2F5A416666666673DD23419A9999D9572F5A416666666649DD234166666646562F5A413333333339DD23419A9999B9552F5A4166666666F2DC234100000020532F5A4100000000ABDC234100000080512F5A41CDCCCCCC5CDC23419A9999B94F2F5A4100000000FADB23419A9999794D2F5A41333333338FDB2341CDCCCC0C4B2F5A410000000073DB2341666666664A2F5A413333333327DB2341CDCCCCAC482F5A4100000000EBDA234133333353472F5A41	01060000206A080000010000000103000000010000000900000000000000EBDA234133333353472F5A410000000007DB234133333373502F5A41333333331BDB234133333353872F5A416666666697DC2341CDCCCC8C6E2F5A419A99999960DD2341CDCCCC2C622F5A416666666673DD23419A9999D9572F5A4166666666F2DC234100000020532F5A4100000000EBDA234133333353472F5A4100000000EBDA234133333353472F5A41	01010000206A080000F052233302DC23419A9999C9682F5A41	751093311	A	Saint-Georges 11	7510933	75109	75	11	0
01060000206A0800000100000001030000000100000013000000CDCCCCCCAADE234133333333FE2E5A419A999999CBDF2341CDCCCC6CF62E5A419A999999EEDF234100000080F52E5A410000000021E0234166666646F42E5A416666666677E0234166666626F22E5A410000000011E12341CDCCCCCCED2E5A4166666666E1E0234166666606D52E5A4166666666DDE02341666666E6D42E5A41CDCCCCCCCEE02341CDCCCC6CD42E5A41CDCCCCCCB8E023419A9999B9D32E5A419A99999931E0234166666686CF2E5A416666666686DF23419A9999B9C92E5A41333333336DDF2341333333F3C82E5A41000000002DDF23419A9999F9C62E5A419A99999917DF2341666666E6CF2E5A4166666666FFDE23419A9999F9D92E5A4166666666F5DE2341CDCCCC4CE12E5A4133333333B1DE234100000060FC2E5A41CDCCCCCCAADE234133333333FE2E5A41	01060000206A0800000100000001030000000100000008000000CDCCCCCCAADE234133333333FE2E5A410000000011E12341CDCCCCCCED2E5A4166666666E1E0234166666606D52E5A41000000002DDF23419A9999F9C62E5A4166666666FFDE23419A9999F9D92E5A4166666666F5DE2341CDCCCC4CE12E5A41CDCCCCCCAADE234133333333FE2E5A41CDCCCCCCAADE234133333333FE2E5A41	01010000206A0800004C090653F5DF2341CDCCCC8CE72E5A41	751093401	A	Chaussée d'Antin 1	7510934	75109	75	11	0
01060000206A080000010000000103000000010000001100000066666666BEDC234100000040B82E5A416666666622DD2341CDCCCC8CDE2E5A41000000006CDD2341000000E0FB2E5A413333333377DD23419A999939062F5A4100000000C2DD234100000040042F5A41CDCCCCCC70DE2341000000A0FF2E5A41CDCCCCCCAADE234133333333FE2E5A4133333333B1DE234100000060FC2E5A4166666666F5DE2341CDCCCC4CE12E5A4166666666FFDE23419A9999F9D92E5A419A99999917DF2341666666E6CF2E5A41000000002DDF23419A9999F9C62E5A41000000003DDE2341CDCCCC8CBF2E5A41CDCCCCCCFBDD2341666666C6BD2E5A4133333333D0DC234100000060B42E5A4133333333C6DC234133333313B42E5A4166666666BEDC234100000040B82E5A41	01060000206A080000010000000103000000010000000C00000066666666BEDC234100000040B82E5A416666666622DD2341CDCCCC8CDE2E5A41000000006CDD2341000000E0FB2E5A413333333377DD23419A999939062F5A41CDCCCCCCAADE234133333333FE2E5A4166666666F5DE2341CDCCCC4CE12E5A4166666666FFDE23419A9999F9D92E5A41000000002DDF23419A9999F9C62E5A41CDCCCCCCFBDD2341666666C6BD2E5A4133333333C6DC234133333313B42E5A4166666666BEDC234100000040B82E5A4166666666BEDC234100000040B82E5A41	01010000206A08000015A32E5A0CDE234134333343DC2E5A41	751093402	A	Chaussée d'Antin 2	7510934	75109	75	11	0
01060000206A080000010000000103000000010000001D0000009A9999996DDA234133333393A12E5A41CDCCCCCC7ADA2341CDCCCCCCAF2E5A41000000008DDA23419A9999F9BC2E5A4133333333D7DA23419A9999B9F02E5A41CDCCCCCCDDDA234133333373F52E5A4133333333DFDA234166666686F72E5A4133333333DDDA234133333333F82E5A4166666666D8DA2341333333D3F82E5A419A999999D0DA23419A999999F92E5A4100000000C9DA234166666606FA2E5A4166666666EDDA2341CDCCCC2C042F5A41000000000BDB2341333333730C2F5A41CDCCCCCC17DB234166666626122F5A41666666661CDB234166666646162F5A413333333329DB2341CDCCCCEC152F5A413333333375DB2341333333D3132F5A41CDCCCCCCDDDB234133333313112F5A41666666669EDC2341333333F30B2F5A41CDCCCCCCF2DC2341000000C0092F5A413333333377DD23419A999939062F5A41000000006CDD2341000000E0FB2E5A416666666622DD2341CDCCCC8CDE2E5A4166666666BEDC234100000040B82E5A4133333333C6DC234133333313B42E5A419A99999947DC23419A9999D9AF2E5A413333333338DC23419A999959AF2E5A4100000000A4DB2341333333D3AA2E5A4100000000CEDA2341CDCCCC8CA42E5A419A9999996DDA234133333393A12E5A41	01060000206A080000010000000103000000010000000E0000009A9999996DDA234133333393A12E5A41CDCCCCCC7ADA2341CDCCCCCCAF2E5A41CDCCCCCCDDDA234133333373F52E5A4100000000C9DA234166666606FA2E5A41000000000BDB2341333333730C2F5A41666666661CDB234166666646162F5A413333333377DD23419A999939062F5A41000000006CDD2341000000E0FB2E5A416666666622DD2341CDCCCC8CDE2E5A4166666666BEDC234100000040B82E5A4133333333C6DC234133333313B42E5A413333333338DC23419A999959AF2E5A419A9999996DDA234133333393A12E5A419A9999996DDA234133333393A12E5A41	01010000206A080000AAA9BDD1CDDB2341343333C3CD2E5A41	751093403	A	Chaussée d'Antin 3	7510934	75109	75	11	0
01060000206A08000001000000010300000001000000160000003333333310DB23419A999959212F5A41CDCCCCCC4BDB234133333373212F5A416666666697DB234133333393212F5A41CDCCCCCCE6DB2341CDCCCCAC212F5A4100000000FBDB2341333333B3212F5A4100000000AEDC234100000000222F5A41666666663DDD234133333333222F5A410000000093DD234133333353222F5A41CDCCCCCC85DD2341333333F3142F5A413333333384DD234133333353132F5A416666666684DD2341333333B3112F5A413333333377DD23419A999939062F5A41CDCCCCCCF2DC2341000000C0092F5A41666666669EDC2341333333F30B2F5A41CDCCCCCCDDDB234133333313112F5A413333333375DB2341333333D3132F5A413333333329DB2341CDCCCCEC152F5A41666666661CDB234166666646162F5A41CDCCCCCC1ADB23419A9999D9172F5A413333333319DB2341666666C6192F5A413333333317DB2341333333F31B2F5A413333333310DB23419A999959212F5A41	01060000206A08000001000000010300000001000000060000003333333310DB23419A999959212F5A410000000093DD234133333353222F5A413333333377DD23419A999939062F5A41666666661CDB234166666646162F5A413333333310DB23419A999959212F5A413333333310DB23419A999959212F5A41	01010000206A0800004DB6640B73DC234133333363142F5A41	751093404	A	Chaussée d'Antin 4	7510934	75109	75	11	0
01060000206A08000001000000010300000001000000140000003333333377DD23419A999939062F5A416666666684DD2341333333B3112F5A413333333384DD234133333353132F5A41CDCCCCCC85DD2341333333F3142F5A410000000093DD234133333353222F5A41666666665EDE234133333373232F5A419A99999905DF23419A9999B9222F5A41CDCCCCCC3CDF23419A999979222F5A41CDCCCCCC5EDF23419A999959222F5A4133333333D6DF23419A9999D9212F5A41CDCCCCCCD9DF2341666666A6102F5A4166666666DFDF234133333373022F5A41CDCCCCCCE0DF234100000020002F5A41CDCCCCCCE2DF2341333333F3FA2E5A419A999999EEDF234100000080F52E5A419A999999CBDF2341CDCCCC6CF62E5A41CDCCCCCCAADE234133333333FE2E5A41CDCCCCCC70DE2341000000A0FF2E5A4100000000C2DD234100000040042F5A413333333377DD23419A999939062F5A41	01060000206A08000001000000010300000001000000080000003333333377DD23419A999939062F5A410000000093DD234133333353222F5A41666666665EDE234133333373232F5A4133333333D6DF23419A9999D9212F5A41CDCCCCCCE2DF2341333333F3FA2E5A419A999999EEDF234100000080F52E5A413333333377DD23419A999939062F5A413333333377DD23419A999939062F5A41	01010000206A080000A9819E86ACDE2341000000700B2F5A41	751093405	A	Chaussée d'Antin 5	7510934	75109	75	11	0
01060000206A080000010000000103000000010000001200000033333333D6DF23419A9999D9212F5A41CDCCCCCC8BE0234100000080202F5A4100000000DBE02341CDCCCCEC1F2F5A41CDCCCCCCEEE023419A9999591E2F5A410000000014E12341333333F31F2F5A419A9999992BE12341666666661F2F5A419A99999972E12341CDCCCCCC1E2F5A413333333348E12341333333130A2F5A419A99999931E123419A999919FF2E5A410000000011E12341CDCCCCCCED2E5A416666666677E0234166666626F22E5A410000000021E0234166666646F42E5A419A999999EEDF234100000080F52E5A41CDCCCCCCE2DF2341333333F3FA2E5A41CDCCCCCCE0DF234100000020002F5A4166666666DFDF234133333373022F5A41CDCCCCCCD9DF2341666666A6102F5A4133333333D6DF23419A9999D9212F5A41	01060000206A080000010000000103000000010000000700000033333333D6DF23419A9999D9212F5A419A99999972E12341CDCCCCCC1E2F5A410000000011E12341CDCCCCCCED2E5A419A999999EEDF234100000080F52E5A41CDCCCCCCE2DF2341333333F3FA2E5A4133333333D6DF23419A9999D9212F5A4133333333D6DF23419A9999D9212F5A41	01010000206A080000B17E721F8FE0234133333343062F5A41	751093406	A	Chaussée d'Antin 6	7510934	75109	75	11	0
01060000206A0800000100000001030000000100000023000000CDCCCCCCCDDF2341000000603C2F5A41CDCCCCCCD8DF2341333333D3472F5A4100000000E5DF23419A999919552F5A4133333333E6DF234166666686572F5A41CDCCCCCCE6DF234133333333582F5A4133333333F5DF2341000000A0692F5A41666666667FE023419A999919672F5A416666666693E02341666666C6662F5A419A999999A8E02341CDCCCC6C662F5A419A999999E2E023419A999959662F5A41CDCCCCCCE6E0234133333373662F5A419A99999973E12341CDCCCC6C692F5A419A99999987E12341333333B3692F5A419A99999997E12341666666C6692F5A4100000000B4E1234166666686692F5A419A999999DDE12341333333B3682F5A416666666622E223419A999959672F5A41666666662FE2234166666606662F5A410000000005E22341666666C6502F5A4133333333D8E1234166666666512F5A41CDCCCCCCA7E123419A999959392F5A419A999999A0E12341333333B3352F5A413333333396E1234133333373302F5A41000000007FE12341000000E0242F5A419A99999972E12341CDCCCCCC1E2F5A419A9999992BE12341666666661F2F5A410000000014E12341333333F31F2F5A41CDCCCCCCEEE023419A9999591E2F5A4100000000DBE02341CDCCCCEC1F2F5A41CDCCCCCC8BE0234100000080202F5A4133333333D6DF23419A9999D9212F5A4133333333D1DF23419A9999592E2F5A419A999999D0DF234166666666312F5A4100000000D0DF2341CDCCCCCC332F5A41CDCCCCCCCDDF2341000000603C2F5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCCCDDF2341000000603C2F5A4133333333F5DF2341000000A0692F5A419A999999A8E02341CDCCCC6C662F5A419A999999E2E023419A999959662F5A419A99999973E12341CDCCCC6C692F5A4100000000B4E1234166666686692F5A416666666622E223419A999959672F5A41666666662FE2234166666606662F5A410000000005E22341666666C6502F5A4133333333D8E1234166666666512F5A419A99999972E12341CDCCCCCC1E2F5A4133333333D6DF23419A9999D9212F5A41CDCCCCCCCDDF2341000000603C2F5A41CDCCCCCCCDDF2341000000603C2F5A41	01010000206A0800004F59C55AC6E023419A999919422F5A41	751093407	A	Chaussée d'Antin 7	7510934	75109	75	11	0
01060000206A080000010000000103000000010000002B0000009A99999960DD2341CDCCCC2C622F5A419A99999981DD2341666666A6602F5A410000000090DD234133333313602F5A410000000098DD2341333333D35F2F5A4133333333A1DD2341CDCCCCAC5F2F5A419A999999B5DD2341000000A05F2F5A4100000000CADD2341CDCCCCCC5F2F5A419A999999DBDD23419A999919602F5A4166666666EADD23419A9999D9602F5A419A999999F8DD2341666666C6612F5A416666666610DE2341000000E0632F5A419A9999992ADE2341666666C6662F5A419A9999996ADE2341000000C0692F5A419A9999997BDE2341CDCCCC2C6A2F5A4100000000AFDE2341000000806A2F5A41333333333EDF2341666666E66B2F5A4133333333F5DF2341000000A0692F5A41CDCCCCCCE6DF234133333333582F5A4133333333E6DF234166666686572F5A4100000000E5DF23419A999919552F5A41CDCCCCCCD8DF2341333333D3472F5A41CDCCCCCCCDDF2341000000603C2F5A4100000000D0DF2341CDCCCCCC332F5A419A999999D0DF234166666666312F5A4133333333D1DF23419A9999592E2F5A4133333333D6DF23419A9999D9212F5A41CDCCCCCC5EDF23419A999959222F5A41CDCCCCCC3CDF23419A999979222F5A419A99999905DF23419A9999B9222F5A41666666665EDE234133333373232F5A410000000093DD234133333353222F5A413333333399DD2341000000002D2F5A41666666669DDD2341CDCCCCAC322F5A41CDCCCCCC9FDD2341CDCCCCEC352F5A419A999999A1DD23419A999939382F5A4133333333A1DD2341CDCCCC0C3A2F5A41333333339FDD2341CDCCCC2C3B2F5A410000000099DD2341000000C03E2F5A416666666673DD23419A9999D9572F5A410000000071DD2341333333935B2F5A419A9999996DDD2341333333135E2F5A416666666667DD234133333393602F5A419A99999960DD2341CDCCCC2C622F5A41	01060000206A080000010000000103000000010000000F0000009A99999960DD2341CDCCCC2C622F5A410000000098DD2341333333D35F2F5A419A999999DBDD23419A999919602F5A419A9999992ADE2341666666C6662F5A419A9999996ADE2341000000C0692F5A41333333333EDF2341666666E66B2F5A4133333333F5DF2341000000A0692F5A41CDCCCCCCCDDF2341000000603C2F5A4133333333D6DF23419A9999D9212F5A41666666665EDE234133333373232F5A410000000093DD234133333353222F5A419A999999A1DD23419A999939382F5A416666666673DD23419A9999D9572F5A419A99999960DD2341CDCCCC2C622F5A419A99999960DD2341CDCCCC2C622F5A41	01010000206A080000A0176252B3DE23419A999949432F5A41	751093408	A	Chaussée d'Antin 8	7510934	75109	75	11	0
01060000206A080000010000000103000000010000002100000066666666E6DA234133333313422F5A4100000000E7DA2341000000A0442F5A4100000000EBDA234133333353472F5A413333333327DB2341CDCCCCAC482F5A410000000073DB2341666666664A2F5A41333333338FDB2341CDCCCC0C4B2F5A4100000000FADB23419A9999794D2F5A41CDCCCCCC5CDC23419A9999B94F2F5A4100000000ABDC234100000080512F5A4166666666F2DC234100000020532F5A413333333339DD23419A9999B9552F5A416666666649DD234166666646562F5A416666666673DD23419A9999D9572F5A410000000099DD2341000000C03E2F5A41333333339FDD2341CDCCCC2C3B2F5A4133333333A1DD2341CDCCCC0C3A2F5A419A999999A1DD23419A999939382F5A41CDCCCCCC9FDD2341CDCCCCEC352F5A41666666669DDD2341CDCCCCAC322F5A413333333399DD2341000000002D2F5A410000000093DD234133333353222F5A41666666663DDD234133333333222F5A4100000000AEDC234100000000222F5A4100000000FBDB2341333333B3212F5A41CDCCCCCCE6DB2341CDCCCCAC212F5A416666666697DB234133333393212F5A41CDCCCCCC4BDB234133333373212F5A413333333310DB23419A999959212F5A4166666666F5DA234166666666332F5A419A999999F4DA234133333313342F5A4166666666EFDA234166666606392F5A41CDCCCCCCE8DA2341000000803F2F5A4166666666E6DA234133333313422F5A41	01060000206A080000010000000103000000010000000A00000066666666E6DA234133333313422F5A4100000000EBDA234133333353472F5A4166666666F2DC234100000020532F5A416666666673DD23419A9999D9572F5A419A999999A1DD23419A999939382F5A410000000093DD234133333353222F5A413333333310DB23419A999959212F5A4166666666F5DA234166666666332F5A4166666666E6DA234133333313422F5A4166666666E6DA234133333313422F5A41	01010000206A0800006F3045BE43DC2341666666F63C2F5A41	751093409	A	Chaussée d'Antin 9	7510934	75109	75	11	0
01060000206A080000010000000103000000010000002700000033333333EFE32341333333F31A2F5A4166666666FDE423419A9999991A2F5A41CDCCCCCC59E523419A9999591A2F5A41CDCCCCCC5FE523419A9999591A2F5A413333333396E52341666666461A2F5A419A9999999DE52341666666461A2F5A413333333347E62341000000001A2F5A41666666668CE62341666666E6192F5A419A999999B6E62341333333D3192F5A413333333313E72341CDCCCCAC192F5A410000000011E7234100000040092F5A419A9999990FE7234133333333FF2E5A41CDCCCCCC0DE723419A9999B9EE2E5A41CDCCCCCC0DE7234133333333E32E5A41000000000EE723419A9999D9E12E5A419A9999990DE72341333333B3CE2E5A419A9999990FE7234133333313BD2E5A41666666668DE62341CDCCCC0CC12E5A419A99999962E623419A999979C22E5A4166666666F6E52341000000E0C52E5A419A999999CEE5234100000040C72E5A419A99999977E4234100000060D22E5A410000000047E423419A9999F9D32E5A41CDCCCCCC50E4234166666686D92E5A41CDCCCCCC56E4234133333393DD2E5A413333333359E42341CDCCCCCCDF2E5A41666666665BE423419A999959E22E5A41666666665DE4234133333373E52E5A419A9999995EE42341333333D3E82E5A419A9999995EE42341CDCCCC0CED2E5A41333333335BE4234133333313F52E5A419A9999994EE42341333333D3FC2E5A41CDCCCCCC4AE42341CDCCCC2CFF2E5A419A99999949E42341666666E6FF2E5A413333333348E4234133333313012F5A419A99999932E423419A9999190D2F5A41CDCCCCCC0DE42341CDCCCCAC142F5A413333333308E42341333333D3152F5A4133333333EFE32341333333F31A2F5A41	01060000206A080000010000000103000000010000000B00000033333333EFE32341333333F31A2F5A413333333313E72341CDCCCCAC192F5A41CDCCCCCC0DE723419A9999B9EE2E5A419A9999990FE7234133333313BD2E5A41666666668DE62341CDCCCC0CC12E5A410000000047E423419A9999F9D32E5A41666666665BE423419A999959E22E5A41333333335BE4234133333313F52E5A419A99999932E423419A9999190D2F5A4133333333EFE32341333333F31A2F5A4133333333EFE32341333333F31A2F5A41	01010000206A08000034333333B6E52341000000F0EA2E5A41	751093501	H	Faubourg Montmartre 1	7510935	75109	75	11	0
01060000206A08000001000000010300000001000000200000009A99999972E12341CDCCCCCC1E2F5A41000000007FE12341000000E0242F5A413333333396E1234133333373302F5A419A999999A0E12341333333B3352F5A41CDCCCCCCA7E123419A999959392F5A4133333333D8E1234166666666512F5A410000000005E22341666666C6502F5A41666666662FE2234166666606662F5A410000000040E2234166666666642F5A419A999999D2E223419A999979622F5A41333333334FE323419A999959612F5A4100000000FCE32341333333F35F2F5A413333333363E42341000000A0602F5A419A999999BCE423419A999979602F5A41333333330EE52341CDCCCC2C602F5A4100000000FDE423419A9999795C2F5A419A999999D4E4234100000020552F5A41CDCCCCCCB0E42341000000804E2F5A4133333333A8E42341666666464C2F5A41333333339AE42341666666A6482F5A410000000085E4234133333393432F5A41333333336FE423419A9999793E2F5A4166666666E1E32341CDCCCCCC1C2F5A41CDCCCCCCE7E32341333333F31B2F5A4133333333EFE32341333333F31A2F5A41CDCCCCCCE3E32341333333F31A2F5A419A999999F6E22341CDCCCC6C1C2F5A41CDCCCCCC68E223419A9999391D2F5A410000000067E22341000000401D2F5A41CDCCCCCC63E22341666666461D2F5A41CDCCCCCC08E22341666666C61D2F5A419A99999972E12341CDCCCCCC1E2F5A41	01060000206A080000010000000103000000010000000E0000009A99999972E12341CDCCCCCC1E2F5A4133333333D8E1234166666666512F5A410000000005E22341666666C6502F5A41666666662FE2234166666606662F5A410000000040E2234166666666642F5A419A999999D2E223419A999979622F5A4100000000FCE32341333333F35F2F5A413333333363E42341000000A0602F5A41333333330EE52341CDCCCC2C602F5A41CDCCCCCCB0E42341000000804E2F5A4166666666E1E32341CDCCCCCC1C2F5A4133333333EFE32341333333F31A2F5A419A99999972E12341CDCCCCCC1E2F5A419A99999972E12341CDCCCCCC1E2F5A41	01010000206A080000EE2441AC18E3234166666606412F5A41	751093502	H	Faubourg Montmartre 2	7510935	75109	75	11	0
01060000206A080000010000000103000000010000002800000066666666E1E32341CDCCCCCC1C2F5A41333333336FE423419A9999793E2F5A410000000085E4234133333393432F5A41333333339AE42341666666A6482F5A4133333333A8E42341666666464C2F5A41CDCCCCCCB0E42341000000804E2F5A419A999999D4E4234100000020552F5A4100000000FDE423419A9999795C2F5A41333333330EE52341CDCCCC2C602F5A419A9999993EE523419A999979602F5A410000000086E5234133333393602F5A4166666666CDE52341666666A6602F5A419A99999911E62341000000C0602F5A410000000015E62341CDCCCCAC5F2F5A41000000001AE62341CDCCCC2C5E2F5A413333333352E62341CDCCCCAC602F5A41CDCCCCCCBEE62341666666C6652F5A4166666666CDE62341000000A0622F5A41CDCCCCCCD1E6234133333313622F5A4100000000DAE62341000000E0612F5A413333333388E72341000000E0612F5A419A99999980E72341CDCCCC6C5F2F5A413333333359E723419A9999F9522F5A410000000053E72341CDCCCC8C502F5A413333333346E723419A9999B94A2F5A41CDCCCCCC3BE723419A999959422F5A41333333332BE723419A999939312F5A410000000019E72341666666A6202F5A413333333313E72341CDCCCCAC192F5A419A999999B6E62341333333D3192F5A41666666668CE62341666666E6192F5A413333333347E62341000000001A2F5A419A9999999DE52341666666461A2F5A413333333396E52341666666461A2F5A41CDCCCCCC5FE523419A9999591A2F5A41CDCCCCCC59E523419A9999591A2F5A4166666666FDE423419A9999991A2F5A4133333333EFE32341333333F31A2F5A41CDCCCCCCE7E32341333333F31B2F5A4166666666E1E32341CDCCCCCC1C2F5A41	01060000206A080000010000000103000000010000000E00000066666666E1E32341CDCCCCCC1C2F5A41CDCCCCCCB0E42341000000804E2F5A41333333330EE52341CDCCCC2C602F5A419A99999911E62341000000C0602F5A41000000001AE62341CDCCCC2C5E2F5A41CDCCCCCCBEE62341666666C6652F5A4100000000DAE62341000000E0612F5A413333333388E72341000000E0612F5A413333333359E723419A9999F9522F5A41CDCCCCCC3BE723419A999959422F5A413333333313E72341CDCCCCAC192F5A4133333333EFE32341333333F31A2F5A4166666666E1E32341CDCCCCCC1C2F5A4166666666E1E32341CDCCCCCC1C2F5A41	01010000206A080000066DAEB3D8E523419A999969402F5A41	751093503	H	Faubourg Montmartre 3	7510935	75109	75	11	0
01060000206A080000010000000103000000010000002500000066666666E1E0234166666606D52E5A410000000011E12341CDCCCCCCED2E5A419A99999931E123419A999919FF2E5A413333333348E12341333333130A2F5A419A99999972E12341CDCCCCCC1E2F5A41CDCCCCCC08E22341666666C61D2F5A41CDCCCCCC63E22341666666461D2F5A410000000067E22341000000401D2F5A41CDCCCCCC68E223419A9999391D2F5A419A999999F6E22341CDCCCC6C1C2F5A41CDCCCCCCE3E32341333333F31A2F5A4133333333EFE32341333333F31A2F5A413333333308E42341333333D3152F5A41CDCCCCCC0DE42341CDCCCCAC142F5A419A99999932E423419A9999190D2F5A413333333348E4234133333313012F5A419A99999949E42341666666E6FF2E5A41CDCCCCCC4AE42341CDCCCC2CFF2E5A419A9999994EE42341333333D3FC2E5A41333333335BE4234133333313F52E5A419A9999995EE42341CDCCCC0CED2E5A419A9999995EE42341333333D3E82E5A41666666665DE4234133333373E52E5A41666666665BE423419A999959E22E5A413333333359E42341CDCCCCCCDF2E5A41CDCCCCCC56E4234133333393DD2E5A41CDCCCCCC50E4234166666686D92E5A410000000047E423419A9999F9D32E5A41000000009BE32341CDCCCC8CD92E5A41CDCCCCCC75E32341CDCCCCCCDA2E5A41666666668EE223419A9999F9E12E5A416666666651E2234166666626E02E5A4100000000FBE1234133333393DD2E5A413333333390E1234133333373DA2E5A413333333368E123419A999939D92E5A41CDCCCCCC3CE12341000000E0D72E5A4166666666E1E0234166666606D52E5A41	01060000206A080000010000000103000000010000000B00000066666666E1E0234166666606D52E5A419A99999931E123419A999919FF2E5A419A99999972E12341CDCCCCCC1E2F5A4133333333EFE32341333333F31A2F5A419A99999932E423419A9999190D2F5A41333333335BE4234133333313F52E5A41666666665BE423419A999959E22E5A410000000047E423419A9999F9D32E5A41666666668EE223419A9999F9E12E5A4166666666E1E0234166666606D52E5A4166666666E1E0234166666606D52E5A41	01010000206A0800006B149B74BDE22341333333F3F82E5A41	751093504	A	Faubourg Montmartre 4	7510935	75109	75	11	0
01060000206A0800000100000001030000000100000022000000333333330EE52341CDCCCC2C602F5A419A9999992AE52341000000406C2F5A41000000002BE523419A9999796C2F5A41333333333CE52341666666A6762F5A41666666664CE5234133333333802F5A41CDCCCCCC72E52341CDCCCCCC912F5A4166666666A0E52341666666269E2F5A419A999999FFE523419A9999F9992F5A416666666652E62341666666869E2F5A4133333333BCE6234133333353A42F5A4166666666C3E623419A9999B9A42F5A419A9999997FE623419A999919852F5A41CDCCCCCCA7E6234133333333832F5A41CDCCCCCCB0E62341CDCCCCCC822F5A4133333333B5E623419A999999822F5A4133333333BCE6234166666646822F5A4166666666C4E62341666666E6812F5A419A999999C8E72341CDCCCC4C782F5A4133333333BAE723419A999919742F5A419A999999B9E7234166666626722F5A41CDCCCCCCA2E72341333333736A2F5A413333333388E72341000000E0612F5A4100000000DAE62341000000E0612F5A41CDCCCCCCD1E6234133333313622F5A4166666666CDE62341000000A0622F5A41CDCCCCCCBEE62341666666C6652F5A413333333352E62341CDCCCCAC602F5A41000000001AE62341CDCCCC2C5E2F5A410000000015E62341CDCCCCAC5F2F5A419A99999911E62341000000C0602F5A4166666666CDE52341666666A6602F5A410000000086E5234133333393602F5A419A9999993EE523419A999979602F5A41333333330EE52341CDCCCC2C602F5A41	01060000206A0800000100000001030000000100000011000000333333330EE52341CDCCCC2C602F5A419A9999992AE52341000000406C2F5A41666666664CE5234133333333802F5A41CDCCCCCC72E52341CDCCCCCC912F5A4166666666A0E52341666666269E2F5A419A999999FFE523419A9999F9992F5A4166666666C3E623419A9999B9A42F5A419A9999997FE623419A999919852F5A4166666666C4E62341666666E6812F5A419A999999C8E72341CDCCCC4C782F5A413333333388E72341000000E0612F5A4100000000DAE62341000000E0612F5A41CDCCCCCCBEE62341666666C6652F5A41000000001AE62341CDCCCC2C5E2F5A419A99999911E62341000000C0602F5A41333333330EE52341CDCCCC2C602F5A41333333330EE52341CDCCCC2C602F5A41	01010000206A0800003014B7D814E62341CCCCCC0C812F5A41	751093601	H	Rochechouart 1	7510936	75109	75	11	0
01060000206A0800000100000001030000000100000014000000333333334FE323419A999959612F5A41CDCCCCCC57E3234166666626622F5A419A999999A8E3234133333373692F5A419A999999A9E32341CDCCCC8C692F5A419A999999D7E323419A9999B96D2F5A419A999999E3E32341666666C6752F5A4100000000F5E32341666666A6812F5A41CDCCCCCC22E42341666666C6912F5A41333333336EE42341333333B3AB2F5A4166666666A0E52341666666269E2F5A41CDCCCCCC72E52341CDCCCCCC912F5A41666666664CE5234133333333802F5A41333333333CE52341666666A6762F5A41000000002BE523419A9999796C2F5A419A9999992AE52341000000406C2F5A41333333330EE52341CDCCCC2C602F5A419A999999BCE423419A999979602F5A413333333363E42341000000A0602F5A4100000000FCE32341333333F35F2F5A41333333334FE323419A999959612F5A41	01060000206A080000010000000103000000010000000D000000333333334FE323419A999959612F5A419A999999D7E323419A9999B96D2F5A4100000000F5E32341666666A6812F5A41333333336EE42341333333B3AB2F5A4166666666A0E52341666666269E2F5A41CDCCCCCC72E52341CDCCCCCC912F5A41666666664CE5234133333333802F5A419A9999992AE52341000000406C2F5A41333333330EE52341CDCCCC2C602F5A413333333363E42341000000A0602F5A4100000000FCE32341333333F35F2F5A41333333334FE323419A999959612F5A41333333334FE323419A999959612F5A41	01010000206A0800006F58FB86B6E42341666666B6892F5A41	751093602	H	Rochechouart 2	7510936	75109	75	11	0
01060000206A08000001000000010300000001000000110000009A999999E5E2234100000040702F5A413333333302E32341666666A67D2F5A41CDCCCCCC2DE32341333333D38E2F5A419A99999947E3234133333313992F5A419A99999957E323419A9999599F2F5A41CDCCCCCC26E32341333333B3AB2F5A41000000004BE32341666666C6B82F5A419A9999998FE3234133333393B52F5A4166666666E7E32341333333B3B12F5A41CDCCCCCC2DE4234133333393AE2F5A41333333336EE42341333333B3AB2F5A41CDCCCCCC22E42341666666C6912F5A4100000000F5E32341666666A6812F5A419A999999E3E32341666666C6752F5A419A999999D7E323419A9999B96D2F5A419A999999A9E32341CDCCCC8C692F5A419A999999E5E2234100000040702F5A41	01060000206A080000010000000103000000010000000B0000009A999999E5E2234100000040702F5A413333333302E32341666666A67D2F5A419A99999957E323419A9999599F2F5A41CDCCCCCC26E32341333333B3AB2F5A41000000004BE32341666666C6B82F5A41333333336EE42341333333B3AB2F5A4100000000F5E32341666666A6812F5A419A999999D7E323419A9999B96D2F5A419A999999A9E32341CDCCCC8C692F5A419A999999E5E2234100000040702F5A419A999999E5E2234100000040702F5A41	01010000206A080000F0DAC50FA8E32341CCCCCC4C902F5A41	751093603	H	Rochechouart 3	7510936	75109	75	11	0
01060000206A08000001000000010300000001000000170000006666666622E223419A999959672F5A410000000039E2234166666626762F5A41666666664EE22341CDCCCCEC832F5A41333333336AE22341000000C0952F5A41000000007EE2234133333393A22F5A419A9999999AE223419A9999F9AF2F5A4100000000B0E2234166666606BA2F5A41CDCCCCCCBBE22341CDCCCC6CBF2F5A41000000004BE32341666666C6B82F5A41CDCCCCCC26E32341333333B3AB2F5A419A99999957E323419A9999599F2F5A419A99999947E3234133333313992F5A41CDCCCCCC2DE32341333333D38E2F5A413333333302E32341666666A67D2F5A419A999999E5E2234100000040702F5A419A999999A9E32341CDCCCC8C692F5A419A999999A8E3234133333373692F5A41CDCCCCCC57E3234166666626622F5A41333333334FE323419A999959612F5A419A999999D2E223419A999979622F5A410000000040E2234166666666642F5A41666666662FE2234166666606662F5A416666666622E223419A999959672F5A41	01060000206A080000010000000103000000010000000D0000006666666622E223419A999959672F5A41000000007EE2234133333393A22F5A41CDCCCCCCBBE22341CDCCCC6CBF2F5A41000000004BE32341666666C6B82F5A41CDCCCCCC26E32341333333B3AB2F5A419A99999957E323419A9999599F2F5A413333333302E32341666666A67D2F5A419A999999E5E2234100000040702F5A419A999999A9E32341CDCCCC8C692F5A41333333334FE323419A999959612F5A410000000040E2234166666666642F5A416666666622E223419A999959672F5A416666666622E223419A999959672F5A41	01010000206A080000015059A8CDE223419A999949922F5A41	751093604	H	Rochechouart 4	7510936	75109	75	11	0
01060000206A080000010000000103000000010000000F000000CDCCCCCCBBE22341CDCCCC6CBF2F5A41CDCCCCCCD9E22341000000A0CC2F5A419A99999945E4234166666666C72F5A4166666666BEE4234166666686C52F5A41333333338DE5234166666686BC2F5A4166666666C8E52341CDCCCCECB92F5A413333333301E623419A999919B72F5A4100000000E2E5234100000000AF2F5A4166666666A0E52341666666269E2F5A41333333336EE42341333333B3AB2F5A41CDCCCCCC2DE4234133333393AE2F5A4166666666E7E32341333333B3B12F5A419A9999998FE3234133333393B52F5A41000000004BE32341666666C6B82F5A41CDCCCCCCBBE22341CDCCCC6CBF2F5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCBBE22341CDCCCC6CBF2F5A41CDCCCCCCD9E22341000000A0CC2F5A419A99999945E4234166666666C72F5A4166666666BEE4234166666686C52F5A41333333338DE5234166666686BC2F5A4166666666C8E52341CDCCCCECB92F5A413333333301E623419A999919B72F5A4100000000E2E5234100000000AF2F5A4166666666A0E52341666666269E2F5A41333333336EE42341333333B3AB2F5A41CDCCCCCC2DE4234133333393AE2F5A4166666666E7E32341333333B3B12F5A419A9999998FE3234133333393B52F5A41000000004BE32341666666C6B82F5A41CDCCCCCCBBE22341CDCCCC6CBF2F5A41	01010000206A080000039275AED7E42341333333A3B32F5A41	751093605	H	Rochechouart 5	7510936	75109	75	11	0
01060000206A080000010000000103000000010000001C00000066666666A0E52341666666269E2F5A4100000000E2E5234100000000AF2F5A413333333301E623419A999919B72F5A419A999999D6E6234133333373B32F5A413333333394E723419A999939B02F5A410000000008E82341CDCCCCCCB62F5A419A9999990CE8234133333313B72F5A41CDCCCCCC0BE82341333333B3B62F5A4133333333F1E7234166666626AA2F5A41CDCCCCCCE9E72341CDCCCCCCA62F5A4166666666E2E7234100000040A02F5A4133333333DAE7234166666686982F5A419A999999D7E72341CDCCCC6C942F5A41CDCCCCCCD4E72341666666868E2F5A41CDCCCCCCD0E723419A9999F9842F5A419A999999CEE72341CDCCCC0C7B2F5A419A999999C8E72341CDCCCC4C782F5A4166666666C4E62341666666E6812F5A4133333333BCE6234166666646822F5A4133333333B5E623419A999999822F5A41CDCCCCCCB0E62341CDCCCCCC822F5A41CDCCCCCCA7E6234133333333832F5A419A9999997FE623419A999919852F5A4166666666C3E623419A9999B9A42F5A4133333333BCE6234133333353A42F5A416666666652E62341666666869E2F5A419A999999FFE523419A9999F9992F5A4166666666A0E52341666666269E2F5A41	01060000206A080000010000000103000000010000000E00000066666666A0E52341666666269E2F5A413333333301E623419A999919B72F5A413333333394E723419A999939B02F5A419A9999990CE8234133333313B72F5A41CDCCCCCCE9E72341CDCCCCCCA62F5A4133333333DAE7234166666686982F5A419A999999CEE72341CDCCCC0C7B2F5A419A999999C8E72341CDCCCC4C782F5A4166666666C4E62341666666E6812F5A419A9999997FE623419A999919852F5A4166666666C3E623419A9999B9A42F5A419A999999FFE523419A9999F9992F5A4166666666A0E52341666666269E2F5A4166666666A0E52341666666269E2F5A41	01010000206A0800002C86F9DF3EE723419A999979962F5A41	751093606	H	Rochechouart 6	7510936	75109	75	11	0
01060000206A08000001000000010300000001000000100000003333333301E623419A999919B72F5A41CDCCCCCC1BE623419A999979BF2F5A41333333332AE6234133333333C52F5A41CDCCCCCC3BE62341666666C6CD2F5A416666666648E6234100000080D82F5A416666666660E62341CDCCCC6CF52F5A416666666661E623419A9999B9F62F5A419A99999962E6234166666606F82F5A41000000003CE8234166666626DE2F5A419A9999993DE8234166666686D12F5A419A99999935E82341333333D3CC2F5A419A9999990CE8234133333313B72F5A410000000008E82341CDCCCCCCB62F5A413333333394E723419A999939B02F5A419A999999D6E6234133333373B32F5A413333333301E623419A999919B72F5A41	01060000206A080000010000000103000000010000000B0000003333333301E623419A999919B72F5A41CDCCCCCC1BE623419A999979BF2F5A41CDCCCCCC3BE62341666666C6CD2F5A416666666648E6234100000080D82F5A419A99999962E6234166666606F82F5A41000000003CE8234166666626DE2F5A419A9999993DE8234166666686D12F5A419A9999990CE8234133333313B72F5A413333333394E723419A999939B02F5A413333333301E623419A999919B72F5A413333333301E623419A999919B72F5A41	01010000206A080000360DFCBA40E7234133333303D52F5A41	751093607	H	Rochechouart 7	7510936	75109	75	11	0
01060000206A080000010000000103000000010000001900000066666666BAE22341666666A6D62F5A416666666607E323419A999959D92F5A413333333309E4234166666666E22F5A41666666661CE52341CDCCCC0CEC2F5A41CDCCCCCC25E5234166666666EC2F5A419A99999928E52341CDCCCC2CEB2F5A419A99999957E52341333333D3EC2F5A419A9999997AE52341CDCCCC0CEE2F5A416666666677E5234100000060EF2F5A419A99999962E6234166666606F82F5A416666666661E623419A9999B9F62F5A416666666660E62341CDCCCC6CF52F5A416666666648E6234100000080D82F5A41CDCCCCCC3BE62341666666C6CD2F5A41333333332AE6234133333333C52F5A41CDCCCCCC1BE623419A999979BF2F5A413333333301E623419A999919B72F5A4166666666C8E52341CDCCCCECB92F5A41333333338DE5234166666686BC2F5A4166666666BEE4234166666686C52F5A419A99999945E4234166666666C72F5A41CDCCCCCCD9E22341000000A0CC2F5A4100000000C3E22341666666C6D32F5A4100000000BEE2234166666646D52F5A4166666666BAE22341666666A6D62F5A41	01060000206A080000010000000103000000010000000E00000066666666BAE22341666666A6D62F5A41CDCCCCCC25E5234166666666EC2F5A419A99999928E52341CDCCCC2CEB2F5A419A9999997AE52341CDCCCC0CEE2F5A416666666677E5234100000060EF2F5A419A99999962E6234166666606F82F5A416666666648E6234100000080D82F5A41CDCCCCCC3BE62341666666C6CD2F5A41CDCCCCCC1BE623419A999979BF2F5A413333333301E623419A999919B72F5A4166666666BEE4234166666686C52F5A41CDCCCCCCD9E22341000000A0CC2F5A4166666666BAE22341666666A6D62F5A4166666666BAE22341666666A6D62F5A41	01010000206A080000C6AEE40B8EE4234133333393D72F5A41	751093608	H	Rochechouart 8	7510936	75109	75	11	0
01060000206A08000001000000010300000001000000240000003333333359E2234166666686FA2F5A416666666675E22341CDCCCCACF92F5A41000000007EE22341CDCCCC6CF92F5A4133333333BBE32341CDCCCCCC04305A41333333333EE423410000008009305A41CDCCCCCCD7E42341666666060F305A41333333332FE52341CDCCCC2C12305A410000000071E62341666666C61D305A410000000093E62341000000001F305A413333333391E623419A9999B919305A416666666690E623410000006017305A416666666689E62341CDCCCC2C14305A410000000074E623413333337304305A419A99999973E623416666662604305A419A99999962E6234166666606F82F5A416666666677E5234100000060EF2F5A419A9999997AE52341CDCCCC0CEE2F5A419A99999957E52341333333D3EC2F5A419A99999928E52341CDCCCC2CEB2F5A41CDCCCCCC25E5234166666666EC2F5A41666666661CE52341CDCCCC0CEC2F5A413333333309E4234166666666E22F5A416666666607E323419A999959D92F5A4166666666BAE22341666666A6D62F5A4133333333B5E22341666666A6D82F5A41CDCCCCCC86E2234133333353EA2F5A413333333383E22341CDCCCCACEB2F5A419A99999981E2234166666646EC2F5A41CDCCCCCC70E22341CDCCCC8CF32F5A41666666666DE22341CDCCCC4CF52F5A419A9999996BE2234133333373F62F5A413333333365E2234100000040F72F5A413333333362E22341000000C0F72F5A419A9999995EE22341666666C6F82F5A41666666665AE22341CDCCCC0CFA2F5A413333333359E2234166666686FA2F5A41	01060000206A080000010000000103000000010000000C0000003333333359E2234166666686FA2F5A41000000007EE22341CDCCCC6CF92F5A410000000093E62341000000001F305A416666666689E62341CDCCCC2C14305A419A99999962E6234166666606F82F5A416666666677E5234100000060EF2F5A419A9999997AE52341CDCCCC0CEE2F5A419A99999928E52341CDCCCC2CEB2F5A41CDCCCCCC25E5234166666666EC2F5A4166666666BAE22341666666A6D62F5A413333333359E2234166666686FA2F5A413333333359E2234166666686FA2F5A41	01010000206A08000007D909DDC7E4234166666656FF2F5A41	751093609	H	Rochechouart 9	7510936	75109	75	11	0
01060000206A08000001000000010300000001000000160000009A99999962E6234166666606F82F5A419A99999973E623416666662604305A410000000074E623413333337304305A416666666689E62341CDCCCC2C14305A416666666690E623410000006017305A413333333391E623419A9999B919305A410000000093E62341000000001F305A4166666666AAE623419A9999791F305A41CDCCCCCCC3E623419A9999F91F305A4133333333F1E623410000000021305A419A999999B6E723419A99997925305A41CDCCCCCCC1E723419A9999B925305A4100000000EFE723419A9999B926305A41666666660AE823410000004027305A41CDCCCCCC0BE823413333333324305A41333333330CE823410000002024305A41CDCCCCCC1DE82341CDCCCC6C20305A41CDCCCCCC22E82341CDCCCC0C12305A410000000028E823410000000003305A416666666628E823419A99999902305A41000000003CE8234166666626DE2F5A419A99999962E6234166666606F82F5A41	01060000206A08000001000000010300000001000000090000009A99999962E6234166666606F82F5A416666666689E62341CDCCCC2C14305A410000000093E62341000000001F305A41666666660AE823410000004027305A41CDCCCCCC1DE82341CDCCCC6C20305A410000000028E823410000000003305A41000000003CE8234166666626DE2F5A419A99999962E6234166666606F82F5A419A99999962E6234166666606F82F5A41	01010000206A0800008CAB1FF44CE72341CDCCCCCC02305A41	751093610	H	Rochechouart 10	7510936	75109	75	11	0
01060000206A080000010000000103000000010000003700000066666666F0EE23416666662637305A4100000000F1EE2341CDCCCC0C38305A41CDCCCCCCF0EE23419A99995938305A41CDCCCCCCF0EE23416666666638305A41CDCCCCCC46EF23410000004038305A419A99999982EF2341CDCCCC2C38305A41CDCCCCCC8CEF23416666662638305A41CDCCCCCC9CEF23419A99991938305A4166666666B5EF23416666660638305A4100000000B8EF23416666660638305A41CDCCCCCCD0EF2341333333F337305A41CDCCCCCCE1EF2341CDCCCCEC37305A4133333333F6EF2341000000E037305A41CDCCCCCCFBEF23419A9999D937305A41000000000BF02341333333D337305A410000000040F02341666666C637305A416666666661F02341CDCCCCAC37305A413333333388F023416666668637305A4133333333A1F023413333335337305A4100000000C8F02341CDCCCCCC36305A416666666619F12341666666A635305A41CDCCCCCC1EF123413333339335305A419A999999B5F12341000000C033305A413333333300F223419A9999B932305A413333333317F223416666666632305A41333333335CF223413333337331305A413333333367F22341CDCCCC4C31305A41CDCCCCCC51F223419A9999F92E305A41666666664AF223419A9999592D305A416666666645F22341666666462C305A419A99999938F223419A9999B92A305A410000000016F223419A99997927305A4166666666CEF123410000004021305A41CDCCCCCC8CF12341CDCCCC6C1B305A410000000049F12341CDCCCCAC15305A4100000000EFF023419A9999D90D305A419A9999990EF023419A999919FA2F5A41CDCCCCCCFCEF23419A999999F72F5A4133333333F8EF234100000020F82F5A4100000000E8EF2341333333B3F92F5A4100000000E2EF23419A999939FA2F5A4133333333D1EF2341CDCCCCECFB2F5A416666666667EF2341333333D306305A410000000052EF2341CDCCCC4C09305A419A99999945EF2341666666860A305A419A9999993DEF2341CDCCCC4C0B305A410000000036EF2341CDCCCC0C0C305A419A99999917EF2341333333530F305A419A99999904EF23419A9999B911305A4133333333FFEE23410000002018305A41CDCCCCCCF9EE23419A9999F92C305A4133333333F8EE23419A9999D932305A4166666666F5EE23416666660634305A4166666666F3EE2341CDCCCCEC34305A4166666666F0EE23416666662637305A41	01060000206A080000010000000103000000010000000C00000066666666F0EE23416666662637305A41CDCCCCCCF0EE23416666666638305A4133333333A1F023413333335337305A413333333367F22341CDCCCC4C31305A410000000016F223419A99997927305A419A9999990EF023419A999919FA2F5A41CDCCCCCCFCEF23419A999999F72F5A416666666667EF2341333333D306305A419A99999904EF23419A9999B911305A4133333333F8EE23419A9999D932305A4166666666F0EE23416666662637305A4166666666F0EE23416666662637305A41	01010000206A0800001ECAC6D62BF02341666666E616305A41	751103709	H	Saint-Vincent de Paul 9	7511037	75110	75	11	0
01060000206A080000010000000103000000010000003A0000003333333398EC23419A9999D9562F5A41CDCCCCCC9DEC23419A9999995B2F5A41CDCCCCCC9FEC23419A9999B95D2F5A419A999999A6EC23419A9999F95F2F5A41CDCCCCCCB7EC23419A9999D9652F5A4100000000F6EC234166666686792F5A413333333302ED2341666666E67D2F5A410000000009ED2341666666E6802F5A419A99999911ED23419A9999D9832F5A416666666627ED2341333333F3902F5A419A99999935ED2341CDCCCC8C992F5A410000000039ED2341CDCCCCEC9B2F5A416666666647ED2341000000E0A92F5A416666666650ED23419A9999B9B32F5A416666666649ED2341666666C6B62F5A419A999999E8ED2341333333B3BE2F5A416666666618EE2341CDCCCC0CC12F5A419A9999992FEE2341CDCCCC2CC22F5A41000000004FEE2341333333B3C32F5A419A99999968EE2341333333F3C42F5A41CDCCCCCC76EE2341CDCCCCACC52F5A4166666666A1EE2341000000C0C72F5A4133333333A6EE23419A9999F9C72F5A41CDCCCCCCB5EE2341000000C0C82F5A419A999999C2EE23419A999959C92F5A4166666666CFEE234100000000CA2F5A4100000000D5EE234100000040CA2F5A419A999999E8EE23419A999939CB2F5A419A999999F5EE23419A9999D9CB2F5A419A9999990BEF2341CDCCCCECCC2F5A419A99999936EF23419A9999D9CE2F5A41CDCCCCCC4DEF234166666646C22F5A41000000005AEF23419A9999F9BD2F5A41333333335CEF234100000020BB2F5A419A9999995FEF23419A999939B32F5A416666666664EF23419A9999D9AD2F5A410000000067EF2341CDCCCC2CA82F5A416666666666EF234133333373A42F5A41CDCCCCCC63EF2341000000A0A12F5A419A9999995FEF23419A9999799F2F5A419A9999995BEF2341333333339F2F5A41666666664AEF2341666666469B2F5A413333333322EF234100000040902F5A4166666666F0EE234100000060812F5A419A999999CEEE23419A999999762F5A41666666669AEE2341CDCCCCAC662F5A41CDCCCCCC79EE2341333333D35B2F5A41000000005CEE23419A9999B9522F5A41CDCCCCCC57EE234166666666512F5A419A9999993CEE2341CDCCCCAC4B2F5A419A99999931EE2341CDCCCC0C4A2F5A41CDCCCCCC11EE23419A9999994A2F5A41000000000DEE2341CDCCCCAC4A2F5A4166666666BFED2341666666864D2F5A41333333335FED234133333393502F5A41000000000DED2341CDCCCC2C532F5A4100000000CDEC23419A999939552F5A413333333398EC23419A9999D9562F5A41	01060000206A08000001000000010300000001000000100000003333333398EC23419A9999D9562F5A41CDCCCCCC9FEC23419A9999B95D2F5A4100000000F6EC234166666686792F5A419A99999911ED23419A9999D9832F5A410000000039ED2341CDCCCCEC9B2F5A416666666650ED23419A9999B9B32F5A416666666649ED2341666666C6B62F5A419A99999936EF23419A9999D9CE2F5A41000000005AEF23419A9999F9BD2F5A416666666666EF234133333373A42F5A41666666664AEF2341666666469B2F5A4166666666F0EE234100000060812F5A41CDCCCCCC57EE234166666666512F5A419A99999931EE2341CDCCCC0C4A2F5A413333333398EC23419A9999D9562F5A413333333398EC23419A9999D9562F5A41	01010000206A080000ED9027AE14EE2341CDCCCC0C8A2F5A41	751103710	A	Saint-Vincent de Paul 10	7511037	75110	75	11	0
01060000206A080000010000000103000000010000001A00000066666666FBE8234133333353FC2F5A413333333310E923410000008026305A410000000011E923416666668627305A41666666660FE92341333333B32A305A419A99999913E92341000000C02A305A416666666649EA2341CDCCCCAC2E305A413333333371EB23416666664632305A41CDCCCCCCB0EB2341CDCCCC0C33305A419A9999998EEB2341000000A02F305A41666666668AEB2341000000402E305A413333333303EB2341666666E603305A41CDCCCCCCDEEA234100000060F72F5A41CDCCCCCCD0EA2341CDCCCCCCF22F5A4100000000C7EA23419A999939F12F5A4100000000C1EA23419A999999F02F5A41CDCCCCCCB9EA234166666646F02F5A41CDCCCCCCB0EA234100000040F02F5A4133333333A2EA234133333373F02F5A410000000064EA2341333333F3F12F5A4166666666E8E923419A9999F9F42F5A413333333397E92341333333D3F62F5A410000000011E92341666666C6F92F5A410000000007E9234100000020FA2F5A419A99999902E9234133333393FA2F5A4100000000FEE82341CDCCCC6CFB2F5A4166666666FBE8234133333353FC2F5A41	01060000206A080000010000000103000000010000000B00000066666666FBE8234133333353FC2F5A413333333310E923410000008026305A41666666660FE92341333333B32A305A41CDCCCCCCB0EB2341CDCCCC0C33305A419A9999998EEB2341000000A02F305A413333333303EB2341666666E603305A41CDCCCCCCD0EA2341CDCCCCCCF22F5A4133333333A2EA234133333373F02F5A410000000011E92341666666C6F92F5A4166666666FBE8234133333353FC2F5A4166666666FBE8234133333353FC2F5A41	01010000206A0800006469710C21EA23413333333315305A41	751103711	A	Saint-Vincent de Paul 11	7511037	75110	75	11	0
01060000206A08000001000000010300000001000000110000003333333364F12341666666A6C22E5A41CDCCCCCC77F2234133333393D62E5A41333333337EF2234100000000D72E5A413333333387F223419A999999D72E5A41CDCCCCCCDDF22341CDCCCCACBC2E5A41000000001FF32341CDCCCC2CA92E5A41CDCCCCCC56F3234133333373982E5A41CDCCCCCCA9F22341CDCCCC2C8C2E5A41CDCCCCCC7AF22341000000E0882E5A416666666676F2234166666686882E5A413333333355F2234133333333862E5A416666666645F22341666666268A2E5A416666666626F22341333333F3912E5A4133333333DEF12341CDCCCC0CA42E5A4100000000C3F12341333333D3AA2E5A41CDCCCCCC6AF12341CDCCCCECC02E5A413333333364F12341666666A6C22E5A41	01060000206A08000001000000010300000001000000070000003333333364F12341666666A6C22E5A413333333387F223419A999999D72E5A41CDCCCCCCDDF22341CDCCCCACBC2E5A41CDCCCCCC56F3234133333373982E5A413333333355F2234133333333862E5A413333333364F12341666666A6C22E5A413333333364F12341666666A6C22E5A41	01010000206A0800007CFADA824DF22341000000C0B32E5A41	751103901	H	Porte Saint-Martin 1	7511039	75110	75	11	0
01060000206A080000010000000103000000010000001F0000009A99999976EF234166666686CA2E5A41CDCCCCCC9CEF2341000000A0CC2E5A416666666674F02341CDCCCC2CDA2E5A41CDCCCCCC7CF02341333333B3DA2E5A416666666694F0234100000000DC2E5A419A9999999DF02341333333F3D92E5A419A999999A3F0234133333373D82E5A410000000014F1234100000080BC2E5A41CDCCCCCC16F12341CDCCCCACBB2E5A413333333359F123419A999939AB2E5A413333333386F123419A999959A02E5A41000000008AF12341666666469F2E5A4100000000FBF1234133333353842E5A4166666666FDF12341000000C0832E5A41CDCCCCCC04F2234100000000822E5A419A999999B1F123419A9999F97D2E5A419A99999979F12341CDCCCCCC7A2E5A41CDCCCCCC2FF12341CDCCCC4C762E5A419A99999912F1234100000000742E5A41CDCCCCCC7BF02341CDCCCCEC8F2E5A41CDCCCCCC5EF02341CDCCCCEC962E5A410000000044F02341CDCCCC2C9D2E5A41333333332BF0234100000000A32E5A419A99999924F0234166666686A52E5A419A9999990BF0234100000020AC2E5A419A99999902F0234166666626AD2E5A4166666666FCEF2341000000A0AE2E5A4100000000E6EF23419A999999B42E5A4133333333BCEF2341CDCCCC2CBF2E5A41333333339FEF234133333373C62E5A419A99999976EF234166666686CA2E5A41	01060000206A080000010000000103000000010000000B0000009A99999976EF234166666686CA2E5A416666666694F0234100000000DC2E5A41000000008AF12341666666469F2E5A41CDCCCCCC04F2234100000000822E5A419A999999B1F123419A9999F97D2E5A419A99999912F1234100000000742E5A41CDCCCCCC7BF02341CDCCCCEC8F2E5A419A99999902F0234166666626AD2E5A41333333339FEF234133333373C62E5A419A99999976EF234166666686CA2E5A419A99999976EF234166666686CA2E5A41	01010000206A080000F85B1966BFF0234100000060A82E5A41	751103902	H	Porte Saint-Martin 2	7511039	75110	75	11	0
01060000206A080000010000000103000000010000002B000000CDCCCCCCAAEE23419A999939B72E5A4166666666B5EE2341333333F3B92E5A4166666666B8EE2341333333B3BA2E5A419A999999C9EE234166666646BF2E5A4166666666D6EE2341CDCCCCACC12E5A416666666631EF234133333373D12E5A419A99999976EF234166666686CA2E5A41333333339FEF234133333373C62E5A4133333333BCEF2341CDCCCC2CBF2E5A4100000000E6EF23419A999999B42E5A4166666666FCEF2341000000A0AE2E5A419A99999902F0234166666626AD2E5A419A9999990BF0234100000020AC2E5A419A99999924F0234166666686A52E5A41333333332BF0234100000000A32E5A410000000044F02341CDCCCC2C9D2E5A41CDCCCCCC5EF02341CDCCCCEC962E5A41CDCCCCCC7BF02341CDCCCCEC8F2E5A419A99999912F1234100000000742E5A419A999999E9F0234133333313712E5A419A999999A4F02341CDCCCC2C6C2E5A41666666668BF023419A9999796A2E5A41CDCCCCCC75F02341CDCCCCCC682E5A416666666645F023419A9999B96E2E5A419A99999916F0234133333313742E5A4100000000EFEF234166666666782E5A4100000000DDEF23419A9999597A2E5A41CDCCCCCCC6EF2341CDCCCCAC7C2E5A4166666666B1EF2341333333737E2E5A419A999999A9EF2341CDCCCC4C802E5A4133333333A3EF23419A9999F9812E5A410000000098EF234133333373842E5A419A99999980EF234133333353892E5A419A99999972EF2341000000808C2E5A413333333367EF2341666666E68E2E5A413333333355EF2341000000E0922E5A416666666633EF23419A9999199A2E5A41CDCCCCCCFEEE2341CDCCCC4CA52E5A4166666666E7EE23419A999959AA2E5A41CDCCCCCCD1EE2341333333B3AE2E5A4100000000B8EE234166666666B42E5A4100000000B0EE2341CDCCCC2CB62E5A41CDCCCCCCAAEE23419A999939B72E5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCCAAEE23419A999939B72E5A419A999999C9EE234166666646BF2E5A416666666631EF234133333373D12E5A41333333339FEF234133333373C62E5A41333333332BF0234100000000A32E5A41CDCCCCCC7BF02341CDCCCCEC8F2E5A419A99999912F1234100000000742E5A41CDCCCCCC75F02341CDCCCCCC682E5A419A99999916F0234133333313742E5A4166666666B1EF2341333333737E2E5A413333333355EF2341000000E0922E5A41CDCCCCCCAAEE23419A999939B72E5A41CDCCCCCCAAEE23419A999939B72E5A41	01010000206A080000E63DD262BBEF2341343333A39B2E5A41	751103903	H	Porte Saint-Martin 3	7511039	75110	75	11	0
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	01060000206A080000010000000103000000010000001100000066666666A7EC2341000000C0922E5A4133333333D3EC2341333333B3A02E5A4166666666DAEC234133333393A02E5A416666666648ED2341333333B3C12E5A4100000000FFED2341CDCCCC2CAE2E5A419A99999975EE2341666666A6C22E5A413333333355EF2341000000E0922E5A4166666666B1EF2341333333737E2E5A419A99999916F0234133333313742E5A41CDCCCCCC75F02341CDCCCCCC682E5A41666666662EF0234166666686622E5A419A999999D9EF2341333333F36A2E5A410000000072ED2341666666C67C2E5A410000000088ED2341000000C0862E5A419A99999911ED23419A9999D98D2E5A4166666666A7EC2341000000C0922E5A4166666666A7EC2341000000C0922E5A41	01010000206A0800000A6F659F02EE23419A999999922E5A41	751103904	H	Porte Saint-Martin 4	7511039	75110	75	11	0
01060000206A080000010000000103000000010000002C0000006666666685EB234166666666942E5A41CDCCCCCCC3EB23419A9999F9A72E5A41CDCCCCCCCDEB234166666626AB2E5A413333333303EC23419A9999B9BB2E5A416666666612EC23419A9999B9C02E5A419A99999925EC23419A9999D9C62E5A41CDCCCCCC2CEC234100000000C92E5A419A99999963EC234133333373D92E5A41CDCCCCCCBEEC234166666646D02E5A4133333333EDEC23419A999959CB2E5A41CDCCCCCCFDEC234133333393C92E5A4166666666FEEC234100000080C92E5A419A99999923ED23419A999999C52E5A416666666648ED2341333333B3C12E5A413333333332ED2341333333F3BA2E5A41666666661BED2341CDCCCC0CB42E5A410000000003ED2341CDCCCCACAC2E5A419A999999ECEC23419A999919A62E5A4166666666DAEC234133333393A02E5A4133333333D3EC2341333333B3A02E5A41CDCCCCCCBDEC2341333333F3992E5A4166666666A7EC2341000000C0922E5A4133333333B6EC234133333373922E5A4133333333E3EC2341CDCCCC2C902E5A419A99999911ED23419A9999D98D2E5A419A99999946ED23419A9999998A2E5A410000000088ED2341000000C0862E5A410000000076ED2341CDCCCCCC7E2E5A410000000072ED2341666666C67C2E5A419A99999937ED2341CDCCCC8C7E2E5A4100000000E9EC23419A9999D9802E5A419A999999F6EB234100000020882E5A41CDCCCCCCC4EB23419A9999F9892E5A4166666666ACEB2341333333F38A2E5A41333333338AEB2341CDCCCC4C8C2E5A416666666688EB2341000000608C2E5A41CDCCCCCC8BEB2341333333938C2E5A413333333392EB2341CDCCCCCC8E2E5A41CDCCCCCC94EB234133333333902E5A410000000095EB23419A999959912E5A416666666692EB234100000060922E5A413333333390EB2341CDCCCCEC922E5A41000000008BEB2341CDCCCCEC932E5A416666666685EB234166666666942E5A41	01060000206A080000010000000103000000010000000F0000006666666685EB234166666666942E5A419A99999925EC23419A9999D9C62E5A419A99999963EC234133333373D92E5A416666666648ED2341333333B3C12E5A4166666666DAEC234133333393A02E5A4133333333D3EC2341333333B3A02E5A4166666666A7EC2341000000C0922E5A419A99999911ED23419A9999D98D2E5A410000000088ED2341000000C0862E5A410000000072ED2341666666C67C2E5A419A999999F6EB234100000020882E5A416666666688EB2341000000608C2E5A410000000095EB23419A999959912E5A416666666685EB234166666666942E5A416666666685EB234166666666942E5A41	01010000206A080000C0011D9960EC234100000090A92E5A41	751103905	H	Porte Saint-Martin 5	7511039	75110	75	11	0
01060000206A080000010000000103000000010000003900000066666666AEEA234133333333962E5A41CDCCCCCCEBEA234100000060AB2E5A41333333331AEB2341666666E6B92E5A41333333333FEB234133333353C52E5A41CDCCCCCC50EB2341333333D3CA2E5A413333333378EB2341000000E0D72E5A4133333333A6EB234100000020E72E5A413333333304EC23419A999979052F5A416666666605EC2341666666E6052F5A410000000007EC234100000080062F5A416666666627EC23419A9999F9122F5A41000000005DEC2341333333F3242F5A41CDCCCCCC57EC2341000000C0272F5A41CDCCCCCC52EC23419A999979282F5A41333333334CEC234100000000292F5A419A9999993FEC234133333393292F5A419A99999950EC2341333333332A2F5A419A99999960EC2341333333F32A2F5A410000000066EC2341333333B32B2F5A416666666669EC23419A9999792C2F5A41666666666EEC2341CDCCCC2C2E2F5A416666666677EC2341CDCCCC2C312F5A419A99999984EC2341000000602E2F5A419A9999999DEC2341333333B3282F5A4100000000D2EC2341CDCCCC4C1D2F5A4133333333F5EC23419A9999B9152F5A41CDCCCCCC0BED234166666626112F5A416666666603ED2341333333130E2F5A4100000000F7EC234166666686092F5A419A999999E9EC2341666666C6042F5A4100000000CBEC234133333333FB2E5A419A999999C8EC234133333353FA2E5A4100000000ACEC234100000040F12E5A419A99999988EC23419A999979E52E5A419A99999973EC2341000000A0DE2E5A419A99999963EC234133333373D92E5A41CDCCCCCC2CEC234100000000C92E5A419A99999925EC23419A9999D9C62E5A416666666612EC23419A9999B9C02E5A413333333303EC23419A9999B9BB2E5A41CDCCCCCCCDEB234166666626AB2E5A41CDCCCCCCC3EB23419A9999F9A72E5A416666666685EB234166666666942E5A41000000008BEB2341CDCCCCEC932E5A413333333390EB2341CDCCCCEC922E5A416666666692EB234100000060922E5A410000000095EB23419A999959912E5A41CDCCCCCC94EB234133333333902E5A413333333392EB2341CDCCCCCC8E2E5A41CDCCCCCC8BEB2341333333938C2E5A416666666688EB2341000000608C2E5A413333333372EB2341CDCCCC4C8D2E5A41666666665AEB2341000000608E2E5A416666666633EB234133333353902E5A416666666615EB23419A9999B9912E5A4133333333C8EA234166666626952E5A4166666666AEEA234133333333962E5A41	01060000206A080000010000000103000000010000001100000066666666AEEA234133333333962E5A41CDCCCCCCEBEA234100000060AB2E5A41CDCCCCCC50EB2341333333D3CA2E5A413333333304EC23419A999979052F5A41000000005DEC2341333333F3242F5A419A9999993FEC234133333393292F5A419A99999960EC2341333333F32A2F5A416666666677EC2341CDCCCC2C312F5A41CDCCCCCC0BED234166666626112F5A419A999999E9EC2341666666C6042F5A419A99999963EC234133333373D92E5A419A99999925EC23419A9999D9C62E5A416666666685EB234166666666942E5A410000000095EB23419A999959912E5A416666666688EB2341000000608C2E5A4166666666AEEA234133333333962E5A4166666666AEEA234133333333962E5A41	01010000206A080000EC68F37E0AEC2341CDCCCC0CE22E5A41	751103906	H	Porte Saint-Martin 6	7511039	75110	75	11	0
01060000206A08000001000000010300000001000000270000009A99999963EC234133333373D92E5A419A99999973EC2341000000A0DE2E5A419A99999988EC23419A999979E52E5A4100000000ACEC234100000040F12E5A419A999999C8EC234133333353FA2E5A4100000000CBEC234133333333FB2E5A419A999999E9EC2341666666C6042F5A4100000000F7EC234166666686092F5A416666666603ED2341333333130E2F5A41CDCCCCCC0BED234166666626112F5A41CDCCCCCC19ED2341666666060E2F5A41CDCCCCCC2AED23419A9999590A2F5A419A9999993BED23419A9999B9062F5A41333333334BED234100000060032F5A41666666665CED2341CDCCCCACFF2E5A41666666667BED2341CDCCCCACF82E5A419A999999ADED234100000000EE2E5A41CDCCCCCCD2ED234166666606E62E5A4166666666E7ED234100000080E12E5A413333333303EE2341CDCCCC6CDB2E5A41333333331DEE234100000000D62E5A413333333330EE2341666666E6D12E5A413333333340EE234133333353CE2E5A41000000004DEE234166666686CB2E5A416666666660EE234100000060C72E5A419A99999975EE2341666666A6C22E5A416666666669EE2341000000A0C02E5A41CDCCCCCC64EE2341CDCCCC0CC02E5A410000000047EE23419A999919BB2E5A41CDCCCCCC24EE2341333333D3B42E5A4100000000FFED2341CDCCCC2CAE2E5A419A999999B7ED234100000000B62E5A416666666648ED2341333333B3C12E5A419A99999923ED23419A999999C52E5A4166666666FEEC234100000080C92E5A41CDCCCCCCFDEC234133333393C92E5A4133333333EDEC23419A999959CB2E5A41CDCCCCCCBEEC234166666646D02E5A419A99999963EC234133333373D92E5A41	01060000206A08000001000000010300000001000000080000009A99999963EC234133333373D92E5A419A999999E9EC2341666666C6042F5A41CDCCCCCC0BED234166666626112F5A419A99999975EE2341666666A6C22E5A4100000000FFED2341CDCCCC2CAE2E5A41CDCCCCCCBEEC234166666646D02E5A419A99999963EC234133333373D92E5A419A99999963EC234133333373D92E5A41	01010000206A080000C58718FE32ED234100000010E02E5A41	751103907	H	Porte Saint-Martin 7	7511039	75110	75	11	0
01060000206A080000010000000103000000010000002E000000333333334BED234100000060032F5A419A99999962ED23419A999919032F5A41000000006DED23419A9999F9022F5A410000000091ED23419A999999022F5A419A999999B3ED234100000040022F5A41CDCCCCCCD0ED2341333333F3012F5A413333333321EE234100000020012F5A41CDCCCCCC76EE23419A999939002F5A41CDCCCCCCD9EE23419A9999F9FF2E5A41666666660FEF2341666666C6FF2E5A416666666654EF234133333393FF2E5A4100000000A5EF234133333373FF2E5A419A999999DDEF234100000060FF2E5A4100000000EBEF23419A9999B9FE2E5A416666666609F02341000000A0FF2E5A41CDCCCCCC17F02341000000C0FB2E5A41CDCCCCCC24F023419A999939F82E5A419A99999940F02341CDCCCC4CF12E5A416666666654F0234133333333EC2E5A410000000084F0234166666626E02E5A416666666694F0234100000000DC2E5A41CDCCCCCC7CF02341333333B3DA2E5A416666666674F02341CDCCCC2CDA2E5A41CDCCCCCC9CEF2341000000A0CC2E5A419A99999976EF234166666686CA2E5A416666666631EF234133333373D12E5A4166666666D6EE2341CDCCCCACC12E5A419A999999C9EE234166666646BF2E5A4166666666B8EE2341333333B3BA2E5A4166666666B5EE2341333333F3B92E5A41CDCCCCCCAAEE23419A999939B72E5A41CDCCCCCC95EE2341000000A0BB2E5A410000000084EE234100000060BF2E5A419A99999975EE2341666666A6C22E5A416666666660EE234100000060C72E5A41000000004DEE234166666686CB2E5A413333333340EE234133333353CE2E5A413333333330EE2341666666E6D12E5A41333333331DEE234100000000D62E5A413333333303EE2341CDCCCC6CDB2E5A4166666666E7ED234100000080E12E5A41CDCCCCCCD2ED234166666606E62E5A419A999999ADED234100000000EE2E5A41666666667BED2341CDCCCCACF82E5A41666666665CED2341CDCCCCACFF2E5A41333333334BED234100000060032F5A41	01060000206A080000010000000103000000010000000B000000333333334BED234100000060032F5A41CDCCCCCC76EE23419A999939002F5A416666666654EF234133333393FF2E5A416666666609F02341000000A0FF2E5A416666666694F0234100000000DC2E5A419A99999976EF234166666686CA2E5A416666666631EF234133333373D12E5A419A999999C9EE234166666646BF2E5A41CDCCCCCCAAEE23419A999939B72E5A41333333334BED234100000060032F5A41333333334BED234100000060032F5A41	01010000206A080000C4E3F9A241EF234133333313DE2E5A41	751103908	H	Porte Saint-Martin 8	7511039	75110	75	11	0
01060000206A080000010000000103000000010000001E0000009A9999990DF023419A999939182F5A416666666642F02341000000C0152F5A419A99999979F023419A9999F9122F5A4100000000A7F02341CDCCCCAC102F5A4133333333D6F02341666666660E2F5A413333333309F12341000000A0082F5A419A99999943F123419A999919022F5A419A9999997DF1234100000060FB2E5A419A999999C5F12341CDCCCC0CF32E5A419A999999C9F12341333333D3F12E5A41CDCCCCCCCBF1234100000040F02E5A4100000000E0F1234100000060EC2E5A41CDCCCCCC6EF2234133333353DB2E5A413333333387F223419A999999D72E5A41333333337EF2234100000000D72E5A41CDCCCCCC77F2234133333393D62E5A413333333364F12341666666A6C22E5A413333333349F1234100000080C92E5A41000000002EF1234133333393D02E5A413333333314F1234166666646D72E5A41CDCCCCCCF9F02341000000C0DD2E5A4133333333D1F02341333333F3E72E5A4166666666A8F023419A9999D9F12E5A419A99999985F023419A999999FA2E5A410000000069F0234166666646012F5A413333333358F0234100000040052F5A419A99999924F0234166666666112F5A416666666619F0234100000020142F5A41CDCCCCCC10F02341666666C6162F5A419A9999990DF023419A999939182F5A41	01060000206A080000010000000103000000010000000C0000009A9999990DF023419A999939182F5A4133333333D6F02341666666660E2F5A419A999999C5F12341CDCCCC0CF32E5A4100000000E0F1234100000060EC2E5A41CDCCCCCC6EF2234133333353DB2E5A413333333387F223419A999999D72E5A413333333364F12341666666A6C22E5A413333333314F1234166666646D72E5A419A99999985F023419A999999FA2E5A416666666619F0234100000020142F5A419A9999990DF023419A999939182F5A419A9999990DF023419A999939182F5A41	01010000206A080000081F7C7046F1234100000050EE2E5A41	751103909	H	Porte Saint-Martin 9	7511039	75110	75	11	0
01060000206A08000001000000010300000001000000380000006666666677EC2341CDCCCC2C312F5A419A99999981EC2341333333B3332F5A41333333338DEC2341666666A6352F5A413333333393EC234166666606382F5A4133333333A8EC2341CDCCCCEC402F5A4100000000CDEC23419A999939552F5A41000000000DED2341CDCCCC2C532F5A41333333335FED234133333393502F5A4166666666BFED2341666666864D2F5A410000000092ED23419A9999593E2F5A4166666666ADED2341CDCCCCCC3A2F5A4133333333BEED234166666646382F5A4133333333CAED2341666666E6362F5A4166666666F3ED23419A999919342F5A41666666662EEE23419A999959302F5A413333333338EE2341CDCCCCAC2F2F5A419A9999996DEE2341333333132C2F5A419A9999997AEE2341333333332B2F5A4133333333CCEE23419A9999B9262F5A4166666666D1EE2341CDCCCC6C262F5A4133333333E3EE23419A999999252F5A413333333310EF234133333373232F5A419A9999992EEF234100000020222F5A413333333350EF2341333333B3202F5A41CDCCCCCC63EF2341666666C61F2F5A416666666683EF2341333333531E2F5A4166666666A9EF23419A9999991C2F5A4100000000AEEF23419A999999182F5A419A999999B3EF234133333313162F5A4133333333B8EF234100000060142F5A4133333333C0EF234133333393112F5A4100000000D2EF2341000000A00C2F5A416666666609F02341000000A0FF2E5A4100000000EBEF23419A9999B9FE2E5A419A999999DDEF234100000060FF2E5A4100000000A5EF234133333373FF2E5A416666666654EF234133333393FF2E5A41666666660FEF2341666666C6FF2E5A41CDCCCCCCD9EE23419A9999F9FF2E5A41CDCCCCCC76EE23419A999939002F5A413333333321EE234100000020012F5A41CDCCCCCCD0ED2341333333F3012F5A419A999999B3ED234100000040022F5A410000000091ED23419A999999022F5A41000000006DED23419A9999F9022F5A419A99999962ED23419A999919032F5A41333333334BED234100000060032F5A419A9999993BED23419A9999B9062F5A41CDCCCCCC2AED23419A9999590A2F5A41CDCCCCCC19ED2341666666060E2F5A41CDCCCCCC0BED234166666626112F5A4133333333F5EC23419A9999B9152F5A4100000000D2EC2341CDCCCC4C1D2F5A419A9999999DEC2341333333B3282F5A419A99999984EC2341000000602E2F5A416666666677EC2341CDCCCC2C312F5A41	01060000206A08000001000000010300000001000000110000006666666677EC2341CDCCCC2C312F5A41333333338DEC2341666666A6352F5A4133333333A8EC2341CDCCCCEC402F5A4100000000CDEC23419A999939552F5A4166666666BFED2341666666864D2F5A410000000092ED23419A9999593E2F5A4133333333CAED2341666666E6362F5A419A9999997AEE2341333333332B2F5A4133333333CCEE23419A9999B9262F5A4166666666A9EF23419A9999991C2F5A4100000000D2EF2341000000A00C2F5A416666666609F02341000000A0FF2E5A416666666654EF234133333393FF2E5A41CDCCCCCC76EE23419A999939002F5A41333333334BED234100000060032F5A416666666677EC2341CDCCCC2C312F5A416666666677EC2341CDCCCC2C312F5A41	01010000206A08000033CC4BBE94ED2341333333F3292F5A41	751103910	H	Porte Saint-Martin 10	7511039	75110	75	11	0
01060000206A080000010000000103000000010000003200000000000000A5EF2341666666C61F2F5A4166666666D8EF2341CDCCCCCC1A2F5A419A9999990DF023419A999939182F5A41CDCCCCCC10F02341666666C6162F5A416666666619F0234100000020142F5A419A99999924F0234166666666112F5A413333333358F0234100000040052F5A410000000069F0234166666646012F5A419A99999985F023419A999999FA2E5A4166666666A8F023419A9999D9F12E5A4133333333D1F02341333333F3E72E5A41CDCCCCCCF9F02341000000C0DD2E5A413333333314F1234166666646D72E5A41000000002EF1234133333393D02E5A413333333349F1234100000080C92E5A413333333364F12341666666A6C22E5A41CDCCCCCC6AF12341CDCCCCECC02E5A4100000000C3F12341333333D3AA2E5A4133333333DEF12341CDCCCC0CA42E5A416666666626F22341333333F3912E5A416666666645F22341666666268A2E5A413333333355F2234133333333862E5A41CDCCCCCC35F22341CDCCCC8C842E5A419A99999924F22341000000A0832E5A41000000001CF22341CDCCCC2C832E5A41CDCCCCCC04F2234100000000822E5A4166666666FDF12341000000C0832E5A4100000000FBF1234133333353842E5A41000000008AF12341666666469F2E5A413333333386F123419A999959A02E5A413333333359F123419A999939AB2E5A41CDCCCCCC16F12341CDCCCCACBB2E5A410000000014F1234100000080BC2E5A419A999999A3F0234133333373D82E5A419A9999999DF02341333333F3D92E5A416666666694F0234100000000DC2E5A410000000084F0234166666626E02E5A416666666654F0234133333333EC2E5A419A99999940F02341CDCCCC4CF12E5A41CDCCCCCC24F023419A999939F82E5A41CDCCCCCC17F02341000000C0FB2E5A416666666609F02341000000A0FF2E5A4100000000D2EF2341000000A00C2F5A4133333333C0EF234133333393112F5A4133333333B8EF234100000060142F5A419A999999B3EF234133333313162F5A4100000000AEEF23419A999999182F5A4166666666A9EF23419A9999991C2F5A4133333333A5EF2341333333B31F2F5A4100000000A5EF2341666666C61F2F5A41	01060000206A080000010000000103000000010000000E00000000000000A5EF2341666666C61F2F5A4166666666D8EF2341CDCCCCCC1A2F5A419A9999990DF023419A999939182F5A416666666619F0234100000020142F5A419A99999985F023419A999999FA2E5A413333333314F1234166666646D72E5A41CDCCCCCC6AF12341CDCCCCECC02E5A413333333355F2234133333333862E5A41CDCCCCCC04F2234100000000822E5A413333333359F123419A999939AB2E5A4100000000D2EF2341000000A00C2F5A4100000000AEEF23419A999999182F5A4100000000A5EF2341666666C61F2F5A4100000000A5EF2341666666C61F2F5A41	01010000206A080000E268D572EBF02341CCCCCCECD32E5A41	751103988	D	Canal Saint-Martin 1	7511039	75110	75	11	0
01060000206A080000010000000103000000010000002700000000000000D8F423419A999979D82E5A416666666649F5234166666666DE2E5A419A9999995CF5234100000040DF2E5A41CDCCCCCC67F52341CDCCCCECDF2E5A41CDCCCCCCB2F5234133333313E72E5A4166666666EAF52341000000A0EC2E5A410000000044F62341CDCCCC0CF52E5A419A9999994EF62341333333F3F62E5A41333333335AF623419A9999F9F92E5A413333333360F623419A999979FB2E5A413333333373F623419A999939002F5A419A99999992F6234166666626082F5A416666666699F62341666666460A2F5A41666666669CF62341333333330B2F5A4166666666A2F62341333333730B2F5A4166666666A7F62341666666260C2F5A4100000000D0F6234100000020052F5A4166666666AEF723419A999999DE2E5A41CDCCCCCCA1F72341666666A6DD2E5A41000000004AF7234133333393D72E5A413333333332F7234100000000D62E5A416666666618F7234166666666D42E5A41CDCCCCCC14F72341CDCCCC2CD42E5A410000000001F72341666666E6D22E5A419A999999FAF6234100000080D22E5A4133333333A1F62341CDCCCCACCC2E5A410000000094F62341CDCCCCCCCB2E5A413333333364F62341333333B3C82E5A419A99999960F623419A999979C82E5A41333333333BF6234100000000C62E5A41CDCCCCCC2AF623419A9999D9C42E5A410000000016F6234133333313C32E5A416666666614F62341333333F3C22E5A41CDCCCCCCD5F52341000000E0BD2E5A4100000000B9F523419A9999B9BB2E5A419A999999A2F5234166666646BA2E5A41CDCCCCCC5FF523419A999919B62E5A41CDCCCCCC09F52341CDCCCC2CCC2E5A4100000000D8F423419A999979D82E5A41	01060000206A080000010000000103000000010000000B00000000000000D8F423419A999979D82E5A41CDCCCCCC67F52341CDCCCCECDF2E5A410000000044F62341CDCCCC0CF52E5A4166666666A7F62341666666260C2F5A4166666666AEF723419A999999DE2E5A41000000004AF7234133333393D72E5A41CDCCCCCC2AF623419A9999D9C42E5A4100000000B9F523419A9999B9BB2E5A41CDCCCCCC5FF523419A999919B62E5A4100000000D8F423419A999979D82E5A4100000000D8F423419A999979D82E5A41	01010000206A0800001C5BDAB48FF6234100000080E32E5A41	751104001	H	Hôpital Saint-Louis 1	7511040	75110	75	11	0
01060000206A08000001000000010300000001000000230000000000000014F4234133333313052F5A419A999999C5F423419A999959132F5A4166666666F2F42341CDCCCCEC162F5A413333333311F52341CDCCCC6C192F5A41CDCCCCCC3CF52341333333F31C2F5A41333333337FF523419A999939232F5A416666666691F5234133333393242F5A4133333333ACF52341000000E0232F5A419A999999CEF52341666666A6212F5A413333333309F62341666666A61D2F5A413333333311F62341333333D31D2F5A41CDCCCCCC17F62341000000601E2F5A41000000001DF623419A9999591F2F5A419A99999933F62341666666E61C2F5A416666666656F62341666666261A2F5A4100000000A0F62341CDCCCC6C0D2F5A4166666666A7F62341666666260C2F5A4166666666A2F62341333333730B2F5A41666666669CF62341333333330B2F5A416666666699F62341666666460A2F5A419A99999992F6234166666626082F5A413333333373F623419A999939002F5A413333333360F623419A999979FB2E5A41333333335AF623419A9999F9F92E5A419A9999994EF62341333333F3F62E5A410000000044F62341CDCCCC0CF52E5A4166666666EAF52341000000A0EC2E5A41CDCCCCCCB2F5234133333313E72E5A41CDCCCCCC67F52341CDCCCCECDF2E5A419A9999995CF5234100000040DF2E5A416666666649F5234166666666DE2E5A4100000000D8F423419A999979D82E5A41666666669DF42341666666E6E42E5A41666666667BF4234133333353EC2E5A410000000014F4234133333313052F5A41	01060000206A080000010000000103000000010000000E0000000000000014F4234133333313052F5A41CDCCCCCC3CF52341333333F31C2F5A416666666691F5234133333393242F5A4133333333ACF52341000000E0232F5A413333333309F62341666666A61D2F5A41000000001DF623419A9999591F2F5A416666666656F62341666666261A2F5A4166666666A7F62341666666260C2F5A410000000044F62341CDCCCC0CF52E5A41CDCCCCCC67F52341CDCCCCECDF2E5A4100000000D8F423419A999979D82E5A41666666667BF4234133333353EC2E5A410000000014F4234133333313052F5A410000000014F4234133333313052F5A41	01010000206A080000BC7935F14DF523419A9999D9FD2E5A41	751104002	H	Hôpital Saint-Louis 2	7511040	75110	75	11	0
01060000206A08000001000000010300000001000000140000009A99999973F3234100000040E02E5A41666666667BF323419A999999E12E5A41000000008AF3234100000040E52E5A4133333333BFF3234166666686FB2E5A419A999999E6F32341CDCCCC2C0C2F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A410000000014F4234133333313052F5A41666666667BF4234133333353EC2E5A41666666669DF42341666666E6E42E5A4100000000D8F423419A999979D82E5A41CDCCCCCC09F52341CDCCCC2CCC2E5A41CDCCCCCC5FF523419A999919B62E5A419A99999998F423419A9999F9AA2E5A41CDCCCCCC73F42341CDCCCCCCA82E5A41333333334FF4234133333393A62E5A416666666646F42341000000E0A82E5A4133333333FCF3234133333333BC2E5A419A999999CAF3234166666626C92E5A41CDCCCCCC96F3234133333333D62E5A419A99999973F3234100000040E02E5A41	01060000206A08000001000000010300000001000000140000009A99999973F3234100000040E02E5A41666666667BF323419A999999E12E5A41000000008AF3234100000040E52E5A4133333333BFF3234166666686FB2E5A419A999999E6F32341CDCCCC2C0C2F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A410000000014F4234133333313052F5A41666666667BF4234133333353EC2E5A41666666669DF42341666666E6E42E5A4100000000D8F423419A999979D82E5A41CDCCCCCC09F52341CDCCCC2CCC2E5A41CDCCCCCC5FF523419A999919B62E5A419A99999998F423419A9999F9AA2E5A41CDCCCCCC73F42341CDCCCCCCA82E5A41333333334FF4234133333393A62E5A416666666646F42341000000E0A82E5A4133333333FCF3234133333333BC2E5A419A999999CAF3234166666626C92E5A41CDCCCCCC96F3234133333333D62E5A419A99999973F3234100000040E02E5A41	01010000206A08000034DBCE7023F42341CDCCCC5CDC2E5A41	751104003	H	Hôpital Saint-Louis 3	7511040	75110	75	11	0
01060000206A080000010000000103000000010000000D0000003333333387F223419A999999D72E5A41666666669CF2234100000060D82E5A419A99999973F3234100000040E02E5A41CDCCCCCC96F3234133333333D62E5A419A999999CAF3234166666626C92E5A4133333333FCF3234133333333BC2E5A416666666646F42341000000E0A82E5A41333333334FF4234133333393A62E5A419A999999C0F32341CDCCCCAC9E2E5A41CDCCCCCC56F3234133333373982E5A41000000001FF32341CDCCCC2CA92E5A41CDCCCCCCDDF22341CDCCCCACBC2E5A413333333387F223419A999999D72E5A41	01060000206A080000010000000103000000010000000D0000003333333387F223419A999999D72E5A41666666669CF2234100000060D82E5A419A99999973F3234100000040E02E5A41CDCCCCCC96F3234133333333D62E5A419A999999CAF3234166666626C92E5A4133333333FCF3234133333333BC2E5A416666666646F42341000000E0A82E5A41333333334FF4234133333393A62E5A419A999999C0F32341CDCCCCAC9E2E5A41CDCCCCCC56F3234133333373982E5A41000000001FF32341CDCCCC2CA92E5A41CDCCCCCCDDF22341CDCCCCACBC2E5A413333333387F223419A999999D72E5A41	01010000206A080000CEA835F16CF3234100000070BC2E5A41	751104004	H	Hôpital Saint-Louis 4	7511040	75110	75	11	0
01060000206A0800000100000001030000000100000020000000CDCCCCCCEAF32341CDCCCCEC0E2F5A419A999999EDF323419A999919142F5A4133333333EDF32341CDCCCC6C172F5A4100000000EBF323419A999979252F5A41CDCCCCCCEDF32341CDCCCCCC372F5A419A99999967F42341CDCCCCAC2F2F5A410000000079F42341000000402E2F5A41CDCCCCCC8FF42341333333F32C2F5A419A999999BFF423419A9999192B2F5A41666666662BF523419A9999D9272F5A41CDCCCCCC8AF523419A9999F9372F5A416666666690F52341333333F3382F5A410000000091F52341CDCCCC0C392F5A4166666666A3F523419A999919392F5A4166666666C5F523419A999939332F5A416666666631F62341CDCCCC8C202F5A416666666656F62341666666261A2F5A419A99999933F62341666666E61C2F5A41000000001DF623419A9999591F2F5A41CDCCCCCC17F62341000000601E2F5A413333333311F62341333333D31D2F5A413333333309F62341666666A61D2F5A419A999999CEF52341666666A6212F5A4133333333ACF52341000000E0232F5A416666666691F5234133333393242F5A41333333337FF523419A999939232F5A41CDCCCCCC3CF52341333333F31C2F5A413333333311F52341CDCCCC6C192F5A4166666666F2F42341CDCCCCEC162F5A419A999999C5F423419A999959132F5A410000000014F4234133333313052F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCEAF32341CDCCCCEC0E2F5A41CDCCCCCCEDF32341CDCCCCCC372F5A41CDCCCCCC8FF42341333333F32C2F5A41666666662BF523419A9999D9272F5A410000000091F52341CDCCCC0C392F5A4166666666A3F523419A999919392F5A416666666656F62341666666261A2F5A41000000001DF623419A9999591F2F5A413333333309F62341666666A61D2F5A4133333333ACF52341000000E0232F5A416666666691F5234133333393242F5A41CDCCCCCC3CF52341333333F31C2F5A410000000014F4234133333313052F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A41	01010000206A080000627553899EF42341CDCCCCDC1E2F5A41	751104005	H	Hôpital Saint-Louis 5	7511040	75110	75	11	0
01060000206A08000001000000010300000001000000210000009A999999EAF22341666666E6512F5A4166666666F6F2234166666686542F5A41CDCCCCCC99F32341333333F3732F5A419A999999B5F32341666666E6782F5A4133333333CDF32341666666467C2F5A41CDCCCCCCDBF323419A9999397B2F5A41CDCCCCCCEEF323419A9999997A2F5A4166666666FCF32341666666C67A2F5A41CDCCCCCC0BF42341333333137C2F5A41CDCCCCCC0DF42341333333537C2F5A410000000018F42341333333937D2F5A410000000025F42341333333537B2F5A416666666616F52341CDCCCC8C512F5A413333333318F5234100000040512F5A41333333335FF52341CDCCCCEC442F5A4166666666A3F523419A999919392F5A410000000091F52341CDCCCC0C392F5A416666666690F52341333333F3382F5A41CDCCCCCC8AF523419A9999F9372F5A41666666662BF523419A9999D9272F5A419A999999BFF423419A9999192B2F5A41CDCCCCCC8FF42341333333F32C2F5A410000000079F42341000000402E2F5A419A99999967F42341CDCCCCAC2F2F5A41CDCCCCCCEDF32341CDCCCCCC372F5A4100000000EBF323419A999979252F5A4133333333EDF32341CDCCCC6C172F5A4166666666C5F3234166666686192F5A41CDCCCCCC4FF3234166666686382F5A419A99999949F32341000000203A2F5A416666666628F3234100000040422F5A419A999999F7F22341333333B34F2F5A419A999999EAF22341666666E6512F5A41	01060000206A080000010000000103000000010000000F0000009A999999EAF22341666666E6512F5A41CDCCCCCC99F32341333333F3732F5A4133333333CDF32341666666467C2F5A4166666666FCF32341666666C67A2F5A410000000018F42341333333937D2F5A4166666666A3F523419A999919392F5A410000000091F52341CDCCCC0C392F5A41666666662BF523419A9999D9272F5A41CDCCCCCC8FF42341333333F32C2F5A41CDCCCCCCEDF32341CDCCCCCC372F5A4133333333EDF32341CDCCCC6C172F5A4166666666C5F3234166666686192F5A419A999999F7F22341333333B34F2F5A419A999999EAF22341666666E6512F5A419A999999EAF22341666666E6512F5A41	01010000206A0800006D46E6A725F42341000000504A2F5A41	751104006	H	Hôpital Saint-Louis 6	7511040	75110	75	11	0
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	01060000206A080000010000000103000000010000001C0000009A999999FEEF2341CDCCCCEC202F5A41CDCCCCCC10F023419A9999792B2F5A41CDCCCCCC2AF023419A999979322F5A4166666666F6F02341666666E65B2F5A413333333366F123419A999919762F5A410000000091F12341CDCCCC0C7F2F5A4166666666D8F12341333333537A2F5A416666666663F22341666666E67D2F5A41CDCCCCCC88F22341CDCCCCEC842F5A4166666666ADF22341CDCCCC4C822F5A4133333333D0F22341CDCCCCAC852F5A4133333333E9F2234166666606822F5A410000000066F32341666666E6812F5A4100000000B3F323419A9999B9832F5A4100000000BAF32341000000808E2F5A419A999999D1F3234166666606922F5A4100000000EFF32341666666E6912F5A419A999999EEF32341000000C0842F5A410000000018F42341333333937D2F5A4166666666FCF32341666666C67A2F5A4133333333CDF32341666666467C2F5A41CDCCCCCC99F32341333333F3732F5A4166666666F6F2234166666686542F5A413333333350F22341333333733C2F5A4133333333D6F02341666666660E2F5A419A9999990DF023419A999939182F5A419A999999FEEF2341CDCCCCEC202F5A419A999999FEEF2341CDCCCCEC202F5A41	01010000206A08000040062AF9D1F123419A999909512F5A41	751104007	H	Hôpital Saint-Louis 7	7511040	75110	75	11	0
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	01060000206A08000001000000010300000001000000140000000000000092ED23419A9999593E2F5A4166666666BFED2341666666864D2F5A419A99999931EE2341CDCCCC0C4A2F5A41CDCCCCCC57EE234166666666512F5A41666666669AEE2341CDCCCCAC662F5A413333333322EF234100000040902F5A419A9999995BEF2341333333339F2F5A41333333337DEF2341CDCCCC8CA12F5A4166666666B4EF234133333373A82F5A419A99999996F0234100000040922F5A413333333322F12341666666067D2F5A4100000000ECEF2341000000603A2F5A4133333333CBEF234100000020342F5A4133333333A1EF23419A9999F9232F5A4166666666A9EF23419A9999991C2F5A4133333333CCEE23419A9999B9262F5A419A9999997AEE2341333333332B2F5A4133333333CAED2341666666E6362F5A410000000092ED23419A9999593E2F5A410000000092ED23419A9999593E2F5A41	01010000206A0800008AD5C38A92EF234134333383602F5A41	751104008	H	Hôpital Saint-Louis 8	7511040	75110	75	11	0
01060000206A080000010000000103000000010000001100000066666666B4EF234133333373A82F5A4166666666B8EF23419A9999F9A82F5A419A999999F0EF23419A999939B22F5A41333333333BF0234133333353BD2F5A410000000084F02341000000E0C82F5A419A99999901F12341000000E0DB2F5A41CDCCCCCC85F12341CDCCCCCCCD2F5A419A9999991CF22341666666C6BD2F5A413333333313F22341333333D3B12F5A41CDCCCCCCE7F12341333333D3A72F5A41CDCCCCCCA0F12341CDCCCCEC982F5A419A9999998DF12341333333D3942F5A413333333322F12341666666067D2F5A4133333333DAF02341CDCCCC8C882F5A419A99999996F0234100000040922F5A416666666671F02341000000E0952F5A4166666666B4EF234133333373A82F5A41	01060000206A080000010000000103000000010000001100000066666666B4EF234133333373A82F5A4166666666B8EF23419A9999F9A82F5A419A999999F0EF23419A999939B22F5A41333333333BF0234133333353BD2F5A410000000084F02341000000E0C82F5A419A99999901F12341000000E0DB2F5A41CDCCCCCC85F12341CDCCCCCCCD2F5A419A9999991CF22341666666C6BD2F5A413333333313F22341333333D3B12F5A41CDCCCCCCE7F12341333333D3A72F5A41CDCCCCCCA0F12341CDCCCCEC982F5A419A9999998DF12341333333D3942F5A413333333322F12341666666067D2F5A4133333333DAF02341CDCCCC8C882F5A419A99999996F0234100000040922F5A416666666671F02341000000E0952F5A4166666666B4EF234133333373A82F5A41	01010000206A080000F0FEE2A3E9F0234166666666AD2F5A41	751104009	H	Hôpital Saint-Louis 9	7511040	75110	75	11	0
01060000206A0800000100000001030000000100000029000000CDCCCCCCFCEF23419A999999F72F5A419A9999990EF023419A999919FA2F5A4100000000EFF023419A9999D90D305A410000000049F12341CDCCCCAC15305A41CDCCCCCC8CF12341CDCCCC6C1B305A4166666666CEF123410000004021305A410000000016F223419A99997927305A419A99999938F223419A9999B92A305A416666666645F22341666666462C305A41666666664AF223419A9999592D305A41CDCCCCCC51F223419A9999F92E305A413333333367F22341CDCCCC4C31305A419A99999983F22341333333F330305A419A99999998F22341CDCCCCAC30305A4166666666A6F223419A99997930305A4166666666B2F223410000004030305A41CDCCCCCCB9F223416666662630305A4100000000CBF22341000000C02F305A4100000000D2F22341000000802F305A419A999999D9F22341333333332F305A4100000000E0F22341666666E62E305A4100000000E7F22341000000802E305A419A999999ECF22341CDCCCC2C2E305A419A999999F2F22341000000E02D305A419A999999F7F22341000000802D305A4166666666FDF22341000000002D305A410000000003F32341CDCCCC6C2C305A41333333330CF32341000000602B305A419A9999990DF32341333333332B305A419A99999912F32341333333932A305A410000000002F32341333333B327305A4166666666C9F223410000000020305A419A9999990BF22341333333F303305A41000000005FF1234100000000EA2F5A419A99999901F12341000000E0DB2F5A41CDCCCCCCC3F02341CDCCCC4CE22F5A4100000000A8F02341666666C6E62F5A416666666675F0234100000000EC2F5A413333333341F0234133333313F12F5A419A99999915F023419A999939F52F5A41CDCCCCCCFCEF23419A999999F72F5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCCFCEF23419A999999F72F5A419A9999990EF023419A999919FA2F5A410000000016F223419A99997927305A413333333367F22341CDCCCC4C31305A4100000000CBF22341000000C02F305A419A99999912F32341333333932A305A419A9999990BF22341333333F303305A419A99999901F12341000000E0DB2F5A4100000000A8F02341666666C6E62F5A41CDCCCCCCFCEF23419A999999F72F5A41CDCCCCCCFCEF23419A999999F72F5A41	01010000206A080000865C11ED71F12341666666E608305A41	751103701	H	Saint-Vincent de Paul 1	7511037	75110	75	11	0
01060000206A080000010000000103000000010000002B00000033333333D5EE23419A999959F72F5A4133333333F9EE23413333331302305A41CDCCCCCC0EEF2341CDCCCCAC06305A410000000014EF2341333333530A305A41CDCCCCCC0DEF2341000000000D305A419A99999904EF23419A9999B911305A419A99999917EF2341333333530F305A410000000036EF2341CDCCCC0C0C305A419A9999993DEF2341CDCCCC4C0B305A419A99999945EF2341666666860A305A410000000052EF2341CDCCCC4C09305A416666666667EF2341333333D306305A4133333333D1EF2341CDCCCCECFB2F5A4100000000E2EF23419A999939FA2F5A4100000000E8EF2341333333B3F92F5A4133333333F8EF234100000020F82F5A41CDCCCCCCFCEF23419A999999F72F5A419A99999915F023419A999939F52F5A413333333341F0234133333313F12F5A416666666675F0234100000000EC2F5A4100000000A8F02341666666C6E62F5A41CDCCCCCCC3F02341CDCCCC4CE22F5A419A99999901F12341000000E0DB2F5A410000000084F02341000000E0C82F5A41333333333BF0234133333353BD2F5A419A999999F0EF23419A999939B22F5A4166666666B8EF23419A9999F9A82F5A4166666666B4EF234133333373A82F5A419A99999994EF2341CDCCCC4CA42F5A41333333337DEF2341CDCCCC8CA12F5A419A9999995FEF23419A9999799F2F5A41CDCCCCCC63EF2341000000A0A12F5A416666666666EF234133333373A42F5A410000000067EF2341CDCCCC2CA82F5A416666666664EF23419A9999D9AD2F5A419A9999995FEF23419A999939B32F5A41333333335CEF234100000020BB2F5A41000000005AEF23419A9999F9BD2F5A41CDCCCCCC4DEF234166666646C22F5A419A99999936EF23419A9999D9CE2F5A413333333320EF234100000040E52F5A419A99999914EF234100000000F42F5A4133333333D5EE23419A999959F72F5A41	01060000206A080000010000000103000000010000000F00000033333333D5EE23419A999959F72F5A410000000014EF2341333333530A305A419A99999904EF23419A9999B911305A4133333333D1EF2341CDCCCCECFB2F5A4100000000A8F02341666666C6E62F5A419A99999901F12341000000E0DB2F5A419A999999F0EF23419A999939B22F5A4166666666B8EF23419A9999F9A82F5A419A9999995FEF23419A9999799F2F5A416666666666EF234133333373A42F5A41000000005AEF23419A9999F9BD2F5A419A99999936EF23419A9999D9CE2F5A419A99999914EF234100000000F42F5A4133333333D5EE23419A999959F72F5A4133333333D5EE23419A999959F72F5A41	01010000206A0800007E1B775103F02341CDCCCC5CD52F5A41	751103702	H	Saint-Vincent de Paul 2	7511037	75110	75	11	0
01060000206A0800000100000001030000000100000032000000333333332DEB2341000000E0732F5A419A9999993DEB23419A999999742F5A41CDCCCCCC4DEB23419A9999F9752F5A41666666665BEB234166666646772F5A410000000065EB23419A9999F9782F5A41CDCCCCCC69EB2341CDCCCC2C7F2F5A41333333336BEB234133333333802F5A41000000007EEB23419A9999D98C2F5A41CDCCCCCC9EEB23419A999959A22F5A41CDCCCCCCA1EB23419A999939A52F5A419A999999A4EB2341CDCCCC0CA82F5A41CDCCCCCCAAEB2341666666E6AC2F5A419A999999B6EB2341CDCCCC6CB62F5A4133333333BFEB234100000020B82F5A4166666666CDEB2341000000A0B72F5A4133333333E9EB234100000080B62F5A410000000011EC2341000000E0B42F5A416666666660EC2341000000E0B12F5A416666666672EC234166666646B12F5A41666666667FEC234166666606B12F5A410000000092EC23419A999939B02F5A4166666666ABEC234166666686AF2F5A419A999999BDEC234166666686B02F5A41CDCCCCCCD0EC234166666646B12F5A41333333330AED23419A999919B42F5A416666666649ED2341666666C6B62F5A416666666650ED23419A9999B9B32F5A416666666647ED2341000000E0A92F5A410000000039ED2341CDCCCCEC9B2F5A419A99999935ED2341CDCCCC8C992F5A416666666627ED2341333333F3902F5A419A99999911ED23419A9999D9832F5A410000000009ED2341666666E6802F5A413333333302ED2341666666E67D2F5A4100000000F6EC234166666686792F5A41CDCCCCCCB7EC23419A9999D9652F5A419A999999A6EC23419A9999F95F2F5A41CDCCCCCC9FEC23419A9999B95D2F5A41CDCCCCCC9DEC23419A9999995B2F5A413333333398EC23419A9999D9562F5A4133333333DFEB2341333333535C2F5A41CDCCCCCCD1EB2341CDCCCCEC5E2F5A419A999999CAEB2341666666265F2F5A4100000000C2EB2341000000205F2F5A4100000000B9EB23419A9999D95E2F5A4100000000A8EB2341333333D35D2F5A41333333338CEB23419A9999395E2F5A41CDCCCCCC82EB23419A9999D9602F5A410000000033EB23419A999919722F5A41333333332DEB2341000000E0732F5A41	01060000206A0800000100000001030000000100000013000000333333332DEB2341000000E0732F5A410000000065EB23419A9999F9782F5A41CDCCCCCC69EB2341CDCCCC2C7F2F5A41CDCCCCCC9EEB23419A999959A22F5A419A999999B6EB2341CDCCCC6CB62F5A4133333333BFEB234100000020B82F5A4166666666ABEC234166666686AF2F5A416666666649ED2341666666C6B62F5A416666666650ED23419A9999B9B32F5A410000000039ED2341CDCCCCEC9B2F5A419A99999911ED23419A9999D9832F5A4100000000F6EC234166666686792F5A41CDCCCCCC9FEC23419A9999B95D2F5A413333333398EC23419A9999D9562F5A4133333333DFEB2341333333535C2F5A41CDCCCCCCD1EB2341CDCCCCEC5E2F5A41333333338CEB23419A9999395E2F5A41333333332DEB2341000000E0732F5A41333333332DEB2341000000E0732F5A41	01010000206A080000C17F4D3348EC23419A999959882F5A41	751103703	H	Saint-Vincent de Paul 3	7511037	75110	75	11	0
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	01060000206A0800000100000001030000000100000014000000CDCCCCCC07E92341CDCCCCCC8A2F5A419A99999920E923419A9999F9982F5A41000000003FE92341000000A0AE2F5A41CDCCCCCC7FE923419A999999B12F5A4166666666AAE92341CDCCCC0CCB2F5A4166666666B7E92341333333F3CC2F5A416666666670EA2341CDCCCC2CC62F5A41CDCCCCCC0CEB2341000000A0BD2F5A41CDCCCCCCB4EB234166666606B92F5A41CDCCCCCC9EEB23419A999959A22F5A41CDCCCCCC69EB2341CDCCCC2C7F2F5A410000000065EB23419A9999F9782F5A41333333332DEB2341000000E0732F5A41333333338CEB23419A9999395E2F5A41CDCCCCCC8FEA2341666666A6642F5A41666666661BE92341333333D36E2F5A413333333332E92341333333337D2F5A413333333367E92341666666E67F2F5A41CDCCCCCC07E92341CDCCCCCC8A2F5A41CDCCCCCC07E92341CDCCCCCC8A2F5A41	01010000206A080000573F32DF52EA234166666666952F5A41	751103704	H	Saint-Vincent de Paul 4	7511037	75110	75	11	0
01060000206A08000001000000010300000001000000330000009A999999B9E7234166666626722F5A4133333333BAE723419A999919742F5A419A999999C8E72341CDCCCC4C782F5A419A999999CEE72341CDCCCC0C7B2F5A41CDCCCCCCD0E723419A9999F9842F5A41CDCCCCCCD4E72341666666868E2F5A419A999999D7E72341CDCCCC6C942F5A4133333333DAE7234166666686982F5A4166666666E2E7234100000040A02F5A41CDCCCCCCE9E72341CDCCCCCCA62F5A4133333333F1E7234166666626AA2F5A41CDCCCCCC0BE82341333333B3B62F5A419A9999990CE8234133333313B72F5A419A99999935E82341333333D3CC2F5A419A9999993DE8234166666686D12F5A41000000003CE8234166666626DE2F5A410000000001E9234100000020D62F5A419A99999955E92341333333B3D22F5A416666666691E92341CDCCCC8CD02F5A419A999999A2E923419A999999CF2F5A41CDCCCCCCA7E92341666666E6CD2F5A41CDCCCCCCA1E92341000000C0CC2F5A4166666666AAE92341CDCCCC0CCB2F5A41CDCCCCCCA3E9234133333353C72F5A41666666669CE9234100000040C32F5A41CDCCCCCC83E92341CDCCCCCCB42F5A41CDCCCCCC7FE923419A999999B12F5A416666666679E92341000000C0B12F5A410000000075E92341666666A6B12F5A41000000003FE92341000000A0AE2F5A413333333323E923419A9999D99A2F5A419A99999920E923419A9999F9982F5A41000000001DE92341CDCCCCAC962F5A416666666618E9234100000020942F5A416666666612E9234166666686912F5A416666666616E92341666666E68F2F5A410000000010E92341333333B38D2F5A41CDCCCCCC07E92341CDCCCCCC8A2F5A419A9999991EE9234166666626882F5A41CDCCCCCC30E92341CDCCCC0C862F5A41CDCCCCCC39E9234100000020852F5A41CDCCCCCC42E9234100000000842F5A413333333367E92341666666E67F2F5A413333333332E92341333333337D2F5A41666666662EE923419A9999B97A2F5A41666666661BE92341333333D36E2F5A41CDCCCCCC79E8234100000020732F5A416666666662E82341000000C0732F5A41CDCCCCCC18E82341CDCCCCCC752F5A41666666660AE8234100000040762F5A419A999999B9E7234166666626722F5A41	01060000206A08000001000000010300000001000000130000009A999999B9E7234166666626722F5A419A999999CEE72341CDCCCC0C7B2F5A4133333333DAE7234166666686982F5A41CDCCCCCCE9E72341CDCCCCCCA62F5A419A9999990CE8234133333313B72F5A419A9999993DE8234166666686D12F5A41000000003CE8234166666626DE2F5A419A999999A2E923419A999999CF2F5A4166666666AAE92341CDCCCC0CCB2F5A41CDCCCCCC7FE923419A999999B12F5A41000000003FE92341000000A0AE2F5A419A99999920E923419A9999F9982F5A41CDCCCCCC07E92341CDCCCCCC8A2F5A413333333367E92341666666E67F2F5A413333333332E92341333333337D2F5A41666666661BE92341333333D36E2F5A41666666660AE8234100000040762F5A419A999999B9E7234166666626722F5A419A999999B9E7234166666626722F5A41	01010000206A080000C2DD6ABF8AE8234166666686A32F5A41	751103705	H	Saint-Vincent de Paul 5	7511037	75110	75	11	0
01060000206A0800000100000001030000000100000038000000666666660AE823410000004027305A410000000012E823416666666627305A410000000033E823419A9999F927305A41333333333BE823410000002028305A419A99999964E823419A99999928305A419A999999FAE82341CDCCCC6C2A305A41666666660FE92341333333B32A305A410000000011E923416666668627305A413333333310E923410000008026305A4166666666FBE8234133333353FC2F5A4100000000FEE82341CDCCCC6CFB2F5A419A99999902E9234133333393FA2F5A410000000007E9234100000020FA2F5A410000000011E92341666666C6F92F5A413333333397E92341333333D3F62F5A4166666666E8E923419A9999F9F42F5A410000000064EA2341333333F3F12F5A4133333333A2EA234133333373F02F5A41CDCCCCCCB0EA234100000040F02F5A41CDCCCCCCB9EA234166666646F02F5A4100000000C1EA23419A999999F02F5A4100000000C7EA23419A999939F12F5A41CDCCCCCCD0EA2341CDCCCCCCF22F5A419A999999CDEA2341CDCCCC8CF02F5A419A999999C5EA234133333393EC2F5A4133333333C4EA23419A9999F9EA2F5A4133333333C4EA234166666666E82F5A41CDCCCCCCC0EA234100000000E62F5A41CDCCCCCCBDEA23419A999999E42F5A4100000000B5EA23419A999979E12F5A4133333333B3EA23419A9999D9E02F5A4166666666B5EA2341CDCCCC0CE02F5A4100000000B5EA2341CDCCCCECDE2F5A410000000087EA234166666606CD2F5A41333333337FEA234133333313CC2F5A416666666670EA2341CDCCCC2CC62F5A41666666666EEA23419A999999C52F5A413333333350EA234100000020C72F5A41CDCCCCCC16EA234133333353C92F5A41CDCCCCCCE0E9234166666666CB2F5A4166666666C4E923419A999979CC2F5A4166666666B7E92341333333F3CC2F5A41CDCCCCCCA1E92341000000C0CC2F5A41CDCCCCCCA7E92341666666E6CD2F5A419A999999A2E923419A999999CF2F5A416666666691E92341CDCCCC8CD02F5A419A99999955E92341333333B3D22F5A410000000001E9234100000020D62F5A41000000003CE8234166666626DE2F5A416666666628E823419A99999902305A410000000028E823410000000003305A41CDCCCCCC22E82341CDCCCC0C12305A41CDCCCCCC1DE82341CDCCCC6C20305A41333333330CE823410000002024305A41CDCCCCCC0BE823413333333324305A41666666660AE823410000004027305A41	01060000206A0800000100000001030000000100000010000000666666660AE823410000004027305A41666666660FE92341333333B32A305A413333333310E923410000008026305A4166666666FBE8234133333353FC2F5A410000000011E92341666666C6F92F5A4133333333A2EA234133333373F02F5A41CDCCCCCCD0EA2341CDCCCCCCF22F5A4100000000B5EA2341CDCCCCECDE2F5A41666666666EEA23419A999999C52F5A4166666666B7E92341333333F3CC2F5A419A999999A2E923419A999999CF2F5A41000000003CE8234166666626DE2F5A410000000028E823410000000003305A41CDCCCCCC1DE82341CDCCCC6C20305A41666666660AE823410000004027305A41666666660AE823410000004027305A41	01010000206A080000F012EF04C1E82341CCCCCC4CF82F5A41	751103706	H	Saint-Vincent de Paul 6	7511037	75110	75	11	0
01060000206A080000010000000103000000010000002A0000006666666672EC234166666646B12F5A4133333333BCEC234100000080CB2F5A4133333333F9EC2341333333F3E12F5A413333333305ED234133333333E62F5A41CDCCCCCC38ED234133333373F62F5A419A99999941ED23419A999919F92F5A416666666685ED2341CDCCCCCC0D305A41CDCCCCCC9AED2341333333730D305A41CDCCCCCCB2ED2341CDCCCC0C0D305A410000000020EE23419A9999390B305A419A99999938EE2341333333D30A305A41CDCCCCCC3AEE2341CDCCCCCC0A305A4166666666F2EE2341666666C607305A41CDCCCCCC0EEF2341CDCCCCAC06305A4133333333F9EE23413333331302305A4133333333D5EE23419A999959F72F5A419A99999914EF234100000000F42F5A413333333320EF234100000040E52F5A419A99999936EF23419A9999D9CE2F5A419A9999990BEF2341CDCCCCECCC2F5A419A999999F5EE23419A9999D9CB2F5A419A999999E8EE23419A999939CB2F5A4100000000D5EE234100000040CA2F5A4166666666CFEE234100000000CA2F5A419A999999C2EE23419A999959C92F5A41CDCCCCCCB5EE2341000000C0C82F5A4133333333A6EE23419A9999F9C72F5A4166666666A1EE2341000000C0C72F5A41CDCCCCCC76EE2341CDCCCCACC52F5A419A99999968EE2341333333F3C42F5A41000000004FEE2341333333B3C32F5A419A9999992FEE2341CDCCCC2CC22F5A416666666618EE2341CDCCCC0CC12F5A419A999999E8ED2341333333B3BE2F5A416666666649ED2341666666C6B62F5A41333333330AED23419A999919B42F5A41CDCCCCCCD0EC234166666646B12F5A419A999999BDEC234166666686B02F5A4166666666ABEC234166666686AF2F5A410000000092EC23419A999939B02F5A41666666667FEC234166666606B12F5A416666666672EC234166666646B12F5A41	01060000206A080000010000000103000000010000000C0000006666666672EC234166666646B12F5A413333333305ED234133333333E62F5A416666666685ED2341CDCCCCCC0D305A4166666666F2EE2341666666C607305A41CDCCCCCC0EEF2341CDCCCCAC06305A4133333333D5EE23419A999959F72F5A419A99999914EF234100000000F42F5A419A99999936EF23419A9999D9CE2F5A416666666649ED2341666666C6B62F5A4166666666ABEC234166666686AF2F5A416666666672EC234166666646B12F5A416666666672EC234166666646B12F5A41	01010000206A080000FA898E2606EE234166666666D82F5A41	751103707	H	Saint-Vincent de Paul 7	7511037	75110	75	11	0
01060000206A08000001000000010300000001000000210000006666666685ED2341CDCCCCCC0D305A41666666668FED2341666666C610305A4133333333A8ED2341000000A02D305A4133333333BAED23419A99999931305A41CDCCCCCCBFED2341CDCCCC8C33305A41CDCCCCCCBAED23416666668634305A419A999999B4ED2341CDCCCCAC35305A4100000000B4ED2341CDCCCCCC38305A4100000000DBED2341CDCCCCCC38305A4100000000FFED2341666666C638305A419A99999906EE2341000000C038305A419A9999999CEE23413333337338305A41CDCCCCCCEFEE23416666666638305A41CDCCCCCCF0EE23416666666638305A41CDCCCCCCF0EE23419A99995938305A4100000000F1EE2341CDCCCC0C38305A4166666666F0EE23416666662637305A4166666666F3EE2341CDCCCCEC34305A4166666666F5EE23416666660634305A4133333333F8EE23419A9999D932305A41CDCCCCCCF9EE23419A9999F92C305A4133333333FFEE23410000002018305A419A99999904EF23419A9999B911305A41CDCCCCCC0DEF2341000000000D305A410000000014EF2341333333530A305A41CDCCCCCC0EEF2341CDCCCCAC06305A4166666666F2EE2341666666C607305A41CDCCCCCC3AEE2341CDCCCCCC0A305A419A99999938EE2341333333D30A305A410000000020EE23419A9999390B305A41CDCCCCCCB2ED2341CDCCCC0C0D305A41CDCCCCCC9AED2341333333730D305A416666666685ED2341CDCCCCCC0D305A41	01060000206A080000010000000103000000010000000D0000006666666685ED2341CDCCCCCC0D305A41666666668FED2341666666C610305A4133333333A8ED2341000000A02D305A41CDCCCCCCBFED2341CDCCCC8C33305A4100000000B4ED2341CDCCCCCC38305A41CDCCCCCCF0EE23416666666638305A4133333333F8EE23419A9999D932305A4133333333FFEE23410000002018305A410000000014EF2341333333530A305A41CDCCCCCC0EEF2341CDCCCCAC06305A4166666666F2EE2341666666C607305A416666666685ED2341CDCCCCCC0D305A416666666685ED2341CDCCCCCC0D305A41	01010000206A080000502701974DEE2341CDCCCC8C22305A41	751103708	H	Saint-Vincent de Paul 8	7511037	75110	75	11	0
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	01060000206A08000001000000010300000001000000110000006666666670EA2341CDCCCC2CC62F5A4100000000B5EA2341CDCCCCECDE2F5A41CDCCCCCCD0EA2341CDCCCCCCF22F5A413333333303EB2341666666E603305A419A9999998EEB2341000000A02F305A41CDCCCCCCB0EB2341CDCCCC0C33305A419A99999970ED2341333333B338305A4100000000B4ED2341CDCCCCCC38305A41CDCCCCCCBFED2341CDCCCC8C33305A4133333333A8ED2341000000A02D305A41666666668FED2341666666C610305A413333333305ED234133333333E62F5A416666666672EC234166666646B12F5A4133333333BFEB234100000020B82F5A41CDCCCCCC0CEB2341000000A0BD2F5A416666666670EA2341CDCCCC2CC62F5A416666666670EA2341CDCCCC2CC62F5A41	01010000206A080000AE26DFB104EC2341000000A0F42F5A41	751103712	A	Saint-Vincent de Paul 12	7511037	75110	75	11	0
01060000206A0800000100000001030000000100000036000000CDCCCCCCC9EA23419A999959F72E5A419A999999DAEA23419A999999FB2E5A413333333327EB2341000000C0112F5A41CDCCCCCC4DEB23419A9999B91C2F5A41CDCCCCCC60EB234166666626222F5A41666666668DEB2341CDCCCC8C2F2F5A41CDCCCCCCA1EB23419A999999352F5A4133333333AEEB234133333333392F5A4133333333BEEB2341666666063E2F5A4100000000CCEB234100000040422F5A4133333333D8EB2341CDCCCCCC452F5A419A999999DEEB2341CDCCCC0C472F5A4133333333D7EB234166666606482F5A41CDCCCCCCCEEB234100000020492F5A419A999999C7EB23419A9999394A2F5A419A999999C1EB23419A9999594B2F5A4133333333D8EB23419A9999994E2F5A4166666666C4EB23419A9999B9522F5A4100000000BFEB234100000080532F5A4166666666B5EB2341CDCCCC8C542F5A419A9999998EEB23419A9999995C2F5A41333333338CEB23419A9999395E2F5A4100000000A8EB2341333333D35D2F5A4100000000B9EB23419A9999D95E2F5A4100000000C2EB2341000000205F2F5A419A999999CAEB2341666666265F2F5A41CDCCCCCCD1EB2341CDCCCCEC5E2F5A4133333333DFEB2341333333535C2F5A413333333398EC23419A9999D9562F5A4100000000CDEC23419A999939552F5A4133333333A8EC2341CDCCCCEC402F5A413333333393EC234166666606382F5A41333333338DEC2341666666A6352F5A419A99999981EC2341333333B3332F5A416666666677EC2341CDCCCC2C312F5A41666666666EEC2341CDCCCC2C2E2F5A416666666669EC23419A9999792C2F5A410000000066EC2341333333B32B2F5A419A99999960EC2341333333F32A2F5A419A99999950EC2341333333332A2F5A419A9999993FEC234133333393292F5A41333333334CEC234100000000292F5A41CDCCCCCC52EC23419A999979282F5A41CDCCCCCC57EC2341000000C0272F5A41000000005DEC2341333333F3242F5A416666666627EC23419A9999F9122F5A410000000007EC234100000080062F5A416666666605EC2341666666E6052F5A413333333304EC23419A999979052F5A4133333333A6EB234100000020E72E5A4166666666E1EA234100000060F62E5A4100000000D8EA234100000000F72E5A4133333333D1EA23419A999939F72E5A41CDCCCCCCC9EA23419A999959F72E5A41	01060000206A0800000100000001030000000100000013000000CDCCCCCCC9EA23419A999959F72E5A41CDCCCCCC60EB234166666626222F5A4133333333D8EB2341CDCCCCCC452F5A419A999999C1EB23419A9999594B2F5A4133333333D8EB23419A9999994E2F5A41333333338CEB23419A9999395E2F5A41CDCCCCCCD1EB2341CDCCCCEC5E2F5A4133333333DFEB2341333333535C2F5A4100000000CDEC23419A999939552F5A4133333333A8EC2341CDCCCCEC402F5A41333333338DEC2341666666A6352F5A419A99999960EC2341333333F32A2F5A419A9999993FEC234133333393292F5A41000000005DEC2341333333F3242F5A413333333304EC23419A999979052F5A4133333333A6EB234100000020E72E5A4166666666E1EA234100000060F62E5A41CDCCCCCCC9EA23419A999959F72E5A41CDCCCCCCC9EA23419A999959F72E5A41	01010000206A0800004C5A7B24DFEB2341CCCCCC8C232F5A41	751103801	H	Porte Saint-Denis 1	7511038	75110	75	11	0
01060000206A080000010000000103000000010000001F000000CDCCCCCCC2E92341000000C0A22E5A41CDCCCCCCCDE9234100000080A62E5A4166666666D9E9234100000040AA2E5A419A999999DDE923419A9999B9AB2E5A41CDCCCCCCF1E923419A9999D9B12E5A416666666600EA2341CDCCCC6CB72E5A410000000027EA23419A999959C42E5A41000000002CEA2341CDCCCC8CC62E5A416666666636EA234133333393C92E5A41333333334DEA234133333333D12E5A416666666658EA2341333333F3D42E5A41333333335AEA234133333393D52E5A41666666665CEA234166666646D62E5A41000000007DEA2341333333B3E02E5A413333333393EA2341CDCCCC2CE72E5A41CDCCCCCCC9EA23419A999959F72E5A4133333333D1EA23419A999939F72E5A4100000000D8EA234100000000F72E5A4166666666E1EA234100000060F62E5A4133333333A6EB234100000020E72E5A413333333378EB2341000000E0D72E5A41CDCCCCCC50EB2341333333D3CA2E5A41333333333FEB234133333353C52E5A41333333331AEB2341666666E6B92E5A41CDCCCCCCEBEA234100000060AB2E5A4166666666AEEA234133333333962E5A41333333336BEA234100000020992E5A410000000047EA2341000000C09A2E5A4100000000F7E92341333333539E2E5A419A999999C5E923419A999979A02E5A41CDCCCCCCC2E92341000000C0A22E5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCCC2E92341000000C0A22E5A41666666665CEA234166666646D62E5A41CDCCCCCCC9EA23419A999959F72E5A4166666666E1EA234100000060F62E5A4133333333A6EB234100000020E72E5A41CDCCCCCC50EB2341333333D3CA2E5A41CDCCCCCCEBEA234100000060AB2E5A4166666666AEEA234133333333962E5A419A999999C5E923419A999979A02E5A41CDCCCCCCC2E92341000000C0A22E5A41CDCCCCCCC2E92341000000C0A22E5A41	01010000206A08000048E17A94BCEA234100000010C82E5A41	751103802	H	Porte Saint-Denis 2	7511038	75110	75	11	0
01060000206A08000001000000010300000001000000220000009A9999990DE72341333333B3CE2E5A41000000000EE723419A9999D9E12E5A41CDCCCCCC0DE7234133333333E32E5A41CDCCCCCC0DE723419A9999B9EE2E5A41CDCCCCCC34E723419A999979ED2E5A4100000000A1E723419A9999F9E92E5A41666666664AE823419A9999F9E42E5A41666666660CE92341333333F3DE2E5A419A999999CAE9234133333313D92E5A416666666658EA2341333333F3D42E5A41333333334DEA234133333333D12E5A416666666636EA234133333393C92E5A41000000002CEA2341CDCCCC8CC62E5A410000000027EA23419A999959C42E5A416666666600EA2341CDCCCC6CB72E5A41CDCCCCCCF1E923419A9999D9B12E5A419A999999DDE923419A9999B9AB2E5A4166666666D9E9234100000040AA2E5A41CDCCCCCCCDE9234100000080A62E5A41CDCCCCCCC2E92341000000C0A22E5A419A999999C5E923419A999979A02E5A41333333338DE92341CDCCCCECA22E5A41CDCCCCCC6BE9234100000060A42E5A4166666666CCE82341CDCCCC0CAB2E5A4133333333B5E823419A9999F9AB2E5A413333333386E82341333333D3AD2E5A41CDCCCCCC4DE8234133333333B02E5A41666666661AE8234133333353B22E5A41CDCCCCCCFFE72341CDCCCC6CB32E5A4166666666BCE723419A999939B62E5A410000000081E7234133333393B82E5A419A99999943E7234100000000BB2E5A419A9999990FE7234133333313BD2E5A419A9999990DE72341333333B3CE2E5A41	01060000206A080000010000000103000000010000000A0000009A9999990DE72341333333B3CE2E5A41CDCCCCCC0DE723419A9999B9EE2E5A419A999999CAE9234133333313D92E5A416666666658EA2341333333F3D42E5A41CDCCCCCCC2E92341000000C0A22E5A419A999999C5E923419A999979A02E5A4166666666CCE82341CDCCCC0CAB2E5A419A9999990FE7234133333313BD2E5A419A9999990DE72341333333B3CE2E5A419A9999990DE72341333333B3CE2E5A41	01010000206A0800008EFACEC69FE8234100000010C82E5A41	751103803	H	Porte Saint-Denis 3	7511038	75110	75	11	0
01060000206A080000010000000103000000010000001F000000CDCCCCCC0DE723419A9999B9EE2E5A419A9999990FE7234133333333FF2E5A410000000011E7234100000040092F5A413333333313E72341CDCCCCAC192F5A4133333333B0E7234166666666172F5A41CDCCCCCCD1E72341000000C0162F5A4166666666DDE72341CDCCCC8C162F5A419A99999906E82341CDCCCC0C162F5A410000000091E82341333333B3132F5A41CDCCCCCC2BE92341333333F30F2F5A41000000003EE92341000000600F2F5A410000000070E92341CDCCCC0C0D2F5A419A999999AFE9234166666666092F5A4166666666CAE923419A9999D9072F5A41CDCCCCCCF7E92341000000C0042F5A4100000000F9E92341666666A6042F5A413333333319EA23419A999939022F5A419A9999999FEA23419A999939F92E5A41CDCCCCCCBAEA23419A999999F72E5A41CDCCCCCCC9EA23419A999959F72E5A413333333393EA2341CDCCCC2CE72E5A41000000007DEA2341333333B3E02E5A41666666665CEA234166666646D62E5A41333333335AEA234133333393D52E5A416666666658EA2341333333F3D42E5A419A999999CAE9234133333313D92E5A41666666660CE92341333333F3DE2E5A41666666664AE823419A9999F9E42E5A4100000000A1E723419A9999F9E92E5A41CDCCCCCC34E723419A999979ED2E5A41CDCCCCCC0DE723419A9999B9EE2E5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC0DE723419A9999B9EE2E5A413333333313E72341CDCCCCAC192F5A410000000091E82341333333B3132F5A41CDCCCCCC2BE92341333333F30F2F5A4166666666CAE923419A9999D9072F5A419A9999999FEA23419A999939F92E5A41CDCCCCCCC9EA23419A999959F72E5A416666666658EA2341333333F3D42E5A419A999999CAE9234133333313D92E5A41CDCCCCCC0DE723419A9999B9EE2E5A41CDCCCCCC0DE723419A9999B9EE2E5A41	01010000206A080000A724CAC1E4E823419A999909F32E5A41	751103804	H	Porte Saint-Denis 4	7511038	75110	75	11	0
01060000206A080000010000000103000000010000001D0000003333333313E72341CDCCCCAC192F5A410000000019E72341666666A6202F5A41333333332BE723419A999939312F5A41CDCCCCCC3BE723419A999959422F5A413333333346E723419A9999B94A2F5A410000000053E72341CDCCCC8C502F5A413333333359E723419A9999F9522F5A419A99999980E72341CDCCCC6C5F2F5A413333333388E72341000000E0612F5A41CDCCCCCCA2E72341333333736A2F5A419A999999B9E7234166666626722F5A41666666660AE8234100000040762F5A41CDCCCCCC18E82341CDCCCCCC752F5A416666666662E82341000000C0732F5A41CDCCCCCC79E8234100000020732F5A41666666661BE92341333333D36E2F5A41CDCCCCCC01E923419A9999F95D2F5A416666666600E92341000000205D2F5A419A999999F8E823419A999959582F5A4166666666EFE82341CDCCCCEC522F5A419A999999EEE8234100000060522F5A4133333333D0E82341333333333D2F5A41CDCCCCCCBCE82341333333F3302F5A410000000091E82341333333B3132F5A419A99999906E82341CDCCCC0C162F5A4166666666DDE72341CDCCCC8C162F5A41CDCCCCCCD1E72341000000C0162F5A4133333333B0E7234166666666172F5A413333333313E72341CDCCCCAC192F5A41	01060000206A080000010000000103000000010000000A0000003333333313E72341CDCCCCAC192F5A41CDCCCCCC3BE723419A999959422F5A413333333359E723419A9999F9522F5A419A999999B9E7234166666626722F5A41666666660AE8234100000040762F5A41666666661BE92341333333D36E2F5A4166666666EFE82341CDCCCCEC522F5A410000000091E82341333333B3132F5A413333333313E72341CDCCCCAC192F5A413333333313E72341CDCCCCAC192F5A41	01010000206A080000C4C27E4D0FE823419A999989462F5A41	751103805	H	Porte Saint-Denis 5	7511038	75110	75	11	0
01060000206A08000001000000010300000001000000330000000000000091E82341333333B3132F5A41CDCCCCCCBCE82341333333F3302F5A4133333333D0E82341333333333D2F5A419A999999EEE8234100000060522F5A4166666666EFE82341CDCCCCEC522F5A419A999999F8E823419A999959582F5A416666666600E92341000000205D2F5A41CDCCCCCC01E923419A9999F95D2F5A41666666661BE92341333333D36E2F5A41666666668EE92341CDCCCCAC6B2F5A4133333333BBE92341333333736A2F5A419A999999C0E92341666666466A2F5A41CDCCCCCC31EA23419A999939672F5A41CDCCCCCC7DEA234166666626652F5A41CDCCCCCC8FEA2341666666A6642F5A419A999999E2EA2341CDCCCC8C622F5A416666666668EB23419A9999F95E2F5A416666666680EB2341666666665E2F5A41333333338CEB23419A9999395E2F5A419A9999998EEB23419A9999995C2F5A4166666666B5EB2341CDCCCC8C542F5A4100000000BFEB234100000080532F5A4166666666C4EB23419A9999B9522F5A4133333333D8EB23419A9999994E2F5A419A999999C1EB23419A9999594B2F5A419A999999C7EB23419A9999394A2F5A41CDCCCCCCCEEB234100000020492F5A4133333333D7EB234166666606482F5A419A999999DEEB2341CDCCCC0C472F5A4133333333D8EB2341CDCCCCCC452F5A4100000000CCEB234100000040422F5A4133333333BEEB2341666666063E2F5A4133333333AEEB234133333333392F5A41CDCCCCCCA1EB23419A999999352F5A41666666668DEB2341CDCCCC8C2F2F5A41CDCCCCCC60EB234166666626222F5A41CDCCCCCC4DEB23419A9999B91C2F5A413333333327EB2341000000C0112F5A419A999999DAEA23419A999999FB2E5A41CDCCCCCCC9EA23419A999959F72E5A41CDCCCCCCBAEA23419A999999F72E5A419A9999999FEA23419A999939F92E5A413333333319EA23419A999939022F5A4100000000F9E92341666666A6042F5A41CDCCCCCCF7E92341000000C0042F5A4166666666CAE923419A9999D9072F5A419A999999AFE9234166666666092F5A410000000070E92341CDCCCC0C0D2F5A41000000003EE92341000000600F2F5A41CDCCCCCC2BE92341333333F30F2F5A410000000091E82341333333B3132F5A41	01060000206A080000010000000103000000010000000F0000000000000091E82341333333B3132F5A4166666666EFE82341CDCCCCEC522F5A41666666661BE92341333333D36E2F5A41CDCCCCCC8FEA2341666666A6642F5A41333333338CEB23419A9999395E2F5A4133333333D8EB23419A9999994E2F5A419A999999C1EB23419A9999594B2F5A4133333333D8EB2341CDCCCCCC452F5A41CDCCCCCC60EB234166666626222F5A41CDCCCCCCC9EA23419A999959F72E5A419A9999999FEA23419A999939F92E5A4166666666CAE923419A9999D9072F5A41CDCCCCCC2BE92341333333F30F2F5A410000000091E82341333333B3132F5A410000000091E82341333333B3132F5A41	01010000206A08000038A09F382DEA234166666646332F5A41	751103806	H	Porte Saint-Denis 6	7511038	75110	75	11	0
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	01060000206A08000001000000010300000001000000150000000000000091F12341CDCCCC0C7F2F5A410000000013F223419A9999599A2F5A416666666670F22341333333B3AC2F5A4166666666AAF223419A9999D9AE2F5A413333333399F3234100000080E32F5A4133333333D2F3234166666626E62F5A41CDCCCCCCD4F32341333333B3F22F5A4166666666EBF3234133333333F32F5A4100000000EFF32341666666E6912F5A419A999999D1F3234166666606922F5A4100000000BAF32341000000808E2F5A4100000000B3F323419A9999B9832F5A410000000066F32341666666E6812F5A4133333333E9F2234166666606822F5A4133333333D0F22341CDCCCCAC852F5A4166666666ADF22341CDCCCC4C822F5A41CDCCCCCC88F22341CDCCCCEC842F5A416666666663F22341666666E67D2F5A4166666666D8F12341333333537A2F5A410000000091F12341CDCCCC0C7F2F5A410000000091F12341CDCCCC0C7F2F5A41	01010000206A080000BEA13B5862F323419A999989B82F5A41	751104010	H	Hôpital Saint-Louis 10	7511040	75110	75	11	0
01060000206A080000010000000103000000010000002A0000009A99999901F12341000000E0DB2F5A41000000005FF1234100000000EA2F5A419A9999990BF22341333333F303305A4166666666C9F223410000000020305A410000000002F32341333333B327305A419A99999912F32341333333932A305A416666666613F323419A9999792A305A419A99999922F323419A99997928305A413333333330F323410000004025305A41333333333EF32341333333F321305A416666666650F32341333333931D305A410000000059F32341333333731B305A41666666665FF32341CDCCCC2C1A305A410000000067F323419A9999D918305A41CDCCCCCC75F32341000000C016305A41666666667DF32341CDCCCCCC15305A419A9999997FF323413333339315305A41333333338CF323419A99991914305A419A9999999EF323410000004012305A41CDCCCCCCA4F32341666666A611305A419A999999AAF32341CDCCCCEC10305A4133333333B2F32341CDCCCC0C10305A4100000000B9F32341333333530F305A41CDCCCCCCBDF323419A9999B90E305A4133333333C5F32341333333930D305A41CDCCCCCCCCF32341CDCCCC6C0C305A4166666666D1F323419A9999990B305A41CDCCCCCCD8F32341000000200A305A41CDCCCCCCE1F32341CDCCCC0C08305A4100000000E5F323410000004007305A4100000000E3F323410000002007305A41CDCCCCCCD8F323410000008006305A419A999999CFF32341CDCCCC4C06305A4166666666C6F323413333335306305A4166666666BBF323419A99999906305A41000000007FF32341CDCCCC0C04305A410000000073F323413333339303305A416666666661F32341000000C002305A419A99999951F32341CDCCCC2C02305A419A9999991CF22341666666C6BD2F5A41CDCCCCCC85F12341CDCCCCCCCD2F5A419A99999901F12341000000E0DB2F5A41	01060000206A080000010000000103000000010000000B0000009A99999901F12341000000E0DB2F5A419A9999990BF22341333333F303305A419A99999912F32341333333932A305A410000000059F32341333333731B305A41CDCCCCCCBDF323419A9999B90E305A4100000000E5F323410000004007305A4166666666BBF323419A99999906305A419A99999951F32341CDCCCC2C02305A419A9999991CF22341666666C6BD2F5A419A99999901F12341000000E0DB2F5A419A99999901F12341000000E0DB2F5A41	01010000206A080000ECE8123265F2234166666616F62F5A41	751104011	H	Hôpital Saint-Louis 11	7511040	75110	75	11	0
01060000206A080000010000000103000000010000002700000033333333D6F02341666666660E2F5A41333333330CF12341333333F3142F5A41CDCCCCCC40F123419A9999791B2F5A41333333336FF12341CDCCCC0C212F5A410000000098F1234166666626262F5A4133333333E3F123419A9999392F2F5A413333333301F22341000000E0322F5A41666666660BF2234133333313342F5A419A99999922F22341666666E6362F5A416666666638F223419A999999392F5A413333333350F22341333333733C2F5A410000000086F2234133333333442F5A41CDCCCCCCC8F22341000000E04D2F5A419A999999DBF22341CDCCCC2C502F5A419A999999EAF22341666666E6512F5A419A999999F7F22341333333B34F2F5A416666666628F3234100000040422F5A419A99999949F32341000000203A2F5A41CDCCCCCC4FF3234166666686382F5A4166666666C5F3234166666686192F5A4133333333EDF32341CDCCCC6C172F5A419A999999EDF323419A999919142F5A41CDCCCCCCEAF32341CDCCCCEC0E2F5A419A999999E6F32341CDCCCC2C0C2F5A4133333333BFF3234166666686FB2E5A41000000008AF3234100000040E52E5A41666666667BF323419A999999E12E5A419A99999973F3234100000040E02E5A41666666669CF2234100000060D82E5A413333333387F223419A999999D72E5A41CDCCCCCC6EF2234133333353DB2E5A4100000000E0F1234100000060EC2E5A41CDCCCCCCCBF1234100000040F02E5A419A999999C9F12341333333D3F12E5A419A999999C5F12341CDCCCC0CF32E5A419A9999997DF1234100000060FB2E5A419A99999943F123419A999919022F5A413333333309F12341000000A0082F5A4133333333D6F02341666666660E2F5A41	01060000206A080000010000000103000000010000001000000033333333D6F02341666666660E2F5A413333333350F22341333333733C2F5A41CDCCCCCCC8F22341000000E04D2F5A419A999999EAF22341666666E6512F5A419A999999F7F22341333333B34F2F5A4166666666C5F3234166666686192F5A4133333333EDF32341CDCCCC6C172F5A419A999999E6F32341CDCCCC2C0C2F5A41000000008AF3234100000040E52E5A419A99999973F3234100000040E02E5A413333333387F223419A999999D72E5A41CDCCCCCC6EF2234133333353DB2E5A4100000000E0F1234100000060EC2E5A419A999999C5F12341CDCCCC0CF32E5A4133333333D6F02341666666660E2F5A4133333333D6F02341666666660E2F5A41	01010000206A08000093F95D1F7BF2234166666686142F5A41	751104012	A	Hôpital Saint-Louis 12	7511040	75110	75	11	0
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	01060000206A080000010000000103000000010000001B00000033333333A1EF23419A9999F9232F5A4133333333CBEF234100000020342F5A4100000000ECEF2341000000603A2F5A41666666661BF12341000000807B2F5A413333333313F22341333333D3B12F5A419A9999991CF22341666666C6BD2F5A419A99999951F32341CDCCCC2C02305A4166666666BBF323419A99999906305A4100000000E5F323410000004007305A4166666666EDF323413333333301305A4166666666EBF3234133333333F32F5A41CDCCCCCCD4F32341333333B3F22F5A4133333333D2F3234166666626E62F5A413333333399F3234100000080E32F5A4166666666AAF223419A9999D9AE2F5A416666666670F22341333333B3AC2F5A410000000013F223419A9999599A2F5A413333333366F123419A999919762F5A4166666666F6F02341666666E65B2F5A41CDCCCCCC2AF023419A999979322F5A41CDCCCCCC10F023419A9999792B2F5A4100000000FFEF234133333393222F5A419A9999990DF023419A999939182F5A4166666666D8EF2341CDCCCCCC1A2F5A4100000000A5EF2341666666C61F2F5A4133333333A1EF23419A9999F9232F5A4133333333A1EF23419A9999F9232F5A41	01010000206A080000084BA4CCB5F123419A9999F9912F5A41	751104088	D	Canal Saint-Martin 2	7511040	75110	75	11	0
01060000206A080000010000000103000000010000001E00000066666666E5FC2341CDCCCC0CCA2C5A41666666660FFD2341CDCCCCCCCB2C5A4133333333A8FD23419A999939D22C5A4166666666C0FD234100000060D32C5A419A99999929FE234100000080C72C5A416666666643FE234166666686C42C5A419A9999996DFE2341CDCCCC2CBF2C5A416666666684FE23419A999999BC2C5A41CDCCCCCC8BFE2341666666C6BB2C5A4133333333D8FE234100000020B32C5A4166666666ECFE2341CDCCCCCCB02C5A413333333328FF2341CDCCCCECA92C5A416666666653FF234166666606A52C5A41000000004200244166666666892C5A419A9999997B002441CDCCCCAC822C5A416666666620002441333333D3822C5A4133333333AAFF2341CDCCCC4C842C5A41333333335FFF2341000000E0842C5A416666666605FF2341CDCCCCEC842C5A4133333333BBFE2341000000A0842C5A41333333332DFE234100000080842C5A41000000007DFD2341CDCCCC6C842C5A416666666669FD23419A999999842C5A41CDCCCCCC1FFD2341666666E6842C5A41CDCCCCCC10FD23419A9999F9842C5A41666666660CFD2341000000808A2C5A416666666603FD2341333333539D2C5A419A999999FAFC2341CDCCCC6CAB2C5A4100000000EFFC2341000000C0BE2C5A4166666666E5FC2341CDCCCC0CCA2C5A41	01060000206A080000010000000103000000010000000C00000066666666E5FC2341CDCCCC0CCA2C5A4166666666C0FD234100000060D32C5A419A9999996DFE2341CDCCCC2CBF2C5A416666666653FF234166666606A52C5A419A9999997B002441CDCCCCAC822C5A416666666620002441333333D3822C5A41333333335FFF2341000000E0842C5A41000000007DFD2341CDCCCC6C842C5A41CDCCCCCC10FD23419A9999F9842C5A4100000000EFFC2341000000C0BE2C5A4166666666E5FC2341CDCCCC0CCA2C5A4166666666E5FC2341CDCCCC0CCA2C5A41	01010000206A080000AE184A5F0EFE2341CDCCCCACAA2C5A41	751114408	H	Sainte-Marguerite 8	7511144	75111	75	11	0
01060000206A08000001000000010300000001000000140000006666666643FE234166666686C42C5A4166666666AAFE234100000060C82C5A4166666666460024419A999919D72C5A41000000009C0024419A9999D9DA2C5A419A999999CC00244166666626CB2C5A41666666660601244133333373B92C5A4133333333310124419A999919AD2C5A41333333335201244133333373A22C5A419A9999999D0124419A9999398A2C5A41CDCCCCCCBA00244166666626842C5A419A9999997B002441CDCCCCAC822C5A41000000004200244166666666892C5A416666666653FF234166666606A52C5A413333333328FF2341CDCCCCECA92C5A4166666666ECFE2341CDCCCCCCB02C5A4133333333D8FE234100000020B32C5A41CDCCCCCC8BFE2341666666C6BB2C5A416666666684FE23419A999999BC2C5A419A9999996DFE2341CDCCCC2CBF2C5A416666666643FE234166666686C42C5A41	01060000206A08000001000000010300000001000000140000006666666643FE234166666686C42C5A4166666666AAFE234100000060C82C5A4166666666460024419A999919D72C5A41000000009C0024419A9999D9DA2C5A419A999999CC00244166666626CB2C5A41666666660601244133333373B92C5A4133333333310124419A999919AD2C5A41333333335201244133333373A22C5A419A9999999D0124419A9999398A2C5A41CDCCCCCCBA00244166666626842C5A419A9999997B002441CDCCCCAC822C5A41000000004200244166666666892C5A416666666653FF234166666606A52C5A413333333328FF2341CDCCCCECA92C5A4166666666ECFE2341CDCCCCCCB02C5A4133333333D8FE234100000020B32C5A41CDCCCCCC8BFE2341666666C6BB2C5A416666666684FE23419A999999BC2C5A419A9999996DFE2341CDCCCC2CBF2C5A416666666643FE234166666686C42C5A41	01010000206A08000096E1E0A313002441343333F3AE2C5A41	751114409	H	Sainte-Marguerite 9	7511144	75111	75	11	0
01060000206A0800000100000001030000000100000015000000000000009C0024419A9999D9DA2C5A419A999999E600244100000020DD2C5A41000000004E0124419A9999D9E12C5A41666666668302244100000060EF2C5A41CDCCCCCC1C032441CDCCCC2CCA2C5A419A9999991D0324419A9999F9C92C5A4166666666DA032441CDCCCC4C9B2C5A41CDCCCCCCDB032441333333D39A2C5A4166666666D8032441333333B39A2C5A4133333333D8032441333333B39A2C5A4100000000BE032441000000E0992C5A41CDCCCCCC620324419A9999D9962C5A4100000000BF0224419A999979912C5A4100000000460224419A9999D98D2C5A416666666601022441333333D38B2C5A419A9999999D0124419A9999398A2C5A41333333335201244133333373A22C5A4133333333310124419A999919AD2C5A41666666660601244133333373B92C5A419A999999CC00244166666626CB2C5A41000000009C0024419A9999D9DA2C5A41	01060000206A080000010000000103000000010000000C000000000000009C0024419A9999D9DA2C5A419A999999E600244100000020DD2C5A41666666668302244100000060EF2C5A41CDCCCCCC1C032441CDCCCC2CCA2C5A41CDCCCCCCDB032441333333D39A2C5A4100000000BF0224419A999979912C5A416666666601022441333333D38B2C5A419A9999999D0124419A9999398A2C5A4133333333310124419A999919AD2C5A419A999999CC00244166666626CB2C5A41000000009C0024419A9999D9DA2C5A41000000009C0024419A9999D9DA2C5A41	01010000206A080000CD135A3815022441666666B6C12C5A41	751114410	H	Sainte-Marguerite 10	7511144	75111	75	11	0
01060000206A080000010000000103000000010000001A000000CDCCCCCCEBFD23419A9999F9E02C5A419A99999927FE234133333353E32C5A419A99999910FF2341666666E6EB2C5A41333333331AFF2341CDCCCC4CEC2C5A416666666654FF234133333393EE2C5A41000000008FFF23419A9999D9F02C5A41000000005FFF2341CDCCCC2C002D5A413333333339FF2341000000C00B2D5A41333333332BFF234100000000132D5A419A999999D6FF2341333333B3172D5A4166666666520024419A9999391B2D5A41333333336C002441666666861C2D5A4100000000AE002441333333D31F2D5A41333333333A012441CDCCCC4C272D5A416666666692012441333333732C2D5A41666666668302244100000060EF2C5A41000000004E0124419A9999D9E12C5A419A999999E600244100000020DD2C5A41000000009C0024419A9999D9DA2C5A4166666666460024419A999919D72C5A4166666666AAFE234100000060C82C5A416666666643FE234166666686C42C5A419A99999929FE234100000080C72C5A41CDCCCCCC25FE234133333333C92C5A413333333309FE23419A9999F9D52C5A41CDCCCCCCEBFD23419A9999F9E02C5A41	01060000206A080000010000000103000000010000001A000000CDCCCCCCEBFD23419A9999F9E02C5A419A99999927FE234133333353E32C5A419A99999910FF2341666666E6EB2C5A41333333331AFF2341CDCCCC4CEC2C5A416666666654FF234133333393EE2C5A41000000008FFF23419A9999D9F02C5A41000000005FFF2341CDCCCC2C002D5A413333333339FF2341000000C00B2D5A41333333332BFF234100000000132D5A419A999999D6FF2341333333B3172D5A4166666666520024419A9999391B2D5A41333333336C002441666666861C2D5A4100000000AE002441333333D31F2D5A41333333333A012441CDCCCC4C272D5A416666666692012441333333732C2D5A41666666668302244100000060EF2C5A41000000004E0124419A9999D9E12C5A419A999999E600244100000020DD2C5A41000000009C0024419A9999D9DA2C5A4166666666460024419A999919D72C5A4166666666AAFE234100000060C82C5A416666666643FE234166666686C42C5A419A99999929FE234100000080C72C5A41CDCCCCCC25FE234133333333C92C5A413333333309FE23419A9999F9D52C5A41CDCCCCCCEBFD23419A9999F9E02C5A41	01010000206A08000000E9FE2BEB00244134333383F82C5A41	751114411	H	Sainte-Marguerite 11	7511144	75111	75	11	0
01060000206A08000001000000010300000001000000180000000000000064FC234133333313FB2C5A4166666666DAFC2341CDCCCC6C002D5A4100000000FDFC234100000000022D5A41666666666BFD2341CDCCCC8C062D5A4100000000A3FD2341CDCCCCEC072D5A4133333333FEFD2341CDCCCCAC0A2D5A416666666692FE2341CDCCCCCC0E2D5A419A9999999DFE23419A9999190F2D5A4133333333E0FE2341000000C0102D5A41333333332BFF234100000000132D5A413333333339FF2341000000C00B2D5A41000000005FFF2341CDCCCC2C002D5A41000000008FFF23419A9999D9F02C5A416666666654FF234133333393EE2C5A41333333331AFF2341CDCCCC4CEC2C5A419A99999910FF2341666666E6EB2C5A419A99999927FE234133333353E32C5A41CDCCCCCCEBFD23419A9999F9E02C5A413333333309FE23419A9999F9D52C5A41CDCCCCCC25FE234133333333C92C5A419A99999929FE234100000080C72C5A4166666666C0FD234100000060D32C5A416666666645FD234166666606E12C5A410000000064FC234133333313FB2C5A41	01060000206A080000010000000103000000010000000A0000000000000064FC234133333313FB2C5A41666666666BFD2341CDCCCC8C062D5A41333333332BFF234100000000132D5A413333333339FF2341000000C00B2D5A41000000008FFF23419A9999D9F02C5A41CDCCCCCCEBFD23419A9999F9E02C5A419A99999929FE234100000080C72C5A416666666645FD234166666606E12C5A410000000064FC234133333313FB2C5A410000000064FC234133333313FB2C5A41	01010000206A08000040F75CA608FE234100000070ED2C5A41	751114412	H	Sainte-Marguerite 12	7511144	75111	75	11	0
01060000206A080000010000000103000000010000001400000000000000B6FA23419A999979E82C5A4166666666DEFA234166666646EA2C5A4166666666A4FB2341666666C6F22C5A4133333333ACFB23419A999919F32C5A413333333308FC2341CDCCCCECF62C5A410000000035FC234166666626F92C5A410000000064FC234133333313FB2C5A416666666645FD234166666606E12C5A4166666666C0FD234100000060D32C5A4133333333A8FD23419A999939D22C5A41666666660FFD2341CDCCCCCCCB2C5A4166666666E5FC2341CDCCCC0CCA2C5A416666666690FC234133333393C62C5A413333333358FC234100000040C42C5A419A99999942FC234100000080C32C5A41333333333DFC23419A999939C32C5A41000000001FFC2341CDCCCC6CC22C5A41000000002FFB2341000000C0BE2C5A41CDCCCCCCE7FA234166666626D72C5A4100000000B6FA23419A999979E82C5A41	01060000206A080000010000000103000000010000000900000000000000B6FA23419A999979E82C5A410000000064FC234133333313FB2C5A416666666645FD234166666606E12C5A4166666666C0FD234100000060D32C5A413333333358FC234100000040C42C5A41000000001FFC2341CDCCCC6CC22C5A41000000002FFB2341000000C0BE2C5A4100000000B6FA23419A999979E82C5A4100000000B6FA23419A999979E82C5A41	01010000206A0800007815E3BF25FC234166666616DC2C5A41	751114413	H	Sainte-Marguerite 13	7511144	75111	75	11	0
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	01060000206A0800000100000001030000000100000013000000666666662EF0234166666686622E5A41CDCCCCCC75F02341CDCCCCCC682E5A41CDCCCCCC2FF12341CDCCCC4C762E5A419A999999B1F123419A9999F97D2E5A413333333355F2234133333333862E5A416666666676F2234166666686882E5A4166666666B0F22341000000A0812E5A416666666693F32341CDCCCC6C7C2E5A4133333333C7F32341333333736B2E5A410000000025F42341CDCCCC0C502E5A413333333364F423419A9999393C2E5A41CDCCCCCC0FF42341CDCCCC6C372E5A4166666666CAF32341333333333A2E5A41CDCCCCCC1CF12341CDCCCC4C532E5A4100000000CBF02341000000C0482E5A41CDCCCCCCBCF02341000000203F2E5A41CDCCCCCC6DF02341333333B35C2E5A41666666662EF0234166666686622E5A41666666662EF0234166666686622E5A41	01010000206A080000FFB57D541CF2234133333303602E5A41	751114107	H	Folie Méricourt 7	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000200000006666666693F32341CDCCCC6C7C2E5A416666666651F42341333333B3772E5A4100000000ABF42341CDCCCC6C752E5A4166666666F1F4234166666666732E5A410000000019F5234166666646712E5A41CDCCCCCC9EF52341CDCCCC6C4F2E5A4100000000B2F523419A9999F9492E5A4166666666C3F5234100000000452E5A41CDCCCCCCD6F523419A9999F93F2E5A4100000000ECF52341CDCCCC6C3A2E5A419A9999990BF6234100000020322E5A41CDCCCCCC1BF623419A9999992D2E5A419A99999933F62341666666E6262E5A41000000004AF6234100000020222E5A41000000000AF62341CDCCCCAC242E5A419A99999941F52341CDCCCC0C2C2E5A416666666619F523419A9999992D2E5A41666666660DF52341333333132E2E5A419A999999E0F42341666666A62F2E5A41CDCCCCCC8EF42341333333F3322E5A41000000005DF42341CDCCCC8C342E5A41CDCCCCCC2BF42341CDCCCC6C362E5A41CDCCCCCC0FF42341CDCCCC6C372E5A41333333332EF4234100000000392E5A419A99999945F42341666666863A2E5A413333333364F423419A9999393C2E5A41CDCCCCCC53F42341CDCCCC6C412E5A410000000025F42341CDCCCC0C502E5A419A999999EFF32341000000E05F2E5A4133333333C7F32341333333736B2E5A41000000009FF3234100000000782E5A416666666693F32341CDCCCC6C7C2E5A41	01060000206A080000010000000103000000010000000C0000006666666693F32341CDCCCC6C7C2E5A4100000000ABF42341CDCCCC6C752E5A410000000019F5234166666646712E5A41CDCCCCCC9EF52341CDCCCC6C4F2E5A419A99999933F62341666666E6262E5A41000000004AF6234100000020222E5A41CDCCCCCC0FF42341CDCCCC6C372E5A413333333364F423419A9999393C2E5A410000000025F42341CDCCCC0C502E5A4133333333C7F32341333333736B2E5A416666666693F32341CDCCCC6C7C2E5A416666666693F32341CDCCCC6C7C2E5A41	01010000206A080000F4285C0FECF42341343333B34C2E5A41	751114108	H	Folie Méricourt 8	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000230000000000000019F5234166666646712E5A410000000034F52341CDCCCC2C712E5A41CDCCCCCC4CF52341000000C0702E5A419A99999969F52341000000A0702E5A41333333337CF52341000000C0702E5A419A999999A0F5234133333373712E5A41666666663FF6234133333353772E5A410000000086F62341666666667A2E5A41CDCCCCCC9BF62341CDCCCC4C7B2E5A41CDCCCCCC1FF72341CDCCCC4C822E5A41CDCCCCCC50F7234166666686852E5A4166666666A5F72341333333938A2E5A4100000000F0F723419A9999F98E2E5A419A999999FEF723419A999919902E5A41666666662DF8234100000040832E5A41CDCCCCCC34F8234133333393812E5A419A99999953F82341666666267A2E5A41666666666DF8234133333333742E5A410000000081F82341666666466F2E5A41000000008DF82341333333F36E2E5A416666666690F82341333333B36E2E5A419A99999994F82341CDCCCC2C6E2E5A41CDCCCCCC9AF823419A9999596D2E5A413333333388F82341666666666C2E5A410000000075F823419A9999796B2E5A41000000004EF82341666666A6692E5A4166666666E1F7234133333393642E5A413333333313F72341666666A65A2E5A4166666666C7F6234166666606572E5A41333333339DF62341CDCCCC0C552E5A41666666664DF6234166666606512E5A4100000000F4F52341CDCCCCCC4C2E5A4100000000B2F523419A9999F9492E5A41CDCCCCCC9EF52341CDCCCC6C4F2E5A410000000019F5234166666646712E5A41	01060000206A080000010000000103000000010000000B0000000000000019F5234166666646712E5A419A999999A0F5234133333373712E5A41CDCCCCCC9BF62341CDCCCC4C7B2E5A41CDCCCCCC1FF72341CDCCCC4C822E5A419A999999FEF723419A999919902E5A41666666662DF8234100000040832E5A410000000081F82341666666466F2E5A41CDCCCCCC9AF823419A9999596D2E5A4100000000B2F523419A9999F9492E5A410000000019F5234166666646712E5A410000000019F5234166666646712E5A41	01010000206A08000096D42DF2DDF62341000000E06C2E5A41	751114109	H	Folie Méricourt 9	7511141	75111	75	11	0
01060000206A080000010000000103000000010000001B0000009A999999FEF723419A999919902E5A410000000011F82341666666E6912E5A41CDCCCCCC38F823419A999959952E5A413333333359F8234133333393982E5A41CDCCCCCC81F82341666666269C2E5A41CDCCCCCCE6F8234100000060A52E5A4166666666ECF82341000000E0A52E5A4100000000FBF8234133333313A72E5A4100000000BEF92341000000A0892E5A419A999999C3F92341CDCCCCCC882E5A4166666666B4F92341CDCCCC8C872E5A4100000000AFF923419A9999F9862E5A419A9999992BF92341000000E0782E5A419A9999990BF9234166666666752E5A413333333305F92341333333B3742E5A4166666666FAF82341000000C0732E5A4100000000E1F8234166666626722E5A41CDCCCCCC9AF823419A9999596D2E5A419A99999994F82341CDCCCC2C6E2E5A416666666690F82341333333B36E2E5A41000000008DF82341333333F36E2E5A410000000081F82341666666466F2E5A41666666666DF8234133333333742E5A419A99999953F82341666666267A2E5A41CDCCCCCC34F8234133333393812E5A41666666662DF8234100000040832E5A419A999999FEF723419A999919902E5A41	01060000206A08000001000000010300000001000000090000009A999999FEF723419A999919902E5A4100000000FBF8234133333313A72E5A419A999999C3F92341CDCCCCCC882E5A413333333305F92341333333B3742E5A41CDCCCCCC9AF823419A9999596D2E5A410000000081F82341666666466F2E5A41666666662DF8234100000040832E5A419A999999FEF723419A999919902E5A419A999999FEF723419A999919902E5A41	01010000206A080000FA48267AD9F82341CDCCCCDC8C2E5A41	751114110	H	Folie Méricourt 10	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000170000006666666618F7234166666666D42E5A413333333332F7234100000000D62E5A41000000004AF7234133333393D72E5A41CDCCCCCCA1F72341666666A6DD2E5A4166666666AEF723419A999999DE2E5A4100000000BEF723419A9999D9DB2E5A41CDCCCCCC37F8234166666666C52E5A416666666677F8234100000000BB2E5A4100000000FBF8234133333313A72E5A4166666666ECF82341000000E0A52E5A41CDCCCCCCE6F8234100000060A52E5A41CDCCCCCC81F82341666666269C2E5A413333333359F8234133333393982E5A41CDCCCCCC38F823419A999959952E5A410000000011F82341666666E6912E5A419A999999FEF723419A999919902E5A4100000000F2F723419A9999D9922E5A41CDCCCCCCE9F7234166666626952E5A4166666666ADF72341333333F3A72E5A410000000097F72341CDCCCCECAE2E5A41CDCCCCCC72F723419A999919AD2E5A419A99999991F72341CDCCCC2CC52E5A416666666618F7234166666666D42E5A41	01060000206A080000010000000103000000010000000C0000006666666618F7234166666666D42E5A4166666666AEF723419A999999DE2E5A41CDCCCCCC37F8234166666666C52E5A416666666677F8234100000000BB2E5A4100000000FBF8234133333313A72E5A419A999999FEF723419A999919902E5A41CDCCCCCCE9F7234166666626952E5A410000000097F72341CDCCCCECAE2E5A41CDCCCCCC72F723419A999919AD2E5A419A99999991F72341CDCCCC2CC52E5A416666666618F7234166666666D42E5A416666666618F7234166666666D42E5A41	01010000206A08000091AB49110EF82341666666F6B42E5A41	751114111	H	Folie Méricourt 11	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000170000003333333364F62341333333B3C82E5A410000000094F62341CDCCCCCCCB2E5A4133333333A1F62341CDCCCCACCC2E5A419A999999FAF6234100000080D22E5A410000000001F72341666666E6D22E5A41CDCCCCCC14F72341CDCCCC2CD42E5A416666666618F7234166666666D42E5A419A99999991F72341CDCCCC2CC52E5A41CDCCCCCC72F723419A999919AD2E5A410000000097F72341CDCCCCECAE2E5A4166666666ADF72341333333F3A72E5A41CDCCCCCCE9F7234166666626952E5A4100000000F2F723419A9999D9922E5A419A999999FEF723419A999919902E5A4100000000F0F723419A9999F98E2E5A4166666666A5F72341333333938A2E5A41CDCCCCCC50F7234166666686852E5A416666666615F72341CDCCCC4C932E5A4100000000D1F62341CDCCCC0CA42E5A4166666666E7F6234133333353A52E5A41CDCCCCCCDCF62341CDCCCC2CA82E5A419A999999B6F623419A999999B22E5A413333333364F62341333333B3C82E5A41	01060000206A080000010000000103000000010000000C0000003333333364F62341333333B3C82E5A416666666618F7234166666666D42E5A419A99999991F72341CDCCCC2CC52E5A41CDCCCCCC72F723419A999919AD2E5A410000000097F72341CDCCCCECAE2E5A41CDCCCCCCE9F7234166666626952E5A419A999999FEF723419A999919902E5A41CDCCCCCC50F7234166666686852E5A4100000000D1F62341CDCCCC0CA42E5A4166666666E7F6234133333353A52E5A413333333364F62341333333B3C82E5A413333333364F62341333333B3C82E5A41	01010000206A0800008684E0453CF72341343333A3AA2E5A41	751114112	H	Folie Méricourt 12	7511141	75111	75	11	0
01060000206A080000010000000103000000010000001A000000CDCCCCCC5FF523419A999919B62E5A419A999999A2F5234166666646BA2E5A4100000000B9F523419A9999B9BB2E5A41CDCCCCCCD5F52341000000E0BD2E5A416666666614F62341333333F3C22E5A410000000016F6234133333313C32E5A41CDCCCCCC2AF623419A9999D9C42E5A41333333333BF6234100000000C62E5A419A99999960F623419A999979C82E5A413333333364F62341333333B3C82E5A419A999999B6F623419A999999B22E5A41CDCCCCCCDCF62341CDCCCC2CA82E5A4166666666E7F6234133333353A52E5A4100000000D1F62341CDCCCC0CA42E5A416666666615F72341CDCCCC4C932E5A41CDCCCCCC50F7234166666686852E5A41CDCCCCCC1FF72341CDCCCC4C822E5A41CDCCCCCC9BF62341CDCCCC4C7B2E5A410000000086F62341666666667A2E5A416666666638F623419A9999598A2E5A416666666626F62341333333938D2E5A41CDCCCCCCF5F5234166666606972E5A4166666666F3F523419A999979972E5A41000000009EF5234100000080A82E5A413333333379F523419A999939B02E5A41CDCCCCCC5FF523419A999919B62E5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCC5FF523419A999919B62E5A4100000000B9F523419A9999B9BB2E5A413333333364F62341333333B3C82E5A4166666666E7F6234133333353A52E5A4100000000D1F62341CDCCCC0CA42E5A41CDCCCCCC50F7234166666686852E5A41CDCCCCCC1FF72341CDCCCC4C822E5A410000000086F62341666666667A2E5A416666666638F623419A9999598A2E5A41000000009EF5234100000080A82E5A41CDCCCCCC5FF523419A999919B62E5A41CDCCCCCC5FF523419A999919B62E5A41	01010000206A080000F2CAAA445FF62341343333C39D2E5A41	751114113	H	Folie Méricourt 13	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000170000009A99999998F423419A9999F9AA2E5A41CDCCCCCC5FF523419A999919B62E5A413333333379F523419A999939B02E5A41000000009EF5234100000080A82E5A4166666666F3F523419A999979972E5A41CDCCCCCCF5F5234166666606972E5A416666666626F62341333333938D2E5A416666666638F623419A9999598A2E5A410000000086F62341666666667A2E5A41666666663FF6234133333353772E5A419A999999A0F5234133333373712E5A41333333337CF52341000000C0702E5A419A99999969F52341000000A0702E5A41CDCCCCCC4CF52341000000C0702E5A410000000034F52341CDCCCC2C712E5A410000000019F5234166666646712E5A4166666666FDF4234133333373782E5A4133333333E0F423419A999919802E5A41CDCCCCCC30F52341000000E0862E5A41000000003AF52341000000A0872E5A4133333333EBF423419A9999F9982E5A41CDCCCCCCA2F42341666666C6A82E5A419A99999998F423419A9999F9AA2E5A41	01060000206A080000010000000103000000010000000B0000009A99999998F423419A9999F9AA2E5A41CDCCCCCC5FF523419A999919B62E5A41000000009EF5234100000080A82E5A416666666638F623419A9999598A2E5A410000000086F62341666666667A2E5A419A999999A0F5234133333373712E5A410000000019F5234166666646712E5A4133333333E0F423419A999919802E5A41000000003AF52341000000A0872E5A419A99999998F423419A9999F9AA2E5A419A99999998F423419A9999F9AA2E5A41	01010000206A0800006410E7CE8BF52341CCCCCC4C922E5A41	751114114	H	Folie Méricourt 14	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000190000006666666676F2234166666686882E5A41CDCCCCCC7AF22341000000E0882E5A41CDCCCCCCA9F22341CDCCCC2C8C2E5A41CDCCCCCC56F3234133333373982E5A419A999999C0F32341CDCCCCAC9E2E5A41333333334FF4234133333393A62E5A41CDCCCCCC73F42341CDCCCCCCA82E5A419A99999998F423419A9999F9AA2E5A41CDCCCCCCA2F42341666666C6A82E5A4133333333EBF423419A9999F9982E5A41000000003AF52341000000A0872E5A41CDCCCCCC30F52341000000E0862E5A4133333333E0F423419A999919802E5A4166666666FDF4234133333373782E5A410000000019F5234166666646712E5A4166666666F1F4234166666666732E5A4100000000ABF42341CDCCCC6C752E5A416666666651F42341333333B3772E5A416666666693F32341CDCCCC6C7C2E5A41666666663EF32341CDCCCCAC7E2E5A4166666666E1F223419A9999B9802E5A4166666666BDF2234166666646812E5A4166666666B0F22341000000A0812E5A4100000000A0F223419A999999822E5A416666666676F2234166666686882E5A41	01060000206A080000010000000103000000010000000B0000006666666676F2234166666686882E5A41CDCCCCCC56F3234133333373982E5A419A99999998F423419A9999F9AA2E5A41000000003AF52341000000A0872E5A4133333333E0F423419A999919802E5A410000000019F5234166666646712E5A4100000000ABF42341CDCCCC6C752E5A41666666663EF32341CDCCCCAC7E2E5A4166666666B0F22341000000A0812E5A416666666676F2234166666686882E5A416666666676F2234166666686882E5A41	01010000206A08000020593CE104F4234100000050922E5A41	751114115	H	Folie Méricourt 15	7511141	75111	75	11	0
01060000206A0800000100000001030000000100000026000000CDCCCCCC06F3234166666666412E5A410000000032F32341CDCCCCCC3F2E5A416666666655F32341000000803E2E5A41CDCCCCCC6DF32341333333933D2E5A419A9999997BF32341333333133D2E5A4166666666CAF32341333333333A2E5A419A999999FAF3234100000040382E5A413333333307F42341666666C6372E5A41CDCCCCCC0FF42341CDCCCC6C372E5A41CDCCCCCC2BF42341CDCCCC6C362E5A41000000005DF42341CDCCCC8C342E5A41CDCCCCCC8EF42341333333F3322E5A419A999999E0F42341666666A62F2E5A41666666660DF52341333333132E2E5A416666666619F523419A9999992D2E5A419A99999941F52341CDCCCC0C2C2E5A41000000000AF62341CDCCCCAC242E5A41000000004AF6234100000020222E5A41333333336AF62341CDCCCCCC202E5A4133333333A1F62341666666061F2E5A41CDCCCCCCBCF62341666666061E2E5A41CDCCCCCC62F62341666666261C2E5A419A999999D1F5234166666686172E5A419A99999962F52341333333D3132E5A419A99999928F52341666666E6112E5A416666666607F5234166666686102E5A41CDCCCCCCBEF42341333333B30D2E5A41000000008CF42341CDCCCCEC092E5A416666666665F4234133333313072E5A410000000057F423419A9999D9052E5A416666666645F423419A999959042E5A413333333341F423419A9999F9032E5A41000000002DF4234100000040022E5A419A9999992AF4234166666606022E5A410000000014F4234166666646002E5A4133333333C2F3234166666626142E5A41333333335DF32341666666462D2E5A41CDCCCCCC06F3234166666666412E5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCC06F3234166666666412E5A419A999999E0F42341666666A62F2E5A41CDCCCCCCBCF62341666666061E2E5A41CDCCCCCC62F62341666666261C2E5A419A99999928F52341666666E6112E5A41CDCCCCCCBEF42341333333B30D2E5A410000000014F4234166666646002E5A41333333335DF32341666666462D2E5A41CDCCCCCC06F3234166666666412E5A41CDCCCCCC06F3234166666666412E5A41	01010000206A08000052537D64F3F4234166666676212E5A41	751114104	H	Folie Méricourt 4	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000210000009A999999EAF02341666666464C2E5A419A999999F8F02341CDCCCC8C4E2E5A416666666605F1234166666646502E5A41CDCCCCCC1CF12341CDCCCC4C532E5A41CDCCCCCC35F123419A999999522E5A419A99999968F12341CDCCCCCC502E5A4133333333A2F12341000000804E2E5A4100000000DAF12341CDCCCC6C4C2E5A416666666612F22341333333534A2E5A41666666668BF22341CDCCCCCC452E5A4166666666A4F22341000000E0442E5A41CDCCCCCC06F3234166666666412E5A41333333335DF32341666666462D2E5A4133333333C2F3234166666626142E5A410000000014F4234166666646002E5A419A999999C4F3234133333313FA2D5A4100000000BDF323419A999979F92D5A41CDCCCCCC27F32341333333530A2E5A413333333312F32341CDCCCCCC0C2E5A4166666666B5F2234166666666172E5A419A9999998AF22341666666461C2E5A41CDCCCCCC60F2234133333313212E5A419A9999993DF223419A999939252E5A419A9999991EF22341CDCCCCCC282E5A419A99999900F223419A9999392C2E5A41CDCCCCCCDAF12341CDCCCC8C302E5A4166666666B8F1234166666686342E5A416666666694F12341CDCCCC8C382E5A413333333369F12341666666663D2E5A41666666663AF12341666666A6422E5A41666666660EF12341666666C6472E5A419A99999902F1234100000020492E5A419A999999EAF02341666666464C2E5A41	01060000206A08000001000000010300000001000000090000009A999999EAF02341666666464C2E5A41CDCCCCCC1CF12341CDCCCC4C532E5A41CDCCCCCC06F3234166666666412E5A41333333335DF32341666666462D2E5A410000000014F4234166666646002E5A4100000000BDF323419A999979F92D5A41CDCCCCCC27F32341333333530A2E5A419A999999EAF02341666666464C2E5A419A999999EAF02341666666464C2E5A41	01010000206A080000B492C03CD2F2234134333303272E5A41	751114105	H	Folie Méricourt 5	7511141	75111	75	11	0
01060000206A0800000100000001030000000100000028000000CDCCCCCCBCF02341000000203F2E5A4166666666BDF02341333333F3422E5A4100000000C0F02341CDCCCCCC442E5A4166666666C5F0234133333393462E5A4100000000CBF02341000000C0482E5A4100000000DBF023419A9999994A2E5A419A999999EAF02341666666464C2E5A419A99999902F1234100000020492E5A41666666660EF12341666666C6472E5A41666666663AF12341666666A6422E5A413333333369F12341666666663D2E5A416666666694F12341CDCCCC8C382E5A4166666666B8F1234166666686342E5A41CDCCCCCCDAF12341CDCCCC8C302E5A419A99999900F223419A9999392C2E5A419A9999991EF22341CDCCCCCC282E5A419A9999993DF223419A999939252E5A41CDCCCCCC60F2234133333313212E5A419A9999998AF22341666666461C2E5A4166666666B5F2234166666666172E5A413333333312F32341CDCCCCCC0C2E5A41CDCCCCCC27F32341333333530A2E5A4100000000BDF323419A999979F92D5A41333333333FF3234133333373EF2D5A41CDCCCCCC99F22341CDCCCC2CE32D5A41CDCCCCCC1FF2234133333313DA2D5A4100000000E0F12341666666E6D52D5A419A999999D2F123419A9999B9E12D5A4166666666CCF12341CDCCCCACE62D5A419A999999C3F1234133333333EA2D5A410000000097F123419A999959F82D5A41CDCCCCCC4AF12341CDCCCCAC102E5A41CDCCCCCC43F12341CDCCCCEC122E5A41CDCCCCCC2BF123419A9999991A2E5A41666666660EF123419A999959242E5A41CDCCCCCCFFF02341CDCCCCCC282E5A419A999999EDF02341666666862E2E5A419A999999DCF0234166666606342E5A4166666666C1F02341333333F33C2E5A41CDCCCCCCBCF02341000000203F2E5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCCBCF02341000000203F2E5A4100000000CBF02341000000C0482E5A419A999999EAF02341666666464C2E5A41CDCCCCCC27F32341333333530A2E5A4100000000BDF323419A999979F92D5A41333333333FF3234133333373EF2D5A41CDCCCCCC1FF2234133333313DA2D5A4100000000E0F12341666666E6D52D5A419A999999C3F1234133333333EA2D5A419A999999EDF02341666666862E2E5A41CDCCCCCCBCF02341000000203F2E5A41CDCCCCCCBCF02341000000203F2E5A41	01010000206A080000782BFBDC16F22341CDCCCCCC112E5A41	751114106	H	Folie Méricourt 6	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000270000003333333329FA2341CDCCCCEC462E5A410000000072FA2341333333334A2E5A41CDCCCCCCE8FA2341333333934F2E5A416666666602FB2341666666C6502E5A41CDCCCCCC09FB234100000020512E5A419A99999910FB234166666666512E5A419A99999923FB234100000000522E5A41000000002EFB23419A999959522E5A41CDCCCCCC38FB2341CDCCCCEC4E2E5A419A9999994DFB23419A999919482E5A419A99999963FB234100000000422E5A413333333378FB2341CDCCCCEC3C2E5A41CDCCCCCC7EFB23419A9999D93B2E5A4100000000A8FB234100000000352E5A4166666666E1FB23419A9999792B2E5A41CDCCCCCC18FC23419A9999F9212E5A41CDCCCCCC37FC2341CDCCCCAC1C2E5A41CDCCCCCC61FC234166666666152E5A4166666666E0FC234133333373002E5A416666666685FD234100000000E42D5A41CDCCCCCC7CFD2341CDCCCC8CE32D5A413333333372FD2341CDCCCC8CE32D5A419A99999951FD2341666666E6DF2D5A419A99999999FC234166666666E62D5A410000000034FC234133333333EA2D5A413333333356FB234166666626F22D5A41000000008CFB23419A999919092E5A419A9999997DFB2341333333F3082E5A419A99999965FB2341CDCCCC8C072E5A419A9999995BFB2341333333F3062E5A416666666653FB2341666666C6062E5A41666666663EFB2341CDCCCC6C072E5A419A99999934FB234166666666072E5A413333333334FB234133333313082E5A416666666619FB234166666686122E5A419A999999F1FA2341666666661C2E5A419A999999B9FA2341000000A0212E5A4166666666ACFA2341CDCCCC6C232E5A413333333329FA2341CDCCCCEC462E5A41	01060000206A08000001000000010300000001000000100000003333333329FA2341CDCCCCEC462E5A41000000002EFB23419A999959522E5A413333333378FB2341CDCCCCEC3C2E5A41CDCCCCCC61FC234166666666152E5A4166666666E0FC234133333373002E5A416666666685FD234100000000E42D5A419A99999951FD2341666666E6DF2D5A413333333356FB234166666626F22D5A41000000008CFB23419A999919092E5A416666666653FB2341666666C6062E5A413333333334FB234133333313082E5A416666666619FB234166666686122E5A419A999999F1FA2341666666661C2E5A4166666666ACFA2341CDCCCC6C232E5A413333333329FA2341CDCCCCEC462E5A413333333329FA2341CDCCCCEC462E5A41	01010000206A080000901A6BA6A6FB2341666666E6182E5A41	751114201	H	Saint-Ambroise 1	7511142	75111	75	11	0
01060000206A080000010000000103000000010000001F0000000000000013FA2341000000A0FC2D5A416666666616FA234133333373FE2D5A410000000023FA234100000000FE2D5A41CDCCCCCC23FA23419A9999F9FD2D5A41000000003FFA2341CDCCCCECFC2D5A41CDCCCCCCACFA2341000000C0F82D5A419A999999B6FA234100000060F82D5A413333333356FB234166666626F22D5A410000000034FC234133333333EA2D5A419A99999999FC234166666666E62D5A419A99999951FD2341666666E6DF2D5A413333333372FD2341CDCCCC8CE32D5A41CDCCCCCC7CFD2341CDCCCC8CE32D5A416666666685FD234100000000E42D5A41CDCCCCCC98FD23419A999979E02D5A41000000009FFD2341000000C0DE2D5A41CDCCCCCC90FD2341333333D3DD2D5A41CDCCCCCC88FD234166666666DD2D5A41333333333EFD234166666686D92D5A4166666666CEFC2341000000E0D32D5A410000000077FC2341CDCCCC8CCF2D5A416666666660FC23419A999959CE2D5A4166666666F4FB23419A999979CA2D5A4100000000D5FB234100000060C92D5A41CDCCCCCCC1FB23419A999979C82D5A416666666655FB2341CDCCCC4CC22D5A419A999999E2FA234166666626BB2D5A4166666666DBFA23419A9999B9BA2D5A41000000009AFA234100000080CF2D5A419A9999995EFA234166666666E32D5A410000000013FA2341000000A0FC2D5A41	01060000206A080000010000000103000000010000000D0000000000000013FA2341000000A0FC2D5A416666666616FA234133333373FE2D5A413333333356FB234166666626F22D5A419A99999951FD2341666666E6DF2D5A416666666685FD234100000000E42D5A41000000009FFD2341000000C0DE2D5A416666666660FC23419A999959CE2D5A4100000000D5FB234100000060C92D5A416666666655FB2341CDCCCC4CC22D5A4166666666DBFA23419A9999B9BA2D5A41000000009AFA234100000080CF2D5A410000000013FA2341000000A0FC2D5A410000000013FA2341000000A0FC2D5A41	01010000206A08000039C17BE5ECFB234166666676DB2D5A41	751114202	H	Saint-Ambroise 2	7511142	75111	75	11	0
01060000206A08000001000000010300000001000000170000000000000043F82341333333730F2E5A41666666666EF823419A9999190E2E5A41333333338AF9234133333393032E5A4100000000FAF9234166666686FF2D5A41666666660CFA2341333333D3FE2D5A416666666616FA234133333373FE2D5A410000000013FA2341000000A0FC2D5A419A9999995EFA234166666666E32D5A41000000009AFA234100000080CF2D5A4166666666DBFA23419A9999B9BA2D5A41666666660EFA234166666606AE2D5A413333333306FA234166666686AD2D5A4166666666C2F92341CDCCCC4CBB2D5A41CDCCCCCC7FF92341666666A6CA2D5A41CDCCCCCC75F92341666666A6CC2D5A419A99999953F923419A999999D32D5A413333333331F923419A999999DA2D5A4133333333FFF82341CDCCCCACE42D5A419A999999C2F8234133333353F22D5A41CDCCCCCC9EF8234133333373FA2D5A416666666693F82341CDCCCCECFC2D5A41000000005CF82341333333530A2E5A410000000043F82341333333730F2E5A41	01060000206A080000010000000103000000010000000C0000000000000043F82341333333730F2E5A41666666666EF823419A9999190E2E5A416666666616FA234133333373FE2D5A410000000013FA2341000000A0FC2D5A41000000009AFA234100000080CF2D5A4166666666DBFA23419A9999B9BA2D5A413333333306FA234166666686AD2D5A4166666666C2F92341CDCCCC4CBB2D5A41CDCCCCCC7FF92341666666A6CA2D5A4133333333FFF82341CDCCCCACE42D5A410000000043F82341333333730F2E5A410000000043F82341333333730F2E5A41	01010000206A0800006AEA788CC3F9234100000000DF2D5A41	751114203	H	Saint-Ambroise 3	7511142	75111	75	11	0
01060000206A08000001000000010300000001000000150000009A999999A8F72341CDCCCC0CC72D5A41000000004BF823419A9999F9D42D5A41333333337AF823419A999939D92D5A419A999999A4F823419A9999D9DC2D5A4166666666ADF8234133333393DD2D5A4133333333FFF82341CDCCCCACE42D5A413333333331F923419A999999DA2D5A419A99999953F923419A999999D32D5A41CDCCCCCC75F92341666666A6CC2D5A41CDCCCCCC7FF92341666666A6CA2D5A4166666666C2F92341CDCCCC4CBB2D5A413333333306FA234166666686AD2D5A4100000000B7F92341333333D3A82D5A4166666666B0F9234133333373A82D5A416666666657F92341CDCCCC2CA32D5A41CDCCCCCC9DF8234166666666982D5A413333333399F8234100000020982D5A41000000006AF82341CDCCCC6CA12D5A419A99999923F82341666666A6AF2D5A419A999999DAF7234166666686BD2D5A419A999999A8F72341CDCCCC0CC72D5A41	01060000206A08000001000000010300000001000000090000009A999999A8F72341CDCCCC0CC72D5A4133333333FFF82341CDCCCCACE42D5A41CDCCCCCC7FF92341666666A6CA2D5A4166666666C2F92341CDCCCC4CBB2D5A413333333306FA234166666686AD2D5A413333333399F8234100000020982D5A419A99999923F82341666666A6AF2D5A419A999999A8F72341CDCCCC0CC72D5A419A999999A8F72341CDCCCC0CC72D5A41	01010000206A080000323C69D7B2F823419A999949C22D5A41	751114204	H	Saint-Ambroise 4	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000010000000CDCCCCCC32F62341CDCCCCECBF2D5A416666666660F72341333333F3D82D5A41CDCCCCCC99F7234100000020CA2D5A419A999999A8F72341CDCCCC0CC72D5A419A999999DAF7234166666686BD2D5A419A99999923F82341666666A6AF2D5A41000000006AF82341CDCCCC6CA12D5A413333333399F8234100000020982D5A416666666690F72341333333B3882D5A4166666666C4F6234166666666A02D5A419A999999BBF62341CDCCCC6CA12D5A4166666666AEF62341333333F3A22D5A410000000061F62341333333F3AB2D5A416666666688F62341000000C0AE2D5A413333333363F62341CDCCCCCCB62D5A41CDCCCCCC32F62341CDCCCCECBF2D5A41	01060000206A0800000100000001030000000100000010000000CDCCCCCC32F62341CDCCCCECBF2D5A416666666660F72341333333F3D82D5A41CDCCCCCC99F7234100000020CA2D5A419A999999A8F72341CDCCCC0CC72D5A419A999999DAF7234166666686BD2D5A419A99999923F82341666666A6AF2D5A41000000006AF82341CDCCCC6CA12D5A413333333399F8234100000020982D5A416666666690F72341333333B3882D5A4166666666C4F6234166666666A02D5A419A999999BBF62341CDCCCC6CA12D5A4166666666AEF62341333333F3A22D5A410000000061F62341333333F3AB2D5A416666666688F62341000000C0AE2D5A413333333363F62341CDCCCCCCB62D5A41CDCCCCCC32F62341CDCCCCECBF2D5A41	01010000206A0800005C6F784142F723419A999939B32D5A41	751114205	H	Saint-Ambroise 5	7511142	75111	75	11	0
01060000206A080000010000000103000000010000002D000000333333332AF4234133333333532D5A419A99999961F42341333333136A2D5A410000000065F423419A9999796B2D5A41CDCCCCCC7EF42341CDCCCC2C762D5A419A99999982F423419A9999B9772D5A4133333333AFF42341333333D3892D5A4166666666D0F4234100000040972D5A41CDCCCCCCD5F42341CDCCCCEC992D5A4133333333E6F4234100000020A22D5A41CDCCCCCCECF42341000000C0A62D5A4133333333F1F423419A999919AB2D5A4100000000F4F4234166666666B02D5A419A999999F3F42341CDCCCC4CB12D5A419A999999EFF42341CDCCCC0CBC2D5A4100000000EBF4234133333373C12D5A419A999999E3F423419A999939C62D5A4166666666C5F423419A999959D22D5A419A999999BAF423419A9999F9D52D5A41CDCCCCCC7BF4234100000080E32D5A4100000000B7F42341000000A0DC2D5A419A999999C5F4234100000000DB2D5A41CDCCCCCCD3F4234100000080D92D5A419A999999EEF4234166666626D62D5A41CDCCCCCCFEF423419A999959D42D5A41666666661CF5234100000080D12D5A41333333334BF5234166666686CB2D5A41666666665BF523419A9999B9C92D5A410000000061F62341333333F3AB2D5A4166666666AEF62341333333F3A22D5A419A999999BBF62341CDCCCC6CA12D5A4166666666C4F6234166666666A02D5A416666666690F72341333333B3882D5A41CDCCCCCC39F7234100000040842D5A416666666601F7234133333393802D5A410000000078F62341CDCCCC4C782D5A4166666666CCF52341000000206E2D5A41CDCCCCCCD5F423419A9999595E2D5A41CDCCCCCCC3F42341000000C05C2D5A419A9999998FF42341CDCCCCAC592D5A416666666685F4234166666606592D5A41333333337CF42341CDCCCC8C582D5A419A99999967F4234100000060572D5A419A9999994EF42341333333B3552D5A416666666648F4234166666646552D5A41333333332AF4234133333333532D5A41	01060000206A080000010000000103000000010000000E000000333333332AF4234133333333532D5A4166666666D0F4234100000040972D5A4133333333E6F4234100000020A22D5A4100000000F4F4234166666666B02D5A419A999999E3F423419A999939C62D5A419A999999BAF423419A9999F9D52D5A41CDCCCCCC7BF4234100000080E32D5A41333333334BF5234166666686CB2D5A410000000061F62341333333F3AB2D5A416666666690F72341333333B3882D5A416666666601F7234133333393802D5A4166666666CCF52341000000206E2D5A41333333332AF4234133333333532D5A41333333332AF4234133333333532D5A41	01010000206A080000D2286345DEF523419A9999299D2D5A41	751114206	H	Saint-Ambroise 6	7511142	75111	75	11	0
01060000206A080000010000000103000000010000001D000000CDCCCCCC44F22341CDCCCC8C822D5A410000000072F2234100000040832D5A41CDCCCCCC98F2234166666626842D5A419A999999C6F2234133333333852D5A4166666666CDF2234133333333852D5A41CDCCCCCCD2F223419A9999D9842D5A41CDCCCCCCD4F2234133333353842D5A4100000000DEF2234166666666802D5A41666666660BF3234133333373822D5A419A99999934F32341CDCCCC4C842D5A41666666663CF32341CDCCCCAC842D5A419A99999967F32341666666E6862D5A41000000008DF323419A999999882D5A419A99999929F4234100000040902D5A4133333333BBF423419A9999F9962D5A4166666666D0F4234100000040972D5A4133333333AFF42341333333D3892D5A419A99999982F423419A9999B9772D5A41CDCCCCCC7EF42341CDCCCC2C762D5A410000000065F423419A9999796B2D5A419A99999961F42341333333136A2D5A41333333332AF4234133333333532D5A41CDCCCCCC89F3234100000080492D5A4133333333F7F22341666666E6402D5A41CDCCCCCC9AF223419A9999F93B2D5A416666666683F22341333333534E2D5A41CDCCCCCC63F2234133333333692D5A41333333334CF22341666666667C2D5A41CDCCCCCC44F22341CDCCCC8C822D5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCC44F22341CDCCCC8C822D5A419A999999C6F2234133333333852D5A4100000000DEF2234166666666802D5A4133333333BBF423419A9999F9962D5A4166666666D0F4234100000040972D5A41333333332AF4234133333333532D5A4133333333F7F22341666666E6402D5A41CDCCCCCC9AF223419A9999F93B2D5A41CDCCCCCC44F22341CDCCCC8C822D5A41CDCCCCCC44F22341CDCCCC8C822D5A41	01010000206A0800008A1CBEE661F32341333333A3692D5A41	751114207	H	Saint-Ambroise 7	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000020000000333333331DF22341000000C0A32D5A41CDCCCCCC2CF223419A999919A42D5A413333333368F22341000000A0A62D5A4133333333B3F32341CDCCCC6CB62D5A4100000000B9F4234133333393C32D5A419A999999E3F423419A999939C62D5A4100000000EBF4234133333373C12D5A419A999999EFF42341CDCCCC0CBC2D5A419A999999F3F42341CDCCCC4CB12D5A4100000000F4F4234166666666B02D5A4133333333F1F423419A999919AB2D5A41CDCCCCCCECF42341000000C0A62D5A4133333333E6F4234100000020A22D5A41CDCCCCCCD5F42341CDCCCCEC992D5A4166666666D0F4234100000040972D5A4133333333BBF423419A9999F9962D5A419A99999929F4234100000040902D5A41000000008DF323419A999999882D5A419A99999967F32341666666E6862D5A41666666663CF32341CDCCCCAC842D5A419A99999934F32341CDCCCC4C842D5A41666666660BF3234133333373822D5A4100000000DEF2234166666666802D5A41CDCCCCCCD4F2234133333353842D5A41CDCCCCCCD2F223419A9999D9842D5A4166666666CDF2234133333333852D5A419A999999C6F2234133333333852D5A41CDCCCCCC98F2234166666626842D5A410000000072F2234100000040832D5A41CDCCCCCC44F22341CDCCCC8C822D5A413333333330F22341333333F3932D5A41333333331DF22341000000C0A32D5A41	01060000206A080000010000000103000000010000000E000000333333331DF22341000000C0A32D5A413333333368F22341000000A0A62D5A4133333333B3F32341CDCCCC6CB62D5A4100000000B9F4234133333393C32D5A419A999999E3F423419A999939C62D5A4100000000F4F4234166666666B02D5A4133333333E6F4234100000020A22D5A4166666666D0F4234100000040972D5A4133333333BBF423419A9999F9962D5A4100000000DEF2234166666666802D5A419A999999C6F2234133333333852D5A41CDCCCCCC44F22341CDCCCC8C822D5A41333333331DF22341000000C0A32D5A41333333331DF22341000000C0A32D5A41	01010000206A080000F291ACC482F32341000000F0A22D5A41	751114208	H	Saint-Ambroise 8	7511142	75111	75	11	0
01060000206A080000010000000103000000010000001500000000000000E0F12341666666E6D52D5A41CDCCCCCC1FF2234133333313DA2D5A41CDCCCCCC99F22341CDCCCC2CE32D5A41333333333FF3234133333373EF2D5A4100000000BDF323419A999979F92D5A41CDCCCCCC1AF4234166666666EE2D5A410000000055F42341CDCCCC8CE72D5A416666666664F42341CDCCCCECE52D5A41CDCCCCCC7BF4234100000080E32D5A419A999999BAF423419A9999F9D52D5A4166666666C5F423419A999959D22D5A419A999999E3F423419A999939C62D5A4100000000B9F4234133333393C32D5A4133333333B3F32341CDCCCC6CB62D5A413333333368F22341000000A0A62D5A41CDCCCCCC2CF223419A999919A42D5A41333333331DF22341000000C0A32D5A419A99999912F22341000000A0AC2D5A416666666605F2234166666666B72D5A4133333333FDF1234100000040BE2D5A4100000000E0F12341666666E6D52D5A41	01060000206A080000010000000103000000010000000D00000000000000E0F12341666666E6D52D5A41CDCCCCCC1FF2234133333313DA2D5A41333333333FF3234133333373EF2D5A4100000000BDF323419A999979F92D5A41CDCCCCCC7BF4234100000080E32D5A419A999999BAF423419A9999F9D52D5A419A999999E3F423419A999939C62D5A4100000000B9F4234133333393C32D5A4133333333B3F32341CDCCCC6CB62D5A413333333368F22341000000A0A62D5A41333333331DF22341000000C0A32D5A4100000000E0F12341666666E6D52D5A4100000000E0F12341666666E6D52D5A41	01010000206A080000B00B242F60F323419A999949CC2D5A41	751114209	H	Saint-Ambroise 9	7511142	75111	75	11	0
01060000206A080000010000000103000000010000002700000000000000BDF323419A999979F92D5A419A999999C4F3234133333313FA2D5A410000000014F4234166666646002E5A419A9999992AF4234166666606022E5A41000000002DF4234100000040022E5A413333333341F423419A9999F9032E5A416666666645F423419A999959042E5A410000000057F423419A9999D9052E5A416666666665F4234133333313072E5A41000000008CF42341CDCCCCEC092E5A41CDCCCCCCBEF42341333333B30D2E5A416666666607F5234166666686102E5A419A99999928F52341666666E6112E5A419A99999962F52341333333D3132E5A419A999999D1F5234166666686172E5A41CDCCCCCC62F62341666666261C2E5A41666666667CF6234100000020152E5A41333333339DF62341CDCCCCCC0C2E5A419A999999AEF62341666666E6072E5A41CDCCCCCCC0F6234100000060032E5A419A999999D5F62341CDCCCC8CFD2D5A416666666661F623419A999959F52D5A419A99999939F6234100000020F22D5A419A99999900F62341000000E0ED2D5A419A99999975F52341CDCCCC8CE12D5A4166666666C5F5234100000060D32D5A41CDCCCCCCC7F52341333333F3D22D5A41333333334BF5234166666686CB2D5A41666666661CF5234100000080D12D5A41CDCCCCCCFEF423419A999959D42D5A419A999999EEF4234166666626D62D5A41CDCCCCCCD3F4234100000080D92D5A419A999999C5F4234100000000DB2D5A4100000000B7F42341000000A0DC2D5A41CDCCCCCC7BF4234100000080E32D5A416666666664F42341CDCCCCECE52D5A410000000055F42341CDCCCC8CE72D5A41CDCCCCCC1AF4234166666666EE2D5A4100000000BDF323419A999979F92D5A41	01060000206A080000010000000103000000010000000C00000000000000BDF323419A999979F92D5A416666666665F4234133333313072E5A41CDCCCCCCBEF42341333333B30D2E5A419A99999928F52341666666E6112E5A41CDCCCCCC62F62341666666261C2E5A419A999999D5F62341CDCCCC8CFD2D5A419A99999900F62341000000E0ED2D5A419A99999975F52341CDCCCC8CE12D5A41CDCCCCCCC7F52341333333F3D22D5A41333333334BF5234166666686CB2D5A4100000000BDF323419A999979F92D5A4100000000BDF323419A999979F92D5A41	01010000206A080000D715058C1DF52341CDCCCCBCF32D5A41	751114210	H	Saint-Ambroise 10	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000013000000333333334BF5234166666686CB2D5A41CDCCCCCCC7F52341333333F3D22D5A4166666666C5F5234100000060D32D5A419A99999975F52341CDCCCC8CE12D5A419A99999900F62341000000E0ED2D5A419A99999939F6234100000020F22D5A416666666661F623419A999959F52D5A419A999999D5F62341CDCCCC8CFD2D5A4166666666EFF62341000000A0F62D5A413333333302F7234100000000F22D5A41CDCCCCCC25F7234100000060E82D5A419A99999931F72341666666A6E52D5A416666666660F72341333333F3D82D5A41CDCCCCCC32F62341CDCCCCECBF2D5A413333333363F62341CDCCCCCCB62D5A416666666688F62341000000C0AE2D5A410000000061F62341333333F3AB2D5A41666666665BF523419A9999B9C92D5A41333333334BF5234166666686CB2D5A41	01060000206A080000010000000103000000010000000B000000333333334BF5234166666686CB2D5A41CDCCCCCCC7F52341333333F3D22D5A419A99999975F52341CDCCCC8CE12D5A419A99999900F62341000000E0ED2D5A419A999999D5F62341CDCCCC8CFD2D5A416666666660F72341333333F3D82D5A41CDCCCCCC32F62341CDCCCCECBF2D5A416666666688F62341000000C0AE2D5A410000000061F62341333333F3AB2D5A41333333334BF5234166666686CB2D5A41333333334BF5234166666686CB2D5A41	01010000206A08000008F39C417AF623419A999929D62D5A41	751114211	H	Saint-Ambroise 11	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000019000000CDCCCCCC62F62341666666261C2E5A41CDCCCCCCBCF62341666666061E2E5A410000000043F82341333333730F2E5A41000000005CF82341333333530A2E5A416666666693F82341CDCCCCECFC2D5A41CDCCCCCC9EF8234133333373FA2D5A419A999999C2F8234133333353F22D5A4133333333FFF82341CDCCCCACE42D5A4166666666ADF8234133333393DD2D5A419A999999A4F823419A9999D9DC2D5A41333333337AF823419A999939D92D5A41000000004BF823419A9999F9D42D5A419A999999A8F72341CDCCCC0CC72D5A41CDCCCCCC99F7234100000020CA2D5A416666666660F72341333333F3D82D5A419A99999931F72341666666A6E52D5A41CDCCCCCC25F7234100000060E82D5A413333333302F7234100000000F22D5A4166666666EFF62341000000A0F62D5A419A999999D5F62341CDCCCC8CFD2D5A41CDCCCCCCC0F6234100000060032E5A419A999999AEF62341666666E6072E5A41333333339DF62341CDCCCCCC0C2E5A41666666667CF6234100000020152E5A41CDCCCCCC62F62341666666261C2E5A41	01060000206A0800000100000001030000000100000009000000CDCCCCCC62F62341666666261C2E5A41CDCCCCCCBCF62341666666061E2E5A410000000043F82341333333730F2E5A4133333333FFF82341CDCCCCACE42D5A419A999999A8F72341CDCCCC0CC72D5A41CDCCCCCC99F7234100000020CA2D5A4166666666EFF62341000000A0F62D5A41CDCCCCCC62F62341666666261C2E5A41CDCCCCCC62F62341666666261C2E5A41	01010000206A0800001DC813A2D8F723419A999979F42D5A41	751114212	H	Saint-Ambroise 12	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCCBCF62341666666061E2E5A419A999999C7F62341CDCCCC0C202E5A41CDCCCCCCF0F623419A9999F9212E5A419A999999E2F72341666666A62C2E5A419A9999994BF823419A999939312E5A41CDCCCCCC91F8234166666646342E5A41CDCCCCCCF6F82341CDCCCCAC382E5A419A9999990DF9234166666606332E5A419A9999993CF92341CDCCCC0C282E5A419A99999940F923419A999919272E5A41CDCCCCCCD0F9234166666606302E5A4166666666D9F92341CDCCCCCC2D2E5A4100000000F3F92341CDCCCC4C272E5A413333333347FA2341CDCCCC0C122E5A41666666666FFA234100000000082E5A413333333327FA23419A9999F9022E5A410000000016FA2341000000A0012E5A419A9999990FFA23419A999939002E5A41666666660CFA2341333333D3FE2D5A4100000000FAF9234166666686FF2D5A41333333338AF9234133333393032E5A41666666666EF823419A9999190E2E5A410000000043F82341333333730F2E5A41CDCCCCCCBCF62341666666061E2E5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCCBCF62341666666061E2E5A419A999999C7F62341CDCCCC0C202E5A41CDCCCCCCF6F82341CDCCCCAC382E5A419A99999940F923419A999919272E5A41CDCCCCCCD0F9234166666606302E5A41666666666FFA234100000000082E5A410000000016FA2341000000A0012E5A41666666660CFA2341333333D3FE2D5A41666666666EF823419A9999190E2E5A410000000043F82341333333730F2E5A41CDCCCCCCBCF62341666666061E2E5A41CDCCCCCCBCF62341666666061E2E5A41	01010000206A0800004FAE3649C6F823419A999909182E5A41	751114213	H	Saint-Ambroise 13	7511142	75111	75	11	0
01060000206A0800000100000001030000000100000027000000CDCCCCCCF6F82341CDCCCCAC382E5A410000000011F92341333333F3392E5A416666666687F92341333333533F2E5A413333333392F92341333333D33F2E5A4100000000AEF9234133333313412E5A419A999999C1F9234166666606422E5A413333333329FA2341CDCCCCEC462E5A4166666666ACFA2341CDCCCC6C232E5A419A999999B9FA2341000000A0212E5A419A999999F1FA2341666666661C2E5A416666666619FB234166666686122E5A413333333334FB234133333313082E5A419A99999934FB234166666666072E5A41666666663EFB2341CDCCCC6C072E5A416666666653FB2341666666C6062E5A419A9999995BFB2341333333F3062E5A419A99999965FB2341CDCCCC8C072E5A419A9999997DFB2341333333F3082E5A41000000008CFB23419A999919092E5A413333333356FB234166666626F22D5A419A999999B6FA234100000060F82D5A41CDCCCCCCACFA2341000000C0F82D5A41000000003FFA2341CDCCCCECFC2D5A41CDCCCCCC23FA23419A9999F9FD2D5A410000000023FA234100000000FE2D5A416666666616FA234133333373FE2D5A41666666660CFA2341333333D3FE2D5A419A9999990FFA23419A999939002E5A410000000016FA2341000000A0012E5A413333333327FA23419A9999F9022E5A41666666666FFA234100000000082E5A413333333347FA2341CDCCCC0C122E5A4100000000F3F92341CDCCCC4C272E5A4166666666D9F92341CDCCCCCC2D2E5A41CDCCCCCCD0F9234166666606302E5A419A99999940F923419A999919272E5A419A9999993CF92341CDCCCC0C282E5A419A9999990DF9234166666606332E5A41CDCCCCCCF6F82341CDCCCCAC382E5A41	01060000206A0800000100000001030000000100000010000000CDCCCCCCF6F82341CDCCCCAC382E5A413333333329FA2341CDCCCCEC462E5A4166666666ACFA2341CDCCCC6C232E5A419A999999F1FA2341666666661C2E5A416666666619FB234166666686122E5A413333333334FB234133333313082E5A416666666653FB2341666666C6062E5A41000000008CFB23419A999919092E5A413333333356FB234166666626F22D5A41666666660CFA2341333333D3FE2D5A410000000016FA2341000000A0012E5A41666666666FFA234100000000082E5A41CDCCCCCCD0F9234166666606302E5A419A99999940F923419A999919272E5A41CDCCCCCCF6F82341CDCCCCAC382E5A41CDCCCCCCF6F82341CDCCCCAC382E5A41	01010000206A0800004F6210B874FA2341333333031F2E5A41	751114214	H	Saint-Ambroise 14	7511142	75111	75	11	0
01060000206A080000010000000103000000010000001200000066666666FDFE23419A999939602D5A419A99999906FF2341000000C05F2D5A419A99999917FF2341333333D35E2D5A41CDCCCCCC22FF2341333333335E2D5A41CDCCCCCC54002441666666A64C2D5A41333333335A0024419A9999394C2D5A4133333333620024419A9999994B2D5A410000000085002441CDCCCC0C482D5A410000000019012441000000E0382D5A416666666692012441333333732C2D5A41333333333A012441CDCCCC4C272D5A4100000000AE002441333333D31F2D5A41333333336C002441666666861C2D5A4166666666520024419A9999391B2D5A419A999999D6FF2341333333B3172D5A416666666625FF2341CDCCCC8C502D5A413333333319FF234100000000552D5A4166666666FDFE23419A999939602D5A41	01060000206A080000010000000103000000010000000900000066666666FDFE23419A999939602D5A41CDCCCCCC54002441666666A64C2D5A416666666692012441333333732C2D5A41333333333A012441CDCCCC4C272D5A4166666666520024419A9999391B2D5A419A999999D6FF2341333333B3172D5A416666666625FF2341CDCCCC8C502D5A4166666666FDFE23419A999939602D5A4166666666FDFE23419A999939602D5A41	01010000206A0800005283AC451300244166666676402D5A41	751114301	H	Roquette 1	7511143	75111	75	11	0
01060000206A08000001000000010300000001000000200000003333333392FC23419A999939302D5A41333333337EFD2341CDCCCC4C3B2D5A419A99999983FD2341CDCCCC8C3B2D5A416666666652FD234133333373492D5A4100000000B7FD2341CDCCCC6C4E2D5A4100000000C9FD2341CDCCCC4C4F2D5A4100000000B3FD2341000000A0572D5A410000000006FE23419A9999995A2D5A410000000057FE2341666666865D2D5A41333333339DFE234166666666602D5A4133333333AEFE23419A999919612D5A4100000000C9FE234100000040622D5A419A999999D5FE2341000000A0632D5A419A999999D9FE23419A9999F9622D5A41CDCCCCCCE0FE234166666626622D5A419A999999ECFE23419A999919612D5A4166666666FDFE23419A999939602D5A413333333319FF234100000000552D5A416666666625FF2341CDCCCC8C502D5A419A999999D6FF2341333333B3172D5A41333333332BFF234100000000132D5A4133333333E0FE2341000000C0102D5A419A9999999DFE23419A9999190F2D5A416666666692FE2341CDCCCCCC0E2D5A4133333333FEFD2341CDCCCCAC0A2D5A4100000000A3FD2341CDCCCCEC072D5A41666666666BFD2341CDCCCC8C062D5A416666666631FD234100000080112D5A41666666660BFD234166666686182D5A419A999999EBFC2341000000201E2D5A419A999999BDFC2341CDCCCCEC262D5A413333333392FC23419A999939302D5A41	01060000206A080000010000000103000000010000000E0000003333333392FC23419A999939302D5A419A99999983FD2341CDCCCC8C3B2D5A416666666652FD234133333373492D5A4100000000C9FD2341CDCCCC4C4F2D5A4100000000B3FD2341000000A0572D5A410000000057FE2341666666865D2D5A419A999999D5FE2341000000A0632D5A4166666666FDFE23419A999939602D5A416666666625FF2341CDCCCC8C502D5A419A999999D6FF2341333333B3172D5A41666666666BFD2341CDCCCC8C062D5A419A999999BDFC2341CDCCCCEC262D5A413333333392FC23419A999939302D5A413333333392FC23419A999939302D5A41	01010000206A080000BC3A488C40FE2341343333C3352D5A41	751114302	H	Roquette 2	7511143	75111	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCCC4FC234166666606762D5A4100000000EDFC2341333333F3772D5A413333333349FD2341333333F37B2D5A41000000005BFE2341CDCCCCEC882D5A410000000076FE2341000000E0882D5A419A9999998BFE234100000060802D5A41CDCCCCCCC5FE2341333333F3682D5A4100000000C9FE23419A999979672D5A41CDCCCCCCCCFE23419A999999652D5A4133333333D4FE23419A9999D9632D5A419A999999D5FE2341000000A0632D5A4100000000C9FE234100000040622D5A4133333333AEFE23419A999919612D5A41333333339DFE234166666666602D5A410000000057FE2341666666865D2D5A410000000006FE23419A9999995A2D5A4100000000B3FD2341000000A0572D5A4100000000C9FD2341CDCCCC4C4F2D5A4100000000B7FD2341CDCCCC6C4E2D5A416666666652FD234133333373492D5A41CDCCCCCC10FD2341000000E05C2D5A4100000000ECFC234133333313692D5A41CDCCCCCCEBFC234100000020692D5A41CDCCCCCCC4FC234166666606762D5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCCC4FC234166666606762D5A41000000005BFE2341CDCCCCEC882D5A410000000076FE2341000000E0882D5A419A999999D5FE2341000000A0632D5A410000000057FE2341666666865D2D5A4100000000B3FD2341000000A0572D5A4100000000C9FD2341CDCCCC4C4F2D5A416666666652FD234133333373492D5A41CDCCCCCC10FD2341000000E05C2D5A41CDCCCCCCC4FC234166666606762D5A41CDCCCCCCC4FC234166666606762D5A41	01010000206A0800002C38ECD1C6FD2341333333936F2D5A41	751114303	H	Roquette 3	7511143	75111	75	11	0
01060000206A080000010000000103000000010000000F0000000000000072FB2341666666A6652D5A419A999999D8FB2341333333936A2D5A410000000007FC2341000000E06C2D5A413333333362FC234166666646712D5A41CDCCCCCCC4FC234166666606762D5A41CDCCCCCCEBFC234100000020692D5A4100000000ECFC234133333313692D5A41CDCCCCCC10FD2341000000E05C2D5A416666666652FD234133333373492D5A419A99999983FD2341CDCCCC8C3B2D5A41333333337EFD2341CDCCCC4C3B2D5A413333333392FC23419A999939302D5A41333333334BFC2341000000403D2D5A41CDCCCCCCFFFB2341666666664C2D5A410000000072FB2341666666A6652D5A41	01060000206A08000001000000010300000001000000080000000000000072FB2341666666A6652D5A41CDCCCCCCC4FC234166666606762D5A41CDCCCCCC10FD2341000000E05C2D5A419A99999983FD2341CDCCCC8C3B2D5A413333333392FC23419A999939302D5A41CDCCCCCCFFFB2341666666664C2D5A410000000072FB2341666666A6652D5A410000000072FB2341666666A6652D5A41	01010000206A0800001F0443147FFC2341333333A3542D5A41	751114304	H	Roquette 4	7511143	75111	75	11	0
01060000206A08000001000000010300000001000000240000003333333395F92341666666464E2D5A41000000009EF923419A999939502D5A4166666666A1F92341000000E0512D5A41CDCCCCCCF9F92341000000E0532D5A419A9999990BFA2341666666A6542D5A410000000036FA234133333393562D5A41CDCCCCCC3CFA2341666666E6562D5A416666666643FA234133333333572D5A410000000052FA2341000000E0572D5A419A99999982FA2341666666865A2D5A419A9999998AFA2341333333F35A2D5A416666666695FA2341CDCCCC6C5B2D5A41666666669CFA23419A9999B95B2D5A4133333333DCFA2341333333735E2D5A410000000072FB2341666666A6652D5A41CDCCCCCCFFFB2341666666664C2D5A41333333334BFC2341000000403D2D5A413333333392FC23419A999939302D5A419A999999BDFC2341CDCCCCEC262D5A419A999999EBFC2341000000201E2D5A41666666660BFD234166666686182D5A416666666631FD234100000080112D5A41666666666BFD2341CDCCCC8C062D5A4100000000FDFC234100000000022D5A4166666666DAFC2341CDCCCC6C002D5A410000000064FC234133333313FB2C5A41CDCCCCCCCCFB23419A9999390C2D5A4100000000C2FB2341666666860D2D5A410000000099FB234166666646122D5A41CDCCCCCC3DFB2341000000E01C2D5A4100000000F7FA2341CDCCCCAC242D5A4100000000A7FA2341CDCCCC4C2F2D5A416666666689FA2341000000C0322D5A4133333333DFF92341CDCCCCAC452D5A4133333333AAF92341CDCCCC8C4B2D5A413333333395F92341666666464E2D5A41	01060000206A080000010000000103000000010000000D0000003333333395F92341666666464E2D5A4166666666A1F92341000000E0512D5A41CDCCCCCCF9F92341000000E0532D5A410000000072FB2341666666A6652D5A41CDCCCCCCFFFB2341666666664C2D5A413333333392FC23419A999939302D5A419A999999BDFC2341CDCCCCEC262D5A41666666666BFD2341CDCCCC8C062D5A410000000064FC234133333313FB2C5A4100000000F7FA2341CDCCCCAC242D5A4100000000A7FA2341CDCCCC4C2F2D5A413333333395F92341666666464E2D5A413333333395F92341666666464E2D5A41	01010000206A08000007FC63C68FFB2341CDCCCC7C312D5A41	751114305	H	Roquette 5	7511143	75111	75	11	0
01060000206A080000010000000103000000010000001C000000CDCCCCCC2FF923419A999939482D5A41CDCCCCCC35F92341CDCCCCEC492D5A41CDCCCCCC39F923419A9999D94A2D5A419A99999968F923419A9999194F2D5A41CDCCCCCC72F92341333333534E2D5A41333333337EF92341000000C04D2D5A41333333338BF92341000000C04D2D5A413333333395F92341666666464E2D5A4133333333AAF92341CDCCCC8C4B2D5A4133333333DFF92341CDCCCCAC452D5A416666666689FA2341000000C0322D5A4100000000A7FA2341CDCCCC4C2F2D5A4100000000F7FA2341CDCCCCAC242D5A41CDCCCCCC3DFB2341000000E01C2D5A410000000099FB234166666646122D5A4100000000C2FB2341666666860D2D5A41CDCCCCCCCCFB23419A9999390C2D5A410000000064FC234133333313FB2C5A410000000035FC234166666626F92C5A413333333308FC2341CDCCCCECF62C5A4133333333ACFB23419A999919F32C5A4166666666A4FB2341666666C6F22C5A4166666666DEFA234166666646EA2C5A4100000000B6FA23419A999979E82C5A41CDCCCCCC7EFA234133333313E62C5A41333333330FFA2341CDCCCCCC062D5A419A9999999FF9234166666686272D5A41CDCCCCCC2FF923419A999939482D5A41	01060000206A0800000100000001030000000100000009000000CDCCCCCC2FF923419A999939482D5A419A99999968F923419A9999194F2D5A413333333395F92341666666464E2D5A4100000000A7FA2341CDCCCC4C2F2D5A4100000000F7FA2341CDCCCCAC242D5A410000000064FC234133333313FB2C5A41CDCCCCCC7EFA234133333313E62C5A41CDCCCCCC2FF923419A999939482D5A41CDCCCCCC2FF923419A999939482D5A41	01010000206A08000032E956B2A0FA234133333393172D5A41	751114306	H	Roquette 6	7511143	75111	75	11	0
01060000206A080000010000000103000000010000000D0000003333333322F82341CDCCCCEC352D5A4166666666B3F82341CDCCCCCC3F2D5A41CDCCCCCC2FF923419A999939482D5A419A9999999FF9234166666686272D5A41333333330FFA2341CDCCCCCC062D5A41CDCCCCCC7EFA234133333313E62C5A41666666663EFA234100000040E32C5A413333333393F923419A9999F9DC2C5A410000000076F9234100000060E32C5A413333333344F9234166666646EF2C5A413333333303F92341000000E0FE2C5A419A9999999DF8234100000020192D5A413333333322F82341CDCCCCEC352D5A41	01060000206A080000010000000103000000010000000D0000003333333322F82341CDCCCCEC352D5A4166666666B3F82341CDCCCCCC3F2D5A41CDCCCCCC2FF923419A999939482D5A419A9999999FF9234166666686272D5A41333333330FFA2341CDCCCCCC062D5A41CDCCCCCC7EFA234133333313E62C5A41666666663EFA234100000040E32C5A413333333393F923419A9999F9DC2C5A410000000076F9234100000060E32C5A413333333344F9234166666646EF2C5A413333333303F92341000000E0FE2C5A419A9999999DF8234100000020192D5A413333333322F82341CDCCCCEC352D5A41	01010000206A080000FC312B8258F92341666666F60F2D5A41	751114307	H	Roquette 7	7511143	75111	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCC81F72341666666662B2D5A413333333322F82341CDCCCCEC352D5A419A9999999DF8234100000020192D5A413333333303F92341000000E0FE2C5A413333333344F9234166666646EF2C5A410000000076F9234100000060E32C5A413333333393F923419A9999F9DC2C5A413333333357F9234133333373DA2C5A416666666641F92341333333F3D92C5A416666666602F92341666666C6D72C5A4166666666FCF82341666666A6D72C5A4166666666B8F823419A999919D62C5A41000000009AF82341666666A6D52C5A41CDCCCCCC6FF82341CDCCCCACE42C5A41CDCCCCCC47F82341666666E6F22C5A41666666662BF82341000000C0F42C5A41666666663AF8234133333393F92C5A416666666615F823419A999959032D5A419A999999F7F72341000000A00D2D5A4100000000F7F723419A9999D90D2D5A4133333333B4F72341000000A01E2D5A419A9999998CF72341666666A6282D5A410000000085F72341333333932A2D5A41CDCCCCCC81F72341666666662B2D5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC81F72341666666662B2D5A413333333322F82341CDCCCCEC352D5A419A9999999DF8234100000020192D5A413333333303F92341000000E0FE2C5A413333333393F923419A9999F9DC2C5A416666666602F92341666666C6D72C5A41000000009AF82341666666A6D52C5A41CDCCCCCC47F82341666666E6F22C5A41666666662BF82341000000C0F42C5A41666666663AF8234133333393F92C5A4100000000F7F723419A9999D90D2D5A41CDCCCCCC81F72341666666662B2D5A41CDCCCCCC81F72341666666662B2D5A41	01010000206A0800006AB85D3F72F82341CDCCCC7C082D5A41	751114308	H	Roquette 8	7511143	75111	75	11	0
01060000206A080000010000000103000000010000001A0000006666666688F62341333333331A2D5A410000000050F72341CDCCCC0C282D5A41CDCCCCCC81F72341666666662B2D5A410000000085F72341333333932A2D5A419A9999998CF72341666666A6282D5A4133333333B4F72341000000A01E2D5A4100000000F7F723419A9999D90D2D5A419A999999F7F72341000000A00D2D5A416666666615F823419A999959032D5A41666666663AF8234133333393F92C5A41666666662BF82341000000C0F42C5A41CDCCCCCC47F82341666666E6F22C5A41CDCCCCCC6FF82341CDCCCCACE42C5A41000000009AF82341666666A6D52C5A419A9999997AF8234166666606D52C5A41333333336DF82341666666A6D42C5A419A9999994DF8234133333353D42C5A4100000000C5F723419A999939D42C5A410000000084F72341000000A0D42C5A419A9999998CF7234100000080D52C5A410000000091F7234166666686D62C5A41CDCCCCCC90F72341666666A6D72C5A41000000008DF723419A999919D92C5A41000000001EF723419A9999D9F42C5A41666666661AF723419A9999B9F52C5A416666666688F62341333333331A2D5A41	01060000206A080000010000000103000000010000000C0000006666666688F62341333333331A2D5A41CDCCCCCC81F72341666666662B2D5A4100000000F7F723419A9999D90D2D5A41666666663AF8234133333393F92C5A41666666662BF82341000000C0F42C5A41CDCCCCCC47F82341666666E6F22C5A41000000009AF82341666666A6D52C5A419A9999994DF8234133333353D42C5A410000000084F72341000000A0D42C5A41000000008DF723419A999919D92C5A416666666688F62341333333331A2D5A416666666688F62341333333331A2D5A41	01010000206A080000B0D9BBA98FF7234166666676FE2C5A41	751114309	H	Roquette 9	7511143	75111	75	11	0
01060000206A0800000100000001030000000100000020000000000000002DF523419A9999F9FF2C5A41333333335BF52341CDCCCCAC032D5A41333333335CF52341000000C0032D5A4100000000A8F5234133333373092D5A41CDCCCCCCC1F523419A9999D90B2D5A419A999999DDF523419A9999390E2D5A419A99999926F62341000000C0132D5A419A99999940F62341CDCCCC4C152D5A416666666688F62341333333331A2D5A41666666661AF723419A9999B9F52C5A41000000001EF723419A9999D9F42C5A41000000008DF723419A999919D92C5A41CDCCCCCC90F72341666666A6D72C5A410000000091F7234166666686D62C5A419A9999998CF7234100000080D52C5A410000000084F72341000000A0D42C5A413333333370F72341CDCCCCACD42C5A413333333345F72341CDCCCCCCD42C5A41333333333FF72341333333D3D42C5A41CDCCCCCCE2F62341CDCCCCCCD52C5A41CDCCCCCCC5F623419A9999B9D52C5A4166666666A9F62341CDCCCC2CD52C5A4166666666A3F623419A9999F9D42C5A416666666682F62341CDCCCC0CD32C5A41000000001FF6234166666666DF2C5A41CDCCCCCC08F62341CDCCCC2CE22C5A419A999999FCF52341333333B3E32C5A419A999999F2F523419A9999D9E42C5A410000000081F52341333333F3F12C5A410000000044F523419A999939F92C5A419A99999939F52341CDCCCC2CFB2C5A41000000002DF523419A9999F9FF2C5A41	01060000206A080000010000000103000000010000000B000000000000002DF523419A9999F9FF2C5A419A99999926F62341000000C0132D5A416666666688F62341333333331A2D5A41000000008DF723419A999919D92C5A410000000084F72341000000A0D42C5A41CDCCCCCCE2F62341CDCCCCCCD52C5A416666666682F62341CDCCCC0CD32C5A419A999999FCF52341333333B3E32C5A410000000044F523419A999939F92C5A41000000002DF523419A9999F9FF2C5A41000000002DF523419A9999F9FF2C5A41	01010000206A0800004687CC0833F623419A999979F72C5A41	751114310	H	Roquette 10	7511143	75111	75	11	0
01060000206A080000010000000103000000010000002B0000009A999999BDF323419A999999D52C5A419A999999BDF32341000000A0D52C5A4133333333C0F3234100000000D62C5A4100000000C5F32341333333F3D62C5A4100000000D7F3234166666666D92C5A419A999999F7F32341CDCCCC2CDF2C5A413333333330F423419A999999E92C5A41CDCCCCCC34F4234100000060EA2C5A419A99999959F4234166666606F12C5A419A9999995DF4234133333393F12C5A410000000064F4234166666626F22C5A41000000006AF4234133333393F22C5A410000000071F42341CDCCCCECF22C5A41000000002DF523419A9999F9FF2C5A419A99999939F52341CDCCCC2CFB2C5A410000000044F523419A999939F92C5A410000000081F52341333333F3F12C5A419A999999F2F523419A9999D9E42C5A419A999999FCF52341333333B3E32C5A41CDCCCCCC08F62341CDCCCC2CE22C5A41000000001FF6234166666666DF2C5A416666666682F62341CDCCCC0CD32C5A41CDCCCCCC49F623419A999959CE2C5A419A9999993FF6234133333313CD2C5A416666666637F62341000000A0CB2C5A41000000002DF62341333333F3C82C5A4166666666F4F52341333333D3BA2C5A419A999999D7F5234133333393B32C5A4133333333C5F5234100000040AE2C5A4166666666B6F52341CDCCCC0CAF2C5A413333333391F5234166666606B12C5A41333333336BF5234166666606B32C5A41000000003FF5234166666666B52C5A413333333315F523419A9999B9B72C5A419A999999EFF42341333333B3B92C5A419A999999EAF42341333333F3B92C5A41CDCCCCCCBDF4234133333393BC2C5A410000000093F423419A999999BF2C5A41CDCCCCCC4EF42341000000E0C52C5A41CDCCCCCC49F4234133333353C62C5A41CDCCCCCC28F423419A999919CA2C5A4100000000DEF3234166666646D32C5A419A999999BDF323419A999999D52C5A41	01060000206A080000010000000103000000010000000F0000009A999999BDF323419A999999D52C5A4100000000D7F3234166666666D92C5A419A9999995DF4234133333393F12C5A41000000002DF523419A9999F9FF2C5A410000000044F523419A999939F92C5A419A999999FCF52341333333B3E32C5A416666666682F62341CDCCCC0CD32C5A416666666637F62341000000A0CB2C5A4133333333C5F5234100000040AE2C5A419A999999EAF42341333333F3B92C5A410000000093F423419A999999BF2C5A41CDCCCCCC49F4234133333353C62C5A4100000000DEF3234166666646D32C5A419A999999BDF323419A999999D52C5A419A999999BDF323419A999999D52C5A41	01010000206A080000B25D549313F52341CCCCCC2CD82C5A41	751114311	H	Roquette 11	7511143	75111	75	11	0
01060000206A080000010000000103000000010000003A000000CDCCCCCC9AF223419A9999F93B2D5A4133333333F7F22341666666E6402D5A416666666629F323419A9999991F2D5A41CDCCCCCC38F32341333333D31F2D5A41CDCCCCCC43F323419A9999191E2D5A41666666668CF3234100000060132D5A419A9999998EF3234133333353142D5A4100000000CFF32341CDCCCC8C2D2D5A41CDCCCCCCE3F32341333333B3352D5A419A999999E8F32341CDCCCC8C372D5A41333333332AF4234133333333532D5A416666666648F4234166666646552D5A419A9999994EF42341333333B3552D5A419A99999967F4234100000060572D5A41333333337CF42341CDCCCC8C582D5A416666666685F4234166666606592D5A419A9999998FF42341CDCCCCAC592D5A41CDCCCCCC4EF42341666666A63E2D5A419A99999928F42341CDCCCCEC2D2D5A416666666625F42341666666C62C2D5A410000000020F423419A9999B92A2D5A4166666666E3F3234133333353122D5A41CDCCCCCCF3F32341CDCCCCAC122D5A41000000000EF4234166666686132D5A41666666664FF42341666666E6152D5A41000000008EF42341000000A0182D5A419A999999C3F42341CDCCCC2C0F2D5A41CDCCCCCC04F523419A999999142D5A419A99999909F5234166666606142D5A416666666631F52341666666260B2D5A41333333335BF52341CDCCCCAC032D5A41000000002DF523419A9999F9FF2C5A410000000071F42341CDCCCCECF22C5A41000000006AF4234133333393F22C5A410000000064F4234166666626F22C5A419A9999995DF4234133333393F12C5A419A99999959F4234166666606F12C5A41CDCCCCCC34F4234100000060EA2C5A413333333330F423419A999999E92C5A419A999999F7F32341CDCCCC2CDF2C5A4100000000D7F3234166666666D92C5A4100000000C5F32341333333F3D62C5A4133333333C0F3234100000000D62C5A419A999999BDF32341000000A0D52C5A419A999999BDF323419A999999D52C5A419A999999B9F32341666666E6D52C5A41CDCCCCCC43F32341CDCCCCACD32C5A419A9999992AF3234133333333D32C5A410000000027F3234100000020D32C5A416666666617F323419A9999D9D22C5A41CDCCCCCC14F323419A999919D52C5A416666666612F323419A999939D72C5A413333333311F3234166666626D82C5A416666666601F32341CDCCCCECE52C5A4166666666FBF2234133333333EB2C5A41CDCCCCCCE0F22341666666C6002D5A4133333333BFF22341CDCCCC4C1C2D5A41CDCCCCCC9AF223419A9999F93B2D5A41	01060000206A0800000100000001030000000100000016000000CDCCCCCC9AF223419A9999F93B2D5A4133333333F7F22341666666E6402D5A416666666629F323419A9999991F2D5A41CDCCCCCC38F32341333333D31F2D5A41666666668CF3234100000060132D5A419A999999E8F32341CDCCCC8C372D5A41333333332AF4234133333333532D5A419A9999998FF42341CDCCCCAC592D5A419A99999928F42341CDCCCCEC2D2D5A4166666666E3F3234133333353122D5A41000000008EF42341000000A0182D5A419A999999C3F42341CDCCCC2C0F2D5A41CDCCCCCC04F523419A999999142D5A41333333335BF52341CDCCCCAC032D5A41000000002DF523419A9999F9FF2C5A419A9999995DF4234133333393F12C5A4100000000D7F3234166666666D92C5A419A999999B9F32341666666E6D52C5A416666666617F323419A9999D9D22C5A4133333333BFF22341CDCCCC4C1C2D5A41CDCCCCCC9AF223419A9999F93B2D5A41CDCCCCCC9AF223419A9999F93B2D5A41	01010000206A080000CA278BB71BF3234133333343172D5A41	751114312	H	Roquette 12	7511143	75111	75	11	0
01060000206A080000020000000103000000010000000C000000CDCCCCCC89F3234100000080492D5A41333333332AF4234133333333532D5A419A999999E8F32341CDCCCC8C372D5A41CDCCCCCCE3F32341333333B3352D5A4100000000CFF32341CDCCCC8C2D2D5A419A9999998EF3234133333353142D5A41666666668CF3234100000060132D5A41CDCCCCCC43F323419A9999191E2D5A41CDCCCCCC38F32341333333D31F2D5A416666666629F323419A9999991F2D5A4133333333F7F22341666666E6402D5A41CDCCCCCC89F3234100000080492D5A41010300000001000000140000000000000020F423419A9999B92A2D5A416666666625F42341666666C62C2D5A419A99999928F42341CDCCCCEC2D2D5A41CDCCCCCC4EF42341666666A63E2D5A419A9999998FF42341CDCCCCAC592D5A41CDCCCCCCC3F42341000000C05C2D5A419A9999993CF5234133333353422D5A419A9999996FF523419A999979372D5A41000000009EF52341000000A02D2D5A410000000057F5234133333333282D5A419A99999951F52341666666C6272D5A4166666666FDF42341CDCCCCAC202D5A4133333333CDF42341333333131D2D5A4100000000A3F423419A9999391A2D5A41000000008EF42341000000A0182D5A41666666664FF42341666666E6152D5A41000000000EF4234166666686132D5A41CDCCCCCCF3F32341CDCCCCAC122D5A4166666666E3F3234133333353122D5A410000000020F423419A9999B92A2D5A41	01060000206A0800000200000001030000000100000009000000CDCCCCCC89F3234100000080492D5A41333333332AF4234133333333532D5A419A999999E8F32341CDCCCC8C372D5A41666666668CF3234100000060132D5A41CDCCCCCC38F32341333333D31F2D5A416666666629F323419A9999991F2D5A4133333333F7F22341666666E6402D5A41CDCCCCCC89F3234100000080492D5A41CDCCCCCC89F3234100000080492D5A41010300000001000000090000000000000020F423419A9999B92A2D5A419A9999998FF42341CDCCCCAC592D5A41CDCCCCCCC3F42341000000C05C2D5A41000000009EF52341000000A02D2D5A4166666666FDF42341CDCCCCAC202D5A41000000008EF42341000000A0182D5A4166666666E3F3234133333353122D5A410000000020F423419A9999B92A2D5A410000000020F423419A9999B92A2D5A41	01010000206A080000B4CEEEABD2F42341000000103B2D5A41	751114313	H	Roquette 13	7511143	75111	75	11	0
01060000206A080000010000000103000000010000001B000000000000008EF42341000000A0182D5A4100000000A3F423419A9999391A2D5A4133333333CDF42341333333131D2D5A4166666666FDF42341CDCCCCAC202D5A419A99999951F52341666666C6272D5A410000000057F5234133333333282D5A41000000009EF52341000000A02D2D5A41CDCCCCCC0AF6234166666626362D5A419A99999934F62341CDCCCC6C392D5A41CDCCCCCCA2F7234133333333562D5A41CDCCCCCCE5F7234133333333452D5A413333333322F82341CDCCCCEC352D5A41CDCCCCCC81F72341666666662B2D5A410000000050F72341CDCCCC0C282D5A416666666688F62341333333331A2D5A419A99999940F62341CDCCCC4C152D5A419A99999926F62341000000C0132D5A419A999999DDF523419A9999390E2D5A41CDCCCCCCC1F523419A9999D90B2D5A4100000000A8F5234133333373092D5A41333333335CF52341000000C0032D5A41333333335BF52341CDCCCCAC032D5A416666666631F52341666666260B2D5A419A99999909F5234166666606142D5A41CDCCCCCC04F523419A999999142D5A419A999999C3F42341CDCCCC2C0F2D5A41000000008EF42341000000A0182D5A41	01060000206A080000010000000103000000010000000C000000000000008EF42341000000A0182D5A4166666666FDF42341CDCCCCAC202D5A41000000009EF52341000000A02D2D5A41CDCCCCCCA2F7234133333333562D5A413333333322F82341CDCCCCEC352D5A410000000050F72341CDCCCC0C282D5A419A99999926F62341000000C0132D5A41333333335BF52341CDCCCCAC032D5A41CDCCCCCC04F523419A999999142D5A419A999999C3F42341CDCCCC2C0F2D5A41000000008EF42341000000A0182D5A41000000008EF42341000000A0182D5A41	01010000206A080000B8EEE41891F62341333333832C2D5A41	751114314	H	Roquette 14	7511143	75111	75	11	0
01060000206A0800000100000001030000000100000011000000CDCCCCCCC3F42341000000C05C2D5A41CDCCCCCCD5F423419A9999595E2D5A4166666666CCF52341000000206E2D5A410000000078F62341CDCCCC4C782D5A416666666601F7234133333393802D5A41666666662EF7234133333373742D5A41000000003AF7234100000060712D5A41000000005FF72341CDCCCC6C672D5A416666666674F723419A9999F9612D5A41CDCCCCCC82F723419A9999595E2D5A41CDCCCCCCA2F7234133333333562D5A419A99999934F62341CDCCCC6C392D5A41CDCCCCCC0AF6234166666626362D5A41000000009EF52341000000A02D2D5A419A9999996FF523419A999979372D5A419A9999993CF5234133333353422D5A41CDCCCCCCC3F42341000000C05C2D5A41	01060000206A0800000100000001030000000100000011000000CDCCCCCCC3F42341000000C05C2D5A41CDCCCCCCD5F423419A9999595E2D5A4166666666CCF52341000000206E2D5A410000000078F62341CDCCCC4C782D5A416666666601F7234133333393802D5A41666666662EF7234133333373742D5A41000000003AF7234100000060712D5A41000000005FF72341CDCCCC6C672D5A416666666674F723419A9999F9612D5A41CDCCCCCC82F723419A9999595E2D5A41CDCCCCCCA2F7234133333333562D5A419A99999934F62341CDCCCC6C392D5A41CDCCCCCC0AF6234166666626362D5A41000000009EF52341000000A02D2D5A419A9999996FF523419A999979372D5A419A9999993CF5234133333353422D5A41CDCCCCCCC3F42341000000C05C2D5A41	01010000206A080000E546345B34F623419A999979592D5A41	751114315	H	Roquette 15	7511143	75111	75	11	0
01060000206A08000001000000010300000001000000170000006666666601F7234133333393802D5A41CDCCCCCC39F7234100000040842D5A416666666690F72341333333B3882D5A41CDCCCCCC8FF82341CDCCCC4C6C2D5A4100000000DBF82341CDCCCCEC632D5A41CDCCCCCCE4F823419A9999D9622D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A4133333333FAF823419A9999D95B2D5A413333333305F92341CDCCCC2C572D5A41CDCCCCCC1BF92341666666C6502D5A41CDCCCCCC25F92341333333F34C2D5A41CDCCCCCC2AF92341666666864A2D5A41CDCCCCCC2FF923419A999939482D5A4166666666B3F82341CDCCCCCC3F2D5A413333333322F82341CDCCCCEC352D5A41CDCCCCCCE5F7234133333333452D5A41CDCCCCCCA2F7234133333333562D5A41CDCCCCCC82F723419A9999595E2D5A416666666674F723419A9999F9612D5A41000000005FF72341CDCCCC6C672D5A41000000003AF7234100000060712D5A41666666662EF7234133333373742D5A416666666601F7234133333393802D5A41	01060000206A08000001000000010300000001000000090000006666666601F7234133333393802D5A416666666690F72341333333B3882D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A4133333333FAF823419A9999D95B2D5A41CDCCCCCC2FF923419A999939482D5A413333333322F82341CDCCCCEC352D5A41000000005FF72341CDCCCC6C672D5A416666666601F7234133333393802D5A416666666601F7234133333393802D5A41	01010000206A080000BA571C063AF8234134333373602D5A41	751114316	H	Roquette 16	7511143	75111	75	11	0
01060000206A08000001000000010300000001000000170000006666666690F72341333333B3882D5A413333333399F8234100000020982D5A41CDCCCCCC9DF8234166666666982D5A416666666657F92341CDCCCC2CA32D5A4166666666B0F9234133333373A82D5A4100000000B7F92341333333D3A82D5A413333333306FA234166666686AD2D5A41000000008DFA234133333393932D5A419A999999C5F9234166666646882D5A419A999999E9F92341333333937F2D5A41CDCCCCCC15FA234133333333742D5A4166666666D9F9234100000060702D5A419A999999CDF92341666666E66E2D5A413333333382F92341666666A6652D5A410000000077F92341000000C0642D5A41CDCCCCCC5FF9234166666666632D5A41CDCCCCCC33F9234133333313612D5A410000000030F92341000000E0602D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A41CDCCCCCCE4F823419A9999D9622D5A4100000000DBF82341CDCCCCEC632D5A41CDCCCCCC8FF82341CDCCCC4C6C2D5A416666666690F72341333333B3882D5A41	01060000206A080000010000000103000000010000000A0000006666666690F72341333333B3882D5A413333333306FA234166666686AD2D5A41000000008DFA234133333393932D5A419A999999C5F9234166666646882D5A41CDCCCCCC15FA234133333333742D5A4166666666D9F9234100000060702D5A413333333382F92341666666A6652D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A416666666690F72341333333B3882D5A416666666690F72341333333B3882D5A41	01010000206A0800001AEB7E78C9F82341CCCCCCEC832D5A41	751114317	H	Roquette 17	7511143	75111	75	11	0
01060000206A080000010000000103000000010000002A00000033333333FAF823419A9999D95B2D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A410000000030F92341000000E0602D5A41CDCCCCCC33F9234133333313612D5A41CDCCCCCC5FF9234166666666632D5A410000000077F92341000000C0642D5A413333333382F92341666666A6652D5A419A999999CDF92341666666E66E2D5A4166666666D9F9234100000060702D5A41CDCCCCCC15FA234133333333742D5A419A999999E9F92341333333937F2D5A419A999999C5F9234166666646882D5A41000000008DFA234133333393932D5A419A999999F2FA2341CDCCCC2C7F2D5A4166666666FEFA2341CDCCCCEC7C2D5A410000000072FB2341666666A6652D5A4133333333DCFA2341333333735E2D5A41666666669CFA23419A9999B95B2D5A416666666695FA2341CDCCCC6C5B2D5A419A9999998AFA2341333333F35A2D5A419A99999982FA2341666666865A2D5A410000000052FA2341000000E0572D5A416666666643FA234133333333572D5A41CDCCCCCC3CFA2341666666E6562D5A410000000036FA234133333393562D5A419A9999990BFA2341666666A6542D5A41CDCCCCCCF9F92341000000E0532D5A4166666666A1F92341000000E0512D5A41000000009EF923419A999939502D5A413333333395F92341666666464E2D5A41333333338BF92341000000C04D2D5A41333333337EF92341000000C04D2D5A41CDCCCCCC72F92341333333534E2D5A419A99999968F923419A9999194F2D5A41CDCCCCCC39F923419A9999D94A2D5A41CDCCCCCC35F92341CDCCCCEC492D5A41CDCCCCCC2FF923419A999939482D5A41CDCCCCCC2AF92341666666864A2D5A41CDCCCCCC25F92341333333F34C2D5A41CDCCCCCC1BF92341666666C6502D5A413333333305F92341CDCCCC2C572D5A4133333333FAF823419A9999D95B2D5A41	01060000206A080000010000000103000000010000000F00000033333333FAF823419A9999D95B2D5A41CDCCCCCC06F92341CDCCCCEC5E2D5A413333333382F92341666666A6652D5A4166666666D9F9234100000060702D5A41CDCCCCCC15FA234133333333742D5A419A999999C5F9234166666646882D5A41000000008DFA234133333393932D5A410000000072FB2341666666A6652D5A41CDCCCCCCF9F92341000000E0532D5A4166666666A1F92341000000E0512D5A413333333395F92341666666464E2D5A419A99999968F923419A9999194F2D5A41CDCCCCCC2FF923419A999939482D5A4133333333FAF823419A9999D95B2D5A4133333333FAF823419A9999D95B2D5A41	01010000206A080000D881E97681FA2341666666466A2D5A41	751114318	H	Roquette 18	7511143	75111	75	11	0
01060000206A0800000100000001030000000100000012000000000000008DFA234133333393932D5A41666666669BFA234133333373942D5A41000000003FFB2341666666E69B2D5A4100000000EFFB2341CDCCCCCCA42D5A41CDCCCCCC4BFC234100000080A92D5A4100000000B8FC2341333333F3AE2D5A41CDCCCCCCEAFC2341333333139D2D5A416666666606FD2341CDCCCC6C932D5A413333333349FD2341333333F37B2D5A4100000000EDFC2341333333F3772D5A41CDCCCCCCC4FC234166666606762D5A413333333362FC234166666646712D5A410000000007FC2341000000E06C2D5A419A999999D8FB2341333333936A2D5A410000000072FB2341666666A6652D5A4166666666FEFA2341CDCCCCEC7C2D5A419A999999F2FA2341CDCCCC2C7F2D5A41000000008DFA234133333393932D5A41	01060000206A0800000100000001030000000100000008000000000000008DFA234133333393932D5A41000000003FFB2341666666E69B2D5A4100000000B8FC2341333333F3AE2D5A413333333349FD2341333333F37B2D5A4100000000EDFC2341333333F3772D5A410000000072FB2341666666A6652D5A41000000008DFA234133333393932D5A41000000008DFA234133333393932D5A41	01010000206A08000034B248B1F1FB2341CDCCCC4C892D5A41	751114319	H	Roquette 19	7511143	75111	75	11	0
01060000206A08000001000000010300000001000000130000003333333306FA234166666686AD2D5A41666666660EFA234166666606AE2D5A4166666666DBFA23419A9999B9BA2D5A419A999999E2FA234166666626BB2D5A416666666655FB2341CDCCCC4CC22D5A41CDCCCCCCC1FB23419A999979C82D5A4100000000D5FB234100000060C92D5A4166666666F4FB23419A999979CA2D5A416666666660FC23419A999959CE2D5A410000000077FC2341CDCCCC8CCF2D5A4166666666CEFC2341000000E0D32D5A419A99999926FD234133333393B42D5A4100000000B8FC2341333333F3AE2D5A41CDCCCCCC4BFC234100000080A92D5A4100000000EFFB2341CDCCCCCCA42D5A41000000003FFB2341666666E69B2D5A41666666669BFA234133333373942D5A41000000008DFA234133333393932D5A413333333306FA234166666686AD2D5A41	01060000206A08000001000000010300000001000000130000003333333306FA234166666686AD2D5A41666666660EFA234166666606AE2D5A4166666666DBFA23419A9999B9BA2D5A419A999999E2FA234166666626BB2D5A416666666655FB2341CDCCCC4CC22D5A41CDCCCCCCC1FB23419A999979C82D5A4100000000D5FB234100000060C92D5A4166666666F4FB23419A999979CA2D5A416666666660FC23419A999959CE2D5A410000000077FC2341CDCCCC8CCF2D5A4166666666CEFC2341000000E0D32D5A419A99999926FD234133333393B42D5A4100000000B8FC2341333333F3AE2D5A41CDCCCCCC4BFC234100000080A92D5A4100000000EFFB2341CDCCCCCCA42D5A41000000003FFB2341666666E69B2D5A41666666669BFA234133333373942D5A41000000008DFA234133333393932D5A413333333306FA234166666686AD2D5A41	01010000206A0800006B02CE039DFB2341333333C3B12D5A41	751114320	H	Roquette 20	7511143	75111	75	11	0
01060000206A080000010000000103000000010000001100000000000000B8FC2341333333F3AE2D5A419A99999926FD234133333393B42D5A4166666666CEFC2341000000E0D32D5A41333333333EFD234166666686D92D5A41CDCCCCCC88FD234166666666DD2D5A41CDCCCCCC90FD2341333333D3DD2D5A41000000009FFD2341000000C0DE2D5A4133333333A8FD234166666626DC2D5A41333333330BFE234166666626B42D5A410000000025FE234133333393A92D5A413333333372FE2341000000608A2D5A410000000076FE2341000000E0882D5A41000000005BFE2341CDCCCCEC882D5A413333333349FD2341333333F37B2D5A416666666606FD2341CDCCCC6C932D5A41CDCCCCCCEAFC2341333333139D2D5A4100000000B8FC2341333333F3AE2D5A41	01060000206A080000010000000103000000010000001100000000000000B8FC2341333333F3AE2D5A419A99999926FD234133333393B42D5A4166666666CEFC2341000000E0D32D5A41333333333EFD234166666686D92D5A41CDCCCCCC88FD234166666666DD2D5A41CDCCCCCC90FD2341333333D3DD2D5A41000000009FFD2341000000C0DE2D5A4133333333A8FD234166666626DC2D5A41333333330BFE234166666626B42D5A410000000025FE234133333393A92D5A413333333372FE2341000000608A2D5A410000000076FE2341000000E0882D5A41000000005BFE2341CDCCCCEC882D5A413333333349FD2341333333F37B2D5A416666666606FD2341CDCCCC6C932D5A41CDCCCCCCEAFC2341333333139D2D5A4100000000B8FC2341333333F3AE2D5A41	01010000206A08000005045F0A6FFD234133333343AC2D5A41	751114321	H	Roquette 21	7511143	75111	75	11	0
01060000206A080000010000000103000000010000002A0000009A9999999D0124419A9999398A2C5A416666666601022441333333D38B2C5A4100000000460224419A9999D98D2C5A4100000000BF0224419A999979912C5A41CDCCCCCC620324419A9999D9962C5A4100000000BE032441000000E0992C5A4133333333D8032441333333B39A2C5A4166666666D8032441333333B39A2C5A41CDCCCCCCDB032441333333D39A2C5A41CDCCCCCCE203244100000080982C5A41CDCCCCCCEB032441CDCCCC0C942C5A41333333330C0424419A999979812C5A41333333330F04244100000000802C5A410000000028042441666666A6702C5A410000000050042441CDCCCC4C592C5A41CDCCCCCC5404244100000020572C5A41CDCCCCCC5404244100000000572C5A41666666665404244133333333542C5A41333333334A042441000000004A2C5A410000000041042441CDCCCCAC412C5A4133333333B803244133333333442C5A419A99999955032441333333B3452C5A416666666657032441666666A6472C5A410000000058032441666666A6492C5A41CDCCCCCC57032441333333134C2C5A4166666666570324419A9999794D2C5A416666666655032441333333334F2C5A419A9999994E03244166666646522C5A41000000004403244133333373552C5A41000000003803244100000080582C5A41666666662B032441666666065B2C5A410000000013032441CDCCCC8C5E2C5A419A999999FE0224419A9999B9602C5A41CDCCCCCCD20224419A9999D9632C5A4166666666A7022441CDCCCC2C662C5A41000000008E022441666666E6662C5A41000000006E0224419A9999F9662C5A41000000004F0224419A9999B9662C5A41666666662D02244100000000662C5A41CDCCCCCC1602244166666606652C5A41000000000B022441000000A0682C5A419A9999999D0124419A9999398A2C5A41	01060000206A08000001000000010300000001000000110000009A9999999D0124419A9999398A2C5A416666666601022441333333D38B2C5A4100000000BF0224419A999979912C5A41CDCCCCCCDB032441333333D39A2C5A41CDCCCCCCEB032441CDCCCC0C942C5A410000000050042441CDCCCC4C592C5A41666666665404244133333333542C5A410000000041042441CDCCCCAC412C5A419A99999955032441333333B3452C5A4166666666570324419A9999794D2C5A41000000003803244100000080582C5A410000000013032441CDCCCC8C5E2C5A41CDCCCCCCD20224419A9999D9632C5A41000000008E022441666666E6662C5A41CDCCCCCC1602244166666606652C5A419A9999999D0124419A9999398A2C5A419A9999999D0124419A9999398A2C5A41	01010000206A0800002A51926716032441333333A36C2C5A41	751114401	H	Sainte-Marguerite 1	7511144	75111	75	11	0
01060000206A0800000100000001030000000100000029000000333333335FFF2341000000E0842C5A4133333333AAFF2341CDCCCC4C842C5A416666666620002441333333D3822C5A419A9999997B002441CDCCCCAC822C5A41CDCCCCCCBA00244166666626842C5A419A9999999D0124419A9999398A2C5A41000000000B022441000000A0682C5A41CDCCCCCC1602244166666606652C5A41666666662D02244100000000662C5A41000000004F0224419A9999B9662C5A41000000006E0224419A9999F9662C5A41000000008E022441666666E6662C5A4166666666A7022441CDCCCC2C662C5A41CDCCCCCCD20224419A9999D9632C5A419A999999FE0224419A9999B9602C5A410000000013032441CDCCCC8C5E2C5A41666666662B032441666666065B2C5A41000000003803244100000080582C5A41000000004403244133333373552C5A419A9999994E03244166666646522C5A416666666655032441333333334F2C5A4166666666570324419A9999794D2C5A41CDCCCCCC57032441333333134C2C5A410000000058032441666666A6492C5A416666666657032441666666A6472C5A419A99999955032441333333B3452C5A413333333300032441CDCCCC4C472C5A4166666666E0022441666666E6472C5A41CDCCCCCCC202244133333373482C5A413333333371022441666666E6492C5A419A99999916022441333333934C2C5A4133333333D0012441000000A04E2C5A41CDCCCCCC83012441666666C6502C5A419A9999997301244166666646512C5A4133333333FD002441CDCCCCAC542C5A4166666666BF0024419A999959562C5A416666666629002441000000E05A2C5A413333333328002441333333135B2C5A41CDCCCCCC1D002441333333535D2C5A410000000082FF2341000000007E2C5A41333333335FFF2341000000E0842C5A41	01060000206A080000010000000103000000010000000F000000333333335FFF2341000000E0842C5A416666666620002441333333D3822C5A419A9999997B002441CDCCCCAC822C5A419A9999999D0124419A9999398A2C5A41CDCCCCCC1602244166666606652C5A41000000008E022441666666E6662C5A41CDCCCCCCD20224419A9999D9632C5A410000000013032441CDCCCC8C5E2C5A41000000003803244100000080582C5A4166666666570324419A9999794D2C5A419A99999955032441333333B3452C5A413333333371022441666666E6492C5A416666666629002441000000E05A2C5A41333333335FFF2341000000E0842C5A41333333335FFF2341000000E0842C5A41	01010000206A080000FD7F5EC7FC002441CDCCCCCC672C5A41	751114402	H	Sainte-Marguerite 2	7511144	75111	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCCDBFB2341666666C6852C5A41CDCCCCCC15FC234133333393852C5A41CDCCCCCC88FC234100000040852C5A41CDCCCCCC10FD23419A9999F9842C5A41CDCCCCCC1FFD2341666666E6842C5A416666666669FD23419A999999842C5A41000000007DFD2341CDCCCC6C842C5A41333333332DFE234100000080842C5A4133333333BBFE2341000000A0842C5A416666666605FF2341CDCCCCEC842C5A41333333335FFF2341000000E0842C5A410000000082FF2341000000007E2C5A41CDCCCCCC1D002441333333535D2C5A413333333328002441333333135B2C5A416666666629002441000000E05A2C5A410000000016002441333333735B2C5A41000000006FFF234133333373602C5A410000000026FF2341000000A0622C5A41CDCCCCCC17FF2341CDCCCC0C632C5A419A999999BEFE23419A9999B9652C5A410000000081FD2341666666466F2C5A410000000001FC2341CDCCCCEC7A2C5A419A999999E5FB234166666606842C5A41CDCCCCCCDBFB2341666666C6852C5A41	01060000206A0800000100000001030000000100000018000000CDCCCCCCDBFB2341666666C6852C5A41CDCCCCCC15FC234133333393852C5A41CDCCCCCC88FC234100000040852C5A41CDCCCCCC10FD23419A9999F9842C5A41CDCCCCCC1FFD2341666666E6842C5A416666666669FD23419A999999842C5A41000000007DFD2341CDCCCC6C842C5A41333333332DFE234100000080842C5A4133333333BBFE2341000000A0842C5A416666666605FF2341CDCCCCEC842C5A41333333335FFF2341000000E0842C5A410000000082FF2341000000007E2C5A41CDCCCCCC1D002441333333535D2C5A413333333328002441333333135B2C5A416666666629002441000000E05A2C5A410000000016002441333333735B2C5A41000000006FFF234133333373602C5A410000000026FF2341000000A0622C5A41CDCCCCCC17FF2341CDCCCC0C632C5A419A999999BEFE23419A9999B9652C5A410000000081FD2341666666466F2C5A410000000001FC2341CDCCCCEC7A2C5A419A999999E5FB234166666606842C5A41CDCCCCCCDBFB2341666666C6852C5A41	01010000206A080000869DE6B736FE23419A999919752C5A41	751114403	H	Sainte-Marguerite 3	7511144	75111	75	11	0
01060000206A080000010000000103000000010000003000000033333333C5F5234100000040AE2C5A419A999999D7F5234133333393B32C5A4166666666F4F52341333333D3BA2C5A41000000002DF62341333333F3C82C5A416666666637F62341000000A0CB2C5A419A9999993FF6234133333313CD2C5A41CDCCCCCC49F623419A999959CE2C5A416666666682F62341CDCCCC0CD32C5A4166666666A3F623419A9999F9D42C5A4166666666A9F62341CDCCCC2CD52C5A41CDCCCCCCC5F623419A9999B9D52C5A41CDCCCCCCE2F62341CDCCCCCCD52C5A41333333333FF72341333333D3D42C5A413333333345F72341CDCCCCCCD42C5A413333333370F72341CDCCCCACD42C5A410000000084F72341000000A0D42C5A4100000000C5F723419A999939D42C5A419A9999994DF8234133333353D42C5A41333333336DF82341666666A6D42C5A419A9999997AF8234166666606D52C5A41CDCCCCCC71F8234133333313C62C5A413333333371F82341000000C0C52C5A419A9999996DF8234100000040C52C5A41333333335DF8234133333333C42C5A413333333358F82341666666E6C32C5A416666666655F823419A999959C32C5A413333333352F8234166666606C22C5A41000000002EF82341666666E6AF2C5A416666666620F8234166666646A92C5A416666666621F82341333333B3A82C5A410000000023F82341CDCCCC4CA72C5A41000000009FF82341CDCCCC8CA32C5A41000000008AF8234133333373982C5A419A9999997CF82341666666E68F2C5A41333333337BF82341666666068D2C5A41666666660DF8234133333353922C5A419A999999F4F72341CDCCCC8C932C5A4100000000D1F7234166666646952C5A4100000000B9F72341CDCCCC6C962C5A419A99999974F723419A9999B9992C5A41333333331AF72341CDCCCC0C9E2C5A4133333333BBF6234100000020A22C5A41CDCCCCCCA9F623419A9999F9A22C5A416666666680F623419A9999F9A42C5A41666666665FF6234133333393A62C5A413333333352F623419A999939A72C5A41CDCCCCCC24F6234133333393A92C5A4133333333C5F5234100000040AE2C5A41	01060000206A080000010000000103000000010000001100000033333333C5F5234100000040AE2C5A416666666637F62341000000A0CB2C5A41CDCCCCCC49F623419A999959CE2C5A4166666666A3F623419A9999F9D42C5A41CDCCCCCCE2F62341CDCCCCCCD52C5A4100000000C5F723419A999939D42C5A419A9999997AF8234166666606D52C5A41CDCCCCCC71F8234133333313C62C5A413333333352F8234166666606C22C5A416666666620F8234166666646A92C5A410000000023F82341CDCCCC4CA72C5A41000000009FF82341CDCCCC8CA32C5A41333333337BF82341666666068D2C5A41333333331AF72341CDCCCC0C9E2C5A4133333333BBF6234100000020A22C5A4133333333C5F5234100000040AE2C5A4133333333C5F5234100000040AE2C5A41	01010000206A0800004D60D77501F72341CCCCCCBCB12C5A41	751114404	H	Sainte-Marguerite 4	7511144	75111	75	11	0
01060000206A08000001000000010300000001000000270000006666666620F8234166666646A92C5A41000000002EF82341666666E6AF2C5A413333333352F8234166666606C22C5A416666666655F823419A999959C32C5A413333333358F82341666666E6C32C5A41333333335DF8234133333333C42C5A419A9999996DF8234100000040C52C5A413333333371F82341000000C0C52C5A41CDCCCCCC71F8234133333313C62C5A419A9999997AF8234166666606D52C5A41000000009AF82341666666A6D52C5A4166666666B8F823419A999919D62C5A4166666666FCF82341666666A6D72C5A416666666602F92341666666C6D72C5A416666666641F92341333333F3D92C5A413333333357F9234133333373DA2C5A413333333393F923419A9999F9DC2C5A4133333333E9F92341CDCCCCCCC42C5A4100000000F8F92341333333F3C12C5A4133333333FAF92341CDCCCCECC02C5A4166666666F9F923419A9999F9BF2C5A41CDCCCCCCF0F923419A9999D9BD2C5A41CDCCCCCCCAF92341CDCCCC6CB12C5A41CDCCCCCC87F92341666666069C2C5A419A9999997DF9234133333373982C5A41CDCCCCCC63F923419A9999B9882C5A419A9999995FF92341666666E6852C5A416666666658F9234133333313862C5A410000000015F923419A9999D9872C5A4100000000F5F82341666666C6882C5A4100000000ADF82341666666C68A2C5A41000000009FF82341CDCCCC4C8B2C5A41333333337BF82341666666068D2C5A419A9999997CF82341666666E68F2C5A41000000008AF8234133333373982C5A41000000009FF82341CDCCCC8CA32C5A410000000023F82341CDCCCC4CA72C5A416666666621F82341333333B3A82C5A416666666620F8234166666646A92C5A41	01060000206A08000001000000010300000001000000100000006666666620F8234166666646A92C5A413333333352F8234166666606C22C5A41CDCCCCCC71F8234133333313C62C5A419A9999997AF8234166666606D52C5A416666666602F92341666666C6D72C5A413333333393F923419A9999F9DC2C5A4133333333E9F92341CDCCCCCCC42C5A41CDCCCCCCF0F923419A9999D9BD2C5A419A9999997DF9234133333373982C5A419A9999995FF92341666666E6852C5A4100000000ADF82341666666C68A2C5A41333333337BF82341666666068D2C5A41000000009FF82341CDCCCC8CA32C5A410000000023F82341CDCCCC4CA72C5A416666666620F8234166666646A92C5A416666666620F8234166666646A92C5A41	01010000206A080000D1C577A00DF92341343333A3B72C5A41	751114405	H	Sainte-Marguerite 5	7511144	75111	75	11	0
01060000206A08000001000000010300000001000000240000009A9999995FF92341666666E6852C5A41CDCCCCCC63F923419A9999B9882C5A419A9999997DF9234133333373982C5A41CDCCCCCC87F92341666666069C2C5A41CDCCCCCCCAF92341CDCCCC6CB12C5A41CDCCCCCCF0F923419A9999D9BD2C5A4166666666F9F923419A9999F9BF2C5A4133333333FAF92341CDCCCCECC02C5A4100000000F8F92341333333F3C12C5A4133333333E9F92341CDCCCCCCC42C5A413333333393F923419A9999F9DC2C5A41666666663EFA234100000040E32C5A41CDCCCCCC7EFA234133333313E62C5A4100000000B6FA23419A999979E82C5A41CDCCCCCCE7FA234166666626D72C5A41000000002FFB2341000000C0BE2C5A4133333333A3FB2341CDCCCC8C992C5A4100000000C7FB2341666666C68D2C5A419A999999D5FB2341000000A0882C5A41CDCCCCCCDBFB2341666666C6852C5A419A999999E5FB234166666606842C5A410000000001FC2341CDCCCCEC7A2C5A4166666666DCFB2341666666267C2C5A4166666666AEFB2341666666467D2C5A41333333338AFB23419A9999197E2C5A416666666670FB2341666666A67E2C5A413333333363FB2341333333F37E2C5A41333333332EFB2341000000C07F2C5A413333333310FB234133333333802C5A41CDCCCCCCFFFA23419A999979802C5A41CDCCCCCCF2FA2341CDCCCCAC802C5A413333333355FA23419A9999F9822C5A410000000027FA234166666646842C5A410000000020FA234166666666842C5A41CDCCCCCC1AFA23419A999979842C5A419A9999995FF92341666666E6852C5A41	01060000206A080000010000000103000000010000000E0000009A9999995FF92341666666E6852C5A419A9999997DF9234133333373982C5A41CDCCCCCCF0F923419A9999D9BD2C5A4133333333E9F92341CDCCCCCCC42C5A413333333393F923419A9999F9DC2C5A41666666663EFA234100000040E32C5A4100000000B6FA23419A999979E82C5A41000000002FFB2341000000C0BE2C5A410000000001FC2341CDCCCCEC7A2C5A413333333363FB2341333333F37E2C5A413333333355FA23419A9999F9822C5A41CDCCCCCC1AFA23419A999979842C5A419A9999995FF92341666666E6852C5A419A9999995FF92341666666E6852C5A41	01010000206A080000E2242D8291FA2341343333A3B72C5A41	751114406	H	Sainte-Marguerite 6	7511144	75111	75	11	0
01060000206A0800000100000001030000000100000013000000000000002FFB2341000000C0BE2C5A41000000001FFC2341CDCCCC6CC22C5A41333333333DFC23419A999939C32C5A419A99999942FC234100000080C32C5A413333333358FC234100000040C42C5A416666666690FC234133333393C62C5A4166666666E5FC2341CDCCCC0CCA2C5A4100000000EFFC2341000000C0BE2C5A419A999999FAFC2341CDCCCC6CAB2C5A416666666603FD2341333333539D2C5A41666666660CFD2341000000808A2C5A41CDCCCCCC10FD23419A9999F9842C5A41CDCCCCCC88FC234100000040852C5A41CDCCCCCC15FC234133333393852C5A41CDCCCCCCDBFB2341666666C6852C5A419A999999D5FB2341000000A0882C5A4100000000C7FB2341666666C68D2C5A4133333333A3FB2341CDCCCC8C992C5A41000000002FFB2341000000C0BE2C5A41	01060000206A0800000100000001030000000100000009000000000000002FFB2341000000C0BE2C5A41000000001FFC2341CDCCCC6CC22C5A4166666666E5FC2341CDCCCC0CCA2C5A4100000000EFFC2341000000C0BE2C5A41CDCCCCCC10FD23419A9999F9842C5A41CDCCCCCCDBFB2341666666C6852C5A4100000000C7FB2341666666C68D2C5A41000000002FFB2341000000C0BE2C5A41000000002FFB2341000000C0BE2C5A41	01010000206A080000985D763140FC234100000060A42C5A41	751114407	H	Sainte-Marguerite 7	7511144	75111	75	11	0
01060000206A080000010000000103000000010000001D000000CDCCCCCC9AF823419A9999596D2E5A4100000000E1F8234166666626722E5A4166666666FAF82341000000C0732E5A413333333305F92341333333B3742E5A419A9999990BF9234166666666752E5A419A9999992BF92341000000E0782E5A4100000000AFF923419A9999F9862E5A4166666666B4F92341CDCCCC8C872E5A419A999999C3F92341CDCCCCCC882E5A4100000000CAF923419A9999D9872E5A416666666659FA2341CDCCCC2C732E5A4100000000C8FA23419A999919632E5A41CDCCCCCC1FFB23419A999959562E5A41CDCCCCCC2CFB23419A9999B9522E5A41000000002EFB23419A999959522E5A419A99999923FB234100000000522E5A419A99999910FB234166666666512E5A41CDCCCCCC09FB234100000020512E5A416666666602FB2341666666C6502E5A41CDCCCCCCE8FA2341333333934F2E5A410000000072FA2341333333334A2E5A413333333329FA2341CDCCCCEC462E5A419A999999C1F9234166666606422E5A4100000000AEF9234133333313412E5A413333333392F92341333333D33F2E5A416666666687F92341333333533F2E5A41CDCCCCCC60F9234100000020482E5A4166666666FFF82341333333735A2E5A41CDCCCCCC9AF823419A9999596D2E5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCC9AF823419A9999596D2E5A413333333305F92341333333B3742E5A419A999999C3F92341CDCCCCCC882E5A41CDCCCCCC1FFB23419A999959562E5A41000000002EFB23419A999959522E5A419A99999910FB234166666666512E5A416666666687F92341333333533F2E5A41CDCCCCCC60F9234100000020482E5A41CDCCCCCC9AF823419A9999596D2E5A41CDCCCCCC9AF823419A9999596D2E5A41	01010000206A0800007E7FAE68ADF923419A999939682E5A41	751114101	H	Folie Méricourt 1	7511141	75111	75	11	0
01060000206A08000001000000010300000001000000120000003333333313F72341666666A65A2E5A4166666666E1F7234133333393642E5A41000000004EF82341666666A6692E5A410000000075F823419A9999796B2E5A413333333388F82341666666666C2E5A41CDCCCCCC9AF823419A9999596D2E5A4166666666FFF82341333333735A2E5A41CDCCCCCC60F9234100000020482E5A416666666687F92341333333533F2E5A410000000011F92341333333F3392E5A41CDCCCCCCF6F82341CDCCCCAC382E5A41CDCCCCCC91F8234166666646342E5A419A9999994BF823419A999939312E5A419A999999E2F72341666666A62C2E5A4100000000DAF723419A9999392E2E5A413333333384F72341CDCCCC8C412E5A416666666671F723419A9999B9452E5A413333333313F72341666666A65A2E5A41	01060000206A08000001000000010300000001000000070000003333333313F72341666666A65A2E5A41CDCCCCCC9AF823419A9999596D2E5A41CDCCCCCC60F9234100000020482E5A416666666687F92341333333533F2E5A419A999999E2F72341666666A62C2E5A413333333313F72341666666A65A2E5A413333333313F72341666666A65A2E5A41	01010000206A080000E80059B936F823419A999949512E5A41	751114102	H	Folie Méricourt 2	7511141	75111	75	11	0
01060000206A080000010000000103000000010000001700000000000000B2F523419A9999F9492E5A4100000000F4F52341CDCCCCCC4C2E5A41666666664DF6234166666606512E5A41333333339DF62341CDCCCC0C552E5A4166666666C7F6234166666606572E5A413333333313F72341666666A65A2E5A416666666671F723419A9999B9452E5A413333333384F72341CDCCCC8C412E5A4100000000DAF723419A9999392E2E5A419A999999E2F72341666666A62C2E5A41CDCCCCCCF0F623419A9999F9212E5A419A999999C7F62341CDCCCC0C202E5A41CDCCCCCCBCF62341666666061E2E5A4133333333A1F62341666666061F2E5A41333333336AF62341CDCCCCCC202E5A41000000004AF6234100000020222E5A419A99999933F62341666666E6262E5A41CDCCCCCC1BF623419A9999992D2E5A419A9999990BF6234100000020322E5A4100000000ECF52341CDCCCC6C3A2E5A41CDCCCCCCD6F523419A9999F93F2E5A4166666666C3F5234100000000452E5A4100000000B2F523419A9999F9492E5A41	01060000206A080000010000000103000000010000000A00000000000000B2F523419A9999F9492E5A4100000000F4F52341CDCCCCCC4C2E5A413333333313F72341666666A65A2E5A419A999999E2F72341666666A62C2E5A419A999999C7F62341CDCCCC0C202E5A41CDCCCCCCBCF62341666666061E2E5A41000000004AF6234100000020222E5A419A99999933F62341666666E6262E5A4100000000B2F523419A9999F9492E5A4100000000B2F523419A9999F9492E5A41	01010000206A080000F4D2E774BCF62341343333333D2E5A41	751114103	H	Folie Méricourt 3	7511141	75111	75	11	0
01060000206A0800000100000001030000000100000010000000333333330606244100000060962B5A41000000000D06244133333333AF2B5A41CDCCCCCC0F062441CDCCCC4CB72B5A41666666661106244100000020BD2B5A4100000000BF072441CDCCCC0CB22B5A41CDCCCCCCBB07244100000020B02B5A41CDCCCCCCB107244133333353A92B5A419A999999A4072441666666C6A02B5A4166666666A2072441333333539F2B5A413333333384072441CDCCCC8C8B2B5A41000000007B07244166666686852B5A41333333336707244166666686782B5A41333333330C072441000000007A2B5A4100000000A1062441CDCCCCAC7B2B5A410000000008062441CDCCCC2C7E2B5A41333333330606244100000060962B5A41	01060000206A0800000100000001030000000100000007000000333333330606244100000060962B5A41666666661106244100000020BD2B5A4100000000BF072441CDCCCC0CB22B5A41333333336707244166666686782B5A410000000008062441CDCCCC2C7E2B5A41333333330606244100000060962B5A41333333330606244100000060962B5A41	01010000206A0800006445EE7ED10624419A9999D99A2B5A41	751124506	H	Bel-Air 6	7511245	75112	75	11	0
01060000206A080000010000000103000000010000001B000000333333339A0524419A999939B32B5A41CDCCCCCC9A05244166666686B32B5A4133333333B405244166666686C02B5A4133333333C5052441666666C6C92B5A4166666666000624419A9999B9E72B5A41000000000806244100000080EB2B5A416666666628062441CDCCCCECE92B5A410000000032062441CDCCCC6CE92B5A4100000000740624419A9999B9E92B5A410000000053072441666666E6E52B5A41CDCCCCCCF107244166666646E32B5A413333333307082441333333F3E22B5A419A9999990508244166666686E12B5A416666666603082441333333F3DF2B5A410000000001082441666666C6DD2B5A41CDCCCCCCF3072441CDCCCC0CD52B5A4100000000EB07244166666666CF2B5A4100000000E6072441333333F3CB2B5A4100000000D2072441000000C0BE2B5A419A999999CD0724419A9999B9BB2B5A4100000000BF072441CDCCCC0CB22B5A41666666661106244100000020BD2B5A41CDCCCCCC0F062441CDCCCC4CB72B5A41000000000D06244133333333AF2B5A41CDCCCCCCAE052441CDCCCCECB12B5A4133333333AE052441333333F3B12B5A41333333339A0524419A999939B32B5A41	01060000206A080000010000000103000000010000000A000000333333339A0524419A999939B32B5A41000000000806244100000080EB2B5A410000000032062441CDCCCC6CE92B5A4100000000740624419A9999B9E92B5A413333333307082441333333F3E22B5A4100000000BF072441CDCCCC0CB22B5A41666666661106244100000020BD2B5A41000000000D06244133333333AF2B5A41333333339A0524419A999939B32B5A41333333339A0524419A999939B32B5A41	01010000206A080000462255B4DA062441CCCCCCACCD2B5A41	751124507	H	Bel-Air 7	7511245	75112	75	11	0
01060000206A08000001000000010300000001000000360000009A999999C1F1234133333313182C5A419A999999C6F123419A9999F9182C5A4166666666CAF12341000000001A2C5A4166666666D2F12341333333531C2C5A41CDCCCCCCD9F12341666666261F2C5A4100000000EFF1234100000000282C5A41CDCCCCCC1EF22341666666A63B2C5A413333333334F22341666666C6432C5A413333333346F223419A999919432C5A41000000004DF2234133333393422C5A410000000069F22341333333933E2C5A4100000000C0F2234100000020332C5A4100000000E5F22341CDCCCC2C2E2C5A4166666666F1F22341666666862C2C5A413333333313F32341333333F3272C5A41CDCCCCCC35F3234100000040232C5A416666666660F32341000000C0272C5A41666666667DF32341666666C62A2C5A41CDCCCCCC5FF4234100000000432C5A413333333379F42341000000E0372C5A410000000087F42341333333D3312C5A419A9999999EF42341CDCCCC8C272C5A4133333333ADF42341CDCCCC0C212C5A41CDCCCCCCB4F42341333333B31D2C5A419A999999E4F423419A999939082C5A4100000000EEF42341333333D3062C5A419A999999F3F42341666666C6052C5A4100000000FBF42341666666E6042C5A41CDCCCCCC05F523419A999919042C5A416666666612F52341CDCCCCCC032C5A416666666614F5234166666646022C5A419A999999F9F42341666666C6012C5A4166666666E3F4234133333333012C5A41CDCCCCCCD0F42341000000E0002C5A4133333333C2F42341000000E0002C5A4166666666B6F4234100000020012C5A410000000059F42341CDCCCC2CFF2B5A413333333350F423419A9999F9FE2B5A41333333334AF423419A9999D9FE2B5A413333333345F42341000000C0FE2B5A416666666632F4234100000060FE2B5A41CDCCCCCC28F4234133333333FE2B5A416666666610F42341333333B3FD2B5A4166666666E4F32341CDCCCCCCFC2B5A41CDCCCCCCAAF323419A9999B9FB2B5A41333333338BF3234100000020FB2B5A41CDCCCCCC7AF32341CDCCCC0CFB2B5A41666666665DF323419A9999D9FA2B5A416666666620F32341CDCCCC0CFA2B5A4100000000C6F2234133333373F82B5A41CDCCCCCC99F22341CDCCCC6CF72B5A410000000030F22341333333B3072C5A419A999999D7F12341666666A6142C5A419A999999C1F1234133333313182C5A41	01060000206A080000010000000103000000010000000E0000009A999999C1F1234133333313182C5A4166666666D2F12341333333531C2C5A413333333334F22341666666C6432C5A41000000004DF2234133333393422C5A41CDCCCCCC35F3234100000040232C5A41CDCCCCCC5FF4234100000000432C5A419A999999E4F423419A999939082C5A416666666614F5234166666646022C5A4166666666B6F4234100000020012C5A41333333338BF3234100000020FB2B5A416666666620F32341CDCCCC0CFA2B5A41CDCCCCCC99F22341CDCCCC6CF72B5A419A999999C1F1234133333313182C5A419A999999C1F1234133333313182C5A41	01010000206A080000DDCFFC4345F32341333333031D2C5A41	751124803	H	Quinze-Vingts 3	7511248	75112	75	11	0
01060000206A08000001000000010300000001000000230000003333333334F22341666666C6432C5A410000000048F223419A9999194C2C5A410000000067F2234100000060592C5A410000000076F22341333333B35F2C5A416666666693F223419A9999596B2C5A419A999999C0F22341333333137C2C5A41000000001EF32341CDCCCC4CA32C5A416666666621F3234166666686A42C5A41CDCCCCCC3CF323419A999999AF2C5A419A99999944F3234100000060B22C5A416666666650F32341000000E0B52C5A410000000060F32341CDCCCCCCB12C5A419A99999971F3234166666666AB2C5A413333333386F3234133333393A22C5A419A999999ADF323419A9999B9902C5A4100000000E3F323419A999919792C5A41CDCCCCCCE7F323419A9999D9752C5A4100000000F1F32341000000A0712C5A4166666666FFF32341000000606B2C5A419A99999904F423419A999919692C5A413333333311F42341000000E0632C5A41666666661CF423419A9999195F2C5A410000000031F4234166666686562C5A41CDCCCCCC5FF4234100000000432C5A41666666667DF32341666666C62A2C5A416666666660F32341000000C0272C5A41CDCCCCCC35F3234100000040232C5A413333333313F32341333333F3272C5A4166666666F1F22341666666862C2C5A4100000000E5F22341CDCCCC2C2E2C5A4100000000C0F2234100000020332C5A410000000069F22341333333933E2C5A41000000004DF2234133333393422C5A413333333346F223419A999919432C5A413333333334F22341666666C6432C5A41	01060000206A080000010000000103000000010000000D0000003333333334F22341666666C6432C5A410000000076F22341333333B35F2C5A419A999999C0F22341333333137C2C5A41000000001EF32341CDCCCC4CA32C5A416666666650F32341000000E0B52C5A419A99999971F3234166666666AB2C5A4100000000E3F323419A999919792C5A419A99999904F423419A999919692C5A41CDCCCCCC5FF4234100000000432C5A41CDCCCCCC35F3234100000040232C5A41000000004DF2234133333393422C5A413333333334F22341666666C6432C5A413333333334F22341666666C6432C5A41	01010000206A08000052EE760E4AF32341000000806E2C5A41	751124804	H	Quinze-Vingts 4	7511248	75112	75	11	0
01060000206A080000010000000103000000010000003C000000CDCCCCCCF8012441CDCCCCCCF82B5A41CDCCCCCC170224419A999939FD2B5A41CDCCCCCC3B0224419A999979FC2B5A419A999999830224419A9999F9FA2B5A4100000000AE0224419A999919FA2B5A410000000058032441CDCCCC8CF62B5A41666666666B03244166666626F62B5A416666666684032441CDCCCCACF52B5A4100000000A003244166666626F52B5A419A999999B4032441000000C0F42B5A4100000000BC0324419A999999F42B5A4100000000D0032441CDCCCCECF32B5A41333333330704244100000000F32B5A419A9999996404244100000060F12B5A41CDCCCCCC93042441000000A0F02B5A419A999999B30424419A999919F02B5A4133333333D9042441CDCCCC6CEF2B5A41CDCCCCCC0F05244133333373EE2B5A410000000027052441CDCCCC0CEE2B5A41CDCCCCCC570524419A999919ED2B5A419A999999CB052441CDCCCC0CEB2B5A4166666666D80524419A9999F9EA2B5A419A999999DD05244100000000EB2B5A41000000000806244100000080EB2B5A4166666666000624419A9999B9E72B5A4133333333C5052441666666C6C92B5A4133333333B405244166666686C02B5A41CDCCCCCC9A05244166666686B32B5A41333333339A0524419A999939B32B5A41000000005705244133333373922B5A419A999999310524419A999939802B5A41000000002B052441333333137D2B5A41333333332A052441000000A07C2B5A410000000025052441666666267A2B5A41666666661205244133333313712B5A4100000000F6042441666666C6632B5A4100000000F304244166666666622B5A4100000000EA042441333333735E2B5A4100000000C404244100000040592B5A4133333333B0042441333333935C2B5A4133333333A004244100000000612B5A41000000008F04244166666606652B5A41CDCCCCCC690424419A9999D96C2B5A41666666665404244133333353712B5A416666666613042441CDCCCC0C7F2B5A41333333330F042441CDCCCC0C802B5A41333333330204244166666626832B5A4166666666FD03244133333333842B5A4100000000DC032441CDCCCC6C8B2B5A4100000000BC032441000000A0922B5A41CDCCCCCC9E03244133333333992B5A41666666668A0324419A9999999D2B5A4166666666740324419A999919A22B5A41666666665F0324419A999979A62B5A41CDCCCCCC5203244100000020A92B5A4166666666430324419A999959AC2B5A41666666660803244133333353BA2B5A4166666666740224419A999979DD2B5A41000000004002244133333313EA2B5A41CDCCCCCCF8012441CDCCCCCCF82B5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCF8012441CDCCCCCCF82B5A41CDCCCCCC170224419A999939FD2B5A4100000000D0032441CDCCCCECF32B5A419A999999CB052441CDCCCC0CEB2B5A41000000000806244100000080EB2B5A41333333339A0524419A999939B32B5A41666666661205244133333313712B5A4100000000EA042441333333735E2B5A4100000000C404244100000040592B5A416666666613042441CDCCCC0C7F2B5A41CDCCCCCC9E03244133333333992B5A4166666666430324419A999959AC2B5A41000000004002244133333313EA2B5A41CDCCCCCCF8012441CDCCCCCCF82B5A41CDCCCCCCF8012441CDCCCCCCF82B5A41	01010000206A0800004D37E8F269042441CDCCCCBCAA2B5A41	751124615	H	Picpus 15	7511246	75112	75	11	0
01060000206A080000010000000103000000010000001C0000003333333327FF23419A9999D9D62B5A419A9999995EFF2341666666A6DB2B5A41CDCCCCCCC5FF234166666606E52B5A41CDCCCCCC8000244133333393F52B5A419A999999F90024419A999979002C5A416666666670012441CDCCCC2C0B2C5A410000000093012441666666660F2C5A41CDCCCCCCF8012441CDCCCCCCF82B5A41000000004002244133333313EA2B5A4166666666740224419A999979DD2B5A41666666660803244133333353BA2B5A4166666666430324419A999959AC2B5A41333333335802244100000060962B5A419A999999880124419A9999B9822B5A416666666650012441666666A67D2B5A41CDCCCCCC41012441333333F37F2B5A419A9999993401244166666666822B5A41CDCCCCCC2C012441666666C6832B5A41CDCCCCCC1F012441CDCCCC6C862B5A41333333331301244166666626892B5A41CDCCCCCC0A012441000000808A2B5A4166666666F90024419A9999198D2B5A4133333333E600244166666646902B5A41000000003A002441CDCCCC6CAB2B5A4166666666BFFF234166666666BE2B5A4133333333ACFF23419A999959C12B5A41666666666BFF2341000000E0CB2B5A413333333327FF23419A9999D9D62B5A41	01060000206A080000010000000103000000010000001C0000003333333327FF23419A9999D9D62B5A419A9999995EFF2341666666A6DB2B5A41CDCCCCCCC5FF234166666606E52B5A41CDCCCCCC8000244133333393F52B5A419A999999F90024419A999979002C5A416666666670012441CDCCCC2C0B2C5A410000000093012441666666660F2C5A41CDCCCCCCF8012441CDCCCCCCF82B5A41000000004002244133333313EA2B5A4166666666740224419A999979DD2B5A41666666660803244133333353BA2B5A4166666666430324419A999959AC2B5A41333333335802244100000060962B5A419A999999880124419A9999B9822B5A416666666650012441666666A67D2B5A41CDCCCCCC41012441333333F37F2B5A419A9999993401244166666666822B5A41CDCCCCCC2C012441666666C6832B5A41CDCCCCCC1F012441CDCCCC6C862B5A41333333331301244166666626892B5A41CDCCCCCC0A012441000000808A2B5A4166666666F90024419A9999198D2B5A4133333333E600244166666646902B5A41000000003A002441CDCCCC6CAB2B5A4166666666BFFF234166666666BE2B5A4133333333ACFF23419A999959C12B5A41666666666BFF2341000000E0CB2B5A413333333327FF23419A9999D9D62B5A41	01010000206A08000004C2483B30012441CDCCCC9CC62B5A41	751124616	H	Picpus 16	7511246	75112	75	11	0
01060000206A0800000100000001030000000100000024000000CDCCCCCC10FE2341333333D3032C5A41333333332AFE234166666606062C5A416666666661FE2341CDCCCCEC0A2C5A4100000000F9FE23419A9999B9182C5A41333333337BFF23419A999999242C5A410000000097FF234166666626272C5A41CDCCCCCCB0FF23419A999979292C5A4100000000B7FF2341CDCCCC6C282C5A4166666666CEFF234100000080242C5A41CDCCCCCC02002441333333331A2C5A416666666614002441000000C0172C5A419A9999992600244133333353162C5A41333333333800244100000040152C5A419A9999994700244100000000152C5A41333333335300244133333353152C5A41666666667100244133333333182C5A4133333333DE002441333333F3212C5A4133333333F700244133333333242C5A41666666662101244100000000282C5A41333333333301244100000020242C5A410000000093012441666666660F2C5A416666666670012441CDCCCC2C0B2C5A419A999999F90024419A999979002C5A41CDCCCCCC8000244133333393F52B5A41CDCCCCCCC5FF234166666606E52B5A419A9999995EFF2341666666A6DB2B5A413333333327FF23419A9999D9D62B5A41000000001BFF2341666666E6D82B5A419A999999F6FE2341333333F3DE2B5A4166666666C6FE234100000080E62B5A41CDCCCCCC92FE2341000000A0EE2B5A419A9999995DFE2341CDCCCC4CF72B5A41CDCCCCCC3DFE234133333393FC2B5A419A99999937FE2341000000A0FD2B5A413333333317FE2341333333B3022C5A41CDCCCCCC10FE2341333333D3032C5A41	01060000206A080000010000000103000000010000000C000000CDCCCCCC10FE2341333333D3032C5A41CDCCCCCCB0FF23419A999979292C5A41CDCCCCCC02002441333333331A2C5A41333333333800244100000040152C5A41333333335300244133333353152C5A41666666662101244100000000282C5A410000000093012441666666660F2C5A416666666670012441CDCCCC2C0B2C5A41CDCCCCCC8000244133333393F52B5A413333333327FF23419A9999D9D62B5A41CDCCCCCC10FE2341333333D3032C5A41CDCCCCCC10FE2341333333D3032C5A41	01010000206A080000C29BA7278CFF2341CDCCCC0CFF2B5A41	751124617	H	Picpus 17	7511246	75112	75	11	0
01060000206A08000001000000010300000001000000250000009A9999992BFD2341000000602E2C5A41CDCCCCCC61FD2341666666862F2C5A41333333338BFD23419A999959302C5A41000000008DFD234166666666302C5A4166666666AEFD23419A999919312C5A41333333337DFE2341CDCCCC6C352C5A41333333335AFF2341CDCCCCEC392C5A41000000004D002441CDCCCCEC3E2C5A41CDCCCCCC7D002441333333F33F2C5A4166666666A7002441666666C6402C5A4133333333B4002441000000203E2C5A41666666662101244100000000282C5A4133333333F700244133333333242C5A4133333333DE002441333333F3212C5A41666666667100244133333333182C5A41333333335300244133333353152C5A419A9999994700244100000000152C5A41333333333800244100000040152C5A419A9999992600244133333353162C5A416666666614002441000000C0172C5A41CDCCCCCC02002441333333331A2C5A4166666666CEFF234100000080242C5A4100000000B7FF2341CDCCCC6C282C5A41CDCCCCCCB0FF23419A999979292C5A410000000097FF234166666626272C5A41333333337BFF23419A999999242C5A4100000000F9FE23419A9999B9182C5A416666666661FE2341CDCCCCEC0A2C5A41333333332AFE234166666606062C5A41CDCCCCCC10FE2341333333D3032C5A4100000000F3FD2341333333B3082C5A419A999999C0FD2341333333D3102C5A41000000008EFD234100000020192C5A41666666665FFD234100000060222C5A416666666656FD234100000060242C5A41CDCCCCCC52FD2341CDCCCC2C252C5A419A9999992BFD2341000000602E2C5A41	01060000206A080000010000000103000000010000000B0000009A9999992BFD2341000000602E2C5A4166666666A7002441666666C6402C5A41666666662101244100000000282C5A41333333335300244133333353152C5A41333333333800244100000040152C5A41CDCCCCCC02002441333333331A2C5A41CDCCCCCCB0FF23419A999979292C5A41CDCCCCCC10FE2341333333D3032C5A41000000008EFD234100000020192C5A419A9999992BFD2341000000602E2C5A419A9999992BFD2341000000602E2C5A41	01010000206A08000069D9FE7860FE23419A999929222C5A41	751124618	H	Picpus 18	7511246	75112	75	11	0
01060000206A080000010000000103000000010000002C000000CDCCCCCC33FB234100000000EA2B5A41CDCCCCCC47FB23419A9999F9EB2B5A416666666658FB2341CDCCCCECEC2B5A4166666666ADFB23419A999979F52B5A41CDCCCCCCBDFB234133333333F72B5A4100000000DFFB234133333373FA2B5A41000000004BFC2341666666C6042C5A4166666666A6FC23419A9999590D2C5A416666666607FD2341CDCCCC8C172C5A41CDCCCCCC48FD2341CDCCCC8C1F2C5A41666666665FFD234100000060222C5A41000000008EFD234100000020192C5A419A999999C0FD2341333333D3102C5A4100000000F3FD2341333333B3082C5A41CDCCCCCC10FE2341333333D3032C5A413333333317FE2341333333B3022C5A419A99999937FE2341000000A0FD2B5A41CDCCCCCC3DFE234133333393FC2B5A419A9999995DFE2341CDCCCC4CF72B5A41CDCCCCCC92FE2341000000A0EE2B5A4166666666C6FE234100000080E62B5A419A999999F6FE2341333333F3DE2B5A41666666663BFE2341000000E0CE2B5A419A999999F3FD2341CDCCCCCCC82B5A4100000000B8FD2341333333B3C32B5A41CDCCCCCC77FD2341CDCCCC4CBE2B5A419A99999917FD2341333333B3B52B5A41CDCCCCCCB1FC234100000040AD2B5A4100000000A9FC234100000080AC2B5A4100000000A5FC234166666626AC2B5A419A999999A1FC2341333333D3AC2B5A419A9999999BFC2341CDCCCC0CAE2B5A419A99999952FC2341666666C6BC2B5A41000000003EFC2341333333F3BF2B5A41CDCCCCCC07FC234166666666C82B5A419A999999CDFB2341CDCCCCCCD12B5A419A999999C1FB2341CDCCCCACD32B5A4100000000B3FB2341666666E6D52B5A419A9999998CFB234100000040DC2B5A413333333385FB234133333353DD2B5A41000000005EFB234166666686E32B5A419A99999949FB2341333333B3E62B5A419A9999993CFB23419A9999F9E72B5A41CDCCCCCC33FB234100000000EA2B5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC33FB234100000000EA2B5A416666666658FB2341CDCCCCECEC2B5A4100000000DFFB234133333373FA2B5A4166666666A6FC23419A9999590D2C5A416666666607FD2341CDCCCC8C172C5A41666666665FFD234100000060222C5A41000000008EFD234100000020192C5A41CDCCCCCC92FE2341000000A0EE2B5A419A999999F6FE2341333333F3DE2B5A4100000000A5FC234166666626AC2B5A419A99999952FC2341666666C6BC2B5A41CDCCCCCC33FB234100000000EA2B5A41CDCCCCCC33FB234100000000EA2B5A41	01010000206A080000E591321702FD234166666656E72B5A41	751124619	H	Picpus 19	7511246	75112	75	11	0
01060000206A0800000100000001030000000100000017000000CDCCCCCC33FB234100000000EA2B5A41CDCCCCCC39FB2341000000E0ED2B5A41CDCCCCCC3BFB2341000000C0EF2B5A41CDCCCCCC4BFB23419A9999F9002C5A41CDCCCCCC73FB234100000080252C5A4166666666C4FB23419A999959272C5A419A999999E1FB23419A9999F9272C5A41CDCCCCCC26FC2341CDCCCC4C292C5A419A999999A6FC2341666666C62B2C5A419A9999992BFD2341000000602E2C5A41CDCCCCCC52FD2341CDCCCC2C252C5A416666666656FD234100000060242C5A41666666665FFD234100000060222C5A41CDCCCCCC48FD2341CDCCCC8C1F2C5A416666666607FD2341CDCCCC8C172C5A4166666666A6FC23419A9999590D2C5A41000000004BFC2341666666C6042C5A4100000000DFFB234133333373FA2B5A41CDCCCCCCBDFB234133333333F72B5A4166666666ADFB23419A999979F52B5A416666666658FB2341CDCCCCECEC2B5A41CDCCCCCC47FB23419A9999F9EB2B5A41CDCCCCCC33FB234100000000EA2B5A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC33FB234100000000EA2B5A41CDCCCCCC73FB234100000080252C5A419A999999E1FB23419A9999F9272C5A419A9999992BFD2341000000602E2C5A41666666665FFD234100000060222C5A416666666607FD2341CDCCCC8C172C5A4166666666A6FC23419A9999590D2C5A4100000000DFFB234133333373FA2B5A416666666658FB2341CDCCCCECEC2B5A41CDCCCCCC33FB234100000000EA2B5A41CDCCCCCC33FB234100000000EA2B5A41	01010000206A080000F272B0ADE6FB234100000010092C5A41	751124620	H	Picpus 20	7511246	75112	75	11	0
01060000206A0800000100000001030000000100000014000000CDCCCCCC73FB234100000080252C5A419A99999984FB234133333313372C5A4100000000C9FB234133333373782C5A4166666666DCFB2341666666267C2C5A410000000001FC2341CDCCCCEC7A2C5A410000000081FD2341666666466F2C5A419A999999BEFE23419A9999B9652C5A419A999999B4FE2341333333B3622C5A4133333333A6FE234133333393602C5A413333333385FE23419A9999B95B2C5A41333333334BFE234166666626532C5A413333333380FD2341666666C6362C5A419A9999996BFD234166666666332C5A41CDCCCCCC61FD2341666666862F2C5A419A9999992BFD2341000000602E2C5A419A999999A6FC2341666666C62B2C5A41CDCCCCCC26FC2341CDCCCC4C292C5A419A999999E1FB23419A9999F9272C5A4166666666C4FB23419A999959272C5A41CDCCCCCC73FB234100000080252C5A41	01060000206A0800000100000001030000000100000014000000CDCCCCCC73FB234100000080252C5A419A99999984FB234133333313372C5A4100000000C9FB234133333373782C5A4166666666DCFB2341666666267C2C5A410000000001FC2341CDCCCCEC7A2C5A410000000081FD2341666666466F2C5A419A999999BEFE23419A9999B9652C5A419A999999B4FE2341333333B3622C5A4133333333A6FE234133333393602C5A413333333385FE23419A9999B95B2C5A41333333334BFE234166666626532C5A413333333380FD2341666666C6362C5A419A9999996BFD234166666666332C5A41CDCCCCCC61FD2341666666862F2C5A419A9999992BFD2341000000602E2C5A419A999999A6FC2341666666C62B2C5A41CDCCCCCC26FC2341CDCCCC4C292C5A419A999999E1FB23419A9999F9272C5A4166666666C4FB23419A999959272C5A41CDCCCCCC73FB234100000080252C5A41	01010000206A080000E574B307BDFC2341CCCCCC1C452C5A41	751124621	H	Picpus 21	7511246	75112	75	11	0
01060000206A0800000100000001030000000100000018000000CDCCCCCC61FD2341666666862F2C5A419A9999996BFD234166666666332C5A413333333380FD2341666666C6362C5A41333333334BFE234166666626532C5A413333333385FE23419A9999B95B2C5A4133333333A6FE234133333393602C5A419A999999B4FE2341333333B3622C5A419A999999BEFE23419A9999B9652C5A41CDCCCCCC17FF2341CDCCCC0C632C5A410000000026FF2341000000A0622C5A41000000006FFF234133333373602C5A410000000016002441333333735B2C5A416666666629002441000000E05A2C5A410000000053002441666666A6522C5A419A99999998002441000000E0432C5A4166666666A7002441666666C6402C5A41CDCCCCCC7D002441333333F33F2C5A41000000004D002441CDCCCCEC3E2C5A41333333335AFF2341CDCCCCEC392C5A41333333337DFE2341CDCCCC6C352C5A4166666666AEFD23419A999919312C5A41000000008DFD234166666666302C5A41333333338BFD23419A999959302C5A41CDCCCCCC61FD2341666666862F2C5A41	01060000206A0800000100000001030000000100000009000000CDCCCCCC61FD2341666666862F2C5A413333333380FD2341666666C6362C5A41333333334BFE234166666626532C5A419A999999B4FE2341333333B3622C5A419A999999BEFE23419A9999B9652C5A416666666629002441000000E05A2C5A4166666666A7002441666666C6402C5A41CDCCCCCC61FD2341666666862F2C5A41CDCCCCCC61FD2341666666862F2C5A41	01010000206A0800005F82224944FF2341333333434B2C5A41	751124622	H	Picpus 22	7511246	75112	75	11	0
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	01060000206A080000010000000103000000010000000F0000009A999999CD0724419A9999B9BB2B5A413333333307082441333333F3E22B5A419A99999953092441000000E0DC2B5A41CDCCCCCC7D0A24419A999939D82B5A4100000000A60A2441CDCCCC0CD72B5A4133333333420A2441CDCCCC6C9E2B5A4133333333250A2441666666468F2B5A4133333333010A2441CDCCCC2C902B5A41333333337D092441000000A08F2B5A4133333333CB09244166666626CB2B5A419A9999997F092441CDCCCC6CCD2B5A41000000004209244100000080B02B5A41666666667A082441CDCCCC4CB72B5A419A999999CD0724419A9999B9BB2B5A419A999999CD0724419A9999B9BB2B5A41	01010000206A080000A5F3D27BC308244100000040B92B5A41	751124508	H	Bel-Air 8	7511245	75112	75	11	0
01060000206A08000001000000010300000001000000280000009A9999994D022441666666864D2B5A41666666668D022441CDCCCCEC4A2B5A410000000090022441000000E04B2B5A41CDCCCCCC9A0224419A9999594B2B5A4133333333DB02244100000020492B5A41CDCCCCCC0E03244100000060452B5A41333333333F03244166666626422B5A41CDCCCCCC4B03244100000040412B5A4133333333F103244100000080352B5A4166666666330424419A9999D9302B5A41333333335E0424419A9999D92D2B5A41CDCCCCCC7C042441666666A62B2B5A4133333333290524419A9999791F2B5A4166666666E7052441CDCCCCCC112B5A419A999999FB05244166666666102B5A4100000000F3052441666666260F2B5A4133333333EC0524419A9999390E2B5A4166666666AE05244133333373082B5A416666666676052441333333B3032B5A41CDCCCCCC37052441CDCCCC2CFE2A5A4133333333E3042441CDCCCC6CF62A5A41000000009704244100000060EF2A5A419A9999997604244166666606EC2A5A4133333333190424419A9999B9F92A5A41CDCCCCCCC903244133333373052B5A4166666666A5032441666666060B2B5A41333333337703244166666626122B5A41000000006F032441000000A0142B5A419A99999951032441CDCCCC2C192B5A416666666632032441333333531E2B5A41CDCCCCCC1F032441666666C6212B5A4166666666E7022441666666462B2B5A4100000000D5022441000000A02E2B5A4166666666CB022441000000C02F2B5A419A99999993022441666666263B2B5A41000000008B022441CDCCCCCC3C2B5A41CDCCCCCC71022441000000C0422B5A419A99999954022441333333134A2B5A413333333350022441666666E64B2B5A419A9999994D022441666666864D2B5A41	01060000206A080000010000000103000000010000000D0000009A9999994D022441666666864D2B5A4133333333DB02244100000020492B5A4133333333290524419A9999791F2B5A419A999999FB05244166666666102B5A4166666666AE05244133333373082B5A41CDCCCCCC37052441CDCCCC2CFE2A5A419A9999997604244166666606EC2A5A41333333337703244166666626122B5A41000000006F032441000000A0142B5A4166666666CB022441000000C02F2B5A41000000008B022441CDCCCCCC3C2B5A419A9999994D022441666666864D2B5A419A9999994D022441666666864D2B5A41	01010000206A080000768137814F042441000000C01B2B5A41	751124606	H	Picpus 6	7511246	75112	75	11	0
01060000206A08000001000000010300000001000000300000006666666629002441000000E05A2C5A4166666666BF0024419A999959562C5A4133333333FD002441CDCCCCAC542C5A419A9999997301244166666646512C5A41CDCCCCCC83012441666666C6502C5A4133333333D0012441000000A04E2C5A419A99999916022441333333934C2C5A413333333371022441666666E6492C5A41CDCCCCCCC202244133333373482C5A4166666666E0022441666666E6472C5A413333333300032441CDCCCC4C472C5A419A99999955032441333333B3452C5A41CDCCCCCC5103244100000040422C5A41666666664D03244133333353402C5A419A99999948032441666666C63E2C5A413333333341032441666666463D2C5A416666666631032441666666663A2C5A41000000002403244100000040382C5A416666666613032441666666E6352C5A41000000000603244166666646342C5A4133333333F6022441666666A6322C5A419A999999DD022441333333B3302C5A4166666666E80224419A9999D92D2C5A413333333317032441000000A0232C5A419A9999994503244100000020172C5A41CDCCCCCC59032441333333B3112C5A4133333333A90324419A999979FB2B5A41CDCCCCCCBD0324419A999999F72B5A4100000000D0032441CDCCCCECF32B5A4100000000BC0324419A999999F42B5A419A999999B4032441000000C0F42B5A4100000000A003244166666626F52B5A416666666684032441CDCCCCACF52B5A41666666666B03244166666626F62B5A410000000058032441CDCCCC8CF62B5A4100000000AE0224419A999919FA2B5A419A999999830224419A9999F9FA2B5A41CDCCCCCC3B0224419A999979FC2B5A41CDCCCCCC170224419A999939FD2B5A41CDCCCCCCF8012441CDCCCCCCF82B5A410000000093012441666666660F2C5A41333333333301244100000020242C5A41666666662101244100000000282C5A4133333333B4002441000000203E2C5A4166666666A7002441666666C6402C5A419A99999998002441000000E0432C5A410000000053002441666666A6522C5A416666666629002441000000E05A2C5A41	01060000206A080000010000000103000000010000000E0000006666666629002441000000E05A2C5A413333333371022441666666E6492C5A419A99999955032441333333B3452C5A419A99999948032441666666C63E2C5A416666666613032441666666E6352C5A419A999999DD022441333333B3302C5A413333333317032441000000A0232C5A4133333333A90324419A999979FB2B5A4100000000D0032441CDCCCCECF32B5A41CDCCCCCC170224419A999939FD2B5A41CDCCCCCCF8012441CDCCCCCCF82B5A41666666662101244100000000282C5A416666666629002441000000E05A2C5A416666666629002441000000E05A2C5A41	01010000206A0800002E7DF82B1B02244100000010262C5A41	751124623	H	Picpus 23	7511246	75112	75	11	0
01060000206A080000010000000103000000010000002F0000009A999999DD022441333333B3302C5A4133333333F6022441666666A6322C5A41000000000603244166666646342C5A416666666613032441666666E6352C5A41000000002403244100000040382C5A416666666631032441666666663A2C5A413333333341032441666666463D2C5A419A99999948032441666666C63E2C5A41666666664D03244133333353402C5A41CDCCCCCC5103244100000040422C5A419A99999955032441333333B3452C5A4133333333B803244133333333442C5A410000000041042441CDCCCCAC412C5A416666666640042441666666263E2C5A41CDCCCCCC3B04244166666686392C5A41CDCCCCCC350424419A999979342C5A419A9999993104244100000080312C5A41CDCCCCCC3B042441333333532D2C5A4133333333440424419A9999D92B2C5A419A9999994C0424419A9999592A2C5A419A9999996C04244100000060262C5A410000000088042441CDCCCCAC222C5A41CDCCCCCCD9042441CDCCCC4C182C5A41666666665305244133333333082C5A419A9999995D052441CDCCCCEC062C5A41CDCCCCCCF8052441666666C6F22B5A41CDCCCCCC0E0624419A9999F9EF2B5A41000000000806244100000080EB2B5A419A999999DD05244100000000EB2B5A4166666666D80524419A9999F9EA2B5A419A999999CB052441CDCCCC0CEB2B5A41CDCCCCCC570524419A999919ED2B5A410000000027052441CDCCCC0CEE2B5A41CDCCCCCC0F05244133333373EE2B5A4133333333D9042441CDCCCC6CEF2B5A419A999999B30424419A999919F02B5A41CDCCCCCC93042441000000A0F02B5A419A9999996404244100000060F12B5A41333333330704244100000000F32B5A4100000000D0032441CDCCCCECF32B5A41CDCCCCCCBD0324419A999999F72B5A4133333333A90324419A999979FB2B5A41CDCCCCCC59032441333333B3112C5A419A9999994503244100000020172C5A413333333317032441000000A0232C5A4166666666E80224419A9999D92D2C5A419A999999DD022441333333B3302C5A41	01060000206A08000001000000010300000001000000100000009A999999DD022441333333B3302C5A416666666613032441666666E6352C5A419A99999948032441666666C63E2C5A419A99999955032441333333B3452C5A410000000041042441CDCCCCAC412C5A419A9999993104244100000080312C5A419A9999994C0424419A9999592A2C5A41CDCCCCCCD9042441CDCCCC4C182C5A41CDCCCCCC0E0624419A9999F9EF2B5A41000000000806244100000080EB2B5A419A999999CB052441CDCCCC0CEB2B5A4100000000D0032441CDCCCCECF32B5A4133333333A90324419A999979FB2B5A413333333317032441000000A0232C5A419A999999DD022441333333B3302C5A419A999999DD022441333333B3302C5A41	01010000206A080000B27BF270EF032441CDCCCC7C1D2C5A41	751124624	H	Picpus 24	7511246	75112	75	11	0
01060000206A080000010000000103000000010000002B00000033333333A3FA23419A999979042B5A41CDCCCCCC02FB23419A9999D90E2B5A41666666660AFB234100000000102B5A419A9999996CFB23419A999939012B5A419A999999C5FB234100000080F32A5A4166666666CFFB23419A9999F9F12A5A41CDCCCCCC20FC234133333373E52A5A416666666645FC2341666666C6DF2A5A419A99999955FC234133333333E12A5A4166666666B0FC234100000080EA2A5A4166666666B5FC234166666606EB2A5A4166666666EBFC234133333393F02A5A41CDCCCCCC08FD23419A9999B9EB2A5A41666666665BFD234100000020DF2A5A41CDCCCCCC6AFD23419A9999B9DC2A5A4100000000B5FD234100000020D12A5A4166666666BBFD234100000020D02A5A419A99999923FE234166666606C02A5A413333333359FE2341000000E0B72A5A413333333329FE234166666606B32A5A41CDCCCCCCD9FD234133333373AB2A5A419A9999998BFD234133333313B82A5A410000000052FD234133333373C12A5A41666666663AFD234166666646BE2A5A41CDCCCCCC33FD2341666666C6BD2A5A41CDCCCCCCFDFC2341CDCCCC0CB72A5A419A999999C5FC2341CDCCCC0CB02A5A41CDCCCCCCC3FC2341CDCCCCACB02A5A416666666698FC234166666666B72A5A41CDCCCCCC77FC234133333373BC2A5A41666666665AFC2341CDCCCCECC02A5A41000000000DFC2341CDCCCCCCCC2A5A4133333333ECFB2341666666E6D12A5A41CDCCCCCCD9FB2341CDCCCCCCD42A5A419A999999C3FB234133333393D82A5A4100000000A5FB234133333333DD2A5A416666666682FB23419A999959E22A5A41666666665AFB234166666686E82A5A419A99999930FB234100000000EF2A5A41666666661DFB2341CDCCCCECF12A5A419A999999E1FA2341CDCCCCECFA2A5A41CDCCCCCCCBFA2341CDCCCC2CFE2A5A4133333333A3FA23419A999979042B5A41	01060000206A080000010000000103000000010000000C00000033333333A3FA23419A999979042B5A41666666660AFB234100000000102B5A416666666645FC2341666666C6DF2A5A4166666666EBFC234133333393F02A5A41CDCCCCCC08FD23419A9999B9EB2A5A413333333359FE2341000000E0B72A5A41CDCCCCCCD9FD234133333373AB2A5A410000000052FD234133333373C12A5A419A999999C5FC2341CDCCCC0CB02A5A419A999999C3FB234133333393D82A5A4133333333A3FA23419A999979042B5A4133333333A3FA23419A999979042B5A41	01010000206A0800005F4D050E80FC23419A999929DE2A5A41	751124701	H	Bercy 1	7511247	75112	75	11	0
01060000206A08000001000000010300000001000000180000009A999999D5F723419A999919122C5A41CDCCCCCCF9F723419A9999F9122C5A410000000049F82341000000A0142C5A419A999999ADF8234133333393162C5A4100000000E9F82341333333D3172C5A413333333316F92341000000C0182C5A410000000047FA2341666666061F2C5A416666666674FA23419A999939202C5A41CDCCCCCCAEFA234133333353212C5A41CDCCCCCC73FB234100000080252C5A41CDCCCCCC4BFB23419A9999F9002C5A41CDCCCCCC3BFB2341000000C0EF2B5A41CDCCCCCC39FB2341000000E0ED2B5A41CDCCCCCC33FB234100000000EA2B5A410000000004FB234100000060E92B5A41CDCCCCCCF5FA2341CDCCCCCCE82B5A41CDCCCCCCC9FA23419A9999B9E52B5A4100000000ABFA234133333393E32B5A413333333364FA234100000080DE2B5A41000000003DFA23419A999999DB2B5A413333333336FA23419A999919DB2B5A413333333332F92341CDCCCC4CF32B5A419A999999FDF7234100000000102C5A419A999999D5F723419A999919122C5A41	01060000206A08000001000000010300000001000000090000009A999999D5F723419A999919122C5A410000000047FA2341666666061F2C5A41CDCCCCCC73FB234100000080252C5A41CDCCCCCC33FB234100000000EA2B5A41CDCCCCCCF5FA2341CDCCCCCCE82B5A413333333336FA23419A999919DB2B5A419A999999FDF7234100000000102C5A419A999999D5F723419A999919122C5A419A999999D5F723419A999919122C5A41	01010000206A08000016E05A1017FA234134333323FA2B5A41	751124801	H	Quinze-Vingts 1	7511248	75112	75	11	0
01060000206A0800000100000001030000000100000027000000CDCCCCCCF3F52341CDCCCC8C062C5A41333333330FF623419A999939092C5A4133333333CFF62341000000200D2C5A4100000000DDF62341000000600D2C5A419A999999FAF62341666666E60D2C5A41666666662BF72341333333D30E2C5A41666666663AF723419A9999190F2C5A4166666666C0F723419A999979112C5A419A999999D5F723419A999919122C5A419A999999FDF7234100000000102C5A413333333332F92341CDCCCC4CF32B5A413333333336FA23419A999919DB2B5A41000000002BFA234100000040DA2B5A41333333331EFA234133333373D92B5A419A99999925F9234100000040C82B5A41666666660FF9234133333393CA2B5A4133333333FEF82341CDCCCC4CCC2B5A4100000000EFF8234100000060CA2B5A410000000074F82341CDCCCC2CD32B5A416666666614F8234100000000DA2B5A4100000000C4F72341000000A0DF2B5A41CDCCCCCCABF72341CDCCCC4CE12B5A4166666666A1F72341CDCCCC6CE12B5A41CDCCCCCC1BF723419A9999D9EF2B5A413333333305F72341000000A0F12B5A419A999999F9F623419A9999D9F22B5A4133333333DAF623419A9999F9ED2B5A4133333333CCF62341CDCCCC4CED2B5A4133333333BFF6234133333393ED2B5A4100000000ACF6234133333393EF2B5A416666666689F6234100000020F32B5A41333333336BF623419A999999F52B5A41CDCCCCCC61F623419A999999F62B5A413333333351F623419A999959F82B5A41CDCCCCCC12F6234100000000FF2B5A41CDCCCCCC03F6234166666686012C5A4133333333FEF52341333333D3022C5A4166666666F7F52341333333B3042C5A41CDCCCCCCF3F52341CDCCCC8C062C5A41	01060000206A0800000100000001030000000100000010000000CDCCCCCCF3F52341CDCCCC8C062C5A41333333330FF623419A999939092C5A419A999999D5F723419A999919122C5A419A999999FDF7234100000000102C5A413333333336FA23419A999919DB2B5A419A99999925F9234100000040C82B5A4133333333FEF82341CDCCCC4CCC2B5A4100000000EFF8234100000060CA2B5A41CDCCCCCCABF72341CDCCCC4CE12B5A4166666666A1F72341CDCCCC6CE12B5A419A999999F9F623419A9999D9F22B5A4133333333DAF623419A9999F9ED2B5A4133333333BFF6234133333393ED2B5A41CDCCCCCC12F6234100000000FF2B5A41CDCCCCCCF3F52341CDCCCC8C062C5A41CDCCCCCCF3F52341CDCCCC8C062C5A41	01010000206A0800000C28706E8EF82341CDCCCC5CE72B5A41	751124802	H	Quinze-Vingts 2	7511248	75112	75	11	0
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	01060000206A08000001000000010300000001000000290000009A999999E8052441CDCCCCCCA82A5A410000000036072441CDCCCC6CBF2A5A419A9999997A072441333333F3C52A5A4100000000710824419A999999E12A5A419A999999F3082441666666E6F52A5A419A9999992709244166666686002B5A41000000003E092441000000C0092B5A41333333337109244166666666292B5A419A999999F409244100000080732B5A419A999999650A2441CDCCCC6C732B5A4100000000AB0A2441CDCCCC4C742B5A419A999999E10A24419A999999762B5A41CDCCCCCC460B24419A9999F97C2B5A4133333333A00B2441666666A67C2B5A41CDCCCCCCE20B24419A999939802B5A4133333333E60B2441000000007E2B5A41000000003C0C2441CDCCCCCC802B5A41CDCCCCCC530C24419A999979792B5A4166666666470C244166666646692B5A4166666666300C2441333333735E2B5A41666666663B0C2441000000A05C2B5A4166666666AE0C2441000000805A2B5A41CDCCCCCCC10C2441333333D3572B5A41666666667A0C2441333333B32E2B5A419A9999990C0C244100000080F52A5A41CDCCCCCCB00B2441333333F3C62A5A41333333333E0B24419A999919B62A5A4166666666E70A2441CDCCCCACB72A5A41333333338E0A244166666626BC2A5A41CDCCCCCC450A2441666666A6C32A5A41333333335B0924419A999939D32A5A41000000003F092441666666E6D02A5A4166666666210924419A9999D9C72A5A419A99999900092441CDCCCC8CC12A5A41CDCCCCCC0608244100000040A82A5A4100000000C40724419A9999D9A22A5A419A99999933072441000000E09B2A5A41CDCCCCCC1407244166666666912A5A4100000000E30624419A9999B9892A5A419A999999E8052441CDCCCCCCA82A5A419A999999E8052441CDCCCCCCA82A5A41	01010000206A0800001C8E9896AE0A2441000000A0042B5A41	751124501	H	Bel-Air 1	7511245	75112	75	11	0
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	01060000206A080000010000000103000000010000001100000033333333590624419A999919F72A5A4166666666A90624419A999939022B5A419A999999B7062441666666E6072B5A4166666666DF062441666666A61F2B5A410000000095082441000000C0342B5A41333333337509244166666606402B5A419A9999999B092441666666E6402B5A41333333337109244166666666292B5A41000000003E092441000000C0092B5A419A9999992709244166666686002B5A419A999999F3082441666666E6F52A5A4100000000710824419A999999E12A5A419A9999997A072441333333F3C52A5A4100000000380724419A999999BF2A5A4133333333B50624419A9999B9DF2A5A4133333333590624419A999919F72A5A4133333333590624419A999919F72A5A41	01010000206A0800005C0A86E3DD0724419A9999B9FF2A5A41	751124502	H	Bel-Air 2	7511245	75112	75	11	0
01060000206A080000010000000103000000010000003300000066666666DF062441666666A61F2B5A41CDCCCCCCE706244133333373252B5A41CDCCCCCC24072441CDCCCCCC4C2B5A410000000037072441333333B3592B5A41CDCCCCCC43072441CDCCCC4C612B5A41333333336E07244133333333612B5A41CDCCCCCC9C0724419A999959612B5A419A999999C207244100000080612B5A4100000000D707244133333393612B5A41CDCCCCCC1708244166666606622B5A41000000003908244166666626622B5A41CDCCCCCC6008244166666666622B5A413333333375082441333333D3622B5A41000000008508244133333333632B5A419A999999A5082441CDCCCCEC632B5A419A999999B70824419A9999B9642B5A41CDCCCCCCD1082441000000A0652B5A4166666666EE082441666666A6662B5A41000000000A092441666666A6672B5A41333333331E09244166666646682B5A419A9999993A09244166666626692B5A41666666665009244100000060692B5A4133333333780924419A999979692B5A4166666666AD092441CDCCCC8C692B5A4166666666D1092441000000C0692B5A4100000000E4092441333333B3692B5A419A999999E0092441000000C0672B5A4166666666DB092441666666C6642B5A41CDCCCCCCD5092441000000A0612B5A4166666666D0092441CDCCCC8C5E2B5A419A999999C9092441000000005B2B5A4133333333C3092441CDCCCC6C572B5A4133333333BC092441000000A0532B5A4133333333B5092441CDCCCC8C4F2B5A4166666666AE092441333333934B2B5A41CDCCCCCCA6092441CDCCCC6C472B5A4100000000A00924419A999979432B5A419A9999999B092441666666E6402B5A41000000008B092441333333D3402B5A419A9999997F09244133333373402B5A41333333337509244166666606402B5A41000000005F0924419A9999F93E2B5A416666666644092441666666A63D2B5A416666666624092441333333133C2B5A416666666600092441333333533A2B5A4166666666BB08244166666606372B5A410000000095082441000000C0342B5A41CDCCCCCC2B082441CDCCCC8C2F2B5A4166666666C7072441333333D32A2B5A41666666662B0724419A999939232B5A4166666666DF062441666666A61F2B5A41	01060000206A080000010000000103000000010000000B00000066666666DF062441666666A61F2B5A41CDCCCCCC43072441CDCCCC4C612B5A41CDCCCCCC6008244166666666622B5A419A999999A5082441CDCCCCEC632B5A41666666665009244100000060692B5A4100000000E4092441333333B3692B5A419A9999999B092441666666E6402B5A41333333337509244166666606402B5A410000000095082441000000C0342B5A4166666666DF062441666666A61F2B5A4166666666DF062441666666A61F2B5A41	01010000206A08000074412E675E08244134333373452B5A41	751124503	H	Bel-Air 3	7511245	75112	75	11	0
01060000206A080000010000000103000000010000002700000000000000C404244100000040592B5A4133333333E00424419A999959592B5A4166666666FE0424419A999919592B5A41333333330D0524419A999919592B5A41CDCCCCCCA005244133333353582B5A419A9999992506244133333333582B5A419A99999983062441CDCCCC6C582B5A419A999999D20624419A9999F9582B5A41CDCCCCCC13072441CDCCCC2C592B5A410000000037072441333333B3592B5A41CDCCCCCC24072441CDCCCCCC4C2B5A41CDCCCCCCE706244133333373252B5A4166666666DF062441666666A61F2B5A4133333333BD062441000000A00B2B5A419A999999B7062441666666E6072B5A41CDCCCCCCB106244100000080052B5A419A999999AD062441666666C6032B5A4166666666A90624419A999939022B5A4133333333590624419A999919F72A5A41666666661906244166666646072B5A416666666608062441333333330C2B5A413333333302062441666666260E2B5A419A999999FB05244166666666102B5A4166666666E7052441CDCCCCCC112B5A4133333333F30524419A999939152B5A41CDCCCCCCF005244133333353192B5A4166666666E7052441333333531C2B5A4100000000C50524419A999939242B5A41CDCCCCCCA7052441666666462B2B5A41CDCCCCCC8D05244133333313322B5A41CDCCCCCC7405244133333313382B5A41CDCCCCCC610524419A9999B93B2B5A419A9999994C052441000000C03F2B5A413333333316052441666666464A2B5A419A99999910052441333333534B2B5A419A999999050524419A9999594D2B5A4133333333E20424419A999939532B5A4166666666D0042441333333D3562B5A4100000000C404244100000040592B5A41	01060000206A080000010000000103000000010000000D00000000000000C404244100000040592B5A419A9999992506244133333333582B5A410000000037072441333333B3592B5A4166666666DF062441666666A61F2B5A419A999999B7062441666666E6072B5A4166666666A90624419A999939022B5A4133333333590624419A999919F72A5A41666666661906244166666646072B5A4133333333F30524419A999939152B5A4166666666E7052441333333531C2B5A41CDCCCCCC7405244133333313382B5A4100000000C404244100000040592B5A4100000000C404244100000040592B5A41	01010000206A080000615DCA1650062441CCCCCC5C282B5A41	751124504	H	Bel-Air 4	7511245	75112	75	11	0
01060000206A080000010000000103000000010000002300000000000000C404244100000040592B5A4100000000EA042441333333735E2B5A4100000000F304244166666666622B5A4100000000F6042441666666C6632B5A41666666661205244133333313712B5A410000000025052441666666267A2B5A41333333332A052441000000A07C2B5A41000000002B052441333333137D2B5A419A999999310524419A999939802B5A41000000005705244133333373922B5A41333333339A0524419A999939B32B5A4133333333AE052441333333F3B12B5A41CDCCCCCCAE052441CDCCCCECB12B5A41000000000D06244133333333AF2B5A41333333330606244100000060962B5A410000000008062441CDCCCC2C7E2B5A4100000000A1062441CDCCCCAC7B2B5A41333333330C072441000000007A2B5A41333333336707244166666686782B5A4166666666630724419A9999F9752B5A41666666665F072441CDCCCC2C732B5A41333333335C0724419A999939712B5A41CDCCCCCC58072441333333336F2B5A4100000000560724419A9999396D2B5A41CDCCCCCC43072441CDCCCC4C612B5A410000000037072441333333B3592B5A41CDCCCCCC13072441CDCCCC2C592B5A419A999999D20624419A9999F9582B5A419A99999983062441CDCCCC6C582B5A419A9999992506244133333333582B5A41CDCCCCCCA005244133333353582B5A41333333330D0524419A999919592B5A4166666666FE0424419A999919592B5A4133333333E00424419A999959592B5A4100000000C404244100000040592B5A41	01060000206A080000010000000103000000010000000C00000000000000C404244100000040592B5A4100000000EA042441333333735E2B5A41666666661205244133333313712B5A41333333339A0524419A999939B32B5A41000000000D06244133333333AF2B5A41333333330606244100000060962B5A410000000008062441CDCCCC2C7E2B5A41333333336707244166666686782B5A410000000037072441333333B3592B5A419A9999992506244133333333582B5A4100000000C404244100000040592B5A4100000000C404244100000040592B5A41	01010000206A0800009E2820BCA505244166666656892B5A41	751124505	H	Bel-Air 5	7511245	75112	75	11	0
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	01060000206A080000010000000103000000010000000F000000CDCCCCCC43072441CDCCCC4C612B5A419A999999CD0724419A9999B9BB2B5A41666666667A082441CDCCCC4CB72B5A41000000004209244100000080B02B5A419A9999997F092441CDCCCC6CCD2B5A4133333333CB09244166666626CB2B5A41333333337D092441000000A08F2B5A4133333333010A2441CDCCCC2C902B5A4133333333250A2441666666468F2B5A4100000000E4092441333333B3692B5A41666666665009244100000060692B5A419A999999A5082441CDCCCCEC632B5A41CDCCCCCC6008244166666666622B5A41CDCCCCCC43072441CDCCCC4C612B5A41CDCCCCCC43072441CDCCCC4C612B5A41	01010000206A080000102628808E082441CDCCCC3C972B5A41	751124509	H	Bel-Air 9	7511245	75112	75	11	0
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	01060000206A08000001000000010300000001000000180000009A999999F409244100000080732B5A4133333333420A2441CDCCCC6C9E2B5A4100000000A60A2441CDCCCC0CD72B5A41000000006D0B2441CDCCCC6CD22B5A419A999999730C244100000080CE2B5A4166666666800D24419A999959C92B5A41000000003C0D244166666686A02B5A419A999999E00C2441CDCCCC0C6C2B5A41CDCCCCCCC10C2441333333D3572B5A4166666666AE0C2441000000805A2B5A41666666663B0C2441000000A05C2B5A4166666666300C2441333333735E2B5A4166666666470C244166666646692B5A41CDCCCCCC530C24419A999979792B5A41000000003C0C2441CDCCCCCC802B5A4133333333E60B2441000000007E2B5A41CDCCCCCCE20B24419A999939802B5A4133333333A00B2441666666A67C2B5A41CDCCCCCC460B24419A9999F97C2B5A419A999999E10A24419A999999762B5A4100000000AB0A2441CDCCCC4C742B5A419A999999650A2441CDCCCC6C732B5A419A999999F409244100000080732B5A419A999999F409244100000080732B5A41	01010000206A0800002D2AC1EFB00B244133333303982B5A41	751124510	H	Bel-Air 10	7511245	75112	75	11	0
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	01060000206A080000010000000103000000010000000F00000000000000A60A2441CDCCCC0CD72B5A4133333333BE0A2441333333F3E32B5A41CDCCCCCCF00A2441000000C0032C5A4166666666F90A24419A9999790E2C5A41CDCCCCCC180B2441CDCCCCCC222C5A4100000000500B244133333373222C5A4133333333440C2441000000A01D2C5A419A999999E70D24419A999959162C5A41CDCCCCCCC70D2441000000A0F52B5A41CDCCCCCCB70D2441CDCCCC2CE92B5A4166666666800D24419A999959C92B5A419A999999730C244100000080CE2B5A41000000006D0B2441CDCCCC6CD22B5A4100000000A60A2441CDCCCC0CD72B5A4100000000A60A2441CDCCCC0CD72B5A41	01010000206A08000028ABFB7D510C244166666616F62B5A41	751124511	H	Bel-Air 11	7511245	75112	75	11	0
01060000206A08000001000000010300000001000000330000003333333307082441333333F3E22B5A41000000004F0824419A999939222C5A410000000054082441000000E0262C5A41666666665A082441CDCCCC6C2C2C5A41CDCCCCCC5A082441000000802C2C5A41000000005D082441CDCCCCCC2E2C5A419A99999971082441000000802E2C5A41CDCCCCCC89082441666666062E2C5A41333333332B092441333333532B2C5A419A999999DC09244100000060282C5A41CDCCCCCC1C0A244133333353272C5A4166666666550A24419A999959262C5A419A999999CD0A244166666626242C5A419A999999F00A244166666686232C5A4100000000170B2441CDCCCCCC222C5A41CDCCCCCC180B2441CDCCCCCC222C5A4166666666160B2441CDCCCC4C202C5A41CDCCCCCC060B244100000060162C5A41CDCCCCCCFE0A2441666666C6112C5A4166666666F90A24419A9999790E2C5A419A999999F60A2441CDCCCC2C0B2C5A41CDCCCCCCF30A2441CDCCCCAC072C5A41CDCCCCCCF00A2441000000C0032C5A4166666666EA0A24419A999979FF2B5A4100000000E30A24419A9999F9FA2B5A419A999999DB0A2441CDCCCC8CF62B5A4100000000D20A24419A9999D9F02B5A4133333333C80A2441333333B3EA2B5A4133333333BE0A2441333333F3E32B5A4166666666B30A244100000000DE2B5A41CDCCCCCCA80A244166666686D82B5A4100000000A60A2441CDCCCC0CD72B5A41CDCCCCCC9C0A244100000020D72B5A4133333333910A24419A9999F9D62B5A41CDCCCCCC7D0A24419A999939D82B5A41CDCCCCCC540A2441000000E0D82B5A41CDCCCCCC2A0A24419A999979D92B5A419A999999010A244100000020DA2B5A419A999999E409244133333393DA2B5A4133333333B9092441CDCCCC4CDB2B5A41000000008809244133333313DC2B5A419A99999953092441000000E0DC2B5A419A999999180924419A9999F9DD2B5A4100000000E2082441CDCCCCECDE2B5A4166666666AB0824419A9999D9DF2B5A419A9999997D082441666666A6E02B5A416666666656082441CDCCCC4CE12B5A41666666663A082441CDCCCC0CE22B5A41000000002008244133333373E22B5A41CDCCCCCC0F082441CDCCCCCCE22B5A413333333307082441333333F3E22B5A41	01060000206A080000010000000103000000010000000C0000003333333307082441333333F3E22B5A41000000005D082441CDCCCCCC2E2C5A4166666666550A24419A999959262C5A41CDCCCCCC180B2441CDCCCCCC222C5A4166666666F90A24419A9999790E2C5A41CDCCCCCCF00A2441000000C0032C5A4133333333BE0A2441333333F3E32B5A4100000000A60A2441CDCCCC0CD72B5A41CDCCCCCC7D0A24419A999939D82B5A419A99999953092441000000E0DC2B5A413333333307082441333333F3E22B5A413333333307082441333333F3E22B5A41	01010000206A080000D85BFCCB8B092441CDCCCC9C012C5A41	751124512	H	Bel-Air 12	7511245	75112	75	11	0
01060000206A0800000100000001030000000100000018000000000000000806244100000080EB2B5A41333333332D06244166666686EC2B5A41000000002E0624419A9999B9EC2B5A41333333333B062441333333F3EF2B5A419A9999998C0624419A999939002C5A4100000000AE0624419A999999222C5A4133333333B9062441CDCCCCEC2D2C5A419A999999BA0624419A9999792F2C5A4100000000BD06244166666606342C5A41CDCCCCCCBC0624419A999939362C5A416666666647082441000000202F2C5A419A9999994E082441666666062F2C5A41000000005D082441CDCCCCCC2E2C5A41CDCCCCCC5A082441000000802C2C5A41666666665A082441CDCCCC6C2C2C5A410000000054082441000000E0262C5A41000000004F0824419A999939222C5A413333333307082441333333F3E22B5A41CDCCCCCCF107244166666646E32B5A410000000053072441666666E6E52B5A4100000000740624419A9999B9E92B5A410000000032062441CDCCCC6CE92B5A416666666628062441CDCCCCECE92B5A41000000000806244100000080EB2B5A41	01060000206A080000010000000103000000010000000B000000000000000806244100000080EB2B5A41333333332D06244166666686EC2B5A419A9999998C0624419A999939002C5A419A999999BA0624419A9999792F2C5A41CDCCCCCCBC0624419A999939362C5A41000000005D082441CDCCCCCC2E2C5A413333333307082441333333F3E22B5A4100000000740624419A9999B9E92B5A410000000032062441CDCCCC6CE92B5A41000000000806244100000080EB2B5A41000000000806244100000080EB2B5A41	01010000206A080000BCDEE8696C0724419A999939112C5A41	751124513	H	Bel-Air 13	7511245	75112	75	11	0
01060000206A080000010000000103000000010000001A0000009A9999993104244100000080312C5A41CDCCCCCC350424419A999979342C5A41CDCCCCCC3B04244166666686392C5A416666666640042441666666263E2C5A410000000041042441CDCCCCAC412C5A41CDCCCCCCBC0624419A999939362C5A4100000000BD06244166666606342C5A419A999999BA0624419A9999792F2C5A4133333333B9062441CDCCCCEC2D2C5A4100000000AE0624419A999999222C5A419A9999998C0624419A999939002C5A41333333333B062441333333F3EF2B5A41000000002E0624419A9999B9EC2B5A41333333332D06244166666686EC2B5A41000000000806244100000080EB2B5A41CDCCCCCC0E0624419A9999F9EF2B5A41CDCCCCCCF8052441666666C6F22B5A419A9999995D052441CDCCCCEC062C5A41666666665305244133333333082C5A41CDCCCCCCD9042441CDCCCC4C182C5A410000000088042441CDCCCCAC222C5A419A9999996C04244100000060262C5A419A9999994C0424419A9999592A2C5A4133333333440424419A9999D92B2C5A41CDCCCCCC3B042441333333532D2C5A419A9999993104244100000080312C5A41	01060000206A080000010000000103000000010000000C0000009A9999993104244100000080312C5A410000000041042441CDCCCCAC412C5A41CDCCCCCCBC0624419A999939362C5A419A999999BA0624419A9999792F2C5A419A9999998C0624419A999939002C5A41333333332D06244166666686EC2B5A41000000000806244100000080EB2B5A41CDCCCCCC0E0624419A9999F9EF2B5A41CDCCCCCCD9042441CDCCCC4C182C5A419A9999994C0424419A9999592A2C5A419A9999993104244100000080312C5A419A9999993104244100000080312C5A41	01010000206A080000AFD99E62D905244100000040102C5A41	751124514	H	Bel-Air 14	7511245	75112	75	11	0
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	01010000206A08000016FE6855091F2441000000B0EA2A5A41	751124577	D	Bois de Vincennes 1	7511245	75112	75	11	5
01060000206A08000001000000010300000001000000300000009A9999997604244166666606EC2A5A41000000009704244100000060EF2A5A4133333333E3042441CDCCCC6CF62A5A41CDCCCCCC37052441CDCCCC2CFE2A5A416666666676052441333333B3032B5A4166666666AE05244133333373082B5A4133333333EC0524419A9999390E2B5A4100000000F3052441666666260F2B5A419A999999FB05244166666666102B5A413333333302062441666666260E2B5A416666666608062441333333330C2B5A41666666661906244166666646072B5A4133333333590624419A999919F72A5A410000000063062441CDCCCC8CF42A5A41333333338B062441CDCCCC2CEB2A5A4133333333B50624419A9999B9DF2A5A4166666666DD06244133333373D52A5A410000000006072441CDCCCC8CCB2A5A419A9999991B07244133333393C62A5A419A9999993307244166666646C12A5A4100000000380724419A999999BF2A5A410000000036072441CDCCCC6CBF2A5A413333333320072441666666C6BD2A5A41666666660907244133333333BC2A5A4166666666F4062441333333B3BA2A5A4133333333DF06244100000040B92A5A4100000000CA062441000000E0B72A5A4133333333B606244133333393B62A5A4100000000A206244133333333B52A5A41000000008E062441CDCCCCCCB32A5A419A9999997706244133333353B22A5A416666666661062441333333D3B02A5A419A9999994B06244166666666AF2A5A41CDCCCCCC330624419A9999D9AD2A5A41333333331D062441CDCCCC4CAC2A5A41CDCCCCCC070624419A9999D9AA2A5A4100000000EE052441CDCCCC2CA92A5A419A999999E8052441CDCCCCCCA82A5A4133333333DC052441CDCCCCACAA2A5A4133333333C7052441666666A6AD2A5A4133333333B40524419A999959B02A5A41666666669E052441666666C6B32A5A41000000008805244100000080B72A5A41CDCCCCCC7105244133333393BB2A5A41CDCCCCCC5E05244133333373BF2A5A41333333331D05244166666686CB2A5A4100000000FF04244100000080D22A5A419A9999997604244166666606EC2A5A41	01060000206A080000010000000103000000010000000F0000009A9999997604244166666606EC2A5A41CDCCCCCC37052441CDCCCC2CFE2A5A4166666666AE05244133333373082B5A419A999999FB05244166666666102B5A41666666661906244166666646072B5A41333333338B062441CDCCCC2CEB2A5A4133333333B50624419A9999B9DF2A5A4100000000380724419A999999BF2A5A4133333333DF06244100000040B92A5A419A999999E8052441CDCCCCCCA82A5A41000000008805244100000080B72A5A41333333331D05244166666686CB2A5A4100000000FF04244100000080D22A5A419A9999997604244166666606EC2A5A419A9999997604244166666606EC2A5A41	01010000206A08000052B0848ACE05244166666696DA2A5A41	751124601	H	Picpus 1	7511246	75112	75	11	0
01060000206A0800000100000001030000000100000034000000333333335B0324419A9999D9BE2A5A4133333333A6032441CDCCCC8CCC2A5A419A999999CF032441666666C6D32A5A4166666666DD032441CDCCCC2CD62A5A4133333333F9032441CDCCCC8CDA2A5A419A9999993E042441CDCCCCCCE42A5A419A9999997604244166666606EC2A5A4100000000FF04244100000080D22A5A41333333331D05244166666686CB2A5A41CDCCCCCC5E05244133333373BF2A5A41CDCCCCCC7105244133333393BB2A5A41000000008805244100000080B72A5A41666666669E052441666666C6B32A5A4133333333B40524419A999959B02A5A4133333333C7052441666666A6AD2A5A4133333333DC052441CDCCCCACAA2A5A419A999999E8052441CDCCCCCCA82A5A4100000000D80524419A9999B9A72A5A4133333333C10524419A999939A62A5A4133333333AA0524419A9999B9A42A5A41CDCCCCCC9205244166666626A32A5A41666666667B0524419A999999A12A5A4166666666620524419A9999F99F2A5A41666666664B052441CDCCCC6C9E2A5A41CDCCCCCC33052441333333D39C2A5A41666666661C052441CDCCCC4C9B2A5A416666666605052441000000C0992A5A419A999999EF0424419A999959982A5A4166666666D90424419A9999D9962A5A4100000000C104244100000040952A5A4100000000AA042441333333B3932A5A419A9999999C042441666666C6922A5A41333333339404244100000040942A5A41666666665A042441CDCCCC8C9B2A5A416666666652042441CDCCCC6C9C2A5A41CDCCCCCC50042441CDCCCCAC9C2A5A419A9999994F042441CDCCCCCC9C2A5A413333333349042441CDCCCCAC9D2A5A410000000046042441333333139E2A5A4100000000430424419A9999799E2A5A4100000000420424419A9999999E2A5A419A9999993C042441333333539F2A5A41666666663A042441666666A69F2A5A419A999999350424419A999939A02A5A419A9999992904244100000000A22A5A41333333330E04244166666606A62A5A4166666666CF0324419A9999B9AF2A5A4100000000BC032441CDCCCCECB22A5A419A999999A9032441000000E0B52A5A41333333339F03244100000060B72A5A410000000066032441666666C6BD2A5A41333333335B0324419A9999D9BE2A5A41	01060000206A080000010000000103000000010000000D000000333333335B0324419A9999D9BE2A5A4166666666DD032441CDCCCC2CD62A5A419A9999993E042441CDCCCCCCE42A5A419A9999997604244166666606EC2A5A4100000000FF04244100000080D22A5A41333333331D05244166666686CB2A5A41000000008805244100000080B72A5A419A999999E8052441CDCCCCCCA82A5A419A9999999C042441666666C6922A5A419A999999350424419A999939A02A5A41333333339F03244100000060B72A5A41333333335B0324419A9999D9BE2A5A41333333335B0324419A9999D9BE2A5A41	01010000206A080000B6BA808E5E04244166666626BF2A5A41	751124602	H	Picpus 2	7511246	75112	75	11	0
01060000206A080000010000000103000000010000003700000000000000BE01244166666686AF2A5A419A999999EA012441CDCCCCACB42A5A41000000003C022441CDCCCCCCBC2A5A4133333333440224419A999999BD2A5A4166666666D5022441CDCCCC6CCB2A5A4100000000E8022441CDCCCCCCC92A5A41CDCCCCCC3F03244133333393C12A5A41333333335B0324419A9999D9BE2A5A410000000066032441666666C6BD2A5A41333333339F03244100000060B72A5A419A999999A9032441000000E0B52A5A4100000000BC032441CDCCCCECB22A5A4166666666CF0324419A9999B9AF2A5A41333333330E04244166666606A62A5A419A9999992904244100000000A22A5A419A999999350424419A999939A02A5A41666666663A042441666666A69F2A5A419A9999993C042441333333539F2A5A4100000000420424419A9999999E2A5A4100000000430424419A9999799E2A5A410000000046042441333333139E2A5A413333333349042441CDCCCCAC9D2A5A419A9999994F042441CDCCCCCC9C2A5A41CDCCCCCC50042441CDCCCCAC9C2A5A416666666652042441CDCCCC6C9C2A5A41666666665A042441CDCCCC8C9B2A5A41333333339404244100000040942A5A419A9999999C042441666666C6922A5A4133333333940424419A999939922A5A419A9999997E042441CDCCCCCC902A5A410000000068042441CDCCCC4C8F2A5A4133333333510424419A9999B98D2A5A41333333333E0424419A9999598C2A5A41CDCCCCCC28042441000000E08A2A5A41000000001304244133333353892A5A41CDCCCCCCFF032441666666E6872A5A41CDCCCCCCEC03244133333373862A5A41CDCCCCCCD7032441333333D3842A5A4100000000C303244100000040832A5A41CDCCCCCCAE032441333333B3812A5A41666666669C03244100000040802A5A41333333338A0324419A9999D97E2A5A41CDCCCCCC75032441CDCCCC2C7D2A5A419A99999962032441CDCCCCAC7B2A5A419A999999500324419A9999997D2A5A413333333348032441333333737E2A5A41333333333B0324419A9999F97F2A5A41333333333003244166666686812A5A41333333332403244100000020832A5A419A9999991F032441333333B3832A5A419A99999901032441CDCCCC4C872A5A41CDCCCCCCE9022441000000808A2A5A4100000000AE022441666666C6912A5A41CDCCCCCC1C022441CDCCCC6CA32A5A4100000000BE01244166666686AF2A5A41	01060000206A080000010000000103000000010000000C00000000000000BE01244166666686AF2A5A419A999999EA012441CDCCCCACB42A5A4166666666D5022441CDCCCC6CCB2A5A41CDCCCCCC3F03244133333393C12A5A41333333339F03244100000060B72A5A419A999999350424419A999939A02A5A419A9999999C042441666666C6922A5A41000000001304244133333353892A5A419A99999962032441CDCCCCAC7B2A5A41CDCCCCCC1C022441CDCCCC6CA32A5A4100000000BE01244166666686AF2A5A4100000000BE01244166666686AF2A5A41	01010000206A0800003D7B10D5140324419A9999B9A42A5A41	751124603	H	Picpus 3	7511246	75112	75	11	0
01060000206A080000010000000103000000010000001E00000000000000B1FF23419A999979142B5A41CDCCCCCCD5FF2341CDCCCC2C112B5A419A999999EDFF2341CDCCCCEC0E2B5A41CDCCCCCCFEFF2341333333730D2B5A416666666623002441CDCCCC8C0B2B5A41CDCCCCCCC4002441666666A6032B5A41CDCCCCCCAF00244133333373FE2A5A41333333335A01244100000020EF2A5A41CDCCCCCCC90124419A999979E32A5A4166666666F301244166666686DF2A5A41CDCCCCCC5E02244100000000D52A5A41666666667F02244100000040D22A5A4166666666D5022441CDCCCC6CCB2A5A4133333333440224419A999999BD2A5A41000000003C022441CDCCCCCCBC2A5A419A999999EA012441CDCCCCACB42A5A4100000000BE01244166666686AF2A5A410000000074012441666666A6B82A5A410000000061012441CDCCCC0CBB2A5A419A9999995501244166666686BC2A5A4133333333390124419A9999B9C02A5A41666666661301244133333333C72A5A419A999999E3002441000000E0CF2A5A41333333338B00244100000020DE2A5A4133333333320024419A9999B9F42A5A41CDCCCCCC050024419A999939FF2A5A4100000000DAFF2341000000200B2B5A4133333333CFFF23419A9999B90D2B5A419A999999C8FF2341CDCCCC2C0F2B5A4100000000B1FF23419A999979142B5A41	01060000206A080000010000000103000000010000001000000000000000B1FF23419A999979142B5A41CDCCCCCCFEFF2341333333730D2B5A41CDCCCCCCC4002441666666A6032B5A41CDCCCCCCAF00244133333373FE2A5A41333333335A01244100000020EF2A5A41CDCCCCCCC90124419A999979E32A5A41CDCCCCCC5E02244100000000D52A5A4166666666D5022441CDCCCC6CCB2A5A419A999999EA012441CDCCCCACB42A5A4100000000BE01244166666686AF2A5A4133333333390124419A9999B9C02A5A419A999999E3002441000000E0CF2A5A41333333338B00244100000020DE2A5A4100000000DAFF2341000000200B2B5A4100000000B1FF23419A999979142B5A4100000000B1FF23419A999979142B5A41	01010000206A0800005C3B29412E01244100000080E12A5A41	751124604	H	Picpus 4	7511246	75112	75	11	0
01060000206A080000010000000103000000010000001B000000CDCCCCCCAF00244133333373FE2A5A41CDCCCCCCC4002441666666A6032B5A41333333339D012441333333D3F82A5A41CDCCCCCCE001244133333393F52A5A41333333334A02244100000040F02A5A4166666666B6022441CDCCCCECEA2A5A41666666660103244166666646E72A5A41000000004303244166666606F12A5A41666666664603244100000080F12A5A41CDCCCCCCC903244133333373052B5A4133333333190424419A9999B9F92A5A419A9999997604244166666606EC2A5A419A9999993E042441CDCCCCCCE42A5A4133333333F9032441CDCCCC8CDA2A5A4166666666DD032441CDCCCC2CD62A5A419A999999CF032441666666C6D32A5A4133333333A6032441CDCCCC8CCC2A5A41333333335B0324419A9999D9BE2A5A41CDCCCCCC3F03244133333393C12A5A4100000000E8022441CDCCCCCCC92A5A4166666666D5022441CDCCCC6CCB2A5A41666666667F02244100000040D22A5A41CDCCCCCC5E02244100000000D52A5A4166666666F301244166666686DF2A5A41CDCCCCCCC90124419A999979E32A5A41333333335A01244100000020EF2A5A41CDCCCCCCAF00244133333373FE2A5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCCAF00244133333373FE2A5A41CDCCCCCCC4002441666666A6032B5A41666666660103244166666646E72A5A41CDCCCCCCC903244133333373052B5A419A9999997604244166666606EC2A5A419A9999993E042441CDCCCCCCE42A5A4166666666DD032441CDCCCC2CD62A5A41333333335B0324419A9999D9BE2A5A4166666666D5022441CDCCCC6CCB2A5A41CDCCCCCC5E02244100000000D52A5A41CDCCCCCCC90124419A999979E32A5A41333333335A01244100000020EF2A5A41CDCCCCCCAF00244133333373FE2A5A41CDCCCCCCAF00244133333373FE2A5A41	01010000206A080000DA96A46D0303244100000080E12A5A41	751124605	H	Picpus 5	7511246	75112	75	11	0
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	01060000206A0800000100000001030000000100000014000000CDCCCCCCC101244133333313572B5A41CDCCCCCCD7012441333333735F2B5A41000000000D02244133333393632B5A41CDCCCCCC220224419A9999D9602B5A4166666666B0022441CDCCCC6C5A2B5A419A999999AD022441000000A0572B5A41CDCCCCCC0C032441CDCCCCCC542B5A41666666667F042441CDCCCCAC562B5A4100000000C404244100000040592B5A41CDCCCCCC7405244133333313382B5A4166666666E7052441333333531C2B5A4133333333F30524419A999939152B5A4166666666E7052441CDCCCCCC112B5A4133333333290524419A9999791F2B5A4133333333DB02244100000020492B5A41666666668D022441CDCCCCEC4A2B5A4133333333F901244100000040512B5A4100000000D0012441666666A6502B5A41CDCCCCCCC101244133333313572B5A41CDCCCCCCC101244133333313572B5A41	01010000206A080000D7AF0F488F042441666666E6392B5A41	751124608	H	Picpus 8	7511246	75112	75	11	0
01060000206A080000010000000103000000010000001A000000CDCCCCCCC4002441666666A6032B5A41CDCCCCCCF0002441CDCCCC2C0C2B5A41000000007701244166666606252B5A419A9999998101244166666606262B5A4100000000910124419A999959272B5A41000000003802244133333393352B5A41000000008B022441CDCCCCCC3C2B5A419A99999993022441666666263B2B5A4166666666CB022441000000C02F2B5A4100000000D5022441000000A02E2B5A4166666666E7022441666666462B2B5A41CDCCCCCC1F032441666666C6212B5A416666666632032441333333531E2B5A419A99999951032441CDCCCC2C192B5A41000000006F032441000000A0142B5A41333333337703244166666626122B5A4166666666A5032441666666060B2B5A41CDCCCCCCC903244133333373052B5A41666666664603244100000080F12A5A41000000004303244166666606F12A5A41666666660103244166666646E72A5A4166666666B6022441CDCCCCECEA2A5A41333333334A02244100000040F02A5A41CDCCCCCCE001244133333393F52A5A41333333339D012441333333D3F82A5A41CDCCCCCCC4002441666666A6032B5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCCC4002441666666A6032B5A41000000007701244166666606252B5A41000000008B022441CDCCCCCC3C2B5A4166666666CB022441000000C02F2B5A41000000006F032441000000A0142B5A41333333337703244166666626122B5A41CDCCCCCCC903244133333373052B5A41666666660103244166666646E72A5A41CDCCCCCCC4002441666666A6032B5A41CDCCCCCCC4002441666666A6032B5A41	01010000206A080000940DADC0450224419A9999290F2B5A41	751124609	H	Picpus 9	7511246	75112	75	11	0
01060000206A080000010000000103000000010000001B00000033333333D2FF2341CDCCCC2C1C2B5A4166666666160024419A999999242B5A4133333333C700244166666686392B5A4166666666100124419A999919422B5A41000000004D012441333333F3482B5A419A99999987012441333333934F2B5A4133333333900124419A999979502B5A41666666669A01244166666666512B5A4166666666BB012441000000C0522B5A4100000000CC0124419A999939532B5A4100000000D0012441666666A6502B5A4100000000E901244100000040512B5A4100000000F401244100000040512B5A4133333333F901244100000040512B5A4100000000FE01244166666606512B5A419A9999994D022441666666864D2B5A413333333350022441666666E64B2B5A419A99999954022441333333134A2B5A41CDCCCCCC71022441000000C0422B5A41000000008B022441CDCCCCCC3C2B5A41000000003802244133333393352B5A4100000000910124419A999959272B5A419A9999998101244166666606262B5A41000000007701244166666606252B5A41CDCCCCCCF0002441CDCCCC2C0C2B5A4133333333EDFF2341CDCCCC6C1A2B5A4133333333D2FF2341CDCCCC2C1C2B5A41	01060000206A080000010000000103000000010000000C00000033333333D2FF2341CDCCCC2C1C2B5A4166666666100124419A999919422B5A41666666669A01244166666666512B5A4100000000CC0124419A999939532B5A4100000000D0012441666666A6502B5A4133333333F901244100000040512B5A419A9999994D022441666666864D2B5A41000000008B022441CDCCCCCC3C2B5A41000000007701244166666606252B5A41CDCCCCCCF0002441CDCCCC2C0C2B5A4133333333D2FF2341CDCCCC2C1C2B5A4133333333D2FF2341CDCCCC2C1C2B5A41	01010000206A0800007EE87F1D27012441666666762E2B5A41	751124610	H	Picpus 10	7511246	75112	75	11	0
01060000206A08000001000000010300000001000000200000003333333386FE2341000000C0452B5A4133333333E1FE234133333313472B5A416666666607FF2341000000A0472B5A41CDCCCCCC3EFF2341CDCCCC6C482B5A41666666662A002441666666064C2B5A41CDCCCCCCD40024419A9999794E2B5A419A99999939012441333333D34F2B5A41000000006101244100000060502B5A41CDCCCCCC80012441333333D3502B5A41666666669A01244166666666512B5A4133333333900124419A999979502B5A419A99999987012441333333934F2B5A41000000004D012441333333F3482B5A4166666666100124419A999919422B5A4133333333C700244166666686392B5A4166666666160024419A999999242B5A4133333333D2FF2341CDCCCC2C1C2B5A4133333333EDFF2341CDCCCC6C1A2B5A41CDCCCCCCF0002441CDCCCC2C0C2B5A41CDCCCCCCC4002441666666A6032B5A416666666623002441CDCCCC8C0B2B5A41CDCCCCCCFEFF2341333333730D2B5A419A999999EDFF2341CDCCCCEC0E2B5A41CDCCCCCCD5FF2341CDCCCC2C112B5A4100000000B1FF23419A999979142B5A419A999999A4FF2341CDCCCCCC162B5A41333333339BFF234133333373182B5A41CDCCCCCC6BFF23419A9999D91F2B5A41CDCCCCCC00FF23419A9999F9302B5A4166666666B6FE2341333333933C2B5A410000000094FE23419A999979422B5A413333333386FE2341000000C0452B5A41	01060000206A080000010000000103000000010000000C0000003333333386FE2341000000C0452B5A41666666669A01244166666666512B5A4166666666100124419A999919422B5A4133333333D2FF2341CDCCCC2C1C2B5A41CDCCCCCCF0002441CDCCCC2C0C2B5A41CDCCCCCCC4002441666666A6032B5A41CDCCCCCCFEFF2341333333730D2B5A4100000000B1FF23419A999979142B5A41333333339BFF234133333373182B5A4166666666B6FE2341333333933C2B5A413333333386FE2341000000C0452B5A413333333386FE2341000000C0452B5A41	01010000206A080000948FF011B9FF23419A9999C92A2B5A41	751124611	H	Picpus 11	7511246	75112	75	11	0
01060000206A08000001000000010300000001000000310000000000000067FD234166666606882B5A416666666668FD234100000020892B5A41666666666BFD2341000000008A2B5A41000000006EFD2341CDCCCCAC8A2B5A416666666673FD23419A9999D98B2B5A410000000078FD2341000000008D2B5A419A99999996FD2341000000E08A2B5A4133333333CDFD2341333333F3872B5A41CDCCCCCCE7FD234133333393862B5A413333333314FE234133333393842B5A410000000054FE2341000000A0812B5A419A9999996AFE2341000000A0802B5A419A9999997DFE234100000020802B5A4133333333A8FE2341000000407E2B5A41CDCCCCCCA4FF23419A999979732B5A410000000022002441CDCCCC2C6E2B5A41CDCCCCCC680024419A9999F96A2B5A41333333338C00244133333373692B5A4100000000D800244133333333662B5A419A999999310124419A999979622B5A416666666687012441CDCCCCAC5E2B5A419A999999CC012441000000805B2B5A4133333333C801244133333393592B5A4133333333C20124419A9999B9572B5A41CDCCCCCCC101244133333313572B5A41CDCCCCCCC201244166666686562B5A4100000000CC0124419A999939532B5A4166666666BB012441000000C0522B5A41666666669A01244166666666512B5A41CDCCCCCC80012441333333D3502B5A41000000006101244100000060502B5A419A99999939012441333333D34F2B5A41CDCCCCCCD40024419A9999794E2B5A41666666662A002441666666064C2B5A41CDCCCCCC3EFF2341CDCCCC6C482B5A416666666607FF2341000000A0472B5A4133333333E1FE234133333313472B5A413333333386FE2341000000C0452B5A419A99999961FE2341666666264F2B5A416666666649FE234133333333552B5A4100000000ECFD23419A9999196A2B5A4100000000CCFD2341CDCCCC0C712B5A4100000000B6FD2341000000C0752B5A41000000009CFD2341666666267B2B5A419A9999998CFD2341CDCCCC6C7E2B5A41CDCCCCCC78FD234133333373822B5A41CDCCCCCC6AFD2341CDCCCC6C852B5A413333333368FD2341000000C0862B5A410000000067FD234166666606882B5A41	01060000206A080000010000000103000000010000000E0000000000000067FD234166666606882B5A410000000078FD2341000000008D2B5A41CDCCCCCCE7FD234133333393862B5A419A999999310124419A999979622B5A419A999999CC012441000000805B2B5A4100000000CC0124419A999939532B5A41CDCCCCCC80012441333333D3502B5A41666666662A002441666666064C2B5A413333333386FE2341000000C0452B5A416666666649FE234133333333552B5A4100000000ECFD23419A9999196A2B5A41CDCCCCCC6AFD2341CDCCCC6C852B5A410000000067FD234166666606882B5A410000000067FD234166666606882B5A41	01010000206A08000016BF242254FF2341333333D3672B5A41	751124612	H	Picpus 12	7511246	75112	75	11	0
01060000206A080000010000000103000000010000003600000000000000A5FC234166666626AC2B5A4100000000A9FC234100000080AC2B5A41CDCCCCCCB1FC234100000040AD2B5A419A99999917FD2341333333B3B52B5A41CDCCCCCC77FD2341CDCCCC4CBE2B5A4100000000B8FD2341333333B3C32B5A419A999999F3FD2341CDCCCCCCC82B5A41666666663BFE2341000000E0CE2B5A419A999999F6FE2341333333F3DE2B5A41000000001BFF2341666666E6D82B5A413333333327FF23419A9999D9D62B5A41666666666BFF2341000000E0CB2B5A4133333333ACFF23419A999959C12B5A4166666666BFFF234166666666BE2B5A41000000003A002441CDCCCC6CAB2B5A4133333333E600244166666646902B5A4166666666F90024419A9999198D2B5A41CDCCCCCC0A012441000000808A2B5A41333333331301244166666626892B5A41CDCCCCCC1F012441CDCCCC6C862B5A41CDCCCCCC2C012441666666C6832B5A419A9999993401244166666666822B5A41CDCCCCCC41012441333333F37F2B5A416666666650012441666666A67D2B5A4133333333B6012441000000406C2B5A4166666666ED012441CDCCCC2C632B5A4100000000F501244100000000622B5A419A999999DC0124419A9999F95F2B5A41CDCCCCCCD7012441333333735F2B5A419A999999CC012441000000805B2B5A416666666687012441CDCCCCAC5E2B5A419A999999310124419A999979622B5A4100000000D800244133333333662B5A41333333338C00244133333373692B5A41CDCCCCCC680024419A9999F96A2B5A410000000022002441CDCCCC2C6E2B5A41CDCCCCCCA4FF23419A999979732B5A4133333333A8FE2341000000407E2B5A419A9999997DFE234100000020802B5A419A9999996AFE2341000000A0802B5A410000000054FE2341000000A0812B5A413333333314FE234133333393842B5A41CDCCCCCCE7FD234133333393862B5A4133333333CDFD2341333333F3872B5A419A99999996FD2341000000E08A2B5A410000000078FD2341000000008D2B5A41666666665FFD2341000000E08E2B5A416666666649FD2341000000C0902B5A41333333333AFD234100000000922B5A410000000006FD2341666666E6962B5A419A999999FAFC2341000000009A2B5A4100000000B1FC2341666666A6A92B5A4166666666A9FC234100000040AB2B5A4100000000A5FC234166666626AC2B5A41	01060000206A080000010000000103000000010000000D00000000000000A5FC234166666626AC2B5A419A999999F6FE2341333333F3DE2B5A4133333333ACFF23419A999959C12B5A41333333331301244166666626892B5A41CDCCCCCC2C012441666666C6832B5A4100000000F501244100000000622B5A419A999999CC012441000000805B2B5A419A999999310124419A999979622B5A41CDCCCCCCE7FD234133333393862B5A419A99999996FD2341000000E08A2B5A410000000006FD2341666666E6962B5A4100000000A5FC234166666626AC2B5A4100000000A5FC234166666626AC2B5A41	01010000206A080000366B1D58A6FE2341333333D3A12B5A41	751124613	H	Picpus 13	7511246	75112	75	11	0
01060000206A08000001000000010300000001000000340000006666666650012441666666A67D2B5A419A999999880124419A9999B9822B5A41333333335802244100000060962B5A4166666666430324419A999959AC2B5A41CDCCCCCC5203244100000020A92B5A41666666665F0324419A999979A62B5A4166666666740324419A999919A22B5A41666666668A0324419A9999999D2B5A41CDCCCCCC9E03244133333333992B5A4100000000BC032441000000A0922B5A4100000000DC032441CDCCCC6C8B2B5A4166666666FD03244133333333842B5A41333333330204244166666626832B5A41333333330F042441CDCCCC0C802B5A416666666613042441CDCCCC0C7F2B5A41666666665404244133333353712B5A41CDCCCCCC690424419A9999D96C2B5A41000000008F04244166666606652B5A4133333333A004244100000000612B5A4133333333B0042441333333935C2B5A4100000000C404244100000040592B5A41CDCCCCCCA3042441CDCCCC2C582B5A410000000085042441000000E0562B5A41666666667F042441CDCCCCAC562B5A41CDCCCCCC400424419A999959562B5A4166666666A7032441CDCCCC8C552B5A419A9999997B03244100000080552B5A41666666664803244166666646552B5A410000000025032441666666E6542B5A4166666666150324419A9999D9542B5A41CDCCCCCC0C032441CDCCCCCC542B5A4133333333F102244133333353552B5A41CDCCCCCCE1022441000000C0552B5A41CDCCCCCCD30224419A999919562B5A4166666666C1022441000000E0562B5A419A999999AD022441000000A0572B5A4133333333B002244100000080592B5A4166666666B0022441CDCCCC6C5A2B5A41CDCCCCCCAC0224419A9999D95A2B5A413333333397022441000000E05B2B5A413333333389022441666666C65C2B5A419A99999961022441666666865E2B5A41CDCCCCCC220224419A9999D9602B5A41CDCCCCCC1E02244100000020612B5A4100000000120224419A9999F9622B5A41000000000D02244133333393632B5A41000000000A022441CDCCCC8C632B5A4133333333010224419A9999F9622B5A4100000000F501244100000000622B5A4166666666ED012441CDCCCC2C632B5A4133333333B6012441000000406C2B5A416666666650012441666666A67D2B5A41	01060000206A080000010000000103000000010000000D0000006666666650012441666666A67D2B5A4166666666430324419A999959AC2B5A41CDCCCCCC9E03244133333333992B5A416666666613042441CDCCCC0C7F2B5A4100000000C404244100000040592B5A41666666667F042441CDCCCCAC562B5A41CDCCCCCC0C032441CDCCCCCC542B5A419A999999AD022441000000A0572B5A4166666666B0022441CDCCCC6C5A2B5A41CDCCCCCC220224419A9999D9602B5A4100000000F501244100000000622B5A416666666650012441666666A67D2B5A416666666650012441666666A67D2B5A41	01010000206A080000CB409DB0C102244134333363812B5A41	751124614	H	Picpus 14	7511246	75112	75	11	0
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	01010000206A0800009AC38506A919244100000020DF295A41	751124677	D	Bois de Vincennes 2	7511246	75112	75	11	5
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	01060000206A0800000100000001030000000100000014000000CDCCCCCCADF82341666666266F2B5A41CDCCCCCCD8F823419A999919712B5A419A99999911F92341000000A06E2B5A4100000000BCFD2341CDCCCC4C462B5A419A999999E1FD2341000000C0442B5A4133333333B5FE2341CDCCCC0C1D2B5A419A999999F6FE2341CDCCCCEC0F2B5A416666666633FE2341CDCCCC4C072B5A4133333333E0FD2341CDCCCCAC022B5A41CDCCCCCC9DFD234133333353002B5A419A99999997FD2341CDCCCC2CFD2A5A410000000042FD23419A999959F42A5A413333333318FD234133333313F52A5A416666666645FC2341666666C6DF2A5A410000000064FA2341CDCCCCAC292B5A410000000041FA234166666686302B5A4133333333DBF92341CDCCCC4C3E2B5A4166666666F3F823419A9999D9612B5A41CDCCCCCCADF82341666666266F2B5A41CDCCCCCCADF82341666666266F2B5A41	01010000206A08000043A215FE73FC2341666666F6272B5A41	751124702	H	Bercy 2	7511247	75112	75	11	0
01060000206A08000001000000010300000001000000B1000000CDCCCCCCC5FC234133333353552A5A419A999999CAFC2341333333F3552A5A419A999999CCFC23419A999939562A5A4133333333D4FC234133333333572A5A4166666666DDFC234166666666582A5A4100000000E4FC2341CDCCCC4C592A5A4133333333E7FC23419A9999B9592A5A4100000000EAFC23419A9999195A2A5A419A99999903FD2341666666665D2A5A41CDCCCCCC13FD2341666666465F2A5A41CDCCCCCC32FD2341CDCCCCEC632A5A41CDCCCCCC74FD2341666666466D2A5A410000000094FD23419A999999712A5A41CDCCCCCCBAFD234133333333772A5A41CDCCCCCCDBFD2341333333F37B2A5A41CDCCCCCCE5FD2341333333137D2A5A4100000000FDFD23419A9999F97F2A5A419A99999921FE2341666666C6832A5A41333333332CFE2341000000E0842A5A41CDCCCCCC5FFE2341CDCCCC2C8A2A5A41CDCCCCCCA3FE234133333313912A5A4166666666C0FE23419A9999F9932A5A4100000000D2FE2341333333D3952A5A41666666660BFF2341CDCCCCCC9B2A5A41333333330FFF2341666666E69B2A5A416666666613FF2341333333339C2A5A419A99999916FF2341CDCCCCAC9C2A5A413333333318FF23419A9999199D2A5A410000000019FF23419A9999999D2A5A419A99999918FF23419A9999399E2A5A413333333318FF2341333333D39E2A5A416666666615FF23419A9999799F2A5A413333333312FF23419A9999B99F2A5A41CDCCCCCC0DFF23419A9999D99F2A5A41000000000AFF2341CDCCCCEC9F2A5A41CDCCCCCC04FF2341666666E69F2A5A416666666600FF2341333333D39F2A5A41CDCCCCCCFAFE2341000000609F2A5A4133333333DBFE2341000000C0A32A5A4133333333C6FE234166666606A72A5A41666666668BFE2341CDCCCC2CB02A5A413333333359FE2341000000E0B72A5A419A99999923FE234166666606C02A5A4166666666BBFD234100000020D02A5A4100000000B5FD234100000020D12A5A41CDCCCCCC6AFD23419A9999B9DC2A5A41666666665BFD234100000020DF2A5A41CDCCCCCC08FD23419A9999B9EB2A5A4166666666EBFC234133333393F02A5A413333333318FD234133333313F52A5A41000000001CFD234100000080F42A5A41CDCCCCCC23FD23419A9999F9F32A5A41CDCCCCCC2CFD2341CDCCCCACF32A5A416666666633FD2341CDCCCCACF32A5A41666666663AFD2341000000E0F32A5A410000000042FD23419A999959F42A5A419A99999962FD234133333393F72A5A413333333371FD234166666606F92A5A419A99999997FD2341CDCCCC2CFD2A5A41000000009DFD234166666646FE2A5A419A9999999EFD234166666646FF2A5A41CDCCCCCC9DFD234133333353002B5A4100000000A8FD234100000080002B5A4166666666C6FD234100000080012B5A4166666666DDFD2341CDCCCC8C022B5A4133333333E0FD2341CDCCCCAC022B5A416666666633FE2341CDCCCC4C072B5A419A999999F6FE2341CDCCCCEC0F2B5A4133333333B5FE2341CDCCCC0C1D2B5A41333333338AFE2341666666C6242B5A41666666663EFE23419A9999F9322B5A419A999999EFFD2341333333F3412B5A419A999999E1FD2341000000C0442B5A4166666666FCFD234133333333442B5A41000000000BFE234133333333442B5A410000000029FE234166666686442B5A410000000073FE234166666686452B5A413333333386FE2341000000C0452B5A410000000094FE23419A999979422B5A4166666666B6FE2341333333933C2B5A41CDCCCCCC00FF23419A9999F9302B5A41CDCCCCCC6BFF23419A9999D91F2B5A41333333339BFF234133333373182B5A419A999999A4FF2341CDCCCCCC162B5A4100000000B1FF23419A999979142B5A419A999999C8FF2341CDCCCC2C0F2B5A4133333333CFFF23419A9999B90D2B5A4100000000DAFF2341000000200B2B5A41CDCCCCCC050024419A999939FF2A5A4133333333320024419A9999B9F42A5A41333333338B00244100000020DE2A5A419A999999E3002441000000E0CF2A5A41666666661301244133333333C72A5A4133333333390124419A9999B9C02A5A419A9999995501244166666686BC2A5A410000000061012441CDCCCC0CBB2A5A410000000074012441666666A6B82A5A4100000000BE01244166666686AF2A5A41CDCCCCCC1C022441CDCCCC6CA32A5A4100000000AE022441666666C6912A5A41CDCCCCCCE9022441000000808A2A5A419A99999901032441CDCCCC4C872A5A419A9999991F032441333333B3832A5A41333333332403244100000020832A5A41333333333003244166666686812A5A41333333333B0324419A9999F97F2A5A413333333348032441333333737E2A5A419A999999500324419A9999997D2A5A419A99999962032441CDCCCCAC7B2A5A410000000062032441000000A07B2A5A419A99999950032441333333337A2A5A41333333333C03244133333393782A5A419A99999928032441333333F3762A5A4166666666130324419A999939752A5A413333333301032441CDCCCCCC732A5A4133333333EB02244166666606722A5A4166666666D50224419A999959702A5A4166666666C0022441000000C06E2A5A4166666666AC022441666666466D2A5A419A99999999022441333333F36B2A5A416666666685022441000000A06A2A5A41666666666C0224419A9999F9682A5A41CDCCCCCC51022441CDCCCC4C672A5A41CDCCCCCC37022441000000C0652A5A41000000002002244100000060642A5A419A99999906022441333333F3622A5A4133333333EC01244166666686612A5A419A999999CE01244166666606602A5A41CDCCCCCCB6012441CDCCCCEC5E2A5A419A999999A8012441333333535E2A5A41333333339A0124419A9999B95D2A5A41CDCCCCCC8B012441000000205D2A5A41333333337C012441333333735C2A5A41000000006F012441333333F35B2A5A41CDCCCCCC62012441333333735B2A5A41CDCCCCCC47012441CDCCCC6C5A2A5A416666666629012441CDCCCC2C592A5A41CDCCCCCC0B01244133333313582A5A4133333333EF002441333333F3562A5A419A999999D20024419A9999D9552A5A4133333333B5002441333333B3542A5A413333333399002441000000A0532A5A41CDCCCCCC7D00244133333393522A5A41666666666200244166666686512A5A41CDCCCCCC45002441CDCCCC6C502A5A41CDCCCCCC2A002441CDCCCC4C4F2A5A416666666610002441CDCCCC2C4E2A5A41CDCCCCCCF7FF2341CDCCCCEC4C2A5A4100000000E1FF2341333333B34B2A5A4100000000CDFF23419A9999794A2A5A4100000000B2FF23419A9999B9482A5A41666666669AFF23419A999919472A5A41000000007EFF234166666606452A5A41666666665FFF2341000000C0422A5A413333333343FF2341CDCCCC8C402A5A416666666629FF2341CDCCCC8C3E2A5A419A99999911FF2341333333B33C2A5A4133333333F8FE2341CDCCCCCC3A2A5A41CDCCCCCCDFFE2341CDCCCCEC382A5A4100000000C7FE234100000000372A5A419A999999A9FE2341000000C0342A5A41CDCCCCCC8EFE23419A999999322A5A410000000074FE234166666686302A5A410000000057FE23419A9999592E2A5A419A9999993BFE2341666666262C2A5A419A9999991EFE2341666666C6292A5A410000000001FE234166666646272A5A41CDCCCCCCE6FD2341CDCCCC0C252A5A4100000000DEFD234166666646242A5A41CDCCCCCCC2FD2341666666E6292A5A41CDCCCCCC6EFD23419A9999F93B2A5A41333333332FFD234166666646492A5A416666666622FD2341CDCCCC6C4A2A5A413333333302FD2341666666664C2A5A41CDCCCCCCD6FC234100000060542A5A4133333333D6FC234166666666542A5A41CDCCCCCCC5FC234133333353552A5A41	01060000206A0800000100000001030000000100000026000000CDCCCCCCC5FC234133333353552A5A41CDCCCCCC13FD2341666666465F2A5A41CDCCCCCCDBFD2341333333F37B2A5A4100000000FDFD23419A9999F97F2A5A4166666666C0FE23419A9999F9932A5A410000000019FF23419A9999999D2A5A4133333333DBFE2341000000C0A32A5A4166666666EBFC234133333393F02A5A413333333318FD234133333313F52A5A410000000042FD23419A999959F42A5A419A99999997FD2341CDCCCC2CFD2A5A41CDCCCCCC9DFD234133333353002B5A4133333333E0FD2341CDCCCCAC022B5A416666666633FE2341CDCCCC4C072B5A419A999999F6FE2341CDCCCCEC0F2B5A4133333333B5FE2341CDCCCC0C1D2B5A419A999999E1FD2341000000C0442B5A4166666666FCFD234133333333442B5A413333333386FE2341000000C0452B5A4166666666B6FE2341333333933C2B5A41333333339BFF234133333373182B5A4100000000DAFF2341000000200B2B5A41333333338B00244100000020DE2A5A419A9999995501244166666686BC2A5A41CDCCCCCC1C022441CDCCCC6CA32A5A419A99999962032441CDCCCCAC7B2A5A419A99999999022441333333F36B2A5A419A999999CE01244166666606602A5A41333333337C012441333333735C2A5A41CDCCCCCC45002441CDCCCC6C502A5A4100000000E1FF2341333333B34B2A5A41666666665FFF2341000000C0422A5A410000000057FE23419A9999592E2A5A4100000000DEFD234166666646242A5A41333333332FFD234166666646492A5A413333333302FD2341666666664C2A5A41CDCCCCCCC5FC234133333353552A5A41CDCCCCCCC5FC234133333353552A5A41	01010000206A080000A0D646E70500244166666606B42A5A41	751124703	H	Bercy 3	7511247	75112	75	11	0
01060000206A08000001000000010300000001000000360000009A999999BDFB2341CDCCCCACA42B5A4100000000CBFB2341CDCCCCACA52B5A4133333333DCFB2341000000E0A62B5A4100000000ECFB234100000000A82B5A413333333314FC23419A9999F9AA2B5A419A9999991EFC2341000000E0AB2B5A413333333339FC23419A999959A92B5A419A9999995CFC234133333313A62B5A419A999999BAFC2341000000A09D2B5A410000000006FD2341666666E6962B5A41333333333AFD234100000000922B5A416666666649FD2341000000C0902B5A41666666665FFD2341000000E08E2B5A410000000078FD2341000000008D2B5A416666666673FD23419A9999D98B2B5A41000000006EFD2341CDCCCCAC8A2B5A41666666666BFD2341000000008A2B5A416666666668FD234100000020892B5A410000000067FD234166666606882B5A413333333368FD2341000000C0862B5A41CDCCCCCC6AFD2341CDCCCC6C852B5A41CDCCCCCC78FD234133333373822B5A419A9999998CFD2341CDCCCC6C7E2B5A41000000009CFD2341666666267B2B5A4100000000B6FD2341000000C0752B5A4100000000CCFD2341CDCCCC0C712B5A4100000000ECFD23419A9999196A2B5A416666666649FE234133333333552B5A419A99999961FE2341666666264F2B5A413333333386FE2341000000C0452B5A410000000073FE234166666686452B5A410000000029FE234166666686442B5A41000000000BFE234133333333442B5A4166666666FCFD234133333333442B5A419A999999E1FD2341000000C0442B5A4133333333D6FD23419A999919472B5A4133333333BEFD2341666666E64B2B5A41CDCCCCCCABFD2341333333534F2B5A419A9999995AFD2341666666E65E2B5A410000000039FD234166666686652B5A41333333330AFD2341000000A06E2B5A419A999999F9FC2341666666A6712B5A4100000000DCFC234133333393772B5A4133333333B3FC2341666666E67E2B5A41CDCCCCCC99FC2341CDCCCC6C832B5A413333333372FC2341CDCCCC0C8B2B5A41CDCCCCCC46FC2341333333B3932B5A410000000025FC2341333333539A2B5A413333333318FC23419A9999599C2B5A41333333330AFC2341666666E69D2B5A410000000000FC2341333333D39E2B5A41CDCCCCCCF4FB23419A9999D99F2B5A4100000000CEFB234133333333A32B5A419A999999BDFB2341CDCCCCACA42B5A41	01060000206A080000010000000103000000010000000F0000009A999999BDFB2341CDCCCCACA42B5A419A9999991EFC2341000000E0AB2B5A41333333333AFD234100000000922B5A410000000078FD2341000000008D2B5A41CDCCCCCC6AFD2341CDCCCC6C852B5A4100000000ECFD23419A9999196A2B5A416666666649FE234133333333552B5A413333333386FE2341000000C0452B5A4166666666FCFD234133333333442B5A419A999999E1FD2341000000C0442B5A4100000000DCFC234133333393772B5A41CDCCCCCC99FC2341CDCCCC6C832B5A410000000025FC2341333333539A2B5A419A999999BDFB2341CDCCCCACA42B5A419A999999BDFB2341CDCCCCACA42B5A41	01010000206A08000034B038533BFD2341CCCCCC5C792B5A41	751124704	H	Bercy 4	7511247	75112	75	11	0
01060000206A080000010000000103000000010000005D0000003333333333F72341666666869E2B5A416666666646F72341CDCCCC2CA12B5A416666666655F7234100000000A32B5A410000000065F7234133333393A42B5A4100000000F8F72341CDCCCC2CB12B5A41CDCCCCCC85F8234133333373BD2B5A41CDCCCCCC9DF82341CDCCCCECBE2B5A419A99999925F9234100000040C82B5A41333333331EFA234133333373D92B5A41000000002BFA234100000040DA2B5A413333333336FA23419A999919DB2B5A41000000003DFA23419A999999DB2B5A413333333364FA234100000080DE2B5A4100000000ABFA234133333393E32B5A41CDCCCCCCC9FA23419A9999B9E52B5A41CDCCCCCCF5FA2341CDCCCCCCE82B5A410000000004FB234100000060E92B5A41CDCCCCCC33FB234100000000EA2B5A419A9999993CFB23419A9999F9E72B5A419A99999949FB2341333333B3E62B5A41000000005EFB234166666686E32B5A413333333385FB234133333353DD2B5A419A9999998CFB234100000040DC2B5A4100000000B3FB2341666666E6D52B5A419A999999C1FB2341CDCCCCACD32B5A419A999999CDFB2341CDCCCCCCD12B5A41CDCCCCCC07FC234166666666C82B5A41000000003EFC2341333333F3BF2B5A419A99999952FC2341666666C6BC2B5A419A9999999BFC2341CDCCCC0CAE2B5A419A999999A1FC2341333333D3AC2B5A4100000000A5FC234166666626AC2B5A4166666666A9FC234100000040AB2B5A4100000000B1FC2341666666A6A92B5A419A999999FAFC2341000000009A2B5A410000000006FD2341666666E6962B5A419A999999BAFC2341000000A09D2B5A419A9999995CFC234133333313A62B5A413333333339FC23419A999959A92B5A419A9999991EFC2341000000E0AB2B5A413333333314FC23419A9999F9AA2B5A4100000000ECFB234100000000A82B5A4133333333DCFB2341000000E0A62B5A4100000000CBFB2341CDCCCCACA52B5A419A999999BDFB2341CDCCCCACA42B5A4100000000CEFB234133333333A32B5A41CDCCCCCCF4FB23419A9999D99F2B5A410000000000FC2341333333D39E2B5A41333333330AFC2341666666E69D2B5A413333333318FC23419A9999599C2B5A410000000025FC2341333333539A2B5A41CDCCCCCC46FC2341333333B3932B5A413333333372FC2341CDCCCC0C8B2B5A41CDCCCCCC99FC2341CDCCCC6C832B5A4133333333B3FC2341666666E67E2B5A4100000000DCFC234133333393772B5A419A999999F9FC2341666666A6712B5A41333333330AFD2341000000A06E2B5A410000000039FD234166666686652B5A419A9999995AFD2341666666E65E2B5A41CDCCCCCCABFD2341333333534F2B5A4133333333BEFD2341666666E64B2B5A4133333333D6FD23419A999919472B5A419A999999E1FD2341000000C0442B5A4100000000BCFD2341CDCCCC4C462B5A41CDCCCCCC74FD2341CDCCCCAC482B5A41CDCCCCCCF6FB234133333393552B5A4166666666ECFA2341CDCCCCAC5E2B5A4100000000C3FA234100000020602B5A41CDCCCCCCA6FA234100000020612B5A41CDCCCCCC91FA2341000000C0612B5A416666666678FA234166666686622B5A419A9999991DFA2341333333B3652B5A419A99999906FA234133333373662B5A41666666669BF92341CDCCCC0C6A2B5A416666666677F92341333333536B2B5A41CDCCCCCC64F92341CDCCCCEC6B2B5A419A99999911F92341000000A06E2B5A413333333304F923419A9999D96F2B5A41CDCCCCCCD8F823419A999919712B5A41CDCCCCCCCEF8234133333313712B5A4166666666C3F82341CDCCCCAC702B5A4133333333B9F8234100000000702B5A41CDCCCCCCADF82341666666266F2B5A416666666692F82341333333B3722B5A419A99999989F8234100000000732B5A413333333378F8234166666686752B5A419A99999947F82341CDCCCC6C7C2B5A4100000000ECF7234166666606892B5A4166666666D5F72341666666468C2B5A4100000000D5F72341666666C68D2B5A4166666666C5F72341333333938F2B5A413333333333F72341666666869E2B5A41	01060000206A08000001000000010300000001000000180000003333333333F72341666666869E2B5A410000000065F7234133333393A42B5A41CDCCCCCC85F8234133333373BD2B5A41333333331EFA234133333373D92B5A41CDCCCCCCF5FA2341CDCCCCCCE82B5A41CDCCCCCC33FB234100000000EA2B5A419A99999952FC2341666666C6BC2B5A4100000000B1FC2341666666A6A92B5A410000000006FD2341666666E6962B5A419A9999991EFC2341000000E0AB2B5A419A999999BDFB2341CDCCCCACA42B5A410000000025FC2341333333539A2B5A41CDCCCCCC99FC2341CDCCCC6C832B5A4100000000DCFC234133333393772B5A419A999999E1FD2341000000C0442B5A4100000000BCFD2341CDCCCC4C462B5A419A99999911F92341000000A06E2B5A41CDCCCCCCD8F823419A999919712B5A41CDCCCCCCADF82341666666266F2B5A419A99999989F8234100000000732B5A4166666666D5F72341666666468C2B5A4166666666C5F72341333333938F2B5A413333333333F72341666666869E2B5A413333333333F72341666666869E2B5A41	01010000206A080000739F6896CEF9234133333373982B5A41	751124705	H	Bercy 5	7511247	75112	75	11	0
01060000206A080000010000000103000000010000004A0000000000000097FB23419A999999842A5A4133333333A1FB2341000000E0852A5A4100000000C1FB2341000000E0892A5A419A999999D3FB2341CDCCCC2C8C2A5A41CDCCCCCC0AFC2341333333F3922A5A41666666662CFC234133333393972A5A419A99999946FC2341CDCCCC2C9B2A5A419A99999948FC2341CDCCCC6C9B2A5A419A99999958FC23419A9999B99D2A5A419A99999967FC234166666606A02A5A413333333377FC2341CDCCCC6CA22A5A419A99999984FC234100000040A42A5A4166666666CCFC234166666606AE2A5A419A999999C5FC2341CDCCCC0CB02A5A41CDCCCCCCFDFC2341CDCCCC0CB72A5A41CDCCCCCC33FD2341666666C6BD2A5A41666666663AFD234166666646BE2A5A410000000052FD234133333373C12A5A419A9999998BFD234133333313B82A5A41CDCCCCCCD9FD234133333373AB2A5A413333333329FE234166666606B32A5A413333333359FE2341000000E0B72A5A41666666668BFE2341CDCCCC2CB02A5A4133333333C6FE234166666606A72A5A4133333333DBFE2341000000C0A32A5A41CDCCCCCCFAFE2341000000609F2A5A416666666600FF2341333333D39F2A5A41CDCCCCCC04FF2341666666E69F2A5A41000000000AFF2341CDCCCCEC9F2A5A41CDCCCCCC0DFF23419A9999D99F2A5A413333333312FF23419A9999B99F2A5A416666666615FF23419A9999799F2A5A413333333318FF2341333333D39E2A5A419A99999918FF23419A9999399E2A5A410000000019FF23419A9999999D2A5A413333333318FF23419A9999199D2A5A419A99999916FF2341CDCCCCAC9C2A5A416666666613FF2341333333339C2A5A41333333330FFF2341666666E69B2A5A41666666660BFF2341CDCCCCCC9B2A5A4100000000D2FE2341333333D3952A5A4166666666C0FE23419A9999F9932A5A41CDCCCCCCA3FE234133333313912A5A41CDCCCCCC5FFE2341CDCCCC2C8A2A5A41333333332CFE2341000000E0842A5A419A99999921FE2341666666C6832A5A4100000000FDFD23419A9999F97F2A5A41CDCCCCCCE5FD2341333333137D2A5A41CDCCCCCCDBFD2341333333F37B2A5A41CDCCCCCCBAFD234133333333772A5A410000000094FD23419A999999712A5A41CDCCCCCC74FD2341666666466D2A5A41CDCCCCCC32FD2341CDCCCCEC632A5A41CDCCCCCC13FD2341666666465F2A5A419A99999903FD2341666666665D2A5A4100000000EAFC23419A9999195A2A5A4133333333E7FC23419A9999B9592A5A4100000000E4FC2341CDCCCC4C592A5A4166666666DDFC234166666666582A5A4133333333D4FC234133333333572A5A419A999999CCFC23419A999939562A5A419A999999CAFC2341333333F3552A5A41CDCCCCCCC5FC234133333353552A5A4166666666ADFC23419A9999F9592A5A41CDCCCCCC9BFC23419A9999B95D2A5A416666666691FC2341666666665F2A5A416666666672FC23419A999919642A5A41CDCCCCCC41FC2341333333336B2A5A41000000001CFC2341000000E0702A5A419A999999F8FB2341CDCCCCEC752A5A4133333333D3FB2341000000807B2A5A41CDCCCCCCB6FB2341CDCCCCCC7F2A5A4100000000B0FB2341333333D3802A5A410000000097FB23419A999999842A5A41	01060000206A08000001000000010300000001000000110000000000000097FB23419A999999842A5A41CDCCCCCC0AFC2341333333F3922A5A4166666666CCFC234166666606AE2A5A419A999999C5FC2341CDCCCC0CB02A5A410000000052FD234133333373C12A5A41CDCCCCCCD9FD234133333373AB2A5A413333333359FE2341000000E0B72A5A41CDCCCCCCFAFE2341000000609F2A5A410000000019FF23419A9999999D2A5A4166666666C0FE23419A9999F9932A5A4100000000FDFD23419A9999F97F2A5A41CDCCCCCCDBFD2341333333F37B2A5A41CDCCCCCC13FD2341666666465F2A5A41CDCCCCCCC5FC234133333353552A5A41CDCCCCCC9BFC23419A9999B95D2A5A410000000097FB23419A999999842A5A410000000097FB23419A999999842A5A41	01010000206A080000BDD284951AFD2341CDCCCC2C8B2A5A41	751124706	A	Bercy 6	7511247	75112	75	11	0
01060000206A0800000100000001030000000100000029000000CDCCCCCCA9F52341CDCCCC8C792B5A4133333333BFF52341000000207B2B5A41CDCCCCCCF4F52341CDCCCC4C802B5A41666666664EF623419A9999D9882B5A4166666666A6F62341CDCCCC2C912B5A413333333319F723419A9999F99B2B5A413333333333F72341666666869E2B5A4166666666C5F72341333333938F2B5A4100000000D5F72341666666C68D2B5A4166666666D5F72341666666468C2B5A4100000000ECF7234166666606892B5A419A99999947F82341CDCCCC6C7C2B5A413333333378F8234166666686752B5A419A99999989F8234100000000732B5A416666666692F82341333333B3722B5A41CDCCCCCCADF82341666666266F2B5A413333333398F82341666666666D2B5A410000000088F823419A9999196C2B5A419A9999994CF8234166666646662B5A4133333333F5F72341333333735D2B5A41333333337AF72341333333F3502B5A416666666632F723419A9999D9492B5A419A99999914F72341333333D3462B5A410000000007F723419A999959452B5A4166666666F7F62341333333B3432B5A4100000000E6F62341333333F3412B5A4166666666D1F6234100000040462B5A41CDCCCCCCC8F6234166666686472B5A4133333333B9F623419A9999F9492B5A4166666666B8F62341000000204A2B5A413333333360F62341CDCCCC4C412B5A419A99999951F62341333333D3432B5A410000000042F6234166666646462B5A41666666669AF62341333333334F2B5A416666666699F62341000000604F2B5A41CDCCCCCC7BF62341CDCCCC6C542B5A41333333334CF62341000000C05C2B5A416666666602F62341333333336A2B5A41CDCCCCCCDAF5234166666606712B5A4133333333B2F5234100000020782B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCA9F52341CDCCCC8C792B5A4133333333BFF52341000000207B2B5A413333333333F72341666666869E2B5A4166666666C5F72341333333938F2B5A4166666666D5F72341666666468C2B5A419A99999989F8234100000000732B5A41CDCCCCCCADF82341666666266F2B5A419A9999994CF8234166666646662B5A4100000000E6F62341333333F3412B5A4166666666B8F62341000000204A2B5A413333333360F62341CDCCCC4C412B5A410000000042F6234166666646462B5A41666666669AF62341333333334F2B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41	01010000206A0800006ED6DD6643F7234166666616702B5A41	751124707	A	Bercy 7	7511247	75112	75	11	0
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	01060000206A080000020000000103000000010000001A000000CDCCCCCCE6FD2341CDCCCC0C252A5A410000000057FE23419A9999592E2A5A41666666665FFF2341000000C0422A5A4100000000E1FF2341333333B34B2A5A41CDCCCCCC45002441CDCCCC6C502A5A41333333337C012441333333735C2A5A419A999999CE01244166666606602A5A419A99999999022441333333F36B2A5A419A99999962032441CDCCCCAC7B2A5A41CDCCCCCC3D0424419A999939612A5A410000000031052441666666E6412A5A41666666665C052441333333F33C2A5A41CDCCCCCC3805244166666646342A5A416666666680042441666666E6282A5A41666666662C04244166666666242A5A41666666666B032441333333531C2A5A419A999999D0022441333333D3142A5A413333333329022441666666E60B2A5A4133333333600124419A9999D9062A5A41333333336CFF2341666666E6DE295A419A9999995EFF23419A9999B9E3295A41CDCCCCCC15FF2341CDCCCC8CEF295A419A999999C2FE2341000000A0F9295A413333333313FE234166666686132A5A41CDCCCCCCE6FD2341CDCCCC0C252A5A41CDCCCCCCE6FD2341CDCCCC0C252A5A410103000000010000001800000066666666F7F62341333333B3432B5A419A9999994CF8234166666646662B5A41CDCCCCCCADF82341666666266F2B5A4166666666F3F823419A9999D9612B5A4133333333DBF92341CDCCCC4C3E2B5A410000000041FA234166666686302B5A410000000064FA2341CDCCCCAC292B5A41666666660AFB234100000000102B5A4133333333A3FA23419A999979042B5A419A999999C3FB234133333393D82A5A41CDCCCCCCC3FC2341CDCCCCACB02A5A4166666666CCFC234166666606AE2A5A41CDCCCCCC0AFC2341333333F3922A5A410000000097FB23419A999999842A5A41CDCCCCCC12FB234166666666982A5A4133333333B9F9234133333333CD2A5A41666666665BF92341333333F3D72A5A419A99999941F923419A9999F9DF2A5A416666666613F82341000000C00D2B5A41CDCCCCCCB1F7234133333373212B5A419A99999927F7234166666626392B5A4100000000E6F62341333333F3412B5A4166666666F7F62341333333B3432B5A4166666666F7F62341333333B3432B5A41	01010000206A080000B2E0EB6988012441000000402D2A5A41	751124708	D	Jardin de Bercy	7511247	75112	75	11	1
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	01060000206A0800000100000001030000000100000022000000CDCCCCCCE8F423419A999959692B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41666666669AF62341333333334F2B5A410000000042F6234166666646462B5A413333333360F62341CDCCCC4C412B5A4166666666B8F62341000000204A2B5A4100000000E6F62341333333F3412B5A419A99999927F7234166666626392B5A41CDCCCCCCB1F7234133333373212B5A416666666613F82341000000C00D2B5A419A99999941F923419A9999F9DF2A5A41666666665BF92341333333F3D72A5A4133333333B9F9234133333333CD2A5A41CDCCCCCC12FB234166666666982A5A41CDCCCCCC9BFC23419A9999B95D2A5A41CDCCCCCCC5FC234133333353552A5A413333333302FD2341666666664C2A5A41333333332FFD234166666646492A5A419A999999F2FD2341CDCCCC0C202A5A413333333313FE234166666686132A5A419A999999C2FE2341000000A0F9295A41CDCCCCCC15FF2341CDCCCC8CEF295A419A9999995EFF23419A9999B9E3295A41333333336CFF2341666666E6DE295A4166666666EAFE234100000020D4295A413333333307FE234133333393F1295A413333333341FD234133333313112A5A419A999999A3FB234133333353552A5A41CDCCCCCCC2F92341CDCCCCEC9D2A5A41CDCCCCCC42F82341CDCCCC2CD92A5A419A99999989F623419A999979212B5A419A99999988F52341CDCCCC8C512B5A41CDCCCCCCE8F423419A999959692B5A41CDCCCCCCE8F423419A999959692B5A41	01010000206A0800004876F3401CFA234133333333A72A5A41	751124799	D	Seine et Berges	7511247	75112	75	11	0
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	01060000206A08000001000000010300000001000000140000009A99999900F32341333333F3C92C5A416666666617F323419A9999D9D22C5A419A999999B9F32341666666E6D52C5A41333333331CF42341666666E6C22C5A419A999999E6F42341666666069F2C5A413333333366F523419A9999198A2C5A4100000000B4F42341333333535C2C5A419A999999D7F5234100000060412C5A4100000000C3F52341666666C63B2C5A4100000000C4F52341666666C6242C5A41CDCCCCCCB4F42341333333B31D2C5A41CDCCCCCC5FF4234100000000432C5A419A99999904F423419A999919692C5A4100000000E3F323419A999919792C5A419A99999971F3234166666666AB2C5A416666666650F32341000000E0B52C5A41000000003AF3234166666626B92C5A416666666612F3234133333353C92C5A419A99999900F32341333333F3C92C5A419A99999900F32341333333F3C92C5A41	01010000206A080000471E103A84F42341000000B0792C5A41	751124805	H	Quinze-Vingts 5	7511248	75112	75	11	0
01060000206A080000010000000103000000010000002B00000000000000B4F42341333333535C2C5A41CDCCCCCCC1F423419A9999995F2C5A4100000000D2F42341CDCCCCCC632C5A4100000000E9F42341333333F3692C5A4166666666F6F42341333333936D2C5A419A999999FEF423419A9999B96F2C5A416666666609F52341CDCCCC8C722C5A413333333329F52341666666467A2C5A419A99999947F5234100000080822C5A413333333366F523419A9999198A2C5A41CDCCCCCCB9F52341CDCCCC2C7C2C5A4166666666D2F52341333333B3772C5A4133333333F5F52341666666E6712C5A41CDCCCCCC04F62341000000606F2C5A410000000018F623419A9999596C2C5A419A9999994BF62341000000E0622C5A416666666652F6234100000000612C5A41CDCCCCCC63F62341333333D35D2C5A41666666666DF623419A9999595C2C5A41CDCCCCCCBAF62341CDCCCCCC532C5A4100000000D9F623419A999959502C5A41CDCCCCCC00F72341333333134C2C5A4133333333EEF62341CDCCCCEC462C5A419A999999D9F623419A999939412C5A4166666666C4F62341CDCCCC8C3B2C5A4133333333B5F62341666666C6362C5A419A999999A6F623419A9999D9322C5A419A9999999AF62341666666462F2C5A416666666694F62341000000802D2C5A41CDCCCCCC83F623419A9999592A2C5A413333333352F62341666666E6282C5A41CDCCCCCC1BF623419A999959272C5A4100000000C4F52341666666C6242C5A4166666666C4F5234133333333272C5A4100000000C3F52341666666C63B2C5A4100000000C0F523419A9999393D2C5A4100000000CFF523419A9999D93F2C5A419A999999D7F5234100000060412C5A4100000000C2F5234166666646432C5A416666666662F52341000000204C2C5A419A9999992DF5234100000000512C5A419A99999907F52341CDCCCCAC542C5A4100000000B4F42341333333535C2C5A41	01060000206A080000010000000103000000010000000C00000000000000B4F42341333333535C2C5A413333333366F523419A9999198A2C5A410000000018F623419A9999596C2C5A41666666666DF623419A9999595C2C5A41CDCCCCCC00F72341333333134C2C5A416666666694F62341000000802D2C5A41CDCCCCCC83F623419A9999592A2C5A4100000000C4F52341666666C6242C5A4100000000C3F52341666666C63B2C5A419A999999D7F5234100000060412C5A4100000000B4F42341333333535C2C5A4100000000B4F42341333333535C2C5A41	01010000206A080000B0A1BC06B7F5234100000080582C5A41	751124806	H	Quinze-Vingts 6	7511248	75112	75	11	0
01060000206A08000001000000010300000001000000380000009A999999BDF323419A999999D52C5A4100000000DEF3234166666646D32C5A41CDCCCCCC28F423419A999919CA2C5A41CDCCCCCC49F4234133333353C62C5A41CDCCCCCC4EF42341000000E0C52C5A410000000093F423419A999999BF2C5A41CDCCCCCCBDF4234133333393BC2C5A419A999999EAF42341333333F3B92C5A419A999999EFF42341333333B3B92C5A413333333315F523419A9999B9B72C5A41000000003FF5234166666666B52C5A41333333336BF5234166666606B32C5A413333333391F5234166666606B12C5A4166666666B6F52341CDCCCC0CAF2C5A4133333333C5F5234100000040AE2C5A41CDCCCCCC24F6234133333393A92C5A413333333352F623419A999939A72C5A41666666665FF6234133333393A62C5A416666666680F623419A9999F9A42C5A41CDCCCCCCA9F623419A9999F9A22C5A4133333333BBF6234100000020A22C5A41333333331AF72341CDCCCC0C9E2C5A419A99999974F723419A9999B9992C5A4100000000B9F72341CDCCCC6C962C5A4100000000D1F7234166666646952C5A419A999999F4F72341CDCCCC8C932C5A41666666660DF8234133333353922C5A41CDCCCCCC97F7234100000020732C5A419A99999947F72341000000E05D2C5A41CDCCCCCC18F72341666666C6512C5A419A99999907F72341333333F3502C5A416666666608F72341666666864F2C5A419A99999905F723419A9999194E2C5A41CDCCCCCC00F72341333333134C2C5A4100000000D9F623419A999959502C5A41CDCCCCCCBAF62341CDCCCCCC532C5A41666666666DF623419A9999595C2C5A41CDCCCCCC63F62341333333D35D2C5A416666666652F6234100000000612C5A419A9999994BF62341000000E0622C5A410000000018F623419A9999596C2C5A41CDCCCCCC04F62341000000606F2C5A4133333333F5F52341666666E6712C5A4166666666D2F52341333333B3772C5A41CDCCCCCCB9F52341CDCCCC2C7C2C5A413333333366F523419A9999198A2C5A413333333345F52341CDCCCC8C8F2C5A410000000024F52341666666E6942C5A419A999999E6F42341666666069F2C5A4100000000B4F4234166666646A82C5A41000000008CF4234133333353AF2C5A416666666671F4234100000020B42C5A413333333366F4234166666606B62C5A41333333331CF42341666666E6C22C5A416666666600F42341000000C0C82C5A419A999999BDF323419A999999D52C5A41	01060000206A08000001000000010300000001000000110000009A999999BDF323419A999999D52C5A4100000000DEF3234166666646D32C5A41CDCCCCCC49F4234133333353C62C5A410000000093F423419A999999BF2C5A419A999999EAF42341333333F3B92C5A4133333333C5F5234100000040AE2C5A4133333333BBF6234100000020A22C5A41333333331AF72341CDCCCC0C9E2C5A41666666660DF8234133333353922C5A41CDCCCCCC18F72341666666C6512C5A41CDCCCCCC00F72341333333134C2C5A41666666666DF623419A9999595C2C5A410000000018F623419A9999596C2C5A419A999999E6F42341666666069F2C5A41333333331CF42341666666E6C22C5A419A999999BDF323419A999999D52C5A419A999999BDF323419A999999D52C5A41	01010000206A08000054CB4461A2F62341000000F0902C5A41	751124807	H	Quinze-Vingts 7	7511248	75112	75	11	0
01060000206A080000010000000103000000010000002E000000CDCCCCCCB4F42341333333B31D2C5A4166666666E9F42341000000201F2C5A419A99999955F5234133333313222C5A4100000000C4F52341666666C6242C5A41CDCCCCCC1BF623419A999959272C5A413333333352F62341666666E6282C5A41CDCCCCCC83F623419A9999592A2C5A416666666694F62341000000802D2C5A419A9999999AF62341666666462F2C5A419A999999A6F623419A9999D9322C5A4133333333B5F62341666666C6362C5A4166666666C4F62341CDCCCC8C3B2C5A419A999999D9F623419A999939412C5A4133333333EEF62341CDCCCCEC462C5A41CDCCCCCC00F72341333333134C2C5A41666666665BF72341666666A6412C5A41333333337AF723419A9999193E2C5A41333333339FF72341666666A6392C5A41CDCCCCCCC3F7234100000060352C5A4133333333FBF723419A9999D92E2C5A419A9999993DF8234166666606262C5A416666666655F82341CDCCCCCC222C5A419A99999976F82341666666661E2C5A41CDCCCCCC8FF82341000000E01A2C5A419A999999ADF8234133333393162C5A410000000049F82341000000A0142C5A41CDCCCCCCF9F723419A9999F9122C5A419A999999D5F723419A999919122C5A4166666666C0F723419A999979112C5A41666666663AF723419A9999190F2C5A41666666662BF72341333333D30E2C5A419A999999FAF62341666666E60D2C5A4100000000DDF62341000000600D2C5A4133333333CFF62341000000200D2C5A41333333330FF623419A999939092C5A41CDCCCCCCF3F52341CDCCCC8C062C5A419A999999CDF52341CDCCCCCC052C5A41333333337FF5234166666646042C5A416666666614F5234166666646022C5A416666666612F52341CDCCCCCC032C5A41CDCCCCCC05F523419A999919042C5A4100000000FBF42341666666E6042C5A419A999999F3F42341666666C6052C5A4100000000EEF42341333333D3062C5A419A999999E4F423419A999939082C5A41CDCCCCCCB4F42341333333B31D2C5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCB4F42341333333B31D2C5A4100000000C4F52341666666C6242C5A41CDCCCCCC83F623419A9999592A2C5A416666666694F62341000000802D2C5A41CDCCCCCC00F72341333333134C2C5A4133333333FBF723419A9999D92E2C5A419A999999ADF8234133333393162C5A4166666666C0F723419A999979112C5A4133333333CFF62341000000200D2C5A41333333330FF623419A999939092C5A41CDCCCCCCF3F52341CDCCCC8C062C5A416666666614F5234166666646022C5A419A999999E4F423419A999939082C5A41CDCCCCCCB4F42341333333B31D2C5A41CDCCCCCCB4F42341333333B31D2C5A41	01010000206A080000C69DB9E91EF72341000000B0262C5A41	751124808	H	Quinze-Vingts 8	7511248	75112	75	11	0
01060000206A080000010000000103000000010000002D000000CDCCCCCC00F72341333333134C2C5A419A99999905F723419A9999194E2C5A416666666608F72341666666864F2C5A419A99999907F72341333333F3502C5A41CDCCCCCC18F72341666666C6512C5A419A99999947F72341000000E05D2C5A41CDCCCCCC97F7234100000020732C5A41666666660DF8234133333353922C5A41333333337BF82341666666068D2C5A41000000009FF82341CDCCCC4C8B2C5A4100000000ADF82341666666C68A2C5A4100000000F5F82341666666C6882C5A41CDCCCCCCC3F82341666666267D2C5A413333333351F8234166666686622C5A419A9999996DF82341000000A0602C5A419A99999975F8234100000020602C5A41CDCCCCCC7BF82341333333935F2C5A416666666682F82341CDCCCCEC5E2C5A410000000089F82341000000405E2C5A419A9999998EF82341000000805D2C5A416666666693F823419A9999995C2C5A419A99999996F823419A9999D95B2C5A41000000009AF82341666666C65A2C5A41666666669BF82341000000E0592C5A41CDCCCCCC9BF8234166666666582C5A41000000009AF823419A999919572C5A41CDCCCCCC96F82341333333F3552C5A416666666693F82341CDCCCC2C552C5A41CDCCCCCC8AF823419A9999B9532C5A41666666667DF8234133333333522C5A41666666669AF8234166666686412C5A419A999999CAF823419A999979262C5A41CDCCCCCCDDF82341333333B31C2C5A4100000000E9F82341333333D3172C5A419A999999ADF8234133333393162C5A41CDCCCCCC8FF82341000000E01A2C5A419A99999976F82341666666661E2C5A416666666655F82341CDCCCCCC222C5A419A9999993DF8234166666606262C5A4133333333FBF723419A9999D92E2C5A41CDCCCCCCC3F7234100000060352C5A41333333339FF72341666666A6392C5A41333333337AF723419A9999193E2C5A41666666665BF72341666666A6412C5A41CDCCCCCC00F72341333333134C2C5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC00F72341333333134C2C5A41CDCCCCCC18F72341666666C6512C5A41666666660DF8234133333353922C5A41000000009FF82341CDCCCC4C8B2C5A4100000000F5F82341666666C6882C5A413333333351F8234166666686622C5A410000000089F82341000000405E2C5A41666666669BF82341000000E0592C5A41666666667DF8234133333333522C5A419A999999CAF823419A999979262C5A4100000000E9F82341333333D3172C5A419A999999ADF8234133333393162C5A4133333333FBF723419A9999D92E2C5A41CDCCCCCC00F72341333333134C2C5A41CDCCCCCC00F72341333333134C2C5A41	01010000206A080000B622861FD9F7234134333373542C5A41	751124809	H	Quinze-Vingts 9	7511248	75112	75	11	0
01060000206A080000010000000103000000010000002A0000003333333351F8234166666686622C5A41CDCCCCCCC3F82341666666267D2C5A4100000000F5F82341666666C6882C5A410000000015F923419A9999D9872C5A416666666658F9234133333313862C5A419A9999995FF92341666666E6852C5A41CDCCCCCC1AFA23419A999979842C5A410000000020FA234166666666842C5A410000000000FA234166666686732C5A4133333333FAF923419A9999F96F2C5A419A999999F5F92341000000E06C2C5A4100000000EAF9234133333393652C5A4100000000BFF92341000000A0482C5A419A999999BDF9234133333313482C5A419A999999BBF92341CDCCCCCC472C5A419A999999A6F9234133333313462C5A4166666666B3F9234100000000432C5A4133333333F6F92341000000E0322C5A41CDCCCCCC2CFA23419A9999D9252C5A410000000047FA2341666666061F2C5A413333333316F92341000000C0182C5A4100000000E9F82341333333D3172C5A41CDCCCCCCDDF82341333333B31C2C5A419A999999CAF823419A999979262C5A41666666669AF8234166666686412C5A41666666667DF8234133333333522C5A41CDCCCCCC8AF823419A9999B9532C5A416666666693F82341CDCCCC2C552C5A41CDCCCCCC96F82341333333F3552C5A41000000009AF823419A999919572C5A41CDCCCCCC9BF8234166666666582C5A41666666669BF82341000000E0592C5A41000000009AF82341666666C65A2C5A419A99999996F823419A9999D95B2C5A416666666693F823419A9999995C2C5A419A9999998EF82341000000805D2C5A410000000089F82341000000405E2C5A416666666682F82341CDCCCCEC5E2C5A41CDCCCCCC7BF82341333333935F2C5A419A99999975F8234100000020602C5A419A9999996DF82341000000A0602C5A413333333351F8234166666686622C5A41	01060000206A080000010000000103000000010000000F0000003333333351F8234166666686622C5A4100000000F5F82341666666C6882C5A419A9999995FF92341666666E6852C5A410000000020FA234166666666842C5A410000000000FA234166666686732C5A4100000000BFF92341000000A0482C5A419A999999A6F9234133333313462C5A410000000047FA2341666666061F2C5A4100000000E9F82341333333D3172C5A419A999999CAF823419A999979262C5A41666666667DF8234133333333522C5A41666666669BF82341000000E0592C5A410000000089F82341000000405E2C5A413333333351F8234166666686622C5A413333333351F8234166666686622C5A41	01010000206A080000109724EB25F923419A9999694D2C5A41	751124810	H	Quinze-Vingts 10	7511248	75112	75	11	0
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	01060000206A08000001000000010300000001000000160000006666666632F4234100000060FE2B5A4166666666B6F4234100000020012C5A41CDCCCCCCD0F42341000000E0002C5A41CDCCCCCCF3F52341CDCCCC8C062C5A41CDCCCCCC12F6234100000000FF2B5A4133333333BFF6234133333393ED2B5A4133333333DAF623419A9999F9ED2B5A419A999999F9F623419A9999D9F22B5A4166666666A1F72341CDCCCC6CE12B5A41CDCCCCCCABF72341CDCCCC4CE12B5A4100000000EFF8234100000060CA2B5A4133333333FEF82341CDCCCC4CCC2B5A419A99999925F9234100000040C82B5A41CDCCCCCC85F8234133333373BD2B5A410000000065F7234133333393A42B5A413333333333F72341666666869E2B5A41CDCCCCCC32F6234100000000B92B5A41CDCCCCCC14F52341666666A6D72B5A4166666666EEF4234133333373DC2B5A41CDCCCCCC36F42341666666E6FB2B5A416666666632F4234100000060FE2B5A416666666632F4234100000060FE2B5A41	01010000206A0800009A8483A9E3F6234100000040D22B5A41	751124811	A	Quinze-Vingts 11	7511248	75112	75	11	0
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	01060000206A0800000100000001030000000100000011000000CDCCCCCC99F22341CDCCCC6CF72B5A416666666620F32341CDCCCC0CFA2B5A41333333338BF3234100000020FB2B5A416666666632F4234100000060FE2B5A41CDCCCCCC36F42341666666E6FB2B5A4166666666EEF4234133333373DC2B5A41CDCCCCCC14F52341666666A6D72B5A41CDCCCCCC32F6234100000000B92B5A413333333333F72341666666869E2B5A4133333333BFF52341000000207B2B5A41CDCCCCCCA9F52341CDCCCC8C792B5A419A99999909F523419A999939942B5A4100000000F2F42341666666A69A2B5A41CDCCCCCC23F42341CDCCCC4CBC2B5A419A999999EDF32341CDCCCCECC32B5A41CDCCCCCC99F22341CDCCCC6CF72B5A41CDCCCCCC99F22341CDCCCC6CF72B5A41	01010000206A0800009EFDA4691FF523419A9999D9BB2B5A41	751124812	A	Quinze-Vingts 12	7511248	75112	75	11	0
01060000206A080000010000000103000000010000001E0000009A999999A6F9234133333313462C5A419A999999BBF92341CDCCCCCC472C5A419A999999BDF9234133333313482C5A4100000000BFF92341000000A0482C5A4100000000EAF9234133333393652C5A419A999999F5F92341000000E06C2C5A4133333333FAF923419A9999F96F2C5A410000000000FA234166666686732C5A410000000020FA234166666666842C5A410000000027FA234166666646842C5A413333333355FA23419A9999F9822C5A41CDCCCCCCF2FA2341CDCCCCAC802C5A41CDCCCCCCFFFA23419A999979802C5A413333333310FB234133333333802C5A41333333332EFB2341000000C07F2C5A413333333363FB2341333333F37E2C5A416666666670FB2341666666A67E2C5A41333333338AFB23419A9999197E2C5A4166666666AEFB2341666666467D2C5A4166666666DCFB2341666666267C2C5A4100000000C9FB234133333373782C5A419A99999984FB234133333313372C5A41CDCCCCCC73FB234100000080252C5A41CDCCCCCCAEFA234133333353212C5A416666666674FA23419A999939202C5A410000000047FA2341666666061F2C5A41CDCCCCCC2CFA23419A9999D9252C5A4133333333F6F92341000000E0322C5A4166666666B3F9234100000000432C5A419A999999A6F9234133333313462C5A41	01060000206A080000010000000103000000010000000D0000009A999999A6F9234133333313462C5A4100000000BFF92341000000A0482C5A410000000000FA234166666686732C5A410000000020FA234166666666842C5A413333333355FA23419A9999F9822C5A413333333363FB2341333333F37E2C5A4166666666DCFB2341666666267C2C5A4100000000C9FB234133333373782C5A419A99999984FB234133333313372C5A41CDCCCCCC73FB234100000080252C5A410000000047FA2341666666061F2C5A419A999999A6F9234133333313462C5A419A999999A6F9234133333313462C5A41	01010000206A080000DE19AD4DBDFA23419A999919572C5A41	751124813	A	Quinze-Vingts 13	7511248	75112	75	11	0
01060000206A080000010000000103000000010000003B0000003333333348F12341333333332A2C5A41CDCCCCCC49F123419A9999592A2C5A416666666659F12341000000002C2C5A416666666664F12341CDCCCC2C2D2C5A416666666665F12341CDCCCC4C2D2C5A419A99999983F1234133333373302C5A413333333385F1234100000040322C5A4166666666B5F12341CDCCCCEC452C5A419A999999C7F12341666666464D2C5A4166666666CEF123419A999919502C5A4100000000DAF12341000000E0542C5A416666666600F223419A999979642C5A41CDCCCCCC66F22341CDCCCC2C8E2C5A419A99999969F22341CDCCCC4C8F2C5A4166666666C0F2234133333313B12C5A4133333333C1F2234133333353B12C5A4166666666C4F22341CDCCCC8CB22C5A4133333333C6F2234100000040B32C5A419A999999C6F22341CDCCCC6CB32C5A419A999999C7F22341333333D3B32C5A4166666666CAF22341666666E6B42C5A419A999999CCF22341CDCCCCCCB52C5A4133333333CEF2234166666666B62C5A419A999999F1F2234100000020C42C5A41CDCCCCCCF7F2234166666686C62C5A419A99999900F32341333333F3C92C5A416666666612F3234133333353C92C5A413333333318F3234100000020C72C5A41000000001DF3234133333373C52C5A41CDCCCCCC21F323419A999999C32C5A416666666627F32341666666C6C02C5A41333333332CF3234100000080BE2C5A416666666634F3234133333333BB2C5A41000000003AF3234166666626B92C5A410000000042F3234133333353B72C5A416666666650F32341000000E0B52C5A419A99999944F3234100000060B22C5A41CDCCCCCC3CF323419A999999AF2C5A416666666621F3234166666686A42C5A41000000001EF32341CDCCCC4CA32C5A419A999999C0F22341333333137C2C5A416666666693F223419A9999596B2C5A410000000076F22341333333B35F2C5A410000000067F2234100000060592C5A410000000048F223419A9999194C2C5A413333333334F22341666666C6432C5A41CDCCCCCC1EF22341666666A63B2C5A4100000000EFF1234100000000282C5A41CDCCCCCCD9F12341666666261F2C5A4166666666D2F12341333333531C2C5A4166666666CAF12341000000001A2C5A419A999999C6F123419A9999F9182C5A419A999999C1F1234133333313182C5A41666666668AF1234100000060202C5A41666666667CF123419A999979222C5A416666666671F1234100000000242C5A419A9999995CF1234166666626272C5A41333333334DF12341CDCCCC6C292C5A413333333348F12341333333332A2C5A41	01060000206A080000010000000103000000010000000F0000003333333348F12341333333332A2C5A413333333385F1234100000040322C5A419A99999969F22341CDCCCC4C8F2C5A419A99999900F32341333333F3C92C5A416666666612F3234133333353C92C5A41000000003AF3234166666626B92C5A416666666650F32341000000E0B52C5A41000000001EF32341CDCCCC4CA32C5A419A999999C0F22341333333137C2C5A410000000076F22341333333B35F2C5A413333333334F22341666666C6432C5A4166666666D2F12341333333531C2C5A419A999999C1F1234133333313182C5A413333333348F12341333333332A2C5A413333333348F12341333333332A2C5A41	01010000206A080000FCE4ABE867F22341666666B6732C5A41	751124888	D	Bassin de l'Arsenal	7511248	75112	75	11	0
01060000206A0800000100000001030000000100000037000000CDCCCCCC5DF0234100000080112C5A4166666666D8F02341666666661E2C5A419A999999DAF02341000000A01E2C5A4166666666E6F02341666666E61F2C5A419A999999E8F0234166666626202C5A4133333333EFF02341CDCCCCCC202C5A419A999999F8F02341CDCCCCCC212C5A4133333333F9F02341000000E0212C5A413333333308F1234133333373232C5A416666666609F1234133333393232C5A419A9999991BF123419A999979252C5A41CDCCCCCC1CF123419A999999252C5A410000000024F1234100000060262C5A410000000047F12341333333132A2C5A413333333348F12341333333332A2C5A41333333334DF12341CDCCCC6C292C5A419A9999995CF1234166666626272C5A416666666671F1234100000000242C5A41666666667CF123419A999979222C5A41666666668AF1234100000060202C5A419A999999C1F1234133333313182C5A419A999999D7F12341666666A6142C5A410000000030F22341333333B3072C5A41CDCCCCCC99F22341CDCCCC6CF72B5A419A999999BDF22341333333B3F12B5A4166666666E2F223419A999959EC2B5A416666666609F323419A999979E62B5A410000000029F32341666666A6E12B5A41CDCCCCCC33F3234166666606E02B5A41666666663EF3234100000080DE2B5A416666666662F3234166666626D92B5A416666666690F32341CDCCCC2CD22B5A4133333333D7F3234133333353C72B5A419A999999EDF32341CDCCCCECC32B5A410000000006F4234166666686C02B5A41CDCCCCCC23F42341CDCCCC4CBC2B5A41CDCCCCCC36F423419A999939B92B5A419A99999960F423419A999999B22B5A410000000090F42341666666A6AA2B5A4166666666B9F42341666666E6A32B5A4100000000F2F42341666666A69A2B5A419A99999909F523419A999939942B5A419A99999940F52341CDCCCC4C8B2B5A419A99999977F5234133333313822B5A41000000009EF52341333333937B2B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41CDCCCCCC7FF523419A999919762B5A4133333333F8F42341CDCCCC0C6B2B5A41CDCCCCCCE8F423419A999959692B5A413333333381F42341333333D3782B5A410000000011F32341333333F3AD2B5A4166666666FAF2234133333333B12B5A419A99999957F22341333333B3C82B5A41333333334BF1234166666666EF2B5A41CDCCCCCC5DF0234100000080112C5A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC5DF0234100000080112C5A413333333348F12341333333332A2C5A410000000030F22341333333B3072C5A419A999999EDF32341CDCCCCECC32B5A41CDCCCCCC23F42341CDCCCC4CBC2B5A4100000000F2F42341666666A69A2B5A419A99999909F523419A999939942B5A41CDCCCCCCA9F52341CDCCCC8C792B5A41CDCCCCCCE8F423419A999959692B5A413333333381F42341333333D3782B5A41333333334BF1234166666666EF2B5A41CDCCCCCC5DF0234100000080112C5A41CDCCCCCC5DF0234100000080112C5A41	01010000206A080000F6BB5707F3F2234100000070CD2B5A41	751124899	D	Seine et Berges	7511248	75112	75	11	0
01060000206A080000010000000103000000010000001B0000009A999999D8E32341666666662A2A5A4133333333F3E323419A9999792F2A5A419A99999912E4234133333353362A5A41CDCCCCCC1AE42341CDCCCC6C382A5A41666666662CE423419A9999393E2A5A41CDCCCCCC6EE42341666666E6532A5A419A99999974E42341000000C0552A5A41666666667DE4234133333333592A5A419A99999985E42341CDCCCCCC5C2A5A41333333338DE423419A999919602A5A416666666693E4234166666606632A5A41333333339AE4234133333373662A5A41333333339FE4234100000000692A5A4166666666A4E423419A9999196D2A5A419A999999A5E423419A9999F96D2A5A4166666666AAE4234166666606722A5A4100000000E1E42341CDCCCCEC6E2A5A41CDCCCCCC1EE52341333333936B2A5A410000000062E52341CDCCCC0C682A5A41CDCCCCCCA4E5234100000060642A5A419A99999998E52341CDCCCC0C5C2A5A410000000096E52341CDCCCC8C592A5A419A99999994E5234166666646552A5A41000000007DE52341000000402E2A5A41CDCCCCCC6FE5234166666626182A5A4133333333D6E42341666666061F2A5A419A999999D8E32341666666662A2A5A41	01060000206A080000010000000103000000010000000A0000009A999999D8E32341666666662A2A5A41CDCCCCCC1AE42341CDCCCC6C382A5A419A99999974E42341000000C0552A5A41333333339FE4234100000000692A5A4166666666AAE4234166666606722A5A41CDCCCCCCA4E5234100000060642A5A419A99999998E52341CDCCCC0C5C2A5A41CDCCCCCC6FE5234166666626182A5A419A999999D8E32341666666662A2A5A419A999999D8E32341666666662A2A5A41	01010000206A08000098024568EDE4234100000010492A5A41	751135119	H	Maison Blanche 19	7511351	75113	75	11	0
01060000206A080000010000000103000000010000002400000000000000AAED234133333393E5295A4100000000C8ED2341CDCCCCECE2295A419A999999E0ED23419A999999E0295A413333333340EE234100000080D7295A41CDCCCCCC0DEF2341CDCCCCECC3295A410000000018EF2341CDCCCCECC2295A4100000000A3EF2341CDCCCC6CB5295A419A999999B6EF234166666686B3295A41CDCCCCCCC6EF234100000000B2295A4133333333D0EF234133333313B1295A4100000000E8EF2341666666C6AE295A410000000002F023419A999939AC295A419A9999991CF023419A999999A9295A419A99999932F0234100000080A7295A41666666667BF02341CDCCCC6CA0295A4133333333B6F023419A9999B99A295A419A999999E9F02341000000C095295A4133333333CDF023413333339392295A413333333362F023413333339388295A419A99999945F023419A9999D985295A419A99999922F02341333333B382295A419A999999A4EF23419A9999F976295A416666666673EF23413333339372295A410000000044EF23419A9999597E295A41000000003FEF2341333333937F295A41CDCCCCCC33EF23416666666682295A419A99999919EF23419A99991989295A410000000008EF2341666666268D295A419A999999B9EE23419A999999A0295A4166666666A9EE234166666646A4295A419A9999999AEE2341CDCCCCECA7295A410000000012EE23419A999999C9295A419A999999F4ED23419A999979D1295A41CDCCCCCCC3ED2341CDCCCC4CDD295A4100000000B1ED23419A999999E1295A4100000000AAED234133333393E5295A41	01060000206A080000010000000103000000010000000800000000000000AAED234133333393E5295A41CDCCCCCC0DEF2341CDCCCCECC3295A419A999999E9F02341000000C095295A4133333333CDF023413333339392295A416666666673EF23413333339372295A4100000000B1ED23419A999999E1295A4100000000AAED234133333393E5295A4100000000AAED234133333393E5295A41	01010000206A080000D43B06E44EEF23419A9999E9AA295A41	751135005	H	Gare 5	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001400000000000000AAED234133333393E5295A410000000087EE234100000060EA295A41CDCCCCCCC9EF234100000000F2295A41666666669EEF2341000000A0E7295A4133333333E3EF2341CDCCCC2CE9295A419A99999943F023419A999979E5295A410000000062F0234166666646DA295A419A9999996CF0234166666626D9295A4100000000C5F02341666666E6BC295A4100000000E0F0234100000040B3295A41666666669BF023419A999979B8295A41666666666EF023419A999959BD295A419A999999B6EF234166666686B3295A4100000000A3EF2341CDCCCC6CB5295A410000000018EF2341CDCCCCECC2295A41CDCCCCCC0DEF2341CDCCCCECC3295A413333333340EE234100000080D7295A419A999999E0ED23419A999999E0295A4100000000C8ED2341CDCCCCECE2295A4100000000AAED234133333393E5295A41	01060000206A080000010000000103000000010000001400000000000000AAED234133333393E5295A410000000087EE234100000060EA295A41CDCCCCCCC9EF234100000000F2295A41666666669EEF2341000000A0E7295A4133333333E3EF2341CDCCCC2CE9295A419A99999943F023419A999979E5295A410000000062F0234166666646DA295A419A9999996CF0234166666626D9295A4100000000C5F02341666666E6BC295A4100000000E0F0234100000040B3295A41666666669BF023419A999979B8295A41666666666EF023419A999959BD295A419A999999B6EF234166666686B3295A4100000000A3EF2341CDCCCC6CB5295A410000000018EF2341CDCCCCECC2295A41CDCCCCCC0DEF2341CDCCCCECC3295A413333333340EE234100000080D7295A419A999999E0ED23419A999999E0295A4100000000C8ED2341CDCCCCECE2295A4100000000AAED234133333393E5295A41	01010000206A0800003238F4B19BEF2341666666B6CD295A41	751135006	H	Gare 6	7511350	75113	75	11	0
01060000206A0800000200000001030000000100000013000000666666666EF023419A999959BD295A41666666669BF023419A999979B8295A4100000000E0F0234100000040B3295A410000000066F1234133333373A3295A413333333383F123410000004093295A416666666687F123419A99997991295A410000000071F12341000000C08F295A413333333349F12341666666868C295A419A999999E9F02341000000C095295A4133333333B6F023419A9999B99A295A41666666667BF02341CDCCCC6CA0295A419A99999932F0234100000080A7295A419A9999991CF023419A999999A9295A410000000002F023419A999939AC295A4100000000E8EF2341666666C6AE295A4133333333D0EF234133333313B1295A41CDCCCCCCC6EF234100000000B2295A419A999999B6EF234166666686B3295A41666666666EF023419A999959BD295A410103000000010000000F000000CDCCCCCCC9EF234100000000F2295A4166666666D6EF23419A999959F2295A4100000000A4F02341CDCCCC6CF7295A41CDCCCCCCC5F023419A999939F8295A413333333336F123419A9999B9CE295A410000000069F12341CDCCCCCCD0295A4166666666A4F12341000000A0BA295A4100000000E0F0234100000040B3295A4100000000C5F02341666666E6BC295A419A9999996CF0234166666626D9295A410000000062F0234166666646DA295A419A99999943F023419A999979E5295A4133333333E3EF2341CDCCCC2CE9295A41666666669EEF2341000000A0E7295A41CDCCCCCCC9EF234100000000F2295A41	01060000206A0800000200000001030000000100000008000000666666666EF023419A999959BD295A4100000000E0F0234100000040B3295A410000000066F1234133333373A3295A416666666687F123419A99997991295A413333333349F12341666666868C295A419A999999B6EF234166666686B3295A41666666666EF023419A999959BD295A41666666666EF023419A999959BD295A410103000000010000000C000000CDCCCCCCC9EF234100000000F2295A41CDCCCCCCC5F023419A999939F8295A413333333336F123419A9999B9CE295A410000000069F12341CDCCCCCCD0295A4166666666A4F12341000000A0BA295A4100000000E0F0234100000040B3295A4100000000C5F02341666666E6BC295A419A99999943F023419A999979E5295A4133333333E3EF2341CDCCCC2CE9295A41666666669EEF2341000000A0E7295A41CDCCCCCCC9EF234100000000F2295A41CDCCCCCCC9EF234100000000F2295A41	01010000206A080000961AA021CEF023419A999979A5295A41	751135007	H	Gare 7	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000023000000CDCCCCCCC5F023419A999939F8295A41000000002CF12341000000A0FA295A416666666666F123419A999919FC295A419A999999A9F1234100000080E3295A4100000000E7F123419A999919CD295A41CDCCCCCC27F2234100000080B5295A413333333345F22341333333D3AA295A41CDCCCCCC4FF22341CDCCCCECA6295A419A99999978F223419A99991998295A413333333383F22341CDCCCCCC94295A41000000008AF22341CDCCCCAC92295A4133333333A7F223419A9999B989295A41CDCCCCCCB0F223413333333386295A419A99999902F323419A9999B968295A41CDCCCCCCFCF223416666662666295A419A999999F1F223419A99995963295A4166666666D5F22341CDCCCC2C66295A41CDCCCCCCEFF12341000000407C295A4133333333E0F12341666666C67D295A41CDCCCCCCD4F12341000000E07E295A41CDCCCCCCCDF12341CDCCCC8C7F295A41CDCCCCCCAFF123419A99997982295A41666666669AF123416666668684295A41000000005FF12341333333538A295A41666666665AF12341666666C68A295A413333333349F12341666666868C295A410000000071F12341000000C08F295A416666666687F123419A99997991295A413333333383F123410000004093295A410000000066F1234133333373A3295A4100000000E0F0234100000040B3295A4166666666A4F12341000000A0BA295A410000000069F12341CDCCCCCCD0295A413333333336F123419A9999B9CE295A41CDCCCCCCC5F023419A999939F8295A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCC5F023419A999939F8295A416666666666F123419A999919FC295A419A99999978F223419A99991998295A4133333333A7F223419A9999B989295A419A99999902F323419A9999B968295A419A999999F1F223419A99995963295A413333333349F12341666666868C295A416666666687F123419A99997991295A410000000066F1234133333373A3295A4100000000E0F0234100000040B3295A4166666666A4F12341000000A0BA295A410000000069F12341CDCCCCCCD0295A413333333336F123419A9999B9CE295A41CDCCCCCCC5F023419A999939F8295A41CDCCCCCCC5F023419A999939F8295A41	01010000206A080000445C8DA99EF123419A999909AF295A41	751135008	H	Gare 8	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001F0000000000000090F02341CDCCCCECBB2A5A419A999999DCF02341666666A6C02A5A413333333358F123419A999959C82A5A419A999999CDF12341CDCCCCACCF2A5A41CDCCCCCCD1F12341333333F3CF2A5A41CDCCCCCCDDF12341333333B3D02A5A419A9999991FF22341000000C0D42A5A41CDCCCCCCDFF2234100000080E02A5A4133333333E1F22341CDCCCC2CE02A5A4166666666E9F22341CDCCCCECDD2A5A4133333333F0F2234100000040DB2A5A41CDCCCCCCFEF2234100000080D72A5A41333333333AF32341000000C0C92A5A419A99999956F32341CDCCCC6CC32A5A4166666666ACF3234100000020B22A5A413333333348F3234133333393AA2A5A410000000043F32341666666E6A92A5A413333333327F323419A9999D9A62A5A416666666619F32341CDCCCC6CA52A5A4100000000C3F22341CDCCCC8C9C2A5A41666666668DF223419A999939972A5A416666666631F22341666666068E2A5A41666666661BF22341000000A08B2A5A4100000000FAF12341333333338F2A5A4133333333AEF1234100000020992A5A41CDCCCCCC42F12341CDCCCCCCA62A5A416666666615F12341CDCCCCCCAC2A5A4100000000F6F02341333333F3B02A5A4100000000B9F023419A999999B82A5A419A999999A6F02341CDCCCC0CBA2A5A410000000090F02341CDCCCCECBB2A5A41	01060000206A080000010000000103000000010000000B0000000000000090F02341CDCCCCECBB2A5A41CDCCCCCCDFF2234100000080E02A5A41CDCCCCCCFEF2234100000080D72A5A419A99999956F32341CDCCCC6CC32A5A4166666666ACF3234100000020B22A5A413333333348F3234133333393AA2A5A41666666661BF22341000000A08B2A5A4100000000FAF12341333333338F2A5A4100000000B9F023419A999999B82A5A410000000090F02341CDCCCCECBB2A5A410000000090F02341CDCCCCECBB2A5A41	01010000206A080000A269559437F22341CDCCCC5CB52A5A41	751135021	H	Gare 21	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000019000000CDCCCCCCBAEF2341333333D3AE2A5A416666666600F0234133333313B32A5A41666666668CF02341333333B3BB2A5A410000000090F02341CDCCCCECBB2A5A419A999999A6F02341CDCCCC0CBA2A5A4100000000B9F023419A999999B82A5A4100000000F6F02341333333F3B02A5A416666666615F12341CDCCCCCCAC2A5A41CDCCCCCC42F12341CDCCCCCCA62A5A4133333333AEF1234100000020992A5A4100000000FAF12341333333338F2A5A41666666661BF22341000000A08B2A5A4133333333A8F12341666666867E2A5A416666666676F12341000000E0782A5A419A9999996BF12341CDCCCC6C772A5A413333333365F123419A9999F9752A5A41CDCCCCCC5BF1234100000060732A5A41666666663CF12341CDCCCC8C772A5A41CDCCCCCCBDF0234133333373892A5A416666666682F02341CDCCCCAC912A5A419A999999E7EF2341666666A6A72A5A4133333333D4EF234133333313AA2A5A4166666666CAEF234100000040AC2A5A4166666666BBEF23419A9999B9AE2A5A41CDCCCCCCBAEF2341333333D3AE2A5A41	01060000206A080000010000000103000000010000000A000000CDCCCCCCBAEF2341333333D3AE2A5A410000000090F02341CDCCCCECBB2A5A4100000000B9F023419A999999B82A5A4100000000FAF12341333333338F2A5A41666666661BF22341000000A08B2A5A416666666676F12341000000E0782A5A41CDCCCCCC5BF1234100000060732A5A419A999999E7EF2341666666A6A72A5A41CDCCCCCCBAEF2341333333D3AE2A5A41CDCCCCCCBAEF2341333333D3AE2A5A41	01010000206A08000096FD7F6719F1234166666666952A5A41	751135023	H	Gare 23	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000020000000CDCCCCCC5BF1234100000060732A5A413333333365F123419A9999F9752A5A419A9999996BF12341CDCCCC6C772A5A416666666676F12341000000E0782A5A4133333333A8F12341666666867E2A5A41666666661BF22341000000A08B2A5A416666666674F22341666666E67F2A5A4133333333AFF2234166666646782A5A4100000000F7F22341000000806F2A5A416666666625F3234166666686692A5A419A99999929F3234100000000692A5A419A9999995DF32341CDCCCC4C622A5A41CDCCCCCCAFF32341000000C0572A5A41000000003AF423419A999999462A5A410000000054F4234133333393432A5A41666666665EF323419A9999F9282A5A4166666666BCF2234166666686402A5A41CDCCCCCCC2F22341CDCCCCEC412A5A419A999999C7F22341CDCCCCCC432A5A4133333333CAF2234133333393452A5A41CDCCCCCC06F323419A9999D9462A5A419A99999969F22341666666C65C2A5A416666666660F223419A9999595D2A5A419A9999995CF223419A9999595D2A5A410000000034F223419A999959592A5A41666666662DF22341CDCCCC4C592A5A413333333320F223419A9999B9582A5A419A99999919F2234166666606582A5A4133333333E8F12341CDCCCC0C5F2A5A419A99999990F12341CDCCCCCC6B2A5A419A99999969F1234100000080712A5A41CDCCCCCC5BF1234100000060732A5A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC5BF1234100000060732A5A416666666676F12341000000E0782A5A41666666661BF22341000000A08B2A5A4133333333AFF2234166666646782A5A41CDCCCCCCAFF32341000000C0572A5A410000000054F4234133333393432A5A41666666665EF323419A9999F9282A5A4166666666BCF2234166666686402A5A4133333333CAF2234133333393452A5A41CDCCCCCC06F323419A9999D9462A5A419A99999969F22341666666C65C2A5A419A9999995CF223419A9999595D2A5A419A99999919F2234166666606582A5A41CDCCCCCC5BF1234100000060732A5A41CDCCCCCC5BF1234100000060732A5A41	01010000206A0800006E3142EF05F32341000000105B2A5A41	751135024	H	Gare 24	7511350	75113	75	11	0
01060000206A080000010000000103000000010000002100000066666666BEF02341CDCCCC8C322A5A419A999999C4F0234133333393332A5A4133333333E3F02341000000E0312A5A413333333320F12341333333B32E2A5A413333333329F123419A9999392E2A5A413333333390F12341666666A6272A5A419A999999AAF1234166666666252A5A419A999999D8F12341CDCCCCEC1F2A5A4166666666E7F123419A999959202A5A41CDCCCCCC01F22341000000801F2A5A41CDCCCCCCCCF22341CDCCCCEC182A5A419A999999D8F2234133333393182A5A410000000014F32341000000A0162A5A419A9999999DF3234166666606122A5A4166666666D4F3234133333333102A5A4133333333D7F3234100000020102A5A4166666666E3F323419A9999B90F2A5A413333333336F42341000000C00D2A5A4166666666EBF32341666666E60B2A5A41333333339FF32341CDCCCC0C0A2A5A4166666666F2F22341CDCCCCCC052A5A41CDCCCCCCE9F2234133333393052A5A419A99999991F2234166666626032A5A4133333333F6F12341CDCCCC8CFF295A4166666666C2F123419A999959FE295A416666666666F123419A999919FC295A413333333332F12341CDCCCCAC0C2A5A41333333332EF12341000000000E2A5A416666666602F123419A9999F91B2A5A4166666666FFF02341666666E61C2A5A4100000000DBF0234166666686282A5A419A999999C5F023419A9999592F2A5A4166666666BEF02341CDCCCC8C322A5A41	01060000206A080000010000000103000000010000000D00000066666666BEF02341CDCCCC8C322A5A419A999999C4F0234133333393332A5A413333333329F123419A9999392E2A5A413333333390F12341666666A6272A5A419A999999D8F12341CDCCCCEC1F2A5A4166666666E7F123419A999959202A5A4166666666E3F323419A9999B90F2A5A413333333336F42341000000C00D2A5A419A99999991F2234166666626032A5A416666666666F123419A999919FC295A419A999999C5F023419A9999592F2A5A4166666666BEF02341CDCCCC8C322A5A4166666666BEF02341CDCCCC8C322A5A41	01010000206A0800006AF2BB3403F223419A999999172A5A41	751135026	H	Gare 26	7511350	75113	75	11	0
01060000206A08000001000000010300000001000000230000006666666630E52341000000C0E1295A410000000034E5234166666606E3295A413333333340E52341CDCCCCECED295A419A99999945E52341CDCCCCACF2295A41CDCCCCCC6FE5234166666626182A5A41000000007DE52341000000402E2A5A419A99999994E5234166666646552A5A410000000096E52341CDCCCC8C592A5A419A99999998E52341CDCCCC0C5C2A5A41CDCCCCCCA4E5234100000060642A5A4100000000D8E52341000000A0612A5A41333333330AE623419A9999B95E2A5A410000000040E62341000000A05B2A5A41CDCCCCCC5AE62341000000205A2A5A419A9999999AE62341666666E6562A5A4133333333E0E623419A999919532A5A419A9999991AE72341CDCCCCEC4F2A5A419A999999FDE623419A999999482A5A4166666666F5E623419A999979462A5A419A999999E1E623419A999999412A5A419A999999CBE62341666666463C2A5A4133333333BAE623419A9999F9372A5A4166666666A8E6234133333393332A5A41666666669CE623419A999919302A5A410000000095E623419A9999F92B2A5A419A9999997CE62341CDCCCCCC212A5A413333333362E62341CDCCCCEC162A5A41666666664CE62341CDCCCCCC0E2A5A416666666639E62341CDCCCCCC072A5A419A999999FAE5234100000080F0295A4133333333F6E52341CDCCCC8CEC295A4100000000F6E52341CDCCCC0CE9295A4133333333F9E52341666666A6DD295A419A999999F9E5234166666666DC295A416666666630E52341000000C0E1295A41	01060000206A080000010000000103000000010000000D0000006666666630E52341000000C0E1295A410000000034E5234166666606E3295A41CDCCCCCC6FE5234166666626182A5A419A99999998E52341CDCCCC0C5C2A5A41CDCCCCCCA4E5234100000060642A5A41CDCCCCCC5AE62341000000205A2A5A419A9999991AE72341CDCCCCEC4F2A5A4166666666A8E6234133333393332A5A413333333362E62341CDCCCCEC162A5A419A999999FAE5234100000080F0295A419A999999F9E5234166666666DC295A416666666630E52341000000C0E1295A416666666630E52341000000C0E1295A41	01010000206A0800001A57CEC8F1E523419A9999F91C2A5A41	751135120	H	Maison Blanche 20	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000290000003333333362E62341CDCCCCEC162A5A419A9999997CE62341CDCCCCCC212A5A410000000095E623419A9999F92B2A5A41666666669CE623419A999919302A5A4166666666A8E6234133333393332A5A4133333333BAE623419A9999F9372A5A419A999999CBE62341666666463C2A5A419A999999E1E623419A999999412A5A4166666666F5E623419A999979462A5A419A999999FDE623419A999999482A5A419A9999991AE72341CDCCCCEC4F2A5A41CDCCCCCC46E72341666666464D2A5A410000000063E72341333333B34B2A5A41CDCCCCCC77E72341666666864A2A5A41CDCCCCCC87E72341333333D3492A5A413333333395E7234166666666492A5A419A999999A2E7234166666646492A5A4166666666C8E72341CDCCCCAC482A5A419A999999F6E72341333333F3472A5A410000000089E82341CDCCCC8C502A5A419A999999A0E82341CDCCCC0C522A5A41CDCCCCCC45E923419A9999595B2A5A410000000074E92341000000C05D2A5A413333333369E923419A9999B9582A5A413333333360E9234166666606562A5A41CDCCCCCC52E923419A9999D9522A5A416666666636E923419A9999B94E2A5A413333333300E9234133333373472A5A41CDCCCCCCCEE8234133333353402A5A419A99999994E823419A9999F9372A5A41CDCCCCCC6EE8234100000000322A5A41CDCCCCCC66E82341CDCCCCCC302A5A41CDCCCCCC0EE82341CDCCCC6C232A5A4100000000D9E72341333333F31A2A5A4133333333A7E7234133333393122A5A41000000009CE72341CDCCCCAC102A5A413333333361E72341000000200F2A5A419A99999937E723419A999959092A5A416666666607E72341CDCCCC6C0C2A5A4100000000FFE62341333333F30C2A5A413333333362E62341CDCCCCEC162A5A41	01060000206A080000010000000103000000010000000F0000003333333362E62341CDCCCCEC162A5A4166666666A8E6234133333393332A5A419A9999991AE72341CDCCCCEC4F2A5A413333333395E7234166666666492A5A419A999999F6E72341333333F3472A5A419A999999A0E82341CDCCCC0C522A5A410000000074E92341000000C05D2A5A41CDCCCCCC52E923419A9999D9522A5A419A99999994E823419A9999F9372A5A4100000000D9E72341333333F31A2A5A41000000009CE72341CDCCCCAC102A5A413333333361E72341000000200F2A5A419A99999937E723419A999959092A5A413333333362E62341CDCCCCEC162A5A413333333362E62341CDCCCCEC162A5A41	01010000206A08000014F335BB8CE723419A9999C9322A5A41	751135121	H	Maison Blanche 21	7511351	75113	75	11	0
01060000206A080000010000000103000000010000002400000000000000F6E52341CDCCCC0CE9295A4133333333F6E52341CDCCCC8CEC295A419A999999FAE5234100000080F0295A416666666639E62341CDCCCCCC072A5A41666666664CE62341CDCCCCCC0E2A5A413333333362E62341CDCCCCEC162A5A4100000000FFE62341333333F30C2A5A416666666607E72341CDCCCC6C0C2A5A419A99999937E723419A999959092A5A413333333361E72341000000200F2A5A41000000009CE72341CDCCCCAC102A5A4166666666CAE72341666666C6112A5A419A99999915E823419A999999132A5A416666666622E82341CDCCCCEC132A5A419A99999955E82341CDCCCC2C152A5A419A999999BBE82341000000A0172A5A4166666666FFE8234166666646192A5A41333333334DE92341666666261B2A5A416666666684E92341000000401D2A5A4133333333A1E92341666666A60D2A5A4166666666C8E9234133333393FD295A419A999999D4E9234133333313F8295A41CDCCCCCC06EA23419A9999B9E1295A4166666666FBE92341000000A0E1295A416666666682E923419A999979E0295A410000000031E92341000000C0DF295A4133333333F5E82341CDCCCC2CDF295A410000000054E82341CDCCCC6CDD295A413333333328E8234166666666DD295A41CDCCCCCCEEE6234133333393DA295A4133333333C6E6234133333333DA295A41000000006BE6234100000060D9295A41CDCCCCCC59E62341000000C0D9295A419A999999F9E5234166666666DC295A4133333333F9E52341666666A6DD295A4100000000F6E52341CDCCCC0CE9295A41	01060000206A080000010000000103000000010000000F00000000000000F6E52341CDCCCC0CE9295A419A999999FAE5234100000080F0295A413333333362E62341CDCCCCEC162A5A419A99999937E723419A999959092A5A413333333361E72341000000200F2A5A41333333334DE92341666666261B2A5A416666666684E92341000000401D2A5A4133333333A1E92341666666A60D2A5A41CDCCCCCC06EA23419A9999B9E1295A410000000054E82341CDCCCC6CDD295A413333333328E8234166666666DD295A41000000006BE6234100000060D9295A419A999999F9E5234166666666DC295A4100000000F6E52341CDCCCC0CE9295A4100000000F6E52341CDCCCC0CE9295A41	01010000206A080000AE74E176F2E72341333333D3FA295A41	751135122	H	Maison Blanche 22	7511351	75113	75	11	0
01060000206A0800000100000001030000000100000023000000000000009CE72341CDCCCCAC102A5A4133333333A7E7234133333393122A5A4100000000D9E72341333333F31A2A5A41CDCCCCCC0EE82341CDCCCC6C232A5A41CDCCCCCC66E82341CDCCCCCC302A5A41CDCCCCCC6EE8234100000000322A5A419A99999994E823419A9999F9372A5A41CDCCCCCCCEE8234133333353402A5A413333333300E9234133333373472A5A416666666636E923419A9999B94E2A5A41CDCCCCCC52E923419A9999D9522A5A413333333360E9234166666606562A5A413333333369E923419A9999B9582A5A410000000074E92341000000C05D2A5A41666666668DE923419A9999395F2A5A41000000005EEA2341000000806B2A5A41CDCCCCCC86EA2341333333F36D2A5A41666666668EEA2341666666E66A2A5A4100000000C0EA234100000080652A5A41CDCCCCCCBFEA234166666666652A5A41CDCCCCCC97EA2341000000205C2A5A41333333337EEA23419A999939562A5A4100000000FFE923419A999959392A5A4166666666ACE92341666666A6262A5A4166666666A4E92341000000C0242A5A416666666698E9234166666606222A5A416666666684E92341000000401D2A5A41333333334DE92341666666261B2A5A4166666666FFE8234166666646192A5A419A999999BBE82341000000A0172A5A419A99999955E82341CDCCCC2C152A5A416666666622E82341CDCCCCEC132A5A419A99999915E823419A999999132A5A4166666666CAE72341666666C6112A5A41000000009CE72341CDCCCCAC102A5A41	01060000206A080000010000000103000000010000000C000000000000009CE72341CDCCCCAC102A5A4100000000D9E72341333333F31A2A5A419A99999994E823419A9999F9372A5A41CDCCCCCC52E923419A9999D9522A5A410000000074E92341000000C05D2A5A41CDCCCCCC86EA2341333333F36D2A5A41666666668EEA2341666666E66A2A5A4100000000C0EA234100000080652A5A416666666684E92341000000401D2A5A41333333334DE92341666666261B2A5A41000000009CE72341CDCCCCAC102A5A41000000009CE72341CDCCCCAC102A5A41	01010000206A08000014B9716D62E92341666666D63C2A5A41	751135123	H	Maison Blanche 23	7511351	75113	75	11	0
01060000206A080000010000000103000000010000002400000066666666AAE4234166666606722A5A41CDCCCCCCADE4234100000040742A5A4133333333C1E423419A999919832A5A4100000000D9E42341333333D39C2A5A41000000000AE5234100000080C62A5A419A99999965E523419A9999D9CB2A5A41CDCCCCCC6CE5234133333373CC2A5A410000000076E5234100000020CD2A5A416666666685E52341CDCCCCACCE2A5A4133333333A7E5234166666686D22A5A41CDCCCCCCAEE523419A999999D32A5A4100000000B5E52341666666C6D42A5A41CDCCCCCCDAE5234100000020DE2A5A41CDCCCCCCEFE52341CDCCCCECDE2A5A416666666609E7234100000060EF2A5A41CDCCCCCCD5E6234133333313DB2A5A41000000008BE62341CDCCCC8CBD2A5A413333333375E62341CDCCCC0CB52A5A41000000006FE62341666666A6B22A5A41333333334EE623419A9999F9A52A5A41000000004EE62341666666E6A52A5A419A9999992EE62341666666E6A32A5A41000000002FE62341CDCCCCCCA32A5A41666666663BE62341000000209E2A5A410000000044E62341666666E69A2A5A419A9999992EE6234133333333992A5A4166666666F7E52341000000E0832A5A41CDCCCCCCEFE523419A9999F9802A5A4133333333DBE52341CDCCCC0C792A5A4100000000C2E52341666666666F2A5A4166666666AAE52341CDCCCC8C662A5A41CDCCCCCCA4E5234100000060642A5A410000000062E52341CDCCCC0C682A5A41CDCCCCCC1EE52341333333936B2A5A4100000000E1E42341CDCCCCEC6E2A5A4166666666AAE4234166666606722A5A41	01060000206A080000010000000103000000010000001000000066666666AAE4234166666606722A5A4133333333C1E423419A999919832A5A4100000000D9E42341333333D39C2A5A41000000000AE5234100000080C62A5A419A99999965E523419A9999D9CB2A5A4100000000B5E52341666666C6D42A5A41CDCCCCCCDAE5234100000020DE2A5A41CDCCCCCCEFE52341CDCCCCECDE2A5A416666666609E7234100000060EF2A5A41000000004EE62341666666E6A52A5A419A9999992EE62341666666E6A32A5A410000000044E62341666666E69A2A5A419A9999992EE6234133333333992A5A41CDCCCCCCA4E5234100000060642A5A4166666666AAE4234166666606722A5A4166666666AAE4234166666606722A5A41	01010000206A08000026E0A2E7A4E5234100000050AC2A5A41	751135204	H	Croulebarbe 4	7511352	75113	75	11	0
01060000206A080000010000000103000000010000001900000066666666DBE22341666666E6892A5A4166666666E0E223419A9999598B2A5A419A999999E5E22341CDCCCCCC942A5A41CDCCCCCCEBE22341333333F39C2A5A41CDCCCCCCF1E22341333333F3A22A5A419A999999F9E2234166666606A92A5A41000000002BE32341CDCCCCACAC2A5A419A99999955E32341000000C0AF2A5A41CDCCCCCC66E3234166666646B12A5A41CDCCCCCC92E32341333333D3B32A5A4100000000C4E3234100000020B62A5A41666666662AE42341666666A6BA2A5A419A9999994FE42341CDCCCC6CBC2A5A419A999999C2E42341CDCCCCECC12A5A41000000000AE5234100000080C62A5A4100000000D9E42341333333D39C2A5A4133333333C1E423419A999919832A5A41CDCCCCCCADE4234100000040742A5A4166666666AAE4234166666606722A5A41CDCCCCCC56E4234100000060762A5A41CDCCCCCCF9E32341000000207B2A5A4100000000B4E32341666666867E2A5A416666666652E32341333333B3832A5A4166666666E3E22341CDCCCC6C892A5A4166666666DBE22341666666E6892A5A41	01060000206A080000010000000103000000010000000A00000066666666DBE22341666666E6892A5A419A999999F9E2234166666606A92A5A41CDCCCCCC92E32341333333D3B32A5A419A999999C2E42341CDCCCCECC12A5A41000000000AE5234100000080C62A5A4100000000D9E42341333333D39C2A5A4133333333C1E423419A999919832A5A4166666666AAE4234166666606722A5A4166666666DBE22341666666E6892A5A4166666666DBE22341666666E6892A5A41	01010000206A0800007EC558F8DEE32341000000D0982A5A41	751135205	H	Croulebarbe 5	7511352	75113	75	11	0
01060000206A08000001000000010300000001000000270000009A999999F9E2234166666606A92A5A41333333332CE32341333333F3D82A5A41CDCCCCCC38E3234133333393E72A5A41CDCCCCCC39E32341CDCCCCCCE82A5A416666666643E32341000000C0F42A5A416666666656E32341000000200C2B5A41333333335AE32341666666C6102B5A41333333335BE32341CDCCCCEC112B5A41666666665FE3234166666626172B5A416666666663E32341000000201C2B5A41000000006CE32341000000C0262B5A419A9999996EE323419A9999192A2B5A41CDCCCCCC75E3234133333313332B5A416666666677E3234166666666352B5A41000000007AE323419A999959382B5A41666666667BE32341CDCCCCCC392B5A41000000007CE323419A9999D93A2B5A419A999999D4E3234100000020372B5A4100000000EBE3234100000040362B5A41333333338FE42341CDCCCCCC2F2B5A4166666666DCE42341000000C02C2B5A416666666671E52341666666A6262B5A410000000073E5234133333393262B5A41666666666FE52341666666A6222B5A419A9999994AE52341CDCCCCAC052B5A416666666646E5234166666626012B5A41666666663EE52341333333B3F82A5A41CDCCCCCC37E52341000000A0F22A5A410000000020E5234133333353DC2A5A41000000000AE5234100000080C62A5A419A999999C2E42341CDCCCCECC12A5A419A9999994FE42341CDCCCC6CBC2A5A41666666662AE42341666666A6BA2A5A4100000000C4E3234100000020B62A5A41CDCCCCCC92E32341333333D3B32A5A41CDCCCCCC66E3234166666646B12A5A419A99999955E32341000000C0AF2A5A41000000002BE32341CDCCCCACAC2A5A419A999999F9E2234166666606A92A5A41	01060000206A080000010000000103000000010000000A0000009A999999F9E2234166666606A92A5A41333333332CE32341333333F3D82A5A41000000007CE323419A9999D93A2B5A410000000073E5234133333393262B5A419A9999994AE52341CDCCCCAC052B5A41000000000AE5234100000080C62A5A419A999999C2E42341CDCCCCECC12A5A41CDCCCCCC92E32341333333D3B32A5A419A999999F9E2234166666606A92A5A419A999999F9E2234166666606A92A5A41	01010000206A080000554BD92638E42341666666B6ED2A5A41	751135206	H	Croulebarbe 6	7511352	75113	75	11	0
01060000206A0800000100000001030000000100000028000000000000000AE5234100000080C62A5A410000000020E5234133333353DC2A5A41CDCCCCCC37E52341000000A0F22A5A41666666663EE52341333333B3F82A5A416666666646E5234166666626012B5A419A9999994AE52341CDCCCCAC052B5A41666666666FE52341666666A6222B5A410000000073E5234133333393262B5A4166666666ECE52341000000A0212B5A419A9999994CE62341CDCCCC8C1D2B5A419A9999995DE62341CDCCCC0C1D2B5A41333333336DE62341CDCCCCAC1C2B5A419A9999995BE72341CDCCCC2C172B5A41CDCCCCCC6EE723419A9999B9162B5A41CDCCCCCC7AE723419A999979162B5A413333333383E72341CDCCCC4C162B5A413333333368E8234133333333112B5A419A9999997CE8234133333313112B5A41CDCCCCCCB5E823419A999919102B5A4133333333D7E82341333333B30F2B5A419A99999915E923419A9999990E2B5A4100000000F8E82341000000200C2B5A419A999999D3E823419A9999B9092B5A41CDCCCCCCAEE82341000000A0072B5A416666666611E82341666666E6FE2A5A4166666666D8E7234133333393FB2A5A41CDCCCCCCBCE723419A9999F9F92A5A410000000039E72341CDCCCC2CF22A5A416666666628E7234133333333F12A5A416666666609E7234100000060EF2A5A41CDCCCCCCEFE52341CDCCCCECDE2A5A41CDCCCCCCDAE5234100000020DE2A5A4100000000B5E52341666666C6D42A5A41CDCCCCCCAEE523419A999999D32A5A4133333333A7E5234166666686D22A5A416666666685E52341CDCCCCACCE2A5A410000000076E5234100000020CD2A5A41CDCCCCCC6CE5234133333373CC2A5A419A99999965E523419A9999D9CB2A5A41000000000AE5234100000080C62A5A41	01060000206A080000010000000103000000010000000E000000000000000AE5234100000080C62A5A419A9999994AE52341CDCCCCAC052B5A410000000073E5234133333393262B5A419A9999994CE62341CDCCCC8C1D2B5A413333333368E8234133333333112B5A419A99999915E923419A9999990E2B5A419A999999D3E823419A9999B9092B5A416666666611E82341666666E6FE2A5A41CDCCCCCCEFE52341CDCCCCECDE2A5A41CDCCCCCCDAE5234100000020DE2A5A4100000000B5E52341666666C6D42A5A419A99999965E523419A9999D9CB2A5A41000000000AE5234100000080C62A5A41000000000AE5234100000080C62A5A41	01010000206A0800000DBDD08357E623419A9999A9F52A5A41	751135207	H	Croulebarbe 7	7511352	75113	75	11	0
01060000206A0800000100000001030000000100000039000000CDCCCCCCBEED2341333333D3412A5A41CDCCCCCCCFED234166666646412A5A41CDCCCCCCE3ED23419A9999D93F2A5A4100000000F4ED2341CDCCCC2C3E2A5A419A999999FEED2341000000203D2A5A41666666660CEE2341666666C63B2A5A410000000017EE2341666666063B2A5A419A99999923EE23419A9999993C2A5A416666666635EE2341333333D33E2A5A41000000006BEE234166666666452A5A41CDCCCCCCCEEE234133333393512A5A4133333333F8EE2341CDCCCCCC562A5A410000000011EF234100000080542A5A419A999999A4EF2341CDCCCCCC482A5A4100000000F8EF23419A999939422A5A416666666671F0234100000080382A5A416666666681F023419A999999372A5A416666666696F02341666666A6362A5A416666666699F0234133333373372A5A41666666669EF0234166666606382A5A4133333333A5F0234133333393382A5A41CDCCCCCCACF02341000000C0382A5A4100000000B4F02341000000C0382A5A4133333333BBF02341CDCCCC6C382A5A41CDCCCCCCC0F02341333333D3372A5A41CDCCCCCCC5F02341333333F3362A5A4100000000C8F02341CDCCCCCC352A5A41CDCCCCCCC7F0234133333393342A5A419A999999C4F0234133333393332A5A4166666666BEF02341CDCCCC8C322A5A419A999999C5F023419A9999592F2A5A4100000000DBF0234166666686282A5A4166666666FFF02341666666E61C2A5A416666666602F123419A9999F91B2A5A41333333332EF12341000000000E2A5A413333333332F12341CDCCCCAC0C2A5A416666666666F123419A999919FC295A41000000002CF12341000000A0FA295A41CDCCCCCCC5F023419A999939F8295A4100000000A4F02341CDCCCC6CF7295A4166666666D6EF23419A999959F2295A41CDCCCCCCC9EF234100000000F2295A41CDCCCCCCBBEF23419A999999F2295A4166666666B3EF2341CDCCCC4CF3295A419A999999AAEF23419A9999B9F4295A413333333364EF2341666666C6FF295A419A99999925EF2341CDCCCC0C0A2A5A416666666616EF2341000000E00C2A5A41CDCCCCCCE6EE234133333333142A5A413333333376EE23419A999979252A5A416666666641EE2341CDCCCC8C2D2A5A41CDCCCCCC21EE234166666666322A5A416666666612EE2341000000C0342A5A4133333333FFED23419A999999372A5A419A999999E0ED2341000000203C2A5A41CDCCCCCCCDED2341666666E63E2A5A41CDCCCCCCBEED2341333333D3412A5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCCBEED2341333333D3412A5A410000000017EE2341666666063B2A5A4133333333F8EE2341CDCCCCCC562A5A410000000011EF234100000080542A5A416666666671F0234100000080382A5A416666666696F02341666666A6362A5A4133333333BBF02341CDCCCC6C382A5A419A999999C5F023419A9999592F2A5A416666666666F123419A999919FC295A41CDCCCCCCC9EF234100000000F2295A4166666666B3EF2341CDCCCC4CF3295A416666666616EF2341000000E00C2A5A41CDCCCCCCBEED2341333333D3412A5A41CDCCCCCCBEED2341333333D3412A5A41	01010000206A0800007CD6880FC2EF234100000030212A5A41	751135027	H	Gare 27	7511350	75113	75	11	0
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	01060000206A080000020000000103000000010000000E0000000000000072ED2341CDCCCC0C052B5A41CDCCCCCCA1EE234166666606EE2A5A41CDCCCCCCE7EF234166666606CC2A5A4100000000C7F023419A999919DC2A5A416666666646F1234133333393E42A5A41000000005CF1234133333313E42A5A4166666666BEF123419A999979D22A5A41CDCCCCCCDDF12341333333B3D02A5A41CDCCCCCCBAEF2341333333D3AE2A5A4166666666ADEF2341333333D3B12A5A4166666666D3ED23419A9999D9F52A5A416666666656ED234166666606072B5A410000000072ED2341CDCCCC0C052B5A410000000072ED2341CDCCCC0C052B5A410103000000010000000C00000000000000F8F32341333333932B2B5A41666666660AF42341666666062F2B5A4100000000DDF42341333333B33E2B5A419A9999994DF52341666666862D2B5A41CDCCCCCCA3F52341666666A61D2B5A4100000000DEF42341CDCCCC6C0C2B5A41333333339CF423419A9999B9052B5A419A99999942F42341CDCCCC2C142B5A41CDCCCCCC4FF4234166666626192B5A41CDCCCCCCFAF32341CDCCCCAC282B5A4100000000F8F32341333333932B2B5A4100000000F8F32341333333932B2B5A41	01010000206A08000055E66DDAD3F4234133333333222B5A41	751134901	H	Salpêtrière 1	7511349	75113	75	11	0
01060000206A0800000100000001030000000100000024000000333333337AEC234133333313D02A5A4166666666BEEC234100000020E12A5A419A999999E6EC234166666626EB2A5A4100000000F7EC2341CDCCCC2CEF2A5A413333333311ED23419A9999B9F52A5A416666666656ED234166666606072B5A4166666666B0ED2341CDCCCCACFA2A5A41CDCCCCCCD1ED2341CDCCCC0CF62A5A4166666666D3ED23419A9999D9F52A5A41CDCCCCCC67EF2341333333D3BB2A5A41CDCCCCCC83EF2341666666C6B72A5A4166666666ADEF2341333333D3B12A5A41CDCCCCCCBAEF2341333333D3AE2A5A4133333333B2EF2341CDCCCC4CAE2A5A4166666666A6EF2341CDCCCC8CAD2A5A416666666616EF2341333333B3A42A5A419A99999911EF23419A999959A42A5A4133333333CEEE2341CDCCCC2CA02A5A4133333333C2EE23419A999999A32A5A4166666666ACEE23419A999939AA2A5A41CDCCCCCCA1EE2341666666E6A92A5A41CDCCCCCC97EE234100000000AA2A5A41666666668FEE234100000060AA2A5A413333333387EE234166666626AB2A5A416666666681EE234166666626AC2A5A41CDCCCCCC7DEE234100000060AD2A5A419A9999997DEE23419A9999B9AE2A5A41CDCCCCCC7FEE2341CDCCCCCCAF2A5A419A9999995CEE2341000000E0B12A5A416666666631EE2341000000A0B42A5A4166666666EEED2341CDCCCCECB82A5A4100000000A7ED234133333373BD2A5A419A999999A3ED2341333333B3BD2A5A41666666666DED2341CDCCCC0CC12A5A4100000000A2EC2341000000A0CD2A5A41333333337AEC234133333313D02A5A41	01060000206A080000010000000103000000010000000B000000333333337AEC234133333313D02A5A416666666656ED234166666606072B5A4166666666D3ED23419A9999D9F52A5A4166666666ADEF2341333333D3B12A5A41CDCCCCCCBAEF2341333333D3AE2A5A4133333333CEEE2341CDCCCC2CA02A5A4166666666ACEE23419A999939AA2A5A413333333387EE234166666626AB2A5A41CDCCCCCC7FEE2341CDCCCCCCAF2A5A41333333337AEC234133333313D02A5A41333333337AEC234133333313D02A5A41	01010000206A08000030EF11C79DED23419A999999D82A5A41	751134902	H	Salpêtrière 2	7511349	75113	75	11	0
01060000206A080000010000000103000000010000002F000000000000002CEB2341000000C0792A5A41333333334BEB234100000000852A5A410000000057EB23419A9999F9872A5A413333333366EB23419A9999B98B2A5A410000000075EB23419A9999F98E2A5A419A9999997BEB2341CDCCCCAC902A5A419A999999B3EB23419A9999999E2A5A4166666666CCEB2341666666C6A42A5A419A999999DDEB2341CDCCCC0CA92A5A4166666666E6EB234100000040AB2A5A410000000076EC234133333313CF2A5A41333333337AEC234133333313D02A5A4100000000A2EC2341000000A0CD2A5A41666666666DED2341CDCCCC0CC12A5A419A999999A3ED2341333333B3BD2A5A4100000000A7ED234133333373BD2A5A4166666666EEED2341CDCCCCECB82A5A416666666631EE2341000000A0B42A5A419A9999995CEE2341000000E0B12A5A41CDCCCCCC7FEE2341CDCCCCCCAF2A5A419A9999997DEE23419A9999B9AE2A5A41CDCCCCCC7DEE234100000060AD2A5A416666666681EE234166666626AC2A5A413333333387EE234166666626AB2A5A41666666668FEE234100000060AA2A5A41CDCCCCCC97EE234100000000AA2A5A41CDCCCCCCA1EE2341666666E6A92A5A4166666666ACEE23419A999939AA2A5A4133333333C2EE23419A999999A32A5A4133333333CEEE2341CDCCCC2CA02A5A419A99999993EE2341000000809C2A5A419A99999944EE2341CDCCCCAC972A5A41CDCCCCCCCDED234100000060902A5A419A999999BDED2341000000608F2A5A419A99999969ED2341333333338A2A5A41666666662EED2341CDCCCC8C862A5A410000000025ED234100000020862A5A416666666609ED23419A999959842A5A41CDCCCCCC94EC2341666666867C2A5A4166666666FCEB23419A999979732A5A41CDCCCCCCFCEB234133333353732A5A416666666608EC234133333393702A5A419A999999F9EB2341000000006F2A5A41000000008EEB234100000080682A5A41CDCCCCCC7BEB2341CDCCCC4C6C2A5A41333333337DEB2341666666C6702A5A41000000002CEB2341000000C0792A5A41	01060000206A080000010000000103000000010000000F000000000000002CEB2341000000C0792A5A41333333334BEB234100000000852A5A41333333337AEC234133333313D02A5A41CDCCCCCC7FEE2341CDCCCCCCAF2A5A413333333387EE234166666626AB2A5A4166666666ACEE23419A999939AA2A5A4133333333CEEE2341CDCCCC2CA02A5A416666666609ED23419A999959842A5A41CDCCCCCC94EC2341666666867C2A5A4166666666FCEB23419A999979732A5A419A999999F9EB2341000000006F2A5A41000000008EEB234100000080682A5A41333333337DEB2341666666C6702A5A41000000002CEB2341000000C0792A5A41000000002CEB2341000000C0792A5A41	01010000206A080000E895C1C606ED2341666666169A2A5A41	751134903	H	Salpêtrière 3	7511349	75113	75	11	0
01060000206A080000010000000103000000010000001200000033333333B5EA23419A999939D82A5A419A999999DDEA2341333333D3DB2A5A410000000052EB23419A999919E72A5A419A99999980EB234133333393EA2A5A41666666669CEB2341666666A6EC2A5A41333333339AEC234100000000002B5A4133333333C7EC2341CDCCCC6C032B5A4166666666F2EC234166666686F72A5A413333333311ED23419A9999B9F52A5A4100000000F7EC2341CDCCCC2CEF2A5A419A999999E6EC234166666626EB2A5A4166666666BEEC234100000020E12A5A41333333337AEC234133333313D02A5A410000000076EC234133333313CF2A5A4166666666E6EB234100000040AB2A5A416666666645EB234133333393C22A5A410000000031EB2341CDCCCC8CC52A5A4133333333B5EA23419A999939D82A5A41	01060000206A080000010000000103000000010000000900000033333333B5EA23419A999939D82A5A410000000052EB23419A999919E72A5A4133333333C7EC2341CDCCCC6C032B5A4166666666F2EC234166666686F72A5A413333333311ED23419A9999B9F52A5A4166666666E6EB234100000040AB2A5A410000000031EB2341CDCCCC8CC52A5A4133333333B5EA23419A999939D82A5A4133333333B5EA23419A999939D82A5A41	01010000206A080000CCCE615BADEB234166666626D42A5A41	751134904	H	Salpêtrière 4	7511349	75113	75	11	0
01060000206A08000001000000010300000001000000310000009A99999915E923419A9999990E2B5A419A9999998CE9234100000060152B5A4166666666C2E92341CDCCCC8C182B5A4100000000CCE92341333333F3152B5A419A9999990FEA2341333333F3032B5A419A999999DFE9234100000080FE2A5A416666666622EA2341CDCCCC8CF42A5A419A99999962EA234100000060EB2A5A41CDCCCCCCAEEA2341000000C0F52A5A4100000000B8EA23419A9999D9F72A5A4100000000CCEA234166666646002B5A4133333333EFEA2341CDCCCCCCFD2A5A41CDCCCCCC9AEB2341333333130A2B5A416666666675EC2341333333B3192B5A4133333333C7EC2341CDCCCC6C032B5A41333333339AEC234100000000002B5A41666666669CEB2341666666A6EC2A5A419A99999980EB234133333393EA2A5A410000000052EB23419A999919E72A5A419A999999DDEA2341333333D3DB2A5A4133333333B5EA23419A999939D82A5A410000000031EB2341CDCCCC8CC52A5A416666666645EB234133333393C22A5A4166666666E6EB234100000040AB2A5A419A999999DDEB2341CDCCCC0CA92A5A4166666666CCEB2341666666C6A42A5A419A999999B3EB23419A9999999E2A5A419A9999997BEB2341CDCCCCAC902A5A410000000075EB23419A9999F98E2A5A413333333366EB23419A9999B98B2A5A410000000057EB23419A9999F9872A5A41333333334BEB234100000000852A5A41000000002CEB2341000000C0792A5A410000000005EB23419A9999F9842A5A4166666666F9EA2341333333B3872A5A4133333333DFEA23419A9999598E2A5A4100000000D4EA234133333333912A5A41CDCCCCCC9EEA234166666666A02A5A41666666667CEA2341CDCCCC2CAA2A5A416666666667EA2341CDCCCC2CB02A5A416666666633EA234133333313BF2A5A41666666660AEA2341000000C0CA2A5A41CDCCCCCCEDE92341666666E6D22A5A419A999999D6E9234100000080D92A5A4100000000C5E92341333333D3DC2A5A4100000000A5E92341000000A0E42A5A416666666671E923419A999999F32A5A410000000021E92341333333530A2B5A419A99999915E923419A9999990E2B5A41	01060000206A08000001000000010300000001000000160000009A99999915E923419A9999990E2B5A4166666666C2E92341CDCCCC8C182B5A419A9999990FEA2341333333F3032B5A419A999999DFE9234100000080FE2A5A419A99999962EA234100000060EB2A5A41CDCCCCCCAEEA2341000000C0F52A5A4100000000CCEA234166666646002B5A4133333333EFEA2341CDCCCCCCFD2A5A416666666675EC2341333333B3192B5A4133333333C7EC2341CDCCCC6C032B5A410000000052EB23419A999919E72A5A4133333333B5EA23419A999939D82A5A410000000031EB2341CDCCCC8CC52A5A4166666666E6EB234100000040AB2A5A41333333334BEB234100000000852A5A41000000002CEB2341000000C0792A5A4100000000D4EA234133333333912A5A419A999999D6E9234100000080D92A5A4100000000A5E92341000000A0E42A5A410000000021E92341333333530A2B5A419A99999915E923419A9999990E2B5A419A99999915E923419A9999990E2B5A41	01010000206A080000182DBAA599EA234166666626C82A5A41	751134905	H	Salpêtrière 5	7511349	75113	75	11	0
01060000206A080000010000000103000000010000001800000066666666C2E92341CDCCCC8C182B5A41333333338CEA234166666666242B5A41CDCCCCCC12EB2341CDCCCC4C2C2B5A419A9999996FEB2341000000C0312B5A41000000000DEC23419A9999393B2B5A413333333311EC23419A9999793B2B5A419A99999919EC2341666666C6382B5A41333333331BEC23419A999979372B5A41CDCCCCCC1DEC234133333353352B5A41CDCCCCCC2FEC2341666666A62E2B5A413333333343EC234133333333282B5A416666666648EC2341CDCCCC8C262B5A416666666675EC2341333333B3192B5A41CDCCCCCC9AEB2341333333130A2B5A4133333333EFEA2341CDCCCCCCFD2A5A4100000000CCEA234166666646002B5A4100000000B8EA23419A9999D9F72A5A41CDCCCCCCAEEA2341000000C0F52A5A419A99999962EA234100000060EB2A5A416666666622EA2341CDCCCC8CF42A5A419A999999DFE9234100000080FE2A5A419A9999990FEA2341333333F3032B5A4100000000CCE92341333333F3152B5A4166666666C2E92341CDCCCC8C182B5A41	01060000206A080000010000000103000000010000000D00000066666666C2E92341CDCCCC8C182B5A419A9999996FEB2341000000C0312B5A413333333311EC23419A9999793B2B5A416666666648EC2341CDCCCC8C262B5A416666666675EC2341333333B3192B5A4133333333EFEA2341CDCCCCCCFD2A5A4100000000CCEA234166666646002B5A41CDCCCCCCAEEA2341000000C0F52A5A419A99999962EA234100000060EB2A5A419A999999DFE9234100000080FE2A5A419A9999990FEA2341333333F3032B5A4166666666C2E92341CDCCCC8C182B5A4166666666C2E92341CDCCCC8C182B5A41	01010000206A0800004D835315E8EA234133333303102B5A41	751134906	H	Salpêtrière 6	7511349	75113	75	11	0
01060000206A080000010000000103000000010000001B0000003333333311EC23419A9999793B2B5A410000000081EC2341CDCCCC2C422B5A4166666666F2EC2341333333F3482B5A416666666648ED23419A9999194E2B5A41CDCCCCCCA5ED2341CDCCCCAC532B5A419A99999939EE23419A9999395C2B5A41CDCCCCCCC4EE2341CDCCCC4C642B5A4166666666BDEE2341333333B3612B5A4166666666ADEE23419A9999795C2B5A410000000088EE234133333333532B5A413333333364EE2341CDCCCCCC4A2B5A41CDCCCCCC55EE234133333333472B5A41CDCCCCCC3BEE2341CDCCCCAC402B5A4133333333C1ED2341333333D3212B5A410000000078ED2341CDCCCC6C0F2B5A416666666656ED234166666606072B5A413333333311ED23419A9999B9F52A5A4166666666F2EC234166666686F72A5A4133333333C7EC2341CDCCCC6C032B5A416666666675EC2341333333B3192B5A416666666648EC2341CDCCCC8C262B5A413333333343EC234133333333282B5A41CDCCCCCC2FEC2341666666A62E2B5A41CDCCCCCC1DEC234133333353352B5A41333333331BEC23419A999979372B5A419A99999919EC2341666666C6382B5A413333333311EC23419A9999793B2B5A41	01060000206A080000010000000103000000010000000A0000003333333311EC23419A9999793B2B5A41CDCCCCCCA5ED2341CDCCCCAC532B5A41CDCCCCCCC4EE2341CDCCCC4C642B5A4166666666ADEE23419A9999795C2B5A413333333364EE2341CDCCCCCC4A2B5A413333333311ED23419A9999B9F52A5A4166666666F2EC234166666686F72A5A416666666648EC2341CDCCCC8C262B5A413333333311EC23419A9999793B2B5A413333333311EC23419A9999793B2B5A41	01010000206A0800001252EF6C10ED2341CCCCCC6C2B2B5A41	751134907	H	Salpêtrière 7	7511349	75113	75	11	0
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	01060000206A08000001000000010300000001000000200000006666666656ED234166666606072B5A413333333364EE2341CDCCCCCC4A2B5A4166666666ADEE23419A9999795C2B5A4100000000C9EE2341333333B3652B5A41000000006CEF2341666666A68C2B5A41CDCCCCCC2CF0234100000020BE2B5A419A9999999BF02341CDCCCCCCD72B5A41CDCCCCCCB4F0234166666606D52B5A4166666666E9F023419A999919CA2B5A410000000066F12341333333B3BB2B5A419A999999BEF12341CDCCCCCCAD2B5A4100000000E5F22341CDCCCC6C842B5A419A99999904F32341333333D3802B5A419A99999951F42341000000E0512B5A4100000000DDF42341333333B33E2B5A41666666660AF42341666666062F2B5A41CDCCCCCCFAF32341CDCCCCAC282B5A41CDCCCCCC4FF4234166666626192B5A419A99999942F42341CDCCCC2C142B5A41333333339CF423419A9999B9052B5A41CDCCCCCC1BF423419A999999F82A5A41000000004CF323419A999999E72A5A41CDCCCCCCFCF2234166666646E22A5A41CDCCCCCCDDF12341333333B3D02A5A4166666666BEF123419A999979D22A5A41000000005CF1234133333313E42A5A416666666646F1234133333393E42A5A4100000000C7F023419A999919DC2A5A41CDCCCCCCE7EF234166666606CC2A5A41CDCCCCCCA1EE234166666606EE2A5A416666666656ED234166666606072B5A416666666656ED234166666606072B5A41	01010000206A08000063843E2269F123419A999989522B5A41	751134908	A	Salpêtrière 8	7511349	75113	75	11	1
01060000206A08000001000000010300000001000000410000009A9999999BF02341CDCCCCCCD72B5A41000000009FF023419A999999D82B5A419A999999A4F02341333333F3D92B5A419A999999A5F02341CDCCCC2CDA2B5A4100000000AAF0234133333353DB2B5A4133333333B0F023419A9999D9DC2B5A4100000000BCF02341333333D3DF2B5A4133333333BDF0234100000020E02B5A41CDCCCCCCCCF02341666666C6E12B5A4133333333D7F023419A9999D9E22B5A419A99999921F123419A9999B9EA2B5A41333333334BF1234166666666EF2B5A419A99999957F22341333333B3C82B5A4166666666FAF2234133333333B12B5A410000000011F32341333333F3AD2B5A413333333381F42341333333D3782B5A41CDCCCCCCE8F423419A999959692B5A41000000002EF52341CDCCCC0C5F2B5A419A99999988F52341CDCCCC8C512B5A41CDCCCCCC3BF6234133333313302B5A410000000047F62341CDCCCCEC2D2B5A419A999999CAF5234100000040212B5A41CDCCCCCCA3F52341666666A61D2B5A41000000009DF52341000000E01E2B5A413333333394F5234166666686202B5A413333333382F52341000000E0232B5A41000000005DF52341666666C62A2B5A419A9999994DF52341666666862D2B5A419A9999993FF52341666666C62F2B5A416666666618F523419A9999F9352B5A419A999999FEF42341666666C6392B5A41CDCCCCCCEFF42341333333133C2B5A4100000000DDF42341333333B33E2B5A419A99999951F42341000000E0512B5A41CDCCCCCC3AF423419A999939552B5A416666666614F42341666666A65A2B5A41CDCCCCCCE7F32341CDCCCC0C612B5A41CDCCCCCC92F32341CDCCCCEC6C2B5A413333333341F3234166666686782B5A41CDCCCCCC12F32341CDCCCCEC7E2B5A419A99999904F32341333333D3802B5A41CDCCCCCCF3F22341333333D3822B5A4100000000E5F22341CDCCCC6C842B5A4100000000D5F22341666666A6862B5A41CDCCCCCCB5F223419A9999198B2B5A416666666694F223419A9999B98F2B5A416666666661F22341666666E6962B5A41000000004AF223419A9999399A2B5A41CDCCCCCC3BF22341000000409C2B5A416666666620F2234133333313A02B5A413333333314F22341000000C0A12B5A4133333333FDF123419A9999F9A42B5A4133333333D2F1234100000020AB2B5A419A999999BEF12341CDCCCCCCAD2B5A4166666666A7F1234166666646B22B5A419A9999999CF12341333333D3B32B5A419A99999992F1234100000040B52B5A410000000066F12341333333B3BB2B5A419A99999951F12341CDCCCC4CBE2B5A41666666661EF12341666666A6C42B5A4166666666FCF0234100000060C82B5A4166666666E9F023419A999919CA2B5A4166666666C6F023419A999979D02B5A41CDCCCCCCB4F0234166666606D52B5A419A9999999BF02341CDCCCCCCD72B5A41	01060000206A08000001000000010300000001000000120000009A9999999BF02341CDCCCCCCD72B5A4133333333BDF0234100000020E02B5A41333333334BF1234166666666EF2B5A413333333381F42341333333D3782B5A419A99999988F52341CDCCCC8C512B5A410000000047F62341CDCCCCEC2D2B5A41CDCCCCCCA3F52341666666A61D2B5A419A9999994DF52341666666862D2B5A41CDCCCCCCEFF42341333333133C2B5A419A99999951F42341000000E0512B5A419A99999904F32341333333D3802B5A4100000000E5F22341CDCCCC6C842B5A419A999999BEF12341CDCCCCCCAD2B5A410000000066F12341333333B3BB2B5A4166666666E9F023419A999919CA2B5A41CDCCCCCCB4F0234166666606D52B5A419A9999999BF02341CDCCCCCCD72B5A419A9999999BF02341CDCCCCCCD72B5A41	01010000206A0800006892C30B83F323419A999989852B5A41	751134999	D	Seine et Berges 1	7511349	75113	75	11	0
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	01060000206A080000010000000103000000010000000E0000009A999999CBF423419A99997963295A413333333331F523419A9999B987295A41CDCCCCCCF5F52341CDCCCC4C94295A416666666657F7234100000000AA295A413333333377F72341CDCCCCECA5295A41CDCCCCCC40F823410000004070295A410000000095F82341666666A657295A4133333333E4F72341333333534D295A4133333333ABF623410000008039295A4100000000A6F623419A9999394C295A41CDCCCCCC33F623410000002072295A41000000003CF52341CDCCCC2C67295A419A999999CBF423419A99997963295A419A999999CBF423419A99997963295A41	01010000206A08000055FF36033AF723410000003071295A41	751135001	H	Gare 1	7511350	75113	75	11	0
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	01060000206A08000001000000010300000001000000140000009A99999958F023419A9999B939295A4100000000FBF123410000000053295A4100000000D7F223419A99991961295A41CDCCCCCC31F323410000002068295A419A999999F2F32341CDCCCC6C74295A413333333331F523419A9999B987295A419A999999CBF423419A99997963295A41000000003CF52341CDCCCC2C67295A41CDCCCCCC33F623410000002072295A4100000000A6F623419A9999394C295A419A999999ABF62341333333133D295A41333333339FF623419A9999F938295A4166666666FEF52341000000402F295A4166666666DAF42341CDCCCCAC1E295A419A99999936F423410000008014295A41000000000EF323410000008003295A410000000095F12341000000C0EC285A4133333333DAF02341333333B31A295A419A99999958F023419A9999B939295A419A99999958F023419A9999B939295A41	01010000206A08000051BA20878FF32341000000803B295A41	751135002	H	Gare 2	7511350	75113	75	11	0
01060000206A08000001000000010300000001000000250000006666666673EF23413333339372295A419A999999A4EF23419A9999F976295A419A99999922F02341333333B382295A419A99999945F023419A9999D985295A413333333362F023413333339388295A4133333333CDF023413333339392295A419A999999E9F02341000000C095295A413333333349F12341666666868C295A41666666665AF12341666666C68A295A41000000005FF12341333333538A295A41666666669AF123416666668684295A41CDCCCCCCAFF123419A99997982295A41CDCCCCCCCDF12341CDCCCC8C7F295A41CDCCCCCCD4F12341000000E07E295A4133333333E0F12341666666C67D295A41CDCCCCCCEFF12341000000407C295A416666666667F123419A99991976295A416666666687F12341666666066B295A4100000000A4F12341666666C660295A4166666666C8F123419A9999F953295A4100000000D2F12341CDCCCC8C50295A4100000000AEF12341666666664E295A416666666663F12341333333F349295A41333333331BF12341666666A645295A41CDCCCCCCBEF023419A99991940295A419A99999958F023419A9999B939295A413333333349F023419A9999793D295A419A9999993BF023410000004041295A41333333331CF023410000000049295A4100000000ECEF23410000006055295A4133333333DCEF23416666660659295A4100000000CBEF2341333333335D295A41CDCCCCCCB3EF2341333333F362295A41CDCCCCCC9BEF2341333333B368295A41333333338CEF23419A9999996C295A41666666667EEF2341333333D36F295A416666666673EF23413333339372295A41	01060000206A080000010000000103000000010000000A0000006666666673EF23413333339372295A4133333333CDF023413333339392295A419A999999E9F02341000000C095295A41CDCCCCCCEFF12341000000407C295A416666666667F123419A99991976295A4100000000D2F12341CDCCCC8C50295A419A99999958F023419A9999B939295A4100000000ECEF23410000006055295A416666666673EF23413333339372295A416666666673EF23413333339372295A41	01010000206A080000AC4DC9DA9EF02341333333D365295A41	751135003	H	Gare 3	7511350	75113	75	11	0
01060000206A080000010000000103000000010000000E0000006666666667F123419A99991976295A41CDCCCCCCEFF12341000000407C295A4166666666D5F22341CDCCCC2C66295A419A999999F1F223419A99995963295A4100000000D7F223419A99991961295A4100000000BBF22341666666265F295A419A9999997DF223419A9999195B295A41333333333EF223410000004057295A4100000000FBF123410000000053295A4100000000D2F12341CDCCCC8C50295A4166666666C8F123419A9999F953295A4100000000A4F12341666666C660295A416666666687F12341666666066B295A416666666667F123419A99991976295A41	01060000206A08000001000000010300000001000000070000006666666667F123419A99991976295A41CDCCCCCCEFF12341000000407C295A419A999999F1F223419A99995963295A419A9999997DF223419A9999195B295A4100000000D2F12341CDCCCC8C50295A416666666667F123419A99991976295A416666666667F123419A99991976295A41	01010000206A08000086EC0C2C25F223419A99999968295A41	751135004	H	Gare 4	7511350	75113	75	11	0
01060000206A080000010000000103000000010000003E0000003333333383F22341CDCCCCCC94295A4100000000D0F22341666666669A295A4166666666D6F22341333333D39C295A410000000056F32341666666A6A6295A41000000009FF3234100000040AC295A4133333333B2F32341CDCCCC8CA6295A4133333333E9F323416666664696295A41CDCCCCCC28F423410000004098295A4166666666D2F42341666666669D295A4166666666D7F42341CDCCCC8C9D295A410000000066F523419A9999B9A1295A4100000000ADF52341CDCCCCACA3295A419A999999FEF5234100000040A6295A41000000004CF62341CDCCCCACA8295A41333333337DF6234166666666AA295A413333333394F6234166666686AB295A4100000000A0F6234133333393AB295A4133333333C1F6234166666646AD295A4133333333EFF623419A999919B0295A41CDCCCCCC12F7234166666666B2295A41CDCCCCCC1FF7234166666606B1295A413333333327F72341CDCCCC0CB0295A41CDCCCCCC36F7234100000040AE295A419A9999994AF72341333333D3AB295A416666666657F7234100000000AA295A419A99999937F72341CDCCCC0CA8295A41333333330BF7234133333353A5295A419A999999E2F62341000000E0A2295A41CDCCCCCCBEF62341333333B3A0295A41333333339BF62341333333939E295A410000000073F62341CDCCCC0C9C295A413333333348F623416666666699295A41333333331DF623419A9999B996295A41CDCCCCCCF5F52341CDCCCC4C94295A419A999999D0F52341000000E091295A4166666666A8F52341CDCCCC4C8F295A41666666667DF52341666666A68C295A419A99999955F52341333333138A295A413333333331F523419A9999B987295A41333333332FF523419A99999987295A41333333330DF523419A99999985295A419A999999ECF423413333339383295A4133333333C9F423413333337381295A4133333333A6F42341333333537F295A419A9999997DF42341000000E07C295A41666666664DF42341666666E679295A419A9999991DF423410000000077295A419A999999F2F32341CDCCCC6C74295A41CDCCCCCCC2F323410000006071295A41333333339AF32341000000C06E295A416666666675F323419A9999596C295A410000000054F32341666666466A295A41CDCCCCCC31F323410000002068295A41000000001FF32341333333D366295A41CDCCCCCC08F323419A99991965295A419A999999F1F223419A99995963295A41CDCCCCCCFCF223416666662666295A419A99999902F323419A9999B968295A41CDCCCCCCB0F223413333333386295A4133333333A7F223419A9999B989295A41000000008AF22341CDCCCCAC92295A413333333383F22341CDCCCCCC94295A41	01060000206A08000001000000010300000001000000120000003333333383F22341CDCCCCCC94295A4100000000D0F22341666666669A295A4166666666D6F22341333333D39C295A41000000009FF3234100000040AC295A4133333333E9F323416666664696295A4100000000ADF52341CDCCCCACA3295A4100000000A0F6234133333393AB295A41CDCCCCCC12F7234166666666B2295A416666666657F7234100000000AA295A41CDCCCCCCF5F52341CDCCCC4C94295A41333333332FF523419A99999987295A419A999999F2F32341CDCCCC6C74295A41CDCCCCCC31F323410000002068295A419A999999F1F223419A99995963295A419A99999902F323419A9999B968295A4133333333A7F223419A9999B989295A413333333383F22341CDCCCCCC94295A413333333383F22341CDCCCCCC94295A41	01010000206A080000D4EEC3AD05F42341CCCCCC5C8B295A41	751135009	H	Gare 9	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001A0000006666666666F123419A999919FC295A4166666666C2F123419A999959FE295A4133333333F6F12341CDCCCC8CFF295A419A99999991F2234166666626032A5A419A999999AAF223419A999979FD295A4166666666FBF223419A999959E1295A41CDCCCCCCFFF223419A9999F9DF295A41CDCCCCCC14F32341000000E0D8295A413333333318F32341666666C6D7295A416666666637F3234100000060CD295A410000000049F3234133333393C7295A416666666660F32341333333D3BF295A419A9999996CF32341CDCCCCECBB295A41CDCCCCCC92F323419A9999F9AF295A41000000009FF3234100000040AC295A410000000056F32341666666A6A6295A4166666666D6F22341333333D39C295A4100000000D0F22341666666669A295A413333333383F22341CDCCCCCC94295A419A99999978F223419A99991998295A41CDCCCCCC4FF22341CDCCCCECA6295A413333333345F22341333333D3AA295A41CDCCCCCC27F2234100000080B5295A4100000000E7F123419A999919CD295A419A999999A9F1234100000080E3295A416666666666F123419A999919FC295A41	01060000206A080000010000000103000000010000000C0000006666666666F123419A999919FC295A419A99999991F2234166666626032A5A419A999999AAF223419A999979FD295A4166666666FBF223419A999959E1295A416666666660F32341333333D3BF295A41000000009FF3234100000040AC295A4166666666D6F22341333333D39C295A4100000000D0F22341666666669A295A413333333383F22341CDCCCCCC94295A419A99999978F223419A99991998295A416666666666F123419A999919FC295A416666666666F123419A999919FC295A41	01010000206A0800007599E89997F2234166666656CA295A41	751135010	H	Gare 10	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001B0000009A99999991F2234166666626032A5A41CDCCCCCCE9F2234133333393052A5A4166666666F2F22341CDCCCCCC052A5A41333333339FF32341CDCCCC0C0A2A5A413333333300F423419A999999F3295A410000000073F42341000000C0D9295A419A99999996F42341333333D3D1295A4133333333D1F42341CDCCCC2CC4295A413333333353F5234100000020A6295A410000000066F523419A9999B9A1295A4166666666D7F42341CDCCCC8C9D295A4166666666D2F42341666666669D295A41CDCCCCCC28F423410000004098295A4133333333E9F323416666664696295A4133333333B2F32341CDCCCC8CA6295A41000000009FF3234100000040AC295A41CDCCCCCC92F323419A9999F9AF295A419A9999996CF32341CDCCCCECBB295A416666666660F32341333333D3BF295A410000000049F3234133333393C7295A416666666637F3234100000060CD295A413333333318F32341666666C6D7295A41CDCCCCCC14F32341000000E0D8295A41CDCCCCCCFFF223419A9999F9DF295A4166666666FBF223419A999959E1295A419A999999AAF223419A999979FD295A419A99999991F2234166666626032A5A41	01060000206A080000010000000103000000010000000B0000009A99999991F2234166666626032A5A41333333339FF32341CDCCCC0C0A2A5A413333333300F423419A999999F3295A419A99999996F42341333333D3D1295A410000000066F523419A9999B9A1295A4133333333E9F323416666664696295A416666666660F32341333333D3BF295A4166666666FBF223419A999959E1295A419A999999AAF223419A999979FD295A419A99999991F2234166666626032A5A419A99999991F2234166666626032A5A41	01010000206A0800001E044270E8F323419A999999CF295A41	751135011	H	Gare 11	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000019000000333333339FF32341CDCCCC0C0A2A5A4166666666EBF32341666666E60B2A5A413333333336F42341000000C00D2A5A413333333357F423419A999999092A5A41CDCCCCCC39F5234166666626ED295A410000000067F523419A999979E7295A413333333307F623419A999959D3295A410000000039F6234100000020CD295A419A99999956F62341CDCCCC6CC9295A41CDCCCCCC12F7234166666666B2295A4133333333EFF623419A999919B0295A4133333333C1F6234166666646AD295A4100000000A0F6234133333393AB295A413333333394F6234166666686AB295A41333333337DF6234166666666AA295A41000000004CF62341CDCCCCACA8295A419A999999FEF5234100000040A6295A4100000000ADF52341CDCCCCACA3295A410000000066F523419A9999B9A1295A413333333353F5234100000020A6295A4133333333D1F42341CDCCCC2CC4295A419A99999996F42341333333D3D1295A410000000073F42341000000C0D9295A413333333300F423419A999999F3295A41333333339FF32341CDCCCC0C0A2A5A41	01060000206A080000010000000103000000010000000A000000333333339FF32341CDCCCC0C0A2A5A413333333336F42341000000C00D2A5A419A99999956F62341CDCCCC6CC9295A41CDCCCCCC12F7234166666666B2295A4100000000A0F6234133333393AB295A410000000066F523419A9999B9A1295A419A99999996F42341333333D3D1295A413333333300F423419A999999F3295A41333333339FF32341CDCCCC0C0A2A5A41333333339FF32341CDCCCC0C0A2A5A41	01010000206A080000BC4C0D8D37F52341CDCCCC8CD6295A41	751135012	H	Gare 12	7511350	75113	75	11	0
01060000206A080000010000000103000000010000003200000000000000DDF52341333333D3FC295A41000000001EF623419A999939FA295A41CDCCCCCC4FF6234166666646F8295A41CDCCCCCC8AF62341CDCCCCACF5295A419A999999D0F623419A9999B9F2295A413333333318F72341333333D3EF295A41666666665CF7234133333313ED295A41CDCCCCCCA0F7234100000060EA295A4100000000B5F7234100000060E9295A419A999999BDF7234133333393E7295A41CDCCCCCCC0F72341CDCCCC4CE5295A4100000000ECF7234100000000E6295A410000000004F82341CDCCCC4CE6295A41CDCCCCCC12F8234100000060E5295A41CDCCCCCC1CF8234133333393E3295A419A99999933F8234133333373E1295A419A9999994EF823419A999979DE295A419A9999996CF823419A9999B9DA295A41CDCCCCCC89F823419A999919D7295A4166666666A9F8234166666626D3295A4166666666BCF82341CDCCCC6CD0295A4100000000C5F8234100000080CE295A413333333382F82341CDCCCC4CCA295A41CDCCCCCC2DF8234166666626C5295A410000000022F82341333333D3C4295A416666666618F823419A9999D9C4295A41333333330AF82341333333F3C4295A410000000008F8234166666686C4295A41CDCCCCCCF7F72341333333B3C2295A4133333333ECF72341000000C0C1295A419A999999E3F7234100000000C1295A4166666666AFF72341CDCCCCCCBD295A419A9999997AF7234100000080BA295A410000000075F7234166666606BA295A41000000006AF7234100000060B8295A416666666663F723419A999999B7295A410000000026F72341000000C0B3295A41CDCCCCCC12F7234166666666B2295A419A99999956F62341CDCCCC6CC9295A410000000039F6234100000020CD295A413333333307F623419A999959D3295A41CDCCCCCC24F62341CDCCCC8CD4295A41CDCCCCCC25F62341000000C0D9295A413333333325F6234166666626DE295A413333333324F62341CDCCCCECDF295A413333333322F6234133333393E1295A41CDCCCCCC1BF62341CDCCCC8CE4295A410000000015F6234166666646E7295A419A99999905F623419A9999D9EC295A4100000000DDF52341333333D3FC295A41	01060000206A080000010000000103000000010000001200000000000000DDF52341333333D3FC295A4100000000B5F7234100000060E9295A41CDCCCCCCC0F72341CDCCCC4CE5295A410000000004F82341CDCCCC4CE6295A419A9999994EF823419A999979DE295A4166666666A9F8234166666626D3295A4100000000C5F8234100000080CE295A41CDCCCCCC2DF8234166666626C5295A41333333330AF82341333333F3C4295A419A999999E3F7234100000000C1295A419A9999997AF7234100000080BA295A416666666663F723419A999999B7295A41CDCCCCCC12F7234166666666B2295A413333333307F623419A999959D3295A41CDCCCCCC24F62341CDCCCC8CD4295A413333333322F6234133333393E1295A4100000000DDF52341333333D3FC295A4100000000DDF52341333333D3FC295A41	01010000206A080000FD01075652F72341CDCCCC6CD8295A41	751135013	H	Gare 13	7511350	75113	75	11	0
01060000206A08000001000000010300000001000000360000003333333336F42341000000C00D2A5A41333333331AF52341333333B3232A5A4133333333D8F5234166666646372A5A413333333364F62341666666C6452A5A413333333379F62341666666E6472A5A413333333386F6234166666646492A5A41000000008EF623419A999939472A5A413333333391F62341CDCCCC6C462A5A41CDCCCCCC96F623419A999919452A5A4100000000A1F62341CDCCCC4C472A5A41CDCCCCCCCAF62341666666E63C2A5A4166666666DAF62341333333F3382A5A4166666666ECF623419A9999F9332A5A4166666666F5F62341CDCCCC8C312A5A419A9999991AF7234166666606272A5A410000000025F7234133333393232A5A413333333328F72341666666A6222A5A419A9999993EF72341666666A61B2A5A413333333355F723419A9999F9142A5A419A99999967F72341333333730F2A5A416666666669F72341333333D30E2A5A410000000071F723419A9999390C2A5A41666666667EF72341CDCCCCEC082A5A416666666696F7234166666686022A5A4166666666AAF72341000000C0FD295A41CDCCCCCCDCF72341666666A6F1295A416666666602F82341000000C0E8295A410000000004F82341333333B3E7295A410000000004F82341CDCCCC4CE6295A4100000000ECF7234100000000E6295A41CDCCCCCCC0F72341CDCCCC4CE5295A419A999999BDF7234133333393E7295A4100000000B5F7234100000060E9295A41CDCCCCCCA0F7234100000060EA295A41666666665CF7234133333313ED295A413333333318F72341333333D3EF295A419A999999D0F623419A9999B9F2295A41CDCCCCCC8AF62341CDCCCCACF5295A41CDCCCCCC4FF6234166666646F8295A41000000001EF623419A999939FA295A4100000000DDF52341333333D3FC295A419A99999905F623419A9999D9EC295A410000000015F6234166666646E7295A41CDCCCCCC1BF62341CDCCCC8CE4295A413333333322F6234133333393E1295A413333333324F62341CDCCCCECDF295A413333333325F6234166666626DE295A41CDCCCCCC25F62341000000C0D9295A41CDCCCCCC24F62341CDCCCC8CD4295A413333333307F623419A999959D3295A410000000067F523419A999979E7295A41CDCCCCCC39F5234166666626ED295A413333333357F423419A999999092A5A413333333336F42341000000C00D2A5A41	01060000206A08000001000000010300000001000000110000003333333336F42341000000C00D2A5A41333333331AF52341333333B3232A5A413333333386F6234166666646492A5A4100000000A1F62341CDCCCC4C472A5A4166666666DAF62341333333F3382A5A419A9999991AF7234166666606272A5A410000000071F723419A9999390C2A5A416666666602F82341000000C0E8295A410000000004F82341CDCCCC4CE6295A41CDCCCCCCC0F72341CDCCCC4CE5295A4100000000B5F7234100000060E9295A4100000000DDF52341333333D3FC295A413333333322F6234133333393E1295A41CDCCCCCC24F62341CDCCCC8CD4295A413333333307F623419A999959D3295A413333333336F42341000000C00D2A5A413333333336F42341000000C00D2A5A41	01010000206A080000D3D08C60D3F523419A9999490E2A5A41	751135014	H	Gare 14	7511350	75113	75	11	0
01060000206A080000010000000103000000010000003400000033333333BBF02341CDCCCC6C382A5A4133333333C3F023419A9999B93C2A5A4166666666CDF023419A999939402A5A4133333333E4F02341333333333F2A5A410000000059F12341666666E6462A5A4133333333D3F123419A9999F94E2A5A4100000000DEF12341CDCCCCEC4F2A5A41CDCCCCCC05F2234100000060532A5A41666666660AF223419A999979552A5A410000000014F2234133333373572A5A419A99999919F2234166666606582A5A413333333320F223419A9999B9582A5A41666666662DF22341CDCCCC4C592A5A410000000034F223419A999959592A5A419A9999995CF223419A9999595D2A5A416666666660F223419A9999595D2A5A419A99999969F22341666666C65C2A5A41CDCCCCCC06F323419A9999D9462A5A4133333333CAF2234133333393452A5A419A999999C7F22341CDCCCCCC432A5A41CDCCCCCCC2F22341CDCCCCEC412A5A4166666666BCF2234166666686402A5A41666666665EF323419A9999F9282A5A410000000074F3234166666646262A5A416666666679F323419A999999252A5A419A999999D4F32341333333131A2A5A4100000000EDF3234100000000172A5A4100000000F2F3234100000060162A5A4133333333FDF32341333333F3142A5A413333333316F42341CDCCCCCC112A5A413333333336F42341000000C00D2A5A4166666666E3F323419A9999B90F2A5A4133333333D7F3234100000020102A5A4166666666D4F3234133333333102A5A419A9999999DF3234166666606122A5A410000000014F32341000000A0162A5A419A999999D8F2234133333393182A5A41CDCCCCCCCCF22341CDCCCCEC182A5A41CDCCCCCC01F22341000000801F2A5A4166666666E7F123419A999959202A5A419A999999D8F12341CDCCCCEC1F2A5A419A999999AAF1234166666666252A5A413333333390F12341666666A6272A5A413333333329F123419A9999392E2A5A413333333320F12341333333B32E2A5A4133333333E3F02341000000E0312A5A419A999999C4F0234133333393332A5A41CDCCCCCCC7F0234133333393342A5A4100000000C8F02341CDCCCCCC352A5A41CDCCCCCCC5F02341333333F3362A5A41CDCCCCCCC0F02341333333D3372A5A4133333333BBF02341CDCCCC6C382A5A41	01060000206A080000010000000103000000010000001500000033333333BBF02341CDCCCC6C382A5A4166666666CDF023419A999939402A5A4133333333E4F02341333333333F2A5A4133333333D3F123419A9999F94E2A5A41CDCCCCCC05F2234100000060532A5A410000000014F2234133333373572A5A419A9999995CF223419A9999595D2A5A419A99999969F22341666666C65C2A5A41CDCCCCCC06F323419A9999D9462A5A4133333333CAF2234133333393452A5A4166666666BCF2234166666686402A5A41666666665EF323419A9999F9282A5A413333333336F42341000000C00D2A5A4166666666E3F323419A9999B90F2A5A4166666666E7F123419A999959202A5A419A999999D8F12341CDCCCCEC1F2A5A413333333390F12341666666A6272A5A413333333329F123419A9999392E2A5A419A999999C4F0234133333393332A5A4133333333BBF02341CDCCCC6C382A5A4133333333BBF02341CDCCCC6C382A5A41	01010000206A08000076542D25E9F1234100000030352A5A41	751135025	H	Gare 25	7511350	75113	75	11	0
01060000206A080000020000000103000000010000005E0000000000000026F72341000000C0B3295A416666666663F723419A999999B7295A41000000006AF7234100000060B8295A410000000075F7234166666606BA295A419A9999997AF7234100000080BA295A4166666666AFF72341CDCCCCCCBD295A419A999999E3F7234100000000C1295A4133333333ECF72341000000C0C1295A41CDCCCCCCF7F72341333333B3C2295A410000000008F8234166666686C4295A41333333330AF82341333333F3C4295A416666666618F823419A9999D9C4295A410000000022F82341333333D3C4295A41CDCCCCCC2DF8234166666626C5295A413333333382F82341CDCCCC4CCA295A4100000000C5F8234100000080CE295A4166666666BCF82341CDCCCC6CD0295A4166666666A9F8234166666626D3295A41CDCCCCCC89F823419A999919D7295A419A9999996CF823419A9999B9DA295A419A9999994EF823419A999979DE295A419A99999933F8234133333373E1295A41CDCCCCCC1CF8234133333393E3295A41CDCCCCCC12F8234100000060E5295A410000000004F82341CDCCCC4CE6295A410000000004F82341333333B3E7295A416666666602F82341000000C0E8295A41CDCCCCCCDCF72341666666A6F1295A4166666666AAF72341000000C0FD295A416666666696F7234166666686022A5A41666666667EF72341CDCCCCEC082A5A410000000071F723419A9999390C2A5A416666666669F72341333333D30E2A5A419A99999987F7234133333313112A5A4166666666AAF72341000000C0132A5A4166666666C9F7234100000020162A5A4133333333E5F7234166666646182A5A410000000002F82341666666861A2A5A41000000001CF82341000000A01C2A5A410000000033F82341CDCCCC6C1E2A5A41CDCCCCCC5AF8234166666686212A5A419A9999996AF82341333333B3222A5A41333333337BF8234100000000242A5A41CDCCCCCC85F82341CDCCCC8C212A5A41CDCCCCCC92F82341000000C01E2A5A419A999999A1F82341333333931B2A5A4166666666B1F8234133333353182A5A4100000000C1F823419A999919152A5A4166666666D3F8234133333333112A5A41CDCCCCCCE5F82341666666860D2A5A41CDCCCCCCF2F82341666666E60A2A5A419A99999901F92341000000E0072A5A41333333330CF92341333333B3052A5A419A99999916F92341CDCCCCAC032A5A413333333320F92341000000A0012A5A41CDCCCCCC2DF92341000000E0FE295A41000000004FF9234100000020F8295A41666666667EF92341CDCCCC6CEE295A419A999999A5F9234166666666E6295A419A999999BCF9234133333313E5295A4133333333C6F9234166666646E4295A41666666660CFA23419A999939DD295A416666666631FA234100000020D9295A419A99999934FA234166666666D8295A41CDCCCCCC26FA234166666686D7295A41CDCCCCCC0FFA2341CDCCCC0CD6295A4100000000F9F92341CDCCCCACD4295A4100000000E3F9234100000060D3295A419A999999C5F9234133333393D1295A419A999999A9F923419A9999D9CF295A41000000008DF923419A999919CE295A419A99999971F92341CDCCCC6CCC295A41333333335AF923419A9999F9CA295A419A99999945F92341000000A0C9295A413333333333F9234166666666C8295A419A99999921F9234133333313C7295A41CDCCCCCC0DF923419A999999C5295A4133333333EDF8234100000040C3295A4133333333CDF823419A999919C1295A41CDCCCCCCA7F82341666666A6BE295A41CDCCCCCC7DF8234166666606BC295A413333333353F8234100000060B9295A410000000023F8234100000060B6295A4100000000EFF723419A999939B3295A419A999999BDF723419A999939B0295A41CDCCCCCC8CF723419A999939AD295A410000000063F72341333333B3AA295A416666666657F7234100000000AA295A419A9999994AF72341333333D3AB295A41CDCCCCCC36F7234100000040AE295A413333333327F72341CDCCCC0CB0295A41CDCCCCCC1FF7234166666606B1295A41CDCCCCCC12F7234166666666B2295A410000000026F72341000000C0B3295A410103000000010000005B000000CDCCCCCCFCF2234166666646E22A5A41000000001CF3234100000040E42A5A410000000024F32341000000C0E42A5A41000000004CF323419A999999E72A5A413333333366F32341333333B3E92A5A410000000089F3234166666686EC2A5A419A999999E6F3234100000000F42A5A4133333333F1F32341CDCCCCECF42A5A4133333333F9F32341000000A0F52A5A4133333333FBF32341666666C6F52A5A41333333330AF4234133333313F72A5A41CDCCCCCC13F42341CDCCCCECF72A5A41CDCCCCCC1BF423419A999999F82A5A41CDCCCCCC21F4234133333333F92A5A41CDCCCCCC26F423419A9999B9F92A5A41CDCCCCCC30F42341000000C0FA2A5A410000000034F4234133333313FB2A5A41000000004AF423419A999959FD2A5A419A99999954F4234133333353FB2A5A41666666664FF42341CDCCCCCCF72A5A419A9999996DF42341666666A6F12A5A41333333338AF42341CDCCCCCCEB2A5A41CDCCCCCCADF423419A999939E52A5A41CDCCCCCCCCF42341333333D3DE2A5A4166666666E8F42341CDCCCC2CD92A5A416666666602F52341333333D3D32A5A419A9999991BF52341666666A6CE2A5A413333333336F52341CDCCCC4CC92A5A41333333335DF52341CDCCCC4CC12A5A416666666687F52341333333B3B82A5A419A999999B0F5234133333373B02A5A41CDCCCCCCD5F52341333333D3A82A5A41CDCCCCCCFEF5234100000080A02A5A41CDCCCCCC22F6234166666606992A5A41CDCCCCCC4FF623419A9999D98F2A5A41666666667AF6234100000000872A5A4133333333A6F62341666666067E2A5A419A999999D2F62341CDCCCCEC742A5A4100000000F7F62341000000C06D2A5A413333333324F723419A9999D9642A5A41000000004BF72341333333335D2A5A419A99999971F7234100000060552A5A419A99999998F72341666666664D2A5A4100000000C2F723419A999919452A5A4100000000E8F723419A9999593D2A5A410000000010F8234133333353352A5A419A999999FEF72341666666C6332A5A410000000088F72341333333B32A2A5A419A99999963F723419A9999F9272A5A416666666637F72341CDCCCCCC242A5A410000000025F7234133333393232A5A419A9999991AF7234166666606272A5A4166666666F5F62341CDCCCC8C312A5A4166666666ECF623419A9999F9332A5A4166666666DAF62341333333F3382A5A41CDCCCCCCCAF62341666666E63C2A5A4100000000A1F62341CDCCCC4C472A5A41CDCCCCCC96F623419A999919452A5A413333333391F62341CDCCCC6C462A5A41000000008EF623419A999939472A5A413333333386F6234166666646492A5A41000000007FF62341CDCCCCEC4A2A5A419A9999997CF62341000000804B2A5A419A99999977F62341000000604D2A5A416666666687F62341CDCCCC8C4D2A5A419A9999996FF62341666666C6532A5A416666666657F6234166666626592A5A41CDCCCCCC4BF62341333333B35B2A5A419A99999924F623419A9999B9632A5A410000000006F6234133333373682A5A419A999999F1F52341666666C66A2A5A410000000096F52341CDCCCC0C732A5A41666666661BF52341CDCCCC2C7E2A5A419A9999990CF523419A9999797F2A5A41CDCCCCCC9CF42341000000C0892A5A41CDCCCCCC53F4234100000080902A5A41000000000BF423419A999979972A5A41000000000FF42341CDCCCC0C9B2A5A41CDCCCCCC0EF42341000000C09C2A5A41333333330DF42341000000809D2A5A410000000008F42341333333D39E2A5A419A999999E9F3234166666666A42A5A4166666666ACF3234100000020B22A5A419A99999956F32341CDCCCC6CC32A5A41333333333AF32341000000C0C92A5A41CDCCCCCCFEF2234100000080D72A5A4133333333F0F2234100000040DB2A5A4166666666E9F22341CDCCCCECDD2A5A4133333333E1F22341CDCCCC2CE02A5A41CDCCCCCCDFF2234100000080E02A5A41CDCCCCCCFCF2234166666646E22A5A41	01060000206A08000002000000010300000001000000170000000000000026F72341000000C0B3295A419A9999997AF7234100000080BA295A419A999999E3F7234100000000C1295A41333333330AF82341333333F3C4295A41CDCCCCCC2DF8234166666626C5295A4100000000C5F8234100000080CE295A4166666666A9F8234166666626D3295A419A9999994EF823419A999979DE295A410000000004F82341CDCCCC4CE6295A416666666602F82341000000C0E8295A416666666696F7234166666686022A5A416666666669F72341333333D30E2A5A41333333337BF8234100000000242A5A419A999999A1F82341333333931B2A5A419A999999A5F9234166666666E6295A4133333333C6F9234166666646E4295A419A99999934FA234166666666D8295A41333333335AF923419A9999F9CA295A41CDCCCCCCA7F82341666666A6BE295A416666666657F7234100000000AA295A41CDCCCCCC12F7234166666666B2295A410000000026F72341000000C0B3295A410000000026F72341000000C0B3295A410103000000010000001B000000CDCCCCCCFCF2234166666646E22A5A41000000004CF323419A999999E72A5A419A999999E6F3234100000000F42A5A41000000004AF423419A999959FD2A5A41666666664FF42341CDCCCCCCF72A5A41CDCCCCCCADF423419A999939E52A5A41CDCCCCCCFEF5234100000080A02A5A419A999999D2F62341CDCCCCEC742A5A41000000004BF72341333333335D2A5A410000000010F8234133333353352A5A410000000025F7234133333393232A5A4166666666DAF62341333333F3382A5A4100000000A1F62341CDCCCC4C472A5A41CDCCCCCC96F623419A999919452A5A419A99999977F62341000000604D2A5A416666666687F62341CDCCCC8C4D2A5A419A99999924F623419A9999B9632A5A419A999999F1F52341666666C66A2A5A419A9999990CF523419A9999797F2A5A41000000000BF423419A999979972A5A41CDCCCCCC0EF42341000000C09C2A5A4166666666ACF3234100000020B22A5A419A99999956F32341CDCCCC6CC32A5A41CDCCCCCCFEF2234100000080D72A5A41CDCCCCCCDFF2234100000080E02A5A41CDCCCCCCFCF2234166666646E22A5A41CDCCCCCCFCF2234166666646E22A5A41	01010000206A0800009BE1A9C252F52341CDCCCC2C902A5A41	751135015	H	Gare 15	7511350	75113	75	11	0
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	01060000206A08000001000000010300000001000000130000000000000025F7234133333393232A5A419A999999FEF72341666666C6332A5A41000000001EF8234133333393362A5A413333333378F92341CDCCCC2C512A5A41CDCCCCCC2BFA2341000000805F2A5A419A9999995CFB23419A9999F9302A5A41CDCCCCCCD0FB2341000000001D2A5A419A9999991CFC234133333333122A5A41CDCCCCCC74FC23419A9999B9032A5A41666666666EFB2341CDCCCCCCEC295A419A999999B8FA234133333373E0295A419A99999934FA234166666666D8295A4133333333C6F9234166666646E4295A419A999999A5F9234166666666E6295A419A999999A1F82341333333931B2A5A41333333337BF8234100000000242A5A416666666669F72341333333D30E2A5A410000000025F7234133333393232A5A410000000025F7234133333393232A5A41	01010000206A0800000C49E8C73AFA2341333333231C2A5A41	751135016	H	Gare 16	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000025000000000000004BF72341333333335D2A5A419A9999995AF72341CDCCCCEC5E2A5A41333333336AF72341666666A6602A5A410000000082F7234133333313632A5A4100000000AFF723419A999999672A5A41CDCCCCCCD3F72341000000406B2A5A419A999999F0F72341666666666E2A5A41CDCCCCCC0EF823419A9999B9712A5A41CDCCCCCC2EF8234100000020752A5A419A99999966F82341000000807A2A5A4100000000A9F82341CDCCCC0C812A5A4100000000D2F8234100000040852A5A41333333330DF92341333333738B2A5A419A99999942F9234133333333832A5A41000000009CF9234100000080752A5A41CDCCCCCCB9F92341666666E6702A5A4100000000D6F92341333333936C2A5A4100000000F6F92341CDCCCCAC672A5A413333333310FA23419A9999B9632A5A41CDCCCCCC2BFA2341000000805F2A5A410000000019FA2341666666E65D2A5A419A999999E0F92341CDCCCC6C592A5A4166666666AEF923419A999979552A5A413333333378F92341CDCCCC2C512A5A41CDCCCCCC3EF92341CDCCCCCC4C2A5A41CDCCCCCC0BF923419A9999D9482A5A4166666666E1F8234166666686452A5A4100000000B8F8234166666646422A5A419A99999985F823419A9999793E2A5A41CDCCCCCC4FF82341000000603A2A5A41000000001EF8234133333393362A5A410000000010F8234133333353352A5A4100000000E8F723419A9999593D2A5A4100000000C2F723419A999919452A5A419A99999998F72341666666664D2A5A419A99999971F7234100000060552A5A41000000004BF72341333333335D2A5A41	01060000206A0800000100000001030000000100000008000000000000004BF72341333333335D2A5A41CDCCCCCC2EF8234100000020752A5A41333333330DF92341333333738B2A5A41CDCCCCCC2BFA2341000000805F2A5A413333333378F92341CDCCCC2C512A5A410000000010F8234133333353352A5A41000000004BF72341333333335D2A5A41000000004BF72341333333335D2A5A41	01010000206A080000D6CF9A85C6F8234133333313602A5A41	751135017	H	Gare 17	7511350	75113	75	11	0
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	01060000206A0800000100000001030000000100000010000000000000004AF423419A999959FD2A5A4100000000DEF42341CDCCCC6C0C2B5A41CDCCCCCCA3F52341666666A61D2B5A41CDCCCCCCE3F52341666666A60E2B5A419A9999998EF6234133333333EB2A5A4133333333A5F6234133333353E72A5A419A999999A6F823419A9999D9982A5A41333333330DF92341333333738B2A5A41CDCCCCCC2EF8234100000020752A5A41000000004BF72341333333335D2A5A419A999999D2F62341CDCCCCEC742A5A41CDCCCCCCFEF5234100000080A02A5A41CDCCCCCCADF423419A999939E52A5A41666666664FF42341CDCCCCCCF72A5A41000000004AF423419A999959FD2A5A41000000004AF423419A999959FD2A5A41	01010000206A080000E51BE3FF8AF623419A9999E9BE2A5A41	751135018	H	Gare 18	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001D000000666666665EF323419A9999F9282A5A410000000054F4234133333393432A5A416666666675F42341000000E0462A5A410000000002F52341CDCCCC2C542A5A419A99999933F523419A9999D9582A5A419A999999F1F52341666666C66A2A5A410000000006F6234133333373682A5A419A99999924F623419A9999B9632A5A41CDCCCCCC4BF62341333333B35B2A5A416666666657F6234166666626592A5A419A9999996FF62341666666C6532A5A416666666687F62341CDCCCC8C4D2A5A419A99999977F62341000000604D2A5A419A9999997CF62341000000804B2A5A41000000007FF62341CDCCCCEC4A2A5A413333333386F6234166666646492A5A413333333379F62341666666E6472A5A413333333364F62341666666C6452A5A4133333333D8F5234166666646372A5A41333333331AF52341333333B3232A5A413333333336F42341000000C00D2A5A413333333316F42341CDCCCCCC112A5A4133333333FDF32341333333F3142A5A4100000000F2F3234100000060162A5A4100000000EDF3234100000000172A5A419A999999D4F32341333333131A2A5A416666666679F323419A999999252A5A410000000074F3234166666646262A5A41666666665EF323419A9999F9282A5A41	01060000206A080000010000000103000000010000000A000000666666665EF323419A9999F9282A5A410000000054F4234133333393432A5A419A999999F1F52341666666C66A2A5A419A99999924F623419A9999B9632A5A416666666687F62341CDCCCC8C4D2A5A413333333386F6234166666646492A5A41333333331AF52341333333B3232A5A413333333336F42341000000C00D2A5A41666666665EF323419A9999F9282A5A41666666665EF323419A9999F9282A5A41	01010000206A080000E677DE6517F52341CCCCCC6C3D2A5A41	751135019	H	Gare 19	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000022000000666666661BF22341000000A08B2A5A416666666631F22341666666068E2A5A41666666668DF223419A999939972A5A4100000000C3F22341CDCCCC8C9C2A5A416666666619F32341CDCCCC6CA52A5A413333333327F323419A9999D9A62A5A410000000043F32341666666E6A92A5A413333333348F3234133333393AA2A5A4166666666ACF3234100000020B22A5A419A999999E9F3234166666666A42A5A410000000008F42341333333D39E2A5A41333333330DF42341000000809D2A5A41CDCCCCCC0EF42341000000C09C2A5A41000000000FF42341CDCCCC0C9B2A5A41000000000BF423419A999979972A5A41CDCCCCCC53F4234100000080902A5A41CDCCCCCC9CF42341000000C0892A5A419A9999990CF523419A9999797F2A5A41666666661BF52341CDCCCC2C7E2A5A410000000096F52341CDCCCC0C732A5A419A999999F1F52341666666C66A2A5A419A99999933F523419A9999D9582A5A410000000002F52341CDCCCC2C542A5A416666666675F42341000000E0462A5A410000000054F4234133333393432A5A41000000003AF423419A999999462A5A41CDCCCCCCAFF32341000000C0572A5A419A9999995DF32341CDCCCC4C622A5A419A99999929F3234100000000692A5A416666666625F3234166666686692A5A4100000000F7F22341000000806F2A5A4133333333AFF2234166666646782A5A416666666674F22341666666E67F2A5A41666666661BF22341000000A08B2A5A41	01060000206A080000010000000103000000010000000C000000666666661BF22341000000A08B2A5A413333333348F3234133333393AA2A5A4166666666ACF3234100000020B22A5A41CDCCCCCC0EF42341000000C09C2A5A41000000000BF423419A999979972A5A419A9999990CF523419A9999797F2A5A419A999999F1F52341666666C66A2A5A410000000054F4234133333393432A5A41CDCCCCCCAFF32341000000C0572A5A4133333333AFF2234166666646782A5A41666666661BF22341000000A08B2A5A41666666661BF22341000000A08B2A5A41	01010000206A08000084092F2EEAF323419A9999397B2A5A41	751135020	H	Gare 20	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000036000000000000008EEB234100000080682A5A419A999999F9EB2341000000006F2A5A416666666608EC234133333393702A5A41CDCCCCCCFCEB234133333353732A5A4166666666FCEB23419A999979732A5A41CDCCCCCC94EC2341666666867C2A5A41CDCCCCCC9EEC23419A9999B9792A5A41CDCCCCCCA9EC234166666686772A5A41666666660AED2341000000A0602A5A413333333320ED2341000000005D2A5A416666666649ED234100000080552A5A419A99999965ED23419A999959502A5A41CDCCCCCC75ED2341666666664D2A5A41CDCCCCCCA3ED2341333333D3452A5A4133333333A8ED234166666606442A5A419A999999B0ED23419A999939432A5A41CDCCCCCCBEED2341333333D3412A5A41CDCCCCCCCDED2341666666E63E2A5A419A999999E0ED2341000000203C2A5A4133333333FFED23419A999999372A5A416666666612EE2341000000C0342A5A41CDCCCCCC21EE234166666666322A5A416666666641EE2341CDCCCC8C2D2A5A413333333376EE23419A999979252A5A41CDCCCCCCE6EE234133333333142A5A416666666616EF2341000000E00C2A5A419A99999925EF2341CDCCCC0C0A2A5A413333333364EF2341666666C6FF295A419A999999AAEF23419A9999B9F4295A4166666666B3EF2341CDCCCC4CF3295A41CDCCCCCCBBEF23419A999999F2295A41CDCCCCCCC9EF234100000000F2295A410000000087EE234100000060EA295A4100000000AAED234133333393E5295A419A999999A5ED2341333333B3E6295A413333333391ED2341666666A6EA295A419A99999984ED234100000040ED295A413333333370ED23419A999959F2295A41CDCCCCCC5FED2341CDCCCC6CF6295A419A9999995CED23419A999959F7295A41CDCCCCCC56ED2341CDCCCCACF8295A413333333333ED234166666686012A5A419A99999926ED2341666666A6042A5A4100000000F8EC234100000040102A5A4133333333F6EC2341333333B3102A5A4166666666E6EC2341000000A0142A5A4100000000E5EC23419A9999F9142A5A41CDCCCCCCCBEC2341666666461B2A5A41CDCCCCCC9EEC2341CDCCCC6C262A5A419A9999995EEC2341333333F3352A5A419A99999909EC23419A9999794A2A5A4166666666A6EB234100000060622A5A413333333397EB2341CDCCCC2C662A5A41000000008EEB234100000080682A5A41	01060000206A0800000100000001030000000100000010000000000000008EEB234100000080682A5A419A999999F9EB2341000000006F2A5A4166666666FCEB23419A999979732A5A41CDCCCCCC94EC2341666666867C2A5A41666666660AED2341000000A0602A5A41CDCCCCCC75ED2341666666664D2A5A41CDCCCCCCCDED2341666666E63E2A5A416666666616EF2341000000E00C2A5A4166666666B3EF2341CDCCCC4CF3295A41CDCCCCCCC9EF234100000000F2295A410000000087EE234100000060EA295A4100000000AAED234133333393E5295A419A99999984ED234100000040ED295A41CDCCCCCC9EEC2341CDCCCC6C262A5A41000000008EEB234100000080682A5A41000000008EEB234100000080682A5A41	01010000206A080000244F407454ED23419A9999F92F2A5A41	751135028	H	Gare 28	7511350	75113	75	11	0
01060000206A0800000100000001030000000100000035000000CDCCCCCC94EC2341666666867C2A5A416666666609ED23419A999959842A5A410000000025ED234100000020862A5A41666666662EED2341CDCCCC8C862A5A419A99999969ED2341333333338A2A5A419A999999BDED2341000000608F2A5A41CDCCCCCCCDED234100000060902A5A419A99999944EE2341CDCCCCAC972A5A419A99999993EE2341000000809C2A5A4133333333CEEE2341CDCCCC2CA02A5A41CDCCCCCCCEEE23419A999919A02A5A419A999999E3EE2341CDCCCCAC9D2A5A41CDCCCCCCF6EE23419A9999B99B2A5A419A99999966EF2341333333D38B2A5A419A999999AEEF2341CDCCCC4C812A5A4166666666C7EF2341333333937D2A5A4166666666D1EF2341CDCCCCEC7B2A5A4133333333D0EF2341000000807A2A5A41CDCCCCCCEDEF2341CDCCCCCC702A5A413333333369F023419A9999594A2A5A419A9999999BF02341666666A63B2A5A4133333333A5F0234133333393382A5A41666666669EF0234166666606382A5A416666666699F0234133333373372A5A416666666696F02341666666A6362A5A416666666681F023419A999999372A5A416666666671F0234100000080382A5A4100000000F8EF23419A999939422A5A419A999999A4EF2341CDCCCCCC482A5A410000000011EF234100000080542A5A4133333333F8EE2341CDCCCCCC562A5A41CDCCCCCCCEEE234133333393512A5A41000000006BEE234166666666452A5A416666666635EE2341333333D33E2A5A419A99999923EE23419A9999993C2A5A410000000017EE2341666666063B2A5A41666666660CEE2341666666C63B2A5A419A999999FEED2341000000203D2A5A4100000000F4ED2341CDCCCC2C3E2A5A41CDCCCCCCE3ED23419A9999D93F2A5A41CDCCCCCCCFED234166666646412A5A41CDCCCCCCBEED2341333333D3412A5A419A999999B0ED23419A999939432A5A4133333333A8ED234166666606442A5A41CDCCCCCCA3ED2341333333D3452A5A41CDCCCCCC75ED2341666666664D2A5A419A99999965ED23419A999959502A5A416666666649ED234100000080552A5A413333333320ED2341000000005D2A5A41666666660AED2341000000A0602A5A41CDCCCCCCA9EC234166666686772A5A41CDCCCCCC9EEC23419A9999B9792A5A41CDCCCCCC94EC2341666666867C2A5A41	01060000206A0800000100000001030000000100000011000000CDCCCCCC94EC2341666666867C2A5A416666666609ED23419A999959842A5A4133333333CEEE2341CDCCCC2CA02A5A41CDCCCCCCF6EE23419A9999B99B2A5A4166666666D1EF2341CDCCCCEC7B2A5A41CDCCCCCCEDEF2341CDCCCCCC702A5A413333333369F023419A9999594A2A5A4133333333A5F0234133333393382A5A416666666671F0234100000080382A5A410000000011EF234100000080542A5A4133333333F8EE2341CDCCCCCC562A5A410000000017EE2341666666063B2A5A41CDCCCCCCBEED2341333333D3412A5A41CDCCCCCC75ED2341666666664D2A5A41666666660AED2341000000A0602A5A41CDCCCCCC94EC2341666666867C2A5A41CDCCCCCC94EC2341666666867C2A5A41	01010000206A0800008A2E1B0578EE2341666666B6682A5A41	751135029	H	Gare 29	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001D00000033333333D0EF2341000000807A2A5A4166666666D1EF2341CDCCCCEC7B2A5A4166666666EAEF2341666666E6782A5A410000000011F023419A9999F9732A5A41CDCCCCCC9FF023419A999979672A5A41CDCCCCCCB1F0234133333313662A5A416666666626F12341333333335E2A5A41CDCCCCCC5BF1234100000060732A5A419A99999969F1234100000080712A5A419A99999990F12341CDCCCCCC6B2A5A4133333333E8F12341CDCCCC0C5F2A5A419A99999919F2234166666606582A5A410000000014F2234133333373572A5A41666666660AF223419A999979552A5A41CDCCCCCC05F2234100000060532A5A4100000000DEF12341CDCCCCEC4F2A5A4133333333D3F123419A9999F94E2A5A410000000059F12341666666E6462A5A4133333333E4F02341333333333F2A5A4166666666CDF023419A999939402A5A4133333333C3F023419A9999B93C2A5A4133333333BBF02341CDCCCC6C382A5A4100000000B4F02341000000C0382A5A41CDCCCCCCACF02341000000C0382A5A4133333333A5F0234133333393382A5A419A9999999BF02341666666A63B2A5A413333333369F023419A9999594A2A5A41CDCCCCCCEDEF2341CDCCCCCC702A5A4133333333D0EF2341000000807A2A5A41	01060000206A080000010000000103000000010000001000000033333333D0EF2341000000807A2A5A4166666666D1EF2341CDCCCCEC7B2A5A410000000011F023419A9999F9732A5A41CDCCCCCC9FF023419A999979672A5A416666666626F12341333333335E2A5A41CDCCCCCC5BF1234100000060732A5A419A99999919F2234166666606582A5A41CDCCCCCC05F2234100000060532A5A4133333333D3F123419A9999F94E2A5A4133333333E4F02341333333333F2A5A4166666666CDF023419A999939402A5A4133333333BBF02341CDCCCC6C382A5A4133333333A5F0234133333393382A5A413333333369F023419A9999594A2A5A4133333333D0EF2341000000807A2A5A4133333333D0EF2341000000807A2A5A41	01010000206A080000AC6055A51BF12341CCCCCC1C5B2A5A41	751135030	H	Gare 30	7511350	75113	75	11	0
01060000206A080000010000000103000000010000001B00000033333333CEEE2341CDCCCC2CA02A5A419A99999911EF23419A999959A42A5A416666666616EF2341333333B3A42A5A4166666666A6EF2341CDCCCC8CAD2A5A4133333333B2EF2341CDCCCC4CAE2A5A41CDCCCCCCBAEF2341333333D3AE2A5A4166666666BBEF23419A9999B9AE2A5A4166666666CAEF234100000040AC2A5A4133333333D4EF234133333313AA2A5A419A999999E7EF2341666666A6A72A5A416666666682F02341CDCCCCAC912A5A41CDCCCCCCBDF0234133333373892A5A41666666663CF12341CDCCCC8C772A5A41CDCCCCCC5BF1234100000060732A5A416666666626F12341333333335E2A5A41CDCCCCCCB1F0234133333313662A5A41CDCCCCCC9FF023419A999979672A5A410000000011F023419A9999F9732A5A4166666666EAEF2341666666E6782A5A4166666666D1EF2341CDCCCCEC7B2A5A4166666666C7EF2341333333937D2A5A419A999999AEEF2341CDCCCC4C812A5A419A99999966EF2341333333D38B2A5A41CDCCCCCCF6EE23419A9999B99B2A5A419A999999E3EE2341CDCCCCAC9D2A5A41CDCCCCCCCEEE23419A999919A02A5A4133333333CEEE2341CDCCCC2CA02A5A41	01060000206A080000010000000103000000010000000B00000033333333CEEE2341CDCCCC2CA02A5A41CDCCCCCCBAEF2341333333D3AE2A5A419A999999E7EF2341666666A6A72A5A41CDCCCCCC5BF1234100000060732A5A416666666626F12341333333335E2A5A41CDCCCCCC9FF023419A999979672A5A410000000011F023419A9999F9732A5A4166666666D1EF2341CDCCCCEC7B2A5A41CDCCCCCCF6EE23419A9999B99B2A5A4133333333CEEE2341CDCCCC2CA02A5A4133333333CEEE2341CDCCCC2CA02A5A41	01010000206A080000326F17AC36F0234100000060852A5A41	751135031	H	Gare 31	7511350	75113	75	11	0
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	01060000206A08000001000000010300000001000000130000006666666657F7234100000000AA295A41CDCCCCCCA7F82341666666A6BE295A41333333335AF923419A9999F9CA295A419A999999B8FA234133333373E0295A41666666666EFB2341CDCCCCCCEC295A41CDCCCCCC74FC23419A9999B9032A5A4133333333C4FC234100000040F7295A410000000033FD234100000080E7295A41000000001AFE2341333333D3C7295A419A9999992EFE234100000000C4295A419A9999991CFD234166666666B2295A41666666661FFC2341000000409E295A419A999999FDF92341000000207A295A41333333338DF923410000008066295A410000000095F82341666666A657295A41CDCCCCCC40F823410000004070295A413333333377F72341CDCCCCECA5295A416666666657F7234100000000AA295A416666666657F7234100000000AA295A41	01010000206A08000038CE77CF49FA23419A9999B9AE295A41	751135032	A	Gare 32	7511350	75113	75	11	0
01060000206A08000001000000010300000001000000210000003333333358E323419A99999977295A41CDCCCCCC71E323413333339379295A41CDCCCCCC42E42341666666E689295A410000000072E42341000000A085295A416666666679E423419A9999B986295A41000000007EE42341666666E687295A416666666681E423413333335389295A413333333387E42341CDCCCC4C8C295A410000000097E42341666666E693295A4100000000AEE42341333333F39E295A41CDCCCCCCCCE4234166666646AD295A41CDCCCCCC23E523419A9999199F295A41CDCCCCCC35E52341000000409C295A413333333390E52341CDCCCCEC8D295A419A999999D3E523413333333383295A41CDCCCCCCE2E52341666666C680295A410000000012E62341000000807B295A4166666666EEE52341666666667A295A4133333333E7E52341CDCCCC2C7A295A41CDCCCCCCDAE523416666664679295A419A999999C9E523410000004078295A4133333333BDE52341333333B377295A419A999999ABE52341CDCCCC0C77295A41CDCCCCCC30E523419A9999F972295A413333333388E42341666666466D295A41000000000EE423413333333369295A4133333333FBE32341666666C668295A4133333333DDE323416666666668295A419A999999B0E323419A99997966295A41666666669AE32341CDCCCC2C65295A416666666697E32341000000C065295A419A99999982E32341CDCCCC4C6B295A413333333358E323419A99999977295A41	01060000206A080000010000000103000000010000000D0000003333333358E323419A99999977295A41CDCCCCCC42E42341666666E689295A410000000072E42341000000A085295A41000000007EE42341666666E687295A41CDCCCCCCCCE4234166666646AD295A41CDCCCCCCE2E52341666666C680295A410000000012E62341000000807B295A419A999999ABE52341CDCCCC0C77295A41000000000EE423413333333369295A4133333333DDE323416666666668295A41666666669AE32341CDCCCC2C65295A413333333358E323419A99999977295A413333333358E323419A99999977295A41	01010000206A080000D57794A418E52341CCCCCC9C88295A41	751135115	H	Maison Blanche 15	7511351	75113	75	11	0
01060000206A080000010000000103000000010000001D0000000000000005E32341333333F3A7295A41CDCCCCCC12E3234100000080BD295A41666666661CE32341CDCCCCECCB295A41333333331AE323419A999959D0295A41333333332EE323419A999919E9295A413333333333E32341CDCCCC8CEB295A41CDCCCCCC39E323419A999959EF295A413333333354E3234166666666EB295A41333333335BE3234166666646EA295A419A9999990DE423419A999979CC295A419A999999B6E42341000000E0B0295A41CDCCCCCCCCE4234166666646AD295A4100000000AEE42341333333F39E295A410000000097E42341666666E693295A413333333387E42341CDCCCC4C8C295A416666666681E423413333335389295A41000000007EE42341666666E687295A416666666679E423419A9999B986295A410000000072E42341000000A085295A41CDCCCCCC42E42341666666E689295A41CDCCCCCC71E323413333339379295A413333333358E323419A99999977295A419A99999954E323419A9999D978295A416666666634E323419A99995983295A41CDCCCCCC2AE32341000000C087295A410000000020E323413333335391295A410000000009E32341666666A6A0295A413333333305E323419A999999A5295A410000000005E32341333333F3A7295A41	01060000206A080000010000000103000000010000000E0000000000000005E32341333333F3A7295A41666666661CE32341CDCCCCECCB295A41333333331AE323419A999959D0295A41333333332EE323419A999919E9295A41CDCCCCCC39E323419A999959EF295A41CDCCCCCCCCE4234166666646AD295A41000000007EE42341666666E687295A410000000072E42341000000A085295A41CDCCCCCC42E42341666666E689295A413333333358E323419A99999977295A416666666634E323419A99995983295A410000000009E32341666666A6A0295A410000000005E32341333333F3A7295A410000000005E32341333333F3A7295A41	01010000206A080000A26A3E5ACFE3234100000030B7295A41	751135116	H	Maison Blanche 16	7511351	75113	75	11	0
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	01060000206A0800000100000001030000000100000018000000CDCCCCCCA3F52341666666A61D2B5A410000000047F62341CDCCCCEC2D2B5A419A99999989F623419A999979212B5A41CDCCCCCC42F82341CDCCCC2CD92A5A41CDCCCCCCC2F92341CDCCCCEC9D2A5A419A999999A3FB234133333353552A5A413333333341FD234133333313112A5A413333333307FE234133333393F1295A4166666666EAFE234100000020D4295A41CDCCCCCC8DFE2341CDCCCC8CCA295A419A9999992EFE234100000000C4295A41000000001AFE2341333333D3C7295A410000000033FD234100000080E7295A4133333333C4FC234100000040F7295A419A9999991CFC234133333333122A5A41CDCCCCCCD0FB2341000000001D2A5A419A9999995CFB23419A9999F9302A5A41333333330DF92341333333738B2A5A419A999999A6F823419A9999D9982A5A4133333333A5F6234133333353E72A5A419A9999998EF6234133333333EB2A5A41CDCCCCCCE3F52341666666A60E2B5A41CDCCCCCCA3F52341666666A61D2B5A41CDCCCCCCA3F52341666666A61D2B5A41	01010000206A080000A5D04B8617FA2341333333037A2A5A41	751135099	D	Seine et Berges 2	7511350	75113	75	11	0
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	01060000206A08000001000000010300000001000000110000003333333356ED23419A9999791E295A41CDCCCCCCAFEE2341CDCCCCAC24295A41666666663FEF2341000000202A295A419A99999907F02341333333B334295A419A99999958F023419A9999B939295A4133333333DAF02341333333B31A295A410000000095F12341000000C0EC285A41333333337DF023419A9999F9DC285A419A99999903F0234166666686D5285A419A99999982EF2341333333B3CE285A41CDCCCCCCE6ED2341000000E0CC285A4133333333D1ED234100000080CD285A4100000000B9ED2341666666A6DA285A4133333333A1ED23419A9999D9EE285A41666666667AED2341333333D305295A413333333356ED23419A9999791E295A413333333356ED23419A9999791E295A41	01010000206A0800004A3789C160EF23413433339301295A41	751135101	H	Maison Blanche 1	7511351	75113	75	11	0
01060000206A080000010000000103000000010000001F0000006666666625EE23419A99993958295A419A99999936EE2341666666C658295A4133333333C2EE2341CDCCCCEC60295A410000000058EF2341666666E669295A41333333338CEF23419A9999996C295A41CDCCCCCC9BEF2341333333B368295A41CDCCCCCCB3EF2341333333F362295A4100000000CBEF2341333333335D295A4133333333DCEF23416666660659295A4100000000ECEF23410000006055295A41333333331CF023410000000049295A419A9999993BF023410000004041295A413333333349F023419A9999793D295A419A99999958F023419A9999B939295A419A99999907F02341333333B334295A419A999999C2EF2341333333D330295A419A99999980EF2341666666462D295A41666666663FEF2341000000202A295A41CDCCCCCCEEEE23419A9999D926295A419A999999C8EE23413333337325295A4166666666C8EE23413333337325295A419A999999C2EE23416666664627295A4166666666B0EE2341666666C62C295A41000000009FEE23416666668632295A41CDCCCCCC8EEE2341333333D337295A419A99999973EE2341000000A040295A413333333360EE2341CDCCCC2C46295A41CDCCCCCC3CEE23410000006050295A41000000002FEE23416666660654295A413333333326EE23416666666657295A416666666625EE23419A99993958295A41	01060000206A080000010000000103000000010000000D0000006666666625EE23419A99993958295A419A99999936EE2341666666C658295A410000000058EF2341666666E669295A41333333338CEF23419A9999996C295A4100000000ECEF23410000006055295A419A99999958F023419A9999B939295A419A99999907F02341333333B334295A41666666663FEF2341000000202A295A4166666666C8EE23413333337325295A419A99999973EE2341000000A040295A41000000002FEE23416666660654295A416666666625EE23419A99993958295A416666666625EE23419A99993958295A41	01010000206A0800008C94B3B72BEF2341000000B04C295A41	751135102	H	Maison Blanche 2	7511351	75113	75	11	0
01060000206A080000010000000103000000010000003000000033333333CAEC2341666666C677295A4166666666DAEC23410000002078295A41333333334BED23419A9999F97A295A4166666666FAED2341CDCCCC0C80295A413333333307EE23413333331372295A416666666616EE2341CDCCCC8C65295A410000000017EE23416666668664295A416666666618EE2341CDCCCCEC62295A41CDCCCCCC19EE23416666662661295A416666666625EE23419A99993958295A413333333326EE23416666666657295A41000000002FEE23416666660654295A41CDCCCCCC3CEE23410000006050295A413333333360EE2341CDCCCC2C46295A419A99999973EE2341000000A040295A41CDCCCCCC8EEE2341333333D337295A41000000009FEE23416666668632295A4166666666B0EE2341666666C62C295A419A999999C2EE23416666664627295A4166666666C8EE23413333337325295A41CDCCCCCCAFEE2341CDCCCCAC24295A413333333391EE23419A99993924295A41CDCCCCCC6AEE2341CDCCCC6C23295A41666666662AEE23416666662622295A4133333333FBED23419A99995921295A4100000000DDED2341333333B320295A41CDCCCCCCC2ED23413333333320295A4166666666A1ED23419A9999991F295A41CDCCCCCC7AED2341666666E61E295A416666666665ED2341000000801E295A410000000058ED23419A9999791E295A413333333356ED23419A9999791E295A41CDCCCCCC55ED2341CDCCCCCC1E295A413333333353ED23410000006020295A41333333334FED23410000004022295A41CDCCCCCC4BED2341CDCCCC6C25295A413333333349ED2341CDCCCC0C27295A416666666640ED2341666666A62C295A410000000034ED23410000008034295A41000000002CED2341333333F339295A416666666618ED23419A99993946295A4166666666F8EC2341333333B35A295A4133333333EEEC23410000000061295A4133333333E7EC23410000004065295A4100000000E2EC23413333337368295A4166666666DFEC23419A9999396A295A4133333333D9EC23419A9999F96D295A4133333333CAEC2341666666C677295A41	01060000206A080000010000000103000000010000000900000033333333CAEC2341666666C677295A4166666666FAED2341CDCCCC0C80295A413333333326EE23416666666657295A419A99999973EE2341000000A040295A4166666666C8EE23413333337325295A41666666662AEE23416666662622295A413333333356ED23419A9999791E295A4133333333CAEC2341666666C677295A4133333333CAEC2341666666C677295A41	01010000206A08000020A4D870AFED2341CDCCCC4C4B295A41	751135103	H	Maison Blanche 3	7511351	75113	75	11	0
01060000206A080000010000000103000000010000002000000000000000B2EC2341CDCCCC8C88295A419A999999C0EC23413333331389295A4100000000EEEC2341000000C08A295A413333333352ED23419A9999598F295A413333333355ED2341000000808F295A416666666608EE2341CDCCCC2C98295A41CDCCCCCC67EE23419A9999799C295A419A999999B9EE23419A999999A0295A410000000008EF2341666666268D295A419A99999919EF23419A99991989295A41CDCCCCCC33EF23416666666682295A41000000003FEF2341333333937F295A410000000044EF23419A9999597E295A416666666673EF23413333339372295A41666666667EEF2341333333D36F295A41333333338CEF23419A9999996C295A410000000058EF2341666666E669295A4133333333C2EE2341CDCCCCEC60295A419A99999936EE2341666666C658295A416666666625EE23419A99993958295A41CDCCCCCC19EE23416666662661295A416666666618EE2341CDCCCCEC62295A410000000017EE23416666668664295A416666666616EE2341CDCCCC8C65295A413333333307EE23413333331372295A4166666666FAED2341CDCCCC0C80295A41333333334BED23419A9999F97A295A4166666666DAEC23410000002078295A4133333333CAEC2341666666C677295A41CDCCCCCCC1EC2341666666667E295A4100000000B6EC23419A99999986295A4100000000B2EC2341CDCCCC8C88295A41	01060000206A080000010000000103000000010000000B00000000000000B2EC2341CDCCCC8C88295A413333333352ED23419A9999598F295A419A999999B9EE23419A999999A0295A41333333338CEF23419A9999996C295A410000000058EF2341666666E669295A419A99999936EE2341666666C658295A416666666625EE23419A99993958295A4166666666FAED2341CDCCCC0C80295A4133333333CAEC2341666666C677295A4100000000B2EC2341CDCCCC8C88295A4100000000B2EC2341CDCCCC8C88295A41	01010000206A08000064BED825A4EE23419A9999A97C295A41	751135104	H	Maison Blanche 4	7511351	75113	75	11	0
01060000206A080000010000000103000000010000001C000000CDCCCCCC1AEC2341CDCCCC8CE6295A41CDCCCCCC2CEC234133333373E6295A4100000000DFEC2341333333D3E5295A419A9999995EED2341CDCCCCACE5295A41000000007BED2341CDCCCCACE5295A4100000000AAED234133333393E5295A4100000000B1ED23419A999999E1295A41CDCCCCCCC3ED2341CDCCCC4CDD295A419A999999F4ED23419A999979D1295A410000000012EE23419A999999C9295A419A9999999AEE2341CDCCCCECA7295A4166666666A9EE234166666646A4295A419A999999B9EE23419A999999A0295A41CDCCCCCC67EE23419A9999799C295A416666666608EE2341CDCCCC2C98295A413333333355ED2341000000808F295A413333333352ED23419A9999598F295A4100000000EEEC2341000000C08A295A419A999999C0EC23413333331389295A4100000000B2EC2341CDCCCC8C88295A419A999999A6EC23419A9999598E295A416666666699EC2341CDCCCC8C96295A413333333366EC234166666686B6295A410000000056EC2341CDCCCCACC0295A419A99999946EC234133333373C9295A410000000032EC2341CDCCCC6CD7295A41333333332BEC2341000000E0DB295A41CDCCCCCC1AEC2341CDCCCC8CE6295A41	01060000206A0800000100000001030000000100000009000000CDCCCCCC1AEC2341CDCCCC8CE6295A4100000000AAED234133333393E5295A4100000000B1ED23419A999999E1295A419A999999B9EE23419A999999A0295A413333333352ED23419A9999598F295A4100000000B2EC2341CDCCCC8C88295A419A999999A6EC23419A9999598E295A41CDCCCCCC1AEC2341CDCCCC8CE6295A41CDCCCCCC1AEC2341CDCCCC8CE6295A41	01010000206A080000875BE87154ED23419A999999BB295A41	751135105	H	Maison Blanche 5	7511351	75113	75	11	0
01060000206A0800000100000001030000000100000010000000666666663BE3234100000040F0295A41000000005EE3234166666646FF295A4133333333A0E32341CDCCCC0C1C2A5A4100000000ACE32341CDCCCC2C212A5A41CDCCCCCCB1E323419A9999D9222A5A419A999999BDE32341CDCCCC6C252A5A419A999999D8E32341666666662A2A5A4133333333D6E42341666666061F2A5A41CDCCCCCC6FE5234166666626182A5A419A99999945E52341CDCCCCACF2295A413333333340E52341CDCCCCECED295A410000000034E5234166666606E3295A416666666630E52341000000C0E1295A41666666668AE42341CDCCCC8CE6295A41000000005DE3234133333333EF295A41666666663BE3234100000040F0295A41	01060000206A0800000100000001030000000100000008000000666666663BE3234100000040F0295A4100000000ACE32341CDCCCC2C212A5A419A999999D8E32341666666662A2A5A41CDCCCCCC6FE5234166666626182A5A410000000034E5234166666606E3295A416666666630E52341000000C0E1295A41666666663BE3234100000040F0295A41666666663BE3234100000040F0295A41	01010000206A080000E60C3E346EE42341666666B60B2A5A41	751135117	H	Maison Blanche 17	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000600000009A999999E4EA23419A9999B9E3295A4166666666EFEA2341333333D3E3295A41CDCCCCCC56EB2341333333D3E4295A4133333333B5EB23419A9999B9E5295A416666666608EC234166666666E6295A41CDCCCCCC1AEC2341CDCCCC8CE6295A41333333332BEC2341000000E0DB295A410000000032EC2341CDCCCC6CD7295A419A99999946EC234133333373C9295A410000000056EC2341CDCCCCACC0295A413333333366EC234166666686B6295A416666666699EC2341CDCCCC8C96295A419A999999A6EC23419A9999598E295A4100000000B2EC2341CDCCCC8C88295A4100000000B6EC23419A99999986295A41CDCCCCCCC1EC2341666666667E295A4133333333CAEC2341666666C677295A4100000000B9EC23416666668677295A4100000000AEEC23419A99997977295A41CDCCCCCC06EC2341CDCCCC4C76295A41CDCCCCCCF0EB23410000002076295A419A999999A0EB23419A99997975295A419A9999999BEB2341666666666D295A419A99999999EB2341000000C068295A41CDCCCCCC98EB23416666662667295A410000000098EB23419A9999D964295A41CDCCCCCC95EB2341CDCCCCEC61295A416666666695EB23410000006061295A416666666694EB2341CDCCCCAC5F295A41CDCCCCCC90EB23419A9999995B295A419A9999998DEB2341666666A654295A41333333338CEB2341CDCCCC2C52295A41333333338AEB2341CDCCCC2C4E295A413333333388EB2341CDCCCC6C4C295A416666666685EB2341333333734B295A41333333337EEB2341666666A64A295A41CDCCCCCC7DEB2341000000E042295A410000000079EB23419A99999943295A413333333374EB23410000006044295A413333333370EB23419A9999F944295A41000000006AEB2341666666E645295A410000000064EB2341CDCCCCCC46295A41666666665DEB23419A9999B947295A419A99999955EB2341CDCCCCCC48295A419A9999994EEB2341666666A649295A419A99999946EB2341666666864A295A41000000003FEB2341000000604B295A413333333335EB2341666666464C295A419A9999992BEB2341CDCCCC0C4D295A413333333324EB2341000000A04D295A41CDCCCCCC1AEB2341000000604E295A413333333313EB23419A9999F94E295A41000000000CEB2341666666864F295A419A99999903EB23410000004050295A4166666666FBEA2341333333D350295A4166666666F2EA23419A99997951295A419A999999E8EA23419A99991952295A4133333333E8EA23410000002052295A4100000000E8EA2341CDCCCC0C59295A4100000000E8EA2341000000C059295A419A999999E9EA2341666666665C295A41CDCCCCCCEBEA2341000000805F295A4133333333EEEA2341CDCCCC6C61295A4166666666EEEA23410000004062295A4166666666EFEA2341CDCCCC8C64295A419A999999F3EA2341000000206D295A4100000000F8EA23413333333376295A4166666666F9EA23419A9999B979295A419A999999FAEA2341666666A67C295A419A999999FBEA2341000000407E295A419A999999FCEA2341CDCCCC6C7F295A413333333302EB2341CDCCCC0C8A295A419A99999907EB2341333333938D295A419A99999905EB23419A9999D991295A41333333330AEB2341333333F39A295A419A9999990CEB23419A999939A4295A41666666660CEB23419A9999F9AC295A41666666660BEB234100000060AE295A419A9999990BEB234100000080B2295A41000000000BEB234100000080B4295A413333333309EB2341666666E6BB295A413333333307EB2341000000C0BE295A416666666604EB2341CDCCCC6CBF295A4100000000FFEA2341CDCCCC0CC0295A419A999999FBEA2341CDCCCCACC0295A4100000000FCEA23419A999919C1295A4133333333FDEA234100000080C1295A419A999999FFEA2341666666C6C1295A416666666602EB2341666666E6C1295A419A999999FFEA234166666626C4295A4166666666FAEA234166666686CD295A4133333333F3EA2341333333F3D6295A4133333333EFEA2341CDCCCC8CDE295A419A999999EEEA2341333333B3DF295A41CDCCCCCCEBEA2341333333F3E0295A419A999999E4EA23419A9999B9E3295A41	01060000206A080000010000000103000000010000000D0000009A999999E4EA23419A9999B9E3295A41CDCCCCCC1AEC2341CDCCCC8CE6295A4133333333CAEC2341666666C677295A419A999999A0EB23419A99997975295A41333333338AEB2341CDCCCC2C4E295A41CDCCCCCC7DEB2341000000E042295A413333333335EB2341666666464C295A4133333333E8EA23410000002052295A419A9999990CEB23419A999939A4295A413333333307EB2341000000C0BE295A419A999999EEEA2341333333B3DF295A419A999999E4EA23419A9999B9E3295A419A999999E4EA23419A9999B9E3295A41	01010000206A0800001B7344FCD1EB23413433333394295A41	751135106	H	Maison Blanche 6	7511351	75113	75	11	0
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	01060000206A080000010000000103000000010000000A000000CDCCCCCC7DEB2341000000E042295A41333333338AEB2341CDCCCC2C4E295A419A999999A0EB23419A99997975295A4133333333CAEC2341666666C677295A413333333356ED23419A9999791E295A4100000000D9EC23413333333320295A419A99999982EC23419A99999923295A413333333322EC23419A9999592B295A41CDCCCCCC7DEB2341000000E042295A41CDCCCCCC7DEB2341000000E042295A41	01010000206A080000D2455D5449EC2341CCCCCC0C4B295A41	751135107	H	Maison Blanche 7	7511351	75113	75	11	0
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	01060000206A0800000100000001030000000100000027000000000000005DE4234166666606C7285A410000000067E42341333333B3D2285A410000000082E423419A9999B9FE285A419A9999999CE42341333333F311295A4133333333C8E42341000000E02B295A419A99999932E52341333333F32A295A419A9999995FE62341333333F339295A419A99999956E723419A99999946295A41000000007CE823419A99995954295A413333333335E92341000000E053295A4100000000A0EA2341CDCCCCEC53295A41CDCCCCCCC9EA23413333337353295A413333333335EB2341666666464C295A410000000064EB2341CDCCCCCC46295A413333333322EC23419A9999592B295A419A99999982EC23419A99999923295A4100000000D9EC23413333333320295A413333333356ED23419A9999791E295A41666666667AED2341333333D305295A4133333333A1ED23419A9999D9EE285A4100000000B9ED2341666666A6DA285A4133333333D1ED234100000080CD285A41CDCCCCCCE6ED2341000000E0CC285A41000000009EEB23419A999979CA285A413333333338EB2341CDCCCC8CC9285A41CDCCCCCC95EA234133333373E2285A4166666666A0E92341666666A604295A41CDCCCCCC40E923410000002013295A419A99999998E82341CDCCCCEC02295A41CDCCCCCC28E7234166666686E4285A419A9999993EE62341333333D3CF285A419A99999918E62341CDCCCC8CCD285A4100000000C8E52341333333F3CC285A419A9999994EE52341CDCCCC6CCF285A41CDCCCCCCDAE4234166666666CF285A4100000000A0E42341000000E0CD285A41CDCCCCCCACE4234100000040C1285A41000000005DE4234166666606C7285A41000000005DE4234166666606C7285A41	01010000206A08000099999991D1E62341000000100E295A41	751135108	H	Maison Blanche 8	7511351	75113	75	11	0
01060000206A080000010000000103000000010000002C00000066666666DBE22341666666E6892A5A4166666666E3E22341CDCCCC6C892A5A416666666652E32341333333B3832A5A4100000000B4E32341666666867E2A5A41CDCCCCCCF9E32341000000207B2A5A41CDCCCCCC56E4234100000060762A5A4166666666AAE4234166666606722A5A419A999999A5E423419A9999F96D2A5A4166666666A4E423419A9999196D2A5A41333333339FE4234100000000692A5A41333333339AE4234133333373662A5A416666666693E4234166666606632A5A41333333338DE423419A999919602A5A419A99999985E42341CDCCCCCC5C2A5A41666666667DE4234133333333592A5A419A99999974E42341000000C0552A5A41CDCCCCCC6EE42341666666E6532A5A41666666662CE423419A9999393E2A5A41CDCCCCCC1AE42341CDCCCC6C382A5A419A99999912E4234133333353362A5A4133333333F3E323419A9999792F2A5A419A999999D8E32341666666662A2A5A419A999999BDE32341CDCCCC6C252A5A41CDCCCCCCB1E323419A9999D9222A5A4100000000ACE32341CDCCCC2C212A5A4133333333A0E32341CDCCCC0C1C2A5A41000000005EE3234166666646FF295A41666666663BE3234100000040F0295A419A9999991DE3234133333373F1295A410000000027E323419A999999122A5A413333333322E323419A999939252A5A410000000015E3234166666626322A5A41CDCCCCCC0BE32341000000C0392A5A410000000006E32341CDCCCCEC3D2A5A416666666600E32341CDCCCC0C432A5A41CDCCCCCCF9E2234100000000542A5A4133333333F7E22341333333B35A2A5A4133333333F4E2234133333373632A5A4133333333F3E22341CDCCCC0C6D2A5A41CDCCCCCCF2E22341666666A6752A5A41CDCCCCCCF3E223419A9999797C2A5A41CDCCCCCCF4E223419A9999397F2A5A419A999999E7E22341666666C6842A5A4166666666DBE22341666666E6892A5A41	01060000206A080000010000000103000000010000000F00000066666666DBE22341666666E6892A5A4166666666AAE4234166666606722A5A41333333339FE4234100000000692A5A419A99999974E42341000000C0552A5A41CDCCCCCC1AE42341CDCCCC6C382A5A4100000000ACE32341CDCCCC2C212A5A41666666663BE3234100000040F0295A419A9999991DE3234133333373F1295A410000000027E323419A999999122A5A413333333322E323419A999939252A5A416666666600E32341CDCCCC0C432A5A4133333333F4E2234133333373632A5A41CDCCCCCCF4E223419A9999397F2A5A4166666666DBE22341666666E6892A5A4166666666DBE22341666666E6892A5A41	01010000206A080000C0E30F0797E32341666666D63B2A5A41	751135118	H	Maison Blanche 18	7511351	75113	75	11	0
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	01060000206A08000001000000010300000001000000120000009A9999995DE92341333333B367295A410000000062E92341333333D36E295A41CDCCCCCCC4E9234166666686A0295A4133333333B0E9234100000000A2295A419A999999A6E92341000000A0A7295A4133333333B4E92341CDCCCCACAA295A4166666666DDE923419A9999B9AB295A41666666662AEA234166666666D3295A41CDCCCCCC06EA23419A9999B9E1295A419A999999E4EA23419A9999B9E3295A419A999999EEEA2341333333B3DF295A413333333307EB2341000000C0BE295A419A9999990CEB23419A999939A4295A4133333333E8EA23410000002052295A4100000000B6EA2341333333D353295A419A9999995FE92341000000E053295A419A9999995DE92341333333B367295A419A9999995DE92341333333B367295A41	01010000206A080000BC5F57335FEA23410000006098295A41	751135109	H	Maison Blanche 9	7511351	75113	75	11	0
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	01060000206A0800000100000001030000000100000016000000666666669AE32341CDCCCC2C65295A4133333333DDE323416666666668295A41000000000EE423413333333369295A419A999999ABE52341CDCCCC0C77295A410000000012E62341000000807B295A41333333335FE62341000000A078295A4166666666D5E723410000002078295A4166666666F6E72341666666C676295A41CDCCCCCC27E82341666666A678295A413333333372E92341CDCCCC2C77295A419A9999995DE92341333333B367295A419A9999995FE92341000000E053295A41000000007CE823419A99995954295A419A99999956E723419A99999946295A419A9999995FE62341333333F339295A419A99999932E52341333333F32A295A4133333333C8E42341000000E02B295A4133333333C9E423419A99997930295A410000000058E423416666668648295A4166666666DBE32341333333935A295A41666666669AE32341CDCCCC2C65295A41666666669AE32341CDCCCC2C65295A41	01010000206A080000247B066231E62341000000A052295A41	751135110	H	Maison Blanche 10	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000320000000000000012E62341000000807B295A419A99999930E623419A99999981295A41CDCCCCCC40E623413333335384295A41666666669EE623410000008095295A419A999999C0E62341CDCCCC8C9B295A410000000018E7234133333333AC295A41000000002FE7234166666606AB295A41CDCCCCCCE4E723419A999999A9295A41CDCCCCCC1BE82341333333F3A8295A41000000004CE82341666666E6A8295A419A99999980E82341CDCCCC8CA8295A41CDCCCCCCCCE8234100000000A8295A41CDCCCCCC32E9234133333333A7295A41666666663CE9234100000020A7295A41CDCCCCCC6AE923419A9999B9A6295A4166666666A5E9234133333373A6295A419A999999A5E92341666666E6A4295A4166666666A9E9234166666666A3295A4133333333B0E9234100000000A2295A4100000000BAE9234100000000A1295A41CDCCCCCCC4E9234166666686A0295A4133333333BBE92341000000409B295A4166666666B0E92341CDCCCCCC95295A41000000009AE92341000000608B295A41666666667AE923419A9999997A295A413333333372E92341CDCCCC2C77295A41CDCCCCCC3AE923416666664677295A413333333303E923419A99999977295A4133333333B8E82341CDCCCC0C78295A41CDCCCCCC6BE82341CDCCCC4C78295A41CDCCCCCC27E82341666666A678295A41666666660FE823419A99995978295A416666666608E823416666660678295A4166666666FCE723413333337377295A4166666666F6E72341666666C676295A41CDCCCCCCDFE72341000000E077295A4166666666D5E723410000002078295A41CDCCCCCCA0E723410000004078295A41666666668FE72341CDCCCC4C78295A413333333382E723413333335378295A413333333369E723416666664678295A41333333333CE723410000006078295A410000000014E723413333337378295A4166666666E2E62341CDCCCC6C78295A41333333335FE62341000000A078295A419A99999954E623419A99997978295A416666666645E62341CDCCCCCC78295A419A99999935E62341CDCCCC4C79295A410000000028E623419A9999197A295A410000000012E62341000000807B295A41	01060000206A080000010000000103000000010000000D0000000000000012E62341000000807B295A419A999999C0E62341CDCCCC8C9B295A410000000018E7234133333333AC295A41000000002FE7234166666606AB295A4166666666A5E9234133333373A6295A41CDCCCCCCC4E9234166666686A0295A413333333372E92341CDCCCC2C77295A41CDCCCCCC27E82341666666A678295A4166666666F6E72341666666C676295A4166666666D5E723410000002078295A41333333335FE62341000000A078295A410000000012E62341000000807B295A410000000012E62341000000807B295A41	01010000206A080000143916D813E823410000007090295A41	751135111	H	Maison Blanche 11	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000240000000000000018E7234133333333AC295A410000000056E7234100000080B7295A41333333336FE7234133333313BC295A416666666689E723419A9999D9C0295A41CDCCCCCCB6E723419A999919C9295A413333333328E8234166666666DD295A410000000054E82341CDCCCC6CDD295A4133333333F5E82341CDCCCC2CDF295A410000000031E92341000000C0DF295A416666666682E923419A999979E0295A4166666666FBE92341000000A0E1295A41CDCCCCCC06EA23419A9999B9E1295A41666666661DEA2341333333D3D7295A41000000001FEA234133333353D7295A41666666662AEA234166666666D3295A41666666660EEA2341CDCCCC6CC5295A410000000001EA23419A9999B9BE295A4166666666DDE923419A9999B9AB295A4133333333D2E92341CDCCCCECAB295A4166666666C6E92341666666C6AB295A4166666666BCE923419A999959AB295A4133333333B4E92341CDCCCCACAA295A419A999999AEE923419A9999B9A9295A41CDCCCCCCA9E923419A9999B9A8295A419A999999A6E92341000000A0A7295A4166666666A5E9234133333373A6295A41CDCCCCCC6AE923419A9999B9A6295A41666666663CE9234100000020A7295A41CDCCCCCC32E9234133333333A7295A41CDCCCCCCCCE8234100000000A8295A419A99999980E82341CDCCCC8CA8295A41000000004CE82341666666E6A8295A41CDCCCCCC1BE82341333333F3A8295A41CDCCCCCCE4E723419A999999A9295A41000000002FE7234166666606AB295A410000000018E7234133333333AC295A41	01060000206A080000010000000103000000010000000B0000000000000018E7234133333333AC295A413333333328E8234166666666DD295A410000000054E82341CDCCCC6CDD295A41CDCCCCCC06EA23419A9999B9E1295A41666666662AEA234166666666D3295A4166666666DDE923419A9999B9AB295A4133333333B4E92341CDCCCCACAA295A4166666666A5E9234133333373A6295A41000000002FE7234166666606AB295A410000000018E7234133333333AC295A410000000018E7234133333333AC295A41	01010000206A080000835716E8CFE8234134333323C3295A41	751135112	H	Maison Blanche 12	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000190000009A999999F9E5234166666666DC295A41CDCCCCCC59E62341000000C0D9295A41000000006BE6234100000060D9295A4133333333C6E6234133333333DA295A41CDCCCCCCEEE6234133333393DA295A413333333328E8234166666666DD295A41CDCCCCCCB6E723419A999919C9295A416666666689E723419A9999D9C0295A41333333336FE7234133333313BC295A410000000056E7234100000080B7295A410000000018E7234133333333AC295A419A999999C0E62341CDCCCC8C9B295A41666666669EE623410000008095295A41CDCCCCCC40E623413333335384295A419A99999930E623419A99999981295A410000000012E62341000000807B295A410000000010E62341CDCCCC6C82295A416666666611E623419A99995985295A41666666660EE62341333333538E295A41333333330AE62341000000009D295A410000000002E623419A9999F9BF295A41CDCCCCCC02E62341CDCCCC4CC2295A413333333301E6234133333393C6295A410000000000E62341333333F3C9295A419A999999F9E5234166666666DC295A41	01060000206A08000001000000010300000001000000090000009A999999F9E5234166666666DC295A41000000006BE6234100000060D9295A413333333328E8234166666666DD295A410000000018E7234133333333AC295A419A999999C0E62341CDCCCC8C9B295A410000000012E62341000000807B295A410000000002E623419A9999F9BF295A419A999999F9E5234166666666DC295A419A999999F9E5234166666666DC295A41	01010000206A080000952FE4279EE623419A9999D9B1295A41	751135113	H	Maison Blanche 13	7511351	75113	75	11	0
01060000206A080000010000000103000000010000001A000000CDCCCCCC39E323419A999959EF295A41666666663BE3234100000040F0295A41000000005DE3234133333333EF295A41666666668AE42341CDCCCC8CE6295A416666666630E52341000000C0E1295A419A999999F9E5234166666666DC295A410000000000E62341333333F3C9295A413333333301E6234133333393C6295A41CDCCCCCC02E62341CDCCCC4CC2295A410000000002E623419A9999F9BF295A41333333330AE62341000000009D295A41666666660EE62341333333538E295A416666666611E623419A99995985295A410000000010E62341CDCCCC6C82295A410000000012E62341000000807B295A41CDCCCCCCE2E52341666666C680295A419A999999D3E523413333333383295A413333333390E52341CDCCCCEC8D295A41CDCCCCCC35E52341000000409C295A41CDCCCCCC23E523419A9999199F295A41CDCCCCCCCCE4234166666646AD295A419A999999B6E42341000000E0B0295A419A9999990DE423419A999979CC295A41333333335BE3234166666646EA295A413333333354E3234166666666EB295A41CDCCCCCC39E323419A999959EF295A41	01060000206A080000010000000103000000010000000A000000CDCCCCCC39E323419A999959EF295A41000000005DE3234133333333EF295A416666666630E52341000000C0E1295A419A999999F9E5234166666666DC295A410000000002E623419A9999F9BF295A410000000012E62341000000807B295A41CDCCCCCCE2E52341666666C680295A41CDCCCCCC23E523419A9999199F295A41CDCCCCCC39E323419A999959EF295A41CDCCCCCC39E323419A999959EF295A41	01010000206A0800009820ED1146E52341CDCCCC6CB8295A41	751135114	H	Maison Blanche 14	7511351	75113	75	11	0
01060000206A08000001000000010300000001000000360000006666666684E92341000000401D2A5A416666666698E9234166666606222A5A4166666666A4E92341000000C0242A5A4166666666ACE92341666666A6262A5A4100000000FFE923419A999959392A5A41333333337EEA23419A999939562A5A41CDCCCCCC97EA2341000000205C2A5A41CDCCCCCCBFEA234166666666652A5A4100000000C0EA234100000080652A5A41666666668EEA2341666666E66A2A5A41CDCCCCCC86EA2341333333F36D2A5A4100000000D8EA23419A9999D9722A5A41CDCCCCCCE8EA2341000000E0732A5A41000000002CEB2341000000C0792A5A41333333337DEB2341666666C6702A5A41CDCCCCCC7BEB2341CDCCCC4C6C2A5A41000000008EEB234100000080682A5A413333333397EB2341CDCCCC2C662A5A4166666666A6EB234100000060622A5A419A99999909EC23419A9999794A2A5A419A9999995EEC2341333333F3352A5A41CDCCCCCC9EEC2341CDCCCC6C262A5A41CDCCCCCCCBEC2341666666461B2A5A4100000000ACEC2341CDCCCC6C1A2A5A419A99999987EC2341CDCCCCEC182A5A413333333358EC2341666666C6162A5A41CDCCCCCC2AEC234100000040152A5A419A99999921EC234133333313152A5A413333333300EC234100000060142A5A4166666666F3EB23419A999919142A5A41CDCCCCCCE4EB2341666666A6132A5A4100000000D4EB23419A999939132A5A4100000000BEEB23419A9999D9212A5A419A999999AAEB234166666626212A5A41000000009DEB2341333333D3202A5A419A99999986EB2341CDCCCCCC1F2A5A41000000007EEB2341333333531F2A5A4166666666E5EA234166666606172A5A4166666666C2EA23419A9999B9142A5A41333333337BEA23419A9999D90F2A5A41CDCCCCCC5FEA2341666666060E2A5A419A99999954EA2341000000400D2A5A41000000003BEA2341333333B30B2A5A419A99999924EA2341666666A60A2A5A419A99999913EA23419A9999790A2A5A419A99999906EA2341666666E60A2A5A41CDCCCCCCFEE923419A9999590B2A5A419A999999EAE92341000000000D2A5A419A999999E7E923419A9999590D2A5A4166666666DCE923419A9999B90E2A5A4133333333ACE92341000000A0162A5A419A99999998E92341333333131A2A5A41666666668FE92341666666661B2A5A416666666684E92341000000401D2A5A41	01060000206A08000001000000010300000001000000140000006666666684E92341000000401D2A5A4100000000C0EA234100000080652A5A41666666668EEA2341666666E66A2A5A41CDCCCCCC86EA2341333333F36D2A5A41CDCCCCCCE8EA2341000000E0732A5A41000000002CEB2341000000C0792A5A41333333337DEB2341666666C6702A5A41CDCCCCCC7BEB2341CDCCCC4C6C2A5A4166666666A6EB234100000060622A5A41CDCCCCCCCBEC2341666666461B2A5A41CDCCCCCC2AEC234100000040152A5A4100000000D4EB23419A999939132A5A4100000000BEEB23419A9999D9212A5A419A99999986EB2341CDCCCCCC1F2A5A4166666666E5EA234166666606172A5A419A99999924EA2341666666A60A2A5A41CDCCCCCCFEE923419A9999590B2A5A4166666666DCE923419A9999B90E2A5A416666666684E92341000000401D2A5A416666666684E92341000000401D2A5A41	01010000206A080000B6A1BFE328EB23419A9999E9412A5A41	751135124	H	Maison Blanche 24	7511351	75113	75	11	0
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	01060000206A08000001000000010300000001000000110000006666666684E92341000000401D2A5A4166666666DCE923419A9999B90E2A5A41CDCCCCCCFEE923419A9999590B2A5A419A99999924EA2341666666A60A2A5A4166666666E5EA234166666606172A5A419A99999986EB2341CDCCCCCC1F2A5A4100000000BEEB23419A9999D9212A5A4100000000D4EB23419A999939132A5A41CDCCCCCC2AEC234100000040152A5A41CDCCCCCCCBEC2341666666461B2A5A419A99999984ED234100000040ED295A4100000000AAED234133333393E5295A41CDCCCCCC1AEC2341CDCCCC8CE6295A41CDCCCCCC06EA23419A9999B9E1295A4133333333A1E92341666666A60D2A5A416666666684E92341000000401D2A5A416666666684E92341000000401D2A5A41	01010000206A08000086DDBEED73EB234166666616032A5A41	751135125	H	Maison Blanche 25	7511351	75113	75	11	0
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	01060000206A080000010000000103000000010000001E00000066666666D8E7234133333393FB2A5A419A999999D3E823419A9999B9092B5A419A99999915E923419A9999990E2B5A410000000021E92341333333530A2B5A4100000000A5E92341000000A0E42A5A419A999999D6E9234100000080D92A5A4100000000D4EA234133333333912A5A41000000002CEB2341000000C0792A5A41CDCCCCCCE8EA2341000000E0732A5A41CDCCCCCC86EA2341333333F36D2A5A41CDCCCCCC7BEA234166666686722A5A41666666667CE9234133333333632A5A419A9999998DE92341CDCCCCAC7F2A5A4133333333FCE823419A9999F98A2A5A419A999999E3E823419A9999198B2A5A41333333339DE82341CDCCCC8C862A5A419A99999962E82341000000A07F2A5A413333333333E823419A9999B9812A5A419A999999ECE72341CDCCCC8C8B2A5A410000000077E8234166666686992A5A4133333333C2E82341666666C6A42A5A419A999999EDE823419A9999D9B42A5A4166666666F3E8234166666666B92A5A4133333333E3E82341CDCCCC0CC52A5A41CDCCCCCCADE82341CDCCCC2CD22A5A410000000084E82341CDCCCC0CD92A5A413333333340E82341333333B3E12A5A4166666666E9E723419A999979F22A5A4166666666D8E7234133333393FB2A5A