SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep77;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep77 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep77','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep77','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep77','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep77"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000784489306260244100000010D7F55941	770010000	Z	Achères-la-Forêt	7700100	77001	77	11	13
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	01010000206A0800008EEDEB90F0A82541CDCCCC0C951F5A41	770020000	Z	Amillis	7700200	77002	77	11	20
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	01010000206A08000075D84847F94B2441CDCCCCCC93EF5941	770030000	Z	Amponville	7700300	77003	77	11	12
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	01010000206A0800002AC35CB698EF2441CDCCCC0CAF125A41	770040000	Z	Andrezel	7700400	77004	77	11	8
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	01010000206A080000E7A1D38053B224413433334347345A41	770050000	Z	Annet-sur-Marne	7700500	77005	77	11	13
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	01010000206A080000B8EA1FD0836124419A99992939FC5941	770060000	Z	Arbonne-la-Forêt	7700600	77006	77	11	15
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	01010000206A0800000FDFCFD13510254133333373DC165A41	770070000	Z	Argentières	7700700	77007	77	11	3
01060000206A080000010000000103000000010000000B02000033333333C5502541666666867B3A5A4133333333D8502541666666667B3A5A41CDCCCCCCDE502541333333737B3A5A4100000000EA502541000000807B3A5A4133333333F0502541666666867B3A5A419A999999175125419A9999B97B3A5A41CDCCCCCC33512541666666067C3A5A410000000053512541CDCCCC0C7D3A5A419A99999996512541333333337F3A5A41CDCCCCCCCD5125419A9999D9803A5A419A999999F151254166666626823A5A4166666666FE51254166666686823A5A413333333308522541000000C0823A5A41666666669052254166666686873A5A41CDCCCCCC04532541000000408C3A5A416666666651532541CDCCCC4C8F3A5A41000000006053254166666606903A5A4100000000A6532541CDCCCCAC933A5A413333333310542541333333B3983A5A41000000006F542541CDCCCC8C9E3A5A419A999999B5542541CDCCCC8CA33A5A419A999999C5542541CDCCCCECA43A5A4166666666FE542541CDCCCCECA93A5A41333333335055254166666626B23A5A41333333338755254133333353B73A5A4133333333A755254166666646BA3A5A4133333333B6552541666666C6BB3A5A41CDCCCCCCD3552541333333B3BE3A5A4133333333355625419A999939C93A5A41CDCCCCCC4956254133333373CB3A5A419A9999994B562541000000A0CB3A5A41666666664F56254166666646CC3A5A419A9999999356254133333393D73A5A41CDCCCCCC1A5725419A999939EC3A5A41CDCCCCCC4357254100000080F23A5A419A99999953572541666666E6F43A5A41333333335957254133333353F43A5A41666666664C5725419A9999D9ED3A5A41666666664E572541666666E6EC3A5A413333333358572541000000C0E73A5A41333333337B572541000000C0D33A5A41666666669457254100000000C73A5A41CDCCCCCCDD572541CDCCCC0CA43A5A4166666666F15725419A9999B99A3A5A4133333333FE572541CDCCCCAC933A5A419A9999990C5825419A9999598C3A5A4133333333155825419A9999398C3A5A41CDCCCCCCA6582541000000A08D3A5A419A999999AB582541333333B3963A5A419A999999B1582541CDCCCC4CA03A5A41CDCCCCCCB2582541CDCCCC6CA13A5A4100000000AE582541CDCCCCECA73A5A4133333333A95825419A9999D9AC3A5A4133333333AF58254166666606AD3A5A41666666661E592541CDCCCC2CB03A5A419A999999A859254100000020B43A5A4100000000C0592541CDCCCC8CB53A5A41333333337F5A2541CDCCCC0CBF3A5A4133333333FE5A2541CDCCCCACC53A5A41CDCCCCCC0A5B2541333333D3B63A5A41CDCCCCCC2F5C254166666686BA3A5A41CDCCCCCC9C5C254133333313BC3A5A419A999999A35C254133333333BC3A5A4100000000B85C254166666626BE3A5A4133333333185D25419A9999D9C73A5A419A9999999F5D254133333353D53A5A4100000000A45D2541666666C6D53A5A41000000000A5E254166666626E03A5A41333333335A5E254133333333E83A5A41000000006A5E254100000080E93A5A4166666666795E25419A999999EA3A5A4166666666885E2541333333B3EB3A5A4133333333AE5E254133333393EE3A5A419A999999B35E254100000000EF3A5A419A999999EC5E2541CDCCCCACF33A5A41CDCCCCCCEF5E2541333333F3F33A5A41666666661B5F254133333373F83A5A41666666664A5F25419A9999F9FC3A5A41000000006A5F2541666666E6FE3A5A4133333333D75F2541333333D3053B5A419A999999E35F254133333393063B5A416666666676602541666666660F3B5A4100000000E8602541CDCCCC6C163B5A41CDCCCCCCFF602541333333F3173B5A410000000071612541333333131F3B5A41666666669A612541666666A6213B5A41CDCCCCCCBE612541333333F3233B5A416666666616622541CDCCCC8C293B5A410000000020622541CDCCCC2C2A3B5A41666666667D62254100000020303B5A41000000008A6225419A9999B9303B5A4166666666BC62254100000080323B5A41333333334063254166666626383B5A419A999999C8632541000000E03E3B5A416666666660642541666666C6463B5A413333333395642541666666264A3B5A41CDCCCCCC9E642541CDCCCC0C4B3B5A4133333333C7642541000000004F3B5A41CDCCCCCCCB642541666666864F3B5A41CDCCCCCCD464254100000040503B5A419A999999E1642541000000C0503B5A41333333338165254166666646583B5A41000000008665254100000080583B5A410000000087652541CDCCCC8C583B5A410000000090652541CDCCCC0C593B5A41333333338A6525419A9999B95A3B5A419A9999996E6525419A9999D9623B5A419A9999999265254166666626653B5A4100000000EB652541333333336B3B5A4100000000AA662541666666C6753B5A410000000027672541333333F37B3B5A41333333333D672541000000E07C3B5A4166666666B2672541000000C0813B5A41CDCCCCCCC867254133333313833B5A4166666666D067254166666686833B5A4166666666F8672541CDCCCCEC853B5A41CDCCCCCC306825419A9999B9883B5A416666666651682541000000608A3B5A4133333333A268254100000020903B5A41333333336B692541000000C09E3B5A4133333333206A25419A9999B9AB3B5A41000000002C6A2541CDCCCC8CAC3B5A4166666666896A2541CDCCCCACB33B5A4133333333EC6A25419A9999D9BA3B5A4133333333D06B25419A999979CB3B5A419A999999E96B2541CDCCCC4CCD3B5A4166666666606C254133333333D33B5A41CDCCCCCCE06C2541666666E6D83B5A419A999999456D254133333353DD3B5A41000000007C6D2541CDCCCC8CDF3B5A419A9999998C6D25419A999939E03B5A4133333333A76D254100000080E13B5A4100000000DB6D2541333333F3E33B5A41CDCCCCCCB76E254166666626ED3B5A41000000005F6F2541666666A6F43B5A4166666666656F2541333333F3F43B5A41000000000E70254166666626FC3B5A41333333337370254166666666003C5A4133333333E37025419A999919053C5A419A9999991971254166666666073C5A419A9999993271254100000000083C5A419A9999995C712541CDCCCCAC0A3C5A4133333333BC712541CDCCCCCC0E3C5A419A999999EC71254133333313103C5A416666666645732541CDCCCCEC183C5A41666666666273254133333313193C5A4100000000D2732541333333D3183C5A419A99999911742541CDCCCCAC183C5A4100000000057425419A999959113C5A41CDCCCCCCFC7325419A9999990C3C5A41CDCCCCCCE97325419A999979013C5A4133333333E0732541333333F3F63B5A4133333333E17325419A9999B9E93B5A4166666666E17325419A999999E53B5A4133333333EF73254166666686D93B5A413333333309742541CDCCCCACCC3B5A41000000002F74254133333333BF3B5A41333333337A742541CDCCCC2CB03B5A419A999999F2742541666666A69F3B5A41333333332975254100000020943B5A419A9999994B75254133333313893B5A41666666665E752541CDCCCC0C7E3B5A41666666665E75254100000040763B5A41000000005E75254166666686713B5A41333333335B752541000000C0613B5A41CDCCCCCC5F7525419A9999395B3B5A413333333366752541333333F3523B5A419A99999984752541666666A63B3B5A419A999999B875254100000060253B5A419A999999EE752541333333B3123B5A41CDCCCCCC1D7625419A999999023B5A41CDCCCCCC1E76254133333353023B5A419A9999995D7625419A9999B9EB3A5A41CDCCCCCC9A762541CDCCCCCCD53A5A4133333333D17625419A9999D9B93A5A4166666666D27625419A999979AB3A5A4100000000D376254166666606A63A5A41333333336876254133333333813A5A4166666666B97525419A9999195A3A5A416666666615752541CDCCCC8C363A5A4166666666D4742541000000202D3A5A41333333339F74254166666666253A5A41000000006D742541000000201E3A5A416666666654742541CDCCCC8C1A3A5A419A999999DF732541000000C00D3A5A4133333333D3732541000000C00C3A5A416666666676732541CDCCCC0C053A5A4100000000D4722541333333B3F8395A41666666661C722541666666C6EC395A4166666666FF712541000000E0EA395A41000000005571254133333373E1395A419A999999077125419A999979DE395A41CDCCCCCCAA702541666666E6DA395A41CDCCCCCCFD6F2541CDCCCCECD7395A4133333333F96E25419A999939D6395A41CDCCCCCCAC6E2541333333F3D5395A41000000000F6E2541CDCCCC8CD5395A4100000000F16D25419A999959D5395A41666666660A6D25419A9999F9D3395A4100000000026D2541666666C6D3395A4166666666FF6B254166666626CD395A41CDCCCCCCFC6B254133333313CD395A419A999999C76B2541333333B3CB395A4133333333796B254133333393C9395A419A999999046B25419A999979C6395A4100000000886A2541CDCCCCCCC2395A4166666666286A2541000000E0C1395A4133333333C16925419A999959C2395A41CDCCCCCC2969254166666686C6395A4100000000B36825419A9999D9CC395A41CDCCCCCC2E68254100000020D3395A4133333333A4672541000000E0D7395A4133333333DA66254100000020E1395A41333333336B6525419A999979F9395A419A9999994864254166666686083A5A413333333316642541000000000B3A5A4133333333DB632541CDCCCCEC0D3A5A413333333391632541CDCCCC4C133A5A41CDCCCCCC6A63254133333373163A5A41333333334963254100000040193A5A41CDCCCCCC066325419A9999791D3A5A419A999999E8622541CDCCCC6C1F3A5A419A999999A862254166666686243A5A41666666667E622541CDCCCCEC273A5A41CDCCCCCC6B62254166666666293A5A41333333332C622541CDCCCC6C2E3A5A419A999999F661254133333313323A5A4166666666C06125419A9999B9353A5A41666666665761254133333333373A5A419A999999D26025419A9999D9363A5A413333333321602541000000E02B3A5A4133333333905F25419A9999B91C3A5A41666666668B5F25419A9999391C3A5A4166666666625F25419A9999B9163A5A4166666666DD5E2541000000E0043A5A4166666666505E2541CDCCCC6CF4395A419A999999D15D2541333333B3E8395A41CDCCCCCCBD5D2541CDCCCC0CE5395A4133333333955D2541CDCCCC8CDD395A41CDCCCCCC915D25419A9999F9DC395A4133333333455D2541CDCCCCCCCE395A41333333339C5C2541CDCCCC0CAF395A41CDCCCCCC5E5C25410000002096395A4166666666485C2541CDCCCC0C8D395A4133333333355C25416666662685395A419A9999992F5C2541CDCCCC8C81395A419A999999045C2541CDCCCCCC65395A4100000000E85B2541CDCCCC0C40395A419A999999E55B25419A9999993C395A4166666666E55B25419A9999791C395A4166666666E55B2541CDCCCCCC18395A419A999999E95B25419A99999915395A4133333333175C25419A9999D9F3385A41CDCCCCCC645C25419A999939CE385A4133333333795C2541CDCCCC6CC4385A4100000000945C2541333333B3BE385A41CDCCCCCCAE5C254166666606B9385A4133333333BE5C2541333333D3B5385A4100000000CB5C2541CDCCCCCCB4385A4133333333525D254133333313AA385A4133333333885D2541333333B3A4385A419A9999995A5D2541666666669F385A4133333333415D2541000000A09C385A41CDCCCCCC2F5D2541666666C69A385A419A999999275D2541333333D399385A4133333333285D2541CDCCCC2C99385A41000000002B5D25413333333398385A41CDCCCCCC3D5D25416666662694385A4166666666475D2541CDCCCC4C91385A4166666666685D25419A9999F989385A4133333333765D25416666662687385A41CDCCCCCC975D2541333333D380385A41CDCCCCCCAC5D2541666666267D385A4100000000C55D25416666662679385A4166666666D05D25413333333377385A4166666666D45D2541CDCCCC2C76385A4133333333D35D25419A9999B975385A4133333333CA5D2541000000C074385A41000000007C5D2541CDCCCCAC6D385A4100000000425D25419A99995968385A41CDCCCCCC2A5D2541CDCCCC2C66385A4133333333275D25419A9999B965385A41CDCCCCCC075D25416666668665385A4100000000F75C2541CDCCCC8C64385A4166666666E25C25419A99995960385A41CDCCCCCCCF5C25419A9999595D385A419A999999AF5C2541666666A655385A4100000000965C25419A9999F94D385A41CDCCCCCC815C25410000004045385A41333333335E5C2541666666463F385A4133333333535C2541666666C63C385A419A999999455C2541666666A639385A41333333332A5C2541666666E631385A4133333333275C2541000000202E385A4100000000245C2541000000602A385A4100000000205C2541333333532A385A41000000001E5C2541333333532A385A41CDCCCCCC1B5C2541CDCCCC4C2A385A41CDCCCCCC195C2541666666462A385A41CDCCCCCC175C2541666666462A385A41CDCCCCCC155C2541666666462A385A419A999999135C2541666666462A385A419A999999115C2541000000402A385A419A9999990F5C25419A9999392A385A419A9999990D5C25419A9999392A385A41666666660B5C2541333333332A385A4166666666095C2541333333332A385A4166666666075C2541CDCCCC2C2A385A4166666666055C2541666666262A385A4133333333035C2541666666262A385A4133333333015C2541000000202A385A4133333333FF5B2541000000202A385A4133333333FD5B2541000000202A385A4100000000FB5B25419A9999192A385A4100000000F75B2541333333132A385A4100000000F35B2541CDCCCC0C2A385A4100000000EF5B2541666666062A385A4100000000EB5B2541000000002A385A4100000000E95B25419A9999F929385A4100000000E75B2541333333F329385A4100000000E55B25419A9999F929385A4100000000E35B2541333333F329385A4100000000E15B2541CDCCCCEC29385A4100000000DF5B2541CDCCCCEC29385A4100000000DD5B2541666666E629385A4100000000DB5B2541000000E029385A4100000000D95B2541000000E029385A4100000000D75B25419A9999D929385A4100000000D55B2541333333D329385A4100000000D35B2541333333D329385A4100000000D15B2541CDCCCCCC29385A4100000000CF5B2541CDCCCCCC29385A4100000000CD5B2541CDCCCCCC29385A4100000000CB5B2541666666C629385A4100000000C95B2541666666C629385A4100000000C75B2541000000C029385A4100000000C55B25419A9999B929385A4100000000C35B25419A9999B929385A4100000000C15B2541333333B329385A4100000000BF5B2541CDCCCCAC29385A4100000000BD5B2541CDCCCCAC29385A4100000000BB5B2541666666A629385A4100000000B95B2541000000A029385A4100000000B75B2541666666A629385A4100000000B55B2541000000A029385A4100000000B35B25419A99999929385A4100000000B15B25419A99999929385A4100000000AF5B25413333339329385A4100000000AD5B2541CDCCCC8C29385A4100000000AB5B2541CDCCCC8C29385A4100000000A95B25416666668629385A4100000000A75B25416666668629385A4100000000A55B25410000008029385A4100000000A35B25419A99997929385A4100000000A15B25419A99997929385A41000000009F5B25419A99997929385A41000000009D5B25419A99997929385A41000000009B5B25413333337329385A4100000000995B25413333337329385A4100000000975B2541CDCCCC6C29385A4100000000955B25416666666629385A4100000000935B25416666666629385A4100000000915B25410000006029385A41000000008F5B25410000006029385A41000000008D5B25419A99995929385A41000000008B5B25413333335329385A4100000000895B25413333335329385A4100000000875B25413333335329385A4100000000855B25413333335329385A4100000000835B2541CDCCCC4C29385A4100000000815B2541CDCCCC4C29385A41000000007F5B25416666664629385A41000000007D5B25410000004029385A41000000007B5B25410000004029385A4100000000795B25419A99993929385A41CDCCCCCC765B25419A99993929385A41CDCCCCCC745B25413333333329385A41CDCCCCCC725B2541CDCCCC2C29385A41CDCCCCCC705B25413333333329385A41CDCCCCCC6E5B2541CDCCCC2C29385A41CDCCCCCC6C5B2541CDCCCC2C29385A41CDCCCCCC6A5B25416666662629385A41CDCCCCCC685B25416666662629385A41CDCCCCCC665B25410000002029385A41CDCCCCCC645B25419A99991929385A41CDCCCCCC625B25419A99991929385A41CDCCCCCC605B25413333331329385A41CDCCCCCC5E5B25413333331329385A41CDCCCCCC5C5B2541CDCCCC0C29385A41CDCCCCCC5A5B25416666660629385A41CDCCCCCC585B2541CDCCCC0C29385A41CDCCCCCC565B25416666660629385A41CDCCCCCC545B25416666660629385A41CDCCCCCC525B25410000000029385A41CDCCCCCC505B25410000000029385A41CDCCCCCC4E5B25419A9999F928385A41CDCCCCCC4C5B2541333333F328385A41CDCCCCCC4A5B2541333333F328385A41CDCCCCCC485B2541CDCCCCEC28385A41CDCCCCCC465B2541CDCCCCEC28385A41CDCCCCCC445B2541666666E628385A41CDCCCCCC425B2541000000E028385A41CDCCCCCC405B2541666666E628385A41CDCCCCCC3E5B2541000000E028385A41CDCCCCCC3C5B2541000000E028385A41CDCCCCCC3A5B25419A9999D928385A41CDCCCCCC385B25419A9999D928385A41CDCCCCCC365B2541333333D328385A41CDCCCCCC345B2541CDCCCCCC28385A41CDCCCCCC325B2541CDCCCCCC28385A41CDCCCCCC305B2541666666C628385A41CDCCCCCC2E5B2541666666C628385A41CDCCCCCC2C5B2541000000C028385A41CDCCCCCC285B2541000000C028385A41CDCCCCCC285B2541000000E029385A41CDCCCCCC285B2541666666A62B385A4133333333225B25413333333335385A41CDCCCCCC215B2541666666C63C385A41CDCCCCCC205B2541333333F34D385A41CDCCCCCC245B2541333333F356385A41CDCCCCCC2C5B2541666666265D385A419A9999992D5B25410000002060385A419A9999991D5B25416666664668385A41CDCCCCCC065B2541CDCCCC6C6E385A4100000000DF5A25416666660677385A419A999999C45A25419A99993979385A4133333333AF5A25416666662681385A419A9999999F5A2541333333F386385A41666666668F5A25413333331395385A41000000008A5A2541333333B397385A419A999999825A25416666662699385A419A999999745A2541666666E69A385A41666666664A5A2541333333339F385A41CDCCCCCC2F5A2541333333B3A3385A4133333333255A25419A999959A7385A419A9999991E5A25419A9999B9AE385A4166666666185A25419A999959B1385A4166666666085A25419A999919B5385A419A999999EE592541CDCCCC6CB8385A4166666666E959254166666626B9385A4100000000E059254100000060BA385A41CDCCCCCCD4592541666666E6BB385A419A999999BF592541000000C0BE385A419A999999A25925419A999979C4385A41CDCCCCCC80592541333333F3CC385A41333333337F592541333333F3CD385A41CDCCCCCC7C59254166666666CF385A41333333337559254133333393D4385A416666666673592541CDCCCC0CD6385A41666666666E592541666666A6D9385A41333333336C59254166666666DB385A419A999999675925419A9999D9DE385A41CDCCCCCC6159254133333353E3385A419A9999995C59254166666606E7385A41CDCCCCCC555925419A999959EA385A419A999999515925419A9999F9EB385A41333333334659254100000040EF385A419A99999938592541333333D3F2385A41CDCCCCCC2C59254133333353F6385A413333333320592541333333B3FB385A416666666619592541CDCCCC2C00395A4100000000195925416666664607395A419A999999125925410000004007395A41CDCCCCCC12592541333333B307395A4100000000135925413333333308395A4166666666FC5825416666664608395A41CDCCCCCCF75825416666664608395A419A999999F2582541CDCCCCAC07395A4166666666EB582541CDCCCCCC06395A4100000000D95825419A99991907395A4166666666D5582541CDCCCC0C06395A41333333334C5825413333339309395A413333333349582541333333B308395A4133333333405825413333339308395A419A999999375825419A9999F907395A4166666666E35725416666666606395A416666666666572541333333F303395A419A99999957572541666666A603395A41CDCCCCCCD65625419A99997900395A419A999999CB5625419A99993900395A4100000000CE562541333333B302395A41CDCCCCCCAE5625419A99993915395A41333333333E5625416666668659395A41CDCCCCCC19562541CDCCCC8C76395A41000000000E562541CDCCCC8C97395A41666666662056254166666646AC395A41CDCCCCCCF6552541CDCCCC0CB9395A41CDCCCCCCF5552541CDCCCC4CB9395A4100000000E4552541333333D3BD395A419A999999775525419A999939D4395A4166666666185525419A999939E0395A4100000000D3542541333333F3E7395A4100000000365425419A9999790A3A5A4100000000A65325419A9999192A3A5A41CDCCCCCC9B532541666666862B3A5A419A99999995532541333333132C3A5A41666666668D532541CDCCCCCC2C3A5A41000000006953254133333313303A5A41333333336753254100000040303A5A41000000005E53254133333313313A5A419A9999994D532541000000C0323A5A413333333344532541333333B3333A5A4100000000905325419A9999D93A3A5A41CDCCCCCCF353254133333333443A5A41333333335B542541000000204E3A5A419A999999AB542541CDCCCCAC553A5A41CDCCCCCC02552541666666065E3A5A41CDCCCCCC2655254133333333613A5A41CDCCCCCC1A55254166666646613A5A41333333335754254166666666613A5A413333333303542541CDCCCC6C613A5A419A99999999522541666666A6613A5A4100000000395225419A9999B9663A5A410000000025522541000000C0673A5A41333333330A52254133333333693A5A41CDCCCCCCEE5125419A9999B96A3A5A419A999999D25125419A9999396C3A5A4100000000B0512541000000006E3A5A41000000007D512541000000A0703A5A419A9999993851254100000040743A5A41CDCCCCCC0C51254133333393763A5A41CDCCCCCCFD5025419A999999773A5A4133333333C5502541666666867B3A5A41	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	01010000206A080000A6124A15A86B25419A9999F9213A5A41	770080000	Z	Armentières-en-Brie	7700800	77008	77	11	7
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	01060000206A080000010000000103000000010000005E000000CDCCCCCC18462441666666263BE5594166666666D64724410000006048E5594100000000CB472441CDCCCCAC66E5594100000000C54724419A9999F966E5594100000000C8472441333333F398E559419A9999996D4A2441333333D382E55941CDCCCCCC7D4C2441CDCCCC0C72E55941666666661A5024410000002054E55941000000004E5024419A9999395AE5594100000000CE5024410000002066E55941CDCCCCCC485124413333339372E55941CDCCCCCC88512441333333337BE559419A9999999B5224419A9999D976E55941000000008F5624419A99995967E55941CDCCCCCC95562441CDCCCC6C54E559419A999999A3572441000000C054E5594133333333B9572441CDCCCC0C69E55941CDCCCCCCA75824419A99997965E559419A999999FA5824419A9999B963E5594133333333F9582441333333F361E5594100000000345A24410000008052E559419A9999998E5B2441000000206DE5594166666666F65B24413333335367E5594100000000F75D24416666662648E559419A999999715F24416666666631E559419A999999E25F2441000000002CE559419A999999A4632441333333D301E55941CDCCCCCC6B6424419A999939F7E45941CDCCCCCCCA64244100000020F1E45941CDCCCCCC1C66244100000000DAE459419A9999995866244133333393B5E4594133333333C26624413333339377E4594166666666DB6624413333333377E45941000000002E6724413333331343E45941000000001A672441CDCCCC8C43E45941333333334B6724416666660623E45941333333334F6724419A9999991CE45941CDCCCCCC4C6824419A9999B924E459419A999999236824419A99999904E459410000000009682441CDCCCC8CF2E35941666666661B68244133333353EAE3594100000000A9682441333333B3C6E35941CDCCCCCC33692441CDCCCC4CA2E3594166666666006A24416666664671E35941CDCCCCCC156A24410000002071E35941CDCCCCCC4F6A2441000000A064E35941CDCCCCCCF36A24419A99995969E359419A999999466B2441CDCCCC4C34E3594166666666406B24413333337333E3594166666666246C24419A9999D9E7E259419A999999A06D244133333313E3E25941CDCCCCCCF06D2441666666A6DFE2594133333333546F2441CDCCCC2CCDE2594166666666D771244166666626AFE2594166666666DE71244166666626ACE25941CDCCCCCCC4712441CDCCCC0C81E2594166666666236E24419A9999F966E259419A9999991A6A2441333333334AE2594133333333216A24419A9999D947E2594166666666F76624416666662636E259419A999999C26324410000008027E259416666666664612441000000C021E259419A999999235F24416666666624E259419A999999635E24410000002028E25941666666662F5C24419A9999B937E25941333333330E5C24419A9999D938E2594133333333F25B2441666666E645E2594133333333195A24419A9999F941E2594100000000265A24416666662651E2594166666666775724413333331361E25941CDCCCCCCCA5424413333333371E259419A999999055424416666662676E2594100000000B4532441000000A077E259419A99999927522441CDCCCCAC7AE2594166666666F34F2441333333737FE2594133333333E54F2441333333337FE25941333333339C4F2441CDCCCCAC9CE2594100000000584F2441333333B3B3E259419A999999184F2441CDCCCC2CC7E25941CDCCCCCC8B4E24419A999939E7E259419A999999274E24419A99997904E35941CDCCCCCCDC4D2441CDCCCCEC20E35941666666669A4D2441333333D335E3594166666666264D24416666666661E35941333333335E4E2441CDCCCCCC66E3594166666666824D24413333333358E459410000000005502441666666A689E459419A999999454C2441333333D3A8E4594100000000BD4C2441CDCCCC2CC8E4594100000000B54924419A999919ECE4594133333333A149244133333313ECE459419A999999954624419A999999DEE45941CDCCCCCC18462441666666263BE55941CDCCCCCC18462441666666263BE55941	01010000206A0800002D1253A0145B2441CCCCCC2CE2E35941	770090000	Z	Arville	7700900	77009	77	11	11
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	01010000206A0800004A2065C1672A25419A9999293A135A41	770100000	Z	Aubepierre-Ozouer-le-Repos	7701000	77010	77	11	27
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	01010000206A08000010968A5952742441333333A31FE65941	770110000	Z	Aufferville	7701100	77011	77	11	18
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	01010000206A08000070DF329D8F2826419A9999B973185A41	770120000	Z	Augers-en-Brie	7701200	77012	77	11	13
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	01010000206A08000073985686DC912541000000702B2C5A41	770130000	Z	Aulnoy	7701300	77013	77	11	14
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	01060000206A080000010000000103000000010000001B00000033333333F7BD2441CDCCCC6C56FD59416666666646BE24419A99995958FD5941CDCCCCCCBFBE2441000000C05FFD5941CDCCCCCCF1BE2441CDCCCC6C61FD594100000000E1BE2441000000406CFD59410000000053BF2441333333138BFD59419A999999AEBF2441333333D39CFD59410000000086C0244100000020C1FD5941CDCCCCCCCAC02441CDCCCC8CCBFD594100000000A0C1244133333393F0FD5941666666660AC224419A9999D901FE59419A999999B1C224413333337320FE59410000000060C32441666666661FFE5941CDCCCCCC85C32441CDCCCC4C17FE594100000000A5C324419A99991916FE59410000000093C324410000006010FE59419A99999996C3244100000080FAFD594100000000E6C324419A9999B9D0FD59419A99999912C42441333333F3BDFD59416666666649C424419A999919ABFD59419A99999984C324419A9999799FFD5941CDCCCCCC63C32441000000C09CFD5941000000001ABF2441666666865FFD594100000000FBBE2441666666C65EFD5941333333330ABE24416666660651FD594133333333F7BD2441CDCCCC6C56FD594133333333F7BD2441CDCCCC6C56FD5941	01010000206A080000823448E93AC22441000000E0B8FD5941	770140101	H	Avon Nord	7701401	77014	77	11	0
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	01060000206A080000010000000103000000010000003C0000003333333361B92441333333D3C9FC5941CDCCCCCCD7BA2441666666A6E4FC5941666666662FBB244100000020EAFC5941CDCCCCCC7ABB244166666686EBFC59410000000002BC2441CDCCCC2CEAFC59413333333335BC244133333373EDFC5941CDCCCCCC5ABC2441666666E6ECFC594133333333A2BC244133333373E7FC594166666666E0BD244100000060EBFC5941CDCCCCCCE0BD2441666666E6DCFC59419A9999990ABE24419A999959D7FC59410000000046BE2441CDCCCC4CD4FC5941333333338FBE2441CDCCCC4CDFFC594100000000A1BE2441000000C0E4FC5941000000007FBE244166666626E9FC59416666666678BE2441666666C6F1FC59410000000082BE24419A999979FDFC594100000000B5BE24413333337304FD594100000000D1BE2441666666860AFD594133333333FDBE24419A9999391AFD5941666666660ABF24419A9999D922FD5941666666662EBF2441333333932DFD5941CDCCCCCC48BF24410000004032FD59419A999999D8BF2441CDCCCC6C41FD5941666666660EC024410000004044FD594133333333A6C02441CDCCCCCC4FFD594100000000D4C024419A99997954FD5941CDCCCCCC91C02441333333935AFD59419A9999994BC024416666660665FD5941333333332BC02441CDCCCCAC6EFD5941CDCCCCCC63C32441000000C09CFD59419A99999984C324419A9999799FFD59416666666649C424419A999919ABFD5941CDCCCCCC5EC4244100000080A7FD5941666666669BC42441333333F38EFD594166666666C3C42441CDCCCCCC82FD5941666666666DC52441666666865CFD594133333333ACC524419A9999D94FFD5941333333331DC624419A99993937FD5941CDCCCCCC99C52441CDCCCC8C28FD59413333333379C52441333333F323FD59416666666634C52441CDCCCC4C16FD59419A99999971C42441000000E0F4FC594100000000F9C324419A999939E8FC59419A999999D0C32441CDCCCCACE9FC594100000000CFC22441666666C6FBFC59416666666695C2244100000020FEFC59419A99999948C224419A9999B9F6FC59419A999999C3C1244166666626E7FC59410000000033C1244100000000D5FC59419A9999994AC0244166666626BCFC5941CDCCCCCC5CBF2441CDCCCC2CA2FC59416666666662BE24419A99995986FC59413333333335BE24413333331385FC59419A9999992BBD2441666666E66CFC5941CDCCCCCC9CBC2441333333B361FC5941CDCCCCCCA0BB2441666666464FFC59419A9999998BBB2441333333933FFC59413333333361B92441333333D3C9FC59413333333361B92441333333D3C9FC5941	01010000206A0800009B4A4AB75DC02441CDCCCCCCF5FC5941	770140102	H	Avon Centre	7701401	77014	77	11	1
01060000206A08000001000000010300000001000000C800000000000000CBB62441000000A0F4FC5941CDCCCCCCDAB6244133333353F6FC594166666666EAB6244166666606F8FC5941CDCCCCCC0CB72441CDCCCC6CFBFC59413333333325B72441000000C0FDFC59419A99999945B72441666666C600FD5941000000005CB72441CDCCCC6C03FD59419A99999965B72441666666A604FD59410000000069B72441CDCCCCCC04FD5941CDCCCCCC6EB724413333337305FD5941CDCCCCCC73B724416666664606FD5941000000007DB724410000006007FD5941333333338EB72441CDCCCC8C09FD594133333333AAB72441000000400DFD594100000000C0B72441CDCCCCCC0FFD59419A999999C8B72441000000A010FD5941CDCCCCCCDBB724416666666612FD5941CDCCCCCCF3B724413333337314FD59419A99999906B824419A99993916FD59413333333320B82441CDCCCC6C18FD5941000000002AB824413333335319FD59416666666637B82441333333731AFD5941CDCCCCCC55B824419A9999391CFD59419A99999982B82441666666261FFD594100000000A4B824416666662621FD5941CDCCCCCCC8B82441CDCCCC2C22FD59419A999999F8B824416666666623FD59413333333315B92441CDCCCC0C24FD5941CDCCCCCC19B92441CDCCCC2C24FD59416666666645B924419A99991925FD5941666666666EB92441666666A625FD59419A99999976B92441666666C625FD59413333333379B92441CDCCCCCC25FD59410000000084B92441333333F325FD59416666666688B924410000000026FD594133333333B4B924419A99999926FD594133333333D6B92441CDCCCC2C27FD594133333333DDB924416666664627FD59413333333315BA2441666666A628FD5941666666661DBA24419A9999D928FD5941CDCCCCCC2DBA2441CDCCCCAC29FD5941666666663BBA2441000000602AFD59413333333375BA2441CDCCCC4C2DFD5941000000008BBA2441CDCCCC8C2EFD5941000000009DBA24419A9999992FFD59419A999999B3BA24413333331331FD594100000000DDBA2441333333D333FD5941CDCCCCCCEFBA24419A9999F934FD594100000000F1BA24413333331335FD5941CDCCCCCC00BB24413333333336FD59413333333307BB2441000000A036FD5941666666663BBB2441333333533AFD59419A9999995EBB2441333333F33CFD5941CDCCCCCC83BB2441000000403FFD594100000000ABBB24410000002041FD594100000000ADBB24419A99993941FD594100000000CDBB24419A99991943FD594166666666EBBB24419A9999D944FD59419A9999990CBC2441CDCCCC6C48FD59413333333322BC2441000000C04AFD5941CDCCCCCC3CBC2441333333934DFD59419A9999995FBC24419A9999594DFD59416666666675BC24419A9999594DFD59419A99999978BC24419A9999594DFD5941CDCCCCCC7ABC2441333333734DFD594133333333A6BC2441666666664FFD5941CDCCCCCCC6BC24410000008051FD5941CDCCCCCCECBC24416666664654FD5941666666660ABD2441666666C655FD59419A99999925BD2441CDCCCCAC56FD5941000000003DBD2441666666A656FD5941CDCCCCCC7DBD2441333333B356FD594100000000A7BD24410000000057FD594166666666DDBD2441CDCCCC2C57FD594133333333F7BD2441CDCCCC6C56FD5941333333330ABE24416666660651FD59416666666643BE24410000002054FD59419A9999996EBE24419A9999B956FD594100000000B4BE2441333333B35AFD594133333333C3BE2441000000A05BFD594133333333DABE2441000000005DFD594166666666E5BE2441000000A05DFD594100000000EEBE2441000000205EFD594100000000FBBE2441666666C65EFD59419A9999990CBF24419A9999395FFD5941000000001ABF2441666666865FFD594100000000A8BF2441CDCCCC6C67FD5941333333332BC02441CDCCCCAC6EFD59419A99999933C02441333333936BFD59413333333341C024413333339367FD59419A9999994BC024416666660665FD5941666666665EC024410000002062FD59419A99999971C02441666666465FFD59410000000082C02441666666E65CFD5941CDCCCCCC91C02441333333935AFD594133333333A2C024410000008058FD59419A999999B7C024419A99995956FD5941CDCCCCCCC5C024413333333355FD594100000000D4C024419A99997954FD594100000000C8C02441CDCCCC6C53FD594133333333A6C02441CDCCCCCC4FFD5941CDCCCCCC46C02441CDCCCC6C48FD5941666666660EC024410000004044FD59419A999999D8BF2441CDCCCC6C41FD594133333333A8BF2441333333533CFD5941CDCCCCCC6BBF24410000000036FD59413333333355BF24413333339333FD5941CDCCCCCC48BF24410000004032FD59419A9999993CBF2441333333B330FD5941666666662EBF2441333333932DFD5941666666660ABF24419A9999D922FD59413333333303BF2441000000601EFD594133333333FDBE24419A9999391AFD594100000000F5BE24410000008016FD594166666666EEBE2441CDCCCCEC13FD594100000000E4BE24413333335310FD594100000000D1BE2441666666860AFD594100000000B5BE24413333337304FD5941CDCCCCCC85BE244100000000FEFC59410000000082BE24419A999979FDFC5941CDCCCCCC7DBE24419A999919FBFC59416666666678BE2441666666C6F1FC59413333333379BE24419A9999F9EBFC5941000000007FBE244166666626E9FC5941000000008ABE244100000040E7FC59410000000096BE2441CDCCCC0CE6FC594100000000A1BE2441000000C0E4FC5941666666669EBE2441CDCCCCECE3FC59419A9999999DBE24419A999959E2FC5941CDCCCCCC9DBE2441333333F3E1FC59416666666698BE2441CDCCCCCCE0FC5941333333338FBE2441CDCCCC4CDFFC5941333333335BBE244100000060D7FC5941333333334DBE24419A999979D5FC59410000000046BE2441CDCCCC4CD4FC59416666666642BE244166666606D5FC59419A9999993CBE2441CDCCCC8CD5FC59419A99999933BE24419A9999F9D5FC59416666666628BE2441CDCCCCECD5FC59419A9999990ABE24419A999959D7FC59410000000001BE2441333333B3D8FC5941CDCCCCCCE0BD2441666666E6DCFC59419A999999DFBD244166666606E1FC594166666666E0BD2441CDCCCC0CEAFC594166666666E0BD244100000060EBFC594133333333C3BD2441666666E6EAFC59419A99999981BD24419A999939EAFC5941CDCCCCCC53BD24419A9999D9E9FC5941CDCCCCCC1BBD24419A999919E9FC59416666666617BD2441CDCCCC0CE9FC59419A9999990FBD2441333333F3E8FC594133333333A2BC244133333373E7FC59419A9999999DBC2441CDCCCC8CE7FC5941CDCCCCCC90BC24419A9999D9E7FC59419A9999996CBC24419A999999EBFC5941CDCCCCCC5ABC2441666666E6ECFC59413333333335BC244133333373EDFC59416666666629BC2441CDCCCC2CECFC59416666666614BC2441CDCCCCACEAFC59410000000002BC2441CDCCCC2CEAFC59419A999999E6BB244166666666EAFC594166666666B7BB244133333313EBFC59416666666693BB244166666646EBFC5941CDCCCCCC7ABB244166666686EBFC5941000000005BBB244133333333EBFC5941666666662FBB244100000020EAFC59413333333311BB24419A999979E8FC5941CDCCCCCCD7BA2441666666A6E4FC59419A99999981BA244133333353DEFC59410000000065BA244166666646DCFC59419A999999FFB92441CDCCCC0CD5FC594166666666DAB9244166666666D2FC594100000000A3B9244166666646CEFC5941000000007AB924419A9999B9CBFC5941666666666CB92441333333B3CBFC59419A99999965B92441CDCCCCECCBFC59419A99999961B9244166666646CAFC59413333333361B92441333333D3C9FC59419A99999957B9244133333393CBFC5941CDCCCCCC54B924419A999919CCFC5941CDCCCCCC51B92441CDCCCC4CCCFC59419A99999943B924419A999919CDFC59410000000041B9244100000040CDFC5941333333332DB92441CDCCCC4CCEFC59419A999999C6B82441333333B3D3FC5941000000007CB82441333333D3D7FC5941000000003AB8244100000080DBFC5941CDCCCCCC23B824419A9999B9DCFC5941666666661FB82441333333F3DCFC5941666666661BB8244100000080DDFC59419A99999913B8244100000060DEFC59419A999999DBB724419A999919E5FC59419A999999BBB7244100000020E9FC594166666666B1B7244166666666EAFC5941000000007BB724419A999959EAFC5941666666662DB724419A9999F9E9FC594133333333FAB62441CDCCCCACECFC59419A999999E8B624419A999919EEFC594166666666DCB62441CDCCCC8CEFFC594100000000CBB62441000000A0F4FC5941	01060000206A080000010000000103000000010000003900000000000000CBB62441000000A0F4FC59419A99999945B72441666666C600FD594100000000C0B72441CDCCCCCC0FFD59416666666637B82441333333731AFD594100000000A4B824416666662621FD59416666666645B924419A99991925FD5941666666661DBA24419A9999D928FD59413333333375BA2441CDCCCC4C2DFD5941CDCCCCCCEFBA24419A9999F934FD59419A9999995EBB2441333333F33CFD594166666666EBBB24419A9999D944FD5941CDCCCCCC3CBC2441333333934DFD59419A99999978BC24419A9999594DFD5941CDCCCCCCECBC24416666664654FD59419A99999925BD2441CDCCCCAC56FD594166666666DDBD2441CDCCCC2C57FD594133333333F7BD2441CDCCCC6C56FD5941333333330ABE24416666660651FD594100000000FBBE2441666666C65EFD5941000000001ABF2441666666865FFD5941333333332BC02441CDCCCCAC6EFD59419A9999994BC024416666660665FD5941CDCCCCCC91C02441333333935AFD594100000000D4C024419A99997954FD594133333333A6C02441CDCCCCCC4FFD5941666666660EC024410000004044FD59419A999999D8BF2441CDCCCC6C41FD5941CDCCCCCC48BF24410000004032FD5941666666662EBF2441333333932DFD5941666666660ABF24419A9999D922FD594133333333FDBE24419A9999391AFD594100000000D1BE2441666666860AFD594100000000B5BE24413333337304FD59410000000082BE24419A999979FDFC59416666666678BE2441666666C6F1FC5941000000007FBE244166666626E9FC594100000000A1BE2441000000C0E4FC5941333333338FBE2441CDCCCC4CDFFC59410000000046BE2441CDCCCC4CD4FC59419A9999990ABE24419A999959D7FC5941CDCCCCCCE0BD2441666666E6DCFC594166666666E0BD244100000060EBFC594133333333A2BC244133333373E7FC5941CDCCCCCC5ABC2441666666E6ECFC59413333333335BC244133333373EDFC59410000000002BC2441CDCCCC2CEAFC5941CDCCCCCC7ABB244166666686EBFC5941666666662FBB244100000020EAFC5941CDCCCCCCD7BA2441666666A6E4FC5941000000007AB924419A9999B9CBFC5941CDCCCCCC54B924419A999919CCFC5941666666661FB82441333333F3DCFC594166666666B1B7244166666666EAFC5941666666662DB724419A9999F9E9FC594166666666DCB62441CDCCCC8CEFFC594100000000CBB62441000000A0F4FC594100000000CBB62441000000A0F4FC5941	01010000206A080000302493F4B3BB2441CDCCCC4C1DFD5941	770140103	H	Avon Ouest	7701401	77014	77	11	0
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	01010000206A08000047F4E0734BC82441CDCCCC7C41FD5941	770140104	H	Avon Est	7701401	77014	77	11	1
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	01060000206A08000001000000010300000001000000370000006666666641B924413333333306FC594133333333C8BA24419A99993923FC59419A999999BFBA2441000000202EFC59410000000082BB2441000000C03AFC5941CDCCCCCCA0BB2441666666464FFC5941CDCCCCCC9CBC2441333333B361FC59419A9999992BBD2441666666E66CFC59413333333335BE24413333331385FC59416666666662BE24419A99995986FC5941CDCCCCCC5CBF2441CDCCCC2CA2FC59419A9999994AC0244166666626BCFC59410000000033C1244100000000D5FC59419A999999C3C1244166666626E7FC59419A99999948C224419A9999B9F6FC59416666666695C2244100000020FEFC594100000000CFC22441666666C6FBFC59419A999999D0C32441CDCCCCACE9FC5941CDCCCCCCDEC32441CDCCCC8CE5FC59416666666689C3244133333373DCFC5941000000005AC32441CDCCCC6CD3FC59413333333346C3244133333333C9FC5941666666663FC32441CDCCCCCCBBFC59410000000031C3244166666626B6FC594100000000F9C224419A9999D9ACFC594133333333A2C2244133333393A2FC5941CDCCCCCCF0C12441CDCCCC8C7EFC594166666666E3C124419A99995971FC59419A999999D9C12441666666E655FC5941CDCCCCCC42C12441000000A05FFC59419A999999B2BF2441666666A624FC5941000000007FBF2441000000801DFC594100000000C9BF24419A99991905FC59419A99999921C0244100000020EBFB5941000000002CC02441666666A6E6FB59416666666613C02441333333F3E4FB5941CDCCCCCC4BC0244100000080D9FB59419A999999BFC024419A999939C4FB5941000000005EC0244100000060BBFB5941666666661AC024419A999999C3FB5941CDCCCCCC9ABE244133333313A6FB594100000000BFBE2441CDCCCCAC9DFB594100000000E1BC24419A9999397EFB594100000000CEBC2441333333537DFB59419A99999980BD24419A99993956FB5941CDCCCCCC55BC2441333333735BFB59410000000040BB24419A9999F980FB59410000000068BA24413333331379FB59410000000034BA24416666660695FB59419A99999954BA2441000000E094FB5941CDCCCCCC25BA2441333333D3A9FB59419A99999994B92441CDCCCCACEDFB5941CDCCCCCC6FB924419A999999F4FB5941666666667BB9244100000000F6FB59416666666641B924413333333306FC59416666666641B924413333333306FC5941	01010000206A0800003A3E7AD947BD2441CDCCCC8C28FC5941	770140105	H	Avon Sud	7701401	77014	77	11	1
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	01010000206A0800002CE6CBE2C42426419A9999E9ADFA5941	770150000	Z	Baby	7701500	77015	77	11	4
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	01060000206A08000001000000010300000001000000B6000000000000004CA52441CDCCCC0C3BE85941000000005EA52441333333B342E85941CDCCCCCC72A524416666666677E85941000000008AA52441333333B38AE85941000000001BA6244133333393CBE859413333333338A62441CDCCCCCCD4E859410000000092A6244133333353E7E859416666666620A72441CDCCCC6C11E959419A99999948A72441333333F319E95941CDCCCCCCBAA72441333333D32DE95941CDCCCCCCDFA72441666666C637E959416666666630A82441333333B344E959416666666667A824410000008048E95941CDCCCCCCFCA82441333333934FE959410000000041A92441CDCCCCCC54E95941666666668DA92441666666A65EE9594133333333C9A92441333333F36AE959419A999999EDA924413333339376E9594133333333F4A92441666666A68AE95941000000000CAA2441666666C699E95941333333332EAA244133333313A3E95941CDCCCCCCDFAA244133333353CBE959419A99999918AB2441CDCCCC8CD6E95941CDCCCCCCF7AB2441333333F3F8E95941CDCCCCCC6EAC24419A9999D90BEA59419A999999A7AC24416666660617EA59419A9999991CAD2441CDCCCC6C27EA59410000000061AD24419A9999792DEA5941CDCCCCCCADAD2441666666A630EA594100000000A8AE2441CDCCCC2C39EA5941CDCCCCCCC9AF24419A9999B93FEA5941CDCCCCCCCDAF2441333333533EEA59413333333339B02441333333B342EA59413333333390B024416666666648EA5941000000009CB024410000006045EA59416666666608B224410000004053EA59416666666601B224416666664656EA5941000000002DB32441CDCCCCAC64EA5941000000005AB324413333339356EA59416666666681B32441333333B345EA59410000000016B52441666666467DE959413333333356B52441000000E05CE95941333333335FB52441666666A654E95941CDCCCCCC9CB524419A9999B9E6E859419A999999AAB5244100000080C8E8594100000000D7B524419A99997981E859416666666624B62441333333333AE85941CDCCCCCC40B62441000000E022E8594100000000EBB62441333333738DE759419A99999911B72441333333536EE759419A99999977B72441CDCCCC0C70E759419A999999EAB72441CDCCCC4C73E75941666666669FB82441CDCCCC2C7BE759413333333370B92441CDCCCC2C7CE759419A999999B6B92441CDCCCC8C81E7594100000000F2B92441333333D387E759419A9999992DBA24419A9999F98FE75941CDCCCCCCFBBA2441CDCCCCAC93E75941CDCCCCCC60BB24410000004097E7594100000000EBBB2441666666269DE75941000000006ABC244166666646A0E759419A999999CABC2441666666A6A3E7594166666666D5BD244100000060ABE75941333333334FBE244166666626B5E759419A99999969BE244133333333B1E75941000000003DBF24419A9999D9A7E75941CDCCCCCC0AC024419A99997973E759419A99999937C024419A99995975E75941666666668DC124413333339319E7594166666666C8C12441CDCCCCEC1CE759416666666696C224419A999999DFE659419A9999998AC224419A999959D9E65941000000005BC2244166666626D5E659419A999999BFC12441CDCCCC2CCDE65941666666665CC0244100000060BEE659416666666663C02441000000E0BBE65941CDCCCCCC22C02441CDCCCCCCB8E659410000000012BF244166666606AAE6594133333333A6BE244166666686A3E65941000000007DBE2441CDCCCC2C9FE659416666666661BD2441CDCCCCEC89E659413333333344BD24419A99997988E65941666666664CBC24410000004084E65941CDCCCCCCBCBB24410000006083E6594133333333CDBB24419A9999D968E6594133333333DEBB2441333333F367E65941CDCCCCCC06BC2441666666A653E6594133333333F3BB2441333333B352E6594166666666FCBB2441333333534CE6594166666666E7BB2441666666E64BE6594166666666FBBB24419A99995940E6594166666666C4BB2441666666C63EE65941CDCCCCCCCCBB2441333333B334E6594133333333E2BB2441CDCCCC0C28E6594166666666B1BB2441CDCCCC6C23E659419A9999999FBB2441CDCCCC4C0CE65941CDCCCCCC9DBB2441333333D300E659410000000093BB244100000040F8E55941666666661EBB2441666666C6E1E5594100000000DBBA24419A9999B9D2E55941000000009DBA2441CDCCCC6CCDE55941CDCCCCCC97B82441666666C68EE55941CDCCCCCCA1B82441333333D397E55941333333339AB82441666666669BE559419A9999999CB82441000000E0BEE5594100000000B1B824419A9999D9C5E5594133333333F5B8244166666646C8E559419A99999909B92441000000C0CFE5594100000000F2B8244166666646D5E5594133333333FBB82441000000C0E5E559413333333324B92441333333B3F4E559419A99999964B92441CDCCCC0CFBE559419A9999997FB92441000000A002E659419A9999998DB92441333333930BE6594166666666B2B924416666660617E659419A999999BFB92441000000802AE659419A999999A0B924416666660639E659410000000079B92441333333133DE659416666666665B924413333339343E659419A9999993FB924419A99991964E659413333333340B924419A9999996BE65941333333330AB924410000002089E6594166666666FFB82441000000A09AE6594133333333ECB8244166666626A6E6594133333333C5B82441CDCCCCACB5E659416666666682B824419A9999B9C7E659410000000008B824419A9999D9DDE65941CDCCCCCCB9B72441CDCCCC6CF8E6594166666666A2B724413333335308E759413333333350B724410000008019E759416666666610B72441333333131CE7594166666666A1B62441CDCCCCAC2AE759410000000056B62441000000C031E7594100000000A7B52441CDCCCC6C3DE759419A99999913B524413333339345E7594133333333C8B42441666666A64DE7594166666666B4B42441CDCCCCAC52E75941000000009AB42441CDCCCCAC68E7594133333333AFB42441666666A67AE759419A999999ECB424413333331390E7594100000000EDB424413333331395E75941333333332AB5244100000080A7E759413333333364B524419A9999B9B2E759413333333369B524419A999939BCE759419A99999934B5244166666666CCE759416666666629B52441333333F3D6E75941000000002AB5244133333373E0E75941333333331BB5244133333373F1E759410000000008B524419A9999F9FCE75941CDCCCCCCF5B424419A99997917E8594133333333F6B424416666660620E859419A99999971B42441666666461BE85941CDCCCCCCDEB32441CDCCCC6C18E8594100000000E6B324419A99993914E85941CDCCCCCCA4B324410000006014E85941CDCCCCCC6CB32441CDCCCC8C0DE859416666666652B324413333331304E859419A99999900B324419A999959F6E75941CDCCCCCCE7B2244100000080F3E75941CDCCCCCCB9B22441666666A6E8E75941666666667CB22441666666A6CFE759413333333349B2244133333333C6E75941CDCCCCCCEAB124419A999959CEE759416666666648B1244166666646D3E75941CDCCCCCCEAB0244100000080D8E759419A9999997BB02441666666A6E1E759419A99999965B02441CDCCCC2CE6E759419A999999B8AF244100000060F0E759416666666663AE2441000000E0EAE75941333333336CAD2441000000E0E5E75941CDCCCCCC1EAD2441CDCCCC6C56E859413333333357AC2441000000C052E859416666666672AB2441333333334DE85941CDCCCCCC7EAB2441666666E642E859410000000012AB2441CDCCCCAC40E85941CDCCCCCCA3AA24419A99999940E85941CDCCCCCCA0A924410000002043E8594166666666FAA724419A9999F943E859419A99999956A724416666668642E8594166666666A2A62441CDCCCCAC3EE85941000000004CA52441CDCCCC0C3BE85941000000004CA52441CDCCCC0C3BE85941	01010000206A0800001F28A4D538B0244134333343F9E75941	770160000	Z	Bagneaux-sur-Loing	7701600	77016	77	11	5
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	01060000206A08000001000000010300000001000000A30000009A999999E2E624419A9999598F2B5A41666666662AE7244133333373902B5A413333333391E72441000000A0902B5A416666666683E724419A9999199A2B5A4133333333E6E72441CDCCCCEC9D2B5A416666666651E824419A9999B9A42B5A419A999999BFE82441CDCCCCCCAD2B5A419A999999B7E8244166666646BB2B5A410000000082E824419A9999B9322C5A41CDCCCCCC68E82441666666265F2C5A41666666664CE82441666666A6D82C5A41CDCCCCCC47E8244166666686E22C5A4100000000BEE82441333333B3E62C5A41CDCCCCCCDDE824419A9999F9EA2C5A410000000037E9244166666686FC2C5A41CDCCCCCC57E92441CDCCCC6CFD2C5A419A99999952EB2441666666E60F2D5A41CDCCCCCC88EB2441666666A6FA2C5A410000000015EB244100000040F62C5A416666666638EB244166666606E42C5A4100000000ABEB24419A999979F32C5A410000000012EC2441CDCCCC0C032D5A410000000077EC2441333333F3132D5A4100000000F0EC2441333333932A2D5A41CDCCCCCC8CEE2441000000200E2D5A419A9999994FEE24419A9999390A2D5A419A99999925EE244133333333FA2C5A416666666606EE244100000040E52C5A413333333306EE2441666666C6C32C5A419A9999992FEE2441CDCCCC0CC12C5A4133333333F7EE24419A999979CD2C5A410000000001F02441000000C0D82C5A416666666644F1244100000000E22C5A4100000000C6F2244100000080EF2C5A41CDCCCCCC26F4244166666626F82C5A419A99999995F4244100000080FB2C5A4133333333AAF52441666666E60D2D5A4133333333C0F5244100000060112D5A416666666671F6244166666686322D5A410000000078F6244166666606352D5A41CDCCCCCC97F6244100000000532D5A4166666666AFF6244166666626652D5A419A999999A4F724419A9999195D2D5A4133333333B9F724419A9999995E2D5A4100000000BDF92441666666264C2D5A4100000000D0F92441CDCCCCEC482D5A416666666684FA24419A9999B9422D5A410000000088FA2441666666A6442D5A410000000040FB2441000000E03D2D5A410000000072FB2441666666A6512D5A419A99999936FB2441333333B3552D5A41CDCCCCCCFEFA2441666666A65B2D5A419A999999CDFA24419A999939632D5A410000000097FA2441CDCCCC0C692D5A4166666666ADFA2441000000A06B2D5A41CDCCCCCC66FC24419A9999B9592D5A41333333339FFC2441000000005E2D5A41CDCCCCCC52FD24419A999979572D5A41CDCCCCCCE3FD244166666666542D5A410000000022FE244166666606652D5A416666666691FE2441333333F37F2D5A41000000001200254166666686852D5A4100000000B90025419A9999D9852D5A41666666660D01254166666626852D5A419A999999DB022541CDCCCC6C7E2D5A41666666664003254133333353732D5A419A9999996802254100000060472D5A41CDCCCCCC68012541CDCCCCAC112D5A4133333333B60025419A999939F12C5A410000000001FF244100000000B32C5A4100000000D1FE2441000000809F2C5A416666666675FE244133333313732C5A41CDCCCCCCBAFD2441000000A04B2C5A419A9999991FFD24419A999959432C5A41CDCCCCCC5FFC2441666666863B2C5A41666666669AFC2441000000003A2C5A41333333330FFD24419A9999B9382C5A413333333399FD2441CDCCCCCC382C5A4166666666A6FC2441CDCCCCCC0F2C5A419A999999FFFB24419A999959F62B5A419A99999966FB2441333333F3DF2B5A413333333398FA2441333333D3C32B5A4166666666BCF9244166666646A72B5A419A99999923F9244100000020952B5A41CDCCCCCC5DF82441CDCCCCEC7E2B5A413333333397F72441000000E0692B5A413333333399F7244133333373652B5A41000000003BF9244100000080602B5A41CDCCCCCCD4FC2441333333D3552B5A41666666660E00254133333373742B5A419A99999999002541CDCCCC0C7A2B5A419A999999490025419A9999794D2B5A41000000006A002541666666E6352B5A419A9999996F002541000000C02D2B5A4133333333B50025419A9999190B2B5A41000000000B012541000000C0EC2A5A41000000000E01254100000080D72A5A419A9999996501254133333393BD2A5A4166666666B401254100000000B22A5A4166666666A00125419A999919A82A5A419A99999998012541000000A09E2A5A4100000000A10125419A9999D9842A5A4166666666AE012541000000A0812A5A416666666677012541666666C6672A5A4166666666B70025419A9999196F2A5A41CDCCCCCC89FF24419A999979292A5A41CDCCCCCC77FF2441CDCCCC6C272A5A4133333333DDFE244100000080272A5A4166666666E2FD2441000000E0282A5A413333333326FD2441CDCCCC4C272A5A4133333333B8FC2441000000E0272A5A419A99999969FB244133333393282A5A413333333320FB2441666666E6252A5A410000000006FB2441CDCCCC4C2D2A5A419A99999990FA2441000000603D2A5A410000000009FA2441CDCCCC0C522A5A4133333333EAF92441000000405A2A5A4166666666D8F92441000000A0592A5A41CDCCCCCCF3F724419A9999993A2A5A416666666630F8244100000040252A5A419A99999993F524419A999979012A5A41CDCCCCCC61F52441666666E60A2A5A410000000005F524419A9999791E2A5A419A999999A7F42441CDCCCC8C392A5A416666666653F42441333333734D2A5A419A999999EAF3244166666606642A5A41CDCCCCCCA7F32441333333F3732A5A413333333386F3244166666646782A5A413333333370F22441000000008C2A5A419A99999930F2244166666626932A5A4133333333CDF124419A999939822A5A4100000000E0F124419A999979792A5A41666666668BF12441CDCCCC6C6F2A5A4166666666A6F02441333333B3462A5A4133333333A3EF2441333333B3262A5A419A9999993CEF2441666666A6262A5A410000000036EF2441333333B3282A5A41CDCCCCCC13EE2441CDCCCC8C232A5A413333333341ED24419A9999991E2A5A4133333333E3EB24419A999999102A5A41CDCCCCCC60EB2441000000C01E2A5A41000000005EEB2441CDCCCC2C232A5A419A99999926EB244133333353322A5A41CDCCCCCCE6EA244100000040482A5A41CDCCCCCCD2EA244166666646512A5A4100000000C3EA2441333333335E2A5A410000000073EA2441CDCCCC6C7A2A5A413333333360EA2441CDCCCC0C862A5A413333333347EA2441000000A08B2A5A4133333333F5E92441000000C0952A5A413333333371E92441000000C0A32A5A41CDCCCCCCB6E8244133333373B32A5A41333333334DE824419A999999CB2A5A41CDCCCCCC1BE824419A999979DC2A5A41333333331CE82441CDCCCCECDE2A5A413333333380E8244133333313FE2A5A419A99999998E8244166666606072B5A41666666669EE82441333333F3152B5A41CDCCCCCC8AE82441333333132B2B5A41333333337AE82441333333F3362B5A413333333310E72441333333F3852B5A419A999999E2E624419A9999598F2B5A419A999999E2E624419A9999598F2B5A41	01010000206A0800007916A6F7A4F1244166666696C32B5A41	770180000	Z	Bailly-Romainvilliers	7701800	77018	77	11	9
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	01010000206A0800008CFAA2568FB42541000000F0EBFA5941	770190000	Z	Balloy	7701900	77019	77	11	13
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	01010000206A080000D9ACC355CACB25410000008071195A41	770200000	Z	Bannost-Villegagnon	7702000	77020	77	11	19
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	01010000206A0800000AA9907AFA782541000000A0B3F75941	770210000	Z	Barbey	7702100	77021	77	11	4
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	01010000206A080000D666A3E82C772441666666D6A8005A41	770220000	Z	Barbizon	7702200	77022	77	11	5
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	01010000206A080000F841132E98182541CDCCCC6C4D3E5A41	770230000	Z	Barcy	7702300	77023	77	11	7
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	01010000206A0800001835FCED94FE2541333333B36A345A41	770240000	Z	Bassevelle	7702400	77024	77	11	18
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	01010000206A0800002CB552BB6CCC2541CCCCCCAC36FB5941	770250000	Z	Bazoches-lès-Bray	7702500	77025	77	11	23
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	01010000206A08000009A8FC0F1D4A2641CCCCCC5C48115A41	770260000	Z	Beauchery-Saint-Martin	7702600	77026	77	11	28
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	01010000206A080000820AA850D3382441666666C6BCDF5941	770270000	Z	Beaumont-du-Gâtinais	7702700	77027	77	11	17
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	01010000206A080000F2188FD1E50F2541000000F0DA155A41	770290000	Z	Beauvoir	7702900	77029	77	11	4
01060000206A08000001000000010300000001000000A00400003333333347022641CDCCCC4CFB2A5A41CDCCCCCC4A02264100000040FC2A5A419A99999963022641CDCCCCCC012B5A41000000007302264100000040052B5A413333333394022641333333B30C2B5A4133333333B4022641000000C0132B5A41CDCCCCCCBD022641666666E6152B5A419A999999D3022641333333B31A2B5A419A999999FC022641666666C6232B5A4100000000FF0226419A999959242B5A41000000001A032641CDCCCC4C2A2B5A41CDCCCCCC3B032641666666C6312B5A413333333356032641666666E6372B5A4100000000730326419A9999393E2B5A413333333377032641666666263E2B5A41000000007B032641CDCCCCAC3F2B5A41666666668C032641333333F3462B5A4166666666950326419A9999994A2B5A41CDCCCCCC9B032641CDCCCCEC4C2B5A41CDCCCCCCB3032641CDCCCC8C542B5A4166666666C8032641333333335B2B5A4100000000DD03264133333373612B5A4100000000E80326419A999919652B5A413333333302042641333333936D2B5A41333333331B042641333333D3742B5A4133333333350426419A999939792B5A410000000064042641000000C0832B5A41CDCCCCCCAC0426419A999919942B5A4133333333B7042641000000A0972B5A4133333333C8042641CDCCCCAC9B2B5A41CDCCCCCCFF042641333333F3A42B5A41000000000605264133333353A62B5A41333333331A0526419A999919AC2B5A41333333332D05264133333353B32B5A41000000005905264100000080C22B5A416666666686052641666666C6CE2B5A419A999999A0052641CDCCCCACD52B5A41CDCCCCCCBB052641CDCCCC2CDB2B5A41333333330706264133333353E82B5A41333333332206264133333373ED2B5A41666666663D062641CDCCCCCCF32B5A419A99999957062641CDCCCC8CFB2B5A41000000006A062641CDCCCCEC002C5A413333333397062641666666E60C2C5A41CDCCCCCCB60626419A9999B9162C5A41CDCCCCCCCC062641333333D3222C5A419A999999D606264100000080282C5A41CDCCCCCCE6062641333333732D2C5A4166666666FB06264100000020352C5A41CDCCCCCC01072641CDCCCCAC372C5A416666666610072641CDCCCC4C3E2C5A413333333318072641333333F33F2C5A41666666661B0726419A999999402C5A419A9999991D0726419A999919412C5A419A99999921072641666666E6412C5A41000000002E0726419A9999B9432C5A41666666666E072641CDCCCCCC522C5A41CDCCCCCC8B072641CDCCCC4C5B2C5A413333333394072641666666465E2C5A410000000098072641666666465F2C5A4166666666DF07264133333353712C5A410000000020082641CDCCCCCC7F2C5A41CDCCCCCC500826419A9999398A2C5A41CDCCCCCC150826419A9999398F2C5A419A999999D2072641CDCCCC8C942C5A419A99999972072641333333139C2C5A419A99999987072641CDCCCC2CA12C5A4100000000B3072641333333F3AC2C5A4100000000D3072641CDCCCC0CB62C5A419A999999EA0726419A999919BD2C5A416666666602082641CDCCCCECC22C5A419A99999928082641666666C6C92C5A41666666663908264166666686CD2C5A41333333334D08264133333333D32C5A41CDCCCCCC5608264133333353D62C5A41666666666508264133333353DC2C5A419A99999971082641666666C6E22C5A41CDCCCCCC7608264100000060E42C5A41CDCCCCCC770826419A9999B9E42C5A419A999999850826419A999939E92C5A419A99999993082641000000A0EC2C5A41CDCCCCCCC008264100000080F82C5A4133333333C508264100000080F92C5A4133333333C9082641CDCCCC4CFA2C5A4133333333D1082641000000E0FB2C5A41CDCCCCCCDB0826419A999979FD2C5A419A999999F7082641666666E6FF2C5A4166666666FD082641666666C6002D5A41666666660B0926419A999999012D5A41CDCCCCCC1309264133333313032D5A41333333331D092641CDCCCCAC042D5A41333333331E092641CDCCCCCC042D5A41000000002209264166666646052D5A41CDCCCCCC2609264133333373062D5A419A99999928092641CDCCCCAC072D5A419A99999930092641000000200B2D5A41CDCCCCCC320926419A9999D90B2D5A419A999999330926419A9999190C2D5A413333333338092641CDCCCC0C0C2D5A41666666664F092641333333930B2D5A41CDCCCCCC52092641666666860B2D5A416666666654092641333333130D2D5A41CDCCCCCC54092641666666260E2D5A41CDCCCCCC5509264100000000102D5A410000000056092641CDCCCC0C102D5A41333333335609264133333313112D5A416666666658092641666666E6112D5A41000000005D092641CDCCCC2C132D5A419A99999960092641666666C6132D5A413333333364092641CDCCCC0C142D5A41000000006B09264133333373142D5A413333333370092641000000C0152D5A41000000007109264100000000162D5A413333333376092641CDCCCC8C172D5A41333333337A09264100000060192D5A416666666677092641333333731B2D5A4133333333790926419A9999391C2D5A41CDCCCCCC7F0926419A9999591D2D5A416666666685092641666666E61D2D5A41CDCCCCCC880926419A9999391E2D5A41333333338B092641333333731E2D5A41333333338E0926419A9999F91E2D5A41000000008F0926419A9999591F2D5A41333333338E092641666666C61F2D5A419A9999998A09264100000060202D5A41CDCCCCCC87092641333333F3202D5A41000000008509264166666686212D5A410000000089092641000000A0212D5A41000000008C092641333333B3212D5A41666666668D092641CDCCCCCC212D5A419A9999998E092641000000E0212D5A419A9999998F09264133333313222D5A4100000000910926419A999939222D5A416666666696092641CDCCCC8C222D5A413333333398092641000000C0222D5A41333333339A09264166666626232D5A419A9999999A0926419A9999B9232D5A419A99999998092641CDCCCC6C242D5A41CDCCCCCC97092641333333B3242D5A419A9999999609264166666626252D5A41CDCCCCCC9409264166666686262D5A41333333339709264133333313272D5A41666666669C09264166666686272D5A41CDCCCCCCA50926419A999959282D5A41CDCCCCCCA6092641333333D3282D5A4133333333A6092641666666E6292D5A41CDCCCCCCA9092641333333932A2D5A4133333333B0092641CDCCCC2C2B2D5A419A999999B5092641CDCCCC4C2C2D5A4100000000B6092641000000002D2D5A4133333333BF092641000000002F2D5A4100000000D0092641CDCCCCAC322D5A4166666666E20926419A9999B9362D5A41CDCCCCCCE6092641CDCCCCCC372D5A41CDCCCCCCFC0926419A9999393D2D5A4100000000400A2641000000E04B2D5A419A999999870A2641CDCCCCEC5B2D5A419A999999A00A26419A999999612D5A4133333333AE0A264133333393642D5A41CDCCCCCCAE0A26419A9999B9642D5A4100000000B10A264100000000652D5A4166666666BB0A264166666666662D5A4166666666BF0A2641333333B3662D5A4133333333D00A26419A999919682D5A419A999999DB0A26419A999939692D5A4100000000E80A2641333333536A2D5A4100000000F10A2641333333336B2D5A419A999999FF0A264100000060692D5A4133333333390B2641000000E06D2D5A419A999999740B2641666666C6762D5A419A999999A30B2641CDCCCC0C732D5A41CDCCCCCCA70B2641333333B3732D5A4100000000AE0B2641000000E0732D5A4100000000B60B264166666646742D5A4100000000BD0B26419A999999742D5A4100000000D90B2641000000C0752D5A41CDCCCCCC0E0C2641333333B3772D5A419A9999993D0C26419A9999997A2D5A41CDCCCCCC3B0C2641666666C67A2D5A4166666666320C2641666666C67B2D5A41CDCCCCCC300C2641333333F37B2D5A4100000000560C264100000020822D5A41CDCCCCCC480C2641CDCCCCEC832D5A4133333333400C2641CDCCCCCC842D5A419A999999520C26419A9999F9892D5A4100000000700C2641CDCCCCCC912D5A4166666666B20C264100000060A42D5A4166666666B50C2641CDCCCC4CA52D5A4133333333BC0C264100000040A72D5A419A999999BC0C26419A999959A72D5A4100000000CE0C264166666626AC2D5A41CDCCCCCCCE0C264133333353AC2D5A4166666666D00C2641CDCCCCCCAC2D5A4100000000D20C264166666646AD2D5A419A999999D30C2641333333B3AD2D5A41CDCCCCCCE70C2641CDCCCC4CAC2D5A41000000003F0D264133333333A22D5A41CDCCCCCC660D2641CDCCCCAC9F2D5A419A999999B20D2641333333939D2D5A419A9999990D0E264100000080902D5A4166666666410E2641333333738D2D5A41CDCCCCCC8C0E264100000060862D5A419A999999B40E2641333333D3832D5A4133333333C70E26419A999999822D5A419A999999D40E264166666666812D5A419A999999E60E264166666666802D5A41CDCCCCCCFE0E264166666666812D5A419A999999160F264100000020822D5A41CDCCCCCC2C0F2641CDCCCCCC822D5A41CDCCCCCC370F264166666626832D5A41CDCCCCCC3E0F264100000060832D5A41CDCCCCCC6B0F2641CDCCCCEC872D5A41CDCCCCCC760F2641333333D3882D5A4133333333940F264133333393892D5A419A999999A80F264133333353892D5A41CDCCCCCCAF0F26419A999939892D5A4133333333BE0F26419A9999398B2D5A4166666666CD0F2641333333138D2D5A419A999999E10F2641000000E08F2D5A4133333333E60F264133333373902D5A41CDCCCCCCED0F264166666606912D5A41CDCCCCCCF60F26419A9999B9912D5A4133333333FF0F264166666606922D5A41CDCCCCCCFF0F264166666606922D5A41333333330410264100000020922D5A416666666609102641333333F3912D5A4166666666651026419A9999D9912D5A4166666666B9102641666666C6912D5A416666666619112641CDCCCCAC932D5A410000000025112641666666268F2D5A419A99999924112641CDCCCC2C892D5A4133333333EC1026419A9999B9822D5A4100000000E4102641000000C07E2D5A41CDCCCCCCF31026419A9999397C2D5A41CDCCCCCC13112641333333B37B2D5A41CDCCCCCC77112641333333937B2D5A41666666668B11264133333313782D5A4133333333731126419A999919752D5A419A99999961112641333333F3732D5A41333333334F112641666666A6722D5A41000000004711264166666626722D5A41CDCCCCCC46112641666666266F2D5A41666666669E112641CDCCCC8C672D5A4166666666BE11264166666686672D5A41CDCCCCCCE51126419A999979612D5A41CDCCCCCC09122641333333F3602D5A41000000006E1226419A999959632D5A41CDCCCCCC971226419A999959632D5A41CDCCCCCCAD12264166666646632D5A41CDCCCCCCED122641333333B3612D5A419A999999511326419A999919622D5A4133333333F5132641CDCCCCEC5C2D5A413333333321142641000000E05C2D5A416666666681142641666666465F2D5A4100000000A5142641000000405F2D5A4133333333A91426419A9999395F2D5A410000000009152641000000A05B2D5A4100000000311526419A9999195C2D5A419A9999994015264133333393562D5A419A9999995C152641CDCCCC0C562D5A41CDCCCCCCF0152641666666E65B2D5A41CDCCCCCC60162641666666C65B2D5A41CDCCCCCCC4162641CDCCCCAC5B2D5A41CDCCCCCCE0162641000000205E2D5A419A999999F11626419A999919692D5A419A9999991D17264133333313692D5A416666666632172641000000006B2D5A41333333333F172641666666266C2D5A419A9999997D17264133333373692D5A419A999999B5172641666666E66B2D5A41000000000E182641CDCCCC4C712D5A41333333337A182641CDCCCC2C762D5A4133333333FE182641CDCCCC0C772D5A416666666632192641000000007A2D5A41CDCCCCCC5E192641333333F37F2D5A41333333339F19264100000060862D5A4133333333F3192641666666C6872D5A4100000000301A264133333333942D5A4100000000481A2641CDCCCC2C942D5A41CDCCCCCC671A264166666626922D5A41CDCCCCCC871A264100000020922D5A4100000000A01A264133333393952D5A4166666666B41A2641CDCCCC8C9C2D5A419A999999DC1A2641666666869F2D5A4166666666301B2641CDCCCCEC9D2D5A4166666666441B2641666666669C2D5A41666666667C1B26419A9999599D2D5A41666666667E1B2641000000E09B2D5A419A999999831B26419A9999F9982D5A419A999999871B2641000000C0962D5A419A999999881B2641CDCCCC2C952D5A419A999999891B264166666626912D5A419A9999998E1B2641333333F3802D5A419A999999961B2641000000C0642D5A41000000009A1B26419A9999D9592D5A41333333339A1B264133333333572D5A41333333339A1B2641333333F3562D5A41333333339E1B264166666666532D5A4100000000AF1B264166666626442D5A4133333333C01B264133333373332D5A41CDCCCCCCC51B2641333333B32D2D5A4166666666C61B2641333333D32C2D5A4100000000CC1B2641666666E6282D5A41CDCCCCCCCD1B2641666666A6272D5A4100000000CE1B264100000040272D5A4133333333CE1B264133333333272D5A4100000000CF1B2641000000C0252D5A4133333333CF1B26419A999999252D5A4166666666CF1B264100000080252D5A4133333333D41B2641666666C6202D5A419A999999D61B2641000000401E2D5A41CDCCCCCCD71B2641CDCCCC0C1D2D5A4166666666D81B2641666666261C2D5A4133333333D91B2641000000401B2D5A4166666666D71B26419A9999391B2D5A4166666666E41B26419A9999390F2D5A4166666666E81B2641333333D30A2D5A419A999999EC1B26419A999979062D5A41CDCCCCCCF21B2641333333D3FF2C5A41CDCCCCCCFA1B26419A999999F72C5A4133333333FF1B264166666606F32C5A419A999999FF1B2641CDCCCCACF22C5A41CDCCCCCC021C264100000000EF2C5A419A999999141C264133333373EE2C5A41333333332F1C2641CDCCCCACED2C5A41666666664F1C2641000000A0EC2C5A4166666666671C2641333333F3EB2C5A419A9999996E1C2641666666C6EB2C5A41333333338B1C264133333313EB2C5A4133333333AD1C264133333333EA2C5A41CDCCCCCCC61C264133333393E92C5A4133333333CE1C264133333373E92C5A4166666666D81C264100000040E92C5A41CDCCCCCCEA1C2641666666E6E82C5A41CDCCCCCC351D2641333333F3E72C5A41666666666A1D2641CDCCCC4CE72C5A41CDCCCCCC6D1D264100000040E72C5A41CDCCCCCC711D2641CDCCCC2CE72C5A4100000000A21D264133333333E62C5A41CDCCCCCCD71D264100000020E52C5A4166666666F61D264166666686E42C5A4166666666FE1D264133333373E42C5A41666666660F1E2641CDCCCC6CE42C5A419A999999191E26419A999999E42C5A41CDCCCCCC251E264166666606E52C5A419A999999301E26419A999919E52C5A41CDCCCCCC341E264100000020E52C5A41CDCCCCCC6B1E2641CDCCCC4CE42C5A4133333333781E264133333313E42C5A41000000007F1E2641000000C0E32C5A41CDCCCCCC861E2641CDCCCC4CE32C5A419A999999911E2641666666A6E22C5A41333333339B1E264166666626E22C5A41CDCCCCCCA61E2641666666C6E12C5A419A999999B21E2641333333B3E12C5A419A999999B91E2641666666A6E12C5A41CDCCCCCCBD1E2641666666A6E12C5A4133333333C61E2641000000A0E12C5A4100000000DD1E26419A9999D9E12C5A4133333333EB1E26419A9999F9E12C5A4100000000F01E2641CDCCCC0CE22C5A419A999999021F264100000000E22C5A419A999999161F26419A9999F9E12C5A4100000000211F2641CDCCCCECE12C5A4100000000301F2641666666A6E12C5A41CDCCCCCC391F264133333373E12C5A41CDCCCCCC401F264100000040E12C5A41CDCCCCCC651F26419A9999F9DF2C5A41CDCCCCCC7C1F264133333373DF2C5A4133333333861F264166666666DF2C5A41333333338E1F264133333353DF2C5A41CDCCCCCCAA1F264100000060DF2C5A419A999999AB1F264100000060DF2C5A4133333333AF1F264166666666DF2C5A41CDCCCCCCB11F264166666666DF2C5A419A999999B41F26419A999979DF2C5A4133333333BB1F264166666686DF2C5A4166666666C01F2641000000A0DF2C5A4166666666C91F2641333333D3DF2C5A4133333333DB1F2641CDCCCC2CE02C5A4166666666E31F26419A999959E02C5A4100000000ED1F264100000080E02C5A41333333331720264166666626E12C5A41333333331C20264100000040E12C5A41333333335120264133333313E22C5A41333333335120264166666666E22C5A41000000009020264100000020E42C5A4166666666BE20264133333373E52C5A4166666666E5202641000000A0E62C5A41CDCCCCCCF520264133333313E72C5A41CDCCCCCC08212641CDCCCC6CE72C5A419A9999990B21264133333373E72C5A41CDCCCCCC12212641CDCCCC8CE72C5A4100000000392126419A999919E82C5A41333333335F212641666666C6E82C5A41000000007721264133333333E92C5A419A999999A6212641CDCCCC0CEA2C5A4166666666BA21264133333373EA2C5A419A999999C9212641333333D3EA2C5A41CDCCCCCCF0212641CDCCCCECEB2C5A4166666666FC212641CDCCCC6CEC2C5A41CDCCCCCC01222641666666A6EC2C5A419A9999993A2226419A9999F9EF2C5A413333333346222641000000A0F02C5A41CDCCCCCC56222641CDCCCC8CF12C5A41666666666A2226419A9999B9F22C5A41000000007522264133333353F32C5A41CDCCCCCC79222641000000A0F32C5A4166666666932226419A999919F52C5A41333333339622264166666646F52C5A4166666666A822264100000060F62C5A419A999999C222264100000040F82C5A41CDCCCCCCD72226419A9999B9F92C5A419A999999E222264100000060FA2C5A41CDCCCCCCEF2226419A999919FB2C5A419A999999F2222641CDCCCC4CFB2C5A4133333333F72226419A9999B9FB2C5A4100000000FC2226419A999919FC2C5A419A999999FE22264166666646FC2C5A41CDCCCCCC0023264133333373FC2C5A41CDCCCCCC0223264166666686FC2C5A41333333333023264100000040FE2C5A419A9999994E23264100000060FF2C5A41000000006A23264166666666002D5A41000000007823264133333333012D5A41CDCCCCCC8B23264133333373022D5A416666666692232641CDCCCC0C032D5A419A999999A12326419A999959042D5A4100000000B1232641CDCCCCAC052D5A4166666666C423264166666626062D5A4166666666D1232641CDCCCC4C072D5A4133333333EF232641333333D3092D5A41CDCCCCCC0D242641CDCCCC6C0C2D5A4133333333032426419A9999F90D2D5A419A99999916242641CDCCCC0C102D5A419A9999992A242641CDCCCC2C122D5A41000000003E24264100000040142D5A419A9999994824264166666666152D5A419A9999996024264100000040172D5A41CDCCCCCC65242641000000A0172D5A41CDCCCCCC692426419A9999D9172D5A41CDCCCCCC752426419A999979182D5A416666666684242641CDCCCC2C192D5A4100000000892426419A999979192D5A413333333391242641CDCCCC2C1A2D5A4133333333A8242641000000401C2D5A4166666666BF242641666666661E2D5A419A999999C42426419A9999F91E2D5A4100000000C9242641666666861F2D5A4133333333D3242641333333F3202D5A4166666666DD24264133333353222D5A4100000000EA242641000000C0232D5A419A99999904252641CDCCCC6C262D5A41666666661A252641666666A6282D5A41CDCCCCCC38252641CDCCCCCC2B2D5A41CDCCCCCC44252641CDCCCC0C2D2D5A419A9999994A252641CDCCCCAC2D2D5A419A99999964252641CDCCCC8C302D5A41000000006B25264166666686312D5A413333333374252641000000C0322D5A413333333387252641CDCCCC4C352D5A41CDCCCCCC942526419A999919372D5A4100000000AD252641666666463A2D5A4100000000B7252641000000803B2D5A4166666666C2252641000000003D2D5A4100000000CB252641666666063E2D5A4133333333D0252641666666A63E2D5A4133333333DF25264133333393402D5A4166666666E82526419A9999F9412D5A4166666666FA252641333333B3442D5A41666666660226264166666606462D5A416666666606262641333333B3462D5A41CDCCCCCC0726264133333333472D5A41666666660826264133333373472D5A41CDCCCCCC0C26264100000080482D5A419A9999990D262641333333B3482D5A419A99999915262641CDCCCC8C4A2D5A41333333331B262641333333B34B2D5A419A99999924262641CDCCCC8C4D2D5A419A9999992A262641000000A04E2D5A41000000002F262641CDCCCC6C4F2D5A41666666663B26264133333333512D5A4133333333372626419A999999512D5A41666666663A26264166666606522D5A419A9999994526264166666686532D5A41CDCCCCCC56262641333333B3552D5A419A999999602626419A999999562D5A4133333333682626419A999959572D5A419A999999702626419A999919582D5A41CDCCCCCC7D26264100000040592D5A41CDCCCCCC932626419A9999395B2D5A41666666669B262641666666065C2D5A4133333333A1262641333333F35C2D5A4100000000A8262641666666265E2D5A41CDCCCCCCAA262641CDCCCCAC5E2D5A41CDCCCCCCB226264166666626602D5A419A999999BC262641666666C6612D5A41CDCCCCCCC1262641666666A6622D5A419A999999CD26264133333393642D5A41CDCCCCCCD9262641333333B3662D5A419A999999DE262641CDCCCCCC672D5A4166666666E2262641000000A0682D5A4100000000EA262641000000C06A2D5A4166666666F2262641000000006D2D5A4100000000F9262641000000E06E2D5A413333333307272641666666E6722D5A419A9999991027264133333373752D5A41CDCCCCCC1727264100000020772D5A41000000002427264100000080792D5A41333333332D272641333333337B2D5A41CDCCCCCC352726419A9999597D2D5A419A9999993F272641000000407F2D5A416666666648272641333333D3802D5A419A99999955272641333333F3822D5A413333333361272641666666C6842D5A419A9999996927264133333353862D5A41CDCCCCCC7227264100000020882D5A419A99999976272641666666C6882D5A419A999999862726419A9999D98B2D5A41333333338D272641CDCCCCEC8C2D5A4133333333AE272641CDCCCCCC912D5A419A999999B72726419A999919932D5A4100000000C527264133333393942D5A4166666666ED27264133333333982D5A41666666660E282641333333339B2D5A419A99999930282641CDCCCC6C9D2D5A4133333333762826419A9999F9A12D5A419A999999A5282641CDCCCC0CA52D5A419A999999C22826419A999959A72D5A4166666666F228264100000020AB2D5A41666666661A29264166666626AE2D5A4166666666252926419A9999F9AE2D5A419A9999992229264100000040AF2D5A4166666666072926419A999919B22D5A419A999999E4282641CDCCCCACB52D5A4133333333CA28264133333353B82D5A4166666666BA2826419A9999D9B92D5A41000000009928264100000000BD2D5A41CDCCCCCC6A282641666666A6C12D5A41CDCCCCCC3D2826419A999939C62D5A41CDCCCCCC1E28264166666666C92D5A4166666666FF27264133333393CC2D5A4166666666FB2726419A9999F9CC2D5A41CDCCCCCCF427264133333393CD2D5A4100000000EA272641CDCCCC8CCE2D5A4133333333D627264100000040D02D5A419A999999CD2726419A9999F9D02D5A41CDCCCCCCCB27264100000020D12D5A4166666666C927264133333353D12D5A41CDCCCCCCF4272641CDCCCCCCD32D5A41666666661E28264100000000D62D5A41333333332D282641666666C6D62D5A41333333333428264166666626D72D5A419A9999994D28264133333353D82D5A419A9999996528264133333353D92D5A41666666669128264166666626DB2D5A4166666666B5282641000000A0DC2D5A419A999999D92826419A999919DE2D5A419A999999EF2826419A9999F9DE2D5A419A999999FE282641000000A0DA2D5A41CDCCCCCC20292641333333B3DD2D5A41666666662F29264133333313DF2D5A41000000004729264133333333E12D5A419A9999995E29264100000080E32D5A419A9999995A29264100000060E52D5A4133333333212926419A999919ED2D5A41CDCCCCCC07292641CDCCCC4CF02D5A4100000000EC2826419A9999D9F32D5A41000000002929264100000060F92D5A413333333339292641000000E0FA2D5A419A9999995729264100000080FD2D5A419A9999996A29264166666626FF2D5A41000000008D292641CDCCCC8C022E5A4166666666D7292641666666C6002E5A4166666666F42926419A999919002E5A4100000000FF2926419A9999B9FF2D5A4133333333132A26419A9999D9FE2D5A419A9999994D2A264166666686FB2D5A419A9999995D2A2641CDCCCC6CFB2D5A4166666666912A264166666606FC2D5A4166666666A82A264133333353FC2D5A41CDCCCCCCBB2A2641333333B3FC2D5A419A999999BE2A26419A9999B9FC2D5A4133333333CD2A26419A999999F82D5A41CDCCCCCCD32A2641333333B3F62D5A4166666666E12A264100000080F32D5A4166666666EE2A26419A999959F02D5A4133333333F82A2641CDCCCCECED2D5A419A999999FF2A2641666666E6EB2D5A41000000000C2B264100000060E82D5A419A999999122B264166666666E62D5A41000000001A2B26419A999939E42D5A4166666666222B2641CDCCCC8CE12D5A41666666662A2B26419A999919DF2D5A41CDCCCCCC332B26419A9999B9DB2D5A41CDCCCCCC452B264166666606D52D5A419A9999994B2B264133333333D32D5A41333333335C2B2641666666C6CD2D5A41CDCCCCCC672B26419A999919CA2D5A41CDCCCCCC7A2B264166666606C42D5A4133333333892B264166666666BF2D5A41CDCCCCCC9F2B264133333353B82D5A4133333333A32B2641CDCCCC2CB72D5A4133333333A62B2641666666C6B52D5A4133333333A92B264100000040B42D5A4100000000AD2B2641000000C0B22D5A4100000000C32B264100000080AB2D5A4133333333D72B2641000000E0A42D5A419A999999E52B264133333313A02D5A4100000000FE2B26419A9999F9962D5A41666666660B2C2641666666E6912D5A4133333333172C2641333333738D2D5A4100000000082C2641000000008C2D5A41CDCCCCCCF42B2641000000C08A2D5A4166666666EC2B26419A9999398A2D5A419A999999D02B26419A999959882D5A4100000000A12B26419A999979852D5A4166666666892B26419A999919842D5A419A999999862B264100000080842D5A41000000007E2B2641666666C6852D5A419A9999996C2B264133333313882D5A419A999999652B2641CDCCCCAC882D5A41000000005F2B2641CDCCCC0C892D5A419A999999542B26419A999919892D5A41CDCCCCCC3B2B264166666666882D5A41666666662D2B2641CDCCCCCC872D5A41666666661D2B264166666626872D5A4100000000142B2641CDCCCC2C862D5A41CDCCCCCCFC2A26419A999959842D5A4133333333D22A264133333393812D5A419A9999999A2A2641333333F37D2D5A41CDCCCCCCA22A2641CDCCCCAC7B2D5A4133333333A92A2641666666E6792D5A419A999999872A264100000000782D5A4133333333902A264133333393722D5A4166666666392A264133333393702D5A419A999999582A2641666666C6612D5A41666666662B2A2641000000E05C2D5A4166666666E1292641333333D3542D5A41CDCCCCCC96292641CDCCCCAC4C2D5A41666666667429264133333393492D5A41CDCCCCCC66292641000000804C2D5A41CDCCCCCC3929264133333353492D5A419A9999991A2926419A999919472D5A41CDCCCCCC15292641666666C6462D5A41333333330F2926419A9999B9462D5A4166666666092926419A9999D9452D5A419A9999991229264166666646452D5A41333333331B292641CDCCCCAC442D5A41CDCCCCCC60292641333333733D2D5A4133333333702926419A9999D93B2D5A41CDCCCCCC71292641333333B33B2D5A4133333333FA292641CDCCCCEC2C2D5A41333333334C2A26419A999939262D5A41333333334F2A264100000000262D5A419A999999502A2641666666E6252D5A41666666664B2A26419A9999B9242D5A4133333333362A2641CDCCCC8C202D5A4166666666182A26419A9999591B2D5A4166666666072A2641CDCCCC6C182D5A4133333333FA29264166666646162D5A4133333333F32926419A999939152D5A419A999999DD29264133333353122D5A4166666666D229264133333313112D5A4166666666BB292641333333930E2D5A41CDCCCCCCA8292641000000800C2D5A41333333339B292641333333F30A2D5A419A9999998E29264100000060092D5A41CDCCCCCC7F29264100000040072D5A41333333337729264133333393052D5A41CDCCCCCC692926419A9999F9022D5A41CDCCCCCC64292641CDCCCCEC012D5A41CDCCCCCC6129264166666646012D5A41000000005E29264133333313002D5A41666666665629264133333313FD2C5A419A9999994C29264133333313F82C5A416666666640292641333333F3F32C5A41CDCCCCCC34292641666666A6F32C5A419A9999991F2926419A9999B9F22C5A41000000001C292641666666A6F22C5A41666666660029264166666666F12C5A4100000000A9282641333333F3ED2C5A41333333335228264133333353E92C5A41CDCCCCCCFF2726419A999939E52C5A41CDCCCCCCD2272641666666C6E22C5A4133333333CC272641CDCCCC6CE22C5A4100000000B927264166666646E12C5A41333333338C27264133333313DE2C5A41666666666E27264166666626DC2C5A41666666665127264166666626DA2C5A41000000004327264133333353D92C5A41666666661F2726419A999979D72C5A4133333333002726419A9999B9D52C5A419A999999D62626419A999959D32C5A4100000000A826264133333353D02C5A41CDCCCCCC9326264100000060CF2C5A41CDCCCCCC8B26264133333313CF2C5A413333333356262641333333F3CD2C5A41666666663B262641CDCCCC2CCD2C5A41CDCCCCCC2826264133333353CC2C5A419A9999995E26264100000060BD2C5A410000000087262641CDCCCCECB12C5A4100000000B626264133333333A72C5A4133333333E9262641CDCCCC0C9B2C5A419A999999ED2626419A999939992C5A419A9999990C2726419A9999998C2C5A41CDCCCCCC18272641000000C0852C5A41CDCCCCCC26272641666666067E2C5A41CDCCCCCC43272641000000406F2C5A419A9999995E2726419A9999795F2C5A419A9999996E272641000000A04F2C5A41333333337D27264133333393422C5A416666666684272641666666E63D2C5A41000000008E272641666666C63B2C5A416666666697272641CDCCCC8C3A2C5A419A9999999D272641CDCCCC4C3A2C5A4133333333B9272641CDCCCCAC372C5A4166666666F2272641CDCCCC4C322C5A41000000001B282641000000A02E2C5A41666666661B282641666666462E2C5A41333333332328264100000020262C5A419A99999939282641CDCCCCAC132C5A41333333335028264166666646012C5A413333333376282641CDCCCC2CE42B5A41CDCCCCCC80282641CDCCCC2CDD2B5A410000000093282641333333F3D52B5A4133333333972826419A999939D52B5A41CDCCCCCC9F282641CDCCCCCCD32B5A41333333337D2826419A999959CF2B5A419A99999966282641CDCCCC6CCC2B5A410000000066282641CDCCCCECCA2B5A41CDCCCCCC6428264166666686C22B5A41333333336328264166666606B82B5A416666666661282641CDCCCCECAB2B5A41000000005F282641333333339F2B5A41333333335D2826419A999999922B5A419A9999995B2826419A999959872B5A41000000005B282641333333F3852B5A41333333335A282641000000E07D2B5A41000000005928264133333393732B5A4166666666582826419A9999196D2B5A419A999999572826419A9999F9652B5A41666666668428264166666646592B5A419A9999999B2826419A999979522B5A41CDCCCCCCA6282641666666E64E2B5A4166666666AE2826419A9999994B2B5A41CDCCCCCCB1282641333333D3492B5A41CDCCCCCCB32826419A999979482B5A4166666666B22826419A999999462B5A419A999999AD28264133333393432B5A4100000000A5282641666666A63F2B5A41CDCCCCCC8D2826419A999999362B5A41333333337C282641000000C02F2B5A410000000073282641CDCCCC0C2C2B5A41CDCCCCCC5A282641333333B3222B5A416666666646282641333333D31A2B5A41000000004028264100000060182B5A41333333333F282641000000C0172B5A419A9999995C2726419A9999391A2B5A419A999999D7262641333333B31B2B5A4100000000492626419A9999D91E2B5A410000000007262641000000A0202B5A419A999999F52526419A999919212B5A4133333333F525264133333313212B5A41CDCCCCCCF4252641000000E0202B5A4166666666F4252641000000C0202B5A4100000000F325264166666626202B5A4133333333E5252641666666661A2B5A419A999999B62526419A9999F9072B5A4100000000AC252641CDCCCC2C042B5A41333333339B252641000000E0FE2A5A41CDCCCCCC8B25264133333333FB2A5A41000000006925264100000080F52A5A41333333332D252641CDCCCC4CEB2A5A4133333333F2242641000000A0E12A5A4166666666F3242641CDCCCC8CE12A5A419A999999F02426419A999919E12A5A4133333333E424264100000020DF2A5A4166666666D82426419A999939DD2A5A4100000000BC24264166666626D92A5A41333333339624264166666666D42A5A4133333333912426419A9999D9D32A5A41666666668324264100000080D22A5A41666666667C24264166666606D02A5A4166666666692426419A999939C92A5A410000000060242641666666E6C52A5A41333333331024264133333373A92A5A419A999999C2232641CDCCCC0C8E2A5A419A9999997D232641CDCCCC6C762A5A41CDCCCCCC4023264100000000632A5A41CDCCCCCC1A2326419A9999B9572A5A4166666666FD222641CDCCCCAC4F2A5A4100000000E6222641333333334A2A5A41CDCCCCCC9D222641666666C63C2A5A410000000063222641333333932F2A5A41000000002C222641333333F3212A5A41333333330A222641CDCCCC4C192A5A41666666660622264133333353182A5A41000000000622264133333333182A5A41CDCCCCCC2F22264133333333162A5A4133333333D1222641CDCCCC2C0E2A5A419A99999921232641CDCCCC2C0A2A5A419A999999E223264166666686002A5A41CDCCCCCC172426419A999919032A5A41CDCCCCCC5224264100000000062A5A410000000092242641CDCCCCEC082A5A419A99999993242641000000A0082A5A419A9999999524264166666646082A5A41CDCCCCCCA824264166666626022A5A4133333333B7242641333333F3FD295A4100000000EF24264166666666ED295A41CDCCCCCCEF2426419A999919ED295A419A999999F424264133333373EA295A419A999999F6242641000000E0E4295A41CDCCCCCCF92426419A999999D9295A4133333333FB242641333333B3D8295A419A999999FD242641CDCCCCCCD6295A4166666666032526419A999999D2295A419A999999032526419A999979D2295A419A999999842426419A9999F9C9295A41CDCCCCCC74242641CDCCCCECC8295A410000000035242641333333B3C4295A416666666646242641333333D3B8295A4166666666502426419A999919B2295A41CDCCCCCC5F24264166666686A7295A41000000006724264100000080A2295A41333333338F2426419A99993987295A41666666669B242641000000E07E295A4166666666A0242641000000C07B295A41CDCCCCCCC8242641333333D374295A4133333333C92426419A9999B974295A4133333333CA242641CDCCCC8C74295A4100000000B12426419A99999969295A419A99999970242641333333734D295A41333333336A242641333333D34A295A413333333347242641333333D33C295A419A999999B8232641CDCCCC4C40295A419A999999562326413333335343295A4133333333F92226419A9999B947295A419A9999998D222641CDCCCCAC4D295A41666666668B222641666666C64D295A41CDCCCCCC88222641666666E64D295A4100000000872226419A9999F94D295A41CDCCCCCC5B2226419A99997945295A4100000000562226419A99995942295A41CDCCCCCC4C222641333333533D295A410000000041222641CDCCCC4C34295A4166666666FF212641333333B337295A41CDCCCCCCA7212641000000A03C295A410000000098212641666666863D295A41666666661C2126410000008044295A4166666666752026419A9999394E295A4133333333622026419A9999594F295A4133333333512026416666664650295A41333333332F2026413333337352295A4166666666182026419A99993954295A41CDCCCCCC032026416666662656295A419A999999F41F2641666666C657295A4133333333F41F2641333333D357295A41CDCCCCCCDE1F2641666666065C295A4166666666D51F2641666666065D295A41CDCCCCCCBF1F2641666666A65D295A4100000000B81F2641000000E05D295A4100000000A61F2641333333935E295A41CDCCCCCC891F2641000000C05F295A41CDCCCCCC871F26419A9999D95F295A41666666666E1F26419A99991961295A4100000000591F26416666662662295A4100000000491F2641333333B362295A4100000000341F26410000006063295A41CDCCCCCC1F1F26416666660664295A419A999999FA1E26416666664665295A4166666666DE1E26419A99993966295A41CDCCCCCC7D1E2641CDCCCC0C69295A4166666666871D2641CDCCCCAC6E295A4166666666001D26416666662671295A419A999999FA1B2641CDCCCCCC73295A41CDCCCCCC5A1B2641333333F374295A41CDCCCCCC9F1926419A99991974295A41666666664A192641CDCCCC4C74295A413333333341192641CDCCCC8C74295A41000000000B1926419A9999F975295A419A999999C2182641000000C079295A41666666663A182641CDCCCC8C80295A41CDCCCCCC01182641333333D382295A4133333333CF1726410000002083295A419A9999998F1726416666668683295A41CDCCCCCC311726416666664683295A419A9999991C172641CDCCCC4C82295A4100000000D8162641000000E080295A4166666666BD162641CDCCCCEC80295A41333333337B162641CDCCCC0C7F295A419A9999993D162641333333737D295A419A9999990F162641CDCCCC0C7D295A4166666666F7152641000000207D295A4133333333DB152641333333937D295A410000000089152641666666A67F295A4100000000351526413333331382295A41000000001C1526413333335382295A419A999999181526413333335382295A413333333353142641000000C080295A41666666660F142641CDCCCC6C81295A4133333333E11326419A9999B981295A4133333333B6132641333333F381295A41CDCCCCCC8C1326416666666681295A41CDCCCCCC651326410000006080295A41666666662A1326419A9999197E295A419A999999DF122641333333337B295A4100000000981226410000008078295A41666666663F1226416666660676295A4100000000D71126416666666673295A4166666666751126410000000071295A410000000016112641CDCCCCCC6E295A419A999999BC102641000000C06C295A416666666607102641CDCCCCEC67295A41333333339E0F26416666668665295A41666666669D0F26410000008065295A419A999999890F26419A9999D965295A41CDCCCCCC720F2641CDCCCC2C66295A4100000000550F26416666662666295A4133333333310F26419A9999F965295A419A999999140F26410000008065295A419A999999DC0E26416666666664295A4100000000AA0E26419A99995963295A41000000004E0E26416666668661295A4166666666150E26419A99995960295A4166666666D80D2641666666065F295A419A999999990D2641000000C05D295A4100000000920D26419A9999995D295A41333333338F0D2641333333935D295A41333333338F0D2641CDCCCCEC5D295A41000000008F0D2641333333935E295A41CDCCCCCC8F0D2641CDCCCCEC67295A419A9999998F0D2641000000E06D295A41666666668F0D26419A9999F96E295A41CDCCCCCC8E0D26416666660672295A419A999999890D2641CDCCCC0C75295A4133333333810D2641CDCCCC6C78295A41CDCCCCCC770D2641000000A07C295A41CDCCCCCC720D26419A9999B97F295A4166666666700D2641333333F382295A419A999999730D2641CDCCCC0C86295A4133333333790D26413333337388295A41CDCCCCCC830D2641000000208B295A419A999999AB0D26410000008092295A41CDCCCCCCC80D26416666660698295A419A999999CE0D26416666662699295A4166666666E30D2641CDCCCCCC9D295A419A999999EA0D26419A9999599F295A419A999999EE0D2641CDCCCCECA0295A41CDCCCCCCF20D2641CDCCCCCCA2295A4100000000F50D26419A9999B9A4295A4166666666F50D2641000000C0A7295A4166666666F20D2641000000C0AD295A4133333333EF0D264133333393B8295A41CDCCCCCCEF0D2641333333B3C4295A4133333333EF0D26419A9999B9CA295A41CDCCCCCCEE0D26419A999999CC295A419A999999EE0D26419A999979CE295A41CDCCCCCCF40D264166666666D4295A4133333333010E264100000040DC295A41666666660B0E2641CDCCCC8CE2295A41666666661B0E26419A999959EC295A41333333331F0E2641CDCCCCACEE295A419A999999260E26419A9999F9F3295A419A9999992E0E264100000060F8295A4166666666310E2641333333D3FA295A41CDCCCCCC310E26419A9999F9FC295A41CDCCCCCC2F0E264166666646FF295A4166666666290E264166666606032A5A41CDCCCCCC250E2641333333D3042A5A4100000000150E2641000000C0042A5A4166666666120E2641666666C6042A5A4133333333C30D2641CDCCCCCC042A5A4100000000A70D26419A9999D9042A5A41666666666F0D264100000000052A5A419A9999991C0D26419A999939052A5A4166666666CC0C264166666686052A5A41CDCCCCCCCA0C264166666666052A5A419A999999C80C2641000000E0042A5A4133333333B10C26419A999939FD295A419A999999510C26419A9999D9FA295A41333333332D0C2641CDCCCCECF9295A4133333333080C264166666606F9295A419A999999D10B26419A999999F7295A4100000000CB0B264133333373F7295A4166666666990B264166666626F6295A4100000000590B264133333373F4295A41CDCCCCCC500B264100000040F4295A41666666664D0B2641000000E0F3295A4166666666370B2641CDCCCC6CF1295A4166666666020B264133333353EB295A4133333333EB0A2641000000A0E8295A419A999999B00A264166666686E1295A41333333334A0A264100000000E2295A41000000003D0A264166666606E2295A4100000000F009264166666626E2295A4166666666E109264133333333E2295A419A999999C709264100000040E2295A41CDCCCCCCD30826419A9999F9E2295A4166666666E6072641000000A0E3295A419A99999974072641666666E6E3295A4166666666700726419A9999D9E3295A41CDCCCCCC63072641CDCCCC2CE4295A41000000003F07264133333353E6295A419A9999992207264166666626EB295A419A999999200726419A999979EB295A413333333321072641666666A6EB295A419A99999921072641000000C0EB295A41CDCCCCCC1907264100000000ED295A41CDCCCCCC1207264133333393ED295A410000000002072641333333F3EE295A41CDCCCCCCEB062641666666C6F0295A4166666666DD062641666666E6F1295A4166666666D206264100000020F3295A4166666666CE062641666666A6F3295A41CDCCCCCCC006264100000000F5295A4133333333BB06264133333353F5295A4166666666B5062641CDCCCC6CF5295A4166666666AE06264100000080F5295A419A999999A106264166666646F5295A419A99999993062641333333F3F4295A4100000000860626419A9999B9F4295A41000000008006264166666666F4295A41CDCCCCCC79062641333333D3F3295A41000000007506264166666686F3295A41CDCCCCCC6C062641CDCCCC4CF3295A419A9999996306264133333333F3295A41000000005C062641CDCCCC6CF3295A41000000005106264133333393F3295A419A99999949062641333333F3F3295A41000000004506264100000080F4295A410000000043062641333333B3F4295A416666666642062641666666C6F4295A41333333333F062641CDCCCCCCF4295A41000000003D062641000000C0F4295A419A9999993A06264133333393F4295A41333333333806264133333333F4295A419A999999360626419A9999B9F3295A419A9999993506264133333333F3295A4133333333330626419A999999F2295A41666666663006264100000020F2295A41333333332D0626419A9999B9F1295A41333333332A0626419A999999F1295A41CDCCCCCC2906264133333393F1295A41CDCCCCCC26062641000000A0F1295A416666666623062641666666C6F1295A419A99999920062641CDCCCC0CF2295A41333333331D062641CDCCCC8CF2295A4166666666190626419A999939F3295A413333333316062641000000C0F3295A413333333314062641333333F3F3295A41666666660D06264100000020F4295A41666666660506264166666606F4295A41CDCCCCCC00062641000000E0F3295A4100000000FE052641666666C6F3295A4133333333FA052641CDCCCC8CF3295A41CDCCCCCCF405264133333313F3295A4100000000F2052641CDCCCCCCF2295A41CDCCCCCCEF05264166666666F2295A41CDCCCCCCEE05264166666626F2295A419A999999ED05264166666606F2295A4100000000EB052641666666E6F1295A41CDCCCCCCE5052641666666C6F1295A4166666666DD0526419A999999F1295A4133333333D705264166666686F1295A4166666666D005264133333333F1295A4100000000CE0526419A9999F9F0295A4100000000CA0526419A999999F0295A4133333333C80526419A999959F0295A419A999999C7052641000000E0EF295A419A999999C7052641000000A0EF295A41CDCCCCCCC805264166666646EF295A4166666666CA052641000000E0EE295A4100000000CB052641CDCCCC8CEE295A4100000000CB05264166666646EE295A4166666666CA05264100000000EE295A4133333333C8052641CDCCCCACED295A4100000000BE052641CDCCCCECEC295A419A999999B805264166666666EC295A41CDCCCCCCB2052641CDCCCCCCEB295A4166666666B00526419A999979EB295A4100000000AC05264166666626EB295A4166666666A5052641333333D3EA295A41666666669705264100000020EA295A419A99999991052641333333D3E9295A419A9999998B05264100000080E9295A41333333338705264133333333E9295A4100000000810526419A9999D9E8295A41333333337D0526419A999999E8295A41333333337905264133333373E8295A41666666667305264133333373E8295A41CDCCCCCC6605264100000080E8295A41CDCCCCCC5E0526419A999979E8295A419A9999995B05264133333373E8295A419A9999995805264133333353E8295A4166666666550526419A9999F9E7295A419A9999995105264133333393E7295A419A9999994F05264166666666E7295A41333333334D052641CDCCCC6CE7295A416666666648052641666666C6E7295A41666666664305264166666626E8295A41666666664105264166666646E8295A41CDCCCCCC3E0526419A999959E8295A41CDCCCCCC3A0526419A999959E8295A419A99999936052641CDCCCC2CE8295A41CDCCCCCC3205264100000000E8295A41666666662E052641333333B3E7295A41CDCCCCCC27052641CDCCCC2CE7295A410000000022052641CDCCCCCCE6295A41666666661C052641666666C6E6295A41666666660C052641000000A0E6295A41000000000605264166666686E6295A4133333333FF04264166666666E6295A41CDCCCCCCFA0426419A999959E6295A4166666666F504264133333353E6295A41CDCCCCCCF50426419A999999E7295A41CDCCCCCCF604264166666626EE295A4100000000F70426419A9999B9EF295A41CDCCCCCCF7042641CDCCCCCCF3295A4133333333F90426419A9999F9FD295A4166666666FA042641000000C0072A5A41CDCCCCCCFB04264166666666112A5A41CDCCCCCCFB0426419A999919132A5A419A999999F4042641333333B3122A5A41CDCCCCCCDA042641CDCCCC0C102A5A41CDCCCCCCD6042641000000A00F2A5A4166666666C3042641333333B30D2A5A41CDCCCCCCA30426419A9999D90A2A5A419A99999988042641CDCCCC0C092A5A413333333368042641333333B3072A5A419A999999440426419A999919072A5A413333333323042641333333B3062A5A41666666661D042641000000A0062A5A413333333317042641CDCCCC8C062A5A41CDCCCCCC1604264133333333072A5A41333333331904264166666686092A5A41CDCCCCCC24042641000000C0152A5A41000000002F0426419A999959202A5A413333333334042641CDCCCC8C252A5A419A99999936042641CDCCCCEC272A5A41333333334104264100000020332A5A41000000005304264100000080452A5A419A99999956042641CDCCCC4C492A5A410000000059042641666666864B2A5A41CDCCCCCC47042641CDCCCC8C4B2A5A41333333331B0426419A9999B94B2A5A419A99999921042641666666A6512A5A41666666662304264100000040532A5A41333333332504264100000020562A5A41CDCCCCCC250426419A999939572A5A41CDCCCCCC280426419A9999D95C2A5A41333333332A042641CDCCCC0C622A5A41333333332A04264166666626622A5A4100000000280426419A999979692A5A4133333333230426419A9999197C2A5A419A9999991E042641666666C6882A5A413333333315042641CDCCCCEC952A5A41000000001304264133333373982A5A4166666666E6032641333333B3942A5A419A999999CC03264100000020932A5A419A99999984032641000000608E2A5A41000000007E032641333333138E2A5A41CDCCCCCC95032641CDCCCCAC9C2A5A413333333398032641333333D39E2A5A41333333339E032641CDCCCC4CA22A5A419A999999A803264133333333A82A5A41CDCCCCCCC7032641666666E6BA2A5A419A999999E30326419A9999D9CC2A5A416666666672032641000000A0D42A5A41000000006603264133333353D52A5A41CDCCCCCC200326419A999959D92A5A41CDCCCCCCC002264166666686DF2A5A419A999999B202264133333393E02A5A4100000000B2022641CDCCCCACE02A5A4166666666A80226419A9999F9E12A5A419A9999999902264133333313E42A5A416666666680022641000000C0E82A5A419A9999995C02264166666666EF2A5A41666666666102264166666626F12A5A410000000070022641666666A6F62A5A410000000076022641000000A0F82A5A4133333333640226419A999999F92A5A413333333347022641CDCCCC4CFB2A5A41	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	01010000206A080000D3411DF48E162641666666A6992B5A41	770300000	Z	Bellot	7703000	77030	77	11	16
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	01010000206A080000A0177A41F03425410000007089195A41	770310000	Z	Bernay-Vilbert	7703100	77031	77	11	17
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	01010000206A080000E0FC852C99E9254133333383AC1C5A41	770320000	Z	Beton-Bazoches	7703200	77032	77	11	18
01060000206A08000001000000010300000001000000070100000000000069E125419A99999935175A41333333336BE125419A99991938175A419A9999996BE125410000006038175A41333333336FE12541000000203B175A413333333370E125419A9999D93B175A410000000077E12541000000C040175A41000000007AE125416666664643175A416666666681E125416666664649175A41333333337EE125419A9999D950175A410000000073E12541CDCCCC6C5A175A413333333373E12541666666A65E175A419A9999997EE12541333333D364175A416666666696E12541000000006D175A41666666669EE125419A9999996F175A41333333339CE12541CDCCCC2C72175A4100000000EFE12541333333937D175A413333333329E22541333333D384175A41000000006BE225410000004089175A41333333338FE22541CDCCCCCC8B175A41CDCCCCCC86E22541000000208E175A4133333333D2E225419A99997993175A410000000032E32541666666269F175A413333333356E325419A9999999C175A41333333339CE32541666666E6A2175A41000000008FE3254100000020AA175A413333333393E32541CDCCCCACAC175A41CDCCCCCCB6E3254166666606C4175A4100000000C0E325419A9999B9C9175A41CDCCCCCCCAE3254166666666D0175A41CDCCCCCCE2E32541000000C0DE175A413333333307E425419A9999B9F4175A419A9999992EE42541000000A00F185A416666666657E42541666666062A185A416666666672E42541333333333B185A413333333379E42541666666A649185A41000000007BE42541000000C04D185A416666666684E42541000000E060185A41CDCCCCCC8EE42541666666C674185A410000000096E42541CDCCCC0C83185A410000000098E42541CDCCCCCC86185A41666666669AE42541666666468B185A41666666669DE425410000006091185A41CDCCCCCC9FE425419A99999995185A419A99999938E42541333333F393185A41333333339BE325413333337391185A41666666668EE325419A9999599B185A41CDCCCCCC58E325419A9999F999185A416666666637E32541CDCCCC4CB3185A416666666628E32541000000A0BD185A410000000004E325419A999939BC185A4133333333B1E2254133333313DC185A41CDCCCCCCD0E2254133333373DE185A4166666666F8E22541000000A0DF185A4100000000DCE225419A9999D9E9185A4100000000B4E22541CDCCCC4CF5185A416666666683E225416666662605195A410000000058E22541CDCCCCEC03195A41333333334AE225410000008009195A410000000041E22541333333D324195A413333333341E22541333333B329195A413333333372E22541CDCCCCEC30195A41333333337CE225413333337332195A413333333382E225413333335333195A41666666668CE225416666664635195A41000000008FE225419A9999D935195A413333333393E225419A9999F936195A4166666666BAE225413333339342195A4166666666DCE22541000000A04C195A4133333333F8E225413333337357195A41CDCCCCCCF8E22541CDCCCCCC57195A4100000000F9E22541CDCCCC4C59195A4100000000F9E22541000000A059195A419A999999FEE225416666660660195A416666666601E325419A9999D961195A41333333331CE32541CDCCCC0C73195A41333333331DE32541666666C674195A41CDCCCCCC1EE325410000002077195A41CDCCCCCC1DE325419A9999797A195A41000000001CE325413333333380195A419A9999991FE32541CDCCCC4C87195A41333333331EE32541CDCCCC2C8C195A410000000014E32541CDCCCC2C95195A41000000000BE325419A9999F99C195A4133333333FAE2254166666606A3195A416666666634E3254100000020AD195A41000000009EE3254166666606BF195A41CDCCCCCCFCE32541CDCCCC4CC5195A410000000066E425419A9999D9CB195A41333333335DE42541000000A0CE195A41666666668EE42541CDCCCC4CD1195A410000000005E52541CDCCCCECD7195A413333333326E5254100000020DA195A41CDCCCCCC47E52541666666C6DA195A419A99999946E52541CDCCCC8CDC195A41666666663EE52541CDCCCC6CE7195A419A99999935E5254166666606F2195A416666666669E525419A999919F2195A410000000083E5254100000040F2195A4166666666DEE5254133333373F3195A410000000045E62541CDCCCC4CF5195A419A999999CFE6254100000080F8195A4133333333E7E62541666666E6FF195A416666666638E7254133333393FE195A419A9999994AE72541333333B3ED195A4100000000B8E7254133333353EC195A41666666663EE82541666666C6EA195A41CDCCCCCC34E8254133333313E5195A41333333335DE8254166666686E3195A41CDCCCCCCE1E8254166666646DE195A416666666642E9254100000060DA195A419A9999993FE925419A999939D3195A419A999999A0E9254133333313D3195A41CDCCCCCCCEE92541CDCCCCCCCF195A413333333340EA25419A999959D2195A41CDCCCCCC90EA2541CDCCCC2CD4195A4166666666B4EA25419A999939D5195A419A999999C0EA2541CDCCCCECCC195A4166666666CFEA2541CDCCCC6CC2195A4166666666D9EA2541666666A6BB195A41CDCCCCCCDEEA2541CDCCCC0CB6195A419A999999DDEA25419A999959B2195A4100000000DCEA2541CDCCCC8CAF195A4100000000D9EA254166666606AD195A4133333333D4EA2541666666E6A9195A4166666666CAEA25419A9999F9A5195A4133333333BAEA25419A9999599F195A419A9999999DEA25413333331396195A410000000083EA2541CDCCCC8C8C195A410000000066EA2541CDCCCC4C82195A41000000004DEA25419A99993979195A41CDCCCCCC45EA2541CDCCCC8C75195A413333333343EA25416666660672195A419A99999940EA25419A9999796D195A416666666641EA25419A9999D969195A419A99999943EA2541000000E064195A41000000004CEA25419A9999D95D195A41CDCCCCCC5AEA25410000006052195A41000000005CEA25419A99997951195A41333333335DEA25410000008050195A41000000006AEA2541666666A646195A416666666676EA2541CDCCCC8C3D195A419A99999985EA25419A99991932195A41000000008FEA25416666668629195A41CDCCCCCC95EA25419A99993923195A41CDCCCCCC9DEA25419A99997919195A41CDCCCCCCA3EA25413333337310195A419A999999A9EA2541000000C007195A4166666666BAEA2541666666E6F2185A419A999999C5EA254133333353E3185A4100000000C8EA254100000000E0185A4133333333C8EA2541CDCCCC0CDD185A4166666666C7EA2541000000E0D9185A419A999999C4EA254166666646D6185A419A999999BEEA254133333333D2185A419A999999B4EA2541CDCCCC8CCE185A4100000000A6EA2541666666A6CA185A413333333393EA254166666686C6185A416666666676EA2541000000E0C0185A419A99999954EA25419A999979BA185A419A9999993EEA2541666666A6B5185A41CDCCCCCC32EA254100000060B2185A410000000031EA2541CDCCCCCCB1185A41CDCCCCCC28EA254100000000AF185A416666666621EA254100000060AB185A419A9999991CEA25419A999939A7185A41CDCCCCCC19EA25419A9999F9A1185A41333333331BEA25416666662698185A41CDCCCCCC1CEA2541CDCCCC4C8D185A41666666661EEA25410000002082185A416666666624EA2541CDCCCC2C7A185A416666666629EA2541333333F374185A41CDCCCCCC32EA25413333339370185A41333333333FEA2541666666466B185A41CDCCCCCC53EA25410000004064185A41CDCCCCCC59EA25413333335362185A41CDCCCCCC67EA2541000000805D185A41CDCCCCCC7AEA2541666666A656185A41CDCCCCCC7FEA25419A99997954185A416666666685EA25416666660652185A41666666668BEA2541000000A04E185A41CDCCCCCC8FEA25419A9999394C185A416666666694EA25410000002047185A416666666697EA2541CDCCCC4C3F185A419A99999996EA25416666660634185A41CDCCCCCC96EA25419A9999792A185A41CDCCCCCC96EA25410000004022185A419A99999997EA25419A9999D915185A416666666697EA25410000002015185A419A99999998EA25419A9999B911185A41333333339BEA2541333333330A185A4166666666A1EA25416666660601185A4133333333AFEA25419A999919F1175A4166666666BDEA2541000000E0DE175A419A999999BEEA254133333393D9175A4133333333C0EA2541CDCCCC2CD3175A4133333333C1EA254100000020CF175A4133333333C1EA2541333333B3CE175A4100000000C2EA2541CDCCCCECCB175A4100000000C5EA254133333313C2175A41CDCCCCCCC6EA2541000000C0B8175A4100000000CDEA254100000080A2175A41CDCCCCCCD3EA25416666660699175A419A999999DBEA25410000002092175A4166666666E4EA2541333333138D175A419A9999991EEB2541333333D373175A416666666621EB25413333333372175A41666666663EEB2541CDCCCCEC64175A41CDCCCCCC4AEB2541CDCCCC0C5D175A410000000055EB25419A9999F953175A410000000061EB2541CDCCCC8C47175A410000000063EB25410000006045175A41CDCCCCCC55EB25416666664645175A419A999999B3EA25416666664651175A410000000030EA25416666662667175A41000000001FEA25410000006066175A419A99999908EA25419A99995965175A4100000000CFE92541CDCCCCAC62175A4100000000D9E92541666666A65E175A419A999999FFE925419A9999794C175A419A9999991EEA2541666666263B175A41666666663CEA2541CDCCCC8C29175A41000000004EEA2541CDCCCC4C1D175A410000000055EA2541666666061A175A41000000007FEA25419A9999B9FE165A41CDCCCCCC7BEA2541CDCCCC6CFF165A41CDCCCCCC6BEA2541000000C001175A41666666665DEA25416666664603175A4100000000B4E92541666666460F175A419A9999996BE925416666660614175A41000000004AE92541000000C015175A41CDCCCCCC29E92541CDCCCCEC16175A41CDCCCCCC01E925413333333318175A41CDCCCCCCCFE725419A9999F920175A4133333333F7E625419A99997926175A41CDCCCCCC9CE625410000002028175A410000000044E625410000006029175A41CDCCCCCCE7E52541000000402A175A419A99999990E52541CDCCCCAC2A175A413333333339E52541000000802A175A416666666607E52541CDCCCC2C2A175A4166666666E1E425410000006028175A419A999999CDE425419A99997927175A4133333333C8E425419A99993927175A41CDCCCCCCC6E425416666662627175A41CDCCCCCCC4E425413333331327175A416666666698E425413333337325175A410000000078E425416666668624175A41CDCCCCCC53E42541CDCCCCEC23175A419A99999946E425416666660624175A419A99999934E425413333333324175A410000000017E425419A99999924175A4133333333EBE325419A99995925175A41CDCCCCCCCAE325410000000026175A41CDCCCCCCBDE325410000004026175A41CDCCCCCC68E325410000004027175A41CDCCCCCC26E325419A99997928175A41CDCCCCCCEAE225419A99999929175A4133333333D8E22541CDCCCC2C2A175A4100000000B1E225419A9999592B175A413333333347E225419A9999992E175A41CDCCCCCC96E125410000004034175A419A9999996AE12541CDCCCC8C35175A410000000069E125419A99999935175A41	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	01010000206A080000D79BDA765AE72541666666267E185A41	770330000	Z	Bezalles	7703300	77033	77	11	3
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	01060000206A080000010000000103000000010000000C01000033333333D7D32441666666666E0E5A416666666635D62441CDCCCC2CB00E5A41CDCCCCCC51D7244100000080CE0E5A4166666666DED72441666666A6DE0E5A410000000096D8244133333373C80E5A41CDCCCCCCF7D92441666666069D0E5A419A9999990DDE2441CDCCCC8CEE0E5A4100000000FFDD2441666666E6F80E5A4100000000F2DD24419A9999990A0F5A413333333384E1244166666626390F5A419A99999939E2244166666646D70E5A419A9999993EE22441CDCCCCCCD50E5A419A999999E1E2244100000000DE0E5A4133333333EBE22441CDCCCC0CD90E5A41CDCCCCCCC3E324419A9999595E0E5A4133333333CDE324419A999979580E5A413333333346E42441000000C0610E5A41CDCCCCCC73E424419A9999D9630E5A4166666666FCE524419A999959710E5A419A9999995CE6244100000000720E5A41333333339FE6244166666626710E5A419A9999991AE72441CDCCCC8C600E5A41CDCCCCCC4DE72441333333D35C0E5A41000000001EE82441333333D3530E5A419A99999973E82441CDCCCCAC510E5A41000000000FE924419A9999B9500E5A41CDCCCCCC7CE9244100000020510E5A419A999999E5E92441333333F3540E5A41CDCCCCCC82EA244133333333560E5A419A99999910EB24419A999959580E5A416666666643EB2441666666A6460E5A416666666661EB2441CDCCCCAC3E0E5A41CDCCCCCC71EB244133333373360E5A419A99999982EB244100000080230E5A419A9999999CEB2441CDCCCCAC210E5A4133333333D0EB244100000000220E5A41CDCCCCCC8DEC2441666666E6170E5A41333333330CED2441CDCCCC8C120E5A413333333375ED24419A9999390D0E5A4100000000E8ED2441CDCCCC2C0C0E5A41CDCCCCCC84ED2441CDCCCCECEE0D5A41CDCCCCCC77ED2441CDCCCC6CE70D5A416666666685ED244133333313E20D5A419A999999DCED24419A999939DB0D5A416666666633EE244133333313D10D5A419A9999998DEE2441333333B3C40D5A4100000000D5EE2441000000E0BC0D5A41CDCCCCCC01EF2441666666C6B20D5A410000000036EF2441666666269B0D5A413333333356EF24419A999919930D5A410000000095EF24419A999959880D5A41CDCCCCCCECEF244133333393710D5A419A99999931F0244133333333540D5A419A99999947F02441000000004D0D5A419A999999AEF02441666666263A0D5A419A999999EFF02441000000A02F0D5A419A9999999BF12441CDCCCC2C1C0D5A41333333330DF22441000000E0130D5A419A9999992BF2244133333393100D5A419A99999980F22441666666C60C0D5A419A9999993AF3244166666646070D5A4166666666B0F3244166666606060D5A4133333333D9F32441000000A0040D5A410000000047F4244166666666FE0C5A410000000071F4244100000020FD0C5A419A999999DCF42441CDCCCC0C020D5A41CDCCCCCCACF52441666666A6080D5A416666666636F62441000000A0100D5A41333333338FF62441CDCCCC4C190D5A41CDCCCCCCFBF624419A999959210D5A410000000072F724419A9999D92C0D5A4133333333A8F72441CDCCCC2C300D5A41000000004DF8244100000020350D5A4133333333C6F82441000000E0320D5A416666666612F9244166666626240D5A4166666666EFF92441CDCCCC0C010D5A416666666628FA2441CDCCCCACDF0C5A41666666669BFA244166666646CA0C5A4100000000B3FA24419A9999B9C20C5A4133333333DDFA2441333333B3AE0C5A41CDCCCCCC29FB2441000000E09A0C5A416666666659FB244100000000940C5A41000000007CFB244100000020910C5A4133333333D2FB2441CDCCCCAC8D0C5A410000000075FC244166666626850C5A4166666666B1FC2441000000C0830C5A416666666688FD2441666666267A0C5A41CDCCCCCCE6FD2441333333F3760C5A4100000000F0FD24419A999939730C5A41666666666BFE2441666666264E0C5A41000000009BFE2441CDCCCC0C410C5A41CDCCCCCCD9FE244100000000320C5A41333333336AFF2441333333B3120C5A416666666655FF2441CDCCCC4C110C5A419A999999E1FD2441CDCCCC0CE80B5A4133333333D8FC24419A9999B9CB0B5A4100000000E2F92441000000E0770B5A41000000007FF72441CDCCCC2C350B5A41CDCCCCCCE5F5244100000040080B5A419A999999F4F424419A999919EE0A5A419A999999CCF3244133333373CD0A5A419A99999934F32441666666A6BD0A5A419A99999934F32441333333B3C20A5A419A99999919F3244133333393C90A5A416666666617F3244133333373CE0A5A4100000000E8F2244133333393D90A5A419A9999999EF224419A999999E80A5A416666666645F22441CDCCCCAC030B5A41CDCCCCCCDFF124419A9999F91E0B5A41CDCCCCCCA7F22441333333F3300B5A41666666665FF12441CDCCCC4C4D0B5A410000000018F1244100000020420B5A4133333333ECF024419A9999D93D0B5A419A99999936F02441333333F3310B5A4133333333FCEF2441CDCCCC6C300B5A419A9999997AEF24419A9999F9320B5A41CDCCCCCC75EF2441CDCCCC8C410B5A41CDCCCCCCD9EC244166666606360B5A410000000046ED2441000000E00E0B5A419A99999981EC2441000000C0060B5A41CDCCCCCC3CEC2441333333F3040B5A41CDCCCCCC2BEC2441000000400C0B5A41CDCCCCCC06EC24419A999979130B5A419A999999A8EB2441000000E01C0B5A41CDCCCCCC1EEB24419A999919270B5A41CDCCCCCCB6EA2441333333D32D0B5A4100000000E4E9244166666686380B5A419A99999938E92441CDCCCCEC410B5A419A9999998DE82441666666064C0B5A4100000000EDE72441CDCCCC2C580B5A419A99999952E724419A999939670B5A416666666608E72441666666266F0B5A41CDCCCCCCFDE62441000000606E0B5A4133333333B9E62441333333D3740B5A41CDCCCCCC71E524419A999939970B5A41000000002FE4244166666606700B5A4133333333DEE324419A9999B9760B5A4133333333C6E32441666666667B0B5A419A9999998FE324419A999999810B5A4166666666D2E22441333333538F0B5A413333333374E224419A9999D9920B5A413333333343E2244100000020930B5A419A999999BDE124419A9999D9980B5A4166666666A5E1244100000020A00B5A41333333335AE12441000000E0A60B5A419A9999994AE124419A9999D9B10B5A419A9999994EE1244166666666B90B5A419A9999992AE1244166666646BA0B5A419A999999E2E02441CDCCCC4CB50B5A419A9999999BE024419A9999B9B60B5A41333333335DE02441CDCCCC0CBB0B5A413333333358E0244133333393BE0B5A413333333366E02441CDCCCC4CC90B5A41666666664CE0244100000040CD0B5A41666666661AE02441CDCCCC8CCD0B5A419A99999956DF2441CDCCCCACCC0B5A410000000001DF24419A999999C70B5A4100000000C6DE244166666606C70B5A419A99999919DE2441CDCCCCACC90B5A4133333333B7DD244100000060C90B5A41666666669EDD244133333353CA0B5A419A9999996CDD2441000000A0C60B5A419A99999959DD244133333313C10B5A41CDCCCCCC2DDC244166666666AF0B5A41CDCCCCCC13DC2441CDCCCC4CB20B5A416666666624DB2441666666C6D60B5A410000000000DB244100000020D90B5A4100000000A4DA24419A999919D70B5A419A9999997BDA2441CDCCCC6CDA0B5A413333333375DA244133333373E10B5A41CDCCCCCC53DA244100000020E40B5A413333333322DA24419A999999E40B5A410000000013DA24419A999939E70B5A41CDCCCCCC2CDA244166666686EC0B5A419A9999990EDA2441666666A6F40B5A410000000015DA244133333373F80B5A410000000003DA2441CDCCCC8CFD0B5A419A999999AED9244100000080040C5A413333333385D924419A999919040C5A419A99999954D9244133333313FF0B5A419A99999923D9244166666606030C5A410000000016D92441333333D3000C5A4100000000D4D82441CDCCCCACFF0B5A4100000000A3D8244133333353FB0B5A419A9999999AD824419A9999D9F60B5A41666666663ED824419A999939F20B5A416666666619D82441CDCCCCECF10B5A4133333333E8D7244166666686F40B5A4166666666CCD72441333333F3F20B5A41CDCCCCCC8DD7244133333393F40B5A413333333374D724419A999959FA0B5A41CDCCCCCC63D7244133333313050C5A416666666661D72441CDCCCC0C130C5A419A9999994AD7244100000040170C5A416666666621D7244133333353180C5A4133333333FFD6244100000040230C5A4133333333DDD6244166666646220C5A41666666665ED62441000000E02C0C5A419A9999990FD62441666666662C0C5A4100000000DBD524419A9999792F0C5A4133333333B2D524419A999959260C5A41CDCCCCCC96D52441666666C6290C5A41333333339DD52441CDCCCC0C310C5A41CDCCCCCC3DD5244100000040370C5A410000000021D52441000000C03C0C5A4166666666F2D42441333333D33A0C5A4133333333E3D424419A9999B93F0C5A41000000009CD424419A999999380C5A41333333333FD42441CDCCCC6C3C0C5A41666666661CD42441333333533F0C5A419A999999D7D32441CDCCCC0C380C5A4133333333C0D32441000000A0380C5A413333333372D32441666666A6320C5A419A99999940D3244100000080370C5A413333333324D32441CDCCCC8C360C5A4166666666F6D22441000000C03A0C5A4133333333E9D224419A9999B93F0C5A4133333333B8D2244166666626430C5A419A999999B0D2244133333373480C5A419A99999964D22441666666E6490C5A413333333316D2244166666626510C5A41CDCCCCCCEAD124419A9999394A0C5A4100000000E6D124419A9999F9450C5A4166666666B3D1244133333353420C5A41CDCCCCCC79D12441000000A0380C5A410000000056D1244100000080360C5A41CDCCCCCC41D12441CDCCCC8C3A0C5A41333333332CD12441000000A0390C5A41CDCCCCCCF4D02441333333B33E0C5A4166666666E3D02441CDCCCC6C3E0C5A4100000000A6D0244133333313450C5A41666666667AD02441000000004C0C5A41CDCCCCCC52D024419A9999D94E0C5A41CDCCCCCC25D02441333333F34E0C5A4100000000BDCF2441CDCCCCCC4A0C5A413333333339CF24419A999999490C5A4166666666FFCE2441000000404A0C5A4166666666D8CE2441CDCCCC2C4E0C5A41CDCCCCCC17CF24419A9999F94D0C5A416666666682CF2441333333D3500C5A4100000000F8CF2441666666E65A0C5A419A9999992BD0244166666646640C5A419A99999943D02441000000606F0C5A41CDCCCCCCE4D024419A999939950C5A41CDCCCCCCD4D12441CDCCCCACBC0C5A41CDCCCCCCD2D1244133333313C30C5A41CDCCCCCCACD1244100000040D10C5A41CDCCCCCC41D12441000000A0E90C5A413333333325D12441666666A6ED0C5A419A999999EED024419A9999B9F10C5A41CDCCCCCCDDD02441666666E6F40C5A410000000038D124419A999979FA0C5A41CDCCCCCC99D22441000000C0130D5A4100000000E2D2244133333353160D5A413333333347D424419A9999F91F0D5A4166666666CCD5244133333313270D5A41CDCCCCCCA4D52441333333F3430D5A41666666668DD524419A999959650D5A41333333334CD5244100000000890D5A41CDCCCCCC87D42441666666E6850D5A41CDCCCCCCFAD3244100000060810D5A4166666666C1D3244166666626A20D5A4133333333CCD3244166666686A20D5A413333333306D3244100000040EF0D5A41CDCCCCCCADD4244100000020010E5A41000000009FD6244166666686160E5A4133333333D7D32441666666666E0E5A4133333333D7D32441666666666E0E5A41	01010000206A080000A2F963AAA2E52441333333F3FB0C5A41	770340000	Z	Blandy	7703400	77034	77	11	14
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