SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep78;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep78 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep78','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep78','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep78','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep78"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A0800000A1D735FCDCA22419A999999180A5A41	780030000	Z	Ablis	7800300	78003	78	11	26
01060000206A0800000100000001030000000100000062000000CDCCCCCC75422341333333D301385A41CDCCCCCC8C422341666666C602385A419A999999944223410000004004385A41CDCCCCCCAB422341CDCCCC0C04385A4133333333B2422341CDCCCC0C06385A4166666666C54223419A9999190C385A419A999999E2422341CDCCCC4C15385A4100000000F2422341000000801A385A41000000001E432341666666A629385A419A999999814323419A9999794C385A4166666666CE432341333333D368385A4133333333E84323413333331368385A4100000000DA4323410000008064385A41CDCCCCCCD64323419A99997962385A4100000000F5432341333333B34D385A419A999999FC432341CDCCCC6C49385A413333333302442341CDCCCC8C48385A413333333308442341333333B347385A41333333331C4423419A99999946385A410000000030442341666666C646385A41CDCCCCCC56442341666666A649385A419A99999962442341666666A649385A41666666666D4423419A99993949385A41CDCCCCCC8C442341333333F347385A4100000000A44423416666660652385A4133333333BD442341666666E65C385A4100000000C94423419A9999F961385A4166666666CF442341000000E064385A419A999999D04423419A9999B966385A419A999999CE442341CDCCCCAC68385A4166666666CD442341000000806A385A4100000000CA442341666666C66C385A41CDCCCCCC00452341000000806F385A4133333333194523410000000071385A419A9999991C4523413333333371385A41CDCCCCCCA14523419A9999D973385A4133333333BA4523410000008074385A4100000000C34523416666668674385A4133333333CB4523416666664674385A4133333333D54523419A9999B973385A419A999999E1452341666666E672385A413333333303462341333333F370385A419A99999920462341CDCCCC4C6F385A410000000035462341000000806E385A419A9999993B4623410000002071385A41000000005C462341666666067C385A41333333336D4623410000006081385A41CDCCCCCC884623410000000080385A41666666664B472341333333F377385A41000000003D4723416666668670385A419A99999930472341333333F368385A41333333332C472341CDCCCC4C66385A41CDCCCCCC214723416666660660385A41CDCCCCCC204723419A9999795F385A410000000012472341CDCCCCCC56385A413333333303472341666666A64E385A419A999999F54623410000002049385A41CDCCCCCCF1462341CDCCCC8C47385A4100000000A6462341CDCCCC2C31385A413333333387462341CDCCCC0C28385A413333333361462341333333B31E385A416666666622462341CDCCCCAC10385A41CDCCCCCCE54523416666666603385A4133333333BA4523419A9999F9FA375A419A999999AA452341CDCCCCACF7375A41000000008D452341CDCCCC6CF1375A41CDCCCCCC82452341CDCCCC8CEF375A419A9999995C4523419A999979E8375A41000000000D45234133333393DB375A41CDCCCCCCE8442341666666C6D5375A4166666666E6442341000000E0D5375A419A999999DE44234166666626D6375A4133333333D644234133333313D6375A419A999999D0442341CDCCCCACD5375A4100000000CD442341CDCCCC2CD5375A419A999999CB4423419A999979D4375A41CDCCCCCCCB44234100000000D4375A41CDCCCCCCCB4423419A999979D3375A41CDCCCCCCCE4423419A9999D9D2375A41CDCCCCCCCF442341333333B3D2375A4100000000B144234100000080CD375A41666666668744234133333313C7375A41666666666E442341CDCCCC6CC2375A419A9999995144234133333353BC375A4133333333224423419A999919B1375A41333333331844234100000060AE375A419A9999990E44234100000000AB375A419A9999990944234100000080A8375A419A999999F5432341000000C0A9375A41000000002943234100000080B6375A419A999999F942234133333353BA375A419A999999F742234133333393BB375A41CDCCCCCCEF42234100000020C1375A4100000000D2422341333333D3D6375A4166666666C0422341CDCCCCCCDF375A4166666666B0422341CDCCCC6CE9375A41000000009F422341CDCCCCCCF1375A41CDCCCCCC75422341333333D301385A41	01060000206A0800000100000001030000000100000023000000CDCCCCCC75422341333333D301385A41CDCCCCCCAB422341CDCCCC0C04385A419A999999E2422341CDCCCC4C15385A419A999999814323419A9999794C385A4166666666CE432341333333D368385A4133333333E84323413333331368385A41CDCCCCCCD64323419A99997962385A419A999999FC432341CDCCCC6C49385A41333333331C4423419A99999946385A41CDCCCCCC56442341666666A649385A41CDCCCCCC8C442341333333F347385A4166666666CF442341000000E064385A4100000000CA442341666666C66C385A419A9999991C4523413333333371385A4133333333CB4523416666664674385A410000000035462341000000806E385A41333333336D4623410000006081385A41666666664B472341333333F377385A413333333303472341666666A64E385A41CDCCCCCCF1462341CDCCCC8C47385A413333333387462341CDCCCC0C28385A413333333361462341333333B31E385A41CDCCCCCCE54523416666666603385A419A9999995C4523419A999979E8375A41CDCCCCCCE8442341666666C6D5375A41666666668744234133333313C7375A419A9999995144234133333353BC375A41333333331844234100000060AE375A419A9999990944234100000080A8375A41000000002943234100000080B6375A419A999999F942234133333353BA375A4100000000D2422341333333D3D6375A41000000009F422341CDCCCCCCF1375A41CDCCCCCC75422341333333D301385A41CDCCCCCC75422341333333D301385A41	01010000206A080000D426ED0184442341CDCCCCFC12385A41	780050108	H	Plantes d'Ennemont	7800501	78005	78	11	0
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	01060000206A08000001000000010300000001000000250000009A999999E8432341333333939D375A41333333331844234100000060AE375A419A9999995144234133333353BC375A41666666668744234133333313C7375A41CDCCCCCCE8442341666666C6D5375A419A9999995C4523419A999979E8375A41CDCCCCCCE54523416666666603385A413333333361462341333333B31E385A413333333387462341CDCCCC0C28385A41CDCCCCCCF1462341CDCCCC8C47385A413333333303472341666666A64E385A41666666664B472341333333F377385A41333333336D4623410000006081385A41CDCCCCCCF846234133333313B4385A4100000000CD47234166666666A8385A41666666665C482341000000209F385A41CDCCCCCC854823419A9999F999385A4133333333B04823416666668690385A410000000028492341333333936F385A4133333333AE4923419A99995949385A41CDCCCCCCDE4923413333337337385A41666666660D4A23413333339318385A4133333333854A2341666666A6B6375A4133333333AF4A2341000000208E375A41CDCCCCCCB54A2341CDCCCC0C84375A4100000000F04923419A9999B958375A4166666666AA492341CDCCCCAC48375A4100000000614923413333331335375A41666666665D4923410000008032375A413333333304492341CDCCCC0C2B375A413333333399482341333333F325375A41333333335A482341000000602C375A41CDCCCCCC394723413333333347375A4133333333514523413333333377375A419A99999960442341CDCCCC0C90375A419A999999E8432341333333939D375A419A999999E8432341333333939D375A41	01010000206A08000010347829DA47234134333303EC375A41	780050109	H	Chêne Feuillu	7800501	78005	78	11	1
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	01060000206A0800000100000001030000000100000099000000000000009A4C2341CDCCCCEC603B5A4100000000394D2341666666E6673B5A4100000000594E23419A9999B9713B5A4166666666F24E2341333333D3753B5A4100000000674F234166666606783B5A4100000000EA4F2341000000E07E3B5A4133333333D950234133333353903B5A4166666666B5512341000000A0943B5A4100000000E1512341000000E0983B5A419A999999C3512341CDCCCC6CA53B5A419A999999D6512341000000A0A83B5A419A9999993D5223419A9999D9A63B5A41000000002B53234166666666A73B5A4166666666D7542341666666A6AA3B5A41000000004D562341CDCCCC2CAF3B5A41333333332158234166666646B43B5A419A99999923592341CDCCCC6CB63B5A416666666687592341333333F3B73B5A41CDCCCCCC9C5A234166666666B93B5A4100000000615C2341000000E0B73B5A41000000002C5E2341333333D3C03B5A41333333334F5F234166666646C13B5A410000000011602341CDCCCCECC53B5A41000000003861234100000060B73B5A41666666666A63234166666686BC3B5A41666666665A642341CDCCCC0CBD3B5A4166666666436523419A9999F9C03B5A419A999999B765234133333393BF3B5A416666666639662341666666A6BB3B5A4133333333BA6623419A999999B83B5A4133333333D56823419A999979B63B5A41CDCCCCCC996923419A9999B9C33B5A4100000000F6692341333333B3BE3B5A41CDCCCCCC426A2341CDCCCCCCBB3B5A41CDCCCCCCA26A234100000080B93B5A4100000000666B234166666646B63B5A41CDCCCCCC886C23419A999999B33B5A419A9999992D6D234100000060B33B5A41CDCCCCCC646E234166666626AD3B5A4166666666D56E2341666666C6A93B5A41CDCCCCCC456F2341CDCCCCCCA73B5A419A9999991C71234133333393A63B5A419A999999F4712341000000E0A13B5A416666666689722341666666A69C3B5A41CDCCCCCC9073234133333313903B5A41333333339474234166666626823B5A416666666636752341000000E0783B5A4133333333C375234133333353733B5A41666666669C7623419A9999F96F3B5A419A999999FE762341333333B3713B5A41CDCCCCCCFA7923419A999999583B5A41CDCCCCCC317A23419A9999594A3B5A41CDCCCCCC557A234133333333453B5A41CDCCCCCC737B2341333333D3313B5A4100000000F97B2341333333D32A3B5A41CDCCCCCCB27C2341CDCCCC8C1C3B5A419A9999994F7D2341666666860E3B5A419A999999F47D23419A9999D9053B5A4166666666C27E23419A9999D9FD3A5A4100000000157F23419A999939F73A5A41333333339D7F2341333333B3E73A5A419A999999C57F23419A999959DF3A5A4100000000FA7F2341666666A6D13A5A41333333333780234100000000C83A5A41CDCCCCCC7C812341CDCCCC8CA13A5A4100000000108223419A999959933A5A416666666666822341000000A08D3A5A4133333333738223419A9999F9883A5A419A99999901832341000000C0683A5A419A9999998D8323419A9999394D3A5A41000000003E84234166666606303A5A4100000000BF842341666666A6153A5A41000000000F85234166666606073A5A41000000003A852341CDCCCC8CF4395A41CDCCCCCC2C852341666666C6D3395A419A9999993D852341666666E6C6395A41CDCCCCCC7F852341000000C0A2395A4166666666AA852341CDCCCC6C95395A4100000000EB852341CDCCCC6C88395A413333333311862341000000E078395A410000000018862341CDCCCC4C6B395A41CDCCCCCC16862341666666865D395A41CDCCCCCC4C862341CDCCCC0C4C395A41CDCCCCCC8E8623416666668640395A419A99999927872341CDCCCC0C36395A413333333304872341CDCCCC2C2C395A41CDCCCCCCA4862341333333B3F8385A419A9999990D86234100000040F9385A41333333336585234133333313FB385A419A999999D0832341CDCCCC4CFE385A41CDCCCCCC61832341333333F34D395A41CDCCCCCCC58223419A999939BC395A41CDCCCCCC1F822341000000800F3A5A41CDCCCCCCE17F23419A9999F9623A5A41CDCCCCCC597E2341CDCCCC6C903A5A41CDCCCCCC4C7E2341CDCCCC0C913A5A4166666666977D234133333353A43A5A4100000000837C2341CDCCCC6CBF3A5A4133333333207C23419A999979C93A5A41333333339C7B2341333333D3D53A5A419A9999996179234100000060FE3A5A41CDCCCCCC1778234166666626153B5A413333333331772341666666C6233B5A41CDCCCCCC2F762341CDCCCC0C333B5A41CDCCCCCC1F752341333333F3413B5A410000000023742341666666E64E3B5A419A999999407323419A9999B95B3B5A413333333387722341666666C6643B5A4166666666117223419A999999683B5A416666666678712341666666666C3B5A41000000002D6D2341000000407D3B5A41CDCCCCCC1B6C2341000000E0803B5A4133333333366A23419A999939853B5A413333333334682341666666668A3B5A4166666666FE662341CDCCCC4C8D3B5A41000000004E6623419A9999598D3B5A4100000000AE65234100000060873B5A419A999999586223419A999959703B5A41333333333E6223419A9999D9393B5A4100000000276223419A999959133B5A419A999999DE61234133333313103B5A419A999999EF60234100000060073B5A41CDCCCCCC835F2341CDCCCC6CF53A5A41333333336C5F2341CDCCCC4CF63A5A41333333336C592341666666A6233B5A41CDCCCCCCE7512341CDCCCCEC5F3B5A419A99999950512341CDCCCC6C5B3B5A41333333335551234133333333583B5A4166666666DB512341333333731D3B5A416666666612522341CDCCCC2C093B5A419A99999934522341666666C6F63A5A41CDCCCCCC6652234100000000E03A5A41CDCCCCCC985323419A999979613A5A419A999999FF53234133333373383A5A419A999999BC532341CDCCCCEC323A5A4133333333615223419A999959133A5A4100000000F4502341000000C0F1395A4100000000884F2341666666E6CA395A4166666666F24E2341CDCCCC6CBB395A419A9999993C4E234100000080A6395A4100000000474D2341CDCCCC0C85395A41333333332C4D23416666660682395A419A999999524D2341333333D3063A5A41000000006E4D2341CDCCCC8C6A3A5A41666666667F4D2341333333B3A23A5A4100000000834D234133333313C03A5A41666666667E4D23419A999919D13A5A4166666666694D234100000060F03A5A419A999999524D23419A9999D9053B5A41000000003E4D2341666666A6143B5A41666666660B4D2341CDCCCCCC313B5A41000000009A4C2341CDCCCCEC603B5A41000000009A4C2341CDCCCCEC603B5A41	01010000206A0800007E18220087502341000000805D3A5A41	780050101	A	Gare	7800501	78005	78	11	4
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	01010000206A0800002AA951C6A94823419A999909603A5A41	780050102	A	Le Barrage	7800501	78005	78	11	1
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	01060000206A080000010000000103000000010000001C0000006666666644452341666666E659395A41333333336C452341666666E65D395A41CDCCCCCC6A462341666666E67D395A4133333333B84623413333331387395A4166666666CE4623419A9999D9DC395A4166666666E846234100000060DF395A419A9999999C4923419A9999991A3A5A419A999999854A2341333333F32E3A5A4100000000C94A2341CDCCCC2C343A5A4133333333A14C2341CDCCCCEC5C3A5A419A9999996F4D234100000040703A5A41666666666A4D234166666686593A5A41333333332C4D23416666660682395A419A9999996C4C2341666666A666395A41CDCCCCCC404C23413333337369395A4166666666244C23419A9999D96D395A4100000000D14B2341CDCCCCAC6C395A4166666666BD492341666666E670395A419A9999999E472341666666C62A395A413333333385472341666666662B395A41333333331B472341CDCCCCAC36395A41CDCCCCCC9F462341CDCCCCEC44395A41CDCCCCCC4A462341666666264C395A4100000000FC4523410000002051395A413333333381452341666666A655395A41333333335B452341CDCCCC0C56395A416666666644452341666666E659395A416666666644452341666666E659395A41	01010000206A0800009FF1EE6C064A234133333373CD395A41	780050103	H	Champs de Villars	7800501	78005	78	11	1
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	01060000206A08000001000000010300000001000000120000009A9999999C4723419A9999B926395A419A9999999E472341666666C62A395A4166666666BD492341666666E670395A4100000000D14B2341CDCCCCAC6C395A4166666666244C23419A9999D96D395A41CDCCCCCC404C23413333337369395A419A9999996C4C2341666666A666395A4100000000FD4B23419A9999194C395A4133333333E24B23419A9999F94E395A4166666666BA4B23419A9999F946395A41CDCCCCCCFE4A23419A99999927395A4100000000A34A2341666666C619395A41333333336749234166666686ED385A4166666666CF482341CDCCCCEC00395A419A9999992B482341666666260B395A4133333333034823410000000010395A419A9999999C4723419A9999B926395A419A9999999C4723419A9999B926395A41	01010000206A0800006A2AFCFE794923419A9999B92F395A41	780050104	H	Thorez	7800501	78005	78	11	0
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	01010000206A08000020A4B7D474412341333333A3D8385A41	780050105	H	Porte de Seine	7800501	78005	78	11	2
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	01060000206A080000010000000103000000010000001D000000000000008B442341333333D39B385A41000000009C44234133333333A7385A419A999999B84423419A999979AA385A41CDCCCCCCEF44234133333353B8385A41666666668745234133333393D2385A4133333333F9452341CDCCCCCCE7385A41CDCCCCCC41472341666666661C395A419A9999999E472341666666C62A395A419A9999999C4723419A9999B926395A4133333333034823410000000010395A419A9999992B482341666666260B395A4166666666CF482341CDCCCCEC00395A41333333336749234166666686ED385A41333333335E49234133333393EB385A4100000000DE482341CDCCCC2CDD385A41333333336748234100000020C9385A4133333333DB48234100000080B8385A419A999999CB482341CDCCCCCCAF385A41CDCCCCCC56482341CDCCCCCCA7385A410000000037482341333333D3A1385A4100000000CD47234166666666A8385A41CDCCCCCCF846234133333313B4385A4166666666834623410000002089385A410000000035462341000000806E385A4133333333CB4523416666664674385A419A9999991C4523413333333371385A4100000000CA442341666666C66C385A41000000008B442341333333D39B385A41000000008B442341333333D39B385A41	01010000206A080000A621C6F2F04623419A999999CC385A41	780050106	H	Centre Ville	7800501	78005	78	11	0
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	01060000206A08000001000000010300000001000000250000000000000037482341333333D3A1385A41CDCCCCCC56482341CDCCCCCCA7385A419A999999CB482341CDCCCCCCAF385A4133333333DB48234100000080B8385A41333333336748234100000020C9385A4100000000DE482341CDCCCC2CDD385A41333333335E49234133333393EB385A41333333336749234166666686ED385A4100000000A34A2341666666C619395A41CDCCCCCCFE4A23419A99999927395A4166666666BA4B23419A9999F946395A4133333333E24B23419A9999F94E395A41CDCCCCCCF84B2341CDCCCC8C4C395A41000000006B4B23416666666635395A4133333333F74A23410000006021395A41CDCCCCCCF34A23419A9999391F395A41666666661C4B234133333393C6385A41CDCCCCCC1D4B23419A999979BA385A419A9999992E4B2341666666C6B8385A4166666666694B2341666666669B385A41CDCCCCCCB44B23419A99991972385A41CDCCCCCCF14B2341666666C635385A4133333333FA4B23419A99993926385A41CDCCCCCC4B4C2341CDCCCCECDF375A4166666666344B23419A999939A1375A419A9999991D4B23419A9999199B375A41CDCCCCCCB54A2341CDCCCC0C84375A4133333333AF4A2341000000208E375A4133333333854A2341666666A6B6375A41666666660D4A23413333339318385A41CDCCCCCCDE4923413333337337385A4133333333AE4923419A99995949385A410000000028492341333333936F385A4133333333B04823416666668690385A41CDCCCCCC854823419A9999F999385A410000000037482341333333D3A1385A410000000037482341333333D3A1385A41	01010000206A08000082BF8A137F4A23419A99991969385A41	780050107	H	Montsouris	7800501	78005	78	11	0
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	01010000206A080000F72642F6555C224100000070121F5A41	780060000	Z	Adainville	7800600	78006	78	11	10
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	01010000206A0800000E3D8810C62A23419A99993977325A41	780070000	Z	Aigremont	7800700	78007	78	11	3
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	01010000206A0800009EE0A7886CE122413333332347035A41	780090000	Z	Allainville	7800900	78009	78	11	16
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	01010000206A080000A03726EEABF22241CCCCCC5CC7335A41	780100000	Z	Les Alluets-le-Roi	7801000	78010	78	11	7
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	01010000206A080000D22C991374B2224100000080F4305A41	780130000	Z	Andelu	7801300	78013	78	11	4
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	01010000206A08000039B07CCE053E234166666616B33A5A41	780150102	H	Les Coteaux	7801501	78015	78	11	1
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	01060000206A080000010000000103000000010000002F0000009A999999204023419A999979BE3B5A419A999999364023419A999939C13B5A41000000003F40234100000080C83B5A41CDCCCCCC3E4023419A999919D63B5A416666666646402341666666C6DA3B5A41CDCCCCCC8E402341000000C0EA3B5A41CDCCCCCC56412341000000A0D73B5A419A99999961412341000000E0DB3B5A41333333338441234166666666DF3B5A41666666661A422341CDCCCCCCDE3B5A41666666662942234100000020EA3B5A419A9999993942234133333333FD3B5A4100000000394223419A9999F9043C5A41666666662A422341333333931A3C5A41CDCCCCCC75422341CDCCCC4C1C3C5A4166666666F7422341000000E01C3C5A4100000000B04423419A999979123C5A4166666666B9442341666666E60E3C5A41CDCCCCCC6846234100000000043C5A41666666663346234100000000013C5A41000000007E45234133333353F33B5A4100000000054523419A999919E83B5A41CDCCCCCC99442341666666A6DB3B5A41666666662944234100000080CC3B5A4100000000C743234166666606BC3B5A41333333338A4323419A999999AF3B5A41CDCCCCCC5C4323419A999939A43B5A41CDCCCCCC174323419A9999198F3B5A4166666666F542234166666666823B5A419A999999D2412341333333531C3B5A413333333391412341000000C01F3B5A4133333333774123419A9999192C3B5A41666666665A412341000000A0333B5A4100000000964123419A999919473B5A4166666666C741234100000080523B5A419A99999946412341666666A6583B5A41CDCCCCCC43412341CDCCCC2C5C3B5A419A99999963412341CDCCCCCC6E3B5A410000000068412341CDCCCC4C783B5A41CDCCCCCC28412341CDCCCC0C793B5A41CDCCCCCC04412341000000009E3B5A41CDCCCCCCF8402341CDCCCCCCA03B5A419A999999D04023419A999999A13B5A4100000000CA402341CDCCCC6CBD3B5A41000000006F40234133333393B93B5A419A999999204023419A999979BE3B5A419A999999204023419A999979BE3B5A41	01010000206A0800006365BC1125422341000000309D3B5A41	780150103	H	Les Charvaux	7801501	78015	78	11	0
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	01010000206A0800009C45DF2F8A3923419A9999698E3B5A41	780150101	H	L'Hautil	7801501	78015	78	11	3
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	01060000206A080000010000000103000000010000003900000033333333A93D2341333333D3573A5A419A9999997F3E2341666666066F3A5A4100000000363F23419A999999863A5A419A9999998A3F2341CDCCCCCC923A5A4166666666E73F234166666686A13A5A41CDCCCCCC33402341CDCCCCECAE3A5A41CDCCCCCC7D4023419A999959BD3A5A4100000000024123419A999939DB3A5A413333333368412341CDCCCCCCF73A5A4100000000AC412341666666C60E3B5A4166666666F542234166666666823B5A41CDCCCCCC174323419A9999198F3B5A41CDCCCCCC5C4323419A999939A43B5A41333333338A4323419A999999AF3B5A4100000000C743234166666606BC3B5A41666666662944234100000080CC3B5A41CDCCCCCC99442341666666A6DB3B5A4100000000054523419A999919E83B5A41000000007E45234133333353F33B5A41666666663346234100000000013C5A41CDCCCCCC6846234100000000043C5A419A9999998846234133333333033C5A41CDCCCCCC8A462341333333B3F53B5A416666666602472341CDCCCC8CF23B5A41000000000047234166666626EE3B5A41CDCCCCCCC7462341666666C6E43B5A419A999999DA45234100000020A63B5A4133333333C0452341666666669D3B5A41666666666945234133333313873B5A41CDCCCCCC414523419A9999597A3B5A416666666622452341CDCCCC2C733B5A4100000000CF4423419A9999B9593B5A4166666666B7442341666666C63B3B5A419A999999AB44234100000000323B5A419A99999970442341333333F31E3B5A419A99999915442341CDCCCCAC093B5A4133333333EF4323419A9999D9013B5A419A9999997E432341333333D3ED3A5A419A9999995E432341CDCCCC6CE43A5A4133333333E2422341CDCCCC6CCE3A5A4133333333A642234100000060C73A5A4100000000F24123419A999999AA3A5A4100000000C7412341666666A6A03A5A41000000004C412341666666C6883A5A41CDCCCCCC2141234100000020843A5A410000000086402341666666667A3A5A41666666663040234133333333733A5A4133333333BD3F2341000000C0623A5A419A9999994E3F2341666666E6693A5A41000000002F3F2341000000C0693A5A4100000000DD3E23419A9999D9623A5A419A9999995E3E2341666666A6533A5A419A999999343E234133333333503A5A41CDCCCCCCF63D2341666666C64E3A5A419A999999D33D2341333333B3503A5A4133333333A93D2341333333D3573A5A4133333333A93D2341333333D3573A5A41	01010000206A080000D869E4AF4043234166666696283B5A41	780150104	H	Le Centre	7801501	78015	78	11	0
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	01010000206A0800008A066EF15742234133333383673A5A41	780150105	H	Les Îles	7801501	78015	78	11	2
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	01010000206A080000F6422EC7E33923419A999959A0395A41	780150106	H	Denouval	7801501	78015	78	11	1
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	01010000206A080000CD9837BB7781224100000090AA335A41	780200000	Z	Arnouville-lès-Mantes	7802000	78020	78	11	10
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	01010000206A080000CACCCC6C0DCD2241CDCCCCDCA3385A41	780290105	H	Village	7802901	78029	78	11	0
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	01060000206A08000001000000010300000001000000820000009A9999995FB82241666666C6883A5A419A9999998DB82241CDCCCC6C8D3A5A4166666666FEB822419A9999B9943A5A4100000000BCB92241000000E09C3A5A4133333333A4BB224133333373B03A5A4133333333EFBC2241CDCCCCCCC83A5A4166666666DEBD2241CDCCCCACDC3A5A41333333337DBE2241CDCCCC4CE93A5A41CDCCCCCC5BBE2241CDCCCCACFB3A5A41333333332BBF2241666666C6103B5A41CDCCCCCC97BE22419A9999D92C3B5A4100000000ACC22241333333937C3B5A410000000008C32241333333D3823B5A419A99999994C32241000000E0873B5A413333333321C42241000000C0863B5A416666666630C522419A999979873B5A419A99999997C5224100000020893B5A416666666674C62241CDCCCC4C8F3B5A419A999999CDC62241CDCCCC8C923B5A410000000042C7224100000040983B5A419A999999C3C72241CDCCCC8CA03B5A416666666682C9224166666686BF3B5A413333333363CA224166666606C93B5A4166666666DBCA224166666626CC3B5A416666666652CB224166666646CE3B5A4133333333E4CB2241CDCCCC0CCD3B5A41CDCCCCCCCBCC2241CDCCCC4CCC3B5A419A99999952CD22419A999919CE3B5A4133333333D5CD224100000000D33B5A4100000000B6CE224100000080763B5A4166666666A0CE224166666686733B5A416666666671CF2241666666E62D3B5A419A9999995ECF2241333333F32C3B5A419A99999991CF2241000000801F3B5A419A999999DFCF2241333333930D3B5A419A999999B1D0224133333373DA3A5A41666666663AD0224133333393CF3A5A4133333333B6D02241CDCCCC8CA43A5A416666666612D1224166666626A93A5A410000000041D12241333333D3963A5A419A99999943D02241CDCCCC2C8D3A5A41000000002ED02241333333538B3A5A410000000068CE2241000000A0703A5A41CDCCCCCCE9CD2241CDCCCCAC6A3A5A416666666697CD2241CDCCCC4C6B3A5A413333333354CD2241333333936F3A5A41666666662FCD2241666666A6743A5A419A999999D7CC22419A9999B98A3A5A419A9999997FCC2241CDCCCCEC923A5A41CDCCCCCC7BCB2241CDCCCC2C9F3A5A410000000042CB22419A999939A13A5A4166666666B3CA2241666666C6803A5A410000000031CA224100000000613A5A41666666660CCA2241000000005C3A5A41333333330AC9224133333333433A5A4100000000BCC82241000000403C3A5A41CDCCCCCC21C92241000000A02B3A5A410000000067C92241000000A0223A5A413333333317C922419A9999B91D3A5A41CDCCCCCC51C92241333333F30F3A5A410000000086C92241333333330A3A5A416666666615CA224166666666003A5A419A99999937CA2241666666A6FB395A41666666666DCA2241CDCCCCCCEF395A419A999999FDCA224133333313C0395A41CDCCCCCC07CB224166666646B5395A41333333332ACB2241666666C6AF395A419A9999995ACB2241000000609F395A410000000075CB2241000000C091395A413333333380CB2241666666667B395A4133333333ACC92241CDCCCCEC62395A419A99999947C82241CDCCCCCC50395A41333333337DC722419A9999D947395A4166666666B2C622416666664640395A41333333338FC52241CDCCCCEC37395A41CDCCCCCC0FC52241333333B333395A4166666666F2C42241666666E63B395A41333333331CC52241000000803C395A4166666666BFC422410000002077395A41CDCCCCCC1CC522416666668672395A413333333358C522416666664672395A419A999999DDC422419A9999F992395A41CDCCCCCC11C42241666666C6CE395A419A999999A7C4224133333313D7395A41000000009BC42241CDCCCC8CDD395A419A99999982C42241000000A0DC395A4166666666F9C3224133333353053A5A4166666666FCC42241333333530C3A5A4133333333C0C4224100000000393A5A4166666666ACC422419A999979383A5A41CDCCCCCCA0C422419A999999403A5A419A999999C3C42241333333D3443A5A419A9999997FC4224166666626493A5A4100000000EAC42241CDCCCC4C613A5A41CDCCCCCCD8C4224100000060643A5A410000000052C42241333333F3873A5A41000000006DC4224100000080893A5A419A99999938C42241666666A6983A5A41CDCCCCCC0DC422419A999979963A5A419A999999FBC32241666666A6983A5A419A99999983C322419A9999D9B93A5A4133333333B7C322419A9999D9BC3A5A41000000006CC3224166666606CF3A5A4100000000A4C22241CDCCCC2C033B5A41CDCCCCCC80C222419A9999D9093B5A413333333331C22241333333B3033B5A4100000000D3C1224100000000FE3A5A4166666666B3C122419A9999D9FA3A5A416666666651C12241CDCCCCACF53A5A4100000000DBC022419A9999B9EB3A5A416666666628C0224100000060DE3A5A41CDCCCCCC86BF2241666666A6D43A5A41CDCCCCCCA9BE22419A999919C63A5A41CDCCCCCC3CBE22419A999999C03A5A41333333330ABE224133333333BF3A5A4100000000A7BD2241CDCCCC0CBF3A5A410000000041BD2241CDCCCC2CBA3A5A419A999999C1BC224100000040B63A5A419A9999997EBC224166666666AD3A5A410000000003BC2241CDCCCC8C9F3A5A4166666666D6BB2241000000409D3A5A413333333358BB2241000000C09A3A5A41CDCCCCCCB1BA2241000000A0913A5A416666666649BA2241333333D38F3A5A4100000000F3B92241CDCCCCEC863A5A4133333333B5B92241000000E0813A5A41CDCCCCCC1CB922419A9999597A3A5A410000000080B82241333333B3713A5A419A9999995FB82241666666C6883A5A419A9999995FB82241666666C6883A5A41	01010000206A0800008796C51191C72241CDCCCCAC833A5A41	780290101	H	Élisa	7802901	78029	78	11	3
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	01060000206A080000010000000103000000010000002100000066666666F7CC22419A99997965385A416666666621CD22410000002067385A41000000006ECD2241333333B365385A4100000000B7CD22419A9999F962385A4100000000E7CD22419A9999995E385A41CDCCCCCC51CE2241CDCCCCAC4F385A410000000072CE2241000000604D385A4100000000CCCE2241000000604D385A4166666666FECE22410000006047385A41666666662ECF22419A9999F943385A41CDCCCCCC6FCF22410000006042385A41CDCCCCCC34D02241333333D344385A416666666665D02241333333F349385A416666666681D02241000000204F385A41666666668FD02241CDCCCC4C5D385A41333333338CD02241CDCCCC2C66385A419A999999E5D022413333333369385A41666666661FD12241CDCCCCCC54385A419A99999932D122419A99995954385A41333333337CD22241CDCCCC0C6C385A410000000099D22241CDCCCC4C24385A419A999999EDD22241666666461D385A419A9999997ED222416666668605385A4166666666E6D1224166666606E4375A4133333333C9D12241CDCCCC6CE8375A4166666666FBD02241333333732C385A413333333310CF22419A99997903385A4100000000FBCE2241666666E603385A41000000008CCE2241CDCCCCAC14385A41000000009CCD22419A9999593F385A41000000001BCD2241333333535E385A4166666666F7CC22419A99997965385A4166666666F7CC22419A99997965385A41	01010000206A080000F34E14E775CF22419A99996929385A41	780290106	H	Acosta	7802901	78029	78	11	0
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	01010000206A0800005E5786622ACE22419A9999D9AB395A41	780290102	H	Trait d'Union	7802901	78029	78	11	2
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	01010000206A0800001E6F26A6A7CD2241333333237A375A41	780290103	H	Montgardé	7802901	78029	78	11	4
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	01060000206A0800000100000001030000000100000017000000000000000DCF2241CDCCCCCCB7385A419A9999991CCF2241333333F3C1385A41CDCCCCCC5BCF224100000080C7385A41333333334CD02241CDCCCC6CD7385A41CDCCCCCC00D222419A9999F9D4385A41333333331DD22241CDCCCC8CD3385A41CDCCCCCC2DD222419A9999D9CE385A41CDCCCCCC2CD22241CDCCCC8CC7385A419A99999946D22241CDCCCC0CCB385A41CDCCCCCC75D222419A9999B97A385A41333333337CD22241CDCCCC0C6C385A419A99999932D122419A99995954385A41666666661FD12241CDCCCCCC54385A419A999999E5D022413333333369385A41333333338CD02241CDCCCC2C66385A41666666667CD02241333333B374385A41CDCCCCCC37D02241666666068F385A4133333333FDCF2241666666E69B385A4133333333C0CF224166666686A2385A419A9999993CCF224166666666AD385A410000000021CF224166666626B1385A41000000000DCF2241CDCCCCCCB7385A41000000000DCF2241CDCCCCCCB7385A41	01010000206A0800009255D80443D122416666669695385A41	780290104	H	Bois Bodin Haut du Parc	7802901	78029	78	11	0
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	01060000206A08000001000000010300000001000000D1000000CDCCCCCCC0CD224166666646A21C5A41CDCCCCCC19CE224133333393B21C5A41CDCCCCCC09CE22419A999939B41C5A41CDCCCCCCDDD12241CDCCCC2C411D5A419A99999978D22241333333F3561D5A4166666666CBD222419A999959631D5A419A99999914D32241CDCCCC6C5B1D5A416666666688D32241333333D3551D5A41CDCCCCCC18D52241000000603D1D5A4166666666A3D522419A9999B9351D5A416666666616D6224133333313351D5A413333333369D62241CDCCCCEC311D5A41666666665FD722419A999939171D5A419A9999991AD8224100000060041D5A419A999999BDD82241333333530A1D5A4100000000B7D82241333333931E1D5A4166666666A1D82241000000A0211D5A41CDCCCCCCB1D822419A999959251D5A419A999999B0D822419A9999592B1D5A4133333333A2DA2241666666C63F1D5A419A99999911DB2241333333733B1D5A419A999999DBDB2241333333333B1D5A419A999999B9DC22419A9999993E1D5A4166666666A0DC224166666666331D5A4133333333D0DC2241CDCCCC8C331D5A413333333312DD224166666666301D5A4133333333A1DD224100000000301D5A4133333333F8DE2241666666C6271D5A4100000000C9DF2241333333B31B1D5A413333333382E02241CDCCCC6C141D5A41666666668FE12241CDCCCC8C0D1D5A4100000000DBE12241333333330A1D5A41000000005EE2224100000000061D5A416666666693E22241666666E6001D5A416666666698E3224166666606F21C5A4100000000F0E3224133333353EF1C5A419A999999ABE42241CDCCCCECE71C5A410000000044E52241CDCCCC6CE51C5A41CDCCCCCCFFE52241CDCCCCACDF1C5A419A9999995BE6224100000080DB1C5A419A999999CCE6224166666666D41C5A413333333318E72241CDCCCCACD11C5A419A9999997EE7224166666626D01C5A419A9999991CE82241000000E0CF1C5A41CDCCCCCC64E82241CDCCCC4CCD1C5A410000000068EA2241666666C6B21C5A419A99999934EB22419A9999B9A71C5A41000000004AEB22419A9999B9CC1C5A419A99999993EB2241CDCCCCACC51C5A41666666662BED2241CDCCCC0CA11C5A416666666659F1224133333393401C5A41CDCCCCCCFDF422419A999999EC1B5A4166666666A0F52241CDCCCC2CDE1B5A41CDCCCCCC8FF5224133333393DA1B5A4100000000B1F522419A999939D41B5A419A9999997CF52241CDCCCCCCBE1B5A4100000000C0F5224133333373A71B5A41CDCCCCCC7DF62241000000A0941B5A41CDCCCCCC74F62241333333D3891B5A416666666624F72241CDCCCCAC661B5A410000000086F722419A999999611B5A4100000000BDF72241CDCCCC0C551B5A4133333333DFF72241CDCCCC4C561B5A41CDCCCCCCFCF7224166666686511B5A41000000007CF82241CDCCCC6C481B5A419A999999E9F8224133333393411B5A41CDCCCCCCFFF82241CDCCCC4C461B5A41CDCCCCCCD4F92241666666E6371B5A41666666661CFA224133333393321B5A4133333333A0F922419A9999D92D1B5A41333333337AF92241333333B32E1B5A41666666664BF92241000000C0221B5A41CDCCCCCC10F92241333333D3181B5A4133333333BAF82241666666A60E1B5A41CDCCCCCC61F822419A9999F9061B5A4100000000E1F7224133333353021B5A419A9999992EF822419A999999F91A5A410000000061F82241CDCCCCACF71A5A41CDCCCCCC67F82241333333F3E41A5A41333333335EF8224100000020D21A5A410000000081F82241CDCCCC2CCB1A5A413333333371F82241CDCCCC2CBC1A5A419A9999993DF82241CDCCCC6CB01A5A413333333333F82241666666A6AB1A5A4166666666C9F72241333333739B1A5A41CDCCCCCC7EF7224166666646821A5A410000000064F72241333333B3801A5A410000000037F72241CDCCCC8C761A5A41000000000AF72241000000606F1A5A4166666666C3F6224133333393681A5A41666666663BF62241666666065D1A5A41000000000BF62241CDCCCC4C5B1A5A4100000000A0F52241000000405E1A5A4100000000F7F52241CDCCCCAC511A5A419A99999911F6224100000020481A5A4166666666FFF5224100000060461A5A4133333333BCF52241666666262B1A5A419A999999B9F522419A9999F9221A5A413333333397F5224166666666F0195A41666666668BF5224133333353EB195A416666666637F522419A9999F9DA195A4166666666AAF4224166666606C3195A419A9999994BF4224166666626B8195A416666666601F42241666666C6B1195A41CDCCCCCC8CF3224166666666A9195A416666666619F32241333333339F195A4133333333E1F222419A9999B998195A419A999999A0F22241000000808F195A419A99999932F22241666666A67C195A4166666666CBF12241666666E667195A4100000000DFF022410000000041195A419A99999940F12241666666A63B195A416666666683F122419A9999D936195A419A99999946F22241CDCCCCEC26195A41666666669AF22241666666061E195A41CDCCCCCC1DF32241666666060C195A41666666667DF3224100000080FD185A4100000000EBF3224133333353EA185A41333333335CF422419A999959D4185A419A9999996CF4224100000020CF185A419A9999996CF4224133333353B8185A41333333337BF42241666666E6B1185A41CDCCCCCCB0F42241333333B3A3185A41666666660FF52241666666C68E185A41CDCCCCCC19F52241CDCCCC0C7E185A41CDCCCCCC18F522419A9999F96D185A41CDCCCCCC0DF522416666666653185A413333333303F522416666666644185A416666666602F522410000000031185A419A99999990F42241666666661F185A41000000001BF422416666668623185A419A99999965F32241CDCCCCEC28185A41CDCCCCCC43F322416666662629185A419A999999FBF122419A99999926185A419A999999ACF122416666660624185A41CDCCCCCCABF02241666666A618185A419A99999984F02241000000C01D185A41CDCCCCCC58F022419A9999391E185A41333333337FEF22410000000017185A4100000000F9EE2241333333330E185A416666666653EE2241666666260B185A41CDCCCCCC0DEE2241000000400B185A413333333303ED2241CDCCCCCC10185A41CDCCCCCC4FEC2241666666461E185A41333333332CEC22419A9999591C185A41666666662BE92241333333D3FB175A419A999999DAE82241333333B3F9175A41CDCCCCCC6FE8224100000000FA175A41CDCCCCCC7DE6224133333313FF175A41CDCCCCCC47E522419A9999F901185A4166666666EEE42241CDCCCC2C00185A41CDCCCCCCE5E322419A999979F2175A4133333333D3E12241000000C01F185A410000000033E122419A9999792F185A410000000082E022419A9999B95A185A416666666630E02241CDCCCCEC6D185A4100000000C5DE2241000000A0C5185A41666666660FDE2241CDCCCC0CF2185A4166666666B7DE22419A9999F9F9185A41CDCCCCCCA4DE2241666666860E195A410000000089DE22416666664653195A41000000007DDE2241333333F36B195A41000000003FDE2241333333D36E195A410000000098DE22410000006090195A419A99999914DF22419A9999D9BC195A41CDCCCCCC54E0224133333353B7195A416666666685E0224100000080CD195A41CDCCCCCCCBE0224166666606F4195A41CDCCCCCCEEE0224100000040031A5A419A999999FAE022419A9999990E1A5A4100000000ECE0224100000020131A5A4100000000D6E022419A999939241A5A4100000000AEE0224133333313391A5A41CDCCCCCC7AE022419A9999995C1A5A413333333354E02241CDCCCCAC721A5A41CDCCCCCCD5DF2241CDCCCC8C971A5A41CDCCCCCCADDF2241000000C0A41A5A419A99999985DF224166666626AF1A5A41CDCCCCCC52DF224166666626B71A5A416666666604DE2241333333F3E21A5A41000000006DDD22419A999979F71A5A41000000002CDD224100000000021B5A41000000002ADD224133333333041B5A4100000000B5DB2241CDCCCCEC0D1B5A416666666688DA224133333373FC1A5A41333333338FDA224133333353011B5A413333333350DA2241CDCCCC6C021B5A4133333333C5D72241000000E01A1B5A419A99999900D7224133333373221B5A41CDCCCCCCAED5224133333333211B5A416666666623D522419A999939281B5A41666666660BD52241CDCCCCEC221B5A413333333360D422419A9999394C1B5A419A9999996AD32241333333730D1B5A41CDCCCCCCEAD222419A999939191B5A419A99999922D22241000000C02A1B5A419A99999919D22241333333F3301B5A416666666654D122419A999979AC1B5A41000000002BD2224133333313BE1B5A416666666670D22241666666E6C41B5A410000000014D2224166666686DA1B5A41CDCCCCCCC9D02241CDCCCC6C2A1C5A416666666679D02241333333733E1C5A4133333333D4CF22419A999959651C5A419A99999999CF224133333393741C5A41666666668ACE224133333353B51C5A41CDCCCCCC06CE2241333333B3A01C5A41CDCCCCCCC0CD224166666646A21C5A41CDCCCCCCC0CD224166666646A21C5A41	01010000206A08000071CAB822E2EB2241000000A0AA1A5A41	780300000	Z	Auffargis	7803000	78030	78	11	17
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	01010000206A080000F4D1DD1B5E7822419A99993963385A41	780310000	Z	Auffreville-Brasseuil	7803100	78031	78	11	2
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	01010000206A080000A0AD7F9E8BC42241CDCCCC3C85355A41	780330000	Z	Aulnay-sur-Mauldre	7803300	78033	78	11	2
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	01060000206A080000010000000103000000010000007C000000CDCCCCCC1DAC224166666626EE2A5A41666666665FAC2241333333D3F22A5A4100000000FFAC22419A9999D9082B5A41333333333AAD22419A999939122B5A410000000060AD2241333333731B2B5A419A9999991CAE22419A9999594F2B5A4166666666A3AE2241CDCCCC2C6D2B5A4166666666DFAE2241000000E0742B5A4100000000F8AE2241000000207A2B5A41000000001AAF2241333333D3862B5A410000000068AF224100000040902B5A416666666692B0224133333353B12B5A41000000006CB1224100000040CB2B5A419A999999CCB1224100000080D82B5A419A999999EEB12241CDCCCC4CDF2B5A41CDCCCCCC18B2224166666666F42B5A41666666663EB222419A999999FC2B5A419A9999994BB2224166666646022C5A410000000055B22241333333330F2C5A413333333357B22241000000201E2C5A41CDCCCCCC69B22241CDCCCC6C222C5A4133333333C9B2224100000000302C5A4100000000EBB22241CDCCCC4C362C5A410000000016B3224100000080422C5A41000000003DB322419A9999F94A2C5A419A999999BCB322419A999979622C5A41CDCCCCCCC9B32241000000A0612C5A41CDCCCCCC9FB32241666666066E2C5A410000000046B42241000000A08E2C5A410000000001B32241CDCCCC8CA72C5A410000000094B2224166666686AE2C5A4166666666A3B22241333333B3B32C5A41666666660DB322419A999919CD2C5A416666666641B32241CDCCCCACDA2C5A41333333338BB322419A999979EB2C5A4100000000B6B32241333333F3F82C5A4133333333EEB3224133333313F62C5A413333333313B42241CDCCCC4CFE2C5A41CDCCCCCC9AB42241CDCCCC6C192D5A41CDCCCCCC07B422419A9999993C2D5A416666666621B42241666666663F2D5A4100000000FDB42241000000005D2D5A413333333326B5224166666626572D5A416666666649B52241333333F35A2D5A4100000000F1B5224133333333472D5A41666666664AB622419A999999502D5A4100000000DDB62241CDCCCC8C3D2D5A41CDCCCCCCA7B6224166666666382D5A416666666640B7224133333313272D5A41CDCCCCCC70B72241333333132F2D5A410000000096B722419A9999F9312D5A41333333330DB8224166666686232D5A41000000003CB82241000000C01E2D5A4166666666E0B82241333333331D2D5A4133333333FBB82241666666E60E2D5A41CDCCCCCC01B92241333333D3062D5A419A99999911B92241CDCCCCCC062D5A4100000000ECB92241000000A00D2D5A41333333333FBA2241333333330C2D5A419A999999CBBA224166666686FC2C5A41CDCCCCCC30BB224166666686F52C5A41CDCCCCCC2FBB22419A999979EC2C5A41CDCCCCCC3FBB22419A999999D72C5A41CDCCCCCC41BB2241333333F3C32C5A41CDCCCCCC30BB2241CDCCCC8C9F2C5A41666666664FBB224133333353A52C5A4100000000EFBB22419A999959BC2C5A419A9999999FBC224100000020D32C5A4166666666F1BC224100000020DB2C5A419A999999A8BD224100000060E72C5A419A99999977BF224166666626972C5A41CDCCCCCCF5C02241333333B37D2C5A41CDCCCCCCCAC0224166666666642C5A4166666666AAC0224100000060572C5A413333333371C02241333333933B2C5A413333333362C02241333333D32F2C5A41666666665CC02241666666861A2C5A416666666646C02241333333330A2C5A419A99999938C02241666666E6F42B5A410000000033C022419A999959DF2B5A41333333333BC02241000000C0BC2B5A416666666643C0224166666626AA2B5A416666666628C02241CDCCCC2CA82B5A41CDCCCCCC9FBF224133333373922B5A416666666670C02241000000C0882B5A419A999999D6BF2241333333735E2B5A4166666666D0BE22419A9999D9362B5A410000000053BF2241CDCCCC2C282B5A4166666666B6BE22419A9999790C2B5A419A99999952BE2241CDCCCCCCFB2A5A41666666663ABE2241CDCCCCACF12A5A419A99999925BE224100000000C62A5A419A99999913BE2241CDCCCCECAC2A5A419A99999906BE2241CDCCCCACA42A5A41CDCCCCCC44BD224100000080AA2A5A410000000052BC224133333393B22A5A41CDCCCCCC71BB224100000000B92A5A41CDCCCCCC52BA2241000000C0B92A5A419A99999945B9224133333393BC2A5A419A999999DDB822419A999939BC2A5A419A99999983B82241000000C0BA2A5A41CDCCCCCC70B7224166666686BC2A5A419A999999C5B62241CDCCCC6CBF2A5A41CDCCCCCC48B622419A9999F9BE2A5A4133333333BAB52241CDCCCC6CBF2A5A413333333301B52241000000E0C02A5A41CDCCCCCC62B4224100000020C32A5A410000000010B422419A999999C72A5A4100000000EDB322419A9999F9C52A5A419A99999987B3224166666646C62A5A41CDCCCCCC12B32241000000A0C52A5A41CDCCCCCC95B22241333333D3C32A5A419A99999931B22241CDCCCC6CC32A5A419A99999938B122419A999979BF2A5A41CDCCCCCCA5B0224100000000C02A5A41CDCCCCCC51B0224100000060C12A5A4100000000FAAF224100000020C42A5A410000000020AF22419A999979CC2A5A416666666627AE2241000000E0D92A5A419A999999DEAD22419A999939DD2A5A41333333334EAD224100000000E22A5A41000000009BAC2241000000C0E82A5A41CDCCCCCC1DAC224166666626EE2A5A41CDCCCCCC1DAC224166666626EE2A5A41	01010000206A080000E438C48E43B922419A9999A9FF2B5A41	780340000	Z	Auteuil	7803400	78034	78	11	4
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	01010000206A080000724C946BC8AB2241666666B66A2C5A41	780360000	Z	Autouillet	7803600	78036	78	11	5
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	01060000206A080000010000000103000000010000008700000066666666FD40234133333313932A5A4166666666004123419A999919982A5A413333333349412341333333D3BD2A5A41CDCCCCCC50412341333333B3BF2A5A41CDCCCCCC344223419A999939BF2A5A416666666652432341CDCCCC4CC12A5A419A9999992444234100000080C02A5A419A9999993D44234133333313D32A5A419A99999958442341666666E6DE2A5A4166666666AB4423419A999919FF2A5A41CDCCCCCCE6442341666666E6112B5A41666666667E452341CDCCCC8C092B5A41000000009645234100000000132B5A4133333333BB452341CDCCCC8C102B5A41CDCCCCCC03462341000000802E2B5A419A9999993C46234100000060432B5A41666666666C47234166666626352B5A41CDCCCCCCBE472341666666E6312B5A4133333333054823419A9999794B2B5A410000000050482341CDCCCCCC492B5A419A999999B34823419A999939462B5A419A999999C148234133333373662B5A4100000000EC482341666666E6712B5A41CDCCCCCCDF48234133333313762B5A419A999999044923419A9999997C2B5A41CDCCCCCC1649234133333373A92B5A4133333333014923419A999959B02B5A41333333330A492341CDCCCC8CC62B5A419A9999995748234100000040C72B5A41CDCCCCCCAA48234166666666EC2B5A4133333333CA482341CDCCCCACF32B5A41CDCCCCCC60492341333333D30A2C5A4133333333524923419A999979102C5A419A9999995B492341000000A0152C5A41000000008848234100000080172C5A410000000096472341000000A01C2C5A4166666666BA46234100000040222C5A41000000000D462341CDCCCC2C252C5A41333333332046234100000040312C5A41CDCCCCCC17462341CDCCCCAC342C5A419A999999EB452341333333B3352C5A419A999999E5452341666666A6382C5A413333333329462341CDCCCCAC622C5A4166666666F1462341CDCCCC6CE22C5A419A999999FA4623419A999979E52C5A41333333336A47234166666626302D5A410000000086492341000000202D2D5A4166666666AB4B2341666666A6282D5A419A9999992A4D234166666646262D5A419A999999F14E2341CDCCCC0C232D5A4133333333344F23419A9999F9192D5A41000000002F4F2341CDCCCC0C0B2D5A4133333333E84E23419A999919F92C5A4100000000874E2341000000A0E82C5A419A999999FE4D2341333333B3D32C5A4133333333B14D2341CDCCCC6CC62C5A413333333302502341CDCCCC6CAB2C5A419A99999926512341CDCCCC6C922C5A41333333332B52234133333333722C5A410000000078542341CDCCCCEC492C5A41000000007154234166666626462C5A41666666661A582341333333F30B2C5A4100000000715A2341666666A6E92B5A419A999999345A234133333373C82B5A41000000003C5A23419A999959C52B5A419A999999C859234133333313932B5A4100000000725923419A999919662B5A41333333335E5823419A9999796C2B5A4166666666C3572341333333D36E2B5A4100000000DC562341333333D36E2B5A4100000000A9562341333333F3652B5A4100000000565623419A9999B9542B5A41CDCCCCCC395623419A9999B94A2B5A410000000020562341CDCCCCAC3B2B5A41CDCCCCCCF25523419A999959392B5A4100000000D7552341CDCCCCAC312B5A4100000000B3552341666666462D2B5A4166666666F7552341CDCCCC8C272B5A419A9999997E562341CDCCCCEC1D2B5A41CDCCCCCC9B562341666666A61C2B5A41CDCCCCCC90562341CDCCCCAC182B5A4100000000B355234100000000E52A5A41000000002A5523419A9999B9C52A5A419A9999998C5423419A999999A02A5A41666666660A5423419A999999842A5A41666666663C532341000000E0542A5A419A999999295323419A999939522A5A4100000000E952234133333353412A5A419A999999535223419A9999391F2A5A41CDCCCCCC12522341000000A0192A5A41CDCCCCCC2F522341666666E6132A5A419A9999992551234133333313D8295A419A999999A64F2341CDCCCC2C7F295A419A999999464F23419A9999997F295A41333333333A4F2341666666C663295A4100000000034F2341333333F359295A4166666666BF4E2341333333F349295A4100000000584E2341CDCCCC2C48295A4166666666D04D2341666666864A295A4100000000914D2341CDCCCC8C4D295A4133333333774D2341666666E649295A4133333333D24C23419A9999D94F295A41666666660D4C2341CDCCCCEC62295A4133333333F84B23416666666669295A4100000000AC4B23413333333372295A4166666666514B2341CDCCCC2C7B295A41333333336E4A2341666666A68F295A419A9999993A4A23413333335398295A41CDCCCCCCF249234166666626A9295A4133333333CD49234133333393AB295A41000000003649234133333333AE295A416666666698482341000000C0B3295A4100000000494823419A9999F9B4295A4133333333A4472341666666A6C4295A419A9999998F472341000000E0C8295A4133333333D6462341000000E0DC295A410000000077462341666666A6E4295A41333333335C452341CDCCCCCCF7295A41CDCCCCCCDA442341333333D3012A5A41CDCCCCCCC14423419A999999062A5A4100000000B444234166666626182A5A4100000000A444234133333393222A5A4100000000834423419A9999592B2A5A41666666660C44234100000080422A5A4133333333A5432341000000C0572A5A41000000000543234133333373772A5A4166666666E5422341666666867E2A5A419A999999BC422341CDCCCC8C802A5A41000000003F422341000000E07D2A5A41CDCCCCCC17422341000000207B2A5A41333333339E4123419A999979752A5A4166666666514123419A999959762A5A4166666666794123419A9999F98D2A5A4166666666FD40234133333313932A5A4166666666FD40234133333313932A5A41	01010000206A08000022C03382064F2341666666463F2B5A41	780430000	Z	Bailly	7804300	78043	78	11	7
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	01010000206A080000D8F96575CC612241CDCCCC0C01295A41	780480000	Z	Bazainville	7804800	78048	78	11	12
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	01010000206A080000210EF413D3D7224166666686C7355A41	780490000	Z	Bazemont	7804900	78049	78	11	7
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	01060000206A08000001000000010300000001000000B1000000666666663CBA2241000000A009245A419A9999995BBA22419A9999B912245A41CDCCCCCC51BA22416666664621245A416666666665BA22419A99995927245A419A9999999ABA2241333333332C245A419A99999929BB22419A9999B944245A416666666672BB22419A9999394E245A4166666666B7BB2241CDCCCCCC55245A419A99999947BC22410000002069245A419A99999963BC2241000000206E245A419A99999997BC2241666666467B245A419A99999910BD2241666666868D245A410000000078BD2241333333739A245A419A999999A7BD2241000000809D245A4133333333E5BD2241333333939D245A41CDCCCCCC24BE2241333333D3A0245A41CDCCCCCC47BE224133333393A4245A4166666666E2BE2241333333D3BE245A41CDCCCCCC8ABF22419A9999B9DC245A41CDCCCCCCABBF224100000000EB245A4166666666F0BF22413333335327255A4133333333F9BF22419A99995933255A41666666661BC022416666660655255A419A9999993EC02241666666A66A255A41666666665EC322419A99991967255A419A99999947C422416666662665255A413333333313C522416666660662255A410000000025C62241333333335F255A41CDCCCCCC5BC62241CDCCCCEC5A255A419A99999977C622413333333356255A410000000087C622413333339348255A419A999999B4C622416666660642255A4166666666E0C622410000004041255A41333333337EC722419A99991944255A41CDCCCCCCB5C72241333333D343255A416666666647C822419A9999D93E255A41666666666DC922419A9999792F255A4166666666EBC92241CDCCCCCC2B255A410000000039CB22419A9999F925255A4133333333A9CB22416666664649255A410000000076CC2241CDCCCC6C80255A416666666662CD2241CDCCCC8CDC255A41CDCCCCCC34CE224166666646E5255A41000000005ECF2241666666460E265A41CDCCCCCC71D02241CDCCCCEC41265A410000000098D122410000000082265A4166666666B1D122410000004089265A419A999999EAD2224166666666DE265A41CDCCCCCC08D322419A999919DC265A419A999999BAD422416666668632275A416666666680D422410000002044275A419A999999E0D422419A99995959275A4133333333B9D522416666662644275A41666666664CD52241CDCCCC8C25275A419A99999905D522416666662614275A419A99999904D52241CDCCCCEC0C275A41CDCCCCCCCAD42241CDCCCC0CC3265A4100000000B2D422419A9999D99A265A419A99999940D422410000000084265A4166666666E1D32241666666A66E265A41CDCCCCCC43D322419A9999794C265A416666666685D222419A99993922265A41CDCCCCCCE5D12241666666E6FA255A4166666666A0D1224166666606EB255A419A9999998DD122419A999979D9255A4133333333B4D1224100000020D3255A41000000001ED22241CDCCCC0CC9255A416666666674D222419A9999B9BD255A419A9999998AD222419A999919B9255A413333333368D322419A99995973255A416666666683D32241CDCCCC6C6B255A41CDCCCCCCA5D32241666666E659255A4100000000EAD322413333337342255A413333333340D42241000000802C255A41CDCCCCCC53D422419A9999D91F255A419A99999925D422410000004021255A419A9999995AD322410000002010255A410000000003D32241CDCCCCAC09255A4166666666C2D22241000000C003255A419A99999964D222410000000003255A4166666666E6D122410000006007255A4166666666C1D12241000000A006255A413333333393D12241CDCCCC0CF7245A416666666666D1224133333313EE245A410000000036D12241000000E0DE245A4133333333E9D02241666666C6D4245A4100000000BBD02241CDCCCC4CCB245A419A9999998AD02241CDCCCCACB4245A41000000006ED022419A9999399E245A41CDCCCCCC41D02241333333138D245A416666666600D02241333333F380245A416666666609D02241000000C070245A410000000007D02241CDCCCC8C56245A4100000000FCCF2241CDCCCC8C4C245A4100000000FECF2241000000E02F245A41666666661BD022419A99991917245A416666666656D02241666666E6F6235A419A99999975D02241CDCCCC4CED235A41333333339DD02241333333D3E4235A41CDCCCCCC0CD1224133333353D4235A410000000074D12241CDCCCC8CCB235A4166666666B5D1224100000060C7235A4100000000DDD122419A999999C6235A419A99999969D222419A9999B9C6235A4133333333A6D22241CDCCCCECC5235A4100000000E4D222419A999939C1235A413333333341D3224133333373B6235A41CDCCCCCC4CD32241333333B3B2235A41CDCCCCCCF2D22241333333B3A4235A4166666666CCD22241666666469C235A419A99999973D22241000000808C235A413333333376D222419A99997978235A419A99999915D222413333339359235A410000000012D22241000000C045235A41333333332ED22241666666E636235A41000000005AD222416666666627235A416666666657D222416666668622235A41CDCCCCCC2CD22241CDCCCC4C1E235A4166666666F3D12241333333331C235A41CDCCCCCCA8D122419A9999B91B235A419A9999992AD122416666666614235A4133333333BBD02241666666C60F235A419A9999992DD02241000000400D235A419A9999993ACF2241333333530D235A4133333333BCCE22410000004009235A4100000000A3CE22410000004009235A41000000000DCE2241CDCCCCEC0D235A419A99999975CD2241000000A015235A419A9999996DCD22410000000019235A41666666661DCD22410000000021235A4166666666BFCC22416666666627235A416666666677CC2241CDCCCC0C2E235A416666666633CC2241CDCCCCCC37235A41666666660ECC2241CDCCCC6C41235A4100000000EECB2241CDCCCCCC45235A413333333337CB22419A99993956235A4166666666F6CA2241666666465E235A4133333333ADCA22416666666665235A410000000044CA2241CDCCCCAC71235A41CDCCCCCCF3C92241666666C67D235A4166666666AEC92241333333D383235A41666666663CC92241000000A088235A419A99999932C92241CDCCCCAC8A235A413333333357C92241CDCCCC0C92235A41666666660EC922419A9999D9A0235A419A999999A1C8224166666626B4235A419A99999935C82241666666A6CC235A416666666612C822419A999919D2235A4100000000B8C7224100000040DD235A4100000000F1C6224166666646EF235A41333333337BC622419A99997900245A416666666633C6224100000060F0235A41CDCCCCCCCDC52241CDCCCC6CDD235A41000000009EC5224133333313D6235A41333333332EC52241CDCCCCACC8235A419A99999905C52241666666A6C2235A410000000076C42241CDCCCCECA8235A419A9999992AC42241000000E09E235A419A999999CDC32241666666E693235A41CDCCCCCC8DC322410000004089235A4100000000CBC222410000006073235A41CDCCCCCC79C222416666660687235A41CDCCCCCC41C222419A9999F991235A41666666662CC12241CDCCCC8CA5235A4166666666A4C022419A9999D9B0235A416666666636C02241666666C6B8235A419A9999993CBF22419A9999D9C4235A4166666666B5BE2241CDCCCCECC9235A413333333353BE2241CDCCCC8CCB235A4100000000A9BD2241CDCCCC4CD5235A4100000000E2BC224166666686DD235A413333333389BC2241CDCCCCECDF235A413333333347BC2241CDCCCCECE2235A419A999999AFBB224166666666F0235A41CDCCCCCCCCBA22416666662600245A41666666663CBA2241000000A009245A41666666663CBA2241000000A009245A41	01010000206A08000092C5D5329AC42241CDCCCCDC31255A41	780500000	Z	Bazoches-sur-Guyonne	7805000	78050	78	11	6
01060000206A08000001000000010300000001000000D8000000CDCCCCCC4A782241000000400C2B5A41333333339D782241CDCCCCEC1E2B5A419A9999996B792241666666A64D2B5A419A9999997F7922419A999959522B5A4166666666AE792241000000605F2B5A4166666666D8792241CDCCCCAC6D2B5A419A999999F7792241000000407A2B5A41CDCCCCCC517A2241666666E6A32B5A41333333337E7A2241333333B3B12B5A41666666668C7A2241333333B3B42B5A4166666666BC7A22419A999999BE2B5A4166666666C47A224100000020C02B5A419A999999E17A224166666686C52B5A41666666662A7B2241CDCCCCACD02B5A41333333333B7B224100000040D32B5A41666666664E7B22419A999999D62B5A41CDCCCCCCA57B224166666686EB2B5A41CDCCCCCCBD7B224100000040F12B5A4166666666C97B2241CDCCCC6CF32B5A4133333333D47B2241CDCCCC8CF42B5A4100000000387B2241666666E6FA2B5A4100000000C47B2241CDCCCCCC1D2C5A41CDCCCCCC027C2241666666662D2C5A4133333333387C2241CDCCCC6C392C5A41333333335D7C2241333333B3372C5A419A999999797C2241666666463F2C5A419A9999995B7D2241000000607B2C5A41333333336B7D2241CDCCCC8C7F2C5A4166666666AD7D22419A999939832C5A41000000001C7E224100000000A02C5A419A9999995D7E2241666666A69B2C5A41000000006E7E2241000000A09F2C5A4166666666267E22419A9999F9A42C5A419A999999C57E224100000020E12C5A41CDCCCCCC517E224133333353E52C5A41666666667F7E2241666666A6F32C5A4166666666147F2241CDCCCC0CED2C5A419A999999CE7F224166666646E42C5A4100000000E1802241CDCCCCACD72C5A4133333333F081224100000000CB2C5A419A999999B48122419A999919C42C5A419A999999778522419A9999D98C2C5A41000000009585224166666626922C5A41CDCCCCCCE385224133333333A12C5A41CDCCCCCC44862241333333F3B62C5A410000000045862241CDCCCC0CB72C5A419A99999917872241000000C0AA2C5A4166666666048722419A999959A52C5A4133333333F4862241000000A0A12C5A413333333396862241CDCCCC4C872C5A4100000000378622419A9999596F2C5A419A999999278722419A999979642C5A41000000007F872241000000A0602C5A41CDCCCCCCF78622419A9999193B2C5A41CDCCCCCCBE862241666666462B2C5A419A999999CB862241666666662A2C5A41CDCCCCCCE3862241CDCCCC2C302C5A41333333337987224133333353262C5A4166666666EB87224166666646202C5A413333333352882241333333331A2C5A4166666666918822419A999939162C5A419A999999DB8822419A999999112C5A413333333315892241666666860D2C5A413333333326892241666666660C2C5A41CDCCCCCC21892241333333530A2C5A416666666606892241CDCCCC6C032C5A4133333333BC88224133333333F42B5A4166666666A988224166666666EF2B5A41CDCCCCCC9988224166666666EB2B5A416666666678882241CDCCCCECE32B5A41CDCCCCCC4588224133333393D82B5A419A99999961882241CDCCCC8CD62B5A41000000007188224133333393D42B5A419A9999999D8822419A9999B9D02B5A4100000000B088224133333393CF2B5A41000000005489224133333313C82B5A4133333333C4892241CDCCCCACC32B5A419A999999208A2241CDCCCCACBF2B5A41000000003C8A224133333333BE2B5A41CDCCCCCC7D8A2241CDCCCC4CBA2B5A41CDCCCCCC858A224166666606B92B5A4166666666658A224133333313B62B5A4166666666548A2241000000E0B32B5A4100000000398A224100000000B02B5A41333333330C8A224166666666AA2B5A4133333333D989224100000040A32B5A41CDCCCCCCA7892241CDCCCCAC9D2B5A419A9999994289224100000080902B5A41CDCCCCCC08892241666666E6892B5A41000000007688224166666666792B5A416666666627882241333333F3702B5A4100000000EC87224100000040692B5A4166666666C28722419A999919652B5A41CDCCCCCC8D8722419A9999395F2B5A41333333338D872241CDCCCC2C5F2B5A4166666666678822419A999979392B5A41666666669D892241666666A6162B5A41000000007A892241000000C0112B5A419A9999995C892241666666A60D2B5A41333333331489224133333393032B5A41000000002F8922419A999999002B5A4100000000508A224100000080E02A5A4133333333A489224100000080C72A5A4100000000E4892241666666E6BF2A5A41666666665089224100000000942A5A413333333302892241CDCCCC0C7A2A5A419A999999C1882241333333936E2A5A41CDCCCCCC9588224166666626662A5A4133333333648822419A9999995C2A5A419A9999993E8822419A9999595D2A5A41333333331F8822419A9999B95E2A5A416666666607882241000000E05E2A5A4166666666F6872241666666A65C2A5A4133333333C9862241CDCCCC0C352A5A41CDCCCCCC01872241333333332D2A5A416666666626872241000000E0262A5A4133333333718722419A9999991A2A5A41333333332D862241333333D3032A5A41000000002E86224100000080032A5A41333333334A86224133333373D8295A413333333308852241CDCCCCACC9295A419A9999997C842241666666C6C2295A41CDCCCCCC1284224166666626BD295A41CDCCCCCC88832241333333F3B6295A41CDCCCCCC6283224100000080B4295A4133333333ED822241333333F3AC295A419A999999D882224133333393AC295A41CDCCCCCCCF82224166666626AC295A419A999999B4822241333333D3AB295A419A9999995682224133333393A9295A41CDCCCCCC33822241000000A0A8295A413333333306822241333333D3A6295A4166666666948122419A999999A0295A419A99999953812241CDCCCCEC9D295A419A999999C7802241666666A696295A41000000008D802241666666E693295A419A999999478022416666664690295A416666666627802241666666668E295A4133333333D17F22413333335389295A41CDCCCCCC6D7F2241CDCCCC2C84295A419A999999497F22419A99991982295A4133333333137F2241666666067F295A4133333333517E2241000000A072295A4100000000167E2241666666466E295A419A999999E97D2241666666866B295A4100000000D77D2241333333536A295A4133333333BA7D22410000002069295A419A999999287D2241666666A662295A4133333333987C2241000000605B295A41CDCCCCCC557C22410000002058295A4166666666987B2241666666E650295A4133333333637B2241CDCCCC6C51295A4166666666C57A22410000000051295A41000000009B7A2241666666E650295A4166666666967A2241CDCCCC2C55295A41CDCCCCCC8C7A2241000000805A295A419A999999897A22416666668663295A41000000007F7A2241000000606F295A41333333337E7A2241CDCCCC2C76295A4133333333807A2241CDCCCCAC79295A419A999999837A22419A9999197C295A41CDCCCCCC8C7A2241666666867E295A419A999999E07A2241333333338F295A41CDCCCCCCFD7A224100000020A4295A4100000000CF7A2241CDCCCCACB3295A4133333333FB7A22419A999999B7295A419A999999067B224133333353CE295A4133333333A47A2241CDCCCC6CE5295A41CDCCCCCC467A2241CDCCCC8CF1295A419A999999557A2241000000C0F2295A4133333333BC7A2241CDCCCC6CF7295A4100000000D97A224100000020F9295A419A999999057B22419A999939FD295A41CDCCCCCC107B2241666666A6FE295A419A999999607B2241666666C6082A5A4166666666497B2241666666460D2A5A419A999999117B22419A9999D9192A5A4166666666D67A22419A999979242A5A4166666666797A2241000000204A2A5A41CDCCCCCC6E7A2241333333934E2A5A4100000000C97A2241333333B3562A5A41CDCCCCCCB07A2241CDCCCC0C5B2A5A419A9999999A7A2241666666065F2A5A4133333333907A2241000000E0612A5A41000000008B7A2241666666A6652A5A41666666668A7A2241666666466A2A5A4100000000147A224166666646722A5A4133333333E979224133333333752A5A4100000000197A22419A9999D98F2A5A41333333331C7A2241000000C08F2A5A41CDCCCCCC777A2241666666468D2A5A41CDCCCCCCDF7A2241333333738A2A5A4100000000ED7A2241CDCCCCEC962A5A4100000000F07A22419A9999B9992A5A4166666666F67A2241666666E69D2A5A4166666666F57A2241CDCCCC4C9E2A5A41CDCCCCCCF67A2241333333F3A22A5A419A999999127B224133333333E32A5A4100000000037B22419A999979EC2A5A4133333333FA7A2241000000E0F02A5A4166666666F77A224166666686F32A5A4100000000F87A224166666626F92A5A4133333333FD7A224133333373FA2A5A4100000000F07A22419A9999B9FE2A5A41CDCCCCCCB57A224166666646FA2A5A41333333330F7A22419A9999F9F32A5A4166666666CB792241CDCCCCACF62A5A4166666666C87922419A9999D9F62A5A410000000096792241CDCCCC2CF82A5A416666666686792241333333D3F82A5A419A9999998179224166666606F92A5A419A99999971792241CDCCCC4CFA2A5A416666666630792241CDCCCC4CFC2A5A4166666666F9782241000000A0FE2A5A4166666666C4782241000000C0022B5A41CDCCCCCC4A782241000000400C2B5A41	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	01010000206A080000AA086CB4DA802241343333332C2B5A41	780530000	Z	Béhoust	7805300	78053	78	11	5
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	01010000206A080000B2A88568012F224133333333C7425A41	780570000	Z	Bennecourt	7805700	78057	78	11	7
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	01060000206A08000001000000010300000001000000E10000009A999999D7C12241CDCCCCECF02D5A41CDCCCCCCB1C22241000000C0F02D5A413333333360C222419A999979222E5A4100000000F2C1224133333313552E5A41666666666CC22241666666C6582E5A416666666650C2224100000080762E5A41333333333EC22241333333338F2E5A413333333368C22241CDCCCC8C992E5A4100000000D9C1224166666626E22E5A41333333331DC322419A999959EC2E5A4166666666D9C222419A9999B9392F5A410000000076C42241333333933D2F5A413333333399C422419A9999D91F2F5A419A9999992BC7224166666686302F5A416666666625C722419A9999993A2F5A41CDCCCCCC14CA22419A9999994D2F5A416666666644CA2241CDCCCC6C422F5A419A999999A7CA22419A9999B9412F5A413333333342CB22419A9999993E2F5A413333333308CC2241666666063E2F5A41666666667BCD2241CDCCCCCC322F5A4100000000ACCD2241333333F3312F5A413333333382CE22419A999979322F5A41CDCCCCCC41CF2241666666C63C2F5A410000000008D0224166666666512F5A419A99999960D02241333333935B2F5A41CDCCCCCC09D12241000000006B2F5A41CDCCCCCC9DD1224133333353742F5A419A99999943D22241666666A67A2F5A4133333333CFD22241000000E07C2F5A419A99999918D32241666666267F2F5A4166666666B3D32241CDCCCCAC872F5A419A99999937D42241CDCCCC2C952F5A419A99999978D422419A9999599E2F5A4133333333B0D42241CDCCCCECA82F5A4166666666F2D42241333333B3B32F5A410000000017D52241000000A0B72F5A416666666672D52241CDCCCCACBC2F5A41CDCCCCCC49D6224166666646C22F5A4133333333C3D62241333333B3C72F5A410000000036D722419A999919992F5A41333333334FD72241CDCCCC8C992F5A41CDCCCCCC8ED72241666666C6932F5A419A999999D9D7224100000020852F5A41333333330ED82241CDCCCCEC7E2F5A416666666685D82241666666E67A2F5A41CDCCCCCC8BD822419A9999B9802F5A416666666659D8224133333353842F5A416666666662D8224166666686872F5A41666666669AD8224166666686892F5A419A99999998D82241333333D38D2F5A419A99999940D82241CDCCCCEC8F2F5A416666666654D8224166666606982F5A410000000077D822419A999959982F5A41CDCCCCCC70D82241000000E09B2F5A41333333331AD8224100000080A12F5A410000000020D822419A999979A82F5A413333333382D8224166666686AB2F5A416666666680D822419A999999B02F5A419A99999923D8224133333353B22F5A4166666666E4D7224166666666AF2F5A4100000000C8D7224133333333B02F5A419A999999C0D72241CDCCCC4CB42F5A419A99999903D822419A999939B82F5A41CDCCCCCC0CD82241CDCCCC0CBB2F5A419A999999F0D722419A999999BE2F5A413333333312D8224166666606C72F5A4166666666E2D7224133333353D02F5A41CDCCCCCC13D82241000000A0CF2F5A413333333376D82241333333B3D12F5A410000000071D822419A999959D82F5A4133333333D9D822419A999939DA2F5A416666666648D922419A9999D9D52F5A41CDCCCCCC94D922419A9999B9D02F5A41CDCCCCCCDBD922419A9999B9C82F5A41CDCCCCCC91DA224133333313C32F5A419A999999BEDA2241CDCCCCECC02F5A413333333319DB224166666686B42F5A413333333366DB2241333333B3AE2F5A4133333333B4DB224166666626A72F5A41666666661DDC22419A9999599E2F5A416666666674DC2241CDCCCC8C942F5A4166666666A3DC2241333333B38A2F5A41CDCCCCCCBFDC224166666666872F5A4166666666FDDC2241CDCCCC2C842F5A410000000065DD2241000000C07C2F5A416666666692DD2241000000207B2F5A410000000034DE22419A9999B9722F5A41333333336FDE22419A9999196E2F5A4133333333E3DE2241333333F3622F5A419A99999917DF2241666666465C2F5A419A99999943DF224100000060532F5A41CDCCCCCC91DF2241CDCCCCCC3B2F5A4166666666F7DF2241000000A0292F5A413333333349E02241666666061E2F5A419A9999996BE0224100000020162F5A413333333311E022419A999999122F5A41CDCCCCCCB4DE22419A9999F9E82E5A416666666659DE22419A999979F42E5A419A999999CCDD2241333333B3042F5A416666666607DD22419A999919192F5A4133333333C6DC2241000000E01C2F5A410000000006DC22419A9999392B2F5A419A99999922DC224166666626092F5A416666666625DC224166666606022F5A413333333372DC22419A999979CE2E5A413333333399DC22419A999979AF2E5A4100000000CADC2241333333B3902E5A41CDCCCCCC7ADD224133333313132E5A41333333330EDE2241333333B3AC2D5A41CDCCCCCC34DE2241CDCCCC0C932D5A419A99999974DE2241CDCCCC4C652D5A413333333369DE2241CDCCCC0C622D5A41CDCCCCCCD1DD224100000080602D5A410000000061DD224166666606622D5A4100000000D1DC2241CDCCCC6C652D5A410000000094DC2241CDCCCC6C652D5A41CDCCCCCC48DC2241000000A0632D5A419A99999920DC2241000000A05F2D5A419A9999991ADC2241333333335C2D5A419A99999923DC2241000000004F2D5A410000000019DC22419A999999432D5A419A999999FADB2241666666E6382D5A4100000000A6DB2241CDCCCC6C2C2D5A41CDCCCCCC6BDB224166666646282D5A4166666666B7DB224133333393202D5A4100000000DCDD22419A9999D9ED2C5A410000000070DD2241CDCCCC8CE72C5A41CDCCCCCCFCDC2241333333F3E42C5A41CDCCCCCC8FDC2241CDCCCC2CE62C5A419A9999993FDC22419A9999B9EA2C5A4133333333E1DB22419A999919F22C5A419A9999994FDB2241CDCCCC8CFE2C5A4100000000E6DA224133333373062D5A4166666666DDD92241666666061D2D5A4133333333C9D92241333333131E2D5A419A999999C2D9224100000060122D5A413333333394D92241CDCCCCAC062D5A416666666684D922419A999919FA2C5A419A99999950D92241333333F3EA2C5A410000000060D92241CDCCCCCCE22C5A4166666666AED92241000000C0DA2C5A419A9999992CDA2241CDCCCC2CCA2C5A410000000051DA224133333353C72C5A41CDCCCCCCD9DB2241000000A0AC2C5A419A9999995ADC224133333313A02C5A41CDCCCCCCD1DC2241CDCCCCAC902C5A410000000036DD2241000000A07D2C5A419A99999964DD2241CDCCCCEC6B2C5A41000000006ADD22419A9999395D2C5A41666666666EDD2241333333F31F2C5A41CDCCCCCC69DD22419A9999B9E82B5A413333333362DD22419A9999D9D42B5A419A9999994FDD2241666666E6CA2B5A4166666666E2DC2241333333D3A52B5A410000000075DC22419A999999822B5A416666666627DC2241CDCCCC6C602B5A41666666661EDC22419A999999572B5A41CDCCCCCCB5DB2241CDCCCC6C322B5A41CDCCCCCC22D8224166666606412B5A4133333333C7D72241333333B33B2B5A4100000000A2D72241000000002F2B5A416666666609D7224133333313352B5A419A9999990DD72241CDCCCC8C3B2B5A410000000004D62241666666C6442B5A419A99999973D52241666666A6EA2A5A41CDCCCCCCDDD42241CDCCCC0CF42A5A41666666668ED42241CDCCCC2CDE2A5A4100000000D3D2224166666646F52A5A413333333369D222419A9999B9D72A5A419A9999991FD22241CDCCCCECDA2A5A4166666666BAD0224166666626E02A5A419A9999990CD02241000000C0E42A5A41000000000ACE224166666606ED2A5A419A9999998FCD224133333333F02A5A413333333318CE2241000000C0452B5A4100000000A6CC2241666666C6482B5A41000000006FCB2241000000A04B2B5A419A9999991FCB22419A9999F94C2B5A41CDCCCCCCF1CA2241000000E0272B5A41666666667BC82241CDCCCCEC242B5A413333333312C822419A9999B9242B5A4166666666EDC72241CDCCCC4C082B5A41CDCCCCCCCBC7224100000040EA2A5A41CDCCCCCCBBC72241CDCCCCECD22A5A41CDCCCCCC7FC722419A9999D9892A5A41CDCCCCCC66C72241666666C6872A5A41CDCCCCCCF5C622419A999979892A5A419A999999A4C522419A9999398D2A5A41666666663DC522419A9999198F2A5A4133333333DFC42241666666E6912A5A419A99999956C42241333333139E2A5A416666666662C32241000000C0B22A5A419A9999990CC3224133333373BC2A5A410000000002C322419A999939BF2A5A41CDCCCCCC1FC3224133333373C92A5A410000000094C32241CDCCCC8CEC2A5A41000000007EC32241666666E6FE2A5A419A99999996C3224100000020292B5A41CDCCCCCCA1C3224166666646332B5A4133333333D8C32241333333734F2B5A4133333333E5C32241333333B3592B5A41CDCCCCCCF7C322419A9999F9732B5A4166666666FCC32241333333B3922B5A413333333302C4224166666666A32B5A419A99999926C422419A9999F9CE2B5A410000000067C4224133333393122C5A41CDCCCCCC61C42241CDCCCCCC182C5A4166666666AFC42241CDCCCCCC4F2C5A419A99999972C5224133333333822C5A4133333333D2C52241000000807A2C5A41CDCCCCCCA6C62241000000C06C2C5A416666666630C7224166666666642C5A41CDCCCCCC67C72241333333136B2C5A419A99999928C8224166666626E62C5A41333333333AC82241000000C0EE2C5A41CDCCCCCC21C722419A999959122D5A419A99999926C62241CDCCCCCC322D5A4133333333C7C22241CDCCCC0CA42D5A410000000009C22241666666C6A52D5A41CDCCCCCC6BC2224133333353BE2D5A41000000005FC22241000000C0C52D5A41000000001EC22241CDCCCC0CC42D5A419A999999D7C12241CDCCCCECF02D5A419A999999D7C12241CDCCCCECF02D5A41	01010000206A080000A54C8D80FDD02241CDCCCCAC312D5A41	780620101	H	Le Bourg et Les Hameaux	7806201	78062	78	11	14
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	01060000206A0800000100000001030000000100000024000000CDCCCCCC4FD922419A999959E82C5A413333333359D92241333333B3EE2C5A416666666684D922419A999919FA2C5A413333333394D92241CDCCCCAC062D5A419A999999C2D9224100000060122D5A4133333333C9D92241333333131E2D5A4166666666DDD92241666666061D2D5A4100000000E6DA224133333373062D5A419A9999994FDB2241CDCCCC8CFE2C5A4133333333E1DB22419A999919F22C5A419A9999993FDC22419A9999B9EA2C5A41CDCCCCCC8FDC2241CDCCCC2CE62C5A41CDCCCCCCFCDC2241333333F3E42C5A410000000070DD2241CDCCCC8CE72C5A4100000000DCDD22419A9999D9ED2C5A410000000029DF2241666666C6CE2C5A4133333333B8DF2241333333B3C02C5A41000000001DE0224166666606B52C5A410000000012E022419A999999AF2C5A419A99999994DE224166666646352C5A4100000000F7DD224166666686052C5A41CDCCCCCC62DD22419A9999F9D62B5A41CDCCCCCC69DD22419A9999B9E82B5A41666666666EDD2241333333F31F2C5A41000000006ADD22419A9999395D2C5A419A99999964DD2241CDCCCCEC6B2C5A410000000036DD2241000000A07D2C5A41CDCCCCCCD1DC2241CDCCCCAC902C5A419A9999995ADC224133333313A02C5A41CDCCCCCCD9DB2241000000A0AC2C5A410000000051DA224133333353C72C5A419A9999992CDA2241CDCCCC2CCA2C5A4166666666AED92241000000C0DA2C5A410000000060D92241CDCCCCCCE22C5A41CDCCCCCC4FD922419A999959E82C5A41CDCCCCCC4FD922419A999959E82C5A41	01010000206A0800003E485D8756DE22419A9999B97B2C5A41	780620102	H	Les Chênes Le Renouveau et l'Estandart	7806201	78062	78	11	0
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	01010000206A080000A0A0F9D08BE42241666666C6B42D5A41	780620103	H	Le Val des Quatre Pignons et Quartier Général Laurier	7806201	78062	78	11	4
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	01010000206A08000071C365A1D6FA2141CDCCCCBC1D425A41	780680000	Z	Blaru	7806800	78068	78	11	15
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	01010000206A080000629ABB10C08F2241CDCCCC7C61355A41	780700000	Z	Boinville-en-Mantois	7807000	78070	78	11	5
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	01010000206A080000A66FD41DD0D02241343333E36D065A41	780710000	Z	Boinville-le-Gaillard	7807100	78071	78	11	13
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	01010000206A0800004F9D310AB65D22410000004094345A41	780720000	Z	Boinvilliers	7807200	78072	78	11	4
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	01060000206A0800000100000001030000000100000034000000CDCCCCCC06312341000000803C275A419A9999990C3123419A9999794B275A419A999999383123419A99999962275A416666666647312341666666E666275A4133333333CD3123419A9999D981275A4166666666B032234100000040C4275A41CDCCCCCC08332341CDCCCCCCDC275A41666666663C332341CDCCCC0CE4275A41000000002F3323419A999979EA275A410000000048332341000000E0F8275A41333333336533234166666606FC275A41CDCCCCCCCA332341CDCCCCACFA275A4133333333D63323419A999959EF275A4133333333E63323419A9999D9ED275A419A9999999835234166666606D7275A41666666663736234100000080CF275A41333333336C36234166666666DB275A4166666666BC362341666666E6D3275A41000000009C36234166666606C8275A41000000001E37234166666606BC275A419A9999996837234133333353B2275A419A9999998A37234100000060A8275A419A999999CB372341CDCCCC4CA4275A419A9999994B38234100000060A6275A419A9999992339234166666626A0275A41CDCCCCCC383923419A999919A0275A41666666668639234133333373BA275A4166666666243A2341CDCCCC8CB4275A419A9999997E3A234100000020A8275A4133333333153B23419A99997995275A41666666663B3C2341000000A06F275A41333333338E3C23419A9999D965275A419A9999993C3C23419A9999994C275A4166666666E03B2341CDCCCCEC2B275A41CDCCCCCCA63B23416666662619275A419A999999F33A23419A9999991D275A419A9999998F3A2341333333531F275A4100000000CB392341333333B324275A419A9999990C382341333333332F275A4100000000CA3723419A9999D92F275A41000000002F372341000000802F275A4100000000C4362341CDCCCCEC2C275A4100000000133623419A99997925275A41666666669F3423416666666616275A4166666666753323419A9999F90A275A41CDCCCCCC7C322341CDCCCCACFF265A4100000000A2312341333333D3F6265A41CDCCCCCC6F312341000000C005275A413333333325312341333333F31F275A416666666613312341333333D327275A41CDCCCCCC06312341000000803C275A41CDCCCCCC06312341000000803C275A41	01010000206A08000007BD0447CA362341CDCCCCBC78275A41	780730105	H	La Chapelle Saint-Jean	7807301	78073	78	11	1
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	01060000206A08000001000000010300000001000000240000009A99999935262341666666A60D275A419A9999997A262341000000C012275A419A999999FC262341666666A613275A419A999999392723410000002017275A4133333333482723413333337313275A41000000009F282341CDCCCCCC21275A416666666607292341CDCCCC2C28275A4133333333BD2C23419A9999D968275A41CDCCCCCCB42C2341000000C064275A4100000000922D23413333331366275A41666666668E2D23419A9999994D275A4133333333D92D2341333333D34B275A4133333333D62D2341000000C03F275A4133333333C42E23413333333338275A419A999999962E23410000000030275A4100000000F62E2341CDCCCCEC25275A419A999999D62F23416666666620275A41CDCCCCCCEA2F2341000000C02D275A4166666666DF302341CDCCCC2C22275A413333333325312341333333F31F275A41CDCCCCCC6F312341000000C005275A4100000000A2312341333333D3F6265A419A999999F7302341CDCCCC4CF2265A4166666666F32F234166666686F0265A4133333333312F2341666666E6F0265A4166666666A52D2341333333F3F4265A4166666666242C234100000040F8265A4133333333222C2341CDCCCC4CF5265A41666666661F2B23419A9999D9F8265A41CDCCCCCC2D2A2341CDCCCC2CFD265A410000000080282341CDCCCC8C05275A4166666666FE272341666666C607275A419A999999EE2723419A99997906275A4100000000992723410000008007275A419A99999935262341666666A60D275A419A99999935262341666666A60D275A41	01010000206A080000C718639CFF2B2341333333132D275A41	780730106	H	La Butte du Moulin	7807301	78073	78	11	0
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	01060000206A080000010000000103000000010000001A000000CDCCCCCC3C282341CDCCCCACBD275A41000000004F28234166666646BF275A419A9999999228234166666686D0275A4100000000E228234133333313D4275A419A999999F928234166666666E1275A4100000000E72923419A999959DB275A41CDCCCCCC182B2341666666E6CE275A4133333333272C234166666646C5275A41000000007B2C234100000040C1275A41CDCCCCCCBB2C2341000000C0BC275A41CDCCCCCCF92C2341000000E0B6275A4100000000162D2341666666A6AD275A41666666660E2D2341666666E67C275A4100000000312D23416666664670275A4133333333E52C2341333333B36B275A4100000000862B2341CDCCCCAC53275A41CDCCCCCC312B2341333333B35D275A4166666666572A23419A9999B96C275A4100000000AD292341666666467D275A419A999999BD2923416666664688275A41000000006E292341333333138A275A419A99999929292341333333338D275A410000000019292341666666269A275A4166666666B028234100000040AF275A41CDCCCCCC3C282341CDCCCCACBD275A41CDCCCCCC3C282341CDCCCCACBD275A41	01010000206A08000098F644AE0F2B2341000000909C275A41	780730103	H	L'Église	7807301	78073	78	11	0
01060000206A0800000100000001030000000100000090000000333333337E2723419A9999D93D285A4133333333C9272341666666264B285A4100000000D82823419A9999F932285A419A9999994D2923419A99997928285A4133333333842923416666664624285A41CDCCCCCCF5292341CDCCCC6C1B285A419A9999990C2A23410000004019285A41000000003A2A2341333333B315285A41CDCCCCCC922A2341666666E60E285A4166666666C42A23419A9999190B285A41333333330D2B23416666666605285A41666666661F2B23410000000004285A4133333333572B2341CDCCCC2C00285A41CDCCCCCC912B2341CDCCCC8CFB275A4100000000CF2B23419A9999B9F6275A41CDCCCCCC0A2C234166666606F2275A41333333334D2C2341666666C6EC275A41666666665C2C2341333333D3EB275A41CDCCCCCC702C2341CDCCCC6CEA275A419A9999999A2C234133333333E7275A41333333335A2D234100000060D8275A41000000008F2D2341CDCCCCECD3275A41CDCCCCCCC32D2341666666E6CE275A4166666666062E2341CDCCCC0CCA275A419A999999432E23419A999939C4275A41333333335E2E2341CDCCCCCCC1275A4166666666822E2341333333D3BF275A4133333333982E2341333333F3BE275A4166666666AA2E2341CDCCCC0CBE275A41CDCCCCCCBD2E23419A999979BC275A4100000000C92E23419A999919BB275A4100000000D62E2341CDCCCCECBA275A4100000000E92E234133333373BA275A4166666666F52E234166666686B9275A4166666666132F2341000000C0B7275A4133333333202F2341CDCCCCACB6275A4100000000322F2341CDCCCC8CB5275A419A999999492F2341CDCCCC2CB4275A4166666666572F23419A999999B3275A41CDCCCCCC692F234100000020B2275A41000000007D2F2341CDCCCC6CB0275A4100000000922F234166666646AF275A41CDCCCCCC9D2F2341666666A6AE275A4100000000B42F23419A9999F9AD275A4100000000C42F2341333333B3AD275A4166666666D82F234166666606AD275A41CDCCCCCCD03123419A9999F982275A4133333333CD3123419A9999D981275A41333333336A312341666666C66D275A416666666647312341666666E666275A419A999999383123419A99999962275A41CDCCCCCC2F312341CDCCCCCC5E275A419A99999919312341666666C653275A419A9999990C3123419A9999794B275A41333333330B3123419A9999B949275A416666666607312341666666E644275A41CDCCCCCC06312341000000803C275A41333333330B312341CDCCCC8C30275A416666666613312341333333D327275A413333333325312341333333F31F275A4166666666DF302341CDCCCC2C22275A4100000000C2302341000000A023275A410000000099302341666666A625275A419A9999995C3023413333339328275A4166666666223023419A9999592B275A41CDCCCCCCEA2F2341000000C02D275A419A999999D62F23416666666620275A41CDCCCCCC282F2341000000A024275A4100000000F62E2341CDCCCCEC25275A419A999999962E23410000000030275A41CDCCCCCCA22E23410000006032275A4133333333C42E23413333333338275A4100000000142E2341CDCCCCCC3D275A4133333333D62D2341000000C03F275A4133333333D92D2341333333D34B275A4100000000952D2341CDCCCC4C4C275A41666666668E2D23419A9999994D275A419A999999912D2341CDCCCC0C5D275A4100000000922D23413333331366275A419A999999162D23413333335365275A41CDCCCCCCB42C2341000000C064275A41CDCCCCCCB92C23419A99999967275A4133333333BD2C23419A9999D968275A4133333333E52C2341333333B36B275A41000000000C2D2341333333336E275A41CDCCCCCC1F2D2341CDCCCC6C6F275A4100000000312D23416666664670275A4166666666272D23416666664673275A41333333331A2D23416666660677275A41CDCCCCCC0F2D2341000000407A275A41333333330E2D23419A9999197C275A41666666660E2D2341666666E67C275A419A999999112D23413333335395275A4100000000122D23410000006098275A4166666666122D2341CDCCCC0C9A275A4100000000162D2341666666A6AD275A4133333333122D234100000040B2275A419A999999002D23419A9999D9B5275A41CDCCCCCCF92C2341000000E0B6275A4100000000F22C2341666666C6B7275A4166666666E92C2341000000C0B8275A41CDCCCCCCDF2C2341333333B3B9275A41CDCCCCCCD02C23419A9999F9BA275A41CDCCCCCCBB2C2341000000C0BC275A419A999999A62C234133333353BE275A41000000007B2C234100000040C1275A419A999999582C234166666626C3275A419A9999993A2C2341CDCCCC6CC4275A4133333333272C234166666646C5275A4133333333DF2B2341CDCCCCACC7275A4166666666462B234100000020CD275A41CDCCCCCC182B2341666666E6CE275A4166666666452A234100000080D7275A41333333333A2A234100000000D8275A41CDCCCCCC1B2A23419A999959D9275A4100000000E72923419A999959DB275A41000000000729234133333313E1275A419A999999F928234166666666E1275A419A999999BC28234166666686E3275A41666666663F282341CDCCCC2CE7275A41333333331A28234166666626E8275A410000000015282341CDCCCC0CE8275A41333333331E282341CDCCCC8CEC275A410000000023282341CDCCCC2CEE275A419A999999292823419A999919F1275A419A9999993228234133333353F7275A41CDCCCCCC3628234133333373FF275A419A99999938282341CDCCCC0C07285A413333333332282341000000200D285A4166666666272823413333337311285A41333333331F282341000000A014285A416666666610282341333333D319285A4100000000FF272341333333D320285A4133333333FA272341333333B322285A419A999999F9272341333333F322285A419A999999E9272341333333932A285A4133333333D9272341000000C02E285A4166666666CA272341000000A031285A4166666666BE272341000000A033285A4100000000B82723419A9999B934285A4166666666AF2723419A99991936285A4133333333AE2723413333335336285A41000000008D272341000000803B285A41333333337E2723419A9999D93D285A41	01060000206A0800000100000001030000000100000032000000333333337E2723419A9999D93D285A4133333333C9272341666666264B285A419A9999994D2923419A99997928285A419A9999990C2A23410000004019285A41666666661F2B23410000000004285A4133333333572B2341CDCCCC2C00285A41333333334D2C2341666666C6EC275A41333333335A2D234100000060D8275A41CDCCCCCCC32D2341666666E6CE275A4166666666062E2341CDCCCC0CCA275A41333333335E2E2341CDCCCCCCC1275A4100000000E92E234133333373BA275A41CDCCCCCC9D2F2341666666A6AE275A4166666666D82F234166666606AD275A41CDCCCCCCD03123419A9999F982275A416666666647312341666666E666275A419A999999383123419A99999962275A419A9999990C3123419A9999794B275A41CDCCCCCC06312341000000803C275A416666666613312341333333D327275A413333333325312341333333F31F275A4166666666DF302341CDCCCC2C22275A41CDCCCCCCEA2F2341000000C02D275A419A999999D62F23416666666620275A4100000000F62E2341CDCCCCEC25275A419A999999962E23410000000030275A4133333333C42E23413333333338275A4133333333D62D2341000000C03F275A4133333333D92D2341333333D34B275A41666666668E2D23419A9999994D275A4100000000922D23413333331366275A41CDCCCCCCB42C2341000000C064275A4133333333BD2C23419A9999D968275A4100000000312D23416666664670275A41666666660E2D2341666666E67C275A4100000000162D2341666666A6AD275A41CDCCCCCCF92C2341000000E0B6275A41CDCCCCCCBB2C2341000000C0BC275A41000000007B2C234100000040C1275A4133333333272C234166666646C5275A41CDCCCCCC182B2341666666E6CE275A4100000000E72923419A999959DB275A419A999999F928234166666666E1275A410000000015282341CDCCCC0CE8275A419A9999993228234133333353F7275A419A99999938282341CDCCCC0C07285A413333333332282341000000200D285A4133333333D9272341000000C02E285A41333333337E2723419A9999D93D285A41333333337E2723419A9999D93D285A41	01010000206A0800007ED2279D212E2341CDCCCCDCB4275A41	780730104	H	Les Communes	7807301	78073	78	11	0
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	01010000206A080000F4E5DE69AE212341CCCCCCAC06285A41	780730107	D	Bois de la Couronne	7807301	78073	78	11	3
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	01060000206A080000010000000103000000010000002E000000666666662C242341CDCCCC2C16275A41333333335E2523413333335366275A419A999999002623419A9999598D275A41000000001E27234100000000D0275A41CDCCCCCC5026234100000040DC275A4166666666AA262341333333B3F6275A410000000054272341666666C6F2275A41000000003F272341333333B309285A4100000000E8262341000000400A285A4133333333E4262341000000E00E285A41CDCCCCCC33272341CDCCCC6C14285A419A99999935272341333333331F285A41CDCCCCCCF8262341000000601F285A419A999999F7262341666666862C285A419A99999978272341666666C632285A41CDCCCCCC5F272341666666A638285A41000000008D272341000000803B285A4166666666CA272341000000A031285A419A999999E9272341333333932A285A413333333332282341000000200D285A419A99999938282341CDCCCC0C07285A419A9999993228234133333353F7275A410000000015282341CDCCCC0CE8275A419A999999F928234166666666E1275A4100000000E228234133333313D4275A419A9999999228234166666686D0275A41000000004F28234166666646BF275A41CDCCCCCC3C282341CDCCCCACBD275A4166666666B028234100000040AF275A410000000019292341666666269A275A419A99999929292341333333338D275A41000000006E292341333333138A275A419A999999BD2923416666664688275A4100000000AD292341666666467D275A4166666666572A23419A9999B96C275A41CDCCCCCC312B2341333333B35D275A4100000000862B2341CDCCCCAC53275A416666666607292341CDCCCC2C28275A41000000009F282341CDCCCCCC21275A4133333333482723413333337313275A419A999999392723410000002017275A419A999999FC262341666666A613275A419A9999997A262341000000C012275A419A99999935262341666666A60D275A41666666662C242341CDCCCC2C16275A41666666662C242341CDCCCC2C16275A41	01010000206A08000011583944A427234100000090A4275A41	780730108	H	La Croix Blanche-Les Langots	7807301	78073	78	11	0
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	01010000206A0800001B2E5F22AA3422419A9999D90C2E5A41	780760000	Z	Boissets	7807600	78076	78	11	4
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	01060000206A080000010000000103000000010000001401000000000000083B2241000000209C1A5A41666666662F3B2241CDCCCC8CAA1A5A41CDCCCCCC5E3B22419A999999B71A5A419A999999853B224166666626BF1A5A4133333333B53B2241CDCCCC2CCB1A5A4133333333563C224133333373E41A5A4166666666763C22419A999939EA1A5A4133333333DE3C22419A9999D9051B5A4166666666743D2241666666862B1B5A4166666666DA3D2241666666C65B1B5A4133333333F03D22419A9999D96B1B5A4166666666F93D22419A9999997A1B5A419A999999163E2241333333D3931B5A4166666666323E22419A999979A11B5A4100000000C73F224100000020911B5A41000000009A402241000000C0841B5A41CDCCCCCC0841224133333333801B5A4100000000C1412241333333937B1B5A4133333333B7422241333333D3771B5A41666666662443224166666626701B5A416666666685432241666666A66B1B5A41666666663B442241CDCCCC4C601B5A41333333338B442241000000E05D1B5A41CDCCCCCC0945224166666686581B5A4166666666184522419A999919561B5A4166666666FB4522419A999999821B5A41333333337646224100000060961B5A419A999999E74622419A999939981B5A4133333333E5472241666666869E1B5A41666666662F48224133333333A41B5A41CDCCCCCC8048224133333393B01B5A4166666666E4472241000000A00A1C5A41CDCCCCCC40472241666666A62C1C5A41CDCCCCCC10472241333333F3341C5A4166666666E5462241666666263F1C5A41CDCCCCCCD2462241666666E6461C5A41CDCCCCCCCF462241CDCCCC8C501C5A41666666661C47224100000000501C5A41CDCCCCCC6A472241CDCCCC0C541C5A41CDCCCCCC41482241333333B3511C5A41000000008949224100000040501C5A41666666664D4A22419A999999521C5A41000000005F4B224100000080571C5A4166666666D94B2241333333535B1C5A4100000000874C2241CDCCCC2C5D1C5A41CDCCCCCC2C4D22419A999979621C5A41CDCCCCCCD84D2241000000606A1C5A4166666666064E2241666666666D1C5A4133333333794E224100000040781C5A4133333333AA4E2241CDCCCC0C7F1C5A41CDCCCCCCD94E2241CDCCCCCC8D1C5A41CDCCCCCC384F22419A9999798B1C5A4100000000A34F2241CDCCCC2C9E1C5A4100000000C04F224133333333A21C5A4100000000C44F2241CDCCCCCCA81C5A4133333333E94F2241CDCCCC4CAD1C5A41666666662350224100000060B01C5A41000000002D502241333333B3B71C5A41CDCCCCCC69502241CDCCCC6CBE1C5A41666666668B50224166666626C71C5A41CDCCCCCCB950224133333313DA1C5A4133333333DC502241000000C0D71C5A41000000004F512241333333B3FB1C5A4133333333CD512241333333B3211D5A4133333333A0512241CDCCCC8C221D5A41000000009A512241CDCCCC4C1D1D5A419A99999977512241CDCCCC8C1D1D5A41CDCCCCCCCE512241666666065C1D5A4100000000FE512241666666A6761D5A419A9999998552224166666626D41D5A41333333334753224166666626DD1D5A41000000007D532241000000E0DE1D5A41CDCCCCCCF353224133333393DF1D5A4166666666D455224133333393DF1D5A4166666666AD562241CDCCCCCCDE1D5A419A99999940572241333333F3D61D5A41666666662C59224166666666B91D5A41000000005F592241333333B3B71D5A4100000000B25A2241333333F3A61D5A4166666666E35C2241000000A0861D5A41CDCCCCCC065D2241CDCCCCCC871D5A41666666669F5D22419A9999996D1D5A41666666661360224166666626761D5A4100000000F6602241CDCCCC8C791D5A4100000000696122419A9999797C1D5A41333333334462224166666686801D5A41666666669A62224100000060841D5A4100000000B262224100000020871D5A413333333316632241CDCCCCAC9D1D5A419A9999997E632241333333F3B01D5A41CDCCCCCC9B632241000000E0B31D5A419A9999996C642241CDCCCC0CC41D5A4100000000F4642241CDCCCC2CD01D5A41CDCCCCCCD565224166666626E11D5A41333333335E6622419A999999F01D5A41000000005E662241CDCCCC2CFB1D5A41666666667F6622419A9999B90C1E5A4166666666A666224133333313161E5A41CDCCCCCC0C672241666666E61C1E5A41000000008D672241CDCCCC4C1C1E5A41CDCCCCCCAB6722419A9999591A1E5A4100000000EF672241000000201C1E5A419A999999656822419A9999B9241E5A41CDCCCCCCA8682241666666A6321E5A4100000000D468224133333333371E5A419A99999963692241000000603B1E5A41CDCCCCCC86692241CDCCCC6C3B1E5A4166666666216A224100000060451E5A41CDCCCCCC4F6B2241CDCCCC0C581E5A4166666666616B2241333333D3591E5A41333333332B6C2241000000E0461E5A41000000006B6C224166666686421E5A4100000000B46C2241333333533F1E5A4166666666B46D2241CDCCCC4C381E5A41000000000B6E224100000000351E5A4166666666156E224166666626381E5A4133333333326F2241000000E0311E5A41CDCCCCCC257022419A9999F9311E5A41CDCCCCCC2C71224100000020311E5A41000000000C722241333333D3311E5A41CDCCCCCC2B73224166666606321E5A4100000000C5732241333333533D1E5A416666666650752241CDCCCC8C561E5A416666666651762241333333D3351E5A4166666666F176224100000040231E5A4133333333AC7622419A999979191E5A4100000000CA752241CDCCCC4CFD1D5A4166666666357522419A9999F9E81D5A41000000001775224133333373E61D5A41333333331C75224133333393DE1D5A419A9999993D75224133333333D31D5A41CDCCCCCC8F752241666666A6C71D5A4133333333C4752241666666A6BD1D5A4133333333E4752241333333D3B01D5A41000000000F76224133333373A91D5A4100000000A276224166666626991D5A4166666666C377224100000000601D5A41CDCCCCCC1A782241CDCCCCEC4D1D5A41CDCCCCCCDA782241333333F31E1D5A41666666664879224100000000061D5A4133333333C679224166666686E61C5A41666666661B7A2241000000C0D21C5A4133333333D37A224166666666A41C5A419A999999247B22419A999979901C5A4100000000F67B2241CDCCCC8C841C5A41CDCCCCCC2A7E2241CDCCCCEC641C5A4100000000467F224133333353541C5A419A9999995080224133333353451C5A41CDCCCCCC2C802241000000E0421C5A4100000000A97E224166666686301C5A41333333332E7E22419A9999192A1C5A41CDCCCCCC6D7D2241CDCCCC0C1F1C5A41CDCCCCCC0D7D2241333333131A1C5A4100000000CB7C224166666686151C5A4133333333567B22419A9999F9F51B5A41CDCCCCCC437922419A9999F9CC1B5A4166666666E277224133333373AB1B5A41666666662C772241666666E6981B5A4100000000C37522419A9999B96E1B5A419A999999DC742241CDCCCCAC421B5A419A9999999674224166666646341B5A4133333333E0732241CDCCCC8C081B5A419A999999A571224100000000D01A5A41000000001671224100000040C31A5A41000000004D70224100000040AF1A5A410000000042702241000000E0A91A5A416666666626702241666666E6A91A5A41000000005E6F224166666686811A5A419A999999D16E2241333333B3661A5A41000000009E6E224133333333481A5A4166666666946E2241333333F33F1A5A4133333333FE6D2241333333F30A1A5A419A999999E06D22419A9999D9F8195A41CDCCCCCC5B6D2241CDCCCC2CDE195A4100000000076D224166666646D5195A4133333333AB6C22419A999979CD195A41CDCCCCCC136B224133333313B4195A4100000000736A2241333333D3AA195A4100000000FF6922419A9999D9A1195A419A999999B1692241000000E09A195A4133333333B76822413333331399195A41000000003A682241333333339E195A416666666686672241333333B3A0195A41000000003F6722419A999939A4195A41CDCCCCCCC16622419A999919AC195A41000000009D662241CDCCCCECAC195A41333333335A6622419A999959AA195A41CDCCCCCC24662241666666E6A9195A41CDCCCCCCE8652241CDCCCC8CAC195A4100000000BC6522419A999999B0195A419A9999998F6522419A9999D9B7195A410000000047652241CDCCCCACC0195A4100000000F1642241333333F3C8195A4133333333A164224100000080CC195A419A9999992964224166666626CC195A41CDCCCCCCCD63224133333313D5195A41CDCCCCCC836322419A99991987195A41CDCCCCCC44632241666666A690195A41CDCCCCCCB6622241CDCCCCECA9195A419A999999406222419A999939C2195A416666666649602241000000609B195A41CDCCCCCC416022419A9999999E195A419A999999E95F224133333393B1195A419A9999996A5F22419A999999C5195A4100000000F05E224166666626D6195A41CDCCCCCC5F5E224133333373EA195A41000000008A5D224100000020DD195A41CDCCCCCC825C224166666686D0195A4166666666595C22419A999919CE195A4133333333BA5B224133333393BD195A419A999999655B2241CDCCCCACB7195A4166666666A25A224133333373AB195A41CDCCCCCCC85922419A9999399C195A419A999999425922419A99995995195A4166666666115822416666660689195A4100000000D85722413333331388195A41CDCCCCCCCE552241CDCCCC4CC2195A419A999999FA54224166666606D1195A419A9999994954224133333313DF195A41666666666F532241CDCCCC4CEF195A41CDCCCCCCFF52224133333353F9195A4166666666E452224100000060FD195A413333333328512241333333B31A1A5A41CDCCCCCC5B50224166666686FE195A41000000002A5022419A999979ED195A4133333333ED4F224166666646DF195A4166666666734F224100000080C0195A4166666666E64E22419A999999A9195A4133333333DB4E2241000000C0B1195A41CDCCCCCCEF4E22419A9999B9BB195A41333333333E4F224133333393CB195A41666666662E4F2241333333F3D3195A4133333333E64E2241CDCCCC6CD6195A4100000000B44E22419A999959D5195A4166666666704E2241000000A0D0195A4166666666CF4D2241CDCCCC4CC2195A41CDCCCCCC8C4D224100000060B9195A41333333331E4D224166666686AC195A4166666666764C22419A9999D99C195A41CDCCCCCCA14B2241CDCCCC0C8C195A41333333330D4A22419A99991972195A419A999999434922413333335366195A419A99999980482241CDCCCCEC5B195A419A9999991A482241333333D36E195A4100000000A6472241000000E068195A416666666671472241666666266A195A41CDCCCCCC22472241333333536E195A4166666666C9462241666666666E195A419A999999C9462241333333136D195A419A999999564622419A9999F96C195A4166666666134622419A9999596E195A41666666667B4522416666660673195A4133333333EA452241666666A69B195A410000000075452241333333339A195A41CDCCCCCC52452241CDCCCCCC98195A41CDCCCCCC52452241333333D3A3195A410000000048452241333333D3A9195A41CDCCCCCC2645224166666666B2195A41CDCCCCCCFC442241CDCCCCACB8195A4133333333CA442241CDCCCCACBD195A41333333338444224133333313C7195A41CDCCCCCC0B4422419A999999DE195A41666666665E432241CDCCCCCCFA195A41CDCCCCCCE5422241333333D30A1A5A41000000004042224100000060231A5A413333333335412241000000204F1A5A41000000000041224100000080491A5A416666666688402241CDCCCCEC561A5A419A999999B44022419A9999595E1A5A416666666663402241CDCCCC4C671A5A4100000000DF3F224166666646731A5A41000000003C3F2241333333937F1A5A4166666666923E2241CDCCCCEC891A5A4133333333853E2241333333B3831A5A4100000000083B2241000000209C1A5A4100000000083B2241000000209C1A5A41	01010000206A080000452A106C0F612241CDCCCC7CD91B5A41	780770000	Z	La Boissière-École	7807700	78077	78	11	26
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	01060000206A080000010000000103000000010000008500000000000000E62322419A99993941395A41CDCCCCCC70242241000000A053395A419A999999B1242241333333335A395A41CDCCCCCC1F252241666666A661395A41CDCCCCCC452522413333331366395A419A9999994C252241CDCCCC0C6B395A4133333333C02522413333333372395A4100000000062622416666666674395A419A999999112622416666662688395A41000000004626224133333313A9395A419A99999918262241CDCCCC4CB4395A416666666633272241000000A0D0395A41CDCCCCCC962A2241CDCCCC0C393A5A4166666666AA2A224166666686353A5A41666666666C2D2241333333939A3A5A41000000005A2D224100000060A03A5A419A999999952E2241666666E6983A5A419A999999D92E22419A999999993A5A41000000004B2F2241666666E69F3A5A419A999999B62F224100000040A73A5A41CDCCCCCC1F2F224166666606C03A5A4166666666FF2F224166666646D63A5A416666666623302241333333F3DB3A5A41CDCCCCCC3130224133333313DA3A5A419A999999B43022419A999959DE3A5A419A999999E531224133333313E73A5A419A999999B132224166666646F03A5A41CDCCCCCCF7322241000000C0F43A5A4166666666A7332241CDCCCC2C0D3B5A41CDCCCCCC8C34224166666666203B5A4133333333B53422419A9999F9253B5A41000000003435224133333313223B5A41666666665C352241CDCCCCEC1B3B5A41666666660E3622419A9999F9103B5A4100000000BF362241333333B3023B5A419A999999783722419A999919103B5A4166666666D3372241CDCCCC4C153B5A41CDCCCCCCAC3822419A9999B9063B5A41CDCCCCCCC53922419A999979FD3A5A4133333333D8392241CDCCCCEC053B5A41000000008B3A224133333353FE3A5A41CDCCCCCC6C3A22419A9999F9F23A5A4133333333493B224166666626E93A5A4100000000B43B224166666606F33A5A4100000000FE3B224133333373EA3A5A41333333331B3C22419A9999B9F03A5A41666666665E3C2241333333B3EB3A5A4133333333103D2241CDCCCC2CF63A5A41000000008A3D224133333313F43A5A4166666666C63D2241CDCCCCACF73A5A41CDCCCCCC163E2241CDCCCC4CFF3A5A41CDCCCCCC933E2241666666A6F73A5A41CDCCCCCCD43E22419A999979F43A5A4166666666803F224100000080E93A5A4100000000F23F22419A9999D9EB3A5A41000000001A402241333333D3E63A5A4100000000494022419A9999F9DD3A5A4133333333B740224166666686CB3A5A419A999999A13E224166666626B23A5A4166666666303E2241666666C69A3A5A41333333335C3E2241666666A6923A5A41000000004E3E2241000000808E3A5A4133333333113E22419A9999396D3A5A4100000000053E224166666666643A5A419A999999C63D2241333333D34F3A5A41666666668A3D224166666686323A5A41000000007C3D2241666666C62D3A5A4133333333213D2241000000601C3A5A4133333333F23C2241000000A0163A5A4133333333333D22419A9999F9073A5A4133333333223D224100000000063A5A41CDCCCCCCB63C224100000080FF395A41CDCCCCCC4C3C224133333313F5395A4166666666CC3B2241666666C6ED395A4166666666A53B2241CDCCCC6CE7395A41666666665B3B22419A9999B9D7395A4166666666F53A22419A999919CA395A4166666666C43A22419A9999B9C6395A41CDCCCCCC223A2241666666E6BD395A41CDCCCCCC213A2241CDCCCC8CBB395A419A999999EC392241CDCCCC6CB7395A41CDCCCCCC613922419A999959B4395A410000000023392241000000C0B1395A41333333335038224166666606A4395A41CDCCCCCC173822419A999919A1395A41CDCCCCCCC13722416666662697395A410000000045372241000000208F395A4133333333F4362241CDCCCC8C88395A4133333333C43622413333337382395A419A99999975362241CDCCCCAC7D395A41CDCCCCCC04362241CDCCCC0C70395A4166666666F5352241CDCCCCEC6C395A41CDCCCCCC5B3422419A99993944395A41333333330C342241333333133B395A413333333332332241333333D324395A419A999999C3322241000000E017395A41666666669231224133333313FD385A4100000000E93022419A999999EE385A4133333333533022419A999939E3385A41CDCCCCCC0530224133333313DF385A419A99999943302241CDCCCC6CD0385A419A9999995230224133333353C7385A41CDCCCCCC5330224100000040B0385A419A99999940302241333333D39D385A413333333310302241000000008E385A410000000009302241CDCCCC6C86385A41333333331B302241000000E079385A416666666617302241666666466F385A41CDCCCCCCF82F22419A9999795B385A4166666666B82F2241333333133F385A4133333333482F2241CDCCCCCC43385A4133333333272E22419A99991953385A4100000000BA2D22419A99991958385A4166666666762D22419A9999195D385A4100000000432C22416666666668385A41CDCCCCCC9A2B2241CDCCCC0C6E385A4100000000112B2241CDCCCC8C73385A4100000000D62A22419A99997977385A4166666666D8292241CDCCCCEC85385A416666666687292241333333B38C385A4100000000F628224133333313A2385A4100000000CA282241666666E6A6385A41000000006628224133333353AF385A419A999999AF272241CDCCCCACB7385A41CDCCCCCC9026224133333353C8385A41000000002E262241000000E0CC385A4100000000CD26224133333333F1385A4166666666D0262241333333F3F3385A416666666618262241000000A007395A41CDCCCCCC3F252241CDCCCCEC1D395A4133333333BF242241000000002C395A4100000000E62322419A99993941395A4100000000E62322419A99993941395A41	01010000206A08000012141017A92F224100000080B2395A41	780820000	Z	Boissy-Mauvoisin	7808200	78082	78	11	5
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	01010000206A080000F626981CECAB2241666666D6D0295A41	780840000	Z	Boissy-sans-Avoir	7808400	78084	78	11	4
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	01060000206A08000001000000010300000001000000CF00000000000000F31E234166666686DC115A41CDCCCCCC5E1F2341666666A6E0115A41CDCCCCCCF21F2341666666A6E3115A41CDCCCCCC22202341666666C6E3115A41CDCCCCCC5921234166666626FD115A419A9999990A2223419A9999390B125A410000000001222341CDCCCCAC0F125A41CDCCCCCC54222341CDCCCC0C1D125A416666666692222341000000E024125A419A999999B8222341333333732C125A4133333333132323416666666643125A41666666664C2323410000002058125A419A999999692323419A9999B96F125A419A9999999A232341CDCCCCAC80125A41CDCCCCCCCC2323419A9999598E125A41CDCCCCCC322423419A999999A7125A41CDCCCCCC9224234166666646B6125A419A999999ED2423419A999979C8125A4100000000162523419A999999D2125A41000000004F25234133333393E5125A419A99999989252341333333D3F4125A41CDCCCCCCB2252341000000200D135A4133333333B12523410000002017135A41333333339B252341CDCCCCEC48135A41333333337F252341666666664C135A41CDCCCCCCEC2423410000004063135A419A9999996E242341000000C075135A4166666666FE2323416666668688135A4100000000DC2323413333335394135A4166666666EF2323419A9999B9A0135A4100000000F323234133333353AA135A4133333333BA23234133333313DA135A413333333379232341000000E0E8135A41666666660F2323410000000007145A419A9999990A2323419A9999D90A145A4100000000D6222341000000A009145A4133333333E22223416666664627145A41CDCCCCCCCC2223410000004027145A4166666666C22223413333339347145A4133333333A82323416666664652145A410000000060242341000000405F145A419A9999992C2523419A99993968145A41CDCCCCCCF02423413333335373145A419A999999AF24234166666686A5145A410000000032252341333333B3CD145A41666666664E252341CDCCCCACDD145A410000000003262341666666C609155A4133333333D6252341666666860D155A4100000000D8242341000000A01D155A41CDCCCCCCB5242341666666E621155A4100000000E8282341333333B32B165A41CDCCCCCC7C292341333333B32F165A4133333333F7292341CDCCCC0C30165A41CDCCCCCC072D23410000000031165A4100000000852D23416666666634165A41CDCCCCCCF02D23410000002031165A4100000000CA2E23410000004037165A4133333333172F2341CDCCCC0C38165A419A9999998C2F2341CDCCCC6C34165A41CDCCCCCCCD2F2341000000A02E165A419A999999163023413333339323165A419A9999997A302341333333931F165A419A999999E83023410000000021165A41CDCCCCCCEA3023413333331325165A416666666641312341000000C023165A4133333333D0312341666666A624165A41CDCCCCCC063223413333335322165A413333333334322341666666A622165A41666666668A322341CDCCCCEC1E165A419A999999C8322341CDCCCCEC15165A41CDCCCCCC05332341CDCCCC8C0A165A413333333328332341333333D305165A419A999999EC322341CDCCCCECFD155A41CDCCCCCC8F32234166666626EC155A419A999999ED3123419A999959CF155A419A99999953312341666666E69F155A419A9999993F312341CDCCCC8C82155A416666666642312341666666C67A155A410000000062312341CDCCCCCC6D155A4133333333F7312341CDCCCC4C43155A41CDCCCCCC24322341333333D337155A410000000058322341333333F32D155A41CDCCCCCC2B3223416666662622155A4166666666003223419A9999191B155A41CDCCCCCC813123410000006011155A41CDCCCCCC17312341000000001C155A4100000000BA3023419A99999912155A4166666666163123419A99997907155A4166666666F7302341CDCCCC0C04155A4100000000A83123419A9999F9ED145A419A9999990E322341CDCCCCACED145A4133333333EB3123419A999919FC145A419A999999B2312341CDCCCC0C08155A4133333333DB312341666666A60A155A41CDCCCCCC043223410000002002155A41CDCCCCCC44322341CDCCCC8C04155A41666666664F322341666666C6F7145A4100000000E7322341333333B3ED145A419A999999CB332341333333D3EE145A41333333334134234133333333F0145A41333333334D3423419A9999F9CB145A41666666665C342341CDCCCC6CAD145A4100000000563423419A99995997145A419A9999994D3423410000008090145A41CDCCCCCC88342341CDCCCC0C8F145A4166666666923423413333333385145A4133333333EB3423419A9999D97E145A413333333388352341333333B36F145A4166666666E4342341333333D35F145A4166666666F7342341666666265D145A410000000074352341333333D351145A41CDCCCCCCEF3523413333331356145A419A9999994D362341666666A64A145A41CDCCCCCC763623416666664648145A41CDCCCCCCBB3623413333335348145A41333333337F3723410000000045145A41CDCCCCCC74372341CDCCCCAC31145A4133333333843723416666660627145A4133333333A0372341666666A61E145A41000000008D3723419A9999D913145A419A9999996A372341666666460F145A4100000000773723410000008007145A419A99999960372341666666C600145A41CDCCCCCC85372341000000E0FD135A419A9999998137234133333353FA135A4133333333B037234133333353F3135A4166666666A537234166666646EA135A4100000000C73723419A999939DF135A4100000000F8372341666666E6E0135A419A999999F8372341CDCCCC6CE6135A416666666622392341CDCCCC4CE6135A41CDCCCCCC25392341CDCCCC0CE3135A4100000000E439234166666666E3135A4166666666E539234166666666DF135A4166666666CB3B2341CDCCCCACD3135A4100000000163C234166666606D8135A4166666666FD3B234133333393CD135A419A999999DA3B2341666666A6A9135A41000000000A3C2341666666A6A8135A41000000000D3C2341000000607E135A419A999999A23C2341000000207F135A4133333333EF3C2341CDCCCC0C7D135A4166666666C83F23416666666675135A419A99999904402341666666C694135A41666666661E4023419A9999F994135A4100000000554023413333331383135A4166666666B73F2341CDCCCCEC36135A4166666666F73E2341CDCCCC0C22135A41CDCCCCCC3F3E23419A9999990A135A419A9999990F3E23419A99991905135A41CDCCCCCC063E2341333333B3F9125A4166666666B63D234166666626C3125A419A999999C23C234166666666E3125A4166666666EA3B234100000020E9125A4100000000613C23419A9999196A125A4100000000993A2341333333F361125A4166666666693A23419A99993963125A419A999999C43923413333335373125A41333333335E392341CDCCCCCC7A125A41333333336D392341666666E677125A41CDCCCCCCDF372341333333535F125A4166666666AA3723413333331357125A4100000000C23223419A99993930125A4166666666173223410000002030125A416666666684312341666666062F125A4133333333C6302341000000802B125A419A99999963302341CDCCCCAC2C125A413333333333302341CDCCCCCC2E125A419A999999FC2F2341000000C034125A4100000000FC2F2341666666C62B125A41666666662B302341000000C014125A4166666666603023416666668604125A41CDCCCCCCAC30234133333313FD115A41000000009430234100000080F4115A41CDCCCCCC5A302341CDCCCC4CE5115A410000000042302341333333B3D2115A41000000003630234100000060A6115A416666666629302341666666E69A115A41CDCCCCCCF82F23410000006087115A41CDCCCCCCB12F2341000000E062115A41CDCCCCCCAB2C2341666666869A115A419A999999892B2341CDCCCCECAF115A419A9999998C2B23419A99991983115A4133333333FD2A23419A9999B98D115A4166666666A32A2341000000A093115A4133333333492923419A999999AD115A41CDCCCCCC142823419A999979C1115A419A9999994D26234100000060DE115A41000000001B2623419A9999B9D2115A41CDCCCCCCD42523419A999939C9115A413333333338252341000000E0AE115A41CDCCCCCCCB24234133333313A1115A41333333337A242341000000C088115A419A9999996F242341CDCCCCEC7F115A41CDCCCCCC63242341000000E068115A41CDCCCCCC5B2423413333337362115A41CDCCCCCC98232341000000C066115A4133333333B5222341000000005D115A410000000039212341CDCCCC6C97115A41CDCCCCCCEB202341666666669E115A4166666666B02023410000004092115A41000000006520234166666606AB115A41CDCCCCCC3B20234166666626AF115A4133333333D71F2341CDCCCCECB4115A41666666660620234100000020BE115A4100000000F31E234166666686DC115A4100000000F31E234166666686DC115A41	01010000206A080000A218B978E32F2341CCCCCCDCCA135A41	780870000	Z	Bonnelles	7808700	78087	78	11	11
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	01010000206A080000FED478D9862B2241CDCCCC8C573F5A41	780890000	Z	Bonnières-sur-Seine	7808900	78089	78	11	8
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	01010000206A080000A646A3822AE722410000002073385A41	780900000	Z	Bouafle	7809000	78090	78	11	7
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	01010000206A0800008446A07D4B70234133333343AA2E5A41	780920102	H	Bord de Seine	7809201	78092	78	11	1
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	01010000206A0800002B8D9217B06C23419A9999C9612E5A41	780920101	H	Les Quais	7809201	78092	78	11	0
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	01010000206A080000A87A3BE9386F23419A999999DD2D5A41	780920103	H	Centre Ville Jonchère	7809201	78092	78	11	1
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	01060000206A080000010000000103000000010000003C0000000000000013652341CDCCCC0CF92C5A419A9999992E672341CDCCCC2C372D5A41CDCCCCCC6D672341333333B33E2D5A41CDCCCCCCC167234133333313472D5A41000000006B682341CDCCCC8C5C2D5A4100000000DA67234100000080682D5A4166666666F46623419A999999762D5A41000000002D67234166666646792D5A416666666655672341333333D37F2D5A4100000000B7672341CDCCCCCC982D5A41CDCCCCCCE3672341666666E6A22D5A4133333333C7682341000000C0C02D5A41000000001B69234133333313CA2D5A419A999999A5692341333333B3D12D5A4100000000F16A23419A999959E62D5A41666666665C6B23419A999939CF2D5A4133333333D36B234100000020BC2D5A4133333333086C234100000000AF2D5A4100000000076C2341333333D3A92D5A41000000006D6C2341000000A09A2D5A4166666666C16C2341CDCCCCAC922D5A419A999999176D2341333333338C2D5A419A999999646D234133333313902D5A4166666666A46D2341CDCCCCAC942D5A4100000000E66D234100000020932D5A4100000000FC6D234166666606912D5A41CDCCCCCC156E2341000000E0872D5A41CDCCCCCC6A6E23419A9999797C2D5A4100000000826E2341000000E0762D5A41CDCCCCCC866E2341000000A06C2D5A419A999999496E234166666686672D5A41CDCCCCCC636D23419A9999395D2D5A419A999999396D2341CDCCCC6C592D5A4166666666AD6C234100000020512D5A4100000000566C23419A999979442D5A4100000000136C23419A9999393C2D5A4100000000A66B2341000000C0362D5A419A999999246B2341333333B3292D5A4166666666D06A2341666666261E2D5A4100000000B26A234133333393182D5A419A9999993E6A234100000080122D5A419A999999ED692341333333330D2D5A4166666666806923419A999919092D5A419A9999994C69234133333333062D5A41000000002969234100000040022D5A419A9999990169234100000000FB2C5A41CDCCCCCCD468234100000080E92C5A4133333333AF6823419A999959DF2C5A41666666664668234166666626C72C5A413333333303682341CDCCCC0CC92C5A41CDCCCCCCA6672341CDCCCCECC92C5A419A99999900672341CDCCCC4CC92C5A41333333339266234133333393C92C5A41000000003866234100000060C82C5A41666666668E65234100000040BF2C5A41000000005165234166666646D42C5A416666666637652341CDCCCC0CDF2C5A419A999999316523419A999999EB2C5A410000000013652341CDCCCC0CF92C5A410000000013652341CDCCCC0CF92C5A41	01010000206A08000036322AF57F6A2341000000A0532D5A41	780920104	H	Les Hauts de Bougival	7809201	78092	78	11	1
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	01010000206A0800004EC8F4A0F4592241000000D0E5225A41	780960000	Z	Bourdonné	7809600	78096	78	11	11
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	01010000206A080000C26A5A87BD7A22416666669654375A41	781040000	Z	Breuil-Bois-Robert	7810400	78104	78	11	4
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	01060000206A08000001000000010300000001000000CD0000006666666625032241000000C033375A410000000085032241333333134A375A41333333332E0422410000006073375A41CDCCCCCCB3042241000000C091375A41CDCCCCCCEC04224100000060A0375A41333333339C052241666666A6C8375A41333333330E06224166666686E5375A4166666666E20622416666660617385A419A999999220722419A99995927385A41333333338F0722419A99993940385A41000000007B082241666666A679385A4166666666C6082241000000608D385A4100000000E00822419A9999798C385A419A99999907092241333333F38F385A41CDCCCCCC260A224166666686A3385A4100000000AA0A22419A9999D9AC385A419A9999992B0B2241333333D3A0385A4166666666B70D22413333335315395A41CDCCCCCC9B0D22413333331325395A419A999999790D22410000004050395A41666666662E0E2241CDCCCC6C61395A419A999999380E2241000000405E395A4166666666070F22419A9999B96F395A4100000000AF0F22416666664653395A41666666669F1022416666664668395A41666666660A102241666666868E395A419A999999331022413333331392395A41000000008B102241CDCCCC6CD2395A4133333333BD1122419A999919233A5A41333333334E122241666666C6353A5A410000000026132241666666664C3A5A4133333333A21322419A9999593A3A5A41000000002B142241333333D3273A5A4166666666EE142241000000A00F3A5A419A9999996F152241CDCCCC0CFE395A419A999999ED15224133333313E9395A410000000061162241CDCCCCECD9395A41CDCCCCCCE9162241CDCCCCACCA395A413333333358172241666666E6BB395A41CDCCCCCC481A2241333333B3E2395A41CDCCCCCC7C1A2241CDCCCC4CD4395A419A999999131B224100000020B1395A41CDCCCCCC891B2241333333D397395A41CDCCCCCC201C224133333393A0395A419A999999041D224166666606AD395A4100000000501D2241CDCCCC2C95395A41333333337D202241CDCCCC8CB4395A41000000006920224100000060BF395A41666666667020224100000060CA395A41333333338920224166666686D1395A4166666666A6202241666666C6D5395A4100000000DD202241666666A6D9395A41333333332F212241333333F3DB395A41666666664E212241CDCCCC0CE0395A41333333337C2122419A9999D9E9395A419A999999A3212241000000A0023A5A4166666666A521224166666606183A5A41000000009B21224166666686273A5A41CDCCCCCC9B21224166666686333A5A4100000000B4212241333333F33D3A5A419A999999CD2122419A9999D9433A5A41666666663422224166666646503A5A4166666666A62222419A9999B95C3A5A41CDCCCCCCD72222419A9999B9643A5A410000000027232241CDCCCC6C763A5A41CDCCCCCC602322419A999999813A5A4166666666AB232241CDCCCC2C8D3A5A410000000012242241CDCCCC8C9B3A5A41CDCCCCCC1B242241CDCCCC6C9F3A5A419A999999E0242241CDCCCC0CB93A5A4133333333F7242241000000A0BC3A5A41CDCCCCCCC6252241CDCCCC6CC23A5A41CDCCCCCC1926224166666626CB3A5A4166666666722622419A999979D63A5A419A999999CF262241CDCCCCACE83A5A41CDCCCCCC03272241CDCCCCACF93A5A41CDCCCCCC38272241CDCCCC6C0F3B5A419A9999993228224166666686203B5A419A9999997128224100000020233B5A41CDCCCCCCA3282241333333131C3B5A41CDCCCCCCE5282241CDCCCC6C163B5A41333333334229224100000080123B5A4166666666FF2922419A9999390E3B5A41666666661F2A22419A9999990F3B5A4166666666CD2A2241666666C6203B5A419A999999352B224166666626283B5A41CDCCCCCC0A2C2241666666A62F3B5A41666666663B2C2241000000202F3B5A41CDCCCCCC882C2241000000202B3B5A4100000000C82C224100000040293B5A4166666666262D224100000080293B5A41000000002D2E2241CDCCCC4C2E3B5A4133333333C22E224166666646323B5A419A999999F22E22419A999979323B5A4133333333102F22419A999979273B5A41333333336A2F22419A9999990B3B5A4100000000CE2F224133333353F23A5A419A99999913302241666666E6E33A5A4166666666263022419A999939DD3A5A4166666666FF2F224166666646D63A5A41CDCCCCCC1F2F224166666606C03A5A419A999999B62F224100000040A73A5A41000000004B2F2241666666E69F3A5A419A999999D92E22419A999999993A5A419A999999952E2241666666E6983A5A41000000005A2D224100000060A03A5A41666666666C2D2241333333939A3A5A4166666666AA2A224166666686353A5A41CDCCCCCC962A2241CDCCCC0C393A5A416666666633272241000000A0D0395A419A99999918262241CDCCCC4CB4395A41000000004626224133333313A9395A419A999999112622416666662688395A4100000000062622416666666674395A4133333333C02522413333333372395A419A9999994C252241CDCCCC0C6B395A41CDCCCCCC452522413333331366395A41CDCCCCCC1F252241666666A661395A419A999999B1242241333333335A395A41CDCCCCCC70242241000000A053395A4100000000E62322419A99993941395A4133333333BF242241000000002C395A41CDCCCCCC3F252241CDCCCCEC1D395A416666666618262241000000A007395A4166666666D0262241333333F3F3385A4100000000CD26224133333333F1385A41000000002E262241000000E0CC385A41CDCCCCCC9026224133333353C8385A419A999999AF272241CDCCCCACB7385A41000000006628224133333353AF385A4100000000CA282241666666E6A6385A4100000000F628224133333313A2385A416666666687292241333333B38C385A4166666666D8292241CDCCCCEC85385A4100000000D62A22419A99997977385A4100000000112B2241CDCCCC8C73385A4133333333B22B2241666666466D385A41CDCCCCCC7B2822419A999999EE375A41000000007227224133333333BA375A41333333335F272241CDCCCCCCB4375A41CDCCCCCC0B27224166666646AD375A4166666666FF232241CDCCCC0C51375A419A99999998232241000000405F375A410000000055232241333333736A375A4133333333A3222241CDCCCC6C80375A419A99999966222241666666468A375A4100000000E0212241CDCCCC8C98375A4133333333F42022419A999919A7375A4100000000892022419A9999398B375A419A999999492022410000006080375A4133333333FB1F22416666664678375A41666666667B1F2241666666E66D375A4133333333221E22413333337353375A4100000000B51D2241CDCCCC0C4C375A4100000000B61C2241000000803F375A4100000000DA1B22419A99991932375A41CDCCCCCC761B22419A99999938375A41666666664F1A22413333337341375A41CDCCCCCC0E1A22416666662644375A4100000000B0182241CDCCCC0C58375A4100000000051822419A99995962375A4166666666E4172241000000605B375A4133333333EA1722419A9999D953375A419A99999922182241CDCCCC2C46375A416666666621182241000000A042375A419A9999995D1722416666668619375A419A999999391722419A99995915375A4166666666051722419A9999B914375A4133333333A81622419A99995905375A41666666669B1622419A99997904375A419A999999661622419A999939F8365A4133333333D615224166666626CB365A4100000000D01522419A9999D9A9365A4133333333E9152241333333D39E365A4100000000EC152241CDCCCC6C99365A419A9999991D1622413333339389365A419A99999926162241666666067D365A419A999999DB152241000000E079365A4133333333AE1522419A9999D979365A419A9999995A152241000000807E365A419A999999EF1422413333337388365A419A999999A9142241000000E08A365A4133333333531422413333335387365A410000000005142241CDCCCCCC8C365A4133333333D2132241666666068E365A419A9999991C14224100000000A3365A41CDCCCCCC7D1422419A999979CB365A419A9999999A1422419A999939D4365A41CDCCCCCCA3112241333333D3FB365A419A999999CB0E2241CDCCCC6C24375A41666666660C0F22410000004034375A41CDCCCCCC2D0F2241CDCCCCAC3A375A41333333338D0E22410000000042375A4133333333520D2241333333334F375A41CDCCCCCCEC0C22416666664652375A4166666666980B22419A9999F95A375A4100000000E00B2241666666A66C375A419A999999360C22416666668683375A41666666668C0B2241333333738C375A4133333333EB082241666666E65E375A41666666663E0722410000006044375A419A999999870522419A9999D93B375A41000000008F0322419A99997934375A416666666625032241000000C033375A416666666625032241000000C033375A41	01010000206A0800002033B595821922419A999909DF385A41	781070000	Z	Bréval	7810700	78107	78	11	12
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	01010000206A08000025E70C1212B12241CCCCCC5C841E5A41	781080000	Z	Les Bréviaires	7810800	78108	78	11	20
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	01010000206A080000EDD11F2793B32241CCCCCC8C40405A41	781130000	Z	Brueil-en-Vexin	7811300	78113	78	11	7
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	01010000206A080000A6CAF148FC6C2341666666B620255A41	781170101	H	Bas Buc	7811701	78117	78	11	5
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	01010000206A0800009484B7AEA96123419A9999C961235A41	781170102	H	Haut Buc	7811701	78117	78	11	4
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	01010000206A0800000C4BD488E16622419A999999893B5A41	781180000	Z	Buchelay	7811800	78118	78	11	5
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	01060000206A080000010000000103000000010000005D0100006666666641F522419A999939D5125A416666666656F52241000000A0DA125A4100000000B7F522419A9999D9EA125A410000000039F622419A999959FE125A41CDCCCCCC1FFC2241000000A0F4135A416666666646FC224100000000F2135A41666666667DFC224133333333E8135A41CDCCCCCCCBFC224166666686DE135A4100000000F5FC224100000060D6135A413333333384FD224166666646C5135A4100000000EBFD224100000040AF135A41CDCCCCCC00FE22419A9999F9A5135A416666666638FE2241000000E09C135A410000000077FE2241000000E095135A4166666666C7FE2241666666E68E135A41666666667E002341CDCCCCECD7135A41CDCCCCCCC5002341333333F3D5135A4166666666CD012341000000203F145A4166666666330523419A99999923145A419A9999995B052341666666C630145A4133333333B8052341CDCCCC4C36145A413333333333062341666666C63B145A41CDCCCCCC49072341000000A040145A4100000000F6082341666666E640145A41CDCCCCCC4C0C2341333333333A145A419A9999992E0C23413333331348145A4100000000310C2341CDCCCCAC58145A4166666666610C2341CDCCCC8C74145A4100000000860C23419A9999998E145A41333333338A0C2341666666269C145A4133333333970C2341333333D3A4145A4100000000C80C2341000000E0B5145A4100000000E80C23419A9999D9BE145A4133333333EC0C234133333353C3145A4166666666D30C23419A999999CF145A41CDCCCCCCCD0C234166666646DA145A419A999999ED0C234133333373EE145A41000000001C0D234133333353F0145A419A9999994B0D2341333333D3F5145A419A999999490D2341CDCCCCECFA145A4133333333500E2341000000A0F8145A41000000007A0E2341CDCCCC4CFD145A4166666666D50E23410000006000155A41666666661B0F23419A9999F9FE145A41666666665E0F234133333313FB145A419A9999999B0F2341CDCCCCECFB145A4133333333B70F234166666646FA145A4133333333FF0F23419A999979FA145A4133333333521023419A999999EA145A4133333333AA10234133333353E7145A4100000000FA102341CDCCCC6CE2145A419A9999994911234100000000E4145A41CDCCCCCCEC11234133333393E5145A41000000003C12234133333333E8145A4133333333441223419A9999390E155A413333333359122341333333330E155A416666666651122341CDCCCC8C19155A41333333333F12