SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep82;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep82 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep82','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep82','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep82','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep82"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01060000206A08000001000000010300000001000000AC000000000000009F162141666666869825584133333333BA162141666666469E25584100000000D116214100000040AF25584100000000DF1621419A999939B42558410000000005172141000000C0B4255841666666661D172141CDCCCC0CAF255841000000005D1721419A999919AA2558419A999999CA17214166666606AD2558416666666684182141CDCCCC2CB4255841CDCCCCCCEF18214166666646B725584133333333B419214100000000BB2558419A9999997D1A214100000060C42558419A999999D11B214166666606D6255841333333336F1C2141333333D3DE25584133333333271D21419A999959E825584133333333D01E21419A999999FC2558419A999999B71F2141CDCCCC6C06265841CDCCCCCC25202141666666E60B265841CDCCCCCC79202141000000801326584166666666B3202141CDCCCC4C1F2658419A999999062121413333337338265841000000005C21214166666666542658419A9999998F212141CDCCCC8C62265841666666662E2221419A9999B987265841333333339F222141CDCCCC4CA126584100000000D7222141333333D3AA2658419A99999910232141CDCCCCACB126584133333333A023214100000080C026584166666666C1242141333333F3DB26584166666666D924214133333333E02658419A99999900252141666666C6EE265841000000001625214133333313F32658419A9999994C252141666666A6F726584133333333ED25214133333373002758419A99999978262141000000A00927584166666666D52621416666660611275841CDCCCCCC902721419A9999591C27584100000000B6272141333333931127584166666666B32721419A9999390A27584166666666F7272141000000E0FA265841CDCCCCCC6628214166666686E426584100000000D1282141CDCCCC2CCD26584133333333F82821419A9999B9C5265841666666663F292141CDCCCC6CB526584133333333C5292141CDCCCC4C99265841000000005B2A2141333333937726584100000000D22A2141CDCCCCEC5A2658419A9999996C2B21419A9999B93426584133333333F82B2141CDCCCCEC0F26584100000000C42C2141000000A0D725584166666666342D21419A999919BA2558419A999999902D214100000000A625584166666666F12D2141000000A08D25584166666666F32E2141CDCCCC4C56255841000000003B2F2141CDCCCCCC492558419A999999D72D2141333333932D2558419A9999990F2C2141CDCCCCEC0E255841666666663A2C21416666666604255841333333337C2C214133333373EE24584166666666E12C2141000000E0C924584100000000EA2C2141CDCCCC6CC42458419A9999993A2D214133333333AA24584166666666AE2D2141333333338324584100000000242E2141000000A06524584100000000E32E2141000000202A2458419A999999542E21416666664622245841666666666E2D2141CDCCCC2C142458419A9999993F2D2141666666A61024584166666666202D21419A9999F90A24584166666666CB2C21419A999999F023584166666666CD2C214100000000E923584100000000F62C214133333353E1235841CDCCCCCC232D21419A9999B9D12358419A999999442D21419A999939C2235841CDCCCCCC5E2D2141CDCCCC0CB123584166666666802D214166666606A5235841CDCCCCCC9F2D2141333333B39E2358419A999999F02D2141333333D392235841000000000E2E2141666666468C235841666666661C2E2141666666C68423584133333333252E21410000006072235841CDCCCCCC0E2E21419A9999B9672358419A999999EF2D2141666666A65023584133333333ED2D2141000000E04123584166666666062D21419A999979402358419A999999E12C2141CDCCCC0C412358419A9999998B2C2141CDCCCC0C3D235841CDCCCCCCAA2B2141CDCCCC4C2F23584166666666522B2141000000C02D235841666666665C2A2141333333133223584166666666352A214166666666342358419A999999FB292141333333D33B2358413333333301292141CDCCCC2C5E23584100000000D12821410000002062235841333333337E282141CDCCCC2C622358413333333349282141CDCCCCCC63235841CDCCCCCCBA2721419A9999196B235841333333334D272141333333F37323584100000000FE262141000000007D235841CDCCCCCCBB262141CDCCCCEC7C2358413333333364262141666666E6752358416666666604262141333333736F23584133333333C9252141333333336A23584166666666EB252141CDCCCCCC5B235841CDCCCCCCE9252141666666064F23584166666666D82521419A9999F9402358419A999999E0252141CDCCCC4C3923584100000000D62521413333337332235841333333338E252141333333B3212358419A99999989252141CDCCCCAC1C23584100000000A2252141333333B3142358416666666613252141666666A6062358419A999999D5242141666666860A2358419A999999A024214166666626042358416666666633242141CDCCCC8CFB225841CDCCCCCC8223214100000040EC225841666666661B23214100000060EA225841CDCCCCCCD0222141333333B3EC2258419A9999998F222141000000C0EC22584166666666632221419A999919F02258410000000049222141CDCCCC6CEF225841CDCCCCCCE821214166666686E62258419A99999991212141CDCCCC0CD82258413333333369212141666666E6CD22584100000000F72021419A9999B9D62258413333333356202141666666C6DF225841CDCCCCCC7B20214100000080E622584166666666C6202141CDCCCCECED2258419A999999DC20214166666666F222584133333333E1202141666666A6F8225841CDCCCCCC86202141CDCCCC0C1A23584166666666232021419A9999793823584133333333D31F21416666668641235841333333338D1F2141CDCCCC8C50235841CDCCCCCC0B1F2141666666066E2358419A999999BB1E21419A99991986235841CDCCCCCC7B1E21419A9999B995235841CDCCCCCC351E214133333333A52358419A999999D01D21419A9999F99F235841CDCCCCCCC31D2141000000C0AE235841CDCCCCCCCE1D2141CDCCCC8CBA23584100000000731D21419A9999D9CD235841666666664B1D21419A999999D923584166666666E51C21419A999919F123584166666666B61C2141CDCCCCCCF9235841666666663B1C2141CDCCCC2C0724584166666666591B21413333333321245841CDCCCCCCC11A2141CDCCCC6C34245841000000008F1A2141666666E638245841CDCCCCCC021A2141000000A041245841666666664C192141CDCCCC4C5C24584133333333351921419A9999795E2458416666666644192141666666266524584100000000B9192141333333937924584166666666FC182141000000809324584100000000D61821419A9999198D245841666666669E182141CDCCCC2C96245841CDCCCCCC7B182141333333B3992458419A9999990C1821419A9999599F245841333333334A182141000000C0A4245841CDCCCCCC141821419A9999F9BC24584133333333021821419A999919CF245841000000001A18214133333373E5245841CDCCCCCC13182141666666A6ED24584100000000771721419A99995910255841CDCCCCCC391721419A9999D9232558410000000023172141CDCCCC2C302558419A99999925172141CDCCCCEC3525584100000000E4162141333333F36F255841CDCCCCCCB51621413333335386255841000000009F1621416666668698255841000000009F1621416666668698255841	01010000206A0800000A495ED81C222141CCCCCC6CF9245841	820010000	Z	Albefeuille-Lagarde	8200100	82001	82	76	8
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	01010000206A080000EB1BD6FEF58F21419A99998982285841	820020000	Z	Albias	8200200	82002	82	76	22
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	01010000206A080000DD8B57AE7187204100000020D81E5841	820030000	Z	Angeville	8200300	82003	82	76	8
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	01010000206A08000024BF58B2C65B20413333333326215841	820040000	Z	Asques	8200400	82004	82	76	11
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	01010000206A0800006A09FDB6140921419A9999D94F095841	820050000	Z	Aucamville	8200500	82005	82	76	23
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	01010000206A080000F83379E2DA612041CDCCCCBC84105841	820060000	Z	Auterive	8200600	82006	82	76	4
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	01060000206A08000001000000010300000001000000D300000000000000F8912141333333B33D335841CDCCCCCC2C92214100000060483358419A999999B3922141000000C05D335841CDCCCCCCDF922141CDCCCC0C623358410000000024932141000000E0653358419A9999998B9321419A9999397633584166666666BC932141000000208433584166666666C69321419A9999998C335841CDCCCCCCDE932141000000809233584166666666F9932141666666E69E3358419A9999990694214166666686AB33584166666666F8932141333333F3B7335841CDCCCCCC06942141CDCCCCCCC5335841000000002394214133333373CD335841000000007994214100000080D83358413333333305952141CDCCCC4CE63358419A9999993695214166666626E8335841666666666D95214166666686EE335841CDCCCCCCC99521419A9999F9F4335841CDCCCCCC63962141000000200334584133333333DD962141000000000C345841333333332B972141333333F3133458419A99999972972141CDCCCC2C1D34584166666666759721419A9999F92034584133333333E2972141333333F33734584100000000309821419A99999950345841CDCCCCCC5A982141666666C655345841000000005D982141666666065B345841CDCCCCCC419821416666660660345841333333335E9821416666660671345841CDCCCCCC639821419A9999B9853458413333333371982141000000008B345841CDCCCCCC73982141CDCCCCAC9834584133333333A49821419A999959A3345841CDCCCCCCC2982141333333B3AC34584133333333FB98214133333393B43458419A99999958992141666666E6C63458416666666694992141CDCCCCECD334584166666666D4992141CDCCCC0CE43458419A9999991C9A2141000000E0F7345841666666662C9A21416666662604355841000000005C9A2141666666A60B355841CDCCCCCC689A21419A9999B910355841CDCCCCCC8B9A2141CDCCCC0C1135584166666666CA9A2141333333D31535584166666666259B214166666646153558419A999999E89B2141CDCCCCCC1A355841000000001E9C214100000000233558419A999999239C21410000004027355841CDCCCCCC4F9C2141000000C02A35584133333333479C21419A9999D941355841333333334D9C2141CDCCCC0C4435584166666666B89C2141333333935335584100000000039D2141CDCCCC6C5D355841000000008B9D2141333333736A3558419A999999E39D2141333333F36F355841CDCCCCCC2B9E2141000000E07535584166666666759E2141666666667F355841CDCCCCCCE19E21419A99997989355841000000002F9F21419A9999D9883558410000000007A02141CDCCCC0C90355841CDCCCCCC57A02141000000E0913558416666666675A02141000000A09535584166666666F2A02141333333139C35584100000000E8A021419A999919A135584100000000F4A0214133333313AA35584166666666EBA0214166666686B1355841666666661EA12141666666C6BA3558419A99999991A12141CDCCCC2CC73558419A9999999FA12141CDCCCC4CCC355841333333337DA2214133333393B33558419A9999996AA3214133333353A13558413333333350A421410000002090355841CDCCCCCCF8A42141CDCCCCCC813558419A99999913A52141333333D37D355841333333335AA52141666666666A35584100000000AEA52141333333B35C3558416666666634A621419A9999394B35584166666666B3A6214133333353373558416666666604A72141CDCCCCEC263558419A99999941A72141333333F31B355841CDCCCCCC5EA72141666666E6183558416666666660A72141666666E603355841CDCCCCCCAEA72141CDCCCCACEF3458419A99999928A82141666666C6DB3458419A99999968A82141666666A6CE345841CDCCCCCCE7A8214100000040C334584133333333DAA8214100000060BA3458419A999999CEA8214133333353A834584133333333E2A82141333333139B3458419A99999904A92141333333138F3458419A9999990FA921419A999939873458410000000003A92141333333338134584100000000FAA821419A9999596C345841CDCCCCCC20A9214133333353613458419A99999967A921410000008055345841000000006AA92141CDCCCC0C513458413333333336A92141666666E635345841666666660DA9214100000080163458413333333314A921419A999979083458416666666649A92141666666E6FE3358410000000069A921419A9999B9F2335841CDCCCCCC9CA92141333333D3E433584133333333E1A9214100000040E1335841CDCCCCCC23AA2141CDCCCCACD7335841333333333DAA2141CDCCCC8CD03358419A99999975AA214166666606C63358419A9999998FAA214100000080BA3358419A999999C9AA2141333333F3B633584166666666DFAA2141000000C0B233584166666666DDAA2141666666C6A133584100000000E9AA2141666666A69A3358410000000073AB2141666666A68633584100000000C0AB2141666666C67C3358419A999999EBAB21419A9999D9783358419A9999994EAC2141CDCCCCCC793358416666666687AC214100000040753358410000000004AD2141000000806D335841000000006EAD2141CDCCCC4C6533584100000000ABAD2141CDCCCC2C5D33584133333333F2AD21416666662658335841CDCCCCCC26AE2141000000A05633584133333333E8AD2141666666E64C33584100000000A0AD21419A9999793F3358419A99999972AD214166666666353358413333333352AD2141000000602B3358419A999999EAAC2141CDCCCC0C0433584166666666C1AC214166666626F93258413333333391AC2141000000E0E4325841000000003DAC214100000060CC3258419A9999992BAC2141CDCCCC0CC532584100000000C3AB214100000080B23258419A999999BFAB214100000000B03258413333333346AB21419A9999B996325841000000001EAB2141333333139032584133333333D3AA2141333333B386325841CDCCCCCC18AA2141333333D3723258413333333364A92141666666865A3258416666666687A82141000000C03D3258419A9999991EA82141333333133132584100000000F4A6214133333333113258413333333308A72141000000600B32584133333333EEA62141333333D3063258410000000044A62141666666A6FE31584133333333E8A52141CDCCCC8CF9315841000000009FA521419A9999B9F6315841333333332FA52141CDCCCC4C033258413333333302A52141333333D31632584100000000D4A42141CDCCCC2C1F32584166666666A6A42141333333D32A3258410000000005A42141666666E63632584133333333E8A321419A9999B93B3258416666666661A32141333333934B325841CDCCCCCC12A32141333333535332584166666666CDA22141CDCCCC8C58325841CDCCCCCC6DA22141000000C06132584100000000CEA12141666666866E325841000000006FA1214133333313743258416666666640A121419A999939753258419A999999D9A02141333333337A3258419A99999960A021416666660683325841CDCCCCCCDE9F2141CDCCCCAC953258419A999999829F214166666646A4325841000000003E9F2141CDCCCCCCAC32584100000000F99E214166666686B232584166666666A29E214166666606C6325841333333336E9E214100000080CE325841CDCCCCCC319E2141CDCCCC6CD532584100000000029E2141CDCCCCACDF325841CDCCCCCC139E214133333313E332584100000000F29D2141CDCCCC2CEF3258419A9999998F9D21419A999999FF32584133333333279D21419A9999990B33584100000000EA9C21419A9999991533584100000000A59C2141000000A0273358419A999999A39C2141333333532D335841CDCCCCCC3A9C2141666666663833584166666666539B21416666662627335841666666661B9B2141333333932D3358419A999999979A21416666666624335841666666667C9A2141CDCCCC4C16335841CDCCCCCC2B9A21419A9999390233584100000000ED9921419A999959EE32584100000000CF992141CDCCCCACE032584100000000CD99214100000000D93258419A999999D8992141CDCCCCECC632584166666666B49921419A999979BF325841CDCCCCCC36992141666666E6B332584133333333B1982141CDCCCC0CA93258413333333375982141333333F39F3258419A9999992C982141000000009032584133333333D99721413333335381325841CDCCCCCC49972141333333938F3258419A999999C7962141666666C69A325841666666663A9621419A999999B332584133333333FA9521419A9999F9BC32584100000000D4952141666666C6C5325841000000009195214166666666D9325841666666667A952141000000A0E73258419A9999994E95214166666686EB3258419A999999AF942141666666E6F53258413333333353942141CDCCCC0CFE3258419A9999991994214166666686073358419A999999D1932141333333931133584133333333C29321416666662612335841666666667A932141333333D320335841000000001D93214166666626303358419A99999993922141000000E0413358410000000039922141333333734033584100000000F8912141333333B33D33584100000000F8912141333333B33D335841	01010000206A08000020DE09D5539F214133333363E2335841	820070000	Z	Auty	8200700	82007	82	76	7
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	01010000206A0800004082E0F8EC382041333333538B275841	820080000	Z	Auvillar	8200800	82008	82	76	16
01060000206A080000010000000103000000010000008601000066666666CF1B204100000000651C584133333333D11B204166666646671C584133333333D71B20419A999959691C584100000000E11B20419A9999596B1C58419A999999F91B2041CDCCCCEC6E1C58419A999999FE1B204133333313701C5841000000002E1C2041333333F37C1C584133333333401C204166666626811C584100000000451C204166666666821C584100000000601C204133333313801C584133333333861C2041000000807B1C58419A999999B71C204100000080751C584133333333DA1C204166666686711C58419A999999F51C2041333333D36E1C5841000000000A1D2041666666866D1C584133333333261D2041666666066C1C58419A999999511D2041333333736A1C5841CDCCCCCC8F1D2041333333D3671C584100000000C31D20419A999959651C584133333333F51D2041CDCCCC4C631C584166666666131E2041CDCCCC2C621C584133333333311E204133333353611C584133333333541E2041CDCCCC4C601C58419A999999711E20419A9999795F1C5841000000009F1E2041333333335E1C584100000000C91E2041CDCCCC8C5C1C5841CDCCCCCC3E1F20419A9999F9631C5841CDCCCCCCC91F204133333313691C5841333333337E21204100000040711C5841666666667222204166666666731C5841666666665C232041CDCCCC8C811C58419A9999992E242041333333F3761C5841CDCCCCCCA924204166666646711C5841333333338325204133333393581C5841CDCCCCCCC0252041666666A64F1C58410000000029262041333333F34E1C58410000000068262041000000804E1C5841CDCCCCCC922620419A9999594E1C58419A999999C62620419A9999394E1C58419A999999D8262041CDCCCC2C4E1C58419A999999FC262041333333334E1C58413333333336272041666666464E1C58413333333355272041CDCCCC0C4E1C58413333333368272041000000E04D1C584133333333752720419A9999994D1C58410000000086272041666666464D1C5841CDCCCCCC91272041000000C04C1C5841666666665A282041333333534E1C58410000000084282041666666464E1C5841CDCCCCCCAD282041CDCCCC6C4F1C584133333333FD28204100000000531C58419A9999994D292041CDCCCCAC551C584133333333B729204166666626571C58419A999999202A2041CDCCCC4C551C5841333333337D2A2041333333B3501C584166666666D82A2041666666864A1C584100000000552B2041CDCCCC0C481C584133333333C42B2041CDCCCCAC431C58419A999999452C2041CDCCCC0C3C1C5841CDCCCCCCB92C2041000000C0381C5841000000000D2E2041666666A62D1C584100000000B32E204133333353251C584100000000E32E2041000000E01F1C5841CDCCCCCC002F2041666666E6141C5841CDCCCCCC5E2F2041666666E60D1C58410000000034302041000000600A1C5841CDCCCCCCCE312041CDCCCC8C081C584133333333B131204100000040C41B584133333333F6312041000000A0C01B58419A9999993D32204100000000BC1B58419A999999713220419A999919B91B5841CDCCCCCC873220419A9999D9B71B58419A999999A9322041CDCCCC6CB51B5841CDCCCCCCC832204100000020B31B584166666666E9322041333333F3B01B58419A99999900332041333333B3AF1B58410000000011332041333333F3AE1B5841CDCCCCCC2F3320419A999939AD1B5841CDCCCCCC3C332041CDCCCC6CAC1B5841000000004A33204133333373AB1B58419A999999523320419A999959AA1B5841333333335D33204133333373A81B5841000000006833204133333313A71B58419A99999975332041CDCCCCACA51B58419A9999997F33204100000080A41B5841333333338C332041CDCCCC2CA31B5841CDCCCCCC9533204166666606A21B584100000000A033204166666646A11B584133333333A9332041CDCCCC2CA11B5841CDCCCCCCB333204133333353A11B584166666666C033204133333353A11B584100000000CC3320419A9999F9A01B58419A999999DB3320419A9999F99F1B584166666666E9332041000000209F1B58419A999999F93320419A9999799E1B5841666666660E342041666666069E1B5841000000001E342041000000A09D1B5841CDCCCCCC31342041333333139D1B58419A999999423420419A9999999C1B5841CDCCCCCC57342041333333539C1B584133333333813420419A9999F99B1B58410000000095342041000000C09B1B58419A999999AB3420419A9999599B1B5841CDCCCCCCC2342041666666069B1B58419A999999D83420419A9999D99A1B584100000000F1342041000000A09A1B58416666666604352041CDCCCC2C9A1B5841000000001E352041CDCCCC8C991B58413333333340352041666666A6981B5841666666665D35204100000080971B5841CDCCCCCC88352041666666A6951B584166666666A335204166666666941B5841CDCCCCCCCE352041333333F3911B584100000000E4352041CDCCCCAC901B584100000000F3352041000000C08F1B58413333333313362041666666068E1B5841CDCCCCCC4C3620419A9999998B1B58419A9999998936204100000020851B58419A999999B9362041333333F37F1B584100000000EE362041000000007A1B5841666666661737204133333373731B5841000000003D372041333333336F1B58410000000074372041333333B36A1B58419A999999A337204133333373661B584166666666C63720419A999959631B58419A999999DE372041000000A0611B58419A99999900382041000000405F1B5841666666662B382041CDCCCCCC5C1B5841CDCCCCCC58382041333333135A1B5841CDCCCCCC7D38204133333333571B5841CDCCCCCCA1382041666666C6541B584133333333BB38204133333393531B584100000000CD3820419A9999F9511B584166666666C83820419A999959511B584100000000BC382041000000E04E1B584133333333AD3820419A9999D94B1B5841666666669F382041000000A0481B5841000000009338204100000020451B5841000000008A38204100000080411B58410000000085382041000000403E1B58419A9999997B3820419A9999793B1B58419A9999996C382041CDCCCC2C391B5841000000005A3820419A999979371B584166666666453820419A9999F9361B5841CDCCCCCC34382041333333F3361B5841333333331C382041000000A0371B5841333333331138204166666626351B58419A999999093820419A999999331B58419A99999902382041000000C0321B58419A999999F8372041666666C6321B584166666666EA372041CDCCCC2C331B584166666666DA37204133333393331B5841CDCCCCCCCE372041666666A6331B584166666666C037204133333353331B5841CDCCCCCCB1372041000000C0321B5841CDCCCCCCA3372041CDCCCCEC311B5841666666669637204100000040311B5841CDCCCCCC84372041666666C6301B58410000000078372041CDCCCCAC301B58413333333369372041000000A0301B5841333333335D37204100000060301B5841CDCCCCCC4C372041000000E02F1B5841000000003B37204133333313301B58419A9999992E372041CDCCCC8C301B5841666666661F372041CDCCCC4C311B5841000000000F372041000000C0311B58419A999999FF362041333333F3311B584133333333EB3620419A9999F9311B584100000000DB3620419A9999F9311B5841CDCCCCCCC73620419A9999F9311B584100000000B536204133333313321B584166666666A73620419A999959321B58419A99999999362041333333F3321B5841000000008D362041CDCCCC0C341B5841CDCCCCCC7F36204166666646351B5841000000007436204166666606361B5841333333336136204133333353361B58419A9999995036204100000000361B5841CDCCCCCC3D36204166666666351B5841CDCCCCCC2D362041CDCCCCEC341B58413333333317362041CDCCCC6C341B5841000000000636204100000000341B58419A999999F4352041CDCCCCEC331B5841CDCCCCCCE2352041333333B3331B584133333333D43520419A999939331B584133333333C8352041666666C6321B5841CDCCCCCCB33520419A999979311B5841000000008F352041000000E02D1B584133333333743520419A9999592B1B58416666666666352041666666262A1B58410000000058352041666666A6281B5841333333333F35204166666666261B5841CDCCCCCC3135204166666626251B584100000000253520419A999939241B5841333333330C352041CDCCCCCC221B58419A999999F834204133333373211B584100000000EE342041000000A0201B58419A999999E03420419A999939201B58419A999999CA342041000000A0201B5841CDCCCCCCA63420419A999999211B5841CDCCCCCC94342041666666A6211B5841666666668534204166666666211B58413333333376342041CDCCCCAC201B5841000000005A342041CDCCCC8C1F1B58413333333340342041000000401E1B58419A9999992E342041666666261D1B5841000000001E342041666666261C1B5841000000000B342041000000001B1B584100000000EE33204100000000191B584166666666DA33204100000000181B58419A999999C533204133333313171B584100000000AE3320419A999919161B58413333333394332041CDCCCCAC141B58410000000073332041CDCCCC4C131B58419A99999961332041000000C0121B58419A9999995433204100000060121B5841666666664833204166666646121B5841333333333B33204166666686121B5841666666662B332041333333F3121B5841000000000A332041CDCCCC4C141B58419A999999E332204100000060151B584100000000CA32204133333333161B584133333333BF322041333333B3161B584133333333B43220419A999939171B5841CDCCCCCCA5322041CDCCCC0C181B5841333333338732204133333393191B58413333333358322041CDCCCCAC1B1B58410000000035322041333333131D1B58413333333324322041666666C61D1B584133333333123220419A9999791E1B5841CDCCCCCCFC312041000000201F1B584133333333D9312041CDCCCC0C201B584133333333C431204166666686201B58419A999999B631204133333313211B584100000000AA31204166666686211B5841333333339E31204166666606221B5841CDCCCCCC91312041CDCCCCCC221B5841000000008231204133333393231B5841CDCCCCCC6A312041CDCCCC2C251B58416666666660312041CDCCCC0C261B5841CDCCCCCC54312041CDCCCC0C271B5841666666664B312041000000A0271B5841CDCCCCCC3F312041CDCCCC4C281B5841666666661C3120419A9999392B1B58416666666605312041000000A02C1B5841CDCCCCCCF8302041333333932D1B58419A999999ED3020419A9999392E1B584100000000E1302041333333D32E1B584100000000CF302041666666E62F1B58419A999999BC30204166666606311B584166666666AF302041CDCCCC2C321B5841CDCCCCCC97302041333333B3331B5841CDCCCCCC8930204166666666341B5841CDCCCCCC7C30204100000000351B58410000000075302041000000A0351B58419A9999996A302041CDCCCC6C361B5841333333335B302041CDCCCC0C371B5841000000003530204133333373371B5841CDCCCCCC2330204100000080371B584133333333123020419A999959371B58419A999999E52F20419A999959361B584166666666B32F204166666666351B584100000000992F20419A999959341B584166666666802F204166666686331B584166666666492F204133333333301B584166666666242F2041CDCCCCCC2F1B5841666666660E2F2041CDCCCC6C2F1B584133333333F92E2041666666E62E1B584133333333E32E2041666666262E1B584133333333D32E20419A9999392D1B5841CDCCCCCCAA2E204133333393291B5841CDCCCCCC782E20419A9999D9241B584100000000512E20419A9999F9201B5841CDCCCCCC3B2E2041CDCCCCCC1E1B5841CDCCCCCC2A2E20419A9999991C1B5841333333331E2E2041CDCCCC2C1B1B5841CDCCCCCC0C2E2041CDCCCC6C191B58419A999999E62D204166666646161B5841CDCCCCCCA52D204100000060111B5841CDCCCCCC682D2041333333930C1B584100000000282D204166666686081B584100000000A62B20419A9999D9F21A58419A999999532B2041CDCCCCECEE1A58419A9999993A2B20419A999999ED1A5841CDCCCCCC282B204166666646EC1A58419A999999152B2041000000A0EA1A584100000000062B204133333353E91A584133333333EF2A204166666686E81A5841CDCCCCCCCE2A20419A9999D9E71A584100000000B92A204166666626E71A584133333333AD2A2041666666A6E61A5841333333339B2A204100000060E51A5841000000008A2A2041CDCCCC8CE31A5841666666667A2A204133333313E11A58419A999999552A204100000000DB1A584133333333482A20419A9999D9D81A5841000000002B2A20419A999919D31A58419A999999EB292041333333F3CE1A58416666666675292041CDCCCC6CCB1A5841000000002A29204100000080CD1A5841CDCCCCCC4B2820419A999999D41A5841CDCCCCCC9327204100000020D81A5841000000002B27204166666686D51A5841000000001126204133333333DD1A5841333333333C2520419A999959E71A58416666666694242041666666A6EA1A5841000000009C232041CDCCCC8CEA1A5841666666664023204166666606E81A584133333333C32220419A999959DF1A5841CDCCCCCC8A2220419A9999D9DB1A5841000000006C2220419A999919D91A58419A9999992522204133333393D31A584133333333F521204133333333D11A584133333333B221204133333393CF1A5841CDCCCCCC8821204133333393CD1A5841CDCCCCCC512120419A999939CC1A584133333333C9202041000000C0CA1A58419A9999999D2020419A9999B9CA1A5841000000007520204166666686CB1A5841000000005420204133333393CB1A58419A999999D41F20419A9999F9C71A5841666666669D1F204166666646C61A58419A999999921F204133333393C91A584166666666891F2041CDCCCC2CCD1A5841000000007F1F2041666666E6CF1A584133333333551F204100000060E21A5841CDCCCCCC441F2041333333F3E61A584100000000121F20419A9999D9F11A584133333333FE1E2041CDCCCCCCF81A584166666666EF1E2041000000C0FF1A5841CDCCCCCCE11E20419A999999041B58419A999999CD1E20419A999979091B584133333333AC1E2041CDCCCC0C101B58419A9999999E1E2041CDCCCC4C131B5841333333338F1E2041333333B3171B5841CDCCCCCC891E2041CDCCCC0C1B1B5841666666667B1E2041000000401F1B5841CDCCCCCC781E204133333373211B5841000000007B1E2041333333932A1B584100000000731E20419A9999B9331B584166666666741E20419A999959371B5841333333337B1E20419A9999393C1B584166666666761E2041CDCCCC4C411B58419A999999741E204166666666471B584166666666761E2041666666064B1B58419A9999997F1E2041000000C0501B5841666666667B1E2041CDCCCC0C581B58419A999999771E20419A9999595A1B584100000000651E2041333333135E1B584166666666491E2041000000E0601B5841CDCCCCCC331E204100000080641B5841666666660E1E2041333333336D1B5841CDCCCCCCE51D2041CDCCCC8C751B584100000000D61D2041333333D3791B584133333333A81D2041CDCCCCEC7F1B5841666666669F1D2041666666C6811B58419A9999998C1D20419A999939871B584133333333741D2041CDCCCCAC8C1B5841CDCCCCCC531D20419A999919911B58419A999999511D20419A999919921B584133333333531D2041000000C0971B5841333333334D1D2041CDCCCC0C9C1B5841CDCCCCCC2A1D2041333333F3A51B584133333333201D204133333313AB1B5841CDCCCCCC1A1D2041666666E6AB1B584133333333FF1C2041CDCCCCCCAD1B584133333333ED1C2041000000C0AF1B584133333333E21C20419A999999B11B58419A999999BF1C204100000020B91B584166666666A21C2041333333D3BD1B584133333333941C204100000040BF1B584100000000601C204166666626C31B584166666666561C2041CDCCCC6CC41B584133333333501C204133333313C61B5841CDCCCCCC501C2041333333F3C71B584100000000581C2041666666A6CA1B58419A999999581C204133333393CC1B584100000000491C20419A9999D9D31B5841666666663F1C20419A999979E01B58419A999999201C204100000060FA1B5841333333331A1C2041CDCCCCCC031C584100000000091C2041000000800F1C584100000000001C2041000000001A1C58419A999999FF1B2041000000A01E1C584166666666F51B2041666666062C1C584133333333EF1B20419A9999D92F1C584100000000F11B20419A9999F9321C5841CDCCCCCCEA1B2041000000C0391C5841CDCCCCCCEA1B2041333333F3401C584166666666CF1B204100000000651C5841	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	01010000206A080000ABF52B055C282041666666D6A31B5841	820090000	Z	Balignac	8200900	82009	82	76	4
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	01010000206A080000A345C3537C3520413433338372235841	820100000	Z	Bardigues	8201000	82010	82	76	12
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	01010000206A080000ECA83318B21721419A999939DD275841	820110000	Z	Barry-d'Islemade	8201100	82011	82	76	11
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	01010000206A080000CA25186CDBE42041000000B0CA295841	820120000	Z	Les Barthes	8201200	82012	82	76	8
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	01010000206A0800003DEA699EA87620410000001087135841	820130000	Z	Beaumont-de-Lomagne	8201300	82013	82	76	46
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	01010000206A080000005CCC9922BB2041CDCCCC4CDE0B5841	820140000	Z	Beaupuy	8201400	82014	82	76	12
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	01010000206A08000081F331F4FFA020419A9999B9C4155841	820150000	Z	Belbèze-en-Lomagne	8201500	82015	82	76	4
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	01010000206A08000004777E7C23B8204134333363D2435841	820160000	Z	Belvèze	8201600	82016	82	76	14
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	01010000206A080000A003C77CB81E21413333332343135841	820170000	Z	Bessens	8201700	82017	82	76	10
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	01060000206A080000010000000103000000010000001C01000066666666BAB02141000000A0A62958419A99999926B12141333333D3AF295841666666663BB321419A999939E129584133333333BEB32141333333D3EE295841666666660EB4214100000000F5295841CDCCCCCC20B52141000000A0132A58410000000046B52141333333930F2A5841333333336FB52141333333D3122A5841000000005DB5214100000040172A58416666666624B521419A9999992A2A58413333333314B521419A9999D9332A5841CDCCCCCC02B5214166666666362A58416666666698B5214133333353342A5841CDCCCCCCD7B52141CDCCCC4C342A58416666666669B62141CDCCCC4C382A584133333333D2B62141CDCCCCEC3D2A5841CDCCCCCC4DB72141333333B3412A5841CDCCCCCCA8B7214100000040472A5841000000001EB821419A9999D9512A58419A99999984B82141000000C0582A5841CDCCCCCCF8B821419A9999F9612A58410000000080B92141333333136E2A5841000000001CBA214100000080702A584100000000A2BA21419A999979702A58419A999999CFBA21419A9999997B2A584166666666DFBA21419A9999B9862A584133333333D6BA2141333333F3972A58419A99999975BA214100000000982A58416666666631BA2141666666C6992A584133333333DBB921419A9999799F2A5841CDCCCCCC7CB92141CDCCCCECA32A584166666666DBB82141666666E6AE2A584166666666D1B7214100000080CB2A5841CDCCCCCC95B7214133333353D22A58419A999999B9B721419A999999DE2A58419A99999931B821419A999939FC2A5841CDCCCCCCFCB8214133333353282B5841CDCCCCCC1AB92141333333B3262B584133333333FBB921419A9999794A2B58419A99999967BA214166666686482B5841CDCCCCCCD1BA21419A9999F9422B58419A999999B2BB214133333313362B5841CDCCCCCCFDBB214100000060302B5841666666665CBC2141CDCCCC0C2D2B58416666666654BC21419A999939332B58419A99999987BC2141000000A0472B5841666666667EBC21419A9999F94D2B5841CDCCCCCC2FBC214100000020632B58413333333323BC2141333333F36B2B5841CDCCCCCC24BC214100000080822B584100000000ADBC2141CDCCCC0C782B58419A999999D3BC21419A999999762B58413333333342BD2141CDCCCC0C792B584100000000B5BD21419A9999197E2B5841333333332BBE2141CDCCCCCC812B5841CDCCCCCC1CBF2141333333F38B2B58419A9999993DC02141CDCCCC0C922B5841CDCCCCCC01C121419A9999F9972B58410000000072C1214166666626992B58416666666614C22141333333D39B2B5841333333338BC22141CDCCCC8C9C2B5841000000004CC32141666666069C2B584133333333E1C32141CDCCCC0C9A2B584166666666C5C4214133333373992B5841666666661AC52141000000009C2B5841CDCCCCCC3EC52141333333139F2B5841000000000AC521419A9999F9AA2B58419A999999E2C42141CDCCCCACBA2B5841CDCCCCCCADC4214100000000CC2B58419A99999953C4214100000080E42B5841666666660EC4214100000080F82B584166666666DFC32141CDCCCC0C032C58410000000093C32141666666260D2C58410000000027C3214166666606212C584166666666ABC22141000000E0432C58419A9999997EC22141333333D3572C58419A999999F2C2214100000040552C58413333333372C321419A9999B9532C58410000000087C3214166666646522C58419A999999ADC42141000000C04B2C5841000000004CC5214133333353462C584166666666F1C52141666666E63D2C58416666666625C72141666666E63D2C5841CDCCCCCC7EC72141333333F33B2C584166666666C4C72141000000E0332C584133333333E8C72141000000C02B2C58419A999999FDC72141666666E61C2C58413333333319C821419A999939162C5841CDCCCCCC8BC82141000000C0092C5841333333330EC92141333333F3FC2B58419A9999993EC9214133333333F92B58419A99999966C9214133333393F82B58419A999999FEC9214166666626ED2B58416666666651CA2141666666A6E82B5841CDCCCCCCF7CA2141CDCCCC2CE92B5841CDCCCCCCE8CB2141000000E0EE2B5841CDCCCCCC2ECC214100000020F52B5841CDCCCCCC8DCC2141CDCCCCCCF82B584166666666E6CC2141CDCCCCACFF2B58410000000021CD2141CDCCCC4C092C58416666666690CD2141666666860A2C584133333333E2CD214166666666082C58419A99999960CE21419A9999B9032C584100000000E9CE21419A999919002C58419A9999994CCF214100000040FC2B584133333333BCCF214133333373FA2B58413333333357D0214100000060F52B584166666666CED0214166666646F22B5841333333335FD12141CDCCCC4CF42B58419A999999F4D1214166666606FB2B5841666666669BD2214133333313002C58419A99999953D32141CDCCCCEC042C584100000000ACD3214166666626042C58416666666667D42141CDCCCCAC002C5841CDCCCCCCA4D4214133333333012C584133333333F0D42141000000E0FF2B58413333333362D521419A999919F92B58410000000037D621419A9999B9F12B5841CDCCCCCC8ED62141CDCCCC6CEC2B58419A999999C3D6214100000020E72B5841CDCCCCCC3BD7214133333373D42B5841CDCCCCCCB6D7214100000060C22B5841CDCCCCCC42D82141CDCCCC0CB52B5841CDCCCCCCD1D921419A9999B9992B584133333333BCDA2141CDCCCCEC8C2B58419A999999BBDB2141666666A67F2B584166666666A0DC2141000000A0782B58410000000005DD2141CDCCCCAC742B5841CDCCCCCC4DDD21419A999999702B584100000000BBDD214133333393672B584133333333A0DE214133333313592B5841CDCCCCCCEDDE2141666666C6512B58419A999999BDDF21419A9999D9402B58416666666606E021419A999959392B5841333333334FE02141000000402F2B584166666666EEE02141000000C0032B5841666666664DE121419A999979EC2A584166666666DDE12141CDCCCC4CD72A58410000000083E221419A999939C22A584133333333ABE221419A9999F9BA2A58419A9999990AE3214100000060AC2A5841CDCCCCCC37E32141000000A0A62A5841CDCCCCCC67E3214133333333A32A5841CDCCCCCC36E42141CDCCCC8CB72A58419A999999F9E42141CDCCCC2CCC2A58419A99999946E52141CDCCCC4CD32A5841666666668FE52141CDCCCCACC82A58419A999999A2E621419A999979A42A5841000000001DE721419A9999F9942A58410000000085E72141666666C6882A5841CDCCCCCC6EE82141666666A66A2A5841000000003FE92141000000204F2A58410000000071E9214133333353492A584100000000A1E9214100000080472A584133333333C0E9214100000000402A5841CDCCCCCC00EA2141CDCCCCEC352A5841CDCCCCCC2DEA2141000000E01D2A58413333333344EA2141CDCCCCAC0C2A5841666666662FEA2141333333D30A2A58413333333301EA214133333333122A584100000000AEE921419A999919102A5841CDCCCCCC71E921419A9999590A2A58419A99999930E92141CDCCCCCC0A2A5841666666660CE92141000000E0012A5841CDCCCCCCE1E8214166666606012A5841CDCCCCCC29E82141CDCCCC2CF629584100000000F5E721419A9999D9E52958419A99999923E8214166666666DE2958419A999999FFE72141666666C6D92958419A999999E1E72141333333B3D229584100000000CDE7214100000040CA2958410000000094E7214166666666BA2958410000000085E72141000000E0B3295841333333338AE72141CDCCCC8CA52958413333333385E72141000000609F295841CDCCCCCC59E72141000000E08D2958410000000055E7214133333373872958410000000068E72141CDCCCC2C8329584100000000A9E72141CDCCCCCC7E295841CDCCCCCCB6E721419A9999797929584133333333B8E72141CDCCCC4C7129584133333333E0E72141333333D369295841000000000FE8214166666666662958410000000012E82141000000A05C295841CDCCCCCC2CE821413333335355295841666666666FE8214133333313492958419A999999A1E82141333333B33A29584133333333F1E82141666666662E29584100000000D0E821419A9999192429584133333333E2E82141CDCCCC0C1C2958419A999999D7E821413333333319295841CDCCCCCC76E82141000000E0082958419A9999990AE8214166666666EF28584166666666D1E7214166666686D828584133333333CAE7214166666666CC285841CDCCCCCC8CE7214100000020CD285841333333334BE6214166666646CB2858419A999999B4E52141666666E6C928584133333333CDE42141CDCCCC4CC42858419A999999AFE321419A999939B828584166666666A9E22141000000E0AB285841CDCCCCCC26E2214166666686A4285841CDCCCCCC6CE12141000000A096285841CDCCCCCC0CE121410000000090285841CDCCCCCC55E021419A9999B98428584166666666F7DF2141666666A680285841CDCCCCCCFFDE2141000000407828584166666666ACDE214100000040762858419A99999913DE2141CDCCCCAC74285841CDCCCCCCEADC2141333333736F28584166666666CEDB214166666626672858419A999999DBDA2141000000A06228584166666666FCD921419A9999D960285841CDCCCCCC0CD92141333333D360285841CDCCCCCC83D82141666666E662285841333333334DD72141CDCCCCAC662858419A99999988D52141333333536A2858416666666633D52141CDCCCC4C6B2858416666666681D221419A9999D9792858416666666649D12141CDCCCCAC7E285841000000009BD0214166666626822858413333333325D02141CDCCCC8C85285841333333338DCF2141333333738D2858419A9999991FCF2141333333F39528584166666666ABCE2141333333F3A02858419A99999903CE214100000000B22858419A99999982CD2141333333F3BD2858419A999999B7CC21419A9999D9CB285841333333337ECC2141CDCCCCCCCC285841666666663DCC214133333333CB2858413333333384CB2141CDCCCC0CCA285841CDCCCCCC8FCA214166666646C1285841333333333DC9214100000020C128584100000000C4C82141666666A6BC2858419A999999F5C7214166666626B42858419A9999996CC721419A9999F9A32858419A999999BDC621410000004092285841CDCCCCCC3AC62141666666067E28584100000000B7C5214166666626662858419A999999E7C421419A9999B91C2858410000000077C421419A9999390228584166666666EBC321419A9999D9E7275841666666666FC32141CDCCCCCCD127584133333333EDC22141CDCCCC2CC12758416666666673C22141333333F3B6275841CDCCCCCCC9C121419A999939AF2758419A99999987C12141CDCCCC8CB02758416666666685C1214133333373B727584166666666EBC02141CDCCCC6CCC275841666666664EC0214100000020D52758413333333318C0214166666606E22758419A9999999BBF2141CDCCCCECF1275841CDCCCCCC89BE21419A9999191B2858419A999999FABD21419A9999192B285841CDCCCCCC8DBD214100000080322858416666666613BD2141333333F334285841CDCCCCCCEDBB21419A99993936285841000000006FBB2141000000803A2858416666666620BB2141000000C043285841CDCCCCCCC7BA21419A9999D95328584133333333A2BA21413333331363285841CDCCCCCC03BA21419A9999F9922858419A999999CDB921419A9999F99E285841CDCCCCCC58B92141666666C6AF285841CDCCCCCCF0B8214133333393BB285841CDCCCCCC91B8214100000080C3285841666666669EB7214100000020D2285841CDCCCCCC55B72141333333D3D528584166666666C2B621419A999939DF2858413333333375B621419A999939E728584166666666F4B521419A9999D9F82858413333333365B52141000000200829584133333333D6B421419A9999791A295841333333337AB4214166666606242958419A999999FEB32141000000C02F2958419A9999999AB32141666666863A295841333333334FB32141000000C04429584133333333EBB2214166666646502958413333333346B2214133333313612958419A99999993B121410000002078295841000000003EB12141CDCCCCEC8529584133333333CEB02141CDCCCCAC9F29584166666666BAB02141000000A0A629584166666666BAB02141000000A0A6295841	01010000206A0800003E0AD7A3D7CE2141000000E0032A5841	820180000	Z	Bioule	8201800	82018	82	76	20
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	01010000206A0800004F1EF47C6A80204166666616912B5841	820190000	Z	Boudou	8201900	82019	82	76	12
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	01010000206A0800009E59F49E71BD20419A9999F96C0F5841	820200000	Z	Bouillac	8202000	82020	82	76	31
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	01010000206A0800005E09315483CD20419A9999193B405841	820210000	Z	Bouloc-en-Quercy	8202100	82021	82	76	15
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	01010000206A0800001449FE5CC5562041CDCCCC4C2E3B5841	820220000	Z	Bourg-de-Visa	8202200	82022	82	76	14
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	01010000206A080000C6C8F97B0FD820419A999999CA195841	820230000	Z	Bourret	8202300	82023	82	76	17
01060000206A08000001000000010300000001000000330400006666666619582041CDCCCC0C74375841CDCCCCCC1E582041000000007837584133333333245820419A9999797A375841CDCCCCCC295820410000002080375841333333332958204166666686833758419A9999992458204166666646873758410000000023582041CDCCCC0C903758419A99999923582041CDCCCC6C923758410000000028582041000000E097375841666666662E582041666666069A3758419A99999943582041000000C09E375841CDCCCCCC4C58204166666686A0375841666666669B58204166666606A237584133333333F1582041000000C0A5375841CDCCCCCC2C592041CDCCCC2CA3375841333333336C592041666666E6A0375841CDCCCCCCC4592041333333539D37584100000000415A204166666686993758419A9999995B5A2041CDCCCC4C98375841000000006D5A20419A9999F9963758419A999999BC5A2041666666469137584166666666CF5A2041CDCCCC8C8F37584100000000195B20413333333385375841CDCCCCCC345B20419A9999F98137584100000000515B20419A9999997F375841CDCCCCCC5E5B2041666666A67E375841000000007B5B2041333333B37B375841000000009C5B2041000000807937584100000000B35B2041CDCCCCCC77375841CDCCCCCCC65B2041333333937637584133333333D95B204133333313753758419A999999EA5B2041000000A073375841000000001F5C2041666666E66D37584166666666225C2041333333B36C375841CDCCCCCC3D5C20419A99997969375841666666665E5C2041333333F365375841333333336E5C2041CDCCCC0C65375841000000009B5C20419A99993963375841CDCCCCCCCC5C2041000000A0613758419A999999525D2041CDCCCC0C5E375841CDCCCCCCCB5D2041CDCCCC6C5B37584133333333D05D2041CDCCCCAC6837584133333333D55D2041333333336C37584166666666E95D20419A9999997637584100000000EF5D2041000000C07D37584166666666EF5D2041333333738137584133333333F05D2041666666C68537584133333333EA5D2041666666468B375841CDCCCCCCE45D2041CDCCCC0C8E37584166666666F45D20419A9999598C375841666666660B5E2041333333338B3758419A999999185E2041000000608A3758419A9999996A5E2041000000809D375841CDCCCCCC605E2041333333339F375841CDCCCCCC525E2041CDCCCC2CA3375841CDCCCCCC475E20419A999939A837584100000000395E2041000000A0AD375841666666661B5F204100000040BB3758419A999999505F204133333353BE37584100000000575F20419A9999F9BC375841000000006B5F2041CDCCCC8CB737584100000000955F204100000060B537584100000000A55F2041CDCCCCCCB437584166666666C65F2041CDCCCCCCB137584100000000066020419A9999F9AD3758410000000032602041333333D3A8375841CDCCCCCC5360204166666686A5375841666666665C60204133333313A4375841333333336B60204100000000A3375841000000007260204100000080A23758419A9999999A602041CDCCCC6CA037584166666666BE602041666666269E37584100000000D5602041CDCCCC6C9D37584166666666F5602041333333739C375841000000003C6120419A9999B997375841CDCCCCCC5B6120410000000096375841000000007161204133333373943758416666666677612041CDCCCC2C943758419A9999999C612041333333739237584100000000E0612041333333B38E3758419A99999924622041666666E68A3758419A999999646220419A9999598837584166666666706220419A9999B9873758416666666684622041333333B38637584166666666C1622041000000208437584133333333EB62204100000020833758419A999999F56220419A999979823758416666666637632041333333737F37584133333333726320419A9999597D375841666666667E632041CDCCCC8C7C3758419A99999986632041666666467C375841333333339D632041333333737B37584166666666F96320419A9999397D3758413333333322642041CDCCCC0C7E375841333333333B642041CDCCCC0C7E3758419A999999486420419A9999197E3758410000000078642041000000007D3758410000000080642041333333D37C37584166666666966420419A9999597D37584100000000AA642041333333537E3758419A999999BC642041333333F37F3758419A999999D66420413333339383375841CDCCCCCC13652041333333738B3758410000000050652041333333338C3758413333333342652041CDCCCC0C8F37584100000000336520419A99993994375841000000002D652041666666C696375841000000001F652041666666A69F375841CDCCCCCC146520419A999959AD3758410000000012652041000000E0AF3758419A9999990C6520419A9999B9B23758410000000000652041000000A0B737584166666666FD6420419A9999B9B9375841CDCCCCCCFE642041CDCCCC8CBE37584133333333FE642041CDCCCCCCC0375841CDCCCCCCF864204166666666C23758419A999999F564204100000040C437584133333333FC642041000000C0C7375841000000000865204100000060CA3758413333333312652041333333B3CB375841000000001B6520419A999999CD375841CDCCCCCC22652041333333B3CF375841666666663065204100000020D4375841CDCCCCCC30652041666666A6D43758410000000031652041000000C0D437584100000000336520419A999939D737584100000000326520419A999979DF3758410000000039652041CDCCCC2CE23758419A9999993F6520419A999999E3375841333333335465204166666666E8375841000000006D652041666666A6ED3758413333333373652041666666A6F03758419A999999736520419A9999F9F437584133333333756520419A999999F83758419A9999997A65204100000040FF3758419A9999997B65204166666626033858419A9999997A65204133333373063858419A99999977652041CDCCCC8C09385841CDCCCCCC71652041CDCCCCCC0C385841333333336065204100000020133858413333333357652041666666E615385841CDCCCCCC51652041666666E618385841CDCCCCCC50652041CDCCCC4C1C385841CDCCCCCC516520419A9999791F385841333333334F6520410000006022385841CDCCCCCC2F652041333333932A3858413333333327652041000000402D3858410000000019652041000000C032385841CDCCCCCC186520419A99999935385841333333331A6520419A9999F936385841CDCCCCCC1B65204100000040383858419A9999992B652041000000E03D3858419A9999992E6520419A9999594038584166666666316520416666666649385841666666662E652041666666C64D385841CDCCCCCC26652041000000205238584133333333266520419A99993954385841666666662A652041CDCCCC2C56385841666666662C652041000000E056385841000000003F652041CDCCCCEC5A3858419A99999952652041333333B36038584100000000666520416666660664385841CDCCCCCC726520419A9999D96538584100000000846520419A999939673858410000000098652041CDCCCC6C6838584100000000AC652041000000806938584166666666D5652041666666A66C385841CDCCCCCCFD6520419A999999703858413333333321662041333333B37438584133333333436620419A9999F978385841333333335C662041000000007D3858410000000064662041333333937E3858419A9999996C662041666666C67F38584100000000716620416666662680385841333333337C662041CDCCCC0C81385841333333337E662041CDCCCC6C823858419A9999997D6620419A99991985385841CDCCCCCC7966204100000000873858419A9999997766204166666666893858419A99999972662041333333D392385841666666666D6620419A9999F997385841000000006C662041CDCCCCAC9A385841666666666C662041666666669D3858410000000070662041CDCCCC2C9F385841CDCCCCCC8D6620419A9999F9A638584166666666B66620419A999959B4385841CDCCCCCCBF662041666666C6B638584166666666D866204166666626BC38584100000000F96620419A999959C4385841000000001567204166666606C9385841CDCCCCCC3D6720419A999939CF3858419A99999955672041CDCCCCCCD3385841666666667567204100000080DA385841CDCCCCCC806720419A9999D9DC385841CDCCCCCC8967204166666666DF385841000000009B672041666666C6E638584100000000A46720419A9999B9E838584166666666B26720419A999999EC38584133333333B8672041333333B3EE38584166666666BC67204100000040EF3858419A999999CF67204166666646F238584133333333D8672041666666A6F438584100000000E867204133333313F938584166666666EB67204133333393FA385841CDCCCCCCF1672041666666C6FB38584166666666FD67204166666626FF3858419A9999990368204166666626023958416666666619682041333333930A395841CDCCCCCC1E682041000000600D3958410000000023682041CDCCCCAC1039584100000000246820419A9999F913395841CDCCCCCC22682041000000C015395841CDCCCCCC2068204100000020183958410000000021682041666666261B3958419A99999928682041333333731F395841CDCCCCCC32682041CDCCCCCC2239584133333333466820419A9999392839584133333333476820413333339329395841CDCCCCCC4F6820419A9999792C3958419A9999994F682041000000E02E3958419A9999994B682041CDCCCC2C313958416666666631682041333333F339395841CDCCCCCC0C682041333333B335395841333333330468204100000000353958419A999999FE672041CDCCCC0C36395841CDCCCCCCF367204133333353373958419A999999E96720410000008039395841CDCCCCCCBB672041000000E04139584100000000A06720410000006046395841666666666C672041333333934F3958416666666651672041333333D356395841CDCCCCCC3F672041333333135B395841666666662A672041666666265F3958419A9999990E672041000000E06239584166666666F1662041000000006639584166666666C76620419A9999F96839584100000000AC6620419A9999D96B395841000000007A6620416666662670395841666666666D6620419A9999196D395841666666666B662041333333736D395841333333333C662041666666066839584133333333FA652041333333F3713958419A999999CA6520419A99995976395841CDCCCCCC88652041000000207C395841333333337C6520419A9999397D3958419A99999966652041CDCCCC8C7F3958413333333343652041000000E0813958419A99999915652041000000608539584133333333FF6420419A9999198639584100000000DC64204166666686873958419A999999B46420419A999979893958419A99999993642041000000C08B395841CDCCCCCC8A6420419A99993986395841CDCCCCCC05642041000000408D395841CDCCCCCCBA632041666666E690395841333333335D632041CDCCCC8C973958416666666633632041333333739B395841CDCCCCCC1F6320416666668699395841CDCCCCCC1A632041666666269A395841CDCCCCCC02632041CDCCCCEC9A39584166666666ED622041CDCCCC8C9C395841CDCCCCCCEA6220419A9999D99F39584133333333DC62204100000080A43958419A999999BB622041000000E0A439584166666666A662204133333393A43958419A9999999E62204100000080A439584133333333506220419A999959A3395841CDCCCCCC06622041CDCCCC4CA23958419A999999AF612041333333F39F39584133333333AB612041666666E69F39584100000000B7612041333333F39C39584166666666BD612041666666469C39584100000000AE61204100000080993958419A9999999D612041666666469739584166666666856120413333337393395841CDCCCCCC5D612041666666268E395841666666661A612041000000E0853958416666666654602041CDCCCC2C6B39584100000000386020416666664666395841CDCCCCCC326020419A9999F963395841333333332C602041000000E0613958419A99999924602041CDCCCC8C62395841000000000E602041CDCCCCAC633958419A999999E65F20416666664666395841CDCCCCCCC95F2041CDCCCC4C6939584133333333A95F2041CDCCCC2C6E395841333333334C5F2041333333737D3958419A9999992E5F20416666660683395841CDCCCCCC135F2041CDCCCC8C883958419A999999F45E2041000000008E395841CDCCCCCC8F5E204166666666A5395841333333336F5E20419A999979AA3958419A999999675E2041666666A6AB395841666666664B5E2041CDCCCCCCAE3958419A999999DE5D2041333333F3BA39584100000000B55D204133333333C0395841CDCCCCCCA15D204133333353C639584133333333945D2041333333B3CA3958419A999999805D204133333333D53958419A9999996F5D2041666666C6DF395841666666666E5D20419A9999B9E639584100000000875D2041000000C0EB3958419A999999BB5D204133333393F43958419A9999990E5E204166666646013A5841CDCCCCCC3F5E204166666686093A5841666666666C5E2041666666660B3A5841666666668F5E2041333333330D3A58419A999999EA5E20419A9999F9123A5841CDCCCCCC125F2041CDCCCC0C163A584100000000425F204166666606193A584166666666FF5E2041666666262A3A58419A999999275F2041000000202C3A58419A999999EA5E2041000000C0463A5841333333332B5F2041333333F3473A584133333333F35E2041CDCCCCEC603A5841666666669F5E20419A999959863A5841CDCCCCCC8E5E2041666666E6893A5841666666668E5E2041000000008A3A584166666666655E204166666666923A58419A9999994D5E204166666686993A584100000000345E2041000000C09D3A584100000000055E20419A999979A53A584133333333B55D2041666666A6B23A58419A9999995A5D20419A999979BC3A584100000000125D204100000020CA3A584133333333E45C20419A999919D33A58419A999999CD5C2041666666A6D63A5841CDCCCCCCBA5C2041000000A0DA3A58419A999999CC5C204133333353DF3A5841CDCCCCCCC45C2041CDCCCCACE03A584133333333A25C2041000000C0E73A58419A999999995C204133333313EC3A5841CDCCCCCC995C204166666646ED3A5841333333339D5C2041000000C0F03A5841CDCCCCCC8D5C204100000020F53A584166666666985C20419A999939F83A58419A999999A55C2041000000E0FC3A584100000000B45C2041CDCCCCCC023B584166666666BA5C2041333333D3043B584100000000C65C204100000060073B584166666666D25C2041333333B30C3B5841CDCCCCCCE75C2041CDCCCC4C163B58419A999999FE5C2041333333331F3B584100000000125D204133333353283B5841CDCCCCCC225D204166666646283B5841CDCCCCCC385D20419A9999D9273B5841333333334E5D2041CDCCCCAC273B584133333333825D2041CDCCCCEC283B58419A999999B65D2041000000E0293B584166666666CD5D2041333333532A3B584133333333E45D2041666666062B3B5841CDCCCCCC115E2041000000002C3B58419A999999455E2041333333932D3B584133333333A55E2041333333D32F3B584133333333BB5E2041000000C02F3B584133333333D05E2041CDCCCC6C2F3B5841CDCCCCCCE85E2041666666E62D3B584166666666FD5E2041333333532B3B58419A999999165F20419A999919293B584100000000525F204100000060243B5841000000005D5F204166666686233B5841CDCCCCCC6E5F204100000000233B58419A999999975F20419A999999223B584100000000C15F20419A9999D9213B584100000000D75F2041666666C6203B584166666666ED5F2041333333331F3B5841CDCCCCCCF35F2041333333931E3B584100000000F75F2041CDCCCCCC1F3B5841333333330260204133333353253B58419A9999990B602041CDCCCC0C2C3B58410000000011602041CDCCCCAC2F3B58419A999999CB602041333333B3393B5841666666662761204100000080343B58419A999999776120419A9999192E3B584133333333DB612041CDCCCCAC273B584166666666F561204100000040253B58419A99999922622041CDCCCC6C213B5841000000003E622041CDCCCC0C1F3B584133333333636220419A9999391C3B5841CDCCCCCC89622041CDCCCC0C193B584166666666A9622041CDCCCC2C153B58419A999999CB62204133333373113B5841CDCCCCCCDF622041666666260E3B5841CDCCCCCCFC622041000000000B3B58410000000025632041000000600A3B58416666666643632041666666A6093B58416666666642632041666666A6083B58419A99999935632041CDCCCC8C053B5841666666662563204133333353023B5841333333332D63204166666606023B5841000000004A63204100000020003B58419A99999967632041666666E6FC3A5841666666668563204100000040FA3A584100000000A063204133333353F73A584166666666CF632041000000A0F43A5841CDCCCCCCDE63204133333313F33A584166666666F9632041CDCCCC4CF53A58419A9999990364204133333353F63A58419A9999990F64204166666606F73A5841666666662E642041CDCCCCECF73A584133333333326420419A9999D9F73A5841000000004D642041000000A0F83A584166666666626420419A999999F73A5841CDCCCCCC7C642041333333D3F53A58419A9999999664204166666646F33A58419A999999AB642041333333D3F03A584100000000EA642041CDCCCC0CEB3A58419A99999913652041CDCCCC8CE63A5841333333333A65204133333333E33A5841333333335365204133333313E23A5841CDCCCCCC5465204166666626E23A584100000000716520419A999919E03A5841000000008F65204133333353DF3A584100000000DD65204133333313DF3A5841000000002D662041000000E0DF3A5841666666665166204100000000E03A58410000000080662041CDCCCC8CDF3A5841CDCCCCCCCF662041CDCCCC0CDE3A584100000000EF662041666666A6DD3A58419A999999116720419A9999F9DC3A5841CDCCCCCC3667204166666686DC3A5841000000005567204166666626DD3A5841666666667367204166666606DF3A584100000000926720419A999979E03A58419A999999B5672041666666A6E03A58419A999999FB67204100000000E03A5841333333334368204100000060E13A5841000000006E68204166666646E13A58413333333390682041333333F3E03A584166666666AA682041CDCCCCACE03A584166666666186920419A9999F9DF3A5841000000003B69204166666666DF3A5841333333337D6920419A999979DC3A584100000000A16920419A999939DB3A584133333333C1692041000000E0D93A5841333333330A6A204133333333D83A5841CDCCCCCC2C6A20419A9999B9D73A5841CDCCCCCC386A204100000020D73A5841666666667E6A2041CDCCCCACD63A584133333333AF6A20419A9999B9D63A584166666666DE6A2041000000A0D73A584166666666E56A204100000060E63A5841CDCCCCCCD16A20419A999919FB3A584133333333B56A2041333333B3083B5841CDCCCCCC516A2041CDCCCCAC2B3B5841666666662D6A2041666666C63D3B584166666666CE6A20419A999959463B584100000000DF6A204100000040473B5841CDCCCCCCC56B204100000000523B584133333333DE6B204166666646533B5841333333331F6C2041CDCCCC4C583B584133333333396C20419A9999B95A3B58419A9999996B6C20419A9999F95F3B584133333333916C2041CDCCCCEC653B5841CDCCCCCC9D6C2041CDCCCC8C683B584100000000A46C204166666626693B584133333333B26C2041000000A06C3B5841CDCCCCCCB96C20419A9999F9763B5841CDCCCCCCB86C2041000000007D3B584133333333A76C2041000000208F3B58419A9999999F6C2041000000E09A3B584166666666936C204100000060A63B584166666666896C20419A999999AC3B5841000000006C6C2041666666A6B73B5841CDCCCCCC5E6C204133333313BF3B584133333333446C2041CDCCCCCCC63B58419A9999990D6C2041000000A0D43B5841CDCCCCCC276C204133333373D23B584166666666BB6C204166666606C53B584166666666ED6C2041666666E6BE3B584166666666F96D2041CDCCCC2C9E3B5841000000003E6F2041000000E0753B58410000000034702041333333F3573B58413333333379702041000000204F3B584133333333CB7020419A999959453B584133333333EC702041CDCCCC0C413B5841CDCCCCCC0D712041666666063D3B5841000000002A7120419A9999193A3B58419A999999367120419A999919393B5841666666666271204133333393353B58410000000008722041CDCCCCEC273B5841CDCCCCCC0D7220419A999979273B58413333333393712041CDCCCCCC1C3B5841CDCCCCCC70712041000000801A3B58419A9999994971204166666626183B5841CDCCCCCC2D71204133333313163B5841CDCCCCCC1871204166666666123B584133333333F6702041333333B30A3B584166666666D0702041000000C0023B584133333333BF70204133333333FE3A5841CDCCCCCCB07020419A9999F9F93A5841CDCCCCCC9F70204166666666F63A5841666666668A70204166666606F33A5841000000007E702041CDCCCC6CF03A584100000000737020419A999979EE3A5841333333338970204100000000EC3A5841CDCCCCCC9B702041666666E6E83A58419A999999A9702041CDCCCCACE53A584133333333B070204166666646E33A584166666666BC702041CDCCCCACE03A584133333333D070204166666606DD3A584100000000E470204166666666DA3A584166666666EB702041666666E6D83A5841000000000671204133333353D33A58413333333335712041CDCCCCACCA3A5841000000004B71204100000040C53A5841000000005C71204166666686C13A5841000000008171204166666686BA3A58410000000095712041000000A0B33A58410000000096712041000000C0B23A58419A999999977120419A999939B13A5841000000009D712041CDCCCCCCAE3A58419A999999A771204133333373AB3A58419A999999C5712041CDCCCCACA53A5841CDCCCCCCFC712041333333F39F3A58419A99999931722041666666469B3A5841333333334472204166666666993A5841666666665C722041CDCCCCAC963A5841000000006C722041666666A6943A5841CDCCCCCC9F722041000000E0963A5841CDCCCCCCD372204100000040983A58419A999999387320419A9999199C3A5841333333337E732041666666E69B3A584166666666E07320419A9999799B3A584100000000D773204166666686983A584100000000B2732041CDCCCC4C8E3A5841CDCCCCCCBF732041000000208C3A58419A999999C67320419A9999798B3A58419A999999E2732041CDCCCC4C873A5841CDCCCCCCF07320419A9999B9843A5841333333330674204100000020823A584100000000207420419A9999B97F3A58419A9999993B742041666666C67D3A58413333333362742041333333B37B3A5841666666667C742041000000C07A3A584166666666AA74204133333313793A5841000000001A75204100000080743A5841000000003C7520419A999999723A5841666666665F75204100000060703A5841000000007E752041333333536E3A58416666666682752041000000E06D3A5841CDCCCCCC88752041333333336D3A58419A999999C37520419A9999D9693A5841666666660A762041CDCCCC2C643A5841333333332A76204100000080663A5841000000003E762041333333F35F3A58419A99999958762041000000805D3A58410000000062762041333333F35F3A5841000000005D76204100000040633A58416666666661762041000000E0653A5841666666667676204100000000653A5841CDCCCCCC7E762041666666A6613A58416666666690762041000000005E3A5841CDCCCCCC9D762041CDCCCC2C5C3A5841CDCCCCCCAA762041333333F35A3A584100000000B3762041333333335A3A584166666666C4762041333333F3583A584133333333FD762041CDCCCCAC553A5841333333331477204100000040533A5841666666662F77204166666666503A5841333333333F772041333333B34E3A5841CDCCCCCC46772041000000C04D3A58416666666674772041333333F3493A5841000000009177204133333353473A5841CDCCCCCCA677204133333333453A584100000000B9772041CDCCCC0C433A58419A999999CE7720419A9999593C3A5841CDCCCCCCDE7720419A9999B9393A584133333333157820419A999919323A5841333333332D782041333333732F3A58413333333357782041666666662B3A58410000000060782041333333F3293A58419A999999697820419A999979273A58419A999999A3782041666666C61F3A584133333333A4782041666666661E3A5841CDCCCCCCBE782041333333931A3A584166666666EC78204166666606153A5841CDCCCCCCF97820419A999999133A584166666666FB782041CDCCCC4C133A58419A999999387920419A9999990D3A58413333333344792041666666A60C3A58410000000052792041333333930B3A58410000000074792041333333730A3A5841CDCCCCCC82792041666666C6093A58419A9999998E7920419A999939093A5841333333339E79204166666646083A58419A999999E679204133333373033A5841666666661F7A2041CDCCCC6C003A5841CDCCCCCC297A2041000000C0003A584166666666347A20419A999919003A5841333333336E7A2041333333B3FB395841333333338D7A20419A999999F939584100000000AD7A20419A9999F9F739584100000000D07A20419A999979F639584133333333F37A20419A999939F539584166666666157B20419A999959F43958419A9999995D7B204166666686F339584100000000817B204133333373F339584166666666C17B204166666606F439584166666666ED7B2041333333D3F339584133333333F37B2041333333D3F439584133333333027C2041CDCCCC6CF73958419A9999994E7D20419A9999F9E83958419A9999995F7D204133333393E9395841CDCCCCCC6F7D20419A9999B9E939584100000000937D20419A999999E839584100000000A87D20419A999919E739584100000000B87D204100000080E539584133333333D17D2041333333B3E039584100000000EC7D20419A9999D9DB395841666666661D7E2041666666A6D13958419A999999397E20419A999979CD39584133333333777E2041666666C6C339584100000000BA7E204100000060BF39584166666666E87E2041CDCCCC2CBD3958419A999999F57E2041000000A0C0395841CDCCCCCC1F7F2041666666A6B339584166666666557F204133333353A0395841CDCCCCCC5F7F2041000000009A39584133333333667F2041666666868D395841666666666A7F204133333353823958419A999999767F2041CDCCCCAC7A395841333333338A7F2041000000207339584133333333D57F2041333333136039584133333333F47F2041CDCCCCEC583958410000000011802041000000C05239584100000000128020410000008050395841333333331E802041000000604A3958416666666621802041CDCCCCCC48395841666666661F8020413333337342395841CDCCCCCC1D802041CDCCCC8C3D395841CDCCCCCC1B802041CDCCCCCC3B395841666666661380204100000000373958419A9999990E8020419A99991935395841666666662C802041000000402D3958419A99999959802041CDCCCC6C22395841000000005D8020413333335322395841000000006E8020419A9999D91E39584133333333938020419A9999591839584100000000D8802041666666860D39584100000000EF802041000000400A39584133333333198120416666664603395841000000002B8120419A9999F9FF3858419A99999941812041CDCCCC8CF9385841000000005C812041666666A6EE385841666666666E8120419A999999E93858413333333381812041CDCCCCCCE63858419A999999A681204133333333E138584100000000D481204166666626DD385841CDCCCCCCF38120419A999999DA38584166666666FF812041000000E0D9385841000000001B822041CDCCCCECD7385841CDCCCCCC34822041CDCCCC8CD5385841666666663F82204133333393D23858416666666646822041CDCCCCACD0385841CDCCCCCC63822041000000E0C93858419A9999998282204166666666C338584100000000AD822041000000C0B938584100000000B9822041000000A0B338584133333333C782204100000060AB38584166666666D382204100000000A238584100000000D2822041CDCCCCCC9D385841CDCCCCCCCB822041CDCCCCEC9A3858419A999999C48220419A9999F99938584100000000BD822041000000609938584133333333AC8220419A9999F998385841CDCCCCCC9B822041666666869938584133333333828220410000008099385841666666667582204100000040993858419A999999688220419A9999B9983858413333333349822041666666A69638584100000000148220413333331393385841666666660B8220419A9999799238584133333333F7812041CDCCCCCC8F38584166666666CC812041CDCCCCCC88385841666666669B812041CDCCCCEC81385841333333339E812041CDCCCC8C7E385841000000009A812041000000E07A385841CDCCCCCC8C812041333333737A3858419A9999997F812041000000A07A3858410000000066812041333333D379385841000000005C812041333333F377385841666666665B8120419A999919763858419A9999995D8120419A9999F96A385841CDCCCCCC6381204133333393663858410000000072812041CDCCCCCC5E3858419A999999838120413333333357385841CDCCCCCC9F812041666666E64D38584100000000B5812041000000804838584100000000C2812041000000804438584166666666D2812041CDCCCC4C41385841CDCCCCCCDB812041000000603F3858419A9999995E822041333333132938584133333333648220419A9999F9283858419A999999E1822041666666462738584166666666E6822041333333532738584100000000E9822041CDCCCC8C27385841333333332D832041CDCCCCCC223858419A99999948832041CDCCCC6C20385841333333338B832041CDCCCC4C1A3858416666666696832041CDCCCCCC1838584166666666A88320419A9999791638584166666666D7832041333333731238584166666666F2832041000000A011385841666666661A8420419A99997911385841CDCCCCCCB38320410000008002385841CDCCCCCCA4832041CDCCCCACFF3758419A99999994832041CDCCCC0CFD375841666666666C83204100000020F7375841333333334F83204133333313F33758419A9999991E8320419A999979EB375841333333330083204100000060E6375841666666665D82204133333373D0375841666666668F812041333333B3B337584100000000F4802041666666E69D37584100000000938020416666662690375841000000003F802041333333F38337584100000000FB7F2041666666A67937584100000000F47F2041000000A078375841CDCCCCCCE67F20410000004076375841CDCCCCCCC37F2041CDCCCCCC7137584133333333697F2041000000C068375841333333332C7F2041666666E66337584100000000EB7E2041666666465F3758419A999999CE7E20419A9999195D375841000000009A7E2041666666065937584166666666757E20419A99993956375841333333334A7E2041000000E052375841CDCCCCCCF17D2041000000A04837584133333333C27D2041666666864237584133333333B07D20419A9999793F375841CDCCCCCC987D20419A9999D93A37584133333333597D2041000000002D375841CDCCCCCC4E7D2041666666062B3758419A9999992B7D2041CDCCCC4C2437584166666666187D2041333333D31F3758419A999999017D20419A9999991A37584133333333E27C2041666666061237584166666666BB7C2041666666C6FF36584166666666B77C20419A999979FE365841CDCCCCCCAF7C204166666606FC365841333333339A7C204100000040F7365841333333337D7C2041CDCCCC2CF036584166666666747C2041CDCCCC8CEE365841CDCCCCCC647C2041666666C6EA365841CDCCCCCC527C204133333373E6365841CDCCCCCC3B7C20419A999979DE36584166666666377C204166666686D43658419A999999357C204100000040CA365841CDCCCCCC317C204133333333B5365841666666662E7C2041CDCCCC4CAE3658419A999999277C2041CDCCCC6CA936584166666666227C20419A9999D9A636584100000000207C2041666666A6A5365841000000000A7C2041666666069C36584133333333FF7B2041000000E0973658419A999999FC7B20419A9999D99636584166666666E57B2041333333D3903658419A999999D17B2041000000008D365841CDCCCCCCC07B2041000000208A3658419A999999A57B2041333333F38436584133333333757B2041000000607F365841000000005C7B2041333333737D3658419A999999337B2041CDCCCCEC7A36584133333333137B2041000000407936584100000000DF7A20410000002077365841CDCCCCCCA77A20419A9999797436584133333333067A2041333333336D3658419A9999998779204100000080683658419A99999979792041333333F36736584166666666187920419A9999196336584166666666E9782041333333F360365841666666667D782041000000805A3658416666666656782041CDCCCCAC58365841333333331F782041000000205436584133333333E37720419A9999B94F36584100000000CE772041CDCCCC4C4E365841666666669D772041000000E049365841CDCCCCCC8C77204133333353483658410000000077772041000000E0453658419A99999958772041000000C042365841CDCCCCCC42772041666666C64036584100000000F376204100000060393658419A999999CE7620419A9999D93536584166666666BA762041CDCCCC2C343658416666666694762041333333D3303658410000000071762041666666A62D365841CDCCCCCC3076204100000060273658419A999999FA752041666666462236584133333333B27520419A9999F9193658419A9999999B752041CDCCCC0C17365841CDCCCCCC6B7520419A99999911365841666666661D7520416666660608365841000000000A7520419A9999390536584133333333B3742041666666C6F935584133333333A1742041666666C6F6355841666666669674204100000080F53558416666666688742041CDCCCC4CF33558419A99999968742041000000E0ED355841333333334E742041666666C6EA355841CDCCCCCC3D742041CDCCCCACE835584166666666097420419A999919E235584100000000F0732041000000A0DE355841CDCCCCCCDB73204166666666DC35584166666666CC7320419A999939DB355841CDCCCCCCB67320419A9999F9D83558416666666694732041000000E0D6355841000000006A732041CDCCCCACD435584133333333597320419A999999D3355841666666662B732041CDCCCC4CD03558419A999999167320419A9999B9CE355841666666660F7320419A9999F9CD3558419A999999E57220419A9999D9C9355841333333339272204100000020C13558416666666669722041CDCCCC4CBC355841000000003372204133333353B63558419A999999F97120419A999999AF355841CDCCCCCCDB7120419A9999B9AB3558419A999999C6712041333333B3A7355841CDCCCCCCB071204100000020A33558410000000096712041333333739E355841CDCCCCCC86712041000000609C3558413333333376712041333333B39A355841666666665F712041000000E098355841CDCCCCCC397120419A999979963558410000000028712041000000809535584133333333D1702041000000209335584166666666AB702041666666C6923558413333333388702041000000809235584100000000C66F2041000000C09035584166666666936F2041CDCCCC6C90355841333333334C6F20419A9999B98F35584133333333FF6E2041333333138F35584133333333E16E2041333333338F35584100000000B96E20419A9999598F35584166666666806E2041CDCCCC0C8F35584166666666186E20419A9999398D35584100000000DC6D20419A9999998B355841666666669E6D2041000000A08935584133333333856D20419A9999998835584133333333536D204166666626873558419A9999993D6D2041666666468635584166666666166D2041CDCCCC0C8435584133333333FA6C2041666666668135584166666666DB6C2041CDCCCCEC7D355841CDCCCCCCB86C2041333333537835584133333333AF6C2041000000A07535584100000000AB6C2041333333737435584166666666A26C2041666666E672355841CDCCCCCC8D6C2041666666066E3558419A999999826C20419A9999B96B35584166666666576C2041333333B360355841CDCCCCCC506C2041333333135E3558419A999999466C2041666666E658355841CDCCCCCC426C2041333333F35435584133333333416C2041333333F34935584166666666426C20419A9999B945355841666666664C6C2041666666663C355841333333334E6C2041666666E6393558419A999999536C2041333333F33035584133333333596C20410000008027355841CDCCCCCC5A6C2041333333D3253558419A9999996C6C204100000020183558419A999999776C2041666666660E355841666666667A6C2041CDCCCCCC09355841CDCCCCCC746C2041000000C002355841000000006C6C2041333333130035584133333333536C204166666686FA34584166666666336C204133333313F5345841666666660C6C2041CDCCCCCCEF345841CDCCCCCCF86B20419A999979ED34584133333333ED6B2041333333F3EC34584100000000D86B2041CDCCCCACF2345841CDCCCCCCA36B2041000000E0FC345841CDCCCCCC6A6B20419A9999D904355841CDCCCCCC316B2041000000400D355841CDCCCCCC116B20410000008012355841CDCCCCCCFB6A2041000000601535584133333333E06A20419A9999391A35584133333333B66A20419A99999921355841CDCCCCCC8A6A204133333333293558419A999999766A2041666666C62C35584166666666596A2041333333F331355841CDCCCCCC266A20419A9999193B35584133333333F66920419A999959433558419A9999998A6920413333335350355841333333336C6920419A9999F955355841666666665B692041000000A0593558419A999999526920419A9999595D3558419A99999950692041CDCCCC6C613558419A999999526920419A999999633558416666666628692041CDCCCC4C673558419A9999991F692041000000206835584100000000F16820419A999939733558419A999999E9682041CDCCCCAC76355841CDCCCCCCD6682041666666667C35584100000000B26820419A9999B985355841666666669E6820413333335387355841666666666B682041000000A088355841333333333A682041CDCCCC2C8B35584166666666196820419A9999798D355841CDCCCCCC16682041333333138E3558419A999999EB6720419A9999F98D35584100000000B5672041000000608E355841333333336F672041333333738E355841CDCCCCCC2E672041333333338E3558413333333307672041CDCCCC4C8E3558419A999999E2662041666666C68E3558419A999999B76620419A9999F98F3558419A9999993E6620419A9999F99435584133333333F9652041333333D398355841CDCCCCCCC3652041333333D3993558419A999999AB652041666666A6993558419A99999965652041CDCCCC4C983558416666666610652041666666669835584100000000D66420419A9999D99935584166666666A7642041CDCCCCEC9A3558419A999999A2642041000000E09A355841000000009F642041333333F39B355841333333338D642041333333F39E355841000000009B642041000000C0AB355841666666669E642041666666A6AC35584166666666A964204100000020B235584100000000B464204166666606BA355841CDCCCCCCBB6420419A9999D9BD35584166666666C664204100000020C135584100000000C964204100000080C135584166666666C4642041333333F3C13558419A999999B96420419A999959C435584133333333A1642041666666C6CB355841CDCCCCCC8F642041CDCCCC8CD1355841333333337F64204166666606DA3558413333333381642041666666E6DB355841CDCCCCCC83642041CDCCCC2CDE355841666666668A64204166666606E0355841CDCCCCCC8D642041000000A0E135584133333333986420419A9999F9E535584133333333AB6420419A999999EA35584100000000B964204100000080EC35584133333333B464204166666626ED35584166666666AC64204100000080EE35584166666666A764204133333393EE355841000000008964204166666666EE355841CDCCCCCC67642041CDCCCC8CEE355841CDCCCCCC66642041000000C0EB355841CDCCCCCC4C642041000000E0EB3558419A999999346420419A999959EC35584133333333ED6320419A999919EE355841CDCCCCCCB9632041CDCCCC2CEE355841CDCCCCCC9563204166666686EE3558410000000077632041333333D3ED355841CDCCCCCC3C63204133333373EB3558416666666624632041CDCCCC4CEB35584100000000BB62204166666606EF35584166666666AC62204133333393EF355841CDCCCCCC8C62204100000060F0355841666666665F6220419A999939EE3558419A9999992162204133333373ED35584133333333ED61204133333313ED355841CDCCCCCCC1612041666666E6ED3558416666666637612041000000C0EE355841CDCCCCCCD760204166666646EE355841CDCCCCCC7660204100000020EC355841333333337260204100000040E53558419A9999993160204100000060E4355841333333331B602041CDCCCC0CE235584133333333F45F204100000020E33558419A999999CE5F20419A9999D9E03558419A999999B45F2041666666E6E03558419A999999705F2041333333B3E335584100000000695F204100000040E3355841CDCCCCCCDF5E2041CDCCCCCCD835584100000000895E2041CDCCCC8CE335584133333333435E204100000000F03558419A999999065E2041666666C6ED35584166666666025E2041CDCCCC2CED35584133333333F35D204133333333EC3558419A999999745D20419A9999791836584133333333685D2041CDCCCCAC1936584100000000425D2041000000C01C3658419A999999275D2041333333D31D365841333333330B5D2041000000C01F36584133333333FA5C2041000000E021365841CDCCCCCCE45C2041666666C623365841CDCCCCCCD95C20419A999919253658419A999999C15C2041000000E02636584166666666AF5C20419A9999F928365841000000009D5C2041CDCCCC2C29365841333333337B5C20419A99997929365841CDCCCCCC625C2041666666462936584100000000615C2041666666662A365841000000005A5C2041666666E62C365841CDCCCCCC575C2041333333332F36584166666666505C204100000040323658419A999999455C2041CDCCCC4C34365841666666663B5C20419A9999D9353658419A999999365C2041333333733736584133333333375C20419A9999193936584133333333345C2041CDCCCCCC3A365841CDCCCCCC225C2041333333733F36584100000000195C20419A999939413658419A9999990A5C2041000000E04236584133333333F75B2041333333734436584166666666C95B2041CDCCCCEC4636584166666666B45B2041CDCCCC8C48365841CDCCCCCCA15B2041333333334B365841CDCCCCCC925B2041333333534E365841CDCCCCCC4A5B2041333333335F3658419A9999992B5B20419A9999F968365841CDCCCCCC205B2041000000006C3658419A999999105B2041CDCCCC0C6E365841CDCCCCCCFE5A20419A9999B9703658419A999999D55A20419A9999F97336584100000000A45A2041666666267A36584100000000895A20419A9999598536584166666666775A20419A9999D99036584100000000755A2041333333D396365841666666666B5A2041CDCCCC6C9E36584133333333635A2041CDCCCC8CA336584166666666575A2041CDCCCCECA8365841000000003E5A204166666606B236584100000000355A20419A999979B4365841CDCCCCCC065A204133333373BF36584100000000F6592041666666E6C2365841CDCCCCCCE9592041666666E6C536584133333333EC59204133333333C836584100000000F059204133333373CB36584133333333FA5920419A999919CF36584100000000F259204100000020D336584100000000EF5920419A999959D5365841CDCCCCCCEC59204133333393D93658419A999999E4592041CDCCCCECE036584166666666E459204133333373EC3658419A999999DE59204100000040EF3658419A999999DA5920419A999939F0365841CDCCCCCCD05920419A999919F436584133333333BF592041333333B3F636584166666666AE59204100000080F83658419A999999935920419A999939FA36584133333333845920419A9999B9FC365841666666667E5920419A999979FE365841CDCCCCCC725920413333333303375841333333336D592041666666A6043758419A99999968592041666666E605375841333333335959204166666606093758419A9999994C592041666666460C3758419A9999993F592041CDCCCCCC0E3758410000000038592041CDCCCC4C0F3758419A99999918592041000000401737584166666666045920419A9999F91937584100000000F7582041666666461C3758419A999999E9582041CDCCCC0C1F37584100000000DF58204133333313223758419A999999D7582041CDCCCCEC2437584133333333C8582041000000C029375841CDCCCCCCBC582041000000402C37584100000000B3582041CDCCCCCC2F375841333333339C5820419A999959353758416666666690582041000000E03637584100000000815820410000006038375841666666666A5820419A9999193A375841CDCCCCCC62582041333333B33A3758413333333353582041333333133D375841CDCCCCCC3C582041CDCCCC8C423758413333333334582041CDCCCC8C4537584100000000305820419A9999F9463758416666666627582041000000E04C375841CDCCCCCC26582041CDCCCC6C523758416666666627582041666666A65A375841CDCCCCCC1C582041000000C060375841666666661B58204133333333653758419A9999991C5820413333331367375841666666661E5820419A9999396C375841CDCCCCCC1D582041666666C66E3758416666666619582041CDCCCC0C74375841	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	01010000206A0800005EAC93E563732041CCCCCC5C62385841	820240000	Z	Brassac	8202400	82024	82	76	20
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	01010000206A080000470D4FF9003F2141CCCCCC9C681A5841	820250000	Z	Bressols	8202500	82025	82	76	20
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	01010000206A080000DCDEC158AF162241CDCCCC0CE4245841	820260000	Z	Bruniquel	8202600	82026	82	76	33
01060000206A08000001000000010300000001000000B8030000CDCCCCCC102D2141333333138F135841CDCCCCCC212D21419A9999199E135841666666665F2D214100000040B81358419A999999C62D21419A999919EA13584166666666422E2141666666A6231458419A999999432E2141000000A03714584133333333262E2141666666664014584166666666E12D21419A9999794F14584133333333BA2D2141000000005C145841CDCCCCCC892D2141666666C67314584100000000A82D21419A9999F97414584133333333302F2141333333D37F14584100000000023021419A9999997F1458419A99999905312141333333137E14584100000000413121416666660674145841CDCCCCCC7C3121419A9999F97314584100000000D7312141000000E0781458419A99999931322141000000C082145841CDCCCCCC593221419A99993985145841666666667B3321410000004080145841CDCCCCCC8A3321419A9999B97F14584100000000DF332141333333937E145841666666660636214133333393701458410000000055362141000000808C1458416666666689362141CDCCCCEC9E145841CDCCCCCCAE362141CDCCCC2CAC14584133333333D236214100000000AC145841333333330D3721419A999959AB145841000000002037214166666626AB145841333333337F37214100000000A91458419A9999994E38214166666626A51458413333333369382141000000A0A4145841333333338038214166666646A6145841000000006439214100000060B51458413333333398392141000000C0B9145841333333331A3A214133333333C51458419A9999995C3A2141CDCCCC8CCB145841CDCCCCCC023B214133333313D414584166666666393C21419A9999B9E21458419A9999998D3C2141CDCCCC0CEA145841333333337F3C214166666666EC145841333333335D3C214100000020F114584133333333513C2141333333F3F314584133333333743C21419A999919FC14584133333333773C2141CDCCCC8CFF1458419A9999998D3C214133333393001558419A999999A63C2141CDCCCC8C00155841CDCCCCCCBC3C21419A9999390115584100000000C83C2141666666460315584166666666C53C2141CDCCCC0C061558419A999999B73C21419A9999790715584166666666A13C21410000008007155841333333338B3C2141CDCCCC2C071558419A999999853C21419A99993908155841333333338E3C2141CDCCCCEC091558419A999999A13C2141333333F30A15584166666666BD3C2141666666460B1558419A999999D33C21419A9999990B155841CDCCCCCCE13C2141CDCCCCAC0D1558419A999999D63C2141000000C00F1558419A999999C03C21416666668611155841CDCCCCCCA73C2141CDCCCCEC1215584133333333973C21416666660615155841CDCCCCCC913C21419A99997917155841CDCCCCCC953C2141000000001B15584166666666A93C2141666666A62215584133333333BF3C2141CDCCCC2C2B15584166666666C63C2141000000A02C155841CDCCCCCCE23C21413333333330155841CDCCCCCCF43C21413333337331155841000000001F3D2141CDCCCC0C33155841CDCCCCCC313D21410000004033155841CDCCCCCC5A3D2141CDCCCC0C33155841CDCCCCCC6D3D21419A99995933155841333333337F3D2141CDCCCC2C341558419A9999998C3D21419A9999B935155841CDCCCCCCAB3D2141000000003915584100000000D23D2141CDCCCC2C3B1558419A999999EF3D2141333333333D155841CDCCCCCC0C3E2141333333F33E155841666666662A3E2141333333333F155841CDCCCCCC443E2141000000403F1558419A9999995D3E214100000000401558419A9999996E3E2141333333934115584133333333773E21416666660644155841CDCCCCCC7B3E21419A99997946155841CDCCCCCC7F3E214166666606481558419A999999903E21410000006049155841666666669A3E2141CDCCCC6C4915584166666666B23E21416666662649155841CDCCCCCCC73E2141000000604815584100000000D83E2141CDCCCC0C471558419A999999EC3E2141CDCCCCAC461558419A999999083F2141333333734715584100000000293F21419A9999D94815584133333333483F2141CDCCCCAC4A155841666666665D3F2141000000E04B15584166666666763F2141666666A64B155841000000008F3F2141CDCCCCAC4A1558419A999999A63F21410000004049155841CDCCCCCCB63F21419A9999594815584133333333D33F21419A9999994715584100000000EF3F214166666606481558419A999999254021413333339349155841666666664F402141CDCCCCEC491558413333333392402141CDCCCC2C4A15584100000000BE402141CDCCCC4C4A15584133333333E6402141000000604A1558416666666612412141CDCCCC4C4A155841333333332F412141CDCCCC8C4A1558410000000055412141000000604D1558419A99999961412141333333535015584133333333694121410000004052155841666666667341214166666606551558416666666679412141333333D3571558419A99999977412141666666865B1558413333333377412141666666065E155841333333337B412141CDCCCC6C60155841000000007B4121416666666663155841333333337F4121419A999959651558419A9999998C412141CDCCCC0C68155841333333339E412141000000206A155841CDCCCCCCB3412141333333F36B15584166666666CB4121419A9999596F155841CDCCCCCCE041214166666666741558419A999999F541214100000000781558416666666606422141CDCCCC0C7A15584133333333264221419A9999797C1558413333333340422141333333B37D1558419A9999995C422141666666267F1558416666666674422141333333F3811558419A99999986422141CDCCCC4C851558419A9999999C4221413333337387155841CDCCCCCCB2422141333333D38915584166666666C9422141333333538D1558419A999999DC422141000000A0901558419A999999F5422141CDCCCC6C921558419A99999915432141CDCCCCAC94155841333333332B432141666666E69515584166666666554321413333333396155841CDCCCCCC8B432141666666E69515584133333333E2432141CDCCCC8C94155841CDCCCCCC1F442141CDCCCC4C9415584166666666F1442141000000C07D155841333333337C452141000000206C155841000000007C4521410000006068155841000000002B4521419A9999F95715584100000000B6442141CDCCCC0C4315584100000000B1442141333333734115584100000000AA442141CDCCCC4C3F15584133333333A14421419A9999F93C15584133333333984421419A9999993A155841333333338C4421419A99999937155841CDCCCCCC83442141666666A6351558419A9999997D44214133333333341558410000000078442141666666E63215584133333333734421419A999999311558419A99999971442141CDCCCCAC301558416666666673442141CDCCCCEC2F155841CDCCCCCC77442141666666262F1558419A99999981442141CDCCCC0C2E15584100000000B2442141CDCCCC8C29155841CDCCCCCCC0442141000000402815584133333333D0442141CDCCCCEC2615584133333333DE442141000000002515584100000000EC442141CDCCCC6C2415584166666666F44421416666668623155841CDCCCCCCFD4421419A999999221558419A99999906452141666666C621155841000000000E452141000000202115584166666666154521413333337320155841333333332F452141000000401E1558410000000036452141CDCCCCAC1D155841000000003B452141CDCCCC0C1D155841CDCCCCCC3E452141333333731C1558410000000044452141333333B31B1558419A99999949452141666666E61A1558416666666652452141CDCCCCEC191558419A9999995B4521413333333319155841CDCCCCCC674521419A999959181558413333333377452141666666661715584133333333884521419A999939161558416666666697452141000000201515584133333333A9452141333333D31315584166666666BC452141000000601215584166666666D1452141CDCCCCAC1015584133333333E1452141666666660F15584100000000F1452141333333F30D15584133333333004621419A9999790C1558419A9999990F4621419A9999190B155841000000001F462141666666A609155841333333332F462141CDCCCC4C08155841666666663E462141333333F3061558419A9999994D462141000000A005155841666666665D462141CDCCCC4C04155841CDCCCCCC6F462141666666C602155841666666667F462141000000A001155841000000008C462141333333B3001558419A9999999B4621419A999979FF145841CDCCCCCCAA4621419A999959FE14584100000000C94621419A999979FC145841CDCCCCCC2749214166666666DB1458413333333332492141CDCCCC2CD9145841666666663A49214100000080D71458413333333344492141CDCCCCCCD51458419A9999994D4921419A999979D4145841000000005C49214133333313D3145841CDCCCCCC6B492141666666A6D1145841CDCCCCCC7C492141CDCCCC2CD014584100000000914921419A999959CE145841CDCCCCCCA34921419A999979CC14584100000000B4492141CDCCCCCCCA14584100000000C949214133333373C8145841CDCCCCCCD8492141333333D3C6145841CDCCCCCCE8492141CDCCCC2CC514584100000000FA4921419A999979C3145841333333330F4A21419A999999C1145841CDCCCCCC2E4A2141000000E0BE145841CDCCCCCC524A2141CDCCCCECBB1458419A999999714A214166666666B9145841CDCCCCCC994A2141CDCCCC4CB614584133333333DF4A21419A999919B114584166666666F24A21419A9999D9AF14584100000000004B214166666646AF145841CDCCCCCC0B4B2141333333B3AE145841CDCCCCCC164B214100000000AE14584133333333234B2141CDCCCC0CAD1458419A9999992F4B2141CDCCCCECAB145841666666663C4B214166666686AA145841000000004A4B2141333333F3A81458419A999999584B214166666646A71458419A999999694B21419A999939A5145841000000007D4B2141333333B3A21458419A9999998E4B21419A999979A014584133333333A04B2141333333339E14584166666666B04B21419A9999F99B145841CDCCCCCCBE4B2141666666C69914584100000000CB4B2141333333F3971458419A999999D54B21410000004096145841CDCCCCCCDD4B21419A9999D9941458419A999999E54B2141000000409314584100000000EC4B214133333313911458419A999999FC4B2141333333938E14584133333333114C2141666666E68B14584166666666224C21419A9999B98914584100000000324C2141000000A08714584100000000434C2141000000808514584100000000544C2141000000C08314584100000000664C2141CDCCCCEC8114584100000000784C2141CDCCCC0C801458419A9999999D4C2141CDCCCC6C7C14584100000000CA4C2141CDCCCC6C7814584166666666F24C2141CDCCCC8C741458419A999999224D2141000000C06F145841CDCCCCCC484D2141000000606B14584133333333654D2141CDCCCC4C6814584100000000874D2141666666C66414584166666666A04D2141333333136214584133333333B24D2141CDCCCC6C6014584100000000C54D2141000000E05E14584100000000D94D2141333333535D1458419A999999E94D21419A9999195C14584100000000FD4D2141CDCCCCAC5A14584133333333134E2141CDCCCC2C5914584100000000264E2141333333F357145841000000003A4E2141666666E656145841666666664E4E2141000000005614584100000000604E2141666666865514584100000000764E21413333333355145841CDCCCCCC8D4E21419A9999D95414584133333333AA4E2141CDCCCCAC5414584100000000C64E21419A9999995414584166666666E34E2141333333935414584166666666094F2141CDCCCC8C5414584166666666374F21419A99997954145841CDCCCCCC614F21410000006054145841333333339D4F21419A9999395414584166666666B94F214133333333541458419A999999D04F21410000004054145841CDCCCCCCE14F21419A9999595414584133333333F24F21419A999979541458419A99999912502141CDCCCCAC54145841666666663A502141666666865514584166666666825021413333333357145841CDCCCCCCA8502141000000205814584133333333C3502141333333B35814584100000000DD50214100000020591458419A999999EF502141CDCCCC4C5914584166666666045121410000004059145841666666661551214100000020591458419A999999295121419A9999D958145841666666663D51214166666666581458419A99999950512141666666E6571458416666666660512141CDCCCC8C5714584166666666735121416666664657145841CDCCCCCC865121419A999939571458419A9999999A5121419A9999595714584166666666AB512141CDCCCC8C571458419A999999C3512141000000005814584166666666DC512141666666A6581458416666666639522141666666665B1458419A99999991522141000000405E14584166666666B8522141000000605F14584133333333CF522141666666266014584100000000DF5221419A9999B96014584100000000EE522141000000606114584133333333FC5221410000002062145841000000000E5321410000002063145841333333331F53214100000020641458410000000034532141CDCCCC8C651458410000000046532141666666E66614584133333333015421419A999999601458419A9999993654214133333353641458413333333360542141CDCCCC4C6714584100000000D1542141666666E67014584133333333025521419A9999D974145841333333331155214100000080761458419A99999918552141CDCCCC8C77145841000000001C5521410000008078145841CDCCCCCC1A5521419A9999B979145841333333331A552141666666067B1458419A9999991A552141000000207C145841333333331B552141000000207D145841333333331D552141CDCCCC2C7E14584133333333215521419A9999D97E145841333333332B552141CDCCCC8C7F1458413333333330552141CDCCCC0C7D14584133333333365521419A9999597C1458419A9999993D552141333333B37B1458410000000044552141666666267B145841666666664D5521419A9999197A1458413333333354552141CDCCCC2C79145841333333335A55214166666646781458419A999999605521419A99995977145841000000006855214166666626761458419A9999996D552141333333137514584133333333725521419A99993974145841000000007A55214100000020731458413333333380552141000000A0721458416666666689552141333333F371145841CDCCCCCC8F55214100000040711458416666666699552141333333537014584100000000A3552141333333936F14584100000000AF5521419A9999B96E145841CDCCCCCCB75521419A9999396E14584133333333C7552141666666866D145841CDCCCCCCD0552141000000006D145841CDCCCCCCDE5521419A9999196C14584100000000EA552141CDCCCC4C6B145841CDCCCCCCF4552141333333736A1458419A999999FD552141333333D369145841CDCCCCCC09562141666666266914584100000000155621419A9999D9681458410000000020562141000000C068145841000000002C5621419A9999D968145841333333333B562141333333F3681458410000000053562141333333F368145841000000008B562141333333B36814584133333333A0562141CDCCCC8C681458419A999999AF562141333333736814584133333333BE562141000000606814584166666666CC562141CDCCCC4C681458419A999999D6562141CDCCCC2C68145841CDCCCCCCE3562141CDCCCCAC6714584133333333F2562141333333D36614584166666666F956214166666606661458419A999999FE562141000000606514584133333333065721416666666664145841000000000E572141333333536314584100000000155721413333335362145841CDCCCCCC1C572141000000A0611458419A999999255721410000002061145841CDCCCCCC2E572141666666A6601458413333333336572141666666266014584100000000405721419A9999F95E145841CDCCCCCC46572141333333F35D145841666666664C5721419A9999D95C145841666666664F5721419A9999995B145841333333334F572141000000405A1458419A9999994D5721416666662659145841CDCCCCCC49572141000000C05714584100000000465721419A999939561458419A999999425721419A999959541458419A99999940572141CDCCCCCC52145841666666663E5721419A999939511458419A9999993D572141666666A64F1458419A9999993C572141666666264E1458419A9999993B572141666666664C1458419A9999993A572141000000404B1458419A99999939572141333333B349145841CDCCCCCC38572141000000A048145841333333333757214100000000481458419A99999932572141CDCCCC8C47145841000000002E572141CDCCCC4C471458413333333328572141000000E046145841CDCCCCCC25572141CDCCCC2C4614584166666666245721419A9999394514584100000000245721413333333344145841CDCCCCCC235721419A9999F9421458416666666622572141CDCCCC8C3F1458416666666620572141666666663E14584100000000205721419A9999B93B14584166666666245721413333333339145841333333332A57214166666666371458419A999999385721419A9999393414584133333333435721416666668632145841666666665057214133333393311458419A9999996257214100000000301458419A99999985572141666666062B14584133333333C65721419A9999D92114584100000000F5572141333333931C1458416666666624582141CDCCCC6C171458410000000030582141333333B3151458416666666638582141000000A013145841666666663D582141CDCCCCAC111458410000000040582141CDCCCC0C101458419A9999993E582141333333330E145841000000003A582141666666C60B145841CDCCCCCC32582141666666E609145841CDCCCCCC285821419A9999D9061458410000000026582141CDCCCCAC041458419A999999255821419A999959021458419A99999929582141666666C6FF135841333333333858214133333373F9135841333333333C582141CDCCCC2CF5135841CDCCCCCC4958214100000020ED1358419A999999505821419A999999E9135841666666665958214133333313E613584133333333605821419A999919E31358419A99999967582141CDCCCCACE0135841CDCCCCCC71582141333333D3DE1358413333333380582141CDCCCC4CDD135841CDCCCCCC9058214133333353DC135841CDCCCCCCA3582141000000A0DB13584133333333B558214166666626DB1358419A999999C85821419A999999DA1358419A999999E15821419A9999B9D813584133333333F758214133333393D6135841333333331A5921419A999939D21358410000000026592141CDCCCC6CD0135841666666662D59214100000080CE1358419A99999930592141666666A6CC135841000000003259214166666666CA135841000000003359214166666646C8135841CDCCCCCC33592141CDCCCC4CC61358419A999999375921419A999919C4135841000000003E59214166666606C2135841666666664659214133333333C0135841333333335259214166666666BE1358419A99999964592141333333D3BB135841000000007F592141666666C6B8135841666666669659214133333373B613584133333333B159214166666626B5135841CDCCCCCCBE5921419A9999D9B313584166666666CC592141CDCCCC6CB213584100000000D7592141CDCCCC0CB1135841CDCCCCCCE659214100000040AE1358419A999999FB59214166666686AA1358419A999999075A214166666666A613584100000000FF59214100000020A513584166666666F55921419A999999A313584100000000E7592141666666E6A113584166666666DC592141CDCCCC0CA013584133333333DA592141333333739E1358419A999999DC5921419A9999599C13584166666666DB592141000000609A1358419A999999DA592141666666069813584133333333DE59214166666606961358419A999999E4592141CDCCCC2C9413584133333333F1592141000000609213584133333333FF592141666666C690135841CDCCCCCC115A2141666666068F1358419A999999245A21419A9999598D1358419A999999395A2141CDCCCC8C8B1358419A999999485A2141333333538A135841333333335B5A21413333339388135841CDCCCCCC745A21410000006085135841000000005D5A2141666666E682135841666666663F5A2141333333D37F13584166666666EF59214100000080751358416666666696592141CDCCCC4C6A135841333333335E592141CDCCCCCC63135841CDCCCCCC2A592141666666E65E1358410000000011592141333333335C1358410000000004592141CDCCCC4C5A13584166666666F9582141333333935813584100000000F1582141666666A656135841CDCCCCCCE4582141666666E654135841CDCCCCCCD4582141000000405313584166666666C358214166666606521358419A999999AF582141333333335013584166666666A15821419A9999594E135841CDCCCCCC945821419A9999594C1358419A9999998B5821419A9999194A1358416666666683582141666666E6471358413333333378582141CDCCCC8C451358419A9999996B582141CDCCCC8C43135841000000005F5821419A9999F941135841CDCCCCCC4F582141CDCCCCAC401358419A99999937582141333333533F135841CDCCCCCC24582141CDCCCC8C3E1358419A99999900582141333333B33D13584166666666ED572141333333533D135841CDCCCCCCD9572141666666A63C13584100000000CC572141000000803B13584133333333C55721419A9999393A135841CDCCCCCCC2572141333333933813584166666666BB572141CDCCCC6C3613584100000000B1572141333333733413584166666666955721419A999939311358419A999999845721419A9999592F135841CDCCCCCC75572141CDCCCC8C2D135841666666666A572141CDCCCCEC2B1358413333333365572141666666C6291358416666666664572141CDCCCCCC27135841CDCCCCCC6257214166666646251358419A99999960572141000000A022135841CDCCCCCC5A572141CDCCCC4C201358416666666653572141333333331E135841CDCCCCCC485721419A9999B91B1358410000000034572141000000601813584133333333255721419A999999161358419A9999990A5721419A9999B91313584133333333F5562141CDCCCCEC1113584133333333DA562141CDCCCCCC0F135841CDCCCCCCB7562141000000400D13584166666666955621419A9999590B13584166666666835621413333335309135841333333337A5621419A999939081358419A9999996B5621416666666606135841CDCCCCCC5F562141CDCCCC0C051358416666666654562141666666C603135841CDCCCCCC4A5621410000008002135841CDCCCCCC42562141666666C600135841333333333E56214166666686FF125841000000003756214166666666FD1258410000000031562141000000A0FB1258419A9999992A562141CDCCCCECF9125841CDCCCCCC21562141666666E6F7125841CDCCCCCC1A5621419A999959F61258410000000012562141000000C0F41258419A9999990A562141CDCCCC6CF31258413333333304562141333333D3F212584100000000EF552141666666E6F212584166666666E355214100000000F31258419A999999D55521419A999919F312584166666666C555214133333333F3125841CDCCCCCCB155214166666666F3125841CDCCCCCC9F552141000000A0F3125841000000008E552141333333D3F3125841000000007955214100000000F41258410000000068552141666666E6F312584166666666555521419A999999F3125841000000004655214166666626F31258419A9999993455214166666646F2125841666666662655214133333353F11258416666666615552141000000E0EF125841CDCCCCCC0455214100000040EE12584100000000DF542141333333B3EA125841CDCCCCCCD354214100000080E912584166666666CA54214100000060E812584166666666C354214100000040E712584166666666BC54214100000040E512584166666666A25421419A9999F9D8125841000000009954214100000000D4125841CDCCCCCC9354214100000040D1125841333333338F54214100000040CF125841CDCCCCCC885421419A999919CD125841CDCCCCCC8254214166666666CB1258419A9999997C542141333333D3C91258410000000078542141000000E0C71258419A9999997A542141CDCCCCACC4125841000000007F54214133333333C3125841CDCCCCCC83542141CDCCCC8CC1125841333333338A54214166666686BF125841666666668F542141CDCCCCCCBD1258416666666694542141CDCCCC6CBB125841CDCCCCCC9754214133333373B9125841333333339A542141CDCCCC4CB7125841CDCCCCCC9B542141CDCCCCCCB4125841666666669C542141000000A0B2125841000000009D542141000000A0B0125841CDCCCCCC9C54214133333353AE1258419A9999999B54214166666666AC125841333333339A54214166666646AA125841000000009854214166666686A81258416666666694542141CDCCCC8CA61258413333333391542141CDCCCC2CA5125841333333338E542141666666C6A3125841666666668A542141000000A0A2125841CDCCCCCC875421419A9999B9A1125841333333337A542141CDCCCC6C9E125841CDCCCCCC70542141CDCCCCCC9C125841CDCCCCCC66542141666666069B125841000000005B54214166666606991258419A9999994C5421419A99997996125841CDCCCCCC40542141000000409412584133333333335421419A999999911258419A99999925542141CDCCCCEC8E1258410000000018542141000000208C1258413333333309542141000000008912584133333333FD532141000000808612584133333333F1532141CDCCCC2C84125841CDCCCCCCE953214166666686821258419A999999E453214166666626811258419A999999E1532141CDCCCC2C8012584166666666E1532141333333937F1258419A999999E4532141CDCCCCCC7E125841CDCCCCCCE7532141CDCCCC2C7E1258419A999999EC532141666666667D1258419A999999F25321419A9999997C1258419A999999F4532141333333537C125841000000003D5421419A9999F9711258419A99999965542141CDCCCCEC6D125841CDCCCCCC72542141CDCCCC0C6B125841666666668C5421416666662663125841666666669A542141333333336012584133333333C8542141333333D359125841CDCCCCCCDE542141CDCCCC0C56125841CDCCCCCCF55421419A99993953125841CDCCCCCC075521419A9999F94F125841000000000B552141666666E64E125841000000000E552141333333134B125841000000000F552141333333533F125841CDCCCCCC155521419A9999393912584100000000095521419A9999D930125841CDCCCCCC09552141CDCCCC6C2912584100000000045521410000006021125841000000000C5521419A9999791B125841333333331F5521419A9999D9151258419A99999925552141333333F3111258410000000013552141666666460B12584166666666105521419A99997908125841666666661055214100000040031258419A9999990A552141333333330112584100000000FF54214133333393FF1158419A999999E854214166666646FE11584100000000C2542141333333B3FD11584133333333A65421419A9999B9FD11584166666666A0542141666666A6FD115841CDCCCCCC9C54214100000040FD115841CDCCCCCC8C542141CDCCCCECF2115841CDCCCCCC8F542141333333B3F0115841CDCCCCCC9B54214133333313EE1158419A9999999B5421419A999919EC115841CDCCCCCC9054214166666666E8115841666666667E54214133333393E5115841CDCCCCCC6E54214100000060E5115841333333334C542141CDCCCCCCE7115841CDCCCCCC2654214166666646E81158419A999999045421419A999919E9115841CDCCCCCCBA532141666666A6EC1158419A999999A8532141333333F3EC1158419A9999999B532141CDCCCC6CEC115841CDCCCCCC73532141CDCCCCACE9115841666666664E53214133333313E81158413333333323532141000000C0E611584133333333E2522141CDCCCC4CE61158419A999999C45221419A9999B9E611584133333333BF52214133333353E61158419A999999B7522141666666E6E411584133333333AA522141000000A0DE1158419A9999999952214133333393DB115841666666667F5221419A9999B9D9115841333333336F522141CDCCCC6CD911584133333333515221419A999939DA115841CDCCCCCC3E522141CDCCCCECD8115841CDCCCCCC0A522141CDCCCC0CD311584166666666B551214133333373C811584166666666AA512141CDCCCC6CC611584133333333A551214100000040C411584166666666A551214100000040BE1158419A999999A051214133333393B8115841CDCCCCCC9451214166666686B3115841CDCCCCCC64512141333333D3A8115841CDCCCCCC56512141CDCCCCECA31158419A99999916512141CDCCCC2C941158416666666669502141333333539C1158416666666612502141CDCCCC8C9D1158419A9999991B4D214133333353A311584100000000C24C2141CDCCCC2CA7115841333333339A4C2141333333F3AA1158419A999999724C214100000040B11158419A999999AA4B2141333333B3AD115841CDCCCCCC4E4A2141CDCCCC4CA9115841CDCCCCCC1E4A2141CDCCCC0CA81158419A999999124A2141CDCCCCCCA711584166666666FE4921419A999979A711584166666666E6492141CDCCCC4CA711584166666666DF49214100000060A71158419A999999D34921419A9999B9A711584166666666CB49214100000000A811584100000000C049214133333393A811584133333333B649214100000040A91158419A999999AA492141333333F3A91158419A99999999492141000000E0AA115841CDCCCCCC86492141000000C0AB1158416666666674492141333333B3AC1158419A99999961492141666666A6AD115841CDCCCCCC48492141666666C6AE1158413333333333492141CDCCCCCCAF115841000000001849214100000080B1115841000000000B49214166666646B21158419A999999FA48214100000040B311584100000000EA48214133333333B4115841CDCCCCCCD948214100000020B5115841CDCCCCCCC94821419A999919B61158419A99999952482141CDCCCCCCB51158410000000013482141000000E0B611584166666666A4472141CDCCCC2CBF115841CDCCCCCC684721419A999999C4115841CDCCCCCC1147214100000060CE115841CDCCCCCC06472141000000A0CC1158419A99999902472141CDCCCC0CCC1158416666666600472141000000A0CB1158419A999999FB462141000000A0CA11584166666666F54621419A9999F9C811584100000000EA46214133333333C61158419A999999D14621419A999919C01158419A999999AA462141666666E6BA1158419A9999999C462141666666A6B71158419A999999A6462141000000E0B51158419A999999A946214133333333B511584100000000AF4621419A999959B411584100000000B646214100000040B311584100000000C446214100000080B011584133333333DA462141666666A6AC11584100000000DE462141CDCCCCCCAB11584133333333E1462141CDCCCCECAA1158419A999999E34621419A999999A911584100000000E44621419A9999F9A51158419A999999E3462141666666C6A411584100000000E346214166666646A311584100000000E2462141CDCCCCACA11158419A999999E0462141333333D39F11584133333333DE462141000000009E11584166666666D94621419A9999599B11584166666666CD462141666666A69311584100000000CA462141000000C09211584133333333BA462141CDCCCCAC8E115841CDCCCCCCA8462141333333738C11584133333333694621419A99995984115841CDCCCCCC5B462141333333F381115841000000004E462141000000807F1158419A999999F9452141333333F37B11584100000000DD452141666666467B1158410000000099452141666666467B1158419A99999955452141333333937B1158410000000077442141000000C07C11584166666666564421413333339372115841000000000444214166666666751158419A999999A843214100000040781158419A99999929432141333333137B11584100000000AE4221416666666682115841CDCCCCCCD44121419A9999396C1158419A999999C7412141000000E06D1158419A9999999E412141666666867311584166666666864121416666666677115841CDCCCCCC57412141333333737F11584100000000234121419A99991989115841333333330D412141000000008D11584166666666EC4021410000008092115841CDCCCCCCDD402141666666E69411584133333333D240214100000020961158419A999999C8402141666666E696115841CDCCCCCCB8402141333333B397115841666666669B402141333333F3981158419A9999995F402141666666669A1158419A99999916402141666666C69C11584100000000D23F2141CDCCCC0C9F11584133333333AC3F2141CDCCCC0CA0115841CDCCCCCC7A3F214133333333A1115841CDCCCCCC473F214166666686A211584166666666113F2141333333F3A311584166666666C03E2141333333D3A5115841CDCCCCCC953E214166666606A611584166666666753E2141000000E0A5115841CDCCCCCC523E214166666686A5115841CDCCCCCC1B3E214166666606A511584133333333EF3D2141CDCCCCCCA411584166666666AA3D214166666606A5115841666666667B3D214100000020A51158419A9999995B3D2141CDCCCCACA411584133333333453D2141CDCCCC0CA4115841000000002E3D2141000000A0A2115841666666663A3D2141CDCCCC8CA11158419A999999293D2141666666E6A011584166666666103D21419A9999999F11584133333333F73C21419A9999799E11584133333333E13C21419A9999B99D11584100000000D23C2141666666669D1158419A999999C43C2141666666A69D115841CDCCCCCCB83C2141666666669E11584166666666A53C2141000000809F11584166666666583C2141CDCCCC6C9E115841CDCCCCCC453C2141666666269E11584100000000493B214100000020B41158419A999999013B21419A999999BB11584166666666903A214166666646C51158419A999999653A214166666606C811584100000000023A21419A9999B9CC11584100000000BD392141666666E6CE115841666666666739214100000000D011584133333333F73821419A9999B9CF115841CDCCCCCCC63821419A9999B9CE115841CDCCCCCC8E38214133333313CE11584133333333593821419A999939CE1158413333333345382141000000C0CE1158416666666605382141CDCCCC0CD111584133333333AC37214166666686D51158419A999999883721419A9999B9D611584100000000483721419A999999D91158419A9999990237214100000000DC11584133333333BB36214100000020DF1158413333333382362141000000C0E0115841666666666D362141000000C0E11158416666666628362141CDCCCC6CE611584133333333F3352141CDCCCCECEA11584166666666DD3521419A999919ED11584100000000BA352141000000E0F111584133333333A33521419A999919F5115841000000009735214100000020F71158419A9999998A35214100000020F91158410000000078352141333333D3FA1158419A9999995735214133333393FC115841333333333235214166666606FE11584166666666EC3421419A9999B9011258419A999999BC342141333333B30312584100000000A6342141666666A6041258419A99999990342141CDCCCCCC05125841CDCCCCCC8134214100000020071258413333333366342141000000800A1258413333333357342141666666860C1258416666666644342141333333730E12584133333333343421419A9999590F125841CDCCCCCC23342141333333B30F1258419A9999990D3421419A999959101258419A999999FF33214100000060111258419A999999F7332141333333931212584166666666F1332141000000401412584166666666EA332141666666E615125841CDCCCCCCE23321419A9999D91612584100000000D6332141CDCCCCCC1712584100000000C53321419A9999F9181258419A999999AE332141333333931B125841000000009A332141666666861D1258416666666603332141666666A62B12584166666666C0312141666666A65512584166666666D8312141666666C6581258419A999999F3312141CDCCCCAC5D12584133333333013221416666662660125841000000000B322141CDCCCCEC6212584133333333193221419A9999196712584100000000283221419A9999B969125841CDCCCCCC32322141666666066C1258416666666641322141CDCCCCEC6E125841333333335B322141CDCCCC2C731258410000000070322141000000407612584133333333883221413333339379125841CDCCCCCC9A322141000000007C1258419A999999A4322141000000607D1258419A999999B0322141333333337E12584100000000C6322141333333B37E12584166666666D0322141333333737E1258419A999999D9322141000000E07E12584100000000E232214100000040801258419A999999E4322141000000C08112584133333333EC32214100000060841258419A999999F232214133333313861258419A999999FA322141000000E0881258416666666602332141666666668C125841000000000D332141333333D39112584166666666173321410000008095125841000000001C33214166666646981258419A9999991E332141666666469A1258419A99999924332141666666C69A125841CDCCCCCC28332141000000209C125841CDCCCCCC2B3321419A9999599F125841000000002B33214166666626A21258419A999999293321419A999939A41258410000000025332141CDCCCC2CA6125841000000001A3321419A999979A8125841CDCCCCCC0C33214133333333AA12584166666666FA32214100000060AC1258419A999999EC322141333333F3AE125841CDCCCCCCE3322141666666E6B01258419A999999D8322141666666E6B3125841CDCCCCCCD5322141CDCCCC2CB612584100000000D732214166666646B912584133333333DB322141CDCCCC8CBC125841CDCCCCCCDE322141CDCCCCCCBF12584166666666E032214166666606C212584133333333E03221419A999939C51258419A999999DE322141333333F3C61258419A999999DC322141000000A0C8125841CDCCCCCCDC32214166666666CA12584166666666DE3221419A9999F9CB1258419A999999E1322141CDCCCC6CCD12584133333333E63221419A9999D9CE12584100000000EC32214133333373D01258419A999999EF32214166666606D21258419A999999F03221419A999939D4125841CDCCCCCCEE3221419A9999F9D612584133333333EE322141CDCCCCACD9125841CDCCCCCCEE32214133333313DC12584133333333EF32214100000000DE125841CDCCCCCCF4322141CDCCCC0CE11258419A999999F9322141CDCCCC6CE312584100000000FC322141000000C0E4125841333333330033214166666626E7125841333333330B3321419A9999F9EB1258410000000011332141000000C0EE125841000000001C33214166666606F31258419A9999992433214133333353F61258416666666630332141000000A0F9125841666666663B3321419A999959FC1258413333333346332141000000E0FE125841666666664B332141CDCCCCCC00135841000000004D332141333333D3021358419A9999994B332141333333F304135841CDCCCCCC44332141000000A007135841666666663A332141333333130A135841000000000C33214133333393141358413333333304332141333333F316135841CDCCCCCCB1322141666666E62513584100000000C3322141666666662E135841CDCCCCCCC63221419A999919381358419A99999988322141000000003B1358419A999999B031214166666666461358419A999999A8312141CDCCCCCC46135841000000007D3121419A9999794A13584133333333CD3021419A99991960135841666666668C30214100000080671358416666666665302141000000406B1358410000000041302141000000406D1358419A9999991E302141666666A66E135841CDCCCCCCEC2F21419A9999997013584166666666BA2F2141CDCCCC6C7213584100000000902F2141333333F3731358419A9999994E2F2141000000C07613584166666666182F21419A9999F9781358419A999999EA2E2141000000C07A1358419A999999C22E2141333333937C1358419A999999902E2141666666C67E1358419A999999512E2141CDCCCC6C811358419A999999312E2141CDCCCC2C831358419A999999032E21410000008085135841CDCCCCCCD32D2141333333B38713584133333333AA2D2141CDCCCCAC891358419A9999997F2D2141000000608B13584133333333462D21419A9999598D135841CDCCCCCC102D2141333333138F135841	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	01010000206A0800003C811EDC55442141000000A080135841	820270000	Z	Campsas	8202700	82027	82	76	15
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	01010000206A08000043FA8EC373312141000000907D105841	820280000	Z	Canals	8202800	82028	82	76	7
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