SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep87;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep87 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep87','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep87','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep87','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep87"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000DAA6AC3DC8F32041666666C6EBE35841	870010101	H	Rive Droite	8700101	87001	87	75	10
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	01010000206A080000AD9B29B9D0E92041CDCCCC0CE0E15841	870010102	H	Rive Gauche	8700101	87001	87	75	12
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	01010000206A0800007CAB4B76B5A3214166666636CBF25841	870020101	H	Sud	8700201	87002	87	75	32
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	01010000206A0800000AF5D5F7CA87214133333333FAF45841	870020102	H	Nord	8700201	87002	87	75	26
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	01060000206A0800000100000001030000000100000042030000666666665F63214133333333041759419A999999B3632141CDCCCCAC1B175941CDCCCCCCEC63214166666686251759413333333328642141CDCCCC6C351759419A99999971642141333333B34D1759419A999999946421416666666657175941CDCCCCCCF0642141000000A06517594166666666146521419A99991967175941CDCCCCCCEC652141333333B37817594100000000F4652141CDCCCCCC711759419A999999126621419A9999596B1759416666666686662141000000A0611759419A999999CF672141CDCCCC8C4A1759410000000011682141666666E6481759419A999999646821419A99997944175941333333339E682141000000604317594133333333ED682141000000603D17594100000000136921419A9999F9361759410000000029692141CDCCCC6C2E1759410000000097692141666666462E175941CDCCCCCCD46921419A99991932175941CDCCCCCC036A2141666666663A17594166666666496A2141666666864217594133333333986A2141CDCCCC4C48175941CDCCCCCCF66A2141333333334B17594166666666E56E2141CDCCCCCCEF17594133333333636F2141000000A00118594100000000167221410000004055185941CDCCCCCCD7722141CDCCCC0C6D1859419A9999998E7321419A9999597F185941CDCCCCCCEB732141000000808C18594100000000567421416666666696185941CDCCCCCC6D742141666666269F1859419A999999F6742141CDCCCCACAF185941000000006175214166666606BB18594133333333217621419A999959CC1859410000000072772141CDCCCCACEC18594133333333EB772141666666C6F61859416666666647782141666666C6101959419A999999A778214166666646181959419A999999CF78214166666646081959416666666608792141333333530119594166666666B579214100000080F218594133333333317A2141CDCCCCCCE518594166666666DE7A21419A999919DA1859419A9999990E7C214133333333C21859419A999999CC7C2141666666C6B91859419A999999F47C214166666646B718594100000000EC7D214100000020A41859419A999999387D2141CDCCCC6C871859419A999999D27D21419A9999F97A185941000000009B7D21419A9999197118594100000000CA7D2141000000C06A185941CDCCCCCC7E7D2141CDCCCC8C47185941000000004E7D2141000000003A185941CDCCCCCCC27D2141000000C02A18594133333333F57D2141CDCCCCEC3018594133333333317E2141000000E030185941CDCCCCCC767E2141CDCCCC4C2E18594166666666C67E21419A9999B926185941CDCCCCCCCF7E21419A9999F91D185941333333339D7E21416666664615185941CDCCCCCC9C7E2141CDCCCC0C0F18594166666666BA7E2141000000400B1859419A9999998A7F2141000000600E1859419A999999248021419A9999190A185941CDCCCCCC17802141666666E6051859419A999999298221419A9999D907185941CDCCCCCCC882214100000060F6175941CDCCCCCC8E82214100000040EE1759410000000062832141000000E0DB175941CDCCCCCCD783214166666666E5175941333333333784214166666646EA1759419A9999998484214133333333EA17594166666666EF842141333333D3F0175941000000004885214166666666E617594166666666458621419A999919CB17594133333333BE862141CDCCCC8CC51759416666666635872141CDCCCC0CC117594100000000998821419A9999D9B6175941CDCCCCCCF088214133333313B2175941CDCCCCCCA289214100000040A517594133333333678A2141333333F39517594100000000FF8A2141666666C68617594133333333BB8B21410000004078175941666666668F8C2141CDCCCCEC6B17594166666666118D2141333333136617594133333333768D21419A9999F95D17594133333333CF8D21410000004071175941CDCCCCCC708D2141333333737C17594133333333C18D2141000000E08F175941000000001F8E214166666626A817594166666666A68E2141000000609E1759419A9999999B8E21419A9999B9991759419A999999C18E2141CDCCCCEC9717594133333333C58E2141CDCCCC6C8F1759419A999999248F2141333333538A1759419A999999408F2141CDCCCCAC9317594100000000988F2141000000609017594100000000E38F214100000080931759419A9999993090214100000020981759416666666683902141CDCCCC8C9B1759419A9999999A902141666666A6A61759419A9999999090214133333393B5175941000000005A9021419A9999D9B21759419A99999903902141CDCCCCACB7175941333333335E90214166666626C51759419A999999B0902141666666E6C3175941CDCCCCCCF69021419A999919C9175941000000003D91214166666686CC1759413333333339912141666666A6BB1759419A99999967912141CDCCCCACBC175941000000002092214100000060C61759416666666677922141333333F3C81759416666666678922141333333B3CE175941CDCCCCCC539121419A999939EF175941666666662C912141333333B3F5175941333333332A9121419A9999B9FC17594133333333509121419A9999D902185941666666669B912141666666060818594133333333F89121410000006007185941666666660C922141333333B310185941333333338592214133333313161859419A99999986922141CDCCCC4C26185941CDCCCCCCA89221419A9999D9281859419A99999928932141000000A02B1859416666666664932141000000E02B18594100000000EB9321416666664625185941333333331D952141CDCCCCAC3C185941666666661095214166666666461859419A999999B19521413333335347185941CDCCCCCC349621419A9999F9531859410000000073962141666666A64818594133333333AF962141333333534018594100000000BB962141666666663C18594133333333E3962141000000A03718594100000000239721413333331338185941666666662B972141333333B331185941666666665A9721419A99991931185941CDCCCCCC82972141000000202D185941333333339B9721419A9999792D18594100000000CA9721410000006026185941000000002A982141CDCCCC8C27185941000000007C982141000000202B185941CDCCCCCCB0982141000000C02F1859419A99999917992141666666662F185941333333335A992141CDCCCCEC2918594100000000C1992141000000E025185941CDCCCCCC059A21416666666620185941666666660B9A2141CDCCCC4C1718594133333333619A21410000008014185941333333338B9A2141333333731418594166666666E39A2141333333931018594100000000199B2141CDCCCC6C081859419A999999229B21416666668603185941666666663B9B2141CDCCCC4C0218594166666666709B21419A9999B9051859419A999999AB9B2141666666460F18594166666666C99B2141333333F30818594133333333EC9B2141333333D305185941CDCCCCCC059C2141666666260718594133333333269C214166666666011859419A999999499C2141CDCCCC2C03185941333333335D9C214100000040FF17594100000000AD9C2141333333D3FA17594133333333EE9C2141333333F3FC1759419A999999F29C2141666666A60018594133333333149D2141000000E00018594166666666359D214100000020FD1759419A999999599D2141000000C00318594133333333689D21410000004002185941333333335B9D2141000000E0FB17594133333333889D2141666666460018594100000000A79D214100000020FE17594133333333959D2141CDCCCC4CF61759419A999999B69D2141CDCCCCACF3175941CDCCCCCCBC9D2141666666A6F717594166666666E39D21419A9999B9F217594133333333439E21419A999939EA175941CDCCCCCC989E21419A99995905185941CDCCCCCC7A9E21419A9999D90A185941CDCCCCCC979E21419A9999B90E1859419A999999BE9E2141666666C61F185941666666661B9F21419A9999792C1859419A9999997F9F21413333337336185941CDCCCCCC9B9F2141000000C03A1859413333333329A021419A9999D92D185941CDCCCCCC4FA02141000000A0191859419A9999994DA12141333333D332185941666666667AA12141CDCCCC8C2F185941CDCCCCCCA7A12141CDCCCC6C3718594133333333BAA12141CDCCCCEC4118594133333333F1A121410000006045185941333333331FA2214166666666531859419A9999997DA221419A9999D94C18594133333333C2A22141CDCCCCCC53185941CDCCCCCCBAA2214133333353651859410000000024A22141CDCCCCAC9B18594166666666FDA2214133333393BD18594100000000ECA3214166666686AD185941CDCCCCCCDCA3214133333393A81859413333333359A42141CDCCCC4CA21859410000000065A421419A9999D9B9185941333333331DA5214100000000B71859419A99999963A5214133333313B718594166666666F1A5214166666626B3185941CDCCCCCC3AA6214133333393B71859416666666683A6214166666626B81859416666666678A62141333333B3B118594166666666E3A62141333333F3A9185941666666663FA7214100000060A61859419A999999C6A7214166666626A918594100000000A3A72141666666869F185941CDCCCCCCC4A82141333333B38918594166666666E9A821419A9999798E185941666666666BA9214133333393A5185941CDCCCCCCD6A9214166666606971859419A999999C1A821419A9999F9491859413333333334A92141333333D3421859416666666612A921419A9999B930185941333333339EA921413333339330185941666666664BA921419A99993925185941CDCCCCCC56A92141333333F31518594100000000D4A821419A999999121859413333333357A82141666666E613185941333333337BA8214166666606FD1759419A9999997AA82141CDCCCCECF31759419A99999985A821419A999919E81759419A999999A3A82141CDCCCC0CE71759419A99999978A821419A9999F9D81759419A9999994FA82141CDCCCCECCF175941CDCCCCCCBAA8214166666646C51759410000000092A821419A999979BA1759416666666667A8214133333313B917594166666666D2A82141CDCCCC0CB1175941CDCCCCCCA9A8214166666606A817594100000000B5A72141CDCCCC6CBA17594100000000BDA72141000000C0B01759416666666663A72141CDCCCC4CA81759419A99999996A721419A999979A2175941CDCCCCCCF2A7214133333353A0175941CDCCCCCCD5A72141000000608A175941CDCCCCCC0EA82141000000C084175941333333330CA821416666668681175941333333333BA821419A9999D97E1759410000000022A821419A9999597B17594166666666D7A72141333333D37F17594100000000D2A72141CDCCCCEC771759413333333315A821419A99997973175941CDCCCCCCECA721419A9999796C175941CDCCCCCC25A8214133333333691759419A9999995DA821419A9999B9751759416666666676A82141666666066E1759413333333357A821419A9999B95D17594100000000F1A72141666666E64E1759419A999999E8A72141333333134A175941CDCCCCCCA1A72141666666864B175941CDCCCCCC69A721413333331346175941000000004CA72141CDCCCCCC371759416666666655A7214166666626331759416666666631A721419A9999F92F175941000000002DA72141333333532B175941666666665FA72141333333F319175941666666664FA721416666668615175941CDCCCCCC0BA72141000000E01117594133333333CFA62141333333730C17594133333333B7A6214100000080081759410000000080A62141CDCCCCEC10175941666666667FA521419A9999D9F7165941CDCCCCCC1BA5214100000020F0165941CDCCCCCC8BA42141333333F30817594100000000A2A3214133333313F2165941000000001EA421419A999979E41659419A999999B6A32141333333F3D516594133333333BBA32141CDCCCCCCCF1659416666666629A3214133333333C21659419A99999949A32141666666C6BD16594100000000FEA22141000000A0B31659416666666662A3214133333393A7165941CDCCCCCCA3A32141333333B3AF1659419A999999E0A32141333333D3A8165941000000009AA32141333333F39E16594100000000BFA32141CDCCCCAC9B16594133333333D2A32141CDCCCCAC8F165941000000000CA42141CDCCCCCC92165941666666662FA421419A9999199A1659416666666669A421410000004093165941000000000CA5214166666626821659419A99999961A52141666666867C1659413333333356A521419A99993975165941333333331CA52141CDCCCC2C6C1659416666666667A521419A9999F962165941CDCCCCCC7AA521413333339368165941000000009EA52141000000006A165941333333333FA62141000000C05916594166666666BFA621419A9999D96316594100000000C6A621419A9999B958165941CDCCCCCC15A72141000000C0571659413333333332A72141CDCCCC4C641659419A9999996DA72141CDCCCCEC5C16594166666666A4A72141666666A6591659419A999999B3A72141666666665B16594133333333D1A72141CDCCCCAC56165941000000001FA82141CDCCCCEC5D1659416666666635A821419A9999595516594166666666B1A82141000000405B16594100000000DBA82141CDCCCC8C5B1659419A999999B7A92141333333F3551659419A999999D6A92141000000004D165941333333333CAA2141333333B355165941CDCCCCCC68AA21416666666650165941CDCCCCCC9AAA2141000000805116594133333333DCAA21419A9999B956165941000000009BAA21419A9999196B1659413333333302AB2141CDCCCC0C7516594100000000B4AB214100000000661659416666666681AB2141666666465D16594100000000B3AB2141000000A055165941CDCCCCCC08AC2141CDCCCC2C641659416666666636AC2141666666A66E1659410000000090AC2141CDCCCC6C6816594133333333DEAC2141000000C073165941000000002BAD2141000000006A1659413333333337AD2141666666E665165941333333332FAD2141000000C05F16594166666666FFAC214133333313591659413333333383AD2141CDCCCC6C50165941CDCCCCCC9BAD2141333333534C165941666666669BAD21419A9999B9441659419A99999989AD2141000000003E1659419A999999DFAD21416666664636165941000000002AAE214166666606401659419A99999957AE21419A9999592B165941CDCCCCCC33AE2141000000601F16594100000000A5AE2141000000E019165941CDCCCCCC9AAE21416666662616165941666666665EAE2141333333B30E16594133333333AEAE2141000000200C16594133333333E9AE214133333393FF1559416666666611AF2141CDCCCC4CF0155941CDCCCCCC49AF214166666646E11559410000000094AF214133333313D61559419A999999D5AF214133333313DF155941CDCCCCCC4EB0214133333333D115594166666666E1B0214166666666C21559413333333388B02141CDCCCC0CA9155941666666663FB02141CDCCCC6CA415594133333333A8AF214166666606B7155941CDCCCCCCA3AF214100000060C0155941CDCCCCCC88AF2141000000A0C3155941CDCCCCCC5DAF214166666686BD155941CDCCCCCC55AF2141CDCCCC2CB4155941333333330FAF214100000000AA15594133333333BDAE2141CDCCCC0CB4155941CDCCCCCC65AE21419A9999F9B2155941000000001CAE2141CDCCCC8C9E15594166666666EEAD21419A99993995155941333333338BAD2141666666A6A115594100000000E5AC2141333333F39A155941333333331FAD2141CDCCCC2C95155941000000004CAD21410000004094155941CDCCCCCC84AD2141666666468C155941666666660FAD2141333333F38A15594133333333E2AC21419A9999B98515594166666666D8AC214100000080751559413333333309AD2141333333F3631559419A99999908AD21419A9999F95915594133333333EEAC2141333333734A155941333333337FAC2141000000004A155941666666661BAC21419A999999461559419A999999A0AB21419A9999F9471559410000000095AB21413333337355155941CDCCCCCCCFAA214166666646581559419A999999CEAA21416666662646155941CDCCCCCC42AA214100000080491559410000000038AA21419A9999393D1559419A999999ECA92141CDCCCCCC3415594166666666E6A921419A9999593015594166666666A8A92141CDCCCC2C29155941666666667BA92141CDCCCC0C28155941333333331AA92141CDCCCC6C2D15594133333333BBA821419A9999192E15594133333333BFA8214100000000421559419A999999E1A72141CDCCCC8C2F155941CDCCCCCCA9A7214100000000421559410000000067A72141CDCCCC8C4A1559419A9999993FA72141CDCCCCCC5215594166666666D0A62141666666A66515594166666666A1A621419A9999F96A155941333333334FA62141333333137215594166666666E4A52141000000C07715594133333333E4A42141333333F38A15594100000000AEA42141000000A095155941CDCCCCCC40A4214166666626A11559413333333366A32141666666C6B1155941000000001BA3214100000060B51559410000000099A22141000000609A15594100000000C3A121419A9999594C1559416666666643A22141000000A03615594100000000BAA12141333333F32B155941CDCCCCCC82A121419A99999929155941CDCCCCCC69A12141000000C025155941000000002AA121416666668614155941CDCCCCCCC0A0214166666666F0145941CDCCCCCC84A021419A9999F9DD14594100000000759F2141CDCCCC4CD814594133333333DA9E214100000000DA145941CDCCCCCC969E2141333333D3DB145941666666667E9E21419A999979E3145941333333335E9E2141CDCCCC6CE6145941CDCCCCCCF99D214166666666E0145941333333339B9D2141333333B3E314594133333333869D2141CDCCCCECD3145941CDCCCCCC5A9D214100000060C7145941CDCCCCCC209D21419A9999D9BF14594100000000B99C2141333333B3B8145941CDCCCCCCAE9C2141333333F3B414594100000000C19C2141000000E0A914594166666666D39C21419A999939A514594166666666679C21410000008082145941333333335E9C21419A9999D97D1459419A999999489D2141666666467D14594100000000549D2141333333136C1459419A999999399D2141333333B35C14594166666666DC9C2141000000C03D14594133333333D29C2141000000802F14594133333333E99C2141666666E629145941CDCCCCCC359D21419A9999391D14594166666666879D214166666626111459419A999999A99D2141CDCCCC0C081459419A999999999D214133333333F61359419A999999639D2141CDCCCC6CDF135941CDCCCCCC3A9D2141CDCCCC2CD3135941666666665D9D214166666666CC13594100000000B49D2141666666C6C113594166666666BF9D2141CDCCCCACAE13594166666666819E2141000000409F13594100000000309F2141333333F391135941CDCCCCCC579F2141CDCCCC0C9D1359419A999999969F2141333333D3A2135941CDCCCCCC0AA0214133333353B613594166666666C0A02141666666C6D0135941333333330EA121419A9999F9D51359419A999999AAA1214133333373EB135941CDCCCCCC25A221419A999919F91359416666666664A22141333333F3FB13594100000000CBA2214133333333FE13594133333333F8A2214133333373FC13594100000000E4A2214133333313F41359413333333316A3214166666666DF1359410000000022A32141000000C0D61359413333333313A32141CDCCCC6CCA1359419A999999DCA2214166666626BB13594100000000C0A2214133333353B0135941CDCCCCCCC1A2214100000040A21359416666666698A22141333333F390135941666666667DA22141666666A68C1359419A9999995AA22141CDCCCC8C80135941CDCCCCCC29A2214166666646651359419A99999928A221416666660659135941CDCCCCCC65A22141333333735513594100000000B8A22141666666C6581359416666666609A32141CDCCCCEC5813594100000000B9A321419A9999D955135941CDCCCCCC75A421419A99995950135941CDCCCCCC0EA52141000000A0451359413333333344A52141CDCCCCCC4313594100000000CFA52141CDCCCC2C421359419A9999992AA62141333333B3441359413333333332A62141CDCCCC2C3E1359419A9999992FA62141666666C62913594166666666EEA521419A999999FB12594100000000C6A5214133333393EA125941CDCCCCCC8EA52141666666A6DD1259416666666636A52141CDCCCC4CC1125941CDCCCCCCE7A4214166666666AE12594166666666BCA42141CDCCCC6CA1125941666666664DA42141CDCCCC6C7C125941333333337CA421419A9999196E1259413333333305A42141CDCCCCCC6A12594100000000A5A321419A9999D9801259419A99999976A321419A9999597B1259419A999999C1A321419A9999D96912594133333333E2A221419A99991962125941666666668AA221416666662660125941CDCCCCCC2CA22141666666E65F1259416666666696A121419A99993963125941666666663BA1214166666626621259419A999999ECA02141333333135F1259413333333365A02141CDCCCCCC3D1259419A999999559F2141000000204C12594100000000069E2141666666066212594100000000499E2141000000C080125941666666661F9D2141666666A6A1125941000000000D9D2141CDCCCC8C9412594100000000579C2141666666867512594166666666679B2141666666C67512594166666666659B2141666666867C12594166666666019B2141666666A67C125941CDCCCCCC009B2141666666E673125941CDCCCCCCC49A21410000002073125941333333334D9A2141CDCCCCAC76125941333333337299214166666606841259419A999999F09821416666662662125941666666668F982141CDCCCC0C651259419A999999D6972141CDCCCC8C651259419A9999997A972141333333D343125941666666669C962141333333F343125941666666663F962141666666C6421259419A9999990296214100000020331259419A99999904962141666666C629125941CDCCCCCC88962141000000A0291259419A99999987962141666666861712594100000000FE952141CDCCCCAC121259419A99999922962141CDCCCC4C071259419A9999990896214100000080F7115941CDCCCCCC81952141666666E6F811594166666666829521419A999959D911594133333333BC952141000000A0BB115941000000000D962141333333D3A3115941666666666A962141000000408D1159416666666615962141000000608C11594100000000B69521410000008085115941000000009995214166666606921159419A99999967952141333333139C115941000000002C952141000000E09F1159419A999999DC942141CDCCCC6CA911594133333333B59421419A999999B11159413333333300942141000000609F1159419A9999991D9421419A9999F995115941000000009C9421419A99991988115941000000007394214166666646771159419A9999995D932141000000C0781159419A999999D2922141333333B3651159419A999999EB912141CDCCCC0C4A1159419A999999D4912141333333D3431159413333333310922141666666064011594133333333E5912141666666263511594166666666F89121419A9999192B115941CDCCCCCC379221419A999959241159419A999999A1922141CDCCCCEC1A11594166666666DE922141CDCCCC6C1B1159410000000002932141666666A6271159419A99999990932141CDCCCC4C151159419A99999921932141CDCCCC2C00115941000000009B912141CDCCCC6C1911594100000000F6902141000000601B11594100000000E390214166666686FE10594133333333A9902141666666E6FD105941333333335D902141CDCCCC4CE4105941CDCCCCCC44902141CDCCCCECE31059419A999999E08F21419A999979E9105941CDCCCCCC4B8F214166666666E9105941CDCCCCCC428E2141333333B3F0105941666666662D8E214166666606EC1059419A999999758E21419A999939DB10594133333333968E214133333313D510594133333333C68E21419A999939D010594133333333268E214100000060C9105941CDCCCCCCE28D214133333333CD10594133333333468D2141CDCCCC6CB310594133333333668D214166666666A910594166666666D78C2141333333D3A5105941CDCCCCCC908C214133333373C0105941CDCCCCCCEC8B21419A999979CC10594133333333BF8B214133333393C110594133333333228C2141333333B3B410594166666666AC8C2141000000E09B105941333333333B8C21410000000092105941CDCCCCCC298C2141666666C68910594166666666A18C214166666626821059419A999999CE8C2141666666467E10594166666666508D2141666666E67010594133333333328D2141666666466A10594166666666D38C2141000000E06D10594100000000258C21419A9999D94D1059419A999999218C2141CDCCCC8C411059419A999999468C2141333333733810594133333333518D2141000000802E10594100000000448D21419A9999F92310594166666666198D21419A9999D92210594100000000E48C2141333333D3121059419A9999999B8C2141333333D31510594166666666108C21419A999939F70F594133333333C38B2141CDCCCC4CFC0F5941CDCCCCCC7A8B214166666686FD0F594100000000A18B2141666666060810594133333333BE8B2141CDCCCC4C2010594166666666488B2141333333531C1059419A999999138B2141CDCCCC0C1510594100000000F58A2141666666C60D1059419A999999F68A2141333333D3F90F5941333333337C8A214133333393FC0F59419A999999E68921419A9999B901105941CDCCCCCCE68921419A999939041059416666666612892141000000A00E1059419A999999A38821419A9999F903105941000000007A8821419A999959FD0F5941000000002E88214100000020EE0F594133333333EA87214100000040EF0F594133333333C787214100000060EC0F594133333333E786214100000080F90F594100000000FC8621416666662605105941CDCCCCCCEF862141CDCCCCEC0B105941CDCCCCCCFF8521416666668606105941CDCCCCCCD8852141CDCCCCCC18105941333333339785214100000060171059419A999999EF842141CDCCCC2C1610594166666666578421413333335319105941000000004D832141666666661A10594100000000328321419A9999591B1059419A999999EE822141666666A6211059419A9999997E83214100000000321059419A99999997822141CDCCCCCC51105941CDCCCCCCF88121419A9999595F10594166666666D0812141333333335B105941CDCCCCCC8F812141666666E65A105941CDCCCCCC98802141666666866110594166666666A4802141666666067910594100000000D0802141666666068710594133333333668121419A9999D98B105941666666667881214166666666981059413333333353812141CDCCCCCC9A105941333333333B812141000000E0A8105941666666663281214133333313BD1059419A999999F680214133333373BD10594100000000C8802141CDCCCC4CCD105941333333332A8021419A9999F9C410594166666666E27F214100000040CC10594166666666697E214100000080D710594166666666027E2141CDCCCC4CC91059419A999999837D214100000040AE105941CDCCCCCC737D21419A9999599F105941CDCCCCCC717D2141CDCCCC4C91105941000000007C7D2141000000008C10594100000000AB7C2141CDCCCC8C931059419A999999317C214166666646A010594133333333BD7B2141000000A0AF105941CDCCCCCC927B2141333333B3D5105941333333331F7B2141CDCCCCECF110594100000000247B214100000080F710594133333333EB7A214133333373FB10594166666666B77A2141000000E0FB10594133333333A17A2141333333B3F710594100000000837A214133333333F910594166666666737A214100000060FF1059419A999999837A21410000008003115941666666666C7A2141666666E60D1159419A999999367A2141000000E01111594100000000D5792141333333F31E1159410000000091792141333333F31E115941000000005A7921419A9999792311594100000000107921419A9999F92B11594100000000FD7821419A9999F92711594100000000D578214166666606281159419A9999992A782141CDCCCC2C211159419A999999BE7721419A99995917115941CDCCCCCC6D772141CDCCCC6C0B115941333333332A772141666666860611594100000000F37621416666666605115941CDCCCCCCB9762141666666260A115941CDCCCCCC94762141333333730F11594100000000D0762141333333532A11594100000000607621419A9999F940115941000000007E7621419A9999D948115941CDCCCCCCAA7621419A9999994F11594166666666C97621410000004058115941CDCCCCCCCE762141333333D35D11594166666666F67621419A9999D96B115941CDCCCCCC0C772141000000606C115941CDCCCCCC117721410000004077115941000000002277214100000020831159413333333325762141666666468C115941000000009176214100000040A11159416666666614762141CDCCCC4CBC1159419A999999AD752141CDCCCC0CB31159410000000065752141333333B3B3115941666666660B7521419A999999B7115941CDCCCCCC737421419A9999D9C01159410000000097742141000000C0C61159413333333336742141666666A6CE115941CDCCCCCCE2732141CDCCCC8CDE11594166666666DD7421419A9999B9F4115941CDCCCCCC0A752141333333F3EF115941333333335C752141CDCCCC0CEE11594133333333B1752141CDCCCC8CFC1159416666666688752141666666C607125941CDCCCCCCC67621419A9999992F12594133333333D3762141000000E032125941CDCCCCCCA8762141666666063A125941000000006D762141666666663C1259419A99999981762141CDCCCC0C461259410000000053772141000000004012594133333333C3772141333333D38512594133333333B97821416666666684125941666666669E782141000000408F1259410000000036792141666666A68F1259419A99999943792141666666268C12594166666666F6792141333333D3981259419A9999998A7A214100000000A512594166666666597B2141000000E0C0125941CDCCCCCC057C214166666626C2125941CDCCCCCC1B7C214166666686DE12594166666666747C21419A999999F0125941CDCCCCCCBA7C214166666606F9125941000000008C7B2141CDCCCCEC101359419A999999967B2141000000801E135941CDCCCCCC967A2141CDCCCC6C1013594166666666967A2141666666662D1359419A999999767A2141CDCCCC2C3413594166666666067A2141666666063B135941333333338C792141666666664013594133333333B37921413333335356135941000000009D7921413333339359135941CDCCCCCCDA792141CDCCCC0C6F135941CDCCCCCC117A2141CDCCCCCC7E13594133333333F0792141CDCCCCCC7F135941000000009A792141CDCCCC8C87135941CDCCCCCC0B7A2141000000E0A0135941CDCCCCCC81792141CDCCCC0CB5135941666666661F7921419A9999F9BD1359419A99999926782141CDCCCCACA91359413333333311782141CDCCCCCCBE135941333333331478214100000060CB1359419A9999993078214133333393DA13594133333333EB7821419A999999D213594100000000F7782141CDCCCC4CD9135941CDCCCCCCE578214133333333E7135941000000000879214100000080E813594100000000F9782141333333D3F813594166666666C9792141333333D30314594100000000057A21413333335308145941333333333A7A21419A999939131459410000000062782141333333533414594166666666B0772141333333533914594100000000177821416666660659145941CDCCCCCCEC772141000000806B1459419A99999923782141333333D36D1459419A99999996782141000000609514594100000000CF782141666666E69F145941CDCCCCCCBF79214166666646AE1459416666666678792141000000A0C7145941CDCCCCCCE8792141666666C6CE1459419A999999267A2141000000C0D614594100000000B27A214100000000DD14594133333333E87A21419A999979E41459419A999999B87A214166666606EB145941CDCCCCCC8F7A2141666666A6F314594100000000507A214100000000FE1459419A9999998A7921419A9999790D155941000000006F792141333333130E155941666666663C792141000000A00A15594100000000067921419A9999F90F15594100000000A6782141CDCCCC6C14155941CDCCCCCCE575214166666686F914594166666666A27521419A999959F91459419A99999959752141CDCCCC6CF3145941000000004A752141CDCCCC0CE91459410000000010752141333333F3E21459419A999999EF7321419A999979D614594100000000297421419A9999F91B15594100000000ED732141CDCCCCEC4015594133333333CB732141666666E64F1559419A9999999E732141000000A053155941666666665F7321419A9999B949155941CDCCCCCC59732141000000803F155941000000005B732141CDCCCC0C2D155941333333334E7321419A99991928155941CDCCCCCC1B7321419A999919211559419A999999AA722141CDCCCC0C1415594133333333577221419A9999B908155941CDCCCCCCC371214100000060011559410000000041712141333333B3F414594133333333E8712141666666261C155941CDCCCCCC5D722141333333D33215594133333333A9722141333333734A15594133333333F1722141CDCCCCCC6715594100000000E97221419A9999D96E155941CDCCCCCC9D722141333333937E1559416666666637722141333333B391155941CDCCCCCCDF712141000000808B155941000000007D712141CDCCCCEC8C155941CDCCCCCC44712141CDCCCCEC8A155941CDCCCCCCBD7021419A9999B9881559419A9999995F70214133333313811559419A99999909702141CDCCCCCC72155941CDCCCCCC9A6F21419A9999B964155941666666662A6F2141666666A658155941CDCCCCCCD86E21413333333345155941333333338D6E2141CDCCCC4C3B15594133333333EC6D21419A9999D92B1559419A999999606C2141000000A04515594166666666506B2141666666666315594133333333B66B2141CDCCCCEC7D15594166666666CA6B21419A999979941559419A999999886B2141CDCCCC2C9D15594133333333046B2141CDCCCCCC9915594100000000E76A21419A9999B99515594100000000F06A21419A99997986155941CDCCCCCC6D6A21410000006085155941333333336D6A21419A9999B9901559419A9999991B6A2141000000009615594166666666006A2141CDCCCC4C9B15594166666666E7692141666666C6AD15594133333333BC69214100000020B5155941CDCCCCCC756921419A999979AD15594133333333CE68214133333393CE155941666666668A682141666666C6DA15594166666666386821419A999939E415594166666666116821419A999999DF155941CDCCCCCC71672141CDCCCCACF415594133333333A8672141000000E0FE1559419A99999968672141000000C00E1659413333333360672141000000E02B165941CDCCCCCC956721416666662659165941000000005E662141CDCCCCAC611659413333333342662141666666E66F165941CDCCCCCC1F662141000000E078165941CDCCCCCCD86521419A99993979165941CDCCCCCC7F652141666666467716594166666666106521416666664672165941333333339D642141CDCCCC6C7316594166666666AE642141000000A07E1659419A999999B7642141CDCCCC8C9316594166666666836421419A9999D9AF1659419A999999956421419A999919BB16594100000000BF64214100000000C416594100000000D464214133333333D31659419A999999936421419A999999D81659416666666648642141CDCCCC4CE616594133333333036421419A999979F1165941CDCCCCCCB8632141666666A6FB165941666666665F6321413333333304175941666666665F6321413333333304175941	01010000206A0800001858D5E05D8A2141CDCCCC2C80145941	870030000	Z	Arnac-la-Poste	8700300	87003	87	75	47
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	01010000206A080000AC676F6585482241666666C621DF5841	870040000	Z	Augne	8700400	87004	87	75	18
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	01010000206A0800009260EA89C49421419A9999C997E35841	870050000	Z	Aureil	8700500	87005	87	75	10
01060000206A08000001000000010300000001000000140500006666666605AB2041666666A6A8185941333333334EAB20419A9999B9AF1859419A9999999EAB204133333333B718594166666666DCAB20419A999939BD185941CDCCCCCCFBAB204133333333C01859419A99999952AC2041CDCCCC8CC818594100000000AAAC2041333333D3D01859410000000004AD204100000040D91859419A99999945AD2041CDCCCC8CDF1859416666666656AD204100000060E11859410000000060AD2041000000E0E21859413333333366AD204166666666E41859419A99999975AD2041CDCCCCECEB1859413333333386AD204166666666F318594166666666B5AD2041000000600519594133333333D5AD20419A9999991219594133333333F0AD2041333333131D19594133333333F8AD20410000002020195941CDCCCCCCFCAD2041000000E021195941CDCCCCCC18AE2041CDCCCC4C201959419A9999995AAE2041666666E61B1959419A999999ADAE2041CDCCCCCC151959416666666609AF2041000000000F195941CDCCCCCC6DAF20416666668607195941CDCCCCCCC6AF204100000000011959410000000001B0204166666666FC18594166666666D5B02041000000802D1959410000000099B12041666666E6641959419A999999A4B120419A9999B96C195941333333337BB12041666666A679195941CDCCCCCC6DB120410000008080195941CDCCCCCC85B12041666666E69E1959416666666654B12041000000C0A71959419A999999E8B0204100000060AA1959410000000075B0204100000000BF1959419A99999910B020419A9999F9CC1959410000000074AF2041666666E6C519594133333333BBAE2041CDCCCCECBC195941CDCCCCCC7CAE204100000020BF195941CDCCCCCC5DAE204133333373C41959410000000044AE20419A999999CE1959410000000059AE2041CDCCCC8CD8195941000000001BAF2041CDCCCCAC101A5941333333339BAF204133333313261A5941333333338DAF20419A9999D9571A59419A999999F1AF2041666666A6571A5941666666664CB02041CDCCCC4C651A5941000000003CB12041666666C6811A5941CDCCCCCCA3B120419A9999B98A1A594166666666A4B12041CDCCCCEC8B1A594133333333A6B1204166666626901A594100000000ABB120419A999979931A59419A999999B0B12041666666E6951A594133333333B7B12041CDCCCCEC971A5941CDCCCCCCC0B12041CDCCCC6C991A59419A999999CDB12041000000609B1A594100000000E0B12041CDCCCCAC9D1A59416666666653B220419A999979981A59419A999999FCB32041CDCCCC2C8A1A5941000000000BB62041000000C0811A59410000000049B620419A9999B99B1A594166666666B6B62041CDCCCC0C981A5941CDCCCCCC5AB72041666666C6971A5941000000006DB720419A9999B9991A5941CDCCCCCC89B72041000000409D1A594166666666A5B720419A9999999F1A594133333333B0B7204166666686A21A594166666666A6B7204166666606A71A59410000000096B720419A999979AB1A59419A99999996B720419A9999D9B01A594100000000ACB72041CDCCCC8CB71A5941CDCCCCCCADB720419A9999D9BB1A594133333333ACB7204133333373C01A59419A999999B1B7204100000020C61A594166666666B9B72041333333F3CB1A59419A999999CBB720419A999959D11A594100000000E2B72041666666A6D81A594100000000E7B720419A9999B9DD1A594133333333ECB720419A9999D9E21A594100000000ECB72041CDCCCCCCE61A594100000000EAB7204166666626E91A59419A999999EEB72041CDCCCC0CEC1A59410000000001B8204133333333EF1A59419A99999909B82041666666A6F11A5941333333330EB8204166666626F61A59419A99999910B820419A9999B9FB1A59416666666611B8204133333313FF1A5941CDCCCCCCF6B72041000000A0041B594133333333DBB7204133333373061B594100000000C4B7204166666606091B5941CDCCCCCCA8B72041000000400C1B59410000000089B72041CDCCCC0C0F1B5941CDCCCCCC66B72041CDCCCC0C121B5941CDCCCCCC47B7204100000060141B5941CDCCCCCC2DB7204100000000161B59419A9999991AB72041000000A0161B5941333333330DB720419A999979171B59419A99999907B72041CDCCCC2C1A1B5941CDCCCCCC03B72041000000C01D1B59416666666601B72041CDCCCCAC201B59410000000004B720419A9999F9241B5941CDCCCCCC0AB72041666666C6271B59413333333308B72041333333932A1B59419A99999900B72041CDCCCC8C2D1B594133333333F8B62041CDCCCCCC2F1B594166666666F3B620419A999959321B594100000000F6B620419A999919351B594166666666F8B62041000000C0381B59419A999999F9B62041666666E63B1B594100000000FEB62041333333133E1B5941333333330BB72041333333F3401B59410000000013B72041CDCCCCEC421B5941CDCCCCCC18B7204100000000461B59416666666622B7204166666606491B5941CDCCCCCC36B72041CDCCCC4C4C1B59413333333350B72041CDCCCCEC501B5941000000006CB72041666666A6551B5941000000008CB72041666666C6591B5941CDCCCCCCBDB720419A9999F95F1B594133333333F2B7204133333373661B59419A99999911B82041000000406A1B5941000000002AB82041333333B36D1B59419A9999992FB820419A9999D96F1B5941666666662DB820419A999939731B59419A9999992FB82041333333B3761B59416666666633B82041666666C67A1B5941CDCCCCCC38B82041CDCCCC8C7F1B5941333333333BB8204100000080821B59419A99999942B82041CDCCCCEC841B59416666666652B82041CDCCCC4C861B5941000000006DB8204166666606881B59419A99999988B8204100000080891B5941CDCCCCCC9FB82041000000208B1B594133333333AEB82041000000608C1B594133333333A9B82041CDCCCC0C8E1B59419A999999A1B82041333333F38E1B59410000000097B82041CDCCCC2C901B59419A99999985B82041CDCCCC4C921B59419A99999977B82041333333F3941B59413333333371B8204100000060971B59413333333372B82041CDCCCC0C9A1B5941CDCCCCCC75B82041CDCCCC6C9B1B5941666666667FB820419A9999B99D1B5941666666668CB82041CDCCCC2C9F1B5941000000009EB82041333333F39F1B59419A999999B4B82041333333739D1B594133333333CDB82041333333739C1B594100000000E2B82041333333339D1B5941CDCCCCCCF9B82041666666A69D1B59410000000018B92041333333D39D1B5941000000002FB92041000000C09E1B5941000000004FB92041333333B3A01B59416666666667B920419A9999F9A11B59419A99999985B9204166666666A41B59416666666693B920419A9999D9A61B594100000000A0B92041CDCCCC6CAA1B594133333333AAB920419A999979AE1B5941CDCCCCCCB5B92041333333D3B11B594133333333C2B9204166666686B41B5941CDCCCCCCC6B9204100000000B61B5941CDCCCCCCCFB9204100000060B91B594133333333CEB920419A999999BB1B59419A999999C2B9204100000000BF1B5941CDCCCCCCC5B920419A9999B9C11B594133333333D1B92041333333F3C41B594133333333E0B92041333333F3C71B594166666666F1B92041CDCCCC2CC91B594100000000F8B920419A9999F9CB1B59419A999999FFB92041333333B3CD1B59416666666616BA20419A999959CF1B59410000000036BA2041666666C6D01B5941000000005CBA20419A999919D21B5941CDCCCCCC84BA2041CDCCCC4CD31B59410000000098BA20419A999999D31B594133333333A9BA2041CDCCCC4CD41B5941CDCCCCCCBEBA2041CDCCCC2CD61B59419A999999CEBA204100000020D81B594133333333DBBA2041666666E6D91B59419A999999E8BA20419A9999F9DA1B59419A999999F6BA2041CDCCCCACDB1B59410000000006BB20419A999999DB1B59419A99999910BB204100000080DB1B5941CDCCCCCC2FBB204133333353DB1B5941666666663ABB204100000080DB1B5941333333333EBB2041666666C6DC1B59416666666636BB20419A999939DE1B59410000000023BB20419A9999D9DF1B59419A9999991DBB2041000000A0E01B59416666666623BB20419A999979E21B5941000000002FBB204133333333E51B5941CDCCCCCC48BB2041000000E0E71B59413333333355BB204100000060EA1B5941333333335DBB20419A999939ED1B59419A99999964BB2041333333B3EF1B59419A9999996DBB2041000000E0F21B5941666666666CBB204133333313F91B59416666666675BB2041000000E0FE1B59419A99999980BB204133333333041C5941CDCCCCCC80BB2041000000800A1C5941333333337ABB2041666666460D1C5941666666665DBB20419A9999B9141C59416666666653BB2041333333F31F1C5941333333333DBB2041000000A0261C5941333333330EBB204100000080311C594166666666F8BA204133333373351C594166666666CEBA2041333333B33A1C5941CDCCCCCC73BA2041666666E6431C59416666666654BA2041333333B3481C59413333333333BA2041000000804F1C59419A99999923BA20419A999919521C59410000000016BA20419A999919541C59419A99999909BA20419A9999B9541C594100000000F0B920419A999919571C594133333333E8B920419A999919571C5941CDCCCCCCE1B920419A999919571C59419A999999DBB9204100000080561C59419A999999D0B920419A999959561C59419A999999CDB920419A9999B9561C594166666666CAB92041333333B3571C594100000000C9B9204133333313591C594166666666C4B92041333333735A1C59419A999999BFB92041CDCCCC6C5B1C59419A999999B9B92041333333D35B1C594166666666B3B920419A9999395C1C594166666666A8B92041CDCCCC6C5C1C59419A9999999DB92041333333735C1C59419A99999992B920419A9999D95B1C59419A9999998DB920419A9999195B1C59416666666684B920419A9999B95A1C59416666666679B920419A9999B95A1C5941000000006DB92041333333535B1C59416666666668B92041000000805C1C59413333333365B920419A9999795D1C59416666666665B920419A9999D95E1C59419A99999968B92041333333D35F1C59410000000088B920419A999919631C5941000000009BB92041000000A0651C594166666666A1B92041CDCCCC8C671C594166666666A1B92041CDCCCCEC681C594166666666A1B92041666666E6691C5941CDCCCCCC99B920419A9999196B1C59410000000092B92041666666466C1C59419A9999998DB92041000000A06D1C5941666666668AB92041666666666F1C59419A9999998AB920419A999959711C5941CDCCCCCC8DB92041333333B3721C59413333333397B92041CDCCCC0C741C59419A999999A0B92041CDCCCC6C751C594166666666A5B9204166666666761C59419A999999A8B9204133333393771C5941CDCCCCCCA5B92041333333B37A1C594133333333A6B92041CDCCCC8C7F1C59419A999999A4B92041CDCCCCEC801C59419A999999A4B9204166666646821C594166666666A9B9204166666646831C5941CDCCCCCCAFB92041CDCCCC6C841C594133333333B9B9204100000060851C5941CDCCCCCCC3B92041CDCCCC0C861C59410000000000BA204100000080871C59410000000011BA20419A999939881C59413333333319BA204133333313891C59419A99999928BA20419A9999F98B1C59410000000042BA20419A9999B98F1C5941333333334CBA2041CDCCCC6C921C59413333333387BA204166666606A61C594133333333C8BA2041CDCCCC2CB81C5941CDCCCCCCE5BA2041CDCCCC0CC31C59419A999999F5BA20419A9999D9C61C594133333333F6BA2041CDCCCCACC81C594166666666DABA204166666646CE1C5941CDCCCCCCD2BA20419A9999D9D01C5941CDCCCCCCD1BA2041CDCCCCCCD21C5941CDCCCCCCD5BA2041666666E6D71C594166666666F7BA204133333333E11C5941CDCCCCCC01BB20419A999939E51C594100000000FABA2041666666A6E91C594100000000F2BA204100000060EC1C5941CDCCCCCCF2BA2041333333D3ED1C59419A999999FABA20419A9999F9EE1C59410000000007BB2041CDCCCC4CEF1C5941333333332BBB204133333373EE1C5941333333333FBB2041666666A6EE1C5941666666664BBB2041CDCCCC6CEF1C59419A9999995EBB2041333333B3F11C59413333333377BB204133333393F41C59419A99999997BB20419A9999F9F81C59419A9999999BBB2041CDCCCC2CFA1C5941CDCCCCCC9CBB20419A999979FC1C5941CDCCCCCCA6BB204133333313FF1C594133333333B6BB20419A999939001D594166666666CFBB2041000000E0001D594166666666E0BB204100000020021D594133333333F9BB2041333333B3051D59419A999999FEBB204133333373061D59419A9999991BBC20419A999999091D5941CDCCCCCC31BC2041CDCCCC0C0D1D5941CDCCCCCC37BC2041666666860E1D59419A99999939BC20419A999939101D5941CDCCCCCC41BC204166666626121D59410000000075BC2041666666861A1D59419A99999977BC2041666666461B1D59419A99999979BC2041666666661F1D5941CDCCCCCC7FBC2041333333B3201D594100000000A6BC20419A999979221D59419A999999C0BC20419A999939261D594100000000E0BC2041333333B3271D594133333333F2BC20419A999959291D594100000000FFBC2041CDCCCC8C2C1D59416666666607BD20419A999999341D59419A9999990DBD204166666646371D59419A99999916BD2041666666E6381D5941CDCCCCCC29BD2041333333533B1D59410000000053BD2041CDCCCC6C431D5941000000005CBD204166666626441D5941666666666BBD2041CDCCCCCC441D59419A99999987BD20419A9999F9461D5941CDCCCCCC90BD2041CDCCCCCC4A1D59419A99999989BD2041666666464C1D5941CDCCCCCC74BD2041333333934D1D59419A99999967BD20419A9999794F1D59416666666660BD2041000000C0511D59419A99999961BD204133333353541D59419A9999995FBD20419A9999D9551D59410000000056BD2041000000C0561D5941666666664ABD2041666666E6571D59419A9999992FBD204166666606591D59419A99999923BD20419A9999D9591D59413333333316BD2041CDCCCC0C5C1D59413333333304BD204133333333601D594133333333EDBC20419A999979621D594133333333E1BC2041CDCCCC2C631D594133333333B9BC20419A999939631D5941CDCCCCCCA6BC2041333333D3631D5941000000009CBC2041000000E0641D5941CDCCCCCC80BC2041000000A0681D5941CDCCCCCC65BC2041CDCCCCEC6A1D59416666666652BC2041666666066B1D59419A9999992EBC204166666646691D5941333333331ABC204100000040691D59416666666606BC20419A9999396A1D5941CDCCCCCCF6BB2041333333D36B1D594133333333ECBB2041000000606C1D594100000000B0BB2041CDCCCC4C6D1D59416666666699BB2041000000E06E1D59413333333387BB2041333333B36F1D5941CDCCCCCC7DBB2041333333D3701D5941CDCCCCCC74BB204100000080721D59410000000071BB20419A999919761D59413333333370BB2041333333B37E1D59419A9999996CBB204166666666801D59410000000068BB2041333333F3801D5941000000004FBB204100000060811D5941CDCCCCCC27BB204133333393821D59413333333316BB204100000040841D59410000000008BB204166666626871D59419A999999F4BA2041000000C0881D594133333333DABA2041666666A6891D59419A9999999BBA2041666666C68A1D59410000000050BA2041333333D38E1D59419A9999994DBA204133333333901D5941333333335ABA2041CDCCCC0C951D5941333333335ABA204133333333991D59416666666654BA2041333333939A1D59410000000041BA2041000000A09B1D59413333333332BA2041000000E09C1D59413333333321BA2041333333739F1D5941CDCCCCCC18BA2041333333F3A21D59413333333317BA204133333313A61D5941333333331BBA20419A999939AA1D59410000000025BA2041CDCCCC6CAF1D59419A99999942BA2041CDCCCC8CB81D5941CDCCCCCC53BA2041000000A0BB1D5941CDCCCCCC60BA2041CDCCCCCCBE1D59419A99999964BA2041CDCCCC4CC51D5941333333336FBA204166666666CA1D59416666666673BA2041666666E6DC1D59413333333383BA204100000020E11D59419A9999998DBA2041CDCCCCECE31D5941000000009BBA2041CDCCCCECE61D5941CDCCCCCCE1BA2041000000C0EF1D594166666666F8BA204100000060F31D5941CDCCCCCC0BBB2041666666E6F51D5941CDCCCCCC21BB2041333333B3F91D5941CDCCCCCC2ABB2041666666C6FC1D59419A9999992DBB2041CDCCCC6C041E59413333333333BB204166666686081E59416666666649BB2041000000C00C1E5941CDCCCCCC7DBB204133333373101E59416666666699BB20419A9999D9111E59419A999999B9BB2041CDCCCCEC131E594166666666CBBB2041CDCCCCEC141E5941CDCCCCCCD9BB204133333353161E594166666666DEBB2041CDCCCCCC171E594166666666D9BB20419A999959191E59419A999999CBBB2041333333D31A1E594133333333BFBB2041666666A61A1E594100000000B2BB20419A9999D9191E594100000000A5BB204166666626191E59416666666693BB204133333353191E59419A9999998ABB2041CDCCCC2C1A1E5941333333337DBB20419A9999791E1E59419A99999979BB2041000000601F1E5941000000006EBB2041333333F31F1E59413333333358BB2041333333D31F1E59413333333348BB20419A999979241E5941CDCCCCCC45BB2041CDCCCCAC261E59416666666647BB2041666666A62B1E59419A9999997BBB2041000000C02D1E5941CDCCCCCC92BB2041666666A62D1E594100000000AFBB2041000000202D1E5941CDCCCCCCD3BB2041333333F32B1E59410000000013BC204133333353291E59419A99999926BC2041CDCCCC0C281E59419A9999992FBC2041000000E0271E59419A9999996EBC2041CDCCCCEC2B1E59419A9999997CBC2041333333D32C1E594133333333D6BC2041666666C6361E59419A99999914BD2041000000A03F1E5941CDCCCCCC25BD20419A999999431E5941333333332BBD2041000000A0471E5941CDCCCCCC2FBD2041CDCCCC4C491E5941666666663CBD2041666666C64A1E59419A9999994FBD2041333333534F1E59416666666657BD20419A999979501E59419A99999974BD20419A999919531E5941333333338EBD204100000040541E5941666666669BBD204100000060541E5941CDCCCCCCB3BD2041CDCCCC0C531E594100000000C3BD204166666646531E5941CDCCCCCCE3BD20419A9999D9571E594133333333FFBD2041000000C05A1E5941666666660ABE2041333333B35C1E59410000000015BE2041CDCCCC8C5F1E59416666666620BE2041000000C0671E59413333333327BE204133333373691E59419A9999993DBE20419A9999596C1E5941CDCCCCCC57BE20419A9999B96D1E59416666666661BE2041333333B36E1E59413333333366BE204100000040711E5941CDCCCCCC67BE2041000000C0721E5941CDCCCCCC6FBE204100000000761E5941CDCCCCCC80BE204166666646781E5941CDCCCCCC99BE2041000000A0791E594100000000C3BE204133333373791E594133333333D7BE2041333333137A1E594100000000FCBE2041CDCCCC6C7A1E59416666666627BF2041000000807B1E59413333333339BF20419A9999797B1E5941333333336DBF2041CDCCCC2C7A1E59416666666693BF2041CDCCCCAC791E594166666666A9BF2041000000207A1E594133333333BBBF2041CDCCCC0C7B1E594133333333D7BF2041666666067E1E594100000000E2BF2041333333B37F1E594166666666EABF2041000000C0811E594166666666FDBF204133333353881E59419A99999921C02041666666C6891E5941333333334AC02041666666868D1E5941333333336FC02041CDCCCC2C921E5941CDCCCCCCC9C02041CDCCCCCC9F1E5941CDCCCCCCD7C02041333333B3A21E594166666666F1C0204100000060AA1E5941CDCCCCCCFDC02041000000C0AC1E5941333333330BC120419A999939AE1E59419A99999958C1204166666666B41E59413333333385C120419A999939BD1E59419A9999999BC1204100000040C01E594100000000A1C120419A9999B9C01E594166666666DFC120419A999919C31E5941CDCCCCCC15C2204100000040C61E59419A999999B1C22041000000C0D51E5941CDCCCCCCCAC2204100000000D81E594100000000C4C22041333333D3D91E594133333333FBC2204100000020E61E5941333333338FC32041000000E0FF1E594133333333F4C32041000000C00F1F59419A99999939C4204166666646181F594166666666DDC42041CDCCCC8C2D1F59419A99999966C52041666666A6441F594133333333F0C5204100000000571F59416666666668C62041666666A6641F5941CDCCCCCC7BC62041333333F3661F59416666666693C62041CDCCCC2C691F59410000000001C7204166666686721F59410000000023C72041333333B3761F59413333333331C72041CDCCCC6C781F59413333333342C72041CDCCCCAC791F5941333333332BC82041CDCCCCCC831F5941333333334CC820419A9999D9851F59416666666695C82041CDCCCC2C891F59416666666697C8204166666646891F594166666666A0C82041000000408B1F594133333333A5C82041CDCCCC6C8C1F5941CDCCCCCCACC82041000000E08C1F5941CDCCCCCCB9C82041000000408D1F5941CDCCCCCCC6C820419A9999798D1F594166666666C8C82041CDCCCC2C8E1F594100000000C9C82041000000A08E1F594166666666CAC82041000000C08F1F59419A999999DAC820419A999959921F594133333333EAC820419A999919931F59416666666600C9204100000020931F5941CDCCCCCC63C9204166666686991F5941CDCCCCCCD3C9204100000020AD1F5941CDCCCCCC0CCA2041333333B3BA1F5941000000001ECA204100000020D21F5941CDCCCCCC1CCA2041000000C0E61F594133333333FAC92041666666860320594166666666D7C920416666664620205941CDCCCCCCA8C920419A9999994220594100000000CDC92041333333D3412059416666666601CA2041CDCCCC4C402059410000000063CB2041000000A0332059419A999999B6CB20419A999979302059413333333333CC20419A9999F92A205941000000009FCC204133333373252059413333333334CD2041000000801E205941000000005ECD2041666666061D20594166666666D4CD2041333333131A2059413333333313CE2041666666E6182059419A9999994FCE20416666660618205941666666667ACE2041CDCCCC6C1720594166666666A7CE2041000000801620594100000000E2CE2041666666E61320594133333333F2CE2041000000A013205941000000000ECF204133333333142059419A99999974CF20416666666617205941CDCCCCCCC6CF2041000000A01A20594133333333F2CF20419A9999D91B2059416666666676D020419A9999191D205941000000009ED02041333333F31C20594100000000B6D02041000000801C20594100000000C0D02041333333131D20594100000000CDD020419A9999D91D20594133333333DAD02041CDCCCC2C1F2059419A999999E2D02041666666A62020594100000000E7D020419A9999D9222059419A999999E7D020410000008027205941333333339ED22041000000E026205941CDCCCCCCC4D32041000000A022205941CDCCCCCC1ED52041CDCCCC8CFF1F594133333333B0D52041666666A6F31F5941333333332DD62041CDCCCC6CE91F594100000000ECD720419A999919CA1F59419A9999993BD82041666666C6C31F59413333333303D9204133333313C11F5941000000006BD920419A9999F9BE1F5941333333336CD92041666666E6BE1F594166666666E7D9204133333373B91F59410000000019DA20419A999939B71F5941666666661FDA20419A9999D9A91F59416666666619DA2041CDCCCCEC9A1F59413333333311DA20419A9999798D1F594100000000F2D92041666666A67B1F5941CDCCCCCCAFD92041333333D3671F5941333333335CD9204133333353571F5941CDCCCCCC57D920419A999919561F59410000000053D9204166666606561F5941333333333FD92041333333B3551F59410000000031D9204100000060521F59410000000029D92041CDCCCC4C4E1F59410000000027D92041333333334A1F5941CDCCCCCC18D92041666666E6421F59413333333320D8204166666626061F59419A999999D2D7204133333393E01E59419A999999B9D7204133333373CE1E59410000000085D720419A999939AA1E59416666666648D7204133333333951E59413333333386D72041CDCCCC2C8C1E59419A999999EFD72041000000C0801E5941666666667ED82041333333B3731E59419A99999925D92041333333935E1E59419A99999927D92041666666665E1E594166666666C7D92041000000004F1E5941CDCCCCCCB5DA2041CDCCCCCC381E594166666666EFDA2041333333B33D1E59410000000034DC2041333333333C1E5941000000008EDC20419A9999D93D1E59413333333324DD204133333333411E59410000000074DD2041333333D3401E594166666666F3DD2041333333133E1E59419A99999954DE2041CDCCCC0C3B1E59416666666684DE204166666626411E5941333333332BDF2041666666C6381E5941CDCCCCCCD9DE2041666666E6221E59416666666688DF204100000040021E59419A99999983DF2041CDCCCC0C011E59419A9999997EDF2041666666E6FF1D59419A99999977DF2041666666C6FE1D59413333333371DF2041666666A6FD1D5941000000006DDF2041CDCCCC2CFC1D59416666666669DF20419A9999D9FA1D59419A99999966DF204100000060F91D59410000000064DF204100000040F81D59410000000060DF204166666686F61D59419A9999995CDF204133333373F51D59419A99999958DF204166666606F41D59419A99999954DF20419A9999D9F21D59416666666651DF2041666666A6F11D5941666666664DDF204166666666F01D5941333333334ADF2041333333F3EE1D5941CDCCCCCC47DF2041000000E0ED1D59410000000045DF2041000000C0EC1D59416666666641DF204166666686EB1D5941CDCCCCCC3FDF2041CDCCCCACEA1D5941666666663FDF2041333333D3E91D5941CDCCCCCC3EDF2041333333D3E81D5941333333333DDF2041CDCCCC6CE71D59419A99999939DF204100000020E61D5941CDCCCCCC34DF2041666666A6E41D5941666666662FDF204166666666E31D59419A9999992BDF204133333333E21D59416666666628DF2041CDCCCCECE01D5941CDCCCCCC25DF2041CDCCCC8CDF1D59416666666623DF204133333373DE1D5941CDCCCCCC1FDF2041333333D3DC1D5941000000001BDF20419A9999B9DB1D59416666666615DF204133333373DA1D5941666666660FDF20419A999959D91D5941666666660ADF20419A999979D81D59416666666605DF204133333393D71D5941CDCCCCCCBFDE204133333333D81D5941CDCCCCCCA8DE204100000060D21D59419A99999980DE2041CDCCCC6CCD1D5941CDCCCCCC55DE204133333353C71D5941CDCCCCCC65DE204166666686AF1D59419A9999996CDE204133333373B71D5941333333337ADE2041000000E0BD1D59416666666602DF204166666606D11D59416666666616DF2041000000E0D11D594133333333A1DF20419A9999F9B81D5941666666667CE02041666666C6AE1D59416666666619E1204100000020841D594133333333CAE1204100000040581D594166666666A8E220419A9999D9381D594100000000BDE2204166666606341D5941CDCCCCCCD1E220419A999979301D594100000000D3E2204166666646301D594166666666EBE22041CDCCCC8C2D1D594166666666FBE22041000000802B1D59413333333321E32041CDCCCCEC271D5941000000003DE3204166666666251D5941CDCCCCCC5DE32041CDCCCC4C221D5941000000007CE32041CDCCCC6C201D5941666666669FE32041666666C61E1D594100000000D7E32041CDCCCC2C1C1D59410000000012E4204100000020181D59413333333355E4204133333393131D5941CDCCCCCC8EE42041000000C00F1D594133333333B9E42041333333130D1D594100000000CCE42041333333530C1D594166666666F7E42041000000C00B1D59413333333313E52041333333730B1D5941333333332DE52041CDCCCC6C0A1D5941CDCCCCCC58E5204166666606081D59413333333399E5204133333313041D594100000000B8E5204100000080021D5941CDCCCCCCCFE52041CDCCCCCC011D594166666666F5E5204133333333011D59419A9999990DE620419A999999001D5941000000001FE620419A9999D9FF1C59419A9999993CE6204166666606FE1C5941000000009DE62041333333B3F71C59416666666603E72041CDCCCC4CF11C5941CDCCCCCC52E72041CDCCCC6CEC1C59419A99999977E7204133333333EA1C59413333333386E720419A9999D9E91C59416666666694E72041CDCCCC8CE91C59419A999999BBE7204100000060E91C594133333333DFE72041CDCCCC8CE91C5941CDCCCCCCE5E72041CDCCCC6CE71C59419A999999F8E72041CDCCCC8CE41C5941000000000FE820419A9999F9DC1C59413333333312E8204100000000DB1C59413333333315E8204100000000D81C5941CDCCCCCC12E82041CDCCCC8CC71C59419A99999912E820419A999939C31C59416666666613E82041000000E0C01C5941CDCCCCCC05E8204133333313A51C594100000000FFE720419A999979A01C594100000000F2E72041CDCCCC8C9D1C594133333333DEE72041000000209B1C594166666666A2E720419A9999398D1C59410000000087E720419A9999F9881C59413333333368E72041CDCCCCEC801C5941CDCCCCCC47E72041000000207A1C5941CDCCCCCC2EE720419A999939751C5941333333330AE72041CDCCCCCC6F1C5941CDCCCCCCE6E62041000000206B1C594133333333BEE6204100000060661C5941333333339CE62041CDCCCC2C611C59410000000021E62041CDCCCCEC491C594100000000D6E52041666666463C1C5941333333339CE5204166666666311C59419A9999998DE52041000000C02F1C59419A9999995BE52041CDCCCC0C2D1C59419A9999992BE5204133333373281C5941CDCCCCCCEEE42041333333F3211C5941666666668AE42041666666E6121C59413333333354E420419A9999590D1C59410000000046E42041CDCCCCCC0B1C5941CDCCCCCC3AE42041CDCCCCEC061C5941333333331DE42041CDCCCCAC001C5941CDCCCCCCE7E32041000000C0F91B5941666666668CE4204166666686F11B59419A999999D9E4204166666606E81B59410000000054E52041666666E6D31B594133333333D5E520419A999919D81B5941333333333FE620419A999999D81B59413333333378E62041666666C6D01B594100000000C7E62041CDCCCC0CE01B594100000000A8E72041666666260D1C5941333333336FE8204166666686451C594100000000AFE82041000000C0451C59413333333340E92041666666866A1C594100000000EDE92041000000E0561C594133333333FCE92041CDCCCC2C551C5941666666665EEA2041666666064A1C594133333333FBEA2041CDCCCC2C4E1C59413333333370EB204100000040511C5941000000005CEB2041666666661D1C59419A99999980EB204166666646171C59419A999999D8EA2041CDCCCC6C071C59413333333349EA2041CDCCCC4CEE1B594166666666EEE9204100000000CE1B59419A999999EEE920419A999919CD1B59419A999999EBE9204133333333CC1B59419A999999D2E9204166666606CA1B59419A999999C8E92041666666A6C81B594166666666BAE920419A9999F9C51B594133333333ACE920419A9999F9C11B5941333333339FE92041CDCCCC4CBF1B59416666666676E92041000000A0BA1B59419A99999957E9204166666626B61B59419A99999942E920419A999939B21B59410000000038E92041CDCCCC0CAF1B59413333333333E92041666666E6AA1B59413333333332E92041000000009D1B59410000000029E92041000000009A1B59413333333314E9204100000080951B5941CDCCCCCC08E92041333333538E1B594100000000E5E82041CDCCCC4C7C1B5941CDCCCCCCE5E82041000000A0791B59419A999999F5E82041CDCCCCAC751B594133333333F6E82041CDCCCC6C731B59419A999999EFE82041666666066F1B594166666666ECE82041CDCCCC0C5E1B59419A999999E9E82041666666065A1B594166666666E4E82041666666C6561B5941CDCCCCCCD2E8204166666686511B594166666666D5E82041333333734E1B5941CDCCCCCCBBE82041333333D3471B59419A999999B9E820419A9999F9451B5941CDCCCCCCBCE8204133333393411B5941CDCCCCCCB9E82041666666463F1B594166666666ACE82041000000E0391B59410000000090E820419A9999D9301B5941CDCCCCCC82E82041000000A02A1B5941CDCCCCCC81E8204166666686271B5941666666665AE820419A9999B9161B59410000000046E82041000000C0111B5941CDCCCCCCB5E72041CDCCCC4C0C1B594133333333AEE72041333333D30A1B59419A99999984E720419A999959031B5941000000007EE72041CDCCCC0C011B59413333333373E720419A999959FF1A5941CDCCCCCC6CE72041CDCCCC2CFE1A5941CDCCCCCC60E72041CDCCCC4CFC1A59419A99999950E720419A9999B9FA1A59419A9999993EE72041CDCCCCECF81A59419A99999924E72041CDCCCCCCF61A59419A999999EAE6204166666646F11A5941CDCCCCCCDAE62041666666C6EF1A59419A999999D0E62041666666A6EE1A594166666666C6E6204166666666ED1A594100000000BEE6204133333373EC1A594166666666B2E62041CDCCCC4CEB1A59419A999999ABE6204166666686EA1A5941CDCCCCCCA1E6204133333313E91A5941CDCCCCCC9BE6204133333313E81A59416666666693E62041000000A0E61A59416666666689E620419A999919E51A59416666666680E62041666666A6E31A59419A9999996EE62041333333D3E01A5941CDCCCCCC62E6204166666686DE1A59410000000059E62041CDCCCCCCDC1A59419A99999950E6204133333353DB1A59410000000042E62041CDCCCC4CD81A5941666666663CE620419A9999D9D61A59413333333336E62041CDCCCC2CD51A59413333333310E620419A999979C61A5941333333330BE6204133333333C41A5941CDCCCCCC07E620419A999999C21A59419A99999900E62041333333D3BE1A594166666666FCE52041CDCCCC4CBD1A59419A999999F4E520419A999939BB1A594133333333ECE5204100000040B91A594166666666E6E52041CDCCCCACB71A594133333333E1E5204100000020B61A594100000000DAE520419A999999B31A59419A999999D3E5204133333313B11A5941CDCCCCCCCBE52041CDCCCC0CB01A594133333333C3E520419A999919AF1A594100000000BDE5204100000000AE1A5941CDCCCCCCB7E5204166666686AC1A594133333333AAE52041CDCCCCCCA91A594166666666A3E5204133333393A81A5941333333339DE52041CDCCCC0CA71A59413333333397E5204100000000A41A59419A99999994E520419A999959A21A5941CDCCCCCC90E52041666666A6A01A59413333333388E52041CDCCCC2C9F1A5941666666667CE520419A9999799D1A59416666666671E520419A9999F99B1A59419A99999966E520419A9999599A1A59419A9999995EE52041333333D3981A59410000000057E5204133333313961A59410000000055E52041CDCCCC4C941A59410000000053E5204166666646921A59416666666643E52041000000E08F1A5941CDCCCCCC39E52041666666468E1A5941666666662FE52041000000A08B1A5941333333332DE520419A9999D9891A5941333333332EE52041CDCCCC2C871A59419A99999922E520419A999959841A5941CDCCCCCC16E520419A999939821A5941CDCCCCCC05E52041333333337F1A594133333333E8E420419A9999D9771A594166666666B6E420419A9999996C1A594100000000A2E42041CDCCCC8C661A59419A99999990E42041CDCCCC8C661A5941000000007FE42041000000C0651A59416666666674E42041333333B3631A59419A99999961E42041CDCCCC2C5E1A59410000000043E4204166666626571A59413333333333E4204166666686541A59419A9999991AE4204166666606501A59413333333309E42041000000204D1A594166666666DCE32041333333D3461A5941CDCCCCCC84E32041666666263B1A59419A99999959E3204100000020331A59413333333300E3204166666606281A594133333333F0E220419A9999D9261A594166666666A7E220419A999939231A5941CDCCCCCC85E22041333333F3201A59419A9999994FE22041666666061A1A594166666666DDE12041000000400D1A5941CDCCCCCCBDE12041000000000B1A59413333333376E120419A9999F9071A59410000000056E1204133333393051A5941CDCCCCCC38E12041CDCCCCCC021A59419A999999F6E02041CDCCCC2CFB1959419A999999C0E02041CDCCCC2CFA195941333333339AE02041333333F3F81959419A99999972E0204133333333F8195941000000005EE0204166666686F71959410000000046E02041CDCCCC0CF61959413333333333E0204100000000F419594166666666E1DF204100000060E919594166666666C6DF20419A999959E6195941CDCCCCCCAEDF20419A9999B9E819594166666666A0DF2041333333F3E81959410000000081DF2041CDCCCC4CE71959416666666662DF2041CDCCCCACE41959410000000056DF2041CDCCCC0CE3195941333333334BDF2041000000E0E01959416666666645DF204100000060DB1959419A9999993ADF2041333333F3D71959419A9999993ADF204100000080CB195941CDCCCCCC44DF2041CDCCCC4CC8195941CDCCCCCC5FDF204133333353C41959416666666684DF2041333333F3B919594166666666B0DF20419A999919B11959419A999999BADF20419A999959A819594100000000CFDF2041CDCCCC0CA019594133333333D2DF20419A9999B99D1959419A999999D1DF2041666666669B19594100000000CCDF2041666666069819594100000000AFDF2041000000E08D195941666666668BDF20416666660687195941000000008ADF20419A9999B986195941666666664DDF2041CDCCCCEC7D1959410000000002DF20419A999919721959416666666681DF2041CDCCCC6C661959413333333359DF2041666666A66219594133333333BADF2041000000E05419594166666666C8DF20416666666650195941CDCCCCCC08E0204166666626481959413333333362E020419A9999D93F195941CDCCCCCC03E120419A9999F9331959410000000044E12041666666862A195941666666668EE12041CDCCCCAC2119594166666666C2E120419A9999D918195941CDCCCCCC20E220410000002011195941CDCCCCCC68E22041000000600C19594133333333CAE220413333335309195941000000001AE32041CDCCCCCC021959413333333320E32041CDCCCC2CF41859419A99999996E42041CDCCCCEC9A1859419A99999996E42041666666E6861859419A99999997E42041666666C6541859419A99999997E420413333331351185941CDCCCCCC97E42041666666C64A1859410000000098E4204133333373471859419A99999998E4204133333353251859419A99999998E420419A9999B921185941333333339AE42041CDCCCC8C0D185941333333339AE4204166666666F9175941000000009EE42041333333F3E2175941CDCCCCCCCAE4204100000040DC175941000000000FE52041333333B3C2175941000000003BE5204166666626B31759413333333362E520419A999919A71759416666666666E52041666666869A175941666666666EE520419A9999197E1759410000000074E5204100000000621759419A99999970E520419A99995953175941666666662BE52041000000403A17594100000000BBE42041CDCCCCAC1617594133333333AEE42041333333B30A17594133333333AFE42041333333F3FB16594100000000B0E420419A9999D9F316594100000000B3E42041CDCCCCACEE165941CDCCCCCCB9E42041CDCCCC2CE9165941CDCCCCCCC5E42041666666A6E416594100000000CCE42041666666E6E116594166666666D3E42041666666C6DE165941CDCCCCCCEEE42041333333B3D41659410000000003E4204100000080F2165941CDCCCCCCCEE32041CDCCCC2CF51659419A999999AFE220410000000004175941666666668DE22041CDCCCCCC051759419A99999953E22041333333D3081759413333333336E22041000000E0051759410000000008E2204166666606F8165941CDCCCCCCB1E120419A999979E1165941CDCCCCCCA6E12041666666C6DE165941000000008CE12041666666A6D81659410000000083E120419A999999D61659410000000077E1204166666666D11659416666666664E1204133333393CB1659416666666653E1204166666686C71659416666666637E12041333333F3C21659419A99999917E120419A999919BF1659419A999999F5E02041CDCCCC4CBA165941CDCCCCCCBFE02041666666E6B01659419A99999990E020419A9999F9A71659413333333388E0204166666666A51659413333333380E02041CDCCCC0C9E1659416666666679E02041CDCCCC8C9B1659419A99999962E02041666666E6961659410000000056E02041CDCCCC6C951659416666666652E0204100000020951659419A999999F5DF2041666666668D165941CDCCCCCC5CDE2041CDCCCC2C68165941CDCCCCCC30DE2041CDCCCC4C631659419A99999902DE2041333333136016594133333333D7DD2041000000005B16594166666666B8DD20410000004056165941CDCCCCCC7CDD2041666666664A165941CDCCCCCC63DD2041000000A0431659410000000053DD20419A999959401659413333333338DD2041666666C63C165941666666661BDD2041CDCCCC4C381659419A999999D1DC2041333333732B16594133333333B2DC204133333393261659410000000091DC2041000000A0201659413333333363DC204133333333171659413333333350DC204133333373141659413333333343DC20416666664613165941CDCCCCCC3ADC2041333333D3111659419A9999991FDC20410000006008165941333333331CDC20419A9999B9EB15594166666666BDDB204166666626E815594133333333D5DA204100000060E01559419A99999973DA204133333373DA155941000000005BDA2041333333B3D9155941333333332CDA2041000000E0D815594100000000BFD9204133333313CE1559413333333367D92041CDCCCC8CC4155941000000002ED920419A9999F9BE1559419A999999D9D82041CDCCCCCCB715594166666666D1D8204166666626B71559419A999999B9D82041666666C6B51559416666666621D8204100000060AF15594100000000F4D72041333333D3AD155941CDCCCCCCB2D720419A9999F9AC155941CDCCCCCC75D72041666666E6AB1559413333333351D72041CDCCCC4CAB155941000000002ED7204100000020AA1559419A99999911D72041666666A6A815594100000000E8D62041CDCCCC8CA5155941666666667CD620419A9999999D1559416666666604D62041CDCCCCAC951559419A999999AAD520419A9999F98F1559419A9999993ED52041000000A08915594166666666DCD420413333337383155941000000007ED42041666666A67E1559413333333350D42041666666E67B155941333333332CD42041666666867815594166666666D7D32041000000C06E15594133333333C1D32041333333336C1559413333333384D320419A9999D95F155941333333337BD320419A9999395C155941333333337AD32041CDCCCC0C5A1559419A9999997AD32041CDCCCC0C58155941666666667CD32041CDCCCC2C561559416666666682D320419A9999F9541559416666666681D32041666666E6541559410000000069D320410000002053155941CDCCCCCC2ED32041CDCCCC8C4D15594100000000E3D220416666666643155941CDCCCCCCA9D22041CDCCCC8C3C155941CDCCCCCC7AD220410000006038155941666666665AD22041666666E6351559419A99999955D2204100000000321559410000000050D22041333333D32C1559419A99999943D22041666666261A155941666666663CD220419A999999101559419A9999993AD22041CDCCCC4C0E1559419A9999993AD22041333333330E1559419A9999992DD22041CDCCCC6CFE1459410000000019D2204166666666E91459410000000015D22041666666C6E11459419A99999917D220419A999939DD1459413333333320D2204166666626D9145941CDCCCCCC30D2204166666606D51459410000000079D220419A999919C9145941CDCCCCCC84D22041CDCCCC2CC6145941CDCCCCCC8DD22041CDCCCC2CC3145941000000009ED220419A9999D9BA1459419A9999992ED1204100000080C214594133333333FFCF204133333373C91459419A99999979CF20419A999959CF145941CDCCCCCC3BCF20419A999999C4145941666666669ECE204100000020AA1459419A9999998CCE2041CDCCCC0CA71459419A99999921CE2041666666A69414594166666666E5CD2041333333D3891459419A99999998CD20416666660679145941CDCCCCCC89CD204100000000761459410000000089CD204166666686721459413333333396CD2041CDCCCC8C6714594100000000A8CD2041333333735A14594133333333B0CD2041CDCCCC4C4814594100000000A1CD2041666666463A145941CDCCCCCC81CD2041333333D3281459419A99999977CD20419A999919251459416666666665CD20413333339318145941CDCCCCCC5ACD2041333333D3131459410000000056CD2041000000200F1459419A99999951CD20419A9999F9FB1359416666666656CD2041CDCCCCCCF9135941CDCCCCCC67CD2041CDCCCC8CF61359416666666677CD204100000080F21359416666666683CD20419A999959EB1359413333333385CD2041CDCCCC6CE71359419A99999983CD2041000000E0DD135941CDCCCCCC7BCD2041000000A0D5135941333333337ECD2041333333D3D11359419A9999997DCD204166666626CD135941CDCCCCCC02CD204166666626D91359419A9999996ECC2041CDCCCC6CDC13594100000000D6CB20419A9999B9DF13594100000000C7CB2041333333D3D4135941CDCCCCCCADCB20419A9999B9D1135941CDCCCCCC86CB204133333393D0135941CDCCCCCC00CB204100000060D61359419A99999985CA204166666646D81359416666666673CA20419A9999D9E01359413333333354CA20419A9999B9E8135941333333333FCA2041000000A0F51359410000000052CA20419A9999F9F8135941333333335ACA204100000040FB135941CDCCCCCC6DCA2041CDCCCC8C031459419A99999977CA2041CDCCCC8C06145941000000006ECA2041000000000A1459419A99999959CA2041333333D3141459413333333383C92041000000C00C1459416666666658C92041CDCCCCEC0F1459419A999999EDC82041666666A61B145941CDCCCCCCBCC8204166666666201459416666666664C8204166666646271459413333333335C82041666666C62914594133333333A3C72041CDCCCC2C2F1459419A9999993DC72041CDCCCC6C33145941CDCCCCCC1AC72041666666863514594133333333D8C52041666666A67114594133333333D7C520419A9999597C145941CDCCCCCC28C620419A9999B982145941CDCCCCCC13C620419A999979881459419A999999F3C520419A9999399E14594133333333EDC52041666666469E145941CDCCCCCCC1C52041333333139F14594166666666ADC52041666666069F1459419A99999973C52041333333939D1459419A99999941C520419A9999599E1459416666666621C52041333333F39D14594133333333FDC42041CDCCCCCC9C14594100000000EAC42041666666C6A6145941333333331DC5204133333333B81459419A99999909C520419A999979BE1459419A999999BAC4204166666606CB14594166666666DEC4204100000040D014594133333333E4C42041000000C0D114594166666666EAC420419A9999B9D614594166666666F0C420419A999939D8145941CDCCCCCC07C52041CDCCCCCCDB14594100000000F8C42041333333B3E2145941CDCCCCCC64C4204133333333F814594166666666DCC32041CDCCCC8C0615594133333333DFC320419A9999590815594133333333E4C32041333333D309155941CDCCCCCCF2C32041000000C00B1559419A999999F7C32041000000E00C155941CDCCCCCC18C420413333337319155941CDCCCCCC1AC42041CDCCCC2C1A1559410000000031C42041CDCCCC4C1D1559419A9999993DC42041000000A01F155941000000004DC4204100000020251559416666666652C420419A99999927155941333333335AC4204166666666291559413333333375C42041000000602B15594166666666E6C42041CDCCCCEC1A155941CDCCCCCC88C52041000000802D1559416666666643C52041CDCCCCCC331559419A999999F0C42041333333D33D1559410000000000C520419A99997940155941CDCCCCCC07C520419A9999D9421559413333333311C520416666664645155941666666661DC520419A99991947155941333333332BC5204100000040481559413333333300C520419A9999D954155941333333332EC52041333333335D155941666666666CC52041CDCCCC2C731559419A999999E0C32041CDCCCCCC9D15594133333333E5C32041333333739F15594133333333E7C320419A999999A115594166666666E7C32041666666E6A415594100000000E1C3204166666666A915594100000000D5C3204166666666AE15594166666666BBC32041CDCCCC4CB215594166666666BAC3204166666606C51559419A9999998BC32041666666E6C81559410000000083C32041000000A0DB1559416666666671C3204166666666E21559416666666657C320419A9999B9E615594133333333D4C22041CDCCCC2CE91559410000000075C22041333333B3001659416666666653C320419A9999990B1659419A999999B8C32041666666C6131659416666666609C4204133333333201659413333333355C420419A999979251659410000000008C420419A999979311659419A999999B3C32041333333F331165941CDCCCCCC5AC3204166666606321659419A99999936C32041333333932E16594166666666F3C22041666666A62E16594133333333B7C22041666666C6351659419A999999FAC12041333333B3481659419A999999F3C12041000000E05516594100000000C2C12041666666065E165941333333330DC12041666666C67716594166666666E0C02041CDCCCC2C77165941CDCCCCCCB3C02041333333337B16594166666666CAC02041CDCCCC2C7C16594100000000DFC02041000000E07D16594166666666E9C020419A9999797F165941CDCCCCCCEDC02041000000208016594100000000F4C020419A99997981165941000000001BC12041CDCCCC2C8A165941CDCCCCCC21C12041CDCCCC2C8C1659413333333327C120419A9999D98E1659419A9999992EC12041CDCCCCEC911659419A9999993BC12041000000A094165941CDCCCCCC4FC120419A999939971659416666666693C12041CDCCCCAC9D165941CDCCCCCCDDC120419A999939A61659416666666614C2204100000020AD165941CDCCCCCCE1C22041666666C6C61659419A999999FCC1204133333353E21659410000000065C120419A999939F51659413333333314C120419A999919FD16594100000000CDC02041000000C00517594166666666A1C0204166666626081759419A99999943C0204133333313071759419A99999911BF2041000000A00617594166666666EEBD2041666666260A1759419A999999E2BD204100000000061759419A999999DCBD2041000000800417594133333333B2BD2041CDCCCC0CFA1659419A9999996FBD204100000040EA1659416666666600BD20419A999979EE1659419A999999DFBC204166666686EF16594166666666C9BC2041CDCCCCACEF1659416666666634BC2041333333F3ED165941000000009EBB20419A9999F9EB165941333333333EBB2041333333B3EA165941CDCCCCCC33BB204166666606E8165941333333332CBB2041333333D3E41659413333333322BB20419A999939E2165941666666661BBB2041CDCCCCACD71659410000000023BB204166666666CF165941000000006EBA2041CDCCCC0CC7165941666666663FBA20419A999959CE1659410000000014BA204166666646D31659419A999999FCB92041666666E6D2165941CDCCCCCCBEB920419A999959DB1659410000000052B9204133333313E31659419A99999913B9204100000080E51659419A999999E6B8204166666646E8165941CDCCCCCC4BB9204133333353F9165941CDCCCCCC74B920416666668600175941666666668FB92041666666C60D1759410000000015BA2041CDCCCC2C0F1759419A99999953BA20419A9999791017594166666666CABA20419A999979131759419A9999994DBB20419A9999B913175941333333335FBB20416666666618175941CDCCCCCCBFBB2041CDCCCC8C2E1759410000000020BC2041000000203B175941CDCCCCCCEDBB2041CDCCCC6C51175941333333337EBB2041333333B35A17594166666666EABA2041333333537B17594133333333D7BA20419A9999598517594166666666EBBA20413333331389175941CDCCCCCC27BB2041000000408F175941CDCCCCCC60BB20419A9999799617594166666666BABA20419A9999F9B91759413333333331BA204100000020BB175941000000005FBA2041CDCCCCCCC91759419A99999943BA204133333373D01759410000000033BA204100000080D71759416666666621BA204133333313DE1759419A99999921BA204133333333E11759419A99999917BA204166666606E6175941666666660EBA2041CDCCCCECEA1759413333333302BA204133333333EE17594100000000F9B9204166666606F117594100000000E1B8204166666646F6175941333333339BB820419A999959F61759410000000054B82041CDCCCCACE3175941CDCCCCCC3AB820419A999919E717594100000000CBB72041666666C6F1175941CDCCCCCC7EB7204133333353F61759419A99999921B720419A999919FB17594100000000FEB62041333333330118594166666666BBB620419A999979201859413333333311B620413333337320185941000000001DB62041000000E02E18594100000000F3B520419A9999B92F185941CDCCCCCCCDB52041333333531618594166666666A5B520419A9999191018594133333333F6B42041333333330A18594133333333AEB420416666668607185941CDCCCCCC56B42041000000A0071859419A99999930B42041000000E0071859416666666630B420419A99999906185941000000002FB42041CDCCCC8C031859419A9999992AB4204166666606FA1759413333333373B3204100000080E617594133333333CBB22041CDCCCC6CD81759419A999999A5B2204166666626D5175941000000001FB22041CDCCCCCCB817594166666666CEB1204100000080A81759413333333349B12041CDCCCC8C8B1759419A99999907B12041CDCCCCCC8117594133333333FEB02041CDCCCCCC7E1759419A999999B5B02041666666E6781759410000000063B02041333333D37217594133333333AFAF2041CDCCCC8C651759419A99999936AF2041666666C65C175941333333339EAE2041CDCCCCCC511759416666666644AE2041333333534B1759419A999999A3AD2041CDCCCC0C40175941000000005DAD20419A99993958175941CDCCCCCC54AD2041333333B373175941000000005DAD2041CDCCCCCC7C175941CDCCCCCC8BAD2041000000C095175941CDCCCCCC52AD204166666666B61759419A999999FFAC2041CDCCCC4CC6175941CDCCCCCC14AD204133333373CC1759410000000072AD20419A9999F9E5175941CDCCCCCCD6AD20419A999999F11759419A99999950AE2041CDCCCC6CF2175941CDCCCCCC9DAE2041CDCCCC0CF5175941000000005DAE20416666666601185941333333331AAE20419A9999790E185941CDCCCCCCB5AD20419A99993922185941CDCCCCCC63AD20419A999959321859419A99999909AD2041666666264418594133333333D2AC20419A9999794E18594166666666A2AC20419A9999F957185941666666664DAC2041CDCCCC6C6818594100000000F5AB20419A999999791859416666666693AB2041CDCCCCEC8C185941666666665DAB2041CDCCCC4C97185941CDCCCCCC36AB20419A9999D99E1859419A9999990DAB204166666606A71859416666666605AB2041666666A6A8185941	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	01010000206A0800005E61A2702FC82041666666C6061A5941	870060000	Z	Azat-le-Ris	8700600	87006	87	75	56
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	01010000206A0800002CED42F6B82321419A9999D948045941	870070000	Z	Balledent	8700700	87007	87	75	12
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	01010000206A080000A185668A13DD2041CDCCCCACBE145941	870080000	Z	La Bazeuge	8700800	87008	87	75	10
01060000206A080000010000000103000000010000005E02000033333333AC862241666666C6B7DD584100000000D48622419A999979C2DD5841000000004C872241666666C6D8DD58419A9999997C872241333333B3D9DD5841333333331088224166666666CFDD5841CDCCCCCC41882241CDCCCC6CCCDD584133333333CD892241CDCCCC6C23DE58419A9999999E8A22419A99999937DE5841666666662D8B22416666662644DE5841CDCCCCCC0D8C2241666666C658DE5841CDCCCCCCFC8C2241333333336EDE5841000000007C8D2241666666A678DE5841CDCCCCCC838D2241CDCCCC4C7ADE584133333333C48D22410000008085DE5841333333332D8E2241000000E095DE584133333333B98E2241CDCCCC2CACDE5841CDCCCCCC028F2241CDCCCC2CB7DE584133333333118F22419A999959B9DE5841666666661A8F2241333333D3BEDE5841000000002C8F2241CDCCCC8CCADE584166666666358F224100000080D0DE58419A999999418F2241000000C0D6DE584133333333538F224133333353E2DE5841CDCCCCCC6B8F22419A999959EEDE584133333333748F224166666626F3DE58419A999999868F224100000000FDDE5841333333338D8F2241CDCCCC6C01DF5841CDCCCCCCA88F22419A99993910DF584166666666DA8F22416666666629DF584133333333E08F2241CDCCCCAC2BDF58419A999999E08F2241000000E02BDF5841CDCCCCCCFB8F22413333337336DF58410000000016902241000000A042DF5841CDCCCCCC269022419A99997949DF58416666666630902241000000804FDF5841CDCCCCCC2E9022419A99999952DF5841CDCCCCCC279022410000004056DF5841CDCCCCCC17902241666666065DDF584100000000079022419A99999962DF5841CDCCCCCCF38F2241333333136ADF584133333333E38F2241CDCCCC0C71DF58419A999999E08F22413333333375DF584166666666DF8F22419A9999B979DF584166666666DF8F22419A9999F97EDF584166666666DE8F2241000000E083DF5841CDCCCCCCF18F22419A99997988DF58410000000006902241CDCCCCCC8ADF5841CDCCCCCCC99022419A99993992DF58419A999999E29022419A99993998DF5841CDCCCCCC39952241CDCCCC0CBFDF584166666666589522419A999979C1DF5841333333338F952241CDCCCCECC5DF58419A999999EA9522419A9999B9D1DF5841333333338A972241666666A60AE058419A999999AC972241CDCCCCCC0BE058419A99999948982241CDCCCC6C0BE05841CDCCCCCC35992241CDCCCCAC08E0584100000000FF9922410000006008E0584133333333479A22416666664608E05841666666666B9A2241CDCCCC8C0BE0584100000000819A2241333333D310E05841CDCCCCCC7A9A22416666662613E0584100000000799A22410000004014E0584166666666789A22419A99995915E05841CDCCCCCC799A2241CDCCCC6C16E05841666666667D9A2241000000C017E0584166666666849A22416666668619E0584133333333969A2241000000C01BE058419A999999CE9A22413333331321E05841CDCCCCCCE09A22419A99991923E0584133333333EC9A2241CDCCCCAC24E0584133333333F49A22419A9999D926E058419A999999FC9A22419A99999929E0584100000000039B22419A9999F92CE0584100000000179B2241666666C63EE05841CDCCCCCC2B9B2241000000604DE05841000000002D9B22419A9999394EE0584166666666339B2241333333B352E058419A999999349B22419A99991956E0584100000000349B2241CDCCCC4C5AE05841CDCCCCCC2C9B2241CDCCCCEC64E05841CDCCCCCC1F9B22419A9999D970E0584166666666139B2241666666067BE0584133333333149B2241CDCCCC8C7CE0584100000000159B2241CDCCCCCC7DE0584100000000179B2241666666C67EE05841000000001C9B22419A99991980E0584133333333209B2241666666E680E0584133333333289B22410000004082E0584133333333499B2241CDCCCC0C85E05841CDCCCCCC809B22419A9999F988E0584100000000BA9B2241333333138CE05841CDCCCCCCCC9B2241000000208DE05841CDCCCCCCF69B22419A9999798FE05841CDCCCCCC749C2241333333D397E0584166666666DD9C2241CDCCCC2C9EE0584166666666239D22419A9999F9A1E0584133333333589D2241000000C0A4E0584166666666949D22419A999919A8E05841CDCCCCCCF39D22419A9999B9ADE05841000000002B9E224133333313B1E0584133333333829E22419A9999F9B5E05841CDCCCCCCBD9E224100000000BAE05841CDCCCCCCF09E224166666646BDE0584133333333279F2241CDCCCC2CC1E05841CDCCCCCC599F224133333333C5E0584133333333749F2241666666C6C7E0584166666666869F22419A999959CAE0584100000000CF9F2241333333D3D0E05841666666662DA022419A999919DAE058419A999999A4A022419A9999B9E3E0584100000000DAA02241333333F3E7E058419A999999FCA0224100000060EDE058419A9999991CA12241333333D3F2E058410000000058A1224166666686FAE05841CDCCCCCC0FA222416666666622E15841666666662EA222413333331324E15841CDCCCCCCCAA02241333333B373E1584100000000D0A022410000006078E158410000000088A12241CDCCCCAC8CE158419A9999999CA22241CDCCCC4CA7E15841CDCCCCCCE6A422419A9999D9D8E15841CDCCCCCC26A52241CDCCCCCCDEE1584166666666BDA42241000000E0E7E15841CDCCCCCCA4A42241000000C0EDE1584100000000CFA4224100000080EEE1584133333333F2A4224100000000FAE1584166666666DEA42241333333F303E25841CDCCCCCCADA42241666666E6FFE15841333333339CA42241CDCCCC4C10E25841CDCCCCCC0FA522416666660616E258416666666608A52241000000401DE25841CDCCCCCC2BA52241666666062DE258410000000020A52241CDCCCC8C38E25841CDCCCCCC3FA52241000000003DE25841CDCCCCCC4FA522416666668647E25841666666663DA52241000000A04CE258416666666685A52241333333B34CE25841CDCCCCCC1CA62241333333534EE258419A9999991EA622413333333353E2584133333333FBA52241333333F356E25841CDCCCCCC26A622416666660659E258419A99999908A622416666668667E2584166666666D2A522419A9999D96CE258419A999999F3A522410000008071E258419A99999942A62241666666C66AE258419A99999952A622419A99993970E258413333333305A622419A99991979E25841CDCCCCCC13A622416666666682E2584100000000E4A522410000000094E258416666666619A622410000008096E2584133333333FCA522419A9999999BE258419A99999902A62241CDCCCC0CA1E258410000000057A6224100000060A0E258419A9999996BA622419A999999A6E258419A9999993DA62241333333F3B1E25841000000002BA62241CDCCCCACB6E25841000000004EA6224166666606BFE25841CDCCCCCCADA6224133333353C7E2584133333333D6A62241000000E0C6E2584100000000DEA6224166666686BBE2584133333333B7A622419A999999A9E258419A999999A0A62241333333939BE2584100000000E2A62241666666C698E25841333333330FA722419A9999D999E25841CDCCCCCC7BA72241CDCCCC0CA7E2584166666666BEA72241666666A6B4E258416666666690A7224100000060C2E258413333333394A72241CDCCCCECC7E2584133333333FBA7224133333393CDE2584133333333ADA8224166666606CBE25841CDCCCCCC0AA9224133333353CBE258410000000056A9224100000060CEE2584100000000AEA92241666666A6D7E2584100000000E6A92241000000E0D4E25841CDCCCCCCFEA9224166666626D0E2584166666666FEA92241CDCCCCACCAE258413333333320AA2241CDCCCCCCC4E258413333333345AA22419A999939C2E25841CDCCCCCCA2AA22419A999979BCE2584100000000DAAA224133333313B3E25841CDCCCCCC63AB224133333313B4E258410000000018AC22410000008098E25841CDCCCCCC57AC2241000000C08CE2584166666666FFAC2241333333537FE25841000000004BAE2241CDCCCCAC5AE258416666666641AF2241000000002AE258410000000091AF22410000000016E2584166666666D7AF2241000000E007E258419A9999994CB0224166666606ECE158419A99999986B02241666666E6D6E15841CDCCCCCCABB0224100000080D4E1584100000000DAB32241000000C0C8E158416666666690B52241CDCCCCCCC1E158419A99999963B62241666666C69CE158419A999999C4B622419A99991989E158410000000027B722410000002073E158419A99999990B722413333333362E158410000000090B72241000000E05FE1584133333333FCB72241000000404DE15841000000006FB82241000000803BE158413333333339B922413333339315E15841CDCCCCCC33B92241CDCCCCCC0EE158413333333342B92241333333D307E158416666666689B92241666666C6FAE05841CDCCCCCCDEB9224100000020F1E05841333333339DB9224100000000F0E058419A99999988B922419A999919EDE05841CDCCCCCC78B922419A999939E9E058410000000067B9224166666666E2E058413333333354B9224133333313E0E058416666666625B92241CDCCCC4CE1E0584166666666E2B82241666666C6E1E0584100000000B9B82241CDCCCCECD4E058419A999999A6B8224133333373CFE05841000000008DB82241CDCCCC4CC5E058419A9999995BB82241CDCCCC2CAAE058410000000056B82241CDCCCCEC9FE058419A99999952B82241CDCCCCCC9CE05841CDCCCCCC50B82241CDCCCC8C8DE058419A99999967B82241CDCCCCAC83E0584166666666BEB822413333337359E058416666666693B92241333333B305E0584100000000D4B922419A9999B9F8DF584166666666D0B9224133333313F2DF5841CDCCCCCCADB92241CDCCCC0CEDDF58413333333344BA2241CDCCCC0CC7DF58413333333384BA224100000020B1DF584100000000CDBA2241333333D391DF58419A99999986BB2241CDCCCCEC4CDF5841666666668FBB2241CDCCCC8C43DF58419A99999983BB2241000000401FDF58419A99999987BB22419A9999D905DF58410000000099BB22419A999919F3DE584166666666B0BB22419A999919DADE5841CDCCCCCCBEBB224166666666C5DE584100000000D6BB22419A999939ABDE5841CDCCCCCCFBBB2241666666A696DE5841666666667CBC22416666660685DE58410000000042BD22419A99991963DE58410000000086BD22410000000068DE58419A999999F6BD2241666666C66BDE58413333333348BE2241CDCCCC2C71DE5841CDCCCCCC83BE22419A99999974DE584166666666B9BE2241000000C07CDE5841666666662DBF2241666666A683DE5841666666665CBF22419A99991987DE584100000000AEBF22419A9999B98BDE58413333333315C022419A9999198FDE5841333333334AC02241666666C691DE5841666666667CC022419A9999D994DE5841333333335EC1224133333373A3DE58410000000036C2224133333353B3DE58419A9999995DC22241666666C6A7DE58419A99999975C2224133333313A1DE5841333333338EC22241666666C699DE58419A99999973C22241333333F378DE58413333333334C222410000000071DE58416666666640C122413333339354DE58419A999999F9C02241000000804BDE58419A999999ADC02241666666E63FDE584133333333ACC02241CDCCCCAC3FDE58419A999999ABC02241CDCCCC6C3FDE58419A9999998AC022416666664631DE5841CDCCCCCC69C02241333333331CDE58416666666659C022413333335310DE58410000000044C02241333333B301DE58413333333316C02241333333B3E1DD584100000000EDBF224100000080C4DD584100000000D2BF224133333333BADD5841CDCCCCCC8CBF2241666666A6B9DD5841CDCCCCCCFCBE224133333353B4DD58419A99999962BE2241000000C0A1DD5841000000000FBE2241333333D396DD584133333333DFBD22413333337395DD584166666666B3BD22416666666694DD5841666666667EBD22419A99991993DD58419A9999993ABD2241000000A091DD584166666666EABC22416666662690DD58410000000098BC2241666666C68FDD58416666666656BC22419A9999F98FDD58419A9999991DBC22410000004090DD5841CDCCCCCCFBBB2241CDCCCC6C90DD584166666666E4BB22413333339390DD584133333333D3BB2241333333D390DD584133333333B5BB22416666664691DD58416666666696BB22416666664692DD5841333333337ABB22416666662693DD5841666666664ABB2241333333338EDD5841666666660BBB22419A99999988DD584100000000CDBA2241666666E687DD5841CDCCCCCC9FBA22419A9999B988DD58413333333392BA22419A9999D989DD58416666666640BA2241333333D390DD58419A99999927BA2241666666C692DD5841CDCCCCCC13BA2241CDCCCC6C94DD5841666666660EBA22416666668694DD58416666666608BA22416666668694DD58419A999999FEB922410000006094DD5841CDCCCCCCF1B92241CDCCCCEC93DD5841CDCCCCCCE5B922416666664693DD584166666666D7B92241CDCCCC6C92DD58419A999999CBB922410000008091DD584133333333B6B922419A99997990DD58419A999999AFB92241CDCCCC2C90DD5841CDCCCCCC9FB92241CDCCCC8C8FDD5841000000008AB922419A9999198FDD58413333333376B92241000000A08EDD58410000000060B92241CDCCCCEC8DDD58413333333348B92241CDCCCC0C8DDD58416666666626B922419A9999798BDD5841CDCCCCCC02B92241666666A689DD5841CDCCCCCCEDB822419A99997988DD584133333333D8B822410000004087DD584100000000CAB822419A99999986DD584166666666BDB822419A99995986DD584100000000B2B82241CDCCCC4C86DD5841666666669EB822413333335386DD5841000000007BB822419A99995986DD5841666666666DB722419A9999D992DD5841333333333FB62241333333D3A1DD584133333333EBB522419A999999A6DD58416666666623B52241666666A6A5DD5841666666668AB422419A9999D9A3DD58419A99999922B42241333333F39DDD58416666666692B32241666666C692DD5841CDCCCCCC5DB32241333333738CDD58419A9999991EB12241000000A035DD5841666666660EB12241000000E032DD58416666666600B122413333333330DD5841CDCCCCCCDBB02241CDCCCC2C29DD5841333333336DB02241333333B324DD58410000000064AF2241333333F319DD5841000000002EAE2241333333130BDD5841666666660BAE2241CDCCCCCC06DD584100000000ACAD2241666666C6F6DC584133333333A3AD224133333353F5DC5841CDCCCCCCA4AD2241000000A0F3DC584133333333A4AD22419A9999D9F1DC584100000000A1AD2241CDCCCCECEFDC5841CDCCCCCC9CAD224100000020EEDC5841333333338DAD2241666666A6E9DC5841333333337CAD2241CDCCCC8CE4DC58419A99999973AD22419A999979E1DC58413333333369AD2241CDCCCCCCDCDC5841666666665EAD2241CDCCCCACD8DC58419A99999956AD2241666666C6D5DC58410000000052AD2241CDCCCCCCD3DC58419A99999950AD22419A999979D1DC58416666666652AD224133333353CFDC58413333333354AD224100000080CDDC5841666666665DAD224133333313CADC5841666666666AAD224166666626C5DC58413333333376AD2241CDCCCCACC0DC5841333333337EAD2241666666C6BCDC58410000000084AD22419A999979BADC58419A99999989AD2241333333F3B8DC5841000000008DAD2241CDCCCC6CB7DC5841333333338EAD224166666606B6DC5841333333338EAD22419A999999B4DC5841000000008EAD224133333373B3DC5841333333338BAD224133333353B2DC5841666666667FAD224133333333AFDC58416666666674AD2241CDCCCC6CABDC58413333333368AD22419A9999B9A7DC5841CDCCCCCC56AD22419A9999F9A2DC5841CDCCCCCC40AD2241666666669EDC584100000000E4AC224100000040A5DC584100000000AAAC2241333333F3A8DC58413333333380AC2241666666E6A7DC58419A9999995AAC2241CDCCCCCCA5DC5841CDCCCCCC18AC2241CDCCCC8CA2DC58419A999999BEAB2241CDCCCC2C9DDC584166666666A8AB22419A9999B99CDC58413333333390AB2241000000009CDC5841CDCCCCCC76AB2241CDCCCCEC9ADC58419A99999941AB22416666666698DC5841CDCCCCCC27AB22419A99991997DC58419A999999F5AA22416666660694DC584166666666C0AA2241666666C690DC5841333333331CAA2241333333338EDC5841666666663EA92241333333B38BDC584166666666C9A82241CDCCCCEC87DC58416666666615A72241000000806BDC584166666666A1A622419A99999963DC5841CDCCCCCC59A62241666666A665DC58416666666645A62241CDCCCC2C61DC58410000000016A62241CDCCCCCC5ADC58413333333301A62241666666A651DC584166666666ECA52241666666064CDC584133333333AFA522410000006047DC58419A99999979A52241333333F33BDC58416666666648A522419A9999B92FDC58419A99999928A52241CDCCCCCC1FDC58410000000007A52241CDCCCCAC14DC584166666666EDA42241666666C60ADC58419A999999D0A422410000000002DC584133333333A7A42241CDCCCC4CF8DB5841000000007BA4224166666626F7DB58416666666646A42241CDCCCC0CF5DB58419A9999990EA42241333333D3FADB58419A999999D8A322419A9999B900DC584100000000B8A322419A99991903DC58419A99999998A322419A9999B903DC58419A99999955A322410000006004DC58419A99999930A32241666666E608DC58419A99999908A32241CDCCCCAC0ADC5841CDCCCCCCC8A22241000000200CDC58419A999999B7A22241CDCCCCEC0BDC584133333333A3A22241CDCCCC2C0BDC58416666666672A222416666662605DC58419A99999957A222416666668600DC58413333333330A22241000000C0F9DB5841CDCCCCCC16A22241CDCCCCACF4DB58419A9999990EA222419A999959F2DB58419A9999990AA222419A999979EEDB584166666666CFA1224133333393F6DB584166666666AAA12241666666A6FCDB584100000000D5A122410000004003DC58419A9999999DA12241CDCCCCEC09DC5841CDCCCCCC7FA12241CDCCCCAC06DC58410000000054A122416666668605DC5841CDCCCCCC10A12241333333F306DC58419A999999F9A022413333339307DC58419A99999986A02241000000200FDC58419A9999994BA022419A9999D913DC58410000000020A02241CDCCCCCC18DC584166666666FC9F22419A9999B91CDC584133333333E59F22419A9999D920DC584133333333CE9F2241CDCCCC8C25DC584133333333869F22410000008022DC584100000000769F2241666666461CDC58419A999999509F2241000000A017DC584166666666189F2241333333B317DC584133333333E09E22419A9999B91BDC584166666666C89E2241000000A01ADC58419A999999B69E22413333331319DC584100000000AE9E22419A9999F917DC584100000000A39E22413333339316DC5841000000007F9E22419A9999B910DC58419A999999559E2241CDCCCCAC0ADC5841CDCCCCCC339E22410000006005DC584166666666259E2241666666C602DC5841000000001E9E2241CDCCCC4C00DC5841CDCCCCCC1D9E2241CDCCCC8CFDDB58419A999999229E2241666666C6F9DB584166666666AD9D224133333393FCDB584166666666869D2241000000C0FDDB58419A9999995D9D2241CDCCCCCCFDDB584133333333279D2241CDCCCC0CFEDB58419A999999C49C22416666668601DC584100000000939C22419A99993907DC584133333333289C22419A9999F9FDDB58419A999999FF9B2241CDCCCCECFADB5841CDCCCCCCF29B2241CDCCCCCCFCDB584133333333DA9B2241000000A0FEDB584166666666BD9B22416666668601DC584100000000AD9B22410000004005DC58419A999999AB9B22413333333308DC58419A999999AC9B2241CDCCCCEC0ADC5841CDCCCCCCA69B22419A9999590FDC5841000000009A9B2241CDCCCC6C12DC584166666666859B2241000000E014DC5841333333336D9B2241CDCCCC2C17DC5841000000004E9B2241CDCCCC8C18DC58419A999999239B2241333333131ADC584166666666019B2241CDCCCC4C1ADC584100000000E39A2241333333F319DC584100000000C19A2241333333F318DC58419A999999A49A22416666660618DC5841CDCCCCCC819A22419A99991917DC58419A9999996B9A2241000000E016DC584133333333529A22419A99997917DC58419A999999339A2241000000A017DC584100000000FC992241333333F31BDC58419A999999E6992241000000801FDC584100000000C69922413333337322DC5841333333338C9922410000002022DC5841333333334F9922416666660621DC5841CDCCCCCC3D992241666666061CDC58410000000014992241000000E015DC58419A9999990A9922416666668614DC584166666666FF982241CDCCCC2C13DC584100000000F39822416666666612DC584100000000E89822416666666612DC584166666666D8982241000000A012DC58419A999999CD9822416666660613DC584100000000BB9822413333337313DC58419A999999A6982241666666A613DC5841333333338F982241CDCCCCAC13DC58419A9999997F9822413333335313DC584100000000739822416666668612DC58419A9999995E9822410000000011DC58410000000052982241CDCCCC0C10DC5841CDCCCCCC3D982241333333130FDC58416666666629982241CDCCCC4C0FDC584100000000FB9722410000004013DC584133333333E89722413333337314DC584100000000D7972241CDCCCC0C15DC584100000000B89722416666664615DC58413333333389972241000000E017DC5841333333337B972241333333D319DC584166666666709722419A9999391ADC58413333333367972241CDCCCC0C1ADC58419A9999995D9722410000004019DC58413333333354972241333333B318DC5841666666664C972241333333B318DC584166666666419722419A99991919DC584100000000359722416666668618DC584166666666289722413333339317DC58419A99999912972241000000A016DC58419A999999FC962241666666A616DC584100000000EA962241CDCCCC0C17DC584100000000D49622419A9999D917DC584100000000B5962241CDCCCCAC18DC58416666666697962241333333B318DC5841666666667E9622419A9999B918DC58419A9999996B962241CDCCCC8C18DC58419A999999559622419A99999917DC58419A9999993D9622413333337315DC58419A9999992F962241CDCCCC0C15DC5841CDCCCCCCE89522410000002017DC5841CDCCCCCCAC9522419A9999B918DC58419A99999982952241666666061ADC5841CDCCCCCC00952241000000E016DC5841CDCCCCCC3D9422419A9999F91ADC58419A999999C4932241333333731EDC58413333333394932241333333131FDC584133333333519322410000002020DC5841000000001B9322419A9999B922DC5841333333331D932241666666462CDC5841000000000B932241333333B334DC5841CDCCCCCC38932241666666E63ADC5841CDCCCCCC569322419A9999B93FDC58416666666663932241333333D343DC58419A9999995D932241666666464ADC58416666666640932241000000604FDC58419A99999932932241666666E652DC5841CDCCCCCC2B9322413333339360DC584166666666299322413333339368DC58419A999999C3922241666666667BDC58419A99999970922241333333338FDC58410000000039922241CDCCCC8C94DC58419A99999929922241333333B397DC5841CDCCCCCC159222419A9999B99EDC5841000000002992224166666686A6DC5841000000003392224133333353AEDC58419A9999995792224133333373B7DC58419A9999994B92224133333353BEDC58416666666622922241CDCCCC0CCBDC5841CDCCCCCC149222419A9999F9D5DC5841000000000792224100000020D9DC584133333333D59122419A9999F9D8DC58419A999999E591224133333333E0DC584133333333E691224100000060EADC5841000000006F92224166666606E1DC5841666666667692224133333393F3DC5841CDCCCCCC39922241CDCCCC8CF7DC5841CDCCCCCC9C9122416666664601DD584133333333449122410000008004DD5841CDCCCCCC219122416666668604DD5841CDCCCCCCEF9022416666666603DD58419A999999B7902241CDCCCCAC02DD58419A999999559022413333337307DD584133333333D68F22416666668612DD584166666666B68F22419A9999F921DD584133333333478F22413333333328DD58419A9999992B8F2241666666A635DD584100000000D18E22419A9999B947DD584133333333BD8E2241CDCCCC6C4CDD5841000000009E8E2241666666664FDD5841000000007F8E22416666666651DD584100000000FC8D2241CDCCCC8C50DD58419A999999D98D2241CDCCCC2C50DD58419A999999748D22410000002057DD584133333333F98C22419A9999396ADD584166666666A18C2241CDCCCC2C7CDD584133333333848C22419A9999D981DD5841000000007E8C2241000000C082DD58419A999999728C2241333333F383DD584166666666878C2241333333338ADD5841333333334F8C2241CDCCCC6C8BDD5841CDCCCCCC8A8B2241CDCCCCEC8FDD584100000000278B22419A99999991DD5841CDCCCCCCCF8A2241CDCCCCAC92DD584166666666378A22419A9999D999DD584100000000A1892241CDCCCC0CA9DD5841333333334889224133333373ABDD5841666666660C89224133333333A9DD5841666666660D892241000000A0A5DD58416666666603892241CDCCCCACA5DD584166666666FC8822419A9999B9A5DD584100000000EF882241000000C0A5DD584133333333D888224133333353A5DD58419A99999960882241000000A0A1DD58419A9999993688224100000000A0DD58416666666628882241333333339FDD58416666666619882241333333539EDD5841333333330A882241333333339DDD584100000000F2872241000000E09ADD5841CDCCCCCCC8872241CDCCCCAC96DD5841CDCCCCCCAC8722419A99997993DD58419A9999997B872241666666068EDD5841333333333A8722410000008094DD584133333333D78622419A999919A1DD584133333333AC862241666666C6B7DD5841	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	01010000206A080000FC90BDC59FA522416666665666DF5841	870090000	Z	Beaumont-du-Lac	8700900	87009	87	75	27
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	01010000206A080000B82D8E659BB420419A99994967035941	870110101	H	Sud-Ouest	8701101	87011	87	75	18
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	01010000206A0800004F1C5D911DCB204166666676E4055941	870110102	H	Nord-Est	8701101	87011	87	75	7
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	01010000206A080000D848CD1956E4204133333363DCFF5841	870120000	Z	Berneuil	8701200	87012	87	75	26
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	01010000206A080000307B4A56E1A3214100000090F4005941	870130000	Z	Bersac-sur-Rivalier	8701300	87013	87	75	33
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	01010000206A0800002A598ACA2B8721419A99993976045941	870140000	Z	Bessines-sur-Gartempe	8701400	87014	87	75	55
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	01010000206A080000BC18F9BBB80121410000003080DF5841	870150000	Z	Beynac	8701500	87015	87	75	13
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