SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep90;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep90 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep90','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep90','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep90','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep90"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000ECA9BDB7743A2E41666666D6C2AB5941	900010000	Z	Andelnans	9000100	90001	90	27	4
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	01010000206A08000055864C258D892E41CDCCCC4C73B65941	900020000	Z	Angeot	9000200	90002	90	27	7
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	01010000206A080000CD6FE20F655C2E41000000E043B75941	900030000	Z	Anjoutey	9000300	90003	90	27	8
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	01060000206A08000001000000010300000001000000890000006666666627132E41000000A05CAB594166666666F0132E41666666A66CAB5941666666662E142E419A99993976AB5941666666666F142E416666660673AB594100000000DC142E41666666E67AAB5941CDCCCCCC2C152E41333333537FAB5941CDCCCCCC16162E41333333D389AB5941CDCCCCCC80162E419A9999B992AB594133333333AD162E419A99995992AB5941CDCCCCCC6D172E4166666666A6AB5941000000005F182E4100000020BAAB5941333333338E182E419A999979C4AB59416666666690182E4133333393CAAB59419A99999914192E4100000080CCAB5941CDCCCCCC2B1A2E41CDCCCCCCD6AB5941CDCCCCCC061A2E419A999919F8AB594100000000571A2E4166666646F9AB59419A999999451A2E41666666C61EAC594133333333971A2E416666666636AC59419A999999B51A2E41000000A03CAC5941333333330F1B2E416666668637AC594100000000A71B2E419A99991954AC594100000000921B2E41000000A05BAC59419A9999991E1B2E41CDCCCC2C56AC5941666666661E1B2E41333333F384AC5941666666660B1B2E419A99997991AC5941CDCCCCCC811A2E419A999959B3AC59419A9999998C1A2E41333333D3BFAC594100000000FC1A2E41666666C6CBAC594133333333BC1A2E41333333B3DEAC594100000000691A2E41666666C6F2AC59419A999999431A2E41666666A6F9AC5941CDCCCCCCC4192E41CDCCCC6C0DAD5941666666660C1B2E419A99995931AD594166666666341B2E41CDCCCC0C30AD594166666666101D2E4133333393FDAC594133333333911D2E41333333F3EBAC594166666666111E2E4133333313D4AC594133333333F51E2E419A999919B7AC5941CDCCCCCC3A1F2E41666666C6B0AC5941000000008C202E41333333338CAC5941666666662B212E41666666C685AC5941CDCCCCCC78222E41CDCCCCEC80AC5941000000005A232E41333333B382AC59416666666619242E419A9999F98FAC59419A9999991F242E419A99999995AC594133333333A1242E413333333397AC59419A99999937252E41CDCCCCEC97AC59413333333380252E419A99991997AC594100000000CE252E41333333D38FAC594166666666DA252E41333333F385AC594100000000BF252E41333333937BAC59416666666693252E41333333F36FAC59419A99999900262E41333333336AAC59410000000050262E41000000E063AC5941CDCCCCCCEA262E419A9999595FAC5941333333334C272E419A99999958AC5941CDCCCCCC6B272E41666666A654AC5941CDCCCCCCAD272E41333333F351AC594166666666FD272E41333333534CAC594166666666B8282E41CDCCCC8C4BAC59413333333317292E410000000047AC59416666666615292E41000000E039AC59416666666622292E41000000602FAC5941CDCCCCCC52292E41333333331EAC59413333333355292E41CDCCCC8C17AC5941333333337E292E416666662610AC59410000000079292E419A99993906AC5941CDCCCCCCEC292E4166666646FDAB5941CDCCCCCC052A2E41000000C0F9AB5941CDCCCCCCFD292E41000000A0F2AB59419A999999422A2E4166666606F0AB5941333333334F2A2E419A999959ECAB59419A999999142A2E4133333393E4AB594100000000B6292E41CDCCCC0CE2AB594100000000A7292E4166666606DFAB5941CDCCCCCCD1292E4166666646D8AB59419A999999CB292E419A9999B9D2AB594166666666DC292E4100000060CEAB59419A999999222A2E419A9999B9CAAB59416666666695292E41333333B3C7AB5941333333337E292E41666666A6A8AB5941666666668F292E41CDCCCC0C96AB59416666666661292E419A9999B98DAB594166666666DC282E41CDCCCCCC82AB5941666666665B282E419A9999D975AB59419A99999930282E41666666E66DAB594100000000CE272E416666666663AB5941CDCCCCCCC3272E41CDCCCCAC5FAB59419A999999BE262E41333333334DAB5941666666669F252E41000000C071AB5941666666666D252E41CDCCCCCC71AB5941333333334F252E41333333D36CAB59410000000049242E41666666664BAB594166666666E4232E410000004040AB5941000000006C232E41666666663BAB59416666666658232E41CDCCCC2C3FAB59419A999999D7222E41CDCCCC8C4FAB59416666666642222E41333333F35AAB5941CDCCCCCCE8212E41CDCCCC8C5DAB5941CDCCCCCC97212E41000000E04FAB59419A99999979212E41CDCCCC6C4DAB5941CDCCCCCC02212E41CDCCCC4C5BAB5941000000003C202E41000000806AAB594133333333CD1F2E41333333F36BAB594133333333751F2E41333333337CAB5941666666664D1F2E41000000607AAB5941333333334B1D2E419A9999D93BAB594100000000231D2E416666662638AB5941000000005D1C2E41CDCCCC2C56AB5941CDCCCCCC6E1B2E41000000A077AB5941000000005C1B2E41333333D37AAB5941CDCCCCCCFF1A2E416666666678AB5941000000000A1A2E416666664668AB59419A999999BF192E41CDCCCC0C64AB59413333333329192E416666662659AB5941000000009A182E41666666E64FAB5941666666662A182E41CDCCCC4C4AAB594133333333D6172E410000000045AB5941CDCCCCCC53172E41CDCCCC8C3AAB5941333333330F172E41CDCCCC0C47AB594166666666C3162E419A99999946AB594100000000A1162E41333333533CAB5941CDCCCCCC62162E410000004040AB5941000000001D162E413333339341AB59419A999999D6152E41666666263AAB59419A99999998152E41000000801DAB5941CDCCCCCC3E152E419A99991920AB5941000000000E152E410000006030AB59410000000083142E41666666463EAB59413333333351142E41333333933FAB59419A999999CE132E419A9999F936AB59419A999999BA132E410000000037AB5941000000006C132E41333333D349AB5941CDCCCCCC3A132E41000000E053AB59416666666627132E41000000A05CAB59416666666627132E41000000A05CAB5941	01010000206A080000B0EBBAAECD212E416666661628AC5941	900040000	Z	Argiésans	9000400	90004	90	27	3
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	01010000206A080000EFEF364119052E410000004021B95941	900050000	Z	Auxelles-Bas	9000500	90005	90	27	9
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	01060000206A080000010000000103000000010000006500000033333333D8F32D41666666E630BB5941CDCCCCCCE6F32D41CDCCCCCC37BB59419A99999914F42D41000000803BBB59419A99999996F42D41CDCCCCCC48BB59419A999999BFF42D419A9999194FBB594133333333FEF42D41CDCCCCCC55BB5941CDCCCCCC82F52D41000000607CBB5941CDCCCCCC84F52D419A99991999BB594166666666A3F52D4133333393A0BB5941CDCCCCCC80F62D41CDCCCC0CB8BB594100000000B3F62D41000000C0BBBB5941CDCCCCCC68F72D41CDCCCC0CD7BB5941666666667DF72D41000000C0DFBB59419A99999940F72D419A99993964BC59413333333300F82D41000000007DBC5941CDCCCCCCDEF82D4100000080A3BC59413333333344F92D41000000E0B9BC594166666666FBF92D4100000020E9BC594133333333BBFA2D41666666E606BD5941000000009AFB2D410000002031BD59419A999999E0FB2D41CDCCCCCC39BD59413333333345FC2D41CDCCCC6C42BD594100000000DCFC2D410000004051BD5941CDCCCCCC5DFD2D41000000A04EBD594166666666E7FD2D410000002047BD5941333333336CFE2D41666666E644BD59419A999999DBFE2D41000000E046BD59410000000024FF2D41000000404ABD59410000000059FF2D41000000004BBD59410000000096FF2D410000008048BD5941CDCCCCCC91002E416666660633BD594166666666DC002E41CDCCCCCC2BBD59410000000048012E41CDCCCCEC1ABD5941CDCCCCCC74022E4166666646F8BC594100000000C7042E41CDCCCCECA8BC5941CDCCCCCC32052E419A9999D98ABC59419A999999A0062E41000000C034BC5941CDCCCCCC3B072E41000000E00FBC59416666666631072E410000006008BC59410000000048062E41CDCCCC2CD4BB59419A999999660A2E413333335393BB5941333333334B0B2E419A99999981BB5941000000003A0C2E419A99991971BB594133333333C50C2E41333333F366BB594133333333500D2E41CDCCCC8C5BBB594166666666A90D2E419A9999F94EBB5941CDCCCCCCB20D2E419A9999B948BB5941CDCCCCCC0B0E2E41000000A039BB594166666666150E2E410000006033BB594100000000160F2E41000000E004BB5941CDCCCCCC5B0F2E41CDCCCC8C03BB594166666666650F2E41CDCCCC4CFDBA59419A999999770F2E41CDCCCC8CE5BA59419A9999993A0F2E41000000A0D6BA5941CDCCCCCC2F0F2E4166666626CABA5941CDCCCCCC380F2E4166666666BCBA594100000000980F2E41CDCCCC4CB0BA59419A999999540E2E41CDCCCC0CAABA594166666666990D2E419A9999F9ACBA5941CDCCCCCC9B0C2E4166666646B5BA594100000000410C2E41666666E6B8BA594133333333160C2E41CDCCCC6CB5BA594133333333120C2E4100000040B2BA5941000000001E0C2E4166666606A1BA594100000000110C2E41000000C09ABA594100000000F50B2E41CDCCCC4C96BA5941666666666B0B2E410000008088BA594100000000070B2E413333339379BA594133333333C60A2E416666662673BA5941666666661D0A2E41000000206CBA5941000000000E0A2E41666666666FBA594100000000E3092E413333337370BA5941000000008A092E41666666466CBA594133333333D9082E41666666866ABA59419A99999992082E41CDCCCC0C6BBA5941CDCCCCCC11082E41000000406ABA594100000000D6072E41000000806BBA59419A99999962072E416666668670BA594166666666E5062E419A99991977BA5941CDCCCCCC74062E41000000A079BA594166666666E0052E41000000E078BA59419A9999997B052E41000000007BBA5941CDCCCCCCDA042E413333335365BA5941666666668A042E41CDCCCC6C60BA59419A999999AE032E41666666A660BA5941CDCCCCCC5E032E410000000062BA59416666666619032E41CDCCCCCC6ABA594166666666A3002E416666662675BA5941666666661EFE2D419A9999F9A2BA59419A99999943FE2D41CDCCCCCC99BA594100000000CFFD2D41666666A691BA5941333333336DFD2D419A9999B9A9BA59410000000057FB2D41CDCCCCEC8ABA59410000000003F82D41000000E063BA5941CDCCCCCC3AF72D419A99995960BA5941000000008DF52D41333333535EBA59419A99999945F52D41CDCCCCEC47BA5941666666663BF52D41CDCCCCAC46BA5941CDCCCCCCE9F32D41000000C021BB594133333333D8F32D41666666E630BB594133333333D8F32D41666666E630BB5941	01010000206A0800002828DD7609FF2D41666666F6C7BB5941	900060000	Z	Auxelles-Haut	9000600	90006	90	27	6
01060000206A08000001000000010300000001000000A20000009A999999B30D2E4133333333FAAA59419A999999D20D2E41CDCCCC6C0AAB5941666666660F0E2E419A99995914AB594166666666B00E2E41666666A625AB5941CDCCCCCCBB0E2E410000000028AB5941CDCCCCCCCE0E2E41000000E02BAB594100000000C60E2E41000000203CAB5941666666664C102E41CDCCCCAC45AB59413333333316112E413333337363AB59416666666627132E41000000A05CAB5941CDCCCCCC3A132E41000000E053AB5941000000006C132E41333333D349AB59419A999999BA132E410000000037AB59419A999999CE132E419A9999F936AB59413333333351142E41333333933FAB59410000000083142E41666666463EAB5941000000000E152E410000006030AB59413333333335152E419A99991925AB5941CDCCCCCC3E152E419A99991920AB59419A99999998152E41000000801DAB59419A999999D6152E41666666263AAB5941CDCCCCCCFE152E41000000203FAB5941000000001D162E413333339341AB5941CDCCCCCC62162E410000004040AB59419A9999998A162E419A9999793CAB594100000000A1162E41333333533CAB5941CDCCCCCCAF162E41CDCCCCAC41AB594166666666BC162E410000000045AB594166666666C3162E419A99999946AB5941333333330F172E41CDCCCC0C47AB59419A9999991D172E419A99997944AB5941CDCCCCCC53172E41CDCCCC8C3AAB5941666666666E172E41666666463DAB59413333333389172E419A9999593FAB594133333333D6172E410000000045AB594100000000FF172E41333333B347AB5941666666662A182E41CDCCCC4C4AAB5941CDCCCCCC52182E41CDCCCC4C4CAB5941000000009A182E41666666E64FAB59413333333329192E416666662659AB59419A999999BF192E41CDCCCC0C64AB5941000000000A1A2E416666664668AB5941CDCCCCCC5E1A2E41333333D36DAB59419A999999771A2E41000000606FAB594100000000941A2E41CDCCCC2C71AB594100000000D11A2E413333333375AB5941CDCCCCCCFF1A2E416666666678AB5941000000005C1B2E41333333D37AAB5941CDCCCCCC6E1B2E41000000A077AB5941000000005D1C2E41CDCCCC2C56AB594100000000231D2E416666662638AB5941333333334B1D2E419A9999D93BAB59419A9999998F1D2E416666662644AB59419A999999D11D2E41333333534CAB5941666666664D1F2E41000000607AAB594133333333751F2E41333333337CAB594133333333CD1F2E41333333F36BAB594100000000CC1F2E41333333D36BAB5941000000003C202E41000000806AAB5941CDCCCCCC02212E41CDCCCC4C5BAB59419A99999979212E41CDCCCC6C4DAB5941CDCCCCCC97212E41000000E04FAB5941CDCCCCCCE8212E41CDCCCC8C5DAB59416666666642222E41333333F35AAB59419A999999D7222E41CDCCCC8C4FAB59416666666658232E41CDCCCC2C3FAB5941000000006C232E41666666663BAB594166666666E4232E410000004040AB59410000000049242E41666666664BAB5941333333334F252E41333333D36CAB5941666666666D252E41CDCCCCCC71AB5941666666669F252E41000000C071AB59419A999999BE262E41333333334DAB594166666666F6252E419A99995925AB594133333333C5252E419A99997921AB594166666666B7252E419A9999F91FAB5941CDCCCCCCA4252E41CDCCCCAC1BAB59410000000070252E41333333B30DAB59413333333335252E413333331305AB594100000000D6242E4100000060F9AA5941CDCCCCCC34242E41666666C6E5AA5941000000001B242E4166666686E2AA594166666666F2232E4100000060DCAA594133333333D6232E4100000060D8AA594166666666C0232E41666666A6D3AA594133333333AE232E41CDCCCC0CD0AA5941666666669F232E41666666A6CCAA5941CDCCCCCC60232E419A9999D9C0AA59410000000090232E4100000080AFAA5941000000009E232E4133333333A9AA5941000000004E232E4166666646A9AA5941CDCCCCCC98222E410000008095AA594100000000D7222E410000008088AA594100000000D7222E419A9999B97BAA59419A999999E9222E41666666E66FAA594100000000F7222E413333339367AA59410000000007232E41000000805DAA59419A99999919232E419A99995952AA59410000000027232E41666666C649AA5941333333332C232E41CDCCCC8C46AA59419A99999931232E41CDCCCCAC40AA5941CDCCCCCC2B232E41333333733BAA59413333333323232E410000000038AA594166666666D1222E416666666626AA59413333333366222E41333333930EAA5941CDCCCCCC0C222E4133333353F9A95941CDCCCCCC02222E4100000000F7A9594133333333E4212E41CDCCCC0CEDA9594100000000BF212E41CDCCCC4CD8A9594100000000AB212E4100000000D0A959410000000086212E41CDCCCC6CC0A959416666666658212E419A9999D9B0A95941666666663E212E4166666666A4A959416666666615212E413333331382A959419A999999FD202E416666666661A9594133333333FC202E41CDCCCC2C4CA9594166666666E6202E419A9999F931A95941333333337F202E41000000A002A95941CDCCCCCCC71F2E419A999959CEA85941CDCCCCCCA01F2E41666666E6BFA8594133333333B11E2E4166666666E1A8594166666666271E2E41666666C6FFA8594166666666001C2E419A99995924A959416666666690192E419A9999B956A959416666666659192E41666666C655A959413333333356192E41CDCCCCCC55A95941CDCCCCCCF1182E41666666264DA959413333333330172E410000006069A95941666666660A172E41666666E66CA9594133333333AA162E41666666C66AA9594133333333C5152E413333339381A95941666666669C152E41000000A085A95941CDCCCCCC4E152E41000000608DA959419A99999976142E4133333353A4A95941CDCCCCCC26152E41000000A0C5A959419A99999998142E4100000040DEA959416666666625142E4100000020E8A95941CDCCCCCC1B142E4100000020EDA95941000000009B142E419A99993901AA5941CDCCCCCC2B152E41CDCCCC4C0DAA59419A99999944152E41666666C618AA594133333333C2142E41666666262EAA59413333333383142E41333333F33CAA59419A99999985142E41333333F341AA5941000000009B142E41CDCCCCAC55AA5941333333337D142E419A99999958AA5941333333336D142E41333333335AAA5941000000005B142E419A9999B957AA594166666666A7132E416666666676AA59416666666679132E41333333B377AA59416666666661122E41666666C657AA5941666666664D122E41CDCCCCCC57AA59416666666630122E41CDCCCCEC5CAA5941CDCCCCCC27122E41000000805EAA5941666666661E122E419A99993960AA5941CDCCCCCCF2112E416666660668AA594166666666EA112E41CDCCCC8C69AA5941CDCCCCCCE4112E41333333936AAA594166666666DA112E419A9999796CAA594100000000EE0D2E41666666E6E4AA594133333333BC0D2E419A999979E7AA59419A999999B30D2E4133333333FAAA5941	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	01010000206A0800002A60BFE4E61B2E41666666961FAA5941	900070000	Z	Banvillars	9000700	90007	90	27	5
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	01010000206A08000062A2FD47D5212E41CDCCCC1CC9AD5941	900080000	Z	Bavilliers	9000800	90008	90	27	5
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	01060000206A08000001000000010300000001000000A10000000000000039562E416666660654A05941000000009C562E41CDCCCCCC61A059419A99999900572E41666666466AA059419A999999CE572E41666666A675A05941CDCCCCCCCB582E410000002084A059416666666645592E419A9999B988A059419A99999959592E41000000808BA05941CDCCCCCC4A5B2E4100000060B3A05941CDCCCCCCA65B2E419A9999F9B7A0594133333333D45B2E41000000609DA0594100000000EE5B2E413333335394A05941CDCCCCCCFD5B2E41CDCCCC4C83A05941CDCCCCCCFF5B2E419A9999B969A05941666666660F5C2E41333333F363A05941333333336A5C2E413333331353A0594166666666AD5C2E41000000204AA0594133333333675C2E416666666643A059419A999999505C2E41000000A03DA0594100000000CC5C2E41CDCCCC8C2CA0594166666666CA5C2E41000000C02BA0594166666666275C2E41666666261AA059419A999999535C2E41000000E013A0594133333333065C2E419A9999B90AA0594100000000605C2E41CDCCCC0C01A0594133333333665D2E4166666626E99F594100000000F45D2E41CDCCCC4CDE9F5941CDCCCCCC0D5E2E4100000080D89F594166666666145E2E41333333B3D29F5941CDCCCCCCE95E2E4100000000C39F594100000000005F2E41CDCCCCCCBE9F5941CDCCCCCC255F2E419A999919C29F5941CDCCCCCC7F5F2E419A999979B99F59419A999999385F2E41CDCCCC2CAF9F5941CDCCCCCCF35F2E4166666686A29F5941CDCCCCCC27602E41666666A69C9F5941666666664A602E4100000020A09F5941CDCCCCCC54602E41000000409E9F59416666666678602E41CDCCCCECA19F59410000000098602E41333333939C9F5941CDCCCCCCAA602E41CDCCCC8C9E9F59419A999999CA602E41CDCCCC0C999F594100000000F1602E41000000209C9F594133333333CD602E4166666626A89F5941CDCCCCCC1D612E4100000000B19F5941CDCCCCCC19612E419A999999B39F5941666666665E612E41000000E0B19F5941666666665E612E41333333F3B69F594166666666A0612E41CDCCCC2CB79F594133333333A6612E41CDCCCC4CC69F5941CDCCCCCCC5612E4100000040CE9F59413333333322622E41CDCCCC2CDC9F59419A99999960622E4133333333E39F59419A9999997B622E41666666A6DD9F59413333333348622E41CDCCCCACD69F59419A9999995F622E4100000060D39F59413333333396622E41000000E0DB9F59419A999999E6622E4100000060D09F5941000000009A622E4166666646C49F59419A999999DA622E419A999979BD9F59410000000014632E419A999959BA9F594133333333F5622E4100000020B49F59413333333328632E4100000040AE9F594100000000A1632E41000000609A9F59419A999999B9632E41333333739C9F59419A999999DF632E419A999999969F59419A9999991F642E41000000A09C9F5941CDCCCCCC7C642E419A9999D9929F594100000000D2642E41666666669C9F5941333333338E652E4100000080AE9F59410000000053662E419A999939BF9F5941CDCCCCCC58662E41000000C0B29F594133333333B9662E41CDCCCC6C7F9F594100000000EA662E41000000E06D9F59413333333367682E41333333B3829F594166666666BC692E4133333393979F594133333333DA692E41CDCCCC4C969F594166666666506A2E41CDCCCC6C7E9F594133333333E56A2E41666666C66C9F594133333333526B2E41CDCCCC6C619F594166666666506B2E419A9999794F9F5941333333331A6B2E41000000A0389F5941CDCCCCCC006B2E41CDCCCC6C329F5941000000008E6A2E419A999959259F5941000000008B6A2E41666666E6159F594100000000976A2E4100000020FA9E59419A999999906A2E41CDCCCC4CED9E5941333333337F6A2E41333333D3E09E5941CDCCCCCC216A2E419A9999F9C89E594100000000166A2E419A999939BE9E594100000000F6692E41333333B3B09E5941CDCCCCCC006A2E4166666666A99E59419A999999316A2E41CDCCCC0C999E5941CDCCCCCC2F6A2E419A9999F97D9E594166666666236A2E41000000606E9E594100000000DF692E41CDCCCC0C539E594166666666E6692E41666666E6469E594133333333F9692E41000000803D9E5941CDCCCCCCED692E41333333B3399E59413333333397692E41CDCCCC0C2F9E5941333333336F692E4166666606269E59419A9999995D692E419A999999169E594100000000EA672E419A999959179E5941CDCCCCCC0E672E4133333393219E5941000000004F652E41CDCCCC4C3C9E5941CDCCCCCCC3642E41333333F3439E5941CDCCCCCC87642E4100000040459E59419A99999990642E41CDCCCC8C369E59413333333305642E41CDCCCC6C3C9E59419A99999987632E4100000000489E59413333333360632E419A999999519E59419A99999943632E41CDCCCC0C5C9E594100000000F6622E41000000805D9E5941000000007C622E419A9999F95D9E59410000000056622E4100000000599E5941CDCCCCCCB8612E419A999959409E594166666666E6602E4166666686429E59419A999999A0602E419A999919459E5941CDCCCCCC2A602E4133333373649E5941666666660D602E419A9999396D9E5941CDCCCCCC775F2E41000000E06F9E59419A9999990D5D2E41CDCCCC4C839E5941CDCCCCCCC25B2E41333333B38E9E5941333333334D5B2E4100000040A19E5941CDCCCCCC3E5B2E41000000C0A69E594100000000295B2E4100000040B89E5941CDCCCCCCF15A2E41333333B3CD9E59419A999999D85A2E4166666686D59E5941666666668D5A2E4166666606DE9E5941CDCCCCCC605A2E41CDCCCC6CE89E594133333333FA592E4166666686049F594166666666745A2E41333333B30A9F594133333333825A2E41666666C60E9F594100000000C1592E41CDCCCC8C0F9F59416666666692592E4166666686109F5941000000006F592E41333333731B9F59410000000054592E41000000201E9F59419A99999934592E41CDCCCCCC259F5941CDCCCCCC0A592E4100000040339F59419A999999B5582E41666666A6529F59410000000081582E41666666266A9F5941CDCCCCCC48582E41CDCCCC6C8D9F5941666666660D582E419A9999B9939F5941CDCCCCCCF1572E419A9999B9B69F594133333333D4572E4100000080BA9F5941CDCCCCCCAC572E41CDCCCC4CC39F5941666666669C572E41666666C6F79F5941333333337F572E41CDCCCC4C04A059410000000030572E41000000600EA0594166666666E1562E413333333321A05941666666669B562E416666664621A059419A99999987562E41CDCCCCCC23A05941000000007F562E41CDCCCC8C36A059413333333389562E41666666463AA059419A999999F7562E41666666A641A059419A99999951572E41CDCCCC8C41A059410000000070572E41333333934AA059419A99999929572E419A9999B955A0594133333333D9562E41000000E059A059410000000097562E413333333359A059410000000039562E416666660654A059410000000039562E416666660654A05941	01010000206A080000548E8769D9612E41666666D6659F5941	900090101	H	Sud	9000901	90009	90	27	4
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	01060000206A080000010000000103000000010000005E00000033333333B35B2E4133333353B1A059419A999999485D2E41CDCCCCCCB7A059419A999999705D2E41666666C6B7A05941000000007A5D2E4166666606AFA05941CDCCCCCC3D5D2E4133333353ABA05941CDCCCCCC5A5D2E41CDCCCCCC9EA05941CDCCCCCC825D2E41666666C69EA0594166666666785F2E41333333B3B9A05941000000006F5F2E4133333373C2A0594166666666F05E2E41CDCCCC4CF3A059419A999999185F2E41666666C6F5A059416666666639602E4133333373E6A05941000000009D602E419A9999D9E3A059410000000070612E41000000A0F2A059419A999999EC622E413333333301A15941CDCCCCCC50632E413333339303A15941CDCCCCCC7A632E4133333353F9A0594100000000AE632E4100000080E5A0594100000000E8632E4100000020C6A05941CDCCCCCC24642E419A999959B0A059416666666660642E413333339395A05941CDCCCCCC71642E416666668690A059410000000082652E41333333138BA05941CDCCCCCC9E652E41CDCCCCCC7AA0594100000000B1652E41CDCCCC4C5FA059419A999999AF652E41CDCCCC8C4CA0594166666666EB652E41000000404BA05941CDCCCCCC72662E41666666A607A059416666666699662E4100000020F69F59419A99999998662E4100000060E89F59413333333350662E419A999979C59F59410000000053662E419A999939BF9F5941333333338E652E4100000080AE9F594100000000D2642E41666666669C9F5941CDCCCCCC7C642E419A9999D9929F59419A9999991F642E41000000A09C9F59419A999999DF632E419A999999969F59419A999999B9632E41333333739C9F594100000000A1632E41000000609A9F59413333333328632E4100000040AE9F594133333333F5622E4100000020B49F59410000000014632E419A999959BA9F59419A999999DA622E419A999979BD9F5941000000009A622E4166666646C49F59419A999999E6622E4100000060D09F59413333333396622E41000000E0DB9F59419A9999995F622E4100000060D39F59413333333348622E41CDCCCCACD69F59419A9999997B622E41666666A6DD9F59419A99999960622E4133333333E39F59413333333322622E41CDCCCC2CDC9F5941CDCCCCCCC5612E4100000040CE9F594133333333A6612E41CDCCCC4CC69F594166666666A0612E41CDCCCC2CB79F5941666666665E612E41333333F3B69F5941666666665E612E41000000E0B19F5941CDCCCCCC19612E419A999999B39F5941CDCCCCCC1D612E4100000000B19F594133333333CD602E4166666626A89F594100000000F1602E41000000209C9F59419A999999CA602E41CDCCCC0C999F5941CDCCCCCCAA602E41CDCCCC8C9E9F59410000000098602E41333333939C9F59416666666678602E41CDCCCCECA19F5941CDCCCCCC54602E41000000409E9F5941666666664A602E4100000020A09F5941CDCCCCCC27602E41666666A69C9F5941CDCCCCCCF35F2E4166666686A29F59419A999999385F2E41CDCCCC2CAF9F5941CDCCCCCC7F5F2E419A999979B99F5941CDCCCCCC255F2E419A999919C29F594100000000005F2E41CDCCCCCCBE9F5941CDCCCCCCE95E2E4100000000C39F594166666666145E2E41333333B3D29F5941CDCCCCCC0D5E2E4100000080D89F594100000000F45D2E41CDCCCC4CDE9F594133333333665D2E4166666626E99F594100000000605C2E41CDCCCC0C01A0594133333333065C2E419A9999B90AA059419A999999535C2E41000000E013A0594166666666275C2E41666666261AA0594166666666CA5C2E41000000C02BA0594100000000CC5C2E41CDCCCC8C2CA059419A999999505C2E41000000A03DA0594133333333675C2E416666666643A0594166666666AD5C2E41000000204AA05941333333336A5C2E413333331353A05941666666660F5C2E41333333F363A05941CDCCCCCCFF5B2E419A9999B969A05941CDCCCCCCFD5B2E41CDCCCC4C83A0594100000000EE5B2E413333335394A0594133333333D45B2E41000000609DA0594133333333B35B2E4133333353B1A0594133333333B35B2E4133333353B1A05941	01010000206A080000D0D5D7DC4A612E41000000B04AA05941	900090102	H	Nord	9000901	90009	90	27	1
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	01060000206A080000010000000103000000010000001D000000333333339F252E41CDCCCC6C5BAF594100000000D9252E41333333B35DAF594166666666B2262E419A99997964AF59413333333360272E410000002069AF5941333333337B272E41CDCCCCEC68AF5941333333337F272E41333333D359AF5941CDCCCCCC96272E41CDCCCCEC44AF594166666666C1272E41000000E031AF594166666666DC272E41000000002AAF59419A9999992A282E419A9999D918AF594133333333EC282E4166666686F8AE5941CDCCCCCC3F292E419A9999D9EBAE594100000000B8292E4166666606DDAE594100000000B3282E41000000C0C7AE5941CDCCCCCC4E282E4133333373DCAE59410000000005282E41000000A0EAAE594166666666CE262E41CDCCCCCCE4AE59419A999999B1262E4100000020E6AE5941000000009F262E41CDCCCC4CDBAE59410000000085262E419A9999F9E4AE59410000000072262E41CDCCCCACF6AE5941666666665A262E41666666E6FDAE5941000000002A262E413333337308AF5941CDCCCCCC28262E41000000400CAF59419A9999996B262E41000000801AAF59419A99999942262E41666666C628AF594133333333EB252E413333333343AF5941333333339F252E41CDCCCC6C5BAF5941333333339F252E41CDCCCC6C5BAF5941	01010000206A080000DAC64F7F49272E416666664617AF5941	900100203	H	Résidences Zaporojie Nord	9001002	90010	90	27	0
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	01060000206A080000010000000103000000010000001A000000000000009F262E41CDCCCC4CDBAE59419A999999B1262E4100000020E6AE594166666666CE262E41CDCCCCCCE4AE59410000000005282E41000000A0EAAE5941CDCCCCCC4E282E4133333373DCAE594100000000B3282E41000000C0C7AE594100000000B8292E4166666606DDAE594166666666112A2E41CDCCCC4CCEAE5941CDCCCCCC6A2A2E419A9999D9BCAE5941CDCCCCCCA42A2E41CDCCCCECAEAE594100000000F72A2E41CDCCCC0C92AE594166666666272B2E419A9999198AAE5941CDCCCCCC762B2E419A9999B983AE594100000000292C2E41000000207EAE594166666666222C2E41333333536DAE594166666666062A2E41000000A07EAE594100000000C0292E41666666A68AAE59419A9999991A292E416666664681AE594166666666A2282E416666662697AE594133333333FC272E4100000020BAAE59419A999999AF272E41333333B3D6AE59413333333389272E41333333B3DDAE59416666666658272E4133333373D7AE5941666666661D272E41666666E6E2AE5941000000009F262E41CDCCCC4CDBAE5941000000009F262E41CDCCCC4CDBAE5941	01010000206A0800002E55AA7C87292E4100000080A7AE5941	900100204	H	Résidences Zaporojie Sud	9001002	90010	90	27	0
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	01060000206A08000001000000010300000001000000250000009A999999C4252E41000000E053B159410000000051262E41CDCCCCEC52B15941666666668A262E419A99997955B15941333333332C272E41333333B361B159419A99999996272E419A99995968B15941CDCCCCCC2C282E41333333F36FB15941CDCCCCCC80282E413333337377B1594100000000CD282E41333333D379B15941333333334D292E419A9999597AB1594133333333B92A2E419A9999F907B159419A999999BF2B2E4133333393B6B0594166666666482C2E41000000A08AB0594133333333FB2C2E419A9999B953B059419A9999998D2D2E416666662625B05941CDCCCCCC9E2C2E41CDCCCC2C19B0594133333333FD2A2E419A99993906B059419A999999BB292E4100000060F8AF5941000000006D292E41666666A6F4AF59413333333313292E41666666E61CB059419A9999995A282E410000000068B0594166666666F9272E41CDCCCCEC90B0594100000000E8272E410000006094B059413333333371272E41666666269AB05941CDCCCCCC40262E4100000020A6B05941333333330D262E41CDCCCCCCA8B0594133333333EC252E41000000C0ADB0594133333333E5252E4100000040B8B05941CDCCCCCCFB252E41333333F3C3B0594166666666F3252E41CDCCCCECCDB05941CDCCCCCCCF252E41CDCCCCECD1B0594133333333F1252E419A999959EBB059419A9999990A262E419A99999903B159413333333306262E41666666061AB1594133333333F6252E41CDCCCC4C39B159419A999999CC252E410000008053B159419A999999C4252E41000000E053B159419A999999C4252E41000000E053B15941	01010000206A080000DC5209A8D0282E419A999969B7B05941	900100205	A	Alstom-Technopole	9001002	90010	90	27	1
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	01060000206A080000010000000103000000010000001C000000333333337B272E41CDCCCCEC68AF594133333333B0272E41333333936BAF5941000000001E292E419A99993976AF59419A9999998A292E41CDCCCCEC78AF5941CDCCCCCC722A2E41666666C67FAF594133333333EA2A2E410000006082AF594100000000152B2E410000000082AF5941CDCCCCCCE72B2E410000002074AF594166666666FA2C2E419A99997961AF5941333333331F2D2E41000000605FAF594100000000172E2E41000000E054AF5941333333337B2D2E41666666460BAF594166666666312D2E4166666686E6AE5941CDCCCCCC122D2E41333333D3E9AE5941CDCCCCCC5D2C2E4166666686F9AE594133333333132C2E419A999999FBAE594133333333822B2E41666666E608AF594133333333632B2E41CDCCCC2C11AF59419A999999402B2E41CDCCCCEC2CAF5941CDCCCCCC302B2E41CDCCCCEC3FAF5941666666666D2B2E41CDCCCC6C42AF59419A999999582B2E413333339357AF5941333333333F2A2E416666666652AF594166666666422A2E419A99991947AF5941CDCCCCCCAC272E41666666C63AAF59410000000089272E41666666A64DAF5941333333337B272E41CDCCCCEC68AF5941333333337B272E41CDCCCCEC68AF5941	01010000206A0800007AD14E39862C2E41343333C334AF5941	900100301	H	Résidences Braille	9001003	90010	90	27	0
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	01060000206A0800000100000001030000000100000022000000CDCCCCCCAC272E41666666C63AAF594166666666422A2E419A99991947AF5941333333333F2A2E416666666652AF59419A999999582B2E413333339357AF5941666666666D2B2E41CDCCCC6C42AF5941CDCCCCCC302B2E41CDCCCCEC3FAF59419A999999402B2E41CDCCCCEC2CAF594133333333632B2E41CDCCCC2C11AF594133333333822B2E41666666E608AF594133333333132C2E419A999999FBAE5941CDCCCCCC5D2C2E4166666686F9AE5941CDCCCCCC122D2E41333333D3E9AE594166666666312D2E4166666686E6AE594100000000C02D2E4166666606D3AE594166666666712D2E41CDCCCCCCC7AE594166666666482D2E419A999959C3AE594166666666BD2C2E419A9999D9B9AE5941CDCCCCCC5B2C2E419A999999ACAE5941333333333B2C2E41CDCCCCECA0AE594133333333302C2E416666662695AE594100000000292C2E41000000207EAE5941CDCCCCCC762B2E419A9999B983AE594166666666272B2E419A9999198AAE594100000000F72A2E41CDCCCC0C92AE5941CDCCCCCCA42A2E41CDCCCCECAEAE5941CDCCCCCC6A2A2E419A9999D9BCAE594166666666112A2E41CDCCCC4CCEAE594100000000B8292E4166666606DDAE5941CDCCCCCC3F292E419A9999D9EBAE594133333333EC282E4166666686F8AE59419A9999992A282E419A9999D918AF594166666666DC272E41000000002AAF5941CDCCCCCCAC272E41666666C63AAF5941CDCCCCCCAC272E41666666C63AAF5941	01010000206A08000054555535242B2E419A999929EBAE5941	900100302	H	Résidences Rome	9001003	90010	90	27	0
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	01060000206A080000010000000103000000010000001A00000066666666312D2E4166666686E6AE5941333333337B2D2E41666666460BAF594100000000172E2E41000000E054AF594133333333E52E2E41000000C04BAF5941CDCCCCCC162F2E41CDCCCC0C4AAF5941CDCCCCCC452F2E41CDCCCCEC4AAF59410000000005302E41000000805BAF59416666666626302E41333333334CAF59413333333330302E41333333D341AF59413333333346302E41CDCCCC4C35AF5941333333332A302E419A999999F7AE5941CDCCCCCC8B302E4100000040D6AE59419A9999996D312E41666666A68FAE5941CDCCCCCC97312E41666666267FAE594133333333A2312E419A99993976AE59419A999999A1312E41CDCCCC0C6DAE5941000000007C312E419A9999996CAE59419A9999991C312E419A99991976AE594100000000ED302E413333331378AE594166666666CB302E41666666667EAE59410000000048302E41666666E68CAE59419A999999842E2E4166666686BBAE5941CDCCCCCC3F2E2E41CDCCCC8CC6AE594100000000C02D2E4166666606D3AE594166666666312D2E4166666686E6AE594166666666312D2E4166666686E6AE5941	01010000206A08000050CD8FB9E12E2E4134333323E1AE5941	900100303	H	Pépinière 1	9001003	90010	90	27	0
01060000206A0800000100000001030000000100000070000000CDCCCCCC2A2C2E41000000E081AE5941000000002C2C2E41CDCCCCEC83AE59419A9999992D2C2E419A9999198BAE5941CDCCCCCC2D2C2E41333333738CAE5941333333332E2C2E41CDCCCCCC8DAE594133333333302C2E416666662695AE59419A999999312C2E413333335397AE594166666666342C2E41CDCCCC4C9BAE594166666666372C2E41333333139EAE5941333333333B2C2E41CDCCCCECA0AE594100000000492C2E41CDCCCCCCA6AE594100000000522C2E41666666A6A9AE5941CDCCCCCC5B2C2E419A999999ACAE5941333333337F2C2E41CDCCCC4CB2AE5941CDCCCCCCA72C2E41000000C0B7AE594166666666BD2C2E419A9999D9B9AE594166666666012D2E4166666626BEAE594166666666482D2E419A999959C3AE594166666666712D2E41CDCCCCCCC7AE59419A999999A92D2E41666666A6CFAE594100000000C02D2E4166666606D3AE594166666666E82D2E4133333313CFAE594133333333132E2E41666666C6CAAE594100000000302E2E41CDCCCC4CC8AE5941CDCCCCCC3F2E2E41CDCCCC8CC6AE594100000000552E2E41666666E6C2AE594166666666602E2E4166666626C1AE594133333333742E2E419A999919BEAE59419A999999842E2E4166666686BBAE594166666666922E2E419A999919BAAE5941CDCCCCCCAE2E2E4133333333B7AE594166666666EA2E2E419A999939B1AE59419A999999F12E2E4100000080B0AE5941333333330D2F2E41CDCCCC6CADAE5941333333334B2F2E419A999919A7AE5941CDCCCCCC7E2F2E41666666C6A1AE5941CDCCCCCCAC2F2E41333333139DAE59419A999999B12F2E41CDCCCC8C9CAE59419A999999C12F2E41CDCCCCCC9AAE594133333333E12F2E416666666697AE594166666666F32F2E41CDCCCC6C95AE59410000000034302E41CDCCCCEC8EAE59410000000048302E41666666E68CAE5941CDCCCCCC8A302E416666668685AE5941CDCCCCCCB3302E41CDCCCC4C81AE594166666666B8302E41000000C080AE594166666666CB302E41666666667EAE594166666666D9302E419A9999197CAE594100000000ED302E413333331378AE59419A99999909312E410000008077AE59419A9999991C312E419A99991976AE59410000000059312E419A99991970AE5941000000007C312E419A9999996CAE59413333333396312E41000000E06AAE59416666666698312E41000000A065AE5941CDCCCCCC99312E419A9999D962AE5941CDCCCCCC99312E416666666662AE59419A999999BC312E41CDCCCC6C62AE594133333333F7312E416666666663AE5941CDCCCCCCED312E413333335360AE594100000000CD312E410000008055AE594100000000AE312E41CDCCCC4C4BAE59413333333393312E416666668642AE5941CDCCCCCC79312E41666666263AAE59413333333361312E41CDCCCCCC21AE59419A9999993D312E4100000080FEAD5941333333332D312E41CDCCCC2CF4AD59410000000018312E4100000040E9AD5941333333339B302E4100000060BAAD5941CDCCCCCCED2F2E4100000060BAAD5941CDCCCCCCF22E2E41CDCCCC0CBAAD59419A999999892E2E41666666A6B6AD594100000000702E2E41CDCCCC2CC3AD594100000000912E2E419A999939C7AD5941CDCCCCCCDD2D2E41CDCCCC0CCEAD59419A9999999D2D2E41CDCCCC2CDCAD5941333333336E2D2E41666666C6E2AD5941000000006B2D2E4166666666E7AD5941CDCCCCCC682D2E4133333353EAAD594166666666672D2E41CDCCCC6CECAD594133333333652D2E4100000080EFAD594100000000642D2E41666666A6F1AD594166666666552D2E413333335306AE5941CDCCCCCC512D2E41CDCCCC6C0BAE5941333333336F2D2E41333333530CAE594133333333AE2D2E41333333330EAE5941CDCCCCCCCD2D2E41333333F30EAE594100000000DD2D2E41CDCCCC2C0FAE594100000000AA2D2E41666666861DAE5941666666667C2D2E419A9999392AAE5941CDCCCCCC512D2E419A9999D936AE594100000000412D2E41666666463AAE594133333333302D2E41333333F33EAE594100000000282D2E413333337341AE5941666666661A2D2E416666660644AE5941000000000C2D2E413333333347AE59419A999999F82C2E41333333734BAE594133333333F52C2E41333333334DAE594166666666C82C2E416666662659AE594133333333AC2C2E41CDCCCCAC62AE594133333333BA2C2E410000000064AE594166666666E02C2E41666666E666AE594133333333ED2C2E410000006069AE5941CDCCCCCCFB2C2E41333333936DAE59419A999999082D2E41000000E072AE594133333333D62C2E416666668676AE594166666666C22C2E41666666E677AE59419A999999B42C2E41666666E678AE59419A9999997C2C2E41000000A07CAE5941666666664C2C2E419A9999D97FAE594100000000452C2E41CDCCCC4C80AE5941CDCCCCCC2A2C2E41000000E081AE5941	01060000206A0800000100000001030000000100000025000000CDCCCCCC2A2C2E41000000E081AE594133333333302C2E416666662695AE5941333333333B2C2E41CDCCCCECA0AE5941CDCCCCCC5B2C2E419A999999ACAE594166666666BD2C2E419A9999D9B9AE594166666666482D2E419A999959C3AE594166666666712D2E41CDCCCCCCC7AE594100000000C02D2E4166666606D3AE5941CDCCCCCC3F2E2E41CDCCCC8CC6AE59419A999999842E2E4166666686BBAE59410000000048302E41666666E68CAE594166666666CB302E41666666667EAE594100000000ED302E413333331378AE59419A9999991C312E419A99991976AE59413333333396312E41000000E06AAE5941CDCCCCCC99312E416666666662AE594133333333F7312E416666666663AE5941CDCCCCCC79312E41666666263AAE59419A9999993D312E4100000080FEAD59410000000018312E4100000040E9AD5941333333339B302E4100000060BAAD5941CDCCCCCCF22E2E41CDCCCC0CBAAD59419A999999892E2E41666666A6B6AD594100000000702E2E41CDCCCC2CC3AD594100000000912E2E419A999939C7AD5941CDCCCCCCDD2D2E41CDCCCC0CCEAD59419A9999999D2D2E41CDCCCC2CDCAD5941333333336E2D2E41666666C6E2AD5941CDCCCCCC512D2E41CDCCCC6C0BAE594100000000DD2D2E41CDCCCC2C0FAE5941CDCCCCCC512D2E419A9999D936AE59419A999999F82C2E41333333734BAE594133333333AC2C2E41CDCCCCAC62AE594166666666E02C2E41666666E666AE59419A999999082D2E41000000E072AE5941CDCCCCCC2A2C2E41000000E081AE5941CDCCCCCC2A2C2E41000000E081AE5941	01010000206A080000C04D31EA572F2E41CCCCCC9C45AE5941	900100304	H	Pépinière 2	9001003	90010	90	27	1
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	01060000206A08000001000000010300000001000000140000009A999999BF2B2E4133333393B6B05941CDCCCCCC3D2C2E41CDCCCC0CBDB0594100000000E62B2E41CDCCCC6CD6B05941333333333D2C2E41666666A6D9B0594100000000452D2E4133333333E2B0594133333333E32D2E41000000C0E6B0594133333333512F2E41CDCCCC6CF3B059416666666647302E4100000060C1B05941CDCCCCCC7F302E41000000C0B6B059419A99999970312E41666666666AB05941CDCCCCCCF82F2E419A99993961B0594100000000F62E2E41333333735AB0594133333333AE2E2E410000000059B0594100000000CF2E2E41666666A646B05941666666662D2E2E41666666E650B059419A9999991A2D2E419A9999F962B059419A999999B32C2E419A99993969B0594100000000FE2B2E4133333333A2B059419A999999BF2B2E4133333393B6B059419A999999BF2B2E4133333393B6B05941	01010000206A08000080649DEB7B2E2E419A99996999B05941	900100401	H	Châteaudun 1	9001004	90010	90	27	0
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	01060000206A08000001000000010300000001000000320000009A999999B32C2E419A99993969B059419A9999991A2D2E419A9999F962B05941666666662D2E2E41666666E650B0594100000000CF2E2E41666666A646B0594133333333AE2E2E410000000059B0594100000000F62E2E41333333735AB05941CDCCCCCCF82F2E419A99993961B059419A99999970312E41666666666AB05941CDCCCCCC7F302E41000000C0B6B059416666666647302E4100000060C1B0594133333333512F2E41CDCCCC6CF3B05941333333330D302E41000000E0FAB059413333333326302E4166666646FBB05941CDCCCCCC06302E41CDCCCC6CFFB059416666666652302E41666666A602B15941CDCCCCCC0D312E413333339313B15941CDCCCCCCBD312E4100000020F8B059419A9999996E322E41CDCCCCECDFB0594100000000CA322E41666666E6CCB0594166666666B2332E419A99997994B059419A9999990B342E41666666867BB059413333333344342E410000002061B0594133333333A8342E41000000403CB059419A999999B1342E419A99997932B0594100000000A7342E41666666062BB05941CDCCCCCC88342E416666660624B059413333333352342E41333333531BB059416666666602342E41666666C60AB059416666666699332E4166666626FAAF59413333333381332E41333333B3F3AF59419A9999996D332E4166666686E8AF5941CDCCCCCC41332E41333333B3C1AF5941CDCCCCCC3B332E419A9999F9A7AF59410000000045332E41CDCCCCCCA0AF594166666666F9322E419A9999199CAF594100000000E4322E41000000E0A5AF594100000000A9322E41666666A6D6AF59419A9999997A322E4100000040F5AF59410000000065322E41CDCCCCEC12B059419A9999992A322E419A9999F912B0594133333333EA312E41CDCCCC0C11B0594100000000A0312E413333337308B0594133333333A1312E410000008005B05941000000001F312E413333331303B0594166666666E92E2E419A9999D9F9AF594133333333252E2E419A999919F6AF5941333333334A2D2E41000000403AB0594133333333FB2C2E419A9999B953B059419A999999B32C2E419A99993969B059419A999999B32C2E419A99993969B05941	01010000206A080000B0E417AB87312E413433336357B05941	900100402	H	Châteaudun 2	9001004	90010	90	27	1
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	01060000206A080000010000000103000000010000001900000033333333252E2E419A999919F6AF594166666666E92E2E419A9999D9F9AF5941000000001F312E413333331303B0594133333333A1312E410000008005B0594100000000A0312E413333337308B0594133333333EA312E41CDCCCC0C11B059419A9999992A322E419A9999F912B059410000000065322E41CDCCCCEC12B059419A9999997A322E4100000040F5AF594100000000A9322E41666666A6D6AF594100000000E4322E41000000E0A5AF594166666666F9322E419A9999199CAF5941CDCCCCCCD1322E413333339397AF59419A99999965322E419A9999398FAF5941CDCCCCCCF8312E41CDCCCCCC84AF5941CDCCCCCC7E312E41000000207AAF5941CDCCCCCC35312E41333333536BAF59419A999999BE302E41666666866BAF5941333333330B302E41CDCCCC0C5CAF59419A999999E52F2E410000002069AF5941CDCCCCCC692F2E41CDCCCCAC90AF59419A999999212F2E4133333373A6AF5941CDCCCCCCD02E2E41CDCCCC8CC0AF594133333333252E2E419A999919F6AF594133333333252E2E419A999919F6AF5941	01010000206A08000028AFA19CE8302E419A999949B2AF5941	900100403	H	Bougenel-Quatre As	9001004	90010	90	27	0
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	01060000206A08000001000000010300000001000000300000000000000005302E41000000805BAF59419A999999BE302E41666666866BAF5941CDCCCCCC35312E41333333536BAF5941CDCCCCCC7E312E41000000207AAF5941CDCCCCCCF8312E41CDCCCCCC84AF59419A99999965322E419A9999398FAF5941CDCCCCCCD1322E413333339397AF594166666666F9322E419A9999199CAF59410000000045332E41CDCCCCCCA0AF5941CDCCCCCC58332E416666660697AF59413333333384332E416666666688AF594166666666B5332E41333333537FAF5941CDCCCCCC28342E410000002070AF59419A99999996342E419A99993959AF594100000000CB342E419A9999D942AF59419A999999E4342E41CDCCCC4C3AAF5941CDCCCCCC58352E41CDCCCC6C1BAF5941000000009A352E41CDCCCC6C08AF594133333333F5352E41333333D3F0AE59419A9999991E362E41CDCCCCACE2AE59410000000073362E4133333333A0AE5941666666667C362E41CDCCCC6C90AE59413333333378362E416666666686AE59416666666668362E41666666067DAE5941CDCCCCCC4B362E41000000A064AE59419A9999994F362E416666664655AE5941000000005B362E41666666064EAE5941333333338D362E41666666863DAE59410000000073352E41666666E62EAE59413333333363352E41CDCCCCEC35AE5941CDCCCCCC34352E410000002043AE594166666666DC342E413333337353AE5941666666661E342E41666666E66EAE59419A99999979332E41666666A660AE594133333333F7312E416666666663AE5941CDCCCCCC99312E416666666662AE59413333333396312E41000000E06AAE59419A999999A1312E41CDCCCC0C6DAE594133333333A2312E419A99993976AE5941CDCCCCCC97312E41666666267FAE59419A9999996D312E41666666A68FAE5941CDCCCCCC8B302E4100000040D6AE5941333333332A302E419A999999F7AE59413333333346302E41CDCCCC4C35AF59413333333330302E41333333D341AF59416666666626302E41333333334CAF59410000000005302E41000000805BAF59410000000005302E41000000805BAF5941	01010000206A0800003CE6835937332E4166666606E7AE5941	900100501	H	Faubourg de Montbéliard	9001005	90010	90	27	1
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	01060000206A08000001000000010300000001000000330000009A99999919252E4166666606E7B159410000000033252E4166666666F6B159413333333331252E41000000E007B25941333333337C252E419A9999390BB259416666666681252E41666666A607B259413333333383292E41666666E625B25941CDCCCCCC9F292E41CDCCCC0C26B25941666666662F2D2E419A99991925B2594100000000562D2E419A9999D925B2594133333333812D2E41666666061BB2594133333333822D2E41000000A012B25941CDCCCCCC9A2D2E41CDCCCCEC00B2594133333333B32D2E41333333D3F9B1594133333333EF2D2E419A999999EEB15941000000000C2E2E4166666626EBB159419A999999CD2E2E4100000080D7B1594100000000F42E2E419A999979D1B1594100000000122F2E41333333B3C7B1594133333333002E2E4100000060BBB1594166666666402D2E41CDCCCC6CB4B1594100000000C72C2E4166666606B1B15941CDCCCCCC072D2E419A99995999B1594133333333A52B2E41CDCCCC6C8AB1594100000000562B2E419A99999997B15941333333331A2B2E410000000099B1594100000000672A2E419A999939A0B15941000000005B292E419A9999D9ABB1594133333333C1282E419A9999F9B2B159419A99999993282E4166666606B4B15941333333334D292E419A9999597AB1594100000000CD282E41333333D379B15941CDCCCCCC80282E413333337377B15941CDCCCCCC2C282E41333333F36FB159419A99999996272E419A99995968B15941333333332C272E41333333B361B15941666666668A262E419A99997955B159410000000051262E41CDCCCCEC52B15941CDCCCCCCD5252E41666666C653B159419A999999E4252E41000000A05FB15941CDCCCCCC1A262E419A9999D974B159413333333342262E41666666868EB159413333333330262E41000000209AB159419A999999F4252E41CDCCCC2CA9B1594133333333B1252E41666666C6B4B1594100000000AA252E4100000000BEB1594133333333C2252E4166666646C8B159419A999999D5252E419A9999B9DEB15941CDCCCCCCC2252E4166666626E4B159419A9999999C252E41000000C0E5B159419A99999919252E4166666606E7B159419A99999919252E4166666606E7B15941	01010000206A08000045444449E3292E41000000B0BCB15941	900100101	H	Méchelle-Allende	9001001	90010	90	27	1
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	01060000206A08000001000000010300000001000000220000009A99999993282E4166666606B4B1594133333333C1282E419A9999F9B2B15941000000005B292E419A9999D9ABB1594100000000672A2E419A999939A0B15941333333331A2B2E410000000099B1594100000000562B2E419A99999997B1594133333333A52B2E41CDCCCC6C8AB15941CDCCCCCC072D2E419A99995999B1594100000000C72C2E4166666606B1B1594166666666402D2E41CDCCCC6CB4B1594133333333002E2E4100000060BBB1594100000000122F2E41333333B3C7B15941666666661E2F2E4100000040BBB15941666666661C2F2E4166666626AFB159419A9999993A2F2E4133333333A8B1594133333333B22F2E41666666069EB159413333333353302E41333333D37CB15941CDCCCCCC63302E41CDCCCCEC73B159419A99999973302E419A99993964B15941333333331C302E41333333B35EB15941CDCCCCCC292F2E41CDCCCC8C48B1594166666666FE2D2E416666660631B15941CDCCCCCC0E2E2E41333333132EB159419A999999BC2D2E41666666662AB1594133333333902C2E41333333B32CB159419A999999D32A2E41333333F330B15941333333332C2B2E416666660616B1594100000000472B2E41CDCCCCAC08B15941CDCCCCCC012B2E41666666060BB1594133333333C92A2E41CDCCCCCC11B15941666666669E2A2E41CDCCCC6C10B159413333333311292E419A9999398DB159419A99999993282E4166666606B4B159419A99999993282E4166666606B4B15941	01010000206A080000C8956F8BFF2C2E416666666666B15941	900100102	H	1re Armée	9001001	90010	90	27	0
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	01060000206A0800000100000001030000000100000021000000666666669E2A2E41CDCCCC6C10B1594133333333C92A2E41CDCCCCCC11B15941CDCCCCCC012B2E41666666060BB1594100000000472B2E41CDCCCCAC08B15941333333332C2B2E416666660616B159419A999999D32A2E41333333F330B1594133333333902C2E41333333B32CB159419A999999BC2D2E41666666662AB15941CDCCCCCC0E2E2E41333333132EB1594166666666FE2D2E416666660631B15941CDCCCCCC292F2E41CDCCCC8C48B15941333333331C302E41333333B35EB159419A99999973302E419A99993964B159416666666678302E41333333F35CB15941666666666A302E41000000604CB159410000000043302E419A9999F93DB15941666666664B302E41CDCCCCAC2DB159416666666671302E41666666C627B15941333333339C302E410000002024B15941CDCCCCCC0D312E413333339313B159416666666652302E41666666A602B15941CDCCCCCC06302E41CDCCCC6CFFB059413333333326302E4166666646FBB05941333333330D302E41000000E0FAB0594133333333512F2E41CDCCCC6CF3B0594133333333E32D2E41000000C0E6B0594100000000452D2E4133333333E2B05941333333333D2C2E41666666A6D9B0594100000000E62B2E41CDCCCC6CD6B05941CDCCCCCC3D2C2E41CDCCCC0CBDB059419A999999BF2B2E4133333393B6B05941666666669E2A2E41CDCCCC6C10B15941666666669E2A2E41CDCCCC6C10B15941	01010000206A080000ECB7FF62032E2E41000000000EB15941	900100103	H	Marché-Vosges	9001001	90010	90	27	0
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	01060000206A0800000100000001030000000100000036000000666666664E242E41666666C6ACAF59410000000081242E41000000C0AFAF594166666666B4242E419A999959AEAF594166666666D4242E41000000E0A8AF5941CDCCCCCC0B252E419A9999F9A6AF594100000000B2252E4166666646A7AF59410000000045262E4100000080A4AF59413333333391262E41CDCCCCCCA3AF5941CDCCCCCC57272E4133333353A3AF59410000000074272E4166666666A1AF59416666666677272E4133333353A8AF59416666666664272E419A999999AAAF59419A99999937272E4133333333B9AF5941CDCCCCCC08272E4166666626CCAF594133333333FD262E419A999959D5AF59413333333303272E41CDCCCCCCDAAF59416666666637272E41CDCCCC2CE3AF59410000000045282E41CDCCCCACFCAF5941CDCCCCCC8D282E410000004007B059419A999999C1282E419A99991914B0594166666666D7282E41CDCCCC0C1FB0594166666666E1282E41CDCCCC8C31B059413333333313292E41666666E61CB05941000000006D292E41666666A6F4AF59419A999999BB292E4100000060F8AF594133333333FD2A2E419A99993906B05941CDCCCCCC9E2C2E41CDCCCC2C19B059419A9999998D2D2E416666662625B0594166666666322E2E4166666686F2AF594100000000732E2E419A999979DDAF5941CDCCCCCCD02E2E41CDCCCC8CC0AF59419A999999212F2E4133333373A6AF5941CDCCCCCC692F2E41CDCCCCAC90AF59419A999999E52F2E410000002069AF5941333333330B302E41CDCCCC0C5CAF5941CDCCCCCC452F2E41CDCCCCEC4AAF5941CDCCCCCC162F2E41CDCCCC0C4AAF594133333333E52E2E41000000C04BAF5941333333331F2D2E41000000605FAF594166666666FA2C2E419A99997961AF5941CDCCCCCCE72B2E410000002074AF594100000000152B2E410000000082AF594133333333EA2A2E410000006082AF5941CDCCCCCC722A2E41666666C67FAF59419A9999998A292E41CDCCCCEC78AF5941000000001E292E419A99993976AF59413333333360272E410000002069AF594166666666B2262E419A99997964AF594100000000D9252E41333333B35DAF5941333333339F252E41CDCCCC6C5BAF5941CDCCCCCCC8242E41CDCCCCEC9AAF59413333333396242E41333333B39FAF5941666666664E242E41666666C6ACAF5941666666664E242E41666666C6ACAF5941	01010000206A080000E49F2659052B2E41000000E0BCAF5941	900100202	H	Le Mont Sud	9001002	90010	90	27	1
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	01010000206A0800000A3D9B15171B2E41000000A0FDB15941	900100104	D	Salbert	9001001	90010	90	27	5
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	01010000206A080000B61E089DEA242E419A99991954B05941	900100201	H	Le Mont Nord	9001002	90010	90	27	1
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	01010000206A0800000CB2118617372E41CDCCCC9C38AF5941	900100502	H	Vieille Ville-Fourneau	9001005	90010	90	27	1
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	01010000206A080000F6566FF54D3B2E41000000A022AF5941	900100503	H	Glacis du Château	9001005	90010	90	27	1
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	01010000206A0800001F5D8D2D783A2E4100000040F5B05941	900100504	H	Forges-Miotte-Champ de Mars	9001005	90010	90	27	3
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	01010000206A080000F0B31C8227302E4134333353E6A85941	900110000	Z	Bermont	9001100	90011	90	27	3
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	01060000206A080000010000000103000000010000005A00000066666666F9502E41000000A099B059419A99999909522E419A999919B2B0594100000000B8522E4133333353E9B05941000000001C542E41333333931EB159413333333352572E41CDCCCCEC4EB159413333333371592E41CDCCCC2CA1B15941CDCCCCCC445A2E419A999999CBB1594133333333FE5A2E4100000040D9B159419A999999F25B2E4166666646DDB1594166666666DD5B2E4133333353E4B159419A999999575C2E41333333D3E8B15941666666665F5C2E41CDCCCC8CE6B1594100000000A45C2E41CDCCCC2CEBB1594133333333B75C2E4166666626E5B15941000000009A5D2E4100000080DDB159419A999999B25D2E41333333F3E2B159419A999999895F2E4133333353CFB15941CDCCCCCCFA602E419A9999B98AB15941CDCCCCCCB1612E41CDCCCC2C52B15941333333335D622E419A99991954B15941CDCCCCCC6D622E413333331350B1594100000000B0652E416666662692B15941666666668A672E419A9999F9BAB15941333333334A692E4166666606AAB1594100000000D76A2E4166666686A8B1594100000000596C2E41666666E6AAB15941CDCCCCCCC86E2E419A999959C4B15941CDCCCCCC1B702E41333333B3CCB15941CDCCCCCCE8702E4100000020D2B1594166666666AA712E4166666606D8B159419A999999C2712E419A999939DAB159413333333329722E419A999979DDB1594133333333C1722E419A9999D9DEB159419A9999990D742E4133333353E3B159419A9999990F742E419A99999989B159413333333355742E410000006075B15941333333339A742E419A9999795FB1594166666666A9742E410000002054B15941CDCCCCCCAB742E41CDCCCC2C3EB159419A999999CC742E41333333B330B15941CDCCCCCCD5742E413333339325B159419A999999F2742E416666664624B1594100000000EC742E41000000A01CB15941CDCCCCCC09752E410000008019B15941000000005C752E419A9999D90CB15941000000008B752E41CDCCCC2CECB0594166666666B2752E41CDCCCC0CE1B0594133333333B1752E41333333D3DBB05941CDCCCCCCCB752E419A999939D6B0594133333333E1752E4166666626CBB05941CDCCCCCCF5752E419A999999C5B059416666666648762E4166666606B6B05941CDCCCCCC8C762E41CDCCCCCC9EB059413333333387762E419A99999997B0594166666666D3762E413333335390B05941333333335E762E41CDCCCCCC5FB05941666666663C762E41CDCCCCEC55B0594100000000F8752E419A99993922B059419A999999CE752E410000002014B059419A99999976752E419A999979FAAF59410000000059752E41CDCCCCCCEFAF59413333333327752E419A999979EFAF59410000000057732E41CDCCCC2CF0AF59419A999999DA722E41CDCCCCCCF1AF59416666666617722E4100000000FAAF5941CDCCCCCC3D702E419A99997906B0594100000000FC6E2E419A99993911B05941CDCCCCCC396E2E419A9999F914B059419A999999A56D2E41333333F314B0594133333333606D2E413333333314B05941333333338F6B2E4166666686F0AF594133333333EC682E4100000000D1AF5941CDCCCCCCD4662E4166666606DFAF59410000000035652E419A999919CEAF594166666666AF622E41CDCCCCECA8AF59410000000088602E41CDCCCCECDAAF59419A999999E95D2E4133333373E2AF594100000000275D2E419A999939E2AF594166666666455B2E4166666686EFAF594100000000F9592E41CDCCCC4CF3AF594166666666CB572E419A999939F3AF594133333333EF552E41CDCCCCCCEDAF59410000000024532E41000000A0E7AF594166666666F8512E419A9999D9EAAF59413333333329522E410000000025B05941333333331F522E41000000802AB05941CDCCCCCC86512E410000004050B0594100000000FC502E41CDCCCC4C84B0594166666666F9502E41000000A099B0594166666666F9502E41000000A099B05941	01010000206A08000094F59A221D642E41333333C3C9B05941	900120000	Z	Bessoncourt	9001200	90012	90	27	8
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	01010000206A0800000CBCB200A8712E4133333343A9B45941	900130000	Z	Bethonvilliers	9001300	90013	90	27	2
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	01010000206A080000460EAD11C2912E413433330352A75941	900140000	Z	Boron	9001400	90014	90	27	6
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	01010000206A0800009A2499A1012F2E410000002006AB5941	900150000	Z	Botans	9001500	90015	90	27	2
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	01010000206A080000587CC51743652E419A9999A975B75941	900160000	Z	Bourg-sous-Châtelet	9001600	90016	90	27	1
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	01010000206A08000094E47F413B522E4100000080A2A75941	900170000	Z	Bourogne	9001700	90017	90	27	14
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	01060000206A080000010000000103000000010000009D00000033333333436E2E419A99991920A95941CDCCCCCC916E2E410000008030A9594133333333126F2E410000006036A9594133333333976F2E419A9999794DA9594166666666D86F2E41666666064CA959419A9999997E702E419A99999955A959419A999999B3702E416666668655A959410000000079712E413333335362A959419A999999D3712E416666660667A95941CDCCCCCC29722E41000000006DA959419A99999943722E419A9999D971A95941CDCCCCCC5E722E41000000207CA959416666666675722E413333339389A959416666666646722E410000000099A959410000000040722E41CDCCCCAC9EA95941666666666F722E4166666626EAA959419A9999995D722E41CDCCCCECEDA9594166666666C4722E41CDCCCC8CFCA95941CDCCCCCC4D722E416666660603AA59419A999999BD722E410000000010AA59419A9999991F732E419A9999F90CAA5941CDCCCCCC70732E41000000800BAA594166666666CD732E419A99999913AA5941CDCCCCCC04742E41CDCCCC0C1FAA59419A99999903742E41000000C023AA5941CDCCCCCCCB732E41333333D32AAA59419A999999AD732E41000000A036AA59419A99999996732E41000000C03BAA59419A99999969732E41666666863EAA59419A99999968732E419A9999B946AA59416666666689732E41666666A647AA59419A999999C7732E41CDCCCCAC44AA59419A99999901742E41CDCCCC8C46AA5941666666663D742E41CDCCCC4C4DAA5941000000007C742E419A9999994FAA594100000000B9742E41666666264FAA59419A999999F7742E41CDCCCC2C53AA59416666666601752E419A99999959AA594133333333CE742E41000000C05EAA5941CDCCCCCC97742E419A9999B961AA59416666666640742E41CDCCCCCC62AA5941666666661A742E41666666E66FAA5941CDCCCCCC28742E419A9999D971AA5941333333337A742E419A9999B973AA59416666666607752E41000000807EAA59410000000021752E41CDCCCC0C88AA59419A99999935752E419A9999B98BAA5941000000006B752E41CDCCCCCC8EAA5941CDCCCCCC99752E419A9999F98DAA594100000000B4752E41333333D389AA594100000000B8752E41CDCCCCAC80AA5941CDCCCCCC04762E41666666066EAA5941333333332D762E41000000406BAA59410000000064762E419A9999B96EAA5941333333335E762E413333339374AA59416666666634762E41666666E678AA5941CDCCCCCC34762E41CDCCCC8C7EAA5941CDCCCCCCAD762E413333339389AA594133333333D2762E41CDCCCCEC91AA59413333333311772E413333331399AA5941CDCCCCCC94772E4166666606A1AA59419A99999922782E419A9999999CAA59416666666666782E4166666626A2AA59410000000084792E4133333393A1AA594100000000207A2E4166666666B5AA5941CDCCCCCC857A2E4100000020ADAA59419A999999CD7B2E41000000E0CEAA594133333333487C2E419A999919D2AA5941000000004B7D2E4100000060D2AA5941CDCCCCCC997D2E419A999919D5AA5941CDCCCCCC007E2E419A999959D6AA5941333333332F7E2E4166666626D4AA59419A999999917E2E4100000000D3AA594166666666C27E2E41CDCCCCECD4AA594166666666347F2E419A9999F9D2AA594100000000967F2E4100000060C8AA594133333333E07F2E41333333D3C4AA59413333333307802E419A999979C4AA59416666666626802E41CDCCCC6CB4AA5941666666665E802E419A9999D9B2AA59419A99999987802E4100000040AEAA594166666666A8802E419A9999B9A0AA594100000000C3802E41333333F39DAA59419A99999920812E41000000009AAA59410000000068812E41CDCCCCAC95AA5941CDCCCCCCDB812E419A9999D98AAA59410000000017822E410000002087AA594100000000CF822E41CDCCCC0C80AA594133333333B9832E419A9999B977AA594166666666DA832E41CDCCCCEC75AA594133333333FE832E416666662670AA59410000000065842E41666666E668AA59410000000095842E41CDCCCCEC66AA5941CDCCCCCC62852E41333333D361AA594100000000A7852E41000000A062AA59413333333337862E41000000C05DAA59416666666671862E416666666658AA59410000000098862E41CDCCCCEC4EAA594100000000A1862E419A99999940AA59413333333396862E410000002035AA59413333333369862E413333339322AA59419A99999965862E41333333B31DAA59416666666648852E416666664607AA594166666666D2842E41666666A6F2A95941333333335B842E419A999939F6A959413333333396832E4100000000FAA95941CDCCCCCC07832E4166666626F8A959419A99999945822E4166666606F2A959419A99999902822E4166666606F1A9594133333333D3812E4133333353EEA959410000000063802E41CDCCCCECEBA9594166666666E27F2E41CDCCCC8CE8A959419A9999997F7F2E41CDCCCC2CE4A959419A999999037F2E4133333353DCA959419A999999D67D2E41333333B3BAA95941CDCCCCCCB37D2E4100000040B7A9594100000000117D2E4166666606AAA959419A999999D47C2E4100000020A4A959419A999999A07C2E41666666269DA9594166666666967C2E41333333F394A9594133333333C87B2E41CDCCCC8C7FA9594100000000267B2E41CDCCCC4C57A9594166666666BE7A2E41CDCCCC4C39A9594166666666557A2E41333333B31DA95941CDCCCCCC95792E4133333313EAA85941666666660E792E41CDCCCC0CC8A859419A9999996B782E419A9999D99DA85941CDCCCCCC4D782E419A9999D994A85941CDCCCCCCD0772E41666666A67FA859413333333374772E419A9999F972A859410000000014772E410000000064A8594100000000C0762E41000000605AA8594133333333A6762E41666666E654A85941333333336E762E419A9999194DA859416666666638762E41CDCCCC0C42A859419A999999FF752E41CDCCCC8C38A85941CDCCCCCC6B752E41000000C015A85941666666664C752E41CDCCCC2C18A85941CDCCCCCC7E742E41CDCCCC4C23A859419A99999958742E413333335324A859410000000026742E41000000C02BA8594100000000E8732E419A99991931A85941000000008F732E413333333333A859410000000007732E419A99995945A859419A99999914722E413333333358A8594166666666E4712E41666666066DA85941CDCCCCCCBE712E410000008077A8594133333333A9712E419A9999B986A859419A99999991712E41000000C08AA859419A99999965712E41CDCCCC4C8AA8594133333333F6702E41666666E690A8594133333333D56F2E419A999999C2A85941CDCCCCCCCF6E2E41666666C6E8A8594133333333406F2E41CDCCCCACF3A859419A999999046F2E4133333373F8A8594133333333436E2E419A99991920A9594133333333436E2E419A99991920A95941	01010000206A08000060E18640FC762E416666661677A95941	900180000	Z	Brebotte	9001800	90018	90	27	4
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	01010000206A0800003833339B6E862E41666666D610AB5941	900190000	Z	Bretagne	9001900	90019	90	27	5
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	01010000206A0800003CAAC025FF0A2E41666666860BAD5941	900200000	Z	Buc	9002000	90020	90	27	2
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	01060000206A08000001000000010300000001000000B50000009A999999195B2E419A9999995DA9594166666666205B2E413333339367A95941CDCCCCCC285C2E41CDCCCC0C84A959419A999999BA5C2E410000008092A95941000000006C5D2E41CDCCCC0CA2A9594166666666E85F2E4133333353E7A959419A9999999D602E41CDCCCC6CFBA959419A999999B2602E419A99993900AA5941CDCCCCCC92612E41CDCCCC6C49AA59416666666679622E419A9999F952AA594133333333DB622E41666666065BAA59413333333345632E410000000062AA59413333333313642E41333333B371AA5941666666663D642E419A99991973AA59419A9999993B652E41CDCCCC6C8EAA5941000000006B652E41CDCCCC0C98AA59419A99999978662E4100000080C4AA59419A9999991A682E4166666686B9AA59419A99999948692E41333333F3CEAA5941666666666B692E4133333353F9AA594133333333FF692E41000000801DAB59419A999999596B2E41000000E025AB594100000000EE6B2E419A9999192BAB594133333333E86B2E41333333D33EAB59419A9999994D6C2E419A9999593EAB5941CDCCCCCC0E6C2E41CDCCCCCC3AAB594100000000026C2E410000008035AB594133333333FA6B2E416666668627AB59419A9999990C6C2E41CDCCCC6C16AB594100000000F56B2E419A9999D90EAB59419A999999D26B2E419A9999F90FAB594166666666E06B2E41CDCCCC0C05AB594166666666C16B2E4133333313FBAA594166666666AA6B2E41000000E0EDAA594100000000BE6B2E419A9999F9EAAA594133333333BF6B2E41000000C0E3AA5941CDCCCCCCEC6B2E41CDCCCCACD6AA5941000000002E6C2E41000000A0CEAA594133333333946C2E41CDCCCC4CCBAA59419A999999D26C2E4133333333CCAA594166666666F56C2E4100000040C6AA594100000000626D2E4100000020BBAA5941CDCCCCCC656D2E4133333373B3AA594133333333C46D2E419A999919ADAA594133333333F26D2E4166666646ABAA594166666666146E2E4133333393A5AA594100000000176E2E41666666A6A1AA5941333333336A6E2E4100000040A0AA594133333333CE6E2E41CDCCCCAC99AA5941CDCCCCCCDD6E2E41CDCCCC0C95AA5941666666661F6F2E419A99995991AA594166666666256F2E41000000A086AA59419A9999997A6F2E41CDCCCCAC84AA59419A9999995C6F2E410000008076AA5941000000005E6F2E419A9999596DAA5941333333336D6F2E419A9999796BAA5941CDCCCCCCFE6F2E41666666A66CAA59413333333347702E41333333336BAA59419A99999955702E410000008067AA59419A99999947702E41666666265FAA59419A99999955702E41333333D358AA59419A99999937702E41CDCCCC6C52AA59419A9999992B702E419A9999F944AA59413333333332702E41666666E632AA59419A99999942702E41333333D32CAA5941CDCCCCCCD96F2E41000000800BAA594166666666D36F2E4166666666FDA95941CDCCCCCCEE6F2E41CDCCCCACEBA9594133333333A66F2E4166666606DDA9594133333333626F2E4133333333D3A9594166666666436F2E41CDCCCC8CD1A9594133333333E16E2E419A999959D5A9594166666666996E2E41000000E0D4A95941CDCCCCCC586E2E41CDCCCC8CCCA95941333333335A6E2E4166666646C7A9594166666666886E2E41CDCCCC8CC1A9594100000000886E2E4100000080BBA959419A9999996F6E2E419A999999B7A959419A999999FE6D2E4100000020AEA95941CDCCCCCCD66D2E4166666646A6A95941000000004B6D2E4133333373A2A9594100000000E96C2E416666662693A9594133333333E26C2E41CDCCCC8C8BA95941CDCCCCCCF26C2E419A9999B983A9594166666666DF6C2E41000000607AA95941333333338B6C2E41CDCCCCEC77A95941CDCCCCCC916C2E41333333F366A95941CDCCCCCCAB6C2E410000000063A9594166666666AE6C2E416666664658A9594133333333A76C2E41666666664BA95941666666667F6C2E41000000E041A9594133333333086C2E419A99997937A959419A999999E06B2E41CDCCCC0C32A9594166666666DA6B2E419A9999391BA9594100000000A56B2E419A99999916A95941CDCCCCCC026B2E41CDCCCC8C17A959419A999999CE6A2E410000000010A95941CDCCCCCCCA6A2E41CDCCCC6C07A959419A999999D66A2E419A999919FCA859419A999999D76A2E41333333F3F1A859419A999999046B2E4133333393EEA859419A999999436B2E4133333353F5A85941CDCCCCCC6D6B2E41CDCCCC0CF7A8594133333333996B2E419A9999D9F4A8594100000000B06B2E4133333353E9A8594100000000A16B2E4100000040DCA8594133333333966B2E4133333393C7A859419A9999997A6B2E4166666666B7A85941CDCCCCCC7F6B2E41CDCCCCCCA7A85941333333336E6B2E419A9999B9A3A859419A999999026B2E41000000A0A3A8594133333333B36A2E419A999959A9A859419A999999586A2E4133333373A9A85941CDCCCCCC1B6A2E4100000060A7A8594100000000F9692E419A9999F9A1A85941CDCCCCCCA8692E41333333939CA859410000000086692E41CDCCCCCC95A85941000000007F692E41333333138BA85941333333335A692E41CDCCCCEC7AA859419A99999975692E419A99997973A85941666666664F692E41333333D366A85941333333330A692E41333333135FA85941CDCCCCCCEA682E41666666265DA859419A999999A3682E419A9999F94FA859419A99999964682E41666666E645A85941CDCCCCCC45682E410000008037A859416666666609682E41000000E02AA8594100000000B3672E419A9999D91EA859419A99999988672E41000000601CA85941333333330A672E419A9999D91EA8594100000000E0662E419A9999591CA85941CDCCCCCCB3662E41000000C016A85941333333339A662E41666666660DA859416666666674662E419A9999B909A85941333333333F662E41CDCCCC0C08A85941666666660D662E419A9999990BA859410000000005662E413333335317A859419A999999F5652E41CDCCCC6C1BA8594166666666C2652E41CDCCCC2C20A85941CDCCCCCC61652E41CDCCCC6C22A859419A9999993A652E41CDCCCCEC1FA859419A999999EE642E419A99995929A85941CDCCCCCCD7642E410000000031A8594166666666CA642E41333333733AA85941CDCCCCCC24652E419A99995940A859419A99999942652E41666666463EA85941CDCCCCCC5C652E410000000041A859413333333323652E416666664672A859419A999999D6642E419A99995975A859419A999999D3642E41666666C67CA859419A99999978642E41CDCCCC0C7FA85941666666662D642E41CDCCCC4C7EA85941CDCCCCCC08642E41333333F381A8594166666666A8632E413333337387A85941333333336C632E41000000A08FA85941CDCCCCCC4A632E419A99997997A8594100000000EA622E41000000809FA859419A999999B8622E41CDCCCC0C9CA85941CDCCCCCC8F622E41CDCCCC0CA2A85941CDCCCCCC92622E41333333B3AFA8594166666666A5622E41000000E0B5A859416666666677622E41CDCCCC4CB9A859416666666658622E4133333373BFA85941333333332A622E4166666646C5A8594100000000E9612E41666666A6C9A8594100000000AD612E419A999999D0A859410000000097612E41000000E0D4A859416666666665612E4100000020D6A859419A99999905612E419A9999D9DBA859419A999999E0602E4166666646E1A85941CDCCCCCC98602E41666666C6E0A859419A99999959602E41000000C0E4A85941CDCCCCCCF05F2E41CDCCCCECE3A859419A999999545E2E4133333313EFA85941CDCCCCCC765E2E419A9999B906A95941666666660C5D2E41333333131AA9594100000000CF5C2E41333333F321A95941CDCCCCCC925C2E41666666462CA95941000000005A5C2E41333333533AA959419A999999195B2E419A9999995DA959419A999999195B2E419A9999995DA95941	01010000206A0800006073208D70652E4100000050A3A95941	900210000	Z	Charmois	9002100	90021	90	27	4
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	01010000206A0800001D7A2A7041282E41343333B320A75941	900220000	Z	Châtenois-les-Forges	9002200	90022	90	27	9
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	01010000206A080000AE315FB742242E4100000070D0B75941	900230000	Z	Chaux	9002300	90023	90	27	9
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	01010000206A080000D44A3F6115B22E416666660649AA5941	900240000	Z	Chavanatte	9002400	90024	90	27	4
01060000206A08000001000000010300000001000000F90300000000000061932E4100000060CAAA59419A99999961932E4100000020CEAA59410000000066932E419A9999D9CFAA59419A99999970932E41CDCCCCCCD2AA59413333333381932E4166666606D5AA594166666666AE932E419A999959DBAA594166666666F4932E4100000060E6AA5941CDCCCCCCF7932E419A999959E7AA594133333333FE932E41CDCCCC2CE7AA5941000000000A942E41000000E0E6AA59413333333312942E4100000000E7AA5941000000001A942E419A999919E7AA59419A99999926942E4166666606E8AA5941333333332E942E4133333393E8AA59419A99999940942E41CDCCCC0CEBAA59419A99999950942E4100000000EDAA5941CDCCCCCC66942E419A9999B9EEAA5941CDCCCCCC70942E419A9999F9EEAA5941CDCCCCCC86942E41CDCCCC2CEFAA59419A9999995A952E41CDCCCC4CF0AA59419A99999904962E4100000040F1AA5941000000003F962E4166666666F3AA59413333333340962E4133333373F3AA59419A999999F9962E4133333313FCAA59419A999999EA962E419A9999F909AB594133333333E9962E41333333130BAB5941CDCCCCCCCF962E410000006020AB594100000000D9962E41333333D32BAB594166666666CE962E413333339338AB594100000000DB962E41CDCCCC6C3FAB594133333333DB962E41CDCCCC8C3FAB594100000000EF962E41666666264BAB594166666666F2962E41333333334DAB5941CDCCCCCC03972E419A99993957AB5941000000001F972E41CDCCCC0C5EAB5941CDCCCCCC36972E419A9999D95EAB594166666666E0972E41000000A064AB594166666666F3972E41000000E064AB59413333333311982E419A9999D965AB5941000000001D982E413333333366AB59416666666629982E41333333D366AB59413333333343982E419A99991968AB59419A9999994F982E419A99997968AB5941CDCCCCCC60982E41000000C068AB5941333333337D982E41CDCCCC4C69AB59413333333392982E41000000006AAB594166666666A2982E41333333736AAB594133333333B5982E41CDCCCCCC6AAB594166666666EF982E41CDCCCC4C6DAB59416666666634992E413333333372AB59413333333380992E419A9999F978AB594100000000C5992E41CDCCCCEC7DAB5941CDCCCCCC1F9A2E413333337382AB594100000000589A2E419A99999984AB5941000000008C9A2E41333333D385AB594166666666FB9A2E41CDCCCCCC87AB594100000000419B2E416666668688AB594100000000709B2E416666666689AB5941CDCCCCCC109C2E41000000608CAB594133333333169C2E419A9999798CAB5941666666665B9C2E41333333138EAB59419A9999994C9C2E416666660694AB5941000000004A9C2E419A99993995AB594166666666459C2E413333333396AB59419A999999389C2E416666664697AB5941666666662F9C2E413333331398AB5941000000002D9C2E413333335398AB5941666666662B9C2E419A9999B998AB5941666666662B9C2E413333335399AB59419A999999319C2E41333333339AAB594133333333409C2E41000000009CAB5941CDCCCCCC499C2E41666666669EAB5941CDCCCCCC4D9C2E419A999939A0AB59419A9999994D9C2E4100000060A2AB5941666666664C9C2E41CDCCCC6CA5AB5941CDCCCCCC4D9C2E4166666686A6AB594166666666529C2E4166666666A7AB594100000000579C2E41333333D3A7AB59419A9999995E9C2E4133333333A8AB59419A999999689C2E419A9999B9A8AB5941666666666C9C2E419A999919A9AB5941333333336F9C2E4100000020AAAB5941666666666E9C2E41CDCCCCECAAAB5941333333336A9C2E419A999919ACAB5941CDCCCCCC669C2E41000000A0ACAB594133333333639C2E4133333313ADAB594166666666619C2E41CDCCCC6CADAB5941CDCCCCCC629C2E41000000E0ADAB594133333333679C2E4166666646AEAB5941666666666F9C2E419A999979AFAB594166666666739C2E41333333F3B0AB59419A999999759C2E41CDCCCC0CB2AB59419A999999769C2E41333333B3B2AB594133333333789C2E41333333F3B2AB59419A9999997B9C2E4166666646B3AB594133333333809C2E41333333B3B3AB594166666666849C2E419A9999B9B4AB594166666666889C2E419A999939B6AB5941CDCCCCCC899C2E41666666A6B7AB59419A9999998A9C2E4133333333B8AB5941333333338B9C2E419A999999B8AB5941000000008E9C2E41666666E6B8AB59419A999999A49C2E41000000C0BAAB594133333333C39C2E419A999979BDAB59419A999999CE9C2E419A999999BEAB59419A999999D49C2E4166666666BFAB594166666666DA9C2E4166666606C1AB594166666666DF9C2E4166666646C2AB594100000000E49C2E4100000040C3AB5941CDCCCCCCE99C2E41333333F3C3AB594100000000EE9C2E41CDCCCC0CC5AB594166666666FC9C2E41333333D3C7AB59419A999999F89C2E41000000E0C8AB59419A999999F69C2E41CDCCCC2CC9AB594133333333ED9C2E4133333373C9AB594166666666E09C2E4100000080C9AB594133333333DB9C2E41000000A0C9AB594100000000D89C2E41333333D3C9AB5941CDCCCCCCD69C2E4166666606CAAB5941CDCCCCCCD79C2E41CDCCCCCCCAAB59419A999999D89C2E4166666646CBAB594100000000DC9C2E41CDCCCC6CCCAB5941CDCCCCCCDF9C2E419A9999D9CCAB594100000000E69C2E41666666A6CDAB594133333333EC9C2E4166666666CEAB594166666666F19C2E41CDCCCC0CCFAB594100000000F79C2E41333333D3CFAB5941CDCCCCCCFB9C2E41CDCCCCACD0AB5941CDCCCCCCFE9C2E41CDCCCC8CD1AB594166666666019D2E4100000060D2AB59419A999999039D2E41CDCCCC0CD3AB59419A999999049D2E41666666C6D3AB5941CDCCCCCC039D2E419A999959D4AB5941CDCCCCCC009D2E41666666C6D4AB594166666666FD9C2E4166666606D5AB594100000000FA9C2E41CDCCCC6CD5AB594133333333F89C2E41CDCCCCECD5AB594133333333F89C2E419A999979D6AB5941CDCCCCCCF99C2E41CDCCCC0CD7AB5941CDCCCCCCFD9C2E4133333373D7AB59419A999999029D2E419A9999B9D7AB594166666666079D2E41000000E0D7AB5941666666660C9D2E419A9999F9D7AB594166666666129D2E4133333313D8AB5941CDCCCCCC189D2E419A999939D8AB5941CDCCCCCC349D2E41000000C0D9AB5941CDCCCCCC729D2E41CDCCCCACD8AB59419A999999749D2E4133333333DDAB594133333333779D2E419A9999B9DDAB5941333333337A9D2E4133333393DEAB5941666666667C9D2E419A999979DFAB5941CDCCCCCC7C9D2E41CDCCCC6CE0AB5941333333337B9D2E4100000040E1AB59419A999999799D2E419A9999F9E1AB594133333333799D2E419A999999E2AB594133333333799D2E41000000E0E2AB594133333333799D2E41333333F3E2AB594166666666799D2E4133333313E4AB5941666666667B9D2E4100000000E5AB5941CDCCCCCC7E9D2E4166666606E6AB5941CDCCCCCC819D2E4133333313E7AB594166666666859D2E419A999939E8AB594100000000919D2E41333333B3EBAB594133333333999D2E4100000020EEAB5941666666669B9D2E41666666A6EEAB5941333333339F9D2E4133333313F0AB59419A999999A29D2E419A999979F1AB594100000000A79D2E41666666A6F3AB59419A999999AA9D2E41CDCCCC0CF5AB594133333333B09D2E41666666E6F6AB59419A999999B59D2E4100000060F8AB594133333333BF9D2E4133333373FAAB59419A999999C99D2E41000000C0FCAB594100000000D39D2E41CDCCCC0CFFAB594100000000DB9D2E410000000001AC5941CDCCCCCCE49D2E41CDCCCCAC03AC594133333333ED9D2E416666662606AC5941CDCCCCCCF49D2E410000004008AC5941CDCCCCCCFB9D2E419A9999F909AC59419A999999039E2E419A9999D90BAC5941666666660B9E2E41000000800DAC594133333333129E2E419A9999B90EAC594133333333199E2E41CDCCCC2C10AC59419A9999991D9E2E41333333B311AC59419A9999991F9E2E419A99999912AC59419A999999219E2E410000008013AC59419A999999239E2E419A99993914AC594166666666259E2E419A9999F914AC59419A999999289E2E419A99997915AC5941000000002E9E2E41000000E015AC5941CDCCCCCC329E2E416666664616AC59419A999999379E2E41333333B316AC5941000000003C9E2E410000008017AC594100000000409E2E410000006018AC594166666666459E2E416666662619AC59419A9999994B9E2E41666666A619AC59419A999999539E2E41666666461AAC594100000000609E2E41CDCCCCAC1BAC59419A999999679E2E41666666461CAC59419A9999996D9E2E419A9999991CAC594166666666749E2E41CDCCCC2C1DAC59419A9999997B9E2E419A9999391EAC594133333333819E2E41333333531FAC594133333333879E2E419A99999920AC5941666666668E9E2E419A9999F921AC594100000000979E2E413333339323AC5941333333339C9E2E41333333D324AC5941CDCCCCCCA09E2E416666666626AC59419A999999A29E2E413333339327AC594133333333A39E2E41CDCCCCCC28AC59419A999999A19E2E419A99999929AC594133333333A19E2E41000000802AAC594133333333A29E2E41333333532BAC594133333333A79E2E41000000002CAC594166666666AB9E2E41CDCCCC8C2CAC594100000000B19E2E41333333332DAC594133333333B69E2E41333333F32DAC594133333333BA9E2E419A9999B92EAC594100000000BB9E2E41000000602FAC594133333333BA9E2E413333333330AC594166666666BC9E2E413333335331AC5941CDCCCCCCBF9E2E41CDCCCC4C32AC594133333333C39E2E416666662633AC594166666666C79E2E419A99993934AC594100000000CC9E2E413333337335AC594100000000CF9E2E41000000A036AC5941CDCCCCCCD09E2E413333339337AC59419A999999D39E2E41333333D338AC59419A999999D79E2E419A9999193AAC59419A999999DC9E2E41000000E03AAC5941CDCCCCCCE29E2E41CDCCCC6C3BAC59419A999999E99E2E419A9999193CAC594166666666F09E2E41666666063DAC59419A999999F79E2E41CDCCCC6C3EAC5941CDCCCCCCFB9E2E41CDCCCC0C3FAC59419A999999FF9E2E41333333F340AC59419A999999F49E2E41CDCCCC6C42AC5941CDCCCCCCEC9E2E41666666A643AC594133333333F49E2E416666668645AC59419A999999F69E2E410000002047AC594133333333FC9E2E41CDCCCC0C48AC59419A999999F89E2E410000000049AC59419A999999049F2E41000000E049AC5941CDCCCCCC379F2E41333333B355AC5941666666669F9F2E416666662650AC594166666666B29F2E41CDCCCC4C52AC594133333333C19F2E410000006050AC5941CDCCCCCCE89F2E419A9999594CAC5941666666660AA02E41000000E048AC5941000000001EA02E41CDCCCCCC46AC59419A999999BFA12E416666662652AC5941000000000FA22E419A9999B949AC5941CDCCCCCC11A32E41CDCCCCAC58AC59413333333337A32E419A99995959AC59416666666645A32E41000000E055AC594133333333D7A32E41000000A054AC594133333333E5A32E413333339354AC59419A999999E4A32E41333333B353AC594133333333E4A32E416666662652AC594133333333E4A32E41666666C650AC594100000000E4A32E41CDCCCC4C4FAC5941CDCCCCCCE3A32E419A9999F94DAC594166666666E4A32E41CDCCCC4C4CAC5941CDCCCCCCD5A32E419A9999194BAC59419A999999CAA32E41000000804AAC594166666666BFA32E41333333D349AC594100000000B6A32E41CDCCCC4C49AC594133333333A9A32E410000008048AC594166666666AAA32E41333333D347AC594166666666ADA32E413333331347AC594166666666B1A32E410000004046AC5941CDCCCCCCB5A32E416666664645AC594133333333BAA32E41CDCCCC4C44AC594133333333BFA32E413333331343AC594166666666C3A32E413333331342AC5941CDCCCCCCC8A32E41CDCCCC4C40AC5941CDCCCCCCCAA32E419A9999393FAC594166666666CCA32E41000000C03DAC5941CDCCCCCCCAA32E419A9999793CAC594100000000C7A32E41666666C63AAC594166666666C3A32E419A99997939AC5941CDCCCCCCBFA32E419A99993938AC5941CDCCCCCCBAA32E41CDCCCCCC36AC594133333333B6A32E41333333B335AC594133333333B2A32E410000008034AC59419A999999AEA32E419A99993933AC5941CDCCCCCCAAA32E41CDCCCC0C32AC594133333333A7A32E419A9999D930AC5941CDCCCCCCA3A32E41CDCCCCEC2FAC594100000000A1A32E41333333132FAC5941666666669FA32E41666666262EAC59419A9999999FA32E41CDCCCC2C2DAC59419A999999A3A32E41CDCCCC6C2CAC594133333333A9A32E41CDCCCC8C2BAC5941CDCCCCCCAEA32E41CDCCCCAC2AAC5941CDCCCCCCB4A32E41CDCCCCEC29AC5941CDCCCCCCB9A32E410000000029AC59419A999999BDA32E41333333D327AC5941CDCCCCCCBFA32E416666668626AC5941CDCCCCCCBFA32E41666666C625AC59419A999999E6A32E41333333D318AC594100000000D1A42E41333333732BAC5941333333335BA62E41000000404FAC59416666666673A62E41333333D349AC59419A99999983A62E410000000047AC59416666666699A62E41666666E644AC59416666666614A72E419A99993945AC59416666666624A72E41333333F342AC5941CDCCCCCC37A72E416666666645AC59419A9999993EA72E413333333344AC5941CDCCCCCC52A72E416666660640AC5941666666666AA72E41000000E03AAC59419A99999983A72E41CDCCCC2C35AC5941CDCCCCCC97A72E41000000E030AC594166666666ACA72E41000000A02CAC59419A999999BAA72E416666664629AC5941CDCCCCCCC6A72E416666664626AC59419A999999CCA72E419A99997924AC59419A999999CFA72E410000004023AC594133333333D2A72E419A9999D921AC59419A999999D4A72E416666664620AC594133333333D6A72E41CDCCCCEC1EAC59419A999999D9A72E419A9999791DAC594166666666DFA72E419A9999191CAC59419A999999E0A72E41CDCCCCEC1BAC59416666666682A82E41666666661FAC594133333333B1A82E413333331314AC594166666666D3A82E416666664616AC594100000000B4A82E41333333531EAC59419A99999936A92E419A99999923AC59410000000025A92E41000000A026AC59419A9999997EA92E41666666A632AC594133333333B4A92E41000000E039AC5941CDCCCCCCC6A92E419A99995936AC594100000000D6A92E410000000034AC594166666666ECA92E41CDCCCC8C31AC59410000000004AA2E41000000802FAC59419A9999990DAA2E419A9999D92EAC59416666666667AA2E413333339337AC59410000000082AA2E41CDCCCC4C34AC59419A9999999AAA2E41000000C030AC594133333333CEAA2E41CDCCCCAC36AC5941CDCCCCCCBCAA2E41666666263AAC5941666666665CAB2E41CDCCCC2C4BAC594166666666D0AC2E416666668661AC5941CDCCCCCCDFAC2E413333339362AC59413333333349AD2E41666666C669AC5941666666665EAD2E41333333536BAC59419A99999992AD2E41666666C66EAC5941000000009BAE2E413333335377AC5941000000009EAE2E416666668674AC594133333333AFAE2E41CDCCCCEC6DAC59419A999999BCAE2E419A99993969AC5941CDCCCCCCC5AE2E419A9999F965AC594166666666DDAE2E41666666A65DAC594133333333F8AE2E41333333B355AC5941666666660DAF2E41CDCCCC0C4EAC5941CDCCCCCC14AF2E41333333F34AAC5941CDCCCCCC20AF2E416666668647AC5941333333330BB02E41333333535AAC594166666666C1B02E416666666661AC59419A99999933B12E41666666C667AC59413333333365B12E41000000C062AC59416666666673B12E410000000065AC59419A999999C0B12E41333333B35DAC59416666666683B12E41666666C651AC59419A99999961B12E41000000C04AAC59413333333351B12E413333335347AC5941CDCCCCCC2EB12E419A99999941AC59410000000023B12E41CDCCCCCC3EAC59413333333323B12E41666666463BAC59410000000037B12E416666666637AC5941000000003CB12E416666666636AC5941CDCCCCCC45B12E410000002033AC59419A99999945B12E419A9999D930AC594100000000FCB02E41CDCCCC2C25AC59419A9999990DB12E41CDCCCCEC1AAC5941666666660FB12E413333331318AC5941CDCCCCCC0AB12E41CDCCCCEC13AC59419A999999EBB02E419A99997912AC59419A999999DFB02E41CDCCCC4C11AC594133333333E2B02E41666666460CAC5941CDCCCCCCFAB02E410000006005AC59419A9999990BB12E41666666A6FFAB59410000000016B12E4133333313F9AB59419A9999993EB12E4100000080EDAB59419A9999994DB12E41666666C6EEAB59419A99999968B12E419A999939EFAB59410000000086B12E4100000020EFAB59419A999999D9B12E41CDCCCCACF0AB5941CDCCCCCC01B22E419A999919F2AB59419A99999919B22E4100000080F3AB59410000000027B22E41000000E0F4AB59410000000044B22E4166666666FBAB59416666666659B22E4166666686FFAB59416666666678B22E419A99997902AC5941CDCCCCCC8DB22E41000000E004AC594133333333A0B22E41333333B306AC5941CDCCCCCCB0B22E413333333308AC594133333333BBB22E41000000E008AC594100000000C9B22E41333333130AAC59419A999999D9B22E41CDCCCC8C0BAC594100000000E6B22E419A9999D90CAC594133333333F1B22E41333333F30DAC594166666666FBB22E41666666860FAC5941333333330AB32E413333333311AC59410000000016B32E41CDCCCC8C12AC59413333333323B32E416666660614AC5941CDCCCCCC30B32E41666666C615AC59416666666636B32E41333333B316AC5941666666663BB32E41666666E617AC59419A99999940B32E413333337319AC59410000000043B32E419A9999991AAC5941CDCCCCCC44B32E41666666261CAC5941CDCCCCCC44B32E419A9999991DAC59416666666645B32E41666666661FAC59410000000047B32E41000000E020AC59416666666649B32E41CDCCCC6C22AC59419A9999994CB32E413333337323AC59419A99999951B32E419A99995924AC59416666666656B32E41000000C025AC59419A9999995AB32E416666660627AC5941CDCCCCCC5DB32E419A9999F928AC5941333333335FB32E41CDCCCCAC2AAC5941CDCCCCCC5EB32E419A9999792CAC59419A9999995DB32E41333333532EAC5941333333335EB32E413333335330AC5941CDCCCCCC5FB32E413333331332AC59416666666662B32E413333335334AC5941333333336AB32E410000000039AC59419A99999985B32E41333333D338AC5941666666669FB32E41CDCCCC4C36AC594166666666ACB32E410000008035AC5941CDCCCCCCC1B32E41CDCCCC2C38AC5941CDCCCCCCCFB32E416666660639AC594133333333D7B32E41CDCCCC8C3CAC5941CDCCCCCCE4B32E419A9999F93CAC59419A999999EDB32E41333333333BAC594166666666EDB32E413333339337AC59419A9999990CB42E419A99997934AC59413333333320B42E410000004034AC59419A9999993CB42E41CDCCCCCC35AC59419A9999994AB42E41CDCCCC0C36AC59416666666655B42E419A9999F934AC59413333333353B42E419A9999B932AC59413333333359B42E413333339330AC59419A9999996EB42E41000000602CAC59416666666664B42E41CDCCCC2C29AC5941000000007CB42E419A99997928AC5941000000008BB42E41333333B32AAC594133333333A6B42E419A9999F92AAC594100000000B7B42E41000000A02BAC59419A999999CBB42E419A99995929AC59419A999999D4B42E41666666A627AC5941CDCCCCCCECB42E413333333326AC59419A999999F4B42E419A9999D923AC59419A99999906B52E410000006023AC59416666666610B52E416666664622AC59419A99999924B52E410000008023AC5941666666662FB52E410000008023AC59413333333346B52E413333339324AC59416666666675B52E41CDCCCC0C23AC5941CDCCCCCC7AB52E41000000C020AC5941CDCCCCCC7CB52E419A9999D91FAC5941666666667EB52E41666666261EAC5941CDCCCCCC8EB52E41CDCCCC6C1FAC59419A99999993B52E41CDCCCC2C20AC5941CDCCCCCC9EB52E41333333F31EAC5941CDCCCCCC98B52E41CDCCCC6C1BAC59413333333397B52E416666664617AC594133333333A3B52E419A99997915AC59419A999999BCB52E419A99999911AC594166666666CDB52E41CDCCCCCC0DAC59419A999999C6B52E41333333130AAC594133333333DEB52E419A9999B906AC594166666666EDB52E410000002005AC594100000000FEB52E41CDCCCC0C03AC5941CDCCCCCC10B62E41333333D3FCAB5941666666662DB62E41CDCCCC0CFBAB5941000000003DB62E41333333D3FCAB59416666666647B62E419A9999F9FEAB59413333333351B62E413333339300AC59416666666696B62E41CDCCCC4C00AC59419A999999A1B62E41333333B3FFAB5941CDCCCCCCC1B62E4100000040FCAB5941CDCCCCCCCDB62E41666666C6FBAB594166666666DCB62E4166666606FCAB594133333333E6B62E41CDCCCC6CFBAB59419A999999E9B62E419A9999D9F7AB594100000000F2B62E41000000E0F5AB59413333333310B72E4100000000F5AB5941CDCCCCCC25B72E419A999999F7AB5941000000003AB72E4166666626F7AB59419A99999957B72E41333333D3F7AB5941CDCCCCCC62B72E4100000080F7AB5941CDCCCCCC7CB72E419A999979F4AB59413333333389B72E419A9999D9F2AB5941333333338DB72E419A999959F0AB59416666666684B72E4166666666EDAB59413333333385B72E41333333B3ECAB59413333333386B72E41CDCCCCCCEBAB59413333333388B72E4133333353EAAB5941CDCCCCCC7DB72E419A9999B9E2AB5941CDCCCCCC85B72E4100000000E0AB59419A9999998BB72E4100000020DFAB5941000000008FB72E4100000000DBAB5941CDCCCCCC8AB72E41CDCCCCACD9AB59410000000091B72E419A999959D8AB5941CDCCCCCC92B72E41CDCCCCCCD6AB594133333333A5B72E4100000000D3AB59419A999999AAB72E41000000E0D0AB594100000000A0B72E41666666E6CCAB5941CDCCCCCC9FB72E41CDCCCCCCCBAB59419A99999990B72E419A999999C9AB5941666666668BB72E4166666666C7AB5941333333338CB72E4166666666C5AB59413333333396B72E41666666C6C3AB594166666666B9B72E41CDCCCC2CC2AB594166666666D3B72E4166666666C2AB594133333333DDB72E419A9999D9C2AB5941CDCCCCCCEAB72E4100000040C2AB594133333333F7B72E419A999979C0AB594100000000FCB72E419A999979BFAB5941CDCCCCCC03B82E419A9999B9BEAB59416666666607B82E419A9999B9BCAB59416666666603B82E41000000E0BAAB59416666666627B82E419A999999B7AB59410000000034B82E419A999919B6AB5941666666663AB82E41CDCCCC2CB6AB59416666666645B82E4100000020B7AB59413333333353B82E419A999999B6AB5941CDCCCCCC64B82E4100000020B6AB5941000000007DB82E419A9999B9B2AB5941333333338DB82E419A999939B1AB5941333333339CB82E41CDCCCC8CB1AB594133333333A5B82E4166666646B3AB594100000000B0B82E41333333B3B3AB59419A999999B7B82E4133333313B3AB5941CDCCCCCCC6B82E41000000A0B0AB594166666666DCB82E41000000E0B0AB594133333333E7B82E419A999999ADAB594166666666FDB82E41CDCCCC4CABAB5941CDCCCCCC02B92E419A9999F9A8AB59419A99999917B92E4166666686A9AB5941000000002AB92E419A999999ADAB5941333333332CB92E41000000A0AFAB5941333333333AB92E41666666C6B0AB59419A99999954B92E419A9999D9B0AB59413333333362B92E41666666A6AFAB59419A9999996BB92E4166666666ACAB5941666666667CB92E41CDCCCCACA8AB5941666666667EB92E4100000020A6AB59416666666691B92E41CDCCCC2CA5AB594166666666AAB92E41CDCCCC8CA5AB594166666666AFB92E4166666686A7AB5941CDCCCCCCA4B92E4166666686A8AB5941333333339AB92E41CDCCCCCCABAB594166666666B1B92E41CDCCCCCCAFAB59419A999999BEB92E419A9999D9AFAB5941CDCCCCCCE2B92E41CDCCCCACADAB5941CDCCCCCCEDB92E4133333373ABAB5941CDCCCCCCF2B92E4166666606A6AB59419A999999FFB92E41666666E6A4AB59413333333315BA2E41666666A6A5AB5941666666662EBA2E41CDCCCCACA8AB5941CDCCCCCC34BA2E41333333B3A8AB59410000000040BA2E4166666606A6AB59410000000042BA2E4166666666A4AB5941CDCCCCCC24BA2E4166666666A2AB594133333333D9B82E41CDCCCCEC89AB59419A9999991AB72E41666666A669AB59416666666607B72E416666664665AB59419A99999949B52E41000000E052AB59413333333301B52E410000002062AB594166666666FFB42E410000006063AB5941CDCCCCCC01B52E41000000A065AB594166666666F8B42E41666666E667AB59419A999999D8B42E410000000069AB59419A999999CCB42E41CDCCCC0C69AB594100000000C1B42E41333333536AAB59419A999999BDB42E41333333D36CAB5941CDCCCCCCB7B42E41000000A06EAB594166666666A4B42E41CDCCCCEC6FAB59416666666698B42E419A9999F96FAB59416666666690B42E410000008070AB59416666666688B42E416666660671AB5941CDCCCCCC7CB42E413333331372AB59410000000067B42E416666666673AB59416666666659B42E41CDCCCC6C74AB59419A99999951B42E419A9999B975AB59410000000046B42E410000000077AB59410000000030B42E413333331377AB59413333333322B42E41000000A077AB59419A99999906B42E419A9999F979AB5941CDCCCCCCFCB32E41000000807AAB5941CDCCCCCCF4B32E41CDCCCC4C7AAB59419A999999E6B32E413333335379AB59419A999999DEB32E41000000A079AB594133333333D9B32E41666666E67BAB594166666666CBB32E41CDCCCC6C7DAB5941CDCCCCCCB7B32E41000000807EAB59419A999999ADB32E41CDCCCCCC7DAB594133333333A1B32E41333333D37BAB5941333333338BB32E41666666667BAB59416666666679B32E419A9999B97CAB59416666666670B32E41333333B37DAB5941CDCCCCCC6DB32E41000000007EAB59410000000064B32E41CDCCCC4C7FAB59419A99999964B32E41CDCCCC4C82AB59419A99999965B32E41CDCCCC8C85AB5941666666665EB32E419A99993989AB5941333333335EB32E41CDCCCC4C89AB5941666666665AB32E41333333138AAB5941666666664AB32E41000000A08AAB59410000000045B32E41666666268CAB5941CDCCCCCC3AB32E41333333138FAB59419A99999939B32E41CDCCCC6C8FAB59413333333330B32E419A9999B991AB5941666666661AB32E41666666C692AB59419A99999902B32E419A99991993AB5941CDCCCCCCFEB22E41666666E693AB594166666666F9B22E41666666A696AB594166666666EBB22E41333333F396AB594133333333DFB22E410000008095AB5941CDCCCCCCD2B22E416666668694AB5941CDCCCCCCCAB22E413333339394AB594133333333C7B22E413333331396AB594166666666C5B22E413333335397AB5941CDCCCCCCBBB22E419A99995998AB59419A999999B1B22E416666666697AB5941CDCCCCCCA5B22E41CDCCCCAC97AB59410000000098B22E410000000099AB59410000000086B22E413333339399AB5941CDCCCCCC7DB22E413333339398AB59419A99999967B22E41CDCCCCEC96AB59419A9999994DB22E410000000097AB5941CDCCCCCC31B22E419A99999997AB5941CDCCCCCC21B22E41666666A697AB59419A9999991BB22E41CDCCCCAC96AB5941CDCCCCCC15B22E41666666A695AB594100000000E0B12E413333337395AB59416666666697B12E41CDCCCCAC95AB59410000000071B12E41666666A695AB59419A9999994CB12E413333339395AB5941000000001EB12E419A9999B996AB59410000000015B12E419A9999B997AB59419A999999BCB02E41333333B397AB5941CDCCCCCCBAB02E41000000C09BAB594100000000BBB02E41666666C69DAB5941CDCCCCCC8AB02E41CDCCCCEC9DAB59419A9999996DB02E41000000409EAB5941333333331BB02E41666666669FAB594166666666F9AF2E4133333333A0AB594166666666E6AF2E41CDCCCC6CA0AB59419A999999CEAF2E4133333373A0AB5941CDCCCCCCACAF2E4100000020A0AB59410000000086AF2E419A9999D99FAB5941000000006AAF2E419A9999D99AAB59410000000048AF2E41666666669AAB594166666666FBAE2E41666666469AAB5941CDCCCCCCEEAE2E41333333939AAB594133333333E3AE2E410000002099AB59419A999999D6AE2E419A99993994AB59419A999999CCAE2E41333333738FAB594166666666B0AE2E41CDCCCCCC8EAB594100000000A7AE2E41333333938EAB59419A99999992AE2E41CDCCCC2C8EAB5941666666668BAE2E41666666068EAB59419A99999973AE2E41333333138EAB5941333333335AAE2E419A9999398EAB5941666666664AAE2E41666666468EAB5941666666662DAE2E419A9999B992AB594166666666D4AD2E419A9999598DAB594100000000EAAD2E41CDCCCC4C8BAB594100000000F2AD2E41333333B38AAB594100000000FDAD2E410000004089AB5941CDCCCCCC02AE2E41CDCCCCAC87AB59410000000005AE2E41000000C085AB59410000000002AE2E413333333384AB594133333333FAAD2E410000008082AB594100000000F6AD2E419A9999B980AB594100000000F7AD2E41666666067FAB59416666666605AE2E41000000A07BAB5941000000000DAE2E41333333F37AAB5941333333331BAE2E41333333937AAB59419A99999928AE2E41000000607AAB59419A99999934AE2E41CDCCCC2C7AAB5941CDCCCCCC40AE2E41CDCCCC4C79AB59413333333349AE2E419A99999978AB5941CDCCCCCC51AE2E410000006077AB5941CDCCCCCC51AE2E416666666676AB59410000000051AE2E41CDCCCCAC74AB59419A9999995FAE2E413333339373AB59419A99999964AE2E41CDCCCC4C74AB59410000000067AE2E419A99991975AB5941CDCCCCCC68AE2E413333339376AB5941000000006DAE2E413333333377AB59413333333373AE2E413333337377AB5941000000007EAE2E419A99993974AB59416666666684AE2E41CDCCCC2C6FAB5941333333338CAE2E41333333536BAB59416666666692AE2E410000006068AB59419A99999993AE2E410000004066AB59416666666693AE2E41666666C663AB59410000000096AE2E419A99993962AB5941000000009BAE2E413333331361AB594133333333A2AE2E419A9999D95FAB594166666666A9AE2E41CDCCCC2C5FAB59419A999999AFAE2E41CDCCCC4C5FAB5941CDCCCCCCC7AE2E41000000C060AB59419A999999E2AE2E41333333F35FAB594166666666E3AE2E41000000E05DAB594100000000E4AE2E419A9999595CAB5941CDCCCCCCE6AE2E41CDCCCCEC59AB594100000000E9AE2E413333333358AB594100000000E5AE2E413333339357AB59419A999999C7AE2E41666666A655AB594166666666BEAE2E416666668654AB594100000000B6AE2E41CDCCCCAC51AB594133333333B7AE2E419A99999950AB594133333333CAAE2E41666666664EAB59419A999999D5AE2E419A9999D94DAB59419A999999F7AE2E41333333534BAB5941000000000CAF2E41666666E647AB59410000000011AF2E416666664646AB59410000000017AF2E41666666A643AB59419A9999991BAF2E41CDCCCC0C41AB59416666666628AF2E41333333133BAB59419A99999903AF2E419A99999936AB594166666666FEAE2E419A99995933AB594166666666FFAE2E413333335332AB59416666666602AF2E413333339331AB5941333333330BAF2E419A99991931AB59419A99999912AF2E419A99991931AB59410000000019AF2E410000006031AB5941CDCCCCCC1FAF2E41CDCCCCAC31AB5941CDCCCCCC2FAF2E419A99991933AB59410000000039AF2E416666666633AB59419A99999941AF2E419A99999932AB59410000000044AF2E41CDCCCCEC30AB59413333333344AF2E419A9999592FAB5941CDCCCCCC44AF2E41CDCCCCCC2CAB59419A99999949AF2E41CDCCCCCC2AAB59410000000059AF2E419A99991927AB59416666666662AF2E41CDCCCC6C25AB59416666666669AF2E41CDCCCC6C23AB59419A9999996FAF2E419A99995920AB5941333333336FAF2E41CDCCCC6C1FAB59419A9999996EAF2E41333333331EAB59416666666666AF2E41333333D31CAB59416666666655AF2E41CDCCCC8C1BAB59416666666634AF2E41000000C019AB59410000000002AF2E41000000A016AB59419A99999909AF2E41CDCCCC2C12AB5941333333330EAF2E41CDCCCC8C0FAB59416666666610AF2E419A9999B90DAB59413333333319AF2E41CDCCCC2C08AB59419A9999991BAF2E41CDCCCC8C04AB5941666666661EAF2E419A99991901AB59419A99999920AF2E41333333D3FEAA5941CDCCCCCC2AAF2E41CDCCCCECFCAA5941CDCCCCCC38AF2E4133333393FBAA59419A99999946AF2E419A999919FAAA5941CDCCCCCC50AF2E41000000C0F8AA59410000000059AF2E4100000080F6AA5941CDCCCCCC5BAF2E419A999959F4AA5941333333335BAF2E41000000E0F1AA5941CDCCCCCC58AF2E4166666666EFAA59416666666658AF2E4100000080EDAA59413333333361AF2E4100000060ECAA5941333333336EAF2E41CDCCCCACEBAA59416666666681AF2E41CDCCCC4CEAAA59419A99999996AF2E4166666646E7AA594100000000A3AF2E41333333F3E3AA5941CDCCCCCC92AF2E419A999959E2AA59413333333383AF2E41000000C0E0AA5941CDCCCCCC72AF2E4166666646DFAA5941CDCCCCCC66AF2E419A9999F9DDAA5941000000005CAF2E4100000080DCAA5941CDCCCCCC4FAF2E4166666666DAAA59416666666643AF2E4166666606D8AA5941333333332DAF2E419A9999D9D4AA5941CDCCCCCC24AF2E4100000000D2AA5941CDCCCCCC2DAF2E41000000C0CDAA59416666666631AF2E419A999959CAAA59419A9999992AAF2E419A999959C9AA59410000000014AF2E419A9999D9C6AA594100000000F9AE2E41CDCCCCCCC3AA594133333333EDAE2E41666666E6C1AA594100000000E7AE2E41CDCCCCACBFAA594133333333E6AE2E419A999959BDAA5941CDCCCCCCE8AE2E4100000040BBAA594100000000EDAE2E4133333373B9AA59419A999999F3AE2E41333333D3B7AA594133333333F9AE2E41333333F3B5AA59419A999999FFAE2E41000000C0B3AA5941000000000BAF2E4100000080B2AA59416666666617AF2E4133333373B1AA5941CDCCCCCC10AF2E4166666606AFAA5941CDCCCCCC07AF2E41000000E0AEAA5941CDCCCCCCEAAE2E4100000020AEAA594100000000D8AE2E4133333393ADAA594133333333D8AE2E4166666606ABAA594133333333DAAE2E4100000020AAAA5941CDCCCCCCE0AE2E41666666A6A7AA594133333333E0AE2E41CDCCCCCCA5AA594100000000E0AE2E419A999919A4AA59419A999999DFAE2E41CDCCCCECA1AA5941CDCCCCCCE3AE2E41666666E69FAA5941CDCCCCCCEAAE2E41333333739EAA59419A999999FBAE2E41000000C09CAA59413333333304AF2E41000000C09BAA5941CDCCCCCC0BAF2E41333333B39AAA59413333333312AF2E419A99991999AA5941CDCCCCCC15AF2E41CDCCCCAC97AA5941CDCCCCCC16AF2E419A99997996AA59410000000012AF2E413333339394AA5941000000000CAF2E413333331394AA59416666666606AF2E41666666C693AA594133333333F0AE2E419A99999993AA59419A999999E3AE2E413333331393AA594133333333DDAE2E410000006091AA594100000000DDAE2E41333333738FAA594100000000DEAE2E41CDCCCC2C8DAA59419A999999D8AE2E419A9999F989AA5941CDCCCCCCDBAE2E413333339386AA594166666666DBAE2E419A9999D984AA59419A999999D3AE2E410000004084AA594100000000C5AE2E419A99997983AA59419A999999BBAE2E41CDCCCC8C82AA594133333333B1AE2E410000008080AA594166666666AAAE2E419A9999F97EAA594166666666A2AE2E41666666E67CAA5941CDCCCCCCA6AE2E419A9999F97BAA59419A999999AEAE2E41333333337BAA594133333333B0AE2E41000000C07AAA594133333333B6AE2E41CDCCCC2C79AA5941666666669BAE2E413333335377AA594100000000B1AD2E416666662675AA594100000000B5AD2E41333333B371AA594100000000B2AC2E419A9999B979AA59410000000046AC2E41CDCCCC0C74AA5941CDCCCCCC01AC2E41CDCCCCCC6FAA5941333333331FAB2E419A9999995FAA5941333333332DAB2E41000000205EAA594100000000FBAA2E41333333D359AA594166666666A0AA2E41666666C652AA5941666666664CAA2E41000000C04CAA594100000000DBA92E41CDCCCCCC44AA59416666666606AA2E41000000A03CAA59419A9999992AAA2E419A99991936AA59410000000036AA2E416666660634AA59419A99999965AA2E419A9999B92BAA5941333333338AAA2E419A99999925AA59416666666657AA2E41000000C020AA59419A99999909AA2E41CDCCCCCC18AA59419A99999913AA2E41CDCCCC2C10AA5941CDCCCCCC21AA2E41CDCCCCEC04AA59413333333334AA2E4166666646F6A95941CDCCCCCCFAA92E419A999919EFA959419A999999A9A92E41CDCCCC6CE5A9594133333333B3A92E419A999919E3A9594166666666C1A92E4100000020DFA9594100000000CBA92E419A999979DAA9594133333333D0A92E4166666646D7A95941CDCCCCCCD9A92E4133333333D4A95941CDCCCCCCEDA92E419A9999D9CFA959416666666606AA2E41333333B3CBA9594166666666F8A92E41CDCCCC4CCBA9594100000000ECA92E4100000060CAA959419A999999CBA92E41333333B3C7A959416666666699A92E41666666C6C2A95941CDCCCCCC88A92E41CDCCCC0CC1A95941000000005FA92E419A9999B9BCA95941333333335DA92E41CDCCCCCCBBA95941CDCCCCCC44A92E419A999939B9A959413333333317A92E419A9999D9B4A9594133333333F1A82E419A9999F9B1A9594100000000E3A82E4133333313B7A959419A999999C5A82E4100000040C0A9594100000000B1A82E419A9999D9C2A95941CDCCCCCC7DA82E4166666606C8A95941666666666EA82E419A999919C9A95941CDCCCCCC3FA82E4166666606CBA95941666666661AA82E41CDCCCCECCCA9594100000000D8A72E4100000040D0A95941000000008DA72E41333333F3D4A95941CDCCCCCC63A72E41CDCCCCCCD6A95941CDCCCCCC57A72E419A9999F9D7A959419A9999994FA72E41666666A6D9A95941CDCCCCCC35A72E41333333D3D5A95941333333331BA72E41CDCCCC4CD1A959413333333302A72E419A999999CDA95941CDCCCCCCEFA62E4100000060CBA959419A999999DFA62E419A999999C8A9594100000000D1A62E4100000000C5A9594100000000C4A62E41CDCCCC0CC1A9594166666666B7A62E4100000040BEA959419A999999ACA62E41CDCCCC4CBCA9594166666666A2A62E41000000E0B9A95941000000009AA62E41CDCCCC0CB8A95941CDCCCCCC5DA62E419A9999B9BDA95941CDCCCCCC8DA52E419A999979D1A9594166666666F1A42E41000000E0E4A95941666666660BA42E41CDCCCC6C01AA594100000000F9A32E41333333B303AA5941333333330FA42E41666666A622AA5941CDCCCCCC10A42E416666664625AA59419A99999915A42E41666666E627AA5941000000001AA42E41666666A62CAA5941CDCCCCCC1FA42E41CDCCCC0C32AA59419A99999928A42E41CDCCCC8C37AA59419A9999992DA42E41CDCCCCCC3BAA59410000000030A42E41666666A63EAA59413333333335A42E419A99991942AA59419A9999993CA42E413333335345AA5941000000004EA42E41333333F348AA59419A99999960A42E41333333534CAA59416666666665A42E41000000804EAA59416666666669A42E413333331352AA5941CDCCCCCC67A42E410000000054AA5941333333330EA42E41666666064FAA59413333333397A32E41CDCCCC6C48AA59419A99999954A32E419A9999B944AA59413333333341A22E419A99997935AA5941CDCCCCCC29A22E413333333334AA5941CDCCCCCC2DA12E413333333326AA59419A9999992AA12E419A99993929AA5941CDCCCCCC26A12E41333333D32BAA59416666666621A12E41666666E62DAA5941000000001AA12E419A9999992FAA59419A9999990CA12E41333333932FAA59419A999999FAA02E41000000402FAA5941CDCCCCCCEBA02E41CDCCCC4C2FAA59419A999999E2A02E410000008030AA594166666666DAA02E41333333F332AA5941CDCCCCCCD0A02E41333333F336AA594133333333C4A02E41000000003BAA594166666666B9A02E41666666A63DAA594166666666A8A02E419A99997940AA5941CDCCCCCC96A02E41333333F343AA5941CDCCCCCC8AA02E41CDCCCC6C47AA59419A99999981A02E41CDCCCC8C4BAA59416666666679A02E41CDCCCC0C50AA59410000000075A02E41CDCCCC0C52AA5941666666668C9E2E416666662641AA594100000000789E2E413333337340AA594133333333439E2E419A9999D936AA594166666666EA9D2E41666666A626AA594133333333A39D2E41333333B319AA594133333333099D2E4133333393FDA9594166666666929C2E4100000040E0A9594166666666559C2E4100000020D1A95941666666669A9B2E416666660610AA59419A999999979B2E419A9999F910AA594100000000919B2E413333333313AA594133333333A09B2E41CDCCCCEC28AA594133333333BA9B2E41000000602EAA5941CDCCCCCCC79B2E41CDCCCC4C32AA59419A999999CA9B2E419A99991933AA5941CDCCCCCCC89B2E419A9999D936AA594100000000BB9B2E41000000603BAA594133333333AD9B2E41000000A03EAA59419A999999899B2E41666666A642AA5941CDCCCCCC6F9B2E41CDCCCC2C46AA594100000000449B2E413333333349AA5941000000001E9B2E419A9999794CAA594133333333009B2E41000000004EAA594166666666E69A2E41000000804FAA594166666666B89A2E41CDCCCCCC50AA59419A9999998A9A2E41333333D352AA5941CDCCCCCC4A9A2E41666666E653AA59419A999999359A2E41CDCCCCAC55AA594100000000279A2E41CDCCCCEC56AA5941CDCCCCCCF4992E41CDCCCC4C54AA59419A9999996A992E419A9999194DAA59419A999999F8982E41333333F349AA5941CDCCCCCCAA982E41000000404BAA5941CDCCCCCC56982E419A9999194BAA5941CDCCCCCCC6972E419A9999D94BAA5941CDCCCCCC85972E41CDCCCC2C4CAA5941000000005D972E41000000204CAA59416666666619972E41666666864BAA59419A999999D9962E41000000C049AA594166666666AE962E419A99993949AA59413333333395962E419A99995948AA5941CDCCCCCC76962E41666666A647AA59410000000088962E41666666464AAA5941666666669D962E41666666C64DAA594166666666A3962E41CDCCCC8C4EAA59419A999999DE962E41CDCCCC6C63AA594100000000EE962E41666666A66EAA594100000000CB962E41CDCCCC2C85AA59419A99999958962E41CDCCCCEC81AA5941CDCCCCCC3E952E419A9999F97FAA5941CDCCCCCC41952E41333333B380AA59419A9999993B952E41000000C082AA5941666666660B952E41666666C68AAA594133333333F7942E41666666668FAA59419A999999EA942E41CDCCCCCC92AA594166666666EA942E41000000E092AA594133333333ED942E41000000E094AA59419A999999D3942E41CDCCCCAC95AA5941CDCCCCCCCA942E419A9999D996AA5941CDCCCCCCE7942E41000000E0A4AA59419A99999901952E41CDCCCC8CA8AA5941666666661F952E419A999939AAAA59410000000026952E41CDCCCC2CACAA594133333333BB942E41333333F3B0AA5941333333335D942E4100000060B4AA5941CDCCCCCC45942E41CDCCCC2CACAA59419A9999993D942E419A9999B9ACAA5941666666663A942E41CDCCCCECACAA5941CDCCCCCC10942E4166666686AFAA5941333333330B942E41CDCCCC0CB1AA5941000000007E932E419A999919B7AA59410000000061932E4100000060CAAA5941	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	01010000206A080000E060A5F0F1A22E416666666614AB5941	900250000	Z	Chavannes-les-Grands	9002500	90025	90	27	7
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	01060000206A080000010000000103000000010000009E00000000000000F2482E419A9999790BAE5941CDCCCCCC81492E41CDCCCC8C5CAE59419A999999EC492E41CDCCCCAC59AE59419A999999124A2E41CDCCCC6C5AAE594100000000A54A2E419A99999960AE594100000000184B2E41CDCCCC0C63AE594133333333D34B2E41CDCCCC4C68AE5941CDCCCCCC564C2E41000000E06FAE594100000000954C2E413333339374AE5941333333338A4C2E41CDCCCC0C89AE594100000000674C2E41CDCCCC8C93AE5941CDCCCCCC064C2E419A999919AAAE59419A999999C94B2E4166666666B5AE594133333333C64B2E4100000020BDAE594166666666DC4B2E4133333393C2AE594133333333474C2E4133333333D3AE5941CDCCCCCC3E4D2E41666666E6F0AE59419A999999514D2E419A999919FEAE59419A999999574D2E41000000801DAF594133333333704D2E419A9999F929AF594166666666904D2E41CDCCCCAC2CAF59419A999999EF4E2E41333333D329AF594133333333374F2E410000004028AF5941333333339D4F2E41666666262AAF59419A99999971502E416666662637AF5941CDCCCCCC64502E410000002047AF59410000000060502E41666666067AAF5941000000003C512E419A9999F9A1AF594166666666F8512E419A9999D9EAAF59410000000024532E41000000A0E7AF594133333333EF552E41CDCCCCCCEDAF594166666666CB572E419A999939F3AF594100000000F9592E41CDCCCC4CF3AF594166666666455B2E4166666686EFAF594100000000275D2E419A999939E2AF59419A999999E95D2E4133333373E2AF59410000000088602E41CDCCCCECDAAF594166666666AF622E41CDCCCCECA8AF59410000000035652E419A999919CEAF5941CDCCCCCCD4662E4166666606DFAF594133333333EC682E4100000000D1AF5941333333338F6B2E4166666686F0AF594133333333606D2E413333333314B059419A999999A56D2E41333333F314B05941CDCCCCCC396E2E419A9999F914B0594100000000FC6E2E419A99993911B05941CDCCCCCC3D702E419A99997906B059416666666617722E4100000000FAAF59419A9999999F722E419A9999D9F3AF59413333333356722E4133333313E8AF59419A99999956722E41CDCCCCCCDEAF5941000000004C722E41666666E6D9AF594133333333DD712E41666666E6D6AF594166666666BA712E41CDCCCC0CD3AF594100000000B2712E41CDCCCCACCBAF5941CDCCCCCC85712E41CDCCCC2CC4AF59419A99999980712E4166666666B6AF5941CDCCCCCC4E712E41CDCCCCCCB1AF59419A99999958712E41CDCCCC6CA9AF59410000000025712E4133333313A6AF594166666666DB702E419A999959A6AF59419A999999BE702E4133333393A2AF594133333333BA702E416666668699AF59419A999999A5702E419A9999B994AF5941CDCCCCCC79702E41CDCCCC4C92AF59419A9999998F702E41CDCCCCCC8EAF59419A999999A6702E416666664686AF594133333333B3702E419A9999D97AAF59416666666689702E416666662672AF5941333333338E702E41CDCCCCCC69AF5941CDCCCCCC51702E419A9999595BAF59410000000050702E413333335356AF59413333333377702E41333333B34EAF594166666666D0702E419A9999F934AF594166666666FC702E413333331332AF59416666666694702E41000000E01FAF5941CDCCCCCC7E702E41CDCCCC2C1AAF5941333333337E702E419A99995914AF5941333333338F702E419A99999902AF5941666666665E6F2E41CDCCCCCCF8AE594166666666896D2E4100000080FBAE594100000000EE6A2E4166666606F4AE59419A999999B06A2E4100000000F0AE5941666666667C6A2E41666666A6EAAE594133333333A56A2E419A999999DEAE594133333333D26A2E4133333333CAAE59419A999999D66A2E41333333F3BCAE5941CDCCCCCCE76A2E41000000E0B5AE59419A999999D56A2E41333333F3AEAE5941CDCCCCCCCF6A2E4133333313A6AE59419A999999906A2E4166666606A1AE59419A9999992F6A2E41666666069FAE594166666666F5692E413333331398AE59419A999999EB692E419A9999398DAE5941333333339D692E419A9999598AAE594133333333A2692E419A99999986AE594133333333C5692E41CDCCCC8C85AE5941CDCCCCCCD8692E41CDCCCC4C80AE594166666666CC692E410000006074AE594166666666B8692E419A9999F96AAE5941CDCCCCCCB5692E41000000E063AE5941CDCCCCCC96692E41333333F364AE59413333333379692E41CDCCCC4C6BAE59419A99999927692E41CDCCCC8C5DAE59419A9999996D682E41333333F356AE5941666666660E682E413333335333AE59419A99999988682E41CDCCCCCC0FAE59416666666693682E419A999959F1AD5941CDCCCCCCB1682E4166666626D1AD5941666666662D692E41CDCCCC6C99AD594100000000C0692E41CDCCCC8C81AD5941CDCCCCCC4B682E41CDCCCCCC8EAD5941333333336B652E41666666C6A9AD59416666666624642E41CDCCCC4CC8AD5941CDCCCCCC90632E419A999959CAAD5941CDCCCCCC72632E419A999919C8AD5941CDCCCCCC42632E4166666666BDAD59413333333341622E419A9999B9BAAD59419A9999991F612E419A999959AFAD594166666666B25F2E419A9999B9A5AD59419A999999745F2E41CDCCCCECA7AD59419A999999245F2E4133333333A7AD5941CDCCCCCCB75E2E4133333353A4AD594100000000815E2E41CDCCCC6CA5AD5941666666663A5E2E41CDCCCC2CA3AD594166666666B85D2E41CDCCCC8CA3AD594100000000715D2E41000000E0A1AD594166666666D55C2E41000000C0A8AD59419A999999AF5C2E41CDCCCC2CACAD59419A9999990D5C2E4133333313A9AD5941666666666A5B2E41333333939EAD5941000000001F5B2E419A99991999AD594100000000DE5A2E416666662697AD5941CDCCCCCC8B592E419A9999F999AD59419A99999908592E41000000809BAD5941333333334B582E4100000020A1AD59419A99999979572E41000000A0AAAD59413333333367572E419A999939ACAD59419A999999B0562E416666662608AE59419A99999902552E41CDCCCC4C19AE59416666666678542E41333333B312AE5941CDCCCCCC79542E41333333B30AAE5941333333332C542E419A9999F908AE59413333333322542E419A9999B904AE594133333333E1532E4133333373FEAD594100000000AE532E4166666646FBAD59416666666647532E419A9999D9F9AD594166666666E4522E41CDCCCC8CF5AD594100000000B3522E41333333B3F5AD5941CDCCCCCC51522E41666666E6EEAD59413333333300522E41000000E0EFAD59413333333385512E4166666606EAAD59419A99999920512E41CDCCCCACE3AD5941CDCCCCCCAE4D2E419A9999D9DFAD59413333333370492E4166666626F9AD59410000000070492E41000000E003AE594100000000F2482E419A9999790BAE594100000000F2482E419A9999790BAE5941	01010000206A08000058382166705B2E4133333383CBAE5941	900260000	Z	Chèvremont	9002600	90026	90	27	9
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	01010000206A080000844542B40DB42E41666666A655A15941	900270000	Z	Courcelles	9002700	90027	90	27	5
01060000206A08000001000000010300000001000000B40100009A999999B8B12E41CDCCCC6C07A659419A99999919B22E41666666860AA6594133333333C7B22E419A9999D914A659413333333392B32E41CDCCCC4C29A6594133333333EFB32E41333333132FA6594100000000F3B32E41333333532FA6594100000000F3B42E41333333333FA65941CDCCCCCCD9B52E419A9999594CA659419A9999994FB72E41CDCCCCAC61A659413333333385B72E41CDCCCC2C64A659419A999999C2B72E41CDCCCC4C66A659413333333307B82E410000002067A65941CDCCCCCC4CB82E413333339367A659416666666689B82E41CDCCCC0C68A6594100000000CEB82E419A9999F969A659416666666602B92E419A9999B96AA659416666666638B92E41333333F36AA65941666666666AB92E41000000406AA659413333333388B92E41000000A069A6594100000000A5B92E419A99999965A659419A999999B0B92E419A99999962A6594100000000B8B92E41000000405FA6594100000000B6B92E41666666265CA6594133333333ADB92E41666666C657A6594166666666AAB92E41CDCCCC4C54A6594100000000AEB92E41CDCCCC6C50A6594100000000B2B92E41666666264EA6594166666666F9B92E419A9999394DA6594133333333B2BA2E419A9999D94AA65941CDCCCCCC1BBB2E416666668649A65941333333335EBB2E41666666A648A659413333333358BB2E41CDCCCC6C44A659419A99999953BB2E41666666A643A65941CDCCCCCC49BB2E41333333F341A65941CDCCCCCC44BB2E41666666E63EA65941CDCCCCCC40BB2E419A9999793BA65941CDCCCCCC36BB2E41CDCCCC0C36A65941000000002EBB2E413333337331A659416666666623BB2E41000000602DA659410000000010BB2E41CDCCCC8C27A659419A99999904BB2E410000000023A659419A99999900BB2E419A99991921A6594133333333F3BA2E419A9999191BA6594166666666E6BA2E413333335315A6594133333333E1BA2E41000000C011A6594133333333E1BA2E41666666060FA6594166666666E7BA2E419A9999F909A659419A999999EDBA2E41000000C006A6594100000000F4BA2E419A9999F902A6594133333333FABA2E41666666C6FEA5594133333333FEBA2E419A9999F9FAA5594166666666FFBA2E419A9999D9F7A559416666666603BB2E4133333393F4A55941CDCCCCCC1CBB2E419A999919EDA55941CDCCCCCC29BB2E419A999919E9A559419A99999934BB2E41333333B3E4A55941000000003DBB2E4166666646E0A559410000000049BB2E41CDCCCC6CD6A55941000000004ABB2E4166666606D3A559419A99999949BB2E4133333393CBA55941CDCCCCCC2FBB2E4133333313BFA55941666666661ABB2E41000000A0B4A559410000000005BB2E41CDCCCC6CACA5594166666666E7BA2E4166666606A2A5594133333333D0BA2E413333335399A5594166666666B8BA2E41CDCCCC2C8FA559419A999999A4BA2E419A9999F983A559419A99999986BA2E41CDCCCC8C6DA5594133333333B1BA2E41333333F36DA5594133333333C5BA2E41666666266EA5594133333333D8BA2E419A99991982A5594133333333FDBA2E41666666E681A559419A99999994BB2E41333333538BA5594166666666C6BB2E41666666468EA5594100000000D6BB2E41333333338FA55941CDCCCCCCEDBB2E410000002090A559419A99999900BC2E41CDCCCCCC91A559419A9999990FBC2E410000002093A559416666666617BC2E41CDCCCC4C94A559410000000034BC2E416666664695A55941CDCCCCCC86BC2E419A9999399AA55941CDCCCCCCB3BC2E41CDCCCCEC9BA55941CDCCCCCCFDBC2E41666666C69EA559410000000056BD2E419A999979A1A55941CDCCCCCCACBD2E419A999999A3A5594166666666F3BD2E419A9999D9A4A55941CDCCCCCC1ABE2E41CDCCCC8CA5A55941000000002CBE2E41000000A0A3A559416666666635BE2E41333333D3A1A559419A9999993EBE2E419A9999F99EA559419A9999993FBE2E41666666269CA55941CDCCCCCC3DBE2E41333333B396A55941000000001CBE2E410000000085A55941CDCCCCCC48BE2E41666666E684A559410000000060BE2E41333333D384A55941CDCCCCCC98BE2E413333337389A5594100000000B8BE2E410000006091A559419A999999BABE2E419A9999F994A5594133333333C7BE2E41CDCCCCEC94A5594133333333CEBE2E419A9999F994A559419A999999E1BE2E413333331395A559416666666638BF2E41CDCCCCCC91A55941CDCCCCCCC2BF2E41333333538CA559419A999999E3BF2E41333333D38AA55941CDCCCCCC17C02E41CDCCCC6C88A559416666666633C02E416666668686A559419A99999944C02E419A99995984A55941CDCCCCCC52C02E419A99997981A55941666666665FC02E41CDCCCC2C7EA55941666666666CC02E419A9999197AA55941333333337BC02E410000004077A559410000000088C02E410000008075A55941666666668FC02E419A99997974A5594133333333BEC02E41000000E06DA5594133333333C4C02E41666666066DA559419A999999EFC02E413333335366A559416666666603C12E41CDCCCC4C5FA55941666666660AC12E41333333F35CA559413333333340C12E41CDCCCCAC61A559413333333355C12E41000000E05CA559419A9999996DC12E41CDCCCC2C55A559419A9999996AC12E419A99991951A559419A9999995AC12E419A9999194BA559413333333343C12E41333333B344A559419A99999935C12E410000000040A55941000000002DC12E41CDCCCC0C3CA559413333333331C12E41CDCCCCEC38A559419A99999949C12E41CDCCCC4C31A55941666666664CC12E41CDCCCC8C2EA559413333333346C32E41CDCCCC8C42A559419A9999997AC32E419A99993946A5594166666666DBC32E41333333134DA55941CDCCCCCCE2C32E419A9999994DA5594166666666F0C32E419A9999994EA55941000000006FC42E410000000058A5594100000000C0C42E410000000060A559416666666602C52E410000000068A559416666666617C52E41CDCCCCCC69A55941CDCCCCCC2AC52E419A9999196CA559419A99999936C52E419A9999796BA559413333333350C52E41333333F367A559419A9999995DC52E419A99993966A55941CDCCCCCC7BC52E41CDCCCC2C62A559413333333394C52E41000000205FA5594133333333AAC52E41666666665CA5594133333333C4C52E41CDCCCCCC59A5594166666666DCC52E41CDCCCC8C57A5594166666666ECC52E410000000057A559419A999999FDC52E410000000055A559419A99999907C62E41333333F352A55941CDCCCCCC0CC62E419A99991950A55941CDCCCCCC0FC62E41CDCCCCAC4BA559416666666606C62E41000000C048A559413333333302C62E41CDCCCC6C44A559419A999999F4C52E41000000403BA55941CDCCCCCCEDC52E41CDCCCCCC39A5594133333333D7C52E41000000E033A559419A999999FDC52E419A9999D931A55941000000001BC62E419A99997930A55941CDCCCCCC51C62E419A9999992DA559419A99999973C62E41333333532BA559416666666662C62E41000000802AA55941CDCCCCCC66C62E41CDCCCC2C29A559419A99999968C62E416666662627A559419A9999996AC62E41333333F324A559419A9999996EC62E419A9999B922A55941CDCCCCCC78C62E419A99991921A55941333333338EC62E419A9999591FA5594133333333A4C62E419A9999B91DA5594166666666B3C62E41CDCCCC6C1CA5594166666666C6C62E41333333D31AA5594133333333D8C62E41CDCCCC0C19A5594133333333D9C62E41CDCCCCEC18A559419A999999E8C62E416666664617A55941CDCCCCCCF3C62E413333335315A55941CDCCCCCCF8C62E41000000C013A559419A999999F7C62E419A99997911A55941CDCCCCCCEEC62E41666666660EA55941CDCCCCCCE3C62E41666666E60BA5594166666666D2C62E41333333B308A55941CDCCCCCCBFC62E410000002005A5594166666666ACC62E41CDCCCC4C01A559410000000097C62E4166666686FDA45941CDCCCCCC84C62E41000000E0F9A459419A99999973C62E41666666A6F6A45941CDCCCCCC61C62E419A9999F9F2A459413333333353C62E41333333F3EFA45941CDCCCCCC42C62E4133333393ECA459410000000036C62E4166666646E9A45941CDCCCCCC28C62E419A999939E6A459419A9999991CC62E4166666646E3A459419A9999990FC62E4100000000E0A459416666666605C62E41CDCCCCECDCA4594100000000F7C52E4133333333D9A4594166666666EBC52E4133333333D6A45941CDCCCCCCE1C52E419A9999B9D2A4594166666666DCC52E41CDCCCCECCFA459419A999999D6C52E41CDCCCCECCCA4594100000000D1C52E4100000080CAA45941CDCCCCCCCAC52E4166666646C8A4594100000000C4C52E419A9999F9C5A45941CDCCCCCCBEC52E4100000020C4A459419A999999B6C52E4133333373C2A459419A999999B0C52E4133333393C0A4594100000000ACC52E41666666A6BEA4594166666666A5C52E4166666686BCA459419A9999999EC52E419A999979BBA459416666666693C52E4133333333BBA459410000000022C52E419A9999399DA459419A999999B6C42E413333339383A459419A9999995EC42E419A99997971A459419A9999995BC42E419A9999796BA459413333333358C42E41000000C064A45941000000004DC42E41000000604FA459410000000051C42E41CDCCCCEC4CA459413333333353C42E410000008049A459419A99999957C42E41CDCCCC0C45A459416666666656C42E416666660630A459410000000056C42E41333333D32BA45941333333335CC42E41CDCCCCAC02A459416666666662C42E41CDCCCC6CF6A35941666666667BC42E41666666C6F9A359419A9999997AC42E41CDCCCCCCF5A359419A99999978C42E4133333393EEA359413333333377C42E419A999939E0A359416666666675C42E4100000000D0A359419A99999977C42E41000000C0C2A359416666666678C42E4133333333C1A35941CDCCCCCC9CC42E4133333373A3A35941CDCCCCCC9DC42E419A9999B993A35941000000009AC42E41666666868FA359410000000091C42E413333333384A359413333333390C42E419A9999D978A359410000000087C42E41000000C06DA359416666666686C42E419A99993967A359419A9999993FC42E41CDCCCC4C58A359419A999999E3C32E41000000604FA359416666666674C32E41000000C03CA3594166666666DCC22E41CDCCCC2C20A359416666666639C22E41666666E6F0A259419A999999E5C12E4166666646BBA2594133333333C4C12E419A9999998AA2594100000000CCC12E41000000E068A25941CDCCCCCC2BC12E41CDCCCC0C64A259413333333331C02E413333331359A25941CDCCCCCC2CBF2E41000000E061A25941000000001DBF2E41333333D362A259419A999999FABE2E41333333B363A25941CDCCCCCCADBE2E410000004065A259419A9999995CBE2E41000000C065A25941CDCCCCCC0BBE2E419A99995966A2594166666666D6BD2E41000000E065A25941333333335FBC2E41000000A06BA2594166666666FBBB2E419A9999796FA259419A999999FBBB2E419A9999F971A259416666666684BB2E419A9999197CA25941333333330BBA2E419A9999B9A0A25941CDCCCCCCA5B82E419A999999C1A259416666666685B72E41000000A0D4A259419A99999945B72E41666666A62EA35941CDCCCCCC33B72E419A999939ABA359413333333302B72E41CDCCCCCCEAA3594166666666E5B62E419A9999790FA459419A999999D6B62E419A99995922A4594166666666C2B62E41CDCCCC0C36A45941CDCCCCCCBFB62E41666666064DA4594166666666ADB62E419A9999999CA45941CDCCCCCCB1B62E41CDCCCC8C9EA45941CDCCCCCCB3B62E41666666C6A4A4594133333333B3B62E41CDCCCC8CA8A459419A999999B5B62E4133333353ADA45941CDCCCCCCB6B62E41CDCCCC6CAFA45941CDCCCCCCB5B62E41000000E0B3A45941CDCCCCCCB8B62E4133333373BCA4594166666666F2B62E41CDCCCCCCE2A459416666666601B72E41666666E6ECA459410000000023B72E419A9999F900A55941333333335EB72E419A99995924A559416666666656B72E410000002026A559410000000053B72E41000000E028A559413333333357B72E41000000E02AA559416666666665B72E41333333532CA559419A9999997BB72E41666666462EA559410000000086B72E410000000030A559410000000083B72E41CDCCCC8C31A559416666666680B72E41666666C632A55941CDCCCCCC80B72E410000008035A559413333333383B72E410000004037A55941666666667DB72E416666668638A559419A9999996DB72E41333333D339A55941CDCCCCCC65B72E41333333D33BA55941CDCCCCCC53B72E41000000E03BA55941000000004EB72E41000000603CA559413333333352B72E41000000E03DA55941333333334EB72E41000000A03EA559419A99999948B72E41666666263FA559419A99999940B72E41666666663FA559419A99999938B72E41CDCCCC6C40A559410000000033B72E41333333F341A55941333333332FB72E41333333B343A559413333333327B72E413333333344A55941666666661BB72E410000000045A55941333333331BB72E41CDCCCC8C46A55941CDCCCCCC15B72E410000004047A55941000000000CB72E416666664648A559410000000004B72E41CDCCCC4C49A5594166666666FAB62E41333333134BA55941CDCCCCCCFCB62E41333333134EA559413333333309B72E41666666C64FA559416666666611B72E416666660651A559416666666609B72E416666664652A55941CDCCCCCCFFB62E413333331354A559413333333306B72E416666664657A559416666666614B72E410000004058A559419A99999922B72E419A9999F958A55941CDCCCCCC24B72E419A9999F959A559410000000023B72E419A9999F95BA559413333333323B72E419A9999795DA55941333333332BB72E41CDCCCC2C5EA559419A99999933B72E41CDCCCC6C5FA559419A99999933B72E41CDCCCC6C60A559419A99999933B72E419A99999960A559410000000034B72E41CDCCCCEC61A559410000000036B72E41CDCCCC6C62A559413333333344B72E41000000A063A559416666666646B72E41000000E064A559419A99999944B72E41000000A065A559410000000043B72E410000006067A55941000000003FB72E41000000E068A559416666666643B72E41000000606AA559416666666645B72E41000000A06BA559419A99999949B72E419A9999D96CA55941000000004CB72E419A9999996EA559413333333346B72E410000002070A55941666666663AB72E410000002072A55941CDCCCCCC32B72E416666666673A559410000000035B72E41666666E674A55941333333333DB72E410000002076A559416666666647B72E419A99991977A55941666666664BB72E413333335378A55941CDCCCCCC45B72E419A9999197AA559413333333340B72E41000000A07BA559413333333340B72E41000000A07CA559413333333348B72E419A9999597DA559416666666652B72E41333333137EA559419A9999995AB72E41CDCCCC4C7FA55941CDCCCCCC5CB72E416666660681A559413333333357B72E41CDCCCC8C82A55941333333334BB72E413333335383A559413333333343B72E419A99999983A559416666666635B72E416666666684A559419A9999992DB72E41666666A685A559419A99999927B72E41666666A686A559410000000028B72E416666666688A559410000000029B72E41CDCCCC6C89A55941666666662AB72E41666666E68AA559419A99999928B72E41666666668CA55941CDCCCCCC20B72E41333333B38CA5594100000000FFB62E41666666C68DA5594100000000F5B62E41666666C68DA55941CDCCCCCCE8B62E41333333D38CA55941CDCCCCCCDEB62E41333333D38BA55941CDCCCCCCD6B62E41000000E08BA55941CDCCCCCCCCB62E41000000208DA5594133333333C5B62E41666666668EA5594133333333BDB62E41CDCCCC6C8EA5594133333333B5B62E41333333738EA5594133333333AFB62E41333333338FA5594166666666A9B62E419A99997990A55941CDCCCCCC9BB62E41000000C092A559413333333390B62E41CDCCCC0C95A559413333333386B62E41CDCCCC0C95A55941333333336CB62E41000000A094A55941000000004EB62E41CDCCCCEC93A559413333333340B62E419A9999F994A559419A99999932B62E416666668696A559419A99999924B62E41CDCCCCCC97A55941CDCCCCCC12B62E419A99995998A55941CDCCCCCCFEB52E416666662698A55941CDCCCCCCE8B52E413333333398A5594100000000E1B52E419A9999F998A5594166666666D7B52E419A9999F99AA5594133333333D1B52E41000000809AA5594100000000C7B52E416666668699A5594100000000C3B52E41666666069AA5594133333333B9B52E41333333D39AA5594166666666ABB52E41CDCCCC6C9BA5594166666666A7B52E419A9999999BA559416666666697B52E41666666669BA559419A99999987B52E41CDCCCCEC9CA55941CDCCCCCC77B52E41333333339EA55941333333335EB52E4166666606A0A559419A99999954B52E41CDCCCC0CA2A55941000000004DB52E4133333393A4A559419A99999947B52E4133333393A9A559410000000044B52E4133333393ABA559416666666636B52E41000000E0ADA55941CDCCCCCC2CB52E41666666E6AFA55941000000002BB52E41666666E6B1A559416666666629B52E4166666666B4A55941CDCCCCCC21B52E41666666A6B6A559413333333318B52E41333333B3B8A55941333333331EB52E41CDCCCCACB9A559419A9999991EB52E41666666A6BBA55941CDCCCCCC1AB52E41CDCCCC6CBDA559419A99999911B52E41333333B3C2A559419A99999908B52E41333333F3C8A5594166666666E3B42E4133333373CDA559419A999999CCB42E41CDCCCC2CD2A55941CDCCCCCCB4B42E419A999999D4A55941000000009DB42E41CDCCCCECD4A559413333333382B42E4133333393D6A559416666666667B42E4133333393D8A559413333333344B42E41666666E6D9A559419A99999923B42E4133333393DBA559410000000004B42E419A9999F9DDA5594100000000F7B32E4100000020E0A559419A999999EAB32E419A999939E2A5594100000000C6B32E4166666606E8A5594133333333A8B32E41CDCCCC6CECA55941333333338EB32E41CDCCCC8CF0A55941000000007CB32E4100000000F4A559419A9999996BB32E419A9999B9F7A559410000000058B32E41CDCCCC6CFAA55941000000003FB32E419A9999F9FCA55941CDCCCCCC1EB32E4133333313FFA55941CDCCCCCCFAB22E41CDCCCC8C00A65941CDCCCCCCD4B22E416666660601A6594166666666ABB22E419A9999F900A659413333333377B22E41000000A000A65941333333334DB22E419A99995900A65941000000002AB22E41CDCCCCCC00A659416666666606B22E419A9999F901A6594100000000E8B12E410000008003A6594133333333CEB12E410000004005A659419A999999B8B12E41CDCCCC6C07A65941	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	01010000206A080000A97753B187BD2E41000000105AA45941	900280000	Z	Courtelevant	9002800	90028	90	27	6
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	01010000206A08000046517A5189212E41000000B02BB15941	900290000	Z	Cravanche	9002900	90029	90	27	1
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	01010000206A0800000C9C888BB2722E41CDCCCCFCFF9A5941	900300000	Z	Croix	9003000	90030	90	27	5
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	01010000206A0800003A052FE77D822E4166666606D6AE5941	900310000	Z	Cunelières	9003100	90031	90	27	2
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	01010000206A0800006550D8F656392E41CDCCCC7C93AD5941	900320000	Z	Danjoutin	9003200	90032	90	27	6
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	01010000206A080000F03809E757952E416666668685A25941	900330101	H	La Voinaie	9003301	90033	90	27	2
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	01060000206A08000001000000010300000001000000830000000000000044772E4100000040B2A059413333333359772E419A999999C1A05941666666668B772E41666666E6EEA059419A99999945782E41333333136EA159416666666639782E419A999959C0A15941CDCCCCCC85782E4133333353C1A159413333333304792E41CDCCCCECC5A1594100000000B6792E41666666C6CEA159419A999999617A2E4133333333D6A15941666666664B7A2E4166666606F7A15941CDCCCCCC267A2E41CDCCCCCC50A2594133333333A97A2E41666666A656A2594166666666E97A2E41CDCCCC6C5AA2594100000000217B2E41CDCCCC0C5BA2594166666666507B2E41000000205EA25941000000003A7B2E413333335363A2594100000000BB7B2E41CDCCCC8C69A2594166666666017C2E419A9999B96FA25941CDCCCCCC8D7C2E413333331377A2594100000000D47C2E419A9999F97BA259419A999999567D2E413333335383A259419A99999923872E410000008020A35941000000002E872E410000008025A359419A999999D7862E41CDCCCCCC5AA359410000000014872E41CDCCCC6C5CA35941666666660E872E41333333B362A35941666666666C872E419A9999D963A35941333333335B872E419A99991972A35941CDCCCCCC26882E41CDCCCCEC6DA35941000000002D882E41666666E674A35941CDCCCCCC85882E413333335379A359419A999999DE882E41000000407BA3594166666666BF882E416666660668A359410000000096882E413333335353A359419A99999971882E41333333B34AA35941CDCCCCCC6D882E419A9999D93FA359419A9999997B882E41666666263DA35941CDCCCCCCEB882E419A9999B938A359413333333326892E41CDCCCC2C2DA35941CDCCCCCC60892E419A99993924A359416666666680892E41666666861AA359410000000091892E41CDCCCC8C11A3594100000000E1892E41666666C606A359419A9999990E8A2E419A999999FBA2594133333333138A2E41333333F3F4A2594166666666FC892E41CDCCCC0CEEA2594100000000D8892E41CDCCCC8CE9A2594100000000B1892E419A999939DFA25941CDCCCCCCA7892E419A999999CBA259410000000085892E41CDCCCCACBAA259419A9999998F892E41CDCCCC8CA1A2594166666666A1892E41333333F398A25941CDCCCCCCD2892E419A9999F98EA2594100000000BF892E41666666C688A25941CDCCCCCCCE892E41000000C07FA2594100000000C5892E413333335377A2594100000000B0892E413333339370A259419A999999A7892E419A9999F963A259419A99999992892E419A9999F957A2594166666666A1892E419A99991949A259419A999999B8892E41CDCCCC4C40A2594133333333148A2E419A9999992BA25941666666665D8A2E413333337319A2594133333333A88A2E410000008017A259416666666681892E416666662604A259419A999999B1892E419A9999F9F5A1594166666666F3892E41666666A6F6A1594133333333058A2E4133333353F2A15941CDCCCCCC288A2E4100000040F0A15941CDCCCCCC378A2E41666666E6E6A159419A999999068A2E419A9999D9E6A15941CDCCCCCC0D8A2E41666666E6DEA159419A9999993F8A2E41CDCCCCECDBA1594166666666A78A2E4100000060D3A1594100000000E88A2E41666666E6D1A1594133333333EE8B2E419A999999D4A1594100000000FF8B2E4166666666D6A15941CDCCCCCC3B8C2E419A999979D5A1594100000000808C2E4100000020D9A1594166666666028D2E41666666C6DBA15941000000004A8D2E4166666626DFA1594166666666898D2E419A9999D9E5A159419A999999C68D2E4133333373F2A15941333333333F8E2E4166666686EEA1594133333333A48E2E4166666666EAA15941CDCCCCCC318F2E4100000080E2A1594100000000E28F2E4100000040D6A15941CDCCCCCC708F2E419A999999C8A15941CDCCCCCC568F2E4166666606CCA159419A999999358F2E41CDCCCC0CC3A1594133333333158F2E41000000E0B6A159419A999999E48E2E419A9999D9A7A1594100000000518E2E41CDCCCCEC98A15941CDCCCCCC3C8E2E410000000093A159419A999999AE8D2E413333339384A15941333333337E8E2E416666662652A15941CDCCCCCC938C2E41666666C632A1594133333333958C2E41333333B320A15941666666660E8C2E416666662613A1594100000000098A2E419A999959EBA05941CDCCCCCC8A882E41000000A0D2A05941CDCCCCCC23872E41666666E6BDA0594100000000AF852E41CDCCCC0CA0A05941CDCCCCCC8C842E413333337377A05941CDCCCCCC6C842E416666660674A059416666666693822E41000000C092A059416666666685822E41000000A08BA05941CDCCCCCC59822E41333333538EA059419A9999991F822E419A99999982A05941333333339C812E419A9999D98EA05941CDCCCCCC4E812E419A9999B9A5A0594166666666F4802E41CDCCCC2CA0A0594133333333CC802E419A9999F99EA059419A9999999A802E41666666C6A2A059410000000019802E41CDCCCCECA7A0594133333333297F2E41CDCCCCECA6A05941333333331F7F2E4133333333A8A059419A999999207F2E41CDCCCC6CBDA0594100000000687F2E4133333313D0A05941CDCCCCCC727F2E41CDCCCC8CDCA05941CDCCCCCCFA7E2E41333333B3DCA0594133333333DD7E2E419A999979E0A059419A999999ED7D2E419A999979E4A0594100000000FE7C2E419A9999F9E5A05941CDCCCCCC367C2E4100000060E2A0594166666666127B2E41666666E6D6A05941000000004A7A2E419A999979CFA0594100000000CE782E41CDCCCC6CC0A059419A99999973782E41666666C6B7A059410000000044772E4100000040B2A059410000000044772E4100000040B2A05941	01010000206A0800005409E6DEF6812E4100000090F7A15941	900330102	H	Les Pasles-Les Vignes	9003301	90033	90	27	5
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	01010000206A0800004A725C132E8C2E41666666469AA25941	900330103	H	Centre Ville	9003301	90033	90	27	2
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	01010000206A08000096CD6219AF502E41666666F6ADB15941	900340000	Z	Denney	9003400	90034	90	27	4
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	01010000206A08000095F6C1C9102C2E419A9999A900AA5941	900350000	Z	Dorans	9003500	90035	90	27	4
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	01010000206A080000B81E85FB045D2E41666666864EB45941	900360000	Z	Eguenigue	9003600	90036	90	27	3
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	01010000206A080000B9C9AF77E6392E413333336307B55941	900370000	Z	Éloie	9003700	90037	90	27	6
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	01010000206A08000064753041FB1A2E41343333A37EAF5941	900390000	Z	Essert	9003900	90039	90	27	7
01060000206A080000010000000103000000010000004C010000CDCCCCCCBE452E41CDCCCC0CA7BA5941000000000A422E41CDCCCC8C77BB594166666666FE412E41333333337BBB5941CDCCCCCCBC412E41CDCCCCEC8FBB5941CDCCCCCCD6402E41666666A6D8BB59419A999999E8402E419A9999B9D8BB594100000000FF422E4100000000DBBB59419A999999B2432E41000000C0DBBB59419A9999995E442E4133333373DCBB594133333333B5442E419A9999D9DCBB59419A999999EE442E4133333313DDBB5941333333330C452E41CDCCCC0CD8BB59410000000031452E419A9999D9D4BB5941666666664C452E41CDCCCC0CD4BB59419A99999958452E419A9999F9D2BB59419A99999978452E4100000020CFBB59413333333390452E4166666606CBBB594166666666A7452E41CDCCCC2CCABB59419A999999B7452E4100000040C9BB5941CDCCCCCCCF452E419A999959C8BB5941CDCCCCCCD8452E4133333393C7BB594133333333FD452E4100000060C3BB59419A99999911462E41666666A6C1BB59413333333333462E41CDCCCCACBFBB5941CDCCCCCC41462E4133333393BDBB5941000000004B462E419A999919BBBB5941666666666C462E419A9999D9B7BB5941666666666A462E419A999919B6BB5941666666666A462E41CDCCCC4CB4BB5941CDCCCCCC64462E4100000060B1BB5941000000007A462E419A999999B1BB59419A9999999D462E41666666A6B1BB594100000000BE462E41CDCCCC4CB2BB594100000000D1462E41000000E0B1BB594133333333ED462E41666666C6B1BB594166666666F2462E4166666666B1BB594133333333F4462E419A9999B9B0BB594133333333FD462E4133333333B0BB59413333333316472E419A999979AFBB5941CDCCCCCC25472E41CDCCCC8CAEBB5941CDCCCCCC51472E41CDCCCC2CABBB59410000000063472E4100000040AABB5941CDCCCCCC7F472E419A999939A9BB5941CDCCCCCC8F472E419A999959A9BB5941CDCCCCCCAF472E41CDCCCC8CAABB5941CDCCCCCCBB472E41000000C0AABB5941CDCCCCCCC6472E41000000A0AABB59419A999999D0472E419A9999B9A9BB594100000000DF472E419A999959A7BB594166666666EF472E41666666C6A5BB594100000000FF472E4133333373A4BB59419A99999938482E419A9999B9A0BB59419A99999961482E419A9999F99DBB59419A99999986482E41666666E69BBB594133333333A7482E419A9999599ABB59419A999999B6482E41000000009ABB594100000000CA482E41333333139ABB59419A999999EE482E41000000C09ABB5941CDCCCCCC02492E41333333339BBB5941CDCCCCCC39492E41333333D39CBB5941CDCCCCCC6E492E41CDCCCC8C9DBB59419A99999979492E41333333139EBB5941000000009E492E4133333313A0BB5941CDCCCCCCB3492E41CDCCCC8CA1BB594133333333D3492E419A9999F9A3BB594133333333EA492E41CDCCCCACA4BB594166666666F8492E41666666C6A4BB594100000000094A2E41666666C6A4BB59419A999999194A2E4166666686A4BB5941000000002B4A2E41CDCCCC0CA4BB5941CDCCCCCC444A2E4100000040A3BB5941333333332C4D2E41CDCCCCEC8CBB594100000000334D2E419A9999B98CBB59419A999999AA4D2E41000000A08FBB5941CDCCCCCC104E2E410000002092BB594100000000E4502E41666666C6A3BB59419A999999D9512E41000000C0A9BB5941CDCCCCCCE7522E4133333353B0BB59419A999999F7532E41333333F3B6BB594133333333A6542E419A9999399FBB594100000000AF552E41666666E687BB59419A999999BE552E410000006085BB594133333333D0552E419A99993981BB59410000000004562E41666666C66EBB59416666666615562E410000006067BB59413333333323562E41333333B363BB59413333333333562E410000008060BB59416666666648562E419A9999B95CBB59410000000056562E41333333F35ABB59413333333390562E419A9999D952BB594100000000AC562E410000000051BB594133333333C0562E41666666264BBB594133333333C0562E41000000A04ABB59416666666658572E413333335331BB59416666666670572E41CDCCCC4C2DBB594166666666BB572E419A99995908BB5941CDCCCCCCCA572E41000000C000BB594166666666DE572E4133333353FCBA59413333333339582E41000000C0E7BA59413333333349582E4133333333E4BA5941CDCCCCCC81582E41CDCCCC6CD7BA5941CDCCCCCCFB582E41CDCCCC2CADBA59419A99999901592E419A999939ABBA5941666666663B592E41CDCCCCACA5BA594166666666605A2E419A99997989BA594100000000CF5A2E41333333D37EBA594133333333FE5A2E419A9999397CBA59419A999999315B2E41CDCCCC6C79BA594166666666BC5B2E41CDCCCCCC71BA594133333333A55C2E416666660665BA5941CDCCCCCCA95C2E410000006064BA59419A999999BD5C2E410000008061BA594133333333285D2E41666666E651BA594100000000A95D2E41000000203FBA5941000000006D5E2E410000008022BA59419A999999985E2E419A99991919BA594100000000A25E2E413333331317BA594133333333AD5E2E41666666A614BA594100000000BA5E2E41000000E011BA594100000000345F2E4166666666F5B959419A999999605F2E41000000C0EBB9594100000000FB5F2E4133333353D0B95941666666663E602E4166666666C4B959419A9999994A602E419A999939C2B9594100000000BA602E41CDCCCC6C98B95941CDCCCCCCC1602E410000008095B959419A999999CA602E416666662692B95941CDCCCCCCDF602E419A9999198AB9594133333333E1612E410000002028B95941CDCCCCCCEA612E413333337324B95941333333330A622E413333339318B959416666666628622E41333333130DB959410000000068612E41333333F31BB95941CDCCCCCC865F2E4166666646C1B85941CDCCCCCC645D2E419A99995955B859419A999999115D2E41666666A64AB8594166666666D55C2E41000000E042B8594166666666B95C2E41CDCCCCEC3FB85941333333336A5C2E419A99997937B85941CDCCCCCC635C2E41CDCCCCCC36B85941666666667A5B2E41CDCCCCEC1DB8594100000000F75A2E416666668615B8594166666666EB5A2E416666666614B8594133333333805A2E41CDCCCC2C0DB859419A9999997A5A2E41CDCCCC6C0CB85941CDCCCCCCA4592E4166666626F0B759419A99999915592E41CDCCCC4CDEB75941CDCCCCCCFC582E4133333353DBB75941CDCCCCCCA3582E41666666A6CFB75941333333333A582E419A999939C2B759410000000085572E419A9999B9ABB759419A9999998E572E4133333333A9B7594166666666BE572E41000000009EB7594100000000D9572E419A99993998B7594133333333E9572E410000006094B7594100000000F4572E41000000C090B75941CDCCCCCCFC572E41333333938CB759419A99999924582E419A9999B973B759416666666627582E419A9999F971B759419A99999938582E41666666266BB75941CDCCCCCC40582E41CDCCCC6C68B75941CDCCCCCC2B572E419A9999995CB75941CDCCCCCC1F572E41CDCCCC0C5CB759419A99999902572E419A99995959B75941666666667B562E419A9999B94CB75941CDCCCCCCF4552E410000002040B759419A999999D6552E41666666C63DB75941333333331C552E41333333332FB759413333333382532E41000000200FB759413333333349512E419A999999E2B659419A999999CF4F2E4166666626BAB659419A999999E54E2E41000000A0B0B6594100000000894D2E419A999919A6B659419A999999854D2E4100000020A8B6594133333333E34A2E41333333139DB6594166666666664A2E41000000009BB659410000000018492E41000000E08DB65941CDCCCCCCA6482E419A9999B98FB659419A99999910482E416666662692B659413333333386472E410000006094B65941666666662B472E419A9999D995B65941CDCCCCCC1E462E41666666C692B65941666666661C452E41666666C68FB659416666666692432E41333333338BB65941CDCCCCCCC2432E41CDCCCCACAFB6594133333333C2432E4166666666B1B6594166666666BA432E41CDCCCC0CB4B6594100000000B6432E4166666646B6B65941CDCCCCCCB4432E4100000080B8B659419A999999B5432E41CDCCCCCCB9B659419A999999B9432E41333333F3BAB6594133333333BC432E41000000C0BDB6594133333333C1432E41000000E0BEB659419A999999D6432E4133333373C5B6594133333333DD432E419A999999C6B65941CDCCCCCCEC432E4133333353C8B6594133333333F2432E41CDCCCCECC9B659410000000008442E41CDCCCC0CCBB65941CDCCCCCC10442E41000000C0CBB659410000000017442E419A999979CCB659410000000026442E419A999919CFB65941CDCCCCCC2E442E419A999959D1B659413333333340442E4133333313D4B65941666666665D442E419A9999B9D4B659416666666667442E4133333393D5B65941CDCCCCCC72442E4133333353D7B65941333333337A442E419A999959DAB65941000000007C442E4133333373DCB65941000000007A442E419A9999B9E2B659419A99999975442E4100000080E7B659413333333375442E41CDCCCC6CEAB659419A9999997A442E419A999979ECB659410000000082442E41CDCCCCCCEDB65941CDCCCCCC86442E41CDCCCC8CF3B659410000000085442E41CDCCCC8CF7B659416666666678442E419A999919FBB65941CDCCCCCC6D442E41666666E6FCB659419A99999958442E413333337302B759419A99999956442E41666666A604B759413333333356442E41CDCCCCCC0AB759413333333347442E41000000C00EB75941666666663F442E41333333B314B759413333333333442E41333333B317B75941000000002E442E41000000E01AB75941333333333F442E41333333B31BB759410000000048442E41CDCCCCEC1CB759410000000048442E419A9999591EB759410000000045442E419A99993920B75941666666663A442E419A99999925B75941666666663A442E41000000A027B75941333333333A442E416666660628B75941666666663A442E41666666E629B75941333333333A442E41000000C02AB75941CDCCCCCC3A442E41666666062CB75941CDCCCCCC24442E419A9999B933B759419A9999991C442E413333333339B75941333333331A442E419A9999B93BB75941333333331A442E41000000203EB75941000000001C442E416666668640B759416666666621442E41333333B344B759419A99999931442E41333333734BB75941CDCCCCCC43442E416666664650B759416666666652442E41333333B352B759416666666653442E416666660654B75941CDCCCCCC50442E413333331359B759419A99999950442E419A9999395CB759419A9999994D442E41000000C05EB759419A99999951442E410000004060B75941000000005F442E410000002063B75941000000005E442E41CDCCCC2C67B759419A99999962442E41666666E66DB75941CDCCCCCC65442E41666666C66FB75941CDCCCCCC6C442E413333337371B759410000000072442E416666664672B7594100000000AB442E419A9999B980B7594100000000AD442E41000000A080B75941CDCCCCCCB5442E41CDCCCC6C82B75941CDCCCCCCBC442E419A99997983B7594133333333C7442E41CDCCCC8C84B7594100000000DC442E41CDCCCCEC87B7594166666666FD442E416666664690B759416666666600452E410000004090B759419A99999908452E41CDCCCC0C91B759419A9999990C452E410000006092B75941CDCCCCCC1A452E41CDCCCC8C92B75941CDCCCCCC1F452E416666668698B759419A99999924452E41666666E69BB75941CDCCCCCC2B452E41000000C09EB75941CDCCCCCC46452E41000000A0A9B75941666666664D452E41CDCCCC0CAEB75941666666664C452E41666666E6AFB759416666666652452E41333333B3B5B75941CDCCCCCC5C452E4133333333B9B759416666666668452E4100000060C0B759416666666680452E4166666646CDB75941CDCCCCCCB2452E4133333373D0B7594166666666B6452E419A9999F9D7B75941CDCCCCCCBA452E41000000E0E1B75941CDCCCCCCC2452E41000000C0F2B759419A99999938462E4166666686F3B7594100000000BB462E41CDCCCC6CF4B759416666666685472E41000000C0F5B75941CDCCCCCC8E472E4133333313F6B759410000000021492E419A9999B902B85941333333336E492E41666666860AB859419A999999AD492E41333333F310B85941CDCCCCCC5D4A2E419A9999D922B8594133333333404B2E41CDCCCCAC2DB85941CDCCCCCC654B2E410000006030B8594100000000E54B2E41CDCCCC8C39B85941333333331C4C2E41666666C645B8594100000000214C2E41000000E046B85941CDCCCCCC044D2E41CDCCCC4C79B85941333333332E4D2E419A99997982B859419A999999314D2E410000004083B859419A999999364D2E41CDCCCC4C8FB85941000000003C4D2E41333333939BB85941000000003F4D2E4166666626A3B85941CDCCCCCC414D2E4100000080A9B8594166666666444D2E4166666686AFB8594166666666484D2E41CDCCCCACB8B85941000000004B4D2E4133333373BFB85941333333334C4D2E419A999939C2B85941000000004E4D2E41CDCCCC6CC6B85941666666662B4D2E419A999999DBB859419A999999064D2E41CDCCCC2CF2B85941CDCCCCCCFC4C2E419A999919F8B859419A999999D64C2E41CDCCCC6CFDB85941CDCCCCCC3A4C2E419A99993913B959419A999999064C2E41000000801AB9594133333333FE4B2E419A9999391EB9594100000000F54B2E41CDCCCC4C22B9594133333333D34B2E413333335331B9594100000000B84B2E41CDCCCC4C3DB9594166666666874B2E41666666E652B959419A999999714B2E41666666865CB959419A999999674B2E416666660661B9594166666666534B2E419A9999F969B9594133333333404B2E419A99997972B959419A999999314B2E41CDCCCCEC78B95941000000000C4B2E41000000A089B9594133333333EC4A2E41CDCCCC8C9BB9594133333333D74A2E41666666E6A4B95941666666669D4A2E419A999999BEB959419A999999734A2E4166666626D1B9594166666666F8492E41CDCCCC2C02BA594100000000DB492E41666666E60DBA594133333333A0492E413333337316BA594100000000E5482E41CDCCCCAC31BA59416666666645482E41CDCCCCEC48BA59416666666656462E419A9999F990BA5941CDCCCCCCBE452E41CDCCCC0CA7BA5941	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	01010000206A08000002221F73BF562E410000005037B95941	900410000	Z	Étueffont	9004100	90041	90	27	13
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	01010000206A08000063A3CE6EBE0F2E4133333343CFB25941	900420000	Z	Évette-Salbert	9004200	90042	90	27	9
01060000206A080000010000000103000000010000007501000000000000FC962E419A9999F979A359413333333358972E410000008092A359410000000066972E4166666666A8A359416666666667972E41666666E6B0A35941000000006B972E41666666E6B3A359413333333384972E4166666626BCA35941CDCCCCCC99972E41333333B3C2A359419A999999A4972E41CDCCCC6CC6A3594100000000B6972E4166666646CCA35941CDCCCCCCB9972E4133333313CEA3594100000000BF972E4133333313D1A359419A999999C4972E419A999999D4A359419A999999C8972E4100000000D9A35941CDCCCCCCCF972E41CDCCCCECDAA35941CDCCCCCCE0972E41333333F3DEA35941CDCCCCCCE6972E4100000040E3A3594166666666F2972E4133333393EAA3594166666666F7972E41000000E0EEA35941000000000A982E41CDCCCCECF2A35941333333331B982E419A999999F6A35941333333332C982E4100000020FAA359413333333344982E4133333373FDA359419A9999995A982E419A9999F9FFA359410000000076982E416666664603A459419A9999998A982E41CDCCCCEC05A4594166666666A3982E41333333F308A4594100000000BF982E41666666460CA4594100000000D3982E41333333B30EA45941CDCCCCCCE0982E41333333F310A4594166666666EA982E419A9999F912A4594133333333F8982E410000006015A45941CDCCCCCCFF982E419A99997917A45941CDCCCCCC05992E41666666C619A459419A99999922992E413333333320A45941666666661F992E410000006022A459413333333318992E41CDCCCC2C24A45941CDCCCCCC1B992E410000000028A459413333333337992E41666666062EA459419A9999994E992E416666664633A459410000000063992E41CDCCCC0C37A45941CDCCCCCC75992E419A9999793AA459413333333383992E41333333133DA459413333333392992E41000000203FA45941CDCCCCCCA6992E416666662642A4594166666666B0992E41666666E648A459419A999999E2992E419A9999B952A45941666666669B992E41666666066CA45941CDCCCCCC87992E41CDCCCC6C73A459410000000082992E41CDCCCC2C86A459413333333373992E41CDCCCC2CA8A45941CDCCCCCC6F992E41333333D3B8A45941000000005D992E4166666606C6A45941CDCCCCCC22982E4166666686BDA459416666666601982E41666666E6CEA4594100000000F7972E41CDCCCCCCD8A4594166666666E6972E4133333353E2A459419A999999DF972E419A9999D9EAA459419A999999EE972E41CDCCCC8CF2A459419A999999FD972E4166666646F8A45941666666660A982E4100000040FEA459419A9999991F982E41CDCCCC2C08A559416666666639982E416666662614A55941666666664E982E419A9999D91AA5594166666666A0982E416666666629A5594100000000E8982E410000008034A55941CDCCCCCCF4982E419A99997939A559416666666609992E41333333333FA559419A99999916992E41000000E042A55941000000001C992E41CDCCCC4C46A559416666666623992E41CDCCCC6C4BA559419A9999992C992E41666666A64FA55941666666663A992E419A9999D953A55941666666664F992E416666660658A559419A99999960992E41333333335BA559410000000074992E41333333535FA559416666666681992E41CDCCCC0C62A55941333333338F992E41333333F364A559410000000098992E410000008067A55941333333339C992E419A9999D96AA55941CDCCCCCCC4992E41000000C074A5594100000000F5992E41666666E690A55941000000001B9A2E41CDCCCC8CA0A55941000000004A9A2E41666666A6BAA5594100000000A19A2E4133333353CDA5594133333333CC9A2E419A999959D6A559419A999999E89A2E4100000040DCA55941CDCCCCCC219B2E4100000060DFA55941CDCCCCCC9A9B2E41CDCCCC2CE7A5594166666666EB9B2E41333333B3EBA5594100000000359C2E4100000020F1A559419A999999989C2E4133333393F7A5594100000000879D2E419A9999590AA6594166666666C49D2E419A9999F90BA6594100000000019E2E41333333D30CA6594166666666229E2E41CDCCCC8C0DA65941CDCCCCCC369E2E419A9999F90DA65941CDCCCCCC659E2E41CDCCCC6C0EA65941CDCCCCCC8D9E2E41CDCCCCAC0EA659419A999999C29E2E41000000600FA6594166666666EB9E2E416666664610A65941CDCCCCCC069F2E419A9999B910A6594166666666229F2E410000004012A6594133333333499F2E41CDCCCC8C13A65941333333335B9F2E416666662614A659419A999999BF9F2E41333333B317A65941CDCCCCCC21A02E41333333D31BA65941000000006FA02E41000000A01EA6594133333333BAA02E410000002022A659419A999999EBA02E419A9999B924A6594166666666FFA02E419A99993927A65941000000000DA12E41000000E028A659419A99999915A12E41666666E629A65941666666663BA12E41666666062BA659413333333349A12E41666666462DA65941000000005EA12E410000006031A659419A99999978A12E413333333336A659410000000089A12E41333333B33AA65941333333338DA12E41CDCCCC2C3EA65941CDCCCCCC90A12E41000000E041A65941CDCCCCCC93A12E410000002046A65941CDCCCCCC91A12E41666666464AA659413333333390A12E41CDCCCC2C4EA65941666666668BA12E413333339352A659410000000087A12E41CDCCCC6C56A659413333333384A12E419A99999959A659416666666682A12E41666666265DA659413333333380A12E41CDCCCCAC61A65941000000008BA12E410000000063A65941666666669BA12E416666660665A6594100000000C5A12E41666666A666A6594100000000E5A12E41333333B367A659419A99999907A22E410000006068A659413333333338A22E41CDCCCC4C68A659419A99999949A22E41666666A667A65941000000005BA22E413333339366A65941000000007CA22E413333333365A65941CDCCCCCCA1A22E413333331369A6594100000000CAA22E419A99995966A6594100000000E8A22E41333333F364A659413333333308A32E41CDCCCC6C63A659413333333320A32E41CDCCCCEC65A659413333333351A32E416666662663A65941333333335BA32E416666666662A659410000000063A32E41000000A060A65941000000006FA32E410000002060A659410000000077A32E41000000E060A659413333333389A32E410000002063A6594133333333B7A32E413333331363A6594133333333CBA32E41CDCCCC4C66A6594100000000D0A32E41CDCCCCEC65A6594133333333DDA32E41666666C664A659419A999999DCA32E419A9999F963A6594100000000DBA32E416666664661A65941CDCCCCCCFCA32E41000000005EA659413333333303A42E419A9999595EA65941666666660BA42E41000000805DA65941333333331BA42E41000000E05BA659419A99999928A42E410000008057A659416666666639A42E41CDCCCCEC50A659413333333347A42E419A9999394BA659419A99999951A42E410000006047A65941CDCCCCCC5AA42E410000000043A65941CDCCCCCC68A42E419A9999793DA659419A99999976A42E41CDCCCC4C38A659419A99999982A42E419A9999D935A65941CDCCCCCC96A42E416666664633A6594100000000AEA42E41333333B330A65941CDCCCCCCD3A42E419A9999B92CA659410000000001A52E413333331328A65941333333332EA52E413333339322A659413333333352A52E41666666861EA65941CDCCCCCC84A62E41CDCCCC8C01A65941666666668EA62E41333333D300A6594166666666A7A62E413333335300A659419A9999990DA72E41CDCCCC8C01A65941000000004CA72E41666666C602A659410000000093A72E416666660605A659419A999999C8A72E41CDCCCC6C05A65941666666663CA82E416666664602A65941CDCCCCCC89A82E419A9999D900A6594133333333A3A82E41666666C6FEA5594166666666BAA82E41666666E6FCA5594166666666D2A82E419A9999B9FAA55941CDCCCCCCE3A82E4166666666F8A5594100000000F2A82E41CDCCCCECF5A55941CDCCCCCCFBA82E4100000000F2A559410000000006A92E4100000040ECA559410000000014A92E41000000A0E5A55941CDCCCCCC1EA92E4133333393E2A55941CDCCCCCC2AA92E4100000000E1A559416666666618A92E419A9999B9DDA559419A99999916A92E4166666666DDA55941CDCCCCCC10A92E41CDCCCCACDBA559416666666608A92E4166666686D8A5594133333333FEA82E4100000040D4A5594133333333F3A82E4166666686CFA559419A999999E8A82E419A9999D9CAA559419A999999D9A82E4133333373C4A5594166666666CDA82E4133333313C0A559419A999999C0A82E4166666646BCA5594133333333AFA82E4133333353B8A55941333333339EA82E419A999999B3A55941333333338CA82E4100000040AFA559410000000075A82E4100000040A9A55941666666666DA82E4166666686A7A55941CDCCCCCC27A82E41333333F39BA559419A999999D0A72E419A9999197DA5594166666666C9A72E41333333737BA55941CDCCCCCC66A72E41CDCCCCEC64A559410000000030A72E416666666658A55941666666663EA72E41333333134EA559419A99999956A72E419A9999793CA5594133333333E8A72E41CDCCCCAC0EA5594100000000FAA72E410000002009A5594133333333FCA72E410000006008A559410000000040A82E41CDCCCC0CF3A459416666666684A82E4100000080DDA459416666666686A82E41000000E0DCA45941333333339DA82E419A9999B9D5A45941CDCCCCCC2AA92E41CDCCCCACA8A45941333333332BA92E4133333373A2A45941CDCCCCCCC9A82E41666666668CA4594166666666F4A82E410000002074A459416666666604A92E41CDCCCC0C6BA459419A9999990AA92E419A99991967A45941000000000CA92E410000004064A459419A99999911A92E41666666865FA45941666666663BA92E419A9999B956A459410000000045A92E41333333134FA45941CDCCCCCC75A92E410000000038A459419A99999991A92E419A9999992CA459413333333390A92E41666666862CA45941000000009FA92E413333333327A45941CDCCCCCCBFA92E419A9999D91BA459419A999999C5A92E41333333F31AA45941CDCCCCCCD0A92E413333335317A45941CDCCCCCCDAA92E41333333F313A4594166666666E5A92E419A99993910A4594100000000EBA92E41666666860EA4594133333333F0A92E41333333B30CA4594133333333F3A92E41333333D30BA45941CDCCCCCCF8A92E41000000800BA459419A99999902AA2E419A9999D90BA459419A99999919AA2E41333333B306A459419A9999993CAA2E41666666C6FEA35941CDCCCCCC52AA2E4133333393FAA35941000000005DAA2E41CDCCCCACF8A359419A99999978AA2E4100000020F3A35941666666668AAA2E4133333313EFA359419A99999996AA2E419A9999D9EBA35941000000003AAA2E419A999919E2A3594133333333C4A92E4100000080D5A35941CDCCCCCC7EA92E419A9999D9CDA359413333333315A92E4100000000C2A35941CDCCCCCCBEA82E41666666C6B8A35941666666665CA82E41666666C6ABA3594166666666DCA72E419A9999399AA359413333333399A72E410000008091A359416666666697A72E41CDCCCC6C91A359413333333387A72E41333333738FA35941CDCCCCCC54A72E410000004089A359416666666618A72E413333339380A3594166666666CFA62E41CDCCCCEC54A3594133333333EDA62E416666666652A35941000000000BA72E410000002051A35941666666660AA72E410000002047A359416666666650A62E41666666A6EEA259416666666618A22E4133333353E3A25941CDCCCCCC2DA02E419A999959D7A2594133333333519F2E419A999959CCA2594100000000ED9E2E419A999979C7A259419A9999995B9D2E41CDCCCCECAEA259419A9999991A9C2E41666666C69DA2594166666666669B2E419A9999B997A25941CDCCCCCCFA9A2E41333333D3BAA25941CDCCCCCCAC9A2E41666666A6D7A2594100000000689A2E41333333B3E6A259419A999999549A2E419A9999B9F0A25941CDCCCCCCE8992E41CDCCCCCC0EA3594100000000D6992E41333333131FA35941CDCCCCCC9C992E419A99991947A359416666666691992E41666666066CA35941CDCCCCCC8D992E41333333736CA35941CDCCCCCC86992E41CDCCCCEC6DA359416666666682992E41666666066FA35941333333337F992E41666666A66FA35941333333337A992E41333333B370A35941CDCCCCCC76992E41CDCCCC4C71A35941CDCCCCCC70992E419A9999F971A35941666666666B992E413333335372A359413333333363992E41666666C672A35941666666665C992E419A9999F972A35941CDCCCCCC50992E41333333F372A359410000000049992E41666666C672A359419A99999942992E41CDCCCC8C72A35941333333333A992E410000002072A359419A99999931992E41CDCCCCAC71A35941666666662C992E413333337371A359410000000027992E413333333371A35941666666661D992E41000000A070A35941666666660C992E419A99991970A359413333333306992E413333331370A3594100000000FE982E410000004070A35941CDCCCCCCF8982E416666668670A3594133333333F2982E410000000071A359419A999999E4982E410000008071A3594100000000DF982E41CDCCCC4C71A35941CDCCCCCCD8982E41CDCCCC8C70A359419A999999D5982E41CDCCCCEC6FA3594100000000D0982E41CDCCCCEC6EA3594166666666C4982E419A9999B96DA3594166666666B3982E41000000806CA359419A9999998B982E41CDCCCC8C6AA359416666666683982E419A9999796AA35941666666667D982E41CDCCCC6C6AA359416666666667982E41000000C06AA359416666666653982E419A9999396AA35941CDCCCCCC4C982E41CDCCCCEC69A359416666666647982E413333339369A359416666666640982E410000002069A359419A99999936982E413333333369A359419A99999927982E41333333D36AA359416666666622982E419A9999B96BA35941CDCCCCCC1E982E419A9999596EA359413333333320982E419A9999D96FA359416666666618982E41CDCCCC2C72A359410000000014982E41000000A072A35941666666660D982E416666662673A359410000000003982E41666666C673A3594166666666F6972E41666666A674A3594166666666EC972E41CDCCCC6C74A359419A999999DE972E41CDCCCCEC73A3594133333333D7972E416666668673A35941CDCCCCCCCE972E41000000C072A3594166666666C7972E410000000072A3594133333333C2972E419A99997971A3594100000000BD972E419A9999B970A3594100000000B2972E41333333536FA35941CDCCCCCCAD972E41333333736EA359419A999999AB972E41666666C66DA3594133333333A8972E41CDCCCC4C6CA3594100000000A7972E41666666666BA3594100000000A6972E41000000A06AA3594133333333A4972E41000000E069A3594133333333A2972E41CDCCCC2C69A3594100000000A1972E41CDCCCCCC68A35941666666669C972E413333331368A359410000000094972E410000006067A359419A9999998A972E41CDCCCC0C67A35941666666667F972E419A99991967A35941333333337C972E410000004067A359413333333379972E419A9999B967A359410000000075972E41CDCCCCAC68A359419A99999973972E41CDCCCC2C69A359416666666673972E413333339369A359413333333373972E419A9999F96AA359419A99999973972E41333333336CA35941CDCCCCCC74972E41333333736EA359413333333374972E41666666066FA35941333333336A972E419A9999F970A359419A9999995F972E416666666671A35941000000003F972E413333331371A359416666666632972E41CDCCCC2C71A35941333333332F972E41CDCCCC4C71A35941000000002B972E41333333B371A359416666666629972E416666660672A35941CDCCCCCC27972E41CDCCCCEC72A35941CDCCCCCC27972E41666666A673A359410000000028972E41CDCCCC4C75A359410000000028972E41666666E676A35941000000001F972E413333335378A359410000000014972E41CDCCCC2C79A3594100000000FC962E419A9999F979A35941	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	01010000206A080000E8704AAD34A12E41666666267DA45941	900430000	Z	Faverois	9004300	90043	90	27	7
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	01010000206A08000021D71CF42C792E41666666267FB75941	900440000	Z	Felon	9004400	90044	90	27	4
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	01010000206A0800006A4926AC10722E413433331335A15941	900450000	Z	Fêche-l'Église	9004500	90045	90	27	4
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	01060000206A08000001000000010300000001000000390100009A99999938962E41000000E01FA85941000000003B962E419A9999593DA85941666666665F962E41CDCCCCCC3BA859416666666679962E41666666A645A85941CDCCCCCCC1962E410000000054A859410000000032972E410000006065A85941333333336E972E416666662672A859419A999999C9972E41666666E693A859419A999999ED972E4166666666A3A859416666666641982E419A9999F9C0A859413333333392982E41666666C6DFA85941333333330C9B2E419A9999F983A9594100000000399C2E4133333313CAA9594133333333099D2E4133333393FDA9594100000000789E2E413333337340AA59410000000075A02E41CDCCCC0C52AA5941CDCCCCCC8AA02E41CDCCCC6C47AA594133333333C4A02E41000000003BAA59419A999999E2A02E410000008030AA5941000000001AA12E419A9999992FAA5941CDCCCCCC2DA12E413333333326AA5941CDCCCCCC67A42E410000000054AA59419A99999960A42E41333333534CAA59419A9999993CA42E413333335345AA59410000000030A42E41666666A63EAA5941333333330FA42E41666666A622AA594100000000F9A32E41333333B303AA5941CDCCCCCC8DA52E419A999979D1A95941000000009AA62E41CDCCCC0CB8A959419A999999DFA62E419A999999C8A959419A9999994FA72E41666666A6D9A95941CDCCCCCC63A72E41CDCCCCCCD6A9594100000000D8A72E4100000040D0A95941CDCCCCCC7DA82E4166666606C8A959419A999999C5A82E4100000040C0A9594133333333F1A82E419A9999F9B1A95941333333335DA92E41CDCCCCCCBBA95941CDCCCCCC88A92E41CDCCCC0CC1A959410000000090A92E41000000C0B7A95941000000007EA92E41CDCCCC0CA6A95941CDCCCCCC2DA92E410000002097A95941CDCCCCCCDCA82E41CDCCCCAC89A9594166666666AFA82E41CDCCCC2C7FA959419A9999999FA82E410000002078A9594100000000AAA82E41CDCCCCEC72A959419A999999E3A82E41CDCCCCEC6FA959416666666652A92E410000000066A959416666666697A92E41333333335DA959419A999999C2A92E419A99999952A959419A9999997EAA2E41333333F33CA95941333333336AA92E41333333F32CA9594133333333A7A92E41CDCCCCAC1CA959419A999999EEA92E41666666A60DA95941666666661AAA2E419A9999190AA95941000000009AAA2E416666664606A959419A999999D1AA2E419A9999B900A95941666666663AAB2E4166666626F3A8594166666666CEAA2E41000000C0EAA85941000000004CAA2E41000000A0DEA85941CDCCCCCC47AA2E4166666666DAA859419A9999996BAA2E41000000A0D8A859416666666675AA2E41000000E0D1A85941333333338FAA2E419A999919D1A85941CDCCCCCC84AA2E41666666E6C2A859419A99999971AA2E41CDCCCC6CBAA85941000000004DAA2E41666666E6B5A859419A9999992DAA2E419A999919AFA859413333333322AA2E4133333353A4A85941666666661EAA2E41333333B391A8594100000000E6A92E41000000C083A859419A999999CFA92E413333337381A85941CDCCCCCC4DA92E416666660655A85941000000002FA82E41CDCCCC6C50A85941CDCCCCCC7BA72E41333333134BA859416666666636A72E416666666646A8594133333333A7A62E41CDCCCC8C40A859416666666634A72E41000000001FA859419A9999995DA72E416666668613A8594166666666B7A72E41333333B302A8594166666666E9A62E41666666E6E9A759419A999999AEA62E4100000060E4A759410000000008A72E41CDCCCC4CD9A759419A99999951A72E419A9999B9D3A7594133333333D9A72E419A999919D1A759410000000027A82E41CDCCCCCCCEA75941CDCCCCCC7CA82E419A999939CAA75941CDCCCCCC01A92E4100000020BEA759419A9999994DA92E41CDCCCC0CB5A75941CDCCCCCC84AB2E419A9999197DA75941CDCCCCCC80AD2E4166666626F5A6594166666666C6AE2E41000000409DA659410000000025AF2E41333333738EA659416666666651AF2E41000000006EA659419A99999973AF2E416666666660A659413333333397AF2E410000000057A659419A999999A0AF2E419A9999593CA65941000000009FAF2E41CDCCCCAC35A659413333333397B12E419A9999790DA659419A999999B8B12E41CDCCCC6C07A659416666666606B22E419A9999F901A65941333333334DB22E419A99995900A65941CDCCCCCCFAB22E41CDCCCC8C00A65941000000003FB32E419A9999F9FCA559419A9999996BB32E419A9999B9F7A55941333333338EB32E41CDCCCC8CF0A559410000000004B42E419A9999F9DDA559419A999999CCB42E41CDCCCC2CD2A559419A99999908B52E41333333F3C8A559419A9999991EB52E41666666A6BBA559413333333318B52E41333333B3B8A55941CDCCCCCC2CB52E41666666E6AFA559410000000044B52E4133333393ABA55941333333335EB52E4166666606A0A559416666666697B52E41666666669BA55941CDCCCCCCE8B52E413333333398A559419A99999924B62E41CDCCCCCC97A55941000000004EB62E41CDCCCCEC93A559413333333390B62E41CDCCCC0C95A5594133333333B5B62E41333333738EA55941CDCCCCCCD6B62E41000000E08BA5594100000000F5B62E41666666C68DA559419A99999928B72E41666666668CA559419A99999927B72E41666666A686A559413333333357B72E41CDCCCC8C82A559413333333340B72E41000000A07CA55941666666664BB72E413333335378A55941CDCCCCCC32B72E416666666673A55941000000004CB72E419A9999996EA559416666666646B72E41000000E064A559413333333323B72E419A9999795DA559419A99999922B72E419A9999F958A559413333333306B72E416666664657A559416666666611B72E416666660651A5594166666666FAB62E41333333134BA55941333333332FB72E41333333B343A559419A99999938B72E41CDCCCC6C40A559413333333383B72E410000004037A559410000000086B72E410000000030A559413333333357B72E41000000E02AA55941333333335EB72E419A99995924A559416666666601B72E41666666E6ECA45941CDCCCCCCB8B62E4133333373BCA45941CDCCCCCCB1B62E41CDCCCC8C9EA4594166666666ADB62E419A9999999CA45941CDCCCCCCBFB62E41666666064DA4594166666666C2B62E41CDCCCC0C36A459419A999999D6B62E419A99995922A45941CDCCCCCC33B72E419A999939ABA359419A99999945B72E41666666A62EA359416666666685B72E41000000A0D4A25941CDCCCCCCA5B82E419A999999C1A25941333333330BBA2E419A9999B9A0A259416666666684BB2E419A9999197CA259419A999999FBBB2E419A9999F971A2594166666666FBBB2E419A9999796FA259410000000017BB2E419A99993972A259413333333361B62E419A9999993CA25941666666664EB02E41000000A0F4A15941CDCCCCCCB6AE2E4133333313F5A1594133333333AAAD2E419A999959F0A1594166666666A6AC2E4133333373D6A1594133333333F3AB2E4100000020D4A15941666666668FAB2E41000000C0CCA159419A99999917AB2E41666666A6C1A1594100000000E2A92E4100000000A9A15941333333337EA92E419A9999199FA15941CDCCCCCC34A82E416666664685A15941333333334AA72E413333333377A159419A9999992AA62E419A9999D96EA159419A999999C7A52E41666666E669A15941000000007FA52E41CDCCCCAC64A15941333333338BA42E41666666C660A15941CDCCCCCC66A32E419A99993958A159416666666686A22E41000000C04CA159410000000015A22E410000000046A159419A999999E7A12E413333331347A159410000000078A02E416666664644A159419A999999B39F2E416666660650A15941666666660E9F2E419A9999F958A159419A9999996F9E2E410000004063A159419A999999BF9D2E413333335375A159419A9999995C9D2E419A99999980A1594133333333DB9C2E41CDCCCC0C82A15941CDCCCCCC859C2E419A99991979A1594166666666269C2E416666664688A15941CDCCCCCCBF9B2E41CDCCCCCC95A1594166666666719B2E41666666C6A5A1594133333333CC9A2E419A9999F9C8A1594133333333FA9A2E419A999939D5A15941CDCCCCCC089B2E419A9999F9E8A159419A9999992D9B2E41000000C0F2A15941CDCCCCCC029B2E41CDCCCC6CFBA15941CDCCCCCCF49A2E41000000400AA259419A999999759B2E419A9999D92DA2594133333333A19B2E41666666E63DA2594166666666A99B2E419A99997947A2594133333333C59B2E410000006050A259419A9999990B9C2E41333333F35DA25941CDCCCCCC349C2E419A99997967A259419A9999995F9C2E41333333B375A25941666666661F9C2E419A99993979A25941CDCCCCCC9B9B2E419A9999998CA2594166666666669B2E419A9999B997A259419A9999991A9C2E41666666C69DA259419A9999995B9D2E41CDCCCCECAEA2594100000000ED9E2E419A999979C7A25941CDCCCCCC2DA02E419A999959D7A259416666666618A22E4133333353E3A259416666666650A62E41666666A6EEA25941666666660AA72E410000002047A35941000000000BA72E410000002051A3594166666666CFA62E41CDCCCCEC54A359416666666618A72E413333339380A35941CDCCCCCC54A72E410000004089A3594166666666DCA72E419A9999399AA35941CDCCCCCCBEA82E41666666C6B8A3594133333333C4A92E4100000080D5A359419A99999996AA2E419A9999D9EBA359419A99999902AA2E419A9999D90BA4594133333333F3A92E41333333D30BA459413333333390A92E41666666862CA459410000000045A92E41333333134FA45941666666663BA92E419A9999B956A459419A99999911A92E41666666865FA459416666666604A92E41CDCCCC0C6BA45941CDCCCCCCC9A82E41666666668CA45941333333332BA92E4133333373A2A45941CDCCCCCC2AA92E41CDCCCCACA8A45941333333339DA82E419A9999B9D5A459419A99999956A72E419A9999793CA559410000000030A72E416666666658A559419A999999D0A72E419A9999197DA55941CDCCCCCC27A82E41333333F39BA55941666666666DA82E4166666686A7A559419A999999C0A82E4166666646BCA559419A999999D9A82E4133333373C4A559416666666608A92E4166666686D8A55941CDCCCCCC2AA92E4100000000E1A559410000000014A92E41000000A0E5A5594100000000F2A82E41CDCCCCECF5A5594166666666D2A82E419A9999B9FAA55941CDCCCCCC89A82E419A9999D900A659419A999999C8A72E41CDCCCC6C05A65941000000004CA72E41666666C602A6594166666666A7A62E413333335300A65941CDCCCCCC84A62E41CDCCCC8C01A659413333333352A52E41666666861EA6594100000000AEA42E41333333B330A659419A99999976A42E41CDCCCC4C38A65941333333331BA42E41000000E05BA6594100000000DBA32E416666664661A6594133333333CBA32E41CDCCCC4C66A6594133333333B7A32E413333331363A659413333333389A32E410000002063A65941000000006FA32E410000002060A659413333333320A32E41CDCCCCEC65A659413333333308A32E41CDCCCC6C63A65941CDCCCCCCA1A22E413333331369A65941000000007CA22E413333333365A659413333333338A22E41CDCCCC4C68A6594100000000E5A12E41333333B367A65941666666669BA12E416666660665A65941000000008BA12E410000000063A65941333333339FA02E410000008091A65941CDCCCCCC44A02E41CDCCCC8C98A659419A999999B99F2E41CDCCCCACA7A6594166666666A29F2E41CDCCCC8CB2A6594133333333599F2E41CDCCCCECB8A6594133333333E39E2E419A999979BFA65941CDCCCCCC5D9E2E4133333373C8A6594100000000F09D2E4133333393C9A659419A999999C09D2E419A999919D2A659419A999999939D2E41000000E0E5A659419A999999639D2E41CDCCCC6CF7A659419A999999709D2E419A999959FBA659419A9999999A9D2E410000002011A75941000000006E9D2E416666662621A75941CDCCCCCC5E9D2E41CDCCCCCC30A7594166666666619D2E41000000403CA759419A999999729D2E419A9999794EA7594166666666659D2E41333333B36DA759419A999999379D2E419A9999B97DA7594166666666EF9C2E41333333537EA75941CDCCCCCCE09C2E419A9999B984A75941CDCCCCCC959C2E41333333938EA7594166666666639C2E41666666868BA759419A999999219C2E41333333D38FA759419A999999F79B2E41000000E08DA75941CDCCCCCCF19B2E410000006092A7594100000000D09B2E41CDCCCCAC93A75941CDCCCCCCB59B2E41CDCCCC2C91A7594100000000A69B2E41CDCCCC6C94A759419A9999997D9B2E419A99995994A75941CDCCCCCC0C9B2E41333333B3A0A75941CDCCCCCCEA9A2E4133333353A5A75941666666666C9A2E4166666606B1A759419A999999269A2E41CDCCCCCCB8A75941CDCCCCCCEE992E419A999939C5A759419A999999CF992E4100000020D5A7594166666666E8992E4133333353DFA7594100000000339A2E41CDCCCC4CF0A759419A9999993B9A2E4133333353F8A75941333333331D9A2E41CDCCCC0C09A8594166666666E1992E41333333730CA8594100000000B0992E416666660611A85941CDCCCCCCD7982E41CDCCCC2C1EA8594100000000B0982E416666662622A859410000000083982E41CDCCCC2C22A859413333333373972E41000000801EA8594133333333AC962E419A9999391CA85941CDCCCCCC3F962E410000006019A859419A99999938962E41000000E01FA859419A99999938962E41000000E01FA85941	01010000206A0800001685DDD8ECAE2E4166666626CCA55941	900460000	Z	Florimont	9004600	90046	90	27	18
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	01010000206A0800004435F73E8F832E419A9999B937B25941	900470000	Z	Fontaine	9004700	90047	90	27	7
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	01010000206A0800004346E2B88F6D2E41666666F623AE5941	900480000	Z	Fontenelle	9004800	90048	90	27	2
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	01010000206A080000ECE4B3A5BE852E41666666E64CB05941	900490000	Z	Foussemagne	9004900	90049	90	27	5
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