SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep93;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep93 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep93','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep93','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep93','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep93"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
01060000206A080000010000000103000000010000003500000033333333280424410000004034335A419A9999993B042441000000A03D335A41000000004C042441CDCCCC8C47335A41CDCCCCCC4E0424416666664649335A419A99999950042441CDCCCC4C4A335A41CDCCCCCC5B0424416666662652335A419A999999770424410000002061335A41CDCCCCCC830424419A99999967335A41CDCCCCCC96042441333333F367335A4133333333A40424416666664668335A41CDCCCCCCCB0424410000004069335A4100000000E00424410000006069335A419A9999991E0524410000006069335A4100000000330524419A9999196A335A41CDCCCCCC46052441000000206A335A41CDCCCCCC89052441666666C669335A4166666666990524410000000081335A4166666666A3052441333333738E335A416666666659052441000000A091335A41000000004B052441CDCCCC4C92335A4166666666300524416666664693335A41CDCCCCCCD5052441CDCCCCCCB9335A41333333330E0624419A999959B6335A41000000001006244100000040B6335A419A9999993B06244100000080B3335A4100000000730624419A9999D9AF335A41CDCCCCCCB5062441CDCCCC6CAB335A4100000000BB0624419A999939AB335A4100000000BF06244133333313AB335A41CDCCCCCCC3062441CDCCCC2CAB335A419A999999C7062441000000E0AA335A4133333333360724419A9999D9BF335A419A999999470724419A999979BE335A416666666689072441CDCCCC2CBA335A41CDCCCCCC810824419A999919A9335A41CDCCCCCC53082441CDCCCC2CA1335A4133333333CB0724416666668689335A419A999999B8072441333333D386335A4100000000B40724410000002086335A416666666681072441000000E07E335A419A9999993E0724410000006073335A419A99999920072441CDCCCC2C6E335A4100000000050724410000002069335A419A999999F3062441CDCCCCEC65335A4100000000F00624416666662665335A41CDCCCCCCC70624419A9999995C335A410000000028062441333333F340335A4100000000090624419A9999993B335A41666666667C0524413333333323335A410000000068052441CDCCCCAC1F335A419A99999961052441333333931E335A4133333333F30424413333333327335A4133333333280424410000004034335A41	01060000206A080000010000000103000000010000001400000033333333280424410000004034335A41CDCCCCCC830424419A99999967335A41CDCCCCCCCB0424410000004069335A4100000000330524419A9999196A335A41CDCCCCCC89052441666666C669335A4166666666A3052441333333738E335A4166666666300524416666664693335A41CDCCCCCCD5052441CDCCCCCCB9335A41CDCCCCCCB5062441CDCCCC6CAB335A419A999999C7062441000000E0AA335A4133333333360724419A9999D9BF335A41CDCCCCCC810824419A999919A9335A4133333333CB0724416666668689335A416666666681072441000000E07E335A419A999999F3062441CDCCCCEC65335A41CDCCCCCCC70624419A9999995C335A419A99999961052441333333931E335A4133333333F30424413333333327335A4133333333280424410000004034335A4133333333280424410000004034335A41	01010000206A08000050C3080D5F062441666666C670335A41	930010302	H	Émile Dubois	9300103	93001	93	11	0
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	01060000206A0800000100000001030000000100000017000000CDCCCCCCBBF923419A9999F942335A41000000006FFA23413333337383335A419A99999984FA23419A9999D991335A41CDCCCCCCB1FA23419A9999F9AA335A4133333333E8FA2341CDCCCC0CA5335A413333333320FB2341333333D3A0335A41CDCCCCCC52FB23419A9999599F335A410000000055FC2341CDCCCCEC9A335A41CDCCCCCCEBFC23413333331394335A419A99999946FD23410000006089335A419A99999909FD23419A9999397B335A41CDCCCCCCDFFC2341CDCCCCEC60335A4166666666B1FC2341CDCCCC0C41335A4133333333A1FC23416666666617335A413333333397FC2341CDCCCCCC15335A4100000000BAFC2341CDCCCCEC0D335A41CDCCCCCC9DFC2341CDCCCCEC09335A41CDCCCCCC5CFC2341333333330B335A416666666634FB2341333333B313335A416666666601FA2341666666461D335A419A9999995FFA2341000000003C335A41CDCCCCCCBBF923419A9999F942335A41CDCCCCCCBBF923419A9999F942335A41	01010000206A080000C95870436AFB2341000000005B335A41	930010903	H	Mairie	9300109	93001	93	11	0
01060000206A08000001000000010300000001000000260000009A999999B6FA2341CDCCCC8CC6325A419A999999CDFA234166666606D4325A4100000000D3FA23419A999939D7325A4100000000E2FA23419A999919E0325A4100000000EEFA23419A9999D9E6325A4133333333EFFA2341CDCCCC8CE7325A41666666660DFB23419A999959F9325A41CDCCCCCC16FB2341666666E6FE325A419A9999991DFB2341000000C003335A413333333320FB23410000008005335A416666666634FB2341333333B313335A4133333333B4FB23416666662610335A4166666666C3FB23419A9999B90F335A41666666660FFC23419A9999790D335A416666666627FC2341666666C60C335A41CDCCCCCC37FC2341666666460C335A41CDCCCCCC5CFC2341333333330B335A416666666676FC2341000000A00A335A41CDCCCCCC9DFC2341CDCCCCEC09335A419A9999999FFC2341CDCCCC0C0B335A4133333333A5FC23419A9999F90B335A4100000000BAFC2341CDCCCCEC0D335A4133333333CDFC23419A9999F909335A41333333332BFD2341CDCCCCACF7325A41666666666FFD2341666666A6E9325A410000000086FD23419A999939E5325A41CDCCCCCCB7FD234100000080DB325A410000000034FE2341CDCCCC4CC3325A41333333333CFE234133333353C1325A413333333345FE2341CDCCCC4CBF325A41CDCCCCCC39FE23419A999959BA325A410000000013FE2341333333F3A1325A4133333333F0FD23419A999919A3325A416666666661FC2341666666A6B4325A410000000075FB23419A9999D9BE325A41CDCCCCCC00FB2341000000C0C3325A41CDCCCCCCF5FA23419A999939C4325A419A999999B6FA2341CDCCCC8CC6325A41	01060000206A080000010000000103000000010000000F0000009A999999B6FA2341CDCCCC8CC6325A41CDCCCCCC16FB2341666666E6FE325A416666666634FB2341333333B313335A41CDCCCCCC5CFC2341333333330B335A41CDCCCCCC9DFC2341CDCCCCEC09335A4100000000BAFC2341CDCCCCEC0D335A41666666666FFD2341666666A6E9325A410000000034FE2341CDCCCC4CC3325A413333333345FE2341CDCCCC4CBF325A410000000013FE2341333333F3A1325A4133333333F0FD23419A999919A3325A416666666661FC2341666666A6B4325A41CDCCCCCCF5FA23419A999939C4325A419A999999B6FA2341CDCCCC8CC6325A419A999999B6FA2341CDCCCC8CC6325A41	01010000206A080000A84400B14CFC2341CDCCCC5CD9325A41	930011001	A	Lenine	9300110	93001	93	11	0
01060000206A08000001000000010300000001000000190000009A999999AFF823419A999919D0325A4166666666CCF82341CDCCCC0CDB325A410000000088F923419A9999D9FF325A4166666666D0F92341000000A00D335A41CDCCCCCCDAF923419A99995911335A4100000000E0F923410000004013335A4166666666E9F92341CDCCCCAC16335A416666666601FA2341666666461D335A41CDCCCCCC21FA2341000000401C335A41333333333CFA2341CDCCCC6C1B335A41CDCCCCCC6DFA2341000000E019335A419A999999D5FA2341666666A616335A419A9999990DFB2341CDCCCCEC14335A416666666634FB2341333333B313335A413333333320FB23410000008005335A419A9999991DFB2341000000C003335A41CDCCCCCC16FB2341666666E6FE325A41666666660DFB23419A999959F9325A4133333333EFFA2341CDCCCC8CE7325A4100000000EEFA23419A9999D9E6325A4100000000E2FA23419A999919E0325A4100000000D3FA23419A999939D7325A419A999999CDFA234166666606D4325A419A999999B6FA2341CDCCCC8CC6325A419A999999AFF823419A999919D0325A41	01060000206A08000001000000010300000001000000090000009A999999AFF823419A999919D0325A4166666666CCF82341CDCCCC0CDB325A4166666666D0F92341000000A00D335A416666666601FA2341666666461D335A416666666634FB2341333333B313335A41CDCCCCCC16FB2341666666E6FE325A419A999999B6FA2341CDCCCC8CC6325A419A999999AFF823419A999919D0325A419A999999AFF823419A999919D0325A41	01010000206A08000018B290E51BFA234134333373F0325A41	930011002	H	Firmin Gemier	9300110	93001	93	11	0
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	01060000206A0800000100000001030000000100000029000000000000007AFD23419A999939FD335A4100000000CEFD2341000000E000345A41CDCCCCCCC6FD23419A9999F905345A419A9999996BFE23413333333305345A4100000000A9FE2341333333930A345A4133333333E5FE2341000000E00D345A41CDCCCCCC1EFF23419A9999190E345A419A99999966FF23416666660611345A4166666666AAFF23410000000021345A4166666666A5FF23416666662625345A4133333333D3FF23410000006031345A4100000000FAFF2341666666C638345A4133333333160024419A9999F93A345A41666666662E002441666666A645345A41CDCCCCCC7F0024410000006052345A4166666666DD0024413333337359345A416666666601012441333333B357345A41CDCCCCCC590124419A9999F94C345A41CDCCCCCCAD0124410000006045345A410000000012022441333333F340345A41666666664F022441000000C041345A41000000008F0224410000008045345A4133333333980224419A99995949345A419A999999F8022441CDCCCC2C4A345A41CDCCCCCC7C032441CDCCCC6C47345A410000000033042441666666A652345A4133333333400424416666666649345A410000000025042441CDCCCC4C3D345A4166666666B70324419A9999F914345A419A999999750324419A999919FB335A41CDCCCCCCAA012441666666E610345A4100000000AC012441CDCCCC8C0C345A416666666687012441000000A0ED335A410000000077012441000000E0E2335A41000000005F012441CDCCCC2CE6335A419A9999990701244166666646E9335A41CDCCCCCC48FF234100000000F6335A419A99999919FF23419A9999D9F5335A4133333333D8FD23419A9999D9F9335A41000000007AFD23419A999939FD335A41000000007AFD23419A999939FD335A41	01010000206A080000FAC00F5CB0012441666666F61B345A41	930010101	H	Robespierre	9300101	93001	93	11	0
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	01060000206A080000010000000103000000010000001D0000000000000077012441000000E0E2335A416666666687012441000000A0ED335A4100000000AC012441CDCCCC8C0C345A41CDCCCCCCAA012441666666E610345A419A999999750324419A999919FB335A4166666666B70324419A9999F914345A410000000025042441CDCCCC4C3D345A4133333333400424416666666649345A410000000033042441666666A652345A41CDCCCCCC6B042441CDCCCC0C55345A4133333333ED0424416666660652345A410000000053052441666666A64E345A419A99999995052441CDCCCC2C4A345A419A999999B40524419A9999D949345A4133333333400624416666664640345A419A9999998D062441CDCCCC4C31345A419A99999990062441333333332E345A4166666666720624419A99991901345A419A9999994806244100000040E8335A41000000009806244166666686E7335A41CDCCCCCC700624419A999999DE335A410000000029062441CDCCCCACDE335A4166666666A005244133333353E2335A41CDCCCCCC7C052441CDCCCC8CDF335A41000000005D05244100000000E0335A4166666666130324419A999979E2335A41CDCCCCCC9A0124419A999979E4335A410000000077012441000000E0E2335A410000000077012441000000E0E2335A41	01010000206A080000D19B1990220524419A9999D918345A41	930010201	H	Péri	9300102	93001	93	11	0
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	01060000206A0800000100000001030000000100000021000000CDCCCCCCA80124419A999979E4335A4166666666130324419A999979E2335A41000000005D05244100000000E0335A41CDCCCCCC7C052441CDCCCC8CDF335A4166666666A005244133333353E2335A410000000029062441CDCCCCACDE335A41CDCCCCCC700624419A999999DE335A41000000009806244166666686E7335A419A9999994806244100000040E8335A4166666666720624419A99991901345A419A99999990062441333333332E345A4133333333AF062441666666262E345A4166666666BC062441666666E620345A4133333333190724419A99995914345A4100000000720724419A9999790C345A4166666666590724410000006006345A4100000000720724413333337301345A4133333333E907244166666626F7335A41000000003F08244166666666F1335A419A999999A7082441333333B3EC335A41000000002309244100000040EB335A419A9999996B0924419A9999D9DF335A4100000000A0092441666666A6DA335A41CDCCCCCC810824419A999919A9335A4133333333360724419A9999D9BF335A419A999999C7062441000000E0AA335A41CDCCCCCCB5062441CDCCCC6CAB335A41CDCCCCCCD5052441CDCCCCCCB9335A4166666666300524416666664693335A41666666669B0424419A9999199D335A41CDCCCCCCC001244166666666DD335A41CDCCCCCCA80124419A999979E4335A41CDCCCCCCA80124419A999979E4335A41	01010000206A0800003EC1300DEE072441666666E6E1335A41	930010202	H	Montfort	9300102	93001	93	11	0
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	01060000206A08000001000000010300000001000000110000000000000068052441CDCCCCAC1F335A41CDCCCCCCC70624419A9999995C335A419A999999F3062441CDCCCCEC65335A416666666681072441000000E07E335A419A999999B60724419A9999F985335A41CDCCCCCC5F0824419A99995976335A419A9999997A0924416666666666335A41CDCCCCCC780A2441CDCCCCEC45335A41CDCCCCCCAB0A2441000000E03E335A419A999999A10B2441666666861F335A41CDCCCCCCC20B2441CDCCCCEC1B335A4166666666EC0A24419A9999F9F4325A419A999999ED092441CDCCCC0CC4325A41666666669F082441CDCCCC4CCF325A4100000000DA0624419A9999B9F6325A410000000068052441CDCCCCAC1F335A410000000068052441CDCCCCAC1F335A41	01010000206A0800007FE8DBFE7D0824419A99994926335A41	930010301	H	Gendarmerie	9300103	93001	93	11	0
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	01060000206A080000010000000103000000010000002600000066666666830024413333337375335A4133333333970024419A99997977335A4100000000C90024419A9999D985335A4133333333E2002441666666A68F335A41CDCCCCCCF1002441CDCCCC8C9A335A410000000077012441000000E0E2335A41CDCCCCCCA80124419A999979E4335A41CDCCCCCCC001244166666666DD335A41666666669B0424419A9999199D335A4166666666300524416666664693335A4100000000F1042441CDCCCCEC83335A4133333333D7042441CDCCCC8C88335A419A9999998A042441666666468D335A41333333334E0424416666664689335A413333333326042441CDCCCC8C83335A4166666666EE032441666666C684335A419A9999999C0324416666666681335A41CDCCCCCC7D032441CDCCCC6C88335A419A999999420324419A9999F98E335A4100000000F70224419A9999F98E335A41CDCCCCCCAB0224413333333379335A41CDCCCCCC960224416666666676335A4166666666D8022441666666A673335A4133333333200324419A9999196F335A416666666645032441CDCCCCCC6F335A4166666666D4032441666666A667335A4133333333E2032441CDCCCCEC63335A41CDCCCCCC90032441333333F360335A41000000002D032441666666A65A335A41666666662F0324410000008059335A41000000004C042441CDCCCC8C47335A4133333333280424410000004034335A4166666666A50224419A9999B94C335A4133333333110224419A9999B954335A413333333353012441CDCCCCAC5F335A419A999999B1002441CDCCCCCC6C335A4166666666830024413333337375335A4166666666830024413333337375335A41	01010000206A0800008CEC0B39E5012441666666C68C335A41	930010303	H	Long Sentier	9300103	93001	93	11	0
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	01060000206A080000010000000103000000010000001D000000CDCCCCCC960224416666666676335A41CDCCCCCCAB0224413333333379335A4100000000F70224419A9999F98E335A419A999999420324419A9999F98E335A41CDCCCCCC7D032441CDCCCC6C88335A419A9999999C0324416666666681335A4166666666EE032441666666C684335A413333333326042441CDCCCC8C83335A41333333334E0424416666664689335A419A9999998A042441666666468D335A4133333333D7042441CDCCCC8C88335A4100000000F1042441CDCCCCEC83335A4166666666300524416666664693335A4166666666A3052441333333738E335A41CDCCCCCC89052441666666C669335A4100000000330524419A9999196A335A41CDCCCCCCCB0424410000004069335A41CDCCCCCC830424419A99999967335A41000000004C042441CDCCCC8C47335A41666666662F0324410000008059335A41000000002D032441666666A65A335A41CDCCCCCC90032441333333F360335A4133333333E2032441CDCCCCEC63335A4166666666D4032441666666A667335A416666666645032441CDCCCCCC6F335A4133333333200324419A9999196F335A4166666666D8022441666666A673335A41CDCCCCCC960224416666666676335A41CDCCCCCC960224416666666676335A41	01010000206A08000084CB43267C0424419A9999996D335A41	930010304	H	Maladrerie	9300103	93001	93	11	0
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	01060000206A0800000100000001030000000100000013000000CDCCCCCC23FF234133333333C2335A41CDCCCCCC31FF23419A9999B9C6335A416666666658FF234166666686DE335A413333333364FF234166666606E1335A41CDCCCCCC74FF234166666606EE335A413333333393FF234133333373EE335A410000000097FF2341333333F3F3335A419A9999990701244166666646E9335A41000000005F012441CDCCCC2CE6335A410000000077012441000000E0E2335A41CDCCCCCCF1002441CDCCCC8C9A335A4133333333E2002441666666A68F335A4100000000C90024419A9999D985335A416666666697002441CDCCCC2C7B335A41CDCCCCCC75002441666666E67D335A41CDCCCCCC13002441333333337B335A41CDCCCCCC40FF234166666686BA335A41CDCCCCCC23FF234133333333C2335A41CDCCCCCC23FF234133333333C2335A41	01010000206A080000AB48BCBA3A00244133333323B5335A41	930010401	H	La Frette	9300104	93001	93	11	0
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	01060000206A08000001000000010300000001000000150000009A99999946FD23410000006089335A41CDCCCCCCA3FD2341333333D3C9335A41CDCCCCCCD4FD234166666686EE335A4133333333D8FD23419A9999D9F9335A419A99999919FF23419A9999D9F5335A41CDCCCCCC48FF234100000000F6335A410000000097FF2341333333F3F3335A413333333393FF234133333373EE335A41CDCCCCCC74FF234166666606EE335A413333333364FF234166666606E1335A416666666658FF234166666686DE335A41CDCCCCCC31FF23419A9999B9C6335A41CDCCCCCC23FF234133333333C2335A41CDCCCCCC40FF234166666686BA335A41CDCCCCCC13002441333333337B335A4100000000DDFE23410000002078335A4100000000B2FE23419A99991978335A4133333333C3FD2341000000A083335A419A9999995FFD23419A9999B985335A419A99999946FD23410000006089335A419A99999946FD23410000006089335A41	01010000206A080000DB69B7276BFE234166666676B6335A41	930010402	H	Valles	9300104	93001	93	11	0
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	01060000206A08000001000000010300000001000000130000006666666635002441333333B339335A419A9999993A002441666666065D335A419A9999994C0024419A9999B96F335A4100000000690024419A9999F975335A41CDCCCCCC67002441666666A67C335A41CDCCCCCC8D0024419A9999997C335A4133333333970024419A99997977335A4166666666830024413333337375335A419A999999B1002441CDCCCCCC6C335A413333333353012441CDCCCCAC5F335A4133333333110224419A9999B954335A4166666666A50224419A9999B94C335A4133333333280424410000004034335A4133333333B00324419A9999F917335A4100000000590324410000004005335A416666666660022441666666E618335A4166666666430224419A99991923335A416666666635002441333333B339335A416666666635002441333333B339335A41	01010000206A0800003C2AE887CD0124419A99998940335A41	930010501	H	Mélèzes	9300105	93001	93	11	0
01060000206A08000001000000010300000001000000240000009A999999C4FF23419A999939DB325A4166666666D0FF234100000000E1325A4133333333DAFF234133333393E6325A4133333333F5FF234166666606F6325A413333333308002441000000E000335A419A9999990D002441333333F303335A413333333321002441000000800F335A419A9999992C0024410000000016335A4100000000300024419A9999F917335A410000000033002441666666E624335A410000000035002441CDCCCCCC2D335A416666666635002441333333B339335A4166666666430224419A99991923335A416666666660022441666666E618335A4166666666620224419A9999B918335A4100000000590324410000004005335A410000000069032441CDCCCCAC08335A4133333333B00324419A9999F917335A4100000000CB032441666666461E335A4100000000D2032441000000E01F335A419A999999D30324410000004020335A4133333333280424410000004034335A4133333333F30424413333333327335A419A99999961052441333333931E335A41CDCCCCCC430524419A99995919335A41CDCCCCCCEB042441666666060A335A41666666668004244166666646F7325A410000000030042441666666E6E8325A41000000000F042441CDCCCC0CE3325A41666666660904244166666606E2325A41CDCCCCCCCE03244133333333D8325A410000000096032441000000A0CE325A419A999999100324419A999939B8325A41CDCCCCCC0F022441333333B3C4325A4166666666190124419A999979D0325A419A999999C4FF23419A999939DB325A41	01060000206A08000001000000010300000001000000100000009A999999C4FF23419A999939DB325A4100000000300024419A9999F917335A416666666635002441333333B339335A4166666666430224419A99991923335A416666666660022441666666E618335A4100000000590324410000004005335A4133333333B00324419A9999F917335A4133333333280424410000004034335A4133333333F30424413333333327335A419A99999961052441333333931E335A41666666668004244166666646F7325A41666666660904244166666606E2325A419A999999100324419A999939B8325A4166666666190124419A999979D0325A419A999999C4FF23419A999939DB325A419A999999C4FF23419A999939DB325A41	01010000206A080000C8E42CD84D02244133333313FC325A41	930010502	H	Presles	9300105	93001	93	11	0
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	01060000206A080000010000000103000000010000001B0000003333333397FC2341CDCCCCCC15335A4133333333A1FC23416666666617335A4166666666B1FC2341CDCCCC0C41335A41CDCCCCCCDFFC2341CDCCCCEC60335A419A99999909FD23419A9999397B335A419A99999946FD23410000006089335A419A9999995FFD23419A9999B985335A4133333333C3FD2341000000A083335A4100000000B2FE23419A99991978335A4100000000DDFE23410000002078335A41CDCCCCCC38002441666666A67B335A41CDCCCCCC75002441666666E67D335A41CDCCCCCC5D0024419A9999397B335A4100000000690024419A9999F975335A419A9999994C0024419A9999B96F335A419A9999993A002441666666065D335A410000000035002441CDCCCCCC2D335A4100000000300024419A9999F917335A419A999999C4FF23419A999939DB325A419A99999917FF23419A999979E2325A41CDCCCCCC50FE23419A9999D9E9325A41CDCCCCCC5BFE23419A999939DD325A41CDCCCCCC55FE234133333333D3325A41333333333CFE234133333353C1325A4133333333CDFC23419A9999F909335A413333333397FC2341CDCCCCCC15335A413333333397FC2341CDCCCCCC15335A41	01010000206A0800009CCF12A36DFE2341000000E028335A41	930010503	H	Paul Bert	9300105	93001	93	11	0
01060000206A080000010000000103000000010000001E0000000000000013FE2341333333F3A1325A41CDCCCCCC39FE23419A999959BA325A413333333345FE2341CDCCCC4CBF325A41333333333CFE234133333353C1325A413333333350FE234100000040CF325A41CDCCCCCC55FE234133333333D3325A410000000056FE234133333393D3325A419A99999959FE2341CDCCCC0CD7325A41CDCCCCCC5BFE23419A999939DD325A41000000005BFE2341000000A0E0325A41CDCCCCCC57FE2341CDCCCCACE4325A41CDCCCCCC50FE23419A9999D9E9325A419A99999917FF23419A999979E2325A410000000077FF23419A999979DE325A419A999999C4FF23419A999939DB325A4166666666190124419A999979D0325A41CDCCCCCC0F022441333333B3C4325A41CDCCCCCC7101244133333353A8325A41333333335401244166666606A3325A419A999999CF002441CDCCCC6C8A325A4166666666C3002441666666068B325A419A9999999E002441333333F38C325A416666666693002441000000808D325A41CDCCCCCC5BFF2341CDCCCC6C9D325A41000000004EFF2341000000E094325A41CDCCCCCC45FF23410000004091325A41666666663CFF2341CDCCCC0C8D325A419A999999F7FE2341666666669B325A41CDCCCCCCDAFE2341666666269B325A410000000013FE2341333333F3A1325A41	01060000206A08000001000000010300000001000000120000000000000013FE2341333333F3A1325A41CDCCCCCC39FE23419A999959BA325A41333333333CFE234133333353C1325A41CDCCCCCC55FE234133333333D3325A41CDCCCCCC5BFE23419A999939DD325A41CDCCCCCC50FE23419A9999D9E9325A419A99999917FF23419A999979E2325A419A999999C4FF23419A999939DB325A4166666666190124419A999979D0325A41CDCCCCCC0F022441333333B3C4325A41333333335401244166666606A3325A419A999999CF002441CDCCCC6C8A325A41CDCCCCCC5BFF2341CDCCCC6C9D325A41666666663CFF2341CDCCCC0C8D325A419A999999F7FE2341666666669B325A41CDCCCCCCDAFE2341666666269B325A410000000013FE2341333333F3A1325A410000000013FE2341333333F3A1325A41	01010000206A08000050F9F4B9E7FF234166666656B1325A41	930010601	H	Fusains	9300106	93001	93	11	0
01060000206A08000001000000010300000001000000320000003333333314FF23413333335341325A41000000003AFF2341000000E048325A41CDCCCCCC51FF2341666666A64E325A419A9999996FFF2341000000E05F325A419A9999998FFF23410000000072325A41CDCCCCCCB6FF23413333339375325A41333333339EFF2341333333737A325A41CDCCCCCC82FF2341CDCCCCAC7F325A416666666680FF23416666662680325A41666666663CFF2341CDCCCC0C8D325A41CDCCCCCC45FF23410000004091325A41000000004EFF2341000000E094325A41CDCCCCCC5BFF2341CDCCCC6C9D325A416666666693002441000000808D325A419A9999999E002441333333F38C325A4166666666C3002441666666068B325A419A999999CF002441CDCCCC6C8A325A41333333335401244166666606A3325A41CDCCCCCC7101244133333353A8325A41CDCCCCCC0F022441333333B3C4325A419A999999100324419A999939B8325A41333333330E032441333333D3B7325A4133333333CB022441CDCCCC0CAC325A419A99999903022441666666E688325A419A999999CE0124413333333380325A4166666666B8012441333333937C325A4100000000A60124416666666679325A41CDCCCCCC8E0124416666666675325A4166666666850124419A9999D973325A4100000000770124416666668671325A41666666665D0124419A9999596D325A41000000005A012441666666C66C325A419A999999370124419A99991967325A4100000000FC002441666666E65C325A4133333333CC0024419A99999954325A4100000000B3002441CDCCCC4C50325A41CDCCCCCCAE0024419A9999994F325A41CDCCCCCC91002441333333934A325A410000000090002441666666464A325A413333333378002441CDCCCC2C46325A41CDCCCCCC75002441000000C045325A41CDCCCCCC560024413333337340325A41CDCCCCCC29002441333333B338325A41CDCCCCCC01002441CDCCCCCC31325A419A999999CFFF23413333331329325A4100000000CEFF2341000000402C325A419A999999BCFF2341333333132F325A419A999999B8FF2341000000C02F325A416666666655FF2341333333533A325A413333333314FF23413333335341325A41	01060000206A08000001000000010300000001000000100000003333333314FF23413333335341325A41CDCCCCCC51FF2341666666A64E325A419A9999998FFF23410000000072325A41CDCCCCCCB6FF23413333339375325A41666666663CFF2341CDCCCC0C8D325A41CDCCCCCC5BFF2341CDCCCC6C9D325A419A999999CF002441CDCCCC6C8A325A41333333335401244166666606A3325A41CDCCCCCC0F022441333333B3C4325A419A999999100324419A999939B8325A419A99999903022441666666E688325A419A999999370124419A99991967325A419A999999CFFF23413333331329325A419A999999B8FF2341000000C02F325A413333333314FF23413333335341325A413333333314FF23413333335341325A41	01010000206A08000030F44207A4002441CCCCCC7C77325A41	930010602	H	Quatre Chemins	9300106	93001	93	11	0
01060000206A080000010000000103000000010000002D0000003333333360FD2341CDCCCCAC47325A41CDCCCCCC7DFD23419A9999D94F325A41666666668EFD2341000000A056325A41333333339DFD2341666666665D325A41CDCCCCCCA0FD2341000000805F325A4133333333B0FD2341000000C068325A4166666666B1FD23410000008069325A419A999999B7FD23419A9999396D325A4133333333CBFD2341CDCCCC4C7B325A4166666666DBFD23413333333385325A41CDCCCCCCE9FD2341CDCCCC0C8D325A419A999999F8FD23413333337394325A4133333333FBFD2341000000C095325A410000000013FE2341333333F3A1325A41CDCCCCCCDAFE2341666666269B325A419A999999F7FE2341666666669B325A41666666663CFF2341CDCCCC0C8D325A416666666680FF23416666662680325A41CDCCCCCC82FF2341CDCCCCAC7F325A41333333339EFF2341333333737A325A41CDCCCCCCB6FF23413333339375325A419A9999998FFF23410000000072325A419A9999996FFF2341000000E05F325A41CDCCCCCC51FF2341666666A64E325A41000000003AFF2341000000E048325A413333333314FF23413333335341325A416666666655FF2341333333533A325A419A999999B8FF2341000000C02F325A419A999999BCFF2341333333132F325A4100000000CEFF2341000000402C325A419A999999CFFF23413333331329325A4166666666A6FF2341CDCCCCEC21325A419A99999987FF2341333333931C325A41666666666AFF23419A99999917325A41CDCCCCCC40FF2341333333131C325A41333333332EFF23419A9999791E325A41CDCCCCCC12FF23416666664621325A41CDCCCCCCBFFE23419A99997928325A41000000009FFE2341666666862B325A41CDCCCCCC93FE23419A9999192C325A41CDCCCCCCA9FE2341666666463A325A41000000003FFE2341CDCCCCAC3E325A4166666666EFFD2341333333F341325A4133333333A8FD2341CDCCCCEC44325A413333333360FD2341CDCCCCAC47325A41	01060000206A08000001000000010300000001000000140000003333333360FD2341CDCCCCAC47325A41CDCCCCCC7DFD23419A9999D94F325A41333333339DFD2341666666665D325A4133333333CBFD2341CDCCCC4C7B325A410000000013FE2341333333F3A1325A41CDCCCCCCDAFE2341666666269B325A419A999999F7FE2341666666669B325A41666666663CFF2341CDCCCC0C8D325A41CDCCCCCCB6FF23413333339375325A419A9999998FFF23410000000072325A41CDCCCCCC51FF2341666666A64E325A413333333314FF23413333335341325A419A999999B8FF2341000000C02F325A419A999999CFFF23413333331329325A41666666666AFF23419A99999917325A41CDCCCCCC12FF23416666664621325A41CDCCCCCC93FE23419A9999192C325A41CDCCCCCCA9FE2341666666463A325A413333333360FD2341CDCCCCAC47325A413333333360FD2341CDCCCCAC47325A41	01010000206A08000000AFF9A07DFE2341333333035A325A41	930010603	H	Condorcet	9300106	93001	93	11	0
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	01060000206A08000001000000010300000001000000200000009A99999921F82341666666C6B0325A413333333327F823419A999959B4325A413333333395F82341000000A0CB325A419A999999AFF823419A999919D0325A419A999999B6FA2341CDCCCC8CC6325A41CDCCCCCCF5FA23419A999939C4325A416666666661FC2341666666A6B4325A4133333333F0FD23419A999919A3325A410000000013FE2341333333F3A1325A4133333333CBFD2341CDCCCC4C7B325A41333333339DFD2341666666665D325A41CDCCCCCC7DFD23419A9999D94F325A413333333360FD2341CDCCCCAC47325A41333333331DFD23419A9999794A325A419A999999CEFB23410000008053325A416666666638FB2341000000A056325A419A999999AEFB23416666668641325A41CDCCCCCC94FB23416666668630325A413333333366FC2341666666A624325A413333333373FC23413333333320325A413333333341FC23419A99993922325A4133333333DCF923419A99995920325A413333333367F923410000002044325A41333333335BF923410000006045325A41333333332AF92341CDCCCC0C55325A41333333332DF92341666666A656325A4133333333EEF82341CDCCCCEC6A325A41CDCCCCCCF0F82341333333B36D325A4133333333D5F82341666666A678325A413333333387F823410000006090325A419A99999921F82341666666C6B0325A419A99999921F82341666666C6B0325A41	01010000206A08000086C25B7151FB2341CCCCCC2C73325A41	930010701	H	Sadi Carnot	9300107	93001	93	11	0
01060000206A080000010000000103000000010000002F0000006666666638FB2341000000A056325A416666666656FB23410000008056325A419A999999CEFB23410000008053325A41CDCCCCCC6CFC2341333333134F325A4133333333B3FC2341000000404D325A41333333331DFD23419A9999794A325A413333333360FD2341CDCCCCAC47325A413333333341FD2341CDCCCCCC3F325A413333333339FD2341000000C03D325A419A9999990DFD23419A9999B931325A4166666666F8FC2341CDCCCCEC27325A419A999999F7FC23419A9999B927325A41CDCCCCCC66FD23419A99993922325A413333333351FD2341333333B318325A41000000007BFD2341333333B316325A410000000090FD2341666666A620325A4133333333A9FD23413333335322325A419A999999BEFD23416666660624325A413333333378FE2341000000801D325A41CDCCCCCC93FE23419A9999192C325A41000000009FFE2341666666862B325A41CDCCCCCCBFFE23419A99997928325A41CDCCCCCC12FF23416666664621325A41333333332EFF23419A9999791E325A41CDCCCCCC40FF2341333333131C325A41666666666AFF23419A99999917325A41CDCCCCCC62FF23416666664616325A41CDCCCCCC2EFF2341666666660D325A41CDCCCCCC1DFF2341000000800A325A413333333312FF23410000004008325A413333333306FF23419A9999B906325A419A999999FFFE23410000002006325A41CDCCCCCCF5FE23416666668606325A41CDCCCCCC57FE2341CDCCCC6C0C325A4100000000DBFC2341CDCCCC0C1C325A41CDCCCCCCC5FC2341666666E61C325A41CDCCCCCC8DFC2341000000201F325A413333333373FC23413333333320325A41CDCCCCCC6AFC2341000000E022325A413333333366FC2341666666A624325A419A9999990AFC23413333337329325A41CDCCCCCC94FB23416666668630325A416666666696FB2341666666A631325A41CDCCCCCC9AFB23416666668634325A419A999999AEFB23416666668641325A419A99999953FB2341000000C051325A416666666638FB2341000000A056325A41	01060000206A08000001000000010300000001000000170000006666666638FB2341000000A056325A419A999999CEFB23410000008053325A41333333331DFD23419A9999794A325A413333333360FD2341CDCCCCAC47325A419A9999990DFD23419A9999B931325A419A999999F7FC23419A9999B927325A41CDCCCCCC66FD23419A99993922325A413333333351FD2341333333B318325A41000000007BFD2341333333B316325A410000000090FD2341666666A620325A419A999999BEFD23416666660624325A413333333378FE2341000000801D325A41CDCCCCCC93FE23419A9999192C325A41CDCCCCCC12FF23416666664621325A41666666666AFF23419A99999917325A419A999999FFFE23410000002006325A41CDCCCCCC57FE2341CDCCCC6C0C325A413333333373FC23413333333320325A413333333366FC2341666666A624325A41CDCCCCCC94FB23416666668630325A419A999999AEFB23416666668641325A416666666638FB2341000000A056325A416666666638FB2341000000A056325A41	01010000206A080000C2A19DED5FFC2341000000502E325A41	930010801	H	Pariferic	9300108	93001	93	11	0
01060000206A08000001000000010300000001000000130000009A999999F7FC23419A9999B927325A4166666666F8FC2341CDCCCCEC27325A419A9999990DFD23419A9999B931325A413333333339FD2341000000C03D325A413333333341FD2341CDCCCCCC3F325A413333333360FD2341CDCCCCAC47325A4133333333A8FD2341CDCCCCEC44325A4166666666EFFD2341333333F341325A41000000003FFE2341CDCCCCAC3E325A41CDCCCCCCA9FE2341666666463A325A41CDCCCCCC93FE23419A9999192C325A413333333378FE2341000000801D325A419A999999BEFD23416666660624325A4133333333A9FD23413333335322325A410000000090FD2341666666A620325A41000000007BFD2341333333B316325A413333333351FD2341333333B318325A41CDCCCCCC66FD23419A99993922325A419A999999F7FC23419A9999B927325A41	01060000206A080000010000000103000000010000000C0000009A999999F7FC23419A9999B927325A419A9999990DFD23419A9999B931325A413333333360FD2341CDCCCCAC47325A41CDCCCCCCA9FE2341666666463A325A413333333378FE2341000000801D325A419A999999BEFD23416666660624325A410000000090FD2341666666A620325A41000000007BFD2341333333B316325A413333333351FD2341333333B318325A41CDCCCCCC66FD23419A99993922325A419A999999F7FC23419A9999B927325A419A999999F7FC23419A9999B927325A41	01010000206A0800000C9727D7CFFD23419A9999E92E325A41	930010802	H	Villette	9300108	93001	93	11	0
01060000206A080000010000000103000000010000002A000000CDCCCCCCB1FA23419A9999F9AA335A41CDCCCCCCB2FA234133333393AB335A4100000000DFFA234133333373C5335A4133333333E9FA2341CDCCCC6CCB335A419A999999EBFA2341CDCCCCCCCC335A4133333333FFFA2341CDCCCC4CD8335A41333333331AFB2341000000A0E8335A419A9999994AFB23419A99999904345A41CDCCCCCC4CFB2341CDCCCC8C04345A4166666666BAFB23410000004002345A41333333331FFC2341666666A600345A41CDCCCCCC35FC23419A99997900345A419A99999975FC23419A9999F9FF335A4100000000F6FC2341000000A0FE335A410000000007FD234133333373FE335A41000000007AFD23419A999939FD335A41CDCCCCCCB9FD23419A9999B9FA335A4133333333D8FD23419A9999D9F9335A4166666666D9FD2341CDCCCCECF6335A41CDCCCCCCD4FD234166666686EE335A41CDCCCCCCA3FD2341333333D3C9335A410000000082FD234166666666B2335A41CDCCCCCC66FD2341CDCCCC6C9F335A41CDCCCCCC64FD2341333333139E335A419A9999994CFD2341000000C08C335A419A99999946FD23410000006089335A419A99999904FD2341CDCCCCCC91335A41CDCCCCCCEBFC23413333331394335A4133333333CCFC23410000000096335A4166666666ABFC2341CDCCCC8C97335A410000000084FC23416666662699335A410000000055FC2341CDCCCCEC9A335A416666666614FC23419A9999799C335A4100000000F5FB2341333333F39C335A4100000000CFFB2341333333339D335A419A999999C8FB2341000000409D335A41CDCCCCCC52FB23419A9999599F335A413333333320FB2341333333D3A0335A41666666660AFB234166666606A2335A4133333333E8FA2341CDCCCC0CA5335A4133333333C9FA234166666666A8335A41CDCCCCCCB1FA23419A9999F9AA335A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCB1FA23419A9999F9AA335A419A9999994AFB23419A99999904345A41333333331FFC2341666666A600345A41000000007AFD23419A999939FD335A4133333333D8FD23419A9999D9F9335A41CDCCCCCCD4FD234166666686EE335A41CDCCCCCCA3FD2341333333D3C9335A419A99999946FD23410000006089335A41CDCCCCCCEBFC23413333331394335A410000000055FC2341CDCCCCEC9A335A41CDCCCCCC52FB23419A9999599F335A413333333320FB2341333333D3A0335A4133333333E8FA2341CDCCCC0CA5335A41CDCCCCCCB1FA23419A9999F9AA335A41CDCCCCCCB1FA23419A9999F9AA335A41	01010000206A080000ACFA60B041FC2341333333A3C7335A41	930010901	H	Centre Ville	9300109	93001	93	11	0
01060000206A080000010000000103000000010000003900000000000000AEF723413333339365335A41CDCCCCCCC0F72341CDCCCC6C6A335A419A999999D7F723419A99995971335A4133333333E4F723410000004076335A4166666666F2F72341CDCCCC0C7E335A4166666666F4F72341666666C67F335A41CDCCCCCCF6F723419A9999398F335A41CDCCCCCCF7F723416666662691335A41CDCCCCCCFEF723413333333393335A41CDCCCCCC08F823419A99991995335A41CDCCCCCC08F8234133333393A8335A416666666609F8234166666626AC335A41333333330DF8234166666606B1335A410000000012F82341CDCCCC2CB5335A410000000017F82341CDCCCCACB7335A410000000049F82341CDCCCCECC9335A413333333352F8234100000000D2335A416666666657F82341666666A6D6335A41000000005FF8234100000080DB335A41CDCCCCCC6CF82341000000A0E3335A41666666667EF823419A9999D9EA335A419A99999992F82341000000C0F1335A419A999999B2F82341CDCCCC2CF6335A4100000000D6F823419A9999D9F7335A416666666672F923410000006005345A41CDCCCCCC9BF923413333337309345A4133333333B9F92341000000000C345A4133333333C9F92341333333330D345A4100000000E1F923419A9999D90B345A41CDCCCCCCFCF92341CDCCCC0C0B345A41CDCCCCCC51FA2341CDCCCC8C09345A41CDCCCCCCCBFA2341666666C606345A419A999999F2FA23419A99991906345A419A9999994AFB23419A99999904345A41333333331AFB2341000000A0E8335A4133333333FFFA2341CDCCCC4CD8335A419A999999EBFA2341CDCCCCCCCC335A4133333333E9FA2341CDCCCC6CCB335A4100000000DFFA234133333373C5335A41CDCCCCCCB2FA234133333393AB335A41CDCCCCCCB1FA23419A9999F9AA335A4166666666AFFA2341666666A6A9335A419A9999999FFA2341666666A6A0335A41333333339DFA2341CDCCCC2C9F335A41CDCCCCCC98FA23419A9999D99C335A41CDCCCCCC96FA2341333333B39B335A419A99999984FA23419A9999D991335A413333333381FA2341333333938F335A41000000006FFA23413333337383335A416666666633FA2341666666466E335A410000000013FA2341666666A662335A41333333335CF92341666666A668335A41CDCCCCCC41F92341CDCCCC8C69335A419A999999EEF82341CDCCCC4C6C335A4100000000DDF823419A9999D96C335A419A999999C3F82341000000A05F335A4100000000AEF723413333339365335A41	01060000206A080000010000000103000000010000001700000000000000AEF723413333339365335A419A999999D7F723419A99995971335A4166666666F4F72341666666C67F335A41CDCCCCCCF7F723416666662691335A41CDCCCCCC08F823419A99991995335A416666666609F8234166666626AC335A410000000017F82341CDCCCCACB7335A410000000049F82341CDCCCCECC9335A41CDCCCCCC6CF82341000000A0E3335A419A99999992F82341000000C0F1335A419A999999B2F82341CDCCCC2CF6335A4100000000D6F823419A9999D9F7335A4133333333C9F92341333333330D345A41CDCCCCCCFCF92341CDCCCC0C0B345A419A9999994AFB23419A99999904345A41CDCCCCCCB2FA234133333393AB335A419A99999984FA23419A9999D991335A41000000006FFA23413333337383335A410000000013FA2341666666A662335A4100000000DDF823419A9999D96C335A419A999999C3F82341000000A05F335A4100000000AEF723413333339365335A4100000000AEF723413333339365335A41	01010000206A0800009EFEC3EA6CF92341CDCCCC6CB6335A41	930010902	H	Roosevelt	9300109	93001	93	11	0
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	01060000206A08000001000000010300000001000000280000009A9999992DF223419A9999B977345A41333333331DF323410000000091345A41666666664FF32341000000E088345A4166666666C1F32341CDCCCCCC78345A410000000024F42341666666866E345A4133333333C9F423419A9999B960345A413333333337F52341CDCCCC8C58345A41CDCCCCCC89F52341666666A668345A4133333333D3F52341CDCCCCEC6F345A41CDCCCCCC15F62341CDCCCCEC74345A41000000005EF62341CDCCCCAC78345A4166666666CDF623419A9999D97C345A413333333351F72341000000006E345A41666666669BF72341000000E066345A4166666666ACF72341666666E662345A4166666666FBF72341CDCCCC4C5A345A4100000000E4F82341333333F346345A410000000019F92341666666663F345A416666666668F92341CDCCCC2C25345A419A999999ABF92341666666A617345A4133333333C9F92341333333330D345A4100000000D6F823419A9999D9F7335A419A999999B2F82341CDCCCC2CF6335A419A99999992F82341000000C0F1335A41CDCCCCCC6CF82341000000A0E3335A41000000005FF8234100000080DB335A419A999999D7F72341333333F3DA335A4133333333C7F623419A999919D5335A4166666666D0F6234100000000D0335A41CDCCCCCCB4F423419A999919C5335A4100000000A3F4234100000040C3335A419A9999998AF42341666666A6CD335A410000000052F423419A9999F9DF335A4133333333B8F32341666666C60F345A41CDCCCCCC7AF323419A99999918345A416666666650F32341CDCCCC6C24345A41CDCCCCCC51F32341CDCCCCEC26345A419A999999B4F22341666666A64E345A419A9999992DF223419A9999B977345A419A9999992DF223419A9999B977345A41	01010000206A080000E0E1EE0E3FF62341666666962E345A41	930011101	H	Pressense	9300111	93001	93	11	0
01060000206A080000010000000103000000010000008000000033333333DBF12341666666263E345A41CDCCCCCC04F223413333333341345A410000000007F223419A99995941345A419A99999914F223410000006042345A41666666661DF223416666660643345A41333333332BF223416666660644345A419A99999936F22341666666E644345A410000000044F22341000000E045345A416666666658F223419A99999947345A41CDCCCCCC6BF223419A99991949345A410000000097F22341666666664C345A419A999999B4F22341666666A64E345A4133333333B6F22341333333734E345A4100000000BAF22341333333534D345A4166666666F1F22341CDCCCC4C3F345A419A999999FCF22341333333133C345A41CDCCCCCC51F32341CDCCCCEC26345A416666666650F32341CDCCCC6C24345A41CDCCCCCC7AF323419A99999918345A41CDCCCCCC86F32341333333F316345A41333333339EF323416666660613345A419A999999ABF32341666666E610345A4133333333B4F323410000004010345A4133333333B8F32341666666C60F345A410000000052F423419A9999F9DF335A410000000055F423419A999939DF335A41CDCCCCCC7FF4234166666646D1335A41CDCCCCCC82F4234100000060D0335A419A9999998AF42341666666A6CD335A41CDCCCCCC8BF423419A999979CC335A41000000008CF4234166666646CC335A419A99999991F4234100000020CA335A416666666695F4234100000040C8335A41333333339EF423419A999959C5335A4100000000A3F4234100000040C3335A41CDCCCCCCB4F423419A999919C5335A41CDCCCCCCC9F42341333333B3C5335A419A999999D2F42341CDCCCCCCC5335A419A999999E6F4234133333313C6335A419A99999902F523419A9999B9C6335A41CDCCCCCC23F5234166666686C7335A41666666663BF62341CDCCCC2CCD335A4166666666D0F6234100000000D0335A4133333333C7F623419A999919D5335A41CDCCCCCC1EF72341333333D3D6335A419A999999D7F72341333333F3DA335A416666666613F8234100000060DB335A41000000005FF8234100000080DB335A416666666657F82341666666A6D6335A413333333352F8234100000000D2335A410000000049F82341CDCCCCECC9335A410000000017F82341CDCCCCACB7335A410000000012F82341CDCCCC2CB5335A41333333330DF8234166666606B1335A416666666609F8234166666626AC335A41CDCCCCCC08F8234133333393A8335A41CDCCCCCC08F823419A99991995335A41CDCCCCCCFEF723413333333393335A41CDCCCCCCF7F723416666662691335A41CDCCCCCCF6F723419A9999398F335A41CDCCCCCCEAF72341666666A68E335A4133333333E4F72341666666668E335A419A999999DDF72341666666268E335A4166666666D1F723419A9999F98D335A419A99999934F72341666666A68E335A419A9999992DF72341CDCCCCAC8E335A419A999999FDF62341666666E68E335A4100000000F7F62341333333F38E335A419A999999E7F62341000000008F335A41CDCCCCCC54F62341333333B38F335A4133333333C7F523413333335390335A419A9999996CF52341CDCCCCAC90335A41333333334AF52341333333D390335A410000000041F523419A9999D990335A413333333335F52341666666E690335A416666666633F52341666666E690335A41CDCCCCCC2BF52341333333F390335A419A99999927F523419A9999F990335A413333333315F523416666660691335A416666666611F523416666660691335A410000000007F523419A99991991335A416666666602F523419A9999F990335A4133333333F9F42341CDCCCC0C91335A4133333333E5F423419A99993991335A41CDCCCCCCCCF423410000006091335A4133333333BDF42341000000C091335A4166666666D9F32341CDCCCCAC92335A413333333369F323410000002093335A419A9999991CF323413333337393335A413333333307F323413333339393335A41CDCCCCCCEBF223419A9999B993335A4133333333A4F223416666662694335A410000000075F223416666664694335A41666666663DF22341CDCCCC6C94335A419A99999923F223410000008094335A41CDCCCCCCF5F12341666666E694335A4166666666EEF1234100000000AC335A4133333333ECF123419A999959B2335A4100000000F2F12341CDCCCCCCD9335A41333333334AF2234133333313D9335A416666666647F2234133333393DF335A419A99999940F22341666666E6F0335A41000000003DF22341CDCCCCECF6335A419A9999993FF22341CDCCCC8CF8335A41666666663FF2234166666626FA335A41333333333EF22341333333B301345A419A9999993FF22341666666C606345A419A9999993BF22341000000E00B345A41333333333BF223419A9999590C345A41000000003CF22341CDCCCC4C0E345A41000000003CF22341666666060F345A419A9999993CF22341CDCCCC2C11345A41CDCCCCCC3CF223413333337311345A41333333333DF223419A99991913345A41333333333DF223410000006013345A41666666663DF223410000002014345A41000000003EF223413333331316345A419A9999993EF223413333337319345A419A9999993EF223419A9999B919345A41000000003FF22341000000E01B345A410000000040F223416666660621345A41CDCCCCCC43F223410000002026345A41CDCCCCCC44F22341333333B327345A41CDCCCCCC4AF223419A9999D92F345A41CDCCCCCC12F22341CDCCCC6C2F345A4166666666FDF123413333331335345A419A999999EDF123410000004039345A4133333333DBF12341666666263E345A41	01060000206A080000010000000103000000010000002200000033333333DBF12341666666263E345A419A999999B4F22341666666A64E345A41CDCCCCCC51F32341CDCCCCEC26345A416666666650F32341CDCCCC6C24345A41CDCCCCCC7AF323419A99999918345A4133333333B8F32341666666C60F345A410000000052F423419A9999F9DF335A419A9999998AF42341666666A6CD335A4100000000A3F4234100000040C3335A41CDCCCCCCB4F423419A999919C5335A4166666666D0F6234100000000D0335A4133333333C7F623419A999919D5335A419A999999D7F72341333333F3DA335A41000000005FF8234100000080DB335A410000000049F82341CDCCCCECC9335A410000000017F82341CDCCCCACB7335A416666666609F8234166666626AC335A41CDCCCCCC08F823419A99991995335A41CDCCCCCCF6F723419A9999398F335A4166666666D1F723419A9999F98D335A41CDCCCCCCCCF423410000006091335A4133333333BDF42341000000C091335A419A9999991CF323413333337393335A41CDCCCCCCF5F12341666666E694335A4133333333ECF123419A999959B2335A4100000000F2F12341CDCCCCCCD9335A41333333334AF2234133333313D9335A419A99999940F22341666666E6F0335A41333333333BF223419A9999590C345A410000000040F223416666660621345A41CDCCCCCC4AF223419A9999D92F345A41CDCCCCCC12F22341CDCCCC6C2F345A4133333333DBF12341666666263E345A4133333333DBF12341666666263E345A41	01010000206A0800005C41AD583DF3234100000070E8335A41	930011102	H	Landy	9300111	93001	93	11	0
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	01060000206A080000010000000103000000010000001900000033333333BDF42341000000C091335A41CDCCCCCCCCF423410000006091335A4166666666D1F723419A9999F98D335A41CDCCCCCCF6F723419A9999398F335A4166666666F4F72341666666C67F335A419A999999D7F723419A99995971335A4100000000AEF723413333339365335A419A999999C3F82341000000A05F335A4100000000DDF823419A9999D96C335A410000000013FA2341666666A662335A41CDCCCCCCBBF923419A9999F942335A419A9999995FFA2341000000003C335A4166666666D0F92341000000A00D335A4166666666CCF82341CDCCCC0CDB325A419A999999AFF823419A999919D0325A413333333395F82341000000A0CB325A413333333327F823419A999959B4325A419A99999921F82341666666C6B0325A41CDCCCCCCEFF72341CDCCCC6CBA325A41CDCCCCCC98F72341000000C0AC325A419A99999951F72341666666E6C3325A41666666661FF623416666660623335A4100000000CDF52341333333B33D335A4133333333BDF42341000000C091335A4133333333BDF42341000000C091335A41	01010000206A080000F642786E19F823416666662620335A41	930011201	H	Victor Hugo	9300112	93001	93	11	0
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	01060000206A08000001000000010300000001000000120000003333333382F1234133333373E9325A41CDCCCCCC85F12341000000E0EF325A419A999999E5F123416666660659335A419A99999923F223410000008094335A4133333333BDF42341000000C091335A4100000000CDF52341333333B33D335A41666666661FF623416666660623335A419A99999951F72341666666E6C3325A41CDCCCCCC98F72341000000C0AC325A41666666660BF72341000000E095325A4133333333A4F523419A9999D99B325A41CDCCCCCC14F42341666666669F325A41CDCCCCCCBAF22341000000E0A4325A41CDCCCCCC35F2234100000040A6325A41CDCCCCCCF5F12341666666E6AA325A4100000000A2F1234133333333AF325A413333333382F1234133333373E9325A413333333382F1234133333373E9325A41	01010000206A0800009C597A77FEF323410000008011335A41	930011202	A	Zone Industrielle	9300112	93001	93	11	1
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	01060000206A0800000100000001030000000100000019000000000000006CF12341000000201A325A41CDCCCCCC87F12341CDCCCC2C41325A419A999999A4F12341CDCCCC8C70325A4133333333A7F12341CDCCCCECA5325A4100000000A2F1234133333333AF325A41CDCCCCCCF5F12341666666E6AA325A41CDCCCCCC35F2234100000040A6325A41CDCCCCCCBAF22341000000E0A4325A41CDCCCCCC14F42341666666669F325A4133333333A4F523419A9999D99B325A41666666660BF72341000000E095325A41CDCCCCCCEFF72341CDCCCC6CBA325A41666666660DF823419A999979B6325A4133333333D5F82341666666A678325A41CDCCCCCCF0F82341333333B36D325A4133333333EEF82341CDCCCCEC6A325A41333333332DF92341666666A656325A41333333332AF92341CDCCCC0C55325A41333333335BF923410000006045325A413333333367F923410000002044325A4133333333DCF923419A99995920325A41CDCCCCCC6AF32341CDCCCC6C1B325A41CDCCCCCCC3F22341000000401B325A41000000006CF12341000000201A325A41000000006CF12341000000201A325A41	01010000206A080000A5CF314D50F52341CCCCCC7C64325A41	930011203	A	Magasins Généraux	9300112	93001	93	11	1
01060000206A080000010000000103000000010000003A00000033333333AE332441CDCCCC2C89345A4166666666BB3324413333335392345A41CDCCCCCCC9332441000000609E345A4166666666D6332441CDCCCC0CAC345A41CDCCCCCCDB33244133333353B3345A4133333333E033244166666626B9345A4166666666E833244133333373C9345A41CDCCCCCCEA3324419A999919D4345A419A999999E93324419A999919E5345A4100000000E633244166666626F3345A41CDCCCCCCE33324419A999979F8345A4100000000E83324419A999919F8345A419A999999F0332441CDCCCC4CF7345A41CDCCCCCC0A342441666666A6F4345A41666666663E342441333333D3EE345A4133333333873424419A999999E7345A419A999999FD3424419A9999D9DB345A41666666667936244166666686B4345A4133333333D736244166666626AB345A419A99999936372441CDCCCCACA1345A416666666641372441CDCCCC8CA0345A41CDCCCCCC47372441CDCCCCCC9F345A413333333349372441000000A09F345A41CDCCCCCC583724419A9999B99D345A41000000006C372441000000A09B345A410000000089372441666666E698345A41CDCCCCCC113924416666666674345A410000000010392441333333D372345A4166666666FB3824419A9999D969345A4166666666E13824419A99999960345A41CDCCCCCC5B3A24413333333353345A41000000006E3A2441333333B345345A41666666667A3A2441666666863C345A41333333339D3A2441CDCCCC8C22345A4100000000993A24419A99995921345A4100000000A23A2441000000E01F345A41000000003C3A2441333333B318345A4133333333A2392441000000E00D345A4166666666163924416666668604345A41CDCCCCCC6E3824416666664602345A4100000000F43724419A9999F92A345A41CDCCCCCC46382441000000203D345A41000000004A382441666666863D345A410000000045382441666666E63D345A41CDCCCCCC403824419A9999793E345A41CDCCCCCC3F382441333333533F345A41666666663F382441333333F33F345A410000000042382441000000C040345A4100000000473824419A99995941345A41CDCCCCCC393824419A9999F941345A419A99999975372441CDCCCC8C46345A419A999999053724410000002036345A4166666666DB352441666666C652345A41333333330A352441CDCCCCCC66345A419A999999EB3324410000004082345A4166666666E8332441CDCCCCCC82345A4133333333DA332441666666C684345A4133333333AE332441CDCCCC2C89345A41	01060000206A080000010000000103000000010000001900000033333333AE332441CDCCCC2C89345A41CDCCCCCCC9332441000000609E345A4133333333E033244166666626B9345A41CDCCCCCCEA3324419A999919D4345A41CDCCCCCCE33324419A999979F8345A41666666663E342441333333D3EE345A419A999999FD3424419A9999D9DB345A41666666667936244166666686B4345A419A99999936372441CDCCCCACA1345A41000000006C372441000000A09B345A41CDCCCCCC113924416666666674345A4166666666E13824419A99999960345A41CDCCCCCC5B3A24413333333353345A4100000000A23A2441000000E01F345A4133333333A2392441000000E00D345A4166666666163924416666668604345A41CDCCCCCC6E3824416666664602345A4100000000F43724419A9999F92A345A41CDCCCCCC46382441000000203D345A41CDCCCCCC393824419A9999F941345A419A99999975372441CDCCCC8C46345A419A999999053724410000002036345A419A999999EB3324410000004082345A4133333333AE332441CDCCCC2C89345A4133333333AE332441CDCCCC2C89345A41	01010000206A0800002D29CE967D362441333333537B345A41	930050303	H	Nonneville 3	9300503	93005	93	11	0
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	01060000206A080000010000000103000000010000003900000066666666552D24410000006087375A4100000000222F2441666666069C375A4100000000982F244166666606A2375A4133333333AF2F2441000000608E375A4100000000D72F24419A9999F972375A410000000015302441333333B351375A4100000000133224419A9999D95A375A41666666669D3324416666668660375A41CDCCCCCC8B3424416666664664375A419A999999353524419A99993966375A4133333333BC3524416666660667375A4100000000EA352441CDCCCC0C68375A41CDCCCCCC2D3624419A9999B96C375A41CDCCCCCC7C3624416666666668375A4133333333B63624419A9999796A375A4100000000C5362441000000C065375A419A99999988372441000000E04C375A416666666657382441000000E033375A4100000000FA372441000000E027375A4100000000643724419A99999916375A416666666611372441000000E011375A4100000000E03624416666666612375A41CDCCCCCCC83824419A999999C0365A4100000000563924419A999939A9365A416666666662392441666666C6AA365A41000000008D39244166666626A2365A4133333333A3382441333333B387365A4100000000983824419A9999F985365A41CDCCCCCC0F382441000000A083365A4166666666343524419A9999F975365A41CDCCCCCCD7342441000000206F365A41000000006A3424419A99993962365A41CDCCCCCC55342441000000605E365A4166666666DA3324419A99999969365A419A99999951342441CDCCCC6C7E365A4100000000313424419A99999982365A410000000061342441666666A687365A4133333333553424419A9999398C365A41CDCCCCCCFB3324419A99995998365A4100000000BD3324419A9999199D365A41000000008C332441333333739D365A41666666665F332441333333B39B365A41CDCCCCCC38332441333333B397365A4166666666C33224419A9999F985365A41666666662C32244133333333AA365A419A999999A4312441000000A0AC365A41666666669131244100000040B0365A419A99999943312441CDCCCC8CB6365A41666666662C312441333333D3B9365A410000000000312441666666E6C6365A419A9999998930244100000080D7365A4166666666CC2F24419A999939D5365A419A999999502E2441666666C6F8365A41CDCCCCCC5F2E2441CDCCCC8C3F375A4166666666D62E2441CDCCCCCC75375A4166666666552D24410000006087375A4166666666552D24410000006087375A41	01010000206A080000DAECCCD7C8322441CCCCCC7C02375A41	930050101	H	Fontaine des Prés 1	9300501	93005	93	11	1
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	01060000206A080000010000000103000000010000002300000000000000EE302441666666E629365A41CDCCCCCCF1322441666666267E365A419A999999C3322441CDCCCCEC85365A41CDCCCCCC38332441333333B397365A41666666665F332441333333B39B365A41000000008C332441333333739D365A4100000000BD3324419A9999199D365A41CDCCCCCCFB3324419A99995998365A4133333333553424419A9999398C365A410000000061342441666666A687365A4100000000313424419A99999982365A419A99999951342441CDCCCC6C7E365A4166666666DA3324419A99999969365A41CDCCCCCC55342441000000605E365A41000000006A3424419A99993962365A41CDCCCCCCD7342441000000206F365A4166666666343524419A9999F975365A419A9999999F362441333333B37C365A41CDCCCCCCBA3624419A99997979365A4100000000F93724419A99997961365A41666666665A3924416666666646365A41666666664F3924416666668643365A419A9999995C3824416666660612365A41CDCCCCCC4D382441000000400E365A4100000000A3372441000000C011365A41666666665B3624413333337319365A41666666663C3624410000000006365A419A999999C33524410000004008365A419A999999843524419A9999D90A365A419A9999991435244133333393EF355A413333333310352441000000A0EB355A4166666666F533244166666646F9355A419A99999947322441CDCCCC6C0D365A4100000000EE302441666666E629365A4100000000EE302441666666E629365A41	01010000206A0800004503728C70352441CCCCCC2C44365A41	930050102	H	Fontaine des Prés 2	9300501	93005	93	11	0
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	01060000206A08000001000000010300000001000000230000009A9999999F362441333333B37C365A4100000000983824419A9999F985365A4100000000093A24419A999959B0365A419A999999053B2441333333539D365A41CDCCCCCCAD3A2441666666468B365A4100000000563B2441333333937E365A4100000000AE3B2441CDCCCCEC7A365A4166666666A13B2441333333F336365A4100000000B03B24410000004036365A4100000000683C2441333333B345365A41CDCCCCCC703C24413333337340365A419A999999533C2441666666E62F365A419A9999992C3C2441CDCCCCAC21365A4100000000293E24419A9999190C365A419A999999A73E24419A9999B9FF355A4166666666F63E2441CDCCCCACF3355A4133333333B33E2441666666E6EE355A41CDCCCCCC253E2441333333B3E8355A4133333333443D244100000060D7355A41000000000C3D244166666666D5355A4166666666873C2441CDCCCCACD4355A4133333333B73B244100000080E6355A419A999999033B244100000040F5355A41000000009D3A24419A999999FB355A4166666666F63924413333331303365A4133333333A93924416666664605365A410000000071382441666666C60C365A41CDCCCCCC4D382441000000400E365A419A9999995C3824416666660612365A41666666664F3924416666668643365A41666666665A3924416666666646365A4100000000F93724419A99997961365A41CDCCCCCCBA3624419A99997979365A419A9999999F362441333333B37C365A419A9999999F362441333333B37C365A41	01010000206A080000A9110313783A2441CCCCCCEC42365A41	930050103	H	Fontaine des Prés 3	9300501	93005	93	11	0
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	01010000206A080000C2E3645C48322441333333F39C385A41	930050201	A	Nord 1	9300502	93005	93	11	4
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	01060000206A080000010000000103000000010000001300000033333333B63624419A9999796A375A4100000000C5362441000000606E375A4100000000EA362441333333336F375A41CDCCCCCC2F372441CDCCCCEC6C375A416666666689392441333333D378375A4100000000CA3924410000006060375A41CDCCCCCCFE392441333333734F375A419A999999B03A2441333333731A375A41CDCCCCCCC23A24419A99995918375A41CDCCCCCCA03A2441CDCCCC8C12375A419A999999503A244100000000FA365A4166666666253A2441666666E6F7365A4133333333C33924419A99995904375A41333333334B3824410000006032375A416666666657382441000000E033375A419A99999988372441000000E04C375A4100000000C5362441000000C065375A4133333333B63624419A9999796A375A4133333333B63624419A9999796A375A41	01010000206A080000ECF0428C3E3924410000006038375A41	930050202	H	Nord 2	9300502	93005	93	11	0
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	01060000206A08000001000000010300000001000000390000000000000049332441CDCCCCACE3375A419A9999997E332441CDCCCCCCEC375A4166666666D4332441333333B3F2375A41333333334934244100000060F7375A419A9999997634244133333393FB375A4166666666A5352441000000C01E385A41CDCCCCCC493624413333333333385A413333333384382441CDCCCCEC78385A419A9999992D392441666666E68B385A4100000000BE3A244100000060BB385A4100000000553B24419A999919CE385A41CDCCCCCCAA3B24419A9999D9D7385A4133333333083C2441000000C0E0385A4133333333683C244100000080D8385A4133333333873C244166666686D2385A41333333335D3D244133333353B5385A419A9999990E3E24419A9999D99D385A4100000000DD3E2441CDCCCCEC81385A4166666666743D2441CDCCCC6C55385A41333333339C3B24419A9999791B385A41666666665F3B24410000006013385A4166666666E63B24410000004002385A41333333330D3B2441000000C0E7375A41666666660A3B244133333333E3375A419A9999995D3B2441000000E0D8375A4133333333633B2441CDCCCC4CD5375A419A999999C93A24419A999999C2375A419A999999993A2441CDCCCCACC3375A419A999999923A2441000000A0C1375A419A9999994D392441CDCCCC2C9A375A419A9999993B392441000000A095375A41000000004E392441333333338D375A41CDCCCCCCB13A2441333333D394375A41000000000A3B2441333333B395375A4133333333253C2441666666A69B375A4100000000783C2441000000009C375A41CDCCCCCCD73D2441000000E0A3375A4100000000103E2441666666A6A4375A41000000000F3E2441666666C691375A4100000000413D2441666666068D375A419A999999223C24413333333387375A4133333333ED392441333333D37A375A41CDCCCCCC2F372441CDCCCCEC6C375A4100000000EA362441333333336F375A4100000000C5362441000000606E375A4133333333C03624416666660675375A419A99999980362441CDCCCC4C7D375A419A99999948362441666666067F375A419A99999914362441333333337C375A4166666666F23524416666662685375A4100000000BA3424419A999999BA375A41333333336F34244100000000C4375A419A999999F6332441CDCCCCACCF375A413333333399332441CDCCCC6CD7375A419A9999996E33244166666626DC375A410000000049332441CDCCCCACE3375A410000000049332441CDCCCCACE3375A41	01010000206A08000044DFFBBAD93824419A99991924385A41	930050203	H	Nord 3	9300502	93005	93	11	1
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	01060000206A08000001000000010300000001000000150000009A9999993B392441000000A095375A419A9999994D392441CDCCCC2C9A375A419A999999923A2441000000A0C1375A419A999999993A2441CDCCCCACC3375A419A999999C93A24419A999999C2375A4133333333633B2441CDCCCC4CD5375A419A9999995D3B2441000000E0D8375A41666666660A3B244133333333E3375A41333333330D3B2441000000C0E7375A4166666666E63B24410000004002385A41000000009F3C2441CDCCCC8CEB375A4133333333113E244100000000BC375A4100000000103E2441666666A6A4375A41CDCCCCCCD73D2441000000E0A3375A4100000000783C2441000000009C375A4133333333253C2441666666A69B375A41000000000A3B2441333333B395375A41CDCCCCCCB13A2441333333D394375A41000000004E392441333333338D375A419A9999993B392441000000A095375A419A9999993B392441000000A095375A41	01010000206A080000187A78B3553C24419A999989C7375A41	930050204	H	Nord 4	9300502	93005	93	11	0
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	01060000206A0800000100000001030000000100000029000000666666665F3B24410000006013385A41333333339C3B24419A9999791B385A4166666666743D2441CDCCCC6C55385A4100000000DD3E2441CDCCCCEC81385A419A9999990E3E24419A9999D99D385A41333333335D3D244133333353B5385A4133333333873C244166666686D2385A4133333333683C244100000080D8385A4133333333083C2441000000C0E0385A4100000000733C244100000080EE385A419A9999990C3E2441666666A61E395A4133333333203E2441000000A01F395A41333333337D3E24419A9999792A395A41666666663C3F24419A9999593F395A419A999999053F2441333333F35C395A4133333333A1412441CDCCCC0CF9385A41CDCCCCCCAE41244166666666FA385A419A9999995D422441000000C0EC385A41CDCCCCCCCB422441333333B3E5385A41CDCCCCCC51432441666666E6DA385A41666666665E452441000000608E385A416666666600452441CDCCCC4C87385A4100000000B2442441CDCCCC4C85385A419A9999996C442441000000A085385A413333333376432441CDCCCC4C8A385A410000000021432441000000408B385A419A999999B0422441000000208B385A4100000000164224413333333388385A4100000000884124410000006082385A4133333333F94024413333337379385A4133333333904024413333333370385A419A999999F03F2441CDCCCC0C5E385A41000000005C412441CDCCCC0C28385A41CDCCCCCC4F412441CDCCCC6C21385A4100000000D03F244166666666F2375A4166666666623F24419A9999F9E3375A419A999999223E244166666666BD375A4133333333113E244100000000BC375A41000000009F3C2441CDCCCC8CEB375A41666666665F3B24410000006013385A41666666665F3B24410000006013385A41	01010000206A080000A2956950EB412441000000008C385A41	930050206	H	Nord 6	9300502	93005	93	11	1
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	01060000206A0800000100000001030000000100000031000000000000000E3E244133333393BA375A4166666666D43E244166666606D3375A4166666666623F24419A9999F9E3375A4100000000D03F244166666666F2375A41CDCCCCCC4F412441CDCCCC6C21385A41000000005C412441CDCCCC0C28385A419A999999F03F2441CDCCCC0C5E385A4133333333904024413333333370385A4133333333F94024413333337379385A4100000000884124410000006082385A4100000000164224413333333388385A419A999999B0422441000000208B385A410000000021432441000000408B385A413333333376432441CDCCCC4C8A385A419A9999996C442441000000A085385A4100000000B2442441CDCCCC4C85385A416666666600452441CDCCCC4C87385A41666666665E452441000000608E385A41CDCCCCCCAF4524419A99997982385A4100000000F34524419A9999F985385A41CDCCCCCCBB4624416666662658385A410000000085472441333333B333385A419A99999930472441666666062B385A41000000008D472441666666E61D385A4133333333C1472441CDCCCC2C14385A416666666625482441666666C606385A41666666660549244166666606EA375A41CDCCCCCC48472441CDCCCC4CDD375A41333333332B4624419A999919D7375A410000000034452441CDCCCCECD2375A410000000007452441CDCCCC4CD1375A41CDCCCCCC614424419A9999B9C7375A413333333373442441CDCCCC2CC1375A41000000004F44244100000040B8375A41CDCCCCCC1A4424419A999919B6375A4100000000E343244100000040B8375A41CDCCCCCCB843244100000020BE375A4166666666B143244100000000C4375A4100000000C043244133333313C9375A419A999999B5432441666666A6CC375A41CDCCCCCC9E43244100000080C8375A41000000007F432441CDCCCCACC9375A41CDCCCCCC3942244133333393C0375A413333333399402441666666E6B5375A41666666660F3F244166666646AD375A41666666669F3E244100000080AA375A4100000000103E2441666666A6A4375A41000000000E3E244133333393BA375A41000000000E3E244133333393BA375A41	01010000206A080000B88573FB5A442441CDCCCCBC1A385A41	930050207	H	Nord 7	9300502	93005	93	11	1
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	01060000206A080000010000000103000000010000002100000000000000AC322441CDCCCC8CE2335A41CDCCCCCCB1322441000000C0FC335A4166666666FA322441333333F31B345A410000000030332441666666C62F345A413333333345332441666666263B345A41333333337A332441000000804D345A4166666666A53324410000000063345A4166666666A6332441666666C683345A4133333333AE332441CDCCCC2C89345A419A999999EB3324410000004082345A419A999999053724410000002036345A419A99999975372441CDCCCC8C46345A41CDCCCCCC393824419A9999F941345A41CDCCCCCC46382441000000203D345A4100000000F43724419A9999F92A345A41CDCCCCCC6E3824416666664602345A4166666666163924416666668604345A41CDCCCCCC5F392441333333B3EC335A41CDCCCCCC5A392441CDCCCC2CD8335A41000000009239244166666606BD335A416666666681392441666666E6BB335A4133333333E53824419A999979BF335A419A99999940382441666666C6D1335A419A999999FF372441000000E0DC335A4133333333FF372441333333F3DE335A4133333333883624419A999999E0335A41000000001436244133333373C8335A41CDCCCCCC51342441666666A6DB335A41333333334634244133333313D2335A41CDCCCCCC5533244133333353D6335A419A999999B43224419A9999B9D8335A4100000000AC322441CDCCCC8CE2335A4100000000AC322441CDCCCC8CE2335A41	01010000206A080000800960B08C3524416666667623345A41	930050304	H	Nonneville 4	9300503	93005	93	11	0
01060000206A080000010000000103000000010000008F0000006666666689392441333333D378375A4133333333A33924419A99995979375A4133333333ED392441333333D37A375A41333333335E3A2441666666467D375A4166666666FB3A2441333333B380375A419A9999998D3B2441CDCCCCCC83375A41333333331E3C24419A99991987375A419A999999223C24413333333387375A4100000000903C2441CDCCCC6C89375A4166666666E33C2441000000208B375A4100000000413D2441666666068D375A41000000000F3E2441666666C691375A41333333330F3E24419A99999994375A41CDCCCCCC0F3E2441CDCCCC2C96375A41CDCCCCCC0F3E2441000000209D375A4100000000103E2441666666A6A4375A4133333333143E24419A9999B9A4375A4166666666233E2441CDCCCC4CA5375A4166666666823E244133333353A9375A41666666669F3E244100000080AA375A41666666660F3F244166666646AD375A419A999999273F2441333333D3AD375A4100000000823F2441CDCCCCCCAF375A41CDCCCCCCBC3F2441CDCCCC0CB1375A419A999999CB3F244100000060B1375A41CDCCCCCC214024419A999939B3375A41000000002A402441CDCCCC6CB3375A413333333399402441666666E6B5375A41CDCCCCCCCF40244100000040B7375A4133333333EC40244133333313B8375A416666666652412441000000A0BA375A41CDCCCCCC3942244133333393C0375A41CDCCCCCCB0422441333333F3C3375A410000000039432441000000C0C7375A410000000048432441CDCCCC2CC8375A41000000005143244166666666C8375A41000000007F432441CDCCCCACC9375A4166666666854324419A999979CA375A41CDCCCCCC8F432441CDCCCC8CC9375A41CDCCCCCC9E43244100000080C8375A4133333333A2432441CDCCCC2CC9375A4166666666AB432441666666E6CB375A419A999999B5432441666666A6CC375A419A999999BA432441CDCCCCECCB375A4133333333BC43244100000000CB375A41CDCCCCCCBC43244100000020CA375A4100000000C043244133333313C9375A41CDCCCCCCB74324419A999999C6375A4166666666B143244100000000C4375A41CDCCCCCCB1432441CDCCCC6CC1375A419A999999B343244100000020C0375A4100000000B74324419A9999B9BE375A41CDCCCCCCB843244100000020BE375A41CDCCCCCCBC4324419A999939BD375A4100000000C643244100000080BB375A4133333333D143244100000020BA375A4166666666B943244166666626B8375A4166666666A243244100000040B6375A41CDCCCCCC77432441666666C6B3375A419A99999964432441666666A6B2375A41CDCCCCCC5E43244133333353B2375A410000000054432441CDCCCC0CB2375A41CDCCCCCC4F432441CDCCCCECB1375A41666666665F422441CDCCCC8CAB375A419A9999994141244133333333A5375A416666666641402441CDCCCC0C9F375A416666666625402441000000609E375A419A99999928402441666666669C375A41CDCCCCCC2B4024419A9999B999375A419A9999992B4024419A9999B995375A4166666666224024419A9999D989375A41CDCCCCCC21402441CDCCCC2C88375A41CDCCCCCC204024419A99995987375A41CDCCCCCC1D4024413333335386375A419A99999919402441000000A085375A41CDCCCCCC0C4024416666666684375A4166666666DD3F24419A9999F981375A41CDCCCCCCC63F2441333333B380375A4133333333853F2441CDCCCC0C7D375A419A9999995A3F2441CDCCCC0C7A375A41333333331D3F2441333333B375375A4133333333DF3E24419A99993971375A41CDCCCCCCB73E2441CDCCCC8C6E375A4100000000753E2441666666066A375A419A999999533E2441666666E667375A41000000003D3E2441CDCCCC6C66375A4133333333363E2441CDCCCC4C66375A4100000000153E24419A99999965375A419A999999133E2441333333B364375A419A9999990F3E2441CDCCCCEC63375A41CDCCCCCC063E24419A9999F962375A4133333333003E24410000008062375A41CDCCCCCCF63D2441333333D361375A419A999999E53D24413333339360375A4133333333E13D24410000004060375A4100000000C03D2441333333B35D375A41CDCCCCCCA43D24419A99997968375A4100000000B33D24416666660671375A419A999999AF3D24413333335371375A4100000000663D24419A99997971375A41000000006C3D2441CDCCCC2C7A375A41CDCCCCCC983D2441CDCCCCAC7F375A4133333333B13D24410000002083375A41CDCCCCCCB73D24413333339384375A4133333333B93D2441CDCCCC6C85375A419A999999B93D2441666666A685375A4133333333B83D24419A9999D986375A4166666666AF3D24413333333388375A4133333333A93D2441CDCCCC8C88375A4100000000A03D2441666666C688375A41000000009D3D2441000000A088375A41666666666F3D2441CDCCCCAC87375A4133333333123D2441666666E67C375A41666666660E3D2441CDCCCCEC7D375A419A999999AC3C2441CDCCCC8C80375A4133333333963C24416666662681375A4166666666763C24419A99997981375A41333333336B3C24416666662681375A41CDCCCCCC5D3C24413333337380375A41666666665A3C24416666664680375A4166666666DC3B24410000006073375A4100000000BE3B2441666666A670375A4133333333623A2441000000A075375A419A999999543A24416666660676375A41CDCCCCCC463A24419A9999B975375A4166666666363A24416666668674375A41333333332E3A2441000000A073375A419A999999253A2441CDCCCC4C72375A419A9999990B3A2441666666C66D375A419A999999F9392441CDCCCCCC6A375A4133333333F4392441666666A669375A4100000000F23924416666666668375A419A999999EE392441333333D366375A4166666666EC392441CDCCCCAC65375A419A999999E8392441CDCCCCAC65375A4133333333E03924416666668665375A4133333333D23924413333331365375A4100000000C0392441CDCCCC4C64375A419A999999A7392441000000C06C375A419A9999999A3924416666660672375A41CDCCCCCC973924413333333373375A41666666668D392441666666C676375A416666666689392441333333D378375A41	01060000206A080000010000000103000000010000002F0000006666666689392441333333D378375A419A9999998D3B2441CDCCCCCC83375A419A999999223C24413333333387375A4100000000413D2441666666068D375A41000000000F3E2441666666C691375A4100000000103E2441666666A6A4375A41666666669F3E244100000080AA375A41666666660F3F244166666646AD375A413333333399402441666666E6B5375A41CDCCCCCC3942244133333393C0375A41000000007F432441CDCCCCACC9375A41CDCCCCCC9E43244100000080C8375A419A999999B5432441666666A6CC375A4100000000C043244133333313C9375A4166666666B143244100000000C4375A41CDCCCCCCB843244100000020BE375A4133333333D143244100000020BA375A41CDCCCCCC5E43244133333353B2375A41666666665F422441CDCCCC8CAB375A419A9999994141244133333333A5375A416666666625402441000000609E375A419A9999992B4024419A9999B995375A41CDCCCCCC204024419A99995987375A41CDCCCCCC0C4024416666666684375A4133333333853F2441CDCCCC0C7D375A4133333333DF3E24419A99993971375A41CDCCCCCC063E24419A9999F962375A4100000000C03D2441333333B35D375A41CDCCCCCCA43D24419A99997968375A4100000000B33D24416666660671375A4100000000663D24419A99997971375A41000000006C3D2441CDCCCC2C7A375A41CDCCCCCCB73D24413333339384375A4100000000A03D2441666666C688375A41666666666F3D2441CDCCCCAC87375A4133333333123D2441666666E67C375A41666666660E3D2441CDCCCCEC7D375A4133333333963C24416666662681375A41666666665A3C24416666664680375A4100000000BE3B2441666666A670375A4133333333623A2441000000A075375A419A999999253A2441CDCCCC4C72375A4133333333F4392441666666A669375A4166666666EC392441CDCCCCAC65375A4100000000C0392441CDCCCC4C64375A416666666689392441333333D378375A416666666689392441333333D378375A41	01010000206A080000322A0C4A1D3F24419A99992995375A41	930050208	H	Nord 8	9300502	93005	93	11	0
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	01060000206A080000010000000103000000010000001D00000000000000C0392441CDCCCC4C64375A4166666666EC392441CDCCCCAC65375A4133333333F4392441666666A669375A419A999999253A2441CDCCCC4C72375A4133333333623A2441000000A075375A4100000000BE3B2441666666A670375A41666666665A3C24416666664680375A4133333333963C24416666662681375A41666666660E3D2441CDCCCCEC7D375A4133333333123D2441666666E67C375A41666666666F3D2441CDCCCCAC87375A4100000000A03D2441666666C688375A41CDCCCCCCB73D24413333339384375A41000000006C3D2441CDCCCC2C7A375A4100000000663D24419A99997971375A4100000000B33D24416666660671375A41CDCCCCCCA43D24419A99997968375A4100000000C03D2441333333B35D375A4100000000573D2441CDCCCCEC55375A41CDCCCCCCF93C2441CDCCCC6C56375A4133333333AB3C24419A9999B959375A41CDCCCCCC593C2441333333D356375A41000000001A3C2441666666064E375A419A999999B13B2441666666A63C375A4133333333213B2441666666A628375A419A999999B03A2441333333731A375A41CDCCCCCCFE392441333333734F375A4100000000C0392441CDCCCC4C64375A4100000000C0392441CDCCCC4C64375A41	01010000206A08000074359DE9153B2441CCCCCCBC51375A41	930050209	H	Nord 9	9300502	93005	93	11	0
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	01060000206A080000010000000103000000010000001E00000066666666B03224413333335326355A4133333333FC322441666666062B355A4100000000783324419A99993931355A419A999999A63324419A9999F936355A4100000000AD332441000000C055355A419A9999995D3424413333333355355A410000000076342441CDCCCCAC59355A419A999999FA3424419A99997959355A419A999999E7362441CDCCCCEC56355A413333333359382441CDCCCC8C55355A4133333333443A2441666666A655355A419A999999E33A24419A99993956355A41CDCCCCCCDC3A2441666666A651355A419A999999EB3A2441CDCCCC0C48355A4133333333EC3A24419A9999F93E355A41CDCCCCCCD33A2441000000E020355A41666666660A3A24419A9999D9FF345A410000000043392441000000C0E0345A410000000007392441CDCCCC8CDF345A41CDCCCCCCF9362441CDCCCCEC0C355A4133333333B0362441333333D3FC345A410000000052362441333333F3EF345A4133333333ED352441000000E002355A41CDCCCCCCFC3424419A9999F9E5345A419A999999FD3424419A9999D9DB345A41666666663E342441333333D3EE345A419A999999983324416666668600355A41CDCCCCCC21332441000000E00A355A4166666666B03224413333335326355A4166666666B03224413333335326355A41	01010000206A0800004E4D8166C53624413433335318355A41	930050301	H	Nonneville 1	9300503	93005	93	11	0
01060000206A0800000100000001030000000100000032000000CDCCCCCCFC3424419A9999F9E5345A4133333333ED352441000000E002355A410000000052362441333333F3EF345A419A999999763624419A999959F4345A4133333333B0362441333333D3FC345A4133333333CF362441333333F304355A4133333333DD362441666666E607355A41CDCCCCCCF9362441CDCCCCEC0C355A41333333337D372441CDCCCC6C01355A41333333330238244133333333F6345A410000000007392441CDCCCC8CDF345A41666666660939244133333313E0345A410000000010392441000000E0E0345A41CDCCCCCC19392441CDCCCC6CE1345A41000000002C39244133333393E1345A41000000003839244133333353E1345A410000000043392441000000C0E0345A41333333334A392441000000E0DF345A419A9999994F39244100000000DE345A41CDCCCCCC50392441000000E0DB345A41000000004D392441CDCCCC2CDA345A41CDCCCCCCCC392441666666E6D0345A4166666666373A2441CDCCCC8CC9345A41CDCCCCCC953A2441CDCCCCECC2345A419A999999203B2441CDCCCC2CB9345A4100000000343C2441333333D3A5345A419A9999992E3C244133333353A5345A41000000002E3C2441000000A0A4345A4166666666313C244133333373A3345A4133333333363C2441CDCCCCECA2345A41666666669E3B24413333331383345A4166666666163B2441000000C066345A4166666666013B2441666666C662345A4166666666F53A24419A99993961345A41CDCCCCCC5B3A24413333333353345A4166666666E13824419A99999960345A4166666666FB3824419A9999D969345A410000000010392441333333D372345A41CDCCCCCC113924416666666674345A410000000089372441666666E698345A41000000006C372441000000A09B345A41CDCCCCCC583724419A9999B99D345A413333333349372441000000A09F345A41CDCCCCCC47372441CDCCCCCC9F345A416666666641372441CDCCCC8CA0345A419A99999936372441CDCCCCACA1345A4133333333D736244166666626AB345A41666666667936244166666686B4345A419A999999FD3424419A9999D9DB345A41CDCCCCCCFC3424419A9999F9E5345A41	01060000206A0800000100000001030000000100000015000000CDCCCCCCFC3424419A9999F9E5345A4133333333ED352441000000E002355A410000000052362441333333F3EF345A4133333333B0362441333333D3FC345A41CDCCCCCCF9362441CDCCCCEC0C355A410000000007392441CDCCCC8CDF345A410000000043392441000000C0E0345A41000000004D392441CDCCCC2CDA345A4100000000343C2441333333D3A5345A4133333333363C2441CDCCCCECA2345A4166666666163B2441000000C066345A4166666666F53A24419A99993961345A41CDCCCCCC5B3A24413333333353345A4166666666E13824419A99999960345A41CDCCCCCC113924416666666674345A41000000006C372441000000A09B345A419A99999936372441CDCCCCACA1345A41666666667936244166666686B4345A419A999999FD3424419A9999D9DB345A41CDCCCCCCFC3424419A9999F9E5345A41CDCCCCCCFC3424419A9999F9E5345A41	01010000206A080000D317F4E526392441666666D6AF345A41	930050302	H	Nonneville 2	9300503	93005	93	11	0
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	01060000206A080000010000000103000000010000001B0000000000000043392441000000C0E0345A41666666660A3A24419A9999D9FF345A41CDCCCCCCD33A2441000000E020355A41CDCCCCCCDA3A24419A9999192D355A41CDCCCCCCEF3A24410000000042355A41CDCCCCCCDC3A2441666666A651355A419A999999E33A24419A99993956355A41333333338B3C24416666668657355A41CDCCCCCC673D2441CDCCCCAC57355A41CDCCCCCC623F2441CDCCCCAC56355A419A999999D64024416666666655355A4133333333614124410000000056355A419A9999995F4124413333337347355A410000000072412441000000C03C355A419A999999B64124419A99997930355A419A9999995E4124413333339333355A41333333331140244100000060ED345A419A999999054024419A9999B9ED345A419A999999E03F2441333333D3FE345A4133333333A83D2441CDCCCCECF1345A41CDCCCCCCF63C24419A999939EE345A419A9999996F3D24419A999999E5345A419A9999993E3C24419A9999B9A5345A4100000000343C2441333333D3A5345A41000000004D392441CDCCCC2CDA345A410000000043392441000000C0E0345A410000000043392441000000C0E0345A41	01010000206A08000008DEB9FDB73C244166666696FC345A41	930050401	H	Parc 1	9300504	93005	93	11	0
01060000206A080000010000000103000000010000005800000066666666163924416666668604345A4133333333A2392441000000E00D345A41000000003C3A2441333333B318345A4100000000A23A2441000000E01F345A4100000000993A24419A99995921345A41333333339D3A2441CDCCCC8C22345A41666666667A3A2441666666863C345A41000000006E3A2441333333B345345A41CDCCCCCC5B3A24413333333353345A4166666666F53A24419A99993961345A4166666666013B2441666666C662345A4166666666163B2441000000C066345A41666666669E3B24413333331383345A4133333333363C2441CDCCCCECA2345A4166666666313C244133333373A3345A41000000002E3C2441000000A0A4345A419A9999992E3C244133333353A5345A4100000000343C2441333333D3A5345A419A9999993E3C24419A9999B9A5345A4133333333AF3C244166666606BD345A4100000000153D244166666666D2345A419A9999996F3D24419A999999E5345A4133333333393D244133333373E9345A4100000000FE3C2441000000A0ED345A41CDCCCCCCF63C24419A999939EE345A41CDCCCCCC3F3D2441000000C0EF345A4133333333A83D2441CDCCCCECF1345A419A999999B63D244100000040F2345A419A999999013F2441CDCCCCECF9345A4166666666143F24419A999959FA345A419A999999E03F2441333333D3FE345A419A999999054024419A9999B9ED345A41000000000840244100000040EB345A416666666601402441CDCCCC0CEA345A419A9999999B3F24419A999919D5345A419A9999994A3F244100000020C4345A419A999999F03E2441000000E0B0345A41333333330F3F24419A999959B0345A4166666666423F2441666666E6AF345A4100000000653F244100000040AF345A4166666666C33F244166666606A8345A419A99999956402441333333F39B345A41CDCCCCCCDD3F2441000000C082345A4166666666CD3F2441CDCCCCCC7D345A4100000000CA3F2441000000C07B345A4166666666B83F2441CDCCCCEC79345A4166666666813E24419A99995964345A41CDCCCCCC7B3E24419A9999D961345A41CDCCCCCC323E2441CDCCCC2C3A345A4166666666303E2441000000C038345A41CDCCCCCC283E24413333337334345A419A999999133E24416666662629345A4166666666093E24413333333324345A419A999999063E24419A9999B922345A41CDCCCCCC903D2441CDCCCC4C26345A41000000008F3D24419A99995926345A4100000000943D2441666666462A345A419A9999998F3D2441333333732A345A41CDCCCCCCFB3C24419A9999B92D345A419A999999F73C2441000000601D345A419A999999E73C2441000000201D345A41CDCCCCCC493C24413333331312345A4133333333D63B2441CDCCCCCC09345A41000000008A3B24419A99993904345A41CDCCCCCC393B2441666666C6FE335A419A999999203B244166666686FD335A41666666661A3B244166666666FD335A41000000000D3B2441CDCCCC6CFD335A4100000000023B2441CDCCCCECFD335A4100000000F83A2441CDCCCCCCFE335A4166666666F13A2441333333B3FF335A419A999999E13A244100000080FE335A4100000000D13A2441666666E6FC335A4133333333B43A244133333393F9335A419A999999A93A244133333393F8335A419A999999883A244166666686F6335A41CDCCCCCC6A3A24419A999919F5335A41000000005C3A2441CDCCCC8CF4335A41333333333E3A2441333333D3F3335A4133333333FC392441CDCCCC6CF2335A419A999999E439244133333393F1335A4100000000DE392441CDCCCC2CF1335A419A999999BC3924419A9999F9EE335A41CDCCCCCCAD3924419A999959EE335A41666666669E3924419A9999F9ED335A41666666666A39244133333313ED335A41CDCCCCCC5F392441333333B3EC335A4166666666163924416666668604345A41	01060000206A080000010000000103000000010000002400000066666666163924416666668604345A4133333333A2392441000000E00D345A4100000000A23A2441000000E01F345A41CDCCCCCC5B3A24413333333353345A4166666666F53A24419A99993961345A4166666666163B2441000000C066345A4133333333363C2441CDCCCCECA2345A419A9999993E3C24419A9999B9A5345A419A9999996F3D24419A999999E5345A41CDCCCCCCF63C24419A999939EE345A4133333333A83D2441CDCCCCECF1345A419A999999E03F2441333333D3FE345A41000000000840244100000040EB345A419A9999999B3F24419A999919D5345A419A999999F03E2441000000E0B0345A4100000000653F244100000040AF345A419A99999956402441333333F39B345A41CDCCCCCCDD3F2441000000C082345A4166666666B83F2441CDCCCCEC79345A4166666666813E24419A99995964345A419A999999063E24419A9999B922345A41000000008F3D24419A99995926345A4100000000943D2441666666462A345A41CDCCCCCCFB3C24419A9999B92D345A419A999999F73C2441000000601D345A419A999999E73C2441000000201D345A41000000008A3B24419A99993904345A419A999999203B244166666686FD335A4166666666F13A2441333333B3FF335A419A999999A93A244133333393F8335A41000000005C3A2441CDCCCC8CF4335A4133333333FC392441CDCCCC6CF2335A419A999999BC3924419A9999F9EE335A41CDCCCCCC5F392441333333B3EC335A4166666666163924416666668604345A4166666666163924416666668604345A41	01010000206A08000012ACCF50393D24416666665670345A41	930050402	H	Parc 2	9300504	93005	93	11	0
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	01060000206A0800000100000001030000000100000020000000CDCCCCCC5839244166666646DB335A41CDCCCCCC5F392441333333B3EC335A419A999999BC3924419A9999F9EE335A4133333333FC392441CDCCCC6CF2335A41000000005C3A2441CDCCCC8CF4335A419A999999A93A244133333393F8335A4166666666F13A2441333333B3FF335A419A999999203B244166666686FD335A41000000008A3B24419A99993904345A419A999999E73C2441000000201D345A419A999999F73C2441000000601D345A41CDCCCCCCFB3C24419A9999B92D345A4100000000943D2441666666462A345A41000000008F3D24419A99995926345A419A999999063E24419A9999B922345A4166666666813E24419A99995964345A4166666666B83F2441CDCCCCEC79345A4100000000CA3F2441000000C07B345A419A99999955402441000000E069345A416666666666402441CDCCCC8C66345A41CDCCCCCC9B402441666666C64C345A41CDCCCCCC6A41244166666646ED335A4133333333E7412441666666E6EB335A413333333339422441666666A6E7335A419A999999024224419A9999B9DC335A41CDCCCCCCB03C244166666666BE335A419A999999F33B2441666666A6BA335A4166666666D039244100000080AE335A41000000009239244166666606BD335A41CDCCCCCC5A392441CDCCCC2CD8335A41CDCCCCCC5839244166666646DB335A41CDCCCCCC5839244166666646DB335A41	01010000206A0800000C1B8F26D43E24419A99999917345A41	930050403	H	Parc 3	9300504	93005	93	11	0
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	01060000206A08000001000000010300000001000000230000009A999999F03E2441000000E0B0345A419A9999994A3F244100000020C4345A416666666601402441CDCCCC0CEA345A419A9999995E4124413333339333355A419A999999B64124419A99997930355A410000000072412441000000C03C355A419A9999995F4124413333337347355A4133333333614124410000000056355A4166666666094324410000002057355A4133333333BB4324419A99999956355A4100000000AD4424416666666653355A410000000000452441333333934B355A4133333333DD452441000000E03E355A41CDCCCCCCCD4624413333339321355A419A999999A4462441666666C619355A41333333335E462441CDCCCC4C09355A4133333333484624419A999939FB345A410000000048462441666666E6EE345A41333333335945244166666646DC345A41CDCCCCCCEC43244166666686C4345A41000000006A43244166666626D3345A41666666663D43244133333333E1345A41000000000F43244133333393E5345A4133333333B542244166666646EA345A419A9999999642244100000020F0345A419A999999D9412441000000A0B5345A41CDCCCCCCCB412441CDCCCCACAD345A4166666666FE4124419A999919A2345A4133333333DC3F24419A9999397C345A4100000000CA3F2441000000C07B345A41CDCCCCCCDD3F2441000000C082345A419A99999956402441333333F39B345A4100000000653F244100000040AF345A419A999999F03E2441000000E0B0345A419A999999F03E2441000000E0B0345A41	01010000206A08000090960EAF5F44244134333383E9345A41	930050501	H	Émile Zola 1	9300505	93005	93	11	0
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	01060000206A080000010000000103000000010000001E00000000000000CA3F2441000000C07B345A4133333333DC3F24419A9999397C345A4166666666FE4124419A999919A2345A41CDCCCCCCCB412441CDCCCCACAD345A419A999999D9412441000000A0B5345A419A9999999642244100000020F0345A4133333333B542244166666646EA345A41000000000F43244133333393E5345A41666666663D43244133333333E1345A41000000006A43244166666626D3345A41CDCCCCCCEC43244166666686C4345A41333333335945244166666646DC345A410000000048462441666666E6EE345A416666666648462441000000A0E7345A410000000035462441666666C6DE345A41CDCCCCCCD746244100000040CF345A41000000002247244133333353C2345A4133333333664724419A9999B9BB345A4100000000E9452441CDCCCC0C7B345A41CDCCCCCC764524419A9999F985345A4133333333DF442441000000406C345A419A99999909442441000000C05F345A4100000000284324419A9999B95D345A419A99999998412441666666E645345A41CDCCCCCC69412441666666C642345A4100000000D6402441CDCCCC4C32345A416666666666402441CDCCCC8C66345A419A99999955402441000000E069345A4100000000CA3F2441000000C07B345A4100000000CA3F2441000000C07B345A41	01010000206A0800002E6F8CA0B24324419A99997990345A41	930050502	H	Émile Zola 2	9300505	93005	93	11	0
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	01060000206A080000010000000103000000010000002500000000000000D6402441CDCCCC4C32345A41CDCCCCCC69412441666666C642345A419A99999998412441666666E645345A4100000000284324419A9999B95D345A419A99999909442441000000C05F345A4133333333DF442441000000406C345A41CDCCCCCC764524419A9999F985345A4100000000E9452441CDCCCC0C7B345A4133333333664724419A9999B9BB345A4100000000EC47244166666626B0345A41CDCCCCCC1848244133333313AA345A41333333332048244100000060AB345A419A9999995548244133333393A6345A413333333381482441CDCCCC6CA0345A419A999999A3482441CDCCCC4CA0345A41CDCCCCCCA1482441000000C099345A4166666666E44824419A99993998345A41CDCCCCCCE54824419A9999F98F345A41666666669A482441333333D390345A419A99999996482441CDCCCCEC82345A419A9999998B4824416666660683345A41000000001F4824419A99991976345A4166666666ED472441000000406E345A4100000000A8472441000000C05B345A41CDCCCCCC6E472441000000C051345A41CDCCCCCC11472441000000A05B345A4100000000004724410000000057345A413333333348462441666666462F345A41333333335D462441CDCCCC6C2D345A41CDCCCCCC8345244133333353F3335A41666666668045244166666646F0335A419A999999024224419A9999B9DC335A413333333339422441666666A6E7335A4133333333E7412441666666E6EB335A41CDCCCCCC6A41244166666646ED335A4100000000D6402441CDCCCC4C32345A4100000000D6402441CDCCCC4C32345A41	01010000206A0800004CFB814E5F442441000000604B345A41	930050503	H	Émile Zola 3	9300505	93005	93	11	0
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	01060000206A0800000100000001030000000100000028000000000000003C3A2441333333F3F7365A419A999999613A2441CDCCCC0CFE365A41CDCCCCCCA03A2441CDCCCC8C12375A4166666666C03A2441CDCCCC8C16375A419A999999BA3A2441000000801B375A4133333333213B2441666666A628375A419A999999B13B2441666666A63C375A41000000001A3C2441666666064E375A41CDCCCCCC593C2441333333D356375A4133333333AB3C24419A9999B959375A41CDCCCCCCF93C2441CDCCCC6C56375A4100000000573D2441CDCCCCEC55375A41CDCCCCCC063E24419A9999F962375A4133333333DF3E24419A99993971375A4133333333853F2441CDCCCC0C7D375A41CDCCCCCC0C4024416666666684375A41CDCCCCCC21402441CDCCCC2C88375A416666666639402441CDCCCC8C87375A41CDCCCCCC984024413333331370375A41CDCCCCCCC84024419A9999B96D375A41CDCCCCCCEC402441CDCCCCEC67375A41333333330F412441000000606B375A41CDCCCCCC40412441CDCCCC0C60375A4166666666634124419A9999195B375A419A999999D34124419A99993951375A4166666666404124419A9999B93A375A4100000000FD4024413333335332375A416666666616402441333333F31A375A41666666667C3F24416666666609375A4166666666C93E244100000060F2365A419A999999A53D2441666666C6C4365A419A999999D63C24419A999939A5365A4100000000983C2441CDCCCCCC99365A41666666666B3C2441CDCCCCCC9F365A419A9999996C3C244100000040A6365A41000000003C3C2441CDCCCCECA9365A4133333333BD3B2441CDCCCC8CC0365A41CDCCCCCC303B244133333333D5365A41000000003C3A2441333333F3F7365A41000000003C3A2441333333F3F7365A41	01010000206A080000F09846A92F3D24419A99997911375A41	930050601	H	Bourg 1	9300506	93005	93	11	0
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	01060000206A080000010000000103000000010000001B00000000000000983C2441CDCCCCCC99365A419A999999D63C24419A999939A5365A419A999999A53D2441666666C6C4365A4166666666C93E244100000060F2365A41666666667C3F24416666666609375A416666666616402441333333F31A375A41666666664E4024410000008020375A416666666638412441333333F308375A41000000007E412441000000C002375A41000000007C41244100000000FF365A41CDCCCCCCD340244166666666E6365A41000000004342244133333353C0365A41CDCCCCCCF24124419A9999D9B3365A41000000002B4224419A9999199E365A41666666668B422441000000A094365A41333333335B422441666666468E365A419A9999994D412441333333D363365A419A999999D8402441CDCCCC8C56365A4166666666E13F24413333337335365A41CDCCCCCC743F2441666666463B365A4100000000F63D24416666668655365A41000000000D3D2441333333736E365A4100000000E13C24419A99997975365A4100000000CB3C2441000000A07D365A41CDCCCCCCB73C24410000004092365A4100000000983C2441CDCCCCCC99365A4100000000983C2441CDCCCCCC99365A41	01010000206A080000DCC584DF833F2441CDCCCC0CAB365A41	930050602	H	Bourg 2	9300506	93005	93	11	0
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	01060000206A080000010000000103000000010000002F0000009A9999992C3C2441CDCCCCAC21365A419A999999533C2441666666E62F365A41CDCCCCCC703C24413333337340365A4100000000683C2441333333B345365A419A999999D13C2441000000804E365A4133333333F13C24410000002052365A419A999999013D2441333333F34E365A4166666666413D24419A9999594F365A419A999999743D2441000000604D365A419A999999D63D2441000000C04C365A4133333333FE3D2441333333D354365A41CDCCCCCC743F2441666666463B365A4166666666E13F24413333337335365A419A999999D8402441CDCCCC8C56365A419A9999994D412441333333D363365A4100000000014224416666666680365A41333333337C4224419A99997992365A419A999999A84224419A99997973365A4100000000D1422441666666E650365A419A999999C84224419A9999794A365A41666666661E4324413333339343365A416666666686432441000000205C365A419A999999D34324413333331357365A419A9999998C4324419A99991947365A41CDCCCCCC534324413333335338365A41000000009C432441666666E634365A413333333323442441000000C032365A416666666658442441333333532C365A419A9999996B442441000000A021365A416666666649442441CDCCCC6C21365A41666666664143244133333393E1355A41CDCCCCCCB442244100000080B5355A419A999999A241244166666646BF355A41000000009541244100000020B8355A41CDCCCCCC8B4124419A999939A6355A41CDCCCCCC95412441CDCCCC8C99355A41666666668D4124416666664699355A413333333375412441CDCCCC2C8A355A419A99999966402441CDCCCC4C9F355A416666666669402441333333D3B0355A41CDCCCCCC433F2441000000C0FB355A41CDCCCCCC383F2441CDCCCC4CFD355A4166666666F63E2441CDCCCCACF3355A419A999999A73E24419A9999B9FF355A4100000000293E24419A9999190C365A419A9999992C3C2441CDCCCCAC21365A419A9999992C3C2441CDCCCCAC21365A41	01010000206A08000069FCF9F5EF402441666666060F365A41	930050603	H	Bourg 3	9300506	93005	93	11	0
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	01060000206A080000010000000103000000010000002600000000000000E03624416666666612375A416666666611372441000000E011375A4100000000643724419A99999916375A4100000000FA372441000000E027375A41333333334B3824410000006032375A4133333333C33924419A99995904375A4166666666253A2441666666E6F7365A41000000003C3A2441333333F3F7365A41CDCCCCCC303B244133333333D5365A4133333333BD3B2441CDCCCC8CC0365A41000000003C3C2441CDCCCCECA9365A419A9999996C3C244100000040A6365A41666666666B3C2441CDCCCCCC9F365A419A999999923C2441CDCCCCAC9A365A41CDCCCCCCB73C24410000004092365A4100000000CB3C2441000000A07D365A4100000000E13C24419A99997975365A41000000000D3D2441333333736E365A4133333333FE3D2441333333D354365A419A999999D63D2441000000C04C365A419A999999743D2441000000604D365A4166666666413D24419A9999594F365A419A999999013D2441333333F34E365A4133333333F13C24410000002052365A419A999999D13C2441000000804E365A4100000000B03B24410000004036365A4166666666A13B2441333333F336365A4100000000AE3B2441CDCCCCEC7A365A4100000000563B2441333333937E365A41CDCCCCCCAD3A2441666666468B365A419A999999053B2441333333539D365A4100000000093A24419A999959B0365A41000000008D39244166666626A2365A416666666662392441666666C6AA365A4100000000563924419A999939A9365A41CDCCCCCCC83824419A999999C0365A4100000000E03624416666666612375A4100000000E03624416666666612375A41	01010000206A0800003A059D25933A244166666616B3365A41	930050604	H	Bourg 4	9300506	93005	93	11	0
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	01060000206A0800000100000001030000000100000028000000000000004B44244166666606B8375A410000000068442441CDCCCCECBB375A413333333373442441CDCCCC2CC1375A41CDCCCCCC614424419A9999B9C7375A410000000007452441CDCCCC4CD1375A410000000034452441CDCCCCECD2375A41333333332B4624419A999919D7375A41CDCCCCCC48472441CDCCCC4CDD375A41666666660549244166666606EA375A41333333336B49244100000000DD375A41CDCCCCCC8F4924419A9999D9E0375A419A999999CF492441CDCCCCACDD375A419A9999990E4A24419A999919D5375A4166666666724B24413333331383375A41CDCCCCCC354B2441666666A67D375A4166666666CE4B2441CDCCCC2C69375A4133333333FE4B2441CDCCCC0C62375A4166666666244C2441333333935E375A419A999999734C24410000000052375A4133333333F34B2441CDCCCC8C4A375A4133333333FC4B24419A9999D951375A4133333333DF4B24419A99997955375A4133333333684B2441666666866B375A4166666666054B2441CDCCCC0C7F375A419A999999DF4A2441CDCCCC6C82375A4166666666754A2441000000807A375A41CDCCCCCC22492441CDCCCCAC6C375A41000000000E4924419A9999D96E375A4133333333AA4824419A99997994375A41CDCCCCCC59482441333333B3B0375A41000000002A482441CDCCCC8CB5375A41CDCCCCCCFA472441000000C0B6375A41333333333547244100000040C2375A4133333333FA462441CDCCCC8CC1375A41000000007B452441000000E0B5375A41CDCCCCCCE644244166666626B4375A4100000000A6442441000000A0AE375A41000000008344244100000060B3375A41000000004B44244166666606B8375A41000000004B44244166666606B8375A41	01010000206A080000601D6D5ED4492441CDCCCC1C9A375A41	930050701	H	Gros Saule 1	9300507	93005	93	11	0
01060000206A080000010000000103000000010000003600000000000000A6442441000000A0AE375A419A999999BA442441CDCCCCECB0375A419A999999D544244133333333B3375A41CDCCCCCCE644244166666626B4375A413333333302452441333333D3B4375A4133333333224524419A999919B5375A419A9999994845244166666646B5375A41CDCCCCCC4C45244166666646B5375A41CDCCCCCC6545244166666686B5375A41000000007B452441000000E0B5375A41000000009E452441333333F3B6375A4166666666EA45244166666646B9375A4133333333544624419A999979BC375A4133333333FA462441CDCCCC8CC1375A41333333331247244133333313C2375A41333333333547244100000040C2375A419A9999993947244166666606C2375A419A999999564724419A999999C0375A4166666666D2472441333333F3B8375A4133333333E147244133333333B8375A419A999999F247244100000020B7375A41CDCCCCCCFA472441000000C0B6375A416666666621482441333333D3B5375A41000000002A482441CDCCCC8CB5375A41CDCCCCCC37482441000000C0B4375A419A99999944482441333333B3B3375A41000000005148244166666646B2375A41CDCCCCCC59482441333333B3B0375A41666666665F48244133333313AF375A416666666669482441CDCCCCCCAB375A41666666667E48244100000000A4375A41333333338A482441000000C09F375A4133333333AA4824419A99997994375A41CDCCCCCCCC482441333333D386375A4166666666CB482441CDCCCC2C83375A41CDCCCCCCB7482441333333D383375A41000000004F482441000000C07F375A413333333342482441333333537F375A41666666662B482441333333337E375A41CDCCCCCC1E482441333333B37D375A4100000000024824419A9999797C375A4133333333E34724419A9999197B375A419A999999D8472441000000A07A375A419A99999983472441000000A076375A4133333333694724410000008075375A4133333333034724419A9999F970375A419A999999B6462441333333936D375A413333333379462441000000E069375A413333333317462441000000C078375A4100000000D344244100000020A8375A4166666666B54424419A9999F9AC375A419A999999AF4424419A999999AD375A4133333333A64424419A999999AE375A4100000000A6442441000000A0AE375A41	01060000206A080000010000000103000000010000001100000000000000A6442441000000A0AE375A41CDCCCCCCE644244166666626B4375A41000000007B452441000000E0B5375A4133333333FA462441CDCCCC8CC1375A41333333333547244100000040C2375A41CDCCCCCCFA472441000000C0B6375A41000000002A482441CDCCCC8CB5375A41CDCCCCCC59482441333333B3B0375A4133333333AA4824419A99997994375A41CDCCCCCCCC482441333333D386375A41CDCCCCCCB7482441333333D383375A41000000004F482441000000C07F375A419A999999B6462441333333936D375A413333333379462441000000E069375A413333333317462441000000C078375A4100000000A6442441000000A0AE375A4100000000A6442441000000A0AE375A41	01010000206A080000D136B18BE6462441CDCCCC1C9A375A41	930050702	H	Gros Saule 2	9300507	93005	93	11	0
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	01060000206A08000001000000010300000001000000200000003333333379462441000000E069375A419A999999B6462441333333936D375A41000000004F482441000000C07F375A41CDCCCCCCB7482441333333D383375A41CDCCCCCCDD482441CDCCCC6C80375A41000000000E4924419A9999D96E375A41CDCCCCCC22492441CDCCCCAC6C375A4166666666754A2441000000807A375A419A999999DF4A2441CDCCCC6C82375A4166666666054B2441CDCCCC0C7F375A4133333333684B2441666666866B375A4133333333DF4B24419A99997955375A4133333333FC4B24419A9999D951375A4133333333F34B2441CDCCCC8C4A375A41333333333E4B2441CDCCCC0C40375A419A999999B54A24419A9999193A375A41CDCCCCCC0B4A2441CDCCCCCC34375A41333333338D492441000000202A375A41000000002B492441333333D322375A4133333333A04824419A9999191A375A419A999999C6482441CDCCCC4C21375A4133333333CD4824416666666626375A4133333333C34824419A9999B92E375A419A999999924824419A9999B936375A419A999999634824419A9999B939375A41333333331F482441666666663A375A4133333333E2472441CDCCCC8C37375A41CDCCCCCCBB472441333333F332375A4133333333C14724419A9999193A375A4133333333A7472441000000C03E375A413333333379462441000000E069375A413333333379462441000000E069375A41	01010000206A080000261734B5934924419A9999E94E375A41	930050703	H	Gros Saule 3	9300507	93005	93	11	0
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	01060000206A0800000100000001030000000100000029000000CDCCCCCC21402441CDCCCC2C88375A419A9999992B4024419A9999B995375A416666666625402441000000609E375A419A9999994141244133333333A5375A41666666665F422441CDCCCC8CAB375A41CDCCCCCC5E43244133333353B2375A4133333333D143244100000020BA375A41CDCCCCCC1A4424419A999919B6375A41000000004B44244166666606B8375A41000000008344244100000060B3375A4100000000D344244100000020A8375A413333333317462441000000C078375A413333333379462441000000E069375A4133333333A7472441000000C03E375A4133333333C14724419A9999193A375A4166666666C3472441333333D335375A41333333338E4724419A99993925375A41333333333E472441666666061F375A41CDCCCCCCF3462441666666061B375A416666666677462441000000E011375A419A9999991A462441CDCCCC2C22375A41CDCCCCCC3D4524413333335346375A4166666666A5442441333333D345375A41666666665D4324416666668642375A41000000002D432441000000803F375A41000000001E4324416666666641375A4166666666AA422441000000A03F375A416666666638412441333333F308375A41666666664E4024410000008020375A4100000000FD4024413333335332375A4166666666404124419A9999B93A375A419A999999D34124419A99993951375A4166666666634124419A9999195B375A41CDCCCCCC40412441CDCCCC0C60375A41333333330F412441000000606B375A41CDCCCCCCEC402441CDCCCCEC67375A41CDCCCCCCC84024419A9999B96D375A41CDCCCCCC984024413333331370375A416666666639402441CDCCCC8C87375A41CDCCCCCC21402441CDCCCC2C88375A41CDCCCCCC21402441CDCCCC2C88375A41	01010000206A080000E6DA81B9F64324410000008061375A41	930050801	H	Ambourget 1	9300508	93005	93	11	0
01060000206A08000001000000010300000001000000220000006666666638412441333333F308375A419A999999AA4124419A9999D919375A41CDCCCCCCAB412441666666061A375A41CDCCCCCCFE4124413333335326375A419A9999992B422441666666E62C375A416666666634422441333333332E375A4166666666AA422441000000A03F375A4166666666B04224410000004040375A41CDCCCCCCB64224419A99997940375A4133333333C0422441CDCCCC8C40375A41000000001E4324416666666641375A41000000002D432441000000803F375A41CDCCCCCC37432441333333D340375A419A9999993C4324413333335341375A4133333333494324413333331342375A4133333333504324413333335342375A41666666665D4324416666668642375A41CDCCCCCCA8432441CDCCCC4C43375A4133333333E8432441333333F343375A419A999999724424419A99995945375A4166666666834424416666668645375A4133333333C4442441CDCCCC4C3A375A419A999999364524419A99997926375A41CDCCCCCC85442441333333D324375A4100000000784424419A9999B924375A419A999999DD432441CDCCCC4C23375A41000000003A432441666666E621375A41CDCCCCCC6D422441CDCCCC2C20375A41333333335B4224410000000020375A413333333349422441CDCCCC6C1F375A416666666685412441000000E004375A41000000007E412441000000C002375A41333333336B4124416666664604375A416666666638412441333333F308375A41	01060000206A080000010000000103000000010000000D0000006666666638412441333333F308375A4166666666AA422441000000A03F375A41000000001E4324416666666641375A41000000002D432441000000803F375A41666666665D4324416666668642375A4166666666834424416666668645375A419A999999364524419A99997926375A41333333335B4224410000000020375A413333333349422441CDCCCC6C1F375A416666666685412441000000E004375A41000000007E412441000000C002375A416666666638412441333333F308375A416666666638412441333333F308375A41	01010000206A08000015D166FF0C4324413433330324375A41	930050802	H	Ambourget 2	9300508	93005	93	11	0
01060000206A080000010000000103000000010000002F00000066666666B24224416666664616375A4166666666D34224413333339316375A419A99999903432441333333F316375A4166666666D24324419A9999F918375A419A999999E34324419A99993919375A419A999999DD432441CDCCCC4C23375A4100000000784424419A9999B924375A41CDCCCCCC85442441333333D324375A419A999999364524419A99997926375A4133333333C4442441CDCCCC4C3A375A4166666666834424416666668645375A4166666666A5442441333333D345375A41CDCCCCCC3D4524413333335346375A4166666666CD452441333333F32E375A4133333333F14524416666660629375A419A9999991A462441CDCCCC2C22375A416666666677462441000000E011375A416666666667462441000000E010375A41666666663B462441333333530D375A41333333331C462441000000200A375A4166666666044624410000002008375A41CDCCCCCCCA4524416666668602375A4100000000AC4524419A999919FF365A413333333381452441333333F3F9365A413333333349452441333333D3F2365A41CDCCCCCC1B452441CDCCCCACEC365A41CDCCCCCCCE442441CDCCCCCCE2365A41CDCCCCCC684424419A999959D4365A41000000002344244100000040CB365A41CDCCCCCC12442441000000C0CD365A419A9999991044244133333313CF365A41000000000E44244100000080D3365A4100000000084424419A999939DC365A419A99999902442441CDCCCC0CE4365A4166666666FE432441CDCCCC6CEC365A4133333333F943244100000020F6365A4133333333F6432441333333F3FA365A4133333333F34324410000000000375A4166666666EE4324419A9999D907375A41CDCCCCCC9E4324410000002007375A419A9999997D432441333333F306375A4166666666F3422441CDCCCCAC05375A4166666666DC4224413333335305375A41CDCCCCCCBA4224410000000005375A4100000000B7422441CDCCCC4C0A375A4166666666B44224416666666611375A4166666666B24224416666664616375A41	01060000206A080000010000000103000000010000001300000066666666B24224416666664616375A419A999999E34324419A99993919375A419A999999DD432441CDCCCC4C23375A419A999999364524419A99997926375A4166666666834424416666668645375A41CDCCCCCC3D4524413333335346375A419A9999991A462441CDCCCC2C22375A416666666677462441000000E011375A41666666663B462441333333530D375A41CDCCCCCCCA4524416666668602375A413333333381452441333333F3F9365A41CDCCCCCCCE442441CDCCCCCCE2365A41000000002344244100000040CB365A41CDCCCCCC12442441000000C0CD365A419A99999902442441CDCCCC0CE4365A4166666666EE4324419A9999D907375A41CDCCCCCCBA4224410000000005375A4166666666B24224416666664616375A4166666666B24224416666664616375A41	01010000206A080000F3E43B12644424410000002009375A41	930050803	H	Ambourget 3	9300508	93005	93	11	0
01060000206A0800000100000001030000000100000025000000CDCCCCCCD340244166666666E6365A41000000007C41244100000000FF365A41666666667E412441CDCCCC2C00375A41000000007E412441000000C002375A416666666685412441000000E004375A413333333349422441CDCCCC6C1F375A41333333335B4224410000000020375A41CDCCCCCC6D422441CDCCCC2C20375A41000000003A432441666666E621375A419A999999DD432441CDCCCC4C23375A419A999999E34324419A99993919375A4166666666D24324419A9999F918375A419A99999903432441333333F316375A4166666666D34224413333339316375A4166666666B24224416666664616375A4166666666B44224416666666611375A4100000000B7422441CDCCCC4C0A375A41CDCCCCCCBA4224410000000005375A4166666666DC4224413333335305375A4166666666F3422441CDCCCCAC05375A419A9999997D432441333333F306375A41CDCCCCCC9E4324410000002007375A4133333333A0432441CDCCCC2C02375A419A999999A2432441000000C0FE365A41CDCCCCCC36432441666666C6FD365A41CDCCCCCC2D432441666666A6FD365A41666666660743244133333313FD365A419A9999990A43244166666606F9365A4166666666174324419A999959E3365A41CDCCCCCC19432441CDCCCC4CDF365A416666666620432441000000E0D3365A4133333333C1422441000000A0D2365A4100000000C742244166666646C5365A4133333333AA42244133333313C4365A4100000000684224419A999959C1365A41000000004342244133333353C0365A41CDCCCCCCD340244166666666E6365A41	01060000206A0800000100000001030000000100000012000000CDCCCCCCD340244166666666E6365A41000000007C41244100000000FF365A416666666685412441000000E004375A413333333349422441CDCCCC6C1F375A41333333335B4224410000000020375A419A999999DD432441CDCCCC4C23375A419A999999E34324419A99993919375A4166666666B24224416666664616375A41CDCCCCCCBA4224410000000005375A41CDCCCCCC9E4324410000002007375A419A999999A2432441000000C0FE365A41666666660743244133333313FD365A416666666620432441000000E0D3365A4133333333C1422441000000A0D2365A4100000000C742244166666646C5365A41000000004342244133333353C0365A41CDCCCCCCD340244166666666E6365A41CDCCCCCCD340244166666666E6365A41	01010000206A0800005E174EC911422441666666B6EF365A41	930050804	H	Ambourget 4	9300508	93005	93	11	0
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	01060000206A0800000100000001030000000100000038000000CDCCCCCCF24124419A9999D9B3365A41000000004342244133333353C0365A4100000000C742244166666646C5365A4133333333C1422441000000A0D2365A416666666620432441000000E0D3365A41666666660743244133333313FD365A419A999999A2432441000000C0FE365A41CDCCCCCC9E4324410000002007375A4166666666EE4324419A9999D907375A419A99999902442441CDCCCC0CE4365A41CDCCCCCC12442441000000C0CD365A41000000002344244100000040CB365A41CDCCCCCCCE442441CDCCCCCCE2365A413333333381452441333333F3F9365A41CDCCCCCCCA4524416666668602375A41666666663B462441333333530D375A41CDCCCCCCF3462441666666061B375A41333333333E472441666666061F375A41333333338E4724419A99993925375A41CDCCCCCCBB472441333333F332375A4133333333E2472441CDCCCC8C37375A41333333331F482441666666663A375A419A999999634824419A9999B939375A419A999999924824419A9999B936375A4133333333C34824419A9999B92E375A4133333333CD4824416666666626375A419A999999C6482441CDCCCC4C21375A4133333333A04824419A9999191A375A4100000000A74824416666666618375A41666666665F4824416666662612375A419A9999996B482441333333F308375A41CDCCCCCC8B48244133333393FA365A41666666665E48244100000040F0365A41666666668248244100000000E9365A41CDCCCCCC624724419A999959DD365A416666666685472441333333B3D5365A419A999999594724419A999979CF365A41000000004D47244166666666CB365A416666666615472441000000E0C6365A41CDCCCCCCE4462441CDCCCC8CC0365A419A99999949462441000000E0AF365A41CDCCCCCC9845244100000040A4365A4166666666EA442441CDCCCC4C88365A41333333334E4424413333335372365A41666666661F442441CDCCCC8C69365A419A999999D34324413333331357365A416666666686432441000000205C365A41666666661E4324413333339343365A419A999999C84224419A9999794A365A4100000000D1422441666666E650365A419A999999A84224419A99997973365A416666666689422441000000008B365A41666666668B422441000000A094365A41000000002B4224419A9999199E365A41CDCCCCCCF24124419A9999D9B3365A41CDCCCCCCF24124419A9999D9B3365A41	01010000206A080000EC39A585774424419A9999C9BC365A41	930050805	H	Ambourget 5	9300508	93005	93	11	0
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	01060000206A080000010000000103000000010000001D0000009A9999999A34244100000000C5355A413333333310352441000000A0EB355A419A9999991435244133333393EF355A419A999999843524419A9999D90A365A419A999999C33524410000004008365A41666666663C3624410000000006365A41666666665B3624413333337319365A4133333333A93924416666664605365A41CDCCCCCCCE3924410000004003365A4166666666D539244100000040FF355A41666666669D3A24419A9999B9E0355A419A9999999E3A244133333313D3355A4133333333883A2441000000C0B9355A4166666666A13A244133333393AD355A419A999999F93924410000004097355A410000000096392441333333938E355A4133333333213924413333337382355A41CDCCCCCCC23824419A9999F976355A41CDCCCCCC79382441CDCCCC0C71355A4133333333FA3724416666660669355A419A999999C63724413333333377355A4133333333C4372441CDCCCCCCB8355A41CDCCCCCC933724419A999939BA355A410000000037372441000000E0B9355A4100000000C0362441000000E0B5355A41666666667936244166666626B7355A4166666666493524419A999999C3355A419A9999999A34244100000000C5355A419A9999999A34244100000000C5355A41	01010000206A0800006F1BB8DF04382441CDCCCCECC1355A41	930050901	H	Anatole France 1	9300509	93005	93	11	0
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	01060000206A080000010000000103000000010000002E0000009A99999908342441666666467D355A416666666621342441CDCCCCAC8C355A4166666666EB342441CDCCCCCC8A355A419A9999992E352441333333B39C355A419A9999998C3524419A999919C1355A419A999999D13524419A9999B9BD355A41666666667936244166666626B7355A4100000000C0362441000000E0B5355A410000000037372441000000E0B9355A41CDCCCCCC933724419A999939BA355A4133333333C4372441CDCCCCCCB8355A419A999999C63724413333333377355A4133333333FA3724416666660669355A41CDCCCCCC79382441CDCCCC0C71355A41CDCCCCCCC23824419A9999F976355A4133333333213924413333337382355A410000000096392441333333938E355A419A999999F93924410000004097355A4166666666A13A244133333393AD355A4133333333883A2441000000C0B9355A419A9999999E3A244133333313D3355A41666666669D3A24419A9999B9E0355A4166666666D539244100000040FF355A41CDCCCCCCCE3924410000004003365A4166666666F63924413333331303365A41000000009D3A24419A999999FB355A419A999999033B244100000040F5355A4133333333B73B244100000080E6355A4166666666873C2441CDCCCCACD4355A419A999999FC3C244133333333D5355A419A9999995F3C2441CDCCCCECB7355A419A999999213C244166666626AD355A41CDCCCCCCA73B24419A9999599E355A4166666666F53A2441333333D389355A41333333331C3B2441CDCCCC2C84355A4133333333513B2441000000C077355A41CDCCCCCCBC3B2441666666E656355A4133333333443A2441666666A655355A413333333359382441CDCCCC8C55355A419A999999E7362441CDCCCCEC56355A419A999999FA3424419A99997959355A410000000076342441CDCCCCAC59355A41CDCCCCCC32342441666666E663355A419A999999263424419A99997968355A419A99999908342441666666467D355A419A99999908342441666666467D355A41	01010000206A0800005620C2028C36244100000000AB355A41	930050902	H	Anatole France 2	9300509	93005	93	11	0
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	01060000206A080000010000000103000000010000002300000066666666F53A2441333333D389355A41CDCCCCCCA73B24419A9999599E355A419A999999213C244166666626AD355A419A9999995F3C2441CDCCCCECB7355A419A999999FC3C244133333333D5355A4133333333443D244100000060D7355A41CDCCCCCC253E2441333333B3E8355A4133333333B33E2441666666E6EE355A4166666666F23E24419A999919F3355A41CDCCCCCC383F2441CDCCCC4CFD355A41CDCCCCCC433F2441000000C0FB355A416666666669402441333333D3B0355A419A99999966402441CDCCCC4C9F355A413333333375412441CDCCCC2C8A355A41666666668D4124416666664699355A4133333333CD4124419A9999D98E355A4100000000FC412441333333538B355A4100000000D6422441000000C086355A4166666666E04224419A99999985355A419A999999AD4324410000002080355A413333333371442441CDCCCC0C77355A4100000000794424416666668674355A419A9999994C4424419A9999D959355A4100000000AD4424416666666653355A4133333333BB4324419A99999956355A4166666666094324410000002057355A419A999999D64024416666666655355A41CDCCCCCC623F2441CDCCCCAC56355A41CDCCCCCC673D2441CDCCCCAC57355A41333333338B3C24416666668657355A41CDCCCCCCBC3B2441666666E656355A4133333333513B2441000000C077355A41333333331C3B2441CDCCCC2C84355A4166666666F53A2441333333D389355A4166666666F53A2441333333D389355A41	01010000206A0800000C379453203E244134333313A4355A41	930050903	H	Anatole France 3	9300509	93005	93	11	0
01060000206A080000010000000103000000010000003200000033333333410D24419A999959662D5A4166666666A80D24419A999939552D5A4133333333BA0D244166666606532D5A419A999999C10D244100000080512D5A41CDCCCCCCCC0D24419A9999B9532D5A419A999999DC0D24419A999959562D5A41CDCCCCCC200E2441666666E65E2D5A419A999999480E2441333333F3632D5A419A999999710E244100000020692D5A4166666666840E24419A9999996A2D5A41CDCCCCCC930E2441333333B36B2D5A4166666666230F2441666666A6742D5A4100000000260F2441CDCCCCCC742D5A41CDCCCCCC3A0F24419A999919762D5A41000000007F0F2441333333737A2D5A41000000008A0F2441CDCCCC2C7B2D5A419A9999999B0F2441CDCCCC4C762D5A4166666666A20F244166666626742D5A419A999999A20F24419A999939732D5A4166666666A20F2441CDCCCC4C722D5A419A999999970F244166666626702D5A41CDCCCCCC8C0F2441333333536D2D5A41333333338A0F2441000000E06B2D5A419A9999999B0F24419A9999F9632D5A41333333334F0F2441000000C0602D5A419A999999B10E2441333333135A2D5A4133333333D90E24419A9999B94B2D5A4133333333DA0E2441000000604B2D5A4133333333010F2441CDCCCC2C3D2D5A4100000000E90F2441333333D3462D5A41CDCCCCCC3210244133333353492D5A419A999999DB102441CDCCCC6C502D5A41000000002D112441000000E0532D5A419A9999996A112441666666A6382D5A41CDCCCCCCA41024419A999999302D5A4166666666460F2441000000A0222D5A4100000000F40E2441000000C01F2D5A4133333333D30E2441CDCCCC2C1E2D5A419A999999A80E2441000000601B2D5A4100000000710E2441CDCCCC4C172D5A4133333333910D244100000040042D5A419A9999997A0D2441000000801F2D5A41000000007A0D2441CDCCCC4C202D5A41CDCCCCCC620D2441000000803E2D5A419A999999570D2441333333D34B2D5A419A9999994B0D24419A9999D9592D5A4133333333480D2441333333735D2D5A4166666666460D2441CDCCCC0C602D5A419A999999420D2441000000C0642D5A4133333333410D24419A999959662D5A41	01060000206A080000010000000103000000010000001600000033333333410D24419A999959662D5A419A999999C10D244100000080512D5A419A999999DC0D24419A999959562D5A419A999999710E244100000020692D5A41CDCCCCCC930E2441333333B36B2D5A41000000008A0F2441CDCCCC2C7B2D5A4166666666A20F244166666626742D5A41333333338A0F2441000000E06B2D5A419A9999999B0F24419A9999F9632D5A419A999999B10E2441333333135A2D5A4133333333010F2441CDCCCC2C3D2D5A4100000000E90F2441333333D3462D5A41CDCCCCCC3210244133333353492D5A41000000002D112441000000E0532D5A419A9999996A112441666666A6382D5A41CDCCCCCCA41024419A999999302D5A4133333333D30E2441CDCCCC2C1E2D5A4100000000710E2441CDCCCC4C172D5A4133333333910D244100000040042D5A41CDCCCCCC620D2441000000803E2D5A4133333333410D24419A999959662D5A4133333333410D24419A999959662D5A41	01010000206A080000F393C67A6C1024419A9999A9422D5A41	930060110	H	Iris 10	9300601	93006	93	11	0
01060000206A080000010000000103000000010000001F0000009A999999B10E2441333333135A2D5A41333333334F0F2441000000C0602D5A419A9999999B0F24419A9999F9632D5A41333333338A0F2441000000E06B2D5A41CDCCCCCC8C0F2441333333536D2D5A419A999999970F244166666626702D5A4166666666A20F2441CDCCCC4C722D5A419A999999A20F24419A999939732D5A4166666666A20F244166666626742D5A419A9999999B0F2441CDCCCC4C762D5A41000000008A0F2441CDCCCC2C7B2D5A41666666669F102441333333738C2D5A41666666668A102441000000E0942D5A4100000000441124419A9999198C2D5A419A999999FF1124419A999939832D5A41CDCCCCCC141224419A999939822D5A413333333345122441333333B37F2D5A41CDCCCCCC411224419A9999D9592D5A41000000004112244166666626562D5A41000000003C122441000000E03D2D5A416666666617122441333333F33C2D5A4166666666BC1124419A9999D93A2D5A419A9999996A112441666666A6382D5A41000000002D112441000000E0532D5A419A999999DB102441CDCCCC6C502D5A41CDCCCCCC3210244133333353492D5A4100000000E90F2441333333D3462D5A4133333333010F2441CDCCCC2C3D2D5A4133333333DA0E2441000000604B2D5A4133333333D90E24419A9999B94B2D5A419A999999B10E2441333333135A2D5A41	01060000206A08000001000000010300000001000000110000009A999999B10E2441333333135A2D5A419A9999999B0F24419A9999F9632D5A41333333338A0F2441000000E06B2D5A4166666666A20F244166666626742D5A41000000008A0F2441CDCCCC2C7B2D5A41666666669F102441333333738C2D5A41666666668A102441000000E0942D5A413333333345122441333333B37F2D5A41CDCCCCCC411224419A9999D9592D5A41000000003C122441000000E03D2D5A419A9999996A112441666666A6382D5A41000000002D112441000000E0532D5A41CDCCCCCC3210244133333353492D5A4100000000E90F2441333333D3462D5A4133333333010F2441CDCCCC2C3D2D5A419A999999B10E2441333333135A2D5A419A999999B10E2441333333135A2D5A41	01010000206A0800009F426FFBEA102441CDCCCCEC672D5A41	930060111	H	Iris 11	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001D0000009A9999995A1124419A999919EA2E5A41CDCCCCCC86112441666666C6002F5A4133333333A6112441333333B30C2F5A41666666662B12244133333313262F5A419A999999791224419A9999F92E2F5A4133333333E0122441CDCCCCAC362F5A41CDCCCCCC9612244133333393432F5A41CDCCCCCC3F122441000000604B2F5A4100000000161224419A9999396B2F5A419A999999DF1124419A999939862F5A4133333333AC132441000000A0852F5A413333333361142441333333B3832F5A413333333387142441000000A0822F5A41333333331615244166666666822F5A419A99999981152441CDCCCC2C832F5A410000000004162441CDCCCCAC852F5A419A999999ED15244100000060792F5A410000000090152441333333734B2F5A41CDCCCCCC441524419A9999D9272F5A416666666611152441000000E0182F5A419A999999C914244100000080062F5A41CDCCCCCC96142441333333F3092F5A4166666666801324419A999919222F5A41333333334B132441000000A0042F5A419A9999990313244133333333D82E5A416666666640122441333333F3DF2E5A4100000000AD112441333333F3E62E5A419A9999995A1124419A999919EA2E5A419A9999995A1124419A999919EA2E5A41	01010000206A080000F07DDBECEA132441343333832F2F5A41	930060101	H	Iris 1	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001E00000066666666F30C2441333333F3EB2D5A4166666666150D2441000000A0E72D5A4166666666190E2441CDCCCC8CCA2D5A41CDCCCCCC500E24419A999919E72D5A41CDCCCCCC680E244166666666ED2D5A419A999999A20E2441CDCCCCEC012E5A4166666666C90E2441CDCCCC4C082E5A419A999999D90E2441000000E00F2E5A41000000001F0F244133333393112E5A41CDCCCCCC7D0F24419A9999D90B2E5A419A9999999B0F2441666666C6EC2D5A419A999999D20F244100000060D72D5A4100000000F80F244133333373CB2D5A41CDCCCCCCCF102441CDCCCC0CD22D5A41CDCCCCCCD710244166666666CE2D5A419A999999E2102441CDCCCC2CB82D5A41CDCCCCCCEE10244133333333AC2D5A4100000000441124419A9999198C2D5A41666666668A102441000000E0942D5A41666666669F102441333333738C2D5A41CDCCCCCC930E2441333333B36B2D5A419A999999710E244100000020692D5A419A999999DC0D24419A999959562D5A419A999999C10D244100000080512D5A4133333333410D24419A999959662D5A41666666661A0D244166666626912D5A41CDCCCCCC130D24419A9999799C2D5A41CDCCCCCC060D2441666666C6C42D5A4166666666F30C2441333333F3EB2D5A4166666666F30C2441333333F3EB2D5A41	01010000206A0800009D73CE29F90E244134333343B42D5A41	930060102	H	Iris 2	9300601	93006	93	11	0
01060000206A0800000100000001030000000100000034000000666666661D0F24419A9999F9112E5A41000000001E0F2441333333D3132E5A4100000000200F244133333373162E5A41CDCCCCCC210F2441666666A6172E5A41CDCCCCCC2D0F24419A9999191D2E5A41000000004B0F2441333333331D2E5A4166666666880F2441666666261D2E5A419A999999BC0F2441333333731D2E5A419A999999D90F2441666666E61D2E5A410000000007102441333333F31E2E5A419A9999994C102441CDCCCC4C202E5A41666666666F102441000000C0212E5A41666666668010244133333373222E5A41000000008410244100000080222E5A419A999999991024419A999939112E5A4100000000AB1024419A999999082E5A4100000000B8102441000000A0032E5A4166666666BB102441000000E0022E5A4133333333BC1024419A9999B9FF2D5A419A999999BC102441CDCCCC2CF92D5A419A999999F810244166666606EE2D5A41000000000A1124419A999959EC2D5A41CDCCCCCC1E1124419A999979EA2D5A41CDCCCCCC32112441000000A0E92D5A41CDCCCCCC5511244100000060E92D5A419A9999996C11244133333313EA2D5A41333333337111244100000080E82D5A41CDCCCCCC8B11244166666606DA2D5A419A999999A111244100000040D22D5A41333333337C112441CDCCCCECD12D5A41CDCCCCCC69112441CDCCCC2CD22D5A413333333359112441CDCCCCACD22D5A41000000002111244133333353D42D5A416666666610112441CDCCCCACD32D5A41CDCCCCCCCF102441CDCCCC0CD22D5A41666666664D102441CDCCCC0CCE2D5A4100000000F80F244133333373CB2D5A41CDCCCCCCE30F2441000000E0D12D5A41CDCCCCCCDB0F2441CDCCCC6CD42D5A419A999999D20F244100000060D72D5A419A9999999B0F2441666666C6EC2D5A41333333338D0F2441666666A6FD2D5A419A999999820F2441333333F3062E5A41CDCCCCCC7D0F2441000000000A2E5A41CDCCCCCC7D0F24419A9999D90B2E5A4166666666760F2441333333D30C2E5A4100000000650F2441000000C00D2E5A419A9999994B0F2441000000E00E2E5A4100000000380F24419A9999B90F2E5A419A999999220F2441666666C6102E5A41000000001F0F244133333393112E5A41666666661D0F24419A9999F9112E5A41	01060000206A0800000100000001030000000100000015000000666666661D0F24419A9999F9112E5A41CDCCCCCC2D0F24419A9999191D2E5A419A999999BC0F2441333333731D2E5A419A9999994C102441CDCCCC4C202E5A41000000008410244100000080222E5A419A999999991024419A999939112E5A4166666666BB102441000000E0022E5A419A999999BC102441CDCCCC2CF92D5A419A999999F810244166666606EE2D5A41CDCCCCCC1E1124419A999979EA2D5A419A9999996C11244133333313EA2D5A41CDCCCCCC8B11244166666606DA2D5A419A999999A111244100000040D22D5A41CDCCCCCC69112441CDCCCC2CD22D5A41000000002111244133333353D42D5A4100000000F80F244133333373CB2D5A419A999999D20F244100000060D72D5A419A9999999B0F2441666666C6EC2D5A41CDCCCCCC7D0F24419A9999D90B2E5A41666666661D0F24419A9999F9112E5A41666666661D0F24419A9999F9112E5A41	01010000206A0800009AC42030381024419A999999F32D5A41	930060103	H	Iris 3	9300601	93006	93	11	0
01060000206A080000010000000103000000010000002C000000333333335E132441CDCCCC0C212E5A41CDCCCCCC7513244133333313222E5A4100000000A2132441000000A0232E5A4100000000C7132441CDCCCC6C252E5A41CDCCCCCCF713244100000080282E5A41333333330114244166666646292E5A419A9999991F142441666666462B2E5A410000000036142441CDCCCC0C2D2E5A41666666667914244133333333332E5A41CDCCCCCC9F142441CDCCCC4C362E5A4100000000B114244133333373372E5A41CDCCCCCCBA14244100000080382E5A4166666666D01424419A9999593A2E5A4133333333D614244133333313392E5A41CDCCCCCCDD14244100000000362E5A4133333333F814244100000040212E5A419A999999F914244166666646202E5A4166666666FA142441000000401F2E5A41CDCCCCCC0315244100000080152E5A419A99999918152441CDCCCC2C092E5A41333333332B15244133333313FF2D5A41333333333B152441CDCCCC4CF52D5A419A9999993D152441666666C6F32D5A419A9999993E152441CDCCCC2CF32D5A419A9999994A152441666666E6EB2D5A4133333333391524419A999979EB2D5A410000000005152441CDCCCC2CEA2D5A4100000000D81424419A9999D9E82D5A4100000000FB13244100000000E12D5A4166666666E9132441000000E0E02D5A41CDCCCCCCE313244166666626E12D5A419A999999DE13244166666666E12D5A4133333333D9132441000000E0E12D5A4100000000D41324419A999979E22D5A41CDCCCCCCCF13244100000040E32D5A4133333333C91324419A9999D9E52D5A4100000000BE13244133333393ED2D5A41666666668B132441000000A00A2E5A419A99999986132441333333F30C2E5A413333333382132441000000200F2E5A419A9999997E1324419A9999D9102E5A4133333333651324419A9999391D2E5A413333333361132441000000601F2E5A41333333335E132441CDCCCC0C212E5A41	01060000206A080000010000000103000000010000000D000000333333335E132441CDCCCC0C212E5A4100000000A2132441000000A0232E5A410000000036142441CDCCCC0C2D2E5A4166666666D01424419A9999593A2E5A41CDCCCCCCDD14244100000000362E5A41CDCCCCCC0315244100000080152E5A419A9999994A152441666666E6EB2D5A4100000000D81424419A9999D9E82D5A4100000000FB13244100000000E12D5A41CDCCCCCCCF13244100000040E32D5A41666666668B132441000000A00A2E5A41333333335E132441CDCCCC0C212E5A41333333335E132441CDCCCC0C212E5A41	01010000206A0800001A009F654A1424419A9999090E2E5A41	930060104	H	Iris 4	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001C00000000000000DD0C24419A9999790D2E5A41CDCCCCCCE80C2441666666C63E2E5A4100000000E30C2441333333535B2E5A4133333333E50C2441CDCCCCAC8A2E5A4133333333E20C244100000080932E5A41000000009B0D2441CDCCCC2C7D2E5A41CDCCCCCC760D2441CDCCCCCC762E5A4166666666140E244166666686672E5A41333333335E0E244166666646612E5A419A999999A10E24419A9999995D2E5A4100000000350F24419A999999572E5A41CDCCCCCC520F244100000020552E5A41000000003A0F2441666666664A2E5A41CDCCCCCCFF0E2441666666A6352E5A4100000000F30E2441666666262A2E5A419A999999450F24419A9999D9272E5A41CDCCCCCC210F2441666666A6172E5A41000000001F0F244133333393112E5A419A999999D90E2441000000E00F2E5A4166666666C90E2441CDCCCC4C082E5A419A999999A20E2441CDCCCCEC012E5A41CDCCCCCC680E244166666666ED2D5A41CDCCCCCC500E24419A999919E72D5A4166666666190E2441CDCCCC8CCA2D5A4166666666150D2441000000A0E72D5A4166666666F30C2441333333F3EB2D5A4100000000DD0C24419A9999790D2E5A4100000000DD0C24419A9999790D2E5A41	01010000206A080000008F7DF4F00D2441333333F32E2E5A41	930060109	A	Iris 9	9300601	93006	93	11	0
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	01010000206A0800004077E2E8011224419A999929172E5A41	930060105	H	Iris 5	9300601	93006	93	11	0
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	01060000206A0800000100000001030000000100000019000000CDCCCCCC020E2441000000602D2F5A419A999999A30E2441333333933C2F5A41CDCCCCCC391024419A9999396C2F5A41CDCCCCCC9210244133333313772F5A4166666666E4102441666666867D2F5A41CDCCCCCC8111244133333353852F5A419A999999DF11244133333333862F5A4100000000161224419A9999396B2F5A41CDCCCCCC3F122441000000604B2F5A41CDCCCCCC9612244133333393432F5A4133333333E0122441CDCCCCAC362F5A419A999999791224419A9999F92E2F5A41666666662B12244133333313262F5A4133333333A6112441333333B30C2F5A41CDCCCCCC86112441666666C6002F5A416666666649112441000000C0E12E5A41333333330111244100000060E62E5A419A99999994102441666666C6EE2E5A410000000050102441CDCCCC6CF62E5A41CDCCCCCC5910244166666626F82E5A419A99999937102441CDCCCC6CFE2E5A4133333333900F24419A9999990D2F5A41CDCCCCCCA40E2441000000601E2F5A41CDCCCCCC020E2441000000602D2F5A41CDCCCCCC020E2441000000602D2F5A41	01010000206A080000664379AD74102441343333D3322F5A41	930060106	H	Iris 6	9300601	93006	93	11	0
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	01060000206A08000001000000010300000001000000160000009A9999999E0C2441333333D3F72E5A4166666666BE0D244100000080232F5A41CDCCCCCC020E2441000000602D2F5A41CDCCCCCCA40E2441000000601E2F5A4133333333900F24419A9999990D2F5A419A99999937102441CDCCCC6CFE2E5A41CDCCCCCC5910244166666626F82E5A410000000050102441CDCCCC6CF62E5A419A99999994102441666666C6EE2E5A41333333330111244100000060E62E5A416666666649112441000000C0E12E5A419A9999992F112441666666C6D42E5A41666666661011244133333353CA2E5A419A999999D610244100000040BC2E5A416666666673102441333333D3C22E5A413333333383102441CDCCCCACC62E5A419A999999B80F2441333333D3DB2E5A4166666666EB0E24419A999959B72E5A419A999999CF0D2441000000A0C92E5A4100000000BD0C244166666646E42E5A419A9999999E0C2441333333D3F72E5A419A9999999E0C2441333333D3F72E5A41	01010000206A08000041EA211F960E24419A9999C9F02E5A41	930060107	H	Iris 7	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001600000066666666BD0C244133333353E32E5A4133333333080D2441CDCCCCCCDC2E5A419A999999CF0D2441000000A0C92E5A4166666666EB0E24419A999959B72E5A419A999999B80F2441333333D3DB2E5A413333333383102441CDCCCCACC62E5A416666666673102441333333D3C22E5A419A999999D610244100000040BC2E5A41333333334B10244133333313982E5A41CDCCCCCCE10F2441666666867E2E5A4166666666860F244166666686622E5A41CDCCCCCC520F244100000020552E5A4100000000350F24419A999999572E5A419A999999A10E24419A9999995D2E5A41333333335E0E244166666646612E5A4166666666140E244166666686672E5A41CDCCCCCC760D2441CDCCCCCC762E5A41000000009B0D2441CDCCCC2C7D2E5A4133333333E20C244100000080932E5A4166666666C60C2441CDCCCCCCCB2E5A4166666666BD0C244133333353E32E5A4166666666BD0C244133333353E32E5A41	01010000206A08000054584F61990E2441333333739A2E5A41	930060108	H	Iris 8	9300601	93006	93	11	0
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	01060000206A08000001000000010300000001000000180000009A999999681024419A9999D99F2E5A41666666661011244133333353CA2E5A419A9999992F112441666666C6D42E5A419A9999995A1124419A999919EA2E5A4100000000AD112441333333F3E62E5A416666666640122441333333F3DF2E5A419A9999990313244133333333D82E5A41CDCCCCCCB312244133333393B72E5A41CDCCCCCC5D13244100000000B02E5A419A999999F4132441CDCCCC0CAF2E5A4133333333DC132441000000E07B2E5A4166666666421424419A9999B9782E5A419A9999991B142441333333135C2E5A41CDCCCCCCFC1324419A9999195A2E5A4100000000F9122441333333B35E2E5A419A9999991513244166666686802E5A413333333344122441666666E6852E5A41CDCCCCCC8A112441CDCCCC8C912E5A41CDCCCCCC4B112441333333F3962E5A41000000002A112441000000209C2E5A41CDCCCCCCFB102441CDCCCC8C9F2E5A41666666669F102441666666069E2E5A419A999999681024419A9999D99F2E5A419A999999681024419A9999D99F2E5A41	01010000206A080000AEFA7BF92F122441343333C3A12E5A41	930060112	H	Iris 12	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001C00000033333333D01324419A999939AF2E5A4100000000D4132441CDCCCCACBA2E5A4100000000F7132441666666A6BB2E5A419A999999F7132441CDCCCC0CBF2E5A41CDCCCCCC59142441CDCCCC0CBD2E5A4166666666A114244166666686BD2E5A41CDCCCCCCC1142441333333B3C12E5A41666666662715244100000060C12E5A41CDCCCCCC45152441CDCCCC8CC22E5A41CDCCCCCCB81524419A9999F9C12E5A41CDCCCCCCA215244166666666BB2E5A419A999999951524419A999979A72E5A419A9999999715244166666646A02E5A41CDCCCCCCDC152441333333939B2E5A4133333333ED152441000000C0962E5A41CDCCCCCC11162441CDCCCC4C922E5A41CDCCCCCC5B15244133333353752E5A41CDCCCCCC5815244166666646702E5A416666666619152441CDCCCC8C662E5A4100000000971424419A9999D9562E5A41CDCCCCCC63142441CDCCCCCC582E5A41CDCCCCCC3E142441666666A6572E5A419A9999991B142441333333135C2E5A4166666666421424419A9999B9782E5A4133333333DC132441000000E07B2E5A419A999999F4132441CDCCCC0CAF2E5A4133333333D01324419A999939AF2E5A4133333333D01324419A999939AF2E5A41	01010000206A080000779BE003E9142441000000908C2E5A41	930060113	H	Iris 13	9300601	93006	93	11	0
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	01060000206A080000010000000103000000010000001F000000CDCCCCCCB312244133333393B72E5A410000000015132441000000A0DF2E5A41333333334B132441000000A0042F5A4166666666801324419A999919222F5A41CDCCCCCC96142441333333F3092F5A41CDCCCCCC5D15244166666626FE2E5A41CDCCCCCC8515244133333313F82E5A41666666660C16244166666686DC2E5A41CDCCCCCC0D162441333333D3D92E5A410000000053162441CDCCCCECC92E5A4166666666A21624419A999999BA2E5A41333333335E162441CDCCCCECB22E5A416666666664162441CDCCCCACA42E5A4100000000F4152441CDCCCCAC952E5A41CDCCCCCCDC152441333333939B2E5A419A9999999715244166666646A02E5A419A999999951524419A999979A72E5A41CDCCCCCCA215244166666666BB2E5A41CDCCCCCCB81524419A9999F9C12E5A41CDCCCCCC45152441CDCCCC8CC22E5A41666666662715244100000060C12E5A41CDCCCCCCC1142441333333B3C12E5A4166666666A114244166666686BD2E5A41CDCCCCCC59142441CDCCCC0CBD2E5A419A999999F7132441CDCCCC0CBF2E5A4100000000F7132441666666A6BB2E5A4100000000D4132441CDCCCCACBA2E5A4133333333D01324419A999939AF2E5A41CDCCCCCC5D13244100000000B02E5A41CDCCCCCCB312244133333393B72E5A41CDCCCCCCB312244133333393B72E5A41	01010000206A0800000AD4FAD58B142441CCCCCC2CDB2E5A41	930060114	H	Iris 14	9300601	93006	93	11	0
01060000206A080000010000000103000000010000002E0000009A999999C914244100000080062F5A4133333333F31424419A999979112F5A4166666666FB1424419A999959132F5A416666666611152441000000E0182F5A4166666666181524419A9999D91A2F5A419A99999929152441333333B31F2F5A41CDCCCCCC3A152441666666C6242F5A41CDCCCCCC441524419A9999D9272F5A419A9999994E152441000000602C2F5A413333333356152441CDCCCC0C302F5A41666666665F152441CDCCCC8C342F5A419A9999996915244133333353392F5A41666666667A16244100000060252F5A4133333333C4162441000000A01F2F5A41666666663817244133333393162F5A419A999999A6172441000000E00D2F5A4100000000B51724419A9999990C2F5A4166666666EE17244100000080072F5A419A9999993818244100000020012F5A4166666666C617244133333313E22E5A41333333339D172441333333F3D52E5A416666666683172441333333D3CF2E5A41666666666C1724419A9999D9CB2E5A41666666665B172441333333F3C92E5A41CDCCCCCC1317244133333313C42E5A4100000000E916244133333313C02E5A4133333333B716244166666666BC2E5A41CDCCCCCCA3162441CDCCCCACBA2E5A4166666666A21624419A999999BA2E5A413333333395162441666666E6BD2E5A4166666666761624419A999979C32E5A410000000053162441CDCCCCECC92E5A4100000000411624419A999959CE2E5A419A9999992B162441CDCCCCCCD22E5A41CDCCCCCC0D162441333333D3D92E5A41666666660C16244166666686DC2E5A4133333333C2152441CDCCCCACEB2E5A41CDCCCCCC8515244133333313F82E5A410000000082152441CDCCCC0CF92E5A41000000007515244100000040FB2E5A41666666666F15244100000000FC2E5A416666666662152441CDCCCCACFD2E5A41CDCCCCCC5D15244166666626FE2E5A4100000000371524419A9999F9002F5A419A999999FA142441666666E6032F5A419A999999C914244100000080062F5A41	01060000206A08000001000000010300000001000000110000009A999999C914244100000080062F5A416666666611152441000000E0182F5A41CDCCCCCC441524419A9999D9272F5A419A9999996915244133333353392F5A41666666667A16244100000060252F5A419A999999A6172441000000E00D2F5A419A9999993818244100000020012F5A416666666683172441333333D3CF2E5A41666666665B172441333333F3C92E5A4166666666A21624419A999999BA2E5A410000000053162441CDCCCCECC92E5A41CDCCCCCC0D162441333333D3D92E5A41666666660C16244166666686DC2E5A41CDCCCCCC8515244133333313F82E5A41CDCCCCCC5D15244166666626FE2E5A419A999999C914244100000080062F5A419A999999C914244100000080062F5A41	01010000206A08000018E02239CD16244166666626FA2E5A41	930060115	H	Iris 15	9300601	93006	93	11	0
01060000206A08000001000000010300000001000000360000009A9999996915244133333353392F5A410000000090152441333333734B2F5A419A999999921524419A9999D94C2F5A41CDCCCCCC9E152441666666E6522F5A4166666666A115244166666626542F5A4166666666D5152441333333D36D2F5A4100000000DA1524419A9999F96F2F5A419A999999ED15244100000060792F5A410000000004162441CDCCCCAC852F5A419A9999992216244100000080862F5A41333333335C162441CDCCCC0C882F5A419A99999995162441000000E0892F5A41CDCCCCCCF2162441666666E68C2F5A41333333334B1724419A999919912F5A419A999999681724419A999999922F5A4166666666AA17244133333353962F5A41CDCCCCCCD91724419A999999982F5A41666666660818244133333373922F5A410000000049182441000000C08B2F5A41666666668918244100000020862F5A4100000000A518244100000000842F5A4133333333D1182441CDCCCC0C812F5A419A99999918192441CDCCCCEC7B2F5A41333333335F1924419A999919772F5A41333333336E192441333333F3752F5A419A999999A3192441CDCCCCEC712F5A41CDCCCCCCD7192441000000206E2F5A419A9999990A1A2441000000A06A2F5A41333333332F1A244133333313682F5A419A999999051A2441000000005C2F5A41666666660F1A2441CDCCCC6C5B2F5A419A999999E8192441CDCCCC6C512F5A4133333333F919244133333373502F5A41CDCCCCCCE31924419A9999F9402F5A41CDCCCCCCC919244133333333302F5A41CDCCCCCCB6192441000000A0212F5A416666666688192441CDCCCC8C212F5A413333333375192441000000E0202F5A413333333349192441333333531E2F5A41CDCCCCCC3C1924419A9999991D2F5A41CDCCCCCC20192441CDCCCC8C1B2F5A41CDCCCCCCF4182441CDCCCCAC182F5A4100000000B818244166666626142F5A41666666669918244100000060112F5A4166666666691824419A9999190C2F5A419A999999611824419A9999F90A2F5A419A9999993818244100000020012F5A4166666666EE17244100000080072F5A4100000000B51724419A9999990C2F5A419A999999A6172441000000E00D2F5A41666666663817244133333393162F5A4133333333C4162441000000A01F2F5A41666666667A16244100000060252F5A419A9999996915244133333353392F5A41	01060000206A08000001000000010300000001000000160000009A9999996915244133333353392F5A419A999999ED15244100000060792F5A410000000004162441CDCCCCAC852F5A41CDCCCCCCF2162441666666E68C2F5A41CDCCCCCCD91724419A999999982F5A41666666660818244133333373922F5A41666666668918244100000020862F5A41333333332F1A244133333313682F5A419A999999051A2441000000005C2F5A41666666660F1A2441CDCCCC6C5B2F5A419A999999E8192441CDCCCC6C512F5A4133333333F919244133333373502F5A41CDCCCCCCB6192441000000A0212F5A416666666688192441CDCCCC8C212F5A41CDCCCCCC3C1924419A9999991D2F5A4100000000B818244166666626142F5A419A999999611824419A9999F90A2F5A419A9999993818244100000020012F5A419A999999A6172441000000E00D2F5A41666666667A16244100000060252F5A419A9999996915244133333353392F5A419A9999996915244133333353392F5A41	01010000206A08000026CB6478C6172441666666A64E2F5A41	930060116	H	Iris 16	9300601	93006	93	11	0
01060000206A0800000100000001030000000100000032000000CDCCCCCC0C1B24419A99993918375A419A999999161B2441333333331A375A41333333335D1B2441CDCCCC8C28375A4133333333AC1B24416666668638375A4166666666F91B2441000000E048375A419A9999992A1C24413333335353375A4133333333541C24419A9999195C375A4100000000011D24416666668680375A41CDCCCCCCC01D2441333333D3A8375A4100000000EB1D24419A999999A5375A41CDCCCCCCFA1D2441666666A6A4375A419A999999FC1D2441CDCCCC8CA4375A4133333333481E244100000020A0375A419A9999999C1E2441CDCCCC2C9B375A4166666666F31E24410000002096375A41CDCCCCCC2E1F2441333333B392375A41CDCCCCCC3A1F2441666666E691375A4133333333F11E2441000000A081375A4133333333C31E2441666666E677375A41333333337A1E2441000000E068375A41333333335B1E24416666660662375A4166666666331E24416666668659375A4133333333121F24410000006058375A4133333333FA1F2441CDCCCC2C57375A41666666660E2024413333331357375A4100000000972024410000006056375A41666666660E212441000000C055375A41CDCCCCCC17212441333333B355375A4166666666592124410000008055375A419A9999995E2124419A99997955375A41333333336B2124413333337355375A41000000006D2124413333337355375A4166666666242124413333331350375A4100000000C8202441CDCCCCCC46375A4166666666951F2441333333B327375A41CDCCCCCC551F24416666662620375A41CDCCCCCC091F2441000000A018375A41CDCCCCCCE91E24410000006015375A4100000000341E24416666664603375A41000000000C1E244166666606FF365A4100000000C21D244100000080F7365A4100000000811D24419A999959F9365A419A999999551D2441000000C0FB365A4133333333291D2441CDCCCC2CFE365A419A999999831C24410000004007375A41CDCCCCCCFF1B2441666666C60D375A419A9999992D1B24416666664619375A419A999999271B24416666662618375A419A999999181B24416666662618375A41CDCCCCCC0C1B24419A99993918375A41	01060000206A0800000100000001030000000100000014000000CDCCCCCC0C1B24419A99993918375A4133333333AC1B24416666668638375A41CDCCCCCCC01D2441333333D3A8375A4100000000EB1D24419A999999A5375A41CDCCCCCC3A1F2441666666E691375A4133333333F11E2441000000A081375A4166666666331E24416666668659375A41CDCCCCCC17212441333333B355375A41000000006D2124413333337355375A4166666666242124413333331350375A4166666666951F2441333333B327375A41CDCCCCCC551F24416666662620375A4100000000341E24416666664603375A4100000000C21D244100000080F7365A4100000000811D24419A999959F9365A419A999999831C24410000004007375A41CDCCCCCCFF1B2441666666C60D375A419A9999992D1B24416666664619375A41CDCCCCCC0C1B24419A99993918375A41CDCCCCCC0C1B24419A99993918375A41	01010000206A080000ACC728A6AE1E2441333333B351375A41	930070104	H	Iris 2	9300701	93007	93	11	0
01060000206A080000010000000103000000010000002A00000000000000982E2441CDCCCC8CC7345A419A999999F22E244166666606CD345A41333333331D2F244133333393CF345A4100000000572F244100000060D2345A4166666666732F244133333373D4345A419A999999E52F244166666666DF345A4100000000FF2F2441333333D3E1345A416666666615302441666666E6E3345A419A9999993E30244166666666E7345A41CDCCCCCC9B30244100000080EF345A4133333333B43024419A9999D9F0345A419A999999ED3024419A999939E5345A419A999999B030244133333393E0345A419A999999A63024419A9999F9DF345A4133333333AD3024419A999919DE345A419A999999C0302441000000A0D7345A41CDCCCCCCD5302441CDCCCCECD2345A4166666666F23024419A999959CD345A41000000000C31244133333333C8345A419A9999991D31244100000040C4345A419A999999503124419A999999B9345A419A9999996531244100000080B3345A413333333372312441CDCCCC2CB1345A419A9999997B312441CDCCCCECAE345A4133333333A131244166666646A7345A41CDCCCCCCF2302441333333F394345A4133333333C63024413333337390345A4166666666AB302441333333F38D345A41CDCCCCCCA73024419A9999398E345A419A999999523024416666668696345A4100000000E92F2441333333538E345A4100000000E82F24419A9999398E345A4100000000DA2F2441666666268D345A4133333333D62F2441CDCCCCEC8B345A41CDCCCCCCD12F2441000000208B345A41CDCCCCCCB72F2441CDCCCC2C87345A419A9999998F2F2441CDCCCCCC81345A41333333337C2F24419A9999397F345A4133333333632F2441CDCCCCCC7C345A419A999999522F2441CDCCCC8C7B345A4166666666152F2441CDCCCCCC81345A4100000000982E2441CDCCCC8CC7345A41	01060000206A080000010000000103000000010000001300000000000000982E2441CDCCCC8CC7345A4166666666732F244133333373D4345A4100000000FF2F2441333333D3E1345A41CDCCCCCC9B30244100000080EF345A4133333333B43024419A9999D9F0345A419A999999ED3024419A999939E5345A419A999999A63024419A9999F9DF345A419A999999C0302441000000A0D7345A419A999999503124419A999999B9345A419A9999996531244100000080B3345A4133333333A131244166666646A7345A4166666666AB302441333333F38D345A419A999999523024416666668696345A4100000000DA2F2441666666268D345A41333333337C2F24419A9999397F345A419A999999522F2441CDCCCC8C7B345A4166666666152F2441CDCCCCCC81345A4100000000982E2441CDCCCC8CC7345A4100000000982E2441CDCCCC8CC7345A41	01010000206A0800004FA1EBD408302441CDCCCC8CB6345A41	930070120	H	Iris 18	9300701	93007	93	11	0
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	01010000206A08000023F90803F12C2441CDCCCC6C1E375A41	930070101	A	Zone d'Activités Coudray Paris Nord	9300701	93007	93	11	1
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	01060000206A080000010000000103000000010000002700000033333333EF19244133333313F9355A41CDCCCCCC7E1A2441CDCCCCAC42365A4100000000ED1A2441CDCCCC0C3E365A41000000007C1B2441CDCCCC0C39365A419A999999CA1B24416666668637365A4166666666251C2441CDCCCC0C37365A4133333333B21C24413333331338365A4166666666BE1C24419A9999F955365A419A999999DA1C2441000000808B365A41CDCCCCCCFC1D24419A99991993365A419A9999995F1E24413333331395365A41CDCCCCCC031F24419A9999B99B365A4166666666A71F244166666606A3365A4100000000742024419A9999F9AC365A419A99999903222441CDCCCC4CC2365A419A9999991A222441666666A6BD365A413333333323232441000000C0A7365A4100000000E1222441666666269D365A41666666668B222441CDCCCC0C9B365A4100000000F3212441666666A67C365A4133333333E82124419A99991979365A41CDCCCCCC9D212441666666C644365A41CDCCCCCC742124419A9999392A365A41000000000E212441000000E02B365A41333333339F202441000000E027365A419A9999991F202441CDCCCC4C1C365A41CDCCCCCC192024413333335319365A4166666666E31F2441666666460F365A419A999999AA1F24419A9999990A365A4166666666751F24413333331308365A419A999999C21E244166666646F9355A4133333333701E2441CDCCCCCCF1355A419A999999E91D244133333333EE355A419A999999AE1D24419A9999D9EB355A41CDCCCCCC6F1C244133333373D4355A41CDCCCCCC9B1B24419A999959CA355A419A9999997D1B244166666626F7355A4133333333EF19244133333313F9355A4133333333EF19244133333313F9355A41	01010000206A0800005A9FB653321F2441000000404D365A41	930070102	H	Zone d'Activités Molette	9300701	93007	93	11	1
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	01060000206A080000010000000103000000010000001E000000CDCCCCCCFA1D2441666666A6A4375A419A999999981E244100000080C4375A41666666663A1F244133333393D2375A41CDCCCCCC641F244133333313D4375A41CDCCCCCC0F2024419A9999D9C7375A413333333332202441CDCCCCECD4375A419A99999942202441CDCCCC4CD1375A419A999999CA20244133333333DA375A4133333333A92024419A999959E1375A419A999999DD20244133333353DA375A41333333330D21244166666646D0375A416666666633212441333333B3CA375A4166666666902124419A9999F9C3375A4133333333C6212441CDCCCC6CC2375A4100000000752124419A999959B2375A410000000088212441CDCCCCCCB0375A41000000005521244166666646A5375A4166666666022124410000002090375A4166666666A5202441000000007C375A419A999999F0202441333333B377375A4166666666742124413333331372375A419A99999939222441333333B36C375A419A9999997C212441333333F358375A41000000006D2124413333337355375A41CDCCCCCC17212441333333B355375A4166666666331E24416666668659375A4133333333F11E2441000000A081375A41CDCCCCCC3A1F2441666666E691375A41CDCCCCCCFA1D2441666666A6A4375A41CDCCCCCCFA1D2441666666A6A4375A41	01010000206A080000B73E7ECFD41F2441666666A69D375A41	930070103	H	Iris 1	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000002A000000000000000D172441333333F33E365A4166666666B4172441000000A062365A41CDCCCCCCE71724413333331370365A4133333333761824419A9999798E365A41666666668119244100000000C4365A4133333333091A2441000000A0E0365A41CDCCCCCC0C1B24419A99993918375A419A9999992D1B24416666664619375A41CDCCCCCCFF1B2441666666C60D375A419A999999831C24410000004007375A4100000000811D24419A999959F9365A4100000000C21D244100000080F7365A4133333333FE1D24419A999939F2365A4133333333771E24419A999979EC365A419A9999999F1F24419A9999B9DC365A41CDCCCCCCAA1F24419A999999D8365A419A999999571F2441CDCCCC8CBE365A4133333333321F2441666666A6BA365A4100000000201F2441333333B3B5365A4133333333D01E2441CDCCCCAC99365A419A9999995F1E24413333331395365A41CDCCCCCCFC1D24419A99991993365A419A999999DA1C2441000000808B365A4166666666BE1C24419A9999F955365A4133333333B21C24413333331338365A4166666666251C2441CDCCCC0C37365A419A999999CA1B24416666668637365A41000000007C1B2441CDCCCC0C39365A4100000000ED1A2441CDCCCC0C3E365A41CDCCCCCC7E1A2441CDCCCCAC42365A4133333333EF19244133333313F9355A4166666666AE192441CDCCCCECF9355A41333333333B182441CDCCCCEC05365A4100000000BF172441CDCCCC2C0E365A41CDCCCCCC96172441333333530E365A41CDCCCCCC34172441666666E614365A413333333348172441000000001A365A416666666619172441333333131D365A4166666666A01724419A99995940365A4100000000A81724413333339343365A41000000000D172441333333F33E365A41000000000D172441333333F33E365A41	01010000206A08000070E24F49961A24419A99994987365A41	930070105	H	Iris 3	9300701	93007	93	11	1
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	01060000206A080000010000000103000000010000001C00000000000000C21D244100000080F7365A4100000000341E24416666664603375A41CDCCCCCC551F24416666662620375A419A9999997A202441CDCCCCEC0E375A419A9999999A202441666666A606375A4133333333DD202441CDCCCCAC09375A4133333333F02024410000008003375A41333333330A2124419A99991901375A419A9999996C212441333333F3FB365A4100000000BB21244166666686F6365A41000000005721244133333373E4365A41CDCCCCCCF421244133333393D6365A41000000005722244100000000E9365A41CDCCCCCC8322244133333353E3365A4100000000C9222441333333B3CB365A419A99999903222441CDCCCC4CC2365A4100000000742024419A9999F9AC365A4166666666A71F244166666606A3365A4133333333D01E2441CDCCCCAC99365A4100000000201F2441333333B3B5365A4133333333321F2441666666A6BA365A419A999999571F2441CDCCCC8CBE365A41CDCCCCCCAA1F24419A999999D8365A419A9999999F1F24419A9999B9DC365A4133333333771E24419A999979EC365A4133333333FE1D24419A999939F2365A4100000000C21D244100000080F7365A4100000000C21D244100000080F7365A41	01010000206A080000081B2A797520244166666606E0365A41	930070106	H	Iris 4	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000001A000000CDCCCCCC551F24416666662620375A4166666666951F2441333333B327375A4166666666242124413333331350375A41000000006D2124413333337355375A4100000000BD2224410000008054375A41CDCCCCCCCC2224410000008051375A4166666666172324413333333335375A41000000009E2324419A9999993A375A4133333333F62324419A9999591C375A4133333333012424416666660616375A4133333333F3232441CDCCCC8C0F375A41CDCCCCCC7B2424419A9999F9DE365A4100000000C9222441333333B3CB365A41CDCCCCCC8322244133333353E3365A41000000005722244100000000E9365A41CDCCCCCCF421244133333393D6365A41000000005721244133333373E4365A4100000000BB21244166666686F6365A419A9999996C212441333333F3FB365A41333333330A2124419A99991901375A4133333333F02024410000008003375A4133333333DD202441CDCCCCAC09375A419A9999999A202441666666A606375A419A9999997A202441CDCCCCEC0E375A41CDCCCCCC551F24416666662620375A41CDCCCCCC551F24416666662620375A41	01010000206A080000547DA9A02A2224413433334310375A41	930070107	H	Iris 5	9300701	93007	93	11	0
01060000206A080000010000000103000000010000002E00000000000000BD2224410000008054375A4166666666022324413333335354375A419A9999998E2324413333339353375A41CDCCCCCC8D2424419A99993952375A419A999999A2242441CDCCCCEC51375A4100000000AA242441333333D351375A41CDCCCCCCD9242441CDCCCC2C52375A41000000003C2524419A99993951375A4166666666E8252441000000804F375A4100000000FC252441000000804E375A4166666666DF2624419A9999394D375A413333333314272441CDCCCCEC4C375A419A99999930272441666666C64C375A410000000073272441666666664C375A41CDCCCCCC6F2724410000000049375A419A999999672724416666666640375A41333333334C2724413333337323375A410000000044272441666666E61A375A41CDCCCCCC412724410000008018375A419A9999993C2724419A99993913375A413333333339272441666666660F375A4100000000332724413333331309375A4166666666312724413333335307375A41CDCCCCCC2B272441CDCCCC6C01375A41666666661E272441CDCCCC6C01375A4133333333162724419A99993901375A41CDCCCCCC0E2724419A9999B900375A4133333333792624416666668612375A419A999999052624410000008021375A41CDCCCCCCE72524413333335325375A41CDCCCCCC4F252441666666E638375A41CDCCCCCC372524419A9999F93B375A419A9999992C242441CDCCCC0C30375A4166666666CA232441CDCCCCAC2B375A4133333333C3232441333333132E375A419A999999A42324419A99995938375A41000000009E2324419A9999993A375A41CDCCCCCC55232441333333B337375A41666666664B232441CDCCCC4C37375A4166666666172324413333333335375A4166666666EB2224410000008045375A4166666666EA222441000000E045375A41CDCCCCCCD3222441000000C04E375A41CDCCCCCCCC2224410000008051375A4166666666C82224410000008051375A4100000000BD2224410000008054375A41	01060000206A080000010000000103000000010000001000000000000000BD2224410000008054375A41CDCCCCCC8D2424419A99993952375A41CDCCCCCCD9242441CDCCCC2C52375A4166666666E8252441000000804F375A4100000000FC252441000000804E375A410000000073272441666666664C375A41CDCCCCCC2B272441CDCCCC6C01375A41CDCCCCCC0E2724419A9999B900375A4133333333792624416666668612375A41CDCCCCCC372524419A9999F93B375A4166666666CA232441CDCCCCAC2B375A41000000009E2324419A9999993A375A4166666666172324413333333335375A41CDCCCCCCCC2224410000008051375A4100000000BD2224410000008054375A4100000000BD2224410000008054375A41	01010000206A080000BABF1710902624410000008028375A41	930070108	H	Iris 7	9300701	93007	93	11	0
01060000206A080000010000000103000000010000002300000066666666CA232441CDCCCCAC2B375A419A9999992C242441CDCCCC0C30375A41CDCCCCCC372524419A9999F93B375A41CDCCCCCC4F252441666666E638375A41CDCCCCCCE72524413333335325375A419A999999052624410000008021375A4133333333792624416666668612375A41CDCCCCCC0E2724419A9999B900375A410000000009272441CDCCCC2C00375A4133333333052724419A999959FF365A41000000000227244133333393FD365A410000000003272441CDCCCC8CFC365A41333333330927244166666606FB365A4133333333F0252441333333F3EE365A41666666662C2524419A999999E6365A41000000002125244133333313E6365A41CDCCCCCC7B2424419A9999F9DE365A41000000006824244166666626E6365A41666666664E24244133333373EF365A419A9999994D2424419A999959EF365A41333333333824244166666606F7365A4133333333F3232441CDCCCC8C0F375A419A999999F02324419A9999F910375A419A999999F02324410000004012375A4133333333FA2324416666666614375A4133333333012424416666660616375A413333333302242441666666A616375A41CDCCCCCC002424419A9999B917375A4100000000FC232441000000C018375A4133333333F0232441333333B319375A4166666666F2232441000000801A375A4133333333F62324419A9999591C375A4100000000F3232441333333B31D375A41CDCCCCCCCB232441333333332B375A4166666666CA232441CDCCCCAC2B375A41	01060000206A080000010000000103000000010000000B00000066666666CA232441CDCCCCAC2B375A41CDCCCCCC372524419A9999F93B375A4133333333792624416666668612375A41CDCCCCCC0E2724419A9999B900375A41333333330927244166666606FB365A41CDCCCCCC7B2424419A9999F9DE365A4133333333F3232441CDCCCC8C0F375A4133333333012424416666660616375A4133333333F62324419A9999591C375A4166666666CA232441CDCCCCAC2B375A4166666666CA232441CDCCCCAC2B375A41	01010000206A08000000F338476C2524413433332308375A41	930070109	H	Iris 6	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000001B0000006666666664242441333333F3DD365A41333333330927244166666606FB365A410000000009272441CDCCCC2C00375A41CDCCCCCC2B272441CDCCCC6C01375A410000000073272441666666664C375A419A999999CA2924410000002049375A4166666666F02924413333339348375A4133333333282B24410000008047375A4100000000B12B2441CDCCCCEC40375A41CDCCCCCC912B2441333333D334375A41CDCCCCCC852B2441CDCCCC2C24375A41CDCCCCCC912B2441666666461B375A419A999999652B24419A9999F919375A419A999999732B2441666666060F375A4133333333592B2441CDCCCC0CEF365A41666666663B2B244100000020B8365A41000000000A2B244166666686BC365A4166666666E92A244133333313BA365A4133333333662A2441000000C0A0365A4133333333262B2441000000C08E365A4166666666B72A2441CDCCCC8C7C365A41CDCCCCCCEC2924419A9999195A365A410000000046272441666666E699365A419A999999AD252441CDCCCC8CBF365A4166666666892424419A999919DB365A416666666664242441333333F3DD365A416666666664242441333333F3DD365A41	01010000206A0800006C487C333128244134333353CD365A41	930070110	H	Iris 8	9300701	93007	93	11	0
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	01060000206A0800000100000001030000000100000018000000CDCCCCCC9D212441666666C644365A4133333333E82124419A99991979365A4100000000F3212441666666A67C365A41666666668B222441CDCCCC0C9B365A4100000000E1222441666666269D365A413333333323232441000000C0A7365A419A9999991A222441666666A6BD365A419A99999903222441CDCCCC4CC2365A4100000000C9222441333333B3CB365A416666666664242441333333F3DD365A4166666666892424419A999919DB365A419A999999AD252441CDCCCC8CBF365A410000000046272441666666E699365A41CDCCCCCCEC2924419A9999195A365A419A9999990F282441000000000A365A41CDCCCCCCF32724410000000006365A41CDCCCCCC8F2624410000002025365A41333333334F2624419A99999928365A41666666661F2524419A9999D92E365A4100000000A1232441333333B33A365A419A999999EA222441CDCCCC8C3F365A4133333333042224413333339343365A41CDCCCCCC9D212441666666C644365A41CDCCCCCC9D212441666666C644365A41	01010000206A080000D6049DA968252441CDCCCC8C71365A41	930070111	H	Iris 9	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000002B000000CDCCCCCC742124419A9999392A365A41CDCCCCCC9D212441666666C644365A4133333333042224413333339343365A419A999999EA222441CDCCCC8C3F365A4100000000A1232441333333B33A365A41666666661F2524419A9999D92E365A41333333334F2624419A99999928365A41CDCCCCCC8F2624410000002025365A41CDCCCCCCF32724410000000006365A41CDCCCCCC66282441CDCCCC6CFF355A41000000001C292441333333D3F3355A41CDCCCCCC4129244100000080F0355A41CDCCCCCC1F2B2441CDCCCCACCA355A419A999999352A24419A9999D993355A41333333339C292441000000406F355A4133333333DA2824413333331370355A41666666665D282441CDCCCC4C6B355A419A99999934282441666666266D355A4100000000682724416666662679355A419A99999950272441000000807D355A419A999999B52624419A9999F990355A41333333337E2624419A99991996355A41CDCCCCCC33262441666666C699355A41666666665526244100000000AB355A41000000004F2624419A999999AE355A41333333338C2624419A999919B7355A41333333336E262441CDCCCCECBA355A41333333336B2624419A9999F9C0355A4166666666C5252441CDCCCC6CCF355A4100000000BF252441000000E0D1355A41000000002125244100000000F0355A41CDCCCCCCE52424419A9999D9F6355A41CDCCCCCCCC242441CDCCCCECF6355A419A999999322424419A999979FF355A4166666666FA232441333333D30D365A419A99999980232441000000C01A365A410000000046232441333333131F365A413333333300232441666666A61D365A41666666669E2224419A9999D91E365A41000000003B2224410000004022365A419A999999172224416666662626365A41CDCCCCCC742124419A9999392A365A41CDCCCCCC742124419A9999392A365A41	01010000206A080000E144540BFE27244100000070D9355A41	930070112	H	Iris 10	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000001C000000CDCCCCCC002824416666666606365A419A9999990F282441000000000A365A4133333333262B2441000000C08E365A41666666665B2B24410000000089365A4133333333A02B24419A9999797F365A4133333333DA2C24419A99995959365A4133333333EB2C2441CDCCCCEC56365A4100000000502E2441CDCCCC4C2B365A419A9999998E2E24413333335324365A41000000008A2F2441CDCCCC8CF6355A4166666666F72F2441000000A0E0355A4100000000A43024419A999939B9355A4133333333EF2F244166666666B3355A41CDCCCCCC9A2E2441000000E0A9355A41666666664D2E244100000040A8355A4133333333032E244100000000A8355A4166666666B42D24419A999919A9355A41000000004F2D24419A999939AD355A4166666666EA2B244100000020C0355A419A999999AC2B2441666666C6C2355A4133333333142B244133333353CB355A41000000009E2A244100000000D5355A41CDCCCCCC4129244100000080F0355A41000000001C292441333333D3F3355A41CDCCCCCC66282441CDCCCC6CFF355A41CDCCCCCC0F282441CDCCCC2C04365A41CDCCCCCC002824416666666606365A41CDCCCCCC002824416666666606365A41	01010000206A080000B409FB099C2B24419A9999991E365A41	930070113	H	Iris 11	9300701	93007	93	11	1
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	01060000206A080000010000000103000000010000001B00000033333333662A2441000000C0A0365A4166666666E92A244133333313BA365A41000000000A2B244166666686BC365A41666666663B2B244100000020B8365A4133333333592B2441CDCCCC0CEF365A419A999999732B2441666666060F375A419A999999652B24419A9999F919375A41CDCCCCCC912B2441666666461B375A4100000000E32C244133333333F0365A419A999999B62D2441666666C6D6365A41CDCCCCCC2A2E244166666646C8365A41CDCCCCCC682E244133333333BD365A419A999999B02E244100000000A9365A4133333333DA2E24419A9999D9A0365A419A999999212F2441CDCCCC6C96365A41666666669D302441333333B367365A41666666664C2F24419A99991935365A41000000000F2F2441CDCCCC8C2E365A4166666666692E2441000000C028365A4100000000502E2441CDCCCC4C2B365A4133333333EB2C2441CDCCCCEC56365A4133333333DA2C24419A99995959365A4133333333A02B24419A9999797F365A41666666665B2B24410000000089365A4133333333262B2441000000C08E365A4133333333662A2441000000C0A0365A4133333333662A2441000000C0A0365A41	01010000206A080000BCBBBB9BA02C2441CDCCCCCCA1365A41	930070114	H	Iris 12	9300701	93007	93	11	0
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	01060000206A080000010000000103000000010000001700000066666666692E2441000000C028365A41000000000F2F2441CDCCCC8C2E365A41666666664C2F24419A99991935365A41666666669D302441333333B367365A41333333337D3124410000002052365A4166666666C6312441000000404D365A4100000000EE302441666666E629365A419A99999947322441CDCCCC6C0D365A4166666666F533244166666646F9355A413333333310352441000000A0EB355A419A9999999A34244100000000C5355A41000000000B34244100000020C4355A41000000002B33244100000040C4355A416666666615332441CDCCCCCCC2355A419A99999992322441333333B3C0355A419A9999996431244100000020BE355A41000000000031244166666646BC355A4100000000A43024419A999939B9355A4166666666F72F2441000000A0E0355A41000000008A2F2441CDCCCC8CF6355A419A9999998E2E24413333335324365A4166666666692E2441000000C028365A4166666666692E2441000000C028365A41	01010000206A080000EC9DD71F81302441CDCCCC1C12365A41	930070115	H	Iris 13	9300701	93007	93	11	0
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	01060000206A0800000100000001030000000100000034000000666666665D282441CDCCCC4C6B355A4133333333DA2824413333331370355A41333333339C292441000000406F355A419A999999352A24419A9999D993355A41CDCCCCCC1F2B2441CDCCCCACCA355A419A999999AC2B2441666666C6C2355A4166666666EA2B244100000020C0355A41000000004F2D24419A999939AD355A4166666666B42D24419A999919A9355A4133333333032E244100000000A8355A41666666664D2E244100000040A8355A41CDCCCCCC9A2E2441000000E0A9355A4133333333EF2F244166666666B3355A41000000000031244166666646BC355A419A9999996431244100000020BE355A419A99999992322441333333B3C0355A416666666615332441CDCCCCCCC2355A41000000002B33244100000040C4355A413333333383332441CDCCCCECC3355A41CDCCCCCCC0342441CDCCCCECC4355A4166666666493524419A999999C3355A419A9999998C3524419A999919C1355A419A9999992E352441333333B39C355A4166666666EB342441CDCCCCCC8A355A416666666621342441CDCCCCAC8C355A419A99999908342441666666467D355A419A999999263424419A99997968355A41CDCCCCCC32342441666666E663355A41333333337B3424416666660659355A419A9999995D3424413333333355355A4100000000AD332441000000C055355A416666666698332441666666A656355A419A999999C03124419A99995958355A4166666666BD3124410000008046355A4133333333573124419A9999D946355A419A999999313124419A9999F945355A413333333327312441666666663C355A4100000000C9302441666666E635355A4133333333B5302441CDCCCC0C33355A4100000000773024419A9999F930355A41333333332A3024410000008030355A4166666666BF2D24419A99993933355A41666666667E2D2441000000E034355A4133333333D12C24410000008034355A41CDCCCCCCBD2C2441666666662E355A4133333333752B2441333333B32E355A4166666666282A2441CDCCCC8C20355A41CDCCCCCC94292441CDCCCCAC1A355A4100000000DE292441333333F333355A41666666664A292441000000E049355A41666666665D282441CDCCCC4C6B355A41666666665D282441CDCCCC4C6B355A41	01010000206A0800008FBAEE4DE02E2441333333B372355A41	930070116	H	Iris 14	9300701	93007	93	11	1
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	01060000206A0800000100000001030000000100000027000000333333335F2E2441000000002E345A419A999999AF2E2441CDCCCC2C28345A4166666666722F24413333335346345A4166666666DA2F2441333333B357345A4100000000D12F2441CDCCCC6C5F345A4133333333353024416666664662345A41CDCCCCCC57312441000000E040345A419A99999974312441CDCCCCEC40345A419A999999DE3124419A9999394E345A4133333333D83124416666662651345A4133333333AC302441000000E072345A4133333333C8302441CDCCCCAC7A345A4100000000E73024419A99991988345A416666666660322441CDCCCCCC63345A41CDCCCCCCB7322441000000005B345A410000000000332441333333135B345A416666666613332441333333D35E345A419A9999994E3324419A9999B978345A419A999999903324410000000079345A4100000000A63324413333337377345A4166666666A53324410000000063345A41333333337A332441000000804D345A413333333345332441666666263B345A410000000030332441666666C62F345A4133333333BC322441CDCCCCEC03345A419A99999955312441333333F30C345A4133333333C230244133333373EC335A419A999999C430244166666606E8335A419A9999993C30244133333373DF335A4100000000CD2F244166666666D9335A4100000000A72F2441CDCCCCCCEA335A41333333338A2F2441CDCCCC2CFF335A419A9999995C2F24419A99995907345A41CDCCCCCC9B2E2441666666A60D345A419A999999842E24410000004010345A419A999999EA2E2441CDCCCC8C1A345A4133333333612E24416666662625345A41333333335F2E2441000000002E345A41333333335F2E2441000000002E345A41	01010000206A08000061D575A30A3124419A99991931345A41	930070121	H	Iris 19	9300701	93007	93	11	0
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	01010000206A0800008F1BFE057B2924419A9999A98B345A41	930070117	H	Iris 15	9300701	93007	93	11	1
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	01060000206A080000010000000103000000010000001B00000066666666A2292441000000C0B8345A41CDCCCCCCFF29244133333373C5345A419A999999602A2441CDCCCCCCBE345A4166666666D22A244133333393BC345A41000000002C2B2441CDCCCCACBE345A41CDCCCCCC5E2B24419A999979C1345A41000000000D2C244100000060D0345A419A999999872C24419A999959D6345A4166666666C42C244166666646C4345A419A999999E12C244133333393B8345A41000000009B2C244166666686B7345A4133333333352D2441CDCCCCAC79345A419A999999072D24419A9999394B345A41CDCCCCCC5F2D24416666668639345A41000000007A2C24419A9999D929345A41333333335A2C24419A9999B931345A4166666666EE2B24410000006044345A4133333333B02B24410000002051345A4166666666232B2441CDCCCC6C46345A4166666666C32A2441333333135B345A41CDCCCCCCA32A24413333339363345A419A999999432A2441000000A061345A4133333333B0292441333333F384345A4100000000542A24410000002097345A419A999999852A2441000000009B345A4166666666A2292441000000C0B8345A4166666666A2292441000000C0B8345A41	01010000206A0800000ED7CD52772B2441CDCCCC4C7F345A41	930070118	H	Iris 17	9300701	93007	93	11	0
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	01010000206A080000FBB9FAE78D322441CDCCCC8CBE345A41	930070119	H	Iris 16	9300701	93007	93	11	1
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	01010000206A080000F490908315122441CDCCCC9CAD325A41	930080101	H	Les Vignes 1	9300801	93008	93	11	3
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	01060000206A0800000100000001030000000100000022000000CDCCCCCC471A2441000000A045335A4100000000821A2441000000E049335A41CDCCCCCC601A2441CDCCCCCC4C335A419A999999BC1C24410000004087335A4100000000ED1D24413333337375335A419A999999801F2441333333735D335A410000000048212441666666E64B335A419A999999C9212441666666C648335A419A9999990F2324410000006031335A4100000000E0232441CDCCCC4C20335A419A9999994D2424419A99995915335A419A9999999F23244133333333F2325A41CDCCCCCC9323244133333393F0325A419A999999F12224419A9999D9E5325A41333333337C2224419A9999B9ED325A41333333336D222441000000E0ED325A41CDCCCCCC2F222441333333D3DE325A410000000000222441000000A0CF325A4166666666342124419A999999DA325A41333333333A202441666666E6E9325A41333333330720244100000040E9325A41CDCCCCCCE61F2441333333D3E6325A41CDCCCCCCF61F24419A999999ED325A4133333333C41F2441333333B3F4325A4166666666841F24419A9999B9F3325A4133333333261F24419A999999F6325A41CDCCCCCC5C1E24419A99993901335A41CDCCCCCC541E2441CDCCCCCC04335A4100000000B51D24419A9999190D335A4133333333381C24410000006025335A41CDCCCCCCEB1B2441000000C029335A4100000000B71A2441333333733D335A41CDCCCCCC471A2441000000A045335A41CDCCCCCC471A2441000000A045335A41	01010000206A080000184DEFE9971F2441333333632B335A41	930080102	H	Bourse du Travail 1	9300801	93008	93	11	0
01060000206A0800000100000001030000000100000039000000000000007D132441CDCCCCACF2325A41000000007D1324419A999979F3325A41CDCCCCCC7E13244100000000F6325A419A9999999D1324419A9999790C335A419A999999A91324419A99995913335A4100000000A3132441CDCCCC8C15335A4100000000AB132441000000A01C335A41CDCCCCCCB7132441CDCCCC4C24335A41CDCCCCCCBF132441333333132A335A4166666666CA132441CDCCCCEC2A335A4100000000C21324419A9999B92C335A4100000000BD132441CDCCCCEC2D335A419A999999BB132441CDCCCC8C2E335A4100000000BA132441666666662F335A4166666666C61324419A99999939335A4166666666D71324410000008046335A41CDCCCCCCE71324413333331353335A41333333332C1424416666668651335A41666666664D142441333333D350335A416666666650142441666666C650335A4133333333C11424419A9999194F335A419A999999A6142441000000203C335A41000000008D142441CDCCCC6C28335A4100000000A31424419A99991928335A4100000000BD142441333333B327335A4166666666F51424413333337326335A413333333306152441333333D326335A41CDCCCCCC11152441333333D326335A413333333327152441333333B326335A41CDCCCCCC321524410000008026335A41CDCCCCCC3D1524416666668626335A410000000046152441CDCCCCEC25335A4133333333471524419A9999D925335A416666666650152441666666A625335A4100000000651524419A99993925335A4133333333681524413333337324335A413333333368152441000000C023335A41000000005C152441000000601B335A4133333333441524419A9999390B335A413333333327152441CDCCCC0CF9325A413333333315152441000000C0EC325A419A999999E914244133333393EE325A4100000000C8142441CDCCCCCCEF325A4133333333AA142441000000A0F0325A419A9999999E142441CDCCCC2CE8325A419A99999965142441000000E0E8325A419A9999994D14244166666666E9325A41666666664714244166666686E9325A413333333334142441CDCCCC8CE9325A41000000001A142441333333F3E8325A413333333308142441CDCCCC8CE8325A4133333333EB132441CDCCCCCCE8325A41CDCCCCCCDE13244100000000E9325A41666666669C132441000000E0EA325A4133333333971324419A999939EB325A413333333393132441333333D3EB325A41000000007D132441CDCCCCACF2325A41	01060000206A0800000100000001030000000100000013000000000000007D132441CDCCCCACF2325A419A999999A91324419A99995913335A4100000000A3132441CDCCCC8C15335A41CDCCCCCCBF132441333333132A335A4100000000BA132441666666662F335A41CDCCCCCCE71324413333331353335A4133333333C11424419A9999194F335A41000000008D142441CDCCCC6C28335A4166666666F51424413333337326335A41CDCCCCCC3D1524416666668626335A413333333368152441000000C023335A413333333315152441000000C0EC325A4133333333AA142441000000A0F0325A419A9999999E142441CDCCCC2CE8325A413333333334142441CDCCCC8CE9325A413333333308142441CDCCCC8CE8325A41666666669C132441000000E0EA325A41000000007D132441CDCCCCACF2325A41000000007D132441CDCCCCACF2325A41	01010000206A080000F719D5F9891424410000003020335A41	930080103	H	Les Vignes 2	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000003900000000000000A0122441CDCCCCCCB3325A419A999999BB12244133333313BB325A41666666663F13244166666686BE325A4133333333C11324419A9999D9C5325A419A9999990E14244100000000CC325A41CDCCCCCC711424419A999999D5325A41333333338B14244100000040DA325A4133333333AA142441000000A0F0325A413333333315152441000000C0EC325A413333333368152441000000C023335A41CDCCCCCC3D1524416666668626335A4166666666F51424413333337326335A41000000008D142441CDCCCC6C28335A4133333333C11424419A9999194F335A41CDCCCCCCE71324413333331353335A41CDCCCCCC171424413333335376335A41CDCCCCCC48142441CDCCCC6C93335A41CDCCCCCCF81524410000002083335A41666666664E162441666666667F335A419A999999BC162441CDCCCC4C78335A4166666666501824419A9999F95C335A410000000087182441CDCCCC2C5F335A41CDCCCCCCD4182441CDCCCCAC5C335A4166666666DC192441CDCCCCCC50335A419A9999994E1A2441CDCCCC0C4B335A41CDCCCCCC601A2441CDCCCCCC4C335A4100000000821A2441000000E049335A41CDCCCCCC471A2441000000A045335A41666666663A1A2441000000A03D335A41CDCCCCCC181A2441CDCCCC6C3B335A4133333333E7192441666666263C335A4166666666C61924410000002038335A413333333329192441666666862A335A41000000008B182441CDCCCCCC1D335A413333333391182441000000401B335A41CDCCCCCC531824413333339313335A4166666666B8172441000000A005335A4166666666D817244133333353FD325A4100000000A8182441CDCCCC6CEE325A41CDCCCCCC851824419A9999F9E3325A41666666669718244166666606D7325A41333333335818244100000080B8325A413333333306182441CDCCCC8CAE325A4100000000C9182441333333F39C325A4166666666111824413333335396325A41CDCCCCCCE21724419A9999B996325A4133333333D5172441333333B39D325A413333333381172441000000E0C0325A41CDCCCCCC2F172441CDCCCC4CDE325A4133333333ED1624419A9999B9F8325A4166666666E71424419A999999CA325A419A999999F813244166666606B5325A419A999999D9132441CDCCCC0CB6325A41CDCCCCCC8A132441CDCCCC0CB4325A41333333332A132441000000E0B2325A4100000000A0122441CDCCCCCCB3325A4100000000A0122441CDCCCCCCB3325A41	01010000206A080000D4EFB9C5DD162441333333A315335A41	930080104	H	Les Vignes 3	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000002D0000000000000000222441000000A0CF325A41CDCCCCCC2F222441333333D3DE325A41333333336D222441000000E0ED325A41333333337C2224419A9999B9ED325A419A999999F12224419A9999D9E5325A41CDCCCCCC9323244133333393F0325A419A9999999F23244133333333F2325A419A9999994D2424419A99995915335A4166666666F6242441333333B302335A413333333334252441CDCCCCCCFE325A419A9999997D252441666666860D335A41666666664D262441666666E601335A41CDCCCCCCB1262441CDCCCC0C16335A4166666666E72624419A99993915335A4133333333502824419A9999D925335A4133333333BF2824416666662625335A41CDCCCCCC382924416666666627335A419A9999999E292441666666662C335A41CDCCCCCCD42924413333339333335A41CDCCCCCCE12924419A99997932335A41CDCCCCCCB7292441000000A02B335A41CDCCCCCC7D292441333333931D335A41CDCCCCCC5A292441000000A00F335A416666666608292441000000C0EB325A41CDCCCCCC7828244100000000CB325A41333333330A282441CDCCCCCC98325A4133333333FC2724416666662697325A41CDCCCCCC13272441333333339F325A41333333334B262441CDCCCCCCA4325A4166666666B5252441666666A6A9325A4100000000AA2524419A9999F9A5325A419A999999292524419A999999A9325A41CDCCCCCCA6242441CDCCCCCCAE325A41000000007B24244133333393AF325A4166666666242424419A999979AA325A41CDCCCCCCBB232441CDCCCC4CAE325A4166666666A32324419A999959B1325A4133333333AD2324419A9999D9B6325A4100000000A12324419A9999D9BA325A41000000007B232441CDCCCC0CBE325A410000000048232441333333D3BC325A41000000003323244166666666B9325A41CDCCCCCC0E232441CDCCCC6CC1325A410000000000222441000000A0CF325A410000000000222441000000A0CF325A41	01010000206A080000B411E8498E25244166666656E2325A41	930080106	H	Édouard Vaillant 1	9300801	93008	93	11	0
01060000206A08000001000000010300000001000000C6000000CDCCCCCCD42924413333339333335A419A999999D5292441CDCCCCAC33335A4166666666352A24419A9999B940335A419A9999995E2A24419A9999F945335A4166666666762A24413333333347335A4133333333872A2441333333F347335A4133333333982A2441000000C048335A41000000009F2A24416666660649335A41CDCCCCCCA92A2441666666A649335A41CDCCCCCCB12A2441000000204A335A41CDCCCCCCB32A2441CDCCCC6C4A335A41CDCCCCCCCD2A2441333333D34E335A4100000000DC2A24419A99993951335A41CDCCCCCCE72A24410000004053335A41CDCCCCCC5C2B24416666664660335A419A9999996A2B2441CDCCCC8C61335A41666666666B2B2441000000A061335A419A9999998B2B2441CDCCCCEC62335A41CDCCCCCC952B24413333335363335A419A999999B42B24413333339364335A4100000000B92B24410000008065335A41CDCCCCCCAC2B2441CDCCCCCC66335A4166666666A02B2441666666E667335A419A9999998F2B2441000000E069335A41000000009E2B2441333333136C335A419A999999B82B2441000000A06E335A419A999999DC2B24413333331371335A419A999999EE2B2441CDCCCC4C72335A419A999999EF2B24419A99995972335A419A999999F32B24416666666672335A4133333333FD2B24419A99997972335A419A999999022C2441CDCCCC8C72335A4100000000112C2441333333D372335A4166666666192C24410000000073335A419A9999992D2C24419A99995973335A41666666662E2C24410000006073335A41000000003A2C2441666666C673335A41CDCCCCCC612C24413333333375335A41CDCCCCCC892C2441666666A676335A41333333338C2C24419A9999B976335A419A9999998E2C24416666666676335A41CDCCCCCC972C24419A99993975335A41000000009E2C2441CDCCCC4C74335A4100000000AE2C2441000000A072335A4100000000BD2C2441CDCCCC4C74335A419A999999C72C24416666662676335A4166666666C82C24416666664676335A4166666666D62C2441CDCCCCEC77335A4133333333FD2C2441666666867C335A41CDCCCCCC032D24419A9999997D335A41000000000F2D2441333333D37E335A4100000000342D2441000000C082335A4100000000432D24419A99993984335A419A999999A32D2441333333738F335A419A999999A62D2441CDCCCCCC8F335A4133333333AC2D24416666668690335A4166666666AE2D2441666666E690335A419A999999B12D24419A99997991335A4133333333E22D2441000000008C335A4133333333F52D2441000000E089335A41CDCCCCCCFA2D24410000004089335A419A999999002E24419A9999B989335A4100000000152E24419A9999798B335A419A999999152E2441666666868B335A4133333333552E24419A9999D990335A41000000008C2E24413333337395335A4100000000A22E2441CDCCCC4C97335A41CDCCCCCCB42E24410000006099335A41CDCCCCCCB62E24413333337399335A4166666666BF2E24419A9999F999335A4166666666C02E2441666666069A335A419A999999DF2E2441CDCCCC8C9B335A419A999999F22E24419A9999799C335A4166666666022F2441CDCCCC4C9D335A419A999999702F2441333333B3A3335A4100000000902F24419A999979A5335A41666666669A2F24419A999979A5335A4133333333B22F24419A999959A5335A4133333333D92F2441000000E0A4335A4133333333E12F2441666666C6A4335A4166666666F72F2441000000A0A4335A41CDCCCCCC6D302441CDCCCC4CA3335A41CDCCCCCC6E30244100000000A2335A410000000072302441000000209B335A413333333375302441000000E094335A41000000007A302441666666868D335A41333333337B302441CDCCCC6C8B335A41666666667B302441666666068B335A416666666680302441000000E083335A41CDCCCCCC87302441000000A078335A41CDCCCCCC87302441666666A677335A41666666668C3024416666662664335A419A9999998D3024419A9999F961335A413333333391302441666666665F335A41CDCCCCCC94302441666666265E335A419A999999B1302441CDCCCC8C55335A4166666666BB302441CDCCCC6C52335A4100000000BF302441666666E650335A4133333333CF302441000000E049335A4100000000D3302441CDCCCC6C46335A41CDCCCCCCD23024419A99993943335A419A999999D03024413333339341335A4133333333B9302441CDCCCC8C38335A4133333333B03024416666664635335A4133333333A3302441CDCCCC0C32335A416666666656302441000000E025335A4133333333323024410000000020335A410000000021302441000000401D335A4100000000FD2F24413333331316335A4166666666EE2F2441666666A612335A4100000000E42F2441666666860F335A41CDCCCCCCDB2F2441000000200D335A4100000000D32F2441CDCCCC8C0A335A419A999999CE2F24419A99993909335A4166666666C82F24419A99997907335A419A999999BB2F24410000002004335A4100000000B62F24413333335302335A419A999999662F2441CDCCCC2C04335A419A999999172F2441CDCCCCAC06335A4133333333ED2E2441CDCCCCEC07335A41CDCCCCCCB42E2441000000C009335A419A999999722E2441000000800B335A419A999999712E2441333333530A335A4166666666202E2441000000E00C335A419A999999152E2441333333730D335A41333333330A2E24419A9999B90D335A4100000000F92D2441CDCCCC0C0E335A419A999999082E2441CDCCCCEC13335A41CDCCCCCC122E24419A9999B917335A41CDCCCCCC1E2E2441333333731C335A41CDCCCCCC2A2E2441666666E61F335A419A9999993A2E2441CDCCCC2C25335A4100000000512E24419A9999792D335A41CDCCCCCC522E2441000000202F335A419A999999522E24416666664630335A41CDCCCCCC4D2E24413333335331335A41CDCCCCCC452E24413333333332335A4100000000342E24413333333333335A4100000000262E2441666666C633335A41CDCCCCCC202E24410000002034335A419A9999991C2E2441333333B334335A41000000001B2E2441000000E035335A41666666661B2E2441333333B337335A41CDCCCCCC1D2E2441333333933A335A41333333331F2E2441666666863C335A41CDCCCCCC1F2E24419A9999D93D335A419A9999991C2E24419A9999793F335A419A999999172E2441000000E040335A41333333330F2E2441CDCCCC0C42335A4166666666022E24419A9999B942335A41CDCCCCCCE72D24413333335343335A4133333333C92D24416666666643335A41CDCCCCCCB52D24419A9999B943335A4133333333A92D2441333333D343335A4166666666A02D2441CDCCCCCC43335A4100000000932D24410000006043335A4166666666842D24419A9999D942335A4166666666792D2441000000E042335A4100000000712D24410000002043335A4166666666592D2441000000E044335A41CDCCCCCC242D24419A9999F93A335A41CDCCCCCC132D24410000000038335A419A999999092D2441333333D336335A4166666666FD2C2441333333F335335A4166666666F72C2441333333B335335A419A999999E62C24419A99997935335A4166666666D82C2441000000E035335A4100000000BE2C24419A99993937335A41333333337C2C2441000000003B335A419A9999991E2C2441CDCCCC6C40335A41CDCCCCCC102C2441000000C03E335A41CDCCCCCC0A2C2441666666A63D335A4100000000FA2B2441333333133D335A4166666666C72B24419A9999593A335A4133333333BE2B2441333333733B335A419A999999AB2B2441666666663C335A4133333333922B2441666666A63C335A419A999999782B24419A9999593C335A4133333333622B2441333333D33B335A41333333334C2B2441CDCCCCCC3B335A4166666666362B2441666666863C335A419A9999991D2B2441000000A03D335A4166666666102B2441333333733E335A4100000000042B24410000006040335A4133333333FD2A2441CDCCCC4C41335A4100000000EF2A2441CDCCCC6C42335A4133333333DC2A24416666668643335A419A999999C82A24416666660644335A4166666666B82A24413333331344335A41CDCCCCCC9C2A24419A9999D943335A4100000000872A24416666668642335A41CDCCCCCC572A24410000004040335A41666666662E2A2441666666A63D335A41CDCCCCCC1C2A2441333333133C335A4166666666102A2441666666663A335A419A999999F7292441CDCCCC2C36335A41CDCCCCCCE12924419A99997932335A41CDCCCCCCD42924413333339333335A41	01060000206A0800000100000001030000000100000034000000CDCCCCCCD42924413333339333335A419A9999995E2A24419A9999F945335A41CDCCCCCCB12A2441000000204A335A41CDCCCCCCE72A24410000004053335A41666666666B2B2441000000A061335A4100000000B92B24410000008065335A419A9999998F2B2441000000E069335A419A999999B82B2441000000A06E335A419A999999EE2B2441CDCCCC4C72335A419A9999992D2C24419A99995973335A41333333338C2C24419A9999B976335A4100000000AE2C2441000000A072335A41CDCCCCCC032D24419A9999997D335A4100000000432D24419A99993984335A419A999999B12D24419A99997991335A41CDCCCCCCFA2D24410000004089335A41CDCCCCCCB42E24410000006099335A4100000000902F24419A999979A5335A41CDCCCCCC6D302441CDCCCC4CA3335A41CDCCCCCC87302441000000A078335A413333333391302441666666665F335A4166666666BB302441CDCCCC6C52335A4133333333CF302441000000E049335A419A999999D03024413333339341335A4133333333A3302441CDCCCC0C32335A410000000021302441000000401D335A4166666666EE2F2441666666A612335A4100000000B62F24413333335302335A419A999999662F2441CDCCCC2C04335A419A999999722E2441000000800B335A419A999999712E2441333333530A335A4100000000F92D2441CDCCCC0C0E335A4100000000512E24419A9999792D335A41CDCCCCCC452E24413333333332335A419A9999991C2E2441333333B334335A41CDCCCCCC1F2E24419A9999D93D335A4166666666022E24419A9999B942335A4166666666592D2441000000E044335A41CDCCCCCC132D24410000000038335A419A999999E62C24419A99997935335A419A9999991E2C2441CDCCCC6C40335A41CDCCCCCC0A2C2441666666A63D335A4166666666C72B24419A9999593A335A419A999999AB2B2441666666663C335A41333333334C2B2441CDCCCCCC3B335A4166666666102B2441333333733E335A4133333333DC2A24416666668643335A41CDCCCCCC9C2A24419A9999D943335A41666666662E2A2441666666A63D335A41CDCCCCCCE12924419A99997932335A41CDCCCCCCD42924413333339333335A41CDCCCCCCD42924413333339333335A41	01010000206A080000CC8E13ABD32D24416666666654335A41	930080107	H	Édouard Vaillant 2	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000002500000033333333312C2441000000C022335A41333333337C2C2441000000003B335A419A999999E62C24419A99997935335A41CDCCCCCC132D24410000000038335A4166666666592D2441000000E044335A4166666666022E24419A9999B942335A41CDCCCCCC1F2E24419A9999D93D335A419A9999991C2E2441333333B334335A41CDCCCCCC452E24413333333332335A4100000000512E24419A9999792D335A4100000000F92D2441CDCCCC0C0E335A419A999999712E2441333333530A335A419A999999722E2441000000800B335A419A999999662F2441CDCCCC2C04335A4100000000B62F24413333335302335A419A999999A02F244100000000FC325A41CDCCCCCC122F244100000020DE325A4100000000E12E244133333373D1325A419A999999952E24419A9999D9BB325A4100000000842E2441333333D3B8325A4166666666152E244133333373AE325A41CDCCCCCC142E24419A999979B0325A41CDCCCCCC4D2E24419A999939D8325A419A999999CC2D2441333333F3DB325A419A999999D52D2441CDCCCCACE2325A4166666666B62D2441CDCCCCECEC325A4166666666672D24419A9999B9F0325A41CDCCCCCC4C2D2441666666E6F4325A419A999999482D244166666626FD325A4166666666642D24416666664603335A4166666666602D2441666666C607335A41333333332E2D2441333333330B335A4133333333392D24413333339310335A41CDCCCCCCFF2C24416666660615335A41CDCCCCCC882C24419A99993919335A4133333333312C2441000000C022335A4133333333312C2441000000C022335A41	01010000206A080000D0DBB2166E2E244166666686F9325A41	930080108	H	Édouard Vaillant 3	9300801	93008	93	11	0
01060000206A080000010000000103000000010000004900000066666666AB292441666666C6EC325A4166666666AD292441333333B3EE325A419A999999B1292441CDCCCC2CF1325A4133333333B629244166666666F2325A41CDCCCCCCFA292441CDCCCC4C13335A419A999999032A24416666660617335A41CDCCCCCC092A24410000008018335A41000000002C2A2441666666E61B335A4166666666332A2441333333931C335A4100000000552A24419A9999B91F335A4100000000612A2441333333D320335A41CDCCCCCC482A2441CDCCCC2C24335A41000000001F2A24419A9999F929335A4133333333FA292441333333132F335A41CDCCCCCCE12924419A99997932335A419A999999F7292441CDCCCC2C36335A4166666666102A2441666666663A335A41CDCCCCCC1C2A2441333333133C335A41666666662E2A2441666666A63D335A41CDCCCCCC572A24410000004040335A4100000000872A24416666668642335A41CDCCCCCC9C2A24419A9999D943335A4166666666B82A24413333331344335A419A999999C82A24416666660644335A4133333333DC2A24416666668643335A4100000000EF2A2441CDCCCC6C42335A4133333333FD2A2441CDCCCC4C41335A4100000000042B24410000006040335A4166666666102B2441333333733E335A419A9999991D2B2441000000A03D335A4166666666362B2441666666863C335A41333333334C2B2441CDCCCCCC3B335A4133333333622B2441333333D33B335A419A999999782B24419A9999593C335A4133333333922B2441666666A63C335A419A999999AB2B2441666666663C335A4133333333BE2B2441333333733B335A4166666666C72B24419A9999593A335A4100000000FA2B2441333333133D335A41CDCCCCCC0A2C2441666666A63D335A41CDCCCCCC102C2441000000C03E335A419A9999991E2C2441CDCCCC6C40335A41333333337C2C2441000000003B335A41000000005A2C24413333335330335A41CDCCCCCC4D2C2441CDCCCC8C2C335A41CDCCCCCC4A2C2441CDCCCC8C2B335A4133333333312C2441000000C022335A4133333333282C2441666666A61F335A4133333333192C2441333333B320335A41CDCCCCCCE12B24419A99993924335A4133333333B12B24419A99997927335A419A9999999F2B24419A99991928335A4100000000952B2441333333D327335A41000000008C2B24419A99993927335A419A999999802B24419A99999925335A419A999999602B2441CDCCCC2C1F335A41CDCCCCCC3F2B24410000002018335A41CDCCCCCC1E2B24410000002011335A4166666666082B2441CDCCCCEC0B335A4166666666FC2A24419A99991909335A41CDCCCCCCDE2A2441CDCCCCACFD325A4100000000DA2A24419A999959FB325A4133333333CA2A2441000000E0F3325A4133333333C42A244133333393E9325A4166666666BE2A244133333333E6325A4133333333AE2A244133333393E0325A419A999999562A2441CDCCCC4CE3325A4133333333EB29244133333373E6325A41CDCCCCCCC62924419A9999D9E7325A4166666666B429244166666686E9325A4166666666AC29244166666606EB325A419A999999AB29244133333353EC325A4166666666AB292441666666C6EC325A41	01060000206A080000010000000103000000010000001B00000066666666AB292441666666C6EC325A41CDCCCCCCFA292441CDCCCC4C13335A41CDCCCCCC092A24410000008018335A4100000000612A2441333333D320335A41CDCCCCCCE12924419A99997932335A41666666662E2A2441666666A63D335A41CDCCCCCC9C2A24419A9999D943335A4133333333DC2A24416666668643335A4166666666102B2441333333733E335A41333333334C2B2441CDCCCCCC3B335A419A999999AB2B2441666666663C335A4166666666C72B24419A9999593A335A41CDCCCCCC0A2C2441666666A63D335A419A9999991E2C2441CDCCCC6C40335A41333333337C2C2441000000003B335A4133333333282C2441666666A61F335A4133333333B12B24419A99997927335A41000000008C2B24419A99993927335A419A999999602B2441CDCCCC2C1F335A4166666666FC2A24419A99991909335A4133333333CA2A2441000000E0F3325A4133333333C42A244133333393E9325A4133333333AE2A244133333393E0325A4133333333EB29244133333373E6325A4166666666B429244166666686E9325A4166666666AB292441666666C6EC325A4166666666AB292441666666C6EC325A41	01010000206A0800009C21C83A8E2A24416666663612335A41	930080109	H	Édouard Vaillant 4	9300801	93008	93	11	0
01060000206A08000001000000010300000001000000CF00000066666666C5272441000000407B325A4100000000D02724413333337382325A419A999999DA2724419A9999D987325A4100000000E3272441CDCCCCAC8B325A4100000000F8272441CDCCCC8C95325A4133333333FC2724416666662697325A41333333330A282441CDCCCCCC98325A413333333319282441CDCCCC0C9F325A4100000000312824419A999959AA325A41333333333B282441000000C0AE325A41333333334C28244133333313B6325A41666666664E28244166666626B7325A41000000006228244100000040C0325A4100000000772824419A999919CA325A41CDCCCCCC7828244100000000CB325A41333333338E282441666666A6D0325A41CDCCCCCCA0282441666666C6D4325A419A999999A328244100000060D5325A419A999999B328244100000040D8325A4100000000C5282441CDCCCC8CDC325A4133333333F028244100000060E6325A4166666666FE28244166666686E9325A416666666608292441000000C0EB325A419A999999272924419A999979F8325A41CDCCCCCC5A292441000000A00F335A41CDCCCCCC7D292441333333931D335A413333333386292441666666E61F335A419A99999997292441333333B323335A419A9999999F292441CDCCCCAC25335A41CDCCCCCCB7292441000000A02B335A4166666666C5292441666666662E335A4166666666D12924416666664630335A41CDCCCCCCE12924419A99997932335A4133333333FA292441333333132F335A41000000001F2A24419A9999F929335A41CDCCCCCC482A2441CDCCCC2C24335A4100000000612A2441333333D320335A4100000000552A24419A9999B91F335A4166666666332A2441333333931C335A41000000002C2A2441666666E61B335A41CDCCCCCC092A24410000008018335A419A999999032A24416666660617335A41CDCCCCCCFA292441CDCCCC4C13335A4133333333B629244166666666F2325A419A999999B1292441CDCCCC2CF1325A4166666666AD292441333333B3EE325A4166666666AB292441666666C6EC325A419A999999AB29244133333353EC325A4166666666AC29244166666606EB325A4166666666B429244166666686E9325A41CDCCCCCCC62924419A9999D9E7325A4133333333EB29244133333373E6325A419A999999562A2441CDCCCC4CE3325A4133333333AE2A244133333393E0325A4166666666BE2A244133333333E6325A4133333333C42A244133333393E9325A4133333333CA2A2441000000E0F3325A4100000000DA2A24419A999959FB325A41CDCCCCCCDE2A2441CDCCCCACFD325A4166666666FC2A24419A99991909335A4166666666082B2441CDCCCCEC0B335A41CDCCCCCC1E2B24410000002011335A41CDCCCCCC3F2B24410000002018335A419A999999602B2441CDCCCC2C1F335A419A999999802B24419A99999925335A41000000008C2B24419A99993927335A4100000000952B2441333333D327335A419A9999999F2B24419A99991928335A4133333333B12B24419A99997927335A41CDCCCCCCE12B24419A99993924335A4133333333192C2441333333B320335A4133333333282C2441666666A61F335A4133333333312C2441000000C022335A41333333333E2C24413333331322335A4100000000432C2441000000A021335A41333333334B2C24413333339320335A4133333333622C2441000000C01C335A41000000006F2C2441000000401B335A41CDCCCCCC882C24419A99993919335A4166666666982C24416666668618335A4166666666AB2C2441CDCCCC2C18335A41CDCCCCCCD42C24419A9999F916335A419A999999EC2C24410000000016335A41CDCCCCCCFF2C24416666660615335A41CDCCCCCC122D2441CDCCCCCC13335A4133333333252D24413333339312335A4166666666322D24416666666611335A4133333333392D24413333339310335A41000000003A2D24410000002010335A41333333333B2D2441333333930F335A41333333333A2D2441000000A00E335A419A999999352D24419A9999990D335A41333333332E2D2441333333330B335A41666666664E2D2441333333F309335A4166666666552D24410000006009335A4166666666602D2441666666C607335A419A999999632D2441CDCCCCCC06335A4166666666652D24413333339304335A4166666666642D24416666664603335A41666666665E2D24410000002001335A4100000000512D24419A999919FE325A419A999999482D244166666626FD325A419A999999462D2441666666A6FA325A4133333333472D244166666666F8325A41000000004A2D244166666666F6325A41CDCCCCCC4C2D2441666666E6F4325A419A999999532D244100000060F3325A419A9999995C2D244100000020F2325A4166666666672D24419A9999B9F0325A4133333333752D2441333333B3EF325A4100000000902D244166666646EE325A41000000009C2D244100000020EE325A4133333333A72D2441CDCCCCECED325A419A999999A82D2441666666E6ED325A4166666666B62D2441CDCCCCECEC325A419A999999BE2D2441333333F3EA325A4166666666C42D244133333333E7325A4100000000C82D2441333333F3E5325A4100000000CF2D244166666666E4325A419A999999D52D2441CDCCCCACE2325A419A999999CC2D2441333333F3DB325A41CDCCCCCCEB2D24419A999959DB325A41CDCCCCCCFC2D2441333333D3DA325A419A9999990E2E2441000000E0D9325A419A999999312E24419A9999B9D8325A41CDCCCCCC4D2E24419A999939D8325A419A9999994C2E244100000060D7325A4133333333352E2441333333F3C6325A41CDCCCCCC142E24419A999979B0325A4166666666152E244133333373AE325A4100000000252E244133333333B0325A419A9999991D2E244166666686AD325A41000000001C2E244100000040AC325A419A999999192E2441CDCCCC8CAA325A419A999999172E244133333313A9325A41333333330B2E24419A999919A0325A4133333333082E2441333333139D325A4166666666062E2441666666E69B325A4133333333062E2441CDCCCCAC9B325A41CDCCCCCC042E2441333333939A325A419A999999012E24410000004098325A4133333333012E24410000000098325A419A999999FF2D2441000000A096325A419A999999FC2D2441CDCCCC6C94325A419A999999F92D24413333333392325A4133333333F92D2441CDCCCC0C92325A4166666666F82D2441CDCCCCAC91325A41CDCCCCCCF52D2441000000808F325A4133333333F42D2441000000408E325A4100000000F42D2441333333138E325A4166666666F22D2441666666068D325A4166666666ED2D2441CDCCCC4C89325A4133333333ED2D24416666662689325A4166666666E82D24419A99999985325A419A999999E62D2441CDCCCC2C84325A4133333333DE2D2441CDCCCC0C7E325A419A999999DD2D2441666666A67D325A4100000000DA2D2441666666067B325A419A999999D92D24419A9999997A325A41CDCCCCCCD52D2441333333D377325A41CDCCCCCCD12D24410000000075325A4166666666D12D2441000000A074325A4100000000D02D24410000008073325A41CDCCCCCCCE2D2441666666A672325A4100000000C52D2441333333736B325A4133333333C32D2441000000206A325A4100000000722D24410000002067325A41666666666E2D24410000000067325A419A9999994F2D2441CDCCCC0C66325A419A999999472D24416666666669325A4100000000472D2441666666A669325A41CDCCCCCC402D24419A9999596C325A41CDCCCCCC312D2441666666C66C325A41333333332D2D2441000000E06C325A4166666666282D2441000000006D325A4166666666052D2441333333F36D325A4166666666FC2C2441333333336E325A4166666666E42C2441333333D36E325A41333333337B2C2441000000406E325A4100000000682C2441000000206E325A4166666666312C2441333333D36D325A4166666666F72B2441000000806D325A4166666666992B2441333333F36C325A4133333333982B2441333333F36C325A4133333333722B2441000000C06C325A41CDCCCCCC422B24419A9999796C325A4100000000182B24419A9999396C325A41CDCCCCCC162B24419A9999396C325A41666666660E2B2441CDCCCC2C6C325A41333333330B2B2441666666266C325A4166666666B52A24419A9999D96B325A41CDCCCCCC802A2441000000406C325A4166666666562A2441333333936C325A41CDCCCCCC0A2A2441000000206D325A4166666666092A2441666666266D325A419A999999FF292441333333336D325A419A999999B92924419A9999B96D325A4166666666862924419A9999196E325A419A9999995E2924419A9999F96E325A4166666666012924410000000071325A41CDCCCCCCBE282441CDCCCCCC71325A4100000000B0282441333333F371325A4133333333B32824419A9999B974325A416666666619282441CDCCCCAC79325A41CDCCCCCCFC2724419A9999397A325A41CDCCCCCCC62724419A9999397B325A4166666666C5272441000000407B325A41	01060000206A080000010000000103000000010000003300000066666666C5272441000000407B325A4133333333FC2724416666662697325A41333333330A282441CDCCCCCC98325A41CDCCCCCC7828244100000000CB325A416666666608292441000000C0EB325A41CDCCCCCC5A292441000000A00F335A41CDCCCCCC7D292441333333931D335A41CDCCCCCCB7292441000000A02B335A41CDCCCCCCE12924419A99997932335A4100000000612A2441333333D320335A41CDCCCCCC092A24410000008018335A41CDCCCCCCFA292441CDCCCC4C13335A4166666666AB292441666666C6EC325A4166666666B429244166666686E9325A4133333333EB29244133333373E6325A4133333333AE2A244133333393E0325A4133333333C42A244133333393E9325A4133333333CA2A2441000000E0F3325A4166666666FC2A24419A99991909335A419A999999602B2441CDCCCC2C1F335A41000000008C2B24419A99993927335A4133333333B12B24419A99997927335A4133333333282C2441666666A61F335A4133333333312C2441000000C022335A41CDCCCCCC882C24419A99993919335A41CDCCCCCCFF2C24416666660615335A4133333333392D24413333339310335A41333333332E2D2441333333330B335A4166666666602D2441666666C607335A4166666666642D24416666664603335A419A999999482D244166666626FD325A41CDCCCCCC4C2D2441666666E6F4325A4166666666672D24419A9999B9F0325A4166666666B62D2441CDCCCCECEC325A419A999999D52D2441CDCCCCACE2325A419A999999CC2D2441333333F3DB325A41CDCCCCCC4D2E24419A999939D8325A41CDCCCCCC142E24419A999979B0325A419A9999991D2E244166666686AD325A4133333333C32D2441000000206A325A419A9999994F2D2441CDCCCC0C66325A41CDCCCCCC402D24419A9999596C325A4166666666E42C2441333333D36E325A4166666666B52A24419A9999D96B325A4166666666862924419A9999196E325A4166666666012924410000000071325A4100000000B0282441333333F371325A4133333333B32824419A9999B974325A416666666619282441CDCCCCAC79325A4166666666C5272441000000407B325A4166666666C5272441000000407B325A41	01010000206A08000006734C3F612B2441333333D3CD325A41	930080110	H	Édouard Vaillant 5	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000003C00000033333333401F2441333333D3A4325A4166666666451F2441666666C6B7325A41CDCCCCCC621F244133333393CD325A41333333339F1F244133333333E4325A4100000000C91F244133333333E4325A41333333330720244100000040E9325A41333333333A202441666666E6E9325A4166666666342124419A999999DA325A4166666666DC2124419A999979D1325A41CDCCCCCCED22244100000040C3325A41CDCCCCCC20232441000000A0BF325A41000000003323244166666666B9325A410000000048232441333333D3BC325A41000000007B232441CDCCCC0CBE325A4100000000A12324419A9999D9BA325A4133333333AD2324419A9999D9B6325A4166666666A32324419A999959B1325A41CDCCCCCCBB232441CDCCCC4CAE325A4166666666242424419A999979AA325A41000000007B24244133333393AF325A41CDCCCCCCA6242441CDCCCCCCAE325A419A999999292524419A999999A9325A4100000000AA2524419A9999F9A5325A4166666666B5252441666666A6A9325A41333333334B262441CDCCCCCCA4325A41CDCCCCCC13272441333333339F325A4133333333FC2724416666662697325A4166666666C5272441000000407B325A416666666619282441CDCCCCAC79325A4133333333B32824419A9999B974325A4100000000A82824416666662669325A41CDCCCCCC1C282441CDCCCCCC6A325A41CDCCCCCC7E272441333333336B325A41CDCCCCCCEF2624410000002069325A4166666666402524419A9999D959325A41666666661F2424413333331350325A41CDCCCCCCD7232441333333134A325A419A999999B6232441CDCCCC8C49325A41CDCCCCCC9D232441666666864C325A41000000006F2324419A9999995F325A4100000000892324419A9999F95A325A4133333333B4232441CDCCCC4C58325A41CDCCCCCCFA2324419A99997959325A41000000004C2524410000008065325A419A9999998C2524410000004068325A41666666669B252441666666866B325A410000000075252441000000607F325A4166666666652524410000002082325A410000000002252441333333B38A325A4100000000B62424419A9999198D325A419A999999EC232441666666668D325A4133333333A72324419A9999D996325A41CDCCCCCC4D2324419A9999B996325A4100000000FC2224410000002095325A41666666669A2124416666668695325A4166666666412124413333335398325A419A9999997C1F24419A9999B998325A4133333333631F2441CDCCCC6C9A325A4133333333401F2441333333D3A4325A4133333333401F2441333333D3A4325A41	01010000206A080000B88167928C232441343333E399325A41	930080111	H	Préfecture 1	9300801	93008	93	11	0
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	01060000206A08000001000000010300000001000000230000009A9999993F1F24419A9999F93E325A4166666666441F2441333333B34B325A41CDCCCCCC4E1F2441CDCCCC6C4F325A4100000000591F2441CDCCCC8C5D325A41333333336A1F24410000006063325A4100000000E7202441CDCCCC4C62325A419A99999928212441CDCCCCAC62325A416666666641212441333333F365325A413333333347212441000000007C325A416666666647212441333333F390325A41333333335D212441CDCCCC2C97325A41666666669A2124416666668695325A4100000000FC2224410000002095325A41CDCCCCCC4D2324419A9999B996325A4133333333A72324419A9999D996325A419A999999EC232441666666668D325A4100000000B62424419A9999198D325A410000000002252441333333B38A325A4166666666652524410000002082325A410000000075252441000000607F325A41666666669B252441666666866B325A419A9999998C2524410000004068325A41000000004C2524410000008065325A41CDCCCCCCFA2324419A99997959325A4133333333B4232441CDCCCC4C58325A4100000000892324419A9999F95A325A41000000006F2324419A9999995F325A419A99999997232441000000404F325A4166666666CA2224419A99993948325A410000000016222441000000E043325A419A9999993E212441666666C63F325A4133333333E8202441CDCCCCEC3E325A4100000000F11F2441333333533E325A419A9999993F1F24419A9999F93E325A419A9999993F1F24419A9999F93E325A41	01010000206A08000074C91E946E232441666666D66A325A41	930080112	H	Préfecture 2	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000001900000066666666511C2441CDCCCCEC8E325A41CDCCCCCC521C2441CDCCCC8C92325A4133333333081D24413333337393325A41000000004D1E24410000006097325A4166666666401F2441333333D398325A4166666666412124413333335398325A41333333335D212441CDCCCC2C97325A416666666647212441333333F390325A413333333347212441000000007C325A416666666641212441333333F365325A419A99999928212441CDCCCCAC62325A4100000000E7202441CDCCCC4C62325A41333333336A1F24410000006063325A419A999999541F24410000008058325A4133333333431F24410000004058325A4133333333221F2441CDCCCC8C51325A4166666666FE1E2441333333F34F325A41CDCCCCCCBF1E24416666666650325A41CDCCCCCC9E1E2441333333B353325A4100000000941E2441333333935C325A419A999999991E2441666666866F325A4166666666711C24419A99993971325A41CDCCCCCC5E1C2441333333F374325A4166666666511C2441CDCCCCEC8E325A4166666666511C2441CDCCCCEC8E325A41	01010000206A08000065290E79D21E24419A9999F973325A41	930080113	H	Préfecture 3	9300801	93008	93	11	0
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	01060000206A0800000100000001030000000100000019000000333333331F1C24419A9999B992325A419A999999641C24419A999919B7325A41CDCCCCCCB51C24419A999979DC325A41000000002C1D24419A9999B9D8325A4100000000441D244133333373DA325A4166666666901D244166666606FF325A41CDCCCCCCC51D2441666666260C335A41CDCCCCCC541E2441CDCCCCCC04335A41CDCCCCCC5C1E24419A99993901335A4133333333261F24419A999999F6325A4166666666841F24419A9999B9F3325A4133333333C41F2441333333B3F4325A41CDCCCCCCF61F24419A999999ED325A4166666666F41F24419A999979E9325A4100000000C91F244133333333E4325A41333333339F1F244133333333E4325A41CDCCCCCC621F244133333393CD325A4166666666451F2441666666C6B7325A4133333333401F2441333333D3A4325A4133333333631F2441CDCCCC6C9A325A4166666666401F2441333333D398325A41000000004D1E24410000006097325A4133333333081D24413333337393325A41333333331F1C24419A9999B992325A41333333331F1C24419A9999B992325A41	01010000206A08000007185466021E244133333313D0325A41	930080114	H	Préfecture 4	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000002500000066666666B8172441000000A005335A41CDCCCCCC531824413333339313335A413333333391182441000000401B335A41000000008B182441CDCCCCCC1D335A413333333329192441666666862A335A4166666666C61924410000002038335A4133333333E7192441666666263C335A41CDCCCCCC181A2441CDCCCC6C3B335A41666666663A1A2441000000A03D335A4100000000491A2441CDCCCCEC44335A4133333333621A24410000006044335A4100000000B71A2441333333733D335A41CDCCCCCCEB1B2441000000C029335A419A9999992D1C24410000000026335A41CDCCCCCCFF1B24419A9999391A335A4100000000B31B2441666666E6F6325A4133333333D11C2441666666C6E9325A419A999999B31C244133333373DB325A419A999999B11C2441666666A6DF325A419A999999ED1B24419A999919E9325A4166666666BA1B244100000060EA325A41666666669B1B2441CDCCCCECDB325A419A999999C21A244133333393E3325A419A999999411B2441666666C6A5325A41CDCCCCCC6D1B24413333337396325A4166666666481B24416666666692325A4133333333AF1A2441CDCCCC6C95325A4100000000831924419A9999799A325A4100000000C9182441333333F39C325A413333333306182441CDCCCC8CAE325A41333333335818244100000080B8325A41666666669718244166666606D7325A41CDCCCCCC851824419A9999F9E3325A4100000000A8182441CDCCCC6CEE325A4166666666D817244133333353FD325A4166666666B8172441000000A005335A4166666666B8172441000000A005335A41	01010000206A080000302CF4E39D1A244166666636EC325A41	930080115	H	Bourse du Travail 2	9300801	93008	93	11	0
01060000206A0800000200000001030000000100000019000000000000009B1B2441333333F3DB325A41666666669B1B2441CDCCCCECDB325A4166666666BA1B244100000060EA325A4133333333D91B2441000000A0E9325A419A999999ED1B24419A999919E9325A419A999999B11C2441666666A6DF325A41CDCCCCCCB11C244100000040DF325A419A999999B31C244133333373DB325A41CDCCCCCC831C244133333313C5325A419A999999641C24419A999919B7325A41333333331F1C24419A9999B992325A419A999999BD1B2441333333D392325A4100000000921B24410000000093325A41333333338A1B2441666666E692325A4133333333881B24419A9999F993325A41CDCCCCCC6D1B24413333337396325A4100000000681B24419A99995997325A419A9999995E1B24419A9999199A325A4100000000581B2441CDCCCC6C9C325A41CDCCCCCC431B2441000000E0A4325A419A999999411B2441666666C6A5325A4100000000041B24419A999999C3325A4100000000E31A244166666606D3325A419A999999C21A244133333393E3325A41000000009B1B2441333333F3DB325A410103000000010000002300000000000000D21B24416666664606335A41CDCCCCCCFF1B24419A9999391A335A41666666660B1C2441666666A61D335A419A9999992D1C24410000000026335A4133333333381C24410000006025335A41CDCCCCCC721C2441666666A621335A41333333337D1C24410000000021335A4100000000D91C2441666666261B335A4166666666E11C24419A9999991A335A41CDCCCCCC1E1D2441333333B316335A419A999999591D24419A9999D912335A4166666666621D24416666664612335A41CDCCCCCC891D2441000000E00F335A4100000000B51D24419A9999190D335A41CDCCCCCCC51D2441666666260C335A41CDCCCCCC9A1D2441CDCCCCCC01335A4166666666901D244166666606FF325A41CDCCCCCC851D244133333313FA325A4100000000761D244100000080F2325A4100000000661D2441CDCCCCACEB325A4133333333531D244133333393E2325A4100000000481D244166666626DC325A4100000000441D244133333373DA325A41000000003E1D244133333373DA325A4100000000341D244133333333DA325A41000000002C1D24419A999939D9325A41000000002C1D24419A9999B9D8325A41CDCCCCCCB51C24419A999979DC325A4166666666BB1C244133333333DF325A4166666666BF1C24419A999919E1325A4133333333D11C2441666666C6E9325A4166666666731C2441CDCCCC0CEE325A4166666666151C2441CDCCCC8CF2325A4100000000B31B2441666666E6F6325A4100000000D21B24416666664606335A41	01060000206A080000020000000103000000010000000D000000000000009B1B2441333333F3DB325A4166666666BA1B244100000060EA325A419A999999ED1B24419A999919E9325A419A999999B11C2441666666A6DF325A419A999999B31C244133333373DB325A419A999999641C24419A999919B7325A41333333331F1C24419A9999B992325A41333333338A1B2441666666E692325A4100000000681B24419A99995997325A419A999999411B2441666666C6A5325A419A999999C21A244133333393E3325A41000000009B1B2441333333F3DB325A41000000009B1B2441333333F3DB325A410103000000010000000C00000000000000D21B24416666664606335A41CDCCCCCCFF1B24419A9999391A335A419A9999992D1C24410000000026335A41CDCCCCCCC51D2441666666260C335A4166666666901D244166666606FF325A4100000000441D244133333373DA325A41000000002C1D24419A9999B9D8325A41CDCCCCCCB51C24419A999979DC325A4133333333D11C2441666666C6E9325A4100000000B31B2441666666E6F6325A4100000000D21B24416666664606335A4100000000D21B24416666664606335A41	01010000206A0800003E62CCE3AD1C24419A99996900335A41	930080116	H	Bourse du Travail 3	9300801	93008	93	11	0
01060000206A080000010000000103000000010000003700000033333333B9182441CDCCCC2C86325A41CDCCCCCCC6182441666666A689325A4100000000C9182441333333F39C325A4133333333E5182441333333D39C325A4133333333E9182441666666C69C325A413333333313192441000000209C325A41CDCCCCCC12192441666666269C325A419A9999997F192441666666869A325A413333333381192441666666869A325A4100000000831924419A9999799A325A4100000000DC192441333333F398325A4133333333F81924413333337398325A41666666663C1A24419A99995997325A4100000000581A2441333333D396325A41333333336C1A24419A99997996325A4133333333AF1A2441CDCCCC6C95325A419A999999D91A24410000006094325A4133333333FB1A24416666668693325A419A999999191B2441000000E092325A4166666666481B24416666666692325A41666666664D1B24413333337394325A41CDCCCCCC511B2441CDCCCC2C95325A41333333335C1B2441CDCCCC4C96325A41CDCCCCCC5C1B24410000006096325A41CDCCCCCC651B24413333339396325A41CDCCCCCC6D1B24413333337396325A4133333333721B2441333333738E325A419A9999998F1B24413333333381325A4133333333951B2441000000807E325A4100000000A01B2441CDCCCC2C79325A4166666666B11B2441CDCCCC8C70325A4100000000B41B24419A9999596F325A4100000000D61B2441000000C05E325A4133333333E71B2441CDCCCC6C56325A4133333333F21B24416666660651325A4133333333F41B2441000000E04F325A4100000000F91B24419A9999394D325A41CDCCCCCCF91B24419A9999B94B325A419A999999FB1B24416666660649325A41CDCCCCCCE41B2441333333F34B325A41CDCCCCCCD61B2441333333134D325A4166666666761B24416666668650325A419A9999992D1B2441666666A653325A41CDCCCCCCDC1A24419A99999957325A419A999999991A24419A9999195B325A41000000006D1A2441000000C05D325A4166666666311A24413333331362325A41CDCCCCCC0A1A2441000000A064325A419A999999C4192441000000206A325A410000000096192441CDCCCCEC6D325A4133333333831924416666660670325A4100000000401924413333339376325A4100000000F1182441333333537F325A4100000000BD182441333333B385325A4133333333B9182441CDCCCC2C86325A41	01060000206A080000010000000103000000010000001300000033333333B9182441CDCCCC2C86325A41CDCCCCCCC6182441666666A689325A4100000000C9182441333333F39C325A4100000000831924419A9999799A325A4133333333AF1A2441CDCCCC6C95325A4166666666481B24416666666692325A41CDCCCCCC6D1B24413333337396325A4133333333721B2441333333738E325A419A9999998F1B24413333333381325A4133333333F21B24416666660651325A419A999999FB1B24416666660649325A41CDCCCCCCD61B2441333333134D325A419A9999992D1B2441666666A653325A419A999999991A24419A9999195B325A41CDCCCCCC0A1A2441000000A064325A410000000096192441CDCCCCEC6D325A4100000000401924413333339376325A4133333333B9182441CDCCCC2C86325A4133333333B9182441CDCCCC2C86325A41	01010000206A080000BC905F1D851A24410000009073325A41	930080117	H	Bourse du Travail 4	9300801	93008	93	11	0
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	01060000206A0800000100000001030000000100000017000000CDCCCCCC6D1B24413333337396325A41333333338A1B2441666666E692325A41CDCCCCCC521C2441CDCCCC8C92325A41CDCCCCCC5E1C2441333333F374325A4166666666711C24419A99993971325A419A999999991E2441666666866F325A4100000000941E2441333333935C325A41CDCCCCCC9E1E2441333333B353325A41CDCCCCCCBF1E24416666666650325A4166666666FE1E2441333333F34F325A4133333333221F2441CDCCCC8C51325A4133333333431F24410000004058325A419A999999541F24410000008058325A4166666666441F2441333333B34B325A419A9999993F1F24419A9999F93E325A4133333333631E2441CDCCCC8C41325A4166666666661D24413333333346325A4166666666A71C2441333333534B325A4133333333F21B24416666660651325A419A9999998F1B24413333333381325A4133333333721B2441333333738E325A41CDCCCCCC6D1B24413333337396325A41CDCCCCCC6D1B24413333337396325A41	01010000206A080000AB5977EC291D2441000000C06B325A41	930080118	H	Préfecture 5	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000001B0000009A999999CE192441666666C6C2315A41666666661A1A24419A999999EB315A4133333333371A2441CDCCCC0CF9315A4166666666B31A2441CDCCCCAC19325A419A9999994E1B2441666666A640325A41CDCCCCCC6F1B24419A99993945325A419A999999FB1B24416666660649325A4133333333F21B24416666660651325A4166666666A71C2441333333534B325A4166666666661D24413333333346325A4133333333631E2441CDCCCC8C41325A419A9999993F1F24419A9999F93E325A41CDCCCCCC391F2441000000C024325A4133333333321F2441CDCCCC2C20325A41CDCCCCCC0A1F24413333339317325A4166666666E61E2441000000C013325A419A999999651E2441666666A60B325A4166666666E21C2441333333B3F0315A41CDCCCCCC601D2441666666A6E7315A419A999999851D244166666666E3315A41CDCCCCCCF91C2441666666C6D5315A41CDCCCCCC051D244166666626CF315A4166666666261B2441666666A6BD315A419A9999992F1B2441CDCCCCECC6315A4100000000FC19244100000000C2315A419A999999CE192441666666C6C2315A419A999999CE192441666666C6C2315A41	01010000206A080000D11FD7BD501C2441333333F307325A41	930080119	H	Les Vignes 4	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000001B00000033333333870C24419A99993992335A41CDCCCCCC470D2441333333F382335A41CDCCCCCCC00D24419A9999B9A0335A4133333333490F2441000000A08A335A41666666669C0E24413333335358335A4133333333DA0F24410000008047335A4166666666C50F2441666666A63F335A4133333333660F2441CDCCCC6C23335A419A999999370F24416666668624335A419A9999990F0F2441CDCCCCCC19335A4166666666BD0E24419A9999D91B335A419A999999620E24410000006002335A4166666666430E24419A999959F8325A4133333333C10D2441666666C601335A4133333333500D2441000000800C335A4133333333840D2441CDCCCC0C16335A4133333333EF0D2441666666C62E335A41CDCCCCCCE40D24419A9999B931335A41000000006F0D2441666666A63A335A419A9999994F0D24410000004042335A4133333333290D2441666666E650335A4100000000F50C24419A9999F957335A41CDCCCCCCDB0C24419A9999995D335A4166666666C60C24419A99997970335A41CDCCCCCC990C2441CDCCCCCC8D335A4133333333870C24419A99993992335A4133333333870C24419A99993992335A41	01010000206A080000F5302994730E2441CDCCCC1C4A335A41	930080120	H	Les Vignes 5	9300801	93008	93	11	0
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	01060000206A080000010000000103000000010000001C0000009A999999B12C244100000080CE315A4100000000E72C2441CDCCCC8CF0315A4166666666002D24419A999979FD315A41333333333A2D2441333333B310325A41000000007F2D24410000008024325A4166666666952D2441666666862E325A41000000009B2D24419A9999B948325A419A9999994F2D2441CDCCCC0C66325A4133333333C32D2441000000206A325A4133333333FD2D2441CDCCCC4C70325A4100000000692E2441333333F372325A41CDCCCCCC4E2E24419A99993966325A4100000000302F24416666668665325A4133333333AC2F24410000008067325A419A9999996E302441CDCCCCAC6C325A4133333333BB3024410000006070325A413333333320312441333333B373325A419A999999373124419A9999B96B325A416666666643312441CDCCCC8C3F325A419A999999CA3024416666662642325A41CDCCCCCC303024419A9999790B325A4166666666952F24419A999919D6315A41CDCCCCCCA630244100000020C9315A41333333335C312441000000009C315A416666666646312441000000809B315A419A999999792F244166666606AA315A419A999999B12C244100000080CE315A419A999999B12C244100000080CE315A41	01010000206A080000C15E3CBFA42E24416666668608325A41	930100201	H	Le Mainguy	9301002	93010	93	11	0
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	01060000206A080000010000000103000000010000003500000033333333912E24419A9999D9BA325A4100000000E12E244133333373D1325A41CDCCCCCC122F244100000020DE325A419A999999A02F244100000000FC325A4166666666EE2F2441666666A612335A410000000021302441000000401D335A4133333333A3302441CDCCCC0C32335A419A999999D03024413333339341335A4133333333CF302441000000E049335A4166666666BB302441CDCCCC6C52335A413333333391302441666666665F335A41CDCCCCCC87302441000000A078335A413333333375302441000000E094335A410000000066302441CDCCCCCCB1335A41000000007130244100000000B7335A419A9999998D302441333333F3BA335A41000000006C3024419A999979C1335A41CDCCCCCCCF2F244133333353D8335A4100000000CD2F244166666666D9335A419A9999993C30244133333373DF335A419A999999C430244166666606E8335A4133333333C230244133333373EC335A419A99999955312441333333F30C345A4133333333BC322441CDCCCCEC03345A41CDCCCCCCB1322441000000C0FC335A4100000000AC322441CDCCCC8CE2335A419A999999B43224419A9999B9D8335A41CDCCCCCC5533244133333353D6335A41333333334634244133333313D2335A41CDCCCCCC51342441666666A6DB335A41000000001436244133333373C8335A41CDCCCCCCF7352441000000A0C2335A419A999999C335244100000060C0335A41CDCCCCCCC6352441333333F3BC335A41000000006E35244100000080BE335A4100000000D2322441666666E6CD335A4166666666C6322441000000A0D2335A419A999999A432244100000060D3335A41333333338A322441666666C6CF335A419A9999993A322441000000A0D1335A419A999999DE3124413333333396335A419A999999B1312441CDCCCCAC7A335A41000000008F3124419A9999F968335A41CDCCCCCC5E312441CDCCCC8C53335A41CDCCCCCC2B3124410000000040335A4100000000EA302441333333532A335A41CDCCCCCCB0302441CDCCCCAC19335A41333333334D30244133333393FF325A4166666666F72F2441333333D3EB325A4166666666732F24419A9999B9CE325A4133333333282F2441000000E0BC325A4133333333912E24419A9999D9BA325A4133333333912E24419A9999D9BA325A41	01010000206A08000012732E88073124410000001063335A41	930100101	H	La Flamiche	9301001	93010	93	11	0
01060000206A0800000100000001030000000100000028000000666666667B322441333333D396335A41333333338D3224413333339399335A419A99999990322441CDCCCC6C9A335A413333333391322441CDCCCC8C9A335A416666666692322441333333D39A335A416666666698322441000000009D335A4166666666B132244166666606AE335A41CDCCCCCCC53224419A9999D9BB335A4100000000CA322441333333B3BE335A4133333333CA322441CDCCCC8CC0335A419A999999C6322441CDCCCC6CC3335A4100000000C032244166666626C6335A419A999999B9322441666666A6CA335A41CDCCCCCCC3322441CDCCCC4CCB335A4166666666C93224419A9999D9CB335A4166666666CD3224419A999979CC335A4100000000D2322441666666E6CD335A410000000073332441CDCCCC2CCA335A41CDCCCCCCA9332441CDCCCCECC8335A4166666666503424419A999919C5335A4133333333E3342441333333B3C1335A41CDCCCCCC35352441333333D3BF335A410000000056352441CDCCCC0CBF335A41CDCCCCCC5F3524419A9999D9BE335A41000000006E35244100000080BE335A41CDCCCCCCC6352441333333F3BC335A419A999999D33524419A9999B9BB335A4133333333C635244133333313B9335A419A999999A7352441333333B3B2335A4133333333A035244133333393B0335A41CDCCCCCC7D3524419A9999B999335A419A999999783524419A99993996335A4133333333743524410000004093335A4100000000713524413333333391335A4100000000613524410000000086335A41CDCCCCCC80342441CDCCCC0C8B335A4166666666A03324416666662690335A4133333333C03224419A99993995335A41333333338D3224416666666696335A41666666667B322441333333D396335A41	01060000206A080000010000000103000000010000000B000000666666667B322441333333D396335A416666666698322441000000009D335A4100000000CA322441333333B3BE335A419A999999B9322441666666A6CA335A4100000000D2322441666666E6CD335A41000000006E35244100000080BE335A419A999999D33524419A9999B9BB335A4133333333A035244133333393B0335A4100000000613524410000000086335A41666666667B322441333333D396335A41666666667B322441333333D396335A41	01010000206A080000C2C70D391A34244133333383A5335A41	930100102	H	La Terre Saint-Blaise	9301001	93010	93	11	0
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	01060000206A080000010000000103000000010000001A000000CDCCCCCC5D302441CDCCCCEC03335A41CDCCCCCCB0302441CDCCCCAC19335A4100000000EA302441333333532A335A41CDCCCCCC2B3124410000000040335A41CDCCCCCC5E312441CDCCCC8C53335A41000000008F3124419A9999F968335A419A999999B1312441CDCCCCAC7A335A419A999999DE3124413333333396335A419A9999993A322441000000A0D1335A41333333338A322441666666C6CF335A419A999999A432244100000060D3335A4166666666C6322441000000A0D2335A4100000000D2322441666666E6CD335A419A999999B9322441666666A6CA335A4100000000CA322441333333B3BE335A416666666698322441000000009D335A4133333333643224410000002092335A41CDCCCCCC543224416666666688335A41000000006F322441CDCCCC4C7D335A41CDCCCCCC04322441CDCCCC8C37335A4133333333CB3124413333331338335A41CDCCCCCC9C3124419A99995934335A413333333366312441CDCCCC4C25335A41CDCCCCCCCF302441CDCCCC8CF7325A41CDCCCCCC5D302441CDCCCCEC03335A41CDCCCCCC5D302441CDCCCCEC03335A41	01010000206A080000AF8727FDE93124413333331366335A41	930100103	H	Les Confins d'Aulnay	9301001	93010	93	11	0
01060000206A080000010000000103000000010000002E000000CDCCCCCC04322441CDCCCC8C37335A41CDCCCCCC30322441333333B354335A41CDCCCCCC313224410000006055335A4166666666373224416666664659335A419A99999938322441333333135A335A41666666663E322441333333D35D335A41CDCCCCCC4D322441000000A067335A4100000000483224413333339368335A410000000046322441333333B369335A419A999999463224419A9999996A335A41CDCCCCCC4C322441666666066C335A4133333333533224419A9999B96C335A413333333357322441333333F36C335A41666666666B322441000000C07A335A41000000006F322441CDCCCC4C7D335A4133333333603224416666664683335A41CDCCCCCC543224416666666688335A41CDCCCCCC5B322441666666C68D335A4133333333643224410000002092335A41333333336D322441CDCCCC6C94335A41666666667B322441333333D396335A41333333338D3224416666666696335A4133333333C03224419A99993995335A4166666666A03324416666662690335A41CDCCCCCC80342441CDCCCC0C8B335A4100000000613524410000000086335A413333333357352441000000407F335A419A999999423524419A9999B976335A41CDCCCCCC3D3524413333331375335A41CDCCCCCC353524416666662673335A4100000000FD3424419A9999396A335A419A999999E23424419A99991966335A4166666666DC3424410000002065335A4133333333D63424419A99991964335A419A999999AA3424419A9999195D335A41666666665F342441CDCCCC0C51335A41CDCCCCCC51342441333333F34D335A419A9999993D3424413333331348335A410000000021342441333333D340335A4166666666D1332441000000602B335A41CDCCCCCCA4332441666666A62D335A41000000005A332441000000802F335A4100000000F63224419A9999D931335A419A999999B9322441CDCCCC4C33335A41CDCCCCCC4E322441CDCCCCCC35335A41CDCCCCCC04322441CDCCCC8C37335A41	01060000206A080000010000000103000000010000000D000000CDCCCCCC04322441CDCCCC8C37335A41000000006F322441CDCCCC4C7D335A41CDCCCCCC543224416666666688335A4133333333643224410000002092335A41666666667B322441333333D396335A4100000000613524410000000086335A413333333357352441000000407F335A41CDCCCCCC353524416666662673335A41666666665F342441CDCCCC0C51335A4166666666D1332441000000602B335A41CDCCCCCCA4332441666666A62D335A41CDCCCCCC04322441CDCCCC8C37335A41CDCCCCCC04322441CDCCCC8C37335A41	01010000206A08000040CE7DFE82332441666666F660335A41	930100104	H	Suzanne Buisson	9301001	93010	93	11	0
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	01060000206A080000010000000103000000010000002200000066666666D1332441000000602B335A41666666665F342441CDCCCC0C51335A41CDCCCCCC353524416666662673335A413333333357352441000000407F335A4133333333A035244133333393B0335A419A999999D33524419A9999B9BB335A419A999999C335244100000060C0335A41CDCCCCCCF7352441000000A0C2335A4133333333883624419A999999E0335A4133333333FF372441333333F3DE335A419A999999FF372441000000E0DC335A419A99999940382441666666C6D1335A4133333333E53824419A999979BF335A416666666681392441666666E6BB335A41000000009239244166666606BD335A4166666666D039244100000080AE335A4133333333FA392441CDCCCCCC94335A41CDCCCCCC8A392441000000C04B335A41CDCCCCCC80392441CDCCCC6C41335A419A999999673924419A99997919335A419A999999643924419A9999D900335A41000000004B3924419A9999B9E7325A4100000000EC382441CDCCCC8CE4325A419A999999CC3824419A999959E2325A41000000005938244100000040DF325A419A999999B33724419A999999D8325A41CDCCCCCCCB3624419A999959D0325A41000000006D362441CDCCCC2CE8325A410000000014372441333333B301335A4166666666483624419A9999F907335A4133333333F83524419A9999F90A335A4133333333E7352441000000600D335A4166666666D1332441000000602B335A4166666666D1332441000000602B335A41	01010000206A0800001E33942A10372441CDCCCCDC56335A41	930100105	H	Le Château Gobillon	9301001	93010	93	11	1
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	01060000206A080000010000000103000000010000001F000000666666660633244166666666DE325A4166666666BE342441CDCCCC2CD7325A41CDCCCCCCB8342441CDCCCCCCE4325A41666666660B33244166666646EC325A41CDCCCCCC1F33244133333353F9325A4166666666D1332441000000602B335A4133333333E7352441000000600D335A4133333333F83524419A9999F90A335A4166666666483624419A9999F907335A410000000014372441333333B301335A41000000006D362441CDCCCC2CE8325A41CDCCCCCCCB3624419A999959D0325A419A999999B33724419A999999D8325A41000000005938244100000040DF325A419A999999CC3824419A999959E2325A4100000000EC382441CDCCCC8CE4325A413333333347392441333333B3E6325A419A999999F43824419A999919D3325A4166666666FE392441000000E0B2325A419A999999053A244100000020AC325A419A9999998A3924419A999919AA325A4100000000A0372441333333D39C325A413333333322372441666666C698325A4100000000AC352441000000C08E325A416666666637352441666666E68B325A4166666666B1342441333333738B325A413333333365342441000000008A325A410000000021332441666666C680325A41CDCCCCCC22332441666666E698325A41666666660633244166666666DE325A41666666660633244166666666DE325A41	01010000206A080000666C641EDF342441CDCCCCFCD5325A41	930100106	H	Les Merisiers	9301001	93010	93	11	0
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	01060000206A080000010000000103000000010000001500000033333333282F2441000000E0BC325A4166666666732F24419A9999B9CE325A4166666666F72F2441333333D3EB325A41CDCCCCCC5D302441CDCCCCEC03335A41CDCCCCCCCF302441CDCCCC8CF7325A413333333366312441CDCCCC4C25335A41CDCCCCCC9C3124419A99995934335A4133333333CB3124413333331338335A41CDCCCCCC04322441CDCCCC8C37335A41CDCCCCCCA4332441666666A62D335A4166666666D1332441000000602B335A41CDCCCCCC1F33244133333353F9325A41666666660B33244166666646EC325A41CDCCCCCCB8342441CDCCCCCCE4325A4166666666BE342441CDCCCC2CD7325A41666666660633244166666666DE325A416666666611332441CDCCCCCCC4325A41000000004F32244100000080C3325A416666666614302441666666A6BE325A4133333333282F2441000000E0BC325A4133333333282F2441000000E0BC325A41	01010000206A080000925A213704322441CDCCCC1CFC325A41	930100107	H	La Noue Caillet	9301001	93010	93	11	0
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	01060000206A080000010000000103000000010000001500000000000000C52D2441333333736B325A419A9999991D2E244166666686AD325A4100000000252E244133333333B0325A4100000000842E2441333333D3B8325A41CDCCCCCCB42E2441333333F3BB325A416666666614302441666666A6BE325A41000000004F32244100000080C3325A416666666611332441CDCCCCCCC4325A41CDCCCCCC22332441666666E698325A419A99999921332441333333B379325A419A999999373124419A9999B96B325A413333333320312441333333B373325A4133333333BB3024410000006070325A419A9999996E302441CDCCCCAC6C325A4133333333AC2F24410000008067325A4100000000302F24416666668665325A41CDCCCCCC4E2E24419A99993966325A4100000000692E2441333333F372325A4133333333FD2D2441CDCCCC4C70325A4100000000C52D2441333333736B325A4100000000C52D2441333333736B325A41	01010000206A080000DC81C6B6903024416666668695325A41	930100108	A	Le Parc du Château	9301001	93010	93	11	0
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	01060000206A0800000100000001030000000100000015000000CDCCCCCC303024419A9999790B325A419A999999CA3024416666662642325A416666666643312441CDCCCC8C3F325A419A999999373124419A9999B96B325A419A99999921332441333333B379325A41000000002A3324413333333353325A41CDCCCCCC223324413333331341325A41CDCCCCCC0C3324410000006035325A41333333331A3324416666662631325A41CDCCCCCC8B332441333333932C325A4100000000783324419A99997927325A410000000038332441666666A628325A4100000000F8322441333333330B325A4100000000323424419A999999FE315A4133333333C933244133333373D5315A4133333333E532244100000000DF315A41000000002032244166666626E4315A41333333332832244166666606F1315A41000000003B322441CDCCCCACF7315A41CDCCCCCC303024419A9999790B325A41CDCCCCCC303024419A9999790B325A41	01010000206A08000097EDFAB6DB312441000000F027325A41	930100202	H	Le Centre Ville	9301002	93010	93	11	0
01060000206A080000010000000103000000010000003800000066666666952F24419A999919D6315A4133333333BC2F2441333333F3E3315A4166666666DE2F2441000000C0EF315A419A999999DF2F2441CDCCCC2CF0315A41CDCCCCCCF42F244100000060F7315A41CDCCCCCC303024419A9999790B325A4133333333C0302441CDCCCC0C06325A4166666666C53024419A9999D905325A41CDCCCCCCC7302441000000C005325A410000000009312441CDCCCC4C03325A419A9999990A3124419A99993903325A4100000000323124419A9999B901325A41CDCCCCCC9C31244133333393FD315A41000000003B322441CDCCCCACF7315A41333333332E322441CDCCCC2CF3315A41333333332832244166666606F1315A41333333332432244166666626EF315A41333333332232244166666646EC315A41000000002032244166666626E4315A41CDCCCCCC2D32244133333333E4315A4100000000533224419A999939E3315A41CDCCCCCC9C322441333333F3E0315A4166666666C2322441CDCCCC0CE0315A4133333333E532244100000000DF315A419A999999043324419A9999D9DD315A419A99999922332441CDCCCCACDC315A41666666664333244100000020DB315A4133333333C933244133333373D5315A41333333338C33244166666686BD315A41000000006C332441666666E6B0315A41CDCCCCCC6A33244133333373B0315A419A99999969332441000000E0AF315A41000000003A332441000000C09C315A41CDCCCCCCCC322441333333B371315A41CDCCCCCC81322441CDCCCCAC73315A419A9999993E322441CDCCCC6C75315A4166666666D23124419A99993978315A416666666694312441CDCCCCEC79315A41CDCCCCCC3F3124419A9999397C315A410000000045312441000000C080315A416666666645312441CDCCCC2C81315A4100000000513124419A9999B98B315A4100000000513124419A9999D98B315A41333333335A312441CDCCCCAC94315A41CDCCCCCC5A3124413333335395315A41666666665D312441CDCCCCCC97315A41CDCCCCCC64312441333333739B315A41333333335C312441000000009C315A413333333354312441000000A09D315A41000000000431244133333313B2315A41CDCCCCCCDC30244166666646BB315A41CDCCCCCCA630244100000020C9315A41333333337F302441333333D3CA315A41000000006E30244133333393CB315A4100000000D52F24419A9999F9D2315A4166666666952F24419A999919D6315A41	01060000206A080000010000000103000000010000000E00000066666666952F24419A999919D6315A41CDCCCCCC303024419A9999790B325A41000000003B322441CDCCCCACF7315A41333333332832244166666606F1315A41000000002032244166666626E4315A4133333333E532244100000000DF315A4133333333C933244133333373D5315A41CDCCCCCCCC322441333333B371315A41CDCCCCCC3F3124419A9999397C315A41666666665D312441CDCCCCCC97315A413333333354312441000000A09D315A41CDCCCCCCA630244100000020C9315A4166666666952F24419A999919D6315A4166666666952F24419A999919D6315A41	01010000206A0800007C8967332C32244133333353C3315A41	930100203	H	Le Champart	9301002	93010	93	11	0
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	01060000206A080000010000000103000000010000002100000000000000DF2D2441000000A0AD305A4100000000042E244133333313B6305A4100000000392E244100000020C8305A4166666666772E2441CDCCCCECE7305A41333333339B2E2441CDCCCC0C03315A4100000000B22E24413333337311315A41333333331F2F24413333337329315A419A999999B62F24419A99995952315A4133333333CD2E2441666666865C315A41CDCCCCCCD02E24419A99999963315A41CDCCCCCCD52F244166666626A7315A416666666646312441000000809B315A41CDCCCCCC64312441333333739B315A41CDCCCCCC3F3124419A9999397C315A41CDCCCCCCCC322441333333B371315A413333333353322441666666464B315A419A999999BE322441CDCCCC0C48315A419A999999A4322441CDCCCC2C34315A4166666666A2322441333333132A315A41333333335F322441666666A6FC305A41CDCCCCCC53322441666666C6F1305A419A9999998931244133333313F5305A41CDCCCCCC7E3124419A9999F9E5305A41666666667D31244133333313D9305A41333333338E3124419A999919BB305A4133333333A3312441CDCCCC4CAC305A419A99999958312441666666E6A3305A41000000001E31244166666686A2305A4100000000BF302441CDCCCC6CA2305A41333333336E2E2441666666A6A8305A4166666666E12D244133333353AB305A4100000000DF2D2441000000A0AD305A4100000000DF2D2441000000A0AD305A41	01010000206A0800002C971E01CE3024410000005023315A41	930100204	H	Le Moulin à Vent	9301002	93010	93	11	0
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	01060000206A080000010000000103000000010000001C000000CDCCCCCC7C312441000000C0DF305A419A9999998931244133333313F5305A41CDCCCCCC53322441666666C6F1305A41333333335F322441666666A6FC305A4166666666A2322441333333132A315A419A999999A4322441CDCCCC2C34315A4133333333CC3424419A99993924315A41333333338A3624413333333319315A41333333336F362441000000E00D315A413333333377372441CDCCCC0C01315A41CDCCCCCC06382441CDCCCC8CFA305A41666666669537244100000060CF305A416666666681372441CDCCCCECCA305A419A9999995437244166666626B9305A416666666620372441CDCCCC8CAC305A41666666663837244133333353AA305A41333333330C3724413333335397305A4100000000C13624419A9999D96F305A41666666667F3624416666666671305A4100000000AD3424410000004081305A41666666665A332441CDCCCC6C8D305A4166666666233324416666668691305A416666666699322441CDCCCC0C99305A4133333333363224419A999979A0305A4100000000A53124419A999999AD305A41333333338E3124419A999919BB305A41CDCCCCCC7C312441000000C0DF305A41CDCCCCCC7C312441000000C0DF305A41	01010000206A080000DCFDEC698E3424419A999959D1305A41	930100301	H	La Mare à la Veuve	9301003	93010	93	11	0
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	01060000206A08000001000000010300000001000000290000009A999999C33524419A9999191E315A4100000000D83524413333337328315A4100000000023624419A9999F926315A4166666666923624419A99997957315A41000000005D3A2441CDCCCCCC3D315A4133333333D83A2441000000E039315A419A999999743A24419A99995916315A4166666666D33924419A99995916315A4166666666C33924410000004003315A41CDCCCCCC6E3A2441000000C0FE305A419A999999CE3C244100000020EE305A419A999999A43C244166666606E0305A41666666664C3D244100000080DB305A4133333333363D2441333333B3C5305A4133333333053D24419A999919C7305A41CDCCCCCCB63C2441CDCCCCCCC0305A41CDCCCCCC653C2441CDCCCC0CB7305A419A999999F93B244133333333B1305A41CDCCCCCCBD3B2441CDCCCC6CAF305A41000000006D3B2441CDCCCC0CB4305A41CDCCCCCCCD392441CDCCCC6CC8305A4166666666A839244133333313CB305A41666666663A3924419A9999B9DA305A4100000000873824413333337397305A4166666666893824410000004093305A416666666669372441000000A096305A4166666666193724419A9999D996305A4133333333E23624416666664671305A4100000000C13624419A9999D96F305A41333333330C3724413333335397305A41666666663837244133333353AA305A416666666620372441CDCCCC8CAC305A419A9999995437244166666626B9305A416666666681372441CDCCCCECCA305A41666666669537244100000060CF305A41CDCCCCCC06382441CDCCCC8CFA305A413333333377372441CDCCCC0C01315A41333333336F362441000000E00D315A41333333338A3624413333333319315A419A999999C33524419A9999191E315A419A999999C33524419A9999191E315A41	01010000206A080000EEAC7696423A244133333393E5305A41	930100302	H	La Remise à Jorelle	9301003	93010	93	11	0
01060000206A08000001000000010300000001000000300000003333333353322441666666464B315A41CDCCCCCCCC322441333333B371315A41000000003A332441000000C09C315A419A99999969332441000000E0AF315A41CDCCCCCC6A33244133333373B0315A41000000006C332441666666E6B0315A41333333338C33244166666686BD315A4133333333C933244133333373D5315A419A9999992934244166666606D1315A410000000031342441CDCCCC8CD0315A419A9999995834244166666606CE315A41000000006634244133333313CD315A410000000078342441CDCCCCCCCB315A41CDCCCCCC8E34244133333333CA315A4100000000E5342441CDCCCC0CC4315A41333333332B35244166666626BF315A416666666631352441333333F3BE315A41666666660535244133333313B0315A4166666666F134244166666646A9315A41333333334C342441333333D36E315A41333333333C3424419A9999D967315A416666666665342441333333B366315A41CDCCCCCC943424413333337365315A41CDCCCCCCEF3424410000000063315A41CDCCCCCCFE3424419A99999962315A419A9999996F3524419A9999995F315A41666666669A352441000000805E315A41CDCCCCCCDD352441666666A65C315A41000000004A3624419A99999959315A4166666666923624419A99997957315A4100000000023624419A9999F926315A4100000000D83524413333337328315A4166666666D53524419A99997927315A41CDCCCCCCCA352441000000E021315A4100000000C7352441000000E01F315A419A999999C33524419A9999191E315A4100000000BC352441666666461E315A4133333333CC3424419A99993924315A41CDCCCCCCEF3324419A9999992A315A4133333333133324419A9999F930315A419A999999A4322441CDCCCC2C34315A4166666666B0322441000000003D315A419A999999BE322441CDCCCC0C48315A41CDCCCCCCBD3224413333331348315A41CDCCCCCC933224416666664649315A41000000007A322441666666264A315A41333333335A322441CDCCCC0C4B315A413333333353322441666666464B315A41	01060000206A08000001000000010300000001000000120000003333333353322441666666464B315A41CDCCCCCCCC322441333333B371315A4133333333C933244133333373D5315A419A9999992934244166666606D1315A416666666631352441333333F3BE315A4166666666F134244166666646A9315A41333333334C342441333333D36E315A41333333333C3424419A9999D967315A41CDCCCCCCDD352441666666A65C315A4166666666923624419A99997957315A4100000000023624419A9999F926315A4100000000D83524413333337328315A419A999999C33524419A9999191E315A4133333333CC3424419A99993924315A419A999999A4322441CDCCCC2C34315A419A999999BE322441CDCCCC0C48315A413333333353322441666666464B315A413333333353322441666666464B315A41	01010000206A08000074430C48CA3324419A99993987315A41	930100303	H	Le Vieux Château	9301003	93010	93	11	0
01060000206A080000010000000103000000010000002C000000333333333C3424419A9999D967315A41333333334C342441333333D36E315A4166666666F134244166666646A9315A41666666660535244133333313B0315A416666666631352441333333F3BE315A410000000057352441CDCCCCACBD315A419A999999A735244133333333BB315A4166666666DF35244166666686B9315A4133333333F035244100000000B9315A41666666662236244100000080B7315A41CDCCCCCC673624419A999979B5315A41CDCCCCCC9A362441666666E6B3315A4100000000C4362441666666A6B2315A41CDCCCCCCF936244133333313B1315A410000000029372441666666A6AF315A41333333333037244133333373AF315A41CDCCCCCC42372441CDCCCCCCAE315A419A9999995837244166666606AE315A4166666666B0372441CDCCCC6CAB315A4100000000DD37244133333313AA315A419A9999995B38244133333373A7315A41CDCCCCCC7E382441333333D3A6315A4100000000DF38244133333313A5315A419A999999DA38244100000080A2315A4133333333D73824419A999919A0315A41333333339E3824419A9999797D315A419A9999999A382441000000407C315A41666666667C3824419A9999597C315A419A99999952382441666666266C315A410000000000382441000000C04D315A41CDCCCCCC41372441333333D352315A4166666666253724419A99999953315A4166666666FF362441CDCCCC8C54315A4133333333D1362441666666C655315A4166666666923624419A99997957315A41000000004A3624419A99999959315A41CDCCCCCCDD352441666666A65C315A41666666669A352441000000805E315A419A9999996F3524419A9999995F315A41CDCCCCCCFE3424419A99999962315A41CDCCCCCCEF3424410000000063315A41CDCCCCCC943424413333337365315A416666666665342441333333B366315A41333333333C3424419A9999D967315A41	01060000206A080000010000000103000000010000000D000000333333333C3424419A9999D967315A41333333334C342441333333D36E315A4166666666F134244166666646A9315A416666666631352441333333F3BE315A4100000000DD37244133333313AA315A4100000000DF38244133333313A5315A41333333339E3824419A9999797D315A41666666667C3824419A9999597C315A410000000000382441000000C04D315A4166666666923624419A99997957315A41CDCCCCCCDD352441666666A65C315A41333333333C3424419A9999D967315A41333333333C3424419A9999D967315A41	01010000206A080000F4225A9EB03624419A9999C98E315A41	930100304	H	Le Saule Blanc	9301003	93010	93	11	0
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	01060000206A08000001000000010300000001000000170000000000000000382441000000C04D315A41666666667C3824419A9999597C315A41333333339E3824419A9999797D315A4100000000DF38244133333313A5315A419A99999916392441CDCCCC0CA4315A41CDCCCCCCC73A24419A99993994315A419A999999423B24419A9999B98C315A4133333333D43B24419A9999D97D315A4133333333703E2441CDCCCC2C61315A41CDCCCCCC803D2441CDCCCC0C28315A419A9999993E3D2441CDCCCCAC18315A4133333333103D2441666666E607315A4100000000043D2441CDCCCCCCFF305A419A999999CE3C244100000020EE305A41CDCCCCCC6E3A2441000000C0FE305A4166666666C33924410000004003315A4166666666D33924419A99995916315A419A999999743A24419A99995916315A4133333333D83A2441000000E039315A41000000005D3A2441CDCCCCCC3D315A4100000000F43924413333335340315A410000000000382441000000C04D315A410000000000382441000000C04D315A41	01010000206A080000994756D65D3B24413433334349315A41	930100305	H	Les Courts Sillons	9301003	93010	93	11	0
01060000206A08000001000000010300000001000000840000000000000029372441666666A6AF315A4166666666883724419A999919CF315A41666666669C3724419A9999B9D5315A4133333333BE372441000000A0E0315A4133333333E637244133333393ED315A41CDCCCCCC1B3824419A999939FF315A41CDCCCCCC583824419A999999FA315A419A99999959382441CDCCCC8CFA315A41CDCCCCCCB6382441666666C6F3315A419A999999C13824419A9999F9F2315A41000000000039244133333333EE315A4100000000003924419A999959ED315A41000000000439244166666646EC315A41666666660C392441000000A0EB315A4133333333173924419A999999EB315A41333333331E39244100000040EC315A4133333333573924419A9999F9E7315A41666666666B39244100000080E6315A4100000000A539244166666626E2315A4166666666B839244133333353E1315A4133333333293A2441CDCCCC0CD9315A41666666662F3A244133333393D8315A41CDCCCCCC543A24419A9999D9D5315A419A999999673A2441666666C6D4315A4100000000903A24419A9999D9D2315A4100000000933A24419A9999B9D2315A419A999999A53A2441333333F3D1315A41CDCCCCCCB63A244133333373D1315A4100000000CE3A244133333313D1315A41CDCCCCCC1C3B244133333353D0315A4166666666463B2441333333F3CF315A4166666666AD3B244133333373CF315A419A999999F43B24419A999979EC315A419A9999993B3C2441CDCCCC2C0A325A41333333335C3C2441000000201B325A41CDCCCCCC933B24413333331323325A41000000005C3B24410000000025325A4100000000633B24413333335337325A419A999999983B2441CDCCCCEC35325A41333333337F3C2441CDCCCCEC2E325A41333333330D3D24419A99993921325A4100000000503D2441CDCCCC4C1F325A4166666666B03D2441333333D31B325A41CDCCCCCCFA3D24410000000019325A41CDCCCCCCF03D24416666668610325A419A999999F63D2441CDCCCC0C0E325A41666666661C3E24419A9999F90F325A4100000000123E24419A9999990B325A41CDCCCCCC0F3E2441333333B30A325A4100000000043E2441CDCCCCCC05325A419A999999013E2441CDCCCCCC04325A4100000000FE3D2441CDCCCC4C03325A4133333333F33D2441000000C0FE315A4133333333DA3D244100000060F4315A4133333333D63D2441000000C0F2315A4100000000D43D2441CDCCCCCCF1315A419A999999D33D2441000000A0F1315A4133333333CD3D2441333333F3EE315A4100000000C93D24419A9999B9ED315A419A999999C23D2441CDCCCCCCEC315A419A999999C13D244166666606EC315A4166666666BB3D2441CDCCCCECE7315A41CDCCCCCCB93D244133333333E7315A419A999999B43D24419A9999D9E4315A41CDCCCCCCAF3D24419A999999E2315A41666666669F3D2441CDCCCCCCDC315A41333333339C3D244166666646DB315A41CDCCCCCC943D2441666666A6D7315A41000000007E3D2441000000A0CC315A4100000000323D244133333313CE315A4133333333EF3C2441333333B3CE315A4133333333C43C244166666606CF315A4133333333C23C2441CDCCCCCCCC315A4166666666BD3C2441666666A6CB315A41CDCCCCCCB33C244100000020C8315A4133333333B03C244100000020C7315A41CDCCCCCCAD3C2441CDCCCC8CC6315A4133333333A53C2441CDCCCC2CC3315A41CDCCCCCC953C24419A9999D9BC315A41666666668B3C2441CDCCCCECB9315A419A999999663C2441666666C6AB315A419A999999463C24419A999939AA315A419A9999992E3C244166666626A8315A4133333333263C244100000040A7315A41CDCCCCCC223C24419A9999D9A6315A41666666661D3C24419A999939A6315A41CDCCCCCC113C2441333333F3A4315A4100000000023C2441666666C6A2315A419A999999F73B24419A999959A1315A4133333333F63B244166666626A1315A419A999999F33B24419A9999B9A0315A4133333333F33B24419A999999A0315A4166666666DF3B2441666666669D315A419A999999D63B2441333333B39B315A419A999999D53B2441000000809B315A4133333333CC3B2441000000C099315A419A999999F63B2441666666A696315A4100000000233C2441CDCCCC4C93315A4100000000F63B24410000002087315A4133333333F23B24416666660686315A4100000000E53B2441CDCCCC6C81315A419A999999DD3B2441000000207F315A41CDCCCCCCD73B2441666666A67D315A4133333333D43B24419A9999D97D315A41CDCCCCCCC13B2441333333737F315A41CDCCCCCCA93B2441CDCCCC0C82315A4100000000733B24419A9999B987315A4133333333643B24416666664689315A419A999999423B24419A9999B98C315A4133333333293B2441CDCCCCCC8E315A419A999999153B24416666660690315A4100000000EF3A24413333337392315A41CDCCCCCCC73A24419A99993994315A4100000000B33A2441CDCCCCEC94315A4100000000AD3A24410000002095315A4133333333303A24413333339399315A419A999999273A2441666666E699315A4100000000E9392441666666269C315A41666666669E392441CDCCCC0C9F315A41CDCCCCCC7F39244133333313A0315A41CDCCCCCC4E3924419A9999D9A1315A41000000002A392441CDCCCC2CA3315A419A99999916392441CDCCCC0CA4315A4100000000DF38244133333313A5315A41CDCCCCCC7E382441333333D3A6315A419A9999995B38244133333373A7315A4100000000DD37244133333313AA315A4166666666B0372441CDCCCC6CAB315A419A9999995837244166666606AE315A41CDCCCCCC42372441CDCCCCCCAE315A41333333333037244133333373AF315A410000000029372441666666A6AF315A41	01060000206A080000010000000103000000010000001E0000000000000029372441666666A6AF315A41CDCCCCCC1B3824419A999939FF315A4100000000A539244166666626E2315A41CDCCCCCC543A24419A9999D9D5315A4100000000CE3A244133333313D1315A4166666666AD3B244133333373CF315A419A9999993B3C2441CDCCCC2C0A325A41333333335C3C2441000000201B325A41000000005C3B24410000000025325A4100000000633B24413333335337325A41333333337F3C2441CDCCCCEC2E325A41333333330D3D24419A99993921325A41CDCCCCCCFA3D24410000000019325A419A999999F63D2441CDCCCC0C0E325A41666666661C3E24419A9999F90F325A4133333333CD3D2441333333F3EE315A419A999999C23D2441CDCCCCCCEC315A41000000007E3D2441000000A0CC315A4133333333C43C244166666606CF315A419A999999663C2441666666C6AB315A41CDCCCCCC113C2441333333F3A4315A4133333333CC3B2441000000C099315A4100000000233C2441CDCCCC4C93315A41CDCCCCCCD73B2441666666A67D315A419A999999423B24419A9999B98C315A41CDCCCCCCC73A24419A99993994315A419A99999916392441CDCCCC0CA4315A4100000000DD37244133333313AA315A410000000029372441666666A6AF315A410000000029372441666666A6AF315A41	01010000206A0800004AC40119E23824419A999929DA315A41	930100401	H	Les Friches	9301004	93010	93	11	0
01060000206A080000010000000103000000010000003D00000033333333C933244133333373D5315A416666666609342441000000A0EE315A41000000002D342441000000A0FC315A4100000000323424419A999999FE315A410000000038342441333333F300325A419A999999713424419A9999D917325A416666666683342441333333B317325A41CDCCCCCCCC3424419A99997914325A4166666666D53424416666662614325A4100000000E13424419A9999B913325A41000000000A352441666666C612325A413333333342352441CDCCCC6C11325A419A9999995D352441CDCCCCCC10325A41CDCCCCCCA6352441CDCCCC2C0F325A4166666666D63524419A9999F90D325A4133333333DB3524419A9999D90D325A41CDCCCCCC30362441000000600C325A410000000036362441CDCCCC4C0C325A41CDCCCCCC49362441CDCCCCEC0B325A41000000006A362441666666460B325A41666666667C362441000000400B325A410000000080362441666666E60B325A41CDCCCCCC86362441CDCCCC4C0C325A41333333338E362441666666660C325A410000000096362441CDCCCC0C0C325A419A9999999C362441CDCCCC0C0B325A41666666662A3724419A99991909325A4133333333423724416666666608325A41CDCCCCCC503724416666660608325A41CDCCCCCC7C372441333333F306325A4100000000C73724410000000005325A4166666666D2372441000000A004325A41CDCCCCCCE6372441666666C603325A4166666666F6372441000000E002325A4166666666F3372441CDCCCCEC01325A4133333333043824410000000001325A41CDCCCCCC1B3824419A999939FF315A4133333333E637244133333393ED315A4133333333BE372441000000A0E0315A41666666669C3724419A9999B9D5315A4166666666883724419A999919CF315A410000000029372441666666A6AF315A41CDCCCCCCF936244133333313B1315A4100000000C4362441666666A6B2315A41CDCCCCCC9A362441666666E6B3315A41CDCCCCCC673624419A999979B5315A41666666662236244100000080B7315A4133333333F035244100000000B9315A4166666666DF35244166666686B9315A419A999999A735244133333333BB315A410000000057352441CDCCCCACBD315A416666666631352441333333F3BE315A41333333332B35244166666626BF315A4100000000E5342441CDCCCC0CC4315A41CDCCCCCC8E34244133333333CA315A410000000078342441CDCCCCCCCB315A41000000006634244133333313CD315A419A9999995834244166666606CE315A410000000031342441CDCCCC8CD0315A419A9999992934244166666606D1315A4133333333C933244133333373D5315A41	01060000206A080000010000000103000000010000000D00000033333333C933244133333373D5315A419A999999713424419A9999D917325A4100000000E13424419A9999B913325A4133333333DB3524419A9999D90D325A41000000006A362441666666460B325A41666666662A3724419A99991909325A4100000000C73724410000000005325A41CDCCCCCC1B3824419A999939FF315A410000000029372441666666A6AF315A41333333332B35244166666626BF315A419A9999992934244166666606D1315A4133333333C933244133333373D5315A4133333333C933244133333373D5315A41	01010000206A080000391C7F34E43524419A999919E7315A41	930100402	H	La Martraye	9301004	93010	93	11	0
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	01060000206A080000010000000103000000010000001700000000000000F8322441333333330B325A410000000038332441666666A628325A4100000000783324419A99997927325A41CDCCCCCC8B332441333333932C325A41333333331A3324416666662631325A41CDCCCCCC0C3324410000006035325A41CDCCCCCC223324413333331341325A41000000002A3324413333333353325A410000000021332441666666C680325A413333333365342441000000008A325A4166666666B1342441333333738B325A416666666637352441666666E68B325A4133333333D23424416666664687325A4100000000D43424419A9999397E325A41CDCCCCCC653524413333333368325A41000000001E362441666666265D325A4166666666AC342441333333532D325A419A99999995342441666666E628325A419A999999743424419A9999F91D325A419A999999713424419A9999D917325A4100000000323424419A999999FE315A4100000000F8322441333333330B325A4100000000F8322441333333330B325A41	01010000206A080000FE893B3447342441666666D645325A41	930100403	H	Les Flèches	9301004	93010	93	11	0
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	01060000206A08000001000000010300000001000000210000009A999999713424419A9999D917325A419A999999743424419A9999F91D325A419A99999995342441666666E628325A4166666666AC342441333333532D325A41000000001E362441666666265D325A41CDCCCCCC653524413333333368325A4100000000D43424419A9999397E325A4133333333D23424416666664687325A416666666637352441666666E68B325A4100000000AC352441000000C08E325A413333333322372441666666C698325A4100000000A0372441333333D39C325A419A9999998A3924419A999919AA325A419A999999053A244100000020AC325A419A999999C7382441333333B3A3325A4166666666E23824413333335397325A41666666666F3924419A9999B999325A4133333333CE3A2441666666C6A2325A4100000000B93A2441333333539D325A4133333333B23A2441333333F393325A419A999999A03A24410000000067325A410000000017392441CDCCCCAC5A325A41CDCCCCCC753924419A9999794C325A41CDCCCCCC9D3824419A9999590E325A4100000000303824413333331314325A4166666666F6372441000000E002325A4100000000C73724410000000005325A41666666662A3724419A99991909325A41000000006A362441666666460B325A4133333333DB3524419A9999D90D325A4100000000E13424419A9999B913325A419A999999713424419A9999D917325A419A999999713424419A9999D917325A41	01010000206A0800005CA892D18F3724416666669658325A41	930100404	H	La Ferme	9301004	93010	93	11	0
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	01060000206A080000010000000103000000010000001E00000066666666F3372441CDCCCCEC01325A4100000000303824413333331314325A41CDCCCCCC9D3824419A9999590E325A41CDCCCCCC753924419A9999794C325A410000000017392441CDCCCCAC5A325A419A999999A03A24410000000067325A4133333333B23A2441333333F393325A4100000000B93A2441333333539D325A4133333333CE3A2441666666C6A2325A4166666666CA3A2441CDCCCC2C76325A4166666666DA3C24410000000078325A4166666666C23C2441333333935B325A4100000000FF3D2441333333D359325A41CDCCCCCC063E24419A9999395E325A41CDCCCCCC573E24410000000058325A41CDCCCCCC0A3E24416666664627325A41CDCCCCCCFA3D24410000000019325A41333333330D3D24419A99993921325A41333333337F3C2441CDCCCCEC2E325A4100000000633B24413333335337325A41000000005C3B24410000000025325A41333333335C3C2441000000201B325A419A9999993B3C2441CDCCCC2C0A325A4166666666AD3B244133333373CF315A4100000000CE3A244133333313D1315A41CDCCCCCC543A24419A9999D9D5315A4100000000A539244166666626E2315A4133333333043824410000000001325A4166666666F3372441CDCCCCEC01325A4166666666F3372441CDCCCCEC01325A41	01010000206A08000004A8BD33AF3B2441CCCCCCEC39325A41	930100405	H	Fosse de la Régale	9301004	93010	93	11	0
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	01060000206A080000010000000103000000010000001C0000009A99999955152441000000A0E7355A41CDCCCCCCC4162441333333D331365A41CDCCCCCC041724413333337340365A41000000000D172441333333F33E365A4100000000A81724413333339343365A4166666666A01724419A99995940365A416666666619172441333333131D365A413333333348172441000000001A365A41CDCCCCCC34172441666666E614365A41CDCCCCCC96172441333333530E365A4100000000BF172441CDCCCC2C0E365A41333333333B182441CDCCCCEC05365A4166666666AE192441CDCCCCECF9355A4133333333EF19244133333313F9355A419A9999997D1B244166666626F7355A41CDCCCCCC9B1B24419A999959CA355A41CDCCCCCC831B244100000040C4355A41CDCCCCCCE71A24419A999939C3355A4100000000D619244166666606C3355A41333333338719244133333393C3355A41000000004819244166666666C6355A4166666666971824419A999979D0355A4166666666701724419A999999E0355A419A99999946162441000000C0F1355A41333333333216244133333373F3355A41CDCCCCCCD7152441CDCCCC6CE2355A419A99999955152441000000A0E7355A419A99999955152441000000A0E7355A41	01010000206A08000054FB863F251724413433338304365A41	930130104	H	Guynemer-Gai Logis	9301301	93013	93	11	0
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	01060000206A08000001000000010300000001000000230000003333333383112441CDCCCC4C37365A41CDCCCCCC3F1224419A99997942365A41CDCCCCCC31122441333333D348365A41CDCCCCCCE2112441666666865C365A4100000000FD1124410000006067365A41CDCCCCCC53122441CDCCCC2C69365A41CDCCCCCC89122441333333B36B365A416666666661142441333333B37F365A410000000095142441CDCCCC2C81365A419A9999995E15244166666666AB365A4133333333B715244100000060A5365A419A999999E616244166666686E8365A413333333365182441000000C0D5365A41000000008819244100000060C5365A4133333333761824419A9999798E365A41CDCCCCCCE71724413333331370365A4166666666B4172441000000A062365A410000000011172441000000C03F365A4100000000F1162441666666E644365A419A9999997E162441000000404D365A416666666657162441666666C64B365A41CDCCCCCC18162441333333D33E365A4166666666EE1524419A99993942365A4166666666B31524413333337342365A413333333394152441CDCCCC4C3F365A4166666666561524410000000033365A413333333335152441000000802F365A419A9999990D152441CDCCCC2C2F365A4133333333D8142441666666463F365A41CDCCCCCC9F142441CDCCCC2C4D365A41CDCCCCCC861424410000000057365A416666666689122441000000C041365A41000000008A1124410000006036365A413333333383112441CDCCCC4C37365A413333333383112441CDCCCC4C37365A41	01010000206A0800002EEC0EC29B162441666666768C365A41	930130101	A	Parcexpo	9301301	93013	93	11	0
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	01060000206A080000010000000103000000010000002E0000009A999999690E2441000000E0EE355A419A999999260F24416666664616365A41CDCCCCCCF20E2441666666262A365A4100000000690F24419A99993937365A419A999999D00F24410000000023365A413333333383112441CDCCCC4C37365A41000000008A1124410000006036365A416666666689122441000000C041365A41CDCCCCCC861424410000000057365A41CDCCCCCC9F142441CDCCCC2C4D365A4133333333D8142441666666463F365A419A9999990D152441CDCCCC2C2F365A413333333335152441000000802F365A4166666666561524410000000033365A413333333394152441CDCCCC4C3F365A4166666666B31524413333337342365A4166666666EE1524419A99993942365A41CDCCCCCC18162441333333D33E365A416666666657162441666666C64B365A419A9999997E162441000000404D365A4100000000F1162441666666E644365A41CDCCCCCC041724413333337340365A41CDCCCCCCC4162441333333D331365A4166666666C3152441CDCCCC8CFD355A41000000000F152441333333530C365A4133333333B31424419A9999F910365A419A999999FD1324416666666615365A416666666681132441666666061A365A41000000004B132441666666A61D365A41CDCCCCCC43132441000000001C365A41CDCCCCCC9C122441666666C616365A41000000009C122441000000400B365A41000000006912244133333373FB355A41666666662F12244100000000EC355A410000000070112441CDCCCCACB5355A41333333334411244166666606AA355A419A9999994011244133333333A5355A4133333333BA10244100000000A1355A41000000009D102441000000609E355A41000000005A102441666666469F355A41333333330B1024419A9999399D355A419A999999800F2441CDCCCC4C91355A41666666664B0F2441CDCCCC8C9C355A41333333330F0F2441CDCCCCECAD355A419A999999690E2441000000E0EE355A419A999999690E2441000000E0EE355A41	01010000206A080000B4CE2EF671102441CCCCCC5CF6355A41	930130102	H	Stade Église	9301301	93013	93	11	0
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	01060000206A08000001000000010300000001000000130000009A9999993D112441CDCCCC4CA7355A41666666662F12244100000000EC355A41000000006912244133333373FB355A41000000009C122441000000400B365A41CDCCCCCC9C122441666666C616365A41CDCCCCCC43132441000000001C365A41000000004B132441666666A61D365A416666666681132441666666061A365A419A999999FD1324416666666615365A4133333333B31424419A9999F910365A41000000000F152441333333530C365A4166666666C3152441CDCCCC8CFD355A419A999999581424419A999939B5355A41CDCCCCCC27142441000000E0AB355A4100000000E3132441666666E6AE355A413333333397122441333333F3AD355A419A9999994011244133333333A5355A419A9999993D112441CDCCCC4CA7355A419A9999993D112441CDCCCC4CA7355A41	01010000206A080000B0BE32859E13244133333303E1355A41	930130103	H	Baudouin République	9301301	93013	93	11	0
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	01060000206A080000010000000103000000010000001D000000CDCCCCCC27142441000000E0AB355A419A99999955152441000000A0E7355A41CDCCCCCCD7152441CDCCCC6CE2355A41333333333216244133333373F3355A419A99999946162441000000C0F1355A4166666666701724419A999999E0355A4166666666971824419A999979D0355A41000000004819244166666666C6355A41333333338719244133333393C3355A4100000000D619244166666606C3355A41CDCCCCCCE71A24419A999939C3355A41CDCCCCCC831B244100000040C4355A41CDCCCCCC9B1B24419A999959CA355A41CDCCCCCC6F1C244133333373D4355A419A999999AE1D24419A9999D9EB355A4133333333B11D244100000020EA355A419A9999997A1E2441666666E6AE355A419A999999EA1E2441000000008B355A419A999999381E2441333333F386355A419A9999996B1C24416666662674355A419A999999791B24419A99997972355A419A999999EF192441CDCCCC0C6E355A4166666666C21724416666664670355A41000000008C1624419A9999D973355A4133333333651524419A99999979355A41333333334D152441666666867C355A419A9999995B142441666666E6A3355A41CDCCCCCC27142441000000E0AB355A41CDCCCCCC27142441000000E0AB355A41	01010000206A080000BB9024F65B19244100000010B2355A41	930130105	H	L'Étang	9301301	93013	93	11	0
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	01060000206A08000001000000010300000001000000260000009A999999E1102441333333D319355A4133333333EA1024419A9999391D355A419A99999962122441333333735D355A419A999999E71224416666662675355A41CDCCCCCC27142441000000E0AB355A419A9999995B142441666666E6A3355A41333333334D152441666666867C355A4133333333651524419A99999979355A41000000008C1624419A9999D973355A4166666666C21724416666664670355A419A999999EF192441CDCCCC0C6E355A419A999999791B24419A99997972355A419A9999996B1C24416666662674355A419A999999381E2441333333F386355A419A999999EA1E2441000000008B355A4166666666081F2441CDCCCCAC82355A4133333333981E2441000000006C355A4133333333F21D2441000000A06B355A4100000000961C2441CDCCCC2C6C355A4166666666A81B24419A9999396B355A41CDCCCCCCB01A24413333335368355A419A999999A81924416666664663355A419A999999C8182441333333135D355A41333333330A182441CDCCCC2C57355A410000000069172441666666E652355A4166666666E4152441333333D344355A410000000024162441333333B33F355A416666666604152441333333D337355A419A999999C11424410000006037355A41666666666C1424410000008034355A4166666666B8132441000000C02F355A410000000018132441666666A629355A41333333339B122441CDCCCCAC28355A41CDCCCCCCD31124413333339320355A419A9999993F1124419A9999D918355A413333333318112441CDCCCC2C18355A419A999999E1102441333333D319355A419A999999E1102441333333D319355A41	01010000206A080000B81E85EB021624413333337362355A41	930130106	H	Gare	9301301	93013	93	11	0
01060000206A080000010000000103000000010000008700000033333333780C2441000000A06E355A4166666666A90C24416666666671355A4133333333B40C24419A99999972355A4100000000F20C24410000006076355A4166666666060D24416666660678355A4166666666070D24410000002078355A4166666666110D24419A99991978355A4100000000860D24413333331378355A419A999999C80D24419A9999F978355A419A9999991E0E24413333337377355A419A9999999F0E2441666666C678355A41CDCCCCCCC90E2441000000C079355A419A999999320F2441CDCCCC2C83355A419A999999750F2441CDCCCCAC89355A41CDCCCCCC540F2441333333D38B355A419A999999E50E24416666662693355A4166666666D70E24413333331394355A419A999999A20E24413333339397355A4133333333700E2441666666E69A355A4100000000660E24419A9999399C355A41000000000E0E24419A999959A3355A4133333333070E24419A9999F9A3355A41CDCCCCCCF20D2441CDCCCCECA5355A4166666666850D2441000000A0AF355A41CDCCCCCC790D2441000000C0B0355A4133333333690D244166666666B2355A4100000000200D2441333333B3B9355A4133333333FA0C244133333373BD355A419A999999270D24419A9999F9C3355A4166666666530D2441333333D3CA355A4100000000BF0D244133333393C8355A4100000000060E2441333333F3C6355A4166666666710E244133333373C4355A4133333333AA0E244100000020C3355A4166666666C40E244166666686C2355A4100000000DB0E244100000000C2355A41333333330F0F2441CDCCCCECAD355A4166666666150F2441333333F3AB355A41000000002B0F2441000000E0A4355A41666666664B0F2441CDCCCC8C9C355A41CDCCCCCC6B0F24419A9999D995355A4133333333760F24416666662693355A419A999999800F2441CDCCCC4C91355A4133333333810F24419A99995991355A41CDCCCCCC880F2441CDCCCCEC91355A41333333338D0F24419A99995992355A4166666666950F24413333331393355A41CDCCCCCCAB0F24419A99991995355A4166666666B50F24410000002096355A419A999999DF0F2441333333F399355A4166666666F40F2441CDCCCCAC9B355A41333333330B1024419A9999399D355A419A999999161024419A9999B99D355A413333333326102441000000609E355A41666666663E1024419A9999F99E355A41000000005A102441666666469F355A41CDCCCCCC76102441333333139F355A41666666668D102441333333B39E355A41000000009D102441000000609E355A4133333333A21024419A9999F99E355A4133333333BA10244100000000A1355A4133333333C9102441000000C0A1355A419A999999E5102441666666C6A2355A419A9999991511244100000040A4355A419A9999994011244133333333A5355A41CDCCCCCC7D112441CDCCCC8CA6355A4100000000DA11244166666646A9355A4166666666F41124419A9999D9A9355A41333333330012244166666626AA355A4133333333231224419A9999F9AA355A419A99999930122441CDCCCC4CAB355A416666666660122441000000C0AC355A413333333397122441333333F3AD355A4100000000F5122441CDCCCC6CAE355A41CDCCCCCC4F1324419A9999B9AE355A41333333336B132441333333D3AE355A4100000000E3132441666666E6AE355A4100000000F8132441CDCCCCACAE355A416666666612142441666666A6AD355A41CDCCCCCC27142441000000E0AB355A4100000000DD1324419A9999199F355A4133333333991324416666668693355A419A99999913132441CDCCCCAC7C355A419A999999E71224416666662675355A4100000000941224419A99993966355A416666666683122441CDCCCC4C63355A416666666675122441CDCCCCCC60355A419A99999962122441333333735D355A41333333334E122441000000005A355A41000000002D1224416666666654355A413333333310122441666666864F355A4166666666FC112441666666264C355A41CDCCCCCCFA112441666666E64B355A4166666666EB1124419A99995949355A41CDCCCCCCE9112441CDCCCC0C49355A4133333333DA112441CDCCCC4C46355A419A999999B61124419A99991940355A4100000000AA112441666666263E355A41CDCCCCCC6C1124413333339333355A410000000028112441666666C627355A413333333313112441CDCCCCCC23355A4133333333101124416666664623355A41CDCCCCCC0D112441000000E022355A416666666604112441CDCCCC4C21355A419A999999FE1024419A99995920355A419A999999F5102441666666C61E355A419A999999EF102441333333D31D355A4133333333EA1024419A9999391D355A419A999999E1102441333333D319355A4133333333D51024419A99997917355A4133333333B21024416666662611355A419A9999999E1024413333339312355A4100000000451024413333333319355A4100000000431024413333335319355A410000000031102441CDCCCCAC1A355A419A9999992E1024419A9999D91A355A41666666661D102441000000201C355A41666666661C102441333333331C355A4100000000F80F2441000000E01E355A4166666666EB0F2441CDCCCCEC1F355A4100000000D20F2441000000C021355A419A999999340F2441666666062D355A4166666666260F24419A9999F92D355A419A999999130F24419A9999792E355A4133333333830E24419A9999B92E355A41CDCCCCCC7A0E2441CDCCCC0C2F355A419A999999660E2441CDCCCC0C31355A41666666663A0E24416666664636355A4166666666940D24419A99997948355A4133333333800D2441CDCCCCCC4A355A4133333333570D24410000002050355A4100000000160D24416666664659355A4100000000EB0C2441666666465F355A419A9999998F0C2441333333D36A355A4133333333780C2441000000A06E355A41	01060000206A080000010000000103000000010000002200000033333333780C2441000000A06E355A4166666666070D24410000002078355A4100000000860D24413333331378355A419A999999C80D24419A9999F978355A419A9999991E0E24413333337377355A41CDCCCCCCC90E2441000000C079355A419A999999750F2441CDCCCCAC89355A4133333333700E2441666666E69A355A4166666666850D2441000000A0AF355A4133333333FA0C244133333373BD355A4166666666530D2441333333D3CA355A4100000000DB0E244100000000C2355A41333333330F0F2441CDCCCCECAD355A41666666664B0F2441CDCCCC8C9C355A419A999999800F2441CDCCCC4C91355A41333333330B1024419A9999399D355A41000000005A102441666666469F355A41000000009D102441000000609E355A4133333333BA10244100000000A1355A419A9999991511244100000040A4355A413333333397122441333333F3AD355A4100000000E3132441666666E6AE355A41CDCCCCCC27142441000000E0AB355A419A999999E71224416666662675355A419A99999962122441333333735D355A4133333333EA1024419A9999391D355A4133333333B21024416666662611355A419A999999340F2441666666062D355A419A999999130F24419A9999792E355A4133333333830E24419A9999B92E355A4166666666940D24419A99997948355A4133333333570D24410000002050355A4133333333780C2441000000A06E355A4133333333780C2441000000A06E355A41	01010000206A08000000D183279E0F24419A9999B96C355A41	930130107	H	Bienvenue Rigaud	9301301	93013	93	11	0
01060000206A080000010000000103000000010000001E000000CDCCCCCC775E24413333335345325A41CDCCCCCC795E2441666666A64C325A41333333337D5E2441000000604F325A4100000000845E2441333333D351325A41333333338C5E24416666660656325A41000000008D5E24413333335356325A41666666668D5E24419A99993958325A41666666668C5E2441CDCCCC8C5D325A41CDCCCCCC8D5E2441333333336D325A41666666668D5E2441333333736F325A41000000008D5E2441000000407A325A41CDCCCCCC8C5E24413333333388325A41666666668A5E2441CDCCCCAC8C325A4133333333A95E24419A9999998C325A4100000000E95E24419A9999798C325A4100000000045F24419A9999B98B325A41CDCCCCCC195F2441CDCCCCEC8A325A419A999999285F2441CDCCCC4C8A325A4100000000345F2441CDCCCCEC89325A4166666666C55F2441CDCCCC8C75325A41666666660C602441000000A06B325A41CDCCCCCC1D6024416666662669325A41333333332F602441333333B366325A4100000000156024419A99993964325A4100000000B25F2441CDCCCCAC5B325A4133333333FC5E2441000000A04B325A41CDCCCCCC995E2441333333F342325A4100000000785E2441CDCCCCEC3F325A4100000000785E2441CDCCCCEC43325A41CDCCCCCC775E24413333335345325A41	01060000206A080000010000000103000000010000000B000000CDCCCCCC775E24413333335345325A41CDCCCCCC795E2441666666A64C325A41000000008D5E24413333335356325A41CDCCCCCC8C5E24413333333388325A41666666668A5E2441CDCCCCAC8C325A4100000000E95E24419A9999798C325A4100000000345F2441CDCCCCEC89325A41333333332F602441333333B366325A4100000000785E2441CDCCCCEC3F325A41CDCCCCCC775E24413333335345325A41CDCCCCCC775E24413333335345325A41	01010000206A08000038179A9A575F24416666667665325A41	930140102	H	Iris 1	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000002B00000066666666BD5C2441666666866F335A41CDCCCCCCC15C24419A99999971335A41000000000A5E24419A999919A4335A4133333333245E244100000060A9335A4100000000055F2441666666C6E6335A4166666666285F2441000000E0ED335A419A999999F85F24410000002006345A41000000004F602441666666A61C345A4166666666666024419A99995921345A41000000005B6024413333331309345A4100000000226224419A99999908345A41000000002E6224419A99997904345A4100000000926224419A999939CB335A4100000000B6622441CDCCCC8CB2335A41CDCCCCCCD662244133333393A1335A419A999999F5622441CDCCCC4C97335A41CDCCCCCC1D632441333333F37C335A4100000000596324419A9999195A335A419A99999976632441CDCCCC4C4D335A41CDCCCCCCF4622441333333533C335A413333333372622441000000A02F335A41CDCCCCCCE06124416666668622335A41333333337E6124419A99995917335A419A999999D2602441666666E605335A41CDCCCCCC4C612441CDCCCCCCF9325A4133333333A0612441CDCCCC6CF0325A4100000000CA6224419A999979D2325A4133333333306324419A999979C7325A4133333333C263244100000000B9325A41333333332F602441333333B366325A4100000000345F2441CDCCCCEC89325A4166666666D75D244166666606BA325A41CDCCCCCC515D2441333333D3CC325A4100000000AE5D2441CDCCCC0CD6325A419A999999985D244166666686E8325A419A999999745D24419A9999B9FF325A41CDCCCCCC585D2441333333732B335A4133333333E35D24416666666635335A4166666666CC5D24419A9999193D335A4100000000735D24413333331347335A4100000000075D2441CDCCCC4C5E335A4166666666BD5C2441666666866F335A4166666666BD5C2441666666866F335A41	01010000206A08000093EE7BF55E602441CDCCCCCC43335A41	930140101	D	Parc Départemental	9301401	93014	93	11	1
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	01060000206A08000001000000010300000001000000230000009A9999997758244100000000E8315A416666666628592441666666E6FE315A41CDCCCCCC3F592441666666E6FA315A4100000000B0592441CDCCCCCC25325A41CDCCCCCC285A24410000000051325A41CDCCCCCC0F5A24410000006055325A41333333331D5A2441333333335A325A4133333333495A2441CDCCCC4C5E325A419A9999997B5A2441CDCCCCCC73325A41CDCCCCCCBE5A24413333333389325A41333333334B5B24410000008089325A4133333333635B2441666666A688325A4100000000F85B24416666662671325A419A999999675C2441CDCCCC0C77325A4100000000A35D2441333333538B325A4166666666F05D2441666666A68C325A41666666668A5E2441CDCCCCAC8C325A41CDCCCCCC8C5E24413333333388325A41000000008D5E24413333335356325A41CDCCCCCC795E2441666666A64C325A4100000000785E2441CDCCCCEC3F325A4166666666115C24416666664609325A4166666666B55B2441333333D309325A4133333333275B24416666660605325A419A999999775A24413333333307325A41000000004D5A24419A99993902325A419A999999335A244100000060FC315A419A999999A25924419A999919D1315A416666666668592441CDCCCC8CC2315A41CDCCCCCC3059244166666686B7315A4133333333085924419A999919B8315A41CDCCCCCC0C5924419A9999D9BE315A41CDCCCCCCEF58244166666646C2315A419A9999997758244100000000E8315A419A9999997758244100000000E8315A41	01010000206A0800004360FADC6F5B24413333334323325A41	930140103	H	Iris 2	9301401	93014	93	11	0
01060000206A080000010000000103000000010000003E0000009A9999998C562441333333F35C325A41CDCCCCCC9D562441000000E060325A4166666666BE562441333333F35F325A4100000000EE562441000000005F325A4166666666BE5724419A9999995B325A41CDCCCCCC0C582441333333D35A325A41CDCCCCCC57582441666666465A325A41CDCCCCCC7A582441333333335A325A4100000000EC582441CDCCCC2C5A325A419A9999991D5924419A9999995A325A410000000030592441000000A05A325A4100000000435924419A9999995A325A410000000057592441CDCCCC8C5A325A41000000006B592441000000805A325A419A9999997E592441000000605A325A419A99999990592441333333335A325A4166666666A1592441000000005A325A419A999999B0592441000000C059325A419A999999BE5924419A99997959325A4166666666CB592441CDCCCC2C59325A41CDCCCCCCD7592441666666E658325A4166666666E35924419A99999958325A4166666666EE5924419A99993958325A4166666666F7592441CDCCCCCC57325A4166666666FF5924416666664657325A4133333333075A2441CDCCCC8C56325A419A9999990E5A2441CDCCCC8C55325A41CDCCCCCC0F5A24410000006055325A4133333333125A2441CDCCCC0C54325A419A999999165A2441CDCCCCCC52325A41CDCCCCCC205A2441CDCCCCAC51325A41CDCCCCCC285A24410000000051325A4166666666FA5924410000006040325A4100000000EE592441666666463C325A4100000000D85924413333339334325A4100000000D3592441666666C632325A419A999999CE5924419A99991931325A4166666666BE5924419A9999192B325A4100000000B0592441CDCCCCCC25325A419A999999825924416666664614325A41000000007E592441CDCCCC8C12325A413333333357592441CDCCCCCC03325A41666666664B59244166666646FF315A41CDCCCCCC3F592441666666E6FA315A416666666628592441666666E6FE315A41333333330E5924410000008002325A4100000000F0582441666666A606325A4166666666C7582441000000400C325A41CDCCCCCCA25824410000004011325A419A99999973582441666666E617325A41000000003E582441666666661F325A41CDCCCCCC355824419A99999920325A413333333310582441000000E025325A41CDCCCCCCA55724419A9999B934325A41CDCCCCCC7A572441CDCCCCEC3A325A413333333350572441333333B340325A41CDCCCCCC11572441CDCCCC6C49325A410000000004572441333333534B325A41CDCCCCCCB85624419A9999D955325A419A999999AF5624410000002057325A4166666666A15624410000002059325A419A9999998C562441333333F35C325A41	01060000206A08000001000000010300000001000000100000009A9999998C562441333333F35C325A41CDCCCCCC9D562441000000E060325A4100000000EE562441000000005F325A4166666666BE5724419A9999995B325A41CDCCCCCC57582441666666465A325A419A9999991D5924419A9999995A325A4166666666A1592441000000005A325A4166666666F7592441CDCCCCCC57325A41CDCCCCCC285A24410000000051325A4100000000B0592441CDCCCCCC25325A41CDCCCCCC3F592441666666E6FA315A416666666628592441666666E6FE315A41CDCCCCCCA25824410000004011325A4166666666A15624410000002059325A419A9999998C562441333333F35C325A419A9999998C562441333333F35C325A41	01010000206A080000EC434EE2CD5824419A9999192E325A41	930140104	H	Iris 3	9301401	93014	93	11	0
01060000206A08000001000000010300000001000000210000009A999999955B24410000000081325A4166666666F65B2441000000608A325A41333333339B5D24419A999919B4325A419A999999B25D244133333393B6325A4166666666D75D244166666606BA325A4100000000185E2441CDCCCC4CB1325A41666666666F5E244166666606A5325A41CDCCCCCC875E2441000000A0A1325A4100000000B35E2441666666A69B325A41CDCCCCCCEE5E24416666666693325A419A999999F85E24413333331392325A4100000000095F2441CDCCCCAC8F325A4100000000345F2441CDCCCCEC89325A419A999999285F2441CDCCCC4C8A325A41CDCCCCCC195F2441CDCCCCEC8A325A4100000000045F24419A9999B98B325A4100000000E95E24419A9999798C325A4133333333A95E24419A9999998C325A41666666668A5E2441CDCCCCAC8C325A4166666666355E2441666666A68C325A4166666666F05D2441666666A68C325A4133333333BD5D24419A9999F98B325A4100000000A35D2441333333538B325A4133333333725D2441CDCCCC6C88325A4100000000625D24413333333387325A419A999999285D24419A99993983325A419A999999C25C2441CDCCCCAC7C325A4133333333B75C2441333333F37B325A419A999999675C2441CDCCCC0C77325A4100000000F85B24416666662671325A4133333333EA5B2441000000A073325A41000000009A5B24416666666680325A419A999999955B24410000000081325A41	01060000206A080000010000000103000000010000000B0000009A999999955B24410000000081325A4166666666F65B2441000000608A325A4166666666D75D244166666606BA325A4100000000345F2441CDCCCCEC89325A4100000000E95E24419A9999798C325A4166666666F05D2441666666A68C325A4100000000A35D2441333333538B325A419A999999675C2441CDCCCC0C77325A4100000000F85B24416666662671325A419A999999955B24410000000081325A419A999999955B24410000000081325A41	01010000206A0800009EAF9BF5A55D24416666668697325A41	930140105	H	Iris 4	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000001C000000CDCCCCCCBE5A24413333333389325A4166666666235B2441666666A6AF325A4100000000375B244100000040BE325A4133333333375B2441333333D3C4325A4100000000205B244100000040D4325A419A999999E35A24419A999959E6325A419A999999E05A2441000000E0FE325A4133333333D15A24419A9999390F335A41333333334A5B2441CDCCCC0C1D335A4100000000C65B2441666666062C335A41CDCCCCCCED5B24419A9999592F335A41333333334C5C2441CDCCCC2C32335A419A999999705D2441CDCCCC8C43335A41333333338B5D24419A99991944335A4166666666CC5D24419A9999193D335A4133333333E35D24416666666635335A41CDCCCCCC585D2441333333732B335A419A999999745D24419A9999B9FF325A419A999999985D244166666686E8325A4100000000AE5D2441CDCCCC0CD6325A41CDCCCCCC515D2441333333D3CC325A4166666666D75D244166666606BA325A4166666666F65B2441000000608A325A419A999999955B24410000000081325A4133333333635B2441666666A688325A41333333334B5B24410000008089325A41CDCCCCCCBE5A24413333333389325A41CDCCCCCCBE5A24413333333389325A41	01010000206A080000C85382BC455C2441333333B3E2325A41	930140106	H	Iris 5	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000001C000000000000006A5024416666662680315A4100000000C3502441CDCCCC0C93315A4166666666A551244166666606C0315A410000000049522441666666C6DF315A41666666669852244133333313F0315A4100000000E9532441CDCCCC6CD5315A41CDCCCCCC6154244166666606EE315A419A9999998C562441333333F35C325A4166666666A15624410000002059325A41CDCCCCCCA25824410000004011325A416666666628592441666666E6FE315A419A9999997758244100000000E8315A41CDCCCCCCEF58244166666646C2315A41CDCCCCCC0C5924419A9999D9BE315A4133333333085924419A999919B8315A41CDCCCCCCE2582441CDCCCCACB8315A4133333333D858244100000080B3315A41CDCCCCCC2A55244166666686C0315A4166666666ED5424419A999959BF315A4133333333E454244166666606C1315A41CDCCCCCC7054244133333393CA315A41333333337E532441333333D3B1315A4166666666AA53244166666626AE315A41CDCCCCCCFE522441666666C6A4315A41CDCCCCCCC9522441CDCCCC8C45315A419A999999AE5024419A99993950315A41000000006A5024416666662680315A41000000006A5024416666662680315A41	01010000206A0800003C9459DD60552441666666F6D2315A41	930140107	H	Iris 6	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000002E00000000000000804A24410000002033325A419A999999074B24410000002050325A4166666666234B2441666666E64E325A4133333333574B24419A99999951325A4133333333E84B2441666666C65E325A419A9999992B4C24416666668661325A4133333333B14C2441CDCCCCEC69325A4133333333DC4C24410000008066325A4133333333AA4D2441000000608C325A4166666666EA4D24410000006097325A4100000000164E2441666666C69A325A419A999999C84E244100000080A4325A4133333333104F24419A9999F9A6325A41CDCCCCCCA04F244100000040A6325A41333333334650244100000080AC325A41000000004F512441CDCCCC4CB8325A41CDCCCCCC5C51244166666666B3325A419A9999997C512441CDCCCCECB0325A419A9999999A5124419A9999F9B1325A419A9999991A522441333333F3A8325A4100000000D2532441CDCCCC2C88325A419A9999995E542441333333F37D325A419A999999D45424416666664676325A416666666661552441000000A06E325A4133333333F2552441000000E067325A41CDCCCCCC9D562441000000E060325A41000000007E5624419A99993959325A41CDCCCCCC31562441000000A04A325A41CDCCCCCC6154244166666606EE315A4100000000E9532441CDCCCC6CD5315A41666666669852244133333313F0315A410000000049522441666666C6DF315A4166666666A551244166666606C0315A4100000000C3502441CDCCCC0C93315A41000000006A5024416666662680315A4100000000784F2441666666862D325A419A999999FD4E2441CDCCCCEC31325A419A9999993E4E24419A9999393C325A41CDCCCCCCFA4D24419A9999393B325A41CDCCCCCC854D2441000000E03D325A41000000003E4D2441CDCCCCEC40325A4133333333F64A2441666666A636325A4166666666A74A24419A99997934325A419A999999974A24416666664631325A4100000000804A24410000002033325A4100000000804A24410000002033325A41	01010000206A080000A446EA2178522441000000B022325A41	930140108	H	Iris 7	9301401	93014	93	11	1
01060000206A0800000100000001030000000100000035000000CDCCCCCCD355244166666666BF325A4133333333DE5524419A999979BF325A4166666666F6552441CDCCCCACBF325A419A99999915562441CDCCCCECBF325A41333333335956244133333353C0325A41666666666556244100000060C0325A4133333333E456244166666646C1325A413333333328572441333333F3C1325A419A9999994257244133333333C2325A419A9999994B5724419A999999C1325A41666666666D5724419A9999D9C1325A41CDCCCCCC8857244166666606C2325A419A999999DD572441333333B3C2325A41CDCCCCCC1E58244100000020C4325A41CDCCCCCC3C5824419A999939C4325A419A99999936582441CDCCCC2CA6325A419A9999993658244166666686A5325A41CDCCCCCC0F58244166666686A5325A4133333333CB5724419A999979A5325A4133333333C8572441666666468E325A4166666666445724419A9999598E325A41CDCCCCCC41572441333333538C325A419A9999993A572441000000E088325A4100000000305724413333333386325A4166666666DC5624416666668671325A4133333333C2562441000000A06A325A4100000000A2562441333333B362325A41CDCCCCCC9D562441000000E060325A419A999999665624419A99993963325A4166666666645624413333335363325A4133333333695624416666666664325A41333333336B5624416666660665325A41000000006B562441CDCCCCAC67325A4100000000615624413333333369325A419A9999995C562441CDCCCC6C6A325A41666666665C562441000000A06B325A41000000005D5624419A9999396D325A410000000060562441333333336E325A419A99999948562441666666866D325A41CDCCCCCC3D5624410000008073325A4133333333365624416666666674325A410000000028562441333333937E325A416666666624562441666666067F325A4166666666115624419A99995986325A419A999999035624413333331391325A4100000000F4552441CDCCCCEC9C325A4100000000F1552441000000E09E325A4133333333E4552441333333D3A6325A4166666666E1552441333333D3A8325A4100000000DA55244133333333AE325A41CDCCCCCCD8552441666666E6B3325A419A999999D855244100000020B5325A41CDCCCCCCD355244166666666BF325A41	01060000206A0800000100000001030000000100000012000000CDCCCCCCD355244166666666BF325A419A999999DD572441333333B3C2325A41CDCCCCCC3C5824419A999939C4325A419A9999993658244166666686A5325A4133333333CB5724419A999979A5325A4133333333C8572441666666468E325A4166666666445724419A9999598E325A419A9999993A572441000000E088325A4100000000A2562441333333B362325A41CDCCCCCC9D562441000000E060325A4166666666645624413333335363325A410000000060562441333333336E325A419A99999948562441666666866D325A410000000028562441333333937E325A4166666666115624419A99995986325A4100000000DA55244133333333AE325A41CDCCCCCCD355244166666666BF325A41CDCCCCCCD355244166666666BF325A41	01010000206A08000058EE6990E25624410000000097325A41	930140109	H	Iris 8	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000001D000000CDCCCCCC9D562441000000E060325A4100000000A2562441333333B362325A419A9999993A572441000000E088325A4166666666445724419A9999598E325A4133333333C8572441666666468E325A4133333333CB5724419A999979A5325A419A9999993658244166666686A5325A41CDCCCCCC3C5824419A999939C4325A4133333333B7582441000000A0C3325A419A99999950592441666666E6C4325A419A999999075A2441666666E6C8325A4100000000475A2441000000E0CB325A419A999999175B24419A999979D7325A4133333333375B2441333333D3C4325A4100000000375B244100000040BE325A4166666666235B2441666666A6AF325A4133333333C05A2441000000C089325A419A9999997B5A2441CDCCCCCC73325A4133333333495A2441CDCCCC4C5E325A41333333331D5A2441333333335A325A41CDCCCCCC0F5A24410000006055325A4166666666F7592441CDCCCCCC57325A4166666666A1592441000000005A325A419A9999991D5924419A9999995A325A41CDCCCCCC57582441666666465A325A4166666666BE5724419A9999995B325A4100000000EE562441000000005F325A41CDCCCCCC9D562441000000E060325A41CDCCCCCC9D562441000000E060325A41	01010000206A080000DA9FF0055A5924419A9999E999325A41	930140110	H	Iris 9	9301401	93014	93	11	0
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	01060000206A08000001000000010300000001000000190000009A999999845424419A9999B917335A41666666661A552441CDCCCCCC18335A41000000003F552441000000801F335A413333333339552441333333D324335A4100000000A1552441CDCCCC8C26335A413333333381562441666666A62B335A41CDCCCCCC0E572441666666662C335A41333333335F572441000000C02E335A416666666607582441666666062D335A41666666661A5924419A99997923335A41CDCCCCCC6A592441000000601A335A41666666660C5924419A9999D905335A41CDCCCCCC055924419A9999D9F7325A4133333333C1582441CDCCCCACED325A41CDCCCCCC1E58244100000020C4325A419A999999DD572441333333B3C2325A419A9999994257244133333333C2325A410000000040552441CDCCCC2CBE325A416666666635552441000000E0D0325A419A999999A8542441CDCCCC4CCF325A419A9999999A54244166666626FE325A410000000086542441CDCCCC0C05335A41CDCCCCCC8C5424419A99995916335A419A999999845424419A9999B917335A419A999999845424419A9999B917335A41	01010000206A0800005EB81A73D056244100000020F7325A41	930140111	H	Iris 10	9301401	93014	93	11	0
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	01060000206A080000010000000103000000010000003100000000000000365524419A99999926335A413333333349552441CDCCCC0C37335A41CDCCCCCC80552441000000804E335A4166666666C0552441666666666C335A410000000004562441CDCCCCCC87335A41CDCCCCCCD6562441CDCCCC2CAB335A4166666666FC5624419A9999F9AF335A4133333333F357244133333353CA335A416666666614582441666666A6C7335A41333333336658244100000060B6335A419A999999A7582441666666A6AF335A41CDCCCCCCF3582441000000E0A5335A4100000000265924419A999939A2335A413333333377592441000000E09F335A4166666666B6592441CDCCCC0C99335A41333333336D5B2441CDCCCC8C93335A419A9999990B5C2441CDCCCC0C7F335A41CDCCCCCCC15C24419A99999971335A41CDCCCCCCBE5C2441000000E06E335A4100000000075D2441CDCCCC4C5E335A4100000000735D24413333331347335A419A999999705D2441CDCCCC8C43335A41333333334C5C2441CDCCCC2C32335A41CDCCCCCCED5B24419A9999592F335A4100000000C65B2441666666062C335A41333333334A5B2441CDCCCC0C1D335A4133333333D15A24419A9999390F335A419A999999E05A2441000000E0FE325A419A999999E35A24419A999959E6325A419A999999175B24419A999979D7325A4100000000475A2441000000E0CB325A419A999999075A2441666666E6C8325A419A99999950592441666666E6C4325A4133333333B7582441000000A0C3325A41CDCCCCCC86582441000000A0C4325A41CDCCCCCC1E58244100000020C4325A4133333333C1582441CDCCCCACED325A41CDCCCCCC055924419A9999D9F7325A41666666660C5924419A9999D905335A41CDCCCCCC6A592441000000601A335A41666666661A5924419A99997923335A416666666607582441666666062D335A41333333335F572441000000C02E335A41CDCCCCCC0E572441666666662C335A413333333381562441666666A62B335A4100000000A1552441CDCCCC8C26335A413333333339552441333333D324335A4100000000365524419A99999926335A4100000000365524419A99999926335A41	01010000206A0800000D418B876E5924410000005045335A41	930140112	H	Iris 11	9301401	93014	93	11	1
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	01060000206A080000010000000103000000010000001F000000000000004F512441CDCCCC4CB8325A41CDCCCCCCA45124419A999919BC325A41666666662F52244166666606C1325A41CDCCCCCC3653244100000060C4325A41333333333554244100000060D6325A4100000000655424419A999939DC325A419A999999845424419A9999B917335A41CDCCCCCC8C5424419A99995916335A410000000086542441CDCCCC0C05335A419A9999999A54244166666626FE325A419A999999A8542441CDCCCC4CCF325A416666666635552441000000E0D0325A410000000040552441CDCCCC2CBE325A41CDCCCCCCD355244166666666BF325A4100000000DA55244133333333AE325A4166666666115624419A99995986325A410000000028562441333333937E325A419A99999948562441666666866D325A410000000060562441333333336E325A4166666666645624413333335363325A4133333333F2552441000000E067325A416666666661552441000000A06E325A419A999999D45424416666664676325A419A9999995E542441333333F37D325A4100000000D2532441CDCCCC2C88325A419A9999991A522441333333F3A8325A419A9999999A5124419A9999F9B1325A419A9999997C512441CDCCCCECB0325A41CDCCCCCC5C51244166666666B3325A41000000004F512441CDCCCC4CB8325A41000000004F512441CDCCCC4CB8325A41	01010000206A0800004692CE70CB53244134333323BD325A41	930140113	H	Iris 12	9301401	93014	93	11	0
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	01010000206A080000654196A60D6A244134333373B0335A41	930150000	Z	Coubron	9301500	93015	93	11	4
01060000206A080000010000000103000000010000002D01000033333333EAFB2341666666C696355A4166666666EDFB2341000000C099355A4100000000F0FB23419A9999399C355A41CDCCCCCCF6FB23419A9999D9A2355A4133333333F7FB23419A999919A3355A41CDCCCCCCFDFB234166666686A9355A416666666618FC2341CDCCCCCCC2355A41666666661EFC2341666666A6C8355A419A99999926FC234133333373D0355A410000000029FC2341000000C0D2355A41000000002BFC23419A9999B9D4355A419A9999992DFC234133333313D7355A410000000032FC2341CDCCCC4CDB355A41333333333CFC2341CDCCCC4CE5355A413333333342FC2341333333F3EA355A413333333348FC2341333333B3F0355A41CDCCCCCC48FC23419A999939F1355A410000000050FC2341CDCCCC2CF9355A419A9999995CFC2341CDCCCC6C07365A41333333335EFC23410000004009365A410000000065FC2341CDCCCCAC10365A41000000006EFC23419A9999D91A365A41CDCCCCCC77FC2341666666E625365A416666666679FC2341CDCCCCCC27365A41CDCCCCCC80FC23416666660630365A41CDCCCCCC82FC23419A99991932365A413333333395FC2341CDCCCCEC46365A41CDCCCCCC1FFD23419A9999B955365A41333333333CFD23419A99995957365A410000000047FD2341666666E657365A41CDCCCCCC1FFE2341333333F362365A413333333344FE2341333333D364365A413333333339FE23410000002071365A416666666632FE2341333333B378365A419A9999992FFE2341000000E07A365A41666666662EFE2341000000E07B365A410000000051FE23419A9999B97C365A410000000076FE2341000000A07D365A410000000098FE23419A9999797E365A4133333333B5FE2341CDCCCC2C7F365A419A999999CAFE2341666666E67F365A41CDCCCCCC02FF2341CDCCCCEC81365A413333333324FF2341000000E083365A41666666662CFF23413333335384365A413333333361FF23416666666687365A416666666669FF2341000000E087365A41CDCCCCCC90FF2341333333538A365A41000000009FFF2341333333338B365A4100000000A9FF2341333333D38B365A4133333333CCFF2341000000008E365A4133333333E3FF2341333333738F365A419A999999ED0024419A999979A0365A41CDCCCCCC84012441666666E6AB365A4100000000DF012441CDCCCCECB1365A4166666666EF012441CDCCCC0CB3365A41333333333302244166666686B8365A419A9999998702244133333333C1365A419A99999994022441666666E6C2365A419A999999B9022441333333B3C7365A4133333333E60224419A999959CC365A4166666666ED0224419A999919CD365A41666666662C032441CDCCCC4CD5365A4166666666320324419A999959D6365A41666666665403244133333353DC365A419A99999967032441333333B3DF365A41666666666C032441CDCCCC8CE0365A41000000009403244166666646E9365A4133333333A103244166666646ED365A419A999999A6032441666666E6EE365A4100000000AC0324419A999979F0365A4100000000B4032441CDCCCCACF2365A4133333333BC032441CDCCCC8CF5365A41CDCCCCCCC503244166666626FA365A4133333333CF03244166666606FD365A4133333333D8032441000000A0FE365A4166666666E10324410000008000375A41CDCCCCCCEE0324419A99993905375A4133333333F70324419A9999B908375A4166666666F9032441333333730A375A4166666666FC032441333333F30A375A416666666601042441333333F30A375A416666666604042441333333B30A375A416666666609042441CDCCCCEC09375A41666666660D042441CDCCCCEC09375A416666666612042441666666660A375A416666666613042441666666460C375A41CDCCCCCC17042441666666660D375A41CDCCCCCC26042441000000C00E375A4133333333300424413333331310375A4100000000400424419A99995912375A4100000000460424413333333314375A419A9999994B0424419A9999F915375A410000000054042441333333D319375A41000000005A042441CDCCCC4C1D375A41666666665B042441333333131E375A41CDCCCCCC5C042441CDCCCC0C21375A41CDCCCCCC8B042441CDCCCCAC27375A4100000000990424413333335329375A419A999999D8042441CDCCCC4C31375A41CDCCCCCCDA0424419A9999F930375A419A999999EC042441333333732E375A4166666666F6042441333333132D375A419A999999FD042441CDCCCC0C2C375A41CDCCCCCC02052441CDCCCC0C2D375A41CDCCCCCC07052441000000802F375A41CDCCCCCC08052441666666E62F375A419A9999990B052441CDCCCCEC30375A41CDCCCCCC190524416666666632375A41CDCCCCCC1B0524416666666633375A419A9999991D0524416666660634375A419A99999923052441CDCCCC6C34375A41666666662C052441CDCCCC8C34375A416666666640052441CDCCCC4C37375A419A99999941052441CDCCCC0C38375A41CDCCCCCC410524419A9999D938375A419A99999941052441CDCCCCAC3A375A41CDCCCCCC42052441666666E63B375A419A99999946052441666666463D375A419A9999994C052441CDCCCC2C3E375A419A99999964052441CDCCCCEC40375A41333333337F0524410000004042375A41CDCCCCCC98052441000000E045375A41000000009D0524416666666646375A419A9999999F0524416666664646375A419A999999A7052441CDCCCC8C46375A419A999999AE052441CDCCCC6C47375A419A999999B1052441CDCCCC0C48375A419A999999B1052441CDCCCC8C48375A41CDCCCCCCB0052441CDCCCCEC48375A419A999999BA052441666666264A375A4100000000C6052441CDCCCC2C4B375A419A999999C9052441666666464C375A419A999999CC052441666666064D375A419A999999D3052441CDCCCCCC4D375A419A999999E1052441666666464E375A4100000000F1052441CDCCCC6C4E375A4133333333F70524419A9999994F375A419A999999FA0524416666668650375A416666666605062441CDCCCCAC51375A419A99999913062441CDCCCC8C52375A419A99999925062441666666E653375A41666666662B0624413333337354375A416666666630062441CDCCCCEC54375A416666666637062441CDCCCC2C55375A41666666663E062441666666E654375A41666666664A062441CDCCCC8C54375A419A99999957062441666666A654375A416666666666062441CDCCCCCC55375A419A99999974062441CDCCCC8C57375A41666666667F062441666666A658375A416666666680062441CDCCCCAC58375A41666666668B062441CDCCCC0C59375A416666666692062441CDCCCCEC58375A4166666666A2062441CDCCCC6C58375A4166666666AB062441CDCCCC4C58375A41CDCCCCCCB5062441CDCCCCEC58375A4166666666BD062441CDCCCC6C59375A4166666666E0062441CDCCCC8C5D375A41CDCCCCCCFA062441666666A660375A4166666666230724419A99997965375A419A999999260724419A9999D965375A41CDCCCCCC4C072441000000606A375A4100000000640724419A9999196D375A41666666668A072441CDCCCCAC71375A41666666669E0724416666668674375A4133333333A6072441666666A675375A4100000000C2072441CDCCCCAC7A375A4133333333CC072441CDCCCC8C7C375A4133333333D40724419A9999197C375A4166666666F50724419A99999977375A4166666666210824419A99999971375A41CDCCCCCC27082441000000C070375A4100000000D00824419A9999F959375A4133333333E40824419A99993957375A4133333333F6082441666666C654375A4133333333F50824416666662652375A4166666666ED0824419A99995951375A4166666666CE082441666666264E375A4166666666C2082441666666E64C375A4133333333BC082441666666464C375A4133333333BE082441666666264A375A419A999999E10824419A99999943375A419A99999955092441666666462E375A41CDCCCCCCC2092441666666861A375A4166666666E3092441666666A614375A4133333333070A2441333333330E375A4166666666170A2441666666460B375A41CDCCCCCC1C0A24419A9999590A375A4166666666260A2441333333D308375A41666666662B0A2441CDCCCCEC06375A4100000000340A2441666666A604375A41000000003E0A24413333339303375A41CDCCCCCC4B0A24419A9999B902375A4133333333570A24413333337301375A41333333335F0A2441CDCCCCCCFF365A41CDCCCCCC620A2441000000A0FD365A4166666666640A2441CDCCCC4CFB365A41CDCCCCCC6D0A2441666666E6F7365A41CDCCCCCC710A2441CDCCCCACF5365A419A999999770A244133333353F3365A419A9999997D0A244166666606F2365A4133333333960A244100000020EE365A4166666666A00A244133333313E9365A419A999999A10A24419A999959E8365A419A999999AD0A244100000040E2365A41CDCCCCCCAF0A244166666646E1365A4100000000BC0A244166666646E0365A41CDCCCCCCDA0A2441CDCCCCACDD365A4133333333000C244100000000C5365A41CDCCCCCC300C2441666666E6C0365A419A9999996D0C244133333393BC365A4133333333750C244100000000BB365A4100000000990C244133333333B5365A41CDCCCCCC9E0C2441000000C0B3365A41CDCCCCCCC50C2441333333F3A9365A41CDCCCCCCC60C2441333333B3A9365A41CDCCCCCCEE0C2441666666A69F365A41CDCCCCCC540D2441666666E690365A4100000000580D24413333337390365A4100000000C10D2441666666E681365A4133333333080E24419A9999197C365A4166666666AA0E24413333333371365A4133333333E10E24419A99991968365A419A9999990C0F2441000000E062365A41CDCCCCCC310F24413333331361365A41666666663E0F24413333337360365A4166666666470F24416666660660365A41CDCCCCCC4D0F2441333333B35D365A419A999999A40F2441000000803E365A4100000000790F2441000000803C365A41CDCCCCCC530F2441666666C63A365A41CDCCCCCC690F2441CDCCCC4C37365A4100000000690F24419A99993937365A41666666665A0F24419A99999935365A41666666662B0F24416666666630365A419A999999240F2441CDCCCCAC2F365A4166666666180F2441CDCCCC4C2E365A41CDCCCCCCF20E2441666666262A365A4166666666020F24416666662624365A419A999999090F24416666666621365A4166666666100F2441000000C01E365A4133333333150F2441666666061D365A4166666666180F2441000000C01B365A41CDCCCCCCBE0E24419A9999F917365A4100000000420E24416666668612365A41333333333D0E2441CDCCCC4C12365A4166666666350E2441333333F311365A4166666666270E24419A99995911365A41CDCCCCCC130E24410000008010365A4133333333080E24416666660610365A4100000000590D24410000004008365A4166666666CA0C24419A99991902365A41333333334F0C24419A999999FC355A419A999999490C24419A999959FC355A41000000003A0C2441666666A6FB355A4100000000300C24419A999939FB355A41CDCCCCCC2D0C244100000020FB355A41666666661F0C24419A999979FA355A4166666666190C244100000040FA355A4166666666FF0B24419A999919F9355A41CDCCCCCCF8092441CDCCCC8CE2355A419A9999990108244133333353CC355A4100000000BD0724419A9999D9C9355A4133333333A607244166666606C9355A410000000087072441000000E0C7355A41333333337307244166666626C7355A41CDCCCCCC3D0724419A999939C5355A41CDCCCCCC2507244100000000C4355A419A9999990C072441000000C0C2355A41CDCCCCCC08072441CDCCCC8CC2355A419A999999E30624419A9999B9C0355A4166666666DD06244166666666C0355A4166666666D30624419A9999F9BF355A41CDCCCCCC87062441666666A6BC355A413333333335062441666666A6B9355A41CDCCCCCCAD052441CDCCCC2CB4355A4100000000E5042441CDCCCCACAD355A410000000050042441666666C6A9355A4166666666CC0324419A9999F9A6355A416666666617032441CDCCCCACA1355A41CDCCCCCCD3012441CDCCCCAC9D355A4100000000700124419A9999F99C355A4133333333B80024419A9999199C355A419A999999CFFF2341333333139C355A416666666652FF2341333333D39A355A41CDCCCCCC32FF23419A9999B99A355A4133333333A4FE2341CDCCCC4C9A355A416666666625FE23419A9999B999355A41CDCCCCCC02FE2341CDCCCC8C99355A41CDCCCCCCF2FD23419A99997999355A41CDCCCCCCE0FD23416666666699355A419A999999DCFD23410000006099355A4166666666DAFD23419A99995999355A41CDCCCCCCD8FD23419A99995999355A4133333333B0FD23413333333399355A419A999999ACFD23413333333399355A410000000090FD2341CDCCCC0C99355A41000000001CFD2341CDCCCC6C98355A41CDCCCCCCC0FC2341333333D397355A41CDCCCCCCA0FC2341666666C697355A4133333333EAFB2341666666C696355A41	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	01010000206A080000C90E1412850624419A99991989365A41	930270102	D	Parc Départemental	9302701	93027	93	11	3
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	01060000206A08000001000000010300000001000000180000003333333337FC23416666666682345A41000000004DFC23419A9999398B345A413333333378FC2341CDCCCC0CA5345A419A9999997DFC23419A9999B9B5345A4100000000D4FC23419A999999E5345A419A999999E4FC234166666606F1345A416666666617FD23419A9999B9EE345A4100000000ADFD23416666662617355A419A999999C5FE23419A99995905355A4100000000E7FF234133333373F1345A41CDCCCCCCD7FF2341CDCCCCACED345A419A99999923002441333333D3E8345A41CDCCCCCC5A012441000000E0D7345A419A9999996A01244100000000DB345A4100000000E1012441666666A6D3345A41000000009C0224419A9999B9C6345A41000000003A03244166666666BF345A419A99999962032441666666E6B8345A41CDCCCCCC480124419A999979A9345A4166666666FD002441666666E6A7345A41666666668BFE23413333339395345A410000000048FD2341CDCCCC6C8B345A413333333337FC23416666666682345A413333333337FC23416666666682345A41	01010000206A080000CDE667EA6FFF234100000090CD345A41	930270103	H	Mairie	9302701	93027	93	11	0
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	01010000206A0800009CA6E7344E0A24419A9999494E355A41	930270101	A	Zone Industrielle	9302701	93027	93	11	2
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	01060000206A0800000100000001030000000100000018000000CDCCCCCC8EFE2341666666E608355A41CDCCCCCC9DFE23413333331310355A419A99999914FF2341CDCCCCCC2D355A41CDCCCCCCE7FF23413333337332355A41CDCCCCCCC9002441CDCCCCCC2A355A413333333356012441333333934C355A419A999999D30124410000002051355A410000000031022441CDCCCC6C49355A419A999999620224419A9999D940355A4166666666AE022441666666C617355A41CDCCCCCCC70224419A9999F912355A419A9999995C0324416666660610355A41CDCCCCCC64032441333333B3C1345A41CDCCCCCC630324419A999919BB345A41000000003A03244166666666BF345A41000000009C0224419A9999B9C6345A4100000000E1012441666666A6D3345A419A9999996A01244100000000DB345A41CDCCCCCC5A012441000000E0D7345A419A99999923002441333333D3E8345A41CDCCCCCCD7FF2341CDCCCCACED345A4100000000E7FF234133333373F1345A41CDCCCCCC8EFE2341666666E608355A41CDCCCCCC8EFE2341666666E608355A41	01010000206A0800001A3E45E1030124410000002007355A41	930270104	H	Convention	9302701	93027	93	11	0
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	01060000206A08000001000000010300000001000000310000000000000012022441333333F340345A41CDCCCCCC35022441333333934F345A4166666666A20224413333331379345A419A999999D50224419A9999F98A345A41CDCCCCCC34032441333333F3A3345A41666666665E032441CDCCCC2CB3345A41CDCCCCCC630324419A999919BB345A419A999999AF03244166666686B0345A4133333333EF03244166666686AC345A4166666666E6042441CDCCCCCCA1345A419A9999994D05244166666686A0345A416666666687052441CDCCCC0C9D345A41CDCCCCCCB2052441000000E095345A4166666666CE072441333333B379345A419A99999926082441CDCCCC4C73345A41CDCCCCCC38092441CDCCCCEC58345A4166666666960924413333337350345A41333333335F0A2441333333D33C345A41CDCCCCCC2A0B2441666666262A345A41000000005E0B2441000000C024345A419A999999460B2441666666261F345A4133333333A30A24416666660602345A4100000000A0092441666666A6DA335A419A9999996B0924419A9999D9DF335A41000000002309244100000040EB335A419A999999A7082441333333B3EC335A41000000003F08244166666666F1335A4133333333E907244166666626F7335A4100000000720724413333337301345A4166666666590724410000006006345A4100000000720724419A9999790C345A4133333333190724419A99995914345A4166666666BC062441666666E620345A4166666666A8062441CDCCCC4C2F345A419A9999998D062441CDCCCC4C31345A4133333333400624416666664640345A419A999999B40524419A9999D949345A419A99999995052441CDCCCC2C4A345A410000000053052441666666A64E345A4133333333ED0424416666660652345A41CDCCCCCC6B042441CDCCCC0C55345A41666666663D0424413333335353345A41CDCCCCCC7C032441CDCCCC6C47345A419A999999F8022441CDCCCC2C4A345A4133333333980224419A99995949345A41000000008F0224410000008045345A41666666664F022441000000C041345A410000000012022441333333F340345A410000000012022441333333F340345A41	01010000206A08000001CFA2AAAD072441CDCCCCAC4A345A41	930270105	H	Anatole France	9302701	93027	93	11	0
01060000206A080000010000000103000000010000006F0000006666666624F823419A9999D956345A41666666663CF82341666666E657345A4166666666B6F923413333333369345A410000000019FA2341666666666D345A41CDCCCCCC27FA2341CDCCCC0C6E345A41CDCCCCCC32FA2341000000806E345A419A999999ADFA23410000008073345A419A999999E3FA2341CDCCCCAC75345A419A999999AEFB2341CDCCCC6C7D345A413333333337FC23416666666682345A419A9999994BFC23416666660683345A410000000048FD2341CDCCCC6C8B345A41CDCCCCCCC5FD2341333333738F345A41666666668BFE23413333339395345A4166666666FD002441666666E6A7345A41666666660E01244166666646A8345A413333333306012441CDCCCC8CA6345A419A999999FD0024419A9999D9A4345A4100000000FD0024419A9999B9A4345A4133333333F20024419A9999D9A2345A4166666666E900244166666686A1345A4133333333E700244133333333A1345A4133333333D5002441CDCCCCAC9E345A4100000000D4002441000000809E345A4100000000D00024419A9999D99D345A4100000000CA002441666666E69C345A419A999999C1002441CDCCCCEC9B345A4100000000C00024419A9999B99B345A4166666666B6002441333333739A345A41CDCCCCCCAC0024410000006099345A4100000000A40024413333335398345A419A9999999E002441333333B397345A4166666666890024410000008095345A41CDCCCCCC7D0024413333335394345A41666666667A0024410000000094345A413333333369002441CDCCCC6C92345A41666666664B002441333333F38F345A419A999999450024419A9999798F345A41CDCCCCCC2E002441CDCCCCAC8D345A41CDCCCCCC190024419A9999598B345A4100000000080024413333333389345A4100000000F7FF2341CDCCCCAC86345A4166666666E3FF23413333339383345A4166666666CAFF2341333333B37F345A4166666666B7FF2341000000E07C345A41333333339EFF2341CDCCCCAC79345A419A99999990FF23419A99993978345A416666666689FF23413333337377345A413333333372FF23413333335375345A410000000053FF23413333335373345A41CDCCCCCC43FF23416666668672345A413333333336FF2341333333D371345A410000000012FF23413333335370345A4166666666ECFE2341666666466F345A4133333333C4FE2341000000206E345A41CDCCCCCCABFE2341666666666D345A4100000000A1FE23419A9999B96C345A41333333339BFE2341000000E06B345A41333333339EFE2341000000406B345A41CDCCCCCC9FFE23419A9999996A345A419A9999999EFE23419A9999D969345A41666666669AFE2341CDCCCC0C69345A416666666696FE23419A9999B968345A416666666692FE23410000008068345A41333333338DFE23419A99997968345A413333333388FE23410000008067345A41666666663FFE2341000000C046345A41666666663CFE23419A99995945345A41CDCCCCCC03FE2341666666C62A345A413333333302FE2341333333132A345A419A999999EFFD23416666660622345A41CDCCCCCCD8FD2341333333F31A345A419A999999DFFD23410000004019345A4100000000DAFD23413333331317345A4166666666C1FD2341CDCCCCCC09345A416666666681FD234100000080FE335A41000000007AFD23419A999939FD335A410000000007FD234133333373FE335A4100000000F6FC2341000000A0FE335A419A99999975FC23419A9999F9FF335A41CDCCCCCC35FC23419A99997900345A41333333331FFC2341666666A600345A4166666666BAFB23410000004002345A41CDCCCCCC4CFB2341CDCCCC8C04345A419A9999994AFB23419A99999904345A419A999999F2FA23419A99991906345A41CDCCCCCCCBFA2341666666C606345A41CDCCCCCC51FA2341CDCCCC8C09345A41CDCCCCCCFCF92341CDCCCC0C0B345A4100000000E1F923419A9999D90B345A4133333333C9F92341333333330D345A4133333333C1F92341333333F311345A419A999999ABF92341666666A617345A41CDCCCCCC90F92341CDCCCC6C1C345A410000000079F923413333331321345A416666666668F92341CDCCCC2C25345A416666666633F923410000004036345A413333333328F92341666666063A345A419A99999926F92341CDCCCC0C3B345A419A9999991EF92341666666863D345A410000000019F92341666666663F345A413333333309F923419A99995941345A4100000000FCF82341CDCCCCAC43345A4100000000E4F82341333333F346345A419A999999D3F82341CDCCCC4C48345A4133333333CBF823410000000049345A4166666666AFF82341333333534B345A416666666677F823419A9999F94F345A41333333336EF823419A9999B950345A41CDCCCCCC43F823410000004054345A416666666624F823419A9999D956345A41	01060000206A080000010000000103000000010000001C0000006666666624F823419A9999D956345A4166666666B6F923413333333369345A419A999999E3FA2341CDCCCCAC75345A413333333337FC23416666666682345A410000000048FD2341CDCCCC6C8B345A41666666668BFE23413333339395345A41666666660E01244166666646A8345A4100000000CA002441666666E69C345A413333333369002441CDCCCC6C92345A4100000000080024413333333389345A4166666666B7FF2341000000E07C345A413333333372FF23413333335375345A410000000012FF23413333335370345A41CDCCCCCCABFE2341666666666D345A413333333388FE23410000008067345A419A999999EFFD23416666660622345A4166666666C1FD2341CDCCCCCC09345A41000000007AFD23419A999939FD335A41333333331FFC2341666666A600345A41CDCCCCCCCBFA2341666666C606345A41CDCCCCCCFCF92341CDCCCC0C0B345A4133333333C9F92341333333330D345A419A999999ABF92341666666A617345A416666666668F92341CDCCCC2C25345A410000000019F92341666666663F345A4100000000E4F82341333333F346345A416666666624F823419A9999D956345A416666666624F823419A9999D956345A41	01010000206A080000E6D7E23E59FB2341CDCCCC7C52345A41	930270109	H	Francs-Tireurs Zola	9302701	93027	93	11	0
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	01060000206A08000001000000010300000001000000180000009A999999BCF62341666666A67E345A413333333394F8234100000020A8345A416666666636F82341000000A0B7345A41666666663DF82341CDCCCC2CBC345A413333333399F9234100000040D6345A4100000000E3F923419A9999D9DC345A4133333333FAF92341000000A0DB345A410000000066FA2341666666C6CE345A41CDCCCCCC45FB23419A9999F9B5345A4100000000AEFB234133333373AB345A41CDCCCCCC20FC234166666606A4345A416666666648FC23419A999999B2345A41CDCCCCCC7BFC2341333333D3B0345A413333333378FC2341CDCCCC0CA5345A41000000004DFC23419A9999398B345A413333333337FC23416666666682345A419A999999E3FA2341CDCCCCAC75345A4166666666B6F923413333333369345A416666666624F823419A9999D956345A4166666666ACF72341666666E662345A41666666669BF72341000000E066345A413333333351F72341000000006E345A419A999999BCF62341666666A67E345A419A999999BCF62341666666A67E345A41	01010000206A08000086DAE41E44FA2341666666969D345A41	930270110	H	Braque Orme Seul	9302701	93027	93	11	0
01060000206A080000010000000103000000010000003C0000003333333308F7234100000080E9345A419A99999922F723419A999979F1345A41333333335CF72341000000E002355A4133333333F0F72341000000802F355A41CDCCCCCC69F82341666666C655355A41CDCCCCCC72F82341666666A658355A41CDCCCCCC77F823419A9999395A355A41666666667DF82341000000005C355A41CDCCCCCC7DF823419A9999195C355A41333333337FF82341CDCCCC8C5C355A410000000046F923413333333358355A410000000066F92341CDCCCC4C57355A41666666668AF923410000004056355A4166666666A4F923413333337355355A4100000000A9F923413333335355355A4166666666DEF923419A99999953355A419A999999C2F923416666662647355A41CDCCCCCC8DF92341000000A033355A419A99999969F92341CDCCCCAC25355A419A99999946F923419A99995915355A41CDCCCCCC3CF92341CDCCCC4C0F355A419A99999982F92341000000C00D355A4100000000EBF92341333333F309355A4166666666F1F923419A99997909355A413333333327FA2341CDCCCC2C06355A419A99999935FA23419A99997905355A41000000003EFA23413333333305355A416666666670FA23413333339303355A416666666694FA2341333333B302355A4166666666BFFA2341333333D301355A410000000009FB23419A99995900355A41CDCCCCCC3BFB234166666626FF345A41CDCCCCCC66FB2341CDCCCCCCFD345A41CDCCCCCC94FB2341CDCCCCECFC345A41CDCCCCCC1DFB2341333333B3F3345A4100000000CAFA234166666626ED345A41CDCCCCCC85FA23419A9999F9E7345A41CDCCCCCCF2F9234133333313DE345A4133333333EEF9234166666606DE345A4133333333E8F92341333333D3DD345A41CDCCCCCCE4F9234100000060DD345A4100000000E3F923419A9999D9DC345A413333333399F9234100000040D6345A41CDCCCCCC7BF9234166666606D4345A419A99999978F92341666666C6D3345A41CDCCCCCC70F92341CDCCCC2CD3345A41CDCCCCCC69F92341666666A6D2345A413333333352F92341000000E0D0345A4166666666C8F823419A999999C6345A41CDCCCCCC5EF82341CDCCCCACBE345A41666666663DF82341CDCCCC2CBC345A413333333340F823419A999979BB345A419A99999941F8234100000060BA345A410000000040F8234166666646B9345A41000000003CF82341CDCCCC4CB8345A416666666636F82341000000A0B7345A419A99999925F8234166666666BA345A41CDCCCCCCFBF7234166666626C2345A41CDCCCCCC2EF72341CDCCCC0CE5345A413333333308F7234100000080E9345A41	01060000206A08000001000000010300000001000000160000003333333308F7234100000080E9345A4133333333F0F72341000000802F355A41333333337FF82341CDCCCC8C5C355A410000000046F923413333333358355A4166666666DEF923419A99999953355A419A999999C2F923416666662647355A419A99999969F92341CDCCCCAC25355A41CDCCCCCC3CF92341CDCCCC4C0F355A419A99999982F92341000000C00D355A4100000000EBF92341333333F309355A419A99999935FA23419A99997905355A416666666694FA2341333333B302355A41CDCCCCCC94FB2341CDCCCCECFC345A41CDCCCCCC85FA23419A9999F9E7345A41CDCCCCCCF2F9234133333313DE345A413333333399F9234100000040D6345A41666666663DF82341CDCCCC2CBC345A416666666636F82341000000A0B7345A41CDCCCCCCFBF7234166666626C2345A41CDCCCCCC2EF72341CDCCCC0CE5345A413333333308F7234100000080E9345A413333333308F7234100000080E9345A41	01010000206A080000DC98066298F823419A9999D90B355A41	930270111	H	La Tour	9302701	93027	93	11	0
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	01060000206A0800000100000001030000000100000026000000CDCCCCCC3CF92341CDCCCC4C0F355A419A99999969F92341CDCCCCAC25355A419A999999C2F923416666662647355A4166666666DEF923419A99999953355A419A99999980FA2341000000204E355A4133333333DCFA23419A99999947355A41333333334AFB2341333333933E355A41000000008CFB23419A9999D94D355A41333333331EFC23419A9999396E355A4133333333C9FB2341CDCCCC8C77355A4133333333EAFB2341666666C696355A419A999999DCFD23410000006099355A4100000000C3FD2341333333B389355A4133333333BDFD2341333333D37B355A4166666666CCFD23410000004078355A413333333361FE23419A9999B96D355A41CDCCCCCC48FE2341CDCCCCCC65355A41CDCCCCCCDDFE2341CDCCCCAC56355A419A999999C9FE23410000008050355A41CDCCCCCCFEFE2341333333734C355A41666666662EFF23416666664644355A41CDCCCCCC7BFE2341CDCCCC6C36355A416666666689FE23413333333333355A4166666666CAFE2341000000402D355A419A99999914FF2341CDCCCCCC2D355A41CDCCCCCC9DFE23413333331310355A41CDCCCCCC8EFE2341666666E608355A4100000000ADFD23416666662617355A416666666617FD23419A9999B9EE345A41CDCCCCCC8CFC234133333393F5345A4133333333CBFB2341CDCCCC4CFC345A41CDCCCCCC94FB2341CDCCCCECFC345A416666666694FA2341333333B302355A419A99999935FA23419A99997905355A4100000000EBF92341333333F309355A419A99999982F92341000000C00D355A41CDCCCCCC3CF92341CDCCCC4C0F355A41CDCCCCCC3CF92341CDCCCC4C0F355A41	01010000206A080000E37234EE47FD23416666662644355A41	930270113	H	6 Routes	9302701	93027	93	11	0
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	01060000206A080000010000000103000000010000002100000033333333BDFD2341333333D37B355A4100000000C3FD2341333333B389355A419A999999DCFD23410000006099355A416666666652FF2341333333D39A355A419A999999CFFF2341333333139C355A4133333333B80024419A9999199C355A41CDCCCCCCD3012441CDCCCCAC9D355A419A999999F70124419A9999F995355A4166666666210224419A9999F98F355A41333333334E022441CDCCCCAC85355A419A99999978022441666666A67F355A41CDCCCCCCEA022441000000A063355A419A99999916032441666666C65E355A419A9999991D032441333333935B355A41CDCCCCCCEA032441666666C643355A413333333394032441CDCCCC2C39355A41CDCCCCCC84022441CDCCCC6C58355A419A999999D30124410000002051355A413333333356012441333333934C355A41CDCCCCCCC9002441CDCCCCCC2A355A41CDCCCCCCE7FF23413333337332355A419A999999D9FE2341333333B32C355A416666666689FE23413333333333355A41CDCCCCCC7BFE2341CDCCCC6C36355A41666666662EFF23416666664644355A41CDCCCCCCFEFE2341333333734C355A419A999999C9FE23410000008050355A41CDCCCCCCDDFE2341CDCCCCAC56355A41CDCCCCCC48FE2341CDCCCCCC65355A413333333361FE23419A9999B96D355A4166666666CCFD23410000004078355A4133333333BDFD2341333333D37B355A4133333333BDFD2341333333D37B355A41	01010000206A08000081A4A3E59C002441666666B664355A41	930270114	H	Verlaine	9302701	93027	93	11	0
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	01060000206A080000010000000103000000010000002F0000009A999999D30124410000002051355A41CDCCCCCC84022441CDCCCC6C58355A413333333394032441CDCCCC2C39355A41CDCCCCCCEA032441666666C643355A419A9999991D032441333333935B355A419A99999916032441666666C65E355A41CDCCCCCCEA022441000000A063355A419A99999978022441666666A67F355A41333333334E022441CDCCCCAC85355A4166666666210224419A9999F98F355A419A999999F70124419A9999F995355A41CDCCCCCCD3012441CDCCCCAC9D355A416666666617032441CDCCCCACA1355A4166666666CC0324419A9999F9A6355A4100000000E5042441CDCCCCACAD355A41CDCCCCCCAD052441CDCCCC2CB4355A41CDCCCCCC87062441666666A6BC355A41CDCCCCCC3D0724419A999939C5355A4133333333A607244166666606C9355A41666666665C07244166666646BF355A41333333334207244133333313BA355A41333333331E07244166666666AE355A410000000009072441CDCCCC8C9E355A419A999999240724419A99995999355A416666666623072441000000A087355A41666666662C072441666666666B355A416666666638072441666666A659355A416666666636072441333333734C355A416666666622072441333333733B355A416666666607072441000000202D355A4100000000F90624413333335320355A4100000000FC062441333333D30A355A41666666660F07244100000080FC345A4100000000A6062441CDCCCC8CF9345A413333333332062441CDCCCC4CF9345A419A999999AE052441000000C0FB345A41333333334D05244100000040FC345A419A999999CC0424419A999979FE345A41000000003B042441CDCCCC0C06355A41CDCCCCCCF4032441333333130B355A41666666667E032441333333530F355A41CDCCCCCCC70224419A9999F912355A4166666666AE022441666666C617355A419A999999620224419A9999D940355A410000000031022441CDCCCC6C49355A419A999999D30124410000002051355A419A999999D30124410000002051355A41	01010000206A080000F494F27C150524419A99992962355A41	930270115	H	Quinet Cachin	9302701	93027	93	11	0
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	01060000206A08000001000000010300000001000000170000006666666687052441CDCCCC0C9D345A4100000000C905244133333373A0345A4100000000DE062441000000C096345A410000000017082441666666E696345A4133333333A5082441333333F399345A4133333333E309244100000000A0345A4100000000380A24419A9999F99F345A41000000000F0D2441666666469B345A4100000000540D24410000006099345A4100000000DB0D2441CDCCCC6C93345A4166666666C30C24416666666662345A4100000000B00C2441666666C65C345A41666666660A0C24419A9999B940345A41000000005E0B2441000000C024345A41CDCCCCCC2A0B2441666666262A345A41333333335F0A2441333333D33C345A4166666666960924413333337350345A41CDCCCCCC38092441CDCCCCEC58345A419A99999926082441CDCCCC4C73345A4166666666CE072441333333B379345A41CDCCCCCCB2052441000000E095345A416666666687052441CDCCCC0C9D345A416666666687052441CDCCCC0C9D345A41	01010000206A0800008A130AE7CB0A24416666660663345A41	930270117	H	Rateau	9302701	93027	93	11	0
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	01060000206A08000001000000010300000001000000190000003333333395092441333333D3D8335A41CDCCCCCC2C0A244166666666F0335A4133333333A30A24416666660602345A419A999999460B2441666666261F345A41000000005E0B2441000000C024345A41666666660A0C24419A9999B940345A4100000000B00C2441666666C65C345A4166666666C30C24416666666662345A4100000000DB0D2441CDCCCC6C93345A419A999999000E24413333337392345A41CDCCCCCC760F24419A9999997C345A4166666666D10E2441CDCCCC2C50345A4100000000920E24416666662640345A41CDCCCCCC120E2441CDCCCC8C28345A4100000000C70D24419A9999191C345A4100000000F60C2441000000C0FC335A419A999999DB0C2441333333F3FE335A4166666666730C244166666686ED335A41CDCCCCCCCC0B244100000020D6335A4166666666780B244133333313C5335A4166666666020B244100000000B1335A41CDCCCCCC6B0A244100000000C6335A4100000000100A244166666686CE335A413333333395092441333333D3D8335A413333333395092441333333D3D8335A41	01010000206A0800001A540AB69D0C2441333333F321345A41	930270118	H	Paul Vaillant-Couturier	9302701	93027	93	11	0
01060000206A080000010000000103000000010000002F00000000000000E3F923419A9999D9DC345A41CDCCCCCCE4F9234100000060DD345A4133333333E8F92341333333D3DD345A4133333333EEF9234166666606DE345A41CDCCCCCCF2F9234133333313DE345A41CDCCCCCC85FA23419A9999F9E7345A4100000000CAFA234166666626ED345A41CDCCCCCC1DFB2341333333B3F3345A41CDCCCCCC94FB2341CDCCCCECFC345A4100000000A6FB2341CDCCCC2CFE345A4133333333CBFB2341CDCCCC4CFC345A410000000043FC234166666646F8345A41CDCCCCCC8CFC234133333393F5345A4133333333D0FC234133333393F2345A4133333333E5FC234100000000F2345A419A999999E4FC234166666606F1345A4100000000D4FC23419A999999E5345A4100000000B2FC2341000000A0D3345A4133333333AEFC2341CDCCCC6CD1345A4166666666A9FC234166666686CE345A419A999999A3FC234133333313CB345A419A9999997DFC23419A9999B9B5345A41CDCCCCCC7BFC2341333333D3B3345A41CDCCCCCC7BFC23419A999939B3345A41CDCCCCCC7BFC2341333333D3B0345A413333333376FC2341000000C0B0345A41000000006CFC2341666666C6B0345A416666666661FC2341CDCCCC0CB1345A416666666657FC2341CDCCCC8CB1345A416666666648FC23419A999999B2345A41CDCCCCCC20FC234166666606A4345A41CDCCCCCC03FC2341CDCCCC0CA5345A4166666666ECFB234100000080A6345A419A999999CDFB2341666666C6A8345A4100000000AEFB234133333373AB345A41CDCCCCCC45FB23419A9999F9B5345A4166666666FFFA2341666666C6BD345A410000000066FA2341666666C6CE345A416666666619FA234166666686D7345A4133333333FAF92341000000A0DB345A4166666666F6F9234100000020DB345A4100000000F2F92341333333F3DA345A4166666666ECF9234100000000DB345A4133333333E8F9234166666646DB345A41CDCCCCCCE4F923419A9999B9DB345A419A999999E3F92341CDCCCC2CDC345A4100000000E3F923419A9999D9DC345A41	01060000206A080000010000000103000000010000000F00000000000000E3F923419A9999D9DC345A41CDCCCCCC85FA23419A9999F9E7345A4100000000A6FB2341CDCCCC2CFE345A4133333333E5FC234100000000F2345A4100000000D4FC23419A999999E5345A419A9999997DFC23419A9999B9B5345A41CDCCCCCC7BFC2341333333D3B0345A416666666648FC23419A999999B2345A41CDCCCCCC20FC234166666606A4345A4100000000AEFB234133333373AB345A41CDCCCCCC45FB23419A9999F9B5345A410000000066FA2341666666C6CE345A4133333333FAF92341000000A0DB345A4100000000E3F923419A9999D9DC345A4100000000E3F923419A9999D9DC345A41	01010000206A08000026E9273483FB23419A999919D0345A41	930270119	H	Moulin Neuf	9302701	93027	93	11	0
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	01060000206A08000001000000010300000001000000100000009A999999FD1C24419A99997983335A419A999999BC1E2441666666A6AB335A41CDCCCCCC3F20244100000000CE335A41000000001521244166666666B6335A4166666666FC202441333333D3AF335A4133333333562224419A9999F991335A41CDCCCCCC542324419A9999197B335A41000000001A2424413333331368335A419A999999632424419A9999B961335A413333333366232441CDCCCC8C2A335A419A9999990F2324410000006031335A419A999999C9212441666666C648335A410000000048212441666666E64B335A419A999999801F2441333333735D335A419A999999FD1C24419A99997983335A419A999999FD1C24419A99997983335A41	01010000206A0800007BB36842642024419A9999F97B335A41	930290502	H	La Mare 2	9302905	93029	93	11	0
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	01060000206A080000010000000103000000010000003200000066666666331D2441333333D36B355A4133333333F21D2441000000A06B355A4133333333981E2441000000006C355A4166666666081F2441CDCCCCAC82355A419A999999EA1E2441000000008B355A4166666666571F2441666666E68C355A41CDCCCCCC871F24419A9999F98E355A413333333328202441666666269B355A41666666668D2024419A9999F9A1355A4166666666F8202441000000C0A5355A41333333331622244100000000AB355A41666666668422244166666646AE355A4100000000FC2224419A999999B0355A413333333373232441666666C6AF355A41666666668C23244100000020B4355A41CDCCCCCCE52424419A9999D9F6355A41000000002125244100000000F0355A4100000000BF252441000000E0D1355A4166666666C5252441CDCCCC6CCF355A41333333336B2624419A9999F9C0355A41333333336E262441CDCCCCECBA355A41333333338C2624419A999919B7355A41000000004F2624419A999999AE355A41666666665526244100000000AB355A41CDCCCCCC33262441666666C699355A41333333337E2624419A99991996355A419A999999B52624419A9999F990355A41333333331A2724413333333384355A419A999999BB262441333333536F355A4100000000AB262441333333336E355A419A99999915252441CDCCCC4C70355A419A99999904252441CDCCCC8C41355A41333333339B2424416666666637355A41CDCCCCCC23242441CDCCCC2C31355A41000000005E2324419A9999B928355A419A999999142324416666664627355A41CDCCCCCCD32224416666666627355A419A9999995C2224413333339323355A419A999999BC2124419A9999191B355A4166666666E6202441CDCCCCEC10355A4166666666B92024416666662610355A419A9999998E2024416666662612355A41333333339D1F24413333333320355A419A9999995D1F2441CDCCCC2C22355A41CDCCCCCCAB1E24419A9999D924355A4166666666951D2441333333D324355A4133333333471D2441333333F322355A419A999999481D24419A99995969355A4166666666331D2441333333D36B355A4166666666331D2441333333D36B355A41	01010000206A08000046976A280E2324416666668683355A41	930290101	H	Économie 1	9302901	93029	93	11	1
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	01060000206A08000001000000010300000001000000260000009A999999AE1D24419A9999D9EB355A419A999999E91D244133333333EE355A4133333333701E2441CDCCCCCCF1355A419A999999C21E244166666646F9355A4166666666751F24413333331308365A419A999999AA1F24419A9999990A365A4166666666E31F2441666666460F365A41CDCCCCCC192024413333335319365A419A9999991F202441CDCCCC4C1C365A41333333339F202441000000E027365A41CDCCCCCCE7202441000000602B365A41666666662D212441CDCCCC8C2B365A41CDCCCCCCCE2124416666668628365A419A999999172224416666662626365A41000000003B2224410000004022365A41666666669E2224419A9999D91E365A413333333300232441666666A61D365A410000000046232441333333131F365A419A99999980232441000000C01A365A4166666666FA232441333333D30D365A419A999999322424419A999979FF355A41CDCCCCCCCC242441CDCCCCECF6355A41CDCCCCCCE52424419A9999D9F6355A41666666668C23244100000020B4355A413333333373232441666666C6AF355A4100000000FC2224419A999999B0355A41666666668422244166666646AE355A41333333331622244100000000AB355A4166666666F8202441000000C0A5355A41666666668D2024419A9999F9A1355A413333333328202441666666269B355A41CDCCCCCC871F24419A9999F98E355A4166666666571F2441666666E68C355A419A999999EA1E2441000000008B355A419A9999997A1E2441666666E6AE355A4133333333B11D244100000020EA355A419A999999AE1D24419A9999D9EB355A419A999999AE1D24419A9999D9EB355A41	01010000206A080000454545451D212441CDCCCCECDA355A41	930290102	H	Économie 2	9302901	93029	93	11	0
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	01060000206A0800000100000001030000000100000029000000CDCCCCCCC81E2441CDCCCC6C0C355A41666666662D1F2441333333F322355A41333333339D1F24413333333320355A419A9999998E2024416666662612355A4166666666B92024416666662610355A4166666666E6202441CDCCCCEC10355A419A999999BC2124419A9999191B355A419A9999995C2224413333339323355A41CDCCCCCCD32224416666666627355A419A999999142324416666664627355A41000000005E2324419A9999B928355A41CDCCCCCC23242441CDCCCC2C31355A41333333339B2424416666666637355A419A99999904252441CDCCCC8C41355A419A99999915252441CDCCCC4C70355A4100000000AB262441333333336E355A419A999999BB262441333333536F355A41333333331A2724413333333384355A4100000000682724416666662679355A41CDCCCCCC63282441CDCCCC2C6A355A41666666664A292441000000E049355A4100000000DE292441333333F333355A4133333333192924419A9999F9EF345A41CDCCCCCC5328244166666686F5345A41666666662F272441333333F3E2345A41CDCCCCCC99262441CDCCCC8C07355A4100000000B7252441000000C0F8345A41666666664B252441666666E6E8345A4133333333D224244100000020F5345A419A999999802424419A999979EA345A416666666670232441666666C6C4345A416666666696222441CDCCCC2CD2345A4100000000BA222441CDCCCC6CD7345A4166666666FF22244166666646E8345A4133333333F721244100000080F3345A41333333333F21244133333373F6345A41CDCCCCCC14202441000000A0FA345A4166666666DD1F2441333333B3FA345A4100000000801F24416666662600355A41CDCCCCCCC81E2441CDCCCC6C0C355A41CDCCCCCCC81E2441CDCCCC6C0C355A41	01010000206A080000B047C63A112624416666666624355A41	930290201	H	Les Oiseaux 1	9302902	93029	93	11	0
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	01060000206A080000010000000103000000010000001D00000000000000AE1E244166666646BD345A4100000000EF1E244133333353CB345A4166666666DD1F2441333333B3FA345A41CDCCCCCC14202441000000A0FA345A41333333333F21244133333373F6345A4133333333F721244100000080F3345A4166666666FF22244166666646E8345A4100000000BA222441CDCCCC6CD7345A416666666696222441CDCCCC2CD2345A416666666670232441666666C6C4345A419A999999802424419A999979EA345A4133333333D224244100000020F5345A41666666664B252441666666E6E8345A4100000000B7252441000000C0F8345A419A999999032624419A999979E6345A41CDCCCCCC54252441CDCCCC6CC8345A4100000000A1242441666666E6A8345A419A999999A52424419A999959A5345A416666666689242441333333D3A4345A41CDCCCCCC852324410000002077345A419A999999B1232441666666C670345A419A999999E7222441CDCCCC2C59345A4133333333FB212441666666E669345A416666666688202441333333D38E345A4133333333562024419A9999F999345A416666666628202441333333B39F345A419A999999DC1E24419A999939B8345A4100000000AE1E244166666646BD345A4100000000AE1E244166666646BD345A41	01010000206A080000D6F407921822244134333333AC345A41	930290202	H	Les Oiseaux 2	9302902	93029	93	11	0
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	01060000206A08000001000000010300000001000000230000009A999999E7222441CDCCCC2C59345A419A999999B1232441666666C670345A41CDCCCCCC852324410000002077345A416666666689242441333333D3A4345A419A999999A52424419A999959A5345A4100000000A1242441666666E6A8345A41CDCCCCCC54252441CDCCCC6CC8345A419A999999032624419A999979E6345A4100000000B7252441000000C0F8345A41CDCCCCCC99262441CDCCCC8C07355A41666666662F272441333333F3E2345A41CDCCCCCC5328244166666686F5345A4133333333192924419A9999F9EF345A4133333333E1282441000000A0E2345A41000000005B292441333333B3CD345A4133333333D3282441666666A6B7345A4100000000B22824419A999999B0345A4133333333B7282441000000A0AB345A4133333333E82824419A9999B99D345A41333333331E2924419A9999B992345A419A9999991C292441666666C68F345A41CDCCCCCCF5282441CDCCCC8C87345A4166666666D8282441CDCCCC4C7C345A419A9999992D2924419A99991977345A41CDCCCCCCA52824419A9999F96F345A41CDCCCCCCD8272441666666866A345A413333333337272441CDCCCC0C67345A41CDCCCCCC0E272441CDCCCC2C65345A41CDCCCCCCAA252441000000204D345A4166666666772524413333337348345A416666666600252441CDCCCC2C3B345A4133333333AA242441CDCCCC0C33345A41CDCCCCCC36242441CDCCCC4C41345A419A999999E7222441CDCCCC2C59345A419A999999E7222441CDCCCC2C59345A41	01010000206A08000068D80182A3262441343333A399345A41	930290203	H	Les Oiseaux 3	9302902	93029	93	11	0
01060000206A080000010000000103000000010000002E0000009A99999955242441666666862B345A4133333333AA242441CDCCCC0C33345A416666666600252441CDCCCC2C3B345A41333333334D252441666666E643345A4166666666772524413333337348345A41CDCCCCCCAA252441000000204D345A4100000000E3252441000000E050345A41CDCCCCCC012624416666662653345A41000000008E262441000000805C345A4100000000FE262441CDCCCC0C64345A41CDCCCCCC0E272441CDCCCC2C65345A413333333337272441CDCCCC0C67345A41CDCCCCCCD8272441666666866A345A41CDCCCCCCA52824419A9999F96F345A4166666666BA282441666666A670345A4133333333D8282441CDCCCCEC71345A4166666666E5282441333333B372345A4133333333F4282441CDCCCC8C73345A41CDCCCCCCFC2824416666662669345A419A999999FD2824410000002068345A4100000000FD2824410000000068345A419A999999F0282441666666E664345A4133333333ED2824410000000064345A4133333333EA282441CDCCCC4C63345A4133333333E0282441000000C05F345A4166666666DB282441CDCCCC0C5E345A4100000000B2282441333333F350345A4166666666BD2824413333337344345A41CDCCCCCCBC282441000000E02F345A4100000000AF2824419A9999592E345A419A999999C1282441CDCCCC4C2D345A419A999999D02824419A9999592C345A4133333333DE2824419A9999392B345A4166666666B62824416666660622345A4133333333792824416666660614345A4166666666152824419A9999D9FC335A4100000000ED27244166666606F4335A4133333333C227244133333353F6335A41666666667227244166666666FC335A419A999999FA262441000000E004345A419A999999F72624410000002005345A4166666666A1262441CDCCCC4C0B345A4166666666002624419A9999D916345A4133333333D8252441CDCCCCEC18345A41CDCCCCCCB1252441CDCCCC8C1A345A419A99999955242441666666862B345A41	01060000206A08000001000000010300000001000000150000009A99999955242441666666862B345A416666666600252441CDCCCC2C3B345A4166666666772524413333337348345A41CDCCCCCCAA252441000000204D345A41CDCCCCCC0E272441CDCCCC2C65345A413333333337272441CDCCCC0C67345A41CDCCCCCCD8272441666666866A345A41CDCCCCCCA52824419A9999F96F345A4133333333F4282441CDCCCC8C73345A419A999999FD2824410000002068345A4100000000B2282441333333F350345A4166666666BD2824413333337344345A41CDCCCCCCBC282441000000E02F345A4100000000AF2824419A9999592E345A4133333333DE2824419A9999392B345A4166666666152824419A9999D9FC335A4100000000ED27244166666606F4335A41666666667227244166666666FC335A4166666666002624419A9999D916345A419A99999955242441666666862B345A419A99999955242441666666862B345A41	01010000206A08000025B8D027C9262441CDCCCC1C37345A41	930290301	H	La Muette 1	9302903	93029	93	11	0
01060000206A080000010000000103000000010000002700000033333333A82224413333333305345A419A9999992D232441CDCCCC0C11345A4133333333892324410000002019345A4166666666AE232441666666661C345A4133333333E4232441CDCCCC4C21345A419A99999955242441666666862B345A41CDCCCCCCB1252441CDCCCC8C1A345A4133333333D8252441CDCCCCEC18345A4166666666002624419A9999D916345A4166666666A1262441CDCCCC4C0B345A419A999999F72624410000002005345A419A999999FA262441000000E004345A41666666667227244166666666FC335A4133333333C227244133333353F6335A4100000000ED27244166666606F4335A419A999999DE27244166666646F1335A41666666666C2724419A9999B9DA335A413333333336272441333333D3CF335A4100000000F326244100000080C2335A410000000077262441000000E0A9335A41666666666B2624419A9999D9A6335A4166666666AA2524419A999919BA335A410000000010252441CDCCCCCCC9335A4100000000F02424419A999919CD335A41666666668E242441333333D3D6335A41000000008124244133333333D8335A41333333332D242441333333D3E0335A41000000001224244100000080E3335A4100000000022424419A999919E5335A4133333333C02324419A999999EB335A4166666666AF23244133333333ED335A41CDCCCCCCA123244100000080EE335A410000000086232441CDCCCC2CF1335A41000000005D232441666666E6F4335A4133333333492324419A9999B9F6335A4166666666412324419A999979F7335A41CDCCCCCC14232441CDCCCC6CFB335A41CDCCCCCC11232441333333B3FB335A4133333333A82224413333333305345A41	01060000206A080000010000000103000000010000000C00000033333333A82224413333333305345A419A99999955242441666666862B345A4166666666002624419A9999D916345A41666666667227244166666666FC335A4100000000ED27244166666606F4335A410000000077262441000000E0A9335A41666666666B2624419A9999D9A6335A4166666666AA2524419A999919BA335A41333333332D242441333333D3E0335A4166666666412324419A999979F7335A4133333333A82224413333333305345A4133333333A82224413333333305345A41	01010000206A08000004542440C92524419A999959E8335A41	930290302	H	La Muette 2	9302903	93029	93	11	0
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	01060000206A08000001000000010300000001000000250000009A999999B62A24419A9999D9D7335A4133333333D42A24419A999979DE335A419A9999995A2B24419A999999F4335A4166666666492B24419A9999F9F8335A4100000000632B24416666664601345A41666666667E2C244100000060F3335A41CDCCCCCC3A2C24419A999999EB335A419A999999942C2441CDCCCCACE8335A4166666666B72D2441333333D305345A4100000000662E2441CDCCCC6C16345A41CDCCCCCC9B2E2441666666A60D345A419A9999995C2F24419A99995907345A41333333338A2F2441CDCCCC2CFF335A4100000000A72F2441CDCCCCCCEA335A41CDCCCCCCCF2F244133333353D8335A41000000006C3024419A999979C1335A419A9999998D302441333333F3BA335A41000000007130244100000000B7335A410000000066302441CDCCCCCCB1335A41CDCCCCCC6D302441CDCCCC4CA3335A4100000000902F24419A999979A5335A41CDCCCCCCB42E24410000006099335A41CDCCCCCCFA2D24410000004089335A419A999999B12D24419A99997991335A4100000000432D24419A99993984335A41CDCCCCCC032D24419A9999997D335A4100000000AE2C2441000000A072335A41333333338C2C24419A9999B976335A41CDCCCCCC612C24413333333375335A419A999999EF2B2441333333D379335A4166666666CF2B2441666666267F335A4133333333592B2441CDCCCC6C8A335A4100000000382B2441333333B38B335A4133333333E22A24416666660695335A4100000000EB2B2441666666E6C3335A419A999999B62A24419A9999D9D7335A419A999999B62A24419A9999D9D7335A41	01010000206A0800004C2A05EF0C2E2441CCCCCCECC5335A41	930290401	H	Village Parisien 1	9302904	93029	93	11	0
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	01060000206A080000010000000103000000010000001C000000CDCCCCCCA8262441000000A0A0335A4166666666CE262441CDCCCC2CA8335A416666666673272441333333539E335A41CDCCCCCC3C282441CDCCCC0CC9335A416666666652292441000000E0B4335A419A9999996B2A24419A9999399E335A41CDCCCCCC6B2B244166666646CC335A4100000000EB2B2441666666E6C3335A4133333333E22A24416666660695335A4100000000382B2441333333B38B335A4133333333592B2441CDCCCC6C8A335A4166666666CF2B2441666666267F335A419A999999EF2B2441333333D379335A41CDCCCCCC612C24413333333375335A419A999999EE2B2441CDCCCC4C72335A419A999999B82B2441000000A06E335A419A9999998F2B2441000000E069335A4100000000B92B24410000008065335A41666666666B2B2441000000A061335A41CDCCCCCCE72A24410000004053335A41CDCCCCCCB12A2441000000204A335A419A9999995E2A24419A9999F945335A41CDCCCCCCD42924413333339333335A4133333333A52824416666666660335A41CDCCCCCCC12724416666666681335A410000000060272441000000208E335A41CDCCCCCCA8262441000000A0A0335A41CDCCCCCCA8262441000000A0A0335A41	01010000206A0800007B7DBB83C62924416666664680335A41	930290402	H	Village Parisien 2	9302904	93029	93	11	0
01060000206A0800000100000001030000000100000030000000666666666B2624419A9999D9A6335A410000000077262441000000E0A9335A4100000000F326244100000080C2335A413333333336272441333333D3CF335A41666666666C2724419A9999B9DA335A419A999999DE27244166666646F1335A4100000000ED27244166666606F4335A4166666666152824419A9999D9FC335A4133333333792824416666660614345A4166666666B62824416666660622345A4133333333FC2924410000006012345A41CDCCCCCCA42A2441CDCCCC6C0A345A4133333333252B24410000004004345A4100000000632B24416666664601345A41CDCCCCCC592B2441CDCCCCEC00345A4166666666492B24419A9999F9F8335A4100000000602B2441000000A0F7335A419A9999995A2B24419A999999F4335A41666666664D2B244166666626F2335A41333333334C2B2441CDCCCC2CF2335A419A999999442B2441CDCCCC8CF1335A41666666663A2B244166666606F0335A4133333333382B2441CDCCCCACEF335A41CDCCCCCC1C2B2441000000C0EA335A419A999999FF2A24419A999979E5335A4133333333D42A24419A999979DE335A419A999999B62A24419A9999D9D7335A41666666660E2B244133333333D2335A41000000001D2B244166666666D1335A419A9999993B2B2441CDCCCC6CCF335A41CDCCCCCC6B2B244166666646CC335A419A999999272B244166666666C0335A419A999999962A2441CDCCCC4CA6335A419A9999996B2A24419A9999399E335A4166666666F429244100000000A8335A41CDCCCCCCE129244166666686A9335A416666666652292441000000E0B4335A41CDCCCCCC3C282441CDCCCC0CC9335A4100000000F627244100000000BA335A4133333333B1272441CDCCCC6CAB335A416666666673272441333333539E335A4100000000F126244100000020A6335A4166666666CE262441CDCCCC2CA8335A4133333333C82624419A9999F9A7335A4133333333B42624419A999979A3335A41CDCCCCCCA8262441000000A0A0335A41666666667E262441666666A6A4335A41666666666B2624419A9999D9A6335A41	01060000206A0800000100000001030000000100000012000000666666666B2624419A9999D9A6335A410000000077262441000000E0A9335A4100000000ED27244166666606F4335A4166666666B62824416666660622345A4100000000632B24416666664601345A4166666666492B24419A9999F9F8335A419A9999995A2B24419A999999F4335A4133333333D42A24419A999979DE335A419A999999B62A24419A9999D9D7335A41CDCCCCCC6B2B244166666646CC335A419A9999996B2A24419A9999399E335A416666666652292441000000E0B4335A41CDCCCCCC3C282441CDCCCC0CC9335A416666666673272441333333539E335A4166666666CE262441CDCCCC2CA8335A41CDCCCCCCA8262441000000A0A0335A41666666666B2624419A9999D9A6335A41666666666B2624419A9999D9A6335A41	01010000206A080000226412823D2924419A9999F9E1335A41	930290403	H	Village Parisien 3	9302904	93029	93	11	0
01060000206A08000001000000010300000001000000580000003333333366232441CDCCCC8C2A335A419A999999632424419A9999B961335A410000000029242441000000C066335A41000000001A2424413333331368335A410000000043242441666666866F335A41666666667A242441000000E069335A419A999999D12424410000000077335A419A999999FF252441333333535D335A41333333335C262441666666866C335A41000000008F252441666666867F335A4100000000DE252441CDCCCCAC8B335A41333333331F262441CDCCCC6C96335A4133333333BC25244100000020A0335A4100000000612524419A9999B9A9335A419A9999990E2524419A9999D9B1335A413333333392242441CDCCCC8CBE335A4100000000F02424419A999919CD335A410000000010252441CDCCCCCCC9335A4166666666AA2524419A999919BA335A41666666666B2624419A9999D9A6335A41666666667E262441666666A6A4335A41CDCCCCCCA8262441000000A0A0335A4100000000E3262441333333939A335A4100000000E3262441333333739A335A4133333333F02624416666660699335A419A99999924272441666666E693335A419A9999992C2724416666662693335A41CDCCCCCC47272441CDCCCC4C90335A410000000060272441000000208E335A413333333372272441333333338C335A41CDCCCCCC85272441000000C089335A41CDCCCCCCC12724416666666681335A41CDCCCCCCFF2724410000004078335A413333333316282441333333F374335A410000000035282441CDCCCC6C70335A41CDCCCCCC51282441666666466C335A4133333333A52824416666666660335A416666666625292441CDCCCC4C4D335A410000000027292441333333134D335A419A99999940292441CDCCCC4C49335A4166666666C7292441333333B335335A41CDCCCCCCD42924413333339333335A4100000000A52924419A9999392D335A419A9999999F292441666666862C335A419A9999999E292441666666662C335A41CDCCCCCC58292441CDCCCCEC28335A410000000051292441CDCCCC8C28335A41666666664D2924419A99995928335A41CDCCCCCC382924416666666627335A41CDCCCCCCFC282441333333F325335A4133333333BF2824416666662625335A419A999999962824416666662625335A41CDCCCCCC922824410000002025335A41333333337F2824410000002025335A4133333333702824413333331326335A416666666665282441CDCCCC0C26335A41CDCCCCCC5E2824410000000026335A4166666666512824419A9999D925335A4133333333502824419A9999D925335A419A999999452824419A99997925335A419A999999422824419A99995925335A419A99999903282441CDCCCC8C22335A4166666666F5272441666666E621335A4166666666ED2724410000008021335A419A999999E62724413333333321335A4166666666E72624419A99993915335A419A999999D62624413333335315335A4133333333C0262441CDCCCCAC15335A41CDCCCCCCB1262441CDCCCC0C16335A4100000000AA2624419A9999F913335A419A999999A12624413333335312335A413333333387262441666666260D335A41666666664D262441666666E601335A4166666666AA252441000000000B335A419A9999997D252441666666860D335A413333333334252441CDCCCCCCFE325A4100000000FD242441000000A001335A4166666666F6242441333333B302335A4133333333C6242441CDCCCC2C08335A41CDCCCCCCAF242441666666660A335A413333333374242441CDCCCC0C11335A41CDCCCCCC51242441666666E614335A419A9999994D2424419A99995915335A410000000028242441CDCCCC8C19335A4100000000E0232441CDCCCC4C20335A4100000000C3232441000000C022335A4166666666A42324419A99995925335A413333333366232441CDCCCC8C2A335A41	01060000206A080000010000000103000000010000001E0000003333333366232441CDCCCC8C2A335A419A999999632424419A9999B961335A41000000001A2424413333331368335A410000000043242441666666866F335A41666666667A242441000000E069335A419A999999D12424410000000077335A419A999999FF252441333333535D335A41333333335C262441666666866C335A41000000008F252441666666867F335A41333333331F262441CDCCCC6C96335A413333333392242441CDCCCC8CBE335A4100000000F02424419A999919CD335A4166666666AA2524419A999919BA335A410000000060272441000000208E335A41CDCCCCCCC12724416666666681335A4133333333A52824416666666660335A41CDCCCCCCD42924413333339333335A419A9999999E292441666666662C335A41CDCCCCCC382924416666666627335A4133333333BF2824416666662625335A4133333333502824419A9999D925335A4166666666E72624419A99993915335A41CDCCCCCCB1262441CDCCCC0C16335A41666666664D262441666666E601335A419A9999997D252441666666860D335A413333333334252441CDCCCCCCFE325A4166666666F6242441333333B302335A410000000028242441CDCCCC8C19335A413333333366232441CDCCCC8C2A335A413333333366232441CDCCCC8C2A335A41	01010000206A0800008669EBFA59272441CDCCCC3C64335A41	930290501	H	La Mare 1	9302905	93029	93	11	0
01060000206A0800000100000001030000000100000036000000CDCCCCCC3F20244100000000CE335A419A9999999F202441333333B3D6335A4100000000BC202441CDCCCC0CD9335A41CDCCCCCC102124419A9999B9E0335A410000000029212441333333D3E2335A410000000082212441666666C6EA335A419A999999B121244133333313EF335A41CDCCCCCCDC212441666666C6F2335A41666666662A222441CDCCCCCCF9335A4133333333A82224413333333305345A41CDCCCCCC11232441333333B3FB335A41CDCCCCCC14232441CDCCCC6CFB335A4166666666412324419A999979F7335A4133333333492324419A9999B9F6335A41000000005D232441666666E6F4335A410000000086232441CDCCCC2CF1335A41CDCCCCCCA123244100000080EE335A4166666666AF23244133333333ED335A4133333333C02324419A999999EB335A4100000000022424419A999919E5335A41000000001224244100000080E3335A41333333332D242441333333D3E0335A41000000008124244133333333D8335A41666666668E242441333333D3D6335A4100000000F02424419A999919CD335A413333333392242441CDCCCC8CBE335A419A9999990E2524419A9999D9B1335A4100000000612524419A9999B9A9335A4133333333BC25244100000020A0335A41333333331F262441CDCCCC6C96335A4100000000DE252441CDCCCCAC8B335A41000000008F252441666666867F335A41333333335C262441666666866C335A419A999999FF252441333333535D335A419A999999D12424410000000077335A41666666667A242441000000E069335A410000000043242441666666866F335A41000000001A2424413333331368335A41CDCCCCCC542324419A9999197B335A413333333301232441333333B382335A4133333333562224419A9999F991335A413333333329222441000000E095335A41666666661D222441666666E696335A4100000000162224416666668697335A4166666666D6212441CDCCCCEC9C335A41CDCCCCCCC1212441CDCCCCAC9E335A41666666669921244133333313A2335A4166666666FC202441333333D3AF335A41000000001521244100000000B4335A413333333319212441CDCCCC8CB5335A419A99999918212441666666A6B5335A41000000001521244166666666B6335A419A9999997A202441666666C6C7335A41CDCCCCCC3F20244100000000CE335A41	01060000206A0800000100000001030000000100000013000000CDCCCCCC3F20244100000000CE335A4133333333A82224413333333305345A4133333333C02324419A999999EB335A4100000000F02424419A999919CD335A413333333392242441CDCCCC8CBE335A41333333331F262441CDCCCC6C96335A41000000008F252441666666867F335A41333333335C262441666666866C335A419A999999FF252441333333535D335A419A999999D12424410000000077335A41666666667A242441000000E069335A410000000043242441666666866F335A41000000001A2424413333331368335A41CDCCCCCC542324419A9999197B335A4133333333562224419A9999F991335A4166666666FC202441333333D3AF335A41000000001521244166666666B6335A41CDCCCCCC3F20244100000000CE335A41CDCCCCCC3F20244100000000CE335A41	01010000206A0800004F7AF99D0D232441666666D6B0335A41	930290503	H	La Mare 3	9302905	93029	93	11	0
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	01060000206A080000010000000103000000010000002100000066666666791C2441000000A0A8345A419A999999D81C24419A999999B6345A41CDCCCCCCE01C2441666666C6B9345A4133333333171D2441CDCCCC8CBE345A4133333333401D244133333333C0345A41CDCCCCCC6D1D2441CDCCCCECC8345A419A999999911D244100000000CD345A4166666666A91D24419A999979CA345A4100000000D51D2441CDCCCC0CD5345A41333333334F1E24419A999999CB345A419A999999B81E2441666666C6BB345A419A999999DC1E24419A999939B8345A416666666628202441333333B39F345A4133333333562024419A9999F999345A416666666688202441333333D38E345A4133333333FB212441666666E669345A419A999999E7222441CDCCCC2C59345A41CDCCCCCC1A2224416666662641345A41333333332D212441333333D32F345A4100000000F72024416666662639345A413333333399202441666666863C345A419A999999941F24413333335340345A419A9999996D1F24416666662640345A41CDCCCCCC7F1F24410000000052345A4166666666801F2441CDCCCCCC5A345A419A999999711F24413333333368345A41CDCCCCCC781F2441666666066B345A4133333333171F2441666666E672345A4133333333D31D2441CDCCCCEC85345A4100000000341D2441CDCCCC4C92345A419A999999F01C24419A99997999345A4166666666791C2441000000A0A8345A4166666666791C2441000000A0A8345A41	01010000206A080000D8598ACB751F2441CDCCCCDC83345A41	930290601	H	Drancy Centre 1	9302906	93029	93	11	0
01060000206A080000010000000103000000010000004600000033333333AD1B24419A99997964345A4133333333C41B24416666664667345A419A999999061C24419A99999970345A41000000002F1C24419A9999B975345A41000000006D1C2441000000A080345A41000000009F1C24419A9999998A345A419A999999F01C24419A99997999345A41CDCCCCCC131D2441000000E095345A419A999999201D2441CDCCCC4C94345A4100000000341D2441CDCCCC4C92345A4100000000471D24416666660691345A4133333333BB1D24419A9999F987345A4133333333D31D2441CDCCCCEC85345A419A9999996E1E2441333333B37C345A4100000000A91E24416666664679345A4166666666EC1E24416666668675345A4166666666F11E2441CDCCCC4C75345A4133333333171F2441666666E672345A41CDCCCCCC291F24416666668671345A419A999999491F2441CDCCCC2C6F345A4133333333601F24419A9999796D345A41000000006E1F2441333333536C345A41CDCCCCCC781F2441666666066B345A419A999999711F24413333333368345A419A999999721F24410000000066345A41CDCCCCCC7B1F2441CDCCCCEC60345A4166666666801F2441CDCCCCCC5A345A4133333333811F2441CDCCCC4C56345A4133333333811F24416666660656345A41CDCCCCCC7F1F24410000000052345A41CDCCCCCC7E1F24410000000051345A419A999999761F2441000000604B345A419A999999721F24419A9999B947345A419A9999996D1F24416666662640345A41333333332D1F2441333333B33D345A4166666666271F2441333333733D345A4100000000DC1E24419A9999193A345A419A999999B91E24419A99999938345A41CDCCCCCCA61E2441CDCCCC4C36345A4166666666A61E24419A9999F935345A419A999999A51E2441666666A635345A4166666666A41E24419A99995935345A419A999999A21E24419A99991935345A419A999999A01E2441000000E034345A41333333339E1E24419A9999B934345A419A9999999B1E2441000000A034345A4100000000991E24413333339334345A4166666666901E24419A99991931345A4133333333721E2441CDCCCCAC29345A41666666664C1E2441000000A020345A41CDCCCCCC171E24410000004013345A41333333330D1E24416666668610345A419A999999031E24419A9999F90C345A4100000000001E2441CDCCCCAC0B345A419A999999FA1D24413333339308345A4100000000E81D244166666606FE335A41333333333A1C2441CDCCCCEC1B345A419A999999591C2441CDCCCC0C1F345A419A999999621C24416666668620345A419A999999661C2441CDCCCC6C21345A4133333333891C24419A9999392A345A419A999999491C24419A9999B92E345A41CDCCCCCCBF1B24413333337339345A419A999999C91B2441666666863B345A41333333334D1C2441333333B352345A419A999999101C24413333331358345A419A999999F91B2441333333B35A345A4166666666E11B2441000000C05D345A4133333333C91B2441000000E060345A4133333333AD1B24419A99997964345A41	01060000206A080000010000000103000000010000001800000033333333AD1B24419A99997964345A41000000002F1C24419A9999B975345A41000000006D1C2441000000A080345A419A999999F01C24419A99997999345A4100000000341D2441CDCCCC4C92345A4133333333D31D2441CDCCCCEC85345A4133333333171F2441666666E672345A41CDCCCCCC781F2441666666066B345A419A999999711F24413333333368345A4166666666801F2441CDCCCCCC5A345A41CDCCCCCC7F1F24410000000052345A419A9999996D1F24416666662640345A419A999999B91E24419A99999938345A4166666666901E24419A99991931345A41333333330D1E24416666668610345A4100000000E81D244166666606FE335A41333333333A1C2441CDCCCCEC1B345A419A999999591C2441CDCCCC0C1F345A4133333333891C24419A9999392A345A41CDCCCCCCBF1B24413333337339345A41333333334D1C2441333333B352345A419A999999101C24413333331358345A4133333333AD1B24419A99997964345A4133333333AD1B24419A99997964345A41	01010000206A0800007E864723D71D2441000000304E345A41	930290602	H	Drancy Centre 2	9302906	93029	93	11	0
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	01060000206A080000010000000103000000010000001300000000000000D61D2441666666A6F0335A4100000000001E2441CDCCCCAC0B345A41333333330D1E24416666668610345A4166666666901E24419A99991931345A419A999999B91E24419A99999938345A419A9999996D1F24416666662640345A419A999999941F24413333335340345A413333333399202441666666863C345A4100000000F72024416666662639345A41333333332D212441333333D32F345A41CDCCCCCC1A2224416666662641345A419A999999E7222441CDCCCC2C59345A41CDCCCCCC36242441CDCCCC4C41345A4133333333AA242441CDCCCC0C33345A4133333333BF1F2441CDCCCC8CC2335A419A999999BC1E2441666666A6AB335A41CDCCCCCC601E244166666646C5335A4100000000D61D2441666666A6F0335A4100000000D61D2441666666A6F0335A41	01010000206A080000A45FDF7737202441CCCCCC9C01345A41	930290603	H	Drancy Centre 3	9302906	93029	93	11	0
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	01060000206A080000010000000103000000010000001B0000009A99999980182441000000604E345A4133333333751924413333339379345A4166666666611A24413333331396345A41CDCCCCCC2F1B2441CDCCCC8CB3345A41CDCCCCCC9B1B2441333333B3C3345A4166666666491C2441333333B3AE345A419A999999F01C24419A99997999345A41000000006D1C2441000000A080345A41000000002F1C24419A9999B975345A4133333333AD1B24419A99997964345A419A999999101C24413333331358345A41333333334D1C2441333333B352345A41CDCCCCCCBF1B24413333337339345A4133333333891C24419A9999392A345A419A999999591C2441CDCCCC0C1F345A41333333333A1C2441CDCCCCEC1B345A4100000000E81D244166666606FE335A4100000000D71D24419A999999F3335A4100000000801D244100000000D7335A4133333333631D2441666666A6D0335A41CDCCCCCCED1C244100000080DD335A4133333333731B2441666666C608345A419A999999891B2441000000000B345A4100000000551A24419A99995928345A41CDCCCCCCFD1924416666660630345A419A99999980182441000000604E345A419A99999980182441000000604E345A41	01010000206A0800006E0C4DB76A1A2441000000D049345A41	930290604	H	Drancy Centre 4	9302906	93029	93	11	0
01060000206A080000010000000103000000010000008E00000066666666371724419A9999F96F335A41333333333D1724416666662670335A4166666666441724410000008070335A416666666646172441CDCCCCAC70335A41000000004A1724419A9999F970335A419A9999994F1724410000006071335A410000000055172441CDCCCCEC71335A41666666665A1724416666668672335A41333333335B172441333333B372335A419A9999995B172441CDCCCCCC72335A41666666665E1724419A99995973335A413333333361172441CDCCCC0C74335A4166666666631724419A99999974335A416666666664172441000000E074335A416666666666172441CDCCCCAC75335A419A99999967172441CDCCCC6C76335A4166666666681724413333333377335A419A999999681724419A99991978335A4166666666671724416666660679335A419A99999965172441000000007A335A41CDCCCCCC62172441000000E07A335A413333333360172441CDCCCCAC7B335A41CDCCCCCC5C172441000000607C335A41000000005A172441333333D37C335A413333333363172441333333B37D335A41CDCCCCCC6E172441333333B37F335A41CDCCCCCC76172441666666C681335A41CDCCCCCC90172441CDCCCCAC8A335A4166666666CD172441CDCCCC8C8A335A4166666666D5172441CDCCCC8C8A335A41CDCCCCCC13182441666666C68A335A4100000000461824419A9999F98A335A41666666664F182441333333338B335A41CDCCCCCC551824419A9999B98B335A41CDCCCCCC58182441333333738C335A41CDCCCCCC59182441666666668D335A419A999999591824419A9999198E335A416666666666182441000000C08E335A4133333333751824416666662690335A41666666668D1824413333333393335A419A999999A71824416666668697335A41CDCCCCCCAF1824416666660699335A419A999999B9182441333333D39A335A4133333333CA1824419A9999599D335A4100000000D7182441000000009F335A4100000000EC18244133333373A0335A41CDCCCCCC02192441CDCCCCECA0335A41000000002319244133333373A2335A41CDCCCCCC37192441CDCCCC0CA4335A41333333334F1924419A9999D9A6335A410000000056192441666666A6A5335A413333333360192441333333D3A2335A41333333336A192441CDCCCC6C9F335A419A99999971192441333333939B335A41CDCCCCCC79192441CDCCCC6C96335A41000000007F1924413333335393335A419A99999984192441CDCCCC0C91335A41CDCCCCCC8D192441333333138E335A410000000091192441000000408D335A413333333396192441000000A08C335A41000000009E192441333333738C335A4133333333AE192441333333738C335A41CDCCCCCCF21924419A9999F98C335A419A999999F3192441000000A085335A41CDCCCCCCF3192441CDCCCC2C84335A4166666666F51924413333335374335A4133333333971A2441666666C671335A419A999999A81A2441CDCCCC8C71335A419A999999B71A24410000000072335A4100000000C11A24419A9999B972335A4166666666DA1A2441CDCCCCCC76335A419A9999997A1B2441666666868F335A419A999999CF1B2441666666869C335A41CDCCCCCCEB1B244133333333A1335A4166666666471C244133333313AF335A41CDCCCCCC621C24419A9999B9B3335A4100000000C11C244100000080B3335A4166666666CD1C2441CDCCCC4CB3335A4166666666D71C2441CDCCCCACB2335A4100000000DF1C244100000040B2335A4166666666ED1C244166666686AF335A4166666666541D2441333333F3A0335A41666666669E1D24416666664696335A41CDCCCCCCB21D24413333339393335A4166666666961D2441CDCCCC0C91335A419A999999631D2441666666868C335A41000000002D1D2441666666A687335A419A999999271D2441CDCCCC2C87335A4100000000001D2441CDCCCCAC83335A419A999999FD1C24419A99997983335A4166666666EA1C24419A99999984335A41CDCCCCCCE91C2441000000A084335A4100000000D71C2441333333B385335A4133333333D41C2441000000E085335A419A999999BC1C24410000004087335A4166666666AB1C24419A99999985335A419A999999AA1C24416666668685335A4100000000A11C24419A99999984335A41CDCCCCCC9D1C2441CDCCCC4C84335A41333333337F1C24413333335381335A41CDCCCCCC791C2441CDCCCCCC80335A41333333336A1C2441CDCCCC4C7F335A4166666666621C2441666666867E335A41CDCCCCCC611C24419A9999797E335A41000000005D1C2441000000007E335A41666666665C1C2441333333F37D335A419A999999521C2441000000007D335A41CDCCCCCC491C2441000000207C335A4166666666331C24419A9999F979335A41CDCCCCCC1B1C24419A9999B977335A4133333333081C2441CDCCCCCC75335A4133333333071C2441333333B375335A4166666666FF1B2441333333F374335A4166666666FE1B24419A9999D974335A4166666666EA1B2441CDCCCCEC72335A4133333333DB1B24413333337371335A41CDCCCCCCB91B2441333333336E335A41CDCCCCCCB31B2441000000A06D335A41CDCCCCCC1E1B2441333333335F335A41CDCCCCCC601A2441CDCCCCCC4C335A419A9999994E1A2441CDCCCC0C4B335A419A999999FA192441000000404F335A4166666666F41924419A9999994F335A4166666666DC192441CDCCCCCC50335A41000000003E192441333333F357335A416666666636192441CDCCCC4C58335A41CDCCCCCC2F1924419A99999958335A416666666616192441000000C059335A41CDCCCCCCE41824419A9999F95B335A41CDCCCCCCD4182441CDCCCCAC5C335A4100000000D41824419A9999B95C335A4133333333B3182441666666E65E335A4100000000AE182441CDCCCCEC5E335A419A999999A41824419A9999F95E335A410000000087182441CDCCCC2C5F335A419A999999751824419A9999795E335A419A9999996F1824419A9999395E335A4166666666501824419A9999F95C335A4133333333A4172441000000A068335A410000000079172441CDCCCC8C6B335A41000000003C172441CDCCCCAC6F335A4166666666371724419A9999F96F335A41	01060000206A080000010000000103000000010000001F00000066666666371724419A9999F96F335A41666666665A1724416666668672335A4166666666681724413333333377335A41000000005A172441333333D37C335A41CDCCCCCC76172441666666C681335A41CDCCCCCC90172441CDCCCCAC8A335A4100000000461824419A9999F98A335A41666666668D1824413333333393335A4100000000D7182441000000009F335A41000000002319244133333373A2335A41333333334F1924419A9999D9A6335A41333333336A192441CDCCCC6C9F335A410000000091192441000000408D335A41CDCCCCCCF21924419A9999F98C335A4166666666F51924413333335374335A419A999999A81A2441CDCCCC8C71335A4100000000C11A24419A9999B972335A4166666666471C244133333313AF335A41CDCCCCCC621C24419A9999B9B3335A4100000000C11C244100000080B3335A4166666666ED1C244166666686AF335A41CDCCCCCCB21D24413333339393335A419A999999FD1C24419A99997983335A419A999999BC1C24410000004087335A419A9999994E1A2441CDCCCC0C4B335A4166666666DC192441CDCCCCCC50335A41CDCCCCCCD4182441CDCCCCAC5C335A410000000087182441CDCCCC2C5F335A4166666666501824419A9999F95C335A4166666666371724419A9999F96F335A4166666666371724419A9999F96F335A41	01010000206A08000066EFB9F4B0182441000000807F335A41	930290701	H	Petit Drancy 1	9302907	93029	93	11	0
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	01060000206A0800000100000001030000000100000014000000CDCCCCCC90172441CDCCCCAC8A335A4100000000E3172441CDCCCC6CAC335A413333333316182441CDCCCC4CB6335A41CDCCCCCCB9182441333333B3C5335A41333333339A18244100000020CB335A41333333339C18244166666646D4335A419A999999C118244100000060D5335A419A99999938192441000000E0D1335A41CDCCCCCCD819244166666626E1335A41CDCCCCCCE6192441666666E6DF335A41CDCCCCCCF21924419A9999F98C335A410000000091192441000000408D335A41333333336A192441CDCCCC6C9F335A41333333334F1924419A9999D9A6335A41000000002319244133333373A2335A4100000000D7182441000000009F335A41666666668D1824413333333393335A4100000000461824419A9999F98A335A41CDCCCCCC90172441CDCCCCAC8A335A41CDCCCCCC90172441CDCCCCAC8A335A41	01010000206A080000D59266FB00192441CDCCCC8CB5335A41	930290702	H	Petit Drancy 2	9302907	93029	93	11	0
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	01060000206A080000010000000103000000010000001F000000333333332F182441333333933F345A419A99999980182441000000604E345A41CDCCCCCCFD1924416666660630345A4100000000551A24419A99995928345A419A999999891B2441000000000B345A4133333333731B2441666666C608345A41CDCCCCCCED1C244100000080DD335A4133333333631D2441666666A6D0335A4100000000801D244100000000D7335A4100000000D71D24419A999999F3335A4133333333DC1D244100000040ED335A41666666660C1E2441000000C0DF335A41CDCCCCCC601E244166666646C5335A419A999999BC1E2441666666A6AB335A41CDCCCCCCB21D24413333339393335A4166666666ED1C244166666686AF335A4100000000C11C244100000080B3335A41CDCCCCCC621C24419A9999B9B3335A4166666666471C244133333313AF335A4100000000C11A24419A9999B972335A419A999999A81A2441CDCCCC8C71335A4166666666F51924413333335374335A419A999999EE19244133333333B2335A41CDCCCCCCE6192441666666E6DF335A41CDCCCCCCD819244166666626E1335A419A99999938192441000000E0D1335A41333333336F19244133333393FE335A41CDCCCCCC841924416666664614345A419A999999991924410000006022345A41333333332F182441333333933F345A41333333332F182441333333933F345A41	01010000206A0800006475C4F55B1B24419A999909E0335A41	930290703	H	Petit Drancy 3	9302907	93029	93	11	0
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	01060000206A08000001000000010300000001000000260000003333333329152441000000A056345A4166666666F2152441CDCCCC8C4F345A41CDCCCCCC0B162441CDCCCC2C51345A41CDCCCCCC801624419A9999D964345A4133333333001824410000000043345A41333333332F182441333333933F345A419A999999991924410000006022345A41CDCCCCCC841924416666664614345A41333333336F19244133333393FE335A419A99999938192441000000E0D1335A419A999999C118244100000060D5335A41333333339C18244166666646D4335A41333333339A18244100000020CB335A41CDCCCCCCB9182441333333B3C5335A413333333316182441CDCCCC4CB6335A4100000000E3172441CDCCCC6CAC335A41CDCCCCCC90172441CDCCCCAC8A335A41CDCCCCCC76172441666666C681335A41000000005A172441333333D37C335A4166666666681724413333333377335A41666666665A1724416666668672335A4166666666371724419A9999F96F335A416666666677162441000000207D335A41000000001D1624416666668681335A41CDCCCCCCE31524419A99995991335A4100000000D8152441000000C099335A4133333333DD152441666666A6A5335A4100000000FC15244100000060AD335A41CDCCCCCC0216244133333313B5335A41CDCCCCCC30162441000000E0B5335A4166666666341624419A999939C0335A4133333333EA1524419A999979E9335A41CDCCCCCCC015244166666646FC335A4100000000AC1524413333337308345A413333333352152441333333B328345A4133333333441524419A9999D93B345A413333333329152441000000A056345A413333333329152441000000A056345A41	01010000206A080000A849B9039E172441CDCCCCDCEB335A41	930290704	H	Petit Drancy 4	9302907	93029	93	11	0
01060000206A080000010000000103000000010000005A00000066666666D60E244166666626DB335A4166666666E60E244166666686DD335A41333333332E0F244133333333EA335A4166666666680F244166666646F4335A4166666666780F244133333313F7335A4133333333880F2441333333B3F9335A4166666666A10F2441CDCCCCCCFD335A4166666666A90F2441CDCCCC4CFD335A4166666666AD0F2441333333D3FC335A4166666666BB0F244133333333FB335A41CDCCCCCCCB0F244166666646F9335A419A999999CE0F2441000000C0F8335A41CDCCCCCC1E10244100000080E8335A416666666635102441CDCCCCACEC335A410000000043102441CDCCCC2CEF335A41333333336F1024419A9999F9F7335A41666666667210244100000060F9335A416666666679102441CDCCCC8CFA335A4100000000B21024416666668604345A4100000000CC1024419A99991909345A4133333333B3102441CDCCCCEC09345A419A99999973102441CDCCCC0C0C345A416666666663102441000000E00C345A41666666664E1024419A9999B90F345A416666666645102441CDCCCCEC10345A41CDCCCCCC451024419A99997918345A410000000046102441CDCCCC0C1F345A4100000000461024419A9999392B345A4133333333461024410000008032345A41CDCCCCCC60102441CDCCCC6C34345A419A9999997F1024410000002037345A41CDCCCCCC9A102441CDCCCC4C39345A4166666666B5102441CDCCCC6C3B345A4100000000C5102441333333133D345A4166666666E91024416666660640345A41CDCCCCCC011124410000000042345A41CDCCCCCC301124413333337346345A41333333333C112441333333B347345A413333333376112441CDCCCC0C4E345A419A9999998B112441333333D350345A419A999999A0112441000000A052345A4100000000A61124419A99991953345A4100000000C1112441CDCCCCAC54345A4133333333DD1124413333331356345A4133333333F7112441CDCCCC8C55345A416666666623122441CDCCCCAC54345A419A9999994F1224416666664654345A416666666678122441666666C653345A410000000088122441CDCCCC4C58345A419A999999B0122441666666E660345A4166666666D2122441CDCCCCAC5E345A4100000000E41224419A9999795D345A4166666666E7122441000000A05E345A4166666666271324419A9999995B345A419A9999996D1324410000008056345A41CDCCCCCC84132441333333B354345A41CDCCCCCC981324416666664653345A4166666666A9132441CDCCCC8C52345A41CDCCCCCCB71324413333335352345A41CDCCCCCCCC1324416666662652345A4133333333D81324410000002052345A41CDCCCCCCD91324410000002052345A4100000000E8132441666666E63D345A4100000000FA132441CDCCCC0C2E345A41CDCCCCCC0F142441666666A620345A41CDCCCCCC24142441CDCCCC4C16345A4166666666261424419A99999915345A419A999999DA132441CDCCCC4C04345A4133333333BB1324410000004005345A41000000005612244166666666AC335A41333333334E1224419A999979A9335A41CDCCCCCC4A122441000000A0A9335A41CDCCCCCC1E122441333333B3AB335A4100000000C61124419A999979AF335A416666666689112441CDCCCC2CB1335A410000000081112441CDCCCCACB1335A419A9999993911244133333313B5335A4166666666D21024419A9999F9B9335A413333333385102441CDCCCCCCBD335A41333333333A102441666666E6C1335A410000000008102441666666E6C4335A419A999999FC0F244133333393C5335A419A999999960F24419A999939CC335A41333333338A0F24419A999919CD335A41333333335E0F2441CDCCCC2CD0335A41CDCCCCCC610F244166666606D1335A419A999999680F244100000040D2335A4100000000670F24419A999959D2335A419A999999470F24419A999939D4335A4166666666D60E244166666626DB335A41	01060000206A080000010000000103000000010000002100000066666666D60E244166666626DB335A4166666666A10F2441CDCCCCCCFD335A41CDCCCCCCCB0F244166666646F9335A41CDCCCCCC1E10244100000080E8335A41666666667210244100000060F9335A4100000000CC1024419A99991909345A416666666663102441000000E00C345A416666666645102441CDCCCCEC10345A4133333333461024410000008032345A4166666666B5102441CDCCCC6C3B345A41CDCCCCCC301124413333337346345A4100000000A61124419A99991953345A4133333333DD1124413333331356345A416666666678122441666666C653345A419A999999B0122441666666E660345A4166666666271324419A9999995B345A41CDCCCCCC981324416666664653345A41CDCCCCCCD91324410000002052345A4100000000E8132441666666E63D345A4100000000FA132441CDCCCC0C2E345A4166666666261424419A99999915345A419A999999DA132441CDCCCC4C04345A4133333333BB1324410000004005345A41000000005612244166666666AC335A41333333334E1224419A999979A9335A4100000000C61124419A999979AF335A410000000081112441CDCCCCACB1335A413333333385102441CDCCCCCCBD335A419A999999FC0F244133333393C5335A41333333335E0F2441CDCCCC2CD0335A419A999999680F244100000040D2335A4166666666D60E244166666626DB335A4166666666D60E244166666626DB335A41	01010000206A080000B004C1E636122441333333E304345A41	930290801	H	L'Avenir Parisien 1	9302908	93029	93	11	0
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	01060000206A080000010000000103000000010000001800000000000000F60C2441000000C0FC335A4100000000C70D24419A9999191C345A41CDCCCCCC120E2441CDCCCC8C28345A4100000000920E24416666662640345A4100000000E80E24419A99995956345A4166666666360F24413333335351345A41CDCCCCCC731024419A9999D938345A419A9999997F1024410000002037345A4133333333461024410000008032345A416666666645102441CDCCCCEC10345A416666666663102441000000E00C345A4100000000CC1024419A99991909345A41666666667210244100000060F9335A41CDCCCCCC1E10244100000080E8335A41CDCCCCCCCB0F244166666646F9335A4166666666A10F2441CDCCCCCCFD335A4166666666D60E244166666626DB335A419A999999680F244100000040D2335A41333333335E0F2441CDCCCC2CD0335A4133333333E10E244100000080D8335A4100000000C80D24419A999919EA335A41CDCCCCCC320D244166666666F6335A4100000000F60C2441000000C0FC335A4100000000F60C2441000000C0FC335A41	01010000206A080000264516A1ED0E2441343333B314345A41	930290802	H	L'Avenir Parisien 2	9302908	93029	93	11	0
01060000206A080000010000000103000000010000003600000000000000E80E24419A99995956345A41CDCCCCCCEC0E2441CDCCCCCC57345A41666666660A0F2441333333735F345A419A999999270F24413333335367345A41333333333D0F2441CDCCCCCC6C345A41CDCCCCCC640F24419A9999F976345A41CDCCCCCC760F24419A9999997C345A41000000006B0F2441333333B37D345A41CDCCCCCC7F0F24419A9999B980345A41CDCCCCCCA30F24419A99997988345A4100000000D30F24413333331392345A419A999999DC0F24419A9999B992345A4166666666E20F24410000006093345A4100000000E50F24410000006093345A4100000000EF0F24419A9999D992345A41CDCCCCCC1C102441CDCCCCEC8E345A41000000003D1024416666666697345A41CDCCCCCC621024419A9999B9A0345A41CDCCCCCC961024419A999999AE345A4100000000AA10244133333313B3345A41333333331E1124419A999959B6345A416666666623112441CDCCCCECB5345A41000000008B11244133333313AE345A4133333333E511244100000080A6345A41000000004E1224419A9999799E345A419A9999996F122441333333739B345A4166666666291224419A9999F98D345A4166666666E5112441000000C080345A41CDCCCCCC9E1124413333335373345A41666666664D122441CDCCCC8C67345A413333333369122441CDCCCCAC65345A419A999999B0122441666666E660345A410000000088122441CDCCCC4C58345A416666666678122441666666C653345A419A9999994F1224416666664654345A416666666623122441CDCCCCAC54345A4133333333F7112441CDCCCC8C55345A4133333333DD1124413333331356345A4100000000C1112441CDCCCCAC54345A4100000000A61124419A99991953345A419A999999A0112441000000A052345A419A9999998B112441333333D350345A413333333376112441CDCCCC0C4E345A41333333333C112441333333B347345A41CDCCCCCC301124413333337346345A41CDCCCCCC011124410000000042345A4166666666E91024416666660640345A4100000000C5102441333333133D345A4166666666B5102441CDCCCC6C3B345A41CDCCCCCC9A102441CDCCCC4C39345A419A9999997F1024410000002037345A41CDCCCCCC731024419A9999D938345A4166666666360F24413333335351345A4100000000E80E24419A99995956345A41	01060000206A080000010000000103000000010000001500000000000000E80E24419A99995956345A41CDCCCCCC640F24419A9999F976345A41CDCCCCCC7F0F24419A9999B980345A4100000000D30F24413333331392345A4100000000EF0F24419A9999D992345A41CDCCCCCC1C102441CDCCCCEC8E345A4100000000AA10244133333313B3345A41333333331E1124419A999959B6345A41000000008B11244133333313AE345A419A9999996F122441333333739B345A41CDCCCCCC9E1124413333335373345A419A999999B0122441666666E660345A416666666678122441666666C653345A4133333333DD1124413333331356345A4100000000A61124419A99991953345A41CDCCCCCC301124413333337346345A419A9999997F1024410000002037345A41CDCCCCCC731024419A9999D938345A4166666666360F24413333335351345A4100000000E80E24419A99995956345A4100000000E80E24419A99995956345A41	01010000206A08000024CF1E0C831024416666662675345A41	930290803	H	L'Avenir Parisien 3	9302908	93029	93	11	0
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	01060000206A08000001000000010300000001000000270000006666666664142441CDCCCCACBB345A4166666666AB1424419A9999B9BB345A41000000001415244166666626B9345A419A9999998A1524419A9999F9D4345A419A999999521624410000000007355A41CDCCCCCC9C162441333333F318355A4100000000521624410000008022355A4166666666D91524410000006030355A4133333333F21524413333335338355A41333333333A162441CDCCCCCC38355A419A99999963162441CDCCCC8C3A355A4166666666F8162441666666062F355A41CDCCCCCC0E172441666666C634355A416666666627172441CDCCCCAC34355A419A999999D2172441333333D326355A41333333330A1824419A99999923355A41CDCCCCCCEE172441CDCCCCEC1D355A41CDCCCCCC0D182441CDCCCCEC1B355A41333333332E1824413333331322355A4100000000461824416666662621355A41333333338E182441CDCCCC4C19355A4100000000971924419A99993905355A419A999999701924419A9999D9FD345A419A99999921192441333333F303355A41333333334B182441333333F3D8345A41CDCCCCCCC21824419A999999CF345A419A999999C017244100000020A0345A419A99999905172441333333537B345A41CDCCCCCC1B162441333333D38D345A419A999999CB152441CDCCCC8C93345A419A999999911524419A9999F98C345A4166666666871524413333335380345A41666666660E1524410000008069345A4166666666FA142441CDCCCC0C71345A4100000000B0142441333333B384345A416666666697142441666666E68C345A4133333333891424419A9999B996345A416666666664142441CDCCCCACBB345A416666666664142441CDCCCCACBB345A41	01010000206A080000DC6C969E0F1724419A999949D2345A41	930290903	H	Paris Campagne 3	9302909	93029	93	11	0
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	01010000206A080000D42627794A1324416666667675345A41	930290804	A	L'Avenir Parisien 4	9302908	93029	93	11	1
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	01060000206A0800000100000001030000000100000019000000666666660E1524410000008069345A4166666666871524413333335380345A419A999999911524419A9999F98C345A419A999999CB152441CDCCCC8C93345A41CDCCCCCC1B162441333333D38D345A419A99999905172441333333537B345A419A999999C017244100000020A0345A41CDCCCCCCC21824419A999999CF345A419A999999421924419A9999B9C5345A419A999999D01924419A999999E3345A41CDCCCCCCF21A24419A9999F9CC345A419A999999411B2441000000E0CE345A41CDCCCCCC9B1B2441333333B3C3345A41CDCCCCCC2F1B2441CDCCCC8CB3345A4166666666611A24413333331396345A4133333333751924413333339379345A419A999999391824410000002042345A41333333332F182441333333933F345A4133333333001824410000000043345A41CDCCCCCC801624419A9999D964345A41CDCCCCCC0B162441CDCCCC2C51345A4166666666F2152441CDCCCC8C4F345A413333333329152441000000A056345A41666666660E1524410000008069345A41666666660E1524410000008069345A41	01010000206A0800008EC63EBBDC182441666666E691345A41	930290901	H	Paris Campagne 1	9302909	93029	93	11	0
01060000206A080000010000000103000000010000003A00000066666666951324419A9999B9F6345A41CDCCCCCC9713244100000040FC345A41666666669D13244133333353FF345A419A999999AD1324413333333305355A4133333333B6132441000000A008355A4166666666D51324419A99997911355A4100000000DE1324416666662614355A4100000000EC1324416666662617355A416666666610142441666666C61D355A419A9999992B1424413333333322355A41000000003B1424413333331324355A4133333333511424419A9999D926355A41CDCCCCCC80142441666666262C355A4100000000B91424416666664631355A4166666666D51424419A99995933355A4133333333F01424416666668634355A410000000015152441CDCCCCCC35355A41CDCCCCCC551524410000006037355A41CDCCCCCC69152441000000E037355A41333333339B152441CDCCCC6C38355A4133333333F21524413333335338355A4133333333F01524413333331336355A4100000000E91524413333331334355A4166666666D91524410000006030355A4100000000521624410000008022355A416666666687162441CDCCCCAC1B355A41666666668D162441666666E61A355A41CDCCCCCC9C162441333333F318355A419A999999521624410000000007355A41000000003C1624413333335301355A41CDCCCCCC27162441CDCCCC4CFC345A416666666615162441333333B3F7345A4133333333B9152441000000A0E0345A419A9999998A1524419A9999F9D4345A41333333334E15244133333333C7345A41000000001415244166666626B9345A4133333333EA142441CDCCCCECB9345A41CDCCCCCCDF14244100000040BA345A4166666666AB1424419A9999B9BB345A41CDCCCCCC931424419A9999F9BB345A416666666664142441CDCCCCACBB345A4133333333491424419A999939BB345A41CDCCCCCC4314244100000020BB345A416666666630142441666666C6BA345A419A9999992114244166666686BA345A419A9999991714244166666686BA345A41333333330C142441CDCCCCACBA345A41333333330A14244100000020BC345A41666666660114244166666606C0345A4166666666FC13244166666646C4345A41CDCCCCCCF513244166666606CA345A4133333333DB1324419A9999D9D8345A4133333333D113244166666626DD345A4100000000B413244100000080E4345A41CDCCCCCCAD13244100000040E6345A4133333333A213244100000000EB345A4100000000981324419A9999D9F1345A4166666666951324419A9999B9F6345A41	01060000206A080000010000000103000000010000001500000066666666951324419A9999B9F6345A41666666669D13244133333353FF345A4100000000DE1324416666662614355A419A9999992B1424413333333322355A41CDCCCCCC80142441666666262C355A4166666666D51424419A99995933355A41CDCCCCCC69152441000000E037355A4133333333F21524413333335338355A4166666666D91524410000006030355A4100000000521624410000008022355A41CDCCCCCC9C162441333333F318355A419A999999521624410000000007355A419A9999998A1524419A9999F9D4345A41000000001415244166666626B9345A4166666666AB1424419A9999B9BB345A41333333330C142441CDCCCCACBA345A41CDCCCCCCF513244166666606CA345A4133333333D113244166666626DD345A41CDCCCCCCAD13244100000040E6345A4166666666951324419A9999B9F6345A4166666666951324419A9999B9F6345A41	01010000206A080000E9E7E7A7DA1424419A9999F9F9345A41	930290902	H	Paris Campagne 2	9302909	93029	93	11	0
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	01060000206A080000010000000103000000010000002A000000333333334B182441333333F3D8345A419A99999921192441333333F303355A419A999999701924419A9999D9FD345A419A999999D71924419A99999910355A419A999999181A24419A9999B90B355A4100000000391A24413333337312355A4166666666FC1924410000008016355A41CDCCCCCC111A2441666666C61A355A4166666666501A2441333333B316355A4166666666721A2441000000401D355A4100000000271B24419A9999F90D355A4133333333401B24419A99991913355A4100000000DB1B2441CDCCCC4C05355A4133333333F51B2441CDCCCC6C09355A41CDCCCCCC941C24419A999959FB345A41333333339D1C244100000060FB345A4100000000D81C2441CDCCCC8C0D355A419A999999381D24419A99991922355A4166666666951D2441333333D324355A41CDCCCCCCAB1E24419A9999D924355A41666666662D1F2441333333F322355A41CDCCCCCCC81E2441CDCCCC6C0C355A4100000000801F24416666662600355A4166666666DD1F2441333333B3FA345A4100000000EF1E244133333353CB345A4100000000AE1E244166666646BD345A41333333334F1E24419A999999CB345A4100000000D51D2441CDCCCC0CD5345A4166666666A91D24419A999979CA345A419A999999911D244100000000CD345A41CDCCCCCC6D1D2441CDCCCCECC8345A4133333333401D244133333333C0345A4133333333171D2441CDCCCC8CBE345A41CDCCCCCCE01C2441666666C6B9345A419A999999D81C24419A999999B6345A4166666666791C2441000000A0A8345A419A999999411B2441000000E0CE345A41CDCCCCCCF21A24419A9999F9CC345A419A999999D01924419A999999E3345A419A999999421924419A9999B9C5345A41333333334B182441333333F3D8345A41333333334B182441333333F3D8345A41	01010000206A080000DE1D6F98011C2441CDCCCC2CE6345A41	930290904	H	Paris Campagne 4	9302909	93029	93	11	0
01060000206A080000010000000103000000010000001E01000066666666250F2441000000C072375A41666666662B0F24413333337373375A419A9999992E0F24419A99993974375A4100000000300F2441000000C075375A4166666666380F24416666662676375A4100000000560F24413333339378375A4133333333620F2441000000207A375A419A999999770F2441666666E67D375A41666666667D0F24419A9999D97F375A4100000000800F2441CDCCCCCC81375A41CDCCCCCC810F24419A9999F986375A41CDCCCCCC810F2441666666E68B375A41CDCCCCCC810F2441333333538C375A4100000000820F2441000000E093375A4166666666820F244133333373A0375A4166666666820F244100000000A1375A4100000000820F2441CDCCCC4CB8375A41CDCCCCCC810F2441333333B3C4375A4133333333840F244133333373C9375A4100000000930F2441333333F3C9375A4133333333B80F244100000040CB375A41333333332C102441333333B3CE375A419A9999993D1024419A999959CF375A41666666664310244133333393CF375A41000000005C102441666666C6D0375A4133333333FA1024419A9999B9D8375A419A999999FC102441CDCCCCCCD8375A41CDCCCCCCFB102441CDCCCC2CD9375A4133333333FE102441CDCCCC4CDA375A41CDCCCCCC0411244100000020DB375A41333333330811244133333333DB375A419A999999ED102441CDCCCCCCE4375A4166666666CA1024419A999959EF375A4100000000C210244100000080F4375A41CDCCCCCCBF102441000000C0F5375A419A999999BC102441666666A6F7375A419A999999A51024410000004005385A4133333333A0102441CDCCCCCC08385A4100000000A5102441666666C609385A4133333333A5102441666666260A385A4166666666A5102441333333B30A385A4133333333A5102441CDCCCCAC0B385A4100000000A4102441666666860C385A4100000000A2102441000000C00D385A419A9999999B102441666666E610385A4166666666961024416666662613385A419A999999921024413333333314385A419A9999998D1024413333331316385A4133333333861024413333333318385A41333333337E102441666666661A385A413333333373102441000000801C385A41666666666A102441000000201E385A41CDCCCCCC611024419A99993920385A419A9999995F1024413333331321385A41000000005E1024410000000022385A41CDCCCCCC5D1024410000002023385A41CDCCCCCC541024416666660624385A41CDCCCCCC451024419A99995925385A4100000000401024410000000026385A41666666663E102441CDCCCC2C26385A419A99999946102441000000A026385A413333333363102441CDCCCC2C28385A41CDCCCCCCD7112441333333733C385A4166666666DC112441000000C03C385A4166666666051224419A9999593F385A4100000000371224410000008042385A41000000004D1224410000006044385A41CDCCCCCC5F122441CDCCCC6C45385A41000000007A1224416666668646385A41CDCCCCCCF01224410000008048385A413333333378132441333333734A385A4133333333BB1324419A9999B94C385A4166666666C9132441CDCCCCEC4C385A4100000000E61324419A9999594C385A419A999999F9132441000000404C385A410000000009142441666666264D385A413333333314142441000000E04E385A41333333332B1424416666666652385A419A999999461424413333333354385A4133333333681424416666660654385A4100000000AB1424416666666653385A419A999999F31424419A99995954385A4133333333241524416666660652385A419A99999988152441000000404F385A41CDCCCCCCA4152441666666864F385A41CDCCCCCCCA1524410000008049385A4133333333EA1524416666666649385A41CDCCCCCCFD152441666666A648385A4100000000181624416666660646385A4100000000381624410000008040385A41CDCCCCCC40162441666666263F385A416666666653162441000000403E385A41CDCCCCCC71162441666666463D385A416666666685162441000000803C385A416666666694162441CDCCCC2C3C385A419A9999999E162441CDCCCC4C39385A4100000000A41624416666668636385A41CDCCCCCCA8162441666666E635385A419A999999BE1624419A9999F934385A419A999999E11624419A99999933385A41666666660B1724413333339330385A41000000003C172441000000202E385A419A9999996E172441333333D32A385A413333333390172441333333F326385A4166666666AA172441CDCCCC0C25385A4133333333E7172441000000A022385A41000000000E182441CDCCCCCC20385A4133333333261824413333333320385A41CDCCCCCC26182441666666C61E385A41CDCCCCCC27182441000000801B385A416666666642182441CDCCCC2C1C385A41CDCCCCCC441824416666664619385A41CDCCCCCC451824410000002016385A4133333333601824410000000015385A41333333336D182441666666C60E385A413333333375182441000000400A385A416666666693182441333333B309385A4166666666AD1824416666662607385A4100000000CA1824416666660605385A4133333333D11824413333335302385A4133333333E31824413333331300385A41CDCCCCCCFA182441CDCCCCECF2375A41000000001F192441666666A6F1375A419A9999998119244166666606EB375A4166666666AB1924419A9999F9E9375A4133333333B019244166666606E8375A4133333333B519244100000060E5375A4133333333C21924419A999939E5375A4100000000DC19244166666666E4375A4100000000DE19244133333373E3375A4100000000DB192441CDCCCCACDD375A4166666666E019244100000080DB375A4100000000EE19244133333393DA375A4100000000051A2441CDCCCCCCDB375A419A999999191A24419A9999F9E0375A4100000000271A2441CDCCCC2CE3375A41333333333B1A2441CDCCCCCCE3375A41CDCCCCCC561A2441CDCCCCACE4375A4100000000891A244100000000E9375A4100000000B01A244166666646ED375A419A999999C81A2441CDCCCC2CED375A41CDCCCCCC3F1B2441CDCCCCCCED375A419A999999DB1B2441CDCCCC0CF0375A4133333333411C24419A9999B9F4375A41CDCCCCCC771C2441CDCCCC0CF7375A4166666666D21C2441CDCCCCACFA375A4100000000051D244133333393FE375A419A999999211D244100000040FF375A41CDCCCCCC4D1D244133333353FF375A41000000006B1D24410000000003385A4166666666A81D24416666660602385A41CDCCCCCCF11D2441CDCCCCAC02385A4100000000441E24416666662601385A41666666665A1E24413333333304385A4133333333801E24416666668601385A41666666668D1E2441333333F301385A41CDCCCCCC9A1E2441333333B306385A419A999999AA1E24413333335307385A4100000000B41E24416666660607385A41CDCCCCCCE81E2441000000E004385A41CDCCCCCCF91E24413333333307385A4133333333191F24419A99991903385A41CDCCCCCC3A1F2441CDCCCC6C07385A419A999999521F2441CDCCCCAC07385A4100000000A320244133333393EC375A4166666666A7202441000000E0E9375A41CDCCCCCC9320244100000020E9375A4166666666882024419A999959E8375A4133333333A92024419A999959E1375A419A999999CA20244133333333DA375A41CDCCCCCC47202441666666A6D1375A419A99999942202441CDCCCC4CD1375A413333333332202441CDCCCCECD4375A4133333333122024419A9999B9C8375A41CDCCCCCC0F2024419A9999D9C7375A41CDCCCCCCD51F24419A9999D9CB375A41CDCCCCCC641F244133333313D4375A4133333333411F2441CDCCCC8CD1375A41666666663A1F244133333393D2375A41CDCCCCCC2C1F2441CDCCCC6CD1375A41000000001F1F24419A999939D0375A41666666661E1F244166666626D0375A4166666666181F2441000000A0CF375A4166666666111F244166666606CF375A4100000000061F244166666606CE375A4100000000F71E2441333333B3CC375A4133333333DA1E244133333333CA375A4133333333A91E2441CDCCCCECC5375A419A999999981E244100000080C4375A419A999999541E2441000000C0B6375A41CDCCCCCC4F1E2441000000C0B5375A41CDCCCCCC4E1E244133333393B5375A41000000003C1E2441333333D3B1375A41CDCCCCCCFA1D2441666666A6A4375A4100000000EB1D24419A999999A5375A41CDCCCCCCC01D2441333333D3A8375A4100000000011D24416666668680375A4133333333541C24419A9999195C375A419A9999992A1C24413333335353375A4166666666F91B2441000000E048375A4133333333AC1B24416666668638375A41333333335D1B2441CDCCCC8C28375A419A999999161B2441333333331A375A41CDCCCCCC0C1B24419A99993918375A419A999999E41A24416666662610375A41CDCCCCCCD91A2441CDCCCCAC0D375A4133333333CE1A2441666666260B375A4133333333AE1A24413333333304375A41666666666A1A2441CDCCCC8CF5365A4133333333091A2441000000A0E0365A4133333333E4192441000000C0D8365A4166666666D7192441CDCCCC0CD6365A4133333333C7192441000000A0D2365A41000000008819244100000060C5365A41333333335C1924419A9999D9C7365A41666666665119244133333373C8365A41CDCCCCCCF31824419A9999B9CD365A4166666666DE182441CDCCCCECCE365A419A99999983182441CDCCCC0CD4365A413333333365182441000000C0D5365A419A999999E616244166666686E8365A41CDCCCCCC11162441CDCCCC6CB9365A4133333333B715244100000060A5365A419A9999995E15244166666666AB365A41CDCCCCCC1D1524419A9999D99D365A413333333300152441000000A097365A4166666666FF1424419A99997997365A41CDCCCCCCF0142441CDCCCC6C94365A4133333333F0142441CDCCCC4C94365A4133333333A91424410000006085365A4100000000A1142441333333B383365A410000000095142441CDCCCC2C81365A416666666661142441333333B37F365A4166666666351324410000000073365A41CDCCCCCC221324413333333372365A419A999999D9122441333333136F365A41CDCCCCCC89122441333333B36B365A41CDCCCCCC53122441CDCCCC2C69365A4100000000391224416666668668365A416666666625122441CDCCCC0C68365A4100000000FD1124410000006067365A419A999999F01124410000004062365A4100000000D6112441000000A061365A41CDCCCCCCC91124416666660661365A419A999999C91124413333331361365A419A999999B71124419A9999D964365A4133333333A2112441333333B369365A413333333383112441333333B370365A41CDCCCCCC6A1124413333335375365A419A9999993A112441CDCCCCEC7D365A419A9999991F1124416666666682365A419A999999031124416666664686365A4133333333E71024413333337389365A4166666666CB1024419A9999B98C365A4166666666CC1024419A9999598D365A419A999999CD102441666666268E365A4166666666CE102441000000008F365A4133333333CD1024413333331390365A4133333333CC102441333333F390365A4166666666CA1024419A9999B991365A4166666666C8102441CDCCCC6C92365A4133333333C41024419A99991993365A4100000000BF102441333333B393365A41CDCCCCCCB81024419A99993994365A41CDCCCCCCB31024413333339394365A4166666666B9102441CDCCCCAC97365A4133333333BF102441CDCCCC0C9E365A4100000000C21024419A999919A1365A419A999999C310244133333333A7365A419A999999C3102441666666A6A7365A4133333333CD10244133333353CA365A4133333333D6102441666666A6E6365A419A9999997E102441000000403D375A419A9999997E1024419A9999593E375A41CDCCCCCC761024419A99999946375A4133333333741024419A99995949375A413333333371102441666666C64D375A41CDCCCCCC4C1024413333333350375A41CDCCCCCC401024416666660651375A419A99999936102441CDCCCCCC51375A419A9999991B102441333333F354375A419A999999C70F2441000000605F375A41333333339F0F24416666666664375A4133333333990F24419A99993965375A4166666666500F2441666666066E375A4166666666250F2441000000C072375A41	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	01010000206A0800001A7DE605211624416666668658375A41	930300101	H	Iris 0101	9303001	93030	93	11	2
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	01060000206A0800000100000001030000000100000029000000666666666A092441CDCCCC4CD1375A41333333337D09244166666666DC375A41CDCCCCCC9E09244100000020E9375A41CDCCCCCCA909244100000060F0375A419A999999A409244166666686F8375A41666666663F0A24419A9999B91B385A419A999999F50A24413333339311385A41000000001C0B24419A99999914385A419A999999030B2441666666E62B385A41CDCCCCCCB80B2441666666662E385A41CDCCCCCC9F0C2441CDCCCC2C27385A419A9999994F0D24413333339327385A41CDCCCCCC4C0D2441333333D32E385A4100000000080E2441CDCCCCEC35385A4166666666850E2441CDCCCC4C43385A41CDCCCCCC770F2441333333B358385A4133333333AC0F24419A9999B955385A41CDCCCCCCF40F24410000004035385A416666666603102441666666262C385A419A99999900102441CDCCCCCC22385A41666666663E102441CDCCCC2C26385A41CDCCCCCC5D1024410000002023385A4100000000A2102441000000C00D385A4133333333A0102441CDCCCCCC08385A4166666666CA1024419A999959EF375A41333333330811244133333333DB375A4133333333FA1024419A9999B9D8375A41666666664310244133333393CF375A4133333333840F244133333373C9375A4100000000CD0E24419A999919C8375A4100000000CC0E244166666686CA375A41333333332A0D244100000060C6375A4166666666290D244133333373C7375A4133333333EE0B24419A999939C4375A41CDCCCCCC960B2441333333F3C4375A4133333333650B244133333333DC375A41CDCCCCCC0E0B244133333353D8375A4100000000020A244166666606C9375A419A9999999A092441333333F3C9375A41666666666A092441CDCCCC4CD1375A41666666666A092441CDCCCC4CD1375A41	01010000206A0800007EDFF73D510D2441000000400E385A41	930300102	H	Iris 0102	9303001	93030	93	11	0
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	01010000206A080000E915C9752B0B2441CDCCCC4C43375A41	930300103	H	Iris 0103	9303001	93030	93	11	1
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	01060000206A0800000100000001030000000100000035000000CDCCCCCCC50C2441333333F3A9365A41CDCCCCCCDF0C24419A999939B5365A419A999999E10C244166666686C4365A419A999999D80C244166666666D3365A4133333333C90C244166666666E0365A4166666666CF0C244133333393E9365A419A999999140D2441000000A000375A4166666666350D24416666668607375A419A999999350D2441000000800C375A419A999999640D2441333333B31C375A419A9999996D0D24410000006029375A4166666666570D2441666666E628375A41000000002C0D2441333333932C375A419A999999EF0C24419A9999F92B375A4100000000EC0C24413333335333375A41CDCCCCCC700D24410000000043375A4166666666D00D24419A9999394C375A41333333338C0D24413333335358375A41333333335B0D2441333333736A375A4133333333540D2441CDCCCCAC71375A41CDCCCCCCB40E24416666666674375A41666666662A0F2441CDCCCC6C77375A4166666666250F2441000000C072375A4166666666500F2441666666066E375A419A99999936102441CDCCCCCC51375A413333333371102441666666C64D375A419A9999997E102441000000403D375A4133333333D6102441666666A6E6365A4100000000C21024419A999919A1365A41CDCCCCCCB31024413333339394365A4166666666C8102441CDCCCC6C92365A4166666666CB1024419A9999B98C365A419A999999031124416666664686365A419A9999993A112441CDCCCCEC7D365A413333333383112441333333B370365A41CDCCCCCCC91124416666660661365A419A999999F01124410000004062365A41CDCCCCCCE2112441666666865C365A41CDCCCCCC31122441333333D348365A41CDCCCCCC3F1224419A99997942365A413333333383112441CDCCCC4C37365A419A999999D00F24410000000023365A41CDCCCCCC530F2441666666C63A365A419A999999A40F2441000000803E365A4166666666470F24416666660660365A419A9999990C0F2441000000E062365A4133333333E10E24419A99991968365A4166666666AA0E24413333333371365A4133333333080E24419A9999197C365A4100000000C10D2441666666E681365A41CDCCCCCCEE0C2441666666A69F365A41CDCCCCCCC50C2441333333F3A9365A41CDCCCCCCC50C2441333333F3A9365A41	01010000206A080000E83E9048D50E24419A999939CD365A41	930300104	H	Iris 0104	9303001	93030	93	11	1
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	01060000206A080000010000000103000000010000002200000000000000B3D02341666666E6CC375A4100000000CDD0234133333373DB375A41CDCCCCCCD1D02341CDCCCC2CE3375A4166666666F0D0234166666626DD375A410000000026D1234133333393D9375A41000000007CD12341333333F3D6375A41CDCCCCCC06D22341CDCCCC0CD5375A413333333361D223419A999959D0375A413333333390D22341666666A6CA375A41CDCCCCCCDAD223419A9999F9BE375A41CDCCCCCC16D3234166666646B9375A413333333395D32341000000E0B1375A41CDCCCCCC30D4234100000040AC375A4100000000E2D4234100000060A8375A410000000007D523419A999999A8375A41CDCCCCCC3CD52341CDCCCCECAF375A41333333335ED52341333333F3B1375A41CDCCCCCC89D52341666666A6AB375A410000000060D52341CDCCCCCCA2375A413333333346D52341CDCCCCCC91375A41CDCCCCCC29D52341CDCCCC8C89375A413333333304D523419A99995989375A41CDCCCCCC60D423410000002090375A4166666666BED32341CDCCCCAC92375A41000000009AD32341CDCCCC8C96375A4166666666DAD22341333333139E375A4133333333E0D12341333333F3A6375A4100000000EBD1234100000000AE375A419A9999990CD22341CDCCCC4CB8375A41CDCCCCCC4ED22341666666C6C1375A41CDCCCCCC3BD2234166666686C5375A4166666666B5D1234100000000C5375A4100000000B3D02341666666E6CC375A4100000000B3D02341666666E6CC375A41	01010000206A080000A524731EA6D22341333333E3B5375A41	930310101	H	Iris 1	9303101	93031	93	11	0
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	01060000206A080000010000000103000000010000000E000000CDCCCCCC87D2234100000080CC375A410000000018D3234133333393E8375A419A9999994DD32341CDCCCC8CED375A410000000098D32341000000E0E1375A4133333333F8D3234100000060D6375A413333333349D5234133333313B1375A410000000007D523419A999999A8375A4100000000E2D4234100000060A8375A41CDCCCCCC30D4234100000040AC375A413333333395D32341000000E0B1375A41CDCCCCCC16D3234166666646B9375A41CDCCCCCCDAD223419A9999F9BE375A41CDCCCCCC87D2234100000080CC375A41CDCCCCCC87D2234100000080CC375A41	01010000206A080000C302EEB472D32341CDCCCC8CCB375A41	930310102	H	Iris 2	9303101	93031	93	11	0
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	01060000206A0800000100000001030000000100000012000000CDCCCCCCC0D02341000000E0E4375A4166666666E1D0234133333313F8375A410000000003D12341CDCCCC0C04385A41CDCCCCCC58D12341CDCCCC0C19385A41333333339BD123410000002024385A4100000000FDD12341CDCCCC4C30385A413333333307D22341CDCCCCAC2A385A41CDCCCCCC5FD22341666666661A385A419A9999994DD32341CDCCCC8CED375A410000000018D3234133333393E8375A41CDCCCCCC87D2234100000080CC375A416666666639D2234166666626D3375A41CDCCCCCC06D22341CDCCCC0CD5375A41000000007CD12341333333F3D6375A410000000026D1234133333393D9375A4166666666F0D0234166666626DD375A41CDCCCCCCC0D02341000000E0E4375A41CDCCCCCCC0D02341000000E0E4375A41	01010000206A080000F92D04CCF2D123419A999939FE375A41	930310103	H	Iris 3	9303101	93031	93	11	0
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	01010000206A0800009E2F6283BBCF2341CDCCCCCCAF375A41	930310104	H	Iris 4	9303101	93031	93	11	1
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	01060000206A080000010000000103000000010000001D000000CDCCCCCCE1CB23419A999919FA385A41333333333ECC23416666666607395A41000000009ECC2341333333B316395A41CDCCCCCCFDCC2341CDCCCC6C0F395A416666666630CD23413333339309395A41333333336ACD23419A99997900395A419A99999918CE2341CDCCCC2CE7385A419A99999957CE2341666666E6DC385A410000000037CF23419A999959B4385A41CDCCCCCC2ED02341000000A0C9385A416666666664D02341CDCCCC6CC2385A41666666669DD02341333333B3C7385A41000000006ED1234100000080D7385A419A999999A8D12341333333F3C0385A419A999999EFD1234166666666B3385A41333333333CD2234100000040A6385A4166666666A1D12341333333F39E385A4133333333D1D02341333333D391385A410000000032D023413333335386385A413333333362CF2341CDCCCC2C72385A41CDCCCCCCFECE2341000000C075385A419A999999C0CE23413333337373385A419A999999A3CE23413333337374385A41CDCCCCCC9CCD2341CDCCCC8C8E385A41CDCCCCCCD6CC2341000000A0A2385A4100000000B4CD234133333313C2385