SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep94;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep94 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep94','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep94','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep94','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep94"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000A4033B823C10244100000020BE1E5A41	940010000	Z	Ablon-sur-Seine	9400100	94001	94	11	1
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	01060000206A0800000100000001030000000100000016000000CDCCCCCC24102441333333F3D3265A41666666662B1124419A9999F9DC265A413333333334122441000000A0E7265A419A999999951224419A999939ED265A4100000000E4122441000000C0F3265A4166666666F01224419A999939F0265A41333333336D1324419A999979F8265A41CDCCCCCC6C132441CDCCCC4CFD265A4100000000AA1324419A9999D9FF265A4100000000281424410000004003275A41666666665814244133333313EA265A4133333333D814244100000040AE265A4166666666FF1424419A9999799E265A419A999999BF1324419A9999D993265A410000000054132441000000C091265A4133333333A11224419A9999998B265A41CDCCCCCC591124419A9999597E265A4166666666DF10244133333373A7265A419A99999985102441CDCCCCECBB265A4166666666421024419A9999D9CD265A41CDCCCCCC24102441333333F3D3265A41CDCCCCCC24102441333333F3D3265A41	01010000206A0800005023A3A89612244134333333BF265A41	940020201	H	Zola Carnot	9400202	94002	94	11	0
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	01060000206A080000010000000103000000010000001F000000CDCCCCCC9B092441000000E0D8275A4166666666AB09244166666626F5275A4133333333FB092441CDCCCC2C34285A41000000000C0A2441333333D343285A41CDCCCCCC3D0A2441000000C062285A41333333335D0A2441666666667F285A419A9999996D0A24419A9999599B285A4100000000630A244133333353AF285A41CDCCCCCC430A2441CDCCCC6CC1285A41CDCCCCCC220A24419A999939CB285A4133333333F109244100000080D3285A4100000000B00A2441000000E0CE285A41333333337F0B2441000000A0CB285A41CDCCCCCC550C2441CDCCCC0CC9285A4166666666090D24419A999959C8285A41CDCCCCCCAE0D244166666606CA285A419A999999CD0D2441666666C6C1285A41000000000E0D2441CDCCCC4CBE285A41CDCCCCCC700C244166666666BF285A41333333339D0C2441000000405D285A4166666666B80C24419A9999391B285A4100000000540A2441CDCCCC6C0D285A419A999999410A24410000006003285A4133333333370A2441000000E0E3275A419A9999994B0A2441000000C0CF275A41CDCCCCCC630A24419A999979C1275A4133333333850A2441000000A0B5275A4166666666EB092441CDCCCCCCB1275A41CDCCCCCCD109244100000020B0275A41CDCCCCCC9B092441000000E0D8275A41CDCCCCCC9B092441000000E0D8275A41	01010000206A0800001847B93F570B2441000000003C285A41	940020101	H	Chinagora Berthelot	9400201	94002	94	11	0
01060000206A0800000100000001030000000100000024000000CDCCCCCC700C244166666666BF285A41CDCCCCCCD70C24419A9999B9BE285A419A999999FC0C244100000080BE285A41000000000E0D2441CDCCCC4CBE285A41CDCCCCCC340D2441000000E0BE285A419A999999750D24419A9999F9BF285A41CDCCCCCCA30D2441666666C6C0285A419A999999CD0D2441666666C6C1285A4133333333D20D244133333393C0285A4166666666F20D244166666666B7285A4100000000FB0D24419A999919B5285A41333333333B0E24419A999979A3285A41CDCCCCCC4F0E2441333333739E285A4166666666830E2441666666E691285A419A999999AD0E24419A9999B988285A4100000000E30E2441000000207D285A4166666666470F2441666666666A285A4100000000A20F2441333333B35A285A4133333333F30F2441333333334E285A413333333385102441666666C639285A4133333333A41024416666666634285A413333333396102441000000A031285A413333333385102441CDCCCC8C31285A4166666666481024413333333330285A413333333307102441CDCCCCAC2E285A41000000009E0F24419A9999192C285A419A999999E50E2441666666E627285A419A9999993B0E24413333333324285A41666666667A0D2441333333D31F285A4166666666B80C24419A9999391B285A41333333339D0C2441000000405D285A41CDCCCCCC910C2441666666A674285A419A9999998A0C24419A99991987285A4166666666800C2441CDCCCCCC9A285A41CDCCCCCC770C2441CDCCCC8CAF285A41CDCCCCCC700C244166666666BF285A41	01060000206A0800000100000001030000000100000012000000CDCCCCCC700C244166666666BF285A41000000000E0D2441CDCCCC4CBE285A419A999999CD0D2441666666C6C1285A41333333333B0E24419A999979A3285A4166666666830E2441666666E691285A4100000000E30E2441000000207D285A4166666666470F2441666666666A285A4100000000A20F2441333333B35A285A4133333333F30F2441333333334E285A413333333385102441666666C639285A4133333333A41024416666666634285A413333333385102441CDCCCC8C31285A419A999999E50E2441666666E627285A41666666667A0D2441333333D31F285A4166666666B80C24419A9999391B285A41333333339D0C2441000000405D285A41CDCCCCCC700C244166666666BF285A41CDCCCCCC700C244166666666BF285A41	01010000206A08000010AFD61BE00D2441666666866F285A41	940020102	H	Tony Garnier Soladier	9400201	94002	94	11	0
01060000206A08000001000000010300000001000000280000009A9999993B0E24413333333324285A419A999999E50E2441666666E627285A41000000009E0F24419A9999192C285A413333333307102441CDCCCCAC2E285A4166666666481024413333333330285A413333333385102441CDCCCC8C31285A413333333396102441000000A031285A4133333333A41024416666666634285A419A999999001124416666664624285A41CDCCCCCC421124410000006018285A41666666665B112441333333D314285A41CDCCCCCC621124416666664613285A41CDCCCCCC74112441CDCCCC8C0F285A4100000000AE1124419A99997900285A41CDCCCCCCDF112441CDCCCC6CF3275A4133333333C9112441CDCCCCACF0275A41CDCCCCCC411124419A9999B9E2275A41666666662B1124419A9999B9E0275A41CDCCCCCCF01024419A999919DB275A419A999999DB102441CDCCCCECD8275A41CDCCCCCCC01024419A999959D6275A41CDCCCCCC8710244100000060D0275A41CDCCCCCC541024419A9999F9CA275A41CDCCCCCC35102441000000E0C7275A4100000000241024419A999999C6275A41CDCCCCCC10102441CDCCCCCCC4275A4166666666E50F24419A999999C0275A4100000000D00F2441333333F3BE275A41CDCCCCCCB30F24419A9999F9BC275A419A999999820F24419A999939BA275A41CDCCCCCC410F24419A999919B7275A4100000000190F2441CDCCCC0CB5275A4133333333FB0E2441CDCCCC4CC4275A4166666666D10E24419A999999D9275A41CDCCCCCCA40E244133333313EF275A41000000009C0E2441CDCCCCCCF3275A4100000000810E24416666662602285A4166666666710E2441666666C609285A419A9999995E0E2441000000E012285A419A9999993B0E24413333333324285A41	01060000206A080000010000000103000000010000000F0000009A9999993B0E24413333333324285A41000000009E0F24419A9999192C285A413333333385102441CDCCCC8C31285A4133333333A41024416666666634285A41CDCCCCCC74112441CDCCCC8C0F285A41CDCCCCCCDF112441CDCCCC6CF3275A41CDCCCCCC411124419A9999B9E2275A41CDCCCCCCC01024419A999959D6275A41CDCCCCCC541024419A9999F9CA275A4166666666E50F24419A999999C0275A41CDCCCCCCB30F24419A9999F9BC275A4100000000190F2441CDCCCC0CB5275A4100000000810E24416666662602285A419A9999993B0E24413333333324285A419A9999993B0E24413333333324285A41	01010000206A080000926B50212B10244134333323FA275A41	940020103	H	Diderot Louis Blanc	9400201	94002	94	11	0
01060000206A080000010000000103000000010000003500000066666666B80C24419A9999391B285A41666666667A0D2441333333D31F285A419A9999993B0E24413333333324285A419A9999995E0E2441000000E012285A4166666666710E2441666666C609285A4100000000810E24416666662602285A41000000009C0E2441CDCCCCCCF3275A41CDCCCCCCA40E244133333313EF275A4166666666D10E24419A999999D9275A4133333333FB0E2441CDCCCC4CC4275A4100000000190F2441CDCCCC0CB5275A41CDCCCCCC1E0F2441CDCCCC6CB2275A419A999999220F2441000000E0B0275A41CDCCCCCC2B0F244100000040AE275A41666666664B0F244100000000A5275A4100000000780F24413333331398275A4133333333AA0F2441CDCCCCEC89275A4100000000C00F24416666668683275A4133333333BB0F2441CDCCCC4C83275A4166666666B80F24416666660683275A4100000000B60F2441CDCCCCAC82275A4166666666B40F24410000004082275A419A999999270F24419A99993986275A4166666666E90E24416666660688275A41CDCCCCCC490E2441000000A08C275A41333333331F0E24419A9999F98D275A41000000007B0D24419A9999F991275A41CDCCCCCC560D2441333333F392275A41CDCCCCCC4E0D24413333335393275A41CDCCCCCC450D2441CDCCCCEC93275A41CDCCCCCC3F0D2441666666A694275A41CDCCCCCC3B0D24413333335395275A4100000000390D24410000000096275A4100000000370D2441CDCCCCCC96275A4133333333350D2441000000C097275A419A999999340D24416666668698275A4133333333340D24416666664699275A41333333332C0D244133333313A4275A41333333332A0D24419A999959A6275A41000000001F0D244133333353B1275A41CDCCCCCC150D24419A9999D9BB275A41000000000D0D244133333353C5275A4133333333060D244166666646CD275A4100000000010D244133333393D1275A4100000000F60C244166666646D8275A4100000000DE0C244133333333E7275A4100000000D70C24419A999919EB275A4133333333D30C2441CDCCCC8CED275A419A999999CE0C24419A999999F0275A419A999999CA0C2441CDCCCC2CF4275A4133333333C60C24419A999939FC275A4100000000C00C2441CDCCCCCC09285A4166666666B80C24419A9999391B285A41	01060000206A080000010000000103000000010000000F00000066666666B80C24419A9999391B285A419A9999993B0E24413333333324285A4100000000810E24416666662602285A41CDCCCCCCA40E244133333313EF275A419A999999220F2441000000E0B0275A4100000000C00F24416666668683275A4166666666B40F24410000004082275A41333333331F0E24419A9999F98D275A41CDCCCCCC560D2441333333F392275A4133333333350D2441000000C097275A41333333332C0D244133333313A4275A4100000000010D244133333393D1275A419A999999CE0C24419A999999F0275A4166666666B80C24419A9999391B285A4166666666B80C24419A9999391B285A41	01010000206A080000B65E8609EB0D2441CCCCCCECD4275A41	940020104	H	Marché Guesde	9400201	94002	94	11	0
01060000206A080000010000000103000000010000003A00000033333333370A2441000000E0E3275A419A999999380A244166666626EE275A41CDCCCCCC390A244133333373F4275A419A9999993D0A244133333353FF275A41333333333F0A24419A99993901285A419A999999410A24410000006003285A41CDCCCCCC450A2441666666E605285A41666666664F0A2441000000200B285A4100000000540A2441CDCCCC6C0D285A4133333333A40A2441000000200F285A41CDCCCCCC1C0B24419A99991912285A4166666666210B24413333333312285A4166666666F20B24419A9999D916285A4166666666B80C24419A9999391B285A4100000000C00C2441CDCCCCCC09285A4133333333C60C24419A999939FC275A419A999999CA0C2441CDCCCC2CF4275A419A999999CE0C24419A999999F0275A4133333333D30C2441CDCCCC8CED275A4100000000D70C24419A999919EB275A4100000000DE0C244133333333E7275A4100000000F60C244166666646D8275A4100000000010D244133333393D1275A4133333333060D244166666646CD275A41000000000D0D244133333353C5275A41CDCCCCCC150D24419A9999D9BB275A41000000001F0D244133333353B1275A41333333332A0D24419A999959A6275A41333333332C0D244133333313A4275A4166666666CA0C244166666666A0275A4166666666A10C24419A9999F99E275A41333333335D0C2441CDCCCCAC9C275A4166666666490C2441666666269C275A4100000000380C2441CDCCCCCC9B275A419A999999240C24419A9999D99B275A419A9999990C0C2441000000809C275A4133333333ED0B2441666666669D275A4100000000B40B2441CDCCCC0C9F275A4100000000850B244133333353A0275A4133333333450B244166666626A2275A4133333333DA0A244166666626A5275A4133333333CF0A244133333373A5275A4166666666C50A244100000060A5275A41CDCCCCCCB50A2441000000E0A4275A4166666666A50A244100000060AA275A4100000000980A24419A999939AF275A4133333333850A2441000000A0B5275A4100000000710A244166666666BC275A41666666666A0A2441000000C0BE275A41CDCCCCCC630A24419A999979C1275A41CDCCCCCC5E0A2441666666E6C3275A41CDCCCCCC590A244133333373C6275A4166666666500A244133333373CC275A419A9999994B0A2441000000C0CF275A4100000000450A244133333313D5275A41CDCCCCCC3C0A2441333333D3DC275A4133333333380A24419A999939E2275A4133333333370A2441000000E0E3275A41	01060000206A080000010000000103000000010000000F00000033333333370A2441000000E0E3275A419A999999410A24410000006003285A4100000000540A2441CDCCCC6C0D285A4166666666B80C24419A9999391B285A419A999999CE0C24419A999999F0275A4100000000010D244133333393D1275A41333333332C0D244133333313A4275A41333333335D0C2441CDCCCCAC9C275A419A999999240C24419A9999D99B275A4133333333CF0A244133333373A5275A41CDCCCCCCB50A2441000000E0A4275A4100000000710A244166666666BC275A419A9999994B0A2441000000C0CF275A4133333333370A2441000000E0E3275A4133333333370A2441000000E0E3275A41	01010000206A080000AC403FC6980B2441CCCCCC8CDA275A41	940020105	H	Blanqui Seine Ponton	9400201	94002	94	11	0
01060000206A080000010000000103000000010000003B000000CDCCCCCCF0122441333333938E265A413333333338132441000000E090265A410000000054132441000000C091265A419A999999701324419A99997992265A419A999999AD1324416666660694265A4100000000B6132441000000E093265A419A999999BF1324419A9999D993265A419A999999E11324419A9999F994265A41666666662D1424410000008097265A41CDCCCCCC8A1424419A9999999A265A413333333397142441666666069B265A4133333333A4142441CDCCCC6C9B265A4166666666E4142441666666869D265A4133333333F3142441CDCCCC0C9E265A4166666666FF1424419A9999799E265A419A999999FF142441CDCCCC6C9E265A41000000000D1524416666660698265A41CDCCCCCC1F152441333333138E265A41666666662B1524413333333388265A41CDCCCCCC5F1524419A9999996D265A41CDCCCCCC8D152441000000E058265A4166666666AC152441666666264B265A4166666666F1152441333333132C265A41000000005D162441333333D3F6255A419A99999969162441666666C6F0255A41333333334216244133333353ED255A41333333333E16244133333333ED255A41000000002F162441CDCCCC4CEC255A41CDCCCCCC1B1624419A999979EB255A41666666662015244133333373E3255A41CDCCCCCCD0142441333333D3E0255A419A999999A514244133333373F5255A4166666666A114244100000080F6255A41666666669B14244166666646F7255A413333333398142441000000A0F7255A419A9999998B142441CDCCCCECF8255A41CDCCCCCC691424419A9999F9FB255A419A99999959142441CDCCCC6CFD255A41CDCCCCCC4E142441CDCCCC6CFE255A416666666649142441000000C0FE255A4133333333461424419A9999D9FE255A41CDCCCCCCCF132441CDCCCC0C0A265A419A999999CB132441333333330A265A4166666666C21324413333339309265A4133333333B7132441CDCCCC2C09265A41CDCCCCCC641324416666666608265A419A9999992E1324416666660608265A41000000002A132441000000A011265A419A99999922132441000000A021265A41333333331B1324419A99993933265A4100000000131324419A99997944265A41000000000D1324413333339351265A419A999999091324413333339358265A4133333333061324419A9999D960265A410000000005132441333333F362265A41CDCCCCCCFD122441333333B373265A41CDCCCCCCF7122441CDCCCCAC80265A419A999999F6122441CDCCCC0C84265A41CDCCCCCCF0122441333333938E265A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCF0122441333333938E265A410000000054132441000000C091265A419A999999BF1324419A9999D993265A4166666666FF1424419A9999799E265A41CDCCCCCC5F1524419A9999996D265A4166666666F1152441333333132C265A419A99999969162441666666C6F0255A41CDCCCCCC1B1624419A999979EB255A41CDCCCCCCD0142441333333D3E0255A419A999999A514244133333373F5255A419A9999998B142441CDCCCCECF8255A41CDCCCCCCCF132441CDCCCC0C0A265A419A9999992E1324416666660608265A41CDCCCCCCF0122441333333938E265A41CDCCCCCCF0122441333333938E265A41	01010000206A080000E9B07FBC721424419A9999D93B265A41	940020202	H	Grand Ensemble	9400202	94002	94	11	0
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	01060000206A0800000100000001030000000100000014000000CDCCCCCCB50A2441000000E0A4275A4133333333CF0A244133333373A5275A419A999999240C24419A9999D99B275A41333333335D0C2441CDCCCCAC9C275A41333333332C0D244133333313A4275A4133333333350D2441000000C097275A41CDCCCCCC560D2441333333F392275A41333333331F0E24419A9999F98D275A4166666666B40F24410000004082275A4100000000B80F2441333333737F275A41CDCCCCCC630F24410000004076275A419A9999996E0E2441666666065D275A41333333335A0D24416666662640275A41333333330A0D24419A99997948275A419A9999996F0C24416666664656275A4133333333B30B24419A99999970275A41666666664D0B24410000000082275A419A999999F40A2441000000408F275A41CDCCCCCCB50A2441000000E0A4275A41CDCCCCCCB50A2441000000E0A4275A41	01010000206A080000AE78D70A730D2441CDCCCC6C72275A41	940020106	H	Micolon 14 Juillet	9400201	94002	94	11	0
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	01060000206A080000010000000103000000010000001400000000000000190F2441CDCCCC0CB5275A41CDCCCCCCB30F24419A9999F9BC275A4166666666E50F24419A999999C0275A41CDCCCCCC541024419A9999F9CA275A41CDCCCCCCC01024419A999959D6275A41CDCCCCCC411124419A9999B9E2275A41CDCCCCCCDF112441CDCCCC6CF3275A41CDCCCCCC72122441666666E6C9275A4166666666B61224419A999919B5275A4133333333231324413333339381275A41CDCCCCCC101324419A9999D97C275A41CDCCCCCC771224419A9999F96C275A41CDCCCCCC5C122441CDCCCC6C6F275A419A999999521024419A9999597E275A41CDCCCCCCD70F24410000006081275A4100000000B80F2441333333737F275A4100000000C00F24416666668683275A419A999999220F2441000000E0B0275A4100000000190F2441CDCCCC0CB5275A4100000000190F2441CDCCCC0CB5275A41	01010000206A0800004022AFA5F410244100000090AF275A41	940020107	H	Mairie	9400201	94002	94	11	0
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	01060000206A080000010000000103000000010000001B000000CDCCCCCCD109244100000020B0275A4166666666EB092441CDCCCCCCB1275A4133333333850A2441000000A0B5275A4133333333E20A2441CDCCCC2C94275A419A999999F40A2441000000408F275A41666666664D0B24410000000082275A4133333333B30B24419A99999970275A419A9999996F0C24416666664656275A41333333330A0D24419A99997948275A41333333335A0D24416666662640275A4166666666880E2441333333B35F275A41CDCCCCCC630F24410000004076275A4100000000B80F2441333333737F275A41CDCCCCCCCE0F24419A9999197F275A419A9999992F1024416666664662275A41333333330B112441333333F324275A416666666675112441CDCCCC6C04275A41CDCCCCCCDA112441333333B3E3265A41666666662B1124419A9999F9DC265A41CDCCCCCC38102441CDCCCCECD4265A41CDCCCCCC111024419A999959D2265A419A9999993B0F244166666606BC265A41CDCCCCCC620D2441CDCCCC0C01275A419A999999C80A2441666666066F275A419A9999993C0A24419A9999D98A275A41CDCCCCCCD109244100000020B0275A41CDCCCCCCD109244100000020B0275A41	01010000206A0800005989F724640E24419A9999293A275A41	940020108	H	14 Juillet Zola	9400201	94002	94	11	0
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	01060000206A0800000100000001030000000100000018000000CDCCCCCCCE0F24419A9999197F275A41CDCCCCCCD70F24410000006081275A419A999999521024419A9999597E275A41CDCCCCCC5C122441CDCCCC6C6F275A41CDCCCCCC771224419A9999F96C275A41CDCCCCCC101324419A9999D97C275A4133333333231324413333339381275A41666666663F1324416666666673275A41000000005A132441000000C069275A4133333333C8132441000000C034275A4100000000281424410000004003275A4100000000AA1324419A9999D9FF265A41CDCCCCCC6C132441CDCCCC4CFD265A41333333336D1324419A999979F8265A4166666666F01224419A999939F0265A4100000000E4122441000000C0F3265A419A999999951224419A999939ED265A413333333334122441000000A0E7265A41CDCCCCCCDA112441333333B3E3265A416666666675112441CDCCCC6C04275A41333333330B112441333333F324275A419A9999992F1024416666664662275A41CDCCCCCCCE0F24419A9999197F275A41CDCCCCCCCE0F24419A9999197F275A41	01010000206A080000A4849C0A64122441000000902C275A41	940020109	H	Gare	9400201	94002	94	11	0
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	01060000206A08000001000000010300000001000000260000009A999999420E244166666686EE245A41CDCCCCCCA10F2441000000A04C255A4166666666FF10244100000080B5255A41CDCCCCCC61112441000000A0E2255A41CDCCCCCC7B112441CDCCCC2C0E265A419A9999994B1124419A9999193A265A4100000000D0102441000000206C265A41CDCCCCCC50102441000000008E265A419A999999840F24419A999959B1265A419A9999993B0F244166666606BC265A41CDCCCCCC24102441333333F3D3265A4166666666421024419A9999D9CD265A419A99999985102441CDCCCCECBB265A4166666666DF10244133333373A7265A41CDCCCCCC591124419A9999597E265A41CDCCCCCCF0122441333333938E265A419A9999992E1324416666660608265A41333333333813244133333373F0255A416666666621132441666666E6E8255A41CDCCCCCC1C13244100000000B7255A419A999999171324416666668698255A4133333333231324410000004095255A41CDCCCCCCEB1224410000002096255A4166666666CF1224413333337385255A419A999999BF1224419A99993983255A4100000000B71224416666660674255A41333333331B1224419A99997962255A413333333310122441CDCCCC6C60255A4133333333411224413333337358255A419A999999411224419A99993956255A4100000000FC112441666666264F255A413333333382112441CDCCCCEC52255A41CDCCCCCC48112441CDCCCC8C55255A4100000000AB102441666666A65E255A4133333333A3102441666666E65B255A41CDCCCCCCEA0E244133333313E4245A419A999999420E244166666686EE245A419A999999420E244166666686EE245A41	01010000206A080000A618DBD4301224419A999929D4255A41	940020203	H	Carnot Petit Pont Alouettes	9400202	94002	94	11	0
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	01060000206A08000001000000010300000001000000200000009A999999B80C2441666666868D245A4166666666F00D244166666686D8245A419A999999420E244166666686EE245A41CDCCCCCCEA0E244133333313E4245A4133333333A3102441666666E65B255A4100000000AB102441666666A65E255A41CDCCCCCC48112441CDCCCC8C55255A413333333382112441CDCCCCEC52255A4100000000FC112441666666264F255A419A999999411224419A99993956255A4133333333411224413333337358255A413333333310122441CDCCCC6C60255A41333333331B1224419A99997962255A4100000000B71224416666660674255A419A999999BF1224419A99993983255A4166666666CF1224413333337385255A41CDCCCCCCEB1224410000002096255A4133333333231324410000004095255A41CDCCCCCC38132441666666468E255A410000000056142441CDCCCC2C4E255A4100000000681424416666666647255A4133333333CF1424413333331316255A4166666666FD142441333333F315255A41666666668C152441666666E618255A419A9999998E1524419A999919E3245A41CDCCCCCCDB142441CDCCCCCCDD245A41CDCCCCCC891424410000000079245A419A99999980142441666666466C245A4166666666F5122441333333D371245A413333333388122441000000A073245A419A999999B80C2441666666868D245A419A999999B80C2441666666868D245A41	01010000206A080000EFD59C086D122441CCCCCCCCFE245A41	940020204	H	Jardin Val de Seine	9400202	94002	94	11	1
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	01060000206A080000010000000103000000010000001800000066666666161324419A9999999A255A41CDCCCCCC1C13244100000000B7255A416666666621132441666666E6E8255A41333333333813244133333373F0255A419A9999992E1324416666660608265A41CDCCCCCCCF132441CDCCCC0C0A265A419A9999998B142441CDCCCCECF8255A419A999999A514244133333373F5255A41CDCCCCCCD0142441333333D3E0255A41CDCCCCCC1B1624419A999979EB255A419A99999969162441666666C6F0255A4133333333BF162441000000E0C7255A41666666661F172441CDCCCCAC98255A41333333339C172441CDCCCCEC60255A419A999999CE172441666666C645255A41000000007F172441CDCCCC8C42255A410000000072172441CDCCCCCC43255A4133333333E01624413333333394255A4166666666DC1624419A9999B997255A41CDCCCCCC861524419A9999F98C255A41CDCCCCCC87132441333333337C255A41CDCCCCCC38132441666666468E255A4166666666161324419A9999999A255A4166666666161324419A9999999A255A41	01010000206A080000EE200BBF1115244100000040A3255A41	940020205	H	Vert de Maison	9400202	94002	94	11	0
01060000206A080000010000000103000000010000003A000000CDCCCCCC87132441333333337C255A416666666690142441CDCCCCEC84255A4133333333AD142441CDCCCCEC85255A41666666663A152441CDCCCC4C8A255A41CDCCCCCC861524419A9999F98C255A419A99999902162441666666E690255A419A9999994A1624416666660693255A41333333339E162441CDCCCCCC95255A4166666666DC1624419A9999B997255A4133333333E01624413333333394255A4100000000F8162441666666C686255A413333333314172441666666C677255A416666666630172441CDCCCCAC67255A410000000072172441CDCCCCCC43255A41000000007F172441CDCCCC8C42255A41666666665E1724419A99993941255A419A999999411724413333331340255A419A999999211724419A9999993C255A41CDCCCCCCC41624419A9999B932255A41CDCCCCCC99162441333333D32D255A41666666666D1624419A9999D928255A41333333333A162441CDCCCC2C23255A41CDCCCCCC12162441000000001F255A4166666666E9152441666666C61B255A419A999999E4152441CDCCCC2C1B255A4166666666DD1524419A9999991A255A4133333333D6152441666666461A255A4166666666CD152441333333131A255A41666666668C152441666666E618255A410000000050152441000000E017255A419A999999081524413333335316255A4166666666FD142441333333F315255A41CDCCCCCCF01424419A99991915255A4166666666E51424419A99991914255A4100000000DF1424416666662615255A4166666666D7142441666666C615255A4133333333CF1424413333331316255A41CDCCCCCCC7142441CDCCCC4C1A255A419A999999C01424419A9999791D255A419A999999A6142441CDCCCCAC29255A419A99999994142441000000A031255A41333333338B1424419A99993936255A419A999999851424419A9999D938255A4166666666711424419A99999942255A41000000006D1424419A9999F944255A4100000000681424416666666647255A41666666665F142441000000004B255A410000000056142441CDCCCC2C4E255A41000000004A142441333333F350255A4133333333331424419A99993956255A4133333333151424419A9999B95C255A419A99999902142441000000E060255A4100000000DA132441000000E069255A41CDCCCCCCCF132441666666266C255A419A999999CD1324419A9999996C255A4166666666C5132441CDCCCC6C6E255A419A999999AD132441666666E673255A41CDCCCCCC87132441333333337C255A41	01060000206A080000010000000103000000010000000F000000CDCCCCCC87132441333333337C255A41CDCCCCCC861524419A9999F98C255A4166666666DC1624419A9999B997255A4133333333E01624413333333394255A410000000072172441CDCCCCCC43255A41000000007F172441CDCCCC8C42255A419A999999411724413333331340255A41CDCCCCCC12162441000000001F255A4166666666DD1524419A9999991A255A4166666666FD142441333333F315255A4133333333CF1424413333331316255A4100000000681424416666666647255A410000000056142441CDCCCC2C4E255A41CDCCCCCC87132441333333337C255A41CDCCCCCC87132441333333337C255A41	01010000206A08000092739FDDC91524416666669653255A41	940020206	H	Grenoble Toulon	9400202	94002	94	11	0
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	01060000206A080000010000000103000000010000001F0000000000000069DA23419A9999792D285A41666666666DDA2341000000402F285A4166666666E9DA2341CDCCCCCC2F285A419A999999C0DC23419A9999B936285A4100000000C3DE2341666666263F285A4100000000C6DE2341333333133D285A41666666663EDE2341CDCCCC4C28285A41333333333EDF2341666666660E285A416666666629E02341CDCCCCAC2E285A4166666666B6E02341000000C042285A4133333333D8E023416666662641285A416666666602E023416666660622285A41333333331CDF2341000000E002285A410000000068DE2341666666C6E9275A410000000085DE2341CDCCCCECE7275A4166666666EBDD23419A999959D4275A4133333333DEDD2341000000A0D6275A41000000007FDD234100000020C8275A4166666666A8DC234100000000A9275A41666666664DDC2341000000E098275A419A99999902DC2341000000C088275A4100000000D9DB2341666666068D275A416666666624DC2341333333539F275A416666666645DC23419A9999B9AE275A41CDCCCCCCB1DC2341666666E6E4275A419A999999B8DC23413333331300285A4166666666B1DC2341CDCCCC6C08285A413333333352DC2341000000200F285A4166666666DBDA2341333333F326285A410000000069DA23419A9999792D285A410000000069DA23419A9999792D285A41	01010000206A0800005CBB0B7491DD234166666676E5275A41	940030109	H	Laplace 2	9400301	94003	94	11	0
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	01060000206A08000001000000010300000001000000130000009A9999995ADA2341000000603C285A4100000000D6DB2341CDCCCC2C92285A41666666668CDD23416666662682285A41CDCCCCCC9ADD2341666666E686285A4100000000F9DD2341CDCCCC4C83285A4166666666E3DD2341CDCCCC8C7A285A4100000000BDDE2341333333D371285A413333333397DE23410000000063285A413333333305DF2341333333F362285A4166666666D4DE2341000000404E285A419A999999E8DE23419A9999D94B285A41666666663FDF2341CDCCCC8C48285A41666666666ADF2341000000C045285A419A99999976DF23419A99991942285A419A999999C0DC23419A9999B936285A4166666666E9DA2341CDCCCCCC2F285A41666666666DDA2341000000402F285A419A9999995ADA2341000000603C285A419A9999995ADA2341000000603C285A41	01010000206A08000028B45540FEDC2341CDCCCCBC60285A41	940030101	H	Joliot-Curie 1	9400301	94003	94	11	0
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	01060000206A080000010000000103000000010000001D000000666666663EDE2341CDCCCC4C28285A4100000000C6DE2341333333133D285A4100000000C3DE2341666666263F285A419A99999976DF23419A99991942285A41666666666ADF2341000000C045285A41666666663FDF2341CDCCCC8C48285A419A999999E8DE23419A9999D94B285A4166666666D4DE2341000000404E285A413333333305DF2341333333F362285A413333333397DE23410000000063285A4133333333CEDE23419A99995979285A4100000000E1DE2341000000007D285A416666666601DF2341333333338A285A41666666664BDF2341333333D388285A41CDCCCCCC30E023419A9999D989285A416666666648E02341333333F384285A41CDCCCCCC77E023410000008082285A419A99999996E02341333333B38B285A416666666632E123419A9999B982285A419A99999920E123410000002080285A41666666663FE22341CDCCCC6C6A285A419A999999DDE12341CDCCCC2C52285A41000000008DE12341333333933F285A416666666612E12341666666663E285A4166666666B6E02341000000C042285A416666666629E02341CDCCCCAC2E285A41333333333EDF2341666666660E285A41666666663EDE2341CDCCCC4C28285A41666666663EDE2341CDCCCC4C28285A41	01010000206A080000CA8B764A50E02341343333134D285A41	940030102	H	Joliot-Curie 2	9400301	94003	94	11	0
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	01060000206A08000001000000010300000001000000270000006666666682DD2341CDCCCC0CB0275A41CDCCCCCC85DD234166666666B1275A41666666660ADE234100000060C8275A4133333333DEDD234133333313CF275A4166666666EBDD23419A999959D4275A410000000085DE2341CDCCCCECE7275A410000000068DE2341666666C6E9275A41333333331CDF2341000000E002285A416666666602E023416666660622285A4133333333D8E023416666662641285A416666666612E12341666666663E285A41000000008DE12341333333933F285A419A99999994E12341CDCCCC2C3D285A41CDCCCCCC79E22341666666A62A285A413333333337E323416666668620285A41CDCCCCCC6BE32341333333D31A285A419A99999933E323416666660601285A41000000005DE3234100000020FF275A4166666666E8E223419A9999B9E4275A419A9999992AE2234166666606C1275A41CDCCCCCC11E2234166666626BD275A413333333324E2234133333393AB275A416666666609E22341CDCCCC2CA5275A4133333333EDE02341333333938B275A4166666666E1E02341666666C6AA275A413333333390E023419A9999D9A5275A413333333353E02341333333939F275A416666666601E02341CDCCCC6C93275A41CDCCCCCC76DF2341CDCCCC2CA3275A419A99999958DF2341333333F3A2275A413333333320DF2341000000209D275A4100000000FADE2341000000E09D275A4166666666AFDE2341000000E094275A41333333334DDE2341CDCCCC0C8D275A416666666652DE2341666666C692275A41CDCCCCCC36DE2341333333B395275A413333333384DD234166666606AF275A416666666682DD2341CDCCCC0CB0275A416666666682DD2341CDCCCC0CB0275A41	01010000206A080000E7359457B8E023419A9999F9E6275A41	940030103	H	Barbusse	9400301	94003	94	11	0
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	01060000206A080000010000000103000000010000002900000033333333EDE02341333333938B275A416666666609E22341CDCCCC2CA5275A413333333324E2234133333393AB275A41CDCCCCCC11E2234166666626BD275A419A9999992AE2234166666606C1275A4166666666E8E223419A9999B9E4275A41000000005DE3234100000020FF275A413333333308E4234100000040F7275A41333333338EE32341333333F3C8275A416666666698E423419A999959AF275A4166666666EFE42341CDCCCC6CA7275A419A9999999DE42341CDCCCC0C94275A413333333360E42341666666467E275A410000000041E423419A9999396B275A41CDCCCCCCAEE52341333333F350275A416666666693E52341000000A04B275A419A99999958E62341CDCCCC0C40275A413333333350E62341333333933D275A410000000081E62341CDCCCCAC3A275A41CDCCCCCC5AE62341000000C033275A41666666667CE523413333333306275A41666666662DE62341CDCCCC4CF9265A410000000070E62341CDCCCC0CF5265A41CDCCCCCC3FE62341CDCCCC2CF0265A41CDCCCCCC64E6234133333313EB265A419A99999907E623419A999979E0265A410000000001E52341333333B3D2265A419A9999996DE5234100000000C1265A419A999999FCE423419A999979BA265A41CDCCCCCC05E42341666666E6D3265A416666666692E32341CDCCCC0CEF265A419A99999950E32341CDCCCCAC01275A416666666632E32341CDCCCCEC0D275A41000000001AE323419A9999D91C275A419A999999E8E123413333335336275A416666666679E12341CDCCCCCC40275A413333333337E12341CDCCCC4C4D275A416666666614E12341000000A058275A410000000008E123413333333361275A4133333333EDE02341333333938B275A4133333333EDE02341333333938B275A41	01010000206A080000811B67790BE32341CCCCCCBC5C275A41	940030104	H	Jean-Macé 1	9400301	94003	94	11	0
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	01060000206A080000010000000103000000010000002800000066666666E9DD2341333333B3FD265A41CDCCCCCC1EDE2341000000E019275A413333333337DE2341CDCCCC8C2A275A4100000000A4DE23419A9999F928275A4100000000C1DE2341CDCCCC0C24275A419A999999D1DE2341333333D327275A41333333332BDF23410000006043275A416666666647DF23419A99993949275A41CDCCCCCC45DF23416666668651275A4100000000B6DF2341666666266E275A413333333357DF2341CDCCCCAC77275A416666666625E023413333331399275A413333333353E02341333333939F275A413333333390E023419A9999D9A5275A4166666666E1E02341666666C6AA275A4133333333EFE023419A99997987275A410000000008E123413333333361275A416666666614E12341000000A058275A413333333337E12341CDCCCC4C4D275A416666666679E12341CDCCCCCC40275A419A999999E8E123413333335336275A41000000001AE323419A9999D91C275A416666666632E32341CDCCCCEC0D275A419A99999950E32341CDCCCCAC01275A416666666692E32341CDCCCC0CEF265A41CDCCCCCC05E42341666666E6D3265A41CDCCCCCCB3E3234100000000DC265A410000000075E3234166666686E0265A416666666698E2234166666646F2265A41CDCCCCCC88E2234166666646EF265A41CDCCCCCCFDE1234100000040C6265A41CDCCCCCCC4E1234100000060C9265A4100000000C7E02341666666A6DA265A410000000098E023419A9999F9DC265A41CDCCCCCCECDF2341CDCCCCECE1265A41CDCCCCCC22DF234100000060E3265A41000000006BDE234166666646E9265A413333333326DE2341000000A0FA265A4166666666E9DD2341333333B3FD265A4166666666E9DD2341333333B3FD265A41	01010000206A0800002E743FFC6AE02341CCCCCCCC38275A41	940030105	H	Jean-Macé 2	9400301	94003	94	11	0
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	01060000206A08000001000000010300000001000000290000003333333356DB23416666668617275A41333333336DDB2341000000C02D275A41333333338EDB2341CDCCCC8C46275A4166666666B8DB2341CDCCCC6C6C275A419A999999DCDB23419A9999597D275A4100000000F6DB23413333339385275A41666666664DDC2341000000E098275A4166666666A8DC234100000000A9275A41000000007FDD234100000020C8275A4133333333DEDD2341000000A0D6275A4133333333DEDD234133333313CF275A41666666660ADE234100000060C8275A41CDCCCCCC85DD234166666666B1275A413333333384DD234166666606AF275A41CDCCCCCC36DE2341333333B395275A416666666652DE2341666666C692275A41333333334DDE2341CDCCCC0C8D275A4166666666AFDE2341000000E094275A4100000000FADE2341000000E09D275A413333333320DF2341000000209D275A419A99999958DF2341333333F3A2275A41CDCCCCCC76DF2341CDCCCC2CA3275A416666666601E02341CDCCCC6C93275A413333333357DF2341CDCCCCAC77275A4100000000B6DF2341666666266E275A41CDCCCCCC45DF23416666668651275A416666666647DF23419A99993949275A41333333332BDF23410000006043275A419A999999D1DE2341333333D327275A4100000000C1DE2341CDCCCC0C24275A4100000000A4DE23419A9999F928275A413333333337DE2341CDCCCC8C2A275A41000000003DDD2341000000E02F275A41CDCCCCCC3DDD23419A99993937275A419A999999C7DC2341CDCCCCCC38275A41CDCCCCCC8EDC2341666666263B275A419A999999B3DB23413333337347275A416666666696DB2341666666A63A275A41333333336DDB23419A99997916275A413333333356DB23416666668617275A413333333356DB23416666668617275A41	01010000206A0800006615B77397DD23419A99997976275A41	940030106	H	Jules Ferry 1	9400301	94003	94	11	0
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	01060000206A080000010000000103000000010000001F0000009A999999CED82341666666063F275A416666666625D923419A99999966275A4133333333B0D9234166666666A8275A4166666666CAD923419A9999F9B3275A419A999999E4DA2341CDCCCC0CA0275A41CDCCCCCCAFDB23410000000091275A419A99999902DC2341000000C088275A419A999999DCDB23419A9999597D275A4166666666B8DB2341CDCCCC6C6C275A41333333338EDB2341CDCCCC8C46275A41333333336DDB2341000000C02D275A413333333356DB23413333339317275A41333333336DDB23419A99997916275A416666666696DB2341666666A63A275A419A999999B3DB23413333337347275A41CDCCCCCC8EDC2341666666263B275A419A999999C7DC2341CDCCCCCC38275A41CDCCCCCC3DDD23419A99993937275A41000000003DDD2341000000E02F275A413333333337DE2341CDCCCC8C2A275A41CDCCCCCC1EDE2341000000E019275A4166666666F1DD23413333337302275A413333333328DD2341666666E608275A41666666661FDD23419A99997904275A41CDCCCCCC05DC23419A9999F909275A410000000035DB2341000000200C275A41CDCCCCCCDEDA23419A9999D91C275A41CDCCCCCCC8DA2341333333531F275A410000000083D92341666666C631275A419A999999CED82341666666063F275A419A999999CED82341666666063F275A41	01010000206A08000024BCCBE25BDA2341000000905D275A41	940030107	H	Jules Ferry 2	9400301	94003	94	11	0
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	01060000206A080000010000000103000000010000002400000066666666CAD923419A9999F9B3275A413333333304DA2341333333B3CE275A41333333333EDA234133333313FA275A419A9999999BD92341333333B3FD275A413333333377D9234133333353F6275A413333333352D92341CDCCCC2CE7275A410000000055D92341333333B3D6275A413333333330D9234166666626D6275A410000000013D92341333333D3CD275A413333333320D9234133333373B5275A41CDCCCCCC07D92341CDCCCCACB6275A419A999999DDD82341000000E0A8275A416666666693D723419A999999B9275A41666666662AD7234166666666B2275A41CDCCCCCCD0D623419A9999B9BE275A419A9999999FD5234166666626BC275A41666666665ED52341CDCCCC6CFE275A4100000000D5D52341333333B31A285A413333333314D623419A9999B92A285A4133333333B0D723419A9999F922285A41000000009CD92341666666C61E285A4133333333CBD92341666666E61D285A419A9999995ADA2341000000603C285A410000000069DA23419A9999792D285A4166666666DBDA2341333333F326285A413333333352DC2341000000200F285A4166666666B1DC2341CDCCCC6C08285A419A999999B8DC23413333331300285A41CDCCCCCCB1DC2341666666E6E4275A416666666645DC23419A9999B9AE275A416666666624DC2341333333539F275A4100000000D9DB2341666666068D275A41CDCCCCCCAFDB23410000000091275A419A999999E4DA2341CDCCCC0CA0275A4166666666CAD923419A9999F9B3275A4166666666CAD923419A9999F9B3275A41	01010000206A080000D7A5E24D66D72341CCCCCCFCE2275A41	940030108	H	Laplace 1	9400301	94003	94	11	0
01060000206A08000001000000010300000001000000630100003333333393392441000000A090225A4166666666B63924410000000093225A4166666666D3392441CDCCCC4C95225A4100000000ED3924410000006097225A4100000000083A2441CDCCCC6C99225A419A9999992F3A24419A9999999B225A4100000000493A2441333333F39D225A41666666667B3A244166666606A2225A4100000000863A2441000000E0A2225A4166666666013B244133333393AC225A419A999999483B24419A999939B2225A4133333333503B2441CDCCCCCCB2225A41666666665E3B2441CDCCCCECB3225A41666666669B3B24419A9999D9B8225A4166666666C53B244100000080BC225A4166666666CF3B244166666686BD225A4100000000D63B244133333373BE225A4133333333DF3B244100000000C0225A4133333333F13B2441000000C0C1225A4100000000163C2441000000C0C5225A4166666666243C24419A999979C7225A41666666663C3C244133333353CA225A41CDCCCCCC4B3C244133333353CC225A41666666665E3C2441CDCCCCACCE225A4100000000713C24419A9999F9D0225A41CDCCCCCC783C244133333313D2225A41CDCCCCCCB43C2441CDCCCC4CDA225A4100000000CD3C24419A9999B9DD225A4100000000F03C2441666666E6E3225A419A999999353D244133333393EF225A41CDCCCCCC633D2441666666E6F6225A419A9999997B3D24419A9999B9FA225A4100000000F33D2441CDCCCCACF2225A4166666666143E2441CDCCCC6CF0225A4133333333863E244166666606E9225A419A999999FE3E24419A999999E0225A41000000004D3F244133333353DB225A41CDCCCCCC703F2441666666E6D8225A41CDCCCCCC713F24419A9999D9D8225A41CDCCCCCCA43F2441CDCCCC6CD5225A41666666660340244166666606CF225A41CDCCCCCC6540244100000060C8225A4133333333C040244166666646C2225A4166666666D14024419A9999B9C5225A4166666666DE402441333333D3C7225A419A999999E740244133333373C9225A4133333333F340244166666686CB225A4166666666FD40244166666666CD225A41000000000941244100000080CF225A410000000026412441000000C0CD225A419A9999992B412441CDCCCC6CCD225A41CDCCCCCC574124419A9999B9CA225A41333333338141244133333333C8225A419A9999998341244100000080C8225A416666666694412441CDCCCCACCA225A419A999999964124419A9999F9CA225A419A999999A2412441CDCCCC8CCC225A4133333333B141244100000060CE225A4166666666D5412441666666C6D2225A4133333333EC422441CDCCCC2CC9225A4133333333D942244100000040C6225A41CDCCCCCCBF422441CDCCCC4CC2225A41CDCCCCCCA142244133333393BD225A410000000091422441333333B3BA225A41333333336D42244133333353B4225A413333333361422441000000C0B1225A41666666665A42244166666686B0225A410000000056422441CDCCCC2CAF225A41000000005142244133333353AD225A41000000004D4224419A999979AB225A419A9999994A422441000000C0A9225A419A99999948422441CDCCCCECA7225A41CDCCCCCC46422441CDCCCCCCA5225A419A999999444224419A9999D9A1225A413333333342422441CDCCCC0C9E225A419A9999993F422441666666069A225A41000000003D4224416666660695225A41666666663A4224419A9999D98E225A413333333336422441CDCCCCAC86225A41CDCCCCCC324224416666662680225A41CDCCCCCC32422441666666467F225A41CDCCCCCC33422441000000007E225A413333333335422441000000E07C225A419A99999934422441000000E07B225A4166666666344224419A9999197B225A419A999999334224419A9999197A225A419A999999324224410000006079225A410000000031422441333333B378225A41CDCCCCCC2E4224419A9999D977225A419A9999992D422441000000A076225A41333333332D4224419A99997975225A41666666662B422441000000C073225A413333333326422441666666C66F225A416666666621422441000000C06C225A41333333331C422441CDCCCC8C69225A410000000015422441CDCCCC2C65225A419A9999990A422441333333D35F225A419A999999FE412441CDCCCC2C5A225A419A999999F24124419A99999955225A4166666666E4412441CDCCCC6C50225A4100000000C44124410000006045225A41CDCCCCCCC04124419A99999944225A41CDCCCCCCBE4124419A9999F943225A419A999999BD412441333333D342225A4100000000BE412441CDCCCCEC41225A4133333333BF412441000000E040225A419A999999C2412441666666C63F225A4166666666C9412441333333933D225A41CDCCCCCCCD412441666666E63B225A41CDCCCCCCD04124419A9999593A225A4133333333D2412441666666A638225A419A999999D1412441CDCCCCEC36225A4166666666D0412441CDCCCCAC34225A419A999999C7412441000000E033225A41CDCCCCCCC2412441CDCCCCEC32225A4133333333C0412441CDCCCCCC31225A4100000000C0412441CDCCCC8C30225A4166666666C2412441000000602F225A4100000000C2412441000000202E225A419A999999BF4124419A9999192D225A4133333333B7412441333333B32B225A4100000000AF412441333333332A225A41CDCCCCCCA84124410000000029225A4133333333A24124410000008027225A41CDCCCCCC7C412441CDCCCC6C1E225A41333333336F412441000000001B225A419A999999614124419A9999D917225A419A999999554124416666662615225A41CDCCCCCC49412441CDCCCC0C13225A41000000003C412441CDCCCCEC10225A419A9999992D412441CDCCCCEC0E225A41000000001E412441CDCCCC0C0D225A419A9999990F4124419A9999590B225A4166666666004124413333339309225A419A999999F54024419A9999F907225A4100000000CD4024419A9999790D225A4133333333B94024413333331310225A41CDCCCCCCA5402441666666E612225A41CDCCCCCC974024413333337315225A4100000000954024410000000016225A41CDCCCCCC8A4024413333337318225A413333333382402441CDCCCCEC17225A419A9999997B402441CDCCCC2C17225A4166666666754024413333339315225A416666666673402441CDCCCC0C14225A419A99999970402441CDCCCC0C0F225A41666666666F402441CDCCCC0C0D225A41CDCCCCCC6B402441333333130B225A4100000000664024413333333309225A41CDCCCCCC5E402441CDCCCC4C07225A416666666658402441000000A005225A419A99999950402441666666E603225A419A99999941402441CDCCCC0C01225A41000000003840244100000060FF215A41000000002C402441000000A0FD215A41CDCCCCCC14402441CDCCCCCCFA215A419A999999FA3F244166666606F8215A41CDCCCCCCD93F2441000000A0F4215A4133333333C93F244166666606F6215A4166666666C33F244100000040F6215A4166666666BE3F244133333353F6215A41CDCCCCCCB43F244133333353F6215A4133333333AC3F244166666626F6215A41333333339B3F2441CDCCCC6CF5215A4100000000823F244166666666F4215A41333333337B3F24419A999979F5215A41CDCCCCCC773F244133333353F6215A4166666666753F244100000020F7215A4100000000733F2441CDCCCC4CF8215A419A9999996F3F244133333373FA215A4133333333573F2441CDCCCC8C06225A4100000000563F24413333333307225A4166666666523F2441CDCCCCEC07225A419A9999994D3F24410000008008225A419A999999473F2441666666E608225A419A999999403F24416666660609225A4166666666373F24419A9999F908225A41000000002C3F2441333333B308225A41333333331C3F24416666664608225A41CDCCCCCCEF3E24419A99991907225A4166666666E53E24416666666607225A419A999999C63E24410000002008225A419A999999BD3E24419A99997908225A4133333333B73E2441CDCCCC2C09225A419A999999AD3E2441666666E60A225A4100000000A23E2441000000C00D225A4133333333893E2441CDCCCC2C12225A41CDCCCCCC7D3E2441CDCCCC4C14225A4166666666783E24419A99997915225A4133333333753E2441CDCCCCAC16225A4133333333743E2441CDCCCC4C18225A4166666666713E2441000000801F225A419A999999733E24410000004020225A419A9999997A3E24419A99991921225A41CDCCCCCC853E2441CDCCCCCC21225A41CDCCCCCCD93E24410000000024225A4133333333373F24410000008026225A419A999999613F24419A99999927225A4133333333593F24419A9999592E225A4133333333593F2441CDCCCC6C2F225A41000000005D3F2441000000E031225A41333333335D3F2441CDCCCC2C33225A41333333335B3F24410000006034225A4133333333553F24413333331336225A41CDCCCCCC4B3F24416666668637225A41666666663F3F24419A99993938225A4166666666323F24419A99997938225A41CDCCCCCC193F2441CDCCCC6C38225A4100000000103F2441000000C038225A41CDCCCCCC063F2441CDCCCC2C39225A4100000000003F2441CDCCCC0C3A225A41CDCCCCCCFC3E2441333333333B225A419A999999BB3E24416666666639225A41CDCCCCCC943E24410000004038225A4133333333843E24419A9999F937225A41CDCCCCCC7C3E2441CDCCCC8C38225A419A999999783E24410000002039225A419A999999753E2441666666263A225A41666666666C3E2441333333B340225A41000000007A3E2441333333D342225A41CDCCCCCC863E2441666666A644225A4133333333833E2441333333934B225A41666666667B3E2441000000E04B225A4133333333763E2441666666264D225A4100000000743E2441000000804E225A4166666666753E2441CDCCCCEC4F225A419A9999997A3E2441666666E651225A4133333333803E2441CDCCCC6C53225A41CDCCCCCC883E24410000000055225A419A999999923E24413333333356225A41333333339B3E24410000004057225A41CDCCCCCCA63E24419A99991958225A4100000000B13E24416666668658225A4166666666BB3E24419A9999B958225A419A999999C43E24413333339358225A419A999999CF3E2441CDCCCC6C58225A4133333333D73E24410000006058225A4133333333DB3E24419A99997958225A4133333333E13E2441333333D358225A4166666666EB3E2441333333535A225A4100000000F43E2441666666265B225A4166666666FC3E24419A9999995C225A4166666666013F24419A9999F95D225A4100000000063F2441CDCCCC8C5F225A4133333333063F2441333333D360225A419A999999023F2441CDCCCC4C63225A41CDCCCCCCFE3E24410000000065225A41CDCCCCCCF83E2441CDCCCCCC66225A4100000000F73E24416666660667225A4133333333E93E2441000000A068225A419A999999DB3E2441CDCCCC4C6A225A4133333333CE3E2441000000006C225A419A999999C03E2441CDCCCCAC6D225A419A999999B33E2441CDCCCC4C6F225A419A999999A63E24419A9999D970225A419A999999993E24419A99995972225A41CDCCCCCC8B3E2441333333D373225A41666666667D3E24410000004075225A41CDCCCCCC6E3E2441666666A676225A4166666666603E24410000000078225A4166666666523E24413333335379225A4166666666453E2441CDCCCCAC7A225A419A999999393E2441CDCCCC0C7C225A41CDCCCCCC2E3E2441666666667D225A4133333333243E24419A9999B97E225A4166666666193E24419A99991980225A419A9999990E3E24410000008081225A4100000000063E24413333339382225A41CDCCCCCCF03D24410000000082225A4133333333D93D24410000004081225A4100000000CE3D2441CDCCCCCC80225A41CDCCCCCCC33D2441000000E07F225A4100000000BB3D2441333333537F225A419A999999B23D2441CDCCCCCC7E225A4166666666B03D2441333333737E225A4133333333AE3D2441000000407E225A4133333333AB3D2441CDCCCC0C7E225A4100000000A83D2441333333F37D225A419A9999999E3D2441333333337D225A4100000000963D2441CDCCCC4C7C225A419A9999998E3D2441666666267B225A419A999999873D2441000000C079225A41CDCCCCCC7F3D24419A99991978225A419A999999773D24416666664676225A419A9999996E3D24413333335374225A4166666666653D2441CDCCCC4C72225A41CDCCCCCC5B3D24410000004070225A4166666666523D2441CDCCCC4C6E225A419A999999483D2441333333736C225A41000000003E3D2441000000C06A225A4166666666323D24410000002069225A4133333333283D24413333335367225A419A9999991D3D2441666666C665225A41CDCCCCCC173D2441000000A064225A419A9999990B3D2441CDCCCC4C62225A41CDCCCCCCFE3C2441333333F35F225A41CDCCCCCCF13C2441000000A05D225A41CDCCCCCCE43C2441CDCCCC4C5B225A4133333333D73C2441333333F358225A41CDCCCCCCC93C2441666666A656225A41CDCCCCCCBC3C24413333337354225A4133333333B03C24410000006052225A41333333339E3C2441666666A64F225A419A9999999C3C24419A9999194E225A41666666668D3C2441666666464B225A4133333333803C24413333333349225A41CDCCCCCC663C24416666666645225A4133333333623C2441666666A644225A419A999999583C24419A99993943225A41666666664D3C2441000000A041225A41CDCCCCCC433C24419A99999940225A419A9999993B3C2441CDCCCCAC3F225A419A999999373C24419A9999193F225A41000000002D3C24419A9999993D225A419A9999992D3C2441666666063D225A41000000002D3C2441666666463C225A419A9999992B3C2441CDCCCC8C3B225A4133333333283C2441333333F33A225A419A999999243C2441666666863A225A41CDCCCCCC1F3C2441333333133A225A41000000001A3C2441333333D339225A4133333333123C2441CDCCCC4C36225A41CDCCCCCC0D3C24419A9999D933225A41CDCCCCCC093C24416666660631225A4100000000073C2441666666862E225A4166666666043C2441CDCCCC0C2C225A41CDCCCCCC023C2441CDCCCC0C2A225A419A999999023C24410000000028225A419A999999023C24416666664626225A41CDCCCCCC033C2441CDCCCC6C22225A41CDCCCCCC053C2441333333D31F225A4166666666093C2441CDCCCC0C1D225A41000000000E3C2441333333331A225A4133333333153C2441666666E616225A41666666661D3C24419A9999B913225A41CDCCCCCC2A3C2441666666060F225A41CDCCCCCC2E3C2441000000E00D225A41CDCCCCCC373C2441333333730B225A4100000000413C24413333331309225A4166666666323C24419A9999F907225A41666666662C3C24416666668607225A419A999999213C24410000000005225A41CDCCCCCC033C2441000000600B225A419A9999991D3B2441CDCCCC4C3D225A4166666666FB3A2441CDCCCC0C44225A419A999999EA3A24410000002047225A41CDCCCCCCD83A2441333333934A225A41CDCCCCCCB03A24413333335352225A41666666667B3A2441000000605D225A4166666666513A24413333337366225A4100000000183A24419A99993973225A4100000000F03924419A9999D97B225A4100000000DF392441333333D37F225A41CDCCCCCC9E392441000000C08D225A413333333393392441000000A090225A41	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	01010000206A080000720A5E4E4B4024410000004077225A41	940040101	H	Les Hautes Varennes	9400401	94004	94	11	1
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	01060000206A08000001000000010300000001000000280000009A999999023C24416666664626225A41CDCCCCCC093C24416666660631225A41000000001A3C2441333333D339225A41666666668D3C2441666666464B225A41333333339E3C2441666666A64F225A419A999999483D2441333333736C225A419A9999998E3D2441666666267B225A4100000000CE3D2441CDCCCCCC80225A4100000000063E24413333339382225A419A999999393E2441CDCCCC0C7C225A41CDCCCCCC8B3E2441333333D373225A41CDCCCCCCF83E2441CDCCCCCC66225A4100000000063F2441CDCCCC8C5F225A4133333333E13E2441333333D358225A41333333339B3E24410000004057225A4100000000743E2441000000804E225A41CDCCCCCC863E2441666666A644225A41666666666C3E2441333333B340225A4133333333843E24419A9999F937225A41CDCCCCCCFC3E2441333333333B225A41CDCCCCCC063F2441CDCCCC2C39225A41CDCCCCCC4B3F24416666668637225A41333333335B3F24410000006034225A419A999999613F24419A99999927225A41CDCCCCCC853E2441CDCCCCCC21225A4166666666713E2441000000801F225A41CDCCCCCC7D3E2441CDCCCC4C14225A41666666662C3E2441000000E010225A4133333333963D2441666666460C225A4166666666483D24419A99991907225A4100000000233D24416666664602225A4100000000123D244133333313FA215A41CDCCCCCC1C3D2441333333D3F2215A4100000000D03C244100000040F3215A41CDCCCCCCA13C244133333393EA215A419A999999213C24410000000005225A4100000000413C24413333331309225A4133333333153C2441666666E616225A419A999999023C24416666664626225A419A999999023C24416666664626225A41	01010000206A0800000EA8BAA9B13D24419A9999E936225A41	940040102	H	Rostand	9400401	94004	94	11	0
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	01060000206A080000010000000103000000010000002B000000CDCCCCCCA13C244133333393EA215A4100000000D03C244100000040F3215A41CDCCCCCC1C3D2441333333D3F2215A4100000000123D244133333313FA215A4100000000233D24416666664602225A4166666666483D24419A99991907225A4133333333963D2441666666460C225A41666666662C3E2441000000E010225A41CDCCCCCC7D3E2441CDCCCC4C14225A4133333333B73E2441CDCCCC2C09225A41CDCCCCCCEF3E24419A99991907225A4166666666373F24419A9999F908225A4100000000563F24413333333307225A4166666666753F244100000020F7215A4100000000823F244166666666F4215A4133333333AC3F244166666626F6215A41CDCCCCCCD93F2441000000A0F4215A41CDCCCCCC14402441CDCCCCCCFA215A419A99999950402441666666E603225A41666666666F402441CDCCCC0C0D225A416666666673402441CDCCCC0C14225A41CDCCCCCC8A4024413333337318225A41CDCCCCCCA5402441666666E612225A419A999999F54024419A9999F907225A410000000028412441CDCCCCACFF215A4166666666594124419A9999B9F1215A41CDCCCCCC5B41244133333393EC215A41CDCCCCCC3A4124419A999979EC215A4133333333F04024419A9999B9E5215A4166666666A4402441CDCCCCACC9215A41333333330C402441CDCCCCCC95215A419A9999998E402441CDCCCC0C8C215A419A99999927402441000000A07E215A4100000000F13F2441CDCCCC8C7C215A4166666666D03E2441666666E674215A41CDCCCCCC6F3E2441CDCCCC4C71215A41666666664E3E2441CDCCCCEC86215A41333333332B3E2441333333F3A0215A4166666666113E2441CDCCCCCCA4215A41666666661C3D2441000000E0D8215A4166666666003D244133333353D7215A41CDCCCCCCA13C244133333393EA215A41CDCCCCCCA13C244133333393EA215A41	01010000206A0800000B0C0C4C0E3F2441000000B0BD215A41	940040103	H	Prévert	9400401	94004	94	11	0
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	01060000206A0800000100000001030000000100000019000000CDCCCCCC313E2441CDCCCC2C6F215A4166666666D03E2441666666E674215A4100000000F13F2441CDCCCC8C7C215A419A99999927402441000000A07E215A419A9999998E402441CDCCCC0C8C215A41333333330C402441CDCCCCCC95215A4166666666A4402441CDCCCCACC9215A4133333333F04024419A9999B9E5215A41CDCCCCCC3A4124419A999979EC215A41CDCCCCCC5B41244133333393EC215A41000000005D41244166666626CE215A41CDCCCCCC6F4124419A999979BF215A41333333338B412441333333D3B5215A413333333360432441333333B336215A41CDCCCCCC74422441CDCCCCCC15215A4100000000D7412441333333D305215A41000000001F40244100000020E2205A419A9999994D3F2441CDCCCCCC0E215A419A9999990C3F24419A9999792B215A4166666666713E24413333337324215A41CDCCCCCC613E2441CDCCCC6C3F215A4100000000633E24419A9999B951215A4100000000733E24413333331352215A41CDCCCCCC313E2441CDCCCC2C6F215A41CDCCCCCC313E2441CDCCCC2C6F215A41	01010000206A080000954D7E1B7A402441000000C066215A41	940040104	H	Savreau	9400401	94004	94	11	0
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	01060000206A08000001000000010300000001000000300000009A999999F54024419A9999F907225A419A999999554124416666662615225A41CDCCCCCCA84124410000000029225A419A999999BF4124419A9999192D225A4133333333D2412441666666A638225A41CDCCCCCCBE4124419A9999F943225A419A999999FE412441CDCCCC2C5A225A413333333326422441666666C66F225A41CDCCCCCC324224416666662680225A419A99999948422441CDCCCCECA7225A41666666665A42244166666686B0225A41CDCCCCCCA142244133333393BD225A4133333333EC422441CDCCCC2CC9225A419A999999A843244100000000C2225A419A99999988452441CDCCCC6CBC225A4133333333A4462441CDCCCCCCC2225A41CDCCCCCC32472441000000A0C7225A41CDCCCCCCE7472441666666E6B1225A419A9999995148244133333393A4225A413333333358492441000000E084225A4133333333B94A24419A9999795C225A4100000000764C2441333333333C225A41CDCCCCCCCC4C24419A99995936225A41CDCCCCCCB64C2441CDCCCCEC2B225A41CDCCCCCC844C24419A99997924225A4166666666174B244100000040F3215A4100000000E84A2441CDCCCCECE9215A4133333333C34A2441000000A0E8215A41CDCCCCCCC04A244100000080E3215A419A9999995E4A24419A999999DB215A419A999999FE49244133333353CE215A4133333333224824419A9999398A215A4166666666794724419A99993971215A413333333386462441000000004E215A41333333333A462441CDCCCC8C42215A4100000000A44524416666662629215A41666666666C442441CDCCCCECFE205A41333333334A4424419A999959FB205A41333333335C442441CDCCCCEC06215A419A999999874324419A9999193C215A413333333360432441333333B336215A41333333338B412441333333D3B5215A41CDCCCCCC6F4124419A999979BF215A41CDCCCCCC5F412441CDCCCCCCC8215A4166666666594124419A9999B9F1215A410000000028412441CDCCCCACFF215A419A999999F54024419A9999F907225A419A999999F54024419A9999F907225A41	01010000206A0800000C34080B0146244133333333E2215A41	940040105	H	Le Centre	9400401	94004	94	11	2
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	01010000206A080000EC2A366CA04F2441CCCCCCACA4205A41	940040106	H	Bois Clary	9400401	94004	94	11	6
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	01010000206A080000A0C98B0815322441000000E066245A41	940110102	H	Centre Ancien	9401101	94011	94	11	0
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	01010000206A0800000A720ABD383A2441CCCCCC7CF3235A41	940110101	A	Zone d'Activités	9401101	94011	94	11	4
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	01060000206A080000010000000103000000010000002A0000009A999999592D24419A9999590E245A41CDCCCCCC8F2D24416666668611245A4133333333D62D24416666660619245A41000000002E2E2441CDCCCC0C25245A41333333331A2F24419A9999593C245A41666666668D2E2441CDCCCC6C58245A4133333333032F24410000008063245A4133333333023024419A9999B97C245A416666666652302441CDCCCCAC72245A4100000000B13024413333335365245A410000000043312441000000204C245A4166666666AD312441666666A63C245A4133333333AA322441333333331D245A413333333341332441CDCCCC4C30245A4133333333EE3324419A99995910245A4166666666DA32244133333313F9235A41CDCCCCCCFD322441CDCCCC0CF3235A4100000000E33224419A9999B9ED235A419A999999EC3224419A9999F9E9235A419A9999993333244133333313DE235A416666666630332441666666E6DA235A419A99999967322441CDCCCCACCA235A41000000007D31244100000060F6235A419A999999DF3024419A999919E2235A41000000005531244133333393CD235A419A999999B83124419A999959BD235A419A999999D43124419A9999D9BA235A4166666666193224419A9999D9AC235A41666666660B322441CDCCCCCCA9235A4133333333293124419A99993996235A41000000000F3124410000002092235A419A99999902312441CDCCCCEC94235A41CDCCCCCCF92F2441CDCCCC8CC4235A4133333333302F2441000000C0AA235A4133333333BD2E244166666626C4235A41666666666F2E244133333373BF235A41CDCCCCCC9A2D2441666666A6E5235A4100000000C92D2441CDCCCCACE7235A4133333333AA2D24419A999959EE235A419A999999C72D244166666646F0235A419A999999592D24419A9999590E245A419A999999592D24419A9999590E245A41	01010000206A08000012B407F578302441CCCCCCCC06245A41	940110103	H	Haut Bonneuil	9401101	94011	94	11	0
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	01060000206A08000001000000010300000001000000150000009A9999993A35244133333373D2235A419A9999993D35244166666606D5235A41333333339F352441666666C6E9235A419A9999990E3624410000006000245A4133333333F0362441CDCCCCCCF8235A4133333333F73624410000008006245A419A9999990A3724413333333315245A4133333333C9372441333333D30F245A41CDCCCCCC25382441666666A609245A41CDCCCCCC05382441CDCCCC6CFD235A4100000000C937244100000060C1235A419A999999B5372441000000E0B7235A41666666667737244166666686A8235A419A99999909372441000000609A235A4100000000D53624419A99991995235A41666666669C3624416666664694235A41CDCCCCCC5B362441333333939D235A4100000000A735244100000080BF235A413333333393352441000000E0C1235A419A9999993A35244133333373D2235A419A9999993A35244133333373D2235A41	01010000206A080000D65BA2E18B362441CCCCCCBCD3235A41	940110104	H	Cité Fabien	9401101	94011	94	11	0
01060000206A08000001000000010300000001000000390000009A99999967322441CDCCCCACCA235A41666666668D32244100000080CD235A4166666666C1322441000000C0D1235A41CDCCCCCCF33224419A9999D9D5235A419A99999918332441000000E0D8235A416666666630332441666666E6DA235A410000000034332441CDCCCCECDB235A41000000003533244100000000DD235A419A9999993333244133333313DE235A41666666662D33244133333353DF235A419A999999EC3224419A9999F9E9235A4133333333E632244166666626EB235A419A999999E13224419A999959EC235A4133333333E1322441CDCCCC0CED235A4100000000E33224419A9999B9ED235A4166666666EB322441666666A6EE235A4166666666F6322441666666A6EF235A41CDCCCCCCFD322441000000A0F0235A4100000000013324419A999979F1235A41333333330133244133333333F2235A41CDCCCCCCFD322441CDCCCC0CF3235A4166666666DA32244133333313F9235A419A9999991A33244133333373FE235A419A99999934332441000000A000245A41CDCCCCCC693324413333333305245A419A9999998F3324416666666608245A419A999999C3332441000000E00C245A4133333333EE3324419A99995910245A41CDCCCCCC0E342441333333330A245A410000000032342441CDCCCC8C03245A419A999999CC342441000000C0E6235A41CDCCCCCC12352441000000E0D9235A419A9999993A35244133333373D2235A41333333333235244100000080D0235A413333333325352441CDCCCCACCE235A4166666666FB3424419A999919CB235A4166666666BF34244100000020C6235A419A9999998734244100000080C1235A41666666666C34244166666666BF235A419A9999992B342441333333F3B9235A4166666666C133244166666626B1235A41333333335D332441333333D3A8235A41333333335133244133333393A7235A41000000004A3324419A999999A6235A419A9999992233244133333393A3235A419A99999921332441666666E6A3235A41666666662033244133333373A4235A41000000002033244133333313A5235A41CDCCCCCC20332441333333B3A5235A41000000002333244100000040A6235A416666666626332441333333B3A6235A41000000001D332441CDCCCC8CA8235A410000000013332441CDCCCC8CAA235A4166666666E1322441000000C0B3235A419A9999999F322441CDCCCCECBF235A41333333337A3224419A999919C7235A419A99999967322441CDCCCCACCA235A41	01060000206A080000010000000103000000010000000F0000009A99999967322441CDCCCCACCA235A416666666630332441666666E6DA235A419A9999993333244133333313DE235A419A999999EC3224419A9999F9E9235A4100000000E33224419A9999B9ED235A41CDCCCCCCFD322441CDCCCC0CF3235A4166666666DA32244133333313F9235A4133333333EE3324419A99995910245A419A9999993A35244133333373D2235A413333333325352441CDCCCCACCE235A41333333335D332441333333D3A8235A419A9999992233244133333393A3235A416666666626332441333333B3A6235A419A99999967322441CDCCCCACCA235A419A99999967322441CDCCCCACCA235A41	01010000206A0800003616EB301D34244133333363DA235A41	940110105	H	Saint-Exupéry	9401101	94011	94	11	0
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	01060000206A080000010000000103000000010000001E0000009A999999DF3024419A999919E2235A41000000007D31244100000060F6235A419A99999967322441CDCCCCACCA235A41666666663B33244133333373A2235A419A9999997F3324413333339396235A4133333333963324419A9999F995235A4133333333563324416666660686235A41CDCCCCCC323324419A9999F978235A419A999999EB322441333333B359235A419A9999998C3224413333331353235A413333333352322441666666E655235A419A99999916322441333333D361235A4166666666AC312441CDCCCCCC74235A419A999999A13124410000000074235A419A99999972312441CDCCCC0C7F235A410000000088312441000000C081235A4100000000DD322441000000E09D235A41CDCCCCCCAA32244100000040A7235A4100000000EA312441333333B397235A4133333333BB312441000000A09D235A41000000001B312441CDCCCCCC8F235A41000000000F3124410000002092235A4133333333293124419A99993996235A41666666660B322441CDCCCCCCA9235A4166666666193224419A9999D9AC235A419A999999D43124419A9999D9BA235A419A999999B83124419A999959BD235A41000000005531244133333393CD235A419A999999DF3024419A999919E2235A419A999999DF3024419A999919E2235A41	01010000206A080000349CC5D32E322441000000C0A4235A41	940110106	H	Salvador Allende	9401101	94011	94	11	0
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	01060000206A080000010000000103000000010000001A00000033333333302F2441000000C0AA235A41CDCCCCCCF92F2441CDCCCC8CC4235A419A99999902312441CDCCCCEC94235A41000000001B312441CDCCCCCC8F235A4133333333BB312441000000A09D235A4100000000EA312441333333B397235A41CDCCCCCCAA32244100000040A7235A4100000000DD322441000000E09D235A410000000088312441000000C081235A419A99999972312441CDCCCC0C7F235A419A999999A13124410000000074235A4166666666AC312441CDCCCCCC74235A419A99999916322441333333D361235A413333333352322441666666E655235A41000000008D322441000000C042235A4166666666943224419A9999993A235A41333333338C322441CDCCCC2C2D235A419A9999996E322441333333732F235A4133333333173224413333337331235A4133333333F8312441CDCCCCCC33235A4166666666483024419A9999F940235A419A999999DC2F2441CDCCCCCC45235A4166666666A43024419A9999D950235A419A999999D02F2441CDCCCCAC83235A4133333333302F2441000000C0AA235A4133333333302F2441000000C0AA235A41	01010000206A0800007AAC4098C23024416666668679235A41	940110107	H	République	9401101	94011	94	11	0
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	01060000206A080000010000000103000000010000002600000033333333D4312441666666A6E9225A41CDCCCCCCEE312441333333D3F2225A4133333333DA3124419A999979FB225A419A999999123224413333331303235A41CDCCCCCC3B322441CDCCCC6C0C235A41CDCCCCCC82322441666666A625235A4166666666943224419A9999993A235A41000000008D322441000000C042235A413333333352322441666666E655235A419A9999998C3224413333331353235A419A999999EB322441333333B359235A41CDCCCCCC323324419A9999F978235A4133333333563324416666660686235A4133333333963324419A9999F995235A419A9999997F3324413333339396235A41666666663B33244133333373A2235A419A9999992233244133333393A3235A41333333335D332441333333D3A8235A419A9999998734244100000080C1235A41000000002C352441666666E6A4235A41CDCCCCCC9D3524413333331390235A413333333396352441000000A08A235A4133333333623424416666662671235A4133333333E53424419A9999B958235A41CDCCCCCC703524416666668664235A41CDCCCCCC923524410000006063235A419A9999992C362441CDCCCC2C47235A41333333334B3624419A99997945235A4166666666BE362441CDCCCC2C2F235A416666666675362441333333F301235A41000000005D3624419A999919FD225A416666666688352441CDCCCC0CF7225A419A9999995D352441000000C0F7225A41CDCCCCCCBE33244166666666ED225A41CDCCCCCC1933244100000000E9225A419A999999543224419A999999E4225A4133333333D4312441666666A6E9225A4133333333D4312441666666A6E9225A41	01010000206A080000DE00136B2F3424416666668650235A41	940110108	H	Fosse aux Moines	9401101	94011	94	11	0
01060000206A0800000100000001030000000100000083000000CDCCCCCCD84524419A9999D9692C5A41CDCCCCCC444624419A999939782C5A419A99999970462441666666467D2C5A419A999999AE462441000000A0832C5A4133333333B34624419A999919842C5A4133333333CD462441CDCCCC6C862C5A4166666666E9462441333333F3882C5A419A9999990B4724419A9999B98B2C5A41CDCCCCCC3047244166666686842C5A41333333333B47244100000080822C5A41666666663C47244166666646822C5A419A9999994047244133333373812C5A410000000068472441333333D3792C5A4166666666944724419A9999D9712C5A41CDCCCCCCEC472441CDCCCCAC612C5A419A99999969482441000000604B2C5A4133333333CE48244100000020392C5A4133333333FE482441CDCCCC6C302C5A4166666666FF482441CDCCCCEC2E2C5A41666666661F49244166666626312C5A41000000008749244100000060382C5A41CDCCCCCC914924419A999959372C5A4133333333B149244166666646352C5A4133333333CE492441666666C6362C5A4166666666084A2441CDCCCCAC392C5A419A9999992E4A2441000000403F2C5A41CDCCCCCC754A24419A9999193F2C5A4100000000CF4A2441CDCCCC4C432C5A41CDCCCCCC084B2441CDCCCCCC452C5A41666666664C4B2441000000C0482C5A4133333333614B2441666666A6422C5A41333333339A4B24419A999999452C5A41000000009D4B2441666666464B2C5A419A999999ED4B2441000000804D2C5A419A999999F54B2441CDCCCC8C4D2C5A419A999999104C2441CDCCCC2C4D2C5A41CDCCCCCC214C2441CDCCCC6C4D2C5A4100000000294C2441000000C04D2C5A4133333333314C2441666666264E2C5A41000000003B4C2441CDCCCC0C4F2C5A41000000003F4C2441CDCCCCEC4D2C5A419A999999414C2441000000404D2C5A4133333333D94C24419A999939262C5A41333333331A4D2441CDCCCC2C152C5A4100000000B94C2441CDCCCC0C132C5A41CDCCCCCC754C24419A999999112C5A4100000000EF4B24419A9999B90E2C5A4133333333A04B2441666666260D2C5A4166666666774B2441333333330C2C5A41CDCCCCCC514B2441333333730B2C5A4100000000F74A2441CDCCCC8C092C5A419A999999E74A244100000020092C5A4100000000DA4A2441000000C0082C5A41666666665F4A24419A999939F52B5A41000000002F4A24419A999999ED2B5A419A999999D649244100000040DF2B5A41CDCCCCCCA3492441CDCCCCCCD72B5A41CDCCCCCCA549244100000080D72B5A419A999999A6492441CDCCCC2CD72B5A4133333333A74924419A999999D62B5A41CDCCCCCCA649244166666606D62B5A419A999999A5492441000000A0D52B5A4100000000A44924419A999959D52B5A41CDCCCCCCA0492441CDCCCC2CD52B5A41CDCCCCCC9E49244166666606D32B5A41333333339B492441666666A6CF2B5A41000000008549244133333333BE2B5A41CDCCCCCC6B4924419A999979AA2B5A41000000004F492441666666C6932B5A4166666666494924419A9999998F2B5A413333333332492441CDCCCC4C7D2B5A413333333321492441333333D36F2B5A41333333331449244100000040662B5A4133333333FB48244133333373522B5A4133333333E9482441333333F3442B5A4166666666E14824419A9999D93E2B5A4166666666D748244133333373372B5A4133333333BE482441CDCCCC6C232B5A419A999999A848244166666646132B5A41000000009A48244166666606072B5A41CDCCCCCC7748244100000020EA2A5A41CDCCCCCC62482441333333F3D92A5A419A9999996148244133333353D62A5A4100000000614824419A999959D42A5A41CDCCCCCC6248244100000060D22A5A41CDCCCCCC6648244100000020D02A5A41333333337048244133333333CC2A5A41666666667048244133333313CB2A5A41000000007048244100000020CA2A5A41000000006F48244133333353C82A5A419A999999734824419A999999C42A5A41CDCCCCCC7548244133333333C32A5A41CDCCCCCC7B48244133333313BE2A5A419A9999997C48244166666686BB2A5A41666666667B4824419A9999F9B82A5A41CDCCCCCC7448244133333393B12A5A41CDCCCCCC72482441666666E6AD2A5A41666666665F482441CDCCCC0CAE2A5A41333333332348244100000080AE2A5A419A99999928482441666666E6B82A5A41666666662648244100000000C22A5A4166666666CC472441666666C6E82A5A41000000008247244100000080FB2A5A41CDCCCCCC59472441333333B3022B5A413333333315462441000000002C2B5A41CDCCCCCCBE45244133333313392B5A419A999999B2452441333333D33B2B5A4166666666A6452441000000403F2B5A41333333339B4524419A999939432B5A419A9999997E452441CDCCCCCC4F2B5A41000000003F45244133333333702B5A410000000016452441CDCCCC4C862B5A4100000000FE442441666666E6942B5A419A999999F7442441CDCCCCEC972B5A4133333333F1442441333333F39A2B5A419A999999B744244100000020BC2B5A41CDCCCCCCA244244133333313CA2B5A41666666668D44244166666666E12B5A41666666668A44244133333373ED2B5A41666666668A442441000000E0F82B5A41CDCCCCCC8E44244133333393052C5A41000000009B4424419A999919122C5A419A999999A8442441000000801C2C5A4166666666B5442441333333F3232C5A4166666666CC442441666666C62E2C5A4100000000E9442441666666263A2C5A410000000009452441CDCCCC0C432C5A419A999999334524419A9999B94C2C5A41CDCCCCCC5D45244100000060552C5A416666666680452441333333535B2C5A41CDCCCCCCD84524419A9999D9692C5A41	01060000206A0800000100000001030000000100000031000000CDCCCCCCD84524419A9999D9692C5A41CDCCCCCC444624419A999939782C5A4133333333B34624419A999919842C5A419A9999990B4724419A9999B98B2C5A410000000068472441333333D3792C5A4133333333FE482441CDCCCC6C302C5A4166666666FF482441CDCCCCEC2E2C5A41000000008749244100000060382C5A4133333333B149244166666646352C5A4166666666084A2441CDCCCCAC392C5A419A9999992E4A2441000000403F2C5A41CDCCCCCC754A24419A9999193F2C5A41666666664C4B2441000000C0482C5A4133333333614B2441666666A6422C5A41333333339A4B24419A999999452C5A41000000009D4B2441666666464B2C5A41000000003B4C2441CDCCCC0C4F2C5A41333333331A4D2441CDCCCC2C152C5A4100000000DA4A2441000000C0082C5A419A999999D649244100000040DF2B5A41CDCCCCCCA3492441CDCCCCCCD72B5A41333333339B492441666666A6CF2B5A413333333321492441333333D36F2B5A419A999999A848244166666646132B5A41CDCCCCCC62482441333333F3D92A5A41CDCCCCCC7B48244133333313BE2A5A41CDCCCCCC72482441666666E6AD2A5A41333333332348244100000080AE2A5A41666666662648244100000000C22A5A4166666666CC472441666666C6E82A5A41000000008247244100000080FB2A5A41CDCCCCCC59472441333333B3022B5A413333333315462441000000002C2B5A41CDCCCCCCBE45244133333313392B5A4166666666A6452441000000403F2B5A419A9999997E452441CDCCCCCC4F2B5A41000000003F45244133333333702B5A4133333333F1442441333333F39A2B5A419A999999B744244100000020BC2B5A41CDCCCCCCA244244133333313CA2B5A41666666668D44244166666666E12B5A41666666668A442441000000E0F82B5A41000000009B4424419A999919122C5A4166666666B5442441333333F3232C5A4100000000E9442441666666263A2C5A410000000009452441CDCCCC0C432C5A41CDCCCCCC5D45244100000060552C5A41CDCCCCCCD84524419A9999D9692C5A41CDCCCCCCD84524419A9999D9692C5A41	01010000206A080000391D43D622472441666666B6A22B5A41	940150101	H	Pépinière	9401501	94015	94	11	1
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	01060000206A08000001000000010300000001000000170000003333333321492441333333D36F2B5A41333333339B492441666666A6CF2B5A41CDCCCCCCA3492441CDCCCCCCD72B5A419A999999D649244100000040DF2B5A4100000000DA4A2441000000C0082C5A41333333331A4D2441CDCCCC2C152C5A419A999999964D244133333313F52B5A41CDCCCCCCF14D244166666646DF2B5A41333333338E4E2441CDCCCC0CB42B5A4100000000614D24419A9999B9A22B5A419A999999034D2441000000E0972B5A41CDCCCCCC274C244133333373662B5A4133333333AF4B2441CDCCCCCC492B5A4166666666894B244166666626432B5A419A9999996B4B24419A9999B9422B5A41CDCCCCCC044B2441000000003B2B5A4133333333EA4A24419A9999F93D2B5A4133333333DE4A2441333333334D2B5A4133333333CA4A2441CDCCCCCC4C2B5A4166666666F0492441666666E65B2B5A4166666666CB4924419A9999F95E2B5A413333333321492441333333D36F2B5A413333333321492441333333D36F2B5A41	01010000206A080000A494E361904B2441CDCCCCECA72B5A41	940150102	H	Carnot	9401501	94015	94	11	0
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	01060000206A0800000100000001030000000100000020000000000000009A48244166666606072B5A419A999999A848244166666646132B5A413333333321492441333333D36F2B5A4166666666CB4924419A9999F95E2B5A4166666666F0492441666666E65B2B5A4133333333CA4A2441CDCCCCCC4C2B5A4133333333DE4A2441333333334D2B5A4133333333EA4A24419A9999F93D2B5A41CDCCCCCC044B2441000000003B2B5A419A9999996B4B24419A9999B9422B5A4166666666894B244166666626432B5A4133333333954B2441666666463C2B5A41CDCCCCCCFA4B244166666606422B5A4100000000514C244133333353442B5A41CDCCCCCC1B4C24419A9999D9302B5A4133333333DC4B2441000000E0102B5A41000000006D4B244166666606D42A5A41333333334A4B244100000080D52A5A41000000003A4B2441333333B3C82A5A41CDCCCCCCD14A244166666626CA2A5A4133333333674A2441333333B3CE2A5A4100000000564A2441333333B3D32A5A4100000000214A244133333333D92A5A41000000002F4A244100000080DF2A5A4166666666C24924419A999959E72A5A419A99999992492441000000C0D82A5A419A99999989492441CDCCCCCCE02A5A419A99999963492441CDCCCCCCF12A5A41666666665149244166666606F72A5A416666666608492441CDCCCC6C002B5A41000000009A48244166666606072B5A41000000009A48244166666606072B5A41	01010000206A0800008739B937524A24419A9999591B2B5A41	940150103	H	Centre Ancien	9401501	94015	94	11	0
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	01060000206A080000010000000103000000010000003A0000009A9999993D402441000000C0502A5A419A999999F34024419A999979472A5A41000000006F412441CDCCCC2C432A5A4100000000F7412441333333F3422A5A419A999999BF422441666666263E2A5A413333333304432441000000203B2A5A4166666666E5432441000000C02D2A5A410000000059442441333333F3292A5A4100000000B94424419A9999192B2A5A41CDCCCCCC8745244100000020382A5A4100000000164624419A9999B9422A5A41CDCCCCCC0D472441000000E05B2A5A410000000080472441333333736C2A5A419A99999920482441000000C0A92A5A41333333332348244100000080AE2A5A41CDCCCCCC72482441666666E6AD2A5A41CDCCCCCC7B48244133333313BE2A5A41CDCCCCCC62482441333333F3D92A5A41000000009A48244166666606072B5A416666666608492441CDCCCC6C002B5A41666666665149244166666606F72A5A419A99999963492441CDCCCCCCF12A5A419A99999989492441CDCCCCCCE02A5A419A99999992492441000000C0D82A5A4166666666C24924419A999959E72A5A41000000002F4A244100000080DF2A5A4100000000214A244133333333D92A5A4100000000564A2441333333B3D32A5A4133333333674A2441333333B3CE2A5A41CDCCCCCCD14A244166666626CA2A5A41000000003A4B2441333333B3C82A5A41333333334A4B244100000080D52A5A41000000006D4B244166666606D42A5A4166666666454B2441CDCCCC0CC02A5A41333333331A4B24419A999939B02A5A4100000000454A2441666666C6792A5A41CDCCCCCCB449244166666626562A5A41CDCCCCCC604924419A999939452A5A4133333333DA482441666666862E2A5A413333333378482441CDCCCCCC1F2A5A416666666626482441CDCCCCEC292A5A4166666666EE462441CDCCCC6C142A5A41CDCCCCCC58462441CDCCCC6C102A5A41CDCCCCCC61452441333333D3062A5A419A999999FE432441CDCCCC2CFB295A4166666666D1432441CDCCCC2C002A5A41CDCCCCCC58432441CDCCCCAC032A5A416666666607432441333333F3072A5A4166666666664224419A999939142A5A41666666664542244100000000182A5A41CDCCCCCC76422441333333F3202A5A41CDCCCCCC1942244166666626272A5A419A99999989412441666666462D2A5A41CDCCCCCCE54024419A999939332A5A4100000000AC4024419A9999193A2A5A410000000073402441333333B3432A5A419A9999993D402441000000C0502A5A419A9999993D402441000000C0502A5A41	01010000206A0800009344E33707492441000000A07F2A5A41	940150104	H	Ferber Leclerc	9401501	94015	94	11	0
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	01060000206A080000010000000103000000010000002F00000033333333434C2441333333336A2B5A4133333333694C2441666666E6742B5A419A999999034D2441000000E0972B5A4100000000614D24419A9999B9A22B5A41333333338E4E2441CDCCCC0CB42B5A41000000002E50244100000040CB2B5A41CDCCCCCCE1512441000000E0E32B5A41000000004B52244166666646C32B5A419A9999996C522441CDCCCCACB52B5A419A9999997952244166666646A22B5A4100000000BA522441000000C0962B5A41CDCCCCCC705324419A9999197E2B5A41666666669A53244100000080752B5A413333333385532441CDCCCCCC6F2B5A4166666666965324419A9999D96A2B5A41CDCCCCCCC853244133333373662B5A419A9999997E542441666666A64E2B5A4100000000B3542441000000E0492B5A41000000001B552441CDCCCC6C4A2B5A419A99999970552441666666663D2B5A419A999999F5542441666666A6342B5A41CDCCCCCC9F542441666666A6312B5A419A999999C6532441333333932E2B5A41333333333C532441CDCCCC2C292B5A419A999999CB522441CDCCCC8C232B5A4133333333E1512441CDCCCCCC162B5A4166666666CB512441CDCCCC8C192B5A41000000009B51244100000040162B5A416666666678512441666666A6162B5A4133333333EA502441CDCCCC2C232B5A4133333333D9502441CDCCCCEC232B5A4133333333305024419A9999993C2B5A4133333333C54F2441CDCCCC4C332B5A419A999999564F2441666666C62F2B5A41666666662A4F2441000000402C2B5A4100000000064F2441CDCCCCEC2C2B5A4166666666DD4E244133333313332B5A41CDCCCCCCF04E244133333353432B5A41CDCCCCCCE94E2441333333334A2B5A419A999999C54E24419A999919572B5A419A999999944E244133333313602B5A41000000004D4E244133333393672B5A4100000000FB4D2441CDCCCC8C6B2B5A41CDCCCCCC9E4D2441333333736C2B5A419A999999624C244133333353672B5A4133333333434C2441333333336A2B5A4133333333434C2441333333336A2B5A41	01010000206A0800005F6CF5BA03502441CDCCCCCC7B2B5A41	940150105	H	La Garenne	9401501	94015	94	11	0
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	01010000206A080000E63110018C4E244100000070AA2A5A41	940150106	H	Les Coteaux	9401501	94015	94	11	1
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	01060000206A0800000100000001030000000100000021000000CDCCCCCC29DE2341333333930B265A410000000022DF23410000000040265A41CDCCCCCC71DF23416666662650265A419A999999E5DF23410000004069265A416666666603E023413333333368265A41CDCCCCCC1DE02341CDCCCC6C6F265A410000000015E02341666666A671265A419A99999933DF23419A99999981265A41000000005DDF2341000000808F265A41000000005EDF2341666666A695265A413333333338DF23419A9999D99E265A41333333337FDF2341CDCCCC2CBA265A4100000000EADF23419A9999F9B6265A413333333346E023419A999999B7265A419A999999C1E02341666666E6B4265A41CDCCCCCC0DE12341CDCCCC2CB1265A41333333334CE123419A999999AB265A4166666666B6E123419A9999B99F265A41CDCCCCCC19E223419A99993971265A413333333320E22341CDCCCC2C62265A41CDCCCCCC08E223413333335354265A4133333333F8E12341666666A642265A41CDCCCCCCE2E12341666666C638265A41000000009AE12341000000A029265A41CDCCCCCC2BE123419A99993911265A419A999999F7E023416666666603265A419A9999993EE02341333333B3D6255A41666666662CE0234133333373D6255A410000000024E02341CDCCCC8CEB255A419A99999948DF2341CDCCCCCCF8255A41666666664FDF2341CDCCCC6CFA255A41CDCCCCCC29DE2341333333930B265A41CDCCCCCC29DE2341333333930B265A41	01010000206A080000D054467EA7E023416666666649265A41	940160104	H	Centre Ville 2	9401601	94016	94	11	0
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	01060000206A08000001000000010300000001000000120000006666666657D62341CDCCCC2C16265A41333333336AD623419A99993920265A416666666619D723416666668671265A419A9999996DD72341666666466E265A41CDCCCCCC0DD82341CDCCCC6C64265A410000000031D82341CDCCCC0C63265A410000000071D82341CDCCCC8C63265A419A9999997BD82341000000E05A265A41CDCCCCCCB8D82341666666665B265A4100000000FDD92341000000C048265A41666666662EDA2341666666E644265A419A99999909DB2341CDCCCC0C38265A410000000085DB23410000000032265A41000000002FDA2341000000A0FD255A41CDCCCCCC89D923419A999939E8255A419A9999995CD9234133333333EA255A416666666657D62341CDCCCC2C16265A416666666657D62341CDCCCC2C16265A41	01010000206A0800003EEF3024EFD823419A9999992B265A41	940160109	H	Pont Royal	9401601	94016	94	11	0
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	01060000206A08000001000000010300000001000000280000000000000085DB23410000000032265A419A99999911DC2341CDCCCC4C47265A4133333333DEDC2341666666C66D265A4100000000FDDC23410000008077265A4100000000F3DC2341CDCCCC6C79265A4166666666D1DC2341666666468B265A41CDCCCCCCD1DC23419A9999F998265A4166666666E9DC234166666666BA265A4100000000F3DC2341CDCCCCCCC2265A419A999999E5DC2341CDCCCC0CD5265A419A999999E1DC23419A999919EB265A4166666666E9DC2341CDCCCC0CF0265A413333333328DD2341666666E608275A4166666666F1DD23413333337302275A4166666666E9DD2341333333B3FD265A413333333326DE2341000000A0FA265A419A99999985DE2341CDCCCC2CE3265A4100000000A6DE234133333373DD265A4166666666F5DE234166666646CB265A419A99999921DF234100000020C4265A419A99999956DF234133333373BE265A4166666666CBDF234100000000B9265A413333333346E023419A999999B7265A4100000000EADF23419A9999F9B6265A41333333337FDF2341CDCCCC2CBA265A413333333338DF23419A9999D99E265A41000000005EDF2341666666A695265A41000000005DDF2341000000808F265A419A99999933DF23419A99999981265A410000000015E02341666666A671265A41CDCCCCCC1DE02341CDCCCC6C6F265A416666666603E023413333333368265A419A999999E5DF23410000004069265A41CDCCCCCC71DF23416666662650265A410000000022DF23410000000040265A41CDCCCCCC29DE2341333333930B265A416666666650DD23419A99999918265A41333333334BDD23410000004017265A410000000085DB23410000000032265A410000000085DB23410000000032265A41	01010000206A080000E03F127C12DE2341333333738A265A41	940160101	H	Centre Ville 1	9401601	94016	94	11	0
01060000206A080000010000000103000000010000001D00000000000000B2D52341CDCCCC0CC7255A41CDCCCCCCBAD52341CDCCCC2CCB255A419A999999C7D5234133333373D2255A416666666657D62341CDCCCC2C16265A41000000006ED623413333337315265A41CDCCCCCCE1D62341666666460E265A410000000020D72341333333D30A265A419A9999993DD723416666662609265A4166666666DDD723416666660600265A4100000000F6D72341666666A6FE255A419A99999986D823419A999979F6255A419A9999995CD9234133333333EA255A41CDCCCCCC89D923419A999939E8255A419A99999961D9234133333333E3255A410000000042D9234100000020DF255A419A999999C0D82341333333B3CE255A4133333333A3D82341333333F3CA255A419A99999989D82341333333B3C7255A419A999999FED7234166666606B6255A4100000000CAD723419A9999B9AF255A4166666666B5D723419A999939AD255A41CDCCCCCCA1D723419A999959AB255A416666666671D72341000000E0AD255A41CDCCCCCC38D723419A9999F9B0255A4133333333C1D6234166666686B7255A41CDCCCCCCB5D62341CDCCCC2CB8255A410000000047D6234133333393BE255A419A999999BCD523419A999979C6255A4100000000B2D52341CDCCCC0CC7255A41	01060000206A080000010000000103000000010000000A00000000000000B2D52341CDCCCC0CC7255A419A999999C7D5234133333373D2255A416666666657D62341CDCCCC2C16265A419A9999995CD9234133333333EA255A41CDCCCCCC89D923419A999939E8255A419A999999FED7234166666606B6255A41CDCCCCCCA1D723419A999959AB255A4133333333C1D6234166666686B7255A4100000000B2D52341CDCCCC0CC7255A4100000000B2D52341CDCCCC0CC7255A41	01010000206A080000F1ECC8519CD723419A999929E1255A41	940160102	H	Cité Jardins	9401601	94016	94	11	0
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	01060000206A080000010000000103000000010000002F000000000000006BDE234166666646E9265A41CDCCCCCC22DF234100000060E3265A41CDCCCCCCECDF2341CDCCCCECE1265A410000000098E023419A9999F9DC265A4100000000C7E02341666666A6DA265A41CDCCCCCCC4E1234100000060C9265A41CDCCCCCCFDE1234100000040C6265A41CDCCCCCC88E2234166666646EF265A416666666698E2234166666646F2265A410000000075E3234166666686E0265A41CDCCCCCCB3E3234100000000DC265A41000000002EE42341333333D3CF265A41333333336EE4234166666606BE265A41CDCCCCCC9CE4234100000060AD265A41CDCCCCCCB1E42341333333B3A3265A41CDCCCCCCC9E423419A99997992265A41CDCCCCCCD3E42341666666867C265A4100000000C8E423416666662667265A419A9999996AE42341333333D31F265A41CDCCCCCC5DE42341333333130F265A410000000007E42341CDCCCC4C18265A4133333333D2E32341000000E0E9255A419A999999B1E32341333333D3EB255A410000000012E32341666666061D265A4100000000ADE223413333339323265A410000000078E22341CDCCCCEC1C265A410000000003E223416666668611265A41CDCCCCCC04E223413333331317265A41CDCCCCCC37E223419A99995923265A413333333357E22341000000E02F265A41CDCCCCCCE2E12341666666C638265A4133333333F8E12341666666A642265A41CDCCCCCC08E223413333335354265A413333333320E22341CDCCCC2C62265A41CDCCCCCC19E223419A99993971265A4166666666B6E123419A9999B99F265A41333333334CE123419A999999AB265A41CDCCCCCC0DE12341CDCCCC2CB1265A419A999999C1E02341666666E6B4265A41CDCCCCCC26E0234133333373B8265A4166666666CBDF234100000000B9265A419A99999956DF234133333373BE265A419A99999921DF234100000020C4265A4166666666F5DE234166666646CB265A4100000000A6DE234133333373DD265A41000000006BDE234166666646E9265A41000000006BDE234166666646E9265A41	01010000206A080000BA911BC975E32341CDCCCC9C6D265A41	940160103	H	Coteau 1	9401601	94016	94	11	0
01060000206A080000010000000103000000010000006C00000066666666DBDE2341666666465A255A419A9999990EDF23419A9999F96C255A413333333347DF2341CDCCCC6C83255A41CDCCCCCCA0DF234133333373AA255A4133333333C5DF2341666666A6B7255A41CDCCCCCCCEDF23419A999919BC255A4133333333D9DF234166666626BF255A4133333333E8DF2341666666C6C2255A416666666608E023419A9999F9C9255A419A99999918E02341333333D3CD255A416666666621E02341CDCCCCCCCF255A419A9999992EE023419A9999F9D0255A41000000002DE0234100000040D5255A41666666662CE0234133333373D6255A419A9999993EE02341333333B3D6255A413333333344E02341CDCCCC0CD8255A419A9999994AE023419A999999D9255A416666666654E02341000000E0DB255A41666666666AE02341CDCCCCECE0255A41CDCCCCCC80E0234133333353E6255A410000000087E02341000000C0E7255A419A999999F7E023416666666603265A41CDCCCCCC2BE123419A99993911265A419A9999994AE12341CDCCCC0C18265A413333333388E123419A9999B925265A41000000009AE12341000000A029265A4100000000D7E123419A9999D935265A41CDCCCCCCE2E12341666666C638265A41666666660EE22341000000C035265A41000000001AE223410000000035265A413333333357E22341000000E02F265A416666666655E22341333333132E265A416666666652E223419A9999792B265A410000000048E22341333333B327265A41CDCCCCCC37E223419A99995923265A416666666611E223419A9999191A265A41CDCCCCCC04E223413333331317265A419A99999900E223413333335315265A413333333300E22341666666C613265A410000000003E223416666668611265A419A9999991AE223416666664613265A419A99999932E223419A99999915265A410000000078E22341CDCCCCEC1C265A41333333339DE223419A99999921265A4100000000ADE223413333339323265A4133333333D3E22341CDCCCCCC20265A4133333333EDE22341CDCCCC2C1F265A410000000012E32341666666061D265A41CDCCCCCC26E323419A99991916265A410000000082E3234166666606FA255A419A99999995E3234133333353F4255A41CDCCCCCCA7E3234100000080EE255A419A999999B1E32341333333D3EB255A419A999999BAE323419A9999B9EA255A4133333333D2E32341000000E0E9255A4166666666D0E32341CDCCCC4CE8255A419A999999B7E323419A999959D0255A41CDCCCCCCB4E3234133333393CE255A4100000000B0E32341CDCCCC4CCC255A4100000000ACE32341CDCCCCCCCA255A4133333333A1E32341333333D3C6255A419A99999998E3234100000020C4255A419A99999986E32341CDCCCC2CBE255A419A9999997DE3234100000020BB255A41CDCCCCCC79E32341000000E0B9255A41CDCCCCCC73E32341333333B3B7255A41000000006AE32341CDCCCC8CB4255A41CDCCCCCC58E32341333333B3AE255A416666666651E32341CDCCCC0CAC255A41000000004DE3234166666646AA255A416666666642E32341000000C0A5255A41CDCCCCCC34E32341000000C09E255A410000000026E32341CDCCCC8C96255A41000000001DE32341000000E091255A416666666615E32341333333D38D255A419A99999910E32341666666A68B255A410000000008E323410000006088255A41CDCCCCCCBAE223416666660669255A4166666666A9E223419A99997961255A41666666669BE223419A9999795D255A416666666679E223410000004057255A41000000006AE223416666662652255A41CDCCCCCC0CE22341666666E656255A4166666666F1E123419A99995958255A419A9999999DE12341333333F35B255A416666666678E123419A9999D950255A419A99999965E12341CDCCCCAC4E255A41000000006CE12341CDCCCCEC4C255A413333333320E12341CDCCCC6C35255A410000000013E123416666664631255A4100000000E4E023419A9999F932255A4100000000CDE02341CDCCCCEC33255A4100000000ABE02341CDCCCC4C35255A4166666666A8E023410000004034255A4133333333A5E023413333339332255A41CDCCCCCCCBDF2341000000003D255A41CDCCCCCC4DDF23419A9999B943255A41333333335FDF2341000000E047255A41333333336FDF2341333333934B255A410000000078DF2341666666A64D255A419A99999982DF2341CDCCCC4C50255A410000000072DF23413333335351255A416666666670DF23416666666651255A410000000063DF23416666660652255A41666666665FDF23413333333352255A413333333320DF2341CDCCCC4C55255A413333333324DF2341CDCCCC8C56255A4166666666DBDE2341666666465A255A41	01060000206A080000010000000103000000010000002500000066666666DBDE2341666666465A255A413333333347DF2341CDCCCC6C83255A41CDCCCCCCA0DF234133333373AA255A41CDCCCCCCCEDF23419A999919BC255A416666666621E02341CDCCCCCCCF255A41666666662CE0234133333373D6255A419A9999993EE02341333333B3D6255A419A999999F7E023416666666603265A41CDCCCCCC2BE123419A99993911265A41000000009AE12341000000A029265A41CDCCCCCCE2E12341666666C638265A413333333357E22341000000E02F265A41CDCCCCCC37E223419A99995923265A41CDCCCCCC04E223413333331317265A410000000003E223416666668611265A410000000078E22341CDCCCCEC1C265A4100000000ADE223413333339323265A410000000012E32341666666061D265A419A999999B1E32341333333D3EB255A4133333333D2E32341000000E0E9255A4100000000B0E32341CDCCCC4CCC255A416666666651E32341CDCCCC0CAC255A416666666615E32341333333D38D255A41CDCCCCCCBAE223416666660669255A41666666669BE223419A9999795D255A41000000006AE223416666662652255A419A9999999DE12341333333F35B255A410000000013E123416666664631255A4100000000ABE02341CDCCCC4C35255A4133333333A5E023413333339332255A41CDCCCCCCCBDF2341000000003D255A41CDCCCCCC4DDF23419A9999B943255A419A99999982DF2341CDCCCC4C50255A413333333320DF2341CDCCCC4C55255A413333333324DF2341CDCCCC8C56255A4166666666DBDE2341666666465A255A4166666666DBDE2341666666465A255A41	01010000206A08000053CDBDDF97E123419A999919B6255A41	940160105	H	Coteau 2	9401601	94016	94	11	0
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	01060000206A080000010000000103000000010000001D000000CDCCCCCC3ADB2341000000C062255A41333333334FDB2341333333B36D255A416666666674DB2341000000607C255A4100000000A6DB2341CDCCCCEC8B255A419A999999B4DD2341333333538E255A4166666666C4DD2341000000E08F255A4166666666AADD23419A999959BC255A4100000000A9DD234100000080C3255A419A999999B9DD2341333333D3D4255A413333333315DE2341666666C6CC255A41666666665BDE2341333333F3C3255A416666666696DE2341CDCCCC0CD8255A4166666666DADE23419A999959D0255A41CDCCCCCC24DF23419A999959EA255A41666666665CDF2341666666A6F7255A410000000024E02341CDCCCC8CEB255A419A9999992EE023419A9999F9D0255A416666666621E02341CDCCCCCCCF255A41CDCCCCCCCEDF23419A999919BC255A41CDCCCCCCA0DF234133333373AA255A413333333347DF2341CDCCCC6C83255A4166666666DBDE2341666666465A255A41CDCCCCCCAFDE2341666666865C255A4100000000ABDE2341666666C65F255A410000000054DD2341CDCCCC4C60255A4133333333D5DB23416666664664255A41CDCCCCCCBDDB23419A99993961255A41CDCCCCCC3ADB2341000000C062255A41CDCCCCCC3ADB2341000000C062255A41	01010000206A08000039FCFAB8A5DE2341666666C6A3255A41	940160106	H	La Plaine 1	9401601	94016	94	11	0
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	01060000206A080000010000000103000000010000001200000000000000A6DB2341CDCCCCEC8B255A41CDCCCCCC3CDC2341CDCCCC2CBD255A4133333333CEDC234166666666EE255A416666666650DD23419A99999918265A41666666664FDF2341CDCCCC6CFA255A41666666665CDF2341666666A6F7255A41CDCCCCCC24DF23419A999959EA255A4166666666DADE23419A999959D0255A416666666696DE2341CDCCCC0CD8255A41666666665BDE2341333333F3C3255A413333333315DE2341666666C6CC255A419A999999B9DD2341333333D3D4255A4100000000A9DD234100000080C3255A4166666666AADD23419A999959BC255A4166666666C4DD2341000000E08F255A419A999999B4DD2341333333538E255A4100000000A6DB2341CDCCCCEC8B255A4100000000A6DB2341CDCCCCEC8B255A41	01010000206A0800009D48A15217DD234100000070D1255A41	940160107	H	La Plaine 2	9401601	94016	94	11	0
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	01060000206A0800000100000001030000000100000018000000CDCCCCCCA1D723419A999959AB255A419A999999FED7234166666606B6255A41CDCCCCCC89D923419A999939E8255A41000000002FDA2341000000A0FD255A410000000085DB23410000000032265A41333333334BDD23410000004017265A4133333333CEDC234166666666EE255A41CDCCCCCC3CDC2341CDCCCC2CBD255A416666666674DB2341000000607C255A41333333334FDB2341333333B36D255A419A999999E4DA2341666666E633255A4166666666C8DA23419A99995920255A416666666640DA23410000000020255A410000000018DA23413333339309255A41CDCCCCCCC7D92341666666661B255A419A999999A2D92341CDCCCC6C1E255A419A999999F3D823416666662626255A41333333332FD923416666668641255A4133333333EBD823419A99991944255A419A9999993BD923416666660663255A41CDCCCCCC22D923416666664664255A419A9999995ED923413333335397255A41CDCCCCCCA1D723419A999959AB255A41CDCCCCCCA1D723419A999959AB255A41	01010000206A080000BC4EA82A4FDA2341000000909E255A41	940160108	H	Prairie	9401601	94016	94	11	0
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	01060000206A080000010000000103000000010000001A0000006666666619D723416666668671265A416666666693D72341333333B3AC265A41666666666CD82341333333B311275A41CDCCCCCCA4D82341333333D32C275A419A999999CED82341666666063F275A410000000083D92341666666C631275A41CDCCCCCCC8DA2341333333531F275A41CDCCCCCCDEDA23419A9999D91C275A416666666624DB2341333333D30E275A410000000026DB2341000000A009275A413333333314DB2341CDCCCC4CF6265A41CDCCCCCCF7DA234100000080E7265A419A999999DFDA2341333333B3E2265A41CDCCCCCC4DDA23419A9999D9ED265A419A999999F6D923419A9999B9D9265A4100000000EBD92341CDCCCCCCD0265A41CDCCCCCC85D92341CDCCCC0CA1265A416666666624D923419A9999D9A3265A41CDCCCCCC9DD82341CDCCCC2C75265A410000000075D82341666666C667265A410000000071D82341CDCCCC8C63265A410000000031D82341CDCCCC0C63265A41CDCCCCCC0DD82341CDCCCC6C64265A419A9999996DD72341666666466E265A416666666619D723416666668671265A416666666619D723416666668671265A41	01010000206A0800006A8F7C0AE5D82341343333E3D0265A41	940160110	H	Grange-Ory Lumières 1	9401601	94016	94	11	0
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	01060000206A08000001000000010300000001000000220000000000000071D82341CDCCCC8C63265A410000000075D82341666666C667265A41CDCCCCCC9DD82341CDCCCC2C75265A416666666624D923419A9999D9A3265A41CDCCCCCC85D92341CDCCCC0CA1265A4100000000EBD92341CDCCCCCCD0265A419A999999F6D923419A9999B9D9265A41CDCCCCCC4DDA23419A9999D9ED265A419A999999DFDA2341333333B3E2265A41CDCCCCCCF7DA234100000080E7265A413333333314DB2341CDCCCC4CF6265A410000000026DB2341000000A009275A410000000035DB2341000000200C275A41CDCCCCCC05DC23419A9999F909275A41666666661FDD23419A99997904275A4166666666E9DC2341CDCCCC0CF0265A419A999999E1DC23419A999919EB265A419A999999E5DC2341CDCCCC0CD5265A4100000000F3DC2341CDCCCCCCC2265A4166666666E9DC234166666666BA265A41CDCCCCCCD1DC23419A9999F998265A4166666666D1DC2341666666468B265A4100000000F3DC2341CDCCCC6C79265A4100000000FDDC23410000008077265A4133333333DEDC2341666666C66D265A419A99999911DC2341CDCCCC4C47265A410000000085DB23410000000032265A419A99999909DB2341CDCCCC0C38265A41666666662EDA2341666666E644265A4100000000FDD92341000000C048265A41CDCCCCCCB8D82341666666665B265A419A9999997BD82341000000E05A265A410000000071D82341CDCCCC8C63265A410000000071D82341CDCCCC8C63265A41	01010000206A080000F4E5004BF2DA2341343333F39C265A41	940160111	H	Grange-Ory Lumières 2	9401601	94016	94	11	0
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	01060000206A080000010000000103000000010000001C000000666666666F40244100000000CF295A419A999999B1412441666666C6E0295A41000000002C422441666666A6E6295A419A999999A84224419A999979ED295A41666666665F43244133333313F6295A4166666666BD43244166666646F8295A4166666666F743244166666646F8295A41000000007D442441333333F3F2295A41333333331F46244166666686EE295A41CDCCCCCC6E46244100000000EE295A419A9999994047244100000000EF295A4100000000714724419A999999EE295A41666666663C472441333333D3DB295A41333333332147244100000000C7295A41333333332047244133333313B8295A41666666662F47244100000080A1295A419A9999991447244133333393A6295A419A999999C9462441CDCCCC0CA7295A4100000000B8452441666666E6AC295A419A9999996F44244166666666B5295A4166666666A04324419A9999F9B9295A4166666666AA43244100000040B2295A41000000008B422441CDCCCC2CB8295A4166666666F641244166666646BC295A41333333338941244166666666C0295A419A999999EC40244100000080C7295A41666666666F40244100000000CF295A41666666666F40244100000000CF295A41	01010000206A080000F804703FD6432441333333A3CD295A41	940170701	H	Quatre Cités 1	9401707	94017	94	11	0
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	01060000206A08000001000000010300000001000000290000009A9999990C30244133333333502A5A419A99999926312441CDCCCC4C592A5A41CDCCCCCC25322441CDCCCCAC5D2A5A4133333333F132244166666606622A5A4166666666383424419A9999F9692A5A4166666666DE342441CDCCCC8C692A5A41CDCCCCCC443524419A999979682A5A41333333338A3624419A9999F95C2A5A419A99999920372441333333935B2A5A41666666666E382441666666265C2A5A4100000000193A2441666666C65B2A5A4166666666243A24419A999999412A5A419A999999143A2441666666663C2A5A41CDCCCCCC243A2441000000C0382A5A4166666666283A2441666666262A2A5A4166666666323A244166666646232A5A41666666663F3B244133333333C8295A41666666669D3B244133333333AA295A4100000000A53B244133333313A6295A419A999999FA3A2441666666C69D295A419A999999533B2441CDCCCC4C85295A413333333300382441CDCCCC4C56295A41CDCCCCCCBE3524419A99991937295A4166666666B13524410000000035295A41000000005E3524419A99991930295A41CDCCCCCCD0342441000000602A295A410000000078342441000000E027295A419A999999E83324419A99995928295A419A999999E93324419A9999D929295A41CDCCCCCC70332441000000A02A295A419A99999975332441000000002C295A4100000000C3322441CDCCCC2C53295A419A99999954322441333333136C295A4100000000BF312441CDCCCC6C8C295A41CDCCCCCCF8312441000000A0B5295A41333333339931244133333313B4295A41333333335C3124419A9999B9F1295A4166666666F6302441CDCCCCACF0295A4133333333F33024419A999979FA295A419A9999990C30244133333333502A5A419A9999990C30244133333333502A5A41	01010000206A080000F62C610E56362441CCCCCC5CCE295A41	940170101	H	Tremblay 1	9401701	94017	94	11	1
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	01060000206A080000010000000103000000010000002100000066666666143A2441CDCCCC4C4C2A5A41333333331C3A2441666666E64D2A5A4100000000193A2441666666C65B2A5A4133333333CF3A244166666606592A5A4133333333743B24419A999979572A5A4133333333153C2441CDCCCCEC542A5A4100000000A53C244166666686542A5A4133333333D53C244166666626462A5A419A9999991F3D244166666626342A5A419A999999693D244166666666252A5A4100000000303D244100000080282A5A419A999999C53C2441CDCCCC8C292A5A4166666666D83C244166666626232A5A41333333331F3D244166666626122A5A41CDCCCCCC5E3D2441000000E0062A5A4100000000B43D244166666666FB295A4133333333C73C244166666686F2295A41333333331E3D244100000000D8295A419A9999992A3D244166666646D2295A4166666666683D2441CDCCCC6CA2295A419A999999533B2441CDCCCC4C85295A419A999999FA3A2441666666C69D295A4100000000A53B244133333313A6295A41666666669D3B244133333333AA295A41666666663F3B244133333333C8295A4166666666323A244166666646232A5A4166666666283A2441666666262A2A5A41CDCCCCCC243A2441000000C0382A5A419A999999143A2441666666663C2A5A4166666666243A24419A999999412A5A419A999999213A24419A9999B9492A5A4166666666143A2441CDCCCC4C4C2A5A4166666666143A2441CDCCCC4C4C2A5A41	01010000206A08000012AEBFB3C83B244100000060F1295A41	940170102	H	Tremblay 2	9401701	94017	94	11	0
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	01060000206A080000010000000103000000010000004100000000000000A53C244166666686542A5A41CDCCCCCCD53C244100000080542A5A41CDCCCCCC583D244166666646512A5A41CDCCCCCC973E2441CDCCCCAC442A5A41CDCCCCCCF93E2441CDCCCC6C422A5A419A9999995240244166666686372A5A41CDCCCCCCE54024419A999939332A5A419A99999989412441666666462D2A5A41CDCCCCCC1942244166666626272A5A41CDCCCCCC76422441333333F3202A5A41666666664542244100000000182A5A4166666666664224419A999939142A5A416666666607432441333333F3072A5A41CDCCCCCC58432441CDCCCCAC032A5A4166666666D1432441CDCCCC2C002A5A419A999999FE432441CDCCCC2CFB295A41CDCCCCCC61452441333333D3062A5A41CDCCCCCC58462441CDCCCC6C102A5A4166666666EE462441CDCCCC6C142A5A416666666626482441CDCCCCEC292A5A41CDCCCCCC4C48244100000080242A5A4100000000B3482441666666C6192A5A4166666666DB482441CDCCCC0C1D2A5A4100000000894924419A9999D9302A5A4166666666A84924419A999999322A5A41CDCCCCCCC8492441000000E0302A5A41CDCCCCCC1B4A2441666666E6232A5A4100000000574A2441000000201D2A5A4166666666AB4B244133333373FF295A41CDCCCCCCB64B244100000060FD295A4133333333744B2441CDCCCCECF8295A41666666661E4B2441CDCCCC8CF5295A419A999999C04A2441CDCCCC2CF3295A419A99999939492441000000C0EB295A419A999999BB48244166666646EA295A41666666666748244100000060EA295A413333333398472441CDCCCC4CEE295A419A9999994047244100000000EF295A41CDCCCCCC6E46244100000000EE295A41333333331F46244166666686EE295A41000000007D442441333333F3F2295A4166666666F743244166666646F8295A4166666666BD43244166666646F8295A41666666665F43244133333313F6295A419A999999A84224419A999979ED295A41000000002C422441666666A6E6295A419A999999B1412441666666C6E0295A41333333333D4024419A999939CC295A4100000000FF3D2441666666A6AB295A41CDCCCCCCF73D2441CDCCCC2CAA295A4166666666683D2441CDCCCC6CA2295A419A9999992A3D244166666646D2295A41333333331E3D244100000000D8295A4133333333C73C244166666686F2295A4100000000B43D244166666666FB295A41CDCCCCCC5E3D2441000000E0062A5A41333333331F3D244166666626122A5A4166666666D83C244166666626232A5A419A999999C53C2441CDCCCC8C292A5A4100000000303D244100000080282A5A419A999999693D244166666666252A5A419A9999991F3D244166666626342A5A4133333333D53C244166666626462A5A4100000000A53C244166666686542A5A4100000000A53C244166666686542A5A41	01010000206A080000CE1FA77BD2472441CCCCCC7CFB295A41	940170103	H	Tremblay 3	9401701	94017	94	11	0
01060000206A0800000100000001030000000100000039000000CDCCCCCCD0342441000000602A295A4166666666F83424419A9999D92B295A41000000000C352441CDCCCC8C2C295A41CDCCCCCC18352441333333132D295A410000000036352441666666462E295A41000000005E3524419A99991930295A419A9999997E352441000000E031295A4166666666B13524410000000035295A41CDCCCCCCBE3524419A99991937295A410000000038362441333333733D295A413333333372362441666666A640295A4133333333BF362441333333D344295A419A999999DA3624416666668646295A4166666666FC3624416666666648295A413333333300382441CDCCCC4C56295A41CDCCCCCC3C3824419A9999B959295A4100000000B83824416666668660295A419A999999273924419A99999966295A4166666666433924416666662668295A41000000006F392441333333936A295A41CDCCCCCC8C3924419A9999396C295A41CDCCCCCCB6392441000000806E295A4133333333FF392441CDCCCC6C72295A41CDCCCCCC8D3A2441333333337A295A41333333339E3A24410000006076295A4100000000AE3A24419A9999B972295A41CDCCCCCCCC3A2441000000606B295A4100000000F03A2441000000605C295A41CDCCCCCCF33A2441666666C65A295A41333333330B3B2441CDCCCC0C51295A419A9999991A3B2441333333934A295A41CDCCCCCC453B2441CDCCCC8C38295A41000000004D3B2441666666C635295A419A999999423B24410000008034295A41CDCCCCCC183B2441CDCCCCCC24295A41CDCCCCCC053B2441000000201E295A4133333333EB3A2441333333F313295A41CDCCCCCCE93A24413333335313295A4166666666AB3A24419A9999F9FB285A4166666666843A244133333373ED285A4133333333EB392441000000C0F3285A41CDCCCCCCCA3924419A999919F5285A41CDCCCCCCB0382441CDCCCC6C00295A4166666666333824419A99999905295A41CDCCCCCCC3372441333333530A295A41000000009F372441666666C60B295A419A999999273724416666668610295A419A999999BE362441666666C614295A4133333333B4362441CDCCCC2C15295A416666666635362441000000401A295A4133333333BB352441000000201F295A41333333335F352441333333D322295A41CDCCCCCC353524413333337324295A41CDCCCCCC233524413333339325295A4133333333113524419A99999926295A41CDCCCCCC063524413333333327295A41CDCCCCCCD0342441000000602A295A41	01060000206A080000010000000103000000010000000F000000CDCCCCCCD0342441000000602A295A41000000005E3524419A99991930295A4166666666B13524410000000035295A41CDCCCCCCBE3524419A99991937295A413333333300382441CDCCCC4C56295A41CDCCCCCC8D3A2441333333337A295A41CDCCCCCCCC3A2441000000606B295A41000000004D3B2441666666C635295A419A999999423B24410000008034295A4166666666843A244133333373ED285A41CDCCCCCCB0382441CDCCCC6C00295A41CDCCCCCCC3372441333333530A295A41CDCCCCCC353524413333337324295A41CDCCCCCCD0342441000000602A295A41CDCCCCCCD0342441000000602A295A41	01010000206A080000B0455285693824410000003033295A41	940170201	H	Plant 1	9401702	94017	94	11	0
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	01060000206A080000010000000103000000010000002000000066666666843A244133333373ED285A419A999999423B24410000008034295A41000000004D3B2441666666C635295A41CDCCCCCCCC3A2441000000606B295A41CDCCCCCC8D3A2441333333337A295A41CDCCCCCC7F3B2441000000E087295A4100000000EC3B24419A9999798D295A4100000000013C2441000000C088295A41000000007C3C2441333333B374295A419A9999991C3D2441666666265C295A41333333336E3D24413333339350295A4100000000983E2441666666C624295A419A999999443F24416666666615295A4100000000D6412441333333733E295A41666666663E4224413333339340295A41CDCCCCCC524224416666666638295A41CDCCCCCCBC422441CDCCCC2C1A295A419A999999F5422441000000200D295A4133333333A4432441CDCCCC0CEB285A4100000000A843244166666606E8285A419A9999997A4324419A999919DB285A41CDCCCCCCC9422441000000C0E6285A41000000003342244133333333EA285A41333333334341244133333333ED285A419A99999900412441000000E0F1285A41000000007E402441CDCCCC4CDD285A419A999999FB3F2441333333D3C5285A4133333333B93F2441333333B3B6285A4133333333C73D244166666666CB285A4133333333773C2441CDCCCCECD8285A4166666666843A244133333373ED285A4166666666843A244133333373ED285A41	01010000206A080000D4A805D4E03C24419A99994922295A41	940170202	H	Plant 2	9401702	94017	94	11	0
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	01060000206A080000010000000103000000010000001D00000000000000EC3B24419A9999798D295A41CDCCCCCCF73D2441CDCCCC2CAA295A4100000000FF3D2441666666A6AB295A41666666666F40244100000000CF295A419A999999EC40244100000080C7295A41333333338941244166666666C0295A4166666666F641244166666646BC295A41000000008B422441CDCCCC2CB8295A4166666666AA43244100000040B2295A41CDCCCCCCB543244100000060A9295A41333333332A43244100000080AC295A41CDCCCCCCC742244133333313AD295A41CDCCCCCCB64224419A9999D985295A4166666666F54124419A99999983295A41CDCCCCCCEB412441333333F384295A41CDCCCCCCB6412441CDCCCCAC80295A419A999999D6412441000000A072295A419A999999EA412441000000A064295A419A999999F4412441CDCCCCAC51295A4166666666EF412441CDCCCC6C3F295A4100000000D6412441333333733E295A419A999999443F24416666666615295A4100000000983E2441666666C624295A41333333336E3D24413333339350295A419A9999991C3D2441666666265C295A41000000007C3C2441333333B374295A4100000000013C2441000000C088295A4100000000EC3B24419A9999798D295A4100000000EC3B24419A9999798D295A41	01010000206A0800009827E9753C3F2441CDCCCCAC6F295A41	940170203	H	Plant 3	9401702	94017	94	11	0
01060000206A080000010000000103000000010000002E00000066666666B7332441CDCCCC4CE8285A41CDCCCCCCC8332441CDCCCC2CFE285A4166666666D33324419A9999990C295A419A999999DC332441333333D317295A4133333333E0332441000000A01C295A419A999999E83324419A99995928295A4133333333133424416666662628295A410000000042342441333333F327295A410000000078342441000000E027295A419A9999998E342441CDCCCC4C28295A41CDCCCCCCD0342441000000602A295A41CDCCCCCC063524413333333327295A4133333333113524419A99999926295A41CDCCCCCC233524413333339325295A41CDCCCCCC353524413333337324295A41333333335F352441333333D322295A4133333333BB352441000000201F295A416666666635362441000000401A295A4133333333B4362441CDCCCC2C15295A419A999999BE362441666666C614295A419A999999273724416666668610295A41000000009F372441666666C60B295A41CDCCCCCCC3372441333333530A295A4166666666333824419A99999905295A41CDCCCCCCB0382441CDCCCC6C00295A41CDCCCCCCCA3924419A999919F5285A41000000008A392441333333D3DB285A41333333330A3924419A9999F9A9285A413333333358382441CDCCCC6CAF285A41000000003B382441CDCCCC6CB0285A41666666669A37244166666606B6285A41CDCCCCCC7537244100000040B7285A41666666665E37244100000000B8285A4166666666B536244133333393BD285A413333333336362441666666C6C1285A41333333331036244166666606C3285A4166666666CC35244166666646C5285A4100000000A3352441333333D3C6285A41666666668835244133333393C8285A419A99999914352441CDCCCC6CD0285A419A999999DF342441666666E6D3285A4100000000A034244100000060D8285A41CDCCCCCC823424419A999959DA285A41666666663934244133333353DF285A4133333333D9332441666666E6E5285A4166666666B7332441CDCCCC4CE8285A41	01060000206A080000010000000103000000010000000F00000066666666B7332441CDCCCC4CE8285A419A999999E83324419A99995928295A410000000078342441000000E027295A41CDCCCCCCD0342441000000602A295A41CDCCCCCC353524413333337324295A41CDCCCCCCC3372441333333530A295A41CDCCCCCCB0382441CDCCCC6C00295A41CDCCCCCCCA3924419A999919F5285A41333333330A3924419A9999F9A9285A413333333358382441CDCCCC6CAF285A41666666669A37244166666606B6285A4100000000A3352441333333D3C6285A419A999999DF342441666666E6D3285A4166666666B7332441CDCCCC4CE8285A4166666666B7332441CDCCCC4CE8285A41	01010000206A080000079BF370BB362441343333B3EE285A41	940170301	H	Remise Saint-Maur 1	9401703	94017	94	11	0
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	01060000206A0800000100000001030000000100000024000000CDCCCCCC7A3224419A9999B974285A4100000000CE3224410000000089285A41000000000F3324419A99995997285A410000000089332441CDCCCCCCB7285A41CDCCCCCC9D33244133333313C6285A4166666666B7332441CDCCCC4CE8285A419A999999DF342441666666E6D3285A4100000000A3352441333333D3C6285A41666666669A37244166666606B6285A413333333358382441CDCCCC6CAF285A419A9999993A3924419A999959A8285A4100000000E5382441666666E661285A41CDCCCCCCB43824419A9999B946285A419A9999993B392441CDCCCC6C41285A41CDCCCCCC353A2441666666863A285A4133333333EB3A24419A9999D934285A419A9999993A3C2441000000802C285A4166666666903C2441000000C02A285A419A9999991C3D2441666666462B285A4133333333A43D2441333333B32E285A41666666663C3E24413333339330285A419A9999990E3F2441CDCCCC8C31285A4100000000453F24419A99993931285A41CDCCCCCC963F24419A9999B92E285A4100000000C43F24410000006021285A4100000000DF3E24416666660621285A4166666666C33D2441666666A61E285A41CDCCCCCCA93C24419A9999591D285A41666666664B3C2441CDCCCC4C1E285A41CDCCCCCC5E3B2441CDCCCC2C24285A41000000002A392441CDCCCC4C37285A4133333333D0362441000000C051285A4133333333F73524416666662659285A4133333333C3342441666666065E285A41CDCCCCCC7A3224419A9999B974285A41CDCCCCCC7A3224419A9999B974285A41	01010000206A080000CC596E8FE03524416666668682285A41	940170302	H	Remise Saint-Maur 2	9401703	94017	94	11	0
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	01060000206A080000010000000103000000010000001A000000CDCCCCCCB43824419A9999B946285A4100000000E5382441666666E661285A419A9999993A3924419A999959A8285A41333333330A3924419A9999F9A9285A41CDCCCCCCCA3924419A999919F5285A4133333333773C2441CDCCCCECD8285A4133333333C73D244166666666CB285A4133333333B93F2441333333B3B6285A419A9999996D3F2441333333739F285A4133333333453F24419A9999998B285A4100000000323F2441666666E673285A41CDCCCCCCE73E2441CDCCCC2C74285A4166666666EB3E24419A99995978285A419A999999493E2441000000607D285A419A999999583B24416666664696285A419A999999523B24413333331395285A41333333332F3B24419A9999595E285A4100000000A93B2441666666665E285A4133333333853B2441CDCCCC8C45285A419A9999993D3B24410000000047285A41CDCCCCCC233B2441333333F333285A4133333333EB3A24419A9999D934285A41CDCCCCCC353A2441666666863A285A419A9999993B392441CDCCCC6C41285A41CDCCCCCCB43824419A9999B946285A41CDCCCCCCB43824419A9999B946285A41	01010000206A0800005895391C843D24410000004093285A41	940170401	H	Maroc 1	9401704	94017	94	11	0
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	01060000206A0800000100000001030000000100000017000000CDCCCCCC233B2441333333F333285A419A9999993D3B24410000000047285A4133333333853B2441CDCCCC8C45285A4100000000A93B2441666666665E285A41333333332F3B24419A9999595E285A419A999999523B24413333331395285A419A999999583B24416666664696285A419A999999493E2441000000607D285A4166666666EB3E24419A99995978285A4100000000E83E2441000000A06D285A4166666666F93E2441000000A062285A4133333333F93E24416666668656285A4133333333123F24419A99999946285A4100000000453F24419A99993931285A419A9999990E3F2441CDCCCC8C31285A41666666663C3E24413333339330285A4133333333A43D2441333333B32E285A419A9999991C3D2441666666462B285A4166666666903C2441000000C02A285A419A9999993A3C2441000000802C285A4100000000333B2441CDCCCC0C33285A41CDCCCCCC233B2441333333F333285A41CDCCCCCC233B2441333333F333285A41	01010000206A080000C21B9DC3143D2441666666B660285A41	940170402	H	Maroc 2	9401704	94017	94	11	0
01060000206A08000001000000010300000001000000A600000033333333B93F2441333333B3B6285A4166666666C63F244166666606BA285A419A999999C93F2441333333D3BA285A419A999999FB3F2441333333D3C5285A419A99999932402441333333D3CF285A41000000007E402441CDCCCC4CDD285A4133333333B9402441CDCCCC8CE6285A4166666666EA40244100000060EE285A419A99999900412441000000E0F1285A41666666660B412441666666E6F0285A41CDCCCCCC1341244166666646F0285A419A9999992741244133333353EF285A41CDCCCCCC3141244133333373EE285A41333333334341244133333333ED285A410000000055412441000000C0EC285A41666666667941244166666626EC285A41333333339F412441CDCCCCACEB285A4166666666C041244166666646EB285A4100000000DD41244100000000EB285A41CDCCCCCCF4412441666666C6EA285A41666666660B422441CDCCCC8CEA285A41000000002142244100000060EA285A41000000003342244133333333EA285A41CDCCCCCC4042244100000000EA285A41666666664E4224419A9999B9E9285A419A9999995D42244166666666E9285A41333333336E422441CDCCCC0CE9285A419A99999982422441CDCCCC8CE8285A4166666666964224419A999919E8285A4100000000A6422441CDCCCCACE7285A41CDCCCCCCC9422441000000C0E6285A419A999999E142244100000020E5285A4133333333F242244166666626E4285A41CDCCCCCC0C43244133333373E2285A419A99999927432441000000A0E0285A413333333342432441666666C6DE285A41000000005943244166666626DD285A419A9999997A4324419A999919DB285A41000000007443244166666646D9285A4133333333974324419A9999F9D6285A4133333333B8432441666666E6D4285A41CDCCCCCCD5432441CDCCCC0CD3285A41CDCCCCCCEB432441CDCCCCACD1285A416666666602442441CDCCCC4CD0285A41000000000F44244133333373CF285A41666666661F4424419A999959CE285A41666666662F44244133333353CD285A419A9999993A44244100000080CC285A41CDCCCCCC42442441CDCCCCCCCB285A41333333334C442441CDCCCCCCCA285A419A99999955442441000000A0C9285A419A999999694424419A9999B9C6285A419A9999997D442441000000E0C3285A416666666681442441000000C0C2285A419A99999987442441CDCCCC8CC1285A419A99999990442441CDCCCC6CC0285A41CDCCCCCC9A4424419A999959BF285A4133333333A6442441666666C6BD285A419A999999A844244166666646BC285A4166666666AC44244100000000BB285A4166666666B1442441CDCCCCECB9285A419A999999B844244100000020B9285A4166666666C144244133333393B8285A4100000000C744244166666646B8285A4100000000CD44244133333313B8285A4166666666D34424419A9999F9B7285A41CDCCCCCCD944244166666606B8285A41CDCCCCCCE044244133333333B8285A4100000000DE4424419A9999B9B6285A41CDCCCCCCDB442441333333D3B4285A4133333333DC442441CDCCCCECB2285A419A999999DD44244133333333B1285A419A999999DF4424419A999939AF285A41CDCCCCCCE044244133333313AD285A4100000000E044244100000000AC285A4100000000EA4424419A999999AB285A4133333333E844244133333393AA285A4166666666EE44244133333313AA285A4133333333F3442441000000C0AA285A4166666666F7442441333333F3AA285A4133333333FF4424419A999999AA285A41333333330545244133333333AA285A41000000000F452441666666A6A9285A41333333331A45244100000020A9285A416666666632452441CDCCCC2CA8285A419A9999993E4524419A9999B9A7285A4133333333AE45244100000060A3285A419A999999FD452441333333F39F285A41CDCCCCCC13462441333333F39E285A41666666664C462441333333739C285A41CDCCCCCC58462441333333B39B285A413333333366462441666666C69A285A41CDCCCCCC9B4624419A9999F996285A4166666666C54624410000000094285A4166666666DB4624413333337392285A410000000037472441333333F38B285A41333333334B472441000000808A285A4166666666524724413333339389285A41000000005B4724416666662688285A413333333363472441000000A086285A41000000007E4724413333339381285A419A9999998B472441CDCCCC2C7F285A416666666691472441CDCCCC8C7E285A4100000000A6472441333333737C285A4100000000B7472441666666067B285A4166666666CE4724413333339379285A4133333333B44724416666668673285A416666666693472441666666C66B285A41000000006C472441CDCCCCCC61285A413333333361472441000000C05E285A4133333333574724419A9999D95B285A41666666663C472441333333135C285A419A99999925472441CDCCCC0C5C285A410000000010472441333333D35B285A419A999999FA462441666666665B285A4133333333B44624413333335359285A4100000000984624413333339358285A4133333333794624419A9999F957285A410000000055462441666666E659285A41333333331D462441333333D35C285A416666666601462441333333335E285A41CDCCCCCCCA452441CDCCCC0C48285A4166666666C84524419A9999F946285A4100000000C74524416666660646285A41CDCCCCCCC64524410000004045285A41CDCCCCCCC74524410000008044285A4166666666CA452441666666C643285A4166666666CE452441666666E642285A41CDCCCCCCC34524419A9999F941285A4133333333BF4524419A9999D941285A4100000000BB452441000000E041285A4166666666A54524413333339342285A41CDCCCCCC6A452441CDCCCC2C44285A41CDCCCCCC40452441CDCCCC4C45285A4133333333E74424419A9999F946285A4166666666844424419A9999394A285A41CDCCCCCC98442441CDCCCCCC53285A419A999999A24424419A99999958285A419A999999C04424419A99995966285A419A999999CB442441000000006B285A4100000000B74424419A9999D96B285A41000000009A442441CDCCCC4C6D285A416666666672442441333333536F285A419A9999995C4424410000008070285A4133333333274424419A99993973285A419A99999919442441000000E073285A4133333333134424413333333374285A4133333333C44324410000008078285A416666666675432441CDCCCCEC7C285A41333333335F432441666666467E285A413333333347432441666666C67F285A4100000000DD4224410000006088285A4166666666954224419A9999798E285A4133333333794224419A9999B990285A41333333334A422441CDCCCC8C93285A4166666666AD412441000000409C285A41666666665D4124419A9999D9A0285A41333333333F412441CDCCCC8CA2285A41000000000841244133333373A5285A4166666666C9402441000000E0A8285A419A999999AF40244133333333AA285A41CDCCCCCC4440244166666606B0285A419A99999918402441CDCCCC4CB2285A4133333333F13F244100000020B4285A4100000000CB3F2441333333F3B5285A4133333333B93F2441333333B3B6285A41	01060000206A080000010000000103000000010000002700000033333333B93F2441333333B3B6285A419A999999FB3F2441333333D3C5285A41000000007E402441CDCCCC4CDD285A419A99999900412441000000E0F1285A41333333334341244133333333ED285A41000000003342244133333333EA285A41CDCCCCCCC9422441000000C0E6285A419A9999997A4324419A999919DB285A41000000007443244166666646D9285A41CDCCCCCC42442441CDCCCCCCCB285A4133333333A6442441666666C6BD285A4166666666B1442441CDCCCCECB9285A41CDCCCCCCE044244133333333B8285A41CDCCCCCCE044244133333313AD285A41333333331A45244100000020A9285A4133333333AE45244100000060A3285A41666666664C462441333333739C285A41333333334B472441000000808A285A419A9999998B472441CDCCCC2C7F285A4166666666CE4724413333339379285A416666666693472441666666C66B285A4133333333574724419A9999D95B285A419A999999FA462441666666665B285A4133333333794624419A9999F957285A416666666601462441333333335E285A41CDCCCCCCCA452441CDCCCC0C48285A4166666666CE452441666666E642285A4100000000BB452441000000E041285A41CDCCCCCC40452441CDCCCC4C45285A4133333333E74424419A9999F946285A4166666666844424419A9999394A285A419A999999CB442441000000006B285A4133333333134424413333333374285A413333333347432441666666C67F285A4133333333794224419A9999B990285A41333333333F412441CDCCCC8CA2285A419A99999918402441CDCCCC4CB2285A4133333333B93F2441333333B3B6285A4133333333B93F2441333333B3B6285A41	01010000206A0800007A8B219D35442441000000E098285A41	940170501	H	Centre 1	9401705	94017	94	11	0
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	01060000206A080000010000000103000000010000002100000066666666E73E2441CDCCCCAC6F285A41CDCCCCCCE73E2441CDCCCC2C74285A4100000000323F2441666666E673285A4133333333453F24419A9999998B285A419A9999996D3F2441333333739F285A4133333333B93F2441333333B3B6285A419A99999918402441CDCCCC4CB2285A41333333333F412441CDCCCC8CA2285A4133333333794224419A9999B990285A413333333347432441666666C67F285A4133333333134424413333333374285A419A999999CB442441000000006B285A4166666666844424419A9999394A285A4133333333E74424419A9999F946285A41CDCCCCCC40452441CDCCCC4C45285A419A999999DE442441666666861A285A410000000072442441333333331F285A419A99999936442441333333B324285A419A999999DA432441000000A023285A419A999999B74324413333335324285A410000000088432441333333130D285A4100000000E6422441CDCCCCCC16285A419A9999997A422441CDCCCC6C19285A416666666695412441666666461B285A41CDCCCCCCB7402441666666E61D285A4100000000C43F24410000006021285A41CDCCCCCC963F24419A9999B92E285A4100000000453F24419A99993931285A4133333333123F24419A99999946285A4133333333F93E24416666668656285A4166666666F93E2441000000A062285A4166666666E73E2441CDCCCCAC6F285A4166666666E73E2441CDCCCCAC6F285A41	01010000206A080000CCCCCC8CD6412441666666B660285A41	940170502	H	Centre 2	9401705	94017	94	11	0
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	01060000206A080000010000000103000000010000002B0000003333333325442441666666264E295A416666666612462441666666C64D295A4133333333AE4624419A9999194C295A41CDCCCCCCEE462441666666A649295A4100000000E64624419A99993947295A41CDCCCCCC5D472441CDCCCC6C44295A4133333333994724416666662645295A4100000000E9472441CDCCCC0C42295A4100000000DD482441CDCCCCCC3B295A4100000000CC492441666666C637295A419A999999344A2441333333F336295A41000000000F4A24413333339303295A4166666666094B24413333339301295A4166666666004B2441666666C6FE285A4166666666FC4A24419A9999F9D8285A419A999999C94A2441CDCCCC8CD8285A41CDCCCCCC5D4924419A999999D0285A41333333334649244166666666CE285A4166666666F248244166666606C2285A4133333333E4482441666666A6BD285A41666666662A49244166666626A6285A41000000005C492441CDCCCC4C97285A4100000000504924416666664694285A4100000000174924416666660692285A419A999999B14824419A99991992285A416666666651482441CDCCCCEC93285A410000000000482441CDCCCC4C97285A4166666666CD4724416666668697285A41CDCCCCCC99472441666666268F285A41000000005B4724416666662688285A41333333334B472441000000808A285A41666666664C462441333333739C285A4133333333AE45244100000060A3285A41333333331A45244100000020A9285A41CDCCCCCCE044244133333313AD285A41CDCCCCCCE044244133333333B8285A4100000000FE4424419A999959BC285A41CDCCCCCCF8442441333333D3C0285A4133333333CA4424419A999919C3285A4100000000B84424419A999939D4285A4166666666444424416666664633295A413333333325442441666666264E295A413333333325442441666666264E295A41	01010000206A0800004A9FF449CE472441666666C6E9285A41	940170601	H	République	9401706	94017	94	11	0
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	01060000206A08000001000000010300000001000000270000009A999999B54224413333331388295A41CDCCCCCCC742244133333313AD295A41333333332A43244100000080AC295A41CDCCCCCCB543244100000060A9295A4166666666A04324419A9999F9B9295A419A9999996F44244166666666B5295A4100000000B8452441666666E6AC295A419A999999C9462441CDCCCC0CA7295A419A9999991447244133333393A6295A41000000001B4724419A9999D9A1295A416666666670472441CDCCCC2CA0295A41CDCCCCCC684724413333335390295A41CDCCCCCC88472441000000C082295A41CDCCCCCCE74724416666668673295A419A999999794824419A9999B974295A419A9999999D4824413333339373295A41CDCCCCCC37492441000000A06A295A41CDCCCCCCF34924416666664663295A4100000000D7492441000000C059295A419A999999CD492441CDCCCCAC52295A4100000000CC492441666666C637295A4100000000DD482441CDCCCCCC3B295A4100000000E9472441CDCCCC0C42295A4133333333994724416666662645295A41CDCCCCCC5D472441CDCCCC6C44295A4100000000E64624419A99993947295A41000000002B4724419A99997958295A41CDCCCCCC3E472441CDCCCC8C61295A410000000030472441666666267C295A4100000000684624419A99997985295A4133333333DB452441000000C08C295A410000000096452441333333338F295A41666666663E452441333333338E295A41CDCCCCCC12452441000000608C295A41CDCCCCCCEC4424419A99999987295A41333333335F442441333333D38A295A41CDCCCCCCB64224419A9999D985295A419A999999B54224413333331388295A419A999999B54224413333331388295A41	01010000206A080000EEF7E99E774724419A9999197A295A41	940170702	H	Quatre Cités 2	9401707	94017	94	11	0
01060000206A08000001000000010300000001000000310000009A999999DC4324416666662689295A41CDCCCCCC14442441CDCCCC0C8A295A41CDCCCCCC44442441333333D38A295A41333333335F442441333333D38A295A41CDCCCCCC71442441666666868A295A41666666668C442441666666E689295A4100000000B0442441666666E688295A41CDCCCCCCEC4424419A99999987295A4133333333F1442441CDCCCCAC88295A4100000000F94424419A9999B989295A41CDCCCCCC12452441000000608C295A41333333331F452441666666268D295A41CDCCCCCC28452441666666868D295A41666666663E452441333333338E295A41000000006B452441333333D38E295A419A99999988452441000000208F295A410000000096452441333333338F295A41CDCCCCCCA2452441CDCCCC0C8F295A419A999999AE452441000000C08E295A4133333333DB452441000000C08C295A4100000000684624419A99997985295A419A999999D0462441CDCCCC8C80295A4133333333F5462441CDCCCCCC7E295A410000000030472441666666267C295A41333333333B472441666666A66B295A41333333333B472441CDCCCC0C6B295A41CDCCCCCC3E472441CDCCCC8C61295A419A9999993E4724410000004060295A41000000003C472441333333735E295A41000000002B4724419A99997958295A410000000017472441666666E653295A4100000000FD4624419A9999194D295A41CDCCCCCCEE462441666666A649295A4100000000BD462441000000A04B295A4133333333AE4624419A9999194C295A41000000007B4624419A9999994C295A416666666612462441666666C64D295A419A9999990B462441CDCCCCCC4D295A4100000000E5452441333333D34D295A41CDCCCCCCCD4524419A9999D94D295A4166666666A6452441000000E04D295A41CDCCCCCC8A4524419A9999F94D295A41666666665A452441000000004E295A416666666682442441000000404E295A413333333325442441666666264E295A410000000009442441666666C664295A416666666601442441CDCCCC0C6B295A4100000000EE4324419A9999D97A295A419A999999DC4324416666662689295A41	01060000206A08000001000000010300000001000000110000009A999999DC4324416666662689295A41333333335F442441333333D38A295A41CDCCCCCCEC4424419A99999987295A41CDCCCCCC12452441000000608C295A41666666663E452441333333338E295A410000000096452441333333338F295A4133333333DB452441000000C08C295A4100000000684624419A99997985295A410000000030472441666666267C295A41CDCCCCCC3E472441CDCCCC8C61295A41000000002B4724419A99997958295A41CDCCCCCCEE462441666666A649295A4133333333AE4624419A9999194C295A416666666612462441666666C64D295A413333333325442441666666264E295A419A999999DC4324416666662689295A419A999999DC4324416666662689295A41	01010000206A08000002CDB9AF964524410000004073295A41	940170703	H	Quatre Cités 3	9401707	94017	94	11	0
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	01060000206A080000010000000103000000010000001B000000CDCCCCCCB6412441CDCCCCAC80295A41CDCCCCCCEB412441333333F384295A4166666666F54124419A99999983295A419A999999DC4324416666662689295A413333333325442441666666264E295A4166666666444424416666664633295A4100000000B84424419A999939D4285A4133333333CA4424419A999919C3285A41CDCCCCCCF8442441333333D3C0285A4100000000FE4424419A999959BC285A41CDCCCCCCE044244133333333B8285A4166666666B1442441CDCCCCECB9285A4133333333A6442441666666C6BD285A41CDCCCCCC42442441CDCCCCCCCB285A41000000007443244166666646D9285A4100000000A843244166666606E8285A4133333333A4432441CDCCCC0CEB285A419A999999F5422441000000200D295A41CDCCCCCCBC422441CDCCCC2C1A295A41CDCCCCCC524224416666666638295A41666666663E4224413333339340295A4166666666EF412441CDCCCC6C3F295A419A999999F4412441CDCCCCAC51295A419A999999EA412441000000A064295A419A999999D6412441000000A072295A41CDCCCCCCB6412441CDCCCCAC80295A41CDCCCCCCB6412441CDCCCCAC80295A41	01010000206A0800000190FF86814324413433336320295A41	940170704	H	Quatre Cités 4	9401707	94017	94	11	0
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	01060000206A0800000100000001030000000100000023000000CDCCCCCCCD4F2441CDCCCCCCBC275A419A99999918502441000000A0C6275A41000000004450244166666666C8275A4133333333505224419A999999BB275A41000000003952244166666626B1275A41666666661C542441CDCCCCCCD5275A41333333334954244133333333DA275A41666666666A562441CDCCCC0C04285A4133333333965624419A99997903285A419A999999955624416666666600285A41000000005A5624419A999919EE275A4100000000C455244166666646C3275A419A999999B5552441000000C0C3275A41666666666D5524419A999939D2275A41CDCCCCCC6F5524419A999959E0275A41333333335C5524419A999999E1275A410000000008552441333333D3DA275A41CDCCCCCCEB5424419A999939D4275A4166666666ED542441000000C0BD275A4100000000DD542441CDCCCC6CB3275A41CDCCCCCC0C55244166666666B0275A41333333337B55244166666646AD275A41CDCCCCCC44552441666666669D275A416666666695542441000000E09F275A413333333373542441333333339F275A41CDCCCCCC465324419A9999799D275A413333333378522441333333939A275A419A99999920522441000000A0A7275A419A999999C651244133333393A0275A416666666624512441666666269B275A410000000013512441333333739E275A4166666666B2502441000000E0A1275A4133333333A250244166666606A5275A41CDCCCCCCCD4F2441CDCCCCCCBC275A41CDCCCCCCCD4F2441CDCCCCCCBC275A41	01010000206A080000683245EF575424419A999909CF275A41	940171102	H	Mordacs 2	9401711	94017	94	11	0
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	01010000206A080000537F4A9D634E244166666696E4285A41	940170801	A	Zone Industrielle	9401708	94017	94	11	1
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	01060000206A0800000100000001030000000100000034000000666666666E4724419A9999598A285A41CDCCCCCC99472441666666268F285A4166666666CD4724416666668697285A410000000000482441CDCCCC4C97285A416666666651482441CDCCCCEC93285A419A999999B14824419A99991992285A4100000000174924416666660692285A4100000000504924416666664694285A41000000005C492441CDCCCC4C97285A41666666662A49244166666626A6285A4133333333E4482441666666A6BD285A4166666666F248244166666606C2285A41333333334649244166666666CE285A41CDCCCCCC5D4924419A999999D0285A419A999999C94A2441CDCCCC8CD8285A41666666660D4C2441CDCCCC4CDA285A419A999999CC4C24419A999919D8285A41000000001A4D2441333333D3D7285A41CDCCCCCC5F4D2441CDCCCCECD8285A419A9999995C4D244133333393D5285A41CDCCCCCC774D244166666646D1285A419A9999997E4D244166666666B8285A41CDCCCCCCA04D2441333333539E285A4166666666984D2441666666068E285A41666666667B4D2441CDCCCCEC85285A419A999999304D2441333333F37F285A41CDCCCCCC264D2441666666667A285A4166666666384D24413333333376285A4100000000684D24413333339374285A419A999999694D2441666666C66A285A419A999999754D2441CDCCCCEC62285A41333333339C4D2441333333D358285A41CDCCCCCC704D24416666668656285A4133333333884D2441CDCCCCAC4D285A419A9999994F4E24419A99995934285A4100000000584E24419A99999932285A41CDCCCCCC544E24419A99999926285A419A9999991A4E2441666666061F285A4166666666DE4D2441CDCCCC4C1E285A4133333333A94D24413333337317285A4133333333294D24413333339303285A419A999999E64B24413333339323285A4100000000974B2441333333B32A285A4133333333194B24410000004033285A410000000064492441333333D34B285A419A9999994E4924410000000051285A41666666668A492441666666065C285A41CDCCCCCCE0482441CDCCCC4C71285A41666666660E482441666666A683285A4133333333C7472441000000E088285A41666666666E4724419A9999598A285A41666666666E4724419A9999598A285A41	01010000206A080000FAC1ACB72C4B24419A9999696F285A41	940170901	H	Plateau	9401709	94017	94	11	0
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	01010000206A080000871AD236484B2441666666C601285A41	940171001	H	Coteaux 1	9401710	94017	94	11	0
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	01060000206A08000001000000010300000001000000240000000000000088432441333333130D285A419A999999B74324413333335324285A419A999999DA432441000000A023285A419A99999936442441333333B324285A410000000072442441333333331F285A419A999999DE442441666666861A285A41CDCCCCCC40452441CDCCCC4C45285A419A999999E2452441666666A640285A413333333395462441333333F337285A419A9999995E472441CDCCCCCC28285A4166666666B24824413333333310285A41666666661E492441CDCCCCEC07285A419A9999994E492441000000C002285A41333333337C49244133333393FB275A4100000000F4492441CDCCCCCCE5275A4100000000224A2441CDCCCC4CDE275A419A999999E64A244166666626BA275A41333333332B4B2441CDCCCC8CAB275A41CDCCCCCC574B2441666666E69D275A419A999999C24B24419A9999B978275A419A999999A84A2441333333336D275A4133333333894A2441CDCCCC6C7B275A41333333330F4A24419A99993995275A41CDCCCCCC9949244100000020AD275A410000000079492441CDCCCC0CB9275A41333333335849244166666626C0275A4133333333ED482441CDCCCC6CCF275A419A9999995A482441333333D3DF275A4133333333D247244166666646E9275A413333333342472441000000E0F1275A416666666640462441CDCCCC6CFC275A41CDCCCCCCC3452441CDCCCC2C00285A4133333333EA4424416666668604285A41000000003A4424410000006006285A410000000088432441333333130D285A410000000088432441333333130D285A41	01010000206A080000FEEAB7F075492441000000B0D7275A41	940171002	H	Coteaux 2	9401710	94017	94	11	0
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	01060000206A080000010000000103000000010000001A0000009A9999990E4F2441333333335B285A41333333337A4F2441333333B35B285A419A999999B94F24413333337359285A41333333330D502441CDCCCC2C58285A4133333333225024419A9999D959285A4133333333FE502441CDCCCCAC58285A4133333333C35224419A9999F94C285A4166666666DA522441CDCCCCAC4C285A4100000000E2522441000000E037285A419A999999E5522441666666661F285A4133333333A2522441CDCCCCECEB275A41CDCCCCCC805224419A999999D5275A4133333333505224419A999999BB275A41000000004450244166666666C8275A419A99999918502441000000A0C6275A41CDCCCCCCCD4F2441CDCCCCCCBC275A41333333334D4F2441CDCCCCACCB275A41CDCCCCCC464F2441CDCCCC6CE5275A4166666666534F2441333333930B285A4133333333674F2441333333930C285A4100000000764F24410000008038285A41333333337A4F24419A99993952285A41CDCCCCCC684F24413333331356285A4100000000114F2441666666E659285A419A9999990E4F2441333333335B285A419A9999990E4F2441333333335B285A41	01010000206A080000E259D16814512441333333130C285A41	940171101	H	Mordacs 1	9401711	94017	94	11	0
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	01060000206A08000001000000010300000001000000150000009A9999994C5A244166666686A4275A4166666666A15A244133333333AB275A419A999999065B244133333393B6275A4133333333395B24419A999979B4275A419A999999895B244166666666BD275A419A999999C25B24419A999999C1275A4133333333025C2441CDCCCC2CC3275A41666666666D5C2441CDCCCC2CC3275A4166666666AA5C2441CDCCCC0CC0275A41CDCCCCCCCC5C2441CDCCCC8CBC275A4166666666E35C244166666626B4275A419A999999F25C2441CDCCCC0CA9275A4133333333EE5C2441666666E69C275A41CDCCCCCCD75C24419A9999597D275A419A9999991B5C2441CDCCCCAC67275A4133333333085C24410000002066275A419A999999C05B2441000000E06E275A4133333333885B2441CDCCCCAC77275A4133333333605A24419A999959A1275A419A9999994C5A244166666686A4275A419A9999994C5A244166666686A4275A41	01010000206A080000A675BCF9CC5B24416666660696275A41	940171204	H	Bois l'Abbé 4	9401712	94017	94	11	0
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	01060000206A0800000100000001030000000100000011000000000000003952244166666626B1275A41CDCCCCCC805224419A999999D5275A4133333333A2522441CDCCCCECEB275A419A999999E5522441666666661F285A419A999999E3522441CDCCCC6C3C285A41CDCCCCCC13532441000000C039285A4166666666935424419A9999792A285A4100000000B65524419A9999791E285A4166666666D55524419A9999191C285A419A999999365624416666662611285A4133333333B15624413333333308285A4133333333A85624410000008004285A41666666666A562441CDCCCC0C04285A41333333334954244133333333DA275A41666666661C542441CDCCCCCCD5275A41000000003952244166666626B1275A41000000003952244166666626B1275A41	01010000206A08000056B81ED5495424419A999969F9275A41	940171103	H	Mordacs 3	9401711	94017	94	11	0
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	01060000206A0800000100000001030000000100000017000000CDCCCCCC9A5724413333337391275A4166666666B25724416666666694275A419A999999DA57244100000000A3275A41666666660D58244100000020AC275A419A99999975582441CDCCCC2CB6275A41333333330D592441666666A6BE275A41666666667359244133333393C9275A41333333332F5A2441333333B3D6275A4100000000425A244100000020D3275A4100000000F15A244133333313BB275A419A999999065B244133333393B6275A4166666666A15A244133333333AB275A4100000000385A24419A9999F9A2275A4166666666965924416666662691275A416666666660592441666666E68B275A419A999999045924410000000086275A410000000089582441333333B37A275A419A99999958582441000000E073275A4100000000175824419A9999797A275A41CDCCCCCCDE5724413333331383275A419A999999BF572441666666A68E275A41CDCCCCCC9A5724413333337391275A41CDCCCCCC9A5724413333337391275A41	01010000206A0800003A34D6ED1A592441CCCCCCFCA4275A41	940171201	H	Bois l'Abbé 1	9401712	94017	94	11	0
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	01060000206A08000001000000010300000001000000120000009A99999958582441000000E073275A410000000089582441333333B37A275A419A999999045924410000000086275A416666666660592441666666E68B275A4166666666965924416666662691275A4133333333275A24419A999979A1275A419A9999994C5A244166666686A4275A4133333333605A24419A999959A1275A4133333333885B2441CDCCCCAC77275A419A999999C05B2441000000E06E275A4133333333085C24410000002066275A4166666666DA5B24416666662663275A41CDCCCCCC1E5B2441666666264E275A41CDCCCCCC7C592441666666E65C275A4166666666345924413333337360275A419A999999E4582441666666C665275A419A99999958582441000000E073275A419A99999958582441000000E073275A41	01010000206A0800003C889C96FD592441666666F679275A41	940171202	H	Bois l'Abbé 2	9401712	94017	94	11	0
01060000206A0800000100000001030000000100000047000000333333332F5A2441333333B3D6275A419A9999994F5A2441CDCCCC4CD8275A4100000000605A24419A999919D9275A4133333333645A244166666666D9275A4100000000655A244100000080D9275A4133333333F25A244133333393DE275A41666666663A5B24419A999919DE275A41CDCCCCCC5D5B244133333353DD275A41333333337A5B2441CDCCCC8CDC275A41000000008D5B244100000000DC275A419A999999A25B24419A999959DB275A4166666666B85B2441CDCCCC8CDA275A4100000000CE5B244133333393D9275A4100000000D55B244166666606D9275A4166666666D95B2441CDCCCC6CD8275A4100000000EE5B24419A999939D7275A4133333333075C2441000000C0D5275A419A999999175C2441CDCCCCCCD4275A41CDCCCCCC1C5C244100000080D4275A41CDCCCCCC315C244166666666D3275A419A999999545C2441000000C0D0275A4100000000635C24419A999999CF275A4100000000715C244100000040CE275A419A9999998B5C2441000000A0CB275A4166666666955C244133333393CA275A41CDCCCCCC9D5C244166666666C9275A4100000000BA5C2441333333F3C5275A4133333333BB5C2441CDCCCCECC3275A4133333333BC5C2441CDCCCCCCC2275A4100000000BF5C244133333373C1275A41CDCCCCCCCC5C2441CDCCCC8CBC275A419A999999B85C2441000000A0BE275A4166666666AA5C2441CDCCCC0CC0275A4100000000A05C2441000000E0C0275A41CDCCCCCC945C244100000080C1275A4166666666895C24419A999919C2275A41333333337F5C244166666686C2275A41666666666D5C2441CDCCCC2CC3275A4133333333025C2441CDCCCC2CC3275A4166666666F15B2441CDCCCC0CC3275A4166666666E05B2441666666A6C2275A4166666666D25B244133333333C2275A419A999999C25B24419A999999C1275A41CDCCCCCCB15B2441000000C0C0275A4166666666A05B2441CDCCCC8CBF275A419A999999895B244166666666BD275A4133333333735B2441000000E0BA275A4100000000665B24419A999959B9275A4133333333395B24419A999979B4275A4166666666345B244100000020B4275A41666666662F5B2441666666E6B3275A4133333333265B2441000000E0B3275A419A9999991F5B2441333333F3B3275A41000000001A5B244133333333B4275A41CDCCCCCC145B244100000080B4275A419A999999105B2441333333F3B4275A419A999999065B244133333393B6275A4166666666045B2441CDCCCC6CB7275A4100000000015B244100000040B8275A4100000000FE5A2441CDCCCCECB8275A419A999999FA5A2441CDCCCC8CB9275A4100000000F15A244133333313BB275A41CDCCCCCCDB5A244100000020BE275A4166666666D05A2441666666A6BF275A419A9999999F5A244166666686C6275A4166666666835A244133333353CA275A41333333335E5A2441CDCCCC4CCF275A4166666666555A244133333373D0275A4100000000425A244100000020D3275A4166666666395A24419A999999D4275A41333333332F5A2441333333B3D6275A41	01060000206A0800000100000001030000000100000014000000333333332F5A2441333333B3D6275A4100000000655A244100000080D9275A4133333333F25A244133333393DE275A41666666663A5B24419A999919DE275A419A999999A25B24419A999959DB275A41CDCCCCCC315C244166666666D3275A419A9999998B5C2441000000A0CB275A4100000000BA5C2441333333F3C5275A41CDCCCCCCCC5C2441CDCCCC8CBC275A4166666666AA5C2441CDCCCC0CC0275A41666666666D5C2441CDCCCC2CC3275A4133333333025C2441CDCCCC2CC3275A419A999999C25B24419A999999C1275A419A999999895B244166666666BD275A4133333333395B24419A999979B4275A41CDCCCCCC145B244100000080B4275A4100000000F15A244133333313BB275A4100000000425A244100000020D3275A41333333332F5A2441333333B3D6275A41333333332F5A2441333333B3D6275A41	01010000206A080000D6EFB93D9F5B2441666666F6C7275A41	940171203	H	Bois l'Abbé 3	9401712	94017	94	11	0
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	01060000206A080000010000000103000000010000002B0000009A999999D4522441666666E697285A4166666666EB522441000000C0AD285A41666666661853244133333353DF285A4100000000125424419A999939E8285A41CDCCCCCC5054244100000060EB285A41000000002B54244100000040CD285A41333333336354244166666626CC285A419A999999B1562441CDCCCC8CC2285A41CDCCCCCCBA562441666666A6E8285A41CDCCCCCCC65624416666662602295A41000000004C572441CDCCCCACFF285A4133333333995724419A9999D9FC285A4133333333BB572441666666E6F9285A41000000000E582441333333B3EA285A41CDCCCCCC40582441000000C0EA285A41333333330E5924419A9999D9E7285A4133333333435A244166666606E4285A41000000007E5A2441CDCCCC8CCD285A413333333305592441CDCCCC4CAC285A41CDCCCCCCC85824410000008088285A419A999999A1582441666666E676285A419A999999A1582441333333B370285A419A999999B7582441CDCCCCEC5F285A4100000000165824419A9999795C285A41CDCCCCCC27582441000000C04D285A416666666621582441333333134C285A41CDCCCCCCAC5724413333333347285A4166666666A6572441333333F345285A416666666641572441666666E649285A419A99999906572441CDCCCCCC31285A41CDCCCCCCB2562441333333530D285A41CDCCCCCCA6562441666666860A285A419A999999365624416666662611285A4166666666D55524419A9999191C285A4100000000B65524419A9999791E285A410000000057542441000000002D285A41CDCCCCCC13532441000000C039285A419A999999E0522441CDCCCCCC3C285A4166666666DA522441CDCCCCAC4C285A419A999999F8522441CDCCCC8C5B285A4133333333AD532441333333D394285A419A999999D4522441666666E697285A419A999999D4522441666666E697285A41	01010000206A08000024D6A5F723562441666666D686285A41	940171301	H	Cœuilly 1	9401713	94017	94	11	1
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	01060000206A08000001000000010300000001000000280000009A999999855924419A999999B7285A41000000007E5A2441CDCCCC8CCD285A41CDCCCCCC1E5C24419A999919F3285A419A999999535C2441CDCCCC8CEA285A41666666666A5C24419A9999F9EA285A4133333333C75C2441CDCCCCACE6285A419A999999EE5D24410000006002295A419A999999015E24419A99999900295A4133333333315E2441333333D304295A4100000000855E24413333335306295A41CDCCCCCCD55E244100000020FF285A413333333326602441333333B3D9285A4100000000C5602441666666A6C6285A4166666666E460244133333393C4285A41666666669F612441CDCCCC8CB0285A4166666666F661244100000060A5285A41CDCCCCCC9F6224419A9999B991285A419A9999994B6324419A9999D97E285A419A999999776324419A99991979285A41333333333D632441666666C66E285A4133333333336324410000000064285A4133333333146324419A99997958285A4166666666BC622441333333534B285A41CDCCCCCCF2612441666666063A285A41CDCCCCCC7D6124413333337337285A419A9999990F612441666666C621285A4166666666B96024413333331323285A419A999999D66024410000002029285A410000000088602441333333B336285A41CDCCCCCCE3602441000000004E285A4100000000F45F24413333331359285A419A9999995A6024419A99997969285A4133333333405F24416666660673285A41CDCCCCCC315F24413333331370285A4133333333F55E2441CDCCCC8C70285A4166666666EA5E24410000000076285A419A9999993A5E2441000000C07B285A4133333333245A2441000000C09F285A419A999999855924419A999999B7285A419A999999855924419A999999B7285A41	01010000206A0800001EA78A030D5F24416666667693285A41	940171302	H	Cœuilly 2	9401713	94017	94	11	0
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	01060000206A080000010000000103000000010000002200000033333333D95A2441CDCCCC6CE8275A419A999999EA5A244133333353EB275A41CDCCCCCC0B5B24416666664603285A41666666660A5B2441CDCCCCCC07285A4133333333265B24419A9999390A285A4133333333CC5B24413333331337285A419A999999BC5B2441333333534F285A4100000000DA5B24416666662653285A4166666666BD5B24419A99993955285A41CDCCCCCC475C24413333333374285A41666666665C5C2441CDCCCC2C8C285A419A9999993A5E2441000000C07B285A4166666666EA5E24410000000076285A4133333333F55E2441CDCCCC8C70285A41CDCCCCCC315F24413333331370285A4133333333405F24416666660673285A419A9999995A6024419A99997969285A4100000000F45F24413333331359285A41CDCCCCCCE3602441000000004E285A410000000088602441333333B336285A419A999999D66024410000002029285A4166666666B96024413333331323285A419A9999990F612441666666C621285A41CDCCCCCCA5602441CDCCCCEC0B285A41CDCCCCCC685F244100000020CD275A41333333336D5F2441CDCCCCECC7275A4133333333445F24419A999939C7275A4133333333525E244133333353CF275A4133333333525D2441000000A0D6275A419A999999105D2441000000E0D6275A4100000000EE5C2441CDCCCC0CDA275A419A999999895B2441CDCCCCECE2275A4133333333D95A2441CDCCCC6CE8275A4133333333D95A2441CDCCCC6CE8275A41	01010000206A08000067B0EDB6355E2441CDCCCCBC2A285A41	940171303	H	Cœuilly 3	9401713	94017	94	11	0
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	01010000206A080000A8042E3A3A5924410000007025285A41	940171304	H	Cœuilly 4	9401713	94017	94	11	1
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	01060000206A0800000100000001030000000100000025000000000000002B54244100000040CD285A41CDCCCCCC5054244100000060EB285A4100000000F254244166666666F2285A41CDCCCCCC1C5524419A999959F5285A419A999999885524413333335301295A4166666666C05524419A99999904295A41CDCCCCCC625624419A9999F905295A41CDCCCCCCD55624410000002013295A419A9999992B572441000000A018295A4100000000B2572441000000C01D295A41CDCCCCCCC5582441000000A01F295A41000000002E592441CDCCCCEC1F295A419A9999999B592441333333D31D295A41CDCCCCCCE35924419A99991919295A4166666666265A2441666666C60A295A419A9999996E5A2441666666A601295A41CDCCCCCCCB5A2441CDCCCC0CFC285A41CDCCCCCC9B5C244100000000F8285A41CDCCCCCC2A5D2441000000E0EF285A4133333333C75C2441CDCCCCACE6285A41666666666A5C24419A9999F9EA285A419A999999535C2441CDCCCC8CEA285A41CDCCCCCC1E5C24419A999919F3285A41000000007E5A2441CDCCCC8CCD285A4133333333435A244166666606E4285A41333333330E5924419A9999D9E7285A41CDCCCCCC40582441000000C0EA285A41000000000E582441333333B3EA285A4133333333BB572441666666E6F9285A4133333333995724419A9999D9FC285A41000000004C572441CDCCCCACFF285A41CDCCCCCCC65624416666662602295A41CDCCCCCCBA562441666666A6E8285A419A999999B1562441CDCCCC8CC2285A41333333336354244166666626CC285A41000000002B54244100000040CD285A41000000002B54244100000040CD285A41	01010000206A080000ACB6B4FCF85924419A9999B9F0285A41	940171401	H	Perroquets	9401714	94017	94	11	0
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	01060000206A080000010000000103000000010000001700000000000000510A244133333333C3295A4166666666DC0A2441CDCCCC4CBC295A4100000000590B244100000060B8295A4100000000D80B2441CDCCCC6CB6295A419A999999820C2441000000E0B5295A4133333333410D24419A999959B7295A4166666666C40D24419A999919B7295A41CDCCCCCC6D0E244100000060B3295A4166666666DA0E244133333333AF295A4133333333D20E2441CDCCCC0CAC295A4100000000DE0E2441666666C698295A41000000009C0C2441333333F373295A4133333333F90B2441000000E06B295A4100000000D00B24419A9999F970295A41CDCCCCCCE00B24413333337374295A419A999999DB0B2441000000E07A295A41000000009B0B2441CDCCCC6C8F295A41333333334D0B244133333353A0295A4166666666060B244100000020AC295A4133333333CC0A244100000040B4295A4166666666620A244100000000C0295A4100000000510A244133333333C3295A4100000000510A244133333333C3295A41	01010000206A080000A192F923240D24419A9999D997295A41	940180103	H	Plateau	9401801	94018	94	11	0
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	01060000206A0800000100000001030000000100000016000000CDCCCCCCBE0B2441CDCCCC8C47295A41CDCCCCCC3C0C24413333337363295A4133333333EB0C2441000000A04D295A41CDCCCCCC3B0E24416666668651295A4100000000EF0F24419A99993956295A4100000000E50F2441333333D334295A41CDCCCCCCDC0F24419A9999D92B295A41CDCCCCCCD30F24416666664609295A419A999999D90F2441333333B303295A4100000000E30F2441333333B3DA285A4133333333460F2441666666C6D7285A41CDCCCCCCF60E24419A999979D5285A41CDCCCCCCAE0D244166666606CA285A4166666666530D244133333313E4285A4133333333F90C24419A999939FC285A41000000002B0D24419A999939FB285A4100000000410D244166666626FE285A4100000000900C24416666662625295A4133333333760C24419A9999592E295A419A999999D60B24410000004045295A41CDCCCCCCBE0B2441CDCCCC8C47295A41CDCCCCCCBE0B2441CDCCCC8C47295A41	01010000206A080000B01ABE4A530E2441000000D017295A41	940180101	H	Centre Ville	9401801	94018	94	11	0
01060000206A080000010000000103000000010000002300000033333333F90B2441000000E06B295A41000000009C0C2441333333F373295A4133333333F00D24419A99997989295A4100000000DE0E2441666666C698295A41CDCCCCCCD90E24419A9999B99C295A4133333333D20E2441CDCCCC0CAC295A4100000000D60E2441CDCCCC8CAD295A4166666666DA0E244133333333AF295A4100000000F70E2441333333D3AD295A41333333330F0F244133333393AC295A4166666666450F2441CDCCCCCCA9295A4100000000730F2441CDCCCCCCA7295A4100000000A30F244166666606A6295A4133333333B80F24419A999959A5295A419A999999EC0F244166666606A4295A419A9999990C102441CDCCCC2CA3295A41000000000C102441333333F39D295A4100000000081024419A99995992295A416666666607102441000000C090295A41CDCCCCCC05102441666666668B295A413333333302102441666666E681295A4100000000FD0F2441CDCCCCCC76295A4166666666FB0F24413333331372295A41CDCCCCCCF70F24419A9999F969295A4100000000EF0F24419A99993956295A41CDCCCCCC210F24410000000054295A4166666666A20E2441000000A052295A4133333333700E24416666660652295A41CDCCCCCC3B0E24416666668651295A41CDCCCCCC100D2441333333F34D295A4133333333EB0C2441000000A04D295A419A999999C80C24416666662652295A419A9999998C0C2441CDCCCC6C59295A41CDCCCCCC3C0C24413333337363295A4133333333F90B2441000000E06B295A41	01060000206A080000010000000103000000010000000E00000033333333F90B2441000000E06B295A41000000009C0C2441333333F373295A4100000000DE0E2441666666C698295A4133333333D20E2441CDCCCC0CAC295A4166666666DA0E244133333333AF295A4166666666450F2441CDCCCCCCA9295A4133333333B80F24419A999959A5295A419A9999990C102441CDCCCC2CA3295A413333333302102441666666E681295A4100000000EF0F24419A99993956295A41CDCCCCCC3B0E24416666668651295A4133333333EB0C2441000000A04D295A4133333333F90B2441000000E06B295A4133333333F90B2441000000E06B295A41	01010000206A080000E672342E900E24419A9999597C295A41	940180102	H	Gabrielle Leclerc	9401801	94018	94	11	0
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	01060000206A0800000100000001030000000100000018000000CDCCCCCC7F05244166666686382A5A4133333333EB052441000000C03E2A5A410000000048062441CDCCCCCC392A5A41CDCCCCCCD1062441CDCCCCCC2F2A5A41000000007E072441000000601D2A5A419A999999F5072441CDCCCC6C0C2A5A4166666666600824419A999979FB295A419A999999F7082441CDCCCC2CE6295A4100000000960924419A999999D3295A4100000000DF092441CDCCCC2CCC295A4100000000510A244133333333C3295A4166666666620A244100000000C0295A4133333333CC0A244100000040B4295A4166666666060B244100000020AC295A41333333334D0B244133333353A0295A41000000009B0B2441CDCCCC6C8F295A419A999999DB0B2441000000E07A295A41CDCCCCCCE00B24413333337374295A4100000000D00B24419A9999F970295A41CDCCCCCC480A24419A999979A1295A4133333333B30724419A999919F3295A41333333331E0624419A9999B9242A5A41CDCCCCCC7F05244166666686382A5A41CDCCCCCC7F05244166666686382A5A41	01010000206A08000004160D77F8082441333333A3D8295A41	940180104	H	Franges du Bois de Vincennes	9401801	94018	94	11	0
01060000206A080000010000000103000000010000002100000066666666BC072441666666A6B1295A4166666666E307244166666646B8295A41000000002008244133333353C3295A419A9999999208244100000060D7295A41CDCCCCCC2809244133333313C5295A4166666666AB092441333333D3B4295A41CDCCCCCC480A24419A999979A1295A41CDCCCCCC100B24413333337388295A4166666666330B24416666664684295A41CDCCCCCC590B2441333333737F295A4133333333810B2441CDCCCC8C7A295A4166666666AA0B24416666666675295A4100000000D00B24419A9999F970295A4133333333F90B2441000000E06B295A41CDCCCCCC3C0C24413333337363295A41333333331A0C2441000000A05B295A4100000000AE0B24413333337363295A419A999999580B24419A99997969295A4100000000180B2441333333F36D295A4100000000BC0A24413333337374295A41000000003A0A24419A9999597D295A4100000000FD092441CDCCCCAC81295A419A999999E90924416666662683295A4133333333CC0924416666668685295A410000000099092441333333F38A295A419A99999949092441CDCCCCCC92295A41333333330B0924410000008098295A419A999999E4082441666666E69B295A41CDCCCCCC8608244166666626A3295A41333333332A0824419A9999B9A9295A41CDCCCCCCEB0724419A9999D9AD295A419A999999CD072441CDCCCCECAF295A4166666666BC072441666666A6B1295A41	01060000206A080000010000000103000000010000000E00000066666666BC072441666666A6B1295A419A9999999208244100000060D7295A41CDCCCCCC480A24419A999979A1295A41CDCCCCCC100B24413333337388295A41CDCCCCCC3C0C24413333337363295A41333333331A0C2441000000A05B295A4100000000AE0B24413333337363295A4100000000FD092441CDCCCCAC81295A4133333333CC0924416666668685295A419A99999949092441CDCCCCCC92295A419A999999E4082441666666E69B295A41CDCCCCCC8608244166666626A3295A4166666666BC072441666666A6B1295A4166666666BC072441666666A6B1295A41	01010000206A080000F301C26BBD092441333333339A295A41	940180105	H	Conflans	9401801	94018	94	11	0
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	01060000206A08000001000000010300000001000000150000000000000041092441000000203D295A4133333333860924410000006050295A4133333333390A24410000004062295A4100000000C60A2441666666C659295A419A9999998C0B2441333333B33C295A41CDCCCCCCBE0B2441CDCCCC8C47295A419A999999D60B24410000004045295A4133333333760C24419A9999592E295A4100000000900C24416666662625295A4100000000410D244166666626FE285A41000000002B0D24419A999939FB285A4133333333CC0C2441666666C6FC285A41CDCCCCCC930C2441CDCCCC6CFF285A4100000000C70B24419A99993903295A419A999999F30B2441000000000C295A4166666666060B2441333333B31C295A4133333333210B24416666660623295A41CDCCCCCCE6092441CDCCCC8C37295A410000000056092441000000603D295A410000000041092441000000203D295A410000000041092441000000203D295A41	01010000206A080000E4A00E9A710B2441343333A32E295A41	940180106	H	Bordeaux Victor Hugo	9401801	94018	94	11	0
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	01060000206A0800000100000001030000000100000024000000CDCCCCCCAD0424410000006030295A41CDCCCCCC190524413333339344295A416666666656052441CDCCCC6C51295A419A9999996C052441000000004F295A4133333333F7052441000000E044295A419A99999999062441666666A63B295A419A999999330724413333331332295A416666666664072441666666A641295A41333333338A072441CDCCCC4C42295A41666666663C0824410000000038295A41666666661A0924419A9999B92D295A410000000041092441000000203D295A410000000056092441000000603D295A41CDCCCCCCE6092441CDCCCC8C37295A4133333333210B24416666660623295A4166666666060B2441333333B31C295A419A999999F30B2441000000000C295A4100000000C70B24419A99993903295A41CDCCCCCC930C2441CDCCCC6CFF285A4133333333F90C24419A999939FC285A4166666666530D244133333313E4285A41CDCCCCCCAE0D244166666606CA285A4166666666090D24419A999959C8285A41CDCCCCCC550C2441CDCCCC0CC9285A41333333337F0B2441000000A0CB285A4100000000B00A2441000000E0CE285A4133333333F109244100000080D3285A4100000000B8092441CDCCCC4CDC285A41CDCCCCCC750924419A9999D9E3285A41CDCCCCCC36092441CDCCCC6CE9285A4100000000F10824419A9999F9ED285A419A999999E207244100000060FC285A4166666666B4062441000000800F295A41CDCCCCCCB7052441666666E61E295A41CDCCCCCCAD0424410000006030295A41CDCCCCCCAD0424410000006030295A41	01010000206A080000BF4D311255092441000000C00D295A41	940180107	H	Carrières	9401801	94018	94	11	0
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	01060000206A080000010000000103000000010000001D0000006666666656052441CDCCCC6C51295A419A9999997C0524413333335358295A4133333333E6052441CDCCCC4C66295A4133333333530624410000002079295A41CDCCCCCC850624419A99991980295A416666666645072441666666069D295A4166666666BC072441666666A6B1295A41CDCCCCCC8608244166666626A3295A419A999999E4082441666666E69B295A419A99999949092441CDCCCCCC92295A4133333333CC0924416666668685295A4100000000FD092441CDCCCCAC81295A4100000000AE0B24413333337363295A41333333331A0C2441000000A05B295A419A9999998C0B2441333333B33C295A4100000000C60A2441666666C659295A4133333333390A24410000004062295A4133333333860924410000006050295A410000000041092441000000203D295A41666666661A0924419A9999B92D295A41666666663C0824410000000038295A41333333338A072441CDCCCC4C42295A416666666664072441666666A641295A419A999999330724413333331332295A419A99999999062441666666A63B295A4133333333F7052441000000E044295A419A9999996C052441000000004F295A416666666656052441CDCCCC6C51295A416666666656052441CDCCCC6C51295A41	01010000206A080000796227F688082441CCCCCC0C71295A41	940180108	H	Archevêché	9401801	94018	94	11	0
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	01060000206A080000010000000103000000010000001C00000066666666EAFE234100000020D4295A419A99999976FF2341CDCCCCCCDF295A41666666667700244133333313F4295A4133333333600124419A9999D9062A5A413333333329022441666666E60B2A5A419A999999D0022441333333D3142A5A41666666666B032441333333531C2A5A41CDCCCCCC3F0424419A999979252A5A419A9999993C042441000000C0212A5A419A9999998005244166666606EC295A41666666664B06244166666626D2295A419A9999994E0724419A999999BB295A4166666666BC072441666666A6B1295A416666666645072441666666069D295A41CDCCCCCC850624419A99991980295A4133333333530624410000002079295A4133333333E6052441CDCCCC4C66295A419A9999997C0524413333335358295A41CDCCCCCC190524413333339344295A41CDCCCCCCAD0424410000006030295A41CDCCCCCC0A042441CDCCCCCC3B295A419A999999670324410000000048295A41CDCCCCCCBE0224416666662658295A419A99999904022441000000C06C295A41CDCCCCCCB00124413333333377295A4166666666CE002441666666A694295A4166666666EAFE234100000020D4295A4166666666EAFE234100000020D4295A41	01010000206A08000050FC5855DE032441000000A0A9295A41	940180109	H	Bercy	9401801	94018	94	11	1
01060000206A080000010000000103000000010000002A000000CDCCCCCC39042441333333B3222A5A41333333333A0424419A9999D9232A5A419A9999993C0424419A9999D9242A5A41CDCCCCCC3F0424419A999979252A5A419A9999995204244100000080262A5A416666666680042441666666E6282A5A4133333333AC042441000000802B2A5A419A999999050524419A999939312A5A41CDCCCCCC3805244166666646342A5A41CDCCCCCC7F05244166666686382A5A41333333331E0624419A9999B9242A5A4100000000EE0624419A9999390B2A5A410000000036072441CDCCCC6C022A5A4133333333B30724419A999919F3295A4166666666C9072441CDCCCC4CF0295A419A999999F80724419A999959EA295A410000000027082441000000A0E4295A419A9999999208244100000060D7295A41000000002008244133333353C3295A4166666666E307244166666646B8295A4166666666BC072441666666A6B1295A419A999999AD07244133333313B3295A41000000008D072441CDCCCCECB5295A41333333336F0724419A999999B8295A419A9999994E0724419A999999BB295A4166666666180724419A999959C0295A41CDCCCCCCDC06244166666646C5295A419A9999997C0624419A9999B9CD295A41666666664B06244166666626D2295A41333333333B0624419A999939D4295A410000000029062441000000C0D6295A41333333331106244100000000DA295A4166666666950524419A999959E9295A41CDCCCCCC88052441333333F3EA295A419A9999998005244166666606EC295A416666666667052441CDCCCC2CF0295A41333333333005244100000020F9295A4133333333BD042441000000600C2A5A419A99999991042441CDCCCCAC132A5A41000000005D042441CDCCCC6C1C2A5A419A9999993C042441000000C0212A5A41CDCCCCCC39042441333333B3222A5A41	01060000206A080000010000000103000000010000000E000000CDCCCCCC39042441333333B3222A5A41CDCCCCCC3F0424419A999979252A5A4133333333AC042441000000802B2A5A41CDCCCCCC7F05244166666686382A5A41333333331E0624419A9999B9242A5A4133333333B30724419A999919F3295A419A9999999208244100000060D7295A4166666666BC072441666666A6B1295A419A9999994E0724419A999999BB295A41666666664B06244166666626D2295A419A9999998005244166666606EC295A419A9999993C042441000000C0212A5A41CDCCCCCC39042441333333B3222A5A41CDCCCCCC39042441333333B3222A5A41	01010000206A08000010AF34AF6E062441CDCCCC1CF6295A41	940180110	H	Valmy	9401801	94018	94	11	0
01060000206A080000010000000103000000010000003E00000033333333D94A24419A9999195C255A4100000000F44A2441333333735E255A419A999999C34B24416666660672255A4133333333EF4B24419A99995976255A41666666660D4C2441000000A079255A419A999999354C2441333333537E255A419A999999764C2441333333F386255A4166666666884C24413333337389255A4133333333C74C24419A99993993255A4100000000E54C2441CDCCCCEC97255A419A999999104D2441666666469F255A41333333336B4D24419A999979AF255A41333333339B4D244166666646B8255A4166666666A74D244133333373BA255A419A999999DD4D24419A999939C4255A419A999999FD4D2441000000E0C9255A419A9999990A4E2441666666E6CB255A41666666661B4E2441CDCCCC8CCE255A4133333333474E244100000000D5255A4133333333544E24419A9999B9D6255A41666666666A4E2441333333B3D9255A4166666666A24E244100000060E0255A419A999999DA4E2441000000C0E6255A4100000000754F2441333333F3F5255A41666666667D4F2441CDCCCC6CF6255A4133333333834F244166666686F6255A4100000000884F24419A999979F6255A4100000000994F2441333333B3F5255A4133333333FB4F2441CDCCCC4CF1255A41000000001E502441000000C0EF255A419A999999F84F244100000060DD255A4166666666E74F24419A999999D4255A4100000000D14F2441CDCCCCECC8255A4133333333C24F244133333393C1255A41CDCCCCCCAA4F24419A999979B4255A4100000000974F244133333373AA255A41CDCCCCCC814F2441666666C6A0255A41CDCCCCCC7C4F24419A9999799E255A4100000000794F2441666666669C255A41333333335B4F24419A9999598D255A41CDCCCCCC564F2441333333538B255A4133333333544F2441666666868A255A4166666666504F2441CDCCCCEC89255A419A999999494F24413333331389255A41000000003C4F2441CDCCCC2C88255A4100000000A64E24419A9999197B255A41333333334D4E24410000008073255A4166666666404E2441333333F371255A419A999999304E2441CDCCCCAC6F255A4100000000854D2441000000A056255A419A999999CC4C24419A9999393B255A4133333333824C24413333333330255A41333333337B4C2441666666A62F255A4166666666714C2441333333732F255A41666666666B4C24419A9999792F255A41000000005C4C2441333333B330255A41CDCCCCCC054C2441333333333A255A419A999999D14B24416666664640255A419A999999974B24410000008046255A419A9999992A4B24419A9999B952255A4133333333204B2441CDCCCCEC53255A4133333333D94A24419A9999195C255A41	01060000206A080000010000000103000000010000001400000033333333D94A24419A9999195C255A419A999999C34B24416666660672255A419A999999354C2441333333537E255A4166666666884C24413333337389255A419A999999104D2441666666469F255A419A999999FD4D2441000000E0C9255A41666666666A4E2441333333B3D9255A419A999999DA4E2441000000C0E6255A4100000000754F2441333333F3F5255A4100000000884F24419A999979F6255A41000000001E502441000000C0EF255A4133333333C24F244133333393C1255A4100000000974F244133333373AA255A4133333333544F2441666666868A255A41333333334D4E24410000008073255A4100000000854D2441000000A056255A4133333333824C24413333333330255A41000000005C4C2441333333B330255A4133333333D94A24419A9999195C255A4133333333D94A24419A9999195C255A41	01010000206A080000D0C112AC0A4E24419A99994990255A41	940190101	H	Le Moulin	9401901	94019	94	11	0
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	01010000206A0800001FAC9DC7E14D244133333393F2255A41	940190102	H	Centre Ville Château	9401901	94019	94	11	1
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	01010000206A0800003F8353452A4D2441000000308E265A41	940190103	H	Coteaux	9401901	94019	94	11	1
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	01010000206A080000C05A9D90A654244166666656CA265A41	940190104	H	Le Fort-La Maillarde	9401901	94019	94	11	1
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	01060000206A080000010000000103000000010000002A00000033333333FA5024413333339399275A419A999999C651244133333393A0275A419A99999920522441000000A0A7275A413333333378522441333333939A275A41CDCCCCCC465324419A9999799D275A413333333373542441333333339F275A416666666695542441000000E09F275A41CDCCCCCC44552441666666669D275A419A999999B15624410000000096275A4133333333D656244133333333A5275A41CDCCCCCC515724419A9999599B275A41CDCCCCCC7B5724419A99995994275A419A999999BF572441666666A68E275A41CDCCCCCCDE5724413333331383275A4100000000175824419A9999797A275A41333333336D582441666666A671275A419A99999920582441333333B365275A419A99999916582441333333535E275A413333333351582441CDCCCC6C30275A4166666666855824419A9999D91F275A4133333333775824419A9999F91E275A4100000000785724419A9999D916275A41CDCCCCCCDE5724419A9999D9E5265A419A9999997A57244100000000E2265A41CDCCCCCC44572441CDCCCC6CDD265A4100000000D95624419A9999F9DF265A41CDCCCCCC8255244100000000E2265A41CDCCCCCC7B55244100000020E6265A413333333359552441000000C0E5265A41666666662655244166666666E8265A416666666655542441333333B3EC265A419A999999A25324419A999919EC265A41CDCCCCCC16532441666666C6E8265A41000000001F532441CDCCCC8C09275A41CDCCCCCC2A532441CDCCCC8C15275A41CDCCCCCC3A5324419A9999B916275A4100000000CD532441666666E616275A41CDCCCCCCC9532441CDCCCC4C3C275A41CDCCCCCC02542441CDCCCC6C43275A41CDCCCCCC95512441CDCCCC4C89275A4133333333FA5024413333339399275A4133333333FA5024413333339399275A41	01010000206A080000203A32BB19562441666666C642275A41	940190105	H	Paris Chennevières	9401901	94019	94	11	0
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	01060000206A080000010000000103000000010000001800000000000000785724419A9999D916275A4133333333775824419A9999F91E275A4166666666855824419A9999D91F275A413333333351582441CDCCCC6C30275A419A99999916582441333333535E275A419A99999920582441333333B365275A41333333336D582441666666A671275A419A999999E4582441666666C665275A4166666666345924413333337360275A41CDCCCCCC7C592441666666E65C275A41CDCCCCCC1E5B2441666666264E275A4133333333315C2441666666A642275A4133333333195C24416666666639275A4166666666F15A24419A99991930275A41CDCCCCCC6E5A2441666666662B275A419A9999992E5A24419A9999B923275A41000000009D592441666666C60D275A41333333337A5924410000002012275A419A9999990159244133333373FD265A4166666666B2582441CDCCCCCCF3265A4100000000625824419A999919ED265A41CDCCCCCCDE5724419A9999D9E5265A4100000000785724419A9999D916275A4100000000785724419A9999D916275A41	01010000206A080000C5FB91536A592441666666C62B275A41	940190106	H	Bois l'Abbé 1	9401901	94019	94	11	0
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	01060000206A080000010000000103000000010000003C000000CDCCCCCC2A5B2441CDCCCC8C4F275A4166666666DA5B24416666662663275A419A9999991B5C2441CDCCCCAC67275A41CDCCCCCCD75C24419A9999597D275A4133333333EE5C2441666666E69C275A419A999999F25C2441CDCCCC0CA9275A41CDCCCCCCDC5C2441000000E0B6275A4100000000BF5C244133333373C1275A4166666666BE5C24419A999939C9275A4133333333F95C24419A9999B9D6275A4133333333525D2441000000A0D6275A4133333333525E244133333353CF275A4133333333445F24419A999939C7275A41333333336D5F2441CDCCCCECC7275A4133333333AF5F2441000000C0AE275A41CDCCCCCC9C5F244100000020AD275A4133333333B85F24419A999919A8275A4166666666D65F2441000000A09C275A4166666666DD5F2441666666C695275A4133333333F55F24413333331393275A4100000000246024416666662681275A4166666666F65E2441CDCCCC6C79275A419A9999992D5F24419A9999595A275A4100000000256024413333337362275A41CDCCCCCC05632441000000207C275A4100000000FD6324419A99991984275A41000000008C6524419A9999794C275A41CDCCCCCC8E662441333333F32E275A41CDCCCCCC98662441CDCCCC0C27275A41CDCCCCCCAB662441CDCCCC8C04275A4166666666B3662441333333B3E6265A41CDCCCCCCDE662441CDCCCCCCD4265A419A999999C2652441000000E0BE265A41000000008364244133333373A7265A41CDCCCCCC7E64244100000040A8265A41CDCCCCCC676324416666666695265A4133333333966224419A99995985265A4133333333296124419A9999F967265A4166666666E6602441CDCCCCEC6E265A41666666661E6024416666662696265A41CDCCCCCC03602441666666A69C265A4133333333EC5F244100000040A6265A41CDCCCCCCA55F24419A999979D7265A4100000000E25F24419A9999D9D8265A4100000000A05F2441CDCCCCEC01275A41666666665E5F24413333335303275A4100000000CF5E2441000000A0FF265A4133333333615E24419A9999590E275A4100000000E15D2441CDCCCC0C1E275A4100000000A25D2441000000A026275A4166666666A25D2441CDCCCC8C2E275A41000000006B5D24410000006032275A419A999999455D2441666666A637275A419A9999992F5D2441CDCCCC4C35275A4100000000C25C2441333333B344275A41333333338D5C24416666660642275A4133333333315C2441666666A642275A419A9999992E5B2441000000604D275A41CDCCCCCC2A5B2441CDCCCC8C4F275A41CDCCCCCC2A5B2441CDCCCC8C4F275A41	01010000206A080000A6DB98722E6224416666665622275A41	940190107	H	Bois l'Abbé 2 Plaine des Bordes	9401901	94019	94	11	1
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	01060000206A0800000100000001030000000100000033000000CDCCCCCC44572441CDCCCC6CDD265A419A9999997A57244100000000E2265A419A9999992958244133333373E9265A4166666666B2582441CDCCCCCCF3265A419A9999990159244133333373FD265A41333333337A5924410000002012275A41000000009D592441666666C60D275A419A9999992E5A24419A9999B923275A41CDCCCCCC6E5A2441666666662B275A4166666666F15A24419A99991930275A4133333333195C24416666666639275A4133333333315C2441666666A642275A41333333338D5C24416666660642275A4100000000C25C2441333333B344275A419A9999992F5D2441CDCCCC4C35275A419A999999455D2441666666A637275A41000000006B5D24410000006032275A4166666666A25D2441CDCCCC8C2E275A4100000000A25D2441000000A026275A4100000000E15D2441CDCCCC0C1E275A4133333333615E24419A9999590E275A4100000000CF5E2441000000A0FF265A41666666665E5F24413333335303275A4100000000A05F2441CDCCCCEC01275A4100000000E25F24419A9999D9D8265A41CDCCCCCCA55F24419A999979D7265A4133333333EC5F244100000040A6265A41CDCCCCCC03602441666666A69C265A41666666661E6024416666662696265A4166666666E6602441CDCCCCEC6E265A4133333333296124419A9999F967265A41CDCCCCCCCA5F2441333333F34A265A41CDCCCCCCFF5E2441CDCCCCAC38265A419A999999FC5D2441CDCCCCEC23265A419A999999C15D2441333333731E265A4100000000935D2441CDCCCC8C16265A4166666666065D2441CDCCCC8C29265A4100000000CA5D2441333333F35A265A4166666666D35C2441000000A062265A419A999999875C24410000008072265A41CDCCCCCC815C2441CDCCCC8C7B265A4133333333755C2441666666667B265A4133333333715C2441000000009D265A41CDCCCCCC685C244133333313BF265A419A999999785C24419A999959C5265A410000000000592441CDCCCCECB1265A419A999999CE582441CDCCCCCCB6265A4133333333555824419A9999D9C4265A419A9999998A572441CDCCCCACD8265A41CDCCCCCC44572441CDCCCC6CDD265A41CDCCCCCC44572441CDCCCC6CDD265A41	01010000206A080000EAAB8ED0295E2441666666A6AA265A41	940190108	H	Hauts de Chennevières Pince-Vent	9401901	94019	94	11	1
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	01060000206A0800000100000001030000000100000015000000000000006BE0234133333313C4235A4100000000B1E02341CDCCCC2CDC235A41CDCCCCCCF1E0234100000040F0235A413333333341E223419A999939E1235A41666666664FE22341666666A6E3235A419A99999987E223419A9999F9E0235A41666666661FE323419A99997911245A419A99999965E32341333333D30D245A41000000003CE423413333339306245A413333333314E523416666666600245A410000000008E52341000000A0EE235A4133333333F5E4234133333373DE235A4100000000C1E42341666666C6C2235A419A9999995AE42341666666069B235A41666666666BE32341666666C6A1235A4100000000C9E223419A999939A7235A4100000000CBE223419A9999F9A8235A4166666666C7E1234166666626B5235A4166666666ABE12341CDCCCCCCB4235A41000000006BE0234133333313C4235A41000000006BE0234133333313C4235A41	01010000206A080000AE14B23BC5E22341000000D0D6235A41	940210103	H	Larue 2	9402101	94021	94	11	0
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	01060000206A080000010000000103000000010000001800000033333333E0EE2341666666C618235A4166666666F7EF2341666666062E235A41000000000CF023410000002041235A4100000000BEEF23416666664652235A419A9999999EF023410000006066235A410000000030F12341333333F373235A4133333333D9F123419A9999F97D235A4133333333E2F12341666666C67D235A4133333333FCF12341CDCCCCCC1E235A41000000000EF2234133333333D0225A4133333333E3F12341CDCCCC4CBD225A4166666666CCF12341333333B3BC225A419A999999A6F1234166666666B2225A419A99999969F12341CDCCCC8CB0225A4166666666EBF0234133333373B0225A41CDCCCCCCE8F02341333333B3BB225A4166666666BCF023419A9999D9BE225A4166666666C2EF23419A999959BE225A4100000000F0EF234133333393C7225A416666666653F02341666666E6D8225A419A999999EBEF234100000040E9225A41000000007FEF2341CDCCCC6CFB225A4133333333E0EE2341666666C618235A4133333333E0EE2341666666C618235A41	01010000206A080000A05B1CD376F023413333330316235A41	940210104	H	Bretagne 1	9402101	94021	94	11	0
01060000206A08000001000000010300000001000000B20000009A999999A7EA2341CDCCCC0C54235A4166666666D1EA2341000000E058235A41CDCCCCCC27EB2341333333F35F235A41000000009DEB2341666666E669235A410000000031EC23416666660676235A413333333367EC23419A9999797A235A4100000000B5EC23410000000081235A41CDCCCCCCD0EC23410000008083235A4166666666F7EC23413333331387235A419A99999912ED23416666668688235A419A9999990EED2341000000A089235A41CDCCCCCCF5EC2341666666C690235A4166666666D4EC23410000004099235A419A999999CCEC2341333333B39B235A4100000000D0EC2341666666069C235A41CDCCCCCCD1EC2341000000609C235A4166666666D2EC2341333333D39C235A4133333333D2EC2341666666469D235A4100000000D1EC2341666666A69D235A41CDCCCCCCCEEC2341000000009E235A4100000000CCEC23419A9999399E235A4133333333C8EC23419A9999599E235A4133333333C3EC2341CDCCCC4C9E235A4100000000ADEC2341333333B3A3235A41CDCCCCCC88EC234166666626AE235A413333333359EC2341666666C6BA235A41CDCCCCCC4CEC2341CDCCCC0CBE235A413333333345EC23419A999919C0235A410000000034EC23419A9999D9C4235A416666666631EC2341666666A6C5235A41CDCCCCCC1DEC2341CDCCCC8CCB235A419A99999913EC23419A999979CF235A410000000010EC2341333333B3D1235A413333333304EC2341CDCCCC0CDC235A41CDCCCCCC9CEC2341CDCCCC2CE3235A41CDCCCCCC9DEC2341333333F3E2235A4166666666C4EC234133333373D9235A4166666666CAEC23419A9999F9D7235A4133333333D7EC234166666606D8235A419A999999E8EC2341666666E6D8235A416666666629ED234166666646DC235A416666666649ED234133333313DE235A41CDCCCCCC72ED2341CDCCCCCCE0235A419A9999997CED234133333373E1235A416666666693ED2341000000A0E3235A4133333333F4ED2341666666E6EC235A416666666609EE23419A999939EF235A41333333331AEE23419A9999F9ED235A41CDCCCCCC2CEE234133333393EC235A410000000046EE23419A9999B9EA235A419A99999974EE234100000040E7235A41CDCCCCCC8CEE23419A999979E5235A4166666666B1EE2341000000C0E2235A4166666666C0EE2341000000A0E1235A416666666619EF234166666606DB235A41333333334EEF234166666666D7235A419A9999998BEF2341333333F3D2235A41CDCCCCCC3DF0234100000000C6235A4100000000A4F0234133333373BE235A410000000002F12341000000C0B7235A41CDCCCCCC46F12341CDCCCCACB2235A41CDCCCCCC80F1234100000060AE235A416666666688F1234100000020AD235A413333333391F1234133333333AC235A419A9999999BF1234133333353AB235A4133333333A8F123419A999939AA235A4133333333ACF12341333333D3A9235A4100000000B2F1234133333313A9235A4133333333BAF12341CDCCCCACA7235A4166666666C5F1234100000080A7235A4100000000D0F1234100000060A7235A41CDCCCCCCD8F1234166666646A7235A41CDCCCCCCD8F1234133333333A7235A41CDCCCCCCD9F1234166666646A2235A41CDCCCCCCDCF12341CDCCCC0C95235A4133333333DFF12341000000E089235A4133333333E2F12341666666C67D235A4133333333D9F123419A9999F97D235A419A999999C8F123419A9999F97C235A41CDCCCCCC74F123419A9999F977235A410000000030F12341333333F373235A416666666606F123413333337370235A41CDCCCCCCE2F023419A9999396D235A4166666666A7F023419A99993967235A419A9999999EF023410000006066235A4100000000BEEF23416666664652235A4100000000FAEF23413333331345235A41000000000CF023410000002041235A4166666666F7EF2341666666062E235A419A999999DFEF2341000000402C235A410000000055EF2341000000A021235A4133333333E0EE2341666666C618235A419A999999FEEE23410000004013235A41CDCCCCCC22EF23419A9999990C235A41333333332AEF2341666666460B235A419A99999942EF23413333339306235A419A99999967EF2341333333B3FF225A41000000007FEF2341CDCCCC6CFB225A4100000000ACEF23419A9999D9F3225A419A999999C5EF23419A999999EF225A4100000000DEEF234100000080EB225A419A999999EBEF234100000040E9225A41666666661AF02341666666C6E1225A41CDCCCCCC3EF0234166666606DC225A416666666653F02341666666E6D8225A41333333332FF02341CDCCCC4CD2225A4100000000F0EF234133333393C7225A4133333333E1EF2341CDCCCCCCC4225A41CDCCCCCCCFEF234133333373C1225A4166666666C2EF23419A999959BE225A41CDCCCCCC9FEF2341CDCCCCECBE225A416666666696EF234166666626C0225A419A99999988EF2341666666E6C1225A410000000076EF234133333333C4225A410000000061EF2341666666C6C6225A41666666664AEF23419A999999C9225A419A99999933EF234100000080CC225A41666666661BEF234133333393CF225A413333333303EF2341000000A0D2225A4166666666EDEE23419A999959D5225A419A999999DEEE2341CDCCCC2CD7225A419A999999D9EE2341CDCCCCECD7225A4166666666CCEE234100000000DA225A419A999999C3EE23419A9999D9DB225A4166666666BFEE2341666666A6DC225A4166666666B7EE234100000040DE225A4166666666ADEE234100000060E0225A4100000000A2EE23419A9999F9E2225A41333333339BEE2341666666A6E4225A410000000095EE234100000020E6225A410000000083EE2341CDCCCCACE9225A41CDCCCCCC6FEE2341CDCCCC6CED225A41666666665AEE23419A999999F1225A413333333344EE23419A9999F9F5225A41333333332EEE234166666646FA225A413333333318EE234166666686FE225A419A99999905EE23419A99991902235A41CDCCCCCCF8ED23416666668604235A4100000000EDED2341666666C606235A419A999999D9ED2341CDCCCC6C0A235A4100000000C8ED23419A9999D90D235A41CDCCCCCCB4ED23410000002010235A419A999999A3ED2341666666A612235A419A99999991ED23416666662616235A41333333337EED2341000000001A235A41000000006CED23419A9999991D235A41333333335EED23410000004020235A413333333354ED2341CDCCCCAC21235A41CDCCCCCC50ED23413333337321235A41000000004CED23419A99997921235A410000000048ED23419A9999B921235A41CDCCCCCC46ED2341333333F321235A419A99999945ED23416666666622235A41000000003FED23419A99999922235A410000000038ED23413333337322235A413333333323ED2341000000E020235A41666666660CED23419A9999191F235A4133333333F5EC2341666666261D235A4166666666E2EC2341CDCCCCAC1B235A4133333333C0EC23416666660619235A41CDCCCCCCB0EC2341666666A617235A41CDCCCCCC9CEC2341CDCCCC4C16235A416666666683EC2341CDCCCC6C14235A41333333336DEC2341000000C012235A41CDCCCCCC60EC2341666666C612235A419A99999952EC2341CDCCCC0C13235A410000000045EC23419A9999B913235A41CDCCCCCC2AEC2341333333D318235A41000000000EEC2341CDCCCC6C1E235A4133333333F3EB23416666668623235A4133333333CCEB23419A9999D92A235A4100000000BAEB2341333333332E235A416666666683EB2341000000A035235A41CDCCCCCCEAEA2341333333F34A235A4100000000D9EA2341000000804D235A4133333333C7EA2341333333D34F235A4133333333B2EA23413333339352235A419A999999A7EA2341CDCCCC0C54235A41	01060000206A08000001000000010300000001000000270000009A999999A7EA2341CDCCCC0C54235A4166666666D1EA2341000000E058235A4100000000B5EC23410000000081235A419A99999912ED23416666668688235A41CDCCCCCC1DEC2341CDCCCC8CCB235A413333333304EC2341CDCCCC0CDC235A41CDCCCCCC9CEC2341CDCCCC2CE3235A4166666666CAEC23419A9999F9D7235A416666666649ED234133333313DE235A419A9999997CED234133333373E1235A416666666609EE23419A999939EF235A41CDCCCCCC80F1234100000060AE235A4133333333BAF12341CDCCCCACA7235A41CDCCCCCCD8F1234166666646A7235A4133333333E2F12341666666C67D235A4133333333D9F123419A9999F97D235A410000000030F12341333333F373235A419A9999999EF023410000006066235A4100000000BEEF23416666664652235A41000000000CF023410000002041235A4166666666F7EF2341666666062E235A4133333333E0EE2341666666C618235A41000000007FEF2341CDCCCC6CFB225A419A999999EBEF234100000040E9225A416666666653F02341666666E6D8225A4100000000F0EF234133333393C7225A4166666666C2EF23419A999959BE225A41CDCCCCCC9FEF2341CDCCCCECBE225A419A999999DEEE2341CDCCCC2CD7225A410000000095EE234100000020E6225A4100000000C8ED23419A9999D90D235A419A999999A3ED2341666666A612235A41333333335EED23410000004020235A410000000038ED23413333337322235A41333333336DEC2341000000C012235A410000000045EC23419A9999B913235A4100000000BAEB2341333333332E235A419A999999A7EA2341CDCCCC0C54235A419A999999A7EA2341CDCCCC0C54235A41	01010000206A080000535555A554ED23416666667656235A41	940210105	H	Bretagne 2	9402101	94021	94	11	1
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	01010000206A080000F0EEEE4EA2E623410000003027235A41	940210101	A	Marché d'Intérêt National Paris-Rungis	9402101	94021	94	11	2
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	01060000206A080000010000000103000000010000003A0000009A9999998FDD23419A9999393C235A419A999999B8DD23419A9999D941235A41CDCCCCCC13DE23413333339358235A413333333386DE23413333339383235A4166666666EBDE234100000020AB235A419A99999927DF234166666606C1235A41000000006DDF234100000000D6235A4166666666BDDE2341CDCCCC8CE2235A4133333333B2DE2341333333D3DE235A413333333339DE2341CDCCCC2CE6235A41000000008EDE23419A9999D9FB235A416666666625DF2341CDCCCC4C1E245A416666666674DF23419A99997932245A413333333334E02341333333B32B245A413333333343E02341CDCCCC6C31245A410000000099E023419A9999192E245A4166666666BFE023419A9999D93D245A41CDCCCCCCD4E023413333339342245A419A9999992AE123419A9999F949245A410000000073E223419A9999D93D245A41CDCCCCCCCBE32341CDCCCCAC2F245A419A99999965E32341333333D30D245A41666666661FE323419A99997911245A419A99999987E223419A9999F9E0235A41666666664FE22341666666A6E3235A413333333341E223419A999939E1235A41CDCCCCCCF1E0234100000040F0235A4100000000B1E02341CDCCCC2CDC235A41000000006BE0234133333313C4235A4166666666ABE12341CDCCCCCCB4235A4166666666C7E1234166666626B5235A4100000000CBE223419A9999F9A8235A4100000000C9E223419A999939A7235A41666666666BE32341666666C6A1235A41CDCCCCCC3CE42341666666269C235A416666666628E42341333333D398235A4133333333DBE32341CDCCCCEC7F235A419A999999B4E323413333335376235A419A99999980E32341CDCCCC2C6C235A413333333313E323419A9999195C235A4100000000FFE12341CDCCCC2C3A235A4166666666D0E12341333333B332235A41000000003FE123410000002023235A413333333354E123416666660612235A41CDCCCCCC7EE12341CDCCCCAC03235A4166666666E3E123419A999939EF225A419A9999997CE0234100000060B2225A41CDCCCCCC03E02341CDCCCCCCBA225A413333333368DF23419A9999B9CC225A410000000000DF234133333373D9225A413333333388DF234166666686E4225A41CDCCCCCCFADF234133333373F2225A419A999999B6E023419A9999390F235A416666666617DF2341666666062C235A41666666661ADE2341000000A03C235A4100000000F8DD23416666668634235A419A9999998FDD23419A9999393C235A419A9999998FDD23419A9999393C235A41	01010000206A080000000000C026E12341CDCCCC5C7E235A41	940210102	H	Larue 1	9402101	94021	94	11	1
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	01060000206A08000001000000010300000001000000350000009A9999995DE52341CDCCCC2CE2235A419A9999996EE52341666666A6FD235A419A99999977E6234100000060F6235A41666666662BE7234133333373F0235A416666666669E72341333333D3ED235A416666666697E7234100000060F5235A41CDCCCCCCF8E72341CDCCCCCC11245A413333333333E823413333335324245A41666666669EE82341333333D33A245A4133333333BCE82341333333B338245A416666666647E92341333333132B245A410000000098E92341000000E024245A41CDCCCCCCAFE92341333333932E245A4100000000FDE92341666666663C245A416666666649EA23419A9999394E245A41666666666DEA2341000000003F245A4166666666A0EA2341666666C624245A419A99999901EB2341666666E610245A419A99999928EB2341CDCCCC4C0A245A419A99999941EC2341000000601F245A4133333333C4EC2341333333B305245A410000000034EE2341CDCCCC2C23245A41000000007CEE2341CDCCCC2C27245A4166666666A7EE2341333333B31F245A4166666666BCEE2341333333F311245A4166666666AEEE2341000000A007245A41666666664BEE23410000000009245A419A999999AAED2341CDCCCC6CFB235A41666666668FED23419A9999D9F7235A416666666609EE23419A999939EF235A419A9999997CED234133333373E1235A416666666649ED234133333313DE235A4166666666CAEC23419A9999F9D7235A41CDCCCCCC9CEC2341CDCCCC2CE3235A413333333304EC2341CDCCCC0CDC235A41CDCCCCCC1DEC2341CDCCCC8CCB235A413333333345EC23419A999919C0235A419A99999912ED23416666668688235A4100000000B5EC23410000000081235A4166666666D1EA2341000000E058235A419A999999A7EA2341CDCCCC0C54235A416666666688EA23410000002058235A4133333333C7E8234100000000AF235A419A99999976E823419A999999BA235A4133333333EEE7234133333393C7235A419A9999999DE7234133333393CC235A41333333332AE72341333333D3D0235A419A99999934E6234100000020D5235A4133333333EBE52341333333D3D3235A4100000000D0E52341333333D3CF235A4100000000BBE5234100000080D4235A419A9999995DE52341CDCCCC2CE2235A419A9999995DE52341CDCCCC2CE2235A41	01010000206A080000B083B71595E923419A999929D1235A41	940210106	H	Centre	9402101	94021	94	11	0
01060000206A080000010000000103000000010000002B0000006666666649EA23419A9999394E245A41CDCCCCCC56EA23419A9999F94F245A41CDCCCCCC65EA2341CDCCCC8C51245A41CDCCCCCCA2EA23410000002057245A4133333333C6EA2341333333135A245A419A999999F9EA23419A9999395E245A419A99999967EB2341000000A066245A413333333381EB2341CDCCCCAC68245A419A999999CCEB2341CDCCCCCC6E245A4100000000E6EB2341666666E669245A41000000004AEC23410000004056245A416666666662EC23419A99997951245A419A999999EEEC23419A99995935245A4166666666F6EC2341666666C633245A416666666611EE2341333333734A245A41CDCCCCCC44EE23419A9999794E245A419A999999A7EE2341CDCCCC2C56245A4100000000D4EE2341666666A659245A4100000000F1EE2341CDCCCCEC53245A419A999999F1EE23419A9999B952245A4133333333EAEE23419A99993951245A410000000011EE23410000002040245A4133333333ADED23413333335338245A419A9999996CED2341CDCCCC6C33245A4100000000E4ED2341333333931C245A41CDCCCCCCB3ED2341CDCCCCCC18245A416666666679ED23416666660614245A41CDCCCCCC55ED23410000002011245A4133333333C4EC2341333333B305245A416666666670EC2341666666E615245A41CDCCCCCC41EC23419A9999591F245A419A99999941EC2341000000601F245A41666666661EEC23419A9999B91C245A419A99999928EB2341CDCCCC4C0A245A419A99999910EB2341000000200E245A419A99999901EB2341666666E610245A4100000000D8EA23416666664619245A4133333333B4EA23416666668620245A4166666666A0EA2341666666C624245A416666666682EA2341666666E633245A41666666666DEA2341000000003F245A41CDCCCCCC59EA23419A99993947245A416666666649EA23419A9999394E245A41	01060000206A08000001000000010300000001000000130000006666666649EA23419A9999394E245A41CDCCCCCCA2EA23410000002057245A419A999999CCEB2341CDCCCCCC6E245A416666666662EC23419A99997951245A4166666666F6EC2341666666C633245A416666666611EE2341333333734A245A4100000000D4EE2341666666A659245A4100000000F1EE2341CDCCCCEC53245A4133333333EAEE23419A99993951245A419A9999996CED2341CDCCCC6C33245A4100000000E4ED2341333333931C245A4133333333C4EC2341333333B305245A419A99999941EC2341000000601F245A419A99999928EB2341CDCCCC4C0A245A419A99999901EB2341666666E610245A4166666666A0EA2341666666C624245A41666666666DEA2341000000003F245A416666666649EA23419A9999394E245A416666666649EA23419A9999394E245A41	01010000206A080000F00D6D6CA1EB23419A9999A93B245A41	940210107	H	Sorbiers	9402101	94021	94	11	0
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	01060000206A08000001000000010300000001000000190000009A999999CCEB2341CDCCCCCC6E245A419A999999B6EC23416666662680245A41333333334CED2341CDCCCCCC8B245A41CDCCCCCC9DEE23419A9999999F245A419A999999B2EF2341CDCCCC4CB2245A41CDCCCCCC93F12341CDCCCC8CD1245A419A99999991F1234100000040C2245A4133333333A2F123419A99995983245A416666666690F12341666666E681245A413333333344F12341333333B383245A41CDCCCCCC38F023413333339351245A4100000000E2EF23419A99999958245A4166666666A7EE2341333333B31F245A41000000007CEE2341CDCCCC2C27245A410000000034EE2341CDCCCC2C23245A4100000000E4ED2341333333931C245A419A9999996CED2341CDCCCC6C33245A4133333333EAEE23419A99993951245A4100000000F1EE2341CDCCCCEC53245A4100000000D4EE2341666666A659245A416666666611EE2341333333734A245A4166666666F6EC2341666666C633245A416666666662EC23419A99997951245A419A999999CCEB2341CDCCCCCC6E245A419A999999CCEB2341CDCCCCCC6E245A41	01010000206A080000BE880DFEA9EE23413333334378245A41	940210108	H	Saussaie	9402101	94021	94	11	0
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	01060000206A0800000100000001030000000100000012000000666666668FED23419A9999D9F7235A419A999999AAED2341CDCCCC6CFB235A41666666664BEE23410000000009245A4166666666AEEE2341000000A007245A4166666666BCEE2341333333F311245A4166666666A6EE2341CDCCCC8C1F245A4100000000E2EF23419A99999958245A41CDCCCCCC38F023413333339351245A413333333344F12341333333B383245A416666666690F12341666666E681245A4133333333A2F123419A99995983245A4100000000C2F123419A99991900245A41CDCCCCCCD8F1234166666646A7235A4133333333BAF12341CDCCCCACA7235A41CDCCCCCC80F1234100000060AE235A416666666609EE23419A999939EF235A41666666668FED23419A9999D9F7235A41666666668FED23419A9999D9F7235A41	01010000206A08000081F918ED3AF02341333333F315245A41	940210109	H	La Guinet	9402101	94021	94	11	0
01060000206A080000010000000103000000010000003A00000033333333C10824410000006092235A41CDCCCCCCE9082441CDCCCCCC94235A413333333315092441CDCCCC6C97235A41333333332B0924410000002098235A410000000058092441333333D399235A410000000060092441666666469A235A41CDCCCCCC67092441000000E09A235A41666666666D092441CDCCCC8C9B235A41CDCCCCCC7A092441000000A09A235A410000000084092441333333539A235A41666666668D092441000000209A235A41CDCCCCCC9E092441000000009A235A4133333333B40924419A9999B999235A41CDCCCCCCC3092441333333939A235A4133333333CB092441000000E09A235A419A999999D2092441000000009B235A41CDCCCCCC040A2441CDCCCCAC9A235A41000000002B0A2441666666669A235A41666666663A0A24419A9999599A235A4166666666430A2441000000209A235A4166666666490A2441CDCCCCCC99235A41666666664D0A2441CDCCCC2C99235A419A9999994F0A24413333335397235A4166666666520A24413333339391235A419A999999570A2441CDCCCCAC84235A419A999999580A24416666664681235A4100000000590A2441666666C67E235A4133333333520A24419A9999797C235A419A9999994B0A2441666666067A235A419A9999994E0A2441CDCCCC0C73235A41CDCCCCCC4D0A2441CDCCCCEC6D235A4166666666520A24419A99993967235A4100000000550A24416666664660235A4100000000540A2441333333F359235A4166666666540A24410000008056235A419A999999540A2441CDCCCC2C55235A4133333333440A24410000006054235A419A9999991D0A2441666666A651235A4166666666CA092441000000804D235A419A999999C3092441000000804E235A4100000000BD0924419A9999D94F235A41CDCCCCCCAB092441666666E654235A41CDCCCCCC7D0924410000004062235A419A9999997C0924410000002063235A41CDCCCCCC7C0924416666660664235A41CDCCCCCC7F0924410000008065235A41CDCCCCCC830924419A99997966235A41000000008A0924419A99997967235A419A99999981092441333333B369235A41000000004E0924413333335378235A413333333342092441333333B37B235A419A9999993D092441333333737C235A413333333336092441000000207D235A413333333331092441000000607D235A4166666666290924419A9999797D235A4100000000EB082441666666C67B235A41CDCCCCCCD4082441CDCCCC0C7B235A4133333333C10824410000006092235A41	01060000206A080000010000000103000000010000001200000033333333C10824410000006092235A41666666666D092441CDCCCC8C9B235A4133333333B40924419A9999B999235A419A999999D2092441000000009B235A41666666663A0A24419A9999599A235A419A9999994F0A24413333335397235A4100000000590A2441666666C67E235A419A9999994B0A2441666666067A235A4100000000550A24416666664660235A419A999999540A2441CDCCCC2C55235A4166666666CA092441000000804D235A41CDCCCCCC7D0924410000004062235A41000000008A0924419A99997967235A413333333342092441333333B37B235A4166666666290924419A9999797D235A41CDCCCCCCD4082441CDCCCC0C7B235A4133333333C10824410000006092235A4133333333C10824410000006092235A41	01010000206A0800007ABEB762D2092441000000B075235A41	940220102	H	Centre I	9402201	94022	94	11	0
01060000206A08000001000000010300000001000000330000006666666650072441666666E626235A41CDCCCCCC610724410000002028235A413333333376072441CDCCCC8C29235A41333333339D072441666666062C235A4166666666CF072441666666062F235A4133333333090824410000008032235A41000000004D082441CDCCCCEC36235A41000000008B082441000000E03B235A41CDCCCCCC9E082441000000603D235A4100000000C0082441666666263F235A41CDCCCCCC1F0924413333333344235A419A9999993D092441666666C645235A416666666673092441000000C048235A4166666666CA092441000000804D235A419A9999991D0A2441666666A651235A4133333333440A24410000006054235A419A999999540A2441CDCCCC2C55235A4100000000550A24419A99993952235A419A999999560A24419A99991947235A4100000000590A2441333333133B235A419A999999590A24416666664638235A41CDCCCCCC590A24413333339337235A4166666666590A2441333333B335235A4100000000580A24413333337334235A4133333333550A2441000000A033235A41CDCCCCCC4C0A24416666664632235A4133333333470A2441CDCCCCAC31235A41CDCCCCCC280A2441666666A62D235A41000000001A0A2441333333132C235A4100000000100A2441666666662B235A419A999999030A2441CDCCCCCC2A235A4166666666F0092441333333F329235A419A999999010A2441CDCCCCCC24235A41CDCCCCCC1D0A2441333333531C235A419A9999992C0A24419A9999F917235A4100000000330A2441000000E014235A4133333333510A24413333333305235A41CDCCCCCC5E0A2441CDCCCCCCFD225A4100000000740A244133333373F3225A419A999999540A2441333333D3F1225A41CDCCCCCC070A24419A9999D9ED225A41CDCCCCCC95092441000000E0E7225A410000000011092441CDCCCCCCE0225A41666666667B082441333333B3D8225A41666666663408244133333333EE225A41000000002808244166666646F2225A419A9999990B082441000000C0F0225A419A999999FF07244100000040F3225A419A999999AD072441CDCCCC8C0B235A419A99999957072441666666C624235A416666666650072441666666E626235A41	01060000206A08000001000000010300000001000000100000006666666650072441666666E626235A41000000004D082441CDCCCCEC36235A41CDCCCCCC9E082441000000603D235A419A999999540A2441CDCCCC2C55235A41CDCCCCCC590A24413333339337235A4133333333550A2441000000A033235A41CDCCCCCC280A2441666666A62D235A4166666666F0092441333333F329235A419A9999992C0A24419A9999F917235A4100000000740A244133333373F3225A41CDCCCCCC95092441000000E0E7225A41666666667B082441333333B3D8225A41000000002808244166666646F2225A419A999999FF07244100000040F3225A416666666650072441666666E626235A416666666650072441666666E626235A41	01010000206A080000D6916E29DC082441CDCCCC6C16235A41	940220105	H	Centre Sud	9402201	94022	94	11	0
01060000206A080000010000000103000000010000002E000000CDCCCCCC1A0324410000000054235A4133333333610324419A99993956235A41333333339A0324413333331358235A419A999999B70324416666660659235A4100000000E50324419A9999795A235A4100000000D20424419A99991962235A41CDCCCCCC520524413333335366235A4100000000E5052441000000E06A235A416666666649062441CDCCCCEC6D235A41666666665A062441000000806E235A4100000000710624419A99993970235A410000000074062441333333D36B235A4166666666970624410000004061235A419A999999A00624419A9999995E235A41CDCCCCCCB10624413333339359235A419A999999BC062441333333F355235A41CDCCCCCCC1062441000000E053235A419A999999C40624416666664652235A41CDCCCCCCC60624419A9999F950235A41CDCCCCCCC80624416666660650235A4133333333D70624419A9999D94A235A41CDCCCCCCEB062441CDCCCCAC44235A4166666666F40624419A99991942235A41CDCCCCCCFF062441333333F33E235A419A99999932072441666666E62F235A4166666666480724410000006029235A416666666650072441666666E626235A4133333333ED0424416666660605235A4166666666DD042441CDCCCC6C06235A41CDCCCCCCCA0424413333333307235A410000000097042441666666C608235A41333333339A042441000000C00A235A41666666669D042441000000600C235A41333333339F0424419A9999590D235A4133333333A2042441666666E60E235A41CDCCCCCC8E042441000000800F235A41666666667D042441666666E60F235A41000000007E042441666666A613235A41000000007C0424416666662616235A413333333377042441666666C618235A41666666666F042441333333731B235A41CDCCCCCC62042441333333D31D235A41CDCCCCCC32042441CDCCCCAC23235A413333333326042441000000C025235A419A99999967032441333333F345235A41CDCCCCCC1A0324410000000054235A41	01060000206A0800000100000001030000000100000012000000CDCCCCCC1A0324410000000054235A41CDCCCCCC520524413333335366235A41666666665A062441000000806E235A4100000000710624419A99993970235A410000000074062441333333D36B235A41CDCCCCCCB10624413333339359235A4133333333D70624419A9999D94A235A416666666650072441666666E626235A4133333333ED0424416666660605235A410000000097042441666666C608235A4133333333A2042441666666E60E235A41666666667D042441666666E60F235A413333333377042441666666C618235A41CDCCCCCC62042441333333D31D235A41CDCCCCCC32042441CDCCCCAC23235A419A99999967032441333333F345235A41CDCCCCCC1A0324410000000054235A41CDCCCCCC1A0324410000000054235A41	01010000206A080000516F7A636B052441CCCCCC6C37235A41	940220111	H	Parc Maurice-Thorez	9402201	94022	94	11	0
01060000206A080000010000000103000000010000001B00000033333333ED0424416666660605235A416666666650072441666666E626235A419A99999957072441666666C624235A419A999999AD072441CDCCCC8C0B235A419A999999FF07244100000040F3225A419A9999990B082441000000C0F0225A41000000002808244166666646F2225A41666666663408244133333333EE225A41666666667B082441333333B3D8225A4166666666890824419A999959D4225A41666666668808244100000020D4225A41666666667C0824419A999999D3225A416666666676082441CDCCCC4CD3225A413333333323082441000000E0CE225A41CDCCCCCCC20724419A999999C9225A416666666648072441666666E6C2225A41333333333D06244166666646B5225A4133333333160624419A999979D1225A41000000000D06244166666666D5225A4166666666010624419A999979D9225A4133333333BA052441CDCCCCECE4225A4100000000590524419A9999D9F5225A416666666616052441666666A600235A41CDCCCCCC0F0524419A99997901235A416666666600052441CDCCCC4C03235A4166666666F1042441666666A604235A4133333333ED0424416666660605235A41	01060000206A080000010000000103000000010000000C00000033333333ED0424416666660605235A416666666650072441666666E626235A419A999999FF07244100000040F3225A41000000002808244166666646F2225A4166666666890824419A999959D4225A416666666648072441666666E6C2225A41333333333D06244166666646B5225A4133333333160624419A999979D1225A4166666666010624419A999979D9225A416666666616052441666666A600235A4133333333ED0424416666660605235A4133333333ED0424416666660605235A41	01010000206A080000B87A06A4F106244100000090E9225A41	940220112	H	Général-Leclerc	9402201	94022	94	11	0
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	01060000206A080000010000000103000000010000001E000000333333333D06244166666646B5225A416666666648072441666666E6C2225A4166666666890824419A999959D4225A41666666667B082441333333B3D8225A41CDCCCCCC95092441000000E0E7225A4100000000740A244133333373F3225A419A9999992C0A24419A9999F917235A4166666666F0092441333333F329235A41CDCCCCCC280A2441666666A62D235A4133333333550A2441000000A033235A41CDCCCCCC590A24413333339337235A419A999999540A2441CDCCCC2C55235A41000000008C0A2441000000E057235A4133333333990A24419A9999F938235A4100000000BA0A2441000000E018235A4133333333E70A2441CDCCCC6C01235A41CDCCCCCC250B244133333393E8225A4166666666960B244133333353C6225A41CDCCCCCC260C24419A9999799D225A4133333333700C24410000008089225A41CDCCCCCCF70B2441333333F388225A419A999999960B24413333331384225A4133333333560B24410000006097225A4166666666A2092441CDCCCCAC80225A4100000000BB092441CDCCCC4C79225A419A999999B0072441000000A05D225A4166666666C50624419A9999B951225A41000000005E062441CDCCCC4C9E225A41333333333D06244166666646B5225A41333333333D06244166666646B5225A41	01010000206A0800001BF33F0FF4092441CDCCCC8CD5225A41	940220113	H	République	9402201	94022	94	11	0
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	01060000206A0800000100000001030000000100000016000000000000008C0A2441000000E057235A419A999999390B24419A99995960235A4133333333530B24416666666658235A4133333333EF0B24419A9999F938235A419A999999AF0C24419A9999F91B235A4100000000340E2441666666C6ED225A4166666666730E244100000080E3225A419A999999F20D2441000000E0CD225A4100000000E60C2441666666A6AD225A4133333333CA0C2441666666E6AB225A4166666666B70C244133333393A4225A41CDCCCCCCBB0C2441666666C68F225A41666666669A0C2441666666268A225A4133333333700C24410000008089225A41CDCCCCCC260C24419A9999799D225A4166666666960B244133333353C6225A41CDCCCCCC250B244133333393E8225A4133333333E70A2441CDCCCC6C01235A4100000000BA0A2441000000E018235A4133333333990A24419A9999F938235A41000000008C0A2441000000E057235A41000000008C0A2441000000E057235A41	01010000206A0800002F2BDC628B0C2441CCCCCCDCF2225A41	940220114	H	Port	9402201	94022	94	11	0
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	01060000206A080000010000000103000000010000002100000066666666C50624419A9999B951225A419A999999B0072441000000A05D225A4100000000BB092441CDCCCC4C79225A4166666666A2092441CDCCCCAC80225A4133333333560B24410000006097225A419A999999960B24413333331384225A41CDCCCCCCF70B2441333333F388225A41666666668C0C2441CDCCCCAC89225A41CDCCCCCCBB0C2441666666C68F225A4166666666B70C244133333393A4225A4133333333CA0C2441666666E6AB225A4100000000E60C2441666666A6AD225A419A999999F20D2441000000E0CD225A4166666666730E244100000080E3225A4133333333F40E2441CDCCCCACCE225A4166666666560F24419A999999B5225A41666666661E102441CDCCCCEC66225A41666666668F102441666666C632225A416666666630112441666666060B225A419A9999993E122441CDCCCC2CE2215A41CDCCCCCC91102441666666E6B0215A4100000000121024419A9999B9A0215A4133333333AF0F2441000000C090215A4166666666880E244100000080E8215A4166666666A80D24419A999959DD215A4166666666CE0C2441000000801E225A4133333333120C24413333339314225A41CDCCCCCC210B24419A99997908225A4100000000CD0A24416666664621225A4166666666660A2441333333331C225A410000000032072441000000C002225A4166666666C50624419A9999B951225A4166666666C50624419A9999B951225A41	01010000206A08000012904008B90B24416666667636225A41	940220106	H	Parc Prairie II	9402201	94022	94	11	1
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	01060000206A080000010000000103000000010000000F0000000000000032072441000000C002225A4166666666660A2441333333331C225A4100000000CD0A24416666664621225A41CDCCCCCC210B24419A99997908225A4133333333120C24413333339314225A4166666666CE0C2441000000801E225A4166666666A80D24419A999959DD215A4100000000060C244166666646C7215A4166666666F20B2441000000C0D0215A4100000000C60B2441CDCCCCACDD215A4133333333790A244133333313D3215A419A99999915092441000000A0C5215A4166666666980724419A9999F9B7215A410000000032072441000000C002225A410000000032072441000000C002225A41	01010000206A08000085DA7497570A244100000080F1215A41	940220107	H	Hautes Bornes Navigateurs I	9402201	94022	94	11	0
01060000206A080000010000000103000000010000003800000000000000710624419A99993970235A41CDCCCCCC7D0624416666664671235A41CDCCCCCC8C0624413333339372235A419A999999DE0624419A99993977235A41CDCCCCCC440724419A9999B97C235A410000000091072441333333D380235A4100000000D2072441CDCCCC4C84235A4133333333C10824410000006092235A41CDCCCCCCD4082441CDCCCC0C7B235A4100000000EB082441666666C67B235A4166666666290924419A9999797D235A413333333331092441000000607D235A413333333336092441000000207D235A419A9999993D092441333333737C235A413333333342092441333333B37B235A41000000004E0924413333335378235A419A99999981092441333333B369235A41000000008A0924419A99997967235A41CDCCCCCC830924419A99997966235A41CDCCCCCC7F0924410000008065235A41CDCCCCCC7C0924416666660664235A419A9999997C0924410000002063235A41CDCCCCCC7D0924410000004062235A41CDCCCCCCAB092441666666E654235A4100000000BD0924419A9999D94F235A419A999999C3092441000000804E235A4166666666CA092441000000804D235A416666666673092441000000C048235A419A9999993D092441666666C645235A41CDCCCCCC1F0924413333333344235A4100000000C0082441666666263F235A41CDCCCCCC9E082441000000603D235A41000000008B082441000000E03B235A41000000004D082441CDCCCCEC36235A4133333333090824410000008032235A4166666666CF072441666666062F235A41333333339D072441666666062C235A413333333376072441CDCCCC8C29235A41CDCCCCCC610724410000002028235A416666666650072441666666E626235A4166666666480724410000006029235A419A99999932072441666666E62F235A41CDCCCCCCFF062441333333F33E235A4166666666F40624419A99991942235A41CDCCCCCCEB062441CDCCCCAC44235A4133333333D70624419A9999D94A235A41CDCCCCCCC80624416666660650235A41CDCCCCCCC60624419A9999F950235A419A999999C40624416666664652235A41CDCCCCCCC1062441000000E053235A419A999999BC062441333333F355235A41CDCCCCCCB10624413333339359235A419A999999A00624419A9999995E235A4166666666970624410000004061235A410000000074062441333333D36B235A4100000000710624419A99993970235A41	01060000206A080000010000000103000000010000001200000000000000710624419A99993970235A41CDCCCCCC8C0624413333339372235A4100000000D2072441CDCCCC4C84235A4133333333C10824410000006092235A41CDCCCCCCD4082441CDCCCC0C7B235A4166666666290924419A9999797D235A413333333342092441333333B37B235A41000000008A0924419A99997967235A41CDCCCCCC7D0924410000004062235A4166666666CA092441000000804D235A41CDCCCCCC9E082441000000603D235A41000000004D082441CDCCCCEC36235A416666666650072441666666E626235A4133333333D70624419A9999D94A235A41CDCCCCCCB10624413333339359235A410000000074062441333333D36B235A4100000000710624419A99993970235A4100000000710624419A99993970235A41	01010000206A0800007969F61D1E082441666666165C235A41	940220108	H	Centre II	9402201	94022	94	11	0
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	01060000206A0800000100000001030000000100000020000000CDCCCCCC87032441CDCCCC8C4C245A419A99999976042441000000E053245A4166666666F1042441333333B336245A41666666666B052441666666A618245A416666666699072441CDCCCC8C29245A410000000093072441CDCCCCEC30245A4166666666160B2441666666C63A245A4100000000F00A2441CDCCCC4C09245A4166666666DA0A244133333333BE235A4133333333EA0A2441000000808B235A4166666666170B2441333333336B235A419A999999390B24419A99995960235A419A999999540A2441CDCCCC2C55235A4100000000550A24416666664660235A419A9999994B0A2441666666067A235A4100000000590A2441666666C67E235A419A9999994F0A24413333335397235A41666666663A0A24419A9999599A235A419A999999D2092441000000009B235A4133333333B40924419A9999B999235A41666666666D092441CDCCCC8C9B235A41333333332B0924410000002098235A41CDCCCCCC1B0824416666664695235A41CDCCCCCCD6072441CDCCCCACD5235A41CDCCCCCCC207244100000060EC235A419A99999980052441666666C6DC235A41333333330B052441CDCCCCCCD9235A4133333333B204244166666666F5235A4100000000420424410000004015245A4166666666D20324419A9999B937245A41CDCCCCCC87032441CDCCCC8C4C245A41CDCCCCCC87032441CDCCCC8C4C245A41	01010000206A080000B5A9C3B860092441000000F0C9235A41	940220109	H	Choisy Nord I	9402201	94022	94	11	0
01060000206A080000010000000103000000010000001F000000333333330B052441CDCCCCCCD9235A419A99999980052441666666C6DC235A41333333334A06244100000040E2235A41CDCCCCCCC207244100000060EC235A4166666666C607244133333333EA235A41CDCCCCCCC6072441CDCCCC6CE6235A41CDCCCCCCD6072441CDCCCCACD5235A4133333333050824419A999959AB235A41CDCCCCCC1B0824416666664695235A41333333336E0824419A99991996235A41333333332B0924410000002098235A413333333315092441CDCCCC6C97235A41CDCCCCCCE9082441CDCCCCCC94235A4133333333C10824410000006092235A4100000000D2072441CDCCCC4C84235A410000000091072441333333D380235A41CDCCCCCC440724419A9999B97C235A419A999999DE0624419A99993977235A41CDCCCCCC8C0624413333339372235A41CDCCCCCC7D0624416666664671235A4100000000710624419A99993970235A41666666663A062441666666E67F235A41333333330D062441333333338D235A416666666604062441000000C08F235A4133333333EF0524413333331396235A41666666669E0524419A9999F9AD235A41CDCCCCCC8F0524419A999979B2235A41666666667F05244133333353B7235A419A9999993E052441333333D3CA235A41CDCCCCCC0D05244100000000D9235A41333333330B052441CDCCCCCCD9235A41	01060000206A080000010000000103000000010000000D000000333333330B052441CDCCCCCCD9235A419A99999980052441666666C6DC235A41CDCCCCCCC207244100000060EC235A41CDCCCCCCD6072441CDCCCCACD5235A41CDCCCCCC1B0824416666664695235A41333333332B0924410000002098235A413333333315092441CDCCCC6C97235A4100000000D2072441CDCCCC4C84235A41CDCCCCCC8C0624413333339372235A4100000000710624419A99993970235A41666666663A062441666666E67F235A41333333330B052441CDCCCCCCD9235A41333333330B052441CDCCCCCCD9235A41	01010000206A080000AF70527ACB0624419A999939B0235A41	940220110	H	Choisy Nord II	9402201	94022	94	11	0
01060000206A080000010000000103000000010000004B00000066666666DA0A244133333333BE235A4100000000F00A2441CDCCCC4C09245A4166666666160B2441666666C63A245A419A999999210B24416666660641245A41CDCCCCCC330B2441000000A047245A4166666666610B24419A9999D956245A4100000000670B24410000006058245A4166666666780B2441000000005D245A41CDCCCCCC970B2441CDCCCCAC62245A4100000000970C2441000000A086245A41CDCCCCCCA70C2441CDCCCC8C89245A419A999999B80C2441666666868D245A419A999999430D24419A9999198B245A419A999999820D24419A9999F989245A4166666666960D2441CDCCCCAC89245A41CDCCCCCC870D24419A99999985245A41000000007B0D2441333333F381245A4133333333720D24419A9999597F245A41666666666B0D2441333333F37C245A4133333333660D2441666666667A245A4133333333620D2441333333F377245A41666666665F0D2441333333D375245A4166666666590D2441666666E670245A4100000000590D2441CDCCCC0C6F245A41000000005A0D2441000000806A245A41333333335D0D24416666664666245A419A999999620D24413333335361245A4100000000660D2441CDCCCC6C5E245A41CDCCCCCC670D24416666660656245A4133333333650D24413333335352245A41333333335F0D2441333333734E245A41333333335A0D2441000000A04B245A4166666666560D2441CDCCCC8C49245A4133333333510D24416666668647245A4166666666460D24413333333344245A41000000001E0D2441CDCCCCEC38245A419A999999F60C2441666666062E245A4133333333B60C24419A9999991B245A41CDCCCCCCA30C24419A99995916245A4166666666840C2441CDCCCCCC0D245A4166666666600C2441666666C603245A41333333334D0C244133333333FE235A4100000000480C244133333353FC235A41666666663C0C2441333333D3F7235A41000000001D0C2441666666A6EB235A41CDCCCCCC170C244166666686E9235A419A9999990C0C24419A999939E4235A41CDCCCCCC0A0C24419A9999F9DC235A4133333333070C24419A9999F9C6235A419A999999070C2441000000C0BA235A41666666660B0C244166666686B2235A41000000000E0C244133333333B0235A41333333331E0C244166666686A6235A41CDCCCCCC260C2441666666A6A1235A4133333333460C2441666666868E235A419A9999994F0C24419A9999D988235A41CDCCCCCC670C2441000000A079235A41000000006F0C24419A9999B977235A41CDCCCCCC770C2441CDCCCC6C74235A41000000007D0C24419A99999972235A41CDCCCCCC800C24410000000071235A419A999999250C2441666666666C235A419A999999ED0B2441CDCCCCCC69235A41CDCCCCCCC60B24410000004068235A41CDCCCCCCB60B2441CDCCCCAC67235A4133333333B70B24413333339367235A419A999999B90B2441000000A066235A4166666666990B2441CDCCCC0C65235A419A999999390B24419A99995960235A4166666666360B2441CDCCCC6C61235A4166666666170B2441333333336B235A419A999999010B2441000000C07A235A4133333333EA0A2441000000808B235A4133333333DB0A2441000000C0BB235A4166666666DA0A244133333333BE235A41	01060000206A080000010000000103000000010000001900000066666666DA0A244133333333BE235A4100000000F00A2441CDCCCC4C09245A4166666666160B2441666666C63A245A419A999999210B24416666660641245A4166666666610B24419A9999D956245A41CDCCCCCC970B2441CDCCCCAC62245A4100000000970C2441000000A086245A419A999999B80C2441666666868D245A4166666666960D2441CDCCCCAC89245A4133333333720D24419A9999597F245A4166666666590D2441666666E670245A4100000000660D2441CDCCCC6C5E245A4133333333650D24413333335352245A4166666666460D24413333333344245A41333333334D0C244133333333FE235A419A9999990C0C24419A999939E4235A4133333333070C24419A9999F9C6235A41000000000E0C244133333333B0235A41CDCCCCCC670C2441000000A079235A41CDCCCCCC800C24410000000071235A419A999999390B24419A99995960235A4166666666170B2441333333336B235A4133333333EA0A2441000000808B235A4166666666DA0A244133333333BE235A4166666666DA0A244133333333BE235A41	01010000206A080000C50A26F68A0B2441CCCCCCBCF1235A41	940220201	H	Gondoles Nord I	9402202	94022	94	11	0
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	01010000206A080000CC55D2B1FF1124419A9999896F225A41	940220202	H	Gondoles Sud I	9402202	94022	94	11	1
01060000206A08000001000000010300000001000000280000009A999999390B24419A99995960235A4166666666990B2441CDCCCC0C65235A419A999999B90B2441000000A066235A4133333333B70B24413333339367235A41CDCCCCCCB60B2441CDCCCCAC67235A41CDCCCCCCC60B24410000004068235A419A999999ED0B2441CDCCCCCC69235A419A999999250C2441666666666C235A41CDCCCCCC800C24410000000071235A4100000000880C24410000006071235A4133333333250D24419A9999D979235A4166666666830D2441CDCCCC0C7F235A4133333333C10D2441666666A682235A41CDCCCCCCD20D24413333335384235A41CDCCCCCC070E2441CDCCCC2C87235A4100000000350E2441CDCCCCAC89235A41000000008A0E2441666666468E235A41CDCCCCCCDD0E24419A9999D992235A4166666666E40E2441000000C090235A41CDCCCCCCE90E2441333333538F235A41CDCCCCCC5B0F2441333333D36E235A4100000000850F24410000008063235A419A999999960F2441333333335E235A416666666644102441000000A02D235A416666666669102441CDCCCCEC22235A4100000000BA0F2441CDCCCC2C19235A4100000000B20F24413333337318235A41CDCCCCCCF90E2441666666860E235A4133333333AC0E2441666666660A235A419A999999920E2441000000E008235A41333333336F0E24416666660607235A41000000006C0E24419A9999D906235A4133333333B70D24419A999999FC225A419A999999AF0C24419A9999F91B235A4133333333EF0B24419A9999F938235A419A9999995A0B2441666666E656235A4133333333530B24416666666658235A4100000000420B2441000000C05D235A41333333333C0B24419A9999795F235A419A999999390B24419A99995960235A41	01060000206A080000010000000103000000010000000F0000009A999999390B24419A99995960235A4100000000880C24410000006071235A4133333333C10D2441666666A682235A41CDCCCCCCD20D24413333335384235A41CDCCCCCCDD0E24419A9999D992235A419A999999960F2441333333335E235A416666666669102441CDCCCCEC22235A4100000000B20F24413333337318235A4133333333AC0E2441666666660A235A4133333333B70D24419A999999FC225A419A999999AF0C24419A9999F91B235A4133333333EF0B24419A9999F938235A4133333333530B24416666666658235A419A999999390B24419A99995960235A419A999999390B24419A99995960235A41	01010000206A0800007823CA93C50D2441000000F047235A41	940220203	H	Gondoles Sud II	9402202	94022	94	11	0
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	01060000206A0800000100000001030000000100000030000000CDCCCCCCDD0E24419A9999D992235A41CDCCCCCCC70F2441333333D39F235A4133333333171024419A9999B9A4235A41CDCCCCCC38122441CDCCCC0CC2235A419A9999990D142441000000E0DB235A41333333330F1424419A999919DA235A41333333337315244166666686ED235A41CDCCCCCCE91624416666666602245A419A999999CE162441666666A6DE235A4133333333C615244166666666D4235A419A999999EC152441CDCCCCCCC3235A419A999999E115244133333393BD235A41CDCCCCCCE015244133333313AF235A410000000093162441666666267D235A41CDCCCCCC411624416666668678235A419A9999995D162441333333136E235A4100000000941624419A9999F968235A41CDCCCCCC81172441000000E069235A41CDCCCCCC07182441CDCCCC2C6D235A419A9999999A1824416666664675235A4166666666F0182441333333D364235A419A9999991D192441000000C060235A413333333382192441CDCCCCAC5C235A41666666660F1A24419A9999394A235A4166666666291A2441000000A04B235A41000000008F1A2441000000E03D235A4166666666141B2441333333D32D235A4133333333A41A2441333333D31E235A4166666666501A2441333333D310235A4133333333301B2441666666E6F7225A4166666666681C2441CDCCCCECE8225A41333333337A1C244100000020DD225A4133333333F91B24419A9999B9CD225A41666666666119244133333333EE225A41CDCCCCCCCF172441CDCCCC6C0A235A4100000000A81724413333339307235A4133333333A71724419A9999D913235A41000000005D1724419A99993915235A416666666654162441CDCCCC0C27235A419A9999995E1524416666666635235A4133333333E8132441CDCCCC6C1C235A41CDCCCCCC871324413333339314235A419A999999831224419A99991901235A410000000004122441666666661B235A4166666666D5102441CDCCCCCC04235A419A999999960F2441333333335E235A41CDCCCCCCDD0E24419A9999D992235A41CDCCCCCCDD0E24419A9999D992235A41	01010000206A08000046AD3BF030142441CCCCCC9C66235A41	940220204	H	Gondoles Sud III	9402202	94022	94	11	1
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	01060000206A0800000100000001030000000100000015000000333333334D0C244133333333FE235A4166666666460D24413333333344245A4133333333650D24413333335352245A4100000000660D2441CDCCCC6C5E245A4166666666590D2441666666E670245A4133333333720D24419A9999597F245A4166666666960D2441CDCCCCAC89245A419A999999FF1124419A9999F975245A4166666666F5122441333333D371245A419A99999980142441666666466C245A419A9999991B1424419A9999D927245A41CDCCCCCCEC1324416666664603245A419A9999990D142441000000E0DB235A41CDCCCCCC38122441CDCCCC0CC2235A4133333333C3112441333333D3BB235A419A999999CB1124419A999939E7235A419A999999CC112441CDCCCC0CFA235A41CDCCCCCC0C11244166666606FB235A4100000000670D2441CDCCCC2CFD235A41333333334D0C244133333333FE235A41333333334D0C244133333333FE235A41	01010000206A0800008FF07FAF6F1024419A9999B921245A41	940220205	H	Gondoles Nord II	9402202	94022	94	11	1
01060000206A080000010000000103000000010000003A00000033333333070C24419A9999F9C6235A41CDCCCCCC0A0C24419A9999F9DC235A419A9999990C0C24419A999939E4235A41CDCCCCCC170C244166666686E9235A41000000001D0C2441666666A6EB235A41666666663C0C2441333333D3F7235A4100000000480C244133333353FC235A41333333334D0C244133333333FE235A4133333333E00C2441CDCCCCACFD235A4100000000670D2441CDCCCC2CFD235A419A999999FE0D2441000000E0FC235A4166666666630E2441666666A6FC235A4100000000B10E244166666666FC235A4133333333370F244133333333FC235A4100000000640F244166666606FC235A419A999999A20F2441666666E6FB235A41CDCCCCCC221024419A999999FB235A4100000000421024419A999999FB235A41333333338E10244133333353FB235A41CDCCCCCC0C11244166666606FB235A410000000072112441666666A6FA235A419A999999CC112441CDCCCC0CFA235A4166666666CD11244133333393F2235A419A999999CB1124419A999939E7235A4166666666C311244133333393C4235A419A999999C2112441666666C6BF235A419A999999C21124419A9999B9BE235A4133333333C3112441333333D3BB235A419A9999996311244100000080B6235A413333333309112441333333D3B1235A41CDCCCCCC7E102441CDCCCC6CAA235A4133333333171024419A9999B9A4235A4166666666DF0F2441CDCCCC6CA1235A41CDCCCCCCC70F2441333333D39F235A41000000009A0F24419A9999399D235A4133333333410F24413333335398235A41CDCCCCCCDD0E24419A9999D992235A41000000008A0E2441666666468E235A4100000000350E2441CDCCCCAC89235A41CDCCCCCC070E2441CDCCCC2C87235A41CDCCCCCCD20D24413333335384235A4133333333C10D2441666666A682235A4166666666830D2441CDCCCC0C7F235A4133333333250D24419A9999D979235A4100000000880C24410000006071235A41CDCCCCCC800C24410000000071235A41000000007D0C24419A99999972235A41CDCCCCCC770C2441CDCCCC6C74235A41000000006F0C24419A9999B977235A41CDCCCCCC670C2441000000A079235A419A9999994F0C24419A9999D988235A4133333333460C2441666666868E235A41CDCCCCCC260C2441666666A6A1235A41333333331E0C244166666686A6235A41000000000E0C244133333333B0235A41666666660B0C244166666686B2235A419A999999070C2441000000C0BA235A4133333333070C24419A9999F9C6235A41	01060000206A080000010000000103000000010000001100000033333333070C24419A9999F9C6235A419A9999990C0C24419A999939E4235A41333333334D0C244133333333FE235A4100000000670D2441CDCCCC2CFD235A41CDCCCCCC0C11244166666606FB235A419A999999CC112441CDCCCC0CFA235A419A999999CB1124419A999939E7235A4133333333C3112441333333D3BB235A4133333333171024419A9999B9A4235A41CDCCCCCCC70F2441333333D39F235A41CDCCCCCCD20D24413333335384235A4133333333C10D2441666666A682235A41CDCCCCCC800C24410000000071235A41CDCCCCCC670C2441000000A079235A41000000000E0C244133333333B0235A4133333333070C24419A9999F9C6235A4133333333070C24419A9999F9C6235A41	01010000206A0800003AE67E2AC90E2441000000A0B8235A41	940220206	H	Gondoles Nord III	9402202	94022	94	11	0
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	01060000206A080000010000000103000000010000001300000000000000BB2B24419A99995933245A4100000000D32B2441333333333A245A4100000000CB2B2441333333B350245A4166666666892D24419A99999952245A419A9999998B2D2441CDCCCCAC5A245A4166666666A52D2441333333135C245A419A999999FD2D24419A9999995C245A41CDCCCCCCF52D2441000000C076245A41333333331A2F24419A9999593C245A41000000002E2E2441CDCCCC0C25245A4133333333A42D2441CDCCCC4C13245A4166666666512D2441000000200E245A4133333333E22C2441666666860F245A41666666669C2C2441000000800F245A4100000000382C2441666666460D245A4166666666082C24410000006024245A419A999999D82B24416666664630245A4100000000BB2B24419A99995933245A4100000000BB2B24419A99995933245A41	01010000206A0800004C784EDD672D24419A99998941245A41	940280404	H	Plumerette	9402804	94028	94	11	0
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	01060000206A080000010000000103000000010000002A000000CDCCCCCCB1282441CDCCCC8C8E265A419A999999D72824416666660698265A41CDCCCCCC0C292441CDCCCC8CAB265A41666666662C29244166666626B9265A410000000048292441CDCCCC4CBF265A4100000000FD29244166666626E3265A4100000000242A2441333333B3EC265A4100000000612A2441CDCCCCACF7265A4100000000C52A2441000000600D275A4133333333F42A24419A9999191B275A41CDCCCCCC4D2B2441666666A63E275A419A999999ED2B24416666666649275A4100000000032C2441CDCCCCAC38275A4166666666A12C244133333393F8265A41CDCCCCCC632D24419A99991983265A41666666669A2D2441000000E060265A4133333333A72D2441CDCCCC6C48265A4100000000982D24419A9999192F265A4166666666A42D24413333339317265A419A999999C22D24419A9999D906265A41CDCCCCCCEB2D2441CDCCCCACF6255A41CDCCCCCC782E244100000040D3255A4133333333312F24419A999919A8255A4100000000352E2441666666669B255A419A999999122E2441CDCCCC6C9B255A419A9999993B2E2441333333F395255A419A999999562D24410000002088255A41CDCCCCCCAC2C2441333333737E255A41333333334D2C24413333339397255A4100000000F82B24419A999959B3255A419A999999BD2B24419A999999BD255A4100000000F52A2441CDCCCC0CF4255A4166666666C42A24419A99991903265A41CDCCCCCC7F2A2441666666461F265A4133333333532A2441CDCCCCEC27265A4100000000622924416666662641265A41000000005F292441333333934C265A4100000000292924413333331367265A41CDCCCCCC00292441000000C075265A41CDCCCCCCD52824419A99997989265A41CDCCCCCCB1282441CDCCCC8C8E265A41CDCCCCCCB1282441CDCCCC8C8E265A41	01010000206A0800008D946948642B2441CDCCCCAC62265A41	940280101	H	Bords de Marne	9402801	94028	94	11	1
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	01060000206A080000010000000103000000010000001A000000CDCCCCCC5F262441666666E63A265A4100000000162724419A9999F947265A419A9999995D272441666666A64F265A4166666666F1262441333333D364265A419A99999923272441CDCCCCEC5F265A416666666671272441CDCCCCEC55265A41333333338A272441333333F34E265A4100000000A92724416666666653265A41CDCCCCCCF5272441CDCCCC4C63265A4133333333F92724419A9999B965265A41CDCCCCCC68282441333333B37D265A41CDCCCCCC712824413333333381265A41CDCCCCCCB1282441CDCCCC8C8E265A41CDCCCCCCD52824419A99997989265A41CDCCCCCC00292441000000C075265A4100000000292924413333331367265A41000000005F292441333333934C265A4100000000622924416666662641265A4133333333532A2441CDCCCCEC27265A41CDCCCCCC7F2A2441666666461F265A4166666666A2272441CDCCCC4CEF255A41333333335F27244166666646EB255A416666666624272441CDCCCC0C03265A41CDCCCCCCB22624416666664624265A41CDCCCCCC5F262441666666E63A265A41CDCCCCCC5F262441666666E63A265A41	01010000206A080000BCBBBBBB00282441CCCCCC8C3C265A41	940280102	H	Église	9402801	94028	94	11	0
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	01060000206A080000010000000103000000010000001D000000333333335F27244166666646EB255A4166666666A2272441CDCCCC4CEF255A41CDCCCCCC7F2A2441666666461F265A4166666666C42A24419A99991903265A4100000000F52A2441CDCCCC0CF4255A4133333333712B2441CDCCCC6CD2255A4133333333CE2A244100000020C9255A419A999999B92A2441000000C0C6255A41333333336B2A244100000060CE255A419A9999994A2A2441CDCCCC4CC9255A419A9999990F292441CDCCCCECB8255A41000000007A292441000000A095255A419A999999B82924419A9999B97D255A41CDCCCCCCEC292441333333736B255A41CDCCCCCC272A2441333333335D255A41333333330D2A24413333333359255A4166666666092A2441CDCCCC8C51255A41CDCCCCCCCC2924419A9999193C255A4133333333B62924419A9999B93B255A416666666605292441333333B331255A4133333333E5282441666666E63F255A4100000000AE2824419A99995952255A41CDCCCCCC52282441000000A06E255A4100000000422824416666660675255A41333333331C282441000000809A255A419A99999905282441CDCCCCECAB255A41000000009327244133333373D6255A41333333335F27244166666646EB255A41333333335F27244166666646EB255A41	01010000206A080000964596C7A82824419A9999B9A6255A41	940280103	H	République	9402801	94028	94	11	0
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	01060000206A08000001000000010300000001000000300000009A9999990F292441CDCCCCECB8255A419A9999994A2A2441CDCCCC4CC9255A41333333336B2A244100000060CE255A419A999999B92A2441000000C0C6255A4133333333CE2A244100000020C9255A4133333333712B2441CDCCCC6CD2255A419A999999BD2B24419A999999BD255A4100000000F82B24419A999959B3255A41333333334D2C24413333339397255A41CDCCCCCCAC2C2441333333737E255A419A999999562D24410000002088255A419A9999993B2E2441333333F395255A4100000000872E2441CDCCCC8C89255A4166666666C02E2441CDCCCC4C78255A419A999999D42E2441000000606B255A41CDCCCCCCF42E2441CDCCCC8C60255A419A999999F82E2441000000A055255A4100000000132F2441333333534A255A41CDCCCCCC142F2441000000003A255A41333333334D2F2441000000C032255A4166666666672F2441000000A029255A41CDCCCCCCE42F2441333333531D255A41666666661A302441CDCCCCEC0E255A4100000000423024416666666602255A416666666668302441666666C6F1245A419A99999976302441666666A6EE245A41333333330830244133333333E3245A41CDCCCCCC942F24419A999959FA245A41CDCCCCCC362F244100000040F2245A41000000003F2F2441666666A6F0245A4166666666642E2441333333F3DC245A4133333333702E244133333353DA245A4166666666FB2D244166666606D1245A41333333337A2D2441CDCCCC6CF1245A41CDCCCCCC1E2D2441333333B314255A4166666666DD2C2441CDCCCCCC2B255A4133333333872C2441333333334F255A419A9999994B2C24410000004061255A4100000000E12B2441333333F376255A4166666666122B2441CDCCCC0C69255A41CDCCCCCCD72A24413333333367255A41CDCCCCCC432A24419A9999D95D255A41CDCCCCCC272A2441333333335D255A41CDCCCCCCEC292441333333736B255A419A999999B82924419A9999B97D255A41000000007A292441000000A095255A419A9999990F292441CDCCCCECB8255A419A9999990F292441CDCCCCECB8255A41	01010000206A08000023D9895CBE2D24419A99996952255A41	940280104	H	Île Sainte-Catherine	9402801	94028	94	11	0
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	01060000206A080000010000000103000000010000001E00000033333333BD212441333333F356255A4100000000F3212441666666A657255A416666666615222441CDCCCC2C5F255A413333333338222441CDCCCC2C62255A4133333333B5232441000000A07C255A41000000000F242441CDCCCCEC87255A4100000000422424410000008092255A4100000000EC2424416666662685255A41CDCCCCCC30252441CDCCCCCC7E255A410000000041252441CDCCCC2C80255A4133333333FB242441333333538A255A41CDCCCCCCC92424410000002094255A4166666666E7252441CDCCCCEC97255A41CDCCCCCCFA2524419A99993993255A419A999999382724419A99997995255A41666666661E2724419A9999D98C255A4133333333DD2624419A99993966255A4100000000B1262441000000404A255A41CDCCCCCC91262441000000402F255A416666666698262441000000801B255A4100000000892624416666666619255A4100000000392624410000002019255A41CDCCCCCC1D262441333333B317255A41333333334F242441333333D314255A4133333333522324410000000013255A419A9999990D2324413333337314255A4166666666DE222441000000A018255A41CDCCCCCCBC222441333333131E255A4133333333BD212441333333F356255A4133333333BD212441333333F356255A41	01010000206A0800008C114C54432424419A99999955255A41	940280201	H	La Brèche	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000001300000066666666952024410000004079255A419A9999995021244100000000A2255A41000000000D22244133333333CA255A419A9999998122244100000080B5255A419A999999B322244133333333AF255A419A99999916232441333333F3A5255A419A99999935242441CDCCCCEC8F255A41000000000F242441CDCCCCEC87255A4133333333B5232441000000A07C255A413333333338222441CDCCCC2C62255A416666666615222441CDCCCC2C5F255A4100000000F3212441666666A657255A4133333333BD212441333333F356255A410000000085212441333333D360255A4166666666462124416666666668255A4166666666B92024416666666673255A4166666666B7202441000000E076255A4166666666952024410000004079255A4166666666952024410000004079255A41	01010000206A0800000E1C914496222441666666C690255A41	940280202	H	La Croix des Mèches	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000002C000000333333335B22244166666606C0245A41CDCCCCCC7022244166666606C3245A4166666666E4222441CDCCCCCCC0245A41333333331423244133333373C2245A4166666666462324419A999959CB245A41CDCCCCCC38232441333333D3D1245A4133333333422324419A999959D8245A410000000036232441333333D3F8245A419A999999E5222441CDCCCC6C07255A419A99999901232441666666E612255A4166666666DE222441000000A018255A419A9999990D2324413333337314255A4133333333522324410000000013255A41333333334F242441333333D314255A41CDCCCCCC1D262441333333B317255A41CDCCCCCC4B262441CDCCCC2C19255A419A99999957262441CDCCCC4CF3245A419A9999993A262441CDCCCCECE7245A41000000004026244133333393CE245A41000000005126244166666646A8245A419A99999964262441CDCCCCCC8E245A41000000005D2624410000006085245A419A99999947262441333333537E245A419A999999F82524419A9999F979245A4166666666D12524410000000076245A41333333338F252441333333F37E245A416666666665252441CDCCCCCC82245A41CDCCCCCC6B2524413333337391245A41CDCCCCCC0B2424419A9999B98F245A419A999999F7232441CDCCCCAC8E245A419A999999022424413333339370245A4100000000D22324413333331370245A419A999999AE232441000000006D245A41CDCCCCCC3F232441000000A06C245A41CDCCCCCC032324419A9999F967245A4166666666BD2224413333333367245A4133333333A4222441333333936B245A4133333333A22224410000008074245A4100000000942224419A99999981245A4166666666742224419A99991987245A41333333336E2224419A9999799B245A413333333364222441CDCCCCACA3245A41333333335B22244166666606C0245A41333333335B22244166666606C0245A41	01010000206A080000E411EB7D5024244133333353C0245A41	940280204	H	Hôtel de Ville	9402802	94028	94	11	0
01060000206A0800000100000001030000000100000059000000CDCCCCCC922224413333335360245A41CDCCCCCC922224416666662661245A413333333395222441CDCCCC0C62245A419A9999999A2224419A9999B962245A41000000009F2224419A99993963245A41CDCCCCCCA1222441CDCCCCCC63245A41CDCCCCCCA0222441CDCCCC6C64245A419A999999942224410000008066245A41666666669D222441666666E666245A41CDCCCCCCB72224419A99997967245A4166666666BD2224413333333367245A4100000000EC2224413333335367245A41CDCCCCCC032324419A9999F967245A419A9999991B2324419A9999596A245A4133333333282324419A9999B96B245A41CDCCCCCC33232441CDCCCC4C6C245A41CDCCCCCC3F232441000000A06C245A419A999999AE232441000000006D245A4133333333B6232441000000206D245A419A999999BC232441CDCCCC6C6D245A4100000000C3232441CDCCCC2C6E245A4166666666CB2324419A9999596F245A4100000000D22324413333331370245A4133333333DB2324413333337370245A419A999999022424413333339370245A41CDCCCCCC1E242441CDCCCCCC70245A413333333349242441666666E670245A413333333370242441CDCCCC2C71245A419A999999812424419A9999D971245A41CDCCCCCCAC242441CDCCCC0C72245A4166666666BB242441CDCCCC6C71245A419A999999D52424410000006071245A419A999999E7242441CDCCCC4C71245A4133333333F32424413333331371245A413333333302252441333333B370245A419A99999909252441CDCCCC2C70245A419A999999132524419A9999996F245A41CDCCCCCC24252441CDCCCC0C6E245A419A9999993F252441333333336B245A413333333358252441333333F367245A41CDCCCCCC75252441CDCCCC6C64245A419A99999994252441666666E660245A4166666666B6252441000000005D245A4133333333B5252441666666E65A245A4166666666B42524413333331358245A4133333333B5252441000000E052245A4100000000B7252441000000C04E245A4166666666A1252441CDCCCCAC4E245A4133333333912524419A9999994E245A41CDCCCCCC7A2524413333333350245A413333333332252441666666C64F245A416666666619252441666666A64F245A419A9999991A2524410000008049245A41333333331B2524419A99991944245A419A9999991C252441333333D33E245A41333333331B252441333333F33C245A410000000017252441000000803B245A41CDCCCCCC0E252441333333733A245A4166666666FA2424419A9999993D245A4166666666ED2424419A9999193F245A419A999999DA242441666666E641245A419A999999B3242441000000003E245A4100000000A7242441CDCCCC0C3E245A413333333393242441CDCCCC2C3E245A41CDCCCCCC752424419A9999193E245A4133333333512424419A9999F93D245A4100000000432424419A9999D93D245A41CDCCCCCC39242441CDCCCC6C3D245A41CDCCCCCC302424419A9999193D245A419A99999925242441666666E63C245A4166666666F4232441666666A63C245A419A999999C22324419A9999593C245A4166666666C0232441CDCCCCCC3B245A419A999999BC232441000000603B245A4133333333B7232441000000003B245A4166666666AE232441666666A63A245A41CDCCCCCCA7232441333333933A245A41CDCCCCCCA2232441CDCCCC8C3A245A419A9999999F232441000000C03A245A41666666669C232441000000003B245A41666666669A232441666666663B245A41CDCCCCCC95232441333333333A245A41666666667F232441666666063B245A410000000059232441666666463C245A41333333333F232441000000E040245A416666666623232441333333F345245A419A999999EF222441666666664F245A416666666695222441666666C65F245A41CDCCCCCC922224413333335360245A41	01060000206A0800000100000001030000000100000016000000CDCCCCCC922224413333335360245A419A999999942224410000008066245A41CDCCCCCC032324419A9999F967245A41CDCCCCCC3F232441000000A06C245A419A999999AE232441000000006D245A4133333333DB2324413333337370245A41CDCCCCCCAC242441CDCCCC0C72245A419A999999132524419A9999996F245A4166666666B6252441000000005D245A4100000000B7252441000000C04E245A41CDCCCCCC7A2524413333333350245A416666666619252441666666A64F245A419A9999991C252441333333D33E245A41CDCCCCCC0E252441333333733A245A419A999999DA242441666666E641245A419A999999B3242441000000003E245A4100000000432424419A9999D93D245A419A999999C22324419A9999593C245A41CDCCCCCC95232441333333333A245A410000000059232441666666463C245A41CDCCCCCC922224413333335360245A41CDCCCCCC922224413333335360245A41	01010000206A08000054DBDE77412424419A99997955245A41	940280205	H	L'Ormetteau	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000001600000000000000421E244133333333DD255A419A999999651E24419A999979EC255A419A999999AE1E2441CDCCCCAC0F265A4166666666C41E24419A9999991E265A4166666666B71F24413333337314265A419A999999E81F2441666666C611265A419A999999662024410000008007265A4133333333A82024419A999959FF255A419A999999102124419A999999EF255A41333333335E212441CDCCCCCCE0255A419A9999998921244133333353E4255A41000000000D22244133333333CA255A419A9999995021244100000000A2255A4166666666952024410000004079255A4133333333292024410000008080255A4133333333CE1F24413333333389255A4100000000AC1F2441CDCCCC0C8F255A41CDCCCCCC091F244133333393B4255A41000000007C1E2441CDCCCC4CD4255A4133333333681E2441666666A6DB255A4100000000421E244133333333DD255A4100000000421E244133333333DD255A41	01010000206A08000018AE47214B202441CCCCCC8CCD255A41	940280209	H	Lévrière-Haye aux Moines	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000004D0000000000000059232441666666463C245A41CDCCCCCC95232441333333333A245A419A999999C22324419A9999593C245A4100000000432424419A9999D93D245A419A999999B3242441000000003E245A419A999999DA242441666666E641245A41CDCCCCCC0E252441333333733A245A419A9999991C252441333333D33E245A416666666619252441666666A64F245A41CDCCCCCC7A2524413333333350245A4100000000B7252441000000C04E245A4166666666B6252441000000005D245A419A999999132524419A9999996F245A41CDCCCCCCAC242441CDCCCC0C72245A419A999999022424413333339370245A419A999999F7232441CDCCCCAC8E245A41CDCCCCCC0B2424419A9999B98F245A41CDCCCCCC6B2524413333337391245A416666666665252441CDCCCCCC82245A4133333333042624410000002070245A41CDCCCCCC1F262441333333536E245A410000000077262441000000E061245A4166666666E12624419A9999B94C245A4133333333342724419A9999793A245A4100000000C5272441CDCCCC6C3C245A4166666666212824416666668623245A419A999999332824419A9999191B245A419A999999C628244133333333DD235A41CDCCCCCCBF28244166666686D3235A41000000000B292441666666E6B8235A41666666662F292441333333B3AF235A4166666666892924419A9999799F235A4100000000A6292441333333B393235A41000000009C2924419A9999198A235A4166666666A72924416666662685235A41666666661D2A2441333333735C235A41000000002A2A2441CDCCCC2C53235A410000000068292441666666E65A235A419A9999999A282441333333F364235A416666666667272441CDCCCCCC4D235A41CDCCCCCC66272441CDCCCC6C4C235A419A999999A72624419A9999B947235A419A9999996D2624419A99997962235A41CDCCCCCCFD242441000000C059235A41CDCCCCCCAE242441CDCCCC6C5C235A416666666614242441CDCCCC2C66235A41CDCCCCCCFE2324419A9999196B235A419A999999D1232441CDCCCC8C7D235A4133333333F8232441000000A080235A4100000000FF2324416666664687235A419A9999997E242441CDCCCC4C8C235A419A999999DF242441333333938D235A41CDCCCCCCC1252441000000008F235A41000000002F2624416666662692235A4100000000842624419A9999F997235A419A999999DE26244133333373A2235A41CDCCCCCC49272441CDCCCC4CA8235A41666666664527244100000080AB235A419A999999BE26244166666646B2235A41CDCCCCCC6C25244133333373C1235A41CDCCCCCC0A262441CDCCCCCCF6235A41000000007A2524410000006001245A4100000000652524413333339300245A41333333331E2524419A999999F7235A419A999999E1242441333333B3F7235A41CDCCCCCC9D2424410000006005245A4166666666D1242441CDCCCCCC0D245A419A999999E3242441CDCCCC0C16245A41CDCCCCCCE12424419A9999F91A245A4133333333CA2424416666666622245A41CDCCCCCC84242441333333D328245A416666666648242441000000A029245A413333333302242441000000E026245A410000000003242441333333F322245A4166666666D8232441CDCCCCAC24245A410000000059232441666666463C245A410000000059232441666666463C245A41	01010000206A080000CC8515B8462724419A999949E9235A41	940280206	H	Port-Source	9402802	94028	94	11	1
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	01060000206A080000010000000103000000010000002B000000CDCCCCCC5E1C24413333339351265A4166666666C31C24416666660676265A41666666661B1D2441666666A690265A4133333333DF1C24413333337399265A419A999999A81D2441CDCCCC6CCD265A419A999999471E2441000000C0EE265A41CDCCCCCC831E244100000060FA265A419A999999551F24419A999939F9265A413333333318202441CDCCCC2CF9265A4133333333D72024419A999979F4265A41CDCCCCCCEA22244133333353E8265A413333333335232441333333B3E9265A41CDCCCCCCBF23244166666646DB265A41333333331724244133333393D0265A413333333392242441CDCCCC2CC4265A419A9999994B24244166666646BD265A41CDCCCCCCA523244133333373A6265A410000000052232441CDCCCCCC9B265A419A999999702324419A99991997265A41CDCCCCCC462424416666660668265A4166666666C92124419A99991938265A4100000000B3202441333333B348265A41666666662B202441CDCCCC6C50265A41CDCCCCCC242024410000000042265A41666666662F202441333333F333265A419A999999402024419A9999792A265A41CDCCCCCC6B202441CDCCCC8C1B265A419A999999BC202441666666060A265A41000000003A212441CDCCCC0CF4255A419A9999998921244133333353E4255A41333333335E212441CDCCCCCCE0255A419A999999102124419A999999EF255A4133333333A82024419A999959FF255A419A999999662024410000008007265A419A999999E81F2441666666C611265A4166666666B71F24413333337314265A4166666666C41E24419A9999991E265A419A999999441D2441000000803B265A41CDCCCCCCF41C2441CDCCCC2C40265A4133333333B31C24416666664645265A41CDCCCCCC741C2441CDCCCC0C4D265A41CDCCCCCC5E1C24413333339351265A41CDCCCCCC5E1C24413333339351265A41	01010000206A080000C6F9B0046E202441CCCCCC0C6B265A41	940280207	H	L'Échat	9402802	94028	94	11	1
01060000206A080000010000000103000000010000005500000033333333781B2441333333D3A2255A41000000007D1B24419A999959B4255A4100000000801B24419A999939BB255A41666666668D1B2441666666E6CF255A419A999999941B244100000080D8255A4166666666A01B244100000040E5255A41CDCCCCCCA81B2441CDCCCC0CED255A4166666666B81B2441000000C0F9255A4166666666CC1B24413333331309265A4166666666D91B24419A99995911265A4100000000E51B2441000000E018265A4100000000031C2441CDCCCCCC29265A41CDCCCCCC151C2441CDCCCCEC32265A41CDCCCCCC321C24416666660640265A41CDCCCCCC5E1C24413333339351265A419A999999601C24419A99991951265A419A999999671C2441CDCCCC6C4F265A419A9999996C1C2441666666864E265A41CDCCCCCC741C2441CDCCCC0C4D265A4166666666831C2441666666E64A265A4166666666931C2441333333B348265A4100000000A11C24410000002047265A4133333333B31C24416666664645265A41CDCCCCCCD21C2441333333B342265A41CDCCCCCCF41C2441CDCCCC2C40265A4133333333111D2441000000603E265A419A999999441D2441000000803B265A4100000000631D24416666662639265A4133333333E51D2441000000802F265A4166666666411E24416666666628265A4133333333881E24416666660623265A4166666666901E2441CDCCCC6C22265A419A9999999F1E24416666664621265A41CDCCCCCCAC1E24413333335320265A4166666666C41E24419A9999991E265A4166666666C11E2441333333F31B265A41CDCCCCCCBD1E24410000004019265A419A999999B71E24413333337314265A419A999999AE1E2441CDCCCCAC0F265A41CDCCCCCCA51E2441333333730B265A419A9999999C1E2441666666E606265A41CDCCCCCC8E1E2441CDCCCC6C00265A419A999999651E24419A999979EC255A4166666666451E2441000000E0DE255A4100000000421E244133333333DD255A4133333333681E2441666666A6DB255A4100000000691E244166666686DA255A419A999999691E2441000000C0D9255A41CDCCCCCC6A1E244166666606D9255A41000000006F1E24419A999999D7255A4133333333751E24419A9999F9D5255A41000000007C1E2441CDCCCC4CD4255A419A999999AE1E2441CDCCCC0CC9255A41CDCCCCCCE91E2441CDCCCC8CBB255A4166666666041F2441000000C0B5255A4166666666851E2441333333F3AC255A41666666667D1E244133333333AD255A4133333333771E2441333333B3AD255A419A999999691E2441000000C0AC255A41CDCCCCCC771E2441333333B3A9255A41CDCCCCCC1D1E24419A999979A3255A4100000000051E2441CDCCCCCCA2255A4133333333E11D244133333313A1255A4166666666C01D24419A9999599E255A4100000000A41D2441333333739A255A41CDCCCCCC921D24416666666697255A419A999999611D24419A99995995255A4100000000471D24413333337396255A41CDCCCCCC141D2441000000E092255A41CDCCCCCC0C1D2441666666E68F255A4166666666DA1C2441000000608C255A419A999999C21C24419A9999B98C255A4166666666B81C24419A9999D98C255A4100000000851C2441CDCCCC4C89255A41333333337E1C2441CDCCCCCC87255A4133333333E41B2441666666267D255A41CDCCCCCCD41B2441CDCCCCCC7C255A4166666666C61B2441333333D37C255A41CDCCCCCCC51B2441CDCCCCAC78255A4133333333B51B2441CDCCCC0C77255A41333333337D1B24419A99991974255A41333333337C1B2441000000E077255A4133333333791B24419A9999D986255A4166666666781B2441000000A08D255A4133333333781B2441333333D3A2255A41	01060000206A080000010000000103000000010000002500000033333333781B2441333333D3A2255A4100000000801B24419A999939BB255A41666666668D1B2441666666E6CF255A41CDCCCCCCA81B2441CDCCCC0CED255A4166666666CC1B24413333331309265A4100000000031C2441CDCCCCCC29265A41CDCCCCCC321C24416666660640265A41CDCCCCCC5E1C24413333339351265A41CDCCCCCC741C2441CDCCCC0C4D265A4133333333B31C24416666664645265A41CDCCCCCCF41C2441CDCCCC2C40265A419A999999441D2441000000803B265A4166666666C41E24419A9999991E265A419A999999AE1E2441CDCCCCAC0F265A419A999999651E24419A999979EC255A4100000000421E244133333333DD255A4133333333681E2441666666A6DB255A41000000007C1E2441CDCCCC4CD4255A4166666666041F2441000000C0B5255A4166666666851E2441333333F3AC255A41CDCCCCCC771E2441333333B3A9255A41CDCCCCCC1D1E24419A999979A3255A4166666666C01D24419A9999599E255A41CDCCCCCC921D24416666666697255A419A999999611D24419A99995995255A4100000000471D24413333337396255A41CDCCCCCC141D2441000000E092255A41CDCCCCCC0C1D2441666666E68F255A4166666666DA1C2441000000608C255A4166666666B81C24419A9999D98C255A41333333337E1C2441CDCCCCCC87255A4133333333E41B2441666666267D255A4166666666C61B2441333333D37C255A41CDCCCCCCC51B2441CDCCCCAC78255A41333333337D1B24419A99991974255A4133333333781B2441333333D3A2255A4133333333781B2441333333D3A2255A41	01010000206A080000CCCCCC32F51C244100000010E2255A41	940280208	H	Montaigut Université	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000002A000000CDCCCCCCD41B2441CDCCCCCC7C255A4133333333E41B2441666666267D255A41333333337E1C2441CDCCCCCC87255A4166666666B81C24419A9999D98C255A4166666666DA1C2441000000608C255A41CDCCCCCC0C1D2441666666E68F255A41CDCCCCCC141D2441000000E092255A4100000000471D24413333337396255A419A999999611D24419A99995995255A41CDCCCCCC921D24416666666697255A4166666666C01D24419A9999599E255A41CDCCCCCC1D1E24419A999979A3255A41CDCCCCCC771E2441333333B3A9255A4166666666851E2441333333F3AC255A4166666666041F2441000000C0B5255A4100000000AC1F2441CDCCCC0C8F255A4133333333CE1F24413333333389255A4133333333292024410000008080255A4166666666952024410000004079255A4133333333DA1F2441333333D350255A4100000000621F2441666666C638255A4166666666191F2441333333533E255A4166666666F01E24419A99991943255A419A999999D41E24413333333340255A4166666666A51E24416666660642255A4133333333651E24416666660642255A41CDCCCCCC281E24419A9999D944255A41CDCCCCCCD91D2441333333F34C255A4133333333C51D24413333339348255A41333333338B1D24419A9999F945255A419A999999431D24416666664647255A4133333333491D2441000000204F255A41666666665D1D2441666666A655255A41000000005B1D2441333333535A255A419A999999231D24416666666662255A41CDCCCCCC251D2441000000606A255A419A999999441D24419A9999B970255A419A999999F21C2441666666E66B255A4133333333F61B2441666666465A255A41CDCCCCCCE11B24416666664664255A41CDCCCCCCD41B2441CDCCCCCC7C255A41CDCCCCCCD41B2441CDCCCCCC7C255A41	01010000206A0800009D868E9B311E24419A99996977255A41	940280210	H	Palais-Grand Pavois	9402802	94028	94	11	0
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	01060000206A080000010000000103000000010000002100000033333333F61B2441666666465A255A419A999999F21C2441666666E66B255A419A999999441D24419A9999B970255A41CDCCCCCC251D2441000000606A255A419A999999231D24416666666662255A41000000005B1D2441333333535A255A41666666665D1D2441666666A655255A4133333333491D2441000000204F255A419A999999431D24416666664647255A41333333338B1D24419A9999F945255A4133333333C51D24413333339348255A41CDCCCCCCD91D2441333333F34C255A41CDCCCCCC281E24419A9999D944255A4133333333651E24416666660642255A4166666666A51E24416666660642255A419A999999D41E24413333333340255A4166666666F01E24419A99991943255A4166666666191F2441333333533E255A4100000000621F2441666666C638255A41666666665C1E24410000008000255A41333333335C1D24419A9999F9C8245A4166666666491D24419A999979C6245A4166666666FD1C2441000000A0B6245A4100000000041D2441000000E0C0245A4133333333081D244133333393DE245A4133333333071D24419A999959EF245A41CDCCCCCCE61C2441666666A627255A41CDCCCCCCDD1C24419A9999592D255A4133333333B41C2441CDCCCC0C36255A41CDCCCCCC471C2441CDCCCCEC45255A41000000001C1C2441333333B34E255A4133333333F61B2441666666465A255A4133333333F61B2441666666465A255A41	01010000206A080000D7ED54C5D41D24416666668613255A41	940280211	H	Palais-Charles Péguy	9402802	94028	94	11	0
01060000206A08000001000000010300000001000000C0000000CDCCCCCCEC1324416666664603245A419A9999991B1424419A9999D927245A416666666649142441CDCCCC8C46245A41CDCCCCCC57142441CDCCCC4C50245A41CDCCCCCC631424416666664658245A41CDCCCCCC6D1424419A9999F95E245A41CDCCCCCC74142441CDCCCCAC63245A41CDCCCCCC761424416666660665245A4133333333791424413333339366245A41333333337F142441000000A06A245A419A99999980142441666666466C245A41CDCCCCCC81142441000000406E245A41CDCCCCCC891424410000000079245A41CDCCCCCCDB142441CDCCCCCCDD245A419A9999990015244166666626DF245A41666666665E152441CDCCCCECE1245A419A9999998E1524419A999919E3245A41666666668C152441666666E618255A4166666666CD152441333333131A255A4133333333D6152441666666461A255A4166666666DD1524419A9999991A255A419A999999E4152441CDCCCC2C1B255A4166666666E9152441666666C61B255A41CDCCCCCC12162441000000001F255A41333333333A162441CDCCCC2C23255A41666666666D1624419A9999D928255A41CDCCCCCC99162441333333D32D255A41CDCCCCCCC41624419A9999B932255A419A999999211724419A9999993C255A419A999999411724413333331340255A41666666665E1724419A99993941255A41000000007F172441CDCCCC8C42255A419A999999831724419A9999B942255A4166666666931724419A99995943255A41666666669C1724419A9999B943255A4133333333AD1724410000006044255A41CDCCCCCCAF1724410000008044255A41CDCCCCCCBD172441CDCCCC0C45255A419A999999CE172441666666C645255A4133333333CB1724410000000048255A41333333339C172441CDCCCCEC60255A41CDCCCCCC73172441CDCCCCAC72255A4166666666661724419A9999D978255A4166666666321724416666662690255A4100000000961724413333335392255A416666666608192441000000409A255A416666666605192441333333739C255A4166666666F2182441CDCCCC8CAB255A419A999999DC182441000000C0BC255A419A999999F1182441000000E0BD255A41666666660A19244133333333BF255A41CDCCCCCC58192441CDCCCC8CC3255A4100000000791924419A999979C5255A41CDCCCCCCCE19244133333333CA255A4133333333CC1A2441CDCCCCCCD6255A419A999999C31A2441000000A0D9255A4133333333751A2441CDCCCCACF2255A41000000003D1A24416666666603265A41000000002F1A24416666660607265A41CDCCCCCC1A1A2441333333F30B265A41CDCCCCCCEF1924419A9999B915265A41CDCCCCCCD6192441000000A01B265A41CDCCCCCCA5192441CDCCCCCC25265A413333333392192441CDCCCC4C2A265A4133333333871924419A9999B92C265A41CDCCCCCC7E1924419A9999992E265A419A999999B51A2441666666263F265A419A999999E01B2441666666E64E265A4100000000CC1B2441CDCCCCAC51265A4166666666BD1B24413333339354265A4100000000971B2441000000A05D265A419A999999791B24416666668666265A4100000000571B2441CDCCCCAC77265A41333333334A1B24419A9999197D265A4133333333461B24413333333380265A4100000000B81B2441666666A685265A41000000002C1C24419A9999398B265A4100000000BD1C24410000002091265A4133333333DF1C24413333337399265A4166666666EA1C24419A9999D997265A41666666661B1D2441666666A690265A41666666660B1D24419A9999398C265A4100000000E91C2441333333F381265A4166666666C31C24416666660676265A419A999999951C24413333333366265A41000000006A1C24416666660656265A41CDCCCCCC5E1C24413333339351265A41CDCCCCCC321C24416666660640265A41CDCCCCCC151C2441CDCCCCEC32265A4100000000031C2441CDCCCCCC29265A4100000000E51B2441000000E018265A4166666666D91B24419A99995911265A4166666666CC1B24413333331309265A4166666666B81B2441000000C0F9255A41CDCCCCCCA81B2441CDCCCC0CED255A4166666666A01B244100000040E5255A419A999999941B244100000080D8255A41666666668D1B2441666666E6CF255A4100000000801B24419A999939BB255A41000000007D1B24419A999959B4255A4133333333781B2441333333D3A2255A4166666666781B2441000000A08D255A4133333333791B24419A9999D986255A41333333337C1B2441000000E077255A41333333337D1B24419A99991974255A4133333333B51B2441CDCCCC0C77255A41CDCCCCCCC51B2441CDCCCCAC78255A4166666666C61B2441333333D37C255A41CDCCCCCCD41B2441CDCCCCCC7C255A4133333333D61B24410000000078255A4166666666D81B2441666666E672255A4166666666DA1B2441000000E06C255A419A999999DC1B24416666660669255A41CDCCCCCCE11B24416666664664255A41CDCCCCCCE81B2441333333D35F255A419A999999F11B24419A9999D95B255A4133333333F61B2441666666465A255A4166666666FA1B2441CDCCCCCC58255A419A999999091C2441333333F353255A41000000001C1C2441333333B34E255A4166666666371C2441CDCCCCEC48255A41CDCCCCCC471C2441CDCCCCEC45255A419A9999996D1C2441333333F33F255A41333333338F1C2441666666463B255A4100000000921C2441333333D33A255A4133333333B41C2441CDCCCC0C36255A41CDCCCCCCC01C24413333331334255A419A999999CA1C2441CDCCCC4C32255A41CDCCCCCCD31C24419A99993930255A41CDCCCCCCDD1C24419A9999592D255A419A999999E21C2441CDCCCC0C2B255A41CDCCCCCCE61C2441666666A627255A4133333333E91C24416666666623255A4133333333F31C24410000006014255A4166666666FC1C2441CDCCCC6C03255A419A999999001D24419A999919FB245A4100000000061D244166666666F3245A4133333333071D24419A999959EF245A4133333333081D244133333393DE245A4166666666041D24419A9999F9D4245A4100000000041D2441CDCCCC0CCE245A419A999999051D24419A999959C7245A4100000000041D2441000000E0C0245A419A999999001D244166666686BD245A41CDCCCCCCFA1C2441666666E6B8245A4166666666FD1C2441000000A0B6245A4166666666EA1C244100000080B2245A4100000000951C244166666626A0245A41CDCCCCCC831C2441333333739C245A4166666666361C2441000000E08B245A4100000000121C24413333331384245A4133333333F81B2441666666667E245A41CDCCCCCCDA1B2441CDCCCCCC77245A419A999999D71B2441CDCCCCCC75245A41666666666F1B2441000000605F245A4100000000051B24416666668648245A4100000000F31A2441666666A644245A419A999999E61A24410000008042245A41CDCCCCCCDB1A2441CDCCCCAC40245A4100000000CC1A24419A9999593E245A4133333333C21A2441333333F33C245A419A999999A71A2441666666063A245A4133333333921A24419A99991938245A41000000008B1A24419A99997937245A41CDCCCCCC7C1A24416666664636245A419A9999995F1A24413333333334245A419A999999281A2441000000E030245A4100000000DC1924419A9999B92C245A4100000000E81824419A9999391F245A419A999999CB182441333333931D245A419A999999B21824419A9999391C245A413333333371182441CDCCCC6C18245A41666666662A1824419A99997914245A416666666602182441CDCCCC2C12245A4100000000ED172441333333F310245A419A999999A9172441000000400D245A4100000000481724419A9999D907245A410000000018172441CDCCCC0C05245A41CDCCCCCCE91624416666666602245A419A99999997162441666666C6FD235A419A9999992E1624419A9999F9F7235A41333333337315244166666686ED235A410000000018152441CDCCCC8CE8235A4133333333BF142441333333B3E3235A41333333334F142441666666A6DD235A41333333330F1424419A999919DA235A419A9999990D142441000000E0DB235A41000000000C142441333333D3DD235A41CDCCCCCC0714244133333313E3235A419A99999903142441333333F3E7235A413333333301142441333333B3EA235A41CDCCCCCCEC1324416666664603245A41	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	01010000206A08000004FDA0CACE1924410000007038255A41	940280212	H	Pompadour-Grand Marais	9402802	94028	94	11	2
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	01010000206A08000094F2AE1B2E1F2441CCCCCC2C6F245A41	940280215	H	Le Lac Étendu	9402802	94028	94	11	2
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	01060000206A080000010000000103000000010000001D0000003333333372252441333333F38E275A41000000001827244100000000B0275A41CDCCCCCC48272441CDCCCCECA8275A41333333337328244133333373BE275A419A999999F0282441000000C0C6275A416666666637292441CDCCCC6CCC275A419A999999BE292441000000A0B9275A419A999999E32A24419A9999D991275A419A9999998F2B2441CDCCCC6C7E275A4166666666C32B2441333333336A275A419A999999ED2B24416666666649275A41CDCCCCCC4D2B2441666666A63E275A4133333333F42A24419A9999191B275A4100000000C52A2441000000600D275A419A9999998F2A24410000004002275A419A9999996B292441666666861B275A413333333349292441666666461F275A419A9999990F292441666666262A275A419A999999D32824419A9999F932275A41CDCCCCCC8F2824419A9999593A275A416666666656282441CDCCCC8C3D275A419A999999AC2724416666662641275A41CDCCCCCC502724416666662646275A419A999999E0262441CDCCCCEC56275A4133333333A8262441000000A060275A41333333334A262441CDCCCCCC72275A419A9999999F252441000000A089275A413333333372252441333333F38E275A413333333372252441333333F38E275A41	01010000206A08000059AC9A7E25292441000000B067275A41	940280301	H	Le Halage	9402803	94028	94	11	0
01060000206A080000010000000103000000010000002D0000003333333331232441CDCCCC6C6B275A4100000000662324410000002071275A41000000001F2424410000002085275A419A99999969242441CDCCCC0C7A275A4166666666902424416666662674275A4166666666B0242441666666666F275A41CDCCCCCC672524419A9999D981275A41000000008A2524410000006085275A419A9999999D2524413333335387275A4166666666962524413333339388275A419A9999999F252441000000A089275A4100000000FF2524419A9999D97C275A41333333334A262441CDCCCCCC72275A413333333369262441000000006D275A413333333391262441CDCCCC2C65275A41000000009A2624416666666663275A4133333333A8262441000000A060275A4133333333B2262441333333D35E275A4133333333C72624419A9999195B275A419A999999E0262441CDCCCCEC56275A419A999999292724419A9999F94B275A419A999999B0262441333333F33E275A41000000003D262441666666C632275A41666666662E2624416666664631275A413333333319262441CDCCCC6C34275A41CDCCCCCCF4252441CDCCCCCC39275A4100000000E9252441000000803B275A4100000000BC252441666666A636275A419A9999998C2524419A9999F93C275A41333333336D2524410000002040275A4100000000422524410000006040275A4133333333E3242441000000E040275A41CDCCCCCC732424416666666641275A419A99999951242441000000A041275A41666666662A242441666666C641275A41CDCCCCCC2E2424419A99999949275A41666666662D242441333333734A275A41CDCCCCCC2A242441000000204B275A41CDCCCCCC22242441000000404C275A419A999999102424419A9999D94E275A4166666666042424419A99999950275A4166666666942324413333339360275A410000000071232441CDCCCC2C65275A41000000004B2324419A9999F968275A413333333331232441CDCCCC6C6B275A41	01060000206A08000001000000010300000001000000110000003333333331232441CDCCCC6C6B275A41000000001F2424410000002085275A4166666666B0242441666666666F275A419A9999999D2524413333335387275A419A9999999F252441000000A089275A41333333334A262441CDCCCCCC72275A4133333333A8262441000000A060275A419A999999292724419A9999F94B275A41666666662E2624416666664631275A4100000000E9252441000000803B275A4100000000BC252441666666A636275A41333333336D2524410000002040275A41666666662A242441666666C641275A41CDCCCCCC2A242441000000204B275A410000000071232441CDCCCC2C65275A413333333331232441CDCCCC6C6B275A413333333331232441CDCCCC6C6B275A41	01010000206A080000A058AA3635252441666666F65C275A41	940280302	H	Les Bleuets	9402803	94028	94	11	0
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	01060000206A0800000100000001030000000100000029000000CDCCCCCC831E244100000060FA265A41CDCCCCCCB41E24419A9999F918275A41666666669F1F2441666666E640275A4133333333691F24410000008046275A419A99999961202441333333336C275A419A9999991D2124419A99997955275A4100000000D2222441000000C08A275A419A999999BE222441666666668D275A4133333333C723244100000000A7275A419A9999992B24244133333333A4275A4166666666F4242441CDCCCCCC9A275A4133333333262524413333331397275A419A9999999F252441000000A089275A419A9999999D2524413333335387275A4166666666B0242441666666666F275A41000000001F2424410000002085275A413333333331232441CDCCCC6C6B275A4166666666942324413333339360275A41CDCCCCCC5F2324419A9999195B275A41CDCCCCCC662324416666662654275A419A99999980232441333333B34F275A41CDCCCCCC2E232441CDCCCC0C47275A413333333303232441666666064A275A4133333333DF222441333333B348275A4133333333C52224413333339344275A41CDCCCCCCC5222441CDCCCC6C40275A419A99999992222441000000E03E275A4100000000462224410000008041275A41333333330B2224410000008039275A410000000000222441666666062F275A4166666666682224416666664620275A41CDCCCCCC602224419A9999391B275A41CDCCCCCCD62124419A9999790C275A419A999999C222244133333373F5265A413333333335232441333333B3E9265A41CDCCCCCCEA22244133333353E8265A4133333333D72024419A999979F4265A413333333318202441CDCCCC2CF9265A419A999999551F24419A999939F9265A41CDCCCCCC831E244100000060FA265A41CDCCCCCC831E244100000060FA265A41	01010000206A080000107BA33223212441CDCCCCAC47275A41	940280303	H	Viet	9402803	94028	94	11	0
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	01060000206A080000010000000103000000010000001C000000CDCCCCCCD62124419A9999790C275A41CDCCCCCC602224419A9999391B275A4166666666682224416666664620275A410000000000222441666666062F275A41333333330B2224410000008039275A4100000000462224410000008041275A419A99999992222441000000E03E275A41CDCCCCCCC5222441CDCCCC6C40275A4133333333C52224413333339344275A4133333333DF222441333333B348275A413333333303232441666666064A275A41CDCCCCCC2E232441CDCCCC0C47275A419A99999980232441333333B34F275A41CDCCCCCC662324416666662654275A41CDCCCCCC5F2324419A9999195B275A4166666666942324413333339360275A41CDCCCCCC2A242441000000204B275A41666666662A242441666666C641275A41333333336D2524410000002040275A4100000000BC252441666666A636275A4100000000E9252441000000803B275A41666666662E2624416666664631275A41333333332F2524419A9999B916275A41666666667E242441666666A606275A413333333335232441333333B3E9265A419A999999C222244133333373F5265A41CDCCCCCCD62124419A9999790C275A41CDCCCCCCD62124419A9999790C275A41	01010000206A0800005E8EE00A012424419A9999B926275A41	940280304	H	Cimetière	9402803	94028	94	11	0
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	01060000206A08000001000000010300000001000000260000003333333335232441333333B3E9265A41666666667E242441666666A606275A41333333332F2524419A9999B916275A419A999999B0262441333333F33E275A419A999999292724419A9999F94B275A41CDCCCCCC5F272441666666C644275A419A999999AC2724416666662641275A416666666656282441CDCCCC8C3D275A41CDCCCCCC8F2824419A9999593A275A419A999999D32824419A9999F932275A419A9999990F292441666666262A275A413333333349292441666666461F275A419A9999996B292441666666861B275A419A9999998F2A24410000004002275A4100000000612A2441CDCCCCACF7265A4100000000242A2441333333B3EC265A4100000000FD29244166666626E3265A410000000048292441CDCCCC4CBF265A41666666662C29244166666626B9265A41CDCCCCCC0C292441CDCCCC8CAB265A419A999999D72824416666660698265A41CDCCCCCCB1282441CDCCCC8C8E265A41CDCCCCCC712824413333333381265A41CDCCCCCC68282441333333B37D265A4133333333F92724419A9999B965265A41CDCCCCCCF5272441CDCCCC4C63265A4100000000A92724416666666653265A41333333338A272441333333F34E265A416666666671272441CDCCCCEC55265A419A99999923272441CDCCCCEC5F265A4166666666F1262441333333D364265A416666666647262441000000007E265A4166666666B9242441000000C0BE265A413333333392242441CDCCCC2CC4265A41333333331724244133333393D0265A41CDCCCCCCBF23244166666646DB265A413333333335232441333333B3E9265A413333333335232441333333B3E9265A41	01010000206A080000CE934CACDF2624419A9999D9CE265A41	940280305	H	Plaisance-Les Tilleuls	9402803	94028	94	11	0
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	01060000206A080000010000000103000000010000001F00000066666666242024416666662646265A41666666662B202441CDCCCC6C50265A4100000000B3202441333333B348265A4166666666C92124419A99991938265A41CDCCCCCC462424416666660668265A419A999999702324419A99991997265A410000000052232441CDCCCCCC9B265A41CDCCCCCCA523244133333373A6265A419A9999994B24244166666646BD265A413333333392242441CDCCCC2CC4265A4166666666B9242441000000C0BE265A416666666647262441000000007E265A4166666666F1262441333333D364265A419A9999995D272441666666A64F265A4100000000162724419A9999F947265A41CDCCCCCC5F262441666666E63A265A4133333333A1252441CDCCCC6C2C265A416666666692232441333333B306265A41CDCCCCCCF22224419A9999F9FB255A4133333333FA222441333333F3F9255A41CDCCCCCCC522244166666626F3255A410000000099222441333333D3EA255A41333333336122244166666646DC255A41000000000D22244133333333CA255A41000000003A212441CDCCCC0CF4255A419A999999BC202441666666060A265A41CDCCCCCC6B202441CDCCCC8C1B265A419A999999402024419A9999792A265A41666666662F202441333333F333265A4166666666242024416666662646265A4166666666242024416666662646265A41	01010000206A0800008AA30919CF242441CDCCCC1C47265A41	940280306	H	Henri Mondor-Champeval	9402803	94028	94	11	0
01060000206A0800000100000001030000000100000054000000000000000D22244133333333CA255A41CDCCCCCC4E222441CDCCCC4CD8255A41333333336122244166666646DC255A41666666667022244133333313E0255A41CDCCCCCC7D2224419A9999D9E3255A419A9999998222244133333393E5255A41000000008C222441333333D3E7255A410000000099222441333333D3EA255A4166666666A8222441000000E0ED255A4133333333B622244166666646F0255A41CDCCCCCCC522244166666626F3255A41CDCCCCCCD7222441CDCCCCCCF5255A4100000000D8222441333333D3F5255A4166666666E822244166666606F8255A419A999999F022244100000000F9255A4133333333FA222441333333F3F9255A41CDCCCCCCF22224419A9999F9FB255A410000000003232441CDCCCC6CFD255A41CDCCCCCC1823244100000000FF255A410000000038232441666666E600265A4133333333442324419A9999B901265A4166666666622324419A99999903265A416666666692232441333333B306265A4133333333CD232441CDCCCCEC0A265A413333333310242441333333B30F265A41666666664D2424410000002014265A416666666664242441333333D315265A41CDCCCCCC98242441CDCCCC8C19265A419A999999B82424419A9999B91B265A41333333333A252441CDCCCCEC24265A4133333333A1252441CDCCCC6C2C265A413333333302262441333333B333265A41CDCCCCCC5F262441666666E63A265A41666666666A262441CDCCCC8C38265A41666666668B262441000000402F265A41CDCCCCCCB22624416666664624265A4100000000E72624413333333315265A413333333308272441333333B30B265A410000000018272441CDCCCCAC06265A416666666624272441CDCCCC0C03265A41333333332E2724419A999959FF255A41333333333A272441CDCCCC6CFA255A419A999999482724419A999999F4255A41333333335F27244166666646EB255A41000000009327244133333373D6255A4166666666A0272441666666A6D1255A4100000000C227244133333313C5255A4100000000E9272441333333B3B6255A419A99999905282441CDCCCCECAB255A41CDCCCCCCF727244100000020AB255A419A999999EE27244100000060AA255A419A999999B027244133333353A3255A419A9999995A2724410000006099255A419A999999382724419A99997995255A41CDCCCCCCFA2524419A99993993255A4166666666E7252441CDCCCCEC97255A41CDCCCCCCC92424410000002094255A419A999999D8242441CDCCCC6C90255A4100000000EA242441CDCCCC0C8D255A4133333333FB242441333333538A255A419A999999102524413333337387255A419A9999992A252441CDCCCCAC83255A41000000003F2524410000008080255A410000000041252441CDCCCC2C80255A41CDCCCCCC30252441CDCCCCCC7E255A41CDCCCCCC0C2524419A99993982255A4100000000EC2424416666662685255A41000000007D2424419A9999D98D255A410000000073242441000000A08E255A4100000000422424410000008092255A419A99999935242441CDCCCCEC8F255A41CDCCCCCC1F242441000000A091255A419A999999D0232441666666C697255A41CDCCCCCC93232441333333539C255A4166666666722324419A9999D99E255A419A99999916232441333333F3A5255A41CDCCCCCCDC222441CDCCCC0CAB255A419A999999B322244133333333AF255A4133333333962224419A9999B9B2255A419A9999998122244100000080B5255A416666666670222441666666A6B8255A41666666664E222441333333F3BD255A41000000002F22244100000080C3255A41000000000D22244133333333CA255A41	01060000206A080000010000000103000000010000001D000000000000000D22244133333333CA255A41333333336122244166666646DC255A410000000099222441333333D3EA255A41CDCCCCCCC522244166666626F3255A4133333333FA222441333333F3F9255A41CDCCCCCCF22224419A9999F9FB255A416666666692232441333333B306265A4133333333A1252441CDCCCC6C2C265A41CDCCCCCC5F262441666666E63A265A41CDCCCCCCB22624416666664624265A416666666624272441CDCCCC0C03265A41000000009327244133333373D6255A419A99999905282441CDCCCCECAB255A419A999999EE27244100000060AA255A419A999999382724419A99997995255A41CDCCCCCCFA2524419A99993993255A4166666666E7252441CDCCCCEC97255A41CDCCCCCCC92424410000002094255A4133333333FB242441333333538A255A410000000041252441CDCCCC2C80255A41CDCCCCCC30252441CDCCCCCC7E255A4100000000EC2424416666662685255A4100000000422424410000008092255A419A99999935242441CDCCCCEC8F255A419A99999916232441333333F3A5255A419A999999B322244133333333AF255A419A9999998122244100000080B5255A41000000000D22244133333333CA255A41000000000D22244133333333CA255A41	01010000206A0800004A26DD4AF4242441CCCCCC2CDE255A41	940280307	H	Les Mèches	9402803	94028	94	11	0
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	01060000206A08000001000000010300000001000000150000006666666605292441333333B331255A4133333333B62924419A9999B93B255A41CDCCCCCCCC2924419A9999193C255A4166666666092A2441CDCCCC8C51255A41CDCCCCCC142A24419A9999B95B255A41CDCCCCCC432A24419A9999D95D255A41CDCCCCCCD72A24413333333367255A4166666666122B2441CDCCCC0C69255A4100000000E12B2441333333F376255A419A9999994B2C24410000004061255A4133333333872C2441333333334F255A4166666666DD2C2441CDCCCCCC2B255A41CDCCCCCC172D2441CDCCCC6C18255A4100000000642D244133333373F9245A419A9999996C2C24419A999959F9245A41CDCCCCCC232C244133333313F8245A4133333333EC2A244100000080F6245A4166666666D12A2441CDCCCC4CF1245A41CDCCCCCCA9292441000000E0EF245A416666666605292441333333B331255A416666666605292441333333B331255A41	01010000206A080000AA33AF04F82A2441CCCCCC5C33255A41	940280401	H	Cardinaud	9402804	94028	94	11	0
01060000206A080000010000000103000000010000004A000000CDCCCCCCA9292441000000E0EF245A41CDCCCCCCDE2924419A999919F0245A4133333333592A2441000000A0F0245A4133333333A42A24419A999919F1245A4166666666D12A2441CDCCCC4CF1245A4100000000D52A24419A999959F1245A41CDCCCCCCD72A244133333393F1245A419A999999D92A2441333333D3F1245A4133333333DA2A24419A999979F2245A4133333333DB2A24419A999919F5245A4133333333DE2A2441666666C6F5245A4133333333E42A2441CDCCCC4CF6245A4133333333EC2A244100000080F6245A4166666666AF2B24419A999959F7245A419A999999C82B244166666666F7245A4166666666F42B2441000000C0F7245A41CDCCCCCC232C244133333313F8245A41CDCCCCCC5F2C244133333313F9245A419A9999996C2C24419A999959F9245A4100000000922C244100000060F9245A4166666666D52C244166666686F9245A4166666666042D2441CDCCCC0CF9245A4100000000642D244133333373F9245A41CDCCCCCC722D2441CDCCCCCCF3245A41333333337A2D2441CDCCCC6CF1245A4166666666912D24419A9999B9EB245A4166666666C92D2441666666A6DD245A419A999999BF2D2441333333D3DC245A419A999999B32D2441CDCCCCECDB245A4100000000A42D244133333333DB245A41CDCCCCCC992D2441333333F3DA245A41666666668D2D2441333333B3DA245A41333333337E2D244133333393DA245A4100000000672D2441CDCCCC6CDA245A41666666665E2D244100000060DA245A4166666666362D24419A999939DA245A41CDCCCCCC322D244133333333DA245A41333333336A2C244166666666D9245A4166666666552C244100000040D9245A41CDCCCCCC4A2C244133333333D9245A41CDCCCCCC3E2C244100000020D9245A41CDCCCCCC412C244100000000D1245A419A999999432C2441CDCCCC2CC9245A41CDCCCCCC472C244100000040BD245A41666666664A2C2441666666A6B7245A41666666664A2C2441CDCCCCECB5245A419A999999362C2441666666C6B5245A41000000000A2C244100000080B5245A4133333333E72B24419A999959B5245A4166666666D92B2441CDCCCC2CB5245A4133333333D12B2441333333D3B4245A41CDCCCCCCCB2B244166666646B4245A4100000000C92B2441333333B3B3245A41CDCCCCCCC62B2441666666E6B2245A4133333333C52B2441CDCCCCECB1245A41CDCCCCCCC52B24419A999959AF245A4100000000CD2B2441000000C09B245A41CDCCCCCCBD2B24419A9999999A245A41CDCCCCCCAF2B2441CDCCCC8C9A245A419A999999692B24419A9999399A245A4166666666352B2441333333F399245A419A999999A12A24410000000099245A4166666666982A2441000000809B245A4166666666882A244166666626A0245A41000000006B2A2441333333B3A8245A41CDCCCCCC622A244100000000AB245A419A999999442A244166666626B4245A419A9999992C2A24419A999999BB245A4133333333222A2441666666C6BE245A4133333333162A244166666646C3245A41CDCCCCCCF1292441333333F3D1245A4166666666E729244166666646D6245A41CDCCCCCCC92924419A999999E2245A41CDCCCCCCA9292441000000E0EF245A41	01060000206A0800000100000001030000000100000013000000CDCCCCCCA9292441000000E0EF245A4166666666D12A2441CDCCCC4CF1245A4133333333EC2A244100000080F6245A41CDCCCCCC232C244133333313F8245A419A9999996C2C24419A999959F9245A4100000000642D244133333373F9245A41333333337A2D2441CDCCCC6CF1245A4166666666C92D2441666666A6DD245A41666666668D2D2441333333B3DA245A41CDCCCCCC3E2C244100000020D9245A41666666664A2C2441CDCCCCECB5245A4133333333D12B2441333333D3B4245A4133333333C52B2441CDCCCCECB1245A4100000000CD2B2441000000C09B245A41CDCCCCCCBD2B24419A9999999A245A419A999999A12A24410000000099245A4133333333222A2441666666C6BE245A41CDCCCCCCA9292441000000E0EF245A41CDCCCCCCA9292441000000E0EF245A41	01010000206A0800000E75CE47202B244166666616CD245A41	940280402	H	Casalis	9402804	94028	94	11	0
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	01060000206A08000001000000010300000001000000190000009A999999A12A24410000000099245A41CDCCCCCCBD2B24419A9999999A245A4100000000CD2B2441000000C09B245A4133333333C52B2441CDCCCCECB1245A4133333333D12B2441333333D3B4245A41666666664A2C2441CDCCCCECB5245A41CDCCCCCC3E2C244100000020D9245A41666666668D2D2441333333B3DA245A4166666666C92D2441666666A6DD245A4166666666FB2D244166666606D1245A4100000000692E24419A999999B9245A419A999999532F24410000006091245A41666666660E2E2441CDCCCCEC71245A41CDCCCCCCF52D2441000000C076245A419A999999FD2D24419A9999995C245A4166666666A52D2441333333135C245A419A9999998B2D2441CDCCCCAC5A245A4166666666892D24419A99999952245A4100000000CB2B2441333333B350245A4133333333BE2B2441666666C65C245A41333333338E2B2441333333B368245A41333333332B2B2441CDCCCC2C76245A4133333333102B24419A9999597B245A419A999999A12A24410000000099245A419A999999A12A24410000000099245A41	01010000206A080000701AC587F62C24410000003095245A41	940280403	H	Abbaye	9402804	94028	94	11	0
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	01010000206A080000EFB030FCE72C2441666666D677235A41	940280405	H	Côte d'Or-Coteaux du Sud-Sarrasins	9402804	94028	94	11	1
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	01060000206A080000010000000103000000010000001F0000009A999999192824419A99997925245A4133333333F72924410000004031245A4133333333622A24413333339333245A419A999999732B24416666666637245A419A999999D82B24416666664630245A4166666666082C24410000006024245A419A999999332C2441CDCCCCCC10245A4133333333342C2441CDCCCC4C07245A4100000000212C24419A999959FF235A41CDCCCCCC032C244100000040FA235A41CDCCCCCC7B2B24419A999979EB235A4133333333642B2441666666C6E7235A41666666665E2B2441CDCCCCACDF235A419A999999702B244166666606DC235A4166666666B82B2441000000E0D3235A4100000000CA2B244133333393CF235A4100000000E32B2441000000A0BD235A419A999999EF2B2441333333B3BA235A41000000007C2B2441CDCCCCACBD235A41000000003C2B244100000020C6235A4133333333A02A244166666646D8235A419A999999922A2441666666C6DC235A41000000002F2A244133333313D9235A419A9999990F2A24419A999939D9235A41333333334829244133333353D1235A416666666629292441000000C0D1235A4133333333CC2824419A999919DC235A4100000000C32824419A999979DE235A413333333381282441333333D3FA235A419A999999192824419A99997925245A419A999999192824419A99997925245A41	01010000206A080000A84C76FE382A2441CDCCCC3CF7235A41	940280406	H	La Habette	9402804	94028	94	11	0
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	01060000206A080000010000000103000000010000001900000066666666D12524410000000076245A419A999999F82524419A9999F979245A419A99999947262441333333537E245A41000000005D2624410000006085245A419A999999612624419A99999992245A41666666664B272441666666A694245A41000000007C2824416666668696245A419A999999A12A24410000000099245A4133333333102B24419A9999597B245A41333333332B2B2441CDCCCC2C76245A41333333338E2B2441333333B368245A41CDCCCCCCC72B24419A9999B958245A4100000000D32B2441333333333A245A4100000000BB2B24419A99995933245A419A999999732B24416666666637245A4133333333622A24413333339333245A4133333333F72924410000004031245A419A999999192824419A99997925245A4100000000C5272441CDCCCC6C3C245A4133333333342724419A9999793A245A4166666666E12624419A9999B94C245A410000000077262441000000E061245A41CDCCCCCC1F262441333333536E245A4166666666D12524410000000076245A4166666666D12524410000000076245A41	01010000206A0800007E6DC27B1C292441343333335F245A41	940280407	H	Arcos	9402804	94028	94	11	0
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	01060000206A080000010000000103000000010000001C0000009A9999993A262441CDCCCCECE7245A419A99999957262441CDCCCC4CF3245A41CDCCCCCC4B262441CDCCCC2C19255A4100000000892624416666666619255A416666666698262441000000801B255A41CDCCCCCC91262441000000402F255A4100000000B1262441000000404A255A4133333333DD2624419A99993966255A41666666661E2724419A9999D98C255A4133333333372724413333335395255A419A999999EE27244100000060AA255A419A99999905282441CDCCCCECAB255A41333333331C282441000000809A255A4100000000422824416666660675255A41CDCCCCCC52282441000000A06E255A4100000000AE2824419A99995952255A4133333333E5282441666666E63F255A41000000001B292441666666C627255A41000000008429244166666666FF245A4133333333222A2441666666C6BE245A419A999999A12A24410000000099245A41000000007C2824416666668696245A41666666664B272441666666A694245A419A999999612624419A99999992245A41000000005126244166666646A8245A41000000004026244133333393CE245A419A9999993A262441CDCCCCECE7245A419A9999993A262441CDCCCCECE7245A41	01010000206A0800004524DCB9E5272441CDCCCC7C1E255A41	940280408	H	Saint-Exupéry	9402804	94028	94	11	0
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	01060000206A080000010000000103000000010000001800000066666666CD1F2441CDCCCC6C902C5A41000000003E2024419A9999D9B12C5A419A99999909202441CDCCCC8CB62C5A419A9999993E20244133333393BC2C5A41CDCCCCCCC72024419A9999F9CF2C5A4100000000FC20244133333373D42C5A41CDCCCCCC0322244133333313E92C5A410000000002232441CDCCCCECFB2C5A41CDCCCCCC87232441CDCCCC4C032D5A41CDCCCCCCBD232441CDCCCC6C052D5A4100000000CC23244100000000FA2C5A419A999999C3232441000000E0E22C5A41CDCCCCCCD4222441CDCCCC0CD22C5A41333333332323244133333333CE2C5A41CDCCCCCCD622244166666666B72C5A419A999999D822244166666626B52C5A419A9999993323244100000080B02C5A41CDCCCCCC902224419A9999D97E2C5A41CDCCCCCC0D22244100000000852C5A413333333364212441000000A08A2C5A41666666663F212441000000A0892C5A41666666662B2124419A9999D97F2C5A4166666666CD1F2441CDCCCC6C902C5A4166666666CD1F2441CDCCCC6C902C5A41	01010000206A0800006C895337A7212441CCCCCC5CC02C5A41	940330101	H	Parapluies 1	9403301	94033	94	11	0
01060000206A080000010000000103000000010000005F000000333333338E2224419A9999F97D2C5A41CDCCCCCC902224419A9999D97E2C5A4100000000C9222441333333F38F2C5A4100000000D522244133333393932C5A4100000000E922244133333373992C5A41333333331423244166666666A62C5A419A9999993323244100000080B02C5A4166666666F3222441CDCCCCACB32C5A419A999999D822244166666626B52C5A4133333333D62224419A9999D9B52C5A4133333333D522244100000060B62C5A41CDCCCCCCD622244166666666B72C5A41333333332323244133333333CE2C5A41CDCCCCCCD4222441CDCCCC0CD22C5A41CDCCCCCC40232441333333B3D92C5A419A999999C3232441000000E0E22C5A4166666666C423244166666626E52C5A4100000000C62324419A999999E92C5A41CDCCCCCCC72324419A999999ED2C5A4133333333CA23244100000040F02C5A4133333333CB232441CDCCCCCCF22C5A4100000000CC23244100000000FA2C5A4166666666C02324419A9999B9002D5A419A999999BC23244166666666032D5A41CDCCCCCCBD232441CDCCCC6C052D5A41CDCCCCCC06242441CDCCCC2C082D5A41333333332D24244166666686092D5A41666666669E242441CDCCCC4C0D2D5A4100000000C6242441333333530E2D5A419A9999991625244100000020102D5A41000000005325244100000060112D5A419A999999952524419A999999122D5A4133333333CF252441666666A6132D5A4166666666D1252441333333B3132D5A4100000000D725244133333333112D5A41CDCCCCCCDE252441333333130F2D5A4133333333D72524419A9999190D2D5A41CDCCCCCCD3252441000000400B2D5A41CDCCCCCCD3252441333333D3072D5A4100000000D8252441CDCCCC4C022D5A4100000000DD252441000000E0FD2C5A4133333333E32524419A9999F9F32C5A4166666666E52524419A999979EF2C5A419A999999D2252441333333F3E92C5A4100000000A525244133333353DD2C5A419A9999998E2524419A999939D62C5A4133333333892524419A999979D42C5A41CDCCCCCC8425244100000000D32C5A416666666682252441333333B3D12C5A41CDCCCCCC8025244100000080D02C5A41333333337C252441CDCCCC2CCC2C5A419A9999997D25244100000020C92C5A419A9999997F2524419A999919C72C5A410000000084252441000000C0C42C5A416666666696252441000000E0BC2C5A41CDCCCCCC98252441CDCCCC6CBB2C5A41000000009C252441CDCCCC0CB82C5A41CDCCCCCC9D25244100000000B42C5A41666666669E252441666666E6AF2C5A41333333339E25244133333313AF2C5A419A9999999E25244100000000A92C5A4100000000A2252441666666469D2C5A4133333333A425244166666626992C5A4133333333A525244133333353952C5A4100000000A525244133333393922C5A4133333333A3252441333333F38F2C5A4133333333A02524419A9999798D2C5A41CDCCCCCC9B252441333333F38A2C5A413333333396252441000000A0882C5A41333333338F25244100000020862C5A41CDCCCCCC6B252441666666C67B2C5A41333333335B25244100000040782C5A41CDCCCCCC50252441CDCCCC8C772C5A41CDCCCCCC472524419A999959772C5A41333333334625244100000080752C5A41666666664225244166666606732C5A41000000003D252441000000A0702C5A41CDCCCCCC35252441000000406E2C5A419A9999992B252441CDCCCCEC6A2C5A4100000000202524419A9999D9672C5A416666666617252441666666E6652C5A41333333331225244133333313662C5A41666666660E2524419A999919662C5A41000000000B25244133333313662C5A419A99999907252441CDCCCCCC652C5A419A99999905252441CDCCCC8C652C5A41CDCCCCCC0325244166666646652C5A4133333333B4242441666666866C2C5A4133333333AB242441CDCCCC0C6A2C5A4133333333FA232441333333336F2C5A41CDCCCCCCF6232441000000C06D2C5A41000000006B232441000000A0732C5A4100000000D3222441CDCCCC2C7A2C5A4133333333CF222441666666067B2C5A41333333338E2224419A9999F97D2C5A41	01060000206A0800000100000001030000000100000020000000333333338E2224419A9999F97D2C5A419A9999993323244100000080B02C5A419A999999D822244166666626B52C5A41CDCCCCCCD622244166666666B72C5A41333333332323244133333333CE2C5A41CDCCCCCCD4222441CDCCCC0CD22C5A419A999999C3232441000000E0E22C5A4100000000CC23244100000000FA2C5A41CDCCCCCCBD232441CDCCCC6C052D5A41666666669E242441CDCCCC4C0D2D5A4166666666D1252441333333B3132D5A41CDCCCCCCDE252441333333130F2D5A41CDCCCCCCD3252441000000400B2D5A4166666666E52524419A999979EF2C5A41CDCCCCCC8425244100000000D32C5A419A9999997F2524419A999919C72C5A416666666696252441000000E0BC2C5A41CDCCCCCC9D25244100000000B42C5A4100000000A525244133333393922C5A41CDCCCCCC9B252441333333F38A2C5A41CDCCCCCC6B252441666666C67B2C5A41CDCCCCCC472524419A999959772C5A41000000003D252441000000A0702C5A416666666617252441666666E6652C5A41CDCCCCCC0325244166666646652C5A4133333333B4242441666666866C2C5A4133333333AB242441CDCCCC0C6A2C5A4133333333FA232441333333336F2C5A41CDCCCCCCF6232441000000C06D2C5A4100000000D3222441CDCCCC2C7A2C5A41333333338E2224419A9999F97D2C5A41333333338E2224419A9999F97D2C5A41	01010000206A080000888888283F24244166666626BC2C5A41	940330102	H	Parapluies 2	9403301	94033	94	11	0
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	01060000206A0800000100000001030000000100000024000000333333337C252441CDCCCC2CCC2C5A41CDCCCCCC8425244100000000D32C5A4166666666E52524419A999979EF2C5A41CDCCCCCCD3252441000000400B2D5A41CDCCCCCCDE252441333333130F2D5A4166666666D1252441333333B3132D5A4133333333F3252441000000C0142D5A419A9999999226244133333313162D5A41333333330728244166666686182D5A4133333333122A244100000040212D5A41333333337C2A244166666646232D5A4133333333742B2441000000C0252D5A41CDCCCCCC772B244100000020242D5A41CDCCCCCC1E2C24419A9999D9262D5A419A999999B92C2441666666662A2D5A419A999999382D244100000040302D5A41CDCCCCCC9C2D2441000000A0392D5A419A9999997C2D2441CDCCCCAC042D5A4166666666692D2441CDCCCC0CF72C5A41333333333E2D244100000020E82C5A419A999999DE2C244100000080D52C5A4133333333C52C2441CDCCCC8CD32C5A4166666666632C2441CDCCCCECC72C5A41000000000D2C2441CDCCCC2CC02C5A4100000000B62B244166666606BB2C5A4100000000222B244166666646B62C5A419A999999D7282441666666E6B02C5A419A9999994828244166666646B12C5A41333333339C272441000000A0B52C5A41CDCCCCCCAA262441CDCCCCCCC12C5A41CDCCCCCC61262441CDCCCC0CC42C5A41333333332E262441333333F3C32C5A4166666666D6252441CDCCCCACC12C5A416666666696252441000000E0BC2C5A41333333337C252441CDCCCC2CCC2C5A41333333337C252441CDCCCC2CCC2C5A41	01010000206A08000080690CB8A429244166666626F62C5A41	940330103	H	Plateau	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000002600000000000000192B2441000000C0852D5A41CDCCCCCCA82B24419A999979912D5A419A999999052C24419A9999F9952D5A4100000000812C24419A999999982D5A41CDCCCCCCE22C2441666666C6972D5A4100000000962D2441666666C6912D5A4166666666CC2E244166666666882D5A4133333333082F2441666666E6872D5A41000000000730244166666646882D5A4166666666563024419A9999198E2D5A4100000000B4302441666666868F2D5A4133333333A73124419A9999D9852D5A41CDCCCCCC1C32244100000080842D5A41CDCCCCCC6D322441CDCCCCEC842D5A416666666627332441CDCCCC6C832D5A4100000000EE322441000000207A2D5A419A999999F432244100000060732D5A4166666666D332244133333353632D5A4133333333C23224419A9999F9512D5A416666666616322441CDCCCCAC532D5A419A999999EB302441CDCCCCEC532D5A41333333336F302441CDCCCCEC522D5A41CDCCCCCC9E2F2441CDCCCC6C4E2D5A41CDCCCCCCF32E2441000000C0482D5A419A999999732E244166666686452D5A4133333333352E2441CDCCCCEC422D5A41CDCCCCCC9C2D2441000000A0392D5A419A999999382D244100000040302D5A419A999999B92C2441666666662A2D5A41CDCCCCCC1E2C24419A9999D9262D5A41CDCCCCCC772B244100000020242D5A4100000000622B244100000000322D5A4133333333332B2441CDCCCC4C582D5A419A999999482B2441666666465B2D5A4100000000522B24419A9999D9692D5A41CDCCCCCC4B2B24419A9999F9742D5A4100000000192B2441000000C0852D5A4100000000192B2441000000C0852D5A41	01010000206A08000023B39A520C2F2441CCCCCC9C5F2D5A41	940330104	H	Victor Hugo	9403301	94033	94	11	0
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	01060000206A0800000100000001030000000100000022000000CDCCCCCC3630244100000060CA2C5A41000000004E3024419A999919CF2C5A419A9999995130244166666646E02C5A413333333387302441666666E6DF2C5A41000000008D30244133333393F62C5A4100000000BC30244133333373FB2C5A41333333338C31244100000080FA2C5A4166666666A33124419A999919F42C5A41666666662E32244166666646F32C5A41CDCCCCCC3D322441000000A0EB2C5A413333333364322441CDCCCC4CEB2C5A4133333333643224419A999939F62C5A419A9999998332244166666686012D5A416666666686322441333333330E2D5A4100000000B4322441000000A00D2D5A4133333333D132244166666666072D5A419A999999EA32244100000080052D5A4166666666A9332441CDCCCC8C032D5A4100000000D23324419A999959042D5A4100000000E43324419A9999D9FD2C5A419A999999C533244133333333F52C5A41CDCCCCCCBD33244133333373D42C5A41CDCCCCCCBB3324419A999999BC2C5A4100000000C833244133333393B72C5A4133333333983324419A999939B82C5A41CDCCCCCC8733244166666646B52C5A416666666691332441000000E0AF2C5A419A99999905332441666666E6B22C5A419A99999943322441333333D3B32C5A4100000000EB31244166666606B52C5A419A99999970312441CDCCCC6CB82C5A4100000000E4302441CDCCCC2CBF2C5A41CDCCCCCC3630244100000060CA2C5A41CDCCCCCC3630244100000060CA2C5A41	01010000206A080000FA4067480932244166666666DF2C5A41	940330108	H	Les Larris 3	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000002800000033333333C23224419A9999F9512D5A4166666666D332244133333353632D5A419A999999F432244100000060732D5A4100000000EE322441000000207A2D5A416666666627332441CDCCCC6C832D5A413333333343332441000000808A2D5A419A9999999C33244166666626AB2D5A4166666666E13324419A999939A92D5A41CDCCCCCC2E3624419A999979962D5A41CDCCCCCC973624419A9999D9932D5A41CDCCCCCC1B372441000000804B2D5A419A999999563724419A9999B9292D5A4100000000A837244133333333F82C5A4166666666DB37244100000020DB2C5A41333333330A3824419A999919C32C5A41000000003838244166666626AE2C5A4100000000DA372441333333B3AC2C5A4100000000F7362441666666E6AD2C5A41CDCCCCCC5A362441CDCCCCACAD2C5A419A9999993C3624419A9999D9AB2C5A410000000039362441000000E0B32C5A41CDCCCCCC1A362441CDCCCCCCB62C5A419A999999D435244133333353B42C5A4133333333D13524419A999959AB2C5A4100000000963524419A9999D9AE2C5A4166666666D834244166666686AF2C5A41000000009633244166666646AF2C5A4166666666863324419A9999D9B22C5A4133333333983324419A999939B82C5A4100000000C833244133333393B72C5A41CDCCCCCCBB3324419A999999BC2C5A41CDCCCCCCBD33244133333373D42C5A419A999999C533244133333333F52C5A419A999999E7332441666666E6002D5A41CDCCCCCCC3332441666666860B2D5A41CDCCCCCCCA332441CDCCCC8C212D5A4133333333AD3324419A9999593E2D5A4100000000683324419A999999542D5A4133333333C23224419A9999F9512D5A4133333333C23224419A9999F9512D5A41	01010000206A08000068BF94978A352441000000702B2D5A41	940330105	H	Jean Zay	9403301	94033	94	11	0
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	01060000206A08000001000000010300000001000000200000009A999999DE2C244100000080D52C5A41333333333E2D244100000020E82C5A4166666666692D2441CDCCCC0CF72C5A419A9999997C2D2441CDCCCCAC042D5A41CDCCCCCC9C2D2441000000A0392D5A4133333333352E2441CDCCCCEC422D5A419A999999732E244166666686452D5A41CDCCCCCCF32E2441000000C0482D5A41CDCCCCCC9E2F2441CDCCCC6C4E2D5A41333333336F302441CDCCCCEC522D5A4100000000A53024419A999979532D5A4166666666A1302441666666E6392D5A416666666696302441CDCCCC6C342D5A41666666665E302441333333F32F2D5A416666666659302441000000801F2D5A41666666669F302441CDCCCC4C1F2D5A41666666669B302441666666A6092D5A41CDCCCCCCB9302441CDCCCC8C092D5A4166666666B5302441666666A6FC2C5A41000000008D30244133333393F62C5A413333333387302441666666E6DF2C5A419A9999995130244166666646E02C5A41000000004E3024419A999919CF2C5A41CDCCCCCC3630244100000060CA2C5A4100000000EA2F24419A9999F9CE2C5A41CDCCCCCC2D2F24419A999939D82C5A41333333339D2E244166666626DD2C5A41CDCCCCCC472E2441333333D3DD2C5A419A999999E52D24419A9999F9DC2C5A41CDCCCCCC062D244100000080D52C5A419A999999DE2C244100000080D52C5A419A999999DE2C244100000080D52C5A41	01010000206A0800007C5FC581102F2441333333930E2D5A41	940330106	H	Les Larris 1	9403301	94033	94	11	0
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	01060000206A08000001000000010300000001000000210000006666666659302441000000801F2D5A41666666665E302441333333F32F2D5A416666666696302441CDCCCC6C342D5A4166666666A1302441666666E6392D5A4100000000A53024419A999979532D5A41333333333D312441CDCCCC0C542D5A416666666616322441CDCCCCAC532D5A4133333333C23224419A9999F9512D5A4100000000683324419A999999542D5A4133333333AD3324419A9999593E2D5A41CDCCCCCCCA332441CDCCCC8C212D5A41CDCCCCCCC3332441666666860B2D5A419A999999D4332441000000E0042D5A4166666666A9332441CDCCCC8C032D5A419A999999EA32244100000080052D5A4133333333D132244166666666072D5A4100000000B4322441000000A00D2D5A416666666686322441333333330E2D5A419A9999998332244166666686012D5A4133333333643224419A999939F62C5A413333333364322441CDCCCC4CEB2C5A41CDCCCCCC3D322441000000A0EB2C5A41666666662E32244166666646F32C5A4166666666A33124419A999919F42C5A410000000097312441CDCCCCACF92C5A410000000058312441666666E6FA2C5A4166666666CF30244166666626FB2C5A4166666666B5302441666666A6FC2C5A41CDCCCCCCB9302441CDCCCC8C092D5A41666666669B302441666666A6092D5A41666666669F302441CDCCCC4C1F2D5A416666666659302441000000801F2D5A416666666659302441000000801F2D5A41	01010000206A080000420F11121232244166666686202D5A41	940330107	H	Les Larris 2	9403301	94033	94	11	0
01060000206A0800000100000001030000000100000038000000CDCCCCCCA2282441000000C0D02B5A4133333333C6282441CDCCCC4CD82B5A4133333333EA2824419A9999B9DF2B5A416666666686292441CDCCCCAC012C5A419A999999DB292441CDCCCC0C142C5A41CDCCCCCC282A2441CDCCCCAC242C5A41000000009A2A2441333333B33C2C5A4100000000BE2A244133333373392C5A4133333333DE2A2441CDCCCC2C362C5A41333333332A2B24419A9999592F2C5A4166666666842B2441333333F3282C5A4100000000D02B24419A999939362C5A4133333333222C244133333313452C5A4166666666452C244100000040422C5A41CDCCCCCC742C2441CDCCCCCC3E2C5A419A9999997A2C2441000000A03D2C5A4166666666832C2441CDCCCCCC3B2C5A41333333339B2C24419A999999362C5A4166666666A12C2441666666E6352C5A4133333333AE2C2441CDCCCC0C352C5A41CDCCCCCC142D2441333333732E2C5A4133333333502D2441666666062B2C5A419A999999562D2441666666A62A2C5A41333333336A2D2441666666A6292C5A41CDCCCCCC872D244100000040282C5A4166666666D22D24419A999939252C5A4133333333C62D24419A999999212C5A4100000000B42D24419A9999591D2C5A4166666666A82D2441333333131B2C5A41CDCCCCCC9A2D2441CDCCCC0C192C5A419A9999998E2D2441666666C6172C5A4100000000852D24419A999939162C5A41000000007E2D244133333393142C5A4100000000672D2441333333130E2C5A419A999999572D2441333333F30A2C5A41CDCCCCCC4E2D244166666646092C5A41333333333F2D2441CDCCCC6C062C5A4100000000252D244166666606012C5A41CDCCCCCC172D24419A999979FE2B5A419A999999F82C2441666666A6FA2B5A4133333333E02C244100000040F82B5A4100000000A12C2441CDCCCC2CF52B5A4133333333D22B244133333313EC2B5A419A999999BF2B2441666666C6E82B5A41CDCCCCCC5D2B244133333373D92B5A4100000000092B2441CDCCCC2CCC2B5A419A999999D32A244100000060C42B5A41CDCCCCCCA42A2441CDCCCCCCBD2B5A419A999999252A244166666646C22B5A41000000001A2A2441666666A6C22B5A41CDCCCCCCD72924419A9999F9C42B5A419A999999B929244133333313C62B5A419A9999998029244133333333C82B5A41666666666029244100000080C92B5A41CDCCCCCC292924419A9999B9CB2B5A41CDCCCCCCA2282441000000C0D02B5A41	01060000206A0800000100000001030000000100000017000000CDCCCCCCA2282441000000C0D02B5A4133333333EA2824419A9999B9DF2B5A41CDCCCCCC282A2441CDCCCCAC242C5A41000000009A2A2441333333B33C2C5A41333333332A2B24419A9999592F2C5A4166666666842B2441333333F3282C5A4133333333222C244133333313452C5A41CDCCCCCC742C2441CDCCCCCC3E2C5A4166666666A12C2441666666E6352C5A41CDCCCCCC142D2441333333732E2C5A41CDCCCCCC872D244100000040282C5A4166666666D22D24419A999939252C5A4166666666A82D2441333333131B2C5A41000000007E2D244133333393142C5A4100000000672D2441333333130E2C5A41CDCCCCCC172D24419A999979FE2B5A4133333333E02C244100000040F82B5A4133333333D22B244133333313EC2B5A4100000000092B2441CDCCCC2CCC2B5A41CDCCCCCCA42A2441CDCCCCCCBD2B5A41CDCCCCCCD72924419A9999F9C42B5A41CDCCCCCCA2282441000000C0D02B5A41CDCCCCCCA2282441000000C0D02B5A41	01010000206A08000035E9A3BD552B24419A999959012C5A41	940330116	H	Le Village 3	9403301	94033	94	11	0
01060000206A080000010000000103000000010000009E000000CDCCCCCC973624419A9999D9932D5A4166666666B0362441CDCCCCAC932D5A4100000000BF362441CDCCCC8C932D5A41CDCCCCCCDD36244133333393932D5A41CDCCCCCCF0362441CDCCCCAC932D5A41000000002137244166666646942D5A41CDCCCCCC3E372441666666E6942D5A419A999999563724419A999979952D5A410000000088372441333333B3962D5A4100000000A63724419A999979972D5A41CDCCCCCCAD372441CDCCCCEC902D5A41666666666D3824419A999939942D5A419A99999903392441333333D3962D5A419A9999990E39244166666606922D5A41666666662239244133333353892D5A419A999999383924419A9999597F2D5A416666666642392441666666467B2D5A41000000005339244166666606742D5A41333333335B392441000000E0742D5A4133333333683924419A999939762D5A41CDCCCCCC763924419A999999772D5A41CDCCCCCC87392441CDCCCC4C792D5A41CDCCCCCCA4392441000000807C2D5A4100000000C0392441CDCCCC4C7F2D5A41333333331B3A244133333393852D5A4133333333D03A2441666666C68F2D5A4133333333E03A2441CDCCCCCC8B2D5A4133333333F23A244166666686862D5A4166666666083B2441333333B3872D5A4166666666163B24419A999959882D5A41333333333D3B24419A9999198A2D5A4100000000493B2441666666A68A2D5A4166666666503B24419A9999F98A2D5A41CDCCCCCC573B2441333333538B2D5A4100000000953B2441333333938E2D5A4100000000A43B2441666666468F2D5A4133333333ED3B244100000080922D5A4166666666083C2441666666C68A2D5A41666666660C3C2441CDCCCCAC892D5A4166666666103C244133333393882D5A4166666666303C2441666666C67F2D5A4133333333423C2441000000C07A2D5A41CDCCCCCC473C244166666646792D5A41CDCCCCCC7E3C244100000080692D5A4133333333553C244133333333682D5A419A999999373B2441333333335F2D5A41000000005D3B244133333353532D5A41CDCCCCCC8C3B24419A9999B9432D5A419A999999B03B244100000080372D5A41CDCCCCCCC93B2441666666062F2D5A4100000000CF3B2441000000602D2D5A41CDCCCCCCE63B244166666646262D5A4100000000FD3B2441333333B31F2D5A4166666666043C24419A9999591D2D5A41000000000A3C2441CDCCCCAC1B2D5A4100000000123C244133333393192D5A41000000002E3C244100000080112D5A419A9999994E3C244166666646082D5A41CDCCCCCC753C2441666666460C2D5A4166666666993C2441666666A60F2D5A4133333333A23C24419A999919102D5A4166666666C73C2441CDCCCC0C122D5A4166666666273D244166666666172D5A41CDCCCCCCBD3D2441000000C01F2D5A4100000000223E2441CDCCCC4C092D5A4100000000093E244100000040082D5A4100000000A43D244133333313032D5A4100000000FB3C244133333353F92C5A419A999999D63C2441CDCCCC4CF72C5A4100000000B13C2441000000C0F52C5A419A999999A03C24419A999939F52C5A4166666666943C244133333393F42C5A41CDCCCCCC8A3C24419A999979F32C5A41000000007E3C2441666666C6F02C5A41333333336B3C2441CDCCCCECEB2C5A4133333333543C244100000080E62C5A41CDCCCCCC373C244133333393DF2C5A4100000000173C24419A9999B9D72C5A419A999999023C24419A9999D9D22C5A4133333333D53B2441CDCCCC4CC82C5A41CDCCCCCCD23B244133333353C72C5A4100000000D23B24419A999959C62C5A419A999999CD3B2441666666C6C02C5A4100000000CD3B244100000020BF2C5A4133333333C93B244166666646BD2C5A4100000000C73B2441666666A6BC2C5A41CDCCCCCCC23B244166666666BB2C5A4133333333BB3B2441CDCCCCCCB92C5A4100000000B73B24419A999919B92C5A4133333333B13B244100000020B82C5A41CDCCCCCCA53B2441333333F3B62C5A41666666669E3B2441CDCCCC2CB62C5A4100000000873B244166666606B42C5A4133333333553B244133333373AF2C5A419A999999283B244133333333AB2C5A4133333333EC3A244100000040A62C5A4166666666F13A244100000040A42C5A41CDCCCCCCE93A2441666666C6A32C5A4100000000E23A2441CDCCCCECA22C5A4133333333DD3A24419A999919A22C5A41CDCCCCCCCD3A244166666626A12C5A419A999999BE3A2441CDCCCC2CA02C5A41000000006F3A2441666666A69B2C5A4100000000433A2441CDCCCC4C992C5A41666666664C3A2441333333D3912C5A41333333334E3A2441000000608F2C5A4133333333723A2441000000207D2C5A41CDCCCCCC6D3A244100000080772C5A41000000006E3A2441CDCCCC0C752C5A41CDCCCCCC6D3A24419A9999B9712C5A41666666666B3A24419A999959682C5A4133333333693A2441000000405E2C5A419A999999623A24419A9999594C2C5A4133333333613A2441000000E0492C5A41333333335D3A244166666606472C5A41CDCCCCCC3F3A24419A9999D9452C5A410000000096392441000000603F2C5A4133333333623924419A9999593D2C5A410000000052392441CDCCCCAC3C2C5A416666666629392441666666063B2C5A416666666619392441CDCCCC6C3A2C5A4133333333063924419A9999B9442C5A4166666666E938244166666686532C5A4133333333D4382441666666865E2C5A41CDCCCCCCAB3824419A9999B9722C5A419A99999997382441666666867D2C5A416666666688382441666666C6852C5A41333333336E38244100000080932C5A41CDCCCCCC60382441000000C0992C5A41CDCCCCCC3A382441000000C0AC2C5A41000000003838244166666626AE2C5A41000000002B382441666666A6B42C5A419A9999991A38244166666606BC2C5A41333333330A3824419A999919C32C5A41CDCCCCCCF8372441666666C6CB2C5A4100000000EA37244166666686D32C5A4166666666DB37244100000020DB2C5A4100000000D93724419A999979DC2C5A4166666666CD372441000000E0E22C5A4100000000C3372441CDCCCC2CE92C5A4100000000B4372441666666E6F12C5A4100000000A837244133333333F82C5A419A9999999A3724419A999939002D5A419A9999996F372441000000A0192D5A41000000006A372441000000401D2D5A419A999999563724419A9999B9292D5A419A999999503724419A9999592D2D5A41333333334237244100000080352D5A41666666662E372441CDCCCCEC402D5A41CDCCCCCC2C372441666666E6412D5A41CDCCCCCC1B372441000000804B2D5A41000000000937244100000080552D5A41CDCCCCCCF6362441CDCCCCEC5F2D5A41CDCCCCCCE1362441000000C06A2D5A419A999999CD3624419A999979762D5A4133333333B93624419A999939822D5A4166666666B3362441000000A0852D5A41CDCCCCCC973624419A9999D9932D5A41	01060000206A080000010000000103000000010000002C000000CDCCCCCC973624419A9999D9932D5A41000000002137244166666646942D5A4100000000A63724419A999979972D5A41CDCCCCCCAD372441CDCCCCEC902D5A419A99999903392441333333D3962D5A41000000005339244166666606742D5A4100000000C0392441CDCCCC4C7F2D5A41333333331B3A244133333393852D5A4133333333D03A2441666666C68F2D5A4133333333F23A244166666686862D5A4133333333ED3B244100000080922D5A41CDCCCCCC7E3C244100000080692D5A419A999999373B2441333333335F2D5A4100000000CF3B2441000000602D2D5A419A9999994E3C244166666646082D5A4166666666993C2441666666A60F2D5A41CDCCCCCCBD3D2441000000C01F2D5A4100000000223E2441CDCCCC4C092D5A4100000000A43D244133333313032D5A419A999999D63C2441CDCCCC4CF72C5A41CDCCCCCC8A3C24419A999979F32C5A4133333333D53B2441CDCCCC4CC82C5A4100000000CD3B244100000020BF2C5A4133333333B13B244100000020B82C5A419A999999283B244133333333AB2C5A4133333333EC3A244100000040A62C5A4166666666F13A244100000040A42C5A419A999999BE3A2441CDCCCC2CA02C5A4100000000433A2441CDCCCC4C992C5A41333333334E3A2441000000608F2C5A4133333333723A2441000000207D2C5A419A999999623A24419A9999594C2C5A41333333335D3A244166666606472C5A416666666619392441CDCCCC6C3A2C5A41CDCCCCCCAB3824419A9999B9722C5A41333333336E38244100000080932C5A41000000002B382441666666A6B42C5A41333333330A3824419A999919C32C5A4166666666DB37244100000020DB2C5A4100000000A837244133333333F82C5A419A999999563724419A9999B9292D5A41CDCCCCCC1B372441000000804B2D5A41CDCCCCCC973624419A9999D9932D5A41CDCCCCCC973624419A9999D9932D5A41	01010000206A0800001A6F0A8A0F3A2441666666D6E72C5A41	940330109	H	Les Alouettes	9403301	94033	94	11	1
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	01060000206A08000001000000010300000001000000260000009A999999CD3324419A9999B96C2C5A4133333333DB33244166666686722C5A41CDCCCCCC273424419A9999B97B2C5A41CDCCCCCC8534244166666626842C5A41CDCCCCCC82342441666666C6852C5A4133333333D1342441333333938D2C5A4166666666D83524419A999939AA2C5A419A999999CB352441CDCCCC8CAD2C5A419A999999D435244133333353B42C5A419A9999990636244100000020B72C5A41666666663C362441666666E6B22C5A419A9999993C3624419A9999D9AB2C5A41CDCCCCCC5A362441CDCCCCACAD2C5A4100000000F7362441666666E6AD2C5A4100000000DA372441333333B3AC2C5A41000000003838244166666626AE2C5A41333333336E38244100000080932C5A41CDCCCCCCAB3824419A9999B9722C5A416666666619392441CDCCCC6C3A2C5A4100000000B7372441CDCCCC0C2D2C5A416666666633372441CDCCCC8C282C5A4133333333113724419A999939322C5A4166666666FA362441666666863F2C5A419A9999997C362441333333735A2C5A41CDCCCCCC81362441CDCCCCCC5D2C5A4100000000A736244166666626622C5A410000000036362441666666C6702C5A416666666635362441333333D3742C5A41CDCCCCCC9335244166666606742C5A419A99999990352441333333136D2C5A41CDCCCCCC7435244100000040682C5A416666666674352441000000A0632C5A41CDCCCCCC5C352441000000E0632C5A41666666660A352441666666465E2C5A4166666666D0342441000000A0572C5A4166666666E333244133333313662C5A419A999999CD3324419A9999B96C2C5A419A999999CD3324419A9999B96C2C5A41	01010000206A080000141C3DE177372441333333C36F2C5A41	940330110	H	Bois Cadet 1	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000003B0000000000000055312441CDCCCC4C492C5A4166666666D831244133333313482C5A410000000062322441333333D34D2C5A4100000000953224419A9999394E2C5A41000000002F342441CDCCCCAC4A2C5A41333333337B3424419A9999F9462C5A41CDCCCCCCDC34244133333393392C5A41666666660E352441CDCCCCCC412C5A419A99999915352441CDCCCC4C4D2C5A41CDCCCCCC0735244100000080522C5A4166666666D0342441000000A0572C5A41666666660A352441666666465E2C5A41CDCCCCCC5C352441000000E0632C5A416666666674352441000000A0632C5A41CDCCCCCC7435244100000040682C5A419A99999990352441333333136D2C5A41CDCCCCCC9335244166666606742C5A416666666635362441333333D3742C5A410000000036362441666666C6702C5A4100000000A736244166666626622C5A41CDCCCCCC81362441CDCCCCCC5D2C5A419A9999997C362441333333735A2C5A4166666666FA362441666666863F2C5A4133333333113724419A999939322C5A416666666633372441CDCCCC8C282C5A4100000000B7372441CDCCCC0C2D2C5A416666666629392441666666063B2C5A413333333343392441CDCCCCCC2C2C5A4100000000FB38244166666686282C5A41CDCCCCCC43382441000000A01A2C5A4133333333B4372441666666A60D2C5A41CDCCCCCC4B37244133333313092C5A41666666660A372441666666C6002C5A41000000000037244133333373032C5A4166666666D6362441CDCCCCCC012C5A4166666666B8362441000000A0FB2B5A4166666666EB362441000000A0F52B5A4133333333B836244166666606EF2B5A419A9999995736244166666666EA2B5A419A9999994A362441000000E0E52B5A413333333351362441000000A0D22B5A419A999999CC35244100000060CC2B5A419A999999F035244133333393B32B5A4166666666C1352441CDCCCCECAD2B5A4100000000F6342441000000A0AB2B5A41666666666D34244166666666972B5A4133333333E23324419A999979982B5A41CDCCCCCCAF332441333333F3972B5A419A99999972332441CDCCCC0C942B5A413333333383322441333333338B2B5A413333333355322441666666A6A22B5A419A9999991932244133333353BE2B5A41333333331232244166666666C82B5A419A999999F331244133333373D12B5A4166666666F9312441CDCCCC4CD72B5A4100000000E13124419A9999F9232C5A419A999999D6312441000000802B2C5A410000000055312441CDCCCC4C492C5A410000000055312441CDCCCC4C492C5A41	01010000206A0800009AF3C1625B34244133333303FF2B5A41	940330111	H	Bois Cadet 2	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000002A000000CDCCCCCC7D30244133333313502C5A4166666666C330244100000040642C5A4100000000D630244166666606662C5A4166666666C0302441666666266A2C5A4166666666E6302441666666E66E2C5A4100000000253124419A9999796F2C5A41CDCCCCCC9B312441333333D3632C5A419A999999C0312441CDCCCCCC662C5A419A9999998232244100000000682C5A41CDCCCCCC9A322441CDCCCC6C652C5A41CDCCCCCCA5322441333333136D2C5A419A9999998F322441CDCCCCEC7B2C5A41CDCCCCCC8F322441666666E6882C5A419A9999997C322441333333338D2C5A41333333337F3224419A9999D9932C5A41333333335D322441CDCCCCCC9B2C5A413333333359322441666666A6AC2C5A4166666666B033244166666666AB2C5A4100000000C83324419A999939AF2C5A4166666666D834244166666686AF2C5A4100000000963524419A9999D9AE2C5A4166666666D83524419A999939AA2C5A4133333333D1342441333333938D2C5A41CDCCCCCC82342441666666C6852C5A41CDCCCCCC8534244166666626842C5A41CDCCCCCC273424419A9999B97B2C5A4100000000D133244133333393702C5A4166666666D23324419A9999D9682C5A4166666666E333244133333313662C5A4100000000D734244100000040572C5A419A999999FD342441000000E0532C5A419A99999915352441CDCCCC4C4D2C5A41666666660E352441CDCCCCCC412C5A41CDCCCCCCDC34244133333393392C5A41333333337B3424419A9999F9462C5A41000000002F342441CDCCCCAC4A2C5A4100000000953224419A9999394E2C5A410000000062322441333333D34D2C5A4166666666D831244133333313482C5A41CDCCCCCC1E312441333333D3492C5A41CDCCCCCC7D30244133333313502C5A41CDCCCCCC7D30244133333313502C5A41	01010000206A0800005EF115FF40332441CCCCCC9C732C5A41	940330112	H	Bois Cadet 3	9403301	94033	94	11	0
01060000206A080000010000000103000000010000009700000000000000B62B244166666606BB2C5A419A999999C22B2441666666A6BB2C5A41CDCCCCCCD02B244133333373BC2C5A4133333333DF2B244166666646BD2C5A41000000000D2C2441CDCCCC2CC02C5A4133333333202C2441000000A0C12C5A4100000000352C24419A999959C32C5A41333333334D2C2441000000A0C52C5A4166666666632C2441CDCCCCECC72C5A41CDCCCCCC8F2C244166666646CD2C5A4133333333C52C2441CDCCCC8CD32C5A419A999999DE2C244100000080D52C5A4133333333F12C244133333353D52C5A41CDCCCCCC062D244100000080D52C5A419A9999996F2D244133333333D92C5A4100000000922D244133333373DA2C5A419A999999B82D2441000000C0DB2C5A419A999999E52D24419A9999F9DC2C5A41CDCCCCCC102E244100000080DD2C5A41CDCCCCCC472E2441333333D3DD2C5A419A9999997A2E2441CDCCCC8CDD2C5A41333333339D2E244166666626DD2C5A4133333333D02E2441333333F3DB2C5A41CDCCCCCCE72E244166666626DB2C5A41CDCCCCCC2D2F24419A999939D82C5A41666666668B2F24419A999999D32C5A419A999999D62F2441666666E6CF2C5A4100000000EA2F24419A9999F9CE2C5A4133333333043024419A999979CD2C5A41666666661F302441666666E6CB2C5A41CDCCCCCC3630244100000060CA2C5A416666666655302441CDCCCC4CC82C5A41000000007630244100000020C62C5A41CDCCCCCC983024419A9999F9C32C5A4166666666AE30244133333393C22C5A419A999999BC302441666666A6C12C5A4100000000E4302441CDCCCC2CBF2C5A419A9999990C31244100000000BD2C5A41CDCCCCCC2E3124419A999939BB2C5A41CDCCCCCC4631244100000040BA2C5A419A99999970312441CDCCCC6CB82C5A4100000000B63124419A999959B62C5A4100000000EB31244166666606B52C5A41CDCCCCCC20322441CDCCCC2CB42C5A419A99999943322441333333D3B32C5A4100000000C13224419A999919B32C5A419A999999DD322441CDCCCC0CB32C5A419A99999905332441666666E6B22C5A41666666662033244133333353B22C5A41666666663233244100000020B22C5A416666666643332441666666E6B12C5A41CDCCCCCC53332441666666A6B12C5A41CDCCCCCC6133244166666666B12C5A419A9999996F3324419A999919B12C5A41000000007B332441666666C6B02C5A413333333386332441CDCCCC6CB02C5A416666666691332441000000E0AF2C5A41000000009633244166666646AF2C5A41000000009C332441333333D3AE2C5A4133333333A43324419A999979AE2C5A4100000000AD33244166666646AE2C5A4166666666B433244166666646AE2C5A419A999999BB33244133333373AE2C5A4166666666B033244166666666AB2C5A41666666669333244166666666AB2C5A41000000006733244166666686AB2C5A41000000004C332441333333B3AB2C5A41000000002333244100000000AC2C5A41000000009F32244100000060AC2C5A413333333359322441666666A6AC2C5A41333333335A3224419A999999A82C5A41CDCCCCCC58322441CDCCCC4CA42C5A41CDCCCCCC583224419A9999B99F2C5A41333333335D322441CDCCCCCC9B2C5A41666666666C32244166666606982C5A41CDCCCCCC77322441666666E6952C5A41CDCCCCCC7C32244100000020952C5A41333333337F3224419A9999D9932C5A419A9999997C322441333333338D2C5A41CDCCCCCC8F322441666666E6882C5A419A9999998F322441CDCCCCEC7B2C5A4133333333933224419A9999D9772C5A41666666669B322441333333B3742C5A41666666669F322441333333B3712C5A41CDCCCCCCA5322441333333136D2C5A41CDCCCCCC9A322441CDCCCC6C652C5A419A99999994322441333333F3652C5A419A9999999332244133333313662C5A419A9999998232244100000000682C5A416666666651322441666666E6672C5A41333333331B322441000000E0672C5A41000000001132244133333333672C5A416666666603322441000000C0662C5A4133333333F7312441333333D3662C5A419A999999C93124419A9999D9662C5A419A999999C0312441CDCCCCCC662C5A4166666666AE3124419A9999D9652C5A4166666666A531244166666666642C5A41CDCCCCCCA0312441333333D3632C5A41CDCCCCCC9B312441333333D3632C5A4166666666953124419A999959642C5A41000000008B31244166666666652C5A419A9999998031244133333373662C5A41000000006B31244100000080682C5A41CDCCCCCC58312441333333536A2C5A410000000037312441CDCCCCCC6D2C5A4100000000253124419A9999796F2C5A41333333331F312441666666E66F2C5A41000000001931244100000020702C5A419A9999991131244133333333702C5A41666666660A312441CDCCCC2C702C5A4133333333033124419A9999F96F2C5A419A999999FB302441666666C66F2C5A4100000000F5302441CDCCCC8C6F2C5A4166666666E6302441666666E66E2C5A4166666666C0302441666666266A2C5A419A999999CB302441CDCCCC4C682C5A4100000000D630244166666606662C5A4166666666C330244100000040642C5A4133333333B730244166666666602C5A41CDCCCCCCAB302441333333135D2C5A41CDCCCCCC85302441CDCCCC0C532C5A41CDCCCCCC7D30244133333313502C5A41CDCCCCCC6B302441CDCCCC2C512C5A41CDCCCCCC58302441000000E0522C5A4100000000323024419A999979562C5A419A99999906302441666666665A2C5A4133333333E22F2441333333935D2C5A419A999999A72F2441666666E6622C5A4166666666732F2441CDCCCCCC672C5A4100000000432F2441333333336C2C5A41CDCCCCCCDE2E2441CDCCCC0C752C5A4133333333792E2441CDCCCCEC7D2C5A419A999999882E244166666626822C5A4100000000FF2D2441333333738C2C5A4100000000702D2441CDCCCCAC962C5A4166666666582D24419A999959982C5A41CDCCCCCC1B2D2441666666C69C2C5A41CDCCCCCCDD2C2441CDCCCCCCA12C5A4166666666C02C24419A999999A32C5A4166666666942C24419A999939A62C5A4100000000882C244133333333A72C5A4166666666442C24419A999979AF2C5A41333333332C2C244166666646B22C5A4166666666142C244166666666B42C5A4100000000062C244133333393B52C5A4166666666F52B2441000000A0B62C5A4133333333E12B2441666666A6B72C5A4166666666CD2B24419A999999B82C5A4133333333C22B2441666666A6B92C5A4100000000B62B244166666606BB2C5A41	01060000206A080000010000000103000000010000002B00000000000000B62B244166666606BB2C5A41000000000D2C2441CDCCCC2CC02C5A4166666666632C2441CDCCCCECC72C5A4133333333C52C2441CDCCCC8CD32C5A419A999999E52D24419A9999F9DC2C5A41CDCCCCCC472E2441333333D3DD2C5A41333333339D2E244166666626DD2C5A41CDCCCCCC2D2F24419A999939D82C5A4100000000EA2F24419A9999F9CE2C5A4100000000E4302441CDCCCC2CBF2C5A419A99999970312441CDCCCC6CB82C5A4100000000EB31244166666606B52C5A419A99999943322441333333D3B32C5A419A99999905332441666666E6B22C5A419A9999996F3324419A999919B12C5A419A999999BB33244133333373AE2C5A4166666666B033244166666666AB2C5A413333333359322441666666A6AC2C5A41333333335D322441CDCCCCCC9B2C5A41333333337F3224419A9999D9932C5A419A9999997C322441333333338D2C5A41CDCCCCCC8F322441666666E6882C5A419A9999998F322441CDCCCCEC7B2C5A41CDCCCCCCA5322441333333136D2C5A41CDCCCCCC9A322441CDCCCC6C652C5A419A9999998232244100000000682C5A419A999999C0312441CDCCCCCC662C5A41CDCCCCCC9B312441333333D3632C5A4100000000253124419A9999796F2C5A4166666666E6302441666666E66E2C5A4166666666C0302441666666266A2C5A4100000000D630244166666606662C5A4166666666C330244100000040642C5A41CDCCCCCC7D30244133333313502C5A41CDCCCCCC6B302441CDCCCC2C512C5A4100000000432F2441333333336C2C5A4133333333792E2441CDCCCCEC7D2C5A419A999999882E244166666626822C5A41CDCCCCCC1B2D2441666666C69C2C5A4100000000882C244133333333A72C5A41333333332C2C244166666646B22C5A4100000000B62B244166666606BB2C5A4100000000B62B244166666606BB2C5A41	01010000206A080000ED8E5F41EB2F24419A999959972C5A41	940330113	H	Michelet	9403301	94033	94	11	0
01060000206A080000010000000103000000010000006D000000CDCCCCCC122E2441CDCCCC2C9B2B5A4166666666152E2441333333539D2B5A419A999999362E244133333333AF2B5A41333333334C2E2441666666C6BA2B5A4166666666722E24419A9999D9CD2B5A419A999999782E2441666666E6D02B5A41CDCCCCCC852E244166666666D72B5A419A9999998E2E2441666666C6DB2B5A4133333333992E2441333333B3E22B5A4133333333962E24419A999979E52B5A4133333333932E244133333353E82B5A41666666668C2E244166666686EC2B5A41333333337D2E2441CDCCCC0CF52B5A4100000000752E244166666626FA2B5A4100000000692E244100000080002C5A41333333335C2E244133333313062C5A4133333333672E24419A999979062C5A419A999999722E2441666666A6062C5A41CDCCCCCC8B2E244133333353062C5A4100000000DA2E244133333373042C5A41333333331D2F2441CDCCCCAC022C5A4133333333642F2441333333D3002C5A4133333333912F2441333333D3FF2B5A41CDCCCCCCE12F244100000040FE2B5A4166666666E82F2441333333B3FE2B5A4166666666F92F2441CDCCCC0C002C5A41000000002A302441000000A0042C5A4166666666493024419A999999072C5A410000000073302441333333730B2C5A419A999999733024419A9999B90C2C5A41CDCCCCCC75302441000000A00E2C5A41333333337C3024419A999919122C5A413333333381302441000000A0142C5A416666666697302441CDCCCC8C1F2C5A4100000000A0302441CDCCCCAC232C5A4166666666A63024419A9999F9262C5A4166666666C73024419A999939272C5A419A999999C8302441CDCCCCEC282C5A4133333333CC302441333333B32E2C5A4100000000D130244166666626362C5A4166666666E9302441000000804B2C5A41CDCCCCCC013124419A9999B94A2C5A41CDCCCCCC1E312441333333D3492C5A419A9999993E31244133333353492C5A410000000055312441CDCCCC4C492C5A419A9999997631244100000060412C5A416666666695312441666666A63A2C5A4100000000A831244100000060362C5A419A999999C03124419A9999B9302C5A4166666666CF312441666666862D2C5A419A999999D6312441000000802B2C5A4133333333DC312441000000A0282C5A4100000000E13124419A9999F9232C5A4133333333E2312441CDCCCC6C1D2C5A41CDCCCCCCE83124419A9999390C2C5A41CDCCCCCCE9312441CDCCCC8C092C5A4100000000EB31244100000080062C5A419A999999EE31244100000040FD2B5A4166666666F631244100000000E12B5A4166666666F9312441CDCCCC4CD72B5A4133333333F931244100000020D42B5A419A999999F7312441000000E0D22B5A419A999999F331244133333373D12B5A41CDCCCCCCF7312441CDCCCC2CD12B5A419A999999FB31244133333393D02B5A4166666666FD312441666666E6CF2B5A419A999999FC312441666666E6CE2B5A419A9999990132244100000040CD2B5A41666666660A32244100000080CA2B5A41333333331232244166666666C82B5A41666666660C32244133333353C82B5A419A99999907322441CDCCCCECC72B5A4100000000053224419A999959C72B5A419A999999033224419A9999F9C62B5A41666666660432244166666606C62B5A419A9999990632244166666686C52B5A41666666660A3224419A999939C52B5A41666666660D322441CDCCCC0CC52B5A416666666611322441333333F3C42B5A419A9999991932244133333353BE2B5A416666666628322441CDCCCC4CB72B5A41666666668331244166666606AC2B5A419A99999934312441333333F3A62B5A4100000000C2302441666666E6A22B5A4133333333C1302441000000C0A02B5A4100000000BE302441CDCCCC4C9D2B5A4133333333BA302441333333539B2B5A4166666666A0302441CDCCCC2C952B5A41CDCCCCCC983024419A999959932B5A41666666667C302441666666A68C2B5A41CDCCCCCC63302441000000A0802B5A419A9999994C3024419A999959772B5A41333333333F302441000000E0752B5A41CDCCCCCC103024419A999999722B5A4166666666DE2F2441666666E66E2B5A4100000000952F2441CDCCCCCC692B5A4100000000472F2441CDCCCCEC632B5A4133333333A72E2441CDCCCC6C582B5A41CDCCCCCC8E2E2441000000605D2B5A4100000000732E2441000000E0622B5A4100000000532E244133333353682B5A41333333334D2E2441666666A66D2B5A4100000000422E244133333353762B5A41333333333B2E24419A9999997B2B5A419A999999232E2441CDCCCC2C8E2B5A4100000000212E244133333313902B5A419A999999202E244100000060902B5A4166666666202E244133333373902B5A41CDCCCCCC122E2441CDCCCC2C9B2B5A41	01060000206A080000010000000103000000010000001F000000CDCCCCCC122E2441CDCCCC2C9B2B5A41333333334C2E2441666666C6BA2B5A419A9999998E2E2441666666C6DB2B5A4133333333992E2441333333B3E22B5A4100000000752E244166666626FA2B5A41333333335C2E244133333313062C5A41CDCCCCCC8B2E244133333353062C5A4133333333642F2441333333D3002C5A41CDCCCCCCE12F244100000040FE2B5A410000000073302441333333730B2C5A4166666666A63024419A9999F9262C5A4166666666C73024419A999939272C5A4100000000D130244166666626362C5A4166666666E9302441000000804B2C5A410000000055312441CDCCCC4C492C5A419A999999D6312441000000802B2C5A4100000000E13124419A9999F9232C5A4166666666F9312441CDCCCC4CD72B5A419A999999F331244133333373D12B5A41333333331232244166666666C82B5A416666666628322441CDCCCC4CB72B5A419A99999934312441333333F3A62B5A4100000000C2302441666666E6A22B5A4133333333BA302441333333539B2B5A41666666667C302441666666A68C2B5A419A9999994C3024419A999959772B5A41333333333F302441000000E0752B5A4133333333A72E2441CDCCCC6C582B5A4100000000532E244133333353682B5A41CDCCCCCC122E2441CDCCCC2C9B2B5A41CDCCCCCC122E2441CDCCCC2C9B2B5A41	01010000206A080000F6B5C561383024419A999929D22B5A41	940330114	H	Le Village 1	9403301	94033	94	11	0
01060000206A0800000100000001030000000100000039000000CDCCCCCC6C2A2441333333F3B62B5A41CDCCCCCCA42A2441CDCCCCCCBD2B5A419A999999D32A244100000060C42B5A4100000000092B2441CDCCCC2CCC2B5A41CDCCCCCC5D2B244133333373D92B5A419A999999BF2B2441666666C6E82B5A4133333333D22B244133333313EC2B5A4100000000A12C2441CDCCCC2CF52B5A4133333333E02C244100000040F82B5A419A999999F82C2441666666A6FA2B5A41CDCCCCCC172D24419A999979FE2B5A4166666666242D2441CDCCCC2CFE2B5A41CDCCCCCC562D244133333393FD2B5A4166666666952D244133333393FC2B5A419A999999B02D244133333313FC2B5A4100000000DA2D24419A999959FB2B5A41CDCCCCCCF02D244133333313FB2B5A41CDCCCCCC052E2441333333D3FA2B5A419A999999152E24419A9999D9F92B5A41CDCCCCCC1C2E244133333373F92B5A419A999999402E244166666686F72B5A419A999999492E244133333313F72B5A41000000005D2E24419A999919F62B5A4166666666672E2441CDCCCCACF52B5A41333333337D2E2441CDCCCC0CF52B5A41666666668C2E244166666686EC2B5A4133333333932E244133333353E82B5A4133333333962E24419A999979E52B5A4133333333992E2441333333B3E22B5A419A9999998E2E2441666666C6DB2B5A41CDCCCCCC852E244166666666D72B5A419A999999782E2441666666E6D02B5A4166666666722E24419A9999D9CD2B5A41333333334C2E2441666666C6BA2B5A419A999999362E244133333333AF2B5A4166666666152E2441333333539D2B5A41CDCCCCCC122E2441CDCCCC2C9B2B5A4166666666202E244133333373902B5A419A999999202E244100000060902B5A4100000000212E244133333313902B5A419A999999F22D2441000000408D2B5A41CDCCCCCCE92D2441CDCCCCAC8C2B5A4166666666522C2441CDCCCCEC732B5A4100000000382C244166666646722B5A41333333331C2C2441CDCCCC8C702B5A419A999999162C2441000000C0712B5A4133333333122C24419A9999B9722B5A41CDCCCCCC072C24419A9999D9742B5A4133333333EA2B2441333333937A2B5A419A999999D62B2441CDCCCC0C7E2B5A4166666666B92B24419A999979822B5A41CDCCCCCC7A2B24419A9999198C2B5A4166666666432B24419A9999F9942B5A419A999999212B2441CDCCCC6C9A2B5A4166666666B62A244100000000AB2B5A419A999999922A2441CDCCCC8CB02B5A41CDCCCCCC6C2A2441333333F3B62B5A41	01060000206A0800000100000001030000000100000012000000CDCCCCCC6C2A2441333333F3B62B5A41CDCCCCCCA42A2441CDCCCCCCBD2B5A4100000000092B2441CDCCCC2CCC2B5A4133333333D22B244133333313EC2B5A4133333333E02C244100000040F82B5A41CDCCCCCC172D24419A999979FE2B5A41CDCCCCCC052E2441333333D3FA2B5A41333333337D2E2441CDCCCC0CF52B5A4133333333992E2441333333B3E22B5A419A9999998E2E2441666666C6DB2B5A41333333334C2E2441666666C6BA2B5A41CDCCCCCC122E2441CDCCCC2C9B2B5A4100000000212E244133333313902B5A41333333331C2C2441CDCCCC8C702B5A419A999999D62B2441CDCCCC0C7E2B5A419A999999922A2441CDCCCC8CB02B5A41CDCCCCCC6C2A2441333333F3B62B5A41CDCCCCCC6C2A2441333333F3B62B5A41	01010000206A080000D0357788622C2441CCCCCCDCB82B5A41	940330115	H	Le Village 2	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000002100000000000000A72B2441000000004F2C5A4133333333062C244166666626612C5A41666666664D2C24419A9999396C2C5A419A9999991E2C2441000000E07D2C5A41CDCCCCCC202C2441CDCCCC8C7F2C5A41CDCCCCCCDD2C2441CDCCCCCCA12C5A41CDCCCCCC1B2D2441666666C69C2C5A419A999999882E244166666626822C5A4133333333792E2441CDCCCCEC7D2C5A4100000000432F2441333333336C2C5A41CDCCCCCC6B302441CDCCCC2C512C5A4166666666E9302441000000804B2C5A4100000000D130244166666626362C5A4166666666C73024419A999939272C5A4166666666A63024419A9999F9262C5A410000000073302441333333730B2C5A41CDCCCCCCE12F244100000040FE2B5A4133333333642F2441333333D3002C5A41CDCCCCCC8B2E244133333353062C5A41333333335C2E244133333313062C5A41333333337D2E2441CDCCCC0CF52B5A41CDCCCCCC052E2441333333D3FA2B5A41CDCCCCCC172D24419A999979FE2B5A4100000000672D2441333333130E2C5A41000000007E2D244133333393142C5A4166666666A82D2441333333131B2C5A4166666666D22D24419A999939252C5A41CDCCCCCC872D244100000040282C5A41CDCCCCCC142D2441333333732E2C5A4166666666A12C2441666666E6352C5A41CDCCCCCC742C2441CDCCCCCC3E2C5A4100000000A72B2441000000004F2C5A4100000000A72B2441000000004F2C5A41	01010000206A08000088888808642E2441000000A04A2C5A41	940330117	H	Le Village 4	9403301	94033	94	11	0
01060000206A0800000100000001030000000100000055000000CDCCCCCC0325244166666646652C5A419A99999905252441CDCCCC8C652C5A419A99999907252441CDCCCCCC652C5A41000000000B25244133333313662C5A41666666660E2524419A999919662C5A41333333331225244133333313662C5A416666666617252441666666E6652C5A4100000000202524419A9999D9672C5A419A9999992B252441CDCCCCEC6A2C5A41CDCCCCCC35252441000000406E2C5A41000000003D252441000000A0702C5A41666666664225244166666606732C5A41333333334625244100000080752C5A41CDCCCCCC472524419A999959772C5A41CDCCCCCC50252441CDCCCC8C772C5A41333333335B25244100000040782C5A41CDCCCCCC6B252441666666C67B2C5A41333333338F25244100000020862C5A413333333396252441000000A0882C5A41CDCCCCCC9B252441333333F38A2C5A4133333333A02524419A9999798D2C5A4133333333A3252441333333F38F2C5A4100000000A525244133333393922C5A4133333333A525244133333353952C5A4133333333A425244166666626992C5A4100000000A2252441666666469D2C5A413333333334262441CDCCCC4C952C5A419A9999997826244133333353912C5A4166666666D0262441333333138C2C5A4100000000B526244100000040852C5A4166666666D8262441000000A0822C5A41CDCCCCCC34272441333333937B2C5A410000000080272441333333F3752C5A41CDCCCCCCA9272441666666C6722C5A41CDCCCCCCB22724419A999959742C5A4166666666BA272441000000A0752C5A41CDCCCCCC0228244133333373802C5A419A99999940282441000000E0892C5A41000000006E28244100000020912C5A41CDCCCCCC802824419A9999B98E2C5A4133333333A328244133333353892C5A4133333333AE28244166666606882C5A4166666666DB2824419A9999D9832C5A41000000000929244133333353802C5A413333333328292441666666467E2C5A41666666665D292441CDCCCC4C7B2C5A41333333331C2A2441CDCCCC8C712C5A41CDCCCCCC582A24419A9999796E2C5A4166666666062A2441666666665C2C5A4100000000BD2924419A9999F94C2C5A4166666666B1292441333333334B2C5A4100000000D0292441CDCCCC6C492C5A4166666666E9292441666666C6472C5A41000000008C29244166666606332C5A419A9999997D29244133333333342C5A41000000005E2924419A9999D9362C5A41000000004C2924419A999959382C5A41666666661F292441CDCCCC0C3B2C5A41666666667B2824419A9999D9442C5A419A99999923282441CDCCCCEC482C5A41CDCCCCCC0D2824419A9999F9492C5A419A99999901282441CDCCCCAC4A2C5A4100000000F8272441CDCCCC4C4B2C5A4100000000EE272441333333534C2C5A41CDCCCCCCE4272441000000204D2C5A41CDCCCCCCDB272441CDCCCCAC4D2C5A4100000000D02724419A9999394E2C5A419A999999C5272441CDCCCCCC4E2C5A4100000000B92724419A9999B94F2C5A41CDCCCCCC222724419A999919542C5A4100000000E02624419A999919562C5A419A9999997E262441333333D3582C5A41000000003C262441000000C05A2C5A41CDCCCCCC03262441666666665C2C5A41CDCCCCCCBD252441333333535E2C5A419A99999975252441CDCCCC6C602C5A4166666666422524419A999919622C5A41CDCCCCCC1B25244133333393632C5A41CDCCCCCC192524419A999939632C5A410000000017252441CDCCCCEC622C5A416666666612252441666666A6622C5A419A9999990E252441CDCCCC8C622C5A419A9999990B252441000000A0622C5A41333333331025244100000060642C5A41CDCCCCCC0325244166666646652C5A41	01060000206A080000010000000103000000010000001C000000CDCCCCCC0325244166666646652C5A416666666617252441666666E6652C5A41000000003D252441000000A0702C5A41CDCCCCCC472524419A999959772C5A41CDCCCCCC6B252441666666C67B2C5A41CDCCCCCC9B252441333333F38A2C5A4100000000A525244133333393922C5A4100000000A2252441666666469D2C5A413333333334262441CDCCCC4C952C5A4166666666D0262441333333138C2C5A4100000000B526244100000040852C5A41CDCCCCCCA9272441666666C6722C5A41000000006E28244100000020912C5A4133333333A328244133333353892C5A41000000000929244133333353802C5A41666666665D292441CDCCCC4C7B2C5A41CDCCCCCC582A24419A9999796E2C5A4166666666062A2441666666665C2C5A4166666666B1292441333333334B2C5A4166666666E9292441666666C6472C5A41000000008C29244166666606332C5A41000000004C2924419A999959382C5A41666666667B2824419A9999D9442C5A41CDCCCCCC0D2824419A9999F9492C5A4100000000B92724419A9999B94F2C5A419A99999975252441CDCCCC6C602C5A41CDCCCCCC0325244166666646652C5A41CDCCCCCC0325244166666646652C5A41	01010000206A08000036E01EB4B327244134333363692C5A41	940330118	H	Roublot 1	9403301	94033	94	11	0
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	01060000206A08000001000000010300000001000000280000006666666696252441000000E0BC2C5A4166666666D6252441CDCCCCACC12C5A41333333332E262441333333F3C32C5A41CDCCCCCC61262441CDCCCC0CC42C5A41CDCCCCCCAA262441CDCCCCCCC12C5A41333333339C272441000000A0B52C5A419A9999994828244166666646B12C5A419A999999D7282441666666E6B02C5A4100000000222B244166666646B62C5A4100000000B62B244166666606BB2C5A41333333332C2C244166666646B22C5A4100000000882C244133333333A72C5A41CDCCCCCCDD2C2441CDCCCCCCA12C5A41CDCCCCCC202C2441CDCCCC8C7F2C5A419A9999991E2C2441000000E07D2C5A41666666664D2C24419A9999396C2C5A4133333333062C244166666626612C5A4100000000A72B2441000000004F2C5A4133333333222C244133333313452C5A4166666666842B2441333333F3282C5A41333333332A2B24419A9999592F2C5A41000000009A2A2441333333B33C2C5A41CDCCCCCC282A2441CDCCCCAC242C5A41000000008C29244166666606332C5A4166666666E9292441666666C6472C5A4166666666B1292441333333334B2C5A4166666666062A2441666666665C2C5A41CDCCCCCC582A24419A9999796E2C5A41666666665D292441CDCCCC4C7B2C5A41000000000929244133333353802C5A4133333333A328244133333353892C5A41000000006E28244100000020912C5A41CDCCCCCCA9272441666666C6722C5A4100000000B526244100000040852C5A4166666666D0262441333333138C2C5A413333333334262441CDCCCC4C952C5A4100000000A2252441666666469D2C5A41CDCCCCCC9D25244100000000B42C5A416666666696252441000000E0BC2C5A416666666696252441000000E0BC2C5A41	01010000206A080000661C0092072B2441CDCCCCFC742C5A41	940330119	H	Roublot 2	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000001600000000000000D124244166666646242C5A41CDCCCCCCF7242441666666063E2C5A41CDCCCCCC06252441000000004B2C5A4100000000E0242441CDCCCCEC4B2C5A419A9999990B252441000000A0622C5A41CDCCCCCC1B25244133333393632C5A419A99999975252441CDCCCC6C602C5A4100000000B92724419A9999B94F2C5A41CDCCCCCC0D2824419A9999F9492C5A41666666667B2824419A9999D9442C5A41000000004C2924419A999959382C5A41CDCCCCCC282A2441CDCCCCAC242C5A4133333333EA2824419A9999B9DF2B5A41CDCCCCCCA2282441000000C0D02B5A41CDCCCCCCD3272441666666E6D82B5A419A9999999527244133333333DC2B5A41000000005227244166666686E12B5A410000000086262441000000C0E82B5A410000000007252441000000000E2C5A419A9999991F252441333333531E2C5A4100000000D124244166666646242C5A4100000000D124244166666646242C5A41	01010000206A080000D0F92FA68527244100000030192C5A41	940330120	H	Pasteur	9403301	94033	94	11	0
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	01060000206A080000010000000103000000010000002B000000CDCCCCCC2A2024419A999919F92B5A41666666662D20244100000020042C5A419A9999993D2024419A9999B9162C5A419A999999D520244100000020142C5A41000000007421244133333353102C5A413333333343222441000000600A2C5A419A9999997E2424419A9999D9F62B5A4133333333E8252441CDCCCC4CEA2B5A4100000000F6252441333333B3F62B5A410000000086262441000000C0E82B5A41000000005227244166666686E12B5A419A9999999527244133333333DC2B5A41CDCCCCCCD3272441666666E6D82B5A41CDCCCCCCD72924419A9999F9C42B5A41CDCCCCCCA42A2441CDCCCCCCBD2B5A41CDCCCCCC6C2A2441333333F3B62B5A419A999999922A2441CDCCCC8CB02B5A419A999999D62B2441CDCCCC0C7E2B5A41CDCCCCCC072C24419A9999D9742B5A4133333333952C244100000040572B5A4133333333552C2441CDCCCCEC522B5A41CDCCCCCC4C2B2441CDCCCC8C3E2B5A4133333333142B2441666666664C2B5A4133333333A52A24419A999979632B5A419A999999372A244133333373752B5A419A999999ED2924419A9999F97E2B5A41000000004429244166666646902B5A4166666666C1282441333333939A2B5A413333333327282441CDCCCC2CA42B5A4133333333B4272441CDCCCC0CAA2B5A41000000000E272441333333F3B02B5A419A999999552624419A9999F9B72B5A419A999999482524419A9999F9BF2B5A419A9999995C242441CDCCCC0CC62B5A41666666666823244133333353CB2B5A4166666666782224419A9999D9D12B5A4133333333DE212441CDCCCCCCD62B5A419A99999921212441333333D3DB2B5A41333333332C2024419A999939E12B5A41CDCCCCCC38202441CDCCCCCCEC2B5A41666666663A2024419A9999D9F82B5A41CDCCCCCC2A2024419A999919F92B5A41CDCCCCCC2A2024419A999919F92B5A41	01010000206A0800002F998A1D3129244166666686AA2B5A41	940330121	H	Bois	9403301	94033	94	11	0
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	01010000206A0800002794682063DF2341000000804D225A41	940340101	A	Cerisaie-Médicis	9403401	94034	94	11	1
01060000206A08000001000000010300000001000000990000000000000081D723410000004042225A41000000008AD72341CDCCCCAC42225A419A9999998ED723413333331343225A416666666691D72341666666A643225A419A99999993D723410000000045225A41CDCCCCCC93D723416666664646225A41CDCCCCCC92D72341000000404A225A413333333391D72341CDCCCC8C4D225A413333333392D723410000004052225A413333333393D72341CDCCCC6C54225A410000000096D72341666666A656225A416666666698D723419A99991958225A41CDCCCCCC9AD723416666666659225A419A999999A7D723419A9999995E225A4166666666E7D72341CDCCCC4C5B225A413333333325D82341CDCCCC8C56225A41CDCCCCCC43D823416666666654225A410000000049D82341000000A053225A41666666664BD823410000004053225A413333333358D823419A9999794D225A41CDCCCCCCDBD823410000008052225A41CDCCCCCC6CD92341CDCCCC4C58225A419A99999987D923416666668659225A419A99999988D92341666666465A225A41000000008BD92341000000205B225A41333333338FD92341333333F35B225A416666666694D923419A9999B95C225A41666666669AD92341000000605D225A4133333333A1D92341333333B35D225A4133333333A8D92341333333D35D225A4100000000B1D923419A9999995D225A4166666666B9D92341000000405D225A419A999999B7D92341CDCCCCCC5E225A4133333333B3D923419A99997960225A419A9999999BD923413333339368225A410000000085D923413333335370225A41CDCCCCCC75D92341333333D375225A41333333335FD92341333333F37F225A419A99999949D92341CDCCCC4C88225A416666666650D923419A99999989225A410000000064D923419A9999F98C225A41CDCCCCCC0EDA2341333333F381225A4100000000D9DA23410000002075225A419A999999F7DA23410000002073225A419A9999990BDB2341CDCCCCAC71225A41CDCCCCCC19DB2341CDCCCC6C70225A419A99999924DB23419A9999196F225A41000000002DDB2341666666A66D225A410000000050DB23410000008070225A419A9999994FDB2341CDCCCC2C6F225A41CDCCCCCC4FDB2341CDCCCC0C6D225A413333333352DB2341333333536B225A419A99999958DB23419A9999F969225A413333333360DB23416666660669225A416666666668DB23419A99993968225A413333333375DB23416666662667225A41666666664ADB23413333333363225A413333333340DB2341666666C661225A41666666663ADB2341CDCCCCAC60225A410000000035DB2341666666A65F225A41666666662BDB2341666666465D225A416666666621DB2341333333B35A225A419A99999910DB23419A99997956225A419A999999FDDA2341000000C051225A4100000000DDDA23410000004049225A4166666666B1DA2341000000003F225A419A99999986DA23416666664634225A410000000079DA23413333339330225A41000000006EDA23419A99995931225A41666666664DDA23413333337329225A41333333332CDA23413333339321225A41CDCCCCCC21DA2341333333F31E225A41000000000DDA23419A9999B919225A419A999999F5D92341CDCCCCAC13225A4166666666F0D923416666664612225A4133333333EDD923419A99993911225A4100000000E9D923419A9999F90F225A419A999999E5D923419A9999B90E225A4166666666E4D92341CDCCCC8C0D225A4166666666E4D923419A9999990C225A419A999999E6D923419A9999590B225A4100000000E9D92341000000400A225A4166666666EBD923410000008009225A419A999999EFD92341333333D308225A4100000000F4D92341CDCCCC2C08225A4166666666EFD923419A9999D907225A41CDCCCCCCE9D92341000000A007225A419A999999E1D923410000008007225A41CDCCCCCCDBD92341333333B304225A4166666666D5D923419A99993903225A419A999999BBD923419A9999F9FE215A41CDCCCCCCADD92341CDCCCC8CFB215A41CDCCCCCCAED9234166666646FA215A413333333320DA2341CDCCCC4CF1215A416666666639DA234100000040EF215A41333333334BDA2341333333B3ED215A416666666642DA2341CDCCCC8CEB215A419A99999932DA23419A9999D9E7215A416666666622DA234166666606E4215A413333333314DA2341CDCCCCACE0215A410000000009DA2341666666E6DD215A41CDCCCCCC05DA23419A9999D9DB215A419A999999ECD9234100000080DB215A4166666666C2D9234133333333D1215A419A999999B5D9234100000020CE215A41000000008BD9234100000040D1215A41666666667CD92341CDCCCC4CD2215A41000000006FD9234166666626D3215A41666666663DD923419A999939D6215A41333333332FD92341333333F3D6215A413333333317D9234133333333D8215A41CDCCCCCC80D82341CDCCCC0CE0215A416666666671D82341CDCCCC2CE1215A410000000045D8234100000080E5215A419A9999993CD8234100000060E8215A41CDCCCCCC39D8234166666606EA215A416666666639D8234100000020EB215A410000000039D8234166666606ED215A419A9999993AD82341666666E6EE215A419A9999993DD8234166666606F0215A416666666642D8234133333333F1215A41000000006CD823419A9999B9FA215A41CDCCCCCC87D82341333333F301225A41CDCCCCCC8FD823419A99995904225A41CDCCCCCCB5D82341666666660F225A41CDCCCCCCBDD82341333333F311225A4166666666C3D823419A99999913225A4166666666C8D823419A99997915225A4133333333CAD823413333335316225A4100000000CBD823413333335317225A419A999999C8D823413333335319225A4166666666B4D823416666666618225A4166666666ACD823419A99993918225A4100000000A3D823416666664618225A410000000090D82341333333B318225A41333333336FD82341CDCCCC0C1A225A41CDCCCCCC57D82341000000401B225A419A9999993DD823419A9999991C225A4166666666CFD72341CDCCCCAC21225A4133333333C1D723416666664622225A4100000000B4D723419A99993923225A4133333333AED723419A9999D923225A419A999999A9D723416666668624225A4100000000A6D723416666668625225A4100000000A3D723419A9999D926225A4133333333A1D72341CDCCCCCC28225A41CDCCCCCCA0D72341666666462B225A41CDCCCCCC9FD72341CDCCCC4C34225A41666666669FD72341CDCCCC8C35225A41666666669BD723419A99995938225A416666666692D72341666666463C225A41CDCCCCCC8CD72341666666E63D225A410000000081D723410000004042225A41	01060000206A08000001000000010300000001000000290000000000000081D723410000004042225A419A99999993D723410000000045225A413333333393D72341CDCCCC6C54225A419A999999A7D723419A9999995E225A4166666666E7D72341CDCCCC4C5B225A41CDCCCCCC43D823416666666654225A413333333358D823419A9999794D225A419A99999987D923416666668659225A41666666669AD92341000000605D225A4166666666B9D92341000000405D225A41CDCCCCCC75D92341333333D375225A419A99999949D92341CDCCCC4C88225A410000000064D923419A9999F98C225A4100000000D9DA23410000002075225A41000000002DDB2341666666A66D225A410000000050DB23410000008070225A413333333352DB2341333333536B225A413333333375DB23416666662667225A410000000035DB2341666666A65F225A410000000079DA23413333339330225A41000000006EDA23419A99995931225A4166666666F0D923416666664612225A419A999999E1D923410000008007225A41CDCCCCCCAED9234166666646FA215A41333333334BDA2341333333B3ED215A410000000009DA2341666666E6DD215A419A999999ECD9234100000080DB215A419A999999B5D9234100000020CE215A41666666663DD923419A999939D6215A41CDCCCCCC80D82341CDCCCC0CE0215A410000000045D8234100000080E5215A419A9999993AD82341666666E6EE215A41CDCCCCCC87D82341333333F301225A4133333333CAD823413333335316225A419A999999C8D823413333335319225A410000000090D82341333333B318225A4166666666CFD72341CDCCCCAC21225A419A999999A9D723416666668624225A41666666669FD72341CDCCCC8C35225A410000000081D723410000004042225A410000000081D723410000004042225A41	01010000206A0800009ACAB82F00D92341CCCCCCEC2D225A41	940340102	H	Sablonnière	9403401	94034	94	11	0
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	01060000206A080000010000000103000000010000002400000033333333CDD42341333333D396225A41666666660DD52341CDCCCC6C9F225A410000000047D52341000000C0AC225A4166666666AFD523419A9999F9C8225A41666666669CD52341000000C0CB225A4166666666E4D5234166666666CB225A41666666669DD623419A9999B9C1225A4166666666FAD7234166666666AB225A41CDCCCCCCC0D823419A9999199E225A4166666666A4D823416666664699225A410000000064D923419A9999F98C225A419A99999949D92341CDCCCC4C88225A41CDCCCCCC75D92341333333D375225A4166666666B9D92341000000405D225A41666666669AD92341000000605D225A419A99999987D923416666668659225A413333333358D823419A9999794D225A41CDCCCCCC43D823416666666654225A4166666666E7D72341CDCCCC4C5B225A419A999999A7D723419A9999995E225A413333333393D72341CDCCCC6C54225A419A99999993D723410000000045225A410000000081D723410000004042225A41666666669FD72341CDCCCC8C35225A4133333333A1D72341CDCCCCCC28225A4100000000B4D723419A99993923225A4133333333A1D72341CDCCCCEC21225A41CDCCCCCCA2D62341000000A027225A4100000000FDD523419A9999992E225A416666666682D523416666662633225A4166666666F9D52341666666064E225A4133333333B2D52341333333B351225A413333333348D623416666664685225A41CDCCCCCC37D523413333339391225A4133333333CDD42341333333D396225A4133333333CDD42341333333D396225A41	01010000206A08000031836962CAD72341333333E37A225A41	940340103	H	Centre Ville	9403401	94034	94	11	0
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	01060000206A080000010000000103000000010000002D0000009A9999990BD32341000000C01E225A419A999999C4D42341333333B32D225A41CDCCCCCC58D523410000000033225A416666666682D523416666662633225A4100000000FDD523419A9999992E225A41CDCCCCCCA2D62341000000A027225A4133333333A1D72341CDCCCCEC21225A4100000000B4D723419A99993923225A410000000090D82341333333B318225A419A999999C8D823413333335319225A4133333333CAD823413333335316225A41CDCCCCCC87D82341333333F301225A419A9999993AD82341666666E6EE215A419A9999993CD8234100000060E8215A41000000005AD82341000000A0DE215A413333333396D82341000000A0D0215A419A999999C1D8234100000080BD215A4166666666EFD82341CDCCCCACB4215A413333333361D82341000000009A215A410000000070D82341333333B396215A41666666662DD823419A9999F989215A413333333304D823419A99993985215A4133333333AED72341333333F371215A416666666690D62341CDCCCC0C84215A419A9999992BD62341CDCCCC4C8B215A4133333333C2D52341666666869C215A416666666658D52341000000E09F215A41000000000BD5234133333313A7215A4100000000D2D423419A9999F9AA215A410000000078D4234100000000AC215A410000000075D4234100000000A8215A410000000056D423419A999979AC215A4133333333DDD4234133333313C5215A41CDCCCCCCD0D42341CDCCCC0CC9215A416666666694D423419A999959D2215A41CDCCCCCC92D4234133333313D7215A4133333333AFD423419A999959DA215A419A99999953D523419A9999B9F2215A4166666666FAD42341CDCCCCECF9215A419A99999971D42341CDCCCC4C06225A413333333323D42341CDCCCC4CFE215A4133333333F9D32341CDCCCCAC04225A413333333319D32341000000801C225A419A9999990BD32341000000C01E225A419A9999990BD32341000000C01E225A41	01010000206A080000221FE2B48FD62341343333E3D2215A41	940340104	H	Daix-Thibaudes	9403401	94034	94	11	0
01060000206A080000010000000103000000010000006A000000CDCCCCCCB4CF23419A9999D93E225A419A999999D3CF2341CDCCCC8C44225A41666666660CD02341000000204F225A410000000046D023419A9999B959225A41CDCCCCCC91D023419A99997955225A41CDCCCCCC6CD123413333335349225A41CDCCCCCC03D223416666660641225A41CDCCCCCC67D22341666666863B225A419A99999973D22341000000403D225A419A999999C7D22341000000E04A225A410000000000D323416666662654225A41666666660DD323413333333356225A41666666661CD323419A99997958225A41333333332BD32341333333B35A225A413333333340D32341666666465D225A41333333335FD32341000000C060225A41CDCCCCCC75D323413333337363225A4166666666C4D32341333333536C225A419A999999E4D32341000000E06F225A4166666666F8D323419A99993972225A410000000008D423413333335374225A413333333314D423416666666676225A410000000024D42341000000207A225A41CDCCCCCC3ED423419A9999D97F225A419A99999951D42341CDCCCC4C84225A41000000006BD423413333333389225A413333333378D42341333333938B225A410000000093D42341333333538F225A4133333333CDD42341333333D396225A41000000000ED523416666668693225A41CDCCCCCC37D523413333339391225A4166666666BED52341333333938B225A4133333333FED52341CDCCCC8C88225A413333333348D623416666664685225A41CDCCCCCC18D62341333333D374225A4133333333B2D52341333333B351225A4166666666D1D523413333331350225A4166666666F9D52341666666064E225A4100000000D2D523419A99991945225A416666666682D523416666662633225A41CDCCCCCC75D523413333335333225A41CDCCCCCC6AD523416666664633225A41CDCCCCCC58D523410000000033225A41CDCCCCCC33D52341333333B331225A41666666660CD523413333335330225A4100000000DAD42341000000802E225A419A999999C4D42341333333B32D225A419A99999996D42341CDCCCC2C2C225A410000000044D423410000006029225A41CDCCCCCC1AD423419A99991928225A4166666666D1D32341CDCCCC8C25225A41CDCCCCCC40D323416666664620225A419A9999990BD32341000000C01E225A413333333319D32341000000801C225A41666666666DD323410000006013225A4133333333F9D32341CDCCCCAC04225A419A999999FED32341333333F303225A4133333333FAD32341CDCCCC2C03225A41CDCCCCCC1ED423419A9999B9FE215A413333333323D42341CDCCCC4CFE215A419A99999971D42341CDCCCC4C06225A4100000000F3D42341CDCCCC8CFA215A4166666666FAD42341CDCCCCECF9215A4100000000FFD4234100000080FA215A413333333303D523419A999919FA215A419A99999953D523419A9999B9F2215A41333333332CD5234166666606ED215A419A9999991ED52341CDCCCC0CEB215A416666666602D523419A9999D9E6215A41CDCCCCCCF9D4234100000080E5215A4133333333AFD423419A999959DA215A41CDCCCCCC92D4234133333313D7215A419A99999994D42341333333B3D6215A419A99999995D42341CDCCCC2CD6215A410000000094D423419A999979D5215A419A99999990D4234166666606D5215A41666666668DD42341CDCCCCCCD4215A419A99999990D42341CDCCCC6CD3215A416666666694D423419A999959D2215A4166666666A2D42341333333B3CF215A4100000000B4D423419A9999B9CC215A41CDCCCCCCD0D42341CDCCCC0CC9215A4133333333DDD4234133333313C5215A419A999999BAD42341CDCCCC6CBE215A41CDCCCCCC80D423419A9999F9B3215A410000000056D423419A999979AC215A410000000052D423419A999959AB215A413333333351D4234133333313AB215A4133333333C0D3234166666686B7215A4166666666CED223419A9999F9CC215A4100000000C6D123419A999979CD215A413333333361D1234133333353D4215A41CDCCCCCC1DD1234100000080D9215A4133333333B5D0234100000040E1215A413333333380D02341CDCCCC2CE5215A419A99999927D123419A999999F6215A41333333335FD123419A9999F9FB215A41CDCCCCCC1AD123416666664609225A410000000010D123419A9999390B225A410000000007D12341000000000D225A4100000000F5D02341000000A010225A41666666661AD123413333339317225A41CDCCCCCC36D12341CDCCCC0C1D225A41000000004AD123410000006020225A4100000000D4D023410000004029225A41CDCCCCCCB4CF23419A9999D93E225A41	01060000206A0800000100000001030000000100000025000000CDCCCCCCB4CF23419A9999D93E225A410000000046D023419A9999B959225A41CDCCCCCC67D22341666666863B225A41333333332BD32341333333B35A225A419A999999E4D32341000000E06F225A413333333314D423416666666676225A413333333378D42341333333938B225A4133333333CDD42341333333D396225A41CDCCCCCC37D523413333339391225A413333333348D623416666664685225A4133333333B2D52341333333B351225A4166666666F9D52341666666064E225A416666666682D523416666662633225A41CDCCCCCC58D523410000000033225A419A999999C4D42341333333B32D225A419A9999990BD32341000000C01E225A413333333319D32341000000801C225A4133333333F9D32341CDCCCCAC04225A413333333323D42341CDCCCC4CFE215A419A99999971D42341CDCCCC4C06225A4166666666FAD42341CDCCCCECF9215A419A99999953D523419A9999B9F2215A4133333333AFD423419A999959DA215A41CDCCCCCC92D4234133333313D7215A416666666694D423419A999959D2215A41CDCCCCCCD0D42341CDCCCC0CC9215A4133333333DDD4234133333313C5215A413333333351D4234133333313AB215A4166666666CED223419A9999F9CC215A4100000000C6D123419A999979CD215A413333333361D1234133333353D4215A413333333380D02341CDCCCC2CE5215A41333333335FD123419A9999F9FB215A4100000000F5D02341000000A010225A41000000004AD123410000006020225A41CDCCCCCCB4CF23419A9999D93E225A41CDCCCCCCB4CF23419A9999D93E225A41	01010000206A08000002A5AD0859D22341666666F622225A41	940340105	H	Fleurs-Pasteur	9403401	94034	94	11	0
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	01060000206A08000001000000010300000001000000170000000000000046D023419A9999B959225A41666666660AD223419A9999D9AA225A4100000000F9D123419A999959AC225A41CDCCCCCC6FD2234166666626C2225A410000000049D22341CDCCCCCCE9225A410000000096D2234133333333FD225A410000000004D32341000000A0F6225A419A99999905D32341000000A0F7225A413333333394D323419A9999B9EF225A41CDCCCCCC87D4234100000000E3225A419A99999938D5234133333333D8225A41CDCCCCCC4CD5234133333373D3225A41CDCCCCCC64D52341333333B3D6225A4166666666AFD523419A9999F9C8225A410000000047D52341000000C0AC225A41666666660DD52341CDCCCC6C9F225A413333333378D42341333333938B225A413333333314D423416666666676225A419A999999E4D32341000000E06F225A41333333332BD32341333333B35A225A41CDCCCCCC67D22341666666863B225A410000000046D023419A9999B959225A410000000046D023419A9999B959225A41	01010000206A080000C99189D15BD32341343333E39C225A41	940340106	H	Peupleraie	9403401	94034	94	11	0
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	01060000206A080000010000000103000000010000001C00000066666666A4D823416666664699225A41CDCCCCCCF6D82341CDCCCCECA4225A413333333337D9234166666646B0225A41333333339AD9234100000000C4225A419A999999C5D92341CDCCCC2CD0225A41CDCCCCCC4DDA23413333335301235A410000000066DA23419A99999900235A419A99999920DB23410000006011235A41CDCCCCCC59DB2341CDCCCCAC1D235A41333333339ADC23410000000011235A4133333333C2DC23419A99999919235A41CDCCCCCC52DD23413333333334235A419A9999998FDD23419A9999393C235A4100000000F8DD23416666668634235A41666666661ADE2341000000A03C235A41000000009FDE23419A99991934235A4166666666CEDD234100000040F2225A41333333334CDD2341CDCCCC0CCA225A416666666615DD23419A999959BE225A4133333333DEDC23419A999979B4225A4133333333CDDC2341CDCCCCCCB4225A4100000000A0DB2341CDCCCC6C80225A410000000066DB2341CDCCCCAC7A225A410000000050DB23410000008070225A41000000002DDB2341666666A66D225A4100000000D9DA23410000002075225A4166666666A4D823416666664699225A4166666666A4D823416666664699225A41	01010000206A0800000061EACF9DDB23419A9999D9D3225A41	940340107	H	Fosse aux Loups	9403401	94034	94	11	0
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	01060000206A08000001000000010300000001000000220000006666666633D823413333337367235A419A9999993CD823419A99991975235A41CDCCCCCCFAD82341000000C070235A413333333337DA23419A9999F95F235A4166666666BFDA2341666666465D235A4166666666BDDA2341000000E05A235A4133333333A1DB2341666666664F235A4100000000F2DB2341CDCCCC6C4D235A41CDCC