SET client_encoding = 'UTF8';
CREATE SCHEMA IF NOT EXISTS bdnb_ref_admin_2025_07_a_open_data_dep95;
COMMENT ON schema bdnb_ref_admin_2025_07_a_open_data_dep95 is 'Base de données Nationale du Bâtiment, millesime 2025-07-a (format v0.7.10';
CREATE EXTENSION IF NOT EXISTS postgis;
SET standard_conforming_strings = ON;
BEGIN;
CREATE TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"();
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "ogc_fid" SERIAL CONSTRAINT "iris_pk" PRIMARY KEY;
COMMENT ON TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" IS 'Données sur les IRIS Grande Echelle fournies par l''IGN pour le compte de l''INSEE';
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep95','iris','geom_iris',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep95','iris','geom_iris_simplifiee_10m',2154,'MULTIPOLYGON',2);
SELECT AddGeometryColumn('bdnb_ref_admin_2025_07_a_open_data_dep95','iris','geom_iris_pos',2154,'POINT',2);
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "code_iris" VARCHAR(9);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."code_iris" IS 'Code IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "type_iris" VARCHAR(1);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."type_iris" IS 'Catégorie de l''IRIS (H : Habitation, D : Divers, A : Agricole, Z : commune non irisée)';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "libelle_iris" VARCHAR;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."libelle_iris" IS 'Nom de l''IRIS';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "code_grand_iris" VARCHAR(7);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."code_grand_iris" IS 'code du grand IRIS associé';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "code_commune_insee" VARCHAR(5);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."code_commune_insee" IS 'Code INSEE de la commune';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "code_departement_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."code_departement_insee" IS 'Code département INSEE';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "code_region_insee" VARCHAR(2);
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."code_region_insee" IS 'Identifiant de la Région associée';
ALTER TABLE "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ADD COLUMN "s_geom_iris" INTEGER;
COMMENT ON COLUMN "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris"."s_geom_iris" IS 'Superficie de l''iris [km²]';
COPY "bdnb_ref_admin_2025_07_a_open_data_dep95"."iris" ("geom_iris", "geom_iris_simplifiee_10m", "geom_iris_pos", "code_iris", "type_iris", "libelle_iris", "code_grand_iris", "code_commune_insee", "code_departement_insee", "code_region_insee", "s_geom_iris") FROM STDIN;
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	01010000206A080000B602FA9A0C132341333333E389465A41	950020000	Z	Ableiges	9500200	95002	95	11	8
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	01010000206A08000067ABAAB1609F2241000000A039455A41	950080000	Z	Aincourt	9500800	95008	95	11	10
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	01010000206A080000E6E311FFCD7122419A9999F9BC4D5A41	950110000	Z	Ambleville	9501100	95011	95	11	8
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	01010000206A0800002C56A7223D622241CCCCCC7C32495A41	950120000	Z	Amenucourt	9501200	95012	95	11	9
01060000206A0800000100000001030000000100000062010000CDCCCCCCEFC6234166666606783C5A41CDCCCCCC02C72341CDCCCCCC7C3C5A41000000002DC7234100000040863C5A419A99999937C72341CDCCCCAC883C5A419A999999A9C72341333333339F3C5A4133333333E3C7234100000060AA3C5A41CDCCCCCC14C823419A999939B23C5A413333333337C8234133333373B53C5A41CDCCCCCC53C8234166666666B63C5A410000000082C8234166666686B83C5A4133333333C1C8234100000000BC3C5A41CDCCCCCCD5C8234100000040BD3C5A4133333333F5C82341CDCCCC8CBF3C5A4133333333FCC8234133333313C03C5A419A99999911C92341666666E6C13C5A416666666637C92341666666E6C53C5A413333333345C923419A999999C73C5A41666666665DC92341CDCCCC8CCB3C5A416666666679C9234100000080D13C5A4166666666ACC923419A999959DD3C5A41CDCCCCCCB8C92341CDCCCCACE03C5A4133333333DDC923419A999999EC3C5A419A999999F5C9234133333333F43C5A41000000001FCA2341666666A6013D5A419A99999943CA2341CDCCCC2C0D3D5A416666666649CA2341CDCCCC0C0F3D5A41666666664FCA2341333333B3133D5A410000000051CA234166666606143D5A410000000068CA23419A9999D9183D5A410000000071CA2341000000201A3D5A41CDCCCCCCA9CA23419A999919223D5A4166666666C5CA2341CDCCCCCC253D5A41CDCCCCCCF9CA2341CDCCCCEC2C3D5A41CDCCCCCC09CB234100000020303D5A419A99999969CA2341000000E0333D5A4166666666AFC9234133333353383D5A419A999999A7C92341CDCCCCCC473D5A4166666666A6C92341CDCCCC4C4A3D5A4133333333A5C92341000000804C3D5A41CDCCCCCC8DC92341000000204D3D5A419A9999997EC92341000000A04D3D5A419A99999995C92341333333535B3D5A4133333333A0C9234133333373613D5A4166666666C0C9234166666666743D5A41CDCCCCCCB2C9234100000060743D5A419A99999987C9234133333353743D5A41CDCCCCCC5CC9234100000000753D5A41000000004EC9234133333353753D5A41CDCCCCCC07C92341666666C6773D5A4166666666D9C8234133333393793D5A4100000000BFC82341333333537A3D5A416666666675C823419A9999197C3D5A419A9999994DC82341666666067D3D5A416666666632C82341666666C67D3D5A4133333333F6C723419A9999F97F3D5A41CDCCCCCCC9C7234166666626823D5A4166666666CFC72341000000C0833D5A419A999999D3C72341666666E6843D5A4166666666E6C72341CDCCCC2C8A3D5A410000000016C82341CDCCCC8C883D5A419A99999935C8234100000080923D5A419A999999E7C7234100000020963D5A410000000030C8234133333333A93D5A419A9999998DC823419A9999D9A33D5A41CDCCCCCC92C8234166666646A43D5A4100000000A5C8234133333373A73D5A4166666666CDC8234133333313B23D5A41CDCCCCCCECC823419A9999B9B93D5A413333333304C9234133333373BF3D5A419A99999917C923419A999999C43D5A410000000046C923419A9999D9D13D5A410000000056C92341000000C0D03D5A413333333396C923419A999979CC3D5A4133333333A1C9234133333313D13D5A419A999999A8C9234133333393D33D5A4166666666AFC92341666666A6D53D5A4100000000C4C9234166666686DA3D5A419A999999E2C92341666666E6E13D5A41CDCCCCCCE7C9234166666686E33D5A4100000000F2C92341CDCCCC8CE63D5A41CDCCCCCCFAC92341000000E0E93D5A410000000001CA234166666606EF3D5A41CDCCCCCC38CA234133333373F93D5A41CDCCCCCC42CA2341666666C6F93D5A419A99999962CA2341CDCCCCCCFA3D5A4166666666C7CA23419A999919FE3D5A4133333333E0CA2341CDCCCCECFE3D5A41CDCCCCCCF9CA2341000000C0FF3D5A41333333330BCB234133333353003E5A416666666621CB23419A999939043E5A410000000028CB2341CDCCCC6C053E5A41CDCCCCCC3DCB23419A999939093E5A41000000009CCB2341666666C6193E5A4133333333A3CB2341000000E01C3E5A4133333333B1CB2341CDCCCC8C203E5A4100000000FBCB234100000020383E5A41333333330DCC23419A9999D93D3E5A41000000000ECC23419A9999193E3E5A41000000001DCC2341666666E6423E5A41666666665BCC23419A9999B9563E5A41666666667BCC2341666666E6603E5A41CDCCCCCC7DCC23419A9999B9613E5A4100000000A0CC2341333333936C3E5A4166666666B8CC23419A9999796F3E5A410000000014CD2341CDCCCCCC773E5A410000000035CD2341333333937B3E5A416666666659CD2341000000A07E3E5A410000000094CD234100000000883E5A41CDCCCCCC9ECD2341CDCCCC8C8B3E5A419A9999993DCD23419A9999399F3E5A41CDCCCCCCDACC2341CDCCCC4CAA3E5A4133333333E0CC234100000000AC3E5A4166666666E6CC2341CDCCCCCCAD3E5A4100000000F6CC2341CDCCCC6CB23E5A41CDCCCCCCE9CC23419A9999F9B53E5A419A999999E1CC2341000000E0B93E5A4100000000CECC234166666666C43E5A4100000000C9CC234166666626C83E5A4133333333C5CC23419A999999CC3E5A4100000000C6CC234100000060D03E5A4166666666C9CC234100000080D33E5A419A999999CCCC2341000000E0D43E5A4133333333CFCC234166666606D63E5A41CDCCCCCCDECC23419A999919DB3E5A41CDCCCCCCE8CC2341CDCCCC6CDD3E5A4166666666EECC2341CDCCCC4CDE3E5A4166666666F9CC234100000040DF3E5A410000000049CD2341CDCCCC6CE43E5A410000000065CD234133333313E73E5A419A9999996BCD2341000000C0E73E5A410000000083CD23419A9999F9EA3E5A410000000094CD2341CDCCCC4CED3E5A4166666666B4CD2341CDCCCC4CF23E5A4100000000BFCD234166666666F43E5A4166666666CCCD23419A9999F9F73E5A4133333333D4CD234166666666FB3E5A4133333333D9CD23419A999999FE3E5A41CDCCCCCCE4CD2341000000A0023F5A4166666666F1CD234133333353053F5A413333333309CE2341666666A6083F5A419A9999994DCE23419A999999103F5A416666666668CE234166666666133F5A416666666676CE2341666666A6143F5A419A99999988CE2341CDCCCC8C193F5A41CDCCCCCC89CE23419A9999591C3F5A416666666686CE2341CDCCCC8C1E3F5A419A99999941CE23419A999999253F5A41000000003ACE23419A9999B92D3F5A41CDCCCCCC19CE2341333333533A3F5A410000000015CE2341000000C0403F5A416666666606CE2341000000A04B3F5A419A999999E1CD2341333333B34D3F5A41CDCCCCCCBFCD2341333333734F3F5A4100000000BCCD2341000000A04F3F5A4133333333B7CD2341000000E04F3F5A419A999999B5CD234133333373513F5A4133333333B4CD23419A999919533F5A419A999999B1CD23419A9999F9553F5A4133333333ACCD2341CDCCCC0C5C3F5A4166666666A7CD234166666626613F5A4100000000A7CD23419A9999D9613F5A4133333333A1CD234100000020683F5A41CDCCCCCC9CCD2341333333F36C3F5A410000000044CE23419A9999796A3F5A41CDCCCCCC4BCE23419A9999596C3F5A41CDCCCCCC6DCE23419A9999196C3F5A416666666688CE2341666666E66B3F5A4100000000A6CE2341CDCCCCAC6B3F5A419A999999FCCE2341000000006B3F5A419A9999995ECF2341000000006A3F5A41CDCCCCCC90CF2341333333D3683F5A413333333396CF2341666666A6683F5A4100000000AFCF234166666606683F5A4100000000BACF234133333393673F5A4166666666C4CF2341CDCCCC2C673F5A419A99999910D02341000000E0633F5A410000000010D0234100000020623F5A41000000000ED0234100000000613F5A416666666611D02341333333F35E3F5A41666666661CD02341CDCCCC4C5B3F5A41CDCCCCCC28D02341666666E6583F5A4100000000FDCF234166666666563F5A4166666666A7CF234166666686513F5A4133333333ACCF2341CDCCCC8C4F3F5A41333333332DCF23419A999999473F5A41000000001ECF2341333333D3103F5A413333333330CF23419A9999190F3F5A41CDCCCCCC51CF23419A9999790B3F5A41CDCCCCCCF1CF234133333313FD3E5A4100000000BCD02341666666E6E93E5A41CDCCCCCCE6D0234166666626E63E5A413333333316D12341000000C0E13E5A41CDCCCCCC60D1234133333333DB3E5A41666666666CD1234166666646DA3E5A41000000009FD12341CDCCCC6CD53E5A4100000000D9D1234100000020CF3E5A41CDCCCCCC0ED22341000000A0C93E5A41CDCCCCCC32D2234166666686C63E5A419A99999990D2234100000000BF3E5A413333333330D32341CDCCCC4CB03E5A413333333356D3234100000080AC3E5A41CDCCCCCCCCD32341000000C0A13E5A4100000000E5D32341666666269F3E5A41666666660CD423419A9999399C3E5A416666666611D42341CDCCCC0C9C3E5A419A99999934D42341666666C69A3E5A41CDCCCCCC1DD42341CDCCCC6C943E5A41CDCCCCCC0ED42341CDCCCC2C8F3E5A41CDCCCCCC05D42341333333338A3E5A4133333333FFD3234100000020853E5A4100000000FDD32341666666A6803E5A4100000000FDD3234100000060733E5A4133333333FED323419A9999596D3E5A419A999999FDD3234166666646693E5A4133333333FAD32341CDCCCC6C633E5A4100000000F7D3234100000060603E5A4133333333F2D32341CDCCCCCC5D3E5A4133333333E3D3234100000000593E5A4100000000C0D32341000000E04F3E5A410000000098D32341666666A6453E5A41000000008DD32341CDCCCC4C433E5A410000000071D32341000000203C3E5A416666666669D323419A9999B9393E5A419A9999995AD32341333333D3343E5A416666666651D3234100000000303E5A419A99999938D32341CDCCCC0C203E5A419A99999930D32341CDCCCC6C193E5A410000000031D32341000000E0163E5A410000000034D323419A999939143E5A419A99999938D32341000000A0123E5A41000000003CD3234133333373113E5A41CDCCCCCC46D32341000000C00E3E5A413333333354D32341666666660C3E5A410000000062D32341000000800A3E5A41CDCCCCCC77D32341333333F3063E5A419A99999981D32341333333F3043E5A419A9999998AD3234166666626023E5A413333333391D323419A999959FF3D5A413333333397D323419A999999FB3D5A41CDCCCCCC9CD32341000000C0F73D5A4100000000A3D3234100000060F13D5A4166666666A8D323419A999959EC3D5A4100000000AAD32341333333F3E73D5A4100000000ABD32341333333D3DF3D5A41CDCCCCCCB0D32341CDCCCCECDC3D5A4166666666B9D3234100000060DA3D5A4133333333C2D32341CDCCCC4CD83D5A4133333333DFD3234133333373D33D5A416666666619D4234133333333CB3D5A41CDCCCCCC34D42341333333D3C63D5A41CDCCCCCC3ED42341666666E6C43D5A416666666656D4234100000060BF3D5A413333333374D423419A999959B73D5A41666666668ED4234166666606AF3D5A41666666669DD42341000000E0AA3D5A41CDCCCCCC77D4234166666646A73D5A4100000000D9D32341CDCCCC6C973D5A41333333337DD32341CDCCCC4C8E3D5A410000000055D32341CDCCCC4C8A3D5A41CDCCCCCCF8D2234100000080813D5A41CDCCCCCCDCD22341000000807E3D5A41CDCCCCCCF2D22341333333537B3D5A419A99999919D32341000000C0753D5A41CDCCCCCC34D3234166666646723D5A416666666661D323419A9999D96C3D5A419A99999982D3234166666626693D5A419A999999BED32341333333D3613D5A4100000000DDD32341CDCCCC0C5F3D5A4133333333FBD32341000000A05B3D5A41CDCCCCCC12D42341CDCCCC8C593D5A413333333306D4234166666626573D5A41CDCCCCCCE0D32341000000A04E3D5A4166666666A8D323419A9999594C3D5A41666666667CD323419A9999594A3D5A419A9999994FD3234133333333473D5A41333333333AD32341666666E6443D5A416666666637D323419A999999443D5A416666666622D323419A9999D9413D5A41666666660BD323419A9999B93E3D5A419A999999F9D223419A9999793B3D5A4100000000F1D22341666666E6383D5A41CDCCCCCCE9D22341000000C0363D5A419A999999C7D22341666666C6073D5A419A999999BED22341CDCCCCAC073D5A41CDCCCCCC9DD2234133333393063D5A41CDCCCCCC67D2234133333353043D5A4100000000C7D12341000000C0FE3C5A4100000000AED1234100000040FE3C5A410000000097D1234166666646FE3C5A413333333385D12341000000A0FE3C5A419A99999974D123419A999979FF3C5A410000000070D123419A9999D9FF3C5A410000000022D1234133333393073D5A41CDCCCCCC16D123419A999999083D5A4133333333FFD02341CDCCCC8C0A3D5A4166666666F2D02341333333530B3D5A4100000000EDD02341CDCCCCAC0B3D5A41CDCCCCCCD5D02341CDCCCC4C0C3D5A419A99999975D023419A9999990D3D5A419A9999995AD02341333333530E3D5A410000000005D02341333333F3133D5A41CDCCCCCCEACF2341CDCCCC4C0D3D5A41CDCCCCCC79CF2341000000C0F03C5A41CDCCCCCC77CF2341000000A0E73C5A410000000073CF234100000040E23C5A410000000072CF2341CDCCCC6CE03C5A419A99999972CF2341666666C6DD3C5A413333333377CF2341000000C0D93C5A410000000084CF2341000000A0CE3C5A419A99999981CF234166666606CB3C5A413333333370CF2341000000C0BE3C5A41000000004DCF2341CDCCCC2CB43C5A419A99999938CF2341CDCCCC0CAE3C5A4166666666FECE23419A9999B99D3C5A419A999999EDCE234133333313993C5A4166666666AACE234133333353863C5A41333333330DCE23419A9999997F3C5A41666666666ECD2341000000C0783C5A410000000021CD2341CDCCCC6C753C5A419A999999FBCC2341333333D3733C5A4133333333D4CC234100000020723C5A4100000000B8CC2341CDCCCCEC703C5A4133333333B3CC2341333333B3703C5A41666666666BCC2341666666A66D3C5A419A9999992BCC2341666666E66A3C5A41333333330ECC2341666666A6693C5A4166666666C6CB2341CDCCCC8C663C5A416666666606CB2341333333535E3C5A4166666666B7CA2341CDCCCCEC5A3C5A419A99999964CA234100000060573C5A410000000024CA23419A999919553C5A416666666612CA2341333333F3543C5A4133333333E1C9234166666626553C5A4100000000A6C9234133333353553C5A416666666691C92341CDCCCCCC553C5A419A99999983C92341333333F3553C5A413333333366C92341000000C0563C5A410000000063C92341333333D3563C5A41333333333FC9234166666626583C5A41CDCCCCCC22C92341000000E0583C5A41CDCCCCCC1AC92341CDCCCC0C593C5A416666666605C92341CDCCCC8C593C5A419A999999E5C823419A9999395A3C5A4133333333D3C82341333333F35A3C5A4133333333A5C82341000000C05C3C5A419A99999979C82341666666265E3C5A419A99999932C8234100000060623C5A41CDCCCCCCFFC7234100000060653C5A419A999999F0C72341CDCCCC6C663C5A41666666669BC723419A9999596C3C5A413333333343C7234133333313723C5A413333333333C7234100000020733C5A41666666662BC72341000000A0733C5A41CDCCCCCCEFC6234166666606783C5A41	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	01010000206A08000058AB7295C4CE2341CCCCCCDCE03D5A41	950140000	Z	Andilly	9501400	95014	95	11	3
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	01060000206A08000001000000010300000001000000260000003333333346A72341CDCCCC0CBC375A41CDCCCCCC53A7234100000020BE375A410000000049A8234133333393C9375A41000000005FA9234100000080D5375A41CDCCCCCC48AA23419A999959E0375A4100000000A6AA2341CDCCCCECE5375A410000000040AB2341CDCCCCACF2375A4100000000B6AB23419A9999B9CB375A4133333333E8AB2341CDCCCC0CBA375A41333333330AAC23419A9999F997375A41CDCCCCCC62AC2341CDCCCCCC6F375A419A9999999FAC23410000008057375A41CDCCCCCCE7AC23419A99991947375A4133333333AFAD2341000000C01C375A41CDCCCCCC5EAE234133333353FE365A41333333332BAE234166666646F9365A416666666647AD2341CDCCCC8CDB365A4166666666B7AC234100000000CA365A4100000000BCAB2341333333D3A6365A416666666687AB2341CDCCCCACA0365A4133333333D1AA2341666666C6B8365A4100000000FAA923419A999979D8365A41000000003EA92341000000E0F4365A4100000000E8AA2341CDCCCCAC11375A41CDCCCCCC95AA2341CDCCCC2C21375A410000000048AA23419A99993936375A4133333333ACA92341000000803A375A4133333333ADA82341333333333F375A4166666666A3A82341CDCCCC4C47375A419A99999986A823419A9999D951375A419A99999963A823416666664662375A419A9999993FA823419A9999196F375A416666666608A82341000000607E375A41333333335AA72341666666C6A6375A410000000082A72341333333D3A8375A41CDCCCCCC7BA7234166666686AD375A413333333346A72341CDCCCC0CBC375A413333333346A72341CDCCCC0CBC375A41	01010000206A08000035E53E61B9AA23419A9999894A375A41	950180102	H	Calais	9501801	95018	95	11	1
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	01060000206A08000001000000010300000001000000160000006666666687AB2341CDCCCCACA0365A4100000000BCAB2341333333D3A6365A4166666666B7AC234100000000CA365A416666666647AD2341CDCCCC8CDB365A41333333332BAE234166666646F9365A419A999999D5AE2341000000C009375A416666666618B02341666666A6CA365A4166666666EAAE2341666666E6B0365A413333333328AE2341CDCCCCCC99365A419A999999F9AD2341666666668E365A419A999999C4AD2341CDCCCCEC84365A419A999999A4AD2341666666867C365A419A99999946AD2341333333D36A365A41CDCCCCCC08AD23410000008062365A4133333333C3AC23419A99997957365A41000000009FAC2341CDCCCCEC6C365A41CDCCCCCC80AC2341666666E676365A416666666666AC23419A9999D97A365A419A99999920AC2341CDCCCC2C8A365A419A999999CFAB23419A9999F996365A416666666687AB2341CDCCCCACA0365A416666666687AB2341CDCCCCACA0365A41	01010000206A08000008E3415B6BAD234133333383AF365A41	950180201	H	Basilique	9501802	95018	95	11	0
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	01060000206A080000010000000103000000010000002E0000000000000040AB2341CDCCCCACF2375A4133333333F4AB2341333333B3FE375A41333333337DAC23419A99999908385A4166666666C0AC2341CDCCCC8C0C385A41333333335CAD2341333333F312385A41CDCCCCCCC3AD23416666664615385A419A99999954AE2341666666A616385A419A999999C1AE2341666666A616385A410000000022AF23413333337315385A4166666666A5AF2341333333B311385A416666666632B02341333333930B385A4133333333AFB023410000004003385A419A9999990DB1234133333393FA375A419A9999997EB1234166666646ED375A41CDCCCCCCD5B12341000000E0DF375A41666666663DB22341000000C0DA375A41CDCCCCCC1EB2234166666686CE375A41333333332EB223419A999939CB375A41666666666BB22341333333F3B6375A41000000006EB223419A9999F9B2375A4100000000E6B12341333333B3B2375A4166666666D0B1234100000000A3375A419A9999990CB223419A9999F99C375A416666666659B22341CDCCCC8C90375A419A99999972B223413333335376375A41666666666BB223413333333355375A419A999999ABB22341CDCCCC4C56375A4166666666CEB223413333339354375A4100000000F8B22341333333B347375A41CDCCCCCCCAB22341000000803D375A4100000000D1B22341000000E035375A419A999999EFB22341333333D32B375A416666666673B22341333333B335375A41333333339AB123416666660649375A41333333338DB12341000000C04B375A41666666668AAF2341000000401B375A41CDCCCCCC5EAE234133333353FE365A4133333333AFAD2341000000C01C375A41CDCCCCCCE7AC23419A99991947375A419A9999999FAC23410000008057375A41CDCCCCCC62AC2341CDCCCCCC6F375A41333333330AAC23419A9999F997375A4133333333E8AB2341CDCCCC0CBA375A4100000000B6AB23419A9999B9CB375A410000000040AB2341CDCCCCACF2375A410000000040AB2341CDCCCCACF2375A41	01010000206A0800007E78FB9244AF2341343333238A375A41	950180101	H	Grandes Fontaines	9501801	95018	95	11	1
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	01060000206A08000001000000010300000001000000200000003333333369AB23419A999979C8355A41000000008EAB23419A9999F9D4355A4166666666B8AB2341CDCCCCACDA355A41333333338FAC23419A999959FE355A4100000000CBAC23419A9999B907365A410000000033AD23413333335316365A4166666666DEAC2341000000801F365A41CDCCCCCCE3AB2341CDCCCC6C3E365A4166666666AEAC2341CDCCCC8C54365A41CDCCCCCC08AD23410000008062365A419A99999946AD2341333333D36A365A419A999999A4AD2341666666867C365A419A999999C4AD2341CDCCCCEC84365A419A999999F9AD2341666666668E365A413333333328AE2341CDCCCCCC99365A4166666666EAAE2341666666E6B0365A416666666609B0234166666646C9365A4133333333D2B023419A999919A3365A4166666666DEB0234133333313A4365A413333333335B123416666660693365A413333333319B123419A99997988365A410000000052B12341666666468D365A410000000089B22341666666E654365A419A9999992AB12341666666A63A365A419A99999913B023416666660625365A4133333333EDAF2341CDCCCC0C27365A41CDCCCCCC7DAF2341000000A035365A41CDCCCCCC24AD234133333393FF355A41CDCCCCCCA5AC2341CDCCCC2CF2355A41666666660BAC23419A9999B9DE355A413333333369AB23419A999979C8355A413333333369AB23419A999979C8355A41	01010000206A08000068B8B77619AF23419A99992949365A41	950180202	H	Promenade Héloïse	9501802	95018	95	11	0
01060000206A080000010000000103000000010000002E0000009A999999D5AE2341000000C009375A419A99999904AF2341000000400E375A413333333328AF2341CDCCCCAC11375A419A9999993FAF2341000000E013375A416666666665AF23416666666617375A41666666668AAF2341000000401B375A4100000000DBAF2341CDCCCCAC22375A416666666621B023410000006029375A413333333352B02341CDCCCC0C2E375A419A9999995FB02341666666462F375A4100000000BEB023419A99993938375A41000000002DB12341666666A642375A410000000063B123419A99997947375A41333333338DB12341000000C04B375A410000000093B12341333333334A375A41333333339AB123416666660649375A419A999999A1B123410000006048375A41666666664CB223413333331339375A416666666673B22341333333B335375A41CDCCCCCCCCB22341666666862E375A419A999999EFB22341333333D32B375A416666666603B323413333339329375A416666666607B32341333333F328375A410000000011B32341666666C626375A413333333315B32341CDCCCC0C25375A416666666607B323419A9999F922375A41CDCCCCCCD7B22341666666A61E375A4100000000B0B223419A9999B919375A419A99999981B22341333333D313375A41666666666BB22341CDCCCC2C11375A419A99999961B223410000000010375A41CDCCCCCC26B22341CDCCCC4C08375A416666666600B22341CDCCCC4C03375A419A99999996B12341333333F3F6365A410000000093B1234133333333F6365A416666666675B1234100000080F1365A41000000006FB123419A999979F0365A4133333333FFB02341CDCCCC6CE4365A419A999999EBB0234166666606E2365A4166666666BFB023419A9999F9DB365A4133333333A4B023419A999999D8365A41666666667DB023419A999979D5365A416666666618B02341666666A6CA365A416666666664AF2341666666E6ED365A413333333304AF2341666666C600375A419A999999D5AE2341000000C009375A41	01060000206A08000001000000010300000001000000110000009A999999D5AE2341000000C009375A41666666668AAF2341000000401B375A41333333338DB12341000000C04B375A41333333339AB123416666660649375A416666666673B22341333333B335375A419A999999EFB22341333333D32B375A413333333315B32341CDCCCC0C25375A41CDCCCCCCD7B22341666666A61E375A416666666600B22341CDCCCC4C03375A419A99999996B12341333333F3F6365A41000000006FB123419A999979F0365A4133333333FFB02341CDCCCC6CE4365A4133333333A4B023419A999999D8365A41666666667DB023419A999979D5365A416666666618B02341666666A6CA365A419A999999D5AE2341000000C009375A419A999999D5AE2341000000C009375A41	01010000206A0800003C25C81398B02341000000000C375A41	950180203	H	Hôtel de Ville	9501802	95018	95	11	0
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	01060000206A08000001000000010300000001000000210000006666666609B0234166666646C9365A41666666667DB023419A999979D5365A4133333333A4B023419A999999D8365A4133333333FFB02341CDCCCC6CE4365A41000000006FB123419A999979F0365A419A99999996B12341333333F3F6365A416666666600B22341CDCCCC4C03375A41CDCCCCCCD7B22341666666A61E375A413333333315B32341CDCCCC0C25375A419A999999EFB22341333333D32B375A4100000000D1B22341000000E035375A41CDCCCCCCCAB22341000000803D375A419A999999E3B223419A99999944375A41CDCCCCCC14B32341333333534A375A41666666667BB32341000000202E375A41CDCCCCCC0BB42341CDCCCC4C09375A4100000000BBB423419A999919E0365A416666666626B52341CDCCCC0CC5365A41CDCCCCCCA8B42341CDCCCCCCBA365A41000000002AB523419A999939A4365A41000000007AB42341666666C693365A416666666610B42341666666E687365A41CDCCCCCC95B323413333339378365A4133333333FFB223419A99995963365A41CDCCCCCCB6B223413333331358365A410000000089B22341666666E654365A410000000052B12341666666468D365A413333333319B123419A99997988365A413333333335B123416666660693365A4166666666DEB0234133333313A4365A4133333333D2B023419A999919A3365A416666666609B0234166666646C9365A416666666609B0234166666646C9365A41	01010000206A08000066953C359DB223419A999939CE365A41	950180204	H	Carême Prenant	9501802	95018	95	11	0
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	01060000206A080000010000000103000000010000002E000000333333339F9A2341CDCCCC4C1B365A4166666666C09A2341CDCCCCAC1F365A41CDCCCCCC099B23419A99997935365A4166666666699B23419A99997935365A4100000000BE9B2341333333933A365A41000000005D9C2341CDCCCC4C41365A419A999999259D23416666662640365A41333333337F9D2341333333733E365A419A999999119E23410000000040365A4166666666699E2341CDCCCCCC3C365A4100000000209F2341666666E639365A419A999999879F23416666668637365A4100000000BA9F2341666666662E365A4166666666A69F2341CDCCCC8C27365A4133333333609F2341333333731B365A410000000016A023419A999999FE355A41666666662FA02341666666A6FC355A41000000005BA02341CDCCCC4CF2355A413333333344A1234100000080B3355A41333333335DA123419A999939B0355A41000000008BA1234166666606A3355A41CDCCCCCC00A22341333333B38A355A410000000069A22341CDCCCCEC6A355A419A999999C4A223419A9999594D355A410000000080A123419A9999192C355A4100000000D1A023419A99997958355A4166666666E4A02341000000A059355A419A99999921A023410000002094355A41CDCCCCCC2BA023419A99993995355A4100000000739F234133333373C3355A4133333333F49E2341333333B3C7355A4133333333529E2341CDCCCCECC9355A4166666666239E23419A999999C9355A4100000000B79C234100000080E9355A419A999999D99C2341333333F3F8355A419A999999C79C2341CDCCCC6C0C365A41000000002E9C2341666666A603365A419A999999119C2341CDCCCCCC0A365A4133333333F99B2341CDCCCCEC0A365A4100000000F59B23419A9999B910365A419A999999C29B23413333339310365A419A9999998D9B23419A9999590C365A419A9999997E9B2341333333B311365A4133333333F59A23413333333308365A41333333339F9A2341CDCCCC4C1B365A41333333339F9A2341CDCCCC4C1B365A41	01010000206A080000C98CD52B74A0234100000090B5355A41	950180301	H	Les Aulnettes	9501803	95018	95	11	0
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	01060000206A080000010000000103000000010000001C0000006666666665A02341CDCCCCCCEE355A410000000058A1234133333333FD355A410000000033A323413333339318365A4133333333ECA223413333333321365A41CDCCCCCCF4A22341CDCCCC8C27365A4166666666ACA32341000000602F365A410000000017A523419A9999F940365A419A99999959A52341333333D348365A419A9999997AA52341000000004F365A416666666603A623416666662650365A4100000000A7A623419A99995952365A41CDCCCCCCABA623410000000050365A41333333339DA72341000000201F365A41CDCCCCCCB4A823419A9999B9EA355A419A999999B6A8234133333353E8355A41CDCCCCCCB6A7234166666686CE355A419A999999F8A42341000000E086355A4166666666F7A32341CDCCCC6C6C355A413333333362A323419A9999B95D355A419A999999C4A223419A9999594D355A410000000069A22341CDCCCCEC6A355A41CDCCCCCC00A22341333333B38A355A41000000008BA1234166666606A3355A41333333335DA123419A999939B0355A413333333344A1234100000080B3355A41CDCCCCCC80A0234100000020E8355A416666666665A02341CDCCCCCCEE355A416666666665A02341CDCCCCCCEE355A41	01010000206A08000098FF31F34EA423419A9999B9CF355A41	950180302	H	Le Marais	9501803	95018	95	11	1
01060000206A080000010000000103000000010000002C0000009A999999C4A223419A9999594D355A413333333362A323419A9999B95D355A4166666666F7A32341CDCCCC6C6C355A41CDCCCCCC21A42341000000C070355A41CDCCCCCC96A423419A9999997C355A4166666666E5A423419A99999984355A419A999999F8A42341000000E086355A41CDCCCCCC42A52341666666668E355A4133333333AAA523419A9999D998355A41CDCCCCCC1EA623419A9999F9A4355A4100000000BDA62341666666E6B4355A41333333330EA723419A999939BD355A41CDCCCCCCB6A7234166666686CE355A4166666666CAA72341CDCCCC8CD0355A41CDCCCCCC05A82341CDCCCC8CD6355A419A999999ADA823419A999959E7355A419A999999B6A8234133333353E8355A4133333333BFA8234166666626E9355A4133333333C9A82341666666C6E7355A4100000000D3A82341333333F3E5355A419A99999909A92341000000E0DB355A419A99999917A92341000000C0D9355A4166666666B6A923419A999939BE355A419A999999D0A92341CDCCCCACB9355A41CDCCCCCC58AA2341CDCCCCCCA3355A41CDCCCCCC3FAA23419A9999B9A0355A413333333340AA2341333333B3A0355A419A99999947AA23419A9999B99F355A419A9999994FAA2341CDCCCCAC9E355A41CDCCCCCCC3AA2341333333138F355A419A999999BFAA2341333333938E355A410000000016A92341333333136B355A416666666664A82341000000205E355A4133333333EDA723419A99993954355A419A9999997AA72341666666464B355A4166666666D0A62341333333333A355A41CDCCCCCCB3A52341CDCCCCAC1E355A4133333333F9A42341333333B30B355A419A9999999FA423419A99991902355A41666666663AA423419A9999D911355A413333333328A423413333337314355A41CDCCCCCCBEA323410000006025355A416666666692A32341000000402C355A419A999999C4A223419A9999594D355A41	01060000206A080000010000000103000000010000002C0000009A999999C4A223419A9999594D355A413333333362A323419A9999B95D355A4166666666F7A32341CDCCCC6C6C355A41CDCCCCCC21A42341000000C070355A41CDCCCCCC96A423419A9999997C355A4166666666E5A423419A99999984355A419A999999F8A42341000000E086355A41CDCCCCCC42A52341666666668E355A4133333333AAA523419A9999D998355A41CDCCCCCC1EA623419A9999F9A4355A4100000000BDA62341666666E6B4355A41333333330EA723419A999939BD355A41CDCCCCCCB6A7234166666686CE355A4166666666CAA72341CDCCCC8CD0355A41CDCCCCCC05A82341CDCCCC8CD6355A419A999999ADA823419A999959E7355A419A999999B6A8234133333353E8355A4133333333BFA8234166666626E9355A4133333333C9A82341666666C6E7355A4100000000D3A82341333333F3E5355A419A99999909A92341000000E0DB355A419A99999917A92341000000C0D9355A4166666666B6A923419A999939BE355A419A999999D0A92341CDCCCCACB9355A41CDCCCCCC58AA2341CDCCCCCCA3355A41CDCCCCCC3FAA23419A9999B9A0355A413333333340AA2341333333B3A0355A419A99999947AA23419A9999B99F355A419A9999994FAA2341CDCCCCAC9E355A41CDCCCCCCC3AA2341333333138F355A419A999999BFAA2341333333938E355A410000000016A92341333333136B355A416666666664A82341000000205E355A4133333333EDA723419A99993954355A419A9999997AA72341666666464B355A4166666666D0A62341333333333A355A41CDCCCCCCB3A52341CDCCCCAC1E355A4133333333F9A42341333333B30B355A419A9999999FA423419A99991902355A41666666663AA423419A9999D911355A413333333328A423413333337314355A41CDCCCCCCBEA323410000006025355A416666666692A32341000000402C355A419A999999C4A223419A9999594D355A41	01010000206A080000801545AFFEA62341CDCCCCAC76355A41	950180303	H	Les Abattoirs	9501803	95018	95	11	0
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	01060000206A080000010000000103000000010000002C00000000000000A7A623419A99995952365A4100000000CAA62341000000A052365A4100000000C4A823419A9999395A365A41000000007AA92341CDCCCCAC6A365A410000000007AA2341CDCCCC2C78365A419A99999915AB23413333331391365A416666666687AB2341CDCCCCACA0365A419A999999CFAB23419A9999F996365A419A99999920AC2341CDCCCC2C8A365A416666666666AC23419A9999D97A365A41CDCCCCCC80AC2341666666E676365A41000000009FAC2341CDCCCCEC6C365A4133333333C3AC23419A99997957365A41CDCCCCCCE3AB2341CDCCCC6C3E365A4166666666DEAC2341000000801F365A410000000033AD23413333335316365A4100000000CBAC23419A9999B907365A41333333338FAC23419A999959FE355A4166666666B8AB2341CDCCCCACDA355A41000000008EAB23419A9999F9D4355A413333333369AB23419A999979C8355A41666666660BAC23419A9999B9DE355A41CDCCCCCCA5AC2341CDCCCC2CF2355A41CDCCCCCC24AD234133333393FF355A41CDCCCCCC7DAF2341000000A035365A4133333333EDAF2341CDCCCC0C27365A419A99999913B023416666660625365A4133333333B2AF2341333333131D365A4100000000F4AE2341333333130C365A4166666666ACAE23419A99997906365A419A999999EDAD2341CDCCCCACF5355A41000000001FAD23419A9999B9E0355A413333333360AC234133333393C5355A416666666627AC2341CDCCCC8CBE355A416666666641AB2341666666269E355A41CDCCCCCCC3AA2341333333138F355A41CDCCCCCC3FAA23419A9999B9A0355A41CDCCCCCC58AA2341CDCCCCCCA3355A419A999999D0A92341CDCCCCACB9355A41CDCCCCCCB4A823419A9999B9EA355A41333333339DA72341000000201F365A41CDCCCCCCABA623410000000050365A4100000000A7A623419A99995952365A4100000000A7A623419A99995952365A41	01010000206A080000104221F466AA2341333333B319365A41	950180304	H	Ambroise Thomas	9501803	95018	95	11	1
01060000206A080000010000000103000000010000006D000000CDCCCCCCF4A22341CDCCCC8C27365A419A99999905A32341CDCCCCCC2C365A41CDCCCCCC16A323416666666633365A41CDCCCCCC1CA323419A9999D936365A41333333331FA323416666664639365A416666666620A32341CDCCCC6C3A365A416666666624A32341000000803E365A413333333326A323410000002043365A419A99999925A323416666668647365A416666666623A323416666660653365A413333333326A323419A99993957365A41CDCCCCCC29A32341000000005B365A419A99999930A32341666666A661365A41CDCCCCCC3EA323419A9999596B365A416666666640A32341333333536C365A41CDCCCCCC40A323419A9999996C365A416666666657A323416666662676365A416666666663A32341CDCCCC4C7A365A419A99999965A32341000000207B365A419A9999996CA32341666666867D365A416666666682A323416666664683365A413333333389A323410000002085365A419A99999990A323413333339386365A4133333333B3A32341666666668F365A4166666666D1A323416666662697365A4133333333E5A32341333333339C365A419A9999991CA42341666666C6AA365A41CDCCCCCC35A42341CDCCCC8CB1365A416666666651A4234100000000B8365A416666666672A4234166666666C1365A41CDCCCCCC84A42341000000A0C6365A41CDCCCCCCA5A42341CDCCCC0CC8365A4166666666F5A42341000000C0CC365A416666666615A523419A999999CE365A41666666661FA5234133333313CF365A41CDCCCCCC28A5234133333353CF365A41000000002FA52341CDCCCC0CCF365A41CDCCCCCC38A52341CDCCCCACCD365A410000000042A523419A999959CB365A41666666665DA5234100000060C5365A419A99999984A523419A999999BC365A4133333333AFA5234100000020B3365A4166666666E5A5234100000020AA365A419A9999990FA6234133333393A2365A416666666680A62341000000808E365A413333333399A623419A9999F987365A41CDCCCCCCADA623416666662686365A4166666666B2A623416666660690365A41CDCCCCCCB9A6234100000040BE365A419A999999D2A6234100000020B8365A41CDCCCCCC4CA72341333333B399365A41000000005AA72341000000A096365A419A9999991CA82341CDCCCC0CA3365A410000000047A82341CDCCCCCCA5365A41CDCCCCCCB9A82341CDCCCC4CAD365A41CDCCCCCCF8A82341000000C0B0365A41000000000DA92341CDCCCC4CB2365A41CDCCCCCC5DA92341666666A6B7365A41CDCCCCCC6FA9234100000080B7365A41666666667CA92341333333F3B6365A416666666681A9234100000060B6365A419A9999999CA9234166666646B3365A4133333333C7A92341333333F3AC365A4100000000D4A92341666666E6AB365A4133333333DCA923419A999979AB365A4100000000E9A92341CDCCCC4CAB365A419A999999A0AA234166666646AA365A4166666666B9AA2341333333F3A9365A4166666666D3AA2341CDCCCC6CA9365A419A999999E9AA23419A999999A8365A4166666666F5AA234166666606A8365A41666666660AAB2341333333B3A6365A41333333332BAB23419A9999F9A8365A41666666663FAB23419A999979AA365A416666666687AB2341CDCCCCACA0365A419A99999922AB2341666666A692365A419A99999915AB23413333331391365A41333333330DAB2341CDCCCC4C90365A41CDCCCCCCF6AA2341666666268E365A41CDCCCCCCCBAA2341000000608A365A410000000043AA23419A9999B97D365A41666666660DAA2341666666C678365A410000000007AA2341CDCCCC2C78365A41000000007AA92341CDCCCCAC6A365A419A9999995EA923410000004068365A4133333333EEA82341666666465E365A4100000000C4A823419A9999395A365A419A99999984A823413333331359365A419A9999991CA82341000000A057365A419A999999F1A72341CDCCCC0C57365A41CDCCCCCC51A72341CDCCCCAC54365A4100000000CAA62341000000A052365A4100000000A7A623419A99995952365A416666666664A623419A99995951365A416666666603A623416666662650365A4166666666C5A52341333333934F365A419A9999997AA52341000000004F365A41CDCCCCCC75A52341666666E64C365A419A99999959A52341333333D348365A419A9999991FA52341666666C641365A410000000017A523419A9999F940365A4100000000A1A42341CDCCCC2C3B365A41CDCCCCCC14A423416666668634365A4133333333FAA323410000004033365A4166666666ACA32341000000602F365A41CDCCCCCC52A32341000000402B365A41CDCCCCCC2BA323413333337329365A416666666610A323413333337328365A41CDCCCCCCF4A22341CDCCCC8C27365A41	01060000206A0800000100000001030000000100000024000000CDCCCCCCF4A22341CDCCCC8C27365A41CDCCCCCC16A323416666666633365A416666666624A32341000000803E365A416666666623A323416666660653365A41CDCCCCCC40A323419A9999996C365A419A9999996CA32341666666867D365A416666666651A4234100000000B8365A41CDCCCCCC84A42341000000A0C6365A416666666615A523419A999999CE365A41CDCCCCCC38A52341CDCCCCACCD365A4133333333AFA5234100000020B3365A4166666666E5A5234100000020AA365A41CDCCCCCCADA623416666662686365A4166666666B2A623416666660690365A41CDCCCCCCB9A6234100000040BE365A41000000005AA72341000000A096365A41CDCCCCCC5DA92341666666A6B7365A41666666667CA92341333333F3B6365A4133333333C7A92341333333F3AC365A4100000000E9A92341CDCCCC4CAB365A419A999999A0AA234166666646AA365A41666666660AAB2341333333B3A6365A41666666663FAB23419A999979AA365A416666666687AB2341CDCCCCACA0365A419A99999915AB23413333331391365A410000000007AA2341CDCCCC2C78365A41000000007AA92341CDCCCCAC6A365A4100000000C4A823419A9999395A365A4100000000CAA62341000000A052365A416666666603A623416666662650365A419A9999997AA52341000000004F365A419A99999959A52341333333D348365A410000000017A523419A9999F940365A4166666666ACA32341000000602F365A41CDCCCCCCF4A22341CDCCCC8C27365A41CDCCCCCCF4A22341CDCCCC8C27365A41	01010000206A080000DA285F78CEA62341333333537C365A41	950180401	H	La Tour Billy	9501804	95018	95	11	0
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	01060000206A0800000100000001030000000100000025000000666666662FA02341666666A6FC355A410000000055A023419A99991935365A419A99999976A02341000000003A365A41666666665AA02341000000403F365A41666666666DA02341CDCCCCCC5A365A41666666667BA02341666666C665365A41CDCCCCCC72A023419A99993992365A41666666664AA02341333333D3B3365A41666666664EA02341CDCCCC4CC4365A416666666661A02341666666E6D7365A41CDCCCCCC90A02341666666C6F9365A419A999999A1A023410000002003375A4133333333E1A0234166666626FB365A4133333333FAA02341333333F3FC365A4166666666DCA22341333333130A375A419A9999990EA32341CDCCCC0C0A375A41000000002EA32341000000E001375A41CDCCCCCC1FA323410000002000375A41CDCCCCCC62A3234166666606E4365A4166666666A5A3234133333333C1365A419A999999B2A3234100000080BC365A41CDCCCCCC42A423419A999959C2365A419A99999960A4234133333353C2365A41CDCCCCCC84A42341000000A0C6365A416666666651A4234100000000B8365A419A9999996CA32341666666867D365A41CDCCCCCC40A323419A9999996C365A416666666623A323416666660653365A416666666624A32341000000803E365A41CDCCCCCC16A323416666666633365A41CDCCCCCCF2A22341CDCCCCEC26365A4133333333ECA223413333333321365A410000000033A323413333339318365A410000000058A1234133333333FD355A416666666665A02341CDCCCCCCEE355A41666666662FA02341666666A6FC355A41666666662FA02341666666A6FC355A41	01010000206A080000D8002F08F0A12341333333537C365A41	950180402	H	Moulin Sarrazin	9501804	95018	95	11	0
01060000206A080000010000000103000000010000003900000033333333659C23413333337309375A4100000000099D2341CDCCCC4C12375A41CDCCCCCC589D2341CDCCCC6C16375A419A999999F99E23419A9999B92C375A41CDCCCCCC5A9F2341666666E631375A4166666666EA9F2341CDCCCC0C39375A419A999999FE9F2341333333F339375A410000000009A02341333333B336375A419A99999913A023419A99995937375A419A99999974A02341333333B33B375A4166666666CEA02341666666863F375A41CDCCCCCCD5A02341000000C03A375A41CDCCCCCCD6A023419A99995937375A419A999999CEA02341666666662E375A419A999999DBA023413333339323375A4133333333E3A02341333333B323375A4100000000E8A02341000000801F375A4166666666FAA023416666662612375A4133333333FAA02341333333F3FC365A4100000000EDA023419A999979FC365A4133333333E1A0234166666626FB365A419A999999A1A023410000002003375A41CDCCCCCC90A02341666666C6F9365A41000000008CA02341CDCCCC4CF6365A41333333338AA0234100000020F5365A416666666661A02341666666E6D7365A41333333335BA023419A9999F9D4365A41666666664EA02341CDCCCC4CC4365A41666666664CA023419A9999D9BF365A41333333334AA02341CDCCCCACB6365A41666666664AA02341333333D3B3365A419A9999994DA02341CDCCCC0CB0365A410000000056A0234100000060AB365A41CDCCCCCC6BA023419A99999998365A41CDCCCCCC72A023419A99993992365A413333333373A02341000000A08E365A41CDCCCCCC75A02341000000C081365A419A99999976A02341CDCCCC2C7E365A41666666667BA02341666666C665365A410000000075A02341000000E065365A41333333338B9F2341CDCCCC0C69365A4133333333AF9E2341000000E06B365A41333333338D9E2341333333536C365A4133333333C39D2341333333136F365A41000000008F9C2341666666C673365A41CDCCCCCC8A9C23419A9999D973365A419A9999998F9C23419A9999B988365A41333333338F9C2341000000C08A365A41333333338C9C23419A999979A0365A419A999999899C23419A9999F9AF365A41CDCCCCCC869C2341CDCCCC6CC0365A41CDCCCCCC7F9C23419A999999E5365A41333333337C9C234100000000FB365A419A9999997D9C23419A99991902375A41666666667B9C23413333331303375A41000000006D9C23413333331307375A4133333333659C23413333337309375A41	01060000206A080000010000000103000000010000001900000033333333659C23413333337309375A41CDCCCCCC5A9F2341666666E631375A419A999999FE9F2341333333F339375A410000000009A02341333333B336375A4166666666CEA02341666666863F375A41CDCCCCCCD6A023419A99995937375A419A999999CEA02341666666662E375A4133333333E3A02341333333B323375A4166666666FAA023416666662612375A4133333333FAA02341333333F3FC365A4133333333E1A0234166666626FB365A419A999999A1A023410000002003375A41CDCCCCCC90A02341666666C6F9365A416666666661A02341666666E6D7365A41666666664EA02341CDCCCC4CC4365A41666666664AA02341333333D3B3365A41CDCCCCCC72A023419A99993992365A41666666667BA02341666666C665365A4133333333C39D2341333333136F365A41CDCCCCCC8A9C23419A9999D973365A419A9999998F9C23419A9999B988365A41333333337C9C234100000000FB365A419A9999997D9C23419A99991902375A4133333333659C23413333337309375A4133333333659C23413333337309375A41	01010000206A0800002E9F73A66C9E2341343333A3CC365A41	950180403	H	Les Fleurs	9501804	95018	95	11	0
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	01060000206A08000001000000010300000001000000270000009A999999D0962341666666C681365A41333333338E9723410000000084365A4133333333859823416666664684365A41CDCCCCCCEB982341000000C083365A4100000000639A2341333333337F365A41000000008F9C2341666666C673365A4133333333C39D2341333333136F365A41666666667BA02341666666C665365A41666666666DA02341CDCCCCCC5A365A41666666665AA02341000000403F365A419A99999976A02341000000003A365A410000000055A023419A99991935365A41666666662FA02341666666A6FC355A410000000016A023419A999999FE355A4133333333609F2341333333731B365A4166666666A69F2341CDCCCC8C27365A4100000000BA9F2341666666662E365A419A999999879F23416666668637365A4100000000209F2341666666E639365A4166666666699E2341CDCCCCCC3C365A419A999999119E23410000000040365A41333333337F9D2341333333733E365A419A999999259D23416666662640365A41000000005D9C2341CDCCCC4C41365A4100000000BE9B2341333333933A365A4166666666699B23419A99997935365A41CDCCCCCC099B23419A99997935365A4166666666C09A2341CDCCCCAC1F365A419A9999996F9A2341CDCCCC2C19365A413333333333992341333333D323365A4100000000CE982341CDCCCC6C23365A4133333333D3982341000000203D365A4100000000A8972341CDCCCC6C3F365A4133333333A59723419A9999394F365A413333333316972341666666064D365A419A999999D99623419A9999594B365A4100000000DE9623416666662666365A419A999999D0962341666666C681365A419A999999D0962341666666C681365A41	01010000206A0800003EDB1A7BF79923410000006040365A41	950180404	H	Le Gibet	9501804	95018	95	11	0
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	01060000206A0800000100000001030000000100000026000000CDCCCCCCF0952341000000C082365A4133333333FD9523416666662696365A41000000002796234166666686AE365A410000000063962341CDCCCC4CDC365A410000000071962341CDCCCC0C06375A41333333338C962341333333D305375A419A999999649623419A99993964375A419A999999599623419A9999D96D375A419A99999991962341333333F374375A4166666666C09623419A99991975375A4133333333639723419A9999797D375A4100000000819723419A99995978375A41CDCCCCCC99972341000000C040375A4100000000A1972341666666263C375A410000000082982341666666263E375A4100000000979823419A9999F923375A41666666669D982341666666A609375A4133333333AA98234166666666EA365A41333333339C98234100000060E7365A4133333333519823419A9999F9E2365A41666666666D98234100000060D8365A419A9999998198234100000080D4365A419A999999009A234100000000E9365A4133333333659C23413333337309375A419A9999997D9C23419A99991902375A41333333337C9C234100000000FB365A419A9999998F9C23419A9999B988365A41CDCCCCCC8A9C23419A9999D973365A4100000000639A2341333333337F365A41CDCCCCCCEB982341000000C083365A4133333333859823416666664684365A41333333338E9723410000000084365A419A999999D0962341333333F381365A4133333333B89623419A9999797F365A413333333366962341333333D36D365A4133333333379623410000006081365A41CDCCCCCCF0952341000000C082365A41CDCCCCCCF0952341000000C082365A41	01010000206A0800008621ADF688972341000000A0F7365A41	950180405	H	Le Prunet	9501804	95018	95	11	0
01060000206A080000010000000103000000010000002500000066666666CEA02341666666863F375A4133333333FFA02341CDCCCC8C41375A410000000037A12341666666E643375A41CDCCCCCC9CA123410000002048375A4166666666CFA12341CDCCCC2C4A375A413333333366A223410000004050375A41000000006FA32341333333135B375A41CDCCCCCC7CA323416666668653375A41CDCCCCCC7EA323416666668652375A4166666666A1A323419A9999D93F375A419A999999AEA32341333333D338375A4100000000C2A323419A9999F92F375A4166666666C2A32341000000C02F375A4166666666EAA323419A99997921375A416666666620A42341333333930C375A419A999999B6A32341CDCCCC4C08375A410000000028A32341CDCCCC2C03375A410000000023A323419A99999905375A41000000001FA323413333337307375A41CDCCCCCC17A323416666662609375A419A9999990EA32341CDCCCC0C0A375A419A99999906A32341666666460A375A4166666666EFA22341333333530A375A4166666666DCA22341333333130A375A41CDCCCCCC74A22341CDCCCC4C07375A419A99999914A22341000000A004375A419A9999990BA223419A99995904375A4133333333D2A12341000000C002375A4133333333FAA02341333333F3FC365A4166666666FAA023416666662612375A4100000000E8A02341000000801F375A4133333333E3A02341333333B323375A419A999999DBA023413333339323375A419A999999CEA02341666666662E375A41CDCCCCCCD6A023419A99995937375A41CDCCCCCCD5A02341000000C03A375A4166666666CEA02341666666863F375A41	01060000206A080000010000000103000000010000000F00000066666666CEA02341666666863F375A41000000006FA32341333333135B375A419A999999AEA32341333333D338375A4166666666C2A32341000000C02F375A416666666620A42341333333930C375A410000000028A32341CDCCCC2C03375A419A9999990EA32341CDCCCC0C0A375A4166666666DCA22341333333130A375A4133333333FAA02341333333F3FC365A4166666666FAA023416666662612375A4133333333E3A02341333333B323375A419A999999CEA02341666666662E375A41CDCCCCCCD6A023419A99995937375A4166666666CEA02341666666863F375A4166666666CEA02341666666863F375A41	01010000206A0800007594791955A22341CCCCCC0C29375A41	950180501	H	Le Perreux	9501805	95018	95	11	0
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	01060000206A08000001000000010300000001000000150000009A9999991FA32341333333F300375A410000000028A32341CDCCCC2C03375A416666666620A42341333333930C375A4166666666C2A32341000000C02F375A419A999999AEA32341333333D338375A41000000006FA32341333333135B375A4100000000C0A42341CDCCCC8C68375A41000000004BA523419A9999393A375A41666666667DA52341000000C023375A41CDCCCCCC0AA623419A9999F9F3365A419A99999970A523419A9999B9EB365A41CDCCCCCC45A52341CDCCCC4CE8365A41CDCCCCCCD7A42341666666C6DA365A41CDCCCCCC84A42341000000A0C6365A419A99999960A4234133333353C2365A41CDCCCCCC42A423419A999959C2365A419A999999B2A3234100000080BC365A4166666666A5A3234133333333C1365A41CDCCCCCC62A3234166666606E4365A419A9999991FA32341333333F300375A419A9999991FA32341333333F300375A41	01010000206A080000C737CD63DCA423419A9999E913375A41	950180502	H	Poirier Fourrier	9501805	95018	95	11	0
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	01060000206A080000010000000103000000010000001D000000CDCCCCCC84A42341000000A0C6365A41CDCCCCCCD7A42341666666C6DA365A41CDCCCCCC45A52341CDCCCC4CE8365A4133333333B7A52341666666E6EF365A419A9999993FA723419A99991902375A41333333331AA923413333335317375A416666666678AA23416666668628375A41CDCCCCCC95AA2341CDCCCC2C21375A4100000000E8AA2341CDCCCCAC11375A41000000003EA92341000000E0F4365A4100000000FAA923419A999979D8365A4133333333D1AA2341666666C6B8365A41666666663FAB23419A999979AA365A41666666660AAB2341333333B3A6365A419A999999A0AA234166666646AA365A4100000000E9A92341CDCCCC4CAB365A4133333333C7A92341333333F3AC365A41666666667CA92341333333F3B6365A41CDCCCCCC5DA92341666666A6B7365A41000000005AA72341000000A096365A41CDCCCCCCB9A6234100000040BE365A4166666666B2A623416666660690365A41CDCCCCCCADA623416666662686365A4166666666E5A5234100000020AA365A4133333333AFA5234100000020B3365A41CDCCCCCC38A52341CDCCCCACCD365A416666666615A523419A999999CE365A41CDCCCCCC84A42341000000A0C6365A41CDCCCCCC84A42341000000A0C6365A41	01010000206A08000042575DEB65A723419A999919D6365A41	950180503	H	Hôpital	9501805	95018	95	11	0
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	01060000206A0800000100000001030000000100000018000000333333335DA42341000000C07F375A4100000000FBA423416666664685375A4166666666BDA52341000000808D375A419A99999964A623419A99997996375A41333333335AA72341666666C6A6375A416666666608A82341000000607E375A419A9999993FA823419A9999196F375A419A99999963A823416666664662375A419A99999986A823419A9999D951375A4166666666A3A82341CDCCCC4C47375A4133333333ADA82341333333333F375A4133333333ACA92341000000803A375A410000000048AA23419A99993936375A416666666678AA23416666668628375A41333333331AA923413333335317375A41CDCCCCCCC0A823416666668613375A41CDCCCCCC0AA623419A9999F9F3365A419A99999995A52341000000401B375A413333333351A52341000000C035375A41000000004BA523419A9999393A375A4133333333ECA423413333335359375A41CDCCCCCCA8A42341000000C070375A41333333335DA42341000000C07F375A41333333335DA42341000000C07F375A41	01010000206A08000048CCD267D3A62341CDCCCCAC4D375A41	950180504	H	Croix Duny	9501805	95018	95	11	0
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	01060000206A080000010000000103000000010000003A00000066666666F3942341333333B328385A419A99999949952341000000A03E385A41333333339A9523419A9999994F385A4133333333E7952341333333F35A385A41CDCCCCCC0C962341CDCCCC8C64385A41CDCCCCCC559623416666660674385A41CDCCCCCCCC9623419A9999198F385A41333333333F97234166666646A2385A4133333333C7982341CDCCCC6C62385A4133333333FA9823419A9999D959385A419A9999999C9A23419A99991916385A41CDCCCCCC679B2341666666C6F4375A41CDCCCCCC869C2341333333B3C6375A41666666660A9D23419A999999CE375A4100000000029E2341333333B3A7375A419A9999992C9E234100000000A2375A4133333333929E23410000004097375A41666666664B9F2341666666068A375A4100000000BD9F2341000000E083375A41CDCCCCCC36A023419A9999F97E375A4133333333E8A02341333333D37A375A419A99999992A12341333333D377375A419A99999950A223410000004076375A416666666635A323419A99991978375A4133333333AAA32341333333737A375A41333333335DA42341000000C07F375A41CDCCCCCCA8A42341000000C070375A4100000000C0A42341CDCCCC8C68375A41000000006FA32341333333135B375A41CDCCCCCC9CA123410000002048375A419A99999974A02341333333B33B375A410000000009A02341333333B336375A419A999999FE9F2341333333F339375A41CDCCCCCC5A9F2341666666E631375A41CDCCCCCCD79A234100000040F4365A419A999999009A234100000000E9365A419A9999998198234100000080D4365A41666666666D98234100000060D8365A4133333333519823419A9999F9E2365A41333333339C98234100000060E7365A4133333333AA98234166666666EA365A41666666669D982341666666A609375A4100000000979823419A9999F923375A410000000082982341666666263E375A4100000000A1972341666666263C375A41CDCCCCCC99972341000000C040375A4100000000819723419A99995978375A4133333333639723419A9999797D375A4166666666C09623419A99991975375A419A99999991962341333333F374375A419A999999599623419A9999D96D375A419A99999958962341CDCCCC0C7D375A419A9999993A96234166666686C9375A41CDCCCCCC2D96234133333393E4375A419A999999199623416666664617385A4166666666D2952341CDCCCC0C19385A4166666666F3942341333333B328385A4166666666F3942341333333B328385A41	01010000206A0800007C93668DCF9923419A9999E9C0375A41	950180601	H	Chateaubriand	9501806	95018	95	11	1
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	01060000206A080000010000000103000000010000002C000000333333333F97234166666646A2385A4100000000A69723419A999919B4385A4133333333DB972341CDCCCCACBB385A413333333305992341CDCCCC6CED385A419A999999B1992341333333B30A395A41CDCCCCCC6E9A23419A999979F7385A419A999999D99A2341CDCCCCECED385A4100000000499B23419A9999D9E6385A41CDCCCCCC7E9C2341CDCCCC8CD8385A41CDCCCCCC939D23419A999959CB385A41CDCCCCCC5E9E23419A999919C2385A4166666666359F2341CDCCCCCCB7385A416666666691A02341CDCCCCAC9F385A41333333338BA12341CDCCCC0C8E385A419A99999917A22341666666A682385A41CDCCCCCC6BA223419A99993979385A41CDCCCCCCB7A223419A9999196F385A410000000031A42341000000A038385A416666666688A42341CDCCCC2C2B385A41CDCCCCCC99A42341333333332A385A4100000000DDA423419A9999991F385A41CDCCCCCCA0A42341CDCCCC8C1D385A419A99999976A32341333333131E385A41CDCCCCCC11A32341666666261C385A41000000005BA223410000008016385A4100000000E0A123413333337314385A41CDCCCCCCA8A123416666666612385A410000000026A12341666666C609385A419A99999958A023413333331306385A419A999999F89E2341CDCCCC0C02385A41CDCCCCCC099D234100000020FF375A4100000000C29C2341666666A6FC375A4133333333969C234166666606F9375A4133333333789C2341333333F3F3375A4166666666659C234133333353EC375A4100000000719C2341666666C6E3375A41666666660A9D23419A999999CE375A41CDCCCCCC869C2341333333B3C6375A41CDCCCCCC679B2341666666C6F4375A419A9999999C9A23419A99991916385A4133333333FA9823419A9999D959385A4133333333C7982341CDCCCC6C62385A41333333333F97234166666646A2385A41333333333F97234166666646A2385A41	01010000206A0800001A77EA49B59D2341000000B06A385A41	950180602	H	Chemin Vert	9501806	95018	95	11	1
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	01060000206A080000010000000103000000010000001200000033333333629C2341CDCCCC8CE9375A4133333333789C2341333333F3F3375A4133333333969C234166666606F9375A4100000000C29C2341666666A6FC375A41CDCCCCCC099D234100000020FF375A41CDCCCCCCD19D23419A99995900385A419A999999DD9D23419A9999F9FB375A4166666666A59F234100000040B3375A419A999999C39F2341333333F3B0375A41666666664B9F2341666666068A375A4133333333929E23410000004097375A419A9999992C9E234100000000A2375A4100000000029E2341333333B3A7375A4166666666CD9C2341333333B3D7375A41CDCCCCCCBA9C2341333333F3D8375A4100000000719C2341666666C6E3375A4133333333629C2341CDCCCC8CE9375A4133333333629C2341CDCCCC8CE9375A41	01010000206A08000028D97AF7439E23419A999959C4375A41	950180603	H	La Bérionne	9501806	95018	95	11	0
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	01060000206A0800000100000001030000000100000013000000CDCCCCCCD19D23419A99995900385A419A999999F89E2341CDCCCC0C02385A419A99999958A023413333331306385A419A9999993DA12341CDCCCCAC0A385A4133333333B5A123419A99999900385A413333333380A2234100000080F2375A41000000009CA223419A999959EF375A410000000091A22341CDCCCCACEB375A41666666663FA2234100000080E3375A410000000039A2234166666626E0375A41CDCCCCCCF4A2234166666626C3375A4166666666B9A22341333333B3BC375A41CDCCCCCC7DA223419A9999F9BB375A41666666663AA0234166666626B2375A4166666666C39F2341000000E0AF375A4166666666A59F234100000040B3375A419A999999DD9D23419A9999F9FB375A41CDCCCCCCD19D23419A99995900385A41CDCCCCCCD19D23419A99995900385A41	01010000206A0800008697E30D83A023419A9999E9DA375A41	950180604	H	Les Canuts	9501806	95018	95	11	0
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	01060000206A0800000100000001030000000100000027000000CDCCCCCC6A9F23416666660694375A4166666666C39F2341000000E0AF375A41666666663AA0234166666626B2375A41CDCCCCCC7DA223419A9999F9BB375A4166666666B9A22341333333B3BC375A41CDCCCCCCF4A2234166666626C3375A410000000039A2234166666626E0375A41666666663FA2234100000080E3375A410000000091A22341CDCCCCACEB375A41000000009CA223419A999959EF375A410000000028A32341CDCCCCECD9375A410000000016A32341CDCCCCCCD7375A416666666655A32341666666C6CE375A41666666666DA42341CDCCCC8CE9375A419A99999969A42341CDCCCC6CD6375A416666666655A4234133333373D2375A4166666666D7A32341666666C6C5375A419A9999996BA32341CDCCCCCCB9375A41CDCCCCCC75A323419A999999B5375A4166666666B6A32341CDCCCC8CAB375A4100000000B4A323419A9999B9A8375A41666666667AA323419A999979A3375A419A999999C4A32341333333F397375A416666666608A32341000000C085375A4100000000B3A223416666666689375A413333333347A22341CDCCCC4C8F375A419A9999993BA223416666666691375A419A9999991AA22341CDCCCCCCAA375A416666666669A123419A9999F9A6375A419A99999961A12341CDCCCC6CA3375A4100000000C3A023419A999979A0375A4166666666B0A02341CDCCCC0CAA375A419A9999999DA023419A999939AB375A419A99999911A0234166666666A8375A4100000000DA9F2341CDCCCC4C98375A4166666666B19F2341CDCCCC0C93375A419A999999939F2341333333F391375A41CDCCCCCC6A9F23416666660694375A41CDCCCCCC6A9F23416666660694375A41	01010000206A080000343333B3E3A22341CDCCCC3CBB375A41	950180605	H	Commune de Paris	9501806	95018	95	11	0
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	01060000206A080000010000000103000000010000002D000000666666664B9F2341666666068A375A41CDCCCCCC6A9F23416666660694375A419A999999939F2341333333F391375A4166666666B19F2341CDCCCC0C93375A4100000000DA9F2341CDCCCC4C98375A419A99999911A0234166666666A8375A419A9999999DA023419A999939AB375A4166666666B0A02341CDCCCC0CAA375A4100000000C3A023419A999979A0375A419A99999961A12341CDCCCC6CA3375A416666666669A123419A9999F9A6375A419A9999991AA22341CDCCCCCCAA375A419A9999993BA223416666666691375A413333333347A22341CDCCCC4C8F375A4100000000B3A223416666666689375A416666666608A32341000000C085375A419A999999C4A32341333333F397375A41666666667AA323419A999979A3375A4100000000B4A323419A9999B9A8375A4166666666B6A32341CDCCCC8CAB375A41CDCCCCCC75A323419A999999B5375A419A9999996BA32341CDCCCCCCB9375A4166666666D7A32341666666C6C5375A416666666655A4234133333373D2375A419A99999969A42341CDCCCC6CD6375A41666666666DA42341CDCCCC8CE9375A419A9999990EA523419A999939F8375A41CDCCCCCC9DA52341CDCCCCCC00385A419A99999906A6234133333373EF375A41CDCCCCCC66A6234100000020DE375A41000000000DA72341CDCCCCACBB375A41333333335AA72341666666C6A6375A419A99999964A623419A99997996375A4166666666BDA52341000000808D375A4100000000FBA423416666664685375A410000000026A42341333333F37D375A4133333333AAA32341333333737A375A416666666635A323419A99991978375A419A99999950A223410000004076375A419A99999992A12341333333D377375A4133333333E8A02341333333D37A375A41CDCCCCCC36A023419A9999F97E375A4100000000BD9F2341000000E083375A41666666664B9F2341666666068A375A41666666664B9F2341666666068A375A41	01010000206A080000D2107FDC41A52341000000E0BA375A41	950180606	H	Jean Lurçat	9501806	95018	95	11	0
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	01060000206A08000001000000010300000001000000190000009A9999993DA12341CDCCCCAC0A385A41CDCCCCCCA8A123416666666612385A4100000000E0A123413333337314385A41000000005BA223410000008016385A41CDCCCCCC11A32341666666261C385A419A99999976A32341333333131E385A41CDCCCCCCA0A42341CDCCCC8C1D385A4100000000DDA423419A9999991F385A413333333322A523419A99995914385A413333333371A52341CDCCCCCC1C385A4166666666D3A523413333331322385A419A99999955A623416666664627385A416666666698A623419A9999190C385A416666666689A52341CDCCCC0C00385A413333333386A52341666666C6FE375A419A9999990EA523419A999939F8375A4166666666DBA42341CDCCCC2CF4375A416666666655A32341666666C6CE375A410000000016A32341CDCCCCCCD7375A410000000028A32341CDCCCCECD9375A4133333333BDA2234166666686EA375A413333333380A2234100000080F2375A4133333333B5A123419A99999900385A419A9999993DA12341CDCCCCAC0A385A419A9999993DA12341CDCCCCAC0A385A41	01010000206A080000E44874F69FA3234100000080FA375A41	950180607	H	Le Coudray	9501806	95018	95	11	0
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	01060000206A08000001000000010300000001000000330000009A999999D99A2341CDCCCCECED385A4133333333719B2341CDCCCC0C0B395A41CDCCCCCCAB9B23419A9999D917395A41CDCCCCCC049D2341333333135A395A41CDCCCCCC529D2341CDCCCC2C67395A4166666666BE9D23419A9999D97F395A4100000000E29D2341333333937C395A419A999999539E23419A9999398E395A4100000000B19E2341666666469F395A4100000000FB9E2341CDCCCCCC9B395A41CDCCCCCC2EA02341333333F3DD395A41CDCCCCCC69A0234100000040DB395A4166666666F3A0234100000040D0395A41000000005BA123419A999939C3395A419A999999B9A123419A999939B9395A419A999999E5A123419A999999B6395A41CDCCCCCC8AA42341666666E69C395A419A99999976A42341CDCCCCAC8C395A4166666666F9A423410000008078395A41CDCCCCCC1BA523419A9999996E395A416666666666A523413333331346395A41CDCCCCCC73A52341000000003B395A416666666689A52341333333533B395A41666666668FA52341666666A634395A4133333333C2A52341333333F32D395A41CDCCCCCC56A623413333339327395A41000000007EA62341CDCCCC6C14395A41CDCCCCCCB1A623413333331303395A419A999999CFA6234166666646F6385A4133333333E9A62341CDCCCC4CE4385A4100000000F8A62341666666A6CC385A410000000016A72341CDCCCCECBB385A41333333335CA72341000000A0B0385A4133333333E9A7234166666626A1385A41CDCCCCCCFFA72341666666669D385A4133333333C5A72341666666669D385A4133333333AAA623413333337399385A4166666666D2A523413333335393385A419A999999A6A423419A9999D98D385A41CDCCCCCC2AA32341CDCCCC6C8D385A410000000027A22341000000E08A385A4166666666E9A12341000000A086385A41333333338BA12341CDCCCC0C8E385A416666666691A02341CDCCCCAC9F385A4166666666359F2341CDCCCCCCB7385A41CDCCCCCC5E9E23419A999919C2385A41CDCCCCCC939D23419A999959CB385A41CDCCCCCC7E9C2341CDCCCC8CD8385A4100000000499B23419A9999D9E6385A419A999999D99A2341CDCCCCECED385A419A999999D99A2341CDCCCCECED385A41	01010000206A08000046F60C0CE7A023410000007031395A41	950180701	H	La Heurneuse	9501807	95018	95	11	1
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	01010000206A080000284ECC00C0AA2341000000F0EC385A41	950180702	H	Morifosse	9501807	95018	95	11	1
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	01060000206A080000010000000103000000010000002A00000066666666E9A12341000000A086385A410000000027A22341000000E08A385A41CDCCCCCC2AA32341CDCCCC6C8D385A419A999999A6A423419A9999D98D385A4166666666D2A523413333335393385A4133333333AAA623413333337399385A41CDCCCCCC7DA72341CDCCCC8C9C385A4166666666F1A72341CDCCCCAC9D385A416666666615A82341333333939C385A419A999999D8A82341000000208F385A419A999999F0A823419A9999B986385A41333333333FA923419A99999972385A419A999999DBA923419A9999F93D385A410000000077AA2341666666C618385A4100000000EFAA2341666666E602385A410000000040AB2341CDCCCCACF2375A4100000000A6AA2341CDCCCCECE5375A41CDCCCCCC48AA23419A999959E0375A41000000005FA9234100000080D5375A410000000049A8234133333393C9375A41CDCCCCCC53A7234100000020BE375A419A99999948A7234133333353BA375A41CDCCCCCC7BA7234166666686AD375A410000000082A72341333333D3A8375A41333333335AA72341666666C6A6375A41000000000DA72341CDCCCCACBB375A41CDCCCCCC66A6234100000020DE375A419A99999906A6234133333373EF375A41CDCCCCCC9DA52341CDCCCCCC00385A416666666698A623419A9999190C385A419A99999955A623416666664627385A4166666666D3A523413333331322385A413333333371A52341CDCCCCCC1C385A413333333322A523419A99995914385A41CDCCCCCC99A42341333333332A385A416666666688A42341CDCCCC2C2B385A410000000031A42341000000A038385A41CDCCCCCCB7A223419A9999196F385A41CDCCCCCC6BA223419A99993979385A419A99999917A22341666666A682385A4166666666E9A12341000000A086385A4166666666E9A12341000000A086385A41	01010000206A0800003C43056F57A823410000004022385A41	950180703	H	Felifeu	9501807	95018	95	11	1
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	01060000206A080000010000000103000000010000002D000000333333333FA923419A99999972385A41CDCCCCCC7BA92341333333537B385A416666666685A92341333333737F385A410000000081AA2341CDCCCC0C84385A4100000000E4AA2341000000E081385A416666666650AB23419A9999F97D385A413333333389AB23413333335388385A4133333333C6AB2341000000E09F385A41CDCCCCCCEEAB2341CDCCCC0CA6385A419A99999913AC234133333313B4385A41CDCCCCCC19AC2341CDCCCC8CBB385A41666666661EAC2341CDCCCC2CD5385A410000000032AC2341CDCCCCCCDC385A416666666664AC23419A999939E8385A41CDCCCCCCA2AC2341CDCCCCCCE5385A41CDCCCCCC63AD2341333333D3E5385A41CDCCCCCC07AE234100000080E2385A4133333333FDAD2341CDCCCCACDF385A41333333337FAD2341000000C0C9385A416666666657AD234133333373C4385A419A9999997BAD23419A9999F9BA385A410000000086AD234100000020B5385A419A999999D0AD234166666686AE385A41CDCCCCCC0AAE234133333373AB385A41CDCCCCCC77AE234166666666A8385A4166666666BDAE2341CDCCCC4CB6385A41CDCCCCCCCBAE23413333337399385A41333333331CAF2341000000E06D385A413333333336AF23410000004052385A413333333335AF23419A9999B93E385A419A9999992DAF23416666664637385A419A999999F1AE23413333339323385A4133333333E7AE2341CDCCCC4C16385A419A99999954AE2341666666A616385A41CDCCCCCCC3AD23416666664615385A41333333335CAD2341333333F312385A4166666666C0AC2341CDCCCC8C0C385A41333333337DAC23419A99999908385A4133333333F4AB2341333333B3FE375A410000000040AB2341CDCCCCACF2375A4100000000EFAA2341666666E602385A410000000077AA2341666666C618385A419A999999DBA923419A9999F93D385A41333333333FA923419A99999972385A41333333333FA923419A99999972385A41	01010000206A080000F4B6AC1B39AC2341CDCCCCDC6B385A41	950180801	H	Morinval	9501808	95018	95	11	0
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	01060000206A08000001000000010300000001000000330000009A99999977AE2341333333D3BE385A416666666693AE23419A999979DE385A4166666666ADAE2341CDCCCCCCF3385A413333333337AF23419A999939EE385A416666666632AF2341333333F3EB385A4166666666BAAF23419A999999E6385A4133333333B6AF234133333333E5385A41CDCCCCCC3CB12341CDCCCC4CE1385A4100000000CAB1234133333333E0385A4133333333D5B12341000000A0E5385A41333333333DB22341CDCCCC6CDF385A419A99999958B22341333333B3E6385A413333333369B22341666666E6E4385A4166666666A2B32341000000C0DD385A41CDCCCCCCAFB32341CDCCCCACE4385A416666666668B4234133333353E0385A4133333333BEB4234166666686DD385A41CDCCCCCCD4B42341CDCCCC8CDE385A419A999999DAB52341CDCCCCECCF385A419A999999FFB5234100000080CE385A41CDCCCCCCFFB5234133333393C1385A413333333392B5234133333333A4385A4100000000B1B42341CDCCCC0C66385A41CDCCCCCC6DB423410000000053385A41CDCCCCCC4AB32341CDCCCC0C03385A4100000000F6B22341CDCCCCACEA375A41CDCCCCCCC7B2234166666606DA375A4100000000A7B2234133333373CA375A410000000087B2234133333353B2375A41666666666BB22341333333F3B6375A41333333332EB223419A999939CB375A41CDCCCCCC1EB2234166666686CE375A41666666663DB22341000000C0DA375A41CDCCCCCCD5B12341000000E0DF375A419A9999997EB1234166666646ED375A419A9999990DB1234133333393FA375A4133333333AFB023410000004003385A416666666632B02341333333930B385A4166666666A5AF2341333333B311385A41CDCCCCCC4DAF23419A99997914385A4133333333E7AE2341CDCCCC4C16385A419A999999F1AE23413333339323385A419A9999992DAF23416666664637385A413333333335AF23419A9999B93E385A413333333336AF23410000004052385A41333333331CAF2341000000E06D385A41CDCCCCCCCBAE23413333337399385A4166666666BDAE2341CDCCCC4CB6385A41333333339BAE2341CDCCCC8CBE385A419A99999977AE2341333333D3BE385A419A99999977AE2341333333D3BE385A41	01010000206A080000DBFBE7D4D1B123410000001053385A41	950180802	H	Noble Terre	9501808	95018	95	11	1
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	01010000206A080000B5C0C64984BA23419A9999295E385A41	950180901	H	Belle Vue	9501809	95018	95	11	1
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	01010000206A0800001133B28B17B7234133333383CA375A41	950180902	H	République	9501809	95018	95	11	1
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	01060000206A0800000100000001030000000100000029000000CDCCCCCC14B32341333333534A375A41666666665DB32341CDCCCCAC4C375A4166666666A3B32341666666665A375A419A999999C8B32341666666065F375A419A99999922B42341CDCCCC4C5F375A410000000038B42341333333F350375A41CDCCCCCC46B42341333333934D375A41CDCCCCCCAFB42341666666E644375A4133333333A1B523419A99999957375A4133333333AEB623419A9999F96B375A419A999999EEB723419A9999B984375A419A9999996EB82341333333F38D375A419A99999936BA23419A9999F9B0375A41CDCCCCCCACBA23419A9999B9B9375A4133333333FDBA234166666686A6375A41CDCCCCCC3DBB2341000000208C375A41CDCCCCCCA4BB23410000008067375A416666666620BC2341000000A06E375A419A9999995DBC2341CDCCCCAC5C375A410000000074BC2341666666A658375A4166666666C6BC2341666666663D375A4100000000DFBC2341CDCCCCEC38375A41666666661FBD2341333333B325375A419A99999970BC2341666666C61D375A419A99999968BB23413333339314375A41CDCCCCCC7FBA2341000000A00A375A419A99999939BA23416666664606375A410000000021B9234100000040F0365A41CDCCCCCC3EB82341000000C0DB365A413333333356B72341000000A0CB365A416666666615B7234166666666C6365A41333333334AB6234166666666BA365A4133333333CCB5234100000080B1365A41000000002AB523419A999939A4365A41CDCCCCCCA8B42341CDCCCCCCBA365A416666666626B52341CDCCCC0CC5365A4100000000BBB423419A999919E0365A41CDCCCCCC0BB42341CDCCCC4C09375A41666666667BB32341000000202E375A41CDCCCCCC14B32341333333534A375A41CDCCCCCC14B32341333333534A375A41	01010000206A080000EA6D163C2CB823416666668633375A41	950180903	H	Le Tronc	9501809	95018	95	11	1
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	01060000206A0800000100000001030000000100000025000000CDCCCCCC5CBF23413333335309385A41CDCCCCCCCEC02341CDCCCC2C13385A419A99999911C123410000002013385A41666666661FC223419A9999B919385A419A99999958C22341CDCCCCAC1B385A4166666666EEC32341000000A026385A41CDCCCCCCA6C42341333333F32B385A413333333313C52341CDCCCCEC2F385A41000000001EC523413333339327385A419A9999994DC523413333335328385A419A999999A1C523419A99995927385A4133333333F1C523413333339323385A41CDCCCCCC14C62341000000A020385A410000000053C62341CDCCCCAC0A385A41666666669DC72341333333D399375A41CDCCCCCCC4C723419A9999798B375A419A999999F5C623416666662681375A41CDCCCCCC53C523416666668678375A4133333333E5C32341CDCCCC6C6F375A41CDCCCCCCCDC323419A99991972375A4166666666AFC323419A9999B985375A413333333331C32341666666E682375A416666666636C22341CDCCCCEC7B375A4166666666D0C12341CDCCCCAC78375A41CDCCCCCC1CC12341000000C071375A4100000000C9C02341333333736D375A41333333339DC023416666666690375A419A99999958C02341666666E693375A41666666662FC023419A99997997375A4166666666CFBF2341666666669A375A419A99999922C0234133333373AD375A41000000005DC0234100000000B8375A419A99999940C023419A999999C5375A419A9999990AC02341333333D3DA375A4133333333A4BF234133333353F8375A41CDCCCCCC5CBF23413333335309385A41CDCCCCCC5CBF23413333335309385A41	01010000206A080000D8CC6DCB91C3234166666666D0375A41	950181001	H	Cité Jardin d'Orgemont	9501810	95018	95	11	1
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	01060000206A080000010000000103000000010000001E0000009A99999999BF2341333333F30A385A41333333339FBF23416666662618385A4100000000B5BF2341666666C636385A419A999999C8BF2341CDCCCC6C44385A410000000024C023419A9999D955385A419A99999939C02341333333D358385A413333333366C023419A99999958385A41CDCCCCCC7DC023413333331363385A4100000000BCC023416666662672385A4133333333F2C02341333333D371385A41CDCCCCCC6FC22341CDCCCCAC7C385A416666666695C22341000000006B385A41CDCCCCCC85C523410000006075385A4100000000ABC523410000008074385A419A999999A0C52341CDCCCC0C68385A419A99999999C52341000000604C385A41CDCCCCCC14C62341000000A020385A4133333333F1C523413333339323385A419A999999A1C523419A99995927385A419A9999994DC523413333335328385A41000000001EC523413333339327385A413333333313C52341CDCCCCEC2F385A41CDCCCCCCA6C42341333333F32B385A4166666666EEC32341000000A026385A419A99999958C22341CDCCCCAC1B385A41666666661FC223419A9999B919385A419A99999911C123410000002013385A41CDCCCCCCCEC02341CDCCCC2C13385A419A99999999BF2341333333F30A385A419A99999999BF2341333333F30A385A41	01010000206A080000C87CF695BCC223419A99994943385A41	950181002	H	Joliot-Curie	9501810	95018	95	11	0
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	01060000206A0800000100000001030000000100000027000000CDCCCCCCACBA23419A9999B9B9375A413333333392BC2341666666C6DE375A4100000000FEBD234166666666F9375A419A999999A8BE2341666666C600385A41666666669CBE2341CDCCCCEC03385A41CDCCCCCC5CBF23413333335309385A4133333333A4BF234133333353F8375A419A9999990AC02341333333D3DA375A419A99999940C023419A999999C5375A41000000005DC0234100000000B8375A419A99999922C0234133333373AD375A4166666666CFBF2341666666669A375A41666666662FC023419A99997997375A419A99999958C02341666666E693375A41333333339DC023416666666690375A4100000000C9C02341333333736D375A41CDCCCCCC1CC12341000000C071375A4166666666D0C12341CDCCCCAC78375A416666666636C22341CDCCCCEC7B375A413333333331C32341666666E682375A4166666666AFC323419A9999B985375A41CDCCCCCCCDC323419A99991972375A4133333333E5C32341CDCCCC6C6F375A419A999999A8C32341000000206E375A41666666669EC12341000000A05D375A419A99999930C02341333333134A375A4166666666F0BD2341666666E62D375A419A99999914BD2341CDCCCCAC24375A41666666661FBD2341333333B325375A4100000000DFBC2341CDCCCCEC38375A4166666666C6BC2341666666663D375A410000000074BC2341666666A658375A419A9999995DBC2341CDCCCCAC5C375A416666666620BC2341000000A06E375A41CDCCCCCCA4BB23410000008067375A41CDCCCCCC3DBB2341000000208C375A4133333333FDBA234166666686A6375A41CDCCCCCCACBA23419A9999B9B9375A41CDCCCCCCACBA23419A9999B9B9375A41	01010000206A0800002BBAE8F0AEBD23413433338396375A41	950181003	H	Vaucelle	9501810	95018	95	11	0
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	01060000206A080000010000000103000000010000003400000000000000510624419A9999F9183B5A419A999999A8062441CDCCCC6C323B5A419A999999C6062441333333F33C3B5A4100000000FD062441000000A04C3B5A41CDCCCCCC960724419A999939733B5A419A999999B207244166666626713B5A41CDCCCCCC500824419A9999598E3B5A41CDCCCCCC6F082441000000808B3B5A4100000000F708244166666666A43B5A41333333334A092441000000609C3B5A41CDCCCCCCC509244100000060B83B5A41333333334D0A2441CDCCCCCCD83B5A4100000000AA0A244133333373D43B5A41CDCCCCCC9D0A24419A999919D13B5A4166666666C90A2441CDCCCC4CCF3B5A419A999999E80A24419A999939CA3B5A4100000000110B244133333313BE3B5A4166666666AE0B2441333333B3B83B5A4133333333E90B244100000080B13B5A419A999999560D2441CDCCCCECD83B5A419A9999991C0E244133333333EC3B5A4166666666020E24419A999979CE3B5A4166666666510F2441666666C6C93B5A41CDCCCCCC730F2441CDCCCC0CD73B5A41CDCCCCCC900F24419A999919D83B5A419A999999E00F244133333353BA3B5A4166666666680F2441CDCCCC8C8C3B5A4166666666DC0F2441000000208B3B5A4100000000E70F2441000000E0893B5A419A999999DD0F244133333333603B5A419A999999000F24419A9999D9633B5A4166666666D50E2441333333F3533B5A41CDCCCCCCB90E244166666606563B5A41333333339C0D244133333313613B5A419A999999050D244100000080673B5A419A9999993D0C24419A999919743B5A4133333333200C244166666606743B5A41CDCCCCCCDF0B2441333333537C3B5A4166666666B00A244100000060583B5A41CDCCCCCC260A24419A9999B96A3B5A419A999999AD092441333333735C3B5A41CDCCCCCCE608244100000020433B5A4133333333960724419A999939193B5A41CDCCCCCCF9072441666666861A3B5A4133333333FA0724419A9999D9183B5A419A9999996E0724419A999979163B5A4100000000F4062441CDCCCC8C153B5A419A999999B00624419A9999790D3B5A41333333339F062441333333530D3B5A4100000000AB0624419A999939183B5A4100000000510624419A9999F9183B5A4100000000510624419A9999F9183B5A41	01010000206A080000EE77DAE5EB0B2441333333337D3B5A41	950190101	H	Cottage	9501901	95019	95	11	0
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	01060000206A080000010000000103000000010000002A000000333333334D0A2441CDCCCCCCD83B5A41CDCCCCCC660A2441666666C6DE3B5A41333333330B0B2441000000C00E3C5A41CDCCCCCC5B0B2441666666660B3C5A419A999999770B2441666666A6133C5A419A999999080C24419A9999F90E3C5A4133333333810C2441666666660C3C5A41CDCCCCCC8D0C24419A999999123C5A419A9999999C0D244166666626113C5A41CDCCCCCCC00D24419A999999343C5A41CDCCCCCCBF0D2441666666C6373C5A4166666666A20E244133333393393C5A41CDCCCCCC560E2441333333B35C3C5A41CDCCCCCC050E244166666606883C5A4100000000230F2441000000008B3C5A41333333332B0F24419A9999D9973C5A419A999999760F24419A9999D9903C5A41000000006B112441000000E0553C5A410000000069122441CDCCCCEC243C5A419A999999D3112441CDCCCC6C1F3C5A4100000000101224419A9999D9083C5A41CDCCCCCCF6112441CDCCCC4C073C5A419A9999997B10244100000080FC3B5A410000000066102441CDCCCC4CF83B5A419A9999994C102441CDCCCC2CF93B5A4166666666920F244166666606E33B5A41666666667A0F2441CDCCCC8CDF3B5A41CDCCCCCC900F24419A999919D83B5A41CDCCCCCC730F2441CDCCCC0CD73B5A4166666666510F2441666666C6C93B5A4166666666020E24419A999979CE3B5A419A9999991C0E244133333333EC3B5A419A999999560D2441CDCCCCECD83B5A4133333333E90B244100000080B13B5A4166666666AE0B2441333333B3B83B5A4100000000110B244133333313BE3B5A419A999999E80A24419A999939CA3B5A4166666666C90A2441CDCCCC4CCF3B5A41CDCCCCCC9D0A24419A999919D13B5A4100000000AA0A244133333373D43B5A41333333334D0A2441CDCCCCCCD83B5A41333333334D0A2441CDCCCCCCD83B5A41	01010000206A0800008C1E8124E60F2441CDCCCC2C223C5A41	950190102	H	Gare	9501901	95019	95	11	0
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	01060000206A0800000100000001030000000100000028000000666666667A0F2441CDCCCC8CDF3B5A4166666666920F244166666606E33B5A419A9999994C102441CDCCCC2CF93B5A410000000066102441CDCCCC4CF83B5A419A9999997B10244100000080FC3B5A41CDCCCCCCF6112441CDCCCC4C073C5A4100000000101224419A9999D9083C5A419A9999992E12244166666666FD3B5A4100000000A0122441333333D3FF3B5A4166666666F11224419A9999D9ED3B5A413333333376132441000000E0A03B5A419A999999B4132441333333B3833B5A419A9999992914244100000040653B5A419A9999993E142441666666865E3B5A4166666666E1142441000000C0363B5A41CDCCCCCC09152441CDCCCC2C263B5A410000000044152441000000E0253B5A410000000093162441CDCCCCECF73A5A41666666662817244100000040E03A5A41333333336917244100000000CC3A5A4166666666611724419A9999D9C83A5A4133333333D1152441333333B3B73A5A419A999999BB1524419A9999F9C53A5A41333333339A1524419A999979C83A5A4100000000A4142441000000A0E53A5A41666666663B142441CDCCCC8CD83A5A41666666663313244133333393F13A5A41333333331214244133333373113B5A41333333336813244166666606273B5A416666666650132441000000C02C3B5A4166666666D4132441000000003B3B5A41333333333A12244166666666773B5A4100000000C1112441CDCCCC8C883B5A41333333330D112441CDCCCC4CA33B5A41CDCCCCCCD0102441CDCCCCECAC3B5A419A99999973102441CDCCCCCCB93B5A4166666666B90F244166666626D63B5A41CDCCCCCC900F24419A999919D83B5A41666666667A0F2441CDCCCC8CDF3B5A41666666667A0F2441CDCCCC8CDF3B5A41	01010000206A080000CCCE49B186132441000000B0603B5A41	950190103	H	Stade	9501901	95019	95	11	0
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	01060000206A080000010000000103000000010000003C0000009A9999991C0F244100000080673A5A41CDCCCCCCA70F2441333333F38E3A5A4166666666910F2441CDCCCC0C903A5A4166666666A00F244166666626953A5A4166666666F80F244133333393903A5A41CDCCCCCC2C102441666666669E3A5A41CDCCCCCCE50F244166666666A33A5A419A999999970F24419A9999F9A63A5A419A9999999B0F2441666666A6C13A5A4166666666AB0F2441333333D3CB3A5A419A999999D10F2441CDCCCC2CD93A5A419A9999991910244166666666EE3A5A41333333334E102441000000C0F83A5A41CDCCCCCC6110244100000040F93A5A416666666651112441CDCCCCECE33A5A41CDCCCCCC57112441CDCCCC2CE03A5A4100000000791124419A999959E03A5A41CDCCCCCC11122441333333D3D03A5A41666666669512244166666606E53A5A4166666666AB13244133333393CA3A5A41CDCCCCCCCA132441333333F3C73A5A4166666666DD132441CDCCCCCCCC3A5A4100000000A4142441000000A0E53A5A41333333339A1524419A999979C83A5A419A999999BB1524419A9999F9C53A5A4133333333D1152441333333B3B73A5A4166666666611724419A9999D9C83A5A41000000007917244100000060C83A5A419A9999991318244166666626993A5A413333333321182441333333B38C3A5A4100000000BB17244133333333823A5A41666666664E172441666666C6723A5A41000000000C172441CDCCCC2C6F3A5A416666666648162441CDCCCCAC613A5A419A9999997014244133333333403A5A41000000000C14244133333313383A5A4100000000071424419A999999203A5A419A999999C7132441666666260C3A5A4100000000C91324419A999959043A5A41CDCCCCCC951324419A9999F9013A5A419A99999972132441CDCCCCAC033A5A410000000044132441CDCCCC8C0B3A5A41CDCCCCCC02132441CDCCCC2C0F3A5A4100000000E8122441666666E6123A5A4166666666C4122441666666C61C3A5A416666666680122441CDCCCCCC243A5A41CDCCCCCC60122441666666462C3A5A4166666666B4112441CDCCCC0C323A5A4133333333C11124419A999979373A5A419A999999AB112441666666A63B3A5A4166666666AC11244100000020413A5A4100000000DD102441000000004D3A5A410000000074102441CDCCCCCC533A5A41000000000A10244166666626593A5A419A999999FF0F24419A999979553A5A4133333333C90F24419A999939553A5A41CDCCCCCCB20F2441333333135A3A5A4166666666C00F2441CDCCCCCC5D3A5A419A9999991C0F244100000080673A5A419A9999991C0F244100000080673A5A41	01010000206A080000FB6117F287132441343333A37E3A5A41	950190104	H	Vieux Pays	9501901	95019	95	11	1
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	01060000206A0800000100000001030000000100000033000000CDCCCCCC6E062441CDCCCCCCDF3A5A41333333339F062441333333530D3B5A419A999999B00624419A9999790D3B5A4100000000F4062441CDCCCC8C153B5A419A9999996E0724419A999979163B5A4133333333FA0724419A9999D9183B5A41CDCCCCCCF9072441666666861A3B5A4133333333960724419A999939193B5A41CDCCCCCCE608244100000020433B5A419A999999AD092441333333735C3B5A41CDCCCCCC260A24419A9999B96A3B5A4166666666B00A244100000060583B5A41CDCCCCCCDF0B2441333333537C3B5A4133333333200C244166666606743B5A419A9999993D0C24419A999919743B5A419A999999050D244100000080673B5A41333333339C0D244133333313613B5A41CDCCCCCC380E2441666666465B3B5A41000000007F0E2441CDCCCC8C3E3B5A4166666666140F2441333333133E3B5A4100000000810F2441CDCCCC0C3D3B5A4166666666A8102441CDCCCC2C373B5A41CDCCCCCCBE10244100000060333B5A4133333333C20F244133333313073B5A419A9999994A10244133333333FB3A5A41333333334E102441000000C0F83A5A419A9999991910244166666666EE3A5A419A999999D10F2441CDCCCC2CD93A5A4166666666AB0F2441333333D3CB3A5A419A9999999B0F2441666666A6C13A5A419A999999970F24419A9999F9A63A5A41CDCCCCCCE50F244166666666A33A5A41CDCCCCCC2C102441666666669E3A5A4166666666F80F244133333393903A5A419A9999998B0F244100000060963A5A41666666663D0F2441CDCCCC0C9F3A5A4133333333E70E24419A9999B9A53A5A4133333333880E2441000000E0AA3A5A41666666664E0E2441000000A0AC3A5A41CDCCCCCC210D2441CDCCCC4CAF3A5A4166666666A60C24419A999979AB3A5A41CDCCCCCC5D0B244133333353B73A5A41CDCCCCCC530A2441000000E0D03A5A4100000000FC0924419A9999F9D13A5A4166666666E509244166666686DA3A5A4133333333BD09244133333333E03A5A41CDCCCCCC2D08244100000060E33A5A419A9999990208244100000040E83A5A4133333333DB072441333333D3D13A5A41CDCCCCCC6E062441CDCCCCCCDF3A5A41CDCCCCCC6E062441CDCCCCCCDF3A5A41	01010000206A0800001917E56A4C0B244133333323013B5A41	950190105	H	Condos	9501901	95019	95	11	1
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	01060000206A0800000100000001030000000100000026000000CDCCCCCC380E2441666666465B3B5A41CDCCCCCCB90E244166666606563B5A4166666666D50E2441333333F3533B5A419A999999000F24419A9999D9633B5A419A999999DD0F244133333333603B5A4100000000E70F2441000000E0893B5A4166666666DC0F2441000000208B3B5A4166666666680F2441CDCCCC8C8C3B5A419A999999E00F244133333353BA3B5A41CDCCCCCC900F24419A999919D83B5A4166666666B90F244166666626D63B5A419A99999973102441CDCCCCCCB93B5A41CDCCCCCCD0102441CDCCCCECAC3B5A41333333330D112441CDCCCC4CA33B5A4100000000C1112441CDCCCC8C883B5A41333333333A12244166666666773B5A4166666666D4132441000000003B3B5A416666666650132441000000C02C3B5A41333333336813244166666606273B5A41333333331214244133333373113B5A41666666663313244133333393F13A5A41666666663B142441CDCCCC8CD83A5A4166666666DD132441CDCCCCCCCC3A5A41CDCCCCCCCA132441333333F3C73A5A4166666666AB13244133333393CA3A5A41666666669512244166666606E53A5A41CDCCCCCC11122441333333D3D03A5A4100000000791124419A999959E03A5A41CDCCCCCC57112441CDCCCC2CE03A5A416666666651112441CDCCCCECE33A5A4133333333C20F244133333313073B5A41CDCCCCCCBE10244100000060333B5A4166666666A8102441CDCCCC2C373B5A4100000000810F2441CDCCCC0C3D3B5A4166666666140F2441333333133E3B5A41000000007F0E2441CDCCCC8C3E3B5A41CDCCCCCC380E2441666666465B3B5A41CDCCCCCC380E2441666666465B3B5A41	01010000206A0800009006FC3AC9102441CCCCCCAC503B5A41	950190106	H	Beauséjour	9501901	95019	95	11	0
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	01010000206A080000F0185C950C5D23419A9999E9C14F5A41	950230000	Z	Arronville	9502300	95023	95	11	16
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	01010000206A0800007AFE44512BAC2241CCCCCC8C65475A41	950240000	Z	Arthies	9502400	95024	95	11	8
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	01010000206A080000AADB47B9E30A244166666666C54B5A41	950260000	Z	Asnières-sur-Oise	9502600	95026	95	11	14
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	01010000206A0800007939124425EB23410000008061435A41	950280000	Z	Attainville	9502800	95028	95	11	7
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	01010000206A080000DAC64F8B168823419A999959E9445A41	950390101	H	Cordeville-Le Montcel-Clos du Château	9503901	95039	95	11	2
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	01010000206A080000DDF0E348027F2341CDCCCCEC22465A41	950390102	H	Les Berthelées-Les Coteaux-Les Perruchets	9503901	95039	95	11	5
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	01010000206A080000C00DC73A83732341343333F366455A41	950390103	H	Valhermeil Chaponval	9503901	95039	95	11	5
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	01010000206A080000FAEA2459FBD52241CCCCCC3C4C475A41	950400000	Z	Avernes	9504000	95040	95	11	17
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	01010000206A08000067E062F80ED023410000009043435A41	950420000	Z	Baillet-en-France	9504200	95042	95	11	8
01060000206A08000001000000010300000001000000E80000006666666603AC22419A9999D9774A5A41CDCCCCCC12AC224100000060944A5A413333333324AC2241CDCCCC4CA34A5A41000000003DAC2241333333D3B04A5A41CDCCCCCC68AC2241000000C0BE4A5A419A9999996FAC224166666626BE4A5A4100000000F2AC22419A9999D9E34A5A4166666666FAAC224166666606E94A5A410000000020AD224100000060F94A5A4133333333ABAD2241000000E00D4B5A410000000014AE2241666666861D4B5A41333333331FAE2241CDCCCCCC1F4B5A419A9999997DAE2241333333F3344B5A41CDCCCCCC1CAF2241CDCCCC8C4C4B5A419A9999996BAF2241333333535B4B5A419A99999980AF2241000000405F4B5A4100000000BFAF224100000000834B5A410000000027B0224133333353994B5A41CDCCCCCC31B02241000000A09B4B5A419A9999995CB0224100000020994B5A410000000005B12241CDCCCC4C8F4B5A410000000037B1224133333373894B5A419A99999968B12241666666A6834B5A4166666666AFB12241000000C0734B5A4166666666FAB122419A9999196E4B5A416666666611B22241CDCCCC4C6E4B5A41CDCCCCCCABB2224133333353614B5A4166666666B5B222419A999979604B5A4166666666E9B22241000000E0694B5A41666666663DB3224133333313794B5A4100000000BAB22241CDCCCC8C884B5A4133333333B4B222419A999939894B5A4133333333C2B22241000000208B4B5A4133333333C3B22241666666468B4B5A416666666626B322419A9999D9984B5A41CDCCCCCC71B3224133333333A34B5A41666666665BB3224133333353A74B5A413333333344B322419A999999AB4B5A41666666665CB32241CDCCCC6CAF4B5A419A999999FFB2224133333373BC4B5A41333333330AB32241333333D3BD4B5A419A99999944B322419A999939C54B5A41000000006BB3224100000020CA4B5A410000000092B3224133333313CF4B5A4133333333B7B32241333333D3D34B5A4166666666EEB32241CDCCCCCCDA4B5A416666666606B42241666666E6DD4B5A4100000000D9B3224133333373E54B5A41CDCCCCCCD2B3224100000080E64B5A413333333367B322419A999919F94B5A419A9999994BB3224166666646FD4B5A41CDCCCCCCC6B22241CDCCCC0C094C5A4100000000B5B222419A9999990A4C5A419A99999974B22241666666E6104C5A41CDCCCCCC41B222419A9999F9154C5A413333333313B22241CDCCCC0C1C4C5A41333333330BB222419A9999791D4C5A4133333333E8B12241666666C6234C5A41CDCCCCCCDEB12241333333F3244C5A4166666666BFB12241666666C6284C5A419A999999C7B12241CDCCCCAC294C5A410000000021B22241333333D3334C5A41000000002DB2224133333333354C5A419A99999958B22241000000A0394C5A4166666666DCB22241333333F3464C5A419A999999E4B22241CDCCCCCC474C5A419A99999931B32241CDCCCCCC3D4C5A416666666603B4224100000000554C5A413333333330B52241333333136E4C5A41CDCCCCCC29B6224133333313894C5A41CDCCCCCC8FB62241CDCCCC0C7D4C5A41CDCCCCCCDAB6224133333333744C5A413333333349B72241000000806C4C5A419A99999991B7224133333353654C5A4166666666BBB72241666666866D4C5A41000000002FB82241CDCCCC4C8A4C5A419A999999DAB82241333333137D4C5A410000000029B92241333333F3764C5A41CDCCCCCC9CB92241CDCCCC0C6E4C5A419A999999C8B92241666666A66A4C5A41CDCCCCCC66BA2241333333535E4C5A41CDCCCCCCD4BA22419A9999D9554C5A41333333337ABB224133333313494C5A4133333333ECBB22419A9999D9624C5A41CDCCCCCC0CBC2241333333336A4C5A4166666666A9BC2241000000E08D4C5A41000000001BBD22419A9999F9A74C5A413333333359BD224100000040B64C5A419A999999C5BD224133333313D04C5A41CDCCCCCC83C1224166666686834C5A419A999999EFC1224133333313904C5A41CDCCCCCC4EC222419A9999D9A84C5A416666666672C22241333333B3B04C5A419A999999DEC222419A999979A74C5A416666666609C42241CDCCCCAC8E4C5A413333333379C42241333333B3854C5A413333333301C52241333333937A4C5A41CDCCCCCCA8C4224100000020664C5A410000000054C422419A9999F94E4C5A4100000000DDC32241CDCCCC2C524C5A4100000000BFC322419A9999F9524C5A419A999999C5C32241CDCCCC8C4D4C5A4166666666E2C3224133333353364C5A4133333333EDC322419A9999B92D4C5A41CDCCCCCCD0C42241CDCCCC8C204C5A413333333316C522419A999979314C5A410000000008C62241333333931D4C5A41CDCCCCCC27C62241333333F31A4C5A41000000000DC62241CDCCCCAC164C5A4166666666C3C522419A9999D90A4C5A41CDCCCCCCEBC5224166666606074C5A413333333317C62241666666E6024C5A4100000000D4C52241CDCCCC4CF54B5A410000000079C52241000000E0E24B5A413333333375C5224166666626E24B5A4166666666A9C522419A999959DE4B5A41CDCCCCCCABC5224166666626DE4B5A4100000000EDC522419A999959D94B5A410000000011C62241CDCCCCACD64B5A410000000014C622419A999979D64B5A416666666613C6224133333353D64B5A419A9999995DC52241CDCCCC0CB34B5A4166666666C3C4224133333313954B5A4100000000B6C422419A999979924B5A41CDCCCCCC15C422419A9999196F4B5A4166666666FAC322419A999919694B5A419A99999923C42241333333D3654B5A410000000041C42241CDCCCC0C634B5A419A99999972C42241CDCCCCCC5E4B5A41666666668AC42241666666C65C4B5A4133333333BCC422419A999979584B5A4166666666D6C42241CDCCCC2C564B5A419A99999939C52241CDCCCC2C4E4B5A416666666658C52241000000E04B4B5A419A99999962C52241000000204B4B5A41CDCCCCCC6BC52241CDCCCCCC464B5A41333333335DC522419A999979434B5A41CDCCCCCCFEC42241CDCCCCEC304B5A41CDCCCCCCFCC4224133333313304B5A4100000000E9C42241333333532C4B5A41666666667CC422419A999999154B5A4100000000CEC32241CDCCCC2C1F4B5A419A99999975C3224166666606244B5A41CDCCCCCC1EC32241CDCCCC2C144B5A41333333334EC2224166666626EE4A5A41CDCCCCCCE9C122419A9999D9DB4A5A413333333319C222419A9999F9D64A5A419A99999926C2224133333353D14A5A410000000046C2224133333353C44A5A41CDCCCCCC65C222419A999919B84A5A41CDCCCCCC45C22241333333D3B54A5A419A9999994EC22241CDCCCCACB34A5A413333333368C222419A999979AD4A5A41666666668AC222419A999939A54A5A41000000003BC12241CDCCCC4C724A5A4100000000BCC12241000000405C4A5A41CDCCCCCC21C22241666666E64A4A5A419A99999968C22241333333D33E4A5A410000000058C222419A9999D93B4A5A413333333306C22241000000402C4A5A419A999999FAC122419A9999D9294A5A419A999999F0C12241000000C0274A5A4133333333C7C122419A9999F91D4A5A41CDCCCCCC94C122419A999979114A5A41CDCCCCCC89C12241000000600E4A5A41CDCCCCCC78C12241333333130B4A5A416666666662C1224133333393074A5A410000000055C122419A999919054A5A41CDCCCCCC1DC122419A999999FD495A41CDCCCCCC18C1224100000000FD495A4133333333FEC02241666666C6F9495A41CDCCCCCCE5C02241666666C6F6495A41CDCCCCCC59C0224100000020E7495A413333333313C022419A999919DF495A41CDCCCCCC99BF2241CDCCCC2CD1495A419A99999978BF2241CDCCCCACCD495A413333333355BF2241CDCCCCACCA495A416666666636BF224100000080C8495A41CDCCCCCC0FBF224166666686C6495A4100000000F8BE22419A999979C5495A419A999999C3BE224166666606C4495A41CDCCCCCC92BE2241666666A6C3495A41000000004EBE224100000080C3495A410000000025BE224133333393C3495A419A9999991BBE22419A999999C3495A41CDCCCCCCF2BD224133333373C3495A41CDCCCCCC02BE22419A999999C1495A41000000000BBE2241CDCCCC4CC0495A41CDCCCCCC35BE2241333333D3BB495A419A99999949BE2241000000C0B9495A41333333335ABE224166666686B7495A413333333364BE2241333333B3B5495A419A9999996ABE2241666666E6B4495A419A99999971BE2241CDCCCC0CB3495A413333333379BE224100000080B1495A419A9999998DBE224100000020AC495A4100000000B7BE22419A9999D99F495A413333333301BE2241000000408C495A413333333314BD2241333333B372495A4133333333DABB22413333331350495A41CDCCCCCC0EBA2241333333931D495A4133333333A8B922419A9999F911495A419A9999997AB92241333333D30C495A413333333387B922419A9999990B495A419A99999991B92241000000600A495A41333333339FB922410000004009495A416666666684B92241000000A005495A4166666666F8B82241CDCCCCCCF1485A41CDCCCCCC07B822410000002008495A41CDCCCCCCC4B72241000000600E495A413333333338B722419A9999791B495A413333333391B622419A9999F92A495A41CDCCCCCC5DB52241CDCCCC8C47495A413333333344B522413333333341495A4133333333F3B42241CDCCCCCC2F495A41CDCCCCCC0BB322419A99995952495A41000000002BB122410000000074495A419A999999EEB022419A99993978495A41CDCCCCCCB8B02241CDCCCC8C6F495A41666666668EB022419A9999F964495A41CDCCCCCC30B02241000000206F495A41CDCCCCCC4CAE22419A999939A4495A41CDCCCCCC45AE22419A999919A5495A416666666635AE2241CDCCCC0CA1495A41CDCCCCCC2DAE2241666666E69E495A419A999999F7AD2241CDCCCC8C92495A413333333363AC2241CDCCCCCCBA495A4166666666AFAC22419A999939C7495A41666666664FAD2241CDCCCC4CE1495A410000000053AE2241333333130C4A5A416666666612AC2241333333933E4A5A416666666603AC22419A9999D9774A5A41	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	01010000206A08000066B374F471B722419A9999D9DF4A5A41	950460000	Z	Banthelu	9504600	95046	95	11	8
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	01060000206A080000010000000103000000010000001A000000CDCCCCCCAC8D234166666606423F5A41CDCCCCCC1D8F23419A9999D93C3F5A41CDCCCCCCAB8F2341333333B3393F5A419A999999BE902341333333B3313F5A41666666666A922341CDCCCC0C263F5A41CDCCCCCC86932341333333B31B3F5A419A999999BB952341CDCCCC6C063F5A4133333333E5962341333333F3FF3E5A41CDCCCCCCAC96234133333333EC3E5A41333333335296234100000020D13E5A4166666666F59523419A999979B03E5A416666666696952341000000A0913E5A41666666663F952341000000E0953E5A41CDCCCCCCBB942341666666A69D3E5A41CDCCCCCC30942341666666A6A43E5A419A99999950922341CDCCCCECBF3E5A4133333333F792234166666646E53E5A41333333330E9323419A999979E83E5A41CDCCCCCC91912341666666A6DC3E5A419A9999992790234100000080D23E5A416666666652902341333333B3D93E5A41CDCCCCCCD58E2341CDCCCCAC053F5A41CDCCCCCCF78D234166666606203F5A41CDCCCCCCC08D2341CDCCCCAC363F5A41CDCCCCCCAC8D234166666606423F5A41CDCCCCCCAC8D234166666606423F5A41	01010000206A080000CCAE43F133932341666666B6EA3E5A41	950510103	H	La Folie-Le Château	9505101	95051	95	11	0
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	01060000206A08000001000000010300000001000000290000009A9999998F8723419A999979D43E5A413333333316882341CDCCCC0CFB3E5A41CDCCCCCC03892341CDCCCC4CEF3E5A4100000000AC89234166666686E63E5A419A999999CD8B234100000000C83E5A4166666666188C234133333393C43E5A4166666666628C23419A999959C53E5A41CDCCCCCCDA8D2341CDCCCC8CD03E5A41666666663D8E234100000080D23E5A419A9999992790234100000080D23E5A41CDCCCCCC91912341666666A6DC3E5A41333333330E9323419A999979E83E5A4133333333F792234166666646E53E5A419A99999950922341CDCCCCECBF3E5A413333333319932341CDCCCC8CB43E5A41666666660592234133333353633E5A413333333308912341000000A0743E5A410000000033912341333333537F3E5A416666666643902341333333F38B3E5A4100000000D68F23419A999999733E5A4133333333D58F234166666606713E5A41CDCCCCCCAE9023419A999999613E5A419A9999992C90234100000020443E5A4166666666868F2341000000404F3E5A41CDCCCCCC2D8F23419A9999D9783E5A419A9999991F8F2341000000A06A3E5A4100000000EF8E23419A9999F9583E5A419A9999993A8E2341000000402E3E5A4133333333168E2341CDCCCCEC243E5A4133333333AE8C2341333333333B3E5A41CDCCCCCCC18C2341333333333F3E5A41333333335F8D234166666686593E5A4133333333658C234133333353693E5A4166666666A58B234133333333763E5A4100000000B78B23419A9999D9803E5A4133333333F48B23419A9999F98A3E5A419A999999168C2341CDCCCC2C933E5A419A9999994189234100000000BB3E5A41666666665589234100000040C03E5A419A9999998F8723419A999979D43E5A419A9999998F8723419A999979D43E5A41	01010000206A0800007BF114F3578F234166666626913E5A41	950510104	H	La Chasse	9505101	95051	95	11	1
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	01060000206A080000010000000103000000010000003400000033333333FC8923419A999939673E5A4133333333348A234166666646753E5A41CDCCCCCC908A2341CDCCCC8C8A3E5A4133333333A68A234133333373923E5A419A999999E28A2341CDCCCC0C8E3E5A4100000000B78B23419A9999D9803E5A4166666666A58B234133333333763E5A4133333333658C234133333353693E5A41333333335F8D234166666686593E5A41CDCCCCCCC18C2341333333333F3E5A4133333333AE8C2341333333333B3E5A41000000009B8D2341CDCCCCAC2C3E5A419A9999994F8F234133333373113E5A41666666661C902341666666E6033E5A419A9999993D91234133333313F23D5A4133333333F691234166666626E83D5A41000000009B922341CDCCCCACDD3D5A4133333333D8922341CDCCCCECD83D5A41CDCCCCCC8F932341CDCCCC6CCD3D5A413333333358942341CDCCCC8CBF3D5A41CDCCCCCC8E95234133333313AB3D5A4166666666FE96234100000060923D5A419A9999997D982341CDCCCC0C793D5A4100000000E598234100000020733D5A413333333341992341CDCCCC2C6C3D5A419A999999099C2341CDCCCC4C403D5A4100000000BD9B2341666666862F3D5A4133333333689B2341000000A0203D5A41CDCCCCCC049B2341CDCCCC4C0D3D5A4133333333449A2341CDCCCCAC1C3D5A419A999999909923419A9999B9283D5A4100000000E7982341CDCCCC6C353D5A41CDCCCCCC5F982341666666863E3D5A4166666666B9952341CDCCCC0C703D5A410000000025952341CDCCCC6C7A3D5A4133333333BB932341666666A6943D5A41000000000E932341666666E6A13D5A4100000000DA912341666666C6B63D5A41666666660F912341666666A6C23D5A4166666666E08F23419A999919D23D5A4133333333CC8F2341000000C0D13D5A4133333333CE8B234100000000083E5A4166666666CB8B2341CDCCCCAC0A3E5A4166666666408C2341CDCCCCEC203E5A419A999999B68B2341666666862C3E5A419A999999268B23419A9999793B3E5A4100000000C38A2341CDCCCCCC443E5A41CDCCCCCC998A2341CDCCCC8C4B3E5A419A9999998A8A2341666666A6513E5A4133333333A48A2341CDCCCC4C5B3E5A4133333333FC8923419A999939673E5A4133333333FC8923419A999939673E5A41	01010000206A080000182674F6C791234100000030CF3D5A41	950510101	H	La Chesnaie-La Bergère	9505101	95051	95	11	1
01060000206A080000010000000103000000010000005500000033333333168E2341CDCCCCEC243E5A419A9999993A8E2341000000402E3E5A419A9999998A8E234166666646413E5A41000000009B8E2341666666E6443E5A4100000000EF8E23419A9999F9583E5A41666666660C8F23419A9999B9613E5A419A9999991F8F2341000000A06A3E5A4100000000298F23419A9999D9723E5A41CDCCCCCC2C8F234133333353773E5A41CDCCCCCC2D8F23419A9999D9783E5A4166666666868F2341000000404F3E5A419A9999992C90234100000020443E5A416666666680902341CDCCCC0C573E5A41CDCCCCCCAE9023419A999999613E5A4133333333D58F234166666606713E5A41CDCCCCCCD28F23419A999919723E5A41CDCCCCCCD38F2341CDCCCC8C723E5A4100000000D68F23419A999999733E5A416666666643902341333333F38B3E5A410000000033912341333333537F3E5A413333333308912341000000A0743E5A41666666660592234133333353633E5A413333333319932341CDCCCC8CB43E5A41000000008293234133333393AE3E5A41000000009B93234166666626AD3E5A41CDCCCCCCB5932341000000A0AB3E5A4166666666E5932341CDCCCCECA83E5A4166666666F493234133333313A83E5A41CDCCCCCC30942341666666A6A43E5A41CDCCCCCCBB942341666666A69D3E5A41666666663F952341000000E0953E5A416666666696952341000000A0913E5A41000000008D952341CDCCCC2C8B3E5A41000000007C95234166666686793E5A41CDCCCCCC5A952341000000A05E3E5A41CDCCCCCCFD95234133333333543E5A419A999999A696234100000040493E5A4166666666B1962341CDCCCC8C483E5A41666666669096234133333333413E5A410000000001962341CDCCCCEC203E5A4133333333EF952341333333131D3E5A41CDCCCCCCE5952341CDCCCC8C1A3E5A4133333333B0952341666666C60E3E5A419A9999998F95234166666626073E5A41CDCCCCCC8795234166666646053E5A41333333336995234133333393FD3D5A419A9999994F9523419A999939F83D5A41CDCCCCCC1E952341000000A0EC3D5A4100000000DB942341666666C6DC3D5A4166666666C89423419A9999D9D83D5A41CDCCCCCCB994234100000020D53D5A41CDCCCCCC8A94234133333373CA3D5A41CDCCCCCC6B94234100000000C33D5A413333333358942341CDCCCC8CBF3D5A41CDCCCCCCD2932341333333D3C83D5A41CDCCCCCCB3932341333333F3CA3D5A41CDCCCCCC8F932341CDCCCC6CCD3D5A41CDCCCCCC27932341CDCCCC4CD43D5A41666666661C932341CDCCCC0CD53D5A4133333333D8922341CDCCCCECD83D5A419A9999999D9223419A999979DD3D5A41000000009B922341CDCCCCACDD3D5A416666666633922341CDCCCC8CE43D5A4133333333F691234166666626E83D5A41CDCCCCCCEF9123419A999979E83D5A4100000000D291234133333313EA3D5A4166666666759123419A999919EF3D5A41666666667391234133333333EF3D5A419A9999995A91234166666686F03D5A413333333353912341CDCCCCECF03D5A419A9999993D91234133333313F23D5A41333333332A91234133333333F33D5A419A9999991691234133333353F43D5A41000000000F912341666666C6F43D5A4166666666CC902341666666C6F83D5A41666666661C902341666666E6033E5A4133333333E08F2341CDCCCCEC073E5A4100000000AC8F2341666666660B3E5A419A9999994F8F234133333373113E5A4166666666048F234100000020163E5A41CDCCCCCCCB8E23419A9999B9193E5A4100000000AE8E2341CDCCCC8C1B3E5A41666666666D8E2341CDCCCC8C1F3E5A4100000000338E234100000020233E5A4133333333168E2341CDCCCCEC243E5A41	01060000206A080000010000000103000000010000002200000033333333168E2341CDCCCCEC243E5A419A9999993A8E2341000000402E3E5A4100000000EF8E23419A9999F9583E5A419A9999991F8F2341000000A06A3E5A41CDCCCCCC2D8F23419A9999D9783E5A4166666666868F2341000000404F3E5A419A9999992C90234100000020443E5A41CDCCCCCCAE9023419A999999613E5A4133333333D58F234166666606713E5A4100000000D68F23419A999999733E5A416666666643902341333333F38B3E5A410000000033912341333333537F3E5A413333333308912341000000A0743E5A41666666660592234133333353633E5A413333333319932341CDCCCC8CB43E5A41CDCCCCCC30942341666666A6A43E5A41CDCCCCCCBB942341666666A69D3E5A41666666663F952341000000E0953E5A416666666696952341000000A0913E5A41CDCCCCCC5A952341000000A05E3E5A4166666666B1962341CDCCCC8C483E5A4133333333B0952341666666C60E3E5A41333333336995234133333393FD3D5A41CDCCCCCC6B94234100000000C33D5A413333333358942341CDCCCC8CBF3D5A41CDCCCCCC8F932341CDCCCC6CCD3D5A4133333333D8922341CDCCCCECD83D5A41000000009B922341CDCCCCACDD3D5A4133333333F691234166666626E83D5A419A9999993D91234133333313F23D5A41666666661C902341666666E6033E5A419A9999994F8F234133333373113E5A4133333333168E2341CDCCCCEC243E5A4133333333168E2341CDCCCCEC243E5A41	01010000206A0800000D8F435F649223419A9999B9373E5A41	950510102	H	Centre	9505101	95051	95	11	1
01060000206A08000001000000010300000001000000B4000000666666661E842341CDCCCCEC6F3E5A419A999999298423419A999999723E5A41CDCCCCCC32842341666666A6743E5A416666666640842341CDCCCC0C773E5A41CDCCCCCC47842341333333F3783E5A41666666664F8423419A9999F97B3E5A416666666652842341CDCCCC2C7D3E5A4166666666608423419A999999813E5A419A99999904852341000000E0AD3E5A41CDCCCCCC0985234100000040B03E5A419A9999992B85234166666646B83E5A413333333350852341000000C0B53E5A41666666666B852341666666E6BB3E5A419A9999997F852341CDCCCC6CC03E5A4133333333C3852341666666A6CF3E5A4133333333CE85234166666626D23E5A4166666666518623419A999919EF3E5A41333333337F86234166666606FA3E5A4100000000BD862341333333D3083F5A41CDCCCCCCBE8623419A9999F9093F5A41CDCCCCCCC5862341666666A60D3F5A4100000000ED8623419A999939163F5A416666666600872341666666C6193F5A416666666606872341CDCCCC0C1B3F5A416666666612872341666666A61D3F5A413333333359872341333333132F3F5A41CDCCCCCC8887234133333333383F5A41CDCCCCCCAE872341333333533E3F5A4100000000B4872341000000C03F3F5A4100000000F7872341000000A0513F5A413333333331882341666666265F3F5A419A9999995A882341CDCCCC4C683F5A413333333366882341333333D36A3F5A4100000000A5882341666666A6783F5A4100000000AA882341CDCCCC8C793F5A4100000000E28823419A9999D9833F5A41000000000689234100000060893F5A419A99999930892341000000C08F3F5A41CDCCCCCC798923419A9999B99A3F5A41666666668F8923419A9999D99D3F5A4166666666D089234133333333A73F5A41CDCCCCCCE1892341666666E6A53F5A4133333333F389234100000060A43F5A41CDCCCCCC058A2341000000E0A23F5A4133333333748A2341CDCCCC0C963F5A4166666666BF8A2341666666A68C3F5A419A999999EE8A234166666666873F5A4100000000158B23419A9999F9833F5A4166666666468B2341CDCCCC8C7F3F5A4133333333548B2341000000007E3F5A41CDCCCCCC9F8B234166666666753F5A4100000000FE8B2341000000406B3F5A41000000000E8C234166666686693F5A419A999999268C234100000020673F5A41CDCCCCCC6A8C234166666666603F5A41CDCCCCCCAC8D234166666606423F5A419A999999B28D2341000000C03E3F5A41CDCCCCCCC08D2341CDCCCCAC363F5A419A999999E28D23419A999939273F5A41CDCCCCCCED8D23419A999959223F5A4100000000F08D234100000080213F5A41CDCCCCCCF78D234166666606203F5A4133333333448E234100000000173F5A4166666666568E23419A9999D9143F5A4100000000A68E2341CDCCCC8C0B3F5A419A999999CA8E234166666606073F5A41CDCCCCCCD58E2341CDCCCCAC053F5A4166666666508F2341CDCCCCACF73E5A4133333333588F2341666666C6F63E5A419A999999CC8F23419A999939E93E5A416666666652902341333333B3D93E5A419A9999992790234100000080D23E5A419A999999AF8F234100000080D23E5A4100000000228F2341CDCCCC8CD23E5A41666666663D8E234100000080D23E5A4100000000178E234133333313D23E5A41CDCCCCCCDA8D2341CDCCCC8CD03E5A41666666662C8D2341CDCCCC4CCB3E5A419A999999FF8C2341CDCCCCECC93E5A4166666666F08C23419A999979C93E5A4100000000D28C23419A999939C83E5A4166666666628C23419A999959C53E5A4166666666338C23419A999979C43E5A41666666661E8C234133333393C43E5A4166666666188C234133333393C43E5A419A999999CD8B234100000000C83E5A41666666666E8B234133333353CD3E5A41666666664E8B234100000020CF3E5A4133333333118B234133333393D23E5A419A999999FD8A2341666666A6D33E5A4100000000F28A2341CDCCCC4CD43E5A4166666666858A234100000060DA3E5A4133333333808A2341CDCCCCACDA3E5A419A999999158A2341000000A0E03E5A4166666666DF892341666666A6E33E5A4100000000AC89234166666686E63E5A419A9999997D89234100000000E93E5A41666666662C8923419A999939ED3E5A41CDCCCCCC03892341CDCCCC4CEF3E5A41CDCCCCCC50882341CDCCCC2CF83E5A410000000035882341CDCCCC8CF93E5A41000000002488234100000060FA3E5A413333333316882341CDCCCC0CFB3E5A419A9999998F8723419A999979D43E5A41666666665589234100000040C03E5A419A9999994189234100000000BB3E5A419A999999168C2341CDCCCC2C933E5A4133333333078C2341000000208F3E5A4133333333F48B23419A9999F98A3E5A419A999999D18B2341CDCCCCAC853E5A41CDCCCCCCCA8B2341666666A6843E5A4100000000B78B23419A9999D9803E5A4133333333AE8B234166666666813E5A41CDCCCCCC4F8B23419A999999873E5A419A999999E28A2341CDCCCC0C8E3E5A4133333333A68A234133333373923E5A4100000000958A2341000000408C3E5A41CDCCCCCC908A2341CDCCCC8C8A3E5A4133333333758A23419A999939843E5A4133333333348A234166666646753E5A419A999999078A23419A9999196A3E5A4133333333FC8923419A999939673E5A4100000000348A2341CDCCCC8C633E5A41333333336A8A23419A9999995F3E5A419A999999808A2341000000005E3E5A4100000000858A2341CDCCCCAC5D3E5A419A999999888A2341000000205E3E5A41000000008E8A2341333333335E3E5A41CDCCCCCC958A2341666666265E3E5A41666666669C8A2341000000C05D3E5A4133333333A18A2341666666065D3E5A4133333333A38A2341666666465C3E5A4133333333A48A2341CDCCCC4C5B3E5A41666666669F8A2341333333735A3E5A419A999999998A2341333333D3593E5A41666666669D8A2341333333D3563E5A41CDCCCCCC968A23419A999919553E5A41000000008E8A234166666666533E5A419A9999998A8A2341666666A6513E5A41000000008F8A2341000000404F3E5A41CDCCCCCC968A23419A9999994C3E5A41CDCCCCCC998A2341CDCCCC8C4B3E5A419A999999AC8A2341CDCCCCEC473E5A4100000000C38A2341CDCCCCCC443E5A4100000000DE8A234100000040423E5A4166666666078B2341666666663E3E5A419A999999268B23419A9999793B3E5A41CDCCCCCC2C8B2341333333D33A3E5A4166666666718B23419A9999B9333E5A41000000007F8B234166666646323E5A419A9999998E8B2341000000A0303E5A4133333333AA8B2341CDCCCCCC2D3E5A419A999999B68B2341666666862C3E5A41CDCCCCCCC38B2341333333532B3E5A4133333333DA8B23419A999959293E5A419A999999068C234133333393253E5A4166666666138C23419A999979243E5A4100000000258C23419A999919233E5A4166666666408C2341CDCCCCEC203E5A4100000000E48B23419A9999990F3E5A4100000000CC8B2341000000C00A3E5A4166666666CB8B2341CDCCCCAC0A3E5A4133333333CE8B234100000000083E5A419A999999CD8A2341333333D3153E5A419A999999C889234133333373233E5A4100000000A289234133333373253E5A416666666627892341333333F32B3E5A41333333337A88234166666686343E5A419A99999900872341000000A0483E5A4100000000FB862341CDCCCCEC483E5A4100000000CF862341000000404B3E5A419A999999B0862341000000E04C3E5A410000000043862341CDCCCCAC523E5A4133333333D3852341666666A6583E5A41CDCCCCCC4F852341666666A65F3E5A41333333333685234100000000613E5A4133333333628423419A9999596C3E5A41CDCCCCCC2E842341333333136F3E5A416666666627842341333333736F3E5A41666666661E842341CDCCCCEC6F3E5A41	01060000206A080000010000000103000000010000003B000000666666661E842341CDCCCCEC6F3E5A41CDCCCCCC47842341333333F3783E5A4166666666608423419A999999813E5A419A9999992B85234166666646B83E5A413333333350852341000000C0B53E5A4166666666518623419A999919EF3E5A4100000000BD862341333333D3083F5A41CDCCCCCCC5862341666666A60D3F5A416666666612872341666666A61D3F5A413333333359872341333333132F3F5A41CDCCCCCCAE872341333333533E3F5A4100000000F7872341000000A0513F5A4100000000A5882341666666A6783F5A4100000000E28823419A9999D9833F5A4166666666D089234133333333A73F5A41CDCCCCCC058A2341000000E0A23F5A419A999999EE8A234166666666873F5A4166666666468B2341CDCCCC8C7F3F5A41000000000E8C234166666686693F5A41CDCCCCCC6A8C234166666666603F5A41CDCCCCCCAC8D234166666606423F5A41CDCCCCCCC08D2341CDCCCCAC363F5A41CDCCCCCCF78D234166666606203F5A41CDCCCCCCD58E2341CDCCCCAC053F5A416666666652902341333333B3D93E5A419A9999992790234100000080D23E5A41666666663D8E234100000080D23E5A41CDCCCCCCDA8D2341CDCCCC8CD03E5A4166666666628C23419A999959C53E5A4166666666188C234133333393C43E5A419A999999CD8B234100000000C83E5A4100000000AC89234166666686E63E5A41CDCCCCCC03892341CDCCCC4CEF3E5A413333333316882341CDCCCC0CFB3E5A419A9999998F8723419A999979D43E5A41666666665589234100000040C03E5A419A9999994189234100000000BB3E5A419A999999168C2341CDCCCC2C933E5A4133333333F48B23419A9999F98A3E5A4100000000B78B23419A9999D9803E5A419A999999E28A2341CDCCCC0C8E3E5A4133333333A68A234133333373923E5A41CDCCCCCC908A2341CDCCCC8C8A3E5A4133333333348A234166666646753E5A4133333333FC8923419A999939673E5A4133333333A48A2341CDCCCC4C5B3E5A419A9999998A8A2341666666A6513E5A41CDCCCCCC998A2341CDCCCC8C4B3E5A4100000000C38A2341CDCCCCCC443E5A419A999999268B23419A9999793B3E5A419A999999B68B2341666666862C3E5A4166666666408C2341CDCCCCEC203E5A4166666666CB8B2341CDCCCCAC0A3E5A4133333333CE8B234100000000083E5A419A999999CD8A2341333333D3153E5A416666666627892341333333F32B3E5A41333333337A88234166666686343E5A41666666661E842341CDCCCCEC6F3E5A41666666661E842341CDCCCCEC6F3E5A41	01010000206A08000001F40685818D234166666616D73E5A41	950510105	A	Zone d'Activités	9505101	95051	95	11	1
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	01060000206A080000010000000103000000010000003B0000009A999999E7C4234100000080624C5A41CDCCCCCCEFC423419A9999D9694C5A419A9999990CC52341333333136F4C5A416666666699C52341CDCCCC8C814C5A41CDCCCCCCABC5234166666626884C5A41CDCCCCCC96C52341CDCCCCEC894C5A41666666668DC52341000000A08F4C5A413333333353C52341CDCCCC6C9B4C5A4100000000E6C52341CDCCCCACAC4C5A41CDCCCCCC96C6234133333333C84C5A419A999999F7C62341CDCCCC2CD84C5A410000000048C723419A999979E74C5A4100000000A3C7234133333313F64C5A41CDCCCCCCF8C72341000000A0024D5A410000000040C82341CDCCCCCC0B4D5A4133333333ECC823419A9999391E4D5A41CDCCCCCCC8C9234133333353344D5A41CDCCCCCC4FCA23419A9999193E4D5A4166666666BACA234100000060434D5A413333333332CB234166666646474D5A4133333333D7CB2341333333530D4D5A4166666666FCCB2341333333F3014D5A410000000059CC2341CDCCCC2CED4C5A41CDCCCCCC87CC234133333353E74C5A41CDCCCCCC87CC23419A999999E24C5A4100000000DBCC23419A999979D34C5A41666666664DCD2341000000C0C34C5A419A999999E4CD2341CDCCCC8CB34C5A413333333325CE23419A999959AB4C5A41000000006ECE234166666686A44C5A413333333372CE23419A9999B99F4C5A41666666665DCE2341000000E09C4C5A419A999999F5CD2341333333B3984C5A419A99999909CD2341333333D3904C5A4100000000C5CC2341000000A08D4C5A41666666664DCC2341333333F3854C5A41000000000CCC2341CDCCCCCC7F4C5A41666666663CCB2341666666A6664C5A41CDCCCCCC5CCB2341CDCCCC6C4F4C5A41CDCCCCCCC3CA234166666686484C5A41CDCCCCCC6FC92341000000803A4C5A413333333334C9234166666626374C5A419A999999BFC823419A9999D9324C5A4100000000EFC7234166666666274C5A41CDCCCCCCB6C7234100000040254C5A419A99999929C72341CDCCCCEC1C4C5A419A9999990CC72341333333D3194C5A419A999999F2C62341333333531D4C5A41000000007BC62341333333F31D4C5A41666666665AC6234166666606204C5A410000000034C623419A9999F91E4C5A41CDCCCCCC11C62341666666E6264C5A4100000000EEC52341333333D33C4C5A419A9999999FC52341000000A0394C5A41CDCCCCCC4DC52341333333F3434C5A41CDCCCCCC4BC52341000000C0464C5A4133333333F5C423419A9999F95C4C5A419A999999E7C4234100000080624C5A419A999999E7C4234100000080624C5A41	01010000206A08000066666611FCC92341CDCCCCCCB14C5A41	950520101	H	Centre Ville	9505201	95052	95	11	1
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	01060000206A080000010000000103000000010000003A0000009A99999961BB2341000000A0F84B5A41CDCCCCCC29BC23419A999939084C5A4166666666D4BC23419A999939144C5A4166666666E4BD234133333313254C5A419A999999F9BE23419A999979334C5A419A999999DABF2341CDCCCC2C3E4C5A4166666666A8C02341CDCCCC8C484C5A41333333332FC12341CDCCCC4C514C5A410000000095C12341000000205B4C5A41333333333AC22341333333B36C4C5A4100000000B3C2234133333373744C5A413333333373C32341333333D37D4C5A41333333335FC4234166666686884C5A41333333330CC52341CDCCCC4C944C5A413333333353C52341CDCCCC6C9B4C5A41666666668DC52341000000A08F4C5A41CDCCCCCC96C52341CDCCCCEC894C5A41CDCCCCCCABC5234166666626884C5A416666666699C52341CDCCCC8C814C5A419A9999990CC52341333333136F4C5A41CDCCCCCCEFC423419A9999D9694C5A419A999999E7C4234100000080624C5A4133333333F5C423419A9999F95C4C5A41CDCCCCCC4BC52341000000C0464C5A41CDCCCCCC4DC52341333333F3434C5A419A9999999FC52341000000A0394C5A4100000000EEC52341333333D33C4C5A41CDCCCCCC11C62341666666E6264C5A410000000034C623419A9999F91E4C5A410000000047C62341000000E01F4C5A416666666636C623419A999959134C5A413333333314C6234133333353054C5A4166666666B6C5234166666606DA4B5A41CDCCCCCC5AC62341CDCCCC2CA94B5A41CDCCCCCC3FC62341CDCCCC8CA74B5A419A999999EDC32341666666C6934B5A41CDCCCCCCE4C32341000000208E4B5A419A9999999EC32341666666068F4B5A4100000000C4C22341CDCCCCCCAD4B5A41CDCCCCCC3BC12341CDCCCC8C834B5A419A999999CFBF234166666646744B5A413333333396BF2341000000A06C4B5A413333333387BF234133333353704B5A4133333333DABE234133333333944B5A419A999999BCBE23419A999979914B5A4133333333A2BE2341666666A6944B5A41CDCCCCCC60BE234100000040A14B5A41CDCCCCCC20BE23419A9999B9A84B5A4100000000F8BD23419A999939B54B5A419A999999BDBD234166666646B14B5A419A99999960BD23419A9999B9BD4B5A416666666688BD23419A9999F9C24B5A41666666663ABD2341333333D3CC4B5A41CDCCCCCC09BD234133333393C54B5A41CDCCCCCCD7BC23419A999919CF4B5A41333333339BBC23419A9999F9CA4B5A419A99999961BB2341000000A0F84B5A419A99999961BB2341000000A0F84B5A41	01010000206A0800001AFBE5F902C12341CDCCCC0C044C5A41	950520102	H	Ouest	9505201	95052	95	11	1
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	01010000206A080000B2B1B1314AD2234133333393B44B5A41	950520103	H	Est	9505201	95052	95	11	3
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	01060000206A080000010000000103000000010000002700000066666666B6C5234166666606DA4B5A413333333314C6234133333353054C5A416666666636C623419A999959134C5A410000000047C62341000000E01F4C5A41000000007BC62341333333F31D4C5A419A999999F2C62341333333531D4C5A419A9999990CC72341333333D3194C5A419A99999929C72341CDCCCCEC1C4C5A41CDCCCCCCB6C7234100000040254C5A4100000000EFC7234166666666274C5A419A999999BFC823419A9999D9324C5A413333333334C9234166666626374C5A41CDCCCCCC6FC92341000000803A4C5A41CDCCCCCCC3CA234166666686484C5A41CDCCCCCC5CCB2341CDCCCC6C4F4C5A410000000095CB234100000000284C5A41CDCCCCCCC3CB23419A9999390F4C5A416666666616CC234166666646DE4B5A410000000037CC23419A9999F9D84B5A4100000000D3CC23419A9999D9D74B5A410000000068CC234133333313BD4B5A41CDCCCCCCF4CB2341CDCCCC4CA64B5A41000000004BCB2341333333939D4B5A41CDCCCCCCCACB234133333353964B5A41CDCCCCCC24CB2341000000E06A4B5A41333333333ACA2341000000A0784B5A41CDCCCCCCA7C92341CDCCCC6C7F4B5A41CDCCCCCC91C923419A999999864B5A410000000045C92341CDCCCC4C9A4B5A4100000000D8C82341CDCCCCAC934B5A41CDCCCCCC3DC82341CDCCCC2C8F4B5A419A99999904C82341333333938C4B5A419A99999986C72341CDCCCC4C834B5A41666666666DC723419A9999598A4B5A41CDCCCCCC44C72341CDCCCC6C9D4B5A41000000003AC72341CDCCCCECA94B5A41666666666EC6234133333333A34B5A4166666666B6C5234166666606DA4B5A4166666666B6C5234166666606DA4B5A41	01010000206A080000C4C51CE2EBC82341333333D3DC4B5A41	950520104	H	Sud	9505201	95052	95	11	1
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	01010000206A080000F358A65830DD2241666666F68E4D5A41	950540000	Z	Le Bellay-en-Vexin	9505400	95054	95	11	5
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	01010000206A0800002DBF77A3DA2F244166666696A9465A41	950550000	Z	Bellefontaine	9505500	95055	95	11	8
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	01010000206A0800001425B744C9F323419A999929A1465A41	950560000	Z	Belloy-en-France	9505600	95056	95	11	9
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	01010000206A08000012F4074024CE2341CCCCCC0C044F5A41	950580000	Z	Bernes-sur-Oise	9505800	95058	95	11	6
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	01010000206A080000787FD7F92749234100000070D1515A41	950590000	Z	Berville	9505900	95059	95	11	9
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	01010000206A08000086AC57BDDB8D2341CCCCCC3C31415A41	950600101	H	Église	9506001	95060	95	11	3
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	01010000206A080000BE6F47F4DA8823410000005083405A41	950600102	H	Base Aérienne	9506001	95060	95	11	3
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	01060000206A08000001000000010300000001000000200000003333333386922341333333F39F415A4100000000E1922341000000E0AC415A41666666664393234133333353BC415A4133333333A993234133333333CA415A41CDCCCCCCAA932341666666E6CB415A4133333333F4932341000000E0C7415A419A99999986942341666666A6DA415A419A999999D8942341666666C6E8415A41CDCCCCCC1A952341000000C0F5415A410000000094952341CDCCCC6CD6415A41CDCCCCCCAF95234100000000D1415A41CDCCCCCC0D96234133333393C3415A41333333330E982341666666C67B415A413333333315992341666666E642415A41CDCCCCCC02982341000000A035415A419A9999997C9723419A9999B92D415A4166666666F79623413333333323415A4133333333CA9623419A9999F922415A4166666666A09623419A99999925415A41CDCCCCCC81962341CDCCCC6C2A415A419A999999DB952341000000003A415A4166666666DD942341333333F353415A4166666666CE9423419A99997954415A41CDCCCCCCF19323419A9999196A415A41CDCCCCCCC9932341CDCCCC4C6B415A4100000000C3932341666666866E415A413333333344932341000000807C415A4100000000309323419A9999397D415A4133333333E2922341CDCCCC6C89415A419A999999BB922341666666A691415A413333333386922341333333F39F415A413333333386922341333333F39F415A41	01010000206A080000B3E3101D3D952341666666468B415A41	950600103	H	Brosses et Malais	9506001	95060	95	11	0
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	01060000206A0800000100000001030000000100000077000000000000008BA72341666666E63B425A410000000011A82341000000A044425A41666666665AA82341333333B34B425A41333333334EA82341CDCCCC8C4F425A4100000000A1A723413333339370425A419A99999982A82341666666268C425A4100000000C9A82341333333337D425A410000000004A923419A99999981425A419A99999997A923419A9999F98E425A4100000000C5A92341666666A684425A41CDCCCCCCEEAA2341CDCCCC8CA0425A41666666669BAA23419A999919CE425A416666666674AA23419A999959CF425A41CDCCCCCC24AA234166666606F2425A416666666617AB23419A999959F7425A419A9999995FAB2341000000E0F7425A41CDCCCCCC41AC2341CDCCCC4CFD425A410000000038AC2341666666660C435A4100000000EAAC2341333333130D435A4133333333F3AC2341666666E617435A41333333336CAE2341666666A639435A419A99999949AE23419A9999393B435A41CDCCCCCC72AE23419A99995947435A41CDCCCCCC26AF23410000006075435A419A99999932AF2341CDCCCCCC92435A419A9999997BAF2341CDCCCC2C92435A41000000007DAF2341CDCCCC0C96435A4166666666A2AF234166666626AA435A4100000000D7AF2341000000C0B5435A419A99999939B0234166666626C7435A41000000003BB023419A999999C8435A4100000000A4B02341CDCCCC0CDC435A4100000000A9B12341333333F30A445A41CDCCCCCCADB12341333333B315445A419A999999A5B123419A9999D930445A41CDCCCCCC96B12341333333F337445A410000000048B12341333333F34B445A41CDCCCCCC47B12341666666865E445A41333333334EB123419A9999796C445A41CDCCCCCC48B12341CDCCCC8C79445A410000000096B123419A9999997B445A41CDCCCCCC8BB123419A9999D984445A416666666602B22341CDCCCC0C86445A416666666669B223419A9999F985445A4133333333CAB223419A99991987445A4100000000CEB22341333333338A445A419A9999999EB32341000000C08F445A419A999999B7B323410000006088445A41333333336AB423413333339386445A4166666666B5B42341333333D383445A419A99999908B52341666666467D445A419A99999931B523416666662676445A41CDCCCCCC46B52341000000206D445A41CDCCCCCC83B52341333333F35E445A4166666666ACB523410000004058445A410000000028B623410000002051445A416666666672B62341666666464E445A419A9999997FB62341666666A639445A416666666680B623419A9999D91F445A41000000009DB623419A9999B9FB435A4166666666C0B62341CDCCCC8CDD435A41CDCCCCCCD2B623419A999979D2435A41CDCCCCCCF4B623419A999999C3435A41666666660BB7234166666666AD435A416666666616B72341666666869B435A416666666603B72341666666668A435A4166666666E0B623419A99993977435A419A999999D8B62341CDCCCC6C6D435A4166666666DAB62341666666C65F435A4133333333E7B62341666666E65A435A416666666663B72341333333935A435A41000000008EB72341666666C642435A4166666666A3B72341666666862C435A41000000009BB72341333333731D435A41333333336BB72341333333B30D435A410000000035B723419A9999D901435A41CDCCCCCC1FB72341CDCCCC2CF5425A410000000023B72341333333B3EA425A419A99999931B723419A999959E4425A410000000080B72341333333F3DB425A413333333329B72341CDCCCCACD1425A4133333333FAB623419A999979CA425A4133333333D0B623419A999959C7425A413333333397B62341CDCCCC8CBD425A410000000061B62341CDCCCC8CB1425A41666666662AB62341333333B3AC425A4166666666BAB5234100000020A5425A4133333333E4B52341000000209A425A4133333333E6B523413333339381425A4100000000DDB523416666668644425A41CDCCCCCCE0B52341CDCCCC2C36425A419A999999DFB52341333333B31B425A4133333333D0B52341CDCCCC4CC5415A4166666666D0B5234133333353B8415A419A999999C5B52341333333D391415A41CDCCCCCC73B52341666666668C415A4133333333E4B423413333335384415A4100000000D2B323410000004073415A416666666684B223419A9999395F415A416666666606B22341000000C055415A419A99999934AF2341CDCCCC8C7A415A413333333351AC2341CDCCCC0CA1415A419A99999968AC234166666686AA415A41CDCCCCCC18AC2341CDCCCC4CA8415A4100000000CFAB234100000000A8415A41333333339EAB234166666646A9415A416666666651AB23419A999999AD415A41CDCCCCCCECAA23419A999959B6415A41CDCCCCCC5FAA234100000000C9415A41CDCCCCCC23AA23419A999959D9415A41CDCCCCCC11AA23419A9999B9E6415A4100000000F8A9234100000060ED415A41000000006AA92341CDCCCCEC07425A413333333346A923419A9999190A425A419A999999D5A82341CDCCCC0C1C425A416666666694A82341CDCCCC2C20425A4133333333B8A723419A99993933425A41000000008BA72341666666E63B425A41000000008BA72341666666E63B425A41	01010000206A08000015133663B0B023419A9999B9F2425A41	950610000	Z	Béthemont-la-Forêt	9506100	95061	95	11	4
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	01060000206A080000010000000103000000010000001D00000066666666D59323419A9999396A355A419A999999FC952341000000C090355A4100000000489623416666668681355A4133333333F79623419A9999D95F355A419A999999B89723419A99997941355A41CDCCCCCC489823413333331324355A419A999999B49823410000000012355A41666666669D992341666666E6F3345A41CDCCCCCCAC9923419A999979F1345A419A999999209823419A999979D6345A419A9999993098234133333353D2345A41CDCCCCCCDD97234133333333CC345A41333333332797234133333353BD345A41CDCCCCCC7096234166666666B0345A41CDCCCCCC94962341333333B3A6345A416666666678962341CDCCCCECA6345A41666666663E95234166666666AD345A41000000000E9523419A9999F9BC345A41666666666B95234133333313C1345A4100000000E49423419A999959E7345A4100000000DD942341666666C6E6345A41000000008D9423419A999939FE345A4100000000F69423410000006003355A419A999999469423419A99991931355A41666666666F942341CDCCCC4C33355A410000000016942341333333734C355A416666666641942341333333334F355A4166666666D59323419A9999396A355A4166666666D59323419A9999396A355A41	01010000206A0800005C2D148C94962341CDCCCC6C19355A41	950630108	H	Chêne Ouest	9506301	95063	95	11	0
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	01060000206A08000001000000010300000001000000130000009A999999FC952341000000C090355A419A999999E1962341333333F3A0355A41CDCCCCCC179823419A9999D9BA355A419A9999998E982341666666C6A2355A419A999999A19923413333339369355A4133333333C0992341666666A660355A419A999999F2992341666666A659355A41000000003A9B2341CDCCCC6C17355A4100000000529A2341000000E003355A41CDCCCCCC609A23416666660601355A4133333333B1992341CDCCCC8CF2345A41666666669D992341666666E6F3345A419A999999B49823410000000012355A41CDCCCCCC489823413333331324355A419A999999B89723419A99997941355A4133333333F79623419A9999D95F355A4100000000489623416666668681355A419A999999FC952341000000C090355A419A999999FC952341000000C090355A41	01010000206A080000483226CE989823419A9999A956355A41	950630109	H	Chêne Est	9506301	95063	95	11	0
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	01060000206A080000010000000103000000010000001C00000033333333D49B234133333313FA345A41CDCCCCCCE39B234133333373FB345A4166666666FF9B23419A999959F5345A41333333331E9C23419A9999D9FB345A41CDCCCCCC479C23419A999979FB345A416666666636A02341000000C00C355A419A9999993EA023419A99997909355A4133333333799E23419A999999AE345A41CDCCCCCCD39D23419A9999198D345A4166666666D89D2341000000E08A345A4100000000489E2341666666C676345A41333333338A9D2341CDCCCC4C68345A41666666666D9D2341000000C067345A419A9999991D9D2341333333935B345A41CDCCCCCCBD9C2341CDCCCCEC52345A41333333335D9C23416666668662345A419A999999389C2341666666A669345A4100000000369C23419A9999B971345A4100000000259C2341666666C679345A419A999999FC9C2341333333D374345A4133333333DA9C2341CDCCCC8C95345A41CDCCCCCCCF9C2341CDCCCCCC9B345A4166666666B79C2341CDCCCCECB6345A4166666666679C2341CDCCCC8CD3345A41333333334E9C23419A9999F9DA345A41CDCCCCCCFB9B234166666606EE345A4133333333D49B234133333313FA345A4133333333D49B234133333313FA345A41	01010000206A08000008D7A3F09E9D234166666616B0345A41	950630102	H	Colombier	9506301	95063	95	11	0
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	01060000206A080000010000000103000000010000001D0000009A999999F29A23419A99999925355A4166666666A29B23416666664633355A41CDCCCCCCE29B2341CDCCCC4C39355A41CDCCCCCCF69B23410000006040355A41CDCCCCCCEE9B2341000000A045355A419A999999749B2341666666C65E355A41CDCCCCCC709C23416666664674355A4133333333CD9D2341666666C68E355A4133333333169E23419A99991984355A4100000000A89E23416666664667355A4133333333329F23410000008073355A41CDCCCCCC529F2341CDCCCC8C78355A41333333336D9F2341666666C687355A4100000000EA9F2341666666A68E355A419A99999921A023410000002094355A4166666666E4A02341000000A059355A4100000000D1A023419A99997958355A410000000080A123419A9999192C355A410000000042A02341333333330C355A416666666636A02341000000C00C355A41CDCCCCCC479C23419A999979FB345A41333333331E9C23419A9999D9FB345A4166666666FF9B23419A999959F5345A41CDCCCCCCE39B234133333373FB345A4133333333D49B234133333313FA345A419A999999969B23413333331304355A419A9999995A9B23413333337311355A419A999999F29A23419A99999925355A419A999999F29A23419A99999925355A41	01010000206A0800006A3A4520859E2341CDCCCCFC44355A41	950630103	H	Agriculture Sud	9506301	95063	95	11	0
01060000206A08000001000000010300000001000000BA00000000000000A39123410000000054335A41CDCCCCCC23922341666666865F335A41CDCCCCCC55922341666666C663335A416666666696922341CDCCCCAC68335A4100000000CD922341CDCCCC0C6D335A4100000000DF922341CDCCCC2C6F335A419A999999F49223419A9999B972335A41000000000A9323410000002075335A4166666666519323410000006079335A4166666666FE9323419A99995986335A419A999999E49423416666664698335A416666666606952341666666C69A335A41333333335095234100000060A0335A410000000079952341CDCCCCACA3335A41CDCCCCCC7A952341CDCCCCCCA3335A41666666667B9523419A9999D9A3335A4133333333D794234166666606C9335A41CDCCCCCCDE94234100000080C9335A419A999999BE942341CDCCCCACD1335A4100000000D5942341333333F3D2335A4100000000F69423419A9999F9D4335A416666666669952341666666E6DC335A41666666666C95234133333313DD335A413333333350952341CDCCCC6CE3335A419A99999947952341CDCCCC6CE5335A410000000042952341CDCCCCACE6335A41333333331095234133333333F2335A41CDCCCCCC0B95234100000040F3335A419A99999905952341CDCCCC8CF4335A416666666601952341CDCCCC8CF5335A4100000000FC942341CDCCCCECF6335A4166666666129523419A999979F8335A413333333391952341CDCCCCCC01345A41000000000C9623419A9999D90B345A41666666661A962341000000800D345A41CDCCCCCC87962341666666E618345A419A999999BF962341000000001F345A41666666660A972341CDCCCC0C26345A41CDCCCCCC629723419A9999592E345A41CDCCCCCCBA972341333333F335345A4166666666DD972341333333F338345A41CDCCCCCC06982341000000803C345A41333333335D9823413333333344345A4133333333679823410000002045345A4166666666AE9823419A9999594B345A410000000083992341CDCCCC8C5D345A419A99999997992341333333535F345A4133333333139A2341333333136A345A4133333333359A2341666666466D345A4100000000429A2341000000806E345A4100000000549A23413333331370345A4166666666AD9A23419A9999F976345A41CDCCCCCCE59A2341666666467B345A4100000000EB9A2341CDCCCCEC7B345A419A999999F39A2341666666667D345A4100000000F79A23419A9999997E345A4166666666069B23413333337380345A4133333333199B23416666660680345A41CDCCCCCC359B2341000000607F345A4133333333539B2341333333B37E345A4133333333719B2341000000007E345A4166666666859B2341CDCCCC8C7D345A41000000008F9B2341CDCCCC4C7D345A4166666666AA9B2341666666A67C345A41CDCCCCCCC39B2341CDCCCC0C7C345A4100000000DC9B23419A9999797B345A4133333333F39B2341666666E67A345A419A999999099C2341000000607A345A41333333331F9C2341CDCCCCEC79345A4100000000259C2341666666C679345A41CDCCCCCC289C2341333333B376345A41000000002F9C23410000008074345A4166666666329C23416666660673345A4100000000369C23419A9999B971345A419A999999369C23419A9999796F345A4100000000379C2341CDCCCCCC6D345A4133333333369C2341000000606B345A419A999999389C2341666666A669345A41CDCCCCCC3F9C23419A99991968345A4133333333489C23419A9999B966345A419A9999994E9C23410000006065345A41333333335D9C23416666668662345A41000000007B9C2341CDCCCCAC5D345A419A999999829C2341333333735C345A41CDCCCCCCBD9C2341CDCCCCEC52345A41CDCCCCCCC69C23413333335354345A41CDCCCCCCCF9C23419A99991955345A4133333333D99C2341666666A655345A4133333333E19C2341CDCCCCAC55345A4166666666E89C2341CDCCCCEC55345A4166666666EE9C23413333337356345A4166666666F39C23419A9999F956345A41CDCCCCCCF79C23416666668657345A41000000000A9D23410000008059345A4133333333119D23419A9999395A345A419A999999179D2341CDCCCCEC5A345A419A9999991D9D2341333333935B345A4166666666229D2341666666265C345A41CDCCCCCC249D23419A9999795C345A4100000000269D2341000000A05C345A4133333333269D2341666666A65C345A4133333333279D2341666666C65C345A41CDCCCCCC289D2341000000005D345A41000000002B9D23419A9999595D345A41000000002E9D2341666666E65D345A41666666662F9D2341000000405E345A419A999999449D23419A99993961345A41CDCCCCCC639D23416666664666345A41CDCCCCCC689D2341333333F366345A41666666666D9D2341000000C067345A4100000000789D2341CDCCCC8C67345A4166666666809D23419A9999B967345A41333333338A9D2341CDCCCC4C68345A41CDCCCCCC9F9D2341333333536A345A4166666666AA9D2341666666466B345A41CDCCCCCCB49D2341333333F36B345A4100000000BF9D2341000000806C345A4100000000C49D2341333333936C345A41CDCCCCCC159E2341666666C672345A4100000000169E23410000000073345A4100000000489E2341666666C676345A419A999999429E23419A99999977345A4166666666309E23419A9999B97A345A4100000000249E2341333333B37C345A4166666666139E23419A99993980345A41CDCCCCCCE79D2341666666E687345A4166666666D89D2341000000E08A345A41CDCCCCCCD39D23419A9999198D345A41000000001F9E2341CDCCCCEC9B345A419A9999993A9E2341CDCCCCACA1345A4100000000509E23419A999919A6345A4133333333799E23419A999999AE345A41CDCCCCCC8A9E23419A999919B2345A41CDCCCCCCE59E234166666646C4345A4166666666149F23419A999999CD345A4166666666259F234166666606D1345A4133333333929F2341666666E6E6345A41CDCCCCCCBC9F2341CDCCCC6CEF345A41CDCCCCCC23A02341CDCCCC0C04355A419A9999993EA023419A99997909355A410000000042A02341333333330C355A416666666657A02341333333130E355A419A99999992A023419A9999F913355A419A9999994BA123419A9999F926355A410000000080A123419A9999192C355A4100000000D8A123416666666635355A419A999999C4A223419A9999594D355A416666666692A32341000000402C355A41CDCCCCCCBEA323410000006025355A413333333328A423413333337314355A41666666663AA423419A9999D911355A419A9999999FA423419A99991902355A419A9999991EA423419A999999F1345A4166666666B7A22341000000A0C4345A416666666615A2234133333393AF345A4100000000D8A02341000000C087345A41CDCCCCCC87A023419A9999F97D345A41CDCCCCCCE59F2341666666C66A345A41CDCCCCCC759E2341333333933F345A41CDCCCCCC699E2341000000203E345A41666666665F9E2341666666E63C345A419A999999A99D23413333339327345A419A9999990E9D23419A99997914345A4133333333499C23419A999939FC335A419A999999909B2341CDCCCC0CE6335A4100000000D49A234100000080CE335A41CDCCCCCCA19A234100000000C7335A41CDCCCCCC3A9A2341666666E6B6335A419A999999E299234133333333A6335A4133333333A29923419A9999199B335A4100000000569923413333335390335A419A999999179923410000008087335A419A999999F8982341333333F383335A41000000003C9823419A9999396C335A41CDCCCCCCC6972341CDCCCCEC5D335A4133333333689723419A99999952335A41CDCCCCCC0C9723419A99995948335A419A9999998B962341666666E63B335A4133333333129623413333331331335A4100000000C4952341000000802B335A41CDCCCCCC339523419A9999B920335A4166666666AF9423416666666617335A4133333333E5932341CDCCCCAC07335A419A99999953932341666666A6FD325A41CDCCCCCCE592234100000080F4325A4100000000A39123410000000054335A41	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	01010000206A080000BC4225CF329A23416666668622345A41	950630101	H	Zone Industrielle	9506301	95063	95	11	1
01060000206A0800000100000001030000000100000089000000CDCCCCCC179823419A9999D9BA355A419A999999B7982341333333F3C0355A419A99999908992341CDCCCC0CC4355A4133333333DA992341CDCCCCACCB355A4133333333089A2341000000E0CC355A419A9999993E9A2341CDCCCC6CCD355A41CDCCCCCCC29A2341CDCCCC8CCB355A4133333333C49A234166666686CB355A419A999999E99A234166666606CB355A4100000000E79A23419A999979C9355A4166666666DE9A2341333333F3C7355A41CDCCCCCCC39A234133333353C5355A4100000000779A234100000040BE355A4166666666739A2341CDCCCCACBD355A41CDCCCCCC719A23419A999919BD355A419A999999719A2341CDCCCCECBB355A4166666666719A234166666666BB355A4133333333709A2341CDCCCCECBA355A41666666666E9A234100000080BA355A41666666666B9A23419A999919BA355A41CDCCCCCC679A23419A9999B9B9355A41CDCCCCCC639A234100000060B9355A4100000000609A2341CDCCCC0CB9355A41333333335C9A23419A9999B9B8355A4166666666C19A2341333333F3A3355A4166666666309B2341666666468D355A4166666666509B2341CDCCCCEC8F355A4166666666799B23416666660693355A41CDCCCCCC829B2341333333B393355A4133333333929B2341333333D394355A41CDCCCCCCCB9B2341CDCCCCCC98355A41CDCCCCCC219C2341666666E69E355A419A9999994E9C23419A999939A2355A41000000007B9C234133333333A5355A41CDCCCCCCA79C234100000060A8355A41CDCCCCCCFD9C23419A999939AF355A41CDCCCCCC229D2341CDCCCCACB1355A4100000000F49C2341000000E0BA355A41CDCCCCCCE99C2341CDCCCC6CBD355A419A999999F59C234166666646BD355A4166666666099D2341CDCCCCACBD355A4166666666589D2341000000E0BF355A41CDCCCCCC639D234133333373C0355A41000000007D9D2341666666A6C1355A4133333333CD9D2341CDCCCC2CC5355A4133333333169E234100000020C9355A4166666666239E23419A999999C9355A419A999999379E234166666626CA355A4133333333529E2341CDCCCCECC9355A4133333333F49E2341333333B3C7355A41CDCCCCCC049F23419A999939C7355A419A9999994B9F234100000040C4355A41CDCCCCCC609F234133333393C3355A4100000000739F234133333373C3355A41CDCCCCCCA39F2341000000A0B7355A41CDCCCCCCC39F23419A999959AF355A41CDCCCCCC2BA023419A99993995355A419A99999921A023410000002094355A413333333316A02341000000E092355A41333333330DA02341CDCCCCEC91355A410000000005A023410000000091355A4100000000EA9F2341666666A68E355A419A9999998B9F23413333335389355A41333333336D9F2341666666C687355A4133333333629F23410000004086355A4166666666609F23416666660681355A419A999999559F2341CDCCCC8C7B355A419A999999559F23419A9999F979355A41CDCCCCCC529F2341CDCCCC8C78355A419A9999994A9F23419A9999D976355A419A999999409F23416666664675355A4133333333329F23410000008073355A4166666666309F23413333335373355A4166666666019F2341333333B36E355A4166666666F69E2341666666C66D355A4100000000DF9E2341000000A06B355A4100000000A89E23416666664667355A41CDCCCCCC859E2341666666E66D355A4133333333459E2341000000C07A355A4133333333169E23419A99991984355A419A999999FC9D2341666666A688355A4166666666FA9D2341CDCCCC0C89355A419A999999E59D2341666666268B355A4133333333CD9D2341666666C68E355A419A999999789D23419A99993988355A41333333331F9D23410000008081355A4166666666F19C2341CDCCCCEC7D355A4133333333CA9C2341CDCCCCEC7A355A4133333333929C2341000000C076355A41CDCCCCCC709C23416666664674355A419A999999279C23419A9999396E355A419A999999E79B2341666666E668355A4166666666D69B23416666666667355A419A999999749B2341666666C65E355A41000000007A9B23419A9999595D355A41666666667F9B2341000000005C355A41CDCCCCCCAF9B23416666660652355A4166666666CF9B2341666666864B355A41CDCCCCCCEE9B2341000000A045355A4100000000EA9B23419A99995944355A4133333333E89B2341666666A643355A419A999999E99B2341CDCCCC8C42355A41CDCCCCCCEB9B2341CDCCCCAC41355A4133333333EF9B23416666660641355A41CDCCCCCCF39B23410000008040355A41CDCCCCCCF69B23410000006040355A4100000000ED9B23419A9999993C355A41CDCCCCCCE99B2341333333133B355A41CDCCCCCCE29B2341CDCCCC4C39355A419A999999D09B23413333333337355A41CDCCCCCCC19B2341333333D335355A4166666666A29B23416666664633355A41CDCCCCCC3A9B23419A9999392B355A419A999999F29A23419A99999925355A4100000000BA9A23413333333331355A41333333338A9A2341000000003B355A41CDCCCCCC1F9A23416666668650355A419A999999FC992341000000A057355A419A999999F2992341666666A659355A4133333333EF992341000000005B355A4166666666DD992341666666A65C355A419A999999D4992341333333B35D355A4133333333C0992341666666A660355A4100000000B0992341CDCCCCCC64355A419A999999A19923413333339369355A41333333338D992341000000606D355A4166666666859923419A9999396F355A416666666681992341CDCCCC2C70355A41666666665A992341000000E078355A41CDCCCCCC3E992341CDCCCC4C7E355A416666666628992341CDCCCCCC82355A416666666604992341CDCCCC4C8A355A419A999999E79823410000002090355A419A9999998E982341666666C6A2355A41333333337898234133333353A7355A410000000057982341000000E0AD355A41CDCCCCCC179823419A9999D9BA355A41	01060000206A0800000100000001030000000100000025000000CDCCCCCC179823419A9999D9BA355A4133333333DA992341CDCCCCACCB355A419A9999993E9A2341CDCCCC6CCD355A419A999999E99A234166666606CB355A4166666666DE9A2341333333F3C7355A4100000000779A234100000040BE355A41333333335C9A23419A9999B9B8355A4166666666309B2341666666468D355A4133333333929B2341333333D394355A41CDCCCCCCA79C234100000060A8355A41CDCCCCCC229D2341CDCCCCACB1355A41CDCCCCCCE99C2341CDCCCC6CBD355A4166666666589D2341000000E0BF355A419A999999379E234166666626CA355A4133333333F49E2341333333B3C7355A4100000000739F234133333373C3355A41CDCCCCCC2BA023419A99993995355A4100000000EA9F2341666666A68E355A41333333336D9F2341666666C687355A41CDCCCCCC529F2341CDCCCC8C78355A4133333333329F23410000008073355A4100000000A89E23416666664667355A4133333333169E23419A99991984355A4133333333CD9D2341666666C68E355A41CDCCCCCC709C23416666664674355A419A999999749B2341666666C65E355A41CDCCCCCCEE9B2341000000A045355A41CDCCCCCCF69B23410000006040355A41CDCCCCCCE29B2341CDCCCC4C39355A4166666666A29B23416666664633355A419A999999F29A23419A99999925355A419A999999F2992341666666A659355A4133333333C0992341666666A660355A419A999999A19923413333339369355A419A9999998E982341666666C6A2355A41CDCCCCCC179823419A9999D9BA355A41CDCCCCCC179823419A9999D9BA355A41	01010000206A0800008F7D4ED7069B2341CDCCCC6C79355A41	950630104	H	Agriculture Nord	9506301	95063	95	11	0
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	01060000206A08000001000000010300000001000000280000009A999999D99623419A9999594B365A413333333316972341666666064D365A4133333333A59723419A9999394F365A4100000000A8972341CDCCCC6C3F365A4133333333D3982341000000203D365A4100000000CE982341CDCCCC6C23365A413333333333992341333333D323365A419A9999996F9A2341CDCCCC2C19365A419A9999999F9A23419A9999191C365A4133333333F59A23413333333308365A419A9999997E9B2341333333B311365A419A9999998D9B23419A9999590C365A419A999999C29B23413333339310365A4100000000F59B23419A9999B910365A4133333333F99B2341CDCCCCEC0A365A419A999999119C2341CDCCCCCC0A365A41000000002E9C2341666666A603365A419A999999C79C2341CDCCCC6C0C365A419A999999D99C2341333333F3F8355A4100000000B79C234100000080E9355A4166666666239E23419A999999C9355A4166666666589D2341000000E0BF355A41CDCCCCCCE99C2341CDCCCC6CBD355A41CDCCCCCC229D2341CDCCCCACB1355A41CDCCCCCCA79C234100000060A8355A4133333333929B2341333333D394355A4166666666309B2341666666468D355A41333333335C9A23419A9999B9B8355A4100000000779A234100000040BE355A4166666666DE9A2341333333F3C7355A419A999999E99A234166666606CB355A419A9999993E9A2341CDCCCC6CCD355A4133333333DA992341CDCCCCACCB355A41CDCCCCCC179823419A9999D9BA355A419A9999997B972341CDCCCC4CDA355A410000000030972341666666E6ED355A419A999999FC962341CDCCCC4C05365A41CDCCCCCCF4962341000000000D365A419A999999D99623419A9999594B365A419A999999D99623419A9999594B365A41	01010000206A0800002E99BD1CF9992341333333F3F0355A41	950630105	H	Vaillant-Couturier	9506301	95063	95	11	0
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	01060000206A08000001000000010300000001000000160000009A999999CA932341333333F31E365A419A99999913942341000000601A365A419A9999991D942341666666861C365A413333333398942341000000C01D365A419A9999997F942341000000405B365A4166666666CE9523419A9999995D365A41666666661E962341666666E661365A419A9999994D962341CDCCCCCC68365A4133333333B89623419A9999797F365A419A999999D0962341333333F381365A4100000000DE9623416666662666365A419A999999D99623419A9999594B365A4133333333F09623410000008016365A410000000085962341666666860F365A4133333333109623413333333304365A41666666668795234166666626F9355A4166666666B094234133333393CA355A41666666660F94234166666686E3355A4133333333129423419A999999EA355A419A999999D3932341CDCCCC0C1D365A419A999999CA932341333333F31E365A419A999999CA932341333333F31E365A41	01010000206A0800000A074E2EBF952341CCCCCC1C26365A41	950630106	H	Val Nord	9506301	95063	95	11	0
01060000206A080000010000000103000000010000004C000000666666667492234133333373D9355A41000000007592234166666686D9355A41CDCCCCCC74932341000000E0EF355A4133333333C7932341CDCCCCCCEA355A4100000000D6932341000000C0E9355A419A999999E89323419A9999F9E7355A4100000000F5932341CDCCCC8CE6355A41666666660F94234166666686E3355A41333333331B94234100000020E2355A41CDCCCCCC229423419A9999F9E0355A41000000002D942341CDCCCCCCDE355A419A9999994094234100000060DB355A419A9999997C94234166666686D2355A41CDCCCCCC919423419A999939CF355A4166666666B094234133333393CA355A4133333333EB942341000000E0D6355A41CDCCCCCC43952341CDCCCC6CEA355A419A9999997695234166666686F5355A41666666668795234166666626F9355A41666666669595234133333333FA355A419A999999A595234166666666FB355A4166666666DA952341666666A6FF355A4100000000F9952341CDCCCC2C02365A4133333333109623413333333304365A419A99999954962341333333730B365A4166666666689623419A9999190D365A410000000085962341666666860F365A4100000000B7962341000000A012365A4166666666DA9623416666660615365A4133333333F09623410000008016365A41CDCCCCCCF4962341000000000D365A4100000000F89623419A9999D908365A419A999999FC962341CDCCCC4C05365A419A9999990B97234100000040FD355A41000000001997234100000000F7355A419A9999992097234100000000F4355A410000000030972341666666E6ED355A41000000004297234133333353E8355A4100000000599723419A999939E2355A41000000005E972341000000E0E0355A419A9999997B972341CDCCCC4CDA355A41000000009497234133333353D5355A41CDCCCCCC179823419A9999D9BA355A4166666666EC9723419A999959B7355A4166666666C3972341CDCCCCECB3355A4166666666659723419A9999B9AB355A419A999999E1962341333333F3A0355A4100000000C5962341666666C69E355A416666666690962341000000009B355A41CDCCCCCC3E962341CDCCCC2C95355A4166666666339623419A99995994355A419A999999FC952341000000C090355A41666666669A9523419A9999B989355A4133333333F1942341333333F37D355A419A99999931942341666666A670355A4166666666EF932341666666066C355A4166666666E9932341000000806D355A4100000000DA9323419A9999B970355A41CDCCCCCCD5932341CDCCCCAC71355A4166666666C9932341CDCCCCCC74355A4133333333C1932341CDCCCCEC76355A4133333333B2932341000000C07A355A4100000000AA932341CDCCCCAC7C355A419A999999999323416666668680355A41666666668B9323410000008084355A416666666680932341333333B387355A419A9999990D93234133333373A8355A4133333333F692234100000020AF355A4100000000E792234133333373B3355A4166666666D3922341333333F3B9355A4133333333D0922341CDCCCC0CBB355A419A999999A3922341CDCCCCCCC9355A41CDCCCCCCA0922341000000C0CA355A41CDCCCCCC8C92234100000060D1355A4100000000789223419A999939D8355A41666666667492234133333373D9355A41	01060000206A0800000100000001030000000100000015000000666666667492234133333373D9355A41CDCCCCCC74932341000000E0EF355A4133333333C7932341CDCCCCCCEA355A41333333331B94234100000020E2355A419A9999994094234100000060DB355A4166666666B094234133333393CA355A41666666668795234166666626F9355A4133333333109623413333333304365A410000000085962341666666860F365A4133333333F09623410000008016365A419A999999FC962341CDCCCC4C05365A410000000030972341666666E6ED355A419A9999997B972341CDCCCC4CDA355A41CDCCCCCC179823419A9999D9BA355A419A999999E1962341333333F3A0355A4166666666339623419A99995994355A4166666666EF932341666666066C355A419A999999999323416666668680355A4100000000E792234133333373B3355A41666666667492234133333373D9355A41666666667492234133333373D9355A41	01010000206A080000148AA8FE55952341CDCCCC6CC2355A41	950630107	H	Val Sud	9506301	95063	95	11	0
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	01060000206A080000010000000103000000010000001C0000009A999999199523419A999979AE345A416666666678962341CDCCCCECA6345A41CDCCCCCC94962341333333B3A6345A41CDCCCCCC7096234166666666B0345A41333333332797234133333353BD345A41CDCCCCCCDD97234133333333CC345A419A9999993098234133333353D2345A419A999999209823419A999979D6345A41CDCCCCCCAC9923419A999979F1345A4133333333B1992341CDCCCC8CF2345A41CDCCCCCC609A23416666660601355A4100000000529A2341000000E003355A41000000003A9B2341CDCCCC6C17355A419A999999969B23413333331304355A4100000000E69B2341CDCCCCECF6345A41CDCCCCCCFB9B234166666606EE345A41333333334E9C23419A9999F9DA345A4166666666679C2341CDCCCC8CD3345A4166666666B79C2341CDCCCCECB6345A41CDCCCCCCCF9C2341CDCCCCCC9B345A4133333333DA9C2341CDCCCC8C95345A419A999999FC9C2341333333D374345A4166666666FD9A2341666666A680345A419A9999991C9A23419A99999986345A41CDCCCCCC319723419A9999F996345A419A99999943952341666666A6A1345A419A999999199523419A999979AE345A419A999999199523419A999979AE345A41	01010000206A08000066DE718A139A2341CCCCCCFCC6345A41	950630110	H	Centre	9506301	95063	95	11	0
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	01060000206A080000010000000103000000010000002200000066666666429223419A99995914345A419A99999978922341333333731A345A4133333333EF9323419A9999D946345A41333333331B9423419A9999794B345A413333333373952341000000C062345A4133333333B59523416666666668345A4166666666AD952341000000606E345A41666666667E952341333333537B345A41CDCCCCCC91952341666666667C345A4133333333449523419A99999994345A419A999999689523419A99995996345A419A99999943952341666666A6A1345A419A9999991C9A23419A99999986345A4166666666069B23413333337380345A41CDCCCCCCE59A2341666666467B345A4100000000549A23413333331370345A4133333333139A2341333333136A345A4166666666AE9823419A9999594B345A41CDCCCCCC629723419A9999592E345A419A999999BF962341000000001F345A41000000000C9623419A9999D90B345A413333333391952341CDCCCCCC01345A4100000000FC942341CDCCCCECF6335A41666666666C95234133333313DD335A419A999999BE942341CDCCCCACD1335A4133333333D794234166666606C9335A41666666667B9523419A9999D9A3335A419A999999E49423416666664698335A4133333333F8932341333333B3CC335A41CDCCCCCC9093234100000040E4335A41000000002E9323419A999939F9335A41666666669A922341000000800D345A4166666666429223419A99995914345A4166666666429223419A99995914345A41	01010000206A080000A028B23C9B9423419A9999B91C345A41	950630111	H	Nouveau Bezons	9506301	95063	95	11	0
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	01060000206A080000010000000103000000010000002E0000009A9999997A1C23419A999919A13F5A41000000000A1D234100000040A43F5A41666666667C1D2341666666C6A43F5A4100000000E11E2341CDCCCCAC9D3F5A419A9999996F1F2341000000409C3F5A41333333337F2023419A9999D99C3F5A419A99999980202341CDCCCCECA33F5A419A999999C0202341CDCCCC0CA43F5A4166666666BD20234166666666A83F5A41CDCCCCCC002123419A999979A83F5A4100000000E3202341333333B3FE3F5A419A999999CE212341333333D3FD3F5A4100000000FD232341333333F30D405A416666666622272341CDCCCC4C00405A41333333339E2723419A9999191D3F5A41CDCCCCCCEC27234100000060F03E5A41CDCCCCCC5228234133333353EC3E5A419A999999212923419A9999F9ED3E5A410000000035292341CDCCCC0CEA3E5A41666666662229234133333333B83E5A41CDCCCCCC382923419A999979B33E5A4100000000D429234166666606983E5A41CDCCCCCCE8292341CDCCCCCC913E5A4100000000A8292341000000C08C3E5A41CDCCCCCCEF2823419A9999B9803E5A4100000000A427234166666606663E5A41000000008A262341666666664D3E5A41CDCCCCCC352623419A9999B9473E5A419A99999999262341CDCCCC8C343E5A410000000010272341666666C6163E5A41CDCCCCCC27272341000000E00F3E5A419A999999E8262341333333730C3E5A416666666691262341CDCCCC6C013E5A4133333333202623419A999919F53D5A4133333333E7252341CDCCCC6CF13D5A41CDCCCCCC5C2523419A999959F13D5A419A999999BE242341000000400D3E5A410000000037242341CDCCCCAC1C3E5A4133333333E82323419A9999B9233E5A419A999999CD232341000000C0243E5A4133333333221F23419A9999D9EE3E5A4166666666FA1D23419A999919223F5A419A999999BC1D23419A9999192E3F5A4166666666E11C234100000060553F5A419A9999997A1C23419A999919A13F5A419A9999997A1C23419A999919A13F5A41	01010000206A080000624A44531D232341666666660B3F5A41	950740000	Z	Boisemont	9507400	95074	95	11	2
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	01010000206A080000818C1628B93323419A999979EA455A41	950780000	Z	Boissy-l'Aillerie	9507800	95078	95	11	6
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	01010000206A080000DFB0F6CD1D182441000000C036395A41	950880000	Z	Bonneuil-en-France	9508800	95088	95	11	5
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	01060000206A080000010000000103000000010000003300000000000000CFD02341000000E0EE415A419A999999AAD123419A999939FB415A4166666666EAD1234133333393FF415A4100000000C4D22341CDCCCC2C10425A416666666674D32341666666261E425A41CDCCCCCC25D423419A9999D92A425A416666666638D42341666666462B425A41CDCCCCCC2DD62341CDCCCC8C2A425A4100000000ADD62341666666C629425A41CDCCCCCCC1D62341333333B32A425A4166666666D2D62341CDCCCCAC30425A41333333330AD723419A99997938425A413333333315D823416666668645425A4133333333AED82341666666464C425A410000000074D923410000006052425A41CDCCCCCCA8D92341CDCCCCEC3A425A41CDCCCCCCE0DA23419A999919A3415A416666666623DA23419A99997996415A413333333360D923413333337386415A419A9999991ED923416666664678415A4133333333F6D82341CDCCCCEC73415A41CDCCCCCC89D82341000000E062415A41333333336DD823419A99991962415A41666666664FD82341CDCCCCCC64415A41333333334BD823416666666679415A4166666666BCD72341666666666C415A416666666698D72341CDCCCC0C7B415A41666666665DD72341CDCCCC8C7D415A413333333335D723413333337388415A413333333331D723419A99991991415A416666666622D72341000000E093415A41666666665ED723419A99995998415A410000000068D7234100000040A1415A41CDCCCCCC21D723419A9999F9A0415A41666666660ED72341CDCCCC0CA5415A41CDCCCCCC0AD72341CDCCCCCCB0415A419A99999924D72341333333B3B2415A413333333362D72341CDCCCCECBE415A4166666666F3D6234166666666C3415A419A999999D4D52341CDCCCCECCD415A41CDCCCCCC2FD52341CDCCCC8CD2415A413333333303D5234100000080D2415A410000000035D4234100000080D5415A41CDCCCCCC5ED3234166666646D6415A413333333312D3234133333353D7415A41CDCCCCCC85D223419A999999DB415A410000000000D223419A9999F9DD415A41666666665DD12341666666E6DE415A41CDCCCCCCD7D02341CDCCCC6CE7415A4100000000CFD02341000000E0EE415A4100000000CFD02341000000E0EE415A41	01010000206A0800000EE6440787D62341343333A3DA415A41	950910103	H	Hauts Champs	9509101	95091	95	11	1
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	01010000206A080000008BD6BDB1C823413333332332415A41	950910101	H	Village	9509101	95091	95	11	4
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	01060000206A080000010000000103000000010000003000000000000000A7D02341333333935E415A416666666614D123419A9999B966415A4166666666F7D02341CDCCCCCC6E415A41CDCCCCCC75D12341666666E68B415A41333333338DD123419A9999598C415A410000000036D22341CDCCCC0C89415A419A9999995DD22341666666A686415A41CDCCCCCC8BD22341CDCCCC6C8F415A419A99999998D22341CDCCCC2C9E415A41CDCCCCCCB9D223419A999959AD415A419A9999991AD323419A999919B3415A4100000000F4D4234100000020D2415A41CDCCCCCC2FD52341CDCCCC8CD2415A419A999999D4D52341CDCCCCECCD415A4166666666F3D6234166666666C3415A413333333362D72341CDCCCCECBE415A419A99999924D72341333333B3B2415A41CDCCCCCC0AD72341CDCCCCCCB0415A41666666660ED72341CDCCCC0CA5415A41CDCCCCCC21D723419A9999F9A0415A410000000068D7234100000040A1415A41666666665ED723419A99995998415A416666666622D72341000000E093415A413333333331D723419A99991991415A413333333335D723413333337388415A41666666665DD72341CDCCCC8C7D415A416666666698D72341CDCCCC0C7B415A4166666666BCD72341666666666C415A41333333334BD823416666666679415A41666666664FD82341CDCCCCCC64415A41333333336DD823419A99991962415A41CDCCCCCC89D82341000000E062415A41CDCCCCCCFDD72341000000404D415A4166666666C1D723410000002046415A410000000002D72341CDCCCC0C3A415A4166666666A2D623413333333332415A41000000004AD523413333337309415A416666666656D423419A99997927415A419A99999957D423416666662645415A41000000005CD323419A9999F942415A413333333318D323419A99999945415A419A99999987D223416666666630415A410000000033D22341CDCCCC0C38415A413333333353D123419A99993947415A413333333319D12341CDCCCC0C4C415A4100000000C6D023413333337355415A4100000000A7D02341333333935E415A4100000000A7D02341333333935E415A41	01010000206A080000D8B6744B59D42341666666E66D415A41	950910102	H	Trait d'Union	9509101	95091	95	11	0
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	01010000206A080000086F5D6BC91424419A9999A94C3F5A41	950940000	Z	Bouqueval	9509400	95094	95	11	3
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	01010000206A080000A880DCBBD6612241CDCCCC9CE64C5A41	951010000	Z	Bray-et-Lû	9510100	95101	95	11	4
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	01010000206A0800004C4465856A2F234133333333104D5A41	951020000	Z	Bréançon	9510200	95102	95	11	11
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	01010000206A080000BB75FED003012341CCCCCC1C2D4C5A41	951100000	Z	Brignancourt	9511000	95110	95	11	3
01060000206A08000001000000010300000001000000D30000003333333321D32341666666467C505A410000000049D32341666666267E505A419A9999996DD32341000000E07F505A4166666666F0D4234133333353B5505A416666666610D523419A999959B9505A413333333307D52341333333F3B9505A4133333333FBD42341000000E0BB505A419A999999E1D42341CDCCCC0CC2505A41000000009FD4234166666606D4505A419A9999998DD4234166666666D6505A419A99999903D423419A999939E4505A41CDCCCCCCF5D3234166666626E5505A41CDCCCCCCF9D3234166666626E8505A419A99999928D4234133333373FF505A410000000030D42341333333F315515A419A99999998D52341666666660A515A41CDCCCCCC8CD52341CDCCCC4CFC505A4166666666EDD52341CDCCCCECF9505A41CDCCCCCC4CD62341000000E0F7505A4166666666EFD7234100000040EF505A41CDCCCCCC58D82341666666C6EB505A419A999999C1D8234100000020E8505A410000000002D9234133333313E6505A41333333334AD92341000000C0E1505A4100000000EFD9234133333333D8505A416666666651DA234100000040D2505A419A999999B6D923419A999999BA505A41CDCCCCCC23D92341000000609C505A41000000001BDA2341666666668D505A41CDCCCCCCBED92341000000A07C505A413333333373DA23416666664672505A41CDCCCCCC5DDA2341333333136D505A41333333337DDA2341000000806A505A41000000007DDB2341000000C056505A410000000032DB2341CDCCCC8C4A505A410000000074DB2341CDCCCC6C44505A410000000099DB2341CDCCCC2C41505A419A9999999DDB23419A9999F940505A4133333333D1DB23419A9999793C505A41CDCCCCCCF5DB2341666666663A505A4166666666AEDC2341CDCCCCCC34505A41333333338BDC23410000004025505A4166666666CCDC2341CDCCCC0C17505A4133333333FBDC2341333333D314505A419A999999B2DD23419A99997906505A410000000083DD2341CDCCCCCCF54F5A41CDCCCCCCB9DD2341CDCCCC0CF04F5A419A999999C6DD2341CDCCCCECF14F5A4133333333DDDE2341666666E6CC4F5A4133333333DBDF2341CDCCCCACAB4F5A4166666666CDDF234166666686A94F5A419A999999DCDF23419A999919A74F5A416666666689E12341666666266A4F5A413333333329E22341CDCCCCAC524F5A41000000006DE2234133333313454F5A41000000009CE22341333333133D4F5A41CDCCCCCCD5E2234166666686314F5A419A999999F3E22341000000402B4F5A416666666640E32341666666461C4F5A41666666669EE32341000000400A4F5A419A999999C7E32341666666E6014F5A4100000000F6E3234133333393F94E5A41CDCCCCCC02E423419A999979F84E5A41CDCCCCCC72E42341CDCCCC2CE34E5A419A999999DDE4234133333373CF4E5A41CDCCCCCCEEE42341333333B3CC4E5A4100000000E3E4234100000020CB4E5A4100000000DEE4234100000040CA4E5A413333333366E5234133333373B14E5A413333333308E82341CDCCCC0C6A4E5A410000000076E92341CDCCCC0C1E4E5A416666666681E92341000000801B4E5A419A9999997BE92341333333B31A4E5A419A99999997EA2341333333B3DA4D5A4100000000CFEB23419A999979A24D5A416666666609EC2341000000A0994D5A419A9999990FEC2341000000E0984D5A419A99999955EC2341000000608E4D5A4100000000ACEC23419A999959884D5A41CDCCCCCCB1EC2341CDCCCC0C884D5A419A9999996DEC2341CDCCCC2C7F4D5A419A99999953ED2341666666A66C4D5A419A99999937ED2341666666C65F4D5A41333333331BED2341CDCCCCCC4D4D5A410000000014ED234100000080464D5A419A9999990BED2341CDCCCC0C424D5A4100000000CCEC2341000000603D4D5A413333333336EC23419A9999F9314D5A41666666666BEC234100000040294D5A416666666605ED234133333373034D5A410000000026ED2341CDCCCCECFC4C5A419A99999959ED234133333373F64C5A419A9999995BED2341CDCCCC8CF64C5A41CDCCCCCCA6ED2341333333B3EC4C5A419A999999DEED23419A999919F44C5A41000000007FEE234100000000E34C5A41CDCCCCCC8DEE2341CDCCCC8CE24C5A41333333339AEE234166666606E64C5A4133333333FEEE2341CDCCCC6CE04C5A4100000000CBEE2341CDCCCC0CDB4C5A410000000046EF234166666646CE4C5A41CDCCCCCC8EEF23419A999979C64C5A416666666641EF234133333393BD4C5A41CDCCCCCCBFEE2341CDCCCCACB34C5A4166666666E8ED2341333333B3A24C5A419A99999966EC234166666626914C5A419A999999E2EB2341CDCCCC2C8E4C5A4166666666B7EA2341000000608A4C5A410000000099EA2341000000008B4C5A4133333333DFE92341000000C08E4C5A41CDCCCCCC94E82341CDCCCC0C9A4C5A4166666666F4E62341CDCCCCCCA64C5A4133333333DEE52341000000A0AD4C5A4100000000F4E4234133333333AF4C5A41333333333CE423419A999919AB4C5A4166666666E2E32341CDCCCC0CA64C5A419A999999B2E3234166666606A34C5A4133333333F1E2234166666666914C5A41CDCCCCCC59E22341CDCCCC8C804C5A4133333333F2E123419A9999D9744C5A41000000008BE123419A9999B9694C5A419A99999954E12341000000E0634C5A4133333333DAE02341666666C6564C5A419A99999954E02341666666464C4C5A41333333331BE02341666666C6474C5A41CDCCCCCC6FDF2341333333F33E4C5A41CDCCCCCC0FDF2341666666863A4C5A410000000080DE23419A9999F9334C5A419A99999919DE234100000060324C5A41CDCCCCCCC6DD234166666626344C5A419A9999996ADD2341000000C0384C5A410000000018DD2341333333933F4C5A4100000000DEDC234166666666464C5A41000000006ADC2341333333B3554C5A4133333333F6DB23419A9999F9684C5A4133333333A9DB2341CDCCCC8C764C5A416666666644DB2341666666268D4C5A41333333331DDB23419A9999F9974C5A41CDCCCCCCF2DA2341000000C0A34C5A4133333333ADDA234133333373B64C5A410000000048DA2341000000E0CE4C5A4166666666F4D9234166666646E24C5A4100000000A4D92341CDCCCCECF04C5A410000000073D9234100000080F84C5A419A99999941D9234133333313FE4C5A4166666666E8D8234100000080044D5A41333333334DD82341666666060B4D5A419A999999D1D72341000000000E4D5A4100000000DAD623419A9999F9104D5A4166666666C4D523419A999939144D5A4100000000DBD4234166666626194D5A419A99999997D42341333333531B4D5A419A999999B1D423419A999939264D5A419A999999B4D4234133333393274D5A4166666666B9D423419A9999392A4D5A41CDCCCCCC32D52341000000E05F4D5A416666666637D5234166666646624D5A41CDCCCCCC1CD52341CDCCCC8C614D5A41CDCCCCCCF5D4234133333313644D5A416666666655D52341000000208A4D5A419A99999959D52341333333D38B4D5A419A9999995AD52341666666268C4D5A41333333335FD52341666666E68B4D5A41CDCCCCCC6DD52341000000208B4D5A41333333338CD52341CDCCCC8C894D5A41333333338DD52341333333538C4D5A41666666668DD523419A9999798C4D5A41333333338FD52341333333B3904D5A4166666666A0D523419A999919B94D5A41CDCCCCCCB1D5234100000080E14D5A4133333333C3D52341333333F3094E5A4100000000BFD52341333333930E4E5A41666666661BD523419A999939124E5A419A9999992BD52341666666062A4E5A41666666662ED52341CDCCCC4C2D4E5A419A99999933D52341000000C0344E5A419A99999937D52341333333533A4E5A419A99999948D5234166666666524E5A41333333334ED52341666666465A4E5A413333333363D5234100000020784E5A413333333343D52341CDCCCCAC784E5A413333333344D523419A999919804E5A41CDCCCCCC44D52341000000E0834E5A419A99999945D52341333333538B4E5A419A9999994AD52341666666A6B04E5A41666666664CD52341CDCCCCCCBD4E5A41CDCCCCCC4CD52341000000E0C04E5A413333333342D52341CDCCCCECDE4E5A41666666663AD5234133333393F54E5A410000000033D52341CDCCCC2C0A4F5A416666666630D52341CDCCCCEC114F5A41666666662ED5234100000020174F5A41666666662CD52341000000001D4F5A416666666626D52341666666662E4F5A413333333323D52341000000C0354F5A419A99999970D5234166666666374F5A41CDCCCCCC15D62341000000E0384F5A4133333333D1D52341000000C0674F5A416666666674D52341CDCCCCCCA84F5A410000000067D52341CDCCCCACB44F5A41000000005FD52341000000E0BB4F5A41666666665ED5234100000040BC4F5A419A99999950D52341333333B3C84F5A41CDCCCCCC4ED5234166666666CA4F5A416666666646D52341666666A6D14F5A413333333335D52341000000E0E04F5A416666666663D5234133333313E54F5A41CDCCCCCCA2D423419A99997917505A41CDCCCCCCE1D32341000000E049505A41333333332DD323419A99991979505A413333333321D32341666666467C505A41	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	01010000206A080000360EC502B3DD2341CCCCCCFC9D4E5A41	951160000	Z	Bruyères-sur-Oise	9511600	95116	95	11	9
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	01010000206A080000C1FB5A9099792241CDCCCCDC51525A41	951190000	Z	Buhy	9511900	95119	95	11	7
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	01010000206A08000070CD9E93138E23419A999939EC455A41	951200000	Z	Butry-sur-Oise	9512000	95120	95	11	3
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	01060000206A08000001000000010300000001000000260000009A9999993D4B2341CDCCCCCC0C415A4100000000984B2341000000C011415A4133333333E64C2341CDCCCCCC26415A419A9999999B4D2341333333B330415A4166666666A24D23410000008032415A41CDCCCCCC8B4E23416666660643415A4100000000F34E2341CDCCCC4C4D415A41CDCCCCCC574F2341000000C05A415A41333333339A4F23413333339360415A4133333333B84F2341CDCCCC2C61415A419A9999990D5023419A9999396E415A4133333333C5502341666666E65B415A4166666666565223419A9999593A415A410000000084532341CDCCCC8C24415A419A99999932532341CDCCCC8C19415A419A999999925223410000004001415A419A999999D551234100000080E6405A419A999999D450234100000080C0405A4100000000D050234166666646BE405A41CDCCCCCC5B50234100000020AD405A4100000000D44F2341CDCCCCCC9E405A41CDCCCCCC894F23413333331399405A419A999999244F23419A9999B992405A4166666666914E2341000000208C405A41333333333C4E2341CDCCCC0CAB405A41000000003D4E23419A999979B0405A419A9999995A4E234133333393B6405A4166666666D44E2341666666A6C4405A419A999999104E234133333333DF405A4100000000BB4D23419A999999EB405A419A999999204D234133333333FF405A419A999999D54C2341CDCCCCEC09415A4166666666564C2341333333F3FA405A4166666666294C234166666666F7405A41CDCCCCCCE24B234100000080F7405A41CDCCCCCCC94B234133333333F9405A419A9999993D4B2341CDCCCCCC0C415A419A9999993D4B2341CDCCCCCC0C415A41	01010000206A08000006963465D24F234166666616FE405A41	951270104	H	Préfecture	9512701	95127	95	11	0
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	01060000206A0800000100000001030000000100000025000000CDCCCCCC04462341333333737E405A41333333331D4623419A9999397F405A419A9999999D4623413333335389405A419A99999966472341CDCCCC6C9B405A4100000000BB472341333333F3A4405A41CDCCCCCCFA48234100000040D2405A41CDCCCCCCC449234100000060EC405A4166666666694A23419A999939FD405A41000000001C4B2341CDCCCC0C0B415A419A9999993D4B2341CDCCCCCC0C415A41CDCCCCCCC94B234133333333F9405A41CDCCCCCCE24B234100000080F7405A4166666666294C234166666666F7405A4166666666564C2341333333F3FA405A419A999999D54C2341CDCCCCEC09415A419A999999204D234133333333FF405A4100000000BB4D23419A999999EB405A419A999999104E234133333333DF405A4166666666D44E2341666666A6C4405A419A9999995A4E234133333393B6405A41000000003D4E23419A999979B0405A41333333333C4E2341CDCCCC0CAB405A4166666666914E2341000000208C405A4166666666B74D23416666660682405A4100000000B54C2341CDCCCC8C76405A41666666665F4C23416666664672405A419A9999993A4B23419A99991965405A4133333333DB4A2341CDCCCCCC5F405A41CDCCCCCC3D4A23413333331354405A4166666666AF492341CDCCCC4C47405A41666666660B4923419A9999B937405A41CDCCCCCCE64723419A9999B94E405A41CDCCCCCC324723419A9999D95A405A4100000000DA4623413333335362405A419A9999996E462341000000806D405A41CDCCCCCC04462341333333737E405A41CDCCCCCC04462341333333737E405A41	01010000206A08000016C96458FE4A234166666666A3405A41	951270105	H	Chemin Dupuis-Paradis	9512701	95127	95	11	1
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	01060000206A080000010000000103000000010000002200000033333333C344234166666686DD415A41333333330C452341666666E6F1415A41CDCCCCCC31452341666666C6F9415A4166666666504523416666664603425A41666666667C4523419A9999D907425A416666666683452341666666260B425A4166666666374623419A9999B90C425A419A9999999A462341CDCCCCAC0C425A419A9999990A472341000000600A425A41CDCCCCCCB2472341333333D304425A416666666614482341CDCCCCACFF415A416666666697482341333333F3F6415A419A999999CE48234166666686ED415A419A9999992149234100000040E8415A41333333336D492341666666A6DE415A4133333333CD492341000000A0CD415A4100000000F449234100000020C3415A41333333338F4A2341666666A6A1415A4133333333114A2341333333D39B415A41666666663E492341000000C08F415A416666666615492341CDCCCC6C8E415A419A999999CB482341CDCCCC2C8F415A4133333333AD482341333333F390415A41CDCCCCCCDD47234133333353A5415A413333333388472341666666E6AC415A419A9999992B4723419A999999B2415A419A999999C34623419A999999B6415A41CDCCCCCC6A462341CDCCCCECB7415A4133333333EB452341666666E6B6415A41666666666245234166666626B2415A41000000003D45234133333313BF415A419A999999E9442341CDCCCC2CD2415A4133333333C344234166666686DD415A4133333333C344234166666686DD415A41	01010000206A08000035FD50D371472341CDCCCC8CCA415A41	951270111	H	Les Linandes	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000004600000000000000D2452341CDCCCC4CEB3F5A41CDCCCCCC554623419A999919F73F5A41CDCCCCCCB5472341CDCCCC6C17405A4133333333F24823410000000036405A41666666660B4923419A9999B937405A4166666666AF492341CDCCCC4C47405A41CDCCCCCC3D4A23413333331354405A4133333333DB4A2341CDCCCCCC5F405A419A9999993A4B23419A99991965405A4166666666F34B2341000000A06D405A41CDCCCCCC124C2341CDCCCCEC62405A4100000000584C23410000002057405A4100000000904C2341CDCCCCAC53405A41CDCCCCCCD54C23410000008051405A41666666661B4D2341CDCCCCAC51405A4166666666604D2341CDCCCC6C54405A41666666667C4D2341666666E649405A41CDCCCCCC6C4D23416666666642405A4100000000BB4C23413333331301405A41333333339E4C234133333313FF3F5A419A999999D44D234100000040EA3F5A4166666666C74E2341333333D3DA3F5A4133333333614F2341000000A0D03F5A413333333336502341CDCCCC4CC33F5A4133333333CF50234166666686BB3F5A413333333307522341666666A6AF3F5A41666666660B5223419A999979B13F5A419A9999998B52234133333353C33F5A4133333333C6532341000000E0F03F5A419A9999990354234100000000FC3F5A413333333394542341666666E619405A4133333333D85423416666668624405A41CDCCCCCC21552341666666062C405A41333333335F552341CDCCCCAC1C405A419A99999950552341CDCCCC4C18405A416666666666552341CDCCCC4C0F405A419A999999745523416666666601405A410000000070552341000000E0EF3F5A413333333356552341333333F3DC3F5A4133333333355523419A999999CE3F5A4166666666F65423419A999999B83F5A4100000000CA54234100000000AE3F5A419A9999990F552341666666C6A93F5A4166666666E75423419A9999399D3F5A413333333344552341CDCCCC4C993F5A4166666666F554234100000060803F5A41000000007954234133333393613F5A41000000004A5423419A999919553F5A41CDCCCCCCF653234166666666453F5A41333333338A532341CDCCCCEC383F5A41CDCCCCCCB952234166666646273F5A41000000003A5223419A9999591F3F5A41CDCCCCCC874F23419A9999B9083F5A4133333333D34E234133333353023F5A4133333333414E2341CDCCCC4C023F5A4133333333F74D234166666666043F5A4100000000814D23419A999959093F5A419A999999C44C23419A999919133F5A41333333335A4B234100000080273F5A4166666666D8492341CDCCCCEC403F5A410000000051492341333333934A3F5A419A999999E5482341CDCCCC2C533F5A41666666668A482341666666465C3F5A41CDCCCCCC13482341666666E66D3F5A41CDCCCCCCC44723419A9999F97C3F5A419A99999907472341CDCCCC2CA43F5A41333333339D462341CDCCCCCCBB3F5A4166666666F84523419A9999F9E63F5A4100000000D2452341CDCCCC4CEB3F5A4100000000D2452341CDCCCC4CEB3F5A41	01010000206A080000D01E8202024C23419A9999A9B63F5A41	951270101	H	Clairières-Châteaux-Zone Agricole	9512701	95127	95	11	2
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	01060000206A0800000100000001030000000100000029000000333333339E4C234133333313FF3F5A4100000000BB4C23413333331301405A41CDCCCCCC6C4D23416666666642405A41666666667C4D2341666666E649405A4166666666604D2341CDCCCC6C54405A4133333333B44D2341666666A658405A41333333332A4E2341CDCCCC0C5B405A4133333333A54E23419A99991957405A4166666666394F2341CDCCCC2C46405A4166666666744F23419A99995943405A4133333333B84F23416666666642405A4133333333135023410000000045405A4100000000A75023419A9999594F405A419A999999D6502341666666A650405A410000000012512341000000604F405A4100000000305123416666664651405A41CDCCCCCC54512341CDCCCC4C4B405A419A9999997C512341666666C640405A419A9999999F512341CDCCCCEC26405A41CDCCCCCCAA5123419A99997922405A4133333333D8512341333333B319405A41666666662B5223410000008012405A4133333333965223416666664610405A41CDCCCCCCD05223416666664611405A41CDCCCCCC2C532341333333B317405A419A9999995C532341666666C61E405A419A9999998B532341666666861A405A41333333332C5423413333331318405A41CDCCCCCC725423416666662613405A419A9999990354234100000000FC3F5A4133333333C6532341000000E0F03F5A419A9999998B52234133333353C33F5A41666666660B5223419A999979B13F5A413333333307522341666666A6AF3F5A4133333333CF50234166666686BB3F5A413333333336502341CDCCCC4CC33F5A4133333333614F2341000000A0D03F5A4166666666C74E2341333333D3DA3F5A419A999999D44D234100000040EA3F5A41333333339E4C234133333313FF3F5A41333333339E4C234133333313FF3F5A41	01010000206A080000FEFC502A88502341CCCCCCAC08405A41	951270102	H	Touleuses-Bocages	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000001E00000066666666F34B2341000000A06D405A419A999999244F23419A9999B992405A41CDCCCCCC894F23413333331399405A4100000000D44F2341CDCCCCCC9E405A41CDCCCCCC5B50234100000020AD405A4100000000D050234166666646BE405A419A999999D450234100000080C0405A416666666646512341666666E6B0405A41CDCCCCCCB6512341666666A6A2405A41333333334B522341CDCCCCCC92405A41CDCCCCCCCA5123419A99997984405A41666666669E512341666666067C405A410000000057512341CDCCCC8C5C405A41000000002B512341CDCCCCEC4F405A419A999999D6502341666666A650405A4100000000A75023419A9999594F405A4133333333135023410000000045405A4133333333B84F23416666666642405A4166666666744F23419A99995943405A4166666666394F2341CDCCCC2C46405A4133333333A54E23419A99991957405A41333333332A4E2341CDCCCC0C5B405A4133333333B44D2341666666A658405A41666666661B4D2341CDCCCCAC51405A41CDCCCCCCD54C23410000008051405A4100000000904C2341CDCCCCAC53405A4100000000584C23410000002057405A41CDCCCCCC124C2341CDCCCCEC62405A4166666666F34B2341000000A06D405A4166666666F34B2341000000A06D405A41	01010000206A080000FC83D2FBA64F2341333333B380405A41	951270103	H	Plants-I.U.F.M.	9512701	95127	95	11	0
01060000206A0800000100000001030000000100000098010000CDCCCCCCAC362341CDCCCCEC10415A4100000000B4362341000000E011415A41CDCCCCCCC9362341CDCCCCAC14415A4100000000D63623416666664616415A41CDCCCCCCE0362341666666A617415A41CDCCCCCC06372341333333931C415A410000000013372341333333531E415A41000000001E3723416666664620415A419A9999994F372341000000A02A415A41666666666E372341CDCCCC2C30415A4133333333AB3723419A9999193A415A41CDCCCCCCC1372341000000203E415A4166666666D4372341CDCCCCEC42415A4133333333EA3723419A9999B947415A419A999999093823419A9999394D415A41CDCCCCCC19382341000000C04F415A419A9999992E3823413333331353415A4166666666373823410000004054415A413333333386382341333333535D415A41CDCCCCCCD33823410000002066415A4100000000E8382341666666C668415A413333333305392341000000E06C415A419A9999990A392341000000C06D415A410000000026392341333333F371415A416666666631392341666666A673415A41333333334A392341CDCCCC8C77415A4166666666983923416666666683415A4166666666A93923410000000086415A41CDCCCCCCB1392341666666E686415A41CDCCCCCCBA3923410000008087415A419A999999BE392341666666268A415A419A999999C2392341666666468B415A419A999999F13923416666660692415A41CDCCCCCC093A23410000008095415A4166666666B5392341333333F39E415A4166666666903923419A999939A5415A41CDCCCCCC73392341000000C0A9415A41CDCCCCCC67392341666666A6AB415A419A99999962392341000000A0AC415A41000000005B392341CDCCCC0CAE415A416666666637392341000000A0AB415A419A999999ED382341CDCCCCECA6415A419A999999E6382341333333B3A6415A41CDCCCCCC0239234166666666AA415A41333333332C39234100000040AE415A41CDCCCCCC5339234133333353B1415A41CDCCCCCC9139234100000020B6415A41CDCCCCCCD7392341CDCCCCACBA415A41666666665F3A2341000000E0C3415A41CDCCCCCC973A234133333313C8415A41CDCCCCCC413B234133333353D5415A4166666666913B23419A999959DB415A4166666666AA3B234133333313DD415A41CDCCCCCCCA3B234100000000DF415A4166666666F43B2341666666E6E1415A419A999999073C2341CDCCCC8CE1415A4166666666123C234100000060E1415A419A999999203C2341666666C6E3415A4100000000253C2341333333F3E4415A4133333333263C2341CDCCCCECE5415A419A9999995C3C234100000020E5415A419A999999A43C234166666626E4415A41CDCCCCCCFB3C23419A9999B9E3415A4100000000363D2341333333D3E3415A41000000005E3D2341333333F3E3415A4166666666813D23419A999919E4415A4100000000853D2341CDCCCCACE3415A41666666668F3D234166666626E3415A41000000009A3D234100000040E3415A41CDCCCCCCA03D2341333333B3E3415A419A999999A63D234133333393E4415A4133333333BC3D2341000000E0E4415A41CDCCCCCC363E2341CDCCCCECE4415A41333333336A3E2341CDCCCC8CE4415A41CDCCCCCC9B3E2341333333D3E3415A4166666666DC3E2341CDCCCC4CE3415A41CDCCCCCC363F234100000020E2415A4133333333A53F2341CDCCCC2CDF415A419A999999CF3F2341333333B3DD415A41000000003640234100000040DA415A41666666664240234133333373DA415A419A9999994A40234133333333DB415A41000000004F402341333333F3DB415A41CDCCCCCC4B402341666666C6DC415A41666666664B402341CDCCCCACDE415A41000000004E40234133333393DF415A419A999999514023419A999939E0415A413333333356402341CDCCCC6CE0415A4100000000624023419A9999B9E0415A41000000006B4023419A999999E0415A4133333333724023419A999919E0415A41000000007640234100000060DF415A419A99999979402341CDCCCCCCDD415A4100000000774023419A999999DC415A419A9999997340234100000000DC415A413333333386402341CDCCCC4CDB415A41000000008940234100000040DB415A4100000000F140234166666626D4415A4166666666F6402341000000C0D3415A41666666662041234133333373D1415A41CDCCCCCC36412341CDCCCC6CD0415A4133333333424123419A9999D9CF415A41666666666441234133333353CE415A419A999999AB4123419A9999D9CA415A41CDCCCCCC88422341CDCCCCECBF415A4166666666A842234100000060BE415A4133333333C1422341CDCCCC2CBD415A4133333333D64223419A999919BC415A41CDCCCCCCF84223419A999959BA415A41333333333D43234100000020B7415A41333333339C43234133333353B2415A4166666666CD432341CDCCCC6CAF415A4133333333E8432341CDCCCC4CAE415A4133333333F8432341333333D3AD415A4133333333014423419A9999B9AA415A41CDCCCCCC1944234100000040A9415A41CDCCCCCC9644234166666606A3415A4100000000BB44234133333373A0415A4100000000E3442341CDCCCCCC9C415A4166666666014523410000004099415A4166666666214523416666668694415A41333333332A4523416666668692415A419A99999932452341666666C690415A416666666681452341CDCCCC4C91415A4100000000C0452341666666A691415A4133333333184623419A99997991415A41333333333E4623416666664691415A419A999999574623419A9999D990415A4133333333774623410000006090415A41000000008A462341000000E08F415A413333333356462341000000C084415A419A999999334623419A9999D97E415A41666666660F4623419A9999F978415A419A999999D5452341666666C66F415A4166666666BA4523419A9999796B415A4133333333B5452341666666A66A415A4100000000A04523419A9999F967415A4133333333C5452341333333D357415A41CDCCCCCC15462341CDCCCC8C34415A41666666661D462341CDCCCC0C31415A41333333331E4623419A9999B930415A4133333333254623419A9999D92D415A41333333334B462341333333B31C415A41666666664B462341000000A01C415A41000000005F4623416666666613415A410000000068462341333333730F415A41CDCCCCCC7F4623416666662605415A41333333338C462341333333D300415A4166666666954623416666660601415A4133333333A04623416666660601415A419A999999AA4623419A9999D900415A4100000000B44623416666664600415A4166666666C846234133333313FE405A4100000000D546234100000060FC405A4100000000EA46234100000020FA405A41333333330747234100000060F8405A41CDCCCCCC1E472341333333F3F7405A4133333333264723419A9999F9F7405A41000000002A4723419A9999F9F7405A419A9999994B472341CDCCCCACF8405A413333333357472341CDCCCC2CF9405A416666666663472341CDCCCCECF9405A419A999999BC472341CDCCCC0CFF405A4100000000C347234100000060FF405A41CDCCCCCCEE4723419A99999901415A4133333333354823416666668605415A419A999999574823413333335307415A41333333336E4823410000002008415A416666666678482341CDCCCC0C04415A41000000007F4823419A9999D901415A41000000008E48234133333313FE405A4133333333CD4823419A999999EF405A4100000000DA482341CDCCCCACEC405A41333333339D48234133333313EB405A4166666666434823419A999919E8405A4133333333DB4723419A999999E4405A419A999999CC472341000000E0E3405A41000000007F472341CDCCCCECDF405A419A99999948472341CDCCCCECDC405A41333333339247234166666686CF405A41CDCCCCCCA4472341CDCCCC6CCC405A419A999999B04723419A9999D9CA405A4166666666C547234166666626C8405A41CDCCCCCCD547234100000040C5405A419A999999E6472341666666E6C2405A4100000000FD47234166666666C1405A413333333338482341000000C0BF405A41666666664848234133333313BF405A41000000005B482341666666A6BE405A41CDCCCCCC68482341000000C0BD405A416666666622482341000000A0B3405A41CDCCCCCCEA472341333333B3AB405A41CDCCCCCCDF4723419A999919AA405A4100000000BB472341333333F3A4405A41000000009247234166666666A0405A419A99999966472341CDCCCC6C9B405A4100000000344723410000002097405A4100000000004723416666660692405A41CDCCCCCCB54623419A9999798B405A419A9999999D4623413333335389405A41333333331D4623419A9999397F405A41CDCCCCCC04462341333333737E405A41666666661D462341CDCCCCCC7A405A41CDCCCCCC63462341CDCCCCEC6E405A419A9999996E462341000000806D405A419A99999981462341CDCCCC8C6B405A4100000000DA4623413333335362405A419A999999FD4623419A9999F95E405A41CDCCCCCC324723419A9999D95A405A41CDCCCCCC46472341000000C059405A4166666666584723419A9999B958405A41CDCCCCCC804723410000002056405A4166666666C24723410000006051405A41CDCCCCCCE64723419A9999B94E405A4166666666C1482341CDCCCC6C3D405A4166666666FF482341333333F339405A41666666660B4923419A9999B937405A4133333333F24823410000000036405A419A999999634823419A99991928405A41CDCCCCCC60482341333333D327405A419A999999554823419A9999B926405A419A99999954482341000000A026405A413333333342482341666666E624405A41000000000B4823419A9999991F405A4133333333F9472341000000E01D405A4166666666F8472341CDCCCCCC1D405A4100000000F7472341CDCCCCAC1D405A419A999999E4472341CDCCCCEC1B405A41CDCCCCCCB5472341CDCCCC6C17405A41666666660C472341000000E007405A41CDCCCCCC554623419A999919F73F5A41000000004D46234166666646F63F5A41333333333346234166666626F43F5A419A9999992746234133333333F33F5A419A999999194623419A999919F23F5A41CDCCCCCC1846234166666606F23F5A4100000000D2452341CDCCCC4CEB3F5A4100000000E24523419A999979E93F5A4166666666F84523419A9999F9E63F5A41333333339D462341CDCCCCCCBB3F5A419A99999907472341CDCCCC2CA43F5A41CDCCCCCCC44723419A9999F97C3F5A41CDCCCCCC13482341666666E66D3F5A41666666668A482341666666465C3F5A419A999999E5482341CDCCCC2C533F5A410000000051492341333333934A3F5A4166666666D8492341CDCCCCEC403F5A41333333335A4B234100000080273F5A419A999999C44C23419A999919133F5A41CDCCCCCC004D23419A999959103F5A4166666666E24C23419A999959083F5A4166666666DC4C23419A9999B9063F5A4133333333AA4C234166666686F93E5A419A9999998D4C2341333333F3F13E5A41CDCCCCCC4A4C23419A999919F43E5A41333333331A4C2341CDCCCC0CF63E5A4100000000D74B234166666646F93E5A4133333333A34B234133333313FB3E5A41CDCCCCCC704B23419A9999D9FD3E5A41333333333A4B23419A999959003F5A4100000000054B234166666606033F5A419A999999C14A234133333393053F5A419A999999814A2341CDCCCC6C073F5A4100000000614A2341666666A6083F5A4100000000ED4923419A9999990D3F5A4133333333D0492341666666260F3F5A4166666666B949234166666646113F5A41CDCCCCCC92492341000000A0163F5A41CDCCCCCC7949234133333393193F5A41CDCCCCCC02492341666666C6283F5A41000000009D4823419A999959343F5A41000000007F48234133333393373F5A419A999999FA47234100000020453F5A4166666666FC46234100000000633F5A41CDCCCCCCD8462341000000E0673F5A419A999999B8462341666666866D3F5A41333333339F462341666666C6723F5A41000000008A46234166666606763F5A41000000006A462341CDCCCC6C7B3F5A416666666653462341CDCCCCEC7E3F5A41333333331E4623419A999939853F5A41000000000A4623419A999919843F5A419A999999F04523419A9999D9853F5A419A9999999945234100000080903F5A410000000082452341CDCCCC0C953F5A41666666664645234100000020A23F5A4133333333EF442341000000C0AD3F5A41CDCCCCCC9344234100000080B93F5A4100000000804423419A999939BD3F5A41000000007B44234166666666BF3F5A41666666667D44234100000080C13F5A419A99999975442341CDCCCC0CC33F5A419A9999996F442341CDCCCC4CC43F5A4100000000604423419A999959C73F5A41333333334B442341CDCCCC4CCA3F5A41666666663F442341CDCCCCECCB3F5A419A99999912442341CDCCCC2CC73F5A41000000000B442341CDCCCCACC63F5A4166666666F4432341CDCCCC8CC53F5A4166666666CE43234166666626C33F5A41CDCCCCCCBA432341CDCCCC6CC13F5A41CDCCCCCCAB4323419A999979C03F5A4166666666A343234100000080BF3F5A41666666668D43234133333393BD3F5A410000000085432341CDCCCC2CBC3F5A41333333337C432341CDCCCCECBA3F5A419A9999995B43234100000040B73F5A41333333332B432341CDCCCC2CB13F5A41CDCCCCCC3B4323419A9999D9AE3F5A410000000031432341CDCCCC8CAD3F5A410000000017432341CDCCCCCCA83F5A410000000007432341666666A6A63F5A4100000000FD42234100000000A53F5A4100000000EE422341666666E6A33F5A41333333330A432341333333F39E3F5A4166666666AE4223419A9999D9903F5A413333333395422341000000008B3F5A41000000008442234100000000873F5A41CDCCCCCC8242234100000080853F5A413333333380422341333333D3823F5A41333333337F422341CDCCCC8C813F5A41666666667C422341000000607E3F5A416666666679422341333333B37D3F5A41000000005E42234133333313773F5A416666666626422341666666C6793F5A413333333305422341000000607B3F5A41CDCCCCCCF04123419A9999597C3F5A41000000008D4123419A999939813F5A41666666667141234133333393823F5A4100000000904123419A9999B9883F5A413333333356412341333333938C3F5A41000000001E412341666666A6913F5A419A999999FD402341000000C0943F5A4166666666DE402341666666C6973F5A41CDCCCCCCD1402341CDCCCC0C993F5A41CDCCCCCCC34023419A9999799A3F5A41CDCCCCCCAB402341666666069D3F5A4133333333984023419A9999199F3F5A419A999999664023419A999959A43F5A41CDCCCCCC1340234133333393AC3F5A41CDCCCCCC12402341CDCCCCACAC3F5A419A999999C53F2341333333B3B43F5A41CDCCCCCCC03F2341CDCCCC2CB53F5A4166666666B03F2341333333F3B63F5A4166666666A83F2341666666A6B73F5A4133333333A43F2341333333F3B73F5A41CDCCCCCC9C3F234133333393B83F5A419A999999943F234100000040B93F5A4166666666803F2341000000A0BB3F5A419A999999B63E2341CDCCCC6CD33F5A419A999999B23E2341666666E6D33F5A41CDCCCCCC9B3E23419A999999D63F5A419A999999823E234133333393D93F5A41000000007E3E234100000060DA3F5A41666666666C3E2341CDCCCC8CDD3F5A41666666665B3E23419A999999E03F5A41CDCCCCCC203E2341CDCCCC0CEB3F5A41000000001D3E2341CDCCCC6CEB3F5A4166666666043E2341CDCCCCECED3F5A4166666666E83D2341666666C6F03F5A4133333333D53D2341333333B3F23F5A4166666666713D2341666666C6FC3F5A41000000009C3D2341CDCCCC2C04405A4133333333E63D23416666660611405A41333333330B3E2341CDCCCC6C17405A4100000000FC3D2341333333D318405A4133333333DA3D2341000000E01B405A41CDCCCCCCB03D2341666666A61F405A4133333333AB3D23416666662620405A4133333333A53D23419A99995920405A4166666666903D23413333339322405A4100000000143D2341000000E02D405A41CDCCCCCCF93C23410000004030405A419A999999CE3C23413333333334405A41666666665E3C2341000000603E405A4100000000133C23419A99993945405A4133333333FF3B23416666660647405A4133333333B73B2341333333934D405A41CDCCCCCC9A3B23416666662650405A4133333333993A23416666668667405A419A999999823A23419A99999969405A419A999999713A2341666666266B405A419A999999013A23413333335375405A4133333333F8392341CDCCCC2C76405A41CDCCCCCCA73923419A9999797D405A41000000009A392341333333B37E405A413333333387392341CDCCCC6C80405A410000000034382341000000409F405A41CDCCCCCCF13723419A999939A5405A41CDCCCCCCD9372341CDCCCC6CA7405A4133333333C437234166666666A9405A41CDCCCCCC9F372341333333B3AC405A419A9999998E37234166666646AE405A419A99999955372341CDCCCC6CB3405A419A99999930382341CDCCCC6CDD405A4133333333053823419A999939E3405A4166666666F63723419A999939E5405A41CDCCCCCCC637234133333373EB405A41000000006337234100000000F9405A41CDCCCCCC243723419A99995901415A419A9999990C3723419A99999904415A419A999999013723419A9999F905415A4100000000F3362341000000C007415A4166666666E63623416666666609415A41CDCCCCCCDF3623419A9999390A415A4100000000D2362341000000000C415A4100000000B03623413333335310415A41CDCCCCCCAC362341CDCCCCEC10415A41	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	01010000206A080000F07D4D486D402341666666866C405A41	951270106	H	Port Ham-Village	9512701	95127	95	11	4
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	01060000206A080000010000000103000000010000001C0000009A99999948472341CDCCCCECDC405A4133333333DB4723419A999999E4405A4100000000DA482341CDCCCCACEC405A41000000007F4823419A9999D901415A419A99999965482341CDCCCC0C11415A4100000000724823419A9999792D415A419A999999804823419A99991933415A4133333333AE482341CDCCCCCC3C415A4100000000F94823419A9999D944415A41CDCCCCCC4F4923410000002046415A41000000007E4923416666666644415A4100000000144A2341CDCCCC8C38415A41CDCCCCCC794A2341333333B32E415A4133333333E84A2341333333D33B415A4166666666FE4A23419A9999593C415A4166666666304B2341000000E042415A41CDCCCCCC944B2341CDCCCC8C35415A4166666666254C2341000000801E415A419A999999644B23413333335312415A41000000001C4B2341CDCCCC0C0B415A4166666666694A23419A999939FD405A41CDCCCCCCC449234100000060EC405A41CDCCCCCCFA48234100000040D2405A41CDCCCCCC68482341000000C0BD405A419A999999E6472341666666E6C2405A41CDCCCCCCA4472341CDCCCC6CCC405A419A99999948472341CDCCCCECDC405A419A99999948472341CDCCCCECDC405A41	01010000206A0800000A3E633897492341343333F302415A41	951270107	H	Croix Petit-Chênes d'Or	9512701	95127	95	11	0
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	01060000206A0800000100000001030000000100000032000000CDCCCCCC193C234133333333AE425A41333333333C3C23419A999959B4425A41000000004E3C234133333313D4425A41000000002D3C2341666666E6DD425A4100000000503C2341000000C0DD425A4166666666613C23413333333306435A41CDCCCCCC763C23416666668618435A4133333333733E23410000006007435A419A9999996B41234100000060ED425A419A9999999642234166666666E2425A413333333316432341333333B3D9425A41666666661E432341000000A0D5425A419A999999464423419A9999B9C5425A41333333335C452341CDCCCC8CB4425A4100000000B245234166666626AE425A41CDCCCCCCDB452341666666A6A9425A41333333336C46234100000060A2425A41333333331A4723419A99995997425A4133333333BF472341CDCCCC0C87425A4100000000C94823419A99997968425A4100000000464923413333331358425A41CDCCCCCCE84A2341666666061C425A41333333334F4A2341333333730C425A4133333333FE492341CDCCCCEC06425A413333333351492341CDCCCCACFC415A410000000001492341CDCCCCCCF4415A419A999999E1482341CDCCCC8CF5415A4100000000C548234133333393F0415A416666666697482341333333F3F6415A416666666614482341CDCCCCACFF415A41CDCCCCCCB2472341333333D304425A419A9999990A472341000000600A425A419A9999999A462341CDCCCCAC0C425A4166666666374623419A9999B90C425A416666666651452341000000E00A425A413333333397442341333333F30B425A41666666665F412341000000001D425A41000000004C3F23413333335328425A41CDCCCCCC643F23410000006039425A41CDCCCCCC483E23419A9999393E425A41CDCCCCCC403E2341000000C03E425A419A999999C43D23419A9999395C425A419A999999533D2341666666467A425A4133333333E73C2341000000809D425A4166666666DD3C23419A9999B9A2425A4166666666793C23419A9999B9A5425A41666666666E3C2341333333D3AA425A4133333333523C23419A999919AE425A41CDCCCCCC193C234133333333AE425A41CDCCCCCC193C234133333333AE425A41	01010000206A0800002628B35186422341CDCCCC6C84425A41	951270108	D	Zone Agricole	9512701	95127	95	11	1
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	01060000206A080000010000000103000000010000002200000000000000C548234133333393F0415A419A999999E1482341CDCCCC8CF5415A410000000001492341CDCCCCCCF4415A413333333351492341CDCCCCACFC415A4133333333FE492341CDCCCCEC06425A41333333334F4A2341333333730C425A41CDCCCCCCE84A2341666666061C425A4133333333204C2341666666C6EE415A419A999999454D234166666666C5415A4166666666424E23419A9999B9A3415A4133333333B74E23413333339394415A41CDCCCCCC464F23419A99993983415A4100000000A74F23419A99997978415A419A9999990D5023419A9999396E415A4133333333B84F2341CDCCCC2C61415A41333333339A4F23413333339360415A41CDCCCCCC574F2341000000C05A415A4100000000F34E2341CDCCCC4C4D415A41CDCCCCCC8B4E23416666660643415A4166666666A24D23410000008032415A41333333337B4D2341CDCCCCCC30415A419A9999994E4D2341000000A038415A41333333335A4C2341CDCCCC0C5A415A419A999999854B23410000008076415A41000000003D4B23413333333381415A41CDCCCCCCFB4A2341333333338C415A4100000000854A2341CDCCCC0CA4415A4100000000F449234100000020C3415A4133333333CD492341000000A0CD415A41333333336D492341666666A6DE415A419A9999992149234100000040E8415A419A999999CE48234166666686ED415A4100000000C548234133333393F0415A4100000000C548234133333393F0415A41	01010000206A0800006671D7A4544C234166666656A6415A41	951270109	A	Cité Artisanale-Chauffours	9512701	95127	95	11	0
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	01010000206A0800003C050CDA12492341000000F058415A41	951270110	H	Reste des Chênes-Le Ponceau	9512701	95127	95	11	0
01060000206A080000010000000103000000010000003300000033333333072F23410000008052425A41CDCCCCCC092F23410000000054425A419A999999222F23413333331366425A4100000000422F2341333333D37E425A419A999999452F23416666666681425A41CDCCCCCC452F23413333339381425A419A9999994A2F23410000004085425A41CDCCCCCC4A2F2341CDCCCC6C85425A41CDCCCCCC652F23416666664685425A4133333333FA2F2341CDCCCC4C82425A41CDCCCCCC8F3023419A9999397F425A4166666666A0302341333333D37E425A4166666666B5302341666666667E425A41666666667D312341666666667A425A419A999999E33123416666666678425A419A999999F2312341000000E077425A4166666666043223419A9999D977425A419A9999997E322341CDCCCC2C75425A41CDCCCCCC27332341333333B371425A416666666694332341CDCCCC4C6F425A419A999999B1332341333333936E425A4133333333B0332341333333936D425A4166666666AC332341666666C66A425A4166666666A73323410000008067425A41CDCCCCCC913323410000006054425A413333333372332341666666263D425A4100000000703323419A9999B93B425A41CDCCCCCC66332341666666E63B425A413333333365332341333333F33B425A410000000063332341000000003C425A41CDCCCCCCD43223419A9999B93E425A4100000000A7322341000000803F425A419A99999999322341333333D33F425A419A99999969322341CDCCCCEC40425A41333333334D3223416666668641425A4133333333EB3123413333339343425A419A999999653123413333339346425A41CDCCCCCC5C3123413333339343425A419A9999991E3123419A99993945425A41CDCCCCCC21312341000000E047425A4133333333D2302341CDCCCC6C49425A4166666666CE3023416666664646425A4133333333893023419A9999D947425A41666666668B302341666666C64A425A41000000005A302341CDCCCCCC4B425A419A999999233023419A9999194D425A4133333333C02F23419A9999F94E425A419A999999742F23416666668650425A4166666666552F23410000000051425A4166666666272F2341000000E051425A4133333333072F23410000008052425A41	01060000206A080000010000000103000000010000001400000033333333072F23410000008052425A41CDCCCCCC4A2F2341CDCCCC6C85425A41CDCCCCCC652F23416666664685425A41666666667D312341666666667A425A4166666666043223419A9999D977425A419A999999B1332341333333936E425A41CDCCCCCC913323410000006054425A4100000000703323419A9999B93B425A4100000000A7322341000000803F425A419A999999653123413333339346425A41CDCCCCCC5C3123413333339343425A419A9999991E3123419A99993945425A41CDCCCCCC21312341000000E047425A4133333333D2302341CDCCCC6C49425A4166666666CE3023416666664646425A4133333333893023419A9999D947425A41666666668B302341666666C64A425A419A999999233023419A9999194D425A4133333333072F23410000008052425A4133333333072F23410000008052425A41	01010000206A08000054BD5320593123419A9999395D425A41	951270120	H	Chat Perché Nord	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000001C000000333333331E3F23410000006004425A4166666666343F23410000006013425A41000000004C3F23413333335328425A41666666665F412341000000001D425A413333333397442341333333F30B425A416666666651452341000000E00A425A41CDCCCCCC82452341666666260B425A41666666667C4523419A9999D907425A4166666666504523416666664603425A41CDCCCCCC31452341666666C6F9415A41333333330C452341666666E6F1415A4133333333C344234166666686DD415A419A999999E9442341CDCCCC2CD2415A41000000003D45234133333313BF415A41666666666245234166666626B2415A419A999999DD442341CDCCCC6CAD415A419A9999998444234100000060AC415A41333333331344234100000020AD415A41333333339C43234133333353B2415A4166666666F6402341000000C0D3415A41000000008940234100000040DB415A41000000006B4023419A999999E0415A413333333356402341CDCCCC6CE0415A4100000000054023419A9999D9E6415A419A999999C43F2341666666C6EF415A4133333333313F23419A999999FF415A41333333331E3F23410000006004425A41333333331E3F23410000006004425A41	01010000206A080000AF06CF116D422341CCCCCCECEA415A41	951270112	H	Justice-Heuruelles	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000002100000066666666B0382341CDCCCC0C08425A41CDCCCCCC703A2341CDCCCC4C30425A419A999999D83A23413333339336425A419A999999DB3A2341666666A63D425A41666666660B3B23419A99993943425A41333333333B3B2341CDCCCC4C43425A419A999999623B23410000004040425A4133333333723B23416666662637425A4166666666873B23410000004039425A419A999999F73B23416666664639425A41000000004C3F23413333335328425A4166666666343F23410000006013425A41333333331E3F23410000006004425A4133333333313F23419A999999FF415A419A999999C43F2341666666C6EF415A4100000000054023419A9999D9E6415A413333333356402341CDCCCC6CE0415A41000000003640234100000040DA415A4133333333A53F2341CDCCCC2CDF415A41CDCCCCCC363F234100000020E2415A41CDCCCCCC363E2341CDCCCCECE4415A4133333333BC3D2341000000E0E4415A41CDCCCCCCFB3C23419A9999B9E3415A419A999999A43C234166666626E4415A4133333333263C2341CDCCCCECE5415A4166666666123C234100000060E1415A4166666666A83B234100000020E3415A41CDCCCCCC293B2341CDCCCCECDE415A4100000000CF39234100000080D2415A41CDCCCCCCBC3923419A999999DC415A4133333333A73923419A9999F9DC415A4166666666B0382341CDCCCC0C08425A4166666666B0382341CDCCCC0C08425A41	01010000206A0800008800FE44FB3B23419A9999290B425A41	951270113	H	La Sébille	9512701	95127	95	11	0
01060000206A08000001000000010300000001000000590000006666666673322341666666860E425A419A999999E03223419A99997918425A41333333332E332341CDCCCC8C1F425A410000000039332341000000A020425A419A9999994E3323416666664623425A410000000017342341666666C61E425A41CDCCCCCCB0342341000000C01B425A419A999999DB342341333333F31A425A41CDCCCCCCA13523419A99991917425A419A9999993E362341CDCCCC0C14425A419A999999643623413333335313425A41333333337B362341333333530F425A4133333333CF3623413333337300425A4100000000F0362341000000A0FA415A41CDCCCCCC34372341CDCCCCECED415A419A99999951372341000000A0E8415A4100000000FA372341333333B3F7415A4100000000FD3723419A9999F9F7415A410000000006382341333333D3F8415A413333333311382341CDCCCCECF9415A4166666666B0382341CDCCCC0C08425A4166666666D1382341CDCCCC2C02425A41666666660839234100000060F8415A41666666662A39234100000060F2415A413333333346392341000000A0ED415A413333333384392341000000E0E2415A41333333338C392341CDCCCC8CE1415A416666666694392341CDCCCC2CE0415A4133333333A73923419A9999F9DC415A4133333333B439234166666646DC415A41CDCCCCCCBC3923419A999999DC415A4100000000C039234166666626D9415A4133333333C439234133333353D7415A4100000000CF39234100000080D2415A4133333333E539234100000060D3415A41CDCCCCCC293B2341CDCCCCECDE415A4100000000443B2341CDCCCCCCDF415A41333333335C3B23419A999999E0415A4166666666A83B234100000020E3415A4166666666F43B2341666666E6E1415A41CDCCCCCCCA3B234100000000DF415A4166666666AA3B234133333313DD415A4166666666913B23419A999959DB415A41CDCCCCCC413B234133333353D5415A41CDCCCCCC973A234133333313C8415A41666666665F3A2341000000E0C3415A41CDCCCCCCD7392341CDCCCCACBA415A41CDCCCCCC9139234100000020B6415A41CDCCCCCC5339234133333353B1415A41333333332C39234100000040AE415A41CDCCCCCC0239234166666666AA415A419A999999E6382341333333B3A6415A4100000000D7382341CDCCCC2CA6415A41CDCCCCCCCB382341CDCCCCCCA5415A41333333333738234100000060A2415A419A9999990D382341CDCCCC0CA1415A4100000000FD37234166666686A0415A4166666666F937234133333353A0415A419A999999C93723419A9999399C415A4100000000AF3723413333339399415A4133333333A9372341333333939A415A4100000000A0372341CDCCCC2C9C415A4166666666FD36234133333313B8415A4166666666EB3623419A999919BB415A4166666666AA36234166666626C6415A419A9999999636234166666686C9415A41333333336D3623419A9999F9CF415A41333333335D3623419A999979D2415A41333333330236234133333353CA415A41666666669435234100000080C0415A419A999999373523419A999939B8415A4100000000D234234100000020AF415A419A999999BA342341CDCCCCCCAC415A4166666666B63423419A999959AD415A41000000009F34234100000060AE415A416666666686342341333333B3AD415A41CDCCCCCC58342341CDCCCC4CB7415A41000000003834234133333313BD415A4166666666F1332341CDCCCC6CC9415A41CDCCCCCCC533234100000020D1415A4100000000BF33234100000040D2415A4166666666B933234133333333D3415A4133333333B6332341000000C0D3415A419A9999996B33234100000040E1415A41666666664B332341CDCCCC0CE7415A4166666666453323419A999919E8415A419A9999990F332341333333D3F1415A419A999999B53223413333335302425A416666666673322341666666860E425A41	01060000206A080000010000000103000000010000001C0000006666666673322341666666860E425A41333333332E332341CDCCCC8C1F425A419A9999994E3323416666664623425A410000000017342341666666C61E425A419A999999643623413333335313425A419A99999951372341000000A0E8415A4166666666B0382341CDCCCC0C08425A4133333333A73923419A9999F9DC415A41CDCCCCCCBC3923419A999999DC415A4100000000CF39234100000080D2415A41CDCCCCCC293B2341CDCCCCECDE415A4166666666A83B234100000020E3415A4166666666F43B2341666666E6E1415A4166666666913B23419A999959DB415A41666666665F3A2341000000E0C3415A41CDCCCCCC9139234100000020B6415A41333333332C39234100000040AE415A419A999999E6382341333333B3A6415A4166666666F937234133333353A0415A4100000000AF3723413333339399415A419A9999999636234166666686C9415A41333333335D3623419A999979D2415A419A999999BA342341CDCCCCCCAC415A416666666686342341333333B3AD415A41CDCCCCCC58342341CDCCCC4CB7415A4133333333B6332341000000C0D3415A416666666673322341666666860E425A416666666673322341666666860E425A41	01010000206A080000809B625E8F36234100000000DE415A41	951270114	H	Les Terrasses-Axe Majeur-Lauterne	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000000E0000009A999999643623413333335313425A4133333333A83623410000000044425A4100000000CB362341333333B35E425A41333333330C372341666666A65D425A4166666666663823419A99997956425A41CDCCCCCC263B23410000004048425A41CDCCCCCC1F3B2341CDCCCC8C43425A4133333333EC3A23413333333341425A419A999999DB3A2341666666A63D425A419A999999D83A23413333339336425A41CDCCCCCC703A2341CDCCCC4C30425A419A99999951372341000000A0E8415A419A999999643623413333335313425A419A999999643623413333335313425A41	01010000206A080000742EF0C4213823410000009021425A41	951270115	H	Les Genottes	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000001A00000000000000CB362341333333B35E425A4100000000ED3623413333333378425A410000000036372341000000408D425A41333333338E3B23419A99997976425A419A999999E63B2341000000408F425A4133333333213C2341000000E09D425A41CDCCCCCC5E3C2341CDCCCC2C9F425A4166666666793C23419A9999B9A5425A4166666666DD3C23419A9999B9A2425A4133333333E73C2341000000809D425A419A999999533D2341666666467A425A419A999999C43D23419A9999395C425A41CDCCCCCC403E2341000000C03E425A41CDCCCCCC483E23419A9999393E425A41CDCCCCCC643F23410000006039425A41000000004C3F23413333335328425A419A999999F73B23416666664639425A4166666666873B23410000004039425A4133333333723B23416666662637425A419A999999623B23410000004040425A41CDCCCCCC1F3B2341CDCCCC8C43425A41CDCCCCCC263B23410000004048425A4166666666663823419A99997956425A41333333330C372341666666A65D425A4100000000CB362341333333B35E425A4100000000CB362341333333B35E425A41	01010000206A0800005847AB62303A2341000000106E425A41	951270116	H	Verger-Belle Épine	9512701	95127	95	11	0
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	01060000206A080000010000000103000000010000002700000033333333B62F2341333333F3E6425A41CDCCCCCCF32F2341333333F3F8425A41CDCCCCCC253023410000002002435A41CDCCCCCC89302341CDCCCC2C0E435A41CDCCCCCCAA312341333333F325435A4133333333D6312341666666661D435A41666666661B3223410000008016435A4100000000733223410000004012435A419A99999987332341CDCCCC0C10435A413333333359342341000000A00C435A4166666666B0342341333333B30C435A4166666666013723416666662607435A41CDCCCCCC65372341333333F305435A41CDCCCCCCBB372341CDCCCCEC03435A4166666666493823419A999939FE425A419A999999E63923419A999939E7425A41CDCCCCCC983A234100000060E1425A419A999999F73A2341CDCCCCCCDF425A41000000002D3C2341666666E6DD425A41000000004E3C234133333313D4425A41333333333C3C23419A999959B4425A41CDCCCCCC193C234133333333AE425A4133333333523C23419A999919AE425A41666666666E3C2341333333D3AA425A4166666666793C23419A9999B9A5425A41CDCCCCCC5E3C2341CDCCCC2C9F425A4133333333213C2341000000E09D425A419A999999E63B2341000000408F425A41333333338E3B23419A99997976425A410000000036372341000000408D425A4100000000ED3623413333333378425A410000000040342341000000E08B425A41CDCCCCCCDD332341666666668E425A41CDCCCCCC29342341CDCCCC8CC9425A4166666666E933234166666606D0425A416666666639302341333333D3E3425A419A999999FB2F234166666646E3425A4133333333B62F2341333333F3E6425A4133333333B62F2341333333F3E6425A41	01010000206A080000002AF70227382341333333B3CD425A41	951270117	D	Petit Albi	9512701	95127	95	11	1
01060000206A08000001000000010300000001000000310000009A9999994E3323416666664623425A419A999999553323413333337326425A419A9999996D332341666666E639425A41000000006F332341333333F33A425A4100000000703323419A9999B93B425A413333333372332341666666263D425A41CDCCCCCC913323410000006054425A4166666666A73323410000008067425A4166666666AC332341666666C66A425A4133333333B0332341333333936D425A419A999999B1332341333333936E425A4166666666B3332341000000E06F425A4100000000B5332341CDCCCCCC70425A41CDCCCCCCB63323416666662672425A41CDCCCCCCBF3323410000008078425A4133333333C0332341333333B378425A41CDCCCCCCDD332341666666668E425A410000000040342341000000E08B425A4100000000A03423419A99991989425A4100000000E63423410000002087425A419A99999911352341000000E085425A419A99999981352341CDCCCCAC82425A41CDCCCCCC27362341333333F37D425A4100000000ED3623413333333378425A4133333333EC362341666666A677425A4100000000D53623416666662666425A4133333333D33623419A9999F964425A4100000000D1362341CDCCCC2C63425A4133333333CD3623413333335360425A4100000000CB362341333333B35E425A419A999999CA362341666666665E425A4100000000CA362341333333F35D425A419A999999C7362341000000005C425A419A999999C6362341333333535B425A4133333333A83623410000000044425A419A999999903623416666662633425A419A9999998B362341666666662F425A419A99999989362341333333132E425A41CDCCCCCC85362341333333532B425A4100000000833623413333333329425A4100000000813623419A9999D927425A41333333337D3623416666662625425A419A999999643623413333335313425A419A9999993E362341CDCCCC0C14